import * as cloudwatch from "../../aws-cloudwatch";
import { IVpcEndpoint } from "../../aws-ec2";
import * as iam from "../../aws-iam";
import { IResource as IResourceBase, Resource } from "../../core";
import { Construct } from 'constructs';
import { ApiDefinition } from './api-definition';
import { ApiKeyOptions, IApiKey } from './api-key';
import { CfnRestApi } from './apigateway.generated';
import { Deployment } from './deployment';
import { DomainName, DomainNameOptions } from './domain-name';
import { GatewayResponse, GatewayResponseOptions } from './gateway-response';
import { Method } from './method';
import { Model, ModelOptions } from './model';
import { RequestValidator, RequestValidatorOptions } from './requestvalidator';
import { IResource, ResourceOptions } from './resource';
import { Stage, StageOptions } from './stage';
import { UsagePlan, UsagePlanProps } from './usage-plan';
/**
 * @experimental
 */
export interface IRestApi extends IResourceBase {
    /**
     * (experimental) The ID of this API Gateway RestApi.
     *
     * @experimental
     * @attribute true
     */
    readonly restApiId: string;
    /**
     * (experimental) The resource ID of the root resource.
     *
     * @experimental
     * @attribute true
     */
    readonly restApiRootResourceId: string;
    /**
     * (experimental) API Gateway deployment that represents the latest changes of the API.
     *
     * This resource will be automatically updated every time the REST API model changes.
     * `undefined` when no deployment is configured.
     *
     * @experimental
     */
    readonly latestDeployment?: Deployment;
    /**
     * (experimental) API Gateway stage that points to the latest deployment (if defined).
     *
     * @experimental
     */
    deploymentStage: Stage;
    /**
     * (experimental) Represents the root resource ("/") of this API. Use it to define the API model:.
     *
     * api.root.addMethod('ANY', redirectToHomePage); // "ANY /"
     *     api.root.addResource('friends').addMethod('GET', getFriendsHandler); // "GET /friends"
     *
     * @experimental
     */
    readonly root: IResource;
    /**
     * (experimental) Gets the "execute-api" ARN.
     *
     * @param method The method (default `*`).
     * @param path The resource path.
     * @param stage The stage (default `*`).
     * @returns The "execute-api" ARN.
     * @default "*" returns the execute API ARN for all methods/resources in
     * this API.
     * @experimental
     */
    arnForExecuteApi(method?: string, path?: string, stage?: string): string;
}
/**
 * (experimental) Represents the props that all Rest APIs share.
 *
 * @experimental
 */
export interface RestApiBaseProps {
    /**
     * (experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
     *
     * Since API Gateway deployments are immutable, When this option is enabled
     * (by default), an AWS::ApiGateway::Deployment resource will automatically
     * created with a logical ID that hashes the API model (methods, resources
     * and options). This means that when the model changes, the logical ID of
     * this CloudFormation resource will change, and a new deployment will be
     * created.
     *
     * If this is set, `latestDeployment` will refer to the `Deployment` object
     * and `deploymentStage` will refer to a `Stage` that points to this
     * deployment. To customize the stage options, use the `deployOptions`
     * property.
     *
     * A CloudFormation Output will also be defined with the root URL endpoint
     * of this REST API.
     *
     * @default true
     * @experimental
     */
    readonly deploy?: boolean;
    /**
     * (experimental) Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
     *
     * If `deploy` is disabled,
     * this value cannot be set.
     *
     * @default - Based on defaults of `StageOptions`.
     * @experimental
     */
    readonly deployOptions?: StageOptions;
    /**
     * (experimental) Retains old deployment resources when the API changes.
     *
     * This allows
     * manually reverting stages to point to old deployments via the AWS
     * Console.
     *
     * @default false
     * @experimental
     */
    readonly retainDeployments?: boolean;
    /**
     * (experimental) A name for the API Gateway RestApi resource.
     *
     * @default - ID of the RestApi construct.
     * @experimental
     */
    readonly restApiName?: string;
    /**
     * (experimental) Custom header parameters for the request.
     *
     * @default - No parameters.
     * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
     * @experimental
     */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
     * (experimental) A policy document that contains the permissions for this RestApi.
     *
     * @default - No policy.
     * @experimental
     */
    readonly policy?: iam.PolicyDocument;
    /**
     * (experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
     *
     * @default false
     * @experimental
     */
    readonly failOnWarnings?: boolean;
    /**
     * (experimental) Configure a custom domain name and map it to this API.
     *
     * @default - no domain name is defined, use `addDomainName` or directly define a `DomainName`.
     * @experimental
     */
    readonly domainName?: DomainNameOptions;
    /**
     * (experimental) Automatically configure an AWS CloudWatch role for API Gateway.
     *
     * @default true
     * @experimental
     */
    readonly cloudWatchRole?: boolean;
    /**
     * (experimental) Export name for the CfnOutput containing the API endpoint.
     *
     * @default - when no export name is given, output will be created without export
     * @experimental
     */
    readonly endpointExportName?: string;
    /**
     * (experimental) A list of the endpoint types of the API.
     *
     * Use this property when creating
     * an API.
     *
     * @default EndpointType.EDGE
     * @experimental
     */
    readonly endpointTypes?: EndpointType[];
}
/**
 * (deprecated) Represents the props that all Rest APIs share.
 *
 * @deprecated - superseded by `RestApiBaseProps`
 */
export interface RestApiOptions extends RestApiBaseProps, ResourceOptions {
}
/**
 * (experimental) Props to create a new instance of RestApi.
 *
 * @experimental
 */
export interface RestApiProps extends RestApiOptions {
    /**
     * (experimental) A description of the purpose of this API Gateway RestApi resource.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream".
     *
     * @default - RestApi supports only UTF-8-encoded text payloads.
     * @experimental
     */
    readonly binaryMediaTypes?: string[];
    /**
     * (experimental) A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API.
     *
     * When compression is enabled, compression or
     * decompression is not applied on the payload if the payload size is
     * smaller than this value. Setting it to zero allows compression for any
     * payload size.
     *
     * @default - Compression is disabled.
     * @experimental
     */
    readonly minimumCompressionSize?: number;
    /**
     * (experimental) The ID of the API Gateway RestApi resource that you want to clone.
     *
     * @default - None.
     * @experimental
     */
    readonly cloneFrom?: IRestApi;
    /**
     * (experimental) The source of the API key for metering requests according to a usage plan.
     *
     * @default - Metering is disabled.
     * @experimental
     */
    readonly apiKeySourceType?: ApiKeySourceType;
    /**
     * (experimental) The EndpointConfiguration property type specifies the endpoint types of a REST API.
     *
     * @default EndpointType.EDGE
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
     * @experimental
     */
    readonly endpointConfiguration?: EndpointConfiguration;
}
/**
 * (experimental) Props to instantiate a new SpecRestApi.
 *
 * @experimental
 */
export interface SpecRestApiProps extends RestApiBaseProps {
    /**
     * (experimental) An OpenAPI definition compatible with API Gateway.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html
     * @experimental
     */
    readonly apiDefinition: ApiDefinition;
}
/**
 * (experimental) Base implementation that are common to various implementations of IRestApi.
 *
 * @experimental
 */
export declare abstract class RestApiBase extends Resource implements IRestApi {
    /**
     * Checks if the given object is an instance of RestApiBase.
     * @internal
     */
    static _isRestApiBase(x: any): x is RestApiBase;
    /**
     * (experimental) API Gateway deployment that represents the latest changes of the API.
     *
     * This resource will be automatically updated every time the REST API model changes.
     * This will be undefined if `deploy` is false.
     *
     * @experimental
     */
    get latestDeployment(): Deployment | undefined;
    /**
     * (experimental) The first domain name mapped to this API, if defined through the `domainName` configuration prop, or added via `addDomainName`.
     *
     * @experimental
     */
    get domainName(): DomainName | undefined;
    /**
     * (experimental) The ID of this API Gateway RestApi.
     *
     * @experimental
     */
    abstract readonly restApiId: string;
    /**
     * (experimental) The resource ID of the root resource.
     *
     * @experimental
     * @attribute true
     */
    abstract readonly restApiRootResourceId: string;
    /**
     * (experimental) Represents the root resource of this API endpoint ('/').
     *
     * Resources and Methods are added to this resource.
     *
     * @experimental
     */
    abstract readonly root: IResource;
    /**
     * (experimental) API Gateway stage that points to the latest deployment (if defined).
     *
     * If `deploy` is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     *
     * @experimental
     */
    deploymentStage: Stage;
    /**
     * (experimental) A human friendly name for this Rest API.
     *
     * Note that this is different from `restApiId`.
     *
     * @experimental
     */
    readonly restApiName: string;
    private _latestDeployment?;
    private _domainName?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: RestApiBaseProps);
    /**
     * (experimental) Returns the URL for an HTTP path.
     *
     * Fails if `deploymentStage` is not set either by `deploy` or explicitly.
     *
     * @experimental
     */
    urlForPath(path?: string): string;
    /**
     * (experimental) Defines an API Gateway domain name and maps it to this API.
     *
     * @param id The construct id.
     * @param options custom domain options.
     * @experimental
     */
    addDomainName(id: string, options: DomainNameOptions): DomainName;
    /**
     * (experimental) Adds a usage plan.
     *
     * @experimental
     */
    addUsagePlan(id: string, props?: UsagePlanProps): UsagePlan;
    /**
     * (experimental) Gets the "execute-api" ARN.
     *
     * @experimental
     */
    arnForExecuteApi(method?: string, path?: string, stage?: string): string;
    /**
     * (experimental) Adds a new gateway response.
     *
     * @experimental
     */
    addGatewayResponse(id: string, options: GatewayResponseOptions): GatewayResponse;
    /**
     * (experimental) Add an ApiKey.
     *
     * @experimental
     */
    addApiKey(id: string, options?: ApiKeyOptions): IApiKey;
    /**
     * (experimental) Returns the given named metric for this API.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of client-side errors captured in a given period.
     *
     * Default: sum over 5 minutes
     *
     * @experimental
     */
    metricClientError(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of server-side errors captured in a given period.
     *
     * Default: sum over 5 minutes
     *
     * @experimental
     */
    metricServerError(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of requests served from the API cache in a given period.
     *
     * Default: sum over 5 minutes
     *
     * @experimental
     */
    metricCacheHitCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of requests served from the backend in a given period, when API caching is enabled.
     *
     * Default: sum over 5 minutes
     *
     * @experimental
     */
    metricCacheMissCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the total number API requests in a given period.
     *
     * Default: sample count over 5 minutes
     *
     * @experimental
     */
    metricCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     *
     * Default: average over 5 minutes.
     *
     * @experimental
     */
    metricIntegrationLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The time between when API Gateway receives a request from a client and when it returns a response to the client.
     *
     * The latency includes the integration latency and other API Gateway overhead.
     *
     * Default: average over 5 minutes.
     *
     * @experimental
     */
    metricLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Internal API used by `Method` to keep an inventory of methods at the API
     * level for validation purposes.
     *
     * @internal
     */
    _attachMethod(method: Method): void;
    /**
     * Associates a Deployment resource with this REST API.
     *
     * @internal
     */
    _attachDeployment(deployment: Deployment): void;
    /**
     * @internal
     */
    protected _configureCloudWatchRole(apiResource: CfnRestApi): void;
    /**
     * @deprecated This method will be made internal. No replacement
     */
    protected configureCloudWatchRole(apiResource: CfnRestApi): void;
    /**
     * @deprecated This method will be made internal. No replacement
     */
    protected configureDeployment(props: RestApiBaseProps): void;
    /**
     * @internal
     */
    protected _configureDeployment(props: RestApiBaseProps): void;
    /**
     * @internal
     */
    protected _configureEndpoints(props: RestApiProps): CfnRestApi.EndpointConfigurationProperty | undefined;
    private cannedMetric;
}
/**
 * (experimental) Represents a REST API in Amazon API Gateway, created with an OpenAPI specification.
 *
 * Some properties normally accessible on @see {@link RestApi} - such as the description -
 * must be declared in the specification. All Resources and Methods need to be defined as
 * part of the OpenAPI specification file, and cannot be added via the CDK.
 *
 * By default, the API will automatically be deployed and accessible from a
 * public endpoint.
 *
 * @experimental
 * @resource AWS::ApiGateway::RestApi
 */
export declare class SpecRestApi extends RestApiBase {
    /**
     * (experimental) The ID of this API Gateway RestApi.
     *
     * @experimental
     */
    readonly restApiId: string;
    /**
     * (experimental) The resource ID of the root resource.
     *
     * @experimental
     * @attribute true
     */
    readonly restApiRootResourceId: string;
    /**
     * (experimental) Represents the root resource of this API endpoint ('/').
     *
     * Resources and Methods are added to this resource.
     *
     * @experimental
     */
    readonly root: IResource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SpecRestApiProps);
}
/**
 * (experimental) Attributes that can be specified when importing a RestApi.
 *
 * @experimental
 */
export interface RestApiAttributes {
    /**
     * (experimental) The ID of the API Gateway RestApi.
     *
     * @experimental
     */
    readonly restApiId: string;
    /**
     * (experimental) The resource ID of the root resource.
     *
     * @experimental
     */
    readonly rootResourceId: string;
}
/**
 * (experimental) Represents a REST API in Amazon API Gateway.
 *
 * Use `addResource` and `addMethod` to configure the API model.
 *
 * By default, the API will automatically be deployed and accessible from a
 * public endpoint.
 *
 * @experimental
 */
export declare class RestApi extends RestApiBase {
    /**
     * (experimental) Import an existing RestApi.
     *
     * @experimental
     */
    static fromRestApiId(scope: Construct, id: string, restApiId: string): IRestApi;
    /**
     * (experimental) Import an existing RestApi that can be configured with additional Methods and Resources.
     *
     * @experimental
     */
    static fromRestApiAttributes(scope: Construct, id: string, attrs: RestApiAttributes): IRestApi;
    /**
     * (experimental) The ID of this API Gateway RestApi.
     *
     * @experimental
     */
    readonly restApiId: string;
    /**
     * (experimental) Represents the root resource of this API endpoint ('/').
     *
     * Resources and Methods are added to this resource.
     *
     * @experimental
     */
    readonly root: IResource;
    /**
     * (experimental) The resource ID of the root resource.
     *
     * @experimental
     */
    readonly restApiRootResourceId: string;
    /**
     * (experimental) The list of methods bound to this RestApi.
     *
     * @experimental
     */
    readonly methods: Method[];
    /**
     * This list of deployments bound to this RestApi
     */
    private readonly deployments;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: RestApiProps);
    /**
     * (experimental) The deployed root URL of this REST API.
     *
     * @experimental
     */
    get url(): string;
    /**
     * (experimental) Adds a new model.
     *
     * @experimental
     */
    addModel(id: string, props: ModelOptions): Model;
    /**
     * (experimental) Adds a new request validator.
     *
     * @experimental
     */
    addRequestValidator(id: string, props: RequestValidatorOptions): RequestValidator;
    /**
     * Internal API used by `Method` to keep an inventory of methods at the API
     * level for validation purposes.
     *
     * @internal
     */
    _attachMethod(method: Method): void;
    /**
     * Attaches a deployment to this REST API.
     *
     * @internal
     */
    _attachDeployment(deployment: Deployment): void;
    /**
     * (experimental) Performs validation of the REST API.
     *
     * @experimental
     */
    protected validate(): string[];
}
/**
 * (experimental) The endpoint configuration of a REST API, including VPCs and endpoint types.
 *
 * EndpointConfiguration is a property of the AWS::ApiGateway::RestApi resource.
 *
 * @experimental
 */
export interface EndpointConfiguration {
    /**
     * (experimental) A list of endpoint types of an API or its custom domain name.
     *
     * @default EndpointType.EDGE
     * @experimental
     */
    readonly types: EndpointType[];
    /**
     * (experimental) A list of VPC Endpoints against which to create Route53 ALIASes.
     *
     * @default - no ALIASes are created for the endpoint.
     * @experimental
     */
    readonly vpcEndpoints?: IVpcEndpoint[];
}
/**
 * @experimental
 */
export declare enum ApiKeySourceType {
    /**
     * (experimental) To read the API key from the `X-API-Key` header of a request.
     *
     * @experimental
     */
    HEADER = "HEADER",
    /**
     * (experimental) To read the API key from the `UsageIdentifierKey` from a custom authorizer.
     *
     * @experimental
     */
    AUTHORIZER = "AUTHORIZER"
}
/**
 * @experimental
 */
export declare enum EndpointType {
    /**
     * (experimental) For an edge-optimized API and its custom domain name.
     *
     * @experimental
     */
    EDGE = "EDGE",
    /**
     * (experimental) For a regional API and its custom domain name.
     *
     * @experimental
     */
    REGIONAL = "REGIONAL",
    /**
     * (experimental) For a private API and its custom domain name.
     *
     * @experimental
     */
    PRIVATE = "PRIVATE"
}
