import { IResource as IResourceBase, Resource as ResourceConstruct } from "../../core";
import { Construct } from 'constructs';
import { CorsOptions } from './cors';
import { Integration } from './integration';
import { Method, MethodOptions } from './method';
import { IRestApi, RestApi } from './restapi';
/**
 * @experimental
 */
export interface IResource extends IResourceBase {
    /**
     * (experimental) The parent of this resource or undefined for the root resource.
     *
     * @experimental
     */
    readonly parentResource?: IResource;
    /**
     * (deprecated) The rest API that this resource is part of.
     *
     * @deprecated - Throws an error if this Resource is not associated with an instance of `RestApi`. Use `api` instead.
     */
    readonly restApi: RestApi;
    /**
     * (experimental) The rest API that this resource is part of.
     *
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     *
     * @experimental
     */
    readonly api: IRestApi;
    /**
     * (experimental) The ID of the resource.
     *
     * @experimental
     * @attribute true
     */
    readonly resourceId: string;
    /**
     * (experimental) The full path of this resource.
     *
     * @experimental
     */
    readonly path: string;
    /**
     * (experimental) An integration to use as a default for all methods created within this API unless an integration is specified.
     *
     * @experimental
     */
    readonly defaultIntegration?: Integration;
    /**
     * (experimental) Method options to use as a default for all methods created within this API unless custom options are specified.
     *
     * @experimental
     */
    readonly defaultMethodOptions?: MethodOptions;
    /**
     * (experimental) Default options for CORS preflight OPTIONS method.
     *
     * @experimental
     */
    readonly defaultCorsPreflightOptions?: CorsOptions;
    /**
     * (experimental) Gets or create all resources leading up to the specified path.
     *
     * - Path may only start with "/" if this method is called on the root resource.
     * - All resources are created using default options.
     *
     * @param path The relative path.
     * @returns a new or existing resource.
     * @experimental
     */
    resourceForPath(path: string): Resource;
    /**
     * (experimental) Defines a new child resource where this resource is the parent.
     *
     * @param pathPart The path part for the child resource.
     * @param options Resource options.
     * @returns A Resource object
     * @experimental
     */
    addResource(pathPart: string, options?: ResourceOptions): Resource;
    /**
     * (experimental) Retrieves a child resource by path part.
     *
     * @param pathPart The path part of the child resource.
     * @returns the child resource or undefined if not found
     * @experimental
     */
    getResource(pathPart: string): IResource | undefined;
    /**
     * (experimental) Adds a greedy proxy resource ("{proxy+}") and an ANY method to this route.
     *
     * @param options Default integration and method options.
     * @experimental
     */
    addProxy(options?: ProxyResourceOptions): ProxyResource;
    /**
     * (experimental) Defines a new method for this resource.
     *
     * @param httpMethod The HTTP method.
     * @param target The target backend integration for this method.
     * @param options Method options, such as authentication.
     * @returns The newly created `Method` object.
     * @experimental
     */
    addMethod(httpMethod: string, target?: Integration, options?: MethodOptions): Method;
    /**
     * (experimental) Adds an OPTIONS method to this resource which responds to Cross-Origin Resource Sharing (CORS) preflight requests.
     *
     * Cross-Origin Resource Sharing (CORS) is a mechanism that uses additional
     * HTTP headers to tell browsers to give a web application running at one
     * origin, access to selected resources from a different origin. A web
     * application executes a cross-origin HTTP request when it requests a
     * resource that has a different origin (domain, protocol, or port) from its
     * own.
     *
     * @param options CORS options.
     * @returns a `Method` object
     * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
     * @experimental
     */
    addCorsPreflight(options: CorsOptions): Method;
}
/**
 * @experimental
 */
export interface ResourceOptions {
    /**
     * (experimental) An integration to use as a default for all methods created within this API unless an integration is specified.
     *
     * @default - Inherited from parent.
     * @experimental
     */
    readonly defaultIntegration?: Integration;
    /**
     * (experimental) Method options to use as a default for all methods created within this API unless custom options are specified.
     *
     * @default - Inherited from parent.
     * @experimental
     */
    readonly defaultMethodOptions?: MethodOptions;
    /**
     * (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources.
     *
     * You can add CORS at the resource-level using `addCorsPreflight`.
     *
     * @default - CORS is disabled
     * @experimental
     */
    readonly defaultCorsPreflightOptions?: CorsOptions;
}
/**
 * @experimental
 */
export interface ResourceProps extends ResourceOptions {
    /**
     * (experimental) The parent resource of this resource.
     *
     * You can either pass another
     * `Resource` object or a `RestApi` object here.
     *
     * @experimental
     */
    readonly parent: IResource;
    /**
     * (experimental) A path name for the resource.
     *
     * @experimental
     */
    readonly pathPart: string;
}
/**
 * @experimental
 */
export declare abstract class ResourceBase extends ResourceConstruct implements IResource {
    /**
     * (experimental) The parent of this resource or undefined for the root resource.
     *
     * @experimental
     */
    abstract readonly parentResource?: IResource;
    /**
     * (deprecated) The rest API that this resource is part of.
     *
     * @deprecated -  Throws an error if this Resource is not associated with an instance of `RestApi`. Use `api` instead.
     */
    abstract readonly restApi: RestApi;
    /**
     * (experimental) The rest API that this resource is part of.
     *
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     *
     * @experimental
     */
    abstract readonly api: IRestApi;
    /**
     * (experimental) The ID of the resource.
     *
     * @experimental
     */
    abstract readonly resourceId: string;
    /**
     * (experimental) The full path of this resource.
     *
     * @experimental
     */
    abstract readonly path: string;
    /**
     * (experimental) An integration to use as a default for all methods created within this API unless an integration is specified.
     *
     * @experimental
     */
    abstract readonly defaultIntegration?: Integration;
    /**
     * (experimental) Method options to use as a default for all methods created within this API unless custom options are specified.
     *
     * @experimental
     */
    abstract readonly defaultMethodOptions?: MethodOptions;
    /**
     * (experimental) Default options for CORS preflight OPTIONS method.
     *
     * @experimental
     */
    abstract readonly defaultCorsPreflightOptions?: CorsOptions;
    private readonly children;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string);
    /**
     * (experimental) Defines a new child resource where this resource is the parent.
     *
     * @experimental
     */
    addResource(pathPart: string, options?: ResourceOptions): Resource;
    /**
     * (experimental) Defines a new method for this resource.
     *
     * @experimental
     */
    addMethod(httpMethod: string, integration?: Integration, options?: MethodOptions): Method;
    /**
     * (experimental) Adds a greedy proxy resource ("{proxy+}") and an ANY method to this route.
     *
     * @experimental
     */
    addProxy(options?: ProxyResourceOptions): ProxyResource;
    /**
     * (experimental) Adds an OPTIONS method to this resource which responds to Cross-Origin Resource Sharing (CORS) preflight requests.
     *
     * Cross-Origin Resource Sharing (CORS) is a mechanism that uses additional
     * HTTP headers to tell browsers to give a web application running at one
     * origin, access to selected resources from a different origin. A web
     * application executes a cross-origin HTTP request when it requests a
     * resource that has a different origin (domain, protocol, or port) from its
     * own.
     *
     * @experimental
     */
    addCorsPreflight(options: CorsOptions): Method;
    /**
     * (experimental) Retrieves a child resource by path part.
     *
     * @experimental
     */
    getResource(pathPart: string): IResource | undefined;
    /**
     * @internal
     */
    _trackChild(pathPart: string, resource: Resource): void;
    /**
     * (experimental) Gets or create all resources leading up to the specified path.
     *
     * - Path may only start with "/" if this method is called on the root resource.
     * - All resources are created using default options.
     *
     * @experimental
     */
    resourceForPath(path: string): Resource;
    /**
     * @deprecated - Throws error in some use cases that have been enabled since this deprecation notice. Use `RestApi.urlForPath()` instead.
     */
    get url(): string;
}
/**
 * (experimental) Attributes that can be specified when importing a Resource.
 *
 * @experimental
 */
export interface ResourceAttributes {
    /**
     * (experimental) The ID of the resource.
     *
     * @experimental
     */
    readonly resourceId: string;
    /**
     * (experimental) The rest API that this resource is part of.
     *
     * @experimental
     */
    readonly restApi: IRestApi;
    /**
     * (experimental) The full path of this resource.
     *
     * @experimental
     */
    readonly path: string;
}
/**
 * @experimental
 */
export declare class Resource extends ResourceBase {
    /**
     * (experimental) Import an existing resource.
     *
     * @experimental
     */
    static fromResourceAttributes(scope: Construct, id: string, attrs: ResourceAttributes): IResource;
    /**
     * (experimental) The parent of this resource or undefined for the root resource.
     *
     * @experimental
     */
    readonly parentResource?: IResource;
    /**
     * (experimental) The rest API that this resource is part of.
     *
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     *
     * @experimental
     */
    readonly api: IRestApi;
    /**
     * (experimental) The ID of the resource.
     *
     * @experimental
     */
    readonly resourceId: string;
    /**
     * (experimental) The full path of this resource.
     *
     * @experimental
     */
    readonly path: string;
    /**
     * (experimental) An integration to use as a default for all methods created within this API unless an integration is specified.
     *
     * @experimental
     */
    readonly defaultIntegration?: Integration;
    /**
     * (experimental) Method options to use as a default for all methods created within this API unless custom options are specified.
     *
     * @experimental
     */
    readonly defaultMethodOptions?: MethodOptions;
    /**
     * (experimental) Default options for CORS preflight OPTIONS method.
     *
     * @experimental
     */
    readonly defaultCorsPreflightOptions?: CorsOptions;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ResourceProps);
    /**
     * (deprecated) The RestApi associated with this Resource.
     *
     * @deprecated - Throws an error if this Resource is not associated with an instance of `RestApi`. Use `api` instead.
     */
    get restApi(): RestApi;
}
/**
 * @experimental
 */
export interface ProxyResourceOptions extends ResourceOptions {
    /**
     * (experimental) Adds an "ANY" method to this resource.
     *
     * If set to `false`, you will have to explicitly
     * add methods to this resource after it's created.
     *
     * @default true
     * @experimental
     */
    readonly anyMethod?: boolean;
}
/**
 * @experimental
 */
export interface ProxyResourceProps extends ProxyResourceOptions {
    /**
     * (experimental) The parent resource of this resource.
     *
     * You can either pass another
     * `Resource` object or a `RestApi` object here.
     *
     * @experimental
     */
    readonly parent: IResource;
}
/**
 * (experimental) Defines a {proxy+} greedy resource and an ANY method on a route.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-set-up-simple-proxy.html
 * @experimental
 */
export declare class ProxyResource extends Resource {
    /**
     * (experimental) If `props.anyMethod` is `true`, this will be the reference to the 'ANY' method associated with this proxy resource.
     *
     * @experimental
     */
    readonly anyMethod?: Method;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ProxyResourceProps);
    /**
     * (experimental) Defines a new method for this resource.
     *
     * @experimental
     */
    addMethod(httpMethod: string, integration?: Integration, options?: MethodOptions): Method;
}
