"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestValidator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * @experimental
 */
class RequestValidator extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.requestValidatorName,
        });
        const validatorProps = {
            name: this.physicalName,
            restApiId: props.restApi.restApiId,
            validateRequestBody: props.validateRequestBody,
            validateRequestParameters: props.validateRequestParameters,
        };
        const resource = new apigateway_generated_1.CfnRequestValidator(this, 'Resource', validatorProps);
        this.requestValidatorId = resource.ref;
        const deployment = (props.restApi instanceof restapi_1.RestApi) ? props.restApi.latestDeployment : undefined;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ validator: validatorProps });
        }
    }
    /**
     * @experimental
     */
    static fromRequestValidatorId(scope, id, requestValidatorId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.requestValidatorId = requestValidatorId;
            }
        }
        return new Import(scope, id);
    }
}
exports.RequestValidator = RequestValidator;
_a = JSII_RTTI_SYMBOL_1;
RequestValidator[_a] = { fqn: "monocdk.aws_apigateway.RequestValidator", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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