import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IRestApi } from './restapi';
/**
 * @experimental
 */
export interface IRequestValidator extends IResource {
    /**
     * (experimental) ID of the request validator, such as abc123.
     *
     * @experimental
     * @attribute true
     */
    readonly requestValidatorId: string;
}
/**
 * @experimental
 */
export interface RequestValidatorOptions {
    /**
     * (experimental) The name of this request validator.
     *
     * @default None
     * @experimental
     */
    readonly requestValidatorName?: string;
    /**
     * (experimental) Indicates whether to validate the request body according to the configured schema for the targeted API and method.
     *
     * @default false
     * @experimental
     */
    readonly validateRequestBody?: boolean;
    /**
     * (experimental) Indicates whether to validate request parameters.
     *
     * @default false
     * @experimental
     */
    readonly validateRequestParameters?: boolean;
}
/**
 * @experimental
 */
export interface RequestValidatorProps extends RequestValidatorOptions {
    /**
     * (experimental) The rest API that this model is part of.
     *
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     *
     * @experimental
     */
    readonly restApi: IRestApi;
}
/**
 * @experimental
 */
export declare class RequestValidator extends Resource implements IRequestValidator {
    /**
     * @experimental
     */
    static fromRequestValidatorId(scope: Construct, id: string, requestValidatorId: string): IRequestValidator;
    /**
     * (experimental) ID of the request validator, such as abc123.
     *
     * @experimental
     * @attribute true
     */
    readonly requestValidatorId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: RequestValidatorProps);
}
