import * as lambda from "../../../aws-lambda";
import { IntegrationConfig, IntegrationOptions } from '../integration';
import { Method } from '../method';
import { AwsIntegration } from './aws';
/**
 * @experimental
 */
export interface LambdaIntegrationOptions extends IntegrationOptions {
    /**
     * (experimental) Use proxy integration or normal (request/response mapping) integration.
     *
     * @default true
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-lambda-proxy-integrations.html#api-gateway-simple-proxy-for-lambda-output-format
     * @experimental
     */
    readonly proxy?: boolean;
    /**
     * (experimental) Allow invoking method from AWS Console UI (for testing purposes).
     *
     * This will add another permission to the AWS Lambda resource policy which
     * will allow the `test-invoke-stage` stage to invoke this handler. If this
     * is set to `false`, the function will only be usable from the deployment
     * endpoint.
     *
     * @default true
     * @experimental
     */
    readonly allowTestInvoke?: boolean;
}
/**
 * (experimental) Integrates an AWS Lambda function to an API Gateway method.
 *
 * @experimental
 * @example
 *
 *    const handler = new lambda.Function(this, 'MyFunction', ...);
 *    api.addMethod('GET', new LambdaIntegration(handler));
 */
export declare class LambdaIntegration extends AwsIntegration {
    private readonly handler;
    private readonly enableTest;
    /**
     * @experimental
     */
    constructor(handler: lambda.IFunction, options?: LambdaIntegrationOptions);
    /**
     * (experimental) Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.
     *
     * @experimental
     */
    bind(method: Method): IntegrationConfig;
}
