import { Integration, IntegrationConfig, IntegrationOptions } from '../integration';
import { Method } from '../method';
/**
 * @experimental
 */
export interface AwsIntegrationProps {
    /**
     * (experimental) Use AWS_PROXY integration.
     *
     * @default false
     * @experimental
     */
    readonly proxy?: boolean;
    /**
     * (experimental) The name of the integrated AWS service (e.g. `s3`).
     *
     * @experimental
     */
    readonly service: string;
    /**
     * (experimental) A designated subdomain supported by certain AWS service for fast host-name lookup.
     *
     * @experimental
     */
    readonly subdomain?: string;
    /**
     * (experimental) The path to use for path-base APIs.
     *
     * For example, for S3 GET, you can set path to `bucket/key`.
     * For lambda, you can set path to `2015-03-31/functions/${function-arn}/invocations`
     *
     * Mutually exclusive with the `action` options.
     *
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) The AWS action to perform in the integration.
     *
     * Use `actionParams` to specify key-value params for the action.
     *
     * Mutually exclusive with `path`.
     *
     * @experimental
     */
    readonly action?: string;
    /**
     * (experimental) Parameters for the action.
     *
     * `action` must be set, and `path` must be undefined.
     * The action params will be URL encoded.
     *
     * @experimental
     */
    readonly actionParameters?: {
        [key: string]: string;
    };
    /**
     * (experimental) The integration's HTTP method type.
     *
     * @default POST
     * @experimental
     */
    readonly integrationHttpMethod?: string;
    /**
     * (experimental) Integration options, such as content handling, request/response mapping, etc.
     *
     * @experimental
     */
    readonly options?: IntegrationOptions;
    /**
     * (experimental) The region of the integrated AWS service.
     *
     * @default - same region as the stack
     * @experimental
     */
    readonly region?: string;
}
/**
 * (experimental) This type of integration lets an API expose AWS service actions.
 *
 * It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 *
 * @experimental
 */
export declare class AwsIntegration extends Integration {
    private scope?;
    /**
     * @experimental
     */
    constructor(props: AwsIntegrationProps);
    /**
     * (experimental) Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.
     *
     * @experimental
     */
    bind(method: Method): IntegrationConfig;
}
