"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseType = exports.GatewayResponse = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
/**
 * (experimental) Configure the response received by clients, produced from the API Gateway backend.
 *
 * @experimental
 * @resource AWS::ApiGateway::GatewayResponse
 */
class GatewayResponse extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const gatewayResponseProps = {
            restApiId: props.restApi.restApiId,
            responseType: props.type.responseType,
            responseParameters: this.buildResponseParameters(props.responseHeaders),
            responseTemplates: props.templates,
            statusCode: props.statusCode,
        };
        const resource = new apigateway_generated_1.CfnGatewayResponse(this, 'Resource', gatewayResponseProps);
        const deployment = props.restApi.latestDeployment;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({
                gatewayResponse: {
                    ...gatewayResponseProps,
                },
            });
        }
        this.node.defaultChild = resource;
    }
    buildResponseParameters(responseHeaders) {
        if (!responseHeaders) {
            return undefined;
        }
        const responseParameters = {};
        for (const [header, value] of Object.entries(responseHeaders)) {
            responseParameters[`gatewayresponse.header.${header}`] = value;
        }
        return responseParameters;
    }
}
exports.GatewayResponse = GatewayResponse;
_a = JSII_RTTI_SYMBOL_1;
GatewayResponse[_a] = { fqn: "monocdk.aws_apigateway.GatewayResponse", version: "1.106.1" };
/**
 * (experimental) Supported types of gateway responses.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
 * @experimental
 */
class ResponseType {
    constructor(type) {
        this.responseType = type;
    }
    /**
     * (experimental) A custom response type to support future cases.
     *
     * @experimental
     */
    static of(type) {
        return new ResponseType(type.toUpperCase());
    }
}
exports.ResponseType = ResponseType;
_b = JSII_RTTI_SYMBOL_1;
ResponseType[_b] = { fqn: "monocdk.aws_apigateway.ResponseType", version: "1.106.1" };
/**
 * (experimental) The gateway response for authorization failure.
 *
 * @experimental
 */
ResponseType.ACCESS_DENIED = new ResponseType('ACCESS_DENIED');
/**
 * (experimental) The gateway response for an invalid API configuration.
 *
 * @experimental
 */
ResponseType.API_CONFIGURATION_ERROR = new ResponseType('API_CONFIGURATION_ERROR');
/**
 * (experimental) The gateway response when a custom or Amazon Cognito authorizer failed to authenticate the caller.
 *
 * @experimental
 */
ResponseType.AUTHORIZER_FAILURE = new ResponseType('AUTHORIZER_FAILURE');
/**
 * (experimental) The gateway response for failing to connect to a custom or Amazon Cognito authorizer.
 *
 * @experimental
 */
ResponseType.AUTHORIZER_CONFIGURATION_ERROR = new ResponseType('AUTHORIZER_CONFIGURATION_ERROR');
/**
 * (experimental) The gateway response when the request parameter cannot be validated according to an enabled request validator.
 *
 * @experimental
 */
ResponseType.BAD_REQUEST_PARAMETERS = new ResponseType('BAD_REQUEST_PARAMETERS');
/**
 * (experimental) The gateway response when the request body cannot be validated according to an enabled request validator.
 *
 * @experimental
 */
ResponseType.BAD_REQUEST_BODY = new ResponseType('BAD_REQUEST_BODY');
/**
 * (experimental) The default gateway response for an unspecified response type with the status code of 4XX.
 *
 * @experimental
 */
ResponseType.DEFAULT_4XX = new ResponseType('DEFAULT_4XX');
/**
 * (experimental) The default gateway response for an unspecified response type with a status code of 5XX.
 *
 * @experimental
 */
ResponseType.DEFAULT_5XX = new ResponseType('DEFAULT_5XX');
/**
 * (experimental) The gateway response for an AWS authentication token expired error.
 *
 * @experimental
 */
ResponseType.EXPIRED_TOKEN = new ResponseType('EXPIRED_TOKEN');
/**
 * (experimental) The gateway response for an invalid AWS signature error.
 *
 * @experimental
 */
ResponseType.INVALID_SIGNATURE = new ResponseType('INVALID_SIGNATURE');
/**
 * (experimental) The gateway response for an integration failed error.
 *
 * @experimental
 */
ResponseType.INTEGRATION_FAILURE = new ResponseType('INTEGRATION_FAILURE');
/**
 * (experimental) The gateway response for an integration timed out error.
 *
 * @experimental
 */
ResponseType.INTEGRATION_TIMEOUT = new ResponseType('INTEGRATION_TIMEOUT');
/**
 * (experimental) The gateway response for an invalid API key submitted for a method requiring an API key.
 *
 * @experimental
 */
ResponseType.INVALID_API_KEY = new ResponseType('INVALID_API_KEY');
/**
 * (experimental) The gateway response for a missing authentication token error, including the cases when the client attempts to invoke an unsupported API method or resource.
 *
 * @experimental
 */
ResponseType.MISSING_AUTHENTICATION_TOKEN = new ResponseType('MISSING_AUTHENTICATION_TOKEN');
/**
 * (experimental) The gateway response for the usage plan quota exceeded error.
 *
 * @experimental
 */
ResponseType.QUOTA_EXCEEDED = new ResponseType('QUOTA_EXCEEDED');
/**
 * (experimental) The gateway response for the request too large error.
 *
 * @experimental
 */
ResponseType.REQUEST_TOO_LARGE = new ResponseType('REQUEST_TOO_LARGE');
/**
 * (experimental) The gateway response when API Gateway cannot find the specified resource after an API request passes authentication and authorization.
 *
 * @experimental
 */
ResponseType.RESOURCE_NOT_FOUND = new ResponseType('RESOURCE_NOT_FOUND');
/**
 * (experimental) The gateway response when usage plan, method, stage, or account level throttling limits exceeded.
 *
 * @experimental
 */
ResponseType.THROTTLED = new ResponseType('THROTTLED');
/**
 * (experimental) The gateway response when the custom or Amazon Cognito authorizer failed to authenticate the caller.
 *
 * @experimental
 */
ResponseType.UNAUTHORIZED = new ResponseType('UNAUTHORIZED');
/**
 * (experimental) The gateway response when a payload is of an unsupported media type, if strict passthrough behavior is enabled.
 *
 * @experimental
 */
ResponseType.UNSUPPORTED_MEDIA_TYPE = new ResponseType('UNSUPPORTED_MEDIA_TYPE');
/**
 * (experimental) The gateway response when a request is blocked by AWS WAF.
 *
 * @experimental
 */
ResponseType.WAF_FILTERED = new ResponseType('WAF_FILTERED');
//# sourceMappingURL=data:application/json;base64,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