import * as iam from "../../../aws-iam";
import * as lambda from "../../../aws-lambda";
import { Duration } from "../../../core";
import { Construct } from 'constructs';
import { Authorizer, IAuthorizer } from '../authorizer';
import { IRestApi } from '../restapi';
/**
 * (experimental) Base properties for all lambda authorizers.
 *
 * @experimental
 */
export interface LambdaAuthorizerProps {
    /**
     * (experimental) An optional human friendly name for the authorizer.
     *
     * Note that, this is not the primary identifier of the authorizer.
     *
     * @default - the unique construcrt ID
     * @experimental
     */
    readonly authorizerName?: string;
    /**
     * (experimental) The handler for the authorizer lambda function.
     *
     * The handler must follow a very specific protocol on the input it receives and the output it needs to produce.
     * API Gateway has documented the handler's input specification
     * {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification
     * {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.
     *
     * @experimental
     */
    readonly handler: lambda.IFunction;
    /**
     * (experimental) How long APIGateway should cache the results.
     *
     * Max 1 hour.
     * Disable caching by setting this to 0.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly resultsCacheTtl?: Duration;
    /**
     * (experimental) An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer.
     *
     * The IAM role must be
     * assumable by 'apigateway.amazonaws.com'.
     *
     * @default - A resource policy is added to the Lambda function allowing apigateway.amazonaws.com to invoke the function.
     * @experimental
     */
    readonly assumeRole?: iam.IRole;
}
declare abstract class LambdaAuthorizer extends Authorizer implements IAuthorizer {
    /**
     * The id of the authorizer.
     * @attribute
     */
    abstract readonly authorizerId: string;
    /**
     * The ARN of the authorizer to be used in permission policies, such as IAM and resource-based grants.
     */
    abstract readonly authorizerArn: string;
    /**
     * (experimental) The Lambda function handler that this authorizer uses.
     *
     * @experimental
     */
    protected readonly handler: lambda.IFunction;
    /**
     * (experimental) The IAM role that the API Gateway service assumes while invoking the Lambda function.
     *
     * @experimental
     */
    protected readonly role?: iam.IRole;
    /**
     * @experimental
     */
    protected restApiId?: string;
    protected constructor(scope: Construct, id: string, props: LambdaAuthorizerProps);
    /**
     * Attaches this authorizer to a specific REST API.
     * @internal
     */
    _attachToApi(restApi: IRestApi): void;
    /**
     * (experimental) Sets up the permissions necessary for the API Gateway service to invoke the Lambda function.
     *
     * @experimental
     */
    protected setupPermissions(): void;
    /**
     * (experimental) Returns a token that resolves to the Rest Api Id at the time of synthesis.
     *
     * Throws an error, during token resolution, if no RestApi is attached to this authorizer.
     *
     * @experimental
     */
    protected lazyRestApiId(): string;
}
/**
 * (experimental) Properties for TokenAuthorizer.
 *
 * @experimental
 */
export interface TokenAuthorizerProps extends LambdaAuthorizerProps {
    /**
     * (experimental) An optional regex to be matched against the authorization token.
     *
     * When matched the authorizer lambda is invoked,
     * otherwise a 401 Unauthorized is returned to the client.
     *
     * @default - no regex filter will be applied.
     * @experimental
     */
    readonly validationRegex?: string;
    /**
     * (experimental) The request header mapping expression for the bearer token.
     *
     * This is typically passed as part of the header, in which case
     * this should be `method.request.header.Authorizer` where Authorizer is the header containing the bearer token.
     *
     * @default `IdentitySource.header('Authorization')`
     * @see https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource
     * @experimental
     */
    readonly identitySource?: string;
}
/**
 * (experimental) Token based lambda authorizer that recognizes the caller's identity as a bearer token, such as a JSON Web Token (JWT) or an OAuth token.
 *
 * Based on the token, authorization is performed by a lambda function.
 *
 * @experimental
 * @resource AWS::ApiGateway::Authorizer
 */
export declare class TokenAuthorizer extends LambdaAuthorizer {
    /**
     * (experimental) The id of the authorizer.
     *
     * @experimental
     */
    readonly authorizerId: string;
    /**
     * (experimental) The ARN of the authorizer to be used in permission policies, such as IAM and resource-based grants.
     *
     * @experimental
     */
    readonly authorizerArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TokenAuthorizerProps);
}
/**
 * (experimental) Properties for RequestAuthorizer.
 *
 * @experimental
 */
export interface RequestAuthorizerProps extends LambdaAuthorizerProps {
    /**
     * (experimental) An array of request header mapping expressions for identities.
     *
     * Supported parameter types are
     * Header, Query String, Stage Variable, and Context. For instance, extracting an authorization
     * token from a header would use the identity source `IdentitySource.header('Authorizer')`.
     *
     * Note: API Gateway uses the specified identity sources as the request authorizer caching key. When caching is
     * enabled, API Gateway calls the authorizer's Lambda function only after successfully verifying that all the
     * specified identity sources are present at runtime. If a specified identify source is missing, null, or empty,
     * API Gateway returns a 401 Unauthorized response without calling the authorizer Lambda function.
     *
     * @see https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource
     * @experimental
     */
    readonly identitySources: string[];
}
/**
 * (experimental) Request-based lambda authorizer that recognizes the caller's identity via request parameters, such as headers, paths, query strings, stage variables, or context variables.
 *
 * Based on the request, authorization is performed by a lambda function.
 *
 * @experimental
 * @resource AWS::ApiGateway::Authorizer
 */
export declare class RequestAuthorizer extends LambdaAuthorizer {
    /**
     * (experimental) The id of the authorizer.
     *
     * @experimental
     */
    readonly authorizerId: string;
    /**
     * (experimental) The ARN of the authorizer to be used in permission policies, such as IAM and resource-based grants.
     *
     * @experimental
     */
    readonly authorizerArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: RequestAuthorizerProps);
}
export {};
