"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Represents an identity source.
 *
 * The source can be specified either as a literal value (e.g: `Auth`) which
 * cannot be blank, or as an unresolved string token.
 *
 * @experimental
 */
class IdentitySource {
    /**
     * (experimental) Provides a properly formatted header identity source.
     *
     * @param headerName the name of the header the `IdentitySource` will represent.
     * @returns a header identity source.
     * @experimental
     */
    static header(headerName) {
        return IdentitySource.toString(headerName, 'method.request.header');
    }
    /**
     * (experimental) Provides a properly formatted query string identity source.
     *
     * @param queryString the name of the query string the `IdentitySource` will represent.
     * @returns a query string identity source.
     * @experimental
     */
    static queryString(queryString) {
        return IdentitySource.toString(queryString, 'method.request.querystring');
    }
    /**
     * (experimental) Provides a properly formatted API Gateway stage variable identity source.
     *
     * @param stageVariable the name of the stage variable the `IdentitySource` will represent.
     * @returns an API Gateway stage variable identity source.
     * @experimental
     */
    static stageVariable(stageVariable) {
        return IdentitySource.toString(stageVariable, 'stageVariables');
    }
    /**
     * (experimental) Provides a properly formatted request context identity source.
     *
     * @param context the name of the context variable the `IdentitySource` will represent.
     * @returns a request context identity source.
     * @experimental
     */
    static context(context) {
        return IdentitySource.toString(context, 'context');
    }
    static toString(source, type) {
        if (!source.trim()) {
            throw new Error('IdentitySources must be a non-empty string.');
        }
        return `${type}.${source}`;
    }
}
exports.IdentitySource = IdentitySource;
_a = JSII_RTTI_SYMBOL_1;
IdentitySource[_a] = { fqn: "monocdk.aws_apigateway.IdentitySource", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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