import * as cognito from "../../../aws-cognito";
import { Duration } from "../../../core";
import { Construct } from 'constructs';
import { Authorizer, IAuthorizer } from '../authorizer';
import { AuthorizationType } from '../method';
import { IRestApi } from '../restapi';
/**
 * (experimental) Properties for CognitoUserPoolsAuthorizer.
 *
 * @experimental
 */
export interface CognitoUserPoolsAuthorizerProps {
    /**
     * (experimental) An optional human friendly name for the authorizer.
     *
     * Note that, this is not the primary identifier of the authorizer.
     *
     * @default - the unique construct ID
     * @experimental
     */
    readonly authorizerName?: string;
    /**
     * (experimental) The user pools to associate with this authorizer.
     *
     * @experimental
     */
    readonly cognitoUserPools: cognito.IUserPool[];
    /**
     * (experimental) How long APIGateway should cache the results.
     *
     * Max 1 hour.
     * Disable caching by setting this to 0.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly resultsCacheTtl?: Duration;
    /**
     * (experimental) The request header mapping expression for the bearer token.
     *
     * This is typically passed as part of the header, in which case
     * this should be `method.request.header.Authorizer` where Authorizer is the header containing the bearer token.
     *
     * @default `IdentitySource.header('Authorization')`
     * @see https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource
     * @experimental
     */
    readonly identitySource?: string;
}
/**
 * (experimental) Cognito user pools based custom authorizer.
 *
 * @experimental
 * @resource AWS::ApiGateway::Authorizer
 */
export declare class CognitoUserPoolsAuthorizer extends Authorizer implements IAuthorizer {
    /**
     * (experimental) The id of the authorizer.
     *
     * @experimental
     * @attribute true
     */
    readonly authorizerId: string;
    /**
     * (experimental) The ARN of the authorizer to be used in permission policies, such as IAM and resource-based grants.
     *
     * @experimental
     * @attribute true
     */
    readonly authorizerArn: string;
    /**
     * (experimental) The authorization type of this authorizer.
     *
     * @experimental
     */
    readonly authorizationType?: AuthorizationType;
    private restApiId?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CognitoUserPoolsAuthorizerProps);
    /**
     * Attaches this authorizer to a specific REST API.
     * @internal
     */
    _attachToApi(restApi: IRestApi): void;
    /**
     * Returns a token that resolves to the Rest Api Id at the time of synthesis.
     * Throws an error, during token resolution, if no RestApi is attached to this authorizer.
     */
    private lazyRestApiId;
}
