import * as iam from "../../aws-iam";
import { IResource as IResourceBase, Resource } from "../../core";
import { Construct } from 'constructs';
import { ResourceOptions } from './resource';
import { IRestApi } from './restapi';
import { QuotaSettings, ThrottleSettings, UsagePlanPerApiStage } from './usage-plan';
/**
 * (experimental) API keys are alphanumeric string values that you distribute to app developer customers to grant access to your API.
 *
 * @experimental
 */
export interface IApiKey extends IResourceBase {
    /**
     * (experimental) The API key ID.
     *
     * @experimental
     * @attribute true
     */
    readonly keyId: string;
    /**
     * (experimental) The API key ARN.
     *
     * @experimental
     */
    readonly keyArn: string;
}
/**
 * (experimental) The options for creating an API Key.
 *
 * @experimental
 */
export interface ApiKeyOptions extends ResourceOptions {
    /**
     * (experimental) A name for the API key.
     *
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
     *
     * @default automically generated name
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-name
     */
    readonly apiKeyName?: string;
    /**
     * (experimental) The value of the API key.
     *
     * Must be at least 20 characters long.
     *
     * @default none
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-value
     */
    readonly value?: string;
}
/**
 * (experimental) ApiKey Properties.
 *
 * @experimental
 */
export interface ApiKeyProps extends ApiKeyOptions {
    /**
     * (experimental) A list of resources this api key is associated with.
     *
     * @default none
     * @experimental
     */
    readonly resources?: IRestApi[];
    /**
     * (experimental) An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
     *
     * @default none
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-customerid
     */
    readonly customerId?: string;
    /**
     * (experimental) A description of the purpose of the API key.
     *
     * @default none
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-description
     */
    readonly description?: string;
    /**
     * (experimental) Indicates whether the API key can be used by clients.
     *
     * @default true
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-enabled
     */
    readonly enabled?: boolean;
    /**
     * (experimental) Specifies whether the key identifier is distinct from the created API key value.
     *
     * @default false
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-generatedistinctid
     */
    readonly generateDistinctId?: boolean;
}
/**
 * Base implementation that is common to the various implementations of IApiKey
 */
declare abstract class ApiKeyBase extends Resource implements IApiKey {
    abstract readonly keyId: string;
    abstract readonly keyArn: string;
    /**
     * (experimental) Permits the IAM principal all read operations through this key.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits the IAM principal all write operations through this key.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits the IAM principal all read and write operations through this key.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantReadWrite(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) An API Gateway ApiKey.
 *
 * An ApiKey can be distributed to API clients that are executing requests
 * for Method resources that require an Api Key.
 *
 * @experimental
 */
export declare class ApiKey extends ApiKeyBase {
    /**
     * (experimental) Import an ApiKey by its Id.
     *
     * @experimental
     */
    static fromApiKeyId(scope: Construct, id: string, apiKeyId: string): IApiKey;
    /**
     * (experimental) The API key ID.
     *
     * @experimental
     */
    readonly keyId: string;
    /**
     * (experimental) The API key ARN.
     *
     * @experimental
     */
    readonly keyArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ApiKeyProps);
    private renderStageKeys;
}
/**
 * (experimental) RateLimitedApiKey properties.
 *
 * @experimental
 */
export interface RateLimitedApiKeyProps extends ApiKeyProps {
    /**
     * (experimental) API Stages to be associated with the RateLimitedApiKey.
     *
     * @default none
     * @experimental
     */
    readonly apiStages?: UsagePlanPerApiStage[];
    /**
     * (experimental) Number of requests clients can make in a given time period.
     *
     * @default none
     * @experimental
     */
    readonly quota?: QuotaSettings;
    /**
     * (experimental) Overall throttle settings for the API.
     *
     * @default none
     * @experimental
     */
    readonly throttle?: ThrottleSettings;
}
/**
 * (experimental) An API Gateway ApiKey, for which a rate limiting configuration can be specified.
 *
 * @experimental
 * @resource AWS::ApiGateway::ApiKey
 */
export declare class RateLimitedApiKey extends ApiKeyBase {
    /**
     * (experimental) The API key ID.
     *
     * @experimental
     */
    readonly keyId: string;
    /**
     * (experimental) The API key ARN.
     *
     * @experimental
     */
    readonly keyArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: RateLimitedApiKeyProps);
}
export {};
