import { ILogGroup } from "../../aws-logs";
import { IStage } from './stage';
/**
 * (experimental) Access log destination for a RestApi Stage.
 *
 * @experimental
 */
export interface IAccessLogDestination {
    /**
     * (experimental) Binds this destination to the RestApi Stage.
     *
     * @experimental
     */
    bind(stage: IStage): AccessLogDestinationConfig;
}
/**
 * (experimental) Options when binding a log destination to a RestApi Stage.
 *
 * @experimental
 */
export interface AccessLogDestinationConfig {
    /**
     * (experimental) The Amazon Resource Name (ARN) of the destination resource.
     *
     * @experimental
     */
    readonly destinationArn: string;
}
/**
 * (experimental) Use CloudWatch Logs as a custom access log destination for API Gateway.
 *
 * @experimental
 */
export declare class LogGroupLogDestination implements IAccessLogDestination {
    private readonly logGroup;
    /**
     * @experimental
     */
    constructor(logGroup: ILogGroup);
    /**
     * (experimental) Binds this destination to the CloudWatch Logs.
     *
     * @experimental
     */
    bind(_stage: IStage): AccessLogDestinationConfig;
}
/**
 * (experimental) $context variables that can be used to customize access log pattern.
 *
 * @experimental
 */
export declare class AccessLogField {
    /**
     * (experimental) The API owner's AWS account ID.
     *
     * @experimental
     */
    static contextAccountId(): string;
    /**
     * (experimental) The identifier API Gateway assigns to your API.
     *
     * @experimental
     */
    static contextApiId(): string;
    /**
     * (experimental) A property of the claims returned from the Amazon Cognito user pool after the method caller is successfully authenticated.
     *
     * @param property A property key of the claims.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html
     * @experimental
     */
    static contextAuthorizerClaims(property: string): string;
    /**
     * (experimental) The principal user identification associated with the token sent by the client and returned from an API Gateway Lambda authorizer (formerly known as a custom authorizer).
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
     * @experimental
     */
    static contextAuthorizerPrincipalId(): string;
    /**
     * (experimental) The stringified value of the specified key-value pair of the `context` map returned from an API Gateway Lambda authorizer function.
     *
     * @param property key of the context map.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
     * @experimental
     */
    static contextAuthorizer(property: string): string;
    /**
     * (experimental) The AWS endpoint's request ID.
     *
     * @experimental
     */
    static contextAwsEndpointRequestId(): string;
    /**
     * (experimental) The full domain name used to invoke the API.
     *
     * This should be the same as the incoming `Host` header.
     *
     * @experimental
     */
    static contextDomainName(): string;
    /**
     * (experimental) The first label of the `$context.domainName`. This is often used as a caller/customer identifier.
     *
     * @experimental
     */
    static contextDomainPrefix(): string;
    /**
     * (experimental) A string containing an API Gateway error message.
     *
     * @experimental
     */
    static contextErrorMessage(): string;
    /**
     * (experimental) The quoted value of $context.error.message, namely "$context.error.message".
     *
     * @experimental
     */
    static contextErrorMessageString(): string;
    /**
     * (experimental) A type of GatewayResponse.
     *
     * This variable can only be used for simple variable substitution in a GatewayResponse body-mapping template,
     * which is not processed by the Velocity Template Language engine, and in access logging.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html
     * @experimental
     */
    static contextErrorResponseType(): string;
    /**
     * (experimental) A string containing a detailed validation error message.
     *
     * @experimental
     */
    static contextErrorValidationErrorString(): string;
    /**
     * (experimental) The extended ID that API Gateway assigns to the API request, which contains more useful information for debugging/troubleshooting.
     *
     * @experimental
     */
    static contextExtendedRequestId(): string;
    /**
     * (experimental) The HTTP method used.
     *
     * Valid values include: `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, and `PUT`.
     *
     * @experimental
     */
    static contextHttpMethod(): string;
    /**
     * (experimental) The AWS account ID associated with the request.
     *
     * @experimental
     */
    static contextIdentityAccountId(): string;
    /**
     * (experimental) For API methods that require an API key, this variable is the API key associated with the method request.
     *
     * For methods that don't require an API key, this variable is
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html
     * @experimental
     */
    static contextIdentityApiKey(): string;
    /**
     * (experimental) The API key ID associated with an API request that requires an API key.
     *
     * @experimental
     */
    static contextIdentityApiKeyId(): string;
    /**
     * (experimental) The principal identifier of the caller making the request.
     *
     * @experimental
     */
    static contextIdentityCaller(): string;
    /**
     * (experimental) The Amazon Cognito authentication provider used by the caller making the request.
     *
     * Available only if the request was signed with Amazon Cognito credentials.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html
     * @experimental
     */
    static contextIdentityCognitoAuthenticationProvider(): string;
    /**
     * (experimental) The Amazon Cognito authentication type of the caller making the request.
     *
     * Available only if the request was signed with Amazon Cognito credentials.
     *
     * @experimental
     */
    static contextIdentityCognitoAuthenticationType(): string;
    /**
     * (experimental) The Amazon Cognito identity ID of the caller making the request.
     *
     * Available only if the request was signed with Amazon Cognito credentials.
     *
     * @experimental
     */
    static contextIdentityCognitoIdentityId(): string;
    /**
     * (experimental) The Amazon Cognito identity pool ID of the caller making the request.
     *
     * Available only if the request was signed with Amazon Cognito credentials.
     *
     * @experimental
     */
    static contextIdentityCognitoIdentityPoolId(): string;
    /**
     * (experimental) The AWS organization ID.
     *
     * @experimental
     */
    static contextIdentityPrincipalOrgId(): string;
    /**
     * (experimental) The source IP address of the TCP connection making the request to API Gateway.
     *
     * Warning: You should not trust this value if there is any chance that the `X-Forwarded-For` header could be forged.
     *
     * @experimental
     */
    static contextIdentitySourceIp(): string;
    /**
     * (experimental) The principal identifier of the user making the request.
     *
     * Used in Lambda authorizers.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
     * @experimental
     */
    static contextIdentityUser(): string;
    /**
     * (experimental) The User-Agent header of the API caller.
     *
     * @experimental
     */
    static contextIdentityUserAgent(): string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the effective user identified after authentication.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
     * @experimental
     */
    static contextIdentityUserArn(): string;
    /**
     * (experimental) The request path.
     *
     * For example, for a non-proxy request URL of https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child,
     * this value is /{stage}/root/child.
     *
     * @experimental
     */
    static contextPath(): string;
    /**
     * (experimental) The request protocol, for example, HTTP/1.1.
     *
     * @experimental
     */
    static contextProtocol(): string;
    /**
     * (experimental) The ID that API Gateway assigns to the API request.
     *
     * @experimental
     */
    static contextRequestId(): string;
    /**
     * (experimental) The request header override.
     *
     * If this parameter is defined, it contains the headers to be used instead of the HTTP Headers that are defined in the Integration Request pane.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     * @experimental
     */
    static contextRequestOverrideHeader(headerName: string): string;
    /**
     * (experimental) The request path override.
     *
     * If this parameter is defined,
     * it contains the request path to be used instead of the URL Path Parameters that are defined in the Integration Request pane.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     * @experimental
     */
    static contextRequestOverridePath(pathName: string): string;
    /**
     * (experimental) The request query string override.
     *
     * If this parameter is defined, it contains the request query strings to be used instead
     * of the URL Query String Parameters that are defined in the Integration Request pane.
     *
     * @experimental
     */
    static contextRequestOverrideQuerystring(querystringName: string): string;
    /**
     * (experimental) The response header override.
     *
     * If this parameter is defined, it contains the header to be returned instead of the Response header
     * that is defined as the Default mapping in the Integration Response pane.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     * @experimental
     */
    static contextResponseOverrideHeader(headerName: string): string;
    /**
     * (experimental) The response status code override.
     *
     * If this parameter is defined, it contains the status code to be returned instead of the Method response status
     * that is defined as the Default mapping in the Integration Response pane.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     * @experimental
     */
    static contextResponseOverrideStatus(): string;
    /**
     * (experimental) The CLF-formatted request time (dd/MMM/yyyy:HH:mm:ss +-hhmm).
     *
     * @experimental
     */
    static contextRequestTime(): string;
    /**
     * (experimental) The Epoch-formatted request time.
     *
     * @experimental
     */
    static contextRequestTimeEpoch(): string;
    /**
     * (experimental) The identifier that API Gateway assigns to your resource.
     *
     * @experimental
     */
    static contextResourceId(): string;
    /**
     * (experimental) The path to your resource.
     *
     * For example, for the non-proxy request URI of `https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child`,
     * The $context.resourcePath value is `/root/child`.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-api-step-by-step.html
     * @experimental
     */
    static contextResourcePath(): string;
    /**
     * (experimental) The deployment stage of the API request (for example, `Beta` or `Prod`).
     *
     * @experimental
     */
    static contextStage(): string;
    /**
     * (experimental) The response received from AWS WAF: `WAF_ALLOW` or `WAF_BLOCK`.
     *
     * Will not be set if the stage is not associated with a web ACL.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
     * @experimental
     */
    static contextWafResponseCode(): string;
    /**
     * (experimental) The complete ARN of the web ACL that is used to decide whether to allow or block the request.
     *
     * Will not be set if the stage is not associated with a web ACL.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
     * @experimental
     */
    static contextWebaclArn(): string;
    /**
     * (experimental) The trace ID for the X-Ray trace.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-enabling-xray.html
     * @experimental
     */
    static contextXrayTraceId(): string;
    /**
     * (experimental) The authorizer latency in ms.
     *
     * @experimental
     */
    static contextAuthorizerIntegrationLatency(): string;
    /**
     * (experimental) The integration latency in ms.
     *
     * @experimental
     */
    static contextIntegrationLatency(): string;
    /**
     * (experimental) For Lambda proxy integration, this parameter represents the status code returned from AWS Lambda, not from the backend Lambda function.
     *
     * @experimental
     */
    static contextIntegrationStatus(): string;
    /**
     * (experimental) The response latency in ms.
     *
     * @experimental
     */
    static contextResponseLatency(): string;
    /**
     * (experimental) The response payload length.
     *
     * @experimental
     */
    static contextResponseLength(): string;
    /**
     * (experimental) The method response status.
     *
     * @experimental
     */
    static contextStatus(): string;
}
/**
 * (experimental) Properties for controlling items output in JSON standard format.
 *
 * @experimental
 */
export interface JsonWithStandardFieldProps {
    /**
     * (experimental) If this flag is enabled, the source IP of request will be output to the log.
     *
     * @experimental
     */
    readonly ip: boolean;
    /**
     * (experimental) If this flag is enabled, the principal identifier of the caller will be output to the log.
     *
     * @experimental
     */
    readonly caller: boolean;
    /**
     * (experimental) If this flag is enabled, the principal identifier of the user will be output to the log.
     *
     * @experimental
     */
    readonly user: boolean;
    /**
     * (experimental) If this flag is enabled, the CLF-formatted request time((dd/MMM/yyyy:HH:mm:ss +-hhmm) will be output to the log.
     *
     * @experimental
     */
    readonly requestTime: boolean;
    /**
     * (experimental) If this flag is enabled, the http method will be output to the log.
     *
     * @experimental
     */
    readonly httpMethod: boolean;
    /**
     * (experimental) If this flag is enabled, the path to your resource will be output to the log.
     *
     * @experimental
     */
    readonly resourcePath: boolean;
    /**
     * (experimental) If this flag is enabled, the method response status will be output to the log.
     *
     * @experimental
     */
    readonly status: boolean;
    /**
     * (experimental) If this flag is enabled, the request protocol will be output to the log.
     *
     * @experimental
     */
    readonly protocol: boolean;
    /**
     * (experimental) If this flag is enabled, the response payload length will be output to the log.
     *
     * @experimental
     */
    readonly responseLength: boolean;
}
/**
 * (experimental) factory methods for access log format.
 *
 * @experimental
 */
export declare class AccessLogFormat {
    /**
     * (experimental) Custom log format.
     *
     * You can create any log format string. You can easily get the $ context variable by using the methods of AccessLogField.
     *
     * @experimental
     * @example
     *
     * custom(JSON.stringify({
     * requestId: AccessLogField.contextRequestId(),
     * sourceIp: AccessLogField.contextIdentitySourceIp(),
     * method: AccessLogFiled.contextHttpMethod(),
     * userContext: {
     * sub: AccessLogField.contextAuthorizerClaims('sub'),
     * email: AccessLogField.contextAuthorizerClaims('email')
     * }
     * }))
     */
    static custom(format: string): AccessLogFormat;
    /**
     * (experimental) Generate Common Log Format.
     *
     * @experimental
     */
    static clf(): AccessLogFormat;
    /**
     * (experimental) Access log will be produced in the JSON format with a set of fields most useful in the access log.
     *
     * All fields are turned on by default with the
     * option to turn off specific fields.
     *
     * @experimental
     */
    static jsonWithStandardFields(fields?: JsonWithStandardFieldProps): AccessLogFormat;
    /**
     * A API Gateway custom access log format
     */
    private readonly format;
    private constructor();
    /**
     * (experimental) Output a format string to be used with CloudFormation.
     *
     * @experimental
     */
    toString(): string;
}
