"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeCommitSourceCodeProvider = exports.GitLabSourceCodeProvider = exports.GitHubSourceCodeProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) GitHub source code provider.
 *
 * @experimental
 */
class GitHubSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app) {
        return {
            repository: `https://github.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitHubSourceCodeProvider = GitHubSourceCodeProvider;
_a = JSII_RTTI_SYMBOL_1;
GitHubSourceCodeProvider[_a] = { fqn: "monocdk.aws_amplify.GitHubSourceCodeProvider", version: "1.106.1" };
/**
 * (experimental) GitLab source code provider.
 *
 * @experimental
 */
class GitLabSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app) {
        return {
            repository: `https://gitlab.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitLabSourceCodeProvider = GitLabSourceCodeProvider;
_b = JSII_RTTI_SYMBOL_1;
GitLabSourceCodeProvider[_b] = { fqn: "monocdk.aws_amplify.GitLabSourceCodeProvider", version: "1.106.1" };
/**
 * (experimental) CodeCommit source code provider.
 *
 * @experimental
 */
class CodeCommitSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(app) {
        this.props.repository.grantPull(app);
        return {
            repository: this.props.repository.repositoryCloneUrlHttp,
        };
    }
}
exports.CodeCommitSourceCodeProvider = CodeCommitSourceCodeProvider;
_c = JSII_RTTI_SYMBOL_1;
CodeCommitSourceCodeProvider[_c] = { fqn: "monocdk.aws_amplify.CodeCommitSourceCodeProvider", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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