"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const amplify_generated_1 = require("./amplify.generated");
/**
 * (experimental) An Amplify Console domain.
 *
 * @experimental
 */
class Domain extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new amplify_generated_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: core_1.Lazy.any({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
            enableAutoSubDomain: !!props.enableAutoSubdomain,
            autoSubDomainCreationPatterns: props.autoSubdomainCreationPatterns || ['*', 'pr*'],
            autoSubDomainIamRole: (_b = props.autoSubDomainIamRole) === null || _b === void 0 ? void 0 : _b.roleArn,
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
        this.domainAutoSubDomainCreationPatterns = domain.attrAutoSubDomainCreationPatterns;
        this.domainAutoSubDomainIamRole = domain.attrAutoSubDomainIamRole;
        this.domainEnableAutoSubDomain = domain.attrEnableAutoSubDomain;
    }
    /**
     * (experimental) Maps a branch to a sub domain.
     *
     * @param branch The branch.
     * @param prefix The prefix.
     * @experimental
     */
    mapSubDomain(branch, prefix) {
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * (experimental) Maps a branch to the domain root.
     *
     * @experimental
     */
    mapRoot(branch) {
        return this.mapSubDomain(branch, '');
    }
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    validate() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => {
            var _b;
            return ({
                branchName: s.branch.branchName,
                prefix: (_b = s.prefix) !== null && _b !== void 0 ? _b : s.branch.branchName,
            });
        });
    }
}
exports.Domain = Domain;
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "monocdk.aws_amplify.Domain", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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