import * as codebuild from "../../aws-codebuild";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IApp } from './app';
import { BasicAuth } from './basic-auth';
/**
 * (experimental) A branch.
 *
 * @experimental
 */
export interface IBranch extends IResource {
    /**
     * (experimental) The name of the branch.
     *
     * @experimental
     * @attribute true
     */
    readonly branchName: string;
}
/**
 * (experimental) Options to add a branch to an application.
 *
 * @experimental
 */
export interface BranchOptions {
    /**
     * (experimental) The Basic Auth configuration.
     *
     * Use this to set password protection for
     * the branch
     *
     * @default - no password protection
     * @experimental
     */
    readonly basicAuth?: BasicAuth;
    /**
     * (experimental) The name of the branch.
     *
     * @default - the construct's id
     * @experimental
     */
    readonly branchName?: string;
    /**
     * (experimental) BuildSpec for the branch.
     *
     * @default - no build spec
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html
     * @experimental
     */
    readonly buildSpec?: codebuild.BuildSpec;
    /**
     * (experimental) A description for the branch.
     *
     * @default - no description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Whether to enable auto building for the branch.
     *
     * @default true
     * @experimental
     */
    readonly autoBuild?: boolean;
    /**
     * (experimental) Whether to enable pull request preview for the branch.
     *
     * @default true
     * @experimental
     */
    readonly pullRequestPreview?: boolean;
    /**
     * (experimental) Environment variables for the branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @default - application environment variables
     * @experimental
     */
    readonly environmentVariables?: {
        [name: string]: string;
    };
    /**
     * (experimental) The dedicated backend environment for the pull request previews.
     *
     * @default - automatically provision a temporary backend
     * @experimental
     */
    readonly pullRequestEnvironmentName?: string;
    /**
     * (experimental) Stage for the branch.
     *
     * @default - no stage
     * @experimental
     */
    readonly stage?: string;
}
/**
 * (experimental) Properties for a Branch.
 *
 * @experimental
 */
export interface BranchProps extends BranchOptions {
    /**
     * (experimental) The application within which the branch must be created.
     *
     * @experimental
     */
    readonly app: IApp;
}
/**
 * (experimental) An Amplify Console branch.
 *
 * @experimental
 */
export declare class Branch extends Resource implements IBranch {
    /**
     * (experimental) Import an existing branch.
     *
     * @experimental
     */
    static fromBranchName(scope: Construct, id: string, branchName: string): IBranch;
    /**
     * (experimental) The ARN of the branch.
     *
     * @experimental
     * @attribute true
     */
    readonly arn: string;
    /**
     * (experimental) The name of the branch.
     *
     * @experimental
     */
    readonly branchName: string;
    private readonly environmentVariables;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BranchProps);
    /**
     * (experimental) Adds an environment variable to this branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addEnvironment(name: string, value: string): this;
}
