"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmazonMQMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class AmazonMQMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'CpuUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static currentConnectionsCountSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'CurrentConnectionsCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cpuCreditBalanceHeapUsageMaximum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'CpuCreditBalanceHeapUsage',
            dimensions,
            statistic: 'Maximum',
        };
    }
    static networkInSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'NetworkIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkOutSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'NetworkOut',
            dimensions,
            statistic: 'Sum',
        };
    }
    static totalConsumerCountSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'TotalConsumerCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static totalMessageCountSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'TotalMessageCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static totalProducerCountSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'TotalProducerCount',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.AmazonMQMetrics = AmazonMQMetrics;
//# sourceMappingURL=data:application/json;base64,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