import * as cdk from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Interface which all CertificateAuthority based class must implement.
 *
 * @experimental
 */
export interface ICertificateAuthority extends cdk.IResource {
    /**
     * (experimental) The Amazon Resource Name of the Certificate.
     *
     * @experimental
     * @attribute true
     */
    readonly certificateAuthorityArn: string;
}
/**
 * (experimental) Defines a Certificate for ACMPCA.
 *
 * @experimental
 * @resource AWS::ACMPCA::CertificateAuthority
 */
export declare class CertificateAuthority {
    /**
     * (experimental) Import an existing Certificate given an ARN.
     *
     * @experimental
     */
    static fromCertificateAuthorityArn(scope: Construct, id: string, certificateAuthorityArn: string): ICertificateAuthority;
    private constructor();
}
