import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export interface CfnCertificateProps {
    /**
     * `AWS::ACMPCA::Certificate.CertificateAuthorityArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificateauthorityarn
     */
    readonly certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::Certificate.CertificateSigningRequest`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificatesigningrequest
     */
    readonly certificateSigningRequest: string;
    /**
     * `AWS::ACMPCA::Certificate.SigningAlgorithm`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-signingalgorithm
     */
    readonly signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::Certificate.Validity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-validity
     */
    readonly validity: CfnCertificate.ValidityProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::Certificate.ApiPassthrough`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-apipassthrough
     */
    readonly apiPassthrough?: CfnCertificate.ApiPassthroughProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::Certificate.TemplateArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-templatearn
     */
    readonly templateArn?: string;
    /**
     * `AWS::ACMPCA::Certificate.ValidityNotBefore`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-validitynotbefore
     */
    readonly validityNotBefore?: CfnCertificate.ValidityProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare class CfnCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ACMPCA::Certificate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCertificate;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Certificate
     */
    readonly attrCertificate: string;
    /**
     * `AWS::ACMPCA::Certificate.CertificateAuthorityArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificateauthorityarn
     */
    certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::Certificate.CertificateSigningRequest`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificatesigningrequest
     */
    certificateSigningRequest: string;
    /**
     * `AWS::ACMPCA::Certificate.SigningAlgorithm`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-signingalgorithm
     */
    signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::Certificate.Validity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-validity
     */
    validity: CfnCertificate.ValidityProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::Certificate.ApiPassthrough`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-apipassthrough
     */
    apiPassthrough: CfnCertificate.ApiPassthroughProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ACMPCA::Certificate.TemplateArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-templatearn
     */
    templateArn: string | undefined;
    /**
     * `AWS::ACMPCA::Certificate.ValidityNotBefore`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-validitynotbefore
     */
    validityNotBefore: CfnCertificate.ValidityProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ACMPCA::Certificate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-apipassthrough.html
     */
    interface ApiPassthroughProperty {
        /**
         * `CfnCertificate.ApiPassthroughProperty.Extensions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-apipassthrough.html#cfn-acmpca-certificate-apipassthrough-extensions
         */
        readonly extensions?: CfnCertificate.ExtensionsProperty | cdk.IResolvable;
        /**
         * `CfnCertificate.ApiPassthroughProperty.Subject`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-apipassthrough.html#cfn-acmpca-certificate-apipassthrough-subject
         */
        readonly subject?: CfnCertificate.SubjectProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-edipartyname.html
     */
    interface EdiPartyNameProperty {
        /**
         * `CfnCertificate.EdiPartyNameProperty.NameAssigner`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-edipartyname.html#cfn-acmpca-certificate-edipartyname-nameassigner
         */
        readonly nameAssigner: string;
        /**
         * `CfnCertificate.EdiPartyNameProperty.PartyName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-edipartyname.html#cfn-acmpca-certificate-edipartyname-partyname
         */
        readonly partyName: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-extendedkeyusage.html
     */
    interface ExtendedKeyUsageProperty {
        /**
         * `CfnCertificate.ExtendedKeyUsageProperty.ExtendedKeyUsageObjectIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-extendedkeyusage.html#cfn-acmpca-certificate-extendedkeyusage-extendedkeyusageobjectidentifier
         */
        readonly extendedKeyUsageObjectIdentifier?: string;
        /**
         * `CfnCertificate.ExtendedKeyUsageProperty.ExtendedKeyUsageType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-extendedkeyusage.html#cfn-acmpca-certificate-extendedkeyusage-extendedkeyusagetype
         */
        readonly extendedKeyUsageType?: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-extensions.html
     */
    interface ExtensionsProperty {
        /**
         * `CfnCertificate.ExtensionsProperty.CertificatePolicies`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-extensions.html#cfn-acmpca-certificate-extensions-certificatepolicies
         */
        readonly certificatePolicies?: Array<CfnCertificate.PolicyInformationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnCertificate.ExtensionsProperty.ExtendedKeyUsage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-extensions.html#cfn-acmpca-certificate-extensions-extendedkeyusage
         */
        readonly extendedKeyUsage?: Array<CfnCertificate.ExtendedKeyUsageProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnCertificate.ExtensionsProperty.KeyUsage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-extensions.html#cfn-acmpca-certificate-extensions-keyusage
         */
        readonly keyUsage?: CfnCertificate.KeyUsageProperty | cdk.IResolvable;
        /**
         * `CfnCertificate.ExtensionsProperty.SubjectAlternativeNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-extensions.html#cfn-acmpca-certificate-extensions-subjectalternativenames
         */
        readonly subjectAlternativeNames?: Array<CfnCertificate.GeneralNameProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-generalname.html
     */
    interface GeneralNameProperty {
        /**
         * `CfnCertificate.GeneralNameProperty.DirectoryName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-generalname.html#cfn-acmpca-certificate-generalname-directoryname
         */
        readonly directoryName?: CfnCertificate.SubjectProperty | cdk.IResolvable;
        /**
         * `CfnCertificate.GeneralNameProperty.DnsName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-generalname.html#cfn-acmpca-certificate-generalname-dnsname
         */
        readonly dnsName?: string;
        /**
         * `CfnCertificate.GeneralNameProperty.EdiPartyName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-generalname.html#cfn-acmpca-certificate-generalname-edipartyname
         */
        readonly ediPartyName?: CfnCertificate.EdiPartyNameProperty | cdk.IResolvable;
        /**
         * `CfnCertificate.GeneralNameProperty.IpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-generalname.html#cfn-acmpca-certificate-generalname-ipaddress
         */
        readonly ipAddress?: string;
        /**
         * `CfnCertificate.GeneralNameProperty.OtherName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-generalname.html#cfn-acmpca-certificate-generalname-othername
         */
        readonly otherName?: CfnCertificate.OtherNameProperty | cdk.IResolvable;
        /**
         * `CfnCertificate.GeneralNameProperty.RegisteredId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-generalname.html#cfn-acmpca-certificate-generalname-registeredid
         */
        readonly registeredId?: string;
        /**
         * `CfnCertificate.GeneralNameProperty.Rfc822Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-generalname.html#cfn-acmpca-certificate-generalname-rfc822name
         */
        readonly rfc822Name?: string;
        /**
         * `CfnCertificate.GeneralNameProperty.UniformResourceIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-generalname.html#cfn-acmpca-certificate-generalname-uniformresourceidentifier
         */
        readonly uniformResourceIdentifier?: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html
     */
    interface KeyUsageProperty {
        /**
         * `CfnCertificate.KeyUsageProperty.CRLSign`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html#cfn-acmpca-certificate-keyusage-crlsign
         */
        readonly crlSign?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificate.KeyUsageProperty.DataEncipherment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html#cfn-acmpca-certificate-keyusage-dataencipherment
         */
        readonly dataEncipherment?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificate.KeyUsageProperty.DecipherOnly`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html#cfn-acmpca-certificate-keyusage-decipheronly
         */
        readonly decipherOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificate.KeyUsageProperty.DigitalSignature`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html#cfn-acmpca-certificate-keyusage-digitalsignature
         */
        readonly digitalSignature?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificate.KeyUsageProperty.EncipherOnly`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html#cfn-acmpca-certificate-keyusage-encipheronly
         */
        readonly encipherOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificate.KeyUsageProperty.KeyAgreement`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html#cfn-acmpca-certificate-keyusage-keyagreement
         */
        readonly keyAgreement?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificate.KeyUsageProperty.KeyCertSign`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html#cfn-acmpca-certificate-keyusage-keycertsign
         */
        readonly keyCertSign?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificate.KeyUsageProperty.KeyEncipherment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html#cfn-acmpca-certificate-keyusage-keyencipherment
         */
        readonly keyEncipherment?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificate.KeyUsageProperty.NonRepudiation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-keyusage.html#cfn-acmpca-certificate-keyusage-nonrepudiation
         */
        readonly nonRepudiation?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-othername.html
     */
    interface OtherNameProperty {
        /**
         * `CfnCertificate.OtherNameProperty.TypeId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-othername.html#cfn-acmpca-certificate-othername-typeid
         */
        readonly typeId: string;
        /**
         * `CfnCertificate.OtherNameProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-othername.html#cfn-acmpca-certificate-othername-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-policyinformation.html
     */
    interface PolicyInformationProperty {
        /**
         * `CfnCertificate.PolicyInformationProperty.CertPolicyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-policyinformation.html#cfn-acmpca-certificate-policyinformation-certpolicyid
         */
        readonly certPolicyId: string;
        /**
         * `CfnCertificate.PolicyInformationProperty.PolicyQualifiers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-policyinformation.html#cfn-acmpca-certificate-policyinformation-policyqualifiers
         */
        readonly policyQualifiers?: Array<CfnCertificate.PolicyQualifierInfoProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-policyqualifierinfo.html
     */
    interface PolicyQualifierInfoProperty {
        /**
         * `CfnCertificate.PolicyQualifierInfoProperty.PolicyQualifierId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-policyqualifierinfo.html#cfn-acmpca-certificate-policyqualifierinfo-policyqualifierid
         */
        readonly policyQualifierId: string;
        /**
         * `CfnCertificate.PolicyQualifierInfoProperty.Qualifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-policyqualifierinfo.html#cfn-acmpca-certificate-policyqualifierinfo-qualifier
         */
        readonly qualifier: CfnCertificate.QualifierProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-qualifier.html
     */
    interface QualifierProperty {
        /**
         * `CfnCertificate.QualifierProperty.CpsUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-qualifier.html#cfn-acmpca-certificate-qualifier-cpsuri
         */
        readonly cpsUri: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html
     */
    interface SubjectProperty {
        /**
         * `CfnCertificate.SubjectProperty.CommonName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-commonname
         */
        readonly commonName?: string;
        /**
         * `CfnCertificate.SubjectProperty.Country`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-country
         */
        readonly country?: string;
        /**
         * `CfnCertificate.SubjectProperty.DistinguishedNameQualifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-distinguishednamequalifier
         */
        readonly distinguishedNameQualifier?: string;
        /**
         * `CfnCertificate.SubjectProperty.GenerationQualifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-generationqualifier
         */
        readonly generationQualifier?: string;
        /**
         * `CfnCertificate.SubjectProperty.GivenName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-givenname
         */
        readonly givenName?: string;
        /**
         * `CfnCertificate.SubjectProperty.Initials`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-initials
         */
        readonly initials?: string;
        /**
         * `CfnCertificate.SubjectProperty.Locality`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-locality
         */
        readonly locality?: string;
        /**
         * `CfnCertificate.SubjectProperty.Organization`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-organization
         */
        readonly organization?: string;
        /**
         * `CfnCertificate.SubjectProperty.OrganizationalUnit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-organizationalunit
         */
        readonly organizationalUnit?: string;
        /**
         * `CfnCertificate.SubjectProperty.Pseudonym`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-pseudonym
         */
        readonly pseudonym?: string;
        /**
         * `CfnCertificate.SubjectProperty.SerialNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-serialnumber
         */
        readonly serialNumber?: string;
        /**
         * `CfnCertificate.SubjectProperty.State`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-state
         */
        readonly state?: string;
        /**
         * `CfnCertificate.SubjectProperty.Surname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-surname
         */
        readonly surname?: string;
        /**
         * `CfnCertificate.SubjectProperty.Title`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-subject.html#cfn-acmpca-certificate-subject-title
         */
        readonly title?: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare namespace CfnCertificate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-validity.html
     */
    interface ValidityProperty {
        /**
         * `CfnCertificate.ValidityProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-validity.html#cfn-acmpca-certificate-validity-type
         */
        readonly type: string;
        /**
         * `CfnCertificate.ValidityProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-validity.html#cfn-acmpca-certificate-validity-value
         */
        readonly value: number;
    }
}
/**
 * Properties for defining a `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export interface CfnCertificateAuthorityProps {
    /**
     * `AWS::ACMPCA::CertificateAuthority.KeyAlgorithm`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keyalgorithm
     */
    readonly keyAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.SigningAlgorithm`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-signingalgorithm
     */
    readonly signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Subject`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-subject
     */
    readonly subject: CfnCertificateAuthority.SubjectProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-type
     */
    readonly type: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.CsrExtensions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-csrextensions
     */
    readonly csrExtensions?: CfnCertificateAuthority.CsrExtensionsProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.KeyStorageSecurityStandard`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keystoragesecuritystandard
     */
    readonly keyStorageSecurityStandard?: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.RevocationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-revocationconfiguration
     */
    readonly revocationConfiguration?: CfnCertificateAuthority.RevocationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare class CfnCertificateAuthority extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ACMPCA::CertificateAuthority";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCertificateAuthority;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CertificateSigningRequest
     */
    readonly attrCertificateSigningRequest: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.KeyAlgorithm`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keyalgorithm
     */
    keyAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.SigningAlgorithm`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-signingalgorithm
     */
    signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Subject`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-subject
     */
    subject: CfnCertificateAuthority.SubjectProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-type
     */
    type: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.CsrExtensions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-csrextensions
     */
    csrExtensions: CfnCertificateAuthority.CsrExtensionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ACMPCA::CertificateAuthority.KeyStorageSecurityStandard`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keystoragesecuritystandard
     */
    keyStorageSecurityStandard: string | undefined;
    /**
     * `AWS::ACMPCA::CertificateAuthority.RevocationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-revocationconfiguration
     */
    revocationConfiguration: CfnCertificateAuthority.RevocationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ACMPCA::CertificateAuthority`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateAuthorityProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-accessdescription.html
     */
    interface AccessDescriptionProperty {
        /**
         * `CfnCertificateAuthority.AccessDescriptionProperty.AccessLocation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-accessdescription.html#cfn-acmpca-certificateauthority-accessdescription-accesslocation
         */
        readonly accessLocation: CfnCertificateAuthority.GeneralNameProperty | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.AccessDescriptionProperty.AccessMethod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-accessdescription.html#cfn-acmpca-certificateauthority-accessdescription-accessmethod
         */
        readonly accessMethod: CfnCertificateAuthority.AccessMethodProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-accessmethod.html
     */
    interface AccessMethodProperty {
        /**
         * `CfnCertificateAuthority.AccessMethodProperty.AccessMethodType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-accessmethod.html#cfn-acmpca-certificateauthority-accessmethod-accessmethodtype
         */
        readonly accessMethodType?: string;
        /**
         * `CfnCertificateAuthority.AccessMethodProperty.CustomObjectIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-accessmethod.html#cfn-acmpca-certificateauthority-accessmethod-customobjectidentifier
         */
        readonly customObjectIdentifier?: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html
     */
    interface CrlConfigurationProperty {
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.CustomCname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-customcname
         */
        readonly customCname?: string;
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.ExpirationInDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-expirationindays
         */
        readonly expirationInDays?: number;
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.S3BucketName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-s3bucketname
         */
        readonly s3BucketName?: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-csrextensions.html
     */
    interface CsrExtensionsProperty {
        /**
         * `CfnCertificateAuthority.CsrExtensionsProperty.KeyUsage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-csrextensions.html#cfn-acmpca-certificateauthority-csrextensions-keyusage
         */
        readonly keyUsage?: CfnCertificateAuthority.KeyUsageProperty | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.CsrExtensionsProperty.SubjectInformationAccess`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-csrextensions.html#cfn-acmpca-certificateauthority-csrextensions-subjectinformationaccess
         */
        readonly subjectInformationAccess?: Array<CfnCertificateAuthority.AccessDescriptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-edipartyname.html
     */
    interface EdiPartyNameProperty {
        /**
         * `CfnCertificateAuthority.EdiPartyNameProperty.NameAssigner`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-edipartyname.html#cfn-acmpca-certificateauthority-edipartyname-nameassigner
         */
        readonly nameAssigner: string;
        /**
         * `CfnCertificateAuthority.EdiPartyNameProperty.PartyName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-edipartyname.html#cfn-acmpca-certificateauthority-edipartyname-partyname
         */
        readonly partyName: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-generalname.html
     */
    interface GeneralNameProperty {
        /**
         * `CfnCertificateAuthority.GeneralNameProperty.DirectoryName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-generalname.html#cfn-acmpca-certificateauthority-generalname-directoryname
         */
        readonly directoryName?: CfnCertificateAuthority.SubjectProperty | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.GeneralNameProperty.DnsName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-generalname.html#cfn-acmpca-certificateauthority-generalname-dnsname
         */
        readonly dnsName?: string;
        /**
         * `CfnCertificateAuthority.GeneralNameProperty.EdiPartyName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-generalname.html#cfn-acmpca-certificateauthority-generalname-edipartyname
         */
        readonly ediPartyName?: CfnCertificateAuthority.EdiPartyNameProperty | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.GeneralNameProperty.IpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-generalname.html#cfn-acmpca-certificateauthority-generalname-ipaddress
         */
        readonly ipAddress?: string;
        /**
         * `CfnCertificateAuthority.GeneralNameProperty.OtherName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-generalname.html#cfn-acmpca-certificateauthority-generalname-othername
         */
        readonly otherName?: CfnCertificateAuthority.OtherNameProperty | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.GeneralNameProperty.RegisteredId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-generalname.html#cfn-acmpca-certificateauthority-generalname-registeredid
         */
        readonly registeredId?: string;
        /**
         * `CfnCertificateAuthority.GeneralNameProperty.Rfc822Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-generalname.html#cfn-acmpca-certificateauthority-generalname-rfc822name
         */
        readonly rfc822Name?: string;
        /**
         * `CfnCertificateAuthority.GeneralNameProperty.UniformResourceIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-generalname.html#cfn-acmpca-certificateauthority-generalname-uniformresourceidentifier
         */
        readonly uniformResourceIdentifier?: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html
     */
    interface KeyUsageProperty {
        /**
         * `CfnCertificateAuthority.KeyUsageProperty.CRLSign`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html#cfn-acmpca-certificateauthority-keyusage-crlsign
         */
        readonly crlSign?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.KeyUsageProperty.DataEncipherment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html#cfn-acmpca-certificateauthority-keyusage-dataencipherment
         */
        readonly dataEncipherment?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.KeyUsageProperty.DecipherOnly`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html#cfn-acmpca-certificateauthority-keyusage-decipheronly
         */
        readonly decipherOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.KeyUsageProperty.DigitalSignature`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html#cfn-acmpca-certificateauthority-keyusage-digitalsignature
         */
        readonly digitalSignature?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.KeyUsageProperty.EncipherOnly`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html#cfn-acmpca-certificateauthority-keyusage-encipheronly
         */
        readonly encipherOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.KeyUsageProperty.KeyAgreement`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html#cfn-acmpca-certificateauthority-keyusage-keyagreement
         */
        readonly keyAgreement?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.KeyUsageProperty.KeyCertSign`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html#cfn-acmpca-certificateauthority-keyusage-keycertsign
         */
        readonly keyCertSign?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.KeyUsageProperty.KeyEncipherment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html#cfn-acmpca-certificateauthority-keyusage-keyencipherment
         */
        readonly keyEncipherment?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.KeyUsageProperty.NonRepudiation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-keyusage.html#cfn-acmpca-certificateauthority-keyusage-nonrepudiation
         */
        readonly nonRepudiation?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-othername.html
     */
    interface OtherNameProperty {
        /**
         * `CfnCertificateAuthority.OtherNameProperty.TypeId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-othername.html#cfn-acmpca-certificateauthority-othername-typeid
         */
        readonly typeId: string;
        /**
         * `CfnCertificateAuthority.OtherNameProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-othername.html#cfn-acmpca-certificateauthority-othername-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-revocationconfiguration.html
     */
    interface RevocationConfigurationProperty {
        /**
         * `CfnCertificateAuthority.RevocationConfigurationProperty.CrlConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-revocationconfiguration.html#cfn-acmpca-certificateauthority-revocationconfiguration-crlconfiguration
         */
        readonly crlConfiguration?: CfnCertificateAuthority.CrlConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html
     */
    interface SubjectProperty {
        /**
         * `CfnCertificateAuthority.SubjectProperty.CommonName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-commonname
         */
        readonly commonName?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Country`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-country
         */
        readonly country?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.DistinguishedNameQualifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-distinguishednamequalifier
         */
        readonly distinguishedNameQualifier?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.GenerationQualifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-generationqualifier
         */
        readonly generationQualifier?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.GivenName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-givenname
         */
        readonly givenName?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Initials`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-initials
         */
        readonly initials?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Locality`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-locality
         */
        readonly locality?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Organization`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-organization
         */
        readonly organization?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.OrganizationalUnit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-organizationalunit
         */
        readonly organizationalUnit?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Pseudonym`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-pseudonym
         */
        readonly pseudonym?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.SerialNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-serialnumber
         */
        readonly serialNumber?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.State`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-state
         */
        readonly state?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Surname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-surname
         */
        readonly surname?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Title`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-title
         */
        readonly title?: string;
    }
}
/**
 * Properties for defining a `AWS::ACMPCA::CertificateAuthorityActivation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html
 */
export interface CfnCertificateAuthorityActivationProps {
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificate
     */
    readonly certificate: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateAuthorityArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificateauthorityarn
     */
    readonly certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateChain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificatechain
     */
    readonly certificateChain?: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Status`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-status
     */
    readonly status?: string;
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthorityActivation`.
 *
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthorityActivation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html
 */
export declare class CfnCertificateAuthorityActivation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ACMPCA::CertificateAuthorityActivation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCertificateAuthorityActivation;
    /**
     * @external
     * @cloudformationAttribute CompleteCertificateChain
     */
    readonly attrCompleteCertificateChain: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificate
     */
    certificate: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateAuthorityArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificateauthorityarn
     */
    certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateChain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificatechain
     */
    certificateChain: string | undefined;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Status`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-status
     */
    status: string | undefined;
    /**
     * Create a new `AWS::ACMPCA::CertificateAuthorityActivation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateAuthorityActivationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
