<p align="center"><img src="https://iamzero.dev/img/logo-boxed.svg" height="80" /></p>

<h1 align="center">iamzero-python</h1>
<p align="center">Python client library for <a href="https://iamzero.dev">IAM Zero</a></p>

<p align="center">
<a align="center" href="https://twitter.com/intent/tweet?url=https%3A%2F%2Fiamzero.dev&text=IAM%20Zero%20simplifies%20cloud%20permissions%20for%20development%20teams"><img src="https://img.shields.io/twitter/url/https/github.com/tterb/hyde.svg?style=social" alt="tweet" /></a>
<a href="https://join.slack.com/t/commonfatecommunity/shared_invite/zt-q4m96ypu-_gYlRWD3k5rIsaSsqP7QMg"><img src="https://img.shields.io/badge/slack-iamzero-1F72FE.svg?logo=slack" alt="slack" /></a>
</p>

<p align="center">
    <a href="https://iamzero.dev/docs/getting-started">🚀 Get Started</a> |
    <a href="https://iamzero.dev/docs/support">📖 Support</a>
</p>

This package makes it easy to create least-privilege IAM policies for your Python scripts or applications.

## What is IAM Zero?

IAM Zero detects identity and access management issues and automatically suggests least-privilege policies. It does this by capturing errors in applications you build or commands that you run which use. By detecting the error and matching it against our Access Advisory lists IAM Zero can instantly provide a least-privilege policy recommendation, customised to your cloud environment.

IAM Zero currently works for AWS but our roadmap includes other cloud platforms like GCP, Azure, and Kubernetes.

## Documentation

Get started by [reading our documentation](https://iamzero.dev/docs/getting-started).

## Contributing

See [CONTRIBUTING.md](./CONTRIBUTING.md) for information on how to contribute. We welcome all contributors - [join our Slack](https://join.slack.com/t/commonfatecommunity/shared_invite/zt-q4m96ypu-_gYlRWD3k5rIsaSsqP7QMg) to discuss the project!

## Security

You can view our full security documentation on the [IAM Zero website](https://iamzero.dev/docs/security).
