import { Category, FeaturedPackages, FeatureFlags, PackageLinkConfig } from '.';
import { ConfigFile } from '../config-file';
import { PackageTagConfig } from '../package-tag';
export interface WebappConfigProps {
    /**
     * Configuration for custom package page links.
     */
    readonly packageLinks?: PackageLinkConfig[];
    /**
     * Configuration for custom computed tags.
     */
    readonly packageTags?: PackageTagConfig[];
    /**
     * Configuration for packages to feature on the home page.
     * @default - Display the 10 most recently updated packages
     */
    readonly featuredPackages?: FeaturedPackages;
    /**
     * Configure feature flags for the web app.
     */
    readonly featureFlags?: FeatureFlags;
    /**
     * Whether to display package stats from `stats.json` on
     * package cards.
     * @default true
     */
    readonly showPackageStats?: boolean;
    /**
     * Browse categories. Each category will appear in the home page as a button
     * with a link to the relevant search query.
     */
    readonly categories?: Category[];
}
export declare class WebappConfig {
    private readonly props;
    readonly file: ConfigFile;
    constructor(props: WebappConfigProps);
    private get frontendConfig();
    private get packageLinks();
    private get packageTags();
    private get featuredPackages();
    private get debugInfo();
}
