"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws = require("../shared/aws.lambda-shared");
const constants_1 = require("../shared/constants");
const env_lambda_shared_1 = require("../shared/env.lambda-shared");
const integrity_lambda_shared_1 = require("../shared/integrity.lambda-shared");
async function handler(event, context) {
    console.log('Event: ', JSON.stringify(event, null, 2));
    const bucket = env_lambda_shared_1.requireEnv('BUCKET_NAME');
    const queueUrl = env_lambda_shared_1.requireEnv('QUEUE_URL');
    console.log(`Download metadata object at ${bucket}/${event.Key}`);
    const { Body: jsonMetadata } = await aws.s3().getObject({ Bucket: bucket, Key: event.Key }).promise();
    if (jsonMetadata == null) {
        console.error(`No body found in ${bucket}/${event.Key}, aborting.`);
        return;
    }
    const { date: time } = JSON.parse(jsonMetadata.toString('utf-8'));
    const tarballKey = `${event.Key.substr(0, event.Key.length - constants_1.METADATA_KEY_SUFFIX.length)}${constants_1.PACKAGE_KEY_SUFFIX}`;
    console.log(`Download metadata object at ${bucket}/${tarballKey}`);
    const { Body: tarball, VersionId: versionId } = await aws.s3().getObject({ Bucket: bucket, Key: tarballKey }).promise();
    if (tarball == null) {
        console.error(`No body found in ${bucket}/${tarballKey}, aborting.`);
        return;
    }
    const ingestionInput = integrity_lambda_shared_1.integrity({
        tarballUri: `s3://${bucket}/${tarballKey}${versionId ? `?versionId=${versionId}` : ''}`,
        time,
        metadata: {
            reprocessRequestId: context.awsRequestId,
            reprocessLogGroup: context.logGroupName,
            reprocessLogStream: context.logStreamName,
        },
    }, Buffer.from(tarball));
    console.log(`Sending message to reprocess queue: ${JSON.stringify(ingestionInput, null, 2)}`);
    return aws.sqs().sendMessage({
        QueueUrl: queueUrl,
        MessageBody: JSON.stringify(ingestionInput, null, 2),
        MessageAttributes: {
            'Reprocess-RequestID': { DataType: 'String', StringValue: context.awsRequestId },
            'Reprocess-LogGroup': { DataType: 'String', StringValue: context.logGroupName },
            'Reprocess-LogStream': { DataType: 'String', StringValue: context.logStreamName },
        },
    }).promise();
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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