#![feature(test)]

// #[cfg(test)]

use criterion::black_box;
use criterion::criterion_group;
use criterion::criterion_main;
use criterion::Criterion;
use rust_circuit::circuit::circuit_optimizer::OptimizationContext;
use rust_circuit::circuit::circuit_optimizer::OptimizationSettings;
use rust_circuit::circuit::deep_rewrite::compiler_simp;
use rust_circuit::circuit::CircuitNode;
use rust_circuit::circuit::*;
use rust_circuit::opt_einsum::EinsumSpec;
use rust_circuit::rearrange_spec::*;
use rust_circuit::sv;
use rust_circuit::tensor_util::*;
extern crate test;

// TODO: these tests won't compile because the randn_named_seeded function has been replaced
// Calls will need to change from randn_named_seeded(vec, name, seed) to randn_seeded(vec, name, TorchDeviceDtypeOp::default(), seed)
// Ditto for new_tensor_randint_seeded
fn test_notebook_examples(circuits: &[CircuitRc]) {
    let mut settings: OptimizationSettings = Default::default();
    settings.verbose = 2;
    settings.log_simplifications = true;
    let mut context = OptimizationContext::new_settings(settings);
    for circuit in circuits {
        let result = compiler_simp(&circuit, &mut context);
        black_box(result);
        println!("{}", context.stringify_logs());
        // println!("{:?}", result.info().hash);
    }
    // println!("yo dude");
}

fn test_einsum_specs(einsum_specs: &Vec<EinsumSpec>) {
    for spec in einsum_specs {
        black_box(spec.optimize(None, None, None, None));
    }
}

fn criterion_benchmark(c: &mut Criterion) {
    pyo3::prepare_freethreaded_python();
    #[rustfmt::skip]
    let einsumspecs = vec![EinsumSpec{input_ints:vec![vec![0,1,2],vec![0,3,4],vec![0,3,5],vec![6,2,7],vec![8,9,10],vec![11,7,12],vec![4,13],vec![14,15],vec![16,14],vec![5,13],vec![13,9],vec![17,14],vec![0],vec![12,18],vec![17,18],vec![10,18],vec![16,18],vec![17],vec![16],vec![5],vec![4],vec![5],vec![4],vec![17],vec![16],vec![8,19],vec![11,20],vec![3,21],vec![1,22],vec![19,23],vec![20,24],vec![6,25],vec![1,25],vec![21,26],vec![22,27],vec![23,26],vec![24,27],vec![],vec![]], output_ints:vec![15], int_sizes:vec![32768,32,384,32,384,384,32,384,9,384,384,9,384,768,768,384,384,384,60,32,32,9,9,9,9,5,4,4]},EinsumSpec{input_ints:vec![vec![0,1,2],vec![0,3,4],vec![5,1,6],vec![7,4,8],vec![9,10,11],vec![12,8,13],vec![2,14],vec![15,16],vec![17,15],vec![6,14],vec![14,10],vec![18,15],vec![5],vec![13,19],vec![18,19],vec![11,19],vec![17,19],vec![18],vec![17],vec![6],vec![2],vec![6],vec![2],vec![18],vec![17],vec![9,20],vec![12,21],vec![1,22],vec![3,23],vec![20,24],vec![21,25],vec![7,26],vec![3,26],vec![22,27],vec![23,28],vec![24,27],vec![25,28],vec![],vec![],vec![]], output_ints:vec![16], int_sizes:vec![32768,32,384,32,384,32768,384,32,384,9,384,384,9,384,768,768,384,384,384,60,32,32,9,9,9,9,5,4,4]},EinsumSpec{input_ints:vec![vec![0,1,2],vec![0,1,3],vec![4,5,6],vec![7,6,8],vec![3,9],vec![2,9],vec![9,10],vec![11,12,13],vec![14,15],vec![11,16,17],vec![11,12,14],vec![4],vec![1,11,5],vec![13,18],vec![8,19],vec![17,18],vec![10,19],vec![13],vec![17],vec![2],vec![3],vec![11,16],vec![2],vec![3],vec![13],vec![17],vec![7,20],vec![5,20],vec![1],vec![1],vec![18,21],vec![19,21],vec![],vec![],vec![]], output_ints:vec![15], int_sizes:vec![32768,32,384,384,32768,32,384,32,384,768,384,8,48,384,384,384,48,384,2,2,5,2]},EinsumSpec{input_ints:vec![vec![0,1,2],vec![0,3,4],vec![0,3,5],vec![6,2,7],vec![4,8],vec![5,8],vec![8,9],vec![10,11,12],vec![13,14],vec![10,15,16],vec![10,11,13],vec![0],vec![3,10,1],vec![12,17],vec![7,18],vec![16,17],vec![9,18],vec![12],vec![16],vec![5],vec![4],vec![10,15],vec![5],vec![4],vec![12],vec![16],vec![6,19],vec![1,19],vec![3],vec![3],vec![17,20],vec![18,20],vec![],vec![]], output_ints:vec![14], int_sizes:vec![32768,32,384,32,384,384,32,384,768,384,8,48,384,384,384,48,384,2,2,5,2]},EinsumSpec{input_ints:vec![vec![0,1,2],vec![0,1,3],vec![4,5,6],vec![7,6,8],vec![9,10,11],vec![12,8,13],vec![3,14],vec![15,16],vec![17,15],vec![2,14],vec![14,10],vec![18,15],vec![4],vec![13,19],vec![18,19],vec![11,19],vec![17,19],vec![18],vec![17],vec![2],vec![3],vec![2],vec![3],vec![18],vec![17],vec![9,20],vec![12,21],vec![1,22],vec![5,23],vec![20,24],vec![21,25],vec![7,26],vec![5,26],vec![22,27],vec![23,28],vec![24,27],vec![25,28],vec![],vec![],vec![]], output_ints:vec![16], int_sizes:vec![32768,32,384,384,32768,32,384,32,384,9,384,384,9,384,768,768,384,384,384,60,32,32,9,9,9,9,5,4,4]},EinsumSpec{input_ints:vec![vec![0,1,2],vec![0,3,4],vec![5,1,6],vec![7,4,8],vec![9,10,11],vec![12,8,13],vec![6,14],vec![15,16],vec![17,15],vec![2,14],vec![14,10],vec![18,15],vec![5],vec![13,19],vec![18,19],vec![11,19],vec![17,19],vec![18],vec![17],vec![2],vec![6],vec![2],vec![6],vec![18],vec![17],vec![9,20],vec![12,21],vec![1,22],vec![3,23],vec![20,24],vec![21,25],vec![7,26],vec![3,26],vec![22,27],vec![23,28],vec![24,27],vec![25,28],vec![],vec![],vec![]], output_ints:vec![16], int_sizes:vec![32768,32,384,32,384,32768,384,32,384,9,384,384,9,384,768,768,384,384,384,60,32,32,9,9,9,9,5,4,4]},EinsumSpec{input_ints:vec![vec![0,1,2],vec![0,3,4],vec![5,1,6],vec![7,4,8],vec![2,9],vec![6,9],vec![9,10],vec![11,12,13],vec![14,15],vec![11,16,17],vec![11,12,14],vec![5],vec![1,11,3],vec![13,18],vec![8,19],vec![17,18],vec![10,19],vec![13],vec![17],vec![6],vec![2],vec![11,16],vec![6],vec![2],vec![13],vec![17],vec![7,20],vec![3,20],vec![1],vec![1],vec![18,21],vec![19,21],vec![],vec![],vec![]], output_ints:vec![15], int_sizes:vec![32768,32,384,32,384,32768,384,32,384,768,384,8,48,384,384,384,48,384,2,2,5,2]},EinsumSpec{input_ints:vec![vec![0,1,2],vec![0,3,4],vec![5,1,6],vec![7,4,8],vec![6,9],vec![2,9],vec![9,10],vec![11,12,13],vec![14,15],vec![11,16,17],vec![11,12,14],vec![5],vec![1,11,3],vec![13,18],vec![8,19],vec![17,18],vec![10,19],vec![13],vec![17],vec![2],vec![6],vec![11,16],vec![2],vec![6],vec![13],vec![17],vec![7,20],vec![3,20],vec![1],vec![1],vec![18,21],vec![19,21],vec![],vec![],vec![]], output_ints:vec![15], int_sizes:vec![32768,32,384,32,384,32768,384,32,384,768,384,8,48,384,384,384,48,384,2,2,5,2]},EinsumSpec{input_ints:vec![vec![0,1,2],vec![0,3,4],vec![5,4,6],vec![7,2,8],vec![9,8,10],vec![11,6,12],vec![13,14],vec![15,13],vec![16,13],vec![0],vec![12,17],vec![16,17],vec![10,17],vec![15,17],vec![14],vec![16],vec![15],vec![14],vec![16],vec![15],vec![14],vec![9,18],vec![11,19],vec![1,20],vec![3,21],vec![18,22],vec![19,23],vec![5,24],vec![3,24],vec![7,25],vec![1,25],vec![20,26],vec![21,27],vec![22,26],vec![23,27],vec![],vec![]], output_ints:vec![], int_sizes:vec![32768,32,384,32,384,32,384,32,384,9,384,9,384,768,384,384,384,60,32,32,9,9,9,9,5,5,4,4]}];
    #[rustfmt::skip]
    let circuits:&[CircuitRc] = &[
    {
    let node0 = ArrayConstant::randn_seeded(sv![50259,384], Some("w.unembed".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 929193938916086232).rc();
    let node1 = ScalarConstant::nrc(-1_f64, sv![], Some("unnamed".to_owned()));
    let node2 = Index::nrc(node0.clone(), TensorIndex ( vec![TensorAxisIndex::Single(318), TensorAxisIndex::Slice(Slice { start:None, stop:None })] ), Some("idx w.unembed".to_owned()));
    let node3 = Index::nrc(node0.clone(), TensorIndex ( vec![TensorAxisIndex::Single(373), TensorAxisIndex::Slice(Slice { start:None, stop:None })] ), Some("idx w.unembed".to_owned()));
    let node4 = Einsum::nrc(vec![(node3.clone(), sv![0]),(node1.clone(), sv![])], sv![0], Some("ScalarMul".to_owned()));
    let node5 = Add::nrc(vec![node2.clone(), node4.clone()], Some("w.unembed_is_m_was".to_owned()));
    let node6 = ArrayConstant::randn_seeded(sv![384], Some("final.n.w.var".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 4811093865619151916).rc();
    let node7 = ScalarConstant::nrc(0.00001_f64, sv![], Some("final.n.eps".to_owned()));
    let node8 = Add::nrc(vec![node6.clone(), node7.clone()], Some("final.n.w.var_p_eps".to_owned()));
    let node9 = ArrayConstant::randn_seeded(sv![384], Some("final.n.w.scale".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 6746609514966997473).rc();
    let node10 = GeneralFunction::new_by_name(vec![node8.clone()], "rsqrt".to_owned(), Some("final.n.w.full_mul".to_owned())).unwrap().rc();
    let node11 = Einsum::nrc(vec![(node9.clone(), sv![0]),(node10.clone(), sv![0]),(node5.clone(), sv![0])], sv![0], Some("w.unembed_is_m_was_s".to_owned()));
    let node12 = ArrayConstant::randn_seeded(sv![32,384], Some("w.pos_embeds".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 18302579321424555450).rc();
    let node13 = ArrayConstant::randn_seeded(sv![50259,384], Some("all_tok_embeds".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 2599709625776908268).rc();
    let node14 = Index::nrc(node13.clone(), TensorIndex ( vec![TensorAxisIndex::new_tensor_randint_seeded(10259872, 50259, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 6343153270071678776), TensorAxisIndex::Slice(Slice { start:None, stop:None })] ), Some("idx all_tok_embeds".to_owned()));
    let node15 = Rearrange::nrc(node14.clone(), RearrangeSpec::new(sv![sv![0,1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(320621)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("tok_embeds_post_t_shape".to_owned()));
    let node16 = Index::nrc(node15.clone(), TensorIndex ( vec![TensorAxisIndex::new_tensor_randint_seeded(4096, 320621, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 9118903253233274138), TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Slice(Slice { start:None, stop:None })] ), Some("idx tok_embeds_post_t_shape".to_owned()));
    let node17 = ScalarConstant::nrc(0.000244140625_f64, sv![4096], Some("empirical_weights_for_sampled".to_owned()));
    let node18 = Einsum::nrc(vec![(node17.clone(), sv![0])], sv![], Some("Ein".to_owned()));
    let node19 = GeneralFunction::new_by_name(vec![node18.clone()], "reciprocal".to_owned(), Some("Ein_recip".to_owned())).unwrap().rc();
    let node20 = Einsum::nrc(vec![(node17.clone(), sv![0]),(node19.clone(), sv![])], sv![0], Some("ScalarMul".to_owned()));
    let node21 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node16.clone(), sv![0,1,2])], sv![1,2], Some("embed_var_sample_sample_expectation".to_owned()));
    let node22 = Rearrange::nrc(node21.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("embed_var_sample_sample_expectation_sample".to_owned()));
    let node23 = Rearrange::nrc(node22.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("embed_var_sample_sample_expectation_sample_rearrange_for_add_1".to_owned()));
    let node24 = Rearrange::nrc(node16.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("embed_var_sample_rearrange_for_add_0".to_owned()));
    let node25 = Einsum::nrc(vec![(node23.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node26 = Add::nrc(vec![node24.clone(), node25.clone()], Some("embed_var_centered_sample".to_owned()));
    let node27 = Einsum::nrc(vec![(node26.clone(), sv![0,1,2]),(node26.clone(), sv![0,3,4]),(node26.clone(), sv![0,5,6])], sv![0,1,2,3,4,5,6], Some("outer_sample".to_owned()));
    let node28 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node27.clone(), sv![0,1,2,3,4,5,6])], sv![1,2,3,4,5,6], Some("outer_sample_sample_expectation".to_owned()));
    let node29 = Einsum::nrc(vec![(node26.clone(), sv![0,1,2]),(node26.clone(), sv![0,3,4])], sv![0,1,2,3,4], Some("outer_sample".to_owned()));
    let node30 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node29.clone(), sv![0,1,2,3,4])], sv![1,2,3,4], Some("outer_sample_sample_expectation".to_owned()));
    let node31 = ArrayConstant::randn_seeded(sv![320621], Some("is_is".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 8610991913703910243).rc();
    let node32 = Index::nrc(node31.clone(), TensorIndex ( vec![TensorAxisIndex::new_tensor_randint_seeded(4096, 320621, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 9118903253233274138)] ), Some("idx is_is".to_owned()));
    let node33 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node32.clone(), sv![0])], sv![], Some("is_is_var_sample_sample_expectation".to_owned()));
    let node34 = Rearrange::nrc(node33.clone(), RearrangeSpec::new(sv![], sv![sv![0]], sv![OpSize::from(Some(4096))]), Some("is_is_var_sample_sample_expectation_sample".to_owned()));
    let node35 = Rearrange::nrc(node34.clone(), RearrangeSpec::new(sv![sv![0]], sv![sv![0]], sv![OpSize::from(Some(4096))]), Some("is_is_var_sample_sample_expectation_sample_rearrange_for_add_1".to_owned()));
    let node36 = Rearrange::nrc(node32.clone(), RearrangeSpec::new(sv![sv![0]], sv![sv![0]], sv![OpSize::from(Some(4096))]), Some("is_is_var_sample_rearrange_for_add_0".to_owned()));
    let node37 = Einsum::nrc(vec![(node35.clone(), sv![0]),(node1.clone(), sv![])], sv![0], Some("ScalarMul".to_owned()));
    let node38 = Add::nrc(vec![node36.clone(), node37.clone()], Some("is_is_var_centered_sample".to_owned()));
    let node39 = ArrayConstant::randn_seeded(sv![8,48,384], Some("a0.w.v".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 10133531896693890946).rc();
    let node40 = Rearrange::nrc(node39.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![3],sv![0],sv![1],sv![2]], sv![OpSize::from(Some(8)),OpSize::from(Some(48)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.w.v_sample".to_owned()));
    let node41 = ArrayConstant::randn_seeded(sv![8,48,384], Some("a0.w.q".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 15164929069836551244).rc();
    let node42 = Rearrange::nrc(node41.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![3],sv![0],sv![1],sv![2]], sv![OpSize::from(Some(8)),OpSize::from(Some(48)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.w.q_sample".to_owned()));
    let node43 = Einsum::nrc(vec![(node41.clone(), sv![0,1,2]),(node12.clone(), sv![3,2])], sv![0,3,1], Some("a0.w.pos_q".to_owned()));
    let node44 = Rearrange::nrc(node43.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![3],sv![0],sv![1],sv![2]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(4096))]), Some("a0.w.pos_q_sample".to_owned()));
    let node45 = Rearrange::nrc(node44.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("a0.w.pos_q_sample_rearrange_for_add_1".to_owned()));
    let node46 = ArrayConstant::randn_seeded(sv![8,48,384], Some("a0.w.k".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 13890711741635822223).rc();
    let node47 = Einsum::nrc(vec![(node46.clone(), sv![0,1,2]),(node12.clone(), sv![3,2])], sv![0,3,1], Some("a0.w.pos_k".to_owned()));
    let node48 = Rearrange::nrc(node47.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![3],sv![0],sv![1],sv![2]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(4096))]), Some("a0.w.pos_k_sample".to_owned()));
    let node49 = Rearrange::nrc(node48.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("a0.w.pos_k_sample_rearrange_for_add_1".to_owned()));
    let node50 = ArrayConstant::randn_seeded(sv![8,48,384], Some("a0.w.out".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 11344873045249210841).rc();
    let node51 = Rearrange::nrc(node50.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![3],sv![0],sv![1],sv![2]], sv![OpSize::from(Some(8)),OpSize::from(Some(48)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.w.out_sample".to_owned()));
    let node52 = Rearrange::nrc(node46.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![3],sv![0],sv![1],sv![2]], sv![OpSize::from(Some(8)),OpSize::from(Some(48)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.w.k_sample".to_owned()));
    let node53 = ArrayConstant::randn_seeded(sv![384], Some("a0.n.w.var".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 2097624483321698950).rc();
    let node54 = ScalarConstant::nrc(0.00001_f64, sv![], Some("a0.n.eps".to_owned()));
    let node55 = Add::nrc(vec![node53.clone(), node54.clone()], Some("a0.n.w.var_p_eps".to_owned()));
    let node56 = ArrayConstant::randn_seeded(sv![384], Some("a0.n.w.scale".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 13379100888128585973).rc();
    let node57 = ArrayConstant::randn_seeded(sv![384], Some("a0.n.w.mean".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 14181844882358567796).rc();
    let node58 = Rearrange::nrc(node57.clone(), RearrangeSpec::new(sv![sv![0]], sv![sv![1],sv![0]], sv![OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.n.w.mean_sample".to_owned()));
    let node59 = Rearrange::nrc(node58.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![0],sv![],sv![1]], sv![OpSize::from(Some(4096)),OpSize::from(Some(384)),OpSize::from(Some(1))]), Some("a0.n.w.mean_sample_rearrange_for_add_1".to_owned()));
    let node60 = GeneralFunction::new_by_name(vec![node55.clone()], "rsqrt".to_owned(), Some("a0.n.w.full_mul".to_owned())).unwrap().rc();
    let node61 = Einsum::nrc(vec![(node56.clone(), sv![0]),(node60.clone(), sv![0])], sv![0], Some("a0.n.w.full_s".to_owned()));
    let node62 = Rearrange::nrc(node61.clone(), RearrangeSpec::new(sv![sv![0]], sv![sv![1],sv![0]], sv![OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.n.w.full_s_sample".to_owned()));
    let node63 = Einsum::nrc(vec![(node59.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node64 = Add::nrc(vec![node24.clone(), node63.clone()], Some("a0.n.sub_mean_sample".to_owned()));
    let node65 = Einsum::nrc(vec![(node64.clone(), sv![0,1,2]),(node62.clone(), sv![0,2])], sv![0,1,2], Some("a0.n.y_out_sample".to_owned()));
    let node66 = Rearrange::nrc(node65.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.n.y_out_sample_rearrange_for_add_1".to_owned()));
    let node67 = ArrayConstant::randn_seeded(sv![384], Some("a0.n.w.bias".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 7836263396355991022).rc();
    let node68 = Rearrange::nrc(node67.clone(), RearrangeSpec::new(sv![sv![0]], sv![sv![1],sv![0]], sv![OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.n.w.bias_sample".to_owned()));
    let node69 = Rearrange::nrc(node68.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![0],sv![],sv![1]], sv![OpSize::from(Some(4096)),OpSize::from(Some(384)),OpSize::from(Some(1))]), Some("a0.n.w.bias_sample_rearrange_for_add_0".to_owned()));
    let node70 = Add::nrc(vec![node69.clone(), node66.clone()], Some("a0.n_sample".to_owned()));
    let node71 = Einsum::nrc(vec![(node42.clone(), sv![0,1,2,3]),(node70.clone(), sv![0,4,3])], sv![0,1,4,2], Some("a0.q_sample".to_owned()));
    let node72 = Rearrange::nrc(node71.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("a0.q_sample_rearrange_for_add_0".to_owned()));
    let node73 = Einsum::nrc(vec![(node40.clone(), sv![0,1,2,3]),(node70.clone(), sv![0,4,3]),(node51.clone(), sv![0,1,2,5])], sv![0,1,4,5], Some("a0.ov_sample".to_owned()));
    let node74 = Rearrange::nrc(node73.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.ov_sample_rearrange_for_add_0".to_owned()));
    let node75 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node70.clone(), sv![0,1,2])], sv![1,2], Some("a0.n_sample_sample_expectation".to_owned()));
    let node76 = Einsum::nrc(vec![(node52.clone(), sv![0,1,2,3]),(node70.clone(), sv![0,4,3])], sv![0,1,4,2], Some("a0.k_sample".to_owned()));
    let node77 = Rearrange::nrc(node76.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("a0.k_sample_rearrange_for_add_0".to_owned()));
    let node78 = Add::nrc(vec![node72.clone(), node45.clone()], Some("a0.f_q_sample".to_owned()));
    let node79 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node78.clone(), sv![0,1,2,3])], sv![1,2,3], Some("a0.f_q_sample_sample_expectation".to_owned()));
    let node80 = Add::nrc(vec![node77.clone(), node49.clone()], Some("a0.f_k_sample".to_owned()));
    let node81 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node80.clone(), sv![0,1,2,3])], sv![1,2,3], Some("a0.f_k_sample_sample_expectation".to_owned()));
    let node82 = Add::nrc(vec![node30.clone()], Some("I k2 embed_var, embed_var I_decompose".to_owned()));
    let node83 = Einsum::nrc(vec![(node82.clone(), sv![0,1,2,3]),(node18.clone(), sv![])], sv![0,1,2,3], Some("ScalarMul".to_owned()));
    let node84 = Einsum::nrc(vec![(node83.clone(), sv![0,1,2,3]),(node18.clone(), sv![])], sv![0,1,2,3], Some("ScalarMul".to_owned()));
    let node85 = Einsum::nrc(vec![(node79.clone(), sv![0,1,2]),(node18.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node86 = Rearrange::nrc(node85.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![3],sv![0],sv![1],sv![2]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(4096))]), Some("I k1 a0.f_q I_sample".to_owned()));
    let node87 = Rearrange::nrc(node86.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I k1 a0.f_q I_sample_rearrange_for_add_2".to_owned()));
    let node88 = Einsum::nrc(vec![(node87.clone(), sv![0,1,2,3]),(node1.clone(), sv![])], sv![0,1,2,3], Some("ScalarMul".to_owned()));
    let node89 = Einsum::nrc(vec![(node75.clone(), sv![0,1]),(node18.clone(), sv![])], sv![0,1], Some("ScalarMul".to_owned()));
    let node90 = Einsum::nrc(vec![(node39.clone(), sv![0,1,2]),(node89.clone(), sv![3,2]),(node50.clone(), sv![0,1,4])], sv![0,3,4], Some("I k1 a0.w.v k1 a0.n k1 a0.w.out I perm".to_owned()));
    let node91 = Rearrange::nrc(node90.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![3],sv![0],sv![1],sv![2]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("I k1 a0.w.v k1 a0.n k1 a0.w.out I perm_sample".to_owned()));
    let node92 = Rearrange::nrc(node91.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("I k1 a0.w.v k1 a0.n k1 a0.w.out I perm_sample_rearrange_for_add_1".to_owned()));
    let node93 = Einsum::nrc(vec![(node92.clone(), sv![0,1,2,3]),(node1.clone(), sv![])], sv![0,1,2,3], Some("ScalarMul".to_owned()));
    let node94 = Einsum::nrc(vec![(node84.clone(), sv![0,1,2,3]),(node56.clone(), sv![3]),(node60.clone(), sv![3])], sv![0,1,2,3], Some("I k2 a0.n.y_out, embed_var I shaped".to_owned()));
    let node95 = Einsum::nrc(vec![(node94.clone(), sv![0,1,2,3]),(node41.clone(), sv![4,5,3])], sv![0,1,4,2,5], Some("I k2 a0.f_q, embed_var I shaped".to_owned()));
    let node96 = Einsum::nrc(vec![(node95.clone(), sv![0,1,2,3,4]),(node56.clone(), sv![1]),(node60.clone(), sv![1])], sv![0,1,2,3,4], Some("I k2 a0.f_q, a0.n.y_out I shaped".to_owned()));
    let node97 = Einsum::nrc(vec![(node96.clone(), sv![0,1,2,3,4]),(node39.clone(), sv![5,6,1]),(node50.clone(), sv![5,6,7])], sv![5,0,7,2,3,4], Some("I k2 a0.f_q, a0.n k1 a0.w.v k1 a0.w.out I perm".to_owned()));
    let node98 = Rearrange::nrc(node97.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5]], sv![sv![6],sv![0],sv![1],sv![2],sv![3],sv![4],sv![5]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(4096))]), Some("I k2 a0.f_q, a0.n k1 a0.w.v k1 a0.w.out I perm_sample".to_owned()));
    let node99 = Rearrange::nrc(node98.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I k2 a0.f_q, a0.n k1 a0.w.v k1 a0.w.out I perm_sample_rearrange_for_add_0".to_owned()));
    let node100 = Einsum::nrc(vec![(node99.clone(), sv![0,1,2,3,4,5,6]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6], Some("ScalarMul".to_owned()));
    let node101 = Einsum::nrc(vec![(node81.clone(), sv![0,1,2]),(node18.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node102 = Rearrange::nrc(node101.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![3],sv![0],sv![1],sv![2]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(4096))]), Some("I k1 a0.f_k I_sample".to_owned()));
    let node103 = Add::nrc(vec![node74.clone(), node93.clone()], Some("I eps1 a0.ov I_eps_sample".to_owned()));
    let node104 = Add::nrc(vec![node72.clone(), node45.clone(), node88.clone()], Some("I eps1 a0.f_q I_eps_sample".to_owned()));
    let node105 = Einsum::nrc(vec![(node103.clone(), sv![0,1,2,3]),(node104.clone(), sv![0,4,5,6])], sv![0,1,2,3,4,5,6], Some("I eps1 a0.ov eps1 a0.f_q I_sample".to_owned()));
    let node106 = Rearrange::nrc(node105.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I eps1 a0.ov eps1 a0.f_q I_sample_rearrange_for_add_1".to_owned()));
    let node107 = Add::nrc(vec![node100.clone(), node106.clone()], Some("I eps2 a0.f_q, a0.ov I_eps_sample".to_owned()));
    let node108 = Einsum::nrc(vec![(node107.clone(), sv![0,1,2,3,4,5,6]),(node102.clone(), sv![0,7,8,9])], sv![0,1,2,3,4,5,6,7,8,9], Some("eps_dec_i I eps2 a0.f_q, a0.ov I_eps I k1 a0.f_k I_sample".to_owned()));
    let node109 = Rearrange::nrc(node108.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("eps_dec_i I eps2 a0.f_q, a0.ov I_eps I k1 a0.f_k I_sample_rearrange_for_add_0".to_owned()));
    let node110 = Einsum::nrc(vec![(node94.clone(), sv![0,1,2,3]),(node46.clone(), sv![4,5,3])], sv![0,1,4,2,5], Some("I k2 a0.f_k, embed_var I shaped".to_owned()));
    let node111 = Einsum::nrc(vec![(node110.clone(), sv![0,1,2,3,4]),(node56.clone(), sv![1]),(node60.clone(), sv![1])], sv![0,1,2,3,4], Some("I k2 a0.f_k, a0.n.y_out I shaped".to_owned()));
    let node112 = Einsum::nrc(vec![(node111.clone(), sv![0,1,2,3,4]),(node39.clone(), sv![5,6,1]),(node50.clone(), sv![5,6,7])], sv![5,0,7,2,3,4], Some("I k2 a0.f_k, a0.n k1 a0.w.v k1 a0.w.out I perm".to_owned()));
    let node113 = Rearrange::nrc(node112.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5]], sv![sv![6],sv![0],sv![1],sv![2],sv![3],sv![4],sv![5]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(4096))]), Some("I k2 a0.f_k, a0.n k1 a0.w.v k1 a0.w.out I perm_sample".to_owned()));
    let node114 = Rearrange::nrc(node113.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I k2 a0.f_k, a0.n k1 a0.w.v k1 a0.w.out I perm_sample_rearrange_for_add_0".to_owned()));
    let node115 = Einsum::nrc(vec![(node114.clone(), sv![0,1,2,3,4,5,6]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6], Some("ScalarMul".to_owned()));
    let node116 = Rearrange::nrc(node102.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I k1 a0.f_k I_sample_rearrange_for_add_2".to_owned()));
    let node117 = Einsum::nrc(vec![(node116.clone(), sv![0,1,2,3]),(node1.clone(), sv![])], sv![0,1,2,3], Some("ScalarMul".to_owned()));
    let node118 = Add::nrc(vec![node77.clone(), node49.clone(), node117.clone()], Some("I eps1 a0.f_k I_eps_sample".to_owned()));
    let node119 = Einsum::nrc(vec![(node103.clone(), sv![0,1,2,3]),(node118.clone(), sv![0,4,5,6])], sv![0,1,2,3,4,5,6], Some("I eps1 a0.ov eps1 a0.f_k I_sample".to_owned()));
    let node120 = Rearrange::nrc(node119.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I eps1 a0.ov eps1 a0.f_k I_sample_rearrange_for_add_1".to_owned()));
    let node121 = Add::nrc(vec![node115.clone(), node120.clone()], Some("I eps2 a0.f_k, a0.ov I_eps_sample".to_owned()));
    let node122 = Einsum::nrc(vec![(node121.clone(), sv![0,1,2,3,4,5,6]),(node86.clone(), sv![0,7,8,9])], sv![0,1,2,3,7,8,9,4,5,6], Some("eps_dec_i I eps2 a0.f_k, a0.ov I_eps I k1 a0.f_q I_sample".to_owned()));
    let node123 = Rearrange::nrc(node122.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("eps_dec_i I eps2 a0.f_k, a0.ov I_eps I k1 a0.f_q I_sample_rearrange_for_add_1".to_owned()));
    let node124 = Einsum::nrc(vec![(node111.clone(), sv![0,1,2,3,4]),(node41.clone(), sv![5,6,1])], sv![5,0,6,2,3,4], Some("I k2 a0.f_k, a0.q I shaped".to_owned()));
    let node125 = Rearrange::nrc(node124.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5]], sv![sv![6],sv![0],sv![1],sv![2],sv![3],sv![4],sv![5]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(4096))]), Some("I k2 a0.f_k, a0.q I shaped_sample".to_owned()));
    let node126 = Rearrange::nrc(node125.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I k2 a0.f_k, a0.q I shaped_sample_rearrange_for_add_0".to_owned()));
    let node127 = Einsum::nrc(vec![(node126.clone(), sv![0,1,2,3,4,5,6]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6], Some("ScalarMul".to_owned()));
    let node128 = Einsum::nrc(vec![(node104.clone(), sv![0,1,2,3]),(node118.clone(), sv![0,4,5,6])], sv![0,1,2,3,4,5,6], Some("I eps1 a0.f_q eps1 a0.f_k I_sample".to_owned()));
    let node129 = Rearrange::nrc(node128.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I eps1 a0.f_q eps1 a0.f_k I_sample_rearrange_for_add_1".to_owned()));
    let node130 = Add::nrc(vec![node127.clone(), node129.clone()], Some("I eps2 a0.f_k, a0.f_q I_eps_sample".to_owned()));
    let node131 = Einsum::nrc(vec![(node130.clone(), sv![0,1,2,3,4,5,6]),(node91.clone(), sv![0,7,8,9])], sv![0,7,8,9,1,2,3,4,5,6], Some("eps_dec_i I eps2 a0.f_k, a0.f_q I_eps I k1 a0.ov I_sample".to_owned()));
    let node132 = Rearrange::nrc(node131.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("eps_dec_i I eps2 a0.f_k, a0.f_q I_eps I k1 a0.ov I_sample_rearrange_for_add_2".to_owned()));
    let node133 = Add::nrc(vec![node28.clone()], Some("I k3 embed_var, embed_var, embed_var I_decompose".to_owned()));
    let node134 = Einsum::nrc(vec![(node133.clone(), sv![0,1,2,3,4,5]),(node18.clone(), sv![])], sv![0,1,2,3,4,5], Some("ScalarMul".to_owned()));
    let node135 = Einsum::nrc(vec![(node98.clone(), sv![0,1,2,3,4,5,6]),(node118.clone(), sv![0,7,8,9])], sv![0,1,2,3,4,5,6,7,8,9], Some("I eps2 a0.f_q, a0.ov eps1 a0.f_k I_sample".to_owned()));
    let node136 = Rearrange::nrc(node135.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I eps2 a0.f_q, a0.ov eps1 a0.f_k I_sample_rearrange_for_add_5".to_owned()));
    let node137 = Einsum::nrc(vec![(node136.clone(), sv![0,1,2,3,4,5,6,7,8,9]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9], Some("ScalarMul".to_owned()));
    let node138 = Einsum::nrc(vec![(node103.clone(), sv![0,1,2,3]),(node125.clone(), sv![0,4,5,6,7,8,9])], sv![0,1,2,3,4,5,6,7,8,9], Some("I eps1 a0.ov eps2 a0.f_k, a0.f_q I_sample".to_owned()));
    let node139 = Rearrange::nrc(node138.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I eps1 a0.ov eps2 a0.f_k, a0.f_q I_sample_rearrange_for_add_4".to_owned()));
    let node140 = Einsum::nrc(vec![(node139.clone(), sv![0,1,2,3,4,5,6,7,8,9]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9], Some("ScalarMul".to_owned()));
    let node141 = Einsum::nrc(vec![(node134.clone(), sv![0,1,2,3,4,5]),(node18.clone(), sv![])], sv![0,1,2,3,4,5], Some("ScalarMul".to_owned()));
    let node142 = Einsum::nrc(vec![(node141.clone(), sv![0,1,2,3,4,5]),(node56.clone(), sv![5]),(node60.clone(), sv![5])], sv![2,3,0,1,4,5], Some("I k3 a0.n.y_out, embed_var, embed_var I shaped".to_owned()));
    let node143 = Einsum::nrc(vec![(node142.clone(), sv![0,1,2,3,4,5]),(node46.clone(), sv![6,7,5])], sv![2,3,0,1,6,4,7], Some("I k3 a0.f_k, embed_var, embed_var I shaped".to_owned()));
    let node144 = Einsum::nrc(vec![(node143.clone(), sv![0,1,2,3,4,5,6]),(node56.clone(), sv![3]),(node60.clone(), sv![3])], sv![0,1,2,3,4,5,6], Some("I k3 a0.f_k, a0.n.y_out, embed_var I shaped".to_owned()));
    let node145 = Einsum::nrc(vec![(node144.clone(), sv![0,1,2,3,4,5,6]),(node41.clone(), sv![7,8,3])], sv![0,1,7,2,8,4,5,6], Some("I k3 a0.f_k, a0.f_q, embed_var I shaped".to_owned()));
    let node146 = Einsum::nrc(vec![(node145.clone(), sv![0,1,2,3,4,5,6,7]),(node56.clone(), sv![1]),(node60.clone(), sv![1])], sv![0,1,2,3,4,5,6,7], Some("I k3 a0.f_k, a0.f_q, a0.n.y_out I shaped".to_owned()));
    let node147 = Einsum::nrc(vec![(node146.clone(), sv![0,1,2,3,4,5,6,7]),(node39.clone(), sv![8,9,1]),(node50.clone(), sv![8,9,10])], sv![8,0,10,2,3,4,5,6,7], Some("I k3 a0.f_k, a0.f_q, a0.n k1 a0.w.v k1 a0.w.out I perm".to_owned()));
    let node148 = Rearrange::nrc(node147.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8]], sv![sv![9],sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(4096))]), Some("I k3 a0.f_k, a0.f_q, a0.n k1 a0.w.v k1 a0.w.out I perm_sample".to_owned()));
    let node149 = Rearrange::nrc(node148.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I k3 a0.f_k, a0.f_q, a0.n k1 a0.w.v k1 a0.w.out I perm_sample_rearrange_for_add_3".to_owned()));
    let node150 = Einsum::nrc(vec![(node149.clone(), sv![0,1,2,3,4,5,6,7,8,9]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9], Some("ScalarMul".to_owned()));
    let node151 = Einsum::nrc(vec![(node104.clone(), sv![0,1,2,3]),(node113.clone(), sv![0,4,5,6,7,8,9])], sv![0,4,5,6,1,2,3,7,8,9], Some("I eps1 a0.f_q eps2 a0.f_k, a0.ov I_sample".to_owned()));
    let node152 = Rearrange::nrc(node151.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I eps1 a0.f_q eps2 a0.f_k, a0.ov I_sample_rearrange_for_add_6".to_owned()));
    let node153 = Einsum::nrc(vec![(node152.clone(), sv![0,1,2,3,4,5,6,7,8,9]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9], Some("ScalarMul".to_owned()));
    let node154 = Einsum::nrc(vec![(node103.clone(), sv![0,1,2,3]),(node104.clone(), sv![0,4,5,6]),(node118.clone(), sv![0,7,8,9])], sv![0,1,2,3,4,5,6,7,8,9], Some("I eps1 a0.ov eps1 a0.f_q eps1 a0.f_k I_sample".to_owned()));
    let node155 = Rearrange::nrc(node154.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("I eps1 a0.ov eps1 a0.f_q eps1 a0.f_k I_sample_rearrange_for_add_7".to_owned()));
    let node156 = Add::nrc(vec![node109.clone(), node123.clone(), node132.clone(), node150.clone(), node140.clone(), node137.clone(), node153.clone(), node155.clone()], Some("eps_dec_multi a0.ov a0.f_q a0.f_k_sample".to_owned()));
    let node157 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node156.clone(), sv![0,1,2,3,4,5,6,7,8,9])], sv![1,2,3,4,5,6,7,8,9], Some("eps_dec_multi a0.ov a0.f_q a0.f_k_sample_sample_expectation".to_owned()));
    let node158 = Rearrange::nrc(node157.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8]], sv![sv![9],sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(4096))]), Some("eps_dec_multi a0.ov a0.f_q a0.f_k_sample_sample_expectation_sample".to_owned()));
    let node159 = Rearrange::nrc(node158.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("eps_dec_multi a0.ov a0.f_q a0.f_k_sample_sample_expectation_sample_rearrange_for_add_1".to_owned()));
    let node160 = Rearrange::nrc(node156.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![sv![0],sv![1],sv![2],sv![3],sv![4],sv![5],sv![6],sv![7],sv![8],sv![9]], sv![OpSize::from(Some(4096)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48)),OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(48))]), Some("eps_dec_multi a0.ov a0.f_q a0.f_k_sample_rearrange_for_add_0".to_owned()));
    let node161 = Einsum::nrc(vec![(node159.clone(), sv![0,1,2,3,4,5,6,7,8,9]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9], Some("ScalarMul".to_owned()));
    let node162 = Add::nrc(vec![node160.clone(), node161.clone()], Some("eps_dec_multi a0.ov a0.f_q a0.f_k_centered_sample".to_owned()));
    let node163 = Einsum::nrc(vec![(node38.clone(), sv![0]),(node162.clone(), sv![0,1,2,3,4,5,6,7,8,9])], sv![0,1,2,3,4,5,6,7,8,9], Some("outer_sample".to_owned()));
    let node164 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node163.clone(), sv![0,1,2,3,4,5,6,7,8,9])], sv![1,2,3,4,5,6,7,8,9], Some("outer_sample_sample_expectation".to_owned()));
    let node165 = ScalarConstant::nrc(1_f64, sv![], Some("one".to_owned()));
    let node166 = ScalarConstant::nrc(0.044194173824159216_f64, sv![], Some("c.div_seq_len".to_owned()));
    let node167 = ArrayConstant::randn_seeded(sv![8], Some("a0.w.g1".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 2618613096524235656).rc();
    let node168 = ArrayConstant::randn_seeded(sv![32], Some("a0.c.inv_nelt".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 7885258334619126176).rc();
    let node169 = Einsum::nrc(vec![(node167.clone(), sv![0]),(node168.clone(), sv![1])], sv![0,1], Some("a0.w.g1op".to_owned()));
    let node170 = Add::nrc(vec![node165.clone(), node169.clone()], Some("a0.w.c1".to_owned()));
    let node171 = ArrayConstant::randn_seeded(sv![32,32], Some("a0.pp.c.score_mask".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 8724464318490575396).rc();
    let node172 = Einsum::nrc(vec![(node170.clone(), sv![0,1]),(node171.clone(), sv![1,2])], sv![1,2,0,2], Some("a0.w.c1 a0.pp.c.score_mask extra_probs_dim".to_owned()));
    let node173 = ArrayConstant::randn_seeded(sv![32,32], Some("a0.s.w.var".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 17367023124078262057).rc();
    let node174 = ScalarConstant::nrc(0.00001_f64, sv![], Some("a0.s.eps".to_owned()));
    let node175 = Add::nrc(vec![node173.clone(), node174.clone()], Some("a0.s.w.var_p_eps".to_owned()));
    let node176 = ArrayConstant::randn_seeded(sv![32,32], Some("a0.s.w.scale".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 4874878538922573945).rc();
    let node177 = GeneralFunction::new_by_name(vec![node175.clone()], "rsqrt".to_owned(), Some("a0.s.w.full_mul".to_owned())).unwrap().rc();
    let node178 = ArrayConstant::randn_seeded(sv![32,32], Some("a0.c.score_mask".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 8724464318490575396).rc();
    let node179 = Einsum::nrc(vec![(node178.clone(), sv![0,1]),(node167.clone(), sv![2]),(node168.clone(), sv![0]),(node171.clone(), sv![0,3])], sv![0,1,2,3], Some("a0.c.score_mask a0.w.g1 a0.c.inv_nelt a0.pp.c.score_mask".to_owned()));
    let node180 = Einsum::nrc(vec![(node179.clone(), sv![0,1,2,3]),(node1.clone(), sv![])], sv![0,1,2,3], Some("ScalarMul".to_owned()));
    let node181 = Add::nrc(vec![node172.clone(), node180.clone()], Some("a0.probs.w_conv".to_owned()));
    let node182 = ScalarConstant::nrc(0.14433756729740646_f64, sv![], Some("a0.c.div_head_size".to_owned()));
    let node183 = Einsum::nrc(vec![(node182.clone(), sv![]),(node176.clone(), sv![0,1]),(node177.clone(), sv![0,1]),(node166.clone(), sv![])], sv![0,1], Some("a0.probs.common_w".to_owned()));
    let node184 = Einsum::nrc(vec![(node183.clone(), sv![0,1]),(node181.clone(), sv![0,1,2,3])], sv![2,0,1,3], Some("a0.probs.mul".to_owned()));
    let node185 = Rearrange::nrc(node184.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![4],sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(8)),OpSize::from(Some(32)),OpSize::from(Some(32)),OpSize::from(Some(32)),OpSize::from(Some(4096))]), Some("a0.probs.mul_sample".to_owned()));
    let node186 = Einsum::nrc(vec![(node156.clone(), sv![0,1,2,3,1,4,5,1,6,5]),(node185.clone(), sv![0,1,4,6,2])], sv![0,4,3], Some("eps_dec_multi a0.ov a0.f_q a0.f_k_probs.mul_sample".to_owned()));
    let node187 = Rearrange::nrc(node186.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("eps_dec_multi a0.ov a0.f_q a0.f_k_probs.mul_sample_rearrange_for_add_0".to_owned()));
    let node188 = ArrayConstant::randn_seeded(sv![8,1,1], Some("a0.w.sb".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 1867266222616571753).rc();
    let node189 = Einsum::nrc(vec![(node188.clone(), sv![0,1,2]),(node171.clone(), sv![3,4])], sv![0,3,4], Some("a0.w.sb_out".to_owned()));
    let node190 = Einsum::nrc(vec![(node61.clone(), sv![0]),(node41.clone(), sv![1,2,0])], sv![1,2,0], Some("a0.w.q_s_".to_owned()));
    let node191 = Einsum::nrc(vec![(node73.clone(), sv![0,1,2,3]),(node80.clone(), sv![0,4,5,6])], sv![0,1,2,3,4,5,6], Some("a0.ov a0.f_k_sample".to_owned()));
    let node192 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node191.clone(), sv![0,1,2,3,4,5,6])], sv![1,2,3,4,5,6], Some("a0.ov a0.f_k_sample_sample_expectation".to_owned()));
    let node193 = Einsum::nrc(vec![(node192.clone(), sv![0,1,2,3,4,5]),(node18.clone(), sv![])], sv![0,1,2,3,4,5], Some("ScalarMul".to_owned()));
    let node194 = Einsum::nrc(vec![(node190.clone(), sv![0,1,2]),(node193.clone(), sv![0,3,4,0,5,1]),(node184.clone(), sv![0,6,5,3])], sv![6,2,6,4], Some("a0.w.q_s_ I k1 a0.ov a0.f_k I a0.probs.mul a0.q_direct.ident".to_owned()));
    let node195 = Einsum::nrc(vec![(node43.clone(), sv![0,1,2]),(node193.clone(), sv![0,3,4,0,5,2]),(node184.clone(), sv![0,1,5,3])], sv![1,4], Some("a0.w.pos_q_mul_probs_const".to_owned()));
    let node196 = Rearrange::nrc(node195.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.w.pos_q_mul_probs_const_sample".to_owned()));
    let node197 = Rearrange::nrc(node196.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.w.pos_q_mul_probs_const_sample_rearrange_for_add_5".to_owned()));
    let node198 = Einsum::nrc(vec![(node73.clone(), sv![0,1,2,3]),(node78.clone(), sv![0,4,5,6])], sv![0,1,2,3,4,5,6], Some("a0.ov a0.f_q_sample".to_owned()));
    let node199 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node198.clone(), sv![0,1,2,3,4,5,6])], sv![1,2,3,4,5,6], Some("a0.ov a0.f_q_sample_sample_expectation".to_owned()));
    let node200 = Einsum::nrc(vec![(node199.clone(), sv![0,1,2,3,4,5]),(node18.clone(), sv![])], sv![0,1,2,3,4,5], Some("ScalarMul".to_owned()));
    let node201 = Einsum::nrc(vec![(node47.clone(), sv![0,1,2]),(node200.clone(), sv![0,3,4,0,5,2]),(node184.clone(), sv![0,5,1,3])], sv![5,4], Some("a0.w.pos_k_mul_probs_const".to_owned()));
    let node202 = Rearrange::nrc(node201.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.w.pos_k_mul_probs_const_sample".to_owned()));
    let node203 = Rearrange::nrc(node202.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.w.pos_k_mul_probs_const_sample_rearrange_for_add_9".to_owned()));
    let node204 = Einsum::nrc(vec![(node61.clone(), sv![0]),(node50.clone(), sv![1,2,3]),(node39.clone(), sv![1,2,0])], sv![1,0,3], Some("a0.w.ov_s_".to_owned()));
    let node205 = ScalarConstant::nrc(1_f64, sv![384,1], Some("a0.direct.ov.ident_ones".to_owned()));
    let node206 = Einsum::nrc(vec![(node205.clone(), sv![0,1])], sv![1,0,0], Some("a0.direct.ov.ident".to_owned()));
    let node207 = Concat::nrc(vec![node204.clone(), node206.clone()], 0, Some("a0.w.ov_s_with_ident".to_owned()));
    let node208 = ArrayConstant::randn_seeded(sv![32,32], Some("a0.s.w.mean".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 4942623806828509992).rc();
    let node209 = Einsum::nrc(vec![(node208.clone(), sv![0,1]),(node176.clone(), sv![0,1]),(node177.clone(), sv![0,1]),(node166.clone(), sv![]),(node178.clone(), sv![0,1]),(node167.clone(), sv![2]),(node168.clone(), sv![0]),(node171.clone(), sv![0,3])], sv![2,0,3], Some("a0.s.w.mean_y_out_t1u_out".to_owned()));
    let node210 = Einsum::nrc(vec![(node208.clone(), sv![0,1]),(node176.clone(), sv![0,1]),(node177.clone(), sv![0,1]),(node166.clone(), sv![]),(node170.clone(), sv![2,0]),(node171.clone(), sv![0,1])], sv![2,0,1], Some("a0.s.w.mean_y_out_t0_out".to_owned()));
    let node211 = ArrayConstant::randn_seeded(sv![32,32], Some("a0.s.w.bias".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 15464796744735661784).rc();
    let node212 = Einsum::nrc(vec![(node211.clone(), sv![0,1]),(node166.clone(), sv![]),(node178.clone(), sv![0,1]),(node167.clone(), sv![2]),(node168.clone(), sv![0]),(node171.clone(), sv![0,3])], sv![2,0,3], Some("a0.s.w.bias_t1u_out".to_owned()));
    let node213 = Einsum::nrc(vec![(node211.clone(), sv![0,1]),(node166.clone(), sv![]),(node170.clone(), sv![2,0]),(node171.clone(), sv![0,1])], sv![2,0,1], Some("a0.s.w.bias_t0_out".to_owned()));
    let node214 = Einsum::nrc(vec![(node78.clone(), sv![0,1,2,3]),(node80.clone(), sv![0,4,5,6])], sv![0,1,2,3,4,5,6], Some("a0.f_q a0.f_k_sample".to_owned()));
    let node215 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node214.clone(), sv![0,1,2,3,4,5,6])], sv![1,2,3,4,5,6], Some("a0.f_q a0.f_k_sample_sample_expectation".to_owned()));
    let node216 = Einsum::nrc(vec![(node210.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node217 = Einsum::nrc(vec![(node212.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node218 = Einsum::nrc(vec![(node215.clone(), sv![0,1,2,3,4,5]),(node18.clone(), sv![])], sv![0,1,2,3,4,5], Some("ScalarMul".to_owned()));
    let node219 = Einsum::nrc(vec![(node218.clone(), sv![0,1,2,0,3,2]),(node184.clone(), sv![0,1,3,4])], sv![0,1,4], Some("I k1 a0.f_q a0.f_k I a0.probs.mul".to_owned()));
    let node220 = Add::nrc(vec![node213.clone(), node216.clone(), node217.clone(), node209.clone(), node189.clone(), node219.clone()], Some("a0.probs_const_all".to_owned()));
    let node221 = ScalarConstant::nrc(1_f64, sv![32,1], Some("a0.direct.k1_probs.ident_ones".to_owned()));
    let node222 = Einsum::nrc(vec![(node221.clone(), sv![0,1])], sv![1,0,0], Some("a0.direct.k1_probs.ident".to_owned()));
    let node223 = Concat::nrc(vec![node220.clone(), node222.clone()], 0, Some("a0.probs_with_ident".to_owned()));
    let node224 = Einsum::nrc(vec![(node207.clone(), sv![0,1,2]),(node223.clone(), sv![0,3,4])], sv![4,1,3,2], Some("a0.w.ov_s_with_ident a0.probs_with_ident".to_owned()));
    let node225 = Einsum::nrc(vec![(node61.clone(), sv![0]),(node46.clone(), sv![1,2,0])], sv![1,2,0], Some("a0.w.k_s_".to_owned()));
    let node226 = Einsum::nrc(vec![(node225.clone(), sv![0,1,2]),(node200.clone(), sv![0,3,4,0,5,1]),(node184.clone(), sv![0,5,6,3])], sv![6,2,5,4], Some("a0.w.k_s_ I k1 a0.ov a0.f_q I a0.probs.mul".to_owned()));
    let node227 = Einsum::nrc(vec![(node73.clone(), sv![0,1,2,3]),(node78.clone(), sv![0,4,5,6]),(node80.clone(), sv![0,7,8,9])], sv![0,1,2,3,4,5,6,7,8,9], Some("a0.ov a0.f_q a0.f_k_sample".to_owned()));
    let node228 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node227.clone(), sv![0,1,2,3,4,5,6,7,8,9])], sv![1,2,3,4,5,6,7,8,9], Some("a0.ov a0.f_q a0.f_k_sample_sample_expectation".to_owned()));
    let node229 = Einsum::nrc(vec![(node41.clone(), sv![0,1,2]),(node57.clone(), sv![2]),(node61.clone(), sv![2]),(node193.clone(), sv![0,3,4,0,5,1]),(node184.clone(), sv![0,6,5,3])], sv![6,4], Some("a0.n.w.mean_to_a_q".to_owned()));
    let node230 = Rearrange::nrc(node229.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.n.w.mean_to_a_q_sample".to_owned()));
    let node231 = Rearrange::nrc(node230.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.n.w.mean_to_a_q_sample_rearrange_for_add_4".to_owned()));
    let node232 = Einsum::nrc(vec![(node39.clone(), sv![0,1,2]),(node57.clone(), sv![2]),(node61.clone(), sv![2]),(node50.clone(), sv![0,1,3]),(node220.clone(), sv![0,4,5])], sv![4,3], Some("a0.n.w.mean_to_a_ov".to_owned()));
    let node233 = Rearrange::nrc(node232.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.n.w.mean_to_a_ov_sample".to_owned()));
    let node234 = Rearrange::nrc(node233.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.n.w.mean_to_a_ov_sample_rearrange_for_add_12".to_owned()));
    let node235 = Einsum::nrc(vec![(node46.clone(), sv![0,1,2]),(node57.clone(), sv![2]),(node61.clone(), sv![2]),(node200.clone(), sv![0,3,4,0,5,1]),(node184.clone(), sv![0,5,6,3])], sv![5,4], Some("a0.n.w.mean_to_a_k".to_owned()));
    let node236 = Rearrange::nrc(node235.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.n.w.mean_to_a_k_sample".to_owned()));
    let node237 = Rearrange::nrc(node236.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.n.w.mean_to_a_k_sample_rearrange_for_add_8".to_owned()));
    let node238 = Einsum::nrc(vec![(node41.clone(), sv![0,1,2]),(node67.clone(), sv![2]),(node193.clone(), sv![0,3,4,0,5,1]),(node184.clone(), sv![0,6,5,3])], sv![6,4], Some("a0.n.w.bias_to_a_q".to_owned()));
    let node239 = Rearrange::nrc(node238.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.n.w.bias_to_a_q_sample".to_owned()));
    let node240 = Rearrange::nrc(node239.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.n.w.bias_to_a_q_sample_rearrange_for_add_3".to_owned()));
    let node241 = Einsum::nrc(vec![(node39.clone(), sv![0,1,2]),(node67.clone(), sv![2]),(node50.clone(), sv![0,1,3]),(node220.clone(), sv![0,4,5])], sv![4,3], Some("a0.n.w.bias_to_a_ov".to_owned()));
    let node242 = Rearrange::nrc(node241.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.n.w.bias_to_a_ov_sample".to_owned()));
    let node243 = Rearrange::nrc(node242.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.n.w.bias_to_a_ov_sample_rearrange_for_add_11".to_owned()));
    let node244 = Einsum::nrc(vec![(node46.clone(), sv![0,1,2]),(node67.clone(), sv![2]),(node200.clone(), sv![0,3,4,0,5,1]),(node184.clone(), sv![0,5,6,3])], sv![5,4], Some("a0.n.w.bias_to_a_k".to_owned()));
    let node245 = Rearrange::nrc(node244.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.n.w.bias_to_a_k_sample".to_owned()));
    let node246 = Rearrange::nrc(node245.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.n.w.bias_to_a_k_sample_rearrange_for_add_7".to_owned()));
    let node247 = Add::nrc(vec![node194.clone(), node226.clone(), node224.clone()], Some("a0.direct.mul".to_owned()));
    let node248 = Rearrange::nrc(node247.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2],sv![3]], sv![sv![4],sv![0],sv![1],sv![2],sv![3]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("a0.direct.mul_sample".to_owned()));
    let node249 = Einsum::nrc(vec![(node16.clone(), sv![0,1,2]),(node248.clone(), sv![0,1,2,3,4])], sv![0,3,4], Some("a0.direct.term_sample".to_owned()));
    let node250 = Rearrange::nrc(node249.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("a0.direct.term_sample_rearrange_for_add_13".to_owned()));
    let node251 = Einsum::nrc(vec![(node228.clone(), sv![0,1,2,3,4,5,6,7,8]),(node18.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8], Some("ScalarMul".to_owned()));
    let node252 = Einsum::nrc(vec![(node234.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node253 = Einsum::nrc(vec![(node193.clone(), sv![0,1,2,0,3,4]),(node184.clone(), sv![0,5,3,1])], sv![0,5,4,2], Some("I k1 a0.ov a0.f_k I a0.probs.mul".to_owned()));
    let node254 = Einsum::nrc(vec![(node85.clone(), sv![0,1,2]),(node253.clone(), sv![0,1,2,3])], sv![1,3], Some("I k1 a0.f_q I_probs.mul".to_owned()));
    let node255 = Rearrange::nrc(node254.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("I k1 a0.f_q I_probs.mul_sample".to_owned()));
    let node256 = Rearrange::nrc(node255.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("I k1 a0.f_q I_probs.mul_sample_rearrange_for_add_6".to_owned()));
    let node257 = Einsum::nrc(vec![(node256.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node258 = Einsum::nrc(vec![(node200.clone(), sv![0,1,2,0,3,4]),(node184.clone(), sv![0,3,5,1])], sv![0,5,4,2,3], Some("I k1 a0.ov a0.f_q I a0.probs.mul".to_owned()));
    let node259 = Einsum::nrc(vec![(node101.clone(), sv![0,1,2]),(node258.clone(), sv![0,1,2,3,4])], sv![4,3], Some("I k1 a0.f_k I_probs.mul".to_owned()));
    let node260 = Rearrange::nrc(node259.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("I k1 a0.f_k I_probs.mul_sample".to_owned()));
    let node261 = Rearrange::nrc(node260.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("I k1 a0.f_k I_probs.mul_sample_rearrange_for_add_10".to_owned()));
    let node262 = Einsum::nrc(vec![(node261.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node263 = Einsum::nrc(vec![(node90.clone(), sv![0,1,2]),(node219.clone(), sv![0,3,1])], sv![3,2], Some("I k1 a0.w.v k1 a0.n k1 a0.w.out I perm_probs.mul".to_owned()));
    let node264 = Rearrange::nrc(node263.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("I k1 a0.w.v k1 a0.n k1 a0.w.out I perm_probs.mul_sample".to_owned()));
    let node265 = Rearrange::nrc(node264.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("I k1 a0.w.v k1 a0.n k1 a0.w.out I perm_probs.mul_sample_rearrange_for_add_2".to_owned()));
    let node266 = Einsum::nrc(vec![(node265.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node267 = Einsum::nrc(vec![(node231.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node268 = Einsum::nrc(vec![(node237.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node269 = Einsum::nrc(vec![(node251.clone(), sv![0,1,2,0,3,4,0,5,4]),(node184.clone(), sv![0,3,5,1])], sv![3,2], Some("I k1 a0.ov a0.f_q a0.f_k I_probs.mul".to_owned()));
    let node270 = Rearrange::nrc(node269.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("I k1 a0.ov a0.f_q a0.f_k I_probs.mul_sample".to_owned()));
    let node271 = Rearrange::nrc(node270.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("I k1 a0.ov a0.f_q a0.f_k I_probs.mul_sample_rearrange_for_add_1".to_owned()));
    let node272 = Add::nrc(vec![node187.clone(), node271.clone(), node266.clone(), node240.clone(), node267.clone(), node197.clone(), node257.clone(), node246.clone(), node268.clone(), node203.clone(), node262.clone(), node243.clone(), node252.clone(), node250.clone()], Some("m0.inp_sample".to_owned()));
    let node273 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node272.clone(), sv![0,1,2])], sv![1,2], Some("m0.inp_sample_sample_expectation".to_owned()));
    let node274 = Rearrange::nrc(node273.clone(), RearrangeSpec::new(sv![sv![0],sv![1]], sv![sv![2],sv![0],sv![1]], sv![OpSize::from(Some(32)),OpSize::from(Some(384)),OpSize::from(Some(4096))]), Some("m0.inp_sample_sample_expectation_sample".to_owned()));
    let node275 = Rearrange::nrc(node274.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("m0.inp_sample_sample_expectation_sample_rearrange_for_add_1".to_owned()));
    let node276 = Rearrange::nrc(node272.clone(), RearrangeSpec::new(sv![sv![0],sv![1],sv![2]], sv![sv![0],sv![1],sv![2]], sv![OpSize::from(Some(4096)),OpSize::from(Some(32)),OpSize::from(Some(384))]), Some("m0.inp_sample_rearrange_for_add_0".to_owned()));
    let node277 = Einsum::nrc(vec![(node275.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node278 = Add::nrc(vec![node276.clone(), node277.clone()], Some("m0.inp_centered_sample".to_owned()));
    let node279 = Einsum::nrc(vec![(node278.clone(), sv![0,1,2]),(node278.clone(), sv![0,3,4]),(node38.clone(), sv![0]),(node162.clone(), sv![0,5,6,7,8,9,10,11,12,13])], sv![0,1,2,3,4,5,6,7,8,9,10,11,12,13], Some("outer_sample".to_owned()));
    let node280 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node279.clone(), sv![0,1,2,3,4,5,6,7,8,9,10,11,12,13])], sv![1,2,3,4,5,6,7,8,9,10,11,12,13], Some("outer_sample_sample_expectation".to_owned()));
    let node281 = Einsum::nrc(vec![(node278.clone(), sv![0,1,2]),(node278.clone(), sv![0,3,4])], sv![0,1,2,3,4], Some("outer_sample".to_owned()));
    let node282 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node281.clone(), sv![0,1,2,3,4])], sv![1,2,3,4], Some("outer_sample_sample_expectation".to_owned()));
    let node283 = Einsum::nrc(vec![(node278.clone(), sv![0,1,2]),(node162.clone(), sv![0,3,4,5,6,7,8,9,10,11])], sv![0,1,2,3,4,5,6,7,8,9,10,11], Some("outer_sample".to_owned()));
    let node284 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node283.clone(), sv![0,1,2,3,4,5,6,7,8,9,10,11])], sv![1,2,3,4,5,6,7,8,9,10,11], Some("outer_sample_sample_expectation".to_owned()));
    let node285 = Einsum::nrc(vec![(node278.clone(), sv![0,1,2]),(node38.clone(), sv![0])], sv![0,1,2], Some("outer_sample".to_owned()));
    let node286 = Einsum::nrc(vec![(node20.clone(), sv![0]),(node285.clone(), sv![0,1,2])], sv![1,2], Some("outer_sample_sample_expectation".to_owned()));
    let node287 = Add::nrc(vec![node286.clone()], Some("I k2 is_is_var, m0.inp I_decompose".to_owned()));
    let node288 = Einsum::nrc(vec![(node287.clone(), sv![0,1]),(node18.clone(), sv![])], sv![0,1], Some("ScalarMul".to_owned()));
    let node289 = Add::nrc(vec![node284.clone()], Some("I k2 eps_dec_multi a0.ov a0.f_q a0.f_k, m0.inp I_decompose".to_owned()));
    let node290 = Einsum::nrc(vec![(node289.clone(), sv![0,1,2,3,4,5,6,7,8,9,10]),(node18.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9,10], Some("ScalarMul".to_owned()));
    let node291 = Einsum::nrc(vec![(node288.clone(), sv![0,1]),(node290.clone(), sv![2,3,4,5,6,7,8,9,10,11,12])], sv![2,3,0,1,4,5,6,7,8,9,10,11,12], Some("outer".to_owned()));
    let node292 = Einsum::nrc(vec![(node288.clone(), sv![0,1]),(node290.clone(), sv![2,3,4,5,6,7,8,9,10,11,12])], sv![0,1,2,3,4,5,6,7,8,9,10,11,12], Some("outer".to_owned()));
    let node293 = Add::nrc(vec![node282.clone()], Some("I k2 m0.inp, m0.inp I_decompose".to_owned()));
    let node294 = Einsum::nrc(vec![(node293.clone(), sv![0,1,2,3]),(node18.clone(), sv![])], sv![0,1,2,3], Some("ScalarMul".to_owned()));
    let node295 = Add::nrc(vec![node164.clone()], Some("I k2 eps_dec_multi a0.ov a0.f_q a0.f_k, is_is_var I_decompose".to_owned()));
    let node296 = Einsum::nrc(vec![(node295.clone(), sv![0,1,2,3,4,5,6,7,8]),(node18.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8], Some("ScalarMul".to_owned()));
    let node297 = Einsum::nrc(vec![(node294.clone(), sv![0,1,2,3]),(node296.clone(), sv![4,5,6,7,8,9,10,11,12])], sv![2,3,0,1,4,5,6,7,8,9,10,11,12], Some("outer".to_owned()));
    let node298 = ArrayConstant::randn_seeded(sv![384,768], Some("m1.w.w1".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 1331227591797635193).rc();
    let node299 = ArrayConstant::randn_seeded(sv![384], Some("m1.n.w.var".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 7096362628065231700).rc();
    let node300 = ScalarConstant::nrc(0.00001_f64, sv![], Some("m1.n.eps".to_owned()));
    let node301 = Add::nrc(vec![node299.clone(), node300.clone()], Some("m1.n.w.var_p_eps".to_owned()));
    let node302 = ArrayConstant::randn_seeded(sv![384], Some("m1.n.w.scale".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 1636268016078253515).rc();
    let node303 = GeneralFunction::new_by_name(vec![node301.clone()], "rsqrt".to_owned(), Some("m1.n.w.full_mul".to_owned())).unwrap().rc();
    let node304 = Einsum::nrc(vec![(node302.clone(), sv![0]),(node303.clone(), sv![0]),(node298.clone(), sv![0,1])], sv![0,1], Some("m1.w.w1_s".to_owned()));
    let node305 = ArrayConstant::randn_seeded(sv![384,768], Some("m1.w.w0".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 13185449622808679385).rc();
    let node306 = Einsum::nrc(vec![(node302.clone(), sv![0]),(node303.clone(), sv![0]),(node305.clone(), sv![0,1])], sv![0,1], Some("m1.w.w0_s".to_owned()));
    let node307 = ArrayConstant::randn_seeded(sv![768,384], Some("m1.w.out".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 9981532348689177629).rc();
    let node308 = ArrayConstant::randn_seeded(sv![384,60], Some("m1.o.1".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 12085267234228853601).rc();
    let node309 = ArrayConstant::randn_seeded(sv![384,60], Some("m1.o.0".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 8166564426074829334).rc();
    let node310 = Einsum::nrc(vec![(node309.clone(), sv![0,1]),(node308.clone(), sv![2,1])], sv![0,2,1], Some("m1.o.outer".to_owned()));
    let node311 = Einsum::nrc(vec![(node310.clone(), sv![0,1,2]),(node310.clone(), sv![3,4,2])], sv![0,1,3,4], Some("m1.o.low_rank_id".to_owned()));
    let node312 = ArrayConstant::randn_seeded(sv![32,4], Some("m0.o.direct_pos.dirs".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 510979872823372479).rc();
    let node313 = ArrayConstant::randn_seeded(sv![32,384,384], Some("m0.direct.mul_estimed".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 8587193936154975863).rc();
    let node314 = Einsum::nrc(vec![(node313.clone(), sv![0,1,2]),(node312.clone(), sv![0,3])], sv![1,2,3], Some("m0.direct.mul_estimed m0.o.direct_pos.dirs".to_owned()));
    let node315 = Einsum::nrc(vec![(node314.clone(), sv![0,1,2]),(node312.clone(), sv![3,2])], sv![3,0,1], Some("m0.direct.mul_estimed_low_rank_id".to_owned()));
    let node316 = ArrayConstant::randn_seeded(sv![8,48,384], Some("a1.w.k".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 346631027691184275).rc();
    let node317 = ArrayConstant::randn_seeded(sv![384], Some("a1.n.w.var".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 1425219787154012984).rc();
    let node318 = ScalarConstant::nrc(0.00001_f64, sv![], Some("a1.n.eps".to_owned()));
    let node319 = Add::nrc(vec![node317.clone(), node318.clone()], Some("a1.n.w.var_p_eps".to_owned()));
    let node320 = ArrayConstant::randn_seeded(sv![384], Some("a1.n.w.scale".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 2062098532837674558).rc();
    let node321 = GeneralFunction::new_by_name(vec![node319.clone()], "rsqrt".to_owned(), Some("a1.n.w.full_mul".to_owned())).unwrap().rc();
    let node322 = Einsum::nrc(vec![(node320.clone(), sv![0]),(node321.clone(), sv![0]),(node316.clone(), sv![1,2,0])], sv![0,1,2], Some("a1.w.k_s".to_owned()));
    let node323 = ArrayConstant::randn_seeded(sv![8,48], Some("I k1 a1.f_q I_last_estimed".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 14108817834917482463).rc();
    let node324 = Einsum::nrc(vec![(node322.clone(), sv![0,1,2]),(node323.clone(), sv![1,2])], sv![0,1], Some("a1.w.k_s I k1 a1.f_q I_last_estimed".to_owned()));
    let node325 = Index::nrc(node324.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::new_tensor_randint_seeded(2, 8, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 7534083475485511395)] ), Some("idx a1.w.k_s I k1 a1.f_q I_last_estimed".to_owned()));
    let node326 = ArrayConstant::randn_seeded(sv![32,32], Some("a1.s.w.scale".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 3798037696282213373).rc();
    let node327 = Index::nrc(node326.clone(), TensorIndex ( vec![TensorAxisIndex::Single(31), TensorAxisIndex::Slice(Slice { start:None, stop:None })] ), Some("idx a1.s.w.scale".to_owned()));
    let node328 = ArrayConstant::randn_seeded(sv![32,32], Some("a1.s.w.var".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 4873730304271440433).rc();
    let node329 = ScalarConstant::nrc(0.00001_f64, sv![], Some("a1.s.eps".to_owned()));
    let node330 = Add::nrc(vec![node328.clone(), node329.clone()], Some("a1.s.w.var_p_eps".to_owned()));
    let node331 = GeneralFunction::new_by_name(vec![node330.clone()], "rsqrt".to_owned(), Some("a1.s.w.full_mul".to_owned())).unwrap().rc();
    let node332 = Index::nrc(node331.clone(), TensorIndex ( vec![TensorAxisIndex::Single(31), TensorAxisIndex::Slice(Slice { start:None, stop:None })] ), Some("idx a1.s.w.full_mul".to_owned()));
    let node333 = ArrayConstant::randn_seeded(sv![32,32], Some("a1.pp.c.score_mask".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 8724464318490575396).rc();
    let node334 = Index::nrc(node333.clone(), TensorIndex ( vec![TensorAxisIndex::Single(31), TensorAxisIndex::Slice(Slice { start:None, stop:None })] ), Some("idx a1.pp.c.score_mask".to_owned()));
    let node335 = ArrayConstant::randn_seeded(sv![32,32], Some("a1.c.score_mask".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 8724464318490575396).rc();
    let node336 = Index::nrc(node335.clone(), TensorIndex ( vec![TensorAxisIndex::Single(31), TensorAxisIndex::Slice(Slice { start:None, stop:None })] ), Some("idx a1.c.score_mask".to_owned()));
    let node337 = ArrayConstant::randn_seeded(sv![32], Some("a1.c.inv_nelt".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 7885258334619126176).rc();
    let node338 = Index::nrc(node337.clone(), TensorIndex ( vec![TensorAxisIndex::Single(31)] ), Some("idx a1.c.inv_nelt".to_owned()));
    let node339 = ArrayConstant::randn_seeded(sv![8,48,384], Some("a1.w.v".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 8687698313936163101).rc();
    let node340 = ArrayConstant::randn_seeded(sv![8,48,384], Some("a1.w.out".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 15478159692831585940).rc();
    let node341 = Einsum::nrc(vec![(node320.clone(), sv![0]),(node321.clone(), sv![0]),(node339.clone(), sv![1,2,0]),(node340.clone(), sv![1,2,3])], sv![0,1,3], Some("a1.w.ov_s".to_owned()));
    let node342 = ArrayConstant::randn_seeded(sv![2,2], Some("a1.o.k4_k.r_inv".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 607277245665302608).rc();
    let node343 = Einsum::nrc(vec![(node325.clone(), sv![0,1]),(node342.clone(), sv![1,2])], sv![0,2], Some("a1.o.k4_k.qr".to_owned()));
    let node344 = Einsum::nrc(vec![(node343.clone(), sv![0,1]),(node343.clone(), sv![2,1])], sv![0,2], Some("a1.o.k4_k.low_rank_id".to_owned()));
    let node345 = Einsum::nrc(vec![(node322.clone(), sv![0,1,2]),(node344.clone(), sv![0,3])], sv![3,1,2], Some("a1.w.k_s_low_rank_id".to_owned()));
    let node346 = ArrayConstant::randn_seeded(sv![8], Some("a1.w.g1".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 3291412235451830005).rc();
    let node347 = Einsum::nrc(vec![(node346.clone(), sv![0]),(node338.clone(), sv![])], sv![0], Some("a1.w.g1op_last".to_owned()));
    let node348 = Add::nrc(vec![node165.clone(), node347.clone()], Some("a1.w.c1_last".to_owned()));
    let node349 = Einsum::nrc(vec![(node348.clone(), sv![0]),(node334.clone(), sv![1])], sv![1,0,1], Some("a1.w.c1 a1.pp.c.score_mask extra_probs_dim_last".to_owned()));
    let node350 = Einsum::nrc(vec![(node336.clone(), sv![0]),(node346.clone(), sv![1]),(node338.clone(), sv![]),(node334.clone(), sv![2])], sv![0,1,2], Some("a1.c.score_mask a1.w.g1 a1.c.inv_nelt a1.pp.c.score_mask_last".to_owned()));
    let node351 = Einsum::nrc(vec![(node350.clone(), sv![0,1,2]),(node1.clone(), sv![])], sv![0,1,2], Some("ScalarMul".to_owned()));
    let node352 = Add::nrc(vec![node349.clone(), node351.clone()], Some("a1.probs.w_conv_last".to_owned()));
    let node353 = ScalarConstant::nrc(0.14433756729740646_f64, sv![], Some("a1.c.div_head_size".to_owned()));
    let node354 = Einsum::nrc(vec![(node353.clone(), sv![]),(node327.clone(), sv![0]),(node332.clone(), sv![0]),(node166.clone(), sv![]),(node352.clone(), sv![0,1,2])], sv![1,2,0], Some("a1.probs.w_conv_last_s".to_owned()));
    let node355 = ArrayConstant::randn_seeded(sv![32,5], Some("a1.o.direct_seq.dirs".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 4488996256317125712).rc();
    let node356 = ArrayConstant::randn_seeded(sv![32,384,384], Some("a1.direct.mul_last_estimed".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 17342475573750503546).rc();
    let node357 = Einsum::nrc(vec![(node356.clone(), sv![0,1,2]),(node355.clone(), sv![0,3])], sv![1,2,3], Some("a1.direct.mul_last_estimed_proj".to_owned()));
    let node358 = Einsum::nrc(vec![(node357.clone(), sv![0,1,2]),(node355.clone(), sv![3,2])], sv![3,0,1], Some("a1.direct.mul_last_estimed_low_rank_id".to_owned()));
    let node359 = Einsum::nrc(vec![(node291.clone(), sv![0,1,2,3,4,5,6,7,8,9,10,11,12]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9,10,11,12], Some("ScalarMul".to_owned()));
    let node360 = Einsum::nrc(vec![(node292.clone(), sv![0,1,2,3,4,5,6,7,8,9,10,11,12]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9,10,11,12], Some("ScalarMul".to_owned()));
    let node361 = Einsum::nrc(vec![(node297.clone(), sv![0,1,2,3,4,5,6,7,8,9,10,11,12]),(node1.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9,10,11,12], Some("ScalarMul".to_owned()));
    let node362 = Add::nrc(vec![node280.clone(), node361.clone(), node359.clone(), node360.clone()], Some("I k4 eps_dec_multi a0.ov a0.f_q a0.f_k, is_is_var, m0.inp, m0.inp I_decompose".to_owned()));
    let node363 = Einsum::nrc(vec![(node362.clone(), sv![0,1,2,3,4,5,6,7,8,9,10,11,12]),(node18.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9,10,11,12], Some("ScalarMul".to_owned()));
    let node364 = Einsum::nrc(vec![(node363.clone(), sv![0,1,2,3,4,5,6,7,8,9,10,11,12]),(node18.clone(), sv![])], sv![0,1,2,3,4,5,6,7,8,9,10,11,12], Some("ScalarMul".to_owned()));
    let node365 = Einsum::nrc(vec![(node364.clone(), sv![0,1,2,3,4,5,6,4,7,8,4,9,8]),(node182.clone(), sv![]),(node176.clone(), sv![7,9]),(node177.clone(), sv![7,9]),(node166.clone(), sv![]),(node181.clone(), sv![7,9,4,5])], sv![2,3,0,1,7,6], Some("I k4 eps_dec_multi a0.ov a0.f_q a0.f_k_probs.mul, is_is_var, m0.inp, m0.inp I shaped".to_owned()));
    let node366 = Einsum::nrc(vec![(node365.clone(), sv![0,1,2,3,4,5]),(node315.clone(), sv![4,5,6]),(node315.clone(), sv![0,1,7]),(node315.clone(), sv![2,3,8])], sv![0,7,4,6,2,8], Some("I k4 a1.inp, a1.inp, is_is_var, m0.direct.term I shaped_ablation".to_owned()));
    let node367 = Einsum::nrc(vec![(node366.clone(), sv![0,1,2,3,4,5]),(node345.clone(), sv![5,6,7]),(node341.clone(), sv![3,8,9]),(node323.clone(), sv![10,11])], sv![8,2,9,10,11,6,4,7,0,1], Some("I k3 I eps2 a1.f_k, a1.ov I_eps, a1.inp, is_is_var k1 I k1 a1.f_q I I perm_last_ablation".to_owned()));
    let node368 = Einsum::nrc(vec![(node367.clone(), sv![0,1,2,3,4,5,6,7,8,9]),(node358.clone(), sv![8,9,10])], sv![10,0,1,2,3,4,5,6,7], Some("I k3 a1.direct.term, eps_dec_multi a1.ov a1.f_q a1.f_k, is_is_var I shaped_last_ablation".to_owned()));
    let node369 = Einsum::nrc(vec![(node368.clone(), sv![0,1,2,3,1,4,1,5,4]),(node354.clone(), sv![1,2,5])], sv![0,3], Some("I k3 eps_dec_multi a1.ov a1.f_q a1.f_k_probs.mul, is_is_var, m1.inp I shaped_last_ablation".to_owned()));
    let node370 = Einsum::nrc(vec![(node367.clone(), sv![0,1,2,0,3,0,4,3,5,6]),(node354.clone(), sv![0,1,4])], sv![2,5,6], Some("I k3 a1.inp, eps_dec_multi a1.ov a1.f_q a1.f_k_probs.mul, is_is_var I shaped_last_ablation".to_owned()));
    let node371 = Einsum::nrc(vec![(node370.clone(), sv![0,1,2]),(node358.clone(), sv![1,2,3])], sv![0,3], Some("I k3 a1.direct.term, is_is_var, m1.inp I shaped_last_ablation".to_owned()));
    let node372 = Add::nrc(vec![node369.clone(), node371.clone()], Some("I k3 is_is_var, m1.inp, m1.inp I_last_ablation".to_owned()));
    let node373 = Einsum::nrc(vec![(node372.clone(), sv![0,1]),(node311.clone(), sv![0,1,2,3]),(node306.clone(), sv![3,4]),(node304.clone(), sv![2,4]),(node307.clone(), sv![4,5])], sv![5], Some("m1.k3_term_ablation".to_owned()));
    let node374 = ArrayConstant::randn_seeded(sv![384,384], Some("m1.direct.mul_last_estimed".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 13464987358980279361).rc();
    let node375 = ArrayConstant::randn_seeded(sv![8,48,384], Some("a1.w.q".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 7589589553252889926).rc();
    let node376 = Einsum::nrc(vec![(node320.clone(), sv![0]),(node321.clone(), sv![0]),(node375.clone(), sv![1,2,0])], sv![0,1,2], Some("a1.w.q_s".to_owned()));
    let node377 = Index::nrc(node376.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(0), TensorAxisIndex::new_tensor_randint_seeded(45, 48, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 17285065714422425717)] ), Some("idx a1.w.q_s".to_owned()));
    let node378 = Index::nrc(node376.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(2), TensorAxisIndex::new_tensor_randint_seeded(46, 48, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 2096462694089307547)] ), Some("idx a1.w.q_s".to_owned()));
    let node379 = Index::nrc(node376.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(4), TensorAxisIndex::new_tensor_randint_seeded(29, 48, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 13022025685427672725)] ), Some("idx a1.w.q_s".to_owned()));
    let node380 = Einsum::nrc(vec![(node341.clone(), sv![0,1,2]),(node374.clone(), sv![2,3]),(node11.clone(), sv![3])], sv![0,1], Some("a1.w.ov_to_out".to_owned()));
    let node381 = Index::nrc(node380.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(2)] ), Some("idx a1.w.ov_to_out".to_owned()));
    let node382 = Index::nrc(node380.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(4)] ), Some("idx a1.w.ov_to_out".to_owned()));
    let node383 = Index::nrc(node380.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(0)] ), Some("idx a1.w.ov_to_out".to_owned()));
    let node384 = Index::nrc(node322.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(0), TensorAxisIndex::new_tensor_randint_seeded(45, 48, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 17285065714422425717)] ), Some("idx a1.w.k_s".to_owned()));
    let node385 = Index::nrc(node322.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(2), TensorAxisIndex::new_tensor_randint_seeded(46, 48, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 2096462694089307547)] ), Some("idx a1.w.k_s".to_owned()));
    let node386 = Index::nrc(node322.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(4), TensorAxisIndex::new_tensor_randint_seeded(29, 48, TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 13022025685427672725)] ), Some("idx a1.w.k_s".to_owned()));
    let node387 = Index::nrc(node366.clone(), TensorIndex ( vec![TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Single(31), TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Slice(Slice { start:None, stop:None }), TensorAxisIndex::Slice(Slice { start:None, stop:None })] ), Some("idx I k4 a1.inp, a1.inp, is_is_var, m0.direct.term I shaped_ablation".to_owned()));
    let node388 = ArrayConstant::randn_seeded(sv![120,120], Some("a1.o.k4.r_inv".to_owned()), TorchDeviceDtypeOp { device: Some("cuda:0".to_owned()), dtype: Some("float32".to_owned()) }, 9135304363382130478).rc();
    let node389 = Concat::nrc(vec![node377.clone(), node378.clone(), node379.clone()], 1, Some("a1.o.k4.q_dirs".to_owned()));
    let node390 = Rearrange::nrc(node382.clone(), RearrangeSpec::new(sv![sv![0]], sv![sv![0],sv![1]], sv![OpSize::from(Some(384)),OpSize::from(Some(29))]), Some("a1.o.k4.ov_out_dirs_4".to_owned()));
    let node391 = Rearrange::nrc(node381.clone(), RearrangeSpec::new(sv![sv![0]], sv![sv![0],sv![1]], sv![OpSize::from(Some(384)),OpSize::from(Some(46))]), Some("a1.o.k4.ov_out_dirs_2".to_owned()));
    let node392 = Rearrange::nrc(node383.clone(), RearrangeSpec::new(sv![sv![0]], sv![sv![0],sv![1]], sv![OpSize::from(Some(384)),OpSize::from(Some(45))]), Some("a1.o.k4.ov_out_dirs_0".to_owned()));
    let node393 = Concat::nrc(vec![node392.clone(), node391.clone(), node390.clone()], 1, Some("a1.o.k4.ov_out_dirs".to_owned()));
    let node394 = Concat::nrc(vec![node384.clone(), node385.clone(), node386.clone()], 1, Some("a1.o.k4.k_dirs".to_owned()));
    let node395 = Einsum::nrc(vec![(node389.clone(), sv![0,1]),(node394.clone(), sv![2,1]),(node393.clone(), sv![3,1])], sv![0,2,3,1], Some("a1.o.k4.outer".to_owned()));
    let node396 = Einsum::nrc(vec![(node395.clone(), sv![0,1,2,3]),(node388.clone(), sv![3,4])], sv![0,1,2,4], Some("a1.o.k4.qr".to_owned()));
    let node397 = Einsum::nrc(vec![(node396.clone(), sv![0,1,2,3]),(node396.clone(), sv![4,5,6,3])], sv![0,1,2,4,5,6], Some("a1.o.k4.low_rank_id".to_owned()));
    let node398 = Einsum::nrc(vec![(node387.clone(), sv![0,1,2,3,4]),(node397.clone(), sv![2,4,1,5,6,7])], sv![0,7,5,3,6], Some("I k4 a1.inp, a1.inp, a1.inp, is_is_var I_last_low_rank_id_ablation".to_owned()));
    let node399 = Einsum::nrc(vec![(node398.clone(), sv![0,1,2,3,4]),(node322.clone(), sv![4,5,6]),(node376.clone(), sv![2,7,8]),(node341.clone(), sv![1,9,10])], sv![9,0,10,7,8,5,3,6], Some("I k2 I eps3 a1.f_k, a1.f_q, a1.ov I_eps, is_is_var I shaped_last_ablation".to_owned()));
    let node400 = Einsum::nrc(vec![(node399.clone(), sv![0,1,2,0,3,0,4,3]),(node354.clone(), sv![0,1,4])], sv![2], Some("I k2 eps_dec_multi a1.ov a1.f_q a1.f_k_probs.mul, is_is_var I shaped_last_ablation".to_owned()));
    let node401 = Einsum::nrc(vec![(node400.clone(), sv![0]),(node374.clone(), sv![0,1])], sv![1], Some("I k2 is_is_var, m1.direct.term I shaped_perm_last_ablation".to_owned()));
    let node402 = Add::nrc(vec![node373.clone(), node401.clone()], Some("I k2 final.n.sub_mean, is_is_var I_last_ablation".to_owned()));
    let node403 = Einsum::nrc(vec![(node402.clone(), sv![0]),(node11.clone(), sv![0])], sv![], Some("I k2 is_is_var, logit_diff I_ablation".to_owned()));
    let node404 = Rearrange::nrc(node403.clone(), RearrangeSpec::new(sv![], sv![sv![]], sv![]), Some("flatten".to_owned()));
    Concat::nrc(vec![node404.clone()], 0, Some("flat_concat".to_owned()))
}
];
    let mut group = c.benchmark_group("all");
    // group.measurement_time(Duration::from_millis(10000));
    group.sample_size(10);
    // group.bench_function("einsum_opt", |b| {
    //     b.iter(|| {
    //         for _i in 0..1 {
    //             test_einsum_specs(black_box(&einsumspecs));
    //         }
    //     })
    // });
    group.bench_function("notebook_examples", |b| {
        b.iter(|| {
            for _i in 0..1 {
                test_notebook_examples(black_box(circuits))
            }
        })
    });
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);

#[bench]
fn the_benchmarks(_b: &mut Bencher) {
    benches();

    Criterion::default().configure_from_args().final_summary();
}
