import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

muscle_ICRP110_MFP = np.array([
	[5.0000000000E+03, 1.8004593877E+00, 8.0403024727E+00, 2.3008910585E-02, 2.2654566797E-02, 3.4366473977E-01],
	[5.0050000000E+03, 1.8025147396E+00, 8.0354506555E+00, 2.3078078836E-02, 2.2721906126E-02, 3.4392231916E-01],
	[5.0100000000E+03, 1.8045703821E+00, 8.0306066062E+00, 2.3147385350E-02, 2.2789375992E-02, 3.4417960813E-01],
	[5.0150000000E+03, 1.8066263149E+00, 8.0257703047E+00, 2.3216830263E-02, 2.2856976508E-02, 3.4443660741E-01],
	[5.0200000000E+03, 1.8086825377E+00, 8.0209417309E+00, 2.3286413713E-02, 2.2924707784E-02, 3.4469331770E-01],
	[5.0250000000E+03, 1.8107390502E+00, 8.0161208647E+00, 2.3356135836E-02, 2.2992569931E-02, 3.4494973971E-01],
	[5.0300000000E+03, 1.8127958524E+00, 8.0113076862E+00, 2.3425996771E-02, 2.3060563061E-02, 3.4520587416E-01],
	[5.0350000000E+03, 1.8148529438E+00, 8.0065021755E+00, 2.3495996652E-02, 2.3128687285E-02, 3.4546172175E-01],
	[5.0400000000E+03, 1.8169103243E+00, 8.0017043128E+00, 2.3566135618E-02, 2.3196942714E-02, 3.4571728319E-01],
	[5.0450000000E+03, 1.8189679936E+00, 7.9969140783E+00, 2.3636413806E-02, 2.3265329458E-02, 3.4597255917E-01],
	[5.0500000000E+03, 1.8210259515E+00, 7.9921314524E+00, 2.3706831353E-02, 2.3333847630E-02, 3.4622755039E-01],
	[5.0550000000E+03, 1.8230841977E+00, 7.9873564155E+00, 2.3777388395E-02, 2.3402497339E-02, 3.4648225756E-01],
	[5.0600000000E+03, 1.8251427320E+00, 7.9825889480E+00, 2.3848085069E-02, 2.3471278697E-02, 3.4673668136E-01],
	[5.0650000000E+03, 1.8272015541E+00, 7.9778290306E+00, 2.3918921514E-02, 2.3540191814E-02, 3.4699082248E-01],
	[5.0700000000E+03, 1.8292606637E+00, 7.9730766437E+00, 2.3989897864E-02, 2.3609236802E-02, 3.4724468161E-01],
	[5.0750000000E+03, 1.8313200607E+00, 7.9683317681E+00, 2.4061014259E-02, 2.3678413770E-02, 3.4749825945E-01],
	[5.0800000000E+03, 1.8333797449E+00, 7.9635943845E+00, 2.4132270833E-02, 2.3747722828E-02, 3.4775155666E-01],
	[5.0850000000E+03, 1.8354530485E+00, 7.9589443033E+00, 2.4203667726E-02, 2.3817167049E-02, 3.4800457394E-01],
	[5.0900000000E+03, 1.8375279506E+00, 7.9543092438E+00, 2.4275205072E-02, 2.3886743897E-02, 3.4825731195E-01],
	[5.0950000000E+03, 1.8396031577E+00, 7.9496814306E+00, 2.4346883011E-02, 2.3956453199E-02, 3.4850977138E-01],
	[5.1000000000E+03, 1.8416786694E+00, 7.9450608451E+00, 2.4418701677E-02, 2.4026295063E-02, 3.4876195289E-01],
	[5.1050000000E+03, 1.8437544856E+00, 7.9404474691E+00, 2.4490661209E-02, 2.4096269601E-02, 3.4901385717E-01],
	[5.1100000000E+03, 1.8458306059E+00, 7.9358412843E+00, 2.4562761743E-02, 2.4166376922E-02, 3.4926548487E-01],
	[5.1150000000E+03, 1.8479070301E+00, 7.9312422723E+00, 2.4635003416E-02, 2.4236617138E-02, 3.4951683666E-01],
	[5.1200000000E+03, 1.8499837579E+00, 7.9266504151E+00, 2.4707386366E-02, 2.4306990357E-02, 3.4976791320E-01],
	[5.1250000000E+03, 1.8520607892E+00, 7.9220656946E+00, 2.4779910729E-02, 2.4377496691E-02, 3.5001871516E-01],
	[5.1300000000E+03, 1.8541381236E+00, 7.9174880927E+00, 2.4852576641E-02, 2.4448136250E-02, 3.5026924319E-01],
	[5.1350000000E+03, 1.8562157609E+00, 7.9129175914E+00, 2.4925384241E-02, 2.4518909142E-02, 3.5051949795E-01],
	[5.1400000000E+03, 1.8582937009E+00, 7.9083541728E+00, 2.4998333665E-02, 2.4589815479E-02, 3.5076948009E-01],
	[5.1450000000E+03, 1.8603719432E+00, 7.9037978191E+00, 2.5071425050E-02, 2.4660855370E-02, 3.5101919027E-01],
	[5.1500000000E+03, 1.8624504877E+00, 7.8992485125E+00, 2.5144658532E-02, 2.4732028924E-02, 3.5126862912E-01],
	[5.1550000000E+03, 1.8645293341E+00, 7.8947062353E+00, 2.5218034249E-02, 2.4803336252E-02, 3.5151779731E-01],
	[5.1600000000E+03, 1.8666084822E+00, 7.8901709698E+00, 2.5291552338E-02, 2.4874777464E-02, 3.5176669547E-01],
	[5.1650000000E+03, 1.8686958038E+00, 7.8856893352E+00, 2.5365212936E-02, 2.4946354537E-02, 3.5201532424E-01],
	[5.1700000000E+03, 1.8707897811E+00, 7.8812521029E+00, 2.5439016179E-02, 2.5018067243E-02, 3.5226368426E-01],
	[5.1750000000E+03, 1.8728840773E+00, 7.8768216530E+00, 2.5512962204E-02, 2.5089914191E-02, 3.5251177617E-01],
	[5.1800000000E+03, 1.8749786922E+00, 7.8723979686E+00, 2.5587051149E-02, 2.5161895491E-02, 3.5275960061E-01],
	[5.1850000000E+03, 1.8770736253E+00, 7.8679810329E+00, 2.5661283150E-02, 2.5234011253E-02, 3.5300715821E-01],
	[5.1900000000E+03, 1.8791688766E+00, 7.8635708291E+00, 2.5735658344E-02, 2.5306261586E-02, 3.5325444959E-01],
	[5.1950000000E+03, 1.8812644457E+00, 7.8591673405E+00, 2.5810176868E-02, 2.5378646599E-02, 3.5350147539E-01],
	[5.2000000000E+03, 1.8833603324E+00, 7.8547705504E+00, 2.5884838859E-02, 2.5451166402E-02, 3.5374823623E-01],
	[5.2050000000E+03, 1.8854565364E+00, 7.8503804422E+00, 2.5959644454E-02, 2.5523821103E-02, 3.5399473273E-01],
	[5.2100000000E+03, 1.8875530574E+00, 7.8459969993E+00, 2.6034593790E-02, 2.5596610812E-02, 3.5424096552E-01],
	[5.2150000000E+03, 1.8896498953E+00, 7.8416202052E+00, 2.6109687003E-02, 2.5669535638E-02, 3.5448693521E-01],
	[5.2200000000E+03, 1.8917470497E+00, 7.8372500435E+00, 2.6184924231E-02, 2.5742595690E-02, 3.5473264242E-01],
	[5.2250000000E+03, 1.8938445205E+00, 7.8328864978E+00, 2.6260305610E-02, 2.5815791077E-02, 3.5497808777E-01],
	[5.2300000000E+03, 1.8959423072E+00, 7.8285295517E+00, 2.6335831278E-02, 2.5889121907E-02, 3.5522327187E-01],
	[5.2350000000E+03, 1.8980404098E+00, 7.8241791890E+00, 2.6411501370E-02, 2.5962588290E-02, 3.5546819533E-01],
	[5.2400000000E+03, 1.9001388278E+00, 7.8198353934E+00, 2.6487316025E-02, 2.6036190334E-02, 3.5571285876E-01],
	[5.2450000000E+03, 1.9022375612E+00, 7.8154981489E+00, 2.6563275378E-02, 2.6109928148E-02, 3.5595726275E-01],
	[5.2500000000E+03, 1.9043494883E+00, 7.8112428991E+00, 2.6639379568E-02, 2.6183805122E-02, 3.5620140793E-01],
	[5.2550000000E+03, 1.9064626733E+00, 7.8069994352E+00, 2.6715628730E-02, 2.6257818350E-02, 3.5644529488E-01],
	[5.2600000000E+03, 1.9085761902E+00, 7.8027623089E+00, 2.6792023001E-02, 2.6331967705E-02, 3.5668892421E-01],
	[5.2650000000E+03, 1.9106900387E+00, 7.7985315047E+00, 2.6868562518E-02, 2.6406253296E-02, 3.5693229652E-01],
	[5.2700000000E+03, 1.9128042185E+00, 7.7943070073E+00, 2.6945247419E-02, 2.6480675230E-02, 3.5717541240E-01],
	[5.2750000000E+03, 1.9149187295E+00, 7.7900888011E+00, 2.7022077840E-02, 2.6555233617E-02, 3.5741827244E-01],
	[5.2800000000E+03, 1.9170335713E+00, 7.7858768710E+00, 2.7099053918E-02, 2.6629928565E-02, 3.5766087724E-01],
	[5.2850000000E+03, 1.9191487437E+00, 7.7816712016E+00, 2.7176175789E-02, 2.6704760182E-02, 3.5790322738E-01],
	[5.2900000000E+03, 1.9212642464E+00, 7.7774717778E+00, 2.7253443591E-02, 2.6779728576E-02, 3.5814532346E-01],
	[5.2950000000E+03, 1.9233800791E+00, 7.7732785844E+00, 2.7330857460E-02, 2.6854833855E-02, 3.5838716605E-01],
	[5.3000000000E+03, 1.9254962417E+00, 7.7690916062E+00, 2.7408417533E-02, 2.6930076128E-02, 3.5862875575E-01],
	[5.3050000000E+03, 1.9276127338E+00, 7.7649108281E+00, 2.7486123948E-02, 2.7005455501E-02, 3.5887009312E-01],
	[5.3100000000E+03, 1.9297295551E+00, 7.7607362353E+00, 2.7563976840E-02, 2.7080972085E-02, 3.5911117876E-01],
	[5.3150000000E+03, 1.9318467055E+00, 7.7565678127E+00, 2.7641976347E-02, 2.7156625985E-02, 3.5935201324E-01],
	[5.3200000000E+03, 1.9339641847E+00, 7.7524055454E+00, 2.7720122606E-02, 2.7232417309E-02, 3.5959259713E-01],
	[5.3250000000E+03, 1.9360819923E+00, 7.7482494185E+00, 2.7798415753E-02, 2.7308346167E-02, 3.5983293104E-01],
	[5.3300000000E+03, 1.9382007219E+00, 7.7441028680E+00, 2.7876855925E-02, 2.7384412826E-02, 3.6007301571E-01],
	[5.3350000000E+03, 1.9403325804E+00, 7.7400366977E+00, 2.7955443259E-02, 2.7460620733E-02, 3.6031285180E-01],
	[5.3400000000E+03, 1.9424647834E+00, 7.7359764685E+00, 2.8034177891E-02, 2.7536966527E-02, 3.6055243996E-01],
	[5.3450000000E+03, 1.9445973307E+00, 7.7319221662E+00, 2.8113059959E-02, 2.7613450317E-02, 3.6079178084E-01],
	[5.3500000000E+03, 1.9467302220E+00, 7.7278737765E+00, 2.8192089600E-02, 2.7690072210E-02, 3.6103087510E-01],
	[5.3550000000E+03, 1.9488634569E+00, 7.7238312853E+00, 2.8271266950E-02, 2.7766832312E-02, 3.6126972336E-01],
	[5.3600000000E+03, 1.9509970354E+00, 7.7197946785E+00, 2.8350592145E-02, 2.7843730732E-02, 3.6150832629E-01],
	[5.3650000000E+03, 1.9531309570E+00, 7.7157639422E+00, 2.8430065324E-02, 2.7920767577E-02, 3.6174668452E-01],
	[5.3700000000E+03, 1.9552652215E+00, 7.7117390622E+00, 2.8509686622E-02, 2.7997942954E-02, 3.6198479869E-01],
	[5.3750000000E+03, 1.9573998287E+00, 7.7077200247E+00, 2.8589456176E-02, 2.8075256970E-02, 3.6222266943E-01],
	[5.3800000000E+03, 1.9595347783E+00, 7.7037068157E+00, 2.8669374123E-02, 2.8152709733E-02, 3.6246029739E-01],
	[5.3850000000E+03, 1.9616700700E+00, 7.6996994214E+00, 2.8749440601E-02, 2.8230301349E-02, 3.6269768318E-01],
	[5.3900000000E+03, 1.9638057035E+00, 7.6956978279E+00, 2.8829655744E-02, 2.8308031925E-02, 3.6293482744E-01],
	[5.3950000000E+03, 1.9659416787E+00, 7.6917020216E+00, 2.8910019692E-02, 2.8385901568E-02, 3.6317173080E-01],
	[5.4000000000E+03, 1.9680779952E+00, 7.6877119886E+00, 2.8990532579E-02, 2.8463910385E-02, 3.6340839387E-01],
	[5.4050000000E+03, 1.9702146528E+00, 7.6837277153E+00, 2.9071194543E-02, 2.8542058483E-02, 3.6364481729E-01],
	[5.4100000000E+03, 1.9723516512E+00, 7.6797491881E+00, 2.9152005721E-02, 2.8620345968E-02, 3.6388100167E-01],
	[5.4150000000E+03, 1.9744889901E+00, 7.6757763934E+00, 2.9232966250E-02, 2.8698772947E-02, 3.6411694763E-01],
	[5.4200000000E+03, 1.9766381431E+00, 7.6718753465E+00, 2.9314076265E-02, 2.8777342887E-02, 3.6435265577E-01],
	[5.4250000000E+03, 1.9787891581E+00, 7.6679885396E+00, 2.9395335905E-02, 2.8856053007E-02, 3.6458812673E-01],
	[5.4300000000E+03, 1.9809405291E+00, 7.6641072798E+00, 2.9476745305E-02, 2.8934902974E-02, 3.6482336110E-01],
	[5.4350000000E+03, 1.9830922558E+00, 7.6602315541E+00, 2.9558304603E-02, 2.9013892894E-02, 3.6505835949E-01],
	[5.4400000000E+03, 1.9852443379E+00, 7.6563613496E+00, 2.9640013935E-02, 2.9093022873E-02, 3.6529312251E-01],
	[5.4450000000E+03, 1.9873967751E+00, 7.6524966532E+00, 2.9721873438E-02, 2.9172293019E-02, 3.6552765076E-01],
	[5.4500000000E+03, 1.9895495672E+00, 7.6486374522E+00, 2.9803883249E-02, 2.9251703436E-02, 3.6576194484E-01],
	[5.4550000000E+03, 1.9917027140E+00, 7.6447837336E+00, 2.9886043504E-02, 2.9331254232E-02, 3.6599600536E-01],
	[5.4600000000E+03, 1.9938562151E+00, 7.6409354847E+00, 2.9968354340E-02, 2.9410945512E-02, 3.6622983291E-01],
	[5.4650000000E+03, 1.9960100702E+00, 7.6370926927E+00, 3.0050815894E-02, 2.9490777383E-02, 3.6646342808E-01],
	[5.4700000000E+03, 1.9981642792E+00, 7.6332553449E+00, 3.0133428302E-02, 2.9570749950E-02, 3.6669679146E-01],
	[5.4750000000E+03, 2.0003188417E+00, 7.6294234286E+00, 3.0216191702E-02, 2.9650863320E-02, 3.6692992366E-01],
	[5.4800000000E+03, 2.0024737575E+00, 7.6255969312E+00, 3.0299450627E-02, 2.9731449204E-02, 3.6716282524E-01],
	[5.4850000000E+03, 2.0046290263E+00, 7.6217758400E+00, 3.0383140296E-02, 2.9812445131E-02, 3.6739549681E-01],
	[5.4900000000E+03, 2.0067846479E+00, 7.6179601426E+00, 3.0466984228E-02, 2.9893584843E-02, 3.6762793894E-01],
	[5.4950000000E+03, 2.0089406219E+00, 7.6141498263E+00, 3.0550982567E-02, 2.9974868450E-02, 3.6786015222E-01],
	[5.5000000000E+03, 2.0110969482E+00, 7.6103448788E+00, 3.0635135455E-02, 3.0056296063E-02, 3.6809213722E-01],
	[5.5050000000E+03, 2.0132592452E+00, 7.6065774021E+00, 3.0719443033E-02, 3.0137869556E-02, 3.6832389452E-01],
	[5.5100000000E+03, 2.0154288502E+00, 7.6028548648E+00, 3.0803905446E-02, 3.0219589479E-02, 3.6855542470E-01],
	[5.5150000000E+03, 2.0175988222E+00, 7.5991375232E+00, 3.0888522835E-02, 3.0301453772E-02, 3.6878672834E-01],
	[5.5200000000E+03, 2.0197691609E+00, 7.5954253654E+00, 3.0973295343E-02, 3.0383462547E-02, 3.6901780599E-01],
	[5.5250000000E+03, 2.0219398661E+00, 7.5917183795E+00, 3.1058223112E-02, 3.0465615913E-02, 3.6924865824E-01],
	[5.5300000000E+03, 2.0241109375E+00, 7.5880165535E+00, 3.1143306284E-02, 3.0547913980E-02, 3.6947928564E-01],
	[5.5350000000E+03, 2.0262823749E+00, 7.5843198757E+00, 3.1228545003E-02, 3.0630356858E-02, 3.6970968877E-01],
	[5.5400000000E+03, 2.0284541779E+00, 7.5806283343E+00, 3.1313939411E-02, 3.0712944657E-02, 3.6993986818E-01],
	[5.5450000000E+03, 2.0306263463E+00, 7.5769419174E+00, 3.1399489649E-02, 3.0795677488E-02, 3.7016982444E-01],
	[5.5500000000E+03, 2.0327988798E+00, 7.5732606133E+00, 3.1485195862E-02, 3.0878555459E-02, 3.7039955811E-01],
	[5.5550000000E+03, 2.0349717782E+00, 7.5695844105E+00, 3.1571058191E-02, 3.0961578680E-02, 3.7062906974E-01],
	[5.5600000000E+03, 2.0371450412E+00, 7.5659132971E+00, 3.1657076778E-02, 3.1044747262E-02, 3.7085835989E-01],
	[5.5650000000E+03, 2.0393186685E+00, 7.5622472617E+00, 3.1743251766E-02, 3.1128061313E-02, 3.7108742911E-01],
	[5.5700000000E+03, 2.0414926599E+00, 7.5585862926E+00, 3.1829583298E-02, 3.1211520944E-02, 3.7131627795E-01],
	[5.5750000000E+03, 2.0436670151E+00, 7.5549303782E+00, 3.1916071516E-02, 3.1295126263E-02, 3.7154490697E-01],
	[5.5800000000E+03, 2.0458417338E+00, 7.5512795072E+00, 3.2002716563E-02, 3.1378877380E-02, 3.7177331670E-01],
	[5.5850000000E+03, 2.0480168158E+00, 7.5476336679E+00, 3.2089518581E-02, 3.1462774404E-02, 3.7200150770E-01],
	[5.5900000000E+03, 2.0501922607E+00, 7.5439928491E+00, 3.2176477712E-02, 3.1546817445E-02, 3.7222948050E-01],
	[5.5950000000E+03, 2.0523769368E+00, 7.5404073799E+00, 3.2263594100E-02, 3.1631009604E-02, 3.7245723566E-01],
	[5.6000000000E+03, 2.0545652715E+00, 7.5368454343E+00, 3.2350867886E-02, 3.1715349135E-02, 3.7268477370E-01],
	[5.6050000000E+03, 2.0567539833E+00, 7.5332883478E+00, 3.2438299213E-02, 3.1799835045E-02, 3.7291209517E-01],
	[5.6100000000E+03, 2.0589430719E+00, 7.5297361097E+00, 3.2525888223E-02, 3.1884467442E-02, 3.7313920060E-01],
	[5.6150000000E+03, 2.0611325373E+00, 7.5261887088E+00, 3.2613635059E-02, 3.1969246437E-02, 3.7336609052E-01],
	[5.6200000000E+03, 2.0633223790E+00, 7.5226461345E+00, 3.2701539864E-02, 3.2054172138E-02, 3.7359276548E-01],
	[5.6250000000E+03, 2.0655125967E+00, 7.5191083758E+00, 3.2789602780E-02, 3.2139244653E-02, 3.7381922599E-01],
	[5.6300000000E+03, 2.0677031904E+00, 7.5155754219E+00, 3.2877823949E-02, 3.2224464091E-02, 3.7404547259E-01],
	[5.6350000000E+03, 2.0698941595E+00, 7.5120472620E+00, 3.2966203514E-02, 3.2309830562E-02, 3.7427150580E-01],
	[5.6400000000E+03, 2.0720855040E+00, 7.5085238854E+00, 3.3054741618E-02, 3.2395344173E-02, 3.7449732615E-01],
	[5.6450000000E+03, 2.0742772234E+00, 7.5050052813E+00, 3.3143438402E-02, 3.2481005033E-02, 3.7472293416E-01],
	[5.6500000000E+03, 2.0764693176E+00, 7.5014914391E+00, 3.3232294009E-02, 3.2566813252E-02, 3.7494833043E-01],
	[5.6550000000E+03, 2.0786617863E+00, 7.4979823481E+00, 3.3321308583E-02, 3.2652768936E-02, 3.7517351556E-01],
	[5.6600000000E+03, 2.0808546292E+00, 7.4944779977E+00, 3.3410482264E-02, 3.2738872195E-02, 3.7539849015E-01],
	[5.6650000000E+03, 2.0830478461E+00, 7.4909783774E+00, 3.3499815197E-02, 3.2825123137E-02, 3.7562325475E-01],
	[5.6700000000E+03, 2.0852414366E+00, 7.4874834765E+00, 3.3589307522E-02, 3.2911521870E-02, 3.7584780993E-01],
	[5.6750000000E+03, 2.0874354006E+00, 7.4839932845E+00, 3.3678959383E-02, 3.2998068502E-02, 3.7607215628E-01],
	[5.6800000000E+03, 2.0896297377E+00, 7.4805077910E+00, 3.3768770923E-02, 3.3084763141E-02, 3.7629629434E-01],
	[5.6850000000E+03, 2.0918329818E+00, 7.4770751763E+00, 3.3858742283E-02, 3.3171608989E-02, 3.7652022468E-01],
	[5.6900000000E+03, 2.0940398124E+00, 7.4736652147E+00, 3.3948873606E-02, 3.3258604252E-02, 3.7674394787E-01],
	[5.6950000000E+03, 2.0962470298E+00, 7.4702598014E+00, 3.4039165035E-02, 3.3345747882E-02, 3.7696746446E-01],
	[5.7000000000E+03, 2.0984546336E+00, 7.4668589263E+00, 3.4129616712E-02, 3.3433039987E-02, 3.7719077502E-01],
	[5.7050000000E+03, 2.1006626236E+00, 7.4634625793E+00, 3.4220228780E-02, 3.3520480674E-02, 3.7741388009E-01],
	[5.7100000000E+03, 2.1028709995E+00, 7.4600707504E+00, 3.4311001380E-02, 3.3608070052E-02, 3.7763678024E-01],
	[5.7150000000E+03, 2.1050797610E+00, 7.4566834298E+00, 3.4401934656E-02, 3.3695808227E-02, 3.7785947600E-01],
	[5.7200000000E+03, 2.1072889079E+00, 7.4533006074E+00, 3.4493028750E-02, 3.3783695308E-02, 3.7808196794E-01],
	[5.7250000000E+03, 2.1094984399E+00, 7.4499222734E+00, 3.4584283804E-02, 3.3871731402E-02, 3.7830425660E-01],
	[5.7300000000E+03, 2.1117083567E+00, 7.4465484179E+00, 3.4675699962E-02, 3.3959916617E-02, 3.7852634252E-01],
	[5.7350000000E+03, 2.1139186581E+00, 7.4431790311E+00, 3.4767318240E-02, 3.4048290262E-02, 3.7874822625E-01],
	[5.7400000000E+03, 2.1161293437E+00, 7.4398141031E+00, 3.4859144696E-02, 3.4136858107E-02, 3.7896990833E-01],
	[5.7450000000E+03, 2.1183404134E+00, 7.4364536242E+00, 3.4951133122E-02, 3.4225575802E-02, 3.7919138930E-01],
	[5.7500000000E+03, 2.1205518668E+00, 7.4330975847E+00, 3.5043283662E-02, 3.4314443457E-02, 3.7941266969E-01],
	[5.7550000000E+03, 2.1227637036E+00, 7.4297459747E+00, 3.5135596460E-02, 3.4403461179E-02, 3.7963375005E-01],
	[5.7600000000E+03, 2.1249759238E+00, 7.4263987847E+00, 3.5228071659E-02, 3.4492629076E-02, 3.7985463090E-01],
	[5.7650000000E+03, 2.1271885268E+00, 7.4230560050E+00, 3.5320709402E-02, 3.4581947256E-02, 3.8007531278E-01],
	[5.7700000000E+03, 2.1294015125E+00, 7.4197176259E+00, 3.5413509834E-02, 3.4671415827E-02, 3.8029579622E-01],
	[5.7750000000E+03, 2.1316198004E+00, 7.4164113222E+00, 3.5506473098E-02, 3.4761036813E-02, 3.8051608174E-01],
	[5.7800000000E+03, 2.1338448769E+00, 7.4131453144E+00, 3.5599599337E-02, 3.4850810922E-02, 3.8073616987E-01],
	[5.7850000000E+03, 2.1360703490E+00, 7.4098835669E+00, 3.5692888695E-02, 3.4940735782E-02, 3.8095606114E-01],
	[5.7900000000E+03, 2.1382962165E+00, 7.4066260707E+00, 3.5786341315E-02, 3.5030811500E-02, 3.8117575607E-01],
	[5.7950000000E+03, 2.1405224791E+00, 7.4033728165E+00, 3.5879957342E-02, 3.5121038183E-02, 3.8139525517E-01],
	[5.8000000000E+03, 2.1427491366E+00, 7.4001237951E+00, 3.5973736917E-02, 3.5211415939E-02, 3.8161455897E-01],
	[5.8050000000E+03, 2.1449761885E+00, 7.3968789974E+00, 3.6067680186E-02, 3.5301944876E-02, 3.8183366799E-01],
	[5.8100000000E+03, 2.1472036348E+00, 7.3936384143E+00, 3.6161787291E-02, 3.5392625100E-02, 3.8205258274E-01],
	[5.8150000000E+03, 2.1494314751E+00, 7.3904020367E+00, 3.6256058376E-02, 3.5483456719E-02, 3.8227130373E-01],
	[5.8200000000E+03, 2.1516597091E+00, 7.3871698554E+00, 3.6350493585E-02, 3.5574439840E-02, 3.8248983147E-01],
	[5.8250000000E+03, 2.1538883367E+00, 7.3839418616E+00, 3.6445093061E-02, 3.5665574570E-02, 3.8270816647E-01],
	[5.8300000000E+03, 2.1561173574E+00, 7.3807180460E+00, 3.6539856948E-02, 3.5756861016E-02, 3.8292630925E-01],
	[5.8350000000E+03, 2.1583467711E+00, 7.3774983999E+00, 3.6634785389E-02, 3.5848299285E-02, 3.8314426031E-01],
	[5.8400000000E+03, 2.1605765774E+00, 7.3742829141E+00, 3.6729878528E-02, 3.5939889484E-02, 3.8336202014E-01],
	[5.8450000000E+03, 2.1628067762E+00, 7.3710715799E+00, 3.6825136508E-02, 3.6031631720E-02, 3.8357958927E-01],
	[5.8500000000E+03, 2.1650373671E+00, 7.3678643882E+00, 3.6920559473E-02, 3.6123526099E-02, 3.8379696817E-01],
	[5.8550000000E+03, 2.1672683499E+00, 7.3646613302E+00, 3.7016147566E-02, 3.6215572727E-02, 3.8401415737E-01],
	[5.8600000000E+03, 2.1694997243E+00, 7.3614623971E+00, 3.7111900931E-02, 3.6307771713E-02, 3.8423115734E-01],
	[5.8650000000E+03, 2.1717314901E+00, 7.3582675799E+00, 3.7207819712E-02, 3.6400123161E-02, 3.8444796859E-01],
	[5.8700000000E+03, 2.1739728882E+00, 7.3551287107E+00, 3.7303904051E-02, 3.6492631059E-02, 3.8466459162E-01],
	[5.8750000000E+03, 2.1762163481E+00, 7.3520031485E+00, 3.7400154093E-02, 3.6585292363E-02, 3.8488102691E-01],
	[5.8800000000E+03, 2.1784602116E+00, 7.3488815717E+00, 3.7496569982E-02, 3.6678106487E-02, 3.8509727495E-01],
	[5.8850000000E+03, 2.1807044786E+00, 7.3457639718E+00, 3.7593151860E-02, 3.6771073537E-02, 3.8531333624E-01],
	[5.8900000000E+03, 2.1829491487E+00, 7.3426503405E+00, 3.7689899871E-02, 3.6864193619E-02, 3.8552921125E-01],
	[5.8950000000E+03, 2.1851942218E+00, 7.3395406693E+00, 3.7786814159E-02, 3.6957466839E-02, 3.8574490049E-01],
	[5.9000000000E+03, 2.1874396974E+00, 7.3364349499E+00, 3.7883894867E-02, 3.7050893304E-02, 3.8596040442E-01],
	[5.9050000000E+03, 2.1896855754E+00, 7.3333331738E+00, 3.7981142139E-02, 3.7144473119E-02, 3.8617572354E-01],
	[5.9100000000E+03, 2.1919318555E+00, 7.3302353327E+00, 3.8078556118E-02, 3.7238206391E-02, 3.8639085832E-01],
	[5.9150000000E+03, 2.1941785374E+00, 7.3271414184E+00, 3.8176136949E-02, 3.7332093225E-02, 3.8660580925E-01],
	[5.9200000000E+03, 2.1964256208E+00, 7.3240514225E+00, 3.8273884773E-02, 3.7426133727E-02, 3.8682057680E-01],
	[5.9250000000E+03, 2.1986731055E+00, 7.3209653367E+00, 3.8371799736E-02, 3.7520328003E-02, 3.8703516144E-01],
	[5.9300000000E+03, 2.2009209912E+00, 7.3178831528E+00, 3.8469881980E-02, 3.7614676158E-02, 3.8724956365E-01],
	[5.9350000000E+03, 2.2031692777E+00, 7.3148048626E+00, 3.8568131650E-02, 3.7709178298E-02, 3.8746378390E-01],
	[5.9400000000E+03, 2.2054179646E+00, 7.3117304580E+00, 3.8666548888E-02, 3.7803834529E-02, 3.8767782267E-01],
	[5.9450000000E+03, 2.2076670517E+00, 7.3086599306E+00, 3.8765133838E-02, 3.7898644955E-02, 3.8789168043E-01],
	[5.9500000000E+03, 2.2099165388E+00, 7.3055932725E+00, 3.8863886644E-02, 3.7993609682E-02, 3.8810535763E-01],
	[5.9550000000E+03, 2.2121664256E+00, 7.3025304754E+00, 3.8962807450E-02, 3.8088728816E-02, 3.8831885465E-01],
	[5.9600000000E+03, 2.2144167118E+00, 7.2994715313E+00, 3.9061896398E-02, 3.8184002462E-02, 3.8853217190E-01],
	[5.9650000000E+03, 2.2166774779E+00, 7.2964729022E+00, 3.9161153633E-02, 3.8279435284E-02, 3.8874530988E-01],
	[5.9700000000E+03, 2.2189390569E+00, 7.2934802649E+00, 3.9260579297E-02, 3.8375023047E-02, 3.8895826911E-01],
	[5.9750000000E+03, 2.2212010472E+00, 7.2904913589E+00, 3.9360173535E-02, 3.8470765676E-02, 3.8917105008E-01],
	[5.9800000000E+03, 2.2234634483E+00, 7.2875061763E+00, 3.9459936491E-02, 3.8566663274E-02, 3.8938365330E-01],
	[5.9850000000E+03, 2.2257262601E+00, 7.2845247095E+00, 3.9559868306E-02, 3.8662715948E-02, 3.8959607927E-01],
	[5.9900000000E+03, 2.2279894822E+00, 7.2815469506E+00, 3.9659969126E-02, 3.8758923801E-02, 3.8980832850E-01],
	[5.9950000000E+03, 2.2302531144E+00, 7.2785728920E+00, 3.9760239094E-02, 3.8855286940E-02, 3.9002040148E-01],
	[6.0000000000E+03, 2.2325171565E+00, 7.2756025261E+00, 3.9860678353E-02, 3.8951805467E-02, 3.9023229870E-01],
	[6.0050000000E+03, 2.2347816081E+00, 7.2726358451E+00, 3.9961756655E-02, 3.9048927888E-02, 3.9044402067E-01],
	[6.0100000000E+03, 2.2370464690E+00, 7.2696728414E+00, 4.0063006520E-02, 3.9146207727E-02, 3.9065556787E-01],
	[6.0150000000E+03, 2.2393117389E+00, 7.2667135075E+00, 4.0164428097E-02, 3.9243645091E-02, 3.9086694079E-01],
	[6.0200000000E+03, 2.2415774175E+00, 7.2637578356E+00, 4.0266021531E-02, 3.9341240089E-02, 3.9107813993E-01],
	[6.0250000000E+03, 2.2438435047E+00, 7.2608058183E+00, 4.0367786971E-02, 3.9438992827E-02, 3.9128916578E-01],
	[6.0300000000E+03, 2.2461100001E+00, 7.2578574481E+00, 4.0469724564E-02, 3.9536903412E-02, 3.9150001881E-01],
	[6.0350000000E+03, 2.2483769034E+00, 7.2549127173E+00, 4.0571834457E-02, 3.9634971952E-02, 3.9171069951E-01],
	[6.0400000000E+03, 2.2506442144E+00, 7.2519716185E+00, 4.0674116797E-02, 3.9733198554E-02, 3.9192120837E-01],
	[6.0450000000E+03, 2.2529119329E+00, 7.2490341442E+00, 4.0776571731E-02, 3.9831583324E-02, 3.9213154587E-01],
	[6.0500000000E+03, 2.2551800585E+00, 7.2461002869E+00, 4.0879199408E-02, 3.9930126369E-02, 3.9234171249E-01],
	[6.0550000000E+03, 2.2574485910E+00, 7.2431700393E+00, 4.0981999973E-02, 4.0028827797E-02, 3.9255170870E-01],
	[6.0600000000E+03, 2.2597253263E+00, 7.2402868838E+00, 4.1084973576E-02, 4.0127691507E-02, 3.9276153498E-01],
	[6.0650000000E+03, 2.2620047879E+00, 7.2374201247E+00, 4.1188120361E-02, 4.0226714972E-02, 3.9297119181E-01],
	[6.0700000000E+03, 2.2642846677E+00, 7.2345568617E+00, 4.1291440478E-02, 4.0325897179E-02, 3.9318067965E-01],
	[6.0750000000E+03, 2.2665649652E+00, 7.2316970875E+00, 4.1394934074E-02, 4.0425238234E-02, 3.9338999899E-01],
	[6.0800000000E+03, 2.2688456804E+00, 7.2288407952E+00, 4.1498601294E-02, 4.0524738243E-02, 3.9359915028E-01],
	[6.0850000000E+03, 2.2711268129E+00, 7.2259879776E+00, 4.1602442288E-02, 4.0624397314E-02, 3.9380813400E-01],
	[6.0900000000E+03, 2.2734083624E+00, 7.2231386277E+00, 4.1706457203E-02, 4.0724215552E-02, 3.9401695062E-01],
	[6.0950000000E+03, 2.2756903286E+00, 7.2202927383E+00, 4.1810646184E-02, 4.0824193065E-02, 3.9422560060E-01],
	[6.1000000000E+03, 2.2779727114E+00, 7.2174503025E+00, 4.1915009381E-02, 4.0924329957E-02, 3.9443408440E-01],
	[6.1050000000E+03, 2.2802555104E+00, 7.2146113132E+00, 4.2019546940E-02, 4.1024626336E-02, 3.9464240248E-01],
	[6.1100000000E+03, 2.2825387254E+00, 7.2117757634E+00, 4.2124259008E-02, 4.1125082307E-02, 3.9485055531E-01],
	[6.1150000000E+03, 2.2848223561E+00, 7.2089436462E+00, 4.2229145733E-02, 4.1225697976E-02, 3.9505854335E-01],
	[6.1200000000E+03, 2.2871064023E+00, 7.2061149546E+00, 4.2334207263E-02, 4.1326473450E-02, 3.9526636704E-01],
	[6.1250000000E+03, 2.2893908637E+00, 7.2032896816E+00, 4.2439443743E-02, 4.1427408834E-02, 3.9547402686E-01],
	[6.1300000000E+03, 2.2916757399E+00, 7.2004678204E+00, 4.2544855323E-02, 4.1528504233E-02, 3.9568152325E-01],
	[6.1350000000E+03, 2.2939610308E+00, 7.1976493640E+00, 4.2650442149E-02, 4.1629759754E-02, 3.9588885666E-01],
	[6.1400000000E+03, 2.2962467362E+00, 7.1948343056E+00, 4.2756204368E-02, 4.1731175502E-02, 3.9609602754E-01],
	[6.1450000000E+03, 2.2985328556E+00, 7.1920226383E+00, 4.2862142128E-02, 4.1832751583E-02, 3.9630303636E-01],
	[6.1500000000E+03, 2.3008193889E+00, 7.1892143553E+00, 4.2968255576E-02, 4.1934488101E-02, 3.9650988355E-01],
	[6.1550000000E+03, 2.3031089941E+00, 7.1864241839E+00, 4.3074544859E-02, 4.2036386553E-02, 3.9671656956E-01],
	[6.1600000000E+03, 2.3054061223E+00, 7.1836766960E+00, 4.3181010126E-02, 4.2138449391E-02, 3.9692309483E-01],
	[6.1650000000E+03, 2.3077036751E+00, 7.1809324864E+00, 4.3287651522E-02, 4.2240673024E-02, 3.9712945982E-01],
	[6.1700000000E+03, 2.3100016521E+00, 7.1781915485E+00, 4.3394469196E-02, 4.2343057556E-02, 3.9733566496E-01],
	[6.1750000000E+03, 2.3123000533E+00, 7.1754538759E+00, 4.3501463295E-02, 4.2445603092E-02, 3.9754171070E-01],
	[6.1800000000E+03, 2.3145988782E+00, 7.1727194620E+00, 4.3608633966E-02, 4.2548309739E-02, 3.9774759747E-01],
	[6.1850000000E+03, 2.3168981266E+00, 7.1699883002E+00, 4.3715981356E-02, 4.2651177600E-02, 3.9795332572E-01],
	[6.1900000000E+03, 2.3191977983E+00, 7.1672603841E+00, 4.3823505613E-02, 4.2754206780E-02, 3.9815889587E-01],
	[6.1950000000E+03, 2.3214978929E+00, 7.1645357073E+00, 4.3931206885E-02, 4.2857397385E-02, 3.9836430837E-01],
	[6.2000000000E+03, 2.3237984103E+00, 7.1618142632E+00, 4.4039085318E-02, 4.2960749520E-02, 3.9856956365E-01],
	[6.2050000000E+03, 2.3260993502E+00, 7.1590960454E+00, 4.4147141060E-02, 4.3064263288E-02, 3.9877466214E-01],
	[6.2100000000E+03, 2.3284007122E+00, 7.1563810475E+00, 4.4255374258E-02, 4.3167938794E-02, 3.9897960428E-01],
	[6.2150000000E+03, 2.3307024962E+00, 7.1536692631E+00, 4.4363785060E-02, 4.3271776144E-02, 3.9918439049E-01],
	[6.2200000000E+03, 2.3330047019E+00, 7.1509606858E+00, 4.4472373613E-02, 4.3375775441E-02, 3.9938902120E-01],
	[6.2250000000E+03, 2.3353073289E+00, 7.1482553093E+00, 4.4581140064E-02, 4.3479936790E-02, 3.9959349684E-01],
	[6.2300000000E+03, 2.3376103772E+00, 7.1455531272E+00, 4.4690084561E-02, 4.3584260296E-02, 3.9979781783E-01],
	[6.2350000000E+03, 2.3399138463E+00, 7.1428541331E+00, 4.4799207251E-02, 4.3688746061E-02, 4.0000198461E-01],
	[6.2400000000E+03, 2.3422177360E+00, 7.1401583208E+00, 4.4908508281E-02, 4.3793394191E-02, 4.0020599759E-01],
	[6.2450000000E+03, 2.3445220461E+00, 7.1374656839E+00, 4.5017987800E-02, 4.3898204789E-02, 4.0040985719E-01],
	[6.2500000000E+03, 2.3468267763E+00, 7.1347762162E+00, 4.5127645953E-02, 4.4003177959E-02, 4.0061356384E-01],
	[6.2550000000E+03, 2.3491362526E+00, 7.1321137417E+00, 4.5237482889E-02, 4.4108316242E-02, 4.0081711795E-01],
	[6.2600000000E+03, 2.3514512493E+00, 7.1294824187E+00, 4.5347498755E-02, 4.4213620204E-02, 4.0102051995E-01],
	[6.2650000000E+03, 2.3537666763E+00, 7.1268541661E+00, 4.5457693699E-02, 4.4319087090E-02, 4.0122377025E-01],
	[6.2700000000E+03, 2.3560825333E+00, 7.1242289780E+00, 4.5568067867E-02, 4.4424717006E-02, 4.0142686926E-01],
	[6.2750000000E+03, 2.3583988202E+00, 7.1216068483E+00, 4.5678621407E-02, 4.4530510054E-02, 4.0162981740E-01],
	[6.2800000000E+03, 2.3607155365E+00, 7.1189877711E+00, 4.5789354467E-02, 4.4636466338E-02, 4.0183261508E-01],
	[6.2850000000E+03, 2.3630326822E+00, 7.1163717404E+00, 4.5900267193E-02, 4.4742585962E-02, 4.0203526271E-01],
	[6.2900000000E+03, 2.3653502568E+00, 7.1137587502E+00, 4.6011359734E-02, 4.4848869030E-02, 4.0223776071E-01],
	[6.2950000000E+03, 2.3676682602E+00, 7.1111487945E+00, 4.6122632237E-02, 4.4955315643E-02, 4.0244010948E-01],
	[6.3000000000E+03, 2.3699866921E+00, 7.1085418675E+00, 4.6234084848E-02, 4.5061925907E-02, 4.0264230943E-01],
	[6.3050000000E+03, 2.3723055522E+00, 7.1059379633E+00, 4.6345717716E-02, 4.5168699923E-02, 4.0284436096E-01],
	[6.3100000000E+03, 2.3746248403E+00, 7.1033370758E+00, 4.6457530988E-02, 4.5275637796E-02, 4.0304626449E-01],
	[6.3150000000E+03, 2.3769445561E+00, 7.1007391993E+00, 4.6569524812E-02, 4.5382739628E-02, 4.0324802041E-01],
	[6.3200000000E+03, 2.3792646993E+00, 7.0981443279E+00, 4.6681699333E-02, 4.5490005521E-02, 4.0344962914E-01],
	[6.3250000000E+03, 2.3815852697E+00, 7.0955524557E+00, 4.6794054701E-02, 4.5597435580E-02, 4.0365109106E-01],
	[6.3300000000E+03, 2.3839062670E+00, 7.0929635769E+00, 4.6906591063E-02, 4.5705029906E-02, 4.0385240658E-01],
	[6.3350000000E+03, 2.3862276910E+00, 7.0903776857E+00, 4.7019308565E-02, 4.5812788603E-02, 4.0405357610E-01],
	[6.3400000000E+03, 2.3885495413E+00, 7.0877947762E+00, 4.7132207355E-02, 4.5920711772E-02, 4.0425460002E-01],
	[6.3450000000E+03, 2.3908718179E+00, 7.0852148428E+00, 4.7245287582E-02, 4.6028799517E-02, 4.0445547873E-01],
	[6.3500000000E+03, 2.3931945203E+00, 7.0826378795E+00, 4.7358549391E-02, 4.6137051940E-02, 4.0465621264E-01],
	[6.3550000000E+03, 2.3955206182E+00, 7.0800801670E+00, 4.7471992931E-02, 4.6245470945E-02, 4.0485680212E-01],
	[6.3600000000E+03, 2.3978532523E+00, 7.0775588363E+00, 4.7585618349E-02, 4.6354058563E-02, 4.0505724759E-01],
	[6.3650000000E+03, 2.4001863221E+00, 7.0750403838E+00, 4.7699425792E-02, 4.6462811208E-02, 4.0525754942E-01],
	[6.3700000000E+03, 2.4025198271E+00, 7.0725248040E+00, 4.7813415408E-02, 4.6571728982E-02, 4.0545770802E-01],
	[6.3750000000E+03, 2.4048537673E+00, 7.0700120914E+00, 4.7927587344E-02, 4.6680811988E-02, 4.0565772376E-01],
	[6.3800000000E+03, 2.4071881423E+00, 7.0675022405E+00, 4.8041941748E-02, 4.6790060328E-02, 4.0585759704E-01],
	[6.3850000000E+03, 2.4095229519E+00, 7.0649952456E+00, 4.8156478767E-02, 4.6899474103E-02, 4.0605732825E-01],
	[6.3900000000E+03, 2.4118581958E+00, 7.0624911015E+00, 4.8271198549E-02, 4.7009053416E-02, 4.0625691777E-01],
	[6.3950000000E+03, 2.4141938737E+00, 7.0599898025E+00, 4.8386101240E-02, 4.7118798368E-02, 4.0645636598E-01],
	[6.4000000000E+03, 2.4165299854E+00, 7.0574913433E+00, 4.8501186989E-02, 4.7228709061E-02, 4.0665567328E-01],
	[6.4050000000E+03, 2.4188665307E+00, 7.0549957183E+00, 4.8616455942E-02, 4.7338785597E-02, 4.0685484004E-01],
	[6.4100000000E+03, 2.4212035092E+00, 7.0525029223E+00, 4.8731908248E-02, 4.7449028078E-02, 4.0705386665E-01],
	[6.4150000000E+03, 2.4235409207E+00, 7.0500129497E+00, 4.8847544054E-02, 4.7559436604E-02, 4.0725275348E-01],
	[6.4200000000E+03, 2.4258787650E+00, 7.0475257952E+00, 4.8963363506E-02, 4.7670011278E-02, 4.0745150092E-01],
	[6.4250000000E+03, 2.4282170418E+00, 7.0450414534E+00, 4.9079366753E-02, 4.7780752201E-02, 4.0765010934E-01],
	[6.4300000000E+03, 2.4305557509E+00, 7.0425599189E+00, 4.9195553943E-02, 4.7891659473E-02, 4.0784857912E-01],
	[6.4350000000E+03, 2.4328948919E+00, 7.0400811865E+00, 4.9311925221E-02, 4.8002733196E-02, 4.0804691065E-01],
	[6.4400000000E+03, 2.4352344647E+00, 7.0376052506E+00, 4.9428480737E-02, 4.8113973472E-02, 4.0824510428E-01],
	[6.4450000000E+03, 2.4375744690E+00, 7.0351321060E+00, 4.9545220637E-02, 4.8225380400E-02, 4.0844316040E-01],
	[6.4500000000E+03, 2.4399149044E+00, 7.0326617475E+00, 4.9662145069E-02, 4.8336954082E-02, 4.0864107938E-01],
	[6.4550000000E+03, 2.4422557709E+00, 7.0301941697E+00, 4.9779254180E-02, 4.8448694620E-02, 4.0883886160E-01],
	[6.4600000000E+03, 2.4446046735E+00, 7.0277709129E+00, 4.9896548118E-02, 4.8560607097E-02, 4.0903650741E-01],
	[6.4650000000E+03, 2.4469551404E+00, 7.0253565029E+00, 5.0014027030E-02, 4.8672687407E-02, 4.0923401720E-01],
	[6.4700000000E+03, 2.4493060474E+00, 7.0229447881E+00, 5.0131691063E-02, 4.8784934918E-02, 4.0943139133E-01],
	[6.4750000000E+03, 2.4516573944E+00, 7.0205357632E+00, 5.0249540366E-02, 4.8897349730E-02, 4.0962863017E-01],
	[6.4800000000E+03, 2.4540091811E+00, 7.0181294233E+00, 5.0367575085E-02, 4.9009931943E-02, 4.0982573409E-01],
	[6.4850000000E+03, 2.4563614072E+00, 7.0157257632E+00, 5.0485798178E-02, 4.9122684318E-02, 4.1002270345E-01],
	[6.4900000000E+03, 2.4587140724E+00, 7.0133247780E+00, 5.0604207483E-02, 4.9235604767E-02, 4.1021953861E-01],
	[6.4950000000E+03, 2.4610671766E+00, 7.0109264625E+00, 5.0722802660E-02, 4.9348692932E-02, 4.1041623994E-01],
	[6.5000000000E+03, 2.4634207194E+00, 7.0085308118E+00, 5.0841583857E-02, 4.9461948911E-02, 4.1061280781E-01],
	[6.5050000000E+03, 2.4657747006E+00, 7.0061378208E+00, 5.0960551221E-02, 4.9575372805E-02, 4.1080924257E-01],
	[6.5100000000E+03, 2.4681291200E+00, 7.0037474846E+00, 5.1079704900E-02, 4.9688964714E-02, 4.1100554458E-01],
	[6.5150000000E+03, 2.4704839773E+00, 7.0013597982E+00, 5.1199045041E-02, 4.9802724738E-02, 4.1120171421E-01],
	[6.5200000000E+03, 2.4728392721E+00, 6.9989747566E+00, 5.1318571792E-02, 4.9916652976E-02, 4.1139775184E-01],
	[6.5250000000E+03, 2.4751950044E+00, 6.9965923549E+00, 5.1438285301E-02, 5.0030749530E-02, 4.1159365804E-01],
	[6.5300000000E+03, 2.4775511738E+00, 6.9942125881E+00, 5.1558185714E-02, 5.0145014497E-02, 4.1178943320E-01],
	[6.5350000000E+03, 2.4799077801E+00, 6.9918354513E+00, 5.1678273180E-02, 5.0259447978E-02, 4.1198507771E-01],
	[6.5400000000E+03, 2.4822648230E+00, 6.9894609395E+00, 5.1798547845E-02, 5.0374050073E-02, 4.1218059193E-01],
	[6.5450000000E+03, 2.4846223022E+00, 6.9870890479E+00, 5.1919009858E-02, 5.0488820880E-02, 4.1237597621E-01],
	[6.5500000000E+03, 2.4869802176E+00, 6.9847197716E+00, 5.2039659366E-02, 5.0603760499E-02, 4.1257123094E-01],
	[6.5550000000E+03, 2.4893385688E+00, 6.9823531057E+00, 5.2160496516E-02, 5.0718869030E-02, 4.1276635646E-01],
	[6.5600000000E+03, 2.4916980743E+00, 6.9799929689E+00, 5.2281521456E-02, 5.0834147078E-02, 4.1296135315E-01],
	[6.5650000000E+03, 2.4940656789E+00, 6.9776772104E+00, 5.2402734334E-02, 5.0949599665E-02, 4.1315622137E-01],
	[6.5700000000E+03, 2.4964337282E+00, 6.9753639825E+00, 5.2524135297E-02, 5.1065221506E-02, 4.1335096147E-01],
	[6.5750000000E+03, 2.4988022218E+00, 6.9730532803E+00, 5.2645724492E-02, 5.1181012698E-02, 4.1354557382E-01],
	[6.5800000000E+03, 2.5011711595E+00, 6.9707450992E+00, 5.2767502067E-02, 5.1296973341E-02, 4.1374005878E-01],
	[6.5850000000E+03, 2.5035405411E+00, 6.9684394346E+00, 5.2889468170E-02, 5.1413103534E-02, 4.1393441670E-01],
	[6.5900000000E+03, 2.5059103662E+00, 6.9661362817E+00, 5.3011622948E-02, 5.1529403376E-02, 4.1412864794E-01],
	[6.5950000000E+03, 2.5082806347E+00, 6.9638356361E+00, 5.3133966548E-02, 5.1645872966E-02, 4.1432275286E-01],
	[6.6000000000E+03, 2.5106513463E+00, 6.9615374929E+00, 5.3256499119E-02, 5.1762512401E-02, 4.1451673180E-01],
	[6.6050000000E+03, 2.5130225007E+00, 6.9592418476E+00, 5.3379220807E-02, 5.1879321781E-02, 4.1471058513E-01],
	[6.6100000000E+03, 2.5153940976E+00, 6.9569486957E+00, 5.3502131761E-02, 5.1996301205E-02, 4.1490431320E-01],
	[6.6150000000E+03, 2.5177661369E+00, 6.9546580324E+00, 5.3625232127E-02, 5.2113450769E-02, 4.1509791636E-01],
	[6.6200000000E+03, 2.5201386183E+00, 6.9523698534E+00, 5.3748522054E-02, 5.2230770574E-02, 4.1529139495E-01],
	[6.6250000000E+03, 2.5225115415E+00, 6.9500841538E+00, 5.3872001689E-02, 5.2348260716E-02, 4.1548474933E-01],
	[6.6300000000E+03, 2.5248849062E+00, 6.9478009293E+00, 5.3995671179E-02, 5.2465921295E-02, 4.1567797985E-01],
	[6.6350000000E+03, 2.5272587123E+00, 6.9455201753E+00, 5.4119530672E-02, 5.2583752408E-02, 4.1587108686E-01],
	[6.6400000000E+03, 2.5296329594E+00, 6.9432418872E+00, 5.4243580315E-02, 5.2701754152E-02, 4.1606407069E-01],
	[6.6450000000E+03, 2.5320076474E+00, 6.9409660605E+00, 5.4367820257E-02, 5.2819926627E-02, 4.1625693170E-01],
	[6.6500000000E+03, 2.5343827759E+00, 6.9386926907E+00, 5.4492250644E-02, 5.2938269928E-02, 4.1644967024E-01],
	[6.6550000000E+03, 2.5367583448E+00, 6.9364217734E+00, 5.4616871624E-02, 5.3056784156E-02, 4.1664228664E-01],
	[6.6600000000E+03, 2.5391343537E+00, 6.9341533039E+00, 5.4741683345E-02, 5.3175469406E-02, 4.1683478124E-01],
	[6.6650000000E+03, 2.5415108024E+00, 6.9318872780E+00, 5.4866685954E-02, 5.3294325776E-02, 4.1702715440E-01],
	[6.6700000000E+03, 2.5438954460E+00, 6.9296659937E+00, 5.4991879600E-02, 5.3413359296E-02, 4.1721940645E-01],
	[6.6750000000E+03, 2.5462808129E+00, 6.9274485840E+00, 5.5117264428E-02, 5.3532564386E-02, 4.1741153773E-01],
	[6.6800000000E+03, 2.5486666278E+00, 6.9252335434E+00, 5.5242840588E-02, 5.3651940933E-02, 4.1760354857E-01],
	[6.6850000000E+03, 2.5510528906E+00, 6.9230208676E+00, 5.5368608226E-02, 5.3771489036E-02, 4.1779543933E-01],
	[6.6900000000E+03, 2.5534396009E+00, 6.9208105523E+00, 5.5494567490E-02, 5.3891208790E-02, 4.1798721033E-01],
	[6.6950000000E+03, 2.5558267586E+00, 6.9186025933E+00, 5.5620718528E-02, 5.4011100294E-02, 4.1817886191E-01],
	[6.7000000000E+03, 2.5582143633E+00, 6.9163969862E+00, 5.5747061487E-02, 5.4131163644E-02, 4.1837039441E-01],
	[6.7050000000E+03, 2.5606024149E+00, 6.9141937269E+00, 5.5873596515E-02, 5.4251398937E-02, 4.1856180816E-01],
	[6.7100000000E+03, 2.5629909131E+00, 6.9119928110E+00, 5.6000323759E-02, 5.4371806270E-02, 4.1875310349E-01],
	[6.7150000000E+03, 2.5653798576E+00, 6.9097942343E+00, 5.6127243368E-02, 5.4492385740E-02, 4.1894428074E-01],
	[6.7200000000E+03, 2.5677692481E+00, 6.9075979926E+00, 5.6254355488E-02, 5.4613137443E-02, 4.1913534024E-01],
	[6.7250000000E+03, 2.5701590845E+00, 6.9054040817E+00, 5.6381660267E-02, 5.4734061477E-02, 4.1932628231E-01],
	[6.7300000000E+03, 2.5725493665E+00, 6.9032124974E+00, 5.6509157852E-02, 5.4855157937E-02, 4.1951710730E-01],
	[6.7350000000E+03, 2.5749400938E+00, 6.9010232355E+00, 5.6636848392E-02, 5.4976426919E-02, 4.1970781552E-01],
	[6.7400000000E+03, 2.5773312662E+00, 6.8988362918E+00, 5.6764732034E-02, 5.5097868521E-02, 4.1989840731E-01],
	[6.7450000000E+03, 2.5797228835E+00, 6.8966516622E+00, 5.6892808926E-02, 5.5219482839E-02, 4.2008888299E-01],
	[6.7500000000E+03, 2.5821149453E+00, 6.8944693424E+00, 5.7021079214E-02, 5.5341269968E-02, 4.2027924290E-01],
	[6.7550000000E+03, 2.5845074515E+00, 6.8922893283E+00, 5.7149543047E-02, 5.5463230004E-02, 4.2046948734E-01],
	[6.7600000000E+03, 2.5869004018E+00, 6.8901116158E+00, 5.7278200572E-02, 5.5585363044E-02, 4.2065961666E-01],
	[6.7650000000E+03, 2.5892937959E+00, 6.8879362008E+00, 5.7407051937E-02, 5.5707669184E-02, 4.2084963117E-01],
	[6.7700000000E+03, 2.5916876337E+00, 6.8857630791E+00, 5.7536097290E-02, 5.5830148518E-02, 4.2103953120E-01],
	[6.7750000000E+03, 2.5940857961E+00, 6.8836134762E+00, 5.7665336778E-02, 5.5952804351E-02, 4.2122931707E-01],
	[6.7800000000E+03, 2.5964882017E+00, 6.8814868651E+00, 5.7794770548E-02, 5.6075636741E-02, 4.2141898909E-01],
	[6.7850000000E+03, 2.5988910586E+00, 6.8793624780E+00, 5.7924398748E-02, 5.6198642660E-02, 4.2160854760E-01],
	[6.7900000000E+03, 2.6012943667E+00, 6.8772403109E+00, 5.8054221526E-02, 5.6321822202E-02, 4.2179799290E-01],
	[6.7950000000E+03, 2.6036981257E+00, 6.8751203599E+00, 5.8184239030E-02, 5.6445175463E-02, 4.2198732533E-01],
	[6.8000000000E+03, 2.6061023353E+00, 6.8730026210E+00, 5.8314451407E-02, 5.6568702538E-02, 4.2217654519E-01],
	[6.8050000000E+03, 2.6085069954E+00, 6.8708870903E+00, 5.8444858804E-02, 5.6692403524E-02, 4.2236565280E-01],
	[6.8100000000E+03, 2.6109121056E+00, 6.8687737639E+00, 5.8575461370E-02, 5.6816278514E-02, 4.2255464848E-01],
	[6.8150000000E+03, 2.6133176657E+00, 6.8666626379E+00, 5.8706259251E-02, 5.6940327604E-02, 4.2274353255E-01],
	[6.8200000000E+03, 2.6157236755E+00, 6.8645537083E+00, 5.8837252597E-02, 5.7064550890E-02, 4.2293230532E-01],
	[6.8250000000E+03, 2.6181301347E+00, 6.8624469712E+00, 5.8968441553E-02, 5.7188948466E-02, 4.2312096710E-01],
	[6.8300000000E+03, 2.6205370431E+00, 6.8603424229E+00, 5.9099826267E-02, 5.7313520426E-02, 4.2330951821E-01],
	[6.8350000000E+03, 2.6229444004E+00, 6.8582400593E+00, 5.9231406889E-02, 5.7438266866E-02, 4.2349795895E-01],
	[6.8400000000E+03, 2.6253522064E+00, 6.8561398768E+00, 5.9363183564E-02, 5.7563187881E-02, 4.2368628965E-01],
	[6.8450000000E+03, 2.6277604609E+00, 6.8540418712E+00, 5.9495156440E-02, 5.7688283564E-02, 4.2387451061E-01],
	[6.8500000000E+03, 2.6301691635E+00, 6.8519460390E+00, 5.9627325666E-02, 5.7813554011E-02, 4.2406262213E-01],
	[6.8550000000E+03, 2.6325783141E+00, 6.8498523761E+00, 5.9759691389E-02, 5.7938999315E-02, 4.2425062454E-01],
	[6.8600000000E+03, 2.6349879124E+00, 6.8477608789E+00, 5.9892253756E-02, 5.8064619571E-02, 4.2443851813E-01],
	[6.8650000000E+03, 2.6373979582E+00, 6.8456715434E+00, 6.0025012916E-02, 5.8190414873E-02, 4.2462630322E-01],
	[6.8700000000E+03, 2.6398084512E+00, 6.8435843658E+00, 6.0157969015E-02, 5.8316385315E-02, 4.2481398012E-01],
	[6.8750000000E+03, 2.6422193912E+00, 6.8414993424E+00, 6.0291122201E-02, 5.8442530992E-02, 4.2500154912E-01],
	[6.8800000000E+03, 2.6446307779E+00, 6.8394164695E+00, 6.0424472622E-02, 5.8568851996E-02, 4.2518901053E-01],
	[6.8850000000E+03, 2.6470477364E+00, 6.8373638928E+00, 6.0558020426E-02, 5.8695353017E-02, 4.2537636466E-01],
	[6.8900000000E+03, 2.6494673425E+00, 6.8353254662E+00, 6.0691765761E-02, 5.8822031560E-02, 4.2556361181E-01],
	[6.8950000000E+03, 2.6518874027E+00, 6.8332891254E+00, 6.0825708773E-02, 5.8948885760E-02, 4.2575075229E-01],
	[6.9000000000E+03, 2.6543079166E+00, 6.8312548667E+00, 6.0959849610E-02, 5.9075915711E-02, 4.2593778639E-01],
	[6.9050000000E+03, 2.6567288841E+00, 6.8292226865E+00, 6.1094188421E-02, 5.9203121505E-02, 4.2612471442E-01],
	[6.9100000000E+03, 2.6591503050E+00, 6.8271925812E+00, 6.1228725353E-02, 5.9330503236E-02, 4.2631153668E-01],
	[6.9150000000E+03, 2.6615721789E+00, 6.8251645472E+00, 6.1363460553E-02, 5.9458060998E-02, 4.2649825347E-01],
	[6.9200000000E+03, 2.6639945057E+00, 6.8231385808E+00, 6.1498394169E-02, 5.9585794884E-02, 4.2668486509E-01],
	[6.9250000000E+03, 2.6664172850E+00, 6.8211146784E+00, 6.1633526349E-02, 5.9713704988E-02, 4.2687137183E-01],
	[6.9300000000E+03, 2.6688405167E+00, 6.8190928365E+00, 6.1768857241E-02, 5.9841791402E-02, 4.2705777400E-01],
	[6.9350000000E+03, 2.6712642005E+00, 6.8170730516E+00, 6.1904386991E-02, 5.9970054219E-02, 4.2724407188E-01],
	[6.9400000000E+03, 2.6736883362E+00, 6.8150553199E+00, 6.2040115748E-02, 6.0098493533E-02, 4.2743026579E-01],
	[6.9450000000E+03, 2.6761129235E+00, 6.8130396379E+00, 6.2176043660E-02, 6.0227109437E-02, 4.2761635601E-01],
	[6.9500000000E+03, 2.6785379622E+00, 6.8110260021E+00, 6.2312170874E-02, 6.0355902022E-02, 4.2780234284E-01],
	[6.9550000000E+03, 2.6809634521E+00, 6.8090144090E+00, 6.2448497537E-02, 6.0484871383E-02, 4.2798822657E-01],
	[6.9600000000E+03, 2.6833893928E+00, 6.8070048550E+00, 6.2585023798E-02, 6.0614017610E-02, 4.2817400750E-01],
	[6.9650000000E+03, 2.6858157842E+00, 6.8049973365E+00, 6.2721749803E-02, 6.0743340798E-02, 4.2835968591E-01],
	[6.9700000000E+03, 2.6882426261E+00, 6.8029918501E+00, 6.2858675702E-02, 6.0872841038E-02, 4.2854526211E-01],
	[6.9750000000E+03, 2.6906699181E+00, 6.8009883923E+00, 6.2995801641E-02, 6.1002518422E-02, 4.2873073638E-01],
	[6.9800000000E+03, 2.6930976601E+00, 6.7989869594E+00, 6.3133127767E-02, 6.1132373044E-02, 4.2891610901E-01],
	[6.9850000000E+03, 2.6955258517E+00, 6.7969875481E+00, 6.3270654230E-02, 6.1262404994E-02, 4.2910138030E-01],
	[6.9900000000E+03, 2.6979544929E+00, 6.7949901549E+00, 6.3408381176E-02, 6.1392614365E-02, 4.2928655053E-01],
	[6.9950000000E+03, 2.7003873758E+00, 6.7930157037E+00, 6.3546308753E-02, 6.1523004934E-02, 4.2947161999E-01],
	[7.0000000000E+03, 2.7028238970E+00, 6.7910607922E+00, 6.3684437108E-02, 6.1653576238E-02, 4.2965658898E-01],
	[7.0050000000E+03, 2.7052608746E+00, 6.7891078385E+00, 6.3824174038E-02, 6.1785644452E-02, 4.2984145777E-01],
	[7.0100000000E+03, 2.7076983083E+00, 6.7871568393E+00, 6.3964117221E-02, 6.1917895082E-02, 4.3002622665E-01],
	[7.0150000000E+03, 2.7101361978E+00, 6.7852077913E+00, 6.4104266814E-02, 6.2050328226E-02, 4.3021089591E-01],
	[7.0200000000E+03, 2.7125745430E+00, 6.7832606911E+00, 6.4244622971E-02, 6.2182943983E-02, 4.3039546584E-01],
	[7.0250000000E+03, 2.7150133435E+00, 6.7813155354E+00, 6.4385185851E-02, 6.2315742449E-02, 4.3057993672E-01],
	[7.0300000000E+03, 2.7174525992E+00, 6.7793723208E+00, 6.4525955608E-02, 6.2448723723E-02, 4.3076430884E-01],
	[7.0350000000E+03, 2.7198923097E+00, 6.7774310441E+00, 6.4666932400E-02, 6.2581887901E-02, 4.3094858247E-01],
	[7.0400000000E+03, 2.7223324749E+00, 6.7754917018E+00, 6.4808116382E-02, 6.2715235082E-02, 4.3113275790E-01],
	[7.0450000000E+03, 2.7247730946E+00, 6.7735542909E+00, 6.4949507711E-02, 6.2848765362E-02, 4.3131683546E-01],
	[7.0500000000E+03, 2.7272141684E+00, 6.7716188078E+00, 6.5091106543E-02, 6.2982478838E-02, 4.3150081548E-01],
	[7.0550000000E+03, 2.7296556961E+00, 6.7696852494E+00, 6.5232913033E-02, 6.3116375608E-02, 4.3168469822E-01],
	[7.0600000000E+03, 2.7320976776E+00, 6.7677536124E+00, 6.5374927340E-02, 6.3250455769E-02, 4.3186848395E-01],
	[7.0650000000E+03, 2.7345401125E+00, 6.7658238936E+00, 6.5517149618E-02, 6.3384719417E-02, 4.3205217293E-01],
	[7.0700000000E+03, 2.7369830006E+00, 6.7638960895E+00, 6.5659580024E-02, 6.3519166649E-02, 4.3223576544E-01],
	[7.0750000000E+03, 2.7394263418E+00, 6.7619701971E+00, 6.5802218715E-02, 6.3653797562E-02, 4.3241926173E-01],
	[7.0800000000E+03, 2.7418701357E+00, 6.7600462130E+00, 6.5945065846E-02, 6.3788612252E-02, 4.3260266207E-01],
	[7.0850000000E+03, 2.7443143821E+00, 6.7581241340E+00, 6.6088121574E-02, 6.3923610816E-02, 4.3278596672E-01],
	[7.0900000000E+03, 2.7467590809E+00, 6.7562039569E+00, 6.6231386056E-02, 6.4058793350E-02, 4.3296917596E-01],
	[7.0950000000E+03, 2.7492042316E+00, 6.7542856785E+00, 6.6374859447E-02, 6.4194159951E-02, 4.3315229004E-01],
	[7.1000000000E+03, 2.7516498342E+00, 6.7523692956E+00, 6.6518541904E-02, 6.4329710714E-02, 4.3333530923E-01],
	[7.1050000000E+03, 2.7540960922E+00, 6.7504559249E+00, 6.6662433583E-02, 6.4465445950E-02, 4.3351823378E-01],
	[7.1100000000E+03, 2.7565493062E+00, 6.7485801376E+00, 6.6806534640E-02, 6.4601372386E-02, 4.3370106396E-01],
	[7.1150000000E+03, 2.7590029784E+00, 6.7467061896E+00, 6.6950845233E-02, 6.4737483321E-02, 4.3388380003E-01],
	[7.1200000000E+03, 2.7614571087E+00, 6.7448340778E+00, 6.7095365516E-02, 6.4873778853E-02, 4.3406644226E-01],
	[7.1250000000E+03, 2.7639116969E+00, 6.7429637992E+00, 6.7240095648E-02, 6.5010259078E-02, 4.3424899089E-01],
	[7.1300000000E+03, 2.7663667427E+00, 6.7410953507E+00, 6.7385035783E-02, 6.5146924090E-02, 4.3443144619E-01],
	[7.1350000000E+03, 2.7688222458E+00, 6.7392287292E+00, 6.7530186078E-02, 6.5283773986E-02, 4.3461380841E-01],
	[7.1400000000E+03, 2.7712782061E+00, 6.7373639316E+00, 6.7675546690E-02, 6.5420808861E-02, 4.3479607782E-01],
	[7.1450000000E+03, 2.7737346233E+00, 6.7355009549E+00, 6.7821117775E-02, 6.5558028810E-02, 4.3497825467E-01],
	[7.1500000000E+03, 2.7761914972E+00, 6.7336397961E+00, 6.7966899489E-02, 6.5695433930E-02, 4.3516033922E-01],
	[7.1550000000E+03, 2.7786488275E+00, 6.7317804520E+00, 6.8112891989E-02, 6.5833024315E-02, 4.3534233172E-01],
	[7.1600000000E+03, 2.7811066140E+00, 6.7299229197E+00, 6.8259095431E-02, 6.5970800060E-02, 4.3552423243E-01],
	[7.1650000000E+03, 2.7835648564E+00, 6.7280671962E+00, 6.8405509971E-02, 6.6108761261E-02, 4.3570604161E-01],
	[7.1700000000E+03, 2.7860235546E+00, 6.7262132783E+00, 6.8552135767E-02, 6.6246908013E-02, 4.3588775951E-01],
	[7.1750000000E+03, 2.7884827083E+00, 6.7243611631E+00, 6.8698972973E-02, 6.6385240409E-02, 4.3606938638E-01],
	[7.1800000000E+03, 2.7909423173E+00, 6.7225108476E+00, 6.8846021748E-02, 6.6523758546E-02, 4.3625092247E-01],
	[7.1850000000E+03, 2.7934023813E+00, 6.7206623288E+00, 6.8993282246E-02, 6.6662462518E-02, 4.3643236804E-01],
	[7.1900000000E+03, 2.7958629001E+00, 6.7188156037E+00, 6.9140754625E-02, 6.6801352419E-02, 4.3661372334E-01],
	[7.1950000000E+03, 2.7983238735E+00, 6.7169706693E+00, 6.9288439041E-02, 6.6940428343E-02, 4.3679498863E-01],
	[7.2000000000E+03, 2.8007853012E+00, 6.7151275226E+00, 6.9436335650E-02, 6.7079690386E-02, 4.3697616414E-01],
	[7.2050000000E+03, 2.8032471830E+00, 6.7132861607E+00, 6.9584444609E-02, 6.7219138641E-02, 4.3715725014E-01],
	[7.2100000000E+03, 2.8057095187E+00, 6.7114465806E+00, 6.9732766074E-02, 6.7358773202E-02, 4.3733824688E-01],
	[7.2150000000E+03, 2.8081723080E+00, 6.7096087793E+00, 6.9881300202E-02, 6.7498594164E-02, 4.3751915459E-01],
	[7.2200000000E+03, 2.8106365499E+00, 6.7077782036E+00, 7.0030047149E-02, 6.7638602753E-02, 4.3769997354E-01],
	[7.2250000000E+03, 2.8131067069E+00, 6.7059791468E+00, 7.0179007072E-02, 6.7778804148E-02, 4.3788070397E-01],
	[7.2300000000E+03, 2.8155773238E+00, 6.7041818166E+00, 7.0328180126E-02, 6.7919192276E-02, 4.3806134612E-01],
	[7.2350000000E+03, 2.8180484002E+00, 6.7023862102E+00, 7.0477566469E-02, 6.8059767231E-02, 4.3824190025E-01],
	[7.2400000000E+03, 2.8205199360E+00, 6.7005923247E+00, 7.0627166257E-02, 6.8200529107E-02, 4.3842236660E-01],
	[7.2450000000E+03, 2.8229919309E+00, 6.6988001573E+00, 7.0776979646E-02, 6.8341477997E-02, 4.3860274541E-01],
	[7.2500000000E+03, 2.8254643847E+00, 6.6970097052E+00, 7.0927006794E-02, 6.8482613995E-02, 4.3878303694E-01],
	[7.2550000000E+03, 2.8279372971E+00, 6.6952209654E+00, 7.1077247855E-02, 6.8623937195E-02, 4.3896324143E-01],
	[7.2600000000E+03, 2.8304106680E+00, 6.6934339353E+00, 7.1227702988E-02, 6.8765447689E-02, 4.3914335911E-01],
	[7.2650000000E+03, 2.8328844970E+00, 6.6916486120E+00, 7.1378372347E-02, 6.8907145571E-02, 4.3932339025E-01],
	[7.2700000000E+03, 2.8353587840E+00, 6.6898649926E+00, 7.1529256091E-02, 6.9049030934E-02, 4.3950333507E-01],
	[7.2750000000E+03, 2.8378335287E+00, 6.6880830745E+00, 7.1680354375E-02, 6.9191103872E-02, 4.3968319383E-01],
	[7.2800000000E+03, 2.8403087310E+00, 6.6863028548E+00, 7.1831667356E-02, 6.9333364476E-02, 4.3986296676E-01],
	[7.2850000000E+03, 2.8427843905E+00, 6.6845243307E+00, 7.1983195190E-02, 6.9475812840E-02, 4.4004265411E-01],
	[7.2900000000E+03, 2.8452605070E+00, 6.6827474994E+00, 7.2134938035E-02, 6.9618449057E-02, 4.4022225612E-01],
	[7.2950000000E+03, 2.8477370803E+00, 6.6809723582E+00, 7.2286896045E-02, 6.9761273218E-02, 4.4040177303E-01],
	[7.3000000000E+03, 2.8502141102E+00, 6.6791989044E+00, 7.2439069379E-02, 6.9904285418E-02, 4.4058120508E-01],
	[7.3050000000E+03, 2.8526915965E+00, 6.6774271351E+00, 7.2591458192E-02, 7.0047485747E-02, 4.4076055251E-01],
	[7.3100000000E+03, 2.8551695389E+00, 6.6756570476E+00, 7.2744062641E-02, 7.0190874299E-02, 4.4093981556E-01],
	[7.3150000000E+03, 2.8576479372E+00, 6.6738886391E+00, 7.2896882883E-02, 7.0334451165E-02, 4.4111899447E-01],
	[7.3200000000E+03, 2.8601267912E+00, 6.6721219070E+00, 7.3049919074E-02, 7.0478216438E-02, 4.4129808947E-01],
	[7.3250000000E+03, 2.8626061006E+00, 6.6703568485E+00, 7.3203171370E-02, 7.0622170209E-02, 4.4147710081E-01],
	[7.3300000000E+03, 2.8650858652E+00, 6.6685934608E+00, 7.3356639929E-02, 7.0766312571E-02, 4.4165602872E-01],
	[7.3350000000E+03, 2.8675660848E+00, 6.6668317413E+00, 7.3510324907E-02, 7.0910643615E-02, 4.4183487345E-01],
	[7.3400000000E+03, 2.8700524149E+00, 6.6651023335E+00, 7.3664226460E-02, 7.1055170383E-02, 4.4201363522E-01],
	[7.3450000000E+03, 2.8725397598E+00, 6.6633775517E+00, 7.3818344745E-02, 7.1199886747E-02, 4.4219231427E-01],
	[7.3500000000E+03, 2.8750275655E+00, 6.6616543894E+00, 7.3972679919E-02, 7.1344792120E-02, 4.4237091084E-01],
	[7.3550000000E+03, 2.8775158318E+00, 6.6599328442E+00, 7.4127232138E-02, 7.1489886595E-02, 4.4254942517E-01],
	[7.3600000000E+03, 2.8800045585E+00, 6.6582129133E+00, 7.4282001558E-02, 7.1635170262E-02, 4.4272785748E-01],
	[7.3650000000E+03, 2.8824937453E+00, 6.6564945941E+00, 7.4436988337E-02, 7.1780643213E-02, 4.4290620801E-01],
	[7.3700000000E+03, 2.8849833921E+00, 6.6547778842E+00, 7.4592192631E-02, 7.1926305539E-02, 4.4308447700E-01],
	[7.3750000000E+03, 2.8874734985E+00, 6.6530627807E+00, 7.4747614597E-02, 7.2072157331E-02, 4.4326266468E-01],
	[7.3800000000E+03, 2.8899640643E+00, 6.6513492812E+00, 7.4903254390E-02, 7.2218198681E-02, 4.4344077129E-01],
	[7.3850000000E+03, 2.8924550894E+00, 6.6496373832E+00, 7.5059112169E-02, 7.2364429679E-02, 4.4361879705E-01],
	[7.3900000000E+03, 2.8949465735E+00, 6.6479270839E+00, 7.5215188089E-02, 7.2510850417E-02, 4.4379674219E-01],
	[7.3950000000E+03, 2.8974385164E+00, 6.6462183808E+00, 7.5371482307E-02, 7.2657460984E-02, 4.4397460695E-01],
	[7.4000000000E+03, 2.8999309178E+00, 6.6445112714E+00, 7.5527994979E-02, 7.2804261472E-02, 4.4415239157E-01],
	[7.4050000000E+03, 2.9024237776E+00, 6.6428057531E+00, 7.5684726263E-02, 7.2951251971E-02, 4.4433009626E-01],
	[7.4100000000E+03, 2.9049170955E+00, 6.6411018233E+00, 7.5841676315E-02, 7.3098432571E-02, 4.4450772126E-01],
	[7.4150000000E+03, 2.9074108712E+00, 6.6393994795E+00, 7.5998845292E-02, 7.3245803363E-02, 4.4468526680E-01],
	[7.4200000000E+03, 2.9099051046E+00, 6.6376987192E+00, 7.6156233350E-02, 7.3393364437E-02, 4.4486273311E-01],
	[7.4250000000E+03, 2.9123997954E+00, 6.6359995398E+00, 7.6313840646E-02, 7.3541115883E-02, 4.4504012042E-01],
	[7.4300000000E+03, 2.9148949434E+00, 6.6343019387E+00, 7.6471667336E-02, 7.3689057791E-02, 4.4521742895E-01],
	[7.4350000000E+03, 2.9173905484E+00, 6.6326059135E+00, 7.6629713578E-02, 7.3837190251E-02, 4.4539465894E-01],
	[7.4400000000E+03, 2.9198866101E+00, 6.6309114617E+00, 7.6787979528E-02, 7.3985513353E-02, 4.4557181061E-01],
	[7.4450000000E+03, 2.9223831284E+00, 6.6292185806E+00, 7.6946465342E-02, 7.4134027186E-02, 4.4574888419E-01],
	[7.4500000000E+03, 2.9248801030E+00, 6.6275272678E+00, 7.7105171178E-02, 7.4282731841E-02, 4.4592587991E-01],
	[7.4550000000E+03, 2.9273792767E+00, 6.6258469321E+00, 7.7264097192E-02, 7.4431629720E-02, 4.4610279798E-01],
	[7.4600000000E+03, 2.9298831231E+00, 6.6241908828E+00, 7.7423243540E-02, 7.4580724227E-02, 4.4627963865E-01],
	[7.4650000000E+03, 2.9323874314E+00, 6.6225363566E+00, 7.7582610380E-02, 7.4730009877E-02, 4.4645640212E-01],
	[7.4700000000E+03, 2.9348922012E+00, 6.6208833511E+00, 7.7742197869E-02, 7.4879486760E-02, 4.4663308864E-01],
	[7.4750000000E+03, 2.9373974324E+00, 6.6192318638E+00, 7.7902006162E-02, 7.5029154963E-02, 4.4680969842E-01],
	[7.4800000000E+03, 2.9399031248E+00, 6.6175818923E+00, 7.8062035416E-02, 7.5179014578E-02, 4.4698623168E-01],
	[7.4850000000E+03, 2.9424092781E+00, 6.6159334343E+00, 7.8222285789E-02, 7.5329065691E-02, 4.4716268865E-01],
	[7.4900000000E+03, 2.9449158921E+00, 6.6142864873E+00, 7.8382757437E-02, 7.5479308394E-02, 4.4733906956E-01],
	[7.4950000000E+03, 2.9474229666E+00, 6.6126410489E+00, 7.8543450517E-02, 7.5629742773E-02, 4.4751537462E-01],
	[7.5000000000E+03, 2.9499305013E+00, 6.6109971168E+00, 7.8704365185E-02, 7.5780368918E-02, 4.4769160407E-01],
	[7.5050000000E+03, 2.9524384961E+00, 6.6093546886E+00, 7.8865501598E-02, 7.5931186919E-02, 4.4786775811E-01],
	[7.5100000000E+03, 2.9549469506E+00, 6.6077137618E+00, 7.9026859914E-02, 7.6082196862E-02, 4.4804383698E-01],
	[7.5150000000E+03, 2.9574558648E+00, 6.6060743342E+00, 7.9188440288E-02, 7.6233398836E-02, 4.4821984089E-01],
	[7.5200000000E+03, 2.9599652383E+00, 6.6044364033E+00, 7.9350242878E-02, 7.6384792931E-02, 4.4839577007E-01],
	[7.5250000000E+03, 2.9624750710E+00, 6.6027999668E+00, 7.9512267840E-02, 7.6536379233E-02, 4.4857162473E-01],
	[7.5300000000E+03, 2.9649853626E+00, 6.6011650224E+00, 7.9674515331E-02, 7.6688157832E-02, 4.4874740510E-01],
	[7.5350000000E+03, 2.9674961129E+00, 6.5995315677E+00, 7.9836985508E-02, 7.6840128814E-02, 4.4892311141E-01],
	[7.5400000000E+03, 2.9700073217E+00, 6.5978996003E+00, 7.9999678527E-02, 7.6992292269E-02, 4.4909874384E-01],
	[7.5450000000E+03, 2.9725189887E+00, 6.5962691179E+00, 8.0162594546E-02, 7.7144648283E-02, 4.4927430260E-01],
	[7.5500000000E+03, 2.9750311138E+00, 6.5946401182E+00, 8.0325733721E-02, 7.7297196944E-02, 4.4944978788E-01],
	[7.5550000000E+03, 2.9775436967E+00, 6.5930125988E+00, 8.0489096209E-02, 7.7449938340E-02, 4.4962519987E-01],
	[7.5600000000E+03, 2.9800567372E+00, 6.5913865575E+00, 8.0652682167E-02, 7.7602872558E-02, 4.4980053878E-01],
	[7.5650000000E+03, 2.9825702351E+00, 6.5897619918E+00, 8.0816491751E-02, 7.7755999686E-02, 4.4997580478E-01],
	[7.5700000000E+03, 2.9850841901E+00, 6.5881388996E+00, 8.0980525119E-02, 7.7909319811E-02, 4.5015099809E-01],
	[7.5750000000E+03, 2.9876002802E+00, 6.5865263160E+00, 8.1144782427E-02, 7.8062835434E-02, 4.5032611889E-01],
	[7.5800000000E+03, 2.9901208547E+00, 6.5849368507E+00, 8.1309263832E-02, 7.8216550055E-02, 4.5050116738E-01],
	[7.5850000000E+03, 2.9926418916E+00, 6.5833488167E+00, 8.1473969490E-02, 7.8370457989E-02, 4.5067614374E-01],
	[7.5900000000E+03, 2.9951633906E+00, 6.5817622117E+00, 8.1638899560E-02, 7.8524559323E-02, 4.5085104818E-01],
	[7.5950000000E+03, 2.9976853516E+00, 6.5801770337E+00, 8.1804054197E-02, 7.8678854143E-02, 4.5102588088E-01],
	[7.6000000000E+03, 3.0002077742E+00, 6.5785932802E+00, 8.1969433558E-02, 7.8833342536E-02, 4.5120064204E-01],
	[7.6050000000E+03, 3.0027306583E+00, 6.5770109492E+00, 8.2135037801E-02, 7.8988024590E-02, 4.5137533185E-01],
	[7.6100000000E+03, 3.0052540036E+00, 6.5754300383E+00, 8.2300867081E-02, 7.9142900390E-02, 4.5154995050E-01],
	[7.6150000000E+03, 3.0077778100E+00, 6.5738505455E+00, 8.2466921557E-02, 7.9297970023E-02, 4.5172449819E-01],
	[7.6200000000E+03, 3.0103020772E+00, 6.5722724684E+00, 8.2633201384E-02, 7.9453233575E-02, 4.5189897509E-01],
	[7.6250000000E+03, 3.0128268050E+00, 6.5706958049E+00, 8.2799706720E-02, 7.9608691133E-02, 4.5207338141E-01],
	[7.6300000000E+03, 3.0153519932E+00, 6.5691205529E+00, 8.2966437722E-02, 7.9764342782E-02, 4.5224771733E-01],
	[7.6350000000E+03, 3.0178776415E+00, 6.5675467100E+00, 8.3133394545E-02, 7.9920188609E-02, 4.5242198304E-01],
	[7.6400000000E+03, 3.0204037498E+00, 6.5659742742E+00, 8.3300577348E-02, 8.0076228700E-02, 4.5259617874E-01],
	[7.6450000000E+03, 3.0229303178E+00, 6.5644032433E+00, 8.3467986287E-02, 8.0232463140E-02, 4.5277030461E-01],
	[7.6500000000E+03, 3.0254573454E+00, 6.5628336150E+00, 8.3635621520E-02, 8.0388892015E-02, 4.5294436084E-01],
	[7.6550000000E+03, 3.0279848322E+00, 6.5612653872E+00, 8.3803483202E-02, 8.0545515411E-02, 4.5311834761E-01],
	[7.6600000000E+03, 3.0305127781E+00, 6.5596985578E+00, 8.3971571491E-02, 8.0702333413E-02, 4.5329226513E-01],
	[7.6650000000E+03, 3.0330411828E+00, 6.5581331246E+00, 8.4139886543E-02, 8.0859346106E-02, 4.5346611357E-01],
	[7.6700000000E+03, 3.0355700462E+00, 6.5565690855E+00, 8.4308428517E-02, 8.1016553577E-02, 4.5363989312E-01],
	[7.6750000000E+03, 3.0380993681E+00, 6.5550064382E+00, 8.4477197568E-02, 8.1173955909E-02, 4.5381360398E-01],
	[7.6800000000E+03, 3.0406291481E+00, 6.5534451806E+00, 8.4646193853E-02, 8.1331553187E-02, 4.5398724632E-01],
	[7.6850000000E+03, 3.0431593861E+00, 6.5518853107E+00, 8.4815417530E-02, 8.1489345498E-02, 4.5416082033E-01],
	[7.6900000000E+03, 3.0456900819E+00, 6.5503268262E+00, 8.4984868755E-02, 8.1647332925E-02, 4.5433432621E-01],
	[7.6950000000E+03, 3.0482212353E+00, 6.5487697251E+00, 8.5154547685E-02, 8.1805515553E-02, 4.5450776413E-01],
	[7.7000000000E+03, 3.0507578013E+00, 6.5472406579E+00, 8.5324454478E-02, 8.1963901221E-02, 4.5468113428E-01],
	[7.7050000000E+03, 3.0532953222E+00, 6.5457155877E+00, 8.5494589289E-02, 8.2122483084E-02, 4.5485443685E-01],
	[7.7100000000E+03, 3.0558333055E+00, 6.5441918616E+00, 8.5664952277E-02, 8.2281260458E-02, 4.5502767202E-01],
	[7.7150000000E+03, 3.0583717510E+00, 6.5426694778E+00, 8.5835543598E-02, 8.2440233427E-02, 4.5520083998E-01],
	[7.7200000000E+03, 3.0609106586E+00, 6.5411484341E+00, 8.6006363409E-02, 8.2599402075E-02, 4.5537394091E-01],
	[7.7250000000E+03, 3.0634500279E+00, 6.5396287285E+00, 8.6177411867E-02, 8.2758766488E-02, 4.5554697500E-01],
	[7.7300000000E+03, 3.0659898588E+00, 6.5381103589E+00, 8.6348689129E-02, 8.2918326749E-02, 4.5571994242E-01],
	[7.7350000000E+03, 3.0685301511E+00, 6.5365933234E+00, 8.6520195352E-02, 8.3078082943E-02, 4.5589284337E-01],
	[7.7400000000E+03, 3.0710709045E+00, 6.5350776198E+00, 8.6691930692E-02, 8.3238035152E-02, 4.5606567802E-01],
	[7.7450000000E+03, 3.0736121188E+00, 6.5335632461E+00, 8.6863895308E-02, 8.3398183461E-02, 4.5623844657E-01],
	[7.7500000000E+03, 3.0761537939E+00, 6.5320502004E+00, 8.7036089355E-02, 8.3558527954E-02, 4.5641114918E-01],
	[7.7550000000E+03, 3.0786959295E+00, 6.5305384805E+00, 8.7208512991E-02, 8.3719068715E-02, 4.5658378605E-01],
	[7.7600000000E+03, 3.0812385253E+00, 6.5290280846E+00, 8.7381166374E-02, 8.3879805826E-02, 4.5675635736E-01],
	[7.7650000000E+03, 3.0837815812E+00, 6.5275190105E+00, 8.7554049659E-02, 8.4040739370E-02, 4.5692886329E-01],
	[7.7700000000E+03, 3.0863250970E+00, 6.5260112563E+00, 8.7727163003E-02, 8.4201869433E-02, 4.5710130401E-01],
	[7.7750000000E+03, 3.0888690725E+00, 6.5245048199E+00, 8.7900506565E-02, 8.4363196095E-02, 4.5727367972E-01],
	[7.7800000000E+03, 3.0914135074E+00, 6.5229996994E+00, 8.8074080501E-02, 8.4524719441E-02, 4.5744599059E-01],
	[7.7850000000E+03, 3.0939584015E+00, 6.5214958927E+00, 8.8247884968E-02, 8.4686439554E-02, 4.5761823680E-01],
	[7.7900000000E+03, 3.0965037546E+00, 6.5199933980E+00, 8.8421920122E-02, 8.4848356516E-02, 4.5779041853E-01],
	[7.7950000000E+03, 3.0990495665E+00, 6.5184922131E+00, 8.8596186122E-02, 8.5010470409E-02, 4.5796253597E-01],
	[7.8000000000E+03, 3.1015958370E+00, 6.5169923362E+00, 8.8770683123E-02, 8.5172781317E-02, 4.5813458929E-01],
	[7.8050000000E+03, 3.1041425659E+00, 6.5154937651E+00, 8.8945411284E-02, 8.5335289322E-02, 4.5830657868E-01],
	[7.8100000000E+03, 3.1066897530E+00, 6.5139964981E+00, 8.9120370761E-02, 8.5497994506E-02, 4.5847850430E-01],
	[7.8150000000E+03, 3.1092373980E+00, 6.5125005330E+00, 8.9295561711E-02, 8.5660896951E-02, 4.5865036635E-01],
	[7.8200000000E+03, 3.1117861872E+00, 6.5110095686E+00, 8.9470984291E-02, 8.5823997906E-02, 4.5882216500E-01],
	[7.8250000000E+03, 3.1143399379E+00, 6.5095441500E+00, 8.9646638659E-02, 8.5987303958E-02, 4.5899390042E-01],
	[7.8300000000E+03, 3.1168941511E+00, 6.5080799970E+00, 8.9822524971E-02, 8.6150807575E-02, 4.5916557280E-01],
	[7.8350000000E+03, 3.1194488266E+00, 6.5066171076E+00, 8.9998643384E-02, 8.6314508838E-02, 4.5933718232E-01],
	[7.8400000000E+03, 3.1220039642E+00, 6.5051554800E+00, 9.0174994056E-02, 8.6478407831E-02, 4.5950872915E-01],
	[7.8450000000E+03, 3.1245595637E+00, 6.5036951123E+00, 9.0351577143E-02, 8.6642504634E-02, 4.5968021346E-01],
	[7.8500000000E+03, 3.1271156249E+00, 6.5022360026E+00, 9.0528392803E-02, 8.6806799329E-02, 4.5985163545E-01],
	[7.8550000000E+03, 3.1296721475E+00, 6.5007781490E+00, 9.0705441193E-02, 8.6971291998E-02, 4.6002299527E-01],
	[7.8600000000E+03, 3.1322291313E+00, 6.4993215496E+00, 9.0882722470E-02, 8.7135982722E-02, 4.6019429312E-01],
	[7.8650000000E+03, 3.1347865762E+00, 6.4978662026E+00, 9.1060236791E-02, 8.7300871583E-02, 4.6036552916E-01],
	[7.8700000000E+03, 3.1373444819E+00, 6.4964121061E+00, 9.1237984313E-02, 8.7465958661E-02, 4.6053670358E-01],
	[7.8750000000E+03, 3.1399028482E+00, 6.4949592582E+00, 9.1415965192E-02, 8.7631244038E-02, 4.6070781654E-01],
	[7.8800000000E+03, 3.1424616749E+00, 6.4935076570E+00, 9.1594179588E-02, 8.7796727795E-02, 4.6087886823E-01],
	[7.8850000000E+03, 3.1450209619E+00, 6.4920573008E+00, 9.1772627655E-02, 8.7962410013E-02, 4.6104985881E-01],
	[7.8900000000E+03, 3.1475807088E+00, 6.4906081875E+00, 9.1951309553E-02, 8.8128290773E-02, 4.6122078847E-01],
	[7.8950000000E+03, 3.1501409155E+00, 6.4891603155E+00, 9.2130225437E-02, 8.8294370154E-02, 4.6139165738E-01],
	[7.9000000000E+03, 3.1527015817E+00, 6.4877136828E+00, 9.2309375464E-02, 8.8460648239E-02, 4.6156246571E-01],
	[7.9050000000E+03, 3.1552627073E+00, 6.4862682876E+00, 9.2488759793E-02, 8.8627125106E-02, 4.6173321364E-01],
	[7.9100000000E+03, 3.1578242921E+00, 6.4848241280E+00, 9.2668378580E-02, 8.8793800837E-02, 4.6190390134E-01],
	[7.9150000000E+03, 3.1603863358E+00, 6.4833812023E+00, 9.2848231982E-02, 8.8960675511E-02, 4.6207452899E-01],
	[7.9200000000E+03, 3.1629488382E+00, 6.4819395086E+00, 9.3028320156E-02, 8.9127749209E-02, 4.6224509675E-01],
	[7.9250000000E+03, 3.1655117992E+00, 6.4804990450E+00, 9.3208643260E-02, 8.9295022011E-02, 4.6241560481E-01],
	[7.9300000000E+03, 3.1680752185E+00, 6.4790598097E+00, 9.3389201450E-02, 8.9462493996E-02, 4.6258605333E-01],
	[7.9350000000E+03, 3.1706390959E+00, 6.4776218010E+00, 9.3569994885E-02, 8.9630165245E-02, 4.6275644249E-01],
	[7.9400000000E+03, 3.1732034312E+00, 6.4761850169E+00, 9.3751023720E-02, 8.9798035837E-02, 4.6292677247E-01],
	[7.9450000000E+03, 3.1757682242E+00, 6.4747494557E+00, 9.3932288114E-02, 8.9966105851E-02, 4.6309704342E-01],
	[7.9500000000E+03, 3.1783381917E+00, 6.4733406028E+00, 9.4113788223E-02, 9.0134384101E-02, 4.6326725553E-01],
	[7.9550000000E+03, 3.1809088373E+00, 6.4719341092E+00, 9.4295524205E-02, 9.0302862390E-02, 4.6343740897E-01],
	[7.9600000000E+03, 3.1834799448E+00, 6.4705288047E+00, 9.4477496216E-02, 9.0471540398E-02, 4.6360750390E-01],
	[7.9650000000E+03, 3.1860515141E+00, 6.4691246874E+00, 9.4659704415E-02, 9.0640418204E-02, 4.6377754051E-01],
	[7.9700000000E+03, 3.1886235449E+00, 6.4677217557E+00, 9.4842148958E-02, 9.0809495888E-02, 4.6394751895E-01],
	[7.9750000000E+03, 3.1911960370E+00, 6.4663200079E+00, 9.5024830002E-02, 9.0978773528E-02, 4.6411743941E-01],
	[7.9800000000E+03, 3.1937689903E+00, 6.4649194421E+00, 9.5207747704E-02, 9.1148251203E-02, 4.6428730205E-01],
	[7.9850000000E+03, 3.1963424045E+00, 6.4635200566E+00, 9.5390902223E-02, 9.1317928993E-02, 4.6445710705E-01],
	[7.9900000000E+03, 3.1989162794E+00, 6.4621218498E+00, 9.5574293714E-02, 9.1487806975E-02, 4.6462685454E-01],
	[7.9950000000E+03, 3.2014906147E+00, 6.4607248198E+00, 9.5757922336E-02, 9.1657885229E-02, 4.6479654469E-01],
	[8.0000000000E+03, 3.2040654104E+00, 6.4593289650E+00, 9.5941788245E-02, 9.1828163833E-02, 4.6496617762E-01],
	[8.0050000000E+03, 3.2066406662E+00, 6.4579342836E+00, 9.6126875193E-02, 9.1999543808E-02, 4.6513575349E-01],
	[8.0100000000E+03, 3.2092163819E+00, 6.4565407740E+00, 9.6312202937E-02, 9.2171126990E-02, 4.6530527244E-01],
	[8.0150000000E+03, 3.2117925572E+00, 6.4551484343E+00, 9.6497771637E-02, 9.2342913459E-02, 4.6547473462E-01],
	[8.0200000000E+03, 3.2143691920E+00, 6.4537572629E+00, 9.6683581458E-02, 9.2514903296E-02, 4.6564414016E-01],
	[8.0250000000E+03, 3.2169462861E+00, 6.4523672582E+00, 9.6869632560E-02, 9.2687096581E-02, 4.6581348922E-01],
	[8.0300000000E+03, 3.2195238393E+00, 6.4509784182E+00, 9.7055925105E-02, 9.2859493396E-02, 4.6598278192E-01],
	[8.0350000000E+03, 3.2221018513E+00, 6.4495907415E+00, 9.7242459255E-02, 9.3032093820E-02, 4.6615201843E-01],
	[8.0400000000E+03, 3.2246803220E+00, 6.4482042262E+00, 9.7429235172E-02, 9.3204897936E-02, 4.6632119887E-01],
	[8.0450000000E+03, 3.2272592512E+00, 6.4468188707E+00, 9.7616253019E-02, 9.3377905822E-02, 4.6649032340E-01],
	[8.0500000000E+03, 3.2298386385E+00, 6.4454346734E+00, 9.7803512957E-02, 9.3551117558E-02, 4.6665939215E-01],
	[8.0550000000E+03, 3.2324184840E+00, 6.4440516324E+00, 9.7991015148E-02, 9.3724533226E-02, 4.6682840526E-01],
	[8.0600000000E+03, 3.2349987873E+00, 6.4426697461E+00, 9.8178759754E-02, 9.3898152905E-02, 4.6699736289E-01],
	[8.0650000000E+03, 3.2375795482E+00, 6.4412890129E+00, 9.8366746937E-02, 9.4071976675E-02, 4.6716626516E-01],
	[8.0700000000E+03, 3.2401607666E+00, 6.4399094311E+00, 9.8554976859E-02, 9.4246004616E-02, 4.6733511223E-01],
	[8.0750000000E+03, 3.2427442181E+00, 6.4385405389E+00, 9.8743449682E-02, 9.4420240364E-02, 4.6750390423E-01],
	[8.0800000000E+03, 3.2453310929E+00, 6.4371886937E+00, 9.8932165569E-02, 9.4594686419E-02, 4.6767264131E-01],
	[8.0850000000E+03, 3.2479184292E+00, 6.4358379683E+00, 9.9121124680E-02, 9.4769336943E-02, 4.6784132360E-01],
	[8.0900000000E+03, 3.2505062267E+00, 6.4344883612E+00, 9.9310327179E-02, 9.4944192016E-02, 4.6800995125E-01],
	[8.0950000000E+03, 3.2530944853E+00, 6.4331398707E+00, 9.9499773226E-02, 9.5119251718E-02, 4.6817852440E-01],
	[8.1000000000E+03, 3.2556832047E+00, 6.4317924952E+00, 9.9689462985E-02, 9.5294516127E-02, 4.6834704318E-01],
	[8.1050000000E+03, 3.2582723847E+00, 6.4304462331E+00, 9.9879396617E-02, 9.5469985323E-02, 4.6851550775E-01],
	[8.1100000000E+03, 3.2608620252E+00, 6.4291010827E+00, 1.0006957428E-01, 9.5645659385E-02, 4.6868391823E-01],
	[8.1150000000E+03, 3.2634521259E+00, 6.4277570426E+00, 1.0025999615E-01, 9.5821538392E-02, 4.6885227477E-01],
	[8.1200000000E+03, 3.2660426866E+00, 6.4264141111E+00, 1.0045066237E-01, 9.5997622422E-02, 4.6902057752E-01],
	[8.1250000000E+03, 3.2686337072E+00, 6.4250722865E+00, 1.0064157312E-01, 9.6173911555E-02, 4.6918882660E-01],
	[8.1300000000E+03, 3.2712251874E+00, 6.4237315673E+00, 1.0083272855E-01, 9.6350405868E-02, 4.6935702215E-01],
	[8.1350000000E+03, 3.2738171271E+00, 6.4223919520E+00, 1.0102412882E-01, 9.6527105440E-02, 4.6952516433E-01],
	[8.1400000000E+03, 3.2764095260E+00, 6.4210534388E+00, 1.0121577411E-01, 9.6704010350E-02, 4.6969325326E-01],
	[8.1450000000E+03, 3.2790023838E+00, 6.4197160263E+00, 1.0140766456E-01, 9.6881120675E-02, 4.6986128909E-01],
	[8.1500000000E+03, 3.2815957006E+00, 6.4183797129E+00, 1.0159980034E-01, 9.7058436494E-02, 4.7002927195E-01],
	[8.1550000000E+03, 3.2841894759E+00, 6.4170444969E+00, 1.0179218162E-01, 9.7235957885E-02, 4.7019720199E-01],
	[8.1600000000E+03, 3.2867837097E+00, 6.4157103769E+00, 1.0198480856E-01, 9.7413684925E-02, 4.7036507934E-01],
	[8.1650000000E+03, 3.2893784017E+00, 6.4143773511E+00, 1.0217768131E-01, 9.7591617692E-02, 4.7053290413E-01],
	[8.1700000000E+03, 3.2919735517E+00, 6.4130454182E+00, 1.0237080004E-01, 9.7769756264E-02, 4.7070067652E-01],
	[8.1750000000E+03, 3.2945691596E+00, 6.4117145764E+00, 1.0256416492E-01, 9.7948100719E-02, 4.7086839663E-01],
	[8.1800000000E+03, 3.2971652251E+00, 6.4103848244E+00, 1.0275777610E-01, 9.8126651132E-02, 4.7103606461E-01],
	[8.1850000000E+03, 3.2997617480E+00, 6.4090561603E+00, 1.0295163374E-01, 9.8305407583E-02, 4.7120368059E-01],
	[8.1900000000E+03, 3.3023587281E+00, 6.4077285829E+00, 1.0314573802E-01, 9.8484370147E-02, 4.7137124471E-01],
	[8.1950000000E+03, 3.3049561653E+00, 6.4064020904E+00, 1.0334008909E-01, 9.8663538902E-02, 4.7153875710E-01],
	[8.2000000000E+03, 3.3075540593E+00, 6.4050766813E+00, 1.0353468711E-01, 9.8842913925E-02, 4.7170621791E-01],
	[8.2050000000E+03, 3.3101541648E+00, 6.4037616359E+00, 1.0372953224E-01, 9.9022499082E-02, 4.7187362727E-01],
	[8.2100000000E+03, 3.3127575750E+00, 6.4024627030E+00, 1.0392462466E-01, 9.9202296847E-02, 4.7204098531E-01],
	[8.2150000000E+03, 3.3153614458E+00, 6.4011648241E+00, 1.0411996451E-01, 9.9382301172E-02, 4.7220829219E-01],
	[8.2200000000E+03, 3.3179657772E+00, 6.3998679978E+00, 1.0431555197E-01, 9.9562512134E-02, 4.7237554802E-01],
	[8.2250000000E+03, 3.3205705687E+00, 6.3985722226E+00, 1.0451138719E-01, 9.9742929808E-02, 4.7254275295E-01],
	[8.2300000000E+03, 3.3231758204E+00, 6.3972774970E+00, 1.0470747033E-01, 9.9923554272E-02, 4.7270990711E-01],
	[8.2350000000E+03, 3.3257815319E+00, 6.3959838194E+00, 1.0490380157E-01, 1.0010438560E-01, 4.7287701065E-01],
	[8.2400000000E+03, 3.3283877031E+00, 6.3946911885E+00, 1.0510038105E-01, 1.0028542387E-01, 4.7304406369E-01],
	[8.2450000000E+03, 3.3309943338E+00, 6.3933996027E+00, 1.0529720895E-01, 1.0046666916E-01, 4.7321106637E-01],
	[8.2500000000E+03, 3.3336014237E+00, 6.3921090605E+00, 1.0549428543E-01, 1.0064812154E-01, 4.7337801882E-01],
	[8.2550000000E+03, 3.3362089727E+00, 6.3908195605E+00, 1.0569161064E-01, 1.0082978109E-01, 4.7354492120E-01],
	[8.2600000000E+03, 3.3388169806E+00, 6.3895311013E+00, 1.0588918475E-01, 1.0101164789E-01, 4.7371177362E-01],
	[8.2650000000E+03, 3.3414254472E+00, 6.3882436812E+00, 1.0608700792E-01, 1.0119372200E-01, 4.7387857622E-01],
	[8.2700000000E+03, 3.3440343723E+00, 6.3869572990E+00, 1.0628508032E-01, 1.0137600352E-01, 4.7404532914E-01],
	[8.2750000000E+03, 3.3466437556E+00, 6.3856719530E+00, 1.0648340210E-01, 1.0155849250E-01, 4.7421203251E-01],
	[8.2800000000E+03, 3.3492535971E+00, 6.3843876419E+00, 1.0668197344E-01, 1.0174118903E-01, 4.7437868647E-01],
	[8.2850000000E+03, 3.3518638964E+00, 6.3831043641E+00, 1.0688079448E-01, 1.0192409318E-01, 4.7454529116E-01],
	[8.2900000000E+03, 3.3544746534E+00, 6.3818221183E+00, 1.0707986540E-01, 1.0210720502E-01, 4.7471184670E-01],
	[8.2950000000E+03, 3.3570858680E+00, 6.3805409030E+00, 1.0727918635E-01, 1.0229052464E-01, 4.7487835323E-01],
	[8.3000000000E+03, 3.3596975398E+00, 6.3792607167E+00, 1.0747875750E-01, 1.0247405210E-01, 4.7504481089E-01],
	[8.3050000000E+03, 3.3623096688E+00, 6.3779815580E+00, 1.0767857901E-01, 1.0265778748E-01, 4.7521121980E-01],
	[8.3100000000E+03, 3.3649222547E+00, 6.3767034255E+00, 1.0787865105E-01, 1.0284173086E-01, 4.7537758011E-01],
	[8.3150000000E+03, 3.3675352973E+00, 6.3754263176E+00, 1.0807897377E-01, 1.0302588231E-01, 4.7554389195E-01],
	[8.3200000000E+03, 3.3701487964E+00, 6.3741502331E+00, 1.0827954733E-01, 1.0321024190E-01, 4.7571015545E-01],
	[8.3250000000E+03, 3.3727627519E+00, 6.3728751703E+00, 1.0848037191E-01, 1.0339480970E-01, 4.7587637074E-01],
	[8.3300000000E+03, 3.3753771635E+00, 6.3716011280E+00, 1.0868144766E-01, 1.0357958580E-01, 4.7604253796E-01],
	[8.3350000000E+03, 3.3779920310E+00, 6.3703281046E+00, 1.0888277474E-01, 1.0376457026E-01, 4.7620865724E-01],
	[8.3400000000E+03, 3.3806116822E+00, 6.3690786338E+00, 1.0908435332E-01, 1.0394977325E-01, 4.7637472871E-01],
	[8.3450000000E+03, 3.3832319280E+00, 6.3678308592E+00, 1.0928618355E-01, 1.0413518514E-01, 4.7654075251E-01],
	[8.3500000000E+03, 3.3858526335E+00, 6.3665840762E+00, 1.0948826561E-01, 1.0432080567E-01, 4.7670672876E-01],
	[8.3550000000E+03, 3.3884737984E+00, 6.3653382835E+00, 1.0969059965E-01, 1.0450663493E-01, 4.7687265761E-01],
	[8.3600000000E+03, 3.3910954224E+00, 6.3640934797E+00, 1.0989318584E-01, 1.0469267298E-01, 4.7703853919E-01],
	[8.3650000000E+03, 3.3937175055E+00, 6.3628496633E+00, 1.1009602434E-01, 1.0487891990E-01, 4.7720437361E-01],
	[8.3700000000E+03, 3.3963400474E+00, 6.3616068331E+00, 1.1029911531E-01, 1.0506537577E-01, 4.7737016103E-01],
	[8.3750000000E+03, 3.3989630479E+00, 6.3603649876E+00, 1.1050245891E-01, 1.0525204065E-01, 4.7753590157E-01],
	[8.3800000000E+03, 3.4015865069E+00, 6.3591241255E+00, 1.1070605530E-01, 1.0543891462E-01, 4.7770159536E-01],
	[8.3850000000E+03, 3.4042104241E+00, 6.3578842454E+00, 1.1090990466E-01, 1.0562599775E-01, 4.7786724254E-01],
	[8.3900000000E+03, 3.4068347993E+00, 6.3566453459E+00, 1.1111400713E-01, 1.0581329012E-01, 4.7803284323E-01],
	[8.3950000000E+03, 3.4094596324E+00, 6.3554074258E+00, 1.1131836289E-01, 1.0600079179E-01, 4.7819839757E-01],
	[8.4000000000E+03, 3.4120849232E+00, 6.3541704836E+00, 1.1152297209E-01, 1.0618850284E-01, 4.7836390569E-01],
	[8.4050000000E+03, 3.4147106714E+00, 6.3529345180E+00, 1.1172783490E-01, 1.0637642335E-01, 4.7852936771E-01],
	[8.4100000000E+03, 3.4173368769E+00, 6.3516995276E+00, 1.1193295148E-01, 1.0656455338E-01, 4.7869478378E-01],
	[8.4150000000E+03, 3.4199635394E+00, 6.3504655111E+00, 1.1213832199E-01, 1.0675289300E-01, 4.7886015403E-01],
	[8.4200000000E+03, 3.4225906589E+00, 6.3492324672E+00, 1.1234394660E-01, 1.0694144229E-01, 4.7902547855E-01],
	[8.4250000000E+03, 3.4252182351E+00, 6.3480003944E+00, 1.1254982547E-01, 1.0713020133E-01, 4.7919075747E-01],
	[8.4300000000E+03, 3.4278462677E+00, 6.3467692915E+00, 1.1275595875E-01, 1.0731917017E-01, 4.7935599087E-01],
	[8.4350000000E+03, 3.4304747567E+00, 6.3455391571E+00, 1.1296234662E-01, 1.0750834889E-01, 4.7952117888E-01],
	[8.4400000000E+03, 3.4331037018E+00, 6.3443099899E+00, 1.1316898923E-01, 1.0769773757E-01, 4.7968632159E-01],
	[8.4450000000E+03, 3.4357331029E+00, 6.3430817886E+00, 1.1337588675E-01, 1.0788733628E-01, 4.7985141912E-01],
	[8.4500000000E+03, 3.4383629596E+00, 6.3418545517E+00, 1.1358303934E-01, 1.0807714508E-01, 4.8001647156E-01],
	[8.4550000000E+03, 3.4409932720E+00, 6.3406282781E+00, 1.1379044716E-01, 1.0826716405E-01, 4.8018147902E-01],
	[8.4600000000E+03, 3.4436240397E+00, 6.3394029663E+00, 1.1399811038E-01, 1.0845739326E-01, 4.8034644161E-01],
	[8.4650000000E+03, 3.4462552625E+00, 6.3381786151E+00, 1.1420602915E-01, 1.0864783278E-01, 4.8051135944E-01],
	[8.4700000000E+03, 3.4488875144E+00, 6.3369581718E+00, 1.1441420364E-01, 1.0883848412E-01, 4.8067623261E-01],
	[8.4750000000E+03, 3.4515239707E+00, 6.3357579236E+00, 1.1462263402E-01, 1.0902935536E-01, 4.8084106122E-01],
	[8.4800000000E+03, 3.4541608856E+00, 6.3345586104E+00, 1.1483132044E-01, 1.0922043719E-01, 4.8100584538E-01],
	[8.4850000000E+03, 3.4567982590E+00, 6.3333602310E+00, 1.1504026307E-01, 1.0941172967E-01, 4.8117058519E-01],
	[8.4900000000E+03, 3.4594360907E+00, 6.3321627841E+00, 1.1524948837E-01, 1.0960325667E-01, 4.8133528077E-01],
	[8.4950000000E+03, 3.4620743804E+00, 6.3309662683E+00, 1.1545897185E-01, 1.0979499596E-01, 4.8149993221E-01],
	[8.5000000000E+03, 3.4647131281E+00, 6.3297706825E+00, 1.1566871212E-01, 1.0998694619E-01, 4.8166453963E-01],
	[8.5050000000E+03, 3.4673523334E+00, 6.3285760254E+00, 1.1587870934E-01, 1.1017910743E-01, 4.8182910311E-01],
	[8.5100000000E+03, 3.4699919962E+00, 6.3273822957E+00, 1.1608896368E-01, 1.1037147977E-01, 4.8199362278E-01],
	[8.5150000000E+03, 3.4726321164E+00, 6.3261894921E+00, 1.1629947529E-01, 1.1056406325E-01, 4.8215809873E-01],
	[8.5200000000E+03, 3.4752726937E+00, 6.3249976133E+00, 1.1651024434E-01, 1.1075685797E-01, 4.8232253107E-01],
	[8.5250000000E+03, 3.4779137279E+00, 6.3238066582E+00, 1.1672127099E-01, 1.1094986398E-01, 4.8248691990E-01],
	[8.5300000000E+03, 3.4805552188E+00, 6.3226166254E+00, 1.1693255541E-01, 1.1114308135E-01, 4.8265126533E-01],
	[8.5350000000E+03, 3.4831971664E+00, 6.3214275138E+00, 1.1714409776E-01, 1.1133651016E-01, 4.8281556746E-01],
	[8.5400000000E+03, 3.4858395703E+00, 6.3202393220E+00, 1.1735589819E-01, 1.1153015047E-01, 4.8297982640E-01],
	[8.5450000000E+03, 3.4884824304E+00, 6.3190520487E+00, 1.1756795688E-01, 1.1172400236E-01, 4.8314404225E-01],
	[8.5500000000E+03, 3.4911257464E+00, 6.3178656929E+00, 1.1778027398E-01, 1.1191806588E-01, 4.8330821511E-01],
	[8.5550000000E+03, 3.4937695183E+00, 6.3166802531E+00, 1.1799284966E-01, 1.1211234112E-01, 4.8347234509E-01],
	[8.5600000000E+03, 3.4964137458E+00, 6.3154957282E+00, 1.1820568408E-01, 1.1230682814E-01, 4.8363643229E-01],
	[8.5650000000E+03, 3.4990584288E+00, 6.3143121169E+00, 1.1841877741E-01, 1.1250152700E-01, 4.8380047681E-01],
	[8.5700000000E+03, 3.5017035670E+00, 6.3131294180E+00, 1.1863212980E-01, 1.1269643778E-01, 4.8396447877E-01],
	[8.5750000000E+03, 3.5043491602E+00, 6.3119476303E+00, 1.1884574142E-01, 1.1289156055E-01, 4.8412843825E-01],
	[8.5800000000E+03, 3.5069952083E+00, 6.3107667525E+00, 1.1905961244E-01, 1.1308689537E-01, 4.8429235538E-01],
	[8.5850000000E+03, 3.5096417111E+00, 6.3095867834E+00, 1.1927374300E-01, 1.1328244230E-01, 4.8445623024E-01],
	[8.5900000000E+03, 3.5122886684E+00, 6.3084077217E+00, 1.1948813329E-01, 1.1347820143E-01, 4.8462006294E-01],
	[8.5950000000E+03, 3.5149360800E+00, 6.3072295663E+00, 1.1970278346E-01, 1.1367417282E-01, 4.8478385359E-01],
	[8.6000000000E+03, 3.5175839457E+00, 6.3060523159E+00, 1.1991769367E-01, 1.1387035653E-01, 4.8494760229E-01],
	[8.6050000000E+03, 3.5202322654E+00, 6.3048759692E+00, 1.2013286409E-01, 1.1406675263E-01, 4.8511130914E-01],
	[8.6100000000E+03, 3.5228846514E+00, 6.3037188197E+00, 1.2034829487E-01, 1.1426337100E-01, 4.8527497424E-01],
	[8.6150000000E+03, 3.5255380638E+00, 6.3025654354E+00, 1.2056398619E-01, 1.1446020351E-01, 4.8543859770E-01],
	[8.6200000000E+03, 3.5281919335E+00, 6.3014129312E+00, 1.2077993820E-01, 1.1465724868E-01, 4.8560217962E-01],
	[8.6250000000E+03, 3.5308462602E+00, 6.3002613058E+00, 1.2099615107E-01, 1.1485450659E-01, 4.8576572011E-01],
	[8.6300000000E+03, 3.5335010438E+00, 6.2991105582E+00, 1.2121262497E-01, 1.1505197728E-01, 4.8592921926E-01],
	[8.6350000000E+03, 3.5361562840E+00, 6.2979606871E+00, 1.2142936004E-01, 1.1524966085E-01, 4.8609267718E-01],
	[8.6400000000E+03, 3.5388119808E+00, 6.2968116913E+00, 1.2164635646E-01, 1.1544755734E-01, 4.8625609397E-01],
	[8.6450000000E+03, 3.5414681339E+00, 6.2956635697E+00, 1.2186361439E-01, 1.1564566683E-01, 4.8641946973E-01],
	[8.6500000000E+03, 3.5441247431E+00, 6.2945163211E+00, 1.2208113399E-01, 1.1584398938E-01, 4.8658280457E-01],
	[8.6550000000E+03, 3.5467818083E+00, 6.2933699443E+00, 1.2229891543E-01, 1.1604252507E-01, 4.8674609858E-01],
	[8.6600000000E+03, 3.5494393292E+00, 6.2922244382E+00, 1.2251695886E-01, 1.1624127395E-01, 4.8690935187E-01],
	[8.6650000000E+03, 3.5520973056E+00, 6.2910798017E+00, 1.2273526446E-01, 1.1644023610E-01, 4.8707256455E-01],
	[8.6700000000E+03, 3.5547557375E+00, 6.2899360334E+00, 1.2295383238E-01, 1.1663941157E-01, 4.8723573671E-01],
	[8.6750000000E+03, 3.5574146246E+00, 6.2887931324E+00, 1.2317266278E-01, 1.1683880045E-01, 4.8739886845E-01],
	[8.6800000000E+03, 3.5600739667E+00, 6.2876510974E+00, 1.2339175584E-01, 1.1703840278E-01, 4.8756195988E-01],
	[8.6850000000E+03, 3.5627337636E+00, 6.2865099272E+00, 1.2361111170E-01, 1.1723821864E-01, 4.8772501111E-01],
	[8.6900000000E+03, 3.5653940152E+00, 6.2853696208E+00, 1.2383073055E-01, 1.1743824810E-01, 4.8788802222E-01],
	[8.6950000000E+03, 3.5680547212E+00, 6.2842301770E+00, 1.2405061253E-01, 1.1763849121E-01, 4.8805099332E-01],
	[8.7000000000E+03, 3.5707158815E+00, 6.2830915946E+00, 1.2427075781E-01, 1.1783894805E-01, 4.8821392452E-01],
	[8.7050000000E+03, 3.5733774959E+00, 6.2819538725E+00, 1.2449116655E-01, 1.1803961868E-01, 4.8837681591E-01],
	[8.7100000000E+03, 3.5760395643E+00, 6.2808170095E+00, 1.2471183893E-01, 1.1824050316E-01, 4.8853966760E-01],
	[8.7150000000E+03, 3.5787020863E+00, 6.2796810045E+00, 1.2493277509E-01, 1.1844160156E-01, 4.8870247969E-01],
	[8.7200000000E+03, 3.5813650619E+00, 6.2785458564E+00, 1.2515397520E-01, 1.1864291395E-01, 4.8886525227E-01],
	[8.7250000000E+03, 3.5840284909E+00, 6.2774115639E+00, 1.2537543944E-01, 1.1884444038E-01, 4.8902798546E-01],
	[8.7300000000E+03, 3.5866923731E+00, 6.2762781261E+00, 1.2559716795E-01, 1.1904618093E-01, 4.8919067935E-01],
	[8.7350000000E+03, 3.5893567082E+00, 6.2751455417E+00, 1.2581916090E-01, 1.1924813566E-01, 4.8935333404E-01],
	[8.7400000000E+03, 3.5920214962E+00, 6.2740138097E+00, 1.2604141846E-01, 1.1945030463E-01, 4.8951594963E-01],
	[8.7450000000E+03, 3.5946873665E+00, 6.2728860795E+00, 1.2626394078E-01, 1.1965268976E-01, 4.8967852623E-01],
	[8.7500000000E+03, 3.5973570999E+00, 6.2717762430E+00, 1.2648672804E-01, 1.1985529927E-01, 4.8984106393E-01],
	[8.7550000000E+03, 3.6000272893E+00, 6.2706672367E+00, 1.2670978039E-01, 1.2005812329E-01, 4.9000356284E-01],
	[8.7600000000E+03, 3.6026979344E+00, 6.2695590596E+00, 1.2693309800E-01, 1.2026116188E-01, 4.9016602306E-01],
	[8.7650000000E+03, 3.6053690352E+00, 6.2684517104E+00, 1.2715668103E-01, 1.2046441511E-01, 4.9032844468E-01],
	[8.7700000000E+03, 3.6080405913E+00, 6.2673451882E+00, 1.2738052964E-01, 1.2066788303E-01, 4.9049082781E-01],
	[8.7750000000E+03, 3.6107126027E+00, 6.2662394918E+00, 1.2760464399E-01, 1.2087156571E-01, 4.9065317254E-01],
	[8.7800000000E+03, 3.6133850691E+00, 6.2651346202E+00, 1.2782902426E-01, 1.2107546321E-01, 4.9081547899E-01],
	[8.7850000000E+03, 3.6160579904E+00, 6.2640305722E+00, 1.2805367060E-01, 1.2127957560E-01, 4.9097774724E-01],
	[8.7900000000E+03, 3.6187313663E+00, 6.2629273468E+00, 1.2827858317E-01, 1.2148390295E-01, 4.9113997740E-01],
	[8.7950000000E+03, 3.6214051968E+00, 6.2618249429E+00, 1.2850376214E-01, 1.2168844530E-01, 4.9130216957E-01],
	[8.8000000000E+03, 3.6240794816E+00, 6.2607233595E+00, 1.2872920768E-01, 1.2189320274E-01, 4.9146432385E-01],
	[8.8050000000E+03, 3.6267542205E+00, 6.2596225953E+00, 1.2895491993E-01, 1.2209817531E-01, 4.9162644034E-01],
	[8.8100000000E+03, 3.6294294134E+00, 6.2585226495E+00, 1.2918089908E-01, 1.2230336309E-01, 4.9178851914E-01],
	[8.8150000000E+03, 3.6321050600E+00, 6.2574235209E+00, 1.2940714528E-01, 1.2250876613E-01, 4.9195056035E-01],
	[8.8200000000E+03, 3.6347811602E+00, 6.2563252084E+00, 1.2963365868E-01, 1.2271438450E-01, 4.9211256406E-01],
	[8.8250000000E+03, 3.6374577139E+00, 6.2552277109E+00, 1.2986043947E-01, 1.2292021826E-01, 4.9227453038E-01],
	[8.8300000000E+03, 3.6401347208E+00, 6.2541310275E+00, 1.3008748780E-01, 1.2312626748E-01, 4.9243645940E-01],
	[8.8350000000E+03, 3.6428121807E+00, 6.2530351570E+00, 1.3031480383E-01, 1.2333253221E-01, 4.9259835118E-01],
	[8.8400000000E+03, 3.6454900936E+00, 6.2519400983E+00, 1.3054238772E-01, 1.2353901252E-01, 4.9276020581E-01],
	[8.8450000000E+03, 3.6481684591E+00, 6.2508458505E+00, 1.3077023965E-01, 1.2374570846E-01, 4.9292202335E-01],
	[8.8500000000E+03, 3.6508472771E+00, 6.2497524124E+00, 1.3099835976E-01, 1.2395262011E-01, 4.9308380389E-01],
	[8.8550000000E+03, 3.6535265475E+00, 6.2486597830E+00, 1.3122674823E-01, 1.2415974752E-01, 4.9324554750E-01],
	[8.8600000000E+03, 3.6562062700E+00, 6.2475679613E+00, 1.3145540523E-01, 1.2436709075E-01, 4.9340725427E-01],
	[8.8650000000E+03, 3.6588864445E+00, 6.2464769461E+00, 1.3168433090E-01, 1.2457464987E-01, 4.9356892427E-01],
	[8.8700000000E+03, 3.6615670708E+00, 6.2453867365E+00, 1.3191352542E-01, 1.2478242493E-01, 4.9373055757E-01],
	[8.8750000000E+03, 3.6642481487E+00, 6.2442973314E+00, 1.3214298894E-01, 1.2499041601E-01, 4.9389215426E-01],
	[8.8800000000E+03, 3.6669296781E+00, 6.2432087297E+00, 1.3237272164E-01, 1.2519862315E-01, 4.9405371441E-01],
	[8.8850000000E+03, 3.6696116662E+00, 6.2421209675E+00, 1.3260272367E-01, 1.2540704644E-01, 4.9421523810E-01],
	[8.8900000000E+03, 3.6722979942E+00, 6.2410532216E+00, 1.3283299520E-01, 1.2561569826E-01, 4.9437672541E-01],
	[8.8950000000E+03, 3.6749847765E+00, 6.2399862586E+00, 1.3306353639E-01, 1.2582456640E-01, 4.9453817641E-01],
	[8.9000000000E+03, 3.6776720131E+00, 6.2389200773E+00, 1.3329434740E-01, 1.2603365093E-01, 4.9469959117E-01],
	[8.9050000000E+03, 3.6803597038E+00, 6.2378546770E+00, 1.3352542840E-01, 1.2624295189E-01, 4.9486096979E-01],
	[8.9100000000E+03, 3.6830478483E+00, 6.2367900564E+00, 1.3375677956E-01, 1.2645246937E-01, 4.9502231233E-01],
	[8.9150000000E+03, 3.6857364466E+00, 6.2357262147E+00, 1.3398840102E-01, 1.2666220340E-01, 4.9518361888E-01],
	[8.9200000000E+03, 3.6884254983E+00, 6.2346631507E+00, 1.3422029296E-01, 1.2687215406E-01, 4.9534488950E-01],
	[8.9250000000E+03, 3.6911150034E+00, 6.2336008636E+00, 1.3445245555E-01, 1.2708232140E-01, 4.9550612427E-01],
	[8.9300000000E+03, 3.6938049617E+00, 6.2325393522E+00, 1.3468488893E-01, 1.2729270549E-01, 4.9566732328E-01],
	[8.9350000000E+03, 3.6964953729E+00, 6.2314786157E+00, 1.3491759328E-01, 1.2750330639E-01, 4.9582848660E-01],
	[8.9400000000E+03, 3.6991862370E+00, 6.2304186529E+00, 1.3515056876E-01, 1.2771412414E-01, 4.9598961431E-01],
	[8.9450000000E+03, 3.7018775537E+00, 6.2293594629E+00, 1.3538381554E-01, 1.2792515882E-01, 4.9615070647E-01],
	[8.9500000000E+03, 3.7045693229E+00, 6.2283010448E+00, 1.3561733377E-01, 1.2813641048E-01, 4.9631176318E-01],
	[8.9550000000E+03, 3.7072615443E+00, 6.2272433975E+00, 1.3585112362E-01, 1.2834787919E-01, 4.9647278451E-01],
	[8.9600000000E+03, 3.7099542179E+00, 6.2261865199E+00, 1.3608518525E-01, 1.2855956499E-01, 4.9663377052E-01],
	[8.9650000000E+03, 3.7126473433E+00, 6.2251304113E+00, 1.3631951883E-01, 1.2877146796E-01, 4.9679472131E-01],
	[8.9700000000E+03, 3.7153409206E+00, 6.2240750704E+00, 1.3655412452E-01, 1.2898358814E-01, 4.9695563694E-01],
	[8.9750000000E+03, 3.7180349494E+00, 6.2230204964E+00, 1.3678900248E-01, 1.2919592560E-01, 4.9711651750E-01],
	[8.9800000000E+03, 3.7207294296E+00, 6.2219666883E+00, 1.3702415287E-01, 1.2940848040E-01, 4.9727736305E-01],
	[8.9850000000E+03, 3.7234243610E+00, 6.2209136451E+00, 1.3725957587E-01, 1.2962125259E-01, 4.9743817368E-01],
	[8.9900000000E+03, 3.7261197435E+00, 6.2198613658E+00, 1.3749527163E-01, 1.2983424223E-01, 4.9759894946E-01],
	[8.9950000000E+03, 3.7288155768E+00, 6.2188098495E+00, 1.3773124031E-01, 1.3004744939E-01, 4.9775969047E-01],
	[9.0000000000E+03, 3.7315118609E+00, 6.2177590951E+00, 1.3796748208E-01, 1.3026087411E-01, 4.9792039679E-01],
	[9.0050000000E+03, 3.7342085954E+00, 6.2167091016E+00, 1.3820540343E-01, 1.3047576988E-01, 4.9808106849E-01],
	[9.0100000000E+03, 3.7369057804E+00, 6.2156598682E+00, 1.3844360222E-01, 1.3069088655E-01, 4.9824170564E-01],
	[9.0150000000E+03, 3.7396034154E+00, 6.2146113938E+00, 1.3868207864E-01, 1.3090622419E-01, 4.9840230833E-01],
	[9.0200000000E+03, 3.7423015005E+00, 6.2135636775E+00, 1.3892083286E-01, 1.3112178287E-01, 4.9856287663E-01],
	[9.0250000000E+03, 3.7450000355E+00, 6.2125167183E+00, 1.3915986503E-01, 1.3133756265E-01, 4.9872341062E-01],
	[9.0300000000E+03, 3.7477005084E+00, 6.2114777626E+00, 1.3939917534E-01, 1.3155356865E-01, 4.9888391037E-01],
	[9.0350000000E+03, 3.7504037159E+00, 6.2104506664E+00, 1.3963876394E-01, 1.3176980373E-01, 4.9904437595E-01],
	[9.0400000000E+03, 3.7531073760E+00, 6.2094243081E+00, 1.3987863101E-01, 1.3198626015E-01, 4.9920480746E-01],
	[9.0450000000E+03, 3.7558114886E+00, 6.2083986867E+00, 1.4011877672E-01, 1.3220293797E-01, 4.9936520495E-01],
	[9.0500000000E+03, 3.7585160535E+00, 6.2073738015E+00, 1.4035920123E-01, 1.3241983726E-01, 4.9952556851E-01],
	[9.0550000000E+03, 3.7612210706E+00, 6.2063496514E+00, 1.4059990472E-01, 1.3263695807E-01, 4.9968589821E-01],
	[9.0600000000E+03, 3.7639265396E+00, 6.2053262354E+00, 1.4084088734E-01, 1.3285430047E-01, 4.9984619413E-01],
	[9.0650000000E+03, 3.7666324603E+00, 6.2043035527E+00, 1.4108214928E-01, 1.3307186451E-01, 5.0000645635E-01],
	[9.0700000000E+03, 3.7693388327E+00, 6.2032816024E+00, 1.4132369069E-01, 1.3328965026E-01, 5.0016668493E-01],
	[9.0750000000E+03, 3.7720456565E+00, 6.2022603835E+00, 1.4156551176E-01, 1.3350765776E-01, 5.0032687997E-01],
	[9.0800000000E+03, 3.7747529316E+00, 6.2012398950E+00, 1.4180761263E-01, 1.3372588709E-01, 5.0048704152E-01],
	[9.0850000000E+03, 3.7774606577E+00, 6.2002201361E+00, 1.4204999350E-01, 1.3394433829E-01, 5.0064716967E-01],
	[9.0900000000E+03, 3.7801688348E+00, 6.1992011059E+00, 1.4229265451E-01, 1.3416301143E-01, 5.0080726450E-01],
	[9.0950000000E+03, 3.7828774625E+00, 6.1981828033E+00, 1.4253559585E-01, 1.3438190657E-01, 5.0096732608E-01],
	[9.1000000000E+03, 3.7855865409E+00, 6.1971652275E+00, 1.4277881768E-01, 1.3460102376E-01, 5.0112735448E-01],
	[9.1050000000E+03, 3.7882960696E+00, 6.1961483777E+00, 1.4302232017E-01, 1.3482036306E-01, 5.0128734978E-01],
	[9.1100000000E+03, 3.7910060486E+00, 6.1951322527E+00, 1.4326610349E-01, 1.3503992454E-01, 5.0144731206E-01],
	[9.1150000000E+03, 3.7937164776E+00, 6.1941168519E+00, 1.4351016780E-01, 1.3525970824E-01, 5.0160724139E-01],
	[9.1200000000E+03, 3.7964273565E+00, 6.1931021741E+00, 1.4375451328E-01, 1.3547971422E-01, 5.0176713785E-01],
	[9.1250000000E+03, 3.7991386851E+00, 6.1920882186E+00, 1.4399914009E-01, 1.3569994255E-01, 5.0192700151E-01],
	[9.1300000000E+03, 3.8018504632E+00, 6.1910749844E+00, 1.4424404841E-01, 1.3592039328E-01, 5.0208683246E-01],
	[9.1350000000E+03, 3.8045626906E+00, 6.1900624705E+00, 1.4448923839E-01, 1.3614106647E-01, 5.0224663075E-01],
	[9.1400000000E+03, 3.8072753673E+00, 6.1890506762E+00, 1.4473471022E-01, 1.3636196217E-01, 5.0240639648E-01],
	[9.1450000000E+03, 3.8099884930E+00, 6.1880396005E+00, 1.4498046406E-01, 1.3658308044E-01, 5.0256612971E-01],
	[9.1500000000E+03, 3.8127020675E+00, 6.1870292425E+00, 1.4522650007E-01, 1.3680442135E-01, 5.0272583052E-01],
	[9.1550000000E+03, 3.8154160907E+00, 6.1860196012E+00, 1.4547281843E-01, 1.3702598493E-01, 5.0288549899E-01],
	[9.1600000000E+03, 3.8181305624E+00, 6.1850106759E+00, 1.4571941931E-01, 1.3724777126E-01, 5.0304513518E-01],
	[9.1650000000E+03, 3.8208454824E+00, 6.1840024655E+00, 1.4596630287E-01, 1.3746978039E-01, 5.0320473919E-01],
	[9.1700000000E+03, 3.8235608506E+00, 6.1829949693E+00, 1.4621346928E-01, 1.3769201237E-01, 5.0336431108E-01],
	[9.1750000000E+03, 3.8262778740E+00, 6.1819939204E+00, 1.4646091872E-01, 1.3791447169E-01, 5.0352385092E-01],
	[9.1800000000E+03, 3.8289978333E+00, 6.1810053815E+00, 1.4670865134E-01, 1.3813716313E-01, 5.0368335880E-01],
	[9.1850000000E+03, 3.8317182435E+00, 6.1800175387E+00, 1.4695666732E-01, 1.3836007767E-01, 5.0384283478E-01],
	[9.1900000000E+03, 3.8344391044E+00, 6.1790303913E+00, 1.4720496684E-01, 1.3858321536E-01, 5.0400227895E-01],
	[9.1950000000E+03, 3.8371604158E+00, 6.1780439384E+00, 1.4745355005E-01, 1.3880657626E-01, 5.0416169137E-01],
	[9.2000000000E+03, 3.8398821776E+00, 6.1770581791E+00, 1.4770241712E-01, 1.3903016043E-01, 5.0432107213E-01],
	[9.2050000000E+03, 3.8426043896E+00, 6.1760731126E+00, 1.4795156823E-01, 1.3925396793E-01, 5.0448042129E-01],
	[9.2100000000E+03, 3.8453270516E+00, 6.1750887379E+00, 1.4820100354E-01, 1.3947799880E-01, 5.0463973894E-01],
	[9.2150000000E+03, 3.8480501635E+00, 6.1741050543E+00, 1.4845072322E-01, 1.3970225310E-01, 5.0479902515E-01],
	[9.2200000000E+03, 3.8507737251E+00, 6.1731220608E+00, 1.4870072745E-01, 1.3992673089E-01, 5.0495827998E-01],
	[9.2250000000E+03, 3.8534977362E+00, 6.1721397567E+00, 1.4895101638E-01, 1.4015143223E-01, 5.0511750350E-01],
	[9.2300000000E+03, 3.8562221967E+00, 6.1711581410E+00, 1.4920159020E-01, 1.4037635716E-01, 5.0527669575E-01],
	[9.2350000000E+03, 3.8589471063E+00, 6.1701772129E+00, 1.4945244906E-01, 1.4060150575E-01, 5.0543585679E-01],
	[9.2400000000E+03, 3.8616724650E+00, 6.1691969715E+00, 1.4970359314E-01, 1.4082687804E-01, 5.0559498667E-01],
	[9.2450000000E+03, 3.8643982725E+00, 6.1682174161E+00, 1.4995502260E-01, 1.4105247409E-01, 5.0575408546E-01],
	[9.2500000000E+03, 3.8671245287E+00, 6.1672385456E+00, 1.5020673762E-01, 1.4127829396E-01, 5.0591315321E-01],
	[9.2550000000E+03, 3.8698512333E+00, 6.1662603594E+00, 1.5045873836E-01, 1.4150433770E-01, 5.0607218997E-01],
	[9.2600000000E+03, 3.8725783864E+00, 6.1652828565E+00, 1.5071102499E-01, 1.4173060537E-01, 5.0623119579E-01],
	[9.2650000000E+03, 3.8753059876E+00, 6.1643060362E+00, 1.5096359768E-01, 1.4195709701E-01, 5.0639017075E-01],
	[9.2700000000E+03, 3.8780340368E+00, 6.1633298974E+00, 1.5121645661E-01, 1.4218381269E-01, 5.0654911488E-01],
	[9.2750000000E+03, 3.8807625338E+00, 6.1623544395E+00, 1.5146960193E-01, 1.4241075245E-01, 5.0670802825E-01],
	[9.2800000000E+03, 3.8834914785E+00, 6.1613796616E+00, 1.5172303382E-01, 1.4263791635E-01, 5.0686691092E-01],
	[9.2850000000E+03, 3.8862208707E+00, 6.1604055628E+00, 1.5197675244E-01, 1.4286530445E-01, 5.0702576293E-01],
	[9.2900000000E+03, 3.8889507102E+00, 6.1594321422E+00, 1.5223075798E-01, 1.4309291679E-01, 5.0718458434E-01],
	[9.2950000000E+03, 3.8916809969E+00, 6.1584593992E+00, 1.5248505058E-01, 1.4332075342E-01, 5.0734337522E-01],
	[9.3000000000E+03, 3.8944117305E+00, 6.1574873327E+00, 1.5273963043E-01, 1.4354881441E-01, 5.0750213561E-01],
	[9.3050000000E+03, 3.8971429110E+00, 6.1565159421E+00, 1.5299449770E-01, 1.4377709981E-01, 5.0766086557E-01],
	[9.3100000000E+03, 3.8998745382E+00, 6.1555452263E+00, 1.5324965254E-01, 1.4400560966E-01, 5.0781956516E-01],
	[9.3150000000E+03, 3.9026066119E+00, 6.1545751848E+00, 1.5350509514E-01, 1.4423434402E-01, 5.0797823443E-01],
	[9.3200000000E+03, 3.9053391318E+00, 6.1536058165E+00, 1.5376082565E-01, 1.4446330294E-01, 5.0813687344E-01],
	[9.3250000000E+03, 3.9080749634E+00, 6.1526503724E+00, 1.5401684425E-01, 1.4469249774E-01, 5.0829548225E-01],
	[9.3300000000E+03, 3.9108120002E+00, 6.1516990855E+00, 1.5427315111E-01, 1.4492192024E-01, 5.0845406090E-01],
	[9.3350000000E+03, 3.9135494859E+00, 6.1507484552E+00, 1.5452974640E-01, 1.4515156754E-01, 5.0861260946E-01],
	[9.3400000000E+03, 3.9162874204E+00, 6.1497984808E+00, 1.5478663028E-01, 1.4538143969E-01, 5.0877112799E-01],
	[9.3450000000E+03, 3.9190258036E+00, 6.1488491614E+00, 1.5504380293E-01, 1.4561153674E-01, 5.0892961652E-01],
	[9.3500000000E+03, 3.9217646352E+00, 6.1479004962E+00, 1.5530126451E-01, 1.4584185875E-01, 5.0908807514E-01],
	[9.3550000000E+03, 3.9245039150E+00, 6.1469524844E+00, 1.5555901520E-01, 1.4607240575E-01, 5.0924650388E-01],
	[9.3600000000E+03, 3.9272436431E+00, 6.1460051253E+00, 1.5581705515E-01, 1.4630317782E-01, 5.0940490280E-01],
	[9.3650000000E+03, 3.9299838190E+00, 6.1450584179E+00, 1.5607538455E-01, 1.4653417499E-01, 5.0956327196E-01],
	[9.3700000000E+03, 3.9327244428E+00, 6.1441123616E+00, 1.5633400356E-01, 1.4676539732E-01, 5.0972161142E-01],
	[9.3750000000E+03, 3.9354655141E+00, 6.1431669555E+00, 1.5659291234E-01, 1.4699684486E-01, 5.0987992123E-01],
	[9.3800000000E+03, 3.9382070330E+00, 6.1422221989E+00, 1.5685211108E-01, 1.4722851766E-01, 5.1003820144E-01],
	[9.3850000000E+03, 3.9409489991E+00, 6.1412780909E+00, 1.5711159993E-01, 1.4746041578E-01, 5.1019645212E-01],
	[9.3900000000E+03, 3.9436914123E+00, 6.1403346308E+00, 1.5737137906E-01, 1.4769253925E-01, 5.1035467332E-01],
	[9.3950000000E+03, 3.9464342725E+00, 6.1393918177E+00, 1.5763144866E-01, 1.4792488814E-01, 5.1051286508E-01],
	[9.4000000000E+03, 3.9491775795E+00, 6.1384496509E+00, 1.5789180887E-01, 1.4815746249E-01, 5.1067102748E-01],
	[9.4050000000E+03, 3.9519213332E+00, 6.1375081296E+00, 1.5815245989E-01, 1.4839026235E-01, 5.1082916056E-01],
	[9.4100000000E+03, 3.9546655333E+00, 6.1365672530E+00, 1.5841340186E-01, 1.4862328778E-01, 5.1098726438E-01],
	[9.4150000000E+03, 3.9574101797E+00, 6.1356270203E+00, 1.5867463497E-01, 1.4885653882E-01, 5.1114533900E-01],
	[9.4200000000E+03, 3.9601552722E+00, 6.1346874308E+00, 1.5893615937E-01, 1.4909001553E-01, 5.1130338447E-01],
	[9.4250000000E+03, 3.9629008107E+00, 6.1337484836E+00, 1.5919797525E-01, 1.4932371794E-01, 5.1146140085E-01],
	[9.4300000000E+03, 3.9656467951E+00, 6.1328101780E+00, 1.5946008277E-01, 1.4955764612E-01, 5.1161938818E-01],
	[9.4350000000E+03, 3.9683932250E+00, 6.1318725132E+00, 1.5972248209E-01, 1.4979180011E-01, 5.1177734654E-01],
	[9.4400000000E+03, 3.9711401005E+00, 6.1309354884E+00, 1.5998517340E-01, 1.5002617997E-01, 5.1193527597E-01],
	[9.4450000000E+03, 3.9738874212E+00, 6.1299991029E+00, 1.6024815685E-01, 1.5026078573E-01, 5.1209317652E-01],
	[9.4500000000E+03, 3.9766351872E+00, 6.1290633558E+00, 1.6051143261E-01, 1.5049561745E-01, 5.1225104826E-01],
	[9.4550000000E+03, 3.9793833981E+00, 6.1281282465E+00, 1.6077500086E-01, 1.5073067518E-01, 5.1240889125E-01],
	[9.4600000000E+03, 3.9821320538E+00, 6.1271937741E+00, 1.6103886177E-01, 1.5096595896E-01, 5.1256670552E-01],
	[9.4650000000E+03, 3.9848811542E+00, 6.1262599378E+00, 1.6130301550E-01, 1.5120146885E-01, 5.1272449115E-01],
	[9.4700000000E+03, 3.9876306991E+00, 6.1253267370E+00, 1.6156746222E-01, 1.5143720490E-01, 5.1288224818E-01],
	[9.4750000000E+03, 3.9903834564E+00, 6.1244066401E+00, 1.6183220211E-01, 1.5167317879E-01, 5.1303997668E-01],
	[9.4800000000E+03, 3.9931374415E+00, 6.1234906839E+00, 1.6209723533E-01, 1.5190938229E-01, 5.1319767669E-01],
	[9.4850000000E+03, 3.9958918737E+00, 6.1225753475E+00, 1.6236256204E-01, 1.5214581217E-01, 5.1335534828E-01],
	[9.4900000000E+03, 3.9986467528E+00, 6.1216606303E+00, 1.6262832509E-01, 1.5238259372E-01, 5.1351299149E-01],
	[9.4950000000E+03, 4.0014020786E+00, 6.1207465314E+00, 1.6289446488E-01, 1.5261967449E-01, 5.1367060639E-01],
	[9.5000000000E+03, 4.0041578509E+00, 6.1198330501E+00, 1.6316089938E-01, 1.5285698233E-01, 5.1382819303E-01],
	[9.5050000000E+03, 4.0069140696E+00, 6.1189201857E+00, 1.6342762874E-01, 1.5309451727E-01, 5.1398575146E-01],
	[9.5100000000E+03, 4.0096707346E+00, 6.1180079375E+00, 1.6369465313E-01, 1.5333227938E-01, 5.1414328174E-01],
	[9.5150000000E+03, 4.0124278455E+00, 6.1170963046E+00, 1.6396197274E-01, 1.5357026869E-01, 5.1430078393E-01],
	[9.5200000000E+03, 4.0151854024E+00, 6.1161852864E+00, 1.6422958772E-01, 1.5380848525E-01, 5.1445825808E-01],
	[9.5250000000E+03, 4.0179434050E+00, 6.1152748821E+00, 1.6449749824E-01, 1.5404692912E-01, 5.1461570424E-01],
	[9.5300000000E+03, 4.0207018532E+00, 6.1143650910E+00, 1.6476570449E-01, 1.5428560033E-01, 5.1477312248E-01],
	[9.5350000000E+03, 4.0234607468E+00, 6.1134559124E+00, 1.6503420662E-01, 1.5452449895E-01, 5.1493051285E-01],
	[9.5400000000E+03, 4.0262200856E+00, 6.1125473454E+00, 1.6530300481E-01, 1.5476362500E-01, 5.1508787539E-01],
	[9.5450000000E+03, 4.0289798696E+00, 6.1116393895E+00, 1.6557209923E-01, 1.5500297855E-01, 5.1524521018E-01],
	[9.5500000000E+03, 4.0317400984E+00, 6.1107320438E+00, 1.6584149005E-01, 1.5524255963E-01, 5.1540251726E-01],
	[9.5550000000E+03, 4.0345007720E+00, 6.1098253076E+00, 1.6611117744E-01, 1.5548236830E-01, 5.1555979668E-01],
	[9.5600000000E+03, 4.0372618903E+00, 6.1089191803E+00, 1.6638116157E-01, 1.5572240460E-01, 5.1571704851E-01],
	[9.5650000000E+03, 4.0400234529E+00, 6.1080136610E+00, 1.6665144261E-01, 1.5596266858E-01, 5.1587427281E-01],
	[9.5700000000E+03, 4.0427854598E+00, 6.1071087490E+00, 1.6692202073E-01, 1.5620316028E-01, 5.1603146961E-01],
	[9.5750000000E+03, 4.0455479109E+00, 6.1062044437E+00, 1.6719289610E-01, 1.5644387975E-01, 5.1618863899E-01],
	[9.5800000000E+03, 4.0483108059E+00, 6.1053007443E+00, 1.6746406889E-01, 1.5668482703E-01, 5.1634578099E-01],
	[9.5850000000E+03, 4.0510741447E+00, 6.1043976500E+00, 1.6773553927E-01, 1.5692600218E-01, 5.1650289568E-01],
	[9.5900000000E+03, 4.0538379272E+00, 6.1034951602E+00, 1.6800730742E-01, 1.5716740524E-01, 5.1665998310E-01],
	[9.5950000000E+03, 4.0566021531E+00, 6.1025932742E+00, 1.6827937350E-01, 1.5740903625E-01, 5.1681704331E-01],
	[9.6000000000E+03, 4.0593668223E+00, 6.1016919911E+00, 1.6855173768E-01, 1.5765089526E-01, 5.1697407635E-01],
	[9.6050000000E+03, 4.0621319348E+00, 6.1007913104E+00, 1.6882440014E-01, 1.5789298231E-01, 5.1713108226E-01],
	[9.6100000000E+03, 4.0648974902E+00, 6.0998912313E+00, 1.6909736104E-01, 1.5813529745E-01, 5.1728806107E-01],
	[9.6150000000E+03, 4.0676634884E+00, 6.0989917530E+00, 1.6937062055E-01, 1.5837784072E-01, 5.1744501282E-01],
	[9.6200000000E+03, 4.0704299293E+00, 6.0980928748E+00, 1.6964417885E-01, 1.5862061218E-01, 5.1760193756E-01],
	[9.6250000000E+03, 4.0731978050E+00, 6.0971989521E+00, 1.6991803610E-01, 1.5886361632E-01, 5.1775883532E-01],
	[9.6300000000E+03, 4.0759686076E+00, 6.0963165184E+00, 1.7019219248E-01, 1.5910685996E-01, 5.1791570614E-01],
	[9.6350000000E+03, 4.0787398553E+00, 6.0954346704E+00, 1.7046664816E-01, 1.5935033200E-01, 5.1807255006E-01],
	[9.6400000000E+03, 4.0815115479E+00, 6.0945534073E+00, 1.7074140330E-01, 1.5959403248E-01, 5.1822936712E-01],
	[9.6450000000E+03, 4.0842836854E+00, 6.0936727285E+00, 1.7101645808E-01, 1.5983796144E-01, 5.1838615736E-01],
	[9.6500000000E+03, 4.0870562674E+00, 6.0927926332E+00, 1.7129181267E-01, 1.6008211894E-01, 5.1854292082E-01],
	[9.6550000000E+03, 4.0898292940E+00, 6.0919131209E+00, 1.7156746724E-01, 1.6032650500E-01, 5.1869965753E-01],
	[9.6600000000E+03, 4.0926027649E+00, 6.0910341908E+00, 1.7184342195E-01, 1.6057111969E-01, 5.1885636754E-01],
	[9.6650000000E+03, 4.0953766800E+00, 6.0901558423E+00, 1.7211967699E-01, 1.6081596303E-01, 5.1901305089E-01],
	[9.6700000000E+03, 4.0981510390E+00, 6.0892780745E+00, 1.7239623252E-01, 1.6106103509E-01, 5.1916970760E-01],
	[9.6750000000E+03, 4.1009258419E+00, 6.0884008869E+00, 1.7267308870E-01, 1.6130633589E-01, 5.1932633774E-01],
	[9.6800000000E+03, 4.1037010885E+00, 6.0875242788E+00, 1.7295024572E-01, 1.6155186548E-01, 5.1948294132E-01],
	[9.6850000000E+03, 4.1064767787E+00, 6.0866482495E+00, 1.7322770374E-01, 1.6179762391E-01, 5.1963951840E-01],
	[9.6900000000E+03, 4.1092529122E+00, 6.0857727983E+00, 1.7350546293E-01, 1.6204361121E-01, 5.1979606901E-01],
	[9.6950000000E+03, 4.1120294889E+00, 6.0848979246E+00, 1.7378352346E-01, 1.6228982744E-01, 5.1995259319E-01],
	[9.7000000000E+03, 4.1148065087E+00, 6.0840236276E+00, 1.7406188551E-01, 1.6253627264E-01, 5.2010909099E-01],
	[9.7050000000E+03, 4.1175839713E+00, 6.0831499066E+00, 1.7434054924E-01, 1.6278294684E-01, 5.2026556243E-01],
	[9.7100000000E+03, 4.1203618767E+00, 6.0822767611E+00, 1.7461951482E-01, 1.6302985008E-01, 5.2042200756E-01],
	[9.7150000000E+03, 4.1231402247E+00, 6.0814041903E+00, 1.7489878244E-01, 1.6327698243E-01, 5.2057842641E-01],
	[9.7200000000E+03, 4.1259190152E+00, 6.0805321936E+00, 1.7517835224E-01, 1.6352434390E-01, 5.2073481904E-01],
	[9.7250000000E+03, 4.1286982479E+00, 6.0796607702E+00, 1.7545822442E-01, 1.6377193455E-01, 5.2089118547E-01],
	[9.7300000000E+03, 4.1314779227E+00, 6.0787899195E+00, 1.7573839913E-01, 1.6401975442E-01, 5.2104752575E-01],
	[9.7350000000E+03, 4.1342580394E+00, 6.0779196409E+00, 1.7601887654E-01, 1.6426780355E-01, 5.2120383991E-01],
	[9.7400000000E+03, 4.1370385980E+00, 6.0770499336E+00, 1.7629965684E-01, 1.6451608198E-01, 5.2136012799E-01],
	[9.7450000000E+03, 4.1398195982E+00, 6.0761807971E+00, 1.7658074019E-01, 1.6476458976E-01, 5.2151639005E-01],
	[9.7500000000E+03, 4.1426010399E+00, 6.0753122305E+00, 1.7686212675E-01, 1.6501332691E-01, 5.2167262610E-01],
	[9.7550000000E+03, 4.1453829229E+00, 6.0744442334E+00, 1.7714381671E-01, 1.6526229350E-01, 5.2182883620E-01],
	[9.7600000000E+03, 4.1481652471E+00, 6.0735768049E+00, 1.7742581022E-01, 1.6551148955E-01, 5.2198502038E-01],
	[9.7650000000E+03, 4.1509480123E+00, 6.0727099445E+00, 1.7770810747E-01, 1.6576091511E-01, 5.2214117868E-01],
	[9.7700000000E+03, 4.1537312184E+00, 6.0718436515E+00, 1.7799070862E-01, 1.6601057021E-01, 5.2229731114E-01],
	[9.7750000000E+03, 4.1565148652E+00, 6.0709779252E+00, 1.7827361385E-01, 1.6626045491E-01, 5.2245341780E-01],
	[9.7800000000E+03, 4.1592999737E+00, 6.0701171313E+00, 1.7855682332E-01, 1.6651057416E-01, 5.2260949870E-01],
	[9.7850000000E+03, 4.1620879040E+00, 6.0692670704E+00, 1.7884033720E-01, 1.6676093460E-01, 5.2276555388E-01],
	[9.7900000000E+03, 4.1648762773E+00, 6.0684175627E+00, 1.7912415567E-01, 1.6701152484E-01, 5.2292158338E-01],
	[9.7950000000E+03, 4.1676650936E+00, 6.0675686076E+00, 1.7940827889E-01, 1.6726234491E-01, 5.2307758724E-01],
	[9.8000000000E+03, 4.1704543526E+00, 6.0667202044E+00, 1.7969270704E-01, 1.6751339487E-01, 5.2323356550E-01],
	[9.8050000000E+03, 4.1732440542E+00, 6.0658723525E+00, 1.7997744029E-01, 1.6776467473E-01, 5.2338951819E-01],
	[9.8100000000E+03, 4.1760341982E+00, 6.0650250512E+00, 1.8026247881E-01, 1.6801618456E-01, 5.2354544536E-01],
	[9.8150000000E+03, 4.1788247845E+00, 6.0641782999E+00, 1.8054782276E-01, 1.6826792438E-01, 5.2370134704E-01],
	[9.8200000000E+03, 4.1816158129E+00, 6.0633320980E+00, 1.8083347233E-01, 1.6851989424E-01, 5.2385722328E-01],
	[9.8250000000E+03, 4.1844072833E+00, 6.0624864449E+00, 1.8111942767E-01, 1.6877209417E-01, 5.2401307412E-01],
	[9.8300000000E+03, 4.1871991955E+00, 6.0616413398E+00, 1.8140568897E-01, 1.6902452422E-01, 5.2416889959E-01],
	[9.8350000000E+03, 4.1899915494E+00, 6.0607967822E+00, 1.8169225639E-01, 1.6927718442E-01, 5.2432469973E-01],
	[9.8400000000E+03, 4.1927843447E+00, 6.0599527715E+00, 1.8197913011E-01, 1.6953007481E-01, 5.2448047459E-01],
	[9.8450000000E+03, 4.1955775814E+00, 6.0591093069E+00, 1.8226631028E-01, 1.6978319544E-01, 5.2463622420E-01],
	[9.8500000000E+03, 4.1983712593E+00, 6.0582663879E+00, 1.8255379709E-01, 1.7003654633E-01, 5.2479194860E-01],
	[9.8550000000E+03, 4.2011653782E+00, 6.0574240139E+00, 1.8284159071E-01, 1.7029012754E-01, 5.2494764783E-01],
	[9.8600000000E+03, 4.2039599380E+00, 6.0565821842E+00, 1.8312969130E-01, 1.7054393909E-01, 5.2510332194E-01],
	[9.8650000000E+03, 4.2067549386E+00, 6.0557408982E+00, 1.8341809905E-01, 1.7079798103E-01, 5.2525897096E-01],
	[9.8700000000E+03, 4.2095503797E+00, 6.0549001552E+00, 1.8370681410E-01, 1.7105225338E-01, 5.2541459493E-01],
	[9.8750000000E+03, 4.2123462613E+00, 6.0540599547E+00, 1.8399583665E-01, 1.7130675621E-01, 5.2557019389E-01],
	[9.8800000000E+03, 4.2151425831E+00, 6.0532202959E+00, 1.8428516686E-01, 1.7156148953E-01, 5.2572576788E-01],
	[9.8850000000E+03, 4.2179393450E+00, 6.0523811784E+00, 1.8457480490E-01, 1.7181645338E-01, 5.2588131693E-01],
	[9.8900000000E+03, 4.2207365469E+00, 6.0515426014E+00, 1.8486475094E-01, 1.7207164781E-01, 5.2603684110E-01],
	[9.8950000000E+03, 4.2235341886E+00, 6.0507045644E+00, 1.8515500515E-01, 1.7232707286E-01, 5.2619234042E-01],
	[9.9000000000E+03, 4.2263322700E+00, 6.0498670667E+00, 1.8544556770E-01, 1.7258272855E-01, 5.2634781492E-01],
	[9.9050000000E+03, 4.2291307908E+00, 6.0490301077E+00, 1.8573643877E-01, 1.7283861493E-01, 5.2650326466E-01],
	[9.9100000000E+03, 4.2319297510E+00, 6.0481936868E+00, 1.8602761853E-01, 1.7309473203E-01, 5.2665868966E-01],
	[9.9150000000E+03, 4.2347291504E+00, 6.0473578034E+00, 1.8631910714E-01, 1.7335107989E-01, 5.2681408997E-01],
	[9.9200000000E+03, 4.2375289889E+00, 6.0465224568E+00, 1.8661090477E-01, 1.7360765854E-01, 5.2696946563E-01],
	[9.9250000000E+03, 4.2403292662E+00, 6.0456876464E+00, 1.8690301161E-01, 1.7386446803E-01, 5.2712481667E-01],
	[9.9300000000E+03, 4.2431299823E+00, 6.0448533717E+00, 1.8719542781E-01, 1.7412150839E-01, 5.2728014314E-01],
	[9.9350000000E+03, 4.2459311370E+00, 6.0440196320E+00, 1.8748815356E-01, 1.7437877966E-01, 5.2743544507E-01],
	[9.9400000000E+03, 4.2487354514E+00, 6.0431977361E+00, 1.8778118901E-01, 1.7463629590E-01, 5.2759072252E-01],
	[9.9450000000E+03, 4.2515408196E+00, 6.0423789116E+00, 1.8807453435E-01, 1.7489404637E-01, 5.2774597550E-01],
	[9.9500000000E+03, 4.2543466286E+00, 6.0415606094E+00, 1.8836818973E-01, 1.7515202794E-01, 5.2790120408E-01],
	[9.9550000000E+03, 4.2571528783E+00, 6.0407428291E+00, 1.8866215535E-01, 1.7541024065E-01, 5.2805640828E-01],
	[9.9600000000E+03, 4.2599595685E+00, 6.0399255700E+00, 1.8895643135E-01, 1.7566868453E-01, 5.2821158820E-01],
	[9.9650000000E+03, 4.2627666991E+00, 6.0391088316E+00, 1.8925101793E-01, 1.7592735961E-01, 5.2836674400E-01],
	[9.9700000000E+03, 4.2655742700E+00, 6.0382926133E+00, 1.8954591524E-01, 1.7618626595E-01, 5.2852187570E-01],
	[9.9750000000E+03, 4.2683822810E+00, 6.0374769144E+00, 1.8984112345E-01, 1.7644540356E-01, 5.2867698331E-01],
	[9.9800000000E+03, 4.2711907319E+00, 6.0366617344E+00, 1.9013664275E-01, 1.7670477249E-01, 5.2883206686E-01],
	[9.9850000000E+03, 4.2739996226E+00, 6.0358470727E+00, 1.9043247329E-01, 1.7696437277E-01, 5.2898712637E-01],
	[9.9900000000E+03, 4.2768089529E+00, 6.0350329286E+00, 1.9072861526E-01, 1.7722420443E-01, 5.2914216185E-01],
	[9.9950000000E+03, 4.2796187228E+00, 6.0342193017E+00, 1.9102506882E-01, 1.7748426751E-01, 5.2929717333E-01],
	[1.0000000000E+04, 4.2824289319E+00, 6.0334061913E+00, 1.9132183414E-01, 1.7774456204E-01, 5.2945216082E-01],
	[1.0005000000E+04, 4.2852395803E+00, 6.0325935969E+00, 1.9162014144E-01, 1.7800614954E-01, 5.2960712436E-01],
	[1.0010000000E+04, 4.2880506677E+00, 6.0317815178E+00, 1.9191876407E-01, 1.7826797097E-01, 5.2976206395E-01],
	[1.0015000000E+04, 4.2908621940E+00, 6.0309699535E+00, 1.9221770220E-01, 1.7853002637E-01, 5.2991697961E-01],
	[1.0020000000E+04, 4.2936741590E+00, 6.0301589033E+00, 1.9251695600E-01, 1.7879231576E-01, 5.3007187138E-01],
	[1.0025000000E+04, 4.2964865625E+00, 6.0293483668E+00, 1.9281652564E-01, 1.7905483919E-01, 5.3022673927E-01],
	[1.0030000000E+04, 4.2992994046E+00, 6.0285383433E+00, 1.9311641131E-01, 1.7931759669E-01, 5.3038158329E-01],
	[1.0035000000E+04, 4.3021126849E+00, 6.0277288322E+00, 1.9341661317E-01, 1.7958058829E-01, 5.3053640347E-01],
	[1.0040000000E+04, 4.3049264033E+00, 6.0269198330E+00, 1.9371713141E-01, 1.7984381403E-01, 5.3069119983E-01],
	[1.0045000000E+04, 4.3077405597E+00, 6.0261113451E+00, 1.9401796620E-01, 1.8010727394E-01, 5.3084597240E-01],
	[1.0050000000E+04, 4.3105551539E+00, 6.0253033679E+00, 1.9431911770E-01, 1.8037096807E-01, 5.3100072118E-01],
	[1.0055000000E+04, 4.3133701859E+00, 6.0244959008E+00, 1.9462058610E-01, 1.8063489644E-01, 5.3115544620E-01],
	[1.0060000000E+04, 4.3161856553E+00, 6.0236889433E+00, 1.9492237158E-01, 1.8089905908E-01, 5.3131014749E-01],
	[1.0065000000E+04, 4.3190015622E+00, 6.0228824947E+00, 1.9522447430E-01, 1.8116345604E-01, 5.3146482506E-01],
	[1.0070000000E+04, 4.3218179062E+00, 6.0220765546E+00, 1.9552689444E-01, 1.8142808734E-01, 5.3161947893E-01],
	[1.0075000000E+04, 4.3246346874E+00, 6.0212711223E+00, 1.9582963218E-01, 1.8169295302E-01, 5.3177410912E-01],
	[1.0080000000E+04, 4.3274519055E+00, 6.0204661972E+00, 1.9613268769E-01, 1.8195805311E-01, 5.3192871566E-01],
	[1.0085000000E+04, 4.3302695604E+00, 6.0196617789E+00, 1.9643606115E-01, 1.8222338765E-01, 5.3208329856E-01],
	[1.0090000000E+04, 4.3330876519E+00, 6.0188578666E+00, 1.9673975273E-01, 1.8248895667E-01, 5.3223785785E-01],
	[1.0095000000E+04, 4.3359061799E+00, 6.0180544600E+00, 1.9704376261E-01, 1.8275476020E-01, 5.3239239354E-01],
	[1.0100000000E+04, 4.3387279365E+00, 6.0172625349E+00, 1.9734809096E-01, 1.8302081340E-01, 5.3254690566E-01],
	[1.0105000000E+04, 4.3415507232E+00, 6.0164734299E+00, 1.9765273795E-01, 1.8328710447E-01, 5.3270139423E-01],
	[1.0110000000E+04, 4.3443739487E+00, 6.0156848187E+00, 1.9795770377E-01, 1.8355363024E-01, 5.3285585926E-01],
	[1.0115000000E+04, 4.3471976128E+00, 6.0148967007E+00, 1.9826298859E-01, 1.8382039074E-01, 5.3301030079E-01],
	[1.0120000000E+04, 4.3500217153E+00, 6.0141090753E+00, 1.9856859257E-01, 1.8408738602E-01, 5.3316471882E-01],
	[1.0125000000E+04, 4.3528462562E+00, 6.0133219421E+00, 1.9887451591E-01, 1.8435461610E-01, 5.3331911339E-01],
	[1.0130000000E+04, 4.3556712353E+00, 6.0125353004E+00, 1.9918075876E-01, 1.8462208102E-01, 5.3347348450E-01],
	[1.0135000000E+04, 4.3584966523E+00, 6.0117491497E+00, 1.9948732132E-01, 1.8488978080E-01, 5.3362783219E-01],
	[1.0140000000E+04, 4.3613225073E+00, 6.0109634894E+00, 1.9979420374E-01, 1.8515771548E-01, 5.3378215647E-01],
	[1.0145000000E+04, 4.3641488000E+00, 6.0101783191E+00, 2.0010140621E-01, 1.8542588509E-01, 5.3393645737E-01],
	[1.0150000000E+04, 4.3669755302E+00, 6.0093936382E+00, 2.0040892891E-01, 1.8569428966E-01, 5.3409073490E-01],
	[1.0155000000E+04, 4.3698026979E+00, 6.0086094460E+00, 2.0071677200E-01, 1.8596292923E-01, 5.3424498909E-01],
	[1.0160000000E+04, 4.3726303029E+00, 6.0078257422E+00, 2.0102493567E-01, 1.8623180383E-01, 5.3439921995E-01],
	[1.0165000000E+04, 4.3754583450E+00, 6.0070425260E+00, 2.0133342008E-01, 1.8650091348E-01, 5.3455342751E-01],
	[1.0170000000E+04, 4.3782868241E+00, 6.0062597971E+00, 2.0164222542E-01, 1.8677025822E-01, 5.3470761180E-01],
	[1.0175000000E+04, 4.3811157400E+00, 6.0054775548E+00, 2.0195135186E-01, 1.8703983807E-01, 5.3486177282E-01],
	[1.0180000000E+04, 4.3839450927E+00, 6.0046957986E+00, 2.0226079957E-01, 1.8730965308E-01, 5.3501591060E-01],
	[1.0185000000E+04, 4.3867748818E+00, 6.0039145279E+00, 2.0257056872E-01, 1.8757970327E-01, 5.3517002517E-01],
	[1.0190000000E+04, 4.3896051074E+00, 6.0031337423E+00, 2.0288065951E-01, 1.8784998867E-01, 5.3532411654E-01],
	[1.0195000000E+04, 4.3924357693E+00, 6.0023534412E+00, 2.0319107209E-01, 1.8812050931E-01, 5.3547818473E-01],
	[1.0200000000E+04, 4.3952668672E+00, 6.0015736240E+00, 2.0350180664E-01, 1.8839126522E-01, 5.3563222977E-01],
	[1.0205000000E+04, 4.3980984011E+00, 6.0007942902E+00, 2.0381286335E-01, 1.8866225644E-01, 5.3578625168E-01],
	[1.0210000000E+04, 4.4009303708E+00, 6.0000154393E+00, 2.0412424238E-01, 1.8893348298E-01, 5.3594025047E-01],
	[1.0215000000E+04, 4.4037627762E+00, 5.9992370707E+00, 2.0443594391E-01, 1.8920494489E-01, 5.3609422618E-01],
	[1.0220000000E+04, 4.4065956171E+00, 5.9984591839E+00, 2.0474796811E-01, 1.8947664219E-01, 5.3624817881E-01],
	[1.0225000000E+04, 4.4094288934E+00, 5.9976817784E+00, 2.0506031517E-01, 1.8974857491E-01, 5.3640210840E-01],
	[1.0230000000E+04, 4.4122626049E+00, 5.9969048537E+00, 2.0537298525E-01, 1.9002074308E-01, 5.3655601496E-01],
	[1.0235000000E+04, 4.4150967514E+00, 5.9961284091E+00, 2.0568597853E-01, 1.9029314672E-01, 5.3670989852E-01],
	[1.0240000000E+04, 4.4179313330E+00, 5.9953524442E+00, 2.0599929519E-01, 1.9056578588E-01, 5.3686375909E-01],
	[1.0245000000E+04, 4.4207663493E+00, 5.9945769584E+00, 2.0631293540E-01, 1.9083866057E-01, 5.3701759670E-01],
	[1.0250000000E+04, 4.4236018002E+00, 5.9938019513E+00, 2.0662689933E-01, 1.9111177083E-01, 5.3717141137E-01],
	[1.0255000000E+04, 4.4264376857E+00, 5.9930274222E+00, 2.0694118717E-01, 1.9138511668E-01, 5.3732520312E-01],
	[1.0260000000E+04, 4.4292751306E+00, 5.9922574717E+00, 2.0725579909E-01, 1.9165870445E-01, 5.3747897197E-01],
	[1.0265000000E+04, 4.4321154107E+00, 5.9914967364E+00, 2.0757073526E-01, 1.9193254138E-01, 5.3763271795E-01],
	[1.0270000000E+04, 4.4349561276E+00, 5.9907364680E+00, 2.0788599586E-01, 1.9220661409E-01, 5.3778644107E-01],
	[1.0275000000E+04, 4.4377972813E+00, 5.9899766660E+00, 2.0820158106E-01, 1.9248092260E-01, 5.3794014135E-01],
	[1.0280000000E+04, 4.4406388715E+00, 5.9892173301E+00, 2.0851749103E-01, 1.9275546694E-01, 5.3809381883E-01],
	[1.0285000000E+04, 4.4434808981E+00, 5.9884584595E+00, 2.0883372597E-01, 1.9303024715E-01, 5.3824747351E-01],
	[1.0290000000E+04, 4.4463233611E+00, 5.9877000538E+00, 2.0915028603E-01, 1.9330526324E-01, 5.3840110542E-01],
	[1.0295000000E+04, 4.4491662601E+00, 5.9869421126E+00, 2.0946717140E-01, 1.9358051525E-01, 5.3855471459E-01],
	[1.0300000000E+04, 4.4520095952E+00, 5.9861846352E+00, 2.0978438225E-01, 1.9385600320E-01, 5.3870830103E-01],
	[1.0305000000E+04, 4.4548533661E+00, 5.9854276213E+00, 2.1010191875E-01, 1.9413172713E-01, 5.3886186477E-01],
	[1.0310000000E+04, 4.4576975727E+00, 5.9846710702E+00, 2.1041978108E-01, 1.9440768705E-01, 5.3901540583E-01],
	[1.0315000000E+04, 4.4605422148E+00, 5.9839149815E+00, 2.1073796943E-01, 1.9468388299E-01, 5.3916892422E-01],
	[1.0320000000E+04, 4.4633872924E+00, 5.9831593546E+00, 2.1105648395E-01, 1.9496031499E-01, 5.3932241998E-01],
	[1.0325000000E+04, 4.4662328053E+00, 5.9824041891E+00, 2.1137532483E-01, 1.9523698307E-01, 5.3947589312E-01],
	[1.0330000000E+04, 4.4690787532E+00, 5.9816494845E+00, 2.1169449224E-01, 1.9551388726E-01, 5.3962934366E-01],
	[1.0335000000E+04, 4.4719251362E+00, 5.9808952402E+00, 2.1201398636E-01, 1.9579102757E-01, 5.3978277163E-01],
	[1.0340000000E+04, 4.4747719539E+00, 5.9801414557E+00, 2.1233380737E-01, 1.9606840404E-01, 5.3993617705E-01],
	[1.0345000000E+04, 4.4776192064E+00, 5.9793881306E+00, 2.1265395543E-01, 1.9634601670E-01, 5.4008955994E-01],
	[1.0350000000E+04, 4.4804668934E+00, 5.9786352644E+00, 2.1297443073E-01, 1.9662386556E-01, 5.4024292032E-01],
	[1.0355000000E+04, 4.4833150149E+00, 5.9778828565E+00, 2.1329523344E-01, 1.9690195066E-01, 5.4039625821E-01],
	[1.0360000000E+04, 4.4861635706E+00, 5.9771309064E+00, 2.1361636373E-01, 1.9718027202E-01, 5.4054957364E-01],
	[1.0365000000E+04, 4.4890125604E+00, 5.9763794136E+00, 2.1393782178E-01, 1.9745882967E-01, 5.4070286663E-01],
	[1.0370000000E+04, 4.4918619841E+00, 5.9756283777E+00, 2.1425960777E-01, 1.9773762363E-01, 5.4085613719E-01],
	[1.0375000000E+04, 4.4947118418E+00, 5.9748777982E+00, 2.1458172188E-01, 1.9801665393E-01, 5.4100938536E-01],
	[1.0380000000E+04, 4.4975621331E+00, 5.9741276745E+00, 2.1490416427E-01, 1.9829592058E-01, 5.4116261115E-01],
	[1.0385000000E+04, 4.5004128579E+00, 5.9733780061E+00, 2.1522693512E-01, 1.9857542363E-01, 5.4131581459E-01],
	[1.0390000000E+04, 4.5032640161E+00, 5.9726287926E+00, 2.1555003461E-01, 1.9885516308E-01, 5.4146899569E-01],
	[1.0395000000E+04, 4.5061156077E+00, 5.9718800335E+00, 2.1587346292E-01, 1.9913513897E-01, 5.4162215449E-01],
	[1.0400000000E+04, 4.5089676323E+00, 5.9711317282E+00, 2.1619722021E-01, 1.9941535132E-01, 5.4177529099E-01],
	[1.0405000000E+04, 4.5118200899E+00, 5.9703838763E+00, 2.1652130667E-01, 1.9969580015E-01, 5.4192840523E-01],
	[1.0410000000E+04, 4.5146729803E+00, 5.9696364773E+00, 2.1684572247E-01, 1.9997648550E-01, 5.4208149723E-01],
	[1.0415000000E+04, 4.5175263034E+00, 5.9688895307E+00, 2.1717046779E-01, 2.0025740737E-01, 5.4223456700E-01],
	[1.0420000000E+04, 4.5203800591E+00, 5.9681430360E+00, 2.1749554280E-01, 2.0053856580E-01, 5.4238761457E-01],
	[1.0425000000E+04, 4.5232353112E+00, 5.9674005893E+00, 2.1782094768E-01, 2.0081996698E-01, 5.4254063997E-01],
	[1.0430000000E+04, 4.5260936026E+00, 5.9666673940E+00, 2.1814668260E-01, 2.0110161993E-01, 5.4269364321E-01],
	[1.0435000000E+04, 4.5289523290E+00, 5.9659346400E+00, 2.1847274774E-01, 2.0138350962E-01, 5.4284662432E-01],
	[1.0440000000E+04, 4.5318114902E+00, 5.9652023270E+00, 2.1879914327E-01, 2.0166563606E-01, 5.4299958331E-01],
	[1.0445000000E+04, 4.5346710861E+00, 5.9644704545E+00, 2.1912586937E-01, 2.0194799927E-01, 5.4315252022E-01],
	[1.0450000000E+04, 4.5375311166E+00, 5.9637390219E+00, 2.1945292622E-01, 2.0223059929E-01, 5.4330543506E-01],
	[1.0455000000E+04, 4.5403915816E+00, 5.9630080289E+00, 2.1978031399E-01, 2.0251343612E-01, 5.4345832785E-01],
	[1.0460000000E+04, 4.5432524808E+00, 5.9622774749E+00, 2.2010803286E-01, 2.0279650981E-01, 5.4361119862E-01],
	[1.0465000000E+04, 4.5461138142E+00, 5.9615473595E+00, 2.2043608299E-01, 2.0307982035E-01, 5.4376404740E-01],
	[1.0470000000E+04, 4.5489755815E+00, 5.9608176822E+00, 2.2076446458E-01, 2.0336336779E-01, 5.4391687419E-01],
	[1.0475000000E+04, 4.5518377828E+00, 5.9600884425E+00, 2.2109317779E-01, 2.0364715214E-01, 5.4406967904E-01],
	[1.0480000000E+04, 4.5547004177E+00, 5.9593596399E+00, 2.2142222280E-01, 2.0393117343E-01, 5.4422246194E-01],
	[1.0485000000E+04, 4.5575634862E+00, 5.9586312741E+00, 2.2175159979E-01, 2.0421543167E-01, 5.4437522294E-01],
	[1.0490000000E+04, 4.5604269882E+00, 5.9579033444E+00, 2.2208130892E-01, 2.0449992689E-01, 5.4452796205E-01],
	[1.0495000000E+04, 4.5632909234E+00, 5.9571758505E+00, 2.2241135039E-01, 2.0478465911E-01, 5.4468067930E-01],
	[1.0500000000E+04, 4.5661552919E+00, 5.9564487919E+00, 2.2274172435E-01, 2.0506962835E-01, 5.4483337470E-01],
	[1.0505000000E+04, 4.5690200933E+00, 5.9557221681E+00, 2.2307243100E-01, 2.0535483464E-01, 5.4498604829E-01],
	[1.0510000000E+04, 4.5718853276E+00, 5.9549959786E+00, 2.2340347049E-01, 2.0564027799E-01, 5.4513870007E-01],
	[1.0515000000E+04, 4.5747509946E+00, 5.9542702230E+00, 2.2373484302E-01, 2.0592595842E-01, 5.4529133008E-01],
	[1.0520000000E+04, 4.5776170942E+00, 5.9535449008E+00, 2.2406654875E-01, 2.0621187596E-01, 5.4544393834E-01],
	[1.0525000000E+04, 4.5804836263E+00, 5.9528200116E+00, 2.2439858787E-01, 2.0649803062E-01, 5.4559652486E-01],
	[1.0530000000E+04, 4.5833505907E+00, 5.9520955548E+00, 2.2473096054E-01, 2.0678442244E-01, 5.4574908968E-01],
	[1.0535000000E+04, 4.5862179873E+00, 5.9513715301E+00, 2.2506366694E-01, 2.0707105142E-01, 5.4590163282E-01],
	[1.0540000000E+04, 4.5890858159E+00, 5.9506479369E+00, 2.2539670725E-01, 2.0735791759E-01, 5.4605415429E-01],
	[1.0545000000E+04, 4.5919540763E+00, 5.9499247748E+00, 2.2573008165E-01, 2.0764502096E-01, 5.4620665412E-01],
	[1.0550000000E+04, 4.5948227686E+00, 5.9492020433E+00, 2.2606379030E-01, 2.0793236157E-01, 5.4635913234E-01],
	[1.0555000000E+04, 4.5976918924E+00, 5.9484797420E+00, 2.2639783339E-01, 2.0821993942E-01, 5.4651158896E-01],
	[1.0560000000E+04, 4.6005614477E+00, 5.9477578704E+00, 2.2673221109E-01, 2.0850775454E-01, 5.4666402401E-01],
	[1.0565000000E+04, 4.6034314344E+00, 5.9470364281E+00, 2.2706692358E-01, 2.0879580695E-01, 5.4681643752E-01],
	[1.0570000000E+04, 4.6063018522E+00, 5.9463154146E+00, 2.2740197104E-01, 2.0908409666E-01, 5.4696882949E-01],
	[1.0575000000E+04, 4.6091727011E+00, 5.9455948294E+00, 2.2773735363E-01, 2.0937262370E-01, 5.4712119997E-01],
	[1.0580000000E+04, 4.6120439810E+00, 5.9448746721E+00, 2.2807307154E-01, 2.0966138808E-01, 5.4727354896E-01],
	[1.0585000000E+04, 4.6149156915E+00, 5.9441549422E+00, 2.2840912494E-01, 2.0995038983E-01, 5.4742587649E-01],
	[1.0590000000E+04, 4.6177878328E+00, 5.9434356393E+00, 2.2874551400E-01, 2.1023962895E-01, 5.4757818259E-01],
	[1.0595000000E+04, 4.6206631866E+00, 5.9427254902E+00, 2.2908223891E-01, 2.1052912221E-01, 5.4773046728E-01],
	[1.0600000000E+04, 4.6235400076E+00, 5.9420190041E+00, 2.2941929984E-01, 2.1081885920E-01, 5.4788273058E-01],
	[1.0605000000E+04, 4.6264172617E+00, 5.9413129351E+00, 2.2975669696E-01, 2.1110883374E-01, 5.4803497252E-01],
	[1.0610000000E+04, 4.6292949489E+00, 5.9406072828E+00, 2.3009443045E-01, 2.1139904584E-01, 5.4818719311E-01],
	[1.0615000000E+04, 4.6321730690E+00, 5.9399020467E+00, 2.3043250048E-01, 2.1168949552E-01, 5.4833939238E-01],
	[1.0620000000E+04, 4.6350516218E+00, 5.9391972264E+00, 2.3077090724E-01, 2.1198018281E-01, 5.4849157035E-01],
	[1.0625000000E+04, 4.6379306072E+00, 5.9384928214E+00, 2.3110965090E-01, 2.1227110771E-01, 5.4864372705E-01],
	[1.0630000000E+04, 4.6408100251E+00, 5.9377888312E+00, 2.3144873163E-01, 2.1256227026E-01, 5.4879586250E-01],
	[1.0635000000E+04, 4.6436898754E+00, 5.9370852556E+00, 2.3178814961E-01, 2.1285367045E-01, 5.4894797672E-01],
	[1.0640000000E+04, 4.6465701578E+00, 5.9363820940E+00, 2.3212790502E-01, 2.1314530832E-01, 5.4910006973E-01],
	[1.0645000000E+04, 4.6494508723E+00, 5.9356793459E+00, 2.3246799803E-01, 2.1343718388E-01, 5.4925214156E-01],
	[1.0650000000E+04, 4.6523320188E+00, 5.9349770110E+00, 2.3280842881E-01, 2.1372929715E-01, 5.4940419216E-01],
	[1.0655000000E+04, 4.6552135970E+00, 5.9342750887E+00, 2.3314919755E-01, 2.1402164814E-01, 5.4955622153E-01],
	[1.0660000000E+04, 4.6580956068E+00, 5.9335735788E+00, 2.3349030442E-01, 2.1431423687E-01, 5.4970822966E-01],
	[1.0665000000E+04, 4.6609780482E+00, 5.9328724807E+00, 2.3383174960E-01, 2.1460706335E-01, 5.4986021657E-01],
	[1.0670000000E+04, 4.6638609209E+00, 5.9321717939E+00, 2.3417353326E-01, 2.1490012761E-01, 5.5001218225E-01],
	[1.0675000000E+04, 4.6667442248E+00, 5.9314715182E+00, 2.3451565557E-01, 2.1519342966E-01, 5.5016412671E-01],
	[1.0680000000E+04, 4.6696279599E+00, 5.9307716529E+00, 2.3485811672E-01, 2.1548696952E-01, 5.5031604995E-01],
	[1.0685000000E+04, 4.6725121259E+00, 5.9300721978E+00, 2.3520091688E-01, 2.1578074720E-01, 5.5046795198E-01],
	[1.0690000000E+04, 4.6753967227E+00, 5.9293731523E+00, 2.3554405622E-01, 2.1607476271E-01, 5.5061983279E-01],
	[1.0695000000E+04, 4.6782817502E+00, 5.9286745160E+00, 2.3588753493E-01, 2.1636901608E-01, 5.5077169241E-01],
	[1.0700000000E+04, 4.6811672083E+00, 5.9279762886E+00, 2.3623135317E-01, 2.1666350732E-01, 5.5092353081E-01],
	[1.0705000000E+04, 4.6840530967E+00, 5.9272784695E+00, 2.3657551113E-01, 2.1695823644E-01, 5.5107534802E-01],
	[1.0710000000E+04, 4.6869394155E+00, 5.9265810584E+00, 2.3692000898E-01, 2.1725320347E-01, 5.5122714404E-01],
	[1.0715000000E+04, 4.6898261643E+00, 5.9258840548E+00, 2.3726484689E-01, 2.1754840840E-01, 5.5137891886E-01],
	[1.0720000000E+04, 4.6927133432E+00, 5.9251874582E+00, 2.3761002505E-01, 2.1784385127E-01, 5.5153067250E-01],
	[1.0725000000E+04, 4.6956009519E+00, 5.9244912684E+00, 2.3795554362E-01, 2.1813953208E-01, 5.5168240496E-01],
	[1.0730000000E+04, 4.6984889904E+00, 5.9237954847E+00, 2.3830140279E-01, 2.1843545086E-01, 5.5183411624E-01],
	[1.0735000000E+04, 4.7013774584E+00, 5.9231001069E+00, 2.3864760273E-01, 2.1873160760E-01, 5.5198580634E-01],
	[1.0740000000E+04, 4.7042663559E+00, 5.9224051344E+00, 2.3899414362E-01, 2.1902800234E-01, 5.5213747527E-01],
	[1.0745000000E+04, 4.7071556827E+00, 5.9217105669E+00, 2.3934102563E-01, 2.1932463507E-01, 5.5228912304E-01],
	[1.0750000000E+04, 4.7100454387E+00, 5.9210164039E+00, 2.3968824893E-01, 2.1962150582E-01, 5.5244074964E-01],
	[1.0755000000E+04, 4.7129356237E+00, 5.9203226451E+00, 2.4003581372E-01, 2.1991861461E-01, 5.5259235508E-01],
	[1.0760000000E+04, 4.7158262377E+00, 5.9196292899E+00, 2.4038372015E-01, 2.2021596143E-01, 5.5274393938E-01],
	[1.0765000000E+04, 4.7187197688E+00, 5.9189435917E+00, 2.4073196841E-01, 2.2051356182E-01, 5.5289550252E-01],
	[1.0770000000E+04, 4.7216152068E+00, 5.9182625918E+00, 2.4108055868E-01, 2.2081140956E-01, 5.5304704452E-01],
	[1.0775000000E+04, 4.7245110764E+00, 5.9175819863E+00, 2.4142949112E-01, 2.2110949550E-01, 5.5319856537E-01],
	[1.0780000000E+04, 4.7274073773E+00, 5.9169017747E+00, 2.4177876592E-01, 2.2140781966E-01, 5.5335006509E-01],
	[1.0785000000E+04, 4.7303041095E+00, 5.9162219567E+00, 2.4212838325E-01, 2.2170638204E-01, 5.5350154368E-01],
	[1.0790000000E+04, 4.7332012728E+00, 5.9155425319E+00, 2.4247834329E-01, 2.2200518266E-01, 5.5365300114E-01],
	[1.0795000000E+04, 4.7360988670E+00, 5.9148634998E+00, 2.4282864622E-01, 2.2230422153E-01, 5.5380443748E-01],
	[1.0800000000E+04, 4.7389968922E+00, 5.9141848600E+00, 2.4317929220E-01, 2.2260349867E-01, 5.5395585270E-01],
	[1.0805000000E+04, 4.7418953480E+00, 5.9135066122E+00, 2.4353028142E-01, 2.2290301408E-01, 5.5410724680E-01],
	[1.0810000000E+04, 4.7447942344E+00, 5.9128287558E+00, 2.4388161406E-01, 2.2320276778E-01, 5.5425861980E-01],
	[1.0815000000E+04, 4.7476935512E+00, 5.9121512906E+00, 2.4423329028E-01, 2.2350275978E-01, 5.5440997169E-01],
	[1.0820000000E+04, 4.7505932983E+00, 5.9114742161E+00, 2.4458531027E-01, 2.2380299010E-01, 5.5456130248E-01],
	[1.0825000000E+04, 4.7534934756E+00, 5.9107975319E+00, 2.4493767421E-01, 2.2410345874E-01, 5.5471261217E-01],
	[1.0830000000E+04, 4.7563940830E+00, 5.9101212375E+00, 2.4529038226E-01, 2.2440416572E-01, 5.5486390078E-01],
	[1.0835000000E+04, 4.7592951202E+00, 5.9094453327E+00, 2.4564343460E-01, 2.2470511105E-01, 5.5501516829E-01],
	[1.0840000000E+04, 4.7621965872E+00, 5.9087698169E+00, 2.4599683142E-01, 2.2500629474E-01, 5.5516641473E-01],
	[1.0845000000E+04, 4.7650984838E+00, 5.9080946898E+00, 2.4635057288E-01, 2.2530771680E-01, 5.5531764008E-01],
	[1.0850000000E+04, 4.7680008099E+00, 5.9074199510E+00, 2.4670465916E-01, 2.2560937725E-01, 5.5546884437E-01],
	[1.0855000000E+04, 4.7709035653E+00, 5.9067456000E+00, 2.4705909045E-01, 2.2591127609E-01, 5.5562002759E-01],
	[1.0860000000E+04, 4.7738067500E+00, 5.9060716365E+00, 2.4741386691E-01, 2.2621341333E-01, 5.5577118974E-01],
	[1.0865000000E+04, 4.7767103638E+00, 5.9053980601E+00, 2.4776898872E-01, 2.2651578899E-01, 5.5592233084E-01],
	[1.0870000000E+04, 4.7796144065E+00, 5.9047248704E+00, 2.4812445606E-01, 2.2681840307E-01, 5.5607345089E-01],
	[1.0875000000E+04, 4.7825188781E+00, 5.9040520669E+00, 2.4848026911E-01, 2.2712125559E-01, 5.5622454988E-01],
	[1.0880000000E+04, 4.7854237783E+00, 5.9033796494E+00, 2.4883642804E-01, 2.2742434656E-01, 5.5637562784E-01],
	[1.0885000000E+04, 4.7883291071E+00, 5.9027076172E+00, 2.4919293302E-01, 2.2772767598E-01, 5.5652668475E-01],
	[1.0890000000E+04, 4.7912348643E+00, 5.9020359702E+00, 2.4954978424E-01, 2.2803124387E-01, 5.5667772064E-01],
	[1.0895000000E+04, 4.7941410498E+00, 5.9013647079E+00, 2.4990698187E-01, 2.2833505024E-01, 5.5682873549E-01],
	[1.0900000000E+04, 4.7970476634E+00, 5.9006938298E+00, 2.5026452609E-01, 2.2863909509E-01, 5.5697972933E-01],
	[1.0905000000E+04, 4.7999547051E+00, 5.9000233356E+00, 2.5062241706E-01, 2.2894337843E-01, 5.5713070214E-01],
	[1.0910000000E+04, 4.8028621747E+00, 5.8993532249E+00, 2.5098065498E-01, 2.2924790028E-01, 5.5728165395E-01],
	[1.0915000000E+04, 4.8057700720E+00, 5.8986834973E+00, 2.5133924002E-01, 2.2955266065E-01, 5.5743258474E-01],
	[1.0920000000E+04, 4.8086783969E+00, 5.8980141524E+00, 2.5169817234E-01, 2.2985765954E-01, 5.5758349454E-01],
	[1.0925000000E+04, 4.8115871493E+00, 5.8973451898E+00, 2.5205745214E-01, 2.3016289695E-01, 5.5773438333E-01],
	[1.0930000000E+04, 4.8144963291E+00, 5.8966766091E+00, 2.5241707958E-01, 2.3046837291E-01, 5.5788525114E-01],
	[1.0935000000E+04, 4.8174059361E+00, 5.8960084099E+00, 2.5277705484E-01, 2.3077408742E-01, 5.5803609796E-01],
	[1.0940000000E+04, 4.8203199917E+00, 5.8953514911E+00, 2.5313737810E-01, 2.3108006647E-01, 5.5818692380E-01],
	[1.0945000000E+04, 4.8232345701E+00, 5.8946951969E+00, 2.5349804953E-01, 2.3138628480E-01, 5.5833772866E-01],
	[1.0950000000E+04, 4.8261495784E+00, 5.8940392755E+00, 2.5385906932E-01, 2.3169274183E-01, 5.5848851255E-01],
	[1.0955000000E+04, 4.8290650165E+00, 5.8933837264E+00, 2.5422043763E-01, 2.3199943756E-01, 5.5863927548E-01],
	[1.0960000000E+04, 4.8319808843E+00, 5.8927285494E+00, 2.5458215464E-01, 2.3230637200E-01, 5.5879001745E-01],
	[1.0965000000E+04, 4.8348971816E+00, 5.8920737439E+00, 2.5494422054E-01, 2.3261354516E-01, 5.5894073846E-01],
	[1.0970000000E+04, 4.8378139082E+00, 5.8914193097E+00, 2.5530663549E-01, 2.3292095704E-01, 5.5909143853E-01],
	[1.0975000000E+04, 4.8407310641E+00, 5.8907652464E+00, 2.5566939968E-01, 2.3322860766E-01, 5.5924211765E-01],
	[1.0980000000E+04, 4.8436486491E+00, 5.8901115535E+00, 2.5603251327E-01, 2.3353649702E-01, 5.5939277584E-01],
	[1.0985000000E+04, 4.8465666631E+00, 5.8894582307E+00, 2.5639597646E-01, 2.3384462513E-01, 5.5954341309E-01],
	[1.0990000000E+04, 4.8494851060E+00, 5.8888052776E+00, 2.5675978940E-01, 2.3415299199E-01, 5.5969402942E-01],
	[1.0995000000E+04, 4.8524039776E+00, 5.8881526939E+00, 2.5712395229E-01, 2.3446159761E-01, 5.5984462482E-01],
	[1.1000000000E+04, 4.8553232778E+00, 5.8875004791E+00, 2.5748846529E-01, 2.3477044200E-01, 5.5999519931E-01],
	[1.1005000000E+04, 4.8582430064E+00, 5.8868486330E+00, 2.5785332858E-01, 2.3507952517E-01, 5.6014575289E-01],
	[1.1010000000E+04, 4.8611631633E+00, 5.8861971550E+00, 2.5821854234E-01, 2.3538884712E-01, 5.6029628557E-01],
	[1.1015000000E+04, 4.8640837485E+00, 5.8855460449E+00, 2.5858410675E-01, 2.3569840785E-01, 5.6044679735E-01],
	[1.1020000000E+04, 4.8670047617E+00, 5.8848953022E+00, 2.5895002198E-01, 2.3600820739E-01, 5.6059728824E-01],
	[1.1025000000E+04, 4.8699262028E+00, 5.8842449267E+00, 2.5931628820E-01, 2.3631824571E-01, 5.6074775824E-01],
	[1.1030000000E+04, 4.8728480718E+00, 5.8835949178E+00, 2.5968290561E-01, 2.3662852285E-01, 5.6089820736E-01],
	[1.1035000000E+04, 4.8757703684E+00, 5.8829452753E+00, 2.6004987436E-01, 2.3693903880E-01, 5.6104863561E-01],
	[1.1040000000E+04, 4.8786930925E+00, 5.8822959988E+00, 2.6041719464E-01, 2.3724979356E-01, 5.6119904299E-01],
	[1.1045000000E+04, 4.8816162441E+00, 5.8816470879E+00, 2.6078486663E-01, 2.3756078714E-01, 5.6134942950E-01],
	[1.1050000000E+04, 4.8845398229E+00, 5.8809985421E+00, 2.6115289050E-01, 2.3787201956E-01, 5.6149979516E-01],
	[1.1055000000E+04, 4.8874638288E+00, 5.8803503613E+00, 2.6152126643E-01, 2.3818349080E-01, 5.6165013997E-01],
	[1.1060000000E+04, 4.8903882618E+00, 5.8797025449E+00, 2.6188999460E-01, 2.3849520088E-01, 5.6180046393E-01],
	[1.1065000000E+04, 4.8933131217E+00, 5.8790550927E+00, 2.6225907517E-01, 2.3880714980E-01, 5.6195076705E-01],
	[1.1070000000E+04, 4.8962384083E+00, 5.8784080042E+00, 2.6262850833E-01, 2.3911933757E-01, 5.6210104934E-01],
	[1.1075000000E+04, 4.8991641215E+00, 5.8777612791E+00, 2.6299829426E-01, 2.3943176419E-01, 5.6225131081E-01],
	[1.1080000000E+04, 4.9020902612E+00, 5.8771149170E+00, 2.6336843313E-01, 2.3974442966E-01, 5.6240155145E-01],
	[1.1085000000E+04, 4.9050168273E+00, 5.8764689175E+00, 2.6373892512E-01, 2.4005733399E-01, 5.6255177128E-01],
	[1.1090000000E+04, 4.9079438196E+00, 5.8758232803E+00, 2.6410977040E-01, 2.4037047719E-01, 5.6270197030E-01],
	[1.1095000000E+04, 4.9108712381E+00, 5.8751780050E+00, 2.6448096916E-01, 2.4068385925E-01, 5.6285214851E-01],
	[1.1100000000E+04, 4.9137990824E+00, 5.8745330913E+00, 2.6485252156E-01, 2.4099748018E-01, 5.6300230593E-01],
	[1.1105000000E+04, 4.9167273527E+00, 5.8738885388E+00, 2.6522442779E-01, 2.4131133998E-01, 5.6315244256E-01],
	[1.1110000000E+04, 4.9196560486E+00, 5.8732443470E+00, 2.6559668802E-01, 2.4162543866E-01, 5.6330255841E-01],
	[1.1115000000E+04, 4.9225884515E+00, 5.8726087940E+00, 2.6596930242E-01, 2.4193979819E-01, 5.6345265348E-01],
	[1.1120000000E+04, 4.9255222664E+00, 5.8719760762E+00, 2.6634227119E-01, 2.4225440331E-01, 5.6360272778E-01],
	[1.1125000000E+04, 4.9284565098E+00, 5.8713437111E+00, 2.6671559448E-01, 2.4256924744E-01, 5.6375278131E-01],
	[1.1130000000E+04, 4.9313911815E+00, 5.8707116981E+00, 2.6708927249E-01, 2.4288433059E-01, 5.6390281409E-01],
	[1.1135000000E+04, 4.9343262814E+00, 5.8700800369E+00, 2.6746330538E-01, 2.4319965275E-01, 5.6405282611E-01],
	[1.1140000000E+04, 4.9372618095E+00, 5.8694487273E+00, 2.6783769333E-01, 2.4351521394E-01, 5.6420281739E-01],
	[1.1145000000E+04, 4.9401977654E+00, 5.8688177688E+00, 2.6821243652E-01, 2.4383101415E-01, 5.6435278792E-01],
	[1.1150000000E+04, 4.9431341493E+00, 5.8681871611E+00, 2.6858753512E-01, 2.4414705339E-01, 5.6450273773E-01],
	[1.1155000000E+04, 4.9460709608E+00, 5.8675569038E+00, 2.6896298932E-01, 2.4446333165E-01, 5.6465266681E-01],
	[1.1160000000E+04, 4.9490081999E+00, 5.8669269966E+00, 2.6933879929E-01, 2.4477984894E-01, 5.6480257517E-01],
	[1.1165000000E+04, 4.9519458664E+00, 5.8662974391E+00, 2.6971496520E-01, 2.4509660527E-01, 5.6495246281E-01],
	[1.1170000000E+04, 4.9548839603E+00, 5.8656682310E+00, 2.7009148724E-01, 2.4541360062E-01, 5.6510232975E-01],
	[1.1175000000E+04, 4.9578224813E+00, 5.8650393719E+00, 2.7046836558E-01, 2.4573083502E-01, 5.6525217599E-01],
	[1.1180000000E+04, 4.9607614294E+00, 5.8644108615E+00, 2.7084560039E-01, 2.4604830845E-01, 5.6540200154E-01],
	[1.1185000000E+04, 4.9637008044E+00, 5.8637826995E+00, 2.7122563839E-01, 2.4636803955E-01, 5.6555180640E-01],
	[1.1190000000E+04, 4.9666406063E+00, 5.8631548854E+00, 2.7160619532E-01, 2.4668814258E-01, 5.6570159058E-01],
	[1.1195000000E+04, 4.9695808348E+00, 5.8625274190E+00, 2.7198711539E-01, 2.4700848882E-01, 5.6585135409E-01],
	[1.1200000000E+04, 4.9725214898E+00, 5.8619002998E+00, 2.7236839878E-01, 2.4732907827E-01, 5.6600109692E-01],
	[1.1205000000E+04, 4.9754625712E+00, 5.8612735276E+00, 2.7275004568E-01, 2.4764991093E-01, 5.6615081910E-01],
	[1.1210000000E+04, 4.9784040790E+00, 5.8606471020E+00, 2.7313205626E-01, 2.4797098680E-01, 5.6630052063E-01],
	[1.1215000000E+04, 4.9813460128E+00, 5.8600210226E+00, 2.7351443072E-01, 2.4829230589E-01, 5.6645020151E-01],
	[1.1220000000E+04, 4.9842883727E+00, 5.8593952892E+00, 2.7389716923E-01, 2.4861386820E-01, 5.6659986175E-01],
	[1.1225000000E+04, 4.9872311586E+00, 5.8587699013E+00, 2.7428027198E-01, 2.4893567372E-01, 5.6674950136E-01],
	[1.1230000000E+04, 4.9901743701E+00, 5.8581448586E+00, 2.7466373915E-01, 2.4925772246E-01, 5.6689912034E-01],
	[1.1235000000E+04, 4.9931180074E+00, 5.8575201607E+00, 2.7504757093E-01, 2.4958001442E-01, 5.6704871870E-01],
	[1.1240000000E+04, 4.9960620701E+00, 5.8568958074E+00, 2.7543176750E-01, 2.4990254961E-01, 5.6719829646E-01],
	[1.1245000000E+04, 4.9990065582E+00, 5.8562717983E+00, 2.7581632904E-01, 2.5022532801E-01, 5.6734785360E-01],
	[1.1250000000E+04, 5.0019514716E+00, 5.8556481330E+00, 2.7620125574E-01, 2.5054834964E-01, 5.6749739015E-01],
	[1.1255000000E+04, 5.0048968101E+00, 5.8550248112E+00, 2.7658654777E-01, 2.5087161450E-01, 5.6764690611E-01],
	[1.1260000000E+04, 5.0078425736E+00, 5.8544018326E+00, 2.7697220533E-01, 2.5119512257E-01, 5.6779640148E-01],
	[1.1265000000E+04, 5.0107887620E+00, 5.8537791968E+00, 2.7735822860E-01, 2.5151887387E-01, 5.6794587628E-01],
	[1.1270000000E+04, 5.0137353752E+00, 5.8531569034E+00, 2.7774461776E-01, 2.5184286840E-01, 5.6809533050E-01],
	[1.1275000000E+04, 5.0166824130E+00, 5.8525349522E+00, 2.7813137299E-01, 2.5216710615E-01, 5.6824476417E-01],
	[1.1280000000E+04, 5.0196298752E+00, 5.8519133428E+00, 2.7851849448E-01, 2.5249158712E-01, 5.6839417727E-01],
	[1.1285000000E+04, 5.0225777618E+00, 5.8512920748E+00, 2.7890598241E-01, 2.5281631132E-01, 5.6854356983E-01],
	[1.1290000000E+04, 5.0255260727E+00, 5.8506711479E+00, 2.7929383696E-01, 2.5314127874E-01, 5.6869294185E-01],
	[1.1295000000E+04, 5.0284792015E+00, 5.8500608837E+00, 2.7968205832E-01, 2.5346651992E-01, 5.6884229329E-01],
	[1.1300000000E+04, 5.0314327819E+00, 5.8494510105E+00, 2.8007064668E-01, 2.5379200463E-01, 5.6899162415E-01],
	[1.1305000000E+04, 5.0343867894E+00, 5.8488414707E+00, 2.8045960221E-01, 2.5411773269E-01, 5.6914093441E-01],
	[1.1310000000E+04, 5.0373412238E+00, 5.8482322638E+00, 2.8084892510E-01, 2.5444370411E-01, 5.6929022406E-01],
	[1.1315000000E+04, 5.0402960851E+00, 5.8476233896E+00, 2.8123861553E-01, 2.5476991888E-01, 5.6943949311E-01],
	[1.1320000000E+04, 5.0432513731E+00, 5.8470148477E+00, 2.8162867369E-01, 2.5509637700E-01, 5.6958874153E-01],
	[1.1325000000E+04, 5.0462070877E+00, 5.8464066379E+00, 2.8201909976E-01, 2.5542307848E-01, 5.6973796934E-01],
	[1.1330000000E+04, 5.0491632287E+00, 5.8457987598E+00, 2.8240989392E-01, 2.5575002330E-01, 5.6988717651E-01],
	[1.1335000000E+04, 5.0521197961E+00, 5.8451912130E+00, 2.8280105636E-01, 2.5607721147E-01, 5.7003636306E-01],
	[1.1340000000E+04, 5.0550767896E+00, 5.8445839972E+00, 2.8319258726E-01, 2.5640464298E-01, 5.7018552895E-01],
	[1.1345000000E+04, 5.0580342093E+00, 5.8439771122E+00, 2.8358448681E-01, 2.5673231784E-01, 5.7033467421E-01],
	[1.1350000000E+04, 5.0609920548E+00, 5.8433705576E+00, 2.8397675518E-01, 2.5706023604E-01, 5.7048379880E-01],
	[1.1355000000E+04, 5.0639503262E+00, 5.8427643330E+00, 2.8436939257E-01, 2.5738839758E-01, 5.7063290274E-01],
	[1.1360000000E+04, 5.0669090233E+00, 5.8421584381E+00, 2.8476239915E-01, 2.5771680245E-01, 5.7078198601E-01],
	[1.1365000000E+04, 5.0698681460E+00, 5.8415528727E+00, 2.8515577511E-01, 2.5804545066E-01, 5.7093104861E-01],
	[1.1370000000E+04, 5.0728276941E+00, 5.8409476363E+00, 2.8554952064E-01, 2.5837434219E-01, 5.7108009053E-01],
	[1.1375000000E+04, 5.0757876676E+00, 5.8403427287E+00, 2.8594363591E-01, 2.5870347705E-01, 5.7122911176E-01],
	[1.1380000000E+04, 5.0787480662E+00, 5.8397381496E+00, 2.8633812112E-01, 2.5903285524E-01, 5.7137811230E-01],
	[1.1385000000E+04, 5.0817088899E+00, 5.8391338985E+00, 2.8673297644E-01, 2.5936247675E-01, 5.7152709215E-01],
	[1.1390000000E+04, 5.0846701385E+00, 5.8385299753E+00, 2.8712820206E-01, 2.5969234157E-01, 5.7167605130E-01],
	[1.1395000000E+04, 5.0876318119E+00, 5.8379263795E+00, 2.8752379816E-01, 2.6002244971E-01, 5.7182498973E-01],
	[1.1400000000E+04, 5.0905939101E+00, 5.8373231109E+00, 2.8791976492E-01, 2.6035280116E-01, 5.7197390746E-01],
	[1.1405000000E+04, 5.0935564328E+00, 5.8367201691E+00, 2.8831610254E-01, 2.6068339591E-01, 5.7212280446E-01],
	[1.1410000000E+04, 5.0965193799E+00, 5.8361175539E+00, 2.8871281119E-01, 2.6101423396E-01, 5.7227168073E-01],
	[1.1415000000E+04, 5.0994827514E+00, 5.8355152648E+00, 2.8910989106E-01, 2.6134531531E-01, 5.7242053628E-01],
	[1.1420000000E+04, 5.1024465470E+00, 5.8349133016E+00, 2.8950734233E-01, 2.6167663995E-01, 5.7256937108E-01],
	[1.1425000000E+04, 5.1054107667E+00, 5.8343116639E+00, 2.8990516518E-01, 2.6200820788E-01, 5.7271818515E-01],
	[1.1430000000E+04, 5.1083754104E+00, 5.8337103515E+00, 2.9030335981E-01, 2.6234001909E-01, 5.7286697846E-01],
	[1.1435000000E+04, 5.1113404778E+00, 5.8331093640E+00, 2.9070192639E-01, 2.6267207358E-01, 5.7301575102E-01],
	[1.1440000000E+04, 5.1143059690E+00, 5.8325087011E+00, 2.9110086510E-01, 2.6300437134E-01, 5.7316450282E-01],
	[1.1445000000E+04, 5.1172718837E+00, 5.8319083625E+00, 2.9150017614E-01, 2.6333691236E-01, 5.7331323386E-01],
	[1.1450000000E+04, 5.1202382218E+00, 5.8313083478E+00, 2.9189985968E-01, 2.6366969665E-01, 5.7346194412E-01],
	[1.1455000000E+04, 5.1232049833E+00, 5.8307086568E+00, 2.9229991590E-01, 2.6400272419E-01, 5.7361063361E-01],
	[1.1460000000E+04, 5.1261721679E+00, 5.8301092892E+00, 2.9270034501E-01, 2.6433599498E-01, 5.7375930232E-01],
	[1.1465000000E+04, 5.1291397756E+00, 5.8295102445E+00, 2.9310114716E-01, 2.6466950902E-01, 5.7390795023E-01],
	[1.1470000000E+04, 5.1321078063E+00, 5.8289115226E+00, 2.9350232256E-01, 2.6500326629E-01, 5.7405657736E-01],
	[1.1475000000E+04, 5.1350792026E+00, 5.8283195673E+00, 2.9390387139E-01, 2.6533728801E-01, 5.7420518368E-01],
	[1.1480000000E+04, 5.1380526534E+00, 5.8277314965E+00, 2.9430579382E-01, 2.6567156481E-01, 5.7435376921E-01],
	[1.1485000000E+04, 5.1410265301E+00, 5.8271437410E+00, 2.9470809004E-01, 2.6600608497E-01, 5.7450233392E-01],
	[1.1490000000E+04, 5.1440008326E+00, 5.8265563006E+00, 2.9511076024E-01, 2.6634084848E-01, 5.7465087782E-01],
	[1.1495000000E+04, 5.1469755607E+00, 5.8259691750E+00, 2.9551380460E-01, 2.6667585534E-01, 5.7479940090E-01],
	[1.1500000000E+04, 5.1499507142E+00, 5.8253823638E+00, 2.9591722331E-01, 2.6701110554E-01, 5.7494790315E-01],
	[1.1505000000E+04, 5.1529262932E+00, 5.8247958667E+00, 2.9632101654E-01, 2.6734659908E-01, 5.7509638458E-01],
	[1.1510000000E+04, 5.1559022973E+00, 5.8242096835E+00, 2.9672518449E-01, 2.6768233593E-01, 5.7524484517E-01],
	[1.1515000000E+04, 5.1588787266E+00, 5.8236238139E+00, 2.9712972733E-01, 2.6801831611E-01, 5.7539328492E-01],
	[1.1520000000E+04, 5.1618555809E+00, 5.8230382574E+00, 2.9753464526E-01, 2.6835453959E-01, 5.7554170382E-01],
	[1.1525000000E+04, 5.1648328601E+00, 5.8224530139E+00, 2.9793993844E-01, 2.6869100638E-01, 5.7569010188E-01],
	[1.1530000000E+04, 5.1678105640E+00, 5.8218680831E+00, 2.9834560708E-01, 2.6902771647E-01, 5.7583847907E-01],
	[1.1535000000E+04, 5.1707886926E+00, 5.8212834645E+00, 2.9875165135E-01, 2.6936466984E-01, 5.7598683541E-01],
	[1.1540000000E+04, 5.1737672456E+00, 5.8206991580E+00, 2.9915807144E-01, 2.6970186649E-01, 5.7613517089E-01],
	[1.1545000000E+04, 5.1767462231E+00, 5.8201151632E+00, 2.9956486752E-01, 2.7003930641E-01, 5.7628348549E-01],
	[1.1550000000E+04, 5.1797256248E+00, 5.8195314798E+00, 2.9997203980E-01, 2.7037698959E-01, 5.7643177922E-01],
	[1.1555000000E+04, 5.1827054506E+00, 5.8189481075E+00, 3.0037958844E-01, 2.7071491602E-01, 5.7658005206E-01],
	[1.1560000000E+04, 5.1856857004E+00, 5.8183650461E+00, 3.0078751363E-01, 2.7105308570E-01, 5.7672830403E-01],
	[1.1565000000E+04, 5.1886663742E+00, 5.8177822952E+00, 3.0119581556E-01, 2.7139149862E-01, 5.7687653510E-01],
	[1.1570000000E+04, 5.1916474716E+00, 5.8171998545E+00, 3.0160449442E-01, 2.7173015476E-01, 5.7702474528E-01],
	[1.1575000000E+04, 5.1946289928E+00, 5.8166177237E+00, 3.0201355037E-01, 2.7206905411E-01, 5.7717293456E-01],
	[1.1580000000E+04, 5.1976109374E+00, 5.8160359025E+00, 3.0242298362E-01, 2.7240819668E-01, 5.7732110293E-01],
	[1.1585000000E+04, 5.2005933054E+00, 5.8154543907E+00, 3.0283279435E-01, 2.7274758244E-01, 5.7746925040E-01],
	[1.1590000000E+04, 5.2035760968E+00, 5.8148731879E+00, 3.0324298273E-01, 2.7308721139E-01, 5.7761737695E-01],
	[1.1595000000E+04, 5.2065593112E+00, 5.8142922938E+00, 3.0365354895E-01, 2.7342708352E-01, 5.7776548259E-01],
	[1.1600000000E+04, 5.2095429487E+00, 5.8137117082E+00, 3.0406449320E-01, 2.7376719881E-01, 5.7791356730E-01],
	[1.1605000000E+04, 5.2125270091E+00, 5.8131314307E+00, 3.0447581566E-01, 2.7410755727E-01, 5.7806163109E-01],
	[1.1610000000E+04, 5.2155114923E+00, 5.8125514610E+00, 3.0488751651E-01, 2.7444815887E-01, 5.7820967394E-01],
	[1.1615000000E+04, 5.2184963981E+00, 5.8119717989E+00, 3.0529959595E-01, 2.7478900360E-01, 5.7835769586E-01],
	[1.1620000000E+04, 5.2214817265E+00, 5.8113924440E+00, 3.0571205415E-01, 2.7513009147E-01, 5.7850569684E-01],
	[1.1625000000E+04, 5.2244674773E+00, 5.8108133961E+00, 3.0612489129E-01, 2.7547142244E-01, 5.7865367687E-01],
	[1.1630000000E+04, 5.2274536504E+00, 5.8102346548E+00, 3.0653810757E-01, 2.7581299652E-01, 5.7880163595E-01],
	[1.1635000000E+04, 5.2304402457E+00, 5.8096562199E+00, 3.0695170316E-01, 2.7615481369E-01, 5.7894957408E-01],
	[1.1640000000E+04, 5.2334272630E+00, 5.8090780911E+00, 3.0736567826E-01, 2.7649687395E-01, 5.7909749125E-01],
	[1.1645000000E+04, 5.2364147022E+00, 5.8085002680E+00, 3.0778003303E-01, 2.7683917727E-01, 5.7924538746E-01],
	[1.1650000000E+04, 5.2394025633E+00, 5.8079227504E+00, 3.0819476768E-01, 2.7718172364E-01, 5.7939326271E-01],
	[1.1655000000E+04, 5.2423908460E+00, 5.8073455380E+00, 3.0860988238E-01, 2.7752451307E-01, 5.7954111698E-01],
	[1.1660000000E+04, 5.2453828961E+00, 5.8067754624E+00, 3.0902537732E-01, 2.7786757056E-01, 5.7968895027E-01],
	[1.1665000000E+04, 5.2483767528E+00, 5.8062085087E+00, 3.0944125268E-01, 2.7821088153E-01, 5.7983676259E-01],
	[1.1670000000E+04, 5.2513710341E+00, 5.8056418532E+00, 3.0985750865E-01, 2.7855443567E-01, 5.7998455392E-01],
	[1.1675000000E+04, 5.2543657400E+00, 5.8050754957E+00, 3.1027414540E-01, 2.7889823295E-01, 5.8013232427E-01],
	[1.1680000000E+04, 5.2573608704E+00, 5.8045094359E+00, 3.1069116314E-01, 2.7924227336E-01, 5.8028007362E-01],
	[1.1685000000E+04, 5.2603564250E+00, 5.8039436736E+00, 3.1110856203E-01, 2.7958655690E-01, 5.8042780198E-01],
	[1.1690000000E+04, 5.2633524039E+00, 5.8033782084E+00, 3.1152634226E-01, 2.7993108354E-01, 5.8057550934E-01],
	[1.1695000000E+04, 5.2663488069E+00, 5.8028130401E+00, 3.1194450403E-01, 2.8027585327E-01, 5.8072319569E-01],
	[1.1700000000E+04, 5.2693456338E+00, 5.8022481684E+00, 3.1236304750E-01, 2.8062086609E-01, 5.8087086104E-01],
	[1.1705000000E+04, 5.2723428845E+00, 5.8016835929E+00, 3.1278197287E-01, 2.8096612197E-01, 5.8101850538E-01],
	[1.1710000000E+04, 5.2753405590E+00, 5.8011193135E+00, 3.1320128033E-01, 2.8131162091E-01, 5.8116612869E-01],
	[1.1715000000E+04, 5.2783386570E+00, 5.8005553298E+00, 3.1362097005E-01, 2.8165736289E-01, 5.8131373099E-01],
	[1.1720000000E+04, 5.2813371785E+00, 5.7999916416E+00, 3.1404104222E-01, 2.8200334790E-01, 5.8146131227E-01],
	[1.1725000000E+04, 5.2843361234E+00, 5.7994282485E+00, 3.1446149702E-01, 2.8234957592E-01, 5.8160887252E-01],
	[1.1730000000E+04, 5.2873354915E+00, 5.7988651503E+00, 3.1488233464E-01, 2.8269604694E-01, 5.8175641173E-01],
	[1.1735000000E+04, 5.2903352828E+00, 5.7983023468E+00, 3.1530355527E-01, 2.8304276094E-01, 5.8190392991E-01],
	[1.1740000000E+04, 5.2933354970E+00, 5.7977398375E+00, 3.1572515909E-01, 2.8338971792E-01, 5.8205142706E-01],
	[1.1745000000E+04, 5.2963361340E+00, 5.7971776224E+00, 3.1614714627E-01, 2.8373691785E-01, 5.8219890316E-01],
	[1.1750000000E+04, 5.2993371939E+00, 5.7966157010E+00, 3.1656951702E-01, 2.8408436072E-01, 5.8234635821E-01],
	[1.1755000000E+04, 5.3023386763E+00, 5.7960540731E+00, 3.1699227150E-01, 2.8443204652E-01, 5.8249379222E-01],
	[1.1760000000E+04, 5.3053405813E+00, 5.7954927384E+00, 3.1741540991E-01, 2.8477997522E-01, 5.8264120517E-01],
	[1.1765000000E+04, 5.3083429086E+00, 5.7949316967E+00, 3.1783893243E-01, 2.8512814683E-01, 5.8278859706E-01],
	[1.1770000000E+04, 5.3113456583E+00, 5.7943709476E+00, 3.1826283925E-01, 2.8547656132E-01, 5.8293596789E-01],
	[1.1775000000E+04, 5.3143488300E+00, 5.7938104909E+00, 3.1868713054E-01, 2.8582521867E-01, 5.8308331766E-01],
	[1.1780000000E+04, 5.3173524238E+00, 5.7932503263E+00, 3.1911180650E-01, 2.8617411887E-01, 5.8323064636E-01],
	[1.1785000000E+04, 5.3203564395E+00, 5.7926904536E+00, 3.1953686731E-01, 2.8652326190E-01, 5.8337795399E-01],
	[1.1790000000E+04, 5.3233608770E+00, 5.7921308724E+00, 3.1996231315E-01, 2.8687264775E-01, 5.8352524054E-01],
	[1.1795000000E+04, 5.3263657362E+00, 5.7915715825E+00, 3.2038814421E-01, 2.8722227640E-01, 5.8367250602E-01],
	[1.1800000000E+04, 5.3293710169E+00, 5.7910125836E+00, 3.2081436067E-01, 2.8757214784E-01, 5.8381975042E-01],
	[1.1805000000E+04, 5.3323767190E+00, 5.7904538755E+00, 3.2124096272E-01, 2.8792226204E-01, 5.8396697373E-01],
	[1.1810000000E+04, 5.3353828425E+00, 5.7898954578E+00, 3.2166795054E-01, 2.8827261899E-01, 5.8411417595E-01],
	[1.1815000000E+04, 5.3383893871E+00, 5.7893373302E+00, 3.2209532431E-01, 2.8862321868E-01, 5.8426135708E-01],
	[1.1820000000E+04, 5.3413963528E+00, 5.7887794926E+00, 3.2252308423E-01, 2.8897406109E-01, 5.8440851711E-01],
	[1.1825000000E+04, 5.3444037395E+00, 5.7882219447E+00, 3.2295123047E-01, 2.8932514620E-01, 5.8455565605E-01],
	[1.1830000000E+04, 5.3474115470E+00, 5.7876646861E+00, 3.2337976322E-01, 2.8967647399E-01, 5.8470277388E-01],
	[1.1835000000E+04, 5.3504197752E+00, 5.7871077166E+00, 3.2380868267E-01, 2.9002804444E-01, 5.8484987061E-01],
	[1.1840000000E+04, 5.3534284240E+00, 5.7865510359E+00, 3.2423798899E-01, 2.9037985754E-01, 5.8499694623E-01],
	[1.1845000000E+04, 5.3564383580E+00, 5.7859962916E+00, 3.2466768238E-01, 2.9073191998E-01, 5.8514400075E-01],
	[1.1850000000E+04, 5.3594527344E+00, 5.7854494935E+00, 3.2509776302E-01, 2.9108425631E-01, 5.8529103414E-01],
	[1.1855000000E+04, 5.3624675345E+00, 5.7849029777E+00, 3.2552823109E-01, 2.9143683539E-01, 5.8543804642E-01],
	[1.1860000000E+04, 5.3654827582E+00, 5.7843567439E+00, 3.2595908678E-01, 2.9178965720E-01, 5.8558503758E-01],
	[1.1865000000E+04, 5.3684984052E+00, 5.7838107918E+00, 3.2639033027E-01, 2.9214272173E-01, 5.8573200762E-01],
	[1.1870000000E+04, 5.3715144756E+00, 5.7832651213E+00, 3.2682196174E-01, 2.9249602894E-01, 5.8587895653E-01],
	[1.1875000000E+04, 5.3745309692E+00, 5.7827197321E+00, 3.2725398139E-01, 2.9284957884E-01, 5.8602588431E-01],
	[1.1880000000E+04, 5.3775478859E+00, 5.7821746239E+00, 3.2768638940E-01, 2.9320337139E-01, 5.8617279095E-01],
	[1.1885000000E+04, 5.3805652255E+00, 5.7816297963E+00, 3.2811918595E-01, 2.9355740659E-01, 5.8631967647E-01],
	[1.1890000000E+04, 5.3835829880E+00, 5.7810852493E+00, 3.2855237122E-01, 2.9391168440E-01, 5.8646654084E-01],
	[1.1895000000E+04, 5.3866011731E+00, 5.7805409824E+00, 3.2898594541E-01, 2.9426620481E-01, 5.8661338407E-01],
	[1.1900000000E+04, 5.3896197809E+00, 5.7799969955E+00, 3.2941990869E-01, 2.9462096781E-01, 5.8676020616E-01],
	[1.1905000000E+04, 5.3926388112E+00, 5.7794532882E+00, 3.2985426125E-01, 2.9497597336E-01, 5.8690700708E-01],
	[1.1910000000E+04, 5.3956582638E+00, 5.7789098604E+00, 3.3028900328E-01, 2.9533122146E-01, 5.8705378682E-01],
	[1.1915000000E+04, 5.3986781387E+00, 5.7783667117E+00, 3.3072413496E-01, 2.9568671208E-01, 5.8720054534E-01],
	[1.1920000000E+04, 5.4016984357E+00, 5.7778238420E+00, 3.3115965647E-01, 2.9604244521E-01, 5.8734728266E-01],
	[1.1925000000E+04, 5.4047191547E+00, 5.7772812508E+00, 3.3159556800E-01, 2.9639842082E-01, 5.8749399874E-01],
	[1.1930000000E+04, 5.4077402955E+00, 5.7767389381E+00, 3.3203186974E-01, 2.9675463889E-01, 5.8764069359E-01],
	[1.1935000000E+04, 5.4107618582E+00, 5.7761969034E+00, 3.3246856186E-01, 2.9711109940E-01, 5.8778736718E-01],
	[1.1940000000E+04, 5.4137838425E+00, 5.7756551466E+00, 3.3290564456E-01, 2.9746780233E-01, 5.8793401951E-01],
	[1.1945000000E+04, 5.4168062484E+00, 5.7751136674E+00, 3.3334311802E-01, 2.9782474766E-01, 5.8808065056E-01],
	[1.1950000000E+04, 5.4198290756E+00, 5.7745724656E+00, 3.3378098243E-01, 2.9818193537E-01, 5.8822726032E-01],
	[1.1955000000E+04, 5.4228523242E+00, 5.7740315408E+00, 3.3421923796E-01, 2.9853936544E-01, 5.8837384878E-01],
	[1.1960000000E+04, 5.4258759940E+00, 5.7734908929E+00, 3.3465788480E-01, 2.9889703785E-01, 5.8852041592E-01],
	[1.1965000000E+04, 5.4289000848E+00, 5.7729505215E+00, 3.3509692315E-01, 2.9925495257E-01, 5.8866696174E-01],
	[1.1970000000E+04, 5.4319245966E+00, 5.7724104265E+00, 3.3553635318E-01, 2.9961310958E-01, 5.8881348621E-01],
	[1.1975000000E+04, 5.4349495292E+00, 5.7718706074E+00, 3.3597617507E-01, 2.9997150887E-01, 5.8895998934E-01],
	[1.1980000000E+04, 5.4379748825E+00, 5.7713310642E+00, 3.3641638902E-01, 3.0033015041E-01, 5.8910647110E-01],
	[1.1985000000E+04, 5.4410006564E+00, 5.7707917966E+00, 3.3685699521E-01, 3.0068903417E-01, 5.8925293149E-01],
	[1.1990000000E+04, 5.4440268508E+00, 5.7702528042E+00, 3.3729799382E-01, 3.0104816014E-01, 5.8939937049E-01],
	[1.1995000000E+04, 5.4470534656E+00, 5.7697140868E+00, 3.3773938504E-01, 3.0140752830E-01, 5.8954578809E-01],
	[1.2000000000E+04, 5.4500805006E+00, 5.7691756443E+00, 3.3818116905E-01, 3.0176713861E-01, 5.8969218428E-01],
	[1.2005000000E+04, 5.4531079557E+00, 5.7686374762E+00, 3.3862334604E-01, 3.0212699106E-01, 5.8983855905E-01],
	[1.2010000000E+04, 5.4561358309E+00, 5.7680995824E+00, 3.3906591619E-01, 3.0248708563E-01, 5.8998491238E-01],
	[1.2015000000E+04, 5.4591641259E+00, 5.7675619627E+00, 3.3950887970E-01, 3.0284742229E-01, 5.9013124426E-01],
	[1.2020000000E+04, 5.4621928408E+00, 5.7670246166E+00, 3.3995223673E-01, 3.0320800101E-01, 5.9027755468E-01],
	[1.2025000000E+04, 5.4652219753E+00, 5.7664875441E+00, 3.4039598748E-01, 3.0356882178E-01, 5.9042384364E-01],
	[1.2030000000E+04, 5.4682515293E+00, 5.7659507449E+00, 3.4084013214E-01, 3.0392988457E-01, 5.9057011111E-01],
	[1.2035000000E+04, 5.4712817156E+00, 5.7654145972E+00, 3.4128467088E-01, 3.0429119108E-01, 5.9071635708E-01],
	[1.2040000000E+04, 5.4743171541E+00, 5.7648873139E+00, 3.4172960390E-01, 3.0465277852E-01, 5.9086258155E-01],
	[1.2045000000E+04, 5.4773530153E+00, 5.7643602977E+00, 3.4217493137E-01, 3.0501460808E-01, 5.9100878450E-01],
	[1.2050000000E+04, 5.4803892990E+00, 5.7638335484E+00, 3.4262065349E-01, 3.0537667973E-01, 5.9115496592E-01],
	[1.2055000000E+04, 5.4834260053E+00, 5.7633070657E+00, 3.4306677043E-01, 3.0573899344E-01, 5.9130112580E-01],
	[1.2060000000E+04, 5.4864631338E+00, 5.7627808493E+00, 3.4351328239E-01, 3.0610154919E-01, 5.9144726413E-01],
	[1.2065000000E+04, 5.4895006846E+00, 5.7622548991E+00, 3.4396018955E-01, 3.0646434696E-01, 5.9159338089E-01],
	[1.2070000000E+04, 5.4925386576E+00, 5.7617292148E+00, 3.4440749209E-01, 3.0682738673E-01, 5.9173947607E-01],
	[1.2075000000E+04, 5.4955770525E+00, 5.7612037962E+00, 3.4485519020E-01, 3.0719066846E-01, 5.9188554967E-01],
	[1.2080000000E+04, 5.4986158693E+00, 5.7606786430E+00, 3.4530328406E-01, 3.0755419213E-01, 5.9203160167E-01],
	[1.2085000000E+04, 5.5016551078E+00, 5.7601537549E+00, 3.4575177386E-01, 3.0791795772E-01, 5.9217763206E-01],
	[1.2090000000E+04, 5.5046947680E+00, 5.7596291317E+00, 3.4620065979E-01, 3.0828196520E-01, 5.9232364082E-01],
	[1.2095000000E+04, 5.5077348497E+00, 5.7591047732E+00, 3.4664994202E-01, 3.0864621455E-01, 5.9246962796E-01],
	[1.2100000000E+04, 5.5107753529E+00, 5.7585806791E+00, 3.4709962075E-01, 3.0901070574E-01, 5.9261559344E-01],
	[1.2105000000E+04, 5.5138162773E+00, 5.7580568493E+00, 3.4754969616E-01, 3.0937543874E-01, 5.9276153728E-01],
	[1.2110000000E+04, 5.5168576230E+00, 5.7575332833E+00, 3.4800016843E-01, 3.0974041354E-01, 5.9290745944E-01],
	[1.2115000000E+04, 5.5198993897E+00, 5.7570099811E+00, 3.4845103775E-01, 3.1010563010E-01, 5.9305335993E-01],
	[1.2120000000E+04, 5.5229415773E+00, 5.7564869423E+00, 3.4890230431E-01, 3.1047108839E-01, 5.9319923872E-01],
	[1.2125000000E+04, 5.5259841858E+00, 5.7559641668E+00, 3.4935396828E-01, 3.1083678840E-01, 5.9334509582E-01],
	[1.2130000000E+04, 5.5290272150E+00, 5.7554416542E+00, 3.4980602986E-01, 3.1120273010E-01, 5.9349093120E-01],
	[1.2135000000E+04, 5.5320706648E+00, 5.7549194044E+00, 3.5025848923E-01, 3.1156891345E-01, 5.9363674487E-01],
	[1.2140000000E+04, 5.5351145351E+00, 5.7543974171E+00, 3.5071134658E-01, 3.1193533843E-01, 5.9378253679E-01],
	[1.2145000000E+04, 5.5381588258E+00, 5.7538756920E+00, 3.5116460209E-01, 3.1230200502E-01, 5.9392830697E-01],
	[1.2150000000E+04, 5.5412035368E+00, 5.7533542289E+00, 3.5161825594E-01, 3.1266891318E-01, 5.9407405540E-01],
	[1.2155000000E+04, 5.5442486679E+00, 5.7528330277E+00, 3.5207230833E-01, 3.1303606289E-01, 5.9421978206E-01],
	[1.2160000000E+04, 5.5472942190E+00, 5.7523120879E+00, 3.5252675943E-01, 3.1340345413E-01, 5.9436548694E-01],
	[1.2165000000E+04, 5.5503401900E+00, 5.7517914095E+00, 3.5298160943E-01, 3.1377108686E-01, 5.9451117003E-01],
	[1.2170000000E+04, 5.5533865809E+00, 5.7512709921E+00, 3.5343685852E-01, 3.1413896105E-01, 5.9465683132E-01],
	[1.2175000000E+04, 5.5564333914E+00, 5.7507508356E+00, 3.5389250689E-01, 3.1450707669E-01, 5.9480247080E-01],
	[1.2180000000E+04, 5.5594806215E+00, 5.7502309396E+00, 3.5434855471E-01, 3.1487543373E-01, 5.9494808845E-01],
	[1.2185000000E+04, 5.5625282711E+00, 5.7497113040E+00, 3.5480500217E-01, 3.1524403216E-01, 5.9509368428E-01],
	[1.2190000000E+04, 5.5655763400E+00, 5.7491919285E+00, 3.5526184946E-01, 3.1561287194E-01, 5.9523925826E-01],
	[1.2195000000E+04, 5.5686248281E+00, 5.7486728129E+00, 3.5571909677E-01, 3.1598195305E-01, 5.9538481039E-01],
	[1.2200000000E+04, 5.5716737354E+00, 5.7481539570E+00, 3.5617674427E-01, 3.1635127545E-01, 5.9553034065E-01],
	[1.2205000000E+04, 5.5747230616E+00, 5.7476353604E+00, 3.5663479216E-01, 3.1672083912E-01, 5.9567584904E-01],
	[1.2210000000E+04, 5.5777728068E+00, 5.7471170230E+00, 3.5709324062E-01, 3.1709064403E-01, 5.9582133554E-01],
	[1.2215000000E+04, 5.5808229707E+00, 5.7465989445E+00, 3.5755208983E-01, 3.1746069015E-01, 5.9596680015E-01],
	[1.2220000000E+04, 5.5838735532E+00, 5.7460811248E+00, 3.5801133998E-01, 3.1783097745E-01, 5.9611224285E-01],
	[1.2225000000E+04, 5.5869245544E+00, 5.7455635634E+00, 3.5847099126E-01, 3.1820150590E-01, 5.9625766363E-01],
	[1.2230000000E+04, 5.5899775014E+00, 5.7450487975E+00, 3.5893104385E-01, 3.1857228822E-01, 5.9640306248E-01],
	[1.2235000000E+04, 5.5930345470E+00, 5.7445403951E+00, 3.5939149793E-01, 3.1894334248E-01, 5.9654843940E-01],
	[1.2240000000E+04, 5.5960920144E+00, 5.7440322453E+00, 3.5985235370E-01, 3.1931463798E-01, 5.9669379436E-01],
	[1.2245000000E+04, 5.5991499034E+00, 5.7435243480E+00, 3.6031361133E-01, 3.1968617467E-01, 5.9683912737E-01],
	[1.2250000000E+04, 5.6022082139E+00, 5.7430167029E+00, 3.6077527102E-01, 3.2005795253E-01, 5.9698443840E-01],
	[1.2255000000E+04, 5.6052669459E+00, 5.7425093099E+00, 3.6123733295E-01, 3.2042997154E-01, 5.9712972746E-01],
	[1.2260000000E+04, 5.6083260992E+00, 5.7420021686E+00, 3.6169979729E-01, 3.2080223165E-01, 5.9727499452E-01],
	[1.2265000000E+04, 5.6113856736E+00, 5.7414952788E+00, 3.6216266425E-01, 3.2117473285E-01, 5.9742023959E-01],
	[1.2270000000E+04, 5.6144456692E+00, 5.7409886404E+00, 3.6262593400E-01, 3.2154747510E-01, 5.9756546264E-01],
	[1.2275000000E+04, 5.6175060857E+00, 5.7404822531E+00, 3.6308960673E-01, 3.2192045836E-01, 5.9771066367E-01],
	[1.2280000000E+04, 5.6205669230E+00, 5.7399761166E+00, 3.6355368263E-01, 3.2229368261E-01, 5.9785584267E-01],
	[1.2285000000E+04, 5.6236281811E+00, 5.7394702307E+00, 3.6401816188E-01, 3.2266714782E-01, 5.9800099963E-01],
	[1.2290000000E+04, 5.6266898599E+00, 5.7389645953E+00, 3.6448304466E-01, 3.2304085396E-01, 5.9814613454E-01],
	[1.2295000000E+04, 5.6297519591E+00, 5.7384592101E+00, 3.6494833117E-01, 3.2341480098E-01, 5.9829124738E-01],
	[1.2300000000E+04, 5.6328144787E+00, 5.7379540748E+00, 3.6541402158E-01, 3.2378898887E-01, 5.9843633816E-01],
	[1.2305000000E+04, 5.6358774187E+00, 5.7374491893E+00, 3.6588011608E-01, 3.2416341759E-01, 5.9858140685E-01],
	[1.2310000000E+04, 5.6389407788E+00, 5.7369445532E+00, 3.6634661487E-01, 3.2453808711E-01, 5.9872645345E-01],
	[1.2315000000E+04, 5.6420045589E+00, 5.7364401665E+00, 3.6681351811E-01, 3.2491299739E-01, 5.9887147795E-01],
	[1.2320000000E+04, 5.6450687590E+00, 5.7359360288E+00, 3.6728082601E-01, 3.2528814841E-01, 5.9901648033E-01],
	[1.2325000000E+04, 5.6481333789E+00, 5.7354321400E+00, 3.6774853874E-01, 3.2566354013E-01, 5.9916146060E-01],
	[1.2330000000E+04, 5.6511984186E+00, 5.7349284997E+00, 3.6821665649E-01, 3.2603917251E-01, 5.9930641873E-01],
	[1.2335000000E+04, 5.6542638779E+00, 5.7344251079E+00, 3.6868517945E-01, 3.2641504554E-01, 5.9945135472E-01],
	[1.2340000000E+04, 5.6573297566E+00, 5.7339219642E+00, 3.6915410780E-01, 3.2679115916E-01, 5.9959626856E-01],
	[1.2345000000E+04, 5.6603960548E+00, 5.7334190685E+00, 3.6962344173E-01, 3.2716751335E-01, 5.9974116024E-01],
	[1.2350000000E+04, 5.6634627722E+00, 5.7329164205E+00, 3.7009318142E-01, 3.2754410808E-01, 5.9988602974E-01],
	[1.2355000000E+04, 5.6665299088E+00, 5.7324140200E+00, 3.7056332706E-01, 3.2792094331E-01, 6.0003087707E-01],
	[1.2360000000E+04, 5.6695974644E+00, 5.7319118668E+00, 3.7103387883E-01, 3.2829801901E-01, 6.0017570221E-01],
	[1.2365000000E+04, 5.6726654389E+00, 5.7314099606E+00, 3.7150483692E-01, 3.2867533515E-01, 6.0032050514E-01],
	[1.2370000000E+04, 5.6757338323E+00, 5.7309083013E+00, 3.7197620152E-01, 3.2905289169E-01, 6.0046528587E-01],
	[1.2375000000E+04, 5.6788026444E+00, 5.7304068886E+00, 3.7244797280E-01, 3.2943068859E-01, 6.0061004438E-01],
	[1.2380000000E+04, 5.6818718750E+00, 5.7299057223E+00, 3.7292015097E-01, 3.2980872583E-01, 6.0075478065E-01],
	[1.2385000000E+04, 5.6849415242E+00, 5.7294048021E+00, 3.7339273619E-01, 3.3018700336E-01, 6.0089949469E-01],
	[1.2390000000E+04, 5.6880115917E+00, 5.7289041279E+00, 3.7386572867E-01, 3.3056552116E-01, 6.0104418649E-01],
	[1.2395000000E+04, 5.6910820775E+00, 5.7284036994E+00, 3.7433912858E-01, 3.3094427918E-01, 6.0118885602E-01],
	[1.2400000000E+04, 5.6941529815E+00, 5.7279035165E+00, 3.7481293610E-01, 3.3132327740E-01, 6.0133350329E-01],
	[1.2405000000E+04, 5.6972243035E+00, 5.7274035788E+00, 3.7528715144E-01, 3.3170251578E-01, 6.0147812828E-01],
	[1.2410000000E+04, 5.7002960434E+00, 5.7269038862E+00, 3.7576177476E-01, 3.3208199429E-01, 6.0162273099E-01],
	[1.2415000000E+04, 5.7033682011E+00, 5.7264044385E+00, 3.7623680626E-01, 3.3246171288E-01, 6.0176731140E-01],
	[1.2420000000E+04, 5.7064407765E+00, 5.7259052354E+00, 3.7671224612E-01, 3.3284167152E-01, 6.0191186950E-01],
	[1.2425000000E+04, 5.7095137695E+00, 5.7254062768E+00, 3.7718809453E-01, 3.3322187018E-01, 6.0205640529E-01],
	[1.2430000000E+04, 5.7125921335E+00, 5.7249152365E+00, 3.7766435167E-01, 3.3360235177E-01, 6.0220091876E-01],
	[1.2435000000E+04, 5.7156713437E+00, 5.7244250947E+00, 3.7814101773E-01, 3.3398307717E-01, 6.0234540990E-01],
	[1.2440000000E+04, 5.7187509749E+00, 5.7239351919E+00, 3.7861809290E-01, 3.3436404265E-01, 6.0248987870E-01],
	[1.2445000000E+04, 5.7218310268E+00, 5.7234455279E+00, 3.7909557736E-01, 3.3474524819E-01, 6.0263432514E-01],
	[1.2450000000E+04, 5.7249114994E+00, 5.7229561024E+00, 3.7957347129E-01, 3.3512669374E-01, 6.0277874922E-01],
	[1.2455000000E+04, 5.7279923926E+00, 5.7224669153E+00, 3.8005177489E-01, 3.3550837928E-01, 6.0292315094E-01],
	[1.2460000000E+04, 5.7310737062E+00, 5.7219779663E+00, 3.8053048833E-01, 3.3589030475E-01, 6.0306753028E-01],
	[1.2465000000E+04, 5.7341554401E+00, 5.7214892552E+00, 3.8100961181E-01, 3.3627247013E-01, 6.0321188723E-01],
	[1.2470000000E+04, 5.7372375942E+00, 5.7210007818E+00, 3.8148914551E-01, 3.3665487539E-01, 6.0335622178E-01],
	[1.2475000000E+04, 5.7403201684E+00, 5.7205125460E+00, 3.8196908962E-01, 3.3703752047E-01, 6.0350053393E-01],
	[1.2480000000E+04, 5.7434031627E+00, 5.7200245474E+00, 3.8244944431E-01, 3.3742040535E-01, 6.0364482367E-01],
	[1.2485000000E+04, 5.7464865768E+00, 5.7195367859E+00, 3.8293020979E-01, 3.3780352999E-01, 6.0378909103E-01],
	[1.2490000000E+04, 5.7495704107E+00, 5.7190492613E+00, 3.8341138622E-01, 3.3818689434E-01, 6.0393333607E-01],
	[1.2495000000E+04, 5.7526546642E+00, 5.7185619733E+00, 3.8389297381E-01, 3.3857049838E-01, 6.0407755877E-01],
	[1.2500000000E+04, 5.7557393373E+00, 5.7180749218E+00, 3.8437497273E-01, 3.3895434207E-01, 6.0422175912E-01],
	[1.2505000000E+04, 5.7588244299E+00, 5.7175881065E+00, 3.8485827830E-01, 3.3933912127E-01, 6.0436593710E-01],
	[1.2510000000E+04, 5.7619099418E+00, 5.7171015272E+00, 3.8534199751E-01, 3.3972414121E-01, 6.0451009270E-01],
	[1.2515000000E+04, 5.7649958729E+00, 5.7166151838E+00, 3.8582613057E-01, 3.4010940185E-01, 6.0465422589E-01],
	[1.2520000000E+04, 5.7680822231E+00, 5.7161290759E+00, 3.8631067764E-01, 3.4049490315E-01, 6.0479833667E-01],
	[1.2525000000E+04, 5.7711689923E+00, 5.7156432035E+00, 3.8679563894E-01, 3.4088064508E-01, 6.0494242502E-01],
	[1.2530000000E+04, 5.7742561803E+00, 5.7151575663E+00, 3.8728101463E-01, 3.4126662759E-01, 6.0508649093E-01],
	[1.2535000000E+04, 5.7773437872E+00, 5.7146721641E+00, 3.8776680491E-01, 3.4165285065E-01, 6.0523053437E-01],
	[1.2540000000E+04, 5.7804318127E+00, 5.7141869966E+00, 3.8825300997E-01, 3.4203931422E-01, 6.0537455533E-01],
	[1.2545000000E+04, 5.7835202568E+00, 5.7137020638E+00, 3.8873962999E-01, 3.4242601826E-01, 6.0551855380E-01],
	[1.2550000000E+04, 5.7866091194E+00, 5.7132173652E+00, 3.8922666517E-01, 3.4281296273E-01, 6.0566252977E-01],
	[1.2555000000E+04, 5.7896984002E+00, 5.7127329009E+00, 3.8971411568E-01, 3.4320014759E-01, 6.0580648321E-01],
	[1.2560000000E+04, 5.7927880993E+00, 5.7122486705E+00, 3.9020198173E-01, 3.4358757280E-01, 6.0595041411E-01],
	[1.2565000000E+04, 5.7958782165E+00, 5.7117646739E+00, 3.9069026349E-01, 3.4397523833E-01, 6.0609432245E-01],
	[1.2570000000E+04, 5.7989687518E+00, 5.7112809108E+00, 3.9117896115E-01, 3.4436314412E-01, 6.0623820823E-01],
	[1.2575000000E+04, 5.8020597049E+00, 5.7107973810E+00, 3.9166807491E-01, 3.4475129015E-01, 6.0638207143E-01],
	[1.2580000000E+04, 5.8051510758E+00, 5.7103140844E+00, 3.9215760494E-01, 3.4513967637E-01, 6.0652591202E-01],
	[1.2585000000E+04, 5.8082428644E+00, 5.7098310207E+00, 3.9264755145E-01, 3.4552830274E-01, 6.0666973000E-01],
	[1.2590000000E+04, 5.8113350705E+00, 5.7093481897E+00, 3.9313791461E-01, 3.4591716923E-01, 6.0681352536E-01],
	[1.2595000000E+04, 5.8144276941E+00, 5.7088655912E+00, 3.9362869462E-01, 3.4630627578E-01, 6.0695729806E-01],
	[1.2600000000E+04, 5.8175207351E+00, 5.7083832251E+00, 3.9411989166E-01, 3.4669562236E-01, 6.0710104811E-01],
	[1.2605000000E+04, 5.8206141933E+00, 5.7079010911E+00, 3.9461150592E-01, 3.4708520894E-01, 6.0724477549E-01],
	[1.2610000000E+04, 5.8237080686E+00, 5.7074191889E+00, 3.9510353758E-01, 3.4747503545E-01, 6.0738848017E-01],
	[1.2615000000E+04, 5.8268023610E+00, 5.7069375185E+00, 3.9559598685E-01, 3.4786510188E-01, 6.0753216215E-01],
	[1.2620000000E+04, 5.8298970702E+00, 5.7064560796E+00, 3.9608885389E-01, 3.4825540817E-01, 6.0767582141E-01],
	[1.2625000000E+04, 5.8329921963E+00, 5.7059748719E+00, 3.9658213892E-01, 3.4864595428E-01, 6.0781945794E-01],
	[1.2630000000E+04, 5.8360929359E+00, 5.7055013074E+00, 3.9707584210E-01, 3.4903678650E-01, 6.0796307172E-01],
	[1.2635000000E+04, 5.8391945814E+00, 5.7050286623E+00, 3.9756996363E-01, 3.4942786297E-01, 6.0810666274E-01],
	[1.2640000000E+04, 5.8422966472E+00, 5.7045562433E+00, 3.9806450369E-01, 3.4981917934E-01, 6.0825023098E-01],
	[1.2645000000E+04, 5.8453991332E+00, 5.7040840502E+00, 3.9855946248E-01, 3.5021073554E-01, 6.0839377642E-01],
	[1.2650000000E+04, 5.8485020392E+00, 5.7036120829E+00, 3.9905484019E-01, 3.5060253155E-01, 6.0853729906E-01],
	[1.2655000000E+04, 5.8516053652E+00, 5.7031403411E+00, 3.9955063700E-01, 3.5099456733E-01, 6.0868079888E-01],
	[1.2660000000E+04, 5.8547091109E+00, 5.7026688246E+00, 4.0004685309E-01, 3.5138684282E-01, 6.0882427586E-01],
	[1.2665000000E+04, 5.8578132764E+00, 5.7021975333E+00, 4.0054348866E-01, 3.5177935799E-01, 6.0896772999E-01],
	[1.2670000000E+04, 5.8609178615E+00, 5.7017264669E+00, 4.0104054390E-01, 3.5217211279E-01, 6.0911116125E-01],
	[1.2675000000E+04, 5.8640228661E+00, 5.7012556253E+00, 4.0153801899E-01, 3.5256510719E-01, 6.0925456963E-01],
	[1.2680000000E+04, 5.8671282901E+00, 5.7007850083E+00, 4.0203591413E-01, 3.5295834113E-01, 6.0939795512E-01],
	[1.2685000000E+04, 5.8702341333E+00, 5.7003146156E+00, 4.0253422949E-01, 3.5335181458E-01, 6.0954131770E-01],
	[1.2690000000E+04, 5.8733403958E+00, 5.6998444471E+00, 4.0303296527E-01, 3.5374552749E-01, 6.0968465736E-01],
	[1.2695000000E+04, 5.8764470772E+00, 5.6993745026E+00, 4.0353212166E-01, 3.5413947982E-01, 6.0982797408E-01],
	[1.2700000000E+04, 5.8795541777E+00, 5.6989047818E+00, 4.0403169884E-01, 3.5453367152E-01, 6.0997126785E-01],
	[1.2705000000E+04, 5.8826616970E+00, 5.6984352846E+00, 4.0453169701E-01, 3.5492810255E-01, 6.1011453865E-01],
	[1.2710000000E+04, 5.8857696350E+00, 5.6979660108E+00, 4.0503211635E-01, 3.5532277287E-01, 6.1025778647E-01],
	[1.2715000000E+04, 5.8888779916E+00, 5.6974969602E+00, 4.0553295704E-01, 3.5571768244E-01, 6.1040101130E-01],
	[1.2720000000E+04, 5.8919867668E+00, 5.6970281326E+00, 4.0603421929E-01, 3.5611283120E-01, 6.1054421311E-01],
	[1.2725000000E+04, 5.8950959604E+00, 5.6965595278E+00, 4.0653590327E-01, 3.5650821911E-01, 6.1068739191E-01],
	[1.2730000000E+04, 5.8982055723E+00, 5.6960911456E+00, 4.0703800917E-01, 3.5690384614E-01, 6.1083054767E-01],
	[1.2735000000E+04, 5.9013156023E+00, 5.6956229859E+00, 4.0754053719E-01, 3.5729971222E-01, 6.1097368037E-01],
	[1.2740000000E+04, 5.9044260505E+00, 5.6951550483E+00, 4.0804348750E-01, 3.5769581733E-01, 6.1111679002E-01],
	[1.2745000000E+04, 5.9075369166E+00, 5.6946873329E+00, 4.0854686031E-01, 3.5809216142E-01, 6.1125987658E-01],
	[1.2750000000E+04, 5.9106482007E+00, 5.6942198392E+00, 4.0905065579E-01, 3.5848874443E-01, 6.1140294005E-01],
	[1.2755000000E+04, 5.9137599024E+00, 5.6937525672E+00, 4.0955487414E-01, 3.5888556632E-01, 6.1154598041E-01],
	[1.2760000000E+04, 5.9168720219E+00, 5.6932855167E+00, 4.1005951555E-01, 3.5928262705E-01, 6.1168899765E-01],
	[1.2765000000E+04, 5.9199845589E+00, 5.6928186874E+00, 4.1056458019E-01, 3.5967992658E-01, 6.1183199175E-01],
	[1.2770000000E+04, 5.9230975133E+00, 5.6923520792E+00, 4.1107006827E-01, 3.6007746485E-01, 6.1197496271E-01],
	[1.2775000000E+04, 5.9262108850E+00, 5.6918856919E+00, 4.1157597996E-01, 3.6047524182E-01, 6.1211791051E-01],
	[1.2780000000E+04, 5.9293246740E+00, 5.6914195252E+00, 4.1208231546E-01, 3.6087325745E-01, 6.1226083512E-01],
	[1.2785000000E+04, 5.9324388801E+00, 5.6909535791E+00, 4.1258907496E-01, 3.6127151168E-01, 6.1240373655E-01],
	[1.2790000000E+04, 5.9355535032E+00, 5.6904878533E+00, 4.1309625864E-01, 3.6167000447E-01, 6.1254661477E-01],
	[1.2795000000E+04, 5.9386685433E+00, 5.6900223476E+00, 4.1360386670E-01, 3.6206873578E-01, 6.1268946978E-01],
	[1.2800000000E+04, 5.9417840001E+00, 5.6895570618E+00, 4.1411189931E-01, 3.6246770556E-01, 6.1283230156E-01],
	[1.2805000000E+04, 5.9448998736E+00, 5.6890919958E+00, 4.1462035668E-01, 3.6286691375E-01, 6.1297511009E-01],
	[1.2810000000E+04, 5.9480161637E+00, 5.6886271494E+00, 4.1512923898E-01, 3.6326636032E-01, 6.1311789536E-01],
	[1.2815000000E+04, 5.9511328702E+00, 5.6881625223E+00, 4.1563854641E-01, 3.6366604521E-01, 6.1326065736E-01],
	[1.2820000000E+04, 5.9542499932E+00, 5.6876981143E+00, 4.1614827915E-01, 3.6406596838E-01, 6.1340339607E-01],
	[1.2825000000E+04, 5.9573675324E+00, 5.6872339254E+00, 4.1665843739E-01, 3.6446612978E-01, 6.1354611148E-01],
	[1.2830000000E+04, 5.9604870938E+00, 5.6867720509E+00, 4.1716902133E-01, 3.6486654401E-01, 6.1368880359E-01],
	[1.2835000000E+04, 5.9636115498E+00, 5.6863162324E+00, 4.1768003115E-01, 3.6526723732E-01, 6.1383147236E-01],
	[1.2840000000E+04, 5.9667364257E+00, 5.6858606280E+00, 4.1819146703E-01, 3.6566816892E-01, 6.1397411780E-01],
	[1.2845000000E+04, 5.9698617215E+00, 5.6854052374E+00, 4.1870332917E-01, 3.6606933876E-01, 6.1411673988E-01],
	[1.2850000000E+04, 5.9729874370E+00, 5.6849500605E+00, 4.1921561776E-01, 3.6647074679E-01, 6.1425933860E-01],
	[1.2855000000E+04, 5.9761135721E+00, 5.6844950971E+00, 4.1972833298E-01, 3.6687239297E-01, 6.1440191394E-01],
	[1.2860000000E+04, 5.9792401267E+00, 5.6840403470E+00, 4.2024147503E-01, 3.6727427724E-01, 6.1454446588E-01],
	[1.2865000000E+04, 5.9823671008E+00, 5.6835858100E+00, 4.2075504408E-01, 3.6767639957E-01, 6.1468699442E-01],
	[1.2870000000E+04, 5.9854944941E+00, 5.6831314860E+00, 4.2126904033E-01, 3.6807875989E-01, 6.1482949954E-01],
	[1.2875000000E+04, 5.9886223066E+00, 5.6826773748E+00, 4.2178346398E-01, 3.6848135817E-01, 6.1497198123E-01],
	[1.2880000000E+04, 5.9917505382E+00, 5.6822234761E+00, 4.2229831519E-01, 3.6888419434E-01, 6.1511443947E-01],
	[1.2885000000E+04, 5.9948791888E+00, 5.6817697899E+00, 4.2281359418E-01, 3.6928726837E-01, 6.1525687425E-01],
	[1.2890000000E+04, 5.9980082583E+00, 5.6813163158E+00, 4.2332930111E-01, 3.6969058021E-01, 6.1539928556E-01],
	[1.2895000000E+04, 6.0011377465E+00, 5.6808630539E+00, 4.2384543619E-01, 3.7009412979E-01, 6.1554167339E-01],
	[1.2900000000E+04, 6.0042676534E+00, 5.6804100037E+00, 4.2436199960E-01, 3.7049791709E-01, 6.1568403772E-01],
	[1.2905000000E+04, 6.0073979788E+00, 5.6799571653E+00, 4.2487899153E-01, 3.7090194203E-01, 6.1582637854E-01],
	[1.2910000000E+04, 6.0105287227E+00, 5.6795045383E+00, 4.2539641217E-01, 3.7130620458E-01, 6.1596869583E-01],
	[1.2915000000E+04, 6.0136598850E+00, 5.6790521226E+00, 4.2591426170E-01, 3.7171070469E-01, 6.1611098959E-01],
	[1.2920000000E+04, 6.0167914654E+00, 5.6785999181E+00, 4.2643254032E-01, 3.7211544230E-01, 6.1625325980E-01],
	[1.2925000000E+04, 6.0199234640E+00, 5.6781479246E+00, 4.2695124821E-01, 3.7252041736E-01, 6.1639550644E-01],
	[1.2930000000E+04, 6.0230558806E+00, 5.6776961418E+00, 4.2747038557E-01, 3.7292562982E-01, 6.1653772951E-01],
	[1.2935000000E+04, 6.0261887152E+00, 5.6772445696E+00, 4.2798995258E-01, 3.7333107964E-01, 6.1667992899E-01],
	[1.2940000000E+04, 6.0293219675E+00, 5.6767932078E+00, 4.2850994942E-01, 3.7373676676E-01, 6.1682210487E-01],
	[1.2945000000E+04, 6.0324556376E+00, 5.6763420563E+00, 4.2903037630E-01, 3.7414269112E-01, 6.1696425714E-01],
	[1.2950000000E+04, 6.0355897252E+00, 5.6758911148E+00, 4.2955123339E-01, 3.7454885269E-01, 6.1710638578E-01],
	[1.2955000000E+04, 6.0387242304E+00, 5.6754403832E+00, 4.3007252088E-01, 3.7495525140E-01, 6.1724849078E-01],
	[1.2960000000E+04, 6.0418591529E+00, 5.6749898613E+00, 4.3059423898E-01, 3.7536188721E-01, 6.1739057212E-01],
	[1.2965000000E+04, 6.0449944927E+00, 5.6745395489E+00, 4.3111638785E-01, 3.7576876006E-01, 6.1753262981E-01],
	[1.2970000000E+04, 6.0481302497E+00, 5.6740894459E+00, 4.3163896770E-01, 3.7617586990E-01, 6.1767466382E-01],
	[1.2975000000E+04, 6.0512664238E+00, 5.6736395520E+00, 4.3216197871E-01, 3.7658321668E-01, 6.1781667413E-01],
	[1.2980000000E+04, 6.0544030149E+00, 5.6731898671E+00, 4.3268542106E-01, 3.7699080035E-01, 6.1795866075E-01],
	[1.2985000000E+04, 6.0575400228E+00, 5.6727403910E+00, 4.3320929496E-01, 3.7739862086E-01, 6.1810062365E-01],
	[1.2990000000E+04, 6.0606774474E+00, 5.6722911236E+00, 4.3373360058E-01, 3.7780667815E-01, 6.1824256282E-01],
	[1.2995000000E+04, 6.0638152887E+00, 5.6718420646E+00, 4.3425833812E-01, 3.7821497216E-01, 6.1838447825E-01],
	[1.3000000000E+04, 6.0669535466E+00, 5.6713932139E+00, 4.3478350776E-01, 3.7862350286E-01, 6.1852636994E-01],
	[1.3005000000E+04, 6.0700922209E+00, 5.6709445713E+00, 4.3530910969E-01, 3.7903227017E-01, 6.1866823785E-01],
	[1.3010000000E+04, 6.0732313115E+00, 5.6704961366E+00, 4.3583514411E-01, 3.7944127406E-01, 6.1881008199E-01],
	[1.3015000000E+04, 6.0763708184E+00, 5.6700479097E+00, 4.3636161120E-01, 3.7985051447E-01, 6.1895190234E-01],
	[1.3020000000E+04, 6.0795107414E+00, 5.6695998903E+00, 4.3688851115E-01, 3.8025999134E-01, 6.1909369889E-01],
	[1.3025000000E+04, 6.0826510804E+00, 5.6691520783E+00, 4.3741584414E-01, 3.8066970461E-01, 6.1923547163E-01],
	[1.3030000000E+04, 6.0857918354E+00, 5.6687044736E+00, 4.3794361038E-01, 3.8107965425E-01, 6.1937722054E-01],
	[1.3035000000E+04, 6.0889330061E+00, 5.6682570759E+00, 4.3847181004E-01, 3.8148984019E-01, 6.1951894561E-01],
	[1.3040000000E+04, 6.0920808187E+00, 5.6678173372E+00, 4.3900044331E-01, 3.8190032067E-01, 6.1966064687E-01],
	[1.3045000000E+04, 6.0952293157E+00, 5.6673781179E+00, 4.3952951039E-01, 3.8231104004E-01, 6.1980232433E-01],
	[1.3050000000E+04, 6.0983782324E+00, 5.6669391009E+00, 4.4005901146E-01, 3.8272199577E-01, 6.1994397798E-01],
	[1.3055000000E+04, 6.1015275687E+00, 5.6665002861E+00, 4.4058894671E-01, 3.8313318780E-01, 6.2008560780E-01],
	[1.3060000000E+04, 6.1046773246E+00, 5.6660616733E+00, 4.4111931633E-01, 3.8354461608E-01, 6.2022721377E-01],
	[1.3065000000E+04, 6.1078274998E+00, 5.6656232623E+00, 4.4165012052E-01, 3.8395628055E-01, 6.2036879587E-01],
	[1.3070000000E+04, 6.1109780943E+00, 5.6651850529E+00, 4.4218135945E-01, 3.8436818116E-01, 6.2051035408E-01],
	[1.3075000000E+04, 6.1141291080E+00, 5.6647470450E+00, 4.4271303331E-01, 3.8478031786E-01, 6.2065188837E-01],
	[1.3080000000E+04, 6.1172805408E+00, 5.6643092385E+00, 4.4324514231E-01, 3.8519269058E-01, 6.2079339874E-01],
	[1.3085000000E+04, 6.1204323925E+00, 5.6638716331E+00, 4.4377768661E-01, 3.8560529928E-01, 6.2093488515E-01],
	[1.3090000000E+04, 6.1235846632E+00, 5.6634342286E+00, 4.4431066643E-01, 3.8601814390E-01, 6.2107634759E-01],
	[1.3095000000E+04, 6.1267373526E+00, 5.6629970250E+00, 4.4484408193E-01, 3.8643122438E-01, 6.2121778604E-01],
	[1.3100000000E+04, 6.1298904607E+00, 5.6625600220E+00, 4.4537793332E-01, 3.8684454067E-01, 6.2135920049E-01],
	[1.3105000000E+04, 6.1330439873E+00, 5.6621232195E+00, 4.4591222077E-01, 3.8725809272E-01, 6.2150059090E-01],
	[1.3110000000E+04, 6.1361979324E+00, 5.6616866172E+00, 4.4644694449E-01, 3.8767188045E-01, 6.2164195726E-01],
	[1.3115000000E+04, 6.1393522959E+00, 5.6612502151E+00, 4.4698210466E-01, 3.8808590383E-01, 6.2178329956E-01],
	[1.3120000000E+04, 6.1425070776E+00, 5.6608140130E+00, 4.4751770146E-01, 3.8850016279E-01, 6.2192461777E-01],
	[1.3125000000E+04, 6.1456622774E+00, 5.6603780106E+00, 4.4805373509E-01, 3.8891465728E-01, 6.2206591187E-01],
	[1.3130000000E+04, 6.1488178953E+00, 5.6599422079E+00, 4.4859020573E-01, 3.8932938724E-01, 6.2220718184E-01],
	[1.3135000000E+04, 6.1519739311E+00, 5.6595066046E+00, 4.4912711359E-01, 3.8974435261E-01, 6.2234842767E-01],
	[1.3140000000E+04, 6.1551303848E+00, 5.6590712006E+00, 4.4966445883E-01, 3.9015955334E-01, 6.2248964933E-01],
	[1.3145000000E+04, 6.1582872562E+00, 5.6586359958E+00, 4.5020224166E-01, 3.9057498937E-01, 6.2263084680E-01],
	[1.3150000000E+04, 6.1614445452E+00, 5.6582009899E+00, 4.5074046226E-01, 3.9099066065E-01, 6.2277202007E-01],
	[1.3155000000E+04, 6.1646022518E+00, 5.6577661828E+00, 4.5127912081E-01, 3.9140656710E-01, 6.2291316912E-01],
	[1.3160000000E+04, 6.1677603758E+00, 5.6573315743E+00, 4.5181821752E-01, 3.9182270869E-01, 6.2305429393E-01],
	[1.3165000000E+04, 6.1709189170E+00, 5.6568971643E+00, 4.5235775257E-01, 3.9223908535E-01, 6.2319539447E-01],
	[1.3170000000E+04, 6.1740778755E+00, 5.6564629526E+00, 4.5289772615E-01, 3.9265569702E-01, 6.2333647073E-01],
	[1.3175000000E+04, 6.1772372512E+00, 5.6560289390E+00, 4.5343813844E-01, 3.9307254364E-01, 6.2347752269E-01],
	[1.3180000000E+04, 6.1803970438E+00, 5.6555951234E+00, 4.5397898964E-01, 3.9348962516E-01, 6.2361855033E-01],
	[1.3185000000E+04, 6.1835572533E+00, 5.6551615056E+00, 4.5452027994E-01, 3.9390694152E-01, 6.2375955364E-01],
	[1.3190000000E+04, 6.1867178796E+00, 5.6547280854E+00, 4.5506200952E-01, 3.9432449265E-01, 6.2390053258E-01],
	[1.3195000000E+04, 6.1898789226E+00, 5.6542948626E+00, 4.5560417857E-01, 3.9474227851E-01, 6.2404148716E-01],
	[1.3200000000E+04, 6.1930403822E+00, 5.6538618372E+00, 4.5614678729E-01, 3.9516029903E-01, 6.2418241733E-01],
	[1.3205000000E+04, 6.1962022583E+00, 5.6534290089E+00, 4.5668983586E-01, 3.9557855416E-01, 6.2432332309E-01],
	[1.3210000000E+04, 6.1993645508E+00, 5.6529963776E+00, 4.5723332447E-01, 3.9599704382E-01, 6.2446420442E-01],
	[1.3215000000E+04, 6.2025272596E+00, 5.6525639431E+00, 4.5777725331E-01, 3.9641576798E-01, 6.2460506130E-01],
	[1.3220000000E+04, 6.2056903846E+00, 5.6521317052E+00, 4.5832162257E-01, 3.9683472655E-01, 6.2474589370E-01],
	[1.3225000000E+04, 6.2088539256E+00, 5.6516996638E+00, 4.5886643244E-01, 3.9725391950E-01, 6.2488670162E-01],
	[1.3230000000E+04, 6.2120178826E+00, 5.6512678187E+00, 4.5941168310E-01, 3.9767334675E-01, 6.2502748503E-01],
	[1.3235000000E+04, 6.2151822555E+00, 5.6508361698E+00, 4.5995737476E-01, 3.9809300824E-01, 6.2516824391E-01],
	[1.3240000000E+04, 6.2183470442E+00, 5.6504047169E+00, 4.6050350759E-01, 3.9851290393E-01, 6.2530897825E-01],
	[1.3245000000E+04, 6.2215122486E+00, 5.6499734598E+00, 4.6105008178E-01, 3.9893303373E-01, 6.2544968802E-01],
	[1.3250000000E+04, 6.2246846982E+00, 5.6495499252E+00, 4.6159709753E-01, 3.9935346333E-01, 6.2559037322E-01],
	[1.3255000000E+04, 6.2278576408E+00, 5.6491266626E+00, 4.6214455502E-01, 3.9977412786E-01, 6.2573103381E-01],
	[1.3260000000E+04, 6.2310310032E+00, 5.6487035914E+00, 4.6269245445E-01, 4.0019502658E-01, 6.2587166978E-01],
	[1.3265000000E+04, 6.2342047853E+00, 5.6482807113E+00, 4.6324079600E-01, 4.0061615940E-01, 6.2601228111E-01],
	[1.3270000000E+04, 6.2373789870E+00, 5.6478580222E+00, 4.6378957986E-01, 4.0103752629E-01, 6.2615286779E-01],
	[1.3275000000E+04, 6.2405536081E+00, 5.6474355240E+00, 4.6433880622E-01, 4.0145912717E-01, 6.2629342979E-01],
	[1.3280000000E+04, 6.2437286486E+00, 5.6470132165E+00, 4.6488847527E-01, 4.0188096198E-01, 6.2643396710E-01],
	[1.3285000000E+04, 6.2469041084E+00, 5.6465910995E+00, 4.6543858720E-01, 4.0230303067E-01, 6.2657447970E-01],
	[1.3290000000E+04, 6.2500799874E+00, 5.6461691729E+00, 4.6598914221E-01, 4.0272533317E-01, 6.2671496757E-01],
	[1.3295000000E+04, 6.2532562854E+00, 5.6457474365E+00, 4.6654014046E-01, 4.0314786942E-01, 6.2685543070E-01],
	[1.3300000000E+04, 6.2564330024E+00, 5.6453258902E+00, 4.6709158217E-01, 4.0357063935E-01, 6.2699586905E-01],
	[1.3305000000E+04, 6.2596101383E+00, 5.6449045337E+00, 4.6764346751E-01, 4.0399364292E-01, 6.2713628263E-01],
	[1.3310000000E+04, 6.2627876929E+00, 5.6444833670E+00, 4.6819579668E-01, 4.0441688005E-01, 6.2727667140E-01],
	[1.3315000000E+04, 6.2659656662E+00, 5.6440623899E+00, 4.6874856987E-01, 4.0484035069E-01, 6.2741703535E-01],
	[1.3320000000E+04, 6.2691440580E+00, 5.6436416023E+00, 4.6930178726E-01, 4.0526405477E-01, 6.2755737446E-01],
	[1.3325000000E+04, 6.2723228683E+00, 5.6432210039E+00, 4.6985544904E-01, 4.0568799223E-01, 6.2769768872E-01],
	[1.3330000000E+04, 6.2755020970E+00, 5.6428005946E+00, 4.7040955541E-01, 4.0611216301E-01, 6.2783797810E-01],
	[1.3335000000E+04, 6.2786817439E+00, 5.6423803743E+00, 4.7096410655E-01, 4.0653656704E-01, 6.2797824259E-01],
	[1.3340000000E+04, 6.2818618089E+00, 5.6419603428E+00, 4.7151910265E-01, 4.0696120426E-01, 6.2811848217E-01],
	[1.3345000000E+04, 6.2850422920E+00, 5.6415405000E+00, 4.7207454390E-01, 4.0738607462E-01, 6.2825869682E-01],
	[1.3350000000E+04, 6.2882231931E+00, 5.6411208456E+00, 4.7263043050E-01, 4.0781117804E-01, 6.2839888653E-01],
	[1.3355000000E+04, 6.2914045120E+00, 5.6407013796E+00, 4.7318676263E-01, 4.0823651446E-01, 6.2853905127E-01],
	[1.3360000000E+04, 6.2945862486E+00, 5.6402821018E+00, 4.7374354047E-01, 4.0866208382E-01, 6.2867919103E-01],
	[1.3365000000E+04, 6.2977684029E+00, 5.6398630121E+00, 4.7430076423E-01, 4.0908788606E-01, 6.2881930579E-01],
	[1.3370000000E+04, 6.3009509747E+00, 5.6394441102E+00, 4.7485843408E-01, 4.0951392111E-01, 6.2895939554E-01],
	[1.3375000000E+04, 6.3041339640E+00, 5.6390253960E+00, 4.7541655023E-01, 4.0994018891E-01, 6.2909946025E-01],
	[1.3380000000E+04, 6.3073173706E+00, 5.6386068694E+00, 4.7597511285E-01, 4.1036668940E-01, 6.2923949991E-01],
	[1.3385000000E+04, 6.3105011944E+00, 5.6381885302E+00, 4.7653412214E-01, 4.1079342251E-01, 6.2937951450E-01],
	[1.3390000000E+04, 6.3136854354E+00, 5.6377703783E+00, 4.7709357828E-01, 4.1122038817E-01, 6.2951950400E-01],
	[1.3395000000E+04, 6.3168700934E+00, 5.6373524135E+00, 4.7765348147E-01, 4.1164758633E-01, 6.2965946840E-01],
	[1.3400000000E+04, 6.3200551683E+00, 5.6369346356E+00, 4.7821383190E-01, 4.1207501691E-01, 6.2979940767E-01],
	[1.3405000000E+04, 6.3232406601E+00, 5.6365170446E+00, 4.7877462975E-01, 4.1250267986E-01, 6.2993932181E-01],
	[1.3410000000E+04, 6.3264265686E+00, 5.6360996402E+00, 4.7933587522E-01, 4.1293057510E-01, 6.3007921079E-01],
	[1.3415000000E+04, 6.3296128937E+00, 5.6356824223E+00, 4.7989756849E-01, 4.1335870258E-01, 6.3021907459E-01],
	[1.3420000000E+04, 6.3327996353E+00, 5.6352653907E+00, 4.8045970976E-01, 4.1378706223E-01, 6.3035891321E-01],
	[1.3425000000E+04, 6.3359867934E+00, 5.6348485453E+00, 4.8102229921E-01, 4.1421565398E-01, 6.3049872661E-01],
	[1.3430000000E+04, 6.3391743678E+00, 5.6344318860E+00, 4.8158533703E-01, 4.1464447777E-01, 6.3063851479E-01],
	[1.3435000000E+04, 6.3423623585E+00, 5.6340154125E+00, 4.8214882341E-01, 4.1507353352E-01, 6.3077827772E-01],
	[1.3440000000E+04, 6.3455507652E+00, 5.6335991248E+00, 4.8271275855E-01, 4.1550282119E-01, 6.3091801539E-01],
	[1.3445000000E+04, 6.3487395880E+00, 5.6331830227E+00, 4.8327714263E-01, 4.1593234069E-01, 6.3105772779E-01],
	[1.3450000000E+04, 6.3519288268E+00, 5.6327671060E+00, 4.8384197584E-01, 4.1636209197E-01, 6.3119741489E-01],
	[1.3455000000E+04, 6.3551184813E+00, 5.6323513746E+00, 4.8440725837E-01, 4.1679207496E-01, 6.3133707668E-01],
	[1.3460000000E+04, 6.3583110686E+00, 5.6319383910E+00, 4.8497299041E-01, 4.1722231449E-01, 6.3147671314E-01],
	[1.3465000000E+04, 6.3615088756E+00, 5.6315304779E+00, 4.8553917215E-01, 4.1765283326E-01, 6.3161632425E-01],
	[1.3470000000E+04, 6.3647071028E+00, 5.6311227458E+00, 4.8610580379E-01, 4.1808358378E-01, 6.3175591000E-01],
	[1.3475000000E+04, 6.3679057501E+00, 5.6307151946E+00, 4.8667288550E-01, 4.1851456599E-01, 6.3189547037E-01],
	[1.3480000000E+04, 6.3711048173E+00, 5.6303078240E+00, 4.8724041748E-01, 4.1894577982E-01, 6.3203500534E-01],
	[1.3485000000E+04, 6.3743043044E+00, 5.6299006339E+00, 4.8780839992E-01, 4.1937722521E-01, 6.3217451490E-01],
	[1.3490000000E+04, 6.3775042112E+00, 5.6294936242E+00, 4.8837683300E-01, 4.1980890209E-01, 6.3231399903E-01],
	[1.3495000000E+04, 6.3807045377E+00, 5.6290867948E+00, 4.8894571693E-01, 4.2024081038E-01, 6.3245345770E-01],
	[1.3500000000E+04, 6.3839052837E+00, 5.6286801455E+00, 4.8951505188E-01, 4.2067295003E-01, 6.3259289092E-01],
	[1.3505000000E+04, 6.3871064492E+00, 5.6282736761E+00, 4.9008483805E-01, 4.2110532097E-01, 6.3273229865E-01],
	[1.3510000000E+04, 6.3903080340E+00, 5.6278673865E+00, 4.9065507563E-01, 4.2153792313E-01, 6.3287168089E-01],
	[1.3515000000E+04, 6.3935100381E+00, 5.6274612765E+00, 4.9122576480E-01, 4.2197075644E-01, 6.3301103761E-01],
	[1.3520000000E+04, 6.3967124614E+00, 5.6270553460E+00, 4.9179690576E-01, 4.2240382083E-01, 6.3315036880E-01],
	[1.3525000000E+04, 6.3999153037E+00, 5.6266495950E+00, 4.9236849870E-01, 4.2283711624E-01, 6.3328967444E-01],
	[1.3530000000E+04, 6.4031185649E+00, 5.6262440231E+00, 4.9294054380E-01, 4.2327064259E-01, 6.3342895452E-01],
	[1.3535000000E+04, 6.4063222450E+00, 5.6258386303E+00, 4.9351304126E-01, 4.2370439983E-01, 6.3356820902E-01],
	[1.3540000000E+04, 6.4095263439E+00, 5.6254334164E+00, 4.9408599126E-01, 4.2413838787E-01, 6.3370743791E-01],
	[1.3545000000E+04, 6.4127308614E+00, 5.6250283813E+00, 4.9465939400E-01, 4.2457260666E-01, 6.3384664120E-01],
	[1.3550000000E+04, 6.4159357974E+00, 5.6246235248E+00, 4.9523324967E-01, 4.2500705613E-01, 6.3398581885E-01],
	[1.3555000000E+04, 6.4191411519E+00, 5.6242188468E+00, 4.9580755845E-01, 4.2544173619E-01, 6.3412497086E-01],
	[1.3560000000E+04, 6.4223469248E+00, 5.6238143472E+00, 4.9638232053E-01, 4.2587664680E-01, 6.3426409720E-01],
	[1.3565000000E+04, 6.4255531159E+00, 5.6234100258E+00, 4.9695753611E-01, 4.2631178787E-01, 6.3440319787E-01],
	[1.3570000000E+04, 6.4287597252E+00, 5.6230058824E+00, 4.9753320537E-01, 4.2674715934E-01, 6.3454227284E-01],
	[1.3575000000E+04, 6.4319667525E+00, 5.6226019169E+00, 4.9810932851E-01, 4.2718276113E-01, 6.3468132209E-01],
	[1.3580000000E+04, 6.4351741977E+00, 5.6221981292E+00, 4.9868590571E-01, 4.2761859319E-01, 6.3482034562E-01],
	[1.3585000000E+04, 6.4383820609E+00, 5.6217945191E+00, 4.9926293716E-01, 4.2805465543E-01, 6.3495934340E-01],
	[1.3590000000E+04, 6.4415903418E+00, 5.6213910865E+00, 4.9984042306E-01, 4.2849094780E-01, 6.3509831543E-01],
	[1.3595000000E+04, 6.4447990403E+00, 5.6209878313E+00, 5.0041836359E-01, 4.2892747021E-01, 6.3523726167E-01],
	[1.3600000000E+04, 6.4480081564E+00, 5.6205847532E+00, 5.0099675894E-01, 4.2936422260E-01, 6.3537618212E-01],
	[1.3605000000E+04, 6.4512176899E+00, 5.6201818522E+00, 5.0157560931E-01, 4.2980120490E-01, 6.3551507677E-01],
	[1.3610000000E+04, 6.4544276408E+00, 5.6197791281E+00, 5.0215491488E-01, 4.3023841704E-01, 6.3565394558E-01],
	[1.3615000000E+04, 6.4576380090E+00, 5.6193765808E+00, 5.0273467584E-01, 4.3067585894E-01, 6.3579278856E-01],
	[1.3620000000E+04, 6.4608487943E+00, 5.6189742101E+00, 5.0331489239E-01, 4.3111353054E-01, 6.3593160568E-01],
	[1.3625000000E+04, 6.4640599967E+00, 5.6185720158E+00, 5.0389556471E-01, 4.3155143177E-01, 6.3607039692E-01],
	[1.3630000000E+04, 6.4672716161E+00, 5.6181699979E+00, 5.0447669299E-01, 4.3198956255E-01, 6.3620916228E-01],
	[1.3635000000E+04, 6.4704836523E+00, 5.6177681562E+00, 5.0505827742E-01, 4.3242792282E-01, 6.3634790173E-01],
	[1.3640000000E+04, 6.4736961053E+00, 5.6173664906E+00, 5.0564031820E-01, 4.3286651249E-01, 6.3648661526E-01],
	[1.3645000000E+04, 6.4769089749E+00, 5.6169650009E+00, 5.0622281550E-01, 4.3330533151E-01, 6.3662530286E-01],
	[1.3650000000E+04, 6.4801222611E+00, 5.6165636869E+00, 5.0680576953E-01, 4.3374437979E-01, 6.3676396450E-01],
	[1.3655000000E+04, 6.4833359638E+00, 5.6161625486E+00, 5.0738918048E-01, 4.3418365727E-01, 6.3690260017E-01],
	[1.3660000000E+04, 6.4865500829E+00, 5.6157615858E+00, 5.0797304852E-01, 4.3462316388E-01, 6.3704120986E-01],
	[1.3665000000E+04, 6.4897646182E+00, 5.6153607983E+00, 5.0855737386E-01, 4.3506289953E-01, 6.3717979355E-01],
	[1.3670000000E+04, 6.4929795697E+00, 5.6149601860E+00, 5.0914215668E-01, 4.3550286417E-01, 6.3731835123E-01],
	[1.3675000000E+04, 6.4961950297E+00, 5.6145598360E+00, 5.0972739717E-01, 4.3594305866E-01, 6.3745688287E-01],
	[1.3680000000E+04, 6.4994185545E+00, 5.6141668692E+00, 5.1031309552E-01, 4.3638356002E-01, 6.3759538847E-01],
	[1.3685000000E+04, 6.5026424999E+00, 5.6137740735E+00, 5.1089925193E-01, 4.3682429040E-01, 6.3773386801E-01],
	[1.3690000000E+04, 6.5058668659E+00, 5.6133814487E+00, 5.1148586657E-01, 4.3726524973E-01, 6.3787232146E-01],
	[1.3695000000E+04, 6.5090916525E+00, 5.6129889948E+00, 5.1207441321E-01, 4.3770751458E-01, 6.3801074883E-01],
	[1.3700000000E+04, 6.5123168595E+00, 5.6125967115E+00, 5.1266582790E-01, 4.3815176756E-01, 6.3814915009E-01],
	[1.3705000000E+04, 6.5155424868E+00, 5.6122045988E+00, 5.1325770892E-01, 4.3859625319E-01, 6.3828752522E-01],
	[1.3710000000E+04, 6.5187685344E+00, 5.6118126565E+00, 5.1385005649E-01, 4.3904097140E-01, 6.3842587421E-01],
	[1.3715000000E+04, 6.5219950020E+00, 5.6114208844E+00, 5.1444287079E-01, 4.3948592211E-01, 6.3856419705E-01],
	[1.3720000000E+04, 6.5252218897E+00, 5.6110292825E+00, 5.1503615202E-01, 4.3993110526E-01, 6.3870249372E-01],
	[1.3725000000E+04, 6.5284491973E+00, 5.6106378506E+00, 5.1562990038E-01, 4.4037652076E-01, 6.3884076421E-01],
	[1.3730000000E+04, 6.5316769248E+00, 5.6102465886E+00, 5.1622411607E-01, 4.4082216854E-01, 6.3897900849E-01],
	[1.3735000000E+04, 6.5349050720E+00, 5.6098554962E+00, 5.1681879928E-01, 4.4126804854E-01, 6.3911722656E-01],
	[1.3740000000E+04, 6.5381336388E+00, 5.6094645735E+00, 5.1741395021E-01, 4.4171416066E-01, 6.3925541840E-01],
	[1.3745000000E+04, 6.5413626252E+00, 5.6090738202E+00, 5.1800956906E-01, 4.4216050485E-01, 6.3939358399E-01],
	[1.3750000000E+04, 6.5445920310E+00, 5.6086832363E+00, 5.1860565602E-01, 4.4260708102E-01, 6.3953172333E-01],
	[1.3755000000E+04, 6.5478218561E+00, 5.6082928215E+00, 5.1920221130E-01, 4.4305388911E-01, 6.3966983638E-01],
	[1.3760000000E+04, 6.5510521005E+00, 5.6079025758E+00, 5.1979923507E-01, 4.4350092902E-01, 6.3980792315E-01],
	[1.3765000000E+04, 6.5542827640E+00, 5.6075124990E+00, 5.2039672756E-01, 4.4394820070E-01, 6.3994598360E-01],
	[1.3770000000E+04, 6.5575138466E+00, 5.6071225910E+00, 5.2099468894E-01, 4.4439570407E-01, 6.4008401774E-01],
	[1.3775000000E+04, 6.5607453481E+00, 5.6067328517E+00, 5.2159311942E-01, 4.4484343904E-01, 6.4022202554E-01],
	[1.3780000000E+04, 6.5639772685E+00, 5.6063432809E+00, 5.2219201920E-01, 4.4529140555E-01, 6.4036000699E-01],
	[1.3785000000E+04, 6.5672096076E+00, 5.6059538784E+00, 5.2279138846E-01, 4.4573960352E-01, 6.4049796207E-01],
	[1.3790000000E+04, 6.5704423654E+00, 5.6055646442E+00, 5.2339122742E-01, 4.4618803287E-01, 6.4063589078E-01],
	[1.3795000000E+04, 6.5736755417E+00, 5.6051755781E+00, 5.2399153626E-01, 4.4663669352E-01, 6.4077379308E-01],
	[1.3800000000E+04, 6.5769091365E+00, 5.6047866800E+00, 5.2459231518E-01, 4.4708558541E-01, 6.4091166898E-01],
	[1.3805000000E+04, 6.5801431497E+00, 5.6043979497E+00, 5.2519356438E-01, 4.4753470845E-01, 6.4104951845E-01],
	[1.3810000000E+04, 6.5833775811E+00, 5.6040093872E+00, 5.2579528406E-01, 4.4798406257E-01, 6.4118734148E-01],
	[1.3815000000E+04, 6.5866124307E+00, 5.6036209922E+00, 5.2639747441E-01, 4.4843364769E-01, 6.4132513806E-01],
	[1.3820000000E+04, 6.5898476984E+00, 5.6032327647E+00, 5.2700013563E-01, 4.4888346374E-01, 6.4146290817E-01],
	[1.3825000000E+04, 6.5930833840E+00, 5.6028447045E+00, 5.2760326792E-01, 4.4933351063E-01, 6.4160065179E-01],
	[1.3830000000E+04, 6.5963194875E+00, 5.6024568115E+00, 5.2820687148E-01, 4.4978378830E-01, 6.4173836892E-01],
	[1.3835000000E+04, 6.5995560088E+00, 5.6020690855E+00, 5.2881094649E-01, 4.5023429666E-01, 6.4187605953E-01],
	[1.3840000000E+04, 6.6027929478E+00, 5.6016815265E+00, 5.2941549316E-01, 4.5068503563E-01, 6.4201372361E-01],
	[1.3845000000E+04, 6.6060303043E+00, 5.6012941342E+00, 5.3002051169E-01, 4.5113600514E-01, 6.4215136115E-01],
	[1.3850000000E+04, 6.6092680784E+00, 5.6009069086E+00, 5.3062600226E-01, 4.5158720512E-01, 6.4228897214E-01],
	[1.3855000000E+04, 6.6125062698E+00, 5.6005198495E+00, 5.3123196509E-01, 4.5203863547E-01, 6.4242655655E-01],
	[1.3860000000E+04, 6.6157448786E+00, 5.6001329568E+00, 5.3183840037E-01, 4.5249029614E-01, 6.4256411438E-01],
	[1.3865000000E+04, 6.6189839045E+00, 5.5997462303E+00, 5.3244530828E-01, 4.5294218702E-01, 6.4270164561E-01],
	[1.3870000000E+04, 6.6222233475E+00, 5.5993596700E+00, 5.3305268904E-01, 4.5339430806E-01, 6.4283915023E-01],
	[1.3875000000E+04, 6.6254632076E+00, 5.5989732757E+00, 5.3366054284E-01, 4.5384665917E-01, 6.4297662821E-01],
	[1.3880000000E+04, 6.6287034845E+00, 5.5985870473E+00, 5.3426886987E-01, 4.5429924027E-01, 6.4311407956E-01],
	[1.3885000000E+04, 6.6319441782E+00, 5.5982009846E+00, 5.3487767033E-01, 4.5475205128E-01, 6.4325150424E-01],
	[1.3890000000E+04, 6.6351852887E+00, 5.5978150874E+00, 5.3548694442E-01, 4.5520509212E-01, 6.4338890226E-01],
	[1.3895000000E+04, 6.6384268158E+00, 5.5974293558E+00, 5.3609669233E-01, 4.5565836272E-01, 6.4352627359E-01],
	[1.3900000000E+04, 6.6416767829E+00, 5.5970508085E+00, 5.3670691427E-01, 4.5611194745E-01, 6.4366361822E-01],
	[1.3905000000E+04, 6.6449273156E+00, 5.5966725490E+00, 5.3731761043E-01, 4.5656576357E-01, 6.4380093613E-01],
	[1.3910000000E+04, 6.6481782695E+00, 5.5962944509E+00, 5.3792878101E-01, 4.5701980949E-01, 6.4393822732E-01],
	[1.3915000000E+04, 6.6514296448E+00, 5.5959165143E+00, 5.3854042620E-01, 4.5747408512E-01, 6.4407549176E-01],
	[1.3920000000E+04, 6.6546814412E+00, 5.5955387390E+00, 5.3915254620E-01, 4.5792859040E-01, 6.4421272945E-01],
	[1.3925000000E+04, 6.6579336587E+00, 5.5951611248E+00, 5.3976514121E-01, 4.5838332523E-01, 6.4434994037E-01],
	[1.3930000000E+04, 6.6611862972E+00, 5.5947836717E+00, 5.4037821143E-01, 4.5883828954E-01, 6.4448712451E-01],
	[1.3935000000E+04, 6.6644393566E+00, 5.5944063794E+00, 5.4099175705E-01, 4.5929348326E-01, 6.4462428185E-01],
	[1.3940000000E+04, 6.6676928368E+00, 5.5940292480E+00, 5.4160577827E-01, 4.5974890629E-01, 6.4476141237E-01],
	[1.3945000000E+04, 6.6709467377E+00, 5.5936522772E+00, 5.4222027529E-01, 4.6020455856E-01, 6.4489851607E-01],
	[1.3950000000E+04, 6.6742010592E+00, 5.5932754669E+00, 5.4283524831E-01, 4.6066043999E-01, 6.4503559293E-01],
	[1.3955000000E+04, 6.6774558012E+00, 5.5928988171E+00, 5.4345069751E-01, 4.6111655051E-01, 6.4517264294E-01],
	[1.3960000000E+04, 6.6807109636E+00, 5.5925223275E+00, 5.4406662311E-01, 4.6157289002E-01, 6.4530966608E-01],
	[1.3965000000E+04, 6.6839665463E+00, 5.5921459981E+00, 5.4468302529E-01, 4.6202945845E-01, 6.4544666234E-01],
	[1.3970000000E+04, 6.6872225492E+00, 5.5917698287E+00, 5.4529990426E-01, 4.6248625572E-01, 6.4558363170E-01],
	[1.3975000000E+04, 6.6904789723E+00, 5.5913938191E+00, 5.4591726021E-01, 4.6294328174E-01, 6.4572057416E-01],
	[1.3980000000E+04, 6.6937358154E+00, 5.5910179694E+00, 5.4653509334E-01, 4.6340053644E-01, 6.4585748969E-01],
	[1.3985000000E+04, 6.6969930783E+00, 5.5906422793E+00, 5.4715340384E-01, 4.6385801973E-01, 6.4599437829E-01],
	[1.3990000000E+04, 6.7002507612E+00, 5.5902667488E+00, 5.4777219192E-01, 4.6431573154E-01, 6.4613123994E-01],
	[1.3995000000E+04, 6.7035088637E+00, 5.5898913776E+00, 5.4839145776E-01, 4.6477367177E-01, 6.4626807463E-01],
	[1.4000000000E+04, 6.7067673859E+00, 5.5895161658E+00, 5.4901120158E-01, 4.6523184036E-01, 6.4640488234E-01],
	[1.4005000000E+04, 6.7100263277E+00, 5.5891411130E+00, 5.4963142356E-01, 4.6569023721E-01, 6.4654166306E-01],
	[1.4010000000E+04, 6.7132856889E+00, 5.5887662193E+00, 5.5025212390E-01, 4.6614886225E-01, 6.4667841677E-01],
	[1.4015000000E+04, 6.7165454694E+00, 5.5883914846E+00, 5.5087330281E-01, 4.6660771539E-01, 6.4681514347E-01],
	[1.4020000000E+04, 6.7198056692E+00, 5.5880169085E+00, 5.5149496047E-01, 4.6706679656E-01, 6.4695184314E-01],
	[1.4025000000E+04, 6.7230662882E+00, 5.5876424912E+00, 5.5211709709E-01, 4.6752610566E-01, 6.4708851577E-01],
	[1.4030000000E+04, 6.7263273262E+00, 5.5872682324E+00, 5.5273971286E-01, 4.6798564261E-01, 6.4722516133E-01],
	[1.4035000000E+04, 6.7295887832E+00, 5.5868941319E+00, 5.5336280798E-01, 4.6844540734E-01, 6.4736177983E-01],
	[1.4040000000E+04, 6.7328506590E+00, 5.5865201898E+00, 5.5398638264E-01, 4.6890539976E-01, 6.4749837125E-01],
	[1.4045000000E+04, 6.7361129537E+00, 5.5861464059E+00, 5.5461043705E-01, 4.6936561979E-01, 6.4763493557E-01],
	[1.4050000000E+04, 6.7393756670E+00, 5.5857727799E+00, 5.5523497141E-01, 4.6982606734E-01, 6.4777147277E-01],
	[1.4055000000E+04, 6.7426387989E+00, 5.5853993119E+00, 5.5585998590E-01, 4.7028674233E-01, 6.4790798286E-01],
	[1.4060000000E+04, 6.7459023493E+00, 5.5850260017E+00, 5.5648548073E-01, 4.7074764468E-01, 6.4804446581E-01],
	[1.4065000000E+04, 6.7491663181E+00, 5.5846528491E+00, 5.5711145609E-01, 4.7120877430E-01, 6.4818092160E-01],
	[1.4070000000E+04, 6.7524307052E+00, 5.5842798541E+00, 5.5773791219E-01, 4.7167013111E-01, 6.4831735024E-01],
	[1.4075000000E+04, 6.7556955106E+00, 5.5839070166E+00, 5.5836484922E-01, 4.7213171503E-01, 6.4845375170E-01],
	[1.4080000000E+04, 6.7589607340E+00, 5.5835343363E+00, 5.5899226737E-01, 4.7259352597E-01, 6.4859012597E-01],
	[1.4085000000E+04, 6.7622263754E+00, 5.5831618132E+00, 5.5962016685E-01, 4.7305556384E-01, 6.4872647301E-01],
	[1.4090000000E+04, 6.7654924348E+00, 5.5827894472E+00, 5.6024854785E-01, 4.7351782857E-01, 6.4886279279E-01],
	[1.4095000000E+04, 6.7687589120E+00, 5.5824172381E+00, 5.6087741057E-01, 4.7398032007E-01, 6.4899908528E-01],
	[1.4100000000E+04, 6.7720258069E+00, 5.5820451858E+00, 5.6150675521E-01, 4.7444303824E-01, 6.4913535046E-01],
	[1.4105000000E+04, 6.7752931195E+00, 5.5816732902E+00, 5.6213658196E-01, 4.7490598302E-01, 6.4927158832E-01],
	[1.4110000000E+04, 6.7785608496E+00, 5.5813015512E+00, 5.6276689102E-01, 4.7536915431E-01, 6.4940779884E-01],
	[1.4115000000E+04, 6.7818289971E+00, 5.5809299686E+00, 5.6339768260E-01, 4.7583255203E-01, 6.4954398199E-01],
	[1.4120000000E+04, 6.7850996595E+00, 5.5805602499E+00, 5.6402895688E-01, 4.7629619887E-01, 6.4968013777E-01],
	[1.4125000000E+04, 6.7883772421E+00, 5.5801959770E+00, 5.6466071407E-01, 4.7676014272E-01, 6.4981626614E-01],
	[1.4130000000E+04, 6.7916552472E+00, 5.5798318568E+00, 5.6529295436E-01, 4.7722431305E-01, 6.4995236709E-01],
	[1.4135000000E+04, 6.7949336746E+00, 5.5794678891E+00, 5.6592567795E-01, 4.7768870975E-01, 6.5008844061E-01],
	[1.4140000000E+04, 6.7982125242E+00, 5.5791040739E+00, 5.6655888504E-01, 4.7815333276E-01, 6.5022448666E-01],
	[1.4145000000E+04, 6.8014917960E+00, 5.5787404111E+00, 5.6719257582E-01, 4.7861818198E-01, 6.5036050524E-01],
	[1.4150000000E+04, 6.8047714898E+00, 5.5783769004E+00, 5.6782675050E-01, 4.7908325732E-01, 6.5049649632E-01],
	[1.4155000000E+04, 6.8080516055E+00, 5.5780135419E+00, 5.6846140927E-01, 4.7954855871E-01, 6.5063245989E-01],
	[1.4160000000E+04, 6.8113321431E+00, 5.5776503353E+00, 5.6909655233E-01, 4.8001408605E-01, 6.5076839593E-01],
	[1.4165000000E+04, 6.8146131024E+00, 5.5772872806E+00, 5.6973217987E-01, 4.8047983926E-01, 6.5090430441E-01],
	[1.4170000000E+04, 6.8178944834E+00, 5.5769243777E+00, 5.7036829210E-01, 4.8094581825E-01, 6.5104018533E-01],
	[1.4175000000E+04, 6.8211762859E+00, 5.5765616264E+00, 5.7100488921E-01, 4.8141202294E-01, 6.5117603865E-01],
	[1.4180000000E+04, 6.8244585099E+00, 5.5761990266E+00, 5.7164197141E-01, 4.8187845324E-01, 6.5131186437E-01],
	[1.4185000000E+04, 6.8277411553E+00, 5.5758365782E+00, 5.7227953887E-01, 4.8234510906E-01, 6.5144766246E-01],
	[1.4190000000E+04, 6.8310242220E+00, 5.5754742810E+00, 5.7291759182E-01, 4.8281199032E-01, 6.5158343290E-01],
	[1.4195000000E+04, 6.8343077098E+00, 5.5751121351E+00, 5.7355613043E-01, 4.8327909693E-01, 6.5171917568E-01],
	[1.4200000000E+04, 6.8375916187E+00, 5.5747501402E+00, 5.7419515492E-01, 4.8374642880E-01, 6.5185489078E-01],
	[1.4205000000E+04, 6.8408759487E+00, 5.5743882962E+00, 5.7483466547E-01, 4.8421398585E-01, 6.5199057817E-01],
	[1.4210000000E+04, 6.8441606995E+00, 5.5740266030E+00, 5.7547466230E-01, 4.8468176798E-01, 6.5212623785E-01],
	[1.4215000000E+04, 6.8474458711E+00, 5.5736650606E+00, 5.7611514558E-01, 4.8514977511E-01, 6.5226186979E-01],
	[1.4220000000E+04, 6.8507314634E+00, 5.5733036687E+00, 5.7675611553E-01, 4.8561800715E-01, 6.5239747398E-01],
	[1.4225000000E+04, 6.8540174764E+00, 5.5729424273E+00, 5.7739757234E-01, 4.8608646402E-01, 6.5253305039E-01],
	[1.4230000000E+04, 6.8573039099E+00, 5.5725813362E+00, 5.7803951620E-01, 4.8655514563E-01, 6.5266859900E-01],
	[1.4235000000E+04, 6.8605907638E+00, 5.5722203954E+00, 5.7868194732E-01, 4.8702405188E-01, 6.5280411981E-01],
	[1.4240000000E+04, 6.8638780380E+00, 5.5718596047E+00, 5.7932486589E-01, 4.8749318269E-01, 6.5293961278E-01],
	[1.4245000000E+04, 6.8671657325E+00, 5.5714989641E+00, 5.7996827212E-01, 4.8796253797E-01, 6.5307507791E-01],
	[1.4250000000E+04, 6.8704538471E+00, 5.5711384733E+00, 5.8061216619E-01, 4.8843211764E-01, 6.5321051518E-01],
	[1.4255000000E+04, 6.8737423818E+00, 5.5707781323E+00, 5.8125654831E-01, 4.8890192160E-01, 6.5334592456E-01],
	[1.4260000000E+04, 6.8770313365E+00, 5.5704179409E+00, 5.8190141867E-01, 4.8937194976E-01, 6.5348130604E-01],
	[1.4265000000E+04, 6.8803207110E+00, 5.5700578991E+00, 5.8254677748E-01, 4.8984220204E-01, 6.5361665960E-01],
	[1.4270000000E+04, 6.8836105053E+00, 5.5696980068E+00, 5.8319262493E-01, 4.9031267834E-01, 6.5375198522E-01],
	[1.4275000000E+04, 6.8869007192E+00, 5.5693382637E+00, 5.8383896121E-01, 4.9078337859E-01, 6.5388728288E-01],
	[1.4280000000E+04, 6.8901913528E+00, 5.5689786699E+00, 5.8448578654E-01, 4.9125430268E-01, 6.5402255258E-01],
	[1.4285000000E+04, 6.8934824058E+00, 5.5686192251E+00, 5.8513310109E-01, 4.9172545053E-01, 6.5415779428E-01],
	[1.4290000000E+04, 6.8967738783E+00, 5.5682599294E+00, 5.8578090508E-01, 4.9219682204E-01, 6.5429300797E-01],
	[1.4295000000E+04, 6.9000657700E+00, 5.5679007825E+00, 5.8642919870E-01, 4.9266841714E-01, 6.5442819363E-01],
	[1.4300000000E+04, 6.9033580810E+00, 5.5675417843E+00, 5.8707798215E-01, 4.9314023572E-01, 6.5456335125E-01],
	[1.4305000000E+04, 6.9066508111E+00, 5.5671829348E+00, 5.8772725562E-01, 4.9361227771E-01, 6.5469848081E-01],
	[1.4310000000E+04, 6.9099439602E+00, 5.5668242338E+00, 5.8837701932E-01, 4.9408454300E-01, 6.5483358229E-01],
	[1.4315000000E+04, 6.9132375282E+00, 5.5664656812E+00, 5.8902727343E-01, 4.9455703150E-01, 6.5496865566E-01],
	[1.4320000000E+04, 6.9165315151E+00, 5.5661072769E+00, 5.8967801817E-01, 4.9502974314E-01, 6.5510370093E-01],
	[1.4325000000E+04, 6.9198259207E+00, 5.5657490208E+00, 5.9032925373E-01, 4.9550267781E-01, 6.5523871806E-01],
	[1.4330000000E+04, 6.9231207450E+00, 5.5653909128E+00, 5.9098098030E-01, 4.9597583542E-01, 6.5537370703E-01],
	[1.4335000000E+04, 6.9264159879E+00, 5.5650329527E+00, 5.9163319809E-01, 4.9644921589E-01, 6.5550866785E-01],
	[1.4340000000E+04, 6.9297116492E+00, 5.5646751405E+00, 5.9228590729E-01, 4.9692281912E-01, 6.5564360047E-01],
	[1.4345000000E+04, 6.9330077289E+00, 5.5643174760E+00, 5.9293910810E-01, 4.9739664502E-01, 6.5577850489E-01],
	[1.4350000000E+04, 6.9363113227E+00, 5.5639653423E+00, 5.9359280072E-01, 4.9787077317E-01, 6.5591338109E-01],
	[1.4355000000E+04, 6.9396172792E+00, 5.5636148247E+00, 5.9424698535E-01, 4.9834514585E-01, 6.5604822906E-01],
	[1.4360000000E+04, 6.9429236593E+00, 5.5632644512E+00, 5.9490166218E-01, 4.9881974125E-01, 6.5618304876E-01],
	[1.4365000000E+04, 6.9462304628E+00, 5.5629142218E+00, 5.9555683141E-01, 4.9929455927E-01, 6.5631784020E-01],
	[1.4370000000E+04, 6.9495376896E+00, 5.5625641362E+00, 5.9621249324E-01, 4.9976959981E-01, 6.5645260334E-01],
	[1.4375000000E+04, 6.9528453397E+00, 5.5622141945E+00, 5.9686864788E-01, 5.0024486279E-01, 6.5658733818E-01],
	[1.4380000000E+04, 6.9561534131E+00, 5.5618643965E+00, 5.9752529551E-01, 5.0072034812E-01, 6.5672204469E-01],
	[1.4385000000E+04, 6.9594619094E+00, 5.5615147420E+00, 5.9818243633E-01, 5.0119605569E-01, 6.5685672286E-01],
	[1.4390000000E+04, 6.9627708288E+00, 5.5611652311E+00, 5.9884007055E-01, 5.0167198543E-01, 6.5699137268E-01],
	[1.4395000000E+04, 6.9660801711E+00, 5.5608158635E+00, 5.9949819836E-01, 5.0214813724E-01, 6.5712599411E-01],
	[1.4400000000E+04, 6.9693899362E+00, 5.5604666392E+00, 6.0015681996E-01, 5.0262451102E-01, 6.5726058716E-01],
	[1.4405000000E+04, 6.9727001240E+00, 5.5601175580E+00, 6.0081593554E-01, 5.0310110668E-01, 6.5739515179E-01],
	[1.4410000000E+04, 6.9760107344E+00, 5.5597686199E+00, 6.0147554532E-01, 5.0357792413E-01, 6.5752968800E-01],
	[1.4415000000E+04, 6.9793217673E+00, 5.5594198248E+00, 6.0213564948E-01, 5.0405496328E-01, 6.5766419576E-01],
	[1.4420000000E+04, 6.9826332227E+00, 5.5590711724E+00, 6.0279624822E-01, 5.0453222404E-01, 6.5779867507E-01],
	[1.4425000000E+04, 6.9859451004E+00, 5.5587226628E+00, 6.0345734174E-01, 5.0500970631E-01, 6.5793312589E-01],
	[1.4430000000E+04, 6.9892574004E+00, 5.5583742958E+00, 6.0411893024E-01, 5.0548740999E-01, 6.5806754822E-01],
	[1.4435000000E+04, 6.9925701225E+00, 5.5580260713E+00, 6.0478101391E-01, 5.0596533500E-01, 6.5820194204E-01],
	[1.4440000000E+04, 6.9958832667E+00, 5.5576779893E+00, 6.0544359297E-01, 5.0644348124E-01, 6.5833630733E-01],
	[1.4445000000E+04, 6.9991968328E+00, 5.5573300495E+00, 6.0610666759E-01, 5.0692184862E-01, 6.5847064408E-01],
	[1.4450000000E+04, 7.0025108208E+00, 5.5569822519E+00, 6.0677023799E-01, 5.0740043704E-01, 6.5860495226E-01],
	[1.4455000000E+04, 7.0058252307E+00, 5.5566345964E+00, 6.0743430436E-01, 5.0787924641E-01, 6.5873923187E-01],
	[1.4460000000E+04, 7.0091400622E+00, 5.5562870828E+00, 6.0809886690E-01, 5.0835827663E-01, 6.5887348288E-01],
	[1.4465000000E+04, 7.0124553153E+00, 5.5559397111E+00, 6.0876392580E-01, 5.0883752762E-01, 6.5900770529E-01],
	[1.4470000000E+04, 7.0157709899E+00, 5.5555924812E+00, 6.0942948127E-01, 5.0931699927E-01, 6.5914189906E-01],
	[1.4475000000E+04, 7.0190870860E+00, 5.5552453929E+00, 6.1009553351E-01, 5.0979669150E-01, 6.5927606419E-01],
	[1.4480000000E+04, 7.0224036033E+00, 5.5548984462E+00, 6.1076208270E-01, 5.1027660420E-01, 6.5941020065E-01],
	[1.4485000000E+04, 7.0257205419E+00, 5.5545516409E+00, 6.1142912906E-01, 5.1075673729E-01, 6.5954430845E-01],
	[1.4490000000E+04, 7.0290379017E+00, 5.5542049770E+00, 6.1209667277E-01, 5.1123709066E-01, 6.5967838754E-01],
	[1.4495000000E+04, 7.0323556824E+00, 5.5538584542E+00, 6.1276471404E-01, 5.1171766422E-01, 6.5981243793E-01],
	[1.4500000000E+04, 7.0356738842E+00, 5.5535120726E+00, 6.1343325307E-01, 5.1219845789E-01, 6.5994645959E-01],
	[1.4505000000E+04, 7.0389925068E+00, 5.5531658320E+00, 6.1410229005E-01, 5.1267947155E-01, 6.6008045251E-01],
	[1.4510000000E+04, 7.0423115502E+00, 5.5528197323E+00, 6.1477182518E-01, 5.1316070512E-01, 6.6021441666E-01],
	[1.4515000000E+04, 7.0456310143E+00, 5.5524737734E+00, 6.1544185866E-01, 5.1364215851E-01, 6.6034835205E-01],
	[1.4520000000E+04, 7.0489508989E+00, 5.5521279553E+00, 6.1611239069E-01, 5.1412383160E-01, 6.6048225864E-01],
	[1.4525000000E+04, 7.0522712041E+00, 5.5517822776E+00, 6.1678342147E-01, 5.1460572432E-01, 6.6061613642E-01],
	[1.4530000000E+04, 7.0555919297E+00, 5.5514367405E+00, 6.1745495120E-01, 5.1508783656E-01, 6.6074998538E-01],
	[1.4535000000E+04, 7.0589130756E+00, 5.5510913438E+00, 6.1812698007E-01, 5.1557016823E-01, 6.6088380550E-01],
	[1.4540000000E+04, 7.0622346417E+00, 5.5507460873E+00, 6.1879950828E-01, 5.1605271922E-01, 6.6101759677E-01],
	[1.4545000000E+04, 7.0655566279E+00, 5.5504009710E+00, 6.1947253603E-01, 5.1653548945E-01, 6.6115135916E-01],
	[1.4550000000E+04, 7.0688790342E+00, 5.5500559948E+00, 6.2014606353E-01, 5.1701847882E-01, 6.6128509266E-01],
	[1.4555000000E+04, 7.0722018605E+00, 5.5497111585E+00, 6.2082009096E-01, 5.1750168723E-01, 6.6141879726E-01],
	[1.4560000000E+04, 7.0755251066E+00, 5.5493664621E+00, 6.2149461853E-01, 5.1798511458E-01, 6.6155247294E-01],
	[1.4565000000E+04, 7.0788487724E+00, 5.5490219054E+00, 6.2216964643E-01, 5.1846876078E-01, 6.6168611968E-01],
	[1.4570000000E+04, 7.0821728580E+00, 5.5486774884E+00, 6.2284517487E-01, 5.1895262573E-01, 6.6181973748E-01],
	[1.4575000000E+04, 7.0854973631E+00, 5.5483332109E+00, 6.2352120404E-01, 5.1943670933E-01, 6.6195332630E-01],
	[1.4580000000E+04, 7.0888279256E+00, 5.5479930673E+00, 6.2419773414E-01, 5.1992107689E-01, 6.6208688614E-01],
	[1.4585000000E+04, 7.0921627512E+00, 5.5476557806E+00, 6.2487476536E-01, 5.2040570771E-01, 6.6222041699E-01],
	[1.4590000000E+04, 7.0954980018E+00, 5.5473186301E+00, 6.2555229792E-01, 5.2089055723E-01, 6.6235391881E-01],
	[1.4595000000E+04, 7.0988336773E+00, 5.5469816156E+00, 6.2623033201E-01, 5.2137562534E-01, 6.6248739161E-01],
	[1.4600000000E+04, 7.1021697776E+00, 5.5466447370E+00, 6.2690886781E-01, 5.2186091194E-01, 6.6262083536E-01],
	[1.4605000000E+04, 7.1055063025E+00, 5.5463079942E+00, 6.2758790555E-01, 5.2234641695E-01, 6.6275425005E-01],
	[1.4610000000E+04, 7.1088432521E+00, 5.5459713870E+00, 6.2826744540E-01, 5.2283214025E-01, 6.6288763566E-01],
	[1.4615000000E+04, 7.1121806262E+00, 5.5456349155E+00, 6.2894748758E-01, 5.2331808176E-01, 6.6302099218E-01],
	[1.4620000000E+04, 7.1155184247E+00, 5.5452985795E+00, 6.2962803227E-01, 5.2380424137E-01, 6.6315431959E-01],
	[1.4625000000E+04, 7.1188566475E+00, 5.5449623788E+00, 6.3030907968E-01, 5.2429061899E-01, 6.6328761788E-01],
	[1.4630000000E+04, 7.1221952945E+00, 5.5446263135E+00, 6.3099063001E-01, 5.2477721452E-01, 6.6342088703E-01],
	[1.4635000000E+04, 7.1255343657E+00, 5.5442903833E+00, 6.3167268346E-01, 5.2526402786E-01, 6.6355412702E-01],
	[1.4640000000E+04, 7.1288738610E+00, 5.5439545883E+00, 6.3235524022E-01, 5.2575105891E-01, 6.6368733785E-01],
	[1.4645000000E+04, 7.1322137802E+00, 5.5436189282E+00, 6.3303830049E-01, 5.2623830757E-01, 6.6382051948E-01],
	[1.4650000000E+04, 7.1355541233E+00, 5.5432834030E+00, 6.3372186447E-01, 5.2672577374E-01, 6.6395367192E-01],
	[1.4655000000E+04, 7.1388948902E+00, 5.5429480126E+00, 6.3440593237E-01, 5.2721345733E-01, 6.6408679514E-01],
	[1.4660000000E+04, 7.1422360807E+00, 5.5426127569E+00, 6.3509050437E-01, 5.2770135824E-01, 6.6421988913E-01],
	[1.4665000000E+04, 7.1455776949E+00, 5.5422776358E+00, 6.3577558068E-01, 5.2818947636E-01, 6.6435295388E-01],
	[1.4670000000E+04, 7.1489197325E+00, 5.5419426492E+00, 6.3646116150E-01, 5.2867781160E-01, 6.6448598936E-01],
	[1.4675000000E+04, 7.1522621936E+00, 5.5416077970E+00, 6.3714724702E-01, 5.2916636386E-01, 6.6461899556E-01],
	[1.4680000000E+04, 7.1556050780E+00, 5.5412730791E+00, 6.3783383744E-01, 5.2965513303E-01, 6.6475197248E-01],
	[1.4685000000E+04, 7.1589483857E+00, 5.5409384953E+00, 6.3852093297E-01, 5.3014411902E-01, 6.6488492008E-01],
	[1.4690000000E+04, 7.1622921165E+00, 5.5406040457E+00, 6.3920853380E-01, 5.3063332173E-01, 6.6501783837E-01],
	[1.4695000000E+04, 7.1656362703E+00, 5.5402697300E+00, 6.3989664012E-01, 5.3112274106E-01, 6.6515072732E-01],
	[1.4700000000E+04, 7.1689808471E+00, 5.5399355483E+00, 6.4058525215E-01, 5.3161237690E-01, 6.6528358691E-01],
	[1.4705000000E+04, 7.1723258468E+00, 5.5396015003E+00, 6.4127437008E-01, 5.3210222916E-01, 6.6541641714E-01],
	[1.4710000000E+04, 7.1756712693E+00, 5.5392675861E+00, 6.4196399410E-01, 5.3259229774E-01, 6.6554921799E-01],
	[1.4715000000E+04, 7.1790171145E+00, 5.5389338054E+00, 6.4265412441E-01, 5.3308258253E-01, 6.6568198944E-01],
	[1.4720000000E+04, 7.1823633822E+00, 5.5386001582E+00, 6.4334476122E-01, 5.3357308344E-01, 6.6581473148E-01],
	[1.4725000000E+04, 7.1857100725E+00, 5.5382666444E+00, 6.4403590473E-01, 5.3406380036E-01, 6.6594744409E-01],
	[1.4730000000E+04, 7.1890571852E+00, 5.5379332640E+00, 6.4472755512E-01, 5.3455473319E-01, 6.6608012727E-01],
	[1.4735000000E+04, 7.1924047203E+00, 5.5376000167E+00, 6.4541971261E-01, 5.3504588184E-01, 6.6621278098E-01],
	[1.4740000000E+04, 7.1957526775E+00, 5.5372669025E+00, 6.4611237738E-01, 5.3553724620E-01, 6.6634540523E-01],
	[1.4745000000E+04, 7.1991010570E+00, 5.5369339214E+00, 6.4680554964E-01, 5.3602882616E-01, 6.6647799999E-01],
	[1.4750000000E+04, 7.2024498585E+00, 5.5366010731E+00, 6.4749922959E-01, 5.3652062164E-01, 6.6661056525E-01],
	[1.4755000000E+04, 7.2057990819E+00, 5.5362683577E+00, 6.4819341743E-01, 5.3701263252E-01, 6.6674310100E-01],
	[1.4760000000E+04, 7.2091487273E+00, 5.5359357750E+00, 6.4888811335E-01, 5.3750485870E-01, 6.6687560722E-01],
	[1.4765000000E+04, 7.2124987945E+00, 5.5356033248E+00, 6.4958331755E-01, 5.3799730008E-01, 6.6700808390E-01],
	[1.4770000000E+04, 7.2158492833E+00, 5.5352710072E+00, 6.5027903024E-01, 5.3848995657E-01, 6.6714053101E-01],
	[1.4775000000E+04, 7.2192001938E+00, 5.5349388221E+00, 6.5097525161E-01, 5.3898282805E-01, 6.6727294856E-01],
	[1.4780000000E+04, 7.2225515258E+00, 5.5346067692E+00, 6.5167198186E-01, 5.3947591443E-01, 6.6740533652E-01],
	[1.4785000000E+04, 7.2259032792E+00, 5.5342748486E+00, 6.5236922119E-01, 5.3996921560E-01, 6.6753769488E-01],
	[1.4790000000E+04, 7.2292554540E+00, 5.5339430601E+00, 6.5306696979E-01, 5.4046273146E-01, 6.6767002362E-01],
	[1.4795000000E+04, 7.2326080500E+00, 5.5336114036E+00, 6.5376522788E-01, 5.4095646190E-01, 6.6780232273E-01],
	[1.4800000000E+04, 7.2359610672E+00, 5.5332798790E+00, 6.5446399564E-01, 5.4145040683E-01, 6.6793459220E-01],
	[1.4805000000E+04, 7.2393145055E+00, 5.5329484863E+00, 6.5516327328E-01, 5.4194456615E-01, 6.6806683201E-01],
	[1.4810000000E+04, 7.2426683647E+00, 5.5326172253E+00, 6.5586306099E-01, 5.4243893974E-01, 6.6819904215E-01],
	[1.4815000000E+04, 7.2460292037E+00, 5.5322904426E+00, 6.5656335897E-01, 5.4293360619E-01, 6.6833122260E-01],
	[1.4820000000E+04, 7.2493938345E+00, 5.5319660196E+00, 6.5726416743E-01, 5.4342852738E-01, 6.6846337335E-01],
	[1.4825000000E+04, 7.2527588919E+00, 5.5316417252E+00, 6.5796548656E-01, 5.4392366289E-01, 6.6859549438E-01],
	[1.4830000000E+04, 7.2561243757E+00, 5.5313175591E+00, 6.5866731656E-01, 5.4441901262E-01, 6.6872758569E-01],
	[1.4835000000E+04, 7.2594902860E+00, 5.5309935213E+00, 6.5936965763E-01, 5.4491457646E-01, 6.6885964725E-01],
	[1.4840000000E+04, 7.2628566225E+00, 5.5306696116E+00, 6.6007250996E-01, 5.4541035431E-01, 6.6899167906E-01],
	[1.4845000000E+04, 7.2662233853E+00, 5.5303458300E+00, 6.6077587377E-01, 5.4590634606E-01, 6.6912368109E-01],
	[1.4850000000E+04, 7.2695905742E+00, 5.5300221764E+00, 6.6147974924E-01, 5.4640255161E-01, 6.6925565334E-01],
	[1.4855000000E+04, 7.2729581891E+00, 5.5296986507E+00, 6.6218413658E-01, 5.4689897086E-01, 6.6938759579E-01],
	[1.4860000000E+04, 7.2763262300E+00, 5.5293752528E+00, 6.6288903598E-01, 5.4739560370E-01, 6.6951950843E-01],
	[1.4865000000E+04, 7.2796946967E+00, 5.5290519825E+00, 6.6359444765E-01, 5.4789245002E-01, 6.6965139124E-01],
	[1.4870000000E+04, 7.2830635892E+00, 5.5287288399E+00, 6.6430037178E-01, 5.4838950974E-01, 6.6978324421E-01],
	[1.4875000000E+04, 7.2864329074E+00, 5.5284058248E+00, 6.6500680857E-01, 5.4888678273E-01, 6.6991506732E-01],
	[1.4880000000E+04, 7.2898026512E+00, 5.5280829371E+00, 6.6571375822E-01, 5.4938426889E-01, 6.7004686057E-01],
	[1.4885000000E+04, 7.2931728204E+00, 5.5277601768E+00, 6.6642122094E-01, 5.4988196813E-01, 6.7017862394E-01],
	[1.4890000000E+04, 7.2965434151E+00, 5.5274375437E+00, 6.6712919691E-01, 5.5037988033E-01, 6.7031035740E-01],
	[1.4895000000E+04, 7.2999144351E+00, 5.5271150377E+00, 6.6783768634E-01, 5.5087800540E-01, 6.7044206096E-01],
	[1.4900000000E+04, 7.3032858803E+00, 5.5267926587E+00, 6.6854668944E-01, 5.5137634322E-01, 6.7057373460E-01],
	[1.4905000000E+04, 7.3066577507E+00, 5.5264704068E+00, 6.6925620638E-01, 5.5187489369E-01, 6.7070537830E-01],
	[1.4910000000E+04, 7.3100300461E+00, 5.5261482817E+00, 6.6996623739E-01, 5.5237365670E-01, 6.7083699205E-01],
	[1.4915000000E+04, 7.3134027664E+00, 5.5258262833E+00, 6.7067678265E-01, 5.5287263216E-01, 6.7096857584E-01],
	[1.4920000000E+04, 7.3167759117E+00, 5.5255044117E+00, 6.7138784236E-01, 5.5337181994E-01, 6.7110012965E-01],
	[1.4925000000E+04, 7.3201494817E+00, 5.5251826666E+00, 6.7209941673E-01, 5.5387121996E-01, 6.7123165347E-01],
	[1.4930000000E+04, 7.3235234765E+00, 5.5248610480E+00, 6.7281150596E-01, 5.5437083210E-01, 6.7136314728E-01],
	[1.4935000000E+04, 7.3268978958E+00, 5.5245395558E+00, 6.7352411023E-01, 5.5487065626E-01, 6.7149461108E-01],
	[1.4940000000E+04, 7.3302727396E+00, 5.5242181900E+00, 6.7423722976E-01, 5.5537069232E-01, 6.7162604485E-01],
	[1.4945000000E+04, 7.3336480079E+00, 5.5238969503E+00, 6.7495086474E-01, 5.5587094019E-01, 6.7175744857E-01],
	[1.4950000000E+04, 7.3370237006E+00, 5.5235758368E+00, 6.7566501537E-01, 5.5637139976E-01, 6.7188882224E-01],
	[1.4955000000E+04, 7.3403998174E+00, 5.5232548493E+00, 6.7637968185E-01, 5.5687207092E-01, 6.7202016583E-01],
	[1.4960000000E+04, 7.3437763585E+00, 5.5229339878E+00, 6.7709486438E-01, 5.5737295356E-01, 6.7215147934E-01],
	[1.4965000000E+04, 7.3471533236E+00, 5.5226132521E+00, 6.7781056315E-01, 5.5787404759E-01, 6.7228276275E-01],
	[1.4970000000E+04, 7.3505307127E+00, 5.5222926422E+00, 6.7852677838E-01, 5.5837535288E-01, 6.7241401606E-01],
	[1.4975000000E+04, 7.3539085257E+00, 5.5219721579E+00, 6.7924351025E-01, 5.5887686934E-01, 6.7254523924E-01],
	[1.4980000000E+04, 7.3572867626E+00, 5.5216517993E+00, 6.7996075896E-01, 5.5937859685E-01, 6.7267643228E-01],
	[1.4985000000E+04, 7.3606654231E+00, 5.5213315661E+00, 6.8067852473E-01, 5.5988053532E-01, 6.7280759517E-01],
	[1.4990000000E+04, 7.3640445073E+00, 5.5210114583E+00, 6.8139680773E-01, 5.6038268462E-01, 6.7293872790E-01],
	[1.4995000000E+04, 7.3674240150E+00, 5.5206914758E+00, 6.8211560819E-01, 5.6088504466E-01, 6.7306983046E-01],
	[1.5000000000E+04, 7.3708039462E+00, 5.5203716185E+00, 6.8283492628E-01, 5.6138761533E-01, 6.7320090282E-01],
	[1.5005000000E+04, 7.3741843007E+00, 5.5200518864E+00, 6.8355695688E-01, 5.6189187946E-01, 6.7333194499E-01],
	[1.5010000000E+04, 7.3775650786E+00, 5.5197322792E+00, 6.8427950949E-01, 5.6239635573E-01, 6.7346295693E-01],
	[1.5015000000E+04, 7.3809462796E+00, 5.5194127971E+00, 6.8500258430E-01, 5.6290104404E-01, 6.7359393866E-01],
	[1.5020000000E+04, 7.3843279037E+00, 5.5190934398E+00, 6.8572618152E-01, 5.6340594428E-01, 6.7372489014E-01],
	[1.5025000000E+04, 7.3877099509E+00, 5.5187742072E+00, 6.8645030134E-01, 5.6391105634E-01, 6.7385581137E-01],
	[1.5030000000E+04, 7.3910924209E+00, 5.5184550993E+00, 6.8717494399E-01, 5.6441638010E-01, 6.7398670233E-01],
	[1.5035000000E+04, 7.3944753139E+00, 5.5181361160E+00, 6.8790010965E-01, 5.6492191547E-01, 6.7411756301E-01],
	[1.5040000000E+04, 7.3978586295E+00, 5.5178172572E+00, 6.8862579852E-01, 5.6542766232E-01, 6.7424839340E-01],
	[1.5045000000E+04, 7.4012423679E+00, 5.5174985228E+00, 6.8935201082E-01, 5.6593362056E-01, 6.7437919349E-01],
	[1.5050000000E+04, 7.4046265288E+00, 5.5171799127E+00, 6.9007874675E-01, 5.6643979008E-01, 6.7450996326E-01],
	[1.5055000000E+04, 7.4080211959E+00, 5.5168676910E+00, 6.9080600650E-01, 5.6694629597E-01, 6.7464070270E-01],
	[1.5060000000E+04, 7.4114165904E+00, 5.5165557763E+00, 6.9153379028E-01, 5.6745301699E-01, 6.7477141177E-01],
	[1.5065000000E+04, 7.4148124132E+00, 5.5162439827E+00, 6.9226209830E-01, 5.6795994932E-01, 6.7490209046E-01],
	[1.5070000000E+04, 7.4182086643E+00, 5.5159323102E+00, 6.9299093075E-01, 5.6846709286E-01, 6.7503273875E-01],
	[1.5075000000E+04, 7.4216053436E+00, 5.5156207588E+00, 6.9372028784E-01, 5.6897444749E-01, 6.7516335663E-01],
	[1.5080000000E+04, 7.4250024510E+00, 5.5153093282E+00, 6.9445016977E-01, 5.6948201311E-01, 6.7529394407E-01],
	[1.5085000000E+04, 7.4283999864E+00, 5.5149980184E+00, 6.9518057675E-01, 5.6998978960E-01, 6.7542450106E-01],
	[1.5090000000E+04, 7.4317979497E+00, 5.5146868294E+00, 6.9591150897E-01, 5.7049777686E-01, 6.7555502759E-01],
	[1.5095000000E+04, 7.4351963409E+00, 5.5143757610E+00, 6.9664296665E-01, 5.7100597478E-01, 6.7568552364E-01],
	[1.5100000000E+04, 7.4385951598E+00, 5.5140648132E+00, 6.9737494997E-01, 5.7151438324E-01, 6.7581598919E-01],
	[1.5105000000E+04, 7.4419944064E+00, 5.5137539859E+00, 6.9810745916E-01, 5.7202300213E-01, 6.7594642422E-01],
	[1.5110000000E+04, 7.4453940806E+00, 5.5134432789E+00, 6.9884049440E-01, 5.7253183135E-01, 6.7607682872E-01],
	[1.5115000000E+04, 7.4487941822E+00, 5.5131326923E+00, 6.9957405591E-01, 5.7304087078E-01, 6.7620720268E-01],
	[1.5120000000E+04, 7.4521947113E+00, 5.5128222258E+00, 7.0030814388E-01, 5.7355012031E-01, 6.7633754607E-01],
	[1.5125000000E+04, 7.4555956677E+00, 5.5125118795E+00, 7.0104275851E-01, 5.7405957984E-01, 6.7646785888E-01],
	[1.5130000000E+04, 7.4589970513E+00, 5.5122016532E+00, 7.0177790002E-01, 5.7456924924E-01, 6.7659814110E-01],
	[1.5135000000E+04, 7.4623988620E+00, 5.5118915469E+00, 7.0251356860E-01, 5.7507912842E-01, 6.7672839270E-01],
	[1.5140000000E+04, 7.4658010998E+00, 5.5115815604E+00, 7.0324976446E-01, 5.7558921726E-01, 6.7685861367E-01],
	[1.5145000000E+04, 7.4692037646E+00, 5.5112716937E+00, 7.0398648780E-01, 5.7609951564E-01, 6.7698880400E-01],
	[1.5150000000E+04, 7.4726068562E+00, 5.5109619467E+00, 7.0472373882E-01, 5.7661002345E-01, 6.7711896367E-01],
	[1.5155000000E+04, 7.4760103747E+00, 5.5106523193E+00, 7.0546151773E-01, 5.7712074059E-01, 6.7724909266E-01],
	[1.5160000000E+04, 7.4794143198E+00, 5.5103428115E+00, 7.0619982473E-01, 5.7763166695E-01, 6.7737919096E-01],
	[1.5165000000E+04, 7.4828186915E+00, 5.5100334230E+00, 7.0693866002E-01, 5.7814280240E-01, 6.7750925855E-01],
	[1.5170000000E+04, 7.4862234898E+00, 5.5097241540E+00, 7.0767802380E-01, 5.7865414684E-01, 6.7763929542E-01],
	[1.5175000000E+04, 7.4896287145E+00, 5.5094150042E+00, 7.0841791628E-01, 5.7916570016E-01, 6.7776930154E-01],
	[1.5180000000E+04, 7.4930343656E+00, 5.5091059736E+00, 7.0915833766E-01, 5.7967746224E-01, 6.7789927691E-01],
	[1.5185000000E+04, 7.4964404429E+00, 5.5087970621E+00, 7.0989928815E-01, 5.8018943297E-01, 6.7802922150E-01],
	[1.5190000000E+04, 7.4998469465E+00, 5.5084882695E+00, 7.1064076794E-01, 5.8070161224E-01, 6.7815913531E-01],
	[1.5195000000E+04, 7.5032538761E+00, 5.5081795960E+00, 7.1138277725E-01, 5.8121399994E-01, 6.7828901832E-01],
	[1.5200000000E+04, 7.5066612317E+00, 5.5078710412E+00, 7.1212531627E-01, 5.8172659595E-01, 6.7841887050E-01],
	[1.5205000000E+04, 7.5100690132E+00, 5.5075626053E+00, 7.1286838520E-01, 5.8223940016E-01, 6.7854869185E-01],
	[1.5210000000E+04, 7.5134772206E+00, 5.5072542879E+00, 7.1361198425E-01, 5.8275241245E-01, 6.7867848235E-01],
	[1.5215000000E+04, 7.5168858537E+00, 5.5069460892E+00, 7.1435611363E-01, 5.8326563272E-01, 6.7880824198E-01],
	[1.5220000000E+04, 7.5202949124E+00, 5.5066380090E+00, 7.1510077353E-01, 5.8377906086E-01, 6.7893797073E-01],
	[1.5225000000E+04, 7.5237043968E+00, 5.5063300472E+00, 7.1584596417E-01, 5.8429269673E-01, 6.7906766858E-01],
	[1.5230000000E+04, 7.5271143066E+00, 5.5060222038E+00, 7.1659168573E-01, 5.8480654025E-01, 6.7919733552E-01],
	[1.5235000000E+04, 7.5305246418E+00, 5.5057144786E+00, 7.1733793843E-01, 5.8532059128E-01, 6.7932697153E-01],
	[1.5240000000E+04, 7.5339354023E+00, 5.5054068715E+00, 7.1808472247E-01, 5.8583484972E-01, 6.7945657659E-01],
	[1.5245000000E+04, 7.5373465881E+00, 5.5050993826E+00, 7.1883203805E-01, 5.8634931545E-01, 6.7958615070E-01],
	[1.5250000000E+04, 7.5407581990E+00, 5.5047920116E+00, 7.1957988538E-01, 5.8686398836E-01, 6.7971569383E-01],
	[1.5255000000E+04, 7.5441702349E+00, 5.5044847585E+00, 7.2032826465E-01, 5.8737886834E-01, 6.7984520598E-01],
	[1.5260000000E+04, 7.5475826959E+00, 5.5041776233E+00, 7.2107717608E-01, 5.8789395526E-01, 6.7997468711E-01],
	[1.5265000000E+04, 7.5509955817E+00, 5.5038706058E+00, 7.2182661986E-01, 5.8840924902E-01, 6.8010413723E-01],
	[1.5270000000E+04, 7.5544088922E+00, 5.5035637060E+00, 7.2257659620E-01, 5.8892474950E-01, 6.8023355631E-01],
	[1.5275000000E+04, 7.5578226275E+00, 5.5032569238E+00, 7.2332710530E-01, 5.8944045659E-01, 6.8036294434E-01],
	[1.5280000000E+04, 7.5612367874E+00, 5.5029502591E+00, 7.2407814736E-01, 5.8995637017E-01, 6.8049230130E-01],
	[1.5285000000E+04, 7.5646513719E+00, 5.5026437118E+00, 7.2482972260E-01, 5.9047249012E-01, 6.8062162719E-01],
	[1.5290000000E+04, 7.5680663808E+00, 5.5023372818E+00, 7.2558183120E-01, 5.9098881634E-01, 6.8075092197E-01],
	[1.5295000000E+04, 7.5714873899E+00, 5.5020342273E+00, 7.2633447338E-01, 5.9150542039E-01, 6.8088018565E-01],
	[1.5300000000E+04, 7.5749141034E+00, 5.5017343706E+00, 7.2708764934E-01, 5.9202229860E-01, 6.8100941820E-01],
	[1.5305000000E+04, 7.5783412474E+00, 5.5014346283E+00, 7.2784135928E-01, 5.9253938311E-01, 6.8113861961E-01],
	[1.5310000000E+04, 7.5817688218E+00, 5.5011350001E+00, 7.2859560340E-01, 5.9305667381E-01, 6.8126778986E-01],
	[1.5315000000E+04, 7.5851968265E+00, 5.5008354861E+00, 7.2935038191E-01, 5.9357417059E-01, 6.8139692894E-01],
	[1.5320000000E+04, 7.5886252613E+00, 5.5005360862E+00, 7.3010569501E-01, 5.9409187333E-01, 6.8152603684E-01],
	[1.5325000000E+04, 7.5920541262E+00, 5.5002368003E+00, 7.3086154291E-01, 5.9460978191E-01, 6.8165511353E-01],
	[1.5330000000E+04, 7.5954834212E+00, 5.4999376283E+00, 7.3161792581E-01, 5.9512789622E-01, 6.8178415901E-01],
	[1.5335000000E+04, 7.5989131460E+00, 5.4996385701E+00, 7.3237484390E-01, 5.9564621615E-01, 6.8191317326E-01],
	[1.5340000000E+04, 7.6023433008E+00, 5.4993396256E+00, 7.3313229741E-01, 5.9616474158E-01, 6.8204215627E-01],
	[1.5345000000E+04, 7.6057738852E+00, 5.4990407948E+00, 7.3389028652E-01, 5.9668347239E-01, 6.8217110801E-01],
	[1.5350000000E+04, 7.6092048994E+00, 5.4987420776E+00, 7.3464881144E-01, 5.9720240847E-01, 6.8230002848E-01],
	[1.5355000000E+04, 7.6126363431E+00, 5.4984434739E+00, 7.3540787238E-01, 5.9772154970E-01, 6.8242891767E-01],
	[1.5360000000E+04, 7.6160682163E+00, 5.4981449837E+00, 7.3616746953E-01, 5.9824089596E-01, 6.8255777555E-01],
	[1.5365000000E+04, 7.6195005190E+00, 5.4978466067E+00, 7.3692760311E-01, 5.9876044715E-01, 6.8268660211E-01],
	[1.5370000000E+04, 7.6229332509E+00, 5.4975483431E+00, 7.3768827331E-01, 5.9928020313E-01, 6.8281539734E-01],
	[1.5375000000E+04, 7.6263664122E+00, 5.4972501926E+00, 7.3844948035E-01, 5.9980016380E-01, 6.8294416122E-01],
	[1.5380000000E+04, 7.6298000025E+00, 5.4969521552E+00, 7.3921122441E-01, 6.0032032904E-01, 6.8307289374E-01],
	[1.5385000000E+04, 7.6332340219E+00, 5.4966542309E+00, 7.3997350571E-01, 6.0084069873E-01, 6.8320159489E-01],
	[1.5390000000E+04, 7.6366684704E+00, 5.4963564195E+00, 7.4073632445E-01, 6.0136127275E-01, 6.8333026465E-01],
	[1.5395000000E+04, 7.6401033477E+00, 5.4960587210E+00, 7.4149968084E-01, 6.0188205099E-01, 6.8345890300E-01],
	[1.5400000000E+04, 7.6435386538E+00, 5.4957611352E+00, 7.4226357507E-01, 6.0240303333E-01, 6.8358750993E-01],
	[1.5405000000E+04, 7.6469743886E+00, 5.4954636622E+00, 7.4302800735E-01, 6.0292421966E-01, 6.8371608544E-01],
	[1.5410000000E+04, 7.6504105521E+00, 5.4951663018E+00, 7.4379297788E-01, 6.0344560985E-01, 6.8384462949E-01],
	[1.5415000000E+04, 7.6538471442E+00, 5.4948690539E+00, 7.4455848687E-01, 6.0396720379E-01, 6.8397314209E-01],
	[1.5420000000E+04, 7.6572841647E+00, 5.4945719185E+00, 7.4532453453E-01, 6.0448900136E-01, 6.8410162321E-01],
	[1.5425000000E+04, 7.6607216136E+00, 5.4942748955E+00, 7.4609112104E-01, 6.0501100244E-01, 6.8423007284E-01],
	[1.5430000000E+04, 7.6641594908E+00, 5.4939779849E+00, 7.4685824663E-01, 6.0553320692E-01, 6.8435849096E-01],
	[1.5435000000E+04, 7.6675977962E+00, 5.4936811864E+00, 7.4762591149E-01, 6.0605561467E-01, 6.8448687757E-01],
	[1.5440000000E+04, 7.6710365297E+00, 5.4933845001E+00, 7.4839411582E-01, 6.0657822559E-01, 6.8461523265E-01],
	[1.5445000000E+04, 7.6744756913E+00, 5.4930879259E+00, 7.4916285983E-01, 6.0710103954E-01, 6.8474355618E-01],
	[1.5450000000E+04, 7.6779152808E+00, 5.4927914637E+00, 7.4993214372E-01, 6.0762405642E-01, 6.8487184816E-01],
	[1.5455000000E+04, 7.6813552982E+00, 5.4924951134E+00, 7.5070196770E-01, 6.0814727609E-01, 6.8500010856E-01],
	[1.5460000000E+04, 7.6847957434E+00, 5.4921988749E+00, 7.5147233197E-01, 6.0867069846E-01, 6.8512833737E-01],
	[1.5465000000E+04, 7.6882366162E+00, 5.4919027482E+00, 7.5224323673E-01, 6.0919432339E-01, 6.8525653459E-01],
	[1.5470000000E+04, 7.6916779167E+00, 5.4916067332E+00, 7.5301468220E-01, 6.0971815076E-01, 6.8538470019E-01],
	[1.5475000000E+04, 7.6951196448E+00, 5.4913108298E+00, 7.5378666856E-01, 6.1024218047E-01, 6.8551283416E-01],
	[1.5480000000E+04, 7.6985618002E+00, 5.4910150379E+00, 7.5455919602E-01, 6.1076641238E-01, 6.8564093649E-01],
	[1.5485000000E+04, 7.7020043831E+00, 5.4907193575E+00, 7.5533226480E-01, 6.1129084638E-01, 6.8576900716E-01],
	[1.5490000000E+04, 7.7054473932E+00, 5.4904237885E+00, 7.5610587508E-01, 6.1181548236E-01, 6.8589704617E-01],
	[1.5495000000E+04, 7.7088908305E+00, 5.4901283307E+00, 7.5688002708E-01, 6.1234032018E-01, 6.8602505349E-01],
	[1.5500000000E+04, 7.7123346949E+00, 5.4898329842E+00, 7.5765472101E-01, 6.1286535974E-01, 6.8615302912E-01],
	[1.5505000000E+04, 7.7157789863E+00, 5.4895377487E+00, 7.5842995705E-01, 6.1339060090E-01, 6.8628097303E-01],
	[1.5510000000E+04, 7.7192237046E+00, 5.4892426244E+00, 7.5920573542E-01, 6.1391604356E-01, 6.8640888522E-01],
	[1.5515000000E+04, 7.7226688498E+00, 5.4889476110E+00, 7.5998205633E-01, 6.1444168759E-01, 6.8653676568E-01],
	[1.5520000000E+04, 7.7261144218E+00, 5.4886527086E+00, 7.6075891996E-01, 6.1496753288E-01, 6.8666461438E-01],
	[1.5525000000E+04, 7.7295604205E+00, 5.4883579169E+00, 7.6153632654E-01, 6.1549357929E-01, 6.8679243133E-01],
	[1.5530000000E+04, 7.7330068457E+00, 5.4880632361E+00, 7.6231427626E-01, 6.1601982672E-01, 6.8692021649E-01],
	[1.5535000000E+04, 7.7364536975E+00, 5.4877686659E+00, 7.6309276932E-01, 6.1654627503E-01, 6.8704796987E-01],
	[1.5540000000E+04, 7.7399041064E+00, 5.4874759297E+00, 7.6387180593E-01, 6.1707296581E-01, 6.8717569144E-01],
	[1.5545000000E+04, 7.7433631427E+00, 5.4871878148E+00, 7.6465138630E-01, 6.1759996667E-01, 6.8730338119E-01],
	[1.5550000000E+04, 7.7468226117E+00, 5.4868998077E+00, 7.6543151063E-01, 6.1812716847E-01, 6.8743103911E-01],
	[1.5555000000E+04, 7.7502825133E+00, 5.4866119083E+00, 7.6621217911E-01, 6.1865457108E-01, 6.8755866519E-01],
	[1.5560000000E+04, 7.7537428475E+00, 5.4863241165E+00, 7.6699339196E-01, 6.1918217440E-01, 6.8768625942E-01],
	[1.5565000000E+04, 7.7572036142E+00, 5.4860364323E+00, 7.6777514938E-01, 6.1970997829E-01, 6.8781382177E-01],
	[1.5570000000E+04, 7.7606648133E+00, 5.4857488556E+00, 7.6855745158E-01, 6.2023798264E-01, 6.8794135225E-01],
	[1.5575000000E+04, 7.7641264446E+00, 5.4854613862E+00, 7.6934029875E-01, 6.2076618733E-01, 6.8806885082E-01],
	[1.5580000000E+04, 7.7675885081E+00, 5.4851740242E+00, 7.7012369110E-01, 6.2129459224E-01, 6.8819631749E-01],
	[1.5585000000E+04, 7.7710510038E+00, 5.4848867694E+00, 7.7090762883E-01, 6.2182319724E-01, 6.8832375224E-01],
	[1.5590000000E+04, 7.7745139316E+00, 5.4845996218E+00, 7.7169211216E-01, 6.2235200222E-01, 6.8845115505E-01],
	[1.5595000000E+04, 7.7779772912E+00, 5.4843125813E+00, 7.7247714128E-01, 6.2288100705E-01, 6.8857852591E-01],
	[1.5600000000E+04, 7.7814410828E+00, 5.4840256479E+00, 7.7326271639E-01, 6.2341021161E-01, 6.8870586481E-01],
	[1.5605000000E+04, 7.7849053061E+00, 5.4837388214E+00, 7.7404883770E-01, 6.2393961578E-01, 6.8883317174E-01],
	[1.5610000000E+04, 7.7883699612E+00, 5.4834521018E+00, 7.7483550542E-01, 6.2446921944E-01, 6.8896044669E-01],
	[1.5615000000E+04, 7.7918350478E+00, 5.4831654889E+00, 7.7562271975E-01, 6.2499902246E-01, 6.8908768963E-01],
	[1.5620000000E+04, 7.7953005660E+00, 5.4828789829E+00, 7.7641048089E-01, 6.2552902474E-01, 6.8921490057E-01],
	[1.5625000000E+04, 7.7987665157E+00, 5.4825925834E+00, 7.7719878904E-01, 6.2605922613E-01, 6.8934207948E-01],
	[1.5630000000E+04, 7.8022328967E+00, 5.4823062906E+00, 7.7798764442E-01, 6.2658962653E-01, 6.8946922635E-01],
	[1.5635000000E+04, 7.8056997090E+00, 5.4820201043E+00, 7.7877704722E-01, 6.2712022580E-01, 6.8959634117E-01],
	[1.5640000000E+04, 7.8091669525E+00, 5.4817340244E+00, 7.7956699765E-01, 6.2765102383E-01, 6.8972342393E-01],
	[1.5645000000E+04, 7.8126346271E+00, 5.4814480509E+00, 7.8035749591E-01, 6.2818202050E-01, 6.8985047462E-01],
	[1.5650000000E+04, 7.8161027327E+00, 5.4811621837E+00, 7.8114854221E-01, 6.2871321567E-01, 6.8997749322E-01],
	[1.5655000000E+04, 7.8195712693E+00, 5.4808764227E+00, 7.8194013675E-01, 6.2924460924E-01, 6.9010447972E-01],
	[1.5660000000E+04, 7.8230402367E+00, 5.4805907678E+00, 7.8273227974E-01, 6.2977620107E-01, 6.9023143410E-01],
	[1.5665000000E+04, 7.8265096350E+00, 5.4803052190E+00, 7.8352497137E-01, 6.3030799105E-01, 6.9035835636E-01],
	[1.5670000000E+04, 7.8299794639E+00, 5.4800197762E+00, 7.8431821185E-01, 6.3083997904E-01, 6.9048524649E-01],
	[1.5675000000E+04, 7.8334497234E+00, 5.4797344394E+00, 7.8511200140E-01, 6.3137216493E-01, 6.9061210446E-01],
	[1.5680000000E+04, 7.8369204134E+00, 5.4794492083E+00, 7.8590634020E-01, 6.3190454860E-01, 6.9073893028E-01],
	[1.5685000000E+04, 7.8403915339E+00, 5.4791640831E+00, 7.8670122847E-01, 6.3243712992E-01, 6.9086572392E-01],
	[1.5690000000E+04, 7.8438630848E+00, 5.4788790636E+00, 7.8749666641E-01, 6.3296990876E-01, 6.9099248537E-01],
	[1.5695000000E+04, 7.8473350659E+00, 5.4785941497E+00, 7.8829265422E-01, 6.3350288501E-01, 6.9111921462E-01],
	[1.5700000000E+04, 7.8508074772E+00, 5.4783093413E+00, 7.8908919211E-01, 6.3403605854E-01, 6.9124591167E-01],
	[1.5705000000E+04, 7.8542803186E+00, 5.4780246385E+00, 7.8988628028E-01, 6.3456942922E-01, 6.9137257649E-01],
	[1.5710000000E+04, 7.8577535900E+00, 5.4777400411E+00, 7.9068391894E-01, 6.3510299694E-01, 6.9149920907E-01],
	[1.5715000000E+04, 7.8612272914E+00, 5.4774555490E+00, 7.9148210829E-01, 6.3563676156E-01, 6.9162580941E-01],
	[1.5720000000E+04, 7.8647014226E+00, 5.4771711622E+00, 7.9228084853E-01, 6.3617072297E-01, 6.9175237749E-01],
	[1.5725000000E+04, 7.8681759836E+00, 5.4768868805E+00, 7.9308013987E-01, 6.3670488104E-01, 6.9187891330E-01],
	[1.5730000000E+04, 7.8716509743E+00, 5.4766027040E+00, 7.9387998252E-01, 6.3723923564E-01, 6.9200541682E-01],
	[1.5735000000E+04, 7.8751263945E+00, 5.4763186326E+00, 7.9468037667E-01, 6.3777378666E-01, 6.9213188805E-01],
	[1.5740000000E+04, 7.8786022443E+00, 5.4760346661E+00, 7.9548132253E-01, 6.3830853396E-01, 6.9225832697E-01],
	[1.5745000000E+04, 7.8820785236E+00, 5.4757508046E+00, 7.9628282031E-01, 6.3884347742E-01, 6.9238473358E-01],
	[1.5750000000E+04, 7.8855552322E+00, 5.4754670479E+00, 7.9708487021E-01, 6.3937861692E-01, 6.9251110785E-01],
	[1.5755000000E+04, 7.8890323701E+00, 5.4751833959E+00, 7.9788747243E-01, 6.3991395233E-01, 6.9263744978E-01],
	[1.5760000000E+04, 7.8925099371E+00, 5.4748998486E+00, 7.9869062718E-01, 6.4044948353E-01, 6.9276375935E-01],
	[1.5765000000E+04, 7.8959879333E+00, 5.4746164060E+00, 7.9949433466E-01, 6.4098521039E-01, 6.9289003656E-01],
	[1.5770000000E+04, 7.8994663584E+00, 5.4743330679E+00, 8.0029859508E-01, 6.4152113279E-01, 6.9301628139E-01],
	[1.5775000000E+04, 7.9029452126E+00, 5.4740498343E+00, 8.0110340864E-01, 6.4205725060E-01, 6.9314249383E-01],
	[1.5780000000E+04, 7.9064244955E+00, 5.4737667051E+00, 8.0190877555E-01, 6.4259356370E-01, 6.9326867387E-01],
	[1.5785000000E+04, 7.9099042073E+00, 5.4734836802E+00, 8.0271469601E-01, 6.4313007195E-01, 6.9339482150E-01],
	[1.5790000000E+04, 7.9133872563E+00, 5.4732022698E+00, 8.0352117022E-01, 6.4366681538E-01, 6.9352093670E-01],
	[1.5795000000E+04, 7.9168796404E+00, 5.4729255844E+00, 8.0432819839E-01, 6.4420387680E-01, 6.9364701946E-01],
	[1.5800000000E+04, 7.9203724597E+00, 5.4726490005E+00, 8.0513578072E-01, 6.4474113345E-01, 6.9377306978E-01],
	[1.5805000000E+04, 7.9238657141E+00, 5.4723725181E+00, 8.0594391742E-01, 6.4527858518E-01, 6.9389908764E-01],
	[1.5810000000E+04, 7.9273594036E+00, 5.4720961371E+00, 8.0675260869E-01, 6.4581623188E-01, 6.9402507302E-01],
	[1.5815000000E+04, 7.9308535280E+00, 5.4718198575E+00, 8.0756185474E-01, 6.4635407341E-01, 6.9415102593E-01],
	[1.5820000000E+04, 7.9343480872E+00, 5.4715436791E+00, 8.0837165577E-01, 6.4689210966E-01, 6.9427694634E-01],
	[1.5825000000E+04, 7.9378430812E+00, 5.4712676020E+00, 8.0918201198E-01, 6.4743034050E-01, 6.9440283425E-01],
	[1.5830000000E+04, 7.9413385099E+00, 5.4709916259E+00, 8.0999292358E-01, 6.4796876579E-01, 6.9452868964E-01],
	[1.5835000000E+04, 7.9448343732E+00, 5.4707157510E+00, 8.1080439078E-01, 6.4850738543E-01, 6.9465451250E-01],
	[1.5840000000E+04, 7.9483306711E+00, 5.4704399771E+00, 8.1161641377E-01, 6.4904619927E-01, 6.9478030282E-01],
	[1.5845000000E+04, 7.9518274033E+00, 5.4701643040E+00, 8.1242899277E-01, 6.4958520719E-01, 6.9490606060E-01],
	[1.5850000000E+04, 7.9553245699E+00, 5.4698887319E+00, 8.1324212798E-01, 6.5012440907E-01, 6.9503178581E-01],
	[1.5855000000E+04, 7.9588221708E+00, 5.4696132605E+00, 8.1405581959E-01, 6.5066380478E-01, 6.9515747845E-01],
	[1.5860000000E+04, 7.9623202059E+00, 5.4693378899E+00, 8.1487006783E-01, 6.5120339419E-01, 6.9528313850E-01],
	[1.5865000000E+04, 7.9658186751E+00, 5.4690626199E+00, 8.1568487288E-01, 6.5174317718E-01, 6.9540876597E-01],
	[1.5870000000E+04, 7.9693175783E+00, 5.4687874505E+00, 8.1650023496E-01, 6.5228315361E-01, 6.9553436082E-01],
	[1.5875000000E+04, 7.9728169155E+00, 5.4685123816E+00, 8.1731615427E-01, 6.5282332337E-01, 6.9565992306E-01],
	[1.5880000000E+04, 7.9763166865E+00, 5.4682374132E+00, 8.1813263101E-01, 6.5336368633E-01, 6.9578545267E-01],
	[1.5885000000E+04, 7.9798168913E+00, 5.4679625452E+00, 8.1894966539E-01, 6.5390424235E-01, 6.9591094964E-01],
	[1.5890000000E+04, 7.9833175298E+00, 5.4676877775E+00, 8.1976725761E-01, 6.5444499131E-01, 6.9603641397E-01],
	[1.5895000000E+04, 7.9868186018E+00, 5.4674131100E+00, 8.2058540788E-01, 6.5498593308E-01, 6.9616184563E-01],
	[1.5900000000E+04, 7.9903201075E+00, 5.4671385427E+00, 8.2140411641E-01, 6.5552706755E-01, 6.9628724462E-01],
	[1.5905000000E+04, 7.9938220465E+00, 5.4668640755E+00, 8.2222338339E-01, 6.5606839456E-01, 6.9641261092E-01],
	[1.5910000000E+04, 7.9973244189E+00, 5.4665897083E+00, 8.2304320903E-01, 6.5660991401E-01, 6.9653794454E-01],
	[1.5915000000E+04, 8.0008272246E+00, 5.4663154412E+00, 8.2386359354E-01, 6.5715162576E-01, 6.9666324545E-01],
	[1.5920000000E+04, 8.0043304635E+00, 5.4660412739E+00, 8.2468453712E-01, 6.5769352969E-01, 6.9678851364E-01],
	[1.5925000000E+04, 8.0078341355E+00, 5.4657672065E+00, 8.2550603997E-01, 6.5823562566E-01, 6.9691374911E-01],
	[1.5930000000E+04, 8.0113382406E+00, 5.4654932388E+00, 8.2632810231E-01, 6.5877791355E-01, 6.9703895185E-01],
	[1.5935000000E+04, 8.0148427786E+00, 5.4652193709E+00, 8.2715072433E-01, 6.5932039323E-01, 6.9716412184E-01],
	[1.5940000000E+04, 8.0183477494E+00, 5.4649456026E+00, 8.2797390624E-01, 6.5986306457E-01, 6.9728925907E-01],
	[1.5945000000E+04, 8.0218531530E+00, 5.4646719338E+00, 8.2879764824E-01, 6.6040592744E-01, 6.9741436353E-01],
	[1.5950000000E+04, 8.0253589894E+00, 5.4643983646E+00, 8.2962195054E-01, 6.6094898172E-01, 6.9753943521E-01],
	[1.5955000000E+04, 8.0288652583E+00, 5.4641248948E+00, 8.3044681334E-01, 6.6149222727E-01, 6.9766447410E-01],
	[1.5960000000E+04, 8.0323719598E+00, 5.4638515243E+00, 8.3127223686E-01, 6.6203566397E-01, 6.9778948020E-01],
	[1.5965000000E+04, 8.0358790938E+00, 5.4635782532E+00, 8.3209822128E-01, 6.6257929169E-01, 6.9791445348E-01],
	[1.5970000000E+04, 8.0393866601E+00, 5.4633050812E+00, 8.3292476682E-01, 6.6312311030E-01, 6.9803939394E-01],
	[1.5975000000E+04, 8.0428946587E+00, 5.4630320085E+00, 8.3375187369E-01, 6.6366711966E-01, 6.9816430155E-01],
	[1.5980000000E+04, 8.0464030895E+00, 5.4627590348E+00, 8.3457954208E-01, 6.6421131966E-01, 6.9828917631E-01],
	[1.5985000000E+04, 8.0499119525E+00, 5.4624861602E+00, 8.3540777220E-01, 6.6475571016E-01, 6.9841401819E-01],
	[1.5990000000E+04, 8.0534212475E+00, 5.4622133846E+00, 8.3623656426E-01, 6.6530029103E-01, 6.9853882719E-01],
	[1.5995000000E+04, 8.0569309744E+00, 5.4619407078E+00, 8.3706591846E-01, 6.6584506214E-01, 6.9866360329E-01],
	[1.6000000000E+04, 8.0604411333E+00, 5.4616681299E+00, 8.3789583501E-01, 6.6639002337E-01, 6.9878834648E-01],
	[1.6005000000E+04, 8.0639517239E+00, 5.4613956507E+00, 8.3872631410E-01, 6.6693517458E-01, 6.9891305675E-01],
	[1.6010000000E+04, 8.0674627462E+00, 5.4611232703E+00, 8.3955735595E-01, 6.6748051564E-01, 6.9903773408E-01],
	[1.6015000000E+04, 8.0709742002E+00, 5.4608509884E+00, 8.4038896077E-01, 6.6802604642E-01, 6.9916237846E-01],
	[1.6020000000E+04, 8.0744860858E+00, 5.4605788051E+00, 8.4122112874E-01, 6.6857176680E-01, 6.9928698988E-01],
	[1.6025000000E+04, 8.0779984028E+00, 5.4603067204E+00, 8.4205386009E-01, 6.6911767664E-01, 6.9941156832E-01],
	[1.6030000000E+04, 8.0815111512E+00, 5.4600347340E+00, 8.4288715501E-01, 6.6966377581E-01, 6.9953611377E-01],
	[1.6035000000E+04, 8.0850243309E+00, 5.4597628461E+00, 8.4372101371E-01, 6.7021006419E-01, 6.9966062622E-01],
	[1.6040000000E+04, 8.0885379418E+00, 5.4594910564E+00, 8.4455543640E-01, 6.7075654163E-01, 6.9978510565E-01],
	[1.6045000000E+04, 8.0920570364E+00, 5.4592218420E+00, 8.4539042327E-01, 6.7130328025E-01, 6.9990955206E-01],
	[1.6050000000E+04, 8.0955838158E+00, 5.4589562781E+00, 8.4622597454E-01, 6.7185031162E-01, 7.0003396542E-01],
	[1.6055000000E+04, 8.0991110331E+00, 5.4586908097E+00, 8.4706209041E-01, 6.7239753212E-01, 7.0015834573E-01],
	[1.6060000000E+04, 8.1026386882E+00, 5.4584254370E+00, 8.4789877108E-01, 6.7294494163E-01, 7.0028269297E-01],
	[1.6065000000E+04, 8.1061667809E+00, 5.4581601597E+00, 8.4873601676E-01, 6.7349254001E-01, 7.0040700714E-01],
	[1.6070000000E+04, 8.1096953112E+00, 5.4578949779E+00, 8.4957382765E-01, 6.7404032714E-01, 7.0053128821E-01],
	[1.6075000000E+04, 8.1132242791E+00, 5.4576298914E+00, 8.5041220396E-01, 6.7458830287E-01, 7.0065553618E-01],
	[1.6080000000E+04, 8.1167536844E+00, 5.4573649002E+00, 8.5125114590E-01, 6.7513646709E-01, 7.0077975103E-01],
	[1.6085000000E+04, 8.1202835271E+00, 5.4571000043E+00, 8.5209065366E-01, 6.7568481965E-01, 7.0090393275E-01],
	[1.6090000000E+04, 8.1238138070E+00, 5.4568352036E+00, 8.5293072746E-01, 6.7623336044E-01, 7.0102808133E-01],
	[1.6095000000E+04, 8.1273445241E+00, 5.4565704980E+00, 8.5377136749E-01, 6.7678208931E-01, 7.0115219675E-01],
	[1.6100000000E+04, 8.1308756784E+00, 5.4563058875E+00, 8.5461257397E-01, 6.7733100614E-01, 7.0127627900E-01],
	[1.6105000000E+04, 8.1344072697E+00, 5.4560413719E+00, 8.5545434710E-01, 6.7788011080E-01, 7.0140032808E-01],
	[1.6110000000E+04, 8.1379392979E+00, 5.4557769513E+00, 8.5629668708E-01, 6.7842940315E-01, 7.0152434396E-01],
	[1.6115000000E+04, 8.1414717630E+00, 5.4555126255E+00, 8.5713959411E-01, 6.7897888306E-01, 7.0164832664E-01],
	[1.6120000000E+04, 8.1450046649E+00, 5.4552483945E+00, 8.5798306842E-01, 6.7952855041E-01, 7.0177227610E-01],
	[1.6125000000E+04, 8.1485380035E+00, 5.4549842583E+00, 8.5882711019E-01, 6.8007840505E-01, 7.0189619233E-01],
	[1.6130000000E+04, 8.1520717788E+00, 5.4547202167E+00, 8.5967171963E-01, 6.8062844687E-01, 7.0202007532E-01],
	[1.6135000000E+04, 8.1556059905E+00, 5.4544562698E+00, 8.6051689695E-01, 6.8117867571E-01, 7.0214392506E-01],
	[1.6140000000E+04, 8.1591406388E+00, 5.4541924174E+00, 8.6136264235E-01, 6.8172909147E-01, 7.0226774153E-01],
	[1.6145000000E+04, 8.1626757234E+00, 5.4539286595E+00, 8.6220895605E-01, 6.8227969399E-01, 7.0239152472E-01],
	[1.6150000000E+04, 8.1662112443E+00, 5.4536649960E+00, 8.6305583823E-01, 6.8283048315E-01, 7.0251527462E-01],
	[1.6155000000E+04, 8.1697472015E+00, 5.4534014268E+00, 8.6390328912E-01, 6.8338145883E-01, 7.0263899122E-01],
	[1.6160000000E+04, 8.1732835948E+00, 5.4531379520E+00, 8.6475130891E-01, 6.8393262087E-01, 7.0276267450E-01],
	[1.6165000000E+04, 8.1768204241E+00, 5.4528745714E+00, 8.6559989781E-01, 6.8448396916E-01, 7.0288632446E-01],
	[1.6170000000E+04, 8.1803576894E+00, 5.4526112849E+00, 8.6644905602E-01, 6.8503550356E-01, 7.0300994108E-01],
	[1.6175000000E+04, 8.1838953906E+00, 5.4523480926E+00, 8.6729878375E-01, 6.8558722394E-01, 7.0313352435E-01],
	[1.6180000000E+04, 8.1874335276E+00, 5.4520849943E+00, 8.6814908120E-01, 6.8613913016E-01, 7.0325707425E-01],
	[1.6185000000E+04, 8.1909721004E+00, 5.4518219900E+00, 8.6899994859E-01, 6.8669122209E-01, 7.0338059078E-01],
	[1.6190000000E+04, 8.1945111088E+00, 5.4515590796E+00, 8.6985138611E-01, 6.8724349961E-01, 7.0350407393E-01],
	[1.6195000000E+04, 8.1980505528E+00, 5.4512962630E+00, 8.7070339397E-01, 6.8779596256E-01, 7.0362752367E-01],
	[1.6200000000E+04, 8.2015904322E+00, 5.4510335403E+00, 8.7155597237E-01, 6.8834861083E-01, 7.0375094001E-01],
	[1.6205000000E+04, 8.2051307471E+00, 5.4507709112E+00, 8.7240912152E-01, 6.8890144428E-01, 7.0387432293E-01],
	[1.6210000000E+04, 8.2086714973E+00, 5.4505083759E+00, 8.7326284163E-01, 6.8945446278E-01, 7.0399767241E-01],
	[1.6215000000E+04, 8.2122126828E+00, 5.4502459342E+00, 8.7411713290E-01, 6.9000766619E-01, 7.0412098845E-01],
	[1.6220000000E+04, 8.2157543034E+00, 5.4499835860E+00, 8.7497199553E-01, 6.9056105437E-01, 7.0424427103E-01],
	[1.6225000000E+04, 8.2192963591E+00, 5.4497213312E+00, 8.7582742974E-01, 6.9111462721E-01, 7.0436752014E-01],
	[1.6230000000E+04, 8.2228388498E+00, 5.4494591699E+00, 8.7668343572E-01, 6.9166838455E-01, 7.0449073577E-01],
	[1.6235000000E+04, 8.2263817754E+00, 5.4491971020E+00, 8.7754001368E-01, 6.9222232627E-01, 7.0461391791E-01],
	[1.6240000000E+04, 8.2299251359E+00, 5.4489351273E+00, 8.7839716383E-01, 6.9277645224E-01, 7.0473706655E-01],
	[1.6245000000E+04, 8.2334689311E+00, 5.4486732459E+00, 8.7925488637E-01, 6.9333076231E-01, 7.0486018167E-01],
	[1.6250000000E+04, 8.2370131610E+00, 5.4484114577E+00, 8.8011318151E-01, 6.9388525636E-01, 7.0498326327E-01],
	[1.6255000000E+04, 8.2405578256E+00, 5.4481497626E+00, 8.8097204945E-01, 6.9443993425E-01, 7.0510631133E-01],
	[1.6260000000E+04, 8.2441029246E+00, 5.4478881605E+00, 8.8183149039E-01, 6.9499479585E-01, 7.0522932584E-01],
	[1.6265000000E+04, 8.2476484581E+00, 5.4476266514E+00, 8.8269150455E-01, 6.9554984102E-01, 7.0535230679E-01],
	[1.6270000000E+04, 8.2511944260E+00, 5.4473652352E+00, 8.8355209213E-01, 6.9610506963E-01, 7.0547525418E-01],
	[1.6275000000E+04, 8.2547408281E+00, 5.4471039119E+00, 8.8441325333E-01, 6.9666048155E-01, 7.0559816797E-01],
	[1.6280000000E+04, 8.2582876644E+00, 5.4468426814E+00, 8.8527498837E-01, 6.9721607663E-01, 7.0572104818E-01],
	[1.6285000000E+04, 8.2618349349E+00, 5.4465815436E+00, 8.8613729743E-01, 6.9777185474E-01, 7.0584389478E-01],
	[1.6290000000E+04, 8.2653826394E+00, 5.4463204985E+00, 8.8700018073E-01, 6.9832781575E-01, 7.0596670776E-01],
	[1.6295000000E+04, 8.2689307778E+00, 5.4460595461E+00, 8.8786363848E-01, 6.9888395953E-01, 7.0608948712E-01],
	[1.6300000000E+04, 8.2724793501E+00, 5.4457986862E+00, 8.8872767088E-01, 6.9944028594E-01, 7.0621223284E-01],
	[1.6305000000E+04, 8.2760380428E+00, 5.4455424076E+00, 8.8959227814E-01, 6.9999693831E-01, 7.0633494491E-01],
	[1.6310000000E+04, 8.2796002882E+00, 5.4452876618E+00, 8.9045746046E-01, 7.0055381956E-01, 7.0645762332E-01],
	[1.6315000000E+04, 8.2831629743E+00, 5.4450330061E+00, 8.9132321804E-01, 7.0111088350E-01, 7.0658026806E-01],
	[1.6320000000E+04, 8.2867261010E+00, 5.4447784402E+00, 8.9218955109E-01, 7.0166813002E-01, 7.0670287912E-01],
	[1.6325000000E+04, 8.2902896682E+00, 5.4445239643E+00, 8.9305645983E-01, 7.0222555896E-01, 7.0682545648E-01],
	[1.6330000000E+04, 8.2938536759E+00, 5.4442695782E+00, 8.9392394444E-01, 7.0278317019E-01, 7.0694800014E-01],
	[1.6335000000E+04, 8.2974181241E+00, 5.4440152818E+00, 8.9479200514E-01, 7.0334096359E-01, 7.0707051008E-01],
	[1.6340000000E+04, 8.3009830125E+00, 5.4437610751E+00, 8.9566064214E-01, 7.0389893900E-01, 7.0719298630E-01],
	[1.6345000000E+04, 8.3045483411E+00, 5.4435069581E+00, 8.9652985564E-01, 7.0445709631E-01, 7.0731542878E-01],
	[1.6350000000E+04, 8.3081141099E+00, 5.4432529306E+00, 8.9739964584E-01, 7.0501543536E-01, 7.0743783752E-01],
	[1.6355000000E+04, 8.3116803188E+00, 5.4429989927E+00, 8.9827001295E-01, 7.0557395604E-01, 7.0756021250E-01],
	[1.6360000000E+04, 8.3152469677E+00, 5.4427451442E+00, 8.9914095717E-01, 7.0613265819E-01, 7.0768255371E-01],
	[1.6365000000E+04, 8.3188140564E+00, 5.4424913851E+00, 9.0001247872E-01, 7.0669154169E-01, 7.0780486114E-01],
	[1.6370000000E+04, 8.3223815850E+00, 5.4422377154E+00, 9.0088457779E-01, 7.0725060640E-01, 7.0792713478E-01],
	[1.6375000000E+04, 8.3259495534E+00, 5.4419841350E+00, 9.0175725459E-01, 7.0780985219E-01, 7.0804937462E-01],
	[1.6380000000E+04, 8.3295179614E+00, 5.4417306437E+00, 9.0263050934E-01, 7.0836927891E-01, 7.0817158065E-01],
	[1.6385000000E+04, 8.3330868090E+00, 5.4414772417E+00, 9.0350434222E-01, 7.0892888643E-01, 7.0829375285E-01],
	[1.6390000000E+04, 8.3366560961E+00, 5.4412239288E+00, 9.0437875346E-01, 7.0948867461E-01, 7.0841589123E-01],
	[1.6395000000E+04, 8.3402258226E+00, 5.4409707049E+00, 9.0525374325E-01, 7.1004864333E-01, 7.0853799576E-01],
	[1.6400000000E+04, 8.3437959885E+00, 5.4407175700E+00, 9.0612931179E-01, 7.1060879244E-01, 7.0866006644E-01],
	[1.6405000000E+04, 8.3473665937E+00, 5.4404645240E+00, 9.0700545931E-01, 7.1116912180E-01, 7.0878210326E-01],
	[1.6410000000E+04, 8.3509376380E+00, 5.4402115670E+00, 9.0788218599E-01, 7.1172963128E-01, 7.0890410621E-01],
	[1.6415000000E+04, 8.3545091214E+00, 5.4399586987E+00, 9.0875949205E-01, 7.1229032074E-01, 7.0902607527E-01],
	[1.6420000000E+04, 8.3580810439E+00, 5.4397059192E+00, 9.0963737770E-01, 7.1285119005E-01, 7.0914801044E-01],
	[1.6425000000E+04, 8.3616534053E+00, 5.4394532284E+00, 9.1051584313E-01, 7.1341223907E-01, 7.0926991170E-01],
	[1.6430000000E+04, 8.3652262056E+00, 5.4392006263E+00, 9.1139488855E-01, 7.1397346766E-01, 7.0939177905E-01],
	[1.6435000000E+04, 8.3687994447E+00, 5.4389481127E+00, 9.1227451417E-01, 7.1453487568E-01, 7.0951361247E-01],
	[1.6440000000E+04, 8.3723731225E+00, 5.4386956877E+00, 9.1315472020E-01, 7.1509646300E-01, 7.0963541196E-01],
	[1.6445000000E+04, 8.3759472389E+00, 5.4384433511E+00, 9.1403550684E-01, 7.1565822948E-01, 7.0975717751E-01],
	[1.6450000000E+04, 8.3795217939E+00, 5.4381911029E+00, 9.1491687429E-01, 7.1622017498E-01, 7.0987890910E-01],
	[1.6455000000E+04, 8.3830967873E+00, 5.4379389431E+00, 9.1579882277E-01, 7.1678229937E-01, 7.1000060672E-01],
	[1.6460000000E+04, 8.3866722192E+00, 5.4376868716E+00, 9.1668135247E-01, 7.1734460251E-01, 7.1012227037E-01],
	[1.6465000000E+04, 8.3902480893E+00, 5.4374348884E+00, 9.1756446361E-01, 7.1790708425E-01, 7.1024390004E-01],
	[1.6470000000E+04, 8.3938243977E+00, 5.4371829933E+00, 9.1844815638E-01, 7.1846974447E-01, 7.1036549571E-01],
	[1.6475000000E+04, 8.3974011442E+00, 5.4369311863E+00, 9.1933243100E-01, 7.1903258302E-01, 7.1048705738E-01],
	[1.6480000000E+04, 8.4009783289E+00, 5.4366794674E+00, 9.2021728767E-01, 7.1959559976E-01, 7.1060858503E-01],
	[1.6485000000E+04, 8.4045559515E+00, 5.4364278365E+00, 9.2110272660E-01, 7.2015879457E-01, 7.1073007865E-01],
	[1.6490000000E+04, 8.4081340120E+00, 5.4361762936E+00, 9.2198874798E-01, 7.2072216730E-01, 7.1085153825E-01],
	[1.6495000000E+04, 8.4117125103E+00, 5.4359248385E+00, 9.2287535204E-01, 7.2128571780E-01, 7.1097296380E-01],
	[1.6500000000E+04, 8.4152914464E+00, 5.4356734713E+00, 9.2376253897E-01, 7.2184944596E-01, 7.1109435529E-01],
	[1.6505000000E+04, 8.4188708202E+00, 5.4354221919E+00, 9.2465030897E-01, 7.2241335161E-01, 7.1121571273E-01],
	[1.6510000000E+04, 8.4224506316E+00, 5.4351710002E+00, 9.2553866226E-01, 7.2297743464E-01, 7.1133703609E-01],
	[1.6515000000E+04, 8.4260308805E+00, 5.4349198961E+00, 9.2642759905E-01, 7.2354169489E-01, 7.1145832536E-01],
	[1.6520000000E+04, 8.4296115669E+00, 5.4346688797E+00, 9.2731711952E-01, 7.2410613223E-01, 7.1157958055E-01],
	[1.6525000000E+04, 8.4331926906E+00, 5.4344179508E+00, 9.2820722390E-01, 7.2467074652E-01, 7.1170080163E-01],
	[1.6530000000E+04, 8.4367742516E+00, 5.4341671094E+00, 9.2909791239E-01, 7.2523553763E-01, 7.1182198860E-01],
	[1.6535000000E+04, 8.4403562498E+00, 5.4339163555E+00, 9.2998918519E-01, 7.2580050540E-01, 7.1194314145E-01],
	[1.6540000000E+04, 8.4439386851E+00, 5.4336656889E+00, 9.3088104252E-01, 7.2636564972E-01, 7.1206426018E-01],
	[1.6545000000E+04, 8.4475215575E+00, 5.4334151096E+00, 9.3177348456E-01, 7.2693097042E-01, 7.1218534476E-01],
	[1.6550000000E+04, 8.4511048668E+00, 5.4331646176E+00, 9.3266651154E-01, 7.2749646739E-01, 7.1230639519E-01],
	[1.6555000000E+04, 8.4546886131E+00, 5.4329142128E+00, 9.3356012366E-01, 7.2806214047E-01, 7.1242741146E-01],
	[1.6560000000E+04, 8.4582727961E+00, 5.4326638952E+00, 9.3445432112E-01, 7.2862798952E-01, 7.1254839357E-01],
	[1.6565000000E+04, 8.4618610248E+00, 5.4324152477E+00, 9.3534910413E-01, 7.2919406974E-01, 7.1266934150E-01],
	[1.6570000000E+04, 8.4654593870E+00, 5.4321709373E+00, 9.3624447289E-01, 7.2976047455E-01, 7.1279025524E-01],
	[1.6575000000E+04, 8.4690581930E+00, 5.4319267115E+00, 9.3714042761E-01, 7.3032705541E-01, 7.1291113479E-01],
	[1.6580000000E+04, 8.4726574428E+00, 5.4316825704E+00, 9.3803696850E-01, 7.3089381220E-01, 7.1303198013E-01],
	[1.6585000000E+04, 8.4762571363E+00, 5.4314385139E+00, 9.3893409577E-01, 7.3146074476E-01, 7.1315279126E-01],
	[1.6590000000E+04, 8.4798572733E+00, 5.4311945419E+00, 9.3983180961E-01, 7.3202785296E-01, 7.1327356816E-01],
	[1.6595000000E+04, 8.4834578540E+00, 5.4309506544E+00, 9.4073011023E-01, 7.3259513666E-01, 7.1339431084E-01],
	[1.6600000000E+04, 8.4870588780E+00, 5.4307068512E+00, 9.4162899785E-01, 7.3316259572E-01, 7.1351501927E-01],
	[1.6605000000E+04, 8.4906603455E+00, 5.4304631325E+00, 9.4252847266E-01, 7.3373023000E-01, 7.1363569345E-01],
	[1.6610000000E+04, 8.4942622562E+00, 5.4302194980E+00, 9.4342853488E-01, 7.3429803936E-01, 7.1375633337E-01],
	[1.6615000000E+04, 8.4978646102E+00, 5.4299759479E+00, 9.4432918471E-01, 7.3486602366E-01, 7.1387693903E-01],
	[1.6620000000E+04, 8.5014674073E+00, 5.4297324819E+00, 9.4523042234E-01, 7.3543418277E-01, 7.1399751040E-01],
	[1.6625000000E+04, 8.5050706474E+00, 5.4294891000E+00, 9.4613224800E-01, 7.3600251653E-01, 7.1411804749E-01],
	[1.6630000000E+04, 8.5086743306E+00, 5.4292458023E+00, 9.4703466189E-01, 7.3657102482E-01, 7.1423855029E-01],
	[1.6635000000E+04, 8.5122784566E+00, 5.4290025885E+00, 9.4793766421E-01, 7.3713970749E-01, 7.1435901878E-01],
	[1.6640000000E+04, 8.5158830255E+00, 5.4287594588E+00, 9.4884125517E-01, 7.3770856439E-01, 7.1447945296E-01],
	[1.6645000000E+04, 8.5194880371E+00, 5.4285164130E+00, 9.4974543497E-01, 7.3827759540E-01, 7.1459985282E-01],
	[1.6650000000E+04, 8.5230934914E+00, 5.4282734511E+00, 9.5065020382E-01, 7.3884680037E-01, 7.1472021835E-01],
	[1.6655000000E+04, 8.5266993882E+00, 5.4280305730E+00, 9.5155556193E-01, 7.3941617916E-01, 7.1484054953E-01],
	[1.6660000000E+04, 8.5303057276E+00, 5.4277877786E+00, 9.5246150950E-01, 7.3998573163E-01, 7.1496084638E-01],
	[1.6665000000E+04, 8.5339125094E+00, 5.4275450680E+00, 9.5336804674E-01, 7.4055545764E-01, 7.1508110886E-01],
	[1.6670000000E+04, 8.5375197336E+00, 5.4273024410E+00, 9.5427517386E-01, 7.4112535705E-01, 7.1520133698E-01],
	[1.6675000000E+04, 8.5411274000E+00, 5.4270598976E+00, 9.5518289105E-01, 7.4169542971E-01, 7.1532153073E-01],
	[1.6680000000E+04, 8.5447355086E+00, 5.4268174378E+00, 9.5609119854E-01, 7.4226567549E-01, 7.1544169009E-01],
	[1.6685000000E+04, 8.5483440594E+00, 5.4265750615E+00, 9.5700009652E-01, 7.4283609425E-01, 7.1556181506E-01],
	[1.6690000000E+04, 8.5519530522E+00, 5.4263327686E+00, 9.5790958519E-01, 7.4340668584E-01, 7.1568190564E-01],
	[1.6695000000E+04, 8.5555624869E+00, 5.4260905591E+00, 9.5881966478E-01, 7.4397745012E-01, 7.1580196181E-01],
	[1.6700000000E+04, 8.5591723635E+00, 5.4258484329E+00, 9.5973033547E-01, 7.4454838696E-01, 7.1592198356E-01],
	[1.6705000000E+04, 8.5627826819E+00, 5.4256063901E+00, 9.6064159748E-01, 7.4511949620E-01, 7.1604197089E-01],
	[1.6710000000E+04, 8.5663934421E+00, 5.4253644304E+00, 9.6155345102E-01, 7.4569077772E-01, 7.1616192378E-01],
	[1.6715000000E+04, 8.5700046439E+00, 5.4251225539E+00, 9.6246589629E-01, 7.4626223136E-01, 7.1628184223E-01],
	[1.6720000000E+04, 8.5736162873E+00, 5.4248807606E+00, 9.6337893349E-01, 7.4683385699E-01, 7.1640172624E-01],
	[1.6725000000E+04, 8.5772283721E+00, 5.4246390503E+00, 9.6429256284E-01, 7.4740565447E-01, 7.1652157579E-01],
	[1.6730000000E+04, 8.5808408984E+00, 5.4243974230E+00, 9.6520678453E-01, 7.4797762364E-01, 7.1664139087E-01],
	[1.6735000000E+04, 8.5844538660E+00, 5.4241558787E+00, 9.6612159878E-01, 7.4854976438E-01, 7.1676117147E-01],
	[1.6740000000E+04, 8.5880672749E+00, 5.4239144173E+00, 9.6703700580E-01, 7.4912207654E-01, 7.1688091760E-01],
	[1.6745000000E+04, 8.5916811249E+00, 5.4236730387E+00, 9.6795300578E-01, 7.4969455998E-01, 7.1700062923E-01],
	[1.6750000000E+04, 8.5952954160E+00, 5.4234317430E+00, 9.6886959893E-01, 7.5026721455E-01, 7.1712030637E-01],
	[1.6755000000E+04, 8.5989101482E+00, 5.4231905300E+00, 9.6978678546E-01, 7.5084004011E-01, 7.1723994900E-01],
	[1.6760000000E+04, 8.6025253213E+00, 5.4229493997E+00, 9.7070456558E-01, 7.5141303652E-01, 7.1735955712E-01],
	[1.6765000000E+04, 8.6061409353E+00, 5.4227083520E+00, 9.7162293950E-01, 7.5198620365E-01, 7.1747913071E-01],
	[1.6770000000E+04, 8.6097569901E+00, 5.4224673869E+00, 9.7254190741E-01, 7.5255954134E-01, 7.1759866977E-01],
	[1.6775000000E+04, 8.6133734855E+00, 5.4222265044E+00, 9.7346146952E-01, 7.5313304945E-01, 7.1771817429E-01],
	[1.6780000000E+04, 8.6169904217E+00, 5.4219857043E+00, 9.7438162605E-01, 7.5370672785E-01, 7.1783764427E-01],
	[1.6785000000E+04, 8.6206077983E+00, 5.4217449867E+00, 9.7530237720E-01, 7.5428057638E-01, 7.1795707969E-01],
	[1.6790000000E+04, 8.6242256155E+00, 5.4215043515E+00, 9.7622372317E-01, 7.5485459491E-01, 7.1807648056E-01],
	[1.6795000000E+04, 8.6278438730E+00, 5.4212637985E+00, 9.7714566417E-01, 7.5542878329E-01, 7.1819584685E-01],
	[1.6800000000E+04, 8.6314625709E+00, 5.4210233279E+00, 9.7806820041E-01, 7.5600314138E-01, 7.1831517856E-01],
	[1.6805000000E+04, 8.6350817091E+00, 5.4207829394E+00, 9.7899133209E-01, 7.5657766904E-01, 7.1843447569E-01],
	[1.6810000000E+04, 8.6387012873E+00, 5.4205426332E+00, 9.7991505943E-01, 7.5715236613E-01, 7.1855373822E-01],
	[1.6815000000E+04, 8.6423213057E+00, 5.4203024090E+00, 9.8083938261E-01, 7.5772723249E-01, 7.1867296615E-01],
	[1.6820000000E+04, 8.6459417641E+00, 5.4200622669E+00, 9.8176430186E-01, 7.5830226800E-01, 7.1879215948E-01],
	[1.6825000000E+04, 8.6495626625E+00, 5.4198222069E+00, 9.8268981738E-01, 7.5887747250E-01, 7.1891131819E-01],
	[1.6830000000E+04, 8.6531840007E+00, 5.4195822287E+00, 9.8361592938E-01, 7.5945284585E-01, 7.1903044227E-01],
	[1.6835000000E+04, 8.6568187766E+00, 5.4193477317E+00, 9.8454263805E-01, 7.6002859429E-01, 7.1914953172E-01],
	[1.6840000000E+04, 8.6604548158E+00, 5.4191136535E+00, 9.8546994362E-01, 7.6060452476E-01, 7.1926858652E-01],
	[1.6845000000E+04, 8.6640913021E+00, 5.4188796549E+00, 9.8639784628E-01, 7.6118062417E-01, 7.1938760666E-01],
	[1.6850000000E+04, 8.6677282355E+00, 5.4186457358E+00, 9.8732634624E-01, 7.6175689238E-01, 7.1950659214E-01],
	[1.6855000000E+04, 8.6713656158E+00, 5.4184118962E+00, 9.8825544370E-01, 7.6233332924E-01, 7.1962554294E-01],
	[1.6860000000E+04, 8.6750034430E+00, 5.4181781361E+00, 9.8918513889E-01, 7.6290993462E-01, 7.1974445905E-01],
	[1.6865000000E+04, 8.6786417170E+00, 5.4179444553E+00, 9.9011543199E-01, 7.6348670837E-01, 7.1986334046E-01],
	[1.6870000000E+04, 8.6822804377E+00, 5.4177108540E+00, 9.9104632322E-01, 7.6406365034E-01, 7.1998218717E-01],
	[1.6875000000E+04, 8.6859196050E+00, 5.4174773318E+00, 9.9197781278E-01, 7.6464076039E-01, 7.2010099916E-01],
	[1.6880000000E+04, 8.6895592189E+00, 5.4172438890E+00, 9.9290990088E-01, 7.6521803838E-01, 7.2021977643E-01],
	[1.6885000000E+04, 8.6931992793E+00, 5.4170105253E+00, 9.9384258773E-01, 7.6579548417E-01, 7.2033851896E-01],
	[1.6890000000E+04, 8.6968397861E+00, 5.4167772408E+00, 9.9477587353E-01, 7.6637309761E-01, 7.2045722675E-01],
	[1.6895000000E+04, 8.7004807392E+00, 5.4165440353E+00, 9.9570975849E-01, 7.6695087855E-01, 7.2057589978E-01],
	[1.6900000000E+04, 8.7041221386E+00, 5.4163109090E+00, 9.9664424282E-01, 7.6752882686E-01, 7.2069453805E-01],
	[1.6905000000E+04, 8.7077639841E+00, 5.4160778615E+00, 9.9757932672E-01, 7.6810694238E-01, 7.2081314155E-01],
	[1.6910000000E+04, 8.7114062758E+00, 5.4158448931E+00, 9.9851501039E-01, 7.6868522498E-01, 7.2093171026E-01],
	[1.6915000000E+04, 8.7150490134E+00, 5.4156120035E+00, 9.9945129406E-01, 7.6926367451E-01, 7.2105024418E-01],
	[1.6920000000E+04, 8.7186921971E+00, 5.4153791928E+00, 1.0003881779E+00, 7.6984229083E-01, 7.2116874330E-01],
	[1.6925000000E+04, 8.7223358265E+00, 5.4151464608E+00, 1.0013256622E+00, 7.7042107379E-01, 7.2128720761E-01],
	[1.6930000000E+04, 8.7259799018E+00, 5.4149138076E+00, 1.0022637470E+00, 7.7100002325E-01, 7.2140563710E-01],
	[1.6935000000E+04, 8.7296244228E+00, 5.4146812331E+00, 1.0032024327E+00, 7.7157913906E-01, 7.2152403176E-01],
	[1.6940000000E+04, 8.7332693894E+00, 5.4144487373E+00, 1.0041417194E+00, 7.7215842108E-01, 7.2164239158E-01],
	[1.6945000000E+04, 8.7369148016E+00, 5.4142163200E+00, 1.0050816073E+00, 7.7273786917E-01, 7.2176071656E-01],
	[1.6950000000E+04, 8.7405606592E+00, 5.4139839813E+00, 1.0060220967E+00, 7.7331748317E-01, 7.2187900667E-01],
	[1.6955000000E+04, 8.7442069623E+00, 5.4137517210E+00, 1.0069631876E+00, 7.7389726295E-01, 7.2199726192E-01],
	[1.6960000000E+04, 8.7478537107E+00, 5.4135195392E+00, 1.0079048805E+00, 7.7447720836E-01, 7.2211548230E-01],
	[1.6965000000E+04, 8.7515009043E+00, 5.4132874358E+00, 1.0088471754E+00, 7.7505731925E-01, 7.2223366779E-01],
	[1.6970000000E+04, 8.7551485431E+00, 5.4130554108E+00, 1.0097900725E+00, 7.7563759549E-01, 7.2235181839E-01],
	[1.6975000000E+04, 8.7587966270E+00, 5.4128234640E+00, 1.0107335721E+00, 7.7621803691E-01, 7.2246993409E-01],
	[1.6980000000E+04, 8.7624451559E+00, 5.4125915955E+00, 1.0116776744E+00, 7.7679864339E-01, 7.2258801488E-01],
	[1.6985000000E+04, 8.7660941298E+00, 5.4123598052E+00, 1.0126223796E+00, 7.7737941478E-01, 7.2270606075E-01],
	[1.6990000000E+04, 8.7697435485E+00, 5.4121280930E+00, 1.0135676878E+00, 7.7796035092E-01, 7.2282407169E-01],
	[1.6995000000E+04, 8.7733934121E+00, 5.4118964589E+00, 1.0145135993E+00, 7.7854145168E-01, 7.2294204769E-01],
	[1.7000000000E+04, 8.7770437203E+00, 5.4116649029E+00, 1.0154601144E+00, 7.7912271690E-01, 7.2305998874E-01],
	[1.7005000000E+04, 8.7806944732E+00, 5.4114334248E+00, 1.0164072331E+00, 7.7970414645E-01, 7.2317789484E-01],
	[1.7010000000E+04, 8.7843456706E+00, 5.4112020247E+00, 1.0173549558E+00, 7.8028574018E-01, 7.2329576598E-01],
	[1.7015000000E+04, 8.7879973125E+00, 5.4109707025E+00, 1.0183032825E+00, 7.8086749794E-01, 7.2341360215E-01],
	[1.7020000000E+04, 8.7916493988E+00, 5.4107394582E+00, 1.0192522136E+00, 7.8144941958E-01, 7.2353140333E-01],
	[1.7025000000E+04, 8.7953019295E+00, 5.4105082917E+00, 1.0202017493E+00, 7.8203150497E-01, 7.2364916952E-01],
	[1.7030000000E+04, 8.7989549044E+00, 5.4102772029E+00, 1.0211518896E+00, 7.8261375395E-01, 7.2376690072E-01],
	[1.7035000000E+04, 8.8026083235E+00, 5.4100461918E+00, 1.0221026350E+00, 7.8319616637E-01, 7.2388459691E-01],
	[1.7040000000E+04, 8.8062621867E+00, 5.4098152584E+00, 1.0230539854E+00, 7.8377874210E-01, 7.2400225808E-01],
	[1.7045000000E+04, 8.8099164939E+00, 5.4095844025E+00, 1.0240059413E+00, 7.8436148099E-01, 7.2411988423E-01],
	[1.7050000000E+04, 8.8135712450E+00, 5.4093536243E+00, 1.0249585027E+00, 7.8494438288E-01, 7.2423747534E-01],
	[1.7055000000E+04, 8.8172264400E+00, 5.4091229235E+00, 1.0259116698E+00, 7.8552744764E-01, 7.2435503142E-01],
	[1.7060000000E+04, 8.8208820789E+00, 5.4088923002E+00, 1.0268654430E+00, 7.8611067512E-01, 7.2447255245E-01],
	[1.7065000000E+04, 8.8245381614E+00, 5.4086617543E+00, 1.0278198223E+00, 7.8669406517E-01, 7.2459003842E-01],
	[1.7070000000E+04, 8.8281946876E+00, 5.4084312858E+00, 1.0287748081E+00, 7.8727761764E-01, 7.2470748932E-01],
	[1.7075000000E+04, 8.8318516573E+00, 5.4082008946E+00, 1.0297304004E+00, 7.8786133239E-01, 7.2482490515E-01],
	[1.7080000000E+04, 8.8355090706E+00, 5.4079705806E+00, 1.0306865995E+00, 7.8844520927E-01, 7.2494228590E-01],
	[1.7085000000E+04, 8.8391669272E+00, 5.4077403439E+00, 1.0316434057E+00, 7.8902924814E-01, 7.2505963155E-01],
	[1.7090000000E+04, 8.8428252272E+00, 5.4075101843E+00, 1.0326008191E+00, 7.8961344885E-01, 7.2517694211E-01],
	[1.7095000000E+04, 8.8464839705E+00, 5.4072801019E+00, 1.0335588399E+00, 7.9019781124E-01, 7.2529421756E-01],
	[1.7100000000E+04, 8.8501431569E+00, 5.4070500965E+00, 1.0345174683E+00, 7.9078233518E-01, 7.2541145790E-01],
	[1.7105000000E+04, 8.8538135629E+00, 5.4068244127E+00, 1.0354767046E+00, 7.9136719754E-01, 7.2552866311E-01],
	[1.7110000000E+04, 8.8574879739E+00, 5.4066002044E+00, 1.0364365489E+00, 7.9195228003E-01, 7.2564583319E-01],
	[1.7115000000E+04, 8.8611628355E+00, 5.4063760709E+00, 1.0373970015E+00, 7.9253752416E-01, 7.2576296813E-01],
	[1.7120000000E+04, 8.8648381476E+00, 5.4061520121E+00, 1.0383580626E+00, 7.9312292979E-01, 7.2588006792E-01],
	[1.7125000000E+04, 8.8685139103E+00, 5.4059280280E+00, 1.0393197323E+00, 7.9370849678E-01, 7.2599713256E-01],
	[1.7130000000E+04, 8.8721901233E+00, 5.4057041186E+00, 1.0402820109E+00, 7.9429422497E-01, 7.2611416204E-01],
	[1.7135000000E+04, 8.8758667867E+00, 5.4054802838E+00, 1.0412448986E+00, 7.9488011422E-01, 7.2623115634E-01],
	[1.7140000000E+04, 8.8795439003E+00, 5.4052565236E+00, 1.0422083956E+00, 7.9546616438E-01, 7.2634811547E-01],
	[1.7145000000E+04, 8.8832214642E+00, 5.4050328379E+00, 1.0431725020E+00, 7.9605237531E-01, 7.2646503941E-01],
	[1.7150000000E+04, 8.8868994781E+00, 5.4048092266E+00, 1.0441372182E+00, 7.9663874686E-01, 7.2658192815E-01],
	[1.7155000000E+04, 8.8905779421E+00, 5.4045856898E+00, 1.0451025443E+00, 7.9722527887E-01, 7.2669878169E-01],
	[1.7160000000E+04, 8.8942568560E+00, 5.4043622274E+00, 1.0460684805E+00, 7.9781197121E-01, 7.2681560003E-01],
	[1.7165000000E+04, 8.8979362198E+00, 5.4041388393E+00, 1.0470350271E+00, 7.9839882373E-01, 7.2693238314E-01],
	[1.7170000000E+04, 8.9016160334E+00, 5.4039155256E+00, 1.0480021841E+00, 7.9898583628E-01, 7.2704913103E-01],
	[1.7175000000E+04, 8.9052962967E+00, 5.4036922860E+00, 1.0489699520E+00, 7.9957300871E-01, 7.2716584368E-01],
	[1.7180000000E+04, 8.9089770097E+00, 5.4034691207E+00, 1.0499383307E+00, 8.0016034087E-01, 7.2728252110E-01],
	[1.7185000000E+04, 8.9126581722E+00, 5.4032460295E+00, 1.0509073206E+00, 8.0074783261E-01, 7.2739916327E-01],
	[1.7190000000E+04, 8.9163397843E+00, 5.4030230124E+00, 1.0518769219E+00, 8.0133548380E-01, 7.2751577018E-01],
	[1.7195000000E+04, 8.9200218457E+00, 5.4028000694E+00, 1.0528471348E+00, 8.0192329428E-01, 7.2763234183E-01],
	[1.7200000000E+04, 8.9237043565E+00, 5.4025772004E+00, 1.0538179594E+00, 8.0251126390E-01, 7.2774887820E-01],
	[1.7205000000E+04, 8.9273873166E+00, 5.4023544053E+00, 1.0547893960E+00, 8.0309939252E-01, 7.2786537930E-01],
	[1.7210000000E+04, 8.9310707259E+00, 5.4021316842E+00, 1.0557614448E+00, 8.0368767998E-01, 7.2798184512E-01],
	[1.7215000000E+04, 8.9347545843E+00, 5.4019090370E+00, 1.0567341060E+00, 8.0427612615E-01, 7.2809827564E-01],
	[1.7220000000E+04, 8.9384388917E+00, 5.4016864636E+00, 1.0577073798E+00, 8.0486473087E-01, 7.2821467086E-01],
	[1.7225000000E+04, 8.9421236481E+00, 5.4014639639E+00, 1.0586812664E+00, 8.0545349398E-01, 7.2833103077E-01],
	[1.7230000000E+04, 8.9458088534E+00, 5.4012415380E+00, 1.0596557660E+00, 8.0604241536E-01, 7.2844735537E-01],
	[1.7235000000E+04, 8.9494945076E+00, 5.4010191858E+00, 1.0606308789E+00, 8.0663149484E-01, 7.2856364464E-01],
	[1.7240000000E+04, 8.9531806104E+00, 5.4007969073E+00, 1.0616066052E+00, 8.0722073228E-01, 7.2867989859E-01],
	[1.7245000000E+04, 8.9568671619E+00, 5.4005747023E+00, 1.0625829451E+00, 8.0781012753E-01, 7.2879611720E-01],
	[1.7250000000E+04, 8.9605541620E+00, 5.4003525709E+00, 1.0635598989E+00, 8.0839968045E-01, 7.2891230047E-01],
	[1.7255000000E+04, 8.9642416107E+00, 5.4001305130E+00, 1.0645374667E+00, 8.0898939087E-01, 7.2902844838E-01],
	[1.7260000000E+04, 8.9679295077E+00, 5.3999085286E+00, 1.0655156488E+00, 8.0957925866E-01, 7.2914456094E-01],
	[1.7265000000E+04, 8.9716178532E+00, 5.3996866176E+00, 1.0664944454E+00, 8.1016928367E-01, 7.2926063813E-01],
	[1.7270000000E+04, 8.9753066469E+00, 5.3994647800E+00, 1.0674738566E+00, 8.1075946575E-01, 7.2937667996E-01],
	[1.7275000000E+04, 8.9789958888E+00, 5.3992430157E+00, 1.0684538827E+00, 8.1134980474E-01, 7.2949268640E-01],
	[1.7280000000E+04, 8.9826855789E+00, 5.3990213246E+00, 1.0694345240E+00, 8.1194030050E-01, 7.2960865745E-01],
	[1.7285000000E+04, 8.9863757170E+00, 5.3987997068E+00, 1.0704157805E+00, 8.1253095289E-01, 7.2972459312E-01],
	[1.7290000000E+04, 8.9900663031E+00, 5.3985781622E+00, 1.0713976525E+00, 8.1312176174E-01, 7.2984049338E-01],
	[1.7295000000E+04, 8.9937573371E+00, 5.3983566908E+00, 1.0723801402E+00, 8.1371272692E-01, 7.2995635824E-01],
	[1.7300000000E+04, 8.9974488190E+00, 5.3981352924E+00, 1.0733632439E+00, 8.1430384827E-01, 7.3007218769E-01],
	[1.7305000000E+04, 9.0011407486E+00, 5.3979139671E+00, 1.0743469637E+00, 8.1489512565E-01, 7.3018798171E-01],
	[1.7310000000E+04, 9.0048331259E+00, 5.3976927148E+00, 1.0753312998E+00, 8.1548655890E-01, 7.3030374031E-01],
	[1.7315000000E+04, 9.0085259508E+00, 5.3974715355E+00, 1.0763162524E+00, 8.1607814787E-01, 7.3041946347E-01],
	[1.7320000000E+04, 9.0122192233E+00, 5.3972504291E+00, 1.0773018219E+00, 8.1666989243E-01, 7.3053515120E-01],
	[1.7325000000E+04, 9.0159129432E+00, 5.3970293956E+00, 1.0782880082E+00, 8.1726179241E-01, 7.3065080347E-01],
	[1.7330000000E+04, 9.0196071105E+00, 5.3968084349E+00, 1.0792748118E+00, 8.1785384766E-01, 7.3076642030E-01],
	[1.7335000000E+04, 9.0233017251E+00, 5.3965875469E+00, 1.0802622327E+00, 8.1844605805E-01, 7.3088200166E-01],
	[1.7340000000E+04, 9.0269967870E+00, 5.3963667318E+00, 1.0812502711E+00, 8.1903842341E-01, 7.3099754756E-01],
	[1.7345000000E+04, 9.0306922960E+00, 5.3961459893E+00, 1.0822389274E+00, 8.1963094360E-01, 7.3111305798E-01],
	[1.7350000000E+04, 9.0343882521E+00, 5.3959253194E+00, 1.0832282017E+00, 8.2022361847E-01, 7.3122853293E-01],
	[1.7355000000E+04, 9.0380846552E+00, 5.3957047222E+00, 1.0842180941E+00, 8.2081644787E-01, 7.3134397238E-01],
	[1.7360000000E+04, 9.0417815053E+00, 5.3954841975E+00, 1.0852086050E+00, 8.2140943165E-01, 7.3145937635E-01],
	[1.7365000000E+04, 9.0454788022E+00, 5.3952637454E+00, 1.0861997345E+00, 8.2200256966E-01, 7.3157474481E-01],
	[1.7370000000E+04, 9.0491765459E+00, 5.3950433657E+00, 1.0871914828E+00, 8.2259586174E-01, 7.3169007777E-01],
	[1.7375000000E+04, 9.0528747363E+00, 5.3948230584E+00, 1.0881838502E+00, 8.2318930776E-01, 7.3180537522E-01],
	[1.7380000000E+04, 9.0565836315E+00, 5.3946066587E+00, 1.0891768367E+00, 8.2378308185E-01, 7.3192063715E-01],
	[1.7385000000E+04, 9.0602975757E+00, 5.3943920478E+00, 1.0901704428E+00, 8.2437708815E-01, 7.3203586356E-01],
	[1.7390000000E+04, 9.0640119743E+00, 5.3941775071E+00, 1.0911646684E+00, 8.2497124848E-01, 7.3215105444E-01],
	[1.7395000000E+04, 9.0677268272E+00, 5.3939630367E+00, 1.0921595140E+00, 8.2556556271E-01, 7.3226620977E-01],
	[1.7400000000E+04, 9.0714421343E+00, 5.3937486364E+00, 1.0931549796E+00, 8.2616003069E-01, 7.3238132957E-01],
	[1.7405000000E+04, 9.0751578955E+00, 5.3935343062E+00, 1.0941510655E+00, 8.2675465226E-01, 7.3249641382E-01],
	[1.7410000000E+04, 9.0788741109E+00, 5.3933200461E+00, 1.0951477719E+00, 8.2734942727E-01, 7.3261146251E-01],
	[1.7415000000E+04, 9.0825907802E+00, 5.3931058561E+00, 1.0961450989E+00, 8.2794435558E-01, 7.3272647564E-01],
	[1.7420000000E+04, 9.0863079034E+00, 5.3928917360E+00, 1.0971430469E+00, 8.2853943703E-01, 7.3284145320E-01],
	[1.7425000000E+04, 9.0900254805E+00, 5.3926776859E+00, 1.0981416160E+00, 8.2913467147E-01, 7.3295639519E-01],
	[1.7430000000E+04, 9.0937435114E+00, 5.3924637057E+00, 1.0991408063E+00, 8.2973005876E-01, 7.3307130160E-01],
	[1.7435000000E+04, 9.0974619960E+00, 5.3922497953E+00, 1.1001406182E+00, 8.3032559874E-01, 7.3318617242E-01],
	[1.7440000000E+04, 9.1011809342E+00, 5.3920359548E+00, 1.1011410519E+00, 8.3092129126E-01, 7.3330100765E-01],
	[1.7445000000E+04, 9.1049003259E+00, 5.3918221840E+00, 1.1021421074E+00, 8.3151713618E-01, 7.3341580729E-01],
	[1.7450000000E+04, 9.1086201711E+00, 5.3916084830E+00, 1.1031437851E+00, 8.3211313334E-01, 7.3353057132E-01],
	[1.7455000000E+04, 9.1123404698E+00, 5.3913948516E+00, 1.1041460852E+00, 8.3270928259E-01, 7.3364529974E-01],
	[1.7460000000E+04, 9.1160612217E+00, 5.3911812900E+00, 1.1051490078E+00, 8.3330558378E-01, 7.3375999255E-01],
	[1.7465000000E+04, 9.1197824269E+00, 5.3909677979E+00, 1.1061525532E+00, 8.3390203676E-01, 7.3387464973E-01],
	[1.7470000000E+04, 9.1235040853E+00, 5.3907543753E+00, 1.1071567216E+00, 8.3449864137E-01, 7.3398927129E-01],
	[1.7475000000E+04, 9.1272261967E+00, 5.3905410223E+00, 1.1081615131E+00, 8.3509539748E-01, 7.3410385722E-01],
	[1.7480000000E+04, 9.1309487612E+00, 5.3903277388E+00, 1.1091669281E+00, 8.3569230493E-01, 7.3421840751E-01],
	[1.7485000000E+04, 9.1346717787E+00, 5.3901145247E+00, 1.1101729666E+00, 8.3628936356E-01, 7.3433292216E-01],
	[1.7490000000E+04, 9.1383952490E+00, 5.3899013800E+00, 1.1111796289E+00, 8.3688657322E-01, 7.3444740116E-01],
	[1.7495000000E+04, 9.1421191721E+00, 5.3896883046E+00, 1.1121869153E+00, 8.3748393377E-01, 7.3456184450E-01],
	[1.7500000000E+04, 9.1458435480E+00, 5.3894752986E+00, 1.1131948258E+00, 8.3808144506E-01, 7.3467625218E-01],
	[1.7505000000E+04, 9.1495683765E+00, 5.3892623618E+00, 1.1142115768E+00, 8.3868376196E-01, 7.3479062420E-01],
	[1.7510000000E+04, 9.1532936576E+00, 5.3890494942E+00, 1.1152289651E+00, 8.3928623283E-01, 7.3490496054E-01],
	[1.7515000000E+04, 9.1570193912E+00, 5.3888366959E+00, 1.1162469908E+00, 8.3988885752E-01, 7.3501926121E-01],
	[1.7520000000E+04, 9.1607455772E+00, 5.3886239666E+00, 1.1172656543E+00, 8.4049163588E-01, 7.3513352619E-01],
	[1.7525000000E+04, 9.1644722156E+00, 5.3884113065E+00, 1.1182849556E+00, 8.4109456774E-01, 7.3524775549E-01],
	[1.7530000000E+04, 9.1681993063E+00, 5.3881987154E+00, 1.1193048950E+00, 8.4169765295E-01, 7.3536194910E-01],
	[1.7535000000E+04, 9.1719268492E+00, 5.3879861933E+00, 1.1203254728E+00, 8.4230089137E-01, 7.3547610700E-01],
	[1.7540000000E+04, 9.1756548442E+00, 5.3877737402E+00, 1.1213466891E+00, 8.4290428283E-01, 7.3559022920E-01],
	[1.7545000000E+04, 9.1793832913E+00, 5.3875613560E+00, 1.1223685442E+00, 8.4350782718E-01, 7.3570431570E-01],
	[1.7550000000E+04, 9.1831121904E+00, 5.3873490407E+00, 1.1233910383E+00, 8.4411152427E-01, 7.3581836648E-01],
	[1.7555000000E+04, 9.1868415413E+00, 5.3871367942E+00, 1.1244141716E+00, 8.4471537393E-01, 7.3593238154E-01],
	[1.7560000000E+04, 9.1905713442E+00, 5.3869246166E+00, 1.1254379444E+00, 8.4531937602E-01, 7.3604636087E-01],
	[1.7565000000E+04, 9.1943015988E+00, 5.3867125077E+00, 1.1264623567E+00, 8.4592353039E-01, 7.3616030447E-01],
	[1.7570000000E+04, 9.1980323050E+00, 5.3865004675E+00, 1.1274874089E+00, 8.4652783686E-01, 7.3627421234E-01],
	[1.7575000000E+04, 9.2017634629E+00, 5.3862884960E+00, 1.1285131012E+00, 8.4713229530E-01, 7.3638808447E-01],
	[1.7580000000E+04, 9.2054950724E+00, 5.3860765932E+00, 1.1295394338E+00, 8.4773690554E-01, 7.3650192085E-01],
	[1.7585000000E+04, 9.2092271333E+00, 5.3858647589E+00, 1.1305664069E+00, 8.4834166743E-01, 7.3661572149E-01],
	[1.7590000000E+04, 9.2129596456E+00, 5.3856529932E+00, 1.1315940207E+00, 8.4894658082E-01, 7.3672948636E-01],
	[1.7595000000E+04, 9.2166926092E+00, 5.3854412959E+00, 1.1326222754E+00, 8.4955164554E-01, 7.3684321548E-01],
	[1.7600000000E+04, 9.2204260241E+00, 5.3852296672E+00, 1.1336511713E+00, 8.5015686145E-01, 7.3695690883E-01],
	[1.7605000000E+04, 9.2241598901E+00, 5.3850181069E+00, 1.1346807086E+00, 8.5076222839E-01, 7.3707056641E-01],
	[1.7610000000E+04, 9.2278942073E+00, 5.3848066149E+00, 1.1357108874E+00, 8.5136774620E-01, 7.3718418821E-01],
	[1.7615000000E+04, 9.2316289755E+00, 5.3845951913E+00, 1.1367417081E+00, 8.5197341472E-01, 7.3729777424E-01],
	[1.7620000000E+04, 9.2353641946E+00, 5.3843838361E+00, 1.1377731708E+00, 8.5257923381E-01, 7.3741132448E-01],
	[1.7625000000E+04, 9.2390998646E+00, 5.3841725490E+00, 1.1388052757E+00, 8.5318520330E-01, 7.3752483893E-01],
	[1.7630000000E+04, 9.2428359855E+00, 5.3839613302E+00, 1.1398380231E+00, 8.5379132304E-01, 7.3763831758E-01],
	[1.7635000000E+04, 9.2465725570E+00, 5.3837501796E+00, 1.1408714132E+00, 8.5439759287E-01, 7.3775176044E-01],
	[1.7640000000E+04, 9.2503095792E+00, 5.3835390971E+00, 1.1419054461E+00, 8.5500401265E-01, 7.3786516749E-01],
	[1.7645000000E+04, 9.2540470520E+00, 5.3833280827E+00, 1.1429401222E+00, 8.5561058220E-01, 7.3797853873E-01],
	[1.7650000000E+04, 9.2577849754E+00, 5.3831171363E+00, 1.1439754415E+00, 8.5621730138E-01, 7.3809187416E-01],
	[1.7655000000E+04, 9.2615233491E+00, 5.3829062580E+00, 1.1450114045E+00, 8.5682417003E-01, 7.3820517391E-01],
	[1.7660000000E+04, 9.2652735602E+00, 5.3826995086E+00, 1.1460480112E+00, 8.5743138856E-01, 7.3831843806E-01],
	[1.7665000000E+04, 9.2690281704E+00, 5.3824942313E+00, 1.1470852618E+00, 8.5803882619E-01, 7.3843166663E-01],
	[1.7670000000E+04, 9.2727832389E+00, 5.3822890199E+00, 1.1481231567E+00, 8.5864641341E-01, 7.3854485959E-01],
	[1.7675000000E+04, 9.2765387655E+00, 5.3820838744E+00, 1.1491616959E+00, 8.5925415008E-01, 7.3865801696E-01],
	[1.7680000000E+04, 9.2802947503E+00, 5.3818787947E+00, 1.1502008798E+00, 8.5986203603E-01, 7.3877113872E-01],
	[1.7685000000E+04, 9.2840511932E+00, 5.3816737808E+00, 1.1512407085E+00, 8.6047007110E-01, 7.3888422486E-01],
	[1.7690000000E+04, 9.2878080940E+00, 5.3814688326E+00, 1.1522811823E+00, 8.6107825515E-01, 7.3899727539E-01],
	[1.7695000000E+04, 9.2915654528E+00, 5.3812639502E+00, 1.1533223014E+00, 8.6168658801E-01, 7.3911029029E-01],
	[1.7700000000E+04, 9.2953232693E+00, 5.3810591335E+00, 1.1543640660E+00, 8.6229506953E-01, 7.3922326956E-01],
	[1.7705000000E+04, 9.2990815437E+00, 5.3808543824E+00, 1.1554064763E+00, 8.6290369955E-01, 7.3933621320E-01],
	[1.7710000000E+04, 9.3028402757E+00, 5.3806496969E+00, 1.1564495325E+00, 8.6351247792E-01, 7.3944912119E-01],
	[1.7715000000E+04, 9.3065994654E+00, 5.3804450770E+00, 1.1574932348E+00, 8.6412140447E-01, 7.3956199354E-01],
	[1.7720000000E+04, 9.3103591125E+00, 5.3802405226E+00, 1.1585375835E+00, 8.6473047907E-01, 7.3967483023E-01],
	[1.7725000000E+04, 9.3141192172E+00, 5.3800360337E+00, 1.1595825788E+00, 8.6533970154E-01, 7.3978763127E-01],
	[1.7730000000E+04, 9.3178797792E+00, 5.3798316102E+00, 1.1606282209E+00, 8.6594907173E-01, 7.3990039664E-01],
	[1.7735000000E+04, 9.3216407986E+00, 5.3796272521E+00, 1.1616745100E+00, 8.6655858949E-01, 7.4001312635E-01],
	[1.7740000000E+04, 9.3254022752E+00, 5.3794229594E+00, 1.1627214464E+00, 8.6716825465E-01, 7.4012582038E-01],
	[1.7745000000E+04, 9.3291642090E+00, 5.3792187320E+00, 1.1637690302E+00, 8.6777806707E-01, 7.4023847873E-01],
	[1.7750000000E+04, 9.3329265999E+00, 5.3790145699E+00, 1.1648172616E+00, 8.6838802658E-01, 7.4035110140E-01],
	[1.7755000000E+04, 9.3366894478E+00, 5.3788104731E+00, 1.1658661410E+00, 8.6899813303E-01, 7.4046368838E-01],
	[1.7760000000E+04, 9.3404527527E+00, 5.3786064415E+00, 1.1669156684E+00, 8.6960838626E-01, 7.4057623967E-01],
	[1.7765000000E+04, 9.3442165144E+00, 5.3784024750E+00, 1.1679658442E+00, 8.7021878611E-01, 7.4068875525E-01],
	[1.7770000000E+04, 9.3479807330E+00, 5.3781985737E+00, 1.1690166685E+00, 8.7082933243E-01, 7.4080123513E-01],
	[1.7775000000E+04, 9.3517454083E+00, 5.3779947374E+00, 1.1700681415E+00, 8.7144002507E-01, 7.4091367930E-01],
	[1.7780000000E+04, 9.3555105402E+00, 5.3777909662E+00, 1.1711202635E+00, 8.7205086385E-01, 7.4102608776E-01],
	[1.7785000000E+04, 9.3592761288E+00, 5.3775872601E+00, 1.1721730347E+00, 8.7266184864E-01, 7.4113846050E-01],
	[1.7790000000E+04, 9.3630421738E+00, 5.3773836189E+00, 1.1732264553E+00, 8.7327297926E-01, 7.4125079751E-01],
	[1.7795000000E+04, 9.3668086753E+00, 5.3771800426E+00, 1.1742805256E+00, 8.7388425557E-01, 7.4136309879E-01],
	[1.7800000000E+04, 9.3705756332E+00, 5.3769765312E+00, 1.1753352456E+00, 8.7449567740E-01, 7.4147536434E-01],
	[1.7805000000E+04, 9.3743430474E+00, 5.3767730847E+00, 1.1763906158E+00, 8.7510724460E-01, 7.4158759415E-01],
	[1.7810000000E+04, 9.3781109178E+00, 5.3765697030E+00, 1.1774466361E+00, 8.7571895701E-01, 7.4169978821E-01],
	[1.7815000000E+04, 9.3818792443E+00, 5.3763663861E+00, 1.1785033070E+00, 8.7633081447E-01, 7.4181194652E-01],
	[1.7820000000E+04, 9.3856480269E+00, 5.3761631339E+00, 1.1795606286E+00, 8.7694281683E-01, 7.4192406908E-01],
	[1.7825000000E+04, 9.3894172655E+00, 5.3759599464E+00, 1.1806186012E+00, 8.7755496393E-01, 7.4203615588E-01],
	[1.7830000000E+04, 9.3931869601E+00, 5.3757568236E+00, 1.1816772248E+00, 8.7816725561E-01, 7.4214820692E-01],
	[1.7835000000E+04, 9.3969571105E+00, 5.3755537654E+00, 1.1827364998E+00, 8.7877969171E-01, 7.4226022219E-01],
	[1.7840000000E+04, 9.4007277167E+00, 5.3753507718E+00, 1.1837964264E+00, 8.7939227208E-01, 7.4237220168E-01],
	[1.7845000000E+04, 9.4044987786E+00, 5.3751478428E+00, 1.1848570048E+00, 8.8000499656E-01, 7.4248414540E-01],
	[1.7850000000E+04, 9.4082702962E+00, 5.3749449782E+00, 1.1859182353E+00, 8.8061786499E-01, 7.4259605333E-01],
	[1.7855000000E+04, 9.4120422693E+00, 5.3747421782E+00, 1.1869801179E+00, 8.8123087721E-01, 7.4270792548E-01],
	[1.7860000000E+04, 9.4158146980E+00, 5.3745394425E+00, 1.1880426530E+00, 8.8184403306E-01, 7.4281976184E-01],
	[1.7865000000E+04, 9.4195875820E+00, 5.3743367713E+00, 1.1891058407E+00, 8.8245733239E-01, 7.4293156240E-01],
	[1.7870000000E+04, 9.4233609214E+00, 5.3741341644E+00, 1.1901696814E+00, 8.8307077504E-01, 7.4304332715E-01],
	[1.7875000000E+04, 9.4271347161E+00, 5.3739316218E+00, 1.1912341751E+00, 8.8368436085E-01, 7.4315505611E-01],
	[1.7880000000E+04, 9.4309089660E+00, 5.3737291435E+00, 1.1922993222E+00, 8.8429808966E-01, 7.4326674925E-01],
	[1.7885000000E+04, 9.4346836710E+00, 5.3735267294E+00, 1.1933651227E+00, 8.8491196132E-01, 7.4337840658E-01],
	[1.7890000000E+04, 9.4384588311E+00, 5.3733243796E+00, 1.1944315771E+00, 8.8552597567E-01, 7.4349002809E-01],
	[1.7895000000E+04, 9.4422344462E+00, 5.3731220939E+00, 1.1954986854E+00, 8.8614013254E-01, 7.4360161378E-01],
	[1.7900000000E+04, 9.4460105162E+00, 5.3729198723E+00, 1.1965664479E+00, 8.8675443178E-01, 7.4371316364E-01],
	[1.7905000000E+04, 9.4497870410E+00, 5.3727177148E+00, 1.1976348648E+00, 8.8736887324E-01, 7.4382467767E-01],
	[1.7910000000E+04, 9.4535640206E+00, 5.3725156213E+00, 1.1987039363E+00, 8.8798345675E-01, 7.4393615587E-01],
	[1.7915000000E+04, 9.4573414549E+00, 5.3723135919E+00, 1.1997736626E+00, 8.8859818215E-01, 7.4404759822E-01],
	[1.7920000000E+04, 9.4611193439E+00, 5.3721116265E+00, 1.2008440441E+00, 8.8921304929E-01, 7.4415900473E-01],
	[1.7925000000E+04, 9.4648976874E+00, 5.3719097249E+00, 1.2019150808E+00, 8.8982805801E-01, 7.4427037539E-01],
	[1.7930000000E+04, 9.4686764853E+00, 5.3717078873E+00, 1.2029867729E+00, 8.9044320814E-01, 7.4438171020E-01],
	[1.7935000000E+04, 9.4724557377E+00, 5.3715061135E+00, 1.2040591208E+00, 8.9105849954E-01, 7.4449300916E-01],
	[1.7940000000E+04, 9.4762354445E+00, 5.3713044036E+00, 1.2051321247E+00, 8.9167393204E-01, 7.4460427225E-01],
	[1.7945000000E+04, 9.4800297040E+00, 5.3711075735E+00, 1.2062057846E+00, 8.9228976330E-01, 7.4471549947E-01],
	[1.7950000000E+04, 9.4838260899E+00, 5.3709113738E+00, 1.2072801010E+00, 8.9290576637E-01, 7.4482669083E-01],
	[1.7955000000E+04, 9.4876229380E+00, 5.3707152360E+00, 1.2083550739E+00, 8.9352191067E-01, 7.4493784632E-01],
	[1.7960000000E+04, 9.4914202484E+00, 5.3705191600E+00, 1.2094307036E+00, 8.9413819606E-01, 7.4504896592E-01],
	[1.7965000000E+04, 9.4952180210E+00, 5.3703231457E+00, 1.2105069903E+00, 8.9475462237E-01, 7.4516004965E-01],
	[1.7970000000E+04, 9.4990162557E+00, 5.3701271930E+00, 1.2115839343E+00, 8.9537118945E-01, 7.4527109749E-01],
	[1.7975000000E+04, 9.5028149525E+00, 5.3699313021E+00, 1.2126615357E+00, 8.9598789713E-01, 7.4538210944E-01],
	[1.7980000000E+04, 9.5066141112E+00, 5.3697354728E+00, 1.2137397947E+00, 8.9660474527E-01, 7.4549308550E-01],
	[1.7985000000E+04, 9.5104137318E+00, 5.3695397050E+00, 1.2148187117E+00, 8.9722173369E-01, 7.4560402567E-01],
	[1.7990000000E+04, 9.5142138142E+00, 5.3693439988E+00, 1.2158982868E+00, 8.9783886225E-01, 7.4571492993E-01],
	[1.7995000000E+04, 9.5180143584E+00, 5.3691483542E+00, 1.2169785202E+00, 8.9845613078E-01, 7.4582579829E-01],
	[1.8000000000E+04, 9.5218153643E+00, 5.3689527710E+00, 1.2180594121E+00, 8.9907353913E-01, 7.4593663074E-01],
	[1.8005000000E+04, 9.5256168317E+00, 5.3687572492E+00, 1.2191409628E+00, 8.9969108713E-01, 7.4604742728E-01],
	[1.8010000000E+04, 9.5294187607E+00, 5.3685617889E+00, 1.2202231724E+00, 9.0030877463E-01, 7.4615818791E-01],
	[1.8015000000E+04, 9.5332211512E+00, 5.3683663899E+00, 1.2213060413E+00, 9.0092660147E-01, 7.4626891261E-01],
	[1.8020000000E+04, 9.5370240030E+00, 5.3681710522E+00, 1.2223895696E+00, 9.0154456749E-01, 7.4637960140E-01],
	[1.8025000000E+04, 9.5408273162E+00, 5.3679757759E+00, 1.2234737575E+00, 9.0216267252E-01, 7.4649025426E-01],
	[1.8030000000E+04, 9.5446310906E+00, 5.3677805608E+00, 1.2245586052E+00, 9.0278091642E-01, 7.4660087118E-01],
	[1.8035000000E+04, 9.5484353262E+00, 5.3675854069E+00, 1.2256441130E+00, 9.0339929902E-01, 7.4671145218E-01],
	[1.8040000000E+04, 9.5522400229E+00, 5.3673903143E+00, 1.2267302811E+00, 9.0401782017E-01, 7.4682199723E-01],
	[1.8045000000E+04, 9.5560451806E+00, 5.3671952828E+00, 1.2278171097E+00, 9.0463647969E-01, 7.4693250635E-01],
	[1.8050000000E+04, 9.5598507993E+00, 5.3670003124E+00, 1.2289045990E+00, 9.0525527745E-01, 7.4704297952E-01],
	[1.8055000000E+04, 9.5636568788E+00, 5.3668054030E+00, 1.2299927492E+00, 9.0587421327E-01, 7.4715341675E-01],
	[1.8060000000E+04, 9.5674634192E+00, 5.3666105548E+00, 1.2310815606E+00, 9.0649328699E-01, 7.4726381803E-01],
	[1.8065000000E+04, 9.5712704203E+00, 5.3664157675E+00, 1.2321710334E+00, 9.0711249846E-01, 7.4737418335E-01],
	[1.8070000000E+04, 9.5750778821E+00, 5.3662210412E+00, 1.2332611677E+00, 9.0773184752E-01, 7.4748451271E-01],
	[1.8075000000E+04, 9.5788858045E+00, 5.3660263758E+00, 1.2343519639E+00, 9.0835133401E-01, 7.4759480611E-01],
	[1.8080000000E+04, 9.5826941874E+00, 5.3658317714E+00, 1.2354434221E+00, 9.0897095777E-01, 7.4770506355E-01],
	[1.8085000000E+04, 9.5865030307E+00, 5.3656372278E+00, 1.2365355425E+00, 9.0959071864E-01, 7.4781528502E-01],
	[1.8090000000E+04, 9.5903123345E+00, 5.3654427450E+00, 1.2376283254E+00, 9.1021061645E-01, 7.4792547053E-01],
	[1.8095000000E+04, 9.5941220985E+00, 5.3652483231E+00, 1.2387217710E+00, 9.1083065106E-01, 7.4803562005E-01],
	[1.8100000000E+04, 9.5979323228E+00, 5.3650539618E+00, 1.2398158795E+00, 9.1145082230E-01, 7.4814573360E-01],
	[1.8105000000E+04, 9.6017430073E+00, 5.3648596614E+00, 1.2409106510E+00, 9.1207113000E-01, 7.4825581117E-01],
	[1.8110000000E+04, 9.6055541519E+00, 5.3646654215E+00, 1.2420060860E+00, 9.1269157402E-01, 7.4836585276E-01],
	[1.8115000000E+04, 9.6093657565E+00, 5.3644712424E+00, 1.2431021844E+00, 9.1331215419E-01, 7.4847585836E-01],
	[1.8120000000E+04, 9.6131778210E+00, 5.3642771238E+00, 1.2441989467E+00, 9.1393287036E-01, 7.4858582797E-01],
	[1.8125000000E+04, 9.6169903454E+00, 5.3640830659E+00, 1.2452963729E+00, 9.1455372235E-01, 7.4869576159E-01],
	[1.8130000000E+04, 9.6208033297E+00, 5.3638890685E+00, 1.2463944633E+00, 9.1517471001E-01, 7.4880565921E-01],
	[1.8135000000E+04, 9.6246167736E+00, 5.3636951316E+00, 1.2474932182E+00, 9.1579583319E-01, 7.4891552084E-01],
	[1.8140000000E+04, 9.6284306773E+00, 5.3635012551E+00, 1.2485926376E+00, 9.1641709172E-01, 7.4902534646E-01],
	[1.8145000000E+04, 9.6322450405E+00, 5.3633074391E+00, 1.2496927220E+00, 9.1703848544E-01, 7.4913513608E-01],
	[1.8150000000E+04, 9.6360598633E+00, 5.3631136835E+00, 1.2507934714E+00, 9.1766001419E-01, 7.4924488969E-01],
	[1.8155000000E+04, 9.6398751455E+00, 5.3629199883E+00, 1.2518948861E+00, 9.1828167781E-01, 7.4935460729E-01],
	[1.8160000000E+04, 9.6436908871E+00, 5.3627263534E+00, 1.2529969664E+00, 9.1890347615E-01, 7.4946428888E-01],
	[1.8165000000E+04, 9.6475070881E+00, 5.3625327788E+00, 1.2540997123E+00, 9.1952540904E-01, 7.4957393445E-01],
	[1.8170000000E+04, 9.6513237482E+00, 5.3623392644E+00, 1.2552031243E+00, 9.2014747631E-01, 7.4968354401E-01],
	[1.8175000000E+04, 9.6551408675E+00, 5.3621458103E+00, 1.2563072024E+00, 9.2076967782E-01, 7.4979311754E-01],
	[1.8180000000E+04, 9.6589584460E+00, 5.3619524163E+00, 1.2574119468E+00, 9.2139201340E-01, 7.4990265505E-01],
	[1.8185000000E+04, 9.6627764834E+00, 5.3617590825E+00, 1.2585173579E+00, 9.2201448288E-01, 7.5001215653E-01],
	[1.8190000000E+04, 9.6665949798E+00, 5.3615658089E+00, 1.2596234358E+00, 9.2263708612E-01, 7.5012162198E-01],
	[1.8195000000E+04, 9.6704139351E+00, 5.3613725953E+00, 1.2607301807E+00, 9.2325982295E-01, 7.5023105140E-01],
	[1.8200000000E+04, 9.6742333493E+00, 5.3611794418E+00, 1.2618375929E+00, 9.2388269320E-01, 7.5034044478E-01],
	[1.8205000000E+04, 9.6780532221E+00, 5.3609863482E+00, 1.2629456726E+00, 9.2450569672E-01, 7.5044980213E-01],
	[1.8210000000E+04, 9.6818735536E+00, 5.3607933147E+00, 1.2640544200E+00, 9.2512883335E-01, 7.5055912343E-01],
	[1.8215000000E+04, 9.6856943438E+00, 5.3606003411E+00, 1.2651638352E+00, 9.2575210292E-01, 7.5066840870E-01],
	[1.8220000000E+04, 9.6895155924E+00, 5.3604074274E+00, 1.2662739186E+00, 9.2637550529E-01, 7.5077765792E-01],
	[1.8225000000E+04, 9.6933372996E+00, 5.3602145736E+00, 1.2673846704E+00, 9.2699904027E-01, 7.5088687109E-01],
	[1.8230000000E+04, 9.6971615839E+00, 5.3600224735E+00, 1.2684960907E+00, 9.2762274789E-01, 7.5099604821E-01],
	[1.8235000000E+04, 9.7010004108E+00, 5.3598350430E+00, 1.2696081798E+00, 9.2824685512E-01, 7.5110518928E-01],
	[1.8240000000E+04, 9.7048397043E+00, 5.3596476706E+00, 1.2707209380E+00, 9.2887109512E-01, 7.5121429429E-01],
	[1.8245000000E+04, 9.7086794644E+00, 5.3594603560E+00, 1.2718343653E+00, 9.2949546774E-01, 7.5132336325E-01],
	[1.8250000000E+04, 9.7125196909E+00, 5.3592730993E+00, 1.2729484621E+00, 9.3011997282E-01, 7.5143239614E-01],
	[1.8255000000E+04, 9.7163603838E+00, 5.3590859004E+00, 1.2740632285E+00, 9.3074461020E-01, 7.5154139298E-01],
	[1.8260000000E+04, 9.7202015431E+00, 5.3588987594E+00, 1.2751786648E+00, 9.3136937972E-01, 7.5165035375E-01],
	[1.8265000000E+04, 9.7240431685E+00, 5.3587116761E+00, 1.2762947713E+00, 9.3199428121E-01, 7.5175927845E-01],
	[1.8270000000E+04, 9.7278852602E+00, 5.3585246505E+00, 1.2774115480E+00, 9.3261931453E-01, 7.5186816708E-01],
	[1.8275000000E+04, 9.7317278179E+00, 5.3583376826E+00, 1.2785289953E+00, 9.3324447949E-01, 7.5197701964E-01],
	[1.8280000000E+04, 9.7355708417E+00, 5.3581507724E+00, 1.2796471133E+00, 9.3386977596E-01, 7.5208583613E-01],
	[1.8285000000E+04, 9.7394143315E+00, 5.3579639199E+00, 1.2807659022E+00, 9.3449520375E-01, 7.5219461655E-01],
	[1.8290000000E+04, 9.7432582871E+00, 5.3577771249E+00, 1.2818853624E+00, 9.3512076272E-01, 7.5230336088E-01],
	[1.8295000000E+04, 9.7471027085E+00, 5.3575903875E+00, 1.2830054940E+00, 9.3574645271E-01, 7.5241206914E-01],
	[1.8300000000E+04, 9.7509475958E+00, 5.3574037077E+00, 1.2841262972E+00, 9.3637227355E-01, 7.5252074131E-01],
	[1.8305000000E+04, 9.7547929486E+00, 5.3572170853E+00, 1.2852477722E+00, 9.3699822508E-01, 7.5262937740E-01],
	[1.8310000000E+04, 9.7586387671E+00, 5.3570305204E+00, 1.2863699193E+00, 9.3762430714E-01, 7.5273797741E-01],
	[1.8315000000E+04, 9.7624850512E+00, 5.3568440130E+00, 1.2874927387E+00, 9.3825051957E-01, 7.5284654133E-01],
	[1.8320000000E+04, 9.7663318007E+00, 5.3566575629E+00, 1.2886162306E+00, 9.3887686220E-01, 7.5295506915E-01],
	[1.8325000000E+04, 9.7701790155E+00, 5.3564711703E+00, 1.2897403952E+00, 9.3950333489E-01, 7.5306356089E-01],
	[1.8330000000E+04, 9.7740266958E+00, 5.3562848349E+00, 1.2908652327E+00, 9.4012993746E-01, 7.5317201653E-01],
	[1.8335000000E+04, 9.7778748412E+00, 5.3560985569E+00, 1.2919907434E+00, 9.4075666976E-01, 7.5328043607E-01],
	[1.8340000000E+04, 9.7817234519E+00, 5.3559123361E+00, 1.2931169275E+00, 9.4138353163E-01, 7.5338881952E-01],
	[1.8345000000E+04, 9.7855725276E+00, 5.3557261725E+00, 1.2942437851E+00, 9.4201052290E-01, 7.5349716686E-01],
	[1.8350000000E+04, 9.7894220684E+00, 5.3555400662E+00, 1.2953713166E+00, 9.4263764341E-01, 7.5360547811E-01],
	[1.8355000000E+04, 9.7932720742E+00, 5.3553540170E+00, 1.2964995221E+00, 9.4326489300E-01, 7.5371375325E-01],
	[1.8360000000E+04, 9.7971225449E+00, 5.3551680249E+00, 1.2976284018E+00, 9.4389227151E-01, 7.5382199229E-01],
	[1.8365000000E+04, 9.8009734804E+00, 5.3549820900E+00, 1.2987579560E+00, 9.4451977878E-01, 7.5393019522E-01],
	[1.8370000000E+04, 9.8048248807E+00, 5.3547962121E+00, 1.2998881849E+00, 9.4514741465E-01, 7.5403836204E-01],
	[1.8375000000E+04, 9.8086767456E+00, 5.3546103913E+00, 1.3010190886E+00, 9.4577517895E-01, 7.5414649276E-01],
	[1.8380000000E+04, 9.8125290752E+00, 5.3544246274E+00, 1.3021506675E+00, 9.4640307153E-01, 7.5425458736E-01],
	[1.8385000000E+04, 9.8163818693E+00, 5.3542389206E+00, 1.3032829218E+00, 9.4703109223E-01, 7.5436264584E-01],
	[1.8390000000E+04, 9.8202351280E+00, 5.3540532706E+00, 1.3044158516E+00, 9.4765924087E-01, 7.5447066821E-01],
	[1.8395000000E+04, 9.8240888510E+00, 5.3538676776E+00, 1.3055494572E+00, 9.4828751730E-01, 7.5457865447E-01],
	[1.8400000000E+04, 9.8279430383E+00, 5.3536821414E+00, 1.3066837387E+00, 9.4891592137E-01, 7.5468660461E-01],
	[1.8405000000E+04, 9.8317976899E+00, 5.3534966621E+00, 1.3078186965E+00, 9.4954445290E-01, 7.5479451862E-01],
	[1.8410000000E+04, 9.8356528058E+00, 5.3533112396E+00, 1.3089543307E+00, 9.5017311173E-01, 7.5490239652E-01],
	[1.8415000000E+04, 9.8395083857E+00, 5.3531258738E+00, 1.3100906416E+00, 9.5080189771E-01, 7.5501023829E-01],
	[1.8420000000E+04, 9.8433644297E+00, 5.3529405648E+00, 1.3112276293E+00, 9.5143081067E-01, 7.5511804394E-01],
	[1.8425000000E+04, 9.8472209377E+00, 5.3527553125E+00, 1.3123652941E+00, 9.5205985046E-01, 7.5522581346E-01],
	[1.8430000000E+04, 9.8510779096E+00, 5.3525701169E+00, 1.3135036363E+00, 9.5268901690E-01, 7.5533354686E-01],
	[1.8435000000E+04, 9.8549353453E+00, 5.3523849779E+00, 1.3146426559E+00, 9.5331830984E-01, 7.5544124412E-01],
	[1.8440000000E+04, 9.8587932449E+00, 5.3521998955E+00, 1.3157823533E+00, 9.5394772911E-01, 7.5554890514E-01],
	[1.8445000000E+04, 9.8626516081E+00, 5.3520148697E+00, 1.3169227287E+00, 9.5457727456E-01, 7.5565652982E-01],
	[1.8450000000E+04, 9.8665104350E+00, 5.3518299005E+00, 1.3180637822E+00, 9.5520694601E-01, 7.5576411816E-01],
	[1.8455000000E+04, 9.8703697254E+00, 5.3516449877E+00, 1.3192055142E+00, 9.5583674332E-01, 7.5587167017E-01],
	[1.8460000000E+04, 9.8742294793E+00, 5.3514601315E+00, 1.3203479247E+00, 9.5646666632E-01, 7.5597918586E-01],
	[1.8465000000E+04, 9.8780896967E+00, 5.3512753316E+00, 1.3214910141E+00, 9.5709671484E-01, 7.5608666521E-01],
	[1.8470000000E+04, 9.8819503774E+00, 5.3510905882E+00, 1.3226347826E+00, 9.5772688872E-01, 7.5619410823E-01],
	[1.8475000000E+04, 9.8858115214E+00, 5.3509059012E+00, 1.3237792303E+00, 9.5835718780E-01, 7.5630151494E-01],
	[1.8480000000E+04, 9.8896731286E+00, 5.3507212705E+00, 1.3249243575E+00, 9.5898761193E-01, 7.5640888532E-01],
	[1.8485000000E+04, 9.8935351990E+00, 5.3505366961E+00, 1.3260701645E+00, 9.5961816093E-01, 7.5651621938E-01],
	[1.8490000000E+04, 9.8973977325E+00, 5.3503521780E+00, 1.3272166513E+00, 9.6024883465E-01, 7.5662351712E-01],
	[1.8495000000E+04, 9.9012607289E+00, 5.3501677162E+00, 1.3283638184E+00, 9.6087963292E-01, 7.5673077855E-01],
	[1.8500000000E+04, 9.9051241883E+00, 5.3499833106E+00, 1.3295116658E+00, 9.6151055558E-01, 7.5683800366E-01],
	[1.8505000000E+04, 9.9089881106E+00, 5.3497989612E+00, 1.3306601937E+00, 9.6214160247E-01, 7.5694519247E-01],
	[1.8510000000E+04, 9.9128524956E+00, 5.3496146679E+00, 1.3318094025E+00, 9.6277277342E-01, 7.5705234496E-01],
	[1.8515000000E+04, 9.9167173434E+00, 5.3494304307E+00, 1.3329592923E+00, 9.6340406828E-01, 7.5715946115E-01],
	[1.8520000000E+04, 9.9205826539E+00, 5.3492462497E+00, 1.3341098634E+00, 9.6403548688E-01, 7.5726654104E-01],
	[1.8525000000E+04, 9.9244557055E+00, 5.3490644096E+00, 1.3352611159E+00, 9.6466717214E-01, 7.5737358462E-01],
	[1.8530000000E+04, 9.9283385925E+00, 5.3488855648E+00, 1.3364130501E+00, 9.6529916543E-01, 7.5748059190E-01],
	[1.8535000000E+04, 9.9322219504E+00, 5.3487067743E+00, 1.3375656662E+00, 9.6593128263E-01, 7.5758756289E-01],
	[1.8540000000E+04, 9.9361057792E+00, 5.3485280379E+00, 1.3387189644E+00, 9.6656352357E-01, 7.5769449759E-01],
	[1.8545000000E+04, 9.9399900789E+00, 5.3483493557E+00, 1.3398729450E+00, 9.6719588811E-01, 7.5780139599E-01],
	[1.8550000000E+04, 9.9438748493E+00, 5.3481707277E+00, 1.3410276081E+00, 9.6782837607E-01, 7.5790825810E-01],
	[1.8555000000E+04, 9.9477600903E+00, 5.3479921537E+00, 1.3421829540E+00, 9.6846098730E-01, 7.5801508392E-01],
	[1.8560000000E+04, 9.9516458020E+00, 5.3478136339E+00, 1.3433389829E+00, 9.6909372163E-01, 7.5812187346E-01],
	[1.8565000000E+04, 9.9555319842E+00, 5.3476351681E+00, 1.3444956950E+00, 9.6972657890E-01, 7.5822862672E-01],
	[1.8570000000E+04, 9.9594186369E+00, 5.3474567562E+00, 1.3456530906E+00, 9.7035955895E-01, 7.5833534370E-01],
	[1.8575000000E+04, 9.9633057599E+00, 5.3472783984E+00, 1.3468111698E+00, 9.7099266161E-01, 7.5844202440E-01],
	[1.8580000000E+04, 9.9671933533E+00, 5.3471000945E+00, 1.3479699328E+00, 9.7162588673E-01, 7.5854866883E-01],
	[1.8585000000E+04, 9.9710814170E+00, 5.3469218446E+00, 1.3491293800E+00, 9.7225923414E-01, 7.5865527699E-01],
	[1.8590000000E+04, 9.9749699508E+00, 5.3467436485E+00, 1.3502895115E+00, 9.7289270368E-01, 7.5876184887E-01],
	[1.8595000000E+04, 9.9788589547E+00, 5.3465655063E+00, 1.3514503275E+00, 9.7352629518E-01, 7.5886838449E-01],
	[1.8600000000E+04, 9.9827484287E+00, 5.3463874179E+00, 1.3526118282E+00, 9.7416000849E-01, 7.5897488385E-01],
	[1.8605000000E+04, 9.9866383727E+00, 5.3462093833E+00, 1.3537740140E+00, 9.7479384344E-01, 7.5908134694E-01],
	[1.8610000000E+04, 9.9905287866E+00, 5.3460314024E+00, 1.3549368849E+00, 9.7542779987E-01, 7.5918777378E-01],
	[1.8615000000E+04, 9.9944196703E+00, 5.3458534753E+00, 1.3561004412E+00, 9.7606187762E-01, 7.5929416436E-01],
	[1.8620000000E+04, 9.9983110238E+00, 5.3456756020E+00, 1.3572646831E+00, 9.7669607652E-01, 7.5940051868E-01],
	[1.8625000000E+04, 1.0002202847E+01, 5.3454977822E+00, 1.3584296109E+00, 9.7733039642E-01, 7.5950683676E-01],
	[1.8630000000E+04, 1.0006095140E+01, 5.3453200162E+00, 1.3595952247E+00, 9.7796483714E-01, 7.5961311858E-01],
	[1.8635000000E+04, 1.0009987902E+01, 5.3451423037E+00, 1.3607615248E+00, 9.7859939854E-01, 7.5971936416E-01],
	[1.8640000000E+04, 1.0013881134E+01, 5.3449646448E+00, 1.3619285115E+00, 9.7923408043E-01, 7.5982557350E-01],
	[1.8645000000E+04, 1.0017774835E+01, 5.3447870395E+00, 1.3630961848E+00, 9.7986888267E-01, 7.5993174660E-01],
	[1.8650000000E+04, 1.0021669006E+01, 5.3446094877E+00, 1.3642645451E+00, 9.8050380509E-01, 7.6003788347E-01],
	[1.8655000000E+04, 1.0025563646E+01, 5.3444319894E+00, 1.3654335925E+00, 9.8113884753E-01, 7.6014398410E-01],
	[1.8660000000E+04, 1.0029458755E+01, 5.3442545445E+00, 1.3666033274E+00, 9.8177400982E-01, 7.6025004849E-01],
	[1.8665000000E+04, 1.0033354333E+01, 5.3440771531E+00, 1.3677737498E+00, 9.8240929180E-01, 7.6035607666E-01],
	[1.8670000000E+04, 1.0037250381E+01, 5.3438998151E+00, 1.3689448600E+00, 9.8304469331E-01, 7.6046206861E-01],
	[1.8675000000E+04, 1.0041146897E+01, 5.3437225304E+00, 1.3701166583E+00, 9.8368021418E-01, 7.6056802433E-01],
	[1.8680000000E+04, 1.0045043882E+01, 5.3435452991E+00, 1.3712891448E+00, 9.8431585426E-01, 7.6067394383E-01],
	[1.8685000000E+04, 1.0048941337E+01, 5.3433681211E+00, 1.3724623198E+00, 9.8495161338E-01, 7.6077982711E-01],
	[1.8690000000E+04, 1.0052839260E+01, 5.3431909963E+00, 1.3736361835E+00, 9.8558749138E-01, 7.6088567419E-01],
	[1.8695000000E+04, 1.0056737651E+01, 5.3430139249E+00, 1.3748107361E+00, 9.8622348809E-01, 7.6099148505E-01],
	[1.8700000000E+04, 1.0060636512E+01, 5.3428369066E+00, 1.3759859779E+00, 9.8685960336E-01, 7.6109725970E-01],
	[1.8705000000E+04, 1.0064535841E+01, 5.3426599415E+00, 1.3771619089E+00, 9.8749583701E-01, 7.6120299815E-01],
	[1.8710000000E+04, 1.0068435638E+01, 5.3424830296E+00, 1.3783385981E+00, 9.8813222407E-01, 7.6130870039E-01],
	[1.8715000000E+04, 1.0072335904E+01, 5.3423061708E+00, 1.3795161100E+00, 9.8876879753E-01, 7.6141436644E-01],
	[1.8720000000E+04, 1.0076236638E+01, 5.3421293651E+00, 1.3806943123E+00, 9.8940548897E-01, 7.6151999629E-01],
	[1.8725000000E+04, 1.0080137841E+01, 5.3419526124E+00, 1.3818732052E+00, 9.9004229821E-01, 7.6162558995E-01],
	[1.8730000000E+04, 1.0084039512E+01, 5.3417759128E+00, 1.3830527888E+00, 9.9067922509E-01, 7.6173114742E-01],
	[1.8735000000E+04, 1.0087941651E+01, 5.3415992663E+00, 1.3842330633E+00, 9.9131626946E-01, 7.6183666870E-01],
	[1.8740000000E+04, 1.0091844258E+01, 5.3414226726E+00, 1.3854140291E+00, 9.9195343114E-01, 7.6194215380E-01],
	[1.8745000000E+04, 1.0095747333E+01, 5.3412461320E+00, 1.3865956862E+00, 9.9259070998E-01, 7.6204760272E-01],
	[1.8750000000E+04, 1.0099650876E+01, 5.3410696442E+00, 1.3877780350E+00, 9.9322810581E-01, 7.6215301546E-01],
	[1.8755000000E+04, 1.0103554888E+01, 5.3408932093E+00, 1.3889610757E+00, 9.9386561847E-01, 7.6225839203E-01],
	[1.8760000000E+04, 1.0107459366E+01, 5.3407168273E+00, 1.3901448084E+00, 9.9450324779E-01, 7.6236373243E-01],
	[1.8765000000E+04, 1.0111364313E+01, 5.3405404982E+00, 1.3913292335E+00, 9.9514099361E-01, 7.6246903666E-01],
	[1.8770000000E+04, 1.0115269728E+01, 5.3403642218E+00, 1.3925143510E+00, 9.9577885578E-01, 7.6257430473E-01],
	[1.8775000000E+04, 1.0119175610E+01, 5.3401879981E+00, 1.3937001612E+00, 9.9641683411E-01, 7.6267953663E-01],
	[1.8780000000E+04, 1.0123081959E+01, 5.3400118273E+00, 1.3948866645E+00, 9.9705492846E-01, 7.6278473238E-01],
	[1.8785000000E+04, 1.0126988776E+01, 5.3398357091E+00, 1.3960738608E+00, 9.9769313866E-01, 7.6288989197E-01],
	[1.8790000000E+04, 1.0130896061E+01, 5.3396596436E+00, 1.3972617506E+00, 9.9833146454E-01, 7.6299501541E-01],
	[1.8795000000E+04, 1.0134803813E+01, 5.3394836307E+00, 1.3984503340E+00, 9.9896990595E-01, 7.6310010271E-01],
	[1.8800000000E+04, 1.0138712032E+01, 5.3393076705E+00, 1.3996396112E+00, 9.9960846271E-01, 7.6320515386E-01],
	[1.8805000000E+04, 1.0142620718E+01, 5.3391317629E+00, 1.4008295825E+00, 1.0002471347E+00, 7.6331016887E-01],
	[1.8810000000E+04, 1.0146529872E+01, 5.3389559078E+00, 1.4020202480E+00, 1.0008859217E+00, 7.6341514774E-01],
	[1.8815000000E+04, 1.0150439492E+01, 5.3387801052E+00, 1.4032116080E+00, 1.0015248235E+00, 7.6352009047E-01],
	[1.8820000000E+04, 1.0154349580E+01, 5.3386043552E+00, 1.4044036627E+00, 1.0021638401E+00, 7.6362499708E-01],
	[1.8825000000E+04, 1.0158273795E+01, 5.3384327697E+00, 1.4055964124E+00, 1.0028032494E+00, 7.6372986756E-01],
	[1.8830000000E+04, 1.0162201924E+01, 5.3382622706E+00, 1.4067898572E+00, 1.0034428437E+00, 7.6383470191E-01],
	[1.8835000000E+04, 1.0166130528E+01, 5.3380918222E+00, 1.4079839974E+00, 1.0040825530E+00, 7.6393950014E-01],
	[1.8840000000E+04, 1.0170059608E+01, 5.3379214244E+00, 1.4091788331E+00, 1.0047223770E+00, 7.6404426226E-01],
	[1.8845000000E+04, 1.0173989163E+01, 5.3377510773E+00, 1.4103743647E+00, 1.0053623155E+00, 7.6414898826E-01],
	[1.8850000000E+04, 1.0177919193E+01, 5.3375807809E+00, 1.4115705923E+00, 1.0060023685E+00, 7.6425367815E-01],
	[1.8855000000E+04, 1.0181849699E+01, 5.3374105350E+00, 1.4127675161E+00, 1.0066425357E+00, 7.6435833193E-01],
	[1.8860000000E+04, 1.0185780680E+01, 5.3372403397E+00, 1.4139651364E+00, 1.0072828170E+00, 7.6446294962E-01],
	[1.8865000000E+04, 1.0189712135E+01, 5.3370701950E+00, 1.4151634534E+00, 1.0079232121E+00, 7.6456753120E-01],
	[1.8870000000E+04, 1.0193644066E+01, 5.3369001007E+00, 1.4163624673E+00, 1.0085637211E+00, 7.6467207668E-01],
	[1.8875000000E+04, 1.0197576472E+01, 5.3367300569E+00, 1.4175621784E+00, 1.0092043436E+00, 7.6477658608E-01],
	[1.8880000000E+04, 1.0201509352E+01, 5.3365600636E+00, 1.4187625867E+00, 1.0098450795E+00, 7.6488105938E-01],
	[1.8885000000E+04, 1.0205442708E+01, 5.3363901207E+00, 1.4199636927E+00, 1.0104859287E+00, 7.6498549660E-01],
	[1.8890000000E+04, 1.0209376538E+01, 5.3362202283E+00, 1.4211654964E+00, 1.0111268910E+00, 7.6508989773E-01],
	[1.8895000000E+04, 1.0213310842E+01, 5.3360503861E+00, 1.4223679981E+00, 1.0117679663E+00, 7.6519426279E-01],
	[1.8900000000E+04, 1.0217245621E+01, 5.3358805944E+00, 1.4235711981E+00, 1.0124091543E+00, 7.6529859178E-01],
	[1.8905000000E+04, 1.0221180875E+01, 5.3357108529E+00, 1.4247750965E+00, 1.0130504549E+00, 7.6540288469E-01],
	[1.8910000000E+04, 1.0225116603E+01, 5.3355411617E+00, 1.4259796936E+00, 1.0136918679E+00, 7.6550714154E-01],
	[1.8915000000E+04, 1.0229052806E+01, 5.3353715208E+00, 1.4271849895E+00, 1.0143333933E+00, 7.6561136232E-01],
	[1.8920000000E+04, 1.0232989482E+01, 5.3352019301E+00, 1.4283909846E+00, 1.0149750307E+00, 7.6571554705E-01],
	[1.8925000000E+04, 1.0236926633E+01, 5.3350323896E+00, 1.4295976790E+00, 1.0156167801E+00, 7.6581969571E-01],
	[1.8930000000E+04, 1.0240864259E+01, 5.3348628993E+00, 1.4308050729E+00, 1.0162586413E+00, 7.6592380833E-01],
	[1.8935000000E+04, 1.0244802358E+01, 5.3346934591E+00, 1.4320131666E+00, 1.0169006141E+00, 7.6602788490E-01],
	[1.8940000000E+04, 1.0248740931E+01, 5.3345240691E+00, 1.4332219603E+00, 1.0175426984E+00, 7.6613192542E-01],
	[1.8945000000E+04, 1.0252679978E+01, 5.3343547291E+00, 1.4344314542E+00, 1.0181848940E+00, 7.6623592990E-01],
	[1.8950000000E+04, 1.0256619499E+01, 5.3341854392E+00, 1.4356416485E+00, 1.0188272007E+00, 7.6633989835E-01],
	[1.8955000000E+04, 1.0260559494E+01, 5.3340161993E+00, 1.4368525434E+00, 1.0194696184E+00, 7.6644383076E-01],
	[1.8960000000E+04, 1.0264499963E+01, 5.3338470095E+00, 1.4380641393E+00, 1.0201121469E+00, 7.6654772715E-01],
	[1.8965000000E+04, 1.0268440906E+01, 5.3336778696E+00, 1.4392764362E+00, 1.0207547860E+00, 7.6665158750E-01],
	[1.8970000000E+04, 1.0272382322E+01, 5.3335087796E+00, 1.4404894344E+00, 1.0213975356E+00, 7.6675541184E-01],
	[1.8975000000E+04, 1.0276324211E+01, 5.3333397396E+00, 1.4417031341E+00, 1.0220403955E+00, 7.6685920016E-01],
	[1.8980000000E+04, 1.0280266574E+01, 5.3331707494E+00, 1.4429175356E+00, 1.0226833656E+00, 7.6696295247E-01],
	[1.8985000000E+04, 1.0284209411E+01, 5.3330018092E+00, 1.4441326391E+00, 1.0233264457E+00, 7.6706666876E-01],
	[1.8990000000E+04, 1.0288152720E+01, 5.3328329187E+00, 1.4453484447E+00, 1.0239696356E+00, 7.6717034905E-01],
	[1.8995000000E+04, 1.0292096503E+01, 5.3326640781E+00, 1.4465649528E+00, 1.0246129351E+00, 7.6727399334E-01],
	[1.9000000000E+04, 1.0296040760E+01, 5.3324952873E+00, 1.4477821634E+00, 1.0252563442E+00, 7.6737760164E-01],
	[1.9005000000E+04, 1.0299985489E+01, 5.3323265462E+00, 1.4490000769E+00, 1.0258998626E+00, 7.6748117393E-01],
	[1.9010000000E+04, 1.0303930692E+01, 5.3321578548E+00, 1.4502186935E+00, 1.0265434901E+00, 7.6758471024E-01],
	[1.9015000000E+04, 1.0307876367E+01, 5.3319892131E+00, 1.4514380134E+00, 1.0271872267E+00, 7.6768821056E-01],
	[1.9020000000E+04, 1.0311822516E+01, 5.3318206211E+00, 1.4526580368E+00, 1.0278310721E+00, 7.6779167490E-01],
	[1.9025000000E+04, 1.0315769137E+01, 5.3316520788E+00, 1.4538787639E+00, 1.0284750262E+00, 7.6789510327E-01],
	[1.9030000000E+04, 1.0319716231E+01, 5.3314835860E+00, 1.4551001950E+00, 1.0291190888E+00, 7.6799849566E-01],
	[1.9035000000E+04, 1.0323663798E+01, 5.3313151429E+00, 1.4563223302E+00, 1.0297632597E+00, 7.6810185208E-01],
	[1.9040000000E+04, 1.0327611837E+01, 5.3311467493E+00, 1.4575451698E+00, 1.0304075388E+00, 7.6820517254E-01],
	[1.9045000000E+04, 1.0331560349E+01, 5.3309784052E+00, 1.4587687140E+00, 1.0310519260E+00, 7.6830845703E-01],
	[1.9050000000E+04, 1.0335509334E+01, 5.3308101107E+00, 1.4599929631E+00, 1.0316964210E+00, 7.6841170557E-01],
	[1.9055000000E+04, 1.0339458791E+01, 5.3306418656E+00, 1.4612179172E+00, 1.0323410237E+00, 7.6851491815E-01],
	[1.9060000000E+04, 1.0343408721E+01, 5.3304736700E+00, 1.4624435765E+00, 1.0329857340E+00, 7.6861809479E-01],
	[1.9065000000E+04, 1.0347359123E+01, 5.3303055237E+00, 1.4636699414E+00, 1.0336305516E+00, 7.6872123548E-01],
	[1.9070000000E+04, 1.0351309997E+01, 5.3301374269E+00, 1.4648970119E+00, 1.0342754764E+00, 7.6882434023E-01],
	[1.9075000000E+04, 1.0355261343E+01, 5.3299693795E+00, 1.4661247884E+00, 1.0349205082E+00, 7.6892740905E-01],
	[1.9080000000E+04, 1.0359213161E+01, 5.3298013814E+00, 1.4673532711E+00, 1.0355656469E+00, 7.6903044193E-01],
	[1.9085000000E+04, 1.0363165452E+01, 5.3296334326E+00, 1.4685824601E+00, 1.0362108924E+00, 7.6913343889E-01],
	[1.9090000000E+04, 1.0367118214E+01, 5.3294655331E+00, 1.4698123557E+00, 1.0368562443E+00, 7.6923639992E-01],
	[1.9095000000E+04, 1.0371071449E+01, 5.3292976828E+00, 1.4710429581E+00, 1.0375017027E+00, 7.6933932504E-01],
	[1.9100000000E+04, 1.0375025155E+01, 5.3291298818E+00, 1.4722742676E+00, 1.0381472673E+00, 7.6944221424E-01],
	[1.9105000000E+04, 1.0378979333E+01, 5.3289621300E+00, 1.4735062843E+00, 1.0387929379E+00, 7.6954506753E-01],
	[1.9110000000E+04, 1.0382933983E+01, 5.3287944273E+00, 1.4747390084E+00, 1.0394387144E+00, 7.6964788491E-01],
	[1.9115000000E+04, 1.0386889104E+01, 5.3286267738E+00, 1.4759724403E+00, 1.0400845967E+00, 7.6975066639E-01],
	[1.9120000000E+04, 1.0390844697E+01, 5.3284591694E+00, 1.4772065801E+00, 1.0407305845E+00, 7.6985341198E-01],
	[1.9125000000E+04, 1.0394804279E+01, 5.3282926302E+00, 1.4784414280E+00, 1.0413767518E+00, 7.6995612167E-01],
	[1.9130000000E+04, 1.0398778378E+01, 5.3281301949E+00, 1.4796769843E+00, 1.0420233206E+00, 7.7005879548E-01],
	[1.9135000000E+04, 1.0402752957E+01, 5.3279678069E+00, 1.4809132491E+00, 1.0426699952E+00, 7.7016143340E-01],
	[1.9140000000E+04, 1.0406728016E+01, 5.3278054663E+00, 1.4821502227E+00, 1.0433167754E+00, 7.7026403544E-01],
	[1.9145000000E+04, 1.0410703555E+01, 5.3276431730E+00, 1.4833879054E+00, 1.0439636610E+00, 7.7036660160E-01],
	[1.9150000000E+04, 1.0414679574E+01, 5.3274809271E+00, 1.4846262973E+00, 1.0446106519E+00, 7.7046913190E-01],
	[1.9155000000E+04, 1.0418656073E+01, 5.3273187285E+00, 1.4858653986E+00, 1.0452577479E+00, 7.7057162632E-01],
	[1.9160000000E+04, 1.0422633052E+01, 5.3271565771E+00, 1.4871052096E+00, 1.0459049488E+00, 7.7067408489E-01],
	[1.9165000000E+04, 1.0426610511E+01, 5.3269944730E+00, 1.4883457305E+00, 1.0465522546E+00, 7.7077650760E-01],
	[1.9170000000E+04, 1.0430588449E+01, 5.3268324161E+00, 1.4895869616E+00, 1.0471996650E+00, 7.7087889446E-01],
	[1.9175000000E+04, 1.0434566867E+01, 5.3266704064E+00, 1.4908289029E+00, 1.0478471798E+00, 7.7098124546E-01],
	[1.9180000000E+04, 1.0438545765E+01, 5.3265084438E+00, 1.4920715549E+00, 1.0484947989E+00, 7.7108356063E-01],
	[1.9185000000E+04, 1.0442525142E+01, 5.3263465284E+00, 1.4933149176E+00, 1.0491425221E+00, 7.7118583995E-01],
	[1.9190000000E+04, 1.0446504999E+01, 5.3261846601E+00, 1.4945589913E+00, 1.0497903494E+00, 7.7128808343E-01],
	[1.9195000000E+04, 1.0450485335E+01, 5.3260228389E+00, 1.4958037762E+00, 1.0504382804E+00, 7.7139029098E-01],
	[1.9200000000E+04, 1.0454466150E+01, 5.3258610648E+00, 1.4970492726E+00, 1.0510863150E+00, 7.7149246259E-01],
	[1.9205000000E+04, 1.0458447445E+01, 5.3256993376E+00, 1.4982954806E+00, 1.0517344532E+00, 7.7159459826E-01],
	[1.9210000000E+04, 1.0462429218E+01, 5.3255376575E+00, 1.4995424005E+00, 1.0523826946E+00, 7.7169669799E-01],
	[1.9215000000E+04, 1.0466411471E+01, 5.3253760244E+00, 1.5007900325E+00, 1.0530310392E+00, 7.7179876177E-01],
	[1.9220000000E+04, 1.0470394203E+01, 5.3252144382E+00, 1.5020383768E+00, 1.0536794868E+00, 7.7190078961E-01],
	[1.9225000000E+04, 1.0474377414E+01, 5.3250528990E+00, 1.5032874337E+00, 1.0543280372E+00, 7.7200278150E-01],
	[1.9230000000E+04, 1.0478361104E+01, 5.3248914067E+00, 1.5045372034E+00, 1.0549766902E+00, 7.7210473745E-01],
	[1.9235000000E+04, 1.0482345273E+01, 5.3247299612E+00, 1.5057876860E+00, 1.0556254457E+00, 7.7220665744E-01],
	[1.9240000000E+04, 1.0486329920E+01, 5.3245685626E+00, 1.5070388818E+00, 1.0562743036E+00, 7.7230854148E-01],
	[1.9245000000E+04, 1.0490315046E+01, 5.3244072109E+00, 1.5082907911E+00, 1.0569232636E+00, 7.7241038957E-01],
	[1.9250000000E+04, 1.0494300651E+01, 5.3242459059E+00, 1.5095434140E+00, 1.0575723257E+00, 7.7251220171E-01],
	[1.9255000000E+04, 1.0498286734E+01, 5.3240846477E+00, 1.5107967508E+00, 1.0582214895E+00, 7.7261397789E-01],
	[1.9260000000E+04, 1.0502273296E+01, 5.3239234363E+00, 1.5120508016E+00, 1.0588707550E+00, 7.7271571812E-01],
	[1.9265000000E+04, 1.0506260337E+01, 5.3237622716E+00, 1.5133055668E+00, 1.0595201221E+00, 7.7281742238E-01],
	[1.9270000000E+04, 1.0510247855E+01, 5.3236011536E+00, 1.5145610465E+00, 1.0601695905E+00, 7.7291909069E-01],
	[1.9275000000E+04, 1.0514235852E+01, 5.3234400822E+00, 1.5158172409E+00, 1.0608191600E+00, 7.7302072304E-01],
	[1.9280000000E+04, 1.0518224328E+01, 5.3232790576E+00, 1.5170741504E+00, 1.0614688306E+00, 7.7312231942E-01],
	[1.9285000000E+04, 1.0522213281E+01, 5.3231180795E+00, 1.5183317750E+00, 1.0621186020E+00, 7.7322387985E-01],
	[1.9290000000E+04, 1.0526202713E+01, 5.3229571480E+00, 1.5195901150E+00, 1.0627684741E+00, 7.7332540430E-01],
	[1.9295000000E+04, 1.0530192622E+01, 5.3227962631E+00, 1.5208491706E+00, 1.0634184468E+00, 7.7342689280E-01],
	[1.9300000000E+04, 1.0534183010E+01, 5.3226354248E+00, 1.5221089422E+00, 1.0640685197E+00, 7.7352834533E-01],
	[1.9305000000E+04, 1.0538173875E+01, 5.3224746330E+00, 1.5233694297E+00, 1.0647186929E+00, 7.7362976189E-01],
	[1.9310000000E+04, 1.0542165219E+01, 5.3223138876E+00, 1.5246306336E+00, 1.0653689661E+00, 7.7373114248E-01],
	[1.9315000000E+04, 1.0546157040E+01, 5.3221531888E+00, 1.5258925540E+00, 1.0660193392E+00, 7.7383248711E-01],
	[1.9320000000E+04, 1.0550149339E+01, 5.3219925363E+00, 1.5271551912E+00, 1.0666698120E+00, 7.7393379576E-01],
	[1.9325000000E+04, 1.0554142115E+01, 5.3218319303E+00, 1.5284185452E+00, 1.0673203843E+00, 7.7403506844E-01],
	[1.9330000000E+04, 1.0558135369E+01, 5.3216713707E+00, 1.5296826165E+00, 1.0679710560E+00, 7.7413630515E-01],
	[1.9335000000E+04, 1.0562129101E+01, 5.3215108575E+00, 1.5309474052E+00, 1.0686218269E+00, 7.7423750589E-01],
	[1.9340000000E+04, 1.0566123310E+01, 5.3213503906E+00, 1.5322129115E+00, 1.0692726969E+00, 7.7433867066E-01],
	[1.9345000000E+04, 1.0570117997E+01, 5.3211899700E+00, 1.5334791356E+00, 1.0699236657E+00, 7.7443979945E-01],
	[1.9350000000E+04, 1.0574113160E+01, 5.3210295957E+00, 1.5347460778E+00, 1.0705747332E+00, 7.7454089226E-01],
	[1.9355000000E+04, 1.0578108801E+01, 5.3208692677E+00, 1.5360137383E+00, 1.0712258993E+00, 7.7464194910E-01],
	[1.9360000000E+04, 1.0582104919E+01, 5.3207089859E+00, 1.5372821173E+00, 1.0718771638E+00, 7.7474296996E-01],
	[1.9365000000E+04, 1.0586101515E+01, 5.3205487504E+00, 1.5385512150E+00, 1.0725285265E+00, 7.7484395485E-01],
	[1.9370000000E+04, 1.0590098587E+01, 5.3203885610E+00, 1.5398210316E+00, 1.0731799873E+00, 7.7494490375E-01],
	[1.9375000000E+04, 1.0594096136E+01, 5.3202284178E+00, 1.5410915674E+00, 1.0738315459E+00, 7.7504581668E-01],
	[1.9380000000E+04, 1.0598094163E+01, 5.3200683207E+00, 1.5423628226E+00, 1.0744832023E+00, 7.7514669363E-01],
	[1.9385000000E+04, 1.0602092666E+01, 5.3199082698E+00, 1.5436347975E+00, 1.0751349563E+00, 7.7524753459E-01],
	[1.9390000000E+04, 1.0606091646E+01, 5.3197482649E+00, 1.5449074921E+00, 1.0757868076E+00, 7.7534833958E-01],
	[1.9395000000E+04, 1.0610091102E+01, 5.3195883061E+00, 1.5461809068E+00, 1.0764387562E+00, 7.7544910858E-01],
	[1.9400000000E+04, 1.0614091036E+01, 5.3194283934E+00, 1.5474550418E+00, 1.0770908019E+00, 7.7554984161E-01],
	[1.9405000000E+04, 1.0618091445E+01, 5.3192685266E+00, 1.5487298972E+00, 1.0777429445E+00, 7.7565053865E-01],
	[1.9410000000E+04, 1.0622092332E+01, 5.3191087059E+00, 1.5500054734E+00, 1.0783951838E+00, 7.7575119970E-01],
	[1.9415000000E+04, 1.0626093695E+01, 5.3189489311E+00, 1.5512817705E+00, 1.0790475197E+00, 7.7585182478E-01],
	[1.9420000000E+04, 1.0630095534E+01, 5.3187892022E+00, 1.5525587888E+00, 1.0796999520E+00, 7.7595241387E-01],
	[1.9425000000E+04, 1.0634097849E+01, 5.3186295193E+00, 1.5538365284E+00, 1.0803524806E+00, 7.7605296697E-01],
	[1.9430000000E+04, 1.0638100641E+01, 5.3184698823E+00, 1.5551149896E+00, 1.0810051053E+00, 7.7615348409E-01],
	[1.9435000000E+04, 1.0642115199E+01, 5.3183134204E+00, 1.5563941727E+00, 1.0816580719E+00, 7.7625396523E-01],
	[1.9440000000E+04, 1.0646136978E+01, 5.3181588704E+00, 1.5576740778E+00, 1.0823112818E+00, 7.7635441038E-01],
	[1.9445000000E+04, 1.0650159242E+01, 5.3180043646E+00, 1.5589547051E+00, 1.0829645880E+00, 7.7645481954E-01],
	[1.9450000000E+04, 1.0654181990E+01, 5.3178499031E+00, 1.5602360550E+00, 1.0836179903E+00, 7.7655519272E-01],
	[1.9455000000E+04, 1.0658205224E+01, 5.3176954857E+00, 1.5615181275E+00, 1.0842714886E+00, 7.7665552992E-01],
	[1.9460000000E+04, 1.0662228942E+01, 5.3175411126E+00, 1.5628009230E+00, 1.0849250827E+00, 7.7675583112E-01],
	[1.9465000000E+04, 1.0666253146E+01, 5.3173867835E+00, 1.5640844416E+00, 1.0855787725E+00, 7.7685609634E-01],
	[1.9470000000E+04, 1.0670277833E+01, 5.3172324986E+00, 1.5653686836E+00, 1.0862325578E+00, 7.7695632557E-01],
	[1.9475000000E+04, 1.0674303006E+01, 5.3170782577E+00, 1.5666536491E+00, 1.0868864384E+00, 7.7705651882E-01],
	[1.9480000000E+04, 1.0678328663E+01, 5.3169240610E+00, 1.5679393385E+00, 1.0875404142E+00, 7.7715667608E-01],
	[1.9485000000E+04, 1.0682354804E+01, 5.3167699082E+00, 1.5692257519E+00, 1.0881944850E+00, 7.7725679735E-01],
	[1.9490000000E+04, 1.0686381430E+01, 5.3166157995E+00, 1.5705128896E+00, 1.0888486506E+00, 7.7735688264E-01],
	[1.9495000000E+04, 1.0690408540E+01, 5.3164617348E+00, 1.5718007517E+00, 1.0895029109E+00, 7.7745693193E-01],
	[1.9500000000E+04, 1.0694436135E+01, 5.3163077140E+00, 1.5730893385E+00, 1.0901572657E+00, 7.7755694524E-01],
	[1.9505000000E+04, 1.0698464214E+01, 5.3161537372E+00, 1.5743786502E+00, 1.0908117149E+00, 7.7765692257E-01],
	[1.9510000000E+04, 1.0702492777E+01, 5.3159998044E+00, 1.5756686871E+00, 1.0914662582E+00, 7.7775686390E-01],
	[1.9515000000E+04, 1.0706521824E+01, 5.3158459154E+00, 1.5769594493E+00, 1.0921208956E+00, 7.7785676925E-01],
	[1.9520000000E+04, 1.0710551355E+01, 5.3156920703E+00, 1.5782509371E+00, 1.0927756268E+00, 7.7795663861E-01],
	[1.9525000000E+04, 1.0714581370E+01, 5.3155382691E+00, 1.5795431507E+00, 1.0934304518E+00, 7.7805647198E-01],
	[1.9530000000E+04, 1.0718611869E+01, 5.3153845116E+00, 1.5808360903E+00, 1.0940853702E+00, 7.7815626937E-01],
	[1.9535000000E+04, 1.0722642851E+01, 5.3152307980E+00, 1.5821297562E+00, 1.0947403820E+00, 7.7825603077E-01],
	[1.9540000000E+04, 1.0726674318E+01, 5.3150771282E+00, 1.5834241485E+00, 1.0953954870E+00, 7.7835575619E-01],
	[1.9545000000E+04, 1.0730706268E+01, 5.3149235021E+00, 1.5847192675E+00, 1.0960506851E+00, 7.7845544562E-01],
	[1.9550000000E+04, 1.0734738702E+01, 5.3147699198E+00, 1.5860151135E+00, 1.0967059760E+00, 7.7855509906E-01],
	[1.9555000000E+04, 1.0738771619E+01, 5.3146163812E+00, 1.5873116865E+00, 1.0973613596E+00, 7.7865471651E-01],
	[1.9560000000E+04, 1.0742805020E+01, 5.3144628862E+00, 1.5886089869E+00, 1.0980168358E+00, 7.7875429798E-01],
	[1.9565000000E+04, 1.0746838904E+01, 5.3143094350E+00, 1.5899070149E+00, 1.0986724044E+00, 7.7885384347E-01],
	[1.9570000000E+04, 1.0750873272E+01, 5.3141560273E+00, 1.5912057706E+00, 1.0993280652E+00, 7.7895335297E-01],
	[1.9575000000E+04, 1.0754908123E+01, 5.3140026633E+00, 1.5925052544E+00, 1.0999838180E+00, 7.7905282649E-01],
	[1.9580000000E+04, 1.0758943457E+01, 5.3138493429E+00, 1.5938054664E+00, 1.1006396627E+00, 7.7915226402E-01],
	[1.9585000000E+04, 1.0762979275E+01, 5.3136960660E+00, 1.5951064068E+00, 1.1012955992E+00, 7.7925166557E-01],
	[1.9590000000E+04, 1.0767015575E+01, 5.3135428327E+00, 1.5964080760E+00, 1.1019516272E+00, 7.7935103113E-01],
	[1.9595000000E+04, 1.0771052359E+01, 5.3133896429E+00, 1.5977104740E+00, 1.1026077466E+00, 7.7945036072E-01],
	[1.9600000000E+04, 1.0775089625E+01, 5.3132364966E+00, 1.5990136011E+00, 1.1032639572E+00, 7.7954965432E-01],
	[1.9605000000E+04, 1.0779127375E+01, 5.3130833938E+00, 1.6003174576E+00, 1.1039202589E+00, 7.7964891194E-01],
	[1.9610000000E+04, 1.0783165607E+01, 5.3129303344E+00, 1.6016220437E+00, 1.1045766515E+00, 7.7974813358E-01],
	[1.9615000000E+04, 1.0787204322E+01, 5.3127773185E+00, 1.6029273595E+00, 1.1052331349E+00, 7.7984731923E-01],
	[1.9620000000E+04, 1.0791243520E+01, 5.3126243460E+00, 1.6042334053E+00, 1.1058897088E+00, 7.7994646891E-01],
	[1.9625000000E+04, 1.0795283200E+01, 5.3124714168E+00, 1.6055401814E+00, 1.1065463732E+00, 7.8004558261E-01],
	[1.9630000000E+04, 1.0799323363E+01, 5.3123185310E+00, 1.6068476879E+00, 1.1072031278E+00, 7.8014466033E-01],
	[1.9635000000E+04, 1.0803364008E+01, 5.3121656886E+00, 1.6081559251E+00, 1.1078599724E+00, 7.8024370207E-01],
	[1.9640000000E+04, 1.0807405136E+01, 5.3120128894E+00, 1.6094648932E+00, 1.1085169070E+00, 7.8034270783E-01],
	[1.9645000000E+04, 1.0811446747E+01, 5.3118601336E+00, 1.6107745924E+00, 1.1091739314E+00, 7.8044167762E-01],
	[1.9650000000E+04, 1.0815488839E+01, 5.3117074210E+00, 1.6120850229E+00, 1.1098310454E+00, 7.8054061143E-01],
	[1.9655000000E+04, 1.0819531414E+01, 5.3115547517E+00, 1.6133961849E+00, 1.1104882487E+00, 7.8063950927E-01],
	[1.9660000000E+04, 1.0823574471E+01, 5.3114021255E+00, 1.6147080788E+00, 1.1111455414E+00, 7.8073837113E-01],
	[1.9665000000E+04, 1.0827618011E+01, 5.3112495426E+00, 1.6160207046E+00, 1.1118029231E+00, 7.8083719702E-01],
	[1.9670000000E+04, 1.0831662032E+01, 5.3110970028E+00, 1.6173340627E+00, 1.1124603938E+00, 7.8093598694E-01],
	[1.9675000000E+04, 1.0835706535E+01, 5.3109445062E+00, 1.6186481532E+00, 1.1131179533E+00, 7.8103474088E-01],
	[1.9680000000E+04, 1.0839751520E+01, 5.3107920527E+00, 1.6199629764E+00, 1.1137756014E+00, 7.8113345886E-01],
	[1.9685000000E+04, 1.0843796987E+01, 5.3106396423E+00, 1.6212785324E+00, 1.1144333379E+00, 7.8123214086E-01],
	[1.9690000000E+04, 1.0847842936E+01, 5.3104872750E+00, 1.6225948216E+00, 1.1150911627E+00, 7.8133078689E-01],
	[1.9695000000E+04, 1.0851889367E+01, 5.3103349508E+00, 1.6239118441E+00, 1.1157490756E+00, 7.8142939696E-01],
	[1.9700000000E+04, 1.0855936279E+01, 5.3101826696E+00, 1.6252296001E+00, 1.1164070765E+00, 7.8152797106E-01],
	[1.9705000000E+04, 1.0859983673E+01, 5.3100304314E+00, 1.6265480899E+00, 1.1170651652E+00, 7.8162650920E-01],
	[1.9710000000E+04, 1.0864031548E+01, 5.3098782362E+00, 1.6278673137E+00, 1.1177233415E+00, 7.8172501136E-01],
	[1.9715000000E+04, 1.0868079905E+01, 5.3097260839E+00, 1.6291872718E+00, 1.1183816052E+00, 7.8182347757E-01],
	[1.9720000000E+04, 1.0872128743E+01, 5.3095739746E+00, 1.6305079642E+00, 1.1190399563E+00, 7.8192190781E-01],
	[1.9725000000E+04, 1.0876178063E+01, 5.3094219082E+00, 1.6318293913E+00, 1.1196983945E+00, 7.8202030209E-01],
	[1.9730000000E+04, 1.0880227864E+01, 5.3092698847E+00, 1.6331515533E+00, 1.1203569196E+00, 7.8211866041E-01],
	[1.9735000000E+04, 1.0884278146E+01, 5.3091179041E+00, 1.6344744504E+00, 1.1210155316E+00, 7.8221698277E-01],
	[1.9740000000E+04, 1.0888328909E+01, 5.3089659663E+00, 1.6357980828E+00, 1.1216742302E+00, 7.8231526917E-01],
	[1.9745000000E+04, 1.0892381281E+01, 5.3088143715E+00, 1.6371224508E+00, 1.1223330407E+00, 7.8241351962E-01],
	[1.9750000000E+04, 1.0896451512E+01, 5.3086674421E+00, 1.6384475545E+00, 1.1229923289E+00, 7.8251173411E-01],
	[1.9755000000E+04, 1.0900522233E+01, 5.3085205540E+00, 1.6397733942E+00, 1.1236517041E+00, 7.8260991264E-01],
	[1.9760000000E+04, 1.0904593443E+01, 5.3083737071E+00, 1.6410999701E+00, 1.1243111660E+00, 7.8270805523E-01],
	[1.9765000000E+04, 1.0908665144E+01, 5.3082269014E+00, 1.6424272824E+00, 1.1249707144E+00, 7.8280616186E-01],
	[1.9770000000E+04, 1.0912737334E+01, 5.3080801369E+00, 1.6437553314E+00, 1.1256303493E+00, 7.8290423253E-01],
	[1.9775000000E+04, 1.0916810015E+01, 5.3079334136E+00, 1.6450841173E+00, 1.1262900704E+00, 7.8300226726E-01],
	[1.9780000000E+04, 1.0920883185E+01, 5.3077867315E+00, 1.6464136403E+00, 1.1269498775E+00, 7.8310026605E-01],
	[1.9785000000E+04, 1.0924956844E+01, 5.3076400904E+00, 1.6477439006E+00, 1.1276097706E+00, 7.8319822888E-01],
	[1.9790000000E+04, 1.0929030993E+01, 5.3074934905E+00, 1.6490748984E+00, 1.1282697494E+00, 7.8329615577E-01],
	[1.9795000000E+04, 1.0933105632E+01, 5.3073469316E+00, 1.6504066340E+00, 1.1289298138E+00, 7.8339404672E-01],
	[1.9800000000E+04, 1.0937180761E+01, 5.3072004139E+00, 1.6517391076E+00, 1.1295899636E+00, 7.8349190173E-01],
	[1.9805000000E+04, 1.0941256378E+01, 5.3070539371E+00, 1.6530723194E+00, 1.1302501987E+00, 7.8358972079E-01],
	[1.9810000000E+04, 1.0945332485E+01, 5.3069075014E+00, 1.6544062696E+00, 1.1309105188E+00, 7.8368750392E-01],
	[1.9815000000E+04, 1.0949409082E+01, 5.3067611066E+00, 1.6557409584E+00, 1.1315709239E+00, 7.8378525110E-01],
	[1.9820000000E+04, 1.0953486167E+01, 5.3066147529E+00, 1.6570763861E+00, 1.1322314138E+00, 7.8388296236E-01],
	[1.9825000000E+04, 1.0957563742E+01, 5.3064684400E+00, 1.6584125530E+00, 1.1328919882E+00, 7.8398063767E-01],
	[1.9830000000E+04, 1.0961641806E+01, 5.3063221681E+00, 1.6597494591E+00, 1.1335526471E+00, 7.8407827706E-01],
	[1.9835000000E+04, 1.0965720359E+01, 5.3061759372E+00, 1.6610871048E+00, 1.1342133903E+00, 7.8417588051E-01],
	[1.9840000000E+04, 1.0969799401E+01, 5.3060297471E+00, 1.6624254902E+00, 1.1348742176E+00, 7.8427344804E-01],
	[1.9845000000E+04, 1.0973878931E+01, 5.3058835978E+00, 1.6637646156E+00, 1.1355351288E+00, 7.8437097963E-01],
	[1.9850000000E+04, 1.0977958951E+01, 5.3057374894E+00, 1.6651044812E+00, 1.1361961239E+00, 7.8446847531E-01],
	[1.9855000000E+04, 1.0982039459E+01, 5.3055914219E+00, 1.6664450872E+00, 1.1368572025E+00, 7.8456593505E-01],
	[1.9860000000E+04, 1.0986120456E+01, 5.3054453951E+00, 1.6677864339E+00, 1.1375183646E+00, 7.8466335888E-01],
	[1.9865000000E+04, 1.0990201942E+01, 5.3052994091E+00, 1.6691285215E+00, 1.1381796100E+00, 7.8476074678E-01],
	[1.9870000000E+04, 1.0994283916E+01, 5.3051534639E+00, 1.6704713501E+00, 1.1388409385E+00, 7.8485809876E-01],
	[1.9875000000E+04, 1.0998366379E+01, 5.3050075594E+00, 1.6718149200E+00, 1.1395023500E+00, 7.8495541483E-01],
	[1.9880000000E+04, 1.1002449330E+01, 5.3048616956E+00, 1.6731592315E+00, 1.1401638443E+00, 7.8505269498E-01],
	[1.9885000000E+04, 1.1006532770E+01, 5.3047158725E+00, 1.6745042848E+00, 1.1408254212E+00, 7.8514993922E-01],
	[1.9890000000E+04, 1.1010616698E+01, 5.3045700900E+00, 1.6758500800E+00, 1.1414870807E+00, 7.8524714755E-01],
	[1.9895000000E+04, 1.1014701114E+01, 5.3044243483E+00, 1.6771966174E+00, 1.1421488224E+00, 7.8534431997E-01],
	[1.9900000000E+04, 1.1018786018E+01, 5.3042786471E+00, 1.6785438972E+00, 1.1428106463E+00, 7.8544145647E-01],
	[1.9905000000E+04, 1.1022871411E+01, 5.3041329865E+00, 1.6798919197E+00, 1.1434725522E+00, 7.8553855708E-01],
	[1.9910000000E+04, 1.1026957291E+01, 5.3039873666E+00, 1.6812406850E+00, 1.1441345398E+00, 7.8563562178E-01],
	[1.9915000000E+04, 1.1031043660E+01, 5.3038417872E+00, 1.6825901935E+00, 1.1447966092E+00, 7.8573265058E-01],
	[1.9920000000E+04, 1.1035130516E+01, 5.3036962483E+00, 1.6839404452E+00, 1.1454587601E+00, 7.8582964346E-01],
	[1.9925000000E+04, 1.1039217860E+01, 5.3035507499E+00, 1.6852914405E+00, 1.1461209923E+00, 7.8592660044E-01],
	[1.9930000000E+04, 1.1043305692E+01, 5.3034052921E+00, 1.6866431795E+00, 1.1467833056E+00, 7.8602352152E-01],
	[1.9935000000E+04, 1.1047394012E+01, 5.3032598747E+00, 1.6879956625E+00, 1.1474457000E+00, 7.8612040668E-01],
	[1.9940000000E+04, 1.1051482820E+01, 5.3031144978E+00, 1.6893488897E+00, 1.1481081752E+00, 7.8621725594E-01],
	[1.9945000000E+04, 1.1055572115E+01, 5.3029691613E+00, 1.6907028614E+00, 1.1487707311E+00, 7.8631406929E-01],
	[1.9950000000E+04, 1.1059661898E+01, 5.3028238652E+00, 1.6920575776E+00, 1.1494333675E+00, 7.8641084674E-01],
	[1.9955000000E+04, 1.1063752168E+01, 5.3026786095E+00, 1.6934130388E+00, 1.1500960843E+00, 7.8650758829E-01],
	[1.9960000000E+04, 1.1067842926E+01, 5.3025333942E+00, 1.6947692450E+00, 1.1507588813E+00, 7.8660429393E-01],
	[1.9965000000E+04, 1.1071934170E+01, 5.3023882192E+00, 1.6961261965E+00, 1.1514217583E+00, 7.8670096367E-01],
	[1.9970000000E+04, 1.1076025903E+01, 5.3022430845E+00, 1.6974838936E+00, 1.1520847151E+00, 7.8679759751E-01],
	[1.9975000000E+04, 1.1080118122E+01, 5.3020979902E+00, 1.6988423364E+00, 1.1527477517E+00, 7.8689419546E-01],
	[1.9980000000E+04, 1.1084210829E+01, 5.3019529361E+00, 1.7002015251E+00, 1.1534108678E+00, 7.8699075750E-01],
	[1.9985000000E+04, 1.1088304023E+01, 5.3018079223E+00, 1.7015614601E+00, 1.1540740633E+00, 7.8708728365E-01],
	[1.9990000000E+04, 1.1092397703E+01, 5.3016629488E+00, 1.7029221415E+00, 1.1547373380E+00, 7.8718377390E-01],
	[1.9995000000E+04, 1.1096491871E+01, 5.3015180154E+00, 1.7042835696E+00, 1.1554006917E+00, 7.8728022825E-01],
	[2.0000000000E+04, 1.1100586526E+01, 5.3013731223E+00, 1.7056457445E+00, 1.1560641244E+00, 7.8737664671E-01],
	[2.0005000000E+04, 1.1104681667E+01, 5.3012282693E+00, 1.7070108455E+00, 1.1567286363E+00, 7.8747302928E-01],
	[2.0010000000E+04, 1.1108777296E+01, 5.3010834565E+00, 1.7083766969E+00, 1.1573932273E+00, 7.8756937595E-01],
	[2.0015000000E+04, 1.1112873411E+01, 5.3009386838E+00, 1.7097432988E+00, 1.1580578972E+00, 7.8766568674E-01],
	[2.0020000000E+04, 1.1116970012E+01, 5.3007939513E+00, 1.7111106516E+00, 1.1587226458E+00, 7.8776196163E-01],
	[2.0025000000E+04, 1.1121067100E+01, 5.3006492588E+00, 1.7124787554E+00, 1.1593874730E+00, 7.8785820064E-01],
	[2.0030000000E+04, 1.1125164675E+01, 5.3005046064E+00, 1.7138476105E+00, 1.1600523786E+00, 7.8795440376E-01],
	[2.0035000000E+04, 1.1129262736E+01, 5.3003599941E+00, 1.7152172171E+00, 1.1607173625E+00, 7.8805057100E-01],
	[2.0040000000E+04, 1.1133361284E+01, 5.3002154218E+00, 1.7165875754E+00, 1.1613824244E+00, 7.8814670235E-01],
	[2.0045000000E+04, 1.1137460318E+01, 5.3000708894E+00, 1.7179586856E+00, 1.1620475643E+00, 7.8824279782E-01],
	[2.0050000000E+04, 1.1141559838E+01, 5.2999263971E+00, 1.7193305480E+00, 1.1627127819E+00, 7.8833885740E-01],
	[2.0055000000E+04, 1.1145659845E+01, 5.2997819448E+00, 1.7207031628E+00, 1.1633780771E+00, 7.8843488111E-01],
	[2.0060000000E+04, 1.1149760337E+01, 5.2996375324E+00, 1.7220765302E+00, 1.1640434497E+00, 7.8853086894E-01],
	[2.0065000000E+04, 1.1153870552E+01, 5.2994955285E+00, 1.7234506505E+00, 1.1647091147E+00, 7.8862682089E-01],
	[2.0070000000E+04, 1.1157990934E+01, 5.2993560444E+00, 1.7248255237E+00, 1.1653750827E+00, 7.8872273697E-01],
	[2.0075000000E+04, 1.1162111811E+01, 5.2992165988E+00, 1.7262011503E+00, 1.1660411284E+00, 7.8881861717E-01],
	[2.0080000000E+04, 1.1166233184E+01, 5.2990771915E+00, 1.7275775304E+00, 1.1667072516E+00, 7.8891446150E-01],
	[2.0085000000E+04, 1.1170355051E+01, 5.2989378226E+00, 1.7289546642E+00, 1.1673734522E+00, 7.8901026995E-01],
	[2.0090000000E+04, 1.1174477414E+01, 5.2987984921E+00, 1.7303325520E+00, 1.1680397300E+00, 7.8910604254E-01],
	[2.0095000000E+04, 1.1178600271E+01, 5.2986591999E+00, 1.7317111940E+00, 1.1687060848E+00, 7.8920177926E-01],
	[2.0100000000E+04, 1.1182723624E+01, 5.2985199461E+00, 1.7330905903E+00, 1.1693725165E+00, 7.8929748012E-01],
	[2.0105000000E+04, 1.1186847471E+01, 5.2983807305E+00, 1.7344707413E+00, 1.1700390249E+00, 7.8939314511E-01],
	[2.0110000000E+04, 1.1190971812E+01, 5.2982415532E+00, 1.7358516472E+00, 1.1707056099E+00, 7.8948877423E-01],
	[2.0115000000E+04, 1.1195096649E+01, 5.2981024142E+00, 1.7372333081E+00, 1.1713722712E+00, 7.8958436750E-01],
	[2.0120000000E+04, 1.1199221980E+01, 5.2979633133E+00, 1.7386157244E+00, 1.1720390088E+00, 7.8967992491E-01],
	[2.0125000000E+04, 1.1203347806E+01, 5.2978242507E+00, 1.7399988961E+00, 1.1727058224E+00, 7.8977544645E-01],
	[2.0130000000E+04, 1.1207474126E+01, 5.2976852263E+00, 1.7413828236E+00, 1.1733727120E+00, 7.8987093215E-01],
	[2.0135000000E+04, 1.1211600940E+01, 5.2975462401E+00, 1.7427675071E+00, 1.1740396773E+00, 7.8996638198E-01],
	[2.0140000000E+04, 1.1215728249E+01, 5.2974072920E+00, 1.7441529468E+00, 1.1747067181E+00, 7.9006179597E-01],
	[2.0145000000E+04, 1.1219856052E+01, 5.2972683821E+00, 1.7455391430E+00, 1.1753738343E+00, 7.9015717411E-01],
	[2.0150000000E+04, 1.1223984350E+01, 5.2971295103E+00, 1.7469260958E+00, 1.1760410258E+00, 7.9025251639E-01],
	[2.0155000000E+04, 1.1228113141E+01, 5.2969906765E+00, 1.7483138054E+00, 1.1767082924E+00, 7.9034782283E-01],
	[2.0160000000E+04, 1.1232242427E+01, 5.2968518809E+00, 1.7497022722E+00, 1.1773756339E+00, 7.9044309343E-01],
	[2.0165000000E+04, 1.1236372206E+01, 5.2967131233E+00, 1.7510914963E+00, 1.1780430501E+00, 7.9053832818E-01],
	[2.0170000000E+04, 1.1240502480E+01, 5.2965744037E+00, 1.7524814779E+00, 1.1787105410E+00, 7.9063352709E-01],
	[2.0175000000E+04, 1.1244633248E+01, 5.2964357222E+00, 1.7538722173E+00, 1.1793781063E+00, 7.9072869016E-01],
	[2.0180000000E+04, 1.1248764509E+01, 5.2962970786E+00, 1.7552637147E+00, 1.1800457458E+00, 7.9082381740E-01],
	[2.0185000000E+04, 1.1252896264E+01, 5.2961584730E+00, 1.7566559704E+00, 1.1807134594E+00, 7.9091890880E-01],
	[2.0190000000E+04, 1.1257028513E+01, 5.2960199054E+00, 1.7580489845E+00, 1.1813812470E+00, 7.9101396437E-01],
	[2.0195000000E+04, 1.1261161255E+01, 5.2958813757E+00, 1.7594427572E+00, 1.1820491084E+00, 7.9110898411E-01],
	[2.0200000000E+04, 1.1265294492E+01, 5.2957428839E+00, 1.7608372889E+00, 1.1827170433E+00, 7.9120396802E-01],
	[2.0205000000E+04, 1.1269428221E+01, 5.2956044300E+00, 1.7622325797E+00, 1.1833850518E+00, 7.9129891610E-01],
	[2.0210000000E+04, 1.1273562444E+01, 5.2954660140E+00, 1.7636286298E+00, 1.1840531335E+00, 7.9139382836E-01],
	[2.0215000000E+04, 1.1277697161E+01, 5.2953276359E+00, 1.7650254395E+00, 1.1847212883E+00, 7.9148870479E-01],
	[2.0220000000E+04, 1.1281832371E+01, 5.2951892956E+00, 1.7664230090E+00, 1.1853895161E+00, 7.9158354541E-01],
	[2.0225000000E+04, 1.1285968074E+01, 5.2950509931E+00, 1.7678213385E+00, 1.1860578167E+00, 7.9167835021E-01],
	[2.0230000000E+04, 1.1290104270E+01, 5.2949127284E+00, 1.7692204283E+00, 1.1867261900E+00, 7.9177311919E-01],
	[2.0235000000E+04, 1.1294240959E+01, 5.2947745015E+00, 1.7706202786E+00, 1.1873946357E+00, 7.9186785236E-01],
	[2.0240000000E+04, 1.1298378142E+01, 5.2946363123E+00, 1.7720208895E+00, 1.1880631537E+00, 7.9196254972E-01],
	[2.0245000000E+04, 1.1302515818E+01, 5.2944981609E+00, 1.7734222614E+00, 1.1887317439E+00, 7.9205721127E-01],
	[2.0250000000E+04, 1.1306653986E+01, 5.2943600472E+00, 1.7748243944E+00, 1.1894004060E+00, 7.9215183701E-01],
	[2.0255000000E+04, 1.1310792648E+01, 5.2942219712E+00, 1.7762272887E+00, 1.1900691400E+00, 7.9224642695E-01],
	[2.0260000000E+04, 1.1314931802E+01, 5.2940839329E+00, 1.7776309447E+00, 1.1907379456E+00, 7.9234098109E-01],
	[2.0265000000E+04, 1.1319071449E+01, 5.2939459322E+00, 1.7790353625E+00, 1.1914068228E+00, 7.9243549943E-01],
	[2.0270000000E+04, 1.1323211589E+01, 5.2938079692E+00, 1.7804405423E+00, 1.1920757713E+00, 7.9252998197E-01],
	[2.0275000000E+04, 1.1327352221E+01, 5.2936700438E+00, 1.7818464844E+00, 1.1927447909E+00, 7.9262442872E-01],
	[2.0280000000E+04, 1.1331493346E+01, 5.2935321560E+00, 1.7832531891E+00, 1.1934138816E+00, 7.9271883967E-01],
	[2.0285000000E+04, 1.1335634963E+01, 5.2933943058E+00, 1.7846606564E+00, 1.1940830431E+00, 7.9281321484E-01],
	[2.0290000000E+04, 1.1339777073E+01, 5.2932564931E+00, 1.7860688866E+00, 1.1947522752E+00, 7.9290755422E-01],
	[2.0295000000E+04, 1.1343919676E+01, 5.2931187180E+00, 1.7874778801E+00, 1.1954215779E+00, 7.9300185782E-01],
	[2.0300000000E+04, 1.1348062770E+01, 5.2929809805E+00, 1.7888876369E+00, 1.1960909510E+00, 7.9309612563E-01],
	[2.0305000000E+04, 1.1352206357E+01, 5.2928432804E+00, 1.7902981574E+00, 1.1967603943E+00, 7.9319035767E-01],
	[2.0310000000E+04, 1.1356350436E+01, 5.2927056178E+00, 1.7917094417E+00, 1.1974299076E+00, 7.9328455393E-01],
	[2.0315000000E+04, 1.1360495007E+01, 5.2925679927E+00, 1.7931214900E+00, 1.1980994907E+00, 7.9337871442E-01],
	[2.0320000000E+04, 1.1364640071E+01, 5.2924304050E+00, 1.7945343027E+00, 1.1987691436E+00, 7.9347283913E-01],
	[2.0325000000E+04, 1.1368785626E+01, 5.2922928547E+00, 1.7959478799E+00, 1.1994388660E+00, 7.9356692808E-01],
	[2.0330000000E+04, 1.1372931673E+01, 5.2921553419E+00, 1.7973622218E+00, 1.2001086578E+00, 7.9366098126E-01],
	[2.0335000000E+04, 1.1377078213E+01, 5.2920178664E+00, 1.7987773287E+00, 1.2007785188E+00, 7.9375499867E-01],
	[2.0340000000E+04, 1.1381225244E+01, 5.2918804283E+00, 1.8001932007E+00, 1.2014484489E+00, 7.9384898033E-01],
	[2.0345000000E+04, 1.1385372766E+01, 5.2917430276E+00, 1.8016098383E+00, 1.2021184479E+00, 7.9394292623E-01],
	[2.0350000000E+04, 1.1389520781E+01, 5.2916056641E+00, 1.8030272414E+00, 1.2027885156E+00, 7.9403683638E-01],
	[2.0355000000E+04, 1.1393669287E+01, 5.2914683380E+00, 1.8044454104E+00, 1.2034586519E+00, 7.9413071077E-01],
	[2.0360000000E+04, 1.1397818285E+01, 5.2913310492E+00, 1.8058643455E+00, 1.2041288565E+00, 7.9422454942E-01],
	[2.0365000000E+04, 1.1401967774E+01, 5.2911937977E+00, 1.8072840470E+00, 1.2047991295E+00, 7.9431835232E-01],
	[2.0370000000E+04, 1.1406117755E+01, 5.2910565834E+00, 1.8087045149E+00, 1.2054694705E+00, 7.9441211947E-01],
	[2.0375000000E+04, 1.1410268227E+01, 5.2909194063E+00, 1.8101257497E+00, 1.2061398794E+00, 7.9450585089E-01],
	[2.0380000000E+04, 1.1414419190E+01, 5.2907822665E+00, 1.8115477514E+00, 1.2068103561E+00, 7.9459954656E-01],
	[2.0385000000E+04, 1.1418570645E+01, 5.2906451638E+00, 1.8129705204E+00, 1.2074809004E+00, 7.9469320651E-01],
	[2.0390000000E+04, 1.1422739686E+01, 5.2905123587E+00, 1.8143940568E+00, 1.2081519255E+00, 7.9478683072E-01],
	[2.0395000000E+04, 1.1426911289E+01, 5.2903801028E+00, 1.8158183608E+00, 1.2088230685E+00, 7.9488041920E-01],
	[2.0400000000E+04, 1.1431083391E+01, 5.2902478827E+00, 1.8172434328E+00, 1.2094942793E+00, 7.9497397196E-01],
	[2.0405000000E+04, 1.1435255994E+01, 5.2901156983E+00, 1.8186692729E+00, 1.2101655579E+00, 7.9506748900E-01],
	[2.0410000000E+04, 1.1439429097E+01, 5.2899835496E+00, 1.8200958813E+00, 1.2108369040E+00, 7.9516097031E-01],
	[2.0415000000E+04, 1.1443602700E+01, 5.2898514365E+00, 1.8215232583E+00, 1.2115083176E+00, 7.9525441591E-01],
	[2.0420000000E+04, 1.1447776804E+01, 5.2897193591E+00, 1.8229514041E+00, 1.2121797983E+00, 7.9534782580E-01],
	[2.0425000000E+04, 1.1451951407E+01, 5.2895873174E+00, 1.8243803189E+00, 1.2128513462E+00, 7.9544119998E-01],
	[2.0430000000E+04, 1.1456126510E+01, 5.2894553112E+00, 1.8258100030E+00, 1.2135229609E+00, 7.9553453845E-01],
	[2.0435000000E+04, 1.1460302113E+01, 5.2893233406E+00, 1.8272404565E+00, 1.2141946424E+00, 7.9562784121E-01],
	[2.0440000000E+04, 1.1464478216E+01, 5.2891914057E+00, 1.8286716797E+00, 1.2148663905E+00, 7.9572110828E-01],
	[2.0445000000E+04, 1.1468654819E+01, 5.2890595062E+00, 1.8301036729E+00, 1.2155382050E+00, 7.9581433965E-01],
	[2.0450000000E+04, 1.1472831922E+01, 5.2889276424E+00, 1.8315364361E+00, 1.2162100857E+00, 7.9590753532E-01],
	[2.0455000000E+04, 1.1477009524E+01, 5.2887958140E+00, 1.8329699698E+00, 1.2168820326E+00, 7.9600069531E-01],
	[2.0460000000E+04, 1.1481187625E+01, 5.2886640212E+00, 1.8344042741E+00, 1.2175540454E+00, 7.9609381960E-01],
	[2.0465000000E+04, 1.1485366227E+01, 5.2885322638E+00, 1.8358393491E+00, 1.2182261240E+00, 7.9618690822E-01],
	[2.0470000000E+04, 1.1489545327E+01, 5.2884005419E+00, 1.8372751953E+00, 1.2188982682E+00, 7.9627996115E-01],
	[2.0475000000E+04, 1.1493724928E+01, 5.2882688554E+00, 1.8387118127E+00, 1.2195704779E+00, 7.9637297840E-01],
	[2.0480000000E+04, 1.1497905027E+01, 5.2881372044E+00, 1.8401492016E+00, 1.2202427528E+00, 7.9646595998E-01],
	[2.0485000000E+04, 1.1502085626E+01, 5.2880055888E+00, 1.8415873622E+00, 1.2209150929E+00, 7.9655890589E-01],
	[2.0490000000E+04, 1.1506266724E+01, 5.2878740086E+00, 1.8430262948E+00, 1.2215874980E+00, 7.9665181613E-01],
	[2.0495000000E+04, 1.1510448321E+01, 5.2877424638E+00, 1.8444659995E+00, 1.2222599678E+00, 7.9674469071E-01],
	[2.0500000000E+04, 1.1514630417E+01, 5.2876109543E+00, 1.8459064766E+00, 1.2229325023E+00, 7.9683752963E-01],
	[2.0505000000E+04, 1.1518813012E+01, 5.2874794802E+00, 1.8473477264E+00, 1.2236051013E+00, 7.9693033289E-01],
	[2.0510000000E+04, 1.1522996107E+01, 5.2873480414E+00, 1.8487897490E+00, 1.2242777647E+00, 7.9702310049E-01],
	[2.0515000000E+04, 1.1527179700E+01, 5.2872166379E+00, 1.8502325447E+00, 1.2249504922E+00, 7.9711583245E-01],
	[2.0520000000E+04, 1.1531363792E+01, 5.2870852697E+00, 1.8516761137E+00, 1.2256232837E+00, 7.9720852876E-01],
	[2.0525000000E+04, 1.1535548382E+01, 5.2869539367E+00, 1.8531204562E+00, 1.2262961390E+00, 7.9730118943E-01],
	[2.0530000000E+04, 1.1539733472E+01, 5.2868226390E+00, 1.8545655725E+00, 1.2269690580E+00, 7.9739381446E-01],
	[2.0535000000E+04, 1.1543919060E+01, 5.2866913766E+00, 1.8560114627E+00, 1.2276420405E+00, 7.9748640385E-01],
	[2.0540000000E+04, 1.1548105147E+01, 5.2865601493E+00, 1.8574581271E+00, 1.2283150864E+00, 7.9757895761E-01],
	[2.0545000000E+04, 1.1552291732E+01, 5.2864289573E+00, 1.8589055660E+00, 1.2289881955E+00, 7.9767147574E-01],
	[2.0550000000E+04, 1.1556478815E+01, 5.2862978004E+00, 1.8603537795E+00, 1.2296613676E+00, 7.9776395825E-01],
	[2.0555000000E+04, 1.1560666398E+01, 5.2861666787E+00, 1.8618027679E+00, 1.2303346026E+00, 7.9785640514E-01],
	[2.0560000000E+04, 1.1564854478E+01, 5.2860355921E+00, 1.8632525314E+00, 1.2310079003E+00, 7.9794881641E-01],
	[2.0565000000E+04, 1.1569043057E+01, 5.2859045407E+00, 1.8647030703E+00, 1.2316812606E+00, 7.9804119206E-01],
	[2.0570000000E+04, 1.1573232134E+01, 5.2857735243E+00, 1.8661543847E+00, 1.2323546832E+00, 7.9813353211E-01],
	[2.0575000000E+04, 1.1577421709E+01, 5.2856425431E+00, 1.8676064748E+00, 1.2330281681E+00, 7.9822583655E-01],
	[2.0580000000E+04, 1.1581611782E+01, 5.2855115969E+00, 1.8690593410E+00, 1.2337017150E+00, 7.9831810538E-01],
	[2.0585000000E+04, 1.1585802353E+01, 5.2853806858E+00, 1.8705129834E+00, 1.2343753239E+00, 7.9841033862E-01],
	[2.0590000000E+04, 1.1589993422E+01, 5.2852498097E+00, 1.8719674023E+00, 1.2350489944E+00, 7.9850253627E-01],
	[2.0595000000E+04, 1.1594184990E+01, 5.2851189686E+00, 1.8734225978E+00, 1.2357227266E+00, 7.9859469832E-01],
	[2.0600000000E+04, 1.1598377055E+01, 5.2849881625E+00, 1.8748785702E+00, 1.2363965202E+00, 7.9868682479E-01],
	[2.0605000000E+04, 1.1602569617E+01, 5.2848573914E+00, 1.8763353198E+00, 1.2370703751E+00, 7.9877891567E-01],
	[2.0610000000E+04, 1.1606762678E+01, 5.2847266553E+00, 1.8777928468E+00, 1.2377442910E+00, 7.9887097097E-01],
	[2.0615000000E+04, 1.1610956236E+01, 5.2845959541E+00, 1.8792511513E+00, 1.2384182679E+00, 7.9896299070E-01],
	[2.0620000000E+04, 1.1615150292E+01, 5.2844652879E+00, 1.8807102336E+00, 1.2390923056E+00, 7.9905497486E-01],
	[2.0625000000E+04, 1.1619344845E+01, 5.2843346565E+00, 1.8821700940E+00, 1.2397664039E+00, 7.9914692345E-01],
	[2.0630000000E+04, 1.1623539896E+01, 5.2842040601E+00, 1.8836307326E+00, 1.2404405627E+00, 7.9923883648E-01],
	[2.0635000000E+04, 1.1627735444E+01, 5.2840734985E+00, 1.8850921497E+00, 1.2411147817E+00, 7.9933071395E-01],
	[2.0640000000E+04, 1.1631931490E+01, 5.2839429718E+00, 1.8865543455E+00, 1.2417890609E+00, 7.9942255586E-01],
	[2.0645000000E+04, 1.1636128032E+01, 5.2838124799E+00, 1.8880173203E+00, 1.2424634001E+00, 7.9951436222E-01],
	[2.0650000000E+04, 1.1640325073E+01, 5.2836820228E+00, 1.8894810742E+00, 1.2431377990E+00, 7.9960613303E-01],
	[2.0655000000E+04, 1.1644522610E+01, 5.2835516006E+00, 1.8909456075E+00, 1.2438122577E+00, 7.9969786831E-01],
	[2.0660000000E+04, 1.1648720644E+01, 5.2834212131E+00, 1.8924109205E+00, 1.2444867758E+00, 7.9978956804E-01],
	[2.0665000000E+04, 1.1652919176E+01, 5.2832908604E+00, 1.8938770132E+00, 1.2451613532E+00, 7.9988123224E-01],
	[2.0670000000E+04, 1.1657118204E+01, 5.2831605424E+00, 1.8953438861E+00, 1.2458359899E+00, 7.9997286090E-01],
	[2.0675000000E+04, 1.1661317729E+01, 5.2830302592E+00, 1.8968115392E+00, 1.2465106855E+00, 8.0006445404E-01],
	[2.0680000000E+04, 1.1665517752E+01, 5.2829000107E+00, 1.8982799728E+00, 1.2471854400E+00, 8.0015601166E-01],
	[2.0685000000E+04, 1.1669718271E+01, 5.2827697969E+00, 1.8997491872E+00, 1.2478602532E+00, 8.0024753376E-01],
	[2.0690000000E+04, 1.1673919286E+01, 5.2826396178E+00, 1.9012191826E+00, 1.2485351249E+00, 8.0033902035E-01],
	[2.0695000000E+04, 1.1678120799E+01, 5.2825094733E+00, 1.9026899591E+00, 1.2492100549E+00, 8.0043047143E-01],
	[2.0700000000E+04, 1.1682322808E+01, 5.2823793635E+00, 1.9041615171E+00, 1.2498850432E+00, 8.0052188700E-01],
	[2.0705000000E+04, 1.1686525314E+01, 5.2822492883E+00, 1.9056338567E+00, 1.2505600895E+00, 8.0061326707E-01],
	[2.0710000000E+04, 1.1690728316E+01, 5.2821192477E+00, 1.9071069782E+00, 1.2512351938E+00, 8.0070461165E-01],
	[2.0715000000E+04, 1.1694936786E+01, 5.2819904475E+00, 1.9085808817E+00, 1.2519104804E+00, 8.0079592073E-01],
	[2.0720000000E+04, 1.1699160165E+01, 5.2818651749E+00, 1.9100555676E+00, 1.2525861865E+00, 8.0088719432E-01],
	[2.0725000000E+04, 1.1703384050E+01, 5.2817399356E+00, 1.9115310361E+00, 1.2532619507E+00, 8.0097843244E-01],
	[2.0730000000E+04, 1.1707608440E+01, 5.2816147294E+00, 1.9130072873E+00, 1.2539377730E+00, 8.0106963507E-01],
	[2.0735000000E+04, 1.1711833336E+01, 5.2814895564E+00, 1.9144843215E+00, 1.2546136532E+00, 8.0116080222E-01],
	[2.0740000000E+04, 1.1716058737E+01, 5.2813644165E+00, 1.9159621390E+00, 1.2552895911E+00, 8.0125193391E-01],
	[2.0745000000E+04, 1.1720284644E+01, 5.2812393098E+00, 1.9174407399E+00, 1.2559655865E+00, 8.0134303013E-01],
	[2.0750000000E+04, 1.1724511056E+01, 5.2811142362E+00, 1.9189201245E+00, 1.2566416393E+00, 8.0143409089E-01],
	[2.0755000000E+04, 1.1728737973E+01, 5.2809891957E+00, 1.9204002930E+00, 1.2573177494E+00, 8.0152511620E-01],
	[2.0760000000E+04, 1.1732965396E+01, 5.2808641882E+00, 1.9218812456E+00, 1.2579939165E+00, 8.0161610605E-01],
	[2.0765000000E+04, 1.1737193323E+01, 5.2807392139E+00, 1.9233629825E+00, 1.2586701405E+00, 8.0170706045E-01],
	[2.0770000000E+04, 1.1741421756E+01, 5.2806142725E+00, 1.9248455041E+00, 1.2593464213E+00, 8.0179797941E-01],
	[2.0775000000E+04, 1.1745650693E+01, 5.2804893642E+00, 1.9263288104E+00, 1.2600227587E+00, 8.0188886293E-01],
	[2.0780000000E+04, 1.1749880135E+01, 5.2803644889E+00, 1.9278129018E+00, 1.2606991525E+00, 8.0197971102E-01],
	[2.0785000000E+04, 1.1754110083E+01, 5.2802396466E+00, 1.9292977785E+00, 1.2613756026E+00, 8.0207052368E-01],
	[2.0790000000E+04, 1.1758340535E+01, 5.2801148373E+00, 1.9307834406E+00, 1.2620521088E+00, 8.0216130091E-01],
	[2.0795000000E+04, 1.1762571492E+01, 5.2799900610E+00, 1.9322698885E+00, 1.2627286709E+00, 8.0225204272E-01],
	[2.0800000000E+04, 1.1766802953E+01, 5.2798653176E+00, 1.9337571222E+00, 1.2634052889E+00, 8.0234274912E-01],
	[2.0805000000E+04, 1.1771034919E+01, 5.2797406071E+00, 1.9352451422E+00, 1.2640819624E+00, 8.0243342010E-01],
	[2.0810000000E+04, 1.1775267390E+01, 5.2796159295E+00, 1.9367339485E+00, 1.2647586915E+00, 8.0252405568E-01],
	[2.0815000000E+04, 1.1779500365E+01, 5.2794912848E+00, 1.9382235414E+00, 1.2654354758E+00, 8.0261465586E-01],
	[2.0820000000E+04, 1.1783733845E+01, 5.2793666730E+00, 1.9397139212E+00, 1.2661123154E+00, 8.0270522064E-01],
	[2.0825000000E+04, 1.1787967829E+01, 5.2792420941E+00, 1.9412050881E+00, 1.2667892099E+00, 8.0279575003E-01],
	[2.0830000000E+04, 1.1792202317E+01, 5.2791175480E+00, 1.9426970422E+00, 1.2674661592E+00, 8.0288624404E-01],
	[2.0835000000E+04, 1.1796437310E+01, 5.2789930348E+00, 1.9441897839E+00, 1.2681431633E+00, 8.0297670266E-01],
	[2.0840000000E+04, 1.1800672806E+01, 5.2788685543E+00, 1.9456833133E+00, 1.2688202218E+00, 8.0306712590E-01],
	[2.0845000000E+04, 1.1804908807E+01, 5.2787441067E+00, 1.9471776307E+00, 1.2694973347E+00, 8.0315751377E-01],
	[2.0850000000E+04, 1.1809145312E+01, 5.2786196918E+00, 1.9486727363E+00, 1.2701745018E+00, 8.0324786627E-01],
	[2.0855000000E+04, 1.1813382321E+01, 5.2784953097E+00, 1.9501686302E+00, 1.2708517230E+00, 8.0333818341E-01],
	[2.0860000000E+04, 1.1817619834E+01, 5.2783709604E+00, 1.9516653129E+00, 1.2715289980E+00, 8.0342846520E-01],
	[2.0865000000E+04, 1.1821857851E+01, 5.2782466437E+00, 1.9531627844E+00, 1.2722063268E+00, 8.0351871163E-01],
	[2.0870000000E+04, 1.1826096371E+01, 5.2781223598E+00, 1.9546610450E+00, 1.2728837091E+00, 8.0360892271E-01],
	[2.0875000000E+04, 1.1830335396E+01, 5.2779981086E+00, 1.9561600950E+00, 1.2735611448E+00, 8.0369909844E-01],
	[2.0880000000E+04, 1.1834574924E+01, 5.2778738901E+00, 1.9576599345E+00, 1.2742386338E+00, 8.0378923884E-01],
	[2.0885000000E+04, 1.1838814956E+01, 5.2777497042E+00, 1.9591605638E+00, 1.2749161758E+00, 8.0387934391E-01],
	[2.0890000000E+04, 1.1843055491E+01, 5.2776255510E+00, 1.9606619830E+00, 1.2755937708E+00, 8.0396941365E-01],
	[2.0895000000E+04, 1.1847296530E+01, 5.2775014304E+00, 1.9621641926E+00, 1.2762714185E+00, 8.0405944806E-01],
	[2.0900000000E+04, 1.1851538072E+01, 5.2773773424E+00, 1.9636671925E+00, 1.2769491189E+00, 8.0414944716E-01],
	[2.0905000000E+04, 1.1855780118E+01, 5.2772532871E+00, 1.9651709832E+00, 1.2776268717E+00, 8.0423941094E-01],
	[2.0910000000E+04, 1.1860022667E+01, 5.2771292643E+00, 1.9666755648E+00, 1.2783046768E+00, 8.0432933942E-01],
	[2.0915000000E+04, 1.1864265719E+01, 5.2770052740E+00, 1.9681809375E+00, 1.2789825340E+00, 8.0441923259E-01],
	[2.0920000000E+04, 1.1868509275E+01, 5.2768813164E+00, 1.9696871015E+00, 1.2796604432E+00, 8.0450909046E-01],
	[2.0925000000E+04, 1.1872753333E+01, 5.2767573912E+00, 1.9711940572E+00, 1.2803384042E+00, 8.0459891304E-01],
	[2.0930000000E+04, 1.1876997895E+01, 5.2766334986E+00, 1.9727018046E+00, 1.2810164168E+00, 8.0468870034E-01],
	[2.0935000000E+04, 1.1881242960E+01, 5.2765096385E+00, 1.9742103441E+00, 1.2816944810E+00, 8.0477845235E-01],
	[2.0940000000E+04, 1.1885488528E+01, 5.2763858108E+00, 1.9757196759E+00, 1.2823725965E+00, 8.0486816909E-01],
	[2.0945000000E+04, 1.1889734598E+01, 5.2762620157E+00, 1.9772298002E+00, 1.2830507632E+00, 8.0495785055E-01],
	[2.0950000000E+04, 1.1893981172E+01, 5.2761382530E+00, 1.9787407172E+00, 1.2837289809E+00, 8.0504749674E-01],
	[2.0955000000E+04, 1.1898228248E+01, 5.2760145227E+00, 1.9802524271E+00, 1.2844072494E+00, 8.0513710768E-01],
	[2.0960000000E+04, 1.1902475827E+01, 5.2758908248E+00, 1.9817649302E+00, 1.2850855687E+00, 8.0522668336E-01],
	[2.0965000000E+04, 1.1906723909E+01, 5.2757671594E+00, 1.9832782267E+00, 1.2857639385E+00, 8.0531622379E-01],
	[2.0970000000E+04, 1.1910972494E+01, 5.2756435263E+00, 1.9847923168E+00, 1.2864423587E+00, 8.0540572897E-01],
	[2.0975000000E+04, 1.1915221580E+01, 5.2755199256E+00, 1.9863072008E+00, 1.2871208291E+00, 8.0549519891E-01],
	[2.0980000000E+04, 1.1919471170E+01, 5.2753963573E+00, 1.9878228789E+00, 1.2877993496E+00, 8.0558463362E-01],
	[2.0985000000E+04, 1.1923721262E+01, 5.2752728212E+00, 1.9893393512E+00, 1.2884779199E+00, 8.0567403309E-01],
	[2.0990000000E+04, 1.1927971856E+01, 5.2751493176E+00, 1.9908566181E+00, 1.2891565401E+00, 8.0576339735E-01],
	[2.0995000000E+04, 1.1932222953E+01, 5.2750258462E+00, 1.9923746798E+00, 1.2898352098E+00, 8.0585272638E-01],
	[2.1000000000E+04, 1.1936474551E+01, 5.2749024071E+00, 1.9938935364E+00, 1.2905139290E+00, 8.0594202020E-01],
	[2.1005000000E+04, 1.1940726652E+01, 5.2747790003E+00, 1.9954131882E+00, 1.2911926975E+00, 8.0603127881E-01],
	[2.1010000000E+04, 1.1944979256E+01, 5.2746556257E+00, 1.9969336355E+00, 1.2918715150E+00, 8.0612050222E-01],
	[2.1015000000E+04, 1.1949232361E+01, 5.2745322834E+00, 1.9984548784E+00, 1.2925503816E+00, 8.0620969044E-01],
	[2.1020000000E+04, 1.1953485968E+01, 5.2744089734E+00, 1.9999769173E+00, 1.2932292969E+00, 8.0629884346E-01],
	[2.1025000000E+04, 1.1957740077E+01, 5.2742856955E+00, 2.0014997522E+00, 1.2939082609E+00, 8.0638796129E-01],
	[2.1030000000E+04, 1.1961994688E+01, 5.2741624498E+00, 2.0030233835E+00, 1.2945872733E+00, 8.0647704395E-01],
	[2.1035000000E+04, 1.1966249801E+01, 5.2740392363E+00, 2.0045478113E+00, 1.2952663341E+00, 8.0656609143E-01],
	[2.1040000000E+04, 1.1970505416E+01, 5.2739160550E+00, 2.0060730359E+00, 1.2959454431E+00, 8.0665510374E-01],
	[2.1045000000E+04, 1.1974761532E+01, 5.2737929058E+00, 2.0075990576E+00, 1.2966246000E+00, 8.0674408088E-01],
	[2.1050000000E+04, 1.1979029210E+01, 5.2736723981E+00, 2.0091258765E+00, 1.2973040925E+00, 8.0683302287E-01],
	[2.1055000000E+04, 1.1983305946E+01, 5.2735539386E+00, 2.0106534929E+00, 1.2979838556E+00, 8.0692192971E-01],
	[2.1060000000E+04, 1.1987583194E+01, 5.2734355098E+00, 2.0121819069E+00, 1.2986636670E+00, 8.0701080139E-01],
	[2.1065000000E+04, 1.1991860952E+01, 5.2733171118E+00, 2.0137111189E+00, 1.2993435266E+00, 8.0709963794E-01],
	[2.1070000000E+04, 1.1996139220E+01, 5.2731987446E+00, 2.0152411291E+00, 1.3000234342E+00, 8.0718843935E-01],
	[2.1075000000E+04, 1.2000417999E+01, 5.2730804081E+00, 2.0167719376E+00, 1.3007033897E+00, 8.0727720563E-01],
	[2.1080000000E+04, 1.2004697289E+01, 5.2729621023E+00, 2.0183035448E+00, 1.3013833929E+00, 8.0736593678E-01],
	[2.1085000000E+04, 1.2008977090E+01, 5.2728438272E+00, 2.0198359507E+00, 1.3020634436E+00, 8.0745463282E-01],
	[2.1090000000E+04, 1.2013257401E+01, 5.2727255829E+00, 2.0213691558E+00, 1.3027435417E+00, 8.0754329374E-01],
	[2.1095000000E+04, 1.2017538222E+01, 5.2726073692E+00, 2.0229031601E+00, 1.3034236871E+00, 8.0763191956E-01],
	[2.1100000000E+04, 1.2021819554E+01, 5.2724891862E+00, 2.0244379639E+00, 1.3041038795E+00, 8.0772051028E-01],
	[2.1105000000E+04, 1.2026101396E+01, 5.2723710338E+00, 2.0259735675E+00, 1.3047841189E+00, 8.0780906589E-01],
	[2.1110000000E+04, 1.2030383748E+01, 5.2722529121E+00, 2.0275099710E+00, 1.3054644050E+00, 8.0789758642E-01],
	[2.1115000000E+04, 1.2034666610E+01, 5.2721348210E+00, 2.0290471747E+00, 1.3061447377E+00, 8.0798607187E-01],
	[2.1120000000E+04, 1.2038949983E+01, 5.2720167605E+00, 2.0305851788E+00, 1.3068251168E+00, 8.0807452223E-01],
	[2.1125000000E+04, 1.2043233865E+01, 5.2718987305E+00, 2.0321239836E+00, 1.3075055423E+00, 8.0816293753E-01],
	[2.1130000000E+04, 1.2047518258E+01, 5.2717807312E+00, 2.0336635893E+00, 1.3081860139E+00, 8.0825131775E-01],
	[2.1135000000E+04, 1.2051803161E+01, 5.2716627624E+00, 2.0352039960E+00, 1.3088665314E+00, 8.0833966292E-01],
	[2.1140000000E+04, 1.2056088573E+01, 5.2715448242E+00, 2.0367452041E+00, 1.3095470948E+00, 8.0842797303E-01],
	[2.1145000000E+04, 1.2060374495E+01, 5.2714269165E+00, 2.0382872137E+00, 1.3102277038E+00, 8.0851624809E-01],
	[2.1150000000E+04, 1.2064660927E+01, 5.2713090393E+00, 2.0398300251E+00, 1.3109083583E+00, 8.0860448811E-01],
	[2.1155000000E+04, 1.2068947869E+01, 5.2711911926E+00, 2.0413736385E+00, 1.3115890582E+00, 8.0869269309E-01],
	[2.1160000000E+04, 1.2073235320E+01, 5.2710733763E+00, 2.0429180542E+00, 1.3122698033E+00, 8.0878086304E-01],
	[2.1165000000E+04, 1.2077523281E+01, 5.2709555906E+00, 2.0444632723E+00, 1.3129505934E+00, 8.0886899797E-01],
	[2.1170000000E+04, 1.2081811751E+01, 5.2708378353E+00, 2.0460092930E+00, 1.3136314283E+00, 8.0895709788E-01],
	[2.1175000000E+04, 1.2086100731E+01, 5.2707201104E+00, 2.0475561167E+00, 1.3143123080E+00, 8.0904516277E-01],
	[2.1180000000E+04, 1.2090390221E+01, 5.2706024160E+00, 2.0491037436E+00, 1.3149932323E+00, 8.0913319265E-01],
	[2.1185000000E+04, 1.2094680219E+01, 5.2704847520E+00, 2.0506521738E+00, 1.3156742010E+00, 8.0922118754E-01],
	[2.1190000000E+04, 1.2098970727E+01, 5.2703671184E+00, 2.0522014075E+00, 1.3163552139E+00, 8.0930914743E-01],
	[2.1195000000E+04, 1.2103261744E+01, 5.2702495151E+00, 2.0537514451E+00, 1.3170362709E+00, 8.0939707233E-01],
	[2.1200000000E+04, 1.2107553270E+01, 5.2701319422E+00, 2.0553022868E+00, 1.3177173718E+00, 8.0948496225E-01],
	[2.1205000000E+04, 1.2111845306E+01, 5.2700143997E+00, 2.0568539327E+00, 1.3183985165E+00, 8.0957281719E-01],
	[2.1210000000E+04, 1.2116137850E+01, 5.2698968875E+00, 2.0584063831E+00, 1.3190797049E+00, 8.0966063716E-01],
	[2.1215000000E+04, 1.2120430904E+01, 5.2697794056E+00, 2.0599596383E+00, 1.3197609367E+00, 8.0974842216E-01],
	[2.1220000000E+04, 1.2124724466E+01, 5.2696619540E+00, 2.0615136984E+00, 1.3204422118E+00, 8.0983617221E-01],
	[2.1225000000E+04, 1.2129018537E+01, 5.2695445327E+00, 2.0630685636E+00, 1.3211235300E+00, 8.0992388730E-01],
	[2.1230000000E+04, 1.2133313117E+01, 5.2694271417E+00, 2.0646242343E+00, 1.3218048913E+00, 8.1001156745E-01],
	[2.1235000000E+04, 1.2137608206E+01, 5.2693097809E+00, 2.0661807106E+00, 1.3224862954E+00, 8.1009921266E-01],
	[2.1240000000E+04, 1.2141903803E+01, 5.2691924504E+00, 2.0677379928E+00, 1.3231677422E+00, 8.1018682294E-01],
	[2.1245000000E+04, 1.2146199909E+01, 5.2690751501E+00, 2.0692960810E+00, 1.3238492315E+00, 8.1027439828E-01],
	[2.1250000000E+04, 1.2150496524E+01, 5.2689578800E+00, 2.0708549756E+00, 1.3245307632E+00, 8.1036193871E-01],
	[2.1255000000E+04, 1.2154793647E+01, 5.2688406401E+00, 2.0724146767E+00, 1.3252123371E+00, 8.1044944422E-01],
	[2.1260000000E+04, 1.2159091278E+01, 5.2687234304E+00, 2.0739751846E+00, 1.3258939531E+00, 8.1053691483E-01],
	[2.1265000000E+04, 1.2163389418E+01, 5.2686062509E+00, 2.0755364995E+00, 1.3265756109E+00, 8.1062435053E-01],
	[2.1270000000E+04, 1.2167688067E+01, 5.2684891015E+00, 2.0770986215E+00, 1.3272573105E+00, 8.1071175133E-01],
	[2.1275000000E+04, 1.2171987223E+01, 5.2683719823E+00, 2.0786615511E+00, 1.3279390518E+00, 8.1079911725E-01],
	[2.1280000000E+04, 1.2176286888E+01, 5.2682548932E+00, 2.0802252883E+00, 1.3286208344E+00, 8.1088644828E-01],
	[2.1285000000E+04, 1.2180587061E+01, 5.2681378342E+00, 2.0817898334E+00, 1.3293026583E+00, 8.1097374444E-01],
	[2.1290000000E+04, 1.2184887742E+01, 5.2680208053E+00, 2.0833551866E+00, 1.3299845234E+00, 8.1106100573E-01],
	[2.1295000000E+04, 1.2189188931E+01, 5.2679038064E+00, 2.0849213482E+00, 1.3306664294E+00, 8.1114823219E-01],
	[2.1300000000E+04, 1.2193490628E+01, 5.2677868377E+00, 2.0864883184E+00, 1.3313483762E+00, 8.1123542382E-01],
	[2.1305000000E+04, 1.2197792833E+01, 5.2676698990E+00, 2.0880560974E+00, 1.3320303637E+00, 8.1132258062E-01],
	[2.1310000000E+04, 1.2202095545E+01, 5.2675529903E+00, 2.0896246854E+00, 1.3327123916E+00, 8.1140970261E-01],
	[2.1315000000E+04, 1.2206398766E+01, 5.2674361116E+00, 2.0911940827E+00, 1.3333944600E+00, 8.1149678977E-01],
	[2.1320000000E+04, 1.2210702494E+01, 5.2673192630E+00, 2.0927642895E+00, 1.3340765685E+00, 8.1158384212E-01],
	[2.1325000000E+04, 1.2215006730E+01, 5.2672024443E+00, 2.0943353060E+00, 1.3347587170E+00, 8.1167085966E-01],
	[2.1330000000E+04, 1.2219311474E+01, 5.2670856557E+00, 2.0959071324E+00, 1.3354409054E+00, 8.1175784240E-01],
	[2.1335000000E+04, 1.2223616725E+01, 5.2669688969E+00, 2.0974797690E+00, 1.3361231336E+00, 8.1184479033E-01],
	[2.1340000000E+04, 1.2227922483E+01, 5.2668521682E+00, 2.0990532160E+00, 1.3368054013E+00, 8.1193170346E-01],
	[2.1345000000E+04, 1.2232228749E+01, 5.2667354693E+00, 2.1006274736E+00, 1.3374877084E+00, 8.1201858179E-01],
	[2.1350000000E+04, 1.2236535523E+01, 5.2666188004E+00, 2.1022025421E+00, 1.3381700548E+00, 8.1210542533E-01],
	[2.1355000000E+04, 1.2240842804E+01, 5.2665021614E+00, 2.1037784217E+00, 1.3388524402E+00, 8.1219223409E-01],
	[2.1360000000E+04, 1.2245150592E+01, 5.2663855523E+00, 2.1053551125E+00, 1.3395348647E+00, 8.1227900806E-01],
	[2.1365000000E+04, 1.2249458887E+01, 5.2662689730E+00, 2.1069326149E+00, 1.3402173279E+00, 8.1236574725E-01],
	[2.1370000000E+04, 1.2253767689E+01, 5.2661524236E+00, 2.1085109291E+00, 1.3408998297E+00, 8.1245245166E-01],
	[2.1375000000E+04, 1.2258076999E+01, 5.2660359041E+00, 2.1100900552E+00, 1.3415823700E+00, 8.1253912131E-01],
	[2.1380000000E+04, 1.2262386815E+01, 5.2659194144E+00, 2.1116699936E+00, 1.3422649487E+00, 8.1262575618E-01],
	[2.1385000000E+04, 1.2266697138E+01, 5.2658029545E+00, 2.1132507444E+00, 1.3429475655E+00, 8.1271235629E-01],
	[2.1390000000E+04, 1.2271023801E+01, 5.2656901581E+00, 2.1148323079E+00, 1.3436306467E+00, 8.1279892163E-01],
	[2.1395000000E+04, 1.2275354992E+01, 5.2655783112E+00, 2.1164146842E+00, 1.3443138746E+00, 8.1288545223E-01],
	[2.1400000000E+04, 1.2279686698E+01, 5.2654664929E+00, 2.1179978737E+00, 1.3449971410E+00, 8.1297194806E-01],
	[2.1405000000E+04, 1.2284018920E+01, 5.2653547030E+00, 2.1195818766E+00, 1.3456804458E+00, 8.1305840915E-01],
	[2.1410000000E+04, 1.2288351659E+01, 5.2652429416E+00, 2.1211666930E+00, 1.3463637887E+00, 8.1314483550E-01],
	[2.1415000000E+04, 1.2292684913E+01, 5.2651312087E+00, 2.1227523232E+00, 1.3470471697E+00, 8.1323122711E-01],
	[2.1420000000E+04, 1.2297018683E+01, 5.2650195042E+00, 2.1243387675E+00, 1.3477305886E+00, 8.1331758397E-01],
	[2.1425000000E+04, 1.2301352969E+01, 5.2649078281E+00, 2.1259260260E+00, 1.3484140452E+00, 8.1340390611E-01],
	[2.1430000000E+04, 1.2305687771E+01, 5.2647961805E+00, 2.1275140990E+00, 1.3490975394E+00, 8.1349019352E-01],
	[2.1435000000E+04, 1.2310023089E+01, 5.2646845613E+00, 2.1291029867E+00, 1.3497810711E+00, 8.1357644620E-01],
	[2.1440000000E+04, 1.2314358922E+01, 5.2645729705E+00, 2.1306926894E+00, 1.3504646400E+00, 8.1366266417E-01],
	[2.1445000000E+04, 1.2318695270E+01, 5.2644614081E+00, 2.1322832072E+00, 1.3511482460E+00, 8.1374884742E-01],
	[2.1450000000E+04, 1.2323032135E+01, 5.2643498741E+00, 2.1338745404E+00, 1.3518318890E+00, 8.1383499596E-01],
	[2.1455000000E+04, 1.2327369515E+01, 5.2642383684E+00, 2.1354666892E+00, 1.3525155688E+00, 8.1392110979E-01],
	[2.1460000000E+04, 1.2331707410E+01, 5.2641268911E+00, 2.1370596539E+00, 1.3531992853E+00, 8.1400718892E-01],
	[2.1465000000E+04, 1.2336045820E+01, 5.2640154421E+00, 2.1386534347E+00, 1.3538830383E+00, 8.1409323335E-01],
	[2.1470000000E+04, 1.2340384746E+01, 5.2639040214E+00, 2.1402480318E+00, 1.3545668276E+00, 8.1417924309E-01],
	[2.1475000000E+04, 1.2344724187E+01, 5.2637926290E+00, 2.1418434454E+00, 1.3552506531E+00, 8.1426521814E-01],
	[2.1480000000E+04, 1.2349064144E+01, 5.2636812649E+00, 2.1434396758E+00, 1.3559345147E+00, 8.1435115850E-01],
	[2.1485000000E+04, 1.2353404615E+01, 5.2635699291E+00, 2.1450367231E+00, 1.3566184121E+00, 8.1443706418E-01],
	[2.1490000000E+04, 1.2357745601E+01, 5.2634586215E+00, 2.1466345877E+00, 1.3573023453E+00, 8.1452293518E-01],
	[2.1495000000E+04, 1.2362087103E+01, 5.2633473422E+00, 2.1482332697E+00, 1.3579863140E+00, 8.1460877152E-01],
	[2.1500000000E+04, 1.2366429119E+01, 5.2632360911E+00, 2.1498327694E+00, 1.3586703182E+00, 8.1469457318E-01],
	[2.1505000000E+04, 1.2370771651E+01, 5.2631248683E+00, 2.1514330869E+00, 1.3593543577E+00, 8.1478034018E-01],
	[2.1510000000E+04, 1.2375114697E+01, 5.2630136736E+00, 2.1530342226E+00, 1.3600384322E+00, 8.1486607253E-01],
	[2.1515000000E+04, 1.2379458258E+01, 5.2629025071E+00, 2.1546361767E+00, 1.3607225418E+00, 8.1495177022E-01],
	[2.1520000000E+04, 1.2383802333E+01, 5.2627913688E+00, 2.1562389493E+00, 1.3614066861E+00, 8.1503743326E-01],
	[2.1525000000E+04, 1.2388146924E+01, 5.2626802587E+00, 2.1578425407E+00, 1.3620908651E+00, 8.1512306165E-01],
	[2.1530000000E+04, 1.2392492028E+01, 5.2625691768E+00, 2.1594469512E+00, 1.3627750786E+00, 8.1520865541E-01],
	[2.1535000000E+04, 1.2396837648E+01, 5.2624581229E+00, 2.1610521809E+00, 1.3634593265E+00, 8.1529421452E-01],
	[2.1540000000E+04, 1.2401183782E+01, 5.2623470972E+00, 2.1626582301E+00, 1.3641436085E+00, 8.1537973901E-01],
	[2.1545000000E+04, 1.2405530430E+01, 5.2622360996E+00, 2.1642650991E+00, 1.3648279246E+00, 8.1546522887E-01],
	[2.1550000000E+04, 1.2409877593E+01, 5.2621251301E+00, 2.1658727879E+00, 1.3655122746E+00, 8.1555068411E-01],
	[2.1555000000E+04, 1.2414225270E+01, 5.2620141887E+00, 2.1674812970E+00, 1.3661966583E+00, 8.1563610473E-01],
	[2.1560000000E+04, 1.2418573461E+01, 5.2619032754E+00, 2.1690906264E+00, 1.3668810756E+00, 8.1572149074E-01],
	[2.1565000000E+04, 1.2422922166E+01, 5.2617923901E+00, 2.1707007765E+00, 1.3675655263E+00, 8.1580684214E-01],
	[2.1570000000E+04, 1.2427271386E+01, 5.2616815328E+00, 2.1723117474E+00, 1.3682500103E+00, 8.1589215894E-01],
	[2.1575000000E+04, 1.2431621119E+01, 5.2615707036E+00, 2.1739235394E+00, 1.3689345275E+00, 8.1597744114E-01],
	[2.1580000000E+04, 1.2435971367E+01, 5.2614599024E+00, 2.1755361527E+00, 1.3696190776E+00, 8.1606268874E-01],
	[2.1585000000E+04, 1.2440322129E+01, 5.2613491292E+00, 2.1771495875E+00, 1.3703036605E+00, 8.1614790176E-01],
	[2.1590000000E+04, 1.2444673404E+01, 5.2612383840E+00, 2.1787638441E+00, 1.3709882760E+00, 8.1623308019E-01],
	[2.1595000000E+04, 1.2449025193E+01, 5.2611276668E+00, 2.1803789227E+00, 1.3716729241E+00, 8.1631822405E-01],
	[2.1600000000E+04, 1.2453377496E+01, 5.2610169775E+00, 2.1819948235E+00, 1.3723576046E+00, 8.1640333333E-01],
	[2.1605000000E+04, 1.2457730313E+01, 5.2609063162E+00, 2.1836115468E+00, 1.3730423172E+00, 8.1648840804E-01],
	[2.1610000000E+04, 1.2462083644E+01, 5.2607956828E+00, 2.1852290927E+00, 1.3737270619E+00, 8.1657344818E-01],
	[2.1615000000E+04, 1.2466437488E+01, 5.2606850773E+00, 2.1868474615E+00, 1.3744118385E+00, 8.1665845377E-01],
	[2.1620000000E+04, 1.2470791845E+01, 5.2605744997E+00, 2.1884666535E+00, 1.3750966468E+00, 8.1674342480E-01],
	[2.1625000000E+04, 1.2475146716E+01, 5.2604639501E+00, 2.1900866688E+00, 1.3757814867E+00, 8.1682836128E-01],
	[2.1630000000E+04, 1.2479502101E+01, 5.2603534283E+00, 2.1917075077E+00, 1.3764663581E+00, 8.1691326322E-01],
	[2.1635000000E+04, 1.2483857999E+01, 5.2602429343E+00, 2.1933291704E+00, 1.3771512608E+00, 8.1699813062E-01],
	[2.1640000000E+04, 1.2488214410E+01, 5.2601324683E+00, 2.1949516571E+00, 1.3778361946E+00, 8.1708296348E-01],
	[2.1645000000E+04, 1.2492571335E+01, 5.2600220300E+00, 2.1965749682E+00, 1.3785211593E+00, 8.1716776181E-01],
	[2.1650000000E+04, 1.2496928772E+01, 5.2599116196E+00, 2.1981991037E+00, 1.3792061549E+00, 8.1725252562E-01],
	[2.1655000000E+04, 1.2501286723E+01, 5.2598012370E+00, 2.1998240639E+00, 1.3798911812E+00, 8.1733725491E-01],
	[2.1660000000E+04, 1.2505645187E+01, 5.2596908822E+00, 2.2014498491E+00, 1.3805762380E+00, 8.1742194968E-01],
	[2.1665000000E+04, 1.2510004164E+01, 5.2595805552E+00, 2.2030764594E+00, 1.3812613252E+00, 8.1750660995E-01],
	[2.1670000000E+04, 1.2514363654E+01, 5.2594702560E+00, 2.2047038952E+00, 1.3819464426E+00, 8.1759123571E-01],
	[2.1675000000E+04, 1.2518723656E+01, 5.2593599845E+00, 2.2063321566E+00, 1.3826315901E+00, 8.1767582697E-01],
	[2.1680000000E+04, 1.2523084172E+01, 5.2592497408E+00, 2.2079612438E+00, 1.3833167674E+00, 8.1776038374E-01],
	[2.1685000000E+04, 1.2527445200E+01, 5.2591395248E+00, 2.2095911572E+00, 1.3840019746E+00, 8.1784490602E-01],
	[2.1690000000E+04, 1.2531806741E+01, 5.2590293365E+00, 2.2112218968E+00, 1.3846872113E+00, 8.1792939381E-01],
	[2.1695000000E+04, 1.2536168795E+01, 5.2589191759E+00, 2.2128534630E+00, 1.3853724775E+00, 8.1801384713E-01],
	[2.1700000000E+04, 1.2540531362E+01, 5.2588090430E+00, 2.2144858560E+00, 1.3860577731E+00, 8.1809826597E-01],
	[2.1705000000E+04, 1.2544894441E+01, 5.2586989378E+00, 2.2161190760E+00, 1.3867430977E+00, 8.1818265035E-01],
	[2.1710000000E+04, 1.2549258032E+01, 5.2585888603E+00, 2.2177531232E+00, 1.3874284514E+00, 8.1826700026E-01],
	[2.1715000000E+04, 1.2553622136E+01, 5.2584788104E+00, 2.2193879978E+00, 1.3881138339E+00, 8.1835131572E-01],
	[2.1720000000E+04, 1.2557986752E+01, 5.2583687882E+00, 2.2210237002E+00, 1.3887992452E+00, 8.1843559673E-01],
	[2.1725000000E+04, 1.2562351881E+01, 5.2582587935E+00, 2.2226602304E+00, 1.3894846849E+00, 8.1851984329E-01],
	[2.1730000000E+04, 1.2566717522E+01, 5.2581488265E+00, 2.2242975888E+00, 1.3901701531E+00, 8.1860405540E-01],
	[2.1735000000E+04, 1.2571102568E+01, 5.2580431053E+00, 2.2259357755E+00, 1.3908561759E+00, 8.1868823309E-01],
	[2.1740000000E+04, 1.2575489326E+01, 5.2579376765E+00, 2.2275747909E+00, 1.3915422608E+00, 8.1877237634E-01],
	[2.1745000000E+04, 1.2579876606E+01, 5.2578322740E+00, 2.2292146351E+00, 1.3922283745E+00, 8.1885648517E-01],
	[2.1750000000E+04, 1.2584264408E+01, 5.2577268978E+00, 2.2308553083E+00, 1.3929145168E+00, 8.1894055957E-01],
	[2.1755000000E+04, 1.2588652730E+01, 5.2576215480E+00, 2.2324968108E+00, 1.3936006875E+00, 8.1902459957E-01],
	[2.1760000000E+04, 1.2593041574E+01, 5.2575162244E+00, 2.2341391428E+00, 1.3942868865E+00, 8.1910860515E-01],
	[2.1765000000E+04, 1.2597430939E+01, 5.2574109272E+00, 2.2357823045E+00, 1.3949731137E+00, 8.1919257633E-01],
	[2.1770000000E+04, 1.2601820825E+01, 5.2573056563E+00, 2.2374262962E+00, 1.3956593689E+00, 8.1927651312E-01],
	[2.1775000000E+04, 1.2606211233E+01, 5.2572004117E+00, 2.2390711181E+00, 1.3963456519E+00, 8.1936041551E-01],
	[2.1780000000E+04, 1.2610602161E+01, 5.2570951933E+00, 2.2407167704E+00, 1.3970319626E+00, 8.1944428352E-01],
	[2.1785000000E+04, 1.2614993611E+01, 5.2569900012E+00, 2.2423632533E+00, 1.3977183009E+00, 8.1952811714E-01],
	[2.1790000000E+04, 1.2619385581E+01, 5.2568848354E+00, 2.2440105671E+00, 1.3984046666E+00, 8.1961191640E-01],
	[2.1795000000E+04, 1.2623778072E+01, 5.2567796957E+00, 2.2456587120E+00, 1.3990910595E+00, 8.1969568128E-01],
	[2.1800000000E+04, 1.2628171084E+01, 5.2566745823E+00, 2.2473076883E+00, 1.3997774795E+00, 8.1977941179E-01],
	[2.1805000000E+04, 1.2632564617E+01, 5.2565694951E+00, 2.2489574961E+00, 1.4004639264E+00, 8.1986310795E-01],
	[2.1810000000E+04, 1.2636958671E+01, 5.2564644341E+00, 2.2506081357E+00, 1.4011504002E+00, 8.1994676976E-01],
	[2.1815000000E+04, 1.2641353245E+01, 5.2563593993E+00, 2.2522596073E+00, 1.4018369006E+00, 8.2003039722E-01],
	[2.1820000000E+04, 1.2645748340E+01, 5.2562543906E+00, 2.2539119111E+00, 1.4025234275E+00, 8.2011399033E-01],
	[2.1825000000E+04, 1.2650143955E+01, 5.2561494081E+00, 2.2555650474E+00, 1.4032099807E+00, 8.2019754912E-01],
	[2.1830000000E+04, 1.2654540091E+01, 5.2560444518E+00, 2.2572190164E+00, 1.4038965601E+00, 8.2028107357E-01],
	[2.1835000000E+04, 1.2658936747E+01, 5.2559395216E+00, 2.2588738183E+00, 1.4045831656E+00, 8.2036456370E-01],
	[2.1840000000E+04, 1.2663333924E+01, 5.2558346175E+00, 2.2605294534E+00, 1.4052697969E+00, 8.2044801951E-01],
	[2.1845000000E+04, 1.2667731621E+01, 5.2557297395E+00, 2.2621859219E+00, 1.4059564540E+00, 8.2053144101E-01],
	[2.1850000000E+04, 1.2672129838E+01, 5.2556248876E+00, 2.2638432239E+00, 1.4066431367E+00, 8.2061482820E-01],
	[2.1855000000E+04, 1.2676528575E+01, 5.2555200617E+00, 2.2655013599E+00, 1.4073298448E+00, 8.2069818109E-01],
	[2.1860000000E+04, 1.2680927833E+01, 5.2554152620E+00, 2.2671603298E+00, 1.4080165782E+00, 8.2078149968E-01],
	[2.1865000000E+04, 1.2685327610E+01, 5.2553104883E+00, 2.2688201341E+00, 1.4087033368E+00, 8.2086478399E-01],
	[2.1870000000E+04, 1.2689727908E+01, 5.2552057406E+00, 2.2704807729E+00, 1.4093901203E+00, 8.2094803401E-01],
	[2.1875000000E+04, 1.2694128725E+01, 5.2551010190E+00, 2.2721422464E+00, 1.4100769287E+00, 8.2103124976E-01],
	[2.1880000000E+04, 1.2698530063E+01, 5.2549963234E+00, 2.2738045549E+00, 1.4107637618E+00, 8.2111443123E-01],
	[2.1885000000E+04, 1.2702931920E+01, 5.2548916538E+00, 2.2754676986E+00, 1.4114506194E+00, 8.2119757844E-01],
	[2.1890000000E+04, 1.2707334297E+01, 5.2547870102E+00, 2.2771316778E+00, 1.4121375014E+00, 8.2128069139E-01],
	[2.1895000000E+04, 1.2711737194E+01, 5.2546823926E+00, 2.2787964926E+00, 1.4128244076E+00, 8.2136377008E-01],
	[2.1900000000E+04, 1.2716140610E+01, 5.2545778010E+00, 2.2804621433E+00, 1.4135113379E+00, 8.2144681453E-01],
	[2.1905000000E+04, 1.2720544546E+01, 5.2544732353E+00, 2.2821286301E+00, 1.4141982922E+00, 8.2152982474E-01],
	[2.1910000000E+04, 1.2724949002E+01, 5.2543686956E+00, 2.2837959533E+00, 1.4148852702E+00, 8.2161280071E-01],
	[2.1915000000E+04, 1.2729353977E+01, 5.2542641817E+00, 2.2854641130E+00, 1.4155722719E+00, 8.2169574245E-01],
	[2.1920000000E+04, 1.2733759471E+01, 5.2541596939E+00, 2.2871331096E+00, 1.4162592971E+00, 8.2177864997E-01],
	[2.1925000000E+04, 1.2738165485E+01, 5.2540552319E+00, 2.2888029432E+00, 1.4169463456E+00, 8.2186152327E-01],
	[2.1930000000E+04, 1.2742572019E+01, 5.2539507958E+00, 2.2904736140E+00, 1.4176334173E+00, 8.2194436236E-01],
	[2.1935000000E+04, 1.2746979071E+01, 5.2538463856E+00, 2.2921451223E+00, 1.4183205121E+00, 8.2202716724E-01],
	[2.1940000000E+04, 1.2751386643E+01, 5.2537420013E+00, 2.2938174684E+00, 1.4190076297E+00, 8.2210993793E-01],
	[2.1945000000E+04, 1.2755794734E+01, 5.2536376428E+00, 2.2954906524E+00, 1.4196947701E+00, 8.2219267442E-01],
	[2.1950000000E+04, 1.2760203344E+01, 5.2535333102E+00, 2.2971646745E+00, 1.4203819331E+00, 8.2227537673E-01],
	[2.1955000000E+04, 1.2764612473E+01, 5.2534290034E+00, 2.2988395351E+00, 1.4210691185E+00, 8.2235804485E-01],
	[2.1960000000E+04, 1.2769022121E+01, 5.2533247224E+00, 2.3005152342E+00, 1.4217563262E+00, 8.2244067880E-01],
	[2.1965000000E+04, 1.2773432288E+01, 5.2532204673E+00, 2.3021917723E+00, 1.4224435561E+00, 8.2252327859E-01],
	[2.1970000000E+04, 1.2777842974E+01, 5.2531162379E+00, 2.3038691494E+00, 1.4231308079E+00, 8.2260584421E-01],
	[2.1975000000E+04, 1.2782254178E+01, 5.2530120344E+00, 2.3055473658E+00, 1.4238180817E+00, 8.2268837567E-01],
	[2.1980000000E+04, 1.2786665902E+01, 5.2529078566E+00, 2.3072264218E+00, 1.4245053771E+00, 8.2277087299E-01],
	[2.1985000000E+04, 1.2791078144E+01, 5.2528037045E+00, 2.3089063176E+00, 1.4251926940E+00, 8.2285333616E-01],
	[2.1990000000E+04, 1.2795490905E+01, 5.2526995782E+00, 2.3105870533E+00, 1.4258800324E+00, 8.2293576520E-01],
	[2.1995000000E+04, 1.2799904184E+01, 5.2525954777E+00, 2.3122686293E+00, 1.4265673920E+00, 8.2301816011E-01],
	[2.2000000000E+04, 1.2804317982E+01, 5.2524914029E+00, 2.3139510457E+00, 1.4272547727E+00, 8.2310052089E-01],
	[2.2005000000E+04, 1.2808732298E+01, 5.2523873538E+00, 2.3156343029E+00, 1.4279421744E+00, 8.2318284755E-01],
	[2.2010000000E+04, 1.2813147133E+01, 5.2522833303E+00, 2.3173184009E+00, 1.4286295968E+00, 8.2326514011E-01],
	[2.2015000000E+04, 1.2817562486E+01, 5.2521793326E+00, 2.3190033400E+00, 1.4293170399E+00, 8.2334739856E-01],
	[2.2020000000E+04, 1.2821978357E+01, 5.2520753606E+00, 2.3206891206E+00, 1.4300045036E+00, 8.2342962291E-01],
	[2.2025000000E+04, 1.2826394747E+01, 5.2519714142E+00, 2.3223757427E+00, 1.4306919876E+00, 8.2351181316E-01],
	[2.2030000000E+04, 1.2830811655E+01, 5.2518674934E+00, 2.3240632067E+00, 1.4313794918E+00, 8.2359396934E-01],
	[2.2035000000E+04, 1.2835229081E+01, 5.2517635983E+00, 2.3257515127E+00, 1.4320670160E+00, 8.2367609143E-01],
	[2.2040000000E+04, 1.2839647025E+01, 5.2516597289E+00, 2.3274406610E+00, 1.4327545602E+00, 8.2375817945E-01],
	[2.2045000000E+04, 1.2844065487E+01, 5.2515558850E+00, 2.3291306518E+00, 1.4334421242E+00, 8.2384023340E-01],
	[2.2050000000E+04, 1.2848484467E+01, 5.2514520668E+00, 2.3308214853E+00, 1.4341297077E+00, 8.2392225330E-01],
	[2.2055000000E+04, 1.2852903965E+01, 5.2513482741E+00, 2.3325131619E+00, 1.4348173108E+00, 8.2400423914E-01],
	[2.2060000000E+04, 1.2857323980E+01, 5.2512445070E+00, 2.3342056816E+00, 1.4355049331E+00, 8.2408619093E-01],
	[2.2065000000E+04, 1.2861744514E+01, 5.2511407655E+00, 2.3358990447E+00, 1.4361925747E+00, 8.2416810869E-01],
	[2.2070000000E+04, 1.2866165565E+01, 5.2510370495E+00, 2.3375932515E+00, 1.4368802352E+00, 8.2424999241E-01],
	[2.2075000000E+04, 1.2870587134E+01, 5.2509333591E+00, 2.3392883022E+00, 1.4375679146E+00, 8.2433184210E-01],
	[2.2080000000E+04, 1.2875009221E+01, 5.2508296942E+00, 2.3409841969E+00, 1.4382556128E+00, 8.2441365778E-01],
	[2.2085000000E+04, 1.2879451646E+01, 5.2507303599E+00, 2.3426809361E+00, 1.4389439002E+00, 8.2449543944E-01],
	[2.2090000000E+04, 1.2883895105E+01, 5.2506311599E+00, 2.3443785197E+00, 1.4396322216E+00, 8.2457718709E-01],
	[2.2095000000E+04, 1.2888339090E+01, 5.2505319843E+00, 2.3460769482E+00, 1.4403205620E+00, 8.2465890075E-01],
	[2.2100000000E+04, 1.2892783603E+01, 5.2504328331E+00, 2.3477762217E+00, 1.4410089213E+00, 8.2474058040E-01],
	[2.2105000000E+04, 1.2897228642E+01, 5.2503337061E+00, 2.3494763405E+00, 1.4416972995E+00, 8.2482222608E-01],
	[2.2110000000E+04, 1.2901674208E+01, 5.2502346034E+00, 2.3511773047E+00, 1.4423856964E+00, 8.2490383777E-01],
	[2.2115000000E+04, 1.2906120300E+01, 5.2501355250E+00, 2.3528791147E+00, 1.4430741118E+00, 8.2498541549E-01],
	[2.2120000000E+04, 1.2910566919E+01, 5.2500364708E+00, 2.3545817706E+00, 1.4437625455E+00, 8.2506695924E-01],
	[2.2125000000E+04, 1.2915014065E+01, 5.2499374409E+00, 2.3562852726E+00, 1.4444509975E+00, 8.2514846903E-01],
	[2.2130000000E+04, 1.2919461737E+01, 5.2498384353E+00, 2.3579896211E+00, 1.4451394676E+00, 8.2522994487E-01],
	[2.2135000000E+04, 1.2923909935E+01, 5.2497394539E+00, 2.3596948162E+00, 1.4458279556E+00, 8.2531138676E-01],
	[2.2140000000E+04, 1.2928358660E+01, 5.2496404967E+00, 2.3614008581E+00, 1.4465164613E+00, 8.2539279471E-01],
	[2.2145000000E+04, 1.2932807911E+01, 5.2495415637E+00, 2.3631077471E+00, 1.4472049848E+00, 8.2547416873E-01],
	[2.2150000000E+04, 1.2937257688E+01, 5.2494426549E+00, 2.3648154834E+00, 1.4478935257E+00, 8.2555550883E-01],
	[2.2155000000E+04, 1.2941707991E+01, 5.2493437703E+00, 2.3665240673E+00, 1.4485820839E+00, 8.2563681500E-01],
	[2.2160000000E+04, 1.2946158820E+01, 5.2492449099E+00, 2.3682334989E+00, 1.4492706594E+00, 8.2571808726E-01],
	[2.2165000000E+04, 1.2950610176E+01, 5.2491460737E+00, 2.3699437785E+00, 1.4499592519E+00, 8.2579932562E-01],
	[2.2170000000E+04, 1.2955062057E+01, 5.2490472616E+00, 2.3716549064E+00, 1.4506478612E+00, 8.2588053007E-01],
	[2.2175000000E+04, 1.2959514465E+01, 5.2489484736E+00, 2.3733668827E+00, 1.4513364874E+00, 8.2596170064E-01],
	[2.2180000000E+04, 1.2963967398E+01, 5.2488497098E+00, 2.3750797077E+00, 1.4520251302E+00, 8.2604283732E-01],
	[2.2185000000E+04, 1.2968420857E+01, 5.2487509701E+00, 2.3767933816E+00, 1.4527137894E+00, 8.2612394013E-01],
	[2.2190000000E+04, 1.2972874842E+01, 5.2486522545E+00, 2.3785079046E+00, 1.4534024649E+00, 8.2620500906E-01],
	[2.2195000000E+04, 1.2977329352E+01, 5.2485535630E+00, 2.3802232770E+00, 1.4540911567E+00, 8.2628604413E-01],
	[2.2200000000E+04, 1.2981784389E+01, 5.2484548956E+00, 2.3819394990E+00, 1.4547798644E+00, 8.2636704534E-01],
	[2.2205000000E+04, 1.2986239950E+01, 5.2483562522E+00, 2.3836565709E+00, 1.4554685880E+00, 8.2644801270E-01],
	[2.2210000000E+04, 1.2990696038E+01, 5.2482576329E+00, 2.3853744928E+00, 1.4561573274E+00, 8.2652894622E-01],
	[2.2215000000E+04, 1.2995152651E+01, 5.2481590377E+00, 2.3870932649E+00, 1.4568460823E+00, 8.2660984591E-01],
	[2.2220000000E+04, 1.2999609789E+01, 5.2480604665E+00, 2.3888128876E+00, 1.4575348527E+00, 8.2669071176E-01],
	[2.2225000000E+04, 1.3004067452E+01, 5.2479619194E+00, 2.3905333610E+00, 1.4582236384E+00, 8.2677154380E-01],
	[2.2230000000E+04, 1.3008525641E+01, 5.2478633962E+00, 2.3922546854E+00, 1.4589124392E+00, 8.2685234201E-01],
	[2.2235000000E+04, 1.3012984356E+01, 5.2477648971E+00, 2.3939768610E+00, 1.4596012550E+00, 8.2693310643E-01],
	[2.2240000000E+04, 1.3017443595E+01, 5.2476664219E+00, 2.3956998881E+00, 1.4602900856E+00, 8.2701383704E-01],
	[2.2245000000E+04, 1.3021903360E+01, 5.2475679708E+00, 2.3974237667E+00, 1.4609789310E+00, 8.2709453386E-01],
	[2.2250000000E+04, 1.3026363649E+01, 5.2474695436E+00, 2.3991484973E+00, 1.4616677910E+00, 8.2717519689E-01],
	[2.2255000000E+04, 1.3030824464E+01, 5.2473711404E+00, 2.4008740800E+00, 1.4623566653E+00, 8.2725582614E-01],
	[2.2260000000E+04, 1.3035285804E+01, 5.2472727611E+00, 2.4026005150E+00, 1.4630455539E+00, 8.2733642162E-01],
	[2.2265000000E+04, 1.3039747668E+01, 5.2471744058E+00, 2.4043278026E+00, 1.4637344567E+00, 8.2741698334E-01],
	[2.2270000000E+04, 1.3044210058E+01, 5.2470760744E+00, 2.4060559430E+00, 1.4644233734E+00, 8.2749751130E-01],
	[2.2275000000E+04, 1.3048672972E+01, 5.2469777669E+00, 2.4077849364E+00, 1.4651123040E+00, 8.2757800551E-01],
	[2.2280000000E+04, 1.3053136411E+01, 5.2468794833E+00, 2.4095147831E+00, 1.4658012483E+00, 8.2765846598E-01],
	[2.2285000000E+04, 1.3057600374E+01, 5.2467812236E+00, 2.4112454833E+00, 1.4664902061E+00, 8.2773889271E-01],
	[2.2290000000E+04, 1.3062064863E+01, 5.2466829878E+00, 2.4129770372E+00, 1.4671791773E+00, 8.2781928571E-01],
	[2.2295000000E+04, 1.3066529876E+01, 5.2465847759E+00, 2.4147094450E+00, 1.4678681617E+00, 8.2789964500E-01],
	[2.2300000000E+04, 1.3070995413E+01, 5.2464865878E+00, 2.4164427070E+00, 1.4685571593E+00, 8.2797997057E-01],
	[2.2305000000E+04, 1.3075461475E+01, 5.2463884236E+00, 2.4181768234E+00, 1.4692461698E+00, 8.2806026243E-01],
	[2.2310000000E+04, 1.3079928061E+01, 5.2462902832E+00, 2.4199117945E+00, 1.4699351931E+00, 8.2814052059E-01],
	[2.2315000000E+04, 1.3084395172E+01, 5.2461921666E+00, 2.4216476204E+00, 1.4706242291E+00, 8.2822074506E-01],
	[2.2320000000E+04, 1.3088862807E+01, 5.2460940739E+00, 2.4233843014E+00, 1.4713132777E+00, 8.2830093585E-01],
	[2.2325000000E+04, 1.3093330966E+01, 5.2459960050E+00, 2.4251218377E+00, 1.4720023386E+00, 8.2838109296E-01],
	[2.2330000000E+04, 1.3097799650E+01, 5.2458979598E+00, 2.4268602296E+00, 1.4726914117E+00, 8.2846121640E-01],
	[2.2335000000E+04, 1.3102268857E+01, 5.2457999385E+00, 2.4285994772E+00, 1.4733804970E+00, 8.2854130618E-01],
	[2.2340000000E+04, 1.3106738589E+01, 5.2457019409E+00, 2.4303395808E+00, 1.4740695942E+00, 8.2862136231E-01],
	[2.2345000000E+04, 1.3111208845E+01, 5.2456039671E+00, 2.4320805407E+00, 1.4747587031E+00, 8.2870138478E-01],
	[2.2350000000E+04, 1.3115679624E+01, 5.2455060170E+00, 2.4338223571E+00, 1.4754478238E+00, 8.2878137362E-01],
	[2.2355000000E+04, 1.3120150928E+01, 5.2454080907E+00, 2.4355650301E+00, 1.4761369560E+00, 8.2886132883E-01],
	[2.2360000000E+04, 1.3124622755E+01, 5.2453101880E+00, 2.4373085601E+00, 1.4768260995E+00, 8.2894125041E-01],
	[2.2365000000E+04, 1.3129095106E+01, 5.2452123092E+00, 2.4390630191E+00, 1.4775189502E+00, 8.2902113837E-01],
	[2.2370000000E+04, 1.3133567981E+01, 5.2451144540E+00, 2.4408199883E+00, 1.4782124146E+00, 8.2910099272E-01],
	[2.2375000000E+04, 1.3138041380E+01, 5.2450166225E+00, 2.4425778292E+00, 1.4789058907E+00, 8.2918081347E-01],
	[2.2380000000E+04, 1.3142515302E+01, 5.2449188147E+00, 2.4443365420E+00, 1.4795993785E+00, 8.2926060063E-01],
	[2.2385000000E+04, 1.3146989748E+01, 5.2448210305E+00, 2.4460961271E+00, 1.4802928779E+00, 8.2934035420E-01],
	[2.2390000000E+04, 1.3151464718E+01, 5.2447232701E+00, 2.4478565845E+00, 1.4809863885E+00, 8.2942007418E-01],
	[2.2395000000E+04, 1.3155940210E+01, 5.2446255332E+00, 2.4496179147E+00, 1.4816799105E+00, 8.2949976060E-01],
	[2.2400000000E+04, 1.3160416227E+01, 5.2445278200E+00, 2.4513801177E+00, 1.4823734434E+00, 8.2957941345E-01],
	[2.2405000000E+04, 1.3164892766E+01, 5.2444301305E+00, 2.4531431939E+00, 1.4830669873E+00, 8.2965903275E-01],
	[2.2410000000E+04, 1.3169369829E+01, 5.2443324646E+00, 2.4549071435E+00, 1.4837605420E+00, 8.2973861849E-01],
	[2.2415000000E+04, 1.3173847415E+01, 5.2442348222E+00, 2.4566719667E+00, 1.4844541074E+00, 8.2981817070E-01],
	[2.2420000000E+04, 1.3178325525E+01, 5.2441372035E+00, 2.4584376637E+00, 1.4851476832E+00, 8.2989768937E-01],
	[2.2425000000E+04, 1.3182804157E+01, 5.2440396083E+00, 2.4602042349E+00, 1.4858412693E+00, 8.2997717451E-01],
	[2.2430000000E+04, 1.3187283313E+01, 5.2439420368E+00, 2.4619716803E+00, 1.4865348656E+00, 8.3005662613E-01],
	[2.2435000000E+04, 1.3191762991E+01, 5.2438444887E+00, 2.4637400003E+00, 1.4872284720E+00, 8.3013604425E-01],
	[2.2440000000E+04, 1.3196261363E+01, 5.2437508034E+00, 2.4655091952E+00, 1.4879226284E+00, 8.3021542886E-01],
	[2.2445000000E+04, 1.3200762673E+01, 5.2436576489E+00, 2.4672792650E+00, 1.4886168669E+00, 8.3029477997E-01],
	[2.2450000000E+04, 1.3205264514E+01, 5.2435645167E+00, 2.4690502102E+00, 1.4893111157E+00, 8.3037409760E-01],
	[2.2455000000E+04, 1.3209766888E+01, 5.2434714070E+00, 2.4708220308E+00, 1.4900053749E+00, 8.3045338175E-01],
	[2.2460000000E+04, 1.3214269794E+01, 5.2433783197E+00, 2.4725947273E+00, 1.4906996443E+00, 8.3053263242E-01],
	[2.2465000000E+04, 1.3218773232E+01, 5.2432852547E+00, 2.4743682996E+00, 1.4913939236E+00, 8.3061184963E-01],
	[2.2470000000E+04, 1.3223277202E+01, 5.2431922121E+00, 2.4761427483E+00, 1.4920882128E+00, 8.3069103338E-01],
	[2.2475000000E+04, 1.3227781705E+01, 5.2430991918E+00, 2.4779180734E+00, 1.4927825118E+00, 8.3077018369E-01],
	[2.2480000000E+04, 1.3232286739E+01, 5.2430061939E+00, 2.4796942751E+00, 1.4934768202E+00, 8.3084930055E-01],
	[2.2485000000E+04, 1.3236792305E+01, 5.2429132183E+00, 2.4814713539E+00, 1.4941711382E+00, 8.3092838398E-01],
	[2.2490000000E+04, 1.3241298403E+01, 5.2428202650E+00, 2.4832493098E+00, 1.4948654654E+00, 8.3100743399E-01],
	[2.2495000000E+04, 1.3245805032E+01, 5.2427273340E+00, 2.4850281431E+00, 1.4955598017E+00, 8.3108645057E-01],
	[2.2500000000E+04, 1.3250312194E+01, 5.2426344254E+00, 2.4868078540E+00, 1.4962541470E+00, 8.3116543375E-01],
	[2.2505000000E+04, 1.3254819887E+01, 5.2425415390E+00, 2.4885884429E+00, 1.4969485011E+00, 8.3124438353E-01],
	[2.2510000000E+04, 1.3259328111E+01, 5.2424486749E+00, 2.4903699098E+00, 1.4976428640E+00, 8.3132329991E-01],
	[2.2515000000E+04, 1.3263836867E+01, 5.2423558331E+00, 2.4921522551E+00, 1.4983372353E+00, 8.3140218290E-01],
	[2.2520000000E+04, 1.3268346155E+01, 5.2422630135E+00, 2.4939354791E+00, 1.4990316151E+00, 8.3148103252E-01],
	[2.2525000000E+04, 1.3272855974E+01, 5.2421702162E+00, 2.4957195818E+00, 1.4997260032E+00, 8.3155984877E-01],
	[2.2530000000E+04, 1.3277366325E+01, 5.2420774411E+00, 2.4975045636E+00, 1.5004203993E+00, 8.3163863165E-01],
	[2.2535000000E+04, 1.3281877207E+01, 5.2419846883E+00, 2.4992904248E+00, 1.5011148035E+00, 8.3171738118E-01],
	[2.2540000000E+04, 1.3286388620E+01, 5.2418919576E+00, 2.5010771655E+00, 1.5018092154E+00, 8.3179609737E-01],
	[2.2545000000E+04, 1.3290900564E+01, 5.2417992492E+00, 2.5028647859E+00, 1.5025036350E+00, 8.3187478022E-01],
	[2.2550000000E+04, 1.3295413040E+01, 5.2417065630E+00, 2.5046532864E+00, 1.5031980622E+00, 8.3195342973E-01],
	[2.2555000000E+04, 1.3299926046E+01, 5.2416138990E+00, 2.5064426671E+00, 1.5038924967E+00, 8.3203204593E-01],
	[2.2560000000E+04, 1.3304439584E+01, 5.2415212571E+00, 2.5082329284E+00, 1.5045869385E+00, 8.3211062881E-01],
	[2.2565000000E+04, 1.3308953652E+01, 5.2414286374E+00, 2.5100240704E+00, 1.5052813874E+00, 8.3218917838E-01],
	[2.2570000000E+04, 1.3313468252E+01, 5.2413360399E+00, 2.5118160933E+00, 1.5059758432E+00, 8.3226769466E-01],
	[2.2575000000E+04, 1.3317983383E+01, 5.2412434645E+00, 2.5136089974E+00, 1.5066703059E+00, 8.3234617764E-01],
	[2.2580000000E+04, 1.3322499044E+01, 5.2411509112E+00, 2.5154027830E+00, 1.5073647752E+00, 8.3242462734E-01],
	[2.2585000000E+04, 1.3327015236E+01, 5.2410583801E+00, 2.5171974503E+00, 1.5080592510E+00, 8.3250304377E-01],
	[2.2590000000E+04, 1.3331531959E+01, 5.2409658711E+00, 2.5189929995E+00, 1.5087537332E+00, 8.3258142693E-01],
	[2.2595000000E+04, 1.3336049212E+01, 5.2408733842E+00, 2.5207894309E+00, 1.5094482216E+00, 8.3265977682E-01],
	[2.2600000000E+04, 1.3340566997E+01, 5.2407809194E+00, 2.5225867446E+00, 1.5101427161E+00, 8.3273809345E-01],
	[2.2605000000E+04, 1.3345085311E+01, 5.2406884766E+00, 2.5243849410E+00, 1.5108372166E+00, 8.3281637683E-01],
	[2.2610000000E+04, 1.3349604156E+01, 5.2405960560E+00, 2.5261840203E+00, 1.5115317228E+00, 8.3289462697E-01],
	[2.2615000000E+04, 1.3354123532E+01, 5.2405036574E+00, 2.5279839826E+00, 1.5122262347E+00, 8.3297284386E-01],
	[2.2620000000E+04, 1.3358643438E+01, 5.2404112809E+00, 2.5297848283E+00, 1.5129207521E+00, 8.3305102752E-01],
	[2.2625000000E+04, 1.3363163874E+01, 5.2403189264E+00, 2.5315865576E+00, 1.5136152748E+00, 8.3312917796E-01],
	[2.2630000000E+04, 1.3367684841E+01, 5.2402265939E+00, 2.5333891707E+00, 1.5143098028E+00, 8.3320729517E-01],
	[2.2635000000E+04, 1.3372206338E+01, 5.2401342835E+00, 2.5351926679E+00, 1.5150043358E+00, 8.3328537917E-01],
	[2.2640000000E+04, 1.3376728365E+01, 5.2400419951E+00, 2.5369970493E+00, 1.5156988738E+00, 8.3336342995E-01],
	[2.2645000000E+04, 1.3381250922E+01, 5.2399497287E+00, 2.5388023153E+00, 1.5163934166E+00, 8.3344144754E-01],
	[2.2650000000E+04, 1.3385774009E+01, 5.2398574843E+00, 2.5406084661E+00, 1.5170879640E+00, 8.3351943193E-01],
	[2.2655000000E+04, 1.3390297627E+01, 5.2397652619E+00, 2.5424155018E+00, 1.5177825159E+00, 8.3359738313E-01],
	[2.2660000000E+04, 1.3394821774E+01, 5.2396730614E+00, 2.5442234228E+00, 1.5184770722E+00, 8.3367530115E-01],
	[2.2665000000E+04, 1.3399346451E+01, 5.2395808829E+00, 2.5460322293E+00, 1.5191716326E+00, 8.3375318599E-01],
	[2.2670000000E+04, 1.3403871658E+01, 5.2394887264E+00, 2.5478419215E+00, 1.5198661972E+00, 8.3383103766E-01],
	[2.2675000000E+04, 1.3408397395E+01, 5.2393965918E+00, 2.5496524997E+00, 1.5205607656E+00, 8.3390885617E-01],
	[2.2680000000E+04, 1.3412923661E+01, 5.2393044791E+00, 2.5514639641E+00, 1.5212553379E+00, 8.3398664152E-01],
	[2.2685000000E+04, 1.3417450457E+01, 5.2392123884E+00, 2.5532763149E+00, 1.5219499138E+00, 8.3406439371E-01],
	[2.2690000000E+04, 1.3421977783E+01, 5.2391203196E+00, 2.5550895523E+00, 1.5226444931E+00, 8.3414211277E-01],
	[2.2695000000E+04, 1.3426505638E+01, 5.2390282726E+00, 2.5569036767E+00, 1.5233390758E+00, 8.3421979868E-01],
	[2.2700000000E+04, 1.3431034023E+01, 5.2389362476E+00, 2.5587186882E+00, 1.5240336618E+00, 8.3429745147E-01],
	[2.2705000000E+04, 1.3435562938E+01, 5.2388442445E+00, 2.5605345871E+00, 1.5247282508E+00, 8.3437507112E-01],
	[2.2710000000E+04, 1.3440092381E+01, 5.2387522632E+00, 2.5623513737E+00, 1.5254228427E+00, 8.3445265766E-01],
	[2.2715000000E+04, 1.3444622354E+01, 5.2386603038E+00, 2.5641690480E+00, 1.5261174374E+00, 8.3453021109E-01],
	[2.2720000000E+04, 1.3449152857E+01, 5.2385683663E+00, 2.5659876105E+00, 1.5268120347E+00, 8.3460773141E-01],
	[2.2725000000E+04, 1.3453683888E+01, 5.2384764505E+00, 2.5678070613E+00, 1.5275066345E+00, 8.3468521863E-01],
	[2.2730000000E+04, 1.3458215449E+01, 5.2383845567E+00, 2.5696274007E+00, 1.5282012367E+00, 8.3476267276E-01],
	[2.2735000000E+04, 1.3462747539E+01, 5.2382926846E+00, 2.5714486289E+00, 1.5288958411E+00, 8.3484009381E-01],
	[2.2740000000E+04, 1.3467280158E+01, 5.2382008344E+00, 2.5732707462E+00, 1.5295904475E+00, 8.3491748178E-01],
	[2.2745000000E+04, 1.3471813306E+01, 5.2381090059E+00, 2.5750937527E+00, 1.5302850558E+00, 8.3499483667E-01],
	[2.2750000000E+04, 1.3476346983E+01, 5.2380171993E+00, 2.5769176487E+00, 1.5309796660E+00, 8.3507215850E-01],
	[2.2755000000E+04, 1.3480881189E+01, 5.2379254145E+00, 2.5787424345E+00, 1.5316742778E+00, 8.3514944727E-01],
	[2.2760000000E+04, 1.3485415924E+01, 5.2378336514E+00, 2.5805681103E+00, 1.5323688910E+00, 8.3522670298E-01],
	[2.2765000000E+04, 1.3489951188E+01, 5.2377419100E+00, 2.5823946764E+00, 1.5330635056E+00, 8.3530392565E-01],
	[2.2770000000E+04, 1.3494486980E+01, 5.2376501905E+00, 2.5842221329E+00, 1.5337581214E+00, 8.3538111529E-01],
	[2.2775000000E+04, 1.3499023301E+01, 5.2375584927E+00, 2.5860504801E+00, 1.5344527383E+00, 8.3545827189E-01],
	[2.2780000000E+04, 1.3503560151E+01, 5.2374668166E+00, 2.5878797183E+00, 1.5351473561E+00, 8.3553539546E-01],
	[2.2785000000E+04, 1.3508097529E+01, 5.2373751622E+00, 2.5897098477E+00, 1.5358419747E+00, 8.3561248602E-01],
	[2.2790000000E+04, 1.3512635436E+01, 5.2372835296E+00, 2.5915408685E+00, 1.5365365940E+00, 8.3568954356E-01],
	[2.2795000000E+04, 1.3517173871E+01, 5.2371919186E+00, 2.5933727809E+00, 1.5372312137E+00, 8.3576656810E-01],
	[2.2800000000E+04, 1.3521726303E+01, 5.2371030976E+00, 2.5952055853E+00, 1.5379262467E+00, 8.3584355964E-01],
	[2.2805000000E+04, 1.3526286631E+01, 5.2370158103E+00, 2.5970392818E+00, 1.5386215063E+00, 8.3592051820E-01],
	[2.2810000000E+04, 1.3530847497E+01, 5.2369285435E+00, 2.5988738706E+00, 1.5393167669E+00, 8.3599744376E-01],
	[2.2815000000E+04, 1.3535408901E+01, 5.2368412974E+00, 2.6007093521E+00, 1.5400120282E+00, 8.3607433635E-01],
	[2.2820000000E+04, 1.3539970843E+01, 5.2367540718E+00, 2.6025457265E+00, 1.5407072901E+00, 8.3615119597E-01],
	[2.2825000000E+04, 1.3544533322E+01, 5.2366668668E+00, 2.6043829939E+00, 1.5414025526E+00, 8.3622802263E-01],
	[2.2830000000E+04, 1.3549096339E+01, 5.2365796824E+00, 2.6062211547E+00, 1.5420978154E+00, 8.3630481632E-01],
	[2.2835000000E+04, 1.3553659893E+01, 5.2364925185E+00, 2.6080602090E+00, 1.5427930784E+00, 8.3638157707E-01],
	[2.2840000000E+04, 1.3558223985E+01, 5.2364053751E+00, 2.6099001571E+00, 1.5434883415E+00, 8.3645830488E-01],
	[2.2845000000E+04, 1.3562788614E+01, 5.2363182522E+00, 2.6117409993E+00, 1.5441836045E+00, 8.3653499975E-01],
	[2.2850000000E+04, 1.3567353780E+01, 5.2362311499E+00, 2.6135827357E+00, 1.5448788673E+00, 8.3661166169E-01],
	[2.2855000000E+04, 1.3571919484E+01, 5.2361440681E+00, 2.6154253667E+00, 1.5455741297E+00, 8.3668829071E-01],
	[2.2860000000E+04, 1.3576485725E+01, 5.2360570067E+00, 2.6172688924E+00, 1.5462693916E+00, 8.3676488682E-01],
	[2.2865000000E+04, 1.3581052503E+01, 5.2359699659E+00, 2.6191133131E+00, 1.5469646529E+00, 8.3684145002E-01],
	[2.2870000000E+04, 1.3585619818E+01, 5.2358829455E+00, 2.6209586291E+00, 1.5476599135E+00, 8.3691798031E-01],
	[2.2875000000E+04, 1.3590187670E+01, 5.2357959456E+00, 2.6228048405E+00, 1.5483551731E+00, 8.3699447772E-01],
	[2.2880000000E+04, 1.3594756059E+01, 5.2357089662E+00, 2.6246519476E+00, 1.5490504316E+00, 8.3707094224E-01],
	[2.2885000000E+04, 1.3599324985E+01, 5.2356220072E+00, 2.6264999507E+00, 1.5497456890E+00, 8.3714737387E-01],
	[2.2890000000E+04, 1.3603894448E+01, 5.2355350686E+00, 2.6283488500E+00, 1.5504409450E+00, 8.3722377264E-01],
	[2.2895000000E+04, 1.3608464448E+01, 5.2354481505E+00, 2.6301986456E+00, 1.5511361995E+00, 8.3730013854E-01],
	[2.2900000000E+04, 1.3613034985E+01, 5.2353612528E+00, 2.6320493380E+00, 1.5518314524E+00, 8.3737647159E-01],
	[2.2905000000E+04, 1.3617606058E+01, 5.2352743755E+00, 2.6339009272E+00, 1.5525267035E+00, 8.3745277178E-01],
	[2.2910000000E+04, 1.3622177668E+01, 5.2351875187E+00, 2.6357534136E+00, 1.5532219528E+00, 8.3752903913E-01],
	[2.2915000000E+04, 1.3626749815E+01, 5.2351006822E+00, 2.6376067974E+00, 1.5539172000E+00, 8.3760527364E-01],
	[2.2920000000E+04, 1.3631322498E+01, 5.2350138661E+00, 2.6394610787E+00, 1.5546124450E+00, 8.3768147533E-01],
	[2.2925000000E+04, 1.3635895718E+01, 5.2349270704E+00, 2.6413162579E+00, 1.5553076877E+00, 8.3775764419E-01],
	[2.2930000000E+04, 1.3640469474E+01, 5.2348402950E+00, 2.6431723352E+00, 1.5560029279E+00, 8.3783378024E-01],
	[2.2935000000E+04, 1.3645043767E+01, 5.2347535400E+00, 2.6450293109E+00, 1.5566981655E+00, 8.3790988348E-01],
	[2.2940000000E+04, 1.3649618596E+01, 5.2346668054E+00, 2.6468871851E+00, 1.5573934004E+00, 8.3798595393E-01],
	[2.2945000000E+04, 1.3654193961E+01, 5.2345800910E+00, 2.6487459581E+00, 1.5580886324E+00, 8.3806199158E-01],
	[2.2950000000E+04, 1.3658769863E+01, 5.2344933971E+00, 2.6506056301E+00, 1.5587838614E+00, 8.3813799644E-01],
	[2.2955000000E+04, 1.3663346301E+01, 5.2344067234E+00, 2.6524662014E+00, 1.5594790872E+00, 8.3821396853E-01],
	[2.2960000000E+04, 1.3667923275E+01, 5.2343200701E+00, 2.6543276723E+00, 1.5601743097E+00, 8.3828990784E-01],
	[2.2965000000E+04, 1.3672500785E+01, 5.2342334370E+00, 2.6561900429E+00, 1.5608695288E+00, 8.3836581439E-01],
	[2.2970000000E+04, 1.3677078831E+01, 5.2341468243E+00, 2.6580533135E+00, 1.5615647443E+00, 8.3844168819E-01],
	[2.2975000000E+04, 1.3681657413E+01, 5.2340602318E+00, 2.6599174843E+00, 1.5622599561E+00, 8.3851752924E-01],
	[2.2980000000E+04, 1.3686236531E+01, 5.2339736596E+00, 2.6617825556E+00, 1.5629551640E+00, 8.3859333755E-01],
	[2.2985000000E+04, 1.3690816184E+01, 5.2338871077E+00, 2.6636485276E+00, 1.5636503679E+00, 8.3866911312E-01],
	[2.2990000000E+04, 1.3695396374E+01, 5.2338005760E+00, 2.6655154006E+00, 1.5643455677E+00, 8.3874485597E-01],
	[2.2995000000E+04, 1.3699977099E+01, 5.2337140646E+00, 2.6673831747E+00, 1.5650407632E+00, 8.3882056610E-01],
	[2.3000000000E+04, 1.3704558360E+01, 5.2336275734E+00, 2.6692518503E+00, 1.5657359543E+00, 8.3889624351E-01],
	[2.3005000000E+04, 1.3709140157E+01, 5.2335411024E+00, 2.6711214275E+00, 1.5664311408E+00, 8.3897188823E-01],
	[2.3010000000E+04, 1.3713722489E+01, 5.2334546517E+00, 2.6729919066E+00, 1.5671263226E+00, 8.3904750025E-01],
	[2.3015000000E+04, 1.3718305357E+01, 5.2333682212E+00, 2.6748632879E+00, 1.5678214996E+00, 8.3912307958E-01],
	[2.3020000000E+04, 1.3722888761E+01, 5.2332818109E+00, 2.6767355716E+00, 1.5685166716E+00, 8.3919862622E-01],
	[2.3025000000E+04, 1.3727472699E+01, 5.2331954207E+00, 2.6786087578E+00, 1.5692118385E+00, 8.3927414020E-01],
	[2.3030000000E+04, 1.3732057173E+01, 5.2331090508E+00, 2.6804828469E+00, 1.5699070002E+00, 8.3934962151E-01],
	[2.3035000000E+04, 1.3736642183E+01, 5.2330227010E+00, 2.6823578392E+00, 1.5706021565E+00, 8.3942507016E-01],
	[2.3040000000E+04, 1.3741227728E+01, 5.2329363714E+00, 2.6842337347E+00, 1.5712973072E+00, 8.3950048616E-01],
	[2.3045000000E+04, 1.3745813808E+01, 5.2328500620E+00, 2.6861105338E+00, 1.5719924523E+00, 8.3957586951E-01],
	[2.3050000000E+04, 1.3750400423E+01, 5.2327637727E+00, 2.6879882367E+00, 1.5726875915E+00, 8.3965122023E-01],
	[2.3055000000E+04, 1.3754987573E+01, 5.2326775035E+00, 2.6898668437E+00, 1.5733827249E+00, 8.3972653832E-01],
	[2.3060000000E+04, 1.3759575258E+01, 5.2325912545E+00, 2.6917463550E+00, 1.5740778521E+00, 8.3980182379E-01],
	[2.3065000000E+04, 1.3764163479E+01, 5.2325050255E+00, 2.6936267707E+00, 1.5747729731E+00, 8.3987707665E-01],
	[2.3070000000E+04, 1.3768752234E+01, 5.2324188167E+00, 2.6955080913E+00, 1.5754680878E+00, 8.3995229691E-01],
	[2.3075000000E+04, 1.3773341524E+01, 5.2323326280E+00, 2.6973903168E+00, 1.5761631960E+00, 8.4002748456E-01],
	[2.3080000000E+04, 1.3777931349E+01, 5.2322464594E+00, 2.6992734476E+00, 1.5768582975E+00, 8.4010263963E-01],
	[2.3085000000E+04, 1.3782521709E+01, 5.2321603109E+00, 2.7011574839E+00, 1.5775533923E+00, 8.4017776212E-01],
	[2.3090000000E+04, 1.3787112604E+01, 5.2320741825E+00, 2.7030424258E+00, 1.5782484801E+00, 8.4025285203E-01],
	[2.3095000000E+04, 1.3791704033E+01, 5.2319880741E+00, 2.7049282738E+00, 1.5789435609E+00, 8.4032790937E-01],
	[2.3100000000E+04, 1.3796295997E+01, 5.2319019858E+00, 2.7068150279E+00, 1.5796386345E+00, 8.4040293416E-01],
	[2.3105000000E+04, 1.3800888495E+01, 5.2318159175E+00, 2.7087026884E+00, 1.5803337008E+00, 8.4047792639E-01],
	[2.3110000000E+04, 1.3805481528E+01, 5.2317298692E+00, 2.7105912556E+00, 1.5810287596E+00, 8.4055288609E-01],
	[2.3115000000E+04, 1.3810075096E+01, 5.2316438410E+00, 2.7124807298E+00, 1.5817238109E+00, 8.4062781324E-01],
	[2.3120000000E+04, 1.3814669198E+01, 5.2315578328E+00, 2.7143711110E+00, 1.5824188544E+00, 8.4070270787E-01],
	[2.3125000000E+04, 1.3819263834E+01, 5.2314718447E+00, 2.7162623997E+00, 1.5831138900E+00, 8.4077756998E-01],
	[2.3130000000E+04, 1.3823859005E+01, 5.2313858765E+00, 2.7181545960E+00, 1.5838089176E+00, 8.4085239958E-01],
	[2.3135000000E+04, 1.3828454709E+01, 5.2312999283E+00, 2.7200477001E+00, 1.5845039371E+00, 8.4092719667E-01],
	[2.3140000000E+04, 1.3833050948E+01, 5.2312140001E+00, 2.7219417124E+00, 1.5851989482E+00, 8.4100196127E-01],
	[2.3145000000E+04, 1.3837647722E+01, 5.2311280919E+00, 2.7238366330E+00, 1.5858939510E+00, 8.4107669338E-01],
	[2.3150000000E+04, 1.3842245029E+01, 5.2310422036E+00, 2.7257324622E+00, 1.5865889452E+00, 8.4115139301E-01],
	[2.3155000000E+04, 1.3846842870E+01, 5.2309563353E+00, 2.7276292001E+00, 1.5872839306E+00, 8.4122606017E-01],
	[2.3160000000E+04, 1.3851441245E+01, 5.2308704870E+00, 2.7295268472E+00, 1.5879789073E+00, 8.4130069486E-01],
	[2.3165000000E+04, 1.3856045368E+01, 5.2307857009E+00, 2.7314254035E+00, 1.5886740397E+00, 8.4137529710E-01],
	[2.3170000000E+04, 1.3860665902E+01, 5.2307041080E+00, 2.7333248694E+00, 1.5893696649E+00, 8.4144986689E-01],
	[2.3175000000E+04, 1.3865286980E+01, 5.2306225339E+00, 2.7352252450E+00, 1.5900652817E+00, 8.4152440423E-01],
	[2.3180000000E+04, 1.3869908601E+01, 5.2305409787E+00, 2.7371265307E+00, 1.5907608900E+00, 8.4159890915E-01],
	[2.3185000000E+04, 1.3874530766E+01, 5.2304594424E+00, 2.7390287266E+00, 1.5914564896E+00, 8.4167338164E-01],
	[2.3190000000E+04, 1.3879153473E+01, 5.2303779249E+00, 2.7409318330E+00, 1.5921520804E+00, 8.4174782171E-01],
	[2.3195000000E+04, 1.3883776724E+01, 5.2302964262E+00, 2.7428358501E+00, 1.5928476623E+00, 8.4182222938E-01],
	[2.3200000000E+04, 1.3888400517E+01, 5.2302149464E+00, 2.7447407782E+00, 1.5935432351E+00, 8.4189660465E-01],
	[2.3205000000E+04, 1.3893024854E+01, 5.2301334855E+00, 2.7466466175E+00, 1.5942387986E+00, 8.4197094752E-01],
	[2.3210000000E+04, 1.3897649734E+01, 5.2300520433E+00, 2.7485533682E+00, 1.5949343529E+00, 8.4204525801E-01],
	[2.3215000000E+04, 1.3902275156E+01, 5.2299706199E+00, 2.7504610306E+00, 1.5956298976E+00, 8.4211953612E-01],
	[2.3220000000E+04, 1.3906901121E+01, 5.2298892154E+00, 2.7523696049E+00, 1.5963254327E+00, 8.4219378187E-01],
	[2.3225000000E+04, 1.3911527630E+01, 5.2298078296E+00, 2.7542790914E+00, 1.5970209581E+00, 8.4226799525E-01],
	[2.3230000000E+04, 1.3916154680E+01, 5.2297264627E+00, 2.7561894903E+00, 1.5977164736E+00, 8.4234217628E-01],
	[2.3235000000E+04, 1.3920782274E+01, 5.2296451145E+00, 2.7581008019E+00, 1.5984119790E+00, 8.4241632497E-01],
	[2.3240000000E+04, 1.3925410410E+01, 5.2295637851E+00, 2.7600130263E+00, 1.5991074743E+00, 8.4249044133E-01],
	[2.3245000000E+04, 1.3930039089E+01, 5.2294824744E+00, 2.7619261638E+00, 1.5998029593E+00, 8.4256452535E-01],
	[2.3250000000E+04, 1.3934668310E+01, 5.2294011825E+00, 2.7638402147E+00, 1.6004984338E+00, 8.4263857706E-01],
	[2.3255000000E+04, 1.3939298073E+01, 5.2293199093E+00, 2.7657551791E+00, 1.6011938978E+00, 8.4271259646E-01],
	[2.3260000000E+04, 1.3943928380E+01, 5.2292386549E+00, 2.7676710574E+00, 1.6018893510E+00, 8.4278658355E-01],
	[2.3265000000E+04, 1.3948559228E+01, 5.2291574192E+00, 2.7695878498E+00, 1.6025847935E+00, 8.4286053835E-01],
	[2.3270000000E+04, 1.3953190619E+01, 5.2290762022E+00, 2.7715055565E+00, 1.6032802249E+00, 8.4293446086E-01],
	[2.3275000000E+04, 1.3957822552E+01, 5.2289950039E+00, 2.7734241777E+00, 1.6039756452E+00, 8.4300835110E-01],
	[2.3280000000E+04, 1.3962455027E+01, 5.2289138244E+00, 2.7753437137E+00, 1.6046710543E+00, 8.4308220906E-01],
	[2.3285000000E+04, 1.3967088044E+01, 5.2288326635E+00, 2.7772641647E+00, 1.6053664520E+00, 8.4315603477E-01],
	[2.3290000000E+04, 1.3971721603E+01, 5.2287515213E+00, 2.7791855310E+00, 1.6060618382E+00, 8.4322982822E-01],
	[2.3295000000E+04, 1.3976355705E+01, 5.2286703978E+00, 2.7811078128E+00, 1.6067572127E+00, 8.4330358942E-01],
	[2.3300000000E+04, 1.3980990348E+01, 5.2285892929E+00, 2.7830310104E+00, 1.6074525755E+00, 8.4337731839E-01],
	[2.3305000000E+04, 1.3985625533E+01, 5.2285082067E+00, 2.7849551239E+00, 1.6081479263E+00, 8.4345101513E-01],
	[2.3310000000E+04, 1.3990261261E+01, 5.2284271392E+00, 2.7868801537E+00, 1.6088432650E+00, 8.4352467965E-01],
	[2.3315000000E+04, 1.3994897530E+01, 5.2283460903E+00, 2.7888060999E+00, 1.6095385916E+00, 8.4359831196E-01],
	[2.3320000000E+04, 1.3999534340E+01, 5.2282650600E+00, 2.7907329628E+00, 1.6102339059E+00, 8.4367191206E-01],
	[2.3325000000E+04, 1.4004171693E+01, 5.2281840484E+00, 2.7926607426E+00, 1.6109292076E+00, 8.4374547997E-01],
	[2.3330000000E+04, 1.4008809587E+01, 5.2281030554E+00, 2.7945894396E+00, 1.6116244968E+00, 8.4381901570E-01],
	[2.3335000000E+04, 1.4013448023E+01, 5.2280220810E+00, 2.7965190541E+00, 1.6123197733E+00, 8.4389251924E-01],
	[2.3340000000E+04, 1.4018087000E+01, 5.2279411252E+00, 2.7984495862E+00, 1.6130150369E+00, 8.4396599062E-01],
	[2.3345000000E+04, 1.4022726519E+01, 5.2278601880E+00, 2.8003810361E+00, 1.6137102874E+00, 8.4403942984E-01],
	[2.3350000000E+04, 1.4027366579E+01, 5.2277792694E+00, 2.8023134043E+00, 1.6144055249E+00, 8.4411283690E-01],
	[2.3355000000E+04, 1.4032007181E+01, 5.2276983693E+00, 2.8042466907E+00, 1.6151007491E+00, 8.4418621181E-01],
	[2.3360000000E+04, 1.4036648324E+01, 5.2276174878E+00, 2.8061808958E+00, 1.6157959599E+00, 8.4425955460E-01],
	[2.3365000000E+04, 1.4041290008E+01, 5.2275366249E+00, 2.8081160198E+00, 1.6164911571E+00, 8.4433286525E-01],
	[2.3370000000E+04, 1.4045932234E+01, 5.2274557806E+00, 2.8100520628E+00, 1.6171863407E+00, 8.4440614379E-01],
	[2.3375000000E+04, 1.4050575001E+01, 5.2273749548E+00, 2.8119890252E+00, 1.6178815105E+00, 8.4447939021E-01],
	[2.3380000000E+04, 1.4055218309E+01, 5.2272941475E+00, 2.8139269071E+00, 1.6185766663E+00, 8.4455260453E-01],
	[2.3385000000E+04, 1.4059862158E+01, 5.2272133587E+00, 2.8158657089E+00, 1.6192718081E+00, 8.4462578676E-01],
	[2.3390000000E+04, 1.4064506548E+01, 5.2271325885E+00, 2.8178054307E+00, 1.6199669357E+00, 8.4469893691E-01],
	[2.3395000000E+04, 1.4069151479E+01, 5.2270518368E+00, 2.8197460727E+00, 1.6206620489E+00, 8.4477205498E-01],
	[2.3400000000E+04, 1.4073796951E+01, 5.2269711036E+00, 2.8216876353E+00, 1.6213571477E+00, 8.4484514098E-01],
	[2.3405000000E+04, 1.4078442963E+01, 5.2268903888E+00, 2.8236301187E+00, 1.6220522318E+00, 8.4491819492E-01],
	[2.3410000000E+04, 1.4083089517E+01, 5.2268096926E+00, 2.8255735231E+00, 1.6227473012E+00, 8.4499121681E-01],
	[2.3415000000E+04, 1.4087736611E+01, 5.2267290149E+00, 2.8275178487E+00, 1.6234423558E+00, 8.4506420666E-01],
	[2.3420000000E+04, 1.4092384247E+01, 5.2266483556E+00, 2.8294630957E+00, 1.6241373953E+00, 8.4513716447E-01],
	[2.3425000000E+04, 1.4097032422E+01, 5.2265677148E+00, 2.8314092645E+00, 1.6248324197E+00, 8.4521009026E-01],
	[2.3430000000E+04, 1.4101681139E+01, 5.2264870924E+00, 2.8333563553E+00, 1.6255274288E+00, 8.4528298404E-01],
	[2.3435000000E+04, 1.4106330396E+01, 5.2264064885E+00, 2.8353043683E+00, 1.6262224226E+00, 8.4535584581E-01],
	[2.3440000000E+04, 1.4110980193E+01, 5.2263259030E+00, 2.8372533037E+00, 1.6269174008E+00, 8.4542867558E-01],
	[2.3445000000E+04, 1.4115630531E+01, 5.2262453359E+00, 2.8392031617E+00, 1.6276123633E+00, 8.4550147335E-01],
	[2.3450000000E+04, 1.4120281409E+01, 5.2261647873E+00, 2.8411539427E+00, 1.6283073100E+00, 8.4557423915E-01],
	[2.3455000000E+04, 1.4124932828E+01, 5.2260842571E+00, 2.8431056469E+00, 1.6290022408E+00, 8.4564697297E-01],
	[2.3460000000E+04, 1.4129584787E+01, 5.2260037453E+00, 2.8450582744E+00, 1.6296971555E+00, 8.4571967483E-01],
	[2.3465000000E+04, 1.4134237286E+01, 5.2259232519E+00, 2.8470118256E+00, 1.6303920540E+00, 8.4579234474E-01],
	[2.3470000000E+04, 1.4138890325E+01, 5.2258427769E+00, 2.8489663006E+00, 1.6310869362E+00, 8.4586498270E-01],
	[2.3475000000E+04, 1.4143543905E+01, 5.2257623202E+00, 2.8509216998E+00, 1.6317818019E+00, 8.4593758872E-01],
	[2.3480000000E+04, 1.4148198025E+01, 5.2256818820E+00, 2.8528780233E+00, 1.6324766510E+00, 8.4601016281E-01],
	[2.3485000000E+04, 1.4152852684E+01, 5.2256014621E+00, 2.8548352714E+00, 1.6331714834E+00, 8.4608270498E-01],
	[2.3490000000E+04, 1.4157507884E+01, 5.2255210605E+00, 2.8567934443E+00, 1.6338662990E+00, 8.4615521524E-01],
	[2.3495000000E+04, 1.4162163623E+01, 5.2254406773E+00, 2.8587525424E+00, 1.6345610975E+00, 8.4622769360E-01],
	[2.3500000000E+04, 1.4166819903E+01, 5.2253603125E+00, 2.8607125657E+00, 1.6352558789E+00, 8.4630014006E-01],
	[2.3505000000E+04, 1.4171476722E+01, 5.2252799659E+00, 2.8626735145E+00, 1.6359506430E+00, 8.4637255464E-01],
	[2.3510000000E+04, 1.4176134081E+01, 5.2251996377E+00, 2.8646353892E+00, 1.6366453898E+00, 8.4644493734E-01],
	[2.3515000000E+04, 1.4180791980E+01, 5.2251193278E+00, 2.8665981899E+00, 1.6373401190E+00, 8.4651728817E-01],
	[2.3520000000E+04, 1.4185450418E+01, 5.2250390363E+00, 2.8685619168E+00, 1.6380348306E+00, 8.4658960715E-01],
	[2.3525000000E+04, 1.4190109396E+01, 5.2249587630E+00, 2.8705265703E+00, 1.6387295244E+00, 8.4666189428E-01],
	[2.3530000000E+04, 1.4194768914E+01, 5.2248785080E+00, 2.8724921505E+00, 1.6394242003E+00, 8.4673414956E-01],
	[2.3535000000E+04, 1.4199428971E+01, 5.2247982713E+00, 2.8744586576E+00, 1.6401188581E+00, 8.4680637301E-01],
	[2.3540000000E+04, 1.4204103792E+01, 5.2247208190E+00, 2.8764260921E+00, 1.6408139604E+00, 8.4687856464E-01],
	[2.3545000000E+04, 1.4208786288E+01, 5.2246447700E+00, 2.8783944539E+00, 1.6415092769E+00, 8.4695072446E-01],
	[2.3550000000E+04, 1.4213469332E+01, 5.2245687383E+00, 2.8803637435E+00, 1.6422045758E+00, 8.4702285247E-01],
	[2.3555000000E+04, 1.4218152926E+01, 5.2244927238E+00, 2.8823339610E+00, 1.6428998569E+00, 8.4709494869E-01],
	[2.3560000000E+04, 1.4222837068E+01, 5.2244167266E+00, 2.8843051067E+00, 1.6435951203E+00, 8.4716701311E-01],
	[2.3565000000E+04, 1.4227521758E+01, 5.2243407465E+00, 2.8862771809E+00, 1.6442903656E+00, 8.4723904576E-01],
	[2.3570000000E+04, 1.4232206998E+01, 5.2242647838E+00, 2.8882501836E+00, 1.6449855928E+00, 8.4731104664E-01],
	[2.3575000000E+04, 1.4236892786E+01, 5.2241888382E+00, 2.8902241153E+00, 1.6456808018E+00, 8.4738301576E-01],
	[2.3580000000E+04, 1.4241579122E+01, 5.2241129098E+00, 2.8921989762E+00, 1.6463759924E+00, 8.4745495313E-01],
	[2.3585000000E+04, 1.4246266007E+01, 5.2240369987E+00, 2.8941747664E+00, 1.6470711645E+00, 8.4752685875E-01],
	[2.3590000000E+04, 1.4250953441E+01, 5.2239611047E+00, 2.8961514862E+00, 1.6477663179E+00, 8.4759873264E-01],
	[2.3595000000E+04, 1.4255641423E+01, 5.2238852279E+00, 2.8981291359E+00, 1.6484614526E+00, 8.4767057481E-01],
	[2.3600000000E+04, 1.4260329953E+01, 5.2238093683E+00, 2.9001077157E+00, 1.6491565684E+00, 8.4774238526E-01],
	[2.3605000000E+04, 1.4265019032E+01, 5.2237335259E+00, 2.9020872258E+00, 1.6498516652E+00, 8.4781416401E-01],
	[2.3610000000E+04, 1.4269708658E+01, 5.2236577006E+00, 2.9040676665E+00, 1.6505467428E+00, 8.4788591105E-01],
	[2.3615000000E+04, 1.4274398833E+01, 5.2235818925E+00, 2.9060490381E+00, 1.6512418011E+00, 8.4795762641E-01],
	[2.3620000000E+04, 1.4279089556E+01, 5.2235061015E+00, 2.9080313406E+00, 1.6519368400E+00, 8.4802931009E-01],
	[2.3625000000E+04, 1.4283780828E+01, 5.2234303277E+00, 2.9100145745E+00, 1.6526318593E+00, 8.4810096210E-01],
	[2.3630000000E+04, 1.4288472647E+01, 5.2233545710E+00, 2.9119987399E+00, 1.6533268590E+00, 8.4817258245E-01],
	[2.3635000000E+04, 1.4293165014E+01, 5.2232788315E+00, 2.9139838371E+00, 1.6540218389E+00, 8.4824417115E-01],
	[2.3640000000E+04, 1.4297857929E+01, 5.2232031090E+00, 2.9159698663E+00, 1.6547167988E+00, 8.4831572820E-01],
	[2.3645000000E+04, 1.4302551392E+01, 5.2231274037E+00, 2.9179568278E+00, 1.6554117387E+00, 8.4838725362E-01],
	[2.3650000000E+04, 1.4307245403E+01, 5.2230517155E+00, 2.9199447218E+00, 1.6561066584E+00, 8.4845874742E-01],
	[2.3655000000E+04, 1.4311939961E+01, 5.2229760444E+00, 2.9219335485E+00, 1.6568015577E+00, 8.4853020960E-01],
	[2.3660000000E+04, 1.4316635068E+01, 5.2229003903E+00, 2.9239233082E+00, 1.6574964366E+00, 8.4860164018E-01],
	[2.3665000000E+04, 1.4321330722E+01, 5.2228247534E+00, 2.9259140010E+00, 1.6581912949E+00, 8.4867303915E-01],
	[2.3670000000E+04, 1.4326026923E+01, 5.2227491335E+00, 2.9279056274E+00, 1.6588861324E+00, 8.4874440654E-01],
	[2.3675000000E+04, 1.4330723672E+01, 5.2226735307E+00, 2.9298981874E+00, 1.6595809492E+00, 8.4881574236E-01],
	[2.3680000000E+04, 1.4335420969E+01, 5.2225979449E+00, 2.9318916814E+00, 1.6602757449E+00, 8.4888704660E-01],
	[2.3685000000E+04, 1.4340118813E+01, 5.2225223762E+00, 2.9338861095E+00, 1.6609705196E+00, 8.4895831928E-01],
	[2.3690000000E+04, 1.4344817205E+01, 5.2224468245E+00, 2.9358814721E+00, 1.6616652730E+00, 8.4902956041E-01],
	[2.3695000000E+04, 1.4349516144E+01, 5.2223712899E+00, 2.9378777693E+00, 1.6623600051E+00, 8.4910077000E-01],
	[2.3700000000E+04, 1.4354215630E+01, 5.2222957723E+00, 2.9398750014E+00, 1.6630547156E+00, 8.4917194805E-01],
	[2.3705000000E+04, 1.4358915663E+01, 5.2222202717E+00, 2.9418731687E+00, 1.6637494046E+00, 8.4924309459E-01],
	[2.3710000000E+04, 1.4363616244E+01, 5.2221447882E+00, 2.9438722713E+00, 1.6644440718E+00, 8.4931420961E-01],
	[2.3715000000E+04, 1.4368317372E+01, 5.2220693216E+00, 2.9458723095E+00, 1.6651387171E+00, 8.4938529312E-01],
	[2.3720000000E+04, 1.4373019046E+01, 5.2219938721E+00, 2.9478732836E+00, 1.6658333404E+00, 8.4945634514E-01],
	[2.3725000000E+04, 1.4377721268E+01, 5.2219184395E+00, 2.9498751938E+00, 1.6665279416E+00, 8.4952736567E-01],
	[2.3730000000E+04, 1.4382424037E+01, 5.2218430239E+00, 2.9518780403E+00, 1.6672225205E+00, 8.4959835473E-01],
	[2.3735000000E+04, 1.4387127353E+01, 5.2217676253E+00, 2.9538818233E+00, 1.6679170770E+00, 8.4966931232E-01],
	[2.3740000000E+04, 1.4391831216E+01, 5.2216922437E+00, 2.9558865432E+00, 1.6686116110E+00, 8.4974023845E-01],
	[2.3745000000E+04, 1.4396535626E+01, 5.2216168791E+00, 2.9578922002E+00, 1.6693061224E+00, 8.4981113313E-01],
	[2.3750000000E+04, 1.4401240582E+01, 5.2215415313E+00, 2.9598987944E+00, 1.6700006110E+00, 8.4988199637E-01],
	[2.3755000000E+04, 1.4405946085E+01, 5.2214662006E+00, 2.9619063262E+00, 1.6706950766E+00, 8.4995282818E-01],
	[2.3760000000E+04, 1.4410652135E+01, 5.2213908868E+00, 2.9639147957E+00, 1.6713895193E+00, 8.5002362858E-01],
	[2.3765000000E+04, 1.4415358731E+01, 5.2213155899E+00, 2.9659242033E+00, 1.6720839388E+00, 8.5009439756E-01],
	[2.3770000000E+04, 1.4420065874E+01, 5.2212403099E+00, 2.9679345491E+00, 1.6727783349E+00, 8.5016513513E-01],
	[2.3775000000E+04, 1.4424773564E+01, 5.2211650469E+00, 2.9699458334E+00, 1.6734727077E+00, 8.5023584132E-01],
	[2.3780000000E+04, 1.4429481800E+01, 5.2210898007E+00, 2.9719580564E+00, 1.6741670569E+00, 8.5030651612E-01],
	[2.3785000000E+04, 1.4434190582E+01, 5.2210145715E+00, 2.9739712184E+00, 1.6748613825E+00, 8.5037715955E-01],
	[2.3790000000E+04, 1.4438899911E+01, 5.2209393592E+00, 2.9759853196E+00, 1.6755556842E+00, 8.5044777161E-01],
	[2.3795000000E+04, 1.4443609786E+01, 5.2208641637E+00, 2.9780003603E+00, 1.6762499621E+00, 8.5051835232E-01],
	[2.3800000000E+04, 1.4448320208E+01, 5.2207889852E+00, 2.9800163406E+00, 1.6769442158E+00, 8.5058890169E-01],
	[2.3805000000E+04, 1.4453031175E+01, 5.2207138235E+00, 2.9820332609E+00, 1.6776384454E+00, 8.5065941971E-01],
	[2.3810000000E+04, 1.4457742689E+01, 5.2206386787E+00, 2.9840511213E+00, 1.6783326507E+00, 8.5072990641E-01],
	[2.3815000000E+04, 1.4462454749E+01, 5.2205635507E+00, 2.9860699222E+00, 1.6790268315E+00, 8.5080036178E-01],
	[2.3820000000E+04, 1.4467167355E+01, 5.2204884396E+00, 2.9880896637E+00, 1.6797209878E+00, 8.5087078584E-01],
	[2.3825000000E+04, 1.4471880507E+01, 5.2204133453E+00, 2.9901103461E+00, 1.6804151194E+00, 8.5094117859E-01],
	[2.3830000000E+04, 1.4476594205E+01, 5.2203382679E+00, 2.9921319697E+00, 1.6811092261E+00, 8.5101154004E-01],
	[2.3835000000E+04, 1.4481308449E+01, 5.2202632073E+00, 2.9941545346E+00, 1.6818033079E+00, 8.5108187021E-01],
	[2.3840000000E+04, 1.4486023239E+01, 5.2201881635E+00, 2.9961780411E+00, 1.6824973647E+00, 8.5115216908E-01],
	[2.3845000000E+04, 1.4490738574E+01, 5.2201131366E+00, 2.9982024895E+00, 1.6831913962E+00, 8.5122243669E-01],
	[2.3850000000E+04, 1.4495454456E+01, 5.2200381264E+00, 3.0002278800E+00, 1.6838854024E+00, 8.5129267302E-01],
	[2.3855000000E+04, 1.4500170883E+01, 5.2199631331E+00, 3.0022542128E+00, 1.6845793832E+00, 8.5136287810E-01],
	[2.3860000000E+04, 1.4504887856E+01, 5.2198881565E+00, 3.0042814882E+00, 1.6852733383E+00, 8.5143305192E-01],
	[2.3865000000E+04, 1.4509605374E+01, 5.2198131968E+00, 3.0063097064E+00, 1.6859672678E+00, 8.5150319450E-01],
	[2.3870000000E+04, 1.4514323438E+01, 5.2197382538E+00, 3.0083388676E+00, 1.6866611714E+00, 8.5157330584E-01],
	[2.3875000000E+04, 1.4519042047E+01, 5.2196633276E+00, 3.0103689721E+00, 1.6873550491E+00, 8.5164338595E-01],
	[2.3880000000E+04, 1.4523761202E+01, 5.2195884181E+00, 3.0124000202E+00, 1.6880489007E+00, 8.5171343484E-01],
	[2.3885000000E+04, 1.4528480902E+01, 5.2195135254E+00, 3.0144320121E+00, 1.6887427261E+00, 8.5178345252E-01],
	[2.3890000000E+04, 1.4533201148E+01, 5.2194386495E+00, 3.0164649479E+00, 1.6894365251E+00, 8.5185343900E-01],
	[2.3895000000E+04, 1.4537921939E+01, 5.2193637903E+00, 3.0184988280E+00, 1.6901302977E+00, 8.5192339428E-01],
	[2.3900000000E+04, 1.4542643275E+01, 5.2192889478E+00, 3.0205336526E+00, 1.6908240436E+00, 8.5199331837E-01],
	[2.3905000000E+04, 1.4547365156E+01, 5.2192141221E+00, 3.0225694220E+00, 1.6915177629E+00, 8.5206321128E-01],
	[2.3910000000E+04, 1.4552087582E+01, 5.2191393131E+00, 3.0246061363E+00, 1.6922114553E+00, 8.5213307302E-01],
	[2.3915000000E+04, 1.4556810554E+01, 5.2190645208E+00, 3.0266437958E+00, 1.6929051208E+00, 8.5220290359E-01],
	[2.3920000000E+04, 1.4561553196E+01, 5.2189933622E+00, 3.0286824008E+00, 1.6935993987E+00, 8.5227270300E-01],
	[2.3925000000E+04, 1.4566298889E+01, 5.2189226916E+00, 3.0307219515E+00, 1.6942937338E+00, 8.5234247127E-01],
	[2.3930000000E+04, 1.4571045137E+01, 5.2188520366E+00, 3.0327624481E+00, 1.6949880423E+00, 8.5241220840E-01],
	[2.3935000000E+04, 1.4575791939E+01, 5.2187813974E+00, 3.0348038909E+00, 1.6956823242E+00, 8.5248191439E-01],
	[2.3940000000E+04, 1.4580539295E+01, 5.2187107739E+00, 3.0368462801E+00, 1.6963765794E+00, 8.5255158926E-01],
	[2.3945000000E+04, 1.4585287206E+01, 5.2186401661E+00, 3.0388896160E+00, 1.6970708078E+00, 8.5262123302E-01],
	[2.3950000000E+04, 1.4590035670E+01, 5.2185695740E+00, 3.0409338987E+00, 1.6977650091E+00, 8.5269084566E-01],
	[2.3955000000E+04, 1.4594784689E+01, 5.2184989976E+00, 3.0429791286E+00, 1.6984591833E+00, 8.5276042721E-01],
	[2.3960000000E+04, 1.4599534263E+01, 5.2184284369E+00, 3.0450253059E+00, 1.6991533303E+00, 8.5282997766E-01],
	[2.3965000000E+04, 1.4604284390E+01, 5.2183578918E+00, 3.0470724308E+00, 1.6998474499E+00, 8.5289949703E-01],
	[2.3970000000E+04, 1.4609035072E+01, 5.2182873624E+00, 3.0491205036E+00, 1.7005415420E+00, 8.5296898533E-01],
	[2.3975000000E+04, 1.4613786307E+01, 5.2182168487E+00, 3.0511695244E+00, 1.7012356065E+00, 8.5303844255E-01],
	[2.3980000000E+04, 1.4618538096E+01, 5.2181463506E+00, 3.0532194936E+00, 1.7019296433E+00, 8.5310786872E-01],
	[2.3985000000E+04, 1.4623290440E+01, 5.2180758682E+00, 3.0552704114E+00, 1.7026236522E+00, 8.5317726384E-01],
	[2.3990000000E+04, 1.4628043337E+01, 5.2180054015E+00, 3.0573222780E+00, 1.7033176331E+00, 8.5324662791E-01],
	[2.3995000000E+04, 1.4632796788E+01, 5.2179349503E+00, 3.0593750937E+00, 1.7040115859E+00, 8.5331596095E-01],
	[2.4000000000E+04, 1.4637550793E+01, 5.2178645148E+00, 3.0614288586E+00, 1.7047055104E+00, 8.5338526296E-01],
	[2.4005000000E+04, 1.4642305351E+01, 5.2177940949E+00, 3.0634835731E+00, 1.7053994066E+00, 8.5345453396E-01],
	[2.4010000000E+04, 1.4647060464E+01, 5.2177236907E+00, 3.0655392374E+00, 1.7060932743E+00, 8.5352377395E-01],
	[2.4015000000E+04, 1.4651816129E+01, 5.2176533020E+00, 3.0675958517E+00, 1.7067871134E+00, 8.5359298293E-01],
	[2.4020000000E+04, 1.4656572349E+01, 5.2175829290E+00, 3.0696534163E+00, 1.7074809238E+00, 8.5366216092E-01],
	[2.4025000000E+04, 1.4661329122E+01, 5.2175125715E+00, 3.0717119313E+00, 1.7081747053E+00, 8.5373130793E-01],
	[2.4030000000E+04, 1.4666086448E+01, 5.2174422296E+00, 3.0737713972E+00, 1.7088684578E+00, 8.5380042396E-01],
	[2.4035000000E+04, 1.4670844328E+01, 5.2173719034E+00, 3.0758318140E+00, 1.7095621812E+00, 8.5386950902E-01],
	[2.4040000000E+04, 1.4675602761E+01, 5.2173015927E+00, 3.0778931820E+00, 1.7102558754E+00, 8.5393856312E-01],
	[2.4045000000E+04, 1.4680361747E+01, 5.2172312975E+00, 3.0799555015E+00, 1.7109495402E+00, 8.5400758627E-01],
	[2.4050000000E+04, 1.4685121287E+01, 5.2171610179E+00, 3.0820187727E+00, 1.7116431755E+00, 8.5407657848E-01],
	[2.4055000000E+04, 1.4689881380E+01, 5.2170907539E+00, 3.0840829958E+00, 1.7123367813E+00, 8.5414553975E-01],
	[2.4060000000E+04, 1.4694642026E+01, 5.2170205054E+00, 3.0861481711E+00, 1.7130303573E+00, 8.5421447010E-01],
	[2.4065000000E+04, 1.4699403225E+01, 5.2169502725E+00, 3.0882142989E+00, 1.7137239034E+00, 8.5428336952E-01],
	[2.4070000000E+04, 1.4704164978E+01, 5.2168800551E+00, 3.0902813793E+00, 1.7144174196E+00, 8.5435223804E-01],
	[2.4075000000E+04, 1.4708927283E+01, 5.2168098533E+00, 3.0923494126E+00, 1.7151109057E+00, 8.5442107566E-01],
	[2.4080000000E+04, 1.4713690141E+01, 5.2167396669E+00, 3.0944183991E+00, 1.7158043616E+00, 8.5448988239E-01],
	[2.4085000000E+04, 1.4718453552E+01, 5.2166694961E+00, 3.0964883390E+00, 1.7164977871E+00, 8.5455865823E-01],
	[2.4090000000E+04, 1.4723217516E+01, 5.2165993408E+00, 3.0985592325E+00, 1.7171911822E+00, 8.5462740319E-01],
	[2.4095000000E+04, 1.4727982033E+01, 5.2165292010E+00, 3.1006310799E+00, 1.7178845467E+00, 8.5469611729E-01],
	[2.4100000000E+04, 1.4732747102E+01, 5.2164590767E+00, 3.1027038814E+00, 1.7185778805E+00, 8.5476480053E-01],
	[2.4105000000E+04, 1.4737512724E+01, 5.2163889678E+00, 3.1047776372E+00, 1.7192711834E+00, 8.5483345292E-01],
	[2.4110000000E+04, 1.4742278899E+01, 5.2163188745E+00, 3.1068523476E+00, 1.7199644554E+00, 8.5490207447E-01],
	[2.4115000000E+04, 1.4747045627E+01, 5.2162487966E+00, 3.1089280129E+00, 1.7206576963E+00, 8.5497066518E-01],
	[2.4120000000E+04, 1.4751812907E+01, 5.2161787342E+00, 3.1110046332E+00, 1.7213509060E+00, 8.5503922507E-01],
	[2.4125000000E+04, 1.4756580739E+01, 5.2161086873E+00, 3.1130822089E+00, 1.7220440843E+00, 8.5510775415E-01],
	[2.4130000000E+04, 1.4761349124E+01, 5.2160386558E+00, 3.1151607401E+00, 1.7227372313E+00, 8.5517625241E-01],
	[2.4135000000E+04, 1.4766118062E+01, 5.2159686398E+00, 3.1172402271E+00, 1.7234303466E+00, 8.5524471988E-01],
	[2.4140000000E+04, 1.4770887551E+01, 5.2158986392E+00, 3.1193206702E+00, 1.7241234303E+00, 8.5531315656E-01],
	[2.4145000000E+04, 1.4775657593E+01, 5.2158286541E+00, 3.1214020695E+00, 1.7248164821E+00, 8.5538156246E-01],
	[2.4150000000E+04, 1.4780428188E+01, 5.2157586843E+00, 3.1234844253E+00, 1.7255095020E+00, 8.5544993758E-01],
	[2.4155000000E+04, 1.4785199334E+01, 5.2156887300E+00, 3.1255677379E+00, 1.7262024899E+00, 8.5551828194E-01],
	[2.4160000000E+04, 1.4789971033E+01, 5.2156187912E+00, 3.1276520076E+00, 1.7268954456E+00, 8.5558659554E-01],
	[2.4165000000E+04, 1.4794743283E+01, 5.2155488677E+00, 3.1297372344E+00, 1.7275883689E+00, 8.5565487840E-01],
	[2.4170000000E+04, 1.4799516086E+01, 5.2154789596E+00, 3.1318234187E+00, 1.7282812599E+00, 8.5572313052E-01],
	[2.4175000000E+04, 1.4804289441E+01, 5.2154090670E+00, 3.1339105608E+00, 1.7289741183E+00, 8.5579135190E-01],
	[2.4180000000E+04, 1.4809063348E+01, 5.2153391897E+00, 3.1359986608E+00, 1.7296669440E+00, 8.5585954257E-01],
	[2.4185000000E+04, 1.4813837806E+01, 5.2152693278E+00, 3.1380877190E+00, 1.7303597370E+00, 8.5592770253E-01],
	[2.4190000000E+04, 1.4818612817E+01, 5.2151994813E+00, 3.1401777357E+00, 1.7310524970E+00, 8.5599583178E-01],
	[2.4195000000E+04, 1.4823388379E+01, 5.2151296501E+00, 3.1422687110E+00, 1.7317452240E+00, 8.5606393033E-01],
	[2.4200000000E+04, 1.4828164493E+01, 5.2150598344E+00, 3.1443606453E+00, 1.7324379179E+00, 8.5613199820E-01],
	[2.4205000000E+04, 1.4832941159E+01, 5.2149900339E+00, 3.1464535388E+00, 1.7331305784E+00, 8.5620003540E-01],
	[2.4210000000E+04, 1.4837718376E+01, 5.2149202489E+00, 3.1485473916E+00, 1.7338232056E+00, 8.5626804192E-01],
	[2.4215000000E+04, 1.4842496145E+01, 5.2148504791E+00, 3.1506422041E+00, 1.7345157993E+00, 8.5633601779E-01],
	[2.4220000000E+04, 1.4847274465E+01, 5.2147807247E+00, 3.1527379765E+00, 1.7352083593E+00, 8.5640396300E-01],
	[2.4225000000E+04, 1.4852053337E+01, 5.2147109857E+00, 3.1548347091E+00, 1.7359008856E+00, 8.5647187757E-01],
	[2.4230000000E+04, 1.4856832761E+01, 5.2146412619E+00, 3.1569324020E+00, 1.7365933780E+00, 8.5653976151E-01],
	[2.4235000000E+04, 1.4861612735E+01, 5.2145715535E+00, 3.1590310555E+00, 1.7372858363E+00, 8.5660761482E-01],
	[2.4240000000E+04, 1.4866393262E+01, 5.2145018604E+00, 3.1611306698E+00, 1.7379782606E+00, 8.5667543752E-01],
	[2.4245000000E+04, 1.4871174339E+01, 5.2144321826E+00, 3.1632312453E+00, 1.7386706506E+00, 8.5674322961E-01],
	[2.4250000000E+04, 1.4875955968E+01, 5.2143625201E+00, 3.1653327821E+00, 1.7393630063E+00, 8.5681099110E-01],
	[2.4255000000E+04, 1.4880738147E+01, 5.2142928729E+00, 3.1674352805E+00, 1.7400553275E+00, 8.5687872201E-01],
	[2.4260000000E+04, 1.4885520878E+01, 5.2142232410E+00, 3.1695387407E+00, 1.7407476140E+00, 8.5694642233E-01],
	[2.4265000000E+04, 1.4890304161E+01, 5.2141536244E+00, 3.1716431629E+00, 1.7414398659E+00, 8.5701409208E-01],
	[2.4270000000E+04, 1.4895087994E+01, 5.2140840230E+00, 3.1737485475E+00, 1.7421320829E+00, 8.5708173127E-01],
	[2.4275000000E+04, 1.4899872378E+01, 5.2140144369E+00, 3.1758548946E+00, 1.7428242649E+00, 8.5714933990E-01],
	[2.4280000000E+04, 1.4904657313E+01, 5.2139448660E+00, 3.1779622045E+00, 1.7435164119E+00, 8.5721691800E-01],
	[2.4285000000E+04, 1.4909442799E+01, 5.2138753104E+00, 3.1800704774E+00, 1.7442085236E+00, 8.5728446555E-01],
	[2.4290000000E+04, 1.4914228836E+01, 5.2138057701E+00, 3.1821797135E+00, 1.7449006000E+00, 8.5735198258E-01],
	[2.4295000000E+04, 1.4919015423E+01, 5.2137362450E+00, 3.1842899132E+00, 1.7455926410E+00, 8.5741946909E-01],
	[2.4300000000E+04, 1.4923802562E+01, 5.2136667351E+00, 3.1864010766E+00, 1.7462846464E+00, 8.5748692509E-01],
	[2.4305000000E+04, 1.4928609584E+01, 5.2136007964E+00, 3.1885132040E+00, 1.7469772802E+00, 8.5755435059E-01],
	[2.4310000000E+04, 1.4933419730E+01, 5.2135353437E+00, 3.1906262957E+00, 1.7476699670E+00, 8.5762174560E-01],
	[2.4315000000E+04, 1.4938230437E+01, 5.2134699052E+00, 3.1927403518E+00, 1.7483626187E+00, 8.5768911013E-01],
	[2.4320000000E+04, 1.4943041703E+01, 5.2134044811E+00, 3.1948553726E+00, 1.7490552353E+00, 8.5775644418E-01],
	[2.4325000000E+04, 1.4947853530E+01, 5.2133390712E+00, 3.1969713583E+00, 1.7497478165E+00, 8.5782374778E-01],
	[2.4330000000E+04, 1.4952665916E+01, 5.2132736755E+00, 3.1990883093E+00, 1.7504403624E+00, 8.5789102091E-01],
	[2.4335000000E+04, 1.4957478863E+01, 5.2132082942E+00, 3.2012062257E+00, 1.7511328727E+00, 8.5795826360E-01],
	[2.4340000000E+04, 1.4962292369E+01, 5.2131429270E+00, 3.2033251078E+00, 1.7518253473E+00, 8.5802547586E-01],
	[2.4345000000E+04, 1.4967106436E+01, 5.2130775742E+00, 3.2054449558E+00, 1.7525177861E+00, 8.5809265768E-01],
	[2.4350000000E+04, 1.4971921062E+01, 5.2130122355E+00, 3.2075657699E+00, 1.7532101891E+00, 8.5815980909E-01],
	[2.4355000000E+04, 1.4976736248E+01, 5.2129469111E+00, 3.2096875504E+00, 1.7539025560E+00, 8.5822693009E-01],
	[2.4360000000E+04, 1.4981551994E+01, 5.2128816009E+00, 3.2118102976E+00, 1.7545948867E+00, 8.5829402069E-01],
	[2.4365000000E+04, 1.4986368299E+01, 5.2128163050E+00, 3.2139340117E+00, 1.7552871813E+00, 8.5836108089E-01],
	[2.4370000000E+04, 1.4991185164E+01, 5.2127510232E+00, 3.2160586929E+00, 1.7559794394E+00, 8.5842811072E-01],
	[2.4375000000E+04, 1.4996002588E+01, 5.2126857557E+00, 3.2181843414E+00, 1.7566716611E+00, 8.5849511017E-01],
	[2.4380000000E+04, 1.5000820572E+01, 5.2126205024E+00, 3.2203109576E+00, 1.7573638461E+00, 8.5856207926E-01],
	[2.4385000000E+04, 1.5005639116E+01, 5.2125552632E+00, 3.2224385416E+00, 1.7580559944E+00, 8.5862901799E-01],
	[2.4390000000E+04, 1.5010458219E+01, 5.2124900383E+00, 3.2245670937E+00, 1.7587481058E+00, 8.5869592638E-01],
	[2.4395000000E+04, 1.5015277881E+01, 5.2124248276E+00, 3.2266966141E+00, 1.7594401803E+00, 8.5876280443E-01],
	[2.4400000000E+04, 1.5020098103E+01, 5.2123596310E+00, 3.2288271031E+00, 1.7601322177E+00, 8.5882965215E-01],
	[2.4405000000E+04, 1.5024918884E+01, 5.2122944486E+00, 3.2309585609E+00, 1.7608242179E+00, 8.5889646955E-01],
	[2.4410000000E+04, 1.5029740224E+01, 5.2122292804E+00, 3.2330909877E+00, 1.7615161808E+00, 8.5896325665E-01],
	[2.4415000000E+04, 1.5034562123E+01, 5.2121641263E+00, 3.2352243839E+00, 1.7622081062E+00, 8.5903001345E-01],
	[2.4420000000E+04, 1.5039384581E+01, 5.2120989864E+00, 3.2373587496E+00, 1.7628999941E+00, 8.5909673995E-01],
	[2.4425000000E+04, 1.5044207599E+01, 5.2120338606E+00, 3.2394940850E+00, 1.7635918443E+00, 8.5916343618E-01],
	[2.4430000000E+04, 1.5049031175E+01, 5.2119687490E+00, 3.2416303905E+00, 1.7642836567E+00, 8.5923010213E-01],
	[2.4435000000E+04, 1.5053855311E+01, 5.2119036515E+00, 3.2437676662E+00, 1.7649754311E+00, 8.5929673782E-01],
	[2.4440000000E+04, 1.5058680005E+01, 5.2118385682E+00, 3.2459059124E+00, 1.7656671676E+00, 8.5936334326E-01],
	[2.4445000000E+04, 1.5063505258E+01, 5.2117734989E+00, 3.2480451294E+00, 1.7663588659E+00, 8.5942991845E-01],
	[2.4450000000E+04, 1.5068331070E+01, 5.2117084438E+00, 3.2501853174E+00, 1.7670505259E+00, 8.5949646341E-01],
	[2.4455000000E+04, 1.5073157441E+01, 5.2116434029E+00, 3.2523264766E+00, 1.7677421476E+00, 8.5956297814E-01],
	[2.4460000000E+04, 1.5077984371E+01, 5.2115783760E+00, 3.2544686072E+00, 1.7684337308E+00, 8.5962946265E-01],
	[2.4465000000E+04, 1.5082811859E+01, 5.2115133632E+00, 3.2566117096E+00, 1.7691252753E+00, 8.5969591696E-01],
	[2.4470000000E+04, 1.5087639906E+01, 5.2114483645E+00, 3.2587557839E+00, 1.7698167811E+00, 8.5976234107E-01],
	[2.4475000000E+04, 1.5092468511E+01, 5.2113833799E+00, 3.2609008304E+00, 1.7705082481E+00, 8.5982873500E-01],
	[2.4480000000E+04, 1.5097297675E+01, 5.2113184094E+00, 3.2630468493E+00, 1.7711996761E+00, 8.5989509874E-01],
	[2.4485000000E+04, 1.5102127398E+01, 5.2112534530E+00, 3.2651938409E+00, 1.7718910650E+00, 8.5996143231E-01],
	[2.4490000000E+04, 1.5106957678E+01, 5.2111885106E+00, 3.2673418054E+00, 1.7725824147E+00, 8.6002773573E-01],
	[2.4495000000E+04, 1.5111788518E+01, 5.2111235823E+00, 3.2694907431E+00, 1.7732737251E+00, 8.6009400899E-01],
	[2.4500000000E+04, 1.5116619915E+01, 5.2110586681E+00, 3.2716406541E+00, 1.7739649960E+00, 8.6016025211E-01],
	[2.4505000000E+04, 1.5121451871E+01, 5.2109937679E+00, 3.2737915389E+00, 1.7746562275E+00, 8.6022646510E-01],
	[2.4510000000E+04, 1.5126284385E+01, 5.2109288818E+00, 3.2759433974E+00, 1.7753474192E+00, 8.6029264797E-01],
	[2.4515000000E+04, 1.5131117457E+01, 5.2108640097E+00, 3.2780962302E+00, 1.7760385711E+00, 8.6035880072E-01],
	[2.4520000000E+04, 1.5135951088E+01, 5.2107991517E+00, 3.2802500372E+00, 1.7767296832E+00, 8.6042492337E-01],
	[2.4525000000E+04, 1.5140785276E+01, 5.2107343077E+00, 3.2824048189E+00, 1.7774207552E+00, 8.6049101592E-01],
	[2.4530000000E+04, 1.5145620023E+01, 5.2106694777E+00, 3.2845605754E+00, 1.7781117871E+00, 8.6055707839E-01],
	[2.4535000000E+04, 1.5150455327E+01, 5.2106046617E+00, 3.2867173070E+00, 1.7788027788E+00, 8.6062311079E-01],
	[2.4540000000E+04, 1.5155291189E+01, 5.2105398598E+00, 3.2888750140E+00, 1.7794937301E+00, 8.6068911312E-01],
	[2.4545000000E+04, 1.5160127610E+01, 5.2104750718E+00, 3.2910336965E+00, 1.7801846409E+00, 8.6075508539E-01],
	[2.4550000000E+04, 1.5164964588E+01, 5.2104102979E+00, 3.2931933548E+00, 1.7808755111E+00, 8.6082102761E-01],
	[2.4555000000E+04, 1.5169802124E+01, 5.2103455379E+00, 3.2953539892E+00, 1.7815663406E+00, 8.6088693980E-01],
	[2.4560000000E+04, 1.5174640217E+01, 5.2102807920E+00, 3.2975155999E+00, 1.7822571293E+00, 8.6095282196E-01],
	[2.4565000000E+04, 1.5179478869E+01, 5.2102160600E+00, 3.2996781871E+00, 1.7829478770E+00, 8.6101867410E-01],
	[2.4570000000E+04, 1.5184318077E+01, 5.2101513420E+00, 3.3018417511E+00, 1.7836385837E+00, 8.6108449623E-01],
	[2.4575000000E+04, 1.5189157844E+01, 5.2100866380E+00, 3.3040062921E+00, 1.7843292492E+00, 8.6115028836E-01],
	[2.4580000000E+04, 1.5193998168E+01, 5.2100219479E+00, 3.3061718104E+00, 1.7850198734E+00, 8.6121605050E-01],
	[2.4585000000E+04, 1.5198839050E+01, 5.2099572718E+00, 3.3083383062E+00, 1.7857104562E+00, 8.6128178266E-01],
	[2.4590000000E+04, 1.5203680489E+01, 5.2098926097E+00, 3.3105057797E+00, 1.7864009975E+00, 8.6134748485E-01],
	[2.4595000000E+04, 1.5208522485E+01, 5.2098279615E+00, 3.3126742312E+00, 1.7870914972E+00, 8.6141315708E-01],
	[2.4600000000E+04, 1.5213365039E+01, 5.2097633272E+00, 3.3148436609E+00, 1.7877819551E+00, 8.6147879936E-01],
	[2.4605000000E+04, 1.5218208150E+01, 5.2096987069E+00, 3.3170140692E+00, 1.7884723711E+00, 8.6154441169E-01],
	[2.4610000000E+04, 1.5223051818E+01, 5.2096341005E+00, 3.3191854561E+00, 1.7891627452E+00, 8.6160999409E-01],
	[2.4615000000E+04, 1.5227896043E+01, 5.2095695081E+00, 3.3213578220E+00, 1.7898530771E+00, 8.6167554657E-01],
	[2.4620000000E+04, 1.5232740826E+01, 5.2095049295E+00, 3.3235311670E+00, 1.7905433669E+00, 8.6174106914E-01],
	[2.4625000000E+04, 1.5237586166E+01, 5.2094403649E+00, 3.3257054916E+00, 1.7912336143E+00, 8.6180656180E-01],
	[2.4630000000E+04, 1.5242432062E+01, 5.2093758142E+00, 3.3278807958E+00, 1.7919238193E+00, 8.6187202457E-01],
	[2.4635000000E+04, 1.5247278516E+01, 5.2093112774E+00, 3.3300570799E+00, 1.7926139817E+00, 8.6193745745E-01],
	[2.4640000000E+04, 1.5252125527E+01, 5.2092467545E+00, 3.3322343442E+00, 1.7933041015E+00, 8.6200286046E-01],
	[2.4645000000E+04, 1.5256973094E+01, 5.2091822455E+00, 3.3344125888E+00, 1.7939941785E+00, 8.6206823360E-01],
	[2.4650000000E+04, 1.5261821219E+01, 5.2091177503E+00, 3.3365918142E+00, 1.7946842126E+00, 8.6213357689E-01],
	[2.4655000000E+04, 1.5266669900E+01, 5.2090532691E+00, 3.3387720204E+00, 1.7953742037E+00, 8.6219889033E-01],
	[2.4660000000E+04, 1.5271519138E+01, 5.2089888017E+00, 3.3409532077E+00, 1.7960641516E+00, 8.6226417393E-01],
	[2.4665000000E+04, 1.5276368932E+01, 5.2089243481E+00, 3.3431353765E+00, 1.7967540563E+00, 8.6232942771E-01],
	[2.4670000000E+04, 1.5281219284E+01, 5.2088599085E+00, 3.3453185268E+00, 1.7974439177E+00, 8.6239465167E-01],
	[2.4675000000E+04, 1.5286070192E+01, 5.2087954827E+00, 3.3475026590E+00, 1.7981337356E+00, 8.6245984583E-01],
	[2.4680000000E+04, 1.5290921656E+01, 5.2087310707E+00, 3.3496877733E+00, 1.7988235099E+00, 8.6252501018E-01],
	[2.4685000000E+04, 1.5295773677E+01, 5.2086666726E+00, 3.3518738699E+00, 1.7995132405E+00, 8.6259014475E-01],
	[2.4690000000E+04, 1.5300626255E+01, 5.2086022884E+00, 3.3540609491E+00, 1.8002029273E+00, 8.6265524955E-01],
	[2.4695000000E+04, 1.5305493618E+01, 5.2085404634E+00, 3.3562490111E+00, 1.8008930715E+00, 8.6272032457E-01],
	[2.4700000000E+04, 1.5310369492E+01, 5.2084800733E+00, 3.3584380562E+00, 1.8015834524E+00, 8.6278536983E-01],
	[2.4705000000E+04, 1.5315245933E+01, 5.2084196961E+00, 3.3606280846E+00, 1.8022737899E+00, 8.6285038535E-01],
	[2.4710000000E+04, 1.5320122940E+01, 5.2083593318E+00, 3.3628190966E+00, 1.8029640841E+00, 8.6291537113E-01],
	[2.4715000000E+04, 1.5325000512E+01, 5.2082989805E+00, 3.3650110923E+00, 1.8036543348E+00, 8.6298032718E-01],
	[2.4720000000E+04, 1.5329878650E+01, 5.2082386420E+00, 3.3672040721E+00, 1.8043445418E+00, 8.6304525351E-01],
	[2.4725000000E+04, 1.5334757354E+01, 5.2081783165E+00, 3.3693980362E+00, 1.8050347050E+00, 8.6311015013E-01],
	[2.4730000000E+04, 1.5339636623E+01, 5.2081180038E+00, 3.3715929847E+00, 1.8057248244E+00, 8.6317501704E-01],
	[2.4735000000E+04, 1.5344516458E+01, 5.2080577041E+00, 3.3737889181E+00, 1.8064148999E+00, 8.6323985427E-01],
	[2.4740000000E+04, 1.5349396859E+01, 5.2079974172E+00, 3.3759858364E+00, 1.8071049312E+00, 8.6330466182E-01],
	[2.4745000000E+04, 1.5354277825E+01, 5.2079371432E+00, 3.3781837399E+00, 1.8077949184E+00, 8.6336943970E-01],
	[2.4750000000E+04, 1.5359159357E+01, 5.2078768821E+00, 3.3803826290E+00, 1.8084848613E+00, 8.6343418792E-01],
	[2.4755000000E+04, 1.5364041454E+01, 5.2078166338E+00, 3.3825825038E+00, 1.8091747597E+00, 8.6349890649E-01],
	[2.4760000000E+04, 1.5368924117E+01, 5.2077563985E+00, 3.3847833645E+00, 1.8098646136E+00, 8.6356359542E-01],
	[2.4765000000E+04, 1.5373807345E+01, 5.2076961759E+00, 3.3869852115E+00, 1.8105544228E+00, 8.6362825472E-01],
	[2.4770000000E+04, 1.5378691138E+01, 5.2076359663E+00, 3.3891880449E+00, 1.8112441873E+00, 8.6369288439E-01],
	[2.4775000000E+04, 1.5383575496E+01, 5.2075757694E+00, 3.3913918650E+00, 1.8119339069E+00, 8.6375748446E-01],
	[2.4780000000E+04, 1.5388460420E+01, 5.2075155855E+00, 3.3935966720E+00, 1.8126235816E+00, 8.6382205492E-01],
	[2.4785000000E+04, 1.5393345908E+01, 5.2074554143E+00, 3.3958024663E+00, 1.8133132111E+00, 8.6388659579E-01],
	[2.4790000000E+04, 1.5398231962E+01, 5.2073952560E+00, 3.3980092479E+00, 1.8140027954E+00, 8.6395110708E-01],
	[2.4795000000E+04, 1.5403118581E+01, 5.2073351105E+00, 3.4002170172E+00, 1.8146923345E+00, 8.6401558880E-01],
	[2.4800000000E+04, 1.5408005765E+01, 5.2072749779E+00, 3.4024257744E+00, 1.8153818280E+00, 8.6408004096E-01],
	[2.4805000000E+04, 1.5412893513E+01, 5.2072148580E+00, 3.4046355198E+00, 1.8160712761E+00, 8.6414446357E-01],
	[2.4810000000E+04, 1.5417781827E+01, 5.2071547510E+00, 3.4068462535E+00, 1.8167606785E+00, 8.6420885663E-01],
	[2.4815000000E+04, 1.5422670706E+01, 5.2070946568E+00, 3.4090579759E+00, 1.8174500351E+00, 8.6427322016E-01],
	[2.4820000000E+04, 1.5427560149E+01, 5.2070345753E+00, 3.4112706871E+00, 1.8181393458E+00, 8.6433755417E-01],
	[2.4825000000E+04, 1.5432450157E+01, 5.2069745067E+00, 3.4134843875E+00, 1.8188286106E+00, 8.6440185867E-01],
	[2.4830000000E+04, 1.5437340730E+01, 5.2069144509E+00, 3.4156990772E+00, 1.8195178292E+00, 8.6446613367E-01],
	[2.4835000000E+04, 1.5442231867E+01, 5.2068544078E+00, 3.4179147566E+00, 1.8202070017E+00, 8.6453037917E-01],
	[2.4840000000E+04, 1.5447123569E+01, 5.2067943775E+00, 3.4201314257E+00, 1.8208961278E+00, 8.6459459520E-01],
	[2.4845000000E+04, 1.5452015836E+01, 5.2067343600E+00, 3.4223490850E+00, 1.8215852075E+00, 8.6465878175E-01],
	[2.4850000000E+04, 1.5456908667E+01, 5.2066743553E+00, 3.4245677345E+00, 1.8222742406E+00, 8.6472293884E-01],
	[2.4855000000E+04, 1.5461802062E+01, 5.2066143633E+00, 3.4267873747E+00, 1.8229632271E+00, 8.6478706647E-01],
	[2.4860000000E+04, 1.5466696022E+01, 5.2065543841E+00, 3.4290080056E+00, 1.8236521669E+00, 8.6485116467E-01],
	[2.4865000000E+04, 1.5471590546E+01, 5.2064944176E+00, 3.4312296277E+00, 1.8243410597E+00, 8.6491523343E-01],
	[2.4870000000E+04, 1.5476485635E+01, 5.2064344639E+00, 3.4334522410E+00, 1.8250299056E+00, 8.6497927277E-01],
	[2.4875000000E+04, 1.5481381288E+01, 5.2063745230E+00, 3.4356758458E+00, 1.8257187043E+00, 8.6504328270E-01],
	[2.4880000000E+04, 1.5486277505E+01, 5.2063145947E+00, 3.4379004424E+00, 1.8264074559E+00, 8.6510726323E-01],
	[2.4885000000E+04, 1.5491174286E+01, 5.2062546792E+00, 3.4401260311E+00, 1.8270961601E+00, 8.6517121437E-01],
	[2.4890000000E+04, 1.5496071632E+01, 5.2061947765E+00, 3.4423526120E+00, 1.8277848169E+00, 8.6523513612E-01],
	[2.4895000000E+04, 1.5500969541E+01, 5.2061348864E+00, 3.4445801854E+00, 1.8284734261E+00, 8.6529902850E-01],
	[2.4900000000E+04, 1.5505868014E+01, 5.2060750091E+00, 3.4468087515E+00, 1.8291619878E+00, 8.6536289152E-01],
	[2.4905000000E+04, 1.5510767052E+01, 5.2060151444E+00, 3.4490383107E+00, 1.8298505016E+00, 8.6542672519E-01],
	[2.4910000000E+04, 1.5515666653E+01, 5.2059552925E+00, 3.4512688631E+00, 1.8305389676E+00, 8.6549052952E-01],
	[2.4915000000E+04, 1.5520566818E+01, 5.2058954533E+00, 3.4535004089E+00, 1.8312273856E+00, 8.6555430452E-01],
	[2.4920000000E+04, 1.5525467547E+01, 5.2058356268E+00, 3.4557329485E+00, 1.8319157555E+00, 8.6561805019E-01],
	[2.4925000000E+04, 1.5530368840E+01, 5.2057758129E+00, 3.4579664821E+00, 1.8326040772E+00, 8.6568176656E-01],
	[2.4930000000E+04, 1.5535270697E+01, 5.2057160118E+00, 3.4602010098E+00, 1.8332923506E+00, 8.6574545362E-01],
	[2.4935000000E+04, 1.5540173117E+01, 5.2056562233E+00, 3.4624365320E+00, 1.8339805756E+00, 8.6580911140E-01],
	[2.4940000000E+04, 1.5545076101E+01, 5.2055964475E+00, 3.4646730489E+00, 1.8346687520E+00, 8.6587273989E-01],
	[2.4945000000E+04, 1.5549979649E+01, 5.2055366844E+00, 3.4669105607E+00, 1.8353568798E+00, 8.6593633911E-01],
	[2.4950000000E+04, 1.5554883760E+01, 5.2054769339E+00, 3.4691490677E+00, 1.8360449589E+00, 8.6599990907E-01],
	[2.4955000000E+04, 1.5559788434E+01, 5.2054171961E+00, 3.4713885701E+00, 1.8367329891E+00, 8.6606344978E-01],
	[2.4960000000E+04, 1.5564693672E+01, 5.2053574710E+00, 3.4736290681E+00, 1.8374209703E+00, 8.6612696125E-01],
	[2.4965000000E+04, 1.5569599473E+01, 5.2052977585E+00, 3.4758705621E+00, 1.8381089025E+00, 8.6619044352E-01],
	[2.4970000000E+04, 1.5574505838E+01, 5.2052380586E+00, 3.4781130522E+00, 1.8387967854E+00, 8.6625389664E-01],
	[2.4975000000E+04, 1.5579412766E+01, 5.2051783714E+00, 3.4803565386E+00, 1.8394846191E+00, 8.6631732063E-01],
	[2.4980000000E+04, 1.5584320257E+01, 5.2051186968E+00, 3.4826010217E+00, 1.8401724034E+00, 8.6638071550E-01],
	[2.4985000000E+04, 1.5589228312E+01, 5.2050590348E+00, 3.4848465017E+00, 1.8408601382E+00, 8.6644408127E-01],
	[2.4990000000E+04, 1.5594136929E+01, 5.2049993855E+00, 3.4870929788E+00, 1.8415478233E+00, 8.6650741794E-01],
	[2.4995000000E+04, 1.5599046110E+01, 5.2049397488E+00, 3.4893404532E+00, 1.8422354587E+00, 8.6657072554E-01],
	[2.5000000000E+04, 1.5603955854E+01, 5.2048801246E+00, 3.4915889253E+00, 1.8429230443E+00, 8.6663400407E-01],
	[2.5005000000E+04, 1.5608866161E+01, 5.2048205131E+00, 3.4938442133E+00, 1.8436121999E+00, 8.6669725356E-01],
	[2.5010000000E+04, 1.5613777030E+01, 5.2047609142E+00, 3.4961005059E+00, 1.8443013056E+00, 8.6676047401E-01],
	[2.5015000000E+04, 1.5618688463E+01, 5.2047013279E+00, 3.4983578034E+00, 1.8449903611E+00, 8.6682366545E-01],
	[2.5020000000E+04, 1.5623600458E+01, 5.2046417542E+00, 3.5006161060E+00, 1.8456793664E+00, 8.6688682787E-01],
	[2.5025000000E+04, 1.5628513017E+01, 5.2045821931E+00, 3.5028754139E+00, 1.8463683214E+00, 8.6694996131E-01],
	[2.5030000000E+04, 1.5633426138E+01, 5.2045226445E+00, 3.5051357273E+00, 1.8470572259E+00, 8.6701306577E-01],
	[2.5035000000E+04, 1.5638339822E+01, 5.2044631085E+00, 3.5073970466E+00, 1.8477460799E+00, 8.6707614126E-01],
	[2.5040000000E+04, 1.5643254068E+01, 5.2044035851E+00, 3.5096593720E+00, 1.8484348832E+00, 8.6713918781E-01],
	[2.5045000000E+04, 1.5648168877E+01, 5.2043440743E+00, 3.5119227037E+00, 1.8491236358E+00, 8.6720220542E-01],
	[2.5050000000E+04, 1.5653084249E+01, 5.2042845760E+00, 3.5141870420E+00, 1.8498123375E+00, 8.6726519411E-01],
	[2.5055000000E+04, 1.5658000183E+01, 5.2042250903E+00, 3.5164523871E+00, 1.8505009883E+00, 8.6732815389E-01],
	[2.5060000000E+04, 1.5662916680E+01, 5.2041656171E+00, 3.5187187392E+00, 1.8511895879E+00, 8.6739108478E-01],
	[2.5065000000E+04, 1.5667833739E+01, 5.2041061565E+00, 3.5209860987E+00, 1.8518781363E+00, 8.6745398680E-01],
	[2.5070000000E+04, 1.5672751361E+01, 5.2040467084E+00, 3.5232544657E+00, 1.8525666335E+00, 8.6751685994E-01],
	[2.5075000000E+04, 1.5677669545E+01, 5.2039872728E+00, 3.5255238405E+00, 1.8532550792E+00, 8.6757970424E-01],
	[2.5080000000E+04, 1.5682588291E+01, 5.2039278498E+00, 3.5277942233E+00, 1.8539434734E+00, 8.6764251970E-01],
	[2.5085000000E+04, 1.5687507599E+01, 5.2038684393E+00, 3.5300656145E+00, 1.8546318159E+00, 8.6770530634E-01],
	[2.5090000000E+04, 1.5692430615E+01, 5.2038095910E+00, 3.5323380142E+00, 1.8553202206E+00, 8.6776806417E-01],
	[2.5095000000E+04, 1.5697373396E+01, 5.2037541097E+00, 3.5346114226E+00, 1.8560092687E+00, 8.6783079320E-01],
	[2.5100000000E+04, 1.5702316749E+01, 5.2036986401E+00, 3.5368858401E+00, 1.8566982657E+00, 8.6789349346E-01],
	[2.5105000000E+04, 1.5707260673E+01, 5.2036431821E+00, 3.5391612669E+00, 1.8573872115E+00, 8.6795616495E-01],
	[2.5110000000E+04, 1.5712205169E+01, 5.2035877358E+00, 3.5414377031E+00, 1.8580761060E+00, 8.6801880768E-01],
	[2.5115000000E+04, 1.5717150236E+01, 5.2035323011E+00, 3.5437151492E+00, 1.8587649491E+00, 8.6808142168E-01],
	[2.5120000000E+04, 1.5722095875E+01, 5.2034768780E+00, 3.5459936052E+00, 1.8594537406E+00, 8.6814400696E-01],
	[2.5125000000E+04, 1.5727042086E+01, 5.2034214666E+00, 3.5482730716E+00, 1.8601424805E+00, 8.6820656352E-01],
	[2.5130000000E+04, 1.5731988867E+01, 5.2033660667E+00, 3.5505535484E+00, 1.8608311687E+00, 8.6826909139E-01],
	[2.5135000000E+04, 1.5736936220E+01, 5.2033106785E+00, 3.5528350360E+00, 1.8615198050E+00, 8.6833159058E-01],
	[2.5140000000E+04, 1.5741884145E+01, 5.2032553019E+00, 3.5551175345E+00, 1.8622083893E+00, 8.6839406110E-01],
	[2.5145000000E+04, 1.5746832640E+01, 5.2031999368E+00, 3.5574010444E+00, 1.8628969216E+00, 8.6845650297E-01],
	[2.5150000000E+04, 1.5751781707E+01, 5.2031445834E+00, 3.5596855657E+00, 1.8635854017E+00, 8.6851891619E-01],
	[2.5155000000E+04, 1.5756731345E+01, 5.2030892416E+00, 3.5619710987E+00, 1.8642738295E+00, 8.6858130079E-01],
	[2.5160000000E+04, 1.5761681555E+01, 5.2030339113E+00, 3.5642576437E+00, 1.8649622049E+00, 8.6864365678E-01],
	[2.5165000000E+04, 1.5766632335E+01, 5.2029785927E+00, 3.5665452010E+00, 1.8656505278E+00, 8.6870598417E-01],
	[2.5170000000E+04, 1.5771583686E+01, 5.2029232856E+00, 3.5688337707E+00, 1.8663387982E+00, 8.6876828298E-01],
	[2.5175000000E+04, 1.5776535608E+01, 5.2028679901E+00, 3.5711233532E+00, 1.8670270158E+00, 8.6883055322E-01],
	[2.5180000000E+04, 1.5781488102E+01, 5.2028127061E+00, 3.5734139486E+00, 1.8677151806E+00, 8.6889279490E-01],
	[2.5185000000E+04, 1.5786441166E+01, 5.2027574337E+00, 3.5757055573E+00, 1.8684032924E+00, 8.6895500804E-01],
	[2.5190000000E+04, 1.5791394800E+01, 5.2027021729E+00, 3.5779981794E+00, 1.8690913513E+00, 8.6901719265E-01],
	[2.5195000000E+04, 1.5796349006E+01, 5.2026469236E+00, 3.5802918152E+00, 1.8697793570E+00, 8.6907934875E-01],
	[2.5200000000E+04, 1.5801303783E+01, 5.2025916859E+00, 3.5825864650E+00, 1.8704673094E+00, 8.6914147635E-01],
	[2.5205000000E+04, 1.5806259130E+01, 5.2025364597E+00, 3.5848821289E+00, 1.8711552086E+00, 8.6920357547E-01],
	[2.5210000000E+04, 1.5811215047E+01, 5.2024812451E+00, 3.5871788073E+00, 1.8718430542E+00, 8.6926564611E-01],
	[2.5215000000E+04, 1.5816171536E+01, 5.2024260420E+00, 3.5894765005E+00, 1.8725308463E+00, 8.6932768829E-01],
	[2.5220000000E+04, 1.5821128595E+01, 5.2023708505E+00, 3.5917752085E+00, 1.8732185847E+00, 8.6938970203E-01],
	[2.5225000000E+04, 1.5826086224E+01, 5.2023156704E+00, 3.5940749317E+00, 1.8739062694E+00, 8.6945168734E-01],
	[2.5230000000E+04, 1.5831044424E+01, 5.2022605019E+00, 3.5963756704E+00, 1.8745939002E+00, 8.6951364424E-01],
	[2.5235000000E+04, 1.5836003194E+01, 5.2022053449E+00, 3.5986774248E+00, 1.8752814770E+00, 8.6957557273E-01],
	[2.5240000000E+04, 1.5840962535E+01, 5.2021501994E+00, 3.6009801950E+00, 1.8759689997E+00, 8.6963747283E-01],
	[2.5245000000E+04, 1.5845922445E+01, 5.2020950654E+00, 3.6032839815E+00, 1.8766564682E+00, 8.6969934456E-01],
	[2.5250000000E+04, 1.5850882927E+01, 5.2020399429E+00, 3.6055887843E+00, 1.8773438824E+00, 8.6976118793E-01],
	[2.5255000000E+04, 1.5855843978E+01, 5.2019848320E+00, 3.6078946039E+00, 1.8780312422E+00, 8.6982300296E-01],
	[2.5260000000E+04, 1.5860805599E+01, 5.2019297325E+00, 3.6102014403E+00, 1.8787185475E+00, 8.6988478965E-01],
	[2.5265000000E+04, 1.5865767791E+01, 5.2018746445E+00, 3.6125092939E+00, 1.8794057982E+00, 8.6994654802E-01],
	[2.5270000000E+04, 1.5870730553E+01, 5.2018195680E+00, 3.6148181649E+00, 1.8800929942E+00, 8.7000827809E-01],
	[2.5275000000E+04, 1.5875693885E+01, 5.2017645029E+00, 3.6171280536E+00, 1.8807801353E+00, 8.7006997987E-01],
	[2.5280000000E+04, 1.5880657786E+01, 5.2017094494E+00, 3.6194389601E+00, 1.8814672215E+00, 8.7013165337E-01],
	[2.5285000000E+04, 1.5885622258E+01, 5.2016544073E+00, 3.6217508848E+00, 1.8821542527E+00, 8.7019329861E-01],
	[2.5290000000E+04, 1.5890587300E+01, 5.2015993767E+00, 3.6240638279E+00, 1.8828412287E+00, 8.7025491560E-01],
	[2.5295000000E+04, 1.5895552911E+01, 5.2015443575E+00, 3.6263777896E+00, 1.8835281495E+00, 8.7031650435E-01],
	[2.5300000000E+04, 1.5900519092E+01, 5.2014893498E+00, 3.6286927703E+00, 1.8842150149E+00, 8.7037806489E-01],
	[2.5305000000E+04, 1.5905485843E+01, 5.2014343535E+00, 3.6310087700E+00, 1.8849018249E+00, 8.7043959721E-01],
	[2.5310000000E+04, 1.5910453164E+01, 5.2013793687E+00, 3.6333257891E+00, 1.8855885793E+00, 8.7050110135E-01],
	[2.5315000000E+04, 1.5915421054E+01, 5.2013243954E+00, 3.6356438279E+00, 1.8862752780E+00, 8.7056257730E-01],
	[2.5320000000E+04, 1.5920389514E+01, 5.2012694334E+00, 3.6379628865E+00, 1.8869619210E+00, 8.7062402509E-01],
	[2.5325000000E+04, 1.5925358543E+01, 5.2012144829E+00, 3.6402829652E+00, 1.8876485081E+00, 8.7068544473E-01],
	[2.5330000000E+04, 1.5930328142E+01, 5.2011595439E+00, 3.6426040643E+00, 1.8883350393E+00, 8.7074683623E-01],
	[2.5335000000E+04, 1.5935298310E+01, 5.2011046162E+00, 3.6449261840E+00, 1.8890215143E+00, 8.7080819960E-01],
	[2.5340000000E+04, 1.5940269048E+01, 5.2010497000E+00, 3.6472493246E+00, 1.8897079332E+00, 8.7086953486E-01],
	[2.5345000000E+04, 1.5945240355E+01, 5.2009947952E+00, 3.6495734863E+00, 1.8903942958E+00, 8.7093084203E-01],
	[2.5350000000E+04, 1.5950212232E+01, 5.2009399018E+00, 3.6518986693E+00, 1.8910806019E+00, 8.7099212112E-01],
	[2.5355000000E+04, 1.5955184677E+01, 5.2008850198E+00, 3.6542248739E+00, 1.8917668516E+00, 8.7105337214E-01],
	[2.5360000000E+04, 1.5960157692E+01, 5.2008301492E+00, 3.6565521004E+00, 1.8924530447E+00, 8.7111459510E-01],
	[2.5365000000E+04, 1.5965131277E+01, 5.2007752900E+00, 3.6588803489E+00, 1.8931391811E+00, 8.7117579002E-01],
	[2.5370000000E+04, 1.5970105430E+01, 5.2007204422E+00, 3.6612096198E+00, 1.8938252607E+00, 8.7123695691E-01],
	[2.5375000000E+04, 1.5975080152E+01, 5.2006656058E+00, 3.6635399133E+00, 1.8945112833E+00, 8.7129809580E-01],
	[2.5380000000E+04, 1.5980055444E+01, 5.2006107808E+00, 3.6658712296E+00, 1.8951972490E+00, 8.7135920668E-01],
	[2.5385000000E+04, 1.5985031304E+01, 5.2005559671E+00, 3.6682035690E+00, 1.8958831575E+00, 8.7142028957E-01],
	[2.5390000000E+04, 1.5990007733E+01, 5.2005011648E+00, 3.6705369317E+00, 1.8965690088E+00, 8.7148134450E-01],
	[2.5395000000E+04, 1.5994984731E+01, 5.2004463739E+00, 3.6728713180E+00, 1.8972548028E+00, 8.7154237147E-01],
	[2.5400000000E+04, 1.5999962298E+01, 5.2003915943E+00, 3.6752067281E+00, 1.8979405394E+00, 8.7160337049E-01],
	[2.5405000000E+04, 1.6004940434E+01, 5.2003368261E+00, 3.6775431623E+00, 1.8986262184E+00, 8.7166434158E-01],
	[2.5410000000E+04, 1.6009919139E+01, 5.2002820693E+00, 3.6798806208E+00, 1.8993118398E+00, 8.7172528475E-01],
	[2.5415000000E+04, 1.6014898412E+01, 5.2002273238E+00, 3.6822191038E+00, 1.8999974035E+00, 8.7178620003E-01],
	[2.5420000000E+04, 1.6019878254E+01, 5.2001725897E+00, 3.6845586116E+00, 1.9006829093E+00, 8.7184708741E-01],
	[2.5425000000E+04, 1.6024858665E+01, 5.2001178669E+00, 3.6868991445E+00, 1.9013683572E+00, 8.7190794692E-01],
	[2.5430000000E+04, 1.6029839644E+01, 5.2000631554E+00, 3.6892407027E+00, 1.9020537471E+00, 8.7196877856E-01],
	[2.5435000000E+04, 1.6034821191E+01, 5.2000084553E+00, 3.6915832865E+00, 1.9027390788E+00, 8.7202958236E-01],
	[2.5440000000E+04, 1.6039803308E+01, 5.1999537664E+00, 3.6939268960E+00, 1.9034243522E+00, 8.7209035833E-01],
	[2.5445000000E+04, 1.6044785992E+01, 5.1998990890E+00, 3.6962715316E+00, 1.9041095673E+00, 8.7215110647E-01],
	[2.5450000000E+04, 1.6049769245E+01, 5.1998444228E+00, 3.6986171935E+00, 1.9047947240E+00, 8.7221182681E-01],
	[2.5455000000E+04, 1.6054753066E+01, 5.1997897679E+00, 3.7009638819E+00, 1.9054798221E+00, 8.7227251935E-01],
	[2.5460000000E+04, 1.6059737456E+01, 5.1997351244E+00, 3.7033115971E+00, 1.9061648615E+00, 8.7233318412E-01],
	[2.5465000000E+04, 1.6064722414E+01, 5.1996804921E+00, 3.7056603393E+00, 1.9068498422E+00, 8.7239382112E-01],
	[2.5470000000E+04, 1.6069707940E+01, 5.1996258712E+00, 3.7080101088E+00, 1.9075347640E+00, 8.7245443037E-01],
	[2.5475000000E+04, 1.6074694034E+01, 5.1995712616E+00, 3.7103609058E+00, 1.9082196269E+00, 8.7251501188E-01],
	[2.5480000000E+04, 1.6079680696E+01, 5.1995166632E+00, 3.7127127306E+00, 1.9089044307E+00, 8.7257556567E-01],
	[2.5485000000E+04, 1.6084667926E+01, 5.1994620761E+00, 3.7150655834E+00, 1.9095891753E+00, 8.7263609175E-01],
	[2.5490000000E+04, 1.6089655724E+01, 5.1994075003E+00, 3.7174194644E+00, 1.9102738606E+00, 8.7269659013E-01],
	[2.5495000000E+04, 1.6094652109E+01, 5.1993543171E+00, 3.7197743740E+00, 1.9109587863E+00, 8.7275706083E-01],
	[2.5500000000E+04, 1.6099663317E+01, 5.1993035994E+00, 3.7221303123E+00, 1.9116441855E+00, 8.7281750385E-01],
	[2.5505000000E+04, 1.6104675103E+01, 5.1992528921E+00, 3.7244872796E+00, 1.9123295260E+00, 8.7287791923E-01],
	[2.5510000000E+04, 1.6109687466E+01, 5.1992021952E+00, 3.7268452762E+00, 1.9130148076E+00, 8.7293830696E-01],
	[2.5515000000E+04, 1.6114700406E+01, 5.1991515088E+00, 3.7292043023E+00, 1.9137000304E+00, 8.7299866706E-01],
	[2.5520000000E+04, 1.6119713924E+01, 5.1991008328E+00, 3.7315643581E+00, 1.9143851941E+00, 8.7305899955E-01],
	[2.5525000000E+04, 1.6124728019E+01, 5.1990501672E+00, 3.7339254439E+00, 1.9150702986E+00, 8.7311930440E-01],
	[2.5530000000E+04, 1.6129742690E+01, 5.1989995120E+00, 3.7362875600E+00, 1.9157553440E+00, 8.7317958154E-01],
	[2.5535000000E+04, 1.6134757939E+01, 5.1989488672E+00, 3.7386507066E+00, 1.9164403300E+00, 8.7323983096E-01],
	[2.5540000000E+04, 1.6139773765E+01, 5.1988982329E+00, 3.7410148838E+00, 1.9171252565E+00, 8.7330005268E-01],
	[2.5545000000E+04, 1.6144790168E+01, 5.1988476089E+00, 3.7433800921E+00, 1.9178101236E+00, 8.7336024669E-01],
	[2.5550000000E+04, 1.6149807147E+01, 5.1987969954E+00, 3.7457463316E+00, 1.9184949310E+00, 8.7342041302E-01],
	[2.5555000000E+04, 1.6154824704E+01, 5.1987463923E+00, 3.7481136025E+00, 1.9191796787E+00, 8.7348055167E-01],
	[2.5560000000E+04, 1.6159842837E+01, 5.1986957995E+00, 3.7504819052E+00, 1.9198643665E+00, 8.7354066264E-01],
	[2.5565000000E+04, 1.6164861548E+01, 5.1986452171E+00, 3.7528512399E+00, 1.9205489944E+00, 8.7360074596E-01],
	[2.5570000000E+04, 1.6169880834E+01, 5.1985946452E+00, 3.7552216068E+00, 1.9212335623E+00, 8.7366080162E-01],
	[2.5575000000E+04, 1.6174900698E+01, 5.1985440835E+00, 3.7575930061E+00, 1.9219180700E+00, 8.7372082964E-01],
	[2.5580000000E+04, 1.6179921138E+01, 5.1984935323E+00, 3.7599654381E+00, 1.9226025175E+00, 8.7378083003E-01],
	[2.5585000000E+04, 1.6184942155E+01, 5.1984429915E+00, 3.7623389032E+00, 1.9232869047E+00, 8.7384080279E-01],
	[2.5590000000E+04, 1.6189963748E+01, 5.1983924610E+00, 3.7647134014E+00, 1.9239712314E+00, 8.7390074793E-01],
	[2.5595000000E+04, 1.6194985918E+01, 5.1983419409E+00, 3.7670889330E+00, 1.9246554976E+00, 8.7396066547E-01],
	[2.5600000000E+04, 1.6200008664E+01, 5.1982914311E+00, 3.7694654984E+00, 1.9253397031E+00, 8.7402055541E-01],
	[2.5605000000E+04, 1.6205031987E+01, 5.1982409317E+00, 3.7718430977E+00, 1.9260238480E+00, 8.7408041777E-01],
	[2.5610000000E+04, 1.6210055886E+01, 5.1981904426E+00, 3.7742217312E+00, 1.9267079320E+00, 8.7414025254E-01],
	[2.5615000000E+04, 1.6215080361E+01, 5.1981399639E+00, 3.7766013992E+00, 1.9273919550E+00, 8.7420005974E-01],
	[2.5620000000E+04, 1.6220105413E+01, 5.1980894955E+00, 3.7789821018E+00, 1.9280759170E+00, 8.7425983938E-01],
	[2.5625000000E+04, 1.6225131040E+01, 5.1980390375E+00, 3.7813638394E+00, 1.9287598179E+00, 8.7431959147E-01],
	[2.5630000000E+04, 1.6230157244E+01, 5.1979885898E+00, 3.7837466121E+00, 1.9294436576E+00, 8.7437931602E-01],
	[2.5635000000E+04, 1.6235184024E+01, 5.1979381524E+00, 3.7861304203E+00, 1.9301274359E+00, 8.7443901303E-01],
	[2.5640000000E+04, 1.6240211380E+01, 5.1978877254E+00, 3.7885152642E+00, 1.9308111528E+00, 8.7449868252E-01],
	[2.5645000000E+04, 1.6245239313E+01, 5.1978373087E+00, 3.7909011440E+00, 1.9314948082E+00, 8.7455832450E-01],
	[2.5650000000E+04, 1.6250267821E+01, 5.1977869023E+00, 3.7932880600E+00, 1.9321784019E+00, 8.7461793897E-01],
	[2.5655000000E+04, 1.6255296905E+01, 5.1977365062E+00, 3.7956760123E+00, 1.9328619339E+00, 8.7467752594E-01],
	[2.5660000000E+04, 1.6260326565E+01, 5.1976861204E+00, 3.7980650014E+00, 1.9335454041E+00, 8.7473708543E-01],
	[2.5665000000E+04, 1.6265356801E+01, 5.1976357449E+00, 3.8004550274E+00, 1.9342288124E+00, 8.7479661743E-01],
	[2.5670000000E+04, 1.6270387612E+01, 5.1975853797E+00, 3.8028460905E+00, 1.9349121586E+00, 8.7485612197E-01],
	[2.5675000000E+04, 1.6275418999E+01, 5.1975350249E+00, 3.8052381911E+00, 1.9355954427E+00, 8.7491559905E-01],
	[2.5680000000E+04, 1.6280450963E+01, 5.1974846803E+00, 3.8076313293E+00, 1.9362786646E+00, 8.7497504868E-01],
	[2.5685000000E+04, 1.6285483501E+01, 5.1974343460E+00, 3.8100255054E+00, 1.9369618242E+00, 8.7503447087E-01],
	[2.5690000000E+04, 1.6290516616E+01, 5.1973840220E+00, 3.8124207196E+00, 1.9376449213E+00, 8.7509386563E-01],
	[2.5695000000E+04, 1.6295550305E+01, 5.1973337082E+00, 3.8148169723E+00, 1.9383279560E+00, 8.7515323296E-01],
	[2.5700000000E+04, 1.6300584571E+01, 5.1972834048E+00, 3.8172142636E+00, 1.9390109280E+00, 8.7521257288E-01],
	[2.5705000000E+04, 1.6305619412E+01, 5.1972331116E+00, 3.8196125938E+00, 1.9396938373E+00, 8.7527188540E-01],
	[2.5710000000E+04, 1.6310654828E+01, 5.1971828287E+00, 3.8220119631E+00, 1.9403766839E+00, 8.7533117052E-01],
	[2.5715000000E+04, 1.6315690820E+01, 5.1971325560E+00, 3.8244123719E+00, 1.9410594675E+00, 8.7539042826E-01],
	[2.5720000000E+04, 1.6320727387E+01, 5.1970822936E+00, 3.8268138202E+00, 1.9417421881E+00, 8.7544965862E-01],
	[2.5725000000E+04, 1.6325764529E+01, 5.1970320415E+00, 3.8292163085E+00, 1.9424248456E+00, 8.7550886162E-01],
	[2.5730000000E+04, 1.6330802247E+01, 5.1969817996E+00, 3.8316198369E+00, 1.9431074399E+00, 8.7556803726E-01],
	[2.5735000000E+04, 1.6335840539E+01, 5.1969315680E+00, 3.8340244056E+00, 1.9437899709E+00, 8.7562718555E-01],
	[2.5740000000E+04, 1.6340879407E+01, 5.1968813466E+00, 3.8364300150E+00, 1.9444724385E+00, 8.7568630650E-01],
	[2.5745000000E+04, 1.6345918850E+01, 5.1968311355E+00, 3.8388366653E+00, 1.9451548426E+00, 8.7574540012E-01],
	[2.5750000000E+04, 1.6350958868E+01, 5.1967809345E+00, 3.8412443567E+00, 1.9458371831E+00, 8.7580446643E-01],
	[2.5755000000E+04, 1.6355999461E+01, 5.1967307439E+00, 3.8436530895E+00, 1.9465194599E+00, 8.7586350542E-01],
	[2.5760000000E+04, 1.6361040629E+01, 5.1966805634E+00, 3.8460628638E+00, 1.9472016730E+00, 8.7592251711E-01],
	[2.5765000000E+04, 1.6366082372E+01, 5.1966303932E+00, 3.8484736801E+00, 1.9478838222E+00, 8.7598150151E-01],
	[2.5770000000E+04, 1.6371124690E+01, 5.1965802332E+00, 3.8508855384E+00, 1.9485659074E+00, 8.7604045863E-01],
	[2.5775000000E+04, 1.6376167583E+01, 5.1965300834E+00, 3.8532984391E+00, 1.9492479285E+00, 8.7609938848E-01],
	[2.5780000000E+04, 1.6381211050E+01, 5.1964799438E+00, 3.8557123825E+00, 1.9499298854E+00, 8.7615829106E-01],
	[2.5785000000E+04, 1.6386255092E+01, 5.1964298144E+00, 3.8581273686E+00, 1.9506117781E+00, 8.7621716639E-01],
	[2.5790000000E+04, 1.6391299709E+01, 5.1963796952E+00, 3.8605433979E+00, 1.9512936064E+00, 8.7627601448E-01],
	[2.5795000000E+04, 1.6396344901E+01, 5.1963295863E+00, 3.8629604706E+00, 1.9519753703E+00, 8.7633483533E-01],
	[2.5800000000E+04, 1.6401390667E+01, 5.1962794875E+00, 3.8653785868E+00, 1.9526570696E+00, 8.7639362895E-01],
	[2.5805000000E+04, 1.6406437008E+01, 5.1962293989E+00, 3.8677977469E+00, 1.9533387042E+00, 8.7645239536E-01],
	[2.5810000000E+04, 1.6411483923E+01, 5.1961793205E+00, 3.8702179510E+00, 1.9540202741E+00, 8.7651113456E-01],
	[2.5815000000E+04, 1.6416531412E+01, 5.1961292523E+00, 3.8726391996E+00, 1.9547017791E+00, 8.7656984657E-01],
	[2.5820000000E+04, 1.6421579476E+01, 5.1960791942E+00, 3.8750614927E+00, 1.9553832192E+00, 8.7662853139E-01],
	[2.5825000000E+04, 1.6426628115E+01, 5.1960291464E+00, 3.8774848306E+00, 1.9560645943E+00, 8.7668718903E-01],
	[2.5830000000E+04, 1.6431677328E+01, 5.1959791087E+00, 3.8799092136E+00, 1.9567459042E+00, 8.7674581950E-01],
	[2.5835000000E+04, 1.6436727115E+01, 5.1959290811E+00, 3.8823346420E+00, 1.9574271489E+00, 8.7680442281E-01],
	[2.5840000000E+04, 1.6441777476E+01, 5.1958790638E+00, 3.8847611159E+00, 1.9581083283E+00, 8.7686299897E-01],
	[2.5845000000E+04, 1.6446828411E+01, 5.1958290566E+00, 3.8871886357E+00, 1.9587894422E+00, 8.7692154799E-01],
	[2.5850000000E+04, 1.6451879921E+01, 5.1957790595E+00, 3.8896172015E+00, 1.9594704906E+00, 8.7698006988E-01],
	[2.5855000000E+04, 1.6456932004E+01, 5.1957290726E+00, 3.8920468137E+00, 1.9601514734E+00, 8.7703856465E-01],
	[2.5860000000E+04, 1.6461984662E+01, 5.1956790959E+00, 3.8944774724E+00, 1.9608323905E+00, 8.7709703231E-01],
	[2.5865000000E+04, 1.6467037894E+01, 5.1956291292E+00, 3.8969091780E+00, 1.9615132418E+00, 8.7715547287E-01],
	[2.5870000000E+04, 1.6472091699E+01, 5.1955791728E+00, 3.8993419306E+00, 1.9621940272E+00, 8.7721388633E-01],
	[2.5875000000E+04, 1.6477146079E+01, 5.1955292264E+00, 3.9017757306E+00, 1.9628747466E+00, 8.7727227271E-01],
	[2.5880000000E+04, 1.6482201032E+01, 5.1954792902E+00, 3.9042105781E+00, 1.9635553999E+00, 8.7733063202E-01],
	[2.5885000000E+04, 1.6487256560E+01, 5.1954293641E+00, 3.9066464734E+00, 1.9642359870E+00, 8.7738896427E-01],
	[2.5890000000E+04, 1.6492312661E+01, 5.1953794482E+00, 3.9090834167E+00, 1.9649165079E+00, 8.7744726946E-01],
	[2.5895000000E+04, 1.6497369335E+01, 5.1953295423E+00, 3.9115214084E+00, 1.9655969623E+00, 8.7750554760E-01],
	[2.5900000000E+04, 1.6502426584E+01, 5.1952796466E+00, 3.9139604486E+00, 1.9662773503E+00, 8.7756379871E-01],
	[2.5905000000E+04, 1.6507490587E+01, 5.1952308120E+00, 3.9164005377E+00, 1.9669579101E+00, 8.7762202279E-01],
	[2.5910000000E+04, 1.6512571148E+01, 5.1951847041E+00, 3.9188416758E+00, 1.9676390202E+00, 8.7768021986E-01],
	[2.5915000000E+04, 1.6517652292E+01, 5.1951386055E+00, 3.9212838631E+00, 1.9683200643E+00, 8.7773838993E-01],
	[2.5920000000E+04, 1.6522734018E+01, 5.1950925162E+00, 3.9237271001E+00, 1.9690010425E+00, 8.7779653299E-01],
	[2.5925000000E+04, 1.6527816328E+01, 5.1950464362E+00, 3.9261713868E+00, 1.9696819545E+00, 8.7785464907E-01],
	[2.5930000000E+04, 1.6532899220E+01, 5.1950003655E+00, 3.9286167235E+00, 1.9703628003E+00, 8.7791273817E-01],
	[2.5935000000E+04, 1.6537982695E+01, 5.1949543040E+00, 3.9310631106E+00, 1.9710435798E+00, 8.7797080030E-01],
	[2.5940000000E+04, 1.6543066753E+01, 5.1949082519E+00, 3.9335105482E+00, 1.9717242929E+00, 8.7802883548E-01],
	[2.5945000000E+04, 1.6548151393E+01, 5.1948622091E+00, 3.9359590365E+00, 1.9724049395E+00, 8.7808684370E-01],
	[2.5950000000E+04, 1.6553236616E+01, 5.1948161755E+00, 3.9384085759E+00, 1.9730855196E+00, 8.7814482499E-01],
	[2.5955000000E+04, 1.6558322421E+01, 5.1947701512E+00, 3.9408591666E+00, 1.9737660330E+00, 8.7820277935E-01],
	[2.5960000000E+04, 1.6563408809E+01, 5.1947241362E+00, 3.9433108089E+00, 1.9744464796E+00, 8.7826070679E-01],
	[2.5965000000E+04, 1.6568495779E+01, 5.1946781304E+00, 3.9457635028E+00, 1.9751268593E+00, 8.7831860732E-01],
	[2.5970000000E+04, 1.6573583331E+01, 5.1946321339E+00, 3.9482172489E+00, 1.9758071721E+00, 8.7837648094E-01],
	[2.5975000000E+04, 1.6578671466E+01, 5.1945861467E+00, 3.9506720472E+00, 1.9764874179E+00, 8.7843432768E-01],
	[2.5980000000E+04, 1.6583760184E+01, 5.1945401688E+00, 3.9531278980E+00, 1.9771675965E+00, 8.7849214754E-01],
	[2.5985000000E+04, 1.6588849483E+01, 5.1944942001E+00, 3.9555848016E+00, 1.9778477078E+00, 8.7854994052E-01],
	[2.5990000000E+04, 1.6593939365E+01, 5.1944482406E+00, 3.9580427582E+00, 1.9785277519E+00, 8.7860770665E-01],
	[2.5995000000E+04, 1.6599029828E+01, 5.1944022904E+00, 3.9605017680E+00, 1.9792077285E+00, 8.7866544592E-01],
	[2.6000000000E+04, 1.6604120874E+01, 5.1943563494E+00, 3.9629618314E+00, 1.9798876376E+00, 8.7872315835E-01],
	[2.6005000000E+04, 1.6609212502E+01, 5.1943104177E+00, 3.9654229485E+00, 1.9805674791E+00, 8.7878084395E-01],
	[2.6010000000E+04, 1.6614304712E+01, 5.1942644952E+00, 3.9678851197E+00, 1.9812472529E+00, 8.7883850272E-01],
	[2.6015000000E+04, 1.6619397504E+01, 5.1942185820E+00, 3.9703483451E+00, 1.9819269588E+00, 8.7889613468E-01],
	[2.6020000000E+04, 1.6624490878E+01, 5.1941726779E+00, 3.9728126250E+00, 1.9826065969E+00, 8.7895373984E-01],
	[2.6025000000E+04, 1.6629584833E+01, 5.1941267831E+00, 3.9752779597E+00, 1.9832861671E+00, 8.7901131821E-01],
	[2.6030000000E+04, 1.6634679371E+01, 5.1940808975E+00, 3.9777443494E+00, 1.9839656691E+00, 8.7906886979E-01],
	[2.6035000000E+04, 1.6639774490E+01, 5.1940350212E+00, 3.9802117943E+00, 1.9846451030E+00, 8.7912639460E-01],
	[2.6040000000E+04, 1.6644870191E+01, 5.1939891540E+00, 3.9826802947E+00, 1.9853244686E+00, 8.7918389264E-01],
	[2.6045000000E+04, 1.6649966474E+01, 5.1939432961E+00, 3.9851498509E+00, 1.9860037659E+00, 8.7924136393E-01],
	[2.6050000000E+04, 1.6655063338E+01, 5.1938974474E+00, 3.9876204631E+00, 1.9866829947E+00, 8.7929880847E-01],
	[2.6055000000E+04, 1.6660160784E+01, 5.1938516079E+00, 3.9900921315E+00, 1.9873621550E+00, 8.7935622628E-01],
	[2.6060000000E+04, 1.6665258812E+01, 5.1938057775E+00, 3.9925648564E+00, 1.9880412466E+00, 8.7941361737E-01],
	[2.6065000000E+04, 1.6670357421E+01, 5.1937599564E+00, 3.9950386380E+00, 1.9887202696E+00, 8.7947098174E-01],
	[2.6070000000E+04, 1.6675456612E+01, 5.1937141445E+00, 3.9975134766E+00, 1.9893992237E+00, 8.7952831940E-01],
	[2.6075000000E+04, 1.6680556384E+01, 5.1936683417E+00, 3.9999893725E+00, 1.9900781089E+00, 8.7958563037E-01],
	[2.6080000000E+04, 1.6685656737E+01, 5.1936225482E+00, 4.0024663259E+00, 1.9907569252E+00, 8.7964291467E-01],
	[2.6085000000E+04, 1.6690757672E+01, 5.1935767638E+00, 4.0049443369E+00, 1.9914356723E+00, 8.7970017232E-01],
	[2.6090000000E+04, 1.6695859188E+01, 5.1935309886E+00, 4.0074234060E+00, 1.9921143502E+00, 8.7975740330E-01],
	[2.6095000000E+04, 1.6700961285E+01, 5.1934852226E+00, 4.0099035333E+00, 1.9927929589E+00, 8.7981460765E-01],
	[2.6100000000E+04, 1.6706063963E+01, 5.1934394657E+00, 4.0123847191E+00, 1.9934714982E+00, 8.7987178535E-01],
	[2.6105000000E+04, 1.6711167223E+01, 5.1933937180E+00, 4.0148669636E+00, 1.9941499681E+00, 8.7992893644E-01],
	[2.6110000000E+04, 1.6716271063E+01, 5.1933479795E+00, 4.0173502670E+00, 1.9948283684E+00, 8.7998606090E-01],
	[2.6115000000E+04, 1.6721375485E+01, 5.1933022502E+00, 4.0198346297E+00, 1.9955066991E+00, 8.8004315876E-01],
	[2.6120000000E+04, 1.6726480488E+01, 5.1932565300E+00, 4.0223200519E+00, 1.9961849600E+00, 8.8010023001E-01],
	[2.6125000000E+04, 1.6731586072E+01, 5.1932108189E+00, 4.0248065338E+00, 1.9968631512E+00, 8.8015727468E-01],
	[2.6130000000E+04, 1.6736692236E+01, 5.1931651170E+00, 4.0272940756E+00, 1.9975412724E+00, 8.8021429276E-01],
	[2.6135000000E+04, 1.6741798982E+01, 5.1931194243E+00, 4.0297826777E+00, 1.9982193236E+00, 8.8027128427E-01],
	[2.6140000000E+04, 1.6746906308E+01, 5.1930737407E+00, 4.0322723402E+00, 1.9988973047E+00, 8.8032824922E-01],
	[2.6145000000E+04, 1.6752014215E+01, 5.1930280662E+00, 4.0347630635E+00, 1.9995752156E+00, 8.8038518761E-01],
	[2.6150000000E+04, 1.6757122703E+01, 5.1929824009E+00, 4.0372548477E+00, 2.0002530563E+00, 8.8044209945E-01],
	[2.6155000000E+04, 1.6762231772E+01, 5.1929367447E+00, 4.0397476931E+00, 2.0009308266E+00, 8.8049898476E-01],
	[2.6160000000E+04, 1.6767341421E+01, 5.1928910976E+00, 4.0422416000E+00, 2.0016085264E+00, 8.8055584354E-01],
	[2.6165000000E+04, 1.6772451651E+01, 5.1928454596E+00, 4.0447365685E+00, 2.0022861557E+00, 8.8061267580E-01],
	[2.6170000000E+04, 1.6777562461E+01, 5.1927998308E+00, 4.0472325991E+00, 2.0029637143E+00, 8.8066948155E-01],
	[2.6175000000E+04, 1.6782673852E+01, 5.1927542111E+00, 4.0497296918E+00, 2.0036412023E+00, 8.8072626081E-01],
	[2.6180000000E+04, 1.6787785824E+01, 5.1927086005E+00, 4.0522278470E+00, 2.0043186194E+00, 8.8078301356E-01],
	[2.6185000000E+04, 1.6792898376E+01, 5.1926629990E+00, 4.0547270649E+00, 2.0049959655E+00, 8.8083973984E-01],
	[2.6190000000E+04, 1.6798011508E+01, 5.1926174066E+00, 4.0572273457E+00, 2.0056732407E+00, 8.8089643964E-01],
	[2.6195000000E+04, 1.6803125221E+01, 5.1925718234E+00, 4.0597286898E+00, 2.0063504448E+00, 8.8095311298E-01],
	[2.6200000000E+04, 1.6808239514E+01, 5.1925262492E+00, 4.0622310973E+00, 2.0070275778E+00, 8.8100975986E-01],
	[2.6205000000E+04, 1.6813354387E+01, 5.1924806841E+00, 4.0647345684E+00, 2.0077046394E+00, 8.8106638029E-01],
	[2.6210000000E+04, 1.6818469840E+01, 5.1924351281E+00, 4.0672391035E+00, 2.0083816297E+00, 8.8112297429E-01],
	[2.6215000000E+04, 1.6823585874E+01, 5.1923895812E+00, 4.0697447029E+00, 2.0090585486E+00, 8.8117954186E-01],
	[2.6220000000E+04, 1.6828702487E+01, 5.1923440434E+00, 4.0722513666E+00, 2.0097353959E+00, 8.8123608301E-01],
	[2.6225000000E+04, 1.6833819681E+01, 5.1922985147E+00, 4.0747590950E+00, 2.0104121715E+00, 8.8129259775E-01],
	[2.6230000000E+04, 1.6838937455E+01, 5.1922529951E+00, 4.0772678884E+00, 2.0110888755E+00, 8.8134908608E-01],
	[2.6235000000E+04, 1.6844055808E+01, 5.1922074845E+00, 4.0797777470E+00, 2.0117655077E+00, 8.8140554803E-01],
	[2.6240000000E+04, 1.6849174742E+01, 5.1921619830E+00, 4.0822886710E+00, 2.0124420679E+00, 8.8146198359E-01],
	[2.6245000000E+04, 1.6854294256E+01, 5.1921164906E+00, 4.0848006607E+00, 2.0131185562E+00, 8.8151839278E-01],
	[2.6250000000E+04, 1.6859414349E+01, 5.1920710072E+00, 4.0873137163E+00, 2.0137949724E+00, 8.8157477560E-01],
	[2.6255000000E+04, 1.6864535022E+01, 5.1920255329E+00, 4.0898278381E+00, 2.0144713164E+00, 8.8163113207E-01],
	[2.6260000000E+04, 1.6869656275E+01, 5.1919800676E+00, 4.0923430263E+00, 2.0151475882E+00, 8.8168746219E-01],
	[2.6265000000E+04, 1.6874778108E+01, 5.1919346114E+00, 4.0948592812E+00, 2.0158237876E+00, 8.8174376597E-01],
	[2.6270000000E+04, 1.6879900520E+01, 5.1918891643E+00, 4.0973766030E+00, 2.0164999147E+00, 8.8180004342E-01],
	[2.6275000000E+04, 1.6885023512E+01, 5.1918437262E+00, 4.0998949920E+00, 2.0171759692E+00, 8.8185629456E-01],
	[2.6280000000E+04, 1.6890147084E+01, 5.1917982971E+00, 4.1024144484E+00, 2.0178519510E+00, 8.8191251938E-01],
	[2.6285000000E+04, 1.6895271235E+01, 5.1917528771E+00, 4.1049349725E+00, 2.0185278602E+00, 8.8196871791E-01],
	[2.6290000000E+04, 1.6900395965E+01, 5.1917074661E+00, 4.1074565645E+00, 2.0192036966E+00, 8.8202489014E-01],
	[2.6295000000E+04, 1.6905521275E+01, 5.1916620642E+00, 4.1099792247E+00, 2.0198794602E+00, 8.8208103609E-01],
	[2.6300000000E+04, 1.6910647165E+01, 5.1916166713E+00, 4.1125029533E+00, 2.0205551507E+00, 8.8213715577E-01],
	[2.6305000000E+04, 1.6915773634E+01, 5.1915712874E+00, 4.1150277506E+00, 2.0212307682E+00, 8.8219324918E-01],
	[2.6310000000E+04, 1.6920900682E+01, 5.1915259125E+00, 4.1175536167E+00, 2.0219063126E+00, 8.8224931634E-01],
	[2.6315000000E+04, 1.6926028309E+01, 5.1914805467E+00, 4.1200805521E+00, 2.0225817838E+00, 8.8230535725E-01],
	[2.6320000000E+04, 1.6931156516E+01, 5.1914351898E+00, 4.1226085568E+00, 2.0232571816E+00, 8.8236137193E-01],
	[2.6325000000E+04, 1.6936304627E+01, 5.1913930857E+00, 4.1251376313E+00, 2.0239332750E+00, 8.8241736038E-01],
	[2.6330000000E+04, 1.6941456053E+01, 5.1913514475E+00, 4.1276677756E+00, 2.0246094043E+00, 8.8247332261E-01],
	[2.6335000000E+04, 1.6946608068E+01, 5.1913098175E+00, 4.1301989901E+00, 2.0252854607E+00, 8.8252925863E-01],
	[2.6340000000E+04, 1.6951760670E+01, 5.1912681957E+00, 4.1327312750E+00, 2.0259614443E+00, 8.8258516846E-01],
	[2.6345000000E+04, 1.6956913861E+01, 5.1912265822E+00, 4.1352646305E+00, 2.0266373550E+00, 8.8264105209E-01],
	[2.6350000000E+04, 1.6962067640E+01, 5.1911849769E+00, 4.1377990570E+00, 2.0273131927E+00, 8.8269690954E-01],
	[2.6355000000E+04, 1.6967222007E+01, 5.1911433799E+00, 4.1403345546E+00, 2.0279889573E+00, 8.8275274082E-01],
	[2.6360000000E+04, 1.6972376962E+01, 5.1911017910E+00, 4.1428711236E+00, 2.0286646487E+00, 8.8280854594E-01],
	[2.6365000000E+04, 1.6977532505E+01, 5.1910602104E+00, 4.1454087643E+00, 2.0293402668E+00, 8.8286432491E-01],
	[2.6370000000E+04, 1.6982688636E+01, 5.1910186380E+00, 4.1479474769E+00, 2.0300158115E+00, 8.8292007773E-01],
	[2.6375000000E+04, 1.6987845355E+01, 5.1909770739E+00, 4.1504872616E+00, 2.0306912828E+00, 8.8297580441E-01],
	[2.6380000000E+04, 1.6993002662E+01, 5.1909355179E+00, 4.1530281187E+00, 2.0313666805E+00, 8.8303150498E-01],
	[2.6385000000E+04, 1.6998160556E+01, 5.1908939701E+00, 4.1555700485E+00, 2.0320420046E+00, 8.8308717942E-01],
	[2.6390000000E+04, 1.7003319039E+01, 5.1908524306E+00, 4.1581130511E+00, 2.0327172550E+00, 8.8314282776E-01],
	[2.6395000000E+04, 1.7008478109E+01, 5.1908108992E+00, 4.1606571269E+00, 2.0333924316E+00, 8.8319845000E-01],
	[2.6400000000E+04, 1.7013637767E+01, 5.1907693761E+00, 4.1632022761E+00, 2.0340675343E+00, 8.8325404616E-01],
	[2.6405000000E+04, 1.7018798013E+01, 5.1907278611E+00, 4.1657484990E+00, 2.0347425630E+00, 8.8330961623E-01],
	[2.6410000000E+04, 1.7023958846E+01, 5.1906863543E+00, 4.1682957957E+00, 2.0354175176E+00, 8.8336516024E-01],
	[2.6415000000E+04, 1.7029120267E+01, 5.1906448558E+00, 4.1708441666E+00, 2.0360923982E+00, 8.8342067819E-01],
	[2.6420000000E+04, 1.7034282275E+01, 5.1906033654E+00, 4.1733936119E+00, 2.0367672044E+00, 8.8347617008E-01],
	[2.6425000000E+04, 1.7039444871E+01, 5.1905618832E+00, 4.1759441318E+00, 2.0374419364E+00, 8.8353163594E-01],
	[2.6430000000E+04, 1.7044608054E+01, 5.1905204091E+00, 4.1784957266E+00, 2.0381165939E+00, 8.8358707576E-01],
	[2.6435000000E+04, 1.7049771825E+01, 5.1904789433E+00, 4.1810483965E+00, 2.0387911770E+00, 8.8364248957E-01],
	[2.6440000000E+04, 1.7054936183E+01, 5.1904374856E+00, 4.1836021418E+00, 2.0394656854E+00, 8.8369787735E-01],
	[2.6445000000E+04, 1.7060101128E+01, 5.1903960361E+00, 4.1861569628E+00, 2.0401401192E+00, 8.8375323914E-01],
	[2.6450000000E+04, 1.7065266661E+01, 5.1903545948E+00, 4.1887128596E+00, 2.0408144783E+00, 8.8380857493E-01],
	[2.6455000000E+04, 1.7070432780E+01, 5.1903131616E+00, 4.1912698326E+00, 2.0414887625E+00, 8.8386388474E-01],
	[2.6460000000E+04, 1.7075599487E+01, 5.1902717366E+00, 4.1938278820E+00, 2.0421629718E+00, 8.8391916857E-01],
	[2.6465000000E+04, 1.7080766782E+01, 5.1902303197E+00, 4.1963870080E+00, 2.0428371061E+00, 8.8397442643E-01],
	[2.6470000000E+04, 1.7085934663E+01, 5.1901889110E+00, 4.1989472108E+00, 2.0435111652E+00, 8.8402965834E-01],
	[2.6475000000E+04, 1.7091103131E+01, 5.1901475105E+00, 4.2015084908E+00, 2.0441851492E+00, 8.8408486430E-01],
	[2.6480000000E+04, 1.7096272186E+01, 5.1901061180E+00, 4.2040708482E+00, 2.0448590580E+00, 8.8414004432E-01],
	[2.6485000000E+04, 1.7101441828E+01, 5.1900647338E+00, 4.2066342832E+00, 2.0455328914E+00, 8.8419519842E-01],
	[2.6490000000E+04, 1.7106612058E+01, 5.1900233577E+00, 4.2091987961E+00, 2.0462066493E+00, 8.8425032659E-01],
	[2.6495000000E+04, 1.7111782874E+01, 5.1899819897E+00, 4.2117643871E+00, 2.0468803317E+00, 8.8430542886E-01],
	[2.6500000000E+04, 1.7116954276E+01, 5.1899406299E+00, 4.2143310565E+00, 2.0475539385E+00, 8.8436050523E-01],
	[2.6505000000E+04, 1.7122126266E+01, 5.1898992781E+00, 4.2168988045E+00, 2.0482274696E+00, 8.8441555570E-01],
	[2.6510000000E+04, 1.7127298842E+01, 5.1898579346E+00, 4.2194676313E+00, 2.0489009250E+00, 8.8447058030E-01],
	[2.6515000000E+04, 1.7132472005E+01, 5.1898165991E+00, 4.2220375373E+00, 2.0495743045E+00, 8.8452557902E-01],
	[2.6520000000E+04, 1.7137645755E+01, 5.1897752718E+00, 4.2246085227E+00, 2.0502476080E+00, 8.8458055189E-01],
	[2.6525000000E+04, 1.7142820091E+01, 5.1897339526E+00, 4.2271805877E+00, 2.0509208355E+00, 8.8463549890E-01],
	[2.6530000000E+04, 1.7147995014E+01, 5.1896926415E+00, 4.2297537326E+00, 2.0515939869E+00, 8.8469042006E-01],
	[2.6535000000E+04, 1.7153170523E+01, 5.1896513385E+00, 4.2323279575E+00, 2.0522670620E+00, 8.8474531540E-01],
	[2.6540000000E+04, 1.7158346619E+01, 5.1896100436E+00, 4.2349032629E+00, 2.0529400609E+00, 8.8480018491E-01],
	[2.6545000000E+04, 1.7163523301E+01, 5.1895687569E+00, 4.2374796488E+00, 2.0536129834E+00, 8.8485502860E-01],
	[2.6550000000E+04, 1.7168700570E+01, 5.1895274782E+00, 4.2400571157E+00, 2.0542858295E+00, 8.8490984649E-01],
	[2.6555000000E+04, 1.7173878425E+01, 5.1894862076E+00, 4.2426356636E+00, 2.0549585990E+00, 8.8496463858E-01],
	[2.6560000000E+04, 1.7179056866E+01, 5.1894449452E+00, 4.2452152929E+00, 2.0556312919E+00, 8.8501940489E-01],
	[2.6565000000E+04, 1.7184235894E+01, 5.1894036908E+00, 4.2477960039E+00, 2.0563039081E+00, 8.8507414542E-01],
	[2.6570000000E+04, 1.7189415507E+01, 5.1893624445E+00, 4.2503777967E+00, 2.0569764475E+00, 8.8512886019E-01],
	[2.6575000000E+04, 1.7194595707E+01, 5.1893212064E+00, 4.2529606716E+00, 2.0576489100E+00, 8.8518354920E-01],
	[2.6580000000E+04, 1.7199776493E+01, 5.1892799763E+00, 4.2555446288E+00, 2.0583212956E+00, 8.8523821246E-01],
	[2.6585000000E+04, 1.7204957865E+01, 5.1892387543E+00, 4.2581296687E+00, 2.0589936041E+00, 8.8529284998E-01],
	[2.6590000000E+04, 1.7210139823E+01, 5.1891975403E+00, 4.2607157914E+00, 2.0596658355E+00, 8.8534746177E-01],
	[2.6595000000E+04, 1.7215322367E+01, 5.1891563345E+00, 4.2633029973E+00, 2.0603379897E+00, 8.8540204785E-01],
	[2.6600000000E+04, 1.7220505497E+01, 5.1891151367E+00, 4.2658912865E+00, 2.0610100666E+00, 8.8545660821E-01],
	[2.6605000000E+04, 1.7225689213E+01, 5.1890739470E+00, 4.2684806593E+00, 2.0616820661E+00, 8.8551114288E-01],
	[2.6610000000E+04, 1.7230873515E+01, 5.1890327653E+00, 4.2710711160E+00, 2.0623539882E+00, 8.8556565185E-01],
	[2.6615000000E+04, 1.7236058402E+01, 5.1889915917E+00, 4.2736626568E+00, 2.0630258327E+00, 8.8562013515E-01],
	[2.6620000000E+04, 1.7241243876E+01, 5.1889504262E+00, 4.2762552819E+00, 2.0636975995E+00, 8.8567459277E-01],
	[2.6625000000E+04, 1.7246429935E+01, 5.1889092687E+00, 4.2788489917E+00, 2.0643692887E+00, 8.8572902473E-01],
	[2.6630000000E+04, 1.7251616579E+01, 5.1888681193E+00, 4.2814437863E+00, 2.0650409001E+00, 8.8578343104E-01],
	[2.6635000000E+04, 1.7256803810E+01, 5.1888269780E+00, 4.2840396660E+00, 2.0657124336E+00, 8.8583781171E-01],
	[2.6640000000E+04, 1.7261991626E+01, 5.1887858447E+00, 4.2866366310E+00, 2.0663838891E+00, 8.8589216674E-01],
	[2.6645000000E+04, 1.7267180027E+01, 5.1887447194E+00, 4.2892346817E+00, 2.0670552666E+00, 8.8594649615E-01],
	[2.6650000000E+04, 1.7272369014E+01, 5.1887036022E+00, 4.2918338182E+00, 2.0677265659E+00, 8.8600079995E-01],
	[2.6655000000E+04, 1.7277558587E+01, 5.1886624930E+00, 4.2944340408E+00, 2.0683977871E+00, 8.8605507815E-01],
	[2.6660000000E+04, 1.7282748745E+01, 5.1886213918E+00, 4.2970353498E+00, 2.0690689300E+00, 8.8610933075E-01],
	[2.6665000000E+04, 1.7287939488E+01, 5.1885802987E+00, 4.2996377454E+00, 2.0697399945E+00, 8.8616355776E-01],
	[2.6670000000E+04, 1.7293130816E+01, 5.1885392136E+00, 4.3022412278E+00, 2.0704109805E+00, 8.8621775920E-01],
	[2.6675000000E+04, 1.7298322730E+01, 5.1884981366E+00, 4.3048457973E+00, 2.0710818880E+00, 8.8627193508E-01],
	[2.6680000000E+04, 1.7303515229E+01, 5.1884570675E+00, 4.3074514542E+00, 2.0717527169E+00, 8.8632608540E-01],
	[2.6685000000E+04, 1.7308708314E+01, 5.1884160065E+00, 4.3100581987E+00, 2.0724234670E+00, 8.8638021017E-01],
	[2.6690000000E+04, 1.7313901983E+01, 5.1883749535E+00, 4.3126660310E+00, 2.0730941384E+00, 8.8643430941E-01],
	[2.6695000000E+04, 1.7319096238E+01, 5.1883339086E+00, 4.3152749515E+00, 2.0737647309E+00, 8.8648838312E-01],
	[2.6700000000E+04, 1.7324291077E+01, 5.1882928716E+00, 4.3178849602E+00, 2.0744352445E+00, 8.8654243132E-01],
	[2.6705000000E+04, 1.7329486502E+01, 5.1882518426E+00, 4.3204960576E+00, 2.0751056791E+00, 8.8659645400E-01],
	[2.6710000000E+04, 1.7334682512E+01, 5.1882108217E+00, 4.3231082438E+00, 2.0757760345E+00, 8.8665045119E-01],
	[2.6715000000E+04, 1.7339879106E+01, 5.1881698087E+00, 4.3257215191E+00, 2.0764463107E+00, 8.8670442290E-01],
	[2.6720000000E+04, 1.7345076286E+01, 5.1881288038E+00, 4.3283358838E+00, 2.0771165077E+00, 8.8675836912E-01],
	[2.6725000000E+04, 1.7350274050E+01, 5.1880878068E+00, 4.3309513380E+00, 2.0777866253E+00, 8.8681228988E-01],
	[2.6730000000E+04, 1.7355472399E+01, 5.1880468179E+00, 4.3335678822E+00, 2.0784566635E+00, 8.8686618517E-01],
	[2.6735000000E+04, 1.7360671333E+01, 5.1880058369E+00, 4.3361855164E+00, 2.0791266221E+00, 8.8692005502E-01],
	[2.6740000000E+04, 1.7365870851E+01, 5.1879648639E+00, 4.3388042409E+00, 2.0797965011E+00, 8.8697389943E-01],
	[2.6745000000E+04, 1.7371073832E+01, 5.1879243758E+00, 4.3414240560E+00, 2.0804664184E+00, 8.8702771841E-01],
	[2.6750000000E+04, 1.7376296462E+01, 5.1878870547E+00, 4.3440449620E+00, 2.0811370380E+00, 8.8708151197E-01],
	[2.6755000000E+04, 1.7381519687E+01, 5.1878497410E+00, 4.3466669591E+00, 2.0818075785E+00, 8.8713528012E-01],
	[2.6760000000E+04, 1.7386743504E+01, 5.1878124344E+00, 4.3492900475E+00, 2.0824780398E+00, 8.8718902287E-01],
	[2.6765000000E+04, 1.7391967916E+01, 5.1877751351E+00, 4.3519142275E+00, 2.0831484220E+00, 8.8724274023E-01],
	[2.6770000000E+04, 1.7397192921E+01, 5.1877378431E+00, 4.3545394994E+00, 2.0838187249E+00, 8.8729643221E-01],
	[2.6775000000E+04, 1.7402418519E+01, 5.1877005582E+00, 4.3571658633E+00, 2.0844889485E+00, 8.8735009881E-01],
	[2.6780000000E+04, 1.7407644711E+01, 5.1876632806E+00, 4.3597933196E+00, 2.0851590926E+00, 8.8740374006E-01],
	[2.6785000000E+04, 1.7412871497E+01, 5.1876260102E+00, 4.3624218685E+00, 2.0858291572E+00, 8.8745735595E-01],
	[2.6790000000E+04, 1.7418098875E+01, 5.1875887471E+00, 4.3650515102E+00, 2.0864991421E+00, 8.8751094651E-01],
	[2.6795000000E+04, 1.7423326847E+01, 5.1875514911E+00, 4.3676822450E+00, 2.0871690474E+00, 8.8756451173E-01],
	[2.6800000000E+04, 1.7428555412E+01, 5.1875142424E+00, 4.3703140732E+00, 2.0878388730E+00, 8.8761805163E-01],
	[2.6805000000E+04, 1.7433784571E+01, 5.1874770009E+00, 4.3729469949E+00, 2.0885086187E+00, 8.8767156621E-01],
	[2.6810000000E+04, 1.7439014322E+01, 5.1874397667E+00, 4.3755810105E+00, 2.0891782845E+00, 8.8772505549E-01],
	[2.6815000000E+04, 1.7444244667E+01, 5.1874025396E+00, 4.3782161202E+00, 2.0898478703E+00, 8.8777851949E-01],
	[2.6820000000E+04, 1.7449475605E+01, 5.1873653197E+00, 4.3808523242E+00, 2.0905173760E+00, 8.8783195819E-01],
	[2.6825000000E+04, 1.7454707136E+01, 5.1873281071E+00, 4.3834896228E+00, 2.0911868015E+00, 8.8788537163E-01],
	[2.6830000000E+04, 1.7459939259E+01, 5.1872909016E+00, 4.3861280163E+00, 2.0918561468E+00, 8.8793875980E-01],
	[2.6835000000E+04, 1.7465171976E+01, 5.1872537033E+00, 4.3887675048E+00, 2.0925254118E+00, 8.8799212272E-01],
	[2.6840000000E+04, 1.7470405286E+01, 5.1872165123E+00, 4.3914080887E+00, 2.0931945963E+00, 8.8804546039E-01],
	[2.6845000000E+04, 1.7475639188E+01, 5.1871793284E+00, 4.3940497682E+00, 2.0938637004E+00, 8.8809877283E-01],
	[2.6850000000E+04, 1.7480873684E+01, 5.1871421517E+00, 4.3966925435E+00, 2.0945327240E+00, 8.8815206005E-01],
	[2.6855000000E+04, 1.7486108772E+01, 5.1871049823E+00, 4.3993364149E+00, 2.0952016669E+00, 8.8820532205E-01],
	[2.6860000000E+04, 1.7491344453E+01, 5.1870678200E+00, 4.4019813826E+00, 2.0958705290E+00, 8.8825855885E-01],
	[2.6865000000E+04, 1.7496580726E+01, 5.1870306648E+00, 4.4046274469E+00, 2.0965393104E+00, 8.8831177045E-01],
	[2.6870000000E+04, 1.7501817593E+01, 5.1869935169E+00, 4.4072746081E+00, 2.0972080109E+00, 8.8836495687E-01],
	[2.6875000000E+04, 1.7507055051E+01, 5.1869563761E+00, 4.4099228663E+00, 2.0978766304E+00, 8.8841811811E-01],
	[2.6880000000E+04, 1.7512293103E+01, 5.1869192426E+00, 4.4125722219E+00, 2.0985451689E+00, 8.8847125419E-01],
	[2.6885000000E+04, 1.7517531747E+01, 5.1868821161E+00, 4.4152226751E+00, 2.0992136263E+00, 8.8852436511E-01],
	[2.6890000000E+04, 1.7522770983E+01, 5.1868449969E+00, 4.4178742261E+00, 2.0998820025E+00, 8.8857745089E-01],
	[2.6895000000E+04, 1.7528010812E+01, 5.1868078848E+00, 4.4205268752E+00, 2.1005502974E+00, 8.8863051153E-01],
	[2.6900000000E+04, 1.7533251233E+01, 5.1867707799E+00, 4.4231806226E+00, 2.1012185110E+00, 8.8868354704E-01],
	[2.6905000000E+04, 1.7538492247E+01, 5.1867336822E+00, 4.4258354687E+00, 2.1018866431E+00, 8.8873655744E-01],
	[2.6910000000E+04, 1.7543733853E+01, 5.1866965916E+00, 4.4284914135E+00, 2.1025546937E+00, 8.8878954274E-01],
	[2.6915000000E+04, 1.7548976051E+01, 5.1866595081E+00, 4.4311484575E+00, 2.1032226628E+00, 8.8884250294E-01],
	[2.6920000000E+04, 1.7554218841E+01, 5.1866224319E+00, 4.4338066008E+00, 2.1038905501E+00, 8.8889543805E-01],
	[2.6925000000E+04, 1.7559462224E+01, 5.1865853627E+00, 4.4364658436E+00, 2.1045583558E+00, 8.8894834809E-01],
	[2.6930000000E+04, 1.7564706198E+01, 5.1865483008E+00, 4.4391261864E+00, 2.1052260796E+00, 8.8900123306E-01],
	[2.6935000000E+04, 1.7569950765E+01, 5.1865112459E+00, 4.4417876292E+00, 2.1058937214E+00, 8.8905409297E-01],
	[2.6940000000E+04, 1.7575195924E+01, 5.1864741982E+00, 4.4444501723E+00, 2.1065612814E+00, 8.8910692784E-01],
	[2.6945000000E+04, 1.7580441675E+01, 5.1864371577E+00, 4.4471138160E+00, 2.1072287592E+00, 8.8915973767E-01],
	[2.6950000000E+04, 1.7585688017E+01, 5.1864001243E+00, 4.4497785606E+00, 2.1078961549E+00, 8.8921252247E-01],
	[2.6955000000E+04, 1.7590934952E+01, 5.1863630980E+00, 4.4524444063E+00, 2.1085634684E+00, 8.8926528226E-01],
	[2.6960000000E+04, 1.7596182479E+01, 5.1863260788E+00, 4.4551113532E+00, 2.1092306997E+00, 8.8931801704E-01],
	[2.6965000000E+04, 1.7601430597E+01, 5.1862890668E+00, 4.4577794018E+00, 2.1098978485E+00, 8.8937072682E-01],
	[2.6970000000E+04, 1.7606679307E+01, 5.1862520619E+00, 4.4604485522E+00, 2.1105649149E+00, 8.8942341161E-01],
	[2.6975000000E+04, 1.7611928609E+01, 5.1862150641E+00, 4.4631188048E+00, 2.1112318988E+00, 8.8947607143E-01],
	[2.6980000000E+04, 1.7617178503E+01, 5.1861780735E+00, 4.4657901596E+00, 2.1118988000E+00, 8.8952870629E-01],
	[2.6985000000E+04, 1.7622428988E+01, 5.1861410900E+00, 4.4684626170E+00, 2.1125656186E+00, 8.8958131618E-01],
	[2.6990000000E+04, 1.7627680065E+01, 5.1861041135E+00, 4.4711361773E+00, 2.1132323545E+00, 8.8963390113E-01],
	[2.6995000000E+04, 1.7632931733E+01, 5.1860671442E+00, 4.4738108407E+00, 2.1138990075E+00, 8.8968646114E-01],
	[2.7000000000E+04, 1.7638183993E+01, 5.1860301820E+00, 4.4764866074E+00, 2.1145655775E+00, 8.8973899622E-01],
	[2.7005000000E+04, 1.7643436845E+01, 5.1859932270E+00, 4.4791634777E+00, 2.1152320646E+00, 8.8979150638E-01],
	[2.7010000000E+04, 1.7648690288E+01, 5.1859562790E+00, 4.4818414518E+00, 2.1158984687E+00, 8.8984399164E-01],
	[2.7015000000E+04, 1.7653944322E+01, 5.1859193381E+00, 4.4845205300E+00, 2.1165647895E+00, 8.8989645200E-01],
	[2.7020000000E+04, 1.7659198948E+01, 5.1858824043E+00, 4.4872007126E+00, 2.1172310272E+00, 8.8994888747E-01],
	[2.7025000000E+04, 1.7664454165E+01, 5.1858454776E+00, 4.4898819997E+00, 2.1178971816E+00, 8.9000129807E-01],
	[2.7030000000E+04, 1.7669709973E+01, 5.1858085580E+00, 4.4925643917E+00, 2.1185632526E+00, 8.9005368380E-01],
	[2.7035000000E+04, 1.7674966372E+01, 5.1857716455E+00, 4.4952478888E+00, 2.1192292401E+00, 8.9010604467E-01],
	[2.7040000000E+04, 1.7680223363E+01, 5.1857347401E+00, 4.4979324912E+00, 2.1198951441E+00, 8.9015838069E-01],
	[2.7045000000E+04, 1.7685480945E+01, 5.1856978418E+00, 4.5006181992E+00, 2.1205609645E+00, 8.9021069187E-01],
	[2.7050000000E+04, 1.7690739118E+01, 5.1856609506E+00, 4.5033050131E+00, 2.1212267012E+00, 8.9026297823E-01],
	[2.7055000000E+04, 1.7695997882E+01, 5.1856240664E+00, 4.5059929330E+00, 2.1218923542E+00, 8.9031523977E-01],
	[2.7060000000E+04, 1.7701257237E+01, 5.1855871893E+00, 4.5086819593E+00, 2.1225579234E+00, 8.9036747650E-01],
	[2.7065000000E+04, 1.7706517183E+01, 5.1855503193E+00, 4.5113720922E+00, 2.1232234086E+00, 8.9041968843E-01],
	[2.7070000000E+04, 1.7711777720E+01, 5.1855134564E+00, 4.5140633319E+00, 2.1238888098E+00, 8.9047187558E-01],
	[2.7075000000E+04, 1.7717038848E+01, 5.1854766006E+00, 4.5167556787E+00, 2.1245541270E+00, 8.9052403795E-01],
	[2.7080000000E+04, 1.7722300566E+01, 5.1854397518E+00, 4.5194491329E+00, 2.1252193601E+00, 8.9057617555E-01],
	[2.7085000000E+04, 1.7727562876E+01, 5.1854029100E+00, 4.5221436946E+00, 2.1258845089E+00, 8.9062828839E-01],
	[2.7090000000E+04, 1.7732825776E+01, 5.1853660754E+00, 4.5248393642E+00, 2.1265495734E+00, 8.9068037649E-01],
	[2.7095000000E+04, 1.7738089267E+01, 5.1853292478E+00, 4.5275361419E+00, 2.1272145536E+00, 8.9073243984E-01],
	[2.7100000000E+04, 1.7743353348E+01, 5.1852924272E+00, 4.5302340279E+00, 2.1278794494E+00, 8.9078447847E-01],
	[2.7105000000E+04, 1.7748618021E+01, 5.1852556137E+00, 4.5329330225E+00, 2.1285442606E+00, 8.9083649239E-01],
	[2.7110000000E+04, 1.7753883283E+01, 5.1852188073E+00, 4.5356331260E+00, 2.1292089872E+00, 8.9088848159E-01],
	[2.7115000000E+04, 1.7759149137E+01, 5.1851820079E+00, 4.5383343386E+00, 2.1298736292E+00, 8.9094044610E-01],
	[2.7120000000E+04, 1.7764415581E+01, 5.1851452155E+00, 4.5410366605E+00, 2.1305381864E+00, 8.9099238592E-01],
	[2.7125000000E+04, 1.7769682615E+01, 5.1851084302E+00, 4.5437400920E+00, 2.1312026588E+00, 8.9104430106E-01],
	[2.7130000000E+04, 1.7774950240E+01, 5.1850716520E+00, 4.5464446333E+00, 2.1318670463E+00, 8.9109619154E-01],
	[2.7135000000E+04, 1.7780218455E+01, 5.1850348807E+00, 4.5491502848E+00, 2.1325313488E+00, 8.9114805736E-01],
	[2.7140000000E+04, 1.7785487260E+01, 5.1849981165E+00, 4.5518570466E+00, 2.1331955663E+00, 8.9119989853E-01],
	[2.7145000000E+04, 1.7790756656E+01, 5.1849613594E+00, 4.5545649189E+00, 2.1338596987E+00, 8.9125171506E-01],
	[2.7150000000E+04, 1.7796026642E+01, 5.1849246093E+00, 4.5572739022E+00, 2.1345237459E+00, 8.9130350696E-01],
	[2.7155000000E+04, 1.7801297218E+01, 5.1848878662E+00, 4.5599839965E+00, 2.1351877078E+00, 8.9135527424E-01],
	[2.7160000000E+04, 1.7806568385E+01, 5.1848511301E+00, 4.5626952022E+00, 2.1358515844E+00, 8.9140701690E-01],
	[2.7165000000E+04, 1.7811840141E+01, 5.1848144010E+00, 4.5654075195E+00, 2.1365153756E+00, 8.9145873497E-01],
	[2.7170000000E+04, 1.7817112488E+01, 5.1847776790E+00, 4.5681209486E+00, 2.1371790813E+00, 8.9151042844E-01],
	[2.7175000000E+04, 1.7822385896E+01, 5.1847410413E+00, 4.5708354899E+00, 2.1378427213E+00, 8.9156209732E-01],
	[2.7180000000E+04, 1.7827681251E+01, 5.1847079055E+00, 4.5735511435E+00, 2.1385071776E+00, 8.9161374163E-01],
	[2.7185000000E+04, 1.7832977205E+01, 5.1846747761E+00, 4.5762679096E+00, 2.1391715490E+00, 8.9166536138E-01],
	[2.7190000000E+04, 1.7838273758E+01, 5.1846416530E+00, 4.5789857887E+00, 2.1398358354E+00, 8.9171695656E-01],
	[2.7195000000E+04, 1.7843570910E+01, 5.1846085362E+00, 4.5817047808E+00, 2.1405000367E+00, 8.9176852720E-01],
	[2.7200000000E+04, 1.7848868660E+01, 5.1845754256E+00, 4.5844248863E+00, 2.1411641529E+00, 8.9182007329E-01],
	[2.7205000000E+04, 1.7854167009E+01, 5.1845423214E+00, 4.5871461054E+00, 2.1418281839E+00, 8.9187159486E-01],
	[2.7210000000E+04, 1.7859465957E+01, 5.1845092235E+00, 4.5898684384E+00, 2.1424921296E+00, 8.9192309190E-01],
	[2.7215000000E+04, 1.7864765503E+01, 5.1844761318E+00, 4.5925918854E+00, 2.1431559899E+00, 8.9197456444E-01],
	[2.7220000000E+04, 1.7870065648E+01, 5.1844430465E+00, 4.5953164468E+00, 2.1438197648E+00, 8.9202601247E-01],
	[2.7225000000E+04, 1.7875366391E+01, 5.1844099674E+00, 4.5980421229E+00, 2.1444834541E+00, 8.9207743600E-01],
	[2.7230000000E+04, 1.7880667733E+01, 5.1843768946E+00, 4.6007689137E+00, 2.1451470579E+00, 8.9212883505E-01],
	[2.7235000000E+04, 1.7885969673E+01, 5.1843438281E+00, 4.6034968197E+00, 2.1458105761E+00, 8.9218020962E-01],
	[2.7240000000E+04, 1.7891272212E+01, 5.1843107679E+00, 4.6062258411E+00, 2.1464740085E+00, 8.9223155973E-01],
	[2.7245000000E+04, 1.7896575349E+01, 5.1842777140E+00, 4.6089559780E+00, 2.1471373551E+00, 8.9228288538E-01],
	[2.7250000000E+04, 1.7901879085E+01, 5.1842446663E+00, 4.6116872308E+00, 2.1478006158E+00, 8.9233418658E-01],
	[2.7255000000E+04, 1.7907183418E+01, 5.1842116250E+00, 4.6144195998E+00, 2.1484637906E+00, 8.9238546334E-01],
	[2.7260000000E+04, 1.7912488350E+01, 5.1841785898E+00, 4.6171530850E+00, 2.1491268793E+00, 8.9243671567E-01],
	[2.7265000000E+04, 1.7917793881E+01, 5.1841455610E+00, 4.6198876869E+00, 2.1497898820E+00, 8.9248794357E-01],
	[2.7270000000E+04, 1.7923100009E+01, 5.1841125384E+00, 4.6226234057E+00, 2.1504527985E+00, 8.9253914707E-01],
	[2.7275000000E+04, 1.7928406735E+01, 5.1840795221E+00, 4.6253602415E+00, 2.1511156287E+00, 8.9259032616E-01],
	[2.7280000000E+04, 1.7933714060E+01, 5.1840465121E+00, 4.6280981948E+00, 2.1517783726E+00, 8.9264148086E-01],
	[2.7285000000E+04, 1.7939021982E+01, 5.1840135083E+00, 4.6308372656E+00, 2.1524410302E+00, 8.9269261118E-01],
	[2.7290000000E+04, 1.7944330503E+01, 5.1839805107E+00, 4.6335774543E+00, 2.1531036012E+00, 8.9274371712E-01],
	[2.7295000000E+04, 1.7949639621E+01, 5.1839475195E+00, 4.6363187611E+00, 2.1537660858E+00, 8.9279479869E-01],
	[2.7300000000E+04, 1.7954949338E+01, 5.1839145344E+00, 4.6390611863E+00, 2.1544284837E+00, 8.9284585591E-01],
	[2.7305000000E+04, 1.7960259652E+01, 5.1838815557E+00, 4.6418047301E+00, 2.1550907950E+00, 8.9289688878E-01],
	[2.7310000000E+04, 1.7965570564E+01, 5.1838485831E+00, 4.6445493928E+00, 2.1557530194E+00, 8.9294789730E-01],
	[2.7315000000E+04, 1.7970882074E+01, 5.1838156169E+00, 4.6472951746E+00, 2.1564151571E+00, 8.9299888150E-01],
	[2.7320000000E+04, 1.7976194181E+01, 5.1837826568E+00, 4.6500420758E+00, 2.1570772079E+00, 8.9304984138E-01],
	[2.7325000000E+04, 1.7981506886E+01, 5.1837497030E+00, 4.6527900965E+00, 2.1577391717E+00, 8.9310077695E-01],
	[2.7330000000E+04, 1.7986820189E+01, 5.1837167555E+00, 4.6555392372E+00, 2.1584010485E+00, 8.9315168822E-01],
	[2.7335000000E+04, 1.7992134090E+01, 5.1836838142E+00, 4.6582894980E+00, 2.1590628381E+00, 8.9320257519E-01],
	[2.7340000000E+04, 1.7997448588E+01, 5.1836508791E+00, 4.6610408791E+00, 2.1597245406E+00, 8.9325343788E-01],
	[2.7345000000E+04, 1.8002763683E+01, 5.1836179502E+00, 4.6637933809E+00, 2.1603861558E+00, 8.9330427630E-01],
	[2.7350000000E+04, 1.8008079377E+01, 5.1835850276E+00, 4.6665470035E+00, 2.1610476837E+00, 8.9335509045E-01],
	[2.7355000000E+04, 1.8013395667E+01, 5.1835521112E+00, 4.6693017473E+00, 2.1617091242E+00, 8.9340588035E-01],
	[2.7360000000E+04, 1.8018712555E+01, 5.1835192010E+00, 4.6720576125E+00, 2.1623704772E+00, 8.9345664600E-01],
	[2.7365000000E+04, 1.8024030040E+01, 5.1834862971E+00, 4.6748145992E+00, 2.1630317426E+00, 8.9350738741E-01],
	[2.7370000000E+04, 1.8029348123E+01, 5.1834533993E+00, 4.6775727079E+00, 2.1636929205E+00, 8.9355810459E-01],
	[2.7375000000E+04, 1.8034666803E+01, 5.1834205078E+00, 4.6803319387E+00, 2.1643540107E+00, 8.9360879756E-01],
	[2.7380000000E+04, 1.8039986080E+01, 5.1833876225E+00, 4.6830922918E+00, 2.1650150131E+00, 8.9365946631E-01],
	[2.7385000000E+04, 1.8045305954E+01, 5.1833547435E+00, 4.6858537676E+00, 2.1656759276E+00, 8.9371011087E-01],
	[2.7390000000E+04, 1.8050626425E+01, 5.1833218706E+00, 4.6886169649E+00, 2.1663368821E+00, 8.9376073123E-01],
	[2.7395000000E+04, 1.8055947494E+01, 5.1832890039E+00, 4.6913814548E+00, 2.1669977846E+00, 8.9381132742E-01],
	[2.7400000000E+04, 1.8061269159E+01, 5.1832561435E+00, 4.6941470690E+00, 2.1676585991E+00, 8.9386189943E-01],
	[2.7405000000E+04, 1.8066591422E+01, 5.1832232892E+00, 4.6969138076E+00, 2.1683193254E+00, 8.9391244727E-01],
	[2.7410000000E+04, 1.8071914281E+01, 5.1831904412E+00, 4.6996816709E+00, 2.1689799636E+00, 8.9396297097E-01],
	[2.7415000000E+04, 1.8077237738E+01, 5.1831575993E+00, 4.7024506591E+00, 2.1696405134E+00, 8.9401347052E-01],
	[2.7420000000E+04, 1.8082561791E+01, 5.1831247637E+00, 4.7052207725E+00, 2.1703009750E+00, 8.9406394593E-01],
	[2.7425000000E+04, 1.8087886441E+01, 5.1830919342E+00, 4.7079920114E+00, 2.1709613481E+00, 8.9411439722E-01],
	[2.7430000000E+04, 1.8093211688E+01, 5.1830591109E+00, 4.7107643759E+00, 2.1716216327E+00, 8.9416482439E-01],
	[2.7435000000E+04, 1.8098537532E+01, 5.1830262939E+00, 4.7135378665E+00, 2.1722818288E+00, 8.9421522746E-01],
	[2.7440000000E+04, 1.8103863973E+01, 5.1829934830E+00, 4.7163124832E+00, 2.1729419363E+00, 8.9426560642E-01],
	[2.7445000000E+04, 1.8109191010E+01, 5.1829606783E+00, 4.7190882263E+00, 2.1736019550E+00, 8.9431596130E-01],
	[2.7450000000E+04, 1.8114518644E+01, 5.1829278798E+00, 4.7218650962E+00, 2.1742618850E+00, 8.9436629210E-01],
	[2.7455000000E+04, 1.8119846874E+01, 5.1828950874E+00, 4.7246430930E+00, 2.1749217262E+00, 8.9441659883E-01],
	[2.7460000000E+04, 1.8125175701E+01, 5.1828623013E+00, 4.7274222171E+00, 2.1755814784E+00, 8.9446688150E-01],
	[2.7465000000E+04, 1.8130505125E+01, 5.1828295213E+00, 4.7302024685E+00, 2.1762411417E+00, 8.9451714012E-01],
	[2.7470000000E+04, 1.8135835145E+01, 5.1827967475E+00, 4.7329838477E+00, 2.1769007160E+00, 8.9456737469E-01],
	[2.7475000000E+04, 1.8141165761E+01, 5.1827639798E+00, 4.7357663549E+00, 2.1775602011E+00, 8.9461758523E-01],
	[2.7480000000E+04, 1.8146496974E+01, 5.1827312184E+00, 4.7385499902E+00, 2.1782195970E+00, 8.9466777175E-01],
	[2.7485000000E+04, 1.8151828783E+01, 5.1826984631E+00, 4.7413347541E+00, 2.1788789037E+00, 8.9471793426E-01],
	[2.7490000000E+04, 1.8157161188E+01, 5.1826657139E+00, 4.7441206466E+00, 2.1795381210E+00, 8.9476807276E-01],
	[2.7495000000E+04, 1.8162494190E+01, 5.1826329710E+00, 4.7469076681E+00, 2.1801972490E+00, 8.9481818727E-01],
	[2.7500000000E+04, 1.8167827788E+01, 5.1826002342E+00, 4.7496958189E+00, 2.1808562875E+00, 8.9486827779E-01],
	[2.7505000000E+04, 1.8173161982E+01, 5.1825675035E+00, 4.7524850991E+00, 2.1815152365E+00, 8.9491834434E-01],
	[2.7510000000E+04, 1.8178496772E+01, 5.1825347790E+00, 4.7552755090E+00, 2.1821740958E+00, 8.9496838692E-01],
	[2.7515000000E+04, 1.8183832159E+01, 5.1825020607E+00, 4.7580670489E+00, 2.1828328655E+00, 8.9501840554E-01],
	[2.7520000000E+04, 1.8189168141E+01, 5.1824693485E+00, 4.7608597190E+00, 2.1834915455E+00, 8.9506840021E-01],
	[2.7525000000E+04, 1.8194504719E+01, 5.1824366425E+00, 4.7636535196E+00, 2.1841501356E+00, 8.9511837095E-01],
	[2.7530000000E+04, 1.8199841894E+01, 5.1824039426E+00, 4.7664484509E+00, 2.1848086359E+00, 8.9516831775E-01],
	[2.7535000000E+04, 1.8205179664E+01, 5.1823712488E+00, 4.7692445132E+00, 2.1854670462E+00, 8.9521824064E-01],
	[2.7540000000E+04, 1.8210518030E+01, 5.1823385612E+00, 4.7720417067E+00, 2.1861253665E+00, 8.9526813961E-01],
	[2.7545000000E+04, 1.8215856992E+01, 5.1823058797E+00, 4.7748400317E+00, 2.1867835967E+00, 8.9531801469E-01],
	[2.7550000000E+04, 1.8221196550E+01, 5.1822732044E+00, 4.7776394885E+00, 2.1874417367E+00, 8.9536786587E-01],
	[2.7555000000E+04, 1.8226536704E+01, 5.1822405352E+00, 4.7804400772E+00, 2.1880997866E+00, 8.9541769317E-01],
	[2.7560000000E+04, 1.8231877453E+01, 5.1822078722E+00, 4.7832417982E+00, 2.1887577461E+00, 8.9546749660E-01],
	[2.7565000000E+04, 1.8237218798E+01, 5.1821752152E+00, 4.7860446517E+00, 2.1894156153E+00, 8.9551727617E-01],
	[2.7570000000E+04, 1.8242560739E+01, 5.1821425644E+00, 4.7888486379E+00, 2.1900733940E+00, 8.9556703188E-01],
	[2.7575000000E+04, 1.8247903275E+01, 5.1821099198E+00, 4.7916537571E+00, 2.1907310823E+00, 8.9561676374E-01],
	[2.7580000000E+04, 1.8253246407E+01, 5.1820772812E+00, 4.7944600095E+00, 2.1913886799E+00, 8.9566647178E-01],
	[2.7585000000E+04, 1.8258590134E+01, 5.1820446488E+00, 4.7972673954E+00, 2.1920461870E+00, 8.9571615598E-01],
	[2.7590000000E+04, 1.8263934457E+01, 5.1820120225E+00, 4.8000759151E+00, 2.1927036033E+00, 8.9576581638E-01],
	[2.7595000000E+04, 1.8269279375E+01, 5.1819794023E+00, 4.8028855688E+00, 2.1933609289E+00, 8.9581545296E-01],
	[2.7600000000E+04, 1.8274624889E+01, 5.1819467882E+00, 4.8056963567E+00, 2.1940181636E+00, 8.9586506575E-01],
	[2.7605000000E+04, 1.8279970998E+01, 5.1819141803E+00, 4.8085082792E+00, 2.1946753074E+00, 8.9591465475E-01],
	[2.7610000000E+04, 1.8285317702E+01, 5.1818815784E+00, 4.8113213364E+00, 2.1953323603E+00, 8.9596421997E-01],
	[2.7615000000E+04, 1.8290676419E+01, 5.1818508285E+00, 4.8141355286E+00, 2.1959898182E+00, 8.9601376142E-01],
	[2.7620000000E+04, 1.8296046031E+01, 5.1818217483E+00, 4.8169508560E+00, 2.1966476328E+00, 8.9606327912E-01],
	[2.7625000000E+04, 1.8301416248E+01, 5.1817926735E+00, 4.8197673190E+00, 2.1973053570E+00, 8.9611277306E-01],
	[2.7630000000E+04, 1.8306787068E+01, 5.1817636042E+00, 4.8225849177E+00, 2.1979629907E+00, 8.9616224327E-01],
	[2.7635000000E+04, 1.8312158492E+01, 5.1817345402E+00, 4.8254036525E+00, 2.1986205340E+00, 8.9621168974E-01],
	[2.7640000000E+04, 1.8317530520E+01, 5.1817054817E+00, 4.8282235235E+00, 2.1992779866E+00, 8.9626111250E-01],
	[2.7645000000E+04, 1.8322903152E+01, 5.1816764286E+00, 4.8310445310E+00, 2.1999353485E+00, 8.9631051154E-01],
	[2.7650000000E+04, 1.8328276388E+01, 5.1816473810E+00, 4.8338666753E+00, 2.2005926198E+00, 8.9635988688E-01],
	[2.7655000000E+04, 1.8333650227E+01, 5.1816183387E+00, 4.8366899566E+00, 2.2012498002E+00, 8.9640923853E-01],
	[2.7660000000E+04, 1.8339024670E+01, 5.1815893019E+00, 4.8395143752E+00, 2.2019068897E+00, 8.9645856649E-01],
	[2.7665000000E+04, 1.8344399717E+01, 5.1815602704E+00, 4.8423399313E+00, 2.2025638884E+00, 8.9650787078E-01],
	[2.7670000000E+04, 1.8349775367E+01, 5.1815312444E+00, 4.8451666252E+00, 2.2032207960E+00, 8.9655715141E-01],
	[2.7675000000E+04, 1.8355151621E+01, 5.1815022238E+00, 4.8479944572E+00, 2.2038776125E+00, 8.9660640838E-01],
	[2.7680000000E+04, 1.8360528478E+01, 5.1814732086E+00, 4.8508234274E+00, 2.2045343380E+00, 8.9665564171E-01],
	[2.7685000000E+04, 1.8365905939E+01, 5.1814441988E+00, 4.8536535361E+00, 2.2051909722E+00, 8.9670485140E-01],
	[2.7690000000E+04, 1.8371284003E+01, 5.1814151944E+00, 4.8564847836E+00, 2.2058475151E+00, 8.9675403747E-01],
	[2.7695000000E+04, 1.8376662671E+01, 5.1813861954E+00, 4.8593171702E+00, 2.2065039667E+00, 8.9680319992E-01],
	[2.7700000000E+04, 1.8382041942E+01, 5.1813572018E+00, 4.8621506960E+00, 2.2071603269E+00, 8.9685233876E-01],
	[2.7705000000E+04, 1.8387421816E+01, 5.1813282135E+00, 4.8649853614E+00, 2.2078165957E+00, 8.9690145401E-01],
	[2.7710000000E+04, 1.8392802293E+01, 5.1812992307E+00, 4.8678211666E+00, 2.2084727729E+00, 8.9695054567E-01],
	[2.7715000000E+04, 1.8398183374E+01, 5.1812702533E+00, 4.8706581118E+00, 2.2091288585E+00, 8.9699961375E-01],
	[2.7720000000E+04, 1.8403565058E+01, 5.1812412812E+00, 4.8734961974E+00, 2.2097848524E+00, 8.9704865826E-01],
	[2.7725000000E+04, 1.8408947345E+01, 5.1812123146E+00, 4.8763354234E+00, 2.2104407546E+00, 8.9709767921E-01],
	[2.7730000000E+04, 1.8414330235E+01, 5.1811833533E+00, 4.8791757903E+00, 2.2110965650E+00, 8.9714667662E-01],
	[2.7735000000E+04, 1.8419713729E+01, 5.1811543974E+00, 4.8820172982E+00, 2.2117522835E+00, 8.9719565048E-01],
	[2.7740000000E+04, 1.8425097825E+01, 5.1811254469E+00, 4.8848599475E+00, 2.2124079101E+00, 8.9724460082E-01],
	[2.7745000000E+04, 1.8430482524E+01, 5.1810965018E+00, 4.8877037383E+00, 2.2130634447E+00, 8.9729352763E-01],
	[2.7750000000E+04, 1.8435867826E+01, 5.1810675621E+00, 4.8905486709E+00, 2.2137188872E+00, 8.9734243093E-01],
	[2.7755000000E+04, 1.8441253731E+01, 5.1810386277E+00, 4.8933947455E+00, 2.2143742376E+00, 8.9739131074E-01],
	[2.7760000000E+04, 1.8446640239E+01, 5.1810096987E+00, 4.8962419625E+00, 2.2150294958E+00, 8.9744016704E-01],
	[2.7765000000E+04, 1.8452027350E+01, 5.1809807751E+00, 4.8990903220E+00, 2.2156846618E+00, 8.9748899987E-01],
	[2.7770000000E+04, 1.8457415064E+01, 5.1809518568E+00, 4.9019398244E+00, 2.2163397354E+00, 8.9753780923E-01],
	[2.7775000000E+04, 1.8462803380E+01, 5.1809229439E+00, 4.9047904698E+00, 2.2169947166E+00, 8.9758659512E-01],
	[2.7780000000E+04, 1.8468192299E+01, 5.1808940364E+00, 4.9076422585E+00, 2.2176496054E+00, 8.9763535756E-01],
	[2.7785000000E+04, 1.8473581821E+01, 5.1808651343E+00, 4.9104951909E+00, 2.2183044016E+00, 8.9768409655E-01],
	[2.7790000000E+04, 1.8478971945E+01, 5.1808362375E+00, 4.9133492670E+00, 2.2189591052E+00, 8.9773281211E-01],
	[2.7795000000E+04, 1.8484362672E+01, 5.1808073460E+00, 4.9162044872E+00, 2.2196137162E+00, 8.9778150425E-01],
	[2.7800000000E+04, 1.8489754001E+01, 5.1807784599E+00, 4.9190608518E+00, 2.2202682345E+00, 8.9783017297E-01],
	[2.7805000000E+04, 1.8495145933E+01, 5.1807495792E+00, 4.9219183609E+00, 2.2209226600E+00, 8.9787881828E-01],
	[2.7810000000E+04, 1.8500538467E+01, 5.1807207038E+00, 4.9247770149E+00, 2.2215769927E+00, 8.9792744020E-01],
	[2.7815000000E+04, 1.8505931604E+01, 5.1806918338E+00, 4.9276368139E+00, 2.2222312324E+00, 8.9797603874E-01],
	[2.7820000000E+04, 1.8511325343E+01, 5.1806629692E+00, 4.9304977583E+00, 2.2228853791E+00, 8.9802461389E-01],
	[2.7825000000E+04, 1.8516719684E+01, 5.1806341098E+00, 4.9333598483E+00, 2.2235394329E+00, 8.9807316568E-01],
	[2.7830000000E+04, 1.8522114628E+01, 5.1806052559E+00, 4.9362230841E+00, 2.2241933935E+00, 8.9812169412E-01],
	[2.7835000000E+04, 1.8527510174E+01, 5.1805764072E+00, 4.9390874661E+00, 2.2248472609E+00, 8.9817019920E-01],
	[2.7840000000E+04, 1.8532906322E+01, 5.1805475640E+00, 4.9419529943E+00, 2.2255010351E+00, 8.9821868095E-01],
	[2.7845000000E+04, 1.8538303072E+01, 5.1805187260E+00, 4.9448196692E+00, 2.2261547160E+00, 8.9826713937E-01],
	[2.7850000000E+04, 1.8543700424E+01, 5.1804898934E+00, 4.9476874909E+00, 2.2268083035E+00, 8.9831557447E-01],
	[2.7855000000E+04, 1.8549098379E+01, 5.1804610661E+00, 4.9505564598E+00, 2.2274617976E+00, 8.9836398627E-01],
	[2.7860000000E+04, 1.8554496935E+01, 5.1804322442E+00, 4.9534265760E+00, 2.2281151982E+00, 8.9841237476E-01],
	[2.7865000000E+04, 1.8559896094E+01, 5.1804034276E+00, 4.9562978397E+00, 2.2287685052E+00, 8.9846073996E-01],
	[2.7870000000E+04, 1.8565295854E+01, 5.1803746163E+00, 4.9591702514E+00, 2.2294217186E+00, 8.9850908189E-01],
	[2.7875000000E+04, 1.8570696217E+01, 5.1803458104E+00, 4.9620438112E+00, 2.2300748384E+00, 8.9855740054E-01],
	[2.7880000000E+04, 1.8576097181E+01, 5.1803170097E+00, 4.9649185193E+00, 2.2307278644E+00, 8.9860569593E-01],
	[2.7885000000E+04, 1.8581498747E+01, 5.1802882145E+00, 4.9677943761E+00, 2.2313807965E+00, 8.9865396807E-01],
	[2.7890000000E+04, 1.8586900915E+01, 5.1802594245E+00, 4.9706713817E+00, 2.2320336348E+00, 8.9870221697E-01],
	[2.7895000000E+04, 1.8592303684E+01, 5.1802306398E+00, 4.9735495364E+00, 2.2326863792E+00, 8.9875044264E-01],
	[2.7900000000E+04, 1.8597707055E+01, 5.1802018605E+00, 4.9764288406E+00, 2.2333390295E+00, 8.9879864509E-01],
	[2.7905000000E+04, 1.8603111028E+01, 5.1801730865E+00, 4.9793092943E+00, 2.2339915858E+00, 8.9884682433E-01],
	[2.7910000000E+04, 1.8608515603E+01, 5.1801443178E+00, 4.9821908979E+00, 2.2346440479E+00, 8.9889498036E-01],
	[2.7915000000E+04, 1.8613920779E+01, 5.1801155544E+00, 4.9850736517E+00, 2.2352964159E+00, 8.9894311320E-01],
	[2.7920000000E+04, 1.8619326557E+01, 5.1800867963E+00, 4.9879575559E+00, 2.2359486895E+00, 8.9899122286E-01],
	[2.7925000000E+04, 1.8624732936E+01, 5.1800580436E+00, 4.9908426106E+00, 2.2366008689E+00, 8.9903930934E-01],
	[2.7930000000E+04, 1.8630139917E+01, 5.1800292961E+00, 4.9937288163E+00, 2.2372529539E+00, 8.9908737266E-01],
	[2.7935000000E+04, 1.8635547499E+01, 5.1800005539E+00, 4.9966161731E+00, 2.2379049444E+00, 8.9913541283E-01],
	[2.7940000000E+04, 1.8640955682E+01, 5.1799718171E+00, 4.9995046814E+00, 2.2385568404E+00, 8.9918342985E-01],
	[2.7945000000E+04, 1.8646364467E+01, 5.1799430855E+00, 5.0023943412E+00, 2.2392086419E+00, 8.9923142374E-01],
	[2.7950000000E+04, 1.8651773853E+01, 5.1799143593E+00, 5.0052851530E+00, 2.2398603487E+00, 8.9927939450E-01],
	[2.7955000000E+04, 1.8657183841E+01, 5.1798856383E+00, 5.0081771169E+00, 2.2405119608E+00, 8.9932734215E-01],
	[2.7960000000E+04, 1.8662594429E+01, 5.1798569227E+00, 5.0110702332E+00, 2.2411634782E+00, 8.9937526669E-01],
	[2.7965000000E+04, 1.8668005619E+01, 5.1798282123E+00, 5.0139645022E+00, 2.2418149007E+00, 8.9942316813E-01],
	[2.7970000000E+04, 1.8673417410E+01, 5.1797995073E+00, 5.0168599241E+00, 2.2424662283E+00, 8.9947104649E-01],
	[2.7975000000E+04, 1.8678829802E+01, 5.1797708075E+00, 5.0197564991E+00, 2.2431174610E+00, 8.9951890178E-01],
	[2.7980000000E+04, 1.8684242795E+01, 5.1797421130E+00, 5.0226542276E+00, 2.2437685987E+00, 8.9956673400E-01],
	[2.7985000000E+04, 1.8689656389E+01, 5.1797134238E+00, 5.0255531097E+00, 2.2444196413E+00, 8.9961454316E-01],
	[2.7990000000E+04, 1.8695070585E+01, 5.1796847399E+00, 5.0284531457E+00, 2.2450705887E+00, 8.9966232927E-01],
	[2.7995000000E+04, 1.8700485381E+01, 5.1796560612E+00, 5.0313543360E+00, 2.2457214410E+00, 8.9971009235E-01],
	[2.8000000000E+04, 1.8705900777E+01, 5.1796273879E+00, 5.0342566806E+00, 2.2463721980E+00, 8.9975783240E-01],
	[2.8005000000E+04, 1.8711316775E+01, 5.1795987198E+00, 5.0371601799E+00, 2.2470228597E+00, 8.9980554943E-01],
	[2.8010000000E+04, 1.8716733374E+01, 5.1795700570E+00, 5.0400648342E+00, 2.2476734260E+00, 8.9985324345E-01],
	[2.8015000000E+04, 1.8722150573E+01, 5.1795413994E+00, 5.0429706436E+00, 2.2483238968E+00, 8.9990091448E-01],
	[2.8020000000E+04, 1.8727568373E+01, 5.1795127472E+00, 5.0458776085E+00, 2.2489742721E+00, 8.9994856251E-01],
	[2.8025000000E+04, 1.8732986774E+01, 5.1794841002E+00, 5.0487857290E+00, 2.2496245519E+00, 8.9999618757E-01],
	[2.8030000000E+04, 1.8738405775E+01, 5.1794554585E+00, 5.0516950055E+00, 2.2502747360E+00, 9.0004378966E-01],
	[2.8035000000E+04, 1.8743825377E+01, 5.1794268220E+00, 5.0546054382E+00, 2.2509248245E+00, 9.0009136879E-01],
	[2.8040000000E+04, 1.8749245580E+01, 5.1793981908E+00, 5.0575170274E+00, 2.2515748172E+00, 9.0013892497E-01],
	[2.8045000000E+04, 1.8754666383E+01, 5.1793695649E+00, 5.0604297732E+00, 2.2522247140E+00, 9.0018645821E-01],
	[2.8050000000E+04, 1.8760087787E+01, 5.1793409443E+00, 5.0633436760E+00, 2.2528745150E+00, 9.0023396852E-01],
	[2.8055000000E+04, 1.8765509791E+01, 5.1793123289E+00, 5.0662587360E+00, 2.2535242201E+00, 9.0028145591E-01],
	[2.8060000000E+04, 1.8770945817E+01, 5.1792858623E+00, 5.0691749534E+00, 2.2541744287E+00, 9.0032892039E-01],
	[2.8065000000E+04, 1.8776390623E+01, 5.1792607056E+00, 5.0720923286E+00, 2.2548249070E+00, 9.0037636196E-01],
	[2.8070000000E+04, 1.8781836038E+01, 5.1792355535E+00, 5.0750108617E+00, 2.2554752900E+00, 9.0042378065E-01],
	[2.8075000000E+04, 1.8787282062E+01, 5.1792104060E+00, 5.0779305530E+00, 2.2561255775E+00, 9.0047117646E-01],
	[2.8080000000E+04, 1.8792728694E+01, 5.1791852631E+00, 5.0808514028E+00, 2.2567757695E+00, 9.0051854939E-01],
	[2.8085000000E+04, 1.8798175936E+01, 5.1791601249E+00, 5.0837734113E+00, 2.2574258660E+00, 9.0056589947E-01],
	[2.8090000000E+04, 1.8803623786E+01, 5.1791349912E+00, 5.0866965788E+00, 2.2580758670E+00, 9.0061322669E-01],
	[2.8095000000E+04, 1.8809072245E+01, 5.1791098621E+00, 5.0896209055E+00, 2.2587257722E+00, 9.0066053107E-01],
	[2.8100000000E+04, 1.8814521313E+01, 5.1790847375E+00, 5.0925463917E+00, 2.2593755817E+00, 9.0070781262E-01],
	[2.8105000000E+04, 1.8819970990E+01, 5.1790596176E+00, 5.0954730376E+00, 2.2600252955E+00, 9.0075507134E-01],
	[2.8110000000E+04, 1.8825421275E+01, 5.1790345023E+00, 5.0984008435E+00, 2.2606749134E+00, 9.0080230726E-01],
	[2.8115000000E+04, 1.8830872169E+01, 5.1790093916E+00, 5.1013298097E+00, 2.2613244354E+00, 9.0084952037E-01],
	[2.8120000000E+04, 1.8836323671E+01, 5.1789842854E+00, 5.1042599363E+00, 2.2619738614E+00, 9.0089671068E-01],
	[2.8125000000E+04, 1.8841775782E+01, 5.1789591839E+00, 5.1071912237E+00, 2.2626231914E+00, 9.0094387822E-01],
	[2.8130000000E+04, 1.8847228501E+01, 5.1789340869E+00, 5.1101236721E+00, 2.2632724253E+00, 9.0099102298E-01],
	[2.8135000000E+04, 1.8852681829E+01, 5.1789089945E+00, 5.1130572817E+00, 2.2639215631E+00, 9.0103814497E-01],
	[2.8140000000E+04, 1.8858135765E+01, 5.1788839067E+00, 5.1159920528E+00, 2.2645706047E+00, 9.0108524422E-01],
	[2.8145000000E+04, 1.8863590310E+01, 5.1788588234E+00, 5.1189279857E+00, 2.2652195500E+00, 9.0113232071E-01],
	[2.8150000000E+04, 1.8869045463E+01, 5.1788337448E+00, 5.1218650805E+00, 2.2658683990E+00, 9.0117937448E-01],
	[2.8155000000E+04, 1.8874501224E+01, 5.1788086707E+00, 5.1248033377E+00, 2.2665171516E+00, 9.0122640552E-01],
	[2.8160000000E+04, 1.8879957594E+01, 5.1787836012E+00, 5.1277427573E+00, 2.2671658078E+00, 9.0127341384E-01],
	[2.8165000000E+04, 1.8885414572E+01, 5.1787585362E+00, 5.1306833397E+00, 2.2678143674E+00, 9.0132039949E-01],
	[2.8170000000E+04, 1.8890872158E+01, 5.1787334759E+00, 5.1336250852E+00, 2.2684628305E+00, 9.0136736249E-01],
	[2.8175000000E+04, 1.8896330352E+01, 5.1787084201E+00, 5.1365679939E+00, 2.2691111970E+00, 9.0141430284E-01],
	[2.8180000000E+04, 1.8901789154E+01, 5.1786833688E+00, 5.1395120661E+00, 2.2697594668E+00, 9.0146122055E-01],
	[2.8185000000E+04, 1.8907248564E+01, 5.1786583222E+00, 5.1424573021E+00, 2.2704076399E+00, 9.0150811564E-01],
	[2.8190000000E+04, 1.8912708582E+01, 5.1786332800E+00, 5.1454037021E+00, 2.2710557161E+00, 9.0155498811E-01],
	[2.8195000000E+04, 1.8918169208E+01, 5.1786082425E+00, 5.1483512664E+00, 2.2717036955E+00, 9.0160183796E-01],
	[2.8200000000E+04, 1.8923630443E+01, 5.1785832095E+00, 5.1512999953E+00, 2.2723515780E+00, 9.0164866522E-01],
	[2.8205000000E+04, 1.8929092285E+01, 5.1785581811E+00, 5.1542498889E+00, 2.2729993634E+00, 9.0169546987E-01],
	[2.8210000000E+04, 1.8934554735E+01, 5.1785331572E+00, 5.1572009476E+00, 2.2736470519E+00, 9.0174225195E-01],
	[2.8215000000E+04, 1.8940017792E+01, 5.1785081379E+00, 5.1601531716E+00, 2.2742946432E+00, 9.0178901144E-01],
	[2.8220000000E+04, 1.8945481458E+01, 5.1784831232E+00, 5.1631065611E+00, 2.2749421374E+00, 9.0183574837E-01],
	[2.8225000000E+04, 1.8950945731E+01, 5.1784581130E+00, 5.1660611164E+00, 2.2755895344E+00, 9.0188246273E-01],
	[2.8230000000E+04, 1.8956410612E+01, 5.1784331073E+00, 5.1690168378E+00, 2.2762368341E+00, 9.0192915455E-01],
	[2.8235000000E+04, 1.8961876100E+01, 5.1784081062E+00, 5.1719737254E+00, 2.2768840365E+00, 9.0197582382E-01],
	[2.8240000000E+04, 1.8967342196E+01, 5.1783831097E+00, 5.1749317797E+00, 2.2775311415E+00, 9.0202247055E-01],
	[2.8245000000E+04, 1.8972808900E+01, 5.1783581177E+00, 5.1778910007E+00, 2.2781781490E+00, 9.0206909476E-01],
	[2.8250000000E+04, 1.8978276212E+01, 5.1783331302E+00, 5.1808513888E+00, 2.2788250590E+00, 9.0211569645E-01],
	[2.8255000000E+04, 1.8983744130E+01, 5.1783081473E+00, 5.1838129443E+00, 2.2794718715E+00, 9.0216227562E-01],
	[2.8260000000E+04, 1.8989212656E+01, 5.1782831689E+00, 5.1867756673E+00, 2.2801185863E+00, 9.0220883230E-01],
	[2.8265000000E+04, 1.8994681790E+01, 5.1782581951E+00, 5.1897395581E+00, 2.2807652035E+00, 9.0225536649E-01],
	[2.8270000000E+04, 1.9000151531E+01, 5.1782332258E+00, 5.1927046170E+00, 2.2814117229E+00, 9.0230187818E-01],
	[2.8275000000E+04, 1.9005621879E+01, 5.1782082610E+00, 5.1956708442E+00, 2.2820581445E+00, 9.0234836741E-01],
	[2.8280000000E+04, 1.9011092835E+01, 5.1781833008E+00, 5.1986382401E+00, 2.2827044682E+00, 9.0239483416E-01],
	[2.8285000000E+04, 1.9016564398E+01, 5.1781583451E+00, 5.2016068047E+00, 2.2833506941E+00, 9.0244127846E-01],
	[2.8290000000E+04, 1.9022036568E+01, 5.1781333939E+00, 5.2045765385E+00, 2.2839968219E+00, 9.0248770031E-01],
	[2.8295000000E+04, 1.9027509345E+01, 5.1781084473E+00, 5.2075474416E+00, 2.2846428517E+00, 9.0253409971E-01],
	[2.8300000000E+04, 1.9032982730E+01, 5.1780835051E+00, 5.2105195143E+00, 2.2852887835E+00, 9.0258047668E-01],
	[2.8305000000E+04, 1.9038456721E+01, 5.1780585676E+00, 5.2134927568E+00, 2.2859346171E+00, 9.0262683122E-01],
	[2.8310000000E+04, 1.9043931320E+01, 5.1780336345E+00, 5.2164671694E+00, 2.2865803524E+00, 9.0267316335E-01],
	[2.8315000000E+04, 1.9049406525E+01, 5.1780087060E+00, 5.2194427524E+00, 2.2872259896E+00, 9.0271947307E-01],
	[2.8320000000E+04, 1.9054882338E+01, 5.1779837819E+00, 5.2224195060E+00, 2.2878715284E+00, 9.0276576039E-01],
	[2.8325000000E+04, 1.9060358757E+01, 5.1779588625E+00, 5.2253974305E+00, 2.2885169688E+00, 9.0281202532E-01],
	[2.8330000000E+04, 1.9065835784E+01, 5.1779339475E+00, 5.2283765261E+00, 2.2891623108E+00, 9.0285826787E-01],
	[2.8335000000E+04, 1.9071313417E+01, 5.1779090370E+00, 5.2313567930E+00, 2.2898075543E+00, 9.0290448805E-01],
	[2.8340000000E+04, 1.9076791657E+01, 5.1778841311E+00, 5.2343382316E+00, 2.2904526992E+00, 9.0295068585E-01],
	[2.8345000000E+04, 1.9082270504E+01, 5.1778592296E+00, 5.2373208421E+00, 2.2910977456E+00, 9.0299686131E-01],
	[2.8350000000E+04, 1.9087749957E+01, 5.1778343327E+00, 5.2403046247E+00, 2.2917426932E+00, 9.0304301441E-01],
	[2.8355000000E+04, 1.9093230017E+01, 5.1778094403E+00, 5.2432895796E+00, 2.2923875422E+00, 9.0308914517E-01],
	[2.8360000000E+04, 1.9098710684E+01, 5.1777845524E+00, 5.2462757072E+00, 2.2930322924E+00, 9.0313525360E-01],
	[2.8365000000E+04, 1.9104191958E+01, 5.1777596690E+00, 5.2492630077E+00, 2.2936769437E+00, 9.0318133971E-01],
	[2.8370000000E+04, 1.9109673838E+01, 5.1777347901E+00, 5.2522514813E+00, 2.2943214961E+00, 9.0322740351E-01],
	[2.8375000000E+04, 1.9115156324E+01, 5.1777099158E+00, 5.2552411283E+00, 2.2949659497E+00, 9.0327344500E-01],
	[2.8380000000E+04, 1.9120639418E+01, 5.1776850459E+00, 5.2582319490E+00, 2.2956103042E+00, 9.0331946420E-01],
	[2.8385000000E+04, 1.9126123117E+01, 5.1776601805E+00, 5.2612239436E+00, 2.2962545596E+00, 9.0336546110E-01],
	[2.8390000000E+04, 1.9131607423E+01, 5.1776353196E+00, 5.2642171123E+00, 2.2968987159E+00, 9.0341143573E-01],
	[2.8395000000E+04, 1.9137092335E+01, 5.1776104632E+00, 5.2672114554E+00, 2.2975427731E+00, 9.0345738808E-01],
	[2.8400000000E+04, 1.9142577854E+01, 5.1775856113E+00, 5.2702069732E+00, 2.2981867310E+00, 9.0350331818E-01],
	[2.8405000000E+04, 1.9148063979E+01, 5.1775607640E+00, 5.2732036659E+00, 2.2988305896E+00, 9.0354922602E-01],
	[2.8410000000E+04, 1.9153550710E+01, 5.1775359211E+00, 5.2762015338E+00, 2.2994743489E+00, 9.0359511161E-01],
	[2.8415000000E+04, 1.9159038048E+01, 5.1775110826E+00, 5.2792005771E+00, 2.3001180088E+00, 9.0364097497E-01],
	[2.8420000000E+04, 1.9164525991E+01, 5.1774862487E+00, 5.2822007961E+00, 2.3007615692E+00, 9.0368681610E-01],
	[2.8425000000E+04, 1.9170014541E+01, 5.1774614193E+00, 5.2852021910E+00, 2.3014050301E+00, 9.0373263501E-01],
	[2.8430000000E+04, 1.9175503697E+01, 5.1774365943E+00, 5.2882047621E+00, 2.3020483915E+00, 9.0377843171E-01],
	[2.8435000000E+04, 1.9180993459E+01, 5.1774117739E+00, 5.2912085096E+00, 2.3026916532E+00, 9.0382420621E-01],
	[2.8440000000E+04, 1.9186483827E+01, 5.1773869579E+00, 5.2942134338E+00, 2.3033348153E+00, 9.0386995852E-01],
	[2.8445000000E+04, 1.9191974801E+01, 5.1773621464E+00, 5.2972195350E+00, 2.3039778776E+00, 9.0391568864E-01],
	[2.8450000000E+04, 1.9197466381E+01, 5.1773373394E+00, 5.3002268133E+00, 2.3046208401E+00, 9.0396139658E-01],
	[2.8455000000E+04, 1.9202958566E+01, 5.1773125368E+00, 5.3032352691E+00, 2.3052637028E+00, 9.0400708236E-01],
	[2.8460000000E+04, 1.9208451358E+01, 5.1772877388E+00, 5.3062449026E+00, 2.3059064656E+00, 9.0405274598E-01],
	[2.8465000000E+04, 1.9213944756E+01, 5.1772629452E+00, 5.3092557141E+00, 2.3065491284E+00, 9.0409838745E-01],
	[2.8470000000E+04, 1.9219438759E+01, 5.1772381561E+00, 5.3122677037E+00, 2.3071916912E+00, 9.0414400678E-01],
	[2.8475000000E+04, 1.9224933368E+01, 5.1772133714E+00, 5.3152808719E+00, 2.3078341540E+00, 9.0418960398E-01],
	[2.8480000000E+04, 1.9230428582E+01, 5.1771885913E+00, 5.3182952187E+00, 2.3084765166E+00, 9.0423517905E-01],
	[2.8485000000E+04, 1.9235924403E+01, 5.1771638156E+00, 5.3213107445E+00, 2.3091187790E+00, 9.0428073201E-01],
	[2.8490000000E+04, 1.9241420829E+01, 5.1771390443E+00, 5.3243274496E+00, 2.3097609413E+00, 9.0432626286E-01],
	[2.8495000000E+04, 1.9246917860E+01, 5.1771142776E+00, 5.3273453341E+00, 2.3104030032E+00, 9.0437177161E-01],
	[2.8500000000E+04, 1.9252415497E+01, 5.1770895152E+00, 5.3303643983E+00, 2.3110449648E+00, 9.0441725828E-01],
	[2.8505000000E+04, 1.9257913740E+01, 5.1770647574E+00, 5.3333846425E+00, 2.3116868260E+00, 9.0446272286E-01],
	[2.8510000000E+04, 1.9263418729E+01, 5.1770409733E+00, 5.3364060670E+00, 2.3123288686E+00, 9.0450816537E-01],
	[2.8515000000E+04, 1.9268939661E+01, 5.1770196128E+00, 5.3394286720E+00, 2.3129715148E+00, 9.0455358582E-01],
	[2.8520000000E+04, 1.9274461207E+01, 5.1769982562E+00, 5.3424524577E+00, 2.3136140611E+00, 9.0459898422E-01],
	[2.8525000000E+04, 1.9279983366E+01, 5.1769769035E+00, 5.3454774244E+00, 2.3142565077E+00, 9.0464436057E-01],
	[2.8530000000E+04, 1.9285506140E+01, 5.1769555545E+00, 5.3485035723E+00, 2.3148988543E+00, 9.0468971488E-01],
	[2.8535000000E+04, 1.9291029527E+01, 5.1769342094E+00, 5.3515309018E+00, 2.3155411009E+00, 9.0473504717E-01],
	[2.8540000000E+04, 1.9296553528E+01, 5.1769128681E+00, 5.3545594130E+00, 2.3161832475E+00, 9.0478035744E-01],
	[2.8545000000E+04, 1.9302078142E+01, 5.1768915307E+00, 5.3575891062E+00, 2.3168252940E+00, 9.0482564569E-01],
	[2.8550000000E+04, 1.9307603371E+01, 5.1768701970E+00, 5.3606199817E+00, 2.3174672404E+00, 9.0487091195E-01],
	[2.8555000000E+04, 1.9313129213E+01, 5.1768488672E+00, 5.3636520398E+00, 2.3181090865E+00, 9.0491615621E-01],
	[2.8560000000E+04, 1.9318655668E+01, 5.1768275412E+00, 5.3666852806E+00, 2.3187508325E+00, 9.0496137849E-01],
	[2.8565000000E+04, 1.9324182737E+01, 5.1768062191E+00, 5.3697197044E+00, 2.3193924781E+00, 9.0500657879E-01],
	[2.8570000000E+04, 1.9329710420E+01, 5.1767849007E+00, 5.3727553115E+00, 2.3200340234E+00, 9.0505175713E-01],
	[2.8575000000E+04, 1.9335238716E+01, 5.1767635862E+00, 5.3757921021E+00, 2.3206754683E+00, 9.0509691351E-01],
	[2.8580000000E+04, 1.9340767625E+01, 5.1767422755E+00, 5.3788300765E+00, 2.3213168127E+00, 9.0514204794E-01],
	[2.8585000000E+04, 1.9346297148E+01, 5.1767209686E+00, 5.3818692350E+00, 2.3219580566E+00, 9.0518716043E-01],
	[2.8590000000E+04, 1.9351827284E+01, 5.1766996655E+00, 5.3849095778E+00, 2.3225991999E+00, 9.0523225099E-01],
	[2.8595000000E+04, 1.9357358034E+01, 5.1766783662E+00, 5.3879511051E+00, 2.3232402426E+00, 9.0527731962E-01],
	[2.8600000000E+04, 1.9362889396E+01, 5.1766570708E+00, 5.3909938172E+00, 2.3238811847E+00, 9.0532236634E-01],
	[2.8605000000E+04, 1.9368421372E+01, 5.1766357791E+00, 5.3940377144E+00, 2.3245220260E+00, 9.0536739116E-01],
	[2.8610000000E+04, 1.9373953962E+01, 5.1766144913E+00, 5.3970827969E+00, 2.3251627665E+00, 9.0541239408E-01],
	[2.8615000000E+04, 1.9379487164E+01, 5.1765932072E+00, 5.4001290649E+00, 2.3258034062E+00, 9.0545737511E-01],
	[2.8620000000E+04, 1.9385020980E+01, 5.1765719270E+00, 5.4031765188E+00, 2.3264439450E+00, 9.0550233427E-01],
	[2.8625000000E+04, 1.9390555408E+01, 5.1765506506E+00, 5.4062251587E+00, 2.3270843828E+00, 9.0554727155E-01],
	[2.8630000000E+04, 1.9396090450E+01, 5.1765293780E+00, 5.4092749850E+00, 2.3277247197E+00, 9.0559218698E-01],
	[2.8635000000E+04, 1.9401626104E+01, 5.1765081092E+00, 5.4123259978E+00, 2.3283649555E+00, 9.0563708055E-01],
	[2.8640000000E+04, 1.9407162372E+01, 5.1764868442E+00, 5.4153781975E+00, 2.3290050902E+00, 9.0568195228E-01],
	[2.8645000000E+04, 1.9412699252E+01, 5.1764655829E+00, 5.4184315843E+00, 2.3296451237E+00, 9.0572680217E-01],
	[2.8650000000E+04, 1.9418236746E+01, 5.1764443255E+00, 5.4214861584E+00, 2.3302850561E+00, 9.0577163024E-01],
	[2.8655000000E+04, 1.9423774852E+01, 5.1764230719E+00, 5.4245419201E+00, 2.3309248871E+00, 9.0581643650E-01],
	[2.8660000000E+04, 1.9429313571E+01, 5.1764018221E+00, 5.4275988697E+00, 2.3315646169E+00, 9.0586122094E-01],
	[2.8665000000E+04, 1.9434852903E+01, 5.1763805761E+00, 5.4306570073E+00, 2.3322042453E+00, 9.0590598358E-01],
	[2.8670000000E+04, 1.9440392847E+01, 5.1763593338E+00, 5.4337163334E+00, 2.3328437723E+00, 9.0595072444E-01],
	[2.8675000000E+04, 1.9445933404E+01, 5.1763380954E+00, 5.4367768480E+00, 2.3334831978E+00, 9.0599544351E-01],
	[2.8680000000E+04, 1.9451474574E+01, 5.1763168607E+00, 5.4398385515E+00, 2.3341225217E+00, 9.0604014082E-01],
	[2.8685000000E+04, 1.9457016357E+01, 5.1762956298E+00, 5.4429014441E+00, 2.3347617441E+00, 9.0608481635E-01],
	[2.8690000000E+04, 1.9462558752E+01, 5.1762744028E+00, 5.4459655261E+00, 2.3354008649E+00, 9.0612947014E-01],
	[2.8695000000E+04, 1.9468101759E+01, 5.1762531795E+00, 5.4490307977E+00, 2.3360398840E+00, 9.0617410217E-01],
	[2.8700000000E+04, 1.9473645379E+01, 5.1762319600E+00, 5.4520972592E+00, 2.3366788013E+00, 9.0621871247E-01],
	[2.8705000000E+04, 1.9479189612E+01, 5.1762107442E+00, 5.4551649108E+00, 2.3373176169E+00, 9.0626330105E-01],
	[2.8710000000E+04, 1.9484734457E+01, 5.1761895323E+00, 5.4582337528E+00, 2.3379563306E+00, 9.0630786790E-01],
	[2.8715000000E+04, 1.9490279914E+01, 5.1761683241E+00, 5.4613037855E+00, 2.3385949425E+00, 9.0635241304E-01],
	[2.8720000000E+04, 1.9495825984E+01, 5.1761471198E+00, 5.4643750090E+00, 2.3392334524E+00, 9.0639693648E-01],
	[2.8725000000E+04, 1.9501372666E+01, 5.1761259191E+00, 5.4674474237E+00, 2.3398718603E+00, 9.0644143823E-01],
	[2.8730000000E+04, 1.9506919960E+01, 5.1761047223E+00, 5.4705210298E+00, 2.3405101661E+00, 9.0648591830E-01],
	[2.8735000000E+04, 1.9512467866E+01, 5.1760835293E+00, 5.4735958276E+00, 2.3411483699E+00, 9.0653037669E-01],
	[2.8740000000E+04, 1.9518016385E+01, 5.1760623400E+00, 5.4766718173E+00, 2.3417864715E+00, 9.0657481341E-01],
	[2.8745000000E+04, 1.9523565515E+01, 5.1760411545E+00, 5.4797489991E+00, 2.3424244709E+00, 9.0661922848E-01],
	[2.8750000000E+04, 1.9529115258E+01, 5.1760199728E+00, 5.4828273734E+00, 2.3430623681E+00, 9.0666362190E-01],
	[2.8755000000E+04, 1.9534665613E+01, 5.1759987948E+00, 5.4859069403E+00, 2.3437001629E+00, 9.0670799368E-01],
	[2.8760000000E+04, 1.9540216580E+01, 5.1759776206E+00, 5.4889877002E+00, 2.3443378554E+00, 9.0675234383E-01],
	[2.8765000000E+04, 1.9545768159E+01, 5.1759564502E+00, 5.4920696532E+00, 2.3449754455E+00, 9.0679667236E-01],
	[2.8770000000E+04, 1.9551320350E+01, 5.1759352835E+00, 5.4951527997E+00, 2.3456129332E+00, 9.0684097928E-01],
	[2.8775000000E+04, 1.9556873152E+01, 5.1759141206E+00, 5.4982371399E+00, 2.3462503183E+00, 9.0688526459E-01],
	[2.8780000000E+04, 1.9562426567E+01, 5.1758929615E+00, 5.5013226740E+00, 2.3468876009E+00, 9.0692952831E-01],
	[2.8785000000E+04, 1.9567980593E+01, 5.1758718061E+00, 5.5044094023E+00, 2.3475247808E+00, 9.0697377045E-01],
	[2.8790000000E+04, 1.9573535232E+01, 5.1758506545E+00, 5.5074973251E+00, 2.3481618581E+00, 9.0701799101E-01],
	[2.8795000000E+04, 1.9579090481E+01, 5.1758295066E+00, 5.5105864426E+00, 2.3487988327E+00, 9.0706219000E-01],
	[2.8800000000E+04, 1.9584646343E+01, 5.1758083625E+00, 5.5136767550E+00, 2.3494357045E+00, 9.0710636743E-01],
	[2.8805000000E+04, 1.9590202817E+01, 5.1757872222E+00, 5.5167682627E+00, 2.3500724736E+00, 9.0715052331E-01],
	[2.8810000000E+04, 1.9595759902E+01, 5.1757660856E+00, 5.5198609658E+00, 2.3507091397E+00, 9.0719465765E-01],
	[2.8815000000E+04, 1.9601317598E+01, 5.1757449528E+00, 5.5229548647E+00, 2.3513457029E+00, 9.0723877046E-01],
	[2.8820000000E+04, 1.9606875906E+01, 5.1757238237E+00, 5.5260499595E+00, 2.3519821632E+00, 9.0728286175E-01],
	[2.8825000000E+04, 1.9612434826E+01, 5.1757026984E+00, 5.5291462506E+00, 2.3526185204E+00, 9.0732693152E-01],
	[2.8830000000E+04, 1.9617994357E+01, 5.1756815768E+00, 5.5322437381E+00, 2.3532547746E+00, 9.0737097979E-01],
	[2.8835000000E+04, 1.9623554500E+01, 5.1756604590E+00, 5.5353424224E+00, 2.3538909257E+00, 9.0741500656E-01],
	[2.8840000000E+04, 1.9629115254E+01, 5.1756393449E+00, 5.5384423037E+00, 2.3545269736E+00, 9.0745901185E-01],
	[2.8845000000E+04, 1.9634676619E+01, 5.1756182346E+00, 5.5415433822E+00, 2.3551629183E+00, 9.0750299565E-01],
	[2.8850000000E+04, 1.9640238596E+01, 5.1755971280E+00, 5.5446456582E+00, 2.3557987597E+00, 9.0754695799E-01],
	[2.8855000000E+04, 1.9645801184E+01, 5.1755760252E+00, 5.5477491320E+00, 2.3564344978E+00, 9.0759089887E-01],
	[2.8860000000E+04, 1.9651364383E+01, 5.1755549261E+00, 5.5508538038E+00, 2.3570701325E+00, 9.0763481830E-01],
	[2.8865000000E+04, 1.9656928193E+01, 5.1755338307E+00, 5.5539596739E+00, 2.3577056638E+00, 9.0767871628E-01],
	[2.8870000000E+04, 1.9662492615E+01, 5.1755127391E+00, 5.5570667425E+00, 2.3583410916E+00, 9.0772259284E-01],
	[2.8875000000E+04, 1.9668057647E+01, 5.1754916513E+00, 5.5601750098E+00, 2.3589764160E+00, 9.0776644797E-01],
	[2.8880000000E+04, 1.9673623291E+01, 5.1754705671E+00, 5.5632844762E+00, 2.3596116367E+00, 9.0781028168E-01],
	[2.8885000000E+04, 1.9679189546E+01, 5.1754494867E+00, 5.5663951419E+00, 2.3602467539E+00, 9.0785409399E-01],
	[2.8890000000E+04, 1.9684756412E+01, 5.1754284100E+00, 5.5695070071E+00, 2.3608817674E+00, 9.0789788490E-01],
	[2.8895000000E+04, 1.9690323889E+01, 5.1754073371E+00, 5.5726200721E+00, 2.3615166771E+00, 9.0794165442E-01],
	[2.8900000000E+04, 1.9695891976E+01, 5.1753862679E+00, 5.5757343372E+00, 2.3621514831E+00, 9.0798540257E-01],
	[2.8905000000E+04, 1.9701460675E+01, 5.1753652024E+00, 5.5788498025E+00, 2.3627861853E+00, 9.0802912934E-01],
	[2.8910000000E+04, 1.9707029985E+01, 5.1753441407E+00, 5.5819664684E+00, 2.3634207836E+00, 9.0807283475E-01],
	[2.8915000000E+04, 1.9712599905E+01, 5.1753230827E+00, 5.5850843351E+00, 2.3640552780E+00, 9.0811651881E-01],
	[2.8920000000E+04, 1.9718170436E+01, 5.1753020284E+00, 5.5882034029E+00, 2.3646896685E+00, 9.0816018153E-01],
	[2.8925000000E+04, 1.9723741578E+01, 5.1752809778E+00, 5.5913236720E+00, 2.3653239549E+00, 9.0820382292E-01],
	[2.8930000000E+04, 1.9729313331E+01, 5.1752599310E+00, 5.5944451427E+00, 2.3659581373E+00, 9.0824744298E-01],
	[2.8935000000E+04, 1.9734885694E+01, 5.1752388878E+00, 5.5975678152E+00, 2.3665922156E+00, 9.0829104172E-01],
	[2.8940000000E+04, 1.9740458668E+01, 5.1752178485E+00, 5.6006916897E+00, 2.3672261897E+00, 9.0833461916E-01],
	[2.8945000000E+04, 1.9746032252E+01, 5.1751968128E+00, 5.6038167666E+00, 2.3678600596E+00, 9.0837817530E-01],
	[2.8950000000E+04, 1.9751606447E+01, 5.1751757808E+00, 5.6069430461E+00, 2.3684938252E+00, 9.0842171015E-01],
	[2.8955000000E+04, 1.9757181253E+01, 5.1751547526E+00, 5.6100705285E+00, 2.3691274866E+00, 9.0846522372E-01],
	[2.8960000000E+04, 1.9762756669E+01, 5.1751337281E+00, 5.6131992139E+00, 2.3697610436E+00, 9.0850871602E-01],
	[2.8965000000E+04, 1.9768332695E+01, 5.1751127072E+00, 5.6163291027E+00, 2.3703944962E+00, 9.0855218706E-01],
	[2.8970000000E+04, 1.9773919926E+01, 5.1750933425E+00, 5.6194601951E+00, 2.3710283435E+00, 9.0859563685E-01],
	[2.8975000000E+04, 1.9779518531E+01, 5.1750756588E+00, 5.6225924914E+00, 2.3716625937E+00, 9.0863906539E-01],
	[2.8980000000E+04, 1.9785117755E+01, 5.1750579782E+00, 5.6257259917E+00, 2.3722967401E+00, 9.0868247270E-01],
	[2.8985000000E+04, 1.9790717597E+01, 5.1750403007E+00, 5.6288606965E+00, 2.3729307826E+00, 9.0872585879E-01],
	[2.8990000000E+04, 1.9796318059E+01, 5.1750226263E+00, 5.6319966059E+00, 2.3735647213E+00, 9.0876922366E-01],
	[2.8995000000E+04, 1.9801919138E+01, 5.1750049551E+00, 5.6351337201E+00, 2.3741985560E+00, 9.0881256732E-01],
	[2.9000000000E+04, 1.9807520836E+01, 5.1749872869E+00, 5.6382720395E+00, 2.3748322866E+00, 9.0885588978E-01],
	[2.9005000000E+04, 1.9813123153E+01, 5.1749696218E+00, 5.6414115643E+00, 2.3754659132E+00, 9.0889919105E-01],
	[2.9010000000E+04, 1.9818726088E+01, 5.1749519599E+00, 5.6445522947E+00, 2.3760994358E+00, 9.0894247115E-01],
	[2.9015000000E+04, 1.9824329642E+01, 5.1749343010E+00, 5.6476942310E+00, 2.3767328541E+00, 9.0898573007E-01],
	[2.9020000000E+04, 1.9829933814E+01, 5.1749166453E+00, 5.6508373735E+00, 2.3773661683E+00, 9.0902896783E-01],
	[2.9025000000E+04, 1.9835538604E+01, 5.1748989927E+00, 5.6539817224E+00, 2.3779993782E+00, 9.0907218444E-01],
	[2.9030000000E+04, 1.9841144013E+01, 5.1748813431E+00, 5.6571272779E+00, 2.3786324839E+00, 9.0911537991E-01],
	[2.9035000000E+04, 1.9846750040E+01, 5.1748636967E+00, 5.6602740404E+00, 2.3792654852E+00, 9.0915855424E-01],
	[2.9040000000E+04, 1.9852356685E+01, 5.1748460534E+00, 5.6634220100E+00, 2.3798983821E+00, 9.0920170745E-01],
	[2.9045000000E+04, 1.9857963948E+01, 5.1748284131E+00, 5.6665711871E+00, 2.3805311745E+00, 9.0924483953E-01],
	[2.9050000000E+04, 1.9863571830E+01, 5.1748107760E+00, 5.6697215718E+00, 2.3811638625E+00, 9.0928795052E-01],
	[2.9055000000E+04, 1.9869180330E+01, 5.1747931419E+00, 5.6728731645E+00, 2.3817964460E+00, 9.0933104040E-01],
	[2.9060000000E+04, 1.9874789447E+01, 5.1747755110E+00, 5.6760259653E+00, 2.3824289248E+00, 9.0937410920E-01],
	[2.9065000000E+04, 1.9880399183E+01, 5.1747578831E+00, 5.6791799746E+00, 2.3830612991E+00, 9.0941715691E-01],
	[2.9070000000E+04, 1.9886009537E+01, 5.1747402583E+00, 5.6823351926E+00, 2.3836935687E+00, 9.0946018356E-01],
	[2.9075000000E+04, 1.9891620509E+01, 5.1747226366E+00, 5.6854916196E+00, 2.3843257335E+00, 9.0950318914E-01],
	[2.9080000000E+04, 1.9897232099E+01, 5.1747050181E+00, 5.6886492557E+00, 2.3849577936E+00, 9.0954617367E-01],
	[2.9085000000E+04, 1.9902844306E+01, 5.1746874026E+00, 5.6918081014E+00, 2.3855897489E+00, 9.0958913716E-01],
	[2.9090000000E+04, 1.9908457132E+01, 5.1746697901E+00, 5.6949681567E+00, 2.3862215993E+00, 9.0963207961E-01],
	[2.9095000000E+04, 1.9914070575E+01, 5.1746521808E+00, 5.6981294220E+00, 2.3868533448E+00, 9.0967500104E-01],
	[2.9100000000E+04, 1.9919684636E+01, 5.1746345746E+00, 5.7012918976E+00, 2.3874849853E+00, 9.0971790145E-01],
	[2.9105000000E+04, 1.9925299315E+01, 5.1746169714E+00, 5.7044555836E+00, 2.3881165209E+00, 9.0976078085E-01],
	[2.9110000000E+04, 1.9930914612E+01, 5.1745993714E+00, 5.7076204803E+00, 2.3887479514E+00, 9.0980363926E-01],
	[2.9115000000E+04, 1.9936530526E+01, 5.1745817744E+00, 5.7107865881E+00, 2.3893792768E+00, 9.0984647668E-01],
	[2.9120000000E+04, 1.9942147058E+01, 5.1745641805E+00, 5.7139539071E+00, 2.3900104971E+00, 9.0988929311E-01],
	[2.9125000000E+04, 1.9947764207E+01, 5.1745465896E+00, 5.7171224376E+00, 2.3906416121E+00, 9.0993208858E-01],
	[2.9130000000E+04, 1.9953381974E+01, 5.1745290019E+00, 5.7202921798E+00, 2.3912726220E+00, 9.0997486309E-01],
	[2.9135000000E+04, 1.9959000359E+01, 5.1745114172E+00, 5.7234631341E+00, 2.3919035265E+00, 9.1001761664E-01],
	[2.9140000000E+04, 1.9964619361E+01, 5.1744938356E+00, 5.7266353006E+00, 2.3925343258E+00, 9.1006034925E-01],
	[2.9145000000E+04, 1.9970238980E+01, 5.1744762571E+00, 5.7298086797E+00, 2.3931650196E+00, 9.1010306093E-01],
	[2.9150000000E+04, 1.9975859217E+01, 5.1744586817E+00, 5.7329832715E+00, 2.3937956081E+00, 9.1014575168E-01],
	[2.9155000000E+04, 1.9981480071E+01, 5.1744411093E+00, 5.7361590763E+00, 2.3944260910E+00, 9.1018842152E-01],
	[2.9160000000E+04, 1.9987101542E+01, 5.1744235400E+00, 5.7393360945E+00, 2.3950564685E+00, 9.1023107045E-01],
	[2.9165000000E+04, 1.9992723631E+01, 5.1744059738E+00, 5.7425143261E+00, 2.3956867404E+00, 9.1027369848E-01],
	[2.9170000000E+04, 1.9998346337E+01, 5.1743884106E+00, 5.7456937716E+00, 2.3963169067E+00, 9.1031630563E-01],
	[2.9175000000E+04, 2.0003969661E+01, 5.1743708506E+00, 5.7488744311E+00, 2.3969469674E+00, 9.1035889190E-01],
	[2.9180000000E+04, 2.0009593601E+01, 5.1743532935E+00, 5.7520563049E+00, 2.3975769223E+00, 9.1040145729E-01],
	[2.9185000000E+04, 2.0015218159E+01, 5.1743357396E+00, 5.7552393933E+00, 2.3982067715E+00, 9.1044400183E-01],
	[2.9190000000E+04, 2.0020843333E+01, 5.1743181887E+00, 5.7584236965E+00, 2.3988365150E+00, 9.1048652551E-01],
	[2.9195000000E+04, 2.0026469125E+01, 5.1743006409E+00, 5.7616092147E+00, 2.3994661526E+00, 9.1052902835E-01],
	[2.9200000000E+04, 2.0032095534E+01, 5.1742830962E+00, 5.7647959483E+00, 2.4000956843E+00, 9.1057151036E-01],
	[2.9205000000E+04, 2.0037722559E+01, 5.1742655545E+00, 5.7679838975E+00, 2.4007251101E+00, 9.1061397154E-01],
	[2.9210000000E+04, 2.0043350202E+01, 5.1742480159E+00, 5.7711730625E+00, 2.4013544299E+00, 9.1065641191E-01],
	[2.9215000000E+04, 2.0048978462E+01, 5.1742304803E+00, 5.7743634435E+00, 2.4019836437E+00, 9.1069883148E-01],
	[2.9220000000E+04, 2.0054607338E+01, 5.1742129478E+00, 5.7775550410E+00, 2.4026127515E+00, 9.1074123024E-01],
	[2.9225000000E+04, 2.0060236831E+01, 5.1741954184E+00, 5.7807478550E+00, 2.4032417532E+00, 9.1078360822E-01],
	[2.9230000000E+04, 2.0065866941E+01, 5.1741778920E+00, 5.7839418858E+00, 2.4038706487E+00, 9.1082596543E-01],
	[2.9235000000E+04, 2.0071497668E+01, 5.1741603687E+00, 5.7871371338E+00, 2.4044994380E+00, 9.1086830186E-01],
	[2.9240000000E+04, 2.0077129012E+01, 5.1741428484E+00, 5.7903335992E+00, 2.4051281210E+00, 9.1091061753E-01],
	[2.9245000000E+04, 2.0082760972E+01, 5.1741253312E+00, 5.7935312821E+00, 2.4057566978E+00, 9.1095291245E-01],
	[2.9250000000E+04, 2.0088393549E+01, 5.1741078170E+00, 5.7967301830E+00, 2.4063851683E+00, 9.1099518663E-01],
	[2.9255000000E+04, 2.0094026742E+01, 5.1740903059E+00, 5.7999303019E+00, 2.4070135324E+00, 9.1103744008E-01],
	[2.9260000000E+04, 2.0099660552E+01, 5.1740727978E+00, 5.8031316393E+00, 2.4076417901E+00, 9.1107967281E-01],
	[2.9265000000E+04, 2.0105294979E+01, 5.1740552928E+00, 5.8063341952E+00, 2.4082699413E+00, 9.1112188482E-01],
	[2.9270000000E+04, 2.0110930022E+01, 5.1740377909E+00, 5.8095379701E+00, 2.4088979860E+00, 9.1116407612E-01],
	[2.9275000000E+04, 2.0116565681E+01, 5.1740202920E+00, 5.8127429641E+00, 2.4095259241E+00, 9.1120624673E-01],
	[2.9280000000E+04, 2.0122201957E+01, 5.1740027961E+00, 5.8159491775E+00, 2.4101537557E+00, 9.1124839666E-01],
	[2.9285000000E+04, 2.0127838849E+01, 5.1739853033E+00, 5.8191566106E+00, 2.4107814806E+00, 9.1129052591E-01],
	[2.9290000000E+04, 2.0133476358E+01, 5.1739678135E+00, 5.8223652636E+00, 2.4114090988E+00, 9.1133263448E-01],
	[2.9295000000E+04, 2.0139114483E+01, 5.1739503268E+00, 5.8255751368E+00, 2.4120366103E+00, 9.1137472240E-01],
	[2.9300000000E+04, 2.0144753224E+01, 5.1739328431E+00, 5.8287862304E+00, 2.4126640150E+00, 9.1141678968E-01],
	[2.9305000000E+04, 2.0150392581E+01, 5.1739153625E+00, 5.8319985446E+00, 2.4132913129E+00, 9.1145883631E-01],
	[2.9310000000E+04, 2.0156032555E+01, 5.1738978849E+00, 5.8352120798E+00, 2.4139185040E+00, 9.1150086231E-01],
	[2.9315000000E+04, 2.0161673145E+01, 5.1738804104E+00, 5.8384268362E+00, 2.4145455881E+00, 9.1154286768E-01],
	[2.9320000000E+04, 2.0167314351E+01, 5.1738629388E+00, 5.8416428140E+00, 2.4151725653E+00, 9.1158485245E-01],
	[2.9325000000E+04, 2.0172956172E+01, 5.1738454704E+00, 5.8448600135E+00, 2.4157994355E+00, 9.1162681661E-01],
	[2.9330000000E+04, 2.0178598610E+01, 5.1738280049E+00, 5.8480784350E+00, 2.4164261987E+00, 9.1166876018E-01],
	[2.9335000000E+04, 2.0184241664E+01, 5.1738105425E+00, 5.8512980787E+00, 2.4170528548E+00, 9.1171068316E-01],
	[2.9340000000E+04, 2.0189885334E+01, 5.1737930832E+00, 5.8545189449E+00, 2.4176794037E+00, 9.1175258556E-01],
	[2.9345000000E+04, 2.0195529620E+01, 5.1737756268E+00, 5.8577410337E+00, 2.4183058455E+00, 9.1179446740E-01],
	[2.9350000000E+04, 2.0201174522E+01, 5.1737581735E+00, 5.8609643456E+00, 2.4189321801E+00, 9.1183632868E-01],
	[2.9355000000E+04, 2.0206820039E+01, 5.1737407232E+00, 5.8641888806E+00, 2.4195584074E+00, 9.1187816942E-01],
	[2.9360000000E+04, 2.0212466173E+01, 5.1737232760E+00, 5.8674146392E+00, 2.4201845274E+00, 9.1191998961E-01],
	[2.9365000000E+04, 2.0218112922E+01, 5.1737058318E+00, 5.8706416215E+00, 2.4208105401E+00, 9.1196178927E-01],
	[2.9370000000E+04, 2.0223760287E+01, 5.1736883906E+00, 5.8738698278E+00, 2.4214364454E+00, 9.1200356842E-01],
	[2.9375000000E+04, 2.0229408267E+01, 5.1736709525E+00, 5.8770992583E+00, 2.4220622433E+00, 9.1204532705E-01],
	[2.9380000000E+04, 2.0235056863E+01, 5.1736535173E+00, 5.8803299134E+00, 2.4226879337E+00, 9.1208706518E-01],
	[2.9385000000E+04, 2.0240706075E+01, 5.1736360852E+00, 5.8835617932E+00, 2.4233135166E+00, 9.1212878282E-01],
	[2.9390000000E+04, 2.0246355903E+01, 5.1736186562E+00, 5.8867948980E+00, 2.4239389919E+00, 9.1217047997E-01],
	[2.9395000000E+04, 2.0252006346E+01, 5.1736012301E+00, 5.8900292281E+00, 2.4245643597E+00, 9.1221215665E-01],
	[2.9400000000E+04, 2.0257657404E+01, 5.1735838071E+00, 5.8932647838E+00, 2.4251896198E+00, 9.1225381286E-01],
	[2.9405000000E+04, 2.0263309078E+01, 5.1735663871E+00, 5.8965015652E+00, 2.4258147722E+00, 9.1229544862E-01],
	[2.9410000000E+04, 2.0268961367E+01, 5.1735489701E+00, 5.8997395726E+00, 2.4264398169E+00, 9.1233706393E-01],
	[2.9415000000E+04, 2.0274614272E+01, 5.1735315561E+00, 5.9029788064E+00, 2.4270647538E+00, 9.1237865881E-01],
	[2.9420000000E+04, 2.0280267792E+01, 5.1735141452E+00, 5.9062192666E+00, 2.4276895829E+00, 9.1242023325E-01],
	[2.9425000000E+04, 2.0285921928E+01, 5.1734967372E+00, 5.9094609537E+00, 2.4283143041E+00, 9.1246178728E-01],
	[2.9430000000E+04, 2.0291576678E+01, 5.1734793323E+00, 5.9127038679E+00, 2.4289389175E+00, 9.1250332089E-01],
	[2.9435000000E+04, 2.0297236898E+01, 5.1734626787E+00, 5.9159480094E+00, 2.4295636574E+00, 9.1254483411E-01],
	[2.9440000000E+04, 2.0302914110E+01, 5.1734485522E+00, 5.9191933784E+00, 2.4301890812E+00, 9.1258632693E-01],
	[2.9445000000E+04, 2.0308591945E+01, 5.1734344281E+00, 5.9224399752E+00, 2.4308143976E+00, 9.1262779937E-01],
	[2.9450000000E+04, 2.0314270404E+01, 5.1734203064E+00, 5.9256878002E+00, 2.4314396067E+00, 9.1266925144E-01],
	[2.9455000000E+04, 2.0319949486E+01, 5.1734061872E+00, 5.9289368535E+00, 2.4320647084E+00, 9.1271068315E-01],
	[2.9460000000E+04, 2.0325629192E+01, 5.1733920704E+00, 5.9321871353E+00, 2.4326897027E+00, 9.1275209450E-01],
	[2.9465000000E+04, 2.0331309521E+01, 5.1733779561E+00, 5.9354386460E+00, 2.4333145895E+00, 9.1279348550E-01],
	[2.9470000000E+04, 2.0336990473E+01, 5.1733638442E+00, 5.9386913859E+00, 2.4339393688E+00, 9.1283485617E-01],
	[2.9475000000E+04, 2.0342672048E+01, 5.1733497347E+00, 5.9419453550E+00, 2.4345640405E+00, 9.1287620652E-01],
	[2.9480000000E+04, 2.0348354246E+01, 5.1733356276E+00, 5.9452005538E+00, 2.4351886046E+00, 9.1291753654E-01],
	[2.9485000000E+04, 2.0354037067E+01, 5.1733215230E+00, 5.9484569825E+00, 2.4358130610E+00, 9.1295884626E-01],
	[2.9490000000E+04, 2.0359720512E+01, 5.1733074208E+00, 5.9517146412E+00, 2.4364374098E+00, 9.1300013568E-01],
	[2.9495000000E+04, 2.0365404579E+01, 5.1732933210E+00, 5.9549735304E+00, 2.4370616509E+00, 9.1304140481E-01],
	[2.9500000000E+04, 2.0371089270E+01, 5.1732792237E+00, 5.9582336502E+00, 2.4376857841E+00, 9.1308265365E-01],
	[2.9505000000E+04, 2.0376774584E+01, 5.1732651288E+00, 5.9614950009E+00, 2.4383098096E+00, 9.1312388223E-01],
	[2.9510000000E+04, 2.0382460520E+01, 5.1732510363E+00, 5.9647575827E+00, 2.4389337272E+00, 9.1316509055E-01],
	[2.9515000000E+04, 2.0388147079E+01, 5.1732369462E+00, 5.9680213959E+00, 2.4395575369E+00, 9.1320627861E-01],
	[2.9520000000E+04, 2.0393834262E+01, 5.1732228586E+00, 5.9712864408E+00, 2.4401812387E+00, 9.1324744643E-01],
	[2.9525000000E+04, 2.0399522067E+01, 5.1732087734E+00, 5.9745527176E+00, 2.4408048325E+00, 9.1328859401E-01],
	[2.9530000000E+04, 2.0405210494E+01, 5.1731946906E+00, 5.9778202266E+00, 2.4414283182E+00, 9.1332972137E-01],
	[2.9535000000E+04, 2.0410899545E+01, 5.1731806103E+00, 5.9810889679E+00, 2.4420516959E+00, 9.1337082852E-01],
	[2.9540000000E+04, 2.0416589218E+01, 5.1731665323E+00, 5.9843589420E+00, 2.4426749655E+00, 9.1341191546E-01],
	[2.9545000000E+04, 2.0422279514E+01, 5.1731524568E+00, 5.9876301490E+00, 2.4432981270E+00, 9.1345298220E-01],
	[2.9550000000E+04, 2.0427970433E+01, 5.1731383837E+00, 5.9909025892E+00, 2.4439211803E+00, 9.1349402875E-01],
	[2.9555000000E+04, 2.0433661974E+01, 5.1731243130E+00, 5.9941762628E+00, 2.4445441253E+00, 9.1353505512E-01],
	[2.9560000000E+04, 2.0439354137E+01, 5.1731102448E+00, 5.9974511702E+00, 2.4451669621E+00, 9.1357606133E-01],
	[2.9565000000E+04, 2.0445046924E+01, 5.1730961789E+00, 6.0007273115E+00, 2.4457896906E+00, 9.1361704737E-01],
	[2.9570000000E+04, 2.0450740332E+01, 5.1730821155E+00, 6.0040046870E+00, 2.4464123107E+00, 9.1365801327E-01],
	[2.9575000000E+04, 2.0456434363E+01, 5.1730680545E+00, 6.0072832969E+00, 2.4470348225E+00, 9.1369895902E-01],
	[2.9580000000E+04, 2.0462129017E+01, 5.1730539959E+00, 6.0105631416E+00, 2.4476572258E+00, 9.1373988464E-01],
	[2.9585000000E+04, 2.0467824293E+01, 5.1730399397E+00, 6.0138442213E+00, 2.4482795206E+00, 9.1378079014E-01],
	[2.9590000000E+04, 2.0473520191E+01, 5.1730258859E+00, 6.0171265362E+00, 2.4489017070E+00, 9.1382167552E-01],
	[2.9595000000E+04, 2.0479216712E+01, 5.1730118346E+00, 6.0204100866E+00, 2.4495237847E+00, 9.1386254080E-01],
	[2.9600000000E+04, 2.0484913854E+01, 5.1729977856E+00, 6.0236948728E+00, 2.4501457539E+00, 9.1390338599E-01],
	[2.9605000000E+04, 2.0490611619E+01, 5.1729837391E+00, 6.0269808949E+00, 2.4507676145E+00, 9.1394421109E-01],
	[2.9610000000E+04, 2.0496310006E+01, 5.1729696950E+00, 6.0302681533E+00, 2.4513893664E+00, 9.1398501611E-01],
	[2.9615000000E+04, 2.0502009016E+01, 5.1729556533E+00, 6.0335566482E+00, 2.4520110095E+00, 9.1402580106E-01],
	[2.9620000000E+04, 2.0507708647E+01, 5.1729416140E+00, 6.0368463799E+00, 2.4526325440E+00, 9.1406656596E-01],
	[2.9625000000E+04, 2.0513408901E+01, 5.1729275771E+00, 6.0401373486E+00, 2.4532539696E+00, 9.1410731080E-01],
	[2.9630000000E+04, 2.0519109776E+01, 5.1729135426E+00, 6.0434295546E+00, 2.4538752864E+00, 9.1414803561E-01],
	[2.9635000000E+04, 2.0524811274E+01, 5.1728995105E+00, 6.0467229982E+00, 2.4544964943E+00, 9.1418874039E-01],
	[2.9640000000E+04, 2.0530513393E+01, 5.1728854808E+00, 6.0500176795E+00, 2.4551175933E+00, 9.1422942515E-01],
	[2.9645000000E+04, 2.0536216135E+01, 5.1728714536E+00, 6.0533135989E+00, 2.4557385834E+00, 9.1427008989E-01],
	[2.9650000000E+04, 2.0541919498E+01, 5.1728574287E+00, 6.0566107565E+00, 2.4563594644E+00, 9.1431073463E-01],
	[2.9655000000E+04, 2.0547623483E+01, 5.1728434062E+00, 6.0599091528E+00, 2.4569802365E+00, 9.1435135938E-01],
	[2.9660000000E+04, 2.0553328090E+01, 5.1728293862E+00, 6.0632087878E+00, 2.4576008994E+00, 9.1439196415E-01],
	[2.9665000000E+04, 2.0559033319E+01, 5.1728153685E+00, 6.0665096619E+00, 2.4582214533E+00, 9.1443254894E-01],
	[2.9670000000E+04, 2.0564739170E+01, 5.1728013532E+00, 6.0698117754E+00, 2.4588418980E+00, 9.1447311376E-01],
	[2.9675000000E+04, 2.0570445642E+01, 5.1727873404E+00, 6.0731151284E+00, 2.4594622335E+00, 9.1451365863E-01],
	[2.9680000000E+04, 2.0576152736E+01, 5.1727733299E+00, 6.0764197212E+00, 2.4600824598E+00, 9.1455418356E-01],
	[2.9685000000E+04, 2.0581860451E+01, 5.1727593218E+00, 6.0797255542E+00, 2.4607025768E+00, 9.1459468854E-01],
	[2.9690000000E+04, 2.0587568788E+01, 5.1727453162E+00, 6.0830326275E+00, 2.4613225845E+00, 9.1463517360E-01],
	[2.9695000000E+04, 2.0593277747E+01, 5.1727313129E+00, 6.0863409414E+00, 2.4619424829E+00, 9.1467563874E-01],
	[2.9700000000E+04, 2.0598987327E+01, 5.1727173120E+00, 6.0896504962E+00, 2.4625622718E+00, 9.1471608397E-01],
	[2.9705000000E+04, 2.0604697529E+01, 5.1727033135E+00, 6.0929612921E+00, 2.4631819514E+00, 9.1475650929E-01],
	[2.9710000000E+04, 2.0610408352E+01, 5.1726893175E+00, 6.0962733293E+00, 2.4638015215E+00, 9.1479691473E-01],
	[2.9715000000E+04, 2.0616119796E+01, 5.1726753238E+00, 6.0995866082E+00, 2.4644209820E+00, 9.1483730029E-01],
	[2.9720000000E+04, 2.0621831862E+01, 5.1726613325E+00, 6.1029011290E+00, 2.4650403331E+00, 9.1487766597E-01],
	[2.9725000000E+04, 2.0627544549E+01, 5.1726473435E+00, 6.1062168919E+00, 2.4656595745E+00, 9.1491801179E-01],
	[2.9730000000E+04, 2.0633257858E+01, 5.1726333570E+00, 6.1095338973E+00, 2.4662787064E+00, 9.1495833775E-01],
	[2.9735000000E+04, 2.0638971787E+01, 5.1726193729E+00, 6.1128521452E+00, 2.4668977285E+00, 9.1499864387E-01],
	[2.9740000000E+04, 2.0644686338E+01, 5.1726053912E+00, 6.1161716361E+00, 2.4675166410E+00, 9.1503893016E-01],
	[2.9745000000E+04, 2.0650401511E+01, 5.1725914118E+00, 6.1194923701E+00, 2.4681354438E+00, 9.1507919662E-01],
	[2.9750000000E+04, 2.0656117304E+01, 5.1725774348E+00, 6.1228143476E+00, 2.4687541367E+00, 9.1511944326E-01],
	[2.9755000000E+04, 2.0661833718E+01, 5.1725634603E+00, 6.1261375687E+00, 2.4693727199E+00, 9.1515967010E-01],
	[2.9760000000E+04, 2.0667550754E+01, 5.1725494881E+00, 6.1294620338E+00, 2.4699911932E+00, 9.1519987714E-01],
	[2.9765000000E+04, 2.0673268410E+01, 5.1725355183E+00, 6.1327877431E+00, 2.4706095566E+00, 9.1524006438E-01],
	[2.9770000000E+04, 2.0678986688E+01, 5.1725215508E+00, 6.1361146968E+00, 2.4712278101E+00, 9.1528023185E-01],
	[2.9775000000E+04, 2.0684705586E+01, 5.1725075858E+00, 6.1394428952E+00, 2.4718459536E+00, 9.1532037955E-01],
	[2.9780000000E+04, 2.0690425106E+01, 5.1724936231E+00, 6.1427723385E+00, 2.4724639872E+00, 9.1536050749E-01],
	[2.9785000000E+04, 2.0696145246E+01, 5.1724796629E+00, 6.1461030271E+00, 2.4730819106E+00, 9.1540061567E-01],
	[2.9790000000E+04, 2.0701866007E+01, 5.1724657050E+00, 6.1494349611E+00, 2.4736997240E+00, 9.1544070412E-01],
	[2.9795000000E+04, 2.0707587389E+01, 5.1724517494E+00, 6.1527681409E+00, 2.4743174273E+00, 9.1548077283E-01],
	[2.9800000000E+04, 2.0713309392E+01, 5.1724377963E+00, 6.1561025667E+00, 2.4749350204E+00, 9.1552082181E-01],
	[2.9805000000E+04, 2.0719032015E+01, 5.1724238456E+00, 6.1594382386E+00, 2.4755525034E+00, 9.1556085108E-01],
	[2.9810000000E+04, 2.0724755259E+01, 5.1724098972E+00, 6.1627751571E+00, 2.4761698761E+00, 9.1560086065E-01],
	[2.9815000000E+04, 2.0730479124E+01, 5.1723959512E+00, 6.1661133223E+00, 2.4767871385E+00, 9.1564085052E-01],
	[2.9820000000E+04, 2.0736203610E+01, 5.1723820075E+00, 6.1694527346E+00, 2.4774042906E+00, 9.1568082070E-01],
	[2.9825000000E+04, 2.0741928716E+01, 5.1723680663E+00, 6.1727933941E+00, 2.4780213324E+00, 9.1572077121E-01],
	[2.9830000000E+04, 2.0747654442E+01, 5.1723541274E+00, 6.1761353011E+00, 2.4786382638E+00, 9.1576070205E-01],
	[2.9835000000E+04, 2.0753380789E+01, 5.1723401909E+00, 6.1794784558E+00, 2.4792550848E+00, 9.1580061323E-01],
	[2.9840000000E+04, 2.0759107757E+01, 5.1723262568E+00, 6.1828228586E+00, 2.4798717953E+00, 9.1584050476E-01],
	[2.9845000000E+04, 2.0764835345E+01, 5.1723123250E+00, 6.1861685097E+00, 2.4804883954E+00, 9.1588037665E-01],
	[2.9850000000E+04, 2.0770563554E+01, 5.1722983956E+00, 6.1895154094E+00, 2.4811048849E+00, 9.1592022890E-01],
	[2.9855000000E+04, 2.0776292383E+01, 5.1722844686E+00, 6.1928635578E+00, 2.4817212638E+00, 9.1596006154E-01],
	[2.9860000000E+04, 2.0782021832E+01, 5.1722705440E+00, 6.1962129553E+00, 2.4823375321E+00, 9.1599987456E-01],
	[2.9865000000E+04, 2.0787751901E+01, 5.1722566217E+00, 6.1995636021E+00, 2.4829536898E+00, 9.1603966799E-01],
	[2.9870000000E+04, 2.0793482591E+01, 5.1722427018E+00, 6.2029154985E+00, 2.4835697368E+00, 9.1607944181E-01],
	[2.9875000000E+04, 2.0799213901E+01, 5.1722287843E+00, 6.2062686446E+00, 2.4841856731E+00, 9.1611919605E-01],
	[2.9880000000E+04, 2.0804945831E+01, 5.1722148691E+00, 6.2096230409E+00, 2.4848014987E+00, 9.1615893072E-01],
	[2.9885000000E+04, 2.0810678381E+01, 5.1722009563E+00, 6.2129786875E+00, 2.4854172134E+00, 9.1619864582E-01],
	[2.9890000000E+04, 2.0816411552E+01, 5.1721870458E+00, 6.2163355847E+00, 2.4860328173E+00, 9.1623834137E-01],
	[2.9895000000E+04, 2.0822145342E+01, 5.1721731377E+00, 6.2196937327E+00, 2.4866483104E+00, 9.1627801737E-01],
	[2.9900000000E+04, 2.0827879753E+01, 5.1721592320E+00, 6.2230531319E+00, 2.4872636926E+00, 9.1631767383E-01],
	[2.9905000000E+04, 2.0833614784E+01, 5.1721453287E+00, 6.2264137824E+00, 2.4878789638E+00, 9.1635731076E-01],
	[2.9910000000E+04, 2.0839360130E+01, 5.1721329056E+00, 6.2297756845E+00, 2.4884946044E+00, 9.1639692817E-01],
	[2.9915000000E+04, 2.0845117501E+01, 5.1721222220E+00, 6.2331388385E+00, 2.4891106993E+00, 9.1643652607E-01],
	[2.9920000000E+04, 2.0850875500E+01, 5.1721115401E+00, 6.2365032446E+00, 2.4897266839E+00, 9.1647610447E-01],
	[2.9925000000E+04, 2.0856634127E+01, 5.1721008600E+00, 6.2398689031E+00, 2.4903425580E+00, 9.1651566338E-01],
	[2.9930000000E+04, 2.0862393382E+01, 5.1720901818E+00, 6.2432358142E+00, 2.4909583217E+00, 9.1655520281E-01],
	[2.9935000000E+04, 2.0868153265E+01, 5.1720795054E+00, 6.2466039783E+00, 2.4915739750E+00, 9.1659472276E-01],
	[2.9940000000E+04, 2.0873913776E+01, 5.1720688307E+00, 6.2499733954E+00, 2.4921895178E+00, 9.1663422325E-01],
	[2.9945000000E+04, 2.0879674915E+01, 5.1720581579E+00, 6.2533440661E+00, 2.4928049500E+00, 9.1667370428E-01],
	[2.9950000000E+04, 2.0885436681E+01, 5.1720474869E+00, 6.2567159903E+00, 2.4934202717E+00, 9.1671316587E-01],
	[2.9955000000E+04, 2.0891199075E+01, 5.1720368176E+00, 6.2600891685E+00, 2.4940354828E+00, 9.1675260803E-01],
	[2.9960000000E+04, 2.0896962097E+01, 5.1720261502E+00, 6.2634636009E+00, 2.4946505832E+00, 9.1679203076E-01],
	[2.9965000000E+04, 2.0902725746E+01, 5.1720154846E+00, 6.2668392877E+00, 2.4952655729E+00, 9.1683143407E-01],
	[2.9970000000E+04, 2.0908490023E+01, 5.1720048208E+00, 6.2702162292E+00, 2.4958804520E+00, 9.1687081797E-01],
	[2.9975000000E+04, 2.0914254928E+01, 5.1719941588E+00, 6.2735944256E+00, 2.4964952203E+00, 9.1691018247E-01],
	[2.9980000000E+04, 2.0920020460E+01, 5.1719834985E+00, 6.2769738773E+00, 2.4971098778E+00, 9.1694952759E-01],
	[2.9985000000E+04, 2.0925786620E+01, 5.1719728401E+00, 6.2803545844E+00, 2.4977244245E+00, 9.1698885332E-01],
	[2.9990000000E+04, 2.0931553407E+01, 5.1719621835E+00, 6.2837365472E+00, 2.4983388604E+00, 9.1702815969E-01],
	[2.9995000000E+04, 2.0937320822E+01, 5.1719515287E+00, 6.2871197660E+00, 2.4989531853E+00, 9.1706744669E-01],
	[3.0000000000E+04, 2.0943088864E+01, 5.1719408757E+00, 6.2905042410E+00, 2.4995673994E+00, 9.1710671434E-01],
	[3.0005000000E+04, 2.0948857534E+01, 5.1719302244E+00, 6.2939114965E+00, 2.5001848989E+00, 9.1714596264E-01],
	[3.0010000000E+04, 2.0954626831E+01, 5.1719195750E+00, 6.2973200283E+00, 2.5008022865E+00, 9.1718519162E-01],
	[3.0015000000E+04, 2.0960396755E+01, 5.1719089274E+00, 6.3007298368E+00, 2.5014195623E+00, 9.1722440127E-01],
	[3.0020000000E+04, 2.0966167307E+01, 5.1718982815E+00, 6.3041409223E+00, 2.5020367260E+00, 9.1726359160E-01],
	[3.0025000000E+04, 2.0971938485E+01, 5.1718876375E+00, 6.3075532849E+00, 2.5026537778E+00, 9.1730276263E-01],
	[3.0030000000E+04, 2.0977710291E+01, 5.1718769953E+00, 6.3109669251E+00, 2.5032707176E+00, 9.1734191436E-01],
	[3.0035000000E+04, 2.0983482724E+01, 5.1718663548E+00, 6.3143818430E+00, 2.5038875453E+00, 9.1738104680E-01],
	[3.0040000000E+04, 2.0989255785E+01, 5.1718557161E+00, 6.3177980389E+00, 2.5045042609E+00, 9.1742015997E-01],
	[3.0045000000E+04, 2.0995029472E+01, 5.1718450793E+00, 6.3212155130E+00, 2.5051208643E+00, 9.1745925387E-01],
	[3.0050000000E+04, 2.1000803786E+01, 5.1718344442E+00, 6.3246342657E+00, 2.5057373556E+00, 9.1749832851E-01],
	[3.0055000000E+04, 2.1006578728E+01, 5.1718238109E+00, 6.3280542972E+00, 2.5063537347E+00, 9.1753738390E-01],
	[3.0060000000E+04, 2.1012354296E+01, 5.1718131794E+00, 6.3314756077E+00, 2.5069700016E+00, 9.1757642004E-01],
	[3.0065000000E+04, 2.1018130492E+01, 5.1718025497E+00, 6.3348981976E+00, 2.5075861562E+00, 9.1761543696E-01],
	[3.0070000000E+04, 2.1023907314E+01, 5.1717919218E+00, 6.3383220671E+00, 2.5082021985E+00, 9.1765443465E-01],
	[3.0075000000E+04, 2.1029684763E+01, 5.1717812957E+00, 6.3417472164E+00, 2.5088181284E+00, 9.1769341314E-01],
	[3.0080000000E+04, 2.1035462839E+01, 5.1717706713E+00, 6.3451736459E+00, 2.5094339459E+00, 9.1773237241E-01],
	[3.0085000000E+04, 2.1041241542E+01, 5.1717600488E+00, 6.3486013557E+00, 2.5100496510E+00, 9.1777131250E-01],
	[3.0090000000E+04, 2.1047020871E+01, 5.1717494280E+00, 6.3520303462E+00, 2.5106652437E+00, 9.1781023339E-01],
	[3.0095000000E+04, 2.1052800828E+01, 5.1717388090E+00, 6.3554606176E+00, 2.5112807239E+00, 9.1784913512E-01],
	[3.0100000000E+04, 2.1058581411E+01, 5.1717281919E+00, 6.3588921702E+00, 2.5118960916E+00, 9.1788801767E-01],
	[3.0105000000E+04, 2.1064362620E+01, 5.1717175765E+00, 6.3623250043E+00, 2.5125113467E+00, 9.1792688107E-01],
	[3.0110000000E+04, 2.1070144457E+01, 5.1717069628E+00, 6.3657591201E+00, 2.5131264892E+00, 9.1796572532E-01],
	[3.0115000000E+04, 2.1075926919E+01, 5.1716963510E+00, 6.3691945178E+00, 2.5137415190E+00, 9.1800455042E-01],
	[3.0120000000E+04, 2.1081710009E+01, 5.1716857409E+00, 6.3726311978E+00, 2.5143564363E+00, 9.1804335639E-01],
	[3.0125000000E+04, 2.1087493725E+01, 5.1716751327E+00, 6.3760691603E+00, 2.5149712408E+00, 9.1808214323E-01],
	[3.0130000000E+04, 2.1093278067E+01, 5.1716645262E+00, 6.3795084055E+00, 2.5155859325E+00, 9.1812091095E-01],
	[3.0135000000E+04, 2.1099063036E+01, 5.1716539215E+00, 6.3829489338E+00, 2.5162005116E+00, 9.1815965955E-01],
	[3.0140000000E+04, 2.1104848631E+01, 5.1716433186E+00, 6.3863907455E+00, 2.5168149778E+00, 9.1819838905E-01],
	[3.0145000000E+04, 2.1110634853E+01, 5.1716327174E+00, 6.3898338406E+00, 2.5174293311E+00, 9.1823709946E-01],
	[3.0150000000E+04, 2.1116421701E+01, 5.1716221180E+00, 6.3932782197E+00, 2.5180435716E+00, 9.1827579078E-01],
	[3.0155000000E+04, 2.1122209175E+01, 5.1716115205E+00, 6.3967238828E+00, 2.5186576992E+00, 9.1831446301E-01],
	[3.0160000000E+04, 2.1127997276E+01, 5.1716009247E+00, 6.4001708302E+00, 2.5192717139E+00, 9.1835311618E-01],
	[3.0165000000E+04, 2.1133786003E+01, 5.1715903306E+00, 6.4036190624E+00, 2.5198856155E+00, 9.1839175028E-01],
	[3.0170000000E+04, 2.1139575356E+01, 5.1715797384E+00, 6.4070685794E+00, 2.5204994042E+00, 9.1843036532E-01],
	[3.0175000000E+04, 2.1145365335E+01, 5.1715691479E+00, 6.4105193815E+00, 2.5211130798E+00, 9.1846896131E-01],
	[3.0180000000E+04, 2.1151155940E+01, 5.1715585592E+00, 6.4139714691E+00, 2.5217266423E+00, 9.1850753827E-01],
	[3.0185000000E+04, 2.1156947171E+01, 5.1715479723E+00, 6.4174248424E+00, 2.5223400917E+00, 9.1854609619E-01],
	[3.0190000000E+04, 2.1162739029E+01, 5.1715373871E+00, 6.4208795016E+00, 2.5229534280E+00, 9.1858463508E-01],
	[3.0195000000E+04, 2.1168531512E+01, 5.1715268038E+00, 6.4243354471E+00, 2.5235666511E+00, 9.1862315496E-01],
	[3.0200000000E+04, 2.1174324622E+01, 5.1715162222E+00, 6.4277926790E+00, 2.5241797610E+00, 9.1866165583E-01],
	[3.0205000000E+04, 2.1180118357E+01, 5.1715056424E+00, 6.4312511977E+00, 2.5247927576E+00, 9.1870013769E-01],
	[3.0210000000E+04, 2.1185912718E+01, 5.1714950643E+00, 6.4347110034E+00, 2.5254056409E+00, 9.1873860057E-01],
	[3.0215000000E+04, 2.1191707705E+01, 5.1714844880E+00, 6.4381720964E+00, 2.5260184110E+00, 9.1877704446E-01],
	[3.0220000000E+04, 2.1197503318E+01, 5.1714739135E+00, 6.4416344770E+00, 2.5266310676E+00, 9.1881546937E-01],
	[3.0225000000E+04, 2.1203299557E+01, 5.1714633408E+00, 6.4450981453E+00, 2.5272436109E+00, 9.1885387531E-01],
	[3.0230000000E+04, 2.1209096421E+01, 5.1714527698E+00, 6.4485631018E+00, 2.5278560408E+00, 9.1889226229E-01],
	[3.0235000000E+04, 2.1214893911E+01, 5.1714422006E+00, 6.4520293466E+00, 2.5284683572E+00, 9.1893063032E-01],
	[3.0240000000E+04, 2.1220692027E+01, 5.1714316332E+00, 6.4554968799E+00, 2.5290805601E+00, 9.1896897940E-01],
	[3.0245000000E+04, 2.1226490769E+01, 5.1714210675E+00, 6.4589657022E+00, 2.5296926495E+00, 9.1900730955E-01],
	[3.0250000000E+04, 2.1232290136E+01, 5.1714105036E+00, 6.4624358136E+00, 2.5303046254E+00, 9.1904562077E-01],
	[3.0255000000E+04, 2.1238090129E+01, 5.1713999415E+00, 6.4659072144E+00, 2.5309164876E+00, 9.1908391306E-01],
	[3.0260000000E+04, 2.1243890747E+01, 5.1713893812E+00, 6.4693799049E+00, 2.5315282363E+00, 9.1912218644E-01],
	[3.0265000000E+04, 2.1249691991E+01, 5.1713788226E+00, 6.4728538853E+00, 2.5321398713E+00, 9.1916044092E-01],
	[3.0270000000E+04, 2.1255493860E+01, 5.1713682658E+00, 6.4763291559E+00, 2.5327513926E+00, 9.1919867650E-01],
	[3.0275000000E+04, 2.1261296355E+01, 5.1713577107E+00, 6.4798057170E+00, 2.5333628002E+00, 9.1923689319E-01],
	[3.0280000000E+04, 2.1267099475E+01, 5.1713471574E+00, 6.4832835688E+00, 2.5339740940E+00, 9.1927509100E-01],
	[3.0285000000E+04, 2.1272903220E+01, 5.1713366059E+00, 6.4867627116E+00, 2.5345852741E+00, 9.1931326993E-01],
	[3.0290000000E+04, 2.1278707591E+01, 5.1713260561E+00, 6.4902431457E+00, 2.5351963403E+00, 9.1935143000E-01],
	[3.0295000000E+04, 2.1284512587E+01, 5.1713155081E+00, 6.4937248713E+00, 2.5358072927E+00, 9.1938957121E-01],
	[3.0300000000E+04, 2.1290318208E+01, 5.1713049619E+00, 6.4972078887E+00, 2.5364181312E+00, 9.1942769358E-01],
	[3.0305000000E+04, 2.1296124455E+01, 5.1712944174E+00, 6.5006921981E+00, 2.5370288558E+00, 9.1946579710E-01],
	[3.0310000000E+04, 2.1301931326E+01, 5.1712838747E+00, 6.5041777999E+00, 2.5376394664E+00, 9.1950388179E-01],
	[3.0315000000E+04, 2.1307738823E+01, 5.1712733337E+00, 6.5076646943E+00, 2.5382499631E+00, 9.1954194765E-01],
	[3.0320000000E+04, 2.1313546945E+01, 5.1712627945E+00, 6.5111528815E+00, 2.5388603457E+00, 9.1957999470E-01],
	[3.0325000000E+04, 2.1319355692E+01, 5.1712522571E+00, 6.5146423618E+00, 2.5394706143E+00, 9.1961802294E-01],
	[3.0330000000E+04, 2.1325165064E+01, 5.1712417214E+00, 6.5181331356E+00, 2.5400807688E+00, 9.1965603237E-01],
	[3.0335000000E+04, 2.1330975062E+01, 5.1712311875E+00, 6.5216252029E+00, 2.5406908092E+00, 9.1969402302E-01],
	[3.0340000000E+04, 2.1336785684E+01, 5.1712206553E+00, 6.5251185642E+00, 2.5413007354E+00, 9.1973199488E-01],
	[3.0345000000E+04, 2.1342596931E+01, 5.1712101249E+00, 6.5286132197E+00, 2.5419105475E+00, 9.1976994796E-01],
	[3.0350000000E+04, 2.1348408803E+01, 5.1711995963E+00, 6.5321091697E+00, 2.5425202454E+00, 9.1980788227E-01],
	[3.0355000000E+04, 2.1354221299E+01, 5.1711890694E+00, 6.5356064143E+00, 2.5431298290E+00, 9.1984579782E-01],
	[3.0360000000E+04, 2.1360034421E+01, 5.1711785442E+00, 6.5391049539E+00, 2.5437392984E+00, 9.1988369462E-01],
	[3.0365000000E+04, 2.1365848167E+01, 5.1711680208E+00, 6.5426047888E+00, 2.5443486534E+00, 9.1992157268E-01],
	[3.0370000000E+04, 2.1371662538E+01, 5.1711574992E+00, 6.5461059192E+00, 2.5449578941E+00, 9.1995943200E-01],
	[3.0375000000E+04, 2.1377477534E+01, 5.1711469793E+00, 6.5496083453E+00, 2.5455670205E+00, 9.1999727259E-01],
	[3.0380000000E+04, 2.1383293155E+01, 5.1711364612E+00, 6.5531120675E+00, 2.5461760324E+00, 9.2003509446E-01],
	[3.0385000000E+04, 2.1389109400E+01, 5.1711259448E+00, 6.5566170861E+00, 2.5467849299E+00, 9.2007289761E-01],
	[3.0390000000E+04, 2.1394929722E+01, 5.1711159504E+00, 6.5601234011E+00, 2.5473938881E+00, 9.2011068207E-01],
	[3.0395000000E+04, 2.1400768146E+01, 5.1711085897E+00, 6.5636310131E+00, 2.5480036188E+00, 9.2014844782E-01],
	[3.0400000000E+04, 2.1406607201E+01, 5.1711012303E+00, 6.5671399221E+00, 2.5486132355E+00, 9.2018619489E-01],
	[3.0405000000E+04, 2.1412446890E+01, 5.1710938721E+00, 6.5706501285E+00, 2.5492227384E+00, 9.2022392328E-01],
	[3.0410000000E+04, 2.1418287210E+01, 5.1710865151E+00, 6.5741616325E+00, 2.5498321274E+00, 9.2026163299E-01],
	[3.0415000000E+04, 2.1424128163E+01, 5.1710791593E+00, 6.5776744345E+00, 2.5504414025E+00, 9.2029932404E-01],
	[3.0420000000E+04, 2.1429969749E+01, 5.1710718047E+00, 6.5811885346E+00, 2.5510505635E+00, 9.2033699644E-01],
	[3.0425000000E+04, 2.1435811966E+01, 5.1710644514E+00, 6.5847039331E+00, 2.5516596106E+00, 9.2037465019E-01],
	[3.0430000000E+04, 2.1441654816E+01, 5.1710570993E+00, 6.5882206303E+00, 2.5522685436E+00, 9.2041228530E-01],
	[3.0435000000E+04, 2.1447498299E+01, 5.1710497484E+00, 6.5917386265E+00, 2.5528773626E+00, 9.2044990177E-01],
	[3.0440000000E+04, 2.1453342413E+01, 5.1710423987E+00, 6.5952579220E+00, 2.5534860675E+00, 9.2048749963E-01],
	[3.0445000000E+04, 2.1459187160E+01, 5.1710350503E+00, 6.5987785169E+00, 2.5540946582E+00, 9.2052507886E-01],
	[3.0450000000E+04, 2.1465032539E+01, 5.1710277030E+00, 6.6023004116E+00, 2.5547031348E+00, 9.2056263949E-01],
	[3.0455000000E+04, 2.1470878549E+01, 5.1710203570E+00, 6.6058236063E+00, 2.5553114972E+00, 9.2060018152E-01],
	[3.0460000000E+04, 2.1476725192E+01, 5.1710130122E+00, 6.6093481013E+00, 2.5559197454E+00, 9.2063770496E-01],
	[3.0465000000E+04, 2.1482572467E+01, 5.1710056686E+00, 6.6128738969E+00, 2.5565278793E+00, 9.2067520982E-01],
	[3.0470000000E+04, 2.1488420374E+01, 5.1709983262E+00, 6.6164009933E+00, 2.5571358989E+00, 9.2071269610E-01],
	[3.0475000000E+04, 2.1494268913E+01, 5.1709909850E+00, 6.6199293908E+00, 2.5577438042E+00, 9.2075016382E-01],
	[3.0480000000E+04, 2.1500118084E+01, 5.1709836451E+00, 6.6234590896E+00, 2.5583515952E+00, 9.2078761297E-01],
	[3.0485000000E+04, 2.1505967887E+01, 5.1709763064E+00, 6.6269900901E+00, 2.5589592718E+00, 9.2082504358E-01],
	[3.0490000000E+04, 2.1511818322E+01, 5.1709689688E+00, 6.6305223925E+00, 2.5595668339E+00, 9.2086245564E-01],
	[3.0495000000E+04, 2.1517669388E+01, 5.1709616325E+00, 6.6340559970E+00, 2.5601742817E+00, 9.2089984917E-01],
	[3.0500000000E+04, 2.1523521086E+01, 5.1709542974E+00, 6.6375909039E+00, 2.5607816149E+00, 9.2093722417E-01],
	[3.0505000000E+04, 2.1529373416E+01, 5.1709469636E+00, 6.6411271135E+00, 2.5613888337E+00, 9.2097458066E-01],
	[3.0510000000E+04, 2.1535226378E+01, 5.1709396309E+00, 6.6446646261E+00, 2.5619959380E+00, 9.2101191863E-01],
	[3.0515000000E+04, 2.1541079972E+01, 5.1709322994E+00, 6.6482034419E+00, 2.5626029276E+00, 9.2104923811E-01],
	[3.0520000000E+04, 2.1546934197E+01, 5.1709249692E+00, 6.6517435612E+00, 2.5632098027E+00, 9.2108653908E-01],
	[3.0525000000E+04, 2.1552789053E+01, 5.1709176401E+00, 6.6552849842E+00, 2.5638165632E+00, 9.2112382158E-01],
	[3.0530000000E+04, 2.1558644542E+01, 5.1709103123E+00, 6.6588277112E+00, 2.5644232090E+00, 9.2116108559E-01],
	[3.0535000000E+04, 2.1564500661E+01, 5.1709029857E+00, 6.6623717426E+00, 2.5650297402E+00, 9.2119833114E-01],
	[3.0540000000E+04, 2.1570357413E+01, 5.1708956603E+00, 6.6659170784E+00, 2.5656361566E+00, 9.2123555823E-01],
	[3.0545000000E+04, 2.1576214795E+01, 5.1708883361E+00, 6.6694637191E+00, 2.5662424583E+00, 9.2127276686E-01],
	[3.0550000000E+04, 2.1582072810E+01, 5.1708810131E+00, 6.6730116649E+00, 2.5668486452E+00, 9.2130995704E-01],
	[3.0555000000E+04, 2.1587931455E+01, 5.1708736914E+00, 6.6765609160E+00, 2.5674547173E+00, 9.2134712880E-01],
	[3.0560000000E+04, 2.1593790732E+01, 5.1708663708E+00, 6.6801114727E+00, 2.5680606745E+00, 9.2138428212E-01],
	[3.0565000000E+04, 2.1599650641E+01, 5.1708590514E+00, 6.6836633353E+00, 2.5686665170E+00, 9.2142141702E-01],
	[3.0570000000E+04, 2.1605511180E+01, 5.1708517333E+00, 6.6872165041E+00, 2.5692722445E+00, 9.2145853351E-01],
	[3.0575000000E+04, 2.1611372351E+01, 5.1708444163E+00, 6.6907709792E+00, 2.5698778571E+00, 9.2149563159E-01],
	[3.0580000000E+04, 2.1617234153E+01, 5.1708371006E+00, 6.6943267611E+00, 2.5704833547E+00, 9.2153271128E-01],
	[3.0585000000E+04, 2.1623096586E+01, 5.1708297861E+00, 6.6978838498E+00, 2.5710887374E+00, 9.2156977258E-01],
	[3.0590000000E+04, 2.1628959651E+01, 5.1708224727E+00, 6.7014422458E+00, 2.5716940050E+00, 9.2160681551E-01],
	[3.0595000000E+04, 2.1634823346E+01, 5.1708151606E+00, 6.7050019493E+00, 2.5722991577E+00, 9.2164384006E-01],
	[3.0600000000E+04, 2.1640687673E+01, 5.1708078497E+00, 6.7085629605E+00, 2.5729041952E+00, 9.2168084624E-01],
	[3.0605000000E+04, 2.1646552631E+01, 5.1708005400E+00, 6.7121252797E+00, 2.5735091177E+00, 9.2171783407E-01],
	[3.0610000000E+04, 2.1652418219E+01, 5.1707932315E+00, 6.7156889071E+00, 2.5741139250E+00, 9.2175480356E-01],
	[3.0615000000E+04, 2.1658284439E+01, 5.1707859242E+00, 6.7192538432E+00, 2.5747186171E+00, 9.2179175470E-01],
	[3.0620000000E+04, 2.1664151290E+01, 5.1707786181E+00, 6.7228200880E+00, 2.5753231941E+00, 9.2182868752E-01],
	[3.0625000000E+04, 2.1670018771E+01, 5.1707713132E+00, 6.7263876419E+00, 2.5759276559E+00, 9.2186560201E-01],
	[3.0630000000E+04, 2.1675886883E+01, 5.1707640095E+00, 6.7299565051E+00, 2.5765320024E+00, 9.2190249819E-01],
	[3.0635000000E+04, 2.1681755627E+01, 5.1707567070E+00, 6.7335266779E+00, 2.5771362336E+00, 9.2193937606E-01],
	[3.0640000000E+04, 2.1687625001E+01, 5.1707494057E+00, 6.7370981606E+00, 2.5777403496E+00, 9.2197623563E-01],
	[3.0645000000E+04, 2.1693495005E+01, 5.1707421057E+00, 6.7406709535E+00, 2.5783443502E+00, 9.2201307692E-01],
	[3.0650000000E+04, 2.1699365641E+01, 5.1707348068E+00, 6.7442450567E+00, 2.5789482354E+00, 9.2204989992E-01],
	[3.0655000000E+04, 2.1705236907E+01, 5.1707275091E+00, 6.7478204706E+00, 2.5795520053E+00, 9.2208670465E-01],
	[3.0660000000E+04, 2.1711108804E+01, 5.1707202126E+00, 6.7513971954E+00, 2.5801556597E+00, 9.2212349111E-01],
	[3.0665000000E+04, 2.1716981331E+01, 5.1707129173E+00, 6.7549752315E+00, 2.5807591987E+00, 9.2216025932E-01],
	[3.0670000000E+04, 2.1722854490E+01, 5.1707056232E+00, 6.7585545790E+00, 2.5813626222E+00, 9.2219700927E-01],
	[3.0675000000E+04, 2.1728728278E+01, 5.1706983304E+00, 6.7621352382E+00, 2.5819659302E+00, 9.2223374099E-01],
	[3.0680000000E+04, 2.1734602697E+01, 5.1706910387E+00, 6.7657172095E+00, 2.5825691227E+00, 9.2227045447E-01],
	[3.0685000000E+04, 2.1740477747E+01, 5.1706837482E+00, 6.7693004930E+00, 2.5831721996E+00, 9.2230714973E-01],
	[3.0690000000E+04, 2.1746353427E+01, 5.1706764589E+00, 6.7728850890E+00, 2.5837751609E+00, 9.2234382678E-01],
	[3.0695000000E+04, 2.1752229738E+01, 5.1706691708E+00, 6.7764709978E+00, 2.5843780067E+00, 9.2238048561E-01],
	[3.0700000000E+04, 2.1758106679E+01, 5.1706618839E+00, 6.7800582197E+00, 2.5849807367E+00, 9.2241712625E-01],
	[3.0705000000E+04, 2.1763984250E+01, 5.1706545982E+00, 6.7836467549E+00, 2.5855833511E+00, 9.2245374869E-01],
	[3.0710000000E+04, 2.1769862451E+01, 5.1706473137E+00, 6.7872366038E+00, 2.5861858498E+00, 9.2249035295E-01],
	[3.0715000000E+04, 2.1775741283E+01, 5.1706400304E+00, 6.7908277665E+00, 2.5867882327E+00, 9.2252693904E-01],
	[3.0720000000E+04, 2.1781620745E+01, 5.1706327483E+00, 6.7944202433E+00, 2.5873904999E+00, 9.2256350696E-01],
	[3.0725000000E+04, 2.1787500837E+01, 5.1706254674E+00, 6.7980140345E+00, 2.5879926514E+00, 9.2260005672E-01],
	[3.0730000000E+04, 2.1793381560E+01, 5.1706181877E+00, 6.8016091404E+00, 2.5885946869E+00, 9.2263658833E-01],
	[3.0735000000E+04, 2.1799262912E+01, 5.1706109092E+00, 6.8052055612E+00, 2.5891966067E+00, 9.2267310179E-01],
	[3.0740000000E+04, 2.1805144895E+01, 5.1706036318E+00, 6.8088032972E+00, 2.5897984106E+00, 9.2270959713E-01],
	[3.0745000000E+04, 2.1811027508E+01, 5.1705963557E+00, 6.8124023486E+00, 2.5904000986E+00, 9.2274607433E-01],
	[3.0750000000E+04, 2.1816910751E+01, 5.1705890808E+00, 6.8160027158E+00, 2.5910016706E+00, 9.2278253342E-01],
	[3.0755000000E+04, 2.1822794623E+01, 5.1705818070E+00, 6.8196043990E+00, 2.5916031267E+00, 9.2281897440E-01],
	[3.0760000000E+04, 2.1828679126E+01, 5.1705745345E+00, 6.8232073984E+00, 2.5922044668E+00, 9.2285539728E-01],
	[3.0765000000E+04, 2.1834564259E+01, 5.1705672631E+00, 6.8268117144E+00, 2.5928056910E+00, 9.2289180207E-01],
	[3.0770000000E+04, 2.1840450021E+01, 5.1705599929E+00, 6.8304173472E+00, 2.5934067990E+00, 9.2292818877E-01],
	[3.0775000000E+04, 2.1846336414E+01, 5.1705527240E+00, 6.8340242970E+00, 2.5940077910E+00, 9.2296455739E-01],
	[3.0780000000E+04, 2.1852223436E+01, 5.1705454562E+00, 6.8376325641E+00, 2.5946086670E+00, 9.2300090795E-01],
	[3.0785000000E+04, 2.1858111088E+01, 5.1705381896E+00, 6.8412421489E+00, 2.5952094268E+00, 9.2303724044E-01],
	[3.0790000000E+04, 2.1863999370E+01, 5.1705309242E+00, 6.8448530515E+00, 2.5958100704E+00, 9.2307355488E-01],
	[3.0795000000E+04, 2.1869888281E+01, 5.1705236599E+00, 6.8484652722E+00, 2.5964105979E+00, 9.2310985128E-01],
	[3.0800000000E+04, 2.1875777822E+01, 5.1705163969E+00, 6.8520788113E+00, 2.5970110092E+00, 9.2314612965E-01],
	[3.0805000000E+04, 2.1881667993E+01, 5.1705091351E+00, 6.8556936691E+00, 2.5976113043E+00, 9.2318238998E-01],
	[3.0810000000E+04, 2.1887558793E+01, 5.1705018744E+00, 6.8593098458E+00, 2.5982114831E+00, 9.2321863230E-01],
	[3.0815000000E+04, 2.1893450223E+01, 5.1704946150E+00, 6.8629273417E+00, 2.5988115456E+00, 9.2325485661E-01],
	[3.0820000000E+04, 2.1899342283E+01, 5.1704873567E+00, 6.8665461571E+00, 2.5994114918E+00, 9.2329106291E-01],
	[3.0825000000E+04, 2.1905234972E+01, 5.1704800996E+00, 6.8701662922E+00, 2.6000113217E+00, 9.2332725122E-01],
	[3.0830000000E+04, 2.1911128290E+01, 5.1704728437E+00, 6.8737877472E+00, 2.6006110352E+00, 9.2336342155E-01],
	[3.0835000000E+04, 2.1917022238E+01, 5.1704655890E+00, 6.8774105226E+00, 2.6012106323E+00, 9.2339957389E-01],
	[3.0840000000E+04, 2.1922916815E+01, 5.1704583355E+00, 6.8810346184E+00, 2.6018101130E+00, 9.2343570827E-01],
	[3.0845000000E+04, 2.1928812022E+01, 5.1704510831E+00, 6.8846600351E+00, 2.6024094773E+00, 9.2347182468E-01],
	[3.0850000000E+04, 2.1934707858E+01, 5.1704438320E+00, 6.8882867728E+00, 2.6030087251E+00, 9.2350792314E-01],
	[3.0855000000E+04, 2.1940604323E+01, 5.1704365820E+00, 6.8919148318E+00, 2.6036078564E+00, 9.2354400366E-01],
	[3.0860000000E+04, 2.1946501418E+01, 5.1704293332E+00, 6.8955442124E+00, 2.6042068712E+00, 9.2358006624E-01],
	[3.0865000000E+04, 2.1952399142E+01, 5.1704220856E+00, 6.8991749149E+00, 2.6048057694E+00, 9.2361611089E-01],
	[3.0870000000E+04, 2.1958297495E+01, 5.1704148392E+00, 6.9028069395E+00, 2.6054045511E+00, 9.2365213762E-01],
	[3.0875000000E+04, 2.1964196477E+01, 5.1704075940E+00, 6.9064402865E+00, 2.6060032161E+00, 9.2368814644E-01],
	[3.0880000000E+04, 2.1970102727E+01, 5.1704013385E+00, 6.9100749561E+00, 2.6066021093E+00, 9.2372413735E-01],
	[3.0885000000E+04, 2.1976023709E+01, 5.1703971833E+00, 6.9137109487E+00, 2.6072016182E+00, 9.2376011037E-01],
	[3.0890000000E+04, 2.1981945328E+01, 5.1703930287E+00, 6.9173482645E+00, 2.6078010111E+00, 9.2379606550E-01],
	[3.0895000000E+04, 2.1987867583E+01, 5.1703888749E+00, 6.9209869037E+00, 2.6084002880E+00, 9.2383200276E-01],
	[3.0900000000E+04, 2.1993790476E+01, 5.1703847217E+00, 6.9246268666E+00, 2.6089994488E+00, 9.2386792214E-01],
	[3.0905000000E+04, 2.1999714005E+01, 5.1703805691E+00, 6.9282681536E+00, 2.6095984935E+00, 9.2390382366E-01],
	[3.0910000000E+04, 2.2005638171E+01, 5.1703764173E+00, 6.9319107648E+00, 2.6101974221E+00, 9.2393970732E-01],
	[3.0915000000E+04, 2.2011562974E+01, 5.1703722661E+00, 6.9355547005E+00, 2.6107962345E+00, 9.2397557314E-01],
	[3.0920000000E+04, 2.2017488413E+01, 5.1703681156E+00, 6.9391999610E+00, 2.6113949308E+00, 9.2401142112E-01],
	[3.0925000000E+04, 2.2023414489E+01, 5.1703639658E+00, 6.9428465466E+00, 2.6119935108E+00, 9.2404725128E-01],
	[3.0930000000E+04, 2.2029341202E+01, 5.1703598167E+00, 6.9464944575E+00, 2.6125919746E+00, 9.2408306361E-01],
	[3.0935000000E+04, 2.2035268551E+01, 5.1703556682E+00, 6.9501436940E+00, 2.6131903222E+00, 9.2411885812E-01],
	[3.0940000000E+04, 2.2041196536E+01, 5.1703515204E+00, 6.9537942563E+00, 2.6137885535E+00, 9.2415463484E-01],
	[3.0945000000E+04, 2.2047125158E+01, 5.1703473733E+00, 6.9574461448E+00, 2.6143866685E+00, 9.2419039375E-01],
	[3.0950000000E+04, 2.2053054417E+01, 5.1703432268E+00, 6.9610993597E+00, 2.6149846671E+00, 9.2422613488E-01],
	[3.0955000000E+04, 2.2058984312E+01, 5.1703390811E+00, 6.9647539012E+00, 2.6155825494E+00, 9.2426185823E-01],
	[3.0960000000E+04, 2.2064914843E+01, 5.1703349360E+00, 6.9684097696E+00, 2.6161803153E+00, 9.2429756381E-01],
	[3.0965000000E+04, 2.2070846011E+01, 5.1703307915E+00, 6.9720669653E+00, 2.6167779648E+00, 9.2433325162E-01],
	[3.0970000000E+04, 2.2076777814E+01, 5.1703266478E+00, 6.9757254884E+00, 2.6173754979E+00, 9.2436892168E-01],
	[3.0975000000E+04, 2.2082710255E+01, 5.1703225047E+00, 6.9793853392E+00, 2.6179729145E+00, 9.2440457399E-01],
	[3.0980000000E+04, 2.2088643331E+01, 5.1703183623E+00, 6.9830465180E+00, 2.6185702147E+00, 9.2444020856E-01],
	[3.0985000000E+04, 2.2094577044E+01, 5.1703142205E+00, 6.9867090251E+00, 2.6191673983E+00, 9.2447582540E-01],
	[3.0990000000E+04, 2.2100511392E+01, 5.1703100794E+00, 6.9903728607E+00, 2.6197644654E+00, 9.2451142452E-01],
	[3.0995000000E+04, 2.2106446377E+01, 5.1703059390E+00, 6.9940380251E+00, 2.6203614159E+00, 9.2454700592E-01],
	[3.1000000000E+04, 2.2112381998E+01, 5.1703017993E+00, 6.9977045186E+00, 2.6209582498E+00, 9.2458256962E-01],
	[3.1005000000E+04, 2.2118318255E+01, 5.1702976603E+00, 7.0013723414E+00, 2.6215549672E+00, 9.2461811563E-01],
	[3.1010000000E+04, 2.2124255148E+01, 5.1702935219E+00, 7.0050414938E+00, 2.6221515679E+00, 9.2465364394E-01],
	[3.1015000000E+04, 2.2130192677E+01, 5.1702893842E+00, 7.0087119760E+00, 2.6227480519E+00, 9.2468915457E-01],
	[3.1020000000E+04, 2.2136130842E+01, 5.1702852471E+00, 7.0123837884E+00, 2.6233444192E+00, 9.2472464753E-01],
	[3.1025000000E+04, 2.2142069643E+01, 5.1702811107E+00, 7.0160569312E+00, 2.6239406699E+00, 9.2476012283E-01],
	[3.1030000000E+04, 2.2148009080E+01, 5.1702769750E+00, 7.0197314046E+00, 2.6245368038E+00, 9.2479558047E-01],
	[3.1035000000E+04, 2.2153949153E+01, 5.1702728400E+00, 7.0234072090E+00, 2.6251328209E+00, 9.2483102046E-01],
	[3.1040000000E+04, 2.2159889861E+01, 5.1702687056E+00, 7.0270843446E+00, 2.6257287213E+00, 9.2486644281E-01],
	[3.1045000000E+04, 2.2165831205E+01, 5.1702645719E+00, 7.0307628116E+00, 2.6263245049E+00, 9.2490184753E-01],
	[3.1050000000E+04, 2.2171773185E+01, 5.1702604389E+00, 7.0344426104E+00, 2.6269201716E+00, 9.2493723463E-01],
	[3.1055000000E+04, 2.2177715801E+01, 5.1702563065E+00, 7.0381237411E+00, 2.6275157214E+00, 9.2497260411E-01],
	[3.1060000000E+04, 2.2183659052E+01, 5.1702521748E+00, 7.0418062041E+00, 2.6281111544E+00, 9.2500795599E-01],
	[3.1065000000E+04, 2.2189602939E+01, 5.1702480438E+00, 7.0454899997E+00, 2.6287064705E+00, 9.2504329027E-01],
	[3.1070000000E+04, 2.2195547462E+01, 5.1702439135E+00, 7.0491751280E+00, 2.6293016696E+00, 9.2507860696E-01],
	[3.1075000000E+04, 2.2201492620E+01, 5.1702397838E+00, 7.0528615895E+00, 2.6298967518E+00, 9.2511390606E-01],
	[3.1080000000E+04, 2.2207438414E+01, 5.1702356548E+00, 7.0565493842E+00, 2.6304917170E+00, 9.2514918760E-01],
	[3.1085000000E+04, 2.2213384843E+01, 5.1702315264E+00, 7.0602385126E+00, 2.6310865652E+00, 9.2518445157E-01],
	[3.1090000000E+04, 2.2219331908E+01, 5.1702273987E+00, 7.0639289748E+00, 2.6316812964E+00, 9.2521969798E-01],
	[3.1095000000E+04, 2.2225279608E+01, 5.1702232717E+00, 7.0676207711E+00, 2.6322759105E+00, 9.2525492684E-01],
	[3.1100000000E+04, 2.2231227944E+01, 5.1702191454E+00, 7.0713139019E+00, 2.6328704076E+00, 9.2529013817E-01],
	[3.1105000000E+04, 2.2237176915E+01, 5.1702150197E+00, 7.0750083673E+00, 2.6334647875E+00, 9.2532533196E-01],
	[3.1110000000E+04, 2.2243126521E+01, 5.1702108947E+00, 7.0787041677E+00, 2.6340590504E+00, 9.2536050823E-01],
	[3.1115000000E+04, 2.2249076763E+01, 5.1702067703E+00, 7.0824013032E+00, 2.6346531960E+00, 9.2539566698E-01],
	[3.1120000000E+04, 2.2255027640E+01, 5.1702026466E+00, 7.0860997743E+00, 2.6352472245E+00, 9.2543080822E-01],
	[3.1125000000E+04, 2.2260979152E+01, 5.1701985236E+00, 7.0897995811E+00, 2.6358411359E+00, 9.2546593197E-01],
	[3.1130000000E+04, 2.2266931299E+01, 5.1701944012E+00, 7.0935007238E+00, 2.6364349300E+00, 9.2550103823E-01],
	[3.1135000000E+04, 2.2272884082E+01, 5.1701902796E+00, 7.0972032029E+00, 2.6370286068E+00, 9.2553612700E-01],
	[3.1140000000E+04, 2.2278837499E+01, 5.1701861585E+00, 7.1009070185E+00, 2.6376221664E+00, 9.2557119830E-01],
	[3.1145000000E+04, 2.2284791552E+01, 5.1701820382E+00, 7.1046121709E+00, 2.6382156087E+00, 9.2560625213E-01],
	[3.1150000000E+04, 2.2290746240E+01, 5.1701779185E+00, 7.1083186603E+00, 2.6388089337E+00, 9.2564128851E-01],
	[3.1155000000E+04, 2.2296701562E+01, 5.1701737995E+00, 7.1120264871E+00, 2.6394021413E+00, 9.2567630744E-01],
	[3.1160000000E+04, 2.2302657520E+01, 5.1701696811E+00, 7.1157356515E+00, 2.6399952316E+00, 9.2571130893E-01],
	[3.1165000000E+04, 2.2308614113E+01, 5.1701655634E+00, 7.1194461538E+00, 2.6405882045E+00, 9.2574629298E-01],
	[3.1170000000E+04, 2.2314571341E+01, 5.1701614464E+00, 7.1231579943E+00, 2.6411810600E+00, 9.2578125961E-01],
	[3.1175000000E+04, 2.2320529203E+01, 5.1701573300E+00, 7.1268711731E+00, 2.6417737980E+00, 9.2581620882E-01],
	[3.1180000000E+04, 2.2326487701E+01, 5.1701532143E+00, 7.1305856906E+00, 2.6423664187E+00, 9.2585114063E-01],
	[3.1185000000E+04, 2.2332446833E+01, 5.1701490992E+00, 7.1343015471E+00, 2.6429589218E+00, 9.2588605504E-01],
	[3.1190000000E+04, 2.2338406600E+01, 5.1701449848E+00, 7.1380187428E+00, 2.6435513074E+00, 9.2592095205E-01],
	[3.1195000000E+04, 2.2344367002E+01, 5.1701408711E+00, 7.1417372779E+00, 2.6441435755E+00, 9.2595583169E-01],
	[3.1200000000E+04, 2.2350328038E+01, 5.1701367581E+00, 7.1454571528E+00, 2.6447357261E+00, 9.2599069394E-01],
	[3.1205000000E+04, 2.2356289709E+01, 5.1701326457E+00, 7.1491783677E+00, 2.6453277591E+00, 9.2602553884E-01],
	[3.1210000000E+04, 2.2362252015E+01, 5.1701285339E+00, 7.1529009229E+00, 2.6459196745E+00, 9.2606036637E-01],
	[3.1215000000E+04, 2.2368214956E+01, 5.1701244229E+00, 7.1566248187E+00, 2.6465114723E+00, 9.2609517656E-01],
	[3.1220000000E+04, 2.2374178531E+01, 5.1701203124E+00, 7.1603500552E+00, 2.6471031525E+00, 9.2612996940E-01],
	[3.1225000000E+04, 2.2380142740E+01, 5.1701162027E+00, 7.1640766329E+00, 2.6476947150E+00, 9.2616474491E-01],
	[3.1230000000E+04, 2.2386107584E+01, 5.1701120936E+00, 7.1678045518E+00, 2.6482861598E+00, 9.2619950309E-01],
	[3.1235000000E+04, 2.2392073063E+01, 5.1701079852E+00, 7.1715338125E+00, 2.6488774869E+00, 9.2623424396E-01],
	[3.1240000000E+04, 2.2398039176E+01, 5.1701038774E+00, 7.1752644149E+00, 2.6494686963E+00, 9.2626896752E-01],
	[3.1245000000E+04, 2.2404005924E+01, 5.1700997703E+00, 7.1789963596E+00, 2.6500597879E+00, 9.2630367378E-01],
	[3.1250000000E+04, 2.2409973305E+01, 5.1700956639E+00, 7.1827296467E+00, 2.6506507618E+00, 9.2633836275E-01],
	[3.1255000000E+04, 2.2415941322E+01, 5.1700915581E+00, 7.1864642764E+00, 2.6512416178E+00, 9.2637303444E-01],
	[3.1260000000E+04, 2.2421909972E+01, 5.1700874530E+00, 7.1902002491E+00, 2.6518323561E+00, 9.2640768885E-01],
	[3.1265000000E+04, 2.2427879257E+01, 5.1700833485E+00, 7.1939375651E+00, 2.6524229765E+00, 9.2644232599E-01],
	[3.1270000000E+04, 2.2433849176E+01, 5.1700792447E+00, 7.1976762245E+00, 2.6530134791E+00, 9.2647694587E-01],
	[3.1275000000E+04, 2.2439819729E+01, 5.1700751415E+00, 7.2014162277E+00, 2.6536038637E+00, 9.2651154851E-01],
	[3.1280000000E+04, 2.2445790917E+01, 5.1700710391E+00, 7.2051575749E+00, 2.6541941305E+00, 9.2654613390E-01],
	[3.1285000000E+04, 2.2451762738E+01, 5.1700669372E+00, 7.2089002664E+00, 2.6547842793E+00, 9.2658070206E-01],
	[3.1290000000E+04, 2.2457735194E+01, 5.1700628361E+00, 7.2126443024E+00, 2.6553743102E+00, 9.2661525299E-01],
	[3.1295000000E+04, 2.2463708284E+01, 5.1700587356E+00, 7.2163896833E+00, 2.6559642231E+00, 9.2664978671E-01],
	[3.1300000000E+04, 2.2469682007E+01, 5.1700546357E+00, 7.2201364093E+00, 2.6565540181E+00, 9.2668430322E-01],
	[3.1305000000E+04, 2.2475656365E+01, 5.1700505365E+00, 7.2238844806E+00, 2.6571436950E+00, 9.2671880252E-01],
	[3.1310000000E+04, 2.2481631357E+01, 5.1700464380E+00, 7.2276338976E+00, 2.6577332538E+00, 9.2675328464E-01],
	[3.1315000000E+04, 2.2487606983E+01, 5.1700423401E+00, 7.2313846605E+00, 2.6583226947E+00, 9.2678774957E-01],
	[3.1320000000E+04, 2.2493583242E+01, 5.1700382429E+00, 7.2351367695E+00, 2.6589120174E+00, 9.2682219732E-01],
	[3.1325000000E+04, 2.2499560136E+01, 5.1700341463E+00, 7.2388902250E+00, 2.6595012220E+00, 9.2685662791E-01],
	[3.1330000000E+04, 2.2505537663E+01, 5.1700300504E+00, 7.2426450271E+00, 2.6600903085E+00, 9.2689104134E-01],
	[3.1335000000E+04, 2.2511515824E+01, 5.1700259552E+00, 7.2464011763E+00, 2.6606792769E+00, 9.2692543762E-01],
	[3.1340000000E+04, 2.2517494619E+01, 5.1700218606E+00, 7.2501586726E+00, 2.6612681271E+00, 9.2695981675E-01],
	[3.1345000000E+04, 2.2523474048E+01, 5.1700177666E+00, 7.2539175165E+00, 2.6618568591E+00, 9.2699417875E-01],
	[3.1350000000E+04, 2.2529454110E+01, 5.1700136734E+00, 7.2576777082E+00, 2.6624454729E+00, 9.2702852363E-01],
	[3.1355000000E+04, 2.2535434806E+01, 5.1700095807E+00, 7.2614392479E+00, 2.6630339685E+00, 9.2706285139E-01],
	[3.1360000000E+04, 2.2541416135E+01, 5.1700054888E+00, 7.2652021358E+00, 2.6636223458E+00, 9.2709716203E-01],
	[3.1365000000E+04, 2.2547398099E+01, 5.1700013974E+00, 7.2689663724E+00, 2.6642106048E+00, 9.2713145558E-01],
	[3.1370000000E+04, 2.2553380695E+01, 5.1699973068E+00, 7.2727319578E+00, 2.6647987456E+00, 9.2716573204E-01],
	[3.1375000000E+04, 2.2559363926E+01, 5.1699932168E+00, 7.2764988923E+00, 2.6653867680E+00, 9.2719999141E-01],
	[3.1380000000E+04, 2.2565366283E+01, 5.1699918500E+00, 7.2802671762E+00, 2.6659756542E+00, 9.2723423370E-01],
	[3.1385000000E+04, 2.2571371333E+01, 5.1699907856E+00, 7.2840368098E+00, 2.6665645317E+00, 9.2726845892E-01],
	[3.1390000000E+04, 2.2577377025E+01, 5.1699897214E+00, 7.2878077932E+00, 2.6671532914E+00, 9.2730266709E-01],
	[3.1395000000E+04, 2.2583383358E+01, 5.1699886573E+00, 7.2915801268E+00, 2.6677419333E+00, 9.2733685821E-01],
	[3.1400000000E+04, 2.2589390331E+01, 5.1699875934E+00, 7.2953538109E+00, 2.6683304575E+00, 9.2737103228E-01],
	[3.1405000000E+04, 2.2595397946E+01, 5.1699865297E+00, 7.2991288457E+00, 2.6689188638E+00, 9.2740518931E-01],
	[3.1410000000E+04, 2.2601406202E+01, 5.1699854661E+00, 7.3029052315E+00, 2.6695071523E+00, 9.2743932932E-01],
	[3.1415000000E+04, 2.2607415098E+01, 5.1699844028E+00, 7.3066829685E+00, 2.6700953230E+00, 9.2747345232E-01],
	[3.1420000000E+04, 2.2613424635E+01, 5.1699833396E+00, 7.3104620571E+00, 2.6706833758E+00, 9.2750755830E-01],
	[3.1425000000E+04, 2.2619434814E+01, 5.1699822765E+00, 7.3142424974E+00, 2.6712713108E+00, 9.2754164728E-01],
	[3.1430000000E+04, 2.2625445633E+01, 5.1699812136E+00, 7.3180242898E+00, 2.6718591278E+00, 9.2757571927E-01],
	[3.1435000000E+04, 2.2631457092E+01, 5.1699801509E+00, 7.3218074345E+00, 2.6724468269E+00, 9.2760977427E-01],
	[3.1440000000E+04, 2.2637469193E+01, 5.1699790884E+00, 7.3255919318E+00, 2.6730344080E+00, 9.2764381229E-01],
	[3.1445000000E+04, 2.2643481934E+01, 5.1699780260E+00, 7.3293777820E+00, 2.6736218712E+00, 9.2767783335E-01],
	[3.1450000000E+04, 2.2649495316E+01, 5.1699769639E+00, 7.3331649853E+00, 2.6742092164E+00, 9.2771183745E-01],
	[3.1455000000E+04, 2.2655509339E+01, 5.1699759018E+00, 7.3369535419E+00, 2.6747964436E+00, 9.2774582459E-01],
	[3.1460000000E+04, 2.2661524002E+01, 5.1699748400E+00, 7.3407434523E+00, 2.6753835527E+00, 9.2777979479E-01],
	[3.1465000000E+04, 2.2667539305E+01, 5.1699737783E+00, 7.3445347165E+00, 2.6759705438E+00, 9.2781374806E-01],
	[3.1470000000E+04, 2.2673555250E+01, 5.1699727168E+00, 7.3483273350E+00, 2.6765574168E+00, 9.2784768440E-01],
	[3.1475000000E+04, 2.2679571834E+01, 5.1699716554E+00, 7.3521213079E+00, 2.6771441717E+00, 9.2788160382E-01],
	[3.1480000000E+04, 2.2685589059E+01, 5.1699705942E+00, 7.3559166356E+00, 2.6777308085E+00, 9.2791550633E-01],
	[3.1485000000E+04, 2.2691606925E+01, 5.1699695332E+00, 7.3597133183E+00, 2.6783173272E+00, 9.2794939193E-01],
	[3.1490000000E+04, 2.2697625431E+01, 5.1699684724E+00, 7.3635113562E+00, 2.6789037278E+00, 9.2798326065E-01],
	[3.1495000000E+04, 2.2703644577E+01, 5.1699674117E+00, 7.3673107497E+00, 2.6794900101E+00, 9.2801711247E-01],
	[3.1500000000E+04, 2.2709664364E+01, 5.1699663512E+00, 7.3711114990E+00, 2.6800761743E+00, 9.2805094742E-01],
	[3.1505000000E+04, 2.2715684791E+01, 5.1699652909E+00, 7.3749136043E+00, 2.6806622202E+00, 9.2808476550E-01],
	[3.1510000000E+04, 2.2721705858E+01, 5.1699642307E+00, 7.3787170660E+00, 2.6812481479E+00, 9.2811856672E-01],
	[3.1515000000E+04, 2.2727727566E+01, 5.1699631707E+00, 7.3825218843E+00, 2.6818339574E+00, 9.2815235109E-01],
	[3.1520000000E+04, 2.2733749914E+01, 5.1699621109E+00, 7.3863280595E+00, 2.6824196486E+00, 9.2818611862E-01],
	[3.1525000000E+04, 2.2739772901E+01, 5.1699610512E+00, 7.3901355918E+00, 2.6830052215E+00, 9.2821986930E-01],
	[3.1530000000E+04, 2.2745796529E+01, 5.1699599917E+00, 7.3939444816E+00, 2.6835906761E+00, 9.2825360316E-01],
	[3.1535000000E+04, 2.2751820798E+01, 5.1699589324E+00, 7.3977547290E+00, 2.6841760123E+00, 9.2828732020E-01],
	[3.1540000000E+04, 2.2757845706E+01, 5.1699578732E+00, 7.4015663343E+00, 2.6847612302E+00, 9.2832102043E-01],
	[3.1545000000E+04, 2.2763871254E+01, 5.1699568142E+00, 7.4053792979E+00, 2.6853463298E+00, 9.2835470386E-01],
	[3.1550000000E+04, 2.2769897442E+01, 5.1699557554E+00, 7.4091936200E+00, 2.6859313109E+00, 9.2838837049E-01],
	[3.1555000000E+04, 2.2775924270E+01, 5.1699546967E+00, 7.4130093008E+00, 2.6865161736E+00, 9.2842202033E-01],
	[3.1560000000E+04, 2.2781951738E+01, 5.1699536383E+00, 7.4168263406E+00, 2.6871009179E+00, 9.2845565340E-01],
	[3.1565000000E+04, 2.2787979846E+01, 5.1699525799E+00, 7.4206447398E+00, 2.6876855438E+00, 9.2848926970E-01],
	[3.1570000000E+04, 2.2794008594E+01, 5.1699515218E+00, 7.4244644985E+00, 2.6882700512E+00, 9.2852286923E-01],
	[3.1575000000E+04, 2.2800037982E+01, 5.1699504638E+00, 7.4282856170E+00, 2.6888544401E+00, 9.2855645202E-01],
	[3.1580000000E+04, 2.2806068009E+01, 5.1699494060E+00, 7.4321080956E+00, 2.6894387105E+00, 9.2859001805E-01],
	[3.1585000000E+04, 2.2812098676E+01, 5.1699483483E+00, 7.4359319346E+00, 2.6900228623E+00, 9.2862356736E-01],
	[3.1590000000E+04, 2.2818129983E+01, 5.1699472909E+00, 7.4397571341E+00, 2.6906068957E+00, 9.2865709993E-01],
	[3.1595000000E+04, 2.2824161930E+01, 5.1699462336E+00, 7.4435836946E+00, 2.6911908104E+00, 9.2869061578E-01],
	[3.1600000000E+04, 2.2830194516E+01, 5.1699451764E+00, 7.4474116163E+00, 2.6917746066E+00, 9.2872411492E-01],
	[3.1605000000E+04, 2.2836227742E+01, 5.1699441194E+00, 7.4512408994E+00, 2.6923582842E+00, 9.2875759736E-01],
	[3.1610000000E+04, 2.2842261608E+01, 5.1699430626E+00, 7.4550715442E+00, 2.6929418431E+00, 9.2879106310E-01],
	[3.1615000000E+04, 2.2848296113E+01, 5.1699420060E+00, 7.4589035510E+00, 2.6935252834E+00, 9.2882451215E-01],
	[3.1620000000E+04, 2.2854331257E+01, 5.1699409495E+00, 7.4627369200E+00, 2.6941086051E+00, 9.2885794453E-01],
	[3.1625000000E+04, 2.2860367042E+01, 5.1699398932E+00, 7.4665716515E+00, 2.6946918081E+00, 9.2889136023E-01],
	[3.1630000000E+04, 2.2866403465E+01, 5.1699388370E+00, 7.4704077458E+00, 2.6952748924E+00, 9.2892475928E-01],
	[3.1635000000E+04, 2.2872440528E+01, 5.1699377811E+00, 7.4742452031E+00, 2.6958578579E+00, 9.2895814167E-01],
	[3.1640000000E+04, 2.2878478231E+01, 5.1699367253E+00, 7.4780840238E+00, 2.6964407048E+00, 9.2899150741E-01],
	[3.1645000000E+04, 2.2884516572E+01, 5.1699356696E+00, 7.4819242080E+00, 2.6970234328E+00, 9.2902485651E-01],
	[3.1650000000E+04, 2.2890555553E+01, 5.1699346142E+00, 7.4857657561E+00, 2.6976060422E+00, 9.2905818899E-01],
	[3.1655000000E+04, 2.2896595174E+01, 5.1699335588E+00, 7.4896086682E+00, 2.6981885327E+00, 9.2909150485E-01],
	[3.1660000000E+04, 2.2902635433E+01, 5.1699325037E+00, 7.4934529448E+00, 2.6987709044E+00, 9.2912480409E-01],
	[3.1665000000E+04, 2.2908676332E+01, 5.1699314487E+00, 7.4972985860E+00, 2.6993531573E+00, 9.2915808673E-01],
	[3.1670000000E+04, 2.2914717870E+01, 5.1699303939E+00, 7.5011455922E+00, 2.6999352913E+00, 9.2919135277E-01],
	[3.1675000000E+04, 2.2920760048E+01, 5.1699293393E+00, 7.5049939635E+00, 2.7005173065E+00, 9.2922460222E-01],
	[3.1680000000E+04, 2.2926802864E+01, 5.1699282848E+00, 7.5088437003E+00, 2.7010992028E+00, 9.2925783510E-01],
	[3.1685000000E+04, 2.2932846319E+01, 5.1699272305E+00, 7.5126948028E+00, 2.7016809802E+00, 9.2929105140E-01],
	[3.1690000000E+04, 2.2938890414E+01, 5.1699261764E+00, 7.5165472713E+00, 2.7022626387E+00, 9.2932425114E-01],
	[3.1695000000E+04, 2.2944935148E+01, 5.1699251224E+00, 7.5204011061E+00, 2.7028441783E+00, 9.2935743433E-01],
	[3.1700000000E+04, 2.2950980520E+01, 5.1699240686E+00, 7.5242563074E+00, 2.7034255989E+00, 9.2939060097E-01],
	[3.1705000000E+04, 2.2957026532E+01, 5.1699230150E+00, 7.5281128755E+00, 2.7040069005E+00, 9.2942375107E-01],
	[3.1710000000E+04, 2.2963073182E+01, 5.1699219615E+00, 7.5319708107E+00, 2.7045880832E+00, 9.2945688464E-01],
	[3.1715000000E+04, 2.2969120471E+01, 5.1699209082E+00, 7.5358301132E+00, 2.7051691468E+00, 9.2949000168E-01],
	[3.1720000000E+04, 2.2975168400E+01, 5.1699198550E+00, 7.5396907833E+00, 2.7057500915E+00, 9.2952310222E-01],
	[3.1725000000E+04, 2.2981216967E+01, 5.1699188021E+00, 7.5435528213E+00, 2.7063309170E+00, 9.2955618625E-01],
	[3.1730000000E+04, 2.2987266172E+01, 5.1699177493E+00, 7.5474162275E+00, 2.7069116236E+00, 9.2958925378E-01],
	[3.1735000000E+04, 2.2993316017E+01, 5.1699166966E+00, 7.5512810020E+00, 2.7074922110E+00, 9.2962230483E-01],
	[3.1740000000E+04, 2.2999366500E+01, 5.1699156441E+00, 7.5551471452E+00, 2.7080726793E+00, 9.2965533939E-01],
	[3.1745000000E+04, 2.3005417622E+01, 5.1699145918E+00, 7.5590146574E+00, 2.7086530286E+00, 9.2968835748E-01],
	[3.1750000000E+04, 2.3011469383E+01, 5.1699135397E+00, 7.5628835388E+00, 2.7092332587E+00, 9.2972135911E-01],
	[3.1755000000E+04, 2.3017521782E+01, 5.1699124877E+00, 7.5667537896E+00, 2.7098133696E+00, 9.2975434428E-01],
	[3.1760000000E+04, 2.3023574820E+01, 5.1699114359E+00, 7.5706254103E+00, 2.7103933614E+00, 9.2978731300E-01],
	[3.1765000000E+04, 2.3029628497E+01, 5.1699103842E+00, 7.5744984009E+00, 2.7109732340E+00, 9.2982026528E-01],
	[3.1770000000E+04, 2.3035682812E+01, 5.1699093328E+00, 7.5783727618E+00, 2.7115529875E+00, 9.2985320114E-01],
	[3.1775000000E+04, 2.3041737765E+01, 5.1699082814E+00, 7.5822484933E+00, 2.7121326217E+00, 9.2988612057E-01],
	[3.1780000000E+04, 2.3047793357E+01, 5.1699072303E+00, 7.5861255956E+00, 2.7127121366E+00, 9.2991902358E-01],
	[3.1785000000E+04, 2.3053849588E+01, 5.1699061793E+00, 7.5900040690E+00, 2.7132915323E+00, 9.2995191019E-01],
	[3.1790000000E+04, 2.3059906456E+01, 5.1699051285E+00, 7.5938839138E+00, 2.7138708088E+00, 9.2998478040E-01],
	[3.1795000000E+04, 2.3065963963E+01, 5.1699040778E+00, 7.5977651302E+00, 2.7144499659E+00, 9.3001763422E-01],
	[3.1800000000E+04, 2.3072022109E+01, 5.1699030274E+00, 7.6016477185E+00, 2.7150290038E+00, 9.3005047166E-01],
	[3.1805000000E+04, 2.3078080893E+01, 5.1699019770E+00, 7.6055316790E+00, 2.7156079223E+00, 9.3008329273E-01],
	[3.1810000000E+04, 2.3084140315E+01, 5.1699009269E+00, 7.6094170119E+00, 2.7161867215E+00, 9.3011609743E-01],
	[3.1815000000E+04, 2.3090200375E+01, 5.1698998769E+00, 7.6133037175E+00, 2.7167654014E+00, 9.3014888577E-01],
	[3.1820000000E+04, 2.3096261074E+01, 5.1698988271E+00, 7.6171917961E+00, 2.7173439619E+00, 9.3018165776E-01],
	[3.1825000000E+04, 2.3102322410E+01, 5.1698977774E+00, 7.6210812479E+00, 2.7179224030E+00, 9.3021441342E-01],
	[3.1830000000E+04, 2.3108384385E+01, 5.1698967279E+00, 7.6249720733E+00, 2.7185007246E+00, 9.3024715274E-01],
	[3.1835000000E+04, 2.3114446998E+01, 5.1698956786E+00, 7.6288642724E+00, 2.7190789269E+00, 9.3027987574E-01],
	[3.1840000000E+04, 2.3120510249E+01, 5.1698946294E+00, 7.6327578456E+00, 2.7196570098E+00, 9.3031258242E-01],
	[3.1845000000E+04, 2.3126574138E+01, 5.1698935804E+00, 7.6366527930E+00, 2.7202349731E+00, 9.3034527280E-01],
	[3.1850000000E+04, 2.3132638665E+01, 5.1698925316E+00, 7.6405491151E+00, 2.7208128170E+00, 9.3037794687E-01],
	[3.1855000000E+04, 2.3138703830E+01, 5.1698914829E+00, 7.6444468121E+00, 2.7213905415E+00, 9.3041060466E-01],
	[3.1860000000E+04, 2.3144769633E+01, 5.1698904344E+00, 7.6483458841E+00, 2.7219681464E+00, 9.3044324616E-01],
	[3.1865000000E+04, 2.3150836073E+01, 5.1698893860E+00, 7.6522463316E+00, 2.7225456318E+00, 9.3047587138E-01],
	[3.1870000000E+04, 2.3156903152E+01, 5.1698883379E+00, 7.6561481547E+00, 2.7231229977E+00, 9.3050848034E-01],
	[3.1875000000E+04, 2.3162970869E+01, 5.1698872899E+00, 7.6600513537E+00, 2.7237002440E+00, 9.3054107305E-01],
	[3.1880000000E+04, 2.3169039223E+01, 5.1698862420E+00, 7.6639559290E+00, 2.7242773707E+00, 9.3057364950E-01],
	[3.1885000000E+04, 2.3175126112E+01, 5.1698878004E+00, 7.6678618807E+00, 2.7248553493E+00, 9.3060620971E-01],
	[3.1890000000E+04, 2.3181216097E+01, 5.1698897156E+00, 7.6717692091E+00, 2.7254333419E+00, 9.3063875369E-01],
	[3.1895000000E+04, 2.3187306728E+01, 5.1698916304E+00, 7.6756779146E+00, 2.7260112154E+00, 9.3067128144E-01],
	[3.1900000000E+04, 2.3193398004E+01, 5.1698935449E+00, 7.6795879973E+00, 2.7265889700E+00, 9.3070379297E-01],
	[3.1905000000E+04, 2.3199489925E+01, 5.1698954591E+00, 7.6834994575E+00, 2.7271666055E+00, 9.3073628830E-01],
	[3.1910000000E+04, 2.3205582491E+01, 5.1698973731E+00, 7.6874122956E+00, 2.7277441220E+00, 9.3076876742E-01],
	[3.1915000000E+04, 2.3211675702E+01, 5.1698992867E+00, 7.6913265118E+00, 2.7283215194E+00, 9.3080123036E-01],
	[3.1920000000E+04, 2.3217769558E+01, 5.1699012000E+00, 7.6952421063E+00, 2.7288987978E+00, 9.3083367710E-01],
	[3.1925000000E+04, 2.3223864059E+01, 5.1699031131E+00, 7.6991590794E+00, 2.7294759570E+00, 9.3086610768E-01],
	[3.1930000000E+04, 2.3229959205E+01, 5.1699050258E+00, 7.7030774314E+00, 2.7300529971E+00, 9.3089852208E-01],
	[3.1935000000E+04, 2.3236054996E+01, 5.1699069382E+00, 7.7069971626E+00, 2.7306299181E+00, 9.3093092032E-01],
	[3.1940000000E+04, 2.3242151432E+01, 5.1699088504E+00, 7.7109182732E+00, 2.7312067200E+00, 9.3096330241E-01],
	[3.1945000000E+04, 2.3248248512E+01, 5.1699107622E+00, 7.7148407634E+00, 2.7317834026E+00, 9.3099566835E-01],
	[3.1950000000E+04, 2.3254346238E+01, 5.1699126738E+00, 7.7187646337E+00, 2.7323599662E+00, 9.3102801815E-01],
	[3.1955000000E+04, 2.3260444608E+01, 5.1699145850E+00, 7.7226898841E+00, 2.7329364105E+00, 9.3106035182E-01],
	[3.1960000000E+04, 2.3266543623E+01, 5.1699164960E+00, 7.7266165151E+00, 2.7335127356E+00, 9.3109266936E-01],
	[3.1965000000E+04, 2.3272643283E+01, 5.1699184066E+00, 7.7305445269E+00, 2.7340889415E+00, 9.3112497078E-01],
	[3.1970000000E+04, 2.3278743588E+01, 5.1699203169E+00, 7.7344739196E+00, 2.7346650281E+00, 9.3115725609E-01],
	[3.1975000000E+04, 2.3284844537E+01, 5.1699222270E+00, 7.7384046937E+00, 2.7352409955E+00, 9.3118952529E-01],
	[3.1980000000E+04, 2.3290946131E+01, 5.1699241368E+00, 7.7423368494E+00, 2.7358168436E+00, 9.3122177840E-01],
	[3.1985000000E+04, 2.3297048369E+01, 5.1699260462E+00, 7.7462703869E+00, 2.7363925724E+00, 9.3125401542E-01],
	[3.1990000000E+04, 2.3303151252E+01, 5.1699279554E+00, 7.7502053065E+00, 2.7369681820E+00, 9.3128623635E-01],
	[3.1995000000E+04, 2.3309254780E+01, 5.1699298642E+00, 7.7541416085E+00, 2.7375436722E+00, 9.3131844121E-01],
	[3.2000000000E+04, 2.3315358952E+01, 5.1699317728E+00, 7.7580792931E+00, 2.7381190431E+00, 9.3135063000E-01],
	[3.2005000000E+04, 2.3321463768E+01, 5.1699336810E+00, 7.7620183607E+00, 2.7386942946E+00, 9.3138280272E-01],
	[3.2010000000E+04, 2.3327569229E+01, 5.1699355890E+00, 7.7659588115E+00, 2.7392694267E+00, 9.3141495940E-01],
	[3.2015000000E+04, 2.3333675334E+01, 5.1699374967E+00, 7.7699006457E+00, 2.7398444395E+00, 9.3144710002E-01],
	[3.2020000000E+04, 2.3339782084E+01, 5.1699394041E+00, 7.7738438636E+00, 2.7404193329E+00, 9.3147922461E-01],
	[3.2025000000E+04, 2.3345889478E+01, 5.1699413111E+00, 7.7777884656E+00, 2.7409941069E+00, 9.3151133316E-01],
	[3.2030000000E+04, 2.3351997516E+01, 5.1699432179E+00, 7.7817344518E+00, 2.7415687615E+00, 9.3154342569E-01],
	[3.2035000000E+04, 2.3358106199E+01, 5.1699451244E+00, 7.7856818225E+00, 2.7421432966E+00, 9.3157550219E-01],
	[3.2040000000E+04, 2.3364215526E+01, 5.1699470306E+00, 7.7896305780E+00, 2.7427177123E+00, 9.3160756269E-01],
	[3.2045000000E+04, 2.3370325497E+01, 5.1699489365E+00, 7.7935807187E+00, 2.7432920085E+00, 9.3163960718E-01],
	[3.2050000000E+04, 2.3376436112E+01, 5.1699508420E+00, 7.7975322446E+00, 2.7438661852E+00, 9.3167163568E-01],
	[3.2055000000E+04, 2.3382547372E+01, 5.1699527473E+00, 7.8014851562E+00, 2.7444402424E+00, 9.3170364819E-01],
	[3.2060000000E+04, 2.3388659275E+01, 5.1699546523E+00, 7.8054394536E+00, 2.7450141802E+00, 9.3173564471E-01],
	[3.2065000000E+04, 2.3394771823E+01, 5.1699565570E+00, 7.8093951372E+00, 2.7455879983E+00, 9.3176762526E-01],
	[3.2070000000E+04, 2.3400885014E+01, 5.1699584614E+00, 7.8133522072E+00, 2.7461616970E+00, 9.3179958984E-01],
	[3.2075000000E+04, 2.3406998850E+01, 5.1699603656E+00, 7.8173106639E+00, 2.7467352761E+00, 9.3183153846E-01],
	[3.2080000000E+04, 2.3413113329E+01, 5.1699622694E+00, 7.8212705076E+00, 2.7473087356E+00, 9.3186347113E-01],
	[3.2085000000E+04, 2.3419228453E+01, 5.1699641729E+00, 7.8252317384E+00, 2.7478820755E+00, 9.3189538785E-01],
	[3.2090000000E+04, 2.3425344220E+01, 5.1699660761E+00, 7.8291943568E+00, 2.7484552959E+00, 9.3192728863E-01],
	[3.2095000000E+04, 2.3431460632E+01, 5.1699679790E+00, 7.8331583630E+00, 2.7490283966E+00, 9.3195917347E-01],
	[3.2100000000E+04, 2.3437577687E+01, 5.1699698817E+00, 7.8371237571E+00, 2.7496013777E+00, 9.3199104240E-01],
	[3.2105000000E+04, 2.3443695386E+01, 5.1699717840E+00, 7.8410905396E+00, 2.7501742391E+00, 9.3202289541E-01],
	[3.2110000000E+04, 2.3449813729E+01, 5.1699736860E+00, 7.8450587106E+00, 2.7507469809E+00, 9.3205473250E-01],
	[3.2115000000E+04, 2.3455932715E+01, 5.1699755878E+00, 7.8490282705E+00, 2.7513196030E+00, 9.3208655369E-01],
	[3.2120000000E+04, 2.3462052346E+01, 5.1699774892E+00, 7.8529992195E+00, 2.7518921055E+00, 9.3211835899E-01],
	[3.2125000000E+04, 2.3468172620E+01, 5.1699793904E+00, 7.8569715579E+00, 2.7524644882E+00, 9.3215014840E-01],
	[3.2130000000E+04, 2.3474293537E+01, 5.1699812912E+00, 7.8609452859E+00, 2.7530367512E+00, 9.3218192193E-01],
	[3.2135000000E+04, 2.3480415099E+01, 5.1699831918E+00, 7.8649204038E+00, 2.7536088945E+00, 9.3221367958E-01],
	[3.2140000000E+04, 2.3486537303E+01, 5.1699850920E+00, 7.8688969119E+00, 2.7541809180E+00, 9.3224542137E-01],
	[3.2145000000E+04, 2.3492660152E+01, 5.1699869920E+00, 7.8728748105E+00, 2.7547528218E+00, 9.3227714729E-01],
	[3.2150000000E+04, 2.3498783644E+01, 5.1699888917E+00, 7.8768540998E+00, 2.7553246059E+00, 9.3230885737E-01],
	[3.2155000000E+04, 2.3504907779E+01, 5.1699907911E+00, 7.8808347801E+00, 2.7558962701E+00, 9.3234055159E-01],
	[3.2160000000E+04, 2.3511032558E+01, 5.1699926902E+00, 7.8848168516E+00, 2.7564678145E+00, 9.3237222998E-01],
	[3.2165000000E+04, 2.3517157980E+01, 5.1699945890E+00, 7.8888003147E+00, 2.7570392392E+00, 9.3240389254E-01],
	[3.2170000000E+04, 2.3523284046E+01, 5.1699964875E+00, 7.8927851696E+00, 2.7576105440E+00, 9.3243553928E-01],
	[3.2175000000E+04, 2.3529410755E+01, 5.1699983857E+00, 7.8967714165E+00, 2.7581817289E+00, 9.3246717020E-01],
	[3.2180000000E+04, 2.3535538107E+01, 5.1700002836E+00, 7.9007590558E+00, 2.7587527941E+00, 9.3249878531E-01],
	[3.2185000000E+04, 2.3541666103E+01, 5.1700021812E+00, 7.9047480877E+00, 2.7593237393E+00, 9.3253038462E-01],
	[3.2190000000E+04, 2.3547794742E+01, 5.1700040785E+00, 7.9087385125E+00, 2.7598945647E+00, 9.3256196813E-01],
	[3.2195000000E+04, 2.3553924024E+01, 5.1700059755E+00, 7.9127303305E+00, 2.7604652702E+00, 9.3259353586E-01],
	[3.2200000000E+04, 2.3560053949E+01, 5.1700078723E+00, 7.9167235418E+00, 2.7610358557E+00, 9.3262508781E-01],
	[3.2205000000E+04, 2.3566184518E+01, 5.1700097687E+00, 7.9207181469E+00, 2.7616063214E+00, 9.3265662398E-01],
	[3.2210000000E+04, 2.3572315730E+01, 5.1700116649E+00, 7.9247141458E+00, 2.7621766671E+00, 9.3268814439E-01],
	[3.2215000000E+04, 2.3578447584E+01, 5.1700135607E+00, 7.9287115391E+00, 2.7627468929E+00, 9.3271964904E-01],
	[3.2220000000E+04, 2.3584580082E+01, 5.1700154563E+00, 7.9327103268E+00, 2.7633169987E+00, 9.3275113794E-01],
	[3.2225000000E+04, 2.3590713223E+01, 5.1700173515E+00, 7.9367105093E+00, 2.7638869845E+00, 9.3278261109E-01],
	[3.2230000000E+04, 2.3596847007E+01, 5.1700192465E+00, 7.9407120868E+00, 2.7644568504E+00, 9.3281406851E-01],
	[3.2235000000E+04, 2.3602981434E+01, 5.1700211412E+00, 7.9447150596E+00, 2.7650265963E+00, 9.3284551020E-01],
	[3.2240000000E+04, 2.3609116504E+01, 5.1700230356E+00, 7.9487194280E+00, 2.7655962221E+00, 9.3287693617E-01],
	[3.2245000000E+04, 2.3615252216E+01, 5.1700249297E+00, 7.9527251922E+00, 2.7661657279E+00, 9.3290834642E-01],
	[3.2250000000E+04, 2.3621388572E+01, 5.1700268235E+00, 7.9567323526E+00, 2.7667351137E+00, 9.3293974096E-01],
	[3.2255000000E+04, 2.3627525571E+01, 5.1700287170E+00, 7.9607409093E+00, 2.7673043794E+00, 9.3297111981E-01],
	[3.2260000000E+04, 2.3633663212E+01, 5.1700306102E+00, 7.9647508627E+00, 2.7678735251E+00, 9.3300248296E-01],
	[3.2265000000E+04, 2.3639801496E+01, 5.1700325031E+00, 7.9687622130E+00, 2.7684425507E+00, 9.3303383042E-01],
	[3.2270000000E+04, 2.3645940423E+01, 5.1700343957E+00, 7.9727749605E+00, 2.7690114562E+00, 9.3306516221E-01],
	[3.2275000000E+04, 2.3652079992E+01, 5.1700362881E+00, 7.9767891054E+00, 2.7695802416E+00, 9.3309647832E-01],
	[3.2280000000E+04, 2.3658220204E+01, 5.1700381801E+00, 7.9808046481E+00, 2.7701489069E+00, 9.3312777878E-01],
	[3.2285000000E+04, 2.3664361059E+01, 5.1700400719E+00, 7.9848215888E+00, 2.7707174520E+00, 9.3315906357E-01],
	[3.2290000000E+04, 2.3670502557E+01, 5.1700419633E+00, 7.9888399277E+00, 2.7712858770E+00, 9.3319033271E-01],
	[3.2295000000E+04, 2.3676644697E+01, 5.1700438545E+00, 7.9928596652E+00, 2.7718541819E+00, 9.3322158622E-01],
	[3.2300000000E+04, 2.3682787479E+01, 5.1700457454E+00, 7.9968808015E+00, 2.7724223666E+00, 9.3325282408E-01],
	[3.2305000000E+04, 2.3688930904E+01, 5.1700476359E+00, 8.0009033368E+00, 2.7729904311E+00, 9.3328404632E-01],
	[3.2310000000E+04, 2.3695074972E+01, 5.1700495262E+00, 8.0049272715E+00, 2.7735583754E+00, 9.3331525294E-01],
	[3.2315000000E+04, 2.3701219682E+01, 5.1700514162E+00, 8.0089526059E+00, 2.7741261996E+00, 9.3334644395E-01],
	[3.2320000000E+04, 2.3707365034E+01, 5.1700533059E+00, 8.0129793401E+00, 2.7746939035E+00, 9.3337761935E-01],
	[3.2325000000E+04, 2.3713511029E+01, 5.1700551954E+00, 8.0170074744E+00, 2.7752614872E+00, 9.3340877915E-01],
	[3.2330000000E+04, 2.3719657666E+01, 5.1700570845E+00, 8.0210370092E+00, 2.7758289506E+00, 9.3343992336E-01],
	[3.2335000000E+04, 2.3725804946E+01, 5.1700589733E+00, 8.0250679447E+00, 2.7763962938E+00, 9.3347105199E-01],
	[3.2340000000E+04, 2.3731952868E+01, 5.1700608619E+00, 8.0291002812E+00, 2.7769635167E+00, 9.3350216503E-01],
	[3.2345000000E+04, 2.3738101432E+01, 5.1700627501E+00, 8.0331340189E+00, 2.7775306194E+00, 9.3353326251E-01],
	[3.2350000000E+04, 2.3744250638E+01, 5.1700646381E+00, 8.0371691580E+00, 2.7780976018E+00, 9.3356434443E-01],
	[3.2355000000E+04, 2.3750400487E+01, 5.1700665257E+00, 8.0412056990E+00, 2.7786644638E+00, 9.3359541079E-01],
	[3.2360000000E+04, 2.3756550978E+01, 5.1700684131E+00, 8.0452436420E+00, 2.7792312056E+00, 9.3362646161E-01],
	[3.2365000000E+04, 2.3762702110E+01, 5.1700703002E+00, 8.0492829873E+00, 2.7797978270E+00, 9.3365749688E-01],
	[3.2370000000E+04, 2.3768853885E+01, 5.1700721870E+00, 8.0533237352E+00, 2.7803643281E+00, 9.3368851662E-01],
	[3.2375000000E+04, 2.3775006302E+01, 5.1700740735E+00, 8.0573658860E+00, 2.7809307088E+00, 9.3371952083E-01],
	[3.2380000000E+04, 2.3781159362E+01, 5.1700759597E+00, 8.0614094398E+00, 2.7814969692E+00, 9.3375050953E-01],
	[3.2385000000E+04, 2.3787313063E+01, 5.1700778456E+00, 8.0654543971E+00, 2.7820631092E+00, 9.3378148271E-01],
	[3.2390000000E+04, 2.3793467406E+01, 5.1700797313E+00, 8.0695007580E+00, 2.7826291289E+00, 9.3381244040E-01],
	[3.2395000000E+04, 2.3799627077E+01, 5.1700822920E+00, 8.0735485229E+00, 2.7831952879E+00, 9.3384338258E-01],
	[3.2400000000E+04, 2.3805802853E+01, 5.1700870797E+00, 8.0775976919E+00, 2.7837621839E+00, 9.3387430927E-01],
	[3.2405000000E+04, 2.3811979277E+01, 5.1700918667E+00, 8.0816484105E+00, 2.7843289772E+00, 9.3390522048E-01],
	[3.2410000000E+04, 2.3818156351E+01, 5.1700966529E+00, 8.0857009473E+00, 2.7848956997E+00, 9.3393611622E-01],
	[3.2415000000E+04, 2.3824334074E+01, 5.1701014384E+00, 8.0897548895E+00, 2.7854623023E+00, 9.3396699649E-01],
	[3.2420000000E+04, 2.3830512446E+01, 5.1701062231E+00, 8.0938102375E+00, 2.7860287851E+00, 9.3399786130E-01],
	[3.2425000000E+04, 2.3836691467E+01, 5.1701110072E+00, 8.0978669916E+00, 2.7865951479E+00, 9.3402871065E-01],
	[3.2430000000E+04, 2.3842871137E+01, 5.1701157905E+00, 8.1019251519E+00, 2.7871613909E+00, 9.3405954456E-01],
	[3.2435000000E+04, 2.3849051457E+01, 5.1701205730E+00, 8.1059847189E+00, 2.7877275139E+00, 9.3409036303E-01],
	[3.2440000000E+04, 2.3855232425E+01, 5.1701253548E+00, 8.1100456928E+00, 2.7882935171E+00, 9.3412116607E-01],
	[3.2445000000E+04, 2.3861414042E+01, 5.1701301359E+00, 8.1141080737E+00, 2.7888594003E+00, 9.3415195369E-01],
	[3.2450000000E+04, 2.3867596308E+01, 5.1701349163E+00, 8.1181718621E+00, 2.7894251635E+00, 9.3418272589E-01],
	[3.2455000000E+04, 2.3873779223E+01, 5.1701396959E+00, 8.1222370581E+00, 2.7899908068E+00, 9.3421348268E-01],
	[3.2460000000E+04, 2.3879962787E+01, 5.1701444748E+00, 8.1263036621E+00, 2.7905563301E+00, 9.3424422407E-01],
	[3.2465000000E+04, 2.3886146999E+01, 5.1701492530E+00, 8.1303716743E+00, 2.7911217334E+00, 9.3427495006E-01],
	[3.2470000000E+04, 2.3892331860E+01, 5.1701540304E+00, 8.1344410950E+00, 2.7916870167E+00, 9.3430566066E-01],
	[3.2475000000E+04, 2.3898517371E+01, 5.1701588071E+00, 8.1385119244E+00, 2.7922521800E+00, 9.3433635589E-01],
	[3.2480000000E+04, 2.3904703529E+01, 5.1701635831E+00, 8.1425841628E+00, 2.7928172233E+00, 9.3436703574E-01],
	[3.2485000000E+04, 2.3910890337E+01, 5.1701683584E+00, 8.1466578106E+00, 2.7933821466E+00, 9.3439770023E-01],
	[3.2490000000E+04, 2.3917077793E+01, 5.1701731329E+00, 8.1507328679E+00, 2.7939469498E+00, 9.3442834936E-01],
	[3.2495000000E+04, 2.3923265898E+01, 5.1701779066E+00, 8.1548093350E+00, 2.7945116330E+00, 9.3445898313E-01],
	[3.2500000000E+04, 2.3929454652E+01, 5.1701826797E+00, 8.1588872123E+00, 2.7950761961E+00, 9.3448960156E-01],
	[3.2505000000E+04, 2.3935644054E+01, 5.1701874520E+00, 8.1629664999E+00, 2.7956406392E+00, 9.3452020466E-01],
	[3.2510000000E+04, 2.3941834104E+01, 5.1701922236E+00, 8.1670471981E+00, 2.7962049621E+00, 9.3455079243E-01],
	[3.2515000000E+04, 2.3948024803E+01, 5.1701969945E+00, 8.1711293073E+00, 2.7967691650E+00, 9.3458136487E-01],
	[3.2520000000E+04, 2.3954216151E+01, 5.1702017646E+00, 8.1752128276E+00, 2.7973332478E+00, 9.3461192200E-01],
	[3.2525000000E+04, 2.3960408147E+01, 5.1702065340E+00, 8.1792977594E+00, 2.7978972104E+00, 9.3464246383E-01],
	[3.2530000000E+04, 2.3966600791E+01, 5.1702113027E+00, 8.1833841030E+00, 2.7984610530E+00, 9.3467299035E-01],
	[3.2535000000E+04, 2.3972794084E+01, 5.1702160706E+00, 8.1874718585E+00, 2.7990247754E+00, 9.3470350158E-01],
	[3.2540000000E+04, 2.3978988025E+01, 5.1702208378E+00, 8.1915610263E+00, 2.7995883776E+00, 9.3473399753E-01],
	[3.2545000000E+04, 2.3985182614E+01, 5.1702256043E+00, 8.1956516066E+00, 2.8001518597E+00, 9.3476447819E-01],
	[3.2550000000E+04, 2.3991377852E+01, 5.1702303701E+00, 8.1997435997E+00, 2.8007152216E+00, 9.3479494359E-01],
	[3.2555000000E+04, 2.3997573738E+01, 5.1702351351E+00, 8.2038370059E+00, 2.8012784633E+00, 9.3482539372E-01],
	[3.2560000000E+04, 2.4003770272E+01, 5.1702398994E+00, 8.2079318255E+00, 2.8018415849E+00, 9.3485582860E-01],
	[3.2565000000E+04, 2.4009967455E+01, 5.1702446630E+00, 8.2120280587E+00, 2.8024045862E+00, 9.3488624823E-01],
	[3.2570000000E+04, 2.4016165285E+01, 5.1702494259E+00, 8.2161257057E+00, 2.8029674674E+00, 9.3491665261E-01],
	[3.2575000000E+04, 2.4022363764E+01, 5.1702541880E+00, 8.2202247669E+00, 2.8035302283E+00, 9.3494704176E-01],
	[3.2580000000E+04, 2.4028562890E+01, 5.1702589494E+00, 8.2243252426E+00, 2.8040928690E+00, 9.3497741569E-01],
	[3.2585000000E+04, 2.4034762665E+01, 5.1702637101E+00, 8.2284271329E+00, 2.8046553894E+00, 9.3500777439E-01],
	[3.2590000000E+04, 2.4040963088E+01, 5.1702684700E+00, 8.2325304382E+00, 2.8052177896E+00, 9.3503811788E-01],
	[3.2595000000E+04, 2.4047164159E+01, 5.1702732292E+00, 8.2366351587E+00, 2.8057800696E+00, 9.3506844617E-01],
	[3.2600000000E+04, 2.4053365878E+01, 5.1702779877E+00, 8.2407412948E+00, 2.8063422292E+00, 9.3509875926E-01],
	[3.2605000000E+04, 2.4059568244E+01, 5.1702827455E+00, 8.2448488466E+00, 2.8069042686E+00, 9.3512905716E-01],
	[3.2610000000E+04, 2.4065771259E+01, 5.1702875026E+00, 8.2489578145E+00, 2.8074661877E+00, 9.3515933987E-01],
	[3.2615000000E+04, 2.4071974921E+01, 5.1702922589E+00, 8.2530681987E+00, 2.8080279865E+00, 9.3518960741E-01],
	[3.2620000000E+04, 2.4078179232E+01, 5.1702970145E+00, 8.2571799995E+00, 2.8085896650E+00, 9.3521985978E-01],
	[3.2625000000E+04, 2.4084384190E+01, 5.1703017693E+00, 8.2612932171E+00, 2.8091512231E+00, 9.3525009699E-01],
	[3.2630000000E+04, 2.4090589796E+01, 5.1703065235E+00, 8.2654078519E+00, 2.8097126609E+00, 9.3528031905E-01],
	[3.2635000000E+04, 2.4096796049E+01, 5.1703112769E+00, 8.2695239041E+00, 2.8102739784E+00, 9.3531052595E-01],
	[3.2640000000E+04, 2.4103002951E+01, 5.1703160296E+00, 8.2736413739E+00, 2.8108351756E+00, 9.3534071772E-01],
	[3.2645000000E+04, 2.4109210500E+01, 5.1703207816E+00, 8.2777602617E+00, 2.8113962523E+00, 9.3537089436E-01],
	[3.2650000000E+04, 2.4115418696E+01, 5.1703255328E+00, 8.2818805677E+00, 2.8119572087E+00, 9.3540105587E-01],
	[3.2655000000E+04, 2.4121627541E+01, 5.1703302834E+00, 8.2860022922E+00, 2.8125180447E+00, 9.3543120226E-01],
	[3.2660000000E+04, 2.4127837032E+01, 5.1703350332E+00, 8.2901254355E+00, 2.8130787604E+00, 9.3546133355E-01],
	[3.2665000000E+04, 2.4134047172E+01, 5.1703397823E+00, 8.2942499977E+00, 2.8136393556E+00, 9.3549144973E-01],
	[3.2670000000E+04, 2.4140257959E+01, 5.1703445306E+00, 8.2983759793E+00, 2.8141998304E+00, 9.3552155081E-01],
	[3.2675000000E+04, 2.4146469393E+01, 5.1703492783E+00, 8.3025033804E+00, 2.8147601848E+00, 9.3555163681E-01],
	[3.2680000000E+04, 2.4152681475E+01, 5.1703540252E+00, 8.3066322014E+00, 2.8153204188E+00, 9.3558170773E-01],
	[3.2685000000E+04, 2.4158894205E+01, 5.1703587714E+00, 8.3107624425E+00, 2.8158805324E+00, 9.3561176357E-01],
	[3.2690000000E+04, 2.4165107581E+01, 5.1703635168E+00, 8.3148941039E+00, 2.8164405254E+00, 9.3564180434E-01],
	[3.2695000000E+04, 2.4171321605E+01, 5.1703682616E+00, 8.3190271860E+00, 2.8170003981E+00, 9.3567183006E-01],
	[3.2700000000E+04, 2.4177536277E+01, 5.1703730056E+00, 8.3231616890E+00, 2.8175601503E+00, 9.3570184072E-01],
	[3.2705000000E+04, 2.4183751595E+01, 5.1703777489E+00, 8.3272976132E+00, 2.8181197820E+00, 9.3573183634E-01],
	[3.2710000000E+04, 2.4189967561E+01, 5.1703824915E+00, 8.3314349589E+00, 2.8186792932E+00, 9.3576181693E-01],
	[3.2715000000E+04, 2.4196184175E+01, 5.1703872334E+00, 8.3355737263E+00, 2.8192386839E+00, 9.3579178248E-01],
	[3.2720000000E+04, 2.4202401435E+01, 5.1703919745E+00, 8.3397139157E+00, 2.8197979541E+00, 9.3582173301E-01],
	[3.2725000000E+04, 2.4208619343E+01, 5.1703967150E+00, 8.3438555273E+00, 2.8203571038E+00, 9.3585166852E-01],
	[3.2730000000E+04, 2.4214837897E+01, 5.1704014547E+00, 8.3479985616E+00, 2.8209161330E+00, 9.3588158903E-01],
	[3.2735000000E+04, 2.4221057099E+01, 5.1704061937E+00, 8.3521430186E+00, 2.8214750417E+00, 9.3591149454E-01],
	[3.2740000000E+04, 2.4227276948E+01, 5.1704109319E+00, 8.3562888987E+00, 2.8220338298E+00, 9.3594138505E-01],
	[3.2745000000E+04, 2.4233497444E+01, 5.1704156695E+00, 8.3604362021E+00, 2.8225924974E+00, 9.3597126057E-01],
	[3.2750000000E+04, 2.4239718587E+01, 5.1704204063E+00, 8.3645849292E+00, 2.8231510444E+00, 9.3600112112E-01],
	[3.2755000000E+04, 2.4245940377E+01, 5.1704251424E+00, 8.3687350802E+00, 2.8237094709E+00, 9.3603096670E-01],
	[3.2760000000E+04, 2.4252162814E+01, 5.1704298778E+00, 8.3728866553E+00, 2.8242677767E+00, 9.3606079731E-01],
	[3.2765000000E+04, 2.4258385898E+01, 5.1704346125E+00, 8.3770396549E+00, 2.8248259621E+00, 9.3609061296E-01],
	[3.2770000000E+04, 2.4264609629E+01, 5.1704393464E+00, 8.3811940792E+00, 2.8253840268E+00, 9.3612041367E-01],
	[3.2775000000E+04, 2.4270834006E+01, 5.1704440797E+00, 8.3853499285E+00, 2.8259419709E+00, 9.3615019943E-01],
	[3.2780000000E+04, 2.4277059031E+01, 5.1704488122E+00, 8.3895072030E+00, 2.8264997944E+00, 9.3617997026E-01],
	[3.2785000000E+04, 2.4283284702E+01, 5.1704535440E+00, 8.3936659030E+00, 2.8270574973E+00, 9.3620972616E-01],
	[3.2790000000E+04, 2.4289511020E+01, 5.1704582751E+00, 8.3978260289E+00, 2.8276150796E+00, 9.3623946714E-01],
	[3.2795000000E+04, 2.4295737985E+01, 5.1704630055E+00, 8.4019875807E+00, 2.8281725412E+00, 9.3626919321E-01],
	[3.2800000000E+04, 2.4301965596E+01, 5.1704677351E+00, 8.4061505590E+00, 2.8287298822E+00, 9.3629890437E-01],
	[3.2805000000E+04, 2.4308193854E+01, 5.1704724640E+00, 8.4103149638E+00, 2.8292871025E+00, 9.3632860063E-01],
	[3.2810000000E+04, 2.4314422759E+01, 5.1704771923E+00, 8.4144807955E+00, 2.8298442022E+00, 9.3635828200E-01],
	[3.2815000000E+04, 2.4320652310E+01, 5.1704819198E+00, 8.4186480543E+00, 2.8304011812E+00, 9.3638794849E-01],
	[3.2820000000E+04, 2.4326882508E+01, 5.1704866466E+00, 8.4228167406E+00, 2.8309580396E+00, 9.3641760010E-01],
	[3.2825000000E+04, 2.4333113353E+01, 5.1704913726E+00, 8.4269868545E+00, 2.8315147772E+00, 9.3644723684E-01],
	[3.2830000000E+04, 2.4339344844E+01, 5.1704960980E+00, 8.4311583964E+00, 2.8320713942E+00, 9.3647685872E-01],
	[3.2835000000E+04, 2.4345576981E+01, 5.1705008226E+00, 8.4353313665E+00, 2.8326278905E+00, 9.3650646574E-01],
	[3.2840000000E+04, 2.4351809765E+01, 5.1705055465E+00, 8.4395057652E+00, 2.8331842661E+00, 9.3653605792E-01],
	[3.2845000000E+04, 2.4358043195E+01, 5.1705102698E+00, 8.4436815926E+00, 2.8337405209E+00, 9.3656563526E-01],
	[3.2850000000E+04, 2.4364277272E+01, 5.1705149923E+00, 8.4478588490E+00, 2.8342966550E+00, 9.3659519776E-01],
	[3.2855000000E+04, 2.4370511995E+01, 5.1705197140E+00, 8.4520375347E+00, 2.8348526684E+00, 9.3662474544E-01],
	[3.2860000000E+04, 2.4376747365E+01, 5.1705244351E+00, 8.4562176501E+00, 2.8354085611E+00, 9.3665427830E-01],
	[3.2865000000E+04, 2.4382983380E+01, 5.1705291555E+00, 8.4603991952E+00, 2.8359643330E+00, 9.3668379635E-01],
	[3.2870000000E+04, 2.4389220042E+01, 5.1705338751E+00, 8.4645821706E+00, 2.8365199841E+00, 9.3671329959E-01],
	[3.2875000000E+04, 2.4395457351E+01, 5.1705385940E+00, 8.4687665763E+00, 2.8370755145E+00, 9.3674278804E-01],
	[3.2880000000E+04, 2.4401695305E+01, 5.1705433122E+00, 8.4729524126E+00, 2.8376309242E+00, 9.3677226170E-01],
	[3.2885000000E+04, 2.4407933906E+01, 5.1705480297E+00, 8.4771396799E+00, 2.8381862130E+00, 9.3680172058E-01],
	[3.2890000000E+04, 2.4414173152E+01, 5.1705527465E+00, 8.4813283784E+00, 2.8387413811E+00, 9.3683116469E-01],
	[3.2895000000E+04, 2.4420413045E+01, 5.1705574626E+00, 8.4855185084E+00, 2.8392964283E+00, 9.3686059402E-01],
	[3.2900000000E+04, 2.4426653584E+01, 5.1705621780E+00, 8.4897100702E+00, 2.8398513548E+00, 9.3689000860E-01],
	[3.2905000000E+04, 2.4432894769E+01, 5.1705668926E+00, 8.4939030639E+00, 2.8404061604E+00, 9.3691940843E-01],
	[3.2910000000E+04, 2.4439136600E+01, 5.1705716065E+00, 8.4980974900E+00, 2.8409608453E+00, 9.3694879350E-01],
	[3.2915000000E+04, 2.4445379077E+01, 5.1705763198E+00, 8.5022933486E+00, 2.8415154093E+00, 9.3697816385E-01],
	[3.2920000000E+04, 2.4451640809E+01, 5.1705836865E+00, 8.5064906400E+00, 2.8420709058E+00, 9.3700751946E-01],
	[3.2925000000E+04, 2.4457904524E+01, 5.1705912416E+00, 8.5106893646E+00, 2.8426263572E+00, 9.3703686034E-01],
	[3.2930000000E+04, 2.4464168893E+01, 5.1705987957E+00, 8.5148895225E+00, 2.8431816884E+00, 9.3706618652E-01],
	[3.2935000000E+04, 2.4470433914E+01, 5.1706063486E+00, 8.5190911141E+00, 2.8437368993E+00, 9.3709549798E-01],
	[3.2940000000E+04, 2.4476699588E+01, 5.1706139003E+00, 8.5232941396E+00, 2.8442919899E+00, 9.3712479474E-01],
	[3.2945000000E+04, 2.4482965915E+01, 5.1706214510E+00, 8.5274985993E+00, 2.8448469602E+00, 9.3715407681E-01],
	[3.2950000000E+04, 2.4489232895E+01, 5.1706290005E+00, 8.5317044934E+00, 2.8454018103E+00, 9.3718334419E-01],
	[3.2955000000E+04, 2.4495500528E+01, 5.1706365488E+00, 8.5359118223E+00, 2.8459565399E+00, 9.3721259689E-01],
	[3.2960000000E+04, 2.4501768813E+01, 5.1706440961E+00, 8.5401205862E+00, 2.8465111493E+00, 9.3724183491E-01],
	[3.2965000000E+04, 2.4508037752E+01, 5.1706516421E+00, 8.5443307853E+00, 2.8470656384E+00, 9.3727105828E-01],
	[3.2970000000E+04, 2.4514307343E+01, 5.1706591871E+00, 8.5485424200E+00, 2.8476200071E+00, 9.3730026698E-01],
	[3.2975000000E+04, 2.4520577588E+01, 5.1706667309E+00, 8.5527554905E+00, 2.8481742554E+00, 9.3732946104E-01],
	[3.2980000000E+04, 2.4526848485E+01, 5.1706742736E+00, 8.5569699971E+00, 2.8487283834E+00, 9.3735864045E-01],
	[3.2985000000E+04, 2.4533120034E+01, 5.1706818152E+00, 8.5611859401E+00, 2.8492823911E+00, 9.3738780522E-01],
	[3.2990000000E+04, 2.4539392237E+01, 5.1706893556E+00, 8.5654033197E+00, 2.8498362784E+00, 9.3741695537E-01],
	[3.2995000000E+04, 2.4545665092E+01, 5.1706968949E+00, 8.5696221361E+00, 2.8503900453E+00, 9.3744609090E-01],
	[3.3000000000E+04, 2.4551938599E+01, 5.1707044331E+00, 8.5738423898E+00, 2.8509436919E+00, 9.3747521181E-01],
	[3.3005000000E+04, 2.4558212759E+01, 5.1707119701E+00, 8.5780640809E+00, 2.8514972180E+00, 9.3750431811E-01],
	[3.3010000000E+04, 2.4564487572E+01, 5.1707195060E+00, 8.5822872097E+00, 2.8520506238E+00, 9.3753340982E-01],
	[3.3015000000E+04, 2.4570763037E+01, 5.1707270408E+00, 8.5865117765E+00, 2.8526039092E+00, 9.3756248693E-01],
	[3.3020000000E+04, 2.4577039155E+01, 5.1707345744E+00, 8.5907377816E+00, 2.8531570741E+00, 9.3759154946E-01],
	[3.3025000000E+04, 2.4583315925E+01, 5.1707421070E+00, 8.5949652251E+00, 2.8537101187E+00, 9.3762059741E-01],
	[3.3030000000E+04, 2.4589593348E+01, 5.1707496383E+00, 8.5991941075E+00, 2.8542630428E+00, 9.3764963079E-01],
	[3.3035000000E+04, 2.4595871423E+01, 5.1707571686E+00, 8.6034244290E+00, 2.8548158465E+00, 9.3767864961E-01],
	[3.3040000000E+04, 2.4602150151E+01, 5.1707646977E+00, 8.6076561898E+00, 2.8553685298E+00, 9.3770765387E-01],
	[3.3045000000E+04, 2.4608429530E+01, 5.1707722257E+00, 8.6118893902E+00, 2.8559210927E+00, 9.3773664359E-01],
	[3.3050000000E+04, 2.4614709563E+01, 5.1707797526E+00, 8.6161240304E+00, 2.8564735350E+00, 9.3776561876E-01],
	[3.3055000000E+04, 2.4620990247E+01, 5.1707872783E+00, 8.6203601109E+00, 2.8570258570E+00, 9.3779457940E-01],
	[3.3060000000E+04, 2.4627271584E+01, 5.1707948029E+00, 8.6245976317E+00, 2.8575780585E+00, 9.3782352551E-01],
	[3.3065000000E+04, 2.4633553573E+01, 5.1708023264E+00, 8.6288365933E+00, 2.8581301395E+00, 9.3785245710E-01],
	[3.3070000000E+04, 2.4639836214E+01, 5.1708098488E+00, 8.6330769958E+00, 2.8586821000E+00, 9.3788137418E-01],
	[3.3075000000E+04, 2.4646119507E+01, 5.1708173700E+00, 8.6373188396E+00, 2.8592339401E+00, 9.3791027676E-01],
	[3.3080000000E+04, 2.4652403452E+01, 5.1708248901E+00, 8.6415621249E+00, 2.8597856597E+00, 9.3793916483E-01],
	[3.3085000000E+04, 2.4658688050E+01, 5.1708324091E+00, 8.6458068520E+00, 2.8603372588E+00, 9.3796803842E-01],
	[3.3090000000E+04, 2.4664973299E+01, 5.1708399270E+00, 8.6500530211E+00, 2.8608887373E+00, 9.3799689753E-01],
	[3.3095000000E+04, 2.4671259201E+01, 5.1708474437E+00, 8.6543006325E+00, 2.8614400954E+00, 9.3802574216E-01],
	[3.3100000000E+04, 2.4677545754E+01, 5.1708549593E+00, 8.6585496866E+00, 2.8619913330E+00, 9.3805457232E-01],
	[3.3105000000E+04, 2.4683832960E+01, 5.1708624738E+00, 8.6628001835E+00, 2.8625424501E+00, 9.3808338802E-01],
	[3.3110000000E+04, 2.4690120817E+01, 5.1708699872E+00, 8.6670521236E+00, 2.8630934466E+00, 9.3811218926E-01],
	[3.3115000000E+04, 2.4696409327E+01, 5.1708774994E+00, 8.6713055070E+00, 2.8636443226E+00, 9.3814097606E-01],
	[3.3120000000E+04, 2.4702698488E+01, 5.1708850105E+00, 8.6755603342E+00, 2.8641950781E+00, 9.3816974842E-01],
	[3.3125000000E+04, 2.4708988301E+01, 5.1708925205E+00, 8.6798166053E+00, 2.8647457130E+00, 9.3819850635E-01],
	[3.3130000000E+04, 2.4715278766E+01, 5.1709000294E+00, 8.6840743206E+00, 2.8652962274E+00, 9.3822724985E-01],
	[3.3135000000E+04, 2.4721569883E+01, 5.1709075371E+00, 8.6883334804E+00, 2.8658466213E+00, 9.3825597894E-01],
	[3.3140000000E+04, 2.4727861651E+01, 5.1709150438E+00, 8.6925940850E+00, 2.8663968945E+00, 9.3828469361E-01],
	[3.3145000000E+04, 2.4734154071E+01, 5.1709225493E+00, 8.6968561347E+00, 2.8669470473E+00, 9.3831339389E-01],
	[3.3150000000E+04, 2.4740447143E+01, 5.1709300536E+00, 8.7011196296E+00, 2.8674970794E+00, 9.3834207976E-01],
	[3.3155000000E+04, 2.4746740867E+01, 5.1709375569E+00, 8.7053845701E+00, 2.8680469910E+00, 9.3837075125E-01],
	[3.3160000000E+04, 2.4753035242E+01, 5.1709450590E+00, 8.7096509565E+00, 2.8685967820E+00, 9.3839940836E-01],
	[3.3165000000E+04, 2.4759330269E+01, 5.1709525601E+00, 8.7139187890E+00, 2.8691464524E+00, 9.3842805109E-01],
	[3.3170000000E+04, 2.4765625947E+01, 5.1709600600E+00, 8.7181880679E+00, 2.8696960022E+00, 9.3845667946E-01],
	[3.3175000000E+04, 2.4771922277E+01, 5.1709675587E+00, 8.7224587935E+00, 2.8702454314E+00, 9.3848529347E-01],
	[3.3180000000E+04, 2.4778219259E+01, 5.1709750564E+00, 8.7267309660E+00, 2.8707947400E+00, 9.3851389312E-01],
	[3.3185000000E+04, 2.4784516891E+01, 5.1709825529E+00, 8.7310045857E+00, 2.8713439280E+00, 9.3854247843E-01],
	[3.3190000000E+04, 2.4790815176E+01, 5.1709900484E+00, 8.7352796529E+00, 2.8718929954E+00, 9.3857104940E-01],
	[3.3195000000E+04, 2.4797114112E+01, 5.1709975427E+00, 8.7395561679E+00, 2.8724419422E+00, 9.3859960605E-01],
	[3.3200000000E+04, 2.4803413699E+01, 5.1710050359E+00, 8.7438341309E+00, 2.8729907683E+00, 9.3862814837E-01],
	[3.3205000000E+04, 2.4809713937E+01, 5.1710125279E+00, 8.7481135422E+00, 2.8735394738E+00, 9.3865667637E-01],
	[3.3210000000E+04, 2.4816014827E+01, 5.1710200189E+00, 8.7523944020E+00, 2.8740880587E+00, 9.3868519007E-01],
	[3.3215000000E+04, 2.4822316368E+01, 5.1710275087E+00, 8.7566767107E+00, 2.8746365229E+00, 9.3871368946E-01],
	[3.3220000000E+04, 2.4828618561E+01, 5.1710349974E+00, 8.7609604685E+00, 2.8751848665E+00, 9.3874217456E-01],
	[3.3225000000E+04, 2.4834921404E+01, 5.1710424850E+00, 8.7652456757E+00, 2.8757330894E+00, 9.3877064537E-01],
	[3.3230000000E+04, 2.4841224899E+01, 5.1710499715E+00, 8.7695323326E+00, 2.8762811917E+00, 9.3879910191E-01],
	[3.3235000000E+04, 2.4847529045E+01, 5.1710574569E+00, 8.7738204394E+00, 2.8768291733E+00, 9.3882754417E-01],
	[3.3240000000E+04, 2.4853833842E+01, 5.1710649412E+00, 8.7781099964E+00, 2.8773770342E+00, 9.3885597216E-01],
	[3.3245000000E+04, 2.4860139291E+01, 5.1710724243E+00, 8.7824010038E+00, 2.8779247745E+00, 9.3888438590E-01],
	[3.3250000000E+04, 2.4866445390E+01, 5.1710799063E+00, 8.7866934620E+00, 2.8784723941E+00, 9.3891278539E-01],
	[3.3255000000E+04, 2.4872752140E+01, 5.1710873872E+00, 8.7909873712E+00, 2.8790198930E+00, 9.3894117063E-01],
	[3.3260000000E+04, 2.4879059542E+01, 5.1710948670E+00, 8.7952827317E+00, 2.8795672712E+00, 9.3896954164E-01],
	[3.3265000000E+04, 2.4885367594E+01, 5.1711023457E+00, 8.7995795438E+00, 2.8801145287E+00, 9.3899789842E-01],
	[3.3270000000E+04, 2.4891676297E+01, 5.1711098233E+00, 8.8038778076E+00, 2.8806616655E+00, 9.3902624098E-01],
	[3.3275000000E+04, 2.4897985652E+01, 5.1711172997E+00, 8.8081775236E+00, 2.8812086816E+00, 9.3905456933E-01],
	[3.3280000000E+04, 2.4904295657E+01, 5.1711247751E+00, 8.8124786920E+00, 2.8817555771E+00, 9.3908288346E-01],
	[3.3285000000E+04, 2.4910606313E+01, 5.1711322493E+00, 8.8167813130E+00, 2.8823023518E+00, 9.3911118340E-01],
	[3.3290000000E+04, 2.4916917620E+01, 5.1711397225E+00, 8.8210853869E+00, 2.8828490057E+00, 9.3913946914E-01],
	[3.3295000000E+04, 2.4923229577E+01, 5.1711471945E+00, 8.8253909140E+00, 2.8833955390E+00, 9.3916774070E-01],
	[3.3300000000E+04, 2.4929542186E+01, 5.1711546654E+00, 8.8296978946E+00, 2.8839419515E+00, 9.3919599809E-01],
	[3.3305000000E+04, 2.4935855445E+01, 5.1711621352E+00, 8.8340063289E+00, 2.8844882433E+00, 9.3922424130E-01],
	[3.3310000000E+04, 2.4942169355E+01, 5.1711696038E+00, 8.8383162172E+00, 2.8850344144E+00, 9.3925247034E-01],
	[3.3315000000E+04, 2.4948483916E+01, 5.1711770714E+00, 8.8426275598E+00, 2.8855804647E+00, 9.3928068523E-01],
	[3.3320000000E+04, 2.4954799127E+01, 5.1711845379E+00, 8.8469403569E+00, 2.8861263943E+00, 9.3930888598E-01],
	[3.3325000000E+04, 2.4961114989E+01, 5.1711920032E+00, 8.8512546088E+00, 2.8866722032E+00, 9.3933707258E-01],
	[3.3330000000E+04, 2.4967431501E+01, 5.1711994674E+00, 8.8555703159E+00, 2.8872178912E+00, 9.3936524504E-01],
	[3.3335000000E+04, 2.4973748664E+01, 5.1712069306E+00, 8.8598874783E+00, 2.8877634586E+00, 9.3939340338E-01],
	[3.3340000000E+04, 2.4980066478E+01, 5.1712143926E+00, 8.8642060963E+00, 2.8883089051E+00, 9.3942154760E-01],
	[3.3345000000E+04, 2.4986384942E+01, 5.1712218535E+00, 8.8685261702E+00, 2.8888542309E+00, 9.3944967770E-01],
	[3.3350000000E+04, 2.4992704056E+01, 5.1712293133E+00, 8.8728477003E+00, 2.8893994359E+00, 9.3947779370E-01],
	[3.3355000000E+04, 2.4999023821E+01, 5.1712367720E+00, 8.8771706869E+00, 2.8899445202E+00, 9.3950589560E-01],
	[3.3360000000E+04, 2.5005344237E+01, 5.1712442296E+00, 8.8814951302E+00, 2.8904894836E+00, 9.3953398341E-01],
	[3.3365000000E+04, 2.5011665302E+01, 5.1712516861E+00, 8.8858210305E+00, 2.8910343263E+00, 9.3956205713E-01],
	[3.3370000000E+04, 2.5017987018E+01, 5.1712591415E+00, 8.8901483880E+00, 2.8915790482E+00, 9.3959011678E-01],
	[3.3375000000E+04, 2.5024309385E+01, 5.1712665957E+00, 8.8944772031E+00, 2.8921236493E+00, 9.3961816236E-01],
	[3.3380000000E+04, 2.5030632401E+01, 5.1712740489E+00, 8.8988074760E+00, 2.8926681296E+00, 9.3964619388E-01],
	[3.3385000000E+04, 2.5036956068E+01, 5.1712815010E+00, 8.9031392070E+00, 2.8932124891E+00, 9.3967421134E-01],
	[3.3390000000E+04, 2.5043280385E+01, 5.1712889519E+00, 8.9074723963E+00, 2.8937567278E+00, 9.3970221475E-01],
	[3.3395000000E+04, 2.5049605353E+01, 5.1712964018E+00, 8.9118070443E+00, 2.8943008457E+00, 9.3973020413E-01],
	[3.3400000000E+04, 2.5055930970E+01, 5.1713038505E+00, 8.9161431511E+00, 2.8948448428E+00, 9.3975817946E-01],
	[3.3405000000E+04, 2.5062257238E+01, 5.1713112982E+00, 8.9204807172E+00, 2.8953887191E+00, 9.3978614078E-01],
	[3.3410000000E+04, 2.5068584156E+01, 5.1713187447E+00, 8.9248197426E+00, 2.8959324745E+00, 9.3981408807E-01],
	[3.3415000000E+04, 2.5074911723E+01, 5.1713261901E+00, 8.9291602278E+00, 2.8964761091E+00, 9.3984202135E-01],
	[3.3420000000E+04, 2.5081239941E+01, 5.1713336345E+00, 8.9335021730E+00, 2.8970196229E+00, 9.3986994063E-01],
	[3.3425000000E+04, 2.5087568809E+01, 5.1713410777E+00, 8.9378455784E+00, 2.8975630159E+00, 9.3989784591E-01],
	[3.3430000000E+04, 2.5093898327E+01, 5.1713485198E+00, 8.9421904444E+00, 2.8981062880E+00, 9.3992573720E-01],
	[3.3435000000E+04, 2.5100228495E+01, 5.1713559608E+00, 8.9465367711E+00, 2.8986494393E+00, 9.3995361451E-01],
	[3.3440000000E+04, 2.5106559312E+01, 5.1713634008E+00, 8.9508845589E+00, 2.8991924697E+00, 9.3998147784E-01],
	[3.3445000000E+04, 2.5112890780E+01, 5.1713708396E+00, 8.9552338081E+00, 2.8997353793E+00, 9.4000932720E-01],
	[3.3450000000E+04, 2.5119241735E+01, 5.1713809378E+00, 8.9595845189E+00, 2.9002792560E+00, 9.4003716260E-01],
	[3.3455000000E+04, 2.5125594236E+01, 5.1713911601E+00, 8.9639366916E+00, 2.9008230638E+00, 9.4006498405E-01],
	[3.3460000000E+04, 2.5131947394E+01, 5.1714013809E+00, 8.9682903264E+00, 2.9013667512E+00, 9.4009279155E-01],
	[3.3465000000E+04, 2.5138301208E+01, 5.1714116002E+00, 8.9726454237E+00, 2.9019103183E+00, 9.4012058511E-01],
	[3.3470000000E+04, 2.5144655680E+01, 5.1714218180E+00, 8.9770019837E+00, 2.9024537651E+00, 9.4014836474E-01],
	[3.3475000000E+04, 2.5151010808E+01, 5.1714320343E+00, 8.9813600066E+00, 2.9029970916E+00, 9.4017613044E-01],
	[3.3480000000E+04, 2.5157366592E+01, 5.1714422491E+00, 8.9857194928E+00, 2.9035402977E+00, 9.4020388223E-01],
	[3.3485000000E+04, 2.5163723034E+01, 5.1714524623E+00, 8.9900804426E+00, 2.9040833836E+00, 9.4023162010E-01],
	[3.3490000000E+04, 2.5170080132E+01, 5.1714626741E+00, 8.9944428561E+00, 2.9046263491E+00, 9.4025934407E-01],
	[3.3495000000E+04, 2.5176437886E+01, 5.1714728844E+00, 8.9988067337E+00, 2.9051691942E+00, 9.4028705414E-01],
	[3.3500000000E+04, 2.5182796298E+01, 5.1714830932E+00, 9.0031720756E+00, 2.9057119190E+00, 9.4031475033E-01],
	[3.3505000000E+04, 2.5189155365E+01, 5.1714933004E+00, 9.0075388822E+00, 2.9062545235E+00, 9.4034243263E-01],
	[3.3510000000E+04, 2.5195515090E+01, 5.1715035062E+00, 9.0119071536E+00, 2.9067970077E+00, 9.4037010106E-01],
	[3.3515000000E+04, 2.5201875470E+01, 5.1715137104E+00, 9.0162768902E+00, 2.9073393715E+00, 9.4039775562E-01],
	[3.3520000000E+04, 2.5208236507E+01, 5.1715239132E+00, 9.0206480922E+00, 2.9078816149E+00, 9.4042539631E-01],
	[3.3525000000E+04, 2.5214598201E+01, 5.1715341144E+00, 9.0250207599E+00, 2.9084237380E+00, 9.4045302316E-01],
	[3.3530000000E+04, 2.5220960551E+01, 5.1715443142E+00, 9.0293948936E+00, 2.9089657407E+00, 9.4048063616E-01],
	[3.3535000000E+04, 2.5227323557E+01, 5.1715545124E+00, 9.0337704935E+00, 2.9095076231E+00, 9.4050823532E-01],
	[3.3540000000E+04, 2.5233687220E+01, 5.1715647092E+00, 9.0381475599E+00, 2.9100493851E+00, 9.4053582065E-01],
	[3.3545000000E+04, 2.5240051539E+01, 5.1715749044E+00, 9.0425260932E+00, 2.9105910268E+00, 9.4056339215E-01],
	[3.3550000000E+04, 2.5246416514E+01, 5.1715850982E+00, 9.0469060935E+00, 2.9111325480E+00, 9.4059094984E-01],
	[3.3555000000E+04, 2.5252782145E+01, 5.1715952904E+00, 9.0512875611E+00, 2.9116739489E+00, 9.4061849371E-01],
	[3.3560000000E+04, 2.5259148433E+01, 5.1716054812E+00, 9.0556704963E+00, 2.9122152295E+00, 9.4064602378E-01],
	[3.3565000000E+04, 2.5265515377E+01, 5.1716156704E+00, 9.0600548994E+00, 2.9127563896E+00, 9.4067354006E-01],
	[3.3570000000E+04, 2.5271882977E+01, 5.1716258582E+00, 9.0644407707E+00, 2.9132974294E+00, 9.4070104255E-01],
	[3.3575000000E+04, 2.5278251233E+01, 5.1716360444E+00, 9.0688281104E+00, 2.9138383488E+00, 9.4072853125E-01],
	[3.3580000000E+04, 2.5284620145E+01, 5.1716462292E+00, 9.0732169187E+00, 2.9143791478E+00, 9.4075600619E-01],
	[3.3585000000E+04, 2.5290989713E+01, 5.1716564125E+00, 9.0776071961E+00, 2.9149198264E+00, 9.4078346735E-01],
	[3.3590000000E+04, 2.5297359937E+01, 5.1716665942E+00, 9.0819989427E+00, 2.9154603846E+00, 9.4081091476E-01],
	[3.3595000000E+04, 2.5303730818E+01, 5.1716767745E+00, 9.0863921588E+00, 2.9160008224E+00, 9.4083834841E-01],
	[3.3600000000E+04, 2.5310102354E+01, 5.1716869533E+00, 9.0907868446E+00, 2.9165411398E+00, 9.4086576831E-01],
	[3.3605000000E+04, 2.5316474546E+01, 5.1716971306E+00, 9.0951830006E+00, 2.9170813369E+00, 9.4089317448E-01],
	[3.3610000000E+04, 2.5322847394E+01, 5.1717073064E+00, 9.0995806268E+00, 2.9176214135E+00, 9.4092056692E-01],
	[3.3615000000E+04, 2.5329220898E+01, 5.1717174807E+00, 9.1039797237E+00, 2.9181613697E+00, 9.4094794563E-01],
	[3.3620000000E+04, 2.5335595058E+01, 5.1717276535E+00, 9.1083802914E+00, 2.9187012055E+00, 9.4097531062E-01],
	[3.3625000000E+04, 2.5341969873E+01, 5.1717378248E+00, 9.1127823303E+00, 2.9192409209E+00, 9.4100266191E-01],
	[3.3630000000E+04, 2.5348345344E+01, 5.1717479946E+00, 9.1171858406E+00, 2.9197805159E+00, 9.4102999949E-01],
	[3.3635000000E+04, 2.5354721472E+01, 5.1717581629E+00, 9.1215908226E+00, 2.9203199905E+00, 9.4105732338E-01],
	[3.3640000000E+04, 2.5361098254E+01, 5.1717683298E+00, 9.1259972766E+00, 2.9208593446E+00, 9.4108463357E-01],
	[3.3645000000E+04, 2.5367475693E+01, 5.1717784951E+00, 9.1304052028E+00, 2.9213985783E+00, 9.4111193009E-01],
	[3.3650000000E+04, 2.5373853787E+01, 5.1717886590E+00, 9.1348146015E+00, 2.9219376916E+00, 9.4113921293E-01],
	[3.3655000000E+04, 2.5380232537E+01, 5.1717988213E+00, 9.1392254729E+00, 2.9224766845E+00, 9.4116648211E-01],
	[3.3660000000E+04, 2.5386611942E+01, 5.1718089822E+00, 9.1436378175E+00, 2.9230155570E+00, 9.4119373762E-01],
	[3.3665000000E+04, 2.5392992003E+01, 5.1718191416E+00, 9.1480516353E+00, 2.9235543090E+00, 9.4122097948E-01],
	[3.3670000000E+04, 2.5399372720E+01, 5.1718292995E+00, 9.1524669268E+00, 2.9240929406E+00, 9.4124820770E-01],
	[3.3675000000E+04, 2.5405754092E+01, 5.1718394559E+00, 9.1568836921E+00, 2.9246314518E+00, 9.4127542227E-01],
	[3.3680000000E+04, 2.5412136119E+01, 5.1718496108E+00, 9.1613019316E+00, 2.9251698425E+00, 9.4130262320E-01],
	[3.3685000000E+04, 2.5418518802E+01, 5.1718597643E+00, 9.1657216455E+00, 2.9257081128E+00, 9.4132981050E-01],
	[3.3690000000E+04, 2.5424902141E+01, 5.1718699162E+00, 9.1701428341E+00, 2.9262462626E+00, 9.4135698419E-01],
	[3.3695000000E+04, 2.5431286135E+01, 5.1718800667E+00, 9.1745654976E+00, 2.9267842920E+00, 9.4138414425E-01],
	[3.3700000000E+04, 2.5437670784E+01, 5.1718902156E+00, 9.1789896364E+00, 2.9273222010E+00, 9.4141129070E-01],
	[3.3705000000E+04, 2.5444056088E+01, 5.1719003631E+00, 9.1834152506E+00, 2.9278599895E+00, 9.4143842356E-01],
	[3.3710000000E+04, 2.5450442048E+01, 5.1719105091E+00, 9.1878423407E+00, 2.9283976576E+00, 9.4146554281E-01],
	[3.3715000000E+04, 2.5456828663E+01, 5.1719206536E+00, 9.1922709068E+00, 2.9289352052E+00, 9.4149264847E-01],
	[3.3720000000E+04, 2.5463215933E+01, 5.1719307967E+00, 9.1967009492E+00, 2.9294726324E+00, 9.4151974054E-01],
	[3.3725000000E+04, 2.5469603859E+01, 5.1719409382E+00, 9.2011324682E+00, 2.9300099391E+00, 9.4154681904E-01],
	[3.3730000000E+04, 2.5475992440E+01, 5.1719510783E+00, 9.2055654641E+00, 2.9305471254E+00, 9.4157388397E-01],
	[3.3735000000E+04, 2.5482381676E+01, 5.1719612169E+00, 9.2099999372E+00, 2.9310841912E+00, 9.4160093533E-01],
	[3.3740000000E+04, 2.5488771567E+01, 5.1719713540E+00, 9.2144358876E+00, 2.9316211365E+00, 9.4162797313E-01],
	[3.3745000000E+04, 2.5495162113E+01, 5.1719814896E+00, 9.2188733157E+00, 2.9321579614E+00, 9.4165499737E-01],
	[3.3750000000E+04, 2.5501553314E+01, 5.1719916237E+00, 9.2233122218E+00, 2.9326946658E+00, 9.4168200807E-01],
	[3.3755000000E+04, 2.5507945170E+01, 5.1720017564E+00, 9.2277526062E+00, 2.9332312498E+00, 9.4170900523E-01],
	[3.3760000000E+04, 2.5514337681E+01, 5.1720118875E+00, 9.2321944690E+00, 2.9337677133E+00, 9.4173598886E-01],
	[3.3765000000E+04, 2.5520730847E+01, 5.1720220172E+00, 9.2366378106E+00, 2.9343040563E+00, 9.4176295896E-01],
	[3.3770000000E+04, 2.5527124668E+01, 5.1720321454E+00, 9.2410826312E+00, 2.9348402789E+00, 9.4178991553E-01],
	[3.3775000000E+04, 2.5533519144E+01, 5.1720422722E+00, 9.2455289312E+00, 2.9353763810E+00, 9.4181685859E-01],
	[3.3780000000E+04, 2.5539914275E+01, 5.1720523974E+00, 9.2499767108E+00, 2.9359123626E+00, 9.4184378815E-01],
	[3.3785000000E+04, 2.5546310061E+01, 5.1720625212E+00, 9.2544259702E+00, 2.9364482238E+00, 9.4187070420E-01],
	[3.3790000000E+04, 2.5552706502E+01, 5.1720726435E+00, 9.2588767098E+00, 2.9369839645E+00, 9.4189760675E-01],
	[3.3795000000E+04, 2.5559103597E+01, 5.1720827643E+00, 9.2633289298E+00, 2.9375195847E+00, 9.4192449582E-01],
	[3.3800000000E+04, 2.5565501347E+01, 5.1720928837E+00, 9.2677826305E+00, 2.9380550844E+00, 9.4195137140E-01],
	[3.3805000000E+04, 2.5571899752E+01, 5.1721030015E+00, 9.2722378122E+00, 2.9385904637E+00, 9.4197823351E-01],
	[3.3810000000E+04, 2.5578298812E+01, 5.1721131179E+00, 9.2766944750E+00, 2.9391257224E+00, 9.4200508214E-01],
	[3.3815000000E+04, 2.5584698526E+01, 5.1721232328E+00, 9.2811526194E+00, 2.9396608607E+00, 9.4203191731E-01],
	[3.3820000000E+04, 2.5591098895E+01, 5.1721333462E+00, 9.2856122456E+00, 2.9401958786E+00, 9.4205873903E-01],
	[3.3825000000E+04, 2.5597499918E+01, 5.1721434582E+00, 9.2900733538E+00, 2.9407307759E+00, 9.4208554729E-01],
	[3.3830000000E+04, 2.5603901597E+01, 5.1721535687E+00, 9.2945359443E+00, 2.9412655528E+00, 9.4211234210E-01],
	[3.3835000000E+04, 2.5610303929E+01, 5.1721636777E+00, 9.2990000174E+00, 2.9418002091E+00, 9.4213912348E-01],
	[3.3840000000E+04, 2.5616706916E+01, 5.1721737852E+00, 9.3034655734E+00, 2.9423347450E+00, 9.4216589143E-01],
	[3.3845000000E+04, 2.5623110558E+01, 5.1721838913E+00, 9.3079326125E+00, 2.9428691604E+00, 9.4219264595E-01],
	[3.3850000000E+04, 2.5629514854E+01, 5.1721939959E+00, 9.3124011351E+00, 2.9434034553E+00, 9.4221938705E-01],
	[3.3855000000E+04, 2.5635919805E+01, 5.1722040990E+00, 9.3168711413E+00, 2.9439376298E+00, 9.4224611474E-01],
	[3.3860000000E+04, 2.5642325410E+01, 5.1722142007E+00, 9.3213426315E+00, 2.9444716837E+00, 9.4227282902E-01],
	[3.3865000000E+04, 2.5648731669E+01, 5.1722243008E+00, 9.3258156060E+00, 2.9450056171E+00, 9.4229952990E-01],
	[3.3870000000E+04, 2.5655138583E+01, 5.1722343995E+00, 9.3302900649E+00, 2.9455394301E+00, 9.4232621739E-01],
	[3.3875000000E+04, 2.5661546151E+01, 5.1722444968E+00, 9.3347660086E+00, 2.9460731226E+00, 9.4235289149E-01],
	[3.3880000000E+04, 2.5667954373E+01, 5.1722545925E+00, 9.3392434374E+00, 2.9466066945E+00, 9.4237955221E-01],
	[3.3885000000E+04, 2.5674363250E+01, 5.1722646868E+00, 9.3437223514E+00, 2.9471401460E+00, 9.4240619956E-01],
	[3.3890000000E+04, 2.5680772781E+01, 5.1722747796E+00, 9.3482027511E+00, 2.9476734770E+00, 9.4243283353E-01],
	[3.3895000000E+04, 2.5687182966E+01, 5.1722848710E+00, 9.3526846367E+00, 2.9482066875E+00, 9.4245945415E-01],
	[3.3900000000E+04, 2.5693593805E+01, 5.1722949609E+00, 9.3571680084E+00, 2.9487397775E+00, 9.4248606141E-01],
	[3.3905000000E+04, 2.5700005298E+01, 5.1723050493E+00, 9.3616528665E+00, 2.9492727471E+00, 9.4251265531E-01],
	[3.3910000000E+04, 2.5706417446E+01, 5.1723151362E+00, 9.3661392113E+00, 2.9498055961E+00, 9.4253923588E-01],
	[3.3915000000E+04, 2.5712830247E+01, 5.1723252217E+00, 9.3706270431E+00, 2.9503383246E+00, 9.4256580311E-01],
	[3.3920000000E+04, 2.5719243703E+01, 5.1723353057E+00, 9.3751163621E+00, 2.9508709326E+00, 9.4259235701E-01],
	[3.3925000000E+04, 2.5725657813E+01, 5.1723453882E+00, 9.3796071686E+00, 2.9514034202E+00, 9.4261889759E-01],
	[3.3930000000E+04, 2.5732072576E+01, 5.1723554693E+00, 9.3840994629E+00, 2.9519357872E+00, 9.4264542485E-01],
	[3.3935000000E+04, 2.5738487994E+01, 5.1723655489E+00, 9.3885932452E+00, 2.9524680337E+00, 9.4267193879E-01],
	[3.3940000000E+04, 2.5744904065E+01, 5.1723756271E+00, 9.3930885159E+00, 2.9530001598E+00, 9.4269843944E-01],
	[3.3945000000E+04, 2.5751320791E+01, 5.1723857038E+00, 9.3975852752E+00, 2.9535321653E+00, 9.4272492678E-01],
	[3.3950000000E+04, 2.5757738170E+01, 5.1723957790E+00, 9.4020835233E+00, 2.9540640504E+00, 9.4275140084E-01],
	[3.3955000000E+04, 2.5764156203E+01, 5.1724058527E+00, 9.4065832606E+00, 2.9545958149E+00, 9.4277786160E-01],
	[3.3960000000E+04, 2.5770574890E+01, 5.1724159250E+00, 9.4110844873E+00, 2.9551274590E+00, 9.4280430909E-01],
	[3.3965000000E+04, 2.5776994231E+01, 5.1724259959E+00, 9.4155872037E+00, 2.9556589825E+00, 9.4283074331E-01],
	[3.3970000000E+04, 2.5783414225E+01, 5.1724360652E+00, 9.4200914101E+00, 2.9561903856E+00, 9.4285716426E-01],
	[3.3975000000E+04, 2.5789834873E+01, 5.1724461331E+00, 9.4245971067E+00, 2.9567216681E+00, 9.4288357195E-01],
	[3.3980000000E+04, 2.5796256175E+01, 5.1724561996E+00, 9.4291042938E+00, 2.9572528302E+00, 9.4290996639E-01],
	[3.3985000000E+04, 2.5802683405E+01, 5.1724670027E+00, 9.4336129717E+00, 2.9577841824E+00, 9.4293634758E-01],
	[3.3990000000E+04, 2.5809125525E+01, 5.1724797958E+00, 9.4381231407E+00, 2.9583162528E+00, 9.4296271553E-01],
	[3.3995000000E+04, 2.5815568306E+01, 5.1724925870E+00, 9.4426348009E+00, 2.9588482031E+00, 9.4298907024E-01],
	[3.4000000000E+04, 2.5822011747E+01, 5.1725053764E+00, 9.4471479528E+00, 2.9593800335E+00, 9.4301541173E-01],
	[3.4005000000E+04, 2.5828455848E+01, 5.1725181639E+00, 9.4516625966E+00, 2.9599117439E+00, 9.4304173999E-01],
	[3.4010000000E+04, 2.5834900610E+01, 5.1725309496E+00, 9.4561787325E+00, 2.9604433344E+00, 9.4306805504E-01],
	[3.4015000000E+04, 2.5841346032E+01, 5.1725437334E+00, 9.4606963609E+00, 2.9609748049E+00, 9.4309435688E-01],
	[3.4020000000E+04, 2.5847792114E+01, 5.1725565154E+00, 9.4652154819E+00, 2.9615061554E+00, 9.4312064552E-01],
	[3.4025000000E+04, 2.5854238857E+01, 5.1725692956E+00, 9.4697360959E+00, 2.9620373859E+00, 9.4314692097E-01],
	[3.4030000000E+04, 2.5860686260E+01, 5.1725820739E+00, 9.4742582032E+00, 2.9625684965E+00, 9.4317318322E-01],
	[3.4035000000E+04, 2.5867134323E+01, 5.1725948503E+00, 9.4787818039E+00, 2.9630994870E+00, 9.4319943229E-01],
	[3.4040000000E+04, 2.5873583046E+01, 5.1726076249E+00, 9.4833068985E+00, 2.9636303576E+00, 9.4322566818E-01],
	[3.4045000000E+04, 2.5880032430E+01, 5.1726203977E+00, 9.4878334871E+00, 2.9641611083E+00, 9.4325189090E-01],
	[3.4050000000E+04, 2.5886482473E+01, 5.1726331686E+00, 9.4923615701E+00, 2.9646917389E+00, 9.4327810046E-01],
	[3.4055000000E+04, 2.5892933177E+01, 5.1726459377E+00, 9.4968911476E+00, 2.9652222496E+00, 9.4330429686E-01],
	[3.4060000000E+04, 2.5899384541E+01, 5.1726587049E+00, 9.5014222201E+00, 2.9657526403E+00, 9.4333048011E-01],
	[3.4065000000E+04, 2.5905836565E+01, 5.1726714703E+00, 9.5059547877E+00, 2.9662829111E+00, 9.4335665022E-01],
	[3.4070000000E+04, 2.5912289249E+01, 5.1726842339E+00, 9.5104888507E+00, 2.9668130619E+00, 9.4338280718E-01],
	[3.4075000000E+04, 2.5918742592E+01, 5.1726969956E+00, 9.5150244095E+00, 2.9673430927E+00, 9.4340895102E-01],
	[3.4080000000E+04, 2.5925196596E+01, 5.1727097554E+00, 9.5195614642E+00, 2.9678730035E+00, 9.4343508173E-01],
	[3.4085000000E+04, 2.5931651260E+01, 5.1727225135E+00, 9.5241000151E+00, 2.9684027943E+00, 9.4346119932E-01],
	[3.4090000000E+04, 2.5938106584E+01, 5.1727352697E+00, 9.5286400626E+00, 2.9689324652E+00, 9.4348730379E-01],
	[3.4095000000E+04, 2.5944562567E+01, 5.1727480240E+00, 9.5331816069E+00, 2.9694620162E+00, 9.4351339516E-01],
	[3.4100000000E+04, 2.5951019211E+01, 5.1727607765E+00, 9.5377246482E+00, 2.9699914471E+00, 9.4353947343E-01],
	[3.4105000000E+04, 2.5957476514E+01, 5.1727735272E+00, 9.5422691869E+00, 2.9705207581E+00, 9.4356553861E-01],
	[3.4110000000E+04, 2.5963934477E+01, 5.1727862760E+00, 9.5468152232E+00, 2.9710499491E+00, 9.4359159069E-01],
	[3.4115000000E+04, 2.5970393100E+01, 5.1727990230E+00, 9.5513627574E+00, 2.9715790201E+00, 9.4361762970E-01],
	[3.4120000000E+04, 2.5976852382E+01, 5.1728117682E+00, 9.5559117898E+00, 2.9721079712E+00, 9.4364365563E-01],
	[3.4125000000E+04, 2.5983312324E+01, 5.1728245115E+00, 9.5604623206E+00, 2.9726368023E+00, 9.4366966850E-01],
	[3.4130000000E+04, 2.5989772926E+01, 5.1728372530E+00, 9.5650143500E+00, 2.9731655135E+00, 9.4369566830E-01],
	[3.4135000000E+04, 2.5996234188E+01, 5.1728499926E+00, 9.5695678785E+00, 2.9736941047E+00, 9.4372165505E-01],
	[3.4140000000E+04, 2.6002696109E+01, 5.1728627304E+00, 9.5741229063E+00, 2.9742225759E+00, 9.4374762874E-01],
	[3.4145000000E+04, 2.6009158689E+01, 5.1728754664E+00, 9.5786794335E+00, 2.9747509271E+00, 9.4377358940E-01],
	[3.4150000000E+04, 2.6015621929E+01, 5.1728882006E+00, 9.5832374606E+00, 2.9752791584E+00, 9.4379953702E-01],
	[3.4155000000E+04, 2.6022085829E+01, 5.1729009329E+00, 9.5877969877E+00, 2.9758072698E+00, 9.4382547160E-01],
	[3.4160000000E+04, 2.6028550388E+01, 5.1729136634E+00, 9.5923580152E+00, 2.9763352611E+00, 9.4385139317E-01],
	[3.4165000000E+04, 2.6035015607E+01, 5.1729263920E+00, 9.5969205433E+00, 2.9768631325E+00, 9.4387730172E-01],
	[3.4170000000E+04, 2.6041481485E+01, 5.1729391188E+00, 9.6014845723E+00, 2.9773908840E+00, 9.4390319725E-01],
	[3.4175000000E+04, 2.6047948023E+01, 5.1729518438E+00, 9.6060501025E+00, 2.9779185155E+00, 9.4392907979E-01],
	[3.4180000000E+04, 2.6054415220E+01, 5.1729645670E+00, 9.6106171341E+00, 2.9784460270E+00, 9.4395494932E-01],
	[3.4185000000E+04, 2.6060883076E+01, 5.1729772883E+00, 9.6151856675E+00, 2.9789734186E+00, 9.4398080586E-01],
	[3.4190000000E+04, 2.6067351591E+01, 5.1729900078E+00, 9.6197557028E+00, 2.9795006903E+00, 9.4400664942E-01],
	[3.4195000000E+04, 2.6073820766E+01, 5.1730027255E+00, 9.6243272404E+00, 2.9800278419E+00, 9.4403248000E-01],
	[3.4200000000E+04, 2.6080290600E+01, 5.1730154413E+00, 9.6289002805E+00, 2.9805548737E+00, 9.4405829761E-01],
	[3.4205000000E+04, 2.6086761094E+01, 5.1730281553E+00, 9.6334748235E+00, 2.9810817854E+00, 9.4408410225E-01],
	[3.4210000000E+04, 2.6093232246E+01, 5.1730408675E+00, 9.6380508695E+00, 2.9816085773E+00, 9.4410989393E-01],
	[3.4215000000E+04, 2.6099704058E+01, 5.1730535779E+00, 9.6426284189E+00, 2.9821352491E+00, 9.4413567265E-01],
	[3.4220000000E+04, 2.6106176529E+01, 5.1730662864E+00, 9.6472074719E+00, 2.9826618011E+00, 9.4416143843E-01],
	[3.4225000000E+04, 2.6112649659E+01, 5.1730789931E+00, 9.6517880288E+00, 2.9831882330E+00, 9.4418719127E-01],
	[3.4230000000E+04, 2.6119123448E+01, 5.1730916980E+00, 9.6563700899E+00, 2.9837145451E+00, 9.4421293118E-01],
	[3.4235000000E+04, 2.6125597896E+01, 5.1731044011E+00, 9.6609536554E+00, 2.9842407372E+00, 9.4423865816E-01],
	[3.4240000000E+04, 2.6132073003E+01, 5.1731171023E+00, 9.6655387257E+00, 2.9847668093E+00, 9.4426437221E-01],
	[3.4245000000E+04, 2.6138548769E+01, 5.1731298017E+00, 9.6701253010E+00, 2.9852927616E+00, 9.4429007336E-01],
	[3.4250000000E+04, 2.6145025194E+01, 5.1731424993E+00, 9.6747133815E+00, 2.9858185938E+00, 9.4431576159E-01],
	[3.4255000000E+04, 2.6151502278E+01, 5.1731551951E+00, 9.6793029676E+00, 2.9863443062E+00, 9.4434143692E-01],
	[3.4260000000E+04, 2.6157980021E+01, 5.1731678890E+00, 9.6838940595E+00, 2.9868698986E+00, 9.4436709935E-01],
	[3.4265000000E+04, 2.6164458423E+01, 5.1731805811E+00, 9.6884866575E+00, 2.9873953711E+00, 9.4439274890E-01],
	[3.4270000000E+04, 2.6170937484E+01, 5.1731932714E+00, 9.6930807619E+00, 2.9879207236E+00, 9.4441838556E-01],
	[3.4275000000E+04, 2.6177417203E+01, 5.1732059599E+00, 9.6976763729E+00, 2.9884459562E+00, 9.4444400935E-01],
	[3.4280000000E+04, 2.6183897581E+01, 5.1732186466E+00, 9.7022734908E+00, 2.9889710689E+00, 9.4446962026E-01],
	[3.4285000000E+04, 2.6190378618E+01, 5.1732313314E+00, 9.7068721160E+00, 2.9894960616E+00, 9.4449521831E-01],
	[3.4290000000E+04, 2.6196860314E+01, 5.1732440145E+00, 9.7114722485E+00, 2.9900209345E+00, 9.4452080350E-01],
	[3.4295000000E+04, 2.6203342669E+01, 5.1732566957E+00, 9.7160738889E+00, 2.9905456874E+00, 9.4454637585E-01],
	[3.4300000000E+04, 2.6209825682E+01, 5.1732693751E+00, 9.7206770372E+00, 2.9910703204E+00, 9.4457193534E-01],
	[3.4305000000E+04, 2.6216309354E+01, 5.1732820526E+00, 9.7252816938E+00, 2.9915948334E+00, 9.4459748200E-01],
	[3.4310000000E+04, 2.6222793684E+01, 5.1732947284E+00, 9.7298878589E+00, 2.9921192266E+00, 9.4462301583E-01],
	[3.4315000000E+04, 2.6229278673E+01, 5.1733074023E+00, 9.7344955329E+00, 2.9926434998E+00, 9.4464853683E-01],
	[3.4320000000E+04, 2.6235764321E+01, 5.1733200745E+00, 9.7391047160E+00, 2.9931676531E+00, 9.4467404501E-01],
	[3.4325000000E+04, 2.6242250627E+01, 5.1733327448E+00, 9.7437154085E+00, 2.9936916865E+00, 9.4469954038E-01],
	[3.4330000000E+04, 2.6248737591E+01, 5.1733454133E+00, 9.7483276106E+00, 2.9942156000E+00, 9.4472502294E-01],
	[3.4335000000E+04, 2.6255225214E+01, 5.1733580799E+00, 9.7529413227E+00, 2.9947393936E+00, 9.4475049271E-01],
	[3.4340000000E+04, 2.6261713496E+01, 5.1733707448E+00, 9.7575565449E+00, 2.9952630673E+00, 9.4477594967E-01],
	[3.4345000000E+04, 2.6268202436E+01, 5.1733834079E+00, 9.7621732777E+00, 2.9957866210E+00, 9.4480139386E-01],
	[3.4350000000E+04, 2.6274692034E+01, 5.1733960691E+00, 9.7667915211E+00, 2.9963100549E+00, 9.4482682526E-01],
	[3.4355000000E+04, 2.6281182291E+01, 5.1734087285E+00, 9.7714112756E+00, 2.9968333689E+00, 9.4485224388E-01],
	[3.4360000000E+04, 2.6287673206E+01, 5.1734213862E+00, 9.7760325414E+00, 2.9973565630E+00, 9.4487764974E-01],
	[3.4365000000E+04, 2.6294164779E+01, 5.1734340420E+00, 9.7806553188E+00, 2.9978796371E+00, 9.4490304283E-01],
	[3.4370000000E+04, 2.6300657010E+01, 5.1734466960E+00, 9.7852796080E+00, 2.9984025914E+00, 9.4492842317E-01],
	[3.4375000000E+04, 2.6307149900E+01, 5.1734593481E+00, 9.7899054093E+00, 2.9989254258E+00, 9.4495379076E-01],
	[3.4380000000E+04, 2.6313643448E+01, 5.1734719985E+00, 9.7945327230E+00, 2.9994481403E+00, 9.4497914561E-01],
	[3.4385000000E+04, 2.6320137654E+01, 5.1734846471E+00, 9.7991615494E+00, 2.9999707350E+00, 9.4500448772E-01],
	[3.4390000000E+04, 2.6326632519E+01, 5.1734972939E+00, 9.8037918887E+00, 3.0004932097E+00, 9.4502981710E-01],
	[3.4395000000E+04, 2.6333128041E+01, 5.1735099388E+00, 9.8084237412E+00, 3.0010155645E+00, 9.4505513376E-01],
	[3.4400000000E+04, 2.6339624222E+01, 5.1735225820E+00, 9.8130571072E+00, 3.0015377995E+00, 9.4508043770E-01],
	[3.4405000000E+04, 2.6346121060E+01, 5.1735352233E+00, 9.8176919870E+00, 3.0020599146E+00, 9.4510572893E-01],
	[3.4410000000E+04, 2.6352618557E+01, 5.1735478628E+00, 9.8223283808E+00, 3.0025819098E+00, 9.4513100746E-01],
	[3.4415000000E+04, 2.6359116711E+01, 5.1735605006E+00, 9.8269662889E+00, 3.0031037852E+00, 9.4515627328E-01],
	[3.4420000000E+04, 2.6365615524E+01, 5.1735731365E+00, 9.8316057115E+00, 3.0036255407E+00, 9.4518152642E-01],
	[3.4425000000E+04, 2.6372114995E+01, 5.1735857706E+00, 9.8362466491E+00, 3.0041471763E+00, 9.4520676687E-01],
	[3.4430000000E+04, 2.6378615123E+01, 5.1735984029E+00, 9.8408891018E+00, 3.0046686921E+00, 9.4523199464E-01],
	[3.4435000000E+04, 2.6385115909E+01, 5.1736110334E+00, 9.8455330698E+00, 3.0051900880E+00, 9.4525720974E-01],
	[3.4440000000E+04, 2.6391617354E+01, 5.1736236621E+00, 9.8501785536E+00, 3.0057113640E+00, 9.4528241217E-01],
	[3.4445000000E+04, 2.6398119456E+01, 5.1736362890E+00, 9.8548255533E+00, 3.0062325202E+00, 9.4530760194E-01],
	[3.4450000000E+04, 2.6404622216E+01, 5.1736489142E+00, 9.8594740692E+00, 3.0067535565E+00, 9.4533277906E-01],
	[3.4455000000E+04, 2.6411125633E+01, 5.1736615375E+00, 9.8641241016E+00, 3.0072744730E+00, 9.4535794353E-01],
	[3.4460000000E+04, 2.6417629709E+01, 5.1736741590E+00, 9.8687756508E+00, 3.0077952696E+00, 9.4538309536E-01],
	[3.4465000000E+04, 2.6424134442E+01, 5.1736867787E+00, 9.8734287171E+00, 3.0083159464E+00, 9.4540823455E-01],
	[3.4470000000E+04, 2.6430639833E+01, 5.1736993966E+00, 9.8780833006E+00, 3.0088365033E+00, 9.4543336112E-01],
	[3.4475000000E+04, 2.6437145881E+01, 5.1737120127E+00, 9.8827394018E+00, 3.0093569404E+00, 9.4545847506E-01],
	[3.4480000000E+04, 2.6443652587E+01, 5.1737246270E+00, 9.8873970208E+00, 3.0098772577E+00, 9.4548357639E-01],
	[3.4485000000E+04, 2.6450159951E+01, 5.1737372395E+00, 9.8920561580E+00, 3.0103974551E+00, 9.4550866512E-01],
	[3.4490000000E+04, 2.6456667972E+01, 5.1737498502E+00, 9.8967168136E+00, 3.0109175327E+00, 9.4553374123E-01],
	[3.4495000000E+04, 2.6463176651E+01, 5.1737624591E+00, 9.9013789879E+00, 3.0114374905E+00, 9.4555880476E-01],
	[3.4500000000E+04, 2.6469685987E+01, 5.1737750662E+00, 9.9060426811E+00, 3.0119573285E+00, 9.4558385569E-01],
	[3.4505000000E+04, 2.6476195981E+01, 5.1737876715E+00, 9.9107078936E+00, 3.0124770466E+00, 9.4560889404E-01],
	[3.4510000000E+04, 2.6482706632E+01, 5.1738002750E+00, 9.9153746256E+00, 3.0129966449E+00, 9.4563391981E-01],
	[3.4515000000E+04, 2.6489217941E+01, 5.1738128768E+00, 9.9200428774E+00, 3.0135161234E+00, 9.4565893301E-01],
	[3.4520000000E+04, 2.6495729907E+01, 5.1738254767E+00, 9.9247126493E+00, 3.0140354821E+00, 9.4568393364E-01],
	[3.4525000000E+04, 2.6502242531E+01, 5.1738380748E+00, 9.9293839415E+00, 3.0145547210E+00, 9.4570892172E-01],
	[3.4530000000E+04, 2.6508755811E+01, 5.1738506712E+00, 9.9340567542E+00, 3.0150738400E+00, 9.4573389725E-01],
	[3.4535000000E+04, 2.6515286186E+01, 5.1738655452E+00, 9.9387310879E+00, 3.0155938263E+00, 9.4575886023E-01],
	[3.4540000000E+04, 2.6521820073E+01, 5.1738808122E+00, 9.9434069428E+00, 3.0161138643E+00, 9.4578381067E-01],
	[3.4545000000E+04, 2.6528354623E+01, 5.1738960769E+00, 9.9480843190E+00, 3.0166337829E+00, 9.4580874858E-01],
	[3.4550000000E+04, 2.6534889837E+01, 5.1739113395E+00, 9.9527632170E+00, 3.0171535823E+00, 9.4583367396E-01],
	[3.4555000000E+04, 2.6541425716E+01, 5.1739266000E+00, 9.9574436370E+00, 3.0176732624E+00, 9.4585858682E-01],
	[3.4560000000E+04, 2.6547962258E+01, 5.1739418583E+00, 9.9621255792E+00, 3.0181928232E+00, 9.4588348717E-01],
	[3.4565000000E+04, 2.6554499464E+01, 5.1739571144E+00, 9.9668090440E+00, 3.0187122647E+00, 9.4590837501E-01],
	[3.4570000000E+04, 2.6561037334E+01, 5.1739723683E+00, 9.9714940315E+00, 3.0192315870E+00, 9.4593325035E-01],
	[3.4575000000E+04, 2.6567575867E+01, 5.1739876201E+00, 9.9761805421E+00, 3.0197507899E+00, 9.4595811319E-01],
	[3.4580000000E+04, 2.6574115064E+01, 5.1740028698E+00, 9.9808685761E+00, 3.0202698736E+00, 9.4598296355E-01],
	[3.4585000000E+04, 2.6580654925E+01, 5.1740181172E+00, 9.9855581337E+00, 3.0207888381E+00, 9.4600780143E-01],
	[3.4590000000E+04, 2.6587195450E+01, 5.1740333626E+00, 9.9902492152E+00, 3.0213076832E+00, 9.4603262682E-01],
	[3.4595000000E+04, 2.6593736639E+01, 5.1740486057E+00, 9.9949418209E+00, 3.0218264092E+00, 9.4605743976E-01],
	[3.4600000000E+04, 2.6600278491E+01, 5.1740638467E+00, 9.9996359511E+00, 3.0223450158E+00, 9.4608224022E-01],
	[3.4605000000E+04, 2.6606821006E+01, 5.1740790855E+00, 1.0004331606E+01, 3.0228635032E+00, 9.4610702823E-01],
	[3.4610000000E+04, 2.6613364185E+01, 5.1740943222E+00, 1.0009028786E+01, 3.0233818714E+00, 9.4613180379E-01],
	[3.4615000000E+04, 2.6619908028E+01, 5.1741095568E+00, 1.0013727491E+01, 3.0239001203E+00, 9.4615656691E-01],
	[3.4620000000E+04, 2.6626452535E+01, 5.1741247891E+00, 1.0018427722E+01, 3.0244182499E+00, 9.4618131759E-01],
	[3.4625000000E+04, 2.6632997704E+01, 5.1741400193E+00, 1.0023129478E+01, 3.0249362603E+00, 9.4620605584E-01],
	[3.4630000000E+04, 2.6639543538E+01, 5.1741552474E+00, 1.0027832761E+01, 3.0254541515E+00, 9.4623078166E-01],
	[3.4635000000E+04, 2.6646090034E+01, 5.1741704733E+00, 1.0032537570E+01, 3.0259719235E+00, 9.4625549507E-01],
	[3.4640000000E+04, 2.6652637194E+01, 5.1741856971E+00, 1.0037243905E+01, 3.0264895762E+00, 9.4628019606E-01],
	[3.4645000000E+04, 2.6659185018E+01, 5.1742009187E+00, 1.0041951768E+01, 3.0270071097E+00, 9.4630488465E-01],
	[3.4650000000E+04, 2.6665733505E+01, 5.1742161381E+00, 1.0046661157E+01, 3.0275245240E+00, 9.4632956083E-01],
	[3.4655000000E+04, 2.6672282655E+01, 5.1742313554E+00, 1.0051372075E+01, 3.0280418190E+00, 9.4635422463E-01],
	[3.4660000000E+04, 2.6678832468E+01, 5.1742465706E+00, 1.0056084520E+01, 3.0285589949E+00, 9.4637887603E-01],
	[3.4665000000E+04, 2.6685382945E+01, 5.1742617836E+00, 1.0060798493E+01, 3.0290760515E+00, 9.4640351506E-01],
	[3.4670000000E+04, 2.6691934085E+01, 5.1742769944E+00, 1.0065513994E+01, 3.0295929890E+00, 9.4642814171E-01],
	[3.4675000000E+04, 2.6698485888E+01, 5.1742922031E+00, 1.0070231024E+01, 3.0301098072E+00, 9.4645275600E-01],
	[3.4680000000E+04, 2.6705038355E+01, 5.1743074097E+00, 1.0074949582E+01, 3.0306265062E+00, 9.4647735792E-01],
	[3.4685000000E+04, 2.6711591484E+01, 5.1743226141E+00, 1.0079669670E+01, 3.0311430860E+00, 9.4650194749E-01],
	[3.4690000000E+04, 2.6718145277E+01, 5.1743378163E+00, 1.0084391287E+01, 3.0316595467E+00, 9.4652652471E-01],
	[3.4695000000E+04, 2.6724699733E+01, 5.1743530164E+00, 1.0089114434E+01, 3.0321758881E+00, 9.4655108959E-01],
	[3.4700000000E+04, 2.6731254851E+01, 5.1743682144E+00, 1.0093839111E+01, 3.0326921104E+00, 9.4657564213E-01],
	[3.4705000000E+04, 2.6737810633E+01, 5.1743834102E+00, 1.0098565318E+01, 3.0332082135E+00, 9.4660018234E-01],
	[3.4710000000E+04, 2.6744367078E+01, 5.1743986039E+00, 1.0103293055E+01, 3.0337241974E+00, 9.4662471023E-01],
	[3.4715000000E+04, 2.6750924186E+01, 5.1744137954E+00, 1.0108022323E+01, 3.0342400622E+00, 9.4664922580E-01],
	[3.4720000000E+04, 2.6757481957E+01, 5.1744289848E+00, 1.0112753122E+01, 3.0347558078E+00, 9.4667372906E-01],
	[3.4725000000E+04, 2.6764040390E+01, 5.1744441721E+00, 1.0117485453E+01, 3.0352714342E+00, 9.4669822001E-01],
	[3.4730000000E+04, 2.6770599487E+01, 5.1744593572E+00, 1.0122219315E+01, 3.0357869415E+00, 9.4672269867E-01],
	[3.4735000000E+04, 2.6777159246E+01, 5.1744745401E+00, 1.0126954709E+01, 3.0363023296E+00, 9.4674716504E-01],
	[3.4740000000E+04, 2.6783719669E+01, 5.1744897210E+00, 1.0131691635E+01, 3.0368175985E+00, 9.4677161912E-01],
	[3.4745000000E+04, 2.6790280754E+01, 5.1745048997E+00, 1.0136430094E+01, 3.0373327483E+00, 9.4679606092E-01],
	[3.4750000000E+04, 2.6796842502E+01, 5.1745200762E+00, 1.0141170085E+01, 3.0378477790E+00, 9.4682049044E-01],
	[3.4755000000E+04, 2.6803404912E+01, 5.1745352506E+00, 1.0145911609E+01, 3.0383626905E+00, 9.4684490770E-01],
	[3.4760000000E+04, 2.6809967986E+01, 5.1745504229E+00, 1.0150654666E+01, 3.0388774830E+00, 9.4686931270E-01],
	[3.4765000000E+04, 2.6816531722E+01, 5.1745655930E+00, 1.0155399257E+01, 3.0393921562E+00, 9.4689370545E-01],
	[3.4770000000E+04, 2.6823096121E+01, 5.1745807610E+00, 1.0160145382E+01, 3.0399067104E+00, 9.4691808595E-01],
	[3.4775000000E+04, 2.6829661182E+01, 5.1745959268E+00, 1.0164893041E+01, 3.0404211454E+00, 9.4694245421E-01],
	[3.4780000000E+04, 2.6836226906E+01, 5.1746110906E+00, 1.0169642234E+01, 3.0409354613E+00, 9.4696681023E-01],
	[3.4785000000E+04, 2.6842793293E+01, 5.1746262521E+00, 1.0174392961E+01, 3.0414496581E+00, 9.4699115403E-01],
	[3.4790000000E+04, 2.6849360342E+01, 5.1746414116E+00, 1.0179145224E+01, 3.0419637358E+00, 9.4701548560E-01],
	[3.4795000000E+04, 2.6855928054E+01, 5.1746565689E+00, 1.0183899022E+01, 3.0424776944E+00, 9.4703980495E-01],
	[3.4800000000E+04, 2.6862496428E+01, 5.1746717241E+00, 1.0188654355E+01, 3.0429915339E+00, 9.4706411210E-01],
	[3.4805000000E+04, 2.6869065464E+01, 5.1746868771E+00, 1.0193411224E+01, 3.0435052543E+00, 9.4708840704E-01],
	[3.4810000000E+04, 2.6875635164E+01, 5.1747020280E+00, 1.0198169628E+01, 3.0440188557E+00, 9.4711268979E-01],
	[3.4815000000E+04, 2.6882205525E+01, 5.1747171768E+00, 1.0202929570E+01, 3.0445323379E+00, 9.4713696034E-01],
	[3.4820000000E+04, 2.6888776549E+01, 5.1747323235E+00, 1.0207691047E+01, 3.0450457011E+00, 9.4716121871E-01],
	[3.4825000000E+04, 2.6895348235E+01, 5.1747474680E+00, 1.0212454061E+01, 3.0455589452E+00, 9.4718546490E-01],
	[3.4830000000E+04, 2.6901920584E+01, 5.1747626104E+00, 1.0217218613E+01, 3.0460720702E+00, 9.4720969892E-01],
	[3.4835000000E+04, 2.6908493595E+01, 5.1747777506E+00, 1.0221984702E+01, 3.0465850761E+00, 9.4723392078E-01],
	[3.4840000000E+04, 2.6915067268E+01, 5.1747928888E+00, 1.0226752328E+01, 3.0470979630E+00, 9.4725813047E-01],
	[3.4845000000E+04, 2.6921641603E+01, 5.1748080248E+00, 1.0231521493E+01, 3.0476107309E+00, 9.4728232802E-01],
	[3.4850000000E+04, 2.6928216601E+01, 5.1748231587E+00, 1.0236292195E+01, 3.0481233797E+00, 9.4730651341E-01],
	[3.4855000000E+04, 2.6934792261E+01, 5.1748382904E+00, 1.0241064436E+01, 3.0486359094E+00, 9.4733068667E-01],
	[3.4860000000E+04, 2.6941368583E+01, 5.1748534200E+00, 1.0245838216E+01, 3.0491483201E+00, 9.4735484779E-01],
	[3.4865000000E+04, 2.6947945567E+01, 5.1748685475E+00, 1.0250613534E+01, 3.0496606118E+00, 9.4737899678E-01],
	[3.4870000000E+04, 2.6954523213E+01, 5.1748836729E+00, 1.0255390392E+01, 3.0501727844E+00, 9.4740313365E-01],
	[3.4875000000E+04, 2.6961101521E+01, 5.1748987962E+00, 1.0260168790E+01, 3.0506848380E+00, 9.4742725841E-01],
	[3.4880000000E+04, 2.6967680491E+01, 5.1749139173E+00, 1.0264948727E+01, 3.0511967726E+00, 9.4745137106E-01],
	[3.4885000000E+04, 2.6974260124E+01, 5.1749290363E+00, 1.0269730205E+01, 3.0517085882E+00, 9.4747547160E-01],
	[3.4890000000E+04, 2.6980840418E+01, 5.1749441532E+00, 1.0274513223E+01, 3.0522202848E+00, 9.4749956005E-01],
	[3.4895000000E+04, 2.6987421374E+01, 5.1749592679E+00, 1.0279297781E+01, 3.0527318624E+00, 9.4752363641E-01],
	[3.4900000000E+04, 2.6994002993E+01, 5.1749743806E+00, 1.0284083880E+01, 3.0532433209E+00, 9.4754770068E-01],
	[3.4905000000E+04, 2.7000585273E+01, 5.1749894911E+00, 1.0288871521E+01, 3.0537546605E+00, 9.4757175288E-01],
	[3.4910000000E+04, 2.7007168215E+01, 5.1750045995E+00, 1.0293660703E+01, 3.0542658811E+00, 9.4759579300E-01],
	[3.4915000000E+04, 2.7013751819E+01, 5.1750197057E+00, 1.0298451427E+01, 3.0547769827E+00, 9.4761982107E-01],
	[3.4920000000E+04, 2.7020336084E+01, 5.1750348099E+00, 1.0303243693E+01, 3.0552879653E+00, 9.4764383707E-01],
	[3.4925000000E+04, 2.7026921012E+01, 5.1750499119E+00, 1.0308037501E+01, 3.0557988290E+00, 9.4766784102E-01],
	[3.4930000000E+04, 2.7033506601E+01, 5.1750650119E+00, 1.0312832852E+01, 3.0563095736E+00, 9.4769183292E-01],
	[3.4935000000E+04, 2.7040092852E+01, 5.1750801097E+00, 1.0317629745E+01, 3.0568201993E+00, 9.4771581279E-01],
	[3.4940000000E+04, 2.7046679764E+01, 5.1750952053E+00, 1.0322428182E+01, 3.0573307061E+00, 9.4773978062E-01],
	[3.4945000000E+04, 2.7053267339E+01, 5.1751102989E+00, 1.0327228162E+01, 3.0578410939E+00, 9.4776373642E-01],
	[3.4950000000E+04, 2.7059855575E+01, 5.1751253904E+00, 1.0332029686E+01, 3.0583513628E+00, 9.4778768020E-01],
	[3.4955000000E+04, 2.7066444472E+01, 5.1751404797E+00, 1.0336832753E+01, 3.0588615127E+00, 9.4781161197E-01],
	[3.4960000000E+04, 2.7073034032E+01, 5.1751555669E+00, 1.0341637365E+01, 3.0593715437E+00, 9.4783553173E-01],
	[3.4965000000E+04, 2.7079624252E+01, 5.1751706520E+00, 1.0346443522E+01, 3.0598814557E+00, 9.4785943949E-01],
	[3.4970000000E+04, 2.7086215135E+01, 5.1751857350E+00, 1.0351251223E+01, 3.0603912489E+00, 9.4788333525E-01],
	[3.4975000000E+04, 2.7092806678E+01, 5.1752008159E+00, 1.0356060469E+01, 3.0609009231E+00, 9.4790721902E-01],
	[3.4980000000E+04, 2.7099398884E+01, 5.1752158947E+00, 1.0360871261E+01, 3.0614104784E+00, 9.4793109081E-01],
	[3.4985000000E+04, 2.7105991750E+01, 5.1752309714E+00, 1.0365683598E+01, 3.0619199147E+00, 9.4795495062E-01],
	[3.4990000000E+04, 2.7112585279E+01, 5.1752460459E+00, 1.0370497481E+01, 3.0624292322E+00, 9.4797879846E-01],
	[3.4995000000E+04, 2.7119179468E+01, 5.1752611184E+00, 1.0375312910E+01, 3.0629384308E+00, 9.4800263434E-01],
	[3.5000000000E+04, 2.7125774319E+01, 5.1752761887E+00, 1.0380129886E+01, 3.0634475105E+00, 9.4802645825E-01],
	[3.5005000000E+04, 2.7132369831E+01, 5.1752912569E+00, 1.0384954405E+01, 3.0639569933E+00, 9.4805027022E-01],
	[3.5010000000E+04, 2.7138966005E+01, 5.1753063230E+00, 1.0389780476E+01, 3.0644663571E+00, 9.4807407024E-01],
	[3.5015000000E+04, 2.7145562840E+01, 5.1753213870E+00, 1.0394608099E+01, 3.0649756017E+00, 9.4809785832E-01],
	[3.5020000000E+04, 2.7152160336E+01, 5.1753364489E+00, 1.0399437274E+01, 3.0654847273E+00, 9.4812163447E-01],
	[3.5025000000E+04, 2.7158758493E+01, 5.1753515087E+00, 1.0404268002E+01, 3.0659937338E+00, 9.4814539869E-01],
	[3.5030000000E+04, 2.7165357312E+01, 5.1753665664E+00, 1.0409100283E+01, 3.0665026213E+00, 9.4816915099E-01],
	[3.5035000000E+04, 2.7171956792E+01, 5.1753816220E+00, 1.0413934117E+01, 3.0670113897E+00, 9.4819289137E-01],
	[3.5040000000E+04, 2.7178556933E+01, 5.1753966755E+00, 1.0418769505E+01, 3.0675200391E+00, 9.4821661985E-01],
	[3.5045000000E+04, 2.7185157735E+01, 5.1754117269E+00, 1.0423606446E+01, 3.0680285694E+00, 9.4824033642E-01],
	[3.5050000000E+04, 2.7191759198E+01, 5.1754267761E+00, 1.0428444942E+01, 3.0685369807E+00, 9.4826404110E-01],
	[3.5055000000E+04, 2.7198361322E+01, 5.1754418233E+00, 1.0433284991E+01, 3.0690452730E+00, 9.4828773389E-01],
	[3.5060000000E+04, 2.7204964107E+01, 5.1754568684E+00, 1.0438126596E+01, 3.0695534462E+00, 9.4831141480E-01],
	[3.5065000000E+04, 2.7211567553E+01, 5.1754719113E+00, 1.0442969755E+01, 3.0700615005E+00, 9.4833508383E-01],
	[3.5070000000E+04, 2.7218171660E+01, 5.1754869522E+00, 1.0447814469E+01, 3.0705694357E+00, 9.4835874099E-01],
	[3.5075000000E+04, 2.7224776428E+01, 5.1755019909E+00, 1.0452660739E+01, 3.0710772519E+00, 9.4838238628E-01],
	[3.5080000000E+04, 2.7231381857E+01, 5.1755170276E+00, 1.0457508564E+01, 3.0715849491E+00, 9.4840601972E-01],
	[3.5085000000E+04, 2.7237987947E+01, 5.1755320622E+00, 1.0462357946E+01, 3.0720925273E+00, 9.4842964130E-01],
	[3.5090000000E+04, 2.7244607522E+01, 5.1755488570E+00, 1.0467208883E+01, 3.0726007708E+00, 9.4845325104E-01],
	[3.5095000000E+04, 2.7251234003E+01, 5.1755665067E+00, 1.0472061377E+01, 3.0731092772E+00, 9.4847684894E-01],
	[3.5100000000E+04, 2.7257861150E+01, 5.1755841539E+00, 1.0476915428E+01, 3.0736176651E+00, 9.4850043500E-01],
	[3.5105000000E+04, 2.7264488965E+01, 5.1756017987E+00, 1.0481771036E+01, 3.0741259346E+00, 9.4852400924E-01],
	[3.5110000000E+04, 2.7271117447E+01, 5.1756194411E+00, 1.0486628202E+01, 3.0746340855E+00, 9.4854757166E-01],
	[3.5115000000E+04, 2.7277746597E+01, 5.1756370810E+00, 1.0491486925E+01, 3.0751421180E+00, 9.4857112226E-01],
	[3.5120000000E+04, 2.7284376414E+01, 5.1756547184E+00, 1.0496347206E+01, 3.0756500320E+00, 9.4859466106E-01],
	[3.5125000000E+04, 2.7291006898E+01, 5.1756723534E+00, 1.0501209045E+01, 3.0761578276E+00, 9.4861818805E-01],
	[3.5130000000E+04, 2.7297638049E+01, 5.1756899860E+00, 1.0506072442E+01, 3.0766655047E+00, 9.4864170325E-01],
	[3.5135000000E+04, 2.7304269867E+01, 5.1757076161E+00, 1.0510937398E+01, 3.0771730633E+00, 9.4866520666E-01],
	[3.5140000000E+04, 2.7310902352E+01, 5.1757252437E+00, 1.0515803914E+01, 3.0776805035E+00, 9.4868869828E-01],
	[3.5145000000E+04, 2.7317535505E+01, 5.1757428689E+00, 1.0520671988E+01, 3.0781878253E+00, 9.4871217813E-01],
	[3.5150000000E+04, 2.7324169324E+01, 5.1757604917E+00, 1.0525541622E+01, 3.0786950286E+00, 9.4873564620E-01],
	[3.5155000000E+04, 2.7330803811E+01, 5.1757781120E+00, 1.0530412816E+01, 3.0792021135E+00, 9.4875910251E-01],
	[3.5160000000E+04, 2.7337438965E+01, 5.1757957299E+00, 1.0535285570E+01, 3.0797090800E+00, 9.4878254706E-01],
	[3.5165000000E+04, 2.7344074785E+01, 5.1758133453E+00, 1.0540159885E+01, 3.0802159280E+00, 9.4880597986E-01],
	[3.5170000000E+04, 2.7350711273E+01, 5.1758309583E+00, 1.0545035760E+01, 3.0807226577E+00, 9.4882940092E-01],
	[3.5175000000E+04, 2.7357348427E+01, 5.1758485688E+00, 1.0549913196E+01, 3.0812292689E+00, 9.4885281023E-01],
	[3.5180000000E+04, 2.7363986249E+01, 5.1758661769E+00, 1.0554792194E+01, 3.0817357618E+00, 9.4887620781E-01],
	[3.5185000000E+04, 2.7370624737E+01, 5.1758837825E+00, 1.0559672752E+01, 3.0822421363E+00, 9.4889959366E-01],
	[3.5190000000E+04, 2.7377263892E+01, 5.1759013857E+00, 1.0564554873E+01, 3.0827483924E+00, 9.4892296780E-01],
	[3.5195000000E+04, 2.7383903714E+01, 5.1759189865E+00, 1.0569438556E+01, 3.0832545301E+00, 9.4894633021E-01],
	[3.5200000000E+04, 2.7390544203E+01, 5.1759365848E+00, 1.0574323801E+01, 3.0837605494E+00, 9.4896968092E-01],
	[3.5205000000E+04, 2.7397185358E+01, 5.1759541807E+00, 1.0579210609E+01, 3.0842664504E+00, 9.4899301993E-01],
	[3.5210000000E+04, 2.7403827181E+01, 5.1759717741E+00, 1.0584098979E+01, 3.0847722330E+00, 9.4901634723E-01],
	[3.5215000000E+04, 2.7410469670E+01, 5.1759893651E+00, 1.0588988913E+01, 3.0852778973E+00, 9.4903966285E-01],
	[3.5220000000E+04, 2.7417112825E+01, 5.1760069537E+00, 1.0593880410E+01, 3.0857834433E+00, 9.4906296679E-01],
	[3.5225000000E+04, 2.7423756648E+01, 5.1760245398E+00, 1.0598773471E+01, 3.0862888709E+00, 9.4908625904E-01],
	[3.5230000000E+04, 2.7430401136E+01, 5.1760421235E+00, 1.0603668096E+01, 3.0867941801E+00, 9.4910953963E-01],
	[3.5235000000E+04, 2.7437046292E+01, 5.1760597048E+00, 1.0608564285E+01, 3.0872993711E+00, 9.4913280855E-01],
	[3.5240000000E+04, 2.7443692114E+01, 5.1760772836E+00, 1.0613462039E+01, 3.0878044437E+00, 9.4915606581E-01],
	[3.5245000000E+04, 2.7450338603E+01, 5.1760948600E+00, 1.0618361358E+01, 3.0883093981E+00, 9.4917931141E-01],
	[3.5250000000E+04, 2.7456985758E+01, 5.1761124339E+00, 1.0623262241E+01, 3.0888142341E+00, 9.4920254538E-01],
	[3.5255000000E+04, 2.7463633580E+01, 5.1761300055E+00, 1.0628164690E+01, 3.0893189518E+00, 9.4922576769E-01],
	[3.5260000000E+04, 2.7470282068E+01, 5.1761475745E+00, 1.0633068705E+01, 3.0898235513E+00, 9.4924897838E-01],
	[3.5265000000E+04, 2.7476931222E+01, 5.1761651412E+00, 1.0637974286E+01, 3.0903280324E+00, 9.4927217744E-01],
	[3.5270000000E+04, 2.7483581043E+01, 5.1761827054E+00, 1.0642881433E+01, 3.0908323953E+00, 9.4929536487E-01],
	[3.5275000000E+04, 2.7490231530E+01, 5.1762002672E+00, 1.0647790146E+01, 3.0913366399E+00, 9.4931854069E-01],
	[3.5280000000E+04, 2.7496882684E+01, 5.1762178266E+00, 1.0652700427E+01, 3.0918407663E+00, 9.4934170490E-01],
	[3.5285000000E+04, 2.7503534504E+01, 5.1762353835E+00, 1.0657612274E+01, 3.0923447744E+00, 9.4936485751E-01],
	[3.5290000000E+04, 2.7510186990E+01, 5.1762529380E+00, 1.0662525689E+01, 3.0928486642E+00, 9.4938799851E-01],
	[3.5295000000E+04, 2.7516840143E+01, 5.1762704901E+00, 1.0667440671E+01, 3.0933524358E+00, 9.4941112793E-01],
	[3.5300000000E+04, 2.7523493962E+01, 5.1762880398E+00, 1.0672357221E+01, 3.0938560892E+00, 9.4943424576E-01],
	[3.5305000000E+04, 2.7530148447E+01, 5.1763055870E+00, 1.0677275339E+01, 3.0943596244E+00, 9.4945735202E-01],
	[3.5310000000E+04, 2.7536803598E+01, 5.1763231318E+00, 1.0682195026E+01, 3.0948630413E+00, 9.4948044669E-01],
	[3.5315000000E+04, 2.7543459415E+01, 5.1763406742E+00, 1.0687116281E+01, 3.0953663400E+00, 9.4950352980E-01],
	[3.5320000000E+04, 2.7550115899E+01, 5.1763582141E+00, 1.0692039106E+01, 3.0958695205E+00, 9.4952660135E-01],
	[3.5325000000E+04, 2.7556773048E+01, 5.1763757517E+00, 1.0696963500E+01, 3.0963725828E+00, 9.4954966134E-01],
	[3.5330000000E+04, 2.7563430864E+01, 5.1763932868E+00, 1.0701889463E+01, 3.0968755270E+00, 9.4957270977E-01],
	[3.5335000000E+04, 2.7570089346E+01, 5.1764108195E+00, 1.0706816996E+01, 3.0973783529E+00, 9.4959574666E-01],
	[3.5340000000E+04, 2.7576748493E+01, 5.1764283497E+00, 1.0711746099E+01, 3.0978810607E+00, 9.4961877201E-01],
	[3.5345000000E+04, 2.7583408307E+01, 5.1764458776E+00, 1.0716676773E+01, 3.0983836503E+00, 9.4964178582E-01],
	[3.5350000000E+04, 2.7590068787E+01, 5.1764634030E+00, 1.0721609017E+01, 3.0988861217E+00, 9.4966478810E-01],
	[3.5355000000E+04, 2.7596729932E+01, 5.1764809260E+00, 1.0726542832E+01, 3.0993884750E+00, 9.4968777886E-01],
	[3.5360000000E+04, 2.7603391744E+01, 5.1764984466E+00, 1.0731478219E+01, 3.0998907101E+00, 9.4971075810E-01],
	[3.5365000000E+04, 2.7610054221E+01, 5.1765159647E+00, 1.0736415177E+01, 3.1003928271E+00, 9.4973372583E-01],
	[3.5370000000E+04, 2.7616717364E+01, 5.1765334805E+00, 1.0741353706E+01, 3.1008948259E+00, 9.4975668205E-01],
	[3.5375000000E+04, 2.7623381173E+01, 5.1765509938E+00, 1.0746293808E+01, 3.1013967067E+00, 9.4977962676E-01],
	[3.5380000000E+04, 2.7630045648E+01, 5.1765685048E+00, 1.0751235482E+01, 3.1018984693E+00, 9.4980255998E-01],
	[3.5385000000E+04, 2.7636710789E+01, 5.1765860133E+00, 1.0756178729E+01, 3.1024001138E+00, 9.4982548171E-01],
	[3.5390000000E+04, 2.7643376595E+01, 5.1766035193E+00, 1.0761123549E+01, 3.1029016402E+00, 9.4984839195E-01],
	[3.5395000000E+04, 2.7650043067E+01, 5.1766210230E+00, 1.0766069941E+01, 3.1034030485E+00, 9.4987129071E-01],
	[3.5400000000E+04, 2.7656710205E+01, 5.1766385243E+00, 1.0771017908E+01, 3.1039043387E+00, 9.4989417800E-01],
	[3.5405000000E+04, 2.7663378008E+01, 5.1766560231E+00, 1.0775967447E+01, 3.1044055108E+00, 9.4991705382E-01],
	[3.5410000000E+04, 2.7670046477E+01, 5.1766735196E+00, 1.0780918561E+01, 3.1049065649E+00, 9.4993991818E-01],
	[3.5415000000E+04, 2.7676715612E+01, 5.1766910136E+00, 1.0785871250E+01, 3.1054075009E+00, 9.4996277108E-01],
	[3.5420000000E+04, 2.7683385412E+01, 5.1767085052E+00, 1.0790825512E+01, 3.1059083188E+00, 9.4998561252E-01],
	[3.5425000000E+04, 2.7690055878E+01, 5.1767259944E+00, 1.0795781350E+01, 3.1064090187E+00, 9.5000844252E-01],
	[3.5430000000E+04, 2.7696727009E+01, 5.1767434812E+00, 1.0800738763E+01, 3.1069096006E+00, 9.5003126108E-01],
	[3.5435000000E+04, 2.7703398806E+01, 5.1767609656E+00, 1.0805697751E+01, 3.1074100644E+00, 9.5005406821E-01],
	[3.5440000000E+04, 2.7710071268E+01, 5.1767784476E+00, 1.0810658314E+01, 3.1079104102E+00, 9.5007686390E-01],
	[3.5445000000E+04, 2.7716744396E+01, 5.1767959271E+00, 1.0815620454E+01, 3.1084106379E+00, 9.5009964817E-01],
	[3.5450000000E+04, 2.7723418189E+01, 5.1768134043E+00, 1.0820584170E+01, 3.1089107477E+00, 9.5012242102E-01],
	[3.5455000000E+04, 2.7730092647E+01, 5.1768308791E+00, 1.0825549462E+01, 3.1094107394E+00, 9.5014518246E-01],
	[3.5460000000E+04, 2.7736767771E+01, 5.1768483514E+00, 1.0830516331E+01, 3.1099106132E+00, 9.5016793249E-01],
	[3.5465000000E+04, 2.7743443560E+01, 5.1768658214E+00, 1.0835484777E+01, 3.1104103689E+00, 9.5019067112E-01],
	[3.5470000000E+04, 2.7750120015E+01, 5.1768832889E+00, 1.0840454801E+01, 3.1109100067E+00, 9.5021339835E-01],
	[3.5475000000E+04, 2.7756797135E+01, 5.1769007541E+00, 1.0845426402E+01, 3.1114095265E+00, 9.5023611419E-01],
	[3.5480000000E+04, 2.7763474920E+01, 5.1769182168E+00, 1.0850399581E+01, 3.1119089284E+00, 9.5025881865E-01],
	[3.5485000000E+04, 2.7770153370E+01, 5.1769356771E+00, 1.0855374338E+01, 3.1124082123E+00, 9.5028151173E-01],
	[3.5490000000E+04, 2.7776832485E+01, 5.1769531351E+00, 1.0860350674E+01, 3.1129073782E+00, 9.5030419343E-01],
	[3.5495000000E+04, 2.7783512266E+01, 5.1769705906E+00, 1.0865328588E+01, 3.1134064262E+00, 9.5032686376E-01],
	[3.5500000000E+04, 2.7790192711E+01, 5.1769880437E+00, 1.0870308082E+01, 3.1139053563E+00, 9.5034952273E-01],
	[3.5505000000E+04, 2.7796873822E+01, 5.1770054945E+00, 1.0875289154E+01, 3.1144041684E+00, 9.5037217034E-01],
	[3.5510000000E+04, 2.7803555598E+01, 5.1770229428E+00, 1.0880271806E+01, 3.1149028626E+00, 9.5039480660E-01],
	[3.5515000000E+04, 2.7810238039E+01, 5.1770403888E+00, 1.0885256038E+01, 3.1154014389E+00, 9.5041743152E-01],
	[3.5520000000E+04, 2.7816921145E+01, 5.1770578323E+00, 1.0890241850E+01, 3.1158998973E+00, 9.5044004509E-01],
	[3.5525000000E+04, 2.7823604916E+01, 5.1770752735E+00, 1.0895229243E+01, 3.1163982379E+00, 9.5046264733E-01],
	[3.5530000000E+04, 2.7830289352E+01, 5.1770927122E+00, 1.0900218216E+01, 3.1168964605E+00, 9.5048523824E-01],
	[3.5535000000E+04, 2.7836974453E+01, 5.1771101486E+00, 1.0905208770E+01, 3.1173945653E+00, 9.5050781783E-01],
	[3.5540000000E+04, 2.7843660219E+01, 5.1771275825E+00, 1.0910200905E+01, 3.1178925522E+00, 9.5053038609E-01],
	[3.5545000000E+04, 2.7850346649E+01, 5.1771450141E+00, 1.0915194622E+01, 3.1183904212E+00, 9.5055294305E-01],
	[3.5550000000E+04, 2.7857033745E+01, 5.1771624433E+00, 1.0920189921E+01, 3.1188881724E+00, 9.5057548869E-01],
	[3.5555000000E+04, 2.7863721505E+01, 5.1771798701E+00, 1.0925186801E+01, 3.1193858057E+00, 9.5059802304E-01],
	[3.5560000000E+04, 2.7870409930E+01, 5.1771972944E+00, 1.0930185264E+01, 3.1198833212E+00, 9.5062054608E-01],
	[3.5565000000E+04, 2.7877099020E+01, 5.1772147164E+00, 1.0935185310E+01, 3.1203807189E+00, 9.5064305784E-01],
	[3.5570000000E+04, 2.7883788775E+01, 5.1772321360E+00, 1.0940186938E+01, 3.1208779988E+00, 9.5066555831E-01],
	[3.5575000000E+04, 2.7890479194E+01, 5.1772495533E+00, 1.0945190150E+01, 3.1213751608E+00, 9.5068804751E-01],
	[3.5580000000E+04, 2.7897170278E+01, 5.1772669681E+00, 1.0950194945E+01, 3.1218722050E+00, 9.5071052542E-01],
	[3.5585000000E+04, 2.7903862027E+01, 5.1772843805E+00, 1.0955201324E+01, 3.1223691315E+00, 9.5073299207E-01],
	[3.5590000000E+04, 2.7910554441E+01, 5.1773017906E+00, 1.0960209286E+01, 3.1228659402E+00, 9.5075544746E-01],
	[3.5595000000E+04, 2.7917247519E+01, 5.1773191983E+00, 1.0965218833E+01, 3.1233626311E+00, 9.5077789159E-01],
	[3.5600000000E+04, 2.7923941261E+01, 5.1773366035E+00, 1.0970229965E+01, 3.1238592042E+00, 9.5080032447E-01],
	[3.5605000000E+04, 2.7930635669E+01, 5.1773540064E+00, 1.0975242682E+01, 3.1243556596E+00, 9.5082274610E-01],
	[3.5610000000E+04, 2.7937330740E+01, 5.1773714069E+00, 1.0980256983E+01, 3.1248519972E+00, 9.5084515649E-01],
	[3.5615000000E+04, 2.7944026477E+01, 5.1773888051E+00, 1.0985272870E+01, 3.1253482170E+00, 9.5086755565E-01],
	[3.5620000000E+04, 2.7950722877E+01, 5.1774062008E+00, 1.0990290343E+01, 3.1258443192E+00, 9.5088994358E-01],
	[3.5625000000E+04, 2.7957419942E+01, 5.1774235942E+00, 1.0995309401E+01, 3.1263403036E+00, 9.5091232028E-01],
	[3.5630000000E+04, 2.7964117672E+01, 5.1774409851E+00, 1.1000330046E+01, 3.1268361703E+00, 9.5093468576E-01],
	[3.5635000000E+04, 2.7970816066E+01, 5.1774583737E+00, 1.1005352277E+01, 3.1273319193E+00, 9.5095704004E-01],
	[3.5640000000E+04, 2.7977515124E+01, 5.1774757599E+00, 1.1010376095E+01, 3.1278275506E+00, 9.5097938310E-01],
	[3.5645000000E+04, 2.7984214847E+01, 5.1774931438E+00, 1.1015401500E+01, 3.1283230642E+00, 9.5100171496E-01],
	[3.5650000000E+04, 2.7990915234E+01, 5.1775105252E+00, 1.1020428493E+01, 3.1288184601E+00, 9.5102403563E-01],
	[3.5655000000E+04, 2.7997629549E+01, 5.1775297073E+00, 1.1025457073E+01, 3.1293145627E+00, 9.5104634510E-01],
	[3.5660000000E+04, 2.8004350128E+01, 5.1775496473E+00, 1.1030487241E+01, 3.1298108957E+00, 9.5106864339E-01],
	[3.5665000000E+04, 2.8011071377E+01, 5.1775695846E+00, 1.1035518997E+01, 3.1303071116E+00, 9.5109093051E-01],
	[3.5670000000E+04, 2.8017793298E+01, 5.1775895192E+00, 1.1040552342E+01, 3.1308032103E+00, 9.5111320644E-01],
	[3.5675000000E+04, 2.8024515888E+01, 5.1776094510E+00, 1.1045587275E+01, 3.1312991917E+00, 9.5113547121E-01],
	[3.5680000000E+04, 2.8031239150E+01, 5.1776293802E+00, 1.1050623797E+01, 3.1317950561E+00, 9.5115772482E-01],
	[3.5685000000E+04, 2.8037963082E+01, 5.1776493066E+00, 1.1055661909E+01, 3.1322908032E+00, 9.5117996727E-01],
	[3.5690000000E+04, 2.8044687684E+01, 5.1776692303E+00, 1.1060701610E+01, 3.1327864332E+00, 9.5120219857E-01],
	[3.5695000000E+04, 2.8051412957E+01, 5.1776891513E+00, 1.1065742901E+01, 3.1332819461E+00, 9.5122441872E-01],
	[3.5700000000E+04, 2.8058138900E+01, 5.1777090696E+00, 1.1070785782E+01, 3.1337773418E+00, 9.5124662773E-01],
	[3.5705000000E+04, 2.8064865514E+01, 5.1777289851E+00, 1.1075830253E+01, 3.1342726204E+00, 9.5126882560E-01],
	[3.5710000000E+04, 2.8071592798E+01, 5.1777488980E+00, 1.1080876316E+01, 3.1347677819E+00, 9.5129101235E-01],
	[3.5715000000E+04, 2.8078320753E+01, 5.1777688081E+00, 1.1085923969E+01, 3.1352628262E+00, 9.5131318797E-01],
	[3.5720000000E+04, 2.8085049377E+01, 5.1777887156E+00, 1.1090973213E+01, 3.1357577535E+00, 9.5133535247E-01],
	[3.5725000000E+04, 2.8091778673E+01, 5.1778086203E+00, 1.1096024049E+01, 3.1362525637E+00, 9.5135750587E-01],
	[3.5730000000E+04, 2.8098508638E+01, 5.1778285223E+00, 1.1101076477E+01, 3.1367472567E+00, 9.5137964815E-01],
	[3.5735000000E+04, 2.8105239274E+01, 5.1778484216E+00, 1.1106130496E+01, 3.1372418328E+00, 9.5140177933E-01],
	[3.5740000000E+04, 2.8111970579E+01, 5.1778683182E+00, 1.1111186108E+01, 3.1377362917E+00, 9.5142389942E-01],
	[3.5745000000E+04, 2.8118702555E+01, 5.1778882121E+00, 1.1116243313E+01, 3.1382306336E+00, 9.5144600841E-01],
	[3.5750000000E+04, 2.8125435202E+01, 5.1779081033E+00, 1.1121302111E+01, 3.1387248584E+00, 9.5146810632E-01],
	[3.5755000000E+04, 2.8132168518E+01, 5.1779279918E+00, 1.1126362502E+01, 3.1392189662E+00, 9.5149019315E-01],
	[3.5760000000E+04, 2.8138902504E+01, 5.1779478775E+00, 1.1131424486E+01, 3.1397129570E+00, 9.5151226891E-01],
	[3.5765000000E+04, 2.8145637161E+01, 5.1779677606E+00, 1.1136488064E+01, 3.1402068308E+00, 9.5153433360E-01],
	[3.5770000000E+04, 2.8152372488E+01, 5.1779876410E+00, 1.1141553236E+01, 3.1407005875E+00, 9.5155638723E-01],
	[3.5775000000E+04, 2.8159108484E+01, 5.1780075186E+00, 1.1146620002E+01, 3.1411942272E+00, 9.5157842979E-01],
	[3.5780000000E+04, 2.8165845151E+01, 5.1780273936E+00, 1.1151688363E+01, 3.1416877500E+00, 9.5160046131E-01],
	[3.5785000000E+04, 2.8172582488E+01, 5.1780472659E+00, 1.1156758319E+01, 3.1421811558E+00, 9.5162248178E-01],
	[3.5790000000E+04, 2.8179320494E+01, 5.1780671354E+00, 1.1161829869E+01, 3.1426744445E+00, 9.5164449121E-01],
	[3.5795000000E+04, 2.8186059171E+01, 5.1780870023E+00, 1.1166903016E+01, 3.1431676164E+00, 9.5166648961E-01],
	[3.5800000000E+04, 2.8192798517E+01, 5.1781068664E+00, 1.1171977758E+01, 3.1436606712E+00, 9.5168847697E-01],
	[3.5805000000E+04, 2.8199538533E+01, 5.1781267279E+00, 1.1177054095E+01, 3.1441536091E+00, 9.5171045331E-01],
	[3.5810000000E+04, 2.8206279219E+01, 5.1781465867E+00, 1.1182132030E+01, 3.1446464301E+00, 9.5173241864E-01],
	[3.5815000000E+04, 2.8213020575E+01, 5.1781664427E+00, 1.1187211560E+01, 3.1451391342E+00, 9.5175437295E-01],
	[3.5820000000E+04, 2.8219762601E+01, 5.1781862961E+00, 1.1192292688E+01, 3.1456317213E+00, 9.5177631625E-01],
	[3.5825000000E+04, 2.8226505297E+01, 5.1782061468E+00, 1.1197375412E+01, 3.1461241915E+00, 9.5179824855E-01],
	[3.5830000000E+04, 2.8233248662E+01, 5.1782259948E+00, 1.1202459734E+01, 3.1466165448E+00, 9.5182016985E-01],
	[3.5835000000E+04, 2.8239992697E+01, 5.1782458401E+00, 1.1207545654E+01, 3.1471087813E+00, 9.5184208017E-01],
	[3.5840000000E+04, 2.8246737401E+01, 5.1782656827E+00, 1.1212633171E+01, 3.1476009008E+00, 9.5186397950E-01],
	[3.5845000000E+04, 2.8253482776E+01, 5.1782855226E+00, 1.1217722287E+01, 3.1480929035E+00, 9.5188586784E-01],
	[3.5850000000E+04, 2.8260228819E+01, 5.1783053598E+00, 1.1222813001E+01, 3.1485847893E+00, 9.5190774522E-01],
	[3.5855000000E+04, 2.8266975533E+01, 5.1783251943E+00, 1.1227905314E+01, 3.1490765583E+00, 9.5192961163E-01],
	[3.5860000000E+04, 2.8273722916E+01, 5.1783450262E+00, 1.1232999225E+01, 3.1495682104E+00, 9.5195146707E-01],
	[3.5865000000E+04, 2.8280470969E+01, 5.1783648553E+00, 1.1238094737E+01, 3.1500597456E+00, 9.5197331155E-01],
	[3.5870000000E+04, 2.8287219691E+01, 5.1783846818E+00, 1.1243191847E+01, 3.1505511641E+00, 9.5199514509E-01],
	[3.5875000000E+04, 2.8293969082E+01, 5.1784045056E+00, 1.1248290558E+01, 3.1510424657E+00, 9.5201696768E-01],
	[3.5880000000E+04, 2.8300719144E+01, 5.1784243266E+00, 1.1253390869E+01, 3.1515336506E+00, 9.5203877932E-01],
	[3.5885000000E+04, 2.8307469874E+01, 5.1784441450E+00, 1.1258492780E+01, 3.1520247186E+00, 9.5206058003E-01],
	[3.5890000000E+04, 2.8314221274E+01, 5.1784639607E+00, 1.1263596292E+01, 3.1525156698E+00, 9.5208236982E-01],
	[3.5895000000E+04, 2.8320973343E+01, 5.1784837738E+00, 1.1268701405E+01, 3.1530065043E+00, 9.5210414867E-01],
	[3.5900000000E+04, 2.8327726082E+01, 5.1785035841E+00, 1.1273808119E+01, 3.1534972220E+00, 9.5212591661E-01],
	[3.5905000000E+04, 2.8334479490E+01, 5.1785233918E+00, 1.1278916434E+01, 3.1539878229E+00, 9.5214767364E-01],
	[3.5910000000E+04, 2.8341233567E+01, 5.1785431968E+00, 1.1284026352E+01, 3.1544783071E+00, 9.5216941976E-01],
	[3.5915000000E+04, 2.8347988314E+01, 5.1785629991E+00, 1.1289137871E+01, 3.1549686746E+00, 9.5219115497E-01],
	[3.5920000000E+04, 2.8354743730E+01, 5.1785827987E+00, 1.1294250993E+01, 3.1554589253E+00, 9.5221287929E-01],
	[3.5925000000E+04, 2.8361499815E+01, 5.1786025956E+00, 1.1299365718E+01, 3.1559490593E+00, 9.5223459272E-01],
	[3.5930000000E+04, 2.8368256569E+01, 5.1786223899E+00, 1.1304482045E+01, 3.1564390766E+00, 9.5225629526E-01],
	[3.5935000000E+04, 2.8375013993E+01, 5.1786421815E+00, 1.1309599976E+01, 3.1569289772E+00, 9.5227798692E-01],
	[3.5940000000E+04, 2.8381772085E+01, 5.1786619704E+00, 1.1314719510E+01, 3.1574187611E+00, 9.5229966771E-01],
	[3.5945000000E+04, 2.8388530847E+01, 5.1786817566E+00, 1.1319840648E+01, 3.1579084283E+00, 9.5232133763E-01],
	[3.5950000000E+04, 2.8395290278E+01, 5.1787015401E+00, 1.1324963390E+01, 3.1583979789E+00, 9.5234299669E-01],
	[3.5955000000E+04, 2.8402050378E+01, 5.1787213210E+00, 1.1330087736E+01, 3.1588874127E+00, 9.5236464489E-01],
	[3.5960000000E+04, 2.8408811147E+01, 5.1787410992E+00, 1.1335213687E+01, 3.1593767300E+00, 9.5238628223E-01],
	[3.5965000000E+04, 2.8415572585E+01, 5.1787608747E+00, 1.1340341243E+01, 3.1598659306E+00, 9.5240790873E-01],
	[3.5970000000E+04, 2.8422334691E+01, 5.1787806476E+00, 1.1345470404E+01, 3.1603550146E+00, 9.5242952439E-01],
	[3.5975000000E+04, 2.8429097467E+01, 5.1788004177E+00, 1.1350601171E+01, 3.1608439819E+00, 9.5245112921E-01],
	[3.5980000000E+04, 2.8435860912E+01, 5.1788201852E+00, 1.1355733543E+01, 3.1613328327E+00, 9.5247272320E-01],
	[3.5985000000E+04, 2.8442625026E+01, 5.1788399501E+00, 1.1360867521E+01, 3.1618215668E+00, 9.5249430637E-01],
	[3.5990000000E+04, 2.8449389808E+01, 5.1788597122E+00, 1.1366003105E+01, 3.1623101843E+00, 9.5251587872E-01],
	[3.5995000000E+04, 2.8456155260E+01, 5.1788794717E+00, 1.1371140296E+01, 3.1627986853E+00, 9.5253744025E-01],
	[3.6000000000E+04, 2.8462921380E+01, 5.1788992285E+00, 1.1376279094E+01, 3.1632870697E+00, 9.5255899098E-01],
	[3.6005000000E+04, 2.8469688169E+01, 5.1789189827E+00, 1.1381419499E+01, 3.1637753375E+00, 9.5258053090E-01],
	[3.6010000000E+04, 2.8476455627E+01, 5.1789387342E+00, 1.1386561511E+01, 3.1642634888E+00, 9.5260206003E-01],
	[3.6015000000E+04, 2.8483223753E+01, 5.1789584830E+00, 1.1391705131E+01, 3.1647515236E+00, 9.5262357836E-01],
	[3.6020000000E+04, 2.8489992549E+01, 5.1789782292E+00, 1.1396850359E+01, 3.1652394418E+00, 9.5264508591E-01],
	[3.6025000000E+04, 2.8496762013E+01, 5.1789979726E+00, 1.1401997195E+01, 3.1657272435E+00, 9.5266658268E-01],
	[3.6030000000E+04, 2.8503532145E+01, 5.1790177135E+00, 1.1407145639E+01, 3.1662149287E+00, 9.5268806867E-01],
	[3.6035000000E+04, 2.8510302946E+01, 5.1790374516E+00, 1.1412295693E+01, 3.1667024974E+00, 9.5270954390E-01],
	[3.6040000000E+04, 2.8517074416E+01, 5.1790571871E+00, 1.1417447355E+01, 3.1671899496E+00, 9.5273100836E-01],
	[3.6045000000E+04, 2.8523846555E+01, 5.1790769200E+00, 1.1422600627E+01, 3.1676772853E+00, 9.5275246206E-01],
	[3.6050000000E+04, 2.8530619362E+01, 5.1790966501E+00, 1.1427755508E+01, 3.1681645045E+00, 9.5277390501E-01],
	[3.6055000000E+04, 2.8537392837E+01, 5.1791163776E+00, 1.1432912000E+01, 3.1686516073E+00, 9.5279533721E-01],
	[3.6060000000E+04, 2.8544166981E+01, 5.1791361025E+00, 1.1438070101E+01, 3.1691385937E+00, 9.5281675867E-01],
	[3.6065000000E+04, 2.8550941794E+01, 5.1791558247E+00, 1.1443229813E+01, 3.1696254636E+00, 9.5283816939E-01],
	[3.6070000000E+04, 2.8557717275E+01, 5.1791755442E+00, 1.1448391136E+01, 3.1701122171E+00, 9.5285956939E-01],
	[3.6075000000E+04, 2.8564493424E+01, 5.1791952611E+00, 1.1453554069E+01, 3.1705988541E+00, 9.5288095865E-01],
	[3.6080000000E+04, 2.8571270242E+01, 5.1792149753E+00, 1.1458718614E+01, 3.1710853748E+00, 9.5290233720E-01],
	[3.6085000000E+04, 2.8578047728E+01, 5.1792346868E+00, 1.1463884771E+01, 3.1715717790E+00, 9.5292370503E-01],
	[3.6090000000E+04, 2.8584825882E+01, 5.1792543957E+00, 1.1469052539E+01, 3.1720580669E+00, 9.5294506216E-01],
	[3.6095000000E+04, 2.8591604705E+01, 5.1792741020E+00, 1.1474221920E+01, 3.1725442384E+00, 9.5296640858E-01],
	[3.6100000000E+04, 2.8598384196E+01, 5.1792938056E+00, 1.1479392913E+01, 3.1730302936E+00, 9.5298774430E-01],
	[3.6105000000E+04, 2.8605164355E+01, 5.1793135065E+00, 1.1484565518E+01, 3.1735162324E+00, 9.5300906933E-01],
	[3.6110000000E+04, 2.8611945183E+01, 5.1793332048E+00, 1.1489739737E+01, 3.1740020548E+00, 9.5303038367E-01],
	[3.6115000000E+04, 2.8618726679E+01, 5.1793529004E+00, 1.1494915569E+01, 3.1744877609E+00, 9.5305168733E-01],
	[3.6120000000E+04, 2.8625508843E+01, 5.1793725934E+00, 1.1500093014E+01, 3.1749733507E+00, 9.5307298032E-01],
	[3.6125000000E+04, 2.8632291675E+01, 5.1793922837E+00, 1.1505272073E+01, 3.1754588242E+00, 9.5309426264E-01],
	[3.6130000000E+04, 2.8639075175E+01, 5.1794119714E+00, 1.1510452746E+01, 3.1759441814E+00, 9.5311553429E-01],
	[3.6135000000E+04, 2.8645859343E+01, 5.1794316565E+00, 1.1515635034E+01, 3.1764294222E+00, 9.5313679528E-01],
	[3.6140000000E+04, 2.8652644180E+01, 5.1794513388E+00, 1.1520818936E+01, 3.1769145468E+00, 9.5315804562E-01],
	[3.6145000000E+04, 2.8659429684E+01, 5.1794710186E+00, 1.1526004453E+01, 3.1773995552E+00, 9.5317928531E-01],
	[3.6150000000E+04, 2.8666215857E+01, 5.1794906957E+00, 1.1531191586E+01, 3.1778844473E+00, 9.5320051435E-01],
	[3.6155000000E+04, 2.8673002697E+01, 5.1795103701E+00, 1.1536380334E+01, 3.1783692231E+00, 9.5322173276E-01],
	[3.6160000000E+04, 2.8679790206E+01, 5.1795300419E+00, 1.1541570697E+01, 3.1788538827E+00, 9.5324294054E-01],
	[3.6165000000E+04, 2.8686578382E+01, 5.1795497110E+00, 1.1546762677E+01, 3.1793384261E+00, 9.5326413769E-01],
	[3.6170000000E+04, 2.8693367226E+01, 5.1795693775E+00, 1.1551956273E+01, 3.1798228532E+00, 9.5328532422E-01],
	[3.6175000000E+04, 2.8700156738E+01, 5.1795890414E+00, 1.1557151485E+01, 3.1803071642E+00, 9.5330650014E-01],
	[3.6180000000E+04, 2.8706946918E+01, 5.1796087026E+00, 1.1562348315E+01, 3.1807913589E+00, 9.5332766545E-01],
	[3.6185000000E+04, 2.8713737766E+01, 5.1796283612E+00, 1.1567546761E+01, 3.1812754375E+00, 9.5334882015E-01],
	[3.6190000000E+04, 2.8720529282E+01, 5.1796480171E+00, 1.1572746825E+01, 3.1817593999E+00, 9.5336996425E-01],
	[3.6195000000E+04, 2.8727321465E+01, 5.1796676704E+00, 1.1577948507E+01, 3.1822432462E+00, 9.5339109776E-01],
	[3.6200000000E+04, 2.8734114317E+01, 5.1796873211E+00, 1.1583151807E+01, 3.1827269763E+00, 9.5341222068E-01],
	[3.6205000000E+04, 2.8740907836E+01, 5.1797069691E+00, 1.1588356725E+01, 3.1832105902E+00, 9.5343333302E-01],
	[3.6210000000E+04, 2.8747702022E+01, 5.1797266144E+00, 1.1593563261E+01, 3.1836940881E+00, 9.5345443478E-01],
	[3.6215000000E+04, 2.8754496877E+01, 5.1797462572E+00, 1.1598771417E+01, 3.1841774698E+00, 9.5347552597E-01],
	[3.6220000000E+04, 2.8761292398E+01, 5.1797658973E+00, 1.1603981191E+01, 3.1846607354E+00, 9.5349660659E-01],
	[3.6225000000E+04, 2.8768088588E+01, 5.1797855347E+00, 1.1609192585E+01, 3.1851438849E+00, 9.5351767666E-01],
	[3.6230000000E+04, 2.8774902516E+01, 5.1798074654E+00, 1.1614405598E+01, 3.1856279959E+00, 9.5353873617E-01],
	[3.6235000000E+04, 2.8781718698E+01, 5.1798296057E+00, 1.1619620232E+01, 3.1861120911E+00, 9.5355978513E-01],
	[3.6240000000E+04, 2.8788535553E+01, 5.1798517430E+00, 1.1624836486E+01, 3.1865960706E+00, 9.5358082354E-01],
	[3.6245000000E+04, 2.8795353083E+01, 5.1798738774E+00, 1.1630054360E+01, 3.1870799345E+00, 9.5360185142E-01],
	[3.6250000000E+04, 2.8802171286E+01, 5.1798960088E+00, 1.1635273855E+01, 3.1875636828E+00, 9.5362286876E-01],
	[3.6255000000E+04, 2.8808990163E+01, 5.1799181373E+00, 1.1640494971E+01, 3.1880473155E+00, 9.5364387558E-01],
	[3.6260000000E+04, 2.8815809714E+01, 5.1799402628E+00, 1.1645717708E+01, 3.1885308327E+00, 9.5366487187E-01],
	[3.6265000000E+04, 2.8822629938E+01, 5.1799623854E+00, 1.1650942067E+01, 3.1890142342E+00, 9.5368585765E-01],
	[3.6270000000E+04, 2.8829450836E+01, 5.1799845050E+00, 1.1656168048E+01, 3.1894975203E+00, 9.5370683292E-01],
	[3.6275000000E+04, 2.8836272407E+01, 5.1800066216E+00, 1.1661395651E+01, 3.1899806907E+00, 9.5372779768E-01],
	[3.6280000000E+04, 2.8843094653E+01, 5.1800287353E+00, 1.1666624877E+01, 3.1904637456E+00, 9.5374875194E-01],
	[3.6285000000E+04, 2.8849917571E+01, 5.1800508461E+00, 1.1671855725E+01, 3.1909466850E+00, 9.5376969571E-01],
	[3.6290000000E+04, 2.8856741163E+01, 5.1800729538E+00, 1.1677088196E+01, 3.1914295089E+00, 9.5379062898E-01],
	[3.6295000000E+04, 2.8863565429E+01, 5.1800950587E+00, 1.1682322291E+01, 3.1919122173E+00, 9.5381155178E-01],
	[3.6300000000E+04, 2.8870390368E+01, 5.1801171606E+00, 1.1687558009E+01, 3.1923948102E+00, 9.5383246409E-01],
	[3.6305000000E+04, 2.8877215981E+01, 5.1801392595E+00, 1.1692795351E+01, 3.1928772876E+00, 9.5385336593E-01],
	[3.6310000000E+04, 2.8884042267E+01, 5.1801613555E+00, 1.1698034317E+01, 3.1933596495E+00, 9.5387425731E-01],
	[3.6315000000E+04, 2.8890869226E+01, 5.1801834485E+00, 1.1703274908E+01, 3.1938418960E+00, 9.5389513822E-01],
	[3.6320000000E+04, 2.8897696859E+01, 5.1802055386E+00, 1.1708517123E+01, 3.1943240270E+00, 9.5391600868E-01],
	[3.6325000000E+04, 2.8904525165E+01, 5.1802276258E+00, 1.1713760963E+01, 3.1948060426E+00, 9.5393686868E-01],
	[3.6330000000E+04, 2.8911354145E+01, 5.1802497100E+00, 1.1719006429E+01, 3.1952879428E+00, 9.5395771824E-01],
	[3.6335000000E+04, 2.8918183798E+01, 5.1802717912E+00, 1.1724253520E+01, 3.1957697275E+00, 9.5397855736E-01],
	[3.6340000000E+04, 2.8925014124E+01, 5.1802938695E+00, 1.1729502237E+01, 3.1962513969E+00, 9.5399938604E-01],
	[3.6345000000E+04, 2.8931845123E+01, 5.1803159449E+00, 1.1734752580E+01, 3.1967329508E+00, 9.5402020430E-01],
	[3.6350000000E+04, 2.8938676795E+01, 5.1803380173E+00, 1.1740004549E+01, 3.1972143894E+00, 9.5404101213E-01],
	[3.6355000000E+04, 2.8945509141E+01, 5.1803600868E+00, 1.1745258145E+01, 3.1976957126E+00, 9.5406180955E-01],
	[3.6360000000E+04, 2.8952342160E+01, 5.1803821533E+00, 1.1750513368E+01, 3.1981769205E+00, 9.5408259655E-01],
	[3.6365000000E+04, 2.8959175852E+01, 5.1804042169E+00, 1.1755770218E+01, 3.1986580130E+00, 9.5410337314E-01],
	[3.6370000000E+04, 2.8966010217E+01, 5.1804262776E+00, 1.1761028695E+01, 3.1991389901E+00, 9.5412413933E-01],
	[3.6375000000E+04, 2.8972845255E+01, 5.1804483353E+00, 1.1766288801E+01, 3.1996198520E+00, 9.5414489513E-01],
	[3.6380000000E+04, 2.8979680966E+01, 5.1804703901E+00, 1.1771550534E+01, 3.2001005985E+00, 9.5416564053E-01],
	[3.6385000000E+04, 2.8986517351E+01, 5.1804924419E+00, 1.1776813896E+01, 3.2005812297E+00, 9.5418637555E-01],
	[3.6390000000E+04, 2.8993354408E+01, 5.1805144908E+00, 1.1782078886E+01, 3.2010617457E+00, 9.5420710019E-01],
	[3.6395000000E+04, 2.9000192138E+01, 5.1805365368E+00, 1.1787345505E+01, 3.2015421463E+00, 9.5422781445E-01],
	[3.6400000000E+04, 2.9007030541E+01, 5.1805585798E+00, 1.1792613754E+01, 3.2020224317E+00, 9.5424851835E-01],
	[3.6405000000E+04, 2.9013869617E+01, 5.1805806200E+00, 1.1797883632E+01, 3.2025026019E+00, 9.5426921188E-01],
	[3.6410000000E+04, 2.9020709366E+01, 5.1806026571E+00, 1.1803155139E+01, 3.2029826568E+00, 9.5428989505E-01],
	[3.6415000000E+04, 2.9027549788E+01, 5.1806246914E+00, 1.1808428277E+01, 3.2034625965E+00, 9.5431056787E-01],
	[3.6420000000E+04, 2.9034390883E+01, 5.1806467227E+00, 1.1813703045E+01, 3.2039424209E+00, 9.5433123034E-01],
	[3.6425000000E+04, 2.9041232650E+01, 5.1806687510E+00, 1.1818979443E+01, 3.2044221302E+00, 9.5435188247E-01],
	[3.6430000000E+04, 2.9048075091E+01, 5.1806907765E+00, 1.1824257472E+01, 3.2049017242E+00, 9.5437252427E-01],
	[3.6435000000E+04, 2.9054918204E+01, 5.1807127990E+00, 1.1829537133E+01, 3.2053812031E+00, 9.5439315573E-01],
	[3.6440000000E+04, 2.9061761990E+01, 5.1807348186E+00, 1.1834818425E+01, 3.2058605668E+00, 9.5441377687E-01],
	[3.6445000000E+04, 2.9068606448E+01, 5.1807568353E+00, 1.1840101348E+01, 3.2063398153E+00, 9.5443438769E-01],
	[3.6450000000E+04, 2.9075451579E+01, 5.1807788490E+00, 1.1845385903E+01, 3.2068189487E+00, 9.5445498819E-01],
	[3.6455000000E+04, 2.9082297383E+01, 5.1808008598E+00, 1.1850672091E+01, 3.2072979669E+00, 9.5447557838E-01],
	[3.6460000000E+04, 2.9089143860E+01, 5.1808228677E+00, 1.1855959911E+01, 3.2077768701E+00, 9.5449615827E-01],
	[3.6465000000E+04, 2.9095991009E+01, 5.1808448727E+00, 1.1861249364E+01, 3.2082556581E+00, 9.5451672786E-01],
	[3.6470000000E+04, 2.9102838831E+01, 5.1808668747E+00, 1.1866540450E+01, 3.2087343310E+00, 9.5453728716E-01],
	[3.6475000000E+04, 2.9109687325E+01, 5.1808888738E+00, 1.1871833170E+01, 3.2092128888E+00, 9.5455783617E-01],
	[3.6480000000E+04, 2.9116536492E+01, 5.1809108700E+00, 1.1877127523E+01, 3.2096913315E+00, 9.5457837490E-01],
	[3.6485000000E+04, 2.9123386331E+01, 5.1809328633E+00, 1.1882423510E+01, 3.2101696592E+00, 9.5459890335E-01],
	[3.6490000000E+04, 2.9130236843E+01, 5.1809548536E+00, 1.1887721131E+01, 3.2106478718E+00, 9.5461942153E-01],
	[3.6495000000E+04, 2.9137088027E+01, 5.1809768410E+00, 1.1893020387E+01, 3.2111259693E+00, 9.5463992944E-01],
	[3.6500000000E+04, 2.9143939884E+01, 5.1809988256E+00, 1.1898321277E+01, 3.2116039519E+00, 9.5466042709E-01],
	[3.6505000000E+04, 2.9150792413E+01, 5.1810208072E+00, 1.1903623803E+01, 3.2120818194E+00, 9.5468091449E-01],
	[3.6510000000E+04, 2.9157645614E+01, 5.1810427858E+00, 1.1908927964E+01, 3.2125595719E+00, 9.5470139164E-01],
	[3.6515000000E+04, 2.9164499488E+01, 5.1810647616E+00, 1.1914233760E+01, 3.2130372094E+00, 9.5472185854E-01],
	[3.6520000000E+04, 2.9171354034E+01, 5.1810867344E+00, 1.1919541192E+01, 3.2135147320E+00, 9.5474231521E-01],
	[3.6525000000E+04, 2.9178209253E+01, 5.1811087044E+00, 1.1924850261E+01, 3.2139921395E+00, 9.5476276164E-01],
	[3.6530000000E+04, 2.9185065143E+01, 5.1811306714E+00, 1.1930160966E+01, 3.2144694321E+00, 9.5478319784E-01],
	[3.6535000000E+04, 2.9191921706E+01, 5.1811526355E+00, 1.1935473307E+01, 3.2149466098E+00, 9.5480362382E-01],
	[3.6540000000E+04, 2.9198778941E+01, 5.1811745967E+00, 1.1940787286E+01, 3.2154236725E+00, 9.5482403959E-01],
	[3.6545000000E+04, 2.9205636849E+01, 5.1811965549E+00, 1.1946102902E+01, 3.2159006203E+00, 9.5484444514E-01],
	[3.6550000000E+04, 2.9212495428E+01, 5.1812185103E+00, 1.1951420155E+01, 3.2163774532E+00, 9.5486484049E-01],
	[3.6555000000E+04, 2.9219354680E+01, 5.1812404628E+00, 1.1956739046E+01, 3.2168541712E+00, 9.5488522563E-01],
	[3.6560000000E+04, 2.9226214604E+01, 5.1812624123E+00, 1.1962059576E+01, 3.2173307743E+00, 9.5490560058E-01],
	[3.6565000000E+04, 2.9233075199E+01, 5.1812843589E+00, 1.1967381744E+01, 3.2178072625E+00, 9.5492596534E-01],
	[3.6570000000E+04, 2.9239936467E+01, 5.1813063027E+00, 1.1972705550E+01, 3.2182836359E+00, 9.5494631991E-01],
	[3.6575000000E+04, 2.9246798407E+01, 5.1813282435E+00, 1.1978030995E+01, 3.2187598944E+00, 9.5496666431E-01],
	[3.6580000000E+04, 2.9253661019E+01, 5.1813501814E+00, 1.1983358080E+01, 3.2192360380E+00, 9.5498699853E-01],
	[3.6585000000E+04, 2.9260524303E+01, 5.1813721164E+00, 1.1988686804E+01, 3.2197120669E+00, 9.5500732258E-01],
	[3.6590000000E+04, 2.9267388259E+01, 5.1813940485E+00, 1.1994017168E+01, 3.2201879809E+00, 9.5502763647E-01],
	[3.6595000000E+04, 2.9274252887E+01, 5.1814159777E+00, 1.1999349172E+01, 3.2206637802E+00, 9.5504794020E-01],
	[3.6600000000E+04, 2.9281118187E+01, 5.1814379040E+00, 1.2004682817E+01, 3.2211394646E+00, 9.5506823378E-01],
	[3.6605000000E+04, 2.9287984158E+01, 5.1814598274E+00, 1.2010018102E+01, 3.2216150343E+00, 9.5508851721E-01],
	[3.6610000000E+04, 2.9294850802E+01, 5.1814817479E+00, 1.2015355028E+01, 3.2220904892E+00, 9.5510879050E-01],
	[3.6615000000E+04, 2.9301718117E+01, 5.1815036655E+00, 1.2020693595E+01, 3.2225658294E+00, 9.5512905366E-01],
	[3.6620000000E+04, 2.9308586104E+01, 5.1815255802E+00, 1.2026033804E+01, 3.2230410548E+00, 9.5514930668E-01],
	[3.6625000000E+04, 2.9315454763E+01, 5.1815474920E+00, 1.2031375654E+01, 3.2235161655E+00, 9.5516954958E-01],
	[3.6630000000E+04, 2.9322324093E+01, 5.1815694009E+00, 1.2036719146E+01, 3.2239911614E+00, 9.5518978236E-01],
	[3.6635000000E+04, 2.9329194096E+01, 5.1815913069E+00, 1.2042064281E+01, 3.2244660427E+00, 9.5521000502E-01],
	[3.6640000000E+04, 2.9336064770E+01, 5.1816132100E+00, 1.2047411058E+01, 3.2249408093E+00, 9.5523021758E-01],
	[3.6645000000E+04, 2.9342936116E+01, 5.1816351102E+00, 1.2052759479E+01, 3.2254154612E+00, 9.5525042003E-01],
	[3.6650000000E+04, 2.9349808133E+01, 5.1816570075E+00, 1.2058109542E+01, 3.2258899984E+00, 9.5527061238E-01],
	[3.6655000000E+04, 2.9356680822E+01, 5.1816789019E+00, 1.2063461249E+01, 3.2263644210E+00, 9.5529079464E-01],
	[3.6660000000E+04, 2.9363554182E+01, 5.1817007934E+00, 1.2068814599E+01, 3.2268387290E+00, 9.5531096681E-01],
	[3.6665000000E+04, 2.9370428214E+01, 5.1817226821E+00, 1.2074169594E+01, 3.2273129223E+00, 9.5533112890E-01],
	[3.6670000000E+04, 2.9377302918E+01, 5.1817445678E+00, 1.2079526233E+01, 3.2277870010E+00, 9.5535128091E-01],
	[3.6675000000E+04, 2.9384178293E+01, 5.1817664506E+00, 1.2084884516E+01, 3.2282609651E+00, 9.5537142285E-01],
	[3.6680000000E+04, 2.9391054340E+01, 5.1817883306E+00, 1.2090244444E+01, 3.2287348146E+00, 9.5539155473E-01],
	[3.6685000000E+04, 2.9397931058E+01, 5.1818102077E+00, 1.2095606018E+01, 3.2292085496E+00, 9.5541167654E-01],
	[3.6690000000E+04, 2.9404808448E+01, 5.1818320818E+00, 1.2100969236E+01, 3.2296821700E+00, 9.5543178830E-01],
	[3.6695000000E+04, 2.9411686509E+01, 5.1818539531E+00, 1.2106334101E+01, 3.2301556758E+00, 9.5545189001E-01],
	[3.6700000000E+04, 2.9418565241E+01, 5.1818758215E+00, 1.2111700611E+01, 3.2306290671E+00, 9.5547198167E-01],
	[3.6705000000E+04, 2.9425444645E+01, 5.1818976870E+00, 1.2117068768E+01, 3.2311023438E+00, 9.5549206329E-01],
	[3.6710000000E+04, 2.9432324720E+01, 5.1819195497E+00, 1.2122438571E+01, 3.2315755061E+00, 9.5551213488E-01],
	[3.6715000000E+04, 2.9439205466E+01, 5.1819414094E+00, 1.2127810021E+01, 3.2320485538E+00, 9.5553219644E-01],
	[3.6720000000E+04, 2.9446086884E+01, 5.1819632662E+00, 1.2133183118E+01, 3.2325214871E+00, 9.5555224798E-01],
	[3.6725000000E+04, 2.9452968973E+01, 5.1819851202E+00, 1.2138557862E+01, 3.2329943059E+00, 9.5557228950E-01],
	[3.6730000000E+04, 2.9459851733E+01, 5.1820069713E+00, 1.2143934254E+01, 3.2334670102E+00, 9.5559232101E-01],
	[3.6735000000E+04, 2.9466735164E+01, 5.1820288195E+00, 1.2149312294E+01, 3.2339396001E+00, 9.5561234251E-01],
	[3.6740000000E+04, 2.9473619267E+01, 5.1820506648E+00, 1.2154691982E+01, 3.2344120755E+00, 9.5563235401E-01],
	[3.6745000000E+04, 2.9480504040E+01, 5.1820725073E+00, 1.2160073319E+01, 3.2348844365E+00, 9.5565235551E-01],
	[3.6750000000E+04, 2.9487389485E+01, 5.1820943468E+00, 1.2165456304E+01, 3.2353566831E+00, 9.5567234702E-01],
	[3.6755000000E+04, 2.9494275601E+01, 5.1821161835E+00, 1.2170840938E+01, 3.2358288153E+00, 9.5569232855E-01],
	[3.6760000000E+04, 2.9501162388E+01, 5.1821380173E+00, 1.2176227222E+01, 3.2363008331E+00, 9.5571230009E-01],
	[3.6765000000E+04, 2.9508049846E+01, 5.1821598483E+00, 1.2181615155E+01, 3.2367727366E+00, 9.5573226166E-01],
	[3.6770000000E+04, 2.9514937975E+01, 5.1821816763E+00, 1.2187004739E+01, 3.2372445257E+00, 9.5575221326E-01],
	[3.6775000000E+04, 2.9521826775E+01, 5.1822035015E+00, 1.2192395972E+01, 3.2377162004E+00, 9.5577215490E-01],
	[3.6780000000E+04, 2.9528716246E+01, 5.1822253238E+00, 1.2197788856E+01, 3.2381877608E+00, 9.5579208657E-01],
	[3.6785000000E+04, 2.9535606388E+01, 5.1822471432E+00, 1.2203183390E+01, 3.2386592069E+00, 9.5581200830E-01],
	[3.6790000000E+04, 2.9542497201E+01, 5.1822689598E+00, 1.2208579576E+01, 3.2391305387E+00, 9.5583192007E-01],
	[3.6795000000E+04, 2.9549388684E+01, 5.1822907735E+00, 1.2213977413E+01, 3.2396017562E+00, 9.5585182190E-01],
	[3.6800000000E+04, 2.9556280839E+01, 5.1823125843E+00, 1.2219376901E+01, 3.2400728594E+00, 9.5587171380E-01],
	[3.6805000000E+04, 2.9563173664E+01, 5.1823343922E+00, 1.2224778041E+01, 3.2405438483E+00, 9.5589159576E-01],
	[3.6810000000E+04, 2.9570072309E+01, 5.1823568827E+00, 1.2230180833E+01, 3.2410150529E+00, 9.5591146779E-01],
	[3.6815000000E+04, 2.9576984916E+01, 5.1823811393E+00, 1.2235585278E+01, 3.2414869951E+00, 9.5593132990E-01],
	[3.6820000000E+04, 2.9583898199E+01, 5.1824053927E+00, 1.2240991376E+01, 3.2419588235E+00, 9.5595118210E-01],
	[3.6825000000E+04, 2.9590812160E+01, 5.1824296430E+00, 1.2246399126E+01, 3.2424305381E+00, 9.5597102439E-01],
	[3.6830000000E+04, 2.9597726797E+01, 5.1824538900E+00, 1.2251808530E+01, 3.2429021389E+00, 9.5599085677E-01],
	[3.6835000000E+04, 2.9604642112E+01, 5.1824781339E+00, 1.2257219587E+01, 3.2433736260E+00, 9.5601067925E-01],
	[3.6840000000E+04, 2.9611558103E+01, 5.1825023746E+00, 1.2262632298E+01, 3.2438449993E+00, 9.5603049183E-01],
	[3.6845000000E+04, 2.9618474770E+01, 5.1825266122E+00, 1.2268046663E+01, 3.2443162588E+00, 9.5605029453E-01],
	[3.6850000000E+04, 2.9625392115E+01, 5.1825508465E+00, 1.2273462682E+01, 3.2447874046E+00, 9.5607008734E-01],
	[3.6855000000E+04, 2.9632310136E+01, 5.1825750777E+00, 1.2278880356E+01, 3.2452584366E+00, 9.5608987027E-01],
	[3.6860000000E+04, 2.9639228834E+01, 5.1825993057E+00, 1.2284299685E+01, 3.2457293550E+00, 9.5610964333E-01],
	[3.6865000000E+04, 2.9646148208E+01, 5.1826235306E+00, 1.2289720669E+01, 3.2462001596E+00, 9.5612940651E-01],
	[3.6870000000E+04, 2.9653068259E+01, 5.1826477523E+00, 1.2295143309E+01, 3.2466708506E+00, 9.5614915984E-01],
	[3.6875000000E+04, 2.9659988987E+01, 5.1826719707E+00, 1.2300567605E+01, 3.2471414279E+00, 9.5616890331E-01],
	[3.6880000000E+04, 2.9666910391E+01, 5.1826961861E+00, 1.2305993556E+01, 3.2476118916E+00, 9.5618863692E-01],
	[3.6885000000E+04, 2.9673832472E+01, 5.1827203982E+00, 1.2311421164E+01, 3.2480822416E+00, 9.5620836069E-01],
	[3.6890000000E+04, 2.9680755229E+01, 5.1827446072E+00, 1.2316850428E+01, 3.2485524779E+00, 9.5622807461E-01],
	[3.6895000000E+04, 2.9687678662E+01, 5.1827688130E+00, 1.2322281350E+01, 3.2490226007E+00, 9.5624777869E-01],
	[3.6900000000E+04, 2.9694602773E+01, 5.1827930157E+00, 1.2327713928E+01, 3.2494926098E+00, 9.5626747294E-01],
	[3.6905000000E+04, 2.9701527559E+01, 5.1828172152E+00, 1.2333148164E+01, 3.2499625054E+00, 9.5628715735E-01],
	[3.6910000000E+04, 2.9708453022E+01, 5.1828414115E+00, 1.2338584058E+01, 3.2504322873E+00, 9.5630683195E-01],
	[3.6915000000E+04, 2.9715379162E+01, 5.1828656046E+00, 1.2344021609E+01, 3.2509019557E+00, 9.5632649672E-01],
	[3.6920000000E+04, 2.9722305977E+01, 5.1828897946E+00, 1.2349460819E+01, 3.2513715106E+00, 9.5634615168E-01],
	[3.6925000000E+04, 2.9729233469E+01, 5.1829139815E+00, 1.2354901688E+01, 3.2518409519E+00, 9.5636579682E-01],
	[3.6930000000E+04, 2.9736161638E+01, 5.1829381651E+00, 1.2360344215E+01, 3.2523102797E+00, 9.5638543217E-01],
	[3.6935000000E+04, 2.9743090482E+01, 5.1829623456E+00, 1.2365788402E+01, 3.2527794939E+00, 9.5640505771E-01],
	[3.6940000000E+04, 2.9750020003E+01, 5.1829865230E+00, 1.2371234248E+01, 3.2532485947E+00, 9.5642467345E-01],
	[3.6945000000E+04, 2.9756950200E+01, 5.1830106972E+00, 1.2376681754E+01, 3.2537175820E+00, 9.5644427941E-01],
	[3.6950000000E+04, 2.9763881074E+01, 5.1830348682E+00, 1.2382130919E+01, 3.2541864558E+00, 9.5646387558E-01],
	[3.6955000000E+04, 2.9770812623E+01, 5.1830590361E+00, 1.2387581745E+01, 3.2546552162E+00, 9.5648346196E-01],
	[3.6960000000E+04, 2.9777744849E+01, 5.1830832008E+00, 1.2393034232E+01, 3.2551238631E+00, 9.5650303857E-01],
	[3.6965000000E+04, 2.9784677750E+01, 5.1831073623E+00, 1.2398488379E+01, 3.2555923966E+00, 9.5652260541E-01],
	[3.6970000000E+04, 2.9791611328E+01, 5.1831315207E+00, 1.2403944187E+01, 3.2560608166E+00, 9.5654216248E-01],
	[3.6975000000E+04, 2.9798545582E+01, 5.1831556760E+00, 1.2409401657E+01, 3.2565291233E+00, 9.5656170980E-01],
	[3.6980000000E+04, 2.9805480512E+01, 5.1831798281E+00, 1.2414860788E+01, 3.2569973165E+00, 9.5658124735E-01],
	[3.6985000000E+04, 2.9812416118E+01, 5.1832039770E+00, 1.2420321582E+01, 3.2574653964E+00, 9.5660077515E-01],
	[3.6990000000E+04, 2.9819352400E+01, 5.1832281228E+00, 1.2425784037E+01, 3.2579333629E+00, 9.5662029320E-01],
	[3.6995000000E+04, 2.9826289358E+01, 5.1832522654E+00, 1.2431248155E+01, 3.2584012161E+00, 9.5663980151E-01],
	[3.7000000000E+04, 2.9833226992E+01, 5.1832764049E+00, 1.2436713936E+01, 3.2588689559E+00, 9.5665930009E-01],
	[3.7005000000E+04, 2.9840165302E+01, 5.1833005413E+00, 1.2442181380E+01, 3.2593365824E+00, 9.5667878893E-01],
	[3.7010000000E+04, 2.9847104288E+01, 5.1833246744E+00, 1.2447650487E+01, 3.2598040956E+00, 9.5669826804E-01],
	[3.7015000000E+04, 2.9854043949E+01, 5.1833488045E+00, 1.2453121258E+01, 3.2602714954E+00, 9.5671773743E-01],
	[3.7020000000E+04, 2.9860984287E+01, 5.1833729314E+00, 1.2458593693E+01, 3.2607387820E+00, 9.5673719710E-01],
	[3.7025000000E+04, 2.9867925300E+01, 5.1833970551E+00, 1.2464067792E+01, 3.2612059554E+00, 9.5675664706E-01],
	[3.7030000000E+04, 2.9874866989E+01, 5.1834211757E+00, 1.2469543555E+01, 3.2616730154E+00, 9.5677608731E-01],
	[3.7035000000E+04, 2.9881809354E+01, 5.1834452932E+00, 1.2475020984E+01, 3.2621399623E+00, 9.5679551785E-01],
	[3.7040000000E+04, 2.9888752395E+01, 5.1834694075E+00, 1.2480500077E+01, 3.2626067959E+00, 9.5681493870E-01],
	[3.7045000000E+04, 2.9895696111E+01, 5.1834935187E+00, 1.2485980835E+01, 3.2630735163E+00, 9.5683434985E-01],
	[3.7050000000E+04, 2.9902640503E+01, 5.1835176267E+00, 1.2491463259E+01, 3.2635401234E+00, 9.5685375131E-01],
	[3.7055000000E+04, 2.9909585570E+01, 5.1835417316E+00, 1.2496947349E+01, 3.2640066174E+00, 9.5687314309E-01],
	[3.7060000000E+04, 2.9916531314E+01, 5.1835658333E+00, 1.2502433106E+01, 3.2644729983E+00, 9.5689252519E-01],
	[3.7065000000E+04, 2.9923477733E+01, 5.1835899319E+00, 1.2507920528E+01, 3.2649392659E+00, 9.5691189761E-01],
	[3.7070000000E+04, 2.9930424827E+01, 5.1836140274E+00, 1.2513409617E+01, 3.2654054204E+00, 9.5693126036E-01],
	[3.7075000000E+04, 2.9937372597E+01, 5.1836381197E+00, 1.2518900374E+01, 3.2658714618E+00, 9.5695061345E-01],
	[3.7080000000E+04, 2.9944321043E+01, 5.1836622089E+00, 1.2524392797E+01, 3.2663373901E+00, 9.5696995687E-01],
	[3.7085000000E+04, 2.9951270164E+01, 5.1836862950E+00, 1.2529886888E+01, 3.2668032052E+00, 9.5698929065E-01],
	[3.7090000000E+04, 2.9958219961E+01, 5.1837103779E+00, 1.2535382647E+01, 3.2672689073E+00, 9.5700861477E-01],
	[3.7095000000E+04, 2.9965170433E+01, 5.1837344577E+00, 1.2540880074E+01, 3.2677344962E+00, 9.5702792924E-01],
	[3.7100000000E+04, 2.9972121580E+01, 5.1837585344E+00, 1.2546379170E+01, 3.2681999722E+00, 9.5704723408E-01],
	[3.7105000000E+04, 2.9979073403E+01, 5.1837826079E+00, 1.2551879934E+01, 3.2686653350E+00, 9.5706652927E-01],
	[3.7110000000E+04, 2.9986025901E+01, 5.1838066783E+00, 1.2557382367E+01, 3.2691305848E+00, 9.5708581484E-01],
	[3.7115000000E+04, 2.9992979075E+01, 5.1838307455E+00, 1.2562886470E+01, 3.2695957216E+00, 9.5710509078E-01],
	[3.7120000000E+04, 2.9999932924E+01, 5.1838548097E+00, 1.2568392241E+01, 3.2700607454E+00, 9.5712435709E-01],
	[3.7125000000E+04, 3.0006887448E+01, 5.1838788707E+00, 1.2573899683E+01, 3.2705256562E+00, 9.5714361380E-01],
	[3.7130000000E+04, 3.0013842648E+01, 5.1839029285E+00, 1.2579408795E+01, 3.2709904541E+00, 9.5716286088E-01],
	[3.7135000000E+04, 3.0020798523E+01, 5.1839269833E+00, 1.2584919577E+01, 3.2714551389E+00, 9.5718209836E-01],
	[3.7140000000E+04, 3.0027755073E+01, 5.1839510349E+00, 1.2590432030E+01, 3.2719197108E+00, 9.5720132624E-01],
	[3.7145000000E+04, 3.0034712298E+01, 5.1839750834E+00, 1.2595946154E+01, 3.2723841698E+00, 9.5722054452E-01],
	[3.7150000000E+04, 3.0041670199E+01, 5.1839991287E+00, 1.2601461948E+01, 3.2728485158E+00, 9.5723975321E-01],
	[3.7155000000E+04, 3.0048628774E+01, 5.1840231710E+00, 1.2606979415E+01, 3.2733127489E+00, 9.5725895231E-01],
	[3.7160000000E+04, 3.0055588025E+01, 5.1840472101E+00, 1.2612498553E+01, 3.2737768691E+00, 9.5727814183E-01],
	[3.7165000000E+04, 3.0062547951E+01, 5.1840712461E+00, 1.2618019363E+01, 3.2742408765E+00, 9.5729732177E-01],
	[3.7170000000E+04, 3.0069508552E+01, 5.1840952790E+00, 1.2623541846E+01, 3.2747047710E+00, 9.5731649213E-01],
	[3.7175000000E+04, 3.0076469828E+01, 5.1841193087E+00, 1.2629066001E+01, 3.2751685526E+00, 9.5733565293E-01],
	[3.7180000000E+04, 3.0083431779E+01, 5.1841433353E+00, 1.2634591829E+01, 3.2756322214E+00, 9.5735480416E-01],
	[3.7185000000E+04, 3.0090394405E+01, 5.1841673588E+00, 1.2640119330E+01, 3.2760957773E+00, 9.5737394583E-01],
	[3.7190000000E+04, 3.0097357706E+01, 5.1841913792E+00, 1.2645648505E+01, 3.2765592204E+00, 9.5739307795E-01],
	[3.7195000000E+04, 3.0104321682E+01, 5.1842153965E+00, 1.2651179353E+01, 3.2770225508E+00, 9.5741220052E-01],
	[3.7200000000E+04, 3.0111286333E+01, 5.1842394107E+00, 1.2656711876E+01, 3.2774857683E+00, 9.5743131355E-01],
	[3.7205000000E+04, 3.0118251659E+01, 5.1842634217E+00, 1.2662246073E+01, 3.2779488731E+00, 9.5745041703E-01],
	[3.7210000000E+04, 3.0125217659E+01, 5.1842874296E+00, 1.2667781944E+01, 3.2784118652E+00, 9.5746951098E-01],
	[3.7215000000E+04, 3.0132184335E+01, 5.1843114344E+00, 1.2673319490E+01, 3.2788747444E+00, 9.5748859540E-01],
	[3.7220000000E+04, 3.0139151685E+01, 5.1843354361E+00, 1.2678858712E+01, 3.2793375110E+00, 9.5750767029E-01],
	[3.7225000000E+04, 3.0146119711E+01, 5.1843594347E+00, 1.2684399608E+01, 3.2798001649E+00, 9.5752673567E-01],
	[3.7230000000E+04, 3.0153088411E+01, 5.1843834302E+00, 1.2689942181E+01, 3.2802627060E+00, 9.5754579153E-01],
	[3.7235000000E+04, 3.0160057785E+01, 5.1844074226E+00, 1.2695486429E+01, 3.2807251345E+00, 9.5756483787E-01],
	[3.7240000000E+04, 3.0167027835E+01, 5.1844314118E+00, 1.2701032354E+01, 3.2811874503E+00, 9.5758387471E-01],
	[3.7245000000E+04, 3.0173998559E+01, 5.1844553979E+00, 1.2706579955E+01, 3.2816496534E+00, 9.5760290205E-01],
	[3.7250000000E+04, 3.0180969958E+01, 5.1844793810E+00, 1.2712129233E+01, 3.2821117439E+00, 9.5762191990E-01],
	[3.7255000000E+04, 3.0187942031E+01, 5.1845033609E+00, 1.2717680189E+01, 3.2825737218E+00, 9.5764092825E-01],
	[3.7260000000E+04, 3.0194914779E+01, 5.1845273377E+00, 1.2723232821E+01, 3.2830355870E+00, 9.5765992711E-01],
	[3.7265000000E+04, 3.0201888202E+01, 5.1845513114E+00, 1.2728787131E+01, 3.2834973397E+00, 9.5767891649E-01],
	[3.7270000000E+04, 3.0208862299E+01, 5.1845752820E+00, 1.2734343120E+01, 3.2839589798E+00, 9.5769789640E-01],
	[3.7275000000E+04, 3.0215837071E+01, 5.1845992495E+00, 1.2739900786E+01, 3.2844205073E+00, 9.5771686683E-01],
	[3.7280000000E+04, 3.0222812518E+01, 5.1846232139E+00, 1.2745460131E+01, 3.2848819222E+00, 9.5773582780E-01],
	[3.7285000000E+04, 3.0229788638E+01, 5.1846471752E+00, 1.2751021155E+01, 3.2853432246E+00, 9.5775477930E-01],
	[3.7290000000E+04, 3.0236765434E+01, 5.1846711334E+00, 1.2756583858E+01, 3.2858044145E+00, 9.5777372134E-01],
	[3.7295000000E+04, 3.0243742903E+01, 5.1846950885E+00, 1.2762148240E+01, 3.2862654919E+00, 9.5779265393E-01],
	[3.7300000000E+04, 3.0250721048E+01, 5.1847190405E+00, 1.2767714302E+01, 3.2867264568E+00, 9.5781157708E-01],
	[3.7305000000E+04, 3.0257699866E+01, 5.1847429894E+00, 1.2773282044E+01, 3.2871873091E+00, 9.5783049078E-01],
	[3.7310000000E+04, 3.0264679359E+01, 5.1847669351E+00, 1.2778851466E+01, 3.2876480491E+00, 9.5784939504E-01],
	[3.7315000000E+04, 3.0271659527E+01, 5.1847908778E+00, 1.2784422568E+01, 3.2881086765E+00, 9.5786828986E-01],
	[3.7320000000E+04, 3.0278640368E+01, 5.1848148174E+00, 1.2789995351E+01, 3.2885691916E+00, 9.5788717526E-01],
	[3.7325000000E+04, 3.0285621884E+01, 5.1848387539E+00, 1.2795569816E+01, 3.2890295942E+00, 9.5790605123E-01],
	[3.7330000000E+04, 3.0292604074E+01, 5.1848626873E+00, 1.2801145961E+01, 3.2894898844E+00, 9.5792491779E-01],
	[3.7335000000E+04, 3.0299586939E+01, 5.1848866176E+00, 1.2806723789E+01, 3.2899500622E+00, 9.5794377493E-01],
	[3.7340000000E+04, 3.0306570478E+01, 5.1849105448E+00, 1.2812303298E+01, 3.2904101276E+00, 9.5796262265E-01],
	[3.7345000000E+04, 3.0313554691E+01, 5.1849344689E+00, 1.2817884489E+01, 3.2908700806E+00, 9.5798146098E-01],
	[3.7350000000E+04, 3.0320539578E+01, 5.1849583900E+00, 1.2823467363E+01, 3.2913299214E+00, 9.5800028990E-01],
	[3.7355000000E+04, 3.0327525139E+01, 5.1849823079E+00, 1.2829051919E+01, 3.2917896497E+00, 9.5801910943E-01],
	[3.7360000000E+04, 3.0334511374E+01, 5.1850062227E+00, 1.2834638159E+01, 3.2922492658E+00, 9.5803791956E-01],
	[3.7365000000E+04, 3.0341498284E+01, 5.1850301345E+00, 1.2840226082E+01, 3.2927087695E+00, 9.5805672031E-01],
	[3.7370000000E+04, 3.0348485867E+01, 5.1850540432E+00, 1.2845815688E+01, 3.2931681609E+00, 9.5807551168E-01],
	[3.7375000000E+04, 3.0355474125E+01, 5.1850779487E+00, 1.2851406978E+01, 3.2936274401E+00, 9.5809429368E-01],
	[3.7380000000E+04, 3.0362463056E+01, 5.1851018512E+00, 1.2856999953E+01, 3.2940866070E+00, 9.5811306630E-01],
	[3.7385000000E+04, 3.0369452662E+01, 5.1851257506E+00, 1.2862594612E+01, 3.2945456617E+00, 9.5813182955E-01],
	[3.7390000000E+04, 3.0376442941E+01, 5.1851496469E+00, 1.2868190955E+01, 3.2950046041E+00, 9.5815058345E-01],
	[3.7395000000E+04, 3.0383433895E+01, 5.1851735402E+00, 1.2873788984E+01, 3.2954634343E+00, 9.5816932798E-01],
	[3.7400000000E+04, 3.0390425522E+01, 5.1851974303E+00, 1.2879388697E+01, 3.2959221523E+00, 9.5818806317E-01],
	[3.7405000000E+04, 3.0397431771E+01, 5.1852231561E+00, 1.2884990097E+01, 3.2963816652E+00, 9.5820678900E-01],
	[3.7410000000E+04, 3.0404442969E+01, 5.1852494416E+00, 1.2890593182E+01, 3.2968413442E+00, 9.5822550549E-01],
	[3.7415000000E+04, 3.0411454847E+01, 5.1852757238E+00, 1.2896197953E+01, 3.2973009113E+00, 9.5824421265E-01],
	[3.7420000000E+04, 3.0418467406E+01, 5.1853020026E+00, 1.2901804411E+01, 3.2977603667E+00, 9.5826291047E-01],
	[3.7425000000E+04, 3.0425480643E+01, 5.1853282780E+00, 1.2907412555E+01, 3.2982197104E+00, 9.5828159896E-01],
	[3.7430000000E+04, 3.0432494561E+01, 5.1853545500E+00, 1.2913022387E+01, 3.2986789423E+00, 9.5830027813E-01],
	[3.7435000000E+04, 3.0439509158E+01, 5.1853808186E+00, 1.2918633905E+01, 3.2991380625E+00, 9.5831894798E-01],
	[3.7440000000E+04, 3.0446524435E+01, 5.1854070839E+00, 1.2924247111E+01, 3.2995970711E+00, 9.5833760852E-01],
	[3.7445000000E+04, 3.0453540392E+01, 5.1854333458E+00, 1.2929862005E+01, 3.3000559679E+00, 9.5835625975E-01],
	[3.7450000000E+04, 3.0460557028E+01, 5.1854596043E+00, 1.2935478587E+01, 3.3005147531E+00, 9.5837490167E-01],
	[3.7455000000E+04, 3.0467574344E+01, 5.1854858595E+00, 1.2941096857E+01, 3.3009734267E+00, 9.5839353429E-01],
	[3.7460000000E+04, 3.0474592339E+01, 5.1855121112E+00, 1.2946716816E+01, 3.3014319886E+00, 9.5841215762E-01],
	[3.7465000000E+04, 3.0481611014E+01, 5.1855383596E+00, 1.2952338464E+01, 3.3018904389E+00, 9.5843077166E-01],
	[3.7470000000E+04, 3.0488630368E+01, 5.1855646047E+00, 1.2957961801E+01, 3.3023487776E+00, 9.5844937641E-01],
	[3.7475000000E+04, 3.0495650402E+01, 5.1855908463E+00, 1.2963586828E+01, 3.3028070047E+00, 9.5846797188E-01],
	[3.7480000000E+04, 3.0502671116E+01, 5.1856170846E+00, 1.2969213544E+01, 3.3032651202E+00, 9.5848655808E-01],
	[3.7485000000E+04, 3.0509692509E+01, 5.1856433196E+00, 1.2974841951E+01, 3.3037231241E+00, 9.5850513500E-01],
	[3.7490000000E+04, 3.0516714581E+01, 5.1856695511E+00, 1.2980472048E+01, 3.3041810166E+00, 9.5852370266E-01],
	[3.7495000000E+04, 3.0523737333E+01, 5.1856957793E+00, 1.2986103835E+01, 3.3046387975E+00, 9.5854226106E-01],
	[3.7500000000E+04, 3.0530760764E+01, 5.1857220042E+00, 1.2991737313E+01, 3.3050964668E+00, 9.5856081020E-01],
	[3.7505000000E+04, 3.0537784875E+01, 5.1857482256E+00, 1.2997372483E+01, 3.3055540247E+00, 9.5857935009E-01],
	[3.7510000000E+04, 3.0544809664E+01, 5.1857744437E+00, 1.3003009344E+01, 3.3060114711E+00, 9.5859788073E-01],
	[3.7515000000E+04, 3.0551835133E+01, 5.1858006585E+00, 1.3008647896E+01, 3.3064688060E+00, 9.5861640213E-01],
	[3.7520000000E+04, 3.0558861282E+01, 5.1858268699E+00, 1.3014288141E+01, 3.3069260295E+00, 9.5863491429E-01],
	[3.7525000000E+04, 3.0565888109E+01, 5.1858530779E+00, 1.3019930078E+01, 3.3073831415E+00, 9.5865341722E-01],
	[3.7530000000E+04, 3.0572915616E+01, 5.1858792825E+00, 1.3025573708E+01, 3.3078401421E+00, 9.5867191092E-01],
	[3.7535000000E+04, 3.0579943802E+01, 5.1859054839E+00, 1.3031219030E+01, 3.3082970313E+00, 9.5869039540E-01],
	[3.7540000000E+04, 3.0586972668E+01, 5.1859316818E+00, 1.3036866046E+01, 3.3087538091E+00, 9.5870887066E-01],
	[3.7545000000E+04, 3.0594002212E+01, 5.1859578764E+00, 1.3042514755E+01, 3.3092104755E+00, 9.5872733670E-01],
	[3.7550000000E+04, 3.0601032436E+01, 5.1859840676E+00, 1.3048165158E+01, 3.3096670306E+00, 9.5874579354E-01],
	[3.7555000000E+04, 3.0608063338E+01, 5.1860102555E+00, 1.3053817254E+01, 3.3101234743E+00, 9.5876424117E-01],
	[3.7560000000E+04, 3.0615094920E+01, 5.1860364400E+00, 1.3059471045E+01, 3.3105798067E+00, 9.5878267960E-01],
	[3.7565000000E+04, 3.0622127181E+01, 5.1860626212E+00, 1.3065126531E+01, 3.3110360277E+00, 9.5880110884E-01],
	[3.7570000000E+04, 3.0629160121E+01, 5.1860887990E+00, 1.3070783712E+01, 3.3114921375E+00, 9.5881952889E-01],
	[3.7575000000E+04, 3.0636193740E+01, 5.1861149735E+00, 1.3076442587E+01, 3.3119481359E+00, 9.5883793975E-01],
	[3.7580000000E+04, 3.0643228037E+01, 5.1861411446E+00, 1.3082103158E+01, 3.3124040231E+00, 9.5885634143E-01],
	[3.7585000000E+04, 3.0650263014E+01, 5.1861673124E+00, 1.3087765425E+01, 3.3128597990E+00, 9.5887473394E-01],
	[3.7590000000E+04, 3.0657298670E+01, 5.1861934768E+00, 1.3093429387E+01, 3.3133154637E+00, 9.5889311728E-01],
	[3.7595000000E+04, 3.0664335004E+01, 5.1862196379E+00, 1.3099095046E+01, 3.3137710171E+00, 9.5891149145E-01],
	[3.7600000000E+04, 3.0671372018E+01, 5.1862457956E+00, 1.3104762402E+01, 3.3142264594E+00, 9.5892985646E-01],
	[3.7605000000E+04, 3.0678409710E+01, 5.1862719500E+00, 1.3110431454E+01, 3.3146817904E+00, 9.5894821231E-01],
	[3.7610000000E+04, 3.0685448081E+01, 5.1862981010E+00, 1.3116102203E+01, 3.3151370103E+00, 9.5896655901E-01],
	[3.7615000000E+04, 3.0692487131E+01, 5.1863242487E+00, 1.3121774650E+01, 3.3155921189E+00, 9.5898489656E-01],
	[3.7620000000E+04, 3.0699526860E+01, 5.1863503930E+00, 1.3127448795E+01, 3.3160471165E+00, 9.5900322497E-01],
	[3.7625000000E+04, 3.0706567268E+01, 5.1863765340E+00, 1.3133124637E+01, 3.3165020029E+00, 9.5902154425E-01],
	[3.7630000000E+04, 3.0713608354E+01, 5.1864026717E+00, 1.3138802177E+01, 3.3169567781E+00, 9.5903985439E-01],
	[3.7635000000E+04, 3.0720650119E+01, 5.1864288060E+00, 1.3144481416E+01, 3.3174114423E+00, 9.5905815540E-01],
	[3.7640000000E+04, 3.0727692563E+01, 5.1864549370E+00, 1.3150162354E+01, 3.3178659954E+00, 9.5907644729E-01],
	[3.7645000000E+04, 3.0734735685E+01, 5.1864810646E+00, 1.3155844991E+01, 3.3183204374E+00, 9.5909473006E-01],
	[3.7650000000E+04, 3.0741779486E+01, 5.1865071889E+00, 1.3161529328E+01, 3.3187747683E+00, 9.5911300372E-01],
	[3.7655000000E+04, 3.0748823966E+01, 5.1865333099E+00, 1.3167215363E+01, 3.3192289882E+00, 9.5913126826E-01],
	[3.7660000000E+04, 3.0755869124E+01, 5.1865594275E+00, 1.3172903099E+01, 3.3196830970E+00, 9.5914952371E-01],
	[3.7665000000E+04, 3.0762914960E+01, 5.1865855418E+00, 1.3178592535E+01, 3.3201370949E+00, 9.5916777005E-01],
	[3.7670000000E+04, 3.0769961476E+01, 5.1866116528E+00, 1.3184283672E+01, 3.3205909817E+00, 9.5918600730E-01],
	[3.7675000000E+04, 3.0777008670E+01, 5.1866377604E+00, 1.3189976509E+01, 3.3210447576E+00, 9.5920423546E-01],
	[3.7680000000E+04, 3.0784056542E+01, 5.1866638647E+00, 1.3195671047E+01, 3.3214984225E+00, 9.5922245454E-01],
	[3.7685000000E+04, 3.0791105092E+01, 5.1866899656E+00, 1.3201367287E+01, 3.3219519764E+00, 9.5924066453E-01],
	[3.7690000000E+04, 3.0798154322E+01, 5.1867160632E+00, 1.3207065228E+01, 3.3224054194E+00, 9.5925886545E-01],
	[3.7695000000E+04, 3.0805204229E+01, 5.1867421575E+00, 1.3212764871E+01, 3.3228587515E+00, 9.5927705729E-01],
	[3.7700000000E+04, 3.0812254815E+01, 5.1867682485E+00, 1.3218466217E+01, 3.3233119727E+00, 9.5929524007E-01],
	[3.7705000000E+04, 3.0819306079E+01, 5.1867943361E+00, 1.3224169265E+01, 3.3237650829E+00, 9.5931341379E-01],
	[3.7710000000E+04, 3.0826358022E+01, 5.1868204204E+00, 1.3229874015E+01, 3.3242180823E+00, 9.5933157845E-01],
	[3.7715000000E+04, 3.0833410643E+01, 5.1868465014E+00, 1.3235580469E+01, 3.3246709709E+00, 9.5934973406E-01],
	[3.7720000000E+04, 3.0840463942E+01, 5.1868725791E+00, 1.3241288625E+01, 3.3251237486E+00, 9.5936788063E-01],
	[3.7725000000E+04, 3.0847517920E+01, 5.1868986534E+00, 1.3246998486E+01, 3.3255764154E+00, 9.5938601815E-01],
	[3.7730000000E+04, 3.0854572576E+01, 5.1869247244E+00, 1.3252710050E+01, 3.3260289715E+00, 9.5940414663E-01],
	[3.7735000000E+04, 3.0861627910E+01, 5.1869507921E+00, 1.3258423318E+01, 3.3264814168E+00, 9.5942226608E-01],
	[3.7740000000E+04, 3.0868683922E+01, 5.1869768564E+00, 1.3264138291E+01, 3.3269337512E+00, 9.5944037650E-01],
	[3.7745000000E+04, 3.0875740612E+01, 5.1870029175E+00, 1.3269854969E+01, 3.3273859749E+00, 9.5945847790E-01],
	[3.7750000000E+04, 3.0882797981E+01, 5.1870289752E+00, 1.3275573351E+01, 3.3278380879E+00, 9.5947657027E-01],
	[3.7755000000E+04, 3.0889856027E+01, 5.1870550296E+00, 1.3281293439E+01, 3.3282900901E+00, 9.5949465364E-01],
	[3.7760000000E+04, 3.0896914752E+01, 5.1870810807E+00, 1.3287015233E+01, 3.3287419816E+00, 9.5951272799E-01],
	[3.7765000000E+04, 3.0903974155E+01, 5.1871071284E+00, 1.3292738732E+01, 3.3291937624E+00, 9.5953079334E-01],
	[3.7770000000E+04, 3.0911034235E+01, 5.1871331728E+00, 1.3298463937E+01, 3.3296454325E+00, 9.5954884969E-01],
	[3.7775000000E+04, 3.0918094994E+01, 5.1871592140E+00, 1.3304190849E+01, 3.3300969919E+00, 9.5956689704E-01],
	[3.7780000000E+04, 3.0925156431E+01, 5.1871852518E+00, 1.3309919467E+01, 3.3305484407E+00, 9.5958493541E-01],
	[3.7785000000E+04, 3.0932218546E+01, 5.1872112863E+00, 1.3315649793E+01, 3.3309997788E+00, 9.5960296478E-01],
	[3.7790000000E+04, 3.0939281338E+01, 5.1872373174E+00, 1.3321381825E+01, 3.3314510064E+00, 9.5962098518E-01],
	[3.7795000000E+04, 3.0946344809E+01, 5.1872633453E+00, 1.3327115566E+01, 3.3319021233E+00, 9.5963899660E-01],
	[3.7800000000E+04, 3.0953408958E+01, 5.1872893698E+00, 1.3332851013E+01, 3.3323531296E+00, 9.5965699905E-01],
	[3.7805000000E+04, 3.0960473784E+01, 5.1873153911E+00, 1.3338588170E+01, 3.3328040253E+00, 9.5967499253E-01],
	[3.7810000000E+04, 3.0967539288E+01, 5.1873414090E+00, 1.3344327034E+01, 3.3332548104E+00, 9.5969297705E-01],
	[3.7815000000E+04, 3.0974605470E+01, 5.1873674236E+00, 1.3350067607E+01, 3.3337054851E+00, 9.5971095261E-01],
	[3.7820000000E+04, 3.0981672330E+01, 5.1873934349E+00, 1.3355809889E+01, 3.3341560491E+00, 9.5972891922E-01],
	[3.7825000000E+04, 3.0988739868E+01, 5.1874194429E+00, 1.3361553880E+01, 3.3346065027E+00, 9.5974687688E-01],
	[3.7830000000E+04, 3.0995808083E+01, 5.1874454476E+00, 1.3367299581E+01, 3.3350568458E+00, 9.5976482560E-01],
	[3.7835000000E+04, 3.1002876976E+01, 5.1874714490E+00, 1.3373046992E+01, 3.3355070784E+00, 9.5978276537E-01],
	[3.7840000000E+04, 3.1009946547E+01, 5.1874974471E+00, 1.3378796113E+01, 3.3359572005E+00, 9.5980069622E-01],
	[3.7845000000E+04, 3.1017016796E+01, 5.1875234419E+00, 1.3384546944E+01, 3.3364072121E+00, 9.5981861813E-01],
	[3.7850000000E+04, 3.1024087722E+01, 5.1875494333E+00, 1.3390299485E+01, 3.3368571134E+00, 9.5983653112E-01],
	[3.7855000000E+04, 3.1031159325E+01, 5.1875754215E+00, 1.3396053738E+01, 3.3373069042E+00, 9.5985443520E-01],
	[3.7860000000E+04, 3.1038231607E+01, 5.1876014064E+00, 1.3401809702E+01, 3.3377565846E+00, 9.5987233035E-01],
	[3.7865000000E+04, 3.1045304566E+01, 5.1876273879E+00, 1.3407567377E+01, 3.3382061546E+00, 9.5989021660E-01],
	[3.7870000000E+04, 3.1052378202E+01, 5.1876533662E+00, 1.3413326764E+01, 3.3386556142E+00, 9.5990809394E-01],
	[3.7875000000E+04, 3.1059452516E+01, 5.1876793412E+00, 1.3419087863E+01, 3.3391049635E+00, 9.5992596237E-01],
	[3.7880000000E+04, 3.1066527508E+01, 5.1877053128E+00, 1.3424850674E+01, 3.3395542024E+00, 9.5994382192E-01],
	[3.7885000000E+04, 3.1073603177E+01, 5.1877312812E+00, 1.3430615198E+01, 3.3400033311E+00, 9.5996167257E-01],
	[3.7890000000E+04, 3.1080679523E+01, 5.1877572463E+00, 1.3436381435E+01, 3.3404523494E+00, 9.5997951433E-01],
	[3.7895000000E+04, 3.1087756547E+01, 5.1877832081E+00, 1.3442149385E+01, 3.3409012574E+00, 9.5999734721E-01],
	[3.7900000000E+04, 3.1094834248E+01, 5.1878091665E+00, 1.3447919049E+01, 3.3413500551E+00, 9.6001517121E-01],
	[3.7905000000E+04, 3.1101912627E+01, 5.1878351217E+00, 1.3453690426E+01, 3.3417987426E+00, 9.6003298635E-01],
	[3.7910000000E+04, 3.1108991683E+01, 5.1878610736E+00, 1.3459463517E+01, 3.3422473198E+00, 9.6005079261E-01],
	[3.7915000000E+04, 3.1116071416E+01, 5.1878870222E+00, 1.3465238323E+01, 3.3426957868E+00, 9.6006859001E-01],
	[3.7920000000E+04, 3.1123151827E+01, 5.1879129675E+00, 1.3471014843E+01, 3.3431441436E+00, 9.6008637855E-01],
	[3.7925000000E+04, 3.1130232915E+01, 5.1879389095E+00, 1.3476793078E+01, 3.3435923902E+00, 9.6010415823E-01],
	[3.7930000000E+04, 3.1137314680E+01, 5.1879648483E+00, 1.3482573028E+01, 3.3440405267E+00, 9.6012192907E-01],
	[3.7935000000E+04, 3.1144397122E+01, 5.1879907837E+00, 1.3488354694E+01, 3.3444885529E+00, 9.6013969106E-01],
	[3.7940000000E+04, 3.1151480242E+01, 5.1880167158E+00, 1.3494138075E+01, 3.3449364690E+00, 9.6015744422E-01],
	[3.7945000000E+04, 3.1158564039E+01, 5.1880426447E+00, 1.3499923173E+01, 3.3453842750E+00, 9.6017518853E-01],
	[3.7950000000E+04, 3.1165648512E+01, 5.1880685703E+00, 1.3505709986E+01, 3.3458319709E+00, 9.6019292402E-01],
	[3.7955000000E+04, 3.1172733664E+01, 5.1880944926E+00, 1.3511498517E+01, 3.3462795566E+00, 9.6021065068E-01],
	[3.7960000000E+04, 3.1179819492E+01, 5.1881204116E+00, 1.3517288764E+01, 3.3467270323E+00, 9.6022836852E-01],
	[3.7965000000E+04, 3.1186905997E+01, 5.1881463273E+00, 1.3523080728E+01, 3.3471743979E+00, 9.6024607754E-01],
	[3.7970000000E+04, 3.1193993179E+01, 5.1881722397E+00, 1.3528874409E+01, 3.3476216534E+00, 9.6026377776E-01],
	[3.7975000000E+04, 3.1201081039E+01, 5.1881981489E+00, 1.3534669809E+01, 3.3480687990E+00, 9.6028146916E-01],
	[3.7980000000E+04, 3.1208169575E+01, 5.1882240547E+00, 1.3540466926E+01, 3.3485158345E+00, 9.6029915176E-01],
	[3.7985000000E+04, 3.1215258788E+01, 5.1882499573E+00, 1.3546265762E+01, 3.3489627600E+00, 9.6031682556E-01],
	[3.7990000000E+04, 3.1222348679E+01, 5.1882758566E+00, 1.3552066316E+01, 3.3494095755E+00, 9.6033449057E-01],
	[3.7995000000E+04, 3.1229439246E+01, 5.1883017527E+00, 1.3557868589E+01, 3.3498562810E+00, 9.6035214680E-01],
	[3.8000000000E+04, 3.1236530490E+01, 5.1883276454E+00, 1.3563672581E+01, 3.3503028766E+00, 9.6036979423E-01],
	[3.8005000000E+04, 3.1243628600E+01, 5.1883543433E+00, 1.3569478292E+01, 3.3507497707E+00, 9.6038743289E-01],
	[3.8010000000E+04, 3.1250739193E+01, 5.1883825797E+00, 1.3575285723E+01, 3.3511973339E+00, 9.6040506278E-01],
	[3.8015000000E+04, 3.1257850468E+01, 5.1884108125E+00, 1.3581094874E+01, 3.3516447875E+00, 9.6042268389E-01],
	[3.8020000000E+04, 3.1264962427E+01, 5.1884390417E+00, 1.3586905745E+01, 3.3520921317E+00, 9.6044029624E-01],
	[3.8025000000E+04, 3.1272075067E+01, 5.1884672673E+00, 1.3592718337E+01, 3.3525393663E+00, 9.6045789983E-01],
	[3.8030000000E+04, 3.1279188391E+01, 5.1884954894E+00, 1.3598532650E+01, 3.3529864915E+00, 9.6047549466E-01],
	[3.8035000000E+04, 3.1286302397E+01, 5.1885237080E+00, 1.3604348683E+01, 3.3534335072E+00, 9.6049308075E-01],
	[3.8040000000E+04, 3.1293417086E+01, 5.1885519230E+00, 1.3610166439E+01, 3.3538804135E+00, 9.6051065808E-01],
	[3.8045000000E+04, 3.1300532457E+01, 5.1885801344E+00, 1.3615985915E+01, 3.3543272103E+00, 9.6052822668E-01],
	[3.8050000000E+04, 3.1307648510E+01, 5.1886083423E+00, 1.3621807114E+01, 3.3547738977E+00, 9.6054578653E-01],
	[3.8055000000E+04, 3.1314765246E+01, 5.1886365466E+00, 1.3627630035E+01, 3.3552204757E+00, 9.6056333766E-01],
	[3.8060000000E+04, 3.1321882665E+01, 5.1886647474E+00, 1.3633454678E+01, 3.3556669443E+00, 9.6058088005E-01],
	[3.8065000000E+04, 3.1329000765E+01, 5.1886929446E+00, 1.3639281044E+01, 3.3561133035E+00, 9.6059841373E-01],
	[3.8070000000E+04, 3.1336119549E+01, 5.1887211382E+00, 1.3645109133E+01, 3.3565595534E+00, 9.6061593868E-01],
	[3.8075000000E+04, 3.1343239014E+01, 5.1887493284E+00, 1.3650938946E+01, 3.3570056939E+00, 9.6063345492E-01],
	[3.8080000000E+04, 3.1350359162E+01, 5.1887775149E+00, 1.3656770482E+01, 3.3574517252E+00, 9.6065096245E-01],
	[3.8085000000E+04, 3.1357479992E+01, 5.1888056980E+00, 1.3662603742E+01, 3.3578976471E+00, 9.6066846128E-01],
	[3.8090000000E+04, 3.1364601505E+01, 5.1888338774E+00, 1.3668438727E+01, 3.3583434597E+00, 9.6068595141E-01],
	[3.8095000000E+04, 3.1371723700E+01, 5.1888620534E+00, 1.3674275435E+01, 3.3587891631E+00, 9.6070343284E-01],
	[3.8100000000E+04, 3.1378846577E+01, 5.1888902258E+00, 1.3680113869E+01, 3.3592347572E+00, 9.6072090558E-01],
	[3.8105000000E+04, 3.1385970136E+01, 5.1889183946E+00, 1.3685954027E+01, 3.3596802421E+00, 9.6073836964E-01],
	[3.8110000000E+04, 3.1393094377E+01, 5.1889465599E+00, 1.3691795911E+01, 3.3601256177E+00, 9.6075582501E-01],
	[3.8115000000E+04, 3.1400219301E+01, 5.1889747217E+00, 1.3697639521E+01, 3.3605708842E+00, 9.6077327171E-01],
	[3.8120000000E+04, 3.1407344907E+01, 5.1890028799E+00, 1.3703484856E+01, 3.3610160414E+00, 9.6079070974E-01],
	[3.8125000000E+04, 3.1414471194E+01, 5.1890310345E+00, 1.3709331918E+01, 3.3614610895E+00, 9.6080813910E-01],
	[3.8130000000E+04, 3.1421598164E+01, 5.1890591857E+00, 1.3715180706E+01, 3.3619060284E+00, 9.6082555979E-01],
	[3.8135000000E+04, 3.1428725816E+01, 5.1890873333E+00, 1.3721031221E+01, 3.3623508582E+00, 9.6084297183E-01],
	[3.8140000000E+04, 3.1435854150E+01, 5.1891154773E+00, 1.3726883462E+01, 3.3627955788E+00, 9.6086037521E-01],
	[3.8145000000E+04, 3.1442983167E+01, 5.1891436179E+00, 1.3732737431E+01, 3.3632401904E+00, 9.6087776995E-01],
	[3.8150000000E+04, 3.1450112865E+01, 5.1891717549E+00, 1.3738593128E+01, 3.3636846928E+00, 9.6089515604E-01],
	[3.8155000000E+04, 3.1457243245E+01, 5.1891998883E+00, 1.3744450553E+01, 3.3641290862E+00, 9.6091253349E-01],
	[3.8160000000E+04, 3.1464374307E+01, 5.1892280182E+00, 1.3750309705E+01, 3.3645733705E+00, 9.6092990231E-01],
	[3.8165000000E+04, 3.1471506051E+01, 5.1892561446E+00, 1.3756170586E+01, 3.3650175458E+00, 9.6094726250E-01],
	[3.8170000000E+04, 3.1478638476E+01, 5.1892842675E+00, 1.3762033196E+01, 3.3654616120E+00, 9.6096461406E-01],
	[3.8175000000E+04, 3.1485771584E+01, 5.1893123868E+00, 1.3767897535E+01, 3.3659055693E+00, 9.6098195700E-01],
	[3.8180000000E+04, 3.1492905374E+01, 5.1893405026E+00, 1.3773763603E+01, 3.3663494175E+00, 9.6099929132E-01],
	[3.8185000000E+04, 3.1500039845E+01, 5.1893686148E+00, 1.3779631401E+01, 3.3667931568E+00, 9.6101661703E-01],
	[3.8190000000E+04, 3.1507174998E+01, 5.1893967236E+00, 1.3785500929E+01, 3.3672367871E+00, 9.6103393414E-01],
	[3.8195000000E+04, 3.1514310833E+01, 5.1894248288E+00, 1.3791372186E+01, 3.3676803084E+00, 9.6105124264E-01],
	[3.8200000000E+04, 3.1521447350E+01, 5.1894529305E+00, 1.3797245174E+01, 3.3681237209E+00, 9.6106854254E-01],
	[3.8205000000E+04, 3.1528584548E+01, 5.1894810286E+00, 1.3803119893E+01, 3.3685670244E+00, 9.6108583386E-01],
	[3.8210000000E+04, 3.1535722429E+01, 5.1895091232E+00, 1.3808996343E+01, 3.3690102190E+00, 9.6110311658E-01],
	[3.8215000000E+04, 3.1542860990E+01, 5.1895372143E+00, 1.3814874524E+01, 3.3694533048E+00, 9.6112039072E-01],
	[3.8220000000E+04, 3.1550000234E+01, 5.1895653019E+00, 1.3820754437E+01, 3.3698962817E+00, 9.6113765628E-01],
	[3.8225000000E+04, 3.1557140159E+01, 5.1895933860E+00, 1.3826636081E+01, 3.3703391498E+00, 9.6115491326E-01],
	[3.8230000000E+04, 3.1564280766E+01, 5.1896214665E+00, 1.3832519458E+01, 3.3707819090E+00, 9.6117216167E-01],
	[3.8235000000E+04, 3.1571422054E+01, 5.1896495435E+00, 1.3838404567E+01, 3.3712245594E+00, 9.6118940152E-01],
	[3.8240000000E+04, 3.1578564024E+01, 5.1896776170E+00, 1.3844291408E+01, 3.3716671010E+00, 9.6120663281E-01],
	[3.8245000000E+04, 3.1585706676E+01, 5.1897056870E+00, 1.3850179983E+01, 3.3721095339E+00, 9.6122385554E-01],
	[3.8250000000E+04, 3.1592850008E+01, 5.1897337535E+00, 1.3856070291E+01, 3.3725518580E+00, 9.6124106972E-01],
	[3.8255000000E+04, 3.1599994023E+01, 5.1897618164E+00, 1.3861962332E+01, 3.3729940733E+00, 9.6125827536E-01],
	[3.8260000000E+04, 3.1607138719E+01, 5.1897898759E+00, 1.3867856107E+01, 3.3734361799E+00, 9.6127547245E-01],
	[3.8265000000E+04, 3.1614284096E+01, 5.1898179318E+00, 1.3873751617E+01, 3.3738781778E+00, 9.6129266100E-01],
	[3.8270000000E+04, 3.1621430155E+01, 5.1898459842E+00, 1.3879648860E+01, 3.3743200671E+00, 9.6130984102E-01],
	[3.8275000000E+04, 3.1628576895E+01, 5.1898740331E+00, 1.3885547839E+01, 3.3747618476E+00, 9.6132701251E-01],
	[3.8280000000E+04, 3.1635724317E+01, 5.1899020784E+00, 1.3891448552E+01, 3.3752035195E+00, 9.6134417547E-01],
	[3.8285000000E+04, 3.1642872420E+01, 5.1899301203E+00, 1.3897351000E+01, 3.3756450827E+00, 9.6136132992E-01],
	[3.8290000000E+04, 3.1650021204E+01, 5.1899581586E+00, 1.3903255184E+01, 3.3760865373E+00, 9.6137847585E-01],
	[3.8295000000E+04, 3.1657170669E+01, 5.1899861935E+00, 1.3909161104E+01, 3.3765278833E+00, 9.6139561327E-01],
	[3.8300000000E+04, 3.1664320816E+01, 5.1900142248E+00, 1.3915068760E+01, 3.3769691207E+00, 9.6141274219E-01],
	[3.8305000000E+04, 3.1671471644E+01, 5.1900422526E+00, 1.3920978152E+01, 3.3774102496E+00, 9.6142986260E-01],
	[3.8310000000E+04, 3.1678623153E+01, 5.1900702770E+00, 1.3926889281E+01, 3.3778512698E+00, 9.6144697452E-01],
	[3.8315000000E+04, 3.1685775344E+01, 5.1900982978E+00, 1.3932802147E+01, 3.3782921816E+00, 9.6146407795E-01],
	[3.8320000000E+04, 3.1692928216E+01, 5.1901263151E+00, 1.3938716750E+01, 3.3787329848E+00, 9.6148117289E-01],
	[3.8325000000E+04, 3.1700081768E+01, 5.1901543289E+00, 1.3944633091E+01, 3.3791736795E+00, 9.6149825935E-01],
	[3.8330000000E+04, 3.1707236002E+01, 5.1901823392E+00, 1.3950551169E+01, 3.3796142657E+00, 9.6151533732E-01],
	[3.8335000000E+04, 3.1714390917E+01, 5.1902103460E+00, 1.3956470985E+01, 3.3800547434E+00, 9.6153240683E-01],
	[3.8340000000E+04, 3.1721546513E+01, 5.1902383493E+00, 1.3962392540E+01, 3.3804951127E+00, 9.6154946786E-01],
	[3.8345000000E+04, 3.1728702791E+01, 5.1902663491E+00, 1.3968315833E+01, 3.3809353735E+00, 9.6156652044E-01],
	[3.8350000000E+04, 3.1735859749E+01, 5.1902943454E+00, 1.3974240865E+01, 3.3813755259E+00, 9.6158356455E-01],
	[3.8355000000E+04, 3.1743017388E+01, 5.1903223382E+00, 1.3980167637E+01, 3.3818155699E+00, 9.6160060020E-01],
	[3.8360000000E+04, 3.1750175708E+01, 5.1903503275E+00, 1.3986096148E+01, 3.3822555055E+00, 9.6161762741E-01],
	[3.8365000000E+04, 3.1757334709E+01, 5.1903783133E+00, 1.3992026398E+01, 3.3826953328E+00, 9.6163464617E-01],
	[3.8370000000E+04, 3.1764494392E+01, 5.1904062956E+00, 1.3997958389E+01, 3.3831350517E+00, 9.6165165649E-01],
	[3.8375000000E+04, 3.1771654755E+01, 5.1904342744E+00, 1.4003892120E+01, 3.3835746622E+00, 9.6166865837E-01],
	[3.8380000000E+04, 3.1778815798E+01, 5.1904622497E+00, 1.4009827592E+01, 3.3840141644E+00, 9.6168565182E-01],
	[3.8385000000E+04, 3.1785977523E+01, 5.1904902215E+00, 1.4015764804E+01, 3.3844535584E+00, 9.6170263684E-01],
	[3.8390000000E+04, 3.1793139929E+01, 5.1905181899E+00, 1.4021703758E+01, 3.3848928440E+00, 9.6171961343E-01],
	[3.8395000000E+04, 3.1800303015E+01, 5.1905461547E+00, 1.4027644453E+01, 3.3853320214E+00, 9.6173658161E-01],
	[3.8400000000E+04, 3.1807466783E+01, 5.1905741160E+00, 1.4033586890E+01, 3.3857710905E+00, 9.6175354136E-01],
	[3.8405000000E+04, 3.1814631231E+01, 5.1906020739E+00, 1.4039531069E+01, 3.3862100513E+00, 9.6177049271E-01],
	[3.8410000000E+04, 3.1821796359E+01, 5.1906300283E+00, 1.4045476990E+01, 3.3866489040E+00, 9.6178743565E-01],
	[3.8415000000E+04, 3.1828962169E+01, 5.1906579791E+00, 1.4051424654E+01, 3.3870876484E+00, 9.6180437018E-01],
	[3.8420000000E+04, 3.1836128659E+01, 5.1906859265E+00, 1.4057374060E+01, 3.3875262847E+00, 9.6182129632E-01],
	[3.8425000000E+04, 3.1843295830E+01, 5.1907138704E+00, 1.4063325210E+01, 3.3879648128E+00, 9.6183821406E-01],
	[3.8430000000E+04, 3.1850463681E+01, 5.1907418109E+00, 1.4069278104E+01, 3.3884032327E+00, 9.6185512341E-01],
	[3.8435000000E+04, 3.1857632213E+01, 5.1907697478E+00, 1.4075232741E+01, 3.3888415445E+00, 9.6187202437E-01],
	[3.8440000000E+04, 3.1864801426E+01, 5.1907976813E+00, 1.4081189122E+01, 3.3892797482E+00, 9.6188891695E-01],
	[3.8445000000E+04, 3.1871971319E+01, 5.1908256112E+00, 1.4087147247E+01, 3.3897178438E+00, 9.6190580115E-01],
	[3.8450000000E+04, 3.1879141893E+01, 5.1908535377E+00, 1.4093107117E+01, 3.3901558313E+00, 9.6192267698E-01],
	[3.8455000000E+04, 3.1886313148E+01, 5.1908814607E+00, 1.4099068731E+01, 3.3905937108E+00, 9.6193954444E-01],
	[3.8460000000E+04, 3.1893485083E+01, 5.1909093802E+00, 1.4105032091E+01, 3.3910314822E+00, 9.6195640353E-01],
	[3.8465000000E+04, 3.1900657698E+01, 5.1909372963E+00, 1.4110997197E+01, 3.3914691455E+00, 9.6197325426E-01],
	[3.8470000000E+04, 3.1907830994E+01, 5.1909652089E+00, 1.4116964048E+01, 3.3919067009E+00, 9.6199009663E-01],
	[3.8475000000E+04, 3.1915004970E+01, 5.1909931180E+00, 1.4122932645E+01, 3.3923441483E+00, 9.6200693065E-01],
	[3.8480000000E+04, 3.1922179627E+01, 5.1910210236E+00, 1.4128902988E+01, 3.3927814876E+00, 9.6202375632E-01],
	[3.8485000000E+04, 3.1929354964E+01, 5.1910489257E+00, 1.4134875078E+01, 3.3932187190E+00, 9.6204057365E-01],
	[3.8490000000E+04, 3.1936530981E+01, 5.1910768244E+00, 1.4140848914E+01, 3.3936558425E+00, 9.6205738263E-01],
	[3.8495000000E+04, 3.1943707679E+01, 5.1911047196E+00, 1.4146824498E+01, 3.3940928580E+00, 9.6207418328E-01],
	[3.8500000000E+04, 3.1950885057E+01, 5.1911326113E+00, 1.4152801829E+01, 3.3945297657E+00, 9.6209097560E-01],
	[3.8505000000E+04, 3.1958063116E+01, 5.1911604995E+00, 1.4158780908E+01, 3.3949665654E+00, 9.6210775958E-01],
	[3.8510000000E+04, 3.1965241854E+01, 5.1911883843E+00, 1.4164761735E+01, 3.3954032573E+00, 9.6212453525E-01],
	[3.8515000000E+04, 3.1972421273E+01, 5.1912162656E+00, 1.4170744310E+01, 3.3958398413E+00, 9.6214130259E-01],
	[3.8520000000E+04, 3.1979601372E+01, 5.1912441434E+00, 1.4176728634E+01, 3.3962763174E+00, 9.6215806162E-01],
	[3.8525000000E+04, 3.1986782152E+01, 5.1912720178E+00, 1.4182714706E+01, 3.3967126858E+00, 9.6217481234E-01],
	[3.8530000000E+04, 3.1993963611E+01, 5.1912998887E+00, 1.4188702528E+01, 3.3971489463E+00, 9.6219155475E-01],
	[3.8535000000E+04, 3.2001145751E+01, 5.1913277561E+00, 1.4194692099E+01, 3.3975850991E+00, 9.6220828885E-01],
	[3.8540000000E+04, 3.2008328571E+01, 5.1913556201E+00, 1.4200683419E+01, 3.3980211440E+00, 9.6222501466E-01],
	[3.8545000000E+04, 3.2015512070E+01, 5.1913834806E+00, 1.4206676490E+01, 3.3984570812E+00, 9.6224173217E-01],
	[3.8550000000E+04, 3.2022696250E+01, 5.1914113376E+00, 1.4212671311E+01, 3.3988929107E+00, 9.6225844140E-01],
	[3.8555000000E+04, 3.2029881110E+01, 5.1914391912E+00, 1.4218667882E+01, 3.3993286325E+00, 9.6227514233E-01],
	[3.8560000000E+04, 3.2037066650E+01, 5.1914670413E+00, 1.4224666204E+01, 3.3997642465E+00, 9.6229183499E-01],
	[3.8565000000E+04, 3.2044252870E+01, 5.1914948879E+00, 1.4230666278E+01, 3.4001997529E+00, 9.6230851937E-01],
	[3.8570000000E+04, 3.2051439771E+01, 5.1915227311E+00, 1.4236668102E+01, 3.4006351516E+00, 9.6232519547E-01],
	[3.8575000000E+04, 3.2058627351E+01, 5.1915505708E+00, 1.4242671678E+01, 3.4010704427E+00, 9.6234186330E-01],
	[3.8580000000E+04, 3.2065815610E+01, 5.1915784071E+00, 1.4248677007E+01, 3.4015056261E+00, 9.6235852287E-01],
	[3.8585000000E+04, 3.2073004550E+01, 5.1916062399E+00, 1.4254684087E+01, 3.4019407019E+00, 9.6237517418E-01],
	[3.8590000000E+04, 3.2080194170E+01, 5.1916340693E+00, 1.4260692920E+01, 3.4023756701E+00, 9.6239181723E-01],
	[3.8595000000E+04, 3.2087384470E+01, 5.1916618952E+00, 1.4266703506E+01, 3.4028105307E+00, 9.6240845203E-01],
	[3.8600000000E+04, 3.2094575449E+01, 5.1916897176E+00, 1.4272715845E+01, 3.4032452838E+00, 9.6242507858E-01],
	[3.8605000000E+04, 3.2101767108E+01, 5.1917175366E+00, 1.4278729937E+01, 3.4036799293E+00, 9.6244169688E-01],
	[3.8610000000E+04, 3.2108959447E+01, 5.1917453521E+00, 1.4284745783E+01, 3.4041144673E+00, 9.6245830695E-01],
	[3.8615000000E+04, 3.2116152466E+01, 5.1917731642E+00, 1.4290763383E+01, 3.4045488978E+00, 9.6247490877E-01],
	[3.8620000000E+04, 3.2123363637E+01, 5.1918032353E+00, 1.4296782737E+01, 3.4049843902E+00, 9.6249150237E-01],
	[3.8625000000E+04, 3.2130575782E+01, 5.1918333400E+00, 1.4302803845E+01, 3.4054197949E+00, 9.6250808774E-01],
	[3.8630000000E+04, 3.2137788612E+01, 5.1918634411E+00, 1.4308826708E+01, 3.4058550924E+00, 9.6252466488E-01],
	[3.8635000000E+04, 3.2145002127E+01, 5.1918935383E+00, 1.4314851327E+01, 3.4062902828E+00, 9.6254123381E-01],
	[3.8640000000E+04, 3.2152216328E+01, 5.1919236319E+00, 1.4320877701E+01, 3.4067253662E+00, 9.6255779452E-01],
	[3.8645000000E+04, 3.2159431214E+01, 5.1919537218E+00, 1.4326905830E+01, 3.4071603425E+00, 9.6257434702E-01],
	[3.8650000000E+04, 3.2166646786E+01, 5.1919838079E+00, 1.4332935715E+01, 3.4075952118E+00, 9.6259089131E-01],
	[3.8655000000E+04, 3.2173863042E+01, 5.1920138903E+00, 1.4338967357E+01, 3.4080299740E+00, 9.6260742740E-01],
	[3.8660000000E+04, 3.2181079984E+01, 5.1920439690E+00, 1.4345000754E+01, 3.4084646293E+00, 9.6262395530E-01],
	[3.8665000000E+04, 3.2188297611E+01, 5.1920740440E+00, 1.4351035909E+01, 3.4088991776E+00, 9.6264047499E-01],
	[3.8670000000E+04, 3.2195515923E+01, 5.1921041153E+00, 1.4357072821E+01, 3.4093336189E+00, 9.6265698650E-01],
	[3.8675000000E+04, 3.2202734921E+01, 5.1921341828E+00, 1.4363111490E+01, 3.4097679532E+00, 9.6267348982E-01],
	[3.8680000000E+04, 3.2209954603E+01, 5.1921642467E+00, 1.4369151917E+01, 3.4102021807E+00, 9.6268998496E-01],
	[3.8685000000E+04, 3.2217174971E+01, 5.1921943068E+00, 1.4375194101E+01, 3.4106363012E+00, 9.6270647192E-01],
	[3.8690000000E+04, 3.2224396023E+01, 5.1922243632E+00, 1.4381238044E+01, 3.4110703148E+00, 9.6272295071E-01],
	[3.8695000000E+04, 3.2231617761E+01, 5.1922544159E+00, 1.4387283745E+01, 3.4115042215E+00, 9.6273942133E-01],
	[3.8700000000E+04, 3.2238840184E+01, 5.1922844649E+00, 1.4393331205E+01, 3.4119380214E+00, 9.6275588378E-01],
	[3.8705000000E+04, 3.2246063292E+01, 5.1923145102E+00, 1.4399380424E+01, 3.4123717145E+00, 9.6277233808E-01],
	[3.8710000000E+04, 3.2253287084E+01, 5.1923445518E+00, 1.4405431403E+01, 3.4128053007E+00, 9.6278878421E-01],
	[3.8715000000E+04, 3.2260511562E+01, 5.1923745897E+00, 1.4411484141E+01, 3.4132387801E+00, 9.6280522220E-01],
	[3.8720000000E+04, 3.2267736725E+01, 5.1924046238E+00, 1.4417538638E+01, 3.4136721527E+00, 9.6282165203E-01],
	[3.8725000000E+04, 3.2274962572E+01, 5.1924346543E+00, 1.4423594896E+01, 3.4141054185E+00, 9.6283807372E-01],
	[3.8730000000E+04, 3.2282189105E+01, 5.1924646811E+00, 1.4429652915E+01, 3.4145385776E+00, 9.6285448727E-01],
	[3.8735000000E+04, 3.2289416322E+01, 5.1924947041E+00, 1.4435712694E+01, 3.4149716300E+00, 9.6287089269E-01],
	[3.8740000000E+04, 3.2296644224E+01, 5.1925247235E+00, 1.4441774234E+01, 3.4154045756E+00, 9.6288728997E-01],
	[3.8745000000E+04, 3.2303872811E+01, 5.1925547392E+00, 1.4447837536E+01, 3.4158374145E+00, 9.6290367913E-01],
	[3.8750000000E+04, 3.2311102083E+01, 5.1925847511E+00, 1.4453902599E+01, 3.4162701467E+00, 9.6292006016E-01],
	[3.8755000000E+04, 3.2318332040E+01, 5.1926147594E+00, 1.4459969424E+01, 3.4167027723E+00, 9.6293643307E-01],
	[3.8760000000E+04, 3.2325562681E+01, 5.1926447639E+00, 1.4466038011E+01, 3.4171352912E+00, 9.6295279787E-01],
	[3.8765000000E+04, 3.2332794007E+01, 5.1926747648E+00, 1.4472108361E+01, 3.4175677035E+00, 9.6296915456E-01],
	[3.8770000000E+04, 3.2340026018E+01, 5.1927047620E+00, 1.4478180473E+01, 3.4180000092E+00, 9.6298550314E-01],
	[3.8775000000E+04, 3.2347258713E+01, 5.1927347554E+00, 1.4484254348E+01, 3.4184322083E+00, 9.6300184361E-01],
	[3.8780000000E+04, 3.2354492093E+01, 5.1927647452E+00, 1.4490329987E+01, 3.4188643008E+00, 9.6301817599E-01],
	[3.8785000000E+04, 3.2361726158E+01, 5.1927947313E+00, 1.4496407389E+01, 3.4192962867E+00, 9.6303450028E-01],
	[3.8790000000E+04, 3.2368960907E+01, 5.1928247137E+00, 1.4502486555E+01, 3.4197281661E+00, 9.6305081647E-01],
	[3.8795000000E+04, 3.2376196341E+01, 5.1928546924E+00, 1.4508567486E+01, 3.4201599390E+00, 9.6306712458E-01],
	[3.8800000000E+04, 3.2383432460E+01, 5.1928846674E+00, 1.4514650180E+01, 3.4205916053E+00, 9.6308342460E-01],
	[3.8805000000E+04, 3.2390669263E+01, 5.1929146388E+00, 1.4520734640E+01, 3.4210231652E+00, 9.6309971655E-01],
	[3.8810000000E+04, 3.2397906750E+01, 5.1929446064E+00, 1.4526820864E+01, 3.4214546186E+00, 9.6311600043E-01],
	[3.8815000000E+04, 3.2405144922E+01, 5.1929745703E+00, 1.4532908854E+01, 3.4218859655E+00, 9.6313227623E-01],
	[3.8820000000E+04, 3.2412383779E+01, 5.1930045306E+00, 1.4538998609E+01, 3.4223172060E+00, 9.6314854397E-01],
	[3.8825000000E+04, 3.2419623320E+01, 5.1930344872E+00, 1.4545090130E+01, 3.4227483401E+00, 9.6316480365E-01],
	[3.8830000000E+04, 3.2426863545E+01, 5.1930644401E+00, 1.4551183417E+01, 3.4231793678E+00, 9.6318105527E-01],
	[3.8835000000E+04, 3.2434104455E+01, 5.1930943893E+00, 1.4557278471E+01, 3.4236102891E+00, 9.6319729884E-01],
	[3.8840000000E+04, 3.2441346049E+01, 5.1931243348E+00, 1.4563375291E+01, 3.4240411040E+00, 9.6321353436E-01],
	[3.8845000000E+04, 3.2448588327E+01, 5.1931542766E+00, 1.4569473878E+01, 3.4244718126E+00, 9.6322976184E-01],
	[3.8850000000E+04, 3.2455831290E+01, 5.1931842148E+00, 1.4575574233E+01, 3.4249024148E+00, 9.6324598127E-01],
	[3.8855000000E+04, 3.2463074937E+01, 5.1932141493E+00, 1.4581676355E+01, 3.4253329107E+00, 9.6326219267E-01],
	[3.8860000000E+04, 3.2470319269E+01, 5.1932440801E+00, 1.4587780245E+01, 3.4257633004E+00, 9.6327839604E-01],
	[3.8865000000E+04, 3.2477564284E+01, 5.1932740072E+00, 1.4593885903E+01, 3.4261935837E+00, 9.6329459138E-01],
	[3.8870000000E+04, 3.2484809984E+01, 5.1933039306E+00, 1.4599993330E+01, 3.4266237608E+00, 9.6331077869E-01],
	[3.8875000000E+04, 3.2492056368E+01, 5.1933338504E+00, 1.4606102525E+01, 3.4270538317E+00, 9.6332695799E-01],
	[3.8880000000E+04, 3.2499303436E+01, 5.1933637665E+00, 1.4612213489E+01, 3.4274837963E+00, 9.6334312927E-01],
	[3.8885000000E+04, 3.2506551189E+01, 5.1933936789E+00, 1.4618326222E+01, 3.4279136548E+00, 9.6335929253E-01],
	[3.8890000000E+04, 3.2513799625E+01, 5.1934235877E+00, 1.4624440725E+01, 3.4283434070E+00, 9.6337544780E-01],
	[3.8895000000E+04, 3.2521048746E+01, 5.1934534927E+00, 1.4630556998E+01, 3.4287730531E+00, 9.6339159505E-01],
	[3.8900000000E+04, 3.2528298551E+01, 5.1934833941E+00, 1.4636675041E+01, 3.4292025930E+00, 9.6340773431E-01],
	[3.8905000000E+04, 3.2535549040E+01, 5.1935132919E+00, 1.4642794854E+01, 3.4296320268E+00, 9.6342386558E-01],
	[3.8910000000E+04, 3.2542800213E+01, 5.1935431859E+00, 1.4648916438E+01, 3.4300613544E+00, 9.6343998885E-01],
	[3.8915000000E+04, 3.2550052070E+01, 5.1935730763E+00, 1.4655039793E+01, 3.4304905760E+00, 9.6345610414E-01],
	[3.8920000000E+04, 3.2557304611E+01, 5.1936029630E+00, 1.4661164919E+01, 3.4309196915E+00, 9.6347221144E-01],
	[3.8925000000E+04, 3.2564557836E+01, 5.1936328461E+00, 1.4667291817E+01, 3.4313487009E+00, 9.6348831077E-01],
	[3.8930000000E+04, 3.2571811744E+01, 5.1936627255E+00, 1.4673420487E+01, 3.4317776043E+00, 9.6350440212E-01],
	[3.8935000000E+04, 3.2579066337E+01, 5.1936926012E+00, 1.4679550928E+01, 3.4322064016E+00, 9.6352048550E-01],
	[3.8940000000E+04, 3.2586321614E+01, 5.1937224732E+00, 1.4685683142E+01, 3.4326350930E+00, 9.6353656092E-01],
	[3.8945000000E+04, 3.2593577575E+01, 5.1937523416E+00, 1.4691817129E+01, 3.4330636783E+00, 9.6355262837E-01],
	[3.8950000000E+04, 3.2600834219E+01, 5.1937822064E+00, 1.4697952889E+01, 3.4334921577E+00, 9.6356868787E-01],
	[3.8955000000E+04, 3.2608091547E+01, 5.1938120674E+00, 1.4704090421E+01, 3.4339205311E+00, 9.6358473941E-01],
	[3.8960000000E+04, 3.2615349559E+01, 5.1938419248E+00, 1.4710229728E+01, 3.4343487986E+00, 9.6360078301E-01],
	[3.8965000000E+04, 3.2622608255E+01, 5.1938717786E+00, 1.4716370808E+01, 3.4347769602E+00, 9.6361681866E-01],
	[3.8970000000E+04, 3.2629867635E+01, 5.1939016287E+00, 1.4722513662E+01, 3.4352050159E+00, 9.6363284636E-01],
	[3.8975000000E+04, 3.2637127698E+01, 5.1939314751E+00, 1.4728658291E+01, 3.4356329657E+00, 9.6364886613E-01],
	[3.8980000000E+04, 3.2644388445E+01, 5.1939613179E+00, 1.4734804694E+01, 3.4360608096E+00, 9.6366487797E-01],
	[3.8985000000E+04, 3.2651649876E+01, 5.1939911570E+00, 1.4740952873E+01, 3.4364885476E+00, 9.6368088188E-01],
	[3.8990000000E+04, 3.2658911991E+01, 5.1940209925E+00, 1.4747102826E+01, 3.4369161799E+00, 9.6369687787E-01],
	[3.8995000000E+04, 3.2666174789E+01, 5.1940508243E+00, 1.4753254555E+01, 3.4373437063E+00, 9.6371286593E-01],
	[3.9000000000E+04, 3.2673438271E+01, 5.1940806524E+00, 1.4759408060E+01, 3.4377711270E+00, 9.6372884608E-01],
	[3.9005000000E+04, 3.2680702436E+01, 5.1941104769E+00, 1.4765563341E+01, 3.4381984418E+00, 9.6374481831E-01],
	[3.9010000000E+04, 3.2687967285E+01, 5.1941402978E+00, 1.4771720398E+01, 3.4386256510E+00, 9.6376078264E-01],
	[3.9015000000E+04, 3.2695232817E+01, 5.1941701150E+00, 1.4777879232E+01, 3.4390527543E+00, 9.6377673906E-01],
	[3.9020000000E+04, 3.2702499034E+01, 5.1941999285E+00, 1.4784039843E+01, 3.4394797520E+00, 9.6379268758E-01],
	[3.9025000000E+04, 3.2709765933E+01, 5.1942297384E+00, 1.4790202231E+01, 3.4399066439E+00, 9.6380862821E-01],
	[3.9030000000E+04, 3.2717033516E+01, 5.1942595447E+00, 1.4796366397E+01, 3.4403334302E+00, 9.6382456095E-01],
	[3.9035000000E+04, 3.2724301783E+01, 5.1942893473E+00, 1.4802532340E+01, 3.4407601108E+00, 9.6384048580E-01],
	[3.9040000000E+04, 3.2731570733E+01, 5.1943191462E+00, 1.4808700061E+01, 3.4411866858E+00, 9.6385640276E-01],
	[3.9045000000E+04, 3.2738840366E+01, 5.1943489416E+00, 1.4814869561E+01, 3.4416131551E+00, 9.6387231185E-01],
	[3.9050000000E+04, 3.2746110683E+01, 5.1943787332E+00, 1.4821040840E+01, 3.4420395188E+00, 9.6388821306E-01],
	[3.9055000000E+04, 3.2753381683E+01, 5.1944085213E+00, 1.4827213897E+01, 3.4424657769E+00, 9.6390410640E-01],
	[3.9060000000E+04, 3.2760653366E+01, 5.1944383056E+00, 1.4833388734E+01, 3.4428919295E+00, 9.6391999187E-01],
	[3.9065000000E+04, 3.2767925733E+01, 5.1944680864E+00, 1.4839565350E+01, 3.4433179765E+00, 9.6393586948E-01],
	[3.9070000000E+04, 3.2775198783E+01, 5.1944978635E+00, 1.4845743745E+01, 3.4437439179E+00, 9.6395173923E-01],
	[3.9075000000E+04, 3.2782472517E+01, 5.1945276369E+00, 1.4851923921E+01, 3.4441697539E+00, 9.6396760112E-01],
	[3.9080000000E+04, 3.2789746933E+01, 5.1945574068E+00, 1.4858105878E+01, 3.4445954843E+00, 9.6398345517E-01],
	[3.9085000000E+04, 3.2797022033E+01, 5.1945871729E+00, 1.4864289614E+01, 3.4450211093E+00, 9.6399930137E-01],
	[3.9090000000E+04, 3.2804297816E+01, 5.1946169355E+00, 1.4870475132E+01, 3.4454466287E+00, 9.6401513972E-01],
	[3.9095000000E+04, 3.2811574282E+01, 5.1946466944E+00, 1.4876662431E+01, 3.4458720428E+00, 9.6403097024E-01],
	[3.9100000000E+04, 3.2818851432E+01, 5.1946764497E+00, 1.4882851512E+01, 3.4462973514E+00, 9.6404679293E-01],
	[3.9105000000E+04, 3.2826129264E+01, 5.1947062013E+00, 1.4889042374E+01, 3.4467225546E+00, 9.6406260778E-01],
	[3.9110000000E+04, 3.2833407780E+01, 5.1947359493E+00, 1.4895235018E+01, 3.4471476524E+00, 9.6407841481E-01],
	[3.9115000000E+04, 3.2840686979E+01, 5.1947656937E+00, 1.4901429445E+01, 3.4475726448E+00, 9.6409421402E-01],
	[3.9120000000E+04, 3.2847966861E+01, 5.1947954344E+00, 1.4907625654E+01, 3.4479975319E+00, 9.6411000540E-01],
	[3.9125000000E+04, 3.2855247426E+01, 5.1948251716E+00, 1.4913823646E+01, 3.4484223137E+00, 9.6412578898E-01],
	[3.9130000000E+04, 3.2862528673E+01, 5.1948549050E+00, 1.4920023422E+01, 3.4488469901E+00, 9.6414156474E-01],
	[3.9135000000E+04, 3.2869810604E+01, 5.1948846349E+00, 1.4926224981E+01, 3.4492715612E+00, 9.6415733270E-01],
	[3.9140000000E+04, 3.2877093218E+01, 5.1949143611E+00, 1.4932428323E+01, 3.4496960271E+00, 9.6417309286E-01],
	[3.9145000000E+04, 3.2884376515E+01, 5.1949440837E+00, 1.4938633450E+01, 3.4501203876E+00, 9.6418884523E-01],
	[3.9150000000E+04, 3.2891660495E+01, 5.1949738027E+00, 1.4944840361E+01, 3.4505446430E+00, 9.6420458979E-01],
	[3.9155000000E+04, 3.2898945158E+01, 5.1950035180E+00, 1.4951049056E+01, 3.4509687931E+00, 9.6422032657E-01],
	[3.9160000000E+04, 3.2906230503E+01, 5.1950332298E+00, 1.4957259537E+01, 3.4513928380E+00, 9.6423605557E-01],
	[3.9165000000E+04, 3.2913516531E+01, 5.1950629379E+00, 1.4963471803E+01, 3.4518167777E+00, 9.6425177678E-01],
	[3.9170000000E+04, 3.2920803243E+01, 5.1950926423E+00, 1.4969685854E+01, 3.4522406122E+00, 9.6426749022E-01],
	[3.9175000000E+04, 3.2928090637E+01, 5.1951223432E+00, 1.4975901691E+01, 3.4526643416E+00, 9.6428319588E-01],
	[3.9180000000E+04, 3.2935378714E+01, 5.1951520404E+00, 1.4982119314E+01, 3.4530879659E+00, 9.6429889378E-01],
	[3.9185000000E+04, 3.2942667473E+01, 5.1951817340E+00, 1.4988338723E+01, 3.4535114850E+00, 9.6431458391E-01],
	[3.9190000000E+04, 3.2949956916E+01, 5.1952114240E+00, 1.4994559919E+01, 3.4539348990E+00, 9.6433026628E-01],
	[3.9195000000E+04, 3.2957247041E+01, 5.1952411104E+00, 1.5000782901E+01, 3.4543582080E+00, 9.6434594089E-01],
	[3.9200000000E+04, 3.2964537848E+01, 5.1952707932E+00, 1.5007007671E+01, 3.4547814119E+00, 9.6436160776E-01],
	[3.9205000000E+04, 3.2971829339E+01, 5.1953004723E+00, 1.5013234229E+01, 3.4552045107E+00, 9.6437726687E-01],
	[3.9210000000E+04, 3.2979121512E+01, 5.1953301478E+00, 1.5019462574E+01, 3.4556275045E+00, 9.6439291824E-01],
	[3.9215000000E+04, 3.2986414368E+01, 5.1953598198E+00, 1.5025692707E+01, 3.4560503934E+00, 9.6440856187E-01],
	[3.9220000000E+04, 3.2993707906E+01, 5.1953894881E+00, 1.5031924629E+01, 3.4564731772E+00, 9.6442419776E-01],
	[3.9225000000E+04, 3.3001002127E+01, 5.1954191528E+00, 1.5038158339E+01, 3.4568958561E+00, 9.6443982593E-01],
	[3.9230000000E+04, 3.3008297031E+01, 5.1954488138E+00, 1.5044393838E+01, 3.4573184300E+00, 9.6445544636E-01],
	[3.9235000000E+04, 3.3015592617E+01, 5.1954784713E+00, 1.5050631126E+01, 3.4577408990E+00, 9.6447105907E-01],
	[3.9240000000E+04, 3.3022900339E+01, 5.1955095964E+00, 1.5056870204E+01, 3.4581640404E+00, 9.6448666406E-01],
	[3.9245000000E+04, 3.3030214816E+01, 5.1955414970E+00, 1.5063111071E+01, 3.4585874891E+00, 9.6450226134E-01],
	[3.9250000000E+04, 3.3037529980E+01, 5.1955733937E+00, 1.5069353728E+01, 3.4590108332E+00, 9.6451785090E-01],
	[3.9255000000E+04, 3.3044845833E+01, 5.1956052866E+00, 1.5075598176E+01, 3.4594340728E+00, 9.6453343276E-01],
	[3.9260000000E+04, 3.3052162374E+01, 5.1956371756E+00, 1.5081844414E+01, 3.4598572079E+00, 9.6454900691E-01],
	[3.9265000000E+04, 3.3059479602E+01, 5.1956690607E+00, 1.5088092443E+01, 3.4602802385E+00, 9.6456457337E-01],
	[3.9270000000E+04, 3.3066797519E+01, 5.1957009420E+00, 1.5094342264E+01, 3.4607031647E+00, 9.6458013212E-01],
	[3.9275000000E+04, 3.3074116123E+01, 5.1957328194E+00, 1.5100593875E+01, 3.4611259864E+00, 9.6459568319E-01],
	[3.9280000000E+04, 3.3081435415E+01, 5.1957646930E+00, 1.5106847279E+01, 3.4615487036E+00, 9.6461122657E-01],
	[3.9285000000E+04, 3.3088755395E+01, 5.1957965627E+00, 1.5113102474E+01, 3.4619713165E+00, 9.6462676227E-01],
	[3.9290000000E+04, 3.3096076063E+01, 5.1958284285E+00, 1.5119359462E+01, 3.4623938249E+00, 9.6464229029E-01],
	[3.9295000000E+04, 3.3103397418E+01, 5.1958602905E+00, 1.5125618243E+01, 3.4628162290E+00, 9.6465781063E-01],
	[3.9300000000E+04, 3.3110719462E+01, 5.1958921486E+00, 1.5131878816E+01, 3.4632385287E+00, 9.6467332331E-01],
	[3.9305000000E+04, 3.3118042193E+01, 5.1959240028E+00, 1.5138141182E+01, 3.4636607241E+00, 9.6468882831E-01],
	[3.9310000000E+04, 3.3125365611E+01, 5.1959558532E+00, 1.5144405342E+01, 3.4640828151E+00, 9.6470432566E-01],
	[3.9315000000E+04, 3.3132689718E+01, 5.1959876998E+00, 1.5150671296E+01, 3.4645048019E+00, 9.6471981534E-01],
	[3.9320000000E+04, 3.3140014512E+01, 5.1960195425E+00, 1.5156939044E+01, 3.4649266843E+00, 9.6473529737E-01],
	[3.9325000000E+04, 3.3147339994E+01, 5.1960513813E+00, 1.5163208586E+01, 3.4653484625E+00, 9.6475077175E-01],
	[3.9330000000E+04, 3.3154666163E+01, 5.1960832163E+00, 1.5169479922E+01, 3.4657701365E+00, 9.6476623849E-01],
	[3.9335000000E+04, 3.3161993020E+01, 5.1961150474E+00, 1.5175753053E+01, 3.4661917062E+00, 9.6478169758E-01],
	[3.9340000000E+04, 3.3169320564E+01, 5.1961468747E+00, 1.5182027980E+01, 3.4666131717E+00, 9.6479714903E-01],
	[3.9345000000E+04, 3.3176648797E+01, 5.1961786981E+00, 1.5188304702E+01, 3.4670345330E+00, 9.6481259285E-01],
	[3.9350000000E+04, 3.3183977716E+01, 5.1962105177E+00, 1.5194583220E+01, 3.4674557901E+00, 9.6482802904E-01],
	[3.9355000000E+04, 3.3191307323E+01, 5.1962423334E+00, 1.5200863533E+01, 3.4678769431E+00, 9.6484345760E-01],
	[3.9360000000E+04, 3.3198637618E+01, 5.1962741453E+00, 1.5207145643E+01, 3.4682979920E+00, 9.6485887854E-01],
	[3.9365000000E+04, 3.3205968600E+01, 5.1963059533E+00, 1.5213429550E+01, 3.4687189367E+00, 9.6487429187E-01],
	[3.9370000000E+04, 3.3213300269E+01, 5.1963377575E+00, 1.5219715253E+01, 3.4691397773E+00, 9.6488969758E-01],
	[3.9375000000E+04, 3.3220632626E+01, 5.1963695579E+00, 1.5226002754E+01, 3.4695605139E+00, 9.6490509567E-01],
	[3.9380000000E+04, 3.3227965671E+01, 5.1964013544E+00, 1.5232292052E+01, 3.4699811463E+00, 9.6492048617E-01],
	[3.9385000000E+04, 3.3235299402E+01, 5.1964331470E+00, 1.5238583148E+01, 3.4704016748E+00, 9.6493586906E-01],
	[3.9390000000E+04, 3.3242633821E+01, 5.1964649358E+00, 1.5244876041E+01, 3.4708220992E+00, 9.6495124435E-01],
	[3.9395000000E+04, 3.3249968928E+01, 5.1964967208E+00, 1.5251170733E+01, 3.4712424196E+00, 9.6496661205E-01],
	[3.9400000000E+04, 3.3257304721E+01, 5.1965285020E+00, 1.5257467224E+01, 3.4716626360E+00, 9.6498197216E-01],
	[3.9405000000E+04, 3.3264641202E+01, 5.1965602793E+00, 1.5263765513E+01, 3.4720827485E+00, 9.6499732468E-01],
	[3.9410000000E+04, 3.3271978370E+01, 5.1965920527E+00, 1.5270065602E+01, 3.4725027570E+00, 9.6501266963E-01],
	[3.9415000000E+04, 3.3279316226E+01, 5.1966238224E+00, 1.5276367490E+01, 3.4729226615E+00, 9.6502800699E-01],
	[3.9420000000E+04, 3.3286654768E+01, 5.1966555881E+00, 1.5282671178E+01, 3.4733424622E+00, 9.6504333678E-01],
	[3.9425000000E+04, 3.3293993998E+01, 5.1966873501E+00, 1.5288976665E+01, 3.4737621589E+00, 9.6505865900E-01],
	[3.9430000000E+04, 3.3301333915E+01, 5.1967191082E+00, 1.5295283953E+01, 3.4741817518E+00, 9.6507397366E-01],
	[3.9435000000E+04, 3.3308674519E+01, 5.1967508625E+00, 1.5301593042E+01, 3.4746012408E+00, 9.6508928075E-01],
	[3.9440000000E+04, 3.3316015810E+01, 5.1967826130E+00, 1.5307903931E+01, 3.4750206260E+00, 9.6510458029E-01],
	[3.9445000000E+04, 3.3323357789E+01, 5.1968143596E+00, 1.5314216622E+01, 3.4754399074E+00, 9.6511987227E-01],
	[3.9450000000E+04, 3.3330700454E+01, 5.1968461024E+00, 1.5320531114E+01, 3.4758590850E+00, 9.6513515671E-01],
	[3.9455000000E+04, 3.3338043807E+01, 5.1968778414E+00, 1.5326847408E+01, 3.4762781587E+00, 9.6515043360E-01],
	[3.9460000000E+04, 3.3345387846E+01, 5.1969095765E+00, 1.5333165503E+01, 3.4766971287E+00, 9.6516570294E-01],
	[3.9465000000E+04, 3.3352732572E+01, 5.1969413078E+00, 1.5339485401E+01, 3.4771159950E+00, 9.6518096475E-01],
	[3.9470000000E+04, 3.3360077986E+01, 5.1969730353E+00, 1.5345807102E+01, 3.4775347576E+00, 9.6519621903E-01],
	[3.9475000000E+04, 3.3367424086E+01, 5.1970047590E+00, 1.5352130605E+01, 3.4779534164E+00, 9.6521146578E-01],
	[3.9480000000E+04, 3.3374770874E+01, 5.1970364788E+00, 1.5358455912E+01, 3.4783719715E+00, 9.6522670500E-01],
	[3.9485000000E+04, 3.3382118348E+01, 5.1970681948E+00, 1.5364783022E+01, 3.4787904230E+00, 9.6524193670E-01],
	[3.9490000000E+04, 3.3389466509E+01, 5.1970999070E+00, 1.5371111935E+01, 3.4792087708E+00, 9.6525716089E-01],
	[3.9495000000E+04, 3.3396815357E+01, 5.1971316154E+00, 1.5377442653E+01, 3.4796270150E+00, 9.6527237756E-01],
	[3.9500000000E+04, 3.3404164892E+01, 5.1971633199E+00, 1.5383775175E+01, 3.4800451556E+00, 9.6528758672E-01],
	[3.9505000000E+04, 3.3411515113E+01, 5.1971950206E+00, 1.5390109501E+01, 3.4804631925E+00, 9.6530278838E-01],
	[3.9510000000E+04, 3.3418866022E+01, 5.1972267176E+00, 1.5396445633E+01, 3.4808811259E+00, 9.6531798253E-01],
	[3.9515000000E+04, 3.3426217617E+01, 5.1972584107E+00, 1.5402783569E+01, 3.4812989558E+00, 9.6533316919E-01],
	[3.9520000000E+04, 3.3433569899E+01, 5.1972900999E+00, 1.5409123311E+01, 3.4817166821E+00, 9.6534834836E-01],
	[3.9525000000E+04, 3.3440922868E+01, 5.1973217854E+00, 1.5415464859E+01, 3.4821343049E+00, 9.6536352003E-01],
	[3.9530000000E+04, 3.3448276523E+01, 5.1973534670E+00, 1.5421808212E+01, 3.4825518241E+00, 9.6537868423E-01],
	[3.9535000000E+04, 3.3455630865E+01, 5.1973851449E+00, 1.5428153372E+01, 3.4829692399E+00, 9.6539384094E-01],
	[3.9540000000E+04, 3.3462985894E+01, 5.1974168189E+00, 1.5434500338E+01, 3.4833865523E+00, 9.6540899017E-01],
	[3.9545000000E+04, 3.3470341609E+01, 5.1974484891E+00, 1.5440849112E+01, 3.4838037612E+00, 9.6542413193E-01],
	[3.9550000000E+04, 3.3477698011E+01, 5.1974801555E+00, 1.5447199692E+01, 3.4842208666E+00, 9.6543926622E-01],
	[3.9555000000E+04, 3.3485055100E+01, 5.1975118181E+00, 1.5453552080E+01, 3.4846378687E+00, 9.6545439305E-01],
	[3.9560000000E+04, 3.3492412875E+01, 5.1975434768E+00, 1.5459906275E+01, 3.4850547673E+00, 9.6546951241E-01],
	[3.9565000000E+04, 3.3499771337E+01, 5.1975751318E+00, 1.5466262279E+01, 3.4854715626E+00, 9.6548462432E-01],
	[3.9570000000E+04, 3.3507130485E+01, 5.1976067830E+00, 1.5472620090E+01, 3.4858882546E+00, 9.6549972878E-01],
	[3.9575000000E+04, 3.3514490320E+01, 5.1976384303E+00, 1.5478979711E+01, 3.4863048432E+00, 9.6551482578E-01],
	[3.9580000000E+04, 3.3521850841E+01, 5.1976700739E+00, 1.5485341140E+01, 3.4867213285E+00, 9.6552991534E-01],
	[3.9585000000E+04, 3.3529212049E+01, 5.1977017136E+00, 1.5491704378E+01, 3.4871377105E+00, 9.6554499746E-01],
	[3.9590000000E+04, 3.3536573943E+01, 5.1977333496E+00, 1.5498069426E+01, 3.4875539892E+00, 9.6556007215E-01],
	[3.9595000000E+04, 3.3543936524E+01, 5.1977649817E+00, 1.5504436283E+01, 3.4879701647E+00, 9.6557513940E-01],
	[3.9600000000E+04, 3.3551299790E+01, 5.1977966100E+00, 1.5510804950E+01, 3.4883862369E+00, 9.6559019922E-01],
	[3.9605000000E+04, 3.3558663744E+01, 5.1978282346E+00, 1.5517175428E+01, 3.4888022059E+00, 9.6560525162E-01],
	[3.9610000000E+04, 3.3566028383E+01, 5.1978598553E+00, 1.5523547716E+01, 3.4892180718E+00, 9.6562029659E-01],
	[3.9615000000E+04, 3.3573393709E+01, 5.1978914722E+00, 1.5529921815E+01, 3.4896338344E+00, 9.6563533415E-01],
	[3.9620000000E+04, 3.3580759722E+01, 5.1979230854E+00, 1.5536297725E+01, 3.4900494939E+00, 9.6565036429E-01],
	[3.9625000000E+04, 3.3588126420E+01, 5.1979546947E+00, 1.5542675447E+01, 3.4904650502E+00, 9.6566538703E-01],
	[3.9630000000E+04, 3.3595493805E+01, 5.1979863003E+00, 1.5549054980E+01, 3.4908805034E+00, 9.6568040236E-01],
	[3.9635000000E+04, 3.3602861876E+01, 5.1980179020E+00, 1.5555436325E+01, 3.4912958535E+00, 9.6569541029E-01],
	[3.9640000000E+04, 3.3610230633E+01, 5.1980495000E+00, 1.5561819482E+01, 3.4917111005E+00, 9.6571041083E-01],
	[3.9645000000E+04, 3.3617600077E+01, 5.1980810941E+00, 1.5568204452E+01, 3.4921262445E+00, 9.6572540397E-01],
	[3.9650000000E+04, 3.3624970206E+01, 5.1981126845E+00, 1.5574591235E+01, 3.4925412854E+00, 9.6574038972E-01],
	[3.9655000000E+04, 3.3632341022E+01, 5.1981442711E+00, 1.5580979831E+01, 3.4929562232E+00, 9.6575536808E-01],
	[3.9660000000E+04, 3.3639712524E+01, 5.1981758539E+00, 1.5587370241E+01, 3.4933710581E+00, 9.6577033907E-01],
	[3.9665000000E+04, 3.3647084712E+01, 5.1982074329E+00, 1.5593762464E+01, 3.4937857900E+00, 9.6578530267E-01],
	[3.9670000000E+04, 3.3654457586E+01, 5.1982390081E+00, 1.5600156501E+01, 3.4942004189E+00, 9.6580025891E-01],
	[3.9675000000E+04, 3.3661831146E+01, 5.1982705795E+00, 1.5606552352E+01, 3.4946149448E+00, 9.6581520777E-01],
	[3.9680000000E+04, 3.3669205392E+01, 5.1983021471E+00, 1.5612950018E+01, 3.4950293678E+00, 9.6583014927E-01],
	[3.9685000000E+04, 3.3676580324E+01, 5.1983337110E+00, 1.5619349498E+01, 3.4954436879E+00, 9.6584508341E-01],
	[3.9690000000E+04, 3.3683955942E+01, 5.1983652710E+00, 1.5625750794E+01, 3.4958579051E+00, 9.6586001019E-01],
	[3.9695000000E+04, 3.3691332246E+01, 5.1983968273E+00, 1.5632153905E+01, 3.4962720194E+00, 9.6587492962E-01],
	[3.9700000000E+04, 3.3698709236E+01, 5.1984283798E+00, 1.5638558832E+01, 3.4966860309E+00, 9.6588984170E-01],
	[3.9705000000E+04, 3.3706086912E+01, 5.1984599285E+00, 1.5644965575E+01, 3.4970999395E+00, 9.6590474643E-01],
	[3.9710000000E+04, 3.3713465273E+01, 5.1984914735E+00, 1.5651374134E+01, 3.4975137453E+00, 9.6591964382E-01],
	[3.9715000000E+04, 3.3720844321E+01, 5.1985230146E+00, 1.5657784510E+01, 3.4979274483E+00, 9.6593453387E-01],
	[3.9720000000E+04, 3.3728224054E+01, 5.1985545520E+00, 1.5664196703E+01, 3.4983410486E+00, 9.6594941659E-01],
	[3.9725000000E+04, 3.3735604474E+01, 5.1985860856E+00, 1.5670610712E+01, 3.4987545460E+00, 9.6596429199E-01],
	[3.9730000000E+04, 3.3742985579E+01, 5.1986176154E+00, 1.5677026539E+01, 3.4991679408E+00, 9.6597916005E-01],
	[3.9735000000E+04, 3.3750367370E+01, 5.1986491414E+00, 1.5683444184E+01, 3.4995812327E+00, 9.6599402079E-01],
	[3.9740000000E+04, 3.3757749846E+01, 5.1986806637E+00, 1.5689863647E+01, 3.4999944220E+00, 9.6600887422E-01],
	[3.9745000000E+04, 3.3765133008E+01, 5.1987121822E+00, 1.5696284928E+01, 3.5004075086E+00, 9.6602372033E-01],
	[3.9750000000E+04, 3.3772516857E+01, 5.1987436969E+00, 1.5702708027E+01, 3.5008204926E+00, 9.6603855913E-01],
	[3.9755000000E+04, 3.3779901390E+01, 5.1987752079E+00, 1.5709132946E+01, 3.5012333739E+00, 9.6605339063E-01],
	[3.9760000000E+04, 3.3787286610E+01, 5.1988067150E+00, 1.5715559683E+01, 3.5016461525E+00, 9.6606821483E-01],
	[3.9765000000E+04, 3.3794672515E+01, 5.1988382184E+00, 1.5721988240E+01, 3.5020588286E+00, 9.6608303172E-01],
	[3.9770000000E+04, 3.3802059105E+01, 5.1988697181E+00, 1.5728418616E+01, 3.5024714021E+00, 9.6609784133E-01],
	[3.9775000000E+04, 3.3809446382E+01, 5.1989012139E+00, 1.5734850813E+01, 3.5028838730E+00, 9.6611264364E-01],
	[3.9780000000E+04, 3.3816834343E+01, 5.1989327060E+00, 1.5741284830E+01, 3.5032962413E+00, 9.6612743867E-01],
	[3.9785000000E+04, 3.3824222991E+01, 5.1989641943E+00, 1.5747720667E+01, 3.5037085071E+00, 9.6614222641E-01],
	[3.9790000000E+04, 3.3831612324E+01, 5.1989956789E+00, 1.5754158325E+01, 3.5041206704E+00, 9.6615700688E-01],
	[3.9795000000E+04, 3.3839002342E+01, 5.1990271597E+00, 1.5760597805E+01, 3.5045327312E+00, 9.6617178007E-01],
	[3.9800000000E+04, 3.3846393046E+01, 5.1990586367E+00, 1.5767039105E+01, 3.5049446895E+00, 9.6618654599E-01],
	[3.9805000000E+04, 3.3853784435E+01, 5.1990901100E+00, 1.5773482228E+01, 3.5053565454E+00, 9.6620130465E-01],
	[3.9810000000E+04, 3.3861176510E+01, 5.1991215795E+00, 1.5779927172E+01, 3.5057682988E+00, 9.6621605604E-01],
	[3.9815000000E+04, 3.3868569271E+01, 5.1991530452E+00, 1.5786373939E+01, 3.5061799499E+00, 9.6623080018E-01],
	[3.9820000000E+04, 3.3875962716E+01, 5.1991845072E+00, 1.5792822528E+01, 3.5065914985E+00, 9.6624553706E-01],
	[3.9825000000E+04, 3.3883356847E+01, 5.1992159654E+00, 1.5799272940E+01, 3.5070029447E+00, 9.6626026669E-01],
	[3.9830000000E+04, 3.3890751663E+01, 5.1992474199E+00, 1.5805725175E+01, 3.5074142886E+00, 9.6627498909E-01],
	[3.9835000000E+04, 3.3898147165E+01, 5.1992788706E+00, 1.5812179234E+01, 3.5078255302E+00, 9.6628970427E-01],
	[3.9840000000E+04, 3.3905543352E+01, 5.1993103176E+00, 1.5818635116E+01, 3.5082366694E+00, 9.6630441222E-01],
	[3.9845000000E+04, 3.3912940224E+01, 5.1993417608E+00, 1.5825092822E+01, 3.5086477063E+00, 9.6631911296E-01],
	[3.9850000000E+04, 3.3920337782E+01, 5.1993732002E+00, 1.5831552353E+01, 3.5090586409E+00, 9.6633380648E-01],
	[3.9855000000E+04, 3.3927736025E+01, 5.1994046359E+00, 1.5838013708E+01, 3.5094694733E+00, 9.6634849280E-01],
	[3.9860000000E+04, 3.3935134953E+01, 5.1994360678E+00, 1.5844476888E+01, 3.5098802034E+00, 9.6636317190E-01],
	[3.9865000000E+04, 3.3942534566E+01, 5.1994674960E+00, 1.5850941892E+01, 3.5102908313E+00, 9.6637784381E-01],
	[3.9870000000E+04, 3.3949940433E+01, 5.1994996298E+00, 1.5857408723E+01, 3.5107017400E+00, 9.6639250851E-01],
	[3.9875000000E+04, 3.3957358707E+01, 5.1995332525E+00, 1.5863877379E+01, 3.5111133525E+00, 9.6640716602E-01],
	[3.9880000000E+04, 3.3964777671E+01, 5.1995668712E+00, 1.5870347861E+01, 3.5115248632E+00, 9.6642181633E-01],
	[3.9885000000E+04, 3.3972197326E+01, 5.1996004859E+00, 1.5876820169E+01, 3.5119362721E+00, 9.6643645946E-01],
	[3.9890000000E+04, 3.3979617672E+01, 5.1996340966E+00, 1.5883294304E+01, 3.5123475792E+00, 9.6645109540E-01],
	[3.9895000000E+04, 3.3987038707E+01, 5.1996677034E+00, 1.5889770266E+01, 3.5127587844E+00, 9.6646572415E-01],
	[3.9900000000E+04, 3.3994460434E+01, 5.1997013061E+00, 1.5896248055E+01, 3.5131698879E+00, 9.6648034573E-01],
	[3.9905000000E+04, 3.4001882850E+01, 5.1997349048E+00, 1.5902727671E+01, 3.5135808896E+00, 9.6649496013E-01],
	[3.9910000000E+04, 3.4009305957E+01, 5.1997684996E+00, 1.5909209115E+01, 3.5139917896E+00, 9.6650956736E-01],
	[3.9915000000E+04, 3.4016729755E+01, 5.1998020903E+00, 1.5915692387E+01, 3.5144025879E+00, 9.6652416742E-01],
	[3.9920000000E+04, 3.4024154243E+01, 5.1998356771E+00, 1.5922177487E+01, 3.5148132844E+00, 9.6653876031E-01],
	[3.9925000000E+04, 3.4031579421E+01, 5.1998692598E+00, 1.5928664416E+01, 3.5152238793E+00, 9.6655334605E-01],
	[3.9930000000E+04, 3.4039005289E+01, 5.1999028386E+00, 1.5935153173E+01, 3.5156343726E+00, 9.6656792462E-01],
	[3.9935000000E+04, 3.4046431847E+01, 5.1999364134E+00, 1.5941643760E+01, 3.5160447641E+00, 9.6658249604E-01],
	[3.9940000000E+04, 3.4053859096E+01, 5.1999699842E+00, 1.5948136176E+01, 3.5164550541E+00, 9.6659706031E-01],
	[3.9945000000E+04, 3.4061287035E+01, 5.2000035510E+00, 1.5954630422E+01, 3.5168652425E+00, 9.6661161743E-01],
	[3.9950000000E+04, 3.4068715664E+01, 5.2000371139E+00, 1.5961126498E+01, 3.5172753293E+00, 9.6662616740E-01],
	[3.9955000000E+04, 3.4076144984E+01, 5.2000706727E+00, 1.5967624404E+01, 3.5176853145E+00, 9.6664071024E-01],
	[3.9960000000E+04, 3.4083574993E+01, 5.2001042276E+00, 1.5974124140E+01, 3.5180951981E+00, 9.6665524593E-01],
	[3.9965000000E+04, 3.4091005693E+01, 5.2001377785E+00, 1.5980625708E+01, 3.5185049803E+00, 9.6666977450E-01],
	[3.9970000000E+04, 3.4098437083E+01, 5.2001713254E+00, 1.5987129106E+01, 3.5189146609E+00, 9.6668429593E-01],
	[3.9975000000E+04, 3.4105869162E+01, 5.2002048683E+00, 1.5993634336E+01, 3.5193242401E+00, 9.6669881023E-01],
	[3.9980000000E+04, 3.4113301932E+01, 5.2002384073E+00, 1.6000141398E+01, 3.5197337178E+00, 9.6671331741E-01],
	[3.9985000000E+04, 3.4120735392E+01, 5.2002719423E+00, 1.6006650291E+01, 3.5201430940E+00, 9.6672781747E-01],
	[3.9990000000E+04, 3.4128169542E+01, 5.2003054732E+00, 1.6013161017E+01, 3.5205523688E+00, 9.6674231041E-01],
	[3.9995000000E+04, 3.4135604382E+01, 5.2003390003E+00, 1.6019673576E+01, 3.5209615422E+00, 9.6675679624E-01],
	[4.0000000000E+04, 3.4143039912E+01, 5.2003725233E+00, 1.6026187967E+01, 3.5213706142E+00, 9.6677127496E-01],
	[4.0005000000E+04, 3.4150476132E+01, 5.2004060424E+00, 1.6032729096E+01, 3.5217807865E+00, 9.6678574657E-01],
	[4.0010000000E+04, 3.4157913041E+01, 5.2004395575E+00, 1.6039272076E+01, 3.5221908569E+00, 9.6680021108E-01],
	[4.0015000000E+04, 3.4165350641E+01, 5.2004730686E+00, 1.6045816907E+01, 3.5226008254E+00, 9.6681466849E-01],
	[4.0020000000E+04, 3.4172788931E+01, 5.2005065758E+00, 1.6052363590E+01, 3.5230106921E+00, 9.6682911881E-01],
	[4.0025000000E+04, 3.4180227910E+01, 5.2005400789E+00, 1.6058912123E+01, 3.5234204568E+00, 9.6684356203E-01],
	[4.0030000000E+04, 3.4187667579E+01, 5.2005735781E+00, 1.6065462509E+01, 3.5238301198E+00, 9.6685799816E-01],
	[4.0035000000E+04, 3.4195107938E+01, 5.2006070734E+00, 1.6072014747E+01, 3.5242396809E+00, 9.6687242720E-01],
	[4.0040000000E+04, 3.4202548987E+01, 5.2006405647E+00, 1.6078568837E+01, 3.5246491402E+00, 9.6688684917E-01],
	[4.0045000000E+04, 3.4209990725E+01, 5.2006740520E+00, 1.6085124780E+01, 3.5250584977E+00, 9.6690126405E-01],
	[4.0050000000E+04, 3.4217433154E+01, 5.2007075353E+00, 1.6091682576E+01, 3.5254677535E+00, 9.6691567186E-01],
	[4.0055000000E+04, 3.4224876272E+01, 5.2007410147E+00, 1.6098242226E+01, 3.5258769075E+00, 9.6693007260E-01],
	[4.0060000000E+04, 3.4232320080E+01, 5.2007744901E+00, 1.6104803729E+01, 3.5262859598E+00, 9.6694446626E-01],
	[4.0065000000E+04, 3.4239764577E+01, 5.2008079616E+00, 1.6111367086E+01, 3.5266949104E+00, 9.6695885287E-01],
	[4.0070000000E+04, 3.4247209764E+01, 5.2008414291E+00, 1.6117932297E+01, 3.5271037594E+00, 9.6697323241E-01],
	[4.0075000000E+04, 3.4254655641E+01, 5.2008748926E+00, 1.6124499362E+01, 3.5275125066E+00, 9.6698760489E-01],
	[4.0080000000E+04, 3.4262102207E+01, 5.2009083522E+00, 1.6131068283E+01, 3.5279211522E+00, 9.6700197032E-01],
	[4.0085000000E+04, 3.4269549463E+01, 5.2009418078E+00, 1.6137639058E+01, 3.5283296962E+00, 9.6701632869E-01],
	[4.0090000000E+04, 3.4276997408E+01, 5.2009752595E+00, 1.6144211689E+01, 3.5287381386E+00, 9.6703068002E-01],
	[4.0095000000E+04, 3.4284446043E+01, 5.2010087072E+00, 1.6150786176E+01, 3.5291464794E+00, 9.6704502431E-01],
	[4.0100000000E+04, 3.4291895368E+01, 5.2010421509E+00, 1.6157362518E+01, 3.5295547186E+00, 9.6705936155E-01],
	[4.0105000000E+04, 3.4299345382E+01, 5.2010755907E+00, 1.6163940717E+01, 3.5299628563E+00, 9.6707369175E-01],
	[4.0110000000E+04, 3.4306796086E+01, 5.2011090265E+00, 1.6170520772E+01, 3.5303708924E+00, 9.6708801493E-01],
	[4.0115000000E+04, 3.4314247479E+01, 5.2011424584E+00, 1.6177102684E+01, 3.5307788271E+00, 9.6710233107E-01],
	[4.0120000000E+04, 3.4321699561E+01, 5.2011758864E+00, 1.6183686453E+01, 3.5311866602E+00, 9.6711664018E-01],
	[4.0125000000E+04, 3.4329152333E+01, 5.2012093103E+00, 1.6190272080E+01, 3.5315943919E+00, 9.6713094227E-01],
	[4.0130000000E+04, 3.4336605794E+01, 5.2012427304E+00, 1.6196859564E+01, 3.5320020222E+00, 9.6714523734E-01],
	[4.0135000000E+04, 3.4344059945E+01, 5.2012761465E+00, 1.6203448906E+01, 3.5324095510E+00, 9.6715952539E-01],
	[4.0140000000E+04, 3.4351514784E+01, 5.2013095586E+00, 1.6210040107E+01, 3.5328169784E+00, 9.6717380643E-01],
	[4.0145000000E+04, 3.4358970314E+01, 5.2013429668E+00, 1.6216633166E+01, 3.5332243044E+00, 9.6718808046E-01],
	[4.0150000000E+04, 3.4366426532E+01, 5.2013763710E+00, 1.6223228084E+01, 3.5336315290E+00, 9.6720234748E-01],
	[4.0155000000E+04, 3.4373883440E+01, 5.2014097713E+00, 1.6229824861E+01, 3.5340386523E+00, 9.6721660750E-01],
	[4.0160000000E+04, 3.4381341037E+01, 5.2014431677E+00, 1.6236423498E+01, 3.5344456743E+00, 9.6723086052E-01],
	[4.0165000000E+04, 3.4388799324E+01, 5.2014765601E+00, 1.6243023995E+01, 3.5348525949E+00, 9.6724510654E-01],
	[4.0170000000E+04, 3.4396258299E+01, 5.2015099485E+00, 1.6249626351E+01, 3.5352594143E+00, 9.6725934558E-01],
	[4.0175000000E+04, 3.4403717964E+01, 5.2015433331E+00, 1.6256230568E+01, 3.5356661323E+00, 9.6727357762E-01],
	[4.0180000000E+04, 3.4411178318E+01, 5.2015767136E+00, 1.6262836645E+01, 3.5360727492E+00, 9.6728780267E-01],
	[4.0185000000E+04, 3.4418639361E+01, 5.2016100903E+00, 1.6269444584E+01, 3.5364792647E+00, 9.6730202075E-01],
	[4.0190000000E+04, 3.4426101093E+01, 5.2016434630E+00, 1.6276054383E+01, 3.5368856791E+00, 9.6731623184E-01],
	[4.0195000000E+04, 3.4433563514E+01, 5.2016768318E+00, 1.6282666044E+01, 3.5372919923E+00, 9.6733043596E-01],
	[4.0200000000E+04, 3.4441026625E+01, 5.2017101966E+00, 1.6289279567E+01, 3.5376982043E+00, 9.6734463311E-01],
	[4.0205000000E+04, 3.4448490424E+01, 5.2017435575E+00, 1.6295894952E+01, 3.5381043152E+00, 9.6735882329E-01],
	[4.0210000000E+04, 3.4455954912E+01, 5.2017769145E+00, 1.6302512199E+01, 3.5385103249E+00, 9.6737300650E-01],
	[4.0215000000E+04, 3.4463420090E+01, 5.2018102675E+00, 1.6309131309E+01, 3.5389162335E+00, 9.6738718275E-01],
	[4.0220000000E+04, 3.4470885956E+01, 5.2018436166E+00, 1.6315752282E+01, 3.5393220410E+00, 9.6740135204E-01],
	[4.0225000000E+04, 3.4478352512E+01, 5.2018769617E+00, 1.6322375118E+01, 3.5397277474E+00, 9.6741551438E-01],
	[4.0230000000E+04, 3.4485819756E+01, 5.2019103030E+00, 1.6328999818E+01, 3.5401333528E+00, 9.6742966977E-01],
	[4.0235000000E+04, 3.4493287689E+01, 5.2019436403E+00, 1.6335626382E+01, 3.5405388571E+00, 9.6744381821E-01],
	[4.0240000000E+04, 3.4500756312E+01, 5.2019769737E+00, 1.6342254809E+01, 3.5409442604E+00, 9.6745795970E-01],
	[4.0245000000E+04, 3.4508225623E+01, 5.2020103031E+00, 1.6348885102E+01, 3.5413495628E+00, 9.6747209426E-01],
	[4.0250000000E+04, 3.4515695623E+01, 5.2020436286E+00, 1.6355517259E+01, 3.5417547641E+00, 9.6748622187E-01],
	[4.0255000000E+04, 3.4523166311E+01, 5.2020769502E+00, 1.6362151280E+01, 3.5421598645E+00, 9.6750034255E-01],
	[4.0260000000E+04, 3.4530637689E+01, 5.2021102679E+00, 1.6368787168E+01, 3.5425648639E+00, 9.6751445630E-01],
	[4.0265000000E+04, 3.4538109755E+01, 5.2021435816E+00, 1.6375424920E+01, 3.5429697624E+00, 9.6752856313E-01],
	[4.0270000000E+04, 3.4545582511E+01, 5.2021768914E+00, 1.6382064539E+01, 3.5433745601E+00, 9.6754266303E-01],
	[4.0275000000E+04, 3.4553055955E+01, 5.2022101973E+00, 1.6388706024E+01, 3.5437792568E+00, 9.6755675601E-01],
	[4.0280000000E+04, 3.4560530087E+01, 5.2022434993E+00, 1.6395349375E+01, 3.5441838527E+00, 9.6757084207E-01],
	[4.0285000000E+04, 3.4568004909E+01, 5.2022767974E+00, 1.6401994593E+01, 3.5445883478E+00, 9.6758492122E-01],
	[4.0290000000E+04, 3.4575480419E+01, 5.2023100915E+00, 1.6408641678E+01, 3.5449927420E+00, 9.6759899346E-01],
	[4.0295000000E+04, 3.4582956617E+01, 5.2023433817E+00, 1.6415290631E+01, 3.5453970354E+00, 9.6761305879E-01],
	[4.0300000000E+04, 3.4590433505E+01, 5.2023766680E+00, 1.6421941451E+01, 3.5458012281E+00, 9.6762711722E-01],
	[4.0305000000E+04, 3.4597911081E+01, 5.2024099504E+00, 1.6428594139E+01, 3.5462053200E+00, 9.6764116875E-01],
	[4.0310000000E+04, 3.4605389345E+01, 5.2024432289E+00, 1.6435248695E+01, 3.5466093111E+00, 9.6765521338E-01],
	[4.0315000000E+04, 3.4612868298E+01, 5.2024765034E+00, 1.6441905120E+01, 3.5470132015E+00, 9.6766925112E-01],
	[4.0320000000E+04, 3.4620347940E+01, 5.2025097741E+00, 1.6448563413E+01, 3.5474169913E+00, 9.6768328197E-01],
	[4.0325000000E+04, 3.4627828270E+01, 5.2025430408E+00, 1.6455223576E+01, 3.5478206803E+00, 9.6769730594E-01],
	[4.0330000000E+04, 3.4635309289E+01, 5.2025763036E+00, 1.6461885608E+01, 3.5482242687E+00, 9.6771132302E-01],
	[4.0335000000E+04, 3.4642790996E+01, 5.2026095625E+00, 1.6468549510E+01, 3.5486277564E+00, 9.6772533322E-01],
	[4.0340000000E+04, 3.4650273392E+01, 5.2026428175E+00, 1.6475215282E+01, 3.5490311435E+00, 9.6773933655E-01],
	[4.0345000000E+04, 3.4657756476E+01, 5.2026760686E+00, 1.6481882924E+01, 3.5494344301E+00, 9.6775333300E-01],
	[4.0350000000E+04, 3.4665240248E+01, 5.2027093158E+00, 1.6488552436E+01, 3.5498376160E+00, 9.6776732259E-01],
	[4.0355000000E+04, 3.4672724709E+01, 5.2027425591E+00, 1.6495223820E+01, 3.5502407014E+00, 9.6778130531E-01],
	[4.0360000000E+04, 3.4680209858E+01, 5.2027757984E+00, 1.6501897074E+01, 3.5506436862E+00, 9.6779528117E-01],
	[4.0365000000E+04, 3.4687695696E+01, 5.2028090339E+00, 1.6508572200E+01, 3.5510465705E+00, 9.6780925017E-01],
	[4.0370000000E+04, 3.4695182222E+01, 5.2028422654E+00, 1.6515249198E+01, 3.5514493543E+00, 9.6782321231E-01],
	[4.0375000000E+04, 3.4702669436E+01, 5.2028754931E+00, 1.6521928068E+01, 3.5518520376E+00, 9.6783716760E-01],
	[4.0380000000E+04, 3.4710157339E+01, 5.2029087168E+00, 1.6528608810E+01, 3.5522546205E+00, 9.6785111605E-01],
	[4.0385000000E+04, 3.4717645930E+01, 5.2029419367E+00, 1.6535291424E+01, 3.5526571029E+00, 9.6786505765E-01],
	[4.0390000000E+04, 3.4725135209E+01, 5.2029751526E+00, 1.6541975912E+01, 3.5530594849E+00, 9.6787899241E-01],
	[4.0395000000E+04, 3.4732625176E+01, 5.2030083647E+00, 1.6548662273E+01, 3.5534617665E+00, 9.6789292033E-01],
	[4.0400000000E+04, 3.4740115832E+01, 5.2030415728E+00, 1.6555350507E+01, 3.5538639477E+00, 9.6790684142E-01],
	[4.0405000000E+04, 3.4747607175E+01, 5.2030747771E+00, 1.6562040615E+01, 3.5542660285E+00, 9.6792075567E-01],
	[4.0410000000E+04, 3.4755099207E+01, 5.2031079774E+00, 1.6568732597E+01, 3.5546680090E+00, 9.6793466310E-01],
	[4.0415000000E+04, 3.4762591927E+01, 5.2031411739E+00, 1.6575426454E+01, 3.5550698892E+00, 9.6794856370E-01],
	[4.0420000000E+04, 3.4770085335E+01, 5.2031743664E+00, 1.6582122185E+01, 3.5554716690E+00, 9.6796245748E-01],
	[4.0425000000E+04, 3.4777579431E+01, 5.2032075551E+00, 1.6588819791E+01, 3.5558733486E+00, 9.6797634445E-01],
	[4.0430000000E+04, 3.4785074216E+01, 5.2032407399E+00, 1.6595519272E+01, 3.5562749279E+00, 9.6799022460E-01],
	[4.0435000000E+04, 3.4792569688E+01, 5.2032739208E+00, 1.6602220629E+01, 3.5566764070E+00, 9.6800409794E-01],
	[4.0440000000E+04, 3.4800065848E+01, 5.2033070978E+00, 1.6608923862E+01, 3.5570777858E+00, 9.6801796447E-01],
	[4.0445000000E+04, 3.4807562697E+01, 5.2033402709E+00, 1.6615628971E+01, 3.5574790645E+00, 9.6803182420E-01],
	[4.0450000000E+04, 3.4815060233E+01, 5.2033734401E+00, 1.6622335956E+01, 3.5578802429E+00, 9.6804567713E-01],
	[4.0455000000E+04, 3.4822558457E+01, 5.2034066054E+00, 1.6629044818E+01, 3.5582813212E+00, 9.6805952327E-01],
	[4.0460000000E+04, 3.4830057369E+01, 5.2034397668E+00, 1.6635755557E+01, 3.5586822994E+00, 9.6807336261E-01],
	[4.0465000000E+04, 3.4837556969E+01, 5.2034729244E+00, 1.6642468173E+01, 3.5590831774E+00, 9.6808719516E-01],
	[4.0470000000E+04, 3.4845057257E+01, 5.2035060780E+00, 1.6649182667E+01, 3.5594839553E+00, 9.6810102092E-01],
	[4.0475000000E+04, 3.4852558233E+01, 5.2035392278E+00, 1.6655899038E+01, 3.5598846331E+00, 9.6811483990E-01],
	[4.0480000000E+04, 3.4860059897E+01, 5.2035723737E+00, 1.6662617288E+01, 3.5602852109E+00, 9.6812865210E-01],
	[4.0485000000E+04, 3.4867562249E+01, 5.2036055157E+00, 1.6669337417E+01, 3.5606856886E+00, 9.6814245752E-01],
	[4.0490000000E+04, 3.4875065288E+01, 5.2036386539E+00, 1.6676059424E+01, 3.5610860663E+00, 9.6815625617E-01],
	[4.0495000000E+04, 3.4882569015E+01, 5.2036717881E+00, 1.6682783310E+01, 3.5614863440E+00, 9.6817004806E-01],
	[4.0500000000E+04, 3.4890073430E+01, 5.2037049185E+00, 1.6689509075E+01, 3.5618865217E+00, 9.6818383317E-01],
	[4.0505000000E+04, 3.4897578533E+01, 5.2037380450E+00, 1.6696236720E+01, 3.5622865995E+00, 9.6819761152E-01],
	[4.0510000000E+04, 3.4905084323E+01, 5.2037711676E+00, 1.6702966245E+01, 3.5626865773E+00, 9.6821138312E-01],
	[4.0515000000E+04, 3.4912607204E+01, 5.2038063465E+00, 1.6709697651E+01, 3.5630875918E+00, 9.6822514796E-01],
	[4.0520000000E+04, 3.4920131519E+01, 5.2038416144E+00, 1.6716430936E+01, 3.5634885582E+00, 9.6823890604E-01],
	[4.0525000000E+04, 3.4927656527E+01, 5.2038768782E+00, 1.6723166103E+01, 3.5638894249E+00, 9.6825265738E-01],
	[4.0530000000E+04, 3.4935182227E+01, 5.2039121378E+00, 1.6729903150E+01, 3.5642901921E+00, 9.6826640197E-01],
	[4.0535000000E+04, 3.4942708621E+01, 5.2039473934E+00, 1.6736642079E+01, 3.5646908597E+00, 9.6828013982E-01],
	[4.0540000000E+04, 3.4950235708E+01, 5.2039826448E+00, 1.6743382890E+01, 3.5650914278E+00, 9.6829387093E-01],
	[4.0545000000E+04, 3.4957763487E+01, 5.2040178922E+00, 1.6750125583E+01, 3.5654918964E+00, 9.6830759530E-01],
	[4.0550000000E+04, 3.4965291959E+01, 5.2040531354E+00, 1.6756870158E+01, 3.5658922655E+00, 9.6832131295E-01],
	[4.0555000000E+04, 3.4972821124E+01, 5.2040883745E+00, 1.6763616615E+01, 3.5662925351E+00, 9.6833502386E-01],
	[4.0560000000E+04, 3.4980350982E+01, 5.2041236095E+00, 1.6770364956E+01, 3.5666927053E+00, 9.6834872805E-01],
	[4.0565000000E+04, 3.4987881532E+01, 5.2041588405E+00, 1.6777115179E+01, 3.5670927761E+00, 9.6836242552E-01],
	[4.0570000000E+04, 3.4995412776E+01, 5.2041940673E+00, 1.6783867286E+01, 3.5674927474E+00, 9.6837611627E-01],
	[4.0575000000E+04, 3.5002944711E+01, 5.2042292900E+00, 1.6790621277E+01, 3.5678926194E+00, 9.6838980031E-01],
	[4.0580000000E+04, 3.5010477340E+01, 5.2042645086E+00, 1.6797377151E+01, 3.5682923920E+00, 9.6840347763E-01],
	[4.0585000000E+04, 3.5018010661E+01, 5.2042997231E+00, 1.6804134910E+01, 3.5686920652E+00, 9.6841714825E-01],
	[4.0590000000E+04, 3.5025544675E+01, 5.2043349335E+00, 1.6810894554E+01, 3.5690916391E+00, 9.6843081216E-01],
	[4.0595000000E+04, 3.5033079382E+01, 5.2043701398E+00, 1.6817656083E+01, 3.5694911137E+00, 9.6844446937E-01],
	[4.0600000000E+04, 3.5040614781E+01, 5.2044053420E+00, 1.6824419496E+01, 3.5698904890E+00, 9.6845811988E-01],
	[4.0605000000E+04, 3.5048150872E+01, 5.2044405401E+00, 1.6831184796E+01, 3.5702897650E+00, 9.6847176370E-01],
	[4.0610000000E+04, 3.5055687656E+01, 5.2044757341E+00, 1.6837951981E+01, 3.5706889418E+00, 9.6848540083E-01],
	[4.0615000000E+04, 3.5063225133E+01, 5.2045109240E+00, 1.6844721052E+01, 3.5710880194E+00, 9.6849903127E-01],
	[4.0620000000E+04, 3.5070763302E+01, 5.2045461099E+00, 1.6851492009E+01, 3.5714869977E+00, 9.6851265503E-01],
	[4.0625000000E+04, 3.5078302164E+01, 5.2045812916E+00, 1.6858264853E+01, 3.5718858769E+00, 9.6852627210E-01],
	[4.0630000000E+04, 3.5085841718E+01, 5.2046164692E+00, 1.6865039584E+01, 3.5722846569E+00, 9.6853988250E-01],
	[4.0635000000E+04, 3.5093381965E+01, 5.2046516428E+00, 1.6871816202E+01, 3.5726833377E+00, 9.6855348623E-01],
	[4.0640000000E+04, 3.5100922904E+01, 5.2046868123E+00, 1.6878594708E+01, 3.5730819194E+00, 9.6856708328E-01],
	[4.0645000000E+04, 3.5108464535E+01, 5.2047219776E+00, 1.6885375102E+01, 3.5734804020E+00, 9.6858067367E-01],
	[4.0650000000E+04, 3.5116006859E+01, 5.2047571389E+00, 1.6892157384E+01, 3.5738787855E+00, 9.6859425739E-01],
	[4.0655000000E+04, 3.5123549875E+01, 5.2047922961E+00, 1.6898941554E+01, 3.5742770700E+00, 9.6860783445E-01],
	[4.0660000000E+04, 3.5131093584E+01, 5.2048274492E+00, 1.6905727613E+01, 3.5746752554E+00, 9.6862140486E-01],
	[4.0665000000E+04, 3.5138637984E+01, 5.2048625982E+00, 1.6912515561E+01, 3.5750733417E+00, 9.6863496861E-01],
	[4.0670000000E+04, 3.5146183078E+01, 5.2048977432E+00, 1.6919305398E+01, 3.5754713291E+00, 9.6864852571E-01],
	[4.0675000000E+04, 3.5153728863E+01, 5.2049328840E+00, 1.6926097125E+01, 3.5758692174E+00, 9.6866207617E-01],
	[4.0680000000E+04, 3.5161275340E+01, 5.2049680208E+00, 1.6932890741E+01, 3.5762670068E+00, 9.6867561998E-01],
	[4.0685000000E+04, 3.5168822510E+01, 5.2050031535E+00, 1.6939686248E+01, 3.5766646973E+00, 9.6868915716E-01],
	[4.0690000000E+04, 3.5176370372E+01, 5.2050382821E+00, 1.6946483645E+01, 3.5770622888E+00, 9.6870268769E-01],
	[4.0695000000E+04, 3.5183918927E+01, 5.2050734066E+00, 1.6953282933E+01, 3.5774597814E+00, 9.6871621160E-01],
	[4.0700000000E+04, 3.5191468173E+01, 5.2051085271E+00, 1.6960084113E+01, 3.5778571751E+00, 9.6872972887E-01],
	[4.0705000000E+04, 3.5199018111E+01, 5.2051436435E+00, 1.6966887183E+01, 3.5782544699E+00, 9.6874323952E-01],
	[4.0710000000E+04, 3.5206568742E+01, 5.2051787558E+00, 1.6973692145E+01, 3.5786516659E+00, 9.6875674354E-01],
	[4.0715000000E+04, 3.5214120065E+01, 5.2052138640E+00, 1.6980498999E+01, 3.5790487630E+00, 9.6877024095E-01],
	[4.0720000000E+04, 3.5221672080E+01, 5.2052489682E+00, 1.6987307746E+01, 3.5794457614E+00, 9.6878373174E-01],
	[4.0725000000E+04, 3.5229224786E+01, 5.2052840682E+00, 1.6994118384E+01, 3.5798426609E+00, 9.6879721592E-01],
	[4.0730000000E+04, 3.5236778185E+01, 5.2053191642E+00, 1.7000930916E+01, 3.5802394617E+00, 9.6881069348E-01],
	[4.0735000000E+04, 3.5244332276E+01, 5.2053542562E+00, 1.7007745341E+01, 3.5806361638E+00, 9.6882416445E-01],
	[4.0740000000E+04, 3.5251887059E+01, 5.2053893440E+00, 1.7014561659E+01, 3.5810327671E+00, 9.6883762881E-01],
	[4.0745000000E+04, 3.5259442534E+01, 5.2054244278E+00, 1.7021379871E+01, 3.5814292717E+00, 9.6885108657E-01],
	[4.0750000000E+04, 3.5266998701E+01, 5.2054595076E+00, 1.7028199976E+01, 3.5818256776E+00, 9.6886453773E-01],
	[4.0755000000E+04, 3.5274555559E+01, 5.2054945832E+00, 1.7035021976E+01, 3.5822219848E+00, 9.6887798230E-01],
	[4.0760000000E+04, 3.5282113110E+01, 5.2055296548E+00, 1.7041845871E+01, 3.5826181934E+00, 9.6889142029E-01],
	[4.0765000000E+04, 3.5289671352E+01, 5.2055647223E+00, 1.7048671661E+01, 3.5830143033E+00, 9.6890485168E-01],
	[4.0770000000E+04, 3.5297230287E+01, 5.2055997858E+00, 1.7055499345E+01, 3.5834103147E+00, 9.6891827650E-01],
	[4.0775000000E+04, 3.5304789913E+01, 5.2056348452E+00, 1.7062328925E+01, 3.5838062275E+00, 9.6893169474E-01],
	[4.0780000000E+04, 3.5312350231E+01, 5.2056699005E+00, 1.7069160401E+01, 3.5842020416E+00, 9.6894510640E-01],
	[4.0785000000E+04, 3.5319911241E+01, 5.2057049518E+00, 1.7075993773E+01, 3.5845977573E+00, 9.6895851149E-01],
	[4.0790000000E+04, 3.5327472942E+01, 5.2057399990E+00, 1.7082829041E+01, 3.5849933744E+00, 9.6897191001E-01],
	[4.0795000000E+04, 3.5335035336E+01, 5.2057750421E+00, 1.7089666206E+01, 3.5853888930E+00, 9.6898530196E-01],
	[4.0800000000E+04, 3.5342598421E+01, 5.2058100812E+00, 1.7096505268E+01, 3.5857843131E+00, 9.6899868736E-01],
	[4.0805000000E+04, 3.5350162197E+01, 5.2058451163E+00, 1.7103346227E+01, 3.5861796348E+00, 9.6901206619E-01],
	[4.0810000000E+04, 3.5357726666E+01, 5.2058801473E+00, 1.7110189084E+01, 3.5865748580E+00, 9.6902543847E-01],
	[4.0815000000E+04, 3.5365291826E+01, 5.2059151742E+00, 1.7117033838E+01, 3.5869699827E+00, 9.6903880420E-01],
	[4.0820000000E+04, 3.5372857678E+01, 5.2059501970E+00, 1.7123880490E+01, 3.5873650091E+00, 9.6905216338E-01],
	[4.0825000000E+04, 3.5380424221E+01, 5.2059852159E+00, 1.7130729041E+01, 3.5877599371E+00, 9.6906551602E-01],
	[4.0830000000E+04, 3.5387991456E+01, 5.2060202306E+00, 1.7137579490E+01, 3.5881547667E+00, 9.6907886211E-01],
	[4.0835000000E+04, 3.5395559383E+01, 5.2060552413E+00, 1.7144431839E+01, 3.5885494979E+00, 9.6909220167E-01],
	[4.0840000000E+04, 3.5403128001E+01, 5.2060902480E+00, 1.7151286086E+01, 3.5889441308E+00, 9.6910553469E-01],
	[4.0845000000E+04, 3.5410697310E+01, 5.2061252506E+00, 1.7158142234E+01, 3.5893386655E+00, 9.6911886118E-01],
	[4.0850000000E+04, 3.5418267312E+01, 5.2061602491E+00, 1.7165000281E+01, 3.5897331018E+00, 9.6913218114E-01],
	[4.0855000000E+04, 3.5425838004E+01, 5.2061952436E+00, 1.7171860228E+01, 3.5901274399E+00, 9.6914549458E-01],
	[4.0860000000E+04, 3.5433409388E+01, 5.2062302341E+00, 1.7178722076E+01, 3.5905216797E+00, 9.6915880149E-01],
	[4.0865000000E+04, 3.5440981464E+01, 5.2062652205E+00, 1.7185585824E+01, 3.5909158213E+00, 9.6917210189E-01],
	[4.0870000000E+04, 3.5448554231E+01, 5.2063002029E+00, 1.7192451473E+01, 3.5913098647E+00, 9.6918539577E-01],
	[4.0875000000E+04, 3.5456127689E+01, 5.2063351812E+00, 1.7199319024E+01, 3.5917038099E+00, 9.6919868315E-01],
	[4.0880000000E+04, 3.5463701839E+01, 5.2063701555E+00, 1.7206188477E+01, 3.5920976569E+00, 9.6921196401E-01],
	[4.0885000000E+04, 3.5471276680E+01, 5.2064051257E+00, 1.7213059831E+01, 3.5924914058E+00, 9.6922523837E-01],
	[4.0890000000E+04, 3.5478852213E+01, 5.2064400919E+00, 1.7219933087E+01, 3.5928850565E+00, 9.6923850623E-01],
	[4.0895000000E+04, 3.5486428437E+01, 5.2064750541E+00, 1.7226808246E+01, 3.5932786092E+00, 9.6925176759E-01],
	[4.0900000000E+04, 3.5494005352E+01, 5.2065100122E+00, 1.7233685308E+01, 3.5936720638E+00, 9.6926502246E-01],
	[4.0905000000E+04, 3.5501582958E+01, 5.2065449663E+00, 1.7240564273E+01, 3.5940654203E+00, 9.6927827084E-01],
	[4.0910000000E+04, 3.5509161256E+01, 5.2065799163E+00, 1.7247445141E+01, 3.5944586787E+00, 9.6929151272E-01],
	[4.0915000000E+04, 3.5516740245E+01, 5.2066148623E+00, 1.7254327913E+01, 3.5948518392E+00, 9.6930474813E-01],
	[4.0920000000E+04, 3.5524319925E+01, 5.2066498043E+00, 1.7261212589E+01, 3.5952449016E+00, 9.6931797705E-01],
	[4.0925000000E+04, 3.5531900296E+01, 5.2066847422E+00, 1.7268099169E+01, 3.5956378660E+00, 9.6933119950E-01],
	[4.0930000000E+04, 3.5539481359E+01, 5.2067196761E+00, 1.7274987653E+01, 3.5960307325E+00, 9.6934441547E-01],
	[4.0935000000E+04, 3.5547063112E+01, 5.2067546060E+00, 1.7281878043E+01, 3.5964235011E+00, 9.6935762497E-01],
	[4.0940000000E+04, 3.5554645557E+01, 5.2067895318E+00, 1.7288770337E+01, 3.5968161717E+00, 9.6937082801E-01],
	[4.0945000000E+04, 3.5562228693E+01, 5.2068244536E+00, 1.7295664537E+01, 3.5972087444E+00, 9.6938402458E-01],
	[4.0950000000E+04, 3.5569812520E+01, 5.2068593714E+00, 1.7302560643E+01, 3.5976012192E+00, 9.6939721469E-01],
	[4.0955000000E+04, 3.5577397038E+01, 5.2068942851E+00, 1.7309458655E+01, 3.5979935962E+00, 9.6941039834E-01],
	[4.0960000000E+04, 3.5584982247E+01, 5.2069291949E+00, 1.7316358573E+01, 3.5983858753E+00, 9.6942357554E-01],
	[4.0965000000E+04, 3.5592568147E+01, 5.2069641006E+00, 1.7323260397E+01, 3.5987780566E+00, 9.6943674628E-01],
	[4.0970000000E+04, 3.5600154738E+01, 5.2069990022E+00, 1.7330164129E+01, 3.5991701401E+00, 9.6944991059E-01],
	[4.0975000000E+04, 3.5607742020E+01, 5.2070338999E+00, 1.7337069767E+01, 3.5995621258E+00, 9.6946306844E-01],
	[4.0980000000E+04, 3.5615329993E+01, 5.2070687935E+00, 1.7343977314E+01, 3.5999540137E+00, 9.6947621986E-01],
	[4.0985000000E+04, 3.5622918657E+01, 5.2071036831E+00, 1.7350886768E+01, 3.6003458040E+00, 9.6948936484E-01],
	[4.0990000000E+04, 3.5630508012E+01, 5.2071385686E+00, 1.7357798130E+01, 3.6007374964E+00, 9.6950250338E-01],
	[4.0995000000E+04, 3.5638098057E+01, 5.2071734502E+00, 1.7364711400E+01, 3.6011290912E+00, 9.6951563550E-01],
	[4.1000000000E+04, 3.5645688794E+01, 5.2072083277E+00, 1.7371626579E+01, 3.6015205883E+00, 9.6952876119E-01],
	[4.1005000000E+04, 3.5653280221E+01, 5.2072432012E+00, 1.7378543667E+01, 3.6019119878E+00, 9.6954188045E-01],
	[4.1010000000E+04, 3.5660872340E+01, 5.2072780707E+00, 1.7385462664E+01, 3.6023032896E+00, 9.6955499329E-01],
	[4.1015000000E+04, 3.5668465149E+01, 5.2073129362E+00, 1.7392383571E+01, 3.6026944938E+00, 9.6956809972E-01],
	[4.1020000000E+04, 3.5676058649E+01, 5.2073477976E+00, 1.7399306388E+01, 3.6030856004E+00, 9.6958119973E-01],
	[4.1025000000E+04, 3.5683652839E+01, 5.2073826551E+00, 1.7406231114E+01, 3.6034766094E+00, 9.6959429334E-01],
	[4.1030000000E+04, 3.5691247721E+01, 5.2074175085E+00, 1.7413157752E+01, 3.6038675208E+00, 9.6960738053E-01],
	[4.1035000000E+04, 3.5698843293E+01, 5.2074523579E+00, 1.7420086299E+01, 3.6042583348E+00, 9.6962046133E-01],
	[4.1040000000E+04, 3.5706439556E+01, 5.2074872033E+00, 1.7427016758E+01, 3.6046490512E+00, 9.6963353572E-01],
	[4.1045000000E+04, 3.5714036509E+01, 5.2075220447E+00, 1.7433949128E+01, 3.6050396701E+00, 9.6964660371E-01],
	[4.1050000000E+04, 3.5721634153E+01, 5.2075568820E+00, 1.7440883410E+01, 3.6054301915E+00, 9.6965966532E-01],
	[4.1055000000E+04, 3.5729232488E+01, 5.2075917154E+00, 1.7447819604E+01, 3.6058206154E+00, 9.6967272053E-01],
	[4.1060000000E+04, 3.5736831514E+01, 5.2076265448E+00, 1.7454757710E+01, 3.6062109420E+00, 9.6968576935E-01],
	[4.1065000000E+04, 3.5744431230E+01, 5.2076613701E+00, 1.7461697728E+01, 3.6066011711E+00, 9.6969881179E-01],
	[4.1070000000E+04, 3.5752031636E+01, 5.2076961914E+00, 1.7468639659E+01, 3.6069913028E+00, 9.6971184785E-01],
	[4.1075000000E+04, 3.5759632733E+01, 5.2077310088E+00, 1.7475583503E+01, 3.6073813371E+00, 9.6972487754E-01],
	[4.1080000000E+04, 3.5767234521E+01, 5.2077658221E+00, 1.7482529261E+01, 3.6077712741E+00, 9.6973790085E-01],
	[4.1085000000E+04, 3.5774836999E+01, 5.2078006314E+00, 1.7489476932E+01, 3.6081611138E+00, 9.6975091779E-01],
	[4.1090000000E+04, 3.5782440168E+01, 5.2078354367E+00, 1.7496426517E+01, 3.6085508561E+00, 9.6976392836E-01],
	[4.1095000000E+04, 3.5790044027E+01, 5.2078702381E+00, 1.7503378016E+01, 3.6089405011E+00, 9.6977693257E-01],
	[4.1100000000E+04, 3.5797648576E+01, 5.2079050354E+00, 1.7510331430E+01, 3.6093300489E+00, 9.6978993042E-01],
	[4.1105000000E+04, 3.5805253816E+01, 5.2079398287E+00, 1.7517286759E+01, 3.6097194994E+00, 9.6980292192E-01],
	[4.1110000000E+04, 3.5812859747E+01, 5.2079746180E+00, 1.7524244002E+01, 3.6101088527E+00, 9.6981590706E-01],
	[4.1115000000E+04, 3.5820466367E+01, 5.2080094033E+00, 1.7531203162E+01, 3.6104981088E+00, 9.6982888584E-01],
	[4.1120000000E+04, 3.5828073679E+01, 5.2080441846E+00, 1.7538164236E+01, 3.6108872676E+00, 9.6984185829E-01],
	[4.1125000000E+04, 3.5835681680E+01, 5.2080789620E+00, 1.7545127227E+01, 3.6112763293E+00, 9.6985482439E-01],
	[4.1130000000E+04, 3.5843290372E+01, 5.2081137353E+00, 1.7552092134E+01, 3.6116652939E+00, 9.6986778415E-01],
	[4.1135000000E+04, 3.5850899754E+01, 5.2081485046E+00, 1.7559058958E+01, 3.6120541613E+00, 9.6988073757E-01],
	[4.1140000000E+04, 3.5858509826E+01, 5.2081832700E+00, 1.7566027699E+01, 3.6124429316E+00, 9.6989368466E-01],
	[4.1145000000E+04, 3.5866120589E+01, 5.2082180313E+00, 1.7572998357E+01, 3.6128316048E+00, 9.6990662542E-01],
	[4.1150000000E+04, 3.5873732042E+01, 5.2082527887E+00, 1.7579970932E+01, 3.6132201810E+00, 9.6991955985E-01],
	[4.1155000000E+04, 3.5881344185E+01, 5.2082875420E+00, 1.7586945425E+01, 3.6136086601E+00, 9.6993248796E-01],
	[4.1160000000E+04, 3.5888957018E+01, 5.2083222914E+00, 1.7593921836E+01, 3.6139970422E+00, 9.6994540974E-01],
	[4.1165000000E+04, 3.5896579484E+01, 5.2083581416E+00, 1.7600900166E+01, 3.6143859499E+00, 9.6995832522E-01],
	[4.1170000000E+04, 3.5904210740E+01, 5.2083949877E+00, 1.7607880414E+01, 3.6147753246E+00, 9.6997123437E-01],
	[4.1175000000E+04, 3.5911842690E+01, 5.2084318296E+00, 1.7614862581E+01, 3.6151646026E+00, 9.6998413722E-01],
	[4.1180000000E+04, 3.5919475336E+01, 5.2084686672E+00, 1.7621846667E+01, 3.6155537839E+00, 9.6999703376E-01],
	[4.1185000000E+04, 3.5927108677E+01, 5.2085055006E+00, 1.7628832673E+01, 3.6159428686E+00, 9.7000992400E-01],
	[4.1190000000E+04, 3.5934742713E+01, 5.2085423299E+00, 1.7635820598E+01, 3.6163318566E+00, 9.7002280794E-01],
	[4.1195000000E+04, 3.5942377445E+01, 5.2085791549E+00, 1.7642810444E+01, 3.6167207481E+00, 9.7003568558E-01],
	[4.1200000000E+04, 3.5950012871E+01, 5.2086159757E+00, 1.7649802210E+01, 3.6171095429E+00, 9.7004855692E-01],
	[4.1205000000E+04, 3.5957648993E+01, 5.2086527923E+00, 1.7656795897E+01, 3.6174982412E+00, 9.7006142198E-01],
	[4.1210000000E+04, 3.5965285810E+01, 5.2086896047E+00, 1.7663791505E+01, 3.6178868429E+00, 9.7007428075E-01],
	[4.1215000000E+04, 3.5972923322E+01, 5.2087264129E+00, 1.7670789034E+01, 3.6182753481E+00, 9.7008713324E-01],
	[4.1220000000E+04, 3.5980561529E+01, 5.2087632169E+00, 1.7677788485E+01, 3.6186637568E+00, 9.7009997944E-01],
	[4.1225000000E+04, 3.5988200431E+01, 5.2088000167E+00, 1.7684789857E+01, 3.6190520690E+00, 9.7011281937E-01],
	[4.1230000000E+04, 3.5995840029E+01, 5.2088368122E+00, 1.7691793152E+01, 3.6194402848E+00, 9.7012565302E-01],
	[4.1235000000E+04, 3.6003480321E+01, 5.2088736036E+00, 1.7698798369E+01, 3.6198284041E+00, 9.7013848041E-01],
	[4.1240000000E+04, 3.6011121309E+01, 5.2089103908E+00, 1.7705805509E+01, 3.6202164270E+00, 9.7015130153E-01],
	[4.1245000000E+04, 3.6018762991E+01, 5.2089471738E+00, 1.7712814572E+01, 3.6206043534E+00, 9.7016411638E-01],
	[4.1250000000E+04, 3.6026405368E+01, 5.2089839525E+00, 1.7719825559E+01, 3.6209921835E+00, 9.7017692497E-01],
	[4.1255000000E+04, 3.6034048441E+01, 5.2090207271E+00, 1.7726838469E+01, 3.6213799172E+00, 9.7018972731E-01],
	[4.1260000000E+04, 3.6041692208E+01, 5.2090574975E+00, 1.7733853302E+01, 3.6217675546E+00, 9.7020252339E-01],
	[4.1265000000E+04, 3.6049336670E+01, 5.2090942637E+00, 1.7740870061E+01, 3.6221550957E+00, 9.7021531322E-01],
	[4.1270000000E+04, 3.6056981827E+01, 5.2091310257E+00, 1.7747888743E+01, 3.6225425404E+00, 9.7022809681E-01],
	[4.1275000000E+04, 3.6064627679E+01, 5.2091677835E+00, 1.7754909351E+01, 3.6229298889E+00, 9.7024087415E-01],
	[4.1280000000E+04, 3.6072274226E+01, 5.2092045371E+00, 1.7761931884E+01, 3.6233171411E+00, 9.7025364525E-01],
	[4.1285000000E+04, 3.6079921467E+01, 5.2092412865E+00, 1.7768956342E+01, 3.6237042971E+00, 9.7026641011E-01],
	[4.1290000000E+04, 3.6087569404E+01, 5.2092780317E+00, 1.7775982725E+01, 3.6240913568E+00, 9.7027916874E-01],
	[4.1295000000E+04, 3.6095218035E+01, 5.2093147727E+00, 1.7783011035E+01, 3.6244783203E+00, 9.7029192114E-01],
	[4.1300000000E+04, 3.6102867361E+01, 5.2093515096E+00, 1.7790041271E+01, 3.6248651877E+00, 9.7030466731E-01],
	[4.1305000000E+04, 3.6110517381E+01, 5.2093882422E+00, 1.7797073434E+01, 3.6252519589E+00, 9.7031740725E-01],
	[4.1310000000E+04, 3.6118168097E+01, 5.2094249707E+00, 1.7804107523E+01, 3.6256386340E+00, 9.7033014098E-01],
	[4.1315000000E+04, 3.6125819507E+01, 5.2094616949E+00, 1.7811143540E+01, 3.6260252129E+00, 9.7034286849E-01],
	[4.1320000000E+04, 3.6133471612E+01, 5.2094984150E+00, 1.7818181484E+01, 3.6264116957E+00, 9.7035558978E-01],
	[4.1325000000E+04, 3.6141124411E+01, 5.2095351309E+00, 1.7825221356E+01, 3.6267980825E+00, 9.7036830487E-01],
	[4.1330000000E+04, 3.6148777905E+01, 5.2095718427E+00, 1.7832263156E+01, 3.6271843732E+00, 9.7038101374E-01],
	[4.1335000000E+04, 3.6156432094E+01, 5.2096085502E+00, 1.7839306884E+01, 3.6275705678E+00, 9.7039371641E-01],
	[4.1340000000E+04, 3.6164086977E+01, 5.2096452536E+00, 1.7846352541E+01, 3.6279566665E+00, 9.7040641288E-01],
	[4.1345000000E+04, 3.6171742555E+01, 5.2096819527E+00, 1.7853400127E+01, 3.6283426691E+00, 9.7041910316E-01],
	[4.1350000000E+04, 3.6179398828E+01, 5.2097186477E+00, 1.7860449642E+01, 3.6287285758E+00, 9.7043178723E-01],
	[4.1355000000E+04, 3.6187055795E+01, 5.2097553386E+00, 1.7867501087E+01, 3.6291143865E+00, 9.7044446512E-01],
	[4.1360000000E+04, 3.6194713456E+01, 5.2097920252E+00, 1.7874554461E+01, 3.6295001013E+00, 9.7045713682E-01],
	[4.1365000000E+04, 3.6202371812E+01, 5.2098287077E+00, 1.7881609766E+01, 3.6298857202E+00, 9.7046980233E-01],
	[4.1370000000E+04, 3.6210030862E+01, 5.2098653860E+00, 1.7888667001E+01, 3.6302712431E+00, 9.7048246167E-01],
	[4.1375000000E+04, 3.6217690607E+01, 5.2099020601E+00, 1.7895726166E+01, 3.6306566702E+00, 9.7049511482E-01],
	[4.1380000000E+04, 3.6225351047E+01, 5.2099387300E+00, 1.7902787263E+01, 3.6310420014E+00, 9.7050776180E-01],
	[4.1385000000E+04, 3.6233012180E+01, 5.2099753958E+00, 1.7909850291E+01, 3.6314272368E+00, 9.7052040261E-01],
	[4.1390000000E+04, 3.6240674008E+01, 5.2100120574E+00, 1.7916915250E+01, 3.6318123764E+00, 9.7053303725E-01],
	[4.1395000000E+04, 3.6248336531E+01, 5.2100487148E+00, 1.7923982142E+01, 3.6321974202E+00, 9.7054566573E-01],
	[4.1400000000E+04, 3.6255999748E+01, 5.2100853681E+00, 1.7931050965E+01, 3.6325823682E+00, 9.7055828805E-01],
	[4.1405000000E+04, 3.6263663659E+01, 5.2101220172E+00, 1.7938121721E+01, 3.6329672205E+00, 9.7057090420E-01],
	[4.1410000000E+04, 3.6271328264E+01, 5.2101586621E+00, 1.7945194410E+01, 3.6333519770E+00, 9.7058351420E-01],
	[4.1415000000E+04, 3.6278993564E+01, 5.2101953029E+00, 1.7952269032E+01, 3.6337366378E+00, 9.7059611805E-01],
	[4.1420000000E+04, 3.6286659558E+01, 5.2102319395E+00, 1.7959345587E+01, 3.6341212030E+00, 9.7060871576E-01],
	[4.1425000000E+04, 3.6294326246E+01, 5.2102685719E+00, 1.7966424076E+01, 3.6345056724E+00, 9.7062130731E-01],
	[4.1430000000E+04, 3.6301993629E+01, 5.2103052001E+00, 1.7973504499E+01, 3.6348900462E+00, 9.7063389273E-01],
	[4.1435000000E+04, 3.6309661706E+01, 5.2103418242E+00, 1.7980586856E+01, 3.6352743244E+00, 9.7064647200E-01],
	[4.1440000000E+04, 3.6317330476E+01, 5.2103784442E+00, 1.7987671148E+01, 3.6356585070E+00, 9.7065904514E-01],
	[4.1445000000E+04, 3.6324999941E+01, 5.2104150600E+00, 1.7994757374E+01, 3.6360425940E+00, 9.7067161215E-01],
	[4.1450000000E+04, 3.6332670101E+01, 5.2104516716E+00, 1.8001845536E+01, 3.6364265854E+00, 9.7068417303E-01],
	[4.1455000000E+04, 3.6340340954E+01, 5.2104882790E+00, 1.8008935633E+01, 3.6368104812E+00, 9.7069672778E-01],
	[4.1460000000E+04, 3.6348012501E+01, 5.2105248823E+00, 1.8016027665E+01, 3.6371942815E+00, 9.7070927642E-01],
	[4.1465000000E+04, 3.6355684743E+01, 5.2105614815E+00, 1.8023121634E+01, 3.6375779864E+00, 9.7072181893E-01],
	[4.1470000000E+04, 3.6363357678E+01, 5.2105980765E+00, 1.8030217539E+01, 3.6379615957E+00, 9.7073435533E-01],
	[4.1475000000E+04, 3.6371031308E+01, 5.2106346673E+00, 1.8037315380E+01, 3.6383451096E+00, 9.7074688561E-01],
	[4.1480000000E+04, 3.6378705631E+01, 5.2106712540E+00, 1.8044415159E+01, 3.6387285280E+00, 9.7075940979E-01],
	[4.1485000000E+04, 3.6386380649E+01, 5.2107078365E+00, 1.8051516874E+01, 3.6391118510E+00, 9.7077192785E-01],
	[4.1490000000E+04, 3.6394056360E+01, 5.2107444149E+00, 1.8058620528E+01, 3.6394950786E+00, 9.7078443982E-01],
	[4.1495000000E+04, 3.6401732765E+01, 5.2107809891E+00, 1.8065726118E+01, 3.6398782108E+00, 9.7079694569E-01],
	[4.1500000000E+04, 3.6409409865E+01, 5.2108175592E+00, 1.8072833647E+01, 3.6402612476E+00, 9.7080944546E-01],
	[4.1505000000E+04, 3.6417087658E+01, 5.2108541251E+00, 1.8079943115E+01, 3.6406441892E+00, 9.7082193914E-01],
	[4.1510000000E+04, 3.6424766145E+01, 5.2108906869E+00, 1.8087054520E+01, 3.6410270353E+00, 9.7083442673E-01],
	[4.1515000000E+04, 3.6432445326E+01, 5.2109272445E+00, 1.8094167865E+01, 3.6414097862E+00, 9.7084690823E-01],
	[4.1520000000E+04, 3.6440125201E+01, 5.2109637980E+00, 1.8101283149E+01, 3.6417924418E+00, 9.7085938365E-01],
	[4.1525000000E+04, 3.6447805770E+01, 5.2110003473E+00, 1.8108400373E+01, 3.6421750021E+00, 9.7087185299E-01],
	[4.1530000000E+04, 3.6455487032E+01, 5.2110368925E+00, 1.8115519537E+01, 3.6425574672E+00, 9.7088431625E-01],
	[4.1535000000E+04, 3.6463168988E+01, 5.2110734336E+00, 1.8122640640E+01, 3.6429398371E+00, 9.7089677344E-01],
	[4.1540000000E+04, 3.6470851638E+01, 5.2111099705E+00, 1.8129763684E+01, 3.6433221118E+00, 9.7090922456E-01],
	[4.1545000000E+04, 3.6478534982E+01, 5.2111465032E+00, 1.8136888669E+01, 3.6437042912E+00, 9.7092166961E-01],
	[4.1550000000E+04, 3.6486219020E+01, 5.2111830318E+00, 1.8144015595E+01, 3.6440863756E+00, 9.7093410860E-01],
	[4.1555000000E+04, 3.6493903751E+01, 5.2112195563E+00, 1.8151144462E+01, 3.6444683648E+00, 9.7094654153E-01],
	[4.1560000000E+04, 3.6501589176E+01, 5.2112560767E+00, 1.8158275270E+01, 3.6448502588E+00, 9.7095896840E-01],
	[4.1565000000E+04, 3.6509275294E+01, 5.2112925929E+00, 1.8165408021E+01, 3.6452320578E+00, 9.7097138922E-01],
	[4.1570000000E+04, 3.6516962106E+01, 5.2113291050E+00, 1.8172542714E+01, 3.6456137617E+00, 9.7098380399E-01],
	[4.1575000000E+04, 3.6524649612E+01, 5.2113656129E+00, 1.8179679349E+01, 3.6459953706E+00, 9.7099621271E-01],
	[4.1580000000E+04, 3.6532337811E+01, 5.2114021167E+00, 1.8186817927E+01, 3.6463768844E+00, 9.7100861538E-01],
	[4.1585000000E+04, 3.6540026704E+01, 5.2114386164E+00, 1.8193958448E+01, 3.6467583032E+00, 9.7102101202E-01],
	[4.1590000000E+04, 3.6547716291E+01, 5.2114751119E+00, 1.8201100912E+01, 3.6471396270E+00, 9.7103340262E-01],
	[4.1595000000E+04, 3.6555406571E+01, 5.2115116033E+00, 1.8208245320E+01, 3.6475208558E+00, 9.7104578718E-01],
	[4.1600000000E+04, 3.6563097544E+01, 5.2115480906E+00, 1.8215391672E+01, 3.6479019896E+00, 9.7105816571E-01],
	[4.1605000000E+04, 3.6570789211E+01, 5.2115845737E+00, 1.8222539969E+01, 3.6482830286E+00, 9.7107053822E-01],
	[4.1610000000E+04, 3.6578481572E+01, 5.2116210527E+00, 1.8229690210E+01, 3.6486639726E+00, 9.7108290470E-01],
	[4.1615000000E+04, 3.6586174626E+01, 5.2116575276E+00, 1.8236842395E+01, 3.6490448217E+00, 9.7109526515E-01],
	[4.1620000000E+04, 3.6593868373E+01, 5.2116939984E+00, 1.8243996526E+01, 3.6494255760E+00, 9.7110761959E-01],
	[4.1625000000E+04, 3.6601562814E+01, 5.2117304650E+00, 1.8251152602E+01, 3.6498062354E+00, 9.7111996802E-01],
	[4.1630000000E+04, 3.6609257948E+01, 5.2117669275E+00, 1.8258310624E+01, 3.6501868000E+00, 9.7113231043E-01],
	[4.1635000000E+04, 3.6616953775E+01, 5.2118033859E+00, 1.8265470592E+01, 3.6505672697E+00, 9.7114464684E-01],
	[4.1640000000E+04, 3.6624650296E+01, 5.2118398402E+00, 1.8272632507E+01, 3.6509476447E+00, 9.7115697724E-01],
	[4.1645000000E+04, 3.6632347510E+01, 5.2118762903E+00, 1.8279796368E+01, 3.6513279249E+00, 9.7116930163E-01],
	[4.1650000000E+04, 3.6640045418E+01, 5.2119127363E+00, 1.8286962175E+01, 3.6517081104E+00, 9.7118162003E-01],
	[4.1655000000E+04, 3.6647744019E+01, 5.2119491782E+00, 1.8294129930E+01, 3.6520882011E+00, 9.7119393244E-01],
	[4.1660000000E+04, 3.6655443313E+01, 5.2119856160E+00, 1.8301299633E+01, 3.6524681972E+00, 9.7120623885E-01],
	[4.1665000000E+04, 3.6663143300E+01, 5.2120220497E+00, 1.8308471283E+01, 3.6528480985E+00, 9.7121853927E-01],
	[4.1670000000E+04, 3.6670843980E+01, 5.2120584792E+00, 1.8315644882E+01, 3.6532279052E+00, 9.7123083370E-01],
	[4.1675000000E+04, 3.6678545354E+01, 5.2120949046E+00, 1.8322820428E+01, 3.6536076172E+00, 9.7124312216E-01],
	[4.1680000000E+04, 3.6686247421E+01, 5.2121313259E+00, 1.8329997924E+01, 3.6539872346E+00, 9.7125540463E-01],
	[4.1685000000E+04, 3.6693950181E+01, 5.2121677431E+00, 1.8337177368E+01, 3.6543667574E+00, 9.7126768113E-01],
	[4.1690000000E+04, 3.6701653634E+01, 5.2122041562E+00, 1.8344358762E+01, 3.6547461856E+00, 9.7127995165E-01],
	[4.1695000000E+04, 3.6709357780E+01, 5.2122405652E+00, 1.8351542105E+01, 3.6551255193E+00, 9.7129221621E-01],
	[4.1700000000E+04, 3.6717062619E+01, 5.2122769701E+00, 1.8358727398E+01, 3.6555047584E+00, 9.7130447480E-01],
	[4.1705000000E+04, 3.6724768152E+01, 5.2123133708E+00, 1.8365914641E+01, 3.6558839030E+00, 9.7131672742E-01],
	[4.1710000000E+04, 3.6732474377E+01, 5.2123497674E+00, 1.8373103835E+01, 3.6562629531E+00, 9.7132897409E-01],
	[4.1715000000E+04, 3.6740181296E+01, 5.2123861600E+00, 1.8380294979E+01, 3.6566419087E+00, 9.7134121480E-01],
	[4.1720000000E+04, 3.6747888907E+01, 5.2124225484E+00, 1.8387488075E+01, 3.6570207698E+00, 9.7135344955E-01],
	[4.1725000000E+04, 3.6755597212E+01, 5.2124589327E+00, 1.8394683122E+01, 3.6573995365E+00, 9.7136567836E-01],
	[4.1730000000E+04, 3.6763306209E+01, 5.2124953129E+00, 1.8401880120E+01, 3.6577782088E+00, 9.7137790121E-01],
	[4.1735000000E+04, 3.6771015900E+01, 5.2125316890E+00, 1.8409079070E+01, 3.6581567867E+00, 9.7139011812E-01],
	[4.1740000000E+04, 3.6778726283E+01, 5.2125680610E+00, 1.8416279973E+01, 3.6585352702E+00, 9.7140232910E-01],
	[4.1745000000E+04, 3.6786437359E+01, 5.2126044289E+00, 1.8423482828E+01, 3.6589136594E+00, 9.7141453413E-01],
	[4.1750000000E+04, 3.6794149128E+01, 5.2126407927E+00, 1.8430687636E+01, 3.6592919542E+00, 9.7142673323E-01],
	[4.1755000000E+04, 3.6801861590E+01, 5.2126771524E+00, 1.8437894396E+01, 3.6596701547E+00, 9.7143892640E-01],
	[4.1760000000E+04, 3.6809574745E+01, 5.2127135080E+00, 1.8445103111E+01, 3.6600482610E+00, 9.7145111364E-01],
	[4.1765000000E+04, 3.6817288593E+01, 5.2127498595E+00, 1.8452313779E+01, 3.6604262729E+00, 9.7146329496E-01],
	[4.1770000000E+04, 3.6825003133E+01, 5.2127862069E+00, 1.8459526401E+01, 3.6608041906E+00, 9.7147547035E-01],
	[4.1775000000E+04, 3.6832718367E+01, 5.2128225502E+00, 1.8466740977E+01, 3.6611820140E+00, 9.7148763983E-01],
	[4.1780000000E+04, 3.6840434293E+01, 5.2128588894E+00, 1.8473957508E+01, 3.6615597433E+00, 9.7149980339E-01],
	[4.1785000000E+04, 3.6848150911E+01, 5.2128952245E+00, 1.8481175993E+01, 3.6619373783E+00, 9.7151196104E-01],
	[4.1790000000E+04, 3.6855868223E+01, 5.2129315555E+00, 1.8488396434E+01, 3.6623149192E+00, 9.7152411278E-01],
	[4.1795000000E+04, 3.6863586227E+01, 5.2129678825E+00, 1.8495618831E+01, 3.6626923659E+00, 9.7153625861E-01],
	[4.1800000000E+04, 3.6871304924E+01, 5.2130042053E+00, 1.8502843183E+01, 3.6630697185E+00, 9.7154839854E-01],
	[4.1805000000E+04, 3.6879024313E+01, 5.2130405240E+00, 1.8510069491E+01, 3.6634469770E+00, 9.7156053258E-01],
	[4.1810000000E+04, 3.6886744396E+01, 5.2130768387E+00, 1.8517297755E+01, 3.6638241414E+00, 9.7157266072E-01],
	[4.1815000000E+04, 3.6894465170E+01, 5.2131131492E+00, 1.8524527976E+01, 3.6642012118E+00, 9.7158478296E-01],
	[4.1820000000E+04, 3.6902186638E+01, 5.2131494557E+00, 1.8531760154E+01, 3.6645781880E+00, 9.7159689931E-01],
	[4.1825000000E+04, 3.6909908798E+01, 5.2131857581E+00, 1.8538994290E+01, 3.6649550703E+00, 9.7160900978E-01],
	[4.1830000000E+04, 3.6917648466E+01, 5.2132240999E+00, 1.8546230382E+01, 3.6653330345E+00, 9.7162111437E-01],
	[4.1835000000E+04, 3.6925388946E+01, 5.2132624513E+00, 1.8553468433E+01, 3.6657109130E+00, 9.7163321307E-01],
	[4.1840000000E+04, 3.6933130124E+01, 5.2133007985E+00, 1.8560708442E+01, 3.6660886977E+00, 9.7164530590E-01],
	[4.1845000000E+04, 3.6940871999E+01, 5.2133391413E+00, 1.8567950409E+01, 3.6664663888E+00, 9.7165739286E-01],
	[4.1850000000E+04, 3.6948614571E+01, 5.2133774798E+00, 1.8575194335E+01, 3.6668439862E+00, 9.7166947394E-01],
	[4.1855000000E+04, 3.6956357842E+01, 5.2134158140E+00, 1.8582440219E+01, 3.6672214900E+00, 9.7168154916E-01],
	[4.1860000000E+04, 3.6964101809E+01, 5.2134541439E+00, 1.8589688064E+01, 3.6675989001E+00, 9.7169361851E-01],
	[4.1865000000E+04, 3.6971846475E+01, 5.2134924696E+00, 1.8596937867E+01, 3.6679762167E+00, 9.7170568200E-01],
	[4.1870000000E+04, 3.6979591837E+01, 5.2135307909E+00, 1.8604189631E+01, 3.6683534396E+00, 9.7171773963E-01],
	[4.1875000000E+04, 3.6987337898E+01, 5.2135691079E+00, 1.8611443355E+01, 3.6687305690E+00, 9.7172979141E-01],
	[4.1880000000E+04, 3.6995084655E+01, 5.2136074207E+00, 1.8618699039E+01, 3.6691076049E+00, 9.7174183734E-01],
	[4.1885000000E+04, 3.7002832110E+01, 5.2136457291E+00, 1.8625956684E+01, 3.6694845473E+00, 9.7175387742E-01],
	[4.1890000000E+04, 3.7010580262E+01, 5.2136840333E+00, 1.8633216290E+01, 3.6698613961E+00, 9.7176591166E-01],
	[4.1895000000E+04, 3.7018329112E+01, 5.2137223331E+00, 1.8640477857E+01, 3.6702381515E+00, 9.7177794005E-01],
	[4.1900000000E+04, 3.7026078659E+01, 5.2137606287E+00, 1.8647741386E+01, 3.6706148134E+00, 9.7178996260E-01],
	[4.1905000000E+04, 3.7033828903E+01, 5.2137989200E+00, 1.8655006877E+01, 3.6709913819E+00, 9.7180197932E-01],
	[4.1910000000E+04, 3.7041579845E+01, 5.2138372070E+00, 1.8662274331E+01, 3.6713678570E+00, 9.7181399021E-01],
	[4.1915000000E+04, 3.7049331484E+01, 5.2138754897E+00, 1.8669543747E+01, 3.6717442386E+00, 9.7182599527E-01],
	[4.1920000000E+04, 3.7057083820E+01, 5.2139137682E+00, 1.8676815125E+01, 3.6721205269E+00, 9.7183799450E-01],
	[4.1925000000E+04, 3.7064836853E+01, 5.2139520423E+00, 1.8684088467E+01, 3.6724967219E+00, 9.7184998791E-01],
	[4.1930000000E+04, 3.7072590584E+01, 5.2139903122E+00, 1.8691363772E+01, 3.6728728235E+00, 9.7186197549E-01],
	[4.1935000000E+04, 3.7080345012E+01, 5.2140285778E+00, 1.8698641041E+01, 3.6732488318E+00, 9.7187395727E-01],
	[4.1940000000E+04, 3.7088100137E+01, 5.2140668391E+00, 1.8705920274E+01, 3.6736247468E+00, 9.7188593323E-01],
	[4.1945000000E+04, 3.7095855959E+01, 5.2141050961E+00, 1.8713201471E+01, 3.6740005685E+00, 9.7189790337E-01],
	[4.1950000000E+04, 3.7103612478E+01, 5.2141433488E+00, 1.8720484633E+01, 3.6743762970E+00, 9.7190986772E-01],
	[4.1955000000E+04, 3.7111369694E+01, 5.2141815973E+00, 1.8727769760E+01, 3.6747519323E+00, 9.7192182625E-01],
	[4.1960000000E+04, 3.7119127608E+01, 5.2142198415E+00, 1.8735056852E+01, 3.6751274743E+00, 9.7193377899E-01],
	[4.1965000000E+04, 3.7126886218E+01, 5.2142580814E+00, 1.8742345909E+01, 3.6755029232E+00, 9.7194572593E-01],
	[4.1970000000E+04, 3.7134645526E+01, 5.2142963170E+00, 1.8749636933E+01, 3.6758782789E+00, 9.7195766708E-01],
	[4.1975000000E+04, 3.7142405530E+01, 5.2143345484E+00, 1.8756929922E+01, 3.6762535414E+00, 9.7196960243E-01],
	[4.1980000000E+04, 3.7150166232E+01, 5.2143727754E+00, 1.8764224878E+01, 3.6766287108E+00, 9.7198153200E-01],
	[4.1985000000E+04, 3.7157927631E+01, 5.2144109982E+00, 1.8771521800E+01, 3.6770037871E+00, 9.7199345578E-01],
	[4.1990000000E+04, 3.7165689726E+01, 5.2144492168E+00, 1.8778820690E+01, 3.6773787704E+00, 9.7200537378E-01],
	[4.1995000000E+04, 3.7173452519E+01, 5.2144874311E+00, 1.8786121546E+01, 3.6777536605E+00, 9.7201728600E-01],
	[4.2000000000E+04, 3.7181216008E+01, 5.2145256411E+00, 1.8793424371E+01, 3.6781284576E+00, 9.7202919244E-01],
	[4.2005000000E+04, 3.7188980194E+01, 5.2145638468E+00, 1.8800729163E+01, 3.6785031617E+00, 9.7204109312E-01],
	[4.2010000000E+04, 3.7196745078E+01, 5.2146020483E+00, 1.8808035923E+01, 3.6788777728E+00, 9.7205298802E-01],
	[4.2015000000E+04, 3.7204510658E+01, 5.2146402454E+00, 1.8815344652E+01, 3.6792522909E+00, 9.7206487716E-01],
	[4.2020000000E+04, 3.7212276935E+01, 5.2146784384E+00, 1.8822655349E+01, 3.6796267160E+00, 9.7207676053E-01],
	[4.2025000000E+04, 3.7220043908E+01, 5.2147166270E+00, 1.8829968015E+01, 3.6800010482E+00, 9.7208863815E-01],
	[4.2030000000E+04, 3.7227811579E+01, 5.2147548114E+00, 1.8837282651E+01, 3.6803752875E+00, 9.7210051001E-01],
	[4.2035000000E+04, 3.7235579946E+01, 5.2147929916E+00, 1.8844599257E+01, 3.6807494338E+00, 9.7211237611E-01],
	[4.2040000000E+04, 3.7243349010E+01, 5.2148311675E+00, 1.8851917832E+01, 3.6811234873E+00, 9.7212423647E-01],
	[4.2045000000E+04, 3.7251118771E+01, 5.2148693391E+00, 1.8859238378E+01, 3.6814974480E+00, 9.7213609108E-01],
	[4.2050000000E+04, 3.7258889229E+01, 5.2149075064E+00, 1.8866560894E+01, 3.6818713158E+00, 9.7214793994E-01],
	[4.2055000000E+04, 3.7266660383E+01, 5.2149456695E+00, 1.8873885381E+01, 3.6822450907E+00, 9.7215978307E-01],
	[4.2060000000E+04, 3.7274432234E+01, 5.2149838284E+00, 1.8881211839E+01, 3.6826187729E+00, 9.7217162045E-01],
	[4.2065000000E+04, 3.7282204782E+01, 5.2150219830E+00, 1.8888540268E+01, 3.6829923623E+00, 9.7218345210E-01],
	[4.2070000000E+04, 3.7289978026E+01, 5.2150601333E+00, 1.8895870669E+01, 3.6833658590E+00, 9.7219527802E-01],
	[4.2075000000E+04, 3.7297751967E+01, 5.2150982794E+00, 1.8903203042E+01, 3.6837392629E+00, 9.7220709821E-01],
	[4.2080000000E+04, 3.7305526604E+01, 5.2151364212E+00, 1.8910537388E+01, 3.6841125740E+00, 9.7221891268E-01],
	[4.2085000000E+04, 3.7313301938E+01, 5.2151745588E+00, 1.8917873706E+01, 3.6844857925E+00, 9.7223072142E-01],
	[4.2090000000E+04, 3.7321077969E+01, 5.2152126921E+00, 1.8925211997E+01, 3.6848589184E+00, 9.7224252445E-01],
	[4.2095000000E+04, 3.7328854696E+01, 5.2152508211E+00, 1.8932552261E+01, 3.6852319515E+00, 9.7225432176E-01],
	[4.2100000000E+04, 3.7336632120E+01, 5.2152889459E+00, 1.8939894498E+01, 3.6856048921E+00, 9.7226611335E-01],
	[4.2105000000E+04, 3.7344410240E+01, 5.2153270665E+00, 1.8947238710E+01, 3.6859777400E+00, 9.7227789924E-01],
	[4.2110000000E+04, 3.7352189057E+01, 5.2153651828E+00, 1.8954584895E+01, 3.6863504953E+00, 9.7228967942E-01],
	[4.2115000000E+04, 3.7359968570E+01, 5.2154032949E+00, 1.8961933055E+01, 3.6867231581E+00, 9.7230145390E-01],
	[4.2120000000E+04, 3.7367748779E+01, 5.2154414027E+00, 1.8969283189E+01, 3.6870957283E+00, 9.7231322267E-01],
	[4.2125000000E+04, 3.7375529685E+01, 5.2154795063E+00, 1.8976635298E+01, 3.6874682060E+00, 9.7232498575E-01],
	[4.2130000000E+04, 3.7383311288E+01, 5.2155176056E+00, 1.8983989383E+01, 3.6878405912E+00, 9.7233674314E-01],
	[4.2135000000E+04, 3.7391093586E+01, 5.2155557007E+00, 1.8991345443E+01, 3.6882128838E+00, 9.7234849483E-01],
	[4.2140000000E+04, 3.7398876582E+01, 5.2155937916E+00, 1.8998703479E+01, 3.6885850841E+00, 9.7236024084E-01],
	[4.2145000000E+04, 3.7406660273E+01, 5.2156318782E+00, 1.9006063491E+01, 3.6889571918E+00, 9.7237198116E-01],
	[4.2150000000E+04, 3.7414444661E+01, 5.2156699606E+00, 1.9013425480E+01, 3.6893292072E+00, 9.7238371581E-01],
	[4.2155000000E+04, 3.7422229745E+01, 5.2157080387E+00, 1.9020789445E+01, 3.6897011301E+00, 9.7239544477E-01],
	[4.2160000000E+04, 3.7430015525E+01, 5.2157461126E+00, 1.9028155387E+01, 3.6900729607E+00, 9.7240716806E-01],
	[4.2165000000E+04, 3.7437802002E+01, 5.2157841822E+00, 1.9035523307E+01, 3.6904446989E+00, 9.7241888567E-01],
	[4.2170000000E+04, 3.7445589175E+01, 5.2158222477E+00, 1.9042893204E+01, 3.6908163447E+00, 9.7243059762E-01],
	[4.2175000000E+04, 3.7453377044E+01, 5.2158603088E+00, 1.9050265079E+01, 3.6911878982E+00, 9.7244230390E-01],
	[4.2180000000E+04, 3.7461165609E+01, 5.2158983658E+00, 1.9057638932E+01, 3.6915593594E+00, 9.7245400452E-01],
	[4.2185000000E+04, 3.7468954870E+01, 5.2159364185E+00, 1.9065014764E+01, 3.6919307284E+00, 9.7246569947E-01],
	[4.2190000000E+04, 3.7476744828E+01, 5.2159744670E+00, 1.9072392575E+01, 3.6923020051E+00, 9.7247738878E-01],
	[4.2195000000E+04, 3.7484535481E+01, 5.2160125112E+00, 1.9079772365E+01, 3.6926731895E+00, 9.7248907242E-01],
	[4.2200000000E+04, 3.7492326831E+01, 5.2160505512E+00, 1.9087154134E+01, 3.6930442817E+00, 9.7250075042E-01],
	[4.2205000000E+04, 3.7500118877E+01, 5.2160885870E+00, 1.9094537883E+01, 3.6934152817E+00, 9.7251242277E-01],
	[4.2210000000E+04, 3.7507911619E+01, 5.2161266186E+00, 1.9101923611E+01, 3.6937861896E+00, 9.7252408948E-01],
	[4.2215000000E+04, 3.7515705057E+01, 5.2161646459E+00, 1.9109311320E+01, 3.6941570053E+00, 9.7253575054E-01],
	[4.2220000000E+04, 3.7523499191E+01, 5.2162026690E+00, 1.9116701010E+01, 3.6945277288E+00, 9.7254740597E-01],
	[4.2225000000E+04, 3.7531294021E+01, 5.2162406879E+00, 1.9124092680E+01, 3.6948983602E+00, 9.7255905576E-01],
	[4.2230000000E+04, 3.7539089547E+01, 5.2162787026E+00, 1.9131486332E+01, 3.6952688996E+00, 9.7257069992E-01],
	[4.2235000000E+04, 3.7546885769E+01, 5.2163167130E+00, 1.9138881965E+01, 3.6956393468E+00, 9.7258233845E-01],
	[4.2240000000E+04, 3.7554682687E+01, 5.2163547192E+00, 1.9146279580E+01, 3.6960097020E+00, 9.7259397136E-01],
	[4.2245000000E+04, 3.7562480301E+01, 5.2163927212E+00, 1.9153679177E+01, 3.6963799652E+00, 9.7260559864E-01],
	[4.2250000000E+04, 3.7570278611E+01, 5.2164307190E+00, 1.9161080756E+01, 3.6967501364E+00, 9.7261722031E-01],
	[4.2255000000E+04, 3.7578077617E+01, 5.2164687125E+00, 1.9168484318E+01, 3.6971202155E+00, 9.7262883635E-01],
	[4.2260000000E+04, 3.7585877318E+01, 5.2165067019E+00, 1.9175889863E+01, 3.6974902027E+00, 9.7264044679E-01],
	[4.2265000000E+04, 3.7593677716E+01, 5.2165446870E+00, 1.9183297391E+01, 3.6978600980E+00, 9.7265205161E-01],
	[4.2270000000E+04, 3.7601478809E+01, 5.2165826679E+00, 1.9190706903E+01, 3.6982299013E+00, 9.7266365083E-01],
	[4.2275000000E+04, 3.7609280598E+01, 5.2166206446E+00, 1.9198118398E+01, 3.6985996127E+00, 9.7267524444E-01],
	[4.2280000000E+04, 3.7617083083E+01, 5.2166586170E+00, 1.9205531878E+01, 3.6989692322E+00, 9.7268683245E-01],
	[4.2285000000E+04, 3.7624886263E+01, 5.2166965853E+00, 1.9212947342E+01, 3.6993387598E+00, 9.7269841487E-01],
	[4.2290000000E+04, 3.7632690140E+01, 5.2167345493E+00, 1.9220364790E+01, 3.6997081956E+00, 9.7270999169E-01],
	[4.2295000000E+04, 3.7640494712E+01, 5.2167725091E+00, 1.9227784224E+01, 3.7000775396E+00, 9.7272156291E-01],
	[4.2300000000E+04, 3.7648299980E+01, 5.2168104648E+00, 1.9235205643E+01, 3.7004467918E+00, 9.7273312855E-01],
	[4.2305000000E+04, 3.7656105943E+01, 5.2168484162E+00, 1.9242629048E+01, 3.7008159522E+00, 9.7274468861E-01],
	[4.2310000000E+04, 3.7663912602E+01, 5.2168863634E+00, 1.9250054438E+01, 3.7011850208E+00, 9.7275624308E-01],
	[4.2315000000E+04, 3.7671719957E+01, 5.2169243063E+00, 1.9257481815E+01, 3.7015539977E+00, 9.7276779197E-01],
	[4.2320000000E+04, 3.7679528007E+01, 5.2169622451E+00, 1.9264911178E+01, 3.7019228828E+00, 9.7277933529E-01],
	[4.2325000000E+04, 3.7687336753E+01, 5.2170001797E+00, 1.9272342528E+01, 3.7022916763E+00, 9.7279087303E-01],
	[4.2330000000E+04, 3.7695146195E+01, 5.2170381101E+00, 1.9279775865E+01, 3.7026603780E+00, 9.7280240520E-01],
	[4.2335000000E+04, 3.7702956332E+01, 5.2170760362E+00, 1.9287211190E+01, 3.7030289882E+00, 9.7281393180E-01],
	[4.2340000000E+04, 3.7710767165E+01, 5.2171139582E+00, 1.9294648502E+01, 3.7033975066E+00, 9.7282545284E-01],
	[4.2345000000E+04, 3.7718578693E+01, 5.2171518760E+00, 1.9302087802E+01, 3.7037659335E+00, 9.7283696832E-01],
	[4.2350000000E+04, 3.7726390917E+01, 5.2171897895E+00, 1.9309529090E+01, 3.7041342687E+00, 9.7284847825E-01],
	[4.2355000000E+04, 3.7734203836E+01, 5.2172276989E+00, 1.9316972367E+01, 3.7045025124E+00, 9.7285998261E-01],
	[4.2360000000E+04, 3.7742017451E+01, 5.2172656040E+00, 1.9324417633E+01, 3.7048706645E+00, 9.7287148143E-01],
	[4.2365000000E+04, 3.7749831761E+01, 5.2173035050E+00, 1.9331864888E+01, 3.7052387251E+00, 9.7288297470E-01],
	[4.2370000000E+04, 3.7757646767E+01, 5.2173414017E+00, 1.9339314132E+01, 3.7056066942E+00, 9.7289446242E-01],
	[4.2375000000E+04, 3.7765462468E+01, 5.2173792943E+00, 1.9346765366E+01, 3.7059745717E+00, 9.7290594459E-01],
	[4.2380000000E+04, 3.7773278864E+01, 5.2174171827E+00, 1.9354218590E+01, 3.7063423578E+00, 9.7291742123E-01],
	[4.2385000000E+04, 3.7781095956E+01, 5.2174550669E+00, 1.9361673805E+01, 3.7067100525E+00, 9.7292889234E-01],
	[4.2390000000E+04, 3.7788913743E+01, 5.2174929468E+00, 1.9369131010E+01, 3.7070776557E+00, 9.7294035790E-01],
	[4.2395000000E+04, 3.7796732225E+01, 5.2175308226E+00, 1.9376590206E+01, 3.7074451675E+00, 9.7295181794E-01],
	[4.2400000000E+04, 3.7804551403E+01, 5.2175686942E+00, 1.9384051393E+01, 3.7078125879E+00, 9.7296327245E-01],
	[4.2405000000E+04, 3.7812371276E+01, 5.2176065616E+00, 1.9391514572E+01, 3.7081799169E+00, 9.7297472144E-01],
	[4.2410000000E+04, 3.7820191844E+01, 5.2176444248E+00, 1.9398979743E+01, 3.7085471546E+00, 9.7298616491E-01],
	[4.2415000000E+04, 3.7828013108E+01, 5.2176822839E+00, 1.9406446906E+01, 3.7089143010E+00, 9.7299760285E-01],
	[4.2420000000E+04, 3.7835835066E+01, 5.2177201387E+00, 1.9413916061E+01, 3.7092813560E+00, 9.7300903529E-01],
	[4.2425000000E+04, 3.7843657720E+01, 5.2177579894E+00, 1.9421387209E+01, 3.7096483198E+00, 9.7302046221E-01],
	[4.2430000000E+04, 3.7851481069E+01, 5.2177958358E+00, 1.9428860350E+01, 3.7100151923E+00, 9.7303188362E-01],
	[4.2435000000E+04, 3.7859305114E+01, 5.2178336781E+00, 1.9436335484E+01, 3.7103819735E+00, 9.7304329952E-01],
	[4.2440000000E+04, 3.7867129853E+01, 5.2178715162E+00, 1.9443812611E+01, 3.7107486635E+00, 9.7305470992E-01],
	[4.2445000000E+04, 3.7874955288E+01, 5.2179093501E+00, 1.9451291733E+01, 3.7111152623E+00, 9.7306611483E-01],
	[4.2450000000E+04, 3.7882781417E+01, 5.2179471798E+00, 1.9458772849E+01, 3.7114817700E+00, 9.7307751423E-01],
	[4.2455000000E+04, 3.7890608242E+01, 5.2179850054E+00, 1.9466255959E+01, 3.7118481865E+00, 9.7308890814E-01],
	[4.2460000000E+04, 3.7898435762E+01, 5.2180228268E+00, 1.9473741065E+01, 3.7122145118E+00, 9.7310029656E-01],
	[4.2465000000E+04, 3.7906263977E+01, 5.2180606439E+00, 1.9481228165E+01, 3.7125807460E+00, 9.7311167950E-01],
	[4.2470000000E+04, 3.7914092886E+01, 5.2180984570E+00, 1.9488717260E+01, 3.7129468891E+00, 9.7312305695E-01],
	[4.2475000000E+04, 3.7921922491E+01, 5.2181362658E+00, 1.9496208352E+01, 3.7133129411E+00, 9.7313442891E-01],
	[4.2480000000E+04, 3.7929752791E+01, 5.2181740704E+00, 1.9503701439E+01, 3.7136789021E+00, 9.7314579540E-01],
	[4.2485000000E+04, 3.7937583786E+01, 5.2182118709E+00, 1.9511196522E+01, 3.7140447720E+00, 9.7315715641E-01],
	[4.2490000000E+04, 3.7945415476E+01, 5.2182496672E+00, 1.9518693602E+01, 3.7144105509E+00, 9.7316851195E-01],
	[4.2495000000E+04, 3.7953247860E+01, 5.2182874594E+00, 1.9526192679E+01, 3.7147762388E+00, 9.7317986202E-01],
	[4.2500000000E+04, 3.7961086456E+01, 5.2183259071E+00, 1.9533693753E+01, 3.7151422230E+00, 9.7319120663E-01],
	[4.2505000000E+04, 3.7968937049E+01, 5.2183657019E+00, 1.9541196825E+01, 3.7155089096E+00, 9.7320254577E-01],
	[4.2510000000E+04, 3.7976788342E+01, 5.2184054923E+00, 1.9548701894E+01, 3.7158755055E+00, 9.7321387944E-01],
	[4.2515000000E+04, 3.7984640334E+01, 5.2184452784E+00, 1.9556208961E+01, 3.7162420107E+00, 9.7322520767E-01],
	[4.2520000000E+04, 3.7992493027E+01, 5.2184850601E+00, 1.9563718027E+01, 3.7166084253E+00, 9.7323653043E-01],
	[4.2525000000E+04, 3.8000346419E+01, 5.2185248374E+00, 1.9571229091E+01, 3.7169747492E+00, 9.7324784775E-01],
	[4.2530000000E+04, 3.8008200511E+01, 5.2185646103E+00, 1.9578742155E+01, 3.7173409826E+00, 9.7325915962E-01],
	[4.2535000000E+04, 3.8016055302E+01, 5.2186043789E+00, 1.9586257217E+01, 3.7177071253E+00, 9.7327046604E-01],
	[4.2540000000E+04, 3.8023910794E+01, 5.2186441431E+00, 1.9593774279E+01, 3.7180731775E+00, 9.7328176702E-01],
	[4.2545000000E+04, 3.8031766985E+01, 5.2186839029E+00, 1.9601293341E+01, 3.7184391392E+00, 9.7329306256E-01],
	[4.2550000000E+04, 3.8039623876E+01, 5.2187236584E+00, 1.9608814403E+01, 3.7188050103E+00, 9.7330435266E-01],
	[4.2555000000E+04, 3.8047481466E+01, 5.2187634094E+00, 1.9616337465E+01, 3.7191707909E+00, 9.7331563734E-01],
	[4.2560000000E+04, 3.8055339756E+01, 5.2188031562E+00, 1.9623862528E+01, 3.7195364810E+00, 9.7332691658E-01],
	[4.2565000000E+04, 3.8063198746E+01, 5.2188428985E+00, 1.9631389592E+01, 3.7199020807E+00, 9.7333819039E-01],
	[4.2570000000E+04, 3.8071058435E+01, 5.2188826365E+00, 1.9638918657E+01, 3.7202675899E+00, 9.7334945878E-01],
	[4.2575000000E+04, 3.8078918824E+01, 5.2189223701E+00, 1.9646449724E+01, 3.7206330087E+00, 9.7336072174E-01],
	[4.2580000000E+04, 3.8086779912E+01, 5.2189620994E+00, 1.9653982793E+01, 3.7209983371E+00, 9.7337197929E-01],
	[4.2585000000E+04, 3.8094641700E+01, 5.2190018243E+00, 1.9661517864E+01, 3.7213635751E+00, 9.7338323142E-01],
	[4.2590000000E+04, 3.8102504187E+01, 5.2190415448E+00, 1.9669054938E+01, 3.7217287228E+00, 9.7339447814E-01],
	[4.2595000000E+04, 3.8110367374E+01, 5.2190812610E+00, 1.9676594014E+01, 3.7220937801E+00, 9.7340571944E-01],
	[4.2600000000E+04, 3.8118231260E+01, 5.2191209728E+00, 1.9684135093E+01, 3.7224587471E+00, 9.7341695533E-01],
	[4.2605000000E+04, 3.8126095846E+01, 5.2191606803E+00, 1.9691678176E+01, 3.7228236238E+00, 9.7342818581E-01],
	[4.2610000000E+04, 3.8133961131E+01, 5.2192003834E+00, 1.9699223263E+01, 3.7231884102E+00, 9.7343941089E-01],
	[4.2615000000E+04, 3.8141827116E+01, 5.2192400821E+00, 1.9706770353E+01, 3.7235531064E+00, 9.7345063057E-01],
	[4.2620000000E+04, 3.8149693800E+01, 5.2192797765E+00, 1.9714319448E+01, 3.7239177123E+00, 9.7346184485E-01],
	[4.2625000000E+04, 3.8157561183E+01, 5.2193194665E+00, 1.9721870547E+01, 3.7242822280E+00, 9.7347305373E-01],
	[4.2630000000E+04, 3.8165429266E+01, 5.2193591522E+00, 1.9729423651E+01, 3.7246466536E+00, 9.7348425722E-01],
	[4.2635000000E+04, 3.8173298048E+01, 5.2193988335E+00, 1.9736978760E+01, 3.7250109889E+00, 9.7349545531E-01],
	[4.2640000000E+04, 3.8181167530E+01, 5.2194385105E+00, 1.9744535875E+01, 3.7253752341E+00, 9.7350664802E-01],
	[4.2645000000E+04, 3.8189037710E+01, 5.2194781831E+00, 1.9752094995E+01, 3.7257393892E+00, 9.7351783534E-01],
	[4.2650000000E+04, 3.8196908590E+01, 5.2195178514E+00, 1.9759656122E+01, 3.7261034541E+00, 9.7352901728E-01],
	[4.2655000000E+04, 3.8204780170E+01, 5.2195575153E+00, 1.9767219255E+01, 3.7264674290E+00, 9.7354019384E-01],
	[4.2660000000E+04, 3.8212652448E+01, 5.2195971749E+00, 1.9774784394E+01, 3.7268313138E+00, 9.7355136501E-01],
	[4.2665000000E+04, 3.8220525426E+01, 5.2196368301E+00, 1.9782351541E+01, 3.7271951085E+00, 9.7356253082E-01],
	[4.2670000000E+04, 3.8228399103E+01, 5.2196764810E+00, 1.9789920694E+01, 3.7275588132E+00, 9.7357369125E-01],
	[4.2675000000E+04, 3.8236273479E+01, 5.2197161275E+00, 1.9797491855E+01, 3.7279224279E+00, 9.7358484630E-01],
	[4.2680000000E+04, 3.8244148554E+01, 5.2197557697E+00, 1.9805065024E+01, 3.7282859526E+00, 9.7359599599E-01],
	[4.2685000000E+04, 3.8252024328E+01, 5.2197954076E+00, 1.9812640202E+01, 3.7286493874E+00, 9.7360714032E-01],
	[4.2690000000E+04, 3.8259900801E+01, 5.2198350411E+00, 1.9820217387E+01, 3.7290127322E+00, 9.7361827928E-01],
	[4.2695000000E+04, 3.8267777974E+01, 5.2198746703E+00, 1.9827796581E+01, 3.7293759871E+00, 9.7362941289E-01],
	[4.2700000000E+04, 3.8275655846E+01, 5.2199142951E+00, 1.9835377785E+01, 3.7297391520E+00, 9.7364054113E-01],
	[4.2705000000E+04, 3.8283534416E+01, 5.2199539156E+00, 1.9842960997E+01, 3.7301022271E+00, 9.7365166402E-01],
	[4.2710000000E+04, 3.8291413686E+01, 5.2199935317E+00, 1.9850546220E+01, 3.7304652123E+00, 9.7366278156E-01],
	[4.2715000000E+04, 3.8299293655E+01, 5.2200331436E+00, 1.9858133452E+01, 3.7308281077E+00, 9.7367389375E-01],
	[4.2720000000E+04, 3.8307174322E+01, 5.2200727510E+00, 1.9865722694E+01, 3.7311909133E+00, 9.7368500059E-01],
	[4.2725000000E+04, 3.8315055689E+01, 5.2201123542E+00, 1.9873313947E+01, 3.7315536290E+00, 9.7369610209E-01],
	[4.2730000000E+04, 3.8322937755E+01, 5.2201519530E+00, 1.9880907210E+01, 3.7319162550E+00, 9.7370719825E-01],
	[4.2735000000E+04, 3.8330820519E+01, 5.2201915475E+00, 1.9888502485E+01, 3.7322787912E+00, 9.7371828906E-01],
	[4.2740000000E+04, 3.8338703983E+01, 5.2202311376E+00, 1.9896099771E+01, 3.7326412376E+00, 9.7372937454E-01],
	[4.2745000000E+04, 3.8346588145E+01, 5.2202707234E+00, 1.9903699069E+01, 3.7330035944E+00, 9.7374045469E-01],
	[4.2750000000E+04, 3.8354473006E+01, 5.2203103049E+00, 1.9911300379E+01, 3.7333658614E+00, 9.7375152951E-01],
	[4.2755000000E+04, 3.8362358566E+01, 5.2203498821E+00, 1.9918903701E+01, 3.7337280388E+00, 9.7376259899E-01],
	[4.2760000000E+04, 3.8370244825E+01, 5.2203894549E+00, 1.9926509035E+01, 3.7340901265E+00, 9.7377366316E-01],
	[4.2765000000E+04, 3.8378131783E+01, 5.2204290234E+00, 1.9934116383E+01, 3.7344521246E+00, 9.7378472199E-01],
	[4.2770000000E+04, 3.8386019440E+01, 5.2204685876E+00, 1.9941725744E+01, 3.7348140331E+00, 9.7379577551E-01],
	[4.2775000000E+04, 3.8393907795E+01, 5.2205081474E+00, 1.9949337118E+01, 3.7351758519E+00, 9.7380682371E-01],
	[4.2780000000E+04, 3.8401796849E+01, 5.2205477030E+00, 1.9956950506E+01, 3.7355375812E+00, 9.7381786660E-01],
	[4.2785000000E+04, 3.8409686602E+01, 5.2205872542E+00, 1.9964565908E+01, 3.7358992210E+00, 9.7382890417E-01],
	[4.2790000000E+04, 3.8417577053E+01, 5.2206268010E+00, 1.9972183324E+01, 3.7362607712E+00, 9.7383993643E-01],
	[4.2795000000E+04, 3.8425468204E+01, 5.2206663436E+00, 1.9979802755E+01, 3.7366222319E+00, 9.7385096338E-01],
	[4.2800000000E+04, 3.8433360052E+01, 5.2207058818E+00, 1.9987424201E+01, 3.7369836031E+00, 9.7386198503E-01],
	[4.2805000000E+04, 3.8441252600E+01, 5.2207454158E+00, 1.9995047662E+01, 3.7373448848E+00, 9.7387300138E-01],
	[4.2810000000E+04, 3.8449145846E+01, 5.2207849454E+00, 2.0002673139E+01, 3.7377060771E+00, 9.7388401243E-01],
	[4.2815000000E+04, 3.8457039791E+01, 5.2208244706E+00, 2.0010300631E+01, 3.7380671799E+00, 9.7389501817E-01],
	[4.2820000000E+04, 3.8464934435E+01, 5.2208639916E+00, 2.0017930140E+01, 3.7384281934E+00, 9.7390601863E-01],
	[4.2825000000E+04, 3.8472829777E+01, 5.2209035083E+00, 2.0025561665E+01, 3.7387891174E+00, 9.7391701379E-01],
	[4.2830000000E+04, 3.8480725817E+01, 5.2209430206E+00, 2.0033195207E+01, 3.7391499521E+00, 9.7392800367E-01],
	[4.2835000000E+04, 3.8488622556E+01, 5.2209825286E+00, 2.0040830766E+01, 3.7395106974E+00, 9.7393898825E-01],
	[4.2840000000E+04, 3.8496519994E+01, 5.2210220323E+00, 2.0048468342E+01, 3.7398713534E+00, 9.7394996756E-01],
	[4.2845000000E+04, 3.8504418130E+01, 5.2210615317E+00, 2.0056107936E+01, 3.7402319201E+00, 9.7396094158E-01],
	[4.2850000000E+04, 3.8512316965E+01, 5.2211010268E+00, 2.0063749547E+01, 3.7405923975E+00, 9.7397191032E-01],
	[4.2855000000E+04, 3.8520216498E+01, 5.2211405176E+00, 2.0071393177E+01, 3.7409527857E+00, 9.7398287379E-01],
	[4.2860000000E+04, 3.8528116729E+01, 5.2211800041E+00, 2.0079038826E+01, 3.7413130846E+00, 9.7399383198E-01],
	[4.2865000000E+04, 3.8536017659E+01, 5.2212194862E+00, 2.0086686493E+01, 3.7416732943E+00, 9.7400478491E-01],
	[4.2870000000E+04, 3.8543919287E+01, 5.2212589641E+00, 2.0094336180E+01, 3.7420334148E+00, 9.7401573256E-01],
	[4.2875000000E+04, 3.8551821614E+01, 5.2212984376E+00, 2.0101987885E+01, 3.7423934461E+00, 9.7402667495E-01],
	[4.2880000000E+04, 3.8559724639E+01, 5.2213379069E+00, 2.0109641611E+01, 3.7427533882E+00, 9.7403761208E-01],
	[4.2885000000E+04, 3.8567628363E+01, 5.2213773718E+00, 2.0117297356E+01, 3.7431132412E+00, 9.7404854394E-01],
	[4.2890000000E+04, 3.8575532784E+01, 5.2214168325E+00, 2.0124955122E+01, 3.7434730051E+00, 9.7405947055E-01],
	[4.2895000000E+04, 3.8583437904E+01, 5.2214562888E+00, 2.0132614909E+01, 3.7438326799E+00, 9.7407039190E-01],
	[4.2900000000E+04, 3.8591343723E+01, 5.2214957409E+00, 2.0140276716E+01, 3.7441922656E+00, 9.7408130800E-01],
	[4.2905000000E+04, 3.8599250239E+01, 5.2215351886E+00, 2.0147940544E+01, 3.7445517623E+00, 9.7409221885E-01],
	[4.2910000000E+04, 3.8607157454E+01, 5.2215746320E+00, 2.0155606394E+01, 3.7449111699E+00, 9.7410312445E-01],
	[4.2915000000E+04, 3.8615065367E+01, 5.2216140712E+00, 2.0163274266E+01, 3.7452704885E+00, 9.7411402481E-01],
	[4.2920000000E+04, 3.8622973978E+01, 5.2216535060E+00, 2.0170944160E+01, 3.7456297181E+00, 9.7412491992E-01],
	[4.2925000000E+04, 3.8630883288E+01, 5.2216929366E+00, 2.0178616076E+01, 3.7459888587E+00, 9.7413580980E-01],
	[4.2930000000E+04, 3.8638793295E+01, 5.2217323628E+00, 2.0186290015E+01, 3.7463479104E+00, 9.7414669443E-01],
	[4.2935000000E+04, 3.8646704001E+01, 5.2217717848E+00, 2.0193965977E+01, 3.7467068731E+00, 9.7415757384E-01],
	[4.2940000000E+04, 3.8654615405E+01, 5.2218112024E+00, 2.0201643962E+01, 3.7470657469E+00, 9.7416844801E-01],
	[4.2945000000E+04, 3.8662527507E+01, 5.2218506158E+00, 2.0209323970E+01, 3.7474245319E+00, 9.7417931695E-01],
	[4.2950000000E+04, 3.8670440307E+01, 5.2218900249E+00, 2.0217006003E+01, 3.7477832279E+00, 9.7419018067E-01],
	[4.2955000000E+04, 3.8678353805E+01, 5.2219294297E+00, 2.0224690059E+01, 3.7481418352E+00, 9.7420103916E-01],
	[4.2960000000E+04, 3.8686268001E+01, 5.2219688302E+00, 2.0232376141E+01, 3.7485003535E+00, 9.7421189243E-01],
	[4.2965000000E+04, 3.8694182896E+01, 5.2220082264E+00, 2.0240064246E+01, 3.7488587831E+00, 9.7422274048E-01],
	[4.2970000000E+04, 3.8702098488E+01, 5.2220476183E+00, 2.0247754377E+01, 3.7492171239E+00, 9.7423358332E-01],
	[4.2975000000E+04, 3.8710014778E+01, 5.2220870060E+00, 2.0255446534E+01, 3.7495753759E+00, 9.7424442094E-01],
	[4.2980000000E+04, 3.8717931766E+01, 5.2221263893E+00, 2.0263140716E+01, 3.7499335392E+00, 9.7425525335E-01],
	[4.2985000000E+04, 3.8725849452E+01, 5.2221657684E+00, 2.0270836923E+01, 3.7502916138E+00, 9.7426608056E-01],
	[4.2990000000E+04, 3.8733767836E+01, 5.2222051432E+00, 2.0278535158E+01, 3.7506495996E+00, 9.7427690255E-01],
	[4.2995000000E+04, 3.8741686918E+01, 5.2222445137E+00, 2.0286235418E+01, 3.7510074968E+00, 9.7428771935E-01],
	[4.3000000000E+04, 3.8749606698E+01, 5.2222838799E+00, 2.0293937706E+01, 3.7513653053E+00, 9.7429853094E-01],
	[4.3005000000E+04, 3.8757527176E+01, 5.2223232419E+00, 2.0301642020E+01, 3.7517230251E+00, 9.7430933734E-01],
	[4.3010000000E+04, 3.8765448352E+01, 5.2223625995E+00, 2.0309348362E+01, 3.7520806563E+00, 9.7432013854E-01],
	[4.3015000000E+04, 3.8773370225E+01, 5.2224019529E+00, 2.0317056732E+01, 3.7524381990E+00, 9.7433093455E-01],
	[4.3020000000E+04, 3.8781292796E+01, 5.2224413020E+00, 2.0324767130E+01, 3.7527956530E+00, 9.7434172536E-01],
	[4.3025000000E+04, 3.8789216065E+01, 5.2224806469E+00, 2.0332479556E+01, 3.7531530185E+00, 9.7435251099E-01],
	[4.3030000000E+04, 3.8797140032E+01, 5.2225199874E+00, 2.0340194011E+01, 3.7535102954E+00, 9.7436329144E-01],
	[4.3035000000E+04, 3.8805064696E+01, 5.2225593237E+00, 2.0347910494E+01, 3.7538674839E+00, 9.7437406670E-01],
	[4.3040000000E+04, 3.8812990059E+01, 5.2225986557E+00, 2.0355629007E+01, 3.7542245838E+00, 9.7438483678E-01],
	[4.3045000000E+04, 3.8820916119E+01, 5.2226379834E+00, 2.0363349549E+01, 3.7545815953E+00, 9.7439560169E-01],
	[4.3050000000E+04, 3.8828842876E+01, 5.2226773069E+00, 2.0371072122E+01, 3.7549385183E+00, 9.7440636142E-01],
	[4.3055000000E+04, 3.8836770332E+01, 5.2227166261E+00, 2.0378796724E+01, 3.7552953528E+00, 9.7441711598E-01],
	[4.3060000000E+04, 3.8844698485E+01, 5.2227559410E+00, 2.0386523356E+01, 3.7556520990E+00, 9.7442786537E-01],
	[4.3065000000E+04, 3.8852627335E+01, 5.2227952517E+00, 2.0394252020E+01, 3.7560087567E+00, 9.7443860959E-01],
	[4.3070000000E+04, 3.8860556884E+01, 5.2228345581E+00, 2.0401982714E+01, 3.7563653261E+00, 9.7444934865E-01],
	[4.3075000000E+04, 3.8868487129E+01, 5.2228738602E+00, 2.0409715440E+01, 3.7567218071E+00, 9.7446008255E-01],
	[4.3080000000E+04, 3.8876418073E+01, 5.2229131580E+00, 2.0417450197E+01, 3.7570781998E+00, 9.7447081129E-01],
	[4.3085000000E+04, 3.8884349714E+01, 5.2229524516E+00, 2.0425186986E+01, 3.7574345042E+00, 9.7448153487E-01],
	[4.3090000000E+04, 3.8892282052E+01, 5.2229917409E+00, 2.0432925807E+01, 3.7577907203E+00, 9.7449225330E-01],
	[4.3095000000E+04, 3.8900215088E+01, 5.2230310260E+00, 2.0440666661E+01, 3.7581468481E+00, 9.7450296658E-01],
	[4.3100000000E+04, 3.8908148822E+01, 5.2230703068E+00, 2.0448409548E+01, 3.7585028877E+00, 9.7451367471E-01],
	[4.3105000000E+04, 3.8916083253E+01, 5.2231095833E+00, 2.0456154467E+01, 3.7588588390E+00, 9.7452437769E-01],
	[4.3110000000E+04, 3.8924018381E+01, 5.2231488556E+00, 2.0463901420E+01, 3.7592147021E+00, 9.7453507553E-01],
	[4.3115000000E+04, 3.8931954207E+01, 5.2231881236E+00, 2.0471650407E+01, 3.7595704771E+00, 9.7454576823E-01],
	[4.3120000000E+04, 3.8939890730E+01, 5.2232273874E+00, 2.0479401428E+01, 3.7599261639E+00, 9.7455645579E-01],
	[4.3125000000E+04, 3.8947827951E+01, 5.2232666469E+00, 2.0487154483E+01, 3.7602817625E+00, 9.7456713821E-01],
	[4.3130000000E+04, 3.8955765869E+01, 5.2233059021E+00, 2.0494909572E+01, 3.7606372730E+00, 9.7457781550E-01],
	[4.3135000000E+04, 3.8963704485E+01, 5.2233451531E+00, 2.0502666697E+01, 3.7609926954E+00, 9.7458848767E-01],
	[4.3140000000E+04, 3.8971643797E+01, 5.2233843998E+00, 2.0510425856E+01, 3.7613480297E+00, 9.7459915470E-01],
	[4.3145000000E+04, 3.8979583808E+01, 5.2234236423E+00, 2.0518187051E+01, 3.7617032760E+00, 9.7460981661E-01],
	[4.3150000000E+04, 3.8987524515E+01, 5.2234628806E+00, 2.0525950282E+01, 3.7620584342E+00, 9.7462047339E-01],
	[4.3155000000E+04, 3.8995465920E+01, 5.2235021145E+00, 2.0533715549E+01, 3.7624135044E+00, 9.7463112506E-01],
	[4.3160000000E+04, 3.9003408022E+01, 5.2235413443E+00, 2.0541482852E+01, 3.7627684866E+00, 9.7464177161E-01],
	[4.3165000000E+04, 3.9011350821E+01, 5.2235805697E+00, 2.0549252191E+01, 3.7631233808E+00, 9.7465241304E-01],
	[4.3170000000E+04, 3.9019294317E+01, 5.2236197910E+00, 2.0557023568E+01, 3.7634781871E+00, 9.7466304936E-01],
	[4.3175000000E+04, 3.9027238511E+01, 5.2236590079E+00, 2.0564796982E+01, 3.7638329054E+00, 9.7467368057E-01],
	[4.3180000000E+04, 3.9035183402E+01, 5.2236982207E+00, 2.0572572434E+01, 3.7641875358E+00, 9.7468430667E-01],
	[4.3185000000E+04, 3.9043137253E+01, 5.2237384020E+00, 2.0580349923E+01, 3.7645426604E+00, 9.7469492767E-01],
	[4.3190000000E+04, 3.9051100241E+01, 5.2237795720E+00, 2.0588129450E+01, 3.7648982914E+00, 9.7470554357E-01],
	[4.3195000000E+04, 3.9059063930E+01, 5.2238207375E+00, 2.0595911016E+01, 3.7652538348E+00, 9.7471615437E-01],
	[4.3200000000E+04, 3.9067028321E+01, 5.2238618985E+00, 2.0603694621E+01, 3.7656092906E+00, 9.7472676007E-01],
	[4.3205000000E+04, 3.9074993414E+01, 5.2239030551E+00, 2.0611480265E+01, 3.7659646587E+00, 9.7473736068E-01],
	[4.3210000000E+04, 3.9082959209E+01, 5.2239442073E+00, 2.0619267948E+01, 3.7663199394E+00, 9.7474795619E-01],
	[4.3215000000E+04, 3.9090925706E+01, 5.2239853550E+00, 2.0627057670E+01, 3.7666751324E+00, 9.7475854662E-01],
	[4.3220000000E+04, 3.9098892905E+01, 5.2240264984E+00, 2.0634849433E+01, 3.7670302380E+00, 9.7476913196E-01],
	[4.3225000000E+04, 3.9106860806E+01, 5.2240676372E+00, 2.0642643235E+01, 3.7673852560E+00, 9.7477971221E-01],
	[4.3230000000E+04, 3.9114829408E+01, 5.2241087717E+00, 2.0650439079E+01, 3.7677401866E+00, 9.7479028739E-01],
	[4.3235000000E+04, 3.9122798713E+01, 5.2241499017E+00, 2.0658236963E+01, 3.7680950297E+00, 9.7480085748E-01],
	[4.3240000000E+04, 3.9130768719E+01, 5.2241910272E+00, 2.0666036888E+01, 3.7684497854E+00, 9.7481142250E-01],
	[4.3245000000E+04, 3.9138739427E+01, 5.2242321484E+00, 2.0673838854E+01, 3.7688044536E+00, 9.7482198244E-01],
	[4.3250000000E+04, 3.9146710837E+01, 5.2242732651E+00, 2.0681642863E+01, 3.7691590345E+00, 9.7483253732E-01],
	[4.3255000000E+04, 3.9154682949E+01, 5.2243143773E+00, 2.0689448913E+01, 3.7695135279E+00, 9.7484308713E-01],
	[4.3260000000E+04, 3.9162655762E+01, 5.2243554852E+00, 2.0697257006E+01, 3.7698679340E+00, 9.7485363187E-01],
	[4.3265000000E+04, 3.9170629277E+01, 5.2243965886E+00, 2.0705067141E+01, 3.7702222528E+00, 9.7486417154E-01],
	[4.3270000000E+04, 3.9178603494E+01, 5.2244376876E+00, 2.0712879319E+01, 3.7705764842E+00, 9.7487470616E-01],
	[4.3275000000E+04, 3.9186578412E+01, 5.2244787822E+00, 2.0720693540E+01, 3.7709306284E+00, 9.7488523572E-01],
	[4.3280000000E+04, 3.9194554032E+01, 5.2245198723E+00, 2.0728509805E+01, 3.7712846852E+00, 9.7489576022E-01],
	[4.3285000000E+04, 3.9202530354E+01, 5.2245609580E+00, 2.0736328114E+01, 3.7716386549E+00, 9.7490627967E-01],
	[4.3290000000E+04, 3.9210507378E+01, 5.2246020393E+00, 2.0744148466E+01, 3.7719925372E+00, 9.7491679407E-01],
	[4.3295000000E+04, 3.9218485103E+01, 5.2246431162E+00, 2.0751970863E+01, 3.7723463324E+00, 9.7492730342E-01],
	[4.3300000000E+04, 3.9226463529E+01, 5.2246841886E+00, 2.0759795305E+01, 3.7727000404E+00, 9.7493780772E-01],
	[4.3305000000E+04, 3.9234442657E+01, 5.2247252567E+00, 2.0767621792E+01, 3.7730536612E+00, 9.7494830699E-01],
	[4.3310000000E+04, 3.9242422487E+01, 5.2247663203E+00, 2.0775450324E+01, 3.7734071948E+00, 9.7495880121E-01],
	[4.3315000000E+04, 3.9250403018E+01, 5.2248073795E+00, 2.0783280901E+01, 3.7737606413E+00, 9.7496929039E-01],
	[4.3320000000E+04, 3.9258384251E+01, 5.2248484343E+00, 2.0791113525E+01, 3.7741140007E+00, 9.7497977454E-01],
	[4.3325000000E+04, 3.9266366185E+01, 5.2248894846E+00, 2.0798948194E+01, 3.7744672730E+00, 9.7499025366E-01],
	[4.3330000000E+04, 3.9274348821E+01, 5.2249305306E+00, 2.0806784911E+01, 3.7748204583E+00, 9.7500072775E-01],
	[4.3335000000E+04, 3.9282332158E+01, 5.2249715721E+00, 2.0814623673E+01, 3.7751735564E+00, 9.7501119681E-01],
	[4.3340000000E+04, 3.9290316197E+01, 5.2250126093E+00, 2.0822464483E+01, 3.7755265676E+00, 9.7502166085E-01],
	[4.3345000000E+04, 3.9298300937E+01, 5.2250536420E+00, 2.0830307341E+01, 3.7758794917E+00, 9.7503211986E-01],
	[4.3350000000E+04, 3.9306286379E+01, 5.2250946703E+00, 2.0838152246E+01, 3.7762323289E+00, 9.7504257385E-01],
	[4.3355000000E+04, 3.9314272521E+01, 5.2251356942E+00, 2.0845999198E+01, 3.7765850791E+00, 9.7505302283E-01],
	[4.3360000000E+04, 3.9322259366E+01, 5.2251767136E+00, 2.0853848200E+01, 3.7769377423E+00, 9.7506346679E-01],
	[4.3365000000E+04, 3.9330246911E+01, 5.2252177287E+00, 2.0861699249E+01, 3.7772903186E+00, 9.7507390574E-01],
	[4.3370000000E+04, 3.9338235158E+01, 5.2252587394E+00, 2.0869552348E+01, 3.7776428080E+00, 9.7508433969E-01],
	[4.3375000000E+04, 3.9346224106E+01, 5.2252997456E+00, 2.0877407496E+01, 3.7779952106E+00, 9.7509476862E-01],
	[4.3380000000E+04, 3.9354213755E+01, 5.2253407475E+00, 2.0885264693E+01, 3.7783475262E+00, 9.7510519255E-01],
	[4.3385000000E+04, 3.9362204106E+01, 5.2253817450E+00, 2.0893123940E+01, 3.7786997550E+00, 9.7511561148E-01],
	[4.3390000000E+04, 3.9370195158E+01, 5.2254227380E+00, 2.0900985237E+01, 3.7790518970E+00, 9.7512602541E-01],
	[4.3395000000E+04, 3.9378186911E+01, 5.2254637267E+00, 2.0908848584E+01, 3.7794039522E+00, 9.7513643434E-01],
	[4.3400000000E+04, 3.9386179365E+01, 5.2255047109E+00, 2.0916713982E+01, 3.7797559206E+00, 9.7514683828E-01],
	[4.3405000000E+04, 3.9394172521E+01, 5.2255456907E+00, 2.0924581431E+01, 3.7801078023E+00, 9.7515723723E-01],
	[4.3410000000E+04, 3.9402166378E+01, 5.2255866662E+00, 2.0932450931E+01, 3.7804595972E+00, 9.7516763119E-01],
	[4.3415000000E+04, 3.9410160936E+01, 5.2256276372E+00, 2.0940322483E+01, 3.7808113053E+00, 9.7517802016E-01],
	[4.3420000000E+04, 3.9418156194E+01, 5.2256686039E+00, 2.0948196086E+01, 3.7811629268E+00, 9.7518840415E-01],
	[4.3425000000E+04, 3.9426152155E+01, 5.2257095662E+00, 2.0956071742E+01, 3.7815144616E+00, 9.7519878315E-01],
	[4.3430000000E+04, 3.9434148816E+01, 5.2257505240E+00, 2.0963949450E+01, 3.7818659098E+00, 9.7520915718E-01],
	[4.3435000000E+04, 3.9442146178E+01, 5.2257914775E+00, 2.0971829211E+01, 3.7822172713E+00, 9.7521952623E-01],
	[4.3440000000E+04, 3.9450144241E+01, 5.2258324266E+00, 2.0979711024E+01, 3.7825685462E+00, 9.7522989031E-01],
	[4.3445000000E+04, 3.9458143006E+01, 5.2258733712E+00, 2.0987594892E+01, 3.7829197344E+00, 9.7524024942E-01],
	[4.3450000000E+04, 3.9466142471E+01, 5.2259143115E+00, 2.0995480812E+01, 3.7832708362E+00, 9.7525060356E-01],
	[4.3455000000E+04, 3.9474142637E+01, 5.2259552474E+00, 2.1003368787E+01, 3.7836218513E+00, 9.7526095273E-01],
	[4.3460000000E+04, 3.9482143504E+01, 5.2259961789E+00, 2.1011258816E+01, 3.7839727799E+00, 9.7527129694E-01],
	[4.3465000000E+04, 3.9490145073E+01, 5.2260371061E+00, 2.1019150899E+01, 3.7843236220E+00, 9.7528163619E-01],
	[4.3470000000E+04, 3.9498147342E+01, 5.2260780288E+00, 2.1027045038E+01, 3.7846743777E+00, 9.7529197049E-01],
	[4.3475000000E+04, 3.9506150312E+01, 5.2261189472E+00, 2.1034941231E+01, 3.7850250468E+00, 9.7530229982E-01],
	[4.3480000000E+04, 3.9514153983E+01, 5.2261598611E+00, 2.1042839480E+01, 3.7853756295E+00, 9.7531262420E-01],
	[4.3485000000E+04, 3.9522158355E+01, 5.2262007707E+00, 2.1050739784E+01, 3.7857261257E+00, 9.7532294364E-01],
	[4.3490000000E+04, 3.9530163427E+01, 5.2262416759E+00, 2.1058642145E+01, 3.7860765356E+00, 9.7533325812E-01],
	[4.3495000000E+04, 3.9538169201E+01, 5.2262825767E+00, 2.1066546561E+01, 3.7864268590E+00, 9.7534356766E-01],
	[4.3500000000E+04, 3.9546175675E+01, 5.2263234731E+00, 2.1074453035E+01, 3.7867770961E+00, 9.7535387225E-01],
	[4.3505000000E+04, 3.9554182850E+01, 5.2263643652E+00, 2.1082361565E+01, 3.7871272468E+00, 9.7536417191E-01],
	[4.3510000000E+04, 3.9562190726E+01, 5.2264052529E+00, 2.1090272152E+01, 3.7874773112E+00, 9.7537446663E-01],
	[4.3515000000E+04, 3.9570199303E+01, 5.2264461362E+00, 2.1098184797E+01, 3.7878272893E+00, 9.7538475641E-01],
	[4.3520000000E+04, 3.9578208581E+01, 5.2264870151E+00, 2.1106099500E+01, 3.7881771811E+00, 9.7539504126E-01],
	[4.3525000000E+04, 3.9586218559E+01, 5.2265278896E+00, 2.1114016261E+01, 3.7885269867E+00, 9.7540532118E-01],
	[4.3530000000E+04, 3.9594229238E+01, 5.2265687598E+00, 2.1121935080E+01, 3.7888767060E+00, 9.7541559617E-01],
	[4.3535000000E+04, 3.9602240617E+01, 5.2266096256E+00, 2.1129855958E+01, 3.7892263390E+00, 9.7542586624E-01],
	[4.3540000000E+04, 3.9610252697E+01, 5.2266504870E+00, 2.1137778895E+01, 3.7895758859E+00, 9.7543613138E-01],
	[4.3545000000E+04, 3.9618265478E+01, 5.2266913440E+00, 2.1145703891E+01, 3.7899253465E+00, 9.7544639160E-01],
	[4.3550000000E+04, 3.9626278960E+01, 5.2267321967E+00, 2.1153630947E+01, 3.7902747211E+00, 9.7545664691E-01],
	[4.3555000000E+04, 3.9634293142E+01, 5.2267730450E+00, 2.1161560063E+01, 3.7906240094E+00, 9.7546689730E-01],
	[4.3560000000E+04, 3.9642308024E+01, 5.2268138889E+00, 2.1169491238E+01, 3.7909732117E+00, 9.7547714278E-01],
	[4.3565000000E+04, 3.9650323608E+01, 5.2268547285E+00, 2.1177424475E+01, 3.7913223278E+00, 9.7548738335E-01],
	[4.3570000000E+04, 3.9658339892E+01, 5.2268955637E+00, 2.1185359772E+01, 3.7916713578E+00, 9.7549761901E-01],
	[4.3575000000E+04, 3.9666356876E+01, 5.2269363945E+00, 2.1193297130E+01, 3.7920203018E+00, 9.7550784977E-01],
	[4.3580000000E+04, 3.9674374561E+01, 5.2269772210E+00, 2.1201236549E+01, 3.7923691598E+00, 9.7551807562E-01],
	[4.3585000000E+04, 3.9682392946E+01, 5.2270180431E+00, 2.1209178031E+01, 3.7927179317E+00, 9.7552829658E-01],
	[4.3590000000E+04, 3.9690412032E+01, 5.2270588608E+00, 2.1217121574E+01, 3.7930666177E+00, 9.7553851263E-01],
	[4.3595000000E+04, 3.9698431818E+01, 5.2270996742E+00, 2.1225067179E+01, 3.7934152176E+00, 9.7554872380E-01],
	[4.3600000000E+04, 3.9706452305E+01, 5.2271404832E+00, 2.1233014847E+01, 3.7937637316E+00, 9.7555893007E-01],
	[4.3605000000E+04, 3.9714473492E+01, 5.2271812878E+00, 2.1240964578E+01, 3.7941121597E+00, 9.7556913145E-01],
	[4.3610000000E+04, 3.9722495379E+01, 5.2272220881E+00, 2.1248916372E+01, 3.7944605018E+00, 9.7557932794E-01],
	[4.3615000000E+04, 3.9730517967E+01, 5.2272628840E+00, 2.1256870230E+01, 3.7948087581E+00, 9.7558951955E-01],
	[4.3620000000E+04, 3.9738541255E+01, 5.2273036756E+00, 2.1264826151E+01, 3.7951569284E+00, 9.7559970628E-01],
	[4.3625000000E+04, 3.9746565244E+01, 5.2273444628E+00, 2.1272784136E+01, 3.7955050129E+00, 9.7560988813E-01],
	[4.3630000000E+04, 3.9754589933E+01, 5.2273852457E+00, 2.1280744186E+01, 3.7958530116E+00, 9.7562006510E-01],
	[4.3635000000E+04, 3.9762615322E+01, 5.2274260242E+00, 2.1288706300E+01, 3.7962009245E+00, 9.7563023720E-01],
	[4.3640000000E+04, 3.9770641412E+01, 5.2274667983E+00, 2.1296670480E+01, 3.7965487515E+00, 9.7564040442E-01],
	[4.3645000000E+04, 3.9778668201E+01, 5.2275075681E+00, 2.1304636724E+01, 3.7968964928E+00, 9.7565056678E-01],
	[4.3650000000E+04, 3.9786695691E+01, 5.2275483335E+00, 2.1312605034E+01, 3.7972441484E+00, 9.7566072427E-01],
	[4.3655000000E+04, 3.9794723882E+01, 5.2275890946E+00, 2.1320575410E+01, 3.7975917182E+00, 9.7567087689E-01],
	[4.3660000000E+04, 3.9802752772E+01, 5.2276298514E+00, 2.1328547852E+01, 3.7979392023E+00, 9.7568102466E-01],
	[4.3665000000E+04, 3.9810782363E+01, 5.2276706038E+00, 2.1336522361E+01, 3.7982866007E+00, 9.7569116756E-01],
	[4.3670000000E+04, 3.9818812653E+01, 5.2277113518E+00, 2.1344498936E+01, 3.7986339134E+00, 9.7570130561E-01],
	[4.3675000000E+04, 3.9826843644E+01, 5.2277520955E+00, 2.1352477578E+01, 3.7989811405E+00, 9.7571143880E-01],
	[4.3680000000E+04, 3.9834875335E+01, 5.2277928348E+00, 2.1360458288E+01, 3.7993282820E+00, 9.7572156714E-01],
	[4.3685000000E+04, 3.9842907726E+01, 5.2278335698E+00, 2.1368441065E+01, 3.7996753378E+00, 9.7573169063E-01],
	[4.3690000000E+04, 3.9850940818E+01, 5.2278743005E+00, 2.1376425911E+01, 3.8000223081E+00, 9.7574180928E-01],
	[4.3695000000E+04, 3.9858974609E+01, 5.2279150268E+00, 2.1384412824E+01, 3.8003691928E+00, 9.7575192308E-01],
	[4.3700000000E+04, 3.9867009100E+01, 5.2279557488E+00, 2.1392401806E+01, 3.8007159919E+00, 9.7576203204E-01],
	[4.3705000000E+04, 3.9875044292E+01, 5.2279964664E+00, 2.1400392857E+01, 3.8010627056E+00, 9.7577213616E-01],
	[4.3710000000E+04, 3.9883080183E+01, 5.2280371797E+00, 2.1408385977E+01, 3.8014093337E+00, 9.7578223544E-01],
	[4.3715000000E+04, 3.9891116775E+01, 5.2280778886E+00, 2.1416381166E+01, 3.8017558763E+00, 9.7579232989E-01],
	[4.3720000000E+04, 3.9899154066E+01, 5.2281185932E+00, 2.1424378425E+01, 3.8021023335E+00, 9.7580241951E-01],
	[4.3725000000E+04, 3.9907192057E+01, 5.2281592935E+00, 2.1432377754E+01, 3.8024487052E+00, 9.7581250430E-01],
	[4.3730000000E+04, 3.9915230749E+01, 5.2281999894E+00, 2.1440379154E+01, 3.8027949915E+00, 9.7582258426E-01],
	[4.3735000000E+04, 3.9923270140E+01, 5.2282406810E+00, 2.1448382624E+01, 3.8031411924E+00, 9.7583265940E-01],
	[4.3740000000E+04, 3.9931310231E+01, 5.2282813683E+00, 2.1456388165E+01, 3.8034873079E+00, 9.7584272972E-01],
	[4.3745000000E+04, 3.9939351022E+01, 5.2283220512E+00, 2.1464395777E+01, 3.8038333381E+00, 9.7585279522E-01],
	[4.3750000000E+04, 3.9947392513E+01, 5.2283627298E+00, 2.1472405461E+01, 3.8041792829E+00, 9.7586285590E-01],
	[4.3755000000E+04, 3.9955434703E+01, 5.2284034041E+00, 2.1480417217E+01, 3.8045251424E+00, 9.7587291177E-01],
	[4.3760000000E+04, 3.9963477594E+01, 5.2284440740E+00, 2.1488431044E+01, 3.8048709166E+00, 9.7588296282E-01],
	[4.3765000000E+04, 3.9971521184E+01, 5.2284847396E+00, 2.1496446944E+01, 3.8052166055E+00, 9.7589300907E-01],
	[4.3770000000E+04, 3.9979565474E+01, 5.2285254009E+00, 2.1504464917E+01, 3.8055622092E+00, 9.7590305051E-01],
	[4.3775000000E+04, 3.9987610464E+01, 5.2285660578E+00, 2.1512484963E+01, 3.8059077276E+00, 9.7591308715E-01],
	[4.3780000000E+04, 3.9995656154E+01, 5.2286067104E+00, 2.1520507082E+01, 3.8062531608E+00, 9.7592311898E-01],
	[4.3785000000E+04, 4.0003702543E+01, 5.2286473587E+00, 2.1528531275E+01, 3.8065985088E+00, 9.7593314602E-01],
	[4.3790000000E+04, 4.0011749632E+01, 5.2286880027E+00, 2.1536557542E+01, 3.8069437717E+00, 9.7594316826E-01],
	[4.3795000000E+04, 4.0019797421E+01, 5.2287286423E+00, 2.1544585882E+01, 3.8072889493E+00, 9.7595318571E-01],
	[4.3800000000E+04, 4.0027845909E+01, 5.2287692776E+00, 2.1552616298E+01, 3.8076340419E+00, 9.7596319837E-01],
	[4.3805000000E+04, 4.0035895097E+01, 5.2288099086E+00, 2.1560648788E+01, 3.8079790493E+00, 9.7597320623E-01],
	[4.3810000000E+04, 4.0043944985E+01, 5.2288505353E+00, 2.1568683353E+01, 3.8083239716E+00, 9.7598320931E-01],
	[4.3815000000E+04, 4.0051995572E+01, 5.2288911576E+00, 2.1576719994E+01, 3.8086688089E+00, 9.7599320761E-01],
	[4.3820000000E+04, 4.0060046859E+01, 5.2289317756E+00, 2.1584758710E+01, 3.8090135611E+00, 9.7600320112E-01],
	[4.3825000000E+04, 4.0068098845E+01, 5.2289723893E+00, 2.1592799503E+01, 3.8093582283E+00, 9.7601318986E-01],
	[4.3830000000E+04, 4.0076151531E+01, 5.2290129987E+00, 2.1600842371E+01, 3.8097028105E+00, 9.7602317382E-01],
	[4.3835000000E+04, 4.0084204917E+01, 5.2290536038E+00, 2.1608887317E+01, 3.8100473076E+00, 9.7603315301E-01],
	[4.3840000000E+04, 4.0092259002E+01, 5.2290942046E+00, 2.1616934339E+01, 3.8103917198E+00, 9.7604312742E-01],
	[4.3845000000E+04, 4.0100313787E+01, 5.2291348010E+00, 2.1624983438E+01, 3.8107360471E+00, 9.7605309707E-01],
	[4.3850000000E+04, 4.0108369271E+01, 5.2291753931E+00, 2.1633034615E+01, 3.8110802894E+00, 9.7606306195E-01],
	[4.3855000000E+04, 4.0116425454E+01, 5.2292159809E+00, 2.1641087870E+01, 3.8114244468E+00, 9.7607302206E-01],
	[4.3860000000E+04, 4.0124482337E+01, 5.2292565645E+00, 2.1649143202E+01, 3.8117685194E+00, 9.7608297742E-01],
	[4.3865000000E+04, 4.0132539919E+01, 5.2292971436E+00, 2.1657200613E+01, 3.8121125070E+00, 9.7609292801E-01],
	[4.3870000000E+04, 4.0140598201E+01, 5.2293377185E+00, 2.1665260103E+01, 3.8124564099E+00, 9.7610287385E-01],
	[4.3875000000E+04, 4.0148657182E+01, 5.2293782891E+00, 2.1673321672E+01, 3.8128002278E+00, 9.7611281494E-01],
	[4.3880000000E+04, 4.0156724470E+01, 5.2294197372E+00, 2.1681385320E+01, 3.8131444985E+00, 9.7612275127E-01],
	[4.3885000000E+04, 4.0164801430E+01, 5.2294622205E+00, 2.1689451048E+01, 3.8134893182E+00, 9.7613268286E-01],
	[4.3890000000E+04, 4.0172879095E+01, 5.2295046994E+00, 2.1697518855E+01, 3.8138340533E+00, 9.7614260970E-01],
	[4.3895000000E+04, 4.0180957463E+01, 5.2295471738E+00, 2.1705588743E+01, 3.8141787039E+00, 9.7615253179E-01],
	[4.3900000000E+04, 4.0189036535E+01, 5.2295896437E+00, 2.1713660711E+01, 3.8145232700E+00, 9.7616244915E-01],
	[4.3905000000E+04, 4.0197116312E+01, 5.2296321091E+00, 2.1721734760E+01, 3.8148677516E+00, 9.7617236176E-01],
	[4.3910000000E+04, 4.0205196792E+01, 5.2296745700E+00, 2.1729810890E+01, 3.8152121488E+00, 9.7618226964E-01],
	[4.3915000000E+04, 4.0213277976E+01, 5.2297170264E+00, 2.1737889102E+01, 3.8155564615E+00, 9.7619217278E-01],
	[4.3920000000E+04, 4.0221359865E+01, 5.2297594783E+00, 2.1745969395E+01, 3.8159006897E+00, 9.7620207120E-01],
	[4.3925000000E+04, 4.0229442457E+01, 5.2298019257E+00, 2.1754051770E+01, 3.8162448336E+00, 9.7621196488E-01],
	[4.3930000000E+04, 4.0237525753E+01, 5.2298443687E+00, 2.1762136227E+01, 3.8165888931E+00, 9.7622185384E-01],
	[4.3935000000E+04, 4.0245609754E+01, 5.2298868071E+00, 2.1770222767E+01, 3.8169328682E+00, 9.7623173807E-01],
	[4.3940000000E+04, 4.0253694458E+01, 5.2299292411E+00, 2.1778311390E+01, 3.8172767589E+00, 9.7624161758E-01],
	[4.3945000000E+04, 4.0261779866E+01, 5.2299716706E+00, 2.1786402096E+01, 3.8176205653E+00, 9.7625149238E-01],
	[4.3950000000E+04, 4.0269865978E+01, 5.2300140956E+00, 2.1794494886E+01, 3.8179642875E+00, 9.7626136245E-01],
	[4.3955000000E+04, 4.0277952794E+01, 5.2300565161E+00, 2.1802589759E+01, 3.8183079253E+00, 9.7627122781E-01],
	[4.3960000000E+04, 4.0286040313E+01, 5.2300989321E+00, 2.1810686716E+01, 3.8186514789E+00, 9.7628108846E-01],
	[4.3965000000E+04, 4.0294128537E+01, 5.2301413437E+00, 2.1818785758E+01, 3.8189949482E+00, 9.7629094441E-01],
	[4.3970000000E+04, 4.0302217464E+01, 5.2301837508E+00, 2.1826886884E+01, 3.8193383333E+00, 9.7630079564E-01],
	[4.3975000000E+04, 4.0310307095E+01, 5.2302261534E+00, 2.1834990095E+01, 3.8196816342E+00, 9.7631064217E-01],
	[4.3980000000E+04, 4.0318397430E+01, 5.2302685515E+00, 2.1843095392E+01, 3.8200248509E+00, 9.7632048400E-01],
	[4.3985000000E+04, 4.0326488468E+01, 5.2303109452E+00, 2.1851202774E+01, 3.8203679835E+00, 9.7633032113E-01],
	[4.3990000000E+04, 4.0334580210E+01, 5.2303533343E+00, 2.1859312242E+01, 3.8207110319E+00, 9.7634015356E-01],
	[4.3995000000E+04, 4.0342672656E+01, 5.2303957190E+00, 2.1867423796E+01, 3.8210539962E+00, 9.7634998130E-01],
	[4.4000000000E+04, 4.0350765806E+01, 5.2304380993E+00, 2.1875537437E+01, 3.8213968764E+00, 9.7635980435E-01],
	[4.4005000000E+04, 4.0358859659E+01, 5.2304804750E+00, 2.1883653164E+01, 3.8217396725E+00, 9.7636962271E-01],
	[4.4010000000E+04, 4.0366954216E+01, 5.2305228463E+00, 2.1891770978E+01, 3.8220823845E+00, 9.7637943638E-01],
	[4.4015000000E+04, 4.0375049477E+01, 5.2305652131E+00, 2.1899890880E+01, 3.8224250125E+00, 9.7638924537E-01],
	[4.4020000000E+04, 4.0383145441E+01, 5.2306075755E+00, 2.1908012870E+01, 3.8227675565E+00, 9.7639904967E-01],
	[4.4025000000E+04, 4.0391242109E+01, 5.2306499333E+00, 2.1916136947E+01, 3.8231100165E+00, 9.7640884930E-01],
	[4.4030000000E+04, 4.0399339480E+01, 5.2306922868E+00, 2.1924263113E+01, 3.8234523925E+00, 9.7641864425E-01],
	[4.4035000000E+04, 4.0407437555E+01, 5.2307346357E+00, 2.1932391367E+01, 3.8237946845E+00, 9.7642843452E-01],
	[4.4040000000E+04, 4.0415536334E+01, 5.2307769802E+00, 2.1940521710E+01, 3.8241368926E+00, 9.7643822012E-01],
	[4.4045000000E+04, 4.0423635816E+01, 5.2308193202E+00, 2.1948654142E+01, 3.8244790168E+00, 9.7644800105E-01],
	[4.4050000000E+04, 4.0431736001E+01, 5.2308616557E+00, 2.1956788664E+01, 3.8248210571E+00, 9.7645777732E-01],
	[4.4055000000E+04, 4.0439836890E+01, 5.2309039868E+00, 2.1964925275E+01, 3.8251630135E+00, 9.7646754892E-01],
	[4.4060000000E+04, 4.0447938482E+01, 5.2309463134E+00, 2.1973063976E+01, 3.8255048861E+00, 9.7647731586E-01],
	[4.4065000000E+04, 4.0456040778E+01, 5.2309886356E+00, 2.1981204768E+01, 3.8258466748E+00, 9.7648707814E-01],
	[4.4070000000E+04, 4.0464143777E+01, 5.2310309533E+00, 2.1989347651E+01, 3.8261883797E+00, 9.7649683576E-01],
	[4.4075000000E+04, 4.0472247480E+01, 5.2310732666E+00, 2.1997492624E+01, 3.8265300008E+00, 9.7650658873E-01],
	[4.4080000000E+04, 4.0480351886E+01, 5.2311155753E+00, 2.2005639688E+01, 3.8268715382E+00, 9.7651633704E-01],
	[4.4085000000E+04, 4.0488456996E+01, 5.2311578797E+00, 2.2013788845E+01, 3.8272129918E+00, 9.7652608071E-01],
	[4.4090000000E+04, 4.0496562808E+01, 5.2312001795E+00, 2.2021940093E+01, 3.8275543616E+00, 9.7653581973E-01],
	[4.4095000000E+04, 4.0504669324E+01, 5.2312424750E+00, 2.2030093433E+01, 3.8278956477E+00, 9.7654555410E-01],
	[4.4100000000E+04, 4.0512776544E+01, 5.2312847659E+00, 2.2038248865E+01, 3.8282368502E+00, 9.7655528383E-01],
	[4.4105000000E+04, 4.0520884467E+01, 5.2313270524E+00, 2.2046406391E+01, 3.8285779690E+00, 9.7656500892E-01],
	[4.4110000000E+04, 4.0528993093E+01, 5.2313693345E+00, 2.2054566009E+01, 3.8289190041E+00, 9.7657472937E-01],
	[4.4115000000E+04, 4.0537102422E+01, 5.2314116121E+00, 2.2062727721E+01, 3.8292599556E+00, 9.7658444519E-01],
	[4.4120000000E+04, 4.0545212454E+01, 5.2314538853E+00, 2.2070891526E+01, 3.8296008234E+00, 9.7659415637E-01],
	[4.4125000000E+04, 4.0553323190E+01, 5.2314961540E+00, 2.2079057425E+01, 3.8299416077E+00, 9.7660386293E-01],
	[4.4130000000E+04, 4.0561434629E+01, 5.2315384183E+00, 2.2087225419E+01, 3.8302823084E+00, 9.7661356486E-01],
	[4.4135000000E+04, 4.0569546771E+01, 5.2315806781E+00, 2.2095395507E+01, 3.8306229256E+00, 9.7662326216E-01],
	[4.4140000000E+04, 4.0577659616E+01, 5.2316229335E+00, 2.2103567690E+01, 3.8309634592E+00, 9.7663295484E-01],
	[4.4145000000E+04, 4.0585773165E+01, 5.2316651844E+00, 2.2111741968E+01, 3.8313039093E+00, 9.7664264290E-01],
	[4.4150000000E+04, 4.0593887416E+01, 5.2317074309E+00, 2.2119918341E+01, 3.8316442760E+00, 9.7665232634E-01],
	[4.4155000000E+04, 4.0602002371E+01, 5.2317496729E+00, 2.2128096810E+01, 3.8319845591E+00, 9.7666200516E-01],
	[4.4160000000E+04, 4.0610118028E+01, 5.2317919105E+00, 2.2136277375E+01, 3.8323247589E+00, 9.7667167938E-01],
	[4.4165000000E+04, 4.0618234389E+01, 5.2318341437E+00, 2.2144460037E+01, 3.8326648751E+00, 9.7668134898E-01],
	[4.4170000000E+04, 4.0626351453E+01, 5.2318763724E+00, 2.2152644795E+01, 3.8330049080E+00, 9.7669101397E-01],
	[4.4175000000E+04, 4.0634469220E+01, 5.2319185966E+00, 2.2160831650E+01, 3.8333448575E+00, 9.7670067436E-01],
	[4.4180000000E+04, 4.0642587690E+01, 5.2319608165E+00, 2.2169020602E+01, 3.8336847236E+00, 9.7671033014E-01],
	[4.4185000000E+04, 4.0650706862E+01, 5.2320030319E+00, 2.2177211652E+01, 3.8340245064E+00, 9.7671998133E-01],
	[4.4190000000E+04, 4.0658826738E+01, 5.2320452429E+00, 2.2185404800E+01, 3.8343642059E+00, 9.7672962791E-01],
	[4.4195000000E+04, 4.0666947317E+01, 5.2320874494E+00, 2.2193600046E+01, 3.8347038220E+00, 9.7673926990E-01],
	[4.4200000000E+04, 4.0675068599E+01, 5.2321296515E+00, 2.2201797390E+01, 3.8350433549E+00, 9.7674890730E-01],
	[4.4205000000E+04, 4.0683190583E+01, 5.2321718491E+00, 2.2209996833E+01, 3.8353828045E+00, 9.7675854011E-01],
	[4.4210000000E+04, 4.0691313271E+01, 5.2322140424E+00, 2.2218198375E+01, 3.8357221709E+00, 9.7676816832E-01],
	[4.4215000000E+04, 4.0699436661E+01, 5.2322562312E+00, 2.2226402016E+01, 3.8360614540E+00, 9.7677779195E-01],
	[4.4220000000E+04, 4.0707560755E+01, 5.2322984155E+00, 2.2234607757E+01, 3.8364006539E+00, 9.7678741100E-01],
	[4.4225000000E+04, 4.0715685551E+01, 5.2323405955E+00, 2.2242815598E+01, 3.8367397707E+00, 9.7679702547E-01],
	[4.4230000000E+04, 4.0723811050E+01, 5.2323827710E+00, 2.2251025539E+01, 3.8370788043E+00, 9.7680663535E-01],
	[4.4235000000E+04, 4.0731937251E+01, 5.2324249421E+00, 2.2259237581E+01, 3.8374177547E+00, 9.7681624066E-01],
	[4.4240000000E+04, 4.0740064156E+01, 5.2324671087E+00, 2.2267451723E+01, 3.8377566220E+00, 9.7682584140E-01],
	[4.4245000000E+04, 4.0748191763E+01, 5.2325092710E+00, 2.2275667967E+01, 3.8380954062E+00, 9.7683543757E-01],
	[4.4250000000E+04, 4.0756320073E+01, 5.2325514288E+00, 2.2283886312E+01, 3.8384341074E+00, 9.7684502916E-01],
	[4.4255000000E+04, 4.0764449086E+01, 5.2325935821E+00, 2.2292106758E+01, 3.8387727254E+00, 9.7685461619E-01],
	[4.4260000000E+04, 4.0772578801E+01, 5.2326357311E+00, 2.2300329307E+01, 3.8391112605E+00, 9.7686419866E-01],
	[4.4265000000E+04, 4.0780709220E+01, 5.2326778756E+00, 2.2308553958E+01, 3.8394497125E+00, 9.7687377656E-01],
	[4.4270000000E+04, 4.0788840341E+01, 5.2327200158E+00, 2.2316780712E+01, 3.8397880815E+00, 9.7688334990E-01],
	[4.4275000000E+04, 4.0796972164E+01, 5.2327621515E+00, 2.2325009568E+01, 3.8401263676E+00, 9.7689291869E-01],
	[4.4280000000E+04, 4.0805104690E+01, 5.2328042827E+00, 2.2333240528E+01, 3.8404645706E+00, 9.7690248292E-01],
	[4.4285000000E+04, 4.0813237919E+01, 5.2328464096E+00, 2.2341473591E+01, 3.8408026908E+00, 9.7691204260E-01],
	[4.4290000000E+04, 4.0821371850E+01, 5.2328885320E+00, 2.2349708758E+01, 3.8411407280E+00, 9.7692159773E-01],
	[4.4295000000E+04, 4.0829506484E+01, 5.2329306501E+00, 2.2357946029E+01, 3.8414786823E+00, 9.7693114832E-01],
	[4.4300000000E+04, 4.0837641821E+01, 5.2329727637E+00, 2.2366185405E+01, 3.8418165538E+00, 9.7694069436E-01],
	[4.4305000000E+04, 4.0845777860E+01, 5.2330148729E+00, 2.2374426885E+01, 3.8421543424E+00, 9.7695023585E-01],
	[4.4310000000E+04, 4.0853914601E+01, 5.2330569777E+00, 2.2382670471E+01, 3.8424920481E+00, 9.7695977281E-01],
	[4.4315000000E+04, 4.0862052046E+01, 5.2330990780E+00, 2.2390916161E+01, 3.8428296711E+00, 9.7696930523E-01],
	[4.4320000000E+04, 4.0870190192E+01, 5.2331411740E+00, 2.2399163958E+01, 3.8431672112E+00, 9.7697883311E-01],
	[4.4325000000E+04, 4.0878329041E+01, 5.2331832655E+00, 2.2407413860E+01, 3.8435046686E+00, 9.7698835646E-01],
	[4.4330000000E+04, 4.0886468593E+01, 5.2332253527E+00, 2.2415665868E+01, 3.8438420432E+00, 9.7699787528E-01],
	[4.4335000000E+04, 4.0894608847E+01, 5.2332674354E+00, 2.2423919983E+01, 3.8441793351E+00, 9.7700738958E-01],
	[4.4340000000E+04, 4.0902749803E+01, 5.2333095137E+00, 2.2432176205E+01, 3.8445165442E+00, 9.7701689935E-01],
	[4.4345000000E+04, 4.0910891462E+01, 5.2333515877E+00, 2.2440434534E+01, 3.8448536707E+00, 9.7702640459E-01],
	[4.4350000000E+04, 4.0919033823E+01, 5.2333936572E+00, 2.2448694970E+01, 3.8451907145E+00, 9.7703590531E-01],
	[4.4355000000E+04, 4.0927176886E+01, 5.2334357223E+00, 2.2456957514E+01, 3.8455276756E+00, 9.7704540152E-01],
	[4.4360000000E+04, 4.0935320652E+01, 5.2334777830E+00, 2.2465222166E+01, 3.8458645542E+00, 9.7705489321E-01],
	[4.4365000000E+04, 4.0943465120E+01, 5.2335198393E+00, 2.2473488926E+01, 3.8462013501E+00, 9.7706438039E-01],
	[4.4370000000E+04, 4.0951610291E+01, 5.2335618912E+00, 2.2481757795E+01, 3.8465380634E+00, 9.7707386305E-01],
	[4.4375000000E+04, 4.0959756164E+01, 5.2336039387E+00, 2.2490028773E+01, 3.8468746941E+00, 9.7708334121E-01],
	[4.4380000000E+04, 4.0967902739E+01, 5.2336459818E+00, 2.2498301860E+01, 3.8472112423E+00, 9.7709281486E-01],
	[4.4385000000E+04, 4.0976050016E+01, 5.2336880205E+00, 2.2506577056E+01, 3.8475477079E+00, 9.7710228401E-01],
	[4.4390000000E+04, 4.0984197995E+01, 5.2337300548E+00, 2.2514854363E+01, 3.8478840911E+00, 9.7711174865E-01],
	[4.4395000000E+04, 4.0992346677E+01, 5.2337720847E+00, 2.2523133779E+01, 3.8482203917E+00, 9.7712120880E-01],
	[4.4400000000E+04, 4.1000496061E+01, 5.2338141102E+00, 2.2531415306E+01, 3.8485566099E+00, 9.7713066445E-01],
	[4.4405000000E+04, 4.1008646147E+01, 5.2338561313E+00, 2.2539698943E+01, 3.8488927457E+00, 9.7714011561E-01],
	[4.4410000000E+04, 4.1016796935E+01, 5.2338981481E+00, 2.2547984692E+01, 3.8492287990E+00, 9.7714956227E-01],
	[4.4415000000E+04, 4.1024948426E+01, 5.2339401604E+00, 2.2556272552E+01, 3.8495647699E+00, 9.7715900445E-01],
	[4.4420000000E+04, 4.1033100618E+01, 5.2339821683E+00, 2.2564562523E+01, 3.8499006584E+00, 9.7716844214E-01],
	[4.4425000000E+04, 4.1041253513E+01, 5.2340241719E+00, 2.2572854607E+01, 3.8502364645E+00, 9.7717787534E-01],
	[4.4430000000E+04, 4.1049407109E+01, 5.2340661710E+00, 2.2581148802E+01, 3.8505721883E+00, 9.7718730406E-01],
	[4.4435000000E+04, 4.1057561408E+01, 5.2341081658E+00, 2.2589445110E+01, 3.8509078298E+00, 9.7719672830E-01],
	[4.4440000000E+04, 4.1065716409E+01, 5.2341501562E+00, 2.2597743531E+01, 3.8512433889E+00, 9.7720614807E-01],
	[4.4445000000E+04, 4.1073872112E+01, 5.2341921422E+00, 2.2606044065E+01, 3.8515788658E+00, 9.7721556336E-01],
	[4.4450000000E+04, 4.1082028516E+01, 5.2342341238E+00, 2.2614346713E+01, 3.8519142604E+00, 9.7722497418E-01],
	[4.4455000000E+04, 4.1090185623E+01, 5.2342761010E+00, 2.2622651474E+01, 3.8522495728E+00, 9.7723438053E-01],
	[4.4460000000E+04, 4.1098343432E+01, 5.2343180738E+00, 2.2630958349E+01, 3.8525848029E+00, 9.7724378241E-01],
	[4.4465000000E+04, 4.1106501943E+01, 5.2343600423E+00, 2.2639267338E+01, 3.8529199508E+00, 9.7725317982E-01],
	[4.4470000000E+04, 4.1114661155E+01, 5.2344020064E+00, 2.2647578442E+01, 3.8532550166E+00, 9.7726257277E-01],
	[4.4475000000E+04, 4.1122821070E+01, 5.2344439660E+00, 2.2655891661E+01, 3.8535900002E+00, 9.7727196126E-01],
	[4.4480000000E+04, 4.1130981686E+01, 5.2344859213E+00, 2.2664206995E+01, 3.8539249016E+00, 9.7728134530E-01],
	[4.4485000000E+04, 4.1139143004E+01, 5.2345278723E+00, 2.2672524445E+01, 3.8542597209E+00, 9.7729072487E-01],
	[4.4490000000E+04, 4.1147305025E+01, 5.2345698188E+00, 2.2680844010E+01, 3.8545944581E+00, 9.7730010000E-01],
	[4.4495000000E+04, 4.1155467747E+01, 5.2346117610E+00, 2.2689165692E+01, 3.8549291133E+00, 9.7730947067E-01],
	[4.4500000000E+04, 4.1163631170E+01, 5.2346536988E+00, 2.2697489490E+01, 3.8552636863E+00, 9.7731883690E-01],
	[4.4505000000E+04, 4.1171795296E+01, 5.2346956322E+00, 2.2705815404E+01, 3.8555981774E+00, 9.7732819868E-01],
	[4.4510000000E+04, 4.1179960123E+01, 5.2347375612E+00, 2.2714143436E+01, 3.8559325864E+00, 9.7733755601E-01],
	[4.4515000000E+04, 4.1188125653E+01, 5.2347794859E+00, 2.2722473585E+01, 3.8562669134E+00, 9.7734690890E-01],
	[4.4520000000E+04, 4.1196291884E+01, 5.2348214062E+00, 2.2730805852E+01, 3.8566011584E+00, 9.7735625736E-01],
	[4.4525000000E+04, 4.1204458816E+01, 5.2348633221E+00, 2.2739140236E+01, 3.8569353214E+00, 9.7736560138E-01],
	[4.4530000000E+04, 4.1212626451E+01, 5.2349052337E+00, 2.2747476739E+01, 3.8572694025E+00, 9.7737494096E-01],
	[4.4535000000E+04, 4.1220794787E+01, 5.2349471409E+00, 2.2755815360E+01, 3.8576034017E+00, 9.7738427611E-01],
	[4.4540000000E+04, 4.1228963824E+01, 5.2349890437E+00, 2.2764156100E+01, 3.8579373190E+00, 9.7739360683E-01],
	[4.4545000000E+04, 4.1237133564E+01, 5.2350309421E+00, 2.2772498959E+01, 3.8582711545E+00, 9.7740293313E-01],
	[4.4550000000E+04, 4.1245304005E+01, 5.2350728362E+00, 2.2780843937E+01, 3.8586049080E+00, 9.7741225500E-01],
	[4.4555000000E+04, 4.1253475147E+01, 5.2351147259E+00, 2.2789191035E+01, 3.8589385797E+00, 9.7742157245E-01],
	[4.4560000000E+04, 4.1261646992E+01, 5.2351566113E+00, 2.2797540254E+01, 3.8592721696E+00, 9.7743088548E-01],
	[4.4565000000E+04, 4.1269819537E+01, 5.2351984922E+00, 2.2805891592E+01, 3.8596056777E+00, 9.7744019409E-01],
	[4.4570000000E+04, 4.1277992785E+01, 5.2352403689E+00, 2.2814245051E+01, 3.8599391041E+00, 9.7744949828E-01],
	[4.4575000000E+04, 4.1286166734E+01, 5.2352822411E+00, 2.2822600631E+01, 3.8602724486E+00, 9.7745879807E-01],
	[4.4580000000E+04, 4.1294341384E+01, 5.2353241090E+00, 2.2830958332E+01, 3.8606057115E+00, 9.7746809344E-01],
	[4.4585000000E+04, 4.1302519774E+01, 5.2353663194E+00, 2.2839318155E+01, 3.8609391077E+00, 9.7747738440E-01],
	[4.4590000000E+04, 4.1310712282E+01, 5.2354100567E+00, 2.2847680099E+01, 3.8612733726E+00, 9.7748667096E-01],
	[4.4595000000E+04, 4.1318905495E+01, 5.2354537895E+00, 2.2856044166E+01, 3.8616075559E+00, 9.7749595312E-01],
	[4.4600000000E+04, 4.1327099415E+01, 5.2354975178E+00, 2.2864410355E+01, 3.8619416578E+00, 9.7750523087E-01],
	[4.4605000000E+04, 4.1335294042E+01, 5.2355412415E+00, 2.2872778667E+01, 3.8622756783E+00, 9.7751450422E-01],
	[4.4610000000E+04, 4.1343489374E+01, 5.2355849607E+00, 2.2881149101E+01, 3.8626096173E+00, 9.7752377318E-01],
	[4.4615000000E+04, 4.1351685412E+01, 5.2356286754E+00, 2.2889521659E+01, 3.8629434749E+00, 9.7753303775E-01],
	[4.4620000000E+04, 4.1359882156E+01, 5.2356723855E+00, 2.2897896341E+01, 3.8632772512E+00, 9.7754229792E-01],
	[4.4625000000E+04, 4.1368079607E+01, 5.2357160911E+00, 2.2906273146E+01, 3.8636109461E+00, 9.7755155371E-01],
	[4.4630000000E+04, 4.1376277763E+01, 5.2357597922E+00, 2.2914652076E+01, 3.8639445597E+00, 9.7756080511E-01],
	[4.4635000000E+04, 4.1384476625E+01, 5.2358034887E+00, 2.2923033130E+01, 3.8642780919E+00, 9.7757005212E-01],
	[4.4640000000E+04, 4.1392676194E+01, 5.2358471807E+00, 2.2931416309E+01, 3.8646115429E+00, 9.7757929475E-01],
	[4.4645000000E+04, 4.1400876468E+01, 5.2358908682E+00, 2.2939801613E+01, 3.8649449125E+00, 9.7758853300E-01],
	[4.4650000000E+04, 4.1409077448E+01, 5.2359345511E+00, 2.2948189043E+01, 3.8652782010E+00, 9.7759776688E-01],
	[4.4655000000E+04, 4.1417279134E+01, 5.2359782295E+00, 2.2956578598E+01, 3.8656114082E+00, 9.7760699638E-01],
	[4.4660000000E+04, 4.1425481526E+01, 5.2360219034E+00, 2.2964970279E+01, 3.8659445341E+00, 9.7761622151E-01],
	[4.4665000000E+04, 4.1433684624E+01, 5.2360655728E+00, 2.2973364087E+01, 3.8662775789E+00, 9.7762544226E-01],
	[4.4670000000E+04, 4.1441888428E+01, 5.2361092376E+00, 2.2981760021E+01, 3.8666105425E+00, 9.7763465865E-01],
	[4.4675000000E+04, 4.1450092938E+01, 5.2361528980E+00, 2.2990158082E+01, 3.8669434249E+00, 9.7764387068E-01],
	[4.4680000000E+04, 4.1458298153E+01, 5.2361965538E+00, 2.2998558270E+01, 3.8672762263E+00, 9.7765307834E-01],
	[4.4685000000E+04, 4.1466504075E+01, 5.2362402050E+00, 2.3006960586E+01, 3.8676089465E+00, 9.7766228164E-01],
	[4.4690000000E+04, 4.1474710702E+01, 5.2362838518E+00, 2.3015365030E+01, 3.8679415856E+00, 9.7767148058E-01],
	[4.4695000000E+04, 4.1482918035E+01, 5.2363274940E+00, 2.3023771601E+01, 3.8682741436E+00, 9.7768067516E-01],
	[4.4700000000E+04, 4.1491126073E+01, 5.2363711317E+00, 2.3032180301E+01, 3.8686066206E+00, 9.7768986540E-01],
	[4.4705000000E+04, 4.1499334818E+01, 5.2364147649E+00, 2.3040591130E+01, 3.8689390165E+00, 9.7769905128E-01],
	[4.4710000000E+04, 4.1507544268E+01, 5.2364583936E+00, 2.3049004088E+01, 3.8692713314E+00, 9.7770823281E-01],
	[4.4715000000E+04, 4.1515754424E+01, 5.2365020178E+00, 2.3057419175E+01, 3.8696035653E+00, 9.7771740999E-01],
	[4.4720000000E+04, 4.1523965285E+01, 5.2365456375E+00, 2.3065836392E+01, 3.8699357183E+00, 9.7772658283E-01],
	[4.4725000000E+04, 4.1532176852E+01, 5.2365892526E+00, 2.3074255738E+01, 3.8702677903E+00, 9.7773575133E-01],
	[4.4730000000E+04, 4.1540389125E+01, 5.2366328632E+00, 2.3082677215E+01, 3.8705997814E+00, 9.7774491549E-01],
	[4.4735000000E+04, 4.1548602104E+01, 5.2366764693E+00, 2.3091100822E+01, 3.8709316915E+00, 9.7775407531E-01],
	[4.4740000000E+04, 4.1556815788E+01, 5.2367200709E+00, 2.3099526560E+01, 3.8712635208E+00, 9.7776323080E-01],
	[4.4745000000E+04, 4.1565030177E+01, 5.2367636680E+00, 2.3107954430E+01, 3.8715952692E+00, 9.7777238195E-01],
	[4.4750000000E+04, 4.1573245273E+01, 5.2368072606E+00, 2.3116384430E+01, 3.8719269367E+00, 9.7778152877E-01],
	[4.4755000000E+04, 4.1581461073E+01, 5.2368508487E+00, 2.3124816563E+01, 3.8722585234E+00, 9.7779067127E-01],
	[4.4760000000E+04, 4.1589677580E+01, 5.2368944323E+00, 2.3133250827E+01, 3.8725900293E+00, 9.7779980944E-01],
	[4.4765000000E+04, 4.1597894792E+01, 5.2369380114E+00, 2.3141687224E+01, 3.8729214544E+00, 9.7780894329E-01],
	[4.4770000000E+04, 4.1606112709E+01, 5.2369815859E+00, 2.3150125753E+01, 3.8732527988E+00, 9.7781807281E-01],
	[4.4775000000E+04, 4.1614331332E+01, 5.2370251560E+00, 2.3158566415E+01, 3.8735840623E+00, 9.7782719802E-01],
	[4.4780000000E+04, 4.1622550660E+01, 5.2370687215E+00, 2.3167009210E+01, 3.8739152452E+00, 9.7783631891E-01],
	[4.4785000000E+04, 4.1630770694E+01, 5.2371122826E+00, 2.3175454139E+01, 3.8742463473E+00, 9.7784543549E-01],
	[4.4790000000E+04, 4.1638991433E+01, 5.2371558392E+00, 2.3183901202E+01, 3.8745773688E+00, 9.7785454775E-01],
	[4.4795000000E+04, 4.1647212878E+01, 5.2371993912E+00, 2.3192350399E+01, 3.8749083095E+00, 9.7786365571E-01],
	[4.4800000000E+04, 4.1655435028E+01, 5.2372429388E+00, 2.3200801730E+01, 3.8752391696E+00, 9.7787275936E-01],
	[4.4805000000E+04, 4.1663657883E+01, 5.2372864818E+00, 2.3209255196E+01, 3.8755699491E+00, 9.7788185870E-01],
	[4.4810000000E+04, 4.1671881444E+01, 5.2373300204E+00, 2.3217710797E+01, 3.8759006480E+00, 9.7789095375E-01],
	[4.4815000000E+04, 4.1680105710E+01, 5.2373735545E+00, 2.3226168533E+01, 3.8762312663E+00, 9.7790004449E-01],
	[4.4820000000E+04, 4.1688330682E+01, 5.2374170840E+00, 2.3234628405E+01, 3.8765618040E+00, 9.7790913093E-01],
	[4.4825000000E+04, 4.1696556358E+01, 5.2374606091E+00, 2.3243090413E+01, 3.8768922612E+00, 9.7791821308E-01],
	[4.4830000000E+04, 4.1704782740E+01, 5.2375041297E+00, 2.3251554557E+01, 3.8772226378E+00, 9.7792729094E-01],
	[4.4835000000E+04, 4.1713009828E+01, 5.2375476458E+00, 2.3260020837E+01, 3.8775529339E+00, 9.7793636451E-01],
	[4.4840000000E+04, 4.1721237620E+01, 5.2375911574E+00, 2.3268489255E+01, 3.8778831496E+00, 9.7794543378E-01],
	[4.4845000000E+04, 4.1729466118E+01, 5.2376346645E+00, 2.3276959809E+01, 3.8782132847E+00, 9.7795449878E-01],
	[4.4850000000E+04, 4.1737695321E+01, 5.2376781671E+00, 2.3285432501E+01, 3.8785433395E+00, 9.7796355949E-01],
	[4.4855000000E+04, 4.1745925229E+01, 5.2377216652E+00, 2.3293907330E+01, 3.8788733137E+00, 9.7797261591E-01],
	[4.4860000000E+04, 4.1754155842E+01, 5.2377651589E+00, 2.3302384298E+01, 3.8792032076E+00, 9.7798166806E-01],
	[4.4865000000E+04, 4.1762387161E+01, 5.2378086480E+00, 2.3310863404E+01, 3.8795330211E+00, 9.7799071593E-01],
	[4.4870000000E+04, 4.1770619184E+01, 5.2378521327E+00, 2.3319344649E+01, 3.8798627542E+00, 9.7799975953E-01],
	[4.4875000000E+04, 4.1778851913E+01, 5.2378956129E+00, 2.3327828032E+01, 3.8801924070E+00, 9.7800879886E-01],
	[4.4880000000E+04, 4.1787085347E+01, 5.2379390886E+00, 2.3336313555E+01, 3.8805219794E+00, 9.7801783391E-01],
	[4.4885000000E+04, 4.1795319486E+01, 5.2379825598E+00, 2.3344801217E+01, 3.8808514715E+00, 9.7802686470E-01],
	[4.4890000000E+04, 4.1803554330E+01, 5.2380260266E+00, 2.3353291019E+01, 3.8811808834E+00, 9.7803589122E-01],
	[4.4895000000E+04, 4.1811789879E+01, 5.2380694888E+00, 2.3361782961E+01, 3.8815102149E+00, 9.7804491348E-01],
	[4.4900000000E+04, 4.1820026133E+01, 5.2381129466E+00, 2.3370277043E+01, 3.8818394663E+00, 9.7805393148E-01],
	[4.4905000000E+04, 4.1828263092E+01, 5.2381563999E+00, 2.3378773267E+01, 3.8821686374E+00, 9.7806294523E-01],
	[4.4910000000E+04, 4.1836500756E+01, 5.2381998488E+00, 2.3387271631E+01, 3.8824977282E+00, 9.7807195471E-01],
	[4.4915000000E+04, 4.1844739125E+01, 5.2382432931E+00, 2.3395772137E+01, 3.8828267389E+00, 9.7808095995E-01],
	[4.4920000000E+04, 4.1852978199E+01, 5.2382867330E+00, 2.3404274784E+01, 3.8831556695E+00, 9.7808996093E-01],
	[4.4925000000E+04, 4.1861217978E+01, 5.2383301684E+00, 2.3412779573E+01, 3.8834845198E+00, 9.7809895766E-01],
	[4.4930000000E+04, 4.1869458462E+01, 5.2383735993E+00, 2.3421286504E+01, 3.8838132901E+00, 9.7810795015E-01],
	[4.4935000000E+04, 4.1877699651E+01, 5.2384170258E+00, 2.3429795578E+01, 3.8841419802E+00, 9.7811693839E-01],
	[4.4940000000E+04, 4.1885941545E+01, 5.2384604477E+00, 2.3438306795E+01, 3.8844705903E+00, 9.7812592239E-01],
	[4.4945000000E+04, 4.1894184143E+01, 5.2385038652E+00, 2.3446820155E+01, 3.8847991203E+00, 9.7813490215E-01],
	[4.4950000000E+04, 4.1902427447E+01, 5.2385472783E+00, 2.3455335658E+01, 3.8851275702E+00, 9.7814387767E-01],
	[4.4955000000E+04, 4.1910671455E+01, 5.2385906868E+00, 2.3463853305E+01, 3.8854559401E+00, 9.7815284896E-01],
	[4.4960000000E+04, 4.1918916168E+01, 5.2386340910E+00, 2.3472373096E+01, 3.8857842300E+00, 9.7816181602E-01],
	[4.4965000000E+04, 4.1927161586E+01, 5.2386774906E+00, 2.3480895032E+01, 3.8861124399E+00, 9.7817077884E-01],
	[4.4970000000E+04, 4.1935407709E+01, 5.2387208858E+00, 2.3489419112E+01, 3.8864405699E+00, 9.7817973744E-01],
	[4.4975000000E+04, 4.1943654536E+01, 5.2387642765E+00, 2.3497945337E+01, 3.8867686199E+00, 9.7818869181E-01],
	[4.4980000000E+04, 4.1951902068E+01, 5.2388076627E+00, 2.3506473707E+01, 3.8870965900E+00, 9.7819764196E-01],
	[4.4985000000E+04, 4.1960150305E+01, 5.2388510445E+00, 2.3515004222E+01, 3.8874244801E+00, 9.7820658788E-01],
	[4.4990000000E+04, 4.1968399246E+01, 5.2388944218E+00, 2.3523536884E+01, 3.8877522904E+00, 9.7821552959E-01],
	[4.4995000000E+04, 4.1976648893E+01, 5.2389377946E+00, 2.3532071692E+01, 3.8880800208E+00, 9.7822446708E-01],
	[4.5000000000E+04, 4.1984899244E+01, 5.2389811630E+00, 2.3540608646E+01, 3.8884076714E+00, 9.7823340036E-01],
	[4.5005000000E+04, 4.1993150299E+01, 5.2390245270E+00, 2.3549165577E+01, 3.8887357283E+00, 9.7824232942E-01],
	[4.5010000000E+04, 4.2001402059E+01, 5.2390678864E+00, 2.3557724665E+01, 3.8890637052E+00, 9.7825125428E-01],
	[4.5015000000E+04, 4.2009654524E+01, 5.2391112414E+00, 2.3566285913E+01, 3.8893916021E+00, 9.7826017492E-01],
	[4.5020000000E+04, 4.2017907694E+01, 5.2391545920E+00, 2.3574849318E+01, 3.8897194189E+00, 9.7826909136E-01],
	[4.5025000000E+04, 4.2026161567E+01, 5.2391979381E+00, 2.3583414883E+01, 3.8900471558E+00, 9.7827800360E-01],
	[4.5030000000E+04, 4.2034416146E+01, 5.2392412798E+00, 2.3591982607E+01, 3.8903748127E+00, 9.7828691164E-01],
	[4.5035000000E+04, 4.2042671429E+01, 5.2392846170E+00, 2.3600552490E+01, 3.8907023896E+00, 9.7829581548E-01],
	[4.5040000000E+04, 4.2050927417E+01, 5.2393279497E+00, 2.3609124534E+01, 3.8910298866E+00, 9.7830471513E-01],
	[4.5045000000E+04, 4.2059184109E+01, 5.2393712780E+00, 2.3617698737E+01, 3.8913573037E+00, 9.7831361058E-01],
	[4.5050000000E+04, 4.2067441505E+01, 5.2394146018E+00, 2.3626275101E+01, 3.8916846410E+00, 9.7832250184E-01],
	[4.5055000000E+04, 4.2075699606E+01, 5.2394579212E+00, 2.3634853626E+01, 3.8920118983E+00, 9.7833138890E-01],
	[4.5060000000E+04, 4.2083958412E+01, 5.2395012362E+00, 2.3643434311E+01, 3.8923390758E+00, 9.7834027179E-01],
	[4.5065000000E+04, 4.2092217922E+01, 5.2395445466E+00, 2.3652017159E+01, 3.8926661735E+00, 9.7834915049E-01],
	[4.5070000000E+04, 4.2100478136E+01, 5.2395878527E+00, 2.3660602167E+01, 3.8929931913E+00, 9.7835802500E-01],
	[4.5075000000E+04, 4.2108739055E+01, 5.2396311543E+00, 2.3669189338E+01, 3.8933201294E+00, 9.7836689534E-01],
	[4.5080000000E+04, 4.2117000678E+01, 5.2396744514E+00, 2.3677778671E+01, 3.8936469877E+00, 9.7837576150E-01],
	[4.5085000000E+04, 4.2125263006E+01, 5.2397177442E+00, 2.3686370167E+01, 3.8939737663E+00, 9.7838462348E-01],
	[4.5090000000E+04, 4.2133526037E+01, 5.2397610324E+00, 2.3694963825E+01, 3.8943004651E+00, 9.7839348129E-01],
	[4.5095000000E+04, 4.2141789774E+01, 5.2398043162E+00, 2.3703559647E+01, 3.8946270843E+00, 9.7840233493E-01],
	[4.5100000000E+04, 4.2150054214E+01, 5.2398475956E+00, 2.3712157632E+01, 3.8949536237E+00, 9.7841118440E-01],
	[4.5105000000E+04, 4.2158319359E+01, 5.2398908706E+00, 2.3720757781E+01, 3.8952800835E+00, 9.7842002970E-01],
	[4.5110000000E+04, 4.2166585208E+01, 5.2399341411E+00, 2.3729360094E+01, 3.8956064636E+00, 9.7842887084E-01],
	[4.5115000000E+04, 4.2174851761E+01, 5.2399774071E+00, 2.3737964571E+01, 3.8959327641E+00, 9.7843770782E-01],
	[4.5120000000E+04, 4.2183119019E+01, 5.2400206688E+00, 2.3746571213E+01, 3.8962589850E+00, 9.7844654064E-01],
	[4.5125000000E+04, 4.2191386980E+01, 5.2400639259E+00, 2.3755180020E+01, 3.8965851263E+00, 9.7845536930E-01],
	[4.5130000000E+04, 4.2199655646E+01, 5.2401071787E+00, 2.3763790993E+01, 3.8969111881E+00, 9.7846419380E-01],
	[4.5135000000E+04, 4.2207925016E+01, 5.2401504270E+00, 2.3772404131E+01, 3.8972371703E+00, 9.7847301415E-01],
	[4.5140000000E+04, 4.2216195091E+01, 5.2401936709E+00, 2.3781019435E+01, 3.8975630729E+00, 9.7848183036E-01],
	[4.5145000000E+04, 4.2224465869E+01, 5.2402369104E+00, 2.3789636905E+01, 3.8978888961E+00, 9.7849064241E-01],
	[4.5150000000E+04, 4.2232737352E+01, 5.2402801454E+00, 2.3798256542E+01, 3.8982146398E+00, 9.7849945032E-01],
	[4.5155000000E+04, 4.2241009538E+01, 5.2403233760E+00, 2.3806878345E+01, 3.8985403040E+00, 9.7850825408E-01],
	[4.5160000000E+04, 4.2249282429E+01, 5.2403666021E+00, 2.3815502316E+01, 3.8988658887E+00, 9.7851705371E-01],
	[4.5165000000E+04, 4.2257556024E+01, 5.2404098239E+00, 2.3824128454E+01, 3.8991913941E+00, 9.7852584919E-01],
	[4.5170000000E+04, 4.2265830323E+01, 5.2404530412E+00, 2.3832756760E+01, 3.8995168200E+00, 9.7853464053E-01],
	[4.5175000000E+04, 4.2274105326E+01, 5.2404962540E+00, 2.3841387234E+01, 3.8998421666E+00, 9.7854342774E-01],
	[4.5180000000E+04, 4.2282381033E+01, 5.2405394625E+00, 2.3850019876E+01, 3.9001674338E+00, 9.7855221081E-01],
	[4.5185000000E+04, 4.2290657443E+01, 5.2405826665E+00, 2.3858654687E+01, 3.9004926216E+00, 9.7856098975E-01],
	[4.5190000000E+04, 4.2298934558E+01, 5.2406258661E+00, 2.3867291667E+01, 3.9008177301E+00, 9.7856976456E-01],
	[4.5195000000E+04, 4.2307212377E+01, 5.2406690613E+00, 2.3875930816E+01, 3.9011427593E+00, 9.7857853524E-01],
	[4.5200000000E+04, 4.2315490900E+01, 5.2407122520E+00, 2.3884572135E+01, 3.9014677092E+00, 9.7858730180E-01],
	[4.5205000000E+04, 4.2323770127E+01, 5.2407554384E+00, 2.3893215624E+01, 3.9017925799E+00, 9.7859606423E-01],
	[4.5210000000E+04, 4.2332050057E+01, 5.2407986203E+00, 2.3901861283E+01, 3.9021173713E+00, 9.7860482254E-01],
	[4.5215000000E+04, 4.2340330692E+01, 5.2408417978E+00, 2.3910509112E+01, 3.9024420835E+00, 9.7861357673E-01],
	[4.5220000000E+04, 4.2348612030E+01, 5.2408849708E+00, 2.3919159112E+01, 3.9027667165E+00, 9.7862232679E-01],
	[4.5225000000E+04, 4.2356894073E+01, 5.2409281395E+00, 2.3927811283E+01, 3.9030912703E+00, 9.7863107275E-01],
	[4.5230000000E+04, 4.2365176819E+01, 5.2409713037E+00, 2.3936465626E+01, 3.9034157449E+00, 9.7863981459E-01],
	[4.5235000000E+04, 4.2373460269E+01, 5.2410144635E+00, 2.3945122140E+01, 3.9037401404E+00, 9.7864855231E-01],
	[4.5240000000E+04, 4.2381744422E+01, 5.2410576189E+00, 2.3953780826E+01, 3.9040644568E+00, 9.7865728593E-01],
	[4.5245000000E+04, 4.2390029280E+01, 5.2411007699E+00, 2.3962441685E+01, 3.9043886940E+00, 9.7866601544E-01],
	[4.5250000000E+04, 4.2398314841E+01, 5.2411439165E+00, 2.3971104716E+01, 3.9047128522E+00, 9.7867474084E-01],
	[4.5255000000E+04, 4.2406601106E+01, 5.2411870587E+00, 2.3979769920E+01, 3.9050369313E+00, 9.7868346213E-01],
	[4.5260000000E+04, 4.2414888075E+01, 5.2412301964E+00, 2.3988437298E+01, 3.9053609314E+00, 9.7869217933E-01],
	[4.5265000000E+04, 4.2423175747E+01, 5.2412733298E+00, 2.3997106849E+01, 3.9056848524E+00, 9.7870089242E-01],
	[4.5270000000E+04, 4.2431464124E+01, 5.2413164587E+00, 2.4005778573E+01, 3.9060086945E+00, 9.7870960142E-01],
	[4.5275000000E+04, 4.2439753203E+01, 5.2413595833E+00, 2.4014452472E+01, 3.9063324575E+00, 9.7871830632E-01],
	[4.5280000000E+04, 4.2448042987E+01, 5.2414027034E+00, 2.4023128546E+01, 3.9066561416E+00, 9.7872700713E-01],
	[4.5285000000E+04, 4.2456333474E+01, 5.2414458191E+00, 2.4031806794E+01, 3.9069797468E+00, 9.7873570384E-01],
	[4.5290000000E+04, 4.2464624665E+01, 5.2414889304E+00, 2.4040487217E+01, 3.9073032730E+00, 9.7874439646E-01],
	[4.5295000000E+04, 4.2472916559E+01, 5.2415320373E+00, 2.4049169815E+01, 3.9076267203E+00, 9.7875308500E-01],
	[4.5300000000E+04, 4.2481209157E+01, 5.2415751398E+00, 2.4057854589E+01, 3.9079500888E+00, 9.7876176945E-01],
	[4.5305000000E+04, 4.2489512876E+01, 5.2416194065E+00, 2.4066541539E+01, 3.9082741162E+00, 9.7877044981E-01],
	[4.5310000000E+04, 4.2497823263E+01, 5.2416643373E+00, 2.4075230666E+01, 3.9085984870E+00, 9.7877912609E-01],
	[4.5315000000E+04, 4.2506134357E+01, 5.2417092635E+00, 2.4083921969E+01, 3.9089227792E+00, 9.7878779829E-01],
	[4.5320000000E+04, 4.2514446160E+01, 5.2417541851E+00, 2.4092615449E+01, 3.9092469929E+00, 9.7879646642E-01],
	[4.5325000000E+04, 4.2522758671E+01, 5.2417991022E+00, 2.4101311106E+01, 3.9095711279E+00, 9.7880513047E-01],
	[4.5330000000E+04, 4.2531071890E+01, 5.2418440147E+00, 2.4110008940E+01, 3.9098951843E+00, 9.7881379044E-01],
	[4.5335000000E+04, 4.2539385817E+01, 5.2418889226E+00, 2.4118708952E+01, 3.9102191622E+00, 9.7882244634E-01],
	[4.5340000000E+04, 4.2547700452E+01, 5.2419338260E+00, 2.4127411143E+01, 3.9105430615E+00, 9.7883109817E-01],
	[4.5345000000E+04, 4.2556015796E+01, 5.2419787247E+00, 2.4136115511E+01, 3.9108668823E+00, 9.7883974593E-01],
	[4.5350000000E+04, 4.2564331847E+01, 5.2420236190E+00, 2.4144822059E+01, 3.9111906246E+00, 9.7884838963E-01],
	[4.5355000000E+04, 4.2572648606E+01, 5.2420685086E+00, 2.4153530785E+01, 3.9115142885E+00, 9.7885702926E-01],
	[4.5360000000E+04, 4.2580966073E+01, 5.2421133937E+00, 2.4162241691E+01, 3.9118378738E+00, 9.7886566483E-01],
	[4.5365000000E+04, 4.2589284248E+01, 5.2421582743E+00, 2.4170954777E+01, 3.9121613808E+00, 9.7887429634E-01],
	[4.5370000000E+04, 4.2597603131E+01, 5.2422031502E+00, 2.4179670042E+01, 3.9124848093E+00, 9.7888292379E-01],
	[4.5375000000E+04, 4.2605922722E+01, 5.2422480216E+00, 2.4188387488E+01, 3.9128081594E+00, 9.7889154719E-01],
	[4.5380000000E+04, 4.2614243021E+01, 5.2422928885E+00, 2.4197107114E+01, 3.9131314311E+00, 9.7890016653E-01],
	[4.5385000000E+04, 4.2622564027E+01, 5.2423377508E+00, 2.4205828921E+01, 3.9134546245E+00, 9.7890878182E-01],
	[4.5390000000E+04, 4.2630885742E+01, 5.2423826085E+00, 2.4214552909E+01, 3.9137777396E+00, 9.7891739306E-01],
	[4.5395000000E+04, 4.2639208164E+01, 5.2424274617E+00, 2.4223279078E+01, 3.9141007763E+00, 9.7892600025E-01],
	[4.5400000000E+04, 4.2647531294E+01, 5.2424723103E+00, 2.4232007430E+01, 3.9144237347E+00, 9.7893460340E-01],
	[4.5405000000E+04, 4.2655855132E+01, 5.2425171544E+00, 2.4240737963E+01, 3.9147466148E+00, 9.7894320250E-01],
	[4.5410000000E+04, 4.2664179678E+01, 5.2425619939E+00, 2.4249470679E+01, 3.9150694167E+00, 9.7895179755E-01],
	[4.5415000000E+04, 4.2672504932E+01, 5.2426068288E+00, 2.4258205577E+01, 3.9153921403E+00, 9.7896038857E-01],
	[4.5420000000E+04, 4.2680830893E+01, 5.2426516592E+00, 2.4266942658E+01, 3.9157147858E+00, 9.7896897555E-01],
	[4.5425000000E+04, 4.2689157562E+01, 5.2426964851E+00, 2.4275681923E+01, 3.9160373530E+00, 9.7897755850E-01],
	[4.5430000000E+04, 4.2697484939E+01, 5.2427413064E+00, 2.4284423371E+01, 3.9163598420E+00, 9.7898613741E-01],
	[4.5435000000E+04, 4.2705813023E+01, 5.2427861231E+00, 2.4293167003E+01, 3.9166822529E+00, 9.7899471228E-01],
	[4.5440000000E+04, 4.2714141815E+01, 5.2428309353E+00, 2.4301912819E+01, 3.9170045856E+00, 9.7900328313E-01],
	[4.5445000000E+04, 4.2722471315E+01, 5.2428757430E+00, 2.4310660820E+01, 3.9173268402E+00, 9.7901184995E-01],
	[4.5450000000E+04, 4.2730801523E+01, 5.2429205461E+00, 2.4319411006E+01, 3.9176490167E+00, 9.7902041274E-01],
	[4.5455000000E+04, 4.2739132438E+01, 5.2429653447E+00, 2.4328163376E+01, 3.9179711152E+00, 9.7902897151E-01],
	[4.5460000000E+04, 4.2747464060E+01, 5.2430101387E+00, 2.4336917932E+01, 3.9182931355E+00, 9.7903752626E-01],
	[4.5465000000E+04, 4.2755796391E+01, 5.2430549282E+00, 2.4345674674E+01, 3.9186150779E+00, 9.7904607698E-01],
	[4.5470000000E+04, 4.2764129428E+01, 5.2430997131E+00, 2.4354433602E+01, 3.9189369422E+00, 9.7905462369E-01],
	[4.5475000000E+04, 4.2772463174E+01, 5.2431444935E+00, 2.4363194716E+01, 3.9192587285E+00, 9.7906316638E-01],
	[4.5480000000E+04, 4.2780797627E+01, 5.2431892693E+00, 2.4371958017E+01, 3.9195804368E+00, 9.7907170506E-01],
	[4.5485000000E+04, 4.2789132787E+01, 5.2432340406E+00, 2.4380723505E+01, 3.9199020671E+00, 9.7908023972E-01],
	[4.5490000000E+04, 4.2797468655E+01, 5.2432788074E+00, 2.4389491179E+01, 3.9202236196E+00, 9.7908877038E-01],
	[4.5495000000E+04, 4.2805805230E+01, 5.2433235696E+00, 2.4398261042E+01, 3.9205450941E+00, 9.7909729702E-01],
	[4.5500000000E+04, 4.2814142513E+01, 5.2433683273E+00, 2.4407033092E+01, 3.9208664906E+00, 9.7910581966E-01],
	[4.5505000000E+04, 4.2822480504E+01, 5.2434130805E+00, 2.4415807331E+01, 3.9211878094E+00, 9.7911433830E-01],
	[4.5510000000E+04, 4.2830819201E+01, 5.2434578291E+00, 2.4424583758E+01, 3.9215090502E+00, 9.7912285293E-01],
	[4.5515000000E+04, 4.2839158607E+01, 5.2435025732E+00, 2.4433362373E+01, 3.9218302132E+00, 9.7913136357E-01],
	[4.5520000000E+04, 4.2847498719E+01, 5.2435473127E+00, 2.4442143178E+01, 3.9221512984E+00, 9.7913987020E-01],
	[4.5525000000E+04, 4.2855839539E+01, 5.2435920478E+00, 2.4450926172E+01, 3.9224723057E+00, 9.7914837284E-01],
	[4.5530000000E+04, 4.2864181067E+01, 5.2436367783E+00, 2.4459711356E+01, 3.9227932353E+00, 9.7915687148E-01],
	[4.5535000000E+04, 4.2872523301E+01, 5.2436815042E+00, 2.4468498730E+01, 3.9231140872E+00, 9.7916536613E-01],
	[4.5540000000E+04, 4.2880866243E+01, 5.2437262256E+00, 2.4477288294E+01, 3.9234348612E+00, 9.7917385680E-01],
	[4.5545000000E+04, 4.2889209893E+01, 5.2437709426E+00, 2.4486080048E+01, 3.9237555576E+00, 9.7918234347E-01],
	[4.5550000000E+04, 4.2897554249E+01, 5.2438156549E+00, 2.4494873994E+01, 3.9240761763E+00, 9.7919082616E-01],
	[4.5555000000E+04, 4.2905899313E+01, 5.2438603628E+00, 2.4503670130E+01, 3.9243967172E+00, 9.7919930486E-01],
	[4.5560000000E+04, 4.2914245084E+01, 5.2439050661E+00, 2.4512468459E+01, 3.9247171805E+00, 9.7920777958E-01],
	[4.5565000000E+04, 4.2922591562E+01, 5.2439497649E+00, 2.4521268979E+01, 3.9250375662E+00, 9.7921625032E-01],
	[4.5570000000E+04, 4.2930938748E+01, 5.2439944592E+00, 2.4530071691E+01, 3.9253578742E+00, 9.7922471708E-01],
	[4.5575000000E+04, 4.2939286641E+01, 5.2440391489E+00, 2.4538876595E+01, 3.9256781047E+00, 9.7923317986E-01],
	[4.5580000000E+04, 4.2947635241E+01, 5.2440838342E+00, 2.4547683693E+01, 3.9259982575E+00, 9.7924163867E-01],
	[4.5585000000E+04, 4.2955984548E+01, 5.2441285149E+00, 2.4556492983E+01, 3.9263183328E+00, 9.7925009351E-01],
	[4.5590000000E+04, 4.2964334562E+01, 5.2441731910E+00, 2.4565304467E+01, 3.9266383305E+00, 9.7925854437E-01],
	[4.5595000000E+04, 4.2972685284E+01, 5.2442178627E+00, 2.4574118144E+01, 3.9269582507E+00, 9.7926699127E-01],
	[4.5600000000E+04, 4.2981036712E+01, 5.2442625299E+00, 2.4582934015E+01, 3.9272780934E+00, 9.7927543420E-01],
	[4.5605000000E+04, 4.2989388848E+01, 5.2443071925E+00, 2.4591752081E+01, 3.9275978587E+00, 9.7928387317E-01],
	[4.5610000000E+04, 4.2997741690E+01, 5.2443518506E+00, 2.4600572341E+01, 3.9279175464E+00, 9.7929230817E-01],
	[4.5615000000E+04, 4.3006095240E+01, 5.2443965042E+00, 2.4609394795E+01, 3.9282371567E+00, 9.7930073922E-01],
	[4.5620000000E+04, 4.3014449497E+01, 5.2444411533E+00, 2.4618219446E+01, 3.9285566896E+00, 9.7930916630E-01],
	[4.5625000000E+04, 4.3022804461E+01, 5.2444857979E+00, 2.4627046291E+01, 3.9288761451E+00, 9.7931758943E-01],
	[4.5630000000E+04, 4.3031160132E+01, 5.2445304380E+00, 2.4635875332E+01, 3.9291955231E+00, 9.7932600861E-01],
	[4.5635000000E+04, 4.3039516509E+01, 5.2445750735E+00, 2.4644706570E+01, 3.9295148238E+00, 9.7933442383E-01],
	[4.5640000000E+04, 4.3047873594E+01, 5.2446197046E+00, 2.4653540003E+01, 3.9298340472E+00, 9.7934283510E-01],
	[4.5645000000E+04, 4.3056231386E+01, 5.2446643311E+00, 2.4662375634E+01, 3.9301531933E+00, 9.7935124242E-01],
	[4.5650000000E+04, 4.3064589885E+01, 5.2447089531E+00, 2.4671213461E+01, 3.9304722620E+00, 9.7935964579E-01],
	[4.5655000000E+04, 4.3072949090E+01, 5.2447535706E+00, 2.4680053486E+01, 3.9307912534E+00, 9.7936804522E-01],
	[4.5660000000E+04, 4.3081309003E+01, 5.2447981836E+00, 2.4688895708E+01, 3.9311101676E+00, 9.7937644071E-01],
	[4.5665000000E+04, 4.3089669622E+01, 5.2448427921E+00, 2.4697740129E+01, 3.9314290045E+00, 9.7938483226E-01],
	[4.5670000000E+04, 4.3098030948E+01, 5.2448873961E+00, 2.4706586747E+01, 3.9317477642E+00, 9.7939321986E-01],
	[4.5675000000E+04, 4.3106392982E+01, 5.2449319956E+00, 2.4715435564E+01, 3.9320664467E+00, 9.7940160353E-01],
	[4.5680000000E+04, 4.3114755721E+01, 5.2449765906E+00, 2.4724286580E+01, 3.9323850520E+00, 9.7940998327E-01],
	[4.5685000000E+04, 4.3123119168E+01, 5.2450211811E+00, 2.4733139795E+01, 3.9327035801E+00, 9.7941835907E-01],
	[4.5690000000E+04, 4.3131483322E+01, 5.2450657671E+00, 2.4741995209E+01, 3.9330220311E+00, 9.7942673094E-01],
	[4.5695000000E+04, 4.3139848182E+01, 5.2451103486E+00, 2.4750852823E+01, 3.9333404050E+00, 9.7943509889E-01],
	[4.5700000000E+04, 4.3148213749E+01, 5.2451549256E+00, 2.4759712638E+01, 3.9336587017E+00, 9.7944346290E-01],
	[4.5705000000E+04, 4.3156580023E+01, 5.2451994981E+00, 2.4768574652E+01, 3.9339769214E+00, 9.7945182299E-01],
	[4.5710000000E+04, 4.3164947004E+01, 5.2452440661E+00, 2.4777438867E+01, 3.9342950639E+00, 9.7946017916E-01],
	[4.5715000000E+04, 4.3173314691E+01, 5.2452886296E+00, 2.4786305283E+01, 3.9346131295E+00, 9.7946853141E-01],
	[4.5720000000E+04, 4.3181683085E+01, 5.2453331886E+00, 2.4795173901E+01, 3.9349311180E+00, 9.7947687973E-01],
	[4.5725000000E+04, 4.3190052185E+01, 5.2453777431E+00, 2.4804044720E+01, 3.9352490295E+00, 9.7948522414E-01],
	[4.5730000000E+04, 4.3198421993E+01, 5.2454222931E+00, 2.4812917740E+01, 3.9355668640E+00, 9.7949356464E-01],
	[4.5735000000E+04, 4.3206792507E+01, 5.2454668386E+00, 2.4821792964E+01, 3.9358846215E+00, 9.7950190122E-01],
	[4.5740000000E+04, 4.3215163727E+01, 5.2455113797E+00, 2.4830670389E+01, 3.9362023020E+00, 9.7951023389E-01],
	[4.5745000000E+04, 4.3223535654E+01, 5.2455559162E+00, 2.4839550017E+01, 3.9365199057E+00, 9.7951856265E-01],
	[4.5750000000E+04, 4.3231908288E+01, 5.2456004483E+00, 2.4848431849E+01, 3.9368374324E+00, 9.7952688751E-01],
	[4.5755000000E+04, 4.3240281628E+01, 5.2456449758E+00, 2.4857315883E+01, 3.9371548822E+00, 9.7953520846E-01],
	[4.5760000000E+04, 4.3248655675E+01, 5.2456894989E+00, 2.4866202122E+01, 3.9374722552E+00, 9.7954352550E-01],
	[4.5765000000E+04, 4.3257030429E+01, 5.2457340175E+00, 2.4875090565E+01, 3.9377895513E+00, 9.7955183864E-01],
	[4.5770000000E+04, 4.3265405888E+01, 5.2457785316E+00, 2.4883981211E+01, 3.9381067706E+00, 9.7956014789E-01],
	[4.5775000000E+04, 4.3273782055E+01, 5.2458230412E+00, 2.4892874063E+01, 3.9384239130E+00, 9.7956845324E-01],
	[4.5780000000E+04, 4.3282158928E+01, 5.2458675464E+00, 2.4901769119E+01, 3.9387409787E+00, 9.7957675469E-01],
	[4.5785000000E+04, 4.3290536507E+01, 5.2459120470E+00, 2.4910666381E+01, 3.9390579676E+00, 9.7958505224E-01],
	[4.5790000000E+04, 4.3298914793E+01, 5.2459565432E+00, 2.4919565848E+01, 3.9393748797E+00, 9.7959334591E-01],
	[4.5795000000E+04, 4.3307293785E+01, 5.2460010349E+00, 2.4928467521E+01, 3.9396917151E+00, 9.7960163569E-01],
	[4.5800000000E+04, 4.3315673484E+01, 5.2460455221E+00, 2.4937371400E+01, 3.9400084738E+00, 9.7960992158E-01],
	[4.5805000000E+04, 4.3324053888E+01, 5.2460900048E+00, 2.4946277486E+01, 3.9403251558E+00, 9.7961820358E-01],
	[4.5810000000E+04, 4.3332435000E+01, 5.2461344831E+00, 2.4955185778E+01, 3.9406417611E+00, 9.7962648170E-01],
	[4.5815000000E+04, 4.3340816818E+01, 5.2461789568E+00, 2.4964096278E+01, 3.9409582898E+00, 9.7963475594E-01],
	[4.5820000000E+04, 4.3349199342E+01, 5.2462234261E+00, 2.4973008984E+01, 3.9412747418E+00, 9.7964302629E-01],
	[4.5825000000E+04, 4.3357582572E+01, 5.2462678909E+00, 2.4981923899E+01, 3.9415911172E+00, 9.7965129277E-01],
	[4.5830000000E+04, 4.3365966509E+01, 5.2463123513E+00, 2.4990841021E+01, 3.9419074160E+00, 9.7965955538E-01],
	[4.5835000000E+04, 4.3374351152E+01, 5.2463568072E+00, 2.4999760352E+01, 3.9422236382E+00, 9.7966781411E-01],
	[4.5840000000E+04, 4.3382736501E+01, 5.2464012586E+00, 2.5008681891E+01, 3.9425397839E+00, 9.7967606897E-01],
	[4.5845000000E+04, 4.3391122556E+01, 5.2464457055E+00, 2.5017605640E+01, 3.9428558531E+00, 9.7968431996E-01],
	[4.5850000000E+04, 4.3399509318E+01, 5.2464901480E+00, 2.5026531597E+01, 3.9431718457E+00, 9.7969256708E-01],
	[4.5855000000E+04, 4.3407896786E+01, 5.2465345859E+00, 2.5035459764E+01, 3.9434877618E+00, 9.7970081033E-01],
	[4.5860000000E+04, 4.3416284960E+01, 5.2465790195E+00, 2.5044390141E+01, 3.9438036014E+00, 9.7970904972E-01],
	[4.5865000000E+04, 4.3424673840E+01, 5.2466234485E+00, 2.5053322728E+01, 3.9441193646E+00, 9.7971728525E-01],
	[4.5870000000E+04, 4.3433063427E+01, 5.2466678731E+00, 2.5062257525E+01, 3.9444350514E+00, 9.7972551692E-01],
	[4.5875000000E+04, 4.3441453720E+01, 5.2467122932E+00, 2.5071194533E+01, 3.9447506617E+00, 9.7973374473E-01],
	[4.5880000000E+04, 4.3449844718E+01, 5.2467567089E+00, 2.5080133752E+01, 3.9450661956E+00, 9.7974196868E-01],
	[4.5885000000E+04, 4.3458236423E+01, 5.2468011201E+00, 2.5089075183E+01, 3.9453816532E+00, 9.7975018878E-01],
	[4.5890000000E+04, 4.3466628834E+01, 5.2468455268E+00, 2.5098018825E+01, 3.9456970343E+00, 9.7975840502E-01],
	[4.5895000000E+04, 4.3475021951E+01, 5.2468899291E+00, 2.5106964679E+01, 3.9460123392E+00, 9.7976661742E-01],
	[4.5900000000E+04, 4.3483415774E+01, 5.2469343269E+00, 2.5115912745E+01, 3.9463275677E+00, 9.7977482597E-01],
	[4.5905000000E+04, 4.3491810303E+01, 5.2469787202E+00, 2.5124863024E+01, 3.9466427199E+00, 9.7978303067E-01],
	[4.5910000000E+04, 4.3500205539E+01, 5.2470231091E+00, 2.5133815516E+01, 3.9469577959E+00, 9.7979123152E-01],
	[4.5915000000E+04, 4.3508601480E+01, 5.2470674935E+00, 2.5142770220E+01, 3.9472727955E+00, 9.7979942854E-01],
	[4.5920000000E+04, 4.3516998127E+01, 5.2471118735E+00, 2.5151727139E+01, 3.9475877190E+00, 9.7980762171E-01],
	[4.5925000000E+04, 4.3525395480E+01, 5.2471562490E+00, 2.5160686271E+01, 3.9479025662E+00, 9.7981581104E-01],
	[4.5930000000E+04, 4.3533793539E+01, 5.2472006200E+00, 2.5169647617E+01, 3.9482173372E+00, 9.7982399654E-01],
	[4.5935000000E+04, 4.3542192304E+01, 5.2472449866E+00, 2.5178611178E+01, 3.9485320320E+00, 9.7983217821E-01],
	[4.5940000000E+04, 4.3550591775E+01, 5.2472893488E+00, 2.5187576953E+01, 3.9488466507E+00, 9.7984035603E-01],
	[4.5945000000E+04, 4.3558991952E+01, 5.2473337065E+00, 2.5196544944E+01, 3.9491611932E+00, 9.7984853003E-01],
	[4.5950000000E+04, 4.3567392834E+01, 5.2473780597E+00, 2.5205515149E+01, 3.9494756596E+00, 9.7985670020E-01],
	[4.5955000000E+04, 4.3575794423E+01, 5.2474224085E+00, 2.5214487571E+01, 3.9497900499E+00, 9.7986486655E-01],
	[4.5960000000E+04, 4.3584196717E+01, 5.2474667528E+00, 2.5223462208E+01, 3.9501043641E+00, 9.7987302906E-01],
	[4.5965000000E+04, 4.3592599718E+01, 5.2475110927E+00, 2.5232439061E+01, 3.9504186022E+00, 9.7988118776E-01],
	[4.5970000000E+04, 4.3601003424E+01, 5.2475554282E+00, 2.5241418131E+01, 3.9507327643E+00, 9.7988934263E-01],
	[4.5975000000E+04, 4.3609407835E+01, 5.2475997592E+00, 2.5250399418E+01, 3.9510468504E+00, 9.7989749369E-01],
	[4.5980000000E+04, 4.3617812953E+01, 5.2476440857E+00, 2.5259382922E+01, 3.9513608605E+00, 9.7990564092E-01],
	[4.5985000000E+04, 4.3626218776E+01, 5.2476884078E+00, 2.5268368644E+01, 3.9516747945E+00, 9.7991378434E-01],
	[4.5990000000E+04, 4.3634625306E+01, 5.2477327255E+00, 2.5277356583E+01, 3.9519886526E+00, 9.7992192395E-01],
	[4.5995000000E+04, 4.3643032540E+01, 5.2477770387E+00, 2.5286346740E+01, 3.9523024348E+00, 9.7993005975E-01],
	[4.6000000000E+04, 4.3651440481E+01, 5.2478213475E+00, 2.5295339116E+01, 3.9526161410E+00, 9.7993819174E-01],
	[4.6005000000E+04, 4.3659849127E+01, 5.2478656518E+00, 2.5304333710E+01, 3.9529297714E+00, 9.7994631992E-01],
	[4.6010000000E+04, 4.3668258479E+01, 5.2479099517E+00, 2.5313330523E+01, 3.9532433258E+00, 9.7995444429E-01],
	[4.6015000000E+04, 4.3676668537E+01, 5.2479542471E+00, 2.5322329556E+01, 3.9535568044E+00, 9.7996256486E-01],
	[4.6020000000E+04, 4.3685079300E+01, 5.2479985381E+00, 2.5331330808E+01, 3.9538702071E+00, 9.7997068163E-01],
	[4.6025000000E+04, 4.3693490769E+01, 5.2480428247E+00, 2.5340334280E+01, 3.9541835340E+00, 9.7997879460E-01],
	[4.6030000000E+04, 4.3701902943E+01, 5.2480871068E+00, 2.5349339972E+01, 3.9544967850E+00, 9.7998690377E-01],
	[4.6035000000E+04, 4.3710328534E+01, 5.2481327813E+00, 2.5358347885E+01, 3.9548108576E+00, 9.7999500914E-01],
	[4.6040000000E+04, 4.3718758492E+01, 5.2481788531E+00, 2.5367358019E+01, 3.9551251126E+00, 9.8000311072E-01],
	[4.6045000000E+04, 4.3727189160E+01, 5.2482249203E+00, 2.5376370373E+01, 3.9554392921E+00, 9.8001120851E-01],
	[4.6050000000E+04, 4.3735620538E+01, 5.2482709830E+00, 2.5385384950E+01, 3.9557533961E+00, 9.8001930251E-01],
	[4.6055000000E+04, 4.3744052626E+01, 5.2483170410E+00, 2.5394401748E+01, 3.9560674245E+00, 9.8002739272E-01],
	[4.6060000000E+04, 4.3752485424E+01, 5.2483630944E+00, 2.5403420767E+01, 3.9563813773E+00, 9.8003547914E-01],
	[4.6065000000E+04, 4.3760918932E+01, 5.2484091433E+00, 2.5412442010E+01, 3.9566952547E+00, 9.8004356178E-01],
	[4.6070000000E+04, 4.3769353150E+01, 5.2484551875E+00, 2.5421465475E+01, 3.9570090566E+00, 9.8005164064E-01],
	[4.6075000000E+04, 4.3777788078E+01, 5.2485012272E+00, 2.5430491163E+01, 3.9573227830E+00, 9.8005971572E-01],
	[4.6080000000E+04, 4.3786223716E+01, 5.2485472622E+00, 2.5439519074E+01, 3.9576364340E+00, 9.8006778701E-01],
	[4.6085000000E+04, 4.3794660064E+01, 5.2485932927E+00, 2.5448549208E+01, 3.9579500096E+00, 9.8007585454E-01],
	[4.6090000000E+04, 4.3803097122E+01, 5.2486393186E+00, 2.5457581567E+01, 3.9582635098E+00, 9.8008391828E-01],
	[4.6095000000E+04, 4.3811534890E+01, 5.2486853398E+00, 2.5466616150E+01, 3.9585769345E+00, 9.8009197826E-01],
	[4.6100000000E+04, 4.3819973368E+01, 5.2487313565E+00, 2.5475652957E+01, 3.9588902840E+00, 9.8010003446E-01],
	[4.6105000000E+04, 4.3828412555E+01, 5.2487773687E+00, 2.5484691989E+01, 3.9592035580E+00, 9.8010808690E-01],
	[4.6110000000E+04, 4.3836852453E+01, 5.2488233762E+00, 2.5493733246E+01, 3.9595167568E+00, 9.8011613556E-01],
	[4.6115000000E+04, 4.3845293060E+01, 5.2488693791E+00, 2.5502776729E+01, 3.9598298802E+00, 9.8012418047E-01],
	[4.6120000000E+04, 4.3853734377E+01, 5.2489153775E+00, 2.5511822437E+01, 3.9601429283E+00, 9.8013222161E-01],
	[4.6125000000E+04, 4.3862176404E+01, 5.2489613712E+00, 2.5520870371E+01, 3.9604559012E+00, 9.8014025898E-01],
	[4.6130000000E+04, 4.3870619141E+01, 5.2490073604E+00, 2.5529920532E+01, 3.9607687989E+00, 9.8014829260E-01],
	[4.6135000000E+04, 4.3879062587E+01, 5.2490533450E+00, 2.5538972919E+01, 3.9610816213E+00, 9.8015632247E-01],
	[4.6140000000E+04, 4.3887506743E+01, 5.2490993251E+00, 2.5548027533E+01, 3.9613943684E+00, 9.8016434857E-01],
	[4.6145000000E+04, 4.3895951609E+01, 5.2491453005E+00, 2.5557084375E+01, 3.9617070405E+00, 9.8017237093E-01],
	[4.6150000000E+04, 4.3904397185E+01, 5.2491912714E+00, 2.5566143444E+01, 3.9620196373E+00, 9.8018038953E-01],
	[4.6155000000E+04, 4.3912843470E+01, 5.2492372377E+00, 2.5575204740E+01, 3.9623321590E+00, 9.8018840438E-01],
	[4.6160000000E+04, 4.3921290465E+01, 5.2492831994E+00, 2.5584268265E+01, 3.9626446055E+00, 9.8019641548E-01],
	[4.6165000000E+04, 4.3929738170E+01, 5.2493291565E+00, 2.5593334019E+01, 3.9629569770E+00, 9.8020442284E-01],
	[4.6170000000E+04, 4.3938186584E+01, 5.2493751091E+00, 2.5602402001E+01, 3.9632692733E+00, 9.8021242646E-01],
	[4.6175000000E+04, 4.3946635708E+01, 5.2494210571E+00, 2.5611472212E+01, 3.9635814946E+00, 9.8022042633E-01],
	[4.6180000000E+04, 4.3955085542E+01, 5.2494670005E+00, 2.5620544653E+01, 3.9638936408E+00, 9.8022842246E-01],
	[4.6185000000E+04, 4.3963536085E+01, 5.2495129393E+00, 2.5629619323E+01, 3.9642057120E+00, 9.8023641486E-01],
	[4.6190000000E+04, 4.3971987338E+01, 5.2495588736E+00, 2.5638696223E+01, 3.9645177082E+00, 9.8024440352E-01],
	[4.6195000000E+04, 4.3980439300E+01, 5.2496048033E+00, 2.5647775354E+01, 3.9648296293E+00, 9.8025238844E-01],
	[4.6200000000E+04, 4.3988891972E+01, 5.2496507284E+00, 2.5656856715E+01, 3.9651414755E+00, 9.8026036963E-01],
	[4.6205000000E+04, 4.3997345353E+01, 5.2496966490E+00, 2.5665940307E+01, 3.9654532468E+00, 9.8026834710E-01],
	[4.6210000000E+04, 4.4005799444E+01, 5.2497425650E+00, 2.5675026131E+01, 3.9657649431E+00, 9.8027632083E-01],
	[4.6215000000E+04, 4.4014254245E+01, 5.2497884764E+00, 2.5684114186E+01, 3.9660765645E+00, 9.8028429084E-01],
	[4.6220000000E+04, 4.4022709754E+01, 5.2498343833E+00, 2.5693204472E+01, 3.9663881110E+00, 9.8029225712E-01],
	[4.6225000000E+04, 4.4031165974E+01, 5.2498802856E+00, 2.5702296991E+01, 3.9666995826E+00, 9.8030021968E-01],
	[4.6230000000E+04, 4.4039622903E+01, 5.2499261833E+00, 2.5711391742E+01, 3.9670109793E+00, 9.8030817852E-01],
	[4.6235000000E+04, 4.4048080541E+01, 5.2499720765E+00, 2.5720488727E+01, 3.9673223012E+00, 9.8031613364E-01],
	[4.6240000000E+04, 4.4056538888E+01, 5.2500179651E+00, 2.5729587944E+01, 3.9676335483E+00, 9.8032408504E-01],
	[4.6245000000E+04, 4.4064997945E+01, 5.2500638492E+00, 2.5738689394E+01, 3.9679447206E+00, 9.8033203273E-01],
	[4.6250000000E+04, 4.4073457712E+01, 5.2501097287E+00, 2.5747793078E+01, 3.9682558181E+00, 9.8033997671E-01],
	[4.6255000000E+04, 4.4081918187E+01, 5.2501556036E+00, 2.5756898996E+01, 3.9685668409E+00, 9.8034791697E-01],
	[4.6260000000E+04, 4.4090379372E+01, 5.2502014740E+00, 2.5766007149E+01, 3.9688777889E+00, 9.8035585352E-01],
	[4.6265000000E+04, 4.4098841267E+01, 5.2502473398E+00, 2.5775117536E+01, 3.9691886621E+00, 9.8036378637E-01],
	[4.6270000000E+04, 4.4107303871E+01, 5.2502932011E+00, 2.5784230157E+01, 3.9694994607E+00, 9.8037171551E-01],
	[4.6275000000E+04, 4.4115767184E+01, 5.2503390578E+00, 2.5793345014E+01, 3.9698101846E+00, 9.8037964095E-01],
	[4.6280000000E+04, 4.4124231206E+01, 5.2503849099E+00, 2.5802462107E+01, 3.9701208338E+00, 9.8038756269E-01],
	[4.6285000000E+04, 4.4132695937E+01, 5.2504307575E+00, 2.5811581435E+01, 3.9704314084E+00, 9.8039548073E-01],
	[4.6290000000E+04, 4.4141161378E+01, 5.2504766006E+00, 2.5820703000E+01, 3.9707419084E+00, 9.8040339506E-01],
	[4.6295000000E+04, 4.4149627528E+01, 5.2505224391E+00, 2.5829826801E+01, 3.9710523337E+00, 9.8041130571E-01],
	[4.6300000000E+04, 4.4158094387E+01, 5.2505682730E+00, 2.5838952838E+01, 3.9713626845E+00, 9.8041921266E-01],
	[4.6305000000E+04, 4.4166561955E+01, 5.2506141024E+00, 2.5848081113E+01, 3.9716729607E+00, 9.8042711591E-01],
	[4.6310000000E+04, 4.4175030233E+01, 5.2506599273E+00, 2.5857211625E+01, 3.9719831623E+00, 9.8043501548E-01],
	[4.6315000000E+04, 4.4183499219E+01, 5.2507057476E+00, 2.5866344375E+01, 3.9722932894E+00, 9.8044291136E-01],
	[4.6320000000E+04, 4.4191968915E+01, 5.2507515633E+00, 2.5875479362E+01, 3.9726033420E+00, 9.8045080355E-01],
	[4.6325000000E+04, 4.4200439320E+01, 5.2507973745E+00, 2.5884616588E+01, 3.9729133201E+00, 9.8045869206E-01],
	[4.6330000000E+04, 4.4208910434E+01, 5.2508431812E+00, 2.5893756052E+01, 3.9732232237E+00, 9.8046657688E-01],
	[4.6335000000E+04, 4.4217382257E+01, 5.2508889833E+00, 2.5902897756E+01, 3.9735330529E+00, 9.8047445803E-01],
	[4.6340000000E+04, 4.4225854789E+01, 5.2509347809E+00, 2.5912041698E+01, 3.9738428077E+00, 9.8048233549E-01],
	[4.6345000000E+04, 4.4234328030E+01, 5.2509805739E+00, 2.5921187880E+01, 3.9741524880E+00, 9.8049020928E-01],
	[4.6350000000E+04, 4.4242801981E+01, 5.2510263624E+00, 2.5930336302E+01, 3.9744620940E+00, 9.8049807940E-01],
	[4.6355000000E+04, 4.4251276640E+01, 5.2510721464E+00, 2.5939486964E+01, 3.9747716255E+00, 9.8050594584E-01],
	[4.6360000000E+04, 4.4259752008E+01, 5.2511179258E+00, 2.5948639866E+01, 3.9750810827E+00, 9.8051380861E-01],
	[4.6365000000E+04, 4.4268228085E+01, 5.2511637007E+00, 2.5957795009E+01, 3.9753904656E+00, 9.8052166771E-01],
	[4.6370000000E+04, 4.4276704871E+01, 5.2512094710E+00, 2.5966952393E+01, 3.9756997742E+00, 9.8052952314E-01],
	[4.6375000000E+04, 4.4285182366E+01, 5.2512552368E+00, 2.5976112018E+01, 3.9760090084E+00, 9.8053737491E-01],
	[4.6380000000E+04, 4.4293660570E+01, 5.2513009981E+00, 2.5985273885E+01, 3.9763181684E+00, 9.8054522301E-01],
	[4.6385000000E+04, 4.4302139483E+01, 5.2513467548E+00, 2.5994437994E+01, 3.9766272542E+00, 9.8055306746E-01],
	[4.6390000000E+04, 4.4310619105E+01, 5.2513925071E+00, 2.6003604345E+01, 3.9769362656E+00, 9.8056090824E-01],
	[4.6395000000E+04, 4.4319099436E+01, 5.2514382547E+00, 2.6012772939E+01, 3.9772452029E+00, 9.8056874536E-01],
	[4.6400000000E+04, 4.4327580475E+01, 5.2514839979E+00, 2.6021943775E+01, 3.9775540660E+00, 9.8057657883E-01],
	[4.6405000000E+04, 4.4336062224E+01, 5.2515297365E+00, 2.6031116855E+01, 3.9778628549E+00, 9.8058440865E-01],
	[4.6410000000E+04, 4.4344544681E+01, 5.2515754705E+00, 2.6040292178E+01, 3.9781715696E+00, 9.8059223481E-01],
	[4.6415000000E+04, 4.4353027847E+01, 5.2516212001E+00, 2.6049469745E+01, 3.9784802102E+00, 9.8060005732E-01],
	[4.6420000000E+04, 4.4361511722E+01, 5.2516669251E+00, 2.6058649556E+01, 3.9787887766E+00, 9.8060787619E-01],
	[4.6425000000E+04, 4.4369996305E+01, 5.2517126456E+00, 2.6067831611E+01, 3.9790972690E+00, 9.8061569140E-01],
	[4.6430000000E+04, 4.4378481598E+01, 5.2517583616E+00, 2.6077015911E+01, 3.9794056872E+00, 9.8062350298E-01],
	[4.6435000000E+04, 4.4386967599E+01, 5.2518040730E+00, 2.6086202456E+01, 3.9797140314E+00, 9.8063131091E-01],
	[4.6440000000E+04, 4.4395454308E+01, 5.2518497800E+00, 2.6095391246E+01, 3.9800223016E+00, 9.8063911520E-01],
	[4.6445000000E+04, 4.4403941727E+01, 5.2518954823E+00, 2.6104582282E+01, 3.9803304977E+00, 9.8064691585E-01],
	[4.6450000000E+04, 4.4412429854E+01, 5.2519411802E+00, 2.6113775564E+01, 3.9806386199E+00, 9.8065471286E-01],
	[4.6455000000E+04, 4.4420918690E+01, 5.2519868736E+00, 2.6122971092E+01, 3.9809466680E+00, 9.8066250624E-01],
	[4.6460000000E+04, 4.4429408234E+01, 5.2520325624E+00, 2.6132168867E+01, 3.9812546422E+00, 9.8067029598E-01],
	[4.6465000000E+04, 4.4437898487E+01, 5.2520782467E+00, 2.6141368889E+01, 3.9815625424E+00, 9.8067808210E-01],
	[4.6470000000E+04, 4.4446389449E+01, 5.2521239265E+00, 2.6150571157E+01, 3.9818703687E+00, 9.8068586458E-01],
	[4.6475000000E+04, 4.4454881120E+01, 5.2521696018E+00, 2.6159775673E+01, 3.9821781210E+00, 9.8069364344E-01],
	[4.6480000000E+04, 4.4463373498E+01, 5.2522152726E+00, 2.6168982437E+01, 3.9824857995E+00, 9.8070141867E-01],
	[4.6485000000E+04, 4.4471866586E+01, 5.2522609388E+00, 2.6178191449E+01, 3.9827934041E+00, 9.8070919028E-01],
	[4.6490000000E+04, 4.4480360382E+01, 5.2523066005E+00, 2.6187402709E+01, 3.9831009349E+00, 9.8071695826E-01],
	[4.6495000000E+04, 4.4488854887E+01, 5.2523522578E+00, 2.6196616218E+01, 3.9834083918E+00, 9.8072472263E-01],
	[4.6500000000E+04, 4.4497350100E+01, 5.2523979105E+00, 2.6205831976E+01, 3.9837157749E+00, 9.8073248337E-01],
	[4.6505000000E+04, 4.4505846021E+01, 5.2524435587E+00, 2.6215049983E+01, 3.9840230842E+00, 9.8074024051E-01],
	[4.6510000000E+04, 4.4514342651E+01, 5.2524892023E+00, 2.6224270240E+01, 3.9843303197E+00, 9.8074799402E-01],
	[4.6515000000E+04, 4.4522839990E+01, 5.2525348415E+00, 2.6233492747E+01, 3.9846374815E+00, 9.8075574393E-01],
	[4.6520000000E+04, 4.4531338037E+01, 5.2525804762E+00, 2.6242717504E+01, 3.9849445696E+00, 9.8076349022E-01],
	[4.6525000000E+04, 4.4539836792E+01, 5.2526261063E+00, 2.6251944511E+01, 3.9852515839E+00, 9.8077123290E-01],
	[4.6530000000E+04, 4.4548336256E+01, 5.2526717320E+00, 2.6261173769E+01, 3.9855585245E+00, 9.8077897198E-01],
	[4.6535000000E+04, 4.4556836428E+01, 5.2527173531E+00, 2.6270405279E+01, 3.9858653915E+00, 9.8078670745E-01],
	[4.6540000000E+04, 4.4565337309E+01, 5.2527629698E+00, 2.6279639040E+01, 3.9861721847E+00, 9.8079443932E-01],
	[4.6545000000E+04, 4.4573838898E+01, 5.2528085819E+00, 2.6288875052E+01, 3.9864789044E+00, 9.8080216759E-01],
	[4.6550000000E+04, 4.4582341195E+01, 5.2528541895E+00, 2.6298113317E+01, 3.9867855504E+00, 9.8080989226E-01],
	[4.6555000000E+04, 4.4590844200E+01, 5.2528997926E+00, 2.6307353834E+01, 3.9870921228E+00, 9.8081761333E-01],
	[4.6560000000E+04, 4.4599347914E+01, 5.2529453913E+00, 2.6316596603E+01, 3.9873986217E+00, 9.8082533080E-01],
	[4.6565000000E+04, 4.4607852337E+01, 5.2529909854E+00, 2.6325841626E+01, 3.9877050469E+00, 9.8083304469E-01],
	[4.6570000000E+04, 4.4616357467E+01, 5.2530365750E+00, 2.6335088902E+01, 3.9880113987E+00, 9.8084075498E-01],
	[4.6575000000E+04, 4.4624863306E+01, 5.2530821601E+00, 2.6344338431E+01, 3.9883176769E+00, 9.8084846168E-01],
	[4.6580000000E+04, 4.4633369853E+01, 5.2531277408E+00, 2.6353590215E+01, 3.9886238815E+00, 9.8085616479E-01],
	[4.6585000000E+04, 4.4641877108E+01, 5.2531733169E+00, 2.6362844252E+01, 3.9889300127E+00, 9.8086386431E-01],
	[4.6590000000E+04, 4.4650385071E+01, 5.2532188885E+00, 2.6372100544E+01, 3.9892360705E+00, 9.8087156025E-01],
	[4.6595000000E+04, 4.4658893743E+01, 5.2532644557E+00, 2.6381359091E+01, 3.9895420548E+00, 9.8087925261E-01],
	[4.6600000000E+04, 4.4667403123E+01, 5.2533100183E+00, 2.6390619893E+01, 3.9898479656E+00, 9.8088694139E-01],
	[4.6605000000E+04, 4.4675913211E+01, 5.2533555765E+00, 2.6399882951E+01, 3.9901538031E+00, 9.8089462659E-01],
	[4.6610000000E+04, 4.4684424007E+01, 5.2534011301E+00, 2.6409148264E+01, 3.9904595671E+00, 9.8090230821E-01],
	[4.6615000000E+04, 4.4692935511E+01, 5.2534466793E+00, 2.6418415833E+01, 3.9907652578E+00, 9.8090998626E-01],
	[4.6620000000E+04, 4.4701447723E+01, 5.2534922240E+00, 2.6427685658E+01, 3.9910708752E+00, 9.8091766073E-01],
	[4.6625000000E+04, 4.4709960644E+01, 5.2535377641E+00, 2.6436957741E+01, 3.9913764192E+00, 9.8092533164E-01],
	[4.6630000000E+04, 4.4718474272E+01, 5.2535832998E+00, 2.6446232080E+01, 3.9916818898E+00, 9.8093299897E-01],
	[4.6635000000E+04, 4.4726988609E+01, 5.2536288311E+00, 2.6455508676E+01, 3.9919872872E+00, 9.8094066274E-01],
	[4.6640000000E+04, 4.4735503653E+01, 5.2536743578E+00, 2.6464787530E+01, 3.9922926113E+00, 9.8094832294E-01],
	[4.6645000000E+04, 4.4744019406E+01, 5.2537198800E+00, 2.6474068642E+01, 3.9925978622E+00, 9.8095597957E-01],
	[4.6650000000E+04, 4.4752535866E+01, 5.2537653978E+00, 2.6483352012E+01, 3.9929030398E+00, 9.8096363265E-01],
	[4.6655000000E+04, 4.4761053035E+01, 5.2538109110E+00, 2.6492637640E+01, 3.9932081442E+00, 9.8097128216E-01],
	[4.6660000000E+04, 4.4769570911E+01, 5.2538564198E+00, 2.6501925528E+01, 3.9935131754E+00, 9.8097892812E-01],
	[4.6665000000E+04, 4.4778089496E+01, 5.2539019241E+00, 2.6511215674E+01, 3.9938181335E+00, 9.8098657052E-01],
	[4.6670000000E+04, 4.4786608788E+01, 5.2539474239E+00, 2.6520508080E+01, 3.9941230183E+00, 9.8099420936E-01],
	[4.6675000000E+04, 4.4795128789E+01, 5.2539929193E+00, 2.6529802746E+01, 3.9944278300E+00, 9.8100184465E-01],
	[4.6680000000E+04, 4.4803649497E+01, 5.2540384102E+00, 2.6539099671E+01, 3.9947325686E+00, 9.8100947639E-01],
	[4.6685000000E+04, 4.4812170913E+01, 5.2540838965E+00, 2.6548398857E+01, 3.9950372341E+00, 9.8101710459E-01],
	[4.6690000000E+04, 4.4820693037E+01, 5.2541293784E+00, 2.6557700304E+01, 3.9953418265E+00, 9.8102472923E-01],
	[4.6695000000E+04, 4.4829215869E+01, 5.2541748559E+00, 2.6567004011E+01, 3.9956463459E+00, 9.8103235033E-01],
	[4.6700000000E+04, 4.4837739408E+01, 5.2542203288E+00, 2.6576309980E+01, 3.9959507922E+00, 9.8103996789E-01],
	[4.6705000000E+04, 4.4846263656E+01, 5.2542657973E+00, 2.6585618210E+01, 3.9962551655E+00, 9.8104758190E-01],
	[4.6710000000E+04, 4.4854788611E+01, 5.2543112613E+00, 2.6594928702E+01, 3.9965594657E+00, 9.8105519238E-01],
	[4.6715000000E+04, 4.4863314274E+01, 5.2543567208E+00, 2.6604241457E+01, 3.9968636930E+00, 9.8106279932E-01],
	[4.6720000000E+04, 4.4871840645E+01, 5.2544021759E+00, 2.6613556474E+01, 3.9971678473E+00, 9.8107040272E-01],
	[4.6725000000E+04, 4.4880367723E+01, 5.2544476265E+00, 2.6622873753E+01, 3.9974719287E+00, 9.8107800259E-01],
	[4.6730000000E+04, 4.4888895510E+01, 5.2544930726E+00, 2.6632193296E+01, 3.9977759371E+00, 9.8108559892E-01],
	[4.6735000000E+04, 4.4897424004E+01, 5.2545385142E+00, 2.6641515102E+01, 3.9980798726E+00, 9.8109319173E-01],
	[4.6740000000E+04, 4.4905953205E+01, 5.2545839514E+00, 2.6650839172E+01, 3.9983837353E+00, 9.8110078101E-01],
	[4.6745000000E+04, 4.4914483115E+01, 5.2546293841E+00, 2.6660165506E+01, 3.9986875250E+00, 9.8110836676E-01],
	[4.6750000000E+04, 4.4923013732E+01, 5.2546748124E+00, 2.6669494104E+01, 3.9989912419E+00, 9.8111594898E-01],
	[4.6755000000E+04, 4.4931545057E+01, 5.2547202362E+00, 2.6678824967E+01, 3.9992948860E+00, 9.8112352768E-01],
	[4.6760000000E+04, 4.4940077089E+01, 5.2547656555E+00, 2.6688158094E+01, 3.9995984572E+00, 9.8113110286E-01],
	[4.6765000000E+04, 4.4948609829E+01, 5.2548110703E+00, 2.6697493487E+01, 3.9999019557E+00, 9.8113867453E-01],
	[4.6770000000E+04, 4.4957143276E+01, 5.2548564807E+00, 2.6706831146E+01, 4.0002053813E+00, 9.8114624267E-01],
	[4.6775000000E+04, 4.4965686738E+01, 5.2549028885E+00, 2.6716171070E+01, 4.0005093886E+00, 9.8115380730E-01],
	[4.6780000000E+04, 4.4974237965E+01, 5.2549500510E+00, 2.6725513261E+01, 4.0008138191E+00, 9.8116136841E-01],
	[4.6785000000E+04, 4.4982789903E+01, 5.2549972088E+00, 2.6734857718E+01, 4.0011181770E+00, 9.8116892602E-01],
	[4.6790000000E+04, 4.4991342554E+01, 5.2550443621E+00, 2.6744204441E+01, 4.0014224624E+00, 9.8117648011E-01],
	[4.6795000000E+04, 4.4999895916E+01, 5.2550915107E+00, 2.6753553432E+01, 4.0017266752E+00, 9.8118403069E-01],
	[4.6800000000E+04, 4.5008449991E+01, 5.2551386547E+00, 2.6762904691E+01, 4.0020308156E+00, 9.8119157777E-01],
	[4.6805000000E+04, 4.5017004777E+01, 5.2551857941E+00, 2.6772258217E+01, 4.0023348835E+00, 9.8119912135E-01],
	[4.6810000000E+04, 4.5025560276E+01, 5.2552329289E+00, 2.6781614011E+01, 4.0026388789E+00, 9.8120666142E-01],
	[4.6815000000E+04, 4.5034116486E+01, 5.2552800591E+00, 2.6790972073E+01, 4.0029428018E+00, 9.8121419799E-01],
	[4.6820000000E+04, 4.5042673408E+01, 5.2553271846E+00, 2.6800332404E+01, 4.0032466524E+00, 9.8122173106E-01],
	[4.6825000000E+04, 4.5051231042E+01, 5.2553743056E+00, 2.6809695004E+01, 4.0035504305E+00, 9.8122926063E-01],
	[4.6830000000E+04, 4.5059789388E+01, 5.2554214219E+00, 2.6819059873E+01, 4.0038541362E+00, 9.8123678671E-01],
	[4.6835000000E+04, 4.5068348445E+01, 5.2554685337E+00, 2.6828427011E+01, 4.0041577696E+00, 9.8124430930E-01],
	[4.6840000000E+04, 4.5076908215E+01, 5.2555156408E+00, 2.6837796420E+01, 4.0044613306E+00, 9.8125182839E-01],
	[4.6845000000E+04, 4.5085468696E+01, 5.2555627433E+00, 2.6847168098E+01, 4.0047648193E+00, 9.8125934400E-01],
	[4.6850000000E+04, 4.5094029889E+01, 5.2556098412E+00, 2.6856542047E+01, 4.0050682357E+00, 9.8126685611E-01],
	[4.6855000000E+04, 4.5102591794E+01, 5.2556569346E+00, 2.6865918267E+01, 4.0053715797E+00, 9.8127436474E-01],
	[4.6860000000E+04, 4.5111154411E+01, 5.2557040233E+00, 2.6875296758E+01, 4.0056748515E+00, 9.8128186989E-01],
	[4.6865000000E+04, 4.5119717739E+01, 5.2557511074E+00, 2.6884677521E+01, 4.0059780511E+00, 9.8128937155E-01],
	[4.6870000000E+04, 4.5128281780E+01, 5.2557981869E+00, 2.6894060555E+01, 4.0062811784E+00, 9.8129686973E-01],
	[4.6875000000E+04, 4.5136846531E+01, 5.2558452618E+00, 2.6903445861E+01, 4.0065842334E+00, 9.8130436444E-01],
	[4.6880000000E+04, 4.5145411995E+01, 5.2558923321E+00, 2.6912833439E+01, 4.0068872163E+00, 9.8131185566E-01],
	[4.6885000000E+04, 4.5153978170E+01, 5.2559393978E+00, 2.6922223290E+01, 4.0071901270E+00, 9.8131934341E-01],
	[4.6890000000E+04, 4.5162545057E+01, 5.2559864589E+00, 2.6931615414E+01, 4.0074929656E+00, 9.8132682769E-01],
	[4.6895000000E+04, 4.5171112655E+01, 5.2560335154E+00, 2.6941009811E+01, 4.0077957320E+00, 9.8133430850E-01],
	[4.6900000000E+04, 4.5179680966E+01, 5.2560805673E+00, 2.6950406482E+01, 4.0080984262E+00, 9.8134178584E-01],
	[4.6905000000E+04, 4.5188249987E+01, 5.2561276147E+00, 2.6959805426E+01, 4.0084010484E+00, 9.8134925970E-01],
	[4.6910000000E+04, 4.5196819721E+01, 5.2561746574E+00, 2.6969206645E+01, 4.0087035985E+00, 9.8135673011E-01],
	[4.6915000000E+04, 4.5205390166E+01, 5.2562216955E+00, 2.6978610138E+01, 4.0090060765E+00, 9.8136419705E-01],
	[4.6920000000E+04, 4.5213961322E+01, 5.2562687291E+00, 2.6988015906E+01, 4.0093084824E+00, 9.8137166052E-01],
	[4.6925000000E+04, 4.5222533190E+01, 5.2563157580E+00, 2.6997423948E+01, 4.0096108164E+00, 9.8137912054E-01],
	[4.6930000000E+04, 4.5231105769E+01, 5.2563627824E+00, 2.7006834267E+01, 4.0099130783E+00, 9.8138657710E-01],
	[4.6935000000E+04, 4.5239679061E+01, 5.2564098022E+00, 2.7016246861E+01, 4.0102152682E+00, 9.8139403020E-01],
	[4.6940000000E+04, 4.5248253063E+01, 5.2564568174E+00, 2.7025661731E+01, 4.0105173862E+00, 9.8140147984E-01],
	[4.6945000000E+04, 4.5256827777E+01, 5.2565038280E+00, 2.7035078877E+01, 4.0108194322E+00, 9.8140892604E-01],
	[4.6950000000E+04, 4.5265403202E+01, 5.2565508340E+00, 2.7044498300E+01, 4.0111214063E+00, 9.8141636878E-01],
	[4.6955000000E+04, 4.5273979339E+01, 5.2565978354E+00, 2.7053920000E+01, 4.0114233084E+00, 9.8142380807E-01],
	[4.6960000000E+04, 4.5282556188E+01, 5.2566448322E+00, 2.7063343977E+01, 4.0117251387E+00, 9.8143124391E-01],
	[4.6965000000E+04, 4.5291133747E+01, 5.2566918245E+00, 2.7072770231E+01, 4.0120268971E+00, 9.8143867631E-01],
	[4.6970000000E+04, 4.5299712019E+01, 5.2567388122E+00, 2.7082198764E+01, 4.0123285836E+00, 9.8144610527E-01],
	[4.6975000000E+04, 4.5308291001E+01, 5.2567857953E+00, 2.7091629574E+01, 4.0126301983E+00, 9.8145353078E-01],
	[4.6980000000E+04, 4.5316870695E+01, 5.2568327738E+00, 2.7101062663E+01, 4.0129317411E+00, 9.8146095285E-01],
	[4.6985000000E+04, 4.5325451100E+01, 5.2568797477E+00, 2.7110498031E+01, 4.0132332122E+00, 9.8146837148E-01],
	[4.6990000000E+04, 4.5334032217E+01, 5.2569267171E+00, 2.7119935678E+01, 4.0135346115E+00, 9.8147578668E-01],
	[4.6995000000E+04, 4.5342614044E+01, 5.2569736818E+00, 2.7129375604E+01, 4.0138359390E+00, 9.8148319844E-01],
	[4.7000000000E+04, 4.5351196583E+01, 5.2570206420E+00, 2.7138817810E+01, 4.0141371947E+00, 9.8149060676E-01],
	[4.7005000000E+04, 4.5359779834E+01, 5.2570675977E+00, 2.7148262296E+01, 4.0144383788E+00, 9.8149801166E-01],
	[4.7010000000E+04, 4.5368363796E+01, 5.2571145487E+00, 2.7157709062E+01, 4.0147394911E+00, 9.8150541313E-01],
	[4.7015000000E+04, 4.5376948468E+01, 5.2571614952E+00, 2.7167158109E+01, 4.0150405317E+00, 9.8151281117E-01],
	[4.7020000000E+04, 4.5385533852E+01, 5.2572084371E+00, 2.7176609437E+01, 4.0153415007E+00, 9.8152020578E-01],
	[4.7025000000E+04, 4.5394119948E+01, 5.2572553744E+00, 2.7186063046E+01, 4.0156423980E+00, 9.8152759697E-01],
	[4.7030000000E+04, 4.5402706754E+01, 5.2573023072E+00, 2.7195518936E+01, 4.0159432237E+00, 9.8153498473E-01],
	[4.7035000000E+04, 4.5411294272E+01, 5.2573492354E+00, 2.7204977108E+01, 4.0162439778E+00, 9.8154236908E-01],
	[4.7040000000E+04, 4.5419882501E+01, 5.2573961590E+00, 2.7214437563E+01, 4.0165446603E+00, 9.8154975001E-01],
	[4.7045000000E+04, 4.5428471441E+01, 5.2574430780E+00, 2.7223900300E+01, 4.0168452712E+00, 9.8155712752E-01],
	[4.7050000000E+04, 4.5437061092E+01, 5.2574899925E+00, 2.7233365319E+01, 4.0171458105E+00, 9.8156450161E-01],
	[4.7055000000E+04, 4.5445651454E+01, 5.2575369024E+00, 2.7242832622E+01, 4.0174462783E+00, 9.8157187229E-01],
	[4.7060000000E+04, 4.5454242527E+01, 5.2575838078E+00, 2.7252302208E+01, 4.0177466746E+00, 9.8157923956E-01],
	[4.7065000000E+04, 4.5462834312E+01, 5.2576307086E+00, 2.7261774078E+01, 4.0180469994E+00, 9.8158660343E-01],
	[4.7070000000E+04, 4.5471426807E+01, 5.2576776048E+00, 2.7271248232E+01, 4.0183472527E+00, 9.8159396388E-01],
	[4.7075000000E+04, 4.5480020013E+01, 5.2577244964E+00, 2.7280724670E+01, 4.0186474346E+00, 9.8160132093E-01],
	[4.7080000000E+04, 4.5488613931E+01, 5.2577713835E+00, 2.7290203392E+01, 4.0189475450E+00, 9.8160867457E-01],
	[4.7085000000E+04, 4.5497208559E+01, 5.2578182661E+00, 2.7299684400E+01, 4.0192475839E+00, 9.8161602481E-01],
	[4.7090000000E+04, 4.5505803899E+01, 5.2578651440E+00, 2.7309167693E+01, 4.0195475515E+00, 9.8162337165E-01],
	[4.7095000000E+04, 4.5514399949E+01, 5.2579120175E+00, 2.7318653271E+01, 4.0198474477E+00, 9.8163071509E-01],
	[4.7100000000E+04, 4.5522996711E+01, 5.2579588863E+00, 2.7328141135E+01, 4.0201472725E+00, 9.8163805513E-01],
	[4.7105000000E+04, 4.5531594183E+01, 5.2580057506E+00, 2.7337631285E+01, 4.0204470260E+00, 9.8164539178E-01],
	[4.7110000000E+04, 4.5540192366E+01, 5.2580526104E+00, 2.7347123722E+01, 4.0207467081E+00, 9.8165272504E-01],
	[4.7115000000E+04, 4.5548791260E+01, 5.2580994655E+00, 2.7356618445E+01, 4.0210463189E+00, 9.8166005490E-01],
	[4.7120000000E+04, 4.5557390866E+01, 5.2581463162E+00, 2.7366115456E+01, 4.0213458585E+00, 9.8166738137E-01],
	[4.7125000000E+04, 4.5565991181E+01, 5.2581931623E+00, 2.7375614754E+01, 4.0216453267E+00, 9.8167470446E-01],
	[4.7130000000E+04, 4.5574592208E+01, 5.2582400038E+00, 2.7385116340E+01, 4.0219447237E+00, 9.8168202416E-01],
	[4.7135000000E+04, 4.5583193946E+01, 5.2582868407E+00, 2.7394620213E+01, 4.0222440495E+00, 9.8168934047E-01],
	[4.7140000000E+04, 4.5591796394E+01, 5.2583336732E+00, 2.7404126375E+01, 4.0225433040E+00, 9.8169665341E-01],
	[4.7145000000E+04, 4.5600399554E+01, 5.2583805010E+00, 2.7413634825E+01, 4.0228424874E+00, 9.8170396296E-01],
	[4.7150000000E+04, 4.5609003424E+01, 5.2584273244E+00, 2.7423145565E+01, 4.0231415995E+00, 9.8171126913E-01],
	[4.7155000000E+04, 4.5617608004E+01, 5.2584741431E+00, 2.7432658593E+01, 4.0234406406E+00, 9.8171857193E-01],
	[4.7160000000E+04, 4.5626213296E+01, 5.2585209574E+00, 2.7442173912E+01, 4.0237396104E+00, 9.8172587135E-01],
	[4.7165000000E+04, 4.5634819298E+01, 5.2585677670E+00, 2.7451691520E+01, 4.0240385092E+00, 9.8173316739E-01],
	[4.7170000000E+04, 4.5643426011E+01, 5.2586145722E+00, 2.7461211418E+01, 4.0243373368E+00, 9.8174046007E-01],
	[4.7175000000E+04, 4.5652033435E+01, 5.2586613728E+00, 2.7470733606E+01, 4.0246360933E+00, 9.8174774937E-01],
	[4.7180000000E+04, 4.5660641569E+01, 5.2587081688E+00, 2.7480258086E+01, 4.0249347788E+00, 9.8175503531E-01],
	[4.7185000000E+04, 4.5669250414E+01, 5.2587549603E+00, 2.7489784856E+01, 4.0252333933E+00, 9.8176231788E-01],
	[4.7190000000E+04, 4.5677859970E+01, 5.2588017473E+00, 2.7499313918E+01, 4.0255319367E+00, 9.8176959708E-01],
	[4.7195000000E+04, 4.5686470237E+01, 5.2588485297E+00, 2.7508845271E+01, 4.0258304091E+00, 9.8177687292E-01],
	[4.7200000000E+04, 4.5695081214E+01, 5.2588953076E+00, 2.7518378917E+01, 4.0261288105E+00, 9.8178414540E-01],
	[4.7205000000E+04, 4.5703692901E+01, 5.2589420809E+00, 2.7527914854E+01, 4.0264271409E+00, 9.8179141452E-01],
	[4.7210000000E+04, 4.5712305299E+01, 5.2589888497E+00, 2.7537453085E+01, 4.0267254004E+00, 9.8179868029E-01],
	[4.7215000000E+04, 4.5720918408E+01, 5.2590356140E+00, 2.7546993608E+01, 4.0270235889E+00, 9.8180594269E-01],
	[4.7220000000E+04, 4.5729532228E+01, 5.2590823737E+00, 2.7556536424E+01, 4.0273217065E+00, 9.8181320175E-01],
	[4.7225000000E+04, 4.5738146757E+01, 5.2591291289E+00, 2.7566081534E+01, 4.0276197533E+00, 9.8182045745E-01],
	[4.7230000000E+04, 4.5746761998E+01, 5.2591758796E+00, 2.7575628938E+01, 4.0279177291E+00, 9.8182770980E-01],
	[4.7235000000E+04, 4.5755377949E+01, 5.2592226257E+00, 2.7585178636E+01, 4.0282156341E+00, 9.8183495880E-01],
	[4.7240000000E+04, 4.5763994610E+01, 5.2592693673E+00, 2.7594730628E+01, 4.0285134682E+00, 9.8184220446E-01],
	[4.7245000000E+04, 4.5772611982E+01, 5.2593161044E+00, 2.7604284916E+01, 4.0288112316E+00, 9.8184944677E-01],
	[4.7250000000E+04, 4.5781230064E+01, 5.2593628369E+00, 2.7613841498E+01, 4.0291089241E+00, 9.8185668574E-01],
	[4.7255000000E+04, 4.5789848857E+01, 5.2594095649E+00, 2.7623400375E+01, 4.0294065458E+00, 9.8186392136E-01],
	[4.7260000000E+04, 4.5798468360E+01, 5.2594562884E+00, 2.7632961549E+01, 4.0297040968E+00, 9.8187115365E-01],
	[4.7265000000E+04, 4.5807088574E+01, 5.2595030073E+00, 2.7642525018E+01, 4.0300015770E+00, 9.8187838260E-01],
	[4.7270000000E+04, 4.5815709498E+01, 5.2595497218E+00, 2.7652090783E+01, 4.0302989865E+00, 9.8188560821E-01],
	[4.7275000000E+04, 4.5824331132E+01, 5.2595964317E+00, 2.7661658846E+01, 4.0305963252E+00, 9.8189283049E-01],
	[4.7280000000E+04, 4.5832953477E+01, 5.2596431370E+00, 2.7671229205E+01, 4.0308935933E+00, 9.8190004943E-01],
	[4.7285000000E+04, 4.5841576532E+01, 5.2596898379E+00, 2.7680801861E+01, 4.0311907907E+00, 9.8190726504E-01],
	[4.7290000000E+04, 4.5850200297E+01, 5.2597365342E+00, 2.7690376815E+01, 4.0314879175E+00, 9.8191447733E-01],
	[4.7295000000E+04, 4.5858824773E+01, 5.2597832260E+00, 2.7699954067E+01, 4.0317849736E+00, 9.8192168629E-01],
	[4.7300000000E+04, 4.5867449959E+01, 5.2598299133E+00, 2.7709533616E+01, 4.0320819591E+00, 9.8192889192E-01],
	[4.7305000000E+04, 4.5876075855E+01, 5.2598765960E+00, 2.7719115465E+01, 4.0323788740E+00, 9.8193609423E-01],
	[4.7310000000E+04, 4.5884702462E+01, 5.2599232743E+00, 2.7728699612E+01, 4.0326757183E+00, 9.8194329321E-01],
	[4.7315000000E+04, 4.5893329778E+01, 5.2599699480E+00, 2.7738286058E+01, 4.0329724921E+00, 9.8195048888E-01],
	[4.7320000000E+04, 4.5901957805E+01, 5.2600166172E+00, 2.7747874803E+01, 4.0332691953E+00, 9.8195768122E-01],
	[4.7325000000E+04, 4.5910586543E+01, 5.2600632819E+00, 2.7757465848E+01, 4.0335658280E+00, 9.8196487026E-01],
	[4.7330000000E+04, 4.5919215990E+01, 5.2601099420E+00, 2.7767059194E+01, 4.0338623902E+00, 9.8197205597E-01],
	[4.7335000000E+04, 4.5927846147E+01, 5.2601565977E+00, 2.7776654839E+01, 4.0341588819E+00, 9.8197923837E-01],
	[4.7340000000E+04, 4.5936477015E+01, 5.2602032488E+00, 2.7786252785E+01, 4.0344553032E+00, 9.8198641746E-01],
	[4.7345000000E+04, 4.5945108593E+01, 5.2602498954E+00, 2.7795853032E+01, 4.0347516540E+00, 9.8199359325E-01],
	[4.7350000000E+04, 4.5953740881E+01, 5.2602965375E+00, 2.7805455580E+01, 4.0350479343E+00, 9.8200076572E-01],
	[4.7355000000E+04, 4.5962373879E+01, 5.2603431751E+00, 2.7815060430E+01, 4.0353441443E+00, 9.8200793489E-01],
	[4.7360000000E+04, 4.5971007587E+01, 5.2603898082E+00, 2.7824667581E+01, 4.0356402838E+00, 9.8201510075E-01],
	[4.7365000000E+04, 4.5979642005E+01, 5.2604364368E+00, 2.7834277035E+01, 4.0359363530E+00, 9.8202226331E-01],
	[4.7370000000E+04, 4.5988277134E+01, 5.2604830609E+00, 2.7843888791E+01, 4.0362323518E+00, 9.8202942257E-01],
	[4.7375000000E+04, 4.5996912972E+01, 5.2605296804E+00, 2.7853502850E+01, 4.0365282803E+00, 9.8203657853E-01],
	[4.7380000000E+04, 4.6005549520E+01, 5.2605762955E+00, 2.7863119212E+01, 4.0368241385E+00, 9.8204373119E-01],
	[4.7385000000E+04, 4.6014186779E+01, 5.2606229061E+00, 2.7872737878E+01, 4.0371199264E+00, 9.8205088056E-01],
	[4.7390000000E+04, 4.6022824747E+01, 5.2606695121E+00, 2.7882358847E+01, 4.0374156440E+00, 9.8205802664E-01],
	[4.7395000000E+04, 4.6031463425E+01, 5.2607161136E+00, 2.7891982120E+01, 4.0377112913E+00, 9.8206516942E-01],
	[4.7400000000E+04, 4.6040102814E+01, 5.2607627107E+00, 2.7901607697E+01, 4.0380068684E+00, 9.8207230891E-01],
	[4.7405000000E+04, 4.6048742912E+01, 5.2608093032E+00, 2.7911235579E+01, 4.0383023753E+00, 9.8207944511E-01],
	[4.7410000000E+04, 4.6057383720E+01, 5.2608558912E+00, 2.7920865766E+01, 4.0385978119E+00, 9.8208657803E-01],
	[4.7415000000E+04, 4.6066025238E+01, 5.2609024748E+00, 2.7930498258E+01, 4.0388931784E+00, 9.8209370766E-01],
	[4.7420000000E+04, 4.6074667466E+01, 5.2609490538E+00, 2.7940133056E+01, 4.0391884747E+00, 9.8210083401E-01],
	[4.7425000000E+04, 4.6083310404E+01, 5.2609956283E+00, 2.7949770160E+01, 4.0394837009E+00, 9.8210795708E-01],
	[4.7430000000E+04, 4.6091954052E+01, 5.2610421984E+00, 2.7959409569E+01, 4.0397788569E+00, 9.8211507686E-01],
	[4.7435000000E+04, 4.6100598409E+01, 5.2610887639E+00, 2.7969051285E+01, 4.0400739428E+00, 9.8212219337E-01],
	[4.7440000000E+04, 4.6109243477E+01, 5.2611353250E+00, 2.7978695308E+01, 4.0403689586E+00, 9.8212930661E-01],
	[4.7445000000E+04, 4.6117889254E+01, 5.2611818815E+00, 2.7988341638E+01, 4.0406639044E+00, 9.8213641656E-01],
	[4.7450000000E+04, 4.6126535741E+01, 5.2612284336E+00, 2.7997990276E+01, 4.0409587801E+00, 9.8214352325E-01],
	[4.7455000000E+04, 4.6135182937E+01, 5.2612749811E+00, 2.8007641221E+01, 4.0412535857E+00, 9.8215062666E-01],
	[4.7460000000E+04, 4.6143830844E+01, 5.2613215242E+00, 2.8017294474E+01, 4.0415483213E+00, 9.8215772681E-01],
	[4.7465000000E+04, 4.6152479460E+01, 5.2613680628E+00, 2.8026950035E+01, 4.0418429870E+00, 9.8216482369E-01],
	[4.7470000000E+04, 4.6161128786E+01, 5.2614145969E+00, 2.8036607905E+01, 4.0421375826E+00, 9.8217191730E-01],
	[4.7475000000E+04, 4.6169778822E+01, 5.2614611265E+00, 2.8046268084E+01, 4.0424321083E+00, 9.8217900765E-01],
	[4.7480000000E+04, 4.6178429567E+01, 5.2615076516E+00, 2.8055930573E+01, 4.0427265640E+00, 9.8218609473E-01],
	[4.7485000000E+04, 4.6187081022E+01, 5.2615541722E+00, 2.8065595370E+01, 4.0430209499E+00, 9.8219317856E-01],
	[4.7490000000E+04, 4.6195733187E+01, 5.2616006883E+00, 2.8075262478E+01, 4.0433152658E+00, 9.8220025913E-01],
	[4.7495000000E+04, 4.6204386061E+01, 5.2616472000E+00, 2.8084931896E+01, 4.0436095118E+00, 9.8220733644E-01],
	[4.7500000000E+04, 4.6213039645E+01, 5.2616937071E+00, 2.8094603624E+01, 4.0439036879E+00, 9.8221441049E-01],
	[4.7505000000E+04, 4.6221693939E+01, 5.2617402098E+00, 2.8104277663E+01, 4.0441977942E+00, 9.8222148129E-01],
	[4.7510000000E+04, 4.6230348942E+01, 5.2617867080E+00, 2.8113954013E+01, 4.0444918307E+00, 9.8222854884E-01],
	[4.7515000000E+04, 4.6239004655E+01, 5.2618332017E+00, 2.8123632674E+01, 4.0447857973E+00, 9.8223561314E-01],
	[4.7520000000E+04, 4.6247661077E+01, 5.2618796910E+00, 2.8133313648E+01, 4.0450796942E+00, 9.8224267419E-01],
	[4.7525000000E+04, 4.6256318209E+01, 5.2619261757E+00, 2.8142996933E+01, 4.0453735213E+00, 9.8224973199E-01],
	[4.7530000000E+04, 4.6264991998E+01, 5.2619743377E+00, 2.8152682530E+01, 4.0456683946E+00, 9.8225678655E-01],
	[4.7535000000E+04, 4.6273666905E+01, 5.2620225376E+00, 2.8162370440E+01, 4.0459632267E+00, 9.8226383787E-01],
	[4.7540000000E+04, 4.6282342526E+01, 5.2620707329E+00, 2.8172060663E+01, 4.0462579891E+00, 9.8227088595E-01],
	[4.7545000000E+04, 4.6291018861E+01, 5.2621189236E+00, 2.8181753200E+01, 4.0465526821E+00, 9.8227793078E-01],
	[4.7550000000E+04, 4.6299695910E+01, 5.2621671097E+00, 2.8191448050E+01, 4.0468473054E+00, 9.8228497238E-01],
	[4.7555000000E+04, 4.6308373673E+01, 5.2622152912E+00, 2.8201145213E+01, 4.0471418593E+00, 9.8229201074E-01],
	[4.7560000000E+04, 4.6317052150E+01, 5.2622634680E+00, 2.8210844691E+01, 4.0474363437E+00, 9.8229904587E-01],
	[4.7565000000E+04, 4.6325731340E+01, 5.2623116402E+00, 2.8220546484E+01, 4.0477307585E+00, 9.8230607776E-01],
	[4.7570000000E+04, 4.6334411244E+01, 5.2623598078E+00, 2.8230250591E+01, 4.0480251040E+00, 9.8231310642E-01],
	[4.7575000000E+04, 4.6343091862E+01, 5.2624079707E+00, 2.8239957013E+01, 4.0483193799E+00, 9.8232013186E-01],
	[4.7580000000E+04, 4.6351773194E+01, 5.2624561291E+00, 2.8249665751E+01, 4.0486135865E+00, 9.8232715406E-01],
	[4.7585000000E+04, 4.6360455239E+01, 5.2625042828E+00, 2.8259376804E+01, 4.0489077236E+00, 9.8233417305E-01],
	[4.7590000000E+04, 4.6369137998E+01, 5.2625524319E+00, 2.8269090173E+01, 4.0492017914E+00, 9.8234118880E-01],
	[4.7595000000E+04, 4.6377821471E+01, 5.2626005764E+00, 2.8278805859E+01, 4.0494957898E+00, 9.8234820134E-01],
	[4.7600000000E+04, 4.6386505658E+01, 5.2626487162E+00, 2.8288523861E+01, 4.0497897188E+00, 9.8235521065E-01],
	[4.7605000000E+04, 4.6395190558E+01, 5.2626968515E+00, 2.8298244181E+01, 4.0500835785E+00, 9.8236221674E-01],
	[4.7610000000E+04, 4.6403876172E+01, 5.2627449821E+00, 2.8307966817E+01, 4.0503773688E+00, 9.8236921962E-01],
	[4.7615000000E+04, 4.6412562500E+01, 5.2627931081E+00, 2.8317691771E+01, 4.0506710899E+00, 9.8237621928E-01],
	[4.7620000000E+04, 4.6421249541E+01, 5.2628412295E+00, 2.8327419043E+01, 4.0509647417E+00, 9.8238321573E-01],
	[4.7625000000E+04, 4.6429937296E+01, 5.2628893463E+00, 2.8337148634E+01, 4.0512583243E+00, 9.8239020896E-01],
	[4.7630000000E+04, 4.6438625765E+01, 5.2629374585E+00, 2.8346880542E+01, 4.0515518376E+00, 9.8239719898E-01],
	[4.7635000000E+04, 4.6447314947E+01, 5.2629855661E+00, 2.8356614770E+01, 4.0518452816E+00, 9.8240418579E-01],
	[4.7640000000E+04, 4.6456004843E+01, 5.2630336690E+00, 2.8366351316E+01, 4.0521386565E+00, 9.8241116939E-01],
	[4.7645000000E+04, 4.6464695452E+01, 5.2630817674E+00, 2.8376090182E+01, 4.0524319622E+00, 9.8241814978E-01],
	[4.7650000000E+04, 4.6473386775E+01, 5.2631298611E+00, 2.8385831368E+01, 4.0527251987E+00, 9.8242512697E-01],
	[4.7655000000E+04, 4.6482078811E+01, 5.2631779503E+00, 2.8395574874E+01, 4.0530183660E+00, 9.8243210095E-01],
	[4.7660000000E+04, 4.6490771561E+01, 5.2632260348E+00, 2.8405320700E+01, 4.0533114643E+00, 9.8243907174E-01],
	[4.7665000000E+04, 4.6499465024E+01, 5.2632741147E+00, 2.8415068846E+01, 4.0536044934E+00, 9.8244603932E-01],
	[4.7670000000E+04, 4.6508159201E+01, 5.2633221900E+00, 2.8424819314E+01, 4.0538974534E+00, 9.8245300370E-01],
	[4.7675000000E+04, 4.6516854092E+01, 5.2633702607E+00, 2.8434572103E+01, 4.0541903443E+00, 9.8245996488E-01],
	[4.7680000000E+04, 4.6525549695E+01, 5.2634183269E+00, 2.8444327214E+01, 4.0544831662E+00, 9.8246692287E-01],
	[4.7685000000E+04, 4.6534246013E+01, 5.2634663884E+00, 2.8454084646E+01, 4.0547759191E+00, 9.8247387766E-01],
	[4.7690000000E+04, 4.6542943043E+01, 5.2635144453E+00, 2.8463844400E+01, 4.0550686029E+00, 9.8248082926E-01],
	[4.7695000000E+04, 4.6551640787E+01, 5.2635624976E+00, 2.8473606478E+01, 4.0553612177E+00, 9.8248777767E-01],
	[4.7700000000E+04, 4.6560339244E+01, 5.2636105453E+00, 2.8483370877E+01, 4.0556537636E+00, 9.8249472289E-01],
	[4.7705000000E+04, 4.6569038415E+01, 5.2636585884E+00, 2.8493137600E+01, 4.0559462404E+00, 9.8250166492E-01],
	[4.7710000000E+04, 4.6577738299E+01, 5.2637066270E+00, 2.8502906647E+01, 4.0562386483E+00, 9.8250860376E-01],
	[4.7715000000E+04, 4.6586438897E+01, 5.2637546609E+00, 2.8512678017E+01, 4.0565309873E+00, 9.8251553942E-01],
	[4.7720000000E+04, 4.6595140207E+01, 5.2638026902E+00, 2.8522451711E+01, 4.0568232574E+00, 9.8252247189E-01],
	[4.7725000000E+04, 4.6603842231E+01, 5.2638507150E+00, 2.8532227730E+01, 4.0571154586E+00, 9.8252940118E-01],
	[4.7730000000E+04, 4.6612544969E+01, 5.2638987351E+00, 2.8542006073E+01, 4.0574075909E+00, 9.8253632729E-01],
	[4.7735000000E+04, 4.6621248419E+01, 5.2639467507E+00, 2.8551786741E+01, 4.0576996544E+00, 9.8254325023E-01],
	[4.7740000000E+04, 4.6629952583E+01, 5.2639947616E+00, 2.8561569735E+01, 4.0579916490E+00, 9.8255016998E-01],
	[4.7745000000E+04, 4.6638657460E+01, 5.2640427680E+00, 2.8571355054E+01, 4.0582835748E+00, 9.8255708656E-01],
	[4.7750000000E+04, 4.6647363050E+01, 5.2640907698E+00, 2.8581142699E+01, 4.0585754318E+00, 9.8256399996E-01],
	[4.7755000000E+04, 4.6656069354E+01, 5.2641387670E+00, 2.8590932670E+01, 4.0588672200E+00, 9.8257091019E-01],
	[4.7760000000E+04, 4.6664776370E+01, 5.2641867596E+00, 2.8600724967E+01, 4.0591589395E+00, 9.8257781725E-01],
	[4.7765000000E+04, 4.6673484100E+01, 5.2642347476E+00, 2.8610519592E+01, 4.0594505902E+00, 9.8258472114E-01],
	[4.7770000000E+04, 4.6682192543E+01, 5.2642827310E+00, 2.8620316543E+01, 4.0597421721E+00, 9.8259162186E-01],
	[4.7775000000E+04, 4.6690901699E+01, 5.2643307099E+00, 2.8630115823E+01, 4.0600336854E+00, 9.8259851941E-01],
	[4.7780000000E+04, 4.6699611569E+01, 5.2643786841E+00, 2.8639917429E+01, 4.0603251300E+00, 9.8260541380E-01],
	[4.7785000000E+04, 4.6708322151E+01, 5.2644266538E+00, 2.8649721364E+01, 4.0606165059E+00, 9.8261230502E-01],
	[4.7790000000E+04, 4.6717033446E+01, 5.2644746189E+00, 2.8659527627E+01, 4.0609078131E+00, 9.8261919309E-01],
	[4.7795000000E+04, 4.6725745455E+01, 5.2645225794E+00, 2.8669336219E+01, 4.0611990518E+00, 9.8262607799E-01],
	[4.7800000000E+04, 4.6734458176E+01, 5.2645705354E+00, 2.8679147140E+01, 4.0614902218E+00, 9.8263295973E-01],
	[4.7805000000E+04, 4.6743171611E+01, 5.2646184867E+00, 2.8688960390E+01, 4.0617813232E+00, 9.8263983832E-01],
	[4.7810000000E+04, 4.6751885759E+01, 5.2646664335E+00, 2.8698775970E+01, 4.0620723560E+00, 9.8264671375E-01],
	[4.7815000000E+04, 4.6760600619E+01, 5.2647143757E+00, 2.8708593880E+01, 4.0623633202E+00, 9.8265358602E-01],
	[4.7820000000E+04, 4.6769316193E+01, 5.2647623133E+00, 2.8718414120E+01, 4.0626542159E+00, 9.8266045514E-01],
	[4.7825000000E+04, 4.6778032479E+01, 5.2648102464E+00, 2.8728236690E+01, 4.0629450431E+00, 9.8266732112E-01],
	[4.7830000000E+04, 4.6786749479E+01, 5.2648581748E+00, 2.8738061591E+01, 4.0632358018E+00, 9.8267418394E-01],
	[4.7835000000E+04, 4.6795467191E+01, 5.2649060987E+00, 2.8747888824E+01, 4.0635264920E+00, 9.8268104361E-01],
	[4.7840000000E+04, 4.6804185617E+01, 5.2649540181E+00, 2.8757718387E+01, 4.0638171137E+00, 9.8268790014E-01],
	[4.7845000000E+04, 4.6812904755E+01, 5.2650019328E+00, 2.8767550283E+01, 4.0641076669E+00, 9.8269475352E-01],
	[4.7850000000E+04, 4.6821624606E+01, 5.2650498430E+00, 2.8777384511E+01, 4.0643981518E+00, 9.8270160375E-01],
	[4.7855000000E+04, 4.6830345170E+01, 5.2650977486E+00, 2.8787221071E+01, 4.0646885682E+00, 9.8270845085E-01],
	[4.7860000000E+04, 4.6839066447E+01, 5.2651456497E+00, 2.8797059964E+01, 4.0649789162E+00, 9.8271529480E-01],
	[4.7865000000E+04, 4.6847788437E+01, 5.2651935462E+00, 2.8806901189E+01, 4.0652691958E+00, 9.8272213562E-01],
	[4.7870000000E+04, 4.6856511140E+01, 5.2652414381E+00, 2.8816744748E+01, 4.0655594071E+00, 9.8272897330E-01],
	[4.7875000000E+04, 4.6865234555E+01, 5.2652893254E+00, 2.8826590641E+01, 4.0658495500E+00, 9.8273580784E-01],
	[4.7880000000E+04, 4.6873958683E+01, 5.2653372082E+00, 2.8836438868E+01, 4.0661396246E+00, 9.8274263925E-01],
	[4.7885000000E+04, 4.6882683524E+01, 5.2653850864E+00, 2.8846289428E+01, 4.0664296309E+00, 9.8274946752E-01],
	[4.7890000000E+04, 4.6891409078E+01, 5.2654329601E+00, 2.8856142324E+01, 4.0667195689E+00, 9.8275629267E-01],
	[4.7895000000E+04, 4.6900135345E+01, 5.2654808291E+00, 2.8865997554E+01, 4.0670094387E+00, 9.8276311468E-01],
	[4.7900000000E+04, 4.6908862324E+01, 5.2655286937E+00, 2.8875855119E+01, 4.0672992401E+00, 9.8276993357E-01],
	[4.7905000000E+04, 4.6917590016E+01, 5.2655765536E+00, 2.8885715020E+01, 4.0675889734E+00, 9.8277674933E-01],
	[4.7910000000E+04, 4.6926318420E+01, 5.2656244090E+00, 2.8895577257E+01, 4.0678786384E+00, 9.8278356196E-01],
	[4.7915000000E+04, 4.6935047538E+01, 5.2656722599E+00, 2.8905441829E+01, 4.0681682353E+00, 9.8279037147E-01],
	[4.7920000000E+04, 4.6943777368E+01, 5.2657201062E+00, 2.8915308739E+01, 4.0684577639E+00, 9.8279717786E-01],
	[4.7925000000E+04, 4.6952507910E+01, 5.2657679479E+00, 2.8925177984E+01, 4.0687472244E+00, 9.8280398113E-01],
	[4.7930000000E+04, 4.6961239166E+01, 5.2658157851E+00, 2.8935049567E+01, 4.0690366168E+00, 9.8281078128E-01],
	[4.7935000000E+04, 4.6969971134E+01, 5.2658636177E+00, 2.8944923487E+01, 4.0693259410E+00, 9.8281757831E-01],
	[4.7940000000E+04, 4.6978703814E+01, 5.2659114458E+00, 2.8954799745E+01, 4.0696151971E+00, 9.8282437222E-01],
	[4.7945000000E+04, 4.6987437207E+01, 5.2659592693E+00, 2.8964678341E+01, 4.0699043852E+00, 9.8283116302E-01],
	[4.7950000000E+04, 4.6996171313E+01, 5.2660070882E+00, 2.8974559275E+01, 4.0701935051E+00, 9.8283795071E-01],
	[4.7955000000E+04, 4.7004906131E+01, 5.2660549026E+00, 2.8984442547E+01, 4.0704825570E+00, 9.8284473529E-01],
	[4.7960000000E+04, 4.7013641662E+01, 5.2661027125E+00, 2.8994328159E+01, 4.0707715409E+00, 9.8285151676E-01],
	[4.7965000000E+04, 4.7022377905E+01, 5.2661505178E+00, 2.9004216109E+01, 4.0710604568E+00, 9.8285829512E-01],
	[4.7970000000E+04, 4.7031114861E+01, 5.2661983185E+00, 2.9014106399E+01, 4.0713493046E+00, 9.8286507037E-01],
	[4.7975000000E+04, 4.7039852529E+01, 5.2662461147E+00, 2.9023999029E+01, 4.0716380845E+00, 9.8287184251E-01],
	[4.7980000000E+04, 4.7048590910E+01, 5.2662939064E+00, 2.9033893999E+01, 4.0719267965E+00, 9.8287861156E-01],
	[4.7985000000E+04, 4.7057330003E+01, 5.2663416935E+00, 2.9043791309E+01, 4.0722154405E+00, 9.8288537750E-01],
	[4.7990000000E+04, 4.7066069809E+01, 5.2663894761E+00, 2.9053690961E+01, 4.0725040165E+00, 9.8289214034E-01],
	[4.7995000000E+04, 4.7074810327E+01, 5.2664372541E+00, 2.9063592953E+01, 4.0727925247E+00, 9.8289890008E-01],
	[4.8000000000E+04, 4.7083551557E+01, 5.2664850276E+00, 2.9073497286E+01, 4.0730809649E+00, 9.8290565673E-01],
	[4.8005000000E+04, 4.7092293500E+01, 5.2665327965E+00, 2.9083403961E+01, 4.0733693373E+00, 9.8291241027E-01],
	[4.8010000000E+04, 4.7101036155E+01, 5.2665805609E+00, 2.9093312978E+01, 4.0736576419E+00, 9.8291916073E-01],
	[4.8015000000E+04, 4.7109779523E+01, 5.2666283208E+00, 2.9103224338E+01, 4.0739458786E+00, 9.8292590809E-01],
	[4.8020000000E+04, 4.7118523603E+01, 5.2666760761E+00, 2.9113138040E+01, 4.0742340475E+00, 9.8293265236E-01],
	[4.8025000000E+04, 4.7127268395E+01, 5.2667238268E+00, 2.9123054084E+01, 4.0745221486E+00, 9.8293939354E-01],
	[4.8030000000E+04, 4.7136013900E+01, 5.2667715731E+00, 2.9132972472E+01, 4.0748101819E+00, 9.8294613163E-01],
	[4.8035000000E+04, 4.7144760116E+01, 5.2668193148E+00, 2.9142893204E+01, 4.0750981475E+00, 9.8295286663E-01],
	[4.8040000000E+04, 4.7153507046E+01, 5.2668670519E+00, 2.9152816279E+01, 4.0753860453E+00, 9.8295959855E-01],
	[4.8045000000E+04, 4.7162254687E+01, 5.2669147846E+00, 2.9162741699E+01, 4.0756738754E+00, 9.8296632739E-01],
	[4.8050000000E+04, 4.7171003041E+01, 5.2669625127E+00, 2.9172669463E+01, 4.0759616378E+00, 9.8297305314E-01],
	[4.8055000000E+04, 4.7179752106E+01, 5.2670102362E+00, 2.9182599571E+01, 4.0762493325E+00, 9.8297977581E-01],
	[4.8060000000E+04, 4.7188501885E+01, 5.2670579552E+00, 2.9192532025E+01, 4.0765369596E+00, 9.8298649540E-01],
	[4.8065000000E+04, 4.7197252375E+01, 5.2671056697E+00, 2.9202466824E+01, 4.0768245189E+00, 9.8299321192E-01],
	[4.8070000000E+04, 4.7206003577E+01, 5.2671533797E+00, 2.9212403969E+01, 4.0771120107E+00, 9.8299992536E-01],
	[4.8075000000E+04, 4.7214755492E+01, 5.2672010851E+00, 2.9222343459E+01, 4.0773994348E+00, 9.8300663572E-01],
	[4.8080000000E+04, 4.7223508119E+01, 5.2672487860E+00, 2.9232285296E+01, 4.0776867914E+00, 9.8301334302E-01],
	[4.8085000000E+04, 4.7232261458E+01, 5.2672964824E+00, 2.9242229480E+01, 4.0779740803E+00, 9.8302004724E-01],
	[4.8090000000E+04, 4.7241015509E+01, 5.2673441742E+00, 2.9252176010E+01, 4.0782613017E+00, 9.8302674839E-01],
	[4.8095000000E+04, 4.7249770272E+01, 5.2673918616E+00, 2.9262124888E+01, 4.0785484556E+00, 9.8303344647E-01],
	[4.8100000000E+04, 4.7258525747E+01, 5.2674395444E+00, 2.9272076113E+01, 4.0788355419E+00, 9.8304014148E-01],
	[4.8105000000E+04, 4.7267281934E+01, 5.2674872226E+00, 2.9282029686E+01, 4.0791225607E+00, 9.8304683343E-01],
	[4.8110000000E+04, 4.7276038834E+01, 5.2675348964E+00, 2.9291985607E+01, 4.0794095121E+00, 9.8305352232E-01],
	[4.8115000000E+04, 4.7284796445E+01, 5.2675825656E+00, 2.9301943877E+01, 4.0796963959E+00, 9.8306020814E-01],
	[4.8120000000E+04, 4.7293554768E+01, 5.2676302303E+00, 2.9311904496E+01, 4.0799832124E+00, 9.8306689090E-01],
	[4.8125000000E+04, 4.7302313804E+01, 5.2676778905E+00, 2.9321867463E+01, 4.0802699613E+00, 9.8307357060E-01],
	[4.8130000000E+04, 4.7311073551E+01, 5.2677255461E+00, 2.9331832780E+01, 4.0805566429E+00, 9.8308024725E-01],
	[4.8135000000E+04, 4.7319834011E+01, 5.2677731973E+00, 2.9341800446E+01, 4.0808432571E+00, 9.8308692084E-01],
	[4.8140000000E+04, 4.7328595182E+01, 5.2678208439E+00, 2.9351770463E+01, 4.0811298039E+00, 9.8309359137E-01],
	[4.8145000000E+04, 4.7337357065E+01, 5.2678684860E+00, 2.9361742830E+01, 4.0814162833E+00, 9.8310025885E-01],
	[4.8150000000E+04, 4.7346119660E+01, 5.2679161236E+00, 2.9371717547E+01, 4.0817026954E+00, 9.8310692328E-01],
	[4.8155000000E+04, 4.7354882967E+01, 5.2679637566E+00, 2.9381694616E+01, 4.0819890401E+00, 9.8311358466E-01],
	[4.8160000000E+04, 4.7363646986E+01, 5.2680113852E+00, 2.9391674035E+01, 4.0822753176E+00, 9.8312024299E-01],
	[4.8165000000E+04, 4.7372411717E+01, 5.2680590092E+00, 2.9401655807E+01, 4.0825615277E+00, 9.8312689827E-01],
	[4.8170000000E+04, 4.7381177160E+01, 5.2681066288E+00, 2.9411639930E+01, 4.0828476706E+00, 9.8313355051E-01],
	[4.8175000000E+04, 4.7389943314E+01, 5.2681542438E+00, 2.9421626405E+01, 4.0831337463E+00, 9.8314019970E-01],
	[4.8180000000E+04, 4.7398710181E+01, 5.2682018543E+00, 2.9431615233E+01, 4.0834197547E+00, 9.8314684585E-01],
	[4.8185000000E+04, 4.7407477759E+01, 5.2682494603E+00, 2.9441606413E+01, 4.0837056958E+00, 9.8315348896E-01],
	[4.8190000000E+04, 4.7416246049E+01, 5.2682970618E+00, 2.9451599947E+01, 4.0839915698E+00, 9.8316012903E-01],
	[4.8195000000E+04, 4.7425015051E+01, 5.2683446587E+00, 2.9461595834E+01, 4.0842773766E+00, 9.8316676606E-01],
	[4.8200000000E+04, 4.7433784764E+01, 5.2683922512E+00, 2.9471594074E+01, 4.0845631163E+00, 9.8317340005E-01],
	[4.8205000000E+04, 4.7442555190E+01, 5.2684398392E+00, 2.9481594669E+01, 4.0848487888E+00, 9.8318003101E-01],
	[4.8210000000E+04, 4.7451326327E+01, 5.2684874226E+00, 2.9491597618E+01, 4.0851343941E+00, 9.8318665894E-01],
	[4.8215000000E+04, 4.7460098175E+01, 5.2685350016E+00, 2.9501602922E+01, 4.0854199324E+00, 9.8319328383E-01],
	[4.8220000000E+04, 4.7468870736E+01, 5.2685825760E+00, 2.9511610581E+01, 4.0857054036E+00, 9.8319990569E-01],
	[4.8225000000E+04, 4.7477644008E+01, 5.2686301460E+00, 2.9521620594E+01, 4.0859908077E+00, 9.8320652453E-01],
	[4.8230000000E+04, 4.7486417992E+01, 5.2686777114E+00, 2.9531632964E+01, 4.0862761447E+00, 9.8321314033E-01],
	[4.8235000000E+04, 4.7495192687E+01, 5.2687252723E+00, 2.9541647689E+01, 4.0865614147E+00, 9.8321975311E-01],
	[4.8240000000E+04, 4.7503968094E+01, 5.2687728288E+00, 2.9551664771E+01, 4.0868466177E+00, 9.8322636287E-01],
	[4.8245000000E+04, 4.7512744213E+01, 5.2688203807E+00, 2.9561684209E+01, 4.0871317537E+00, 9.8323296960E-01],
	[4.8250000000E+04, 4.7521521043E+01, 5.2688679281E+00, 2.9571706004E+01, 4.0874168227E+00, 9.8323957331E-01],
	[4.8255000000E+04, 4.7530298585E+01, 5.2689154711E+00, 2.9581730156E+01, 4.0877018248E+00, 9.8324617401E-01],
	[4.8260000000E+04, 4.7539076838E+01, 5.2689630095E+00, 2.9591756665E+01, 4.0879867599E+00, 9.8325277168E-01],
	[4.8265000000E+04, 4.7547855803E+01, 5.2690105435E+00, 2.9601785532E+01, 4.0882716280E+00, 9.8325936634E-01],
	[4.8270000000E+04, 4.7556635480E+01, 5.2690580729E+00, 2.9611816757E+01, 4.0885564293E+00, 9.8326595798E-01],
	[4.8275000000E+04, 4.7565415868E+01, 5.2691055979E+00, 2.9621850341E+01, 4.0888411636E+00, 9.8327254660E-01],
	[4.8280000000E+04, 4.7574196967E+01, 5.2691531184E+00, 2.9631886283E+01, 4.0891258311E+00, 9.8327913222E-01],
	[4.8285000000E+04, 4.7582978778E+01, 5.2692006343E+00, 2.9641924584E+01, 4.0894104318E+00, 9.8328571482E-01],
	[4.8290000000E+04, 4.7591761301E+01, 5.2692481458E+00, 2.9651965245E+01, 4.0896949656E+00, 9.8329229441E-01],
	[4.8295000000E+04, 4.7600560178E+01, 5.2692972690E+00, 2.9662008265E+01, 4.0899805218E+00, 9.8329887100E-01],
	[4.8300000000E+04, 4.7609360468E+01, 5.2693464597E+00, 2.9672053645E+01, 4.0902660599E+00, 9.8330544458E-01],
	[4.8305000000E+04, 4.7618161474E+01, 5.2693956457E+00, 2.9682101385E+01, 4.0905515313E+00, 9.8331201516E-01],
	[4.8310000000E+04, 4.7626963196E+01, 5.2694448271E+00, 2.9692151486E+01, 4.0908369362E+00, 9.8331858273E-01],
	[4.8315000000E+04, 4.7635765634E+01, 5.2694940039E+00, 2.9702203947E+01, 4.0911222744E+00, 9.8332514730E-01],
	[4.8320000000E+04, 4.7644568787E+01, 5.2695431761E+00, 2.9712258770E+01, 4.0914075460E+00, 9.8333170887E-01],
	[4.8325000000E+04, 4.7653372656E+01, 5.2695923436E+00, 2.9722315954E+01, 4.0916927510E+00, 9.8333826744E-01],
	[4.8330000000E+04, 4.7662177241E+01, 5.2696415065E+00, 2.9732375500E+01, 4.0919778895E+00, 9.8334482301E-01],
	[4.8335000000E+04, 4.7670982541E+01, 5.2696906647E+00, 2.9742437408E+01, 4.0922629615E+00, 9.8335137559E-01],
	[4.8340000000E+04, 4.7679788557E+01, 5.2697398183E+00, 2.9752501678E+01, 4.0925479669E+00, 9.8335792517E-01],
	[4.8345000000E+04, 4.7688595289E+01, 5.2697889674E+00, 2.9762568311E+01, 4.0928329058E+00, 9.8336447176E-01],
	[4.8350000000E+04, 4.7697402736E+01, 5.2698381117E+00, 2.9772637308E+01, 4.0931177782E+00, 9.8337101536E-01],
	[4.8355000000E+04, 4.7706210899E+01, 5.2698872515E+00, 2.9782708667E+01, 4.0934025842E+00, 9.8337755597E-01],
	[4.8360000000E+04, 4.7715019778E+01, 5.2699363866E+00, 2.9792782390E+01, 4.0936873237E+00, 9.8338409359E-01],
	[4.8365000000E+04, 4.7723829372E+01, 5.2699855171E+00, 2.9802858477E+01, 4.0939719968E+00, 9.8339062822E-01],
	[4.8370000000E+04, 4.7732639681E+01, 5.2700346430E+00, 2.9812936928E+01, 4.0942566034E+00, 9.8339715987E-01],
	[4.8375000000E+04, 4.7741450707E+01, 5.2700837643E+00, 2.9823017744E+01, 4.0945411437E+00, 9.8340368854E-01],
	[4.8380000000E+04, 4.7750262447E+01, 5.2701328810E+00, 2.9833100924E+01, 4.0948256176E+00, 9.8341021422E-01],
	[4.8385000000E+04, 4.7759074904E+01, 5.2701819930E+00, 2.9843186470E+01, 4.0951100251E+00, 9.8341673692E-01],
	[4.8390000000E+04, 4.7767888075E+01, 5.2702311004E+00, 2.9853274381E+01, 4.0953943663E+00, 9.8342325664E-01],
	[4.8395000000E+04, 4.7776701963E+01, 5.2702802032E+00, 2.9863364658E+01, 4.0956786411E+00, 9.8342977339E-01],
	[4.8400000000E+04, 4.7785516565E+01, 5.2703293014E+00, 2.9873457301E+01, 4.0959628497E+00, 9.8343628715E-01],
	[4.8405000000E+04, 4.7794331883E+01, 5.2703783950E+00, 2.9883552311E+01, 4.0962469919E+00, 9.8344279795E-01],
	[4.8410000000E+04, 4.7803147917E+01, 5.2704274839E+00, 2.9893649687E+01, 4.0965310679E+00, 9.8344930577E-01],
	[4.8415000000E+04, 4.7811964666E+01, 5.2704765683E+00, 2.9903749430E+01, 4.0968150776E+00, 9.8345581061E-01],
	[4.8420000000E+04, 4.7820782130E+01, 5.2705256480E+00, 2.9913851541E+01, 4.0970990211E+00, 9.8346231249E-01],
	[4.8425000000E+04, 4.7829600310E+01, 5.2705747231E+00, 2.9923956019E+01, 4.0973828983E+00, 9.8346881140E-01],
	[4.8430000000E+04, 4.7838419205E+01, 5.2706237936E+00, 2.9934062865E+01, 4.0976667094E+00, 9.8347530734E-01],
	[4.8435000000E+04, 4.7847238816E+01, 5.2706728595E+00, 2.9944172080E+01, 4.0979504543E+00, 9.8348180032E-01],
	[4.8440000000E+04, 4.7856059142E+01, 5.2707219208E+00, 2.9954283663E+01, 4.0982341330E+00, 9.8348829033E-01],
	[4.8445000000E+04, 4.7864880183E+01, 5.2707709775E+00, 2.9964397615E+01, 4.0985177455E+00, 9.8349477738E-01],
	[4.8450000000E+04, 4.7873701940E+01, 5.2708200296E+00, 2.9974513936E+01, 4.0988012920E+00, 9.8350126146E-01],
	[4.8455000000E+04, 4.7882524411E+01, 5.2708690771E+00, 2.9984632627E+01, 4.0990847723E+00, 9.8350774259E-01],
	[4.8460000000E+04, 4.7891347598E+01, 5.2709181199E+00, 2.9994753687E+01, 4.0993681865E+00, 9.8351422076E-01],
	[4.8465000000E+04, 4.7900171501E+01, 5.2709671582E+00, 3.0004877118E+01, 4.0996515347E+00, 9.8352069597E-01],
	[4.8470000000E+04, 4.7908996118E+01, 5.2710161919E+00, 3.0015002919E+01, 4.0999348167E+00, 9.8352716823E-01],
	[4.8475000000E+04, 4.7917821451E+01, 5.2710652209E+00, 3.0025131091E+01, 4.1002180328E+00, 9.8353363753E-01],
	[4.8480000000E+04, 4.7926647499E+01, 5.2711142454E+00, 3.0035261633E+01, 4.1005011828E+00, 9.8354010388E-01],
	[4.8485000000E+04, 4.7935474263E+01, 5.2711632653E+00, 3.0045394548E+01, 4.1007842668E+00, 9.8354656728E-01],
	[4.8490000000E+04, 4.7944301741E+01, 5.2712122805E+00, 3.0055529834E+01, 4.1010672848E+00, 9.8355302772E-01],
	[4.8495000000E+04, 4.7953129935E+01, 5.2712612912E+00, 3.0065667491E+01, 4.1013502369E+00, 9.8355948523E-01],
	[4.8500000000E+04, 4.7961958843E+01, 5.2713102972E+00, 3.0075807522E+01, 4.1016331230E+00, 9.8356593978E-01],
	[4.8505000000E+04, 4.7970788467E+01, 5.2713592987E+00, 3.0085949924E+01, 4.1019159432E+00, 9.8357239139E-01],
	[4.8510000000E+04, 4.7979618806E+01, 5.2714082956E+00, 3.0096094700E+01, 4.1021986974E+00, 9.8357884006E-01],
	[4.8515000000E+04, 4.7988449860E+01, 5.2714572879E+00, 3.0106241849E+01, 4.1024813857E+00, 9.8358528578E-01],
	[4.8520000000E+04, 4.7997281630E+01, 5.2715062756E+00, 3.0116391371E+01, 4.1027640082E+00, 9.8359172857E-01],
	[4.8525000000E+04, 4.8006114114E+01, 5.2715552587E+00, 3.0126543268E+01, 4.1030465648E+00, 9.8359816841E-01],
	[4.8530000000E+04, 4.8014947313E+01, 5.2716042372E+00, 3.0136697538E+01, 4.1033290556E+00, 9.8360460532E-01],
	[4.8535000000E+04, 4.8023781228E+01, 5.2716532111E+00, 3.0146854183E+01, 4.1036114805E+00, 9.8361103929E-01],
	[4.8540000000E+04, 4.8032615857E+01, 5.2717021804E+00, 3.0157013203E+01, 4.1038938396E+00, 9.8361747032E-01],
	[4.8545000000E+04, 4.8041451201E+01, 5.2717511451E+00, 3.0167174598E+01, 4.1041761329E+00, 9.8362389843E-01],
	[4.8550000000E+04, 4.8050287261E+01, 5.2718001053E+00, 3.0177338368E+01, 4.1044583605E+00, 9.8363032360E-01],
	[4.8555000000E+04, 4.8059124035E+01, 5.2718490608E+00, 3.0187504514E+01, 4.1047405223E+00, 9.8363674584E-01],
	[4.8560000000E+04, 4.8067961525E+01, 5.2718980118E+00, 3.0197673036E+01, 4.1050226183E+00, 9.8364316515E-01],
	[4.8565000000E+04, 4.8076799729E+01, 5.2719469582E+00, 3.0207843934E+01, 4.1053046487E+00, 9.8364958154E-01],
	[4.8570000000E+04, 4.8085638648E+01, 5.2719959000E+00, 3.0218017209E+01, 4.1055866133E+00, 9.8365599500E-01],
	[4.8575000000E+04, 4.8094478282E+01, 5.2720448372E+00, 3.0228192861E+01, 4.1058685122E+00, 9.8366240554E-01],
	[4.8580000000E+04, 4.8103318631E+01, 5.2720937698E+00, 3.0238370890E+01, 4.1061503455E+00, 9.8366881315E-01],
	[4.8585000000E+04, 4.8112159695E+01, 5.2721426979E+00, 3.0248551297E+01, 4.1064321131E+00, 9.8367521784E-01],
	[4.8590000000E+04, 4.8121001474E+01, 5.2721916214E+00, 3.0258734081E+01, 4.1067138151E+00, 9.8368161961E-01],
	[4.8595000000E+04, 4.8129843968E+01, 5.2722405402E+00, 3.0268919244E+01, 4.1069954514E+00, 9.8368801847E-01],
	[4.8600000000E+04, 4.8138687176E+01, 5.2722894546E+00, 3.0279106785E+01, 4.1072770222E+00, 9.8369441441E-01],
	[4.8605000000E+04, 4.8147531100E+01, 5.2723383643E+00, 3.0289296705E+01, 4.1075585274E+00, 9.8370080743E-01],
	[4.8610000000E+04, 4.8156375738E+01, 5.2723872694E+00, 3.0299489004E+01, 4.1078399670E+00, 9.8370719753E-01],
	[4.8615000000E+04, 4.8165221091E+01, 5.2724361700E+00, 3.0309683683E+01, 4.1081213411E+00, 9.8371358473E-01],
	[4.8620000000E+04, 4.8174067158E+01, 5.2724850660E+00, 3.0319880741E+01, 4.1084026497E+00, 9.8371996902E-01],
	[4.8625000000E+04, 4.8182913941E+01, 5.2725339575E+00, 3.0330080180E+01, 4.1086838927E+00, 9.8372635039E-01],
	[4.8630000000E+04, 4.8191761438E+01, 5.2725828443E+00, 3.0340281998E+01, 4.1089650702E+00, 9.8373272886E-01],
	[4.8635000000E+04, 4.8200609650E+01, 5.2726317266E+00, 3.0350486198E+01, 4.1092461823E+00, 9.8373910442E-01],
	[4.8640000000E+04, 4.8209458576E+01, 5.2726806043E+00, 3.0360692778E+01, 4.1095272289E+00, 9.8374547707E-01],
	[4.8645000000E+04, 4.8218308218E+01, 5.2727294774E+00, 3.0370901740E+01, 4.1098082101E+00, 9.8375184683E-01],
	[4.8650000000E+04, 4.8227158574E+01, 5.2727783460E+00, 3.0381113083E+01, 4.1100891259E+00, 9.8375821368E-01],
	[4.8655000000E+04, 4.8236009644E+01, 5.2728272100E+00, 3.0391326808E+01, 4.1103699762E+00, 9.8376457763E-01],
	[4.8660000000E+04, 4.8244861430E+01, 5.2728760694E+00, 3.0401542916E+01, 4.1106507612E+00, 9.8377093868E-01],
	[4.8665000000E+04, 4.8253713930E+01, 5.2729249243E+00, 3.0411761406E+01, 4.1109314808E+00, 9.8377729683E-01],
	[4.8670000000E+04, 4.8262567144E+01, 5.2729737746E+00, 3.0421982278E+01, 4.1112121350E+00, 9.8378365209E-01],
	[4.8675000000E+04, 4.8271421073E+01, 5.2730226203E+00, 3.0432205534E+01, 4.1114927240E+00, 9.8379000445E-01],
	[4.8680000000E+04, 4.8280275717E+01, 5.2730714615E+00, 3.0442431174E+01, 4.1117732476E+00, 9.8379635392E-01],
	[4.8685000000E+04, 4.8289131075E+01, 5.2731202981E+00, 3.0452659197E+01, 4.1120537059E+00, 9.8380270050E-01],
	[4.8690000000E+04, 4.8297987148E+01, 5.2731691301E+00, 3.0462889604E+01, 4.1123340989E+00, 9.8380904418E-01],
	[4.8695000000E+04, 4.8306843936E+01, 5.2732179576E+00, 3.0473122396E+01, 4.1126144266E+00, 9.8381538498E-01],
	[4.8700000000E+04, 4.8315701437E+01, 5.2732667805E+00, 3.0483357572E+01, 4.1128946891E+00, 9.8382172289E-01],
	[4.8705000000E+04, 4.8324559654E+01, 5.2733155989E+00, 3.0493595134E+01, 4.1131748864E+00, 9.8382805792E-01],
	[4.8710000000E+04, 4.8333418585E+01, 5.2733644127E+00, 3.0503835080E+01, 4.1134550185E+00, 9.8383439006E-01],
	[4.8715000000E+04, 4.8342278230E+01, 5.2734132219E+00, 3.0514077413E+01, 4.1137350854E+00, 9.8384071932E-01],
	[4.8720000000E+04, 4.8351138590E+01, 5.2734620266E+00, 3.0524322131E+01, 4.1140150871E+00, 9.8384704569E-01],
	[4.8725000000E+04, 4.8359999664E+01, 5.2735108267E+00, 3.0534569236E+01, 4.1142950237E+00, 9.8385336919E-01],
	[4.8730000000E+04, 4.8368861453E+01, 5.2735596223E+00, 3.0544818727E+01, 4.1145748951E+00, 9.8385968981E-01],
	[4.8735000000E+04, 4.8377723956E+01, 5.2736084133E+00, 3.0555070605E+01, 4.1148547014E+00, 9.8386600755E-01],
	[4.8740000000E+04, 4.8386587174E+01, 5.2736571997E+00, 3.0565324870E+01, 4.1151344425E+00, 9.8387232241E-01],
	[4.8745000000E+04, 4.8395451106E+01, 5.2737059816E+00, 3.0575581522E+01, 4.1154141186E+00, 9.8387863440E-01],
	[4.8750000000E+04, 4.8404315752E+01, 5.2737547590E+00, 3.0585840563E+01, 4.1156937297E+00, 9.8388494352E-01],
	[4.8755000000E+04, 4.8413181113E+01, 5.2738035318E+00, 3.0596101992E+01, 4.1159732757E+00, 9.8389124977E-01],
	[4.8760000000E+04, 4.8422047187E+01, 5.2738523000E+00, 3.0606365809E+01, 4.1162527566E+00, 9.8389755315E-01],
	[4.8765000000E+04, 4.8430913977E+01, 5.2739010637E+00, 3.0616632014E+01, 4.1165321725E+00, 9.8390385366E-01],
	[4.8770000000E+04, 4.8439781480E+01, 5.2739498229E+00, 3.0626900609E+01, 4.1168115235E+00, 9.8391015130E-01],
	[4.8775000000E+04, 4.8448649698E+01, 5.2739985775E+00, 3.0637171593E+01, 4.1170908094E+00, 9.8391644608E-01],
	[4.8780000000E+04, 4.8457518630E+01, 5.2740473276E+00, 3.0647444967E+01, 4.1173700304E+00, 9.8392273799E-01],
	[4.8785000000E+04, 4.8466388277E+01, 5.2740960731E+00, 3.0657720731E+01, 4.1176491865E+00, 9.8392902704E-01],
	[4.8790000000E+04, 4.8475258637E+01, 5.2741448140E+00, 3.0667998885E+01, 4.1179282776E+00, 9.8393531323E-01],
	[4.8795000000E+04, 4.8484129712E+01, 5.2741935504E+00, 3.0678279430E+01, 4.1182073038E+00, 9.8394159656E-01],
	[4.8800000000E+04, 4.8493001501E+01, 5.2742422823E+00, 3.0688562365E+01, 4.1184862651E+00, 9.8394787703E-01],
	[4.8805000000E+04, 4.8501874004E+01, 5.2742910097E+00, 3.0698847692E+01, 4.1187651615E+00, 9.8395415465E-01],
	[4.8810000000E+04, 4.8510747222E+01, 5.2743397325E+00, 3.0709135411E+01, 4.1190439931E+00, 9.8396042941E-01],
	[4.8815000000E+04, 4.8519621153E+01, 5.2743884507E+00, 3.0719425521E+01, 4.1193227598E+00, 9.8396670132E-01],
	[4.8820000000E+04, 4.8528495799E+01, 5.2744371644E+00, 3.0729718023E+01, 4.1196014617E+00, 9.8397297037E-01],
	[4.8825000000E+04, 4.8537371159E+01, 5.2744858736E+00, 3.0740012918E+01, 4.1198800988E+00, 9.8397923658E-01],
	[4.8830000000E+04, 4.8546247233E+01, 5.2745345782E+00, 3.0750310206E+01, 4.1201586712E+00, 9.8398549993E-01],
	[4.8835000000E+04, 4.8555124021E+01, 5.2745832783E+00, 3.0760609886E+01, 4.1204371787E+00, 9.8399176044E-01],
	[4.8840000000E+04, 4.8564001523E+01, 5.2746319739E+00, 3.0770911960E+01, 4.1207156215E+00, 9.8399801810E-01],
	[4.8845000000E+04, 4.8572879740E+01, 5.2746806649E+00, 3.0781216428E+01, 4.1209939996E+00, 9.8400427291E-01],
	[4.8850000000E+04, 4.8581758670E+01, 5.2747293514E+00, 3.0791523290E+01, 4.1212723129E+00, 9.8401052489E-01],
	[4.8855000000E+04, 4.8590638314E+01, 5.2747780334E+00, 3.0801832546E+01, 4.1215505616E+00, 9.8401677402E-01],
	[4.8860000000E+04, 4.8599518672E+01, 5.2748267108E+00, 3.0812144197E+01, 4.1218287455E+00, 9.8402302031E-01],
	[4.8865000000E+04, 4.8608399745E+01, 5.2748753837E+00, 3.0822458243E+01, 4.1221068648E+00, 9.8402926376E-01],
	[4.8870000000E+04, 4.8617281531E+01, 5.2749240520E+00, 3.0832774684E+01, 4.1223849195E+00, 9.8403550437E-01],
	[4.8875000000E+04, 4.8626164031E+01, 5.2749727159E+00, 3.0843093520E+01, 4.1226629095E+00, 9.8404174215E-01],
	[4.8880000000E+04, 4.8635047246E+01, 5.2750213752E+00, 3.0853414753E+01, 4.1229408349E+00, 9.8404797709E-01],
	[4.8885000000E+04, 4.8643931174E+01, 5.2750700299E+00, 3.0863738381E+01, 4.1232186957E+00, 9.8405420920E-01],
	[4.8890000000E+04, 4.8652815816E+01, 5.2751186802E+00, 3.0874064407E+01, 4.1234964919E+00, 9.8406043847E-01],
	[4.8895000000E+04, 4.8661701172E+01, 5.2751673259E+00, 3.0884392828E+01, 4.1237742236E+00, 9.8406666492E-01],
	[4.8900000000E+04, 4.8670587242E+01, 5.2752159671E+00, 3.0894723648E+01, 4.1240518907E+00, 9.8407288854E-01],
	[4.8905000000E+04, 4.8679474026E+01, 5.2752646038E+00, 3.0905056864E+01, 4.1243294933E+00, 9.8407910933E-01],
	[4.8910000000E+04, 4.8688361523E+01, 5.2753132359E+00, 3.0915392478E+01, 4.1246070314E+00, 9.8408532729E-01],
	[4.8915000000E+04, 4.8697249735E+01, 5.2753618635E+00, 3.0925730491E+01, 4.1248845050E+00, 9.8409154243E-01],
	[4.8920000000E+04, 4.8706138660E+01, 5.2754104866E+00, 3.0936070901E+01, 4.1251619142E+00, 9.8409775475E-01],
	[4.8925000000E+04, 4.8715028299E+01, 5.2754591052E+00, 3.0946413711E+01, 4.1254392589E+00, 9.8410396424E-01],
	[4.8930000000E+04, 4.8723918652E+01, 5.2755077193E+00, 3.0956758919E+01, 4.1257165391E+00, 9.8411017092E-01],
	[4.8935000000E+04, 4.8732809719E+01, 5.2755563288E+00, 3.0967106527E+01, 4.1259937549E+00, 9.8411637477E-01],
	[4.8940000000E+04, 4.8741701500E+01, 5.2756049338E+00, 3.0977456534E+01, 4.1262709063E+00, 9.8412257581E-01],
	[4.8945000000E+04, 4.8750593994E+01, 5.2756535343E+00, 3.0987808941E+01, 4.1265479934E+00, 9.8412877403E-01],
	[4.8950000000E+04, 4.8759487202E+01, 5.2757021303E+00, 3.0998163748E+01, 4.1268250160E+00, 9.8413496944E-01],
	[4.8955000000E+04, 4.8768381124E+01, 5.2757507218E+00, 3.1008520956E+01, 4.1271019743E+00, 9.8414116204E-01],
	[4.8960000000E+04, 4.8777275759E+01, 5.2757993087E+00, 3.1018880565E+01, 4.1273788683E+00, 9.8414735182E-01],
	[4.8965000000E+04, 4.8786171108E+01, 5.2758478912E+00, 3.1029242575E+01, 4.1276556980E+00, 9.8415353879E-01],
	[4.8970000000E+04, 4.8795067171E+01, 5.2758964691E+00, 3.1039606987E+01, 4.1279324634E+00, 9.8415972296E-01],
	[4.8975000000E+04, 4.8803963947E+01, 5.2759450425E+00, 3.1049973800E+01, 4.1282091644E+00, 9.8416590431E-01],
	[4.8980000000E+04, 4.8812861437E+01, 5.2759936114E+00, 3.1060343015E+01, 4.1284858013E+00, 9.8417208287E-01],
	[4.8985000000E+04, 4.8821759641E+01, 5.2760421758E+00, 3.1070714633E+01, 4.1287623739E+00, 9.8417825861E-01],
	[4.8990000000E+04, 4.8830658559E+01, 5.2760907357E+00, 3.1081088653E+01, 4.1290388822E+00, 9.8418443156E-01],
	[4.8995000000E+04, 4.8839558189E+01, 5.2761392911E+00, 3.1091465077E+01, 4.1293153263E+00, 9.8419060170E-01],
	[4.9000000000E+04, 4.8848458534E+01, 5.2761878419E+00, 3.1101843904E+01, 4.1295917063E+00, 9.8419676904E-01],
	[4.9005000000E+04, 4.8857359592E+01, 5.2762363883E+00, 3.1112225134E+01, 4.1298680221E+00, 9.8420293359E-01],
	[4.9010000000E+04, 4.8866261364E+01, 5.2762849301E+00, 3.1122608768E+01, 4.1301442737E+00, 9.8420909533E-01],
	[4.9015000000E+04, 4.8875163849E+01, 5.2763334675E+00, 3.1132994807E+01, 4.1304204611E+00, 9.8421525428E-01],
	[4.9020000000E+04, 4.8884067048E+01, 5.2763820003E+00, 3.1143383250E+01, 4.1306965845E+00, 9.8422141044E-01],
	[4.9025000000E+04, 4.8892970960E+01, 5.2764305287E+00, 3.1153774098E+01, 4.1309726437E+00, 9.8422756380E-01],
	[4.9030000000E+04, 4.8901875586E+01, 5.2764790525E+00, 3.1164167352E+01, 4.1312486389E+00, 9.8423371438E-01],
	[4.9035000000E+04, 4.8910780925E+01, 5.2765275718E+00, 3.1174563011E+01, 4.1315245700E+00, 9.8423986216E-01],
	[4.9040000000E+04, 4.8919686977E+01, 5.2765760867E+00, 3.1184961075E+01, 4.1318004370E+00, 9.8424600715E-01],
	[4.9045000000E+04, 4.8928593743E+01, 5.2766245970E+00, 3.1195361546E+01, 4.1320762400E+00, 9.8425214936E-01],
	[4.9050000000E+04, 4.8937501223E+01, 5.2766731028E+00, 3.1205764424E+01, 4.1323519789E+00, 9.8425828878E-01],
	[4.9055000000E+04, 4.8946409416E+01, 5.2767216042E+00, 3.1216169708E+01, 4.1326276539E+00, 9.8426442542E-01],
	[4.9060000000E+04, 4.8955318322E+01, 5.2767701010E+00, 3.1226577399E+01, 4.1329032649E+00, 9.8427055927E-01],
	[4.9065000000E+04, 4.8964227942E+01, 5.2768185933E+00, 3.1236987497E+01, 4.1331788119E+00, 9.8427669034E-01],
	[4.9070000000E+04, 4.8973146046E+01, 5.2768678680E+00, 3.1247400003E+01, 4.1334548331E+00, 9.8428281864E-01],
	[4.9075000000E+04, 4.8982073422E+01, 5.2769180044E+00, 3.1257814918E+01, 4.1337313830E+00, 9.8428894415E-01],
	[4.9080000000E+04, 4.8991001515E+01, 5.2769681361E+00, 3.1268232240E+01, 4.1340078690E+00, 9.8429506689E-01],
	[4.9085000000E+04, 4.8999930326E+01, 5.2770182632E+00, 3.1278651971E+01, 4.1342842913E+00, 9.8430118685E-01],
	[4.9090000000E+04, 4.9008859855E+01, 5.2770683856E+00, 3.1289074111E+01, 4.1345606498E+00, 9.8430730404E-01],
	[4.9095000000E+04, 4.9017790101E+01, 5.2771185034E+00, 3.1299498660E+01, 4.1348369446E+00, 9.8431341845E-01],
	[4.9100000000E+04, 4.9026721065E+01, 5.2771686166E+00, 3.1309925619E+01, 4.1351131757E+00, 9.8431953009E-01],
	[4.9105000000E+04, 4.9035652747E+01, 5.2772187252E+00, 3.1320354988E+01, 4.1353893431E+00, 9.8432563897E-01],
	[4.9110000000E+04, 4.9044585145E+01, 5.2772688291E+00, 3.1330786767E+01, 4.1356654467E+00, 9.8433174507E-01],
	[4.9115000000E+04, 4.9053518262E+01, 5.2773189284E+00, 3.1341220956E+01, 4.1359414868E+00, 9.8433784841E-01],
	[4.9120000000E+04, 4.9062452096E+01, 5.2773690231E+00, 3.1351657557E+01, 4.1362174631E+00, 9.8434394898E-01],
	[4.9125000000E+04, 4.9071386647E+01, 5.2774191132E+00, 3.1362096568E+01, 4.1364933758E+00, 9.8435004679E-01],
	[4.9130000000E+04, 4.9080321916E+01, 5.2774691987E+00, 3.1372537991E+01, 4.1367692249E+00, 9.8435614183E-01],
	[4.9135000000E+04, 4.9089257902E+01, 5.2775192795E+00, 3.1382981825E+01, 4.1370450105E+00, 9.8436223411E-01],
	[4.9140000000E+04, 4.9098194606E+01, 5.2775693557E+00, 3.1393428072E+01, 4.1373207324E+00, 9.8436832364E-01],
	[4.9145000000E+04, 4.9107132027E+01, 5.2776194273E+00, 3.1403876730E+01, 4.1375963907E+00, 9.8437441040E-01],
	[4.9150000000E+04, 4.9116070166E+01, 5.2776694942E+00, 3.1414327802E+01, 4.1378719855E+00, 9.8438049441E-01],
	[4.9155000000E+04, 4.9125009022E+01, 5.2777195566E+00, 3.1424781286E+01, 4.1381475168E+00, 9.8438657566E-01],
	[4.9160000000E+04, 4.9133948595E+01, 5.2777696143E+00, 3.1435237184E+01, 4.1384229846E+00, 9.8439265416E-01],
	[4.9165000000E+04, 4.9142888886E+01, 5.2778196674E+00, 3.1445695496E+01, 4.1386983889E+00, 9.8439872990E-01],
	[4.9170000000E+04, 4.9151829893E+01, 5.2778697159E+00, 3.1456156221E+01, 4.1389737297E+00, 9.8440480290E-01],
	[4.9175000000E+04, 4.9160771619E+01, 5.2779197598E+00, 3.1466619360E+01, 4.1392490070E+00, 9.8441087314E-01],
	[4.9180000000E+04, 4.9169714061E+01, 5.2779697991E+00, 3.1477084915E+01, 4.1395242209E+00, 9.8441694064E-01],
	[4.9185000000E+04, 4.9178657221E+01, 5.2780198337E+00, 3.1487552883E+01, 4.1397993713E+00, 9.8442300538E-01],
	[4.9190000000E+04, 4.9187601098E+01, 5.2780698638E+00, 3.1498023267E+01, 4.1400744584E+00, 9.8442906739E-01],
	[4.9195000000E+04, 4.9196545693E+01, 5.2781198892E+00, 3.1508496067E+01, 4.1403494820E+00, 9.8443512664E-01],
	[4.9200000000E+04, 4.9205491005E+01, 5.2781699100E+00, 3.1518971282E+01, 4.1406244423E+00, 9.8444118316E-01],
	[4.9205000000E+04, 4.9214437034E+01, 5.2782199262E+00, 3.1529448914E+01, 4.1408993392E+00, 9.8444723693E-01],
	[4.9210000000E+04, 4.9223383780E+01, 5.2782699378E+00, 3.1539928962E+01, 4.1411741728E+00, 9.8445328796E-01],
	[4.9215000000E+04, 4.9232331243E+01, 5.2783199448E+00, 3.1550411426E+01, 4.1414489430E+00, 9.8445933626E-01],
	[4.9220000000E+04, 4.9241279424E+01, 5.2783699472E+00, 3.1560896308E+01, 4.1417236500E+00, 9.8446538182E-01],
	[4.9225000000E+04, 4.9250228321E+01, 5.2784199450E+00, 3.1571383606E+01, 4.1419982936E+00, 9.8447142464E-01],
	[4.9230000000E+04, 4.9259177936E+01, 5.2784699382E+00, 3.1581873323E+01, 4.1422728740E+00, 9.8447746472E-01],
	[4.9235000000E+04, 4.9268128268E+01, 5.2785199268E+00, 3.1592365457E+01, 4.1425473911E+00, 9.8448350208E-01],
	[4.9240000000E+04, 4.9277079317E+01, 5.2785699107E+00, 3.1602860010E+01, 4.1428218450E+00, 9.8448953670E-01],
	[4.9245000000E+04, 4.9286031083E+01, 5.2786198901E+00, 3.1613356981E+01, 4.1430962357E+00, 9.8449556859E-01],
	[4.9250000000E+04, 4.9294983567E+01, 5.2786698649E+00, 3.1623856372E+01, 4.1433705632E+00, 9.8450159776E-01],
	[4.9255000000E+04, 4.9303936767E+01, 5.2787198351E+00, 3.1634358181E+01, 4.1436448274E+00, 9.8450762419E-01],
	[4.9260000000E+04, 4.9312890684E+01, 5.2787698006E+00, 3.1644862410E+01, 4.1439190285E+00, 9.8451364790E-01],
	[4.9265000000E+04, 4.9321845319E+01, 5.2788197616E+00, 3.1655369059E+01, 4.1441931665E+00, 9.8451966889E-01],
	[4.9270000000E+04, 4.9330800670E+01, 5.2788697180E+00, 3.1665878128E+01, 4.1444672413E+00, 9.8452568715E-01],
	[4.9275000000E+04, 4.9339756739E+01, 5.2789196698E+00, 3.1676389617E+01, 4.1447412530E+00, 9.8453170269E-01],
	[4.9280000000E+04, 4.9348713524E+01, 5.2789696169E+00, 3.1686903527E+01, 4.1450152016E+00, 9.8453771551E-01],
	[4.9285000000E+04, 4.9357671027E+01, 5.2790195595E+00, 3.1697419858E+01, 4.1452890871E+00, 9.8454372561E-01],
	[4.9290000000E+04, 4.9366629246E+01, 5.2790694975E+00, 3.1707938611E+01, 4.1455629095E+00, 9.8454973300E-01],
	[4.9295000000E+04, 4.9375588183E+01, 5.2791194309E+00, 3.1718459785E+01, 4.1458366689E+00, 9.8455573767E-01],
	[4.9300000000E+04, 4.9384547836E+01, 5.2791693597E+00, 3.1728983381E+01, 4.1461103653E+00, 9.8456173962E-01],
	[4.9305000000E+04, 4.9393508207E+01, 5.2792192840E+00, 3.1739509400E+01, 4.1463839986E+00, 9.8456773886E-01],
	[4.9310000000E+04, 4.9402469294E+01, 5.2792692036E+00, 3.1750037841E+01, 4.1466575690E+00, 9.8457373539E-01],
	[4.9315000000E+04, 4.9411431098E+01, 5.2793191186E+00, 3.1760568705E+01, 4.1469310763E+00, 9.8457972921E-01],
	[4.9320000000E+04, 4.9420393619E+01, 5.2793690291E+00, 3.1771101992E+01, 4.1472045207E+00, 9.8458572031E-01],
	[4.9325000000E+04, 4.9429356857E+01, 5.2794189349E+00, 3.1781637703E+01, 4.1474779022E+00, 9.8459170872E-01],
	[4.9330000000E+04, 4.9438320811E+01, 5.2794688362E+00, 3.1792175838E+01, 4.1477512207E+00, 9.8459769441E-01],
	[4.9335000000E+04, 4.9447285483E+01, 5.2795187329E+00, 3.1802716397E+01, 4.1480244763E+00, 9.8460367740E-01],
	[4.9340000000E+04, 4.9456250871E+01, 5.2795686250E+00, 3.1813259380E+01, 4.1482976690E+00, 9.8460965769E-01],
	[4.9345000000E+04, 4.9465216976E+01, 5.2796185125E+00, 3.1823804789E+01, 4.1485707989E+00, 9.8461563527E-01],
	[4.9350000000E+04, 4.9474183798E+01, 5.2796683954E+00, 3.1834352622E+01, 4.1488438658E+00, 9.8462161016E-01],
	[4.9355000000E+04, 4.9483151337E+01, 5.2797182738E+00, 3.1844902881E+01, 4.1491168700E+00, 9.8462758234E-01],
	[4.9360000000E+04, 4.9492119592E+01, 5.2797681476E+00, 3.1855455565E+01, 4.1493898113E+00, 9.8463355183E-01],
	[4.9365000000E+04, 4.9501088565E+01, 5.2798180168E+00, 3.1866010676E+01, 4.1496626898E+00, 9.8463951862E-01],
	[4.9370000000E+04, 4.9510058253E+01, 5.2798678814E+00, 3.1876568213E+01, 4.1499355055E+00, 9.8464548271E-01],
	[4.9375000000E+04, 4.9519028659E+01, 5.2799177414E+00, 3.1887128177E+01, 4.1502082584E+00, 9.8465144412E-01],
	[4.9380000000E+04, 4.9527999781E+01, 5.2799675969E+00, 3.1897690567E+01, 4.1504809485E+00, 9.8465740283E-01],
	[4.9385000000E+04, 4.9536971620E+01, 5.2800174477E+00, 3.1908255385E+01, 4.1507535760E+00, 9.8466335885E-01],
	[4.9390000000E+04, 4.9545944176E+01, 5.2800672940E+00, 3.1918822631E+01, 4.1510261406E+00, 9.8466931217E-01],
	[4.9395000000E+04, 4.9554917448E+01, 5.2801171358E+00, 3.1929392304E+01, 4.1512986426E+00, 9.8467526282E-01],
	[4.9400000000E+04, 4.9563891437E+01, 5.2801669729E+00, 3.1939964406E+01, 4.1515710819E+00, 9.8468121077E-01],
	[4.9405000000E+04, 4.9572866143E+01, 5.2802168055E+00, 3.1950538936E+01, 4.1518434585E+00, 9.8468715604E-01],
	[4.9410000000E+04, 4.9581841565E+01, 5.2802666335E+00, 3.1961115895E+01, 4.1521157725E+00, 9.8469309863E-01],
	[4.9415000000E+04, 4.9590817704E+01, 5.2803164569E+00, 3.1971695283E+01, 4.1523880238E+00, 9.8469903853E-01],
	[4.9420000000E+04, 4.9599794559E+01, 5.2803662758E+00, 3.1982277101E+01, 4.1526602125E+00, 9.8470497575E-01],
	[4.9425000000E+04, 4.9608772131E+01, 5.2804160901E+00, 3.1992861349E+01, 4.1529323386E+00, 9.8471091030E-01],
	[4.9430000000E+04, 4.9617750419E+01, 5.2804658998E+00, 3.2003448026E+01, 4.1532044021E+00, 9.8471684216E-01],
	[4.9435000000E+04, 4.9626729424E+01, 5.2805157049E+00, 3.2014037134E+01, 4.1534764030E+00, 9.8472277135E-01],
	[4.9440000000E+04, 4.9635709145E+01, 5.2805655055E+00, 3.2024628673E+01, 4.1537483414E+00, 9.8472869786E-01],
	[4.9445000000E+04, 4.9644689583E+01, 5.2806153015E+00, 3.2035222643E+01, 4.1540202173E+00, 9.8473462170E-01],
	[4.9450000000E+04, 4.9653670738E+01, 5.2806650930E+00, 3.2045819044E+01, 4.1542920306E+00, 9.8474054286E-01],
	[4.9455000000E+04, 4.9662652609E+01, 5.2807148799E+00, 3.2056417877E+01, 4.1545637814E+00, 9.8474646136E-01],
	[4.9460000000E+04, 4.9671635196E+01, 5.2807646622E+00, 3.2067019141E+01, 4.1548354697E+00, 9.8475237718E-01],
	[4.9465000000E+04, 4.9680618500E+01, 5.2808144400E+00, 3.2077622838E+01, 4.1551070956E+00, 9.8475829034E-01],
	[4.9470000000E+04, 4.9689602520E+01, 5.2808642132E+00, 3.2088228968E+01, 4.1553786590E+00, 9.8476420082E-01],
	[4.9475000000E+04, 4.9698587256E+01, 5.2809139818E+00, 3.2098837531E+01, 4.1556501600E+00, 9.8477010865E-01],
	[4.9480000000E+04, 4.9707572709E+01, 5.2809637459E+00, 3.2109448526E+01, 4.1559215985E+00, 9.8477601381E-01],
	[4.9485000000E+04, 4.9716558879E+01, 5.2810135054E+00, 3.2120061956E+01, 4.1561929747E+00, 9.8478191630E-01],
	[4.9490000000E+04, 4.9725545764E+01, 5.2810632604E+00, 3.2130677819E+01, 4.1564642884E+00, 9.8478781613E-01],
	[4.9495000000E+04, 4.9734533366E+01, 5.2811130108E+00, 3.2141296116E+01, 4.1567355398E+00, 9.8479371331E-01],
	[4.9500000000E+04, 4.9743521685E+01, 5.2811627566E+00, 3.2151916848E+01, 4.1570067289E+00, 9.8479960782E-01],
	[4.9505000000E+04, 4.9752510719E+01, 5.2812124979E+00, 3.2162540014E+01, 4.1572778556E+00, 9.8480549968E-01],
	[4.9510000000E+04, 4.9761500470E+01, 5.2812622346E+00, 3.2173165616E+01, 4.1575489200E+00, 9.8481138888E-01],
	[4.9515000000E+04, 4.9770490938E+01, 5.2813119668E+00, 3.2183793653E+01, 4.1578199221E+00, 9.8481727543E-01],
	[4.9520000000E+04, 4.9779482121E+01, 5.2813616944E+00, 3.2194424125E+01, 4.1580908619E+00, 9.8482315932E-01],
	[4.9525000000E+04, 4.9788474021E+01, 5.2814114175E+00, 3.2205057034E+01, 4.1583617394E+00, 9.8482904056E-01],
	[4.9530000000E+04, 4.9797466637E+01, 5.2814611360E+00, 3.2215692379E+01, 4.1586325547E+00, 9.8483491915E-01],
	[4.9535000000E+04, 4.9806459969E+01, 5.2815108500E+00, 3.2226330161E+01, 4.1589033078E+00, 9.8484079510E-01],
	[4.9540000000E+04, 4.9815454017E+01, 5.2815605594E+00, 3.2236970380E+01, 4.1591739986E+00, 9.8484666839E-01],
	[4.9545000000E+04, 4.9824448782E+01, 5.2816102643E+00, 3.2247613036E+01, 4.1594446273E+00, 9.8485253904E-01],
	[4.9550000000E+04, 4.9833444263E+01, 5.2816599646E+00, 3.2258258129E+01, 4.1597151938E+00, 9.8485840704E-01],
	[4.9555000000E+04, 4.9842440460E+01, 5.2817096604E+00, 3.2268905660E+01, 4.1599856981E+00, 9.8486427240E-01],
	[4.9560000000E+04, 4.9851437373E+01, 5.2817593516E+00, 3.2279555630E+01, 4.1602561402E+00, 9.8487013511E-01],
	[4.9565000000E+04, 4.9860435002E+01, 5.2818090383E+00, 3.2290208038E+01, 4.1605265203E+00, 9.8487599519E-01],
	[4.9570000000E+04, 4.9869433347E+01, 5.2818587204E+00, 3.2300862885E+01, 4.1607968382E+00, 9.8488185263E-01],
	[4.9575000000E+04, 4.9878432409E+01, 5.2819083980E+00, 3.2311520171E+01, 4.1610670940E+00, 9.8488770743E-01],
	[4.9580000000E+04, 4.9887432186E+01, 5.2819580711E+00, 3.2322179897E+01, 4.1613372877E+00, 9.8489355959E-01],
	[4.9585000000E+04, 4.9896432680E+01, 5.2820077396E+00, 3.2332842062E+01, 4.1616074194E+00, 9.8489940911E-01],
	[4.9590000000E+04, 4.9905433889E+01, 5.2820574036E+00, 3.2343506667E+01, 4.1618774890E+00, 9.8490525600E-01],
	[4.9595000000E+04, 4.9914435815E+01, 5.2821070630E+00, 3.2354173713E+01, 4.1621474966E+00, 9.8491110026E-01],
	[4.9600000000E+04, 4.9923438457E+01, 5.2821567179E+00, 3.2364843200E+01, 4.1624174422E+00, 9.8491694189E-01],
	[4.9605000000E+04, 4.9932441814E+01, 5.2822063682E+00, 3.2375515127E+01, 4.1626873258E+00, 9.8492278089E-01],
	[4.9610000000E+04, 4.9941445888E+01, 5.2822560140E+00, 3.2386189496E+01, 4.1629571474E+00, 9.8492861726E-01],
	[4.9615000000E+04, 4.9950450678E+01, 5.2823056553E+00, 3.2396866306E+01, 4.1632269071E+00, 9.8493445100E-01],
	[4.9620000000E+04, 4.9959456183E+01, 5.2823552921E+00, 3.2407545559E+01, 4.1634966048E+00, 9.8494028212E-01],
	[4.9625000000E+04, 4.9968462405E+01, 5.2824049243E+00, 3.2418227253E+01, 4.1637662406E+00, 9.8494611061E-01],
	[4.9630000000E+04, 4.9977469342E+01, 5.2824545519E+00, 3.2428911390E+01, 4.1640358145E+00, 9.8495193648E-01],
	[4.9635000000E+04, 4.9986476996E+01, 5.2825041751E+00, 3.2439597970E+01, 4.1643053265E+00, 9.8495775973E-01],
	[4.9640000000E+04, 4.9995485365E+01, 5.2825537937E+00, 3.2450286994E+01, 4.1645747766E+00, 9.8496358036E-01],
	[4.9645000000E+04, 5.0004494450E+01, 5.2826034077E+00, 3.2460978460E+01, 4.1648441648E+00, 9.8496939837E-01],
	[4.9650000000E+04, 5.0013504251E+01, 5.2826530173E+00, 3.2471672371E+01, 4.1651134912E+00, 9.8497521376E-01],
	[4.9655000000E+04, 5.0022514768E+01, 5.2827026223E+00, 3.2482368726E+01, 4.1653827558E+00, 9.8498102653E-01],
	[4.9660000000E+04, 5.0031526001E+01, 5.2827522228E+00, 3.2493067525E+01, 4.1656519586E+00, 9.8498683670E-01],
	[4.9665000000E+04, 5.0040537949E+01, 5.2828018187E+00, 3.2503768769E+01, 4.1659210995E+00, 9.8499264424E-01],
	[4.9670000000E+04, 5.0049550614E+01, 5.2828514102E+00, 3.2514472458E+01, 4.1661901787E+00, 9.8499844918E-01],
	[4.9675000000E+04, 5.0058563994E+01, 5.2829009971E+00, 3.2525178592E+01, 4.1664591962E+00, 9.8500425150E-01],
	[4.9680000000E+04, 5.0067578090E+01, 5.2829505794E+00, 3.2535887172E+01, 4.1667281519E+00, 9.8501005122E-01],
	[4.9685000000E+04, 5.0076592901E+01, 5.2830001573E+00, 3.2546598198E+01, 4.1669970459E+00, 9.8501584832E-01],
	[4.9690000000E+04, 5.0085608429E+01, 5.2830497306E+00, 3.2557311670E+01, 4.1672658781E+00, 9.8502164282E-01],
	[4.9695000000E+04, 5.0094624672E+01, 5.2830992994E+00, 3.2568027589E+01, 4.1675346487E+00, 9.8502743472E-01],
	[4.9700000000E+04, 5.0103641631E+01, 5.2831488637E+00, 3.2578745955E+01, 4.1678033576E+00, 9.8503322401E-01],
	[4.9705000000E+04, 5.0112659305E+01, 5.2831984235E+00, 3.2589466768E+01, 4.1680720048E+00, 9.8503901070E-01],
	[4.9710000000E+04, 5.0121677696E+01, 5.2832479787E+00, 3.2600190029E+01, 4.1683405904E+00, 9.8504479479E-01],
	[4.9715000000E+04, 5.0130696802E+01, 5.2832975294E+00, 3.2610915738E+01, 4.1686091144E+00, 9.8505057627E-01],
	[4.9720000000E+04, 5.0139716623E+01, 5.2833470756E+00, 3.2621643894E+01, 4.1688775768E+00, 9.8505635516E-01],
	[4.9725000000E+04, 5.0148737160E+01, 5.2833966173E+00, 3.2632374500E+01, 4.1691459776E+00, 9.8506213146E-01],
	[4.9730000000E+04, 5.0157758413E+01, 5.2834461545E+00, 3.2643107554E+01, 4.1694143168E+00, 9.8506790515E-01],
	[4.9735000000E+04, 5.0166780382E+01, 5.2834956872E+00, 3.2653843057E+01, 4.1696825944E+00, 9.8507367625E-01],
	[4.9740000000E+04, 5.0175803066E+01, 5.2835452153E+00, 3.2664581009E+01, 4.1699508106E+00, 9.8507944476E-01],
	[4.9745000000E+04, 5.0184826465E+01, 5.2835947389E+00, 3.2675321412E+01, 4.1702189651E+00, 9.8508521068E-01],
	[4.9750000000E+04, 5.0193850581E+01, 5.2836442580E+00, 3.2686064264E+01, 4.1704870582E+00, 9.8509097401E-01],
	[4.9755000000E+04, 5.0202875411E+01, 5.2836937726E+00, 3.2696809567E+01, 4.1707550898E+00, 9.8509673475E-01],
	[4.9760000000E+04, 5.0211900958E+01, 5.2837432827E+00, 3.2707557321E+01, 4.1710230599E+00, 9.8510249290E-01],
	[4.9765000000E+04, 5.0220927219E+01, 5.2837927883E+00, 3.2718307525E+01, 4.1712909686E+00, 9.8510824846E-01],
	[4.9770000000E+04, 5.0229954197E+01, 5.2838422893E+00, 3.2729060181E+01, 4.1715588158E+00, 9.8511400144E-01],
	[4.9775000000E+04, 5.0238981890E+01, 5.2838917859E+00, 3.2739815288E+01, 4.1718266016E+00, 9.8511975184E-01],
	[4.9780000000E+04, 5.0248010298E+01, 5.2839412780E+00, 3.2750572847E+01, 4.1720943260E+00, 9.8512549965E-01],
	[4.9785000000E+04, 5.0257039422E+01, 5.2839907655E+00, 3.2761332859E+01, 4.1723619891E+00, 9.8513124488E-01],
	[4.9790000000E+04, 5.0266069261E+01, 5.2840402485E+00, 3.2772095323E+01, 4.1726295907E+00, 9.8513698754E-01],
	[4.9795000000E+04, 5.0275099815E+01, 5.2840897271E+00, 3.2782860240E+01, 4.1728971310E+00, 9.8514272761E-01],
	[4.9800000000E+04, 5.0284131085E+01, 5.2841392011E+00, 3.2793627610E+01, 4.1731646099E+00, 9.8514846511E-01],
	[4.9805000000E+04, 5.0293163071E+01, 5.2841886706E+00, 3.2804397434E+01, 4.1734320276E+00, 9.8515420004E-01],
	[4.9810000000E+04, 5.0302195772E+01, 5.2842381356E+00, 3.2815169711E+01, 4.1736993839E+00, 9.8515993239E-01],
	[4.9815000000E+04, 5.0311229188E+01, 5.2842875961E+00, 3.2825944443E+01, 4.1739666789E+00, 9.8516566216E-01],
	[4.9820000000E+04, 5.0320263319E+01, 5.2843370521E+00, 3.2836721629E+01, 4.1742339127E+00, 9.8517138937E-01],
	[4.9825000000E+04, 5.0329298166E+01, 5.2843865037E+00, 3.2847501269E+01, 4.1745010852E+00, 9.8517711400E-01],
	[4.9830000000E+04, 5.0338333728E+01, 5.2844359507E+00, 3.2858283365E+01, 4.1747681965E+00, 9.8518283607E-01],
	[4.9835000000E+04, 5.0347370006E+01, 5.2844853932E+00, 3.2869067916E+01, 4.1750352465E+00, 9.8518855557E-01],
	[4.9840000000E+04, 5.0356406999E+01, 5.2845348312E+00, 3.2879854923E+01, 4.1753022353E+00, 9.8519427250E-01],
	[4.9845000000E+04, 5.0365444707E+01, 5.2845842647E+00, 3.2890644386E+01, 4.1755691630E+00, 9.8519998687E-01],
	[4.9850000000E+04, 5.0374483130E+01, 5.2846336938E+00, 3.2901436305E+01, 4.1758360295E+00, 9.8520569868E-01],
	[4.9855000000E+04, 5.0383522269E+01, 5.2846831183E+00, 3.2912230681E+01, 4.1761028348E+00, 9.8521140792E-01],
	[4.9860000000E+04, 5.0392570146E+01, 5.2847333341E+00, 3.2923027513E+01, 4.1763701311E+00, 9.8521711460E-01],
	[4.9865000000E+04, 5.0401627039E+01, 5.2847843683E+00, 3.2933826803E+01, 4.1766379373E+00, 9.8522281873E-01],
	[4.9870000000E+04, 5.0410684651E+01, 5.2848353979E+00, 3.2944628551E+01, 4.1769056826E+00, 9.8522852029E-01],
	[4.9875000000E+04, 5.0419742983E+01, 5.2848864228E+00, 3.2955432756E+01, 4.1771733668E+00, 9.8523421930E-01],
	[4.9880000000E+04, 5.0428802034E+01, 5.2849374432E+00, 3.2966239419E+01, 4.1774409901E+00, 9.8523991576E-01],
	[4.9885000000E+04, 5.0437861804E+01, 5.2849884589E+00, 3.2977048541E+01, 4.1777085525E+00, 9.8524560966E-01],
	[4.9890000000E+04, 5.0446922294E+01, 5.2850394700E+00, 3.2987860122E+01, 4.1779760540E+00, 9.8525130101E-01],
	[4.9895000000E+04, 5.0455983503E+01, 5.2850904765E+00, 3.2998674162E+01, 4.1782434945E+00, 9.8525698980E-01],
	[4.9900000000E+04, 5.0465045432E+01, 5.2851414783E+00, 3.3009490661E+01, 4.1785108741E+00, 9.8526267605E-01],
	[4.9905000000E+04, 5.0474108079E+01, 5.2851924755E+00, 3.3020309620E+01, 4.1787781929E+00, 9.8526835975E-01],
	[4.9910000000E+04, 5.0483171447E+01, 5.2852434682E+00, 3.3031131039E+01, 4.1790454509E+00, 9.8527404090E-01],
	[4.9915000000E+04, 5.0492235533E+01, 5.2852944562E+00, 3.3041954918E+01, 4.1793126479E+00, 9.8527971950E-01],
	[4.9920000000E+04, 5.0501300339E+01, 5.2853454395E+00, 3.3052781258E+01, 4.1795797842E+00, 9.8528539556E-01],
	[4.9925000000E+04, 5.0510365864E+01, 5.2853964183E+00, 3.3063610059E+01, 4.1798468597E+00, 9.8529106908E-01],
	[4.9930000000E+04, 5.0519432108E+01, 5.2854473925E+00, 3.3074441322E+01, 4.1801138743E+00, 9.8529674006E-01],
	[4.9935000000E+04, 5.0528499071E+01, 5.2854983620E+00, 3.3085275046E+01, 4.1803808282E+00, 9.8530240849E-01],
	[4.9940000000E+04, 5.0537566754E+01, 5.2855493270E+00, 3.3096111232E+01, 4.1806477214E+00, 9.8530807438E-01],
	[4.9945000000E+04, 5.0546635156E+01, 5.2856002873E+00, 3.3106949880E+01, 4.1809145538E+00, 9.8531373774E-01],
	[4.9950000000E+04, 5.0555704277E+01, 5.2856512430E+00, 3.3117790990E+01, 4.1811813254E+00, 9.8531939856E-01],
	[4.9955000000E+04, 5.0564774117E+01, 5.2857021941E+00, 3.3128634564E+01, 4.1814480364E+00, 9.8532505684E-01],
	[4.9960000000E+04, 5.0573844677E+01, 5.2857531406E+00, 3.3139480601E+01, 4.1817146867E+00, 9.8533071259E-01],
	[4.9965000000E+04, 5.0582915955E+01, 5.2858040825E+00, 3.3150329101E+01, 4.1819812763E+00, 9.8533636580E-01],
	[4.9970000000E+04, 5.0591987953E+01, 5.2858550198E+00, 3.3161180065E+01, 4.1822478053E+00, 9.8534201648E-01],
	[4.9975000000E+04, 5.0601060670E+01, 5.2859059524E+00, 3.3172033493E+01, 4.1825142736E+00, 9.8534766463E-01],
	[4.9980000000E+04, 5.0610134105E+01, 5.2859568805E+00, 3.3182889385E+01, 4.1827806813E+00, 9.8535331025E-01],
	[4.9985000000E+04, 5.0619208260E+01, 5.2860078040E+00, 3.3193747742E+01, 4.1830470283E+00, 9.8535895334E-01],
	[4.9990000000E+04, 5.0628283134E+01, 5.2860587228E+00, 3.3204608565E+01, 4.1833133148E+00, 9.8536459390E-01],
	[4.9995000000E+04, 5.0637358727E+01, 5.2861096371E+00, 3.3215471852E+01, 4.1835795408E+00, 9.8537023193E-01],
	[5.0000000000E+04, 5.0646435040E+01, 5.2861605468E+00, 3.3226337606E+01, 4.1838457061E+00, 9.8537586744E-01],
	[5.0005000000E+04, 5.0655512071E+01, 5.2862114518E+00, 3.3237220253E+01, 4.1841120396E+00, 9.8538150043E-01],
	[5.0010000000E+04, 5.0664589821E+01, 5.2862623523E+00, 3.3248105375E+01, 4.1843783124E+00, 9.8538713089E-01],
	[5.0015000000E+04, 5.0673668290E+01, 5.2863132481E+00, 3.3258992972E+01, 4.1846445246E+00, 9.8539275884E-01],
	[5.0020000000E+04, 5.0682747478E+01, 5.2863641394E+00, 3.3269883043E+01, 4.1849106762E+00, 9.8539838426E-01],
	[5.0025000000E+04, 5.0691827385E