import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

brain_ICRP110_MFP = np.array([
	[5.0000000000E+03, 1.8003368457E+00, 7.9768757417E+00, 2.2802240236E-02, 2.2453667618E-02, 3.4332911249E-01],
	[5.0050000000E+03, 1.8023888079E+00, 7.9720672705E+00, 2.2870724012E-02, 2.2520352919E-02, 3.4358719953E-01],
	[5.0100000000E+03, 1.8044410565E+00, 7.9672664948E+00, 2.2939344493E-02, 2.2587167330E-02, 3.4384499717E-01],
	[5.0150000000E+03, 1.8064935912E+00, 7.9624733945E+00, 2.3008101812E-02, 2.2654110962E-02, 3.4410250613E-01],
	[5.0200000000E+03, 1.8085464118E+00, 7.9576879499E+00, 2.3076996106E-02, 2.2721183924E-02, 3.4435972712E-01],
	[5.0250000000E+03, 1.8105995180E+00, 7.9529101411E+00, 2.3146027510E-02, 2.2788386327E-02, 3.4461666084E-01],
	[5.0300000000E+03, 1.8126529096E+00, 7.9481399483E+00, 2.3215196158E-02, 2.2855718279E-02, 3.4487330800E-01],
	[5.0350000000E+03, 1.8147065863E+00, 7.9433773517E+00, 2.3284502186E-02, 2.2923179891E-02, 3.4512966929E-01],
	[5.0400000000E+03, 1.8167605479E+00, 7.9386223319E+00, 2.3353945728E-02, 2.2990771272E-02, 3.4538574542E-01],
	[5.0450000000E+03, 1.8188147942E+00, 7.9338748692E+00, 2.3423526920E-02, 2.3058492532E-02, 3.4564153708E-01],
	[5.0500000000E+03, 1.8208693249E+00, 7.9291349441E+00, 2.3493245897E-02, 2.3126343779E-02, 3.4589704496E-01],
	[5.0550000000E+03, 1.8229241398E+00, 7.9244025373E+00, 2.3563102794E-02, 2.3194325125E-02, 3.4615226975E-01],
	[5.0600000000E+03, 1.8249792386E+00, 7.9196776294E+00, 2.3633097747E-02, 2.3262436677E-02, 3.4640721214E-01],
	[5.0650000000E+03, 1.8270346210E+00, 7.9149602011E+00, 2.3703230889E-02, 2.3330678546E-02, 3.4666187282E-01],
	[5.0700000000E+03, 1.8290902869E+00, 7.9102502332E+00, 2.3773502356E-02, 2.3399050840E-02, 3.4691625245E-01],
	[5.0750000000E+03, 1.8311462360E+00, 7.9055477066E+00, 2.3843912283E-02, 2.3467553668E-02, 3.4717035174E-01],
	[5.0800000000E+03, 1.8332024681E+00, 7.9008526022E+00, 2.3914460806E-02, 2.3536187140E-02, 3.4742417135E-01],
	[5.0850000000E+03, 1.8352723148E+00, 7.8962446697E+00, 2.3985148059E-02, 2.3604954284E-02, 3.4767771195E-01],
	[5.0900000000E+03, 1.8373437556E+00, 7.8916516839E+00, 2.4055974177E-02, 2.3673852600E-02, 3.4793097423E-01],
	[5.0950000000E+03, 1.8394154972E+00, 7.8870658753E+00, 2.4126939296E-02, 2.3742881917E-02, 3.4818395884E-01],
	[5.1000000000E+03, 1.8414875393E+00, 7.8824872257E+00, 2.4198043550E-02, 2.3812042343E-02, 3.4843666646E-01],
	[5.1050000000E+03, 1.8435598817E+00, 7.8779157168E+00, 2.4269287075E-02, 2.3881333987E-02, 3.4868909775E-01],
	[5.1100000000E+03, 1.8456325240E+00, 7.8733513307E+00, 2.4340670005E-02, 2.3950756958E-02, 3.4894125338E-01],
	[5.1150000000E+03, 1.8477054661E+00, 7.8687940492E+00, 2.4412192475E-02, 2.4020311365E-02, 3.4919313400E-01],
	[5.1200000000E+03, 1.8497787076E+00, 7.8642438543E+00, 2.4483854621E-02, 2.4089997317E-02, 3.4944474027E-01],
	[5.1250000000E+03, 1.8518522484E+00, 7.8597007281E+00, 2.4555656578E-02, 2.4159814922E-02, 3.4969607285E-01],
	[5.1300000000E+03, 1.8539260882E+00, 7.8551646528E+00, 2.4627598480E-02, 2.4229764289E-02, 3.4994713238E-01],
	[5.1350000000E+03, 1.8560002268E+00, 7.8506356106E+00, 2.4699680463E-02, 2.4299845526E-02, 3.5019791953E-01],
	[5.1400000000E+03, 1.8580746638E+00, 7.8461135837E+00, 2.4771902661E-02, 2.4370058742E-02, 3.5044843493E-01],
	[5.1450000000E+03, 1.8601493991E+00, 7.8415985544E+00, 2.4844265210E-02, 2.4440404045E-02, 3.5069867924E-01],
	[5.1500000000E+03, 1.8622244323E+00, 7.8370905051E+00, 2.4916768245E-02, 2.4510881543E-02, 3.5094865309E-01],
	[5.1550000000E+03, 1.8642997633E+00, 7.8325894184E+00, 2.4989411900E-02, 2.4581491345E-02, 3.5119835713E-01],
	[5.1600000000E+03, 1.8663753919E+00, 7.8280952766E+00, 2.5062196311E-02, 2.4652233559E-02, 3.5144779200E-01],
	[5.1650000000E+03, 1.8684591903E+00, 7.8236546720E+00, 2.5135121612E-02, 2.4723110136E-02, 3.5169695833E-01],
	[5.1700000000E+03, 1.8705496407E+00, 7.8192583814E+00, 2.5208187939E-02, 2.4794120851E-02, 3.5194585676E-01],
	[5.1750000000E+03, 1.8726404057E+00, 7.8148688074E+00, 2.5281395426E-02, 2.4865264332E-02, 3.5219448792E-01],
	[5.1800000000E+03, 1.8747314852E+00, 7.8104859330E+00, 2.5354744209E-02, 2.4936540687E-02, 3.5244285243E-01],
	[5.1850000000E+03, 1.8768228788E+00, 7.8061097417E+00, 2.5428234423E-02, 2.5007950025E-02, 3.5269095094E-01],
	[5.1900000000E+03, 1.8789145864E+00, 7.8017402169E+00, 2.5501866202E-02, 2.5079492454E-02, 3.5293878405E-01],
	[5.1950000000E+03, 1.8810066076E+00, 7.7973773419E+00, 2.5575639681E-02, 2.5151168081E-02, 3.5318635240E-01],
	[5.2000000000E+03, 1.8830989422E+00, 7.7930211003E+00, 2.5649554996E-02, 2.5222977014E-02, 3.5343365660E-01],
	[5.2050000000E+03, 1.8851915900E+00, 7.7886714757E+00, 2.5723612281E-02, 2.5294919362E-02, 3.5368069728E-01],
	[5.2100000000E+03, 1.8872845507E+00, 7.7843284515E+00, 2.5797811672E-02, 2.5366995231E-02, 3.5392747504E-01],
	[5.2150000000E+03, 1.8893778240E+00, 7.7799920116E+00, 2.5872153303E-02, 2.5439204729E-02, 3.5417399052E-01],
	[5.2200000000E+03, 1.8914714098E+00, 7.7756621395E+00, 2.5946637309E-02, 2.5511547964E-02, 3.5442024430E-01],
	[5.2250000000E+03, 1.8935653077E+00, 7.7713388192E+00, 2.6021263825E-02, 2.5584025044E-02, 3.5466623702E-01],
	[5.2300000000E+03, 1.8956595174E+00, 7.7670220344E+00, 2.6096032987E-02, 2.5656636075E-02, 3.5491196926E-01],
	[5.2350000000E+03, 1.8977540389E+00, 7.7627117689E+00, 2.6170944928E-02, 2.5729381164E-02, 3.5515744165E-01],
	[5.2400000000E+03, 1.8998488717E+00, 7.7584080068E+00, 2.6245999785E-02, 2.5802260421E-02, 3.5540265478E-01],
	[5.2450000000E+03, 1.9019440156E+00, 7.7541107321E+00, 2.6321197692E-02, 2.5875273950E-02, 3.5564760925E-01],
	[5.2500000000E+03, 1.9040523516E+00, 7.7498953584E+00, 2.6396538783E-02, 2.5948425098E-02, 3.5589230567E-01],
	[5.2550000000E+03, 1.9061619414E+00, 7.7456917052E+00, 2.6472023195E-02, 2.6021710997E-02, 3.5613674462E-01],
	[5.2600000000E+03, 1.9082718590E+00, 7.7414943266E+00, 2.6547651061E-02, 2.6095131522E-02, 3.5638092671E-01],
	[5.2650000000E+03, 1.9103821040E+00, 7.7373032074E+00, 2.6623422516E-02, 2.6168686780E-02, 3.5662485253E-01],
	[5.2700000000E+03, 1.9124926762E+00, 7.7331183322E+00, 2.6699337697E-02, 2.6242376878E-02, 3.5686852267E-01],
	[5.2750000000E+03, 1.9146035753E+00, 7.7289396858E+00, 2.6775396737E-02, 2.6316201923E-02, 3.5711193772E-01],
	[5.2800000000E+03, 1.9167148011E+00, 7.7247672532E+00, 2.6851599771E-02, 2.6390162023E-02, 3.5735509827E-01],
	[5.2850000000E+03, 1.9188263533E+00, 7.7206010191E+00, 2.6927946935E-02, 2.6464257282E-02, 3.5759800489E-01],
	[5.2900000000E+03, 1.9209382317E+00, 7.7164409685E+00, 2.7004438362E-02, 2.6538487810E-02, 3.5784065818E-01],
	[5.2950000000E+03, 1.9230504359E+00, 7.7122870864E+00, 2.7081074189E-02, 2.6612853712E-02, 3.5808305871E-01],
	[5.3000000000E+03, 1.9251629658E+00, 7.7081393579E+00, 2.7157854550E-02, 2.6687355094E-02, 3.5832520706E-01],
	[5.3050000000E+03, 1.9272758211E+00, 7.7039977680E+00, 2.7234779580E-02, 2.6761992064E-02, 3.5856710381E-01],
	[5.3100000000E+03, 1.9293890015E+00, 7.6998623019E+00, 2.7311849414E-02, 2.6836764727E-02, 3.5880874954E-01],
	[5.3150000000E+03, 1.9315025068E+00, 7.6957329447E+00, 2.7389064186E-02, 2.6911673191E-02, 3.5905014481E-01],
	[5.3200000000E+03, 1.9336163367E+00, 7.6916096818E+00, 2.7466424032E-02, 2.6986717562E-02, 3.5929129020E-01],
	[5.3250000000E+03, 1.9357304910E+00, 7.6874924983E+00, 2.7543929087E-02, 2.7061897945E-02, 3.5953218632E-01],
	[5.3300000000E+03, 1.9378455632E+00, 7.6833848297E+00, 2.7621579484E-02, 2.7137214606E-02, 3.5977283388E-01],
	[5.3350000000E+03, 1.9399737645E+00, 7.6793574649E+00, 2.7699375360E-02, 2.7212670947E-02, 3.6001323355E-01],
	[5.3400000000E+03, 1.9421023061E+00, 7.6753359809E+00, 2.7777316849E-02, 2.7288263650E-02, 3.6025338598E-01],
	[5.3450000000E+03, 1.9442311877E+00, 7.6713203636E+00, 2.7855404086E-02, 2.7363992823E-02, 3.6049329181E-01],
	[5.3500000000E+03, 1.9463604092E+00, 7.6673105989E+00, 2.7933637206E-02, 2.7439858571E-02, 3.6073295167E-01],
	[5.3550000000E+03, 1.9484899703E+00, 7.6633066728E+00, 2.8012016343E-02, 2.7515861001E-02, 3.6097236622E-01],
	[5.3600000000E+03, 1.9506198706E+00, 7.6593085715E+00, 2.8090541633E-02, 2.7592000218E-02, 3.6121153609E-01],
	[5.3650000000E+03, 1.9527501099E+00, 7.6553162809E+00, 2.8169213210E-02, 2.7668276329E-02, 3.6145046191E-01],
	[5.3700000000E+03, 1.9548806880E+00, 7.6513297873E+00, 2.8248031209E-02, 2.7744689439E-02, 3.6168914433E-01],
	[5.3750000000E+03, 1.9570116046E+00, 7.6473490769E+00, 2.8326995766E-02, 2.7821239653E-02, 3.6192758396E-01],
	[5.3800000000E+03, 1.9591428595E+00, 7.6433741359E+00, 2.8406107014E-02, 2.7897927078E-02, 3.6216578144E-01],
	[5.3850000000E+03, 1.9612744523E+00, 7.6394049505E+00, 2.8485365089E-02, 2.7974751820E-02, 3.6240373739E-01],
	[5.3900000000E+03, 1.9634063828E+00, 7.6354415072E+00, 2.8564770126E-02, 2.8051713982E-02, 3.6264145244E-01],
	[5.3950000000E+03, 1.9655386508E+00, 7.6314837922E+00, 2.8644322259E-02, 2.8128813672E-02, 3.6287892720E-01],
	[5.4000000000E+03, 1.9676712560E+00, 7.6275317921E+00, 2.8724021623E-02, 2.8206050995E-02, 3.6311616230E-01],
	[5.4050000000E+03, 1.9698041981E+00, 7.6235854933E+00, 2.8803868353E-02, 2.8283426055E-02, 3.6335315836E-01],
	[5.4100000000E+03, 1.9719374769E+00, 7.6196448823E+00, 2.8883862584E-02, 2.8360938959E-02, 3.6358991598E-01],
	[5.4150000000E+03, 1.9740710922E+00, 7.6157099456E+00, 2.8964004451E-02, 2.8438589810E-02, 3.6382643579E-01],
	[5.4200000000E+03, 1.9762165228E+00, 7.6118466977E+00, 2.9044294088E-02, 2.8516382032E-02, 3.6406271838E-01],
	[5.4250000000E+03, 1.9783638120E+00, 7.6079976319E+00, 2.9124731630E-02, 2.8594312879E-02, 3.6429876437E-01],
	[5.4300000000E+03, 1.9805114531E+00, 7.6041540557E+00, 2.9205317213E-02, 2.8672382022E-02, 3.6453457436E-01],
	[5.4350000000E+03, 1.9826594457E+00, 7.6003159562E+00, 2.9286050970E-02, 2.8750589567E-02, 3.6477014895E-01],
	[5.4400000000E+03, 1.9848077895E+00, 7.5964833205E+00, 2.9366933037E-02, 2.8828935618E-02, 3.6500548876E-01],
	[5.4450000000E+03, 1.9869564844E+00, 7.5926561359E+00, 2.9447963549E-02, 2.8907420280E-02, 3.6524059436E-01],
	[5.4500000000E+03, 1.9891055299E+00, 7.5888343895E+00, 2.9529142639E-02, 2.8986043658E-02, 3.6547546636E-01],
	[5.4550000000E+03, 1.9912549259E+00, 7.5850180688E+00, 2.9610470444E-02, 2.9064805858E-02, 3.6571010536E-01],
	[5.4600000000E+03, 1.9934046722E+00, 7.5812071610E+00, 2.9691947098E-02, 2.9143706983E-02, 3.6594451195E-01],
	[5.4650000000E+03, 1.9955547683E+00, 7.5774016536E+00, 2.9773572735E-02, 2.9222747138E-02, 3.6617868671E-01],
	[5.4700000000E+03, 1.9977052141E+00, 7.5736015339E+00, 2.9855347491E-02, 2.9301926429E-02, 3.6641263023E-01],
	[5.4750000000E+03, 1.9998560094E+00, 7.5698067893E+00, 2.9937271500E-02, 2.9381244958E-02, 3.6664634311E-01],
	[5.4800000000E+03, 2.0020071537E+00, 7.5660174075E+00, 3.0019692616E-02, 2.9461037730E-02, 3.6687982591E-01],
	[5.4850000000E+03, 2.0041586470E+00, 7.5622333759E+00, 3.0102545432E-02, 2.9541241652E-02, 3.6711307923E-01],
	[5.4900000000E+03, 2.0063104889E+00, 7.5584546820E+00, 3.0185550798E-02, 2.9621587821E-02, 3.6734610364E-01],
	[5.4950000000E+03, 2.0084626792E+00, 7.5546813137E+00, 3.0268708855E-02, 2.9702076347E-02, 3.6757889972E-01],
	[5.5000000000E+03, 2.0106152175E+00, 7.5509132584E+00, 3.0352019743E-02, 2.9782707339E-02, 3.6781146805E-01],
	[5.5050000000E+03, 2.0127737261E+00, 7.5471826243E+00, 3.0435483603E-02, 2.9863482645E-02, 3.6804380919E-01],
	[5.5100000000E+03, 2.0149395430E+00, 7.5434968818E+00, 3.0519100575E-02, 2.9944402811E-02, 3.6827592372E-01],
	[5.5150000000E+03, 2.0171057228E+00, 7.5398162799E+00, 3.0602870801E-02, 3.0025465803E-02, 3.6850781221E-01],
	[5.5200000000E+03, 2.0192722651E+00, 7.5361408068E+00, 3.0686794421E-02, 3.0106671730E-02, 3.6873947522E-01],
	[5.5250000000E+03, 2.0214391698E+00, 7.5324704507E+00, 3.0770871575E-02, 3.0188020701E-02, 3.6897091332E-01],
	[5.5300000000E+03, 2.0236064366E+00, 7.5288051999E+00, 3.0855102404E-02, 3.0269512825E-02, 3.6920212707E-01],
	[5.5350000000E+03, 2.0257740651E+00, 7.5251450425E+00, 3.0939487049E-02, 3.0351148209E-02, 3.6943311704E-01],
	[5.5400000000E+03, 2.0279420552E+00, 7.5214899671E+00, 3.1024025650E-02, 3.0432926964E-02, 3.6966388377E-01],
	[5.5450000000E+03, 2.0301104066E+00, 7.5178399619E+00, 3.1108718348E-02, 3.0514849197E-02, 3.6989442783E-01],
	[5.5500000000E+03, 2.0322791189E+00, 7.5141950154E+00, 3.1193565284E-02, 3.0596915017E-02, 3.7012474977E-01],
	[5.5550000000E+03, 2.0344481920E+00, 7.5105551159E+00, 3.1278566597E-02, 3.0679124532E-02, 3.7035485014E-01],
	[5.5600000000E+03, 2.0366176255E+00, 7.5069202520E+00, 3.1363722429E-02, 3.0761477851E-02, 3.7058472951E-01],
	[5.5650000000E+03, 2.0387874193E+00, 7.5032904122E+00, 3.1449032921E-02, 3.0843975081E-02, 3.7081438840E-01],
	[5.5700000000E+03, 2.0409575729E+00, 7.4996655850E+00, 3.1534498213E-02, 3.0926616332E-02, 3.7104382738E-01],
	[5.5750000000E+03, 2.0431280863E+00, 7.4960457590E+00, 3.1620118445E-02, 3.1009401711E-02, 3.7127304698E-01],
	[5.5800000000E+03, 2.0452989591E+00, 7.4924309228E+00, 3.1705893758E-02, 3.1092331325E-02, 3.7150204775E-01],
	[5.5850000000E+03, 2.0474701910E+00, 7.4888210652E+00, 3.1791824293E-02, 3.1175405284E-02, 3.7173083023E-01],
	[5.5900000000E+03, 2.0496417818E+00, 7.4852161748E+00, 3.1877910190E-02, 3.1258623695E-02, 3.7195939496E-01],
	[5.5950000000E+03, 2.0518226070E+00, 7.4816666010E+00, 3.1964151590E-02, 3.1341989620E-02, 3.7218774247E-01],
	[5.6000000000E+03, 2.0540070892E+00, 7.4781405051E+00, 3.2050548634E-02, 3.1425501336E-02, 3.7241587331E-01],
	[5.6050000000E+03, 2.0561919445E+00, 7.4746192159E+00, 3.2137101462E-02, 3.1509157862E-02, 3.7264378801E-01],
	[5.6100000000E+03, 2.0583771726E+00, 7.4711027222E+00, 3.2223810215E-02, 3.1592959307E-02, 3.7287148709E-01],
	[5.6150000000E+03, 2.0605627732E+00, 7.4675910135E+00, 3.2310675033E-02, 3.1676905776E-02, 3.7309897109E-01],
	[5.6200000000E+03, 2.0627487460E+00, 7.4640840789E+00, 3.2397696057E-02, 3.1760997379E-02, 3.7332624054E-01],
	[5.6250000000E+03, 2.0649350908E+00, 7.4605819077E+00, 3.2484873428E-02, 3.1845234222E-02, 3.7355329595E-01],
	[5.6300000000E+03, 2.0671218073E+00, 7.4570844892E+00, 3.2572207285E-02, 3.1929616413E-02, 3.7378013787E-01],
	[5.6350000000E+03, 2.0693088952E+00, 7.4535918127E+00, 3.2659697771E-02, 3.2014144059E-02, 3.7400676680E-01],
	[5.6400000000E+03, 2.0714963543E+00, 7.4501038677E+00, 3.2747345025E-02, 3.2098817268E-02, 3.7423318328E-01],
	[5.6450000000E+03, 2.0736841844E+00, 7.4466206434E+00, 3.2835149188E-02, 3.2183636148E-02, 3.7445938781E-01],
	[5.6500000000E+03, 2.0758723850E+00, 7.4431421294E+00, 3.2923110400E-02, 3.2268600804E-02, 3.7468538099E-01],
	[5.6550000000E+03, 2.0780609560E+00, 7.4396683151E+00, 3.3011228802E-02, 3.2353711345E-02, 3.7491116344E-01],
	[5.6600000000E+03, 2.0802498971E+00, 7.4361991901E+00, 3.3099504536E-02, 3.2438967877E-02, 3.7513673571E-01],
	[5.6650000000E+03, 2.0824392081E+00, 7.4327347438E+00, 3.3187937740E-02, 3.2524370507E-02, 3.7536209838E-01],
	[5.6700000000E+03, 2.0846288887E+00, 7.4292749658E+00, 3.3276528557E-02, 3.2609919343E-02, 3.7558725201E-01],
	[5.6750000000E+03, 2.0868189385E+00, 7.4258198458E+00, 3.3365277126E-02, 3.2695614490E-02, 3.7581219716E-01],
	[5.6800000000E+03, 2.0890093574E+00, 7.4223693733E+00, 3.3454183588E-02, 3.2781456056E-02, 3.7603693439E-01],
	[5.6850000000E+03, 2.0912086880E+00, 7.4189717584E+00, 3.3543248084E-02, 3.2867447204E-02, 3.7626146427E-01],
	[5.6900000000E+03, 2.0934116043E+00, 7.4155967572E+00, 3.3632470754E-02, 3.2953586161E-02, 3.7648578735E-01],
	[5.6950000000E+03, 2.0956149031E+00, 7.4122262537E+00, 3.3721851740E-02, 3.3039871892E-02, 3.7670990418E-01],
	[5.7000000000E+03, 2.0978185844E+00, 7.4088602381E+00, 3.3811391180E-02, 3.3126304504E-02, 3.7693381532E-01],
	[5.7050000000E+03, 2.1000226476E+00, 7.4054987004E+00, 3.3901089217E-02, 3.3212884104E-02, 3.7715752132E-01],
	[5.7100000000E+03, 2.1022270927E+00, 7.4021416307E+00, 3.3990945990E-02, 3.3299610797E-02, 3.7738102272E-01],
	[5.7150000000E+03, 2.1044319193E+00, 7.3987890191E+00, 3.4080961641E-02, 3.3386484689E-02, 3.7760432008E-01],
	[5.7200000000E+03, 2.1066371272E+00, 7.3954408560E+00, 3.4171136310E-02, 3.3473505889E-02, 3.7782741394E-01],
	[5.7250000000E+03, 2.1088427161E+00, 7.3920971315E+00, 3.4261470137E-02, 3.3560674501E-02, 3.7805030484E-01],
	[5.7300000000E+03, 2.1110486857E+00, 7.3887578358E+00, 3.4351963263E-02, 3.3647990631E-02, 3.7827299332E-01],
	[5.7350000000E+03, 2.1132550357E+00, 7.3854229592E+00, 3.4442645916E-02, 3.3735483251E-02, 3.7849547992E-01],
	[5.7400000000E+03, 2.1154617660E+00, 7.3820924920E+00, 3.4533522587E-02, 3.3823156634E-02, 3.7871776518E-01],
	[5.7450000000E+03, 2.1176688762E+00, 7.3787664246E+00, 3.4624559304E-02, 3.3910978154E-02, 3.7893984963E-01],
	[5.7500000000E+03, 2.1198763660E+00, 7.3754447473E+00, 3.4715756205E-02, 3.3998947918E-02, 3.7916173381E-01],
	[5.7550000000E+03, 2.1220842352E+00, 7.3721274506E+00, 3.4807113434E-02, 3.4087066033E-02, 3.7938341825E-01],
	[5.7600000000E+03, 2.1242924836E+00, 7.3688145247E+00, 3.4898631131E-02, 3.4175332603E-02, 3.7960490347E-01],
	[5.7650000000E+03, 2.1265011109E+00, 7.3655059603E+00, 3.4990309438E-02, 3.4263747737E-02, 3.7982619001E-01],
	[5.7700000000E+03, 2.1287101167E+00, 7.3622017478E+00, 3.5082148495E-02, 3.4352311540E-02, 3.8004727838E-01],
	[5.7750000000E+03, 2.1309244267E+00, 7.3589295852E+00, 3.5174148446E-02, 3.4441026012E-02, 3.8026816913E-01],
	[5.7800000000E+03, 2.1331455292E+00, 7.3556977002E+00, 3.5266309430E-02, 3.4529891853E-02, 3.8048886275E-01],
	[5.7850000000E+03, 2.1353670232E+00, 7.3524700272E+00, 3.5358631589E-02, 3.4618906718E-02, 3.8070935979E-01],
	[5.7900000000E+03, 2.1375889084E+00, 7.3492465572E+00, 3.5451115065E-02, 3.4708070713E-02, 3.8092966074E-01],
	[5.7950000000E+03, 2.1398111847E+00, 7.3460272810E+00, 3.5543759998E-02, 3.4797383944E-02, 3.8114976614E-01],
	[5.8000000000E+03, 2.1420338518E+00, 7.3428121896E+00, 3.5636566531E-02, 3.4886846517E-02, 3.8136967649E-01],
	[5.8050000000E+03, 2.1442569093E+00, 7.3396012740E+00, 3.5729534804E-02, 3.4976458537E-02, 3.8158939231E-01],
	[5.8100000000E+03, 2.1464803570E+00, 7.3363945251E+00, 3.5822664960E-02, 3.5066220111E-02, 3.8180891411E-01],
	[5.8150000000E+03, 2.1487041947E+00, 7.3331919339E+00, 3.5915957138E-02, 3.5156131344E-02, 3.8202824240E-01],
	[5.8200000000E+03, 2.1509284221E+00, 7.3299934916E+00, 3.6009411482E-02, 3.5246192342E-02, 3.8224737768E-01],
	[5.8250000000E+03, 2.1531530389E+00, 7.3267991891E+00, 3.6103028131E-02, 3.5336403211E-02, 3.8246632046E-01],
	[5.8300000000E+03, 2.1553780448E+00, 7.3236090175E+00, 3.6196807228E-02, 3.5426764055E-02, 3.8268507125E-01],
	[5.8350000000E+03, 2.1576034396E+00, 7.3204229680E+00, 3.6290748914E-02, 3.5517274981E-02, 3.8290363055E-01],
	[5.8400000000E+03, 2.1598292230E+00, 7.3172410318E+00, 3.6384853330E-02, 3.5607936094E-02, 3.8312199885E-01],
	[5.8450000000E+03, 2.1620553947E+00, 7.3140631999E+00, 3.6479120617E-02, 3.5698747498E-02, 3.8334017666E-01],
	[5.8500000000E+03, 2.1642819546E+00, 7.3108894637E+00, 3.6573550917E-02, 3.5789709300E-02, 3.8355816447E-01],
	[5.8550000000E+03, 2.1665089022E+00, 7.3077198143E+00, 3.6668144372E-02, 3.5880821603E-02, 3.8377596278E-01],
	[5.8600000000E+03, 2.1687362375E+00, 7.3045542429E+00, 3.6762901122E-02, 3.5972084515E-02, 3.8399357209E-01],
	[5.8650000000E+03, 2.1709639600E+00, 7.3013927409E+00, 3.6857821309E-02, 3.6063498138E-02, 3.8421099288E-01],
	[5.8700000000E+03, 2.1732013244E+00, 7.2982871959E+00, 3.6952905074E-02, 3.6155066414E-02, 3.8442822564E-01],
	[5.8750000000E+03, 2.1754407490E+00, 7.2951949215E+00, 3.7048152559E-02, 3.6246786334E-02, 3.8464527086E-01],
	[5.8800000000E+03, 2.1776805732E+00, 7.2921065861E+00, 3.7143563905E-02, 3.6338657319E-02, 3.8486212904E-01],
	[5.8850000000E+03, 2.1799207967E+00, 7.2890221816E+00, 3.7239139254E-02, 3.6430679472E-02, 3.8507880065E-01],
	[5.8900000000E+03, 2.1821614194E+00, 7.2859416994E+00, 3.7334878746E-02, 3.6522852899E-02, 3.8529528618E-01],
	[5.8950000000E+03, 2.1844024409E+00, 7.2828651314E+00, 3.7430782524E-02, 3.6615177704E-02, 3.8551158611E-01],
	[5.9000000000E+03, 2.1866438609E+00, 7.2797924692E+00, 3.7526850728E-02, 3.6707653992E-02, 3.8572770092E-01],
	[5.9050000000E+03, 2.1888856793E+00, 7.2767237046E+00, 3.7623083500E-02, 3.6800281867E-02, 3.8594363109E-01],
	[5.9100000000E+03, 2.1911278957E+00, 7.2736588293E+00, 3.7719480981E-02, 3.6893061434E-02, 3.8615937710E-01],
	[5.9150000000E+03, 2.1933705099E+00, 7.2705978351E+00, 3.7816043313E-02, 3.6985992797E-02, 3.8637493942E-01],
	[5.9200000000E+03, 2.1956135215E+00, 7.2675407139E+00, 3.7912770637E-02, 3.7079076061E-02, 3.8659031853E-01],
	[5.9250000000E+03, 2.1978569304E+00, 7.2644874574E+00, 3.8009663094E-02, 3.7172311330E-02, 3.8680551490E-01],
	[5.9300000000E+03, 2.2001007363E+00, 7.2614380575E+00, 3.8106720826E-02, 3.7265698707E-02, 3.8702052899E-01],
	[5.9350000000E+03, 2.2023449389E+00, 7.2583925061E+00, 3.8203943973E-02, 3.7359238297E-02, 3.8723536129E-01],
	[5.9400000000E+03, 2.2045895379E+00, 7.2553507952E+00, 3.8301332679E-02, 3.7452930205E-02, 3.8745001225E-01],
	[5.9450000000E+03, 2.2068345331E+00, 7.2523129166E+00, 3.8398887083E-02, 3.7546774533E-02, 3.8766448234E-01],
	[5.9500000000E+03, 2.2090799242E+00, 7.2492788623E+00, 3.8496607327E-02, 3.7640771385E-02, 3.8787877203E-01],
	[5.9550000000E+03, 2.2113257109E+00, 7.2462486242E+00, 3.8594493553E-02, 3.7734920866E-02, 3.8809288168E-01],
	[5.9600000000E+03, 2.2135718931E+00, 7.2432221944E+00, 3.8692545902E-02, 3.7829223079E-02, 3.8830681171E-01],
	[5.9650000000E+03, 2.2158285686E+00, 7.2402561078E+00, 3.8790764515E-02, 3.7923682638E-02, 3.8852056260E-01],
	[5.9700000000E+03, 2.2180860539E+00, 7.2372959714E+00, 3.8889149533E-02, 3.8018295352E-02, 3.8873413488E-01],
	[5.9750000000E+03, 2.2203439462E+00, 7.2343395218E+00, 3.8987701099E-02, 3.8113061147E-02, 3.8894752903E-01],
	[5.9800000000E+03, 2.2226022454E+00, 7.2313867515E+00, 3.9086419353E-02, 3.8207980126E-02, 3.8916074556E-01],
	[5.9850000000E+03, 2.2248609513E+00, 7.2284376526E+00, 3.9185304436E-02, 3.8303052393E-02, 3.8937378497E-01],
	[5.9900000000E+03, 2.2271200635E+00, 7.2254922177E+00, 3.9284356491E-02, 3.8398278051E-02, 3.8958664774E-01],
	[5.9950000000E+03, 2.2293795817E+00, 7.2225504390E+00, 3.9383575658E-02, 3.8493657204E-02, 3.8979933438E-01],
	[6.0000000000E+03, 2.2316395057E+00, 7.2196123091E+00, 3.9482962079E-02, 3.8589189954E-02, 3.9001184538E-01],
	[6.0050000000E+03, 2.2338998353E+00, 7.2166778204E+00, 3.9583000407E-02, 3.8685339190E-02, 3.9022418122E-01],
	[6.0100000000E+03, 2.2361605702E+00, 7.2137469652E+00, 3.9683208325E-02, 3.8781644116E-02, 3.9043634239E-01],
	[6.0150000000E+03, 2.2384217100E+00, 7.2108197362E+00, 3.9783585980E-02, 3.8878104835E-02, 3.9064832939E-01],
	[6.0200000000E+03, 2.2406832547E+00, 7.2078961258E+00, 3.9884133517E-02, 3.8974721456E-02, 3.9086014269E-01],
	[6.0250000000E+03, 2.2429452038E+00, 7.2049761265E+00, 3.9984851080E-02, 3.9071494083E-02, 3.9107178279E-01],
	[6.0300000000E+03, 2.2452075571E+00, 7.2020597309E+00, 4.0085738816E-02, 3.9168422823E-02, 3.9128325015E-01],
	[6.0350000000E+03, 2.2474703143E+00, 7.1991469316E+00, 4.0186796869E-02, 3.9265507780E-02, 3.9149454527E-01],
	[6.0400000000E+03, 2.2497334753E+00, 7.1962377211E+00, 4.0288025384E-02, 3.9362749062E-02, 3.9170566862E-01],
	[6.0450000000E+03, 2.2519970397E+00, 7.1933320920E+00, 4.0389424507E-02, 3.9460146773E-02, 3.9191662068E-01],
	[6.0500000000E+03, 2.2542610072E+00, 7.1904300371E+00, 4.0490994383E-02, 3.9557701019E-02, 3.9212740192E-01],
	[6.0550000000E+03, 2.2565253777E+00, 7.1875315489E+00, 4.0592735158E-02, 3.9655411906E-02, 3.9233801281E-01],
	[6.0600000000E+03, 2.2587979640E+00, 7.1846801563E+00, 4.0694646976E-02, 3.9753283291E-02, 3.9254845384E-01],
	[6.0650000000E+03, 2.2610732778E+00, 7.1818451311E+00, 4.0796729983E-02, 3.9851312673E-02, 3.9275872547E-01],
	[6.0700000000E+03, 2.2633490056E+00, 7.1790135595E+00, 4.0898984323E-02, 3.9949499051E-02, 3.9296882816E-01],
	[6.0750000000E+03, 2.2656251473E+00, 7.1761854343E+00, 4.1001410144E-02, 4.0047842530E-02, 3.9317876239E-01],
	[6.0800000000E+03, 2.2679017027E+00, 7.1733607486E+00, 4.1104007588E-02, 4.0146343214E-02, 3.9338852863E-01],
	[6.0850000000E+03, 2.2701786713E+00, 7.1705394954E+00, 4.1206776803E-02, 4.0245001210E-02, 3.9359812733E-01],
	[6.0900000000E+03, 2.2724560530E+00, 7.1677216677E+00, 4.1309717933E-02, 4.0343816622E-02, 3.9380755895E-01],
	[6.0950000000E+03, 2.2747338474E+00, 7.1649072584E+00, 4.1412831123E-02, 4.0442789556E-02, 3.9401682397E-01],
	[6.1000000000E+03, 2.2770120544E+00, 7.1620962607E+00, 4.1516116518E-02, 4.0541920115E-02, 3.9422592284E-01],
	[6.1050000000E+03, 2.2792906737E+00, 7.1592886677E+00, 4.1619574265E-02, 4.0641208405E-02, 3.9443485602E-01],
	[6.1100000000E+03, 2.2815697049E+00, 7.1564844723E+00, 4.1723204508E-02, 4.0740654531E-02, 3.9464362396E-01],
	[6.1150000000E+03, 2.2838491479E+00, 7.1536836678E+00, 4.1827007392E-02, 4.0840258597E-02, 3.9485222712E-01],
	[6.1200000000E+03, 2.2861290024E+00, 7.1508862473E+00, 4.1930983063E-02, 4.0940020708E-02, 3.9506066595E-01],
	[6.1250000000E+03, 2.2884092681E+00, 7.1480922039E+00, 4.2035131666E-02, 4.1039940969E-02, 3.9526894091E-01],
	[6.1300000000E+03, 2.2906899447E+00, 7.1453015308E+00, 4.2139453346E-02, 4.1140019483E-02, 3.9547705244E-01],
	[6.1350000000E+03, 2.2929710321E+00, 7.1425142212E+00, 4.2243948249E-02, 4.1240256355E-02, 3.9568500100E-01],
	[6.1400000000E+03, 2.2952525298E+00, 7.1397302683E+00, 4.2348616519E-02, 4.1340651690E-02, 3.9589278704E-01],
	[6.1450000000E+03, 2.2975344377E+00, 7.1369496653E+00, 4.2453458303E-02, 4.1441205592E-02, 3.9610041099E-01],
	[6.1500000000E+03, 2.2998167556E+00, 7.1341724054E+00, 4.2558473745E-02, 4.1541918164E-02, 3.9630787330E-01],
	[6.1550000000E+03, 2.3021021488E+00, 7.1314132230E+00, 4.2663662991E-02, 4.1642790885E-02, 3.9651517442E-01],
	[6.1600000000E+03, 2.3043950811E+00, 7.1286967015E+00, 4.2769026186E-02, 4.1743826184E-02, 3.9672231479E-01],
	[6.1650000000E+03, 2.3066884341E+00, 7.1259834175E+00, 4.2874563475E-02, 4.1845020506E-02, 3.9692929485E-01],
	[6.1700000000E+03, 2.3089822074E+00, 7.1232733646E+00, 4.2980275004E-02, 4.1946373954E-02, 3.9713611504E-01],
	[6.1750000000E+03, 2.3112764009E+00, 7.1205665364E+00, 4.3086160917E-02, 4.2047886632E-02, 3.9734277579E-01],
	[6.1800000000E+03, 2.3135710141E+00, 7.1178629265E+00, 4.3192221361E-02, 4.2149558645E-02, 3.9754927755E-01],
	[6.1850000000E+03, 2.3158660470E+00, 7.1151625283E+00, 4.3298456480E-02, 4.2251390096E-02, 3.9775562074E-01],
	[6.1900000000E+03, 2.3181614991E+00, 7.1124653355E+00, 4.3404866420E-02, 4.2353381088E-02, 3.9796180580E-01],
	[6.1950000000E+03, 2.3204573704E+00, 7.1097713417E+00, 4.3511451326E-02, 4.2455531725E-02, 3.9816783316E-01],
	[6.2000000000E+03, 2.3227536603E+00, 7.1070805405E+00, 4.3618211343E-02, 4.2557842110E-02, 3.9837370326E-01],
	[6.2050000000E+03, 2.3250503689E+00, 7.1043929256E+00, 4.3725146618E-02, 4.2660312348E-02, 3.9857941652E-01],
	[6.2100000000E+03, 2.3273474956E+00, 7.1017084906E+00, 4.3832257294E-02, 4.2762942540E-02, 3.9878497336E-01],
	[6.2150000000E+03, 2.3296450404E+00, 7.0990272293E+00, 4.3939543517E-02, 4.2865732792E-02, 3.9899037423E-01],
	[6.2200000000E+03, 2.3319430030E+00, 7.0963491352E+00, 4.4047005433E-02, 4.2968683204E-02, 3.9919561954E-01],
	[6.2250000000E+03, 2.3342413830E+00, 7.0936742022E+00, 4.4154643187E-02, 4.3071793881E-02, 3.9940070971E-01],
	[6.2300000000E+03, 2.3365401802E+00, 7.0910024240E+00, 4.4262456924E-02, 4.3175064926E-02, 3.9960564517E-01],
	[6.2350000000E+03, 2.3388393944E+00, 7.0883337943E+00, 4.4370446789E-02, 4.3278496441E-02, 3.9981042634E-01],
	[6.2400000000E+03, 2.3411390253E+00, 7.0856683068E+00, 4.4478612929E-02, 4.3382088530E-02, 4.0001505364E-01],
	[6.2450000000E+03, 2.3434390727E+00, 7.0830059555E+00, 4.4586955488E-02, 4.3485841294E-02, 4.0021952748E-01],
	[6.2500000000E+03, 2.3457395362E+00, 7.0803467340E+00, 4.4695474611E-02, 4.3589754837E-02, 4.0042384829E-01],
	[6.2550000000E+03, 2.3480447571E+00, 7.0777144625E+00, 4.4804170444E-02, 4.3693831673E-02, 4.0062801648E-01],
	[6.2600000000E+03, 2.3503555123E+00, 7.0751132987E+00, 4.4913043132E-02, 4.3798072361E-02, 4.0083203247E-01],
	[6.2650000000E+03, 2.3526666939E+00, 7.0725151664E+00, 4.5022092821E-02, 4.3902474176E-02, 4.0103589667E-01],
	[6.2700000000E+03, 2.3549783017E+00, 7.0699200598E+00, 4.5131319655E-02, 4.4007037220E-02, 4.0123960949E-01],
	[6.2750000000E+03, 2.3572903354E+00, 7.0673279730E+00, 4.5240723781E-02, 4.4111761597E-02, 4.0144317134E-01],
	[6.2800000000E+03, 2.3596027948E+00, 7.0647388999E+00, 4.5350305343E-02, 4.4216647408E-02, 4.0164658263E-01],
	[6.2850000000E+03, 2.3619156795E+00, 7.0621528347E+00, 4.5460064487E-02, 4.4321694756E-02, 4.0184984377E-01],
	[6.2900000000E+03, 2.3642289893E+00, 7.0595697716E+00, 4.5570001358E-02, 4.4426903742E-02, 4.0205295517E-01],
	[6.2950000000E+03, 2.3665427240E+00, 7.0569897046E+00, 4.5680116101E-02, 4.4532274469E-02, 4.0225591723E-01],
	[6.3000000000E+03, 2.3688568833E+00, 7.0544126279E+00, 4.5790408863E-02, 4.4637807040E-02, 4.0245873036E-01],
	[6.3050000000E+03, 2.3711714669E+00, 7.0518385357E+00, 4.5900879787E-02, 4.4743501555E-02, 4.0266139496E-01],
	[6.3100000000E+03, 2.3734864745E+00, 7.0492674221E+00, 4.6011529020E-02, 4.4849358116E-02, 4.0286391143E-01],
	[6.3150000000E+03, 2.3758019061E+00, 7.0466992814E+00, 4.6122356707E-02, 4.4955376826E-02, 4.0306628018E-01],
	[6.3200000000E+03, 2.3781177611E+00, 7.0441341078E+00, 4.6233362993E-02, 4.5061557786E-02, 4.0326850160E-01],
	[6.3250000000E+03, 2.3804340395E+00, 7.0415718954E+00, 4.6344548024E-02, 4.5167901097E-02, 4.0347057609E-01],
	[6.3300000000E+03, 2.3827507409E+00, 7.0390126385E+00, 4.6455911944E-02, 4.5274406862E-02, 4.0367250405E-01],
	[6.3350000000E+03, 2.3850678651E+00, 7.0364563315E+00, 4.6567454900E-02, 4.5381075181E-02, 4.0387428587E-01],
	[6.3400000000E+03, 2.3873854119E+00, 7.0339029685E+00, 4.6679177036E-02, 4.5487906156E-02, 4.0407592196E-01],
	[6.3450000000E+03, 2.3897033809E+00, 7.0313525439E+00, 4.6791078498E-02, 4.5594899888E-02, 4.0427741270E-01],
	[6.3500000000E+03, 2.3920217719E+00, 7.0288050519E+00, 4.6903159432E-02, 4.5702056478E-02, 4.0447875849E-01],
	[6.3550000000E+03, 2.3943435672E+00, 7.0262767597E+00, 4.7015419982E-02, 4.5809377811E-02, 4.0467995971E-01],
	[6.3600000000E+03, 2.3966719208E+00, 7.0237847846E+00, 4.7127860295E-02, 4.5916865897E-02, 4.0488101677E-01],
	[6.3650000000E+03, 2.3990007062E+00, 7.0212956505E+00, 4.7240480514E-02, 4.6024517187E-02, 4.0508193004E-01],
	[6.3700000000E+03, 2.4013299230E+00, 7.0188093522E+00, 4.7353280787E-02, 4.6132331781E-02, 4.0528269992E-01],
	[6.3750000000E+03, 2.4036595712E+00, 7.0163258840E+00, 4.7466261257E-02, 4.6240309780E-02, 4.0548332678E-01],
	[6.3800000000E+03, 2.4059896503E+00, 7.0138452405E+00, 4.7579422071E-02, 4.6348451285E-02, 4.0568381103E-01],
	[6.3850000000E+03, 2.4083201601E+00, 7.0113674164E+00, 4.7692763374E-02, 4.6456756397E-02, 4.0588415304E-01],
	[6.3900000000E+03, 2.4106511004E+00, 7.0088924062E+00, 4.7806285311E-02, 4.6565225216E-02, 4.0608435319E-01],
	[6.3950000000E+03, 2.4129824710E+00, 7.0064202045E+00, 4.7919988028E-02, 4.6673857843E-02, 4.0628441187E-01],
	[6.4000000000E+03, 2.4153142715E+00, 7.0039508059E+00, 4.8033871670E-02, 4.6782654379E-02, 4.0648432947E-01],
	[6.4050000000E+03, 2.4176465016E+00, 7.0014842052E+00, 4.8147936382E-02, 4.6891614924E-02, 4.0668410635E-01],
	[6.4100000000E+03, 2.4199791613E+00, 6.9990203968E+00, 4.8262182310E-02, 4.7000739578E-02, 4.0688374289E-01],
	[6.4150000000E+03, 2.4223122501E+00, 6.9965593756E+00, 4.8376609598E-02, 4.7110028441E-02, 4.0708323949E-01],
	[6.4200000000E+03, 2.4246457679E+00, 6.9941011361E+00, 4.8491218394E-02, 4.7219481614E-02, 4.0728259650E-01],
	[6.4250000000E+03, 2.4269797143E+00, 6.9916456731E+00, 4.8606008841E-02, 4.7329099197E-02, 4.0748181432E-01],
	[6.4300000000E+03, 2.4293140892E+00, 6.9891929813E+00, 4.8720981085E-02, 4.7438881290E-02, 4.0768089331E-01],
	[6.4350000000E+03, 2.4316488922E+00, 6.9867430554E+00, 4.8836135272E-02, 4.7548827992E-02, 4.0787983384E-01],
	[6.4400000000E+03, 2.4339841232E+00, 6.9842958901E+00, 4.8951471547E-02, 4.7658939403E-02, 4.0807863629E-01],
	[6.4450000000E+03, 2.4363197818E+00, 6.9818514801E+00, 4.9066990056E-02, 4.7769215624E-02, 4.0827730104E-01],
	[6.4500000000E+03, 2.4386558678E+00, 6.9794098203E+00, 4.9182690943E-02, 4.7879656753E-02, 4.0847582844E-01],
	[6.4550000000E+03, 2.4409923810E+00, 6.9769709055E+00, 4.9298574354E-02, 4.7990262891E-02, 4.0867421887E-01],
	[6.4600000000E+03, 2.4433369651E+00, 6.9745762135E+00, 4.9414640435E-02, 4.8101039073E-02, 4.0887247270E-01],
	[6.4650000000E+03, 2.4456831153E+00, 6.9721903237E+00, 4.9530889331E-02, 4.8211981231E-02, 4.0907059030E-01],
	[6.4700000000E+03, 2.4480297019E+00, 6.9698070937E+00, 4.9647321188E-02, 4.8323088739E-02, 4.0926857203E-01],
	[6.4750000000E+03, 2.4503767247E+00, 6.9674265184E+00, 4.9763936150E-02, 4.8434361696E-02, 4.0946641825E-01],
	[6.4800000000E+03, 2.4527241833E+00, 6.9650485928E+00, 4.9880734363E-02, 4.8545800202E-02, 4.0966412933E-01],
	[6.4850000000E+03, 2.4550720777E+00, 6.9626733120E+00, 4.9997721484E-02, 4.8657409574E-02, 4.0986170564E-01],
	[6.4900000000E+03, 2.4574204074E+00, 6.9603006709E+00, 5.0114893127E-02, 4.8769185621E-02, 4.1005914754E-01],
	[6.4950000000E+03, 2.4597691722E+00, 6.9579306646E+00, 5.0232248485E-02, 4.8881127538E-02, 4.1025645538E-01],
	[6.5000000000E+03, 2.4621183720E+00, 6.9555632882E+00, 5.0349787701E-02, 4.8993235423E-02, 4.1045362952E-01],
	[6.5050000000E+03, 2.4644680064E+00, 6.9531985367E+00, 5.0467510922E-02, 4.9105509376E-02, 4.1065067033E-01],
	[6.5100000000E+03, 2.4668180751E+00, 6.9508364052E+00, 5.0585418292E-02, 4.9217949495E-02, 4.1084757817E-01],
	[6.5150000000E+03, 2.4691685780E+00, 6.9484768887E+00, 5.0703509958E-02, 4.9330555878E-02, 4.1104435339E-01],
	[6.5200000000E+03, 2.4715195148E+00, 6.9461199824E+00, 5.0821786065E-02, 4.9443328626E-02, 4.1124099637E-01],
	[6.5250000000E+03, 2.4738708851E+00, 6.9437656815E+00, 5.0940246758E-02, 4.9556267835E-02, 4.1143750767E-01],
	[6.5300000000E+03, 2.4762226889E+00, 6.9414139809E+00, 5.1058892182E-02, 4.9669373605E-02, 4.1163388770E-01],
	[6.5350000000E+03, 2.4785749257E+00, 6.9390648759E+00, 5.1177722484E-02, 4.9782646034E-02, 4.1183013681E-01],
	[6.5400000000E+03, 2.4809275954E+00, 6.9367183616E+00, 5.1296737809E-02, 4.9896085221E-02, 4.1202625538E-01],
	[6.5450000000E+03, 2.4832806977E+00, 6.9343744331E+00, 5.1415938301E-02, 5.0009691263E-02, 4.1222224376E-01],
	[6.5500000000E+03, 2.4856342324E+00, 6.9320330857E+00, 5.1535324107E-02, 5.0123464259E-02, 4.1241810232E-01],
	[6.5550000000E+03, 2.4879881992E+00, 6.9296943146E+00, 5.1654895372E-02, 5.0237404306E-02, 4.1261383142E-01],
	[6.5600000000E+03, 2.4903433208E+00, 6.9273620297E+00, 5.1774652242E-02, 5.0351512006E-02, 4.1280943141E-01],
	[6.5650000000E+03, 2.4927065834E+00, 6.9250739970E+00, 5.1894594862E-02, 5.0465792331E-02, 4.1300490266E-01],
	[6.5700000000E+03, 2.4950702869E+00, 6.9227884610E+00, 5.2014723377E-02, 5.0580240045E-02, 4.1320024553E-01],
	[6.5750000000E+03, 2.4974344310E+00, 6.9205054173E+00, 5.2135037933E-02, 5.0694855246E-02, 4.1339546037E-01],
	[6.5800000000E+03, 2.4997990156E+00, 6.9182248610E+00, 5.2255538675E-02, 5.0809638033E-02, 4.1359054754E-01],
	[6.5850000000E+03, 2.5021640403E+00, 6.9159467877E+00, 5.2376225750E-02, 5.0924588502E-02, 4.1378550738E-01],
	[6.5900000000E+03, 2.5045295048E+00, 6.9136711928E+00, 5.2497099302E-02, 5.1039706751E-02, 4.1398034027E-01],
	[6.5950000000E+03, 2.5068954090E+00, 6.9113980717E+00, 5.2618159476E-02, 5.1154992879E-02, 4.1417504654E-01],
	[6.6000000000E+03, 2.5092617526E+00, 6.9091274199E+00, 5.2739406419E-02, 5.1270446981E-02, 4.1436962655E-01],
	[6.6050000000E+03, 2.5116285353E+00, 6.9068592327E+00, 5.2860840276E-02, 5.1386069157E-02, 4.1456408065E-01],
	[6.6100000000E+03, 2.5139957569E+00, 6.9045935056E+00, 5.2982461193E-02, 5.1501859503E-02, 4.1475840920E-01],
	[6.6150000000E+03, 2.5163634171E+00, 6.9023302342E+00, 5.3104269314E-02, 5.1617818116E-02, 4.1495261253E-01],
	[6.6200000000E+03, 2.5187315157E+00, 6.9000694139E+00, 5.3226264785E-02, 5.1733945093E-02, 4.1514669100E-01],
	[6.6250000000E+03, 2.5211000524E+00, 6.8978110402E+00, 5.3348447752E-02, 5.1850240531E-02, 4.1534064495E-01],
	[6.6300000000E+03, 2.5234690270E+00, 6.8955551086E+00, 5.3470818361E-02, 5.1966704528E-02, 4.1553447473E-01],
	[6.6350000000E+03, 2.5258384392E+00, 6.8933016147E+00, 5.3593376756E-02, 5.2083337180E-02, 4.1572818069E-01],
	[6.6400000000E+03, 2.5282082888E+00, 6.8910505539E+00, 5.3716123084E-02, 5.2200138584E-02, 4.1592176316E-01],
	[6.6450000000E+03, 2.5305785755E+00, 6.8888019218E+00, 5.3839057489E-02, 5.2317108836E-02, 4.1611522249E-01],
	[6.6500000000E+03, 2.5329492991E+00, 6.8865557140E+00, 5.3962180118E-02, 5.2434248033E-02, 4.1630855903E-01],
	[6.6550000000E+03, 2.5353204594E+00, 6.8843119260E+00, 5.4085491116E-02, 5.2551556272E-02, 4.1650177311E-01],
	[6.6600000000E+03, 2.5376920560E+00, 6.8820705534E+00, 5.4208990628E-02, 5.2669033649E-02, 4.1669486508E-01],
	[6.6650000000E+03, 2.5400640888E+00, 6.8798315918E+00, 5.4332678799E-02, 5.2786680260E-02, 4.1688783526E-01],
	[6.6700000000E+03, 2.5424443665E+00, 6.8776372150E+00, 5.4456555777E-02, 5.2904502078E-02, 4.1708068401E-01],
	[6.6750000000E+03, 2.5448253657E+00, 6.8754466762E+00, 5.4580621704E-02, 5.3022493576E-02, 4.1727341166E-01],
	[6.6800000000E+03, 2.5472068094E+00, 6.8732584747E+00, 5.4704876729E-02, 5.3140654641E-02, 4.1746601853E-01],
	[6.6850000000E+03, 2.5495886973E+00, 6.8710726060E+00, 5.4829320995E-02, 5.3258985370E-02, 4.1765850498E-01],
	[6.6900000000E+03, 2.5519710291E+00, 6.8688890661E+00, 5.4953954649E-02, 5.3377485859E-02, 4.1785087134E-01],
	[6.6950000000E+03, 2.5543538046E+00, 6.8667078506E+00, 5.5078777835E-02, 5.3496156203E-02, 4.1804311793E-01],
	[6.7000000000E+03, 2.5567370235E+00, 6.8645289553E+00, 5.5203790700E-02, 5.3614996500E-02, 4.1823524509E-01],
	[6.7050000000E+03, 2.5591206857E+00, 6.8623523761E+00, 5.5328993389E-02, 5.3734006843E-02, 4.1842725315E-01],
	[6.7100000000E+03, 2.5615047908E+00, 6.8601781087E+00, 5.5454386047E-02, 5.3853187330E-02, 4.1861914244E-01],
	[6.7150000000E+03, 2.5638893386E+00, 6.8580061491E+00, 5.5579968820E-02, 5.3972538056E-02, 4.1881091330E-01],
	[6.7200000000E+03, 2.5662743289E+00, 6.8558364930E+00, 5.5705741854E-02, 5.4092059116E-02, 4.1900256605E-01],
	[6.7250000000E+03, 2.5686597614E+00, 6.8536691362E+00, 5.5831705294E-02, 5.4211750605E-02, 4.1919410101E-01],
	[6.7300000000E+03, 2.5710456359E+00, 6.8515040747E+00, 5.5957859285E-02, 5.4331612620E-02, 4.1938551853E-01],
	[6.7350000000E+03, 2.5734319521E+00, 6.8493413042E+00, 5.6084203973E-02, 5.4451645255E-02, 4.1957681892E-01],
	[6.7400000000E+03, 2.5758187097E+00, 6.8471808208E+00, 5.6210739505E-02, 5.4571848605E-02, 4.1976800250E-01],
	[6.7450000000E+03, 2.5782059086E+00, 6.8450226202E+00, 5.6337466024E-02, 5.4692222766E-02, 4.1995906961E-01],
	[6.7500000000E+03, 2.5805935485E+00, 6.8428666983E+00, 5.6464383677E-02, 5.4812767832E-02, 4.2015002057E-01],
	[6.7550000000E+03, 2.5829816291E+00, 6.8407130512E+00, 5.6591492609E-02, 5.4933483898E-02, 4.2034085569E-01],
	[6.7600000000E+03, 2.5853701502E+00, 6.8385616746E+00, 5.6718792965E-02, 5.5054371060E-02, 4.2053157531E-01],
	[6.7650000000E+03, 2.5877591115E+00, 6.8364125645E+00, 5.6846284893E-02, 5.5175429411E-02, 4.2072217974E-01],
	[6.7700000000E+03, 2.5901485129E+00, 6.8342657169E+00, 5.6973968535E-02, 5.5296659046E-02, 4.2091266931E-01],
	[6.7750000000E+03, 2.5925422663E+00, 6.8321422785E+00, 5.7101844040E-02, 5.5418063240E-02, 4.2110304432E-01],
	[6.7800000000E+03, 2.5949402898E+00, 6.8300417244E+00, 5.7229911551E-02, 5.5539642049E-02, 4.2129330511E-01],
	[6.7850000000E+03, 2.5973387610E+00, 6.8279433639E+00, 5.7358171215E-02, 5.5661392472E-02, 4.2148345199E-01],
	[6.7900000000E+03, 2.5997376799E+00, 6.8258471931E+00, 5.7486623176E-02, 5.5783314602E-02, 4.2167348528E-01],
	[6.7950000000E+03, 2.6021370461E+00, 6.8237532081E+00, 5.7615267581E-02, 5.5905408535E-02, 4.2186340529E-01],
	[6.8000000000E+03, 2.6045368594E+00, 6.8216614050E+00, 5.7744104576E-02, 5.6027674365E-02, 4.2205321233E-01],
	[6.8050000000E+03, 2.6069371196E+00, 6.8195717801E+00, 5.7873134305E-02, 5.6150112185E-02, 4.2224290673E-01],
	[6.8100000000E+03, 2.6093378264E+00, 6.8174843293E+00, 5.8002356914E-02, 5.6272722090E-02, 4.2243248880E-01],
	[6.8150000000E+03, 2.6117389796E+00, 6.8153990488E+00, 5.8131772549E-02, 5.6395504174E-02, 4.2262195885E-01],
	[6.8200000000E+03, 2.6141405789E+00, 6.8133159348E+00, 5.8261381355E-02, 5.6518458530E-02, 4.2281131718E-01],
	[6.8250000000E+03, 2.6165426240E+00, 6.8112349835E+00, 5.8391183478E-02, 5.6641585253E-02, 4.2300056412E-01],
	[6.8300000000E+03, 2.6189451149E+00, 6.8091561910E+00, 5.8521179063E-02, 5.6764884436E-02, 4.2318969998E-01],
	[6.8350000000E+03, 2.6213480511E+00, 6.8070795535E+00, 5.8651368256E-02, 5.6888356173E-02, 4.2337872506E-01],
	[6.8400000000E+03, 2.6237514324E+00, 6.8050050672E+00, 5.8781751203E-02, 5.7012000558E-02, 4.2356763967E-01],
	[6.8450000000E+03, 2.6261552587E+00, 6.8029327283E+00, 5.8912328049E-02, 5.7135817683E-02, 4.2375644412E-01],
	[6.8500000000E+03, 2.6285595296E+00, 6.8008625330E+00, 5.9043098940E-02, 5.7259807642E-02, 4.2394513872E-01],
	[6.8550000000E+03, 2.6309642450E+00, 6.7987944775E+00, 5.9174064021E-02, 5.7383970529E-02, 4.2413372377E-01],
	[6.8600000000E+03, 2.6333694045E+00, 6.7967285581E+00, 5.9305223437E-02, 5.7508306436E-02, 4.2432219958E-01],
	[6.8650000000E+03, 2.6357750080E+00, 6.7946647710E+00, 5.9436577335E-02, 5.7632815456E-02, 4.2451056646E-01],
	[6.8700000000E+03, 2.6381810551E+00, 6.7926031124E+00, 5.9568125860E-02, 5.7757497684E-02, 4.2469882471E-01],
	[6.8750000000E+03, 2.6405875458E+00, 6.7905435787E+00, 5.9699869158E-02, 5.7882353210E-02, 4.2488697464E-01],
	[6.8800000000E+03, 2.6429944796E+00, 6.7884861660E+00, 5.9831807373E-02, 5.8007382129E-02, 4.2507501654E-01],
	[6.8850000000E+03, 2.6454070289E+00, 6.7864588935E+00, 5.9963940652E-02, 5.8132589087E-02, 4.2526295072E-01],
	[6.8900000000E+03, 2.6478222425E+00, 6.7844456878E+00, 6.0096269140E-02, 5.8257971612E-02, 4.2545077748E-01],
	[6.8950000000E+03, 2.6502379066E+00, 6.7824345391E+00, 6.0228792983E-02, 5.8383527853E-02, 4.2563849711E-01],
	[6.9000000000E+03, 2.6526540212E+00, 6.7804254438E+00, 6.0361512327E-02, 5.8509257904E-02, 4.2582610993E-01],
	[6.9050000000E+03, 2.6550705858E+00, 6.7784183983E+00, 6.0494427316E-02, 5.8635161857E-02, 4.2601361623E-01],
	[6.9100000000E+03, 2.6574876003E+00, 6.7764133991E+00, 6.0627538097E-02, 5.8761239805E-02, 4.2620101631E-01],
	[6.9150000000E+03, 2.6599050644E+00, 6.7744104425E+00, 6.0760844815E-02, 5.8887491839E-02, 4.2638831047E-01],
	[6.9200000000E+03, 2.6623229779E+00, 6.7724095251E+00, 6.0894347615E-02, 5.9013918052E-02, 4.2657549899E-01],
	[6.9250000000E+03, 2.6647413405E+00, 6.7704106433E+00, 6.1028046644E-02, 5.9140518536E-02, 4.2676258219E-01],
	[6.9300000000E+03, 2.6671601520E+00, 6.7684137936E+00, 6.1161942047E-02, 5.9267293383E-02, 4.2694956035E-01],
	[6.9350000000E+03, 2.6695794122E+00, 6.7664189723E+00, 6.1296033969E-02, 5.9394242686E-02, 4.2713643377E-01],
	[6.9400000000E+03, 2.6719991208E+00, 6.7644261761E+00, 6.1430322556E-02, 5.9521366536E-02, 4.2732320274E-01],
	[6.9450000000E+03, 2.6744192776E+00, 6.7624354013E+00, 6.1564807954E-02, 5.9648665024E-02, 4.2750986756E-01],
	[6.9500000000E+03, 2.6768398824E+00, 6.7604466445E+00, 6.1699490308E-02, 5.9776138243E-02, 4.2769642852E-01],
	[6.9550000000E+03, 2.6792609348E+00, 6.7584599022E+00, 6.1834369764E-02, 5.9903786284E-02, 4.2788288591E-01],
	[6.9600000000E+03, 2.6816824347E+00, 6.7564751710E+00, 6.1969446467E-02, 6.0031609238E-02, 4.2806924002E-01],
	[6.9650000000E+03, 2.6841043818E+00, 6.7544924472E+00, 6.2104720563E-02, 6.0159607198E-02, 4.2825549115E-01],
	[6.9700000000E+03, 2.6865267759E+00, 6.7525117275E+00, 6.2240192198E-02, 6.0287780253E-02, 4.2844163958E-01],
	[6.9750000000E+03, 2.6889496167E+00, 6.7505330083E+00, 6.2375861517E-02, 6.0416128496E-02, 4.2862768561E-01],
	[6.9800000000E+03, 2.6913729040E+00, 6.7485562864E+00, 6.2511728666E-02, 6.0544652018E-02, 4.2881362951E-01],
	[6.9850000000E+03, 2.6937966376E+00, 6.7465815581E+00, 6.2647793790E-02, 6.0673350909E-02, 4.2899947158E-01],
	[6.9900000000E+03, 2.6962208173E+00, 6.7446088200E+00, 6.2784057035E-02, 6.0802225261E-02, 4.2918521211E-01],
	[6.9950000000E+03, 2.6986492749E+00, 6.7426588872E+00, 6.2920518547E-02, 6.0931278818E-02, 4.2937085139E-01],
	[7.0000000000E+03, 2.7010814010E+00, 6.7407283752E+00, 6.3057178471E-02, 6.1060511121E-02, 4.2955638969E-01],
	[7.0050000000E+03, 2.7035139800E+00, 6.7387997936E+00, 6.3195429157E-02, 6.1191224504E-02, 4.2974182731E-01],
	[7.0100000000E+03, 2.7059470117E+00, 6.7368731394E+00, 6.3333883663E-02, 6.1322118286E-02, 4.2992716452E-01],
	[7.0150000000E+03, 2.7083804959E+00, 6.7349484092E+00, 6.3472542142E-02, 6.1453192565E-02, 4.3011240162E-01],
	[7.0200000000E+03, 2.7108144324E+00, 6.7330255996E+00, 6.3611404748E-02, 6.1584447436E-02, 4.3029753888E-01],
	[7.0250000000E+03, 2.7132488209E+00, 6.7311047074E+00, 6.3750471637E-02, 6.1715882997E-02, 4.3048257659E-01],
	[7.0300000000E+03, 2.7156836611E+00, 6.7291857294E+00, 6.3889742961E-02, 6.1847499343E-02, 4.3066751503E-01],
	[7.0350000000E+03, 2.7181189529E+00, 6.7272686623E+00, 6.4029218874E-02, 6.1979296571E-02, 4.3085235449E-01],
	[7.0400000000E+03, 2.7205546960E+00, 6.7253535027E+00, 6.4168899531E-02, 6.2111274777E-02, 4.3103709523E-01],
	[7.0450000000E+03, 2.7229908901E+00, 6.7234402475E+00, 6.4308785087E-02, 6.2243434058E-02, 4.3122173760E-01],
	[7.0500000000E+03, 2.7254275351E+00, 6.7215288934E+00, 6.4448875694E-02, 6.2375774509E-02, 4.3140628191E-01],
	[7.0550000000E+03, 2.7278646306E+00, 6.7196194372E+00, 6.4589171507E-02, 6.2508296226E-02, 4.3159072841E-01],
	[7.0600000000E+03, 2.7303021765E+00, 6.7177118756E+00, 6.4729672680E-02, 6.2640999305E-02, 4.3177507739E-01],
	[7.0650000000E+03, 2.7327401725E+00, 6.7158062055E+00, 6.4870379367E-02, 6.2773883842E-02, 4.3195932910E-01],
	[7.0700000000E+03, 2.7351786184E+00, 6.7139024236E+00, 6.5011291722E-02, 6.2906949932E-02, 4.3214348381E-01],
	[7.0750000000E+03, 2.7376175140E+00, 6.7120005267E+00, 6.5152409899E-02, 6.3040197672E-02, 4.3232754177E-01],
	[7.0800000000E+03, 2.7400568589E+00, 6.7101005116E+00, 6.5293734053E-02, 6.3173627155E-02, 4.3251150326E-01],
	[7.0850000000E+03, 2.7424966530E+00, 6.7082023751E+00, 6.5435264338E-02, 6.3307238479E-02, 4.3269536854E-01],
	[7.0900000000E+03, 2.7449368961E+00, 6.7063061141E+00, 6.5577000907E-02, 6.3441031737E-02, 4.3287913786E-01],
	[7.0950000000E+03, 2.7473775879E+00, 6.7044117254E+00, 6.5718943915E-02, 6.3575007025E-02, 4.3306281150E-01],
	[7.1000000000E+03, 2.7498187281E+00, 6.7025192057E+00, 6.5861093515E-02, 6.3709164439E-02, 4.3324638970E-01],
	[7.1050000000E+03, 2.7522605228E+00, 6.7006296662E+00, 6.6003449863E-02, 6.3843504285E-02, 4.3342987273E-01],
	[7.1100000000E+03, 2.7547093455E+00, 6.6987774949E+00, 6.6146013112E-02, 6.3978033235E-02, 4.3361326085E-01],
	[7.1150000000E+03, 2.7571586233E+00, 6.6969271372E+00, 6.6288783416E-02, 6.4112744644E-02, 4.3379655432E-01],
	[7.1200000000E+03, 2.7596083558E+00, 6.6950785898E+00, 6.6431760929E-02, 6.4247638607E-02, 4.3397975339E-01],
	[7.1250000000E+03, 2.7620585430E+00, 6.6932318499E+00, 6.6574945806E-02, 6.4382715218E-02, 4.3416285833E-01],
	[7.1300000000E+03, 2.7645091844E+00, 6.6913869143E+00, 6.6718338200E-02, 6.4517974573E-02, 4.3434586938E-01],
	[7.1350000000E+03, 2.7669602800E+00, 6.6895437801E+00, 6.6861938267E-02, 6.4653416766E-02, 4.3452878681E-01],
	[7.1400000000E+03, 2.7694118295E+00, 6.6877024442E+00, 6.7005746159E-02, 6.4789041891E-02, 4.3471161088E-01],
	[7.1450000000E+03, 2.7718638326E+00, 6.6858629036E+00, 6.7149762031E-02, 6.4924850043E-02, 4.3489434183E-01],
	[7.1500000000E+03, 2.7743162891E+00, 6.6840251553E+00, 6.7293986038E-02, 6.5060841316E-02, 4.3507697992E-01],
	[7.1550000000E+03, 2.7767691988E+00, 6.6821891963E+00, 6.7438418333E-02, 6.5197015804E-02, 4.3525952541E-01],
	[7.1600000000E+03, 2.7792225614E+00, 6.6803550236E+00, 6.7583059071E-02, 6.5333373601E-02, 4.3544197855E-01],
	[7.1650000000E+03, 2.7816763767E+00, 6.6785226342E+00, 6.7727908406E-02, 6.5469914801E-02, 4.3562433959E-01],
	[7.1700000000E+03, 2.7841306445E+00, 6.6766920252E+00, 6.7872966492E-02, 6.5606639498E-02, 4.3580660878E-01],
	[7.1750000000E+03, 2.7865853646E+00, 6.6748631936E+00, 6.8018233483E-02, 6.5743547786E-02, 4.3598878639E-01],
	[7.1800000000E+03, 2.7890405366E+00, 6.6730361364E+00, 6.8163709534E-02, 6.5880639758E-02, 4.3617087264E-01],
	[7.1850000000E+03, 2.7914961605E+00, 6.6712108507E+00, 6.8309394798E-02, 6.6017915508E-02, 4.3635286781E-01],
	[7.1900000000E+03, 2.7939522359E+00, 6.6693873334E+00, 6.8455289431E-02, 6.6155375130E-02, 4.3653477214E-01],
	[7.1950000000E+03, 2.7964087626E+00, 6.6675655818E+00, 6.8601393585E-02, 6.6293018716E-02, 4.3671658587E-01],
	[7.2000000000E+03, 2.7988657404E+00, 6.6657455928E+00, 6.8747707416E-02, 6.6430846360E-02, 4.3689830926E-01],
	[7.2050000000E+03, 2.8013231691E+00, 6.6639273635E+00, 6.8894231077E-02, 6.6568858156E-02, 4.3707994256E-01],
	[7.2100000000E+03, 2.8037810484E+00, 6.6621108910E+00, 6.9040964723E-02, 6.6707054195E-02, 4.3726148601E-01],
	[7.2150000000E+03, 2.8062393780E+00, 6.6602961724E+00, 6.9187908508E-02, 6.6845434572E-02, 4.3744293986E-01],
	[7.2200000000E+03, 2.8086991697E+00, 6.6584886263E+00, 6.9335062586E-02, 6.6984000503E-02, 4.3762430436E-01],
	[7.2250000000E+03, 2.8111649428E+00, 6.6567124207E+00, 6.9482427112E-02, 6.7122757128E-02, 4.3780557975E-01],
	[7.2300000000E+03, 2.8136311726E+00, 6.6549379173E+00, 6.9630002239E-02, 6.7261698418E-02, 4.3798676628E-01],
	[7.2350000000E+03, 2.8160978587E+00, 6.6531651132E+00, 6.9777788123E-02, 6.7400824467E-02, 4.3816786420E-01],
	[7.2400000000E+03, 2.8185650011E+00, 6.6513940055E+00, 6.9925784917E-02, 6.7540135368E-02, 4.3834887375E-01],
	[7.2450000000E+03, 2.8210325994E+00, 6.6496245916E+00, 7.0073992775E-02, 6.7679631213E-02, 4.3852979517E-01],
	[7.2500000000E+03, 2.8235006534E+00, 6.6478568686E+00, 7.0222411852E-02, 6.7819312095E-02, 4.3871062871E-01],
	[7.2550000000E+03, 2.8259691629E+00, 6.6460908338E+00, 7.0371042303E-02, 6.7959178106E-02, 4.3889137461E-01],
	[7.2600000000E+03, 2.8284381276E+00, 6.6443264843E+00, 7.0519884280E-02, 6.8099229337E-02, 4.3907203311E-01],
	[7.2650000000E+03, 2.8309075474E+00, 6.6425638174E+00, 7.0668937940E-02, 6.8239465883E-02, 4.3925260446E-01],
	[7.2700000000E+03, 2.8333774220E+00, 6.6408028304E+00, 7.0818203435E-02, 6.8379887833E-02, 4.3943308890E-01],
	[7.2750000000E+03, 2.8358477512E+00, 6.6390435204E+00, 7.0967680921E-02, 6.8520495281E-02, 4.3961348667E-01],
	[7.2800000000E+03, 2.8383185347E+00, 6.6372858848E+00, 7.1117370551E-02, 6.8661288319E-02, 4.3979379800E-01],
	[7.2850000000E+03, 2.8407897723E+00, 6.6355299208E+00, 7.1267272480E-02, 6.8802267037E-02, 4.3997402315E-01],
	[7.2900000000E+03, 2.8432614638E+00, 6.6337756256E+00, 7.1417386862E-02, 6.8943431528E-02, 4.4015416234E-01],
	[7.2950000000E+03, 2.8457336089E+00, 6.6320229965E+00, 7.1567713852E-02, 6.9084781883E-02, 4.4033421582E-01],
	[7.3000000000E+03, 2.8482062075E+00, 6.6302720309E+00, 7.1718253603E-02, 6.9226318194E-02, 4.4051418383E-01],
	[7.3050000000E+03, 2.8506792593E+00, 6.6285227260E+00, 7.1869006271E-02, 6.9368040552E-02, 4.4069406660E-01],
	[7.3100000000E+03, 2.8531527641E+00, 6.6267750790E+00, 7.2019972009E-02, 6.9509949048E-02, 4.4087386438E-01],
	[7.3150000000E+03, 2.8556267216E+00, 6.6250290873E+00, 7.2171150972E-02, 6.9652043773E-02, 4.4105357740E-01],
	[7.3200000000E+03, 2.8581011316E+00, 6.6232847482E+00, 7.2322543315E-02, 6.9794324819E-02, 4.4123320589E-01],
	[7.3250000000E+03, 2.8605759939E+00, 6.6215420590E+00, 7.2474149190E-02, 6.9936792276E-02, 4.4141275009E-01],
	[7.3300000000E+03, 2.8630513083E+00, 6.6198010170E+00, 7.2625968754E-02, 7.0079446235E-02, 4.4159221025E-01],
	[7.3350000000E+03, 2.8655270746E+00, 6.6180616195E+00, 7.2778002160E-02, 7.0222286787E-02, 4.4177158658E-01],
	[7.3400000000E+03, 2.8680090271E+00, 6.6163543560E+00, 7.2930249562E-02, 7.0365320923E-02, 4.4195087934E-01],
	[7.3450000000E+03, 2.8704919990E+00, 6.6146516800E+00, 7.3082711115E-02, 7.0508542559E-02, 4.4213008874E-01],
	[7.3500000000E+03, 2.8729754287E+00, 6.6129506005E+00, 7.3235386974E-02, 7.0651951112E-02, 4.4230921504E-01],
	[7.3550000000E+03, 2.8754593160E+00, 6.6112511147E+00, 7.3388277292E-02, 7.0795546671E-02, 4.4248825845E-01],
	[7.3600000000E+03, 2.8779436605E+00, 6.6095532202E+00, 7.3541382225E-02, 7.0939329328E-02, 4.4266721922E-01],
	[7.3650000000E+03, 2.8804284621E+00, 6.6078569144E+00, 7.3694701926E-02, 7.1083299173E-02, 4.4284609757E-01],
	[7.3700000000E+03, 2.8829137206E+00, 6.6061621947E+00, 7.3848236549E-02, 7.1227456297E-02, 4.4302489374E-01],
	[7.3750000000E+03, 2.8853994357E+00, 6.6044690586E+00, 7.4001986251E-02, 7.1371800788E-02, 4.4320360796E-01],
	[7.3800000000E+03, 2.8878856072E+00, 6.6027775035E+00, 7.4155951183E-02, 7.1516332738E-02, 4.4338224045E-01],
	[7.3850000000E+03, 2.8903722349E+00, 6.6010875268E+00, 7.4310131502E-02, 7.1661052235E-02, 4.4356079146E-01],
	[7.3900000000E+03, 2.8928593185E+00, 6.5993991260E+00, 7.4464527361E-02, 7.1805959371E-02, 4.4373926121E-01],
	[7.3950000000E+03, 2.8953468579E+00, 6.5977122986E+00, 7.4619138915E-02, 7.1951054234E-02, 4.4391764993E-01],
	[7.4000000000E+03, 2.8978348528E+00, 6.5960270421E+00, 7.4773966319E-02, 7.2096336915E-02, 4.4409595784E-01],
	[7.4050000000E+03, 2.9003233029E+00, 6.5943433539E+00, 7.4929009726E-02, 7.2241807502E-02, 4.4427418519E-01],
	[7.4100000000E+03, 2.9028122081E+00, 6.5926612316E+00, 7.5084269291E-02, 7.2387466086E-02, 4.4445233219E-01],
	[7.4150000000E+03, 2.9053015681E+00, 6.5909806725E+00, 7.5239745169E-02, 7.2533312755E-02, 4.4463039908E-01],
	[7.4200000000E+03, 2.9077913828E+00, 6.5893016742E+00, 7.5395437514E-02, 7.2679347598E-02, 4.4480838608E-01],
	[7.4250000000E+03, 2.9102816518E+00, 6.5876242342E+00, 7.5551346481E-02, 7.2825570705E-02, 4.4498629341E-01],
	[7.4300000000E+03, 2.9127723750E+00, 6.5859483501E+00, 7.5707472223E-02, 7.2971982165E-02, 4.4516412132E-01],
	[7.4350000000E+03, 2.9152635521E+00, 6.5842740192E+00, 7.5863814896E-02, 7.3118582067E-02, 4.4534187001E-01],
	[7.4400000000E+03, 2.9177551829E+00, 6.5826012392E+00, 7.6020374654E-02, 7.3265370498E-02, 4.4551953973E-01],
	[7.4450000000E+03, 2.9202472672E+00, 6.5809300075E+00, 7.6177151651E-02, 7.3412347549E-02, 4.4569713068E-01],
	[7.4500000000E+03, 2.9227398048E+00, 6.5792603217E+00, 7.6334146042E-02, 7.3559513307E-02, 4.4587464310E-01],
	[7.4550000000E+03, 2.9252345651E+00, 6.5776015445E+00, 7.6491357981E-02, 7.3706870161E-02, 4.4605207722E-01],
	[7.4600000000E+03, 2.9277340596E+00, 6.5759669201E+00, 7.6648787623E-02, 7.3854421491E-02, 4.4622943325E-01],
	[7.4650000000E+03, 2.9302340130E+00, 6.5743337968E+00, 7.6806435122E-02, 7.4002161847E-02, 4.4640671142E-01],
	[7.4700000000E+03, 2.9327344250E+00, 6.5727021722E+00, 7.6964300633E-02, 7.4150091318E-02, 4.4658391196E-01],
	[7.4750000000E+03, 2.9352352954E+00, 6.5710720438E+00, 7.7122384310E-02, 7.4298209991E-02, 4.4676103508E-01],
	[7.4800000000E+03, 2.9377366241E+00, 6.5694434094E+00, 7.7280686308E-02, 7.4446517954E-02, 4.4693808101E-01],
	[7.4850000000E+03, 2.9402384107E+00, 6.5678162665E+00, 7.7439206781E-02, 7.4595015296E-02, 4.4711504997E-01],
	[7.4900000000E+03, 2.9427406551E+00, 6.5661906128E+00, 7.7597945884E-02, 7.4743702105E-02, 4.4729194218E-01],
	[7.4950000000E+03, 2.9452433570E+00, 6.5645664459E+00, 7.7756903771E-02, 7.4892578468E-02, 4.4746875786E-01],
	[7.5000000000E+03, 2.9477465162E+00, 6.5629437635E+00, 7.7916080596E-02, 7.5041644473E-02, 4.4764549724E-01],
	[7.5050000000E+03, 2.9502501325E+00, 6.5613225633E+00, 7.8075476515E-02, 7.5190900208E-02, 4.4782216053E-01],
	[7.5100000000E+03, 2.9527542056E+00, 6.5597028428E+00, 7.8235091682E-02, 7.5340345760E-02, 4.4799874796E-01],
	[7.5150000000E+03, 2.9552587355E+00, 6.5580845998E+00, 7.8394926251E-02, 7.5489981217E-02, 4.4817525974E-01],
	[7.5200000000E+03, 2.9577637217E+00, 6.5564678319E+00, 7.8554980377E-02, 7.5639806666E-02, 4.4835169610E-01],
	[7.5250000000E+03, 2.9602691641E+00, 6.5548525369E+00, 7.8715254215E-02, 7.5789822194E-02, 4.4852805724E-01],
	[7.5300000000E+03, 2.9627750626E+00, 6.5532387123E+00, 7.8875747918E-02, 7.5940027888E-02, 4.4870434340E-01],
	[7.5350000000E+03, 2.9652814168E+00, 6.5516263559E+00, 7.9036461642E-02, 7.6090423836E-02, 4.4888055480E-01],
	[7.5400000000E+03, 2.9677882265E+00, 6.5500154653E+00, 7.9197395541E-02, 7.6241010123E-02, 4.4905669162E-01],
	[7.5450000000E+03, 2.9702954916E+00, 6.5484060383E+00, 7.9358549770E-02, 7.6391786838E-02, 4.4923275407E-01],
	[7.5500000000E+03, 2.9728032118E+00, 6.5467980726E+00, 7.9519924483E-02, 7.6542754066E-02, 4.4940874233E-01],
	[7.5550000000E+03, 2.9753113868E+00, 6.5451915659E+00, 7.9681519835E-02, 7.6693911894E-02, 4.4958465661E-01],
	[7.5600000000E+03, 2.9778200166E+00, 6.5435865158E+00, 7.9843335980E-02, 7.6845260409E-02, 4.4976049709E-01],
	[7.5650000000E+03, 2.9803291008E+00, 6.5419829202E+00, 8.0005373073E-02, 7.6996799697E-02, 4.4993626397E-01],
	[7.5700000000E+03, 2.9828386392E+00, 6.5403807766E+00, 8.0167631268E-02, 7.7148529844E-02, 4.5011195744E-01],
	[7.5750000000E+03, 2.9853503378E+00, 6.5387890775E+00, 8.0330110721E-02, 7.7300453337E-02, 4.5028757770E-01],
	[7.5800000000E+03, 2.9878665856E+00, 6.5372203725E+00, 8.0492811585E-02, 7.7452573654E-02, 4.5046312493E-01],
	[7.5850000000E+03, 2.9903832928E+00, 6.5356530780E+00, 8.0655734015E-02, 7.7604885143E-02, 4.5063859933E-01],
	[7.5900000000E+03, 2.9929004594E+00, 6.5340871916E+00, 8.0818878167E-02, 7.7757387889E-02, 4.5081400109E-01],
	[7.5950000000E+03, 2.9954180850E+00, 6.5325227112E+00, 8.0982244194E-02, 7.7910081980E-02, 4.5098933039E-01],
	[7.6000000000E+03, 2.9979361695E+00, 6.5309596347E+00, 8.1145832251E-02, 7.8062967500E-02, 4.5116458744E-01],
	[7.6050000000E+03, 3.0004547126E+00, 6.5293979598E+00, 8.1309642493E-02, 7.8216044535E-02, 4.5133977243E-01],
	[7.6100000000E+03, 3.0029737142E+00, 6.5278376844E+00, 8.1473675074E-02, 7.8369313171E-02, 4.5151488553E-01],
	[7.6150000000E+03, 3.0054931739E+00, 6.5262788062E+00, 8.1637930149E-02, 7.8522773494E-02, 4.5168992695E-01],
	[7.6200000000E+03, 3.0080130916E+00, 6.5247213232E+00, 8.1802407873E-02, 7.8676425588E-02, 4.5186489686E-01],
	[7.6250000000E+03, 3.0105334671E+00, 6.5231652331E+00, 8.1967108400E-02, 7.8830269539E-02, 4.5203979547E-01],
	[7.6300000000E+03, 3.0130543002E+00, 6.5216105339E+00, 8.2132031885E-02, 7.8984305432E-02, 4.5221462296E-01],
	[7.6350000000E+03, 3.0155755906E+00, 6.5200572233E+00, 8.2297178483E-02, 7.9138533353E-02, 4.5238937951E-01],
	[7.6400000000E+03, 3.0180973381E+00, 6.5185052991E+00, 8.2462548347E-02, 7.9292953386E-02, 4.5256406532E-01],
	[7.6450000000E+03, 3.0206195425E+00, 6.5169547594E+00, 8.2628141634E-02, 7.9447565616E-02, 4.5273868058E-01],
	[7.6500000000E+03, 3.0231422036E+00, 6.5154056018E+00, 8.2793958497E-02, 7.9602370128E-02, 4.5291322546E-01],
	[7.6550000000E+03, 3.0256653211E+00, 6.5138578244E+00, 8.2959999091E-02, 7.9757367006E-02, 4.5308770017E-01],
	[7.6600000000E+03, 3.0281888949E+00, 6.5123114249E+00, 8.3126263572E-02, 7.9912556335E-02, 4.5326210488E-01],
	[7.6650000000E+03, 3.0307129248E+00, 6.5107664012E+00, 8.3292752092E-02, 8.0067938199E-02, 4.5343643978E-01],
	[7.6700000000E+03, 3.0332374104E+00, 6.5092227513E+00, 8.3459464808E-02, 8.0223512684E-02, 4.5361070506E-01],
	[7.6750000000E+03, 3.0357623517E+00, 6.5076804729E+00, 8.3626401874E-02, 8.0379279872E-02, 4.5378490090E-01],
	[7.6800000000E+03, 3.0382877484E+00, 6.5061395640E+00, 8.3793563444E-02, 8.0535239848E-02, 4.5395902750E-01],
	[7.6850000000E+03, 3.0408136002E+00, 6.5046000225E+00, 8.3960949674E-02, 8.0691392696E-02, 4.5413308503E-01],
	[7.6900000000E+03, 3.0433399070E+00, 6.5030618462E+00, 8.4128560717E-02, 8.0847738500E-02, 4.5430707368E-01],
	[7.6950000000E+03, 3.0458666686E+00, 6.5015250332E+00, 8.4296396730E-02, 8.1004277343E-02, 4.5448099363E-01],
	[7.7000000000E+03, 3.0483989311E+00, 6.5000161109E+00, 8.4464457865E-02, 8.1161017023E-02, 4.5465484507E-01],
	[7.7050000000E+03, 3.0509321549E+00, 6.4985111536E+00, 8.4632744279E-02, 8.1317950730E-02, 4.5482862819E-01],
	[7.7100000000E+03, 3.0534658384E+00, 6.4970075207E+00, 8.4801256126E-02, 8.1475077783E-02, 4.5500234316E-01],
	[7.7150000000E+03, 3.0559999814E+00, 6.4955052102E+00, 8.4969993560E-02, 8.1632398265E-02, 4.5517599018E-01],
	[7.7200000000E+03, 3.0585345837E+00, 6.4940042201E+00, 8.5138956736E-02, 8.1789912261E-02, 4.5534956941E-01],
	[7.7250000000E+03, 3.0610696450E+00, 6.4925045482E+00, 8.5308145809E-02, 8.1947619853E-02, 4.5552308105E-01],
	[7.7300000000E+03, 3.0636051653E+00, 6.4910061927E+00, 8.5477560934E-02, 8.2105521125E-02, 4.5569652529E-01],
	[7.7350000000E+03, 3.0661411441E+00, 6.4895091516E+00, 8.5647202266E-02, 8.2263616160E-02, 4.5586990229E-01],
	[7.7400000000E+03, 3.0686775814E+00, 6.4880134227E+00, 8.5817069958E-02, 8.2421905041E-02, 4.5604321225E-01],
	[7.7450000000E+03, 3.0712144769E+00, 6.4865190042E+00, 8.5987164167E-02, 8.2580387850E-02, 4.5621645534E-01],
	[7.7500000000E+03, 3.0737518304E+00, 6.4850258941E+00, 8.6157485046E-02, 8.2739064671E-02, 4.5638963174E-01],
	[7.7550000000E+03, 3.0762896417E+00, 6.4835340902E+00, 8.6328032751E-02, 8.2897935587E-02, 4.5656274165E-01],
	[7.7600000000E+03, 3.0788279106E+00, 6.4820435908E+00, 8.6498807436E-02, 8.3057000678E-02, 4.5673578523E-01],
	[7.7650000000E+03, 3.0813666368E+00, 6.4805543937E+00, 8.6669809256E-02, 8.3216260030E-02, 4.5690876267E-01],
	[7.7700000000E+03, 3.0839058202E+00, 6.4790664971E+00, 8.6841038366E-02, 8.3375713722E-02, 4.5708167415E-01],
	[7.7750000000E+03, 3.0864454606E+00, 6.4775798988E+00, 8.7012494920E-02, 8.3535361839E-02, 4.5725451985E-01],
	[7.7800000000E+03, 3.0889855576E+00, 6.4760945971E+00, 8.7184179074E-02, 8.3695204462E-02, 4.5742729994E-01],
	[7.7850000000E+03, 3.0915261112E+00, 6.4746105898E+00, 8.7356090981E-02, 8.3855241672E-02, 4.5760001461E-01],
	[7.7900000000E+03, 3.0940671211E+00, 6.4731278751E+00, 8.7528230798E-02, 8.4015473552E-02, 4.5777266404E-01],
	[7.7950000000E+03, 3.0966085871E+00, 6.4716464510E+00, 8.7700598678E-02, 8.4175900185E-02, 4.5794524841E-01],
	[7.8000000000E+03, 3.0991505090E+00, 6.4701663155E+00, 8.7873194777E-02, 8.4336521650E-02, 4.5811776789E-01],
	[7.8050000000E+03, 3.1016928865E+00, 6.4686874668E+00, 8.8046019249E-02, 8.4497338030E-02, 4.5829022266E-01],
	[7.8100000000E+03, 3.1042357195E+00, 6.4672099028E+00, 8.8219072249E-02, 8.4658349407E-02, 4.5846261290E-01],
	[7.8150000000E+03, 3.1067790078E+00, 6.4657336216E+00, 8.8392353932E-02, 8.4819555862E-02, 4.5863493879E-01],
	[7.8200000000E+03, 3.1093234514E+00, 6.4642623054E+00, 8.8565864453E-02, 8.4980958635E-02, 4.5880720051E-01],
	[7.8250000000E+03, 3.1118729449E+00, 6.4628164078E+00, 8.8739603967E-02, 8.5142564286E-02, 4.5897939822E-01],
	[7.8300000000E+03, 3.1144228984E+00, 6.4613717570E+00, 8.8913572627E-02, 8.5304365315E-02, 4.5915153212E-01],
	[7.8350000000E+03, 3.1169733115E+00, 6.4599283509E+00, 8.9087770590E-02, 8.5466361803E-02, 4.5932360237E-01],
	[7.8400000000E+03, 3.1195241841E+00, 6.4584861878E+00, 8.9262198010E-02, 8.5628553832E-02, 4.5949560915E-01],
	[7.8450000000E+03, 3.1220755160E+00, 6.4570452658E+00, 8.9436855042E-02, 8.5790941481E-02, 4.5966755264E-01],
	[7.8500000000E+03, 3.1246273070E+00, 6.4556055831E+00, 8.9611741841E-02, 8.5953524833E-02, 4.5983943302E-01],
	[7.8550000000E+03, 3.1271795568E+00, 6.4541671378E+00, 8.9786858561E-02, 8.6116303967E-02, 4.6001125046E-01],
	[7.8600000000E+03, 3.1297322652E+00, 6.4527299280E+00, 8.9962205357E-02, 8.6279278965E-02, 4.6018300513E-01],
	[7.8650000000E+03, 3.1322854322E+00, 6.4512939519E+00, 9.0137782385E-02, 8.6442449906E-02, 4.6035469720E-01],
	[7.8700000000E+03, 3.1348390573E+00, 6.4498592076E+00, 9.0313589799E-02, 8.6605816872E-02, 4.6052632687E-01],
	[7.8750000000E+03, 3.1373931404E+00, 6.4484256934E+00, 9.0489627755E-02, 8.6769379941E-02, 4.6069789429E-01],
	[7.8800000000E+03, 3.1399476814E+00, 6.4469934073E+00, 9.0665896406E-02, 8.6933139196E-02, 4.6086939965E-01],
	[7.8850000000E+03, 3.1425026800E+00, 6.4455623476E+00, 9.0842395907E-02, 8.7097094715E-02, 4.6104084311E-01],
	[7.8900000000E+03, 3.1450581359E+00, 6.4441325125E+00, 9.1019126415E-02, 8.7261246578E-02, 4.6121222485E-01],
	[7.8950000000E+03, 3.1476140491E+00, 6.4427039000E+00, 9.1196088083E-02, 8.7425594865E-02, 4.6138354505E-01],
	[7.9000000000E+03, 3.1501704192E+00, 6.4412765084E+00, 9.1373281066E-02, 8.7590139656E-02, 4.6155480388E-01],
	[7.9050000000E+03, 3.1527272461E+00, 6.4398503359E+00, 9.1550705520E-02, 8.7754881031E-02, 4.6172600150E-01],
	[7.9100000000E+03, 3.1552845295E+00, 6.4384253806E+00, 9.1728361598E-02, 8.7919819069E-02, 4.6189713810E-01],
	[7.9150000000E+03, 3.1578422693E+00, 6.4370016408E+00, 9.1906249457E-02, 8.8084953849E-02, 4.6206821385E-01],
	[7.9200000000E+03, 3.1604004653E+00, 6.4355791146E+00, 9.2084369252E-02, 8.8250285451E-02, 4.6223922891E-01],
	[7.9250000000E+03, 3.1629591172E+00, 6.4341578003E+00, 9.2262721135E-02, 8.8415813953E-02, 4.6241018347E-01],
	[7.9300000000E+03, 3.1655182248E+00, 6.4327376960E+00, 9.2441305264E-02, 8.8581539435E-02, 4.6258107768E-01],
	[7.9350000000E+03, 3.1680777880E+00, 6.4313188000E+00, 9.2620121793E-02, 8.8747461975E-02, 4.6275191173E-01],
	[7.9400000000E+03, 3.1706378065E+00, 6.4299011105E+00, 9.2799170876E-02, 8.8913581653E-02, 4.6292268578E-01],
	[7.9450000000E+03, 3.1731982801E+00, 6.4284846256E+00, 9.2978452669E-02, 8.9079898547E-02, 4.6309340000E-01],
	[7.9500000000E+03, 3.1757640303E+00, 6.4270947211E+00, 9.3157967327E-02, 8.9246421437E-02, 4.6326405458E-01],
	[7.9550000000E+03, 3.1783304610E+00, 6.4257071530E+00, 9.3337715004E-02, 8.9413142155E-02, 4.6343464967E-01],
	[7.9600000000E+03, 3.1808973512E+00, 6.4243207560E+00, 9.3517695855E-02, 8.9580060383E-02, 4.6360518544E-01],
	[7.9650000000E+03, 3.1834647007E+00, 6.4229355283E+00, 9.3697910036E-02, 8.9747176199E-02, 4.6377566208E-01],
	[7.9700000000E+03, 3.1860325092E+00, 6.4215514685E+00, 9.3878357701E-02, 8.9914489682E-02, 4.6394607974E-01],
	[7.9750000000E+03, 3.1886007765E+00, 6.4201685745E+00, 9.4059039006E-02, 9.0082000909E-02, 4.6411643859E-01],
	[7.9800000000E+03, 3.1911695025E+00, 6.4187868449E+00, 9.4239954105E-02, 9.0249709960E-02, 4.6428673881E-01],
	[7.9850000000E+03, 3.1937386869E+00, 6.4174062778E+00, 9.4421103153E-02, 9.0417616911E-02, 4.6445698057E-01],
	[7.9900000000E+03, 3.1963083296E+00, 6.4160268716E+00, 9.4602486305E-02, 9.0585721841E-02, 4.6462716401E-01],
	[7.9950000000E+03, 3.1988784303E+00, 6.4146486246E+00, 9.4784103716E-02, 9.0754024827E-02, 4.6479728927E-01],
	[8.0000000000E+03, 3.2014489888E+00, 6.4132715350E+00, 9.4965955542E-02, 9.0922525948E-02, 4.6496735651E-01],
	[8.0050000000E+03, 3.2040200050E+00, 6.4118956012E+00, 9.5148994216E-02, 9.1092098085E-02, 4.6513736586E-01],
	[8.0100000000E+03, 3.2065914785E+00, 6.4105208214E+00, 9.5332270693E-02, 9.1261871117E-02, 4.6530731746E-01],
	[8.0150000000E+03, 3.2091634093E+00, 6.4091471941E+00, 9.5515785134E-02, 9.1431845124E-02, 4.6547721147E-01],
	[8.0200000000E+03, 3.2117357971E+00, 6.4077747174E+00, 9.5699537697E-02, 9.1602020185E-02, 4.6564704802E-01],
	[8.0250000000E+03, 3.2143086416E+00, 6.4064033898E+00, 9.5883528542E-02, 9.1772396380E-02, 4.6581682725E-01],
	[8.0300000000E+03, 3.2168819428E+00, 6.4050332095E+00, 9.6067757829E-02, 9.1942973790E-02, 4.6598654932E-01],
	[8.0350000000E+03, 3.2194557004E+00, 6.4036641749E+00, 9.6252225717E-02, 9.2113752493E-02, 4.6615621435E-01],
	[8.0400000000E+03, 3.2220299142E+00, 6.4022962843E+00, 9.6436932365E-02, 9.2284732570E-02, 4.6632582249E-01],
	[8.0450000000E+03, 3.2246045839E+00, 6.4009295361E+00, 9.6621877934E-02, 9.2455914100E-02, 4.6649537388E-01],
	[8.0500000000E+03, 3.2271797095E+00, 6.3995639285E+00, 9.6807062582E-02, 9.2627297162E-02, 4.6666486867E-01],
	[8.0550000000E+03, 3.2297552906E+00, 6.3981994599E+00, 9.6992486469E-02, 9.2798881835E-02, 4.6683430700E-01],
	[8.0600000000E+03, 3.2323313271E+00, 6.3968361287E+00, 9.7178149755E-02, 9.2970668198E-02, 4.6700368900E-01],
	[8.0650000000E+03, 3.2349078188E+00, 6.3954739332E+00, 9.7364052600E-02, 9.3142656331E-02, 4.6717301482E-01],
	[8.0700000000E+03, 3.2374847655E+00, 6.3941128718E+00, 9.7550195162E-02, 9.3314846311E-02, 4.6734228460E-01],
	[8.0750000000E+03, 3.2400639850E+00, 6.3927624422E+00, 9.7736577601E-02, 9.3487241764E-02, 4.6751149848E-01],
	[8.0800000000E+03, 3.2426466958E+00, 6.3914289749E+00, 9.7923200077E-02, 9.3659845178E-02, 4.6768065660E-01],
	[8.0850000000E+03, 3.2452298658E+00, 6.3900966104E+00, 9.8110062750E-02, 9.3832650736E-02, 4.6784975910E-01],
	[8.0900000000E+03, 3.2478134946E+00, 6.3887653471E+00, 9.8297165778E-02, 9.4005658517E-02, 4.6801880612E-01],
	[8.0950000000E+03, 3.2503975821E+00, 6.3874351834E+00, 9.8484509322E-02, 9.4178868599E-02, 4.6818779779E-01],
	[8.1000000000E+03, 3.2529821281E+00, 6.3861061178E+00, 9.8672093541E-02, 9.4352281060E-02, 4.6835673427E-01],
	[8.1050000000E+03, 3.2555671324E+00, 6.3847781486E+00, 9.8859918595E-02, 9.4525895978E-02, 4.6852561569E-01],
	[8.1100000000E+03, 3.2581525948E+00, 6.3834512742E+00, 9.9047984643E-02, 9.4699713433E-02, 4.6869444219E-01],
	[8.1150000000E+03, 3.2607385151E+00, 6.3821254932E+00, 9.9236291845E-02, 9.4873733501E-02, 4.6886321390E-01],
	[8.1200000000E+03, 3.2633248930E+00, 6.3808008039E+00, 9.9424840361E-02, 9.5047956261E-02, 4.6903193097E-01],
	[8.1250000000E+03, 3.2659117285E+00, 6.3794772047E+00, 9.9613630350E-02, 9.5222381790E-02, 4.6920059354E-01],
	[8.1300000000E+03, 3.2684990212E+00, 6.3781546941E+00, 9.9802661971E-02, 9.5397010166E-02, 4.6936920174E-01],
	[8.1350000000E+03, 3.2710867710E+00, 6.3768332705E+00, 9.9991935385E-02, 9.5571841467E-02, 4.6953775571E-01],
	[8.1400000000E+03, 3.2736749777E+00, 6.3755129324E+00, 1.0018145075E-01, 9.5746875770E-02, 4.6970625560E-01],
	[8.1450000000E+03, 3.2762636410E+00, 6.3741936782E+00, 1.0037120823E-01, 9.5922113152E-02, 4.6987470153E-01],
	[8.1500000000E+03, 3.2788527608E+00, 6.3728755063E+00, 1.0056120798E-01, 9.6097553691E-02, 4.7004309365E-01],
	[8.1550000000E+03, 3.2814423370E+00, 6.3715584152E+00, 1.0075145016E-01, 9.6273197463E-02, 4.7021143210E-01],
	[8.1600000000E+03, 3.2840323692E+00, 6.3702424033E+00, 1.0094193493E-01, 9.6449044546E-02, 4.7037971700E-01],
	[8.1650000000E+03, 3.2866228572E+00, 6.3689274692E+00, 1.0113266245E-01, 9.6625095016E-02, 4.7054794851E-01],
	[8.1700000000E+03, 3.2892138010E+00, 6.3676136112E+00, 1.0132363288E-01, 9.6801348950E-02, 4.7071612676E-01],
	[8.1750000000E+03, 3.2918052002E+00, 6.3663008278E+00, 1.0151484638E-01, 9.6977806425E-02, 4.7088425188E-01],
	[8.1800000000E+03, 3.2943970548E+00, 6.3649891175E+00, 1.0170630310E-01, 9.7154467516E-02, 4.7105232401E-01],
	[8.1850000000E+03, 3.2969893644E+00, 6.3636784787E+00, 1.0189800322E-01, 9.7331332302E-02, 4.7122034329E-01],
	[8.1900000000E+03, 3.2995821289E+00, 6.3623689100E+00, 1.0208994689E-01, 9.7508400857E-02, 4.7138830985E-01],
	[8.1950000000E+03, 3.3021753481E+00, 6.3610604098E+00, 1.0228213426E-01, 9.7685673258E-02, 4.7155622384E-01],
	[8.2000000000E+03, 3.3047690218E+00, 6.3597529765E+00, 1.0247456551E-01, 9.7863149580E-02, 4.7172408538E-01],
	[8.2050000000E+03, 3.3073649482E+00, 6.3584558509E+00, 1.0266724078E-01, 9.8040833678E-02, 4.7189189462E-01],
	[8.2100000000E+03, 3.3099642477E+00, 6.3571747572E+00, 1.0286016023E-01, 9.8218728017E-02, 4.7205965168E-01],
	[8.2150000000E+03, 3.3125640057E+00, 6.3558947014E+00, 1.0305332404E-01, 9.8396826567E-02, 4.7222735671E-01],
	[8.2200000000E+03, 3.3151642218E+00, 6.3546156819E+00, 1.0324673235E-01, 9.8575129403E-02, 4.7239500985E-01],
	[8.2250000000E+03, 3.3177648960E+00, 6.3533376974E+00, 1.0344038533E-01, 9.8753636602E-02, 4.7256261122E-01],
	[8.2300000000E+03, 3.3203660281E+00, 6.3520607462E+00, 1.0363428313E-01, 9.8932348239E-02, 4.7273016096E-01],
	[8.2350000000E+03, 3.3229676178E+00, 6.3507848271E+00, 1.0382842592E-01, 9.9111264389E-02, 4.7289765921E-01],
	[8.2400000000E+03, 3.3255696649E+00, 6.3495099385E+00, 1.0402281386E-01, 9.9290385128E-02, 4.7306510610E-01],
	[8.2450000000E+03, 3.3281721692E+00, 6.3482360789E+00, 1.0421744710E-01, 9.9469710530E-02, 4.7323250177E-01],
	[8.2500000000E+03, 3.3307751306E+00, 6.3469632470E+00, 1.0441232581E-01, 9.9649240671E-02, 4.7339984635E-01],
	[8.2550000000E+03, 3.3333785489E+00, 6.3456914411E+00, 1.0460745014E-01, 9.9828975626E-02, 4.7356713997E-01],
	[8.2600000000E+03, 3.3359824238E+00, 6.3444206600E+00, 1.0480282026E-01, 1.0000891547E-01, 4.7373438278E-01],
	[8.2650000000E+03, 3.3385867552E+00, 6.3431509022E+00, 1.0499843632E-01, 1.0018906028E-01, 4.7390157490E-01],
	[8.2700000000E+03, 3.3411915428E+00, 6.3418821662E+00, 1.0519429849E-01, 1.0036941012E-01, 4.7406871647E-01],
	[8.2750000000E+03, 3.3437967865E+00, 6.3406144505E+00, 1.0539040692E-01, 1.0054996508E-01, 4.7423580763E-01],
	[8.2800000000E+03, 3.3464024861E+00, 6.3393477538E+00, 1.0558676177E-01, 1.0073072522E-01, 4.7440284850E-01],
	[8.2850000000E+03, 3.3490086413E+00, 6.3380820746E+00, 1.0578336321E-01, 1.0091169062E-01, 4.7456983922E-01],
	[8.2900000000E+03, 3.3516152520E+00, 6.3368174115E+00, 1.0598021139E-01, 1.0109286136E-01, 4.7473677992E-01],
	[8.2950000000E+03, 3.3542223180E+00, 6.3355537630E+00, 1.0617730648E-01, 1.0127423751E-01, 4.7490367075E-01],
	[8.3000000000E+03, 3.3568298391E+00, 6.3342911278E+00, 1.0637464862E-01, 1.0145581914E-01, 4.7507051182E-01],
	[8.3050000000E+03, 3.3594378151E+00, 6.3330295043E+00, 1.0657223800E-01, 1.0163760632E-01, 4.7523730328E-01],
	[8.3100000000E+03, 3.3620462458E+00, 6.3317688913E+00, 1.0677007475E-01, 1.0181959914E-01, 4.7540404525E-01],
	[8.3150000000E+03, 3.3646551310E+00, 6.3305092872E+00, 1.0696815905E-01, 1.0200179766E-01, 4.7557073788E-01],
	[8.3200000000E+03, 3.3672644705E+00, 6.3292506906E+00, 1.0716649105E-01, 1.0218420195E-01, 4.7573738128E-01],
	[8.3250000000E+03, 3.3698742641E+00, 6.3279931002E+00, 1.0736507091E-01, 1.0236681210E-01, 4.7590397560E-01],
	[8.3300000000E+03, 3.3724845116E+00, 6.3267365145E+00, 1.0756389880E-01, 1.0254962817E-01, 4.7607052097E-01],
	[8.3350000000E+03, 3.3750952129E+00, 6.3254809322E+00, 1.0776297486E-01, 1.0273265023E-01, 4.7623701752E-01],
	[8.3400000000E+03, 3.3777108079E+00, 6.3242487901E+00, 1.0796229927E-01, 1.0291588843E-01, 4.7640346538E-01],
	[8.3450000000E+03, 3.3803269990E+00, 6.3230183257E+00, 1.0816187218E-01, 1.0309933315E-01, 4.7656986468E-01],
	[8.3500000000E+03, 3.3829436476E+00, 6.3217888375E+00, 1.0836169376E-01, 1.0328298414E-01, 4.7673621555E-01],
	[8.3550000000E+03, 3.3855607536E+00, 6.3205603242E+00, 1.0856176415E-01, 1.0346684149E-01, 4.7690251814E-01],
	[8.3600000000E+03, 3.3881783166E+00, 6.3193327844E+00, 1.0876208353E-01, 1.0365090526E-01, 4.7706877256E-01],
	[8.3650000000E+03, 3.3907963365E+00, 6.3181062167E+00, 1.0896265204E-01, 1.0383517552E-01, 4.7723497895E-01],
	[8.3700000000E+03, 3.3934148131E+00, 6.3168806199E+00, 1.0916346986E-01, 1.0401965236E-01, 4.7740113744E-01],
	[8.3750000000E+03, 3.3960337463E+00, 6.3156559925E+00, 1.0936453714E-01, 1.0420433583E-01, 4.7756724816E-01],
	[8.3800000000E+03, 3.3986531358E+00, 6.3144323332E+00, 1.0956585405E-01, 1.0438922602E-01, 4.7773331125E-01],
	[8.3850000000E+03, 3.4012729814E+00, 6.3132096406E+00, 1.0976742073E-01, 1.0457432299E-01, 4.7789932683E-01],
	[8.3900000000E+03, 3.4038932829E+00, 6.3119879135E+00, 1.0996923735E-01, 1.0475962682E-01, 4.7806529503E-01],
	[8.3950000000E+03, 3.4065140403E+00, 6.3107671504E+00, 1.1017130408E-01, 1.0494513757E-01, 4.7823121599E-01],
	[8.4000000000E+03, 3.4091352531E+00, 6.3095473501E+00, 1.1037362106E-01, 1.0513085533E-01, 4.7839708983E-01],
	[8.4050000000E+03, 3.4117569213E+00, 6.3083285113E+00, 1.1057618847E-01, 1.0531678016E-01, 4.7856291669E-01],
	[8.4100000000E+03, 3.4143790447E+00, 6.3071106325E+00, 1.1077900646E-01, 1.0550291213E-01, 4.7872869670E-01],
	[8.4150000000E+03, 3.4170016231E+00, 6.3058937125E+00, 1.1098207519E-01, 1.0568925132E-01, 4.7889442998E-01],
	[8.4200000000E+03, 3.4196246563E+00, 6.3046777499E+00, 1.1118539481E-01, 1.0587579779E-01, 4.7906011665E-01],
	[8.4250000000E+03, 3.4222481441E+00, 6.3034627434E+00, 1.1138896550E-01, 1.0606255162E-01, 4.7922575681E-01],
	[8.4300000000E+03, 3.4248720863E+00, 6.3022486918E+00, 1.1159278742E-01, 1.0624951288E-01, 4.7939135056E-01],
	[8.4350000000E+03, 3.4274964826E+00, 6.3010355936E+00, 1.1179686071E-01, 1.0643668163E-01, 4.7955689802E-01],
	[8.4400000000E+03, 3.4301213331E+00, 6.2998234476E+00, 1.1200118554E-01, 1.0662405795E-01, 4.7972239928E-01],
	[8.4450000000E+03, 3.4327466373E+00, 6.2986122524E+00, 1.1220576207E-01, 1.0681164192E-01, 4.7988785446E-01],
	[8.4500000000E+03, 3.4353723952E+00, 6.2974020068E+00, 1.1241059047E-01, 1.0699943359E-01, 4.8005326365E-01],
	[8.4550000000E+03, 3.4379986066E+00, 6.2961927095E+00, 1.1261567088E-01, 1.0718743304E-01, 4.8021862696E-01],
	[8.4600000000E+03, 3.4406252712E+00, 6.2949843591E+00, 1.1282100348E-01, 1.0737564035E-01, 4.8038394451E-01],
	[8.4650000000E+03, 3.4432523889E+00, 6.2937769543E+00, 1.1302658841E-01, 1.0756405557E-01, 4.8054921638E-01],
	[8.4700000000E+03, 3.4458805491E+00, 6.2925734298E+00, 1.1323242585E-01, 1.0775268022E-01, 4.8071444269E-01],
	[8.4750000000E+03, 3.4485130136E+00, 6.2913900025E+00, 1.1343851595E-01, 1.0794152236E-01, 4.8087962355E-01],
	[8.4800000000E+03, 3.4511459348E+00, 6.2902074955E+00, 1.1364485886E-01, 1.0813057268E-01, 4.8104475905E-01],
	[8.4850000000E+03, 3.4537793125E+00, 6.2890259076E+00, 1.1385145476E-01, 1.0831983128E-01, 4.8120984930E-01],
	[8.4900000000E+03, 3.4564131464E+00, 6.2878452375E+00, 1.1405838108E-01, 1.0850936815E-01, 4.8137489442E-01],
	[8.4950000000E+03, 3.4590474364E+00, 6.2866654840E+00, 1.1426556556E-01, 1.0869911780E-01, 4.8153989449E-01],
	[8.5000000000E+03, 3.4616821823E+00, 6.2854866458E+00, 1.1447300377E-01, 1.0888907615E-01, 4.8170484962E-01],
	[8.5050000000E+03, 3.4643173840E+00, 6.2843087217E+00, 1.1468069587E-01, 1.0907924327E-01, 4.8186975993E-01],
	[8.5100000000E+03, 3.4669530411E+00, 6.2831317105E+00, 1.1488864203E-01, 1.0926961924E-01, 4.8203462551E-01],
	[8.5150000000E+03, 3.4695891536E+00, 6.2819556108E+00, 1.1509684240E-01, 1.0946020411E-01, 4.8219944647E-01],
	[8.5200000000E+03, 3.4722257212E+00, 6.2807804215E+00, 1.1530529715E-01, 1.0965099796E-01, 4.8236422291E-01],
	[8.5250000000E+03, 3.4748627438E+00, 6.2796061414E+00, 1.1551400644E-01, 1.0984200085E-01, 4.8252895494E-01],
	[8.5300000000E+03, 3.4775002212E+00, 6.2784327691E+00, 1.1572297042E-01, 1.1003321287E-01, 4.8269364265E-01],
	[8.5350000000E+03, 3.4801381532E+00, 6.2772603034E+00, 1.1593218927E-01, 1.1022463407E-01, 4.8285828616E-01],
	[8.5400000000E+03, 3.4827765395E+00, 6.2760887432E+00, 1.1614166313E-01, 1.1041626452E-01, 4.8302288557E-01],
	[8.5450000000E+03, 3.4854153800E+00, 6.2749180871E+00, 1.1635139217E-01, 1.1060810430E-01, 4.8318744097E-01],
	[8.5500000000E+03, 3.4880546746E+00, 6.2737483341E+00, 1.1656137655E-01, 1.1080015347E-01, 4.8335195248E-01],
	[8.5550000000E+03, 3.4906944230E+00, 6.2725794827E+00, 1.1677161643E-01, 1.1099241210E-01, 4.8351642020E-01],
	[8.5600000000E+03, 3.4933346250E+00, 6.2714115319E+00, 1.1698211197E-01, 1.1118488026E-01, 4.8368084423E-01],
	[8.5650000000E+03, 3.4959752805E+00, 6.2702444803E+00, 1.1719286334E-01, 1.1137755801E-01, 4.8384522467E-01],
	[8.5700000000E+03, 3.4986163893E+00, 6.2690783269E+00, 1.1740387068E-01, 1.1157044543E-01, 4.8400956162E-01],
	[8.5750000000E+03, 3.5012579511E+00, 6.2679130703E+00, 1.1761513417E-01, 1.1176354257E-01, 4.8417385520E-01],
	[8.5800000000E+03, 3.5038999658E+00, 6.2667487094E+00, 1.1782665396E-01, 1.1195684952E-01, 4.8433810550E-01],
	[8.5850000000E+03, 3.5065424333E+00, 6.2655852429E+00, 1.1803843021E-01, 1.1215036634E-01, 4.8450231263E-01],
	[8.5900000000E+03, 3.5091853532E+00, 6.2644226696E+00, 1.1825046309E-01, 1.1234409309E-01, 4.8466647668E-01],
	[8.5950000000E+03, 3.5118287255E+00, 6.2632609884E+00, 1.1846275276E-01, 1.1253802984E-01, 4.8483059777E-01],
	[8.6000000000E+03, 3.5144725500E+00, 6.2621001980E+00, 1.1867529936E-01, 1.1273217666E-01, 4.8499467598E-01],
	[8.6050000000E+03, 3.5171168264E+00, 6.2609402972E+00, 1.1888810308E-01, 1.1292653362E-01, 4.8515871144E-01],
	[8.6100000000E+03, 3.5197652702E+00, 6.2597994997E+00, 1.1910116406E-01, 1.1312111057E-01, 4.8532270423E-01],
	[8.6150000000E+03, 3.5224147548E+00, 6.2586624409E+00, 1.1931448247E-01, 1.1331589939E-01, 4.8548665446E-01],
	[8.6200000000E+03, 3.5250646947E+00, 6.2575262482E+00, 1.1952805847E-01, 1.1351089862E-01, 4.8565056224E-01],
	[8.6250000000E+03, 3.5277150898E+00, 6.2563909204E+00, 1.1974189221E-01, 1.1370610832E-01, 4.8581442766E-01],
	[8.6300000000E+03, 3.5303659400E+00, 6.2552564564E+00, 1.1995598387E-01, 1.1390152855E-01, 4.8597825082E-01],
	[8.6350000000E+03, 3.5330172450E+00, 6.2541228550E+00, 1.2017033360E-01, 1.1409715939E-01, 4.8614203184E-01],
	[8.6400000000E+03, 3.5356690046E+00, 6.2529901151E+00, 1.2038494155E-01, 1.1429300090E-01, 4.8630577081E-01],
	[8.6450000000E+03, 3.5383212186E+00, 6.2518582355E+00, 1.2059980790E-01, 1.1448905315E-01, 4.8646946783E-01],
	[8.6500000000E+03, 3.5409738869E+00, 6.2507272151E+00, 1.2081493280E-01, 1.1468531620E-01, 4.8663312300E-01],
	[8.6550000000E+03, 3.5436270093E+00, 6.2495970527E+00, 1.2103031641E-01, 1.1488179013E-01, 4.8679673643E-01],
	[8.6600000000E+03, 3.5462805856E+00, 6.2484677472E+00, 1.2124595890E-01, 1.1507847498E-01, 4.8696030822E-01],
	[8.6650000000E+03, 3.5489346156E+00, 6.2473392973E+00, 1.2146186041E-01, 1.1527537084E-01, 4.8712383847E-01],
	[8.6700000000E+03, 3.5515890992E+00, 6.2462117021E+00, 1.2167802113E-01, 1.1547247777E-01, 4.8728732727E-01],
	[8.6750000000E+03, 3.5542440361E+00, 6.2450849603E+00, 1.2189444120E-01, 1.1566979583E-01, 4.8745077474E-01],
	[8.6800000000E+03, 3.5568994261E+00, 6.2439590708E+00, 1.2211112078E-01, 1.1586732508E-01, 4.8761418097E-01],
	[8.6850000000E+03, 3.5595552691E+00, 6.2428340325E+00, 1.2232806005E-01, 1.1606506560E-01, 4.8777754607E-01],
	[8.6900000000E+03, 3.5622115649E+00, 6.2417098442E+00, 1.2254525915E-01, 1.1626301745E-01, 4.8794087013E-01],
	[8.6950000000E+03, 3.5648683134E+00, 6.2405865049E+00, 1.2276271825E-01, 1.1646118069E-01, 4.8810415326E-01],
	[8.7000000000E+03, 3.5675255142E+00, 6.2394640133E+00, 1.2298043750E-01, 1.1665955540E-01, 4.8826739555E-01],
	[8.7050000000E+03, 3.5701831673E+00, 6.2383423684E+00, 1.2319841708E-01, 1.1685814162E-01, 4.8843059712E-01],
	[8.7100000000E+03, 3.5728412725E+00, 6.2372215689E+00, 1.2341665714E-01, 1.1705693943E-01, 4.8859375805E-01],
	[8.7150000000E+03, 3.5754998295E+00, 6.2361016139E+00, 1.2363515784E-01, 1.1725594890E-01, 4.8875687845E-01],
	[8.7200000000E+03, 3.5781588382E+00, 6.2349825022E+00, 1.2385391934E-01, 1.1745517008E-01, 4.8891995842E-01],
	[8.7250000000E+03, 3.5808182985E+00, 6.2338642327E+00, 1.2407294180E-01, 1.1765460305E-01, 4.8908299806E-01],
	[8.7300000000E+03, 3.5834782101E+00, 6.2327468042E+00, 1.2429222539E-01, 1.1785424786E-01, 4.8924599748E-01],
	[8.7350000000E+03, 3.5861385728E+00, 6.2316302156E+00, 1.2451177026E-01, 1.1805410458E-01, 4.8940895676E-01],
	[8.7400000000E+03, 3.5887993865E+00, 6.2305144659E+00, 1.2473157658E-01, 1.1825417327E-01, 4.8957187602E-01],
	[8.7450000000E+03, 3.5914612995E+00, 6.2294026907E+00, 1.2495164450E-01, 1.1845445584E-01, 4.8973475535E-01],
	[8.7500000000E+03, 3.5941271759E+00, 6.2283087210E+00, 1.2517197419E-01, 1.1865496051E-01, 4.8989759485E-01],
	[8.7550000000E+03, 3.5967935065E+00, 6.2272155681E+00, 1.2539256581E-01, 1.1885567741E-01, 4.9006039462E-01],
	[8.7600000000E+03, 3.5994602911E+00, 6.2261232311E+00, 1.2561341951E-01, 1.1905660661E-01, 4.9022315477E-01],
	[8.7650000000E+03, 3.6021275296E+00, 6.2250317088E+00, 1.2583453547E-01, 1.1925774818E-01, 4.9038587539E-01],
	[8.7700000000E+03, 3.6047952218E+00, 6.2239410002E+00, 1.2605591383E-01, 1.1945910216E-01, 4.9054855658E-01],
	[8.7750000000E+03, 3.6074633674E+00, 6.2228511042E+00, 1.2627755477E-01, 1.1966066864E-01, 4.9071119845E-01],
	[8.7800000000E+03, 3.6101319663E+00, 6.2217620198E+00, 1.2649945843E-01, 1.1986244766E-01, 4.9087380108E-01],
	[8.7850000000E+03, 3.6128010184E+00, 6.2206737458E+00, 1.2672162499E-01, 1.2006443930E-01, 4.9103636459E-01],
	[8.7900000000E+03, 3.6154705234E+00, 6.2195862812E+00, 1.2694405460E-01, 1.2026664362E-01, 4.9119888907E-01],
	[8.7950000000E+03, 3.6181404812E+00, 6.2184996250E+00, 1.2716674743E-01, 1.2046906068E-01, 4.9136137462E-01],
	[8.8000000000E+03, 3.6208108915E+00, 6.2174137761E+00, 1.2738970363E-01, 1.2067169053E-01, 4.9152382134E-01],
	[8.8050000000E+03, 3.6234817543E+00, 6.2163287334E+00, 1.2761292337E-01, 1.2087453326E-01, 4.9168622933E-01],
	[8.8100000000E+03, 3.6261530693E+00, 6.2152444958E+00, 1.2783640680E-01, 1.2107758891E-01, 4.9184859868E-01],
	[8.8150000000E+03, 3.6288248363E+00, 6.2141610624E+00, 1.2806015409E-01, 1.2128085755E-01, 4.9201092951E-01],
	[8.8200000000E+03, 3.6314970551E+00, 6.2130784321E+00, 1.2828416540E-01, 1.2148433924E-01, 4.9217322190E-01],
	[8.8250000000E+03, 3.6341697257E+00, 6.2119966037E+00, 1.2850844089E-01, 1.2168803404E-01, 4.9233547596E-01],
	[8.8300000000E+03, 3.6368428477E+00, 6.2109155764E+00, 1.2873298072E-01, 1.2189194202E-01, 4.9249769178E-01],
	[8.8350000000E+03, 3.6395164211E+00, 6.2098353489E+00, 1.2895778505E-01, 1.2209606324E-01, 4.9265986941E-01],
	[8.8400000000E+03, 3.6421904456E+00, 6.2087559204E+00, 1.2918285404E-01, 1.2230039776E-01, 4.9282200894E-01],
	[8.8450000000E+03, 3.6448649211E+00, 6.2076772897E+00, 1.2940818785E-01, 1.2250494564E-01, 4.9298411045E-01],
	[8.8500000000E+03, 3.6475398474E+00, 6.2065994557E+00, 1.2963378665E-01, 1.2270970693E-01, 4.9314617402E-01],
	[8.8550000000E+03, 3.6502152242E+00, 6.2055224176E+00, 1.2985965060E-01, 1.2291468171E-01, 4.9330819972E-01],
	[8.8600000000E+03, 3.6528910515E+00, 6.2044461741E+00, 1.3008577984E-01, 1.2311987004E-01, 4.9347018762E-01],
	[8.8650000000E+03, 3.6555673291E+00, 6.2033707244E+00, 1.3031217456E-01, 1.2332527197E-01, 4.9363213781E-01],
	[8.8700000000E+03, 3.6582440567E+00, 6.2022960673E+00, 1.3053883490E-01, 1.2353088757E-01, 4.9379405037E-01],
	[8.8750000000E+03, 3.6609212342E+00, 6.2012222018E+00, 1.3076576103E-01, 1.2373671689E-01, 4.9395592536E-01],
	[8.8800000000E+03, 3.6635988614E+00, 6.2001491269E+00, 1.3099295311E-01, 1.2394276000E-01, 4.9411776288E-01],
	[8.8850000000E+03, 3.6662769459E+00, 6.1990768785E+00, 1.3122041130E-01, 1.2414901698E-01, 4.9427956299E-01],
	[8.8900000000E+03, 3.6689594909E+00, 6.1980245484E+00, 1.3144813576E-01, 1.2435550018E-01, 4.9444132577E-01],
	[8.8950000000E+03, 3.6716424887E+00, 6.1969729885E+00, 1.3167612666E-01, 1.2456219741E-01, 4.9460305130E-01],
	[8.9000000000E+03, 3.6743259391E+00, 6.1959221978E+00, 1.3190438414E-01, 1.2476910875E-01, 4.9476473965E-01],
	[8.9050000000E+03, 3.6770098420E+00, 6.1948721753E+00, 1.3213290839E-01, 1.2497623425E-01, 4.9492639091E-01],
	[8.9100000000E+03, 3.6796941971E+00, 6.1938229200E+00, 1.3236169954E-01, 1.2518357396E-01, 4.9508800514E-01],
	[8.9150000000E+03, 3.6823790043E+00, 6.1927744309E+00, 1.3259075777E-01, 1.2539112796E-01, 4.9524958244E-01],
	[8.9200000000E+03, 3.6850642634E+00, 6.1917267071E+00, 1.3282008324E-01, 1.2559889629E-01, 4.9541112286E-01],
	[8.9250000000E+03, 3.6877499743E+00, 6.1906797474E+00, 1.3304967611E-01, 1.2580687902E-01, 4.9557262650E-01],
	[8.9300000000E+03, 3.6904361367E+00, 6.1896335510E+00, 1.3327953654E-01, 1.2601507622E-01, 4.9573409342E-01],
	[8.9350000000E+03, 3.6931227504E+00, 6.1885881169E+00, 1.3350966468E-01, 1.2622348793E-01, 4.9589552370E-01],
	[8.9400000000E+03, 3.6958098154E+00, 6.1875434441E+00, 1.3374006071E-01, 1.2643211421E-01, 4.9605691742E-01],
	[8.9450000000E+03, 3.6984973314E+00, 6.1864995315E+00, 1.3397072478E-01, 1.2664095514E-01, 4.9621827466E-01],
	[8.9500000000E+03, 3.7011852982E+00, 6.1854563783E+00, 1.3420165705E-01, 1.2685001076E-01, 4.9637959549E-01],
	[8.9550000000E+03, 3.7038737157E+00, 6.1844139835E+00, 1.3443285769E-01, 1.2705928113E-01, 4.9654087999E-01],
	[8.9600000000E+03, 3.7065625836E+00, 6.1833723460E+00, 1.3466432685E-01, 1.2726876632E-01, 4.9670212824E-01],
	[8.9650000000E+03, 3.7092519019E+00, 6.1823314649E+00, 1.3489606470E-01, 1.2747846637E-01, 4.9686334031E-01],
	[8.9700000000E+03, 3.7119416703E+00, 6.1812913393E+00, 1.3512807140E-01, 1.2768838136E-01, 4.9702451627E-01],
	[8.9750000000E+03, 3.7146318887E+00, 6.1802519681E+00, 1.3536034710E-01, 1.2789851134E-01, 4.9718565621E-01],
	[8.9800000000E+03, 3.7173225569E+00, 6.1792133504E+00, 1.3559289197E-01, 1.2810885636E-01, 4.9734676020E-01],
	[8.9850000000E+03, 3.7200136747E+00, 6.1781754853E+00, 1.3582570618E-01, 1.2831941649E-01, 4.9750782832E-01],
	[8.9900000000E+03, 3.7227052419E+00, 6.1771383717E+00, 1.3605878987E-01, 1.2853019179E-01, 4.9766886064E-01],
	[8.9950000000E+03, 3.7253972584E+00, 6.1761020087E+00, 1.3629214322E-01, 1.2874118230E-01, 4.9782985724E-01],
	[9.0000000000E+03, 3.7280897240E+00, 6.1750663954E+00, 1.3652576638E-01, 1.2895238809E-01, 4.9799081820E-01],
	[9.0050000000E+03, 3.7307826385E+00, 6.1740315308E+00, 1.3676104423E-01, 1.2916504439E-01, 4.9815174359E-01],
	[9.0100000000E+03, 3.7334760017E+00, 6.1729974139E+00, 1.3699659620E-01, 1.2937791926E-01, 4.9831263348E-01],
	[9.0150000000E+03, 3.7361698135E+00, 6.1719640437E+00, 1.3723242244E-01, 1.2959101276E-01, 4.9847348796E-01],
	[9.0200000000E+03, 3.7388640736E+00, 6.1709314194E+00, 1.3746852312E-01, 1.2980432496E-01, 4.9863430709E-01],
	[9.0250000000E+03, 3.7415587820E+00, 6.1698995400E+00, 1.3770489841E-01, 1.3001785590E-01, 4.9879509097E-01],
	[9.0300000000E+03, 3.7442554767E+00, 6.1688756178E+00, 1.3794154848E-01, 1.3023161074E-01, 4.9895583965E-01],
	[9.0350000000E+03, 3.7469549810E+00, 6.1678634906E+00, 1.3817847349E-01, 1.3044559229E-01, 4.9911655322E-01],
	[9.0400000000E+03, 3.7496549365E+00, 6.1668520893E+00, 1.3841567361E-01, 1.3065979283E-01, 4.9927723176E-01],
	[9.0450000000E+03, 3.7523553429E+00, 6.1658414130E+00, 1.3865314900E-01, 1.3087421245E-01, 4.9943787533E-01],
	[9.0500000000E+03, 3.7550562002E+00, 6.1648314607E+00, 1.3889089983E-01, 1.3108885118E-01, 4.9959848402E-01],
	[9.0550000000E+03, 3.7577575080E+00, 6.1638222315E+00, 1.3912892627E-01, 1.3130370910E-01, 4.9975905789E-01],
	[9.0600000000E+03, 3.7604592663E+00, 6.1628137245E+00, 1.3936722848E-01, 1.3151878626E-01, 4.9991959704E-01],
	[9.0650000000E+03, 3.7631614749E+00, 6.1618059389E+00, 1.3960580662E-01, 1.3173408272E-01, 5.0008010152E-01],
	[9.0700000000E+03, 3.7658641337E+00, 6.1607988735E+00, 1.3984466088E-01, 1.3194959854E-01, 5.0024057142E-01],
	[9.0750000000E+03, 3.7685672423E+00, 6.1597925277E+00, 1.4008379141E-01, 1.3216533377E-01, 5.0040100682E-01],
	[9.0800000000E+03, 3.7712708007E+00, 6.1587869004E+00, 1.4032319837E-01, 1.3238128848E-01, 5.0056140778E-01],
	[9.0850000000E+03, 3.7739748087E+00, 6.1577819908E+00, 1.4056288194E-01, 1.3259746273E-01, 5.0072177439E-01],
	[9.0900000000E+03, 3.7766792661E+00, 6.1567777979E+00, 1.4080284228E-01, 1.3281385657E-01, 5.0088210671E-01],
	[9.0950000000E+03, 3.7793841728E+00, 6.1557743208E+00, 1.4104307955E-01, 1.3303047005E-01, 5.0104240483E-01],
	[9.1000000000E+03, 3.7820895285E+00, 6.1547715587E+00, 1.4128359393E-01, 1.3324730325E-01, 5.0120266882E-01],
	[9.1050000000E+03, 3.7847953331E+00, 6.1537695106E+00, 1.4152438558E-01, 1.3346435621E-01, 5.0136289876E-01],
	[9.1100000000E+03, 3.7875015865E+00, 6.1527681756E+00, 1.4176545467E-01, 1.3368162900E-01, 5.0152309471E-01],
	[9.1150000000E+03, 3.7902082884E+00, 6.1517675529E+00, 1.4200680136E-01, 1.3389912166E-01, 5.0168325677E-01],
	[9.1200000000E+03, 3.7929154387E+00, 6.1507676415E+00, 1.4224842581E-01, 1.3411683427E-01, 5.0184338499E-01],
	[9.1250000000E+03, 3.7956230372E+00, 6.1497684405E+00, 1.4249032820E-01, 1.3433476687E-01, 5.0200347946E-01],
	[9.1300000000E+03, 3.7983310837E+00, 6.1487699491E+00, 1.4273250870E-01, 1.3455291952E-01, 5.0216354025E-01],
	[9.1350000000E+03, 3.8010395781E+00, 6.1477721663E+00, 1.4297496746E-01, 1.3477129228E-01, 5.0232356744E-01],
	[9.1400000000E+03, 3.8037485202E+00, 6.1467750913E+00, 1.4321770465E-01, 1.3498988521E-01, 5.0248356110E-01],
	[9.1450000000E+03, 3.8064579098E+00, 6.1457787232E+00, 1.4346072045E-01, 1.3520869836E-01, 5.0264352130E-01],
	[9.1500000000E+03, 3.8091677468E+00, 6.1447830610E+00, 1.4370401501E-01, 1.3542773180E-01, 5.0280344813E-01],
	[9.1550000000E+03, 3.8118780310E+00, 6.1437881040E+00, 1.4394758851E-01, 1.3564698556E-01, 5.0296334166E-01],
	[9.1600000000E+03, 3.8145887622E+00, 6.1427938512E+00, 1.4419144111E-01, 1.3586645973E-01, 5.0312320196E-01],
	[9.1650000000E+03, 3.8172999402E+00, 6.1418003017E+00, 1.4443557297E-01, 1.3608615433E-01, 5.0328302910E-01],
	[9.1700000000E+03, 3.8200115649E+00, 6.1408074546E+00, 1.4467998427E-01, 1.3630606945E-01, 5.0344282317E-01],
	[9.1750000000E+03, 3.8227248875E+00, 6.1398210117E+00, 1.4492467516E-01, 1.3652620954E-01, 5.0360258423E-01],
	[9.1800000000E+03, 3.8254412354E+00, 6.1388470020E+00, 1.4516964582E-01, 1.3674657939E-01, 5.0376231237E-01],
	[9.1850000000E+03, 3.8281580329E+00, 6.1378736771E+00, 1.4541489642E-01, 1.3696716998E-01, 5.0392200765E-01],
	[9.1900000000E+03, 3.8308752796E+00, 6.1369010360E+00, 1.4566042711E-01, 1.3718798138E-01, 5.0408167016E-01],
	[9.1950000000E+03, 3.8335929756E+00, 6.1359290780E+00, 1.4590623807E-01, 1.3740901364E-01, 5.0424129996E-01],
	[9.2000000000E+03, 3.8363111205E+00, 6.1349578022E+00, 1.4615232946E-01, 1.3763026681E-01, 5.0440089713E-01],
	[9.2050000000E+03, 3.8390297143E+00, 6.1339872078E+00, 1.4639870144E-01, 1.3785174096E-01, 5.0456046175E-01],
	[9.2100000000E+03, 3.8417487567E+00, 6.1330172938E+00, 1.4664535420E-01, 1.3807343612E-01, 5.0471999389E-01],
	[9.2150000000E+03, 3.8444682477E+00, 6.1320480595E+00, 1.4689228788E-01, 1.3829535237E-01, 5.0487949362E-01],
	[9.2200000000E+03, 3.8471881869E+00, 6.1310795040E+00, 1.4713950266E-01, 1.3851748975E-01, 5.0503896102E-01],
	[9.2250000000E+03, 3.8499085744E+00, 6.1301116264E+00, 1.4738699871E-01, 1.3873984832E-01, 5.0519839613E-01],
	[9.2300000000E+03, 3.8526294098E+00, 6.1291444260E+00, 1.4763477618E-01, 1.3896242814E-01, 5.0535779902E-01],
	[9.2350000000E+03, 3.8553506930E+00, 6.1281779018E+00, 1.4788283526E-01, 1.3918522925E-01, 5.0551716974E-01],
	[9.2400000000E+03, 3.8580724238E+00, 6.1272120531E+00, 1.4813117610E-01, 1.3940825172E-01, 5.0567650834E-01],
	[9.2450000000E+03, 3.8607946022E+00, 6.1262468790E+00, 1.4837979886E-01, 1.3963149560E-01, 5.0583581487E-01],
	[9.2500000000E+03, 3.8635172278E+00, 6.1252823787E+00, 1.4862870373E-01, 1.3985496093E-01, 5.0599508940E-01],
	[9.2550000000E+03, 3.8662403006E+00, 6.1243185513E+00, 1.4887789086E-01, 1.4007864778E-01, 5.0615433199E-01],
	[9.2600000000E+03, 3.8689638204E+00, 6.1233553960E+00, 1.4912736042E-01, 1.4030255620E-01, 5.0631354267E-01],
	[9.2650000000E+03, 3.8716877870E+00, 6.1223929120E+00, 1.4937711257E-01, 1.4052668624E-01, 5.0647272153E-01],
	[9.2700000000E+03, 3.8744122002E+00, 6.1214310984E+00, 1.4962714749E-01, 1.4075103796E-01, 5.0663186860E-01],
	[9.2750000000E+03, 3.8771370599E+00, 6.1204699545E+00, 1.4987746534E-01, 1.4097561141E-01, 5.0679098394E-01],
	[9.2800000000E+03, 3.8798623659E+00, 6.1195094793E+00, 1.5012806629E-01, 1.4120040664E-01, 5.0695006761E-01],
	[9.2850000000E+03, 3.8825881180E+00, 6.1185496721E+00, 1.5037895050E-01, 1.4142542370E-01, 5.0710911967E-01],
	[9.2900000000E+03, 3.8853143161E+00, 6.1175905320E+00, 1.5063011814E-01, 1.4165066266E-01, 5.0726814017E-01],
	[9.2950000000E+03, 3.8880409600E+00, 6.1166320583E+00, 1.5088156937E-01, 1.4187612355E-01, 5.0742712917E-01],
	[9.3000000000E+03, 3.8907680496E+00, 6.1156742500E+00, 1.5113330437E-01, 1.4210180645E-01, 5.0758608672E-01],
	[9.3050000000E+03, 3.8934955846E+00, 6.1147171064E+00, 1.5138532330E-01, 1.4232771138E-01, 5.0774501288E-01],
	[9.3100000000E+03, 3.8962235649E+00, 6.1137606267E+00, 1.5163762632E-01, 1.4255383842E-01, 5.0790390770E-01],
	[9.3150000000E+03, 3.8989519903E+00, 6.1128048100E+00, 1.5189021361E-01, 1.4278018761E-01, 5.0806277124E-01],
	[9.3200000000E+03, 3.9016808607E+00, 6.1118496556E+00, 1.5214308533E-01, 1.4300675900E-01, 5.0822160356E-01],
	[9.3250000000E+03, 3.9044131555E+00, 6.1109083288E+00, 1.5239624164E-01, 1.4323356389E-01, 5.0838040471E-01],
	[9.3300000000E+03, 3.9071466843E+00, 6.1099711257E+00, 1.5264968272E-01, 1.4346059413E-01, 5.0853917475E-01],
	[9.3350000000E+03, 3.9098806609E+00, 6.1090345684E+00, 1.5290340873E-01, 1.4368784680E-01, 5.0869791373E-01],
	[9.3400000000E+03, 3.9126150850E+00, 6.1080986560E+00, 1.5315741983E-01, 1.4391532197E-01, 5.0885662171E-01],
	[9.3450000000E+03, 3.9153499565E+00, 6.1071633877E+00, 1.5341171620E-01, 1.4414301967E-01, 5.0901529874E-01],
	[9.3500000000E+03, 3.9180852753E+00, 6.1062287629E+00, 1.5366629799E-01, 1.4437093997E-01, 5.0917394488E-01],
	[9.3550000000E+03, 3.9208210411E+00, 6.1052947806E+00, 1.5392116539E-01, 1.4459908291E-01, 5.0933256019E-01],
	[9.3600000000E+03, 3.9235572538E+00, 6.1043614401E+00, 1.5417631854E-01, 1.4482744855E-01, 5.0949114472E-01],
	[9.3650000000E+03, 3.9262939132E+00, 6.1034287407E+00, 1.5443175763E-01, 1.4505603694E-01, 5.0964969853E-01],
	[9.3700000000E+03, 3.9290310191E+00, 6.1024966814E+00, 1.5468748281E-01, 1.4528484812E-01, 5.0980822167E-01],
	[9.3750000000E+03, 3.9317685715E+00, 6.1015652617E+00, 1.5494349426E-01, 1.4551388215E-01, 5.0996671419E-01],
	[9.3800000000E+03, 3.9345065700E+00, 6.1006344806E+00, 1.5519979213E-01, 1.4574313908E-01, 5.1012517616E-01],
	[9.3850000000E+03, 3.9372450147E+00, 6.0997043373E+00, 1.5545637661E-01, 1.4597261896E-01, 5.1028360763E-01],
	[9.3900000000E+03, 3.9399839052E+00, 6.0987748313E+00, 1.5571324784E-01, 1.4620232184E-01, 5.1044200865E-01],
	[9.3950000000E+03, 3.9427232415E+00, 6.0978459615E+00, 1.5597040601E-01, 1.4643224777E-01, 5.1060037929E-01],
	[9.4000000000E+03, 3.9454630233E+00, 6.0969177273E+00, 1.5622785128E-01, 1.4666239681E-01, 5.1075871959E-01],
	[9.4050000000E+03, 3.9482032505E+00, 6.0959901279E+00, 1.5648558381E-01, 1.4689276899E-01, 5.1091702961E-01],
	[9.4100000000E+03, 3.9509439230E+00, 6.0950631626E+00, 1.5674360377E-01, 1.4712336438E-01, 5.1107530940E-01],
	[9.4150000000E+03, 3.9536850405E+00, 6.0941368305E+00, 1.5700191133E-01, 1.4735418301E-01, 5.1123355903E-01],
	[9.4200000000E+03, 3.9564266029E+00, 6.0932111309E+00, 1.5726050665E-01, 1.4758522495E-01, 5.1139177855E-01],
	[9.4250000000E+03, 3.9591686101E+00, 6.0922860630E+00, 1.5751938990E-01, 1.4781649023E-01, 5.1154996801E-01],
	[9.4300000000E+03, 3.9619110619E+00, 6.0913616260E+00, 1.5777856126E-01, 1.4804797892E-01, 5.1170812747E-01],
	[9.4350000000E+03, 3.9646539581E+00, 6.0904378193E+00, 1.5803802087E-01, 1.4827969105E-01, 5.1186625699E-01],
	[9.4400000000E+03, 3.9673972985E+00, 6.0895146420E+00, 1.5829776892E-01, 1.4851162668E-01, 5.1202435661E-01],
	[9.4450000000E+03, 3.9701410830E+00, 6.0885920933E+00, 1.5855780557E-01, 1.4874378586E-01, 5.1218242640E-01],
	[9.4500000000E+03, 3.9728853115E+00, 6.0876701725E+00, 1.5881813098E-01, 1.4897616863E-01, 5.1234046641E-01],
	[9.4550000000E+03, 3.9756299837E+00, 6.0867488789E+00, 1.5907874533E-01, 1.4920877504E-01, 5.1249847670E-01],
	[9.4600000000E+03, 3.9783750995E+00, 6.0858282117E+00, 1.5933964878E-01, 1.4944160515E-01, 5.1265645732E-01],
	[9.4650000000E+03, 3.9811206588E+00, 6.0849081701E+00, 1.5960084149E-01, 1.4967465900E-01, 5.1281440832E-01],
	[9.4700000000E+03, 3.9838666613E+00, 6.0839887534E+00, 1.5986232363E-01, 1.4990793663E-01, 5.1297232977E-01],
	[9.4750000000E+03, 3.9866159948E+00, 6.0830823374E+00, 1.6012409538E-01, 1.5014144974E-01, 5.1313022172E-01],
	[9.4800000000E+03, 3.9893665888E+00, 6.0821800256E+00, 1.6038615689E-01, 1.5037519009E-01, 5.1328808421E-01],
	[9.4850000000E+03, 3.9921176289E+00, 6.0812783233E+00, 1.6064850833E-01, 1.5060915446E-01, 5.1344591732E-01],
	[9.4900000000E+03, 3.9948691146E+00, 6.0803772298E+00, 1.6091125462E-01, 1.5084343493E-01, 5.1360372109E-01],
	[9.4950000000E+03, 3.9976210461E+00, 6.0794767444E+00, 1.6117435206E-01, 1.5107799297E-01, 5.1376149559E-01],
	[9.5000000000E+03, 4.0003734229E+00, 6.0785768662E+00, 1.6143774043E-01, 1.5131277556E-01, 5.1391924085E-01],
	[9.5050000000E+03, 4.0031262451E+00, 6.0776775947E+00, 1.6170141991E-01, 1.5154778276E-01, 5.1407695695E-01],
	[9.5100000000E+03, 4.0058795123E+00, 6.0767789290E+00, 1.6196539067E-01, 1.5178301461E-01, 5.1423464393E-01],
	[9.5150000000E+03, 4.0086332246E+00, 6.0758808684E+00, 1.6222965287E-01, 1.5201847115E-01, 5.1439230186E-01],
	[9.5200000000E+03, 4.0113873816E+00, 6.0749834123E+00, 1.6249420667E-01, 1.5225415243E-01, 5.1454993077E-01],
	[9.5250000000E+03, 4.0141419833E+00, 6.0740865598E+00, 1.6275905225E-01, 1.5249005851E-01, 5.1470753075E-01],
	[9.5300000000E+03, 4.0168970294E+00, 6.0731903103E+00, 1.6302418978E-01, 1.5272618942E-01, 5.1486510182E-01],
	[9.5350000000E+03, 4.0196525199E+00, 6.0722946631E+00, 1.6328961942E-01, 1.5296254522E-01, 5.1502264407E-01],
	[9.5400000000E+03, 4.0224084545E+00, 6.0713996173E+00, 1.6355534134E-01, 1.5319912595E-01, 5.1518015752E-01],
	[9.5450000000E+03, 4.0251648331E+00, 6.0705051724E+00, 1.6382135570E-01, 1.5343593166E-01, 5.1533764226E-01],
	[9.5500000000E+03, 4.0279216556E+00, 6.0696113276E+00, 1.6408766269E-01, 1.5367296240E-01, 5.1549509832E-01],
	[9.5550000000E+03, 4.0306789217E+00, 6.0687180821E+00, 1.6435426245E-01, 1.5391021821E-01, 5.1565252576E-01],
	[9.5600000000E+03, 4.0334366313E+00, 6.0678254353E+00, 1.6462115517E-01, 1.5414769914E-01, 5.1580992464E-01],
	[9.5650000000E+03, 4.0361947843E+00, 6.0669333864E+00, 1.6488834100E-01, 1.5438540523E-01, 5.1596729502E-01],
	[9.5700000000E+03, 4.0389533805E+00, 6.0660419347E+00, 1.6515582012E-01, 1.5462333653E-01, 5.1612463694E-01],
	[9.5750000000E+03, 4.0417124197E+00, 6.0651510796E+00, 1.6542359270E-01, 1.5486149309E-01, 5.1628195047E-01],
	[9.5800000000E+03, 4.0444719017E+00, 6.0642608203E+00, 1.6569165889E-01, 1.5509987495E-01, 5.1643923566E-01],
	[9.5850000000E+03, 4.0472318265E+00, 6.0633711560E+00, 1.6596001888E-01, 1.5533848216E-01, 5.1659649257E-01],
	[9.5900000000E+03, 4.0499921938E+00, 6.0624820862E+00, 1.6622867283E-01, 1.5557731476E-01, 5.1675372125E-01],
	[9.5950000000E+03, 4.0527530035E+00, 6.0615936100E+00, 1.6649762090E-01, 1.5581637281E-01, 5.1691092175E-01],
	[9.6000000000E+03, 4.0555142555E+00, 6.0607057268E+00, 1.6676686326E-01, 1.5605565633E-01, 5.1706809411E-01],
	[9.6050000000E+03, 4.0582759495E+00, 6.0598184359E+00, 1.6703640008E-01, 1.5629516539E-01, 5.1722523838E-01],
	[9.6100000000E+03, 4.0610380854E+00, 6.0589317366E+00, 1.6730623154E-01, 1.5653490002E-01, 5.1738235458E-01],
	[9.6150000000E+03, 4.0638006631E+00, 6.0580456281E+00, 1.6757635779E-01, 1.5677486026E-01, 5.1753944276E-01],
	[9.6200000000E+03, 4.0665636824E+00, 6.0571601098E+00, 1.6784677900E-01, 1.5701504618E-01, 5.1769650296E-01],
	[9.6250000000E+03, 4.0693281819E+00, 6.0562795000E+00, 1.6811749535E-01, 1.5725546226E-01, 5.1785353522E-01],
	[9.6300000000E+03, 4.0720957238E+00, 6.0554102769E+00, 1.6838850699E-01, 1.5749611532E-01, 5.1801053957E-01],
	[9.6350000000E+03, 4.0748637098E+00, 6.0545416298E+00, 1.6865981411E-01, 1.5773699425E-01, 5.1816751606E-01],
	[9.6400000000E+03, 4.0776321398E+00, 6.0536735577E+00, 1.6893141686E-01, 1.5797809911E-01, 5.1832446473E-01],
	[9.6450000000E+03, 4.0804010137E+00, 6.0528060602E+00, 1.6920331541E-01, 1.5821942994E-01, 5.1848138561E-01],
	[9.6500000000E+03, 4.0831703313E+00, 6.0519391365E+00, 1.6947550994E-01, 1.5846098678E-01, 5.1863827874E-01],
	[9.6550000000E+03, 4.0859400924E+00, 6.0510727860E+00, 1.6974800061E-01, 1.5870276968E-01, 5.1879514416E-01],
	[9.6600000000E+03, 4.0887102969E+00, 6.0502070079E+00, 1.7002078758E-01, 1.5894477868E-01, 5.1895198192E-01],
	[9.6650000000E+03, 4.0914809446E+00, 6.0493418016E+00, 1.7029387103E-01, 1.5918701382E-01, 5.1910879205E-01],
	[9.6700000000E+03, 4.0942520353E+00, 6.0484771664E+00, 1.7056725112E-01, 1.5942947515E-01, 5.1926557460E-01],
	[9.6750000000E+03, 4.0970235690E+00, 6.0476131016E+00, 1.7084092802E-01, 1.5967216271E-01, 5.1942232959E-01],
	[9.6800000000E+03, 4.0997955454E+00, 6.0467496066E+00, 1.7111490191E-01, 1.5991507654E-01, 5.1957905707E-01],
	[9.6850000000E+03, 4.1025679644E+00, 6.0458866807E+00, 1.7138917294E-01, 1.6015821669E-01, 5.1973575709E-01],
	[9.6900000000E+03, 4.1053408258E+00, 6.0450243233E+00, 1.7166374128E-01, 1.6040158320E-01, 5.1989242967E-01],
	[9.6950000000E+03, 4.1081141295E+00, 6.0441625336E+00, 1.7193860711E-01, 1.6064517611E-01, 5.2004907486E-01],
	[9.7000000000E+03, 4.1108878752E+00, 6.0433013110E+00, 1.7221377059E-01, 1.6088899547E-01, 5.2020569270E-01],
	[9.7050000000E+03, 4.1136620630E+00, 6.0424406549E+00, 1.7248923188E-01, 1.6113304131E-01, 5.2036228322E-01],
	[9.7100000000E+03, 4.1164366925E+00, 6.0415805645E+00, 1.7276499117E-01, 1.6137731369E-01, 5.2051884648E-01],
	[9.7150000000E+03, 4.1192117637E+00, 6.0407210392E+00, 1.7304104861E-01, 1.6162181264E-01, 5.2067538250E-01],
	[9.7200000000E+03, 4.1219872763E+00, 6.0398620784E+00, 1.7331740437E-01, 1.6186653820E-01, 5.2083189132E-01],
	[9.7250000000E+03, 4.1247632303E+00, 6.0390036814E+00, 1.7359405862E-01, 1.6211149042E-01, 5.2098837299E-01],
	[9.7300000000E+03, 4.1275396254E+00, 6.0381458474E+00, 1.7387101154E-01, 1.6235666933E-01, 5.2114482755E-01],
	[9.7350000000E+03, 4.1303164616E+00, 6.0372885760E+00, 1.7414826327E-01, 1.6260207499E-01, 5.2130125503E-01],
	[9.7400000000E+03, 4.1330937386E+00, 6.0364318663E+00, 1.7442581401E-01, 1.6284770742E-01, 5.2145765547E-01],
	[9.7450000000E+03, 4.1358714563E+00, 6.0355757179E+00, 1.7470366390E-01, 1.6309356668E-01, 5.2161402892E-01],
	[9.7500000000E+03, 4.1386496145E+00, 6.0347201299E+00, 1.7498181313E-01, 1.6333965281E-01, 5.2177037541E-01],
	[9.7550000000E+03, 4.1414282132E+00, 6.0338651017E+00, 1.7526026186E-01, 1.6358596583E-01, 5.2192669498E-01],
	[9.7600000000E+03, 4.1442072520E+00, 6.0330106328E+00, 1.7553901025E-01, 1.6383250580E-01, 5.2208298768E-01],
	[9.7650000000E+03, 4.1469867310E+00, 6.0321567223E+00, 1.7581805848E-01, 1.6407927276E-01, 5.2223925354E-01],
	[9.7700000000E+03, 4.1497666498E+00, 6.0313033698E+00, 1.7609740671E-01, 1.6432626675E-01, 5.2239549259E-01],
	[9.7750000000E+03, 4.1525470084E+00, 6.0304505745E+00, 1.7637705512E-01, 1.6457348780E-01, 5.2255170489E-01],
	[9.7800000000E+03, 4.1553288796E+00, 6.0296026605E+00, 1.7665700386E-01, 1.6482094088E-01, 5.2270789047E-01],
	[9.7850000000E+03, 4.1581136925E+00, 6.0287653726E+00, 1.7693725311E-01, 1.6506863263E-01, 5.2286404937E-01],
	[9.7900000000E+03, 4.1608989477E+00, 6.0279286286E+00, 1.7721780304E-01, 1.6531655165E-01, 5.2302018162E-01],
	[9.7950000000E+03, 4.1636846450E+00, 6.0270924279E+00, 1.7749865381E-01, 1.6556469799E-01, 5.2317628728E-01],
	[9.8000000000E+03, 4.1664707842E+00, 6.0262567698E+00, 1.7777980559E-01, 1.6581307168E-01, 5.2333236637E-01],
	[9.8050000000E+03, 4.1692573652E+00, 6.0254216538E+00, 1.7806125855E-01, 1.6606167276E-01, 5.2348841895E-01],
	[9.8100000000E+03, 4.1720443879E+00, 6.0245870792E+00, 1.7834301286E-01, 1.6631050127E-01, 5.2364444504E-01],
	[9.8150000000E+03, 4.1748318520E+00, 6.0237530453E+00, 1.7862506868E-01, 1.6655955726E-01, 5.2380044468E-01],
	[9.8200000000E+03, 4.1776197574E+00, 6.0229195516E+00, 1.7890742619E-01, 1.6680884077E-01, 5.2395641793E-01],
	[9.8250000000E+03, 4.1804081040E+00, 6.0220865974E+00, 1.7919008555E-01, 1.6705835182E-01, 5.2411236481E-01],
	[9.8300000000E+03, 4.1831968917E+00, 6.0212541821E+00, 1.7947304693E-01, 1.6730809046E-01, 5.2426828537E-01],
	[9.8350000000E+03, 4.1859861201E+00, 6.0204223050E+00, 1.7975631050E-01, 1.6755805674E-01, 5.2442417964E-01],
	[9.8400000000E+03, 4.1887757893E+00, 6.0195909656E+00, 1.8003987643E-01, 1.6780825068E-01, 5.2458004767E-01],
	[9.8450000000E+03, 4.1915658990E+00, 6.0187601633E+00, 1.8032374488E-01, 1.6805867233E-01, 5.2473588949E-01],
	[9.8500000000E+03, 4.1943564492E+00, 6.0179298973E+00, 1.8060791603E-01, 1.6830932173E-01, 5.2489170515E-01],
	[9.8550000000E+03, 4.1971474395E+00, 6.0171001672E+00, 1.8089239003E-01, 1.6856019891E-01, 5.2504749468E-01],
	[9.8600000000E+03, 4.1999388700E+00, 6.0162709722E+00, 1.8117716707E-01, 1.6881130392E-01, 5.2520325813E-01],
	[9.8650000000E+03, 4.2027307404E+00, 6.0154423118E+00, 1.8146224730E-01, 1.6906263678E-01, 5.2535899553E-01],
	[9.8700000000E+03, 4.2055230505E+00, 6.0146141853E+00, 1.8174763090E-01, 1.6931419755E-01, 5.2551470693E-01],
	[9.8750000000E+03, 4.2083158003E+00, 6.0137865922E+00, 1.8203331804E-01, 1.6956598625E-01, 5.2567039235E-01],
	[9.8800000000E+03, 4.2111089896E+00, 6.0129595318E+00, 1.8231930887E-01, 1.6981800293E-01, 5.2582605185E-01],
	[9.8850000000E+03, 4.2139026182E+00, 6.0121330035E+00, 1.8260560358E-01, 1.7007024762E-01, 5.2598168547E-01],
	[9.8900000000E+03, 4.2166966859E+00, 6.0113070066E+00, 1.8289220233E-01, 1.7032272035E-01, 5.2613729323E-01],
	[9.8950000000E+03, 4.2194911927E+00, 6.0104815407E+00, 1.8317910528E-01, 1.7057542118E-01, 5.2629287519E-01],
	[9.9000000000E+03, 4.2222861383E+00, 6.0096566050E+00, 1.8346631261E-01, 1.7082835013E-01, 5.2644843138E-01],
	[9.9050000000E+03, 4.2250815227E+00, 6.0088321990E+00, 1.8375382448E-01, 1.7108150724E-01, 5.2660396184E-01],
	[9.9100000000E+03, 4.2278773456E+00, 6.0080083221E+00, 1.8404164106E-01, 1.7133489254E-01, 5.2675946661E-01],
	[9.9150000000E+03, 4.2306736068E+00, 6.0071849736E+00, 1.8432976253E-01, 1.7158850608E-01, 5.2691494573E-01],
	[9.9200000000E+03, 4.2334703064E+00, 6.0063621529E+00, 1.8461818904E-01, 1.7184234790E-01, 5.2707039925E-01],
	[9.9250000000E+03, 4.2362674440E+00, 6.0055398595E+00, 1.8490692077E-01, 1.7209641802E-01, 5.2722582719E-01],
	[9.9300000000E+03, 4.2390650196E+00, 6.0047180927E+00, 1.8519595788E-01, 1.7235071648E-01, 5.2738122961E-01],
	[9.9350000000E+03, 4.2418630330E+00, 6.0038968520E+00, 1.8548530055E-01, 1.7260524332E-01, 5.2753660653E-01],
	[9.9400000000E+03, 4.2446643537E+00, 6.0030873253E+00, 1.8577494894E-01, 1.7286001262E-01, 5.2769195801E-01],
	[9.9450000000E+03, 4.2474667608E+00, 6.0022808338E+00, 1.8606490322E-01, 1.7311501361E-01, 5.2784728407E-01],
	[9.9500000000E+03, 4.2502696081E+00, 6.0014748559E+00, 1.8635516355E-01, 1.7337024317E-01, 5.2800258477E-01],
	[9.9550000000E+03, 4.2530728955E+00, 6.0006693911E+00, 1.8664573012E-01, 1.7362570135E-01, 5.2815786013E-01],
	[9.9600000000E+03, 4.2558766228E+00, 5.9998644388E+00, 1.8693660307E-01, 1.7388138817E-01, 5.2831311027E-01],
	[9.9650000000E+03, 4.2586807898E+00, 5.9990599984E+00, 1.8722778260E-01, 1.7413730368E-01, 5.2846833532E-01],
	[9.9700000000E+03, 4.2614853965E+00, 5.9982560692E+00, 1.8751926885E-01, 1.7439344790E-01, 5.2862353531E-01],
	[9.9750000000E+03, 4.2642904425E+00, 5.9974526508E+00, 1.8781106200E-01, 1.7464982088E-01, 5.2877871026E-01],
	[9.9800000000E+03, 4.2670959279E+00, 5.9966497426E+00, 1.8810316222E-01, 1.7490642264E-01, 5.2893386018E-01],
	[9.9850000000E+03, 4.2699018525E+00, 5.9958473439E+00, 1.8839556968E-01, 1.7516325323E-01, 5.2908898511E-01],
	[9.9900000000E+03, 4.2727082160E+00, 5.9950454542E+00, 1.8868828454E-01, 1.7542031268E-01, 5.2924408505E-01],
	[9.9950000000E+03, 4.2755150184E+00, 5.9942440729E+00, 1.8898130698E-01, 1.7567760102E-01, 5.2939916004E-01],
	[1.0000000000E+04, 4.2783222594E+00, 5.9934431994E+00, 1.8927463716E-01, 1.7593511828E-01, 5.2955421009E-01],
	[1.0005000000E+04, 4.2811299390E+00, 5.9926428332E+00, 1.8956956201E-01, 1.7619397609E-01, 5.2970923522E-01],
	[1.0010000000E+04, 4.2839380570E+00, 5.9918429737E+00, 1.8986479831E-01, 1.7645306543E-01, 5.2986423545E-01],
	[1.0015000000E+04, 4.2867466133E+00, 5.9910436203E+00, 1.9016034625E-01, 1.7671238634E-01, 5.3001921081E-01],
	[1.0020000000E+04, 4.2895556076E+00, 5.9902447724E+00, 1.9045620598E-01, 1.7697193884E-01, 5.3017416131E-01],
	[1.0025000000E+04, 4.2923650398E+00, 5.9894464295E+00, 1.9075237769E-01, 1.7723172298E-01, 5.3032908697E-01],
	[1.0030000000E+04, 4.2951749099E+00, 5.9886485910E+00, 1.9104886154E-01, 1.7749173878E-01, 5.3048398783E-01],
	[1.0035000000E+04, 4.2979852176E+00, 5.9878512563E+00, 1.9134565771E-01, 1.7775198629E-01, 5.3063886388E-01],
	[1.0040000000E+04, 4.3007959628E+00, 5.9870544249E+00, 1.9164276637E-01, 1.7801246554E-01, 5.3079371517E-01],
	[1.0045000000E+04, 4.3036071453E+00, 5.9862580961E+00, 1.9194018770E-01, 1.7827317657E-01, 5.3094854170E-01],
	[1.0050000000E+04, 4.3064187650E+00, 5.9854622695E+00, 1.9223792186E-01, 1.7853411940E-01, 5.3110334351E-01],
	[1.0055000000E+04, 4.3092308218E+00, 5.9846669445E+00, 1.9253596902E-01, 1.7879529408E-01, 5.3125812060E-01],
	[1.0060000000E+04, 4.3120433154E+00, 5.9838721204E+00, 1.9283432937E-01, 1.7905670063E-01, 5.3141287301E-01],
	[1.0065000000E+04, 4.3148562458E+00, 5.9830777967E+00, 1.9313300307E-01, 1.7931833909E-01, 5.3156760074E-01],
	[1.0070000000E+04, 4.3176696128E+00, 5.9822839730E+00, 1.9343199030E-01, 1.7958020951E-01, 5.3172230383E-01],
	[1.0075000000E+04, 4.3204834162E+00, 5.9814906485E+00, 1.9373129122E-01, 1.7984231190E-01, 5.3187698230E-01],
	[1.0080000000E+04, 4.3232976559E+00, 5.9806978227E+00, 1.9403090602E-01, 1.8010464630E-01, 5.3203163616E-01],
	[1.0085000000E+04, 4.3261123318E+00, 5.9799054952E+00, 1.9433083486E-01, 1.8036721275E-01, 5.3218626544E-01],
	[1.0090000000E+04, 4.3289274437E+00, 5.9791136652E+00, 1.9463107791E-01, 1.8063001128E-01, 5.3234087015E-01],
	[1.0095000000E+04, 4.3317429914E+00, 5.9783223323E+00, 1.9493163536E-01, 1.8089304193E-01, 5.3249545032E-01],
	[1.0100000000E+04, 4.3345619179E+00, 5.9775423501E+00, 1.9523250736E-01, 1.8115631983E-01, 5.3265000597E-01],
	[1.0105000000E+04, 4.3373819058E+00, 5.9767651537E+00, 1.9553369410E-01, 1.8141983319E-01, 5.3280453712E-01],
	[1.0110000000E+04, 4.3402023321E+00, 5.9759884428E+00, 1.9583519574E-01, 1.8168357887E-01, 5.3295904380E-01],
	[1.0115000000E+04, 4.3430231965E+00, 5.9752122167E+00, 1.9613701247E-01, 1.8194755688E-01, 5.3311352602E-01],
	[1.0120000000E+04, 4.3458444989E+00, 5.9744364750E+00, 1.9643914444E-01, 1.8221176726E-01, 5.3326798380E-01],
	[1.0125000000E+04, 4.3486662391E+00, 5.9736612171E+00, 1.9674159184E-01, 1.8247621004E-01, 5.3342241716E-01],
	[1.0130000000E+04, 4.3514884170E+00, 5.9728864425E+00, 1.9704435484E-01, 1.8274088526E-01, 5.3357682614E-01],
	[1.0135000000E+04, 4.3543110324E+00, 5.9721121506E+00, 1.9734743360E-01, 1.8300579295E-01, 5.3373121074E-01],
	[1.0140000000E+04, 4.3571340852E+00, 5.9713383409E+00, 1.9765082831E-01, 1.8327093314E-01, 5.3388557099E-01],
	[1.0145000000E+04, 4.3599575752E+00, 5.9705650129E+00, 1.9795453913E-01, 1.8353630586E-01, 5.3403990691E-01],
	[1.0150000000E+04, 4.3627815023E+00, 5.9697921659E+00, 1.9825856624E-01, 1.8380191115E-01, 5.3419421853E-01],
	[1.0155000000E+04, 4.3656058664E+00, 5.9690197996E+00, 1.9856290980E-01, 1.8406774904E-01, 5.3434850585E-01],
	[1.0160000000E+04, 4.3684306673E+00, 5.9682479133E+00, 1.9886757001E-01, 1.8433381955E-01, 5.3450276892E-01],
	[1.0165000000E+04, 4.3712559048E+00, 5.9674765066E+00, 1.9917254701E-01, 1.8460012272E-01, 5.3465700773E-01],
	[1.0170000000E+04, 4.3740815788E+00, 5.9667055788E+00, 1.9947784100E-01, 1.8486665858E-01, 5.3481122233E-01],
	[1.0175000000E+04, 4.3769076891E+00, 5.9659351294E+00, 1.9978345213E-01, 1.8513342717E-01, 5.3496541272E-01],
	[1.0180000000E+04, 4.3797342357E+00, 5.9651651580E+00, 2.0008938059E-01, 1.8540042851E-01, 5.3511957894E-01],
	[1.0185000000E+04, 4.3825612183E+00, 5.9643956640E+00, 2.0039562655E-01, 1.8566766263E-01, 5.3527372100E-01],
	[1.0190000000E+04, 4.3853886368E+00, 5.9636266468E+00, 2.0070219017E-01, 1.8593512957E-01, 5.3542783892E-01],
	[1.0195000000E+04, 4.3882164911E+00, 5.9628581060E+00, 2.0100907164E-01, 1.8620282935E-01, 5.3558193273E-01],
	[1.0200000000E+04, 4.3910447810E+00, 5.9620900409E+00, 2.0131627112E-01, 1.8647076200E-01, 5.3573600244E-01],
	[1.0205000000E+04, 4.3938735064E+00, 5.9613224511E+00, 2.0162378879E-01, 1.8673892757E-01, 5.3589004808E-01],
	[1.0210000000E+04, 4.3967026670E+00, 5.9605553361E+00, 2.0193162482E-01, 1.8700732607E-01, 5.3604406967E-01],
	[1.0215000000E+04, 4.3995322629E+00, 5.9597886953E+00, 2.0223977938E-01, 1.8727595753E-01, 5.3619806723E-01],
	[1.0220000000E+04, 4.4023622938E+00, 5.9590225282E+00, 2.0254825264E-01, 1.8754482199E-01, 5.3635204079E-01],
	[1.0225000000E+04, 4.4051927596E+00, 5.9582568342E+00, 2.0285704479E-01, 1.8781391948E-01, 5.3650599036E-01],
	[1.0230000000E+04, 4.4080236601E+00, 5.9574916129E+00, 2.0316615598E-01, 1.8808325001E-01, 5.3665991597E-01],
	[1.0235000000E+04, 4.4108549953E+00, 5.9567268637E+00, 2.0347558641E-01, 1.8835281364E-01, 5.3681381763E-01],
	[1.0240000000E+04, 4.4136867648E+00, 5.9559625861E+00, 2.0378533622E-01, 1.8862261038E-01, 5.3696769538E-01],
	[1.0245000000E+04, 4.4165189687E+00, 5.9551987796E+00, 2.0409540561E-01, 1.8889264025E-01, 5.3712154923E-01],
	[1.0250000000E+04, 4.4193516067E+00, 5.9544354437E+00, 2.0440579474E-01, 1.8916290330E-01, 5.3727537920E-01],
	[1.0255000000E+04, 4.4221846788E+00, 5.9536725778E+00, 2.0471650378E-01, 1.8943339955E-01, 5.3742918532E-01],
	[1.0260000000E+04, 4.4250193664E+00, 5.9529142369E+00, 2.0502753292E-01, 1.8970413532E-01, 5.3758296760E-01],
	[1.0265000000E+04, 4.4278570095E+00, 5.9521650065E+00, 2.0533888231E-01, 1.8997511783E-01, 5.3773672607E-01],
	[1.0270000000E+04, 4.4306950891E+00, 5.9514162351E+00, 2.0565055214E-01, 1.9024633371E-01, 5.3789046075E-01],
	[1.0275000000E+04, 4.4335336051E+00, 5.9506679223E+00, 2.0596254257E-01, 1.9051778301E-01, 5.3804417167E-01],
	[1.0280000000E+04, 4.4363725573E+00, 5.9499200676E+00, 2.0627485379E-01, 1.9078946575E-01, 5.3819785884E-01],
	[1.0285000000E+04, 4.4392119456E+00, 5.9491726705E+00, 2.0658748596E-01, 1.9106138195E-01, 5.3835152229E-01],
	[1.0290000000E+04, 4.4420517698E+00, 5.9484257304E+00, 2.0690043925E-01, 1.9133353165E-01, 5.3850516203E-01],
	[1.0295000000E+04, 4.4448920298E+00, 5.9476792469E+00, 2.0721371384E-01, 1.9160591488E-01, 5.3865877810E-01],
	[1.0300000000E+04, 4.4477327255E+00, 5.9469332195E+00, 2.0752730990E-01, 1.9187853165E-01, 5.3881237051E-01],
	[1.0305000000E+04, 4.4505738566E+00, 5.9461876476E+00, 2.0784122761E-01, 1.9215138200E-01, 5.3896593928E-01],
	[1.0310000000E+04, 4.4534154232E+00, 5.9454425308E+00, 2.0815546713E-01, 1.9242446596E-01, 5.3911948444E-01],
	[1.0315000000E+04, 4.4562574249E+00, 5.9446978686E+00, 2.0847002865E-01, 1.9269778356E-01, 5.3927300601E-01],
	[1.0320000000E+04, 4.4590998617E+00, 5.9439536604E+00, 2.0878491233E-01, 1.9297133481E-01, 5.3942650401E-01],
	[1.0325000000E+04, 4.4619427334E+00, 5.9432099059E+00, 2.0910011834E-01, 1.9324511975E-01, 5.3957997846E-01],
	[1.0330000000E+04, 4.4647860399E+00, 5.9424666044E+00, 2.0941564686E-01, 1.9351913840E-01, 5.3973342939E-01],
	[1.0335000000E+04, 4.4676297810E+00, 5.9417237555E+00, 2.0973149807E-01, 1.9379339080E-01, 5.3988685681E-01],
	[1.0340000000E+04, 4.4704739566E+00, 5.9409813587E+00, 2.1004767213E-01, 1.9406787696E-01, 5.4004026075E-01],
	[1.0345000000E+04, 4.4733185666E+00, 5.9402394135E+00, 2.1036416922E-01, 1.9434259691E-01, 5.4019364123E-01],
	[1.0350000000E+04, 4.4761636108E+00, 5.9394979194E+00, 2.1068098951E-01, 1.9461755068E-01, 5.4034699828E-01],
	[1.0355000000E+04, 4.4790090890E+00, 5.9387568759E+00, 2.1099813317E-01, 1.9489273830E-01, 5.4050033191E-01],
	[1.0360000000E+04, 4.4818550012E+00, 5.9380162825E+00, 2.1131560038E-01, 1.9516815979E-01, 5.4065364215E-01],
	[1.0365000000E+04, 4.4847013471E+00, 5.9372761388E+00, 2.1163339131E-01, 1.9544381518E-01, 5.4080692902E-01],
	[1.0370000000E+04, 4.4875481266E+00, 5.9365364442E+00, 2.1195150614E-01, 1.9571970448E-01, 5.4096019255E-01],
	[1.0375000000E+04, 4.4903953397E+00, 5.9357971982E+00, 2.1226994503E-01, 1.9599582774E-01, 5.4111343274E-01],
	[1.0380000000E+04, 4.4932429861E+00, 5.9350584005E+00, 2.1258870815E-01, 1.9627218497E-01, 5.4126664964E-01],
	[1.0385000000E+04, 4.4960910657E+00, 5.9343200504E+00, 2.1290779570E-01, 1.9654877620E-01, 5.4141984325E-01],
	[1.0390000000E+04, 4.4989395783E+00, 5.9335821474E+00, 2.1322720782E-01, 1.9682560145E-01, 5.4157301361E-01],
	[1.0395000000E+04, 4.5017885239E+00, 5.9328446912E+00, 2.1354694471E-01, 1.9710266074E-01, 5.4172616073E-01],
	[1.0400000000E+04, 4.5046379022E+00, 5.9321076813E+00, 2.1386700653E-01, 1.9737995411E-01, 5.4187928463E-01],
	[1.0405000000E+04, 4.5074877132E+00, 5.9313711170E+00, 2.1418739345E-01, 1.9765748158E-01, 5.4203238535E-01],
	[1.0410000000E+04, 4.5103379566E+00, 5.9306349980E+00, 2.1450810565E-01, 1.9793524316E-01, 5.4218546290E-01],
	[1.0415000000E+04, 4.5131886324E+00, 5.9298993238E+00, 2.1482914330E-01, 1.9821323890E-01, 5.4233851730E-01],
	[1.0420000000E+04, 4.5160397404E+00, 5.9291640939E+00, 2.1515050657E-01, 1.9849146880E-01, 5.4249154857E-01],
	[1.0425000000E+04, 4.5188923943E+00, 5.9284328649E+00, 2.1547219564E-01, 1.9876993904E-01, 5.4264455675E-01],
	[1.0430000000E+04, 4.5217482092E+00, 5.9277107830E+00, 2.1579421069E-01, 1.9904865864E-01, 5.4279754184E-01],
	[1.0435000000E+04, 4.5246044588E+00, 5.9269891350E+00, 2.1611655187E-01, 1.9932761258E-01, 5.4295050388E-01],
	[1.0440000000E+04, 4.5274611431E+00, 5.9262679206E+00, 2.1643921937E-01, 1.9960680089E-01, 5.4310344289E-01],
	[1.0445000000E+04, 4.5303182619E+00, 5.9255471391E+00, 2.1676221337E-01, 1.9988622359E-01, 5.4325635888E-01],
	[1.0450000000E+04, 4.5331758150E+00, 5.9248267902E+00, 2.1708553402E-01, 2.0016588070E-01, 5.4340925189E-01],
	[1.0455000000E+04, 4.5360338024E+00, 5.9241068734E+00, 2.1740918151E-01, 2.0044577225E-01, 5.4356212193E-01],
	[1.0460000000E+04, 4.5388922238E+00, 5.9233873882E+00, 2.1773315601E-01, 2.0072589826E-01, 5.4371496903E-01],
	[1.0465000000E+04, 4.5417510792E+00, 5.9226683342E+00, 2.1805745769E-01, 2.0100625876E-01, 5.4386779320E-01],
	[1.0470000000E+04, 4.5446103684E+00, 5.9219497109E+00, 2.1838208673E-01, 2.0128685375E-01, 5.4402059448E-01],
	[1.0475000000E+04, 4.5474700912E+00, 5.9212315178E+00, 2.1870704330E-01, 2.0156768328E-01, 5.4417337288E-01],
	[1.0480000000E+04, 4.5503302476E+00, 5.9205137545E+00, 2.1903232757E-01, 2.0184874736E-01, 5.4432612843E-01],
	[1.0485000000E+04, 4.5531908373E+00, 5.9197964205E+00, 2.1935793971E-01, 2.0213004601E-01, 5.4447886115E-01],
	[1.0490000000E+04, 4.5560518602E+00, 5.9190795153E+00, 2.1968387990E-01, 2.0241157926E-01, 5.4463157106E-01],
	[1.0495000000E+04, 4.5589133163E+00, 5.9183630385E+00, 2.2001014832E-01, 2.0269334712E-01, 5.4478425819E-01],
	[1.0500000000E+04, 4.5617752053E+00, 5.9176469896E+00, 2.2033674513E-01, 2.0297534962E-01, 5.4493692256E-01],
	[1.0505000000E+04, 4.5646375270E+00, 5.9169313682E+00, 2.2066367051E-01, 2.0325758679E-01, 5.4508956419E-01],
	[1.0510000000E+04, 4.5675002815E+00, 5.9162161739E+00, 2.2099092463E-01, 2.0354005863E-01, 5.4524218310E-01],
	[1.0515000000E+04, 4.5703634685E+00, 5.9155014060E+00, 2.2131850766E-01, 2.0382276518E-01, 5.4539477932E-01],
	[1.0520000000E+04, 4.5732270879E+00, 5.9147870643E+00, 2.2164641978E-01, 2.0410570646E-01, 5.4554735286E-01],
	[1.0525000000E+04, 4.5760911395E+00, 5.9140731482E+00, 2.2197466117E-01, 2.0438888248E-01, 5.4569990376E-01],
	[1.0530000000E+04, 4.5789556232E+00, 5.9133596572E+00, 2.2230323199E-01, 2.0467229327E-01, 5.4585243204E-01],
	[1.0535000000E+04, 4.5818205389E+00, 5.9126465910E+00, 2.2263213241E-01, 2.0495593885E-01, 5.4600493771E-01],
	[1.0540000000E+04, 4.5846858864E+00, 5.9119339491E+00, 2.2296136262E-01, 2.0523981923E-01, 5.4615742081E-01],
	[1.0545000000E+04, 4.5875516656E+00, 5.9112217310E+00, 2.2329092279E-01, 2.0552393444E-01, 5.4630988135E-01],
	[1.0550000000E+04, 4.5904178763E+00, 5.9105099362E+00, 2.2362081308E-01, 2.0580828451E-01, 5.4646231936E-01],
	[1.0555000000E+04, 4.5932845185E+00, 5.9097985644E+00, 2.2395103367E-01, 2.0609286944E-01, 5.4661473485E-01],
	[1.0560000000E+04, 4.5961515919E+00, 5.9090876150E+00, 2.2428158474E-01, 2.0637768926E-01, 5.4676712786E-01],
	[1.0565000000E+04, 4.5990190964E+00, 5.9083770876E+00, 2.2461246645E-01, 2.0666274399E-01, 5.4691949841E-01],
	[1.0570000000E+04, 4.6018870320E+00, 5.9076669818E+00, 2.2494367899E-01, 2.0694803365E-01, 5.4707184651E-01],
	[1.0575000000E+04, 4.6047553984E+00, 5.9069572971E+00, 2.2527522252E-01, 2.0723355826E-01, 5.4722417220E-01],
	[1.0580000000E+04, 4.6076241955E+00, 5.9062480331E+00, 2.2560709722E-01, 2.0751931783E-01, 5.4737647549E-01],
	[1.0585000000E+04, 4.6104934231E+00, 5.9055391893E+00, 2.2593930326E-01, 2.0780531240E-01, 5.4752875641E-01],
	[1.0590000000E+04, 4.6133630812E+00, 5.9048307652E+00, 2.2627184082E-01, 2.0809154197E-01, 5.4768101499E-01],
	[1.0595000000E+04, 4.6162360728E+00, 5.9041313927E+00, 2.2660471006E-01, 2.0837802323E-01, 5.4783325123E-01],
	[1.0600000000E+04, 4.6191105765E+00, 5.9034356409E+00, 2.2693791117E-01, 2.0866474582E-01, 5.4798546518E-01],
	[1.0605000000E+04, 4.6219855132E+00, 5.9027402991E+00, 2.2727144431E-01, 2.0895170359E-01, 5.4813765684E-01],
	[1.0610000000E+04, 4.6248608829E+00, 5.9020453669E+00, 2.2760530966E-01, 2.0923889655E-01, 5.4828982625E-01],
	[1.0615000000E+04, 4.6277366855E+00, 5.9013508439E+00, 2.2793950739E-01, 2.0952632472E-01, 5.4844197343E-01],
	[1.0620000000E+04, 4.6306129207E+00, 5.9006567296E+00, 2.2827403768E-01, 2.0981398811E-01, 5.4859409840E-01],
	[1.0625000000E+04, 4.6334895884E+00, 5.8999630236E+00, 2.2860890069E-01, 2.1010188675E-01, 5.4874620118E-01],
	[1.0630000000E+04, 4.6363666886E+00, 5.8992697255E+00, 2.2894409661E-01, 2.1039002065E-01, 5.4889828180E-01],
	[1.0635000000E+04, 4.6392442210E+00, 5.8985768348E+00, 2.2927962561E-01, 2.1067838984E-01, 5.4905034028E-01],
	[1.0640000000E+04, 4.6421221855E+00, 5.8978843511E+00, 2.2961548785E-01, 2.1096699432E-01, 5.4920237664E-01],
	[1.0645000000E+04, 4.6450005820E+00, 5.8971922741E+00, 2.2995168352E-01, 2.1125583412E-01, 5.4935439091E-01],
	[1.0650000000E+04, 4.6478794104E+00, 5.8965006031E+00, 2.3028821278E-01, 2.1154490925E-01, 5.4950638304E-01],
	[1.0655000000E+04, 4.6507586704E+00, 5.8958093379E+00, 2.3062507582E-01, 2.1183421974E-01, 5.4965835302E-01],
	[1.0660000000E+04, 4.6536383621E+00, 5.8951184779E+00, 2.3096227279E-01, 2.1212376560E-01, 5.4981030087E-01],
	[1.0665000000E+04, 4.6565184851E+00, 5.8944280229E+00, 2.3129980389E-01, 2.1241354684E-01, 5.4996222658E-01],
	[1.0670000000E+04, 4.6593990395E+00, 5.8937379722E+00, 2.3163766927E-01, 2.1270356348E-01, 5.5011413016E-01],
	[1.0675000000E+04, 4.6622800250E+00, 5.8930483256E+00, 2.3197586912E-01, 2.1299381555E-01, 5.5026601161E-01],
	[1.0680000000E+04, 4.6651614415E+00, 5.8923590826E+00, 2.3231440361E-01, 2.1328430305E-01, 5.5041787094E-01],
	[1.0685000000E+04, 4.6680432889E+00, 5.8916702427E+00, 2.3265327290E-01, 2.1357502601E-01, 5.5056970815E-01],
	[1.0690000000E+04, 4.6709255671E+00, 5.8909818056E+00, 2.3299247718E-01, 2.1386598443E-01, 5.5072152325E-01],
	[1.0695000000E+04, 4.6738082759E+00, 5.8902937707E+00, 2.3333201662E-01, 2.1415717834E-01, 5.5087331624E-01],
	[1.0700000000E+04, 4.6766914151E+00, 5.8896061378E+00, 2.3367189140E-01, 2.1444860775E-01, 5.5102508712E-01],
	[1.0705000000E+04, 4.6795749847E+00, 5.8889189063E+00, 2.3401210167E-01, 2.1474027268E-01, 5.5117683590E-01],
	[1.0710000000E+04, 4.6824589844E+00, 5.8882320759E+00, 2.3435264763E-01, 2.1503217314E-01, 5.5132856259E-01],
	[1.0715000000E+04, 4.6853434143E+00, 5.8875456461E+00, 2.3469352944E-01, 2.1532430915E-01, 5.5148026719E-01],
	[1.0720000000E+04, 4.6882282740E+00, 5.8868596165E+00, 2.3503474727E-01, 2.1561668072E-01, 5.5163194969E-01],
	[1.0725000000E+04, 4.6911135635E+00, 5.8861739867E+00, 2.3537630130E-01, 2.1590928787E-01, 5.5178361012E-01],
	[1.0730000000E+04, 4.6939992827E+00, 5.8854887562E+00, 2.3571819171E-01, 2.1620213062E-01, 5.5193524847E-01],
	[1.0735000000E+04, 4.6968854314E+00, 5.8848039247E+00, 2.3606041867E-01, 2.1649520897E-01, 5.5208686474E-01],
	[1.0740000000E+04, 4.6997720095E+00, 5.8841194918E+00, 2.3640298234E-01, 2.1678852295E-01, 5.5223845895E-01],
	[1.0745000000E+04, 4.7026590168E+00, 5.8834354569E+00, 2.3674588291E-01, 2.1708207257E-01, 5.5239003109E-01],
	[1.0750000000E+04, 4.7055464533E+00, 5.8827518197E+00, 2.3708912055E-01, 2.1737585784E-01, 5.5254158117E-01],
	[1.0755000000E+04, 4.7084343187E+00, 5.8820685798E+00, 2.3743269543E-01, 2.1766987878E-01, 5.5269310920E-01],
	[1.0760000000E+04, 4.7113226129E+00, 5.8813857368E+00, 2.3777660772E-01, 2.1796413540E-01, 5.5284461518E-01],
	[1.0765000000E+04, 4.7142139249E+00, 5.8807104656E+00, 2.3812085760E-01, 2.1825864314E-01, 5.5299609912E-01],
	[1.0770000000E+04, 4.7171072036E+00, 5.8800398397E+00, 2.3846544525E-01, 2.1855339585E-01, 5.5314756101E-01],
	[1.0775000000E+04, 4.7200009139E+00, 5.8793696014E+00, 2.3881037083E-01, 2.1884838439E-01, 5.5329900087E-01],
	[1.0780000000E+04, 4.7228950556E+00, 5.8786997504E+00, 2.3915563452E-01, 2.1914360878E-01, 5.5345041871E-01],
	[1.0785000000E+04, 4.7257896286E+00, 5.8780302863E+00, 2.3950123650E-01, 2.1943906903E-01, 5.5360181451E-01],
	[1.0790000000E+04, 4.7286846328E+00, 5.8773612086E+00, 2.3984717693E-01, 2.1973476517E-01, 5.5375318830E-01],
	[1.0795000000E+04, 4.7315800679E+00, 5.8766925171E+00, 2.4019345599E-01, 2.2003069719E-01, 5.5390454007E-01],
	[1.0800000000E+04, 4.7344759340E+00, 5.8760242112E+00, 2.4054007386E-01, 2.2032686512E-01, 5.5405586983E-01],
	[1.0805000000E+04, 4.7373722309E+00, 5.8753562906E+00, 2.4088703071E-01, 2.2062326897E-01, 5.5420717759E-01],
	[1.0810000000E+04, 4.7402689583E+00, 5.8746887549E+00, 2.4123432671E-01, 2.2091990875E-01, 5.5435846335E-01],
	[1.0815000000E+04, 4.7431661163E+00, 5.8740216037E+00, 2.4158196204E-01, 2.2121678447E-01, 5.5450972712E-01],
	[1.0820000000E+04, 4.7460637046E+00, 5.8733548365E+00, 2.4192993686E-01, 2.2151389615E-01, 5.5466096889E-01],
	[1.0825000000E+04, 4.7489617231E+00, 5.8726884530E+00, 2.4227825136E-01, 2.2181124379E-01, 5.5481218868E-01],
	[1.0830000000E+04, 4.7518601717E+00, 5.8720224528E+00, 2.4262690571E-01, 2.2210882742E-01, 5.5496338650E-01],
	[1.0835000000E+04, 4.7547590502E+00, 5.8713568355E+00, 2.4297590008E-01, 2.2240664704E-01, 5.5511456234E-01],
	[1.0840000000E+04, 4.7576583585E+00, 5.8706916007E+00, 2.4332523464E-01, 2.2270470266E-01, 5.5526571621E-01],
	[1.0845000000E+04, 4.7605580966E+00, 5.8700267479E+00, 2.4367490958E-01, 2.2300299430E-01, 5.5541684812E-01],
	[1.0850000000E+04, 4.7634582641E+00, 5.8693622769E+00, 2.4402492505E-01, 2.2330152197E-01, 5.5556795807E-01],
	[1.0855000000E+04, 4.7663588611E+00, 5.8686981872E+00, 2.4437528124E-01, 2.2360028568E-01, 5.5571904607E-01],
	[1.0860000000E+04, 4.7692598873E+00, 5.8680344783E+00, 2.4472597833E-01, 2.2389928544E-01, 5.5587011212E-01],
	[1.0865000000E+04, 4.7721613427E+00, 5.8673711500E+00, 2.4507701647E-01, 2.2419852126E-01, 5.5602115623E-01],
	[1.0870000000E+04, 4.7750632271E+00, 5.8667082018E+00, 2.4542839586E-01, 2.2449799316E-01, 5.5617217840E-01],
	[1.0875000000E+04, 4.7779655404E+00, 5.8660456333E+00, 2.4578011665E-01, 2.2479770114E-01, 5.5632317865E-01],
	[1.0880000000E+04, 4.7808682824E+00, 5.8653834442E+00, 2.4613217903E-01, 2.2509764521E-01, 5.5647415697E-01],
	[1.0885000000E+04, 4.7837714530E+00, 5.8647216340E+00, 2.4648458318E-01, 2.2539782539E-01, 5.5662511337E-01],
	[1.0890000000E+04, 4.7866750521E+00, 5.8640602024E+00, 2.4683732925E-01, 2.2569824169E-01, 5.5677604786E-01],
	[1.0895000000E+04, 4.7895790795E+00, 5.8633991489E+00, 2.4719041743E-01, 2.2599889411E-01, 5.5692696044E-01],
	[1.0900000000E+04, 4.7924835351E+00, 5.8627384732E+00, 2.4754384790E-01, 2.2629978266E-01, 5.5707785112E-01],
	[1.0905000000E+04, 4.7953884188E+00, 5.8620781749E+00, 2.4789762081E-01, 2.2660090737E-01, 5.5722871990E-01],
	[1.0910000000E+04, 4.7982937304E+00, 5.8614182536E+00, 2.4825173636E-01, 2.2690226823E-01, 5.5737956679E-01],
	[1.0915000000E+04, 4.8011994698E+00, 5.8607587089E+00, 2.4860619471E-01, 2.2720386525E-01, 5.5753039179E-01],
	[1.0920000000E+04, 4.8041056369E+00, 5.8600995404E+00, 2.4896099604E-01, 2.2750569845E-01, 5.5768119492E-01],
	[1.0925000000E+04, 4.8070122315E+00, 5.8594407478E+00, 2.4931614052E-01, 2.2780776784E-01, 5.5783197617E-01],
	[1.0930000000E+04, 4.8099192536E+00, 5.8587823306E+00, 2.4967162832E-01, 2.2811007341E-01, 5.5798273555E-01],
	[1.0935000000E+04, 4.8128267029E+00, 5.8581242884E+00, 2.5002745962E-01, 2.2841261519E-01, 5.5813347307E-01],
	[1.0940000000E+04, 4.8157387521E+00, 5.8574774036E+00, 2.5038363460E-01, 2.2871541904E-01, 5.5828418874E-01],
	[1.0945000000E+04, 4.8186513278E+00, 5.8568311344E+00, 2.5074015342E-01, 2.2901845981E-01, 5.5843488255E-01],
	[1.0950000000E+04, 4.8215643335E+00, 5.8561852317E+00, 2.5109701626E-01, 2.2932173694E-01, 5.5858555452E-01],
	[1.0955000000E+04, 4.8244777692E+00, 5.8555396950E+00, 2.5145422329E-01, 2.2962525043E-01, 5.5873620466E-01],
	[1.0960000000E+04, 4.8273916346E+00, 5.8548945239E+00, 2.5181177470E-01, 2.2992900028E-01, 5.5888683296E-01],
	[1.0965000000E+04, 4.8303059298E+00, 5.8542497182E+00, 2.5216967064E-01, 2.3023298650E-01, 5.5903743943E-01],
	[1.0970000000E+04, 4.8332206546E+00, 5.8536052774E+00, 2.5252791131E-01, 2.3053720911E-01, 5.5918802408E-01],
	[1.0975000000E+04, 4.8361358087E+00, 5.8529612011E+00, 2.5288649686E-01, 2.3084166811E-01, 5.5933858692E-01],
	[1.0980000000E+04, 4.8390513921E+00, 5.8523174891E+00, 2.5324542748E-01, 2.3114636351E-01, 5.5948912795E-01],
	[1.0985000000E+04, 4.8419674047E+00, 5.8516741408E+00, 2.5360470334E-01, 2.3145129532E-01, 5.5963964718E-01],
	[1.0990000000E+04, 4.8448838463E+00, 5.8510311560E+00, 2.5396432461E-01, 2.3175646354E-01, 5.5979014461E-01],
	[1.0995000000E+04, 4.8478007168E+00, 5.8503885342E+00, 2.5432429146E-01, 2.3206186818E-01, 5.5994062025E-01],
	[1.1000000000E+04, 4.8507180161E+00, 5.8497462751E+00, 2.5468460408E-01, 2.3236750925E-01, 5.6009107411E-01],
	[1.1005000000E+04, 4.8536357440E+00, 5.8491043784E+00, 2.5504526263E-01, 2.3267338676E-01, 5.6024150619E-01],
	[1.1010000000E+04, 4.8565539003E+00, 5.8484628436E+00, 2.5540626729E-01, 2.3297950071E-01, 5.6039191650E-01],
	[1.1015000000E+04, 4.8594724851E+00, 5.8478216705E+00, 2.5576761824E-01, 2.3328585111E-01, 5.6054230505E-01],
	[1.1020000000E+04, 4.8623914981E+00, 5.8471808585E+00, 2.5612931564E-01, 2.3359243797E-01, 5.6069267183E-01],
	[1.1025000000E+04, 4.8653109391E+00, 5.8465404074E+00, 2.5649135967E-01, 2.3389926129E-01, 5.6084301687E-01],
	[1.1030000000E+04, 4.8682308082E+00, 5.8459003168E+00, 2.5685375050E-01, 2.3420632108E-01, 5.6099334015E-01],
	[1.1035000000E+04, 4.8711511050E+00, 5.8452605863E+00, 2.5721648832E-01, 2.3451361734E-01, 5.6114364170E-01],
	[1.1040000000E+04, 4.8740718296E+00, 5.8446212156E+00, 2.5757957329E-01, 2.3482115009E-01, 5.6129392152E-01],
	[1.1045000000E+04, 4.8769929817E+00, 5.8439822043E+00, 2.5794300558E-01, 2.3512891933E-01, 5.6144417961E-01],
	[1.1050000000E+04, 4.8799145613E+00, 5.8433435520E+00, 2.5830678538E-01, 2.3543692506E-01, 5.6159441597E-01],
	[1.1055000000E+04, 4.8828365682E+00, 5.8427052583E+00, 2.5867091285E-01, 2.3574516728E-01, 5.6174463063E-01],
	[1.1060000000E+04, 4.8857590023E+00, 5.8420673230E+00, 2.5903538818E-01, 2.3605364602E-01, 5.6189482357E-01],
	[1.1065000000E+04, 4.8886818635E+00, 5.8414297456E+00, 2.5940021153E-01, 2.3636236126E-01, 5.6204499482E-01],
	[1.1070000000E+04, 4.8916051515E+00, 5.8407925258E+00, 2.5976538307E-01, 2.3667131301E-01, 5.6219514437E-01],
	[1.1075000000E+04, 4.8945288664E+00, 5.8401556632E+00, 2.6013090299E-01, 2.3698050129E-01, 5.6234527224E-01],
	[1.1080000000E+04, 4.8974530079E+00, 5.8395191574E+00, 2.6049677145E-01, 2.3728992609E-01, 5.6249537842E-01],
	[1.1085000000E+04, 4.9003775759E+00, 5.8388830081E+00, 2.6086298864E-01, 2.3759958742E-01, 5.6264546293E-01],
	[1.1090000000E+04, 4.9033025703E+00, 5.8382472150E+00, 2.6122955472E-01, 2.3790948529E-01, 5.6279552577E-01],
	[1.1095000000E+04, 4.9062279910E+00, 5.8376117776E+00, 2.6159646987E-01, 2.3821961969E-01, 5.6294556695E-01],
	[1.1100000000E+04, 4.9091538379E+00, 5.8369766957E+00, 2.6196373426E-01, 2.3852999063E-01, 5.6309558648E-01],
	[1.1105000000E+04, 4.9120801107E+00, 5.8363419688E+00, 2.6233134807E-01, 2.3884059813E-01, 5.6324558436E-01],
	[1.1110000000E+04, 4.9150068095E+00, 5.8357075966E+00, 2.6269931147E-01, 2.3915144217E-01, 5.6339556060E-01],
	[1.1115000000E+04, 4.9179373299E+00, 5.8350817693E+00, 2.6306762464E-01, 2.3946254461E-01, 5.6354551520E-01],
	[1.1120000000E+04, 4.9208692969E+00, 5.8344587449E+00, 2.6343628774E-01, 2.3977389027E-01, 5.6369544818E-01],
	[1.1125000000E+04, 4.9238016927E+00, 5.8338360672E+00, 2.6380530097E-01, 2.4008547261E-01, 5.6384535953E-01],
	[1.1130000000E+04, 4.9267345171E+00, 5.8332137356E+00, 2.6417466448E-01, 2.4039729165E-01, 5.6399524928E-01],
	[1.1135000000E+04, 4.9296677700E+00, 5.8325917499E+00, 2.6454437845E-01, 2.4070934738E-01, 5.6414511741E-01],
	[1.1140000000E+04, 4.9326014512E+00, 5.8319701097E+00, 2.6491444306E-01, 2.4102163981E-01, 5.6429496395E-01],
	[1.1145000000E+04, 4.9355355607E+00, 5.8313488146E+00, 2.6528485848E-01, 2.4133416894E-01, 5.6444478890E-01],
	[1.1150000000E+04, 4.9384700984E+00, 5.8307278644E+00, 2.6565562489E-01, 2.4164693477E-01, 5.6459459226E-01],
	[1.1155000000E+04, 4.9414050640E+00, 5.8301072586E+00, 2.6602674246E-01, 2.4195993731E-01, 5.6474437404E-01],
	[1.1160000000E+04, 4.9443404574E+00, 5.8294869970E+00, 2.6639821136E-01, 2.4227317656E-01, 5.6489413425E-01],
	[1.1165000000E+04, 4.9472762786E+00, 5.8288670791E+00, 2.6677003177E-01, 2.4258665252E-01, 5.6504387289E-01],
	[1.1170000000E+04, 4.9502125274E+00, 5.8282475047E+00, 2.6714220386E-01, 2.4290036519E-01, 5.6519358998E-01],
	[1.1175000000E+04, 4.9531492036E+00, 5.8276282734E+00, 2.6751472781E-01, 2.4321431458E-01, 5.6534328551E-01],
	[1.1180000000E+04, 4.9560863072E+00, 5.8270093848E+00, 2.6788760379E-01, 2.4352850069E-01, 5.6549295951E-01],
	[1.1185000000E+04, 4.9590238380E+00, 5.8263908386E+00, 2.6826320947E-01, 2.4384488789E-01, 5.6564261197E-01],
	[1.1190000000E+04, 4.9619617959E+00, 5.8257726344E+00, 2.6863932504E-01, 2.4416164113E-01, 5.6579224289E-01],
	[1.1195000000E+04, 4.9649001807E+00, 5.8251547720E+00, 2.6901579911E-01, 2.4447863514E-01, 5.6594185230E-01],
	[1.1200000000E+04, 4.9678389923E+00, 5.8245372510E+00, 2.6939263186E-01, 2.4479586993E-01, 5.6609144019E-01],
	[1.1205000000E+04, 4.9707782306E+00, 5.8239200710E+00, 2.6976982347E-01, 2.4511334549E-01, 5.6624100658E-01],
	[1.1210000000E+04, 4.9737178955E+00, 5.8233032317E+00, 2.7014737413E-01, 2.4543106184E-01, 5.6639055146E-01],
	[1.1215000000E+04, 4.9766579869E+00, 5.8226867328E+00, 2.7052528401E-01, 2.4574901898E-01, 5.6654007486E-01],
	[1.1220000000E+04, 4.9795985045E+00, 5.8220705738E+00, 2.7090355329E-01, 2.4606721690E-01, 5.6668957676E-01],
	[1.1225000000E+04, 4.9825394483E+00, 5.8214547546E+00, 2.7128218215E-01, 2.4638565561E-01, 5.6683905719E-01],
	[1.1230000000E+04, 4.9854808182E+00, 5.8208392747E+00, 2.7166117078E-01, 2.4670433511E-01, 5.6698851615E-01],
	[1.1235000000E+04, 4.9884226140E+00, 5.8202241338E+00, 2.7204051936E-01, 2.4702325541E-01, 5.6713795365E-01],
	[1.1240000000E+04, 4.9913648356E+00, 5.8196093315E+00, 2.7242022806E-01, 2.4734241650E-01, 5.6728736969E-01],
	[1.1245000000E+04, 4.9943074828E+00, 5.8189948676E+00, 2.7280029707E-01, 2.4766181839E-01, 5.6743676428E-01],
	[1.1250000000E+04, 4.9972505556E+00, 5.8183807417E+00, 2.7318072656E-01, 2.4798146108E-01, 5.6758613743E-01],
	[1.1255000000E+04, 5.0001940538E+00, 5.8177669534E+00, 2.7356151673E-01, 2.4830134456E-01, 5.6773548915E-01],
	[1.1260000000E+04, 5.0031379773E+00, 5.8171535025E+00, 2.7394266774E-01, 2.4862146885E-01, 5.6788481944E-01],
	[1.1265000000E+04, 5.0060823260E+00, 5.8165403885E+00, 2.7432417978E-01, 2.4894183393E-01, 5.6803412831E-01],
	[1.1270000000E+04, 5.0090270997E+00, 5.8159276112E+00, 2.7470605304E-01, 2.4926243982E-01, 5.6818341577E-01],
	[1.1275000000E+04, 5.0119722982E+00, 5.8153151702E+00, 2.7508828769E-01, 2.4958328651E-01, 5.6833268183E-01],
	[1.1280000000E+04, 5.0149179216E+00, 5.8147030651E+00, 2.7547088391E-01, 2.4990437400E-01, 5.6848192650E-01],
	[1.1285000000E+04, 5.0178639696E+00, 5.8140912958E+00, 2.7585384188E-01, 2.5022570230E-01, 5.6863114977E-01],
	[1.1290000000E+04, 5.0208104421E+00, 5.8134798617E+00, 2.7623716179E-01, 2.5054727140E-01, 5.6878035167E-01],
	[1.1295000000E+04, 5.0237618751E+00, 5.8128789762E+00, 2.7662084381E-01, 2.5086911163E-01, 5.6892953215E-01],
	[1.1300000000E+04, 5.0267137609E+00, 5.8122784755E+00, 2.7700488813E-01, 2.5119119297E-01, 5.6907869121E-01],
	[1.1305000000E+04, 5.0296660741E+00, 5.8116783023E+00, 2.7738929493E-01, 2.5151351525E-01, 5.6922782884E-01],
	[1.1310000000E+04, 5.0326188147E+00, 5.8110784565E+00, 2.7777406438E-01, 2.5183607846E-01, 5.6937694502E-01],
	[1.1315000000E+04, 5.0355719825E+00, 5.8104789377E+00, 2.7815919668E-01, 2.5215888261E-01, 5.6952603976E-01],
	[1.1320000000E+04, 5.0385255774E+00, 5.8098797456E+00, 2.7854469199E-01, 2.5248192769E-01, 5.6967511306E-01],
	[1.1325000000E+04, 5.0414795993E+00, 5.8092808798E+00, 2.7893055050E-01, 2.5280521371E-01, 5.6982416489E-01],
	[1.1330000000E+04, 5.0444340480E+00, 5.8086823400E+00, 2.7931677240E-01, 2.5312874066E-01, 5.6997319527E-01],
	[1.1335000000E+04, 5.0473889235E+00, 5.8080841259E+00, 2.7970335786E-01, 2.5345250854E-01, 5.7012220418E-01],
	[1.1340000000E+04, 5.0503442255E+00, 5.8074862373E+00, 2.8009030706E-01, 2.5377651735E-01, 5.7027119161E-01],
	[1.1345000000E+04, 5.0532999540E+00, 5.8068886737E+00, 2.8047762019E-01, 2.5410076710E-01, 5.7042015757E-01],
	[1.1350000000E+04, 5.0562561088E+00, 5.8062914348E+00, 2.8086529742E-01, 2.5442525777E-01, 5.7056910204E-01],
	[1.1355000000E+04, 5.0592126898E+00, 5.8056945204E+00, 2.8125333894E-01, 2.5474998937E-01, 5.7071802503E-01],
	[1.1360000000E+04, 5.0621696969E+00, 5.8050979301E+00, 2.8164174493E-01, 2.5507496189E-01, 5.7086692652E-01],
	[1.1365000000E+04, 5.0651271300E+00, 5.8045016636E+00, 2.8203051556E-01, 2.5540017533E-01, 5.7101580651E-01],
	[1.1370000000E+04, 5.0680849889E+00, 5.8039057205E+00, 2.8241965103E-01, 2.5572562970E-01, 5.7116466499E-01],
	[1.1375000000E+04, 5.0710432735E+00, 5.8033101006E+00, 2.8280915150E-01, 2.5605132498E-01, 5.7131350196E-01],
	[1.1380000000E+04, 5.0740019837E+00, 5.8027148036E+00, 2.8319901717E-01, 2.5637726118E-01, 5.7146231742E-01],
	[1.1385000000E+04, 5.0769611193E+00, 5.8021198290E+00, 2.8358924821E-01, 2.5670343829E-01, 5.7161111136E-01],
	[1.1390000000E+04, 5.0799206802E+00, 5.8015251767E+00, 2.8397984480E-01, 2.5702985631E-01, 5.7175988377E-01],
	[1.1395000000E+04, 5.0828806664E+00, 5.8009308463E+00, 2.8437080713E-01, 2.5735651524E-01, 5.7190863464E-01],
	[1.1400000000E+04, 5.0858410776E+00, 5.8003368374E+00, 2.8476213537E-01, 2.5768341507E-01, 5.7205736399E-01],
	[1.1405000000E+04, 5.0888019138E+00, 5.7997431498E+00, 2.8515382971E-01, 2.5801055580E-01, 5.7220607178E-01],
	[1.1410000000E+04, 5.0917631748E+00, 5.7991497831E+00, 2.8554589033E-01, 2.5833793743E-01, 5.7235475804E-01],
	[1.1415000000E+04, 5.0947248606E+00, 5.7985567371E+00, 2.8593831741E-01, 2.5866555995E-01, 5.7250342274E-01],
	[1.1420000000E+04, 5.0976869708E+00, 5.7979640114E+00, 2.8633111112E-01, 2.5899342336E-01, 5.7265206588E-01],
	[1.1425000000E+04, 5.1006495056E+00, 5.7973716057E+00, 2.8672427166E-01, 2.5932152766E-01, 5.7280068746E-01],
	[1.1430000000E+04, 5.1036124646E+00, 5.7967795197E+00, 2.8711779921E-01, 2.5964987283E-01, 5.7294928747E-01],
	[1.1435000000E+04, 5.1065758479E+00, 5.7961877530E+00, 2.8751169393E-01, 2.5997845889E-01, 5.7309786591E-01],
	[1.1440000000E+04, 5.1095396552E+00, 5.7955963054E+00, 2.8790595602E-01, 2.6030728581E-01, 5.7324642277E-01],
	[1.1445000000E+04, 5.1125038865E+00, 5.7950051766E+00, 2.8830058566E-01, 2.6063635361E-01, 5.7339495805E-01],
	[1.1450000000E+04, 5.1154685416E+00, 5.7944143663E+00, 2.8869558302E-01, 2.6096566227E-01, 5.7354347175E-01],
	[1.1455000000E+04, 5.1184336204E+00, 5.7938238740E+00, 2.8909094829E-01, 2.6129521178E-01, 5.7369196385E-01],
	[1.1460000000E+04, 5.1213991228E+00, 5.7932336996E+00, 2.8948668165E-01, 2.6162500215E-01, 5.7384043436E-01],
	[1.1465000000E+04, 5.1243650487E+00, 5.7926438427E+00, 2.8988278328E-01, 2.6195503337E-01, 5.7398888326E-01],
	[1.1470000000E+04, 5.1273313978E+00, 5.7920543030E+00, 2.9027925336E-01, 2.6228530542E-01, 5.7413731056E-01],
	[1.1475000000E+04, 5.1303012013E+00, 5.7914714576E+00, 2.9067609208E-01, 2.6261583938E-01, 5.7428571625E-01],
	[1.1480000000E+04, 5.1332731086E+00, 5.7908924541E+00, 2.9107329961E-01, 2.6294662593E-01, 5.7443410032E-01],
	[1.1485000000E+04, 5.1362454423E+00, 5.7903137606E+00, 2.9147087614E-01, 2.6327765345E-01, 5.7458246277E-01],
	[1.1490000000E+04, 5.1392182022E+00, 5.7897353767E+00, 2.9186882184E-01, 2.6360892193E-01, 5.7473080360E-01],
	[1.1495000000E+04, 5.1421913882E+00, 5.7891573022E+00, 2.9226713690E-01, 2.6394043136E-01, 5.7487912280E-01],
	[1.1500000000E+04, 5.1451650002E+00, 5.7885795368E+00, 2.9266582150E-01, 2.6427218174E-01, 5.7502742036E-01],
	[1.1505000000E+04, 5.1481390381E+00, 5.7880020802E+00, 2.9306487582E-01, 2.6460417306E-01, 5.7517569629E-01],
	[1.1510000000E+04, 5.1511135016E+00, 5.7874249320E+00, 2.9346430004E-01, 2.6493640532E-01, 5.7532395057E-01],
	[1.1515000000E+04, 5.1540883908E+00, 5.7868480921E+00, 2.9386409434E-01, 2.6526887851E-01, 5.7547218321E-01],
	[1.1520000000E+04, 5.1570637055E+00, 5.7862715600E+00, 2.9426425891E-01, 2.6560159261E-01, 5.7562039420E-01],
	[1.1525000000E+04, 5.1600394456E+00, 5.7856953354E+00, 2.9466479393E-01, 2.6593454764E-01, 5.7576858352E-01],
	[1.1530000000E+04, 5.1630156108E+00, 5.7851194182E+00, 2.9506569957E-01, 2.6626774357E-01, 5.7591675119E-01],
	[1.1535000000E+04, 5.1659922012E+00, 5.7845438079E+00, 2.9546697602E-01, 2.6660118040E-01, 5.7606489720E-01],
	[1.1540000000E+04, 5.1689692166E+00, 5.7839685043E+00, 2.9586862346E-01, 2.6693485813E-01, 5.7621302153E-01],
	[1.1545000000E+04, 5.1719466569E+00, 5.7833935071E+00, 2.9627064207E-01, 2.6726877674E-01, 5.7636112419E-01],
	[1.1550000000E+04, 5.1749245219E+00, 5.7828188161E+00, 2.9667303203E-01, 2.6760293623E-01, 5.7650920518E-01],
	[1.1555000000E+04, 5.1779028115E+00, 5.7822444308E+00, 2.9707579353E-01, 2.6793733659E-01, 5.7665726448E-01],
	[1.1560000000E+04, 5.1808815256E+00, 5.7816703510E+00, 2.9747892674E-01, 2.6827197782E-01, 5.7680530210E-01],
	[1.1565000000E+04, 5.1838606640E+00, 5.7810965764E+00, 2.9788243185E-01, 2.6860685989E-01, 5.7695331803E-01],
	[1.1570000000E+04, 5.1868402268E+00, 5.7805231067E+00, 2.9828630904E-01, 2.6894198282E-01, 5.7710131226E-01],
	[1.1575000000E+04, 5.1898202136E+00, 5.7799499417E+00, 2.9869055848E-01, 2.6927734658E-01, 5.7724928480E-01],
	[1.1580000000E+04, 5.1928006245E+00, 5.7793770810E+00, 2.9909518037E-01, 2.6961295117E-01, 5.7739723563E-01],
	[1.1585000000E+04, 5.1957814592E+00, 5.7788045243E+00, 2.9950017488E-01, 2.6994879658E-01, 5.7754516475E-01],
	[1.1590000000E+04, 5.1987627177E+00, 5.7782322714E+00, 2.9990554219E-01, 2.7028488280E-01, 5.7769307217E-01],
	[1.1595000000E+04, 5.2017443999E+00, 5.7776603219E+00, 3.0031128249E-01, 2.7062120982E-01, 5.7784095787E-01],
	[1.1600000000E+04, 5.2047265055E+00, 5.7770886756E+00, 3.0071739595E-01, 2.7095777763E-01, 5.7798882186E-01],
	[1.1605000000E+04, 5.2077090346E+00, 5.7765173321E+00, 3.0112388276E-01, 2.7129458623E-01, 5.7813666412E-01],
	[1.1610000000E+04, 5.2106919869E+00, 5.7759462913E+00, 3.0153074310E-01, 2.7163163560E-01, 5.7828448466E-01],
	[1.1615000000E+04, 5.2136753624E+00, 5.7753755527E+00, 3.0193797715E-01, 2.7196892574E-01, 5.7843228347E-01],
	[1.1620000000E+04, 5.2166591608E+00, 5.7748051161E+00, 3.0234558509E-01, 2.7230645663E-01, 5.7858006054E-01],
	[1.1625000000E+04, 5.2196433822E+00, 5.7742349812E+00, 3.0275356711E-01, 2.7264422826E-01, 5.7872781588E-01],
	[1.1630000000E+04, 5.2226280264E+00, 5.7736651477E+00, 3.0316192338E-01, 2.7298224062E-01, 5.7887554947E-01],
	[1.1635000000E+04, 5.2256130932E+00, 5.7730956154E+00, 3.0357065409E-01, 2.7332049371E-01, 5.7902326132E-01],
	[1.1640000000E+04, 5.2285985826E+00, 5.7725263839E+00, 3.0397975942E-01, 2.7365898751E-01, 5.7917095143E-01],
	[1.1645000000E+04, 5.2315844944E+00, 5.7719574530E+00, 3.0438923954E-01, 2.7399772201E-01, 5.7931861978E-01],
	[1.1650000000E+04, 5.2345708284E+00, 5.7713888223E+00, 3.0479909465E-01, 2.7433669720E-01, 5.7946626637E-01],
	[1.1655000000E+04, 5.2375575847E+00, 5.7708204916E+00, 3.0520932492E-01, 2.7467591307E-01, 5.7961389121E-01],
	[1.1660000000E+04, 5.2405482016E+00, 5.7702592222E+00, 3.0561993054E-01, 2.7501539444E-01, 5.7976149428E-01],
	[1.1665000000E+04, 5.2435406640E+00, 5.7697010406E+00, 3.0603091168E-01, 2.7535512685E-01, 5.7990907559E-01],
	[1.1670000000E+04, 5.2465335516E+00, 5.7691431521E+00, 3.0644226853E-01, 2.7569510005E-01, 5.8005663512E-01],
	[1.1675000000E+04, 5.2495268644E+00, 5.7685855565E+00, 3.0685400127E-01, 2.7603531403E-01, 5.8020417289E-01],
	[1.1680000000E+04, 5.2525206022E+00, 5.7680282535E+00, 3.0726611008E-01, 2.7637576878E-01, 5.8035168887E-01],
	[1.1685000000E+04, 5.2555147650E+00, 5.7674712428E+00, 3.0767859514E-01, 2.7671646429E-01, 5.8049918308E-01],
	[1.1690000000E+04, 5.2585093525E+00, 5.7669145241E+00, 3.0809145664E-01, 2.7705740055E-01, 5.8064665550E-01],
	[1.1695000000E+04, 5.2615043646E+00, 5.7663580973E+00, 3.0850469475E-01, 2.7739857754E-01, 5.8079410614E-01],
	[1.1700000000E+04, 5.2644998013E+00, 5.7658019619E+00, 3.0891830966E-01, 2.7773999525E-01, 5.8094153498E-01],
	[1.1705000000E+04, 5.2674956624E+00, 5.7652461177E+00, 3.0933230154E-01, 2.7808165367E-01, 5.8108894203E-01],
	[1.1710000000E+04, 5.2704919478E+00, 5.7646905645E+00, 3.0974667059E-01, 2.7842355279E-01, 5.8123632729E-01],
	[1.1715000000E+04, 5.2734886574E+00, 5.7641353020E+00, 3.1016141698E-01, 2.7876569259E-01, 5.8138369074E-01],
	[1.1720000000E+04, 5.2764857911E+00, 5.7635803298E+00, 3.1057654089E-01, 2.7910807307E-01, 5.8153103239E-01],
	[1.1725000000E+04, 5.2794833486E+00, 5.7630256478E+00, 3.1099204251E-01, 2.7945069420E-01, 5.8167835224E-01],
	[1.1730000000E+04, 5.2824813300E+00, 5.7624712555E+00, 3.1140792202E-01, 2.7979355598E-01, 5.8182565027E-01],
	[1.1735000000E+04, 5.2854797351E+00, 5.7619171529E+00, 3.1182417960E-01, 2.8013665839E-01, 5.8197292649E-01],
	[1.1740000000E+04, 5.2884785637E+00, 5.7613633395E+00, 3.1224081542E-01, 2.8048000141E-01, 5.8212018090E-01],
	[1.1745000000E+04, 5.2914778158E+00, 5.7608098152E+00, 3.1265782968E-01, 2.8082358505E-01, 5.8226741349E-01],
	[1.1750000000E+04, 5.2944774913E+00, 5.7602565795E+00, 3.1307522255E-01, 2.8116740927E-01, 5.8241462425E-01],
	[1.1755000000E+04, 5.2974775899E+00, 5.7597036324E+00, 3.1349299422E-01, 2.8151147407E-01, 5.8256181319E-01],
	[1.1760000000E+04, 5.3004781116E+00, 5.7591509734E+00, 3.1391114487E-01, 2.8185577943E-01, 5.8270898030E-01],
	[1.1765000000E+04, 5.3034790563E+00, 5.7585986024E+00, 3.1432967467E-01, 2.8220032534E-01, 5.8285612558E-01],
	[1.1770000000E+04, 5.3064804238E+00, 5.7580465190E+00, 3.1474858382E-01, 2.8254511179E-01, 5.8300324903E-01],
	[1.1775000000E+04, 5.3094822141E+00, 5.7574947230E+00, 3.1516787249E-01, 2.8289013875E-01, 5.8315035064E-01],
	[1.1780000000E+04, 5.3124844270E+00, 5.7569432140E+00, 3.1558754086E-01, 2.8323540622E-01, 5.8329743041E-01],
	[1.1785000000E+04, 5.3154870623E+00, 5.7563919919E+00, 3.1600758912E-01, 2.8358091418E-01, 5.8344448834E-01],
	[1.1790000000E+04, 5.3184901201E+00, 5.7558410564E+00, 3.1642801745E-01, 2.8392666261E-01, 5.8359152442E-01],
	[1.1795000000E+04, 5.3214936001E+00, 5.7552904072E+00, 3.1684882603E-01, 2.8427265150E-01, 5.8373853865E-01],
	[1.1800000000E+04, 5.3244975022E+00, 5.7547400440E+00, 3.1727001504E-01, 2.8461888084E-01, 5.8388553103E-01],
	[1.1805000000E+04, 5.3275018263E+00, 5.7541899665E+00, 3.1769158467E-01, 2.8496535060E-01, 5.8403250156E-01],
	[1.1810000000E+04, 5.3305065723E+00, 5.7536401745E+00, 3.1811353508E-01, 2.8531206078E-01, 5.8417945023E-01],
	[1.1815000000E+04, 5.3335117401E+00, 5.7530906678E+00, 3.1853586648E-01, 2.8565901135E-01, 5.8432637704E-01],
	[1.1820000000E+04, 5.3365173295E+00, 5.7525414460E+00, 3.1895857904E-01, 2.8600620230E-01, 5.8447328199E-01],
	[1.1825000000E+04, 5.3395233404E+00, 5.7519925088E+00, 3.1938167293E-01, 2.8635363362E-01, 5.8462016508E-01],
	[1.1830000000E+04, 5.3425297728E+00, 5.7514438561E+00, 3.1980514835E-01, 2.8670130528E-01, 5.8476702630E-01],
	[1.1835000000E+04, 5.3455366265E+00, 5.7508954875E+00, 3.2022900548E-01, 2.8704921728E-01, 5.8491386565E-01],
	[1.1840000000E+04, 5.3485439013E+00, 5.7503474028E+00, 3.2065324449E-01, 2.8739736959E-01, 5.8506068312E-01],
	[1.1845000000E+04, 5.3515524840E+00, 5.7498012328E+00, 3.2107786557E-01, 2.8774576884E-01, 5.8520747873E-01],
	[1.1850000000E+04, 5.3545656129E+00, 5.7492629261E+00, 3.2150286890E-01, 2.8809443938E-01, 5.8535425245E-01],
	[1.1855000000E+04, 5.3575791660E+00, 5.7487248968E+00, 3.2192825466E-01, 2.8844335034E-01, 5.8550100429E-01],
	[1.1860000000E+04, 5.3605931434E+00, 5.7481871447E+00, 3.2235402304E-01, 2.8879250169E-01, 5.8564773426E-01],
	[1.1865000000E+04, 5.3636075448E+00, 5.7476496696E+00, 3.2278017421E-01, 2.8914189343E-01, 5.8579444233E-01],
	[1.1870000000E+04, 5.3666223703E+00, 5.7471124711E+00, 3.2320670836E-01, 2.8949152554E-01, 5.8594112853E-01],
	[1.1875000000E+04, 5.3696376196E+00, 5.7465755490E+00, 3.2363362567E-01, 2.8984139799E-01, 5.8608779283E-01],
	[1.1880000000E+04, 5.3726532926E+00, 5.7460389031E+00, 3.2406092633E-01, 2.9019151078E-01, 5.8623443524E-01],
	[1.1885000000E+04, 5.3756693893E+00, 5.7455025331E+00, 3.2448861051E-01, 2.9054186388E-01, 5.8638105575E-01],
	[1.1890000000E+04, 5.3786859095E+00, 5.7449664388E+00, 3.2491667839E-01, 2.9089245727E-01, 5.8652765437E-01],
	[1.1895000000E+04, 5.3817028531E+00, 5.7444306198E+00, 3.2534513016E-01, 2.9124329094E-01, 5.8667423109E-01],
	[1.1900000000E+04, 5.3847202199E+00, 5.7438950759E+00, 3.2577396600E-01, 2.9159436487E-01, 5.8682078591E-01],
	[1.1905000000E+04, 5.3877380099E+00, 5.7433598069E+00, 3.2620318610E-01, 2.9194567903E-01, 5.8696731881E-01],
	[1.1910000000E+04, 5.3907562229E+00, 5.7428248125E+00, 3.2663279062E-01, 2.9229723342E-01, 5.8711382976E-01],
	[1.1915000000E+04, 5.3937748589E+00, 5.7422900925E+00, 3.2706277977E-01, 2.9264902801E-01, 5.8726031876E-01],
	[1.1920000000E+04, 5.3967939176E+00, 5.7417556466E+00, 3.2749315371E-01, 2.9300106279E-01, 5.8740678578E-01],
	[1.1925000000E+04, 5.3998133990E+00, 5.7412214745E+00, 3.2792391263E-01, 2.9335333773E-01, 5.8755323083E-01],
	[1.1930000000E+04, 5.4028333030E+00, 5.7406875760E+00, 3.2835505672E-01, 2.9370585281E-01, 5.8769965388E-01],
	[1.1935000000E+04, 5.4058536294E+00, 5.7401539508E+00, 3.2878658615E-01, 2.9405860802E-01, 5.8784605494E-01],
	[1.1940000000E+04, 5.4088743781E+00, 5.7396205987E+00, 3.2921850110E-01, 2.9441160334E-01, 5.8799243397E-01],
	[1.1945000000E+04, 5.4118955491E+00, 5.7390875195E+00, 3.2965080176E-01, 2.9476483874E-01, 5.8813879098E-01],
	[1.1950000000E+04, 5.4149171421E+00, 5.7385547128E+00, 3.3008348832E-01, 2.9511831421E-01, 5.8828512595E-01],
	[1.1955000000E+04, 5.4179391571E+00, 5.7380221784E+00, 3.3051656094E-01, 2.9547202972E-01, 5.8843143887E-01],
	[1.1960000000E+04, 5.4209615939E+00, 5.7374899161E+00, 3.3095001983E-01, 2.9582598526E-01, 5.8857772973E-01],
	[1.1965000000E+04, 5.4239844525E+00, 5.7369579257E+00, 3.3138386514E-01, 2.9618018080E-01, 5.8872399851E-01],
	[1.1970000000E+04, 5.4270077327E+00, 5.7364262067E+00, 3.3181809708E-01, 2.9653461633E-01, 5.8887024521E-01],
	[1.1975000000E+04, 5.4300314344E+00, 5.7358947591E+00, 3.3225271582E-01, 2.9688929183E-01, 5.8901646982E-01],
	[1.1980000000E+04, 5.4330555575E+00, 5.7353635826E+00, 3.3268772154E-01, 2.9724420727E-01, 5.8916267231E-01],
	[1.1985000000E+04, 5.4360801019E+00, 5.7348326768E+00, 3.3312311443E-01, 2.9759936262E-01, 5.8930885269E-01],
	[1.1990000000E+04, 5.4391050674E+00, 5.7343020416E+00, 3.3355889466E-01, 2.9795475788E-01, 5.8945501094E-01],
	[1.1995000000E+04, 5.4421304539E+00, 5.7337716767E+00, 3.3399506243E-01, 2.9831039302E-01, 5.8960114704E-01],
	[1.2000000000E+04, 5.4451562613E+00, 5.7332415819E+00, 3.3443161790E-01, 2.9866626802E-01, 5.8974726100E-01],
	[1.2005000000E+04, 5.4481824896E+00, 5.7327117568E+00, 3.3486856127E-01, 2.9902238285E-01, 5.8989335278E-01],
	[1.2010000000E+04, 5.4512091385E+00, 5.7321822014E+00, 3.3530589272E-01, 2.9937873750E-01, 5.9003942240E-01],
	[1.2015000000E+04, 5.4542362080E+00, 5.7316529152E+00, 3.3574361242E-01, 2.9973533194E-01, 5.9018546983E-01],
	[1.2020000000E+04, 5.4572636979E+00, 5.7311238981E+00, 3.3618172057E-01, 3.0009216615E-01, 5.9033149506E-01],
	[1.2025000000E+04, 5.4602916082E+00, 5.7305951497E+00, 3.3662021734E-01, 3.0044924010E-01, 5.9047749808E-01],
	[1.2030000000E+04, 5.4633199387E+00, 5.7300666700E+00, 3.3705910291E-01, 3.0080655378E-01, 5.9062347888E-01],
	[1.2035000000E+04, 5.4663489071E+00, 5.7295388333E+00, 3.3749837747E-01, 3.0116410886E-01, 5.9076943745E-01],
	[1.2040000000E+04, 5.4693832424E+00, 5.7290197699E+00, 3.3793804120E-01, 3.0152194223E-01, 5.9091537378E-01],
	[1.2045000000E+04, 5.4724180013E+00, 5.7285009689E+00, 3.3837809428E-01, 3.0188001540E-01, 5.9106128786E-01],
	[1.2050000000E+04, 5.4754531834E+00, 5.7279824303E+00, 3.3881853690E-01, 3.0223832838E-01, 5.9120717967E-01],
	[1.2055000000E+04, 5.4784887887E+00, 5.7274641536E+00, 3.3925936923E-01, 3.0259688113E-01, 5.9135304921E-01],
	[1.2060000000E+04, 5.4815248172E+00, 5.7269461387E+00, 3.3970059146E-01, 3.0295567362E-01, 5.9149889647E-01],
	[1.2065000000E+04, 5.4845612686E+00, 5.7264283854E+00, 3.4014220378E-01, 3.0331470584E-01, 5.9164472143E-01],
	[1.2070000000E+04, 5.4875981429E+00, 5.7259108934E+00, 3.4058420635E-01, 3.0367397777E-01, 5.9179052408E-01],
	[1.2075000000E+04, 5.4906354400E+00, 5.7253936624E+00, 3.4102659937E-01, 3.0403348937E-01, 5.9193630441E-01],
	[1.2080000000E+04, 5.4936731596E+00, 5.7248766923E+00, 3.4146938302E-01, 3.0439324063E-01, 5.9208206242E-01],
	[1.2085000000E+04, 5.4967113018E+00, 5.7243599828E+00, 3.4191255748E-01, 3.0475323152E-01, 5.9222779808E-01],
	[1.2090000000E+04, 5.4997498664E+00, 5.7238435336E+00, 3.4235612294E-01, 3.0511346202E-01, 5.9237351140E-01],
	[1.2095000000E+04, 5.5027888533E+00, 5.7233273445E+00, 3.4280007956E-01, 3.0547393209E-01, 5.9251920235E-01],
	[1.2100000000E+04, 5.5058282623E+00, 5.7228114152E+00, 3.4324442755E-01, 3.0583464173E-01, 5.9266487094E-01],
	[1.2105000000E+04, 5.5088680934E+00, 5.7222957456E+00, 3.4368916707E-01, 3.0619559090E-01, 5.9281051714E-01],
	[1.2110000000E+04, 5.5119083465E+00, 5.7217803354E+00, 3.4413429832E-01, 3.0655677958E-01, 5.9295614095E-01],
	[1.2115000000E+04, 5.5149490213E+00, 5.7212651844E+00, 3.4457982147E-01, 3.0691820775E-01, 5.9310174236E-01],
	[1.2120000000E+04, 5.5179901179E+00, 5.7207502922E+00, 3.4502573671E-01, 3.0727987537E-01, 5.9324732136E-01],
	[1.2125000000E+04, 5.5210316360E+00, 5.7202356588E+00, 3.4547204421E-01, 3.0764178243E-01, 5.9339287793E-01],
	[1.2130000000E+04, 5.5240735756E+00, 5.7197212837E+00, 3.4591874417E-01, 3.0800392889E-01, 5.9353841207E-01],
	[1.2135000000E+04, 5.5271159366E+00, 5.7192071669E+00, 3.4636583677E-01, 3.0836631474E-01, 5.9368392376E-01],
	[1.2140000000E+04, 5.5301587188E+00, 5.7186933081E+00, 3.4681332218E-01, 3.0872893995E-01, 5.9382941300E-01],
	[1.2145000000E+04, 5.5332019221E+00, 5.7181797070E+00, 3.4726120058E-01, 3.0909180448E-01, 5.9397487978E-01],
	[1.2150000000E+04, 5.5362455465E+00, 5.7176663634E+00, 3.4770947217E-01, 3.0945490832E-01, 5.9412032408E-01],
	[1.2155000000E+04, 5.5392895917E+00, 5.7171532771E+00, 3.4815813713E-01, 3.0981825144E-01, 5.9426574589E-01],
	[1.2160000000E+04, 5.5423340578E+00, 5.7166404478E+00, 3.4860719563E-01, 3.1018183382E-01, 5.9441114521E-01],
	[1.2165000000E+04, 5.5453789445E+00, 5.7161278752E+00, 3.4905664786E-01, 3.1054565541E-01, 5.9455652202E-01],
	[1.2170000000E+04, 5.5484242517E+00, 5.7156155593E+00, 3.4950649400E-01, 3.1090971621E-01, 5.9470187632E-01],
	[1.2175000000E+04, 5.5514699794E+00, 5.7151034997E+00, 3.4995673423E-01, 3.1127401618E-01, 5.9484720809E-01],
	[1.2180000000E+04, 5.5545161274E+00, 5.7145916962E+00, 3.5040736874E-01, 3.1163855530E-01, 5.9499251733E-01],
	[1.2185000000E+04, 5.5575626957E+00, 5.7140801485E+00, 3.5085839771E-01, 3.1200333353E-01, 5.9513780401E-01],
	[1.2190000000E+04, 5.5606096840E+00, 5.7135688565E+00, 3.5130982132E-01, 3.1236835086E-01, 5.9528306815E-01],
	[1.2195000000E+04, 5.5636570923E+00, 5.7130578198E+00, 3.5176163975E-01, 3.1273360725E-01, 5.9542830971E-01],
	[1.2200000000E+04, 5.5667049204E+00, 5.7125470384E+00, 3.5221385319E-01, 3.1309910267E-01, 5.9557352870E-01],
	[1.2205000000E+04, 5.5697531683E+00, 5.7120365118E+00, 3.5266646182E-01, 3.1346483710E-01, 5.9571872510E-01],
	[1.2210000000E+04, 5.5728018359E+00, 5.7115262400E+00, 3.5311946582E-01, 3.1383081052E-01, 5.9586389891E-01],
	[1.2215000000E+04, 5.5758509230E+00, 5.7110162226E+00, 3.5357286538E-01, 3.1419702288E-01, 5.9600905011E-01],
	[1.2220000000E+04, 5.5789004295E+00, 5.7105064595E+00, 3.5402666067E-01, 3.1456347417E-01, 5.9615417870E-01],
	[1.2225000000E+04, 5.5819503552E+00, 5.7099969504E+00, 3.5448085188E-01, 3.1493016435E-01, 5.9629928466E-01],
	[1.2230000000E+04, 5.5850022609E+00, 5.7094902069E+00, 3.5493543919E-01, 3.1529710604E-01, 5.9644436798E-01],
	[1.2235000000E+04, 5.5880583456E+00, 5.7089897618E+00, 3.5539042279E-01, 3.1566431709E-01, 5.9658942866E-01],
	[1.2240000000E+04, 5.5911148529E+00, 5.7084895650E+00, 3.5584580285E-01, 3.1603176712E-01, 5.9673446669E-01],
	[1.2245000000E+04, 5.5941717827E+00, 5.7079896163E+00, 3.5630157956E-01, 3.1639945609E-01, 5.9687948205E-01],
	[1.2250000000E+04, 5.5972291349E+00, 5.7074899154E+00, 3.5675775311E-01, 3.1676738399E-01, 5.9702447473E-01],
	[1.2255000000E+04, 5.6002869093E+00, 5.7069904622E+00, 3.5721432367E-01, 3.1713555078E-01, 5.9716944474E-01],
	[1.2260000000E+04, 5.6033451059E+00, 5.7064912564E+00, 3.5767129143E-01, 3.1750395644E-01, 5.9731439205E-01],
	[1.2265000000E+04, 5.6064037245E+00, 5.7059922978E+00, 3.5812865656E-01, 3.1787260092E-01, 5.9745931665E-01],
	[1.2270000000E+04, 5.6094627650E+00, 5.7054935861E+00, 3.5858641926E-01, 3.1824148421E-01, 5.9760421855E-01],
	[1.2275000000E+04, 5.6125222273E+00, 5.7049951212E+00, 3.5904457971E-01, 3.1861060628E-01, 5.9774909772E-01],
	[1.2280000000E+04, 5.6155821112E+00, 5.7044969028E+00, 3.5950313808E-01, 3.1897996708E-01, 5.9789395416E-01],
	[1.2285000000E+04, 5.6186424168E+00, 5.7039989307E+00, 3.5996209457E-01, 3.1934956660E-01, 5.9803878786E-01],
	[1.2290000000E+04, 5.6217031438E+00, 5.7035012047E+00, 3.6042144935E-01, 3.1971940481E-01, 5.9818359881E-01],
	[1.2295000000E+04, 5.6247642921E+00, 5.7030037246E+00, 3.6088120260E-01, 3.2008948166E-01, 5.9832838700E-01],
	[1.2300000000E+04, 5.6278258617E+00, 5.7025064901E+00, 3.6134135451E-01, 3.2045979714E-01, 5.9847315242E-01],
	[1.2305000000E+04, 5.6308878524E+00, 5.7020095010E+00, 3.6180190527E-01, 3.2083035122E-01, 5.9861789506E-01],
	[1.2310000000E+04, 5.6339502640E+00, 5.7015127570E+00, 3.6226285505E-01, 3.2120114385E-01, 5.9876261492E-01],
	[1.2315000000E+04, 5.6370130966E+00, 5.7010162581E+00, 3.6272420403E-01, 3.2157217501E-01, 5.9890731197E-01],
	[1.2320000000E+04, 5.6400763500E+00, 5.7005200039E+00, 3.6318595241E-01, 3.2194344468E-01, 5.9905198623E-01],
	[1.2325000000E+04, 5.6431400240E+00, 5.7000239942E+00, 3.6364810036E-01, 3.2231495281E-01, 5.9919663766E-01],
	[1.2330000000E+04, 5.6462041185E+00, 5.6995282289E+00, 3.6411064806E-01, 3.2268669938E-01, 5.9934126628E-01],
	[1.2335000000E+04, 5.6492686335E+00, 5.6990327076E+00, 3.6457359571E-01, 3.2305868435E-01, 5.9948587205E-01],
	[1.2340000000E+04, 5.6523335688E+00, 5.6985374303E+00, 3.6503694347E-01, 3.2343090769E-01, 5.9963045499E-01],
	[1.2345000000E+04, 5.6553989243E+00, 5.6980423965E+00, 3.6550069154E-01, 3.2380336938E-01, 5.9977501508E-01],
	[1.2350000000E+04, 5.6584647000E+00, 5.6975476063E+00, 3.6596484009E-01, 3.2417606938E-01, 5.9991955230E-01],
	[1.2355000000E+04, 5.6615308956E+00, 5.6970530592E+00, 3.6642938931E-01, 3.2454900765E-01, 6.0006406665E-01],
	[1.2360000000E+04, 5.6645975111E+00, 5.6965587551E+00, 3.6689433939E-01, 3.2492218416E-01, 6.0020855813E-01],
	[1.2365000000E+04, 5.6676645463E+00, 5.6960646938E+00, 3.6735969050E-01, 3.2529559889E-01, 6.0035302672E-01],
	[1.2370000000E+04, 5.6707320012E+00, 5.6955708751E+00, 3.6782544282E-01, 3.2566925180E-01, 6.0049747241E-01],
	[1.2375000000E+04, 5.6737998756E+00, 5.6950772987E+00, 3.6829159655E-01, 3.2604314285E-01, 6.0064189519E-01],
	[1.2380000000E+04, 5.6768681695E+00, 5.6945839645E+00, 3.6875815186E-01, 3.2641727202E-01, 6.0078629507E-01],
	[1.2385000000E+04, 5.6799368826E+00, 5.6940908722E+00, 3.6922510894E-01, 3.2679163927E-01, 6.0093067201E-01],
	[1.2390000000E+04, 5.6830060150E+00, 5.6935980216E+00, 3.6969246797E-01, 3.2716624456E-01, 6.0107502603E-01],
	[1.2395000000E+04, 5.6860755664E+00, 5.6931054124E+00, 3.7016022913E-01, 3.2754108786E-01, 6.0121935710E-01],
	[1.2400000000E+04, 5.6891455369E+00, 5.6926130445E+00, 3.7062839260E-01, 3.2791616915E-01, 6.0136366523E-01],
	[1.2405000000E+04, 5.6922159262E+00, 5.6921209177E+00, 3.7109695858E-01, 3.2829148838E-01, 6.0150795040E-01],
	[1.2410000000E+04, 5.6952867342E+00, 5.6916290317E+00, 3.7156592723E-01, 3.2866704552E-01, 6.0165221260E-01],
	[1.2415000000E+04, 5.6983579609E+00, 5.6911373864E+00, 3.7203529875E-01, 3.2904284054E-01, 6.0179645182E-01],
	[1.2420000000E+04, 5.7014296061E+00, 5.6906459814E+00, 3.7250507331E-01, 3.2941887340E-01, 6.0194066806E-01],
	[1.2425000000E+04, 5.7045016697E+00, 5.6901548166E+00, 3.7297525110E-01, 3.2979514407E-01, 6.0208486131E-01],
	[1.2430000000E+04, 5.7075792036E+00, 5.6896714906E+00, 3.7344583231E-01, 3.3017169501E-01, 6.0222903156E-01],
	[1.2435000000E+04, 5.7106575930E+00, 5.6891890525E+00, 3.7391681711E-01, 3.3054848750E-01, 6.0237317879E-01],
	[1.2440000000E+04, 5.7137364043E+00, 5.6887068491E+00, 3.7438820569E-01, 3.3092551788E-01, 6.0251730301E-01],
	[1.2445000000E+04, 5.7168156372E+00, 5.6882248804E+00, 3.7485999823E-01, 3.3130278611E-01, 6.0266140420E-01],
	[1.2450000000E+04, 5.7198952917E+00, 5.6877431461E+00, 3.7533219492E-01, 3.3168029214E-01, 6.0280548235E-01],
	[1.2455000000E+04, 5.7229753677E+00, 5.6872616460E+00, 3.7580479593E-01, 3.3205803595E-01, 6.0294953746E-01],
	[1.2460000000E+04, 5.7260558650E+00, 5.6867803799E+00, 3.7627780145E-01, 3.3243601751E-01, 6.0309356952E-01],
	[1.2465000000E+04, 5.7291367835E+00, 5.6862993476E+00, 3.7675121167E-01, 3.3281423677E-01, 6.0323757852E-01],
	[1.2470000000E+04, 5.7322181231E+00, 5.6858185488E+00, 3.7722502676E-01, 3.3319269370E-01, 6.0338156445E-01],
	[1.2475000000E+04, 5.7352998838E+00, 5.6853379835E+00, 3.7769924691E-01, 3.3357138826E-01, 6.0352552730E-01],
	[1.2480000000E+04, 5.7383820653E+00, 5.6848576513E+00, 3.7817387231E-01, 3.3395032042E-01, 6.0366946707E-01],
	[1.2485000000E+04, 5.7414646676E+00, 5.6843775520E+00, 3.7864890313E-01, 3.3432949015E-01, 6.0381338385E-01],
	[1.2490000000E+04, 5.7445476906E+00, 5.6838976856E+00, 3.7912433955E-01, 3.3470889740E-01, 6.0395727778E-01],
	[1.2495000000E+04, 5.7476311342E+00, 5.6834180516E+00, 3.7960018177E-01, 3.3508854214E-01, 6.0410114884E-01],
	[1.2500000000E+04, 5.7507149982E+00, 5.6829386500E+00, 3.8007642997E-01, 3.3546842434E-01, 6.0424499701E-01],
	[1.2505000000E+04, 5.7537992826E+00, 5.6824594806E+00, 3.8055403326E-01, 3.3584928305E-01, 6.0438882229E-01],
	[1.2510000000E+04, 5.7568839872E+00, 5.6819805430E+00, 3.8103204497E-01, 3.3623038038E-01, 6.0453262465E-01],
	[1.2515000000E+04, 5.7599691119E+00, 5.6815018372E+00, 3.8151046525E-01, 3.3661171630E-01, 6.0467640408E-01],
	[1.2520000000E+04, 5.7630546566E+00, 5.6810233629E+00, 3.8198929432E-01, 3.3699329078E-01, 6.0482016057E-01],
	[1.2525000000E+04, 5.7661406212E+00, 5.6805451200E+00, 3.8246853234E-01, 3.3737510377E-01, 6.0496389410E-01],
	[1.2530000000E+04, 5.7692270056E+00, 5.6800671081E+00, 3.8294817950E-01, 3.3775715525E-01, 6.0510760466E-01],
	[1.2535000000E+04, 5.7723138097E+00, 5.6795893272E+00, 3.8342823599E-01, 3.3813944517E-01, 6.0525129224E-01],
	[1.2540000000E+04, 5.7754010333E+00, 5.6791117769E+00, 3.8390870200E-01, 3.3852197349E-01, 6.0539495682E-01],
	[1.2545000000E+04, 5.7784886764E+00, 5.6786344572E+00, 3.8438957771E-01, 3.3890474018E-01, 6.0553859838E-01],
	[1.2550000000E+04, 5.7815767389E+00, 5.6781573677E+00, 3.8487086330E-01, 3.3928774520E-01, 6.0568221691E-01],
	[1.2555000000E+04, 5.7846652206E+00, 5.6776805084E+00, 3.8535255895E-01, 3.3967098851E-01, 6.0582581240E-01],
	[1.2560000000E+04, 5.7877541214E+00, 5.6772038790E+00, 3.8583466487E-01, 3.4005447008E-01, 6.0596938484E-01],
	[1.2565000000E+04, 5.7908434412E+00, 5.6767274792E+00, 3.8631718122E-01, 3.4043818986E-01, 6.0611293420E-01],
	[1.2570000000E+04, 5.7939331800E+00, 5.6762513089E+00, 3.8680010820E-01, 3.4082214781E-01, 6.0625646048E-01],
	[1.2575000000E+04, 5.7970233375E+00, 5.6757753679E+00, 3.8728344599E-01, 3.4120634391E-01, 6.0639996366E-01],
	[1.2580000000E+04, 5.8001139137E+00, 5.6752996560E+00, 3.8776719478E-01, 3.4159077810E-01, 6.0654344373E-01],
	[1.2585000000E+04, 5.8032049085E+00, 5.6748241730E+00, 3.8825135475E-01, 3.4197545036E-01, 6.0668690067E-01],
	[1.2590000000E+04, 5.8062963218E+00, 5.6743489187E+00, 3.8873592608E-01, 3.4236036063E-01, 6.0683033447E-01],
	[1.2595000000E+04, 5.8093881534E+00, 5.6738738929E+00, 3.8922090897E-01, 3.4274550889E-01, 6.0697374512E-01],
	[1.2600000000E+04, 5.8124804032E+00, 5.6733990953E+00, 3.8970630360E-01, 3.4313089509E-01, 6.0711713260E-01],
	[1.2605000000E+04, 5.8155730712E+00, 5.6729245258E+00, 3.9019211014E-01, 3.4351651919E-01, 6.0726049689E-01],
	[1.2610000000E+04, 5.8186661573E+00, 5.6724501842E+00, 3.9067832880E-01, 3.4390238115E-01, 6.0740383799E-01],
	[1.2615000000E+04, 5.8217596612E+00, 5.6719760703E+00, 3.9116495974E-01, 3.4428848094E-01, 6.0754715588E-01],
	[1.2620000000E+04, 5.8248535830E+00, 5.6715021839E+00, 3.9165200317E-01, 3.4467481851E-01, 6.0769045054E-01],
	[1.2625000000E+04, 5.8279479225E+00, 5.6710285248E+00, 3.9213945926E-01, 3.4506139382E-01, 6.0783372197E-01],
	[1.2630000000E+04, 5.8310479694E+00, 5.6705624330E+00, 3.9262732820E-01, 3.4544825265E-01, 6.0797697015E-01],
	[1.2635000000E+04, 5.8341489321E+00, 5.6700972500E+00, 3.9311561018E-01, 3.4583535359E-01, 6.0812019506E-01],
	[1.2640000000E+04, 5.8372503159E+00, 5.6696322892E+00, 3.9360430537E-01, 3.4622269235E-01, 6.0826339669E-01],
	[1.2645000000E+04, 5.8403521209E+00, 5.6691675504E+00, 3.9409341397E-01, 3.4661026887E-01, 6.0840657504E-01],
	[1.2650000000E+04, 5.8434543469E+00, 5.6687030333E+00, 3.9458293617E-01, 3.4699808312E-01, 6.0854973007E-01],
	[1.2655000000E+04, 5.8465569938E+00, 5.6682387379E+00, 3.9507287213E-01, 3.4738613506E-01, 6.0869286179E-01],
	[1.2660000000E+04, 5.8496600615E+00, 5.6677746639E+00, 3.9556322206E-01, 3.4777442465E-01, 6.0883597018E-01],
	[1.2665000000E+04, 5.8527635499E+00, 5.6673108111E+00, 3.9605398614E-01, 3.4816295184E-01, 6.0897905522E-01],
	[1.2670000000E+04, 5.8558674588E+00, 5.6668471794E+00, 3.9654516455E-01, 3.4855171660E-01, 6.0912211690E-01],
	[1.2675000000E+04, 5.8589717882E+00, 5.6663837684E+00, 3.9703675748E-01, 3.4894071887E-01, 6.0926515520E-01],
	[1.2680000000E+04, 5.8620765380E+00, 5.6659205781E+00, 3.9752876512E-01, 3.4932995863E-01, 6.0940817012E-01],
	[1.2685000000E+04, 5.8651817080E+00, 5.6654576083E+00, 3.9802118764E-01, 3.4971943583E-01, 6.0955116165E-01],
	[1.2690000000E+04, 5.8682872982E+00, 5.6649948587E+00, 3.9851402524E-01, 3.5010915042E-01, 6.0969412976E-01],
	[1.2695000000E+04, 5.8713933084E+00, 5.6645323292E+00, 3.9900727809E-01, 3.5049910237E-01, 6.0983707444E-01],
	[1.2700000000E+04, 5.8744997385E+00, 5.6640700196E+00, 3.9950094640E-01, 3.5088929164E-01, 6.0997999568E-01],
	[1.2705000000E+04, 5.8776065884E+00, 5.6636079297E+00, 3.9999503033E-01, 3.5127971817E-01, 6.1012289348E-01],
	[1.2710000000E+04, 5.8807138580E+00, 5.6631460592E+00, 4.0048953008E-01, 3.5167038193E-01, 6.1026576780E-01],
	[1.2715000000E+04, 5.8838215473E+00, 5.6626844080E+00, 4.0098444584E-01, 3.5206128287E-01, 6.1040861865E-01],
	[1.2720000000E+04, 5.8869296560E+00, 5.6622229760E+00, 4.0147977778E-01, 3.5245242096E-01, 6.1055144601E-01],
	[1.2725000000E+04, 5.8900381841E+00, 5.6617617629E+00, 4.0197552609E-01, 3.5284379615E-01, 6.1069424986E-01],
	[1.2730000000E+04, 5.8931471314E+00, 5.6613007685E+00, 4.0247169097E-01, 3.5323540839E-01, 6.1083703019E-01],
	[1.2735000000E+04, 5.8962564979E+00, 5.6608399927E+00, 4.0296827259E-01, 3.5362725764E-01, 6.1097978700E-01],
	[1.2740000000E+04, 5.8993662835E+00, 5.6603794352E+00, 4.0346527114E-01, 3.5401934387E-01, 6.1112252025E-01],
	[1.2745000000E+04, 5.9024764880E+00, 5.6599190959E+00, 4.0396268680E-01, 3.5441166702E-01, 6.1126522996E-01],
	[1.2750000000E+04, 5.9055871114E+00, 5.6594589746E+00, 4.0446051977E-01, 3.5480422705E-01, 6.1140791609E-01],
	[1.2755000000E+04, 5.9086981535E+00, 5.6589990710E+00, 4.0495877022E-01, 3.5519702391E-01, 6.1155057864E-01],
	[1.2760000000E+04, 5.9118096142E+00, 5.6585393850E+00, 4.0545743835E-01, 3.5559005757E-01, 6.1169321760E-01],
	[1.2765000000E+04, 5.9149214934E+00, 5.6580799165E+00, 4.0595652434E-01, 3.5598332798E-01, 6.1183583294E-01],
	[1.2770000000E+04, 5.9180337911E+00, 5.6576206652E+00, 4.0645602837E-01, 3.5637683510E-01, 6.1197842467E-01],
	[1.2775000000E+04, 5.9211465070E+00, 5.6571616309E+00, 4.0695595062E-01, 3.5677057887E-01, 6.1212099276E-01],
	[1.2780000000E+04, 5.9242596411E+00, 5.6567028135E+00, 4.0745629130E-01, 3.5716455926E-01, 6.1226353721E-01],
	[1.2785000000E+04, 5.9273731934E+00, 5.6562442127E+00, 4.0795705057E-01, 3.5755877622E-01, 6.1240605800E-01],
	[1.2790000000E+04, 5.9304871635E+00, 5.6557858284E+00, 4.0845822864E-01, 3.5795322970E-01, 6.1254855511E-01],
	[1.2795000000E+04, 5.9336015516E+00, 5.6553276604E+00, 4.0895982567E-01, 3.5834791966E-01, 6.1269102855E-01],
	[1.2800000000E+04, 5.9367163574E+00, 5.6548697085E+00, 4.0946184186E-01, 3.5874284606E-01, 6.1283347828E-01],
	[1.2805000000E+04, 5.9398315809E+00, 5.6544119725E+00, 4.0996427740E-01, 3.5913800885E-01, 6.1297590431E-01],
	[1.2810000000E+04, 5.9429472220E+00, 5.6539544522E+00, 4.1046713246E-01, 3.5953340797E-01, 6.1311830661E-01],
	[1.2815000000E+04, 5.9460632804E+00, 5.6534971475E+00, 4.1097040725E-01, 3.5992904340E-01, 6.1326068518E-01],
	[1.2820000000E+04, 5.9491797562E+00, 5.6530400581E+00, 4.1147410193E-01, 3.6032491507E-01, 6.1340304000E-01],
	[1.2825000000E+04, 5.9522966493E+00, 5.6525831839E+00, 4.1197821670E-01, 3.6072102295E-01, 6.1354537106E-01],
	[1.2830000000E+04, 5.9554155913E+00, 5.6521286005E+00, 4.1248275174E-01, 3.6111738147E-01, 6.1368767835E-01],
	[1.2835000000E+04, 5.9585395006E+00, 5.6516800138E+00, 4.1298770724E-01, 3.6151401655E-01, 6.1382996186E-01],
	[1.2840000000E+04, 5.9616638309E+00, 5.6512316375E+00, 4.1349308338E-01, 3.6191088790E-01, 6.1397222157E-01],
	[1.2845000000E+04, 5.9647885821E+00, 5.6507834713E+00, 4.1399888035E-01, 3.6230799547E-01, 6.1411445747E-01],
	[1.2850000000E+04, 5.9679137540E+00, 5.6503355150E+00, 4.1450509834E-01, 3.6270533921E-01, 6.1425666955E-01],
	[1.2855000000E+04, 5.9710393466E+00, 5.6498877685E+00, 4.1501173753E-01, 3.6310291908E-01, 6.1439885780E-01],
	[1.2860000000E+04, 5.9741653597E+00, 5.6494402315E+00, 4.1551879811E-01, 3.6350073503E-01, 6.1454102220E-01],
	[1.2865000000E+04, 5.9772917932E+00, 5.6489929040E+00, 4.1602628026E-01, 3.6389878701E-01, 6.1468316275E-01],
	[1.2870000000E+04, 5.9804186471E+00, 5.6485457857E+00, 4.1653418417E-01, 3.6429707498E-01, 6.1482527942E-01],
	[1.2875000000E+04, 5.9835459213E+00, 5.6480988764E+00, 4.1704251002E-01, 3.6469559888E-01, 6.1496737221E-01],
	[1.2880000000E+04, 5.9866736155E+00, 5.6476521760E+00, 4.1755125801E-01, 3.6509435867E-01, 6.1510944111E-01],
	[1.2885000000E+04, 5.9898017297E+00, 5.6472056842E+00, 4.1806042831E-01, 3.6549335431E-01, 6.1525148610E-01],
	[1.2890000000E+04, 5.9929302639E+00, 5.6467594010E+00, 4.1857002111E-01, 3.6589258574E-01, 6.1539350718E-01],
	[1.2895000000E+04, 5.9960592179E+00, 5.6463133261E+00, 4.1908003660E-01, 3.6629205291E-01, 6.1553550432E-01],
	[1.2900000000E+04, 5.9991885915E+00, 5.6458674593E+00, 4.1959047497E-01, 3.6669175578E-01, 6.1567747752E-01],
	[1.2905000000E+04, 6.0023183847E+00, 5.6454218005E+00, 4.2010133639E-01, 3.6709169431E-01, 6.1581942677E-01],
	[1.2910000000E+04, 6.0054485974E+00, 5.6449763495E+00, 4.2061262106E-01, 3.6749186843E-01, 6.1596135205E-01],
	[1.2915000000E+04, 6.0085792295E+00, 5.6445311062E+00, 4.2112432916E-01, 3.6789227811E-01, 6.1610325336E-01],
	[1.2920000000E+04, 6.0117102809E+00, 5.6440860702E+00, 4.2163646088E-01, 3.6829292329E-01, 6.1624513067E-01],
	[1.2925000000E+04, 6.0148417514E+00, 5.6436412415E+00, 4.2214901641E-01, 3.6869380392E-01, 6.1638698398E-01],
	[1.2930000000E+04, 6.0179736410E+00, 5.6431966200E+00, 4.2266199592E-01, 3.6909491996E-01, 6.1652881328E-01],
	[1.2935000000E+04, 6.0211059495E+00, 5.6427522053E+00, 4.2317539961E-01, 3.6949627136E-01, 6.1667061855E-01],
	[1.2940000000E+04, 6.0242386768E+00, 5.6423079973E+00, 4.2368922766E-01, 3.6989785806E-01, 6.1681239979E-01],
	[1.2945000000E+04, 6.0273718229E+00, 5.6418639959E+00, 4.2420348025E-01, 3.7029968002E-01, 6.1695415698E-01],
	[1.2950000000E+04, 6.0305053877E+00, 5.6414202009E+00, 4.2471815758E-01, 3.7070173719E-01, 6.1709589011E-01],
	[1.2955000000E+04, 6.0336393709E+00, 5.6409766121E+00, 4.2523325983E-01, 3.7110402951E-01, 6.1723759916E-01],
	[1.2960000000E+04, 6.0367737726E+00, 5.6405332293E+00, 4.2574878719E-01, 3.7150655694E-01, 6.1737928414E-01],
	[1.2965000000E+04, 6.0399085926E+00, 5.6400900524E+00, 4.2626473983E-01, 3.7190931943E-01, 6.1752094501E-01],
	[1.2970000000E+04, 6.0430438308E+00, 5.6396470812E+00, 4.2678111796E-01, 3.7231231693E-01, 6.1766258179E-01],
	[1.2975000000E+04, 6.0461794871E+00, 5.6392043154E+00, 4.2729792174E-01, 3.7271554938E-01, 6.1780419444E-01],
	[1.2980000000E+04, 6.0493155614E+00, 5.6387617550E+00, 4.2781515138E-01, 3.7311901674E-01, 6.1794578296E-01],
	[1.2985000000E+04, 6.0524520536E+00, 5.6383193998E+00, 4.2833280705E-01, 3.7352271895E-01, 6.1808734734E-01],
	[1.2990000000E+04, 6.0555889636E+00, 5.6378772495E+00, 4.2885088894E-01, 3.7392665597E-01, 6.1822888757E-01],
	[1.2995000000E+04, 6.0587262912E+00, 5.6374353041E+00, 4.2936939724E-01, 3.7433082774E-01, 6.1837040364E-01],
	[1.3000000000E+04, 6.0618640365E+00, 5.6369935632E+00, 4.2988833214E-01, 3.7473523420E-01, 6.1851189553E-01],
	[1.3005000000E+04, 6.0650021992E+00, 5.6365520269E+00, 4.3040769381E-01, 3.7513987532E-01, 6.1865336323E-01],
	[1.3010000000E+04, 6.0681407792E+00, 5.6361106948E+00, 4.3092748245E-01, 3.7554475104E-01, 6.1879480674E-01],
	[1.3015000000E+04, 6.0712797766E+00, 5.6356695669E+00, 4.3144769824E-01, 3.7594986130E-01, 6.1893622604E-01],
	[1.3020000000E+04, 6.0744191911E+00, 5.6352286429E+00, 4.3196834137E-01, 3.7635520606E-01, 6.1907762111E-01],
	[1.3025000000E+04, 6.0775590226E+00, 5.6347879226E+00, 4.3248941202E-01, 3.7676078526E-01, 6.1921899196E-01],
	[1.3030000000E+04, 6.0806992711E+00, 5.6343474060E+00, 4.3301091038E-01, 3.7716659885E-01, 6.1936033856E-01],
	[1.3035000000E+04, 6.0838399365E+00, 5.6339070928E+00, 4.3353283664E-01, 3.7757264677E-01, 6.1950166090E-01],
	[1.3040000000E+04, 6.0869873341E+00, 5.6334743656E+00, 4.3405519098E-01, 3.7797898657E-01, 6.1964295901E-01],
	[1.3045000000E+04, 6.0901354211E+00, 5.6330421513E+00, 4.3457797359E-01, 3.7838556326E-01, 6.1978423290E-01],
	[1.3050000000E+04, 6.0932839288E+00, 5.6326101357E+00, 4.3510118465E-01, 3.7879237434E-01, 6.1992548254E-01],
	[1.3055000000E+04, 6.0964328573E+00, 5.6321783188E+00, 4.3562482436E-01, 3.7919941976E-01, 6.2006670792E-01],
	[1.3060000000E+04, 6.0995822063E+00, 5.6317467003E+00, 4.3614889289E-01, 3.7960669948E-01, 6.2020790901E-01],
	[1.3065000000E+04, 6.1027319759E+00, 5.6313152801E+00, 4.3667339044E-01, 3.8001421342E-01, 6.2034908581E-01],
	[1.3070000000E+04, 6.1058821658E+00, 5.6308840580E+00, 4.3719831718E-01, 3.8042196155E-01, 6.2049023828E-01],
	[1.3075000000E+04, 6.1090327761E+00, 5.6304530338E+00, 4.3772367331E-01, 3.8082994381E-01, 6.2063136642E-01],
	[1.3080000000E+04, 6.1121838065E+00, 5.6300222074E+00, 4.3824945901E-01, 3.8123816015E-01, 6.2077247019E-01],
	[1.3085000000E+04, 6.1153352569E+00, 5.6295915786E+00, 4.3877567447E-01, 3.8164661050E-01, 6.2091354959E-01],
	[1.3090000000E+04, 6.1184871274E+00, 5.6291611473E+00, 4.3930231987E-01, 3.8205529483E-01, 6.2105460459E-01],
	[1.3095000000E+04, 6.1216394177E+00, 5.6287309132E+00, 4.3982939541E-01, 3.8246421307E-01, 6.2119563518E-01],
	[1.3100000000E+04, 6.1247921278E+00, 5.6283008762E+00, 4.4035690126E-01, 3.8287336517E-01, 6.2133664133E-01],
	[1.3105000000E+04, 6.1279452575E+00, 5.6278710362E+00, 4.4088483761E-01, 3.8328275107E-01, 6.2147762302E-01],
	[1.3110000000E+04, 6.1310988068E+00, 5.6274413929E+00, 4.4141320466E-01, 3.8369237073E-01, 6.2161858025E-01],
	[1.3115000000E+04, 6.1342527755E+00, 5.6270119463E+00, 4.4194200257E-01, 3.8410222408E-01, 6.2175951298E-01],
	[1.3120000000E+04, 6.1374071635E+00, 5.6265826961E+00, 4.4247123155E-01, 3.8451231108E-01, 6.2190042120E-01],
	[1.3125000000E+04, 6.1405619708E+00, 5.6261536421E+00, 4.4300089178E-01, 3.8492263167E-01, 6.2204130489E-01],
	[1.3130000000E+04, 6.1437171973E+00, 5.6257247843E+00, 4.4353098344E-01, 3.8533318579E-01, 6.2218216403E-01],
	[1.3135000000E+04, 6.1468728427E+00, 5.6252961225E+00, 4.4406150673E-01, 3.8574397338E-01, 6.2232299860E-01],
	[1.3140000000E+04, 6.1500289071E+00, 5.6248676564E+00, 4.4459246182E-01, 3.8615499440E-01, 6.2246380859E-01],
	[1.3145000000E+04, 6.1531853903E+00, 5.6244393860E+00, 4.4512384890E-01, 3.8656624879E-01, 6.2260459397E-01],
	[1.3150000000E+04, 6.1563422923E+00, 5.6240113110E+00, 4.4565566816E-01, 3.8697773648E-01, 6.2274535473E-01],
	[1.3155000000E+04, 6.1594996128E+00, 5.6235834313E+00, 4.4618791979E-01, 3.8738945744E-01, 6.2288609085E-01],
	[1.3160000000E+04, 6.1626573519E+00, 5.6231557468E+00, 4.4672060397E-01, 3.8780141159E-01, 6.2302680231E-01],
	[1.3165000000E+04, 6.1658155094E+00, 5.6227282572E+00, 4.4725372089E-01, 3.8821359889E-01, 6.2316748909E-01],
	[1.3170000000E+04, 6.1689740851E+00, 5.6223009624E+00, 4.4778727073E-01, 3.8862601927E-01, 6.2330815117E-01],
	[1.3175000000E+04, 6.1721330791E+00, 5.6218738623E+00, 4.4832125369E-01, 3.8903867268E-01, 6.2344878853E-01],
	[1.3180000000E+04, 6.1752924912E+00, 5.6214469566E+00, 4.4885566994E-01, 3.8945155907E-01, 6.2358940117E-01],
	[1.3185000000E+04, 6.1784523212E+00, 5.6210202453E+00, 4.4939051968E-01, 3.8986467838E-01, 6.2372998904E-01],
	[1.3190000000E+04, 6.1816125692E+00, 5.6205937282E+00, 4.4992580309E-01, 3.9027803055E-01, 6.2387055215E-01],
	[1.3195000000E+04, 6.1847732349E+00, 5.6201674050E+00, 4.5046152035E-01, 3.9069161552E-01, 6.2401109047E-01],
	[1.3200000000E+04, 6.1879343184E+00, 5.6197412757E+00, 4.5099767166E-01, 3.9110543324E-01, 6.2415160397E-01],
	[1.3205000000E+04, 6.1910958194E+00, 5.6193153400E+00, 4.5153425720E-01, 3.9151948365E-01, 6.2429209266E-01],
	[1.3210000000E+04, 6.1942577379E+00, 5.6188895979E+00, 4.5207127715E-01, 3.9193376669E-01, 6.2443255650E-01],
	[1.3215000000E+04, 6.1974200738E+00, 5.6184640491E+00, 4.5260873171E-01, 3.9234828231E-01, 6.2457299547E-01],
	[1.3220000000E+04, 6.2005828269E+00, 5.6180386935E+00, 4.5314662105E-01, 3.9276303044E-01, 6.2471340957E-01],
	[1.3225000000E+04, 6.2037459972E+00, 5.6176135309E+00, 4.5368494537E-01, 3.9317801103E-01, 6.2485379876E-01],
	[1.3230000000E+04, 6.2069095846E+00, 5.6171885612E+00, 4.5422370486E-01, 3.9359322402E-01, 6.2499416304E-01],
	[1.3235000000E+04, 6.2100735889E+00, 5.6167637842E+00, 4.5476289969E-01, 3.9400866936E-01, 6.2513450239E-01],
	[1.3240000000E+04, 6.2132380101E+00, 5.6163391997E+00, 4.5530253006E-01, 3.9442434698E-01, 6.2527481678E-01],
	[1.3245000000E+04, 6.2164028481E+00, 5.6159148077E+00, 4.5584259615E-01, 3.9484025682E-01, 6.2541510620E-01],
	[1.3250000000E+04, 6.2195750205E+00, 5.6154980660E+00, 4.5638309814E-01, 3.9525646372E-01, 6.2555537063E-01],
	[1.3255000000E+04, 6.2227476879E+00, 5.6150815923E+00, 4.5692403623E-01, 3.9567290365E-01, 6.2569561006E-01],
	[1.3260000000E+04, 6.2259207762E+00, 5.6146653065E+00, 4.5746541061E-01, 3.9608957586E-01, 6.2583582446E-01],
	[1.3265000000E+04, 6.2290942854E+00, 5.6142492085E+00, 4.5800722145E-01, 3.9650648029E-01, 6.2597601382E-01],
	[1.3270000000E+04, 6.2322682154E+00, 5.6138332981E+00, 4.5854946894E-01, 3.9692361687E-01, 6.2611617811E-01],
	[1.3275000000E+04, 6.2354425659E+00, 5.6134175752E+00, 4.5909215328E-01, 3.9734098556E-01, 6.2625631734E-01],
	[1.3280000000E+04, 6.2386173370E+00, 5.6130020396E+00, 4.5963527464E-01, 3.9775858629E-01, 6.2639643146E-01],
	[1.3285000000E+04, 6.2417925285E+00, 5.6125866912E+00, 4.6017883321E-01, 3.9817641901E-01, 6.2653652047E-01],
	[1.3290000000E+04, 6.2449681403E+00, 5.6121715298E+00, 4.6072282919E-01, 3.9859448365E-01, 6.2667658435E-01],
	[1.3295000000E+04, 6.2481441723E+00, 5.6117565553E+00, 4.6126726275E-01, 3.9901278015E-01, 6.2681662309E-01],
	[1.3300000000E+04, 6.2513206245E+00, 5.6113417674E+00, 4.6181213409E-01, 3.9943130845E-01, 6.2695663665E-01],
	[1.3305000000E+04, 6.2544974967E+00, 5.6109271661E+00, 4.6235744339E-01, 3.9985006850E-01, 6.2709662503E-01],
	[1.3310000000E+04, 6.2576747887E+00, 5.6105127512E+00, 4.6290319083E-01, 4.0026906024E-01, 6.2723658822E-01],
	[1.3315000000E+04, 6.2608525006E+00, 5.6100985226E+00, 4.6344937661E-01, 4.0068828359E-01, 6.2737652618E-01],
	[1.3320000000E+04, 6.2640306322E+00, 5.6096844800E+00, 4.6399600091E-01, 4.0110773851E-01, 6.2751643891E-01],
	[1.3325000000E+04, 6.2672091834E+00, 5.6092706233E+00, 4.6454306391E-01, 4.0152742494E-01, 6.2765632638E-01],
	[1.3330000000E+04, 6.2703881542E+00, 5.6088569525E+00, 4.6509056581E-01, 4.0194734280E-01, 6.2779618858E-01],
	[1.3335000000E+04, 6.2735675443E+00, 5.6084434672E+00, 4.6563850679E-01, 4.0236749205E-01, 6.2793602550E-01],
	[1.3340000000E+04, 6.2767473537E+00, 5.6080301675E+00, 4.6618688703E-01, 4.0278787262E-01, 6.2807583710E-01],
	[1.3345000000E+04, 6.2799275823E+00, 5.6076170530E+00, 4.6673570673E-01, 4.0320848444E-01, 6.2821562339E-01],
	[1.3350000000E+04, 6.2831082300E+00, 5.6072041237E+00, 4.6728496607E-01, 4.0362932747E-01, 6.2835538434E-01],
	[1.3355000000E+04, 6.2862892967E+00, 5.6067913795E+00, 4.6783466523E-01, 4.0405040163E-01, 6.2849511993E-01],
	[1.3360000000E+04, 6.2894707823E+00, 5.6063788201E+00, 4.6838480441E-01, 4.0447170686E-01, 6.2863483014E-01],
	[1.3365000000E+04, 6.2926526866E+00, 5.6059664454E+00, 4.6893538379E-01, 4.0489324311E-01, 6.2877451497E-01],
	[1.3370000000E+04, 6.2958350097E+00, 5.6055542553E+00, 4.6948640356E-01, 4.0531501031E-01, 6.2891417438E-01],
	[1.3375000000E+04, 6.2990177514E+00, 5.6051422495E+00, 4.7003786390E-01, 4.0573700839E-01, 6.2905380837E-01],
	[1.3380000000E+04, 6.3022009115E+00, 5.6047304281E+00, 4.7058976500E-01, 4.0615923731E-01, 6.2919341692E-01],
	[1.3385000000E+04, 6.3053844900E+00, 5.6043187907E+00, 4.7114210704E-01, 4.0658169698E-01, 6.2933300001E-01],
	[1.3390000000E+04, 6.3085684868E+00, 5.6039073373E+00, 4.7169489022E-01, 4.0700438736E-01, 6.2947255762E-01],
	[1.3395000000E+04, 6.3117529018E+00, 5.6034960677E+00, 4.7224811472E-01, 4.0742730838E-01, 6.2961208974E-01],
	[1.3400000000E+04, 6.3149377349E+00, 5.6030849818E+00, 4.7280178073E-01, 4.0785045998E-01, 6.2975159635E-01],
	[1.3405000000E+04, 6.3181229859E+00, 5.6026740794E+00, 4.7335588844E-01, 4.0827384208E-01, 6.2989107743E-01],
	[1.3410000000E+04, 6.3213086549E+00, 5.6022633603E+00, 4.7391043802E-01, 4.0869745464E-01, 6.3003053297E-01],
	[1.3415000000E+04, 6.3244947416E+00, 5.6018528244E+00, 4.7446542967E-01, 4.0912129759E-01, 6.3016996295E-01],
	[1.3420000000E+04, 6.3276812460E+00, 5.6014424716E+00, 4.7502086358E-01, 4.0954537085E-01, 6.3030936735E-01],
	[1.3425000000E+04, 6.3308681679E+00, 5.6010323016E+00, 4.7557673993E-01, 4.0996967438E-01, 6.3044874615E-01],
	[1.3430000000E+04, 6.3340555073E+00, 5.6006223145E+00, 4.7613305890E-01, 4.1039420810E-01, 6.3058809935E-01],
	[1.3435000000E+04, 6.3372432642E+00, 5.6002125099E+00, 4.7668982069E-01, 4.1081897196E-01, 6.3072742692E-01],
	[1.3440000000E+04, 6.3404314382E+00, 5.5998028878E+00, 4.7724702548E-01, 4.1124396588E-01, 6.3086672884E-01],
	[1.3445000000E+04, 6.3436200295E+00, 5.5993934480E+00, 4.7780467347E-01, 4.1166918981E-01, 6.3100600511E-01],
	[1.3450000000E+04, 6.3468090378E+00, 5.5989841903E+00, 4.7836276482E-01, 4.1209464368E-01, 6.3114525570E-01],
	[1.3455000000E+04, 6.3499984631E+00, 5.5985751147E+00, 4.7892129974E-01, 4.1252032742E-01, 6.3128448059E-01],
	[1.3460000000E+04, 6.3531908514E+00, 5.5981687607E+00, 4.7948027841E-01, 4.1294626554E-01, 6.3142367977E-01],
	[1.3465000000E+04, 6.3563885161E+00, 5.5977674303E+00, 4.8003970102E-01, 4.1337248046E-01, 6.3156285323E-01],
	[1.3470000000E+04, 6.3595866021E+00, 5.5973662777E+00, 4.8059956775E-01, 4.1379892529E-01, 6.3170200095E-01],
	[1.3475000000E+04, 6.3627851095E+00, 5.5969653028E+00, 4.8115987879E-01, 4.1422559999E-01, 6.3184112290E-01],
	[1.3480000000E+04, 6.3659840379E+00, 5.5965645052E+00, 4.8172063432E-01, 4.1465250448E-01, 6.3198021909E-01],
	[1.3485000000E+04, 6.3691833875E+00, 5.5961638850E+00, 4.8228183454E-01, 4.1507963870E-01, 6.3211928948E-01],
	[1.3490000000E+04, 6.3723831580E+00, 5.5957634420E+00, 4.8284347963E-01, 4.1550700258E-01, 6.3225833406E-01],
	[1.3495000000E+04, 6.3755833493E+00, 5.5953631760E+00, 4.8340556978E-01, 4.1593459606E-01, 6.3239735282E-01],
	[1.3500000000E+04, 6.3787839615E+00, 5.5949630869E+00, 4.8396810517E-01, 4.1636241908E-01, 6.3253634573E-01],
	[1.3505000000E+04, 6.3819849942E+00, 5.5945631746E+00, 4.8453108600E-01, 4.1679047156E-01, 6.3267531279E-01],
	[1.3510000000E+04, 6.3851864476E+00, 5.5941634388E+00, 4.8509451244E-01, 4.1721875345E-01, 6.3281425398E-01],
	[1.3515000000E+04, 6.3883883213E+00, 5.5937638795E+00, 4.8565838469E-01, 4.1764726467E-01, 6.3295316928E-01],
	[1.3520000000E+04, 6.3915906155E+00, 5.5933644965E+00, 4.8622270293E-01, 4.1807600516E-01, 6.3309205868E-01],
	[1.3525000000E+04, 6.3947933299E+00, 5.5929652897E+00, 4.8678746735E-01, 4.1850497486E-01, 6.3323092215E-01],
	[1.3530000000E+04, 6.3979964644E+00, 5.5925662590E+00, 4.8735267814E-01, 4.1893417369E-01, 6.3336975969E-01],
	[1.3535000000E+04, 6.4012000191E+00, 5.5921674041E+00, 4.8791833548E-01, 4.1936360159E-01, 6.3350857128E-01],
	[1.3540000000E+04, 6.4044039936E+00, 5.5917687249E+00, 4.8848443956E-01, 4.1979325850E-01, 6.3364735689E-01],
	[1.3545000000E+04, 6.4076083880E+00, 5.5913702214E+00, 4.8905099057E-01, 4.2022314435E-01, 6.3378611653E-01],
	[1.3550000000E+04, 6.4108132022E+00, 5.5909718933E+00, 4.8961798869E-01, 4.2065325907E-01, 6.3392485016E-01],
	[1.3555000000E+04, 6.4140184360E+00, 5.5905737405E+00, 4.9018543412E-01, 4.2108360259E-01, 6.3406355777E-01],
	[1.3560000000E+04, 6.4172240894E+00, 5.5901757630E+00, 4.9075332703E-01, 4.2151417484E-01, 6.3420223936E-01],
	[1.3565000000E+04, 6.4204301623E+00, 5.5897779604E+00, 4.9132166762E-01, 4.2194497577E-01, 6.3434089490E-01],
	[1.3570000000E+04, 6.4236366545E+00, 5.5893803327E+00, 4.9189045608E-01, 4.2237600530E-01, 6.3447952437E-01],
	[1.3575000000E+04, 6.4268435659E+00, 5.5889828798E+00, 4.9245969258E-01, 4.2280726336E-01, 6.3461812776E-01],
	[1.3580000000E+04, 6.4300508965E+00, 5.5885856016E+00, 4.9302937732E-01, 4.2323874989E-01, 6.3475670507E-01],
	[1.3585000000E+04, 6.4332586462E+00, 5.5881884977E+00, 4.9359951048E-01, 4.2367046482E-01, 6.3489525626E-01],
	[1.3590000000E+04, 6.4364668148E+00, 5.5877915682E+00, 4.9417009226E-01, 4.2410240807E-01, 6.3503378132E-01],
	[1.3595000000E+04, 6.4396754023E+00, 5.5873948129E+00, 4.9474112283E-01, 4.2453457959E-01, 6.3517228024E-01],
	[1.3600000000E+04, 6.4428844085E+00, 5.5869982317E+00, 4.9531260239E-01, 4.2496697930E-01, 6.3531075301E-01],
	[1.3605000000E+04, 6.4460938334E+00, 5.5866018243E+00, 4.9588453112E-01, 4.2539960714E-01, 6.3544919960E-01],
	[1.3610000000E+04, 6.4493036769E+00, 5.5862055908E+00, 4.9645690922E-01, 4.2583246303E-01, 6.3558762001E-01],
	[1.3615000000E+04, 6.4525139388E+00, 5.5858095308E+00, 4.9702973685E-01, 4.2626554691E-01, 6.3572601421E-01],
	[1.3620000000E+04, 6.4557246191E+00, 5.5854136443E+00, 4.9760301423E-01, 4.2669885871E-01, 6.3586438220E-01],
	[1.3625000000E+04, 6.4589357176E+00, 5.5850179312E+00, 4.9817674152E-01, 4.2713239836E-01, 6.3600272395E-01],
	[1.3630000000E+04, 6.4621472343E+00, 5.5846223913E+00, 4.9875091892E-01, 4.2756616578E-01, 6.3614103945E-01],
	[1.3635000000E+04, 6.4653591691E+00, 5.5842270245E+00, 4.9932554662E-01, 4.2800016092E-01, 6.3627932869E-01],
	[1.3640000000E+04, 6.4685715218E+00, 5.5838318306E+00, 4.9990062480E-01, 4.2843438370E-01, 6.3641759165E-01],
	[1.3645000000E+04, 6.4717842924E+00, 5.5834368095E+00, 5.0047615365E-01, 4.2886883405E-01, 6.3655582831E-01],
	[1.3650000000E+04, 6.4749974808E+00, 5.5830419610E+00, 5.0105213336E-01, 4.2930351190E-01, 6.3669403866E-01],
	[1.3655000000E+04, 6.4782110868E+00, 5.5826472851E+00, 5.0162856411E-01, 4.2973841718E-01, 6.3683222269E-01],
	[1.3660000000E+04, 6.4814251104E+00, 5.5822527815E+00, 5.0220544610E-01, 4.3017354982E-01, 6.3697038038E-01],
	[1.3665000000E+04, 6.4846395515E+00, 5.5818584502E+00, 5.0278277950E-01, 4.3060890975E-01, 6.3710851171E-01],
	[1.3670000000E+04, 6.4878544099E+00, 5.5814642909E+00, 5.0336056451E-01, 4.3104449690E-01, 6.3724661667E-01],
	[1.3675000000E+04, 6.4910697791E+00, 5.5810703901E+00, 5.0393880131E-01, 4.3148031213E-01, 6.3738469525E-01],
	[1.3680000000E+04, 6.4942932934E+00, 5.5806838063E+00, 5.0451749009E-01, 4.3191643142E-01, 6.3752274742E-01],
	[1.3685000000E+04, 6.4975172296E+00, 5.5802973905E+00, 5.0509663104E-01, 4.3235277798E-01, 6.3766077318E-01],
	[1.3690000000E+04, 6.5007415877E+00, 5.5799111426E+00, 5.0567622435E-01, 4.3278935173E-01, 6.3779877251E-01],
	[1.3695000000E+04, 6.5039663676E+00, 5.5795250625E+00, 5.0625772191E-01, 4.3322721570E-01, 6.3793674540E-01],
	[1.3700000000E+04, 6.5071915692E+00, 5.5791391500E+00, 5.0684204591E-01, 4.3366704391E-01, 6.3807469182E-01],
	[1.3705000000E+04, 6.5104171924E+00, 5.5787534050E+00, 5.0742683023E-01, 4.3410710298E-01, 6.3821261177E-01],
	[1.3710000000E+04, 6.5136432370E+00, 5.5783678274E+00, 5.0801207506E-01, 4.3454739283E-01, 6.3835050523E-01],
	[1.3715000000E+04, 6.5168697030E+00, 5.5779824169E+00, 5.0859778061E-01, 4.3498791338E-01, 6.3848837219E-01],
	[1.3720000000E+04, 6.5200965903E+00, 5.5775971736E+00, 5.0918394707E-01, 4.3542866458E-01, 6.3862621262E-01],
	[1.3725000000E+04, 6.5233238988E+00, 5.5772120973E+00, 5.0977057462E-01, 4.3586964634E-01, 6.3876402653E-01],
	[1.3730000000E+04, 6.5265516284E+00, 5.5768271878E+00, 5.1035766347E-01, 4.3631085860E-01, 6.3890181388E-01],
	[1.3735000000E+04, 6.5297797789E+00, 5.5764424449E+00, 5.1094521380E-01, 4.3675230128E-01, 6.3903957467E-01],
	[1.3740000000E+04, 6.5330083504E+00, 5.5760578687E+00, 5.1153322582E-01, 4.3719397431E-01, 6.3917730889E-01],
	[1.3745000000E+04, 6.5362373426E+00, 5.5756734588E+00, 5.1212169971E-01, 4.3763587761E-01, 6.3931501651E-01],
	[1.3750000000E+04, 6.5394667555E+00, 5.5752892153E+00, 5.1271063567E-01, 4.3807801112E-01, 6.3945269752E-01],
	[1.3755000000E+04, 6.5426965891E+00, 5.5749051379E+00, 5.1330003389E-01, 4.3852037476E-01, 6.3959035191E-01],
	[1.3760000000E+04, 6.5459268431E+00, 5.5745212266E+00, 5.1388989457E-01, 4.3896296846E-01, 6.3972797967E-01],
	[1.3765000000E+04, 6.5491575175E+00, 5.5741374812E+00, 5.1448021791E-01, 4.3940579215E-01, 6.3986558078E-01],
	[1.3770000000E+04, 6.5523886122E+00, 5.5737539015E+00, 5.1507100408E-01, 4.3984884575E-01, 6.4000315522E-01],
	[1.3775000000E+04, 6.5556201271E+00, 5.5733704875E+00, 5.1566225330E-01, 4.4029212918E-01, 6.4014070299E-01],
	[1.3780000000E+04, 6.5588520622E+00, 5.5729872389E+00, 5.1625396575E-01, 4.4073564238E-01, 6.4027822406E-01],
	[1.3785000000E+04, 6.5620844172E+00, 5.5726041558E+00, 5.1684614163E-01, 4.4117938527E-01, 6.4041571842E-01],
	[1.3790000000E+04, 6.5653171921E+00, 5.5722212379E+00, 5.1743878112E-01, 4.4162335778E-01, 6.4055318606E-01],
	[1.3795000000E+04, 6.5685503869E+00, 5.5718384851E+00, 5.1803188444E-01, 4.4206755983E-01, 6.4069062696E-01],
	[1.3800000000E+04, 6.5717840013E+00, 5.5714558972E+00, 5.1862545176E-01, 4.4251199135E-01, 6.4082804112E-01],
	[1.3805000000E+04, 6.5750180354E+00, 5.5710734743E+00, 5.1921948328E-01, 4.4295665227E-01, 6.4096542851E-01],
	[1.3810000000E+04, 6.5782524890E+00, 5.5706912160E+00, 5.1981397921E-01, 4.4340154250E-01, 6.4110278912E-01],
	[1.3815000000E+04, 6.5814873620E+00, 5.5703091224E+00, 5.2040893972E-01, 4.4384666198E-01, 6.4124012294E-01],
	[1.3820000000E+04, 6.5847226544E+00, 5.5699271932E+00, 5.2100436502E-01, 4.4429201062E-01, 6.4137742995E-01],
	[1.3825000000E+04, 6.5879583659E+00, 5.5695454283E+00, 5.2160025530E-01, 4.4473758837E-01, 6.4151471014E-01],
	[1.3830000000E+04, 6.5911944966E+00, 5.5691638276E+00, 5.2219661076E-01, 4.4518339513E-01, 6.4165196350E-01],
	[1.3835000000E+04, 6.5944310463E+00, 5.5687823910E+00, 5.2279343158E-01, 4.4562943084E-01, 6.4178919001E-01],
	[1.3840000000E+04, 6.5976680150E+00, 5.5684011183E+00, 5.2339071796E-01, 4.4607569541E-01, 6.4192638965E-01],
	[1.3845000000E+04, 6.6009054025E+00, 5.5680200095E+00, 5.2398847010E-01, 4.4652218878E-01, 6.4206356242E-01],
	[1.3850000000E+04, 6.6041432087E+00, 5.5676390643E+00, 5.2458668819E-01, 4.4696891087E-01, 6.4220070829E-01],
	[1.3855000000E+04, 6.6073814336E+00, 5.5672582826E+00, 5.2518537243E-01, 4.4741586160E-01, 6.4233782727E-01],
	[1.3860000000E+04, 6.6106200770E+00, 5.5668776644E+00, 5.2578452300E-01, 4.4786304089E-01, 6.4247491932E-01],
	[1.3865000000E+04, 6.6138591389E+00, 5.5664972095E+00, 5.2638414011E-01, 4.4831044867E-01, 6.4261198444E-01],
	[1.3870000000E+04, 6.6170986191E+00, 5.5661169177E+00, 5.2698422395E-01, 4.4875808487E-01, 6.4274902262E-01],
	[1.3875000000E+04, 6.6203385176E+00, 5.5657367890E+00, 5.2758477470E-01, 4.4920594940E-01, 6.4288603384E-01],
	[1.3880000000E+04, 6.6235788342E+00, 5.5653568232E+00, 5.2818579257E-01, 4.4965404219E-01, 6.4302301808E-01],
	[1.3885000000E+04, 6.6268195689E+00, 5.5649770201E+00, 5.2878727775E-01, 4.5010236317E-01, 6.4315997533E-01],
	[1.3890000000E+04, 6.6300607215E+00, 5.5645973797E+00, 5.2938923044E-01, 4.5055091225E-01, 6.4329690559E-01],
	[1.3895000000E+04, 6.6333022921E+00, 5.5642179018E+00, 5.2999165082E-01, 4.5099968936E-01, 6.4343380883E-01],
	[1.3900000000E+04, 6.6365523784E+00, 5.5638455453E+00, 5.3059453910E-01, 4.5144877770E-01, 6.4357068504E-01],
	[1.3905000000E+04, 6.6398030328E+00, 5.5634734724E+00, 5.3119789546E-01, 4.5189809569E-01, 6.4370753422E-01],
	[1.3910000000E+04, 6.6430541098E+00, 5.5631015582E+00, 5.3180172011E-01, 4.5234764176E-01, 6.4384435633E-01],
	[1.3915000000E+04, 6.6463056095E+00, 5.5627298025E+00, 5.3240601323E-01, 4.5279741582E-01, 6.4398115138E-01],
	[1.3920000000E+04, 6.6495575316E+00, 5.5623582051E+00, 5.3301077502E-01, 4.5324741780E-01, 6.4411791935E-01],
	[1.3925000000E+04, 6.6528098761E+00, 5.5619867661E+00, 5.3361600567E-01, 4.5369764761E-01, 6.4425466022E-01],
	[1.3930000000E+04, 6.6560626429E+00, 5.5616154852E+00, 5.3422170538E-01, 4.5414810520E-01, 6.4439137398E-01],
	[1.3935000000E+04, 6.6593158319E+00, 5.5612443622E+00, 5.3482787435E-01, 4.5459879046E-01, 6.4452806062E-01],
	[1.3940000000E+04, 6.6625694430E+00, 5.5608733972E+00, 5.3543451276E-01, 4.5504970334E-01, 6.4466472013E-01],
	[1.3945000000E+04, 6.6658234761E+00, 5.5605025900E+00, 5.3604162081E-01, 4.5550084374E-01, 6.4480135248E-01],
	[1.3950000000E+04, 6.6690779311E+00, 5.5601319403E+00, 5.3664919870E-01, 4.5595221159E-01, 6.4493795768E-01],
	[1.3955000000E+04, 6.6723328079E+00, 5.5597614482E+00, 5.3725724662E-01, 4.5640380682E-01, 6.4507453570E-01],
	[1.3960000000E+04, 6.6755881065E+00, 5.5593911135E+00, 5.3786576476E-01, 4.5685562934E-01, 6.4521108653E-01],
	[1.3965000000E+04, 6.6788438266E+00, 5.5590209361E+00, 5.3847475333E-01, 4.5730767907E-01, 6.4534761016E-01],
	[1.3970000000E+04, 6.6820999682E+00, 5.5586509158E+00, 5.3908421250E-01, 4.5775995594E-01, 6.4548410657E-01],
	[1.3975000000E+04, 6.6853565313E+00, 5.5582810526E+00, 5.3969414249E-01, 4.5821245987E-01, 6.4562057576E-01],
	[1.3980000000E+04, 6.6886135157E+00, 5.5579113462E+00, 5.4030454347E-01, 4.5866519078E-01, 6.4575701771E-01],
	[1.3985000000E+04, 6.6918709213E+00, 5.5575417967E+00, 5.4091541565E-01, 4.5911814858E-01, 6.4589343240E-01],
	[1.3990000000E+04, 6.6951287481E+00, 5.5571724037E+00, 5.4152675923E-01, 4.5957133321E-01, 6.4602981982E-01],
	[1.3995000000E+04, 6.6983869958E+00, 5.5568031674E+00, 5.4213857439E-01, 4.6002474457E-01, 6.4616617997E-01],
	[1.4000000000E+04, 6.7016456646E+00, 5.5564340874E+00, 5.4275086133E-01, 4.6047838259E-01, 6.4630251282E-01],
	[1.4005000000E+04, 6.7049047541E+00, 5.5560651637E+00, 5.4336362024E-01, 4.6093224719E-01, 6.4643881836E-01],
	[1.4010000000E+04, 6.7081642645E+00, 5.5556963962E+00, 5.4397685132E-01, 4.6138633829E-01, 6.4657509659E-01],
	[1.4015000000E+04, 6.7114241954E+00, 5.5553277848E+00, 5.4459055477E-01, 4.6184065581E-01, 6.4671134749E-01],
	[1.4020000000E+04, 6.7146845470E+00, 5.5549593293E+00, 5.4520473077E-01, 4.6229519967E-01, 6.4684757104E-01],
	[1.4025000000E+04, 6.7179453189E+00, 5.5545910295E+00, 5.4581937953E-01, 4.6274996979E-01, 6.4698376723E-01],
	[1.4030000000E+04, 6.7212065113E+00, 5.5542228855E+00, 5.4643450123E-01, 4.6320496609E-01, 6.4711993605E-01],
	[1.4035000000E+04, 6.7244681239E+00, 5.5538548970E+00, 5.4705009608E-01, 4.6366018848E-01, 6.4725607749E-01],
	[1.4040000000E+04, 6.7277301567E+00, 5.5534870640E+00, 5.4766616426E-01, 4.6411563689E-01, 6.4739219154E-01],
	[1.4045000000E+04, 6.7309926096E+00, 5.5531193863E+00, 5.4828270597E-01, 4.6457131123E-01, 6.4752827818E-01],
	[1.4050000000E+04, 6.7342554824E+00, 5.5527518638E+00, 5.4889972140E-01, 4.6502721143E-01, 6.4766433739E-01],
	[1.4055000000E+04, 6.7375187752E+00, 5.5523844963E+00, 5.4951721076E-01, 4.6548333740E-01, 6.4780036917E-01],
	[1.4060000000E+04, 6.7407824877E+00, 5.5520172838E+00, 5.5013517423E-01, 4.6593968906E-01, 6.4793637351E-01],
	[1.4065000000E+04, 6.7440466199E+00, 5.5516502262E+00, 5.5075361201E-01, 4.6639626633E-01, 6.4807235038E-01],
	[1.4070000000E+04, 6.7473111718E+00, 5.5512833233E+00, 5.5137252429E-01, 4.6685306913E-01, 6.4820829979E-01],
	[1.4075000000E+04, 6.7505761431E+00, 5.5509165749E+00, 5.5199191128E-01, 4.6731009737E-01, 6.4834422171E-01],
	[1.4080000000E+04, 6.7538415338E+00, 5.5505499811E+00, 5.5261177315E-01, 4.6776735097E-01, 6.4848011614E-01],
	[1.4085000000E+04, 6.7571073439E+00, 5.5501835416E+00, 5.5323211011E-01, 4.6822482986E-01, 6.4861598303E-01],
	[1.4090000000E+04, 6.7603735732E+00, 5.5498172563E+00, 5.5385292235E-01, 4.6868253394E-01, 6.4875182234E-01],
	[1.4095000000E+04, 6.7636402216E+00, 5.5494511252E+00, 5.5447421007E-01, 4.6914046314E-01, 6.4888763407E-01],
	[1.4100000000E+04, 6.7669072890E+00, 5.5490851481E+00, 5.5509597347E-01, 4.6959861738E-01, 6.4902341819E-01],
	[1.4105000000E+04, 6.7701747754E+00, 5.5487193248E+00, 5.5571821272E-01, 4.7005699656E-01, 6.4915917468E-01],
	[1.4110000000E+04, 6.7734426806E+00, 5.5483536553E+00, 5.5634092804E-01, 4.7051560061E-01, 6.4929490352E-01],
	[1.4115000000E+04, 6.7767110046E+00, 5.5479881394E+00, 5.5696411962E-01, 4.7097442944E-01, 6.4943060470E-01],
	[1.4120000000E+04, 6.7799818620E+00, 5.5476244704E+00, 5.5758778764E-01, 4.7143350543E-01, 6.4956627819E-01],
	[1.4125000000E+04, 6.7832596951E+00, 5.5472661999E+00, 5.5821193231E-01, 4.7189287580E-01, 6.4970192398E-01],
	[1.4130000000E+04, 6.7865379519E+00, 5.5469080794E+00, 5.5883655382E-01, 4.7235247099E-01, 6.4983754206E-01],
	[1.4135000000E+04, 6.7898166323E+00, 5.5465501087E+00, 5.5946165236E-01, 4.7281229092E-01, 6.4997313239E-01],
	[1.4140000000E+04, 6.7930957364E+00, 5.5461922877E+00, 5.6008722813E-01, 4.7327233552E-01, 6.5010869496E-01],
	[1.4145000000E+04, 6.7963752639E+00, 5.5458346163E+00, 5.6071328133E-01, 4.7373260469E-01, 6.5024422976E-01],
	[1.4150000000E+04, 6.7996552148E+00, 5.5454770944E+00, 5.6133981215E-01, 4.7419309835E-01, 6.5037973677E-01],
	[1.4155000000E+04, 6.8029355890E+00, 5.5451197217E+00, 5.6196682077E-01, 4.7465381643E-01, 6.5051521596E-01],
	[1.4160000000E+04, 6.8062163863E+00, 5.5447624984E+00, 5.6259430741E-01, 4.7511475882E-01, 6.5065066732E-01],
	[1.4165000000E+04, 6.8094976068E+00, 5.5444054241E+00, 5.6322227225E-01, 4.7557592546E-01, 6.5078609084E-01],
	[1.4170000000E+04, 6.8127792503E+00, 5.5440484988E+00, 5.6385071549E-01, 4.7603731625E-01, 6.5092148649E-01],
	[1.4175000000E+04, 6.8160613167E+00, 5.5436917224E+00, 5.6447963732E-01, 4.7649893111E-01, 6.5105685425E-01],
	[1.4180000000E+04, 6.8193438059E+00, 5.5433350948E+00, 5.6510903793E-01, 4.7696076996E-01, 6.5119219411E-01],
	[1.4185000000E+04, 6.8226267178E+00, 5.5429786159E+00, 5.6573891753E-01, 4.7742283272E-01, 6.5132750605E-01],
	[1.4190000000E+04, 6.8259100523E+00, 5.5426222855E+00, 5.6636927631E-01, 4.7788511929E-01, 6.5146279005E-01],
	[1.4195000000E+04, 6.8291938094E+00, 5.5422661035E+00, 5.6700011446E-01, 4.7834762959E-01, 6.5159804609E-01],
	[1.4200000000E+04, 6.8324779889E+00, 5.5419100698E+00, 5.6763143218E-01, 4.7881036354E-01, 6.5173327416E-01],
	[1.4205000000E+04, 6.8357625907E+00, 5.5415541844E+00, 5.6826322965E-01, 4.7927332105E-01, 6.5186847424E-01],
	[1.4210000000E+04, 6.8390476148E+00, 5.5411984470E+00, 5.6889550709E-01, 4.7973650204E-01, 6.5200364630E-01],
	[1.4215000000E+04, 6.8423330610E+00, 5.5408428576E+00, 5.6952826467E-01, 4.8019990642E-01, 6.5213879034E-01],
	[1.4220000000E+04, 6.8456189293E+00, 5.5404874161E+00, 5.7016150260E-01, 4.8066353411E-01, 6.5227390633E-01],
	[1.4225000000E+04, 6.8489052196E+00, 5.5401321223E+00, 5.7079522108E-01, 4.8112738501E-01, 6.5240899426E-01],
	[1.4230000000E+04, 6.8521919317E+00, 5.5397769761E+00, 5.7142942029E-01, 4.8159145905E-01, 6.5254405411E-01],
	[1.4235000000E+04, 6.8554790656E+00, 5.5394219775E+00, 5.7206410043E-01, 4.8205575614E-01, 6.5267908586E-01],
	[1.4240000000E+04, 6.8587666211E+00, 5.5390671263E+00, 5.7269926170E-01, 4.8252027618E-01, 6.5281408949E-01],
	[1.4245000000E+04, 6.8620545983E+00, 5.5387124223E+00, 5.7333490428E-01, 4.8298501911E-01, 6.5294906499E-01],
	[1.4250000000E+04, 6.8653429970E+00, 5.5383578656E+00, 5.7397102839E-01, 4.8344998481E-01, 6.5308401233E-01],
	[1.4255000000E+04, 6.8686318170E+00, 5.5380034559E+00, 5.7460763420E-01, 4.8391517322E-01, 6.5321893151E-01],
	[1.4260000000E+04, 6.8719210584E+00, 5.5376491931E+00, 5.7524472193E-01, 4.8438058425E-01, 6.5335382250E-01],
	[1.4265000000E+04, 6.8752107209E+00, 5.5372950773E+00, 5.7588229175E-01, 4.8484621780E-01, 6.5348868528E-01],
	[1.4270000000E+04, 6.8785008046E+00, 5.5369411081E+00, 5.7652034387E-01, 4.8531207379E-01, 6.5362351985E-01],
	[1.4275000000E+04, 6.8817913093E+00, 5.5365872856E+00, 5.7715887848E-01, 4.8577815214E-01, 6.5375832617E-01],
	[1.4280000000E+04, 6.8850822350E+00, 5.5362336095E+00, 5.7779789577E-01, 4.8624445275E-01, 6.5389310424E-01],
	[1.4285000000E+04, 6.8883735815E+00, 5.5358800799E+00, 5.7843739595E-01, 4.8671097554E-01, 6.5402785403E-01],
	[1.4290000000E+04, 6.8916653487E+00, 5.5355266966E+00, 5.7907737920E-01, 4.8717772042E-01, 6.5416257554E-01],
	[1.4295000000E+04, 6.8949575366E+00, 5.5351734594E+00, 5.7971784573E-01, 4.8764468730E-01, 6.5429726873E-01],
	[1.4300000000E+04, 6.8982501450E+00, 5.5348203683E+00, 5.8035879572E-01, 4.8811187609E-01, 6.5443193361E-01],
	[1.4305000000E+04, 6.9015431739E+00, 5.5344674231E+00, 5.8100022937E-01, 4.8857928671E-01, 6.5456657013E-01],
	[1.4310000000E+04, 6.9048366231E+00, 5.5341146238E+00, 5.8164214688E-01, 4.8904691907E-01, 6.5470117830E-01],
	[1.4315000000E+04, 6.9081304927E+00, 5.5337619702E+00, 5.8228454844E-01, 4.8951477308E-01, 6.5483575810E-01],
	[1.4320000000E+04, 6.9114247824E+00, 5.5334094622E+00, 5.8292743425E-01, 4.8998284865E-01, 6.5497030949E-01],
	[1.4325000000E+04, 6.9147194922E+00, 5.5330570997E+00, 5.8357080450E-01, 4.9045114569E-01, 6.5510483248E-01],
	[1.4330000000E+04, 6.9180146220E+00, 5.5327048826E+00, 5.8421465938E-01, 4.9091966412E-01, 6.5523932704E-01],
	[1.4335000000E+04, 6.9213101717E+00, 5.5323528108E+00, 5.8485899910E-01, 4.9138840384E-01, 6.5537379316E-01],
	[1.4340000000E+04, 6.9246061412E+00, 5.5320008842E+00, 5.8550382385E-01, 4.9185736476E-01, 6.5550823081E-01],
	[1.4345000000E+04, 6.9279025304E+00, 5.5316491026E+00, 5.8614913382E-01, 4.9232654680E-01, 6.5564263999E-01],
	[1.4350000000E+04, 6.9312064877E+00, 5.5313028051E+00, 5.8679492920E-01, 4.9279602838E-01, 6.5577702067E-01],
	[1.4355000000E+04, 6.9345128234E+00, 5.5309581090E+00, 5.8744121020E-01, 4.9326575263E-01, 6.5591137284E-01],
	[1.4360000000E+04, 6.9378195839E+00, 5.5306135543E+00, 5.8808797701E-01, 4.9373569804E-01, 6.5604569648E-01],
	[1.4365000000E+04, 6.9411267693E+00, 5.5302691411E+00, 5.8873522982E-01, 4.9420586452E-01, 6.5617999158E-01],
	[1.4370000000E+04, 6.9444343795E+00, 5.5299248691E+00, 5.8938296882E-01, 4.9467625197E-01, 6.5631425811E-01],
	[1.4375000000E+04, 6.9477424144E+00, 5.5295807384E+00, 5.9003119423E-01, 4.9514686032E-01, 6.5644849607E-01],
	[1.4380000000E+04, 6.9510508738E+00, 5.5292367487E+00, 5.9067990622E-01, 4.9561768946E-01, 6.5658270543E-01],
	[1.4385000000E+04, 6.9543597576E+00, 5.5288929000E+00, 5.9132910499E-01, 4.9608873931E-01, 6.5671688618E-01],
	[1.4390000000E+04, 6.9576690659E+00, 5.5285491922E+00, 5.9197879074E-01, 4.9656000978E-01, 6.5685103830E-01],
	[1.4395000000E+04, 6.9609787984E+00, 5.5282056251E+00, 5.9262896367E-01, 4.9703150078E-01, 6.5698516177E-01],
	[1.4400000000E+04, 6.9642889551E+00, 5.5278621987E+00, 5.9327962397E-01, 4.9750321221E-01, 6.5711925658E-01],
	[1.4405000000E+04, 6.9675995360E+00, 5.5275189128E+00, 5.9393077183E-01, 4.9797514400E-01, 6.5725332272E-01],
	[1.4410000000E+04, 6.9709105408E+00, 5.5271757674E+00, 5.9458240746E-01, 4.9844729604E-01, 6.5738736016E-01],
	[1.4415000000E+04, 6.9742219695E+00, 5.5268327623E+00, 5.9523453104E-01, 4.9891966824E-01, 6.5752136889E-01],
	[1.4420000000E+04, 6.9775338221E+00, 5.5264898975E+00, 5.9588714277E-01, 4.9939226053E-01, 6.5765534890E-01],
	[1.4425000000E+04, 6.9808460984E+00, 5.5261471727E+00, 5.9654024284E-01, 4.9986507279E-01, 6.5778930016E-01],
	[1.4430000000E+04, 6.9841587983E+00, 5.5258045880E+00, 5.9719383146E-01, 5.0033810495E-01, 6.5792322266E-01],
	[1.4435000000E+04, 6.9874719218E+00, 5.5254621432E+00, 5.9784790882E-01, 5.0081135691E-01, 6.5805711639E-01],
	[1.4440000000E+04, 6.9907854687E+00, 5.5251198382E+00, 5.9850247510E-01, 5.0128482858E-01, 6.5819098132E-01],
	[1.4445000000E+04, 6.9940994390E+00, 5.5247776729E+00, 5.9915753052E-01, 5.0175851987E-01, 6.5832481745E-01],
	[1.4450000000E+04, 6.9974138326E+00, 5.5244356472E+00, 5.9981307526E-01, 5.0223243069E-01, 6.5845862475E-01],
	[1.4455000000E+04, 7.0007286493E+00, 5.5240937610E+00, 6.0046910951E-01, 5.0270656094E-01, 6.5859240321E-01],
	[1.4460000000E+04, 7.0040438891E+00, 5.5237520142E+00, 6.0112563348E-01, 5.0318091053E-01, 6.5872615282E-01],
	[1.4465000000E+04, 7.0073595519E+00, 5.5234104066E+00, 6.0178264736E-01, 5.0365547937E-01, 6.5885987355E-01],
	[1.4470000000E+04, 7.0106756376E+00, 5.5230689383E+00, 6.0244015135E-01, 5.0413026738E-01, 6.5899356540E-01],
	[1.4475000000E+04, 7.0139921461E+00, 5.5227276090E+00, 6.0309814563E-01, 5.0460527445E-01, 6.5912722834E-01],
	[1.4480000000E+04, 7.0173090773E+00, 5.5223864186E+00, 6.0375663041E-01, 5.0508050049E-01, 6.5926086236E-01],
	[1.4485000000E+04, 7.0206264311E+00, 5.5220453672E+00, 6.0441560588E-01, 5.0555594541E-01, 6.5939446745E-01],
	[1.4490000000E+04, 7.0239442075E+00, 5.5217044545E+00, 6.0507507224E-01, 5.0603160912E-01, 6.5952804358E-01],
	[1.4495000000E+04, 7.0272624062E+00, 5.5213636804E+00, 6.0573502968E-01, 5.0650749153E-01, 6.5966159075E-01],
	[1.4500000000E+04, 7.0305810274E+00, 5.5210230449E+00, 6.0639547839E-01, 5.0698359253E-01, 6.5979510893E-01],
	[1.4505000000E+04, 7.0339000708E+00, 5.5206825478E+00, 6.0705641858E-01, 5.0745991205E-01, 6.5992859811E-01],
	[1.4510000000E+04, 7.0372195363E+00, 5.5203421891E+00, 6.0771785044E-01, 5.0793644998E-01, 6.6006205828E-01],
	[1.4515000000E+04, 7.0405394239E+00, 5.5200019686E+00, 6.0837977416E-01, 5.0841320623E-01, 6.6019548942E-01],
	[1.4520000000E+04, 7.0438597335E+00, 5.5196618862E+00, 6.0904218994E-01, 5.0889018071E-01, 6.6032889152E-01],
	[1.4525000000E+04, 7.0471804650E+00, 5.5193219419E+00, 6.0970509797E-01, 5.0936737333E-01, 6.6046226455E-01],
	[1.4530000000E+04, 7.0505016182E+00, 5.5189821355E+00, 6.1036849845E-01, 5.0984478398E-01, 6.6059560850E-01],
	[1.4535000000E+04, 7.0538231932E+00, 5.5186424669E+00, 6.1103239159E-01, 5.1032241258E-01, 6.6072892336E-01],
	[1.4540000000E+04, 7.0571451898E+00, 5.5183029361E+00, 6.1169677756E-01, 5.1080025903E-01, 6.6086220912E-01],
	[1.4545000000E+04, 7.0604676079E+00, 5.5179635428E+00, 6.1236165657E-01, 5.1127832324E-01, 6.6099546575E-01],
	[1.4550000000E+04, 7.0637904474E+00, 5.5176242871E+00, 6.1302702881E-01, 5.1175660511E-01, 6.6112869324E-01],
	[1.4555000000E+04, 7.0671137083E+00, 5.5172851688E+00, 6.1369289447E-01, 5.1223510455E-01, 6.6126189158E-01],
	[1.4560000000E+04, 7.0704373904E+00, 5.5169461878E+00, 6.1435925377E-01, 5.1271382147E-01, 6.6139506074E-01],
	[1.4565000000E+04, 7.0737614936E+00, 5.5166073439E+00, 6.1502610688E-01, 5.1319275576E-01, 6.6152820073E-01],
	[1.4570000000E+04, 7.0770860179E+00, 5.5162686372E+00, 6.1569345401E-01, 5.1367190733E-01, 6.6166131151E-01],
	[1.4575000000E+04, 7.0804109632E+00, 5.5159300675E+00, 6.1636129534E-01, 5.1415127610E-01, 6.6179439307E-01],
	[1.4580000000E+04, 7.0837420043E+00, 5.5155955972E+00, 6.1702963109E-01, 5.1463092640E-01, 6.6192744541E-01],
	[1.4585000000E+04, 7.0870773353E+00, 5.5152639596E+00, 6.1769846143E-01, 5.1511083785E-01, 6.6206046850E-01],
	[1.4590000000E+04, 7.0904130926E+00, 5.5149324555E+00, 6.1836778657E-01, 5.1559096653E-01, 6.6219346233E-01],
	[1.4595000000E+04, 7.0937492763E+00, 5.5146010850E+00, 6.1903760671E-01, 5.1607131234E-01, 6.6232642688E-01],
	[1.4600000000E+04, 7.0970858861E+00, 5.5142698479E+00, 6.1970792203E-01, 5.1655187519E-01, 6.6245936214E-01],
	[1.4605000000E+04, 7.1004229221E+00, 5.5139387441E+00, 6.2037873274E-01, 5.1703265499E-01, 6.6259226809E-01],
	[1.4610000000E+04, 7.1037603841E+00, 5.5136077734E+00, 6.2105003902E-01, 5.1751365163E-01, 6.6272514473E-01],
	[1.4615000000E+04, 7.1070982721E+00, 5.5132769359E+00, 6.2172184109E-01, 5.1799486502E-01, 6.6285799202E-01],
	[1.4620000000E+04, 7.1104365859E+00, 5.5129462314E+00, 6.2239413912E-01, 5.1847629507E-01, 6.6299080997E-01],
	[1.4625000000E+04, 7.1137753255E+00, 5.5126156598E+00, 6.2306693332E-01, 5.1895794167E-01, 6.6312359855E-01],
	[1.4630000000E+04, 7.1171144907E+00, 5.5122852211E+00, 6.2374022389E-01, 5.1943980474E-01, 6.6325635775E-01],
	[1.4635000000E+04, 7.1204540815E+00, 5.5119549150E+00, 6.2441401101E-01, 5.1992188418E-01, 6.6338908755E-01],
	[1.4640000000E+04, 7.1237940977E+00, 5.5116247415E+00, 6.2508829489E-01, 5.2040417989E-01, 6.6352178794E-01],
	[1.4645000000E+04, 7.1271345394E+00, 5.5112947006E+00, 6.2576307571E-01, 5.2088669177E-01, 6.6365445891E-01],
	[1.4650000000E+04, 7.1304754064E+00, 5.5109647920E+00, 6.2643835369E-01, 5.2136941972E-01, 6.6378710043E-01],
	[1.4655000000E+04, 7.1338166985E+00, 5.5106350158E+00, 6.2711412900E-01, 5.2185236366E-01, 6.6391971250E-01],
	[1.4660000000E+04, 7.1371584158E+00, 5.5103053718E+00, 6.2779040185E-01, 5.2233552348E-01, 6.6405229510E-01],
	[1.4665000000E+04, 7.1405005581E+00, 5.5099758599E+00, 6.2846717244E-01, 5.2281889909E-01, 6.6418484822E-01],
	[1.4670000000E+04, 7.1438431253E+00, 5.5096464800E+00, 6.2914444095E-01, 5.2330249038E-01, 6.6431737184E-01],
	[1.4675000000E+04, 7.1471861174E+00, 5.5093172321E+00, 6.2982220759E-01, 5.2378629727E-01, 6.6444986595E-01],
	[1.4680000000E+04, 7.1505295343E+00, 5.5089881160E+00, 6.3050047255E-01, 5.2427031965E-01, 6.6458233052E-01],
	[1.4685000000E+04, 7.1538733758E+00, 5.5086591316E+00, 6.3117923602E-01, 5.2475455743E-01, 6.6471476556E-01],
	[1.4690000000E+04, 7.1572176418E+00, 5.5083302789E+00, 6.3185849821E-01, 5.2523901050E-01, 6.6484717104E-01],
	[1.4695000000E+04, 7.1605623324E+00, 5.5080015576E+00, 6.3253825931E-01, 5.2572367877E-01, 6.6497954694E-01],
	[1.4700000000E+04, 7.1639074473E+00, 5.5076729678E+00, 6.3321851950E-01, 5.2620856215E-01, 6.6511189327E-01],
	[1.4705000000E+04, 7.1672529866E+00, 5.5073445094E+00, 6.3389927900E-01, 5.2669366053E-01, 6.6524420999E-01],
	[1.4710000000E+04, 7.1705989500E+00, 5.5070161822E+00, 6.3458053800E-01, 5.2717897382E-01, 6.6537649709E-01],
	[1.4715000000E+04, 7.1739453376E+00, 5.5066879861E+00, 6.3526229668E-01, 5.2766450191E-01, 6.6550875457E-01],
	[1.4720000000E+04, 7.1772921492E+00, 5.5063599211E+00, 6.3594455526E-01, 5.2815024471E-01, 6.6564098241E-01],
	[1.4725000000E+04, 7.1806393847E+00, 5.5060319871E+00, 6.3662731391E-01, 5.2863620212E-01, 6.6577318059E-01],
	[1.4730000000E+04, 7.1839870441E+00, 5.5057041839E+00, 6.3731057285E-01, 5.2912237405E-01, 6.6590534909E-01],
	[1.4735000000E+04, 7.1873351273E+00, 5.5053765114E+00, 6.3799433226E-01, 5.2960876038E-01, 6.6603748792E-01],
	[1.4740000000E+04, 7.1906836341E+00, 5.5050489696E+00, 6.3867859234E-01, 5.3009536103E-01, 6.6616959704E-01],
	[1.4745000000E+04, 7.1940325645E+00, 5.5047215584E+00, 6.3936335329E-01, 5.3058217589E-01, 6.6630167645E-01],
	[1.4750000000E+04, 7.1973819183E+00, 5.5043942776E+00, 6.4004861530E-01, 5.3106920486E-01, 6.6643372613E-01],
	[1.4755000000E+04, 7.2007316956E+00, 5.5040671273E+00, 6.4073437857E-01, 5.3155644785E-01, 6.6656574606E-01],
	[1.4760000000E+04, 7.2040818962E+00, 5.5037401072E+00, 6.4142064330E-01, 5.3204390475E-01, 6.6669773625E-01],
	[1.4765000000E+04, 7.2074325200E+00, 5.5034132172E+00, 6.4210740967E-01, 5.3253157547E-01, 6.6682969666E-01],
	[1.4770000000E+04, 7.2107835669E+00, 5.5030864574E+00, 6.4279467790E-01, 5.3301945991E-01, 6.6696162729E-01],
	[1.4775000000E+04, 7.2141350369E+00, 5.5027598275E+00, 6.4348244816E-01, 5.3350755795E-01, 6.6709352812E-01],
	[1.4780000000E+04, 7.2174869298E+00, 5.5024333276E+00, 6.4417072067E-01, 5.3399586952E-01, 6.6722539914E-01],
	[1.4785000000E+04, 7.2208392455E+00, 5.5021069574E+00, 6.4485949561E-01, 5.3448439449E-01, 6.6735724034E-01],
	[1.4790000000E+04, 7.2241919841E+00, 5.5017807169E+00, 6.4554877318E-01, 5.3497313278E-01, 6.6748905169E-01],
	[1.4795000000E+04, 7.2275451453E+00, 5.5014546061E+00, 6.4623855358E-01, 5.3546208429E-01, 6.6762083320E-01],
	[1.4800000000E+04, 7.2308987291E+00, 5.5011286247E+00, 6.4692883700E-01, 5.3595124890E-01, 6.6775258483E-01],
	[1.4805000000E+04, 7.2342527354E+00, 5.5008027728E+00, 6.4761962364E-01, 5.3644062653E-01, 6.6788430659E-01],
	[1.4810000000E+04, 7.2376071641E+00, 5.5004770502E+00, 6.4831091369E-01, 5.3693021707E-01, 6.6801599845E-01],
	[1.4815000000E+04, 7.2409686121E+00, 5.5001557694E+00, 6.4900270736E-01, 5.3742009793E-01, 6.6814766040E-01],
	[1.4820000000E+04, 7.2443338731E+00, 5.4998368287E+00, 6.4969500483E-01, 5.3791023157E-01, 6.6827929244E-01],
	[1.4825000000E+04, 7.2476995620E+00, 5.4995180140E+00, 6.5038780631E-01, 5.3840057816E-01, 6.6841089454E-01],
	[1.4830000000E+04, 7.2510656790E+00, 5.4991993253E+00, 6.5108111199E-01, 5.3889113760E-01, 6.6854246669E-01],
	[1.4835000000E+04, 7.2544322237E+00, 5.4988807625E+00, 6.5177492206E-01, 5.3938190979E-01, 6.6867400887E-01],
	[1.4840000000E+04, 7.2577991963E+00, 5.4985623255E+00, 6.5246923672E-01, 5.3987289463E-01, 6.6880552109E-01],
	[1.4845000000E+04, 7.2611665965E+00, 5.4982440142E+00, 6.5316405617E-01, 5.4036409201E-01, 6.6893700331E-01],
	[1.4850000000E+04, 7.2645344243E+00, 5.4979258285E+00, 6.5385938061E-01, 5.4085550184E-01, 6.6906845553E-01],
	[1.4855000000E+04, 7.2679026796E+00, 5.4976077683E+00, 6.5455521022E-01, 5.4134712402E-01, 6.6919987774E-01],
	[1.4860000000E+04, 7.2712713624E+00, 5.4972898335E+00, 6.5525154522E-01, 5.4183895843E-01, 6.6933126992E-01],
	[1.4865000000E+04, 7.2746404724E+00, 5.4969720241E+00, 6.5594838578E-01, 5.4233100499E-01, 6.6946263205E-01],
	[1.4870000000E+04, 7.2780100097E+00, 5.4966543400E+00, 6.5664573212E-01, 5.4282326358E-01, 6.6959396413E-01],
	[1.4875000000E+04, 7.2813799741E+00, 5.4963367809E+00, 6.5734358441E-01, 5.4331573411E-01, 6.6972526615E-01],
	[1.4880000000E+04, 7.2847503655E+00, 5.4960193470E+00, 6.5804194287E-01, 5.4380841648E-01, 6.6985653808E-01],
	[1.4885000000E+04, 7.2881211840E+00, 5.4957020380E+00, 6.5874080769E-01, 5.4430131057E-01, 6.6998777991E-01],
	[1.4890000000E+04, 7.2914924292E+00, 5.4953848539E+00, 6.5944017906E-01, 5.4479441629E-01, 6.7011899164E-01],
	[1.4895000000E+04, 7.2948641013E+00, 5.4950677946E+00, 6.6014005718E-01, 5.4528773354E-01, 6.7025017324E-01],
	[1.4900000000E+04, 7.2982362001E+00, 5.4947508600E+00, 6.6084044225E-01, 5.4578126221E-01, 6.7038132471E-01],
	[1.4905000000E+04, 7.3016087254E+00, 5.4944340499E+00, 6.6154133445E-01, 5.4627500220E-01, 6.7051244604E-01],
	[1.4910000000E+04, 7.3049816773E+00, 5.4941173644E+00, 6.6224273400E-01, 5.4676895341E-01, 6.7064353720E-01],
	[1.4915000000E+04, 7.3083550556E+00, 5.4938008034E+00, 6.6294464108E-01, 5.4726311573E-01, 6.7077459819E-01],
	[1.4920000000E+04, 7.3117288603E+00, 5.4934843666E+00, 6.6364705590E-01, 5.4775748906E-01, 6.7090562899E-01],
	[1.4925000000E+04, 7.3151030911E+00, 5.4931680541E+00, 6.6434997864E-01, 5.4825207329E-01, 6.7103662959E-01],
	[1.4930000000E+04, 7.3184777482E+00, 5.4928518658E+00, 6.6505340950E-01, 5.4874686833E-01, 6.7116759999E-01],
	[1.4935000000E+04, 7.3218528313E+00, 5.4925358015E+00, 6.6575734868E-01, 5.4924187407E-01, 6.7129854015E-01],
	[1.4940000000E+04, 7.3252283404E+00, 5.4922198612E+00, 6.6646179638E-01, 5.4973709041E-01, 6.7142945008E-01],
	[1.4945000000E+04, 7.3286042754E+00, 5.4919040448E+00, 6.6716675280E-01, 5.5023251723E-01, 6.7156032976E-01],
	[1.4950000000E+04, 7.3319806362E+00, 5.4915883522E+00, 6.6787221812E-01, 5.5072815444E-01, 6.7169117917E-01],
	[1.4955000000E+04, 7.3353574227E+00, 5.4912727832E+00, 6.6857819254E-01, 5.5122400194E-01, 6.7182199831E-01],
	[1.4960000000E+04, 7.3387346348E+00, 5.4909573379E+00, 6.6928467627E-01, 5.5172005961E-01, 6.7195278716E-01],
	[1.4965000000E+04, 7.3421122725E+00, 5.4906420161E+00, 6.6999166950E-01, 5.5221632736E-01, 6.7208354571E-01],
	[1.4970000000E+04, 7.3454903356E+00, 5.4903268178E+00, 6.7069917242E-01, 5.5271280508E-01, 6.7221427394E-01],
	[1.4975000000E+04, 7.3488688240E+00, 5.4900117428E+00, 6.7140718523E-01, 5.5320949266E-01, 6.7234497185E-01],
	[1.4980000000E+04, 7.3522477378E+00, 5.4896967910E+00, 6.7211570813E-01, 5.5370639000E-01, 6.7247563942E-01],
	[1.4985000000E+04, 7.3556270767E+00, 5.4893819624E+00, 6.7282474131E-01, 5.5420349700E-01, 6.7260627663E-01],
	[1.4990000000E+04, 7.3590068407E+00, 5.4890672569E+00, 6.7353428498E-01, 5.5470081354E-01, 6.7273688348E-01],
	[1.4995000000E+04, 7.3623870298E+00, 5.4887526744E+00, 6.7424433931E-01, 5.5519833953E-01, 6.7286745996E-01],
	[1.5000000000E+04, 7.3657676437E+00, 5.4884382148E+00, 6.7495490453E-01, 5.5569607486E-01, 6.7299800604E-01],
	[1.5005000000E+04, 7.3691486825E+00, 5.4881238779E+00, 6.7566818849E-01, 5.5619551539E-01, 6.7312852173E-01],
	[1.5010000000E+04, 7.3725301460E+00, 5.4878096638E+00, 6.7638198770E-01, 5.5669516681E-01, 6.7325900699E-01],
	[1.5015000000E+04, 7.3759120341E+00, 5.4874955724E+00, 6.7709630236E-01, 5.5719502901E-01, 6.7338946184E-01],
	[1.5020000000E+04, 7.3792943469E+00, 5.4871816035E+00, 6.7781113267E-01, 5.5769510187E-01, 6.7351988624E-01],
	[1.5025000000E+04, 7.3826770841E+00, 5.4868677570E+00, 6.7852647883E-01, 5.5819538530E-01, 6.7365028019E-01],
	[1.5030000000E+04, 7.3860602457E+00, 5.4865540329E+00, 6.7924234104E-01, 5.5869587919E-01, 6.7378064368E-01],
	[1.5035000000E+04, 7.3894438316E+00, 5.4862404311E+00, 6.7995871949E-01, 5.5919658342E-01, 6.7391097670E-01],
	[1.5040000000E+04, 7.3928278417E+00, 5.4859269514E+00, 6.8067561440E-01, 5.5969749790E-01, 6.7404127923E-01],
	[1.5045000000E+04, 7.3962122759E+00, 5.4856135939E+00, 6.8139302595E-01, 5.6019862252E-01, 6.7417155125E-01],
	[1.5050000000E+04, 7.3995971342E+00, 5.4853003584E+00, 6.8211095435E-01, 5.6069995716E-01, 6.7430179277E-01],
	[1.5055000000E+04, 7.4029925480E+00, 5.4849934595E+00, 6.8282939980E-01, 5.6120162501E-01, 6.7443200375E-01],
	[1.5060000000E+04, 7.4063886921E+00, 5.4846868639E+00, 6.8354836250E-01, 5.6170350668E-01, 6.7456218418E-01],
	[1.5065000000E+04, 7.4097852661E+00, 5.4843803872E+00, 6.8426784264E-01, 5.6220559843E-01, 6.7469233403E-01],
	[1.5070000000E+04, 7.4131822698E+00, 5.4840740293E+00, 6.8498784043E-01, 5.6270790014E-01, 6.7482245329E-01],
	[1.5075000000E+04, 7.4165797032E+00, 5.4837677902E+00, 6.8570835607E-01, 5.6321041171E-01, 6.7495254195E-01],
	[1.5080000000E+04, 7.4199775662E+00, 5.4834616697E+00, 6.8642938976E-01, 5.6371313302E-01, 6.7508259997E-01],
	[1.5085000000E+04, 7.4233758588E+00, 5.4831556677E+00, 6.8715094169E-01, 5.6421606398E-01, 6.7521262736E-01],
	[1.5090000000E+04, 7.4267745807E+00, 5.4828497843E+00, 6.8787301207E-01, 5.6471920447E-01, 6.7534262410E-01],
	[1.5095000000E+04, 7.4301737320E+00, 5.4825440192E+00, 6.8859560110E-01, 5.6522255439E-01, 6.7547259016E-01],
	[1.5100000000E+04, 7.4335733125E+00, 5.4822383725E+00, 6.8931870898E-01, 5.6572611363E-01, 6.7560252553E-01],
	[1.5105000000E+04, 7.4369733222E+00, 5.4819328439E+00, 6.9004233590E-01, 5.6622988207E-01, 6.7573243020E-01],
	[1.5110000000E+04, 7.4403737610E+00, 5.4816274335E+00, 6.9076648208E-01, 5.6673385962E-01, 6.7586230415E-01],
	[1.5115000000E+04, 7.4437746287E+00, 5.4813221412E+00, 6.9149114769E-01, 5.6723804616E-01, 6.7599214737E-01],
	[1.5120000000E+04, 7.4471759254E+00, 5.4810169668E+00, 6.9221633296E-01, 5.6774244159E-01, 6.7612195983E-01],
	[1.5125000000E+04, 7.4505776508E+00, 5.4807119103E+00, 6.9294203807E-01, 5.6824704579E-01, 6.7625174153E-01],
	[1.5130000000E+04, 7.4539798050E+00, 5.4804069716E+00, 6.9366826323E-01, 5.6875185866E-01, 6.7638149244E-01],
	[1.5135000000E+04, 7.4573823878E+00, 5.4801021506E+00, 6.9439500864E-01, 5.6925688009E-01, 6.7651121256E-01],
	[1.5140000000E+04, 7.4607853991E+00, 5.4797974473E+00, 6.9512227450E-01, 5.6976210996E-01, 6.7664090186E-01],
	[1.5145000000E+04, 7.4641888389E+00, 5.4794928615E+00, 6.9585006100E-01, 5.7026754818E-01, 6.7677056034E-01],
	[1.5150000000E+04, 7.4675927071E+00, 5.4791883931E+00, 6.9657836835E-01, 5.7077319463E-01, 6.7690018797E-01],
	[1.5155000000E+04, 7.4709970036E+00, 5.4788840421E+00, 6.9730719675E-01, 5.7127904920E-01, 6.7702978473E-01],
	[1.5160000000E+04, 7.4744017282E+00, 5.4785798085E+00, 6.9803654640E-01, 5.7178511179E-01, 6.7715935063E-01],
	[1.5165000000E+04, 7.4778068810E+00, 5.4782756920E+00, 6.9876641749E-01, 5.7229138228E-01, 6.7728888563E-01],
	[1.5170000000E+04, 7.4812124617E+00, 5.4779716927E+00, 6.9949681024E-01, 5.7279786056E-01, 6.7741838973E-01],
	[1.5175000000E+04, 7.4846184705E+00, 5.4776678104E+00, 7.0022772483E-01, 5.7330454652E-01, 6.7754786290E-01],
	[1.5180000000E+04, 7.4880249070E+00, 5.4773640450E+00, 7.0095916147E-01, 5.7381144005E-01, 6.7767730514E-01],
	[1.5185000000E+04, 7.4914317713E+00, 5.4770603966E+00, 7.0169112035E-01, 5.7431854105E-01, 6.7780671642E-01],
	[1.5190000000E+04, 7.4948390633E+00, 5.4767568649E+00, 7.0242360169E-01, 5.7482584941E-01, 6.7793609674E-01],
	[1.5195000000E+04, 7.4982467829E+00, 5.4764534499E+00, 7.0315660568E-01, 5.7533336500E-01, 6.7806544607E-01],
	[1.5200000000E+04, 7.5016549300E+00, 5.4761501516E+00, 7.0389013251E-01, 5.7584108773E-01, 6.7819476441E-01],
	[1.5205000000E+04, 7.5050635044E+00, 5.4758469698E+00, 7.0462418240E-01, 5.7634901747E-01, 6.7832405173E-01],
	[1.5210000000E+04, 7.5084725062E+00, 5.4755439044E+00, 7.0535875553E-01, 5.7685715413E-01, 6.7845330802E-01],
	[1.5215000000E+04, 7.5118819353E+00, 5.4752409555E+00, 7.0609385211E-01, 5.7736549759E-01, 6.7858253328E-01],
	[1.5220000000E+04, 7.5152917915E+00, 5.4749381228E+00, 7.0682947234E-01, 5.7787404774E-01, 6.7871172747E-01],
	[1.5225000000E+04, 7.5187020747E+00, 5.4746354063E+00, 7.0756561643E-01, 5.7838280446E-01, 6.7884089059E-01],
	[1.5230000000E+04, 7.5221127849E+00, 5.4743328060E+00, 7.0830228456E-01, 5.7889176765E-01, 6.7897002262E-01],
	[1.5235000000E+04, 7.5255239221E+00, 5.4740303217E+00, 7.0903947694E-01, 5.7940093719E-01, 6.7909912355E-01],
	[1.5240000000E+04, 7.5289354860E+00, 5.4737279534E+00, 7.0977719378E-01, 5.7991031298E-01, 6.7922819336E-01],
	[1.5245000000E+04, 7.5323474766E+00, 5.4734257009E+00, 7.1051543526E-01, 5.8041989490E-01, 6.7935723203E-01],
	[1.5250000000E+04, 7.5357598939E+00, 5.4731235643E+00, 7.1125420160E-01, 5.8092968284E-01, 6.7948623956E-01],
	[1.5255000000E+04, 7.5391727377E+00, 5.4728215434E+00, 7.1199349299E-01, 5.8143967669E-01, 6.7961521593E-01],
	[1.5260000000E+04, 7.5425860079E+00, 5.4725196381E+00, 7.1273330963E-01, 5.8194987634E-01, 6.7974416112E-01],
	[1.5265000000E+04, 7.5459997046E+00, 5.4722178483E+00, 7.1347365172E-01, 5.8246028166E-01, 6.7987307511E-01],
	[1.5270000000E+04, 7.5494138275E+00, 5.4719161740E+00, 7.1421451947E-01, 5.8297089256E-01, 6.8000195790E-01],
	[1.5275000000E+04, 7.5528283766E+00, 5.4716146151E+00, 7.1495591307E-01, 5.8348170892E-01, 6.8013080947E-01],
	[1.5280000000E+04, 7.5562433518E+00, 5.4713131715E+00, 7.1569783272E-01, 5.8399273063E-01, 6.8025962981E-01],
	[1.5285000000E+04, 7.5596587530E+00, 5.4710118432E+00, 7.1644027862E-01, 5.8450395757E-01, 6.8038841889E-01],
	[1.5290000000E+04, 7.5630745802E+00, 5.4707106299E+00, 7.1718325098E-01, 5.8501538963E-01, 6.8051717671E-01],
	[1.5295000000E+04, 7.5664964257E+00, 5.4704127622E+00, 7.1792675000E-01, 5.8552709720E-01, 6.8064590325E-01],
	[1.5300000000E+04, 7.5699239928E+00, 5.4701180638E+00, 7.1867077587E-01, 5.8603907666E-01, 6.8077459849E-01],
	[1.5305000000E+04, 7.5733519919E+00, 5.4698234776E+00, 7.1941532879E-01, 5.8655126129E-01, 6.8090326243E-01],
	[1.5310000000E+04, 7.5767804229E+00, 5.4695290035E+00, 7.2016040897E-01, 5.8706365096E-01, 6.8103189504E-01],
	[1.5315000000E+04, 7.5802092857E+00, 5.4692346413E+00, 7.2090601660E-01, 5.8757624558E-01, 6.8116049632E-01],
	[1.5320000000E+04, 7.5836385801E+00, 5.4689403911E+00, 7.2165215190E-01, 5.8808904503E-01, 6.8128906624E-01],
	[1.5325000000E+04, 7.5870683062E+00, 5.4686462527E+00, 7.2239881505E-01, 5.8860204920E-01, 6.8141760480E-01],
	[1.5330000000E+04, 7.5904984639E+00, 5.4683522261E+00, 7.2314600625E-01, 5.8911525797E-01, 6.8154611198E-01],
	[1.5335000000E+04, 7.5939290529E+00, 5.4680583112E+00, 7.2389372572E-01, 5.8962867122E-01, 6.8167458777E-01],
	[1.5340000000E+04, 7.5973600734E+00, 5.4677645078E+00, 7.2464197364E-01, 5.9014228885E-01, 6.8180303215E-01],
	[1.5345000000E+04, 7.6007915251E+00, 5.4674708160E+00, 7.2539075022E-01, 5.9065611075E-01, 6.8193144510E-01],
	[1.5350000000E+04, 7.6042234079E+00, 5.4671772357E+00, 7.2614005566E-01, 5.9117013679E-01, 6.8205982662E-01],
	[1.5355000000E+04, 7.6076557219E+00, 5.4668837667E+00, 7.2688989016E-01, 5.9168436687E-01, 6.8218817669E-01],
	[1.5360000000E+04, 7.6110884669E+00, 5.4665904090E+00, 7.2764025392E-01, 5.9219880086E-01, 6.8231649529E-01],
	[1.5365000000E+04, 7.6145216429E+00, 5.4662971625E+00, 7.2839114714E-01, 5.9271343867E-01, 6.8244478242E-01],
	[1.5370000000E+04, 7.6179552496E+00, 5.4660040272E+00, 7.2914257002E-01, 5.9322828016E-01, 6.8257303805E-01],
	[1.5375000000E+04, 7.6213892871E+00, 5.4657110029E+00, 7.2989452277E-01, 5.9374332524E-01, 6.8270126218E-01],
	[1.5380000000E+04, 7.6248237553E+00, 5.4654180896E+00, 7.3064700558E-01, 5.9425857378E-01, 6.8282945479E-01],
	[1.5385000000E+04, 7.6282586541E+00, 5.4651252872E+00, 7.3140001865E-01, 5.9477402566E-01, 6.8295761586E-01],
	[1.5390000000E+04, 7.6316939834E+00, 5.4648325956E+00, 7.3215356218E-01, 5.9528968079E-01, 6.8308574538E-01],
	[1.5395000000E+04, 7.6351297431E+00, 5.4645400147E+00, 7.3290763638E-01, 5.9580553903E-01, 6.8321384335E-01],
	[1.5400000000E+04, 7.6385659331E+00, 5.4642475445E+00, 7.3366224144E-01, 5.9632160028E-01, 6.8334190973E-01],
	[1.5405000000E+04, 7.6420025533E+00, 5.4639551850E+00, 7.3441737757E-01, 5.9683786442E-01, 6.8346994453E-01],
	[1.5410000000E+04, 7.6454396037E+00, 5.4636629359E+00, 7.3517304496E-01, 5.9735433133E-01, 6.8359794773E-01],
	[1.5415000000E+04, 7.6488770842E+00, 5.4633707972E+00, 7.3592924382E-01, 5.9787100090E-01, 6.8372591931E-01],
	[1.5420000000E+04, 7.6523149946E+00, 5.4630787689E+00, 7.3668597435E-01, 5.9838787302E-01, 6.8385385926E-01],
	[1.5425000000E+04, 7.6557533350E+00, 5.4627868509E+00, 7.3744323674E-01, 5.9890494757E-01, 6.8398176756E-01],
	[1.5430000000E+04, 7.6591921051E+00, 5.4624950431E+00, 7.3820103121E-01, 5.9942222442E-01, 6.8410964421E-01],
	[1.5435000000E+04, 7.6626313050E+00, 5.4622033454E+00, 7.3895935794E-01, 5.9993970348E-01, 6.8423748919E-01],
	[1.5440000000E+04, 7.6660709345E+00, 5.4619117578E+00, 7.3971821714E-01, 6.0045738462E-01, 6.8436530248E-01],
	[1.5445000000E+04, 7.6695109936E+00, 5.4616202801E+00, 7.4047760901E-01, 6.0097526773E-01, 6.8449308407E-01],
	[1.5450000000E+04, 7.6729514821E+00, 5.4613289123E+00, 7.4123753376E-01, 6.0149335268E-01, 6.8462083396E-01],
	[1.5455000000E+04, 7.6763924001E+00, 5.4610376543E+00, 7.4199799157E-01, 6.0201163937E-01, 6.8474855212E-01],
	[1.5460000000E+04, 7.6798337473E+00, 5.4607465061E+00, 7.4275898266E-01, 6.0253012768E-01, 6.8487623854E-01],
	[1.5465000000E+04, 7.6832755237E+00, 5.4604554675E+00, 7.4352050722E-01, 6.0304881748E-01, 6.8500389321E-01],
	[1.5470000000E+04, 7.6867177293E+00, 5.4601645385E+00, 7.4428256546E-01, 6.0356770867E-01, 6.8513151612E-01],
	[1.5475000000E+04, 7.6901603639E+00, 5.4598737191E+00, 7.4504515757E-01, 6.0408680113E-01, 6.8525910725E-01],
	[1.5480000000E+04, 7.6936034275E+00, 5.4595830090E+00, 7.4580828376E-01, 6.0460609474E-01, 6.8538666659E-01],
	[1.5485000000E+04, 7.6970469199E+00, 5.4592924083E+00, 7.4657194422E-01, 6.0512558939E-01, 6.8551419413E-01],
	[1.5490000000E+04, 7.7004908411E+00, 5.4590019169E+00, 7.4733613916E-01, 6.0564528495E-01, 6.8564168985E-01],
	[1.5495000000E+04, 7.7039351910E+00, 5.4587115347E+00, 7.4810086878E-01, 6.0616518131E-01, 6.8576915374E-01],
	[1.5500000000E+04, 7.7073799696E+00, 5.4584212616E+00, 7.4886613327E-01, 6.0668527835E-01, 6.8589658578E-01],
	[1.5505000000E+04, 7.7108251766E+00, 5.4581310976E+00, 7.4963193285E-01, 6.0720557596E-01, 6.8602398597E-01],
	[1.5510000000E+04, 7.7142708122E+00, 5.4578410425E+00, 7.5039826771E-01, 6.0772607402E-01, 6.8615135429E-01],
	[1.5515000000E+04, 7.7177168760E+00, 5.4575510963E+00, 7.5116513804E-01, 6.0824677240E-01, 6.8627869073E-01],
	[1.5520000000E+04, 7.7211633682E+00, 5.4572612590E+00, 7.5193254406E-01, 6.0876767100E-01, 6.8640599527E-01],
	[1.5525000000E+04, 7.7246102885E+00, 5.4569715304E+00, 7.5270048596E-01, 6.0928876970E-01, 6.8653326791E-01],
	[1.5530000000E+04, 7.7280576370E+00, 5.4566819105E+00, 7.5346896395E-01, 6.0981006837E-01, 6.8666050863E-01],
	[1.5535000000E+04, 7.7315054135E+00, 5.4563923991E+00, 7.5423797822E-01, 6.1033156690E-01, 6.8678771741E-01],
	[1.5540000000E+04, 7.7349567525E+00, 5.4561047038E+00, 7.5500752898E-01, 6.1085330612E-01, 6.8691489425E-01],
	[1.5545000000E+04, 7.7384167305E+00, 5.4558215860E+00, 7.5577761642E-01, 6.1137535244E-01, 6.8704203912E-01],
	[1.5550000000E+04, 7.7418771427E+00, 5.4555385739E+00, 7.5654824075E-01, 6.1189759868E-01, 6.8716915203E-01],
	[1.5555000000E+04, 7.7453379891E+00, 5.4552556674E+00, 7.5731940216E-01, 6.1242004470E-01, 6.8729623295E-01],
	[1.5560000000E+04, 7.7487992696E+00, 5.4549728665E+00, 7.5809110087E-01, 6.1294269040E-01, 6.8742328187E-01],
	[1.5565000000E+04, 7.7522609840E+00, 5.4546901712E+00, 7.5886333707E-01, 6.1346553564E-01, 6.8755029879E-01],
	[1.5570000000E+04, 7.7557231324E+00, 5.4544075812E+00, 7.5963611095E-01, 6.1398858033E-01, 6.8767728368E-01],
	[1.5575000000E+04, 7.7591857146E+00, 5.4541250967E+00, 7.6040942273E-01, 6.1451182433E-01, 6.8780423654E-01],
	[1.5580000000E+04, 7.7626487305E+00, 5.4538427174E+00, 7.6118327261E-01, 6.1503526753E-01, 6.8793115735E-01],
	[1.5585000000E+04, 7.7661121801E+00, 5.4535604434E+00, 7.6195766077E-01, 6.1555890981E-01, 6.8805804610E-01],
	[1.5590000000E+04, 7.7695760633E+00, 5.4532782745E+00, 7.6273258743E-01, 6.1608275105E-01, 6.8818490278E-01],
	[1.5595000000E+04, 7.7730403799E+00, 5.4529962107E+00, 7.6350805279E-01, 6.1660679113E-01, 6.8831172738E-01],
	[1.5600000000E+04, 7.7765051300E+00, 5.4527142519E+00, 7.6428405704E-01, 6.1713102993E-01, 6.8843851987E-01],
	[1.5605000000E+04, 7.7799703133E+00, 5.4524323980E+00, 7.6506060039E-01, 6.1765546734E-01, 6.8856528026E-01],
	[1.5610000000E+04, 7.7834359299E+00, 5.4521506489E+00, 7.6583768304E-01, 6.1818010324E-01, 6.8869200853E-01],
	[1.5615000000E+04, 7.7869019797E+00, 5.4518690047E+00, 7.6661530519E-01, 6.1870493749E-01, 6.8881870466E-01],
	[1.5620000000E+04, 7.7903684624E+00, 5.4515874652E+00, 7.6739346704E-01, 6.1922997000E-01, 6.8894536865E-01],
	[1.5625000000E+04, 7.7938353782E+00, 5.4513060303E+00, 7.6817216879E-01, 6.1975520063E-01, 6.8907200048E-01],
	[1.5630000000E+04, 7.7973027269E+00, 5.4510246999E+00, 7.6895141065E-01, 6.2028062926E-01, 6.8919860014E-01],
	[1.5635000000E+04, 7.8007705083E+00, 5.4507434741E+00, 7.6973119281E-01, 6.2080625579E-01, 6.8932516762E-01],
	[1.5640000000E+04, 7.8042387225E+00, 5.4504623527E+00, 7.7051151547E-01, 6.2133208007E-01, 6.8945170290E-01],
	[1.5645000000E+04, 7.8077073694E+00, 5.4501813356E+00, 7.7129237884E-01, 6.2185810201E-01, 6.8957820597E-01],
	[1.5650000000E+04, 7.8111764487E+00, 5.4499004228E+00, 7.7207378312E-01, 6.2238432147E-01, 6.8970467683E-01],
	[1.5655000000E+04, 7.8146459606E+00, 5.4496196142E+00, 7.7285572850E-01, 6.2291073834E-01, 6.8983111546E-01],
	[1.5660000000E+04, 7.8181159048E+00, 5.4493389098E+00, 7.7363821520E-01, 6.2343735249E-01, 6.8995752184E-01],
	[1.5665000000E+04, 7.8215862813E+00, 5.4490583094E+00, 7.7442124340E-01, 6.2396416381E-01, 6.9008389597E-01],
	[1.5670000000E+04, 7.8250570901E+00, 5.4487778130E+00, 7.7520481332E-01, 6.2449117218E-01, 6.9021023783E-01],
	[1.5675000000E+04, 7.8285283310E+00, 5.4484974206E+00, 7.7598892515E-01, 6.2501837746E-01, 6.9033654741E-01],
	[1.5680000000E+04, 7.8320000039E+00, 5.4482171319E+00, 7.7677357910E-01, 6.2554577955E-01, 6.9046282471E-01],
	[1.5685000000E+04, 7.8354721088E+00, 5.4479369471E+00, 7.7755877536E-01, 6.2607337832E-01, 6.9058906970E-01],
	[1.5690000000E+04, 7.8389446456E+00, 5.4476568659E+00, 7.7834451413E-01, 6.2660117366E-01, 6.9071528238E-01],
	[1.5695000000E+04, 7.8424176142E+00, 5.4473768884E+00, 7.7913079563E-01, 6.2712916543E-01, 6.9084146273E-01],
	[1.5700000000E+04, 7.8458910145E+00, 5.4470970145E+00, 7.7991762004E-01, 6.2765735352E-01, 6.9096761075E-01],
	[1.5705000000E+04, 7.8493648464E+00, 5.4468172440E+00, 7.8070498757E-01, 6.2818573781E-01, 6.9109372641E-01],
	[1.5710000000E+04, 7.8528391098E+00, 5.4465375770E+00, 7.8149289842E-01, 6.2871431817E-01, 6.9121980972E-01],
	[1.5715000000E+04, 7.8563138048E+00, 5.4462580133E+00, 7.8228135280E-01, 6.2924309449E-01, 6.9134586065E-01],
	[1.5720000000E+04, 7.8597889311E+00, 5.4459785528E+00, 7.8307035090E-01, 6.2977206663E-01, 6.9147187920E-01],
	[1.5725000000E+04, 7.8632644887E+00, 5.4456991956E+00, 7.8385989293E-01, 6.3030123449E-01, 6.9159786536E-01],
	[1.5730000000E+04, 7.8667404775E+00, 5.4454199416E+00, 7.8464997908E-01, 6.3083059794E-01, 6.9172381911E-01],
	[1.5735000000E+04, 7.8702168974E+00, 5.4451407905E+00, 7.8544060956E-01, 6.3136015685E-01, 6.9184974044E-01],
	[1.5740000000E+04, 7.8736937484E+00, 5.4448617425E+00, 7.8623178456E-01, 6.3188991111E-01, 6.9197562934E-01],
	[1.5745000000E+04, 7.8771710303E+00, 5.4445827974E+00, 7.8702350430E-01, 6.3241986059E-01, 6.9210148580E-01],
	[1.5750000000E+04, 7.8806487431E+00, 5.4443039552E+00, 7.8781576897E-01, 6.3295000517E-01, 6.9222730981E-01],
	[1.5755000000E+04, 7.8841268867E+00, 5.4440252157E+00, 7.8860857877E-01, 6.3348034472E-01, 6.9235310135E-01],
	[1.5760000000E+04, 7.8876054611E+00, 5.4437465789E+00, 7.8940193391E-01, 6.3401087913E-01, 6.9247886042E-01],
	[1.5765000000E+04, 7.8910844660E+00, 5.4434680448E+00, 7.9019583458E-01, 6.3454160827E-01, 6.9260458701E-01],
	[1.5770000000E+04, 7.8945639015E+00, 5.4431896133E+00, 7.9099028098E-01, 6.3507253202E-01, 6.9273028109E-01],
	[1.5775000000E+04, 7.8980437674E+00, 5.4429112842E+00, 7.9178527333E-01, 6.3560365026E-01, 6.9285594267E-01],
	[1.5780000000E+04, 7.9015240637E+00, 5.4426330576E+00, 7.9258081181E-01, 6.3613496285E-01, 6.9298157173E-01],
	[1.5785000000E+04, 7.9050047904E+00, 5.4423549334E+00, 7.9337689664E-01, 6.3666646969E-01, 6.9310716825E-01],
	[1.5790000000E+04, 7.9084888546E+00, 5.4420784066E+00, 7.9417352801E-01, 6.3719821001E-01, 6.9323273223E-01],
	[1.5795000000E+04, 7.9119822520E+00, 5.4418065567E+00, 7.9497070612E-01, 6.3773026510E-01, 6.9335826367E-01],
	[1.5800000000E+04, 7.9154760862E+00, 5.4415348064E+00, 7.9576843117E-01, 6.3826251448E-01, 6.9348376253E-01],
	[1.5805000000E+04, 7.9189703570E+00, 5.4412631557E+00, 7.9656670338E-01, 6.3879495804E-01, 6.9360922882E-01],
	[1.5810000000E+04, 7.9224650643E+00, 5.4409916045E+00, 7.9736552293E-01, 6.3932759564E-01, 6.9373466253E-01],
	[1.5815000000E+04, 7.9259602082E+00, 5.4407201527E+00, 7.9816489003E-01, 6.3986042716E-01, 6.9386006364E-01],
	[1.5820000000E+04, 7.9294557883E+00, 5.4404488002E+00, 7.9896480488E-01, 6.4039345249E-01, 6.9398543214E-01],
	[1.5825000000E+04, 7.9329518048E+00, 5.4401775470E+00, 7.9976526768E-01, 6.4092667149E-01, 6.9411076802E-01],
	[1.5830000000E+04, 7.9364482575E+00, 5.4399063931E+00, 8.0056627863E-01, 6.4146008405E-01, 6.9423607127E-01],
	[1.5835000000E+04, 7.9399451464E+00, 5.4396353382E+00, 8.0136783794E-01, 6.4199369003E-01, 6.9436134188E-01],
	[1.5840000000E+04, 7.9434424713E+00, 5.4393643825E+00, 8.0216994581E-01, 6.4252748932E-01, 6.9448657984E-01],
	[1.5845000000E+04, 7.9469402321E+00, 5.4390935257E+00, 8.0297260244E-01, 6.4306148179E-01, 6.9461178513E-01],
	[1.5850000000E+04, 7.9504384289E+00, 5.4388227679E+00, 8.0377580802E-01, 6.4359566733E-01, 6.9473695776E-01],
	[1.5855000000E+04, 7.9539370614E+00, 5.4385521089E+00, 8.0457956276E-01, 6.4413004579E-01, 6.9486209770E-01],
	[1.5860000000E+04, 7.9574361297E+00, 5.4382815488E+00, 8.0538386687E-01, 6.4466461706E-01, 6.9498720494E-01],
	[1.5865000000E+04, 7.9609356335E+00, 5.4380110873E+00, 8.0618872054E-01, 6.4519938102E-01, 6.9511227949E-01],
	[1.5870000000E+04, 7.9644355730E+00, 5.4377407246E+00, 8.0699412398E-01, 6.4573433754E-01, 6.9523732131E-01],
	[1.5875000000E+04, 7.9679359479E+00, 5.4374704605E+00, 8.0780007739E-01, 6.4626948650E-01, 6.9536233041E-01],
	[1.5880000000E+04, 7.9714367582E+00, 5.4372002949E+00, 8.0860658096E-01, 6.4680482777E-01, 6.9548730677E-01],
	[1.5885000000E+04, 7.9749380037E+00, 5.4369302277E+00, 8.0941363490E-01, 6.4734036122E-01, 6.9561225039E-01],
	[1.5890000000E+04, 7.9784396845E+00, 5.4366602590E+00, 8.1022123942E-01, 6.4787608673E-01, 6.9573716125E-01],
	[1.5895000000E+04, 7.9819418005E+00, 5.4363903886E+00, 8.1102939470E-01, 6.4841200418E-01, 6.9586203934E-01],
	[1.5900000000E+04, 7.9854443515E+00, 5.4361206164E+00, 8.1183810097E-01, 6.4894811345E-01, 6.9598688465E-01],
	[1.5905000000E+04, 7.9889473374E+00, 5.4358509425E+00, 8.1264735841E-01, 6.4948441440E-01, 6.9611169718E-01],
	[1.5910000000E+04, 7.9924507583E+00, 5.4355813667E+00, 8.1345716722E-01, 6.5002090691E-01, 6.9623647690E-01],
	[1.5915000000E+04, 7.9959546139E+00, 5.4353118890E+00, 8.1426752762E-01, 6.5055759085E-01, 6.9636122382E-01],
	[1.5920000000E+04, 7.9994589043E+00, 5.4350425093E+00, 8.1507843980E-01, 6.5109446610E-01, 6.9648593791E-01],
	[1.5925000000E+04, 8.0029636293E+00, 5.4347732275E+00, 8.1588990396E-01, 6.5163153254E-01, 6.9661061918E-01],
	[1.5930000000E+04, 8.0064687889E+00, 5.4345040435E+00, 8.1670192031E-01, 6.5216879004E-01, 6.9673526761E-01],
	[1.5935000000E+04, 8.0099743829E+00, 5.4342349574E+00, 8.1751448905E-01, 6.5270623847E-01, 6.9685988318E-01],
	[1.5940000000E+04, 8.0134804114E+00, 5.4339659690E+00, 8.1832761037E-01, 6.5324387770E-01, 6.9698446590E-01],
	[1.5945000000E+04, 8.0169868741E+00, 5.4336970783E+00, 8.1914128448E-01, 6.5378170762E-01, 6.9710901574E-01],
	[1.5950000000E+04, 8.0204937711E+00, 5.4334282852E+00, 8.1995551158E-01, 6.5431972809E-01, 6.9723353271E-01],
	[1.5955000000E+04, 8.0240011022E+00, 5.4331595896E+00, 8.2077029188E-01, 6.5485793899E-01, 6.9735801678E-01],
	[1.5960000000E+04, 8.0275088673E+00, 5.4328909915E+00, 8.2158562557E-01, 6.5539634019E-01, 6.9748246796E-01],
	[1.5965000000E+04, 8.0310170665E+00, 5.4326224908E+00, 8.2240151286E-01, 6.5593493156E-01, 6.9760688622E-01],
	[1.5970000000E+04, 8.0345256995E+00, 5.4323540875E+00, 8.2321795394E-01, 6.5647371298E-01, 6.9773127156E-01],
	[1.5975000000E+04, 8.0380347664E+00, 5.4320857814E+00, 8.2403494903E-01, 6.5701268433E-01, 6.9785562395E-01],
	[1.5980000000E+04, 8.0415442670E+00, 5.4318175726E+00, 8.2485249832E-01, 6.5755184547E-01, 6.9797994338E-01],
	[1.5985000000E+04, 8.0450542012E+00, 5.4315494608E+00, 8.2567060201E-01, 6.5809119627E-01, 6.9810422985E-01],
	[1.5990000000E+04, 8.0485645691E+00, 5.4312814462E+00, 8.2648926031E-01, 6.5863073662E-01, 6.9822848333E-01],
	[1.5995000000E+04, 8.0520753704E+00, 5.4310135286E+00, 8.2730847341E-01, 6.5917046638E-01, 6.9835270382E-01],
	[1.6000000000E+04, 8.0555866051E+00, 5.4307457079E+00, 8.2812824153E-01, 6.5971038543E-01, 6.9847689130E-01],
	[1.6005000000E+04, 8.0590982731E+00, 5.4304779841E+00, 8.2894856485E-01, 6.6025049363E-01, 6.9860104576E-01],
	[1.6010000000E+04, 8.0626103744E+00, 5.4302103571E+00, 8.2976944359E-01, 6.6079079087E-01, 6.9872516719E-01],
	[1.6015000000E+04, 8.0661229088E+00, 5.4299428268E+00, 8.3059087794E-01, 6.6133127701E-01, 6.9884925557E-01],
	[1.6020000000E+04, 8.0696358763E+00, 5.4296753933E+00, 8.3141286811E-01, 6.6187195193E-01, 6.9897331089E-01],
	[1.6025000000E+04, 8.0731492768E+00, 5.4294080564E+00, 8.3223541429E-01, 6.6241281550E-01, 6.9909733314E-01],
	[1.6030000000E+04, 8.0766631102E+00, 5.4291408160E+00, 8.3305851670E-01, 6.6295386759E-01, 6.9922132231E-01],
	[1.6035000000E+04, 8.0801773764E+00, 5.4288736721E+00, 8.3388217553E-01, 6.6349510807E-01, 6.9934527838E-01],
	[1.6040000000E+04, 8.0836920754E+00, 5.4286066246E+00, 8.3470639098E-01, 6.6403653681E-01, 6.9946920134E-01],
	[1.6045000000E+04, 8.0872122500E+00, 5.4283421242E+00, 8.3553116326E-01, 6.6457822448E-01, 6.9959309118E-01],
	[1.6050000000E+04, 8.0907400971E+00, 5.4280812343E+00, 8.3635649256E-01, 6.6512020203E-01, 6.9971694789E-01],
	[1.6055000000E+04, 8.0942683836E+00, 5.4278204383E+00, 8.3718237909E-01, 6.6566236790E-01, 6.9984077146E-01],
	[1.6060000000E+04, 8.0977971094E+00, 5.4275597359E+00, 8.3800882306E-01, 6.6620472197E-01, 6.9996456186E-01],
	[1.6065000000E+04, 8.1013262744E+00, 5.4272991272E+00, 8.3883582466E-01, 6.6674726411E-01, 7.0008831910E-01],
	[1.6070000000E+04, 8.1048558785E+00, 5.4270386122E+00, 8.3966338409E-01, 6.6728999419E-01, 7.0021204315E-01],
	[1.6075000000E+04, 8.1083859217E+00, 5.4267781907E+00, 8.4049150156E-01, 6.6783291209E-01, 7.0033573401E-01],
	[1.6080000000E+04, 8.1119164038E+00, 5.4265178626E+00, 8.4132017727E-01, 6.6837601766E-01, 7.0045939166E-01],
	[1.6085000000E+04, 8.1154473248E+00, 5.4262576280E+00, 8.4214941143E-01, 6.6891931080E-01, 7.0058301609E-01],
	[1.6090000000E+04, 8.1189786846E+00, 5.4259974867E+00, 8.4297920422E-01, 6.6946279136E-01, 7.0070660729E-01],
	[1.6095000000E+04, 8.1225104832E+00, 5.4257374387E+00, 8.4380955586E-01, 6.7000645922E-01, 7.0083016525E-01],
	[1.6100000000E+04, 8.1260427203E+00, 5.4254774840E+00, 8.4464046655E-01, 6.7055031425E-01, 7.0095368995E-01],
	[1.6105000000E+04, 8.1295753960E+00, 5.4252176224E+00, 8.4547193648E-01, 6.7109435633E-01, 7.0107718139E-01],
	[1.6110000000E+04, 8.1331085102E+00, 5.4249578539E+00, 8.4630396587E-01, 6.7163858531E-01, 7.0120063954E-01],
	[1.6115000000E+04, 8.1366420627E+00, 5.4246981785E+00, 8.4713655491E-01, 6.7218300108E-01, 7.0132406441E-01],
	[1.6120000000E+04, 8.1401760536E+00, 5.4244385961E+00, 8.4796970380E-01, 6.7272760350E-01, 7.0144745597E-01],
	[1.6125000000E+04, 8.1437104827E+00, 5.4241791065E+00, 8.4880341276E-01, 6.7327239245E-01, 7.0157081422E-01],
	[1.6130000000E+04, 8.1472453499E+00, 5.4239197099E+00, 8.4963768197E-01, 6.7381736779E-01, 7.0169413914E-01],
	[1.6135000000E+04, 8.1507806552E+00, 5.4236604060E+00, 8.5047251164E-01, 6.7436252940E-01, 7.0181743073E-01],
	[1.6140000000E+04, 8.1543163985E+00, 5.4234011948E+00, 8.5130790197E-01, 6.7490787715E-01, 7.0194068896E-01],
	[1.6145000000E+04, 8.1578525797E+00, 5.4231420764E+00, 8.5214385317E-01, 6.7545341090E-01, 7.0206391383E-01],
	[1.6150000000E+04, 8.1613891987E+00, 5.4228830505E+00, 8.5298036544E-01, 6.7599913053E-01, 7.0218710533E-01],
	[1.6155000000E+04, 8.1649262554E+00, 5.4226241172E+00, 8.5381743898E-01, 6.7654503590E-01, 7.0231026344E-01],
	[1.6160000000E+04, 8.1684637498E+00, 5.4223652763E+00, 8.5465507399E-01, 6.7709112690E-01, 7.0243338816E-01],
	[1.6165000000E+04, 8.1720016817E+00, 5.4221065279E+00, 8.5549327067E-01, 6.7763740338E-01, 7.0255647947E-01],
	[1.6170000000E+04, 8.1755400512E+00, 5.4218478719E+00, 8.5633202923E-01, 6.7818386522E-01, 7.0267953736E-01],
	[1.6175000000E+04, 8.1790788580E+00, 5.4215893081E+00, 8.5717134987E-01, 6.7873051228E-01, 7.0280256182E-01],
	[1.6180000000E+04, 8.1826181022E+00, 5.4213308366E+00, 8.5801123279E-01, 6.7927734444E-01, 7.0292555283E-01],
	[1.6185000000E+04, 8.1861577837E+00, 5.4210724573E+00, 8.5885167819E-01, 6.7982436157E-01, 7.0304851039E-01],
	[1.6190000000E+04, 8.1896979023E+00, 5.4208141701E+00, 8.5969268627E-01, 6.8037156353E-01, 7.0317143449E-01],
	[1.6195000000E+04, 8.1932384579E+00, 5.4205559749E+00, 8.6053425725E-01, 6.8091895020E-01, 7.0329432511E-01],
	[1.6200000000E+04, 8.1967794506E+00, 5.4202978718E+00, 8.6137639131E-01, 6.8146652144E-01, 7.0341718224E-01],
	[1.6205000000E+04, 8.2003208803E+00, 5.4200398606E+00, 8.6221908866E-01, 6.8201427713E-01, 7.0354000587E-01],
	[1.6210000000E+04, 8.2038627467E+00, 5.4197819412E+00, 8.6306234950E-01, 6.8256221713E-01, 7.0366279599E-01],
	[1.6215000000E+04, 8.2074050499E+00, 5.4195241137E+00, 8.6390617404E-01, 6.8311034131E-01, 7.0378555259E-01],
	[1.6220000000E+04, 8.2109477898E+00, 5.4192663779E+00, 8.6475056248E-01, 6.8365864953E-01, 7.0390827566E-01],
	[1.6225000000E+04, 8.2144909663E+00, 5.4190087338E+00, 8.6559551502E-01, 6.8420714168E-01, 7.0403096518E-01],
	[1.6230000000E+04, 8.2180345794E+00, 5.4187511813E+00, 8.6644103186E-01, 6.8475581762E-01, 7.0415362115E-01],
	[1.6235000000E+04, 8.2215786288E+00, 5.4184937204E+00, 8.6728711321E-01, 6.8530467721E-01, 7.0427624355E-01],
	[1.6240000000E+04, 8.2251231147E+00, 5.4182363510E+00, 8.6813375926E-01, 6.8585372032E-01, 7.0439883237E-01],
	[1.6245000000E+04, 8.2286680368E+00, 5.4179790730E+00, 8.6898097022E-01, 6.8640294683E-01, 7.0452138760E-01],
	[1.6250000000E+04, 8.2322133951E+00, 5.4177218865E+00, 8.6982874629E-01, 6.8695235660E-01, 7.0464390924E-01],
	[1.6255000000E+04, 8.2357591895E+00, 5.4174647912E+00, 8.7067708768E-01, 6.8750194950E-01, 7.0476639726E-01],
	[1.6260000000E+04, 8.2393054199E+00, 5.4172077872E+00, 8.7152599458E-01, 6.8805172540E-01, 7.0488885167E-01],
	[1.6265000000E+04, 8.2428520863E+00, 5.4169508745E+00, 8.7237546720E-01, 6.8860168416E-01, 7.0501127244E-01],
	[1.6270000000E+04, 8.2463991886E+00, 5.4166940528E+00, 8.7322550574E-01, 6.8915182566E-01, 7.0513365957E-01],
	[1.6275000000E+04, 8.2499467267E+00, 5.4164373223E+00, 8.7407611040E-01, 6.8970214975E-01, 7.0525601304E-01],
	[1.6280000000E+04, 8.2534947005E+00, 5.4161806827E+00, 8.7492728139E-01, 6.9025265632E-01, 7.0537833285E-01],
	[1.6285000000E+04, 8.2570431099E+00, 5.4159241342E+00, 8.7577901891E-01, 6.9080334522E-01, 7.0550061899E-01],
	[1.6290000000E+04, 8.2605919549E+00, 5.4156676765E+00, 8.7663132315E-01, 6.9135421633E-01, 7.0562287143E-01],
	[1.6295000000E+04, 8.2641412354E+00, 5.4154113097E+00, 8.7748419433E-01, 6.9190526951E-01, 7.0574509019E-01],
	[1.6300000000E+04, 8.2676909512E+00, 5.4151550337E+00, 8.7833763265E-01, 6.9245650462E-01, 7.0586727523E-01],
	[1.6305000000E+04, 8.2712507569E+00, 5.4149032861E+00, 8.7919163830E-01, 6.9300806200E-01, 7.0598942656E-01],
	[1.6310000000E+04, 8.2748141064E+00, 5.4146530531E+00, 8.8004621149E-01, 6.9355984661E-01, 7.0611154416E-01],
	[1.6315000000E+04, 8.2783778981E+00, 5.4144029085E+00, 8.8090135242E-01, 6.9411181321E-01, 7.0623362802E-01],
	[1.6320000000E+04, 8.2819421319E+00, 5.4141528520E+00, 8.8175706130E-01, 6.9466396170E-01, 7.0635567813E-01],
	[1.6325000000E+04, 8.2855068078E+00, 5.4139028836E+00, 8.8261333832E-01, 6.9521629192E-01, 7.0647769448E-01],
	[1.6330000000E+04, 8.2890719257E+00, 5.4136530034E+00, 8.8347018369E-01, 6.9576880375E-01, 7.0659967706E-01],
	[1.6335000000E+04, 8.2926374855E+00, 5.4134032112E+00, 8.8432759762E-01, 6.9632149706E-01, 7.0672162586E-01],
	[1.6340000000E+04, 8.2962034870E+00, 5.4131535069E+00, 8.8518558030E-01, 6.9687437171E-01, 7.0684354086E-01],
	[1.6345000000E+04, 8.2997699303E+00, 5.4129038905E+00, 8.8604413193E-01, 6.9742742758E-01, 7.0696542207E-01],
	[1.6350000000E+04, 8.3033368153E+00, 5.4126543621E+00, 8.8690325273E-01, 6.9798066452E-01, 7.0708726947E-01],
	[1.6355000000E+04, 8.3069041418E+00, 5.4124049213E+00, 8.8776294288E-01, 6.9853408240E-01, 7.0720908304E-01],
	[1.6360000000E+04, 8.3104719098E+00, 5.4121555684E+00, 8.8862320260E-01, 6.9908768109E-01, 7.0733086278E-01],
	[1.6365000000E+04, 8.3140401192E+00, 5.4119063031E+00, 8.8948403209E-01, 6.9964146046E-01, 7.0745260868E-01],
	[1.6370000000E+04, 8.3176087699E+00, 5.4116571254E+00, 8.9034543154E-01, 7.0019542038E-01, 7.0757432072E-01],
	[1.6375000000E+04, 8.3211778619E+00, 5.4114080353E+00, 8.9120740117E-01, 7.0074956070E-01, 7.0769599891E-01],
	[1.6380000000E+04, 8.3247473950E+00, 5.4111590327E+00, 8.9206994117E-01, 7.0130388130E-01, 7.0781764322E-01],
	[1.6385000000E+04, 8.3283173692E+00, 5.4109101176E+00, 8.9293305175E-01, 7.0185838204E-01, 7.0793925365E-01],
	[1.6390000000E+04, 8.3318877845E+00, 5.4106612898E+00, 8.9379673311E-01, 7.0241306280E-01, 7.0806083018E-01],
	[1.6395000000E+04, 8.3354586406E+00, 5.4104125494E+00, 8.9466098545E-01, 7.0296792342E-01, 7.0818237281E-01],
	[1.6400000000E+04, 8.3390299376E+00, 5.4101638963E+00, 8.9552580897E-01, 7.0352296379E-01, 7.0830388153E-01],
	[1.6405000000E+04, 8.3426016754E+00, 5.4099153303E+00, 8.9639120388E-01, 7.0407818377E-01, 7.0842535633E-01],
	[1.6410000000E+04, 8.3461738539E+00, 5.4096668516E+00, 8.9725717038E-01, 7.0463358321E-01, 7.0854679719E-01],
	[1.6415000000E+04, 8.3497464729E+00, 5.4094184599E+00, 8.9812370868E-01, 7.0518916200E-01, 7.0866820411E-01],
	[1.6420000000E+04, 8.3533195325E+00, 5.4091701553E+00, 8.9899081897E-01, 7.0574491999E-01, 7.0878957708E-01],
	[1.6425000000E+04, 8.3568930325E+00, 5.4089219377E+00, 8.9985850145E-01, 7.0630085705E-01, 7.0891091609E-01],
	[1.6430000000E+04, 8.3604669729E+00, 5.4086738070E+00, 9.0072675634E-01, 7.0685697304E-01, 7.0903222112E-01],
	[1.6435000000E+04, 8.3640413536E+00, 5.4084257632E+00, 9.0159558382E-01, 7.0741326784E-01, 7.0915349218E-01],
	[1.6440000000E+04, 8.3676161745E+00, 5.4081778062E+00, 9.0246498412E-01, 7.0796974130E-01, 7.0927472924E-01],
	[1.6445000000E+04, 8.3711914355E+00, 5.4079299360E+00, 9.0333495742E-01, 7.0852639329E-01, 7.0939593230E-01],
	[1.6450000000E+04, 8.3747671366E+00, 5.4076821525E+00, 9.0420550393E-01, 7.0908322367E-01, 7.0951710135E-01],
	[1.6455000000E+04, 8.3783432776E+00, 5.4074344556E+00, 9.0507662386E-01, 7.0964023232E-01, 7.0963823638E-01],
	[1.6460000000E+04, 8.3819198586E+00, 5.4071868454E+00, 9.0594831740E-01, 7.1019741909E-01, 7.0975933738E-01],
	[1.6465000000E+04, 8.3854968793E+00, 5.4069393216E+00, 9.0682058476E-01, 7.1075478385E-01, 7.0988040435E-01],
	[1.6470000000E+04, 8.3890743397E+00, 5.4066918844E+00, 9.0769342614E-01, 7.1131232647E-01, 7.1000143726E-01],
	[1.6475000000E+04, 8.3926522399E+00, 5.4064445336E+00, 9.0856684175E-01, 7.1187004681E-01, 7.1012243611E-01],
	[1.6480000000E+04, 8.3962305795E+00, 5.4061972691E+00, 9.0944083178E-01, 7.1242794473E-01, 7.1024340090E-01],
	[1.6485000000E+04, 8.3998093587E+00, 5.4059500910E+00, 9.1031539644E-01, 7.1298602010E-01, 7.1036433161E-01],
	[1.6490000000E+04, 8.4033885773E+00, 5.4057029991E+00, 9.1119053594E-01, 7.1354427278E-01, 7.1048522824E-01],
	[1.6495000000E+04, 8.4069682352E+00, 5.4054559934E+00, 9.1206625047E-01, 7.1410270264E-01, 7.1060609076E-01],
	[1.6500000000E+04, 8.4105483324E+00, 5.4052090738E+00, 9.1294254024E-01, 7.1466130954E-01, 7.1072691919E-01],
	[1.6505000000E+04, 8.4141288687E+00, 5.4049622404E+00, 9.1381940545E-01, 7.1522009334E-01, 7.1084771350E-01],
	[1.6510000000E+04, 8.4177098441E+00, 5.4047154929E+00, 9.1469684630E-01, 7.1577905392E-01, 7.1096847368E-01],
	[1.6515000000E+04, 8.4212912586E+00, 5.4044688315E+00, 9.1557486300E-01, 7.1633819113E-01, 7.1108919974E-01],
	[1.6520000000E+04, 8.4248731120E+00, 5.4042222560E+00, 9.1645345575E-01, 7.1689750483E-01, 7.1120989165E-01],
	[1.6525000000E+04, 8.4284554042E+00, 5.4039757663E+00, 9.1733262475E-01, 7.1745699490E-01, 7.1133054941E-01],
	[1.6530000000E+04, 8.4320381352E+00, 5.4037293624E+00, 9.1821237021E-01, 7.1801666119E-01, 7.1145117301E-01],
	[1.6535000000E+04, 8.4356213049E+00, 5.4034830443E+00, 9.1909269232E-01, 7.1857650356E-01, 7.1157176244E-01],
	[1.6540000000E+04, 8.4392049133E+00, 5.4032368119E+00, 9.1997359129E-01, 7.1913652189E-01, 7.1169231769E-01],
	[1.6545000000E+04, 8.4427889602E+00, 5.4029906651E+00, 9.2085506733E-01, 7.1969671603E-01, 7.1181283876E-01],
	[1.6550000000E+04, 8.4463734455E+00, 5.4027446039E+00, 9.2173712063E-01, 7.2025708585E-01, 7.1193332563E-01],
	[1.6555000000E+04, 8.4499583692E+00, 5.4024986282E+00, 9.2261975140E-01, 7.2081763121E-01, 7.1205377829E-01],
	[1.6560000000E+04, 8.4535437312E+00, 5.4022527380E+00, 9.2350295985E-01, 7.2137835198E-01, 7.1217419674E-01],
	[1.6565000000E+04, 8.4571331237E+00, 5.4020084972E+00, 9.2438674617E-01, 7.2193930212E-01, 7.1229458097E-01],
	[1.6570000000E+04, 8.4607326063E+00, 5.4017685403E+00, 9.2527111057E-01, 7.2250057302E-01, 7.1241493097E-01],
	[1.6575000000E+04, 8.4643325341E+00, 5.4015286664E+00, 9.2615605324E-01, 7.2306201939E-01, 7.1253524672E-01],
	[1.6580000000E+04, 8.4679329072E+00, 5.4012888755E+00, 9.2704157440E-01, 7.2362364111E-01, 7.1265552823E-01],
	[1.6585000000E+04, 8.4715337254E+00, 5.4010491676E+00, 9.2792767425E-01, 7.2418543804E-01, 7.1277577548E-01],
	[1.6590000000E+04, 8.4751349887E+00, 5.4008095426E+00, 9.2881435299E-01, 7.2474741004E-01, 7.1289598846E-01],
	[1.6595000000E+04, 8.4787366970E+00, 5.4005700004E+00, 9.2970161082E-01, 7.2530955697E-01, 7.1301616717E-01],
	[1.6600000000E+04, 8.4823388503E+00, 5.4003305410E+00, 9.3058944794E-01, 7.2587187869E-01, 7.1313631159E-01],
	[1.6605000000E+04, 8.4859414484E+00, 5.4000911643E+00, 9.3147786457E-01, 7.2643437507E-01, 7.1325642172E-01],
	[1.6610000000E+04, 8.4895444912E+00, 5.3998518703E+00, 9.3236686089E-01, 7.2699704598E-01, 7.1337649755E-01],
	[1.6615000000E+04, 8.4931479788E+00, 5.3996126589E+00, 9.3325643712E-01, 7.2755989127E-01, 7.1349653906E-01],
	[1.6620000000E+04, 8.4967519109E+00, 5.3993735301E+00, 9.3414659346E-01, 7.2812291081E-01, 7.1361654626E-01],
	[1.6625000000E+04, 8.5003562876E+00, 5.3991344838E+00, 9.3503733010E-01, 7.2868610445E-01, 7.1373651914E-01],
	[1.6630000000E+04, 8.5039611087E+00, 5.3988955199E+00, 9.3592864726E-01, 7.2924947207E-01, 7.1385645768E-01],
	[1.6635000000E+04, 8.5075663742E+00, 5.3986566385E+00, 9.3682054514E-01, 7.2981301352E-01, 7.1397636187E-01],
	[1.6640000000E+04, 8.5111720840E+00, 5.3984178394E+00, 9.3771302394E-01, 7.3037672867E-01, 7.1409623171E-01],
	[1.6645000000E+04, 8.5147782380E+00, 5.3981791226E+00, 9.3860608385E-01, 7.3094061737E-01, 7.1421606720E-01],
	[1.6650000000E+04, 8.5183848362E+00, 5.3979404881E+00, 9.3949972510E-01, 7.3150467950E-01, 7.1433586831E-01],
	[1.6655000000E+04, 8.5219918784E+00, 5.3977019358E+00, 9.4039394787E-01, 7.3206891491E-01, 7.1445563505E-01],
	[1.6660000000E+04, 8.5255993646E+00, 5.3974634656E+00, 9.4128875237E-01, 7.3263332346E-01, 7.1457536740E-01],
	[1.6665000000E+04, 8.5292072946E+00, 5.3972250775E+00, 9.4218413881E-01, 7.3319790502E-01, 7.1469506535E-01],
	[1.6670000000E+04, 8.5328156685E+00, 5.3969867714E+00, 9.4308010739E-01, 7.3376265944E-01, 7.1481472891E-01],
	[1.6675000000E+04, 8.5364244862E+00, 5.3967485473E+00, 9.4397665831E-01, 7.3432758660E-01, 7.1493435805E-01],
	[1.6680000000E+04, 8.5400337475E+00, 5.3965104052E+00, 9.4487379177E-01, 7.3489268635E-01, 7.1505395278E-01],
	[1.6685000000E+04, 8.5436434524E+00, 5.3962723449E+00, 9.4577150798E-01, 7.3545795855E-01, 7.1517351308E-01],
	[1.6690000000E+04, 8.5472536007E+00, 5.3960343664E+00, 9.4666980714E-01, 7.3602340306E-01, 7.1529303895E-01],
	[1.6695000000E+04, 8.5508641926E+00, 5.3957964698E+00, 9.4756868945E-01, 7.3658901975E-01, 7.1541253038E-01],
	[1.6700000000E+04, 8.5544752277E+00, 5.3955586548E+00, 9.4846815512E-01, 7.3715480847E-01, 7.1553198735E-01],
	[1.6705000000E+04, 8.5580867062E+00, 5.3953209215E+00, 9.4936820435E-01, 7.3772076910E-01, 7.1565140987E-01],
	[1.6710000000E+04, 8.5616986278E+00, 5.3950832699E+00, 9.5026883734E-01, 7.3828690148E-01, 7.1577079792E-01],
	[1.6715000000E+04, 8.5653109925E+00, 5.3948456998E+00, 9.5117005430E-01, 7.3885320548E-01, 7.1589015149E-01],
	[1.6720000000E+04, 8.5689238003E+00, 5.3946082112E+00, 9.5207185542E-01, 7.3941968096E-01, 7.1600947059E-01],
	[1.6725000000E+04, 8.5725370511E+00, 5.3943708040E+00, 9.5297424092E-01, 7.3998632778E-01, 7.1612875519E-01],
	[1.6730000000E+04, 8.5761507447E+00, 5.3941334783E+00, 9.5387721100E-01, 7.4055314580E-01, 7.1624800530E-01],
	[1.6735000000E+04, 8.5797648811E+00, 5.3938962339E+00, 9.5478076585E-01, 7.4112013489E-01, 7.1636722090E-01],
	[1.6740000000E+04, 8.5833794603E+00, 5.3936590708E+00, 9.5568490569E-01, 7.4168729490E-01, 7.1648640199E-01],
	[1.6745000000E+04, 8.5869944821E+00, 5.3934219890E+00, 9.5658963071E-01, 7.4225462569E-01, 7.1660554855E-01],
	[1.6750000000E+04, 8.5906099464E+00, 5.3931849884E+00, 9.5749494112E-01, 7.4282212713E-01, 7.1672466059E-01],
	[1.6755000000E+04, 8.5942258533E+00, 5.3929480689E+00, 9.5840083712E-01, 7.4338979907E-01, 7.1684373809E-01],
	[1.6760000000E+04, 8.5978422025E+00, 5.3927112305E+00, 9.5930731892E-01, 7.4395764138E-01, 7.1696278105E-01],
	[1.6765000000E+04, 8.6014589941E+00, 5.3924744732E+00, 9.6021438672E-01, 7.4452565391E-01, 7.1708178946E-01],
	[1.6770000000E+04, 8.6050762280E+00, 5.3922377968E+00, 9.6112204071E-01, 7.4509383652E-01, 7.1720076330E-01],
	[1.6775000000E+04, 8.6086939040E+00, 5.3920012014E+00, 9.6203028112E-01, 7.4566218908E-01, 7.1731970258E-01],
	[1.6780000000E+04, 8.6123120221E+00, 5.3917646869E+00, 9.6293910813E-01, 7.4623071145E-01, 7.1743860729E-01],
	[1.6785000000E+04, 8.6159305823E+00, 5.3915282532E+00, 9.6384852195E-01, 7.4679940348E-01, 7.1755747741E-01],
	[1.6790000000E+04, 8.6195495844E+00, 5.3912919003E+00, 9.6475852279E-01, 7.4736826503E-01, 7.1767631295E-01],
	[1.6795000000E+04, 8.6231690284E+00, 5.3910556281E+00, 9.6566911084E-01, 7.4793729597E-01, 7.1779511389E-01],
	[1.6800000000E+04, 8.6267889141E+00, 5.3908194366E+00, 9.6658028632E-01, 7.4850649614E-01, 7.1791388022E-01],
	[1.6805000000E+04, 8.6304092416E+00, 5.3905833257E+00, 9.6749204942E-01, 7.4907586543E-01, 7.1803261194E-01],
	[1.6810000000E+04, 8.6340300107E+00, 5.3903472954E+00, 9.6840440035E-01, 7.4964540367E-01, 7.1815130905E-01],
	[1.6815000000E+04, 8.6376512214E+00, 5.3901113456E+00, 9.6931733932E-01, 7.5021511074E-01, 7.1826997153E-01],
	[1.6820000000E+04, 8.6412728735E+00, 5.3898754763E+00, 9.7023086651E-01, 7.5078498649E-01, 7.1838859937E-01],
	[1.6825000000E+04, 8.6448949671E+00, 5.3896396875E+00, 9.7114498215E-01, 7.5135503077E-01, 7.1850719258E-01],
	[1.6830000000E+04, 8.6485175019E+00, 5.3894039789E+00, 9.7205968643E-01, 7.5192524346E-01, 7.1862575113E-01],
	[1.6835000000E+04, 8.6521533997E+00, 5.3891736808E+00, 9.7297497955E-01, 7.5249582606E-01, 7.1874427503E-01],
	[1.6840000000E+04, 8.6557905574E+00, 5.3889437957E+00, 9.7389086172E-01, 7.5306658994E-01, 7.1886276426E-01],
	[1.6845000000E+04, 8.6594281636E+00, 5.3887139885E+00, 9.7480733314E-01, 7.5363752231E-01, 7.1898121880E-01],
	[1.6850000000E+04, 8.6630662183E+00, 5.3884842594E+00, 9.7572439402E-01, 7.5420862302E-01, 7.1909963866E-01],
	[1.6855000000E+04, 8.6667047214E+00, 5.3882546082E+00, 9.7664204456E-01, 7.5477989194E-01, 7.1921802382E-01],
	[1.6860000000E+04, 8.6703436728E+00, 5.3880250349E+00, 9.7756028496E-01, 7.5535132891E-01, 7.1933637427E-01],
	[1.6865000000E+04, 8.6739830724E+00, 5.3877955395E+00, 9.7847911543E-01, 7.5592293381E-01, 7.1945469000E-01],
	[1.6870000000E+04, 8.6776229201E+00, 5.3875661218E+00, 9.7939853616E-01, 7.5649470649E-01, 7.1957297101E-01],
	[1.6875000000E+04, 8.6812632160E+00, 5.3873367819E+00, 9.8031854737E-01, 7.5706664681E-01, 7.1969121728E-01],
	[1.6880000000E+04, 8.6849039598E+00, 5.3871075197E+00, 9.8123914926E-01, 7.5763875463E-01, 7.1980942880E-01],
	[1.6885000000E+04, 8.6885451515E+00, 5.3868783352E+00, 9.8216034202E-01, 7.5821102981E-01, 7.1992760557E-01],
	[1.6890000000E+04, 8.6921867911E+00, 5.3866492283E+00, 9.8308212587E-01, 7.5878347220E-01, 7.2004574758E-01],
	[1.6895000000E+04, 8.6958288784E+00, 5.3864201989E+00, 9.8400450100E-01, 7.5935608167E-01, 7.2016385481E-01],
	[1.6900000000E+04, 8.6994714134E+00, 5.3861912470E+00, 9.8492746763E-01, 7.5992885807E-01, 7.2028192726E-01],
	[1.6905000000E+04, 8.7031143961E+00, 5.3859623726E+00, 9.8585102595E-01, 7.6050180126E-01, 7.2039996492E-01],
	[1.6910000000E+04, 8.7067578262E+00, 5.3857335755E+00, 9.8677517616E-01, 7.6107491110E-01, 7.2051796778E-01],
	[1.6915000000E+04, 8.7104017038E+00, 5.3855048559E+00, 9.8769991848E-01, 7.6164818745E-01, 7.2063593584E-01],
	[1.6920000000E+04, 8.7140460288E+00, 5.3852762135E+00, 9.8862525310E-01, 7.6222163017E-01, 7.2075386907E-01],
	[1.6925000000E+04, 8.7176908010E+00, 5.3850476484E+00, 9.8955118023E-01, 7.6279523911E-01, 7.2087176748E-01],
	[1.6930000000E+04, 8.7213360205E+00, 5.3848191605E+00, 9.9047770008E-01, 7.6336901414E-01, 7.2098963105E-01],
	[1.6935000000E+04, 8.7249816872E+00, 5.3845907498E+00, 9.9140481283E-01, 7.6394295510E-01, 7.2110745978E-01],
	[1.6940000000E+04, 8.7286278008E+00, 5.3843624162E+00, 9.9233251871E-01, 7.6451706187E-01, 7.2122525365E-01],
	[1.6945000000E+04, 8.7322743615E+00, 5.3841341596E+00, 9.9326081791E-01, 7.6509133429E-01, 7.2134301266E-01],
	[1.6950000000E+04, 8.7359213691E+00, 5.3839059801E+00, 9.9418971063E-01, 7.6566577222E-01, 7.2146073680E-01],
	[1.6955000000E+04, 8.7395688235E+00, 5.3836778775E+00, 9.9511919709E-01, 7.6624037553E-01, 7.2157842606E-01],
	[1.6960000000E+04, 8.7432167247E+00, 5.3834498519E+00, 9.9604927748E-01, 7.6681514407E-01, 7.2169608044E-01],
	[1.6965000000E+04, 8.7468650726E+00, 5.3832219031E+00, 9.9697995200E-01, 7.6739007769E-01, 7.2181369991E-01],
	[1.6970000000E+04, 8.7505138670E+00, 5.3829940311E+00, 9.9791122087E-01, 7.6796517626E-01, 7.2193128449E-01],
	[1.6975000000E+04, 8.7541631080E+00, 5.3827662359E+00, 9.9884308428E-01, 7.6854043962E-01, 7.2204883414E-01],
	[1.6980000000E+04, 8.7578127954E+00, 5.3825385174E+00, 9.9977554244E-01, 7.6911586765E-01, 7.2216634888E-01],
	[1.6985000000E+04, 8.7614629293E+00, 5.3823108756E+00, 1.0007085955E+00, 7.6969146020E-01, 7.2228382868E-01],
	[1.6990000000E+04, 8.7651135093E+00, 5.3820833105E+00, 1.0016422438E+00, 7.7026721711E-01, 7.2240127354E-01],
	[1.6995000000E+04, 8.7687645357E+00, 5.3818558219E+00, 1.0025764874E+00, 7.7084313826E-01, 7.2251868346E-01],
	[1.7000000000E+04, 8.7724160081E+00, 5.3816284098E+00, 1.0035113266E+00, 7.7141922350E-01, 7.2263605842E-01],
	[1.7005000000E+04, 8.7760679266E+00, 5.3814010742E+00, 1.0044467616E+00, 7.7199547268E-01, 7.2275339841E-01],
	[1.7010000000E+04, 8.7797202911E+00, 5.3811738151E+00, 1.0053827925E+00, 7.7257188566E-01, 7.2287070344E-01],
	[1.7015000000E+04, 8.7833731016E+00, 5.3809466323E+00, 1.0063194196E+00, 7.7314846230E-01, 7.2298797348E-01],
	[1.7020000000E+04, 8.7870263578E+00, 5.3807195259E+00, 1.0072566431E+00, 7.7372520245E-01, 7.2310520853E-01],
	[1.7025000000E+04, 8.7906800598E+00, 5.3804924957E+00, 1.0081944631E+00, 7.7430210598E-01, 7.2322240858E-01],
	[1.7030000000E+04, 8.7943342075E+00, 5.3802655418E+00, 1.0091328800E+00, 7.7487917273E-01, 7.2333957363E-01],
	[1.7035000000E+04, 8.7979888008E+00, 5.3800386641E+00, 1.0100718938E+00, 7.7545640256E-01, 7.2345670366E-01],
	[1.7040000000E+04, 8.8016438396E+00, 5.3798118626E+00, 1.0110115048E+00, 7.7603379534E-01, 7.2357379867E-01],
	[1.7045000000E+04, 8.8052993239E+00, 5.3795851371E+00, 1.0119517133E+00, 7.7661135092E-01, 7.2369085865E-01],
	[1.7050000000E+04, 8.8089552535E+00, 5.3793584877E+00, 1.0128925193E+00, 7.7718906914E-01, 7.2380788359E-01],
	[1.7055000000E+04, 8.8126116285E+00, 5.3791319143E+00, 1.0138339231E+00, 7.7776694988E-01, 7.2392487348E-01],
	[1.7060000000E+04, 8.8162684487E+00, 5.3789054168E+00, 1.0147759250E+00, 7.7834499298E-01, 7.2404182832E-01],
	[1.7065000000E+04, 8.8199257140E+00, 5.3786789952E+00, 1.0157185250E+00, 7.7892319831E-01, 7.2415874810E-01],
	[1.7070000000E+04, 8.8235834244E+00, 5.3784526495E+00, 1.0166617235E+00, 7.7950156571E-01, 7.2427563280E-01],
	[1.7075000000E+04, 8.8272415797E+00, 5.3782263796E+00, 1.0176055206E+00, 7.8008009504E-01, 7.2439248243E-01],
	[1.7080000000E+04, 8.8309001800E+00, 5.3780001855E+00, 1.0185499165E+00, 7.8065878616E-01, 7.2450929697E-01],
	[1.7085000000E+04, 8.8345592252E+00, 5.3777740671E+00, 1.0194949114E+00, 7.8123763893E-01, 7.2462607642E-01],
	[1.7090000000E+04, 8.8382187151E+00, 5.3775480244E+00, 1.0204405056E+00, 7.8181665320E-01, 7.2474282077E-01],
	[1.7095000000E+04, 8.8418786497E+00, 5.3773220572E+00, 1.0213866992E+00, 7.8239582882E-01, 7.2485953000E-01],
	[1.7100000000E+04, 8.8455390289E+00, 5.3770961657E+00, 1.0223334924E+00, 7.8297516566E-01, 7.2497620412E-01],
	[1.7105000000E+04, 8.8492105533E+00, 5.3768745370E+00, 1.0232808855E+00, 7.8355483638E-01, 7.2509284311E-01],
	[1.7110000000E+04, 8.8528860590E+00, 5.3766543633E+00, 1.0242288786E+00, 7.8413472550E-01, 7.2520944697E-01],
	[1.7115000000E+04, 8.8565620167E+00, 5.3764342629E+00, 1.0251774720E+00, 7.8471477593E-01, 7.2532601569E-01],
	[1.7120000000E+04, 8.8602384264E+00, 5.3762142359E+00, 1.0261266658E+00, 7.8529498753E-01, 7.2544254926E-01],
	[1.7125000000E+04, 8.8639152880E+00, 5.3759942821E+00, 1.0270764603E+00, 7.8587536014E-01, 7.2555904767E-01],
	[1.7130000000E+04, 8.8675926013E+00, 5.3757744015E+00, 1.0280268557E+00, 7.8645589363E-01, 7.2567551093E-01],
	[1.7135000000E+04, 8.8712703663E+00, 5.3755545941E+00, 1.0289778521E+00, 7.8703658785E-01, 7.2579193901E-01],
	[1.7140000000E+04, 8.8749485830E+00, 5.3753348597E+00, 1.0299294498E+00, 7.8761744266E-01, 7.2590833191E-01],
	[1.7145000000E+04, 8.8786272513E+00, 5.3751151985E+00, 1.0308816490E+00, 7.8819845791E-01, 7.2602468963E-01],
	[1.7150000000E+04, 8.8823063710E+00, 5.3748956103E+00, 1.0318344498E+00, 7.8877963346E-01, 7.2614101215E-01],
	[1.7155000000E+04, 8.8859859422E+00, 5.3746760950E+00, 1.0327878526E+00, 7.8936096916E-01, 7.2625729947E-01],
	[1.7160000000E+04, 8.8896659647E+00, 5.3744566527E+00, 1.0337418574E+00, 7.8994246487E-01, 7.2637355159E-01],
	[1.7165000000E+04, 8.8933464384E+00, 5.3742372832E+00, 1.0346964645E+00, 7.9052412044E-01, 7.2648976849E-01],
	[1.7170000000E+04, 8.8970273634E+00, 5.3740179867E+00, 1.0356516741E+00, 7.9110593573E-01, 7.2660595016E-01],
	[1.7175000000E+04, 8.9007087394E+00, 5.3737987629E+00, 1.0366074864E+00, 7.9168791059E-01, 7.2672209661E-01],
	[1.7180000000E+04, 8.9043905665E+00, 5.3735796118E+00, 1.0375639016E+00, 7.9227004488E-01, 7.2683820782E-01],
	[1.7185000000E+04, 8.9080728445E+00, 5.3733605335E+00, 1.0385209199E+00, 7.9285233845E-01, 7.2695428379E-01],
	[1.7190000000E+04, 8.9117555734E+00, 5.3731415278E+00, 1.0394785415E+00, 7.9343479116E-01, 7.2707032450E-01],
	[1.7195000000E+04, 8.9154387531E+00, 5.3729225947E+00, 1.0404367667E+00, 7.9401740287E-01, 7.2718632996E-01],
	[1.7200000000E+04, 8.9191223836E+00, 5.3727037342E+00, 1.0413955955E+00, 7.9460017341E-01, 7.2730230015E-01],
	[1.7205000000E+04, 8.9228064646E+00, 5.3724849463E+00, 1.0423550283E+00, 7.9518310267E-01, 7.2741823507E-01],
	[1.7210000000E+04, 8.9264909963E+00, 5.3722662308E+00, 1.0433150652E+00, 7.9576619047E-01, 7.2753413471E-01],
	[1.7215000000E+04, 8.9301759785E+00, 5.3720475877E+00, 1.0442757065E+00, 7.9634943669E-01, 7.2764999906E-01],
	[1.7220000000E+04, 8.9338614110E+00, 5.3718290170E+00, 1.0452369522E+00, 7.9693284117E-01, 7.2776582812E-01],
	[1.7225000000E+04, 8.9375472940E+00, 5.3716105187E+00, 1.0461988028E+00, 7.9751640377E-01, 7.2788162187E-01],
	[1.7230000000E+04, 8.9412336272E+00, 5.3713920927E+00, 1.0471612582E+00, 7.9810012435E-01, 7.2799738032E-01],
	[1.7235000000E+04, 8.9449204106E+00, 5.3711737389E+00, 1.0481243188E+00, 7.9868400275E-01, 7.2811310346E-01],
	[1.7240000000E+04, 8.9486076441E+00, 5.3709554573E+00, 1.0490879848E+00, 7.9926803883E-01, 7.2822879127E-01],
	[1.7245000000E+04, 8.9522953276E+00, 5.3707372479E+00, 1.0500522563E+00, 7.9985223245E-01, 7.2834444376E-01],
	[1.7250000000E+04, 8.9559834612E+00, 5.3705191107E+00, 1.0510171336E+00, 8.0043658346E-01, 7.2846006091E-01],
	[1.7255000000E+04, 8.9596720446E+00, 5.3703010454E+00, 1.0519826168E+00, 8.0102109171E-01, 7.2857564272E-01],
	[1.7260000000E+04, 8.9633610778E+00, 5.3700830523E+00, 1.0529487062E+00, 8.0160575706E-01, 7.2869118918E-01],
	[1.7265000000E+04, 8.9670505608E+00, 5.3698651311E+00, 1.0539154020E+00, 8.0219057936E-01, 7.2880670029E-01],
	[1.7270000000E+04, 8.9707404935E+00, 5.3696472818E+00, 1.0548827044E+00, 8.0277555847E-01, 7.2892217604E-01],
	[1.7275000000E+04, 8.9744308757E+00, 5.3694295045E+00, 1.0558506135E+00, 8.0336069423E-01, 7.2903761641E-01],
	[1.7280000000E+04, 8.9781217075E+00, 5.3692117990E+00, 1.0568191296E+00, 8.0394598651E-01, 7.2915302142E-01],
	[1.7285000000E+04, 8.9818129887E+00, 5.3689941653E+00, 1.0577882530E+00, 8.0453143515E-01, 7.2926839104E-01],
	[1.7290000000E+04, 8.9855047193E+00, 5.3687766034E+00, 1.0587579837E+00, 8.0511704001E-01, 7.2938372527E-01],
	[1.7295000000E+04, 8.9891968991E+00, 5.3685591132E+00, 1.0597283220E+00, 8.0570280094E-01, 7.2949902411E-01],
	[1.7300000000E+04, 8.9928895282E+00, 5.3683416946E+00, 1.0606992681E+00, 8.0628871779E-01, 7.2961428755E-01],
	[1.7305000000E+04, 8.9965826064E+00, 5.3681243477E+00, 1.0616708222E+00, 8.0687479043E-01, 7.2972951558E-01],
	[1.7310000000E+04, 9.0002761337E+00, 5.3679070724E+00, 1.0626429846E+00, 8.0746101869E-01, 7.2984470820E-01],
	[1.7315000000E+04, 9.0039701100E+00, 5.3676898686E+00, 1.0636157553E+00, 8.0804740244E-01, 7.2995986540E-01],
	[1.7320000000E+04, 9.0076645352E+00, 5.3674727363E+00, 1.0645891347E+00, 8.0863394153E-01, 7.3007498717E-01],
	[1.7325000000E+04, 9.0113594092E+00, 5.3672556755E+00, 1.0655631229E+00, 8.0922063581E-01, 7.3019007351E-01],
	[1.7330000000E+04, 9.0150547320E+00, 5.3670386861E+00, 1.0665377201E+00, 8.0980748514E-01, 7.3030512441E-01],
	[1.7335000000E+04, 9.0187505034E+00, 5.3668217680E+00, 1.0675129265E+00, 8.1039448935E-01, 7.3042013986E-01],
	[1.7340000000E+04, 9.0224467235E+00, 5.3666049213E+00, 1.0684887424E+00, 8.1098164832E-01, 7.3053511986E-01],
	[1.7345000000E+04, 9.0261433922E+00, 5.3663881458E+00, 1.0694651680E+00, 8.1156896189E-01, 7.3065006441E-01],
	[1.7350000000E+04, 9.0298405093E+00, 5.3661714416E+00, 1.0704422033E+00, 8.1215642992E-01, 7.3076497349E-01],
	[1.7355000000E+04, 9.0335380748E+00, 5.3659548086E+00, 1.0714198488E+00, 8.1274405225E-01, 7.3087984711E-01],
	[1.7360000000E+04, 9.0372360886E+00, 5.3657382467E+00, 1.0723981045E+00, 8.1333182874E-01, 7.3099468524E-01],
	[1.7365000000E+04, 9.0409345506E+00, 5.3655217559E+00, 1.0733769706E+00, 8.1391975925E-01, 7.3110948790E-01],
	[1.7370000000E+04, 9.0446334608E+00, 5.3653053362E+00, 1.0743564474E+00, 8.1450784361E-01, 7.3122425506E-01],
	[1.7375000000E+04, 9.0483328191E+00, 5.3650889874E+00, 1.0753365351E+00, 8.1509608170E-01, 7.3133898674E-01],
	[1.7380000000E+04, 9.0520428004E+00, 5.3648764905E+00, 1.0763172338E+00, 8.1568464337E-01, 7.3145368291E-01],
	[1.7385000000E+04, 9.0557577947E+00, 5.3646657567E+00, 1.0772985439E+00, 8.1627343510E-01, 7.3156834358E-01],
	[1.7390000000E+04, 9.0594732447E+00, 5.3644550917E+00, 1.0782804654E+00, 8.1686238066E-01, 7.3168296873E-01],
	[1.7395000000E+04, 9.0631891503E+00, 5.3642444955E+00, 1.0792629986E+00, 8.1745147990E-01, 7.3179755837E-01],
	[1.7400000000E+04, 9.0669055114E+00, 5.3640339682E+00, 1.0802461436E+00, 8.1804073266E-01, 7.3191211249E-01],
	[1.7405000000E+04, 9.0706223281E+00, 5.3638235096E+00, 1.0812299008E+00, 8.1863013881E-01, 7.3202663107E-01],
	[1.7410000000E+04, 9.0743396001E+00, 5.3636131197E+00, 1.0822142703E+00, 8.1921969820E-01, 7.3214111412E-01],
	[1.7415000000E+04, 9.0780573275E+00, 5.3634027984E+00, 1.0831992523E+00, 8.1980941067E-01, 7.3225556163E-01],
	[1.7420000000E+04, 9.0817755101E+00, 5.3631925458E+00, 1.0841848470E+00, 8.2039927608E-01, 7.3236997360E-01],
	[1.7425000000E+04, 9.0854941478E+00, 5.3629823618E+00, 1.0851710546E+00, 8.2098929429E-01, 7.3248435001E-01],
	[1.7430000000E+04, 9.0892132407E+00, 5.3627722462E+00, 1.0861578753E+00, 8.2157946514E-01, 7.3259869086E-01],
	[1.7435000000E+04, 9.0929327886E+00, 5.3625621992E+00, 1.0871453093E+00, 8.2216978849E-01, 7.3271299615E-01],
	[1.7440000000E+04, 9.0966527914E+00, 5.3623522207E+00, 1.0881333569E+00, 8.2276026418E-01, 7.3282726587E-01],
	[1.7445000000E+04, 9.1003732491E+00, 5.3621423105E+00, 1.0891220182E+00, 8.2335089208E-01, 7.3294150002E-01],
	[1.7450000000E+04, 9.1040941617E+00, 5.3619324687E+00, 1.0901112934E+00, 8.2394167203E-01, 7.3305569859E-01],
	[1.7455000000E+04, 9.1078155289E+00, 5.3617226953E+00, 1.0911011828E+00, 8.2453260388E-01, 7.3316986157E-01],
	[1.7460000000E+04, 9.1115373508E+00, 5.3615129901E+00, 1.0920916865E+00, 8.2512368749E-01, 7.3328398896E-01],
	[1.7465000000E+04, 9.1152596272E+00, 5.3613033532E+00, 1.0930828047E+00, 8.2571492271E-01, 7.3339808075E-01],
	[1.7470000000E+04, 9.1189823581E+00, 5.3610937844E+00, 1.0940745378E+00, 8.2630630938E-01, 7.3351213694E-01],
	[1.7475000000E+04, 9.1227055435E+00, 5.3608842839E+00, 1.0950668857E+00, 8.2689784737E-01, 7.3362615753E-01],
	[1.7480000000E+04, 9.1264291832E+00, 5.3606748514E+00, 1.0960598489E+00, 8.2748953652E-01, 7.3374014250E-01],
	[1.7485000000E+04, 9.1301532772E+00, 5.3604654871E+00, 1.0970534274E+00, 8.2808137669E-01, 7.3385409185E-01],
	[1.7490000000E+04, 9.1338778254E+00, 5.3602561907E+00, 1.0980476215E+00, 8.2867336772E-01, 7.3396800558E-01],
	[1.7495000000E+04, 9.1376028277E+00, 5.3600469624E+00, 1.0990424313E+00, 8.2926550946E-01, 7.3408188369E-01],
	[1.7500000000E+04, 9.1413282841E+00, 5.3598378020E+00, 1.1000378572E+00, 8.2985780178E-01, 7.3419572615E-01],
	[1.7505000000E+04, 9.1450541944E+00, 5.3596287095E+00, 1.1010418971E+00, 8.3045479444E-01, 7.3430953298E-01],
	[1.7510000000E+04, 9.1487805587E+00, 5.3594196849E+00, 1.1020465658E+00, 8.3105194083E-01, 7.3442330417E-01],
	[1.7515000000E+04, 9.1525073767E+00, 5.3592107281E+00, 1.1030518632E+00, 8.3164924082E-01, 7.3453703970E-01],
	[1.7520000000E+04, 9.1562346486E+00, 5.3590018391E+00, 1.1040577898E+00, 8.3224669425E-01, 7.3465073959E-01],
	[1.7525000000E+04, 9.1599623741E+00, 5.3587930178E+00, 1.1050643457E+00, 8.3284430097E-01, 7.3476440381E-01],
	[1.7530000000E+04, 9.1636905532E+00, 5.3585842642E+00, 1.1060715310E+00, 8.3344206082E-01, 7.3487803237E-01],
	[1.7535000000E+04, 9.1674191858E+00, 5.3583755784E+00, 1.1070793461E+00, 8.3403997365E-01, 7.3499162525E-01],
	[1.7540000000E+04, 9.1711482719E+00, 5.3581669601E+00, 1.1080877911E+00, 8.3463803931E-01, 7.3510518247E-01],
	[1.7545000000E+04, 9.1748778114E+00, 5.3579584094E+00, 1.1090968663E+00, 8.3523625765E-01, 7.3521870400E-01],
	[1.7550000000E+04, 9.1786078042E+00, 5.3577499262E+00, 1.1101065718E+00, 8.3583462851E-01, 7.3533218985E-01],
	[1.7555000000E+04, 9.1823382502E+00, 5.3575415106E+00, 1.1111169079E+00, 8.3643315175E-01, 7.3544564001E-01],
	[1.7560000000E+04, 9.1860691494E+00, 5.3573331624E+00, 1.1121278748E+00, 8.3703182720E-01, 7.3555905448E-01],
	[1.7565000000E+04, 9.1898005016E+00, 5.3571248816E+00, 1.1131394726E+00, 8.3763065473E-01, 7.3567243325E-01],
	[1.7570000000E+04, 9.1935323069E+00, 5.3569166682E+00, 1.1141517017E+00, 8.3822963417E-01, 7.3578577631E-01],
	[1.7575000000E+04, 9.1972645651E+00, 5.3567085221E+00, 1.1151645622E+00, 8.3882876537E-01, 7.3589908367E-01],
	[1.7580000000E+04, 9.2009972762E+00, 5.3565004433E+00, 1.1161780543E+00, 8.3942804818E-01, 7.3601235531E-01],
	[1.7585000000E+04, 9.2047304401E+00, 5.3562924317E+00, 1.1171921783E+00, 8.4002748245E-01, 7.3612559123E-01],
	[1.7590000000E+04, 9.2084640567E+00, 5.3560844874E+00, 1.1182069344E+00, 8.4062706802E-01, 7.3623879143E-01],
	[1.7595000000E+04, 9.2121981259E+00, 5.3558766103E+00, 1.1192223227E+00, 8.4122680475E-01, 7.3635195591E-01],
	[1.7600000000E+04, 9.2159326477E+00, 5.3556688002E+00, 1.1202383436E+00, 8.4182669247E-01, 7.3646508465E-01],
	[1.7605000000E+04, 9.2196676220E+00, 5.3554610573E+00, 1.1212549971E+00, 8.4242673104E-01, 7.3657817765E-01],
	[1.7610000000E+04, 9.2234030487E+00, 5.3552533814E+00, 1.1222722836E+00, 8.4302692030E-01, 7.3669123492E-01],
	[1.7615000000E+04, 9.2271389278E+00, 5.3550457725E+00, 1.1232902031E+00, 8.4362726010E-01, 7.3680425643E-01],
	[1.7620000000E+04, 9.2308752591E+00, 5.3548382306E+00, 1.1243087561E+00, 8.4422775028E-01, 7.3691724220E-01],
	[1.7625000000E+04, 9.2346120426E+00, 5.3546307556E+00, 1.1253279426E+00, 8.4482839070E-01, 7.3703019221E-01],
	[1.7630000000E+04, 9.2383492783E+00, 5.3544233475E+00, 1.1263477628E+00, 8.4542918120E-01, 7.3714310647E-01],
	[1.7635000000E+04, 9.2420869660E+00, 5.3542160062E+00, 1.1273682171E+00, 8.4603012162E-01, 7.3725598496E-01],
	[1.7640000000E+04, 9.2458251057E+00, 5.3540087318E+00, 1.1283893056E+00, 8.4663121182E-01, 7.3736882768E-01],
	[1.7645000000E+04, 9.2495636973E+00, 5.3538015241E+00, 1.1294110284E+00, 8.4723245163E-01, 7.3748163463E-01],
	[1.7650000000E+04, 9.2533027408E+00, 5.3535943831E+00, 1.1304333859E+00, 8.4783384091E-01, 7.3759440580E-01],
	[1.7655000000E+04, 9.2570422359E+00, 5.3533873088E+00, 1.1314563783E+00, 8.4843537950E-01, 7.3770714146E-01],
	[1.7660000000E+04, 9.2607934694E+00, 5.3531843041E+00, 1.1324800057E+00, 8.4903726282E-01, 7.3781984180E-01],
	[1.7665000000E+04, 9.2645490686E+00, 5.3529827499E+00, 1.1335042683E+00, 8.4963936333E-01, 7.3793250684E-01],
	[1.7670000000E+04, 9.2683051272E+00, 5.3527812604E+00, 1.1345291665E+00, 8.5024161328E-01, 7.3804513657E-01],
	[1.7675000000E+04, 9.2720616454E+00, 5.3525798354E+00, 1.1355547003E+00, 8.5084401251E-01, 7.3815773097E-01],
	[1.7680000000E+04, 9.2758186229E+00, 5.3523784750E+00, 1.1365808701E+00, 8.5144656085E-01, 7.3827029005E-01],
	[1.7685000000E+04, 9.2795760597E+00, 5.3521771791E+00, 1.1376076760E+00, 8.5204925817E-01, 7.3838281380E-01],
	[1.7690000000E+04, 9.2833339558E+00, 5.3519759477E+00, 1.1386351182E+00, 8.5265210431E-01, 7.3849530222E-01],
	[1.7695000000E+04, 9.2870923110E+00, 5.3517747807E+00, 1.1396631969E+00, 8.5325509911E-01, 7.3860775531E-01],
	[1.7700000000E+04, 9.2908511253E+00, 5.3515736781E+00, 1.1406919125E+00, 8.5385824241E-01, 7.3872017305E-01],
	[1.7705000000E+04, 9.2946103986E+00, 5.3513726399E+00, 1.1417212650E+00, 8.5446153407E-01, 7.3883255544E-01],
	[1.7710000000E+04, 9.2983701309E+00, 5.3511716660E+00, 1.1427512547E+00, 8.5506497394E-01, 7.3894490249E-01],
	[1.7715000000E+04, 9.3021303221E+00, 5.3509707563E+00, 1.1437818818E+00, 8.5566856185E-01, 7.3905721418E-01],
	[1.7720000000E+04, 9.3058909720E+00, 5.3507699109E+00, 1.1448131465E+00, 8.5627229766E-01, 7.3916949051E-01],
	[1.7725000000E+04, 9.3096520807E+00, 5.3505691297E+00, 1.1458450491E+00, 8.5687618120E-01, 7.3928173148E-01],
	[1.7730000000E+04, 9.3134136480E+00, 5.3503684127E+00, 1.1468775897E+00, 8.5748021234E-01, 7.3939393708E-01],
	[1.7735000000E+04, 9.3171756739E+00, 5.3501677597E+00, 1.1479107686E+00, 8.5808439090E-01, 7.3950610730E-01],
	[1.7740000000E+04, 9.3209381584E+00, 5.3499671709E+00, 1.1489445859E+00, 8.5868871675E-01, 7.3961824216E-01],
	[1.7745000000E+04, 9.3247011012E+00, 5.3497666461E+00, 1.1499790420E+00, 8.5929318972E-01, 7.3973034163E-01],
	[1.7750000000E+04, 9.3284645024E+00, 5.3495661853E+00, 1.1510141369E+00, 8.5989780965E-01, 7.3984240572E-01],
	[1.7755000000E+04, 9.3322283619E+00, 5.3493657885E+00, 1.1520498710E+00, 8.6050257641E-01, 7.3995443442E-01],
	[1.7760000000E+04, 9.3359926796E+00, 5.3491654556E+00, 1.1530862443E+00, 8.6110748982E-01, 7.4006642772E-01],
	[1.7765000000E+04, 9.3397574554E+00, 5.3489651866E+00, 1.1541232573E+00, 8.6171254975E-01, 7.4017838563E-01],
	[1.7770000000E+04, 9.3435226893E+00, 5.3487649814E+00, 1.1551609100E+00, 8.6231775602E-01, 7.4029030814E-01],
	[1.7775000000E+04, 9.3472883812E+00, 5.3485648401E+00, 1.1561992026E+00, 8.6292310849E-01, 7.4040219525E-01],
	[1.7780000000E+04, 9.3510545310E+00, 5.3483647625E+00, 1.1572381355E+00, 8.6352860701E-01, 7.4051404695E-01],
	[1.7785000000E+04, 9.3548211386E+00, 5.3481647487E+00, 1.1582777087E+00, 8.6413425142E-01, 7.4062586323E-01],
	[1.7790000000E+04, 9.3585882040E+00, 5.3479647986E+00, 1.1593179226E+00, 8.6474004156E-01, 7.4073764410E-01],
	[1.7795000000E+04, 9.3623557271E+00, 5.3477649122E+00, 1.1603587773E+00, 8.6534597728E-01, 7.4084938955E-01],
	[1.7800000000E+04, 9.3661237079E+00, 5.3475650893E+00, 1.1614002730E+00, 8.6595205842E-01, 7.4096109957E-01],
	[1.7805000000E+04, 9.3698921462E+00, 5.3473653301E+00, 1.1624424100E+00, 8.6655828484E-01, 7.4107277416E-01],
	[1.7810000000E+04, 9.3736610420E+00, 5.3471656344E+00, 1.1634851885E+00, 8.6716465637E-01, 7.4118441333E-01],
	[1.7815000000E+04, 9.3774303951E+00, 5.3469660022E+00, 1.1645286086E+00, 8.6777117286E-01, 7.4129601705E-01],
	[1.7820000000E+04, 9.3812002056E+00, 5.3467664335E+00, 1.1655726706E+00, 8.6837783416E-01, 7.4140758534E-01],
	[1.7825000000E+04, 9.3849704734E+00, 5.3465669282E+00, 1.1666173748E+00, 8.6898464010E-01, 7.4151911819E-01],
	[1.7830000000E+04, 9.3887411984E+00, 5.3463674863E+00, 1.1676627213E+00, 8.6959159054E-01, 7.4163061558E-01],
	[1.7835000000E+04, 9.3925123805E+00, 5.3461681077E+00, 1.1687087103E+00, 8.7019868533E-01, 7.4174207753E-01],
	[1.7840000000E+04, 9.3962840196E+00, 5.3459687925E+00, 1.1697553421E+00, 8.7080592430E-01, 7.4185350402E-01],
	[1.7845000000E+04, 9.4000561157E+00, 5.3457695406E+00, 1.1708026168E+00, 8.7141330729E-01, 7.4196489506E-01],
	[1.7850000000E+04, 9.4038286687E+00, 5.3455703519E+00, 1.1718505347E+00, 8.7202083417E-01, 7.4207625063E-01],
	[1.7855000000E+04, 9.4076016785E+00, 5.3453712264E+00, 1.1728990960E+00, 8.7262850476E-01, 7.4218757074E-01],
	[1.7860000000E+04, 9.4113751450E+00, 5.3451721641E+00, 1.1739483010E+00, 8.7323631891E-01, 7.4229885538E-01],
	[1.7865000000E+04, 9.4151490683E+00, 5.3449731649E+00, 1.1749981497E+00, 8.7384427648E-01, 7.4241010455E-01],
	[1.7870000000E+04, 9.4189234481E+00, 5.3447742288E+00, 1.1760486425E+00, 8.7445237729E-01, 7.4252131824E-01],
	[1.7875000000E+04, 9.4226982845E+00, 5.3445753558E+00, 1.1770997795E+00, 8.7506062121E-01, 7.4263249646E-01],
	[1.7880000000E+04, 9.4264735774E+00, 5.3443765458E+00, 1.1781515611E+00, 8.7566900806E-01, 7.4274363919E-01],
	[1.7885000000E+04, 9.4302493266E+00, 5.3441777987E+00, 1.1792039872E+00, 8.7627753771E-01, 7.4285474643E-01],
	[1.7890000000E+04, 9.4340255322E+00, 5.3439791147E+00, 1.1802570583E+00, 8.7688620998E-01, 7.4296581819E-01],
	[1.7895000000E+04, 9.4378021939E+00, 5.3437804935E+00, 1.1813107745E+00, 8.7749502473E-01, 7.4307685445E-01],
	[1.7900000000E+04, 9.4415793119E+00, 5.3435819351E+00, 1.1823651360E+00, 8.7810398179E-01, 7.4318785522E-01],
	[1.7905000000E+04, 9.4453568860E+00, 5.3433834397E+00, 1.1834201431E+00, 8.7871308102E-01, 7.4329882049E-01],
	[1.7910000000E+04, 9.4491349161E+00, 5.3431850070E+00, 1.1844757959E+00, 8.7932232226E-01, 7.4340975026E-01],
	[1.7915000000E+04, 9.4529134021E+00, 5.3429866370E+00, 1.1855320947E+00, 8.7993170534E-01, 7.4352064452E-01],
	[1.7920000000E+04, 9.4566923441E+00, 5.3427883298E+00, 1.1865890396E+00, 8.8054123012E-01, 7.4363150327E-01],
	[1.7925000000E+04, 9.4604717418E+00, 5.3425900852E+00, 1.1876466310E+00, 8.8115089645E-01, 7.4374232651E-01],
	[1.7930000000E+04, 9.4642515953E+00, 5.3423919033E+00, 1.1887048689E+00, 8.8176070415E-01, 7.4385311424E-01],
	[1.7935000000E+04, 9.4680319044E+00, 5.3421937840E+00, 1.1897637537E+00, 8.8237065308E-01, 7.4396386644E-01],
	[1.7940000000E+04, 9.4718126692E+00, 5.3419957273E+00, 1.1908232855E+00, 8.8298074308E-01, 7.4407458313E-01],
	[1.7945000000E+04, 9.4756078582E+00, 5.3418024818E+00, 1.1918834646E+00, 8.8359122539E-01, 7.4418526429E-01],
	[1.7950000000E+04, 9.4794051592E+00, 5.3416098575E+00, 1.1929442911E+00, 8.8420187869E-01, 7.4429590992E-01],
	[1.7955000000E+04, 9.4832029238E+00, 5.3414172938E+00, 1.1940057653E+00, 8.8481267320E-01, 7.4440652002E-01],
	[1.7960000000E+04, 9.4870011519E+00, 5.3412247907E+00, 1.1950678874E+00, 8.8542360876E-01, 7.4451709459E-01],
	[1.7965000000E+04, 9.4907998433E+00, 5.3410323481E+00, 1.1961306577E+00, 8.8603468521E-01, 7.4462763362E-01],
	[1.7970000000E+04, 9.4945989980E+00, 5.3408399660E+00, 1.1971940762E+00, 8.8664590239E-01, 7.4473813712E-01],
	[1.7975000000E+04, 9.4983986160E+00, 5.3406476444E+00, 1.1982581433E+00, 8.8725726015E-01, 7.4484860507E-01],
	[1.7980000000E+04, 9.5021986971E+00, 5.3404553831E+00, 1.1993228591E+00, 8.8786875834E-01, 7.4495903747E-01],
	[1.7985000000E+04, 9.5059992413E+00, 5.3402631822E+00, 1.2003882239E+00, 8.8848039679E-01, 7.4506943433E-01],
	[1.7990000000E+04, 9.5098002484E+00, 5.3400710417E+00, 1.2014542379E+00, 8.8909217535E-01, 7.4517979564E-01],
	[1.7995000000E+04, 9.5136017186E+00, 5.3398789615E+00, 1.2025209012E+00, 8.8970409386E-01, 7.4529012139E-01],
	[1.8000000000E+04, 9.5174036516E+00, 5.3396869415E+00, 1.2035882142E+00, 8.9031615218E-01, 7.4540041158E-01],
	[1.8005000000E+04, 9.5212060473E+00, 5.3394949818E+00, 1.2046561770E+00, 8.9092835013E-01, 7.4551066622E-01],
	[1.8010000000E+04, 9.5250089058E+00, 5.3393030823E+00, 1.2057247898E+00, 8.9154068757E-01, 7.4562088529E-01],
	[1.8015000000E+04, 9.5288122270E+00, 5.3391112429E+00, 1.2067940529E+00, 8.9215316434E-01, 7.4573106880E-01],
	[1.8020000000E+04, 9.5326160107E+00, 5.3389194637E+00, 1.2078639665E+00, 8.9276578028E-01, 7.4584121675E-01],
	[1.8025000000E+04, 9.5364202570E+00, 5.3387277445E+00, 1.2089345307E+00, 8.9337853524E-01, 7.4595132912E-01],
	[1.8030000000E+04, 9.5402249656E+00, 5.3385360854E+00, 1.2100057458E+00, 8.9399142905E-01, 7.4606140592E-01],
	[1.8035000000E+04, 9.5440301366E+00, 5.3383444863E+00, 1.2110776121E+00, 8.9460446157E-01, 7.4617144714E-01],
	[1.8040000000E+04, 9.5478357700E+00, 5.3381529473E+00, 1.2121501296E+00, 8.9521763264E-01, 7.4628145279E-01],
	[1.8045000000E+04, 9.5516418655E+00, 5.3379614681E+00, 1.2132232987E+00, 8.9583094209E-01, 7.4639142285E-01],
	[1.8050000000E+04, 9.5554484232E+00, 5.3377700489E+00, 1.2142971196E+00, 8.9644438977E-01, 7.4650135733E-01],
	[1.8055000000E+04, 9.5592554429E+00, 5.3375786895E+00, 1.2153715924E+00, 8.9705797554E-01, 7.4661125623E-01],
	[1.8060000000E+04, 9.5630629246E+00, 5.3373873900E+00, 1.2164467174E+00, 8.9767169922E-01, 7.4672111954E-01],
	[1.8065000000E+04, 9.5668708683E+00, 5.3371961504E+00, 1.2175224948E+00, 8.9828556066E-01, 7.4683094726E-01],
	[1.8070000000E+04, 9.5706792738E+00, 5.3370049704E+00, 1.2185989249E+00, 8.9889955970E-01, 7.4694073939E-01],
	[1.8075000000E+04, 9.5744881412E+00, 5.3368138503E+00, 1.2196760077E+00, 8.9951369620E-01, 7.4705049592E-01],
	[1.8080000000E+04, 9.5782974702E+00, 5.3366227898E+00, 1.2207537436E+00, 9.0012796999E-01, 7.4716021685E-01],
	[1.8085000000E+04, 9.5821072608E+00, 5.3364317890E+00, 1.2218321327E+00, 9.0074238090E-01, 7.4726990218E-01],
	[1.8090000000E+04, 9.5859175131E+00, 5.3362408478E+00, 1.2229111753E+00, 9.0135692880E-01, 7.4737955191E-01],
	[1.8095000000E+04, 9.5897282268E+00, 5.3360499662E+00, 1.2239908716E+00, 9.0197161352E-01, 7.4748916604E-01],
	[1.8100000000E+04, 9.5935394020E+00, 5.3358591442E+00, 1.2250712218E+00, 9.0258643489E-01, 7.4759874456E-01],
	[1.8105000000E+04, 9.5973510385E+00, 5.3356683817E+00, 1.2261522261E+00, 9.0320139278E-01, 7.4770828747E-01],
	[1.8110000000E+04, 9.6011631363E+00, 5.3354776787E+00, 1.2272338847E+00, 9.0381648701E-01, 7.4781779477E-01],
	[1.8115000000E+04, 9.6049756953E+00, 5.3352870351E+00, 1.2283161979E+00, 9.0443171743E-01, 7.4792726646E-01],
	[1.8120000000E+04, 9.6087887154E+00, 5.3350964510E+00, 1.2293991659E+00, 9.0504708388E-01, 7.4803670253E-01],
	[1.8125000000E+04, 9.6126021967E+00, 5.3349059263E+00, 1.2304827888E+00, 9.0566258621E-01, 7.4814610298E-01],
	[1.8130000000E+04, 9.6164161389E+00, 5.3347154609E+00, 1.2315670669E+00, 9.0627822426E-01, 7.4825546781E-01],
	[1.8135000000E+04, 9.6202305420E+00, 5.3345250548E+00, 1.2326520003E+00, 9.0689399786E-01, 7.4836479702E-01],
	[1.8140000000E+04, 9.6240454060E+00, 5.3343347081E+00, 1.2337375895E+00, 9.0750990687E-01, 7.4847409061E-01],
	[1.8145000000E+04, 9.6278607308E+00, 5.3341444205E+00, 1.2348238344E+00, 9.0812595113E-01, 7.4858334857E-01],
	[1.8150000000E+04, 9.6316765163E+00, 5.3339541922E+00, 1.2359107354E+00, 9.0874213047E-01, 7.4869257090E-01],
	[1.8155000000E+04, 9.6354927624E+00, 5.3337640231E+00, 1.2369982926E+00, 9.0935844474E-01, 7.4880175761E-01],
	[1.8160000000E+04, 9.6393094691E+00, 5.3335739131E+00, 1.2380865063E+00, 9.0997489379E-01, 7.4891090868E-01],
	[1.8165000000E+04, 9.6431266363E+00, 5.3333838622E+00, 1.2391753768E+00, 9.1059147744E-01, 7.4902002412E-01],
	[1.8170000000E+04, 9.6469442639E+00, 5.3331938704E+00, 1.2402649041E+00, 9.1120819556E-01, 7.4912910392E-01],
	[1.8175000000E+04, 9.6507623518E+00, 5.3330039376E+00, 1.2413550885E+00, 9.1182504797E-01, 7.4923814808E-01],
	[1.8180000000E+04, 9.6545809001E+00, 5.3328140638E+00, 1.2424459303E+00, 9.1244203453E-01, 7.4934715661E-01],
	[1.8185000000E+04, 9.6583999086E+00, 5.3326242490E+00, 1.2435374296E+00, 9.1305915506E-01, 7.4945612949E-01],
	[1.8190000000E+04, 9.6622193772E+00, 5.3324344932E+00, 1.2446295867E+00, 9.1367640942E-01, 7.4956506673E-01],
	[1.8195000000E+04, 9.6660393059E+00, 5.3322447962E+00, 1.2457224017E+00, 9.1429379745E-01, 7.4967396832E-01],
	[1.8200000000E+04, 9.6698596945E+00, 5.3320551581E+00, 1.2468158750E+00, 9.1491131899E-01, 7.4978283427E-01],
	[1.8205000000E+04, 9.6736805431E+00, 5.3318655788E+00, 1.2479100066E+00, 9.1552897387E-01, 7.4989166457E-01],
	[1.8210000000E+04, 9.6775018516E+00, 5.3316760584E+00, 1.2490047969E+00, 9.1614676195E-01, 7.5000045922E-01],
	[1.8215000000E+04, 9.6813236199E+00, 5.3314865967E+00, 1.2501002460E+00, 9.1676468306E-01, 7.5010921822E-01],
	[1.8220000000E+04, 9.6851458478E+00, 5.3312971937E+00, 1.2511963542E+00, 9.1738273705E-01, 7.5021794157E-01],
	[1.8225000000E+04, 9.6889685354E+00, 5.3311078494E+00, 1.2522931217E+00, 9.1800092375E-01, 7.5032662926E-01],
	[1.8230000000E+04, 9.6927937811E+00, 5.3309192482E+00, 1.2533905486E+00, 9.1861928218E-01, 7.5043528129E-01],
	[1.8235000000E+04, 9.6966334356E+00, 5.3307352525E+00, 1.2544886352E+00, 9.1923803366E-01, 7.5054389766E-01],
	[1.8240000000E+04, 9.7004735578E+00, 5.3305513135E+00, 1.2555873817E+00, 9.1985691801E-01, 7.5065247838E-01],
	[1.8245000000E+04, 9.7043141476E+00, 5.3303674313E+00, 1.2566867884E+00, 9.2047593506E-01, 7.5076102343E-01],
	[1.8250000000E+04, 9.7081552050E+00, 5.3301836058E+00, 1.2577868554E+00, 9.2109508466E-01, 7.5086953282E-01],
	[1.8255000000E+04, 9.7119967299E+00, 5.3299998370E+00, 1.2588875829E+00, 9.2171436664E-01, 7.5097800655E-01],
	[1.8260000000E+04, 9.7158387223E+00, 5.3298161249E+00, 1.2599889713E+00, 9.2233378086E-01, 7.5108644461E-01],
	[1.8265000000E+04, 9.7196811820E+00, 5.3296324694E+00, 1.2610910206E+00, 9.2295332715E-01, 7.5119484700E-01],
	[1.8270000000E+04, 9.7235241090E+00, 5.3294488705E+00, 1.2621937311E+00, 9.2357300536E-01, 7.5130321373E-01],
	[1.8275000000E+04, 9.7273675032E+00, 5.3292653282E+00, 1.2632971030E+00, 9.2419281533E-01, 7.5141154478E-01],
	[1.8280000000E+04, 9.7312113645E+00, 5.3290818424E+00, 1.2644011366E+00, 9.2481275689E-01, 7.5151984017E-01],
	[1.8285000000E+04, 9.7350556929E+00, 5.3288984130E+00, 1.2655058320E+00, 9.2543282990E-01, 7.5162809988E-01],
	[1.8290000000E+04, 9.7389004883E+00, 5.3287150402E+00, 1.2666111895E+00, 9.2605303419E-01, 7.5173632391E-01],
	[1.8295000000E+04, 9.7427457507E+00, 5.3285317238E+00, 1.2677172093E+00, 9.2667336960E-01, 7.5184451228E-01],
	[1.8300000000E+04, 9.7465914799E+00, 5.3283484637E+00, 1.2688238915E+00, 9.2729383598E-01, 7.5195266496E-01],
	[1.8305000000E+04, 9.7504376759E+00, 5.3281652601E+00, 1.2699312364E+00, 9.2791443316E-01, 7.5206078197E-01],
	[1.8310000000E+04, 9.7542843387E+00, 5.3279821127E+00, 1.2710392443E+00, 9.2853516099E-01, 7.5216886330E-01],
	[1.8315000000E+04, 9.7581314680E+00, 5.3277990217E+00, 1.2721479153E+00, 9.2915601932E-01, 7.5227690895E-01],
	[1.8320000000E+04, 9.7619790640E+00, 5.3276159869E+00, 1.2732572497E+00, 9.2977700797E-01, 7.5238491891E-01],
	[1.8325000000E+04, 9.7658271264E+00, 5.3274330084E+00, 1.2743672476E+00, 9.3039812680E-01, 7.5249289320E-01],
	[1.8330000000E+04, 9.7696756553E+00, 5.3272500861E+00, 1.2754779093E+00, 9.3101937564E-01, 7.5260083180E-01],
	[1.8335000000E+04, 9.7735246506E+00, 5.3270672199E+00, 1.2765892350E+00, 9.3164075434E-01, 7.5270873472E-01],
	[1.8340000000E+04, 9.7773741122E+00, 5.3268844099E+00, 1.2777012250E+00, 9.3226226274E-01, 7.5281660195E-01],
	[1.8345000000E+04, 9.7812240400E+00, 5.3267016560E+00, 1.2788138793E+00, 9.3288390067E-01, 7.5292443349E-01],
	[1.8350000000E+04, 9.7850744339E+00, 5.3265189581E+00, 1.2799271983E+00, 9.3350566799E-01, 7.5303222935E-01],
	[1.8355000000E+04, 9.7889252939E+00, 5.3263363163E+00, 1.2810411821E+00, 9.3412756452E-01, 7.5313998951E-01],
	[1.8360000000E+04, 9.7927766200E+00, 5.3261537305E+00, 1.2821558311E+00, 9.3474959012E-01, 7.5324771399E-01],
	[1.8365000000E+04, 9.7966284119E+00, 5.3259712006E+00, 1.2832711453E+00, 9.3537174461E-01, 7.5335540278E-01],
	[1.8370000000E+04, 9.8004806698E+00, 5.3257887268E+00, 1.2843871250E+00, 9.3599402786E-01, 7.5346305587E-01],
	[1.8375000000E+04, 9.8043333934E+00, 5.3256063088E+00, 1.2855037704E+00, 9.3661643968E-01, 7.5357067328E-01],
	[1.8380000000E+04, 9.8081865828E+00, 5.3254239467E+00, 1.2866210818E+00, 9.3723897994E-01, 7.5367825499E-01],
	[1.8385000000E+04, 9.8120402379E+00, 5.3252416404E+00, 1.2877390593E+00, 9.3786164846E-01, 7.5378580100E-01],
	[1.8390000000E+04, 9.8158943585E+00, 5.3250593899E+00, 1.2888577032E+00, 9.3848444508E-01, 7.5389331132E-01],
	[1.8395000000E+04, 9.8197489446E+00, 5.3248771953E+00, 1.2899770136E+00, 9.3910736966E-01, 7.5400078595E-01],
	[1.8400000000E+04, 9.8236039962E+00, 5.3246950563E+00, 1.2910969909E+00, 9.3973042203E-01, 7.5410822487E-01],
	[1.8405000000E+04, 9.8274595132E+00, 5.3245129731E+00, 1.2922176351E+00, 9.4035360202E-01, 7.5421562810E-01],
	[1.8410000000E+04, 9.8313154955E+00, 5.3243309456E+00, 1.2933389466E+00, 9.4097690949E-01, 7.5432299564E-01],
	[1.8415000000E+04, 9.8351719430E+00, 5.3241489737E+00, 1.2944609255E+00, 9.4160034427E-01, 7.5443032747E-01],
	[1.8420000000E+04, 9.8390288557E+00, 5.3239670575E+00, 1.2955835721E+00, 9.4222390620E-01, 7.5453762360E-01],
	[1.8425000000E+04, 9.8428862335E+00, 5.3237851968E+00, 1.2967068866E+00, 9.4284759512E-01, 7.5464488404E-01],
	[1.8430000000E+04, 9.8467440763E+00, 5.3236033917E+00, 1.2978308691E+00, 9.4347141088E-01, 7.5475210877E-01],
	[1.8435000000E+04, 9.8506023841E+00, 5.3234216421E+00, 1.2989555199E+00, 9.4409535331E-01, 7.5485929780E-01],
	[1.8440000000E+04, 9.8544611568E+00, 5.3232399480E+00, 1.3000808393E+00, 9.4471942226E-01, 7.5496645102E-01],
	[1.8445000000E+04, 9.8583203943E+00, 5.3230583093E+00, 1.3012068274E+00, 9.4534361756E-01, 7.5507356833E-01],
	[1.8450000000E+04, 9.8621800965E+00, 5.3228767261E+00, 1.3023334844E+00, 9.4596793906E-01, 7.5518064974E-01],
	[1.8455000000E+04, 9.8660402634E+00, 5.3226951983E+00, 1.3034608106E+00, 9.4659238660E-01, 7.5528769525E-01],
	[1.8460000000E+04, 9.8699008949E+00, 5.3225137258E+00, 1.3045888062E+00, 9.4721696001E-01, 7.5539470486E-01],
	[1.8465000000E+04, 9.8737619910E+00, 5.3223323087E+00, 1.3057174714E+00, 9.4784165914E-01, 7.5550167856E-01],
	[1.8470000000E+04, 9.8776235515E+00, 5.3221509469E+00, 1.3068468064E+00, 9.4846648382E-01, 7.5560861637E-01],
	[1.8475000000E+04, 9.8814855764E+00, 5.3219696403E+00, 1.3079768114E+00, 9.4909143390E-01, 7.5571551827E-01],
	[1.8480000000E+04, 9.8853480657E+00, 5.3217883890E+00, 1.3091074866E+00, 9.4971650922E-01, 7.5582238428E-01],
	[1.8485000000E+04, 9.8892110192E+00, 5.3216071928E+00, 1.3102388323E+00, 9.5034170962E-01, 7.5592921438E-01],
	[1.8490000000E+04, 9.8930744369E+00, 5.3214260519E+00, 1.3113708487E+00, 9.5096703494E-01, 7.5603600858E-01],
	[1.8495000000E+04, 9.8969383187E+00, 5.3212449661E+00, 1.3125035359E+00, 9.5159248502E-01, 7.5614276689E-01],
	[1.8500000000E+04, 9.9008026646E+00, 5.3210639354E+00, 1.3136368943E+00, 9.5221805969E-01, 7.5624948929E-01],
	[1.8505000000E+04, 9.9046674744E+00, 5.3208829597E+00, 1.3147709240E+00, 9.5284375880E-01, 7.5635617580E-01],
	[1.8510000000E+04, 9.9085327482E+00, 5.3207020391E+00, 1.3159056252E+00, 9.5346958220E-01, 7.5646282640E-01],
	[1.8515000000E+04, 9.9123984857E+00, 5.3205211736E+00, 1.3170409981E+00, 9.5409552971E-01, 7.5656944111E-01],
	[1.8520000000E+04, 9.9162646871E+00, 5.3203403630E+00, 1.3181770430E+00, 9.5472160118E-01, 7.5667601992E-01],
	[1.8525000000E+04, 9.9201385583E+00, 5.3201618618E+00, 1.3193137601E+00, 9.5534793597E-01, 7.5678256283E-01],
	[1.8530000000E+04, 9.9240221729E+00, 5.3199863155E+00, 1.3204511496E+00, 9.5597457443E-01, 7.5688906985E-01],
	[1.8535000000E+04, 9.9279062594E+00, 5.3198108224E+00, 1.3215892117E+00, 9.5660133702E-01, 7.5699554097E-01],
	[1.8540000000E+04, 9.9317908178E+00, 5.3196353824E+00, 1.3227279467E+00, 9.5722822356E-01, 7.5710197619E-01],
	[1.8545000000E+04, 9.9356758481E+00, 5.3194599955E+00, 1.3238673546E+00, 9.5785523390E-01, 7.5720837551E-01],
	[1.8550000000E+04, 9.9395613502E+00, 5.3192846616E+00, 1.3250074359E+00, 9.5848236789E-01, 7.5731473894E-01],
	[1.8555000000E+04, 9.9434473239E+00, 5.3191093808E+00, 1.3261481906E+00, 9.5910962536E-01, 7.5742106648E-01],
	[1.8560000000E+04, 9.9473337693E+00, 5.3189341530E+00, 1.3272896189E+00, 9.5973700616E-01, 7.5752735812E-01],
	[1.8565000000E+04, 9.9512206863E+00, 5.3187589781E+00, 1.3284317212E+00, 9.6036451012E-01, 7.5763361387E-01],
	[1.8570000000E+04, 9.9551080748E+00, 5.3185838562E+00, 1.3295744976E+00, 9.6099213708E-01, 7.5773983372E-01],
	[1.8575000000E+04, 9.9589959347E+00, 5.3184087872E+00, 1.3307179484E+00, 9.6161988688E-01, 7.5784601769E-01],
	[1.8580000000E+04, 9.9628842660E+00, 5.3182337710E+00, 1.3318620737E+00, 9.6224775937E-01, 7.5795216576E-01],
	[1.8585000000E+04, 9.9667730685E+00, 5.3180588078E+00, 1.3330068737E+00, 9.6287575439E-01, 7.5805827794E-01],
	[1.8590000000E+04, 9.9706623423E+00, 5.3178838973E+00, 1.3341523488E+00, 9.6350387177E-01, 7.5816435422E-01],
	[1.8595000000E+04, 9.9745520872E+00, 5.3177090396E+00, 1.3352984990E+00, 9.6413211135E-01, 7.5827039462E-01],
	[1.8600000000E+04, 9.9784423032E+00, 5.3175342347E+00, 1.3364453247E+00, 9.6476047298E-01, 7.5837639913E-01],
	[1.8605000000E+04, 9.9823329902E+00, 5.3173594825E+00, 1.3375928260E+00, 9.6538895649E-01, 7.5848236776E-01],
	[1.8610000000E+04, 9.9862241482E+00, 5.3171847830E+00, 1.3387410031E+00, 9.6601756172E-01, 7.5858830049E-01],
	[1.8615000000E+04, 9.9901157770E+00, 5.3170101362E+00, 1.3398898563E+00, 9.6664628852E-01, 7.5869419734E-01],
	[1.8620000000E+04, 9.9940078766E+00, 5.3168355420E+00, 1.3410393857E+00, 9.6727513672E-01, 7.5880005830E-01],
	[1.8625000000E+04, 9.9979004470E+00, 5.3166610005E+00, 1.3421895917E+00, 9.6790410617E-01, 7.5890588338E-01],
	[1.8630000000E+04, 1.0001793488E+01, 5.3164865115E+00, 1.3433404743E+00, 9.6853319670E-01, 7.5901167257E-01],
	[1.8635000000E+04, 1.0005687000E+01, 5.3163120750E+00, 1.3444920339E+00, 9.6916240815E-01, 7.5911742588E-01],
	[1.8640000000E+04, 1.0009580982E+01, 5.3161376911E+00, 1.3456442706E+00, 9.6979174037E-01, 7.5922314331E-01],
	[1.8645000000E+04, 1.0013475434E+01, 5.3159633597E+00, 1.3467971847E+00, 9.7042119319E-01, 7.5932882486E-01],
	[1.8650000000E+04, 1.0017370357E+01, 5.3157890807E+00, 1.3479507763E+00, 9.7105076645E-01, 7.5943447053E-01],
	[1.8655000000E+04, 1.0021265751E+01, 5.3156148541E+00, 1.3491050458E+00, 9.7168046000E-01, 7.5954008031E-01],
	[1.8660000000E+04, 1.0025161614E+01, 5.3154406800E+00, 1.3502599932E+00, 9.7231027366E-01, 7.5964565422E-01],
	[1.8665000000E+04, 1.0029057948E+01, 5.3152665582E+00, 1.3514156189E+00, 9.7294020729E-01, 7.5975119225E-01],
	[1.8670000000E+04, 1.0032954752E+01, 5.3150924887E+00, 1.3525719229E+00, 9.7357026072E-01, 7.5985669441E-01],
	[1.8675000000E+04, 1.0036852026E+01, 5.3149184716E+00, 1.3537289057E+00, 9.7420043379E-01, 7.5996216069E-01],
	[1.8680000000E+04, 1.0040749770E+01, 5.3147445067E+00, 1.3548865673E+00, 9.7483072634E-01, 7.6006759109E-01],
	[1.8685000000E+04, 1.0044647983E+01, 5.3145705941E+00, 1.3560449079E+00, 9.7546113821E-01, 7.6017298563E-01],
	[1.8690000000E+04, 1.0048546667E+01, 5.3143967337E+00, 1.3572039279E+00, 9.7609166924E-01, 7.6027834429E-01],
	[1.8695000000E+04, 1.0052445820E+01, 5.3142229255E+00, 1.3583636274E+00, 9.7672231926E-01, 7.6038366708E-01],
	[1.8700000000E+04, 1.0056345443E+01, 5.3140491695E+00, 1.3595240066E+00, 9.7735308813E-01, 7.6048895400E-01],
	[1.8705000000E+04, 1.0060245536E+01, 5.3138754656E+00, 1.3606850658E+00, 9.7798397567E-01, 7.6059420505E-01],
	[1.8710000000E+04, 1.0064146098E+01, 5.3137018138E+00, 1.3618469387E+00, 9.7861505074E-01, 7.6069942023E-01],
	[1.8715000000E+04, 1.0068047130E+01, 5.3135282141E+00, 1.3630097519E+00, 9.7924637823E-01, 7.6080459955E-01],
	[1.8720000000E+04, 1.0071948631E+01, 5.3133546664E+00, 1.3641732463E+00, 9.7987782405E-01, 7.6090974300E-01],
	[1.8725000000E+04, 1.0075850601E+01, 5.3131811707E+00, 1.3653374220E+00, 9.8050938805E-01, 7.6101485059E-01],
	[1.8730000000E+04, 1.0079753041E+01, 5.3130077270E+00, 1.3665022794E+00, 9.8114107006E-01, 7.6111992232E-01],
	[1.8735000000E+04, 1.0083655950E+01, 5.3128343353E+00, 1.3676678187E+00, 9.8177286992E-01, 7.6122495819E-01],
	[1.8740000000E+04, 1.0087559328E+01, 5.3126609955E+00, 1.3688340400E+00, 9.8240478747E-01, 7.6132995819E-01],
	[1.8745000000E+04, 1.0091463175E+01, 5.3124877076E+00, 1.3700009435E+00, 9.8303682255E-01, 7.6143492234E-01],
	[1.8750000000E+04, 1.0095367492E+01, 5.3123144715E+00, 1.3711685296E+00, 9.8366897500E-01, 7.6153985063E-01],
	[1.8755000000E+04, 1.0099272277E+01, 5.3121412873E+00, 1.3723367983E+00, 9.8430124466E-01, 7.6164474307E-01],
	[1.8760000000E+04, 1.0103177531E+01, 5.3119681549E+00, 1.3735057500E+00, 9.8493363137E-01, 7.6174959965E-01],
	[1.8765000000E+04, 1.0107083253E+01, 5.3117950743E+00, 1.3746753848E+00, 9.8556613496E-01, 7.6185442038E-01],
	[1.8770000000E+04, 1.0110989445E+01, 5.3116220454E+00, 1.3758457030E+00, 9.8619875527E-01, 7.6195920526E-01],
	[1.8775000000E+04, 1.0114896105E+01, 5.3114490682E+00, 1.3770167047E+00, 9.8683149215E-01, 7.6206395429E-01],
	[1.8780000000E+04, 1.0118803234E+01, 5.3112761428E+00, 1.3781883902E+00, 9.8746434543E-01, 7.6216866747E-01],
	[1.8785000000E+04, 1.0122710831E+01, 5.3111032690E+00, 1.3793607597E+00, 9.8809731495E-01, 7.6227334480E-01],
	[1.8790000000E+04, 1.0126618897E+01, 5.3109304468E+00, 1.3805338135E+00, 9.8873040056E-01, 7.6237798629E-01],
	[1.8795000000E+04, 1.0130527431E+01, 5.3107576762E+00, 1.3817075517E+00, 9.8936360208E-01, 7.6248259193E-01],
	[1.8800000000E+04, 1.0134436434E+01, 5.3105849572E+00, 1.3828819745E+00, 9.8999691936E-01, 7.6258716174E-01],
	[1.8805000000E+04, 1.0138345904E+01, 5.3104122898E+00, 1.3840570822E+00, 9.9063035223E-01, 7.6269169570E-01],
	[1.8810000000E+04, 1.0142255843E+01, 5.3102396739E+00, 1.3852328750E+00, 9.9126390055E-01, 7.6279619382E-01],
	[1.8815000000E+04, 1.0146166250E+01, 5.3100671094E+00, 1.3864093531E+00, 9.9189756413E-01, 7.6290065611E-01],
	[1.8820000000E+04, 1.0150077125E+01, 5.3098945964E+00, 1.3875865167E+00, 9.9253134283E-01, 7.6300508256E-01],
	[1.8825000000E+04, 1.0154001988E+01, 5.3097261934E+00, 1.3887643660E+00, 9.9316550781E-01, 7.6310947317E-01],
	[1.8830000000E+04, 1.0157930730E+01, 5.3095588622E+00, 1.3899429013E+00, 9.9379985650E-01, 7.6321382796E-01],
	[1.8835000000E+04, 1.0161859949E+01, 5.3093915807E+00, 1.3911221228E+00, 9.9443432048E-01, 7.6331814691E-01],
	[1.8840000000E+04, 1.0165789644E+01, 5.3092243488E+00, 1.3923020306E+00, 9.9506889959E-01, 7.6342243004E-01],
	[1.8845000000E+04, 1.0169719816E+01, 5.3090571666E+00, 1.3934826251E+00, 9.9570359368E-01, 7.6352667734E-01],
	[1.8850000000E+04, 1.0173650463E+01, 5.3088900340E+00, 1.3946639063E+00, 9.9633840257E-01, 7.6363088881E-01],
	[1.8855000000E+04, 1.0177581587E+01, 5.3087229510E+00, 1.3958458746E+00, 9.9697332611E-01, 7.6373506446E-01],
	[1.8860000000E+04, 1.0181513187E+01, 5.3085559175E+00, 1.3970285302E+00, 9.9760836414E-01, 7.6383920429E-01],
	[1.8865000000E+04, 1.0185445263E+01, 5.3083889336E+00, 1.3982118732E+00, 9.9824351650E-01, 7.6394330829E-01],
	[1.8870000000E+04, 1.0189377815E+01, 5.3082219992E+00, 1.3993959039E+00, 9.9887878302E-01, 7.6404737648E-01],
	[1.8875000000E+04, 1.0193310842E+01, 5.3080551142E+00, 1.4005806225E+00, 9.9951416354E-01, 7.6415140886E-01],
	[1.8880000000E+04, 1.0197244346E+01, 5.3078882787E+00, 1.4017660293E+00, 1.0001496579E+00, 7.6425540542E-01],
	[1.8885000000E+04, 1.0201178325E+01, 5.3077214926E+00, 1.4029521243E+00, 1.0007852660E+00, 7.6435936617E-01],
	[1.8890000000E+04, 1.0205112780E+01, 5.3075547559E+00, 1.4041389079E+00, 1.0014209875E+00, 7.6446329110E-01],
	[1.8895000000E+04, 1.0209047710E+01, 5.3073880686E+00, 1.4053263803E+00, 1.0020568225E+00, 7.6456718023E-01],
	[1.8900000000E+04, 1.0212983116E+01, 5.3072214306E+00, 1.4065145417E+00, 1.0026927706E+00, 7.6467103356E-01],
	[1.8905000000E+04, 1.0216918998E+01, 5.3070548419E+00, 1.4077033923E+00, 1.0033288318E+00, 7.6477485108E-01],
	[1.8910000000E+04, 1.0220855354E+01, 5.3068883025E+00, 1.4088929322E+00, 1.0039650058E+00, 7.6487863279E-01],
	[1.8915000000E+04, 1.0224792187E+01, 5.3067218124E+00, 1.4100831619E+00, 1.0046012926E+00, 7.6498237871E-01],
	[1.8920000000E+04, 1.0228729494E+01, 5.3065553715E+00, 1.4112740813E+00, 1.0052376919E+00, 7.6508608883E-01],
	[1.8925000000E+04, 1.0232667276E+01, 5.3063889797E+00, 1.4124656909E+00, 1.0058742036E+00, 7.6518976315E-01],
	[1.8930000000E+04, 1.0236605534E+01, 5.3062226372E+00, 1.4136579907E+00, 1.0065108275E+00, 7.6529340167E-01],
	[1.8935000000E+04, 1.0240544267E+01, 5.3060563438E+00, 1.4148509810E+00, 1.0071475635E+00, 7.6539700441E-01],
	[1.8940000000E+04, 1.0244483474E+01, 5.3058900995E+00, 1.4160446621E+00, 1.0077844114E+00, 7.6550057136E-01],
	[1.8945000000E+04, 1.0248423157E+01, 5.3057239042E+00, 1.4172390341E+00, 1.0084213711E+00, 7.6560410251E-01],
	[1.8950000000E+04, 1.0252363314E+01, 5.3055577581E+00, 1.4184340972E+00, 1.0090584423E+00, 7.6570759789E-01],
	[1.8955000000E+04, 1.0256303946E+01, 5.3053916610E+00, 1.4196298517E+00, 1.0096956250E+00, 7.6581105748E-01],
	[1.8960000000E+04, 1.0260245053E+01, 5.3052256129E+00, 1.4208262978E+00, 1.0103329189E+00, 7.6591448128E-01],
	[1.8965000000E+04, 1.0264186635E+01, 5.3050596137E+00, 1.4220234357E+00, 1.0109703240E+00, 7.6601786931E-01],
	[1.8970000000E+04, 1.0268128691E+01, 5.3048936635E+00, 1.4232212656E+00, 1.0116078399E+00, 7.6612122157E-01],
	[1.8975000000E+04, 1.0272071221E+01, 5.3047277623E+00, 1.4244197878E+00, 1.0122454667E+00, 7.6622453804E-01],
	[1.8980000000E+04, 1.0276014226E+01, 5.3045619099E+00, 1.4256190024E+00, 1.0128832041E+00, 7.6632781875E-01],
	[1.8985000000E+04, 1.0279957706E+01, 5.3043961064E+00, 1.4268189097E+00, 1.0135210519E+00, 7.6643106369E-01],
	[1.8990000000E+04, 1.0283901659E+01, 5.3042303518E+00, 1.4280195099E+00, 1.0141590100E+00, 7.6653427286E-01],
	[1.8995000000E+04, 1.0287846087E+01, 5.3040646459E+00, 1.4292208031E+00, 1.0147970782E+00, 7.6663744626E-01],
	[1.9000000000E+04, 1.0291790989E+01, 5.3038989889E+00, 1.4304227897E+00, 1.0154352565E+00, 7.6674058390E-01],
	[1.9005000000E+04, 1.0295736365E+01, 5.3037333806E+00, 1.4316254699E+00, 1.0160735445E+00, 7.6684368578E-01],
	[1.9010000000E+04, 1.0299682216E+01, 5.3035678210E+00, 1.4328288438E+00, 1.0167119421E+00, 7.6694675191E-01],
	[1.9015000000E+04, 1.0303628540E+01, 5.3034023102E+00, 1.4340329116E+00, 1.0173504493E+00, 7.6704978227E-01],
	[1.9020000000E+04, 1.0307575338E+01, 5.3032368480E+00, 1.4352376737E+00, 1.0179890658E+00, 7.6715277689E-01],
	[1.9025000000E+04, 1.0311522610E+01, 5.3030714345E+00, 1.4364431301E+00, 1.0186277914E+00, 7.6725573575E-01],
	[1.9030000000E+04, 1.0315470355E+01, 5.3029060696E+00, 1.4376492812E+00, 1.0192666261E+00, 7.6735865887E-01],
	[1.9035000000E+04, 1.0319418574E+01, 5.3027407533E+00, 1.4388561272E+00, 1.0199055695E+00, 7.6746154624E-01],
	[1.9040000000E+04, 1.0323367267E+01, 5.3025754855E+00, 1.4400636681E+00, 1.0205446217E+00, 7.6756439786E-01],
	[1.9045000000E+04, 1.0327316434E+01, 5.3024102664E+00, 1.4412719044E+00, 1.0211837824E+00, 7.6766721375E-01],
	[1.9050000000E+04, 1.0331266074E+01, 5.3022450957E+00, 1.4424808361E+00, 1.0218230514E+00, 7.6776999390E-01],
	[1.9055000000E+04, 1.0335216187E+01, 5.3020799735E+00, 1.4436904636E+00, 1.0224624286E+00, 7.6787273831E-01],
	[1.9060000000E+04, 1.0339166773E+01, 5.3019148998E+00, 1.4449007870E+00, 1.0231019138E+00, 7.6797544699E-01],
	[1.9065000000E+04, 1.0343117833E+01, 5.3017498745E+00, 1.4461118065E+00, 1.0237415070E+00, 7.6807811994E-01],
	[1.9070000000E+04, 1.0347069367E+01, 5.3015848976E+00, 1.4473235224E+00, 1.0243812078E+00, 7.6818075716E-01],
	[1.9075000000E+04, 1.0351021373E+01, 5.3014199691E+00, 1.4485359348E+00, 1.0250210161E+00, 7.6828335866E-01],
	[1.9080000000E+04, 1.0354973852E+01, 5.3012550890E+00, 1.4497490441E+00, 1.0256609319E+00, 7.6838592443E-01],
	[1.9085000000E+04, 1.0358926805E+01, 5.3010902572E+00, 1.4509628504E+00, 1.0263009548E+00, 7.6848845449E-01],
	[1.9090000000E+04, 1.0362880230E+01, 5.3009254737E+00, 1.4521773539E+00, 1.0269410848E+00, 7.6859094883E-01],
	[1.9095000000E+04, 1.0366834128E+01, 5.3007607384E+00, 1.4533925548E+00, 1.0275813218E+00, 7.6869340745E-01],
	[1.9100000000E+04, 1.0370788499E+01, 5.3005960514E+00, 1.4546084534E+00, 1.0282216654E+00, 7.6879583036E-01],
	[1.9105000000E+04, 1.0374743343E+01, 5.3004314127E+00, 1.4558250499E+00, 1.0288621156E+00, 7.6889821757E-01],
	[1.9110000000E+04, 1.0378698659E+01, 5.3002668221E+00, 1.4570423445E+00, 1.0295026723E+00, 7.6900056907E-01],
	[1.9115000000E+04, 1.0382654448E+01, 5.3001022797E+00, 1.4582603374E+00, 1.0301433351E+00, 7.6910288486E-01],
	[1.9120000000E+04, 1.0386610710E+01, 5.2999377854E+00, 1.4594790288E+00, 1.0307841041E+00, 7.6920516495E-01],
	[1.9125000000E+04, 1.0390570924E+01, 5.2997743424E+00, 1.4606984190E+00, 1.0314250513E+00, 7.6930740935E-01],
	[1.9130000000E+04, 1.0394545507E+01, 5.2996149507E+00, 1.4619185081E+00, 1.0320663932E+00, 7.6940961805E-01],
	[1.9135000000E+04, 1.0398520570E+01, 5.2994556055E+00, 1.4631392964E+00, 1.0327078413E+00, 7.6951179106E-01],
	[1.9140000000E+04, 1.0402496115E+01, 5.2992963066E+00, 1.4643607842E+00, 1.0333493956E+00, 7.6961392838E-01],
	[1.9145000000E+04, 1.0406472140E+01, 5.2991370542E+00, 1.4655829715E+00, 1.0339910559E+00, 7.6971603002E-01],
	[1.9150000000E+04, 1.0410448647E+01, 5.2989778481E+00, 1.4668058587E+00, 1.0346328219E+00, 7.6981809597E-01],
	[1.9155000000E+04, 1.0414425634E+01, 5.2988186884E+00, 1.4680294459E+00, 1.0352746936E+00, 7.6992012625E-01],
	[1.9160000000E+04, 1.0418403102E+01, 5.2986595750E+00, 1.4692537334E+00, 1.0359166708E+00, 7.7002212084E-01],
	[1.9165000000E+04, 1.0422381050E+01, 5.2985005078E+00, 1.4704787214E+00, 1.0365587532E+00, 7.7012407976E-01],
	[1.9170000000E+04, 1.0426359480E+01, 5.2983414870E+00, 1.4717044101E+00, 1.0372009409E+00, 7.7022600301E-01],
	[1.9175000000E+04, 1.0430338389E+01, 5.2981825124E+00, 1.4729307997E+00, 1.0378432335E+00, 7.7032789059E-01],
	[1.9180000000E+04, 1.0434317779E+01, 5.2980235840E+00, 1.4741578904E+00, 1.0384856309E+00, 7.7042974251E-01],
	[1.9185000000E+04, 1.0438297650E+01, 5.2978647018E+00, 1.4753856825E+00, 1.0391281330E+00, 7.7053155876E-01],
	[1.9190000000E+04, 1.0442278001E+01, 5.2977058657E+00, 1.4766141762E+00, 1.0397707397E+00, 7.7063333935E-01],
	[1.9195000000E+04, 1.0446258832E+01, 5.2975470758E+00, 1.4778433716E+00, 1.0404134506E+00, 7.7073508421E-01],
	[1.9200000000E+04, 1.0450240143E+01, 5.2973883320E+00, 1.4790732691E+00, 1.0410562658E+00, 7.7083679335E-01],
	[1.9205000000E+04, 1.0454221934E+01, 5.2972296343E+00, 1.4803038688E+00, 1.0416991849E+00, 7.7093846675E-01],
	[1.9210000000E+04, 1.0458204206E+01, 5.2970709827E+00, 1.4815351710E+00, 1.0423422080E+00, 7.7104010442E-01],
	[1.9215000000E+04, 1.0462186957E+01, 5.2969123771E+00, 1.4827671758E+00, 1.0429853347E+00, 7.7114170636E-01],
	[1.9220000000E+04, 1.0466170188E+01, 5.2967538175E+00, 1.4839998834E+00, 1.0436285649E+00, 7.7124327256E-01],
	[1.9225000000E+04, 1.0470153899E+01, 5.2965953039E+00, 1.4852332942E+00, 1.0442718986E+00, 7.7134480302E-01],
	[1.9230000000E+04, 1.0474138090E+01, 5.2964368363E+00, 1.4864674083E+00, 1.0449153354E+00, 7.7144629775E-01],
	[1.9235000000E+04, 1.0478122761E+01, 5.2962784146E+00, 1.4877022259E+00, 1.0455588753E+00, 7.7154775674E-01],
	[1.9240000000E+04, 1.0482107911E+01, 5.2961200388E+00, 1.4889377472E+00, 1.0462025181E+00, 7.7164917998E-01],
	[1.9245000000E+04, 1.0486093541E+01, 5.2959617089E+00, 1.4901739726E+00, 1.0468462636E+00, 7.7175056749E-01],
	[1.9250000000E+04, 1.0490079650E+01, 5.2958034249E+00, 1.4914109021E+00, 1.0474901116E+00, 7.7185191925E-01],
	[1.9255000000E+04, 1.0494066239E+01, 5.2956451867E+00, 1.4926485360E+00, 1.0481340621E+00, 7.7195323526E-01],
	[1.9260000000E+04, 1.0498053307E+01, 5.2954869943E+00, 1.4938868745E+00, 1.0487781148E+00, 7.7205451553E-01],
	[1.9265000000E+04, 1.0502040855E+01, 5.2953288477E+00, 1.4951259178E+00, 1.0494222696E+00, 7.7215576005E-01],
	[1.9270000000E+04, 1.0506028881E+01, 5.2951707469E+00, 1.4963656663E+00, 1.0500665263E+00, 7.7225696883E-01],
	[1.9275000000E+04, 1.0510017387E+01, 5.2950126918E+00, 1.4976061199E+00, 1.0507108847E+00, 7.7235814185E-01],
	[1.9280000000E+04, 1.0514006372E+01, 5.2948546824E+00, 1.4988472791E+00, 1.0513553448E+00, 7.7245927913E-01],
	[1.9285000000E+04, 1.0517995836E+01, 5.2946967187E+00, 1.5000891440E+00, 1.0519999063E+00, 7.7256038065E-01],
	[1.9290000000E+04, 1.0521985779E+01, 5.2945388006E+00, 1.5013317147E+00, 1.0526445690E+00, 7.7266144642E-01],
	[1.9295000000E+04, 1.0525976201E+01, 5.2943809282E+00, 1.5025749917E+00, 1.0532893329E+00, 7.7276247644E-01],
	[1.9300000000E+04, 1.0529967102E+01, 5.2942231014E+00, 1.5038189749E+00, 1.0539341976E+00, 7.7286347070E-01],
	[1.9305000000E+04, 1.0533958482E+01, 5.2940653202E+00, 1.5050636648E+00, 1.0545791632E+00, 7.7296442921E-01],
	[1.9310000000E+04, 1.0537950340E+01, 5.2939075845E+00, 1.5063090614E+00, 1.0552242294E+00, 7.7306535196E-01],
	[1.9315000000E+04, 1.0541942677E+01, 5.2937498944E+00, 1.5075551651E+00, 1.0558693961E+00, 7.7316623895E-01],
	[1.9320000000E+04, 1.0545935492E+01, 5.2935922498E+00, 1.5088019760E+00, 1.0565146630E+00, 7.7326709019E-01],
	[1.9325000000E+04, 1.0549928786E+01, 5.2934346507E+00, 1.5100494943E+00, 1.0571600301E+00, 7.7336790566E-01],
	[1.9330000000E+04, 1.0553922559E+01, 5.2932770970E+00, 1.5112977203E+00, 1.0578054971E+00, 7.7346868538E-01],
	[1.9335000000E+04, 1.0557916809E+01, 5.2931195888E+00, 1.5125466542E+00, 1.0584510640E+00, 7.7356942933E-01],
	[1.9340000000E+04, 1.0561911538E+01, 5.2929621260E+00, 1.5137962962E+00, 1.0590967305E+00, 7.7367013753E-01],
	[1.9345000000E+04, 1.0565906746E+01, 5.2928047086E+00, 1.5150466464E+00, 1.0597424965E+00, 7.7377080996E-01],
	[1.9350000000E+04, 1.0569902431E+01, 5.2926473365E+00, 1.5162977053E+00, 1.0603883618E+00, 7.7387144663E-01],
	[1.9355000000E+04, 1.0573898595E+01, 5.2924900098E+00, 1.5175494728E+00, 1.0610343263E+00, 7.7397204754E-01],
	[1.9360000000E+04, 1.0577895237E+01, 5.2923327283E+00, 1.5188019494E+00, 1.0616803898E+00, 7.7407261268E-01],
	[1.9365000000E+04, 1.0581892356E+01, 5.2921754922E+00, 1.5200551351E+00, 1.0623265521E+00, 7.7417314206E-01],
	[1.9370000000E+04, 1.0585889954E+01, 5.2920183013E+00, 1.5213090302E+00, 1.0629728131E+00, 7.7427363567E-01],
	[1.9375000000E+04, 1.0589888029E+01, 5.2918611557E+00, 1.5225636349E+00, 1.0636191726E+00, 7.7437409351E-01],
	[1.9380000000E+04, 1.0593886582E+01, 5.2917040553E+00, 1.5238189495E+00, 1.0642656304E+00, 7.7447451559E-01],
	[1.9385000000E+04, 1.0597885613E+01, 5.2915470001E+00, 1.5250749742E+00, 1.0649121864E+00, 7.7457490191E-01],
	[1.9390000000E+04, 1.0601885122E+01, 5.2913899900E+00, 1.5263317091E+00, 1.0655588405E+00, 7.7467525245E-01],
	[1.9395000000E+04, 1.0605885108E+01, 5.2912330251E+00, 1.5275891545E+00, 1.0662055924E+00, 7.7477556723E-01],
	[1.9400000000E+04, 1.0609885572E+01, 5.2910761053E+00, 1.5288473106E+00, 1.0668524421E+00, 7.7487584623E-01],
	[1.9405000000E+04, 1.0613886513E+01, 5.2909192305E+00, 1.5301061777E+00, 1.0674993892E+00, 7.7497608947E-01],
	[1.9410000000E+04, 1.0617887931E+01, 5.2907624009E+00, 1.5313657558E+00, 1.0681464338E+00, 7.7507629694E-01],
	[1.9415000000E+04, 1.0621889827E+01, 5.2906056163E+00, 1.5326260454E+00, 1.0687935755E+00, 7.7517646864E-01],
	[1.9420000000E+04, 1.0625892200E+01, 5.2904488767E+00, 1.5338870465E+00, 1.0694408143E+00, 7.7527660457E-01],
	[1.9425000000E+04, 1.0629895050E+01, 5.2902921821E+00, 1.5351487595E+00, 1.0700881501E+00, 7.7537670473E-01],
	[1.9430000000E+04, 1.0633898378E+01, 5.2901355324E+00, 1.5364111844E+00, 1.0707355825E+00, 7.7547676912E-01],
	[1.9435000000E+04, 1.0637913348E+01, 5.2899820182E+00, 1.5376743216E+00, 1.0713833515E+00, 7.7557679774E-01],
	[1.9440000000E+04, 1.0641935467E+01, 5.2898303918E+00, 1.5389381712E+00, 1.0720313607E+00, 7.7567679059E-01],
	[1.9445000000E+04, 1.0645958071E+01, 5.2896788088E+00, 1.5402027336E+00, 1.0726794669E+00, 7.7577674767E-01],
	[1.9450000000E+04, 1.0649981162E+01, 5.2895272690E+00, 1.5414680088E+00, 1.0733276699E+00, 7.7587666897E-01],
	[1.9455000000E+04, 1.0654004737E+01, 5.2893757726E+00, 1.5427339971E+00, 1.0739759695E+00, 7.7597655450E-01],
	[1.9460000000E+04, 1.0658028799E+01, 5.2892243195E+00, 1.5440006987E+00, 1.0746243655E+00, 7.7607640426E-01],
	[1.9465000000E+04, 1.0662053345E+01, 5.2890729095E+00, 1.5452681138E+00, 1.0752728579E+00, 7.7617621825E-01],
	[1.9470000000E+04, 1.0666078378E+01, 5.2889215428E+00, 1.5465362428E+00, 1.0759214464E+00, 7.7627599647E-01],
	[1.9475000000E+04, 1.0670103896E+01, 5.2887702193E+00, 1.5478050857E+00, 1.0765701308E+00, 7.7637573891E-01],
	[1.9480000000E+04, 1.0674129899E+01, 5.2886189390E+00, 1.5490746428E+00, 1.0772189111E+00, 7.7647544559E-01],
	[1.9485000000E+04, 1.0678156387E+01, 5.2884677018E+00, 1.5503449143E+00, 1.0778677870E+00, 7.7657511649E-01],
	[1.9490000000E+04, 1.0682183360E+01, 5.2883165078E+00, 1.5516159004E+00, 1.0785167585E+00, 7.7667475162E-01],
	[1.9495000000E+04, 1.0686210819E+01, 5.2881653568E+00, 1.5528876014E+00, 1.0791658252E+00, 7.7677435097E-01],
	[1.9500000000E+04, 1.0690238763E+01, 5.2880142490E+00, 1.5541600175E+00, 1.0798149871E+00, 7.7687391456E-01],
	[1.9505000000E+04, 1.0694267191E+01, 5.2878631841E+00, 1.5554331488E+00, 1.0804642440E+00, 7.7697344237E-01],
	[1.9510000000E+04, 1.0698296105E+01, 5.2877121624E+00, 1.5567069957E+00, 1.0811135958E+00, 7.7707293441E-01],
	[1.9515000000E+04, 1.0702325503E+01, 5.2875611836E+00, 1.5579815583E+00, 1.0817630422E+00, 7.7717239068E-01],
	[1.9520000000E+04, 1.0706355386E+01, 5.2874102478E+00, 1.5592568368E+00, 1.0824125832E+00, 7.7727181118E-01],
	[1.9525000000E+04, 1.0710385754E+01, 5.2872593550E+00, 1.5605328314E+00, 1.0830622185E+00, 7.7737119591E-01],
	[1.9530000000E+04, 1.0714416607E+01, 5.2871085051E+00, 1.5618095425E+00, 1.0837119480E+00, 7.7747054486E-01],
	[1.9535000000E+04, 1.0718447944E+01, 5.2869576982E+00, 1.5630869701E+00, 1.0843617715E+00, 7.7756985805E-01],
	[1.9540000000E+04, 1.0722479766E+01, 5.2868069341E+00, 1.5643651146E+00, 1.0850116889E+00, 7.7766913546E-01],
	[1.9545000000E+04, 1.0726512072E+01, 5.2866562129E+00, 1.5656439760E+00, 1.0856617000E+00, 7.7776837711E-01],
	[1.9550000000E+04, 1.0730544863E+01, 5.2865055346E+00, 1.5669235548E+00, 1.0863118047E+00, 7.7786758298E-01],
	[1.9555000000E+04, 1.0734578138E+01, 5.2863548991E+00, 1.5682038510E+00, 1.0869620027E+00, 7.7796675309E-01],
	[1.9560000000E+04, 1.0738611897E+01, 5.2862043063E+00, 1.5694848648E+00, 1.0876122940E+00, 7.7806588742E-01],
	[1.9565000000E+04, 1.0742646140E+01, 5.2860537564E+00, 1.5707665966E+00, 1.0882626783E+00, 7.7816498599E-01],
	[1.9570000000E+04, 1.0746680868E+01, 5.2859032492E+00, 1.5720490465E+00, 1.0889131555E+00, 7.7826404879E-01],
	[1.9575000000E+04, 1.0750716080E+01, 5.2857527848E+00, 1.5733322147E+00, 1.0895637255E+00, 7.7836307582E-01],
	[1.9580000000E+04, 1.0754751775E+01, 5.2856023630E+00, 1.5746161015E+00, 1.0902143880E+00, 7.7846206708E-01],
	[1.9585000000E+04, 1.0758787955E+01, 5.2854519840E+00, 1.5759007071E+00, 1.0908651430E+00, 7.7856102258E-01],
	[1.9590000000E+04, 1.0762824618E+01, 5.2853016476E+00, 1.5771860316E+00, 1.0915159902E+00, 7.7865994231E-01],
	[1.9595000000E+04, 1.0766861765E+01, 5.2851513538E+00, 1.5784720754E+00, 1.0921669295E+00, 7.7875882627E-01],
	[1.9600000000E+04, 1.0770899396E+01, 5.2850011027E+00, 1.5797588386E+00, 1.0928179607E+00, 7.7885767447E-01],
	[1.9605000000E+04, 1.0774937511E+01, 5.2848508941E+00, 1.5810463214E+00, 1.0934690837E+00, 7.7895648691E-01],
	[1.9610000000E+04, 1.0778976109E+01, 5.2847007282E+00, 1.5823345241E+00, 1.0941202983E+00, 7.7905526358E-01],
	[1.9615000000E+04, 1.0783015191E+01, 5.2845506047E+00, 1.5836234469E+00, 1.0947716043E+00, 7.7915400449E-01],
	[1.9620000000E+04, 1.0787054756E+01, 5.2844005238E+00, 1.5849130900E+00, 1.0954230016E+00, 7.7925270963E-01],
	[1.9625000000E+04, 1.0791094805E+01, 5.2842504854E+00, 1.5862034536E+00, 1.0960744901E+00, 7.7935137901E-01],
	[1.9630000000E+04, 1.0795135337E+01, 5.2841004895E+00, 1.5874945380E+00, 1.0967260694E+00, 7.7945001263E-01],
	[1.9635000000E+04, 1.0799176353E+01, 5.2839505361E+00, 1.5887863433E+00, 1.0973777396E+00, 7.7954861049E-01],
	[1.9640000000E+04, 1.0803217851E+01, 5.2838006250E+00, 1.5900788698E+00, 1.0980295004E+00, 7.7964717260E-01],
	[1.9645000000E+04, 1.0807259833E+01, 5.2836507564E+00, 1.5913721176E+00, 1.0986813517E+00, 7.7974569894E-01],
	[1.9650000000E+04, 1.0811302298E+01, 5.2835009302E+00, 1.5926660871E+00, 1.0993332933E+00, 7.7984418952E-01],
	[1.9655000000E+04, 1.0815345246E+01, 5.2833511464E+00, 1.5939607784E+00, 1.0999853250E+00, 7.7994264435E-01],
	[1.9660000000E+04, 1.0819388676E+01, 5.2832014048E+00, 1.5952561918E+00, 1.1006374468E+00, 7.8004106342E-01],
	[1.9665000000E+04, 1.0823432590E+01, 5.2830517056E+00, 1.5965523274E+00, 1.1012896583E+00, 7.8013944673E-01],
	[1.9670000000E+04, 1.0827476987E+01, 5.2829020487E+00, 1.5978491855E+00, 1.1019419595E+00, 7.8023779429E-01],
	[1.9675000000E+04, 1.0831521866E+01, 5.2827524341E+00, 1.5991467663E+00, 1.1025943502E+00, 7.8033610610E-01],
	[1.9680000000E+04, 1.0835567228E+01, 5.2826028618E+00, 1.6004450701E+00, 1.1032468302E+00, 7.8043438215E-01],
	[1.9685000000E+04, 1.0839613073E+01, 5.2824533316E+00, 1.6017440969E+00, 1.1038993994E+00, 7.8053262246E-01],
	[1.9690000000E+04, 1.0843659400E+01, 5.2823038437E+00, 1.6030438472E+00, 1.1045520577E+00, 7.8063082701E-01],
	[1.9695000000E+04, 1.0847706209E+01, 5.2821543979E+00, 1.6043443210E+00, 1.1052048047E+00, 7.8072899581E-01],
	[1.9700000000E+04, 1.0851753502E+01, 5.2820049943E+00, 1.6056455186E+00, 1.1058576405E+00, 7.8082712886E-01],
	[1.9705000000E+04, 1.0855801276E+01, 5.2818556329E+00, 1.6069474402E+00, 1.1065105648E+00, 7.8092522617E-01],
	[1.9710000000E+04, 1.0859849533E+01, 5.2817063136E+00, 1.6082500860E+00, 1.1071635775E+00, 7.8102328773E-01],
	[1.9715000000E+04, 1.0863898272E+01, 5.2815570363E+00, 1.6095534563E+00, 1.1078166783E+00, 7.8112131354E-01],
	[1.9720000000E+04, 1.0867947493E+01, 5.2814078012E+00, 1.6108575513E+00, 1.1084698672E+00, 7.8121930361E-01],
	[1.9725000000E+04, 1.0871997196E+01, 5.2812586080E+00, 1.6121623711E+00, 1.1091231440E+00, 7.8131725794E-01],
	[1.9730000000E+04, 1.0876047382E+01, 5.2811094570E+00, 1.6134679160E+00, 1.1097765085E+00, 7.8141517652E-01],
	[1.9735000000E+04, 1.0880098049E+01, 5.2809603479E+00, 1.6147741863E+00, 1.1104299605E+00, 7.8151305937E-01],
	[1.9740000000E+04, 1.0884149199E+01, 5.2808112808E+00, 1.6160811821E+00, 1.1110835000E+00, 7.8161090647E-01],
	[1.9745000000E+04, 1.0888201945E+01, 5.2806625521E+00, 1.6173889037E+00, 1.1117371514E+00, 7.8170871784E-01],
	[1.9750000000E+04, 1.0892272354E+01, 5.2805184321E+00, 1.6186973512E+00, 1.1123912718E+00, 7.8180649347E-01],
	[1.9755000000E+04, 1.0896343255E+01, 5.2803743526E+00, 1.6200065250E+00, 1.1130454799E+00, 7.8190423337E-01],
	[1.9760000000E+04, 1.0900414646E+01, 5.2802303134E+00, 1.6213164252E+00, 1.1136997754E+00, 7.8200193753E-01],
	[1.9765000000E+04, 1.0904486528E+01, 5.2800863147E+00, 1.6226270520E+00, 1.1143541582E+00, 7.8209960596E-01],
	[1.9770000000E+04, 1.0908558901E+01, 5.2799423562E+00, 1.6239384056E+00, 1.1150086282E+00, 7.8219723866E-01],
	[1.9775000000E+04, 1.0912631764E+01, 5.2797984381E+00, 1.6252504863E+00, 1.1156631851E+00, 7.8229483563E-01],
	[1.9780000000E+04, 1.0916705117E+01, 5.2796545603E+00, 1.6265632943E+00, 1.1163178289E+00, 7.8239239687E-01],
	[1.9785000000E+04, 1.0920778960E+01, 5.2795107228E+00, 1.6278768298E+00, 1.1169725593E+00, 7.8248992238E-01],
	[1.9790000000E+04, 1.0924853294E+01, 5.2793669256E+00, 1.6291910931E+00, 1.1176273763E+00, 7.8258741217E-01],
	[1.9795000000E+04, 1.0928928119E+01, 5.2792231686E+00, 1.6305060843E+00, 1.1182822796E+00, 7.8268486623E-01],
	[1.9800000000E+04, 1.0933003433E+01, 5.2790794518E+00, 1.6318218036E+00, 1.1189372690E+00, 7.8278228457E-01],
	[1.9805000000E+04, 1.0937079237E+01, 5.2789357752E+00, 1.6331382514E+00, 1.1195923445E+00, 7.8287966719E-01],
	[1.9810000000E+04, 1.0941155532E+01, 5.2787921388E+00, 1.6344554277E+00, 1.1202475058E+00, 7.8297701409E-01],
	[1.9815000000E+04, 1.0945232316E+01, 5.2786485425E+00, 1.6357733328E+00, 1.1209027528E+00, 7.8307432528E-01],
	[1.9820000000E+04, 1.0949309590E+01, 5.2785049864E+00, 1.6370919670E+00, 1.1215580854E+00, 7.8317160075E-01],
	[1.9825000000E+04, 1.0953387354E+01, 5.2783614704E+00, 1.6384113305E+00, 1.1222135033E+00, 7.8326884050E-01],
	[1.9830000000E+04, 1.0957465608E+01, 5.2782179944E+00, 1.6397314234E+00, 1.1228690064E+00, 7.8336604454E-01],
	[1.9835000000E+04, 1.0961544352E+01, 5.2780745586E+00, 1.6410522460E+00, 1.1235245946E+00, 7.8346321287E-01],
	[1.9840000000E+04, 1.0965623585E+01, 5.2779311628E+00, 1.6423737986E+00, 1.1241802677E+00, 7.8356034549E-01],
	[1.9845000000E+04, 1.0969703308E+01, 5.2777878070E+00, 1.6436960812E+00, 1.1248360254E+00, 7.8365744241E-01],
	[1.9850000000E+04, 1.0973783520E+01, 5.2776444913E+00, 1.6450190942E+00, 1.1254918678E+00, 7.8375450362E-01],
	[1.9855000000E+04, 1.0977864222E+01, 5.2775012155E+00, 1.6463428378E+00, 1.1261477945E+00, 7.8385152912E-01],
	[1.9860000000E+04, 1.0981945413E+01, 5.2773579797E+00, 1.6476673122E+00, 1.1268038055E+00, 7.8394851892E-01],
	[1.9865000000E+04, 1.0986027093E+01, 5.2772147838E+00, 1.6489925175E+00, 1.1274599006E+00, 7.8404547302E-01],
	[1.9870000000E+04, 1.0990109263E+01, 5.2770716278E+00, 1.6503184541E+00, 1.1281160796E+00, 7.8414239143E-01],
	[1.9875000000E+04, 1.0994191922E+01, 5.2769285118E+00, 1.6516451222E+00, 1.1287723423E+00, 7.8423927414E-01],
	[1.9880000000E+04, 1.0998275070E+01, 5.2767854356E+00, 1.6529725219E+00, 1.1294286886E+00, 7.8433612115E-01],
	[1.9885000000E+04, 1.1002358707E+01, 5.2766423993E+00, 1.6543006535E+00, 1.1300851184E+00, 7.8443293247E-01],
	[1.9890000000E+04, 1.1006442833E+01, 5.2764994028E+00, 1.6556295171E+00, 1.1307416314E+00, 7.8452970810E-01],
	[1.9895000000E+04, 1.1010527448E+01, 5.2763564462E+00, 1.6569591131E+00, 1.1313982276E+00, 7.8462644804E-01],
	[1.9900000000E+04, 1.1014612552E+01, 5.2762135293E+00, 1.6582894417E+00, 1.1320549067E+00, 7.8472315229E-01],
	[1.9905000000E+04, 1.1018698144E+01, 5.2760706522E+00, 1.6596205030E+00, 1.1327116686E+00, 7.8481982086E-01],
	[1.9910000000E+04, 1.1022784225E+01, 5.2759278149E+00, 1.6609522972E+00, 1.1333685131E+00, 7.8491645375E-01],
	[1.9915000000E+04, 1.1026870795E+01, 5.2757850173E+00, 1.6622848247E+00, 1.1340254401E+00, 7.8501305095E-01],
	[1.9920000000E+04, 1.1030957854E+01, 5.2756422594E+00, 1.6636180856E+00, 1.1346824493E+00, 7.8510961248E-01],
	[1.9925000000E+04, 1.1035045401E+01, 5.2754995412E+00, 1.6649520801E+00, 1.1353395407E+00, 7.8520613833E-01],
	[1.9930000000E+04, 1.1039133437E+01, 5.2753568626E+00, 1.6662868084E+00, 1.1359967141E+00, 7.8530262849E-01],
	[1.9935000000E+04, 1.1043221961E+01, 5.2752142237E+00, 1.6676222708E+00, 1.1366539694E+00, 7.8539908298E-01],
	[1.9940000000E+04, 1.1047310973E+01, 5.2750716245E+00, 1.6689584676E+00, 1.1373113062E+00, 7.8549550180E-01],
	[1.9945000000E+04, 1.1051400474E+01, 5.2749290648E+00, 1.6702953988E+00, 1.1379687246E+00, 7.8559188493E-01],
	[1.9950000000E+04, 1.1055490463E+01, 5.2747865447E+00, 1.6716330647E+00, 1.1386262243E+00, 7.8568823240E-01],
	[1.9955000000E+04, 1.1059580940E+01, 5.2746440642E+00, 1.6729714656E+00, 1.1392838052E+00, 7.8578454418E-01],
	[1.9960000000E+04, 1.1063671905E+01, 5.2745016233E+00, 1.6743106016E+00, 1.1399414671E+00, 7.8588082030E-01],
	[1.9965000000E+04, 1.1067763358E+01, 5.2743592218E+00, 1.6756504731E+00, 1.1405992098E+00, 7.8597706074E-01],
	[1.9970000000E+04, 1.1071855299E+01, 5.2742168599E+00, 1.6769910801E+00, 1.1412570333E+00, 7.8607326551E-01],
	[1.9975000000E+04, 1.1075947728E+01, 5.2740745374E+00, 1.6783324230E+00, 1.1419149372E+00, 7.8616943461E-01],
	[1.9980000000E+04, 1.1080040645E+01, 5.2739322544E+00, 1.6796745018E+00, 1.1425729216E+00, 7.8626556805E-01],
	[1.9985000000E+04, 1.1084134049E+01, 5.2737900109E+00, 1.6810173170E+00, 1.1432309861E+00, 7.8636166581E-01],
	[1.9990000000E+04, 1.1088227942E+01, 5.2736478067E+00, 1.6823608686E+00, 1.1438891307E+00, 7.8645772791E-01],
	[1.9995000000E+04, 1.1092322322E+01, 5.2735056420E+00, 1.6837051569E+00, 1.1445473552E+00, 7.8655375434E-01],
	[2.0000000000E+04, 1.1096417189E+01, 5.2733635166E+00, 1.6850501822E+00, 1.1452056594E+00, 7.8664974511E-01],
	[2.0005000000E+04, 1.1100512544E+01, 5.2732214306E+00, 1.6863980917E+00, 1.1458650344E+00, 7.8674570021E-01],
	[2.0010000000E+04, 1.1104608387E+01, 5.2730793839E+00, 1.6877467415E+00, 1.1465244894E+00, 7.8684161965E-01],
	[2.0015000000E+04, 1.1108704717E+01, 5.2729373766E+00, 1.6890961320E+00, 1.1471840241E+00, 7.8693750343E-01],
	[2.0020000000E+04, 1.1112801534E+01, 5.2727954085E+00, 1.6904462632E+00, 1.1478436383E+00, 7.8703335155E-01],
	[2.0025000000E+04, 1.1116898838E+01, 5.2726534797E+00, 1.6917971355E+00, 1.1485033320E+00, 7.8712916401E-01],
	[2.0030000000E+04, 1.1120996630E+01, 5.2725115901E+00, 1.6931487491E+00, 1.1491631050E+00, 7.8722494082E-01],
	[2.0035000000E+04, 1.1125094909E+01, 5.2723697398E+00, 1.6945011040E+00, 1.1498229570E+00, 7.8732068197E-01],
	[2.0040000000E+04, 1.1129193675E+01, 5.2722279287E+00, 1.6958542007E+00, 1.1504828880E+00, 7.8741638746E-01],
	[2.0045000000E+04, 1.1133292928E+01, 5.2720861568E+00, 1.6972080393E+00, 1.1511428977E+00, 7.8751205731E-01],
	[2.0050000000E+04, 1.1137392667E+01, 5.2719444241E+00, 1.6985626201E+00, 1.1518029861E+00, 7.8760769149E-01],
	[2.0055000000E+04, 1.1141492894E+01, 5.2718027305E+00, 1.6999179432E+00, 1.1524631528E+00, 7.8770329003E-01],
	[2.0060000000E+04, 1.1145593608E+01, 5.2716610760E+00, 1.7012740088E+00, 1.1531233979E+00, 7.8779885293E-01],
	[2.0065000000E+04, 1.1149703938E+01, 5.2715218012E+00, 1.7026308173E+00, 1.1537839310E+00, 7.8789438017E-01],
	[2.0070000000E+04, 1.1153824326E+01, 5.2713850160E+00, 1.7039883687E+00, 1.1544447625E+00, 7.8798987177E-01],
	[2.0075000000E+04, 1.1157945210E+01, 5.2712482684E+00, 1.7053466634E+00, 1.1551056725E+00, 7.8808532772E-01],
	[2.0080000000E+04, 1.1162066590E+01, 5.2711115584E+00, 1.7067057016E+00, 1.1557666608E+00, 7.8818074803E-01],
	[2.0085000000E+04, 1.1166188465E+01, 5.2709748860E+00, 1.7080654835E+00, 1.1564277274E+00, 7.8827613270E-01],
	[2.0090000000E+04, 1.1170310835E+01, 5.2708382512E+00, 1.7094260092E+00, 1.1570888721E+00, 7.8837148173E-01],
	[2.0095000000E+04, 1.1174433702E+01, 5.2707016539E+00, 1.7107872791E+00, 1.1577500946E+00, 7.8846679512E-01],
	[2.0100000000E+04, 1.1178557063E+01, 5.2705650941E+00, 1.7121492933E+00, 1.1584113949E+00, 7.8856207288E-01],
	[2.0105000000E+04, 1.1182680920E+01, 5.2704285719E+00, 1.7135120521E+00, 1.1590727727E+00, 7.8865731500E-01],
	[2.0110000000E+04, 1.1186805272E+01, 5.2702920871E+00, 1.7148755556E+00, 1.1597342280E+00, 7.8875252149E-01],
	[2.0115000000E+04, 1.1190930120E+01, 5.2701556398E+00, 1.7162398042E+00, 1.1603957605E+00, 7.8884769234E-01],
	[2.0120000000E+04, 1.1195055463E+01, 5.2700192299E+00, 1.7176047980E+00, 1.1610573701E+00, 7.8894282757E-01],
	[2.0125000000E+04, 1.1199181301E+01, 5.2698828574E+00, 1.7189705372E+00, 1.1617190566E+00, 7.8903792717E-01],
	[2.0130000000E+04, 1.1203307633E+01, 5.2697465224E+00, 1.7203370222E+00, 1.1623808199E+00, 7.8913299114E-01],
	[2.0135000000E+04, 1.1207434461E+01, 5.2696102247E+00, 1.7217042530E+00, 1.1630426598E+00, 7.8922801949E-01],
	[2.0140000000E+04, 1.1211561784E+01, 5.2694739644E+00, 1.7230722299E+00, 1.1637045762E+00, 7.8932301222E-01],
	[2.0145000000E+04, 1.1215689602E+01, 5.2693377415E+00, 1.7244409532E+00, 1.1643665688E+00, 7.8941796933E-01],
	[2.0150000000E+04, 1.1219817914E+01, 5.2692015559E+00, 1.7258104230E+00, 1.1650286375E+00, 7.8951289082E-01],
	[2.0155000000E+04, 1.1223946721E+01, 5.2690654076E+00, 1.7271806396E+00, 1.1656907822E+00, 7.8960777669E-01],
	[2.0160000000E+04, 1.1228076023E+01, 5.2689292965E+00, 1.7285516031E+00, 1.1663530027E+00, 7.8970262695E-01],
	[2.0165000000E+04, 1.1232205819E+01, 5.2687932228E+00, 1.7299233140E+00, 1.1670152988E+00, 7.8979744159E-01],
	[2.0170000000E+04, 1.1236336110E+01, 5.2686571863E+00, 1.7312957722E+00, 1.1676776705E+00, 7.8989222062E-01],
	[2.0175000000E+04, 1.1240466896E+01, 5.2685211870E+00, 1.7326689781E+00, 1.1683401174E+00, 7.8998696405E-01],
	[2.0180000000E+04, 1.1244598176E+01, 5.2683852249E+00, 1.7340429319E+00, 1.1690026395E+00, 7.9008167187E-01],
	[2.0185000000E+04, 1.1248729950E+01, 5.2682493000E+00, 1.7354176338E+00, 1.1696652365E+00, 7.9017634408E-01],
	[2.0190000000E+04, 1.1252862218E+01, 5.2681134123E+00, 1.7367930840E+00, 1.1703279084E+00, 7.9027098069E-01],
	[2.0195000000E+04, 1.1256994981E+01, 5.2679775618E+00, 1.7381692828E+00, 1.1709906550E+00, 7.9036558170E-01],
	[2.0200000000E+04, 1.1261128238E+01, 5.2678417483E+00, 1.7395462304E+00, 1.1716534761E+00, 7.9046014711E-01],
	[2.0205000000E+04, 1.1265261989E+01, 5.2677059720E+00, 1.7409239269E+00, 1.1723163715E+00, 7.9055467693E-01],
	[2.0210000000E+04, 1.1269396234E+01, 5.2675702328E+00, 1.7423023726E+00, 1.1729793411E+00, 7.9064917115E-01],
	[2.0215000000E+04, 1.1273530973E+01, 5.2674345307E+00, 1.7436815678E+00, 1.1736423848E+00, 7.9074362978E-01],
	[2.0220000000E+04, 1.1277666206E+01, 5.2672988656E+00, 1.7450615127E+00, 1.1743055023E+00, 7.9083805282E-01],
	[2.0225000000E+04, 1.1281801932E+01, 5.2671632375E+00, 1.7464422074E+00, 1.1749686935E+00, 7.9093244027E-01],
	[2.0230000000E+04, 1.1285938153E+01, 5.2670276465E+00, 1.7478236522E+00, 1.1756319582E+00, 7.9102679214E-01],
	[2.0235000000E+04, 1.1290074867E+01, 5.2668920924E+00, 1.7492058473E+00, 1.1762952963E+00, 7.9112110842E-01],
	[2.0240000000E+04, 1.1294212075E+01, 5.2667565754E+00, 1.7505887930E+00, 1.1769587077E+00, 7.9121538912E-01],
	[2.0245000000E+04, 1.1298349777E+01, 5.2666210953E+00, 1.7519724894E+00, 1.1776221921E+00, 7.9130963425E-01],
	[2.0250000000E+04, 1.1302487972E+01, 5.2664856521E+00, 1.7533569368E+00, 1.1782857494E+00, 7.9140384380E-01],
	[2.0255000000E+04, 1.1306626660E+01, 5.2663502459E+00, 1.7547421354E+00, 1.1789493795E+00, 7.9149801777E-01],
	[2.0260000000E+04, 1.1310765842E+01, 5.2662148765E+00, 1.7561280855E+00, 1.1796130821E+00, 7.9159215618E-01],
	[2.0265000000E+04, 1.1314905517E+01, 5.2660795441E+00, 1.7575147872E+00, 1.1802768571E+00, 7.9168625901E-01],
	[2.0270000000E+04, 1.1319045686E+01, 5.2659442485E+00, 1.7589022407E+00, 1.1809407044E+00, 7.9178032628E-01],
	[2.0275000000E+04, 1.1323186347E+01, 5.2658089897E+00, 1.7602904464E+00, 1.1816046238E+00, 7.9187435799E-01],
	[2.0280000000E+04, 1.1327327502E+01, 5.2656737678E+00, 1.7616794044E+00, 1.1822686151E+00, 7.9196835413E-01],
	[2.0285000000E+04, 1.1331469150E+01, 5.2655385827E+00, 1.7630691149E+00, 1.1829326782E+00, 7.9206231472E-01],
	[2.0290000000E+04, 1.1335611291E+01, 5.2654034343E+00, 1.7644595781E+00, 1.1835968129E+00, 7.9215623975E-01],
	[2.0295000000E+04, 1.1339753925E+01, 5.2652683228E+00, 1.7658507944E+00, 1.1842610191E+00, 7.9225012922E-01],
	[2.0300000000E+04, 1.1343897052E+01, 5.2651332480E+00, 1.7672427638E+00, 1.1849252965E+00, 7.9234398315E-01],
	[2.0305000000E+04, 1.1348040671E+01, 5.2649982099E+00, 1.7686354867E+00, 1.1855896451E+00, 7.9243780152E-01],
	[2.0310000000E+04, 1.1352184784E+01, 5.2648632085E+00, 1.7700289632E+00, 1.1862540647E+00, 7.9253158435E-01],
	[2.0315000000E+04, 1.1356329389E+01, 5.2647282438E+00, 1.7714231935E+00, 1.1869185550E+00, 7.9262533164E-01],
	[2.0320000000E+04, 1.1360474487E+01, 5.2645933158E+00, 1.7728181780E+00, 1.1875831160E+00, 7.9271904338E-01],
	[2.0325000000E+04, 1.1364620077E+01, 5.2644584244E+00, 1.7742139167E+00, 1.1882477475E+00, 7.9281271959E-01],
	[2.0330000000E+04, 1.1368766160E+01, 5.2643235697E+00, 1.7756104100E+00, 1.1889124493E+00, 7.9290636026E-01],
	[2.0335000000E+04, 1.1372912735E+01, 5.2641887516E+00, 1.7770076580E+00, 1.1895772213E+00, 7.9299996540E-01],
	[2.0340000000E+04, 1.1377059803E+01, 5.2640539701E+00, 1.7784056611E+00, 1.1902420632E+00, 7.9309353501E-01],
	[2.0345000000E+04, 1.1381207363E+01, 5.2639192252E+00, 1.7798044193E+00, 1.1909069751E+00, 7.9318706909E-01],
	[2.0350000000E+04, 1.1385355416E+01, 5.2637845168E+00, 1.7812039329E+00, 1.1915719566E+00, 7.9328056765E-01],
	[2.0355000000E+04, 1.1389503960E+01, 5.2636498449E+00, 1.7826042021E+00, 1.1922370076E+00, 7.9337403069E-01],
	[2.0360000000E+04, 1.1393652997E+01, 5.2635152096E+00, 1.7840052272E+00, 1.1929021280E+00, 7.9346745821E-01],
	[2.0365000000E+04, 1.1397802526E+01, 5.2633806108E+00, 1.7854070084E+00, 1.1935673176E+00, 7.9356085021E-01],
	[2.0370000000E+04, 1.1401952547E+01, 5.2632460485E+00, 1.7868095459E+00, 1.1942325762E+00, 7.9365420670E-01],
	[2.0375000000E+04, 1.1406103060E+01, 5.2631115226E+00, 1.7882128399E+00, 1.1948979037E+00, 7.9374752768E-01],
	[2.0380000000E+04, 1.1410254064E+01, 5.2629770332E+00, 1.7896168907E+00, 1.1955632999E+00, 7.9384081315E-01],
	[2.0385000000E+04, 1.1414405561E+01, 5.2628425802E+00, 1.7910216984E+00, 1.1962287647E+00, 7.9393406312E-01],
	[2.0390000000E+04, 1.1418574451E+01, 5.2627123738E+00, 1.7924272634E+00, 1.1968947013E+00, 7.9402727759E-01],
	[2.0395000000E+04, 1.1422745878E+01, 5.2625827098E+00, 1.7938335857E+00, 1.1975607556E+00, 7.9412045656E-01],
	[2.0400000000E+04, 1.1426917807E+01, 5.2624530809E+00, 1.7952406657E+00, 1.1982268786E+00, 7.9421360003E-01],
	[2.0405000000E+04, 1.1431090236E+01, 5.2623234869E+00, 1.7966485035E+00, 1.1988930704E+00, 7.9430670802E-01],
	[2.0410000000E+04, 1.1435263166E+01, 5.2621939279E+00, 1.7980570994E+00, 1.1995593306E+00, 7.9439978051E-01],
	[2.0415000000E+04, 1.1439436596E+01, 5.2620644038E+00, 1.7994664536E+00, 1.2002256592E+00, 7.9449281752E-01],
	[2.0420000000E+04, 1.1443610527E+01, 5.2619349146E+00, 1.8008765663E+00, 1.2008920560E+00, 7.9458581904E-01],
	[2.0425000000E+04, 1.1447784959E+01, 5.2618054603E+00, 1.8022874378E+00, 1.2015585209E+00, 7.9467878509E-01],
	[2.0430000000E+04, 1.1451959891E+01, 5.2616760408E+00, 1.8036990682E+00, 1.2022250536E+00, 7.9477171566E-01],
	[2.0435000000E+04, 1.1456135323E+01, 5.2615466563E+00, 1.8051114578E+00, 1.2028916540E+00, 7.9486461076E-01],
	[2.0440000000E+04, 1.1460311256E+01, 5.2614173065E+00, 1.8065246068E+00, 1.2035583219E+00, 7.9495747038E-01],
	[2.0445000000E+04, 1.1464487689E+01, 5.2612879916E+00, 1.8079385155E+00, 1.2042250573E+00, 7.9505029454E-01],
	[2.0450000000E+04, 1.1468664622E+01, 5.2611587114E+00, 1.8093531840E+00, 1.2048918599E+00, 7.9514308324E-01],
	[2.0455000000E+04, 1.1472842055E+01, 5.2610294661E+00, 1.8107686126E+00, 1.2055587296E+00, 7.9523583647E-01],
	[2.0460000000E+04, 1.1477019988E+01, 5.2609002555E+00, 1.8121848014E+00, 1.2062256662E+00, 7.9532855425E-01],
	[2.0465000000E+04, 1.1481198421E+01, 5.2607710796E+00, 1.8136017508E+00, 1.2068926695E+00, 7.9542123657E-01],
	[2.0470000000E+04, 1.1485377355E+01, 5.2606419385E+00, 1.8150194610E+00, 1.2075597394E+00, 7.9551388345E-01],
	[2.0475000000E+04, 1.1489556788E+01, 5.2605128321E+00, 1.8164379320E+00, 1.2082268758E+00, 7.9560649487E-01],
	[2.0480000000E+04, 1.1493736720E+01, 5.2603837603E+00, 1.8178571643E+00, 1.2088940784E+00, 7.9569907086E-01],
	[2.0485000000E+04, 1.1497917153E+01, 5.2602547233E+00, 1.8192771580E+00, 1.2095613472E+00, 7.9579161140E-01],
	[2.0490000000E+04, 1.1502098085E+01, 5.2601257209E+00, 1.8206979133E+00, 1.2102286819E+00, 7.9588411650E-01],
	[2.0495000000E+04, 1.1506279517E+01, 5.2599967531E+00, 1.8221194305E+00, 1.2108960824E+00, 7.9597658618E-01],
	[2.0500000000E+04, 1.1510461449E+01, 5.2598678200E+00, 1.8235417097E+00, 1.2115635485E+00, 7.9606902042E-01],
	[2.0505000000E+04, 1.1514643880E+01, 5.2597389214E+00, 1.8249647512E+00, 1.2122310801E+00, 7.9616141923E-01],
	[2.0510000000E+04, 1.1518826810E+01, 5.2596100575E+00, 1.8263885552E+00, 1.2128986770E+00, 7.9625378263E-01],
	[2.0515000000E+04, 1.1523010240E+01, 5.2594812281E+00, 1.8278131220E+00, 1.2135663391E+00, 7.9634611060E-01],
	[2.0520000000E+04, 1.1527194169E+01, 5.2593524333E+00, 1.8292384517E+00, 1.2142340662E+00, 7.9643840315E-01],
	[2.0525000000E+04, 1.1531378597E+01, 5.2592236730E+00, 1.8306645447E+00, 1.2149018581E+00, 7.9653066030E-01],
	[2.0530000000E+04, 1.1535563525E+01, 5.2590949472E+00, 1.8320914010E+00, 1.2155697147E+00, 7.9662288203E-01],
	[2.0535000000E+04, 1.1539748952E+01, 5.2589662559E+00, 1.8335190209E+00, 1.2162376358E+00, 7.9671506836E-01],
	[2.0540000000E+04, 1.1543934877E+01, 5.2588375991E+00, 1.8349474047E+00, 1.2169056213E+00, 7.9680721929E-01],
	[2.0545000000E+04, 1.1548121302E+01, 5.2587089767E+00, 1.8363765526E+00, 1.2175736710E+00, 7.9689933482E-01],
	[2.0550000000E+04, 1.1552308226E+01, 5.2585803888E+00, 1.8378064647E+00, 1.2182417847E+00, 7.9699141495E-01],
	[2.0555000000E+04, 1.1556495648E+01, 5.2584518353E+00, 1.8392371414E+00, 1.2189099622E+00, 7.9708345970E-01],
	[2.0560000000E+04, 1.1560683570E+01, 5.2583233162E+00, 1.8406685828E+00, 1.2195782036E+00, 7.9717546905E-01],
	[2.0565000000E+04, 1.1564871990E+01, 5.2581948316E+00, 1.8421007892E+00, 1.2202465084E+00, 7.9726744303E-01],
	[2.0570000000E+04, 1.1569060908E+01, 5.2580663812E+00, 1.8435337607E+00, 1.2209148767E+00, 7.9735938162E-01],
	[2.0575000000E+04, 1.1573250326E+01, 5.2579379653E+00, 1.8449674976E+00, 1.2215833082E+00, 7.9745128484E-01],
	[2.0580000000E+04, 1.1577440242E+01, 5.2578095837E+00, 1.8464020002E+00, 1.2222518028E+00, 7.9754315269E-01],
	[2.0585000000E+04, 1.1581630656E+01, 5.2576812364E+00, 1.8478372686E+00, 1.2229203603E+00, 7.9763498516E-01],
	[2.0590000000E+04, 1.1585821569E+01, 5.2575529234E+00, 1.8492733031E+00, 1.2235889806E+00, 7.9772678228E-01],
	[2.0595000000E+04, 1.1590012981E+01, 5.2574246447E+00, 1.8507101039E+00, 1.2242576635E+00, 7.9781854403E-01],
	[2.0600000000E+04, 1.1594204890E+01, 5.2572964002E+00, 1.8521476712E+00, 1.2249264088E+00, 7.9791027042E-01],
	[2.0605000000E+04, 1.1598397298E+01, 5.2571681900E+00, 1.8535860052E+00, 1.2255952164E+00, 7.9800196147E-01],
	[2.0610000000E+04, 1.1602590204E+01, 5.2570400141E+00, 1.8550251062E+00, 1.2262640862E+00, 7.9809361716E-01],
	[2.0615000000E+04, 1.1606783609E+01, 5.2569118723E+00, 1.8564649744E+00, 1.2269330179E+00, 7.9818523745E-01],
	[2.0620000000E+04, 1.1610977511E+01, 5.2567837648E+00, 1.8579056099E+00, 1.2276020114E+00, 7.9827682228E-01],
	[2.0625000000E+04, 1.1615171911E+01, 5.2566556914E+00, 1.8593470131E+00, 1.2282710666E+00, 7.9836837164E-01],
	[2.0630000000E+04, 1.1619366810E+01, 5.2565276522E+00, 1.8607891842E+00, 1.2289401832E+00, 7.9845988554E-01],
	[2.0635000000E+04, 1.1623562206E+01, 5.2563996472E+00, 1.8622321233E+00, 1.2296093612E+00, 7.9855136400E-01],
	[2.0640000000E+04, 1.1627758100E+01, 5.2562716763E+00, 1.8636758307E+00, 1.2302786004E+00, 7.9864280702E-01],
	[2.0645000000E+04, 1.1631954492E+01, 5.2561437395E+00, 1.8651203066E+00, 1.2309479006E+00, 7.9873421461E-01],
	[2.0650000000E+04, 1.1636151381E+01, 5.2560158367E+00, 1.8665655512E+00, 1.2316172616E+00, 7.9882558677E-01],
	[2.0655000000E+04, 1.1640348768E+01, 5.2558879681E+00, 1.8680115648E+00, 1.2322866833E+00, 7.9891692353E-01],
	[2.0660000000E+04, 1.1644546653E+01, 5.2557601335E+00, 1.8694583476E+00, 1.2329561656E+00, 7.9900822488E-01],
	[2.0665000000E+04, 1.1648745035E+01, 5.2556323330E+00, 1.8709058998E+00, 1.2336257082E+00, 7.9909949083E-01],
	[2.0670000000E+04, 1.1652943915E+01, 5.2555045665E+00, 1.8723542216E+00, 1.2342953111E+00, 7.9919072140E-01],
	[2.0675000000E+04, 1.1657143292E+01, 5.2553768340E+00, 1.8738033133E+00, 1.2349649740E+00, 7.9928191659E-01],
	[2.0680000000E+04, 1.1661343166E+01, 5.2552491354E+00, 1.8752531751E+00, 1.2356346968E+00, 7.9937307641E-01],
	[2.0685000000E+04, 1.1665543538E+01, 5.2551214709E+00, 1.8767038071E+00, 1.2363044794E+00, 7.9946420086E-01],
	[2.0690000000E+04, 1.1669744407E+01, 5.2549938403E+00, 1.8781552096E+00, 1.2369743215E+00, 7.9955528996E-01],
	[2.0695000000E+04, 1.1673945773E+01, 5.2548662436E+00, 1.8796073829E+00, 1.2376442231E+00, 7.9964634372E-01],
	[2.0700000000E+04, 1.1678147636E+01, 5.2547386809E+00, 1.8810603272E+00, 1.2383141839E+00, 7.9973736214E-01],
	[2.0705000000E+04, 1.1682349996E+01, 5.2546111521E+00, 1.8825140426E+00, 1.2389842039E+00, 7.9982834523E-01],
	[2.0710000000E+04, 1.1686552854E+01, 5.2544836572E+00, 1.8839685294E+00, 1.2396542827E+00, 7.9991929301E-01],
	[2.0715000000E+04, 1.1690761123E+01, 5.2543573877E+00, 1.8854237879E+00, 1.2403245421E+00, 8.0001020547E-01],
	[2.0720000000E+04, 1.1694984141E+01, 5.2542346043E+00, 1.8868798182E+00, 1.2409952134E+00, 8.0010108263E-01],
	[2.0725000000E+04, 1.1699207664E+01, 5.2541118534E+00, 1.8883366206E+00, 1.2416659439E+00, 8.0019192450E-01],
	[2.0730000000E+04, 1.1703431693E+01, 5.2539891349E+00, 1.8897941952E+00, 1.2423367335E+00, 8.0028273108E-01],
	[2.0735000000E+04, 1.1707656228E+01, 5.2538664489E+00, 1.8912525424E+00, 1.2430075820E+00, 8.0037350238E-01],
	[2.0740000000E+04, 1.1711881269E+01, 5.2537437954E+00, 1.8927116624E+00, 1.2436784893E+00, 8.0046423842E-01],
	[2.0745000000E+04, 1.1716106816E+01, 5.2536211743E+00, 1.8941715552E+00, 1.2443494552E+00, 8.0055493920E-01],
	[2.0750000000E+04, 1.1720332868E+01, 5.2534985856E+00, 1.8956322213E+00, 1.2450204795E+00, 8.0064560473E-01],
	[2.0755000000E+04, 1.1724559426E+01, 5.2533760293E+00, 1.8970936608E+00, 1.2456915621E+00, 8.0073623501E-01],
	[2.0760000000E+04, 1.1728786489E+01, 5.2532535054E+00, 1.8985558739E+00, 1.2463627029E+00, 8.0082683007E-01],
	[2.0765000000E+04, 1.1733014058E+01, 5.2531310138E+00, 1.9000188609E+00, 1.2470339016E+00, 8.0091738990E-01],
	[2.0770000000E+04, 1.1737242132E+01, 5.2530085546E+00, 1.9014826219E+00, 1.2477051582E+00, 8.0100791451E-01],
	[2.0775000000E+04, 1.1741470712E+01, 5.2528861278E+00, 1.9029471573E+00, 1.2483764724E+00, 8.0109840391E-01],
	[2.0780000000E+04, 1.1745699797E+01, 5.2527637332E+00, 1.9044124671E+00, 1.2490478441E+00, 8.0118885812E-01],
	[2.0785000000E+04, 1.1749929387E+01, 5.2526413709E+00, 1.9058785517E+00, 1.2497192731E+00, 8.0127927714E-01],
	[2.0790000000E+04, 1.1754159482E+01, 5.2525190409E+00, 1.9073454113E+00, 1.2503907594E+00, 8.0136966098E-01],
	[2.0795000000E+04, 1.1758390083E+01, 5.2523967432E+00, 1.9088130461E+00, 1.2510623026E+00, 8.0146000964E-01],
	[2.0800000000E+04, 1.1762621188E+01, 5.2522744777E+00, 1.9102814562E+00, 1.2517339027E+00, 8.0155032314E-01],
	[2.0805000000E+04, 1.1766852799E+01, 5.2521522445E+00, 1.9117506420E+00, 1.2524055596E+00, 8.0164060149E-01],
	[2.0810000000E+04, 1.1771084914E+01, 5.2520300435E+00, 1.9132206037E+00, 1.2530772730E+00, 8.0173084469E-01],
	[2.0815000000E+04, 1.1775317534E+01, 5.2519078747E+00, 1.9146913414E+00, 1.2537490428E+00, 8.0182105275E-01],
	[2.0820000000E+04, 1.1779550659E+01, 5.2517857380E+00, 1.9161628554E+00, 1.2544208688E+00, 8.0191122568E-01],
	[2.0825000000E+04, 1.1783784289E+01, 5.2516636335E+00, 1.9176351460E+00, 1.2550927509E+00, 8.0200136350E-01],
	[2.0830000000E+04, 1.1788018424E+01, 5.2515415612E+00, 1.9191082133E+00, 1.2557646889E+00, 8.0209146620E-01],
	[2.0835000000E+04, 1.1792253063E+01, 5.2514195210E+00, 1.9205820576E+00, 1.2564366827E+00, 8.0218153380E-01],
	[2.0840000000E+04, 1.1796488207E+01, 5.2512975130E+00, 1.9220566790E+00, 1.2571087321E+00, 8.0227156631E-01],
	[2.0845000000E+04, 1.1800723855E+01, 5.2511755370E+00, 1.9235320779E+00, 1.2577808369E+00, 8.0236156374E-01],
	[2.0850000000E+04, 1.1804960007E+01, 5.2510535931E+00, 1.9250082544E+00, 1.2584529970E+00, 8.0245152609E-01],
	[2.0855000000E+04, 1.1809196664E+01, 5.2509316813E+00, 1.9264852088E+00, 1.2591252123E+00, 8.0254145337E-01],
	[2.0860000000E+04, 1.1813433826E+01, 5.2508098015E+00, 1.9279629413E+00, 1.2597974825E+00, 8.0263134559E-01],
	[2.0865000000E+04, 1.1817671491E+01, 5.2506879538E+00, 1.9294414520E+00, 1.2604698076E+00, 8.0272120276E-01],
	[2.0870000000E+04, 1.1821909661E+01, 5.2505661381E+00, 1.9309207413E+00, 1.2611421873E+00, 8.0281102490E-01],
	[2.0875000000E+04, 1.1826148335E+01, 5.2504443544E+00, 1.9324008093E+00, 1.2618146215E+00, 8.0290081200E-01],
	[2.0880000000E+04, 1.1830387513E+01, 5.2503226028E+00, 1.9338816564E+00, 1.2624871101E+00, 8.0299056408E-01],
	[2.0885000000E+04, 1.1834627195E+01, 5.2502008830E+00, 1.9353632826E+00, 1.2631596529E+00, 8.0308028115E-01],
	[2.0890000000E+04, 1.1838867381E+01, 5.2500791953E+00, 1.9368456882E+00, 1.2638322497E+00, 8.0316996321E-01],
	[2.0895000000E+04, 1.1843108071E+01, 5.2499575394E+00, 1.9383288735E+00, 1.2645049003E+00, 8.0325961027E-01],
	[2.0900000000E+04, 1.1847349265E+01, 5.2498359155E+00, 1.9398128386E+00, 1.2651776047E+00, 8.0334922235E-01],
	[2.0905000000E+04, 1.1851590962E+01, 5.2497143235E+00, 1.9412975838E+00, 1.2658503626E+00, 8.0343879945E-01],
	[2.0910000000E+04, 1.1855833163E+01, 5.2495927634E+00, 1.9427831094E+00, 1.2665231740E+00, 8.0352834158E-01],
	[2.0915000000E+04, 1.1860075868E+01, 5.2494712352E+00, 1.9442694154E+00, 1.2671960385E+00, 8.0361784876E-01],
	[2.0920000000E+04, 1.1864319076E+01, 5.2493497389E+00, 1.9457565023E+00, 1.2678689562E+00, 8.0370732098E-01],
	[2.0925000000E+04, 1.1868562788E+01, 5.2492282744E+00, 1.9472443701E+00, 1.2685419268E+00, 8.0379675825E-01],
	[2.0930000000E+04, 1.1872807004E+01, 5.2491068417E+00, 1.9487330191E+00, 1.2692149502E+00, 8.0388616060E-01],
	[2.0935000000E+04, 1.1877051723E+01, 5.2489854408E+00, 1.9502224495E+00, 1.2698880262E+00, 8.0397552802E-01],
	[2.0940000000E+04, 1.1881296945E+01, 5.2488640717E+00, 1.9517126616E+00, 1.2705611546E+00, 8.0406486052E-01],
	[2.0945000000E+04, 1.1885542670E+01, 5.2487427345E+00, 1.9532036555E+00, 1.2712343353E+00, 8.0415415812E-01],
	[2.0950000000E+04, 1.1889788899E+01, 5.2486214289E+00, 1.9546954316E+00, 1.2719075682E+00, 8.0424342082E-01],
	[2.0955000000E+04, 1.1894035631E+01, 5.2485001552E+00, 1.9561879899E+00, 1.2725808531E+00, 8.0433264864E-01],
	[2.0960000000E+04, 1.1898282866E+01, 5.2483789131E+00, 1.9576813308E+00, 1.2732541898E+00, 8.0442184157E-01],
	[2.0965000000E+04, 1.1902530604E+01, 5.2482577028E+00, 1.9591754545E+00, 1.2739275782E+00, 8.0451099964E-01],
	[2.0970000000E+04, 1.1906778845E+01, 5.2481365242E+00, 1.9606703611E+00, 1.2746010181E+00, 8.0460012284E-01],
	[2.0975000000E+04, 1.1911027589E+01, 5.2480153773E+00, 1.9621660510E+00, 1.2752745093E+00, 8.0468921119E-01],
	[2.0980000000E+04, 1.1915276835E+01, 5.2478942620E+00, 1.9636625243E+00, 1.2759480518E+00, 8.0477826470E-01],
	[2.0985000000E+04, 1.1919526585E+01, 5.2477731784E+00, 1.9651597812E+00, 1.2766216453E+00, 8.0486728337E-01],
	[2.0990000000E+04, 1.1923776837E+01, 5.2476521264E+00, 1.9666578220E+00, 1.2772952897E+00, 8.0495626722E-01],
	[2.0995000000E+04, 1.1928027592E+01, 5.2475311061E+00, 1.9681566470E+00, 1.2779689848E+00, 8.0504521625E-01],
	[2.1000000000E+04, 1.1932278850E+01, 5.2474101174E+00, 1.9696562562E+00, 1.2786427305E+00, 8.0513413047E-01],
	[2.1005000000E+04, 1.1936530610E+01, 5.2472891602E+00, 1.9711566500E+00, 1.2793165266E+00, 8.0522300990E-01],
	[2.1010000000E+04, 1.1940782873E+01, 5.2471682347E+00, 1.9726578285E+00, 1.2799903730E+00, 8.0531185454E-01],
	[2.1015000000E+04, 1.1945035638E+01, 5.2470473407E+00, 1.9741597921E+00, 1.2806642695E+00, 8.0540066440E-01],
	[2.1020000000E+04, 1.1949288905E+01, 5.2469264782E+00, 1.9756625409E+00, 1.2813382159E+00, 8.0548943949E-01],
	[2.1025000000E+04, 1.1953542675E+01, 5.2468056473E+00, 1.9771660751E+00, 1.2820122122E+00, 8.0557817982E-01],
	[2.1030000000E+04, 1.1957796947E+01, 5.2466848479E+00, 1.9786703949E+00, 1.2826862580E+00, 8.0566688539E-01],
	[2.1035000000E+04, 1.1962051722E+01, 5.2465640800E+00, 1.9801755007E+00, 1.2833603534E+00, 8.0575555623E-01],
	[2.1040000000E+04, 1.1966306998E+01, 5.2464433435E+00, 1.9816813925E+00, 1.2840344980E+00, 8.0584419232E-01],
	[2.1045000000E+04, 1.1970562777E+01, 5.2463226385E+00, 1.9831880707E+00, 1.2847086918E+00, 8.0593279370E-01],
	[2.1050000000E+04, 1.1974829994E+01, 5.2462045440E+00, 1.9846955355E+00, 1.2853832155E+00, 8.0602136036E-01],
	[2.1055000000E+04, 1.1979106175E+01, 5.2460884733E+00, 1.9862037870E+00, 1.2860580057E+00, 8.0610989231E-01],
	[2.1060000000E+04, 1.1983382867E+01, 5.2459724328E+00, 1.9877128255E+00, 1.2867328454E+00, 8.0619838956E-01],
	[2.1065000000E+04, 1.1987660070E+01, 5.2458564224E+00, 1.9892226512E+00, 1.2874077344E+00, 8.0628685213E-01],
	[2.1070000000E+04, 1.1991937784E+01, 5.2457404421E+00, 1.9907332644E+00, 1.2880826726E+00, 8.0637528002E-01],
	[2.1075000000E+04, 1.1996216009E+01, 5.2456244919E+00, 1.9922446653E+00, 1.2887576598E+00, 8.0646367324E-01],
	[2.1080000000E+04, 1.2000494745E+01, 5.2455085717E+00, 1.9937568540E+00, 1.2894326959E+00, 8.0655203180E-01],
	[2.1085000000E+04, 1.2004773991E+01, 5.2453926816E+00, 1.9952698309E+00, 1.2901077806E+00, 8.0664035571E-01],
	[2.1090000000E+04, 1.2009053749E+01, 5.2452768215E+00, 1.9967835961E+00, 1.2907829139E+00, 8.0672864497E-01],
	[2.1095000000E+04, 1.2013334017E+01, 5.2451609915E+00, 1.9982981499E+00, 1.2914580955E+00, 8.0681689960E-01],
	[2.1100000000E+04, 1.2017614796E+01, 5.2450451915E+00, 1.9998134924E+00, 1.2921333254E+00, 8.0690511961E-01],
	[2.1105000000E+04, 1.2021896085E+01, 5.2449294214E+00, 2.0013296240E+00, 1.2928086034E+00, 8.0699330501E-01],
	[2.1110000000E+04, 1.2026177885E+01, 5.2448136813E+00, 2.0028465448E+00, 1.2934839293E+00, 8.0708145580E-01],
	[2.1115000000E+04, 1.2030460195E+01, 5.2446979712E+00, 2.0043642550E+00, 1.2941593030E+00, 8.0716957199E-01],
	[2.1120000000E+04, 1.2034743015E+01, 5.2445822911E+00, 2.0058827550E+00, 1.2948347242E+00, 8.0725765360E-01],
	[2.1125000000E+04, 1.2039026346E+01, 5.2444666409E+00, 2.0074020448E+00, 1.2955101930E+00, 8.0734570063E-01],
	[2.1130000000E+04, 1.2043310188E+01, 5.2443510206E+00, 2.0089221248E+00, 1.2961857090E+00, 8.0743371310E-01],
	[2.1135000000E+04, 1.2047594539E+01, 5.2442354302E+00, 2.0104429951E+00, 1.2968612721E+00, 8.0752169100E-01],
	[2.1140000000E+04, 1.2051879401E+01, 5.2441198697E+00, 2.0119646560E+00, 1.2975368823E+00, 8.0760963436E-01],
	[2.1145000000E+04, 1.2056164772E+01, 5.2440043390E+00, 2.0134871076E+00, 1.2982125392E+00, 8.0769754318E-01],
	[2.1150000000E+04, 1.2060450654E+01, 5.2438888383E+00, 2.0150103503E+00, 1.2988882429E+00, 8.0778541746E-01],
	[2.1155000000E+04, 1.2064737046E+01, 5.2437733673E+00, 2.0165343843E+00, 1.2995639931E+00, 8.0787325723E-01],
	[2.1160000000E+04, 1.2069023947E+01, 5.2436579262E+00, 2.0180592097E+00, 1.3002397896E+00, 8.0796106248E-01],
	[2.1165000000E+04, 1.2073311359E+01, 5.2435425149E+00, 2.0195848267E+00, 1.3009156323E+00, 8.0804883323E-01],
	[2.1170000000E+04, 1.2077599280E+01, 5.2434271335E+00, 2.0211112357E+00, 1.3015915211E+00, 8.0813656949E-01],
	[2.1175000000E+04, 1.2081887711E+01, 5.2433117818E+00, 2.0226384369E+00, 1.3022674558E+00, 8.0822427126E-01],
	[2.1180000000E+04, 1.2086176651E+01, 5.2431964598E+00, 2.0241664304E+00, 1.3029434363E+00, 8.0831193856E-01],
	[2.1185000000E+04, 1.2090466101E+01, 5.2430811677E+00, 2.0256952164E+00, 1.3036194623E+00, 8.0839957140E-01],
	[2.1190000000E+04, 1.2094756061E+01, 5.2429659052E+00, 2.0272247953E+00, 1.3042955337E+00, 8.0848716977E-01],
	[2.1195000000E+04, 1.2099046531E+01, 5.2428506725E+00, 2.0287551672E+00, 1.3049716505E+00, 8.0857473371E-01],
	[2.1200000000E+04, 1.2103337509E+01, 5.2427354696E+00, 2.0302863324E+00, 1.3056478123E+00, 8.0866226320E-01],
	[2.1205000000E+04, 1.2107628997E+01, 5.2426202963E+00, 2.0318182910E+00, 1.3063240192E+00, 8.0874975827E-01],
	[2.1210000000E+04, 1.2111920995E+01, 5.2425051527E+00, 2.0333510434E+00, 1.3070002708E+00, 8.0883721892E-01],
	[2.1215000000E+04, 1.2116213501E+01, 5.2423900387E+00, 2.0348845896E+00, 1.3076765671E+00, 8.0892464516E-01],
	[2.1220000000E+04, 1.2120506517E+01, 5.2422749544E+00, 2.0364189300E+00, 1.3083529079E+00, 8.0901203701E-01],
	[2.1225000000E+04, 1.2124800042E+01, 5.2421598998E+00, 2.0379540648E+00, 1.3090292931E+00, 8.0909939446E-01],
	[2.1230000000E+04, 1.2129094076E+01, 5.2420448748E+00, 2.0394899942E+00, 1.3097057224E+00, 8.0918671753E-01],
	[2.1235000000E+04, 1.2133388619E+01, 5.2419298794E+00, 2.0410267184E+00, 1.3103821958E+00, 8.0927400623E-01],
	[2.1240000000E+04, 1.2137683671E+01, 5.2418149135E+00, 2.0425642376E+00, 1.3110587131E+00, 8.0936126058E-01],
	[2.1245000000E+04, 1.2141979232E+01, 5.2416999773E+00, 2.0441025521E+00, 1.3117352740E+00, 8.0944848056E-01],
	[2.1250000000E+04, 1.2146275302E+01, 5.2415850706E+00, 2.0456416620E+00, 1.3124118786E+00, 8.0953566621E-01],
	[2.1255000000E+04, 1.2150571880E+01, 5.2414701935E+00, 2.0471815677E+00, 1.3130885266E+00, 8.0962281753E-01],
	[2.1260000000E+04, 1.2154868967E+01, 5.2413553459E+00, 2.0487222693E+00, 1.3137652179E+00, 8.0970993452E-01],
	[2.1265000000E+04, 1.2159166563E+01, 5.2412405279E+00, 2.0502637671E+00, 1.3144419522E+00, 8.0979701719E-01],
	[2.1270000000E+04, 1.2163464668E+01, 5.2411257393E+00, 2.0518060613E+00, 1.3151187295E+00, 8.0988406556E-01],
	[2.1275000000E+04, 1.2167763281E+01, 5.2410109803E+00, 2.0533491520E+00, 1.3157955497E+00, 8.0997107964E-01],
	[2.1280000000E+04, 1.2172062402E+01, 5.2408962507E+00, 2.0548930396E+00, 1.3164724124E+00, 8.1005805943E-01],
	[2.1285000000E+04, 1.2176362032E+01, 5.2407815506E+00, 2.0564377243E+00, 1.3171493177E+00, 8.1014500495E-01],
	[2.1290000000E+04, 1.2180662170E+01, 5.2406668799E+00, 2.0579832062E+00, 1.3178262653E+00, 8.1023191618E-01],
	[2.1295000000E+04, 1.2184962817E+01, 5.2405522387E+00, 2.0595294856E+00, 1.3185032551E+00, 8.1031879310E-01],
	[2.1300000000E+04, 1.2189263972E+01, 5.2404376269E+00, 2.0610765627E+00, 1.3191802869E+00, 8.1040563570E-01],
	[2.1305000000E+04, 1.2193565635E+01, 5.2403230445E+00, 2.0626244378E+00, 1.3198573606E+00, 8.1049244399E-01],
	[2.1310000000E+04, 1.2197867806E+01, 5.2402084915E+00, 2.0641731111E+00, 1.3205344760E+00, 8.1057921797E-01],
	[2.1315000000E+04, 1.2202170485E+01, 5.2400939679E+00, 2.0657225827E+00, 1.3212116330E+00, 8.1066595764E-01],
	[2.1320000000E+04, 1.2206473672E+01, 5.2399794736E+00, 2.0672728530E+00, 1.3218888313E+00, 8.1075266301E-01],
	[2.1325000000E+04, 1.2210777367E+01, 5.2398650087E+00, 2.0688239221E+00, 1.3225660710E+00, 8.1083933409E-01],
	[2.1330000000E+04, 1.2215081571E+01, 5.2397505731E+00, 2.0703757903E+00, 1.3232433517E+00, 8.1092597086E-01],
	[2.1335000000E+04, 1.2219386281E+01, 5.2396361669E+00, 2.0719284577E+00, 1.3239206734E+00, 8.1101257335E-01],
	[2.1340000000E+04, 1.2223691500E+01, 5.2395217899E+00, 2.0734819247E+00, 1.3245980359E+00, 8.1109914154E-01],
	[2.1345000000E+04, 1.2227997226E+01, 5.2394074422E+00, 2.0750361914E+00, 1.3252754391E+00, 8.1118567545E-01],
	[2.1350000000E+04, 1.2232303460E+01, 5.2392931239E+00, 2.0765912581E+00, 1.3259528827E+00, 8.1127217508E-01],
	[2.1355000000E+04, 1.2236610202E+01, 5.2391788347E+00, 2.0781471249E+00, 1.3266303667E+00, 8.1135864043E-01],
	[2.1360000000E+04, 1.2240917451E+01, 5.2390645749E+00, 2.0797037922E+00, 1.3273078908E+00, 8.1144507151E-01],
	[2.1365000000E+04, 1.2245225208E+01, 5.2389503442E+00, 2.0812612601E+00, 1.3279854550E+00, 8.1153146832E-01],
	[2.1370000000E+04, 1.2249533471E+01, 5.2388361428E+00, 2.0828195288E+00, 1.3286630590E+00, 8.1161783086E-01],
	[2.1375000000E+04, 1.2253842243E+01, 5.2387219706E+00, 2.0843785986E+00, 1.3293407028E+00, 8.1170415914E-01],
	[2.1380000000E+04, 1.2258151521E+01, 5.2386078276E+00, 2.0859384697E+00, 1.3300183861E+00, 8.1179045316E-01],
	[2.1385000000E+04, 1.2262461307E+01, 5.2384937137E+00, 2.0874991424E+00, 1.3306961089E+00, 8.1187671293E-01],
	[2.1390000000E+04, 1.2266787259E+01, 5.2383832206E+00, 2.0890606168E+00, 1.3313742873E+00, 8.1196293844E-01],
	[2.1395000000E+04, 1.2271117693E+01, 5.2382736656E+00, 2.0906228931E+00, 1.3320526111E+00, 8.1204912970E-01],
	[2.1400000000E+04, 1.2275448644E+01, 5.2381641385E+00, 2.0921859717E+00, 1.3327309746E+00, 8.1213528672E-01],
	[2.1405000000E+04, 1.2279780111E+01, 5.2380546393E+00, 2.0937498527E+00, 1.3334093778E+00, 8.1222140951E-01],
	[2.1410000000E+04, 1.2284112094E+01, 5.2379451680E+00, 2.0953145363E+00, 1.3340878203E+00, 8.1230749805E-01],
	[2.1415000000E+04, 1.2288444593E+01, 5.2378357245E+00, 2.0968800228E+00, 1.3347663022E+00, 8.1239355236E-01],
	[2.1420000000E+04, 1.2292777608E+01, 5.2377263088E+00, 2.0984463124E+00, 1.3354448232E+00, 8.1247957245E-01],
	[2.1425000000E+04, 1.2297111140E+01, 5.2376169209E+00, 2.1000134053E+00, 1.3361233831E+00, 8.1256555831E-01],
	[2.1430000000E+04, 1.2301445187E+01, 5.2375075609E+00, 2.1015813018E+00, 1.3368019819E+00, 8.1265150994E-01],
	[2.1435000000E+04, 1.2305779750E+01, 5.2373982287E+00, 2.1031500020E+00, 1.3374806193E+00, 8.1273742737E-01],
	[2.1440000000E+04, 1.2310114829E+01, 5.2372889242E+00, 2.1047195062E+00, 1.3381592953E+00, 8.1282331057E-01],
	[2.1445000000E+04, 1.2314450424E+01, 5.2371796475E+00, 2.1062898146E+00, 1.3388380096E+00, 8.1290915957E-01],
	[2.1450000000E+04, 1.2318786534E+01, 5.2370703986E+00, 2.1078609275E+00, 1.3395167622E+00, 8.1299497437E-01],
	[2.1455000000E+04, 1.2323123160E+01, 5.2369611774E+00, 2.1094328450E+00, 1.3401955528E+00, 8.1308075496E-01],
	[2.1460000000E+04, 1.2327460302E+01, 5.2368519839E+00, 2.1110055674E+00, 1.3408743813E+00, 8.1316650136E-01],
	[2.1465000000E+04, 1.2331797959E+01, 5.2367428181E+00, 2.1125790949E+00, 1.3415532475E+00, 8.1325221357E-01],
	[2.1470000000E+04, 1.2336136132E+01, 5.2366336801E+00, 2.1141534277E+00, 1.3422321514E+00, 8.1333789159E-01],
	[2.1475000000E+04, 1.2340474820E+01, 5.2365245697E+00, 2.1157285661E+00, 1.3429110927E+00, 8.1342353542E-01],
	[2.1480000000E+04, 1.2344814023E+01, 5.2364154870E+00, 2.1173045102E+00, 1.3435900713E+00, 8.1350914507E-01],
	[2.1485000000E+04, 1.2349153742E+01, 5.2363064320E+00, 2.1188812604E+00, 1.3442690871E+00, 8.1359472055E-01],
	[2.1490000000E+04, 1.2353493976E+01, 5.2361974046E+00, 2.1204588168E+00, 1.3449481398E+00, 8.1368026186E-01],
	[2.1495000000E+04, 1.2357834725E+01, 5.2360884048E+00, 2.1220371796E+00, 1.3456272294E+00, 8.1376576899E-01],
	[2.1500000000E+04, 1.2362175989E+01, 5.2359794327E+00, 2.1236163492E+00, 1.3463063557E+00, 8.1385124197E-01],
	[2.1505000000E+04, 1.2366517769E+01, 5.2358704882E+00, 2.1251963256E+00, 1.3469855185E+00, 8.1393668078E-01],
	[2.1510000000E+04, 1.2370860063E+01, 5.2357615713E+00, 2.1267771091E+00, 1.3476647176E+00, 8.1402208544E-01],
	[2.1515000000E+04, 1.2375202872E+01, 5.2356526819E+00, 2.1283587000E+00, 1.3483439531E+00, 8.1410745595E-01],
	[2.1520000000E+04, 1.2379546196E+01, 5.2355438201E+00, 2.1299410985E+00, 1.3490232245E+00, 8.1419279232E-01],
	[2.1525000000E+04, 1.2383890035E+01, 5.2354349859E+00, 2.1315243048E+00, 1.3497025320E+00, 8.1427809454E-01],
	[2.1530000000E+04, 1.2388234389E+01, 5.2353261792E+00, 2.1331083190E+00, 1.3503818751E+00, 8.1436336262E-01],
	[2.1535000000E+04, 1.2392579257E+01, 5.2352174000E+00, 2.1346931416E+00, 1.3510612540E+00, 8.1444859658E-01],
	[2.1540000000E+04, 1.2396924641E+01, 5.2351086484E+00, 2.1362787725E+00, 1.3517406682E+00, 8.1453379640E-01],
	[2.1545000000E+04, 1.2401270538E+01, 5.2349999242E+00, 2.1378652122E+00, 1.3524201178E+00, 8.1461896210E-01],
	[2.1550000000E+04, 1.2405616950E+01, 5.2348912275E+00, 2.1394524608E+00, 1.3530996026E+00, 8.1470409367E-01],
	[2.1555000000E+04, 1.2409963877E+01, 5.2347825583E+00, 2.1410405186E+00, 1.3537791223E+00, 8.1478919114E-01],
	[2.1560000000E+04, 1.2414311318E+01, 5.2346739166E+00, 2.1426293857E+00, 1.3544586770E+00, 8.1487425449E-01],
	[2.1565000000E+04, 1.2418659274E+01, 5.2345653023E+00, 2.1442190624E+00, 1.3551382663E+00, 8.1495928373E-01],
	[2.1570000000E+04, 1.2423007743E+01, 5.2344567154E+00, 2.1458095489E+00, 1.3558178902E+00, 8.1504427888E-01],
	[2.1575000000E+04, 1.2427356727E+01, 5.2343481560E+00, 2.1474008454E+00, 1.3564975485E+00, 8.1512923992E-01],
	[2.1580000000E+04, 1.2431706226E+01, 5.2342396240E+00, 2.1489929522E+00, 1.3571772411E+00, 8.1521416688E-01],
	[2.1585000000E+04, 1.2436056238E+01, 5.2341311193E+00, 2.1505858695E+00, 1.3578569677E+00, 8.1529905974E-01],
	[2.1590000000E+04, 1.2440406764E+01, 5.2340226421E+00, 2.1521795975E+00, 1.3585367283E+00, 8.1538391852E-01],
	[2.1595000000E+04, 1.2444757805E+01, 5.2339141922E+00, 2.1537741364E+00, 1.3592165227E+00, 8.1546874322E-01],
	[2.1600000000E+04, 1.2449109359E+01, 5.2338057696E+00, 2.1553694865E+00, 1.3598963508E+00, 8.1555353385E-01],
	[2.1605000000E+04, 1.2453461427E+01, 5.2336973744E+00, 2.1569656480E+00, 1.3605762123E+00, 8.1563829041E-01],
	[2.1610000000E+04, 1.2457814009E+01, 5.2335890066E+00, 2.1585626211E+00, 1.3612561072E+00, 8.1572301290E-01],
	[2.1615000000E+04, 1.2462167105E+01, 5.2334806660E+00, 2.1601604060E+00, 1.3619360353E+00, 8.1580770133E-01],
	[2.1620000000E+04, 1.2466520715E+01, 5.2333723527E+00, 2.1617590029E+00, 1.3626159964E+00, 8.1589235570E-01],
	[2.1625000000E+04, 1.2470874838E+01, 5.2332640668E+00, 2.1633584122E+00, 1.3632959904E+00, 8.1597697603E-01],
	[2.1630000000E+04, 1.2475229475E+01, 5.2331558081E+00, 2.1649586339E+00, 1.3639760171E+00, 8.1606156230E-01],
	[2.1635000000E+04, 1.2479584625E+01, 5.2330475766E+00, 2.1665596684E+00, 1.3646560765E+00, 8.1614611454E-01],
	[2.1640000000E+04, 1.2483940289E+01, 5.2329393724E+00, 2.1681615158E+00, 1.3653361683E+00, 8.1623063274E-01],
	[2.1645000000E+04, 1.2488296466E+01, 5.2328311955E+00, 2.1697641764E+00, 1.3660162923E+00, 8.1631511691E-01],
	[2.1650000000E+04, 1.2492653157E+01, 5.2327230457E+00, 2.1713676504E+00, 1.3666964485E+00, 8.1639956705E-01],
	[2.1655000000E+04, 1.2497010361E+01, 5.2326149232E+00, 2.1729719380E+00, 1.3673766367E+00, 8.1648398316E-01],
	[2.1660000000E+04, 1.2501368078E+01, 5.2325068279E+00, 2.1745770395E+00, 1.3680568567E+00, 8.1656836526E-01],
	[2.1665000000E+04, 1.2505726308E+01, 5.2323987597E+00, 2.1761829550E+00, 1.3687371083E+00, 8.1665271335E-01],
	[2.1670000000E+04, 1.2510085052E+01, 5.2322907188E+00, 2.1777896849E+00, 1.3694173916E+00, 8.1673702743E-01],
	[2.1675000000E+04, 1.2514444308E+01, 5.2321827049E+00, 2.1793972292E+00, 1.3700977061E+00, 8.1682130751E-01],
	[2.1680000000E+04, 1.2518804078E+01, 5.2320747183E+00, 2.1810055883E+00, 1.3707780520E+00, 8.1690555359E-01],
	[2.1685000000E+04, 1.2523164361E+01, 5.2319667587E+00, 2.1826147624E+00, 1.3714584288E+00, 8.1698976567E-01],
	[2.1690000000E+04, 1.2527525156E+01, 5.2318588263E+00, 2.1842247517E+00, 1.3721388367E+00, 8.1707394377E-01],
	[2.1695000000E+04, 1.2531886464E+01, 5.2317509210E+00, 2.1858355564E+00, 1.3728192753E+00, 8.1715808788E-01],
	[2.1700000000E+04, 1.2536248285E+01, 5.2316430427E+00, 2.1874471767E+00, 1.3734997445E+00, 8.1724219802E-01],
	[2.1705000000E+04, 1.2540610619E+01, 5.2315351916E+00, 2.1890596129E+00, 1.3741802442E+00, 8.1732627419E-01],
	[2.1710000000E+04, 1.2544973466E+01, 5.2314273675E+00, 2.1906728652E+00, 1.3748607742E+00, 8.1741031638E-01],
	[2.1715000000E+04, 1.2549336825E+01, 5.2313195704E+00, 2.1922869339E+00, 1.3755413344E+00, 8.1749432461E-01],
	[2.1720000000E+04, 1.2553700697E+01, 5.2312118004E+00, 2.1939018190E+00, 1.3762219246E+00, 8.1757829889E-01],
	[2.1725000000E+04, 1.2558065081E+01, 5.2311040574E+00, 2.1955175209E+00, 1.3769025446E+00, 8.1766223921E-01],
	[2.1730000000E+04, 1.2562429977E+01, 5.2309963415E+00, 2.1971340399E+00, 1.3775831944E+00, 8.1774614559E-01],
	[2.1735000000E+04, 1.2566814073E+01, 5.2308928220E+00, 2.1987513760E+00, 1.3782643881E+00, 8.1783001802E-01],
	[2.1740000000E+04, 1.2571199869E+01, 5.2307895911E+00, 2.2003695296E+00, 1.3789456443E+00, 8.1791385652E-01],
	[2.1745000000E+04, 1.2575586185E+01, 5.2306863860E+00, 2.2019885008E+00, 1.3796269306E+00, 8.1799766108E-01],
	[2.1750000000E+04, 1.2579973024E+01, 5.2305832067E+00, 2.2036082899E+00, 1.3803082468E+00, 8.1808143172E-01],
	[2.1755000000E+04, 1.2584360383E+01, 5.2304800531E+00, 2.2052288971E+00, 1.3809895928E+00, 8.1816516843E-01],
	[2.1760000000E+04, 1.2588748264E+01, 5.2303769253E+00, 2.2068503227E+00, 1.3816709684E+00, 8.1824887123E-01],
	[2.1765000000E+04, 1.2593136667E+01, 5.2302738232E+00, 2.2084725669E+00, 1.3823523735E+00, 8.1833254012E-01],
	[2.1770000000E+04, 1.2597525590E+01, 5.2301707468E+00, 2.2100956298E+00, 1.3830338079E+00, 8.1841617510E-01],
	[2.1775000000E+04, 1.2601915035E+01, 5.2300676961E+00, 2.2117195117E+00, 1.3837152715E+00, 8.1849977618E-01],
	[2.1780000000E+04, 1.2606305001E+01, 5.2299646712E+00, 2.2133442129E+00, 1.3843967641E+00, 8.1858334337E-01],
	[2.1785000000E+04, 1.2610695488E+01, 5.2298616718E+00, 2.2149697335E+00, 1.3850782855E+00, 8.1866687666E-01],
	[2.1790000000E+04, 1.2615086496E+01, 5.2297586982E+00, 2.2165960738E+00, 1.3857598357E+00, 8.1875037607E-01],
	[2.1795000000E+04, 1.2619478025E+01, 5.2296557502E+00, 2.2182232340E+00, 1.3864414145E+00, 8.1883384161E-01],
	[2.1800000000E+04, 1.2623870075E+01, 5.2295528278E+00, 2.2198512144E+00, 1.3871230217E+00, 8.1891727326E-01],
	[2.1805000000E+04, 1.2628262645E+01, 5.2294499311E+00, 2.2214800151E+00, 1.3878046572E+00, 8.1900067105E-01],
	[2.1810000000E+04, 1.2632655737E+01, 5.2293470600E+00, 2.2231096364E+00, 1.3884863208E+00, 8.1908403498E-01],
	[2.1815000000E+04, 1.2637049349E+01, 5.2292442145E+00, 2.2247400785E+00, 1.3891680123E+00, 8.1916736505E-01],
	[2.1820000000E+04, 1.2641443482E+01, 5.2291413946E+00, 2.2263713416E+00, 1.3898497317E+00, 8.1925066127E-01],
	[2.1825000000E+04, 1.2645838135E+01, 5.2290386002E+00, 2.2280034260E+00, 1.3905314788E+00, 8.1933392364E-01],
	[2.1830000000E+04, 1.2650233309E+01, 5.2289358315E+00, 2.2296363319E+00, 1.3912132534E+00, 8.1941715217E-01],
	[2.1835000000E+04, 1.2654629003E+01, 5.2288330882E+00, 2.2312700595E+00, 1.3918950554E+00, 8.1950034686E-01],
	[2.1840000000E+04, 1.2659025218E+01, 5.2287303706E+00, 2.2329046090E+00, 1.3925768846E+00, 8.1958350772E-01],
	[2.1845000000E+04, 1.2663421954E+01, 5.2286276784E+00, 2.2345399807E+00, 1.3932587409E+00, 8.1966663476E-01],
	[2.1850000000E+04, 1.2667819209E+01, 5.2285250118E+00, 2.2361761747E+00, 1.3939406241E+00, 8.1974972798E-01],
	[2.1855000000E+04, 1.2672216985E+01, 5.2284223707E+00, 2.2378131914E+00, 1.3946225341E+00, 8.1983278738E-01],
	[2.1860000000E+04, 1.2676615281E+01, 5.2283197550E+00, 2.2394510309E+00, 1.3953044708E+00, 8.1991581298E-01],
	[2.1865000000E+04, 1.2681014097E+01, 5.2282171649E+00, 2.2410896934E+00, 1.3959864339E+00, 8.1999880478E-01],
	[2.1870000000E+04, 1.2685413433E+01, 5.2281146002E+00, 2.2427291792E+00, 1.3966684233E+00, 8.2008176278E-01],
	[2.1875000000E+04, 1.2689813290E+01, 5.2280120610E+00, 2.2443694885E+00, 1.3973504390E+00, 8.2016468699E-01],
	[2.1880000000E+04, 1.2694213666E+01, 5.2279095472E+00, 2.2460106216E+00, 1.3980324807E+00, 8.2024757741E-01],
	[2.1885000000E+04, 1.2698614562E+01, 5.2278070589E+00, 2.2476525786E+00, 1.3987145483E+00, 8.2033043405E-01],
	[2.1890000000E+04, 1.2703015978E+01, 5.2277045960E+00, 2.2492953598E+00, 1.3993966416E+00, 8.2041325692E-01],
	[2.1895000000E+04, 1.2707417914E+01, 5.2276021585E+00, 2.2509389654E+00, 1.4000787605E+00, 8.2049604602E-01],
	[2.1900000000E+04, 1.2711820370E+01, 5.2274997464E+00, 2.2525833956E+00, 1.4007609049E+00, 8.2057880136E-01],
	[2.1905000000E+04, 1.2716223345E+01, 5.2273973596E+00, 2.2542286506E+00, 1.4014430745E+00, 8.2066152294E-01],
	[2.1910000000E+04, 1.2720626840E+01, 5.2272949983E+00, 2.2558747308E+00, 1.4021252693E+00, 8.2074421077E-01],
	[2.1915000000E+04, 1.2725030854E+01, 5.2271926623E+00, 2.2575216362E+00, 1.4028074891E+00, 8.2082686486E-01],
	[2.1920000000E+04, 1.2729435388E+01, 5.2270903516E+00, 2.2591693672E+00, 1.4034897338E+00, 8.2090948520E-01],
	[2.1925000000E+04, 1.2733840442E+01, 5.2269880663E+00, 2.2608179239E+00, 1.4041720031E+00, 8.2099207181E-01],
	[2.1930000000E+04, 1.2738246015E+01, 5.2268858063E+00, 2.2624673066E+00, 1.4048542970E+00, 8.2107462470E-01],
	[2.1935000000E+04, 1.2742652107E+01, 5.2267835717E+00, 2.2641175155E+00, 1.4055366154E+00, 8.2115714386E-01],
	[2.1940000000E+04, 1.2747058718E+01, 5.2266813623E+00, 2.2657685509E+00, 1.4062189579E+00, 8.2123962931E-01],
	[2.1945000000E+04, 1.2751465849E+01, 5.2265791782E+00, 2.2674204129E+00, 1.4069013246E+00, 8.2132208104E-01],
	[2.1950000000E+04, 1.2755873499E+01, 5.2264770194E+00, 2.2690731017E+00, 1.4075837153E+00, 8.2140449908E-01],
	[2.1955000000E+04, 1.2760281668E+01, 5.2263748859E+00, 2.2707266177E+00, 1.4082661297E+00, 8.2148688341E-01],
	[2.1960000000E+04, 1.2764690356E+01, 5.2262727776E+00, 2.2723809610E+00, 1.4089485678E+00, 8.2156923405E-01],
	[2.1965000000E+04, 1.2769099563E+01, 5.2261706945E+00, 2.2740361318E+00, 1.4096310295E+00, 8.2165155101E-01],
	[2.1970000000E+04, 1.2773509289E+01, 5.2260686367E+00, 2.2756921304E+00, 1.4103135145E+00, 8.2173383428E-01],
	[2.1975000000E+04, 1.2777919534E+01, 5.2259666041E+00, 2.2773489570E+00, 1.4109960227E+00, 8.2181608388E-01],
	[2.1980000000E+04, 1.2782330298E+01, 5.2258645967E+00, 2.2790066119E+00, 1.4116785540E+00, 8.2189829981E-01],
	[2.1985000000E+04, 1.2786741580E+01, 5.2257626145E+00, 2.2806650951E+00, 1.4123611083E+00, 8.2198048208E-01],
	[2.1990000000E+04, 1.2791153381E+01, 5.2256606575E+00, 2.2823244071E+00, 1.4130436853E+00, 8.2206263070E-01],
	[2.1995000000E+04, 1.2795565701E+01, 5.2255587256E+00, 2.2839845480E+00, 1.4137262850E+00, 8.2214474566E-01],
	[2.2000000000E+04, 1.2799978539E+01, 5.2254568189E+00, 2.2856455180E+00, 1.4144089071E+00, 8.2222682698E-01],
	[2.2005000000E+04, 1.2804391896E+01, 5.2253549373E+00, 2.2873073173E+00, 1.4150915516E+00, 8.2230887466E-01],
	[2.2010000000E+04, 1.2808805772E+01, 5.2252530809E+00, 2.2889699462E+00, 1.4157742182E+00, 8.2239088871E-01],
	[2.2015000000E+04, 1.2813220166E+01, 5.2251512496E+00, 2.2906334049E+00, 1.4164569069E+00, 8.2247286913E-01],
	[2.2020000000E+04, 1.2817635078E+01, 5.2250494434E+00, 2.2922976937E+00, 1.4171396175E+00, 8.2255481593E-01],
	[2.2025000000E+04, 1.2822050509E+01, 5.2249476623E+00, 2.2939628127E+00, 1.4178223499E+00, 8.2263672912E-01],
	[2.2030000000E+04, 1.2826466458E+01, 5.2248459063E+00, 2.2956287622E+00, 1.4185051038E+00, 8.2271860871E-01],
	[2.2035000000E+04, 1.2830882925E+01, 5.2247441753E+00, 2.2972955423E+00, 1.4191878792E+00, 8.2280045469E-01],
	[2.2040000000E+04, 1.2835299910E+01, 5.2246424695E+00, 2.2989631534E+00, 1.4198706759E+00, 8.2288226707E-01],
	[2.2045000000E+04, 1.2839717413E+01, 5.2245407886E+00, 2.3006315957E+00, 1.4205534938E+00, 8.2296404587E-01],
	[2.2050000000E+04, 1.2844135435E+01, 5.2244391328E+00, 2.3023008693E+00, 1.4212363326E+00, 8.2304579108E-01],
	[2.2055000000E+04, 1.2848553974E+01, 5.2243375021E+00, 2.3039709745E+00, 1.4219191924E+00, 8.2312750272E-01],
	[2.2060000000E+04, 1.2852973031E+01, 5.2242358963E+00, 2.3056419116E+00, 1.4226020728E+00, 8.2320918079E-01],
	[2.2065000000E+04, 1.2857392606E+01, 5.2241343156E+00, 2.3073136807E+00, 1.4232849738E+00, 8.2329082530E-01],
	[2.2070000000E+04, 1.2861812699E+01, 5.2240327598E+00, 2.3089862821E+00, 1.4239678953E+00, 8.2337243624E-01],
	[2.2075000000E+04, 1.2866233310E+01, 5.2239312290E+00, 2.3106597160E+00, 1.4246508370E+00, 8.2345401364E-01],
	[2.2080000000E+04, 1.2870654438E+01, 5.2238297232E+00, 2.3123339826E+00, 1.4253337989E+00, 8.2353555749E-01],
	[2.2085000000E+04, 1.2875095691E+01, 5.2237324978E+00, 2.3140090821E+00, 1.4260173384E+00, 8.2361706780E-01],
	[2.2090000000E+04, 1.2879537972E+01, 5.2236354050E+00, 2.3156850149E+00, 1.4267009127E+00, 8.2369854458E-01],
	[2.2095000000E+04, 1.2883980780E+01, 5.2235383361E+00, 2.3173617810E+00, 1.4273845076E+00, 8.2377998784E-01],
	[2.2100000000E+04, 1.2888424114E+01, 5.2234412908E+00, 2.3190393808E+00, 1.4280681229E+00, 8.2386139758E-01],
	[2.2105000000E+04, 1.2892867976E+01, 5.2233442694E+00, 2.3207178144E+00, 1.4287517583E+00, 8.2394277380E-01],
	[2.2110000000E+04, 1.2897312363E+01, 5.2232472716E+00, 2.3223970821E+00, 1.4294354138E+00, 8.2402411652E-01],
	[2.2115000000E+04, 1.2901757278E+01, 5.2231502977E+00, 2.3240771841E+00, 1.4301190893E+00, 8.2410542573E-01],
	[2.2120000000E+04, 1.2906202719E+01, 5.2230533474E+00, 2.3257581206E+00, 1.4308027845E+00, 8.2418670146E-01],
	[2.2125000000E+04, 1.2910648687E+01, 5.2229564208E+00, 2.3274398919E+00, 1.4314864993E+00, 8.2426794369E-01],
	[2.2130000000E+04, 1.2915095180E+01, 5.2228595180E+00, 2.3291224982E+00, 1.4321702336E+00, 8.2434915245E-01],
	[2.2135000000E+04, 1.2919542201E+01, 5.2227626388E+00, 2.3308059396E+00, 1.4328539872E+00, 8.2443032773E-01],
	[2.2140000000E+04, 1.2923989747E+01, 5.2226657833E+00, 2.3324902165E+00, 1.4335377600E+00, 8.2451146955E-01],
	[2.2145000000E+04, 1.2928437820E+01, 5.2225689515E+00, 2.3341753291E+00, 1.4342215519E+00, 8.2459257790E-01],
	[2.2150000000E+04, 1.2932886419E+01, 5.2224721433E+00, 2.3358612775E+00, 1.4349053626E+00, 8.2467365280E-01],
	[2.2155000000E+04, 1.2937335544E+01, 5.2223753588E+00, 2.3375480620E+00, 1.4355891921E+00, 8.2475469425E-01],
	[2.2160000000E+04, 1.2941785196E+01, 5.2222785979E+00, 2.3392356829E+00, 1.4362730402E+00, 8.2483570226E-01],
	[2.2165000000E+04, 1.2946235373E+01, 5.2221818607E+00, 2.3409241403E+00, 1.4369569068E+00, 8.2491667684E-01],
	[2.2170000000E+04, 1.2950686076E+01, 5.2220851470E+00, 2.3426134345E+00, 1.4376407916E+00, 8.2499761799E-01],
	[2.2175000000E+04, 1.2955137305E+01, 5.2219884569E+00, 2.3443035657E+00, 1.4383246947E+00, 8.2507852572E-01],
	[2.2180000000E+04, 1.2959589060E+01, 5.2218917905E+00, 2.3459945342E+00, 1.4390086157E+00, 8.2515940003E-01],
	[2.2185000000E+04, 1.2964041341E+01, 5.2217951476E+00, 2.3476863400E+00, 1.4396925546E+00, 8.2524024093E-01],
	[2.2190000000E+04, 1.2968494147E+01, 5.2216985283E+00, 2.3493789836E+00, 1.4403765113E+00, 8.2532104844E-01],
	[2.2195000000E+04, 1.2972947480E+01, 5.2216019325E+00, 2.3510724651E+00, 1.4410604855E+00, 8.2540182255E-01],
	[2.2200000000E+04, 1.2977401337E+01, 5.2215053603E+00, 2.3527667847E+00, 1.4417444772E+00, 8.2548256327E-01],
	[2.2205000000E+04, 1.2981855721E+01, 5.2214088116E+00, 2.3544619427E+00, 1.4424284862E+00, 8.2556327061E-01],
	[2.2210000000E+04, 1.2986310630E+01, 5.2213122864E+00, 2.3561579393E+00, 1.4431125123E+00, 8.2564394457E-01],
	[2.2215000000E+04, 1.2990766064E+01, 5.2212157848E+00, 2.3578547746E+00, 1.4437965554E+00, 8.2572458517E-01],
	[2.2220000000E+04, 1.2995222024E+01, 5.2211193066E+00, 2.3595524490E+00, 1.4444806154E+00, 8.2580519241E-01],
	[2.2225000000E+04, 1.2999678509E+01, 5.2210228519E+00, 2.3612509627E+00, 1.4451646921E+00, 8.2588576629E-01],
	[2.2230000000E+04, 1.3004135519E+01, 5.2209264207E+00, 2.3629503158E+00, 1.4458487854E+00, 8.2596630683E-01],
	[2.2235000000E+04, 1.3008593055E+01, 5.2208300130E+00, 2.3646505087E+00, 1.4465328951E+00, 8.2604681402E-01],
	[2.2240000000E+04, 1.3013051116E+01, 5.2207336288E+00, 2.3663515415E+00, 1.4472170211E+00, 8.2612728789E-01],
	[2.2245000000E+04, 1.3017509702E+01, 5.2206372679E+00, 2.3680534144E+00, 1.4479011632E+00, 8.2620772842E-01],
	[2.2250000000E+04, 1.3021968813E+01, 5.2205409306E+00, 2.3697561278E+00, 1.4485853213E+00, 8.2628813564E-01],
	[2.2255000000E+04, 1.3026428449E+01, 5.2204446166E+00, 2.3714596817E+00, 1.4492694952E+00, 8.2636850954E-01],
	[2.2260000000E+04, 1.3030888609E+01, 5.2203483261E+00, 2.3731640765E+00, 1.4499536849E+00, 8.2644885014E-01],
	[2.2265000000E+04, 1.3035349295E+01, 5.2202520589E+00, 2.3748693124E+00, 1.4506378901E+00, 8.2652915743E-01],
	[2.2270000000E+04, 1.3039810506E+01, 5.2201558152E+00, 2.3765753895E+00, 1.4513221107E+00, 8.2660943144E-01],
	[2.2275000000E+04, 1.3044272241E+01, 5.2200595948E+00, 2.3782823082E+00, 1.4520063466E+00, 8.2668967216E-01],
	[2.2280000000E+04, 1.3048734502E+01, 5.2199633978E+00, 2.3799900686E+00, 1.4526905976E+00, 8.2676987960E-01],
	[2.2285000000E+04, 1.3053197286E+01, 5.2198672241E+00, 2.3816986710E+00, 1.4533748636E+00, 8.2685005377E-01],
	[2.2290000000E+04, 1.3057660596E+01, 5.2197710738E+00, 2.3834081155E+00, 1.4540591444E+00, 8.2693019468E-01],
	[2.2295000000E+04, 1.3062124430E+01, 5.2196749469E+00, 2.3851184025E+00, 1.4547434399E+00, 8.2701030233E-01],
	[2.2300000000E+04, 1.3066588788E+01, 5.2195788432E+00, 2.3868295321E+00, 1.4554277500E+00, 8.2709037673E-01],
	[2.2305000000E+04, 1.3071053671E+01, 5.2194827629E+00, 2.3885415046E+00, 1.4561120744E+00, 8.2717041788E-01],
	[2.2310000000E+04, 1.3075519079E+01, 5.2193867059E+00, 2.3902543202E+00, 1.4567964132E+00, 8.2725042580E-01],
	[2.2315000000E+04, 1.3079985010E+01, 5.2192906721E+00, 2.3919679791E+00, 1.4574807660E+00, 8.2733040049E-01],
	[2.2320000000E+04, 1.3084451466E+01, 5.2191946617E+00, 2.3936824815E+00, 1.4581651328E+00, 8.2741034196E-01],
	[2.2325000000E+04, 1.3088918446E+01, 5.2190986745E+00, 2.3953978277E+00, 1.4588495134E+00, 8.2749025021E-01],
	[2.2330000000E+04, 1.3093385951E+01, 5.2190027106E+00, 2.3971140180E+00, 1.4595339078E+00, 8.2757012526E-01],
	[2.2335000000E+04, 1.3097853979E+01, 5.2189067699E+00, 2.3988310524E+00, 1.4602183156E+00, 8.2764996710E-01],
	[2.2340000000E+04, 1.3102322532E+01, 5.2188108525E+00, 2.4005489313E+00, 1.4609027369E+00, 8.2772977575E-01],
	[2.2345000000E+04, 1.3106791608E+01, 5.2187149583E+00, 2.4022676548E+00, 1.4615871714E+00, 8.2780955122E-01],
	[2.2350000000E+04, 1.3111261209E+01, 5.2186190873E+00, 2.4039872233E+00, 1.4622716190E+00, 8.2788929350E-01],
	[2.2355000000E+04, 1.3115731333E+01, 5.2185232395E+00, 2.4057076368E+00, 1.4629560795E+00, 8.2796900261E-01],
	[2.2360000000E+04, 1.3120201981E+01, 5.2184274149E+00, 2.4074288957E+00, 1.4636405529E+00, 8.2804867856E-01],
	[2.2365000000E+04, 1.3124673153E+01, 5.2183316135E+00, 2.4091609338E+00, 1.4643287089E+00, 8.2812832135E-01],
	[2.2370000000E+04, 1.3129144849E+01, 5.2182358353E+00, 2.4108954477E+00, 1.4650174756E+00, 8.2820793099E-01],
	[2.2375000000E+04, 1.3133617068E+01, 5.2181400803E+00, 2.4126308215E+00, 1.4657062556E+00, 8.2828750749E-01],
	[2.2380000000E+04, 1.3138089811E+01, 5.2180443483E+00, 2.4143670555E+00, 1.4663950488E+00, 8.2836705085E-01],
	[2.2385000000E+04, 1.3142563077E+01, 5.2179486396E+00, 2.4161041499E+00, 1.4670838549E+00, 8.2844656108E-01],
	[2.2390000000E+04, 1.3147036867E+01, 5.2178529539E+00, 2.4178421049E+00, 1.4677726739E+00, 8.2852603819E-01],
	[2.2395000000E+04, 1.3151511181E+01, 5.2177572914E+00, 2.4195809208E+00, 1.4684615056E+00, 8.2860548219E-01],
	[2.2400000000E+04, 1.3155986018E+01, 5.2176616520E+00, 2.4213205978E+00, 1.4691503498E+00, 8.2868489308E-01],
	[2.2405000000E+04, 1.3160461378E+01, 5.2175660357E+00, 2.4230611361E+00, 1.4698392064E+00, 8.2876427087E-01],
	[2.2410000000E+04, 1.3164937261E+01, 5.2174704425E+00, 2.4248025360E+00, 1.4705280753E+00, 8.2884361556E-01],
	[2.2415000000E+04, 1.3169413668E+01, 5.2173748723E+00, 2.4265447976E+00, 1.4712169563E+00, 8.2892292718E-01],
	[2.2420000000E+04, 1.3173890598E+01, 5.2172793252E+00, 2.4282879214E+00, 1.4719058492E+00, 8.2900220571E-01],
	[2.2425000000E+04, 1.3178368050E+01, 5.2171838012E+00, 2.4300319073E+00, 1.4725947540E+00, 8.2908145118E-01],
	[2.2430000000E+04, 1.3182846026E+01, 5.2170883002E+00, 2.4317767558E+00, 1.4732836704E+00, 8.2916066358E-01],
	[2.2435000000E+04, 1.3187324525E+01, 5.2169928223E+00, 2.4335224670E+00, 1.4739725984E+00, 8.2923984292E-01],
	[2.2440000000E+04, 1.3191821523E+01, 5.2169011625E+00, 2.4352690411E+00, 1.4746620656E+00, 8.2931898922E-01],
	[2.2445000000E+04, 1.3196321433E+01, 5.2168100271E+00, 2.4370164785E+00, 1.4753516148E+00, 8.2939810248E-01],
	[2.2450000000E+04, 1.3200821874E+01, 5.2167189137E+00, 2.4387647793E+00, 1.4760411758E+00, 8.2947718271E-01],
	[2.2455000000E+04, 1.3205322848E+01, 5.2166278222E+00, 2.4405139438E+00, 1.4767307486E+00, 8.2955622991E-01],
	[2.2460000000E+04, 1.3209824354E+01, 5.2165367525E+00, 2.4422639721E+00, 1.4774203331E+00, 8.2963524409E-01],
	[2.2465000000E+04, 1.3214326391E+01, 5.2164457047E+00, 2.4440148646E+00, 1.4781099290E+00, 8.2971422526E-01],
	[2.2470000000E+04, 1.3218828961E+01, 5.2163546787E+00, 2.4457666215E+00, 1.4787995363E+00, 8.2979317343E-01],
	[2.2475000000E+04, 1.3223332063E+01, 5.2162636746E+00, 2.4475192429E+00, 1.4794891547E+00, 8.2987208860E-01],
	[2.2480000000E+04, 1.3227835696E+01, 5.2161726923E+00, 2.4492727292E+00, 1.4801787842E+00, 8.2995097078E-01],
	[2.2485000000E+04, 1.3232339861E+01, 5.2160817318E+00, 2.4510270806E+00, 1.4808684246E+00, 8.3002981999E-01],
	[2.2490000000E+04, 1.3236844558E+01, 5.2159907931E+00, 2.4527822973E+00, 1.4815580758E+00, 8.3010863622E-01],
	[2.2495000000E+04, 1.3241349786E+01, 5.2158998763E+00, 2.4545383795E+00, 1.4822477376E+00, 8.3018741948E-01],
	[2.2500000000E+04, 1.3245855546E+01, 5.2158089812E+00, 2.4562953275E+00, 1.4829374098E+00, 8.3026616979E-01],
	[2.2505000000E+04, 1.3250361838E+01, 5.2157181079E+00, 2.4580531414E+00, 1.4836270924E+00, 8.3034488714E-01],
	[2.2510000000E+04, 1.3254868661E+01, 5.2156272564E+00, 2.4598118216E+00, 1.4843167851E+00, 8.3042357156E-01],
	[2.2515000000E+04, 1.3259376015E+01, 5.2155364266E+00, 2.4615713683E+00, 1.4850064879E+00, 8.3050222304E-01],
	[2.2520000000E+04, 1.3263883901E+01, 5.2154456186E+00, 2.4633317817E+00, 1.4856962005E+00, 8.3058084159E-01],
	[2.2525000000E+04, 1.3268392318E+01, 5.2153548323E+00, 2.4650930620E+00, 1.4863859229E+00, 8.3065942722E-01],
	[2.2530000000E+04, 1.3272901267E+01, 5.2152640678E+00, 2.4668552095E+00, 1.4870756549E+00, 8.3073797994E-01],
	[2.2535000000E+04, 1.3277410747E+01, 5.2151733250E+00, 2.4686182244E+00, 1.4877653964E+00, 8.3081649976E-01],
	[2.2540000000E+04, 1.3281920757E+01, 5.2150826038E+00, 2.4703821070E+00, 1.4884551472E+00, 8.3089498667E-01],
	[2.2545000000E+04, 1.3286431299E+01, 5.2149919044E+00, 2.4721468574E+00, 1.4891449071E+00, 8.3097344070E-01],
	[2.2550000000E+04, 1.3290942372E+01, 5.2149012267E+00, 2.4739124759E+00, 1.4898346761E+00, 8.3105186185E-01],
	[2.2555000000E+04, 1.3295453976E+01, 5.2148105707E+00, 2.4756789627E+00, 1.4905244540E+00, 8.3113025013E-01],
	[2.2560000000E+04, 1.3299966111E+01, 5.2147199363E+00, 2.4774463182E+00, 1.4912142406E+00, 8.3120860554E-01],
	[2.2565000000E+04, 1.3304478777E+01, 5.2146293236E+00, 2.4792145424E+00, 1.4919040358E+00, 8.3128692809E-01],
	[2.2570000000E+04, 1.3308991973E+01, 5.2145387325E+00, 2.4809836357E+00, 1.4925938394E+00, 8.3136521779E-01],
	[2.2575000000E+04, 1.3313505701E+01, 5.2144481631E+00, 2.4827535982E+00, 1.4932836513E+00, 8.3144347464E-01],
	[2.2580000000E+04, 1.3318019959E+01, 5.2143576153E+00, 2.4845244303E+00, 1.4939734714E+00, 8.3152169867E-01],
	[2.2585000000E+04, 1.3322534747E+01, 5.2142670891E+00, 2.4862961321E+00, 1.4946632996E+00, 8.3159988986E-01],
	[2.2590000000E+04, 1.3327050066E+01, 5.2141765845E+00, 2.4880687039E+00, 1.4953531356E+00, 8.3167804823E-01],
	[2.2595000000E+04, 1.3331565916E+01, 5.2140861016E+00, 2.4898421459E+00, 1.4960429793E+00, 8.3175617378E-01],
	[2.2600000000E+04, 1.3336082297E+01, 5.2139956402E+00, 2.4916164584E+00, 1.4967328306E+00, 8.3183426652E-01],
	[2.2605000000E+04, 1.3340599207E+01, 5.2139052004E+00, 2.4933916415E+00, 1.4974226894E+00, 8.3191232645E-01],
	[2.2610000000E+04, 1.3345116648E+01, 5.2138147822E+00, 2.4951676955E+00, 1.4981125555E+00, 8.3199035358E-01],
	[2.2615000000E+04, 1.3349634620E+01, 5.2137243855E+00, 2.4969446207E+00, 1.4988024287E+00, 8.3206834792E-01],
	[2.2620000000E+04, 1.3354153122E+01, 5.2136340104E+00, 2.4987224172E+00, 1.4994923089E+00, 8.3214630947E-01],
	[2.2625000000E+04, 1.3358672153E+01, 5.2135436568E+00, 2.5005010854E+00, 1.5001821961E+00, 8.3222423823E-01],
	[2.2630000000E+04, 1.3363191716E+01, 5.2134533248E+00, 2.5022806255E+00, 1.5008720899E+00, 8.3230213422E-01],
	[2.2635000000E+04, 1.3367711808E+01, 5.2133630143E+00, 2.5040610376E+00, 1.5015619903E+00, 8.3237999744E-01],
	[2.2640000000E+04, 1.3372232430E+01, 5.2132727252E+00, 2.5058423220E+00, 1.5022518972E+00, 8.3245782790E-01],
	[2.2645000000E+04, 1.3376753582E+01, 5.2131824577E+00, 2.5076244790E+00, 1.5029418104E+00, 8.3253562560E-01],
	[2.2650000000E+04, 1.3381275264E+01, 5.2130922117E+00, 2.5094075087E+00, 1.5036317297E+00, 8.3261339055E-01],
	[2.2655000000E+04, 1.3385797476E+01, 5.2130019872E+00, 2.5111914115E+00, 1.5043216551E+00, 8.3269112275E-01],
	[2.2660000000E+04, 1.3390320218E+01, 5.2129117841E+00, 2.5129761875E+00, 1.5050115863E+00, 8.3276882221E-01],
	[2.2665000000E+04, 1.3394843490E+01, 5.2128216025E+00, 2.5147618370E+00, 1.5057015233E+00, 8.3284648894E-01],
	[2.2670000000E+04, 1.3399367291E+01, 5.2127314424E+00, 2.5165483603E+00, 1.5063914658E+00, 8.3292412294E-01],
	[2.2675000000E+04, 1.3403891622E+01, 5.2126413036E+00, 2.5183357575E+00, 1.5070814138E+00, 8.3300172422E-01],
	[2.2680000000E+04, 1.3408416483E+01, 5.2125511864E+00, 2.5201240289E+00, 1.5077713671E+00, 8.3307929278E-01],
	[2.2685000000E+04, 1.3412941873E+01, 5.2124610905E+00, 2.5219131747E+00, 1.5084613255E+00, 8.3315682864E-01],
	[2.2690000000E+04, 1.3417467793E+01, 5.2123710161E+00, 2.5237031951E+00, 1.5091512890E+00, 8.3323433179E-01],
	[2.2695000000E+04, 1.3421994242E+01, 5.2122809630E+00, 2.5254940905E+00, 1.5098412573E+00, 8.3331180225E-01],
	[2.2700000000E+04, 1.3426521220E+01, 5.2121909314E+00, 2.5272858610E+00, 1.5105312304E+00, 8.3338924002E-01],
	[2.2705000000E+04, 1.3431048728E+01, 5.2121009211E+00, 2.5290785068E+00, 1.5112212081E+00, 8.3346664510E-01],
	[2.2710000000E+04, 1.3435576765E+01, 5.2120109322E+00, 2.5308720282E+00, 1.5119111902E+00, 8.3354401751E-01],
	[2.2715000000E+04, 1.3440105332E+01, 5.2119209647E+00, 2.5326664255E+00, 1.5126011766E+00, 8.3362135725E-01],
	[2.2720000000E+04, 1.3444634427E+01, 5.2118310185E+00, 2.5344616988E+00, 1.5132911672E+00, 8.3369866432E-01],
	[2.2725000000E+04, 1.3449164052E+01, 5.2117410937E+00, 2.5362578484E+00, 1.5139811619E+00, 8.3377593874E-01],
	[2.2730000000E+04, 1.3453694206E+01, 5.2116511902E+00, 2.5380548746E+00, 1.5146711604E+00, 8.3385318050E-01],
	[2.2735000000E+04, 1.3458224888E+01, 5.2115613080E+00, 2.5398527775E+00, 1.5153611626E+00, 8.3393038962E-01],
	[2.2740000000E+04, 1.3462756100E+01, 5.2114714472E+00, 2.5416515574E+00, 1.5160511684E+00, 8.3400756610E-01],
	[2.2745000000E+04, 1.3467287841E+01, 5.2113816076E+00, 2.5434512145E+00, 1.5167411777E+00, 8.3408470995E-01],
	[2.2750000000E+04, 1.3471820110E+01, 5.2112917894E+00, 2.5452517491E+00, 1.5174311903E+00, 8.3416182117E-01],
	[2.2755000000E+04, 1.3476352908E+01, 5.2112019924E+00, 2.5470531614E+00, 1.5181212061E+00, 8.3423889977E-01],
	[2.2760000000E+04, 1.3480886235E+01, 5.2111122167E+00, 2.5488554517E+00, 1.5188112249E+00, 8.3431594576E-01],
	[2.2765000000E+04, 1.3485420091E+01, 5.2110224623E+00, 2.5506586201E+00, 1.5195012467E+00, 8.3439295914E-01],
	[2.2770000000E+04, 1.3489954475E+01, 5.2109327291E+00, 2.5524626669E+00, 1.5201912711E+00, 8.3446993993E-01],
	[2.2775000000E+04, 1.3494489388E+01, 5.2108430172E+00, 2.5542675924E+00, 1.5208812982E+00, 8.3454688812E-01],
	[2.2780000000E+04, 1.3499024829E+01, 5.2107533265E+00, 2.5560733967E+00, 1.5215713277E+00, 8.3462380372E-01],
	[2.2785000000E+04, 1.3503560799E+01, 5.2106636571E+00, 2.5578800802E+00, 1.5222613596E+00, 8.3470068674E-01],
	[2.2790000000E+04, 1.3508097297E+01, 5.2105740088E+00, 2.5596876429E+00, 1.5229513936E+00, 8.3477753719E-01],
	[2.2795000000E+04, 1.3512634324E+01, 5.2104843818E+00, 2.5614960853E+00, 1.5236414297E+00, 8.3485435507E-01],
	[2.2800000000E+04, 1.3517185204E+01, 5.2103975126E+00, 2.5633054075E+00, 1.5243318714E+00, 8.3493114039E-01],
	[2.2805000000E+04, 1.3521743903E+01, 5.2103121594E+00, 2.5651156097E+00, 1.5250225361E+00, 8.3500789316E-01],
	[2.2810000000E+04, 1.3526303139E+01, 5.2102268263E+00, 2.5669266922E+00, 1.5257132033E+00, 8.3508461338E-01],
	[2.2815000000E+04, 1.3530862913E+01, 5.2101415133E+00, 2.5687386551E+00, 1.5264038728E+00, 8.3516130106E-01],
	[2.2820000000E+04, 1.3535423224E+01, 5.2100562204E+00, 2.5705514989E+00, 1.5270945445E+00, 8.3523795621E-01],
	[2.2825000000E+04, 1.3539984072E+01, 5.2099709475E+00, 2.5723652236E+00, 1.5277852182E+00, 8.3531457883E-01],
	[2.2830000000E+04, 1.3544545458E+01, 5.2098856948E+00, 2.5741798296E+00, 1.5284758938E+00, 8.3539116893E-01],
	[2.2835000000E+04, 1.3549107382E+01, 5.2098004621E+00, 2.5759953170E+00, 1.5291665712E+00, 8.3546772651E-01],
	[2.2840000000E+04, 1.3553669842E+01, 5.2097152494E+00, 2.5778116860E+00, 1.5298572502E+00, 8.3554425159E-01],
	[2.2845000000E+04, 1.3558232839E+01, 5.2096300568E+00, 2.5796289370E+00, 1.5305479306E+00, 8.3562074417E-01],
	[2.2850000000E+04, 1.3562796374E+01, 5.2095448843E+00, 2.5814470702E+00, 1.5312386124E+00, 8.3569720425E-01],
	[2.2855000000E+04, 1.3567360446E+01, 5.2094597318E+00, 2.5832660857E+00, 1.5319292953E+00, 8.3577363185E-01],
	[2.2860000000E+04, 1.3571925054E+01, 5.2093745993E+00, 2.5850859839E+00, 1.5326199793E+00, 8.3585002697E-01],
	[2.2865000000E+04, 1.3576490200E+01, 5.2092894868E+00, 2.5869067649E+00, 1.5333106642E+00, 8.3592638961E-01],
	[2.2870000000E+04, 1.3581055882E+01, 5.2092043943E+00, 2.5887284290E+00, 1.5340013499E+00, 8.3600271979E-01],
	[2.2875000000E+04, 1.3585622102E+01, 5.2091193218E+00, 2.5905509765E+00, 1.5346920362E+00, 8.3607901751E-01],
	[2.2880000000E+04, 1.3590188858E+01, 5.2090342692E+00, 2.5923744075E+00, 1.5353827230E+00, 8.3615528278E-01],
	[2.2885000000E+04, 1.3594756151E+01, 5.2089492367E+00, 2.5941987223E+00, 1.5360734101E+00, 8.3623151560E-01],
	[2.2890000000E+04, 1.3599323980E+01, 5.2088642241E+00, 2.5960239211E+00, 1.5367640975E+00, 8.3630771599E-01],
	[2.2895000000E+04, 1.3603892346E+01, 5.2087792314E+00, 2.5978500042E+00, 1.5374547849E+00, 8.3638388394E-01],
	[2.2900000000E+04, 1.3608461249E+01, 5.2086942588E+00, 2.5996769718E+00, 1.5381454723E+00, 8.3646001947E-01],
	[2.2905000000E+04, 1.3613030688E+01, 5.2086093060E+00, 2.6015048241E+00, 1.5388361594E+00, 8.3653612257E-01],
	[2.2910000000E+04, 1.3617600664E+01, 5.2085243732E+00, 2.6033335614E+00, 1.5395268462E+00, 8.3661219327E-01],
	[2.2915000000E+04, 1.3622171176E+01, 5.2084394603E+00, 2.6051631839E+00, 1.5402175326E+00, 8.3668823157E-01],
	[2.2920000000E+04, 1.3626742224E+01, 5.2083545673E+00, 2.6069936918E+00, 1.5409082183E+00, 8.3676423747E-01],
	[2.2925000000E+04, 1.3631313809E+01, 5.2082696942E+00, 2.6088250854E+00, 1.5415989032E+00, 8.3684021097E-01],
	[2.2930000000E+04, 1.3635885930E+01, 5.2081848410E+00, 2.6106573649E+00, 1.5422895872E+00, 8.3691615210E-01],
	[2.2935000000E+04, 1.3640458587E+01, 5.2081000076E+00, 2.6124905305E+00, 1.5429802702E+00, 8.3699206085E-01],
	[2.2940000000E+04, 1.3645031780E+01, 5.2080151942E+00, 2.6143245825E+00, 1.5436709520E+00, 8.3706793723E-01],
	[2.2945000000E+04, 1.3649605509E+01, 5.2079304006E+00, 2.6161595212E+00, 1.5443616325E+00, 8.3714378125E-01],
	[2.2950000000E+04, 1.3654179775E+01, 5.2078456269E+00, 2.6179953467E+00, 1.5450523115E+00, 8.3721959291E-01],
	[2.2955000000E+04, 1.3658754576E+01, 5.2077608730E+00, 2.6198320592E+00, 1.5457429889E+00, 8.3729537223E-01],
	[2.2960000000E+04, 1.3663329913E+01, 5.2076761390E+00, 2.6216696591E+00, 1.5464336646E+00, 8.3737111920E-01],
	[2.2965000000E+04, 1.3667905786E+01, 5.2075914247E+00, 2.6235081465E+00, 1.5471243384E+00, 8.3744683385E-01],
	[2.2970000000E+04, 1.3672482195E+01, 5.2075067304E+00, 2.6253475217E+00, 1.5478150102E+00, 8.3752251616E-01],
	[2.2975000000E+04, 1.3677059140E+01, 5.2074220558E+00, 2.6271877849E+00, 1.5485056798E+00, 8.3759816616E-01],
	[2.2980000000E+04, 1.3681636620E+01, 5.2073374010E+00, 2.6290289364E+00, 1.5491963472E+00, 8.3767378385E-01],
	[2.2985000000E+04, 1.3686214636E+01, 5.2072527660E+00, 2.6308709763E+00, 1.5498870121E+00, 8.3774936923E-01],
	[2.2990000000E+04, 1.3690793188E+01, 5.2071681508E+00, 2.6327139050E+00, 1.5505776745E+00, 8.3782492231E-01],
	[2.2995000000E+04, 1.3695372275E+01, 5.2070835554E+00, 2.6345577227E+00, 1.5512683341E+00, 8.3790044311E-01],
	[2.3000000000E+04, 1.3699951897E+01, 5.2069989797E+00, 2.6364024295E+00, 1.5519589909E+00, 8.3797593162E-01],
	[2.3005000000E+04, 1.3704532055E+01, 5.2069144238E+00, 2.6382480257E+00, 1.5526496447E+00, 8.3805138785E-01],
	[2.3010000000E+04, 1.3709112749E+01, 5.2068298876E+00, 2.6400945117E+00, 1.5533402954E+00, 8.3812681182E-01],
	[2.3015000000E+04, 1.3713693977E+01, 5.2067453712E+00, 2.6419418875E+00, 1.5540309429E+00, 8.3820220353E-01],
	[2.3020000000E+04, 1.3718275741E+01, 5.2066608745E+00, 2.6437901534E+00, 1.5547215869E+00, 8.3827756298E-01],
	[2.3025000000E+04, 1.3722858040E+01, 5.2065763976E+00, 2.6456393097E+00, 1.5554122274E+00, 8.3835289018E-01],
	[2.3030000000E+04, 1.3727440875E+01, 5.2064919403E+00, 2.6474893566E+00, 1.5561028643E+00, 8.3842818515E-01],
	[2.3035000000E+04, 1.3732024244E+01, 5.2064075028E+00, 2.6493402944E+00, 1.5567934973E+00, 8.3850344788E-01],
	[2.3040000000E+04, 1.3736608149E+01, 5.2063230849E+00, 2.6511921232E+00, 1.5574841264E+00, 8.3857867839E-01],
	[2.3045000000E+04, 1.3741192588E+01, 5.2062386867E+00, 2.6530448433E+00, 1.5581747514E+00, 8.3865387669E-01],
	[2.3050000000E+04, 1.3745777562E+01, 5.2061543082E+00, 2.6548984550E+00, 1.5588653721E+00, 8.3872904277E-01],
	[2.3055000000E+04, 1.3750363072E+01, 5.2060699494E+00, 2.6567529584E+00, 1.5595559885E+00, 8.3880417665E-01],
	[2.3060000000E+04, 1.3754949116E+01, 5.2059856103E+00, 2.6586083539E+00, 1.5602466004E+00, 8.3887927833E-01],
	[2.3065000000E+04, 1.3759535695E+01, 5.2059012907E+00, 2.6604646416E+00, 1.5609372077E+00, 8.3895434783E-01],
	[2.3070000000E+04, 1.3764122808E+01, 5.2058169909E+00, 2.6623218217E+00, 1.5616278102E+00, 8.3902938515E-01],
	[2.3075000000E+04, 1.3768710457E+01, 5.2057327106E+00, 2.6641798946E+00, 1.5623184078E+00, 8.3910439029E-01],
	[2.3080000000E+04, 1.3773298640E+01, 5.2056484500E+00, 2.6660388604E+00, 1.5630090004E+00, 8.3917936327E-01],
	[2.3085000000E+04, 1.3777887357E+01, 5.2055642090E+00, 2.6678987195E+00, 1.5636995878E+00, 8.3925430409E-01],
	[2.3090000000E+04, 1.3782476609E+01, 5.2054799876E+00, 2.6697594719E+00, 1.5643901698E+00, 8.3932921276E-01],
	[2.3095000000E+04, 1.3787066396E+01, 5.2053957858E+00, 2.6716211180E+00, 1.5650807464E+00, 8.3940408929E-01],
	[2.3100000000E+04, 1.3791656717E+01, 5.2053116036E+00, 2.6734836580E+00, 1.5657713174E+00, 8.3947893368E-01],
	[2.3105000000E+04, 1.3796247572E+01, 5.2052274410E+00, 2.6753470921E+00, 1.5664618826E+00, 8.3955374595E-01],
	[2.3110000000E+04, 1.3800838962E+01, 5.2051432980E+00, 2.6772114205E+00, 1.5671524420E+00, 8.3962852610E-01],
	[2.3115000000E+04, 1.3805430885E+01, 5.2050591745E+00, 2.6790766436E+00, 1.5678429954E+00, 8.3970327413E-01],
	[2.3120000000E+04, 1.3810023343E+01, 5.2049750705E+00, 2.6809427615E+00, 1.5685335427E+00, 8.3977799005E-01],
	[2.3125000000E+04, 1.3814616336E+01, 5.2048909861E+00, 2.6828097744E+00, 1.5692240837E+00, 8.3985267388E-01],
	[2.3130000000E+04, 1.3819209862E+01, 5.2048069213E+00, 2.6846776827E+00, 1.5699146182E+00, 8.3992732562E-01],
	[2.3135000000E+04, 1.3823803922E+01, 5.2047228760E+00, 2.6865464864E+00, 1.5706051462E+00, 8.4000194528E-01],
	[2.3140000000E+04, 1.3828398516E+01, 5.2046388501E+00, 2.6884161860E+00, 1.5712956675E+00, 8.4007653286E-01],
	[2.3145000000E+04, 1.3832993644E+01, 5.2045548439E+00, 2.6902867816E+00, 1.5719861820E+00, 8.4015108838E-01],
	[2.3150000000E+04, 1.3837589307E+01, 5.2044708571E+00, 2.6921582734E+00, 1.5726766896E+00, 8.4022561184E-01],
	[2.3155000000E+04, 1.3842185502E+01, 5.2043868898E+00, 2.6940306616E+00, 1.5733671900E+00, 8.4030010324E-01],
	[2.3160000000E+04, 1.3846782232E+01, 5.2043029419E+00, 2.6959039466E+00, 1.5740576832E+00, 8.4037456260E-01],
	[2.3165000000E+04, 1.3851384654E+01, 5.2042200441E+00, 2.6977781285E+00, 1.5747483301E+00, 8.4044898993E-01],
	[2.3170000000E+04, 1.3856003321E+01, 5.2041403028E+00, 2.6996532076E+00, 1.5754394603E+00, 8.4052338522E-01],
	[2.3175000000E+04, 1.3860622531E+01, 5.2040605801E+00, 2.7015291842E+00, 1.5761305836E+00, 8.4059774850E-01],
	[2.3180000000E+04, 1.3865242284E+01, 5.2039808757E+00, 2.7034060583E+00, 1.5768217001E+00, 8.4067207976E-01],
	[2.3185000000E+04, 1.3869862580E+01, 5.2039011897E+00, 2.7052838304E+00, 1.5775128095E+00, 8.4074637902E-01],
	[2.3190000000E+04, 1.3874483419E+01, 5.2038215221E+00, 2.7071625006E+00, 1.5782039116E+00, 8.4082064628E-01],
	[2.3195000000E+04, 1.3879104800E+01, 5.2037418730E+00, 2.7090420691E+00, 1.5788950064E+00, 8.4089488154E-01],
	[2.3200000000E+04, 1.3883726725E+01, 5.2036622422E+00, 2.7109225362E+00, 1.5795860937E+00, 8.4096908483E-01],
	[2.3205000000E+04, 1.3888349192E+01, 5.2035826298E+00, 2.7128039021E+00, 1.5802771735E+00, 8.4104325614E-01],
	[2.3210000000E+04, 1.3892972201E+01, 5.2035030358E+00, 2.7146861672E+00, 1.5809682454E+00, 8.4111739549E-01],
	[2.3215000000E+04, 1.3897595753E+01, 5.2034234601E+00, 2.7165693315E+00, 1.5816593095E+00, 8.4119150288E-01],
	[2.3220000000E+04, 1.3902219848E+01, 5.2033439028E+00, 2.7184533953E+00, 1.5823503655E+00, 8.4126557832E-01],
	[2.3225000000E+04, 1.3906844485E+01, 5.2032643638E+00, 2.7203383589E+00, 1.5830414134E+00, 8.4133962181E-01],
	[2.3230000000E+04, 1.3911469664E+01, 5.2031848432E+00, 2.7222242225E+00, 1.5837324530E+00, 8.4141363337E-01],
	[2.3235000000E+04, 1.3916095386E+01, 5.2031053409E+00, 2.7241109863E+00, 1.5844234842E+00, 8.4148761300E-01],
	[2.3240000000E+04, 1.3920721650E+01, 5.2030258569E+00, 2.7259986507E+00, 1.5851145068E+00, 8.4156156071E-01],
	[2.3245000000E+04, 1.3925348457E+01, 5.2029463912E+00, 2.7278872157E+00, 1.5858055207E+00, 8.4163547652E-01],
	[2.3250000000E+04, 1.3929975805E+01, 5.2028669438E+00, 2.7297766816E+00, 1.5864965258E+00, 8.4170936041E-01],
	[2.3255000000E+04, 1.3934603696E+01, 5.2027875147E+00, 2.7316670488E+00, 1.5871875219E+00, 8.4178321242E-01],
	[2.3260000000E+04, 1.3939232129E+01, 5.2027081040E+00, 2.7335583173E+00, 1.5878785089E+00, 8.4185703253E-01],
	[2.3265000000E+04, 1.3943861104E+01, 5.2026287115E+00, 2.7354504875E+00, 1.5885694867E+00, 8.4193082077E-01],
	[2.3270000000E+04, 1.3948490620E+01, 5.2025493372E+00, 2.7373435596E+00, 1.5892604551E+00, 8.4200457713E-01],
	[2.3275000000E+04, 1.3953120679E+01, 5.2024699813E+00, 2.7392375338E+00, 1.5899514140E+00, 8.4207830163E-01],
	[2.3280000000E+04, 1.3957751280E+01, 5.2023906435E+00, 2.7411324104E+00, 1.5906423632E+00, 8.4215199427E-01],
	[2.3285000000E+04, 1.3962382422E+01, 5.2023113241E+00, 2.7430281896E+00, 1.5913333027E+00, 8.4222565507E-01],
	[2.3290000000E+04, 1.3967014106E+01, 5.2022320229E+00, 2.7449248715E+00, 1.5920242323E+00, 8.4229928403E-01],
	[2.3295000000E+04, 1.3971646332E+01, 5.2021527399E+00, 2.7468224566E+00, 1.5927151518E+00, 8.4237288115E-01],
	[2.3300000000E+04, 1.3976279100E+01, 5.2020734751E+00, 2.7487209449E+00, 1.5934060612E+00, 8.4244644646E-01],
	[2.3305000000E+04, 1.3980912409E+01, 5.2019942285E+00, 2.7506203368E+00, 1.5940969602E+00, 8.4251997994E-01],
	[2.3310000000E+04, 1.3985546260E+01, 5.2019150002E+00, 2.7525206324E+00, 1.5947878488E+00, 8.4259348162E-01],
	[2.3315000000E+04, 1.3990180652E+01, 5.2018357900E+00, 2.7544218321E+00, 1.5954787269E+00, 8.4266695150E-01],
	[2.3320000000E+04, 1.3994815585E+01, 5.2017565981E+00, 2.7563239360E+00, 1.5961695942E+00, 8.4274038959E-01],
	[2.3325000000E+04, 1.3999451060E+01, 5.2016774243E+00, 2.7582269443E+00, 1.5968604507E+00, 8.4281379590E-01],
	[2.3330000000E+04, 1.4004087077E+01, 5.2015982687E+00, 2.7601308574E+00, 1.5975512962E+00, 8.4288717043E-01],
	[2.3335000000E+04, 1.4008723634E+01, 5.2015191313E+00, 2.7620356754E+00, 1.5982421306E+00, 8.4296051320E-01],
	[2.3340000000E+04, 1.4013360733E+01, 5.2014400120E+00, 2.7639413986E+00, 1.5989329537E+00, 8.4303382420E-01],
	[2.3345000000E+04, 1.4017998373E+01, 5.2013609109E+00, 2.7658480272E+00, 1.5996237655E+00, 8.4310710346E-01],
	[2.3350000000E+04, 1.4022636555E+01, 5.2012818279E+00, 2.7677555614E+00, 1.6003145657E+00, 8.4318035097E-01],
	[2.3355000000E+04, 1.4027275277E+01, 5.2012027630E+00, 2.7696640015E+00, 1.6010053543E+00, 8.4325356675E-01],
	[2.3360000000E+04, 1.4031914540E+01, 5.2011237163E+00, 2.7715733478E+00, 1.6016961312E+00, 8.4332675080E-01],
	[2.3365000000E+04, 1.4036554344E+01, 5.2010446877E+00, 2.7734836004E+00, 1.6023868961E+00, 8.4339990314E-01],
	[2.3370000000E+04, 1.4041194690E+01, 5.2009656772E+00, 2.7753947596E+00, 1.6030776490E+00, 8.4347302376E-01],
	[2.3375000000E+04, 1.4045835576E+01, 5.2008866848E+00, 2.7773068257E+00, 1.6037683897E+00, 8.4354611269E-01],
	[2.3380000000E+04, 1.4050477003E+01, 5.2008077105E+00, 2.7792197988E+00, 1.6044591180E+00, 8.4361916992E-01],
	[2.3385000000E+04, 1.4055118970E+01, 5.2007287543E+00, 2.7811336792E+00, 1.6051498340E+00, 8.4369219547E-01],
	[2.3390000000E+04, 1.4059761479E+01, 5.2006498162E+00, 2.7830484671E+00, 1.6058405374E+00, 8.4376518934E-01],
	[2.3395000000E+04, 1.4064404528E+01, 5.2005708961E+00, 2.7849641628E+00, 1.6065312280E+00, 8.4383815154E-01],
	[2.3400000000E+04, 1.4069048117E+01, 5.2004919941E+00, 2.7868807665E+00, 1.6072219058E+00, 8.4391108208E-01],
	[2.3405000000E+04, 1.4073692247E+01, 5.2004131102E+00, 2.7887982785E+00, 1.6079125707E+00, 8.4398398098E-01],
	[2.3410000000E+04, 1.4078336918E+01, 5.2003342443E+00, 2.7907166989E+00, 1.6086032224E+00, 8.4405684822E-01],
	[2.3415000000E+04, 1.4082982129E+01, 5.2002553964E+00, 2.7926360281E+00, 1.6092938609E+00, 8.4412968384E-01],
	[2.3420000000E+04, 1.4087627881E+01, 5.2001765666E+00, 2.7945562662E+00, 1.6099844860E+00, 8.4420248782E-01],
	[2.3425000000E+04, 1.4092274172E+01, 5.2000977548E+00, 2.7964774135E+00, 1.6106750977E+00, 8.4427526019E-01],
	[2.3430000000E+04, 1.4096921005E+01, 5.2000189610E+00, 2.7983994702E+00, 1.6113656957E+00, 8.4434800095E-01],
	[2.3435000000E+04, 1.4101568377E+01, 5.1999401852E+00, 2.8003224365E+00, 1.6120562799E+00, 8.4442071011E-01],
	[2.3440000000E+04, 1.4106216289E+01, 5.1998614274E+00, 2.8022463128E+00, 1.6127468502E+00, 8.4449338767E-01],
	[2.3445000000E+04, 1.4110864742E+01, 5.1997826876E+00, 2.8041710992E+00, 1.6134374065E+00, 8.4456603365E-01],
	[2.3450000000E+04, 1.4115513735E+01, 5.1997039658E+00, 2.8060967959E+00, 1.6141279486E+00, 8.4463864806E-01],
	[2.3455000000E+04, 1.4120163268E+01, 5.1996252619E+00, 2.8080234032E+00, 1.6148184765E+00, 8.4471123089E-01],
	[2.3460000000E+04, 1.4124813340E+01, 5.1995465761E+00, 2.8099509214E+00, 1.6155089899E+00, 8.4478378217E-01],
	[2.3465000000E+04, 1.4129463953E+01, 5.1994679081E+00, 2.8118793507E+00, 1.6161994887E+00, 8.4485630189E-01],
	[2.3470000000E+04, 1.4134115106E+01, 5.1993892582E+00, 2.8138086912E+00, 1.6168899729E+00, 8.4492879008E-01],
	[2.3475000000E+04, 1.4138766798E+01, 5.1993106262E+00, 2.8157389433E+00, 1.6175804422E+00, 8.4500124672E-01],
	[2.3480000000E+04, 1.4143419030E+01, 5.1992320121E+00, 2.8176701072E+00, 1.6182708966E+00, 8.4507367185E-01],
	[2.3485000000E+04, 1.4148071802E+01, 5.1991534159E+00, 2.8196021830E+00, 1.6189613358E+00, 8.4514606545E-01],
	[2.3490000000E+04, 1.4152725113E+01, 5.1990748377E+00, 2.8215351712E+00, 1.6196517599E+00, 8.4521842755E-01],
	[2.3495000000E+04, 1.4157378965E+01, 5.1989962773E+00, 2.8234690718E+00, 1.6203421686E+00, 8.4529075815E-01],
	[2.3500000000E+04, 1.4162033355E+01, 5.1989177349E+00, 2.8254038851E+00, 1.6210325619E+00, 8.4536305726E-01],
	[2.3505000000E+04, 1.4166688285E+01, 5.1988392104E+00, 2.8273396114E+00, 1.6217229395E+00, 8.4543532488E-01],
	[2.3510000000E+04, 1.4171343755E+01, 5.1987607037E+00, 2.8292762509E+00, 1.6224133014E+00, 8.4550756103E-01],
	[2.3515000000E+04, 1.4175999764E+01, 5.1986822150E+00, 2.8312138038E+00, 1.6231036474E+00, 8.4557976572E-01],
	[2.3520000000E+04, 1.4180656312E+01, 5.1986037441E+00, 2.8331522704E+00, 1.6237939775E+00, 8.4565193894E-01],
	[2.3525000000E+04, 1.4185313400E+01, 5.1985252911E+00, 2.8350916509E+00, 1.6244842913E+00, 8.4572408072E-01],
	[2.3530000000E+04, 1.4189971027E+01, 5.1984468559E+00, 2.8370319455E+00, 1.6251745890E+00, 8.4579619106E-01],
	[2.3535000000E+04, 1.4194629193E+01, 5.1983684386E+00, 2.8389731545E+00, 1.6258648702E+00, 8.4586826997E-01],
	[2.3540000000E+04, 1.4199301975E+01, 5.1982927739E+00, 2.8409152781E+00, 1.6265555874E+00, 8.4594031745E-01],
	[2.3545000000E+04, 1.4203982357E+01, 5.1982184965E+00, 2.8428583165E+00, 1.6272465153E+00, 8.4601233352E-01],
	[2.3550000000E+04, 1.4208663287E+01, 5.1981442359E+00, 2.8448022700E+00, 1.6279374272E+00, 8.4608431819E-01],
	[2.3555000000E+04, 1.4213344766E+01, 5.1980699922E+00, 2.8467471388E+00, 1.6286283231E+00, 8.4615627145E-01],
	[2.3560000000E+04, 1.4218026793E+01, 5.1979957652E+00, 2.8486929232E+00, 1.6293192028E+00, 8.4622819333E-01],
	[2.3565000000E+04, 1.4222709368E+01, 5.1979215551E+00, 2.8506396234E+00, 1.6300100661E+00, 8.4630008383E-01],
	[2.3570000000E+04, 1.4227392492E+01, 5.1978473618E+00, 2.8525872396E+00, 1.6307009130E+00, 8.4637194296E-01],
	[2.3575000000E+04, 1.4232076164E+01, 5.1977731852E+00, 2.8545357720E+00, 1.6313917433E+00, 8.4644377073E-01],
	[2.3580000000E+04, 1.4236760384E+01, 5.1976990255E+00, 2.8564852210E+00, 1.6320825568E+00, 8.4651556715E-01],
	[2.3585000000E+04, 1.4241445152E+01, 5.1976248825E+00, 2.8584355867E+00, 1.6327733535E+00, 8.4658733222E-01],
	[2.3590000000E+04, 1.4246130468E+01, 5.1975507564E+00, 2.8603868693E+00, 1.6334641332E+00, 8.4665906595E-01],
	[2.3595000000E+04, 1.4250816332E+01, 5.1974766469E+00, 2.8623390692E+00, 1.6341548958E+00, 8.4673076836E-01],
	[2.3600000000E+04, 1.4255502743E+01, 5.1974025543E+00, 2.8642921864E+00, 1.6348456411E+00, 8.4680243944E-01],
	[2.3605000000E+04, 1.4260189703E+01, 5.1973284784E+00, 2.8662462214E+00, 1.6355363690E+00, 8.4687407922E-01],
	[2.3610000000E+04, 1.4264877211E+01, 5.1972544192E+00, 2.8682011743E+00, 1.6362270795E+00, 8.4694568770E-01],
	[2.3615000000E+04, 1.4269565266E+01, 5.1971803768E+00, 2.8701570453E+00, 1.6369177722E+00, 8.4701726489E-01],
	[2.3620000000E+04, 1.4274253869E+01, 5.1971063511E+00, 2.8721138347E+00, 1.6376084473E+00, 8.4708881079E-01],
	[2.3625000000E+04, 1.4278943020E+01, 5.1970323421E+00, 2.8740715427E+00, 1.6382991044E+00, 8.4716032542E-01],
	[2.3630000000E+04, 1.4283632718E+01, 5.1969583499E+00, 2.8760301696E+00, 1.6389897435E+00, 8.4723180878E-01],
	[2.3635000000E+04, 1.4288322964E+01, 5.1968843743E+00, 2.8779897156E+00, 1.6396803645E+00, 8.4730326089E-01],
	[2.3640000000E+04, 1.4293013757E+01, 5.1968104155E+00, 2.8799501809E+00, 1.6403709671E+00, 8.4737468174E-01],
	[2.3645000000E+04, 1.4297705098E+01, 5.1967364733E+00, 2.8819115657E+00, 1.6410615514E+00, 8.4744607136E-01],
	[2.3650000000E+04, 1.4302396987E+01, 5.1966625478E+00, 2.8838738704E+00, 1.6417521171E+00, 8.4751742975E-01],
	[2.3655000000E+04, 1.4307089422E+01, 5.1965886390E+00, 2.8858370951E+00, 1.6424426641E+00, 8.4758875692E-01],
	[2.3660000000E+04, 1.4311782405E+01, 5.1965147469E+00, 2.8878012400E+00, 1.6431331923E+00, 8.4766005287E-01],
	[2.3665000000E+04, 1.4316475935E+01, 5.1964408715E+00, 2.8897663055E+00, 1.6438237016E+00, 8.4773131763E-01],
	[2.3670000000E+04, 1.4321170013E+01, 5.1963670127E+00, 2.8917322917E+00, 1.6445141919E+00, 8.4780255118E-01],
	[2.3675000000E+04, 1.4325864637E+01, 5.1962931705E+00, 2.8936991989E+00, 1.6452046630E+00, 8.4787375355E-01],
	[2.3680000000E+04, 1.4330559809E+01, 5.1962193450E+00, 2.8956670274E+00, 1.6458951147E+00, 8.4794492475E-01],
	[2.3685000000E+04, 1.4335255527E+01, 5.1961455361E+00, 2.8976357772E+00, 1.6465855470E+00, 8.4801606477E-01],
	[2.3690000000E+04, 1.4339951793E+01, 5.1960717439E+00, 2.8996054488E+00, 1.6472759597E+00, 8.4808717364E-01],
	[2.3695000000E+04, 1.4344648605E+01, 5.1959979683E+00, 2.9015760423E+00, 1.6479663528E+00, 8.4815825136E-01],
	[2.3700000000E+04, 1.4349345965E+01, 5.1959242093E+00, 2.9035475579E+00, 1.6486567260E+00, 8.4822929793E-01],
	[2.3705000000E+04, 1.4354043871E+01, 5.1958504668E+00, 2.9055199960E+00, 1.6493470792E+00, 8.4830031338E-01],
	[2.3710000000E+04, 1.4358742324E+01, 5.1957767410E+00, 2.9074933566E+00, 1.6500374124E+00, 8.4837129770E-01],
	[2.3715000000E+04, 1.4363441324E+01, 5.1957030318E+00, 2.9094676402E+00, 1.6507277253E+00, 8.4844225091E-01],
	[2.3720000000E+04, 1.4368140870E+01, 5.1956293392E+00, 2.9114428468E+00, 1.6514180180E+00, 8.4851317301E-01],
	[2.3725000000E+04, 1.4372840963E+01, 5.1955556631E+00, 2.9134189768E+00, 1.6521082901E+00, 8.4858406401E-01],
	[2.3730000000E+04, 1.4377541603E+01, 5.1954820037E+00, 2.9153960304E+00, 1.6527985416E+00, 8.4865492393E-01],
	[2.3735000000E+04, 1.4382242789E+01, 5.1954083607E+00, 2.9173740078E+00, 1.6534887725E+00, 8.4872575277E-01],
	[2.3740000000E+04, 1.4386944521E+01, 5.1953347344E+00, 2.9193529092E+00, 1.6541789824E+00, 8.4879655055E-01],
	[2.3745000000E+04, 1.4391646800E+01, 5.1952611246E+00, 2.9213327350E+00, 1.6548691714E+00, 8.4886731726E-01],
	[2.3750000000E+04, 1.4396349626E+01, 5.1951875313E+00, 2.9233134852E+00, 1.6555593393E+00, 8.4893805292E-01],
	[2.3755000000E+04, 1.4401052997E+01, 5.1951139545E+00, 2.9252951602E+00, 1.6562494860E+00, 8.4900875754E-01],
	[2.3760000000E+04, 1.4405756915E+01, 5.1950403943E+00, 2.9272777603E+00, 1.6569396112E+00, 8.4907943113E-01],
	[2.3765000000E+04, 1.4410461380E+01, 5.1949668506E+00, 2.9292612855E+00, 1.6576297150E+00, 8.4915007369E-01],
	[2.3770000000E+04, 1.4415166390E+01, 5.1948933234E+00, 2.9312457362E+00, 1.6583197972E+00, 8.4922068524E-01],
	[2.3775000000E+04, 1.4419871946E+01, 5.1948198128E+00, 2.9332311126E+00, 1.6590098577E+00, 8.4929126578E-01],
	[2.3780000000E+04, 1.4424578049E+01, 5.1947463186E+00, 2.9352174150E+00, 1.6596998962E+00, 8.4936181533E-01],
	[2.3785000000E+04, 1.4429284697E+01, 5.1946728409E+00, 2.9372046436E+00, 1.6603899128E+00, 8.4943233389E-01],
	[2.3790000000E+04, 1.4433991892E+01, 5.1945993797E+00, 2.9391927985E+00, 1.6610799072E+00, 8.4950282147E-01],
	[2.3795000000E+04, 1.4438699632E+01, 5.1945259350E+00, 2.9411818801E+00, 1.6617698794E+00, 8.4957327809E-01],
	[2.3800000000E+04, 1.4443407918E+01, 5.1944525067E+00, 2.9431718886E+00, 1.6624598292E+00, 8.4964370374E-01],
	[2.3805000000E+04, 1.4448116750E+01, 5.1943790949E+00, 2.9451628242E+00, 1.6631497565E+00, 8.4971409844E-01],
	[2.3810000000E+04, 1.4452826128E+01, 5.1943056996E+00, 2.9471546872E+00, 1.6638396612E+00, 8.4978446220E-01],
	[2.3815000000E+04, 1.4457536052E+01, 5.1942323207E+00, 2.9491474778E+00, 1.6645295431E+00, 8.4985479502E-01],
	[2.3820000000E+04, 1.4462246521E+01, 5.1941589582E+00, 2.9511411962E+00, 1.6652194022E+00, 8.4992509691E-01],
	[2.3825000000E+04, 1.4466957535E+01, 5.1940856122E+00, 2.9531358427E+00, 1.6659092382E+00, 8.4999536788E-01],
	[2.3830000000E+04, 1.4471669096E+01, 5.1940122826E+00, 2.9551314175E+00, 1.6665990511E+00, 8.5006560793E-01],
	[2.3835000000E+04, 1.4476381201E+01, 5.1939389694E+00, 2.9571279209E+00, 1.6672888407E+00, 8.5013581708E-01],
	[2.3840000000E+04, 1.4481093853E+01, 5.1938656727E+00, 2.9591253530E+00, 1.6679786069E+00, 8.5020599533E-01],
	[2.3845000000E+04, 1.4485807049E+01, 5.1937923923E+00, 2.9611237141E+00, 1.6686683496E+00, 8.5027614269E-01],
	[2.3850000000E+04, 1.4490520791E+01, 5.1937191283E+00, 2.9631230045E+00, 1.6693580687E+00, 8.5034625916E-01],
	[2.3855000000E+04, 1.4495235078E+01, 5.1936458808E+00, 2.9651232244E+00, 1.6700477640E+00, 8.5041634475E-01],
	[2.3860000000E+04, 1.4499949911E+01, 5.1935726496E+00, 2.9671243740E+00, 1.6707374354E+00, 8.5048639948E-01],
	[2.3865000000E+04, 1.4504665288E+01, 5.1934994348E+00, 2.9691264535E+00, 1.6714270828E+00, 8.5055642334E-01],
	[2.3870000000E+04, 1.4509381211E+01, 5.1934262363E+00, 2.9711294633E+00, 1.6721167060E+00, 8.5062641636E-01],
	[2.3875000000E+04, 1.4514097679E+01, 5.1933530543E+00, 2.9731334035E+00, 1.6728063050E+00, 8.5069637852E-01],
	[2.3880000000E+04, 1.4518814692E+01, 5.1932798885E+00, 2.9751382744E+00, 1.6734958796E+00, 8.5076630985E-01],
	[2.3885000000E+04, 1.4523532249E+01, 5.1932067392E+00, 2.9771440762E+00, 1.6741854296E+00, 8.5083621035E-01],
	[2.3890000000E+04, 1.4528250352E+01, 5.1931336061E+00, 2.9791508091E+00, 1.6748749550E+00, 8.5090608003E-01],
	[2.3895000000E+04, 1.4532969000E+01, 5.1930604894E+00, 2.9811584734E+00, 1.6755644556E+00, 8.5097591889E-01],
	[2.3900000000E+04, 1.4537688192E+01, 5.1929873891E+00, 2.9831670693E+00, 1.6762539313E+00, 8.5104572694E-01],
	[2.3905000000E+04, 1.4542407930E+01, 5.1929143050E+00, 2.9851765971E+00, 1.6769433820E+00, 8.5111550419E-01],
	[2.3910000000E+04, 1.4547128212E+01, 5.1928412373E+00, 2.9871870570E+00, 1.6776328076E+00, 8.5118525066E-01],
	[2.3915000000E+04, 1.4551849038E+01, 5.1927681858E+00, 2.9891984492E+00, 1.6783222079E+00, 8.5125496634E-01],
	[2.3920000000E+04, 1.4556589338E+01, 5.1926987270E+00, 2.9912107740E+00, 1.6790122085E+00, 8.5132465124E-01],
	[2.3925000000E+04, 1.4561332663E+01, 5.1926297504E+00, 2.9932240315E+00, 1.6797022660E+00, 8.5139430538E-01],
	[2.3930000000E+04, 1.4566076541E+01, 5.1925607891E+00, 2.9952382222E+00, 1.6803922988E+00, 8.5146392875E-01],
	[2.3935000000E+04, 1.4570820974E+01, 5.1924918431E+00, 2.9972533460E+00, 1.6810823066E+00, 8.5153352138E-01],
	[2.3940000000E+04, 1.4575565960E+01, 5.1924229125E+00, 2.9992694034E+00, 1.6817722893E+00, 8.5160308326E-01],
	[2.3945000000E+04, 1.4580311500E+01, 5.1923539971E+00, 3.0012863946E+00, 1.6824622469E+00, 8.5167261440E-01],
	[2.3950000000E+04, 1.4585057594E+01, 5.1922850971E+00, 3.0033043197E+00, 1.6831521791E+00, 8.5174211481E-01],
	[2.3955000000E+04, 1.4589804241E+01, 5.1922162123E+00, 3.0053231791E+00, 1.6838420860E+00, 8.5181158451E-01],
	[2.3960000000E+04, 1.4594551442E+01, 5.1921473429E+00, 3.0073429729E+00, 1.6845319672E+00, 8.5188102349E-01],
	[2.3965000000E+04, 1.4599299197E+01, 5.1920784887E+00, 3.0093637014E+00, 1.6852218228E+00, 8.5195043176E-01],
	[2.3970000000E+04, 1.4604047505E+01, 5.1920096498E+00, 3.0113853649E+00, 1.6859116526E+00, 8.5201980934E-01],
	[2.3975000000E+04, 1.4608796367E+01, 5.1919408262E+00, 3.0134079635E+00, 1.6866014565E+00, 8.5208915623E-01],
	[2.3980000000E+04, 1.4613545782E+01, 5.1918720178E+00, 3.0154314975E+00, 1.6872912343E+00, 8.5215847244E-01],
	[2.3985000000E+04, 1.4618295751E+01, 5.1918032247E+00, 3.0174559672E+00, 1.6879809859E+00, 8.5222775798E-01],
	[2.3990000000E+04, 1.4623046273E+01, 5.1917344468E+00, 3.0194813727E+00, 1.6886707112E+00, 8.5229701285E-01],
	[2.3995000000E+04, 1.4627797348E+01, 5.1916656842E+00, 3.0215077144E+00, 1.6893604101E+00, 8.5236623707E-01],
	[2.4000000000E+04, 1.4632548976E+01, 5.1915969368E+00, 3.0235349924E+00, 1.6900500825E+00, 8.5243543063E-01],
	[2.4005000000E+04, 1.4637301158E+01, 5.1915282047E+00, 3.0255632070E+00, 1.6907397282E+00, 8.5250459356E-01],
	[2.4010000000E+04, 1.4642053893E+01, 5.1914594878E+00, 3.0275923585E+00, 1.6914293470E+00, 8.5257372585E-01],
	[2.4015000000E+04, 1.4646807181E+01, 5.1913907861E+00, 3.0296224470E+00, 1.6921189390E+00, 8.5264282752E-01],
	[2.4020000000E+04, 1.4651561022E+01, 5.1913220996E+00, 3.0316534728E+00, 1.6928085039E+00, 8.5271189857E-01],
	[2.4025000000E+04, 1.4656315416E+01, 5.1912534283E+00, 3.0336854361E+00, 1.6934980417E+00, 8.5278093901E-01],
	[2.4030000000E+04, 1.4661070363E+01, 5.1911847722E+00, 3.0357183372E+00, 1.6941875521E+00, 8.5284994886E-01],
	[2.4035000000E+04, 1.4665825863E+01, 5.1911161313E+00, 3.0377521764E+00, 1.6948770352E+00, 8.5291892811E-01],
	[2.4040000000E+04, 1.4670581915E+01, 5.1910475056E+00, 3.0397869537E+00, 1.6955664907E+00, 8.5298787677E-01],
	[2.4045000000E+04, 1.4675338521E+01, 5.1909788951E+00, 3.0418226696E+00, 1.6962559186E+00, 8.5305679486E-01],
	[2.4050000000E+04, 1.4680095679E+01, 5.1909102997E+00, 3.0438593242E+00, 1.6969453186E+00, 8.5312568239E-01],
	[2.4055000000E+04, 1.4684853390E+01, 5.1908417195E+00, 3.0458969177E+00, 1.6976346908E+00, 8.5319453935E-01],
	[2.4060000000E+04, 1.4689611653E+01, 5.1907731545E+00, 3.0479354505E+00, 1.6983240350E+00, 8.5326336576E-01],
	[2.4065000000E+04, 1.4694370469E+01, 5.1907046046E+00, 3.0499749227E+00, 1.6990133509E+00, 8.5333216163E-01],
	[2.4070000000E+04, 1.4699129838E+01, 5.1906360699E+00, 3.0520153345E+00, 1.6997026387E+00, 8.5340092696E-01],
	[2.4075000000E+04, 1.4703889759E+01, 5.1905675503E+00, 3.0540566863E+00, 1.7003918980E+00, 8.5346966177E-01],
	[2.4080000000E+04, 1.4708650233E+01, 5.1904990458E+00, 3.0560989782E+00, 1.7010811288E+00, 8.5353836605E-01],
	[2.4085000000E+04, 1.4713411259E+01, 5.1904305565E+00, 3.0581422104E+00, 1.7017703309E+00, 8.5360703983E-01],
	[2.4090000000E+04, 1.4718172837E+01, 5.1903620823E+00, 3.0601863833E+00, 1.7024595043E+00, 8.5367568310E-01],
	[2.4095000000E+04, 1.4722934968E+01, 5.1902936232E+00, 3.0622314971E+00, 1.7031486489E+00, 8.5374429588E-01],
	[2.4100000000E+04, 1.4727697650E+01, 5.1902251792E+00, 3.0642775519E+00, 1.7038377644E+00, 8.5381287818E-01],
	[2.4105000000E+04, 1.4732460885E+01, 5.1901567503E+00, 3.0663245481E+00, 1.7045268507E+00, 8.5388143000E-01],
	[2.4110000000E+04, 1.4737224672E+01, 5.1900883365E+00, 3.0683724859E+00, 1.7052159079E+00, 8.5394995135E-01],
	[2.4115000000E+04, 1.4741989012E+01, 5.1900199378E+00, 3.0704213654E+00, 1.7059049356E+00, 8.5401844223E-01],
	[2.4120000000E+04, 1.4746753903E+01, 5.1899515541E+00, 3.0724711870E+00, 1.7065939339E+00, 8.5408690267E-01],
	[2.4125000000E+04, 1.4751519346E+01, 5.1898831856E+00, 3.0745219509E+00, 1.7072829025E+00, 8.5415533266E-01],
	[2.4130000000E+04, 1.4756285341E+01, 5.1898148321E+00, 3.0765736573E+00, 1.7079718414E+00, 8.5422373222E-01],
	[2.4135000000E+04, 1.4761051888E+01, 5.1897464937E+00, 3.0786263064E+00, 1.7086607504E+00, 8.5429210135E-01],
	[2.4140000000E+04, 1.4765818987E+01, 5.1896781703E+00, 3.0806798985E+00, 1.7093496294E+00, 8.5436044005E-01],
	[2.4145000000E+04, 1.4770586638E+01, 5.1896098620E+00, 3.0827344339E+00, 1.7100384784E+00, 8.5442874835E-01],
	[2.4150000000E+04, 1.4775354840E+01, 5.1895415687E+00, 3.0847899127E+00, 1.7107272971E+00, 8.5449702625E-01],
	[2.4155000000E+04, 1.4780123594E+01, 5.1894732905E+00, 3.0868463352E+00, 1.7114160855E+00, 8.5456527375E-01],
	[2.4160000000E+04, 1.4784892900E+01, 5.1894050273E+00, 3.0889037017E+00, 1.7121048434E+00, 8.5463349087E-01],
	[2.4165000000E+04, 1.4789662757E+01, 5.1893367791E+00, 3.0909620123E+00, 1.7127935707E+00, 8.5470167761E-01],
	[2.4170000000E+04, 1.4794433166E+01, 5.1892685459E+00, 3.0930212674E+00, 1.7134822673E+00, 8.5476983398E-01],
	[2.4175000000E+04, 1.4799204126E+01, 5.1892003277E+00, 3.0950814671E+00, 1.7141709330E+00, 8.5483795999E-01],
	[2.4180000000E+04, 1.4803975637E+01, 5.1891321246E+00, 3.0971426116E+00, 1.7148595678E+00, 8.5490605565E-01],
	[2.4185000000E+04, 1.4808747701E+01, 5.1890639364E+00, 3.0992047013E+00, 1.7155481715E+00, 8.5497412097E-01],
	[2.4190000000E+04, 1.4813520315E+01, 5.1889957633E+00, 3.1012677364E+00, 1.7162367441E+00, 8.5504215595E-01],
	[2.4195000000E+04, 1.4818293480E+01, 5.1889276051E+00, 3.1033317171E+00, 1.7169252853E+00, 8.5511016061E-01],
	[2.4200000000E+04, 1.4823067197E+01, 5.1888594619E+00, 3.1053966436E+00, 1.7176137951E+00, 8.5517813495E-01],
	[2.4205000000E+04, 1.4827841465E+01, 5.1887913336E+00, 3.1074625162E+00, 1.7183022733E+00, 8.5524607898E-01],
	[2.4210000000E+04, 1.4832616284E+01, 5.1887232204E+00, 3.1095293350E+00, 1.7189907198E+00, 8.5531399271E-01],
	[2.4215000000E+04, 1.4837391655E+01, 5.1886551221E+00, 3.1115971005E+00, 1.7196791346E+00, 8.5538187615E-01],
	[2.4220000000E+04, 1.4842167576E+01, 5.1885870387E+00, 3.1136658127E+00, 1.7203675174E+00, 8.5544972930E-01],
	[2.4225000000E+04, 1.4846944048E+01, 5.1885189703E+00, 3.1157354719E+00, 1.7210558681E+00, 8.5551755218E-01],
	[2.4230000000E+04, 1.4851721071E+01, 5.1884509169E+00, 3.1178060784E+00, 1.7217441868E+00, 8.5558534479E-01],
	[2.4235000000E+04, 1.4856498645E+01, 5.1883828783E+00, 3.1198776324E+00, 1.7224324731E+00, 8.5565310714E-01],
	[2.4240000000E+04, 1.4861276770E+01, 5.1883148547E+00, 3.1219501342E+00, 1.7231207270E+00, 8.5572083925E-01],
	[2.4245000000E+04, 1.4866055446E+01, 5.1882468460E+00, 3.1240235839E+00, 1.7238089484E+00, 8.5578854111E-01],
	[2.4250000000E+04, 1.4870834672E+01, 5.1881788523E+00, 3.1260979818E+00, 1.7244971372E+00, 8.5585621275E-01],
	[2.4255000000E+04, 1.4875614449E+01, 5.1881108734E+00, 3.1281733282E+00, 1.7251852932E+00, 8.5592385416E-01],
	[2.4260000000E+04, 1.4880394777E+01, 5.1880429095E+00, 3.1302496232E+00, 1.7258734163E+00, 8.5599146535E-01],
	[2.4265000000E+04, 1.4885175655E+01, 5.1879749604E+00, 3.1323268672E+00, 1.7265615065E+00, 8.5605904634E-01],
	[2.4270000000E+04, 1.4889957084E+01, 5.1879070262E+00, 3.1344050603E+00, 1.7272495635E+00, 8.5612659713E-01],
	[2.4275000000E+04, 1.4894739063E+01, 5.1878391070E+00, 3.1364842028E+00, 1.7279375872E+00, 8.5619411774E-01],
	[2.4280000000E+04, 1.4899521592E+01, 5.1877712025E+00, 3.1385642950E+00, 1.7286255776E+00, 8.5626160816E-01],
	[2.4285000000E+04, 1.4904304672E+01, 5.1877033130E+00, 3.1406453370E+00, 1.7293135346E+00, 8.5632906841E-01],
	[2.4290000000E+04, 1.4909088303E+01, 5.1876354383E+00, 3.1427273291E+00, 1.7300014579E+00, 8.5639649850E-01],
	[2.4295000000E+04, 1.4913872483E+01, 5.1875675785E+00, 3.1448102716E+00, 1.7306893475E+00, 8.5646389844E-01],
	[2.4300000000E+04, 1.4918657214E+01, 5.1874997336E+00, 3.1468941647E+00, 1.7313772033E+00, 8.5653126823E-01],
	[2.4305000000E+04, 1.4923461631E+01, 5.1874354195E+00, 3.1489790085E+00, 1.7320656748E+00, 8.5659860788E-01],
	[2.4310000000E+04, 1.4928269145E+01, 5.1873715858E+00, 3.1510648035E+00, 1.7327541993E+00, 8.5666591741E-01],
	[2.4315000000E+04, 1.4933077219E+01, 5.1873077660E+00, 3.1531515497E+00, 1.7334426904E+00, 8.5673319681E-01],
	[2.4320000000E+04, 1.4937885852E+01, 5.1872439601E+00, 3.1552392475E+00, 1.7341311481E+00, 8.5680044611E-01],
	[2.4325000000E+04, 1.4942695045E+01, 5.1871801681E+00, 3.1573278970E+00, 1.7348195722E+00, 8.5686766531E-01],
	[2.4330000000E+04, 1.4947504797E+01, 5.1871163900E+00, 3.1594174986E+00, 1.7355079625E+00, 8.5693485441E-01],
	[2.4335000000E+04, 1.4952315109E+01, 5.1870526258E+00, 3.1615080524E+00, 1.7361963191E+00, 8.5700201343E-01],
	[2.4340000000E+04, 1.4957125979E+01, 5.1869888755E+00, 3.1635995586E+00, 1.7368846416E+00, 8.5706914238E-01],
	[2.4345000000E+04, 1.4961937409E+01, 5.1869251390E+00, 3.1656920176E+00, 1.7375729302E+00, 8.5713624126E-01],
	[2.4350000000E+04, 1.4966749399E+01, 5.1868614165E+00, 3.1677854296E+00, 1.7382611845E+00, 8.5720331008E-01],
	[2.4355000000E+04, 1.4971561947E+01, 5.1867977078E+00, 3.1698797947E+00, 1.7389494045E+00, 8.5727034885E-01],
	[2.4360000000E+04, 1.4976375054E+01, 5.1867340129E+00, 3.1719751133E+00, 1.7396375901E+00, 8.5733735759E-01],
	[2.4365000000E+04, 1.4981188721E+01, 5.1866703319E+00, 3.1740713856E+00, 1.7403257412E+00, 8.5740433629E-01],
	[2.4370000000E+04, 1.4986002946E+01, 5.1866066648E+00, 3.1761686117E+00, 1.7410138576E+00, 8.5747128497E-01],
	[2.4375000000E+04, 1.4990817731E+01, 5.1865430115E+00, 3.1782667921E+00, 1.7417019393E+00, 8.5753820364E-01],
	[2.4380000000E+04, 1.4995633074E+01, 5.1864793720E+00, 3.1803659267E+00, 1.7423899860E+00, 8.5760509230E-01],
	[2.4385000000E+04, 1.5000448976E+01, 5.1864157464E+00, 3.1824660161E+00, 1.7430779978E+00, 8.5767195097E-01],
	[2.4390000000E+04, 1.5005265437E+01, 5.1863521346E+00, 3.1845670602E+00, 1.7437659744E+00, 8.5773877966E-01],
	[2.4395000000E+04, 1.5010082457E+01, 5.1862885366E+00, 3.1866690595E+00, 1.7444539157E+00, 8.5780557836E-01],
	[2.4400000000E+04, 1.5014900035E+01, 5.1862249524E+00, 3.1887720141E+00, 1.7451418217E+00, 8.5787234710E-01],
	[2.4405000000E+04, 1.5019718172E+01, 5.1861613820E+00, 3.1908759243E+00, 1.7458296923E+00, 8.5793908588E-01],
	[2.4410000000E+04, 1.5024536868E+01, 5.1860978254E+00, 3.1929807903E+00, 1.7465175272E+00, 8.5800579471E-01],
	[2.4415000000E+04, 1.5029356122E+01, 5.1860342827E+00, 3.1950866123E+00, 1.7472053264E+00, 8.5807247360E-01],
	[2.4420000000E+04, 1.5034175935E+01, 5.1859707537E+00, 3.1971933906E+00, 1.7478930898E+00, 8.5813912255E-01],
	[2.4425000000E+04, 1.5038996306E+01, 5.1859072385E+00, 3.1993011255E+00, 1.7485808172E+00, 8.5820574158E-01],
	[2.4430000000E+04, 1.5043817236E+01, 5.1858437371E+00, 3.2014098171E+00, 1.7492685085E+00, 8.5827233070E-01],
	[2.4435000000E+04, 1.5048638724E+01, 5.1857802494E+00, 3.2035194657E+00, 1.7499561637E+00, 8.5833888991E-01],
	[2.4440000000E+04, 1.5053460770E+01, 5.1857167755E+00, 3.2056300715E+00, 1.7506437826E+00, 8.5840541923E-01],
	[2.4445000000E+04, 1.5058283374E+01, 5.1856533154E+00, 3.2077416348E+00, 1.7513313650E+00, 8.5847191866E-01],
	[2.4450000000E+04, 1.5063106537E+01, 5.1855898691E+00, 3.2098541558E+00, 1.7520189109E+00, 8.5853838820E-01],
	[2.4455000000E+04, 1.5067930258E+01, 5.1855264364E+00, 3.2119676348E+00, 1.7527064202E+00, 8.5860482788E-01],
	[2.4460000000E+04, 1.5072754537E+01, 5.1854630176E+00, 3.2140820720E+00, 1.7533938927E+00, 8.5867123770E-01],
	[2.4465000000E+04, 1.5077579374E+01, 5.1853996124E+00, 3.2161974676E+00, 1.7540813283E+00, 8.5873761767E-01],
	[2.4470000000E+04, 1.5082404769E+01, 5.1853362210E+00, 3.2183138218E+00, 1.7547687269E+00, 8.5880396780E-01],
	[2.4475000000E+04, 1.5087230722E+01, 5.1852728434E+00, 3.2204311349E+00, 1.7554560884E+00, 8.5887028809E-01],
	[2.4480000000E+04, 1.5092057233E+01, 5.1852094794E+00, 3.2225494072E+00, 1.7561434126E+00, 8.5893657856E-01],
	[2.4485000000E+04, 1.5096884301E+01, 5.1851461292E+00, 3.2246686389E+00, 1.7568306995E+00, 8.5900283922E-01],
	[2.4490000000E+04, 1.5101711928E+01, 5.1850827926E+00, 3.2267888302E+00, 1.7575179490E+00, 8.5906907007E-01],
	[2.4495000000E+04, 1.5106540112E+01, 5.1850194698E+00, 3.2289099813E+00, 1.7582051608E+00, 8.5913527112E-01],
	[2.4500000000E+04, 1.5111368854E+01, 5.1849561607E+00, 3.2310320925E+00, 1.7588923350E+00, 8.5920144239E-01],
	[2.4505000000E+04, 1.5116198154E+01, 5.1848928652E+00, 3.2331551641E+00, 1.7595794713E+00, 8.5926758387E-01],
	[2.4510000000E+04, 1.5121028011E+01, 5.1848295835E+00, 3.2352791962E+00, 1.7602665697E+00, 8.5933369559E-01],
	[2.4515000000E+04, 1.5125858426E+01, 5.1847663154E+00, 3.2374041891E+00, 1.7609536300E+00, 8.5939977755E-01],
	[2.4520000000E+04, 1.5130689398E+01, 5.1847030610E+00, 3.2395301430E+00, 1.7616406522E+00, 8.5946582976E-01],
	[2.4525000000E+04, 1.5135520928E+01, 5.1846398203E+00, 3.2416570583E+00, 1.7623276361E+00, 8.5953185223E-01],
	[2.4530000000E+04, 1.5140353015E+01, 5.1845765932E+00, 3.2437849350E+00, 1.7630145816E+00, 8.5959784496E-01],
	[2.4535000000E+04, 1.5145185659E+01, 5.1845133798E+00, 3.2459137735E+00, 1.7637014886E+00, 8.5966380797E-01],
	[2.4540000000E+04, 1.5150018861E+01, 5.1844501801E+00, 3.2480435740E+00, 1.7643883570E+00, 8.5972974127E-01],
	[2.4545000000E+04, 1.5154852620E+01, 5.1843869939E+00, 3.2501743367E+00, 1.7650751866E+00, 8.5979564486E-01],
	[2.4550000000E+04, 1.5159686937E+01, 5.1843238215E+00, 3.2523060619E+00, 1.7657619774E+00, 8.5986151875E-01],
	[2.4555000000E+04, 1.5164521810E+01, 5.1842606626E+00, 3.2544387498E+00, 1.7664487292E+00, 8.5992736296E-01],
	[2.4560000000E+04, 1.5169357241E+01, 5.1841975174E+00, 3.2565724007E+00, 1.7671354419E+00, 8.5999317750E-01],
	[2.4565000000E+04, 1.5174193228E+01, 5.1841343858E+00, 3.2587070147E+00, 1.7678221154E+00, 8.6005896236E-01],
	[2.4570000000E+04, 1.5179029773E+01, 5.1840712679E+00, 3.2608425922E+00, 1.7685087496E+00, 8.6012471757E-01],
	[2.4575000000E+04, 1.5183866875E+01, 5.1840081635E+00, 3.2629791333E+00, 1.7691953444E+00, 8.6019044313E-01],
	[2.4580000000E+04, 1.5188704533E+01, 5.1839450728E+00, 3.2651166383E+00, 1.7698818996E+00, 8.6025613905E-01],
	[2.4585000000E+04, 1.5193542749E+01, 5.1838819956E+00, 3.2672551074E+00, 1.7705684152E+00, 8.6032180533E-01],
	[2.4590000000E+04, 1.5198381521E+01, 5.1838189320E+00, 3.2693945409E+00, 1.7712548909E+00, 8.6038744200E-01],
	[2.4595000000E+04, 1.5203220850E+01, 5.1837558821E+00, 3.2715349391E+00, 1.7719413268E+00, 8.6045304905E-01],
	[2.4600000000E+04, 1.5208060736E+01, 5.1836928457E+00, 3.2736763020E+00, 1.7726277227E+00, 8.6051862650E-01],
	[2.4605000000E+04, 1.5212901178E+01, 5.1836298229E+00, 3.2758186301E+00, 1.7733140784E+00, 8.6058417436E-01],
	[2.4610000000E+04, 1.5217742177E+01, 5.1835668136E+00, 3.2779619235E+00, 1.7740003940E+00, 8.6064969263E-01],
	[2.4615000000E+04, 1.5222583733E+01, 5.1835038180E+00, 3.2801061824E+00, 1.7746866691E+00, 8.6071518133E-01],
	[2.4620000000E+04, 1.5227425845E+01, 5.1834408359E+00, 3.2822514072E+00, 1.7753729038E+00, 8.6078064047E-01],
	[2.4625000000E+04, 1.5232268513E+01, 5.1833778673E+00, 3.2843975980E+00, 1.7760590980E+00, 8.6084607005E-01],
	[2.4630000000E+04, 1.5237111739E+01, 5.1833149123E+00, 3.2865447550E+00, 1.7767452514E+00, 8.6091147008E-01],
	[2.4635000000E+04, 1.5241955520E+01, 5.1832519708E+00, 3.2886928786E+00, 1.7774313640E+00, 8.6097684057E-01],
	[2.4640000000E+04, 1.5246799858E+01, 5.1831890429E+00, 3.2908419690E+00, 1.7781174357E+00, 8.6104218154E-01],
	[2.4645000000E+04, 1.5251644752E+01, 5.1831261285E+00, 3.2929920263E+00, 1.7788034664E+00, 8.6110749299E-01],
	[2.4650000000E+04, 1.5256490202E+01, 5.1830632276E+00, 3.2951430509E+00, 1.7794894559E+00, 8.6117277492E-01],
	[2.4655000000E+04, 1.5261336208E+01, 5.1830003403E+00, 3.2972950429E+00, 1.7801754042E+00, 8.6123802736E-01],
	[2.4660000000E+04, 1.5266182771E+01, 5.1829374665E+00, 3.2994480026E+00, 1.7808613111E+00, 8.6130325031E-01],
	[2.4665000000E+04, 1.5271029890E+01, 5.1828746061E+00, 3.3016019303E+00, 1.7815471765E+00, 8.6136844378E-01],
	[2.4670000000E+04, 1.5275877564E+01, 5.1828117593E+00, 3.3037568262E+00, 1.7822330003E+00, 8.6143360778E-01],
	[2.4675000000E+04, 1.5280725795E+01, 5.1827489260E+00, 3.3059126904E+00, 1.7829187824E+00, 8.6149874231E-01],
	[2.4680000000E+04, 1.5285574582E+01, 5.1826861062E+00, 3.3080695234E+00, 1.7836045226E+00, 8.6156384740E-01],
	[2.4685000000E+04, 1.5290423924E+01, 5.1826232998E+00, 3.3102273252E+00, 1.7842902210E+00, 8.6162892304E-01],
	[2.4690000000E+04, 1.5295273822E+01, 5.1825605070E+00, 3.3123860962E+00, 1.7849758772E+00, 8.6169396925E-01],
	[2.4695000000E+04, 1.5300138362E+01, 5.1825002447E+00, 3.3145458365E+00, 1.7856619820E+00, 8.6175898603E-01],
	[2.4700000000E+04, 1.5305011332E+01, 5.1824414010E+00, 3.3167065465E+00, 1.7863483192E+00, 8.6182397340E-01],
	[2.4705000000E+04, 1.5309884868E+01, 5.1823825699E+00, 3.3188682263E+00, 1.7870346149E+00, 8.6188893136E-01],
	[2.4710000000E+04, 1.5314758968E+01, 5.1823237513E+00, 3.3210308762E+00, 1.7877208689E+00, 8.6195385993E-01],
	[2.4715000000E+04, 1.5319633634E+01, 5.1822649454E+00, 3.3231944964E+00, 1.7884070812E+00, 8.6201875911E-01],
	[2.4720000000E+04, 1.5324508864E+01, 5.1822061520E+00, 3.3253590872E+00, 1.7890932515E+00, 8.6208362892E-01],
	[2.4725000000E+04, 1.5329384660E+01, 5.1821473711E+00, 3.3275246488E+00, 1.7897793799E+00, 8.6214846936E-01],
	[2.4730000000E+04, 1.5334261021E+01, 5.1820886029E+00, 3.3296911815E+00, 1.7904654661E+00, 8.6221328044E-01],
	[2.4735000000E+04, 1.5339137946E+01, 5.1820298471E+00, 3.3318586854E+00, 1.7911515101E+00, 8.6227806217E-01],
	[2.4740000000E+04, 1.5344015437E+01, 5.1819711039E+00, 3.3340271608E+00, 1.7918375118E+00, 8.6234281457E-01],
	[2.4745000000E+04, 1.5348893492E+01, 5.1819123733E+00, 3.3361966080E+00, 1.7925234710E+00, 8.6240753764E-01],
	[2.4750000000E+04, 1.5353772112E+01, 5.1818536551E+00, 3.3383670272E+00, 1.7932093877E+00, 8.6247223139E-01],
	[2.4755000000E+04, 1.5358651297E+01, 5.1817949495E+00, 3.3405384186E+00, 1.7938952616E+00, 8.6253689583E-01],
	[2.4760000000E+04, 1.5363531046E+01, 5.1817362564E+00, 3.3427107825E+00, 1.7945810928E+00, 8.6260153097E-01],
	[2.4765000000E+04, 1.5368411360E+01, 5.1816775759E+00, 3.3448841191E+00, 1.7952668811E+00, 8.6266613682E-01],
	[2.4770000000E+04, 1.5373292239E+01, 5.1816189078E+00, 3.3470584287E+00, 1.7959526264E+00, 8.6273071339E-01],
	[2.4775000000E+04, 1.5378173682E+01, 5.1815602523E+00, 3.3492337114E+00, 1.7966383285E+00, 8.6279526068E-01],
	[2.4780000000E+04, 1.5383055689E+01, 5.1815016092E+00, 3.3514099676E+00, 1.7973239874E+00, 8.6285977872E-01],
	[2.4785000000E+04, 1.5387938261E+01, 5.1814429786E+00, 3.3535871974E+00, 1.7980096030E+00, 8.6292426751E-01],
	[2.4790000000E+04, 1.5392821398E+01, 5.1813843606E+00, 3.3557654012E+00, 1.7986951750E+00, 8.6298872705E-01],
	[2.4795000000E+04, 1.5397705098E+01, 5.1813257550E+00, 3.3579445790E+00, 1.7993807036E+00, 8.6305315736E-01],
	[2.4800000000E+04, 1.5402589363E+01, 5.1812671619E+00, 3.3601247313E+00, 1.8000661884E+00, 8.6311755845E-01],
	[2.4805000000E+04, 1.5407474192E+01, 5.1812085813E+00, 3.3623058582E+00, 1.8007516295E+00, 8.6318193032E-01],
	[2.4810000000E+04, 1.5412359586E+01, 5.1811500131E+00, 3.3644879599E+00, 1.8014370266E+00, 8.6324627300E-01],
	[2.4815000000E+04, 1.5417245543E+01, 5.1810914574E+00, 3.3666710367E+00, 1.8021223797E+00, 8.6331058647E-01],
	[2.4820000000E+04, 1.5422132065E+01, 5.1810329142E+00, 3.3688550889E+00, 1.8028076887E+00, 8.6337487077E-01],
	[2.4825000000E+04, 1.5427019150E+01, 5.1809743834E+00, 3.3710401166E+00, 1.8034929535E+00, 8.6343912589E-01],
	[2.4830000000E+04, 1.5431906800E+01, 5.1809158651E+00, 3.3732261202E+00, 1.8041781739E+00, 8.6350335184E-01],
	[2.4835000000E+04, 1.5436795013E+01, 5.1808573592E+00, 3.3754130997E+00, 1.8048633498E+00, 8.6356754864E-01],
	[2.4840000000E+04, 1.5441683790E+01, 5.1807988657E+00, 3.3776010556E+00, 1.8055484812E+00, 8.6363171630E-01],
	[2.4845000000E+04, 1.5446573132E+01, 5.1807403847E+00, 3.3797899880E+00, 1.8062335679E+00, 8.6369585482E-01],
	[2.4850000000E+04, 1.5451463037E+01, 5.1806819161E+00, 3.3819798972E+00, 1.8069186098E+00, 8.6375996421E-01],
	[2.4855000000E+04, 1.5456353505E+01, 5.1806234599E+00, 3.3841707834E+00, 1.8076036068E+00, 8.6382404449E-01],
	[2.4860000000E+04, 1.5461244538E+01, 5.1805650162E+00, 3.3863626468E+00, 1.8082885588E+00, 8.6388809566E-01],
	[2.4865000000E+04, 1.5466136134E+01, 5.1805065848E+00, 3.3885554877E+00, 1.8089734657E+00, 8.6395211773E-01],
	[2.4870000000E+04, 1.5471028293E+01, 5.1804481659E+00, 3.3907493063E+00, 1.8096583273E+00, 8.6401611072E-01],
	[2.4875000000E+04, 1.5475921017E+01, 5.1803897594E+00, 3.3929441029E+00, 1.8103431436E+00, 8.6408007463E-01],
	[2.4880000000E+04, 1.5480814303E+01, 5.1803313652E+00, 3.3951398776E+00, 1.8110279144E+00, 8.6414400948E-01],
	[2.4885000000E+04, 1.5485708153E+01, 5.1802729835E+00, 3.3973366308E+00, 1.8117126397E+00, 8.6420791527E-01],
	[2.4890000000E+04, 1.5490602567E+01, 5.1802146141E+00, 3.3995343627E+00, 1.8123973193E+00, 8.6427179201E-01],
	[2.4895000000E+04, 1.5495497544E+01, 5.1801562572E+00, 3.4017330735E+00, 1.8130819531E+00, 8.6433563971E-01],
	[2.4900000000E+04, 1.5500393084E+01, 5.1800979126E+00, 3.4039327634E+00, 1.8137665410E+00, 8.6439945838E-01],
	[2.4905000000E+04, 1.5505289188E+01, 5.1800395804E+00, 3.4061334328E+00, 1.8144510829E+00, 8.6446324804E-01],
	[2.4910000000E+04, 1.5510185854E+01, 5.1799812605E+00, 3.4083350817E+00, 1.8151355787E+00, 8.6452700869E-01],
	[2.4915000000E+04, 1.5515083084E+01, 5.1799229530E+00, 3.4105377105E+00, 1.8158200283E+00, 8.6459074033E-01],
	[2.4920000000E+04, 1.5519980877E+01, 5.1798646579E+00, 3.4127413195E+00, 1.8165044315E+00, 8.6465444300E-01],
	[2.4925000000E+04, 1.5524879233E+01, 5.1798063751E+00, 3.4149459087E+00, 1.8171887883E+00, 8.6471811668E-01],
	[2.4930000000E+04, 1.5529778152E+01, 5.1797481046E+00, 3.4171514786E+00, 1.8178730985E+00, 8.6478176139E-01],
	[2.4935000000E+04, 1.5534677634E+01, 5.1796898465E+00, 3.4193580293E+00, 1.8185573621E+00, 8.6484537714E-01],
	[2.4940000000E+04, 1.5539577679E+01, 5.1796316008E+00, 3.4215655610E+00, 1.8192415789E+00, 8.6490896395E-01],
	[2.4945000000E+04, 1.5544478287E+01, 5.1795733673E+00, 3.4237740740E+00, 1.8199257489E+00, 8.6497252182E-01],
	[2.4950000000E+04, 1.5549379457E+01, 5.1795151462E+00, 3.4259835686E+00, 1.8206098718E+00, 8.6503605075E-01],
	[2.4955000000E+04, 1.5554281190E+01, 5.1794569374E+00, 3.4281940450E+00, 1.8212939477E+00, 8.6509955077E-01],
	[2.4960000000E+04, 1.5559183487E+01, 5.1793987410E+00, 3.4304055033E+00, 1.8219779763E+00, 8.6516302188E-01],
	[2.4965000000E+04, 1.5564086345E+01, 5.1793405568E+00, 3.4326179440E+00, 1.8226619577E+00, 8.6522646416E-01],
	[2.4970000000E+04, 1.5568989767E+01, 5.1792823849E+00, 3.4348313671E+00, 1.8233458916E+00, 8.6528987774E-01],
	[2.4975000000E+04, 1.5573893751E+01, 5.1792242254E+00, 3.4370457729E+00, 1.8240297779E+00, 8.6535326263E-01],
	[2.4980000000E+04, 1.5578798297E+01, 5.1791660781E+00, 3.4392611617E+00, 1.8247136167E+00, 8.6541661883E-01],
	[2.4985000000E+04, 1.5583703406E+01, 5.1791079432E+00, 3.4414775338E+00, 1.8253974077E+00, 8.6547994636E-01],
	[2.4990000000E+04, 1.5588609078E+01, 5.1790498205E+00, 3.4436948893E+00, 1.8260811508E+00, 8.6554324524E-01],
	[2.4995000000E+04, 1.5593515311E+01, 5.1789917101E+00, 3.4459132284E+00, 1.8267648459E+00, 8.6560651545E-01],
	[2.5000000000E+04, 1.5598422108E+01, 5.1789336119E+00, 3.4481325515E+00, 1.8274484930E+00, 8.6566975703E-01],
	[2.5005000000E+04, 1.5603329466E+01, 5.1788755261E+00, 3.4503587219E+00, 1.8281337379E+00, 8.6573296997E-01],
	[2.5010000000E+04, 1.5608237387E+01, 5.1788174525E+00, 3.4525858832E+00, 1.8288189345E+00, 8.6579615428E-01],
	[2.5015000000E+04, 1.5613145870E+01, 5.1787593911E+00, 3.4548140358E+00, 1.8295040828E+00, 8.6585930998E-01],
	[2.5020000000E+04, 1.5618054915E+01, 5.1787013421E+00, 3.4570431798E+00, 1.8301891827E+00, 8.6592243708E-01],
	[2.5025000000E+04, 1.5622964522E+01, 5.1786433052E+00, 3.4592733155E+00, 1.8308742340E+00, 8.6598553558E-01],
	[2.5030000000E+04, 1.5627874691E+01, 5.1785852806E+00, 3.4615044432E+00, 1.8315592366E+00, 8.6604860550E-01],
	[2.5035000000E+04, 1.5632785422E+01, 5.1785272683E+00, 3.4637365630E+00, 1.8322441904E+00, 8.6611164684E-01],
	[2.5040000000E+04, 1.5637696715E+01, 5.1784692682E+00, 3.4659696752E+00, 1.8329290954E+00, 8.6617465961E-01],
	[2.5045000000E+04, 1.5642608570E+01, 5.1784112803E+00, 3.4682037802E+00, 1.8336139514E+00, 8.6623764383E-01],
	[2.5050000000E+04, 1.5647520987E+01, 5.1783533046E+00, 3.4704388780E+00, 1.8342987583E+00, 8.6630059950E-01],
	[2.5055000000E+04, 1.5652433966E+01, 5.1782953412E+00, 3.4726749690E+00, 1.8349835160E+00, 8.6636352664E-01],
	[2.5060000000E+04, 1.5657347506E+01, 5.1782373900E+00, 3.4749120533E+00, 1.8356682244E+00, 8.6642642524E-01],
	[2.5065000000E+04, 1.5662261609E+01, 5.1781794510E+00, 3.4771501313E+00, 1.8363528834E+00, 8.6648929534E-01],
	[2.5070000000E+04, 1.5667176272E+01, 5.1781215242E+00, 3.4793892032E+00, 1.8370374928E+00, 8.6655213692E-01],
	[2.5075000000E+04, 1.5672091498E+01, 5.1780636095E+00, 3.4816292692E+00, 1.8377220526E+00, 8.6661495000E-01],
	[2.5080000000E+04, 1.5677007285E+01, 5.1780057071E+00, 3.4838703296E+00, 1.8384065627E+00, 8.6667773460E-01],
	[2.5085000000E+04, 1.5681923634E+01, 5.1779478169E+00, 3.4861123846E+00, 1.8390910229E+00, 8.6674049072E-01],
	[2.5090000000E+04, 1.5686843659E+01, 5.1778904824E+00, 3.4883554344E+00, 1.8397755446E+00, 8.6680321837E-01],
	[2.5095000000E+04, 1.5691783261E+01, 5.1778364773E+00, 3.4905994793E+00, 1.8404606970E+00, 8.6686591756E-01],
	[2.5100000000E+04, 1.5696723434E+01, 5.1777824834E+00, 3.4928445196E+00, 1.8411458001E+00, 8.6692858831E-01],
	[2.5105000000E+04, 1.5701664178E+01, 5.1777285008E+00, 3.4950905554E+00, 1.8418308538E+00, 8.6699123061E-01],
	[2.5110000000E+04, 1.5706605492E+01, 5.1776745296E+00, 3.4973375870E+00, 1.8425158579E+00, 8.6705384448E-01],
	[2.5115000000E+04, 1.5711547378E+01, 5.1776205697E+00, 3.4995856147E+00, 1.8432008124E+00, 8.6711642994E-01],
	[2.5120000000E+04, 1.5716489834E+01, 5.1775666210E+00, 3.5018346387E+00, 1.8438857171E+00, 8.6717898699E-01],
	[2.5125000000E+04, 1.5721432860E+01, 5.1775126837E+00, 3.5040846593E+00, 1.8445705719E+00, 8.6724151563E-01],
	[2.5130000000E+04, 1.5726376458E+01, 5.1774587577E+00, 3.5063356766E+00, 1.8452553768E+00, 8.6730401589E-01],
	[2.5135000000E+04, 1.5731320625E+01, 5.1774048429E+00, 3.5085876910E+00, 1.8459401315E+00, 8.6736648776E-01],
	[2.5140000000E+04, 1.5736265364E+01, 5.1773509395E+00, 3.5108407027E+00, 1.8466248361E+00, 8.6742893127E-01],
	[2.5145000000E+04, 1.5741210673E+01, 5.1772970473E+00, 3.5130947118E+00, 1.8473094904E+00, 8.6749134642E-01],
	[2.5150000000E+04, 1.5746156552E+01, 5.1772431664E+00, 3.5153497188E+00, 1.8479940942E+00, 8.6755373321E-01],
	[2.5155000000E+04, 1.5751103001E+01, 5.1771892968E+00, 3.5176057237E+00, 1.8486786476E+00, 8.6761609167E-01],
	[2.5160000000E+04, 1.5756050021E+01, 5.1771354384E+00, 3.5198627269E+00, 1.8493631503E+00, 8.6767842179E-01],
	[2.5165000000E+04, 1.5760997611E+01, 5.1770815913E+00, 3.5221207285E+00, 1.8500476023E+00, 8.6774072359E-01],
	[2.5170000000E+04, 1.5765945771E+01, 5.1770277555E+00, 3.5243797289E+00, 1.8507320035E+00, 8.6780299708E-01],
	[2.5175000000E+04, 1.5770894502E+01, 5.1769739309E+00, 3.5266397283E+00, 1.8514163537E+00, 8.6786524228E-01],
	[2.5180000000E+04, 1.5775843802E+01, 5.1769201175E+00, 3.5289007269E+00, 1.8521006529E+00, 8.6792745918E-01],
	[2.5185000000E+04, 1.5780793673E+01, 5.1768663154E+00, 3.5311627249E+00, 1.8527849010E+00, 8.6798964779E-01],
	[2.5190000000E+04, 1.5785744114E+01, 5.1768125246E+00, 3.5334257227E+00, 1.8534690978E+00, 8.6805180814E-01],
	[2.5195000000E+04, 1.5790695124E+01, 5.1767587450E+00, 3.5356897203E+00, 1.8541532432E+00, 8.6811394023E-01],
	[2.5200000000E+04, 1.5795646705E+01, 5.1767049766E+00, 3.5379547182E+00, 1.8548373371E+00, 8.6817604406E-01],
	[2.5205000000E+04, 1.5800598855E+01, 5.1766512194E+00, 3.5402207165E+00, 1.8555213795E+00, 8.6823811965E-01],
	[2.5210000000E+04, 1.5805551575E+01, 5.1765974735E+00, 3.5424877155E+00, 1.8562053702E+00, 8.6830016701E-01],
	[2.5215000000E+04, 1.5810504865E+01, 5.1765437387E+00, 3.5447557154E+00, 1.8568893091E+00, 8.6836218615E-01],
	[2.5220000000E+04, 1.5815458725E+01, 5.1764900152E+00, 3.5470247164E+00, 1.8575731961E+00, 8.6842417708E-01],
	[2.5225000000E+04, 1.5820413155E+01, 5.1764363029E+00, 3.5492947189E+00, 1.8582570311E+00, 8.6848613981E-01],
	[2.5230000000E+04, 1.5825368154E+01, 5.1763826018E+00, 3.5515657230E+00, 1.8589408140E+00, 8.6854807434E-01],
	[2.5235000000E+04, 1.5830323722E+01, 5.1763289119E+00, 3.5538377289E+00, 1.8596245447E+00, 8.6860998069E-01],
	[2.5240000000E+04, 1.5835279861E+01, 5.1762752332E+00, 3.5561107370E+00, 1.8603082231E+00, 8.6867185887E-01],
	[2.5245000000E+04, 1.5840236568E+01, 5.1762215656E+00, 3.5583847475E+00, 1.8609918491E+00, 8.6873370889E-01],
	[2.5250000000E+04, 1.5845193845E+01, 5.1761679093E+00, 3.5606597606E+00, 1.8616754225E+00, 8.6879553076E-01],
	[2.5255000000E+04, 1.5850151692E+01, 5.1761142641E+00, 3.5629357766E+00, 1.8623589433E+00, 8.6885732448E-01],
	[2.5260000000E+04, 1.5855110108E+01, 5.1760606302E+00, 3.5652127956E+00, 1.8630424114E+00, 8.6891909007E-01],
	[2.5265000000E+04, 1.5860069093E+01, 5.1760070073E+00, 3.5674908180E+00, 1.8637258267E+00, 8.6898082754E-01],
	[2.5270000000E+04, 1.5865028647E+01, 5.1759533957E+00, 3.5697698440E+00, 1.8644091890E+00, 8.6904253690E-01],
	[2.5275000000E+04, 1.5869988771E+01, 5.1758997952E+00, 3.5720498738E+00, 1.8650924982E+00, 8.6910421816E-01],
	[2.5280000000E+04, 1.5874949464E+01, 5.1758462059E+00, 3.5743309077E+00, 1.8657757543E+00, 8.6916587132E-01],
	[2.5285000000E+04, 1.5879910726E+01, 5.1757926277E+00, 3.5766129459E+00, 1.8664589571E+00, 8.6922749640E-01],
	[2.5290000000E+04, 1.5884872557E+01, 5.1757390607E+00, 3.5788959887E+00, 1.8671421066E+00, 8.6928909341E-01],
	[2.5295000000E+04, 1.5889834957E+01, 5.1756855048E+00, 3.5811800362E+00, 1.8678252026E+00, 8.6935066236E-01],
	[2.5300000000E+04, 1.5894797926E+01, 5.1756319600E+00, 3.5834650888E+00, 1.8685082450E+00, 8.6941220326E-01],
	[2.5305000000E+04, 1.5899761464E+01, 5.1755784264E+00, 3.5857511467E+00, 1.8691912338E+00, 8.6947371612E-01],
	[2.5310000000E+04, 1.5904725571E+01, 5.1755249039E+00, 3.5880382101E+00, 1.8698741687E+00, 8.6953520094E-01],
	[2.5315000000E+04, 1.5909690246E+01, 5.1754713926E+00, 3.5903262793E+00, 1.8705570498E+00, 8.6959665774E-01],
	[2.5320000000E+04, 1.5914655491E+01, 5.1754178923E+00, 3.5926153546E+00, 1.8712398769E+00, 8.6965808653E-01],
	[2.5325000000E+04, 1.5919621304E+01, 5.1753644032E+00, 3.5949054360E+00, 1.8719226499E+00, 8.6971948732E-01],
	[2.5330000000E+04, 1.5924587686E+01, 5.1753109252E+00, 3.5971965240E+00, 1.8726053688E+00, 8.6978086012E-01],
	[2.5335000000E+04, 1.5929554637E+01, 5.1752574583E+00, 3.5994886187E+00, 1.8732880333E+00, 8.6984220494E-01],
	[2.5340000000E+04, 1.5934522156E+01, 5.1752040025E+00, 3.6017817204E+00, 1.8739706434E+00, 8.6990352178E-01],
	[2.5345000000E+04, 1.5939490243E+01, 5.1751505578E+00, 3.6040758294E+00, 1.8746531990E+00, 8.6996481067E-01],
	[2.5350000000E+04, 1.5944458899E+01, 5.1750971242E+00, 3.6063709458E+00, 1.8753357000E+00, 8.7002607160E-01],
	[2.5355000000E+04, 1.5949428124E+01, 5.1750437017E+00, 3.6086670699E+00, 1.8760181462E+00, 8.7008730459E-01],
	[2.5360000000E+04, 1.5954397917E+01, 5.1749902903E+00, 3.6109642020E+00, 1.8767005377E+00, 8.7014850965E-01],
	[2.5365000000E+04, 1.5959368279E+01, 5.1749368899E+00, 3.6132623423E+00, 1.8773828742E+00, 8.7020968679E-01],
	[2.5370000000E+04, 1.5964339208E+01, 5.1748835007E+00, 3.6155614910E+00, 1.8780651557E+00, 8.7027083602E-01],
	[2.5375000000E+04, 1.5969310706E+01, 5.1748301225E+00, 3.6178616485E+00, 1.8787473821E+00, 8.7033195735E-01],
	[2.5380000000E+04, 1.5974282772E+01, 5.1747767553E+00, 3.6201628148E+00, 1.8794295532E+00, 8.7039305079E-01],
	[2.5385000000E+04, 1.5979255407E+01, 5.1747233993E+00, 3.6224649904E+00, 1.8801116691E+00, 8.7045411635E-01],
	[2.5390000000E+04, 1.5984228609E+01, 5.1746700543E+00, 3.6247681753E+00, 1.8807937294E+00, 8.7051515404E-01],
	[2.5395000000E+04, 1.5989202380E+01, 5.1746167203E+00, 3.6270723700E+00, 1.8814757343E+00, 8.7057616387E-01],
	[2.5400000000E+04, 1.5994176719E+01, 5.1745633974E+00, 3.6293775745E+00, 1.8821576835E+00, 8.7063714585E-01],
	[2.5405000000E+04, 1.5999151625E+01, 5.1745100855E+00, 3.6316837892E+00, 1.8828395769E+00, 8.7069809999E-01],
	[2.5410000000E+04, 1.6004127100E+01, 5.1744567847E+00, 3.6339910143E+00, 1.8835214145E+00, 8.7075902630E-01],
	[2.5415000000E+04, 1.6009103142E+01, 5.1744034949E+00, 3.6362992500E+00, 1.8842031962E+00, 8.7081992479E-01],
	[2.5420000000E+04, 1.6014079752E+01, 5.1743502162E+00, 3.6386084965E+00, 1.8848849218E+00, 8.7088079547E-01],
	[2.5425000000E+04, 1.6019056931E+01, 5.1742969484E+00, 3.6409187543E+00, 1.8855665912E+00, 8.7094163835E-01],
	[2.5430000000E+04, 1.6024034676E+01, 5.1742436917E+00, 3.6432300233E+00, 1.8862482044E+00, 8.7100245345E-01],
	[2.5435000000E+04, 1.6029012990E+01, 5.1741904461E+00, 3.6455423040E+00, 1.8869297612E+00, 8.7106324076E-01],
	[2.5440000000E+04, 1.6033991871E+01, 5.1741372114E+00, 3.6478555965E+00, 1.8876112616E+00, 8.7112400031E-01],
	[2.5445000000E+04, 1.6038971320E+01, 5.1740839877E+00, 3.6501699012E+00, 1.8882927054E+00, 8.7118473210E-01],
	[2.5450000000E+04, 1.6043951336E+01, 5.1740307751E+00, 3.6524852181E+00, 1.8889740925E+00, 8.7124543614E-01],
	[2.5455000000E+04, 1.6048931920E+01, 5.1739775734E+00, 3.6548015477E+00, 1.8896554229E+00, 8.7130611245E-01],
	[2.5460000000E+04, 1.6053913072E+01, 5.1739243827E+00, 3.6571188901E+00, 1.8903366964E+00, 8.7136676102E-01],
	[2.5465000000E+04, 1.6058894790E+01, 5.1738712031E+00, 3.6594372455E+00, 1.8910179129E+00, 8.7142738188E-01],
	[2.5470000000E+04, 1.6063877077E+01, 5.1738180344E+00, 3.6617566143E+00, 1.8916990724E+00, 8.7148797503E-01],
	[2.5475000000E+04, 1.6068859930E+01, 5.1737648767E+00, 3.6640769966E+00, 1.8923801746E+00, 8.7154854049E-01],
	[2.5480000000E+04, 1.6073843351E+01, 5.1737117300E+00, 3.6663983927E+00, 1.8930612196E+00, 8.7160907826E-01],
	[2.5485000000E+04, 1.6078827339E+01, 5.1736585942E+00, 3.6687208028E+00, 1.8937422073E+00, 8.7166958835E-01],
	[2.5490000000E+04, 1.6083811894E+01, 5.1736054694E+00, 3.6710442273E+00, 1.8944231374E+00, 8.7173007077E-01],
	[2.5495000000E+04, 1.6088804964E+01, 5.1735537214E+00, 3.6733686662E+00, 1.8951043035E+00, 8.7179052554E-01],
	[2.5500000000E+04, 1.6093812733E+01, 5.1735044109E+00, 3.6756941200E+00, 1.8957859342E+00, 8.7185095267E-01],
	[2.5505000000E+04, 1.6098821078E+01, 5.1734551106E+00, 3.6780205887E+00, 1.8964675078E+00, 8.7191135216E-01],
	[2.5510000000E+04, 1.6103829999E+01, 5.1734058204E+00, 3.6803480727E+00, 1.8971490245E+00, 8.7197172402E-01],
	[2.5515000000E+04, 1.6108839497E+01, 5.1733565403E+00, 3.6826765722E+00, 1.8978304840E+00, 8.7203206827E-01],
	[2.5520000000E+04, 1.6113849571E+01, 5.1733072704E+00, 3.6850060875E+00, 1.8985118862E+00, 8.7209238491E-01],
	[2.5525000000E+04, 1.6118860221E+01, 5.1732580106E+00, 3.6873366187E+00, 1.8991932311E+00, 8.7215267396E-01],
	[2.5530000000E+04, 1.6123871448E+01, 5.1732087609E+00, 3.6896681662E+00, 1.8998745185E+00, 8.7221293543E-01],
	[2.5535000000E+04, 1.6128883250E+01, 5.1731595213E+00, 3.6920007302E+00, 1.9005557484E+00, 8.7227316932E-01],
	[2.5540000000E+04, 1.6133895629E+01, 5.1731102918E+00, 3.6943343108E+00, 1.9012369206E+00, 8.7233337565E-01],
	[2.5545000000E+04, 1.6138908584E+01, 5.1730610724E+00, 3.6966689085E+00, 1.9019180351E+00, 8.7239355442E-01],
	[2.5550000000E+04, 1.6143922115E+01, 5.1730118632E+00, 3.6990045233E+00, 1.9025990917E+00, 8.7245370566E-01],
	[2.5555000000E+04, 1.6148936221E+01, 5.1729626640E+00, 3.7013411556E+00, 1.9032800903E+00, 8.7251382936E-01],
	[2.5560000000E+04, 1.6153950904E+01, 5.1729134749E+00, 3.7036788056E+00, 1.9039610309E+00, 8.7257392553E-01],
	[2.5565000000E+04, 1.6158966162E+01, 5.1728642959E+00, 3.7060174735E+00, 1.9046419133E+00, 8.7263399420E-01],
	[2.5570000000E+04, 1.6163981997E+01, 5.1728151270E+00, 3.7083571596E+00, 1.9053227375E+00, 8.7269403536E-01],
	[2.5575000000E+04, 1.6168998407E+01, 5.1727659682E+00, 3.7106978642E+00, 1.9060035033E+00, 8.7275404904E-01],
	[2.5580000000E+04, 1.6174015393E+01, 5.1727168194E+00, 3.7130395873E+00, 1.9066842107E+00, 8.7281403523E-01],
	[2.5585000000E+04, 1.6179032954E+01, 5.1726676807E+00, 3.7153823295E+00, 1.9073648595E+00, 8.7287399395E-01],
	[2.5590000000E+04, 1.6184051092E+01, 5.1726185521E+00, 3.7177260907E+00, 1.9080454497E+00, 8.7293392521E-01],
	[2.5595000000E+04, 1.6189069804E+01, 5.1725694336E+00, 3.7200708714E+00, 1.9087259811E+00, 8.7299382902E-01],
	[2.5600000000E+04, 1.6194089093E+01, 5.1725203251E+00, 3.7224166717E+00, 1.9094064536E+00, 8.7305370539E-01],
	[2.5605000000E+04, 1.6199108957E+01, 5.1724712267E+00, 3.7247634919E+00, 1.9100868672E+00, 8.7311355433E-01],
	[2.5610000000E+04, 1.6204129396E+01, 5.1724221383E+00, 3.7271113322E+00, 1.9107672217E+00, 8.7317337586E-01],
	[2.5615000000E+04, 1.6209150410E+01, 5.1723730600E+00, 3.7294601929E+00, 1.9114475171E+00, 8.7323316997E-01],
	[2.5620000000E+04, 1.6214172001E+01, 5.1723239917E+00, 3.7318100742E+00, 1.9121277532E+00, 8.7329293669E-01],
	[2.5625000000E+04, 1.6219194166E+01, 5.1722749335E+00, 3.7341609763E+00, 1.9128079300E+00, 8.7335267601E-01],
	[2.5630000000E+04, 1.6224216907E+01, 5.1722258853E+00, 3.7365128996E+00, 1.9134880474E+00, 8.7341238796E-01],
	[2.5635000000E+04, 1.6229240222E+01, 5.1721768471E+00, 3.7388658442E+00, 1.9141681051E+00, 8.7347207255E-01],
	[2.5640000000E+04, 1.6234264113E+01, 5.1721278189E+00, 3.7412198104E+00, 1.9148481033E+00, 8.7353172977E-01],
	[2.5645000000E+04, 1.6239288580E+01, 5.1720788008E+00, 3.7435747984E+00, 1.9155280416E+00, 8.7359135965E-01],
	[2.5650000000E+04, 1.6244313621E+01, 5.1720297927E+00, 3.7459308086E+00, 1.9162079202E+00, 8.7365096220E-01],
	[2.5655000000E+04, 1.6249339237E+01, 5.1719807946E+00, 3.7482878410E+00, 1.9168877388E+00, 8.7371053742E-01],
	[2.5660000000E+04, 1.6254365428E+01, 5.1719318066E+00, 3.7506458960E+00, 1.9175674973E+00, 8.7377008532E-01],
	[2.5665000000E+04, 1.6259392194E+01, 5.1718828285E+00, 3.7530049738E+00, 1.9182471957E+00, 8.7382960592E-01],
	[2.5670000000E+04, 1.6264419536E+01, 5.1718338605E+00, 3.7553650747E+00, 1.9189268339E+00, 8.7388909922E-01],
	[2.5675000000E+04, 1.6269447452E+01, 5.1717849024E+00, 3.7577261989E+00, 1.9196064117E+00, 8.7394856524E-01],
	[2.5680000000E+04, 1.6274475942E+01, 5.1717359543E+00, 3.7600883466E+00, 1.9202859291E+00, 8.7400800399E-01],
	[2.5685000000E+04, 1.6279505008E+01, 5.1716870163E+00, 3.7624515181E+00, 1.9209653860E+00, 8.7406741548E-01],
	[2.5690000000E+04, 1.6284534648E+01, 5.1716380882E+00, 3.7648157136E+00, 1.9216447822E+00, 8.7412679971E-01],
	[2.5695000000E+04, 1.6289564863E+01, 5.1715891701E+00, 3.7671809334E+00, 1.9223241177E+00, 8.7418615669E-01],
	[2.5700000000E+04, 1.6294595652E+01, 5.1715402620E+00, 3.7695471777E+00, 1.9230033923E+00, 8.7424548645E-01],
	[2.5705000000E+04, 1.6299627016E+01, 5.1714913639E+00, 3.7719144467E+00, 1.9236826061E+00, 8.7430478899E-01],
	[2.5710000000E+04, 1.6304658955E+01, 5.1714424757E+00, 3.7742827408E+00, 1.9243617588E+00, 8.7436406431E-01],
	[2.5715000000E+04, 1.6309691468E+01, 5.1713935975E+00, 3.7766520601E+00, 1.9250408504E+00, 8.7442331243E-01],
	[2.5720000000E+04, 1.6314724556E+01, 5.1713447293E+00, 3.7790224050E+00, 1.9257198808E+00, 8.7448253337E-01],
	[2.5725000000E+04, 1.6319758218E+01, 5.1712958710E+00, 3.7813937755E+00, 1.9263988498E+00, 8.7454172712E-01],
	[2.5730000000E+04, 1.6324792454E+01, 5.1712470227E+00, 3.7837661720E+00, 1.9270777574E+00, 8.7460089371E-01],
	[2.5735000000E+04, 1.6329827264E+01, 5.1711981843E+00, 3.7861395948E+00, 1.9277566036E+00, 8.7466003313E-01],
	[2.5740000000E+04, 1.6334862649E+01, 5.1711493559E+00, 3.7885140440E+00, 1.9284353881E+00, 8.7471914541E-01],
	[2.5745000000E+04, 1.6339898608E+01, 5.1711005375E+00, 3.7908895199E+00, 1.9291141109E+00, 8.7477823055E-01],
	[2.5750000000E+04, 1.6344935141E+01, 5.1710517289E+00, 3.7932660228E+00, 1.9297927719E+00, 8.7483728856E-01],
	[2.5755000000E+04, 1.6349972249E+01, 5.1710029303E+00, 3.7956435529E+00, 1.9304713710E+00, 8.7489631946E-01],
	[2.5760000000E+04, 1.6355009930E+01, 5.1709541417E+00, 3.7980221104E+00, 1.9311499081E+00, 8.7495532324E-01],
	[2.5765000000E+04, 1.6360048185E+01, 5.1709053630E+00, 3.8004016956E+00, 1.9318283831E+00, 8.7501429994E-01],
	[2.5770000000E+04, 1.6365087015E+01, 5.1708565942E+00, 3.8027823087E+00, 1.9325067959E+00, 8.7507324954E-01],
	[2.5775000000E+04, 1.6370126418E+01, 5.1708078353E+00, 3.8051639500E+00, 1.9331851465E+00, 8.7513217208E-01],
	[2.5780000000E+04, 1.6375166395E+01, 5.1707590863E+00, 3.8075466198E+00, 1.9338634346E+00, 8.7519106754E-01],
	[2.5785000000E+04, 1.6380206946E+01, 5.1707103473E+00, 3.8099303182E+00, 1.9345416603E+00, 8.7524993596E-01],
	[2.5790000000E+04, 1.6385248071E+01, 5.1706616181E+00, 3.8123150455E+00, 1.9352198233E+00, 8.7530877733E-01],
	[2.5795000000E+04, 1.6390289769E+01, 5.1706128989E+00, 3.8147008019E+00, 1.9358979238E+00, 8.7536759166E-01],
	[2.5800000000E+04, 1.6395332042E+01, 5.1705641896E+00, 3.8170875878E+00, 1.9365759614E+00, 8.7542637898E-01],
	[2.5805000000E+04, 1.6400374888E+01, 5.1705154901E+00, 3.8194754032E+00, 1.9372539362E+00, 8.7548513928E-01],
	[2.5810000000E+04, 1.6405418307E+01, 5.1704668006E+00, 3.8218642486E+00, 1.9379318480E+00, 8.7554387258E-01],
	[2.5815000000E+04, 1.6410462300E+01, 5.1704181209E+00, 3.8242541241E+00, 1.9386096967E+00, 8.7560257889E-01],
	[2.5820000000E+04, 1.6415506867E+01, 5.1703694512E+00, 3.8266450300E+00, 1.9392874823E+00, 8.7566125822E-01],
	[2.5825000000E+04, 1.6420552007E+01, 5.1703207913E+00, 3.8290369664E+00, 1.9399652047E+00, 8.7571991058E-01],
	[2.5830000000E+04, 1.6425597720E+01, 5.1702721413E+00, 3.8314299338E+00, 1.9406428637E+00, 8.7577853598E-01],
	[2.5835000000E+04, 1.6430644007E+01, 5.1702235012E+00, 3.8338239322E+00, 1.9413204592E+00, 8.7583713443E-01],
	[2.5840000000E+04, 1.6435690867E+01, 5.1701748709E+00, 3.8362189620E+00, 1.9419979912E+00, 8.7589570594E-01],
	[2.5845000000E+04, 1.6440738301E+01, 5.1701262505E+00, 3.8386150234E+00, 1.9426754596E+00, 8.7595425052E-01],
	[2.5850000000E+04, 1.6445786307E+01, 5.1700776400E+00, 3.8410121166E+00, 1.9433528643E+00, 8.7601276819E-01],
	[2.5855000000E+04, 1.6450834887E+01, 5.1700290393E+00, 3.8434102419E+00, 1.9440302051E+00, 8.7607125895E-01],
	[2.5860000000E+04, 1.6455884040E+01, 5.1699804485E+00, 3.8458093995E+00, 1.9447074820E+00, 8.7612972281E-01],
	[2.5865000000E+04, 1.6460933766E+01, 5.1699318675E+00, 3.8482095896E+00, 1.9453846949E+00, 8.7618815979E-01],
	[2.5870000000E+04, 1.6465984065E+01, 5.1698832964E+00, 3.8506108126E+00, 1.9460618437E+00, 8.7624656989E-01],
	[2.5875000000E+04, 1.6471034938E+01, 5.1698347351E+00, 3.8530130687E+00, 1.9467389282E+00, 8.7630495313E-01],
	[2.5880000000E+04, 1.6476086383E+01, 5.1697861837E+00, 3.8554163580E+00, 1.9474159485E+00, 8.7636330952E-01],
	[2.5885000000E+04, 1.6481138401E+01, 5.1697376421E+00, 3.8578206809E+00, 1.9480929044E+00, 8.7642163906E-01],
	[2.5890000000E+04, 1.6486190992E+01, 5.1696891103E+00, 3.8602260376E+00, 1.9487697958E+00, 8.7647994177E-01],
	[2.5895000000E+04, 1.6491244156E+01, 5.1696405884E+00, 3.8626324283E+00, 1.9494466225E+00, 8.7653821765E-01],
	[2.5900000000E+04, 1.6496297892E+01, 5.1695920762E+00, 3.8650398533E+00, 1.9501233847E+00, 8.7659646672E-01],
	[2.5905000000E+04, 1.6501358335E+01, 5.1695446130E+00, 3.8674483128E+00, 1.9508003157E+00, 8.7665468900E-01],
	[2.5910000000E+04, 1.6506435211E+01, 5.1694998454E+00, 3.8698578071E+00, 1.9514777865E+00, 8.7671288448E-01],
	[2.5915000000E+04, 1.6511512670E+01, 5.1694550868E+00, 3.8722683364E+00, 1.9521551932E+00, 8.7677105318E-01],
	[2.5920000000E+04, 1.6516590711E+01, 5.1694103372E+00, 3.8746799009E+00, 1.9528325356E+00, 8.7682919511E-01],
	[2.5925000000E+04, 1.6521669333E+01, 5.1693655967E+00, 3.8770925009E+00, 1.9535098138E+00, 8.7688731029E-01],
	[2.5930000000E+04, 1.6526748537E+01, 5.1693208652E+00, 3.8795061367E+00, 1.9541870275E+00, 8.7694539871E-01],
	[2.5935000000E+04, 1.6531828323E+01, 5.1692761426E+00, 3.8819208085E+00, 1.9548641766E+00, 8.7700346040E-01],
	[2.5940000000E+04, 1.6536908691E+01, 5.1692314291E+00, 3.8843365165E+00, 1.9555412612E+00, 8.7706149536E-01],
	[2.5945000000E+04, 1.6541989640E+01, 5.1691867246E+00, 3.8867532609E+00, 1.9562182810E+00, 8.7711950360E-01],
	[2.5950000000E+04, 1.6547071171E+01, 5.1691420291E+00, 3.8891710421E+00, 1.9568952361E+00, 8.7717748514E-01],
	[2.5955000000E+04, 1.6552153283E+01, 5.1690973426E+00, 3.8915898603E+00, 1.9575721262E+00, 8.7723543998E-01],
	[2.5960000000E+04, 1.6557235977E+01, 5.1690526651E+00, 3.8940097156E+00, 1.9582489514E+00, 8.7729336814E-01],
	[2.5965000000E+04, 1.6562319252E+01, 5.1690079966E+00, 3.8964306085E+00, 1.9589257115E+00, 8.7735126962E-01],
	[2.5970000000E+04, 1.6567403109E+01, 5.1689633370E+00, 3.8988525390E+00, 1.9596024064E+00, 8.7740914444E-01],
	[2.5975000000E+04, 1.6572487547E+01, 5.1689186865E+00, 3.9012755074E+00, 1.9602790360E+00, 8.7746699261E-01],
	[2.5980000000E+04, 1.6577572566E+01, 5.1688740449E+00, 3.9036995141E+00, 1.9609556003E+00, 8.7752481413E-01],
	[2.5985000000E+04, 1.6582658167E+01, 5.1688294123E+00, 3.9061245591E+00, 1.9616320991E+00, 8.7758260902E-01],
	[2.5990000000E+04, 1.6587744349E+01, 5.1687847887E+00, 3.9085506429E+00, 1.9623085324E+00, 8.7764037730E-01],
	[2.5995000000E+04, 1.6592831112E+01, 5.1687401740E+00, 3.9109777655E+00, 1.9629849000E+00, 8.7769811896E-01],
	[2.6000000000E+04, 1.6597918456E+01, 5.1686955683E+00, 3.9134059274E+00, 1.9636612019E+00, 8.7775583402E-01],
	[2.6005000000E+04, 1.6603006381E+01, 5.1686509716E+00, 3.9158351286E+00, 1.9643374380E+00, 8.7781352249E-01],
	[2.6010000000E+04, 1.6608094887E+01, 5.1686063838E+00, 3.9182653695E+00, 1.9650136081E+00, 8.7787118439E-01],
	[2.6015000000E+04, 1.6613183975E+01, 5.1685618050E+00, 3.9206966503E+00, 1.9656897123E+00, 8.7792881971E-01],
	[2.6020000000E+04, 1.6618273643E+01, 5.1685172351E+00, 3.9231289712E+00, 1.9663657503E+00, 8.7798642848E-01],
	[2.6025000000E+04, 1.6623363892E+01, 5.1684726742E+00, 3.9255623325E+00, 1.9670417221E+00, 8.7804401070E-01],
	[2.6030000000E+04, 1.6628454722E+01, 5.1684281222E+00, 3.9279967344E+00, 1.9677176276E+00, 8.7810156639E-01],
	[2.6035000000E+04, 1.6633546133E+01, 5.1683835792E+00, 3.9304321772E+00, 1.9683934668E+00, 8.7815909555E-01],
	[2.6040000000E+04, 1.6638638124E+01, 5.1683390451E+00, 3.9328686612E+00, 1.9690692394E+00, 8.7821659820E-01],
	[2.6045000000E+04, 1.6643730696E+01, 5.1682945200E+00, 3.9353061865E+00, 1.9697449455E+00, 8.7827407434E-01],
	[2.6050000000E+04, 1.6648823849E+01, 5.1682500037E+00, 3.9377447534E+00, 1.9704205850E+00, 8.7833152399E-01],
	[2.6055000000E+04, 1.6653917583E+01, 5.1682054964E+00, 3.9401843621E+00, 1.9710961576E+00, 8.7838894716E-01],
	[2.6060000000E+04, 1.6659011897E+01, 5.1681609980E+00, 3.9426250130E+00, 1.9717716635E+00, 8.7844634385E-01],
	[2.6065000000E+04, 1.6664106792E+01, 5.1681165086E+00, 3.9450667062E+00, 1.9724471023E+00, 8.7850371408E-01],
	[2.6070000000E+04, 1.6669202267E+01, 5.1680720280E+00, 3.9475094419E+00, 1.9731224742E+00, 8.7856105787E-01],
	[2.6075000000E+04, 1.6674298323E+01, 5.1680275564E+00, 3.9499532206E+00, 1.9737977789E+00, 8.7861837518E-01],
	[2.6080000000E+04, 1.6679394959E+01, 5.1679830937E+00, 3.9523980422E+00, 1.9744730164E+00, 8.7867566601E-01],
	[2.6085000000E+04, 1.6684492175E+01, 5.1679386399E+00, 3.9548439072E+00, 1.9751481867E+00, 8.7873293035E-01],
	[2.6090000000E+04, 1.6689589972E+01, 5.1678941950E+00, 3.9572908158E+00, 1.9758232895E+00, 8.7879016821E-01],
	[2.6095000000E+04, 1.6694688349E+01, 5.1678497590E+00, 3.9597387682E+00, 1.9764983248E+00, 8.7884737961E-01],
	[2.6100000000E+04, 1.6699787306E+01, 5.1678053318E+00, 3.9621877646E+00, 1.9771732925E+00, 8.7890456455E-01],
	[2.6105000000E+04, 1.6704886843E+01, 5.1677609136E+00, 3.9646378054E+00, 1.9778481926E+00, 8.7896172305E-01],
	[2.6110000000E+04, 1.6709986961E+01, 5.1677165043E+00, 3.9670888906E+00, 1.9785230249E+00, 8.7901885510E-01],
	[2.6115000000E+04, 1.6715087658E+01, 5.1676721038E+00, 3.9695410207E+00, 1.9791977894E+00, 8.7907596072E-01],
	[2.6120000000E+04, 1.6720188936E+01, 5.1676277122E+00, 3.9719941958E+00, 1.9798724859E+00, 8.7913303992E-01],
	[2.6125000000E+04, 1.6725290793E+01, 5.1675833296E+00, 3.9744484162E+00, 1.9805471143E+00, 8.7919009271E-01],
	[2.6130000000E+04, 1.6730393231E+01, 5.1675389557E+00, 3.9769036821E+00, 1.9812216746E+00, 8.7924711909E-01],
	[2.6135000000E+04, 1.6735496248E+01, 5.1674945908E+00, 3.9793599937E+00, 1.9818961668E+00, 8.7930411907E-01],
	[2.6140000000E+04, 1.6740599846E+01, 5.1674502347E+00, 3.9818173514E+00, 1.9825705906E+00, 8.7936109267E-01],
	[2.6145000000E+04, 1.6745704023E+01, 5.1674058875E+00, 3.9842757553E+00, 1.9832449460E+00, 8.7941803989E-01],
	[2.6150000000E+04, 1.6750808780E+01, 5.1673615491E+00, 3.9867352058E+00, 1.9839192329E+00, 8.7947496074E-01],
	[2.6155000000E+04, 1.6755914117E+01, 5.1673172196E+00, 3.9891957029E+00, 1.9845934512E+00, 8.7953185523E-01],
	[2.6160000000E+04, 1.6761020033E+01, 5.1672728990E+00, 3.9916572471E+00, 1.9852676009E+00, 8.7958872337E-01],
	[2.6165000000E+04, 1.6766126529E+01, 5.1672285872E+00, 3.9941198385E+00, 1.9859416817E+00, 8.7964556517E-01],
	[2.6170000000E+04, 1.6771233604E+01, 5.1671842843E+00, 3.9965834774E+00, 1.9866156938E+00, 8.7970238063E-01],
	[2.6175000000E+04, 1.6776341260E+01, 5.1671399901E+00, 3.9990481640E+00, 1.9872896369E+00, 8.7975916977E-01],
	[2.6180000000E+04, 1.6781449494E+01, 5.1670957049E+00, 4.0015138986E+00, 1.9879635109E+00, 8.7981593259E-01],
	[2.6185000000E+04, 1.6786558308E+01, 5.1670514285E+00, 4.0039806814E+00, 1.9886373158E+00, 8.7987266910E-01],
	[2.6190000000E+04, 1.6791667702E+01, 5.1670071609E+00, 4.0064485126E+00, 1.9893110516E+00, 8.7992937932E-01],
	[2.6195000000E+04, 1.6796777675E+01, 5.1669629021E+00, 4.0089173926E+00, 1.9899847180E+00, 8.7998606324E-01],
	[2.6200000000E+04, 1.6801888227E+01, 5.1669186522E+00, 4.0113873215E+00, 1.9906583150E+00, 8.8004272089E-01],
	[2.6205000000E+04, 1.6806999358E+01, 5.1668744110E+00, 4.0138582996E+00, 1.9913318425E+00, 8.8009935226E-01],
	[2.6210000000E+04, 1.6812111069E+01, 5.1668301787E+00, 4.0163303271E+00, 1.9920053005E+00, 8.8015595738E-01],
	[2.6215000000E+04, 1.6817223359E+01, 5.1667859553E+00, 4.0188034043E+00, 1.9926786887E+00, 8.8021253623E-01],
	[2.6220000000E+04, 1.6822336228E+01, 5.1667417406E+00, 4.0212775314E+00, 1.9933520073E+00, 8.8026908885E-01],
	[2.6225000000E+04, 1.6827449676E+01, 5.1666975347E+00, 4.0237527088E+00, 1.9940252560E+00, 8.8032561523E-01],
	[2.6230000000E+04, 1.6832563703E+01, 5.1666533377E+00, 4.0262289365E+00, 1.9946984347E+00, 8.8038211538E-01],
	[2.6235000000E+04, 1.6837678309E+01, 5.1666091494E+00, 4.0287062149E+00, 1.9953715435E+00, 8.8043858931E-01],
	[2.6240000000E+04, 1.6842793494E+01, 5.1665649700E+00, 4.0311845442E+00, 1.9960445821E+00, 8.8049503704E-01],
	[2.6245000000E+04, 1.6847909258E+01, 5.1665207993E+00, 4.0336639247E+00, 1.9967175505E+00, 8.8055145856E-01],
	[2.6250000000E+04, 1.6853025601E+01, 5.1664766375E+00, 4.0361443565E+00, 1.9973904486E+00, 8.8060785390E-01],
	[2.6255000000E+04, 1.6858142523E+01, 5.1664324844E+00, 4.0386258400E+00, 1.9980632764E+00, 8.8066422305E-01],
	[2.6260000000E+04, 1.6863260024E+01, 5.1663883401E+00, 4.0411083754E+00, 1.9987360337E+00, 8.8072056603E-01],
	[2.6265000000E+04, 1.6868378103E+01, 5.1663442046E+00, 4.0435919629E+00, 1.9994087204E+00, 8.8077688285E-01],
	[2.6270000000E+04, 1.6873496761E+01, 5.1663000778E+00, 4.0460766028E+00, 2.0000813365E+00, 8.8083317351E-01],
	[2.6275000000E+04, 1.6878615998E+01, 5.1662559599E+00, 4.0485622953E+00, 2.0007538818E+00, 8.8088943803E-01],
	[2.6280000000E+04, 1.6883735813E+01, 5.1662118507E+00, 4.0510490407E+00, 2.0014263564E+00, 8.8094567641E-01],
	[2.6285000000E+04, 1.6888856207E+01, 5.1661677503E+00, 4.0535368392E+00, 2.0020987600E+00, 8.8100188866E-01],
	[2.6290000000E+04, 1.6893977179E+01, 5.1661236586E+00, 4.0560256911E+00, 2.0027710926E+00, 8.8105807480E-01],
	[2.6295000000E+04, 1.6899098730E+01, 5.1660795757E+00, 4.0585155965E+00, 2.0034433541E+00, 8.8111423482E-01],
	[2.6300000000E+04, 1.6904220859E+01, 5.1660355016E+00, 4.0610065558E+00, 2.0041155445E+00, 8.8117036875E-01],
	[2.6305000000E+04, 1.6909343567E+01, 5.1659914362E+00, 4.0634985692E+00, 2.0047876636E+00, 8.8122647658E-01],
	[2.6310000000E+04, 1.6914466853E+01, 5.1659473796E+00, 4.0659916369E+00, 2.0054597113E+00, 8.8128255833E-01],
	[2.6315000000E+04, 1.6919590717E+01, 5.1659033317E+00, 4.0684857593E+00, 2.0061316876E+00, 8.8133861401E-01],
	[2.6320000000E+04, 1.6924715159E+01, 5.1658592925E+00, 4.0709809364E+00, 2.0068035923E+00, 8.8139464363E-01],
	[2.6325000000E+04, 1.6929859378E+01, 5.1658184687E+00, 4.0734771686E+00, 2.0074761797E+00, 8.8145064719E-01],
	[2.6330000000E+04, 1.6935006893E+01, 5.1657781053E+00, 4.0759744562E+00, 2.0081488025E+00, 8.8150662470E-01],
	[2.6335000000E+04, 1.6940154995E+01, 5.1657377499E+00, 4.0784727993E+00, 2.0088213543E+00, 8.8156257618E-01],
	[2.6340000000E+04, 1.6945303684E+01, 5.1656974025E+00, 4.0809721982E+00, 2.0094938350E+00, 8.8161850163E-01],
	[2.6345000000E+04, 1.6950452960E+01, 5.1656570630E+00, 4.0834726531E+00, 2.0101662446E+00, 8.8167440106E-01],
	[2.6350000000E+04, 1.6955602823E+01, 5.1656167315E+00, 4.0859741644E+00, 2.0108385829E+00, 8.8173027448E-01],
	[2.6355000000E+04, 1.6960753274E+01, 5.1655764080E+00, 4.0884767322E+00, 2.0115108499E+00, 8.8178612191E-01],
	[2.6360000000E+04, 1.6965904311E+01, 5.1655360924E+00, 4.0909803568E+00, 2.0121830455E+00, 8.8184194334E-01],
	[2.6365000000E+04, 1.6971055935E+01, 5.1654957848E+00, 4.0934850384E+00, 2.0128551696E+00, 8.8189773879E-01],
	[2.6370000000E+04, 1.6976208146E+01, 5.1654554851E+00, 4.0959907773E+00, 2.0135272220E+00, 8.8195350826E-01],
	[2.6375000000E+04, 1.6981360945E+01, 5.1654151934E+00, 4.0984975737E+00, 2.0141992028E+00, 8.8200925178E-01],
	[2.6380000000E+04, 1.6986514330E+01, 5.1653749097E+00, 4.1010054279E+00, 2.0148711119E+00, 8.8206496934E-01],
	[2.6385000000E+04, 1.6991668301E+01, 5.1653346339E+00, 4.1035143401E+00, 2.0155429491E+00, 8.8212066095E-01],
	[2.6390000000E+04, 1.6996822860E+01, 5.1652943660E+00, 4.1060243106E+00, 2.0162147143E+00, 8.8217632663E-01],
	[2.6395000000E+04, 1.7001978005E+01, 5.1652541061E+00, 4.1085353396E+00, 2.0168864075E+00, 8.8223196638E-01],
	[2.6400000000E+04, 1.7007133737E+01, 5.1652138542E+00, 4.1110474273E+00, 2.0175580286E+00, 8.8228758022E-01],
	[2.6405000000E+04, 1.7012290056E+01, 5.1651736101E+00, 4.1135605740E+00, 2.0182295775E+00, 8.8234316815E-01],
	[2.6410000000E+04, 1.7017446961E+01, 5.1651333740E+00, 4.1160747800E+00, 2.0189010541E+00, 8.8239873017E-01],
	[2.6415000000E+04, 1.7022604453E+01, 5.1650931459E+00, 4.1185900454E+00, 2.0195724583E+00, 8.8245426631E-01],
	[2.6420000000E+04, 1.7027762531E+01, 5.1650529256E+00, 4.1211063706E+00, 2.0202437901E+00, 8.8250977657E-01],
	[2.6425000000E+04, 1.7032921195E+01, 5.1650127133E+00, 4.1236237558E+00, 2.0209150493E+00, 8.8256526096E-01],
	[2.6430000000E+04, 1.7038080446E+01, 5.1649725089E+00, 4.1261422011E+00, 2.0215862359E+00, 8.8262071948E-01],
	[2.6435000000E+04, 1.7043240284E+01, 5.1649323124E+00, 4.1286617070E+00, 2.0222573498E+00, 8.8267615215E-01],
	[2.6440000000E+04, 1.7048400707E+01, 5.1648921239E+00, 4.1311822735E+00, 2.0229283908E+00, 8.8273155898E-01],
	[2.6445000000E+04, 1.7053561717E+01, 5.1648519432E+00, 4.1337039011E+00, 2.0235993590E+00, 8.8278693997E-01],
	[2.6450000000E+04, 1.7058723314E+01, 5.1648117705E+00, 4.1362265898E+00, 2.0242702542E+00, 8.8284229514E-01],
	[2.6455000000E+04, 1.7063885496E+01, 5.1647716056E+00, 4.1387503399E+00, 2.0249410763E+00, 8.8289762449E-01],
	[2.6460000000E+04, 1.7069048264E+01, 5.1647314487E+00, 4.1412751518E+00, 2.0256118253E+00, 8.8295292804E-01],
	[2.6465000000E+04, 1.7074211619E+01, 5.1646912997E+00, 4.1438010256E+00, 2.0262825010E+00, 8.8300820579E-01],
	[2.6470000000E+04, 1.7079375560E+01, 5.1646511585E+00, 4.1463279616E+00, 2.0269531034E+00, 8.8306345775E-01],
	[2.6475000000E+04, 1.7084540086E+01, 5.1646110253E+00, 4.1488559600E+00, 2.0276236324E+00, 8.8311868393E-01],
	[2.6480000000E+04, 1.7089705199E+01, 5.1645708999E+00, 4.1513850211E+00, 2.0282940879E+00, 8.8317388435E-01],
	[2.6485000000E+04, 1.7094870897E+01, 5.1645307825E+00, 4.1539151451E+00, 2.0289644699E+00, 8.8322905900E-01],
	[2.6490000000E+04, 1.7100037182E+01, 5.1644906729E+00, 4.1564463323E+00, 2.0296347782E+00, 8.8328420790E-01],
	[2.6495000000E+04, 1.7105204052E+01, 5.1644505712E+00, 4.1589785829E+00, 2.0303050127E+00, 8.8333933106E-01],
	[2.6500000000E+04, 1.7110371508E+01, 5.1644104774E+00, 4.1615118971E+00, 2.0309751734E+00, 8.8339442849E-01],
	[2.6505000000E+04, 1.7115539550E+01, 5.1643703914E+00, 4.1640462753E+00, 2.0316452601E+00, 8.8344950020E-01],
	[2.6510000000E+04, 1.7120708177E+01, 5.1643303133E+00, 4.1665817176E+00, 2.0323152729E+00, 8.8350454619E-01],
	[2.6515000000E+04, 1.7125877390E+01, 5.1642902431E+00, 4.1691182243E+00, 2.0329852116E+00, 8.8355956648E-01],
	[2.6520000000E+04, 1.7131047189E+01, 5.1642501808E+00, 4.1716557956E+00, 2.0336550761E+00, 8.8361456108E-01],
	[2.6525000000E+04, 1.7136217573E+01, 5.1642101263E+00, 4.1741944318E+00, 2.0343248664E+00, 8.8366952999E-01],
	[2.6530000000E+04, 1.7141388543E+01, 5.1641700797E+00, 4.1767341332E+00, 2.0349945823E+00, 8.8372447322E-01],
	[2.6535000000E+04, 1.7146560098E+01, 5.1641300409E+00, 4.1792748999E+00, 2.0356642237E+00, 8.8377939079E-01],
	[2.6540000000E+04, 1.7151732239E+01, 5.1640900100E+00, 4.1818167322E+00, 2.0363337907E+00, 8.8383428270E-01],
	[2.6545000000E+04, 1.7156904965E+01, 5.1640499870E+00, 4.1843596304E+00, 2.0370032831E+00, 8.8388914896E-01],
	[2.6550000000E+04, 1.7162078277E+01, 5.1640099718E+00, 4.1869035947E+00, 2.0376727008E+00, 8.8394398958E-01],
	[2.6555000000E+04, 1.7167252173E+01, 5.1639699644E+00, 4.1894486254E+00, 2.0383420437E+00, 8.8399880458E-01],
	[2.6560000000E+04, 1.7172426655E+01, 5.1639299649E+00, 4.1919947227E+00, 2.0390113118E+00, 8.8405359395E-01],
	[2.6565000000E+04, 1.7177601722E+01, 5.1638899732E+00, 4.1945418868E+00, 2.0396805049E+00, 8.8410835772E-01],
	[2.6570000000E+04, 1.7182777375E+01, 5.1638499894E+00, 4.1970901181E+00, 2.0403496230E+00, 8.8416309588E-01],
	[2.6575000000E+04, 1.7187953612E+01, 5.1638100134E+00, 4.1996394166E+00, 2.0410186660E+00, 8.8421780845E-01],
	[2.6580000000E+04, 1.7193130435E+01, 5.1637700452E+00, 4.2021897828E+00, 2.0416876339E+00, 8.8427249544E-01],
	[2.6585000000E+04, 1.7198307842E+01, 5.1637300848E+00, 4.2047412168E+00, 2.0423565265E+00, 8.8432715686E-01],
	[2.6590000000E+04, 1.7203485835E+01, 5.1636901323E+00, 4.2072937188E+00, 2.0430253437E+00, 8.8438179272E-01],
	[2.6595000000E+04, 1.7208664412E+01, 5.1636501876E+00, 4.2098472892E+00, 2.0436940854E+00, 8.8443640302E-01],
	[2.6600000000E+04, 1.7213843575E+01, 5.1636102507E+00, 4.2124019281E+00, 2.0443627517E+00, 8.8449098777E-01],
	[2.6605000000E+04, 1.7219023322E+01, 5.1635703216E+00, 4.2149576359E+00, 2.0450313424E+00, 8.8454554700E-01],
	[2.6610000000E+04, 1.7224203654E+01, 5.1635304004E+00, 4.2175144127E+00, 2.0456998573E+00, 8.8460008069E-01],
	[2.6615000000E+04, 1.7229384571E+01, 5.1634904869E+00, 4.2200722589E+00, 2.0463682965E+00, 8.8465458887E-01],
	[2.6620000000E+04, 1.7234566073E+01, 5.1634505813E+00, 4.2226311745E+00, 2.0470366599E+00, 8.8470907155E-01],
	[2.6625000000E+04, 1.7239748159E+01, 5.1634106834E+00, 4.2251911600E+00, 2.0477049473E+00, 8.8476352873E-01],
	[2.6630000000E+04, 1.7244930830E+01, 5.1633707934E+00, 4.2277522155E+00, 2.0483731587E+00, 8.8481796042E-01],
	[2.6635000000E+04, 1.7250114085E+01, 5.1633309111E+00, 4.2303143413E+00, 2.0490412939E+00, 8.8487236663E-01],
	[2.6640000000E+04, 1.7255297925E+01, 5.1632910367E+00, 4.2328775377E+00, 2.0497093530E+00, 8.8492674737E-01],
	[2.6645000000E+04, 1.7260482350E+01, 5.1632511700E+00, 4.2354418048E+00, 2.0503773359E+00, 8.8498110266E-01],
	[2.6650000000E+04, 1.7265667359E+01, 5.1632113111E+00, 4.2380071429E+00, 2.0510452423E+00, 8.8503543249E-01],
	[2.6655000000E+04, 1.7270852952E+01, 5.1631714600E+00, 4.2405735523E+00, 2.0517130724E+00, 8.8508973689E-01],
	[2.6660000000E+04, 1.7276039130E+01, 5.1631316167E+00, 4.2431410333E+00, 2.0523808259E+00, 8.8514401585E-01],
	[2.6665000000E+04, 1.7281225892E+01, 5.1630917812E+00, 4.2457095860E+00, 2.0530485028E+00, 8.8519826939E-01],
	[2.6670000000E+04, 1.7286413239E+01, 5.1630519535E+00, 4.2482792107E+00, 2.0537161031E+00, 8.8525249753E-01],
	[2.6675000000E+04, 1.7291601170E+01, 5.1630121335E+00, 4.2508499076E+00, 2.0543836266E+00, 8.8530670026E-01],
	[2.6680000000E+04, 1.7296789684E+01, 5.1629723213E+00, 4.2534216771E+00, 2.0550510732E+00, 8.8536087759E-01],
	[2.6685000000E+04, 1.7301978783E+01, 5.1629325168E+00, 4.2559945193E+00, 2.0557184429E+00, 8.8541502955E-01],
	[2.6690000000E+04, 1.7307168467E+01, 5.1628927202E+00, 4.2585684345E+00, 2.0563857356E+00, 8.8546915613E-01],
	[2.6695000000E+04, 1.7312358734E+01, 5.1628529312E+00, 4.2611434229E+00, 2.0570529512E+00, 8.8552325735E-01],
	[2.6700000000E+04, 1.7317549585E+01, 5.1628131501E+00, 4.2637194848E+00, 2.0577200896E+00, 8.8557733321E-01],
	[2.6705000000E+04, 1.7322741020E+01, 5.1627733767E+00, 4.2662966204E+00, 2.0583871508E+00, 8.8563138373E-01],
	[2.6710000000E+04, 1.7327933040E+01, 5.1627336110E+00, 4.2688748301E+00, 2.0590541346E+00, 8.8568540891E-01],
	[2.6715000000E+04, 1.7333125643E+01, 5.1626938531E+00, 4.2714541139E+00, 2.0597210410E+00, 8.8573940877E-01],
	[2.6720000000E+04, 1.7338318830E+01, 5.1626541030E+00, 4.2740344722E+00, 2.0603878699E+00, 8.8579338331E-01],
	[2.6725000000E+04, 1.7343512600E+01, 5.1626143606E+00, 4.2766159052E+00, 2.0610546213E+00, 8.8584733255E-01],
	[2.6730000000E+04, 1.7348706955E+01, 5.1625746259E+00, 4.2791984132E+00, 2.0617212949E+00, 8.8590125649E-01],
	[2.6735000000E+04, 1.7353901893E+01, 5.1625348990E+00, 4.2817819964E+00, 2.0623878908E+00, 8.8595515514E-01],
	[2.6740000000E+04, 1.7359097415E+01, 5.1624951798E+00, 4.2843666550E+00, 2.0630544089E+00, 8.8600902851E-01],
	[2.6745000000E+04, 1.7364296382E+01, 5.1624559397E+00, 4.2869523893E+00, 2.0637209649E+00, 8.8606287661E-01],
	[2.6750000000E+04, 1.7369514894E+01, 5.1624198300E+00, 4.2895391996E+00, 2.0643882101E+00, 8.8611669946E-01],
	[2.6755000000E+04, 1.7374733999E+01, 5.1623837273E+00, 4.2921270860E+00, 2.0650553780E+00, 8.8617049706E-01],
	[2.6760000000E+04, 1.7379953696E+01, 5.1623476316E+00, 4.2947160489E+00, 2.0657224686E+00, 8.8622426942E-01],
	[2.6765000000E+04, 1.7385173986E+01, 5.1623115429E+00, 4.2973060885E+00, 2.0663894818E+00, 8.8627801655E-01],
	[2.6770000000E+04, 1.7390394868E+01, 5.1622754612E+00, 4.2998972050E+00, 2.0670564175E+00, 8.8633173845E-01],
	[2.6775000000E+04, 1.7395616342E+01, 5.1622393865E+00, 4.3024893987E+00, 2.0677232755E+00, 8.8638543515E-01],
	[2.6780000000E+04, 1.7400838409E+01, 5.1622033187E+00, 4.3050826698E+00, 2.0683900559E+00, 8.8643910665E-01],
	[2.6785000000E+04, 1.7406061068E+01, 5.1621672580E+00, 4.3076770185E+00, 2.0690567585E+00, 8.8649275296E-01],
	[2.6790000000E+04, 1.7411284320E+01, 5.1621312042E+00, 4.3102724452E+00, 2.0697233833E+00, 8.8654637408E-01],
	[2.6795000000E+04, 1.7416508163E+01, 5.1620951575E+00, 4.3128689500E+00, 2.0703899302E+00, 8.8659997003E-01],
	[2.6800000000E+04, 1.7421732599E+01, 5.1620591177E+00, 4.3154665332E+00, 2.0710563990E+00, 8.8665354082E-01],
	[2.6805000000E+04, 1.7426957627E+01, 5.1620230848E+00, 4.3180651951E+00, 2.0717227898E+00, 8.8670708646E-01],
	[2.6810000000E+04, 1.7432183247E+01, 5.1619870590E+00, 4.3206649358E+00, 2.0723891024E+00, 8.8676060695E-01],
	[2.6815000000E+04, 1.7437409459E+01, 5.1619510401E+00, 4.3232657557E+00, 2.0730553368E+00, 8.8681410232E-01],
	[2.6820000000E+04, 1.7442636263E+01, 5.1619150282E+00, 4.3258676550E+00, 2.0737214929E+00, 8.8686757255E-01],
	[2.6825000000E+04, 1.7447863659E+01, 5.1618790232E+00, 4.3284706339E+00, 2.0743875705E+00, 8.8692101768E-01],
	[2.6830000000E+04, 1.7453091647E+01, 5.1618430252E+00, 4.3310746927E+00, 2.0750535697E+00, 8.8697443770E-01],
	[2.6835000000E+04, 1.7458320227E+01, 5.1618070342E+00, 4.3336798316E+00, 2.0757194904E+00, 8.8702783262E-01],
	[2.6840000000E+04, 1.7463549398E+01, 5.1617710501E+00, 4.3362860509E+00, 2.0763853323E+00, 8.8708120246E-01],
	[2.6845000000E+04, 1.7468779162E+01, 5.1617350730E+00, 4.3388933508E+00, 2.0770510956E+00, 8.8713454722E-01],
	[2.6850000000E+04, 1.7474009517E+01, 5.1616991028E+00, 4.3415017316E+00, 2.0777167801E+00, 8.8718786692E-01],
	[2.6855000000E+04, 1.7479240463E+01, 5.1616631396E+00, 4.3441111935E+00, 2.0783823857E+00, 8.8724116156E-01],
	[2.6860000000E+04, 1.7484472002E+01, 5.1616271833E+00, 4.3467217367E+00, 2.0790479123E+00, 8.8729443116E-01],
	[2.6865000000E+04, 1.7489704132E+01, 5.1615912340E+00, 4.3493333616E+00, 2.0797133599E+00, 8.8734767572E-01],
	[2.6870000000E+04, 1.7494936853E+01, 5.1615552916E+00, 4.3519460683E+00, 2.0803787283E+00, 8.8740089525E-01],
	[2.6875000000E+04, 1.7500170166E+01, 5.1615193561E+00, 4.3545598570E+00, 2.0810440176E+00, 8.8745408977E-01],
	[2.6880000000E+04, 1.7505404071E+01, 5.1614834276E+00, 4.3571747282E+00, 2.0817092276E+00, 8.8750725928E-01],
	[2.6885000000E+04, 1.7510638567E+01, 5.1614475060E+00, 4.3597906819E+00, 2.0823743583E+00, 8.8756040379E-01],
	[2.6890000000E+04, 1.7515873654E+01, 5.1614115914E+00, 4.3624077184E+00, 2.0830394095E+00, 8.8761352331E-01],
	[2.6895000000E+04, 1.7521109333E+01, 5.1613756836E+00, 4.3650258380E+00, 2.0837043812E+00, 8.8766661785E-01],
	[2.6900000000E+04, 1.7526345603E+01, 5.1613397828E+00, 4.3676450410E+00, 2.0843692733E+00, 8.8771968743E-01],
	[2.6905000000E+04, 1.7531582464E+01, 5.1613038889E+00, 4.3702653275E+00, 2.0850340857E+00, 8.8777273205E-01],
	[2.6910000000E+04, 1.7536819916E+01, 5.1612680020E+00, 4.3728866978E+00, 2.0856988184E+00, 8.8782575171E-01],
	[2.6915000000E+04, 1.7542057960E+01, 5.1612321219E+00, 4.3755091522E+00, 2.0863634713E+00, 8.8787874644E-01],
	[2.6920000000E+04, 1.7547296595E+01, 5.1611962488E+00, 4.3781326909E+00, 2.0870280442E+00, 8.8793171624E-01],
	[2.6925000000E+04, 1.7552535820E+01, 5.1611603825E+00, 4.3807573142E+00, 2.0876925372E+00, 8.8798466112E-01],
	[2.6930000000E+04, 1.7557775637E+01, 5.1611245232E+00, 4.3833830222E+00, 2.0883569501E+00, 8.8803758109E-01],
	[2.6935000000E+04, 1.7563016045E+01, 5.1610886708E+00, 4.3860098154E+00, 2.0890212828E+00, 8.8809047616E-01],
	[2.6940000000E+04, 1.7568257044E+01, 5.1610528253E+00, 4.3886376938E+00, 2.0896855354E+00, 8.8814334634E-01],
	[2.6945000000E+04, 1.7573498634E+01, 5.1610169867E+00, 4.3912666577E+00, 2.0903497076E+00, 8.8819619163E-01],
	[2.6950000000E+04, 1.7578740814E+01, 5.1609811550E+00, 4.3938967075E+00, 2.0910137995E+00, 8.8824901206E-01],
	[2.6955000000E+04, 1.7583983585E+01, 5.1609453302E+00, 4.3965278432E+00, 2.0916778109E+00, 8.8830180763E-01],
	[2.6960000000E+04, 1.7589226948E+01, 5.1609095123E+00, 4.3991600653E+00, 2.0923417418E+00, 8.8835457834E-01],
	[2.6965000000E+04, 1.7594470901E+01, 5.1608737013E+00, 4.4017933739E+00, 2.0930055920E+00, 8.8840732421E-01],
	[2.6970000000E+04, 1.7599715444E+01, 5.1608378971E+00, 4.4044277692E+00, 2.0936693616E+00, 8.8846004525E-01],
	[2.6975000000E+04, 1.7604960578E+01, 5.1608020999E+00, 4.4070632516E+00, 2.0943330504E+00, 8.8851274147E-01],
	[2.6980000000E+04, 1.7610206303E+01, 5.1607663095E+00, 4.4096998212E+00, 2.0949966584E+00, 8.8856541288E-01],
	[2.6985000000E+04, 1.7615452619E+01, 5.1607305260E+00, 4.4123374784E+00, 2.0956601854E+00, 8.8861805948E-01],
	[2.6990000000E+04, 1.7620699525E+01, 5.1606947494E+00, 4.4149762233E+00, 2.0963236315E+00, 8.8867068129E-01],
	[2.6995000000E+04, 1.7625947021E+01, 5.1606589797E+00, 4.4176160562E+00, 2.0969869965E+00, 8.8872327832E-01],
	[2.7000000000E+04, 1.7631195108E+01, 5.1606232168E+00, 4.4202569774E+00, 2.0976502803E+00, 8.8877585058E-01],
	[2.7005000000E+04, 1.7636443785E+01, 5.1605874608E+00, 4.4228989871E+00, 2.0983134829E+00, 8.8882839807E-01],
	[2.7010000000E+04, 1.7641693053E+01, 5.1605517117E+00, 4.4255420855E+00, 2.0989766041E+00, 8.8888092081E-01],
	[2.7015000000E+04, 1.7646942911E+01, 5.1605159694E+00, 4.4281862729E+00, 2.0996396440E+00, 8.8893341880E-01],
	[2.7020000000E+04, 1.7652193359E+01, 5.1604802340E+00, 4.4308315495E+00, 2.1003026025E+00, 8.8898589206E-01],
	[2.7025000000E+04, 1.7657444397E+01, 5.1604445055E+00, 4.4334779157E+00, 2.1009654794E+00, 8.8903834060E-01],
	[2.7030000000E+04, 1.7662696026E+01, 5.1604087838E+00, 4.4361253715E+00, 2.1016282747E+00, 8.8909076442E-01],
	[2.7035000000E+04, 1.7667948245E+01, 5.1603730690E+00, 4.4387739174E+00, 2.1022909882E+00, 8.8914316354E-01],
	[2.7040000000E+04, 1.7673201054E+01, 5.1603373610E+00, 4.4414235534E+00, 2.1029536201E+00, 8.8919553797E-01],
	[2.7045000000E+04, 1.7678454452E+01, 5.1603016599E+00, 4.4440742799E+00, 2.1036161700E+00, 8.8924788771E-01],
	[2.7050000000E+04, 1.7683708441E+01, 5.1602659656E+00, 4.4467260972E+00, 2.1042786381E+00, 8.8930021277E-01],
	[2.7055000000E+04, 1.7688963020E+01, 5.1602302781E+00, 4.4493790054E+00, 2.1049410241E+00, 8.8935251317E-01],
	[2.7060000000E+04, 1.7694218189E+01, 5.1601945975E+00, 4.4520330048E+00, 2.1056033281E+00, 8.8940478892E-01],
	[2.7065000000E+04, 1.7699473948E+01, 5.1601589238E+00, 4.4546880957E+00, 2.1062655499E+00, 8.8945704002E-01],
	[2.7070000000E+04, 1.7704730296E+01, 5.1601232569E+00, 4.4573442783E+00, 2.1069276895E+00, 8.8950926648E-01],
	[2.7075000000E+04, 1.7709987234E+01, 5.1600875968E+00, 4.4600015528E+00, 2.1075897468E+00, 8.8956146832E-01],
	[2.7080000000E+04, 1.7715244762E+01, 5.1600519435E+00, 4.4626599195E+00, 2.1082517218E+00, 8.8961364554E-01],
	[2.7085000000E+04, 1.7720502880E+01, 5.1600162971E+00, 4.4653193787E+00, 2.1089136142E+00, 8.8966579816E-01],
	[2.7090000000E+04, 1.7725761588E+01, 5.1599806575E+00, 4.4679799306E+00, 2.1095754241E+00, 8.8971792618E-01],
	[2.7095000000E+04, 1.7731020885E+01, 5.1599450247E+00, 4.4706415754E+00, 2.1102371515E+00, 8.8977002962E-01],
	[2.7100000000E+04, 1.7736280771E+01, 5.1599093988E+00, 4.4733043134E+00, 2.1108987961E+00, 8.8982210848E-01],
	[2.7105000000E+04, 1.7741541247E+01, 5.1598737796E+00, 4.4759681448E+00, 2.1115603580E+00, 8.8987416277E-01],
	[2.7110000000E+04, 1.7746802313E+01, 5.1598381673E+00, 4.4786330698E+00, 2.1122218370E+00, 8.8992619251E-01],
	[2.7115000000E+04, 1.7752063968E+01, 5.1598025618E+00, 4.4812990889E+00, 2.1128832331E+00, 8.8997819770E-01],
	[2.7120000000E+04, 1.7757326213E+01, 5.1597669631E+00, 4.4839662020E+00, 2.1135445463E+00, 8.9003017836E-01],
	[2.7125000000E+04, 1.7762589047E+01, 5.1597313712E+00, 4.4866344096E+00, 2.1142057764E+00, 8.9008213448E-01],
	[2.7130000000E+04, 1.7767852470E+01, 5.1596957861E+00, 4.4893037119E+00, 2.1148669233E+00, 8.9013406609E-01],
	[2.7135000000E+04, 1.7773116482E+01, 5.1596602078E+00, 4.4919741091E+00, 2.1155279871E+00, 8.9018597320E-01],
	[2.7140000000E+04, 1.7778381084E+01, 5.1596246364E+00, 4.4946456014E+00, 2.1161889675E+00, 8.9023785581E-01],
	[2.7145000000E+04, 1.7783646275E+01, 5.1595890717E+00, 4.4973181891E+00, 2.1168498646E+00, 8.9028971392E-01],
	[2.7150000000E+04, 1.7788912055E+01, 5.1595535138E+00, 4.4999918725E+00, 2.1175106783E+00, 8.9034154756E-01],
	[2.7155000000E+04, 1.7794178424E+01, 5.1595179627E+00, 4.5026666518E+00, 2.1181714084E+00, 8.9039335673E-01],
	[2.7160000000E+04, 1.7799445383E+01, 5.1594824184E+00, 4.5053425272E+00, 2.1188320550E+00, 8.9044514143E-01],
	[2.7165000000E+04, 1.7804712930E+01, 5.1594468809E+00, 4.5080194990E+00, 2.1194926179E+00, 8.9049690169E-01],
	[2.7170000000E+04, 1.7809981066E+01, 5.1594113501E+00, 4.5106975674E+00, 2.1201530970E+00, 8.9054863749E-01],
	[2.7175000000E+04, 1.7815250261E+01, 5.1593759026E+00, 4.5133767327E+00, 2.1208135119E+00, 8.9060034887E-01],
	[2.7180000000E+04, 1.7820541310E+01, 5.1593439161E+00, 4.5160569952E+00, 2.1214747284E+00, 8.9065203581E-01],
	[2.7185000000E+04, 1.7825832957E+01, 5.1593119357E+00, 4.5187383550E+00, 2.1221358617E+00, 8.9070369834E-01],
	[2.7190000000E+04, 1.7831125202E+01, 5.1592799614E+00, 4.5214208125E+00, 2.1227969117E+00, 8.9075533646E-01],
	[2.7195000000E+04, 1.7836418044E+01, 5.1592479931E+00, 4.5241043678E+00, 2.1234578784E+00, 8.9080695018E-01],
	[2.7200000000E+04, 1.7841711483E+01, 5.1592160309E+00, 4.5267890213E+00, 2.1241187618E+00, 8.9085853951E-01],
	[2.7205000000E+04, 1.7847005521E+01, 5.1591840748E+00, 4.5294747731E+00, 2.1247795616E+00, 8.9091010446E-01],
	[2.7210000000E+04, 1.7852300155E+01, 5.1591521248E+00, 4.5321616235E+00, 2.1254402779E+00, 8.9096164503E-01],
	[2.7215000000E+04, 1.7857595388E+01, 5.1591201809E+00, 4.5348495728E+00, 2.1261009106E+00, 8.9101316124E-01],
	[2.7220000000E+04, 1.7862891218E+01, 5.1590882430E+00, 4.5375386212E+00, 2.1267614596E+00, 8.9106465310E-01],
	[2.7225000000E+04, 1.7868187645E+01, 5.1590563111E+00, 4.5402287689E+00, 2.1274219248E+00, 8.9111612061E-01],
	[2.7230000000E+04, 1.7873484669E+01, 5.1590243854E+00, 4.5429200163E+00, 2.1280823062E+00, 8.9116756379E-01],
	[2.7235000000E+04, 1.7878782291E+01, 5.1589924657E+00, 4.5456123635E+00, 2.1287426037E+00, 8.9121898263E-01],
	[2.7240000000E+04, 1.7884080510E+01, 5.1589605520E+00, 4.5483058107E+00, 2.1294028172E+00, 8.9127037716E-01],
	[2.7245000000E+04, 1.7889379326E+01, 5.1589286444E+00, 4.5510003584E+00, 2.1300629466E+00, 8.9132174738E-01],
	[2.7250000000E+04, 1.7894678740E+01, 5.1588967429E+00, 4.5536960066E+00, 2.1307229919E+00, 8.9137309330E-01],
	[2.7255000000E+04, 1.7899978750E+01, 5.1588648474E+00, 4.5563927556E+00, 2.1313829530E+00, 8.9142441492E-01],
	[2.7260000000E+04, 1.7905279358E+01, 5.1588329579E+00, 4.5590906057E+00, 2.1320428298E+00, 8.9147571227E-01],
	[2.7265000000E+04, 1.7910580563E+01, 5.1588010745E+00, 4.5617895572E+00, 2.1327026222E+00, 8.9152698534E-01],
	[2.7270000000E+04, 1.7915882365E+01, 5.1587691972E+00, 4.5644896102E+00, 2.1333623303E+00, 8.9157823414E-01],
	[2.7275000000E+04, 1.7921184764E+01, 5.1587373258E+00, 4.5671907650E+00, 2.1340219538E+00, 8.9162945869E-01],
	[2.7280000000E+04, 1.7926487759E+01, 5.1587054606E+00, 4.5698930220E+00, 2.1346814927E+00, 8.9168065899E-01],
	[2.7285000000E+04, 1.7931791352E+01, 5.1586736013E+00, 4.5725963812E+00, 2.1353409470E+00, 8.9173183506E-01],
	[2.7290000000E+04, 1.7937095541E+01, 5.1586417481E+00, 4.5753008430E+00, 2.1360003166E+00, 8.9178298690E-01],
	[2.7295000000E+04, 1.7942400328E+01, 5.1586099009E+00, 4.5780064076E+00, 2.1366596014E+00, 8.9183411451E-01],
	[2.7300000000E+04, 1.7947705711E+01, 5.1585780598E+00, 4.5807130752E+00, 2.1373188013E+00, 8.9188521792E-01],
	[2.7305000000E+04, 1.7953011691E+01, 5.1585462247E+00, 4.5834208462E+00, 2.1379779163E+00, 8.9193629713E-01],
	[2.7310000000E+04, 1.7958318267E+01, 5.1585143956E+00, 4.5861297207E+00, 2.1386369462E+00, 8.9198735214E-01],
	[2.7315000000E+04, 1.7963625440E+01, 5.1584825725E+00, 4.5888396990E+00, 2.1392958911E+00, 8.9203838297E-01],
	[2.7320000000E+04, 1.7968933210E+01, 5.1584507555E+00, 4.5915507814E+00, 2.1399547508E+00, 8.9208938963E-01],
	[2.7325000000E+04, 1.7974241576E+01, 5.1584189445E+00, 4.5942629680E+00, 2.1406135253E+00, 8.9214037212E-01],
	[2.7330000000E+04, 1.7979550539E+01, 5.1583871394E+00, 4.5969762592E+00, 2.1412722145E+00, 8.9219133046E-01],
	[2.7335000000E+04, 1.7984860098E+01, 5.1583553404E+00, 4.5996906552E+00, 2.1419308184E+00, 8.9224226465E-01],
	[2.7340000000E+04, 1.7990170254E+01, 5.1583235475E+00, 4.6024061562E+00, 2.1425893367E+00, 8.9229317470E-01],
	[2.7345000000E+04, 1.7995481006E+01, 5.1582917605E+00, 4.6051227625E+00, 2.1432477696E+00, 8.9234406062E-01],
	[2.7350000000E+04, 1.8000792354E+01, 5.1582599795E+00, 4.6078404743E+00, 2.1439061169E+00, 8.9239492243E-01],
	[2.7355000000E+04, 1.8006104299E+01, 5.1582282046E+00, 4.6105592919E+00, 2.1445643785E+00, 8.9244576012E-01],
	[2.7360000000E+04, 1.8011416840E+01, 5.1581964356E+00, 4.6132792155E+00, 2.1452225544E+00, 8.9249657371E-01],
	[2.7365000000E+04, 1.8016729977E+01, 5.1581646726E+00, 4.6160002454E+00, 2.1458806444E+00, 8.9254736322E-01],
	[2.7370000000E+04, 1.8022043710E+01, 5.1581329157E+00, 4.6187223818E+00, 2.1465386486E+00, 8.9259812863E-01],
	[2.7375000000E+04, 1.8027358040E+01, 5.1581011647E+00, 4.6214456249E+00, 2.1471965669E+00, 8.9264886998E-01],
	[2.7380000000E+04, 1.8032672965E+01, 5.1580694197E+00, 4.6241699751E+00, 2.1478543991E+00, 8.9269958726E-01],
	[2.7385000000E+04, 1.8037988487E+01, 5.1580376808E+00, 4.6268954325E+00, 2.1485121453E+00, 8.9275028048E-01],
	[2.7390000000E+04, 1.8043304605E+01, 5.1580059478E+00, 4.6296223865E+00, 2.1491698891E+00, 8.9280094966E-01],
	[2.7395000000E+04, 1.8048621318E+01, 5.1579742208E+00, 4.6323505585E+00, 2.1498275703E+00, 8.9285159481E-01],
	[2.7400000000E+04, 1.8053938628E+01, 5.1579424998E+00, 4.6350798390E+00, 2.1504851653E+00, 8.9290221592E-01],
	[2.7405000000E+04, 1.8059256533E+01, 5.1579107847E+00, 4.6378102283E+00, 2.1511426738E+00, 8.9295281301E-01],
	[2.7410000000E+04, 1.8064575034E+01, 5.1578790757E+00, 4.6405417266E+00, 2.1518000959E+00, 8.9300338610E-01],
	[2.7415000000E+04, 1.8069894131E+01, 5.1578473726E+00, 4.6432743342E+00, 2.1524574314E+00, 8.9305393519E-01],
	[2.7420000000E+04, 1.8075213824E+01, 5.1578156755E+00, 4.6460080512E+00, 2.1531146804E+00, 8.9310446028E-01],
	[2.7425000000E+04, 1.8080534113E+01, 5.1577839844E+00, 4.6487428781E+00, 2.1537718427E+00, 8.9315496139E-01],
	[2.7430000000E+04, 1.8085854997E+01, 5.1577522992E+00, 4.6514788149E+00, 2.1544289182E+00, 8.9320543853E-01],
	[2.7435000000E+04, 1.8091176477E+01, 5.1577206200E+00, 4.6542158620E+00, 2.1550859070E+00, 8.9325589171E-01],
	[2.7440000000E+04, 1.8096498552E+01, 5.1576889468E+00, 4.6569540196E+00, 2.1557428088E+00, 8.9330632093E-01],
	[2.7445000000E+04, 1.8101821223E+01, 5.1576572796E+00, 4.6596932880E+00, 2.1563996237E+00, 8.9335672621E-01],
	[2.7450000000E+04, 1.8107144489E+01, 5.1576256183E+00, 4.6624336673E+00, 2.1570563516E+00, 8.9340710755E-01],
	[2.7455000000E+04, 1.8112468351E+01, 5.1575939630E+00, 4.6651751579E+00, 2.1577129924E+00, 8.9345746497E-01],
	[2.7460000000E+04, 1.8117792809E+01, 5.1575623136E+00, 4.6679177600E+00, 2.1583695461E+00, 8.9350779846E-01],
	[2.7465000000E+04, 1.8123117861E+01, 5.1575306702E+00, 4.6706614738E+00, 2.1590260125E+00, 8.9355810805E-01],
	[2.7470000000E+04, 1.8128443509E+01, 5.1574990327E+00, 4.6734062996E+00, 2.1596823915E+00, 8.9360839374E-01],
	[2.7475000000E+04, 1.8133769753E+01, 5.1574674012E+00, 4.6761522377E+00, 2.1603386833E+00, 8.9365865554E-01],
	[2.7480000000E+04, 1.8139096591E+01, 5.1574357757E+00, 4.6788992882E+00, 2.1609948875E+00, 8.9370889346E-01],
	[2.7485000000E+04, 1.8144424025E+01, 5.1574041561E+00, 4.6816474515E+00, 2.1616510043E+00, 8.9375910751E-01],
	[2.7490000000E+04, 1.8149752054E+01, 5.1573725424E+00, 4.6843967277E+00, 2.1623070335E+00, 8.9380929770E-01],
	[2.7495000000E+04, 1.8155080678E+01, 5.1573409347E+00, 4.6871471172E+00, 2.1629629750E+00, 8.9385946403E-01],
	[2.7500000000E+04, 1.8160409897E+01, 5.1573093329E+00, 4.6898986201E+00, 2.1636188288E+00, 8.9390960653E-01],
	[2.7505000000E+04, 1.8165739712E+01, 5.1572777371E+00, 4.6926512368E+00, 2.1642745948E+00, 8.9395972518E-01],
	[2.7510000000E+04, 1.8171070121E+01, 5.1572461472E+00, 4.6954049674E+00, 2.1649302730E+00, 8.9400982001E-01],
	[2.7515000000E+04, 1.8176401125E+01, 5.1572145632E+00, 4.6981598123E+00, 2.1655858632E+00, 8.9405989103E-01],
	[2.7520000000E+04, 1.8181732724E+01, 5.1571829852E+00, 4.7009157716E+00, 2.1662413654E+00, 8.9410993824E-01],
	[2.7525000000E+04, 1.8187064918E+01, 5.1571514131E+00, 4.7036728456E+00, 2.1668967796E+00, 8.9415996165E-01],
	[2.7530000000E+04, 1.8192397707E+01, 5.1571198469E+00, 4.7064310346E+00, 2.1675521056E+00, 8.9420996128E-01],
	[2.7535000000E+04, 1.8197731091E+01, 5.1570882867E+00, 4.7091903388E+00, 2.1682073434E+00, 8.9425993713E-01],
	[2.7540000000E+04, 1.8203065069E+01, 5.1570567323E+00, 4.7119507585E+00, 2.1688624929E+00, 8.9430988920E-01],
	[2.7545000000E+04, 1.8208399642E+01, 5.1570251839E+00, 4.7147122939E+00, 2.1695175541E+00, 8.9435981752E-01],
	[2.7550000000E+04, 1.8213734810E+01, 5.1569936414E+00, 4.7174749452E+00, 2.1701725268E+00, 8.9440972209E-01],
	[2.7555000000E+04, 1.8219070572E+01, 5.1569621049E+00, 4.7202387127E+00, 2.1708274111E+00, 8.9445960291E-01],
	[2.7560000000E+04, 1.8224406929E+01, 5.1569305742E+00, 4.7230035967E+00, 2.1714822068E+00, 8.9450946001E-01],
	[2.7565000000E+04, 1.8229743881E+01, 5.1568990495E+00, 4.7257695973E+00, 2.1721369139E+00, 8.9455929338E-01],
	[2.7570000000E+04, 1.8235081427E+01, 5.1568675306E+00, 4.7285367149E+00, 2.1727915324E+00, 8.9460910304E-01],
	[2.7575000000E+04, 1.8240419567E+01, 5.1568360177E+00, 4.7313049497E+00, 2.1734460620E+00, 8.9465888899E-01],
	[2.7580000000E+04, 1.8245758302E+01, 5.1568045107E+00, 4.7340743019E+00, 2.1741005028E+00, 8.9470865125E-01],
	[2.7585000000E+04, 1.8251097632E+01, 5.1567730096E+00, 4.7368447719E+00, 2.1747548548E+00, 8.9475838983E-01],
	[2.7590000000E+04, 1.8256437555E+01, 5.1567415144E+00, 4.7396163597E+00, 2.1754091177E+00, 8.9480810473E-01],
	[2.7595000000E+04, 1.8261778073E+01, 5.1567100251E+00, 4.7423890658E+00, 2.1760632917E+00, 8.9485779596E-01],
	[2.7600000000E+04, 1.8267119185E+01, 5.1566785416E+00, 4.7451628902E+00, 2.1767173765E+00, 8.9490746354E-01],
	[2.7605000000E+04, 1.8272460892E+01, 5.1566470641E+00, 4.7479378334E+00, 2.1773713721E+00, 8.9495710746E-01],
	[2.7610000000E+04, 1.8277803192E+01, 5.1566155925E+00, 4.7507138954E+00, 2.1780252786E+00, 8.9500672775E-01],
	[2.7615000000E+04, 1.8283157469E+01, 5.1565859509E+00, 4.7534910767E+00, 2.1786795829E+00, 8.9505632441E-01],
	[2.7620000000E+04, 1.8288522608E+01, 5.1565579593E+00, 4.7562693773E+00, 2.1793342378E+00, 8.9510589745E-01],
	[2.7625000000E+04, 1.8293888351E+01, 5.1565299729E+00, 4.7590487977E+00, 2.1799888040E+00, 8.9515544688E-01],
	[2.7630000000E+04, 1.8299254696E+01, 5.1565019917E+00, 4.7618293379E+00, 2.1806432815E+00, 8.9520497271E-01],
	[2.7635000000E+04, 1.8304621643E+01, 5.1564740157E+00, 4.7646109984E+00, 2.1812976702E+00, 8.9525447495E-01],
	[2.7640000000E+04, 1.8309989194E+01, 5.1564460450E+00, 4.7673937792E+00, 2.1819519700E+00, 8.9530395360E-01],
	[2.7645000000E+04, 1.8315357347E+01, 5.1564180794E+00, 4.7701776807E+00, 2.1826061808E+00, 8.9535340868E-01],
	[2.7650000000E+04, 1.8320726102E+01, 5.1563901191E+00, 4.7729627031E+00, 2.1832603027E+00, 8.9540284020E-01],
	[2.7655000000E+04, 1.8326095460E+01, 5.1563621640E+00, 4.7757488467E+00, 2.1839143354E+00, 8.9545224816E-01],
	[2.7660000000E+04, 1.8331465421E+01, 5.1563342141E+00, 4.7785361116E+00, 2.1845682791E+00, 8.9550163258E-01],
	[2.7665000000E+04, 1.8336835984E+01, 5.1563062694E+00, 4.7813244982E+00, 2.1852221335E+00, 8.9555099347E-01],
	[2.7670000000E+04, 1.8342207150E+01, 5.1562783298E+00, 4.7841140068E+00, 2.1858758986E+00, 8.9560033083E-01],
	[2.7675000000E+04, 1.8347578918E+01, 5.1562503955E+00, 4.7869046374E+00, 2.1865295744E+00, 8.9564964467E-01],
	[2.7680000000E+04, 1.8352951288E+01, 5.1562224664E+00, 4.7896963905E+00, 2.1871831608E+00, 8.9569893500E-01],
	[2.7685000000E+04, 1.8358324261E+01, 5.1561945425E+00, 4.7924892662E+00, 2.1878366578E+00, 8.9574820184E-01],
	[2.7690000000E+04, 1.8363697836E+01, 5.1561666238E+00, 4.7952832649E+00, 2.1884900651E+00, 8.9579744519E-01],
	[2.7695000000E+04, 1.8369072013E+01, 5.1561387102E+00, 4.7980783866E+00, 2.1891433829E+00, 8.9584666506E-01],
	[2.7700000000E+04, 1.8374446792E+01, 5.1561108019E+00, 4.8008746318E+00, 2.1897966110E+00, 8.9589586146E-01],
	[2.7705000000E+04, 1.8379822174E+01, 5.1560828987E+00, 4.8036720005E+00, 2.1904497493E+00, 8.9594503440E-01],
	[2.7710000000E+04, 1.8385198157E+01, 5.1560550008E+00, 4.8064704932E+00, 2.1911027978E+00, 8.9599418389E-01],
	[2.7715000000E+04, 1.8390574743E+01, 5.1560271080E+00, 4.8092701100E+00, 2.1917557565E+00, 8.9604330994E-01],
	[2.7720000000E+04, 1.8395951930E+01, 5.1559992204E+00, 4.8120708512E+00, 2.1924086252E+00, 8.9609241256E-01],
	[2.7725000000E+04, 1.8401329720E+01, 5.1559713380E+00, 4.8148727170E+00, 2.1930614038E+00, 8.9614149175E-01],
	[2.7730000000E+04, 1.8406708112E+01, 5.1559434607E+00, 4.8176757077E+00, 2.1937140925E+00, 8.9619054753E-01],
	[2.7735000000E+04, 1.8412087105E+01, 5.1559155886E+00, 4.8204798235E+00, 2.1943666909E+00, 8.9623957991E-01],
	[2.7740000000E+04, 1.8417466700E+01, 5.1558877217E+00, 4.8232850647E+00, 2.1950191992E+00, 8.9628858890E-01],
	[2.7745000000E+04, 1.8422846897E+01, 5.1558598600E+00, 4.8260914316E+00, 2.1956716172E+00, 8.9633757450E-01],
	[2.7750000000E+04, 1.8428227696E+01, 5.1558320035E+00, 4.8288989243E+00, 2.1963239448E+00, 8.9638653672E-01],
	[2.7755000000E+04, 1.8433609097E+01, 5.1558041521E+00, 4.8317075431E+00, 2.1969761820E+00, 8.9643547559E-01],
	[2.7760000000E+04, 1.8438991099E+01, 5.1557763059E+00, 4.8345172883E+00, 2.1976283288E+00, 8.9648439109E-01],
	[2.7765000000E+04, 1.8444373703E+01, 5.1557484648E+00, 4.8373281601E+00, 2.1982803850E+00, 8.9653328325E-01],
	[2.7770000000E+04, 1.8449756909E+01, 5.1557206290E+00, 4.8401401587E+00, 2.1989323506E+00, 8.9658215207E-01],
	[2.7775000000E+04, 1.8455140716E+01, 5.1556927982E+00, 4.8429532845E+00, 2.1995842255E+00, 8.9663099756E-01],
	[2.7780000000E+04, 1.8460525124E+01, 5.1556649727E+00, 4.8457675376E+00, 2.2002360097E+00, 8.9667981974E-01],
	[2.7785000000E+04, 1.8465910135E+01, 5.1556371523E+00, 4.8485829184E+00, 2.2008877031E+00, 8.9672861861E-01],
	[2.7790000000E+04, 1.8471295746E+01, 5.1556093370E+00, 4.8513994270E+00, 2.2015393057E+00, 8.9677739417E-01],
	[2.7795000000E+04, 1.8476681959E+01, 5.1555815269E+00, 4.8542170637E+00, 2.2021908173E+00, 8.9682614645E-01],
	[2.7800000000E+04, 1.8482068773E+01, 5.1555537220E+00, 4.8570358288E+00, 2.2028422379E+00, 8.9687487545E-01],
	[2.7805000000E+04, 1.8487456189E+01, 5.1555259222E+00, 4.8598557224E+00, 2.2034935674E+00, 8.9692358118E-01],
	[2.7810000000E+04, 1.8492844206E+01, 5.1554981276E+00, 4.8626767449E+00, 2.2041448058E+00, 8.9697226364E-01],
	[2.7815000000E+04, 1.8498232824E+01, 5.1554703381E+00, 4.8654988966E+00, 2.2047959530E+00, 8.9702092286E-01],
	[2.7820000000E+04, 1.8503622044E+01, 5.1554425537E+00, 4.8683221775E+00, 2.2054470090E+00, 8.9706955883E-01],
	[2.7825000000E+04, 1.8509011864E+01, 5.1554147745E+00, 4.8711465881E+00, 2.2060979736E+00, 8.9711817157E-01],
	[2.7830000000E+04, 1.8514402286E+01, 5.1553870004E+00, 4.8739721285E+00, 2.2067488468E+00, 8.9716676109E-01],
	[2.7835000000E+04, 1.8519793308E+01, 5.1553592315E+00, 4.8767987990E+00, 2.2073996286E+00, 8.9721532739E-01],
	[2.7840000000E+04, 1.8525184932E+01, 5.1553314677E+00, 4.8796265998E+00, 2.2080503189E+00, 8.9726387049E-01],
	[2.7845000000E+04, 1.8530577157E+01, 5.1553037091E+00, 4.8824555312E+00, 2.2087009176E+00, 8.9731239040E-01],
	[2.7850000000E+04, 1.8535969983E+01, 5.1552759555E+00, 4.8852855935E+00, 2.2093514246E+00, 8.9736088712E-01],
	[2.7855000000E+04, 1.8541363409E+01, 5.1552482072E+00, 4.8881167868E+00, 2.2100018399E+00, 8.9740936066E-01],
	[2.7860000000E+04, 1.8546757437E+01, 5.1552204639E+00, 4.8909491115E+00, 2.2106521635E+00, 8.9745781104E-01],
	[2.7865000000E+04, 1.8552152065E+01, 5.1551927258E+00, 4.8937825678E+00, 2.2113023952E+00, 8.9750623826E-01],
	[2.7870000000E+04, 1.8557547294E+01, 5.1551649928E+00, 4.8966171559E+00, 2.2119525350E+00, 8.9755464234E-01],
	[2.7875000000E+04, 1.8562943124E+01, 5.1551372649E+00, 4.8994528761E+00, 2.2126025828E+00, 8.9760302328E-01],
	[2.7880000000E+04, 1.8568339554E+01, 5.1551095421E+00, 4.9022897286E+00, 2.2132525386E+00, 8.9765138109E-01],
	[2.7885000000E+04, 1.8573736586E+01, 5.1550818245E+00, 4.9051277136E+00, 2.2139024023E+00, 8.9769971578E-01],
	[2.7890000000E+04, 1.8579134217E+01, 5.1550541119E+00, 4.9079668315E+00, 2.2145521739E+00, 8.9774802737E-01],
	[2.7895000000E+04, 1.8584532450E+01, 5.1550264045E+00, 4.9108070825E+00, 2.2152018532E+00, 8.9779631585E-01],
	[2.7900000000E+04, 1.8589931283E+01, 5.1549987023E+00, 4.9136484668E+00, 2.2158514402E+00, 8.9784458125E-01],
	[2.7905000000E+04, 1.8595330716E+01, 5.1549710051E+00, 4.9164909847E+00, 2.2165009349E+00, 8.9789282356E-01],
	[2.7910000000E+04, 1.8600730750E+01, 5.1549433130E+00, 4.9193346364E+00, 2.2171503372E+00, 8.9794104281E-01],
	[2.7915000000E+04, 1.8606131384E+01, 5.1549156261E+00, 4.9221794221E+00, 2.2177996470E+00, 8.9798923899E-01],
	[2.7920000000E+04, 1.8611532619E+01, 5.1548879442E+00, 4.9250253422E+00, 2.2184488642E+00, 8.9803741213E-01],
	[2.7925000000E+04, 1.8616934454E+01, 5.1548602675E+00, 4.9278723968E+00, 2.2190979888E+00, 8.9808556222E-01],
	[2.7930000000E+04, 1.8622336889E+01, 5.1548325958E+00, 4.9307205863E+00, 2.2197470208E+00, 8.9813368928E-01],
	[2.7935000000E+04, 1.8627739925E+01, 5.1548049293E+00, 4.9335699108E+00, 2.2203959600E+00, 8.9818179331E-01],
	[2.7940000000E+04, 1.8633143561E+01, 5.1547772678E+00, 4.9364203706E+00, 2.2210448065E+00, 8.9822987434E-01],
	[2.7945000000E+04, 1.8638547797E+01, 5.1547496115E+00, 4.9392719660E+00, 2.2216935600E+00, 8.9827793236E-01],
	[2.7950000000E+04, 1.8643952633E+01, 5.1547219603E+00, 4.9421246972E+00, 2.2223422207E+00, 8.9832596739E-01],
	[2.7955000000E+04, 1.8649358069E+01, 5.1546943141E+00, 4.9449785644E+00, 2.2229907884E+00, 8.9837397943E-01],
	[2.7960000000E+04, 1.8654764105E+01, 5.1546666731E+00, 4.9478335679E+00, 2.2236392630E+00, 8.9842196850E-01],
	[2.7965000000E+04, 1.8660170742E+01, 5.1546390371E+00, 4.9506897080E+00, 2.2242876445E+00, 8.9846993460E-01],
	[2.7970000000E+04, 1.8665577978E+01, 5.1546114062E+00, 4.9535469849E+00, 2.2249359328E+00, 8.9851787775E-01],
	[2.7975000000E+04, 1.8670985814E+01, 5.1545837804E+00, 4.9564053989E+00, 2.2255841279E+00, 8.9856579795E-01],
	[2.7980000000E+04, 1.8676394250E+01, 5.1545561597E+00, 4.9592649501E+00, 2.2262322297E+00, 8.9861369522E-01],
	[2.7985000000E+04, 1.8681803286E+01, 5.1545285441E+00, 4.9621256389E+00, 2.2268802381E+00, 8.9866156956E-01],
	[2.7990000000E+04, 1.8687212922E+01, 5.1545009335E+00, 4.9649874655E+00, 2.2275281531E+00, 8.9870942098E-01],
	[2.7995000000E+04, 1.8692623157E+01, 5.1544733281E+00, 4.9678504301E+00, 2.2281759747E+00, 8.9875724950E-01],
	[2.8000000000E+04, 1.8698033992E+01, 5.1544457277E+00, 4.9707145331E+00, 2.2288237026E+00, 8.9880505511E-01],
	[2.8005000000E+04, 1.8703445427E+01, 5.1544181324E+00, 4.9735797745E+00, 2.2294713370E+00, 8.9885283784E-01],
	[2.8010000000E+04, 1.8708857462E+01, 5.1543905422E+00, 4.9764461548E+00, 2.2301188777E+00, 8.9890059769E-01],
	[2.8015000000E+04, 1.8714270096E+01, 5.1543629570E+00, 4.9793136741E+00, 2.2307663247E+00, 8.9894833468E-01],
	[2.8020000000E+04, 1.8719683330E+01, 5.1543353769E+00, 4.9821823327E+00, 2.2314136778E+00, 8.9899604880E-01],
	[2.8025000000E+04, 1.8725097163E+01, 5.1543078019E+00, 4.9850521308E+00, 2.2320609371E+00, 8.9904374007E-01],
	[2.8030000000E+04, 1.8730511596E+01, 5.1542802319E+00, 4.9879230687E+00, 2.2327081025E+00, 8.9909140850E-01],
	[2.8035000000E+04, 1.8735926628E+01, 5.1542526670E+00, 4.9907951466E+00, 2.2333551739E+00, 8.9913905411E-01],
	[2.8040000000E+04, 1.8741342259E+01, 5.1542251072E+00, 4.9936683649E+00, 2.2340021512E+00, 8.9918667689E-01],
	[2.8045000000E+04, 1.8746758490E+01, 5.1541975525E+00, 4.9965427236E+00, 2.2346490345E+00, 8.9923427686E-01],
	[2.8050000000E+04, 1.8752175321E+01, 5.1541700027E+00, 4.9994182232E+00, 2.2352958235E+00, 8.9928185403E-01],
	[2.8055000000E+04, 1.8757592750E+01, 5.1541424581E+00, 5.0022948637E+00, 2.2359425184E+00, 8.9932940841E-01],
	[2.8060000000E+04, 1.8763024176E+01, 5.1541170367E+00, 5.0051726456E+00, 2.2365897082E+00, 8.9937694000E-01],
	[2.8065000000E+04, 1.8768464365E+01, 5.1540929095E+00, 5.0080515690E+00, 2.2372371630E+00, 8.9942444883E-01],
	[2.8070000000E+04, 1.8773905162E+01, 5.1540687868E+00, 5.0109316341E+00, 2.2378845241E+00, 8.9947193489E-01],
	[2.8075000000E+04, 1.8779346567E+01, 5.1540446684E+00, 5.0138128413E+00, 2.2385317916E+00, 8.9951939819E-01],
	[2.8080000000E+04, 1.8784788579E+01, 5.1540205545E+00, 5.0166951907E+00, 2.2391789652E+00, 8.9956683876E-01],
	[2.8085000000E+04, 1.8790231199E+01, 5.1539964449E+00, 5.0195786827E+00, 2.2398260450E+00, 8.9961425659E-01],
	[2.8090000000E+04, 1.8795674427E+01, 5.1539723398E+00, 5.0224633174E+00, 2.2404730309E+00, 8.9966165169E-01],
	[2.8095000000E+04, 1.8801118262E+01, 5.1539482390E+00, 5.0253490952E+00, 2.2411199229E+00, 8.9970902408E-01],
	[2.8100000000E+04, 1.8806562705E+01, 5.1539241427E+00, 5.0282360162E+00, 2.2417667208E+00, 8.9975637377E-01],
	[2.8105000000E+04, 1.8812007755E+01, 5.1539000508E+00, 5.0311240808E+00, 2.2424134246E+00, 8.9980370076E-01],
	[2.8110000000E+04, 1.8817453413E+01, 5.1538759632E+00, 5.0340132891E+00, 2.2430600343E+00, 8.9985100506E-01],
	[2.8115000000E+04, 1.8822899678E+01, 5.1538518801E+00, 5.0369036414E+00, 2.2437065498E+00, 8.9989828669E-01],
	[2.8120000000E+04, 1.8828346551E+01, 5.1538278013E+00, 5.0397951380E+00, 2.2443529710E+00, 8.9994554566E-01],
	[2.8125000000E+04, 1.8833794031E+01, 5.1538037270E+00, 5.0426877791E+00, 2.2449992979E+00, 8.9999278196E-01],
	[2.8130000000E+04, 1.8839242118E+01, 5.1537796570E+00, 5.0455815649E+00, 2.2456455305E+00, 9.0003999562E-01],
	[2.8135000000E+04, 1.8844690813E+01, 5.1537555915E+00, 5.0484764958E+00, 2.2462916685E+00, 9.0008718664E-01],
	[2.8140000000E+04, 1.8850140114E+01, 5.1537315303E+00, 5.0513725720E+00, 2.2469377121E+00, 9.0013435504E-01],
	[2.8145000000E+04, 1.8855590023E+01, 5.1537074735E+00, 5.0542697936E+00, 2.2475836610E+00, 9.0018150081E-01],
	[2.8150000000E+04, 1.8861040540E+01, 5.1536834211E+00, 5.0571681610E+00, 2.2482295154E+00, 9.0022862398E-01],
	[2.8155000000E+04, 1.8866491663E+01, 5.1536593730E+00, 5.0600676744E+00, 2.2488752751E+00, 9.0027572455E-01],
	[2.8160000000E+04, 1.8871943393E+01, 5.1536353294E+00, 5.0629683341E+00, 2.2495209400E+00, 9.0032280253E-01],
	[2.8165000000E+04, 1.8877395730E+01, 5.1536112901E+00, 5.0658701403E+00, 2.2501665101E+00, 9.0036985796E-01],
	[2.8170000000E+04, 1.8882848675E+01, 5.1535872553E+00, 5.0687730932E+00, 2.2508119853E+00, 9.0041689086E-01],
	[2.8175000000E+04, 1.8888302226E+01, 5.1535632248E+00, 5.0716771931E+00, 2.2514573656E+00, 9.0046390124E-01],
	[2.8180000000E+04, 1.8893756384E+01, 5.1535391986E+00, 5.0745824403E+00, 2.2521026510E+00, 9.0051088911E-01],
	[2.8185000000E+04, 1.8899211149E+01, 5.1535151769E+00, 5.0774888350E+00, 2.2527478412E+00, 9.0055785447E-01],
	[2.8190000000E+04, 1.8904666521E+01, 5.1534911595E+00, 5.0803963774E+00, 2.2533929364E+00, 9.0060479734E-01],
	[2.8195000000E+04, 1.8910122499E+01, 5.1534671465E+00, 5.0833050678E+00, 2.2540379364E+00, 9.0065171771E-01],
	[2.8200000000E+04, 1.8915579085E+01, 5.1534431378E+00, 5.0862149065E+00, 2.2546828411E+00, 9.0069861561E-01],
	[2.8205000000E+04, 1.8921036277E+01, 5.1534191336E+00, 5.0891258937E+00, 2.2553276506E+00, 9.0074549104E-01],
	[2.8210000000E+04, 1.8926494075E+01, 5.1533951337E+00, 5.0920380296E+00, 2.2559723648E+00, 9.0079234401E-01],
	[2.8215000000E+04, 1.8931952481E+01, 5.1533711381E+00, 5.0949513145E+00, 2.2566169835E+00, 9.0083917452E-01],
	[2.8220000000E+04, 1.8937411493E+01, 5.1533471470E+00, 5.0978657487E+00, 2.2572615068E+00, 9.0088598259E-01],
	[2.8225000000E+04, 1.8942871111E+01, 5.1533231601E+00, 5.1007813323E+00, 2.2579059345E+00, 9.0093276822E-01],
	[2.8230000000E+04, 1.8948331336E+01, 5.1532991777E+00, 5.1036980657E+00, 2.2585502667E+00, 9.0097953142E-01],
	[2.8235000000E+04, 1.8953792168E+01, 5.1532751996E+00, 5.1066159491E+00, 2.2591945032E+00, 9.0102627220E-01],
	[2.8240000000E+04, 1.8959253606E+01, 5.1532512259E+00, 5.1095349827E+00, 2.2598386440E+00, 9.0107299057E-01],
	[2.8245000000E+04, 1.8964715650E+01, 5.1532272565E+00, 5.1124551668E+00, 2.2604826890E+00, 9.0111968653E-01],
	[2.8250000000E+04, 1.8970178300E+01, 5.1532032914E+00, 5.1153765017E+00, 2.2611266383E+00, 9.0116636010E-01],
	[2.8255000000E+04, 1.8975641557E+01, 5.1531793308E+00, 5.1182989875E+00, 2.2617704916E+00, 9.0121301128E-01],
	[2.8260000000E+04, 1.8981105420E+01, 5.1531553744E+00, 5.1212226246E+00, 2.2624142491E+00, 9.0125964008E-01],
	[2.8265000000E+04, 1.8986569890E+01, 5.1531314225E+00, 5.1241474132E+00, 2.2630579105E+00, 9.0130624651E-01],
	[2.8270000000E+04, 1.8992034965E+01, 5.1531074748E+00, 5.1270733535E+00, 2.2637014759E+00, 9.0135283058E-01],
	[2.8275000000E+04, 1.8997500647E+01, 5.1530835316E+00, 5.1300004458E+00, 2.2643449452E+00, 9.0139939229E-01],
	[2.8280000000E+04, 1.9002966935E+01, 5.1530595926E+00, 5.1329286903E+00, 2.2649883183E+00, 9.0144593166E-01],
	[2.8285000000E+04, 1.9008433829E+01, 5.1530356580E+00, 5.1358580873E+00, 2.2656315951E+00, 9.0149244870E-01],
	[2.8290000000E+04, 1.9013901329E+01, 5.1530117278E+00, 5.1387886371E+00, 2.2662747757E+00, 9.0153894340E-01],
	[2.8295000000E+04, 1.9019369435E+01, 5.1529878019E+00, 5.1417203398E+00, 2.2669178599E+00, 9.0158541578E-01],
	[2.8300000000E+04, 1.9024838147E+01, 5.1529638803E+00, 5.1446531957E+00, 2.2675608478E+00, 9.0163186586E-01],
	[2.8305000000E+04, 1.9030307464E+01, 5.1529399631E+00, 5.1475872052E+00, 2.2682037392E+00, 9.0167829362E-01],
	[2.8310000000E+04, 1.9035777388E+01, 5.1529160502E+00, 5.1505223683E+00, 2.2688465340E+00, 9.0172469910E-01],
	[2.8315000000E+04, 1.9041247917E+01, 5.1528921416E+00, 5.1534586855E+00, 2.2694892323E+00, 9.0177108229E-01],
	[2.8320000000E+04, 1.9046719053E+01, 5.1528682374E+00, 5.1563961568E+00, 2.2701318340E+00, 9.0181744320E-01],
	[2.8325000000E+04, 1.9052190794E+01, 5.1528443375E+00, 5.1593347827E+00, 2.2707743389E+00, 9.0186378184E-01],
	[2.8330000000E+04, 1.9057663140E+01, 5.1528204419E+00, 5.1622745633E+00, 2.2714167471E+00, 9.0191009821E-01],
	[2.8335000000E+04, 1.9063136093E+01, 5.1527965507E+00, 5.1652154988E+00, 2.2720590585E+00, 9.0195639234E-01],
	[2.8340000000E+04, 1.9068609651E+01, 5.1527726637E+00, 5.1681575896E+00, 2.2727012731E+00, 9.0200266422E-01],
	[2.8345000000E+04, 1.9074083814E+01, 5.1527487812E+00, 5.1711008358E+00, 2.2733433907E+00, 9.0204891387E-01],
	[2.8350000000E+04, 1.9079558583E+01, 5.1527249029E+00, 5.1740452378E+00, 2.2739854113E+00, 9.0209514129E-01],
	[2.8355000000E+04, 1.9085033958E+01, 5.1527010289E+00, 5.1769907958E+00, 2.2746273349E+00, 9.0214134649E-01],
	[2.8360000000E+04, 1.9090509938E+01, 5.1526771593E+00, 5.1799375099E+00, 2.2752691615E+00, 9.0218752948E-01],
	[2.8365000000E+04, 1.9095986523E+01, 5.1526532940E+00, 5.1828853806E+00, 2.2759108908E+00, 9.0223369027E-01],
	[2.8370000000E+04, 1.9101463714E+01, 5.1526294330E+00, 5.1858344079E+00, 2.2765525230E+00, 9.0227982887E-01],
	[2.8375000000E+04, 1.9106941511E+01, 5.1526055763E+00, 5.1887845923E+00, 2.2771940579E+00, 9.0232594528E-01],
	[2.8380000000E+04, 1.9112419912E+01, 5.1525817240E+00, 5.1917359338E+00, 2.2778354954E+00, 9.0237203951E-01],
	[2.8385000000E+04, 1.9117898919E+01, 5.1525578759E+00, 5.1946884329E+00, 2.2784768356E+00, 9.0241811158E-01],
	[2.8390000000E+04, 1.9123378531E+01, 5.1525340322E+00, 5.1976420896E+00, 2.2791180784E+00, 9.0246416149E-01],
	[2.8395000000E+04, 1.9128858748E+01, 5.1525101927E+00, 5.2005969043E+00, 2.2797592237E+00, 9.0251018924E-01],
	[2.8400000000E+04, 1.9134339570E+01, 5.1524863576E+00, 5.2035528772E+00, 2.2804002714E+00, 9.0255619486E-01],
	[2.8405000000E+04, 1.9139820998E+01, 5.1524625268E+00, 5.2065100086E+00, 2.2810412215E+00, 9.0260217834E-01],
	[2.8410000000E+04, 1.9145303031E+01, 5.1524387003E+00, 5.2094682988E+00, 2.2816820739E+00, 9.0264813970E-01],
	[2.8415000000E+04, 1.9150785668E+01, 5.1524148781E+00, 5.2124277479E+00, 2.2823228287E+00, 9.0269407894E-01],
	[2.8420000000E+04, 1.9156268911E+01, 5.1523910602E+00, 5.2153883562E+00, 2.2829634856E+00, 9.0273999607E-01],
	[2.8425000000E+04, 1.9161752758E+01, 5.1523672466E+00, 5.2183501239E+00, 2.2836040448E+00, 9.0278589110E-01],
	[2.8430000000E+04, 1.9167237211E+01, 5.1523434373E+00, 5.2213130514E+00, 2.2842445060E+00, 9.0283176404E-01],
	[2.8435000000E+04, 1.9172722268E+01, 5.1523196322E+00, 5.2242771388E+00, 2.2848848693E+00, 9.0287761490E-01],
	[2.8440000000E+04, 1.9178207930E+01, 5.1522958315E+00, 5.2272423865E+00, 2.2855251346E+00, 9.0292344369E-01],
	[2.8445000000E+04, 1.9183694197E+01, 5.1522720351E+00, 5.2302087946E+00, 2.2861653019E+00, 9.0296925041E-01],
	[2.8450000000E+04, 1.9189181069E+01, 5.1522482430E+00, 5.2331763635E+00, 2.2868053710E+00, 9.0301503507E-01],
	[2.8455000000E+04, 1.9194668545E+01, 5.1522244551E+00, 5.2361450933E+00, 2.2874453420E+00, 9.0306079768E-01],
	[2.8460000000E+04, 1.9200156626E+01, 5.1522006716E+00, 5.2391149843E+00, 2.2880852147E+00, 9.0310653826E-01],
	[2.8465000000E+04, 1.9205645312E+01, 5.1521768923E+00, 5.2420860367E+00, 2.2887249892E+00, 9.0315225681E-01],
	[2.8470000000E+04, 1.9211134602E+01, 5.1521531173E+00, 5.2450582509E+00, 2.2893646653E+00, 9.0319795333E-01],
	[2.8475000000E+04, 1.9216624497E+01, 5.1521293467E+00, 5.2480316271E+00, 2.2900042431E+00, 9.0324362784E-01],
	[2.8480000000E+04, 1.9222114996E+01, 5.1521055802E+00, 5.2510061654E+00, 2.2906437224E+00, 9.0328928034E-01],
	[2.8485000000E+04, 1.9227606100E+01, 5.1520818181E+00, 5.2539818662E+00, 2.2912831032E+00, 9.0333491085E-01],
	[2.8490000000E+04, 1.9233097808E+01, 5.1520580603E+00, 5.2569587298E+00, 2.2919223855E+00, 9.0338051937E-01],
	[2.8495000000E+04, 1.9238590121E+01, 5.1520343067E+00, 5.2599367562E+00, 2.2925615691E+00, 9.0342610591E-01],
	[2.8500000000E+04, 1.9244083038E+01, 5.1520105574E+00, 5.2629159459E+00, 2.2932006541E+00, 9.0347167048E-01],
	[2.8505000000E+04, 1.9249576559E+01, 5.1519868124E+00, 5.2658962991E+00, 2.2938396403E+00, 9.0351721308E-01],
	[2.8510000000E+04, 1.9255076823E+01, 5.1519640293E+00, 5.2688778159E+00, 2.2944788049E+00, 9.0356273374E-01],
	[2.8515000000E+04, 1.9260593019E+01, 5.1519436409E+00, 5.2718604968E+00, 2.2951185629E+00, 9.0360823245E-01],
	[2.8520000000E+04, 1.9266109827E+01, 5.1519232561E+00, 5.2748443418E+00, 2.2957582228E+00, 9.0365370922E-01],
	[2.8525000000E+04, 1.9271627249E+01, 5.1519028749E+00, 5.2778293513E+00, 2.2963977845E+00, 9.0369916406E-01],
	[2.8530000000E+04, 1.9277145283E+01, 5.1518824975E+00, 5.2808155255E+00, 2.2970372479E+00, 9.0374459699E-01],
	[2.8535000000E+04, 1.9282663930E+01, 5.1518621236E+00, 5.2838028646E+00, 2.2976766130E+00, 9.0379000801E-01],
	[2.8540000000E+04, 1.9288183189E+01, 5.1518417534E+00, 5.2867913690E+00, 2.2983158797E+00, 9.0383539712E-01],
	[2.8545000000E+04, 1.9293703060E+01, 5.1518213869E+00, 5.2897810388E+00, 2.2989550480E+00, 9.0388076434E-01],
	[2.8550000000E+04, 1.9299223545E+01, 5.1518010240E+00, 5.2927718743E+00, 2.2995941179E+00, 9.0392610968E-01],
	[2.8555000000E+04, 1.9304744641E+01, 5.1517806648E+00, 5.2957638758E+00, 2.3002330892E+00, 9.0397143314E-01],
	[2.8560000000E+04, 1.9310266350E+01, 5.1517603092E+00, 5.2987570434E+00, 2.3008719619E+00, 9.0401673474E-01],
	[2.8565000000E+04, 1.9315788671E+01, 5.1517399572E+00, 5.3017513776E+00, 2.3015107361E+00, 9.0406201448E-01],
	[2.8570000000E+04, 1.9321311605E+01, 5.1517196089E+00, 5.3047468784E+00, 2.3021494115E+00, 9.0410727236E-01],
	[2.8575000000E+04, 1.9326835151E+01, 5.1516992642E+00, 5.3077435462E+00, 2.3027879881E+00, 9.0415250841E-01],
	[2.8580000000E+04, 1.9332359309E+01, 5.1516789232E+00, 5.3107413812E+00, 2.3034264660E+00, 9.0419772262E-01],
	[2.8585000000E+04, 1.9337884079E+01, 5.1516585858E+00, 5.3137403836E+00, 2.3040648450E+00, 9.0424291501E-01],
	[2.8590000000E+04, 1.9343409462E+01, 5.1516382520E+00, 5.3167405538E+00, 2.3047031251E+00, 9.0428808559E-01],
	[2.8595000000E+04, 1.9348935457E+01, 5.1516179219E+00, 5.3197418919E+00, 2.3053413063E+00, 9.0433323436E-01],
	[2.8600000000E+04, 1.9354462063E+01, 5.1515975954E+00, 5.3227443982E+00, 2.3059793884E+00, 9.0437836133E-01],
	[2.8605000000E+04, 1.9359989282E+01, 5.1515772726E+00, 5.3257480730E+00, 2.3066173715E+00, 9.0442346652E-01],
	[2.8610000000E+04, 1.9365517113E+01, 5.1515569533E+00, 5.3287529164E+00, 2.3072552554E+00, 9.0446854992E-01],
	[2.8615000000E+04, 1.9371045555E+01, 5.1515366377E+00, 5.3317589288E+00, 2.3078930402E+00, 9.0451361155E-01],
	[2.8620000000E+04, 1.9376574610E+01, 5.1515163258E+00, 5.3347661105E+00, 2.3085307257E+00, 9.0455865142E-01],
	[2.8625000000E+04, 1.9382104276E+01, 5.1514960175E+00, 5.3377744615E+00, 2.3091683119E+00, 9.0460366954E-01],
	[2.8630000000E+04, 1.9387634555E+01, 5.1514757127E+00, 5.3407839823E+00, 2.3098057988E+00, 9.0464866591E-01],
	[2.8635000000E+04, 1.9393165445E+01, 5.1514554117E+00, 5.3437946731E+00, 2.3104431864E+00, 9.0469364054E-01],
	[2.8640000000E+04, 1.9398696947E+01, 5.1514351142E+00, 5.3468065340E+00, 2.3110804744E+00, 9.0473859345E-01],
	[2.8645000000E+04, 1.9404229060E+01, 5.1514148204E+00, 5.3498195654E+00, 2.3117176630E+00, 9.0478352464E-01],
	[2.8650000000E+04, 1.9409761786E+01, 5.1513945302E+00, 5.3528337675E+00, 2.3123547521E+00, 9.0482843411E-01],
	[2.8655000000E+04, 1.9415295122E+01, 5.1513742436E+00, 5.3558491405E+00, 2.3129917415E+00, 9.0487332189E-01],
	[2.8660000000E+04, 1.9420829071E+01, 5.1513539606E+00, 5.3588656848E+00, 2.3136286312E+00, 9.0491818797E-01],
	[2.8665000000E+04, 1.9426363631E+01, 5.1513336813E+00, 5.3618834004E+00, 2.3142654213E+00, 9.0496303237E-01],
	[2.8670000000E+04, 1.9431898803E+01, 5.1513134055E+00, 5.3649022878E+00, 2.3149021116E+00, 9.0500785510E-01],
	[2.8675000000E+04, 1.9437434586E+01, 5.1512931334E+00, 5.3679223472E+00, 2.3155387021E+00, 9.0505265616E-01],
	[2.8680000000E+04, 1.9442970980E+01, 5.1512728649E+00, 5.3709435787E+00, 2.3161751927E+00, 9.0509743556E-01],
	[2.8685000000E+04, 1.9448507986E+01, 5.1512526000E+00, 5.3739659828E+00, 2.3168115834E+00, 9.0514219331E-01],
	[2.8690000000E+04, 1.9454045604E+01, 5.1512323387E+00, 5.3769895595E+00, 2.3174478741E+00, 9.0518692942E-01],
	[2.8695000000E+04, 1.9459583832E+01, 5.1512120811E+00, 5.3800143091E+00, 2.3180840648E+00, 9.0523164390E-01],
	[2.8700000000E+04, 1.9465122672E+01, 5.1511918270E+00, 5.3830402320E+00, 2.3187201554E+00, 9.0527633676E-01],
	[2.8705000000E+04, 1.9470662124E+01, 5.1511715765E+00, 5.3860673283E+00, 2.3193561459E+00, 9.0532100800E-01],
	[2.8710000000E+04, 1.9476202186E+01, 5.1511513297E+00, 5.3890955983E+00, 2.3199920362E+00, 9.0536565764E-01],
	[2.8715000000E+04, 1.9481742860E+01, 5.1511310865E+00, 5.3921250423E+00, 2.3206278263E+00, 9.0541028568E-01],
	[2.8720000000E+04, 1.9487284144E+01, 5.1511108468E+00, 5.3951556604E+00, 2.3212635160E+00, 9.0545489214E-01],
	[2.8725000000E+04, 1.9492826040E+01, 5.1510906108E+00, 5.3981874531E+00, 2.3218991055E+00, 9.0549947701E-01],
	[2.8730000000E+04, 1.9498368547E+01, 5.1510703783E+00, 5.4012204204E+00, 2.3225345945E+00, 9.0554404032E-01],
	[2.8735000000E+04, 1.9503911665E+01, 5.1510501495E+00, 5.4042545627E+00, 2.3231699831E+00, 9.0558858207E-01],
	[2.8740000000E+04, 1.9509455394E+01, 5.1510299243E+00, 5.4072898801E+00, 2.3238052712E+00, 9.0563310226E-01],
	[2.8745000000E+04, 1.9514999734E+01, 5.1510097026E+00, 5.4103263731E+00, 2.3244404588E+00, 9.0567760091E-01],
	[2.8750000000E+04, 1.9520544685E+01, 5.1509894846E+00, 5.4133640417E+00, 2.3250755457E+00, 9.0572207803E-01],
	[2.8755000000E+04, 1.9526090246E+01, 5.1509692702E+00, 5.4164028863E+00, 2.3257105320E+00, 9.0576653362E-01],
	[2.8760000000E+04, 1.9531636419E+01, 5.1509490593E+00, 5.4194429071E+00, 2.3263454176E+00, 9.0581096769E-01],
	[2.8765000000E+04, 1.9537183202E+01, 5.1509288521E+00, 5.4224841043E+00, 2.3269802025E+00, 9.0585538025E-01],
	[2.8770000000E+04, 1.9542730596E+01, 5.1509086484E+00, 5.4255264783E+00, 2.3276148865E+00, 9.0589977132E-01],
	[2.8775000000E+04, 1.9548278600E+01, 5.1508884483E+00, 5.4285700292E+00, 2.3282494697E+00, 9.0594414090E-01],
	[2.8780000000E+04, 1.9553827216E+01, 5.1508682518E+00, 5.4316147573E+00, 2.3288839520E+00, 9.0598848899E-01],
	[2.8785000000E+04, 1.9559376442E+01, 5.1508480589E+00, 5.4346606628E+00, 2.3295183333E+00, 9.0603281561E-01],
	[2.8790000000E+04, 1.9564926278E+01, 5.1508278696E+00, 5.4377077461E+00, 2.3301526136E+00, 9.0607712077E-01],
	[2.8795000000E+04, 1.9570476726E+01, 5.1508076839E+00, 5.4407560073E+00, 2.3307867928E+00, 9.0612140447E-01],
	[2.8800000000E+04, 1.9576027783E+01, 5.1507875017E+00, 5.4438054467E+00, 2.3314208709E+00, 9.0616566673E-01],
	[2.8805000000E+04, 1.9581579451E+01, 5.1507673232E+00, 5.4468560646E+00, 2.3320548479E+00, 9.0620990754E-01],
	[2.8810000000E+04, 1.9587131730E+01, 5.1507471482E+00, 5.4499078612E+00, 2.3326887236E+00, 9.0625412693E-01],
	[2.8815000000E+04, 1.9592684619E+01, 5.1507269768E+00, 5.4529608367E+00, 2.3333224981E+00, 9.0629832490E-01],
	[2.8820000000E+04, 1.9598238118E+01, 5.1507068090E+00, 5.4560149915E+00, 2.3339561713E+00, 9.0634250146E-01],
	[2.8825000000E+04, 1.9603792228E+01, 5.1506866447E+00, 5.4590703257E+00, 2.3345897431E+00, 9.0638665662E-01],
	[2.8830000000E+04, 1.9609346948E+01, 5.1506664841E+00, 5.4621268396E+00, 2.3352232134E+00, 9.0643079039E-01],
	[2.8835000000E+04, 1.9614902278E+01, 5.1506463270E+00, 5.4651845334E+00, 2.3358565823E+00, 9.0647490277E-01],
	[2.8840000000E+04, 1.9620458218E+01, 5.1506261735E+00, 5.4682434075E+00, 2.3364898497E+00, 9.0651899377E-01],
	[2.8845000000E+04, 1.9626014769E+01, 5.1506060235E+00, 5.4713034620E+00, 2.3371230155E+00, 9.0656306341E-01],
	[2.8850000000E+04, 1.9631571929E+01, 5.1505858771E+00, 5.4743646972E+00, 2.3377560797E+00, 9.0660711169E-01],
	[2.8855000000E+04, 1.9637129700E+01, 5.1505657343E+00, 5.4774271134E+00, 2.3383890422E+00, 9.0665113862E-01],
	[2.8860000000E+04, 1.9642688081E+01, 5.1505455951E+00, 5.4804907108E+00, 2.3390219030E+00, 9.0669514422E-01],
	[2.8865000000E+04, 1.9648247072E+01, 5.1505254594E+00, 5.4835554897E+00, 2.3396546620E+00, 9.0673912848E-01],
	[2.8870000000E+04, 1.9653806672E+01, 5.1505053273E+00, 5.4866214502E+00, 2.3402873192E+00, 9.0678309142E-01],
	[2.8875000000E+04, 1.9659366883E+01, 5.1504851988E+00, 5.4896885928E+00, 2.3409198745E+00, 9.0682703305E-01],
	[2.8880000000E+04, 1.9664927704E+01, 5.1504650738E+00, 5.4927569175E+00, 2.3415523279E+00, 9.0687095337E-01],
	[2.8885000000E+04, 1.9670489134E+01, 5.1504449524E+00, 5.4958264247E+00, 2.3421846793E+00, 9.0691485240E-01],
	[2.8890000000E+04, 1.9676051174E+01, 5.1504248346E+00, 5.4988971146E+00, 2.3428169287E+00, 9.0695873014E-01],
	[2.8895000000E+04, 1.9681613824E+01, 5.1504047203E+00, 5.5019689874E+00, 2.3434490761E+00, 9.0700258660E-01],
	[2.8900000000E+04, 1.9687177084E+01, 5.1503846095E+00, 5.5050420435E+00, 2.3440811213E+00, 9.0704642179E-01],
	[2.8905000000E+04, 1.9692740954E+01, 5.1503645024E+00, 5.5081162830E+00, 2.3447130643E+00, 9.0709023573E-01],
	[2.8910000000E+04, 1.9698305433E+01, 5.1503443988E+00, 5.5111917063E+00, 2.3453449051E+00, 9.0713402841E-01],
	[2.8915000000E+04, 1.9703870522E+01, 5.1503242987E+00, 5.5142683135E+00, 2.3459766437E+00, 9.0717779986E-01],
	[2.8920000000E+04, 1.9709436220E+01, 5.1503042022E+00, 5.5173461049E+00, 2.3466082799E+00, 9.0722155007E-01],
	[2.8925000000E+04, 1.9715002528E+01, 5.1502841092E+00, 5.5204250807E+00, 2.3472398137E+00, 9.0726527905E-01],
	[2.8930000000E+04, 1.9720569445E+01, 5.1502640198E+00, 5.5235052413E+00, 2.3478712452E+00, 9.0730898682E-01],
	[2.8935000000E+04, 1.9726136972E+01, 5.1502439340E+00, 5.5265865869E+00, 2.3485025741E+00, 9.0735267339E-01],
	[2.8940000000E+04, 1.9731705108E+01, 5.1502238517E+00, 5.5296691176E+00, 2.3491338006E+00, 9.0739633875E-01],
	[2.8945000000E+04, 1.9737273854E+01, 5.1502037729E+00, 5.5327528339E+00, 2.3497649245E+00, 9.0743998293E-01],
	[2.8950000000E+04, 1.9742843209E+01, 5.1501836977E+00, 5.5358377358E+00, 2.3503959457E+00, 9.0748360593E-01],
	[2.8955000000E+04, 1.9748413174E+01, 5.1501636260E+00, 5.5389238237E+00, 2.3510268643E+00, 9.0752720776E-01],
	[2.8960000000E+04, 1.9753983747E+01, 5.1501435579E+00, 5.5420110979E+00, 2.3516576802E+00, 9.0757078843E-01],
	[2.8965000000E+04, 1.9759554930E+01, 5.1501234933E+00, 5.5450995585E+00, 2.3522883933E+00, 9.0761434795E-01],
	[2.8970000000E+04, 1.9765137324E+01, 5.1501050647E+00, 5.5481892058E+00, 2.3529194946E+00, 9.0765788632E-01],
	[2.8975000000E+04, 1.9770731100E+01, 5.1500882968E+00, 5.5512800400E+00, 2.3535509922E+00, 9.0770140356E-01],
	[2.8980000000E+04, 1.9776325492E+01, 5.1500715318E+00, 5.5543720615E+00, 2.3541823875E+00, 9.0774489967E-01],
	[2.8985000000E+04, 1.9781920503E+01, 5.1500547698E+00, 5.5574652705E+00, 2.3548136806E+00, 9.0778837466E-01],
	[2.8990000000E+04, 1.9787516130E+01, 5.1500380107E+00, 5.5605596672E+00, 2.3554448714E+00, 9.0783182855E-01],
	[2.8995000000E+04, 1.9793112376E+01, 5.1500212545E+00, 5.5636552518E+00, 2.3560759599E+00, 9.0787526134E-01],
	[2.9000000000E+04, 1.9798709238E+01, 5.1500045013E+00, 5.5667520247E+00, 2.3567069461E+00, 9.0791867304E-01],
	[2.9005000000E+04, 1.9804306718E+01, 5.1499877510E+00, 5.5698499861E+00, 2.3573378298E+00, 9.0796206366E-01],
	[2.9010000000E+04, 1.9809904815E+01, 5.1499710037E+00, 5.5729491361E+00, 2.3579686110E+00, 9.0800543320E-01],
	[2.9015000000E+04, 1.9815503529E+01, 5.1499542593E+00, 5.5760494752E+00, 2.3585992897E+00, 9.0804878169E-01],
	[2.9020000000E+04, 1.9821102860E+01, 5.1499375179E+00, 5.5791510034E+00, 2.3592298658E+00, 9.0809210912E-01],
	[2.9025000000E+04, 1.9826702809E+01, 5.1499207794E+00, 5.5822537212E+00, 2.3598603393E+00, 9.0813541550E-01],
	[2.9030000000E+04, 1.9832303375E+01, 5.1499040438E+00, 5.5853576286E+00, 2.3604907101E+00, 9.0817870085E-01],
	[2.9035000000E+04, 1.9837904558E+01, 5.1498873112E+00, 5.5884627260E+00, 2.3611209782E+00, 9.0822196517E-01],
	[2.9040000000E+04, 1.9843506357E+01, 5.1498705815E+00, 5.5915690137E+00, 2.3617511436E+00, 9.0826520848E-01],
	[2.9045000000E+04, 1.9849108774E+01, 5.1498538548E+00, 5.5946764918E+00, 2.3623812061E+00, 9.0830843077E-01],
	[2.9050000000E+04, 1.9854711808E+01, 5.1498371309E+00, 5.5977851607E+00, 2.3630111658E+00, 9.0835163207E-01],
	[2.9055000000E+04, 1.9860315459E+01, 5.1498204100E+00, 5.6008950205E+00, 2.3636410225E+00, 9.0839481237E-01],
	[2.9060000000E+04, 1.9865919727E+01, 5.1498036921E+00, 5.6040060716E+00, 2.3642707763E+00, 9.0843797169E-01],
	[2.9065000000E+04, 1.9871524611E+01, 5.1497869771E+00, 5.6071183141E+00, 2.3649004272E+00, 9.0848111004E-01],
	[2.9070000000E+04, 1.9877130112E+01, 5.1497702650E+00, 5.6102317484E+00, 2.3655299749E+00, 9.0852422743E-01],
	[2.9075000000E+04, 1.9882736231E+01, 5.1497535558E+00, 5.6133463747E+00, 2.3661594196E+00, 9.0856732386E-01],
	[2.9080000000E+04, 1.9888342965E+01, 5.1497368495E+00, 5.6164621932E+00, 2.3667887611E+00, 9.0861039934E-01],
	[2.9085000000E+04, 1.9893950317E+01, 5.1497201462E+00, 5.6195792041E+00, 2.3674179994E+00, 9.0865345389E-01],
	[2.9090000000E+04, 1.9899558285E+01, 5.1497034458E+00, 5.6226974078E+00, 2.3680471345E+00, 9.0869648751E-01],
	[2.9095000000E+04, 1.9905166870E+01, 5.1496867484E+00, 5.6258168045E+00, 2.3686761663E+00, 9.0873950021E-01],
	[2.9100000000E+04, 1.9910776071E+01, 5.1496700538E+00, 5.6289373944E+00, 2.3693050947E+00, 9.0878249200E-01],
	[2.9105000000E+04, 1.9916385889E+01, 5.1496533622E+00, 5.6320591778E+00, 2.3699339198E+00, 9.0882546289E-01],
	[2.9110000000E+04, 1.9921996324E+01, 5.1496366735E+00, 5.6351821550E+00, 2.3705626414E+00, 9.0886841288E-01],
	[2.9115000000E+04, 1.9927607375E+01, 5.1496199877E+00, 5.6383063261E+00, 2.3711912596E+00, 9.0891134200E-01],
	[2.9120000000E+04, 1.9933219042E+01, 5.1496033048E+00, 5.6414316914E+00, 2.3718197742E+00, 9.0895425024E-01],
	[2.9125000000E+04, 1.9938831326E+01, 5.1495866249E+00, 5.6445582513E+00, 2.3724481853E+00, 9.0899713761E-01],
	[2.9130000000E+04, 1.9944444226E+01, 5.1495699479E+00, 5.6476860059E+00, 2.3730764927E+00, 9.0904000413E-01],
	[2.9135000000E+04, 1.9950057742E+01, 5.1495532738E+00, 5.6508149555E+00, 2.3737046965E+00, 9.0908284981E-01],
	[2.9140000000E+04, 1.9955671875E+01, 5.1495366026E+00, 5.6539451003E+00, 2.3743327966E+00, 9.0912567464E-01],
	[2.9145000000E+04, 1.9961286624E+01, 5.1495199343E+00, 5.6570764406E+00, 2.3749607929E+00, 9.0916847865E-01],
	[2.9150000000E+04, 1.9966901989E+01, 5.1495032689E+00, 5.6602089766E+00, 2.3755886855E+00, 9.0921126184E-01],
	[2.9155000000E+04, 1.9972517971E+01, 5.1494866065E+00, 5.6633427087E+00, 2.3762164741E+00, 9.0925402421E-01],
	[2.9160000000E+04, 1.9978134568E+01, 5.1494699469E+00, 5.6664776370E+00, 2.3768441589E+00, 9.0929676579E-01],
	[2.9165000000E+04, 1.9983751782E+01, 5.1494532903E+00, 5.6696137617E+00, 2.3774717397E+00, 9.0933948657E-01],
	[2.9170000000E+04, 1.9989369611E+01, 5.1494366366E+00, 5.6727510833E+00, 2.3780992166E+00, 9.0938218657E-01],
	[2.9175000000E+04, 1.9994988057E+01, 5.1494199857E+00, 5.6758896018E+00, 2.3787265894E+00, 9.0942486579E-01],
	[2.9180000000E+04, 2.0000607118E+01, 5.1494033378E+00, 5.6790293176E+00, 2.3793538581E+00, 9.0946752425E-01],
	[2.9185000000E+04, 2.0006226796E+01, 5.1493866928E+00, 5.6821702308E+00, 2.3799810227E+00, 9.0951016195E-01],
	[2.9190000000E+04, 2.0011847089E+01, 5.1493700507E+00, 5.6853123419E+00, 2.3806080831E+00, 9.0955277891E-01],
	[2.9195000000E+04, 2.0017467999E+01, 5.1493534115E+00, 5.6884556509E+00, 2.3812350393E+00, 9.0959537513E-01],
	[2.9200000000E+04, 2.0023089524E+01, 5.1493367752E+00, 5.6916001582E+00, 2.3818618913E+00, 9.0963795061E-01],
	[2.9205000000E+04, 2.0028711665E+01, 5.1493201419E+00, 5.6947458639E+00, 2.3824886389E+00, 9.0968050538E-01],
	[2.9210000000E+04, 2.0034334421E+01, 5.1493035114E+00, 5.6978927685E+00, 2.3831152822E+00, 9.0972303944E-01],
	[2.9215000000E+04, 2.0039957794E+01, 5.1492868838E+00, 5.7010408720E+00, 2.3837418210E+00, 9.0976555279E-01],
	[2.9220000000E+04, 2.0045581782E+01, 5.1492702591E+00, 5.7041901748E+00, 2.3843682555E+00, 9.0980804545E-01],
	[2.9225000000E+04, 2.0051206385E+01, 5.1492536373E+00, 5.7073406771E+00, 2.3849945854E+00, 9.0985051743E-01],
	[2.9230000000E+04, 2.0056831605E+01, 5.1492370184E+00, 5.7104923791E+00, 2.3856208108E+00, 9.0989296873E-01],
	[2.9235000000E+04, 2.0062457439E+01, 5.1492204024E+00, 5.7136452812E+00, 2.3862469316E+00, 9.0993539937E-01],
	[2.9240000000E+04, 2.0068083890E+01, 5.1492037893E+00, 5.7167993835E+00, 2.3868729478E+00, 9.0997780935E-01],
	[2.9245000000E+04, 2.0073710956E+01, 5.1491871791E+00, 5.7199546863E+00, 2.3874988593E+00, 9.1002019868E-01],
	[2.9250000000E+04, 2.0079338637E+01, 5.1491705718E+00, 5.7231111899E+00, 2.3881246661E+00, 9.1006256738E-01],
	[2.9255000000E+04, 2.0084966933E+01, 5.1491539674E+00, 5.7262688945E+00, 2.3887503681E+00, 9.1010491544E-01],
	[2.9260000000E+04, 2.0090595845E+01, 5.1491373658E+00, 5.7294278004E+00, 2.3893759653E+00, 9.1014724288E-01],
	[2.9265000000E+04, 2.0096225373E+01, 5.1491207672E+00, 5.7325879078E+00, 2.3900014576E+00, 9.1018954972E-01],
	[2.9270000000E+04, 2.0101855515E+01, 5.1491041715E+00, 5.7357492169E+00, 2.3906268451E+00, 9.1023183595E-01],
	[2.9275000000E+04, 2.0107486273E+01, 5.1490875786E+00, 5.7389117281E+00, 2.3912521276E+00, 9.1027410158E-01],
	[2.9280000000E+04, 2.0113117647E+01, 5.1490709886E+00, 5.7420754415E+00, 2.3918773051E+00, 9.1031634664E-01],
	[2.9285000000E+04, 2.0118749635E+01, 5.1490544015E+00, 5.7452403575E+00, 2.3925023776E+00, 9.1035857112E-01],
	[2.9290000000E+04, 2.0124382238E+01, 5.1490378173E+00, 5.7484064762E+00, 2.3931273450E+00, 9.1040077503E-01],
	[2.9295000000E+04, 2.0130015457E+01, 5.1490212360E+00, 5.7515737979E+00, 2.3937522073E+00, 9.1044295838E-01],
	[2.9300000000E+04, 2.0135649290E+01, 5.1490046576E+00, 5.7547423229E+00, 2.3943769644E+00, 9.1048512119E-01],
	[2.9305000000E+04, 2.0141283739E+01, 5.1489880820E+00, 5.7579120515E+00, 2.3950016163E+00, 9.1052726346E-01],
	[2.9310000000E+04, 2.0146918803E+01, 5.1489715093E+00, 5.7610829838E+00, 2.3956261630E+00, 9.1056938520E-01],
	[2.9315000000E+04, 2.0152554481E+01, 5.1489549395E+00, 5.7642551201E+00, 2.3962506043E+00, 9.1061148642E-01],
	[2.9320000000E+04, 2.0158190775E+01, 5.1489383726E+00, 5.7674284607E+00, 2.3968749403E+00, 9.1065356712E-01],
	[2.9325000000E+04, 2.0163827683E+01, 5.1489218086E+00, 5.7706030059E+00, 2.3974991709E+00, 9.1069562733E-01],
	[2.9330000000E+04, 2.0169465206E+01, 5.1489052474E+00, 5.7737787558E+00, 2.3981232961E+00, 9.1073766704E-01],
	[2.9335000000E+04, 2.0175103344E+01, 5.1488886891E+00, 5.7769557108E+00, 2.3987473158E+00, 9.1077968627E-01],
	[2.9340000000E+04, 2.0180742097E+01, 5.1488721337E+00, 5.7801338710E+00, 2.3993712300E+00, 9.1082168502E-01],
	[2.9345000000E+04, 2.0186381465E+01, 5.1488555812E+00, 5.7833132368E+00, 2.3999950386E+00, 9.1086366331E-01],
	[2.9350000000E+04, 2.0192021447E+01, 5.1488390315E+00, 5.7864938083E+00, 2.4006187416E+00, 9.1090562114E-01],
	[2.9355000000E+04, 2.0197662044E+01, 5.1488224848E+00, 5.7896755859E+00, 2.4012423389E+00, 9.1094755852E-01],
	[2.9360000000E+04, 2.0203303255E+01, 5.1488059408E+00, 5.7928585698E+00, 2.4018658306E+00, 9.1098947547E-01],
	[2.9365000000E+04, 2.0208945081E+01, 5.1487893998E+00, 5.7960427602E+00, 2.4024892165E+00, 9.1103137198E-01],
	[2.9370000000E+04, 2.0214587522E+01, 5.1487728616E+00, 5.7992281574E+00, 2.4031124966E+00, 9.1107324808E-01],
	[2.9375000000E+04, 2.0220230577E+01, 5.1487563263E+00, 5.8024147617E+00, 2.4037356709E+00, 9.1111510376E-01],
	[2.9380000000E+04, 2.0225874246E+01, 5.1487397939E+00, 5.8056025732E+00, 2.4043587393E+00, 9.1115693904E-01],
	[2.9385000000E+04, 2.0231518530E+01, 5.1487232643E+00, 5.8087915923E+00, 2.4049817018E+00, 9.1119875393E-01],
	[2.9390000000E+04, 2.0237163428E+01, 5.1487067376E+00, 5.8119818192E+00, 2.4056045584E+00, 9.1124054843E-01],
	[2.9395000000E+04, 2.0242808941E+01, 5.1486902137E+00, 5.8151732541E+00, 2.4062273089E+00, 9.1128232256E-01],
	[2.9400000000E+04, 2.0248455068E+01, 5.1486736928E+00, 5.8183658973E+00, 2.4068499534E+00, 9.1132407633E-01],
	[2.9405000000E+04, 2.0254101809E+01, 5.1486571746E+00, 5.8215597491E+00, 2.4074724919E+00, 9.1136580973E-01],
	[2.9410000000E+04, 2.0259749165E+01, 5.1486406594E+00, 5.8247548096E+00, 2.4080949241E+00, 9.1140752279E-01],
	[2.9415000000E+04, 2.0265397135E+01, 5.1486241470E+00, 5.8279510792E+00, 2.4087172503E+00, 9.1144921551E-01],
	[2.9420000000E+04, 2.0271045718E+01, 5.1486076375E+00, 5.8311485582E+00, 2.4093394702E+00, 9.1149088791E-01],
	[2.9425000000E+04, 2.0276694916E+01, 5.1485911308E+00, 5.8343472466E+00, 2.4099615838E+00, 9.1153253998E-01],
	[2.9430000000E+04, 2.0282344728E+01, 5.1485746270E+00, 5.8375471449E+00, 2.4105835911E+00, 9.1157417174E-01],
	[2.9435000000E+04, 2.0288000018E+01, 5.1485588652E+00, 5.8407482533E+00, 2.4112057229E+00, 9.1161578320E-01],
	[2.9440000000E+04, 2.0293672334E+01, 5.1485455997E+00, 5.8439505719E+00, 2.4118285275E+00, 9.1165737437E-01],
	[2.9445000000E+04, 2.0299345273E+01, 5.1485323365E+00, 5.8471541011E+00, 2.4124512264E+00, 9.1169894525E-01],
	[2.9450000000E+04, 2.0305018833E+01, 5.1485190755E+00, 5.8503588411E+00, 2.4130738194E+00, 9.1174049586E-01],
	[2.9455000000E+04, 2.0310693016E+01, 5.1485058169E+00, 5.8535647922E+00, 2.4136963067E+00, 9.1178202620E-01],
	[2.9460000000E+04, 2.0316367820E+01, 5.1484925605E+00, 5.8567719546E+00, 2.4143186881E+00, 9.1182353629E-01],
	[2.9465000000E+04, 2.0322043247E+01, 5.1484793064E+00, 5.8599803286E+00, 2.4149409636E+00, 9.1186502613E-01],
	[2.9470000000E+04, 2.0327719296E+01, 5.1484660546E+00, 5.8631899143E+00, 2.4155631332E+00, 9.1190649574E-01],
	[2.9475000000E+04, 2.0333395967E+01, 5.1484528051E+00, 5.8664007122E+00, 2.4161851968E+00, 9.1194794511E-01],
	[2.9480000000E+04, 2.0339073260E+01, 5.1484395578E+00, 5.8696127224E+00, 2.4168071544E+00, 9.1198937427E-01],
	[2.9485000000E+04, 2.0344751175E+01, 5.1484263129E+00, 5.8728259451E+00, 2.4174290059E+00, 9.1203078321E-01],
	[2.9490000000E+04, 2.0350429711E+01, 5.1484130702E+00, 5.8760403806E+00, 2.4180507514E+00, 9.1207217195E-01],
	[2.9495000000E+04, 2.0356108870E+01, 5.1483998298E+00, 5.8792560293E+00, 2.4186723906E+00, 9.1211354050E-01],
	[2.9500000000E+04, 2.0361788650E+01, 5.1483865917E+00, 5.8824728912E+00, 2.4192939237E+00, 9.1215488887E-01],
	[2.9505000000E+04, 2.0367469052E+01, 5.1483733558E+00, 5.8856909668E+00, 2.4199153505E+00, 9.1219621707E-01],
	[2.9510000000E+04, 2.0373150076E+01, 5.1483601222E+00, 5.8889102561E+00, 2.4205366711E+00, 9.1223752510E-01],
	[2.9515000000E+04, 2.0378831722E+01, 5.1483468910E+00, 5.8921307596E+00, 2.4211578854E+00, 9.1227881297E-01],
	[2.9520000000E+04, 2.0384513989E+01, 5.1483336619E+00, 5.8953524774E+00, 2.4217789933E+00, 9.1232008070E-01],
	[2.9525000000E+04, 2.0390196878E+01, 5.1483204352E+00, 5.8985754097E+00, 2.4223999948E+00, 9.1236132829E-01],
	[2.9530000000E+04, 2.0395880388E+01, 5.1483072107E+00, 5.9017995569E+00, 2.4230208898E+00, 9.1240255575E-01],
	[2.9535000000E+04, 2.0401564520E+01, 5.1482939885E+00, 5.9050249192E+00, 2.4236416784E+00, 9.1244376309E-01],
	[2.9540000000E+04, 2.0407249274E+01, 5.1482807686E+00, 5.9082514968E+00, 2.4242623604E+00, 9.1248495033E-01],
	[2.9545000000E+04, 2.0412934649E+01, 5.1482675509E+00, 5.9114792900E+00, 2.4248829359E+00, 9.1252611746E-01],
	[2.9550000000E+04, 2.0418620646E+01, 5.1482543356E+00, 5.9147082991E+00, 2.4255034048E+00, 9.1256726450E-01],
	[2.9555000000E+04, 2.0424307263E+01, 5.1482411224E+00, 5.9179385243E+00, 2.4261237670E+00, 9.1260839146E-01],
	[2.9560000000E+04, 2.0429994503E+01, 5.1482279116E+00, 5.9211699657E+00, 2.4267440226E+00, 9.1264949834E-01],
	[2.9565000000E+04, 2.0435682363E+01, 5.1482147030E+00, 5.9244026238E+00, 2.4273641714E+00, 9.1269058516E-01],
	[2.9570000000E+04, 2.0441370845E+01, 5.1482014967E+00, 5.9276364988E+00, 2.4279842134E+00, 9.1273165193E-01],
	[2.9575000000E+04, 2.0447059948E+01, 5.1481882927E+00, 5.9308715908E+00, 2.4286041486E+00, 9.1277269865E-01],
	[2.9580000000E+04, 2.0452749673E+01, 5.1481750909E+00, 5.9341079002E+00, 2.4292239770E+00, 9.1281372534E-01],
	[2.9585000000E+04, 2.0458440018E+01, 5.1481618914E+00, 5.9373454272E+00, 2.4298436985E+00, 9.1285473199E-01],
	[2.9590000000E+04, 2.0464130985E+01, 5.1481486941E+00, 5.9405841720E+00, 2.4304633130E+00, 9.1289571863E-01],
	[2.9595000000E+04, 2.0469822573E+01, 5.1481354992E+00, 5.9438241350E+00, 2.4310828206E+00, 9.1293668526E-01],
	[2.9600000000E+04, 2.0475514782E+01, 5.1481223064E+00, 5.9470653163E+00, 2.4317022211E+00, 9.1297763189E-01],
	[2.9605000000E+04, 2.0481207612E+01, 5.1481091160E+00, 5.9503077162E+00, 2.4323215146E+00, 9.1301855853E-01],
	[2.9610000000E+04, 2.0486901063E+01, 5.1480959278E+00, 5.9535513350E+00, 2.4329407009E+00, 9.1305946518E-01],
	[2.9615000000E+04, 2.0492595135E+01, 5.1480827418E+00, 5.9567961729E+00, 2.4335597802E+00, 9.1310035187E-01],
	[2.9620000000E+04, 2.0498289827E+01, 5.1480695582E+00, 5.9600422302E+00, 2.4341787522E+00, 9.1314121859E-01],
	[2.9625000000E+04, 2.0503985141E+01, 5.1480563767E+00, 5.9632895070E+00, 2.4347976171E+00, 9.1318206535E-01],
	[2.9630000000E+04, 2.0509681076E+01, 5.1480431976E+00, 5.9665380038E+00, 2.4354163747E+00, 9.1322289218E-01],
	[2.9635000000E+04, 2.0515377631E+01, 5.1480300207E+00, 5.9697877207E+00, 2.4360350249E+00, 9.1326369906E-01],
	[2.9640000000E+04, 2.0521074807E+01, 5.1480168460E+00, 5.9730386579E+00, 2.4366535679E+00, 9.1330448602E-01],
	[2.9645000000E+04, 2.0526772604E+01, 5.1480036737E+00, 5.9762908158E+00, 2.4372720034E+00, 9.1334525306E-01],
	[2.9650000000E+04, 2.0532471022E+01, 5.1479905035E+00, 5.9795441945E+00, 2.4378903315E+00, 9.1338600020E-01],
	[2.9655000000E+04, 2.0538170060E+01, 5.1479773356E+00, 5.9827987944E+00, 2.4385085522E+00, 9.1342672743E-01],
	[2.9660000000E+04, 2.0543869719E+01, 5.1479641700E+00, 5.9860546156E+00, 2.4391266653E+00, 9.1346743477E-01],
	[2.9665000000E+04, 2.0549569998E+01, 5.1479510066E+00, 5.9893116585E+00, 2.4397446710E+00, 9.1350812224E-01],
	[2.9670000000E+04, 2.0555270898E+01, 5.1479378455E+00, 5.9925699233E+00, 2.4403625690E+00, 9.1354878983E-01],
	[2.9675000000E+04, 2.0560972419E+01, 5.1479246867E+00, 5.9958294102E+00, 2.4409803594E+00, 9.1358943756E-01],
	[2.9680000000E+04, 2.0566674560E+01, 5.1479115300E+00, 5.9990901194E+00, 2.4415980421E+00, 9.1363006543E-01],
	[2.9685000000E+04, 2.0572377321E+01, 5.1478983757E+00, 6.0023520514E+00, 2.4422156172E+00, 9.1367067347E-01],
	[2.9690000000E+04, 2.0578080703E+01, 5.1478852235E+00, 6.0056152062E+00, 2.4428330845E+00, 9.1371126166E-01],
	[2.9695000000E+04, 2.0583784706E+01, 5.1478720737E+00, 6.0088795841E+00, 2.4434504440E+00, 9.1375183003E-01],
	[2.9700000000E+04, 2.0589489328E+01, 5.1478589261E+00, 6.0121451855E+00, 2.4440676957E+00, 9.1379237859E-01],
	[2.9705000000E+04, 2.0595194571E+01, 5.1478457807E+00, 6.0154120105E+00, 2.4446848396E+00, 9.1383290733E-01],
	[2.9710000000E+04, 2.0600900434E+01, 5.1478326375E+00, 6.0186800594E+00, 2.4453018755E+00, 9.1387341628E-01],
	[2.9715000000E+04, 2.0606606918E+01, 5.1478194967E+00, 6.0219493324E+00, 2.4459188035E+00, 9.1391390544E-01],
	[2.9720000000E+04, 2.0612314021E+01, 5.1478063580E+00, 6.0252198298E+00, 2.4465356235E+00, 9.1395437482E-01],
	[2.9725000000E+04, 2.0618021745E+01, 5.1477932216E+00, 6.0284915519E+00, 2.4471523355E+00, 9.1399482443E-01],
	[2.9730000000E+04, 2.0623730089E+01, 5.1477800875E+00, 6.0317644989E+00, 2.4477689395E+00, 9.1403525428E-01],
	[2.9735000000E+04, 2.0629439053E+01, 5.1477669556E+00, 6.0350386711E+00, 2.4483854353E+00, 9.1407566437E-01],
	[2.9740000000E+04, 2.0635148637E+01, 5.1477538259E+00, 6.0383140687E+00, 2.4490018230E+00, 9.1411605472E-01],
	[2.9745000000E+04, 2.0640858840E+01, 5.1477406985E+00, 6.0415906919E+00, 2.4496181026E+00, 9.1415642534E-01],
	[2.9750000000E+04, 2.0646569664E+01, 5.1477275733E+00, 6.0448685411E+00, 2.4502342739E+00, 9.1419677623E-01],
	[2.9755000000E+04, 2.0652281108E+01, 5.1477144503E+00, 6.0481476164E+00, 2.4508503370E+00, 9.1423710741E-01],
	[2.9760000000E+04, 2.0657993172E+01, 5.1477013296E+00, 6.0514279181E+00, 2.4514662918E+00, 9.1427741888E-01],
	[2.9765000000E+04, 2.0663705855E+01, 5.1476882111E+00, 6.0547094465E+00, 2.4520821382E+00, 9.1431771065E-01],
	[2.9770000000E+04, 2.0669419159E+01, 5.1476750949E+00, 6.0579922018E+00, 2.4526978763E+00, 9.1435798273E-01],
	[2.9775000000E+04, 2.0675133082E+01, 5.1476619809E+00, 6.0612761843E+00, 2.4533135060E+00, 9.1439823514E-01],
	[2.9780000000E+04, 2.0680847625E+01, 5.1476488691E+00, 6.0645613942E+00, 2.4539290272E+00, 9.1443846787E-01],
	[2.9785000000E+04, 2.0686562787E+01, 5.1476357596E+00, 6.0678478318E+00, 2.4545444400E+00, 9.1447868095E-01],
	[2.9790000000E+04, 2.0692278570E+01, 5.1476226523E+00, 6.0711354974E+00, 2.4551597442E+00, 9.1451887437E-01],
	[2.9795000000E+04, 2.0697994972E+01, 5.1476095472E+00, 6.0744243911E+00, 2.4557749399E+00, 9.1455904815E-01],
	[2.9800000000E+04, 2.0703711993E+01, 5.1475964444E+00, 6.0777145132E+00, 2.4563900270E+00, 9.1459920230E-01],
	[2.9805000000E+04, 2.0709429634E+01, 5.1475833438E+00, 6.0810058641E+00, 2.4570050054E+00, 9.1463933682E-01],
	[2.9810000000E+04, 2.0715147895E+01, 5.1475702454E+00, 6.0842984438E+00, 2.4576198752E+00, 9.1467945173E-01],
	[2.9815000000E+04, 2.0720866775E+01, 5.1475571493E+00, 6.0875922528E+00, 2.4582346362E+00, 9.1471954704E-01],
	[2.9820000000E+04, 2.0726586274E+01, 5.1475440554E+00, 6.0908872912E+00, 2.4588492885E+00, 9.1475962274E-01],
	[2.9825000000E+04, 2.0732306393E+01, 5.1475309637E+00, 6.0941835593E+00, 2.4594638320E+00, 9.1479967886E-01],
	[2.9830000000E+04, 2.0738027131E+01, 5.1475178742E+00, 6.0974810573E+00, 2.4600782667E+00, 9.1483971540E-01],
	[2.9835000000E+04, 2.0743748489E+01, 5.1475047870E+00, 6.1007797856E+00, 2.4606925925E+00, 9.1487973238E-01],
	[2.9840000000E+04, 2.0749470466E+01, 5.1474917020E+00, 6.1040797443E+00, 2.4613068094E+00, 9.1491972979E-01],
	[2.9845000000E+04, 2.0755193062E+01, 5.1474786192E+00, 6.1073809337E+00, 2.4619209174E+00, 9.1495970765E-01],
	[2.9850000000E+04, 2.0760916278E+01, 5.1474655387E+00, 6.1106833540E+00, 2.4625349164E+00, 9.1499966597E-01],
	[2.9855000000E+04, 2.0766640112E+01, 5.1474524604E+00, 6.1139870056E+00, 2.4631488064E+00, 9.1503960476E-01],
	[2.9860000000E+04, 2.0772364566E+01, 5.1474393843E+00, 6.1172918886E+00, 2.4637625873E+00, 9.1507952403E-01],
	[2.9865000000E+04, 2.0778089639E+01, 5.1474263104E+00, 6.1205980033E+00, 2.4643762592E+00, 9.1511942378E-01],
	[2.9870000000E+04, 2.0783815331E+01, 5.1474132387E+00, 6.1239053500E+00, 2.4649898219E+00, 9.1515930403E-01],
	[2.9875000000E+04, 2.0789541642E+01, 5.1474001693E+00, 6.1272139289E+00, 2.4656032754E+00, 9.1519916478E-01],
	[2.9880000000E+04, 2.0795268572E+01, 5.1473871021E+00, 6.1305237403E+00, 2.4662166198E+00, 9.1523900605E-01],
	[2.9885000000E+04, 2.0800996121E+01, 5.1473740371E+00, 6.1338347844E+00, 2.4668298549E+00, 9.1527882783E-01],
	[2.9890000000E+04, 2.0806724289E+01, 5.1473609743E+00, 6.1371470615E+00, 2.4674429807E+00, 9.1531863016E-01],
	[2.9895000000E+04, 2.0812453075E+01, 5.1473479137E+00, 6.1404605718E+00, 2.4680559972E+00, 9.1535841302E-01],
	[2.9900000000E+04, 2.0818182481E+01, 5.1473348554E+00, 6.1437753156E+00, 2.4686689044E+00, 9.1539817643E-01],
	[2.9905000000E+04, 2.0823912505E+01, 5.1473217993E+00, 6.1470912931E+00, 2.4692817021E+00, 9.1543792040E-01],
	[2.9910000000E+04, 2.0829652878E+01, 5.1473102052E+00, 6.1504085045E+00, 2.4698948634E+00, 9.1547764494E-01],
	[2.9915000000E+04, 2.0835405311E+01, 5.1473003292E+00, 6.1537269503E+00, 2.4705084717E+00, 9.1551735006E-01],
	[2.9920000000E+04, 2.0841158372E+01, 5.1472904548E+00, 6.1570466305E+00, 2.4711219711E+00, 9.1555703577E-01],
	[2.9925000000E+04, 2.0846912059E+01, 5.1472805821E+00, 6.1603675454E+00, 2.4717353617E+00, 9.1559670207E-01],
	[2.9930000000E+04, 2.0852666374E+01, 5.1472707111E+00, 6.1636896954E+00, 2.4723486435E+00, 9.1563634898E-01],
	[2.9935000000E+04, 2.0858421315E+01, 5.1472608417E+00, 6.1670130805E+00, 2.4729618163E+00, 9.1567597650E-01],
	[2.9940000000E+04, 2.0864176882E+01, 5.1472509740E+00, 6.1703377012E+00, 2.4735748801E+00, 9.1571558465E-01],
	[2.9945000000E+04, 2.0869933076E+01, 5.1472411080E+00, 6.1736635576E+00, 2.4741878350E+00, 9.1575517343E-01],
	[2.9950000000E+04, 2.0875689897E+01, 5.1472312437E+00, 6.1769906501E+00, 2.4748006808E+00, 9.1579474285E-01],
	[2.9955000000E+04, 2.0881447345E+01, 5.1472213810E+00, 6.1803189787E+00, 2.4754134176E+00, 9.1583429292E-01],
	[2.9960000000E+04, 2.0887205419E+01, 5.1472115199E+00, 6.1836485439E+00, 2.4760260452E+00, 9.1587382366E-01],
	[2.9965000000E+04, 2.0892964119E+01, 5.1472016606E+00, 6.1869793459E+00, 2.4766385637E+00, 9.1591333506E-01],
	[2.9970000000E+04, 2.0898723446E+01, 5.1471918029E+00, 6.1903113848E+00, 2.4772509731E+00, 9.1595282714E-01],
	[2.9975000000E+04, 2.0904483400E+01, 5.1471819468E+00, 6.1936446610E+00, 2.4778632732E+00, 9.1599229991E-01],
	[2.9980000000E+04, 2.0910243980E+01, 5.1471720924E+00, 6.1969791748E+00, 2.4784754641E+00, 9.1603175338E-01],
	[2.9985000000E+04, 2.0916005186E+01, 5.1471622397E+00, 6.2003149263E+00, 2.4790875457E+00, 9.1607118756E-01],
	[2.9990000000E+04, 2.0921767019E+01, 5.1471523887E+00, 6.2036519158E+00, 2.4796995179E+00, 9.1611060245E-01],
	[2.9995000000E+04, 2.0927529478E+01, 5.1471425393E+00, 6.2069901436E+00, 2.4803113809E+00, 9.1614999806E-01],
	[3.0000000000E+04, 2.0933292563E+01, 5.1471326916E+00, 6.2103296099E+00, 2.4809231344E+00, 9.1618937441E-01],
	[3.0005000000E+04, 2.0939056274E+01, 5.1471228455E+00, 6.2136914244E+00, 2.4815381453E+00, 9.1622873150E-01],
	[3.0010000000E+04, 2.0944820612E+01, 5.1471130011E+00, 6.2170544973E+00, 2.4821530459E+00, 9.1626806935E-01],
	[3.0015000000E+04, 2.0950585575E+01, 5.1471031583E+00, 6.2204188287E+00, 2.4827678361E+00, 9.1630738795E-01],
	[3.0020000000E+04, 2.0956351165E+01, 5.1470933172E+00, 6.2237844189E+00, 2.4833825159E+00, 9.1634668733E-01],
	[3.0025000000E+04, 2.0962117381E+01, 5.1470834778E+00, 6.2271512682E+00, 2.4839970853E+00, 9.1638596749E-01],
	[3.0030000000E+04, 2.0967884223E+01, 5.1470736400E+00, 6.2305193768E+00, 2.4846115442E+00, 9.1642522843E-01],
	[3.0035000000E+04, 2.0973651691E+01, 5.1470638039E+00, 6.2338887450E+00, 2.4852258926E+00, 9.1646447018E-01],
	[3.0040000000E+04, 2.0979419785E+01, 5.1470539694E+00, 6.2372593731E+00, 2.4858401304E+00, 9.1650369273E-01],
	[3.0045000000E+04, 2.0985188505E+01, 5.1470441366E+00, 6.2406312613E+00, 2.4864542577E+00, 9.1654289610E-01],
	[3.0050000000E+04, 2.0990957851E+01, 5.1470343055E+00, 6.2440044098E+00, 2.4870682743E+00, 9.1658208029E-01],
	[3.0055000000E+04, 2.0996727822E+01, 5.1470244760E+00, 6.2473788190E+00, 2.4876821803E+00, 9.1662124532E-01],
	[3.0060000000E+04, 2.1002498420E+01, 5.1470146481E+00, 6.2507544891E+00, 2.4882959755E+00, 9.1666039119E-01],
	[3.0065000000E+04, 2.1008269643E+01, 5.1470048219E+00, 6.2541314203E+00, 2.4889096601E+00, 9.1669951792E-01],
	[3.0070000000E+04, 2.1014041492E+01, 5.1469949974E+00, 6.2575096130E+00, 2.4895232338E+00, 9.1673862551E-01],
	[3.0075000000E+04, 2.1019813967E+01, 5.1469851745E+00, 6.2608890673E+00, 2.4901366968E+00, 9.1677771397E-01],
	[3.0080000000E+04, 2.1025587067E+01, 5.1469753532E+00, 6.2642697836E+00, 2.4907500489E+00, 9.1681678331E-01],
	[3.0085000000E+04, 2.1031360793E+01, 5.1469655337E+00, 6.2676517621E+00, 2.4913632902E+00, 9.1685583354E-01],
	[3.0090000000E+04, 2.1037135145E+01, 5.1469557157E+00, 6.2710350030E+00, 2.4919764205E+00, 9.1689486467E-01],
	[3.0095000000E+04, 2.1042910122E+01, 5.1469458994E+00, 6.2744195066E+00, 2.4925894399E+00, 9.1693387671E-01],
	[3.0100000000E+04, 2.1048685725E+01, 5.1469360848E+00, 6.2778052733E+00, 2.4932023484E+00, 9.1697286967E-01],
	[3.0105000000E+04, 2.1054461953E+01, 5.1469262718E+00, 6.2811923032E+00, 2.4938151458E+00, 9.1701184355E-01],
	[3.0110000000E+04, 2.1060238807E+01, 5.1469164605E+00, 6.2845805966E+00, 2.4944278321E+00, 9.1705079837E-01],
	[3.0115000000E+04, 2.1066016286E+01, 5.1469066508E+00, 6.2879701537E+00, 2.4950404074E+00, 9.1708973412E-01],
	[3.0120000000E+04, 2.1071794390E+01, 5.1468968427E+00, 6.2913609749E+00, 2.4956528715E+00, 9.1712865083E-01],
	[3.0125000000E+04, 2.1077573120E+01, 5.1468870363E+00, 6.2947530603E+00, 2.4962652245E+00, 9.1716754849E-01],
	[3.0130000000E+04, 2.1083352475E+01, 5.1468772316E+00, 6.2981464104E+00, 2.4968774662E+00, 9.1720642711E-01],
	[3.0135000000E+04, 2.1089132456E+01, 5.1468674285E+00, 6.3015410252E+00, 2.4974895968E+00, 9.1724528670E-01],
	[3.0140000000E+04, 2.1094913062E+01, 5.1468576270E+00, 6.3049369051E+00, 2.4981016161E+00, 9.1728412727E-01],
	[3.0145000000E+04, 2.1100694293E+01, 5.1468478272E+00, 6.3083340503E+00, 2.4987135240E+00, 9.1732294883E-01],
	[3.0150000000E+04, 2.1106476149E+01, 5.1468380290E+00, 6.3117324611E+00, 2.4993253207E+00, 9.1736175139E-01],
	[3.0155000000E+04, 2.1112258630E+01, 5.1468282325E+00, 6.3151321378E+00, 2.4999370059E+00, 9.1740053494E-01],
	[3.0160000000E+04, 2.1118041736E+01, 5.1468184376E+00, 6.3185330806E+00, 2.5005485798E+00, 9.1743929951E-01],
	[3.0165000000E+04, 2.1123825468E+01, 5.1468086444E+00, 6.3219352897E+00, 2.5011600422E+00, 9.1747804509E-01],
	[3.0170000000E+04, 2.1129609824E+01, 5.1467988528E+00, 6.3253387655E+00, 2.5017713932E+00, 9.1751677171E-01],
	[3.0175000000E+04, 2.1135394806E+01, 5.1467890628E+00, 6.3287435082E+00, 2.5023826326E+00, 9.1755547935E-01],
	[3.0180000000E+04, 2.1141180412E+01, 5.1467792745E+00, 6.3321495180E+00, 2.5029937605E+00, 9.1759416804E-01],
	[3.0185000000E+04, 2.1146966643E+01, 5.1467694878E+00, 6.3355567953E+00, 2.5036047768E+00, 9.1763283778E-01],
	[3.0190000000E+04, 2.1152753500E+01, 5.1467597028E+00, 6.3389653402E+00, 2.5042156815E+00, 9.1767148857E-01],
	[3.0195000000E+04, 2.1158540981E+01, 5.1467499194E+00, 6.3423751531E+00, 2.5048264746E+00, 9.1771012043E-01],
	[3.0200000000E+04, 2.1164329087E+01, 5.1467401376E+00, 6.3457862342E+00, 2.5054371559E+00, 9.1774873337E-01],
	[3.0205000000E+04, 2.1170117817E+01, 5.1467303575E+00, 6.3491985838E+00, 2.5060477256E+00, 9.1778732738E-01],
	[3.0210000000E+04, 2.1175907173E+01, 5.1467205790E+00, 6.3526122020E+00, 2.5066581835E+00, 9.1782590249E-01],
	[3.0215000000E+04, 2.1181697153E+01, 5.1467108022E+00, 6.3560270893E+00, 2.5072685296E+00, 9.1786445869E-01],
	[3.0220000000E+04, 2.1187487758E+01, 5.1467010269E+00, 6.3594432458E+00, 2.5078787639E+00, 9.1790299599E-01],
	[3.0225000000E+04, 2.1193278987E+01, 5.1466912534E+00, 6.3628606718E+00, 2.5084888863E+00, 9.1794151441E-01],
	[3.0230000000E+04, 2.1199070841E+01, 5.1466814814E+00, 6.3662793676E+00, 2.5090988969E+00, 9.1798001395E-01],
	[3.0235000000E+04, 2.1204863320E+01, 5.1466717111E+00, 6.3696993334E+00, 2.5097087955E+00, 9.1801849462E-01],
	[3.0240000000E+04, 2.1210656423E+01, 5.1466619424E+00, 6.3731205695E+00, 2.5103185821E+00, 9.1805695643E-01],
	[3.0245000000E+04, 2.1216450150E+01, 5.1466521754E+00, 6.3765430761E+00, 2.5109282568E+00, 9.1809539938E-01],
	[3.0250000000E+04, 2.1222244502E+01, 5.1466424100E+00, 6.3799668536E+00, 2.5115378195E+00, 9.1813382348E-01],
	[3.0255000000E+04, 2.1228039479E+01, 5.1466326462E+00, 6.3833919022E+00, 2.5121472701E+00, 9.1817222875E-01],
	[3.0260000000E+04, 2.1233835080E+01, 5.1466228841E+00, 6.3868182220E+00, 2.5127566085E+00, 9.1821061518E-01],
	[3.0265000000E+04, 2.1239631305E+01, 5.1466131236E+00, 6.3902458135E+00, 2.5133658349E+00, 9.1824898279E-01],
	[3.0270000000E+04, 2.1245428154E+01, 5.1466033647E+00, 6.3936746768E+00, 2.5139749491E+00, 9.1828733158E-01],
	[3.0275000000E+04, 2.1251225628E+01, 5.1465936074E+00, 6.3971048123E+00, 2.5145839512E+00, 9.1832566157E-01],
	[3.0280000000E+04, 2.1257023726E+01, 5.1465838518E+00, 6.4005362201E+00, 2.5151928409E+00, 9.1836397275E-01],
	[3.0285000000E+04, 2.1262822448E+01, 5.1465740978E+00, 6.4039689006E+00, 2.5158016185E+00, 9.1840226514E-01],
	[3.0290000000E+04, 2.1268621795E+01, 5.1465643455E+00, 6.4074028539E+00, 2.5164102837E+00, 9.1844053875E-01],
	[3.0295000000E+04, 2.1274421765E+01, 5.1465545947E+00, 6.4108380805E+00, 2.5170188366E+00, 9.1847879359E-01],
	[3.0300000000E+04, 2.1280222360E+01, 5.1465448456E+00, 6.4142745804E+00, 2.5176272772E+00, 9.1851702965E-01],
	[3.0305000000E+04, 2.1286023579E+01, 5.1465350981E+00, 6.4177123541E+00, 2.5182356053E+00, 9.1855524696E-01],
	[3.0310000000E+04, 2.1291825421E+01, 5.1465253523E+00, 6.4211514017E+00, 2.5188438211E+00, 9.1859344551E-01],
	[3.0315000000E+04, 2.1297627888E+01, 5.1465156081E+00, 6.4245917235E+00, 2.5194519243E+00, 9.1863162532E-01],
	[3.0320000000E+04, 2.1303430979E+01, 5.1465058655E+00, 6.4280333197E+00, 2.5200599151E+00, 9.1866978639E-01],
	[3.0325000000E+04, 2.1309234693E+01, 5.1464961245E+00, 6.4314761907E+00, 2.5206677934E+00, 9.1870792873E-01],
	[3.0330000000E+04, 2.1315039032E+01, 5.1464863851E+00, 6.4349203367E+00, 2.5212755591E+00, 9.1874605235E-01],
	[3.0335000000E+04, 2.1320843994E+01, 5.1464766474E+00, 6.4383657580E+00, 2.5218832122E+00, 9.1878415727E-01],
	[3.0340000000E+04, 2.1326649580E+01, 5.1464669113E+00, 6.4418124548E+00, 2.5224907526E+00, 9.1882224347E-01],
	[3.0345000000E+04, 2.1332455790E+01, 5.1464571768E+00, 6.4452604273E+00, 2.5230981805E+00, 9.1886031098E-01],
	[3.0350000000E+04, 2.1338262623E+01, 5.1464474440E+00, 6.4487096759E+00, 2.5237054956E+00, 9.1889835980E-01],
	[3.0355000000E+04, 2.1344070081E+01, 5.1464377127E+00, 6.4521602008E+00, 2.5243126980E+00, 9.1893638994E-01],
	[3.0360000000E+04, 2.1349878162E+01, 5.1464279831E+00, 6.4556120022E+00, 2.5249197877E+00, 9.1897440141E-01],
	[3.0365000000E+04, 2.1355686866E+01, 5.1464182551E+00, 6.4590650805E+00, 2.5255267645E+00, 9.1901239421E-01],
	[3.0370000000E+04, 2.1361496194E+01, 5.1464085287E+00, 6.4625194358E+00, 2.5261336286E+00, 9.1905036836E-01],
	[3.0375000000E+04, 2.1367306146E+01, 5.1463988040E+00, 6.4659750685E+00, 2.5267403798E+00, 9.1908832386E-01],
	[3.0380000000E+04, 2.1373116721E+01, 5.1463890808E+00, 6.4694319788E+00, 2.5273470181E+00, 9.1912626072E-01],
	[3.0385000000E+04, 2.1378927920E+01, 5.1463793593E+00, 6.4728901670E+00, 2.5279535435E+00, 9.1916417894E-01],
	[3.0390000000E+04, 2.1384743207E+01, 5.1463701533E+00, 6.4763496333E+00, 2.5285601284E+00, 9.1920207854E-01],
	[3.0395000000E+04, 2.1390576655E+01, 5.1463635491E+00, 6.4798103780E+00, 2.5291674737E+00, 9.1923995953E-01],
	[3.0400000000E+04, 2.1396410734E+01, 5.1463569460E+00, 6.4832724013E+00, 2.5297747066E+00, 9.1927782190E-01],
	[3.0405000000E+04, 2.1402245444E+01, 5.1463503441E+00, 6.4867357036E+00, 2.5303818272E+00, 9.1931566568E-01],
	[3.0410000000E+04, 2.1408080786E+01, 5.1463437432E+00, 6.4902002850E+00, 2.5309888353E+00, 9.1935349086E-01],
	[3.0415000000E+04, 2.1413916759E+01, 5.1463371434E+00, 6.4936661459E+00, 2.5315957310E+00, 9.1939129745E-01],
	[3.0420000000E+04, 2.1419753363E+01, 5.1463305447E+00, 6.4971332864E+00, 2.5322025143E+00, 9.1942908547E-01],
	[3.0425000000E+04, 2.1425590598E+01, 5.1463239471E+00, 6.5006017070E+00, 2.5328091850E+00, 9.1946685493E-01],
	[3.0430000000E+04, 2.1431428465E+01, 5.1463173506E+00, 6.5040714077E+00, 2.5334157432E+00, 9.1950460582E-01],
	[3.0435000000E+04, 2.1437266963E+01, 5.1463107552E+00, 6.5075423889E+00, 2.5340221889E+00, 9.1954233816E-01],
	[3.0440000000E+04, 2.1443106091E+01, 5.1463041608E+00, 6.5110146509E+00, 2.5346285219E+00, 9.1958005195E-01],
	[3.0445000000E+04, 2.1448945851E+01, 5.1462975676E+00, 6.5144881939E+00, 2.5352347424E+00, 9.1961774721E-01],
	[3.0450000000E+04, 2.1454786242E+01, 5.1462909755E+00, 6.5179630182E+00, 2.5358408501E+00, 9.1965542394E-01],
	[3.0455000000E+04, 2.1460627264E+01, 5.1462843844E+00, 6.5214391239E+00, 2.5364468452E+00, 9.1969308214E-01],
	[3.0460000000E+04, 2.1466468916E+01, 5.1462777945E+00, 6.5249165115E+00, 2.5370527276E+00, 9.1973072184E-01],
	[3.0465000000E+04, 2.1472311200E+01, 5.1462712056E+00, 6.5283951811E+00, 2.5376584972E+00, 9.1976834303E-01],
	[3.0470000000E+04, 2.1478154114E+01, 5.1462646178E+00, 6.5318751331E+00, 2.5382641540E+00, 9.1980594573E-01],
	[3.0475000000E+04, 2.1483997659E+01, 5.1462580311E+00, 6.5353563676E+00, 2.5388696980E+00, 9.1984352993E-01],
	[3.0480000000E+04, 2.1489841835E+01, 5.1462514455E+00, 6.5388388849E+00, 2.5394751292E+00, 9.1988109566E-01],
	[3.0485000000E+04, 2.1495686642E+01, 5.1462448610E+00, 6.5423226854E+00, 2.5400804475E+00, 9.1991864291E-01],
	[3.0490000000E+04, 2.1501532080E+01, 5.1462382776E+00, 6.5458077692E+00, 2.5406856528E+00, 9.1995617170E-01],
	[3.0495000000E+04, 2.1507378148E+01, 5.1462316952E+00, 6.5492941366E+00, 2.5412907453E+00, 9.1999368204E-01],
	[3.0500000000E+04, 2.1513224847E+01, 5.1462251140E+00, 6.5527817879E+00, 2.5418957247E+00, 9.2003117392E-01],
	[3.0505000000E+04, 2.1519072176E+01, 5.1462185338E+00, 6.5562707234E+00, 2.5425005912E+00, 9.2006864736E-01],
	[3.0510000000E+04, 2.1524920136E+01, 5.1462119547E+00, 6.5597609433E+00, 2.5431053446E+00, 9.2010610238E-01],
	[3.0515000000E+04, 2.1530768727E+01, 5.1462053768E+00, 6.5632524478E+00, 2.5437099850E+00, 9.2014353897E-01],
	[3.0520000000E+04, 2.1536617948E+01, 5.1461987998E+00, 6.5667452373E+00, 2.5443145123E+00, 9.2018095714E-01],
	[3.0525000000E+04, 2.1542467800E+01, 5.1461922240E+00, 6.5702393119E+00, 2.5449189264E+00, 9.2021835690E-01],
	[3.0530000000E+04, 2.1548318282E+01, 5.1461856493E+00, 6.5737346721E+00, 2.5455232274E+00, 9.2025573827E-01],
	[3.0535000000E+04, 2.1554169394E+01, 5.1461790756E+00, 6.5772313179E+00, 2.5461274152E+00, 9.2029310124E-01],
	[3.0540000000E+04, 2.1560021137E+01, 5.1461725031E+00, 6.5807292497E+00, 2.5467314897E+00, 9.2033044583E-01],
	[3.0545000000E+04, 2.1565873510E+01, 5.1461659316E+00, 6.5842284678E+00, 2.5473354511E+00, 9.2036777204E-01],
	[3.0550000000E+04, 2.1571726513E+01, 5.1461593612E+00, 6.5877289723E+00, 2.5479392991E+00, 9.2040507989E-01],
	[3.0555000000E+04, 2.1577580147E+01, 5.1461527919E+00, 6.5912307636E+00, 2.5485430339E+00, 9.2044236937E-01],
	[3.0560000000E+04, 2.1583434411E+01, 5.1461462237E+00, 6.5947338420E+00, 2.5491466553E+00, 9.2047964051E-01],
	[3.0565000000E+04, 2.1589289305E+01, 5.1461396565E+00, 6.5982382076E+00, 2.5497501633E+00, 9.2051689330E-01],
	[3.0570000000E+04, 2.1595144829E+01, 5.1461330905E+00, 6.6017438608E+00, 2.5503535579E+00, 9.2055412775E-01],
	[3.0575000000E+04, 2.1601000984E+01, 5.1461265255E+00, 6.6052508017E+00, 2.5509568391E+00, 9.2059134388E-01],
	[3.0580000000E+04, 2.1606857768E+01, 5.1461199616E+00, 6.6087590308E+00, 2.5515600069E+00, 9.2062854169E-01],
	[3.0585000000E+04, 2.1612715183E+01, 5.1461133988E+00, 6.6122685482E+00, 2.5521630611E+00, 9.2066572119E-01],
	[3.0590000000E+04, 2.1618573227E+01, 5.1461068370E+00, 6.6157793542E+00, 2.5527660018E+00, 9.2070288238E-01],
	[3.0595000000E+04, 2.1624431902E+01, 5.1461002764E+00, 6.6192914490E+00, 2.5533688290E+00, 9.2074002528E-01],
	[3.0600000000E+04, 2.1630291206E+01, 5.1460937168E+00, 6.6228048330E+00, 2.5539715426E+00, 9.2077714989E-01],
	[3.0605000000E+04, 2.1636151141E+01, 5.1460871583E+00, 6.6263195063E+00, 2.5545741426E+00, 9.2081425623E-01],
	[3.0610000000E+04, 2.1642011705E+01, 5.1460806009E+00, 6.6298354693E+00, 2.5551766289E+00, 9.2085134429E-01],
	[3.0615000000E+04, 2.1647872899E+01, 5.1460740446E+00, 6.6333527222E+00, 2.5557790016E+00, 9.2088841409E-01],
	[3.0620000000E+04, 2.1653734723E+01, 5.1460674893E+00, 6.6368712653E+00, 2.5563812606E+00, 9.2092546564E-01],
	[3.0625000000E+04, 2.1659597176E+01, 5.1460609351E+00, 6.6403910988E+00, 2.5569834058E+00, 9.2096249894E-01],
	[3.0630000000E+04, 2.1665460260E+01, 5.1460543820E+00, 6.6439122230E+00, 2.5575854373E+00, 9.2099951400E-01],
	[3.0635000000E+04, 2.1671323973E+01, 5.1460478300E+00, 6.6474346381E+00, 2.5581873550E+00, 9.2103651083E-01],
	[3.0640000000E+04, 2.1677188316E+01, 5.1460412791E+00, 6.6509583444E+00, 2.5587891589E+00, 9.2107348943E-01],
	[3.0645000000E+04, 2.1683053288E+01, 5.1460347292E+00, 6.6544833423E+00, 2.5593908489E+00, 9.2111044983E-01],
	[3.0650000000E+04, 2.1688918890E+01, 5.1460281804E+00, 6.6580096318E+00, 2.5599924250E+00, 9.2114739202E-01],
	[3.0655000000E+04, 2.1694785121E+01, 5.1460216327E+00, 6.6615372134E+00, 2.5605938873E+00, 9.2118431600E-01],
	[3.0660000000E+04, 2.1700651983E+01, 5.1460150861E+00, 6.6650660872E+00, 2.5611952356E+00, 9.2122122180E-01],
	[3.0665000000E+04, 2.1706519473E+01, 5.1460085405E+00, 6.6685962536E+00, 2.5617964699E+00, 9.2125810942E-01],
	[3.0670000000E+04, 2.1712387593E+01, 5.1460019960E+00, 6.6721277127E+00, 2.5623975903E+00, 9.2129497887E-01],
	[3.0675000000E+04, 2.1718256342E+01, 5.1459954526E+00, 6.6756604649E+00, 2.5629985966E+00, 9.2133183015E-01],
	[3.0680000000E+04, 2.1724125721E+01, 5.1459889103E+00, 6.6791945104E+00, 2.5635994889E+00, 9.2136866327E-01],
	[3.0685000000E+04, 2.1729995729E+01, 5.1459823690E+00, 6.6827298495E+00, 2.5642002671E+00, 9.2140547824E-01],
	[3.0690000000E+04, 2.1735866367E+01, 5.1459758288E+00, 6.6862664824E+00, 2.5648009312E+00, 9.2144227507E-01],
	[3.0695000000E+04, 2.1741737634E+01, 5.1459692897E+00, 6.6898044094E+00, 2.5654014811E+00, 9.2147905377E-01],
	[3.0700000000E+04, 2.1747609529E+01, 5.1459627517E+00, 6.6933436308E+00, 2.5660019169E+00, 9.2151581434E-01],
	[3.0705000000E+04, 2.1753482055E+01, 5.1459562147E+00, 6.6968841468E+00, 2.5666022385E+00, 9.2155255680E-01],
	[3.0710000000E+04, 2.1759355209E+01, 5.1459496788E+00, 6.7004259576E+00, 2.5672024459E+00, 9.2158928114E-01],
	[3.0715000000E+04, 2.1765228992E+01, 5.1459431440E+00, 6.7039690637E+00, 2.5678025390E+00, 9.2162598739E-01],
	[3.0720000000E+04, 2.1771103405E+01, 5.1459366103E+00, 6.7075134651E+00, 2.5684025178E+00, 9.2166267555E-01],
	[3.0725000000E+04, 2.1776978447E+01, 5.1459300776E+00, 6.7110591622E+00, 2.5690023823E+00, 9.2169934561E-01],
	[3.0730000000E+04, 2.1782854117E+01, 5.1459235460E+00, 6.7146061552E+00, 2.5696021325E+00, 9.2173599761E-01],
	[3.0735000000E+04, 2.1788730417E+01, 5.1459170154E+00, 6.7181544444E+00, 2.5702017683E+00, 9.2177263153E-01],
	[3.0740000000E+04, 2.1794607346E+01, 5.1459104860E+00, 6.7217040301E+00, 2.5708012897E+00, 9.2180924740E-01],
	[3.0745000000E+04, 2.1800484903E+01, 5.1459039576E+00, 6.7252549125E+00, 2.5714006967E+00, 9.2184584521E-01],
	[3.0750000000E+04, 2.1806363090E+01, 5.1458974303E+00, 6.7288070919E+00, 2.5719999892E+00, 9.2188242498E-01],
	[3.0755000000E+04, 2.1812241905E+01, 5.1458909040E+00, 6.7323605685E+00, 2.5725991673E+00, 9.2191898672E-01],
	[3.0760000000E+04, 2.1818121349E+01, 5.1458843788E+00, 6.7359153426E+00, 2.5731982309E+00, 9.2195553042E-01],
	[3.0765000000E+04, 2.1824001422E+01, 5.1458778547E+00, 6.7394714145E+00, 2.5737971799E+00, 9.2199205611E-01],
	[3.0770000000E+04, 2.1829882124E+01, 5.1458713317E+00, 6.7430287844E+00, 2.5743960143E+00, 9.2202856378E-01],
	[3.0775000000E+04, 2.1835763454E+01, 5.1458648097E+00, 6.7465874526E+00, 2.5749947342E+00, 9.2206505346E-01],
	[3.0780000000E+04, 2.1841645413E+01, 5.1458582888E+00, 6.7501474194E+00, 2.5755933394E+00, 9.2210152513E-01],
	[3.0785000000E+04, 2.1847528001E+01, 5.1458517689E+00, 6.7537086850E+00, 2.5761918300E+00, 9.2213797883E-01],
	[3.0790000000E+04, 2.1853411217E+01, 5.1458452501E+00, 6.7572712497E+00, 2.5767902059E+00, 9.2217441454E-01],
	[3.0795000000E+04, 2.1859295062E+01, 5.1458387324E+00, 6.7608351137E+00, 2.5773884672E+00, 9.2221083228E-01],
	[3.0800000000E+04, 2.1865179536E+01, 5.1458322158E+00, 6.7644002773E+00, 2.5779866136E+00, 9.2224723206E-01],
	[3.0805000000E+04, 2.1871064638E+01, 5.1458257002E+00, 6.7679667407E+00, 2.5785846454E+00, 9.2228361388E-01],
	[3.0810000000E+04, 2.1876950368E+01, 5.1458191857E+00, 6.7715345043E+00, 2.5791825623E+00, 9.2231997776E-01],
	[3.0815000000E+04, 2.1882836727E+01, 5.1458126722E+00, 6.7751035683E+00, 2.5797803644E+00, 9.2235632370E-01],
	[3.0820000000E+04, 2.1888723714E+01, 5.1458061599E+00, 6.7786739330E+00, 2.5803780517E+00, 9.2239265171E-01],
	[3.0825000000E+04, 2.1894611330E+01, 5.1457996485E+00, 6.7822455985E+00, 2.5809756241E+00, 9.2242896180E-01],
	[3.0830000000E+04, 2.1900499574E+01, 5.1457931383E+00, 6.7858185653E+00, 2.5815730817E+00, 9.2246525398E-01],
	[3.0835000000E+04, 2.1906388446E+01, 5.1457866291E+00, 6.7893928334E+00, 2.5821704243E+00, 9.2250152825E-01],
	[3.0840000000E+04, 2.1912277947E+01, 5.1457801210E+00, 6.7929684033E+00, 2.5827676519E+00, 9.2253778462E-01],
	[3.0845000000E+04, 2.1918168075E+01, 5.1457736139E+00, 6.7965452751E+00, 2.5833647646E+00, 9.2257402311E-01],
	[3.0850000000E+04, 2.1924058832E+01, 5.1457671079E+00, 6.8001234492E+00, 2.5839617623E+00, 9.2261024371E-01],
	[3.0855000000E+04, 2.1929950217E+01, 5.1457606030E+00, 6.8037029258E+00, 2.5845586449E+00, 9.2264644644E-01],
	[3.0860000000E+04, 2.1935842231E+01, 5.1457540991E+00, 6.8072837051E+00, 2.5851554125E+00, 9.2268263130E-01],
	[3.0865000000E+04, 2.1941734872E+01, 5.1457475963E+00, 6.8108657874E+00, 2.5857520650E+00, 9.2271879831E-01],
	[3.0870000000E+04, 2.1947628141E+01, 5.1457410945E+00, 6.8144491730E+00, 2.5863486024E+00, 9.2275494747E-01],
	[3.0875000000E+04, 2.1953522039E+01, 5.1457345938E+00, 6.8180338621E+00, 2.5869450246E+00, 9.2279107880E-01],
	[3.0880000000E+04, 2.1959423223E+01, 5.1457290710E+00, 6.8216198551E+00, 2.5875416712E+00, 9.2282719228E-01],
	[3.0885000000E+04, 2.1965339183E+01, 5.1457256235E+00, 6.8252071521E+00, 2.5881389239E+00, 9.2286328795E-01],
	[3.0890000000E+04, 2.1971255778E+01, 5.1457221766E+00, 6.8287957534E+00, 2.5887360620E+00, 9.2289936580E-01],
	[3.0895000000E+04, 2.1977173009E+01, 5.1457187302E+00, 6.8323856593E+00, 2.5893330856E+00, 9.2293542584E-01],
	[3.0900000000E+04, 2.1983090875E+01, 5.1457152844E+00, 6.8359768701E+00, 2.5899299945E+00, 9.2297146808E-01],
	[3.0905000000E+04, 2.1989009378E+01, 5.1457118391E+00, 6.8395693859E+00, 2.5905267888E+00, 9.2300749253E-01],
	[3.0910000000E+04, 2.1994928516E+01, 5.1457083944E+00, 6.8431632072E+00, 2.5911234684E+00, 9.2304349920E-01],
	[3.0915000000E+04, 2.2000848289E+01, 5.1457049502E+00, 6.8467583341E+00, 2.5917200334E+00, 9.2307948809E-01],
	[3.0920000000E+04, 2.2006768698E+01, 5.1457015066E+00, 6.8503547669E+00, 2.5923164835E+00, 9.2311545922E-01],
	[3.0925000000E+04, 2.2012689742E+01, 5.1456980636E+00, 6.8539525058E+00, 2.5929128190E+00, 9.2315141259E-01],
	[3.0930000000E+04, 2.2018611422E+01, 5.1456946211E+00, 6.8575515512E+00, 2.5935090396E+00, 9.2318734821E-01],
	[3.0935000000E+04, 2.2024533738E+01, 5.1456911792E+00, 6.8611519033E+00, 2.5941051455E+00, 9.2322326608E-01],
	[3.0940000000E+04, 2.2030456688E+01, 5.1456877379E+00, 6.8647535623E+00, 2.5947011365E+00, 9.2325916622E-01],
	[3.0945000000E+04, 2.2036380274E+01, 5.1456842971E+00, 6.8683565285E+00, 2.5952970127E+00, 9.2329504864E-01],
	[3.0950000000E+04, 2.2042304496E+01, 5.1456808568E+00, 6.8719608022E+00, 2.5958927740E+00, 9.2333091334E-01],
	[3.0955000000E+04, 2.2048229352E+01, 5.1456774171E+00, 6.8755663837E+00, 2.5964884204E+00, 9.2336676032E-01],
	[3.0960000000E+04, 2.2054154844E+01, 5.1456739780E+00, 6.8791732731E+00, 2.5970839518E+00, 9.2340258961E-01],
	[3.0965000000E+04, 2.2060080971E+01, 5.1456705395E+00, 6.8827814709E+00, 2.5976793683E+00, 9.2343840120E-01],
	[3.0970000000E+04, 2.2066007734E+01, 5.1456671014E+00, 6.8863909771E+00, 2.5982746698E+00, 9.2347419511E-01],
	[3.0975000000E+04, 2.2071935131E+01, 5.1456636640E+00, 6.8900017921E+00, 2.5988698563E+00, 9.2350997134E-01],
	[3.0980000000E+04, 2.2077863164E+01, 5.1456602271E+00, 6.8936139162E+00, 2.5994649277E+00, 9.2354572991E-01],
	[3.0985000000E+04, 2.2083791831E+01, 5.1456567908E+00, 6.8972273496E+00, 2.6000598841E+00, 9.2358147081E-01],
	[3.0990000000E+04, 2.2089721134E+01, 5.1456533550E+00, 6.9008420926E+00, 2.6006547254E+00, 9.2361719406E-01],
	[3.0995000000E+04, 2.2095651072E+01, 5.1456499198E+00, 6.9044581454E+00, 2.6012494515E+00, 9.2365289967E-01],
	[3.1000000000E+04, 2.2101581645E+01, 5.1456464851E+00, 6.9080755083E+00, 2.6018440625E+00, 9.2368858764E-01],
	[3.1005000000E+04, 2.2107512852E+01, 5.1456430510E+00, 6.9116941816E+00, 2.6024385584E+00, 9.2372425798E-01],
	[3.1010000000E+04, 2.2113444695E+01, 5.1456396174E+00, 6.9153141655E+00, 2.6030329391E+00, 9.2375991070E-01],
	[3.1015000000E+04, 2.2119377172E+01, 5.1456361844E+00, 6.9189354603E+00, 2.6036272045E+00, 9.2379554582E-01],
	[3.1020000000E+04, 2.2125310284E+01, 5.1456327520E+00, 6.9225580663E+00, 2.6042213547E+00, 9.2383116333E-01],
	[3.1025000000E+04, 2.2131244031E+01, 5.1456293201E+00, 6.9261819837E+00, 2.6048153897E+00, 9.2386676324E-01],
	[3.1030000000E+04, 2.2137178413E+01, 5.1456258888E+00, 6.9298072127E+00, 2.6054093093E+00, 9.2390234557E-01],
	[3.1035000000E+04, 2.2143113430E+01, 5.1456224580E+00, 6.9334337537E+00, 2.6060031136E+00, 9.2393791031E-01],
	[3.1040000000E+04, 2.2149049081E+01, 5.1456190278E+00, 6.9370616069E+00, 2.6065968026E+00, 9.2397345749E-01],
	[3.1045000000E+04, 2.2154985367E+01, 5.1456155981E+00, 6.9406907726E+00, 2.6071903762E+00, 9.2400898711E-01],
	[3.1050000000E+04, 2.2160922287E+01, 5.1456121690E+00, 6.9443212510E+00, 2.6077838344E+00, 9.2404449917E-01],
	[3.1055000000E+04, 2.2166859843E+01, 5.1456087404E+00, 6.9479530424E+00, 2.6083771772E+00, 9.2407999368E-01],
	[3.1060000000E+04, 2.2172798032E+01, 5.1456053124E+00, 6.9515861470E+00, 2.6089704045E+00, 9.2411547066E-01],
	[3.1065000000E+04, 2.2178736857E+01, 5.1456018850E+00, 6.9552205652E+00, 2.6095635164E+00, 9.2415093011E-01],
	[3.1070000000E+04, 2.2184676315E+01, 5.1455984581E+00, 6.9588562971E+00, 2.6101565128E+00, 9.2418637204E-01],
	[3.1075000000E+04, 2.2190616408E+01, 5.1455950317E+00, 6.9624933431E+00, 2.6107493937E+00, 9.2422179645E-01],
	[3.1080000000E+04, 2.2196557136E+01, 5.1455916059E+00, 6.9661317034E+00, 2.6113421590E+00, 9.2425720336E-01],
	[3.1085000000E+04, 2.2202498498E+01, 5.1455881807E+00, 6.9697713783E+00, 2.6119348087E+00, 9.2429259277E-01],
	[3.1090000000E+04, 2.2208440494E+01, 5.1455847560E+00, 6.9734123680E+00, 2.6125273429E+00, 9.2432796469E-01],
	[3.1095000000E+04, 2.2214383125E+01, 5.1455813319E+00, 6.9770546728E+00, 2.6131197614E+00, 9.2436331914E-01],
	[3.1100000000E+04, 2.2220326390E+01, 5.1455779083E+00, 6.9806982929E+00, 2.6137120643E+00, 9.2439865611E-01],
	[3.1105000000E+04, 2.2226270289E+01, 5.1455744853E+00, 6.9843432287E+00, 2.6143042515E+00, 9.2443397561E-01],
	[3.1110000000E+04, 2.2232214823E+01, 5.1455710628E+00, 6.9879894804E+00, 2.6148963231E+00, 9.2446927767E-01],
	[3.1115000000E+04, 2.2238159990E+01, 5.1455676409E+00, 6.9916370482E+00, 2.6154882789E+00, 9.2450456227E-01],
	[3.1120000000E+04, 2.2244105792E+01, 5.1455642195E+00, 6.9952859324E+00, 2.6160801190E+00, 9.2453982943E-01],
	[3.1125000000E+04, 2.2250052228E+01, 5.1455607987E+00, 6.9989361333E+00, 2.6166718433E+00, 9.2457507917E-01],
	[3.1130000000E+04, 2.2255999298E+01, 5.1455573784E+00, 7.0025876511E+00, 2.6172634518E+00, 9.2461031147E-01],
	[3.1135000000E+04, 2.2261947002E+01, 5.1455539587E+00, 7.0062404861E+00, 2.6178549445E+00, 9.2464552637E-01],
	[3.1140000000E+04, 2.2267895340E+01, 5.1455505396E+00, 7.0098946386E+00, 2.6184463214E+00, 9.2468072386E-01],
	[3.1145000000E+04, 2.2273844312E+01, 5.1455471210E+00, 7.0135501088E+00, 2.6190375824E+00, 9.2471590395E-01],
	[3.1150000000E+04, 2.2279793918E+01, 5.1455437029E+00, 7.0172068970E+00, 2.6196287275E+00, 9.2475106665E-01],
	[3.1155000000E+04, 2.2285744158E+01, 5.1455402854E+00, 7.0208650035E+00, 2.6202197568E+00, 9.2478621196E-01],
	[3.1160000000E+04, 2.2291695032E+01, 5.1455368684E+00, 7.0245244284E+00, 2.6208106701E+00, 9.2482133991E-01],
	[3.1165000000E+04, 2.2297646539E+01, 5.1455334520E+00, 7.0281851722E+00, 2.6214014674E+00, 9.2485645048E-01],
	[3.1170000000E+04, 2.2303598681E+01, 5.1455300362E+00, 7.0318472350E+00, 2.6219921487E+00, 9.2489154370E-01],
	[3.1175000000E+04, 2.2309551456E+01, 5.1455266209E+00, 7.0355106171E+00, 2.6225827141E+00, 9.2492661958E-01],
	[3.1180000000E+04, 2.2315504865E+01, 5.1455232061E+00, 7.0391753187E+00, 2.6231731634E+00, 9.2496167811E-01],
	[3.1185000000E+04, 2.2321458907E+01, 5.1455197919E+00, 7.0428413402E+00, 2.6237634967E+00, 9.2499671930E-01],
	[3.1190000000E+04, 2.2327413583E+01, 5.1455163783E+00, 7.0465086818E+00, 2.6243537139E+00, 9.2503174317E-01],
	[3.1195000000E+04, 2.2333368893E+01, 5.1455129651E+00, 7.0501773437E+00, 2.6249438150E+00, 9.2506674973E-01],
	[3.1200000000E+04, 2.2339324837E+01, 5.1455095526E+00, 7.0538473263E+00, 2.6255337999E+00, 9.2510173898E-01],
	[3.1205000000E+04, 2.2345281414E+01, 5.1455061406E+00, 7.0575186297E+00, 2.6261236688E+00, 9.2513671092E-01],
	[3.1210000000E+04, 2.2351238625E+01, 5.1455027291E+00, 7.0611912543E+00, 2.6267134214E+00, 9.2517166558E-01],
	[3.1215000000E+04, 2.2357196469E+01, 5.1454993182E+00, 7.0648652003E+00, 2.6273030579E+00, 9.2520660295E-01],
	[3.1220000000E+04, 2.2363154946E+01, 5.1454959078E+00, 7.0685404679E+00, 2.6278925782E+00, 9.2524152305E-01],
	[3.1225000000E+04, 2.2369114057E+01, 5.1454924980E+00, 7.0722170575E+00, 2.6284819822E+00, 9.2527642588E-01],
	[3.1230000000E+04, 2.2375073802E+01, 5.1454890888E+00, 7.0758949693E+00, 2.6290712699E+00, 9.2531131145E-01],
	[3.1235000000E+04, 2.2381034180E+01, 5.1454856801E+00, 7.0795742035E+00, 2.6296604414E+00, 9.2534617976E-01],
	[3.1240000000E+04, 2.2386995191E+01, 5.1454822719E+00, 7.0832547605E+00, 2.6302494966E+00, 9.2538103084E-01],
	[3.1245000000E+04, 2.2392956835E+01, 5.1454788643E+00, 7.0869366405E+00, 2.6308384354E+00, 9.2541586468E-01],
	[3.1250000000E+04, 2.2398919113E+01, 5.1454754572E+00, 7.0906198437E+00, 2.6314272579E+00, 9.2545068130E-01],
	[3.1255000000E+04, 2.2404882024E+01, 5.1454720507E+00, 7.0943043704E+00, 2.6320159640E+00, 9.2548548069E-01],
	[3.1260000000E+04, 2.2410845568E+01, 5.1454686447E+00, 7.0979902209E+00, 2.6326045537E+00, 9.2552026288E-01],
	[3.1265000000E+04, 2.2416809745E+01, 5.1454652392E+00, 7.1016773954E+00, 2.6331930270E+00, 9.2555502787E-01],
	[3.1270000000E+04, 2.2422774556E+01, 5.1454618344E+00, 7.1053658943E+00, 2.6337813838E+00, 9.2558977566E-01],
	[3.1275000000E+04, 2.2428739999E+01, 5.1454584300E+00, 7.1090557177E+00, 2.6343696242E+00, 9.2562450627E-01],
	[3.1280000000E+04, 2.2434706076E+01, 5.1454550262E+00, 7.1127468659E+00, 2.6349577481E+00, 9.2565921969E-01],
	[3.1285000000E+04, 2.2440672785E+01, 5.1454516230E+00, 7.1164393392E+00, 2.6355457554E+00, 9.2569391596E-01],
	[3.1290000000E+04, 2.2446640128E+01, 5.1454482203E+00, 7.1201331379E+00, 2.6361336463E+00, 9.2572859505E-01],
	[3.1295000000E+04, 2.2452608103E+01, 5.1454448181E+00, 7.1238282622E+00, 2.6367214205E+00, 9.2576325700E-01],
	[3.1300000000E+04, 2.2458576712E+01, 5.1454414165E+00, 7.1275247124E+00, 2.6373090782E+00, 9.2579790181E-01],
	[3.1305000000E+04, 2.2464545953E+01, 5.1454380154E+00, 7.1312224887E+00, 2.6378966193E+00, 9.2583252947E-01],
	[3.1310000000E+04, 2.2470515827E+01, 5.1454346149E+00, 7.1349215915E+00, 2.6384840438E+00, 9.2586714001E-01],
	[3.1315000000E+04, 2.2476486334E+01, 5.1454312150E+00, 7.1386220209E+00, 2.6390713516E+00, 9.2590173343E-01],
	[3.1320000000E+04, 2.2482457474E+01, 5.1454278155E+00, 7.1423237773E+00, 2.6396585428E+00, 9.2593630974E-01],
	[3.1325000000E+04, 2.2488429246E+01, 5.1454244166E+00, 7.1460268608E+00, 2.6402456173E+00, 9.2597086894E-01],
	[3.1330000000E+04, 2.2494401652E+01, 5.1454210183E+00, 7.1497312718E+00, 2.6408325750E+00, 9.2600541105E-01],
	[3.1335000000E+04, 2.2500374690E+01, 5.1454176205E+00, 7.1534370105E+00, 2.6414194160E+00, 9.2603993607E-01],
	[3.1340000000E+04, 2.2506348360E+01, 5.1454142233E+00, 7.1571440773E+00, 2.6420061403E+00, 9.2607444402E-01],
	[3.1345000000E+04, 2.2512322663E+01, 5.1454108266E+00, 7.1608524723E+00, 2.6425927478E+00, 9.2610893489E-01],
	[3.1350000000E+04, 2.2518297599E+01, 5.1454074304E+00, 7.1645621958E+00, 2.6431792385E+00, 9.2614340870E-01],
	[3.1355000000E+04, 2.2524273167E+01, 5.1454040348E+00, 7.1682732480E+00, 2.6437656123E+00, 9.2617786546E-01],
	[3.1360000000E+04, 2.2530249368E+01, 5.1454006397E+00, 7.1719856293E+00, 2.6443518693E+00, 9.2621230517E-01],
	[3.1365000000E+04, 2.2536226202E+01, 5.1453972452E+00, 7.1756993400E+00, 2.6449380095E+00, 9.2624672784E-01],
	[3.1370000000E+04, 2.2542203667E+01, 5.1453938512E+00, 7.1794143802E+00, 2.6455240328E+00, 9.2628113348E-01],
	[3.1375000000E+04, 2.2548181766E+01, 5.1453904577E+00, 7.1831307502E+00, 2.6461099391E+00, 9.2631552211E-01],
	[3.1380000000E+04, 2.2554179039E+01, 5.1453897558E+00, 7.1868484503E+00, 2.6466966959E+00, 9.2634989372E-01],
	[3.1385000000E+04, 2.2560179011E+01, 5.1453893526E+00, 7.1905674808E+00, 2.6472834437E+00, 9.2638424832E-01],
	[3.1390000000E+04, 2.2566179623E+01, 5.1453889495E+00, 7.1942878419E+00, 2.6478700751E+00, 9.2641858593E-01],
	[3.1395000000E+04, 2.2572180874E+01, 5.1453885464E+00, 7.1980095339E+00, 2.6484565902E+00, 9.2645290655E-01],
	[3.1400000000E+04, 2.2578182766E+01, 5.1453881435E+00, 7.2017325570E+00, 2.6490429889E+00, 9.2648721018E-01],
	[3.1405000000E+04, 2.2584185297E+01, 5.1453877405E+00, 7.2054569116E+00, 2.6496292712E+00, 9.2652149685E-01],
	[3.1410000000E+04, 2.2590188468E+01, 5.1453873377E+00, 7.2091825978E+00, 2.6502154371E+00, 9.2655576655E-01],
	[3.1415000000E+04, 2.2596192279E+01, 5.1453869349E+00, 7.2129096160E+00, 2.6508014865E+00, 9.2659001930E-01],
	[3.1420000000E+04, 2.2602196730E+01, 5.1453865322E+00, 7.2166379664E+00, 2.6513874194E+00, 9.2662425510E-01],
	[3.1425000000E+04, 2.2608201820E+01, 5.1453861295E+00, 7.2203676492E+00, 2.6519732359E+00, 9.2665847396E-01],
	[3.1430000000E+04, 2.2614207551E+01, 5.1453857269E+00, 7.2240986648E+00, 2.6525589358E+00, 9.2669267589E-01],
	[3.1435000000E+04, 2.2620213921E+01, 5.1453853244E+00, 7.2278310134E+00, 2.6531445192E+00, 9.2672686089E-01],
	[3.1440000000E+04, 2.2626220930E+01, 5.1453849219E+00, 7.2315646952E+00, 2.6537299860E+00, 9.2676102898E-01],
	[3.1445000000E+04, 2.2632228579E+01, 5.1453845195E+00, 7.2352997106E+00, 2.6543153363E+00, 9.2679518017E-01],
	[3.1450000000E+04, 2.2638236868E+01, 5.1453841171E+00, 7.2390360597E+00, 2.6549005700E+00, 9.2682931445E-01],
	[3.1455000000E+04, 2.2644245796E+01, 5.1453837149E+00, 7.2427737429E+00, 2.6554856870E+00, 9.2686343185E-01],
	[3.1460000000E+04, 2.2650255364E+01, 5.1453833127E+00, 7.2465127604E+00, 2.6560706874E+00, 9.2689753236E-01],
	[3.1465000000E+04, 2.2656265571E+01, 5.1453829105E+00, 7.2502531125E+00, 2.6566555711E+00, 9.2693161600E-01],
	[3.1470000000E+04, 2.2662276417E+01, 5.1453825084E+00, 7.2539947994E+00, 2.6572403382E+00, 9.2696568278E-01],
	[3.1475000000E+04, 2.2668287903E+01, 5.1453821064E+00, 7.2577378215E+00, 2.6578249886E+00, 9.2699973269E-01],
	[3.1480000000E+04, 2.2674300029E+01, 5.1453817044E+00, 7.2614821788E+00, 2.6584095222E+00, 9.2703376576E-01],
	[3.1485000000E+04, 2.2680312793E+01, 5.1453813025E+00, 7.2652278719E+00, 2.6589939391E+00, 9.2706778199E-01],
	[3.1490000000E+04, 2.2686326197E+01, 5.1453809007E+00, 7.2689749008E+00, 2.6595782392E+00, 9.2710178138E-01],
	[3.1495000000E+04, 2.2692340241E+01, 5.1453804989E+00, 7.2727232659E+00, 2.6601624225E+00, 9.2713576395E-01],
	[3.1500000000E+04, 2.2698354923E+01, 5.1453800972E+00, 7.2764729674E+00, 2.6607464891E+00, 9.2716972971E-01],
	[3.1505000000E+04, 2.2704370245E+01, 5.1453796956E+00, 7.2802240056E+00, 2.6613304388E+00, 9.2720367865E-01],
	[3.1510000000E+04, 2.2710386206E+01, 5.1453792940E+00, 7.2839763807E+00, 2.6619142716E+00, 9.2723761079E-01],
	[3.1515000000E+04, 2.2716402806E+01, 5.1453788925E+00, 7.2877300931E+00, 2.6624979876E+00, 9.2727152615E-01],
	[3.1520000000E+04, 2.2722420045E+01, 5.1453784911E+00, 7.2914851429E+00, 2.6630815867E+00, 9.2730542472E-01],
	[3.1525000000E+04, 2.2728437923E+01, 5.1453780897E+00, 7.2952415305E+00, 2.6636650689E+00, 9.2733930651E-01],
	[3.1530000000E+04, 2.2734456440E+01, 5.1453776884E+00, 7.2989992560E+00, 2.6642484342E+00, 9.2737317154E-01],
	[3.1535000000E+04, 2.2740475596E+01, 5.1453772871E+00, 7.3027583199E+00, 2.6648316825E+00, 9.2740701980E-01],
	[3.1540000000E+04, 2.2746495391E+01, 5.1453768859E+00, 7.3065187222E+00, 2.6654148139E+00, 9.2744085132E-01],
	[3.1545000000E+04, 2.2752515825E+01, 5.1453764848E+00, 7.3102804634E+00, 2.6659978282E+00, 9.2747466609E-01],
	[3.1550000000E+04, 2.2758536898E+01, 5.1453760837E+00, 7.3140435437E+00, 2.6665807256E+00, 9.2750846413E-01],
	[3.1555000000E+04, 2.2764558610E+01, 5.1453756827E+00, 7.3178079632E+00, 2.6671635059E+00, 9.2754224544E-01],
	[3.1560000000E+04, 2.2770580961E+01, 5.1453752818E+00, 7.3215737223E+00, 2.6677461692E+00, 9.2757601004E-01],
	[3.1565000000E+04, 2.2776603950E+01, 5.1453748809E+00, 7.3253408213E+00, 2.6683287154E+00, 9.2760975792E-01],
	[3.1570000000E+04, 2.2782627578E+01, 5.1453744801E+00, 7.3291092605E+00, 2.6689111445E+00, 9.2764348911E-01],
	[3.1575000000E+04, 2.2788651845E+01, 5.1453740793E+00, 7.3328790399E+00, 2.6694934565E+00, 9.2767720360E-01],
	[3.1580000000E+04, 2.2794676751E+01, 5.1453736786E+00, 7.3366501601E+00, 2.6700756514E+00, 9.2771090140E-01],
	[3.1585000000E+04, 2.2800702295E+01, 5.1453732780E+00, 7.3404226211E+00, 2.6706577291E+00, 9.2774458253E-01],
	[3.1590000000E+04, 2.2806728478E+01, 5.1453728775E+00, 7.3441964233E+00, 2.6712396897E+00, 9.2777824698E-01],
	[3.1595000000E+04, 2.2812755300E+01, 5.1453724770E+00, 7.3479715670E+00, 2.6718215331E+00, 9.2781189478E-01],
	[3.1600000000E+04, 2.2818782760E+01, 5.1453720765E+00, 7.3517480523E+00, 2.6724032592E+00, 9.2784552592E-01],
	[3.1605000000E+04, 2.2824810858E+01, 5.1453716762E+00, 7.3555258796E+00, 2.6729848682E+00, 9.2787914042E-01],
	[3.1610000000E+04, 2.2830839595E+01, 5.1453712759E+00, 7.3593050491E+00, 2.6735663599E+00, 9.2791273829E-01],
	[3.1615000000E+04, 2.2836868971E+01, 5.1453708756E+00, 7.3630855612E+00, 2.6741477343E+00, 9.2794631952E-01],
	[3.1620000000E+04, 2.2842898985E+01, 5.1453704754E+00, 7.3668674159E+00, 2.6747289915E+00, 9.2797988413E-01],
	[3.1625000000E+04, 2.2848929637E+01, 5.1453700753E+00, 7.3706506137E+00, 2.6753101313E+00, 9.2801343214E-01],
	[3.1630000000E+04, 2.2854960928E+01, 5.1453696753E+00, 7.3744351548E+00, 2.6758911539E+00, 9.2804696354E-01],
	[3.1635000000E+04, 2.2860992857E+01, 5.1453692753E+00, 7.3782210394E+00, 2.6764720591E+00, 9.2808047834E-01],
	[3.1640000000E+04, 2.2867025424E+01, 5.1453688754E+00, 7.3820082678E+00, 2.6770528469E+00, 9.2811397656E-01],
	[3.1645000000E+04, 2.2873058630E+01, 5.1453684755E+00, 7.3857968403E+00, 2.6776335173E+00, 9.2814745819E-01],
	[3.1650000000E+04, 2.2879092474E+01, 5.1453680757E+00, 7.3895867572E+00, 2.6782140704E+00, 9.2818092326E-01],
	[3.1655000000E+04, 2.2885126956E+01, 5.1453676760E+00, 7.3933780186E+00, 2.6787945060E+00, 9.2821437176E-01],
	[3.1660000000E+04, 2.2891162076E+01, 5.1453672763E+00, 7.3971706249E+00, 2.6793748242E+00, 9.2824780371E-01],
	[3.1665000000E+04, 2.2897197834E+01, 5.1453668767E+00, 7.4009645764E+00, 2.6799550250E+00, 9.2828121912E-01],
	[3.1670000000E+04, 2.2903234231E+01, 5.1453664771E+00, 7.4047598732E+00, 2.6805351082E+00, 9.2831461798E-01],
	[3.1675000000E+04, 2.2909271265E+01, 5.1453660777E+00, 7.4085565157E+00, 2.6811150740E+00, 9.2834800032E-01],
	[3.1680000000E+04, 2.2915308938E+01, 5.1453656782E+00, 7.4123545041E+00, 2.6816949223E+00, 9.2838136613E-01],
	[3.1685000000E+04, 2.2921347248E+01, 5.1453652789E+00, 7.4161538387E+00, 2.6822746530E+00, 9.2841471543E-01],
	[3.1690000000E+04, 2.2927386196E+01, 5.1453648796E+00, 7.4199545198E+00, 2.6828542662E+00, 9.2844804822E-01],
	[3.1695000000E+04, 2.2933425783E+01, 5.1453644803E+00, 7.4237565475E+00, 2.6834337618E+00, 9.2848136452E-01],
	[3.1700000000E+04, 2.2939466007E+01, 5.1453640812E+00, 7.4275599223E+00, 2.6840131398E+00, 9.2851466432E-01],
	[3.1705000000E+04, 2.2945506869E+01, 5.1453636821E+00, 7.4313646442E+00, 2.6845924003E+00, 9.2854794765E-01],
	[3.1710000000E+04, 2.2951548369E+01, 5.1453632830E+00, 7.4351707137E+00, 2.6851715431E+00, 9.2858121450E-01],
	[3.1715000000E+04, 2.2957590507E+01, 5.1453628841E+00, 7.4389781310E+00, 2.6857505682E+00, 9.2861446489E-01],
	[3.1720000000E+04, 2.2963633282E+01, 5.1453624851E+00, 7.4427868963E+00, 2.6863294757E+00, 9.2864769882E-01],
	[3.1725000000E+04, 2.2969676696E+01, 5.1453620863E+00, 7.4465970099E+00, 2.6869082656E+00, 9.2868091631E-01],
	[3.1730000000E+04, 2.2975720747E+01, 5.1453616875E+00, 7.4504084720E+00, 2.6874869377E+00, 9.2871411735E-01],
	[3.1735000000E+04, 2.2981765435E+01, 5.1453612888E+00, 7.4542212830E+00, 2.6880654921E+00, 9.2874730196E-01],
	[3.1740000000E+04, 2.2987810762E+01, 5.1453608901E+00, 7.4580354431E+00, 2.6886439288E+00, 9.2878047015E-01],
	[3.1745000000E+04, 2.2993856725E+01, 5.1453604915E+00, 7.4618509525E+00, 2.6892222477E+00, 9.2881362192E-01],
	[3.1750000000E+04, 2.2999903327E+01, 5.1453600930E+00, 7.4656678116E+00, 2.6898004489E+00, 9.2884675728E-01],
	[3.1755000000E+04, 2.3005950566E+01, 5.1453596945E+00, 7.4694860205E+00, 2.6903785323E+00, 9.2887987625E-01],
	[3.1760000000E+04, 2.3011998442E+01, 5.1453592961E+00, 7.4733055796E+00, 2.6909564979E+00, 9.2891297882E-01],
	[3.1765000000E+04, 2.3018046956E+01, 5.1453588977E+00, 7.4771264891E+00, 2.6915343456E+00, 9.2894606501E-01],
	[3.1770000000E+04, 2.3024096107E+01, 5.1453584994E+00, 7.4809487493E+00, 2.6921120755E+00, 9.2897913482E-01],
	[3.1775000000E+04, 2.3030145896E+01, 5.1453581012E+00, 7.4847723604E+00, 2.6926896876E+00, 9.2901218827E-01],
	[3.1780000000E+04, 2.3036196322E+01, 5.1453577030E+00, 7.4885973227E+00, 2.6932671818E+00, 9.2904522536E-01],
	[3.1785000000E+04, 2.3042247385E+01, 5.1453573049E+00, 7.4924236365E+00, 2.6938445581E+00, 9.2907824610E-01],
	[3.1790000000E+04, 2.3048299086E+01, 5.1453569069E+00, 7.4962513020E+00, 2.6944218164E+00, 9.2911125050E-01],
	[3.1795000000E+04, 2.3054351424E+01, 5.1453565089E+00, 7.5000803195E+00, 2.6949989569E+00, 9.2914423856E-01],
	[3.1800000000E+04, 2.3060404399E+01, 5.1453561110E+00, 7.5039106893E+00, 2.6955759794E+00, 9.2917721030E-01],
	[3.1805000000E+04, 2.3066458012E+01, 5.1453557132E+00, 7.5077424116E+00, 2.6961528839E+00, 9.2921016571E-01],
	[3.1810000000E+04, 2.3072512261E+01, 5.1453553154E+00, 7.5115754867E+00, 2.6967296705E+00, 9.2924310482E-01],
	[3.1815000000E+04, 2.3078567148E+01, 5.1453549177E+00, 7.5154099149E+00, 2.6973063391E+00, 9.2927602763E-01],
	[3.1820000000E+04, 2.3084622672E+01, 5.1453545200E+00, 7.5192456963E+00, 2.6978828896E+00, 9.2930893414E-01],
	[3.1825000000E+04, 2.3090678832E+01, 5.1453541224E+00, 7.5230828314E+00, 2.6984593221E+00, 9.2934182437E-01],
	[3.1830000000E+04, 2.3096735630E+01, 5.1453537249E+00, 7.5269213203E+00, 2.6990356366E+00, 9.2937469832E-01],
	[3.1835000000E+04, 2.3102793065E+01, 5.1453533274E+00, 7.5307611633E+00, 2.6996118330E+00, 9.2940755601E-01],
	[3.1840000000E+04, 2.3108851137E+01, 5.1453529300E+00, 7.5346023607E+00, 2.7001879113E+00, 9.2944039743E-01],
	[3.1845000000E+04, 2.3114909846E+01, 5.1453525326E+00, 7.5384449127E+00, 2.7007638715E+00, 9.2947322260E-01],
	[3.1850000000E+04, 2.3120969191E+01, 5.1453521353E+00, 7.5422888197E+00, 2.7013397136E+00, 9.2950603152E-01],
	[3.1855000000E+04, 2.3127029174E+01, 5.1453517381E+00, 7.5461340818E+00, 2.7019154376E+00, 9.2953882421E-01],
	[3.1860000000E+04, 2.3133089793E+01, 5.1453513410E+00, 7.5499806993E+00, 2.7024910434E+00, 9.2957160067E-01],
	[3.1865000000E+04, 2.3139151050E+01, 5.1453509439E+00, 7.5538286726E+00, 2.7030665310E+00, 9.2960436091E-01],
	[3.1870000000E+04, 2.3145212943E+01, 5.1453505468E+00, 7.5576780018E+00, 2.7036419005E+00, 9.2963710493E-01],
	[3.1875000000E+04, 2.3151275472E+01, 5.1453501498E+00, 7.5615286872E+00, 2.7042171517E+00, 9.2966983276E-01],
	[3.1880000000E+04, 2.3157338639E+01, 5.1453497529E+00, 7.5653807291E+00, 2.7047922847E+00, 9.2970254438E-01],
	[3.1885000000E+04, 2.3163420379E+01, 5.1453519325E+00, 7.5692341278E+00, 2.7053682565E+00, 9.2973523982E-01],
	[3.1890000000E+04, 2.3169505221E+01, 5.1453544647E+00, 7.5730888835E+00, 2.7059442417E+00, 9.2976791908E-01],
	[3.1895000000E+04, 2.3175590707E+01, 5.1453569965E+00, 7.5769449965E+00, 2.7065201092E+00, 9.2980058217E-01],
	[3.1900000000E+04, 2.3181676836E+01, 5.1453595279E+00, 7.5808024670E+00, 2.7070958590E+00, 9.2983322910E-01],
	[3.1905000000E+04, 2.3187763610E+01, 5.1453620589E+00, 7.5846612954E+00, 2.7076714911E+00, 9.2986585987E-01],
	[3.1910000000E+04, 2.3193851028E+01, 5.1453645895E+00, 7.5885214818E+00, 2.7082470055E+00, 9.2989847449E-01],
	[3.1915000000E+04, 2.3199939089E+01, 5.1453671197E+00, 7.5923830266E+00, 2.7088224022E+00, 9.2993107297E-01],
	[3.1920000000E+04, 2.3206027795E+01, 5.1453696495E+00, 7.5962459300E+00, 2.7093976812E+00, 9.2996365533E-01],
	[3.1925000000E+04, 2.3212117145E+01, 5.1453721789E+00, 7.6001101922E+00, 2.7099728423E+00, 9.2999622156E-01],
	[3.1930000000E+04, 2.3218207138E+01, 5.1453747079E+00, 7.6039758136E+00, 2.7105478858E+00, 9.3002877168E-01],
	[3.1935000000E+04, 2.3224297775E+01, 5.1453772365E+00, 7.6078427944E+00, 2.7111228114E+00, 9.3006130568E-01],
	[3.1940000000E+04, 2.3230389057E+01, 5.1453797647E+00, 7.6117111349E+00, 2.7116976192E+00, 9.3009382359E-01],
	[3.1945000000E+04, 2.3236480981E+01, 5.1453822925E+00, 7.6155808353E+00, 2.7122723092E+00, 9.3012632540E-01],
	[3.1950000000E+04, 2.3242573550E+01, 5.1453848200E+00, 7.6194518959E+00, 2.7128468813E+00, 9.3015881113E-01],
	[3.1955000000E+04, 2.3248666762E+01, 5.1453873470E+00, 7.6233243169E+00, 2.7134213356E+00, 9.3019128077E-01],
	[3.1960000000E+04, 2.3254760618E+01, 5.1453898736E+00, 7.6271980987E+00, 2.7139956720E+00, 9.3022373434E-01],
	[3.1965000000E+04, 2.3260855118E+01, 5.1453923999E+00, 7.6310732414E+00, 2.7145698905E+00, 9.3025617185E-01],
	[3.1970000000E+04, 2.3266950261E+01, 5.1453949258E+00, 7.6349497455E+00, 2.7151439911E+00, 9.3028859329E-01],
	[3.1975000000E+04, 2.3273046048E+01, 5.1453974512E+00, 7.6388276110E+00, 2.7157179738E+00, 9.3032099869E-01],
	[3.1980000000E+04, 2.3279142478E+01, 5.1453999763E+00, 7.6427068383E+00, 2.7162918385E+00, 9.3035338804E-01],
	[3.1985000000E+04, 2.3285239552E+01, 5.1454025010E+00, 7.6465874277E+00, 2.7168655853E+00, 9.3038576135E-01],
	[3.1990000000E+04, 2.3291337270E+01, 5.1454050252E+00, 7.6504693794E+00, 2.7174392141E+00, 9.3041811863E-01],
	[3.1995000000E+04, 2.3297435630E+01, 5.1454075491E+00, 7.6543526936E+00, 2.7180127249E+00, 9.3045045989E-01],
	[3.2000000000E+04, 2.3303534635E+01, 5.1454100726E+00, 7.6582373707E+00, 2.7185861177E+00, 9.3048278513E-01],
	[3.2005000000E+04, 2.3309634282E+01, 5.1454125957E+00, 7.6621234109E+00, 2.7191593925E+00, 9.3051509436E-01],
	[3.2010000000E+04, 2.3315734573E+01, 5.1454151184E+00, 7.6660108145E+00, 2.7197325493E+00, 9.3054738759E-01],
	[3.2015000000E+04, 2.3321835507E+01, 5.1454176408E+00, 7.6698995817E+00, 2.7203055880E+00, 9.3057966482E-01],
	[3.2020000000E+04, 2.3327937085E+01, 5.1454201627E+00, 7.6737897128E+00, 2.7208785087E+00, 9.3061192607E-01],
	[3.2025000000E+04, 2.3334039306E+01, 5.1454226842E+00, 7.6776812081E+00, 2.7214513113E+00, 9.3064417134E-01],
	[3.2030000000E+04, 2.3340142170E+01, 5.1454252053E+00, 7.6815740678E+00, 2.7220239957E+00, 9.3067640063E-01],
	[3.2035000000E+04, 2.3346245677E+01, 5.1454277261E+00, 7.6854682922E+00, 2.7225965621E+00, 9.3070861396E-01],
	[3.2040000000E+04, 2.3352349827E+01, 5.1454302464E+00, 7.6893638815E+00, 2.7231690103E+00, 9.3074081133E-01],
	[3.2045000000E+04, 2.3358454621E+01, 5.1454327664E+00, 7.6932608361E+00, 2.7237413404E+00, 9.3077299274E-01],
	[3.2050000000E+04, 2.3364560057E+01, 5.1454352860E+00, 7.6971591562E+00, 2.7243135523E+00, 9.3080515821E-01],
	[3.2055000000E+04, 2.3370666137E+01, 5.1454378052E+00, 7.7010588420E+00, 2.7248856461E+00, 9.3083730774E-01],
	[3.2060000000E+04, 2.3376772859E+01, 5.1454403239E+00, 7.7049598939E+00, 2.7254576217E+00, 9.3086944135E-01],
	[3.2065000000E+04, 2.3382880225E+01, 5.1454428423E+00, 7.7088623120E+00, 2.7260294790E+00, 9.3090155902E-01],
	[3.2070000000E+04, 2.3388988234E+01, 5.1454453603E+00, 7.7127660967E+00, 2.7266012182E+00, 9.3093366079E-01],
	[3.2075000000E+04, 2.3395096885E+01, 5.1454478780E+00, 7.7166712482E+00, 2.7271728391E+00, 9.3096574664E-01],
	[3.2080000000E+04, 2.3401206180E+01, 5.1454503952E+00, 7.7205777667E+00, 2.7277443418E+00, 9.3099781659E-01],
	[3.2085000000E+04, 2.3407316117E+01, 5.1454529120E+00, 7.7244856526E+00, 2.7283157262E+00, 9.3102987065E-01],
	[3.2090000000E+04, 2.3413426697E+01, 5.1454554285E+00, 7.7283949061E+00, 2.7288869923E+00, 9.3106190881E-01],
	[3.2095000000E+04, 2.3419537920E+01, 5.1454579445E+00, 7.7323055275E+00, 2.7294581401E+00, 9.3109393110E-01],
	[3.2100000000E+04, 2.3425649785E+01, 5.1454604602E+00, 7.7362175171E+00, 2.7300291696E+00, 9.3112593751E-01],
	[3.2105000000E+04, 2.3431762294E+01, 5.1454629754E+00, 7.7401308750E+00, 2.7306000808E+00, 9.3115792806E-01],
	[3.2110000000E+04, 2.3437875445E+01, 5.1454654903E+00, 7.7440456016E+00, 2.7311708736E+00, 9.3118990275E-01],
	[3.2115000000E+04, 2.3443989239E+01, 5.1454680048E+00, 7.7479616971E+00, 2.7317415481E+00, 9.3122186159E-01],
	[3.2120000000E+04, 2.3450103675E+01, 5.1454705189E+00, 7.7518791619E+00, 2.7323121043E+00, 9.3125380458E-01],
	[3.2125000000E+04, 2.3456218754E+01, 5.1454730326E+00, 7.7557979960E+00, 2.7328825420E+00, 9.3128573173E-01],
	[3.2130000000E+04, 2.3462334475E+01, 5.1454755459E+00, 7.7597182000E+00, 2.7334528613E+00, 9.3131764306E-01],
	[3.2135000000E+04, 2.3468450839E+01, 5.1454780588E+00, 7.7636397739E+00, 2.7340230623E+00, 9.3134953856E-01],
	[3.2140000000E+04, 2.3474567846E+01, 5.1454805714E+00, 7.7675627180E+00, 2.7345931448E+00, 9.3138141824E-01],
	[3.2145000000E+04, 2.3480685495E+01, 5.1454830835E+00, 7.7714870327E+00, 2.7351631088E+00, 9.3141328212E-01],
	[3.2150000000E+04, 2.3486803786E+01, 5.1454855953E+00, 7.7754127182E+00, 2.7357329545E+00, 9.3144513019E-01],
	[3.2155000000E+04, 2.3492922720E+01, 5.1454881066E+00, 7.7793397747E+00, 2.7363026816E+00, 9.3147696247E-01],
	[3.2160000000E+04, 2.3499042297E+01, 5.1454906176E+00, 7.7832682026E+00, 2.7368722902E+00, 9.3150877896E-01],
	[3.2165000000E+04, 2.3505162515E+01, 5.1454931282E+00, 7.7871980020E+00, 2.7374417804E+00, 9.3154057968E-01],
	[3.2170000000E+04, 2.3511283376E+01, 5.1454956384E+00, 7.7911291733E+00, 2.7380111520E+00, 9.3157236461E-01],
	[3.2175000000E+04, 2.3517404879E+01, 5.1454981482E+00, 7.7950617166E+00, 2.7385804052E+00, 9.3160413379E-01],
	[3.2180000000E+04, 2.3523527025E+01, 5.1455006577E+00, 7.7989956324E+00, 2.7391495397E+00, 9.3163588720E-01],
	[3.2185000000E+04, 2.3529649812E+01, 5.1455031667E+00, 7.8029309208E+00, 2.7397185557E+00, 9.3166762486E-01],
	[3.2190000000E+04, 2.3535773242E+01, 5.1455056753E+00, 7.8068675821E+00, 2.7402874532E+00, 9.3169934678E-01],
	[3.2195000000E+04, 2.3541897314E+01, 5.1455081836E+00, 7.8108056166E+00, 2.7408562321E+00, 9.3173105296E-01],
	[3.2200000000E+04, 2.3548022028E+01, 5.1455106915E+00, 7.8147450245E+00, 2.7414248923E+00, 9.3176274341E-01],
	[3.2205000000E+04, 2.3554147384E+01, 5.1455131989E+00, 7.8186858061E+00, 2.7419934340E+00, 9.3179441814E-01],
	[3.2210000000E+04, 2.3560273382E+01, 5.1455157060E+00, 7.8226279617E+00, 2.7425618570E+00, 9.3182607715E-01],
	[3.2215000000E+04, 2.3566400022E+01, 5.1455182127E+00, 7.8265714915E+00, 2.7431301614E+00, 9.3185772046E-01],
	[3.2220000000E+04, 2.3572527305E+01, 5.1455207191E+00, 7.8305163959E+00, 2.7436983471E+00, 9.3188934806E-01],
	[3.2225000000E+04, 2.3578655229E+01, 5.1455232250E+00, 7.8344626749E+00, 2.7442664142E+00, 9.3192095997E-01],
	[3.2230000000E+04, 2.3584783795E+01, 5.1455257305E+00, 7.8384103290E+00, 2.7448343626E+00, 9.3195255619E-01],
	[3.2235000000E+04, 2.3590913003E+01, 5.1455282357E+00, 7.8423593584E+00, 2.7454021923E+00, 9.3198413673E-01],
	[3.2240000000E+04, 2.3597042852E+01, 5.1455307404E+00, 7.8463097634E+00, 2.7459699033E+00, 9.3201570160E-01],
	[3.2245000000E+04, 2.3603173344E+01, 5.1455332448E+00, 7.8502615442E+00, 2.7465374956E+00, 9.3204725080E-01],
	[3.2250000000E+04, 2.3609304477E+01, 5.1455357488E+00, 7.8542147011E+00, 2.7471049691E+00, 9.3207878435E-01],
	[3.2255000000E+04, 2.3615436252E+01, 5.1455382524E+00, 7.8581692343E+00, 2.7476723239E+00, 9.3211030224E-01],
	[3.2260000000E+04, 2.3621568669E+01, 5.1455407556E+00, 7.8621251441E+00, 2.7482395599E+00, 9.3214180449E-01],
	[3.2265000000E+04, 2.3627701728E+01, 5.1455432585E+00, 7.8660824308E+00, 2.7488066772E+00, 9.3217329111E-01],
	[3.2270000000E+04, 2.3633835428E+01, 5.1455457609E+00, 7.8700410947E+00, 2.7493736756E+00, 9.3220476209E-01],
	[3.2275000000E+04, 2.3639969770E+01, 5.1455482630E+00, 7.8740011360E+00, 2.7499405553E+00, 9.3223621746E-01],
	[3.2280000000E+04, 2.3646104753E+01, 5.1455507647E+00, 7.8779625550E+00, 2.7505073161E+00, 9.3226765720E-01],
	[3.2285000000E+04, 2.3652240378E+01, 5.1455532659E+00, 7.8819253519E+00, 2.7510739581E+00, 9.3229908134E-01],
	[3.2290000000E+04, 2.3658376645E+01, 5.1455557668E+00, 7.8858895270E+00, 2.7516404813E+00, 9.3233048988E-01],
	[3.2295000000E+04, 2.3664513553E+01, 5.1455582674E+00, 7.8898550806E+00, 2.7522068856E+00, 9.3236188283E-01],
	[3.2300000000E+04, 2.3670651102E+01, 5.1455607675E+00, 7.8938220130E+00, 2.7527731711E+00, 9.3239326019E-01],
	[3.2305000000E+04, 2.3676789293E+01, 5.1455632672E+00, 7.8977903243E+00, 2.7533393377E+00, 9.3242462197E-01],
	[3.2310000000E+04, 2.3682928126E+01, 5.1455657666E+00, 7.9017600149E+00, 2.7539053854E+00, 9.3245596818E-01],
	[3.2315000000E+04, 2.3689067599E+01, 5.1455682656E+00, 7.9057310851E+00, 2.7544713141E+00, 9.3248729883E-01],
	[3.2320000000E+04, 2.3695207714E+01, 5.1455707641E+00, 7.9097035350E+00, 2.7550371240E+00, 9.3251861391E-01],
	[3.2325000000E+04, 2.3701348471E+01, 5.1455732623E+00, 7.9136773651E+00, 2.7556028149E+00, 9.3254991345E-01],
	[3.2330000000E+04, 2.3707489868E+01, 5.1455757602E+00, 7.9176525754E+00, 2.7561683869E+00, 9.3258119745E-01],
	[3.2335000000E+04, 2.3713631907E+01, 5.1455782576E+00, 7.9216291664E+00, 2.7567338399E+00, 9.3261246590E-01],
	[3.2340000000E+04, 2.3719774587E+01, 5.1455807546E+00, 7.9256071382E+00, 2.7572991740E+00, 9.3264371884E-01],
	[3.2345000000E+04, 2.3725917908E+01, 5.1455832513E+00, 7.9295864911E+00, 2.7578643891E+00, 9.3267495624E-01],
	[3.2350000000E+04, 2.3732061871E+01, 5.1455857476E+00, 7.9335672255E+00, 2.7584294851E+00, 9.3270617814E-01],
	[3.2355000000E+04, 2.3738206474E+01, 5.1455882435E+00, 7.9375493415E+00, 2.7589944622E+00, 9.3273738453E-01],
	[3.2360000000E+04, 2.3744351719E+01, 5.1455907390E+00, 7.9415328394E+00, 2.7595593203E+00, 9.3276857541E-01],
	[3.2365000000E+04, 2.3750497605E+01, 5.1455932341E+00, 7.9455177195E+00, 2.7601240593E+00, 9.3279975081E-01],
	[3.2370000000E+04, 2.3756644131E+01, 5.1455957288E+00, 7.9495039821E+00, 2.7606886792E+00, 9.3283091072E-01],
	[3.2375000000E+04, 2.3762791299E+01, 5.1455982232E+00, 7.9534916274E+00, 2.7612531802E+00, 9.3286205515E-01],
	[3.2380000000E+04, 2.3768939107E+01, 5.1456007172E+00, 7.9574806556E+00, 2.7618175620E+00, 9.3289318412E-01],
	[3.2385000000E+04, 2.3775087557E+01, 5.1456032108E+00, 7.9614710672E+00, 2.7623818248E+00, 9.3292429761E-01],
	[3.2390000000E+04, 2.3781236647E+01, 5.1456057040E+00, 7.9654628622E+00, 2.7629459684E+00, 9.3295539566E-01],
	[3.2395000000E+04, 2.3787391074E+01, 5.1456088647E+00, 7.9694560410E+00, 2.7635102490E+00, 9.3298647825E-01],
	[3.2400000000E+04, 2.3793561631E+01, 5.1456142274E+00, 7.9734506039E+00, 2.7640752552E+00, 9.3301754540E-01],
	[3.2405000000E+04, 2.3799732837E+01, 5.1456195894E+00, 7.9774469753E+00, 2.7646401938E+00, 9.3304859711E-01],
	[3.2410000000E+04, 2.3805904690E+01, 5.1456249505E+00, 7.9814459395E+00, 2.7652051587E+00, 9.3307963340E-01],
	[3.2415000000E+04, 2.3812077192E+01, 5.1456303108E+00, 7.9854462900E+00, 2.7657700051E+00, 9.3311065427E-01],
	[3.2420000000E+04, 2.3818250342E+01, 5.1456356703E+00, 7.9894480271E+00, 2.7663347328E+00, 9.3314165972E-01],
	[3.2425000000E+04, 2.3824424139E+01, 5.1456410290E+00, 7.9934511510E+00, 2.7668993419E+00, 9.3317264977E-01],
	[3.2430000000E+04, 2.3830598585E+01, 5.1456463868E+00, 7.9974556621E+00, 2.7674638323E+00, 9.3320362442E-01],
	[3.2435000000E+04, 2.3836773679E+01, 5.1456517439E+00, 8.0014615605E+00, 2.7680282040E+00, 9.3323458368E-01],
	[3.2440000000E+04, 2.3842949420E+01, 5.1456571001E+00, 8.0054688465E+00, 2.7685924570E+00, 9.3326552756E-01],
	[3.2445000000E+04, 2.3849125810E+01, 5.1456624555E+00, 8.0094775205E+00, 2.7691565914E+00, 9.3329645605E-01],
	[3.2450000000E+04, 2.3855302847E+01, 5.1456678100E+00, 8.0134875826E+00, 2.7697206070E+00, 9.3332736918E-01],
	[3.2455000000E+04, 2.3861480532E+01, 5.1456731638E+00, 8.0174990332E+00, 2.7702845039E+00, 9.3335826695E-01],
	[3.2460000000E+04, 2.3867658865E+01, 5.1456785167E+00, 8.0215118724E+00, 2.7708482821E+00, 9.3338914936E-01],
	[3.2465000000E+04, 2.3873837845E+01, 5.1456838688E+00, 8.0255261007E+00, 2.7714119415E+00, 9.3342001642E-01],
	[3.2470000000E+04, 2.3880017474E+01, 5.1456892201E+00, 8.0295417182E+00, 2.7719754822E+00, 9.3345086814E-01],
	[3.2475000000E+04, 2.3886197750E+01, 5.1456945706E+00, 8.0335587251E+00, 2.7725389041E+00, 9.3348170453E-01],
	[3.2480000000E+04, 2.3892378673E+01, 5.1456999202E+00, 8.0375771219E+00, 2.7731022072E+00, 9.3351252559E-01],
	[3.2485000000E+04, 2.3898560244E+01, 5.1457052691E+00, 8.0415969086E+00, 2.7736653916E+00, 9.3354333133E-01],
	[3.2490000000E+04, 2.3904742463E+01, 5.1457106171E+00, 8.0456180857E+00, 2.7742284571E+00, 9.3357412176E-01],
	[3.2495000000E+04, 2.3910925330E+01, 5.1457159643E+00, 8.0496406534E+00, 2.7747914038E+00, 9.3360489688E-01],
	[3.2500000000E+04, 2.3917108843E+01, 5.1457213107E+00, 8.0536646119E+00, 2.7753542317E+00, 9.3363565671E-01],
	[3.2505000000E+04, 2.3923293005E+01, 5.1457266562E+00, 8.0576899614E+00, 2.7759169408E+00, 9.3366640125E-01],
	[3.2510000000E+04, 2.3929477814E+01, 5.1457320010E+00, 8.0617167024E+00, 2.7764795309E+00, 9.3369713050E-01],
	[3.2515000000E+04, 2.3935663270E+01, 5.1457373449E+00, 8.0657448350E+00, 2.7770420023E+00, 9.3372784448E-01],
	[3.2520000000E+04, 2.3941849374E+01, 5.1457426880E+00, 8.0697743595E+00, 2.7776043547E+00, 9.3375854319E-01],
	[3.2525000000E+04, 2.3948036125E+01, 5.1457480303E+00, 8.0738052761E+00, 2.7781665883E+00, 9.3378922664E-01],
	[3.2530000000E+04, 2.3954223523E+01, 5.1457533718E+00, 8.0778375852E+00, 2.7787287030E+00, 9.3381989483E-01],
	[3.2535000000E+04, 2.3960411569E+01, 5.1457587125E+00, 8.0818712870E+00, 2.7792906988E+00, 9.3385054778E-01],
	[3.2540000000E+04, 2.3966600261E+01, 5.1457640524E+00, 8.0859063817E+00, 2.7798525756E+00, 9.3388118549E-01],
	[3.2545000000E+04, 2.3972789602E+01, 5.1457693914E+00, 8.0899428697E+00, 2.7804143336E+00, 9.3391180796E-01],
	[3.2550000000E+04, 2.3978979589E+01, 5.1457747296E+00, 8.0939807511E+00, 2.7809759725E+00, 9.3394241521E-01],
	[3.2555000000E+04, 2.3985170223E+01, 5.1457800670E+00, 8.0980200264E+00, 2.7815374926E+00, 9.3397300724E-01],
	[3.2560000000E+04, 2.3991361505E+01, 5.1457854036E+00, 8.1020606956E+00, 2.7820988936E+00, 9.3400358406E-01],
	[3.2565000000E+04, 2.3997553434E+01, 5.1457907394E+00, 8.1061027592E+00, 2.7826601757E+00, 9.3403414568E-01],
	[3.2570000000E+04, 2.4003746010E+01, 5.1457960744E+00, 8.1101462173E+00, 2.7832213389E+00, 9.3406469210E-01],
	[3.2575000000E+04, 2.4009939233E+01, 5.1458014086E+00, 8.1141910703E+00, 2.7837823830E+00, 9.3409522333E-01],
	[3.2580000000E+04, 2.4016133102E+01, 5.1458067419E+00, 8.1182373183E+00, 2.7843433081E+00, 9.3412573938E-01],
	[3.2585000000E+04, 2.4022327619E+01, 5.1458120744E+00, 8.1222849618E+00, 2.7849041142E+00, 9.3415624026E-01],
	[3.2590000000E+04, 2.4028522783E+01, 5.1458174061E+00, 8.1263340008E+00, 2.7854648013E+00, 9.3418672597E-01],
	[3.2595000000E+04, 2.4034718594E+01, 5.1458227371E+00, 8.1303844357E+00, 2.7860253693E+00, 9.3421719652E-01],
	[3.2600000000E+04, 2.4040915052E+01, 5.1458280672E+00, 8.1344362668E+00, 2.7865858183E+00, 9.3424765191E-01],
	[3.2605000000E+04, 2.4047112156E+01, 5.1458333964E+00, 8.1384894944E+00, 2.7871461482E+00, 9.3427809216E-01],
	[3.2610000000E+04, 2.4053309907E+01, 5.1458387249E+00, 8.1425441186E+00, 2.7877063590E+00, 9.3430851727E-01],
	[3.2615000000E+04, 2.4059508306E+01, 5.1458440526E+00, 8.1466001398E+00, 2.7882664508E+00, 9.3433892725E-01],
	[3.2620000000E+04, 2.4065707350E+01, 5.1458493794E+00, 8.1506575582E+00, 2.7888264235E+00, 9.3436932211E-01],
	[3.2625000000E+04, 2.4071907042E+01, 5.1458547054E+00, 8.1547163741E+00, 2.7893862771E+00, 9.3439970185E-01],
	[3.2630000000E+04, 2.4078107380E+01, 5.1458600307E+00, 8.1587765878E+00, 2.7899460115E+00, 9.3443006647E-01],
	[3.2635000000E+04, 2.4084308365E+01, 5.1458653551E+00, 8.1628381995E+00, 2.7905056269E+00, 9.3446041600E-01],
	[3.2640000000E+04, 2.4090509997E+01, 5.1458706787E+00, 8.1669012094E+00, 2.7910651231E+00, 9.3449075043E-01],
	[3.2645000000E+04, 2.4096712275E+01, 5.1458760015E+00, 8.1709656180E+00, 2.7916245002E+00, 9.3452106978E-01],
	[3.2650000000E+04, 2.4102915200E+01, 5.1458813235E+00, 8.1750314254E+00, 2.7921837581E+00, 9.3455137404E-01],
	[3.2655000000E+04, 2.4109118771E+01, 5.1458866447E+00, 8.1790986319E+00, 2.7927428968E+00, 9.3458166323E-01],
	[3.2660000000E+04, 2.4115322989E+01, 5.1458919650E+00, 8.1831672377E+00, 2.7933019164E+00, 9.3461193736E-01],
	[3.2665000000E+04, 2.4121527853E+01, 5.1458972846E+00, 8.1872372431E+00, 2.7938608168E+00, 9.3464219642E-01],
	[3.2670000000E+04, 2.4127733364E+01, 5.1459026033E+00, 8.1913086485E+00, 2.7944195980E+00, 9.3467244043E-01],
	[3.2675000000E+04, 2.4133939521E+01, 5.1459079213E+00, 8.1953814540E+00, 2.7949782600E+00, 9.3470266940E-01],
	[3.2680000000E+04, 2.4140146324E+01, 5.1459132384E+00, 8.1994556600E+00, 2.7955368028E+00, 9.3473288334E-01],
	[3.2685000000E+04, 2.4146353774E+01, 5.1459185547E+00, 8.2035312666E+00, 2.7960952264E+00, 9.3476308224E-01],
	[3.2690000000E+04, 2.4152561870E+01, 5.1459238702E+00, 8.2076082742E+00, 2.7966535307E+00, 9.3479326612E-01],
	[3.2695000000E+04, 2.4158770613E+01, 5.1459291850E+00, 8.2116866830E+00, 2.7972117158E+00, 9.3482343498E-01],
	[3.2700000000E+04, 2.4164980002E+01, 5.1459344989E+00, 8.2157664933E+00, 2.7977697816E+00, 9.3485358884E-01],
	[3.2705000000E+04, 2.4171190037E+01, 5.1459398120E+00, 8.2198477054E+00, 2.7983277282E+00, 9.3488372769E-01],
	[3.2710000000E+04, 2.4177400718E+01, 5.1459451242E+00, 8.2239303195E+00, 2.7988855555E+00, 9.3491385155E-01],
	[3.2715000000E+04, 2.4183612045E+01, 5.1459504357E+00, 8.2280143359E+00, 2.7994432635E+00, 9.3494396043E-01],
	[3.2720000000E+04, 2.4189824018E+01, 5.1459557464E+00, 8.2320997549E+00, 2.8000008522E+00, 9.3497405432E-01],
	[3.2725000000E+04, 2.4196036638E+01, 5.1459610563E+00, 8.2361865767E+00, 2.8005583216E+00, 9.3500413324E-01],
	[3.2730000000E+04, 2.4202249903E+01, 5.1459663653E+00, 8.2402748016E+00, 2.8011156717E+00, 9.3503419720E-01],
	[3.2735000000E+04, 2.4208463815E+01, 5.1459716736E+00, 8.2443644298E+00, 2.8016729025E+00, 9.3506424620E-01],
	[3.2740000000E+04, 2.4214678373E+01, 5.1459769810E+00, 8.2484554617E+00, 2.8022300140E+00, 9.3509428025E-01],
	[3.2745000000E+04, 2.4220893576E+01, 5.1459822877E+00, 8.2525478974E+00, 2.8027870061E+00, 9.3512429936E-01],
	[3.2750000000E+04, 2.4227109426E+01, 5.1459875935E+00, 8.2566417374E+00, 2.8033438789E+00, 9.3515430353E-01],
	[3.2755000000E+04, 2.4233325921E+01, 5.1459928986E+00, 8.2607369817E+00, 2.8039006323E+00, 9.3518429277E-01],
	[3.2760000000E+04, 2.4239543062E+01, 5.1459982028E+00, 8.2648336308E+00, 2.8044572663E+00, 9.3521426709E-01],
	[3.2765000000E+04, 2.4245760850E+01, 5.1460035062E+00, 8.2689316848E+00, 2.8050137810E+00, 9.3524422650E-01],
	[3.2770000000E+04, 2.4251979283E+01, 5.1460088089E+00, 8.2730311440E+00, 2.8055701763E+00, 9.3527417100E-01],
	[3.2775000000E+04, 2.4258198361E+01, 5.1460141107E+00, 8.2771320088E+00, 2.8061264521E+00, 9.3530410060E-01],
	[3.2780000000E+04, 2.4264418086E+01, 5.1460194117E+00, 8.2812342793E+00, 2.8066826086E+00, 9.3533401531E-01],
	[3.2785000000E+04, 2.4270638456E+01, 5.1460247119E+00, 8.2853379558E+00, 2.8072386457E+00, 9.3536391513E-01],
	[3.2790000000E+04, 2.4276859472E+01, 5.1460300114E+00, 8.2894430386E+00, 2.8077945633E+00, 9.3539380007E-01],
	[3.2795000000E+04, 2.4283081133E+01, 5.1460353100E+00, 8.2935495280E+00, 2.8083503616E+00, 9.3542367015E-01],
	[3.2800000000E+04, 2.4289303441E+01, 5.1460406078E+00, 8.2976574242E+00, 2.8089060403E+00, 9.3545352536E-01],
	[3.2805000000E+04, 2.4295526393E+01, 5.1460459048E+00, 8.3017667275E+00, 2.8094615996E+00, 9.3548336571E-01],
	[3.2810000000E+04, 2.4301749992E+01, 5.1460512010E+00, 8.3058774382E+00, 2.8100170395E+00, 9.3551319121E-01],
	[3.2815000000E+04, 2.4307974235E+01, 5.1460564964E+00, 8.3099895565E+00, 2.8105723599E+00, 9.3554300188E-01],
	[3.2820000000E+04, 2.4314199125E+01, 5.1460617910E+00, 8.3141030827E+00, 2.8111275608E+00, 9.3557279771E-01],
	[3.2825000000E+04, 2.4320424660E+01, 5.1460670848E+00, 8.3182180171E+00, 2.8116826423E+00, 9.3560257871E-01],
	[3.2830000000E+04, 2.4326650840E+01, 5.1460723778E+00, 8.3223343599E+00, 2.8122376042E+00, 9.3563234489E-01],
	[3.2835000000E+04, 2.4332877665E+01, 5.1460776700E+00, 8.3264521114E+00, 2.8127924467E+00, 9.3566209625E-01],
	[3.2840000000E+04, 2.4339105137E+01, 5.1460829614E+00, 8.3305712719E+00, 2.8133471696E+00, 9.3569183282E-01],
	[3.2845000000E+04, 2.4345333253E+01, 5.1460882520E+00, 8.3346918416E+00, 2.8139017730E+00, 9.3572155458E-01],
	[3.2850000000E+04, 2.4351562015E+01, 5.1460935418E+00, 8.3388138208E+00, 2.8144562569E+00, 9.3575126155E-01],
	[3.2855000000E+04, 2.4357791421E+01, 5.1460988308E+00, 8.3429372097E+00, 2.8150106212E+00, 9.3578095374E-01],
	[3.2860000000E+04, 2.4364021474E+01, 5.1461041190E+00, 8.3470620087E+00, 2.8155648660E+00, 9.3581063115E-01],
	[3.2865000000E+04, 2.4370252171E+01, 5.1461094064E+00, 8.3511882180E+00, 2.8161189913E+00, 9.3584029379E-01],
	[3.2870000000E+04, 2.4376483514E+01, 5.1461146930E+00, 8.3553158379E+00, 2.8166729970E+00, 9.3586994167E-01],
	[3.2875000000E+04, 2.4382715501E+01, 5.1461199788E+00, 8.3594448686E+00, 2.8172268831E+00, 9.3589957480E-01],
	[3.2880000000E+04, 2.4388948134E+01, 5.1461252638E+00, 8.3635753104E+00, 2.8177806496E+00, 9.3592919317E-01],
	[3.2885000000E+04, 2.4395181412E+01, 5.1461305480E+00, 8.3677071635E+00, 2.8183342966E+00, 9.3595879681E-01],
	[3.2890000000E+04, 2.4401415335E+01, 5.1461358314E+00, 8.3718404283E+00, 2.8188878239E+00, 9.3598838571E-01],
	[3.2895000000E+04, 2.4407649903E+01, 5.1461411140E+00, 8.3759751050E+00, 2.8194412317E+00, 9.3601795989E-01],
	[3.2900000000E+04, 2.4413885116E+01, 5.1461463959E+00, 8.3801111939E+00, 2.8199945198E+00, 9.3604751934E-01],
	[3.2905000000E+04, 2.4420120974E+01, 5.1461516769E+00, 8.3842486952E+00, 2.8205476883E+00, 9.3607706409E-01],
	[3.2910000000E+04, 2.4426357477E+01, 5.1461569571E+00, 8.3883876092E+00, 2.8211007372E+00, 9.3610659413E-01],
	[3.2915000000E+04, 2.4432594625E+01, 5.1461622365E+00, 8.3925279362E+00, 2.8216536665E+00, 9.3613610947E-01],
	[3.2920000000E+04, 2.4438851053E+01, 5.1461701404E+00, 8.3966696764E+00, 2.8222075142E+00, 9.3616561013E-01],
	[3.2925000000E+04, 2.4445109464E+01, 5.1461782307E+00, 8.4008128302E+00, 2.8227613169E+00, 9.3619509610E-01],
	[3.2930000000E+04, 2.4451368527E+01, 5.1461863197E+00, 8.4049573977E+00, 2.8233150006E+00, 9.3622456739E-01],
	[3.2935000000E+04, 2.4457628242E+01, 5.1461944075E+00, 8.4091033792E+00, 2.8238685651E+00, 9.3625402402E-01],
	[3.2940000000E+04, 2.4463888609E+01, 5.1462024941E+00, 8.4132507751E+00, 2.8244220106E+00, 9.3628346598E-01],
	[3.2945000000E+04, 2.4470149628E+01, 5.1462105795E+00, 8.4173995855E+00, 2.8249753369E+00, 9.3631289330E-01],
	[3.2950000000E+04, 2.4476411299E+01, 5.1462186637E+00, 8.4215498107E+00, 2.8255285441E+00, 9.3634230596E-01],
	[3.2955000000E+04, 2.4482673621E+01, 5.1462267467E+00, 8.4257014511E+00, 2.8260816321E+00, 9.3637170399E-01],
	[3.2960000000E+04, 2.4488936595E+01, 5.1462348284E+00, 8.4298545068E+00, 2.8266346011E+00, 9.3640108738E-01],
	[3.2965000000E+04, 2.4495200222E+01, 5.1462429090E+00, 8.4340089782E+00, 2.8271874508E+00, 9.3643045615E-01],
	[3.2970000000E+04, 2.4501464499E+01, 5.1462509883E+00, 8.4381648655E+00, 2.8277401814E+00, 9.3645981030E-01],
	[3.2975000000E+04, 2.4507729429E+01, 5.1462590664E+00, 8.4423221690E+00, 2.8282927929E+00, 9.3648914984E-01],
	[3.2980000000E+04, 2.4513995010E+01, 5.1462671433E+00, 8.4464808889E+00, 2.8288452851E+00, 9.3651847478E-01],
	[3.2985000000E+04, 2.4520261243E+01, 5.1462752190E+00, 8.4506410255E+00, 2.8293976582E+00, 9.3654778512E-01],
	[3.2990000000E+04, 2.4526528127E+01, 5.1462832934E+00, 8.4548025792E+00, 2.8299499121E+00, 9.3657708087E-01],
	[3.2995000000E+04, 2.4532795663E+01, 5.1462913667E+00, 8.4589655500E+00, 2.8305020468E+00, 9.3660636204E-01],
	[3.3000000000E+04, 2.4539063851E+01, 5.1462994388E+00, 8.4631299384E+00, 2.8310540623E+00, 9.3663562863E-01],
	[3.3005000000E+04, 2.4545332690E+01, 5.1463075096E+00, 8.4672957445E+00, 2.8316059586E+00, 9.3666488066E-01],
	[3.3010000000E+04, 2.4551602181E+01, 5.1463155792E+00, 8.4714629687E+00, 2.8321577356E+00, 9.3669411813E-01],
	[3.3015000000E+04, 2.4557872323E+01, 5.1463236477E+00, 8.4756316112E+00, 2.8327093935E+00, 9.3672334104E-01],
	[3.3020000000E+04, 2.4564143116E+01, 5.1463317149E+00, 8.4798016723E+00, 2.8332609321E+00, 9.3675254941E-01],
	[3.3025000000E+04, 2.4570414561E+01, 5.1463397809E+00, 8.4839731523E+00, 2.8338123514E+00, 9.3678174324E-01],
	[3.3030000000E+04, 2.4576686657E+01, 5.1463478457E+00, 8.4881460513E+00, 2.8343636516E+00, 9.3681092254E-01],
	[3.3035000000E+04, 2.4582959405E+01, 5.1463559093E+00, 8.4923203698E+00, 2.8349148324E+00, 9.3684008732E-01],
	[3.3040000000E+04, 2.4589232804E+01, 5.1463639716E+00, 8.4964961078E+00, 2.8354658940E+00, 9.3686923758E-01],
	[3.3045000000E+04, 2.4595506854E+01, 5.1463720328E+00, 8.5006732659E+00, 2.8360168363E+00, 9.3689837333E-01],
	[3.3050000000E+04, 2.4601781555E+01, 5.1463800928E+00, 8.5048518441E+00, 2.8365676594E+00, 9.3692749457E-01],
	[3.3055000000E+04, 2.4608056908E+01, 5.1463881515E+00, 8.5090318427E+00, 2.8371183631E+00, 9.3695660132E-01],
	[3.3060000000E+04, 2.4614332911E+01, 5.1463962091E+00, 8.5132132621E+00, 2.8376689476E+00, 9.3698569359E-01],
	[3.3065000000E+04, 2.4620609566E+01, 5.1464042654E+00, 8.5173961025E+00, 2.8382194128E+00, 9.3701477137E-01],
	[3.3070000000E+04, 2.4626886872E+01, 5.1464123206E+00, 8.5215803641E+00, 2.8387697587E+00, 9.3704383468E-01],
	[3.3075000000E+04, 2.4633164830E+01, 5.1464203745E+00, 8.5257660472E+00, 2.8393199852E+00, 9.3707288352E-01],
	[3.3080000000E+04, 2.4639443438E+01, 5.1464284272E+00, 8.5299531521E+00, 2.8398700924E+00, 9.3710191791E-01],
	[3.3085000000E+04, 2.4645722697E+01, 5.1464364788E+00, 8.5341416791E+00, 2.8404200803E+00, 9.3713093784E-01],
	[3.3090000000E+04, 2.4652002607E+01, 5.1464445291E+00, 8.5383316285E+00, 2.8409699489E+00, 9.3715994333E-01],
	[3.3095000000E+04, 2.4658283168E+01, 5.1464525782E+00, 8.5425230004E+00, 2.8415196982E+00, 9.3718893438E-01],
	[3.3100000000E+04, 2.4664564380E+01, 5.1464606261E+00, 8.5467157951E+00, 2.8420693280E+00, 9.3721791100E-01],
	[3.3105000000E+04, 2.4670846243E+01, 5.1464686728E+00, 8.5509100130E+00, 2.8426188386E+00, 9.3724687320E-01],
	[3.3110000000E+04, 2.4677128757E+01, 5.1464767184E+00, 8.5551056543E+00, 2.8431682297E+00, 9.3727582098E-01],
	[3.3115000000E+04, 2.4683411922E+01, 5.1464847627E+00, 8.5593027193E+00, 2.8437175016E+00, 9.3730475435E-01],
	[3.3120000000E+04, 2.4689695737E+01, 5.1464928058E+00, 8.5635012082E+00, 2.8442666540E+00, 9.3733367332E-01],
	[3.3125000000E+04, 2.4695980204E+01, 5.1465008477E+00, 8.5677011213E+00, 2.8448156870E+00, 9.3736257790E-01],
	[3.3130000000E+04, 2.4702265321E+01, 5.1465088884E+00, 8.5719024588E+00, 2.8453646007E+00, 9.3739146809E-01],
	[3.3135000000E+04, 2.4708551088E+01, 5.1465169279E+00, 8.5761052211E+00, 2.8459133950E+00, 9.3742034390E-01],
	[3.3140000000E+04, 2.4714837507E+01, 5.1465249662E+00, 8.5803094084E+00, 2.8464620698E+00, 9.3744920533E-01],
	[3.3145000000E+04, 2.4721124576E+01, 5.1465330033E+00, 8.5845150210E+00, 2.8470106253E+00, 9.3747805240E-01],
	[3.3150000000E+04, 2.4727412296E+01, 5.1465410392E+00, 8.5887220590E+00, 2.8475590614E+00, 9.3750688512E-01],
	[3.3155000000E+04, 2.4733700666E+01, 5.1465490739E+00, 8.5929305229E+00, 2.8481073780E+00, 9.3753570348E-01],
	[3.3160000000E+04, 2.4739989687E+01, 5.1465571074E+00, 8.5971404129E+00, 2.8486555752E+00, 9.3756450750E-01],
	[3.3165000000E+04, 2.4746279358E+01, 5.1465651397E+00, 8.6013517292E+00, 2.8492036530E+00, 9.3759329718E-01],
	[3.3170000000E+04, 2.4752569680E+01, 5.1465731708E+00, 8.6055644721E+00, 2.8497516113E+00, 9.3762207253E-01],
	[3.3175000000E+04, 2.4758860652E+01, 5.1465812007E+00, 8.6097786419E+00, 2.8502994502E+00, 9.3765083356E-01],
	[3.3180000000E+04, 2.4765152275E+01, 5.1465892294E+00, 8.6139942388E+00, 2.8508471697E+00, 9.3767958028E-01],
	[3.3185000000E+04, 2.4771444548E+01, 5.1465972569E+00, 8.6182112632E+00, 2.8513947697E+00, 9.3770831268E-01],
	[3.3190000000E+04, 2.4777737472E+01, 5.1466052833E+00, 8.6224297152E+00, 2.8519422502E+00, 9.3773703079E-01],
	[3.3195000000E+04, 2.4784031046E+01, 5.1466133084E+00, 8.6266495951E+00, 2.8524896113E+00, 9.3776573460E-01],
	[3.3200000000E+04, 2.4790325270E+01, 5.1466213323E+00, 8.6308709033E+00, 2.8530368529E+00, 9.3779442413E-01],
	[3.3205000000E+04, 2.4796620145E+01, 5.1466293550E+00, 8.6350936400E+00, 2.8535839750E+00, 9.3782309938E-01],
	[3.3210000000E+04, 2.4802915669E+01, 5.1466373766E+00, 8.6393178053E+00, 2.8541309776E+00, 9.3785176035E-01],
	[3.3215000000E+04, 2.4809211844E+01, 5.1466453969E+00, 8.6435433998E+00, 2.8546778607E+00, 9.3788040706E-01],
	[3.3220000000E+04, 2.4815508670E+01, 5.1466534160E+00, 8.6477704235E+00, 2.8552246243E+00, 9.3790903952E-01],
	[3.3225000000E+04, 2.4821806145E+01, 5.1466614340E+00, 8.6519988767E+00, 2.8557712685E+00, 9.3793765772E-01],
	[3.3230000000E+04, 2.4828104270E+01, 5.1466694507E+00, 8.6562287598E+00, 2.8563177931E+00, 9.3796626168E-01],
	[3.3235000000E+04, 2.4834403046E+01, 5.1466774663E+00, 8.6604600729E+00, 2.8568641982E+00, 9.3799485140E-01],
	[3.3240000000E+04, 2.4840702472E+01, 5.1466854807E+00, 8.6646928164E+00, 2.8574104838E+00, 9.3802342690E-01],
	[3.3245000000E+04, 2.4847002547E+01, 5.1466934938E+00, 8.6689269905E+00, 2.8579566499E+00, 9.3805198817E-01],
	[3.3250000000E+04, 2.4853303273E+01, 5.1467015058E+00, 8.6731625955E+00, 2.8585026964E+00, 9.3808053523E-01],
	[3.3255000000E+04, 2.4859604649E+01, 5.1467095166E+00, 8.6773996317E+00, 2.8590486234E+00, 9.3810906808E-01],
	[3.3260000000E+04, 2.4865906674E+01, 5.1467175262E+00, 8.6816380993E+00, 2.8595944308E+00, 9.3813758673E-01],
	[3.3265000000E+04, 2.4872209350E+01, 5.1467255346E+00, 8.6858779986E+00, 2.8601401187E+00, 9.3816609119E-01],
	[3.3270000000E+04, 2.4878512675E+01, 5.1467335418E+00, 8.6901193298E+00, 2.8606856871E+00, 9.3819458146E-01],
	[3.3275000000E+04, 2.4884816650E+01, 5.1467415479E+00, 8.6943620933E+00, 2.8612311359E+00, 9.3822305756E-01],
	[3.3280000000E+04, 2.4891121276E+01, 5.1467495527E+00, 8.6986062893E+00, 2.8617764651E+00, 9.3825151948E-01],
	[3.3285000000E+04, 2.4897426550E+01, 5.1467575563E+00, 8.7028519180E+00, 2.8623216747E+00, 9.3827996724E-01],
	[3.3290000000E+04, 2.4903732475E+01, 5.1467655588E+00, 8.7070989798E+00, 2.8628667648E+00, 9.3830840084E-01],
	[3.3295000000E+04, 2.4910039049E+01, 5.1467735600E+00, 8.7113474749E+00, 2.8634117353E+00, 9.3833682029E-01],
	[3.3300000000E+04, 2.4916346274E+01, 5.1467815601E+00, 8.7155974035E+00, 2.8639565862E+00, 9.3836522560E-01],
	[3.3305000000E+04, 2.4922654147E+01, 5.1467895590E+00, 8.7198487660E+00, 2.8645013175E+00, 9.3839361677E-01],
	[3.3310000000E+04, 2.4928962671E+01, 5.1467975567E+00, 8.7241015625E+00, 2.8650459293E+00, 9.3842199382E-01],
	[3.3315000000E+04, 2.4935271844E+01, 5.1468055532E+00, 8.7283557935E+00, 2.8655904214E+00, 9.3845035674E-01],
	[3.3320000000E+04, 2.4941581666E+01, 5.1468135485E+00, 8.7326114591E+00, 2.8661347939E+00, 9.3847870555E-01],
	[3.3325000000E+04, 2.4947892138E+01, 5.1468215427E+00, 8.7368685596E+00, 2.8666790468E+00, 9.3850704025E-01],
	[3.3330000000E+04, 2.4954203260E+01, 5.1468295356E+00, 8.7411270952E+00, 2.8672231801E+00, 9.3853536086E-01],
	[3.3335000000E+04, 2.4960515031E+01, 5.1468375274E+00, 8.7453870663E+00, 2.8677671938E+00, 9.3856366737E-01],
	[3.3340000000E+04, 2.4966827452E+01, 5.1468455180E+00, 8.7496484731E+00, 2.8683110878E+00, 9.3859195979E-01],
	[3.3345000000E+04, 2.4973140522E+01, 5.1468535074E+00, 8.7539113159E+00, 2.8688548622E+00, 9.3862023814E-01],
	[3.3350000000E+04, 2.4979454241E+01, 5.1468614956E+00, 8.7581755950E+00, 2.8693985170E+00, 9.3864850241E-01],
	[3.3355000000E+04, 2.4985768610E+01, 5.1468694826E+00, 8.7624413105E+00, 2.8699420522E+00, 9.3867675263E-01],
	[3.3360000000E+04, 2.4992083628E+01, 5.1468774684E+00, 8.7667084629E+00, 2.8704854677E+00, 9.3870498878E-01],
	[3.3365000000E+04, 2.4998399296E+01, 5.1468854531E+00, 8.7709770523E+00, 2.8710287635E+00, 9.3873321089E-01],
	[3.3370000000E+04, 2.5004715612E+01, 5.1468934365E+00, 8.7752470790E+00, 2.8715719397E+00, 9.3876141895E-01],
	[3.3375000000E+04, 2.5011032578E+01, 5.1469014188E+00, 8.7795185433E+00, 2.8721149962E+00, 9.3878961298E-01],
	[3.3380000000E+04, 2.5017350193E+01, 5.1469093999E+00, 8.7837914454E+00, 2.8726579331E+00, 9.3881779298E-01],
	[3.3385000000E+04, 2.5023668458E+01, 5.1469173798E+00, 8.7880657857E+00, 2.8732007503E+00, 9.3884595896E-01],
	[3.3390000000E+04, 2.5029987371E+01, 5.1469253586E+00, 8.7923415644E+00, 2.8737434478E+00, 9.3887411092E-01],
	[3.3395000000E+04, 2.5036306934E+01, 5.1469333361E+00, 8.7966187817E+00, 2.8742860257E+00, 9.3890224888E-01],
	[3.3400000000E+04, 2.5042627145E+01, 5.1469413125E+00, 8.8008974379E+00, 2.8748284838E+00, 9.3893037284E-01],
	[3.3405000000E+04, 2.5048948006E+01, 5.1469492877E+00, 8.8051775334E+00, 2.8753708223E+00, 9.3895848280E-01],
	[3.3410000000E+04, 2.5055269516E+01, 5.1469572617E+00, 8.8094590683E+00, 2.8759130411E+00, 9.3898657878E-01],
	[3.3415000000E+04, 2.5061591675E+01, 5.1469652345E+00, 8.8137420429E+00, 2.8764551402E+00, 9.3901466079E-01],
	[3.3420000000E+04, 2.5067914482E+01, 5.1469732061E+00, 8.8180264575E+00, 2.8769971196E+00, 9.3904272882E-01],
	[3.3425000000E+04, 2.5074237939E+01, 5.1469811766E+00, 8.8223123124E+00, 2.8775389793E+00, 9.3907078289E-01],
	[3.3430000000E+04, 2.5080562045E+01, 5.1469891459E+00, 8.8265996079E+00, 2.8780807193E+00, 9.3909882300E-01],
	[3.3435000000E+04, 2.5086886799E+01, 5.1469971140E+00, 8.8308883441E+00, 2.8786223395E+00, 9.3912684916E-01],
	[3.3440000000E+04, 2.5093212202E+01, 5.1470050809E+00, 8.8351785214E+00, 2.8791638401E+00, 9.3915486138E-01],
	[3.3445000000E+04, 2.5099538255E+01, 5.1470130467E+00, 8.8394701401E+00, 2.8797052209E+00, 9.3918285967E-01],
	[3.3450000000E+04, 2.5105883810E+01, 5.1470236434E+00, 8.8437632003E+00, 2.8802475544E+00, 9.3921084402E-01],
	[3.3455000000E+04, 2.5112230911E+01, 5.1470343629E+00, 8.8480577024E+00, 2.8807898194E+00, 9.3923881446E-01],
	[3.3460000000E+04, 2.5118578667E+01, 5.1470450807E+00, 8.8523536467E+00, 2.8813319652E+00, 9.3926677098E-01],
	[3.3465000000E+04, 2.5124927079E+01, 5.1470557970E+00, 8.8566510334E+00, 2.8818739917E+00, 9.3929471359E-01],
	[3.3470000000E+04, 2.5131276147E+01, 5.1470665117E+00, 8.8609498628E+00, 2.8824158991E+00, 9.3932264231E-01],
	[3.3475000000E+04, 2.5137625871E+01, 5.1470772249E+00, 8.8652501351E+00, 2.8829576873E+00, 9.3935055713E-01],
	[3.3480000000E+04, 2.5143976250E+01, 5.1470879364E+00, 8.8695518506E+00, 2.8834993562E+00, 9.3937845807E-01],
	[3.3485000000E+04, 2.5150327285E+01, 5.1470986464E+00, 8.8738550096E+00, 2.8840409060E+00, 9.3940634513E-01],
	[3.3490000000E+04, 2.5156678976E+01, 5.1471093548E+00, 8.8781596124E+00, 2.8845823365E+00, 9.3943421832E-01],
	[3.3495000000E+04, 2.5163031322E+01, 5.1471200616E+00, 8.8824656592E+00, 2.8851236478E+00, 9.3946207764E-01],
	[3.3500000000E+04, 2.5169384323E+01, 5.1471307669E+00, 8.8867731503E+00, 2.8856648399E+00, 9.3948992311E-01],
	[3.3505000000E+04, 2.5175737980E+01, 5.1471414706E+00, 8.8910820859E+00, 2.8862059128E+00, 9.3951775473E-01],
	[3.3510000000E+04, 2.5182092292E+01, 5.1471521727E+00, 8.8953924664E+00, 2.8867468664E+00, 9.3954557251E-01],
	[3.3515000000E+04, 2.5188447260E+01, 5.1471628732E+00, 8.8997042919E+00, 2.8872877008E+00, 9.3957337645E-01],
	[3.3520000000E+04, 2.5194802883E+01, 5.1471735721E+00, 8.9040175629E+00, 2.8878284160E+00, 9.3960116656E-01],
	[3.3525000000E+04, 2.5201159162E+01, 5.1471842695E+00, 8.9083322794E+00, 2.8883690119E+00, 9.3962894285E-01],
	[3.3530000000E+04, 2.5207516095E+01, 5.1471949653E+00, 8.9126484419E+00, 2.8889094886E+00, 9.3965670533E-01],
	[3.3535000000E+04, 2.5213873685E+01, 5.1472056595E+00, 8.9169660505E+00, 2.8894498460E+00, 9.3968445400E-01],
	[3.3540000000E+04, 2.5220231929E+01, 5.1472163522E+00, 8.9212851055E+00, 2.8899900842E+00, 9.3971218887E-01],
	[3.3545000000E+04, 2.5226590828E+01, 5.1472270433E+00, 8.9256056073E+00, 2.8905302031E+00, 9.3973990994E-01],
	[3.3550000000E+04, 2.5232950383E+01, 5.1472377328E+00, 8.9299275560E+00, 2.8910702028E+00, 9.3976761723E-01],
	[3.3555000000E+04, 2.5239310593E+01, 5.1472484208E+00, 8.9342509520E+00, 2.8916100832E+00, 9.3979531075E-01],
	[3.3560000000E+04, 2.5245671458E+01, 5.1472591071E+00, 8.9385757955E+00, 2.8921498443E+00, 9.3982299049E-01],
	[3.3565000000E+04, 2.5252032978E+01, 5.1472697919E+00, 8.9429020867E+00, 2.8926894862E+00, 9.3985065647E-01],
	[3.3570000000E+04, 2.5258395154E+01, 5.1472804752E+00, 8.9472298260E+00, 2.8932290088E+00, 9.3987830869E-01],
	[3.3575000000E+04, 2.5264757984E+01, 5.1472911568E+00, 8.9515590137E+00, 2.8937684121E+00, 9.3990594716E-01],
	[3.3580000000E+04, 2.5271121469E+01, 5.1473018369E+00, 8.9558896499E+00, 2.8943076961E+00, 9.3993357188E-01],
	[3.3585000000E+04, 2.5277485610E+01, 5.1473125155E+00, 8.9602217349E+00, 2.8948468609E+00, 9.3996118288E-01],
	[3.3590000000E+04, 2.5283850405E+01, 5.1473231924E+00, 8.9645552691E+00, 2.8953859063E+00, 9.3998878014E-01],
	[3.3595000000E+04, 2.5290215855E+01, 5.1473338678E+00, 8.9688902526E+00, 2.8959248325E+00, 9.4001636368E-01],
	[3.3600000000E+04, 2.5296581960E+01, 5.1473445417E+00, 8.9732266858E+00, 2.8964636394E+00, 9.4004393351E-01],
	[3.3605000000E+04, 2.5302948720E+01, 5.1473552139E+00, 8.9775645690E+00, 2.8970023269E+00, 9.4007148962E-01],
	[3.3610000000E+04, 2.5309316135E+01, 5.1473658846E+00, 8.9819039023E+00, 2.8975408952E+00, 9.4009903204E-01],
	[3.3615000000E+04, 2.5315684204E+01, 5.1473765538E+00, 8.9862446861E+00, 2.8980793442E+00, 9.4012656077E-01],
	[3.3620000000E+04, 2.5322052929E+01, 5.1473872213E+00, 8.9905869206E+00, 2.8986176739E+00, 9.4015407581E-01],
	[3.3625000000E+04, 2.5328422308E+01, 5.1473978873E+00, 8.9949306062E+00, 2.8991558842E+00, 9.4018157717E-01],
	[3.3630000000E+04, 2.5334792341E+01, 5.1474085518E+00, 8.9992757430E+00, 2.8996939753E+00, 9.4020906485E-01],
	[3.3635000000E+04, 2.5341163030E+01, 5.1474192146E+00, 9.0036223313E+00, 2.9002319470E+00, 9.4023653888E-01],
	[3.3640000000E+04, 2.5347534373E+01, 5.1474298760E+00, 9.0079703714E+00, 2.9007697994E+00, 9.4026399924E-01],
	[3.3645000000E+04, 2.5353906371E+01, 5.1474405357E+00, 9.0123198636E+00, 2.9013075325E+00, 9.4029144596E-01],
	[3.3650000000E+04, 2.5360279023E+01, 5.1474511939E+00, 9.0166708082E+00, 2.9018451463E+00, 9.4031887903E-01],
	[3.3655000000E+04, 2.5366652330E+01, 5.1474618505E+00, 9.0210232053E+00, 2.9023826407E+00, 9.4034629846E-01],
	[3.3660000000E+04, 2.5373026292E+01, 5.1474725056E+00, 9.0253770553E+00, 2.9029200158E+00, 9.4037370427E-01],
	[3.3665000000E+04, 2.5379400908E+01, 5.1474831591E+00, 9.0297323585E+00, 2.9034572716E+00, 9.4040109645E-01],
	[3.3670000000E+04, 2.5385776178E+01, 5.1474938110E+00, 9.0340891151E+00, 2.9039944080E+00, 9.4042847501E-01],
	[3.3675000000E+04, 2.5392152103E+01, 5.1475044614E+00, 9.0384473254E+00, 2.9045314252E+00, 9.4045583996E-01],
	[3.3680000000E+04, 2.5398528682E+01, 5.1475151103E+00, 9.0428069896E+00, 2.9050683229E+00, 9.4048319130E-01],
	[3.3685000000E+04, 2.5404905916E+01, 5.1475257575E+00, 9.0471681081E+00, 2.9056051013E+00, 9.4051052905E-01],
	[3.3690000000E+04, 2.5411283804E+01, 5.1475364032E+00, 9.0515306810E+00, 2.9061417604E+00, 9.4053785320E-01],
	[3.3695000000E+04, 2.5417662346E+01, 5.1475470474E+00, 9.0558947087E+00, 2.9066783002E+00, 9.4056516376E-01],
	[3.3700000000E+04, 2.5424041543E+01, 5.1475576900E+00, 9.0602601914E+00, 2.9072147205E+00, 9.4059246075E-01],
	[3.3705000000E+04, 2.5430421394E+01, 5.1475683310E+00, 9.0646271295E+00, 2.9077510216E+00, 9.4061974416E-01],
	[3.3710000000E+04, 2.5436801899E+01, 5.1475789705E+00, 9.0689955230E+00, 2.9082872032E+00, 9.4064701400E-01],
	[3.3715000000E+04, 2.5443183058E+01, 5.1475896084E+00, 9.0733653725E+00, 2.9088232655E+00, 9.4067427028E-01],
	[3.3720000000E+04, 2.5449564872E+01, 5.1476002448E+00, 9.0777366780E+00, 2.9093592085E+00, 9.4070151301E-01],
	[3.3725000000E+04, 2.5455947340E+01, 5.1476108796E+00, 9.0821094399E+00, 2.9098950321E+00, 9.4072874218E-01],
	[3.3730000000E+04, 2.5462330461E+01, 5.1476215129E+00, 9.0864836584E+00, 2.9104307363E+00, 9.4075595782E-01],
	[3.3735000000E+04, 2.5468714237E+01, 5.1476321446E+00, 9.0908593338E+00, 2.9109663212E+00, 9.4078315992E-01],
	[3.3740000000E+04, 2.5475098667E+01, 5.1476427747E+00, 9.0952364665E+00, 2.9115017867E+00, 9.4081034848E-01],
	[3.3745000000E+04, 2.5481483751E+01, 5.1476534033E+00, 9.0996150565E+00, 2.9120371328E+00, 9.4083752353E-01],
	[3.3750000000E+04, 2.5487869489E+01, 5.1476640304E+00, 9.1039951043E+00, 2.9125723595E+00, 9.4086468506E-01],
	[3.3755000000E+04, 2.5494255881E+01, 5.1476746559E+00, 9.1083766100E+00, 2.9131074669E+00, 9.4089183307E-01],
	[3.3760000000E+04, 2.5500642927E+01, 5.1476852798E+00, 9.1127595740E+00, 2.9136424549E+00, 9.4091896758E-01],
	[3.3765000000E+04, 2.5507030626E+01, 5.1476959022E+00, 9.1171439966E+00, 2.9141773235E+00, 9.4094608860E-01],
	[3.3770000000E+04, 2.5513418980E+01, 5.1477065230E+00, 9.1215298779E+00, 2.9147120727E+00, 9.4097319612E-01],
	[3.3775000000E+04, 2.5519807988E+01, 5.1477171423E+00, 9.1259172183E+00, 2.9152467026E+00, 9.4100029016E-01],
	[3.3780000000E+04, 2.5526197649E+01, 5.1477277601E+00, 9.1303060179E+00, 2.9157812131E+00, 9.4102737071E-01],
	[3.3785000000E+04, 2.5532587964E+01, 5.1477383763E+00, 9.1346962772E+00, 2.9163156041E+00, 9.4105443780E-01],
	[3.3790000000E+04, 2.5538978933E+01, 5.1477489909E+00, 9.1390879964E+00, 2.9168498758E+00, 9.4108149141E-01],
	[3.3795000000E+04, 2.5545370555E+01, 5.1477596040E+00, 9.1434811757E+00, 2.9173840281E+00, 9.4110853157E-01],
	[3.3800000000E+04, 2.5551762832E+01, 5.1477702155E+00, 9.1478758154E+00, 2.9179180610E+00, 9.4113555827E-01],
	[3.3805000000E+04, 2.5558155761E+01, 5.1477808255E+00, 9.1522719157E+00, 2.9184519745E+00, 9.4116257153E-01],
	[3.3810000000E+04, 2.5564549345E+01, 5.1477914340E+00, 9.1566694770E+00, 2.9189857686E+00, 9.4118957134E-01],
	[3.3815000000E+04, 2.5570943582E+01, 5.1478020409E+00, 9.1610684995E+00, 2.9195194433E+00, 9.4121655772E-01],
	[3.3820000000E+04, 2.5577338473E+01, 5.1478126462E+00, 9.1654689835E+00, 2.9200529986E+00, 9.4124353067E-01],
	[3.3825000000E+04, 2.5583734017E+01, 5.1478232501E+00, 9.1698709293E+00, 2.9205864346E+00, 9.4127049019E-01],
	[3.3830000000E+04, 2.5590130215E+01, 5.1478338523E+00, 9.1742743370E+00, 2.9211197511E+00, 9.4129743630E-01],
	[3.3835000000E+04, 2.5596527066E+01, 5.1478444530E+00, 9.1786792070E+00, 2.9216529482E+00, 9.4132436901E-01],
	[3.3840000000E+04, 2.5602924571E+01, 5.1478550522E+00, 9.1830855396E+00, 2.9221860259E+00, 9.4135128830E-01],
	[3.3845000000E+04, 2.5609322729E+01, 5.1478656498E+00, 9.1874933350E+00, 2.9227189841E+00, 9.4137819420E-01],
	[3.3850000000E+04, 2.5615721541E+01, 5.1478762459E+00, 9.1919025935E+00, 2.9232518230E+00, 9.4140508671E-01],
	[3.3855000000E+04, 2.5622121006E+01, 5.1478868405E+00, 9.1963133154E+00, 2.9237845425E+00, 9.4143196584E-01],
	[3.3860000000E+04, 2.5628521124E+01, 5.1478974335E+00, 9.2007255008E+00, 2.9243171425E+00, 9.4145883159E-01],
	[3.3865000000E+04, 2.5634921895E+01, 5.1479080249E+00, 9.2051391502E+00, 2.9248496232E+00, 9.4148568396E-01],
	[3.3870000000E+04, 2.5641323320E+01, 5.1479186149E+00, 9.2095542637E+00, 2.9253819844E+00, 9.4151252297E-01],
	[3.3875000000E+04, 2.5647725398E+01, 5.1479292032E+00, 9.2139708417E+00, 2.9259142262E+00, 9.4153934862E-01],
	[3.3880000000E+04, 2.5654128130E+01, 5.1479397901E+00, 9.2183888844E+00, 2.9264463486E+00, 9.4156616092E-01],
	[3.3885000000E+04, 2.5660531514E+01, 5.1479503754E+00, 9.2228083920E+00, 2.9269783516E+00, 9.4159295987E-01],
	[3.3890000000E+04, 2.5666935552E+01, 5.1479609591E+00, 9.2272293649E+00, 2.9275102352E+00, 9.4161974548E-01],
	[3.3895000000E+04, 2.5673340243E+01, 5.1479715413E+00, 9.2316518033E+00, 2.9280419993E+00, 9.4164651776E-01],
	[3.3900000000E+04, 2.5679745587E+01, 5.1479821220E+00, 9.2360757075E+00, 2.9285736440E+00, 9.4167327671E-01],
	[3.3905000000E+04, 2.5686151584E+01, 5.1479927011E+00, 9.2405010778E+00, 2.9291051693E+00, 9.4170002234E-01],
	[3.3910000000E+04, 2.5692558234E+01, 5.1480032787E+00, 9.2449279143E+00, 2.9296365752E+00, 9.4172675465E-01],
	[3.3915000000E+04, 2.5698965537E+01, 5.1480138548E+00, 9.2493562174E+00, 2.9301678616E+00, 9.4175347366E-01],
	[3.3920000000E+04, 2.5705373493E+01, 5.1480244293E+00, 9.2537859874E+00, 2.9306990286E+00, 9.4178017936E-01],
	[3.3925000000E+04, 2.5711782102E+01, 5.1480350023E+00, 9.2582172246E+00, 2.9312300762E+00, 9.4180687177E-01],
	[3.3930000000E+04, 2.5718191363E+01, 5.1480455737E+00, 9.2626499291E+00, 2.9317610044E+00, 9.4183355088E-01],
	[3.3935000000E+04, 2.5724601278E+01, 5.1480561437E+00, 9.2670841012E+00, 2.9322918131E+00, 9.4186021672E-01],
	[3.3940000000E+04, 2.5731011846E+01, 5.1480667120E+00, 9.2715197413E+00, 2.9328225024E+00, 9.4188686928E-01],
	[3.3945000000E+04, 2.5737423066E+01, 5.1480772789E+00, 9.2759568497E+00, 2.9333530723E+00, 9.4191350856E-01],
	[3.3950000000E+04, 2.5743834940E+01, 5.1480878442E+00, 9.2803954264E+00, 2.9338835227E+00, 9.4194013459E-01],
	[3.3955000000E+04, 2.5750247466E+01, 5.1480984080E+00, 9.2848354720E+00, 2.9344138537E+00, 9.4196674735E-01],
	[3.3960000000E+04, 2.5756660644E+01, 5.1481089702E+00, 9.2892769865E+00, 2.9349440653E+00, 9.4199334686E-01],
	[3.3965000000E+04, 2.5763074476E+01, 5.1481195309E+00, 9.2937199703E+00, 2.9354741575E+00, 9.4201993313E-01],
	[3.3970000000E+04, 2.5769488960E+01, 5.1481300901E+00, 9.2981644236E+00, 2.9360041302E+00, 9.4204650616E-01],
	[3.3975000000E+04, 2.5775904097E+01, 5.1481406477E+00, 9.3026103468E+00, 2.9365339834E+00, 9.4207306596E-01],
	[3.3980000000E+04, 2.5782319886E+01, 5.1481512038E+00, 9.3070577400E+00, 2.9370637173E+00, 9.4209961253E-01],
	[3.3985000000E+04, 2.5788741605E+01, 5.1481624889E+00, 9.3115066037E+00, 2.9375936380E+00, 9.4212614588E-01],
	[3.3990000000E+04, 2.5795178218E+01, 5.1481757431E+00, 9.3159569379E+00, 2.9381242661E+00, 9.4215266602E-01],
	[3.3995000000E+04, 2.5801615490E+01, 5.1481889955E+00, 9.3204087430E+00, 2.9386547752E+00, 9.4217917295E-01],
	[3.4000000000E+04, 2.5808053422E+01, 5.1482022459E+00, 9.3248620193E+00, 2.9391851655E+00, 9.4220566668E-01],
	[3.4005000000E+04, 2.5814492013E+01, 5.1482154944E+00, 9.3293167670E+00, 2.9397154368E+00, 9.4223214721E-01],
	[3.4010000000E+04, 2.5820931264E+01, 5.1482287410E+00, 9.3337729864E+00, 2.9402455892E+00, 9.4225861456E-01],
	[3.4015000000E+04, 2.5827371173E+01, 5.1482419856E+00, 9.3382306778E+00, 2.9407756227E+00, 9.4228506873E-01],
	[3.4020000000E+04, 2.5833811742E+01, 5.1482552284E+00, 9.3426898414E+00, 2.9413055373E+00, 9.4231150971E-01],
	[3.4025000000E+04, 2.5840252970E+01, 5.1482684693E+00, 9.3471504775E+00, 2.9418353330E+00, 9.4233793754E-01],
	[3.4030000000E+04, 2.5846694858E+01, 5.1482817082E+00, 9.3516125865E+00, 2.9423650097E+00, 9.4236435219E-01],
	[3.4035000000E+04, 2.5853137404E+01, 5.1482949452E+00, 9.3560761684E+00, 2.9428945675E+00, 9.4239075369E-01],
	[3.4040000000E+04, 2.5859580610E+01, 5.1483081803E+00, 9.3605412237E+00, 2.9434240064E+00, 9.4241714204E-01],
	[3.4045000000E+04, 2.5866024474E+01, 5.1483214135E+00, 9.3650077525E+00, 2.9439533264E+00, 9.4244351725E-01],
	[3.4050000000E+04, 2.5872468998E+01, 5.1483346448E+00, 9.3694757552E+00, 2.9444825274E+00, 9.4246987932E-01],
	[3.4055000000E+04, 2.5878914181E+01, 5.1483478742E+00, 9.3739452321E+00, 2.9450116096E+00, 9.4249622826E-01],
	[3.4060000000E+04, 2.5885360023E+01, 5.1483611017E+00, 9.3784161833E+00, 2.9455405728E+00, 9.4252256407E-01],
	[3.4065000000E+04, 2.5891806523E+01, 5.1483743273E+00, 9.3828886092E+00, 2.9460694171E+00, 9.4254888677E-01],
	[3.4070000000E+04, 2.5898253683E+01, 5.1483875510E+00, 9.3873625100E+00, 2.9465981424E+00, 9.4257519635E-01],
	[3.4075000000E+04, 2.5904701502E+01, 5.1484007727E+00, 9.3918378860E+00, 2.9471267489E+00, 9.4260149283E-01],
	[3.4080000000E+04, 2.5911149979E+01, 5.1484139926E+00, 9.3963147375E+00, 2.9476552364E+00, 9.4262777621E-01],
	[3.4085000000E+04, 2.5917599116E+01, 5.1484272105E+00, 9.4007930647E+00, 2.9481836050E+00, 9.4265404649E-01],
	[3.4090000000E+04, 2.5924048911E+01, 5.1484404266E+00, 9.4052728680E+00, 2.9487118547E+00, 9.4268030369E-01],
	[3.4095000000E+04, 2.5930499365E+01, 5.1484536407E+00, 9.4097541475E+00, 2.9492399854E+00, 9.4270654781E-01],
	[3.4100000000E+04, 2.5936950478E+01, 5.1484668529E+00, 9.4142369035E+00, 2.9497679973E+00, 9.4273277885E-01],
	[3.4105000000E+04, 2.5943402249E+01, 5.1484800633E+00, 9.4187211364E+00, 2.9502958902E+00, 9.4275899683E-01],
	[3.4110000000E+04, 2.5949854679E+01, 5.1484932717E+00, 9.4232068464E+00, 2.9508236641E+00, 9.4278520174E-01],
	[3.4115000000E+04, 2.5956307768E+01, 5.1485064782E+00, 9.4276940337E+00, 2.9513513192E+00, 9.4281139360E-01],
	[3.4120000000E+04, 2.5962761516E+01, 5.1485196829E+00, 9.4321826987E+00, 2.9518788553E+00, 9.4283757241E-01],
	[3.4125000000E+04, 2.5969215922E+01, 5.1485328856E+00, 9.4366728415E+00, 2.9524062726E+00, 9.4286373818E-01],
	[3.4130000000E+04, 2.5975670987E+01, 5.1485460864E+00, 9.4411644625E+00, 2.9529335708E+00, 9.4288989091E-01],
	[3.4135000000E+04, 2.5982126710E+01, 5.1485592853E+00, 9.4456575620E+00, 2.9534607502E+00, 9.4291603061E-01],
	[3.4140000000E+04, 2.5988583092E+01, 5.1485724824E+00, 9.4501521401E+00, 2.9539878107E+00, 9.4294215729E-01],
	[3.4145000000E+04, 2.5995040133E+01, 5.1485856775E+00, 9.4546481972E+00, 2.9545147522E+00, 9.4296827096E-01],
	[3.4150000000E+04, 2.6001497832E+01, 5.1485988707E+00, 9.4591457336E+00, 2.9550415748E+00, 9.4299437161E-01],
	[3.4155000000E+04, 2.6007956189E+01, 5.1486120620E+00, 9.4636447494E+00, 2.9555682785E+00, 9.4302045925E-01],
	[3.4160000000E+04, 2.6014415205E+01, 5.1486252515E+00, 9.4681452451E+00, 2.9560948632E+00, 9.4304653390E-01],
	[3.4165000000E+04, 2.6020874879E+01, 5.1486384390E+00, 9.4726472208E+00, 2.9566213291E+00, 9.4307259556E-01],
	[3.4170000000E+04, 2.6027335212E+01, 5.1486516247E+00, 9.4771506768E+00, 2.9571476760E+00, 9.4309864423E-01],
	[3.4175000000E+04, 2.6033796203E+01, 5.1486648084E+00, 9.4816556134E+00, 2.9576739040E+00, 9.4312467992E-01],
	[3.4180000000E+04, 2.6040257852E+01, 5.1486779903E+00, 9.4861620309E+00, 2.9582000131E+00, 9.4315070264E-01],
	[3.4185000000E+04, 2.6046720159E+01, 5.1486911702E+00, 9.4906699295E+00, 2.9587260033E+00, 9.4317671240E-01],
	[3.4190000000E+04, 2.6053183125E+01, 5.1487043483E+00, 9.4951793095E+00, 2.9592518745E+00, 9.4320270919E-01],
	[3.4195000000E+04, 2.6059646749E+01, 5.1487175244E+00, 9.4996901711E+00, 2.9597776269E+00, 9.4322869303E-01],
	[3.4200000000E+04, 2.6066111031E+01, 5.1487306987E+00, 9.5042025148E+00, 2.9603032603E+00, 9.4325466392E-01],
	[3.4205000000E+04, 2.6072575971E+01, 5.1487438711E+00, 9.5087163406E+00, 2.9608287748E+00, 9.4328062187E-01],
	[3.4210000000E+04, 2.6079041570E+01, 5.1487570416E+00, 9.5132316488E+00, 2.9613541704E+00, 9.4330656689E-01],
	[3.4215000000E+04, 2.6085507826E+01, 5.1487702102E+00, 9.5177484399E+00, 2.9618794470E+00, 9.4333249898E-01],
	[3.4220000000E+04, 2.6091974741E+01, 5.1487833769E+00, 9.5222667139E+00, 2.9624046048E+00, 9.4335841814E-01],
	[3.4225000000E+04, 2.6098442313E+01, 5.1487965417E+00, 9.5267864713E+00, 2.9629296437E+00, 9.4338432439E-01],
	[3.4230000000E+04, 2.6104910544E+01, 5.1488097047E+00, 9.5313077121E+00, 2.9634545636E+00, 9.4341021773E-01],
	[3.4235000000E+04, 2.6111379432E+01, 5.1488228657E+00, 9.5358304368E+00, 2.9639793646E+00, 9.4343609817E-01],
	[3.4240000000E+04, 2.6117848979E+01, 5.1488360249E+00, 9.5403546457E+00, 2.9645040467E+00, 9.4346196571E-01],
	[3.4245000000E+04, 2.6124319184E+01, 5.1488491821E+00, 9.5448803388E+00, 2.9650286099E+00, 9.4348782036E-01],
	[3.4250000000E+04, 2.6130790046E+01, 5.1488623375E+00, 9.5494075166E+00, 2.9655530542E+00, 9.4351366213E-01],
	[3.4255000000E+04, 2.6137261566E+01, 5.1488754910E+00, 9.5539361793E+00, 2.9660773796E+00, 9.4353949102E-01],
	[3.4260000000E+04, 2.6143733744E+01, 5.1488886426E+00, 9.5584663272E+00, 2.9666015861E+00, 9.4356530703E-01],
	[3.4265000000E+04, 2.6150206580E+01, 5.1489017923E+00, 9.5629979605E+00, 2.9671256737E+00, 9.4359111019E-01],
	[3.4270000000E+04, 2.6156680074E+01, 5.1489149401E+00, 9.5675310796E+00, 2.9676496424E+00, 9.4361690048E-01],
	[3.4275000000E+04, 2.6163154225E+01, 5.1489280861E+00, 9.5720656846E+00, 2.9681734922E+00, 9.4364267792E-01],
	[3.4280000000E+04, 2.6169629034E+01, 5.1489412302E+00, 9.5766017759E+00, 2.9686972230E+00, 9.4366844252E-01],
	[3.4285000000E+04, 2.6176104501E+01, 5.1489543723E+00, 9.5811393536E+00, 2.9692208350E+00, 9.4369419427E-01],
	[3.4290000000E+04, 2.6182580626E+01, 5.1489675126E+00, 9.5856784182E+00, 2.9697443281E+00, 9.4371993319E-01],
	[3.4295000000E+04, 2.6189057408E+01, 5.1489806511E+00, 9.5902189699E+00, 2.9702677023E+00, 9.4374565929E-01],
	[3.4300000000E+04, 2.6195534848E+01, 5.1489937876E+00, 9.5947610088E+00, 2.9707909575E+00, 9.4377137256E-01],
	[3.4305000000E+04, 2.6202012945E+01, 5.1490069223E+00, 9.5993045354E+00, 2.9713140939E+00, 9.4379707302E-01],
	[3.4310000000E+04, 2.6208491700E+01, 5.1490200550E+00, 9.6038495499E+00, 2.9718371114E+00, 9.4382276067E-01],
	[3.4315000000E+04, 2.6214971112E+01, 5.1490331859E+00, 9.6083960524E+00, 2.9723600100E+00, 9.4384843552E-01],
	[3.4320000000E+04, 2.6221451182E+01, 5.1490463149E+00, 9.6129440434E+00, 2.9728827897E+00, 9.4387409758E-01],
	[3.4325000000E+04, 2.6227931909E+01, 5.1490594421E+00, 9.6174935231E+00, 2.9734054505E+00, 9.4389974684E-01],
	[3.4330000000E+04, 2.6234413294E+01, 5.1490725673E+00, 9.6220444917E+00, 2.9739279925E+00, 9.4392538332E-01],
	[3.4335000000E+04, 2.6240895336E+01, 5.1490856907E+00, 9.6265969496E+00, 2.9744504155E+00, 9.4395100703E-01],
	[3.4340000000E+04, 2.6247378036E+01, 5.1490988122E+00, 9.6311508969E+00, 2.9749727197E+00, 9.4397661797E-01],
	[3.4345000000E+04, 2.6253861393E+01, 5.1491119318E+00, 9.6357063340E+00, 2.9754949050E+00, 9.4400221614E-01],
	[3.4350000000E+04, 2.6260345407E+01, 5.1491250496E+00, 9.6402632611E+00, 2.9760169713E+00, 9.4402780155E-01],
	[3.4355000000E+04, 2.6266830078E+01, 5.1491381654E+00, 9.6448216785E+00, 2.9765389189E+00, 9.4405337421E-01],
	[3.4360000000E+04, 2.6273315407E+01, 5.1491512794E+00, 9.6493815865E+00, 2.9770607475E+00, 9.4407893413E-01],
	[3.4365000000E+04, 2.6279801393E+01, 5.1491643916E+00, 9.6539429853E+00, 2.9775824573E+00, 9.4410448131E-01],
	[3.4370000000E+04, 2.6286288036E+01, 5.1491775018E+00, 9.6585058753E+00, 2.9781040481E+00, 9.4413001576E-01],
	[3.4375000000E+04, 2.6292775336E+01, 5.1491906102E+00, 9.6630702566E+00, 2.9786255201E+00, 9.4415553748E-01],
	[3.4380000000E+04, 2.6299263294E+01, 5.1492037167E+00, 9.6676361295E+00, 2.9791468733E+00, 9.4418104648E-01],
	[3.4385000000E+04, 2.6305751908E+01, 5.1492168213E+00, 9.6722034944E+00, 2.9796681075E+00, 9.4420654277E-01],
	[3.4390000000E+04, 2.6312241180E+01, 5.1492299241E+00, 9.6767723515E+00, 2.9801892229E+00, 9.4423202635E-01],
	[3.4395000000E+04, 2.6318731109E+01, 5.1492430249E+00, 9.6813427010E+00, 2.9807102195E+00, 9.4425749724E-01],
	[3.4400000000E+04, 2.6325221694E+01, 5.1492561240E+00, 9.6859145433E+00, 2.9812310971E+00, 9.4428295542E-01],
	[3.4405000000E+04, 2.6331712937E+01, 5.1492692211E+00, 9.6904878785E+00, 2.9817518560E+00, 9.4430840092E-01],
	[3.4410000000E+04, 2.6338204837E+01, 5.1492823164E+00, 9.6950627070E+00, 2.9822724959E+00, 9.4433383374E-01],
	[3.4415000000E+04, 2.6344697393E+01, 5.1492954098E+00, 9.6996390291E+00, 2.9827930170E+00, 9.4435925388E-01],
	[3.4420000000E+04, 2.6351190607E+01, 5.1493085013E+00, 9.7042168449E+00, 2.9833134192E+00, 9.4438466135E-01],
	[3.4425000000E+04, 2.6357684477E+01, 5.1493215910E+00, 9.7087961549E+00, 2.9838337026E+00, 9.4441005616E-01],
	[3.4430000000E+04, 2.6364179005E+01, 5.1493346788E+00, 9.7133769592E+00, 2.9843538671E+00, 9.4443543832E-01],
	[3.4435000000E+04, 2.6370674189E+01, 5.1493477647E+00, 9.7179592581E+00, 2.9848739128E+00, 9.4446080782E-01],
	[3.4440000000E+04, 2.6377170030E+01, 5.1493608488E+00, 9.7225430519E+00, 2.9853938396E+00, 9.4448616468E-01],
	[3.4445000000E+04, 2.6383666527E+01, 5.1493739310E+00, 9.7271283408E+00, 2.9859136476E+00, 9.4451150891E-01],
	[3.4450000000E+04, 2.6390163682E+01, 5.1493870113E+00, 9.7317151252E+00, 2.9864333367E+00, 9.4453684050E-01],
	[3.4455000000E+04, 2.6396661493E+01, 5.1494000898E+00, 9.7363034053E+00, 2.9869529070E+00, 9.4456215946E-01],
	[3.4460000000E+04, 2.6403159960E+01, 5.1494131664E+00, 9.7408931813E+00, 2.9874723585E+00, 9.4458746581E-01],
	[3.4465000000E+04, 2.6409659085E+01, 5.1494262411E+00, 9.7454844536E+00, 2.9879916911E+00, 9.4461275955E-01],
	[3.4470000000E+04, 2.6416158866E+01, 5.1494393140E+00, 9.7500772224E+00, 2.9885109049E+00, 9.4463804068E-01],
	[3.4475000000E+04, 2.6422659303E+01, 5.1494523850E+00, 9.7546714880E+00, 2.9890299999E+00, 9.4466330921E-01],
	[3.4480000000E+04, 2.6429160398E+01, 5.1494654541E+00, 9.7592672506E+00, 2.9895489760E+00, 9.4468856515E-01],
	[3.4485000000E+04, 2.6435662148E+01, 5.1494785214E+00, 9.7638645105E+00, 2.9900678333E+00, 9.4471380850E-01],
	[3.4490000000E+04, 2.6442164555E+01, 5.1494915869E+00, 9.7684632681E+00, 2.9905865717E+00, 9.4473903927E-01],
	[3.4495000000E+04, 2.6448667619E+01, 5.1495046504E+00, 9.7730635234E+00, 2.9911051914E+00, 9.4476425746E-01],
	[3.4500000000E+04, 2.6455171339E+01, 5.1495177121E+00, 9.7776652770E+00, 2.9916236922E+00, 9.4478946309E-01],
	[3.4505000000E+04, 2.6461675716E+01, 5.1495307720E+00, 9.7822685289E+00, 2.9921420742E+00, 9.4481465616E-01],
	[3.4510000000E+04, 2.6468180749E+01, 5.1495438300E+00, 9.7868732795E+00, 2.9926603374E+00, 9.4483983667E-01],
	[3.4515000000E+04, 2.6474686438E+01, 5.1495568861E+00, 9.7914795290E+00, 2.9931784818E+00, 9.4486500463E-01],
	[3.4520000000E+04, 2.6481192783E+01, 5.1495699403E+00, 9.7960872777E+00, 2.9936965074E+00, 9.4489016004E-01],
	[3.4525000000E+04, 2.6487699785E+01, 5.1495829928E+00, 9.8006965259E+00, 2.9942144142E+00, 9.4491530293E-01],
	[3.4530000000E+04, 2.6494207443E+01, 5.1495960433E+00, 9.8053072739E+00, 2.9947322021E+00, 9.4494043328E-01],
	[3.4535000000E+04, 2.6500732192E+01, 5.1496113484E+00, 9.8099195219E+00, 2.9952508446E+00, 9.4496555111E-01],
	[3.4540000000E+04, 2.6507260451E+01, 5.1496270423E+00, 9.8145332701E+00, 2.9957695374E+00, 9.4499065642E-01],
	[3.4545000000E+04, 2.6513789373E+01, 5.1496427340E+00, 9.8191485190E+00, 2.9962881119E+00, 9.4501574922E-01],
	[3.4550000000E+04, 2.6520318958E+01, 5.1496584234E+00, 9.8237652686E+00, 2.9968065681E+00, 9.4504082951E-01],
	[3.4555000000E+04, 2.6526849205E+01, 5.1496741106E+00, 9.8283835194E+00, 2.9973249060E+00, 9.4506589730E-01],
	[3.4560000000E+04, 2.6533380116E+01, 5.1496897956E+00, 9.8330032715E+00, 2.9978431257E+00, 9.4509095261E-01],
	[3.4565000000E+04, 2.6539911689E+01, 5.1497054784E+00, 9.8376245253E+00, 2.9983612270E+00, 9.4511599542E-01],
	[3.4570000000E+04, 2.6546443925E+01, 5.1497211590E+00, 9.8422472810E+00, 2.9988792101E+00, 9.4514102576E-01],
	[3.4575000000E+04, 2.6552976823E+01, 5.1497368373E+00, 9.8468715389E+00, 2.9993970748E+00, 9.4516604363E-01],
	[3.4580000000E+04, 2.6559510385E+01, 5.1497525134E+00, 9.8514972992E+00, 2.9999148213E+00, 9.4519104902E-01],
	[3.4585000000E+04, 2.6566044608E+01, 5.1497681873E+00, 9.8561245623E+00, 3.0004324495E+00, 9.4521604196E-01],
	[3.4590000000E+04, 2.6572579495E+01, 5.1497838590E+00, 9.8607533283E+00, 3.0009499595E+00, 9.4524102244E-01],
	[3.4595000000E+04, 2.6579115044E+01, 5.1497995285E+00, 9.8653835976E+00, 3.0014673512E+00, 9.4526599047E-01],
	[3.4600000000E+04, 2.6585651256E+01, 5.1498151957E+00, 9.8700153704E+00, 3.0019846246E+00, 9.4529094606E-01],
	[3.4605000000E+04, 2.6592188130E+01, 5.1498308608E+00, 9.8746486471E+00, 3.0025017797E+00, 9.4531588922E-01],
	[3.4610000000E+04, 2.6598725667E+01, 5.1498465236E+00, 9.8792834278E+00, 3.0030188166E+00, 9.4534081994E-01],
	[3.4615000000E+04, 2.6605263866E+01, 5.1498621842E+00, 9.8839197129E+00, 3.0035357352E+00, 9.4536573824E-01],
	[3.4620000000E+04, 2.6611802727E+01, 5.1498778426E+00, 9.8885575025E+00, 3.0040525356E+00, 9.4539064413E-01],
	[3.4625000000E+04, 2.6618342251E+01, 5.1498934987E+00, 9.8931967971E+00, 3.0045692177E+00, 9.4541553760E-01],
	[3.4630000000E+04, 2.6624882438E+01, 5.1499091527E+00, 9.8978375968E+00, 3.0050857816E+00, 9.4544041867E-01],
	[3.4635000000E+04, 2.6631423287E+01, 5.1499248045E+00, 9.9024799019E+00, 3.0056022272E+00, 9.4546528735E-01],
	[3.4640000000E+04, 2.6637964798E+01, 5.1499404540E+00, 9.9071237128E+00, 3.0061185546E+00, 9.4549014363E-01],
	[3.4645000000E+04, 2.6644506971E+01, 5.1499561013E+00, 9.9117690296E+00, 3.0066347637E+00, 9.4551498752E-01],
	[3.4650000000E+04, 2.6651049807E+01, 5.1499717464E+00, 9.9164158526E+00, 3.0071508547E+00, 9.4553981904E-01],
	[3.4655000000E+04, 2.6657593305E+01, 5.1499873893E+00, 9.9210641822E+00, 3.0076668273E+00, 9.4556463818E-01],
	[3.4660000000E+04, 2.6664137465E+01, 5.1500030300E+00, 9.9257140185E+00, 3.0081826818E+00, 9.4558944496E-01],
	[3.4665000000E+04, 2.6670682288E+01, 5.1500186685E+00, 9.9303653619E+00, 3.0086984180E+00, 9.4561423938E-01],
	[3.4670000000E+04, 2.6677227772E+01, 5.1500343048E+00, 9.9350182126E+00, 3.0092140360E+00, 9.4563902144E-01],
	[3.4675000000E+04, 2.6683773919E+01, 5.1500499389E+00, 9.9396725709E+00, 3.0097295357E+00, 9.4566379115E-01],
	[3.4680000000E+04, 2.6690320728E+01, 5.1500655707E+00, 9.9443284370E+00, 3.0102449173E+00, 9.4568854853E-01],
	[3.4685000000E+04, 2.6696868199E+01, 5.1500812004E+00, 9.9489858113E+00, 3.0107601806E+00, 9.4571329357E-01],
	[3.4690000000E+04, 2.6703416331E+01, 5.1500968279E+00, 9.9536446940E+00, 3.0112753258E+00, 9.4573802628E-01],
	[3.4695000000E+04, 2.6709965126E+01, 5.1501124531E+00, 9.9583050853E+00, 3.0117903527E+00, 9.4576274666E-01],
	[3.4700000000E+04, 2.6716514583E+01, 5.1501280761E+00, 9.9629669856E+00, 3.0123052614E+00, 9.4578745473E-01],
	[3.4705000000E+04, 2.6723064702E+01, 5.1501436970E+00, 9.9676303951E+00, 3.0128200519E+00, 9.4581215049E-01],
	[3.4710000000E+04, 2.6729615483E+01, 5.1501593156E+00, 9.9722953141E+00, 3.0133347243E+00, 9.4583683395E-01],
	[3.4715000000E+04, 2.6736166926E+01, 5.1501749321E+00, 9.9769617429E+00, 3.0138492784E+00, 9.4586150511E-01],
	[3.4720000000E+04, 2.6742719030E+01, 5.1501905463E+00, 9.9816296816E+00, 3.0143637144E+00, 9.4588616398E-01],
	[3.4725000000E+04, 2.6749271797E+01, 5.1502061583E+00, 9.9862991307E+00, 3.0148780321E+00, 9.4591081056E-01],
	[3.4730000000E+04, 2.6755825225E+01, 5.1502217682E+00, 9.9909700903E+00, 3.0153922317E+00, 9.4593544486E-01],
	[3.4735000000E+04, 2.6762379315E+01, 5.1502373758E+00, 9.9956425608E+00, 3.0159063131E+00, 9.4596006690E-01],
	[3.4740000000E+04, 2.6768934067E+01, 5.1502529812E+00, 1.0000316542E+01, 3.0164202763E+00, 9.4598467666E-01],
	[3.4745000000E+04, 2.6775489481E+01, 5.1502685845E+00, 1.0004992035E+01, 3.0169341214E+00, 9.4600927417E-01],
	[3.4750000000E+04, 2.6782045556E+01, 5.1502841855E+00, 1.0009669040E+01, 3.0174478483E+00, 9.4603385942E-01],
	[3.4755000000E+04, 2.6788602293E+01, 5.1502997843E+00, 1.0014347556E+01, 3.0179614570E+00, 9.4605843242E-01],
	[3.4760000000E+04, 2.6795159692E+01, 5.1503153810E+00, 1.0019027585E+01, 3.0184749476E+00, 9.4608299319E-01],
	[3.4765000000E+04, 2.6801717752E+01, 5.1503309754E+00, 1.0023709126E+01, 3.0189883200E+00, 9.4610754172E-01],
	[3.4770000000E+04, 2.6808276474E+01, 5.1503465677E+00, 1.0028392180E+01, 3.0195015742E+00, 9.4613207802E-01],
	[3.4775000000E+04, 2.6814835857E+01, 5.1503621577E+00, 1.0033076747E+01, 3.0200147104E+00, 9.4615660210E-01],
	[3.4780000000E+04, 2.6821395902E+01, 5.1503777456E+00, 1.0037762827E+01, 3.0205277283E+00, 9.4618111396E-01],
	[3.4785000000E+04, 2.6827956609E+01, 5.1503933313E+00, 1.0042450421E+01, 3.0210406282E+00, 9.4620561361E-01],
	[3.4790000000E+04, 2.6834517977E+01, 5.1504089147E+00, 1.0047139528E+01, 3.0215534099E+00, 9.4623010106E-01],
	[3.4795000000E+04, 2.6841080006E+01, 5.1504244960E+00, 1.0051830150E+01, 3.0220660734E+00, 9.4625457631E-01],
	[3.4800000000E+04, 2.6847642697E+01, 5.1504400751E+00, 1.0056522286E+01, 3.0225786189E+00, 9.4627903937E-01],
	[3.4805000000E+04, 2.6854206049E+01, 5.1504556520E+00, 1.0061215937E+01, 3.0230910462E+00, 9.4630349025E-01],
	[3.4810000000E+04, 2.6860770063E+01, 5.1504712267E+00, 1.0065911102E+01, 3.0236033554E+00, 9.4632792894E-01],
	[3.4815000000E+04, 2.6867334738E+01, 5.1504867992E+00, 1.0070607783E+01, 3.0241155465E+00, 9.4635235547E-01],
	[3.4820000000E+04, 2.6873900074E+01, 5.1505023696E+00, 1.0075305979E+01, 3.0246276194E+00, 9.4637676983E-01],
	[3.4825000000E+04, 2.6880466071E+01, 5.1505179377E+00, 1.0080005691E+01, 3.0251395743E+00, 9.4640117202E-01],
	[3.4830000000E+04, 2.6887032730E+01, 5.1505335037E+00, 1.0084706918E+01, 3.0256514111E+00, 9.4642556207E-01],
	[3.4835000000E+04, 2.6893600050E+01, 5.1505490674E+00, 1.0089409662E+01, 3.0261631297E+00, 9.4644993997E-01],
	[3.4840000000E+04, 2.6900168031E+01, 5.1505646290E+00, 1.0094113923E+01, 3.0266747303E+00, 9.4647430573E-01],
	[3.4845000000E+04, 2.6906736674E+01, 5.1505801884E+00, 1.0098819700E+01, 3.0271862128E+00, 9.4649865935E-01],
	[3.4850000000E+04, 2.6913305977E+01, 5.1505957456E+00, 1.0103526995E+01, 3.0276975772E+00, 9.4652300084E-01],
	[3.4855000000E+04, 2.6919875942E+01, 5.1506113006E+00, 1.0108235806E+01, 3.0282088235E+00, 9.4654733021E-01],
	[3.4860000000E+04, 2.6926446568E+01, 5.1506268535E+00, 1.0112946136E+01, 3.0287199517E+00, 9.4657164747E-01],
	[3.4865000000E+04, 2.6933017854E+01, 5.1506424041E+00, 1.0117657983E+01, 3.0292309619E+00, 9.4659595262E-01],
	[3.4870000000E+04, 2.6939589802E+01, 5.1506579526E+00, 1.0122371348E+01, 3.0297418540E+00, 9.4662024566E-01],
	[3.4875000000E+04, 2.6946162411E+01, 5.1506734989E+00, 1.0127086232E+01, 3.0302526280E+00, 9.4664452660E-01],
	[3.4880000000E+04, 2.6952735681E+01, 5.1506890430E+00, 1.0131802634E+01, 3.0307632840E+00, 9.4666879546E-01],
	[3.4885000000E+04, 2.6959309611E+01, 5.1507045849E+00, 1.0136520556E+01, 3.0312738219E+00, 9.4669305223E-01],
	[3.4890000000E+04, 2.6965884203E+01, 5.1507201247E+00, 1.0141239996E+01, 3.0317842418E+00, 9.4671729692E-01],
	[3.4895000000E+04, 2.6972459455E+01, 5.1507356622E+00, 1.0145960957E+01, 3.0322945436E+00, 9.4674152953E-01],
	[3.4900000000E+04, 2.6979035369E+01, 5.1507511976E+00, 1.0150683437E+01, 3.0328047274E+00, 9.4676575009E-01],
	[3.4905000000E+04, 2.6985611943E+01, 5.1507667308E+00, 1.0155407436E+01, 3.0333147932E+00, 9.4678995858E-01],
	[3.4910000000E+04, 2.6992189178E+01, 5.1507822619E+00, 1.0160132957E+01, 3.0338247409E+00, 9.4681415502E-01],
	[3.4915000000E+04, 2.6998767074E+01, 5.1507977907E+00, 1.0164859998E+01, 3.0343345706E+00, 9.4683833941E-01],
	[3.4920000000E+04, 2.7005345630E+01, 5.1508133174E+00, 1.0169588559E+01, 3.0348442823E+00, 9.4686251176E-01],
	[3.4925000000E+04, 2.7011924847E+01, 5.1508288419E+00, 1.0174318642E+01, 3.0353538759E+00, 9.4688667207E-01],
	[3.4930000000E+04, 2.7018504725E+01, 5.1508443642E+00, 1.0179050246E+01, 3.0358633516E+00, 9.4691082036E-01],
	[3.4935000000E+04, 2.7025085264E+01, 5.1508598844E+00, 1.0183783372E+01, 3.0363727092E+00, 9.4693495662E-01],
	[3.4940000000E+04, 2.7031666463E+01, 5.1508754023E+00, 1.0188518020E+01, 3.0368819488E+00, 9.4695908087E-01],
	[3.4945000000E+04, 2.7038248323E+01, 5.1508909181E+00, 1.0193254190E+01, 3.0373910705E+00, 9.4698319311E-01],
	[3.4950000000E+04, 2.7044830843E+01, 5.1509064318E+00, 1.0197991883E+01, 3.0379000741E+00, 9.4700729334E-01],
	[3.4955000000E+04, 2.7051414024E+01, 5.1509219432E+00, 1.0202731098E+01, 3.0384089598E+00, 9.4703138158E-01],
	[3.4960000000E+04, 2.7057997866E+01, 5.1509374525E+00, 1.0207471836E+01, 3.0389177275E+00, 9.4705545782E-01],
	[3.4965000000E+04, 2.7064582368E+01, 5.1509529596E+00, 1.0212214098E+01, 3.0394263772E+00, 9.4707952208E-01],
	[3.4970000000E+04, 2.7071167530E+01, 5.1509684646E+00, 1.0216957883E+01, 3.0399349089E+00, 9.4710357436E-01],
	[3.4975000000E+04, 2.7077753353E+01, 5.1509839673E+00, 1.0221703192E+01, 3.0404433227E+00, 9.4712761467E-01],
	[3.4980000000E+04, 2.7084339836E+01, 5.1509994679E+00, 1.0226450025E+01, 3.0409516184E+00, 9.4715164301E-01],
	[3.4985000000E+04, 2.7090926980E+01, 5.1510149664E+00, 1.0231198382E+01, 3.0414597963E+00, 9.4717565939E-01],
	[3.4990000000E+04, 2.7097514784E+01, 5.1510304626E+00, 1.0235948264E+01, 3.0419678562E+00, 9.4719966382E-01],
	[3.4995000000E+04, 2.7104103248E+01, 5.1510459567E+00, 1.0240699671E+01, 3.0424757981E+00, 9.4722365629E-01],
	[3.5000000000E+04, 2.7110692373E+01, 5.1510614487E+00, 1.0245452604E+01, 3.0429836221E+00, 9.4724763683E-01],
	[3.5005000000E+04, 2.7117282157E+01, 5.1510769384E+00, 1.0250212389E+01, 3.0434917979E+00, 9.4727160543E-01],
	[3.5010000000E+04, 2.7123872603E+01, 5.1510924260E+00, 1.0254973705E+01, 3.0439998555E+00, 9.4729556210E-01],
	[3.5015000000E+04, 2.7130463708E+01, 5.1511079114E+00, 1.0259736550E+01, 3.0445077951E+00, 9.4731950685E-01],
	[3.5020000000E+04, 2.7137055473E+01, 5.1511233947E+00, 1.0264500927E+01, 3.0450156165E+00, 9.4734343969E-01],
	[3.5025000000E+04, 2.7143647899E+01, 5.1511388758E+00, 1.0269266834E+01, 3.0455233199E+00, 9.4736736061E-01],
	[3.5030000000E+04, 2.7150240985E+01, 5.1511543548E+00, 1.0274034272E+01, 3.0460309051E+00, 9.4739126962E-01],
	[3.5035000000E+04, 2.7156834731E+01, 5.1511698315E+00, 1.0278803242E+01, 3.0465383723E+00, 9.4741516674E-01],
	[3.5040000000E+04, 2.7163429136E+01, 5.1511853062E+00, 1.0283573743E+01, 3.0470457214E+00, 9.4743905197E-01],
	[3.5045000000E+04, 2.7170024202E+01, 5.1512007786E+00, 1.0288345776E+01, 3.0475529524E+00, 9.4746292531E-01],
	[3.5050000000E+04, 2.7176619928E+01, 5.1512162489E+00, 1.0293119342E+01, 3.0480600653E+00, 9.4748678677E-01],
	[3.5055000000E+04, 2.7183216314E+01, 5.1512317170E+00, 1.0297894440E+01, 3.0485670602E+00, 9.4751063636E-01],
	[3.5060000000E+04, 2.7189813360E+01, 5.1512471830E+00, 1.0302671070E+01, 3.0490739370E+00, 9.4753447408E-01],
	[3.5065000000E+04, 2.7196411066E+01, 5.1512626468E+00, 1.0307449234E+01, 3.0495806958E+00, 9.4755829994E-01],
	[3.5070000000E+04, 2.7203009432E+01, 5.1512781085E+00, 1.0312228931E+01, 3.0500873365E+00, 9.4758211394E-01],
	[3.5075000000E+04, 2.7209608457E+01, 5.1512935680E+00, 1.0317010161E+01, 3.0505938592E+00, 9.4760591610E-01],
	[3.5080000000E+04, 2.7216208143E+01, 5.1513090253E+00, 1.0321792926E+01, 3.0511002638E+00, 9.4762970641E-01],
	[3.5085000000E+04, 2.7222808488E+01, 5.1513244805E+00, 1.0326577224E+01, 3.0516065504E+00, 9.4765348489E-01],
	[3.5090000000E+04, 2.7229422312E+01, 5.1513416783E+00, 1.0331363057E+01, 3.0521134925E+00, 9.4767725153E-01],
	[3.5095000000E+04, 2.7236043036E+01, 5.1513597225E+00, 1.0336150424E+01, 3.0526206933E+00, 9.4770100636E-01],
	[3.5100000000E+04, 2.7242664427E+01, 5.1513777642E+00, 1.0340939327E+01, 3.0531277766E+00, 9.4772474936E-01],
	[3.5105000000E+04, 2.7249286484E+01, 5.1513958033E+00, 1.0345729764E+01, 3.0536347424E+00, 9.4774848055E-01],
	[3.5110000000E+04, 2.7255909208E+01, 5.1514138400E+00, 1.0350521737E+01, 3.0541415906E+00, 9.4777219994E-01],
	[3.5115000000E+04, 2.7262532597E+01, 5.1514318742E+00, 1.0355315246E+01, 3.0546483213E+00, 9.4779590753E-01],
	[3.5120000000E+04, 2.7269156653E+01, 5.1514499058E+00, 1.0360110291E+01, 3.0551549345E+00, 9.4781960333E-01],
	[3.5125000000E+04, 2.7275781375E+01, 5.1514679349E+00, 1.0364906872E+01, 3.0556614302E+00, 9.4784328733E-01],
	[3.5130000000E+04, 2.7282406763E+01, 5.1514859616E+00, 1.0369704990E+01, 3.0561678083E+00, 9.4786695956E-01],
	[3.5135000000E+04, 2.7289032817E+01, 5.1515039857E+00, 1.0374504644E+01, 3.0566740690E+00, 9.4789062002E-01],
	[3.5140000000E+04, 2.7295659537E+01, 5.1515220074E+00, 1.0379305836E+01, 3.0571802122E+00, 9.4791426870E-01],
	[3.5145000000E+04, 2.7302286923E+01, 5.1515400265E+00, 1.0384108565E+01, 3.0576862379E+00, 9.4793790562E-01],
	[3.5150000000E+04, 2.7308914975E+01, 5.1515580431E+00, 1.0388912832E+01, 3.0581921461E+00, 9.4796153079E-01],
	[3.5155000000E+04, 2.7315543693E+01, 5.1515760573E+00, 1.0393718636E+01, 3.0586979368E+00, 9.4798514421E-01],
	[3.5160000000E+04, 2.7322173077E+01, 5.1515940689E+00, 1.0398525979E+01, 3.0592036101E+00, 9.4800874588E-01],
	[3.5165000000E+04, 2.7328803127E+01, 5.1516120780E+00, 1.0403334860E+01, 3.0597091659E+00, 9.4803233581E-01],
	[3.5170000000E+04, 2.7335433843E+01, 5.1516300847E+00, 1.0408145280E+01, 3.0602146043E+00, 9.4805591402E-01],
	[3.5175000000E+04, 2.7342065224E+01, 5.1516480888E+00, 1.0412957239E+01, 3.0607199252E+00, 9.4807948050E-01],
	[3.5180000000E+04, 2.7348697272E+01, 5.1516660905E+00, 1.0417770738E+01, 3.0612251286E+00, 9.4810303526E-01],
	[3.5185000000E+04, 2.7355329985E+01, 5.1516840896E+00, 1.0422585776E+01, 3.0617302146E+00, 9.4812657831E-01],
	[3.5190000000E+04, 2.7361963364E+01, 5.1517020863E+00, 1.0427402353E+01, 3.0622351832E+00, 9.4815010965E-01],
	[3.5195000000E+04, 2.7368597409E+01, 5.1517200805E+00, 1.0432220471E+01, 3.0627400343E+00, 9.4817362929E-01],
	[3.5200000000E+04, 2.7375232119E+01, 5.1517380721E+00, 1.0437040129E+01, 3.0632447681E+00, 9.4819713723E-01],
	[3.5205000000E+04, 2.7381867495E+01, 5.1517560613E+00, 1.0441861328E+01, 3.0637493844E+00, 9.4822063349E-01],
	[3.5210000000E+04, 2.7388503537E+01, 5.1517740480E+00, 1.0446684068E+01, 3.0642538833E+00, 9.4824411806E-01],
	[3.5215000000E+04, 2.7395140245E+01, 5.1517920322E+00, 1.0451508349E+01, 3.0647582647E+00, 9.4826759096E-01],
	[3.5220000000E+04, 2.7401777618E+01, 5.1518100139E+00, 1.0456334172E+01, 3.0652625288E+00, 9.4829105219E-01],
	[3.5225000000E+04, 2.7408415656E+01, 5.1518279931E+00, 1.0461161536E+01, 3.0657666755E+00, 9.4831450176E-01],
	[3.5230000000E+04, 2.7415054360E+01, 5.1518459698E+00, 1.0465990442E+01, 3.0662707048E+00, 9.4833793966E-01],
	[3.5235000000E+04, 2.7421693730E+01, 5.1518639441E+00, 1.0470820891E+01, 3.0667746168E+00, 9.4836136592E-01],
	[3.5240000000E+04, 2.7428333765E+01, 5.1518819158E+00, 1.0475652882E+01, 3.0672784113E+00, 9.4838478053E-01],
	[3.5245000000E+04, 2.7434974466E+01, 5.1518998851E+00, 1.0480486416E+01, 3.0677820885E+00, 9.4840818350E-01],
	[3.5250000000E+04, 2.7441615832E+01, 5.1519178519E+00, 1.0485321493E+01, 3.0682856484E+00, 9.4843157484E-01],
	[3.5255000000E+04, 2.7448257863E+01, 5.1519358161E+00, 1.0490158113E+01, 3.0687890908E+00, 9.4845495456E-01],
	[3.5260000000E+04, 2.7454900560E+01, 5.1519537780E+00, 1.0494996277E+01, 3.0692924160E+00, 9.4847832265E-01],
	[3.5265000000E+04, 2.7461543922E+01, 5.1519717373E+00, 1.0499835986E+01, 3.0697956237E+00, 9.4850167912E-01],
	[3.5270000000E+04, 2.7468187950E+01, 5.1519896941E+00, 1.0504677238E+01, 3.0702987142E+00, 9.4852502399E-01],
	[3.5275000000E+04, 2.7474832642E+01, 5.1520076485E+00, 1.0509520035E+01, 3.0708016873E+00, 9.4854835726E-01],
	[3.5280000000E+04, 2.7481478000E+01, 5.1520256003E+00, 1.0514364376E+01, 3.0713045431E+00, 9.4857167893E-01],
	[3.5285000000E+04, 2.7488124024E+01, 5.1520435497E+00, 1.0519210263E+01, 3.0718072816E+00, 9.4859498901E-01],
	[3.5290000000E+04, 2.7494770712E+01, 5.1520614966E+00, 1.0524057695E+01, 3.0723099027E+00, 9.4861828751E-01],
	[3.5295000000E+04, 2.7501418066E+01, 5.1520794411E+00, 1.0528906672E+01, 3.0728124066E+00, 9.4864157442E-01],
	[3.5300000000E+04, 2.7508066085E+01, 5.1520973830E+00, 1.0533757195E+01, 3.0733147932E+00, 9.4866484977E-01],
	[3.5305000000E+04, 2.7514714769E+01, 5.1521153225E+00, 1.0538609265E+01, 3.0738170625E+00, 9.4868811355E-01],
	[3.5310000000E+04, 2.7521364118E+01, 5.1521332595E+00, 1.0543462880E+01, 3.0743192144E+00, 9.4871136577E-01],
	[3.5315000000E+04, 2.7528014132E+01, 5.1521511940E+00, 1.0548318043E+01, 3.0748212492E+00, 9.4873460643E-01],
	[3.5320000000E+04, 2.7534664811E+01, 5.1521691260E+00, 1.0553174752E+01, 3.0753231666E+00, 9.4875783555E-01],
	[3.5325000000E+04, 2.7541316155E+01, 5.1521870556E+00, 1.0558033009E+01, 3.0758249668E+00, 9.4878105312E-01],
	[3.5330000000E+04, 2.7547968165E+01, 5.1522049827E+00, 1.0562892813E+01, 3.0763266497E+00, 9.4880425915E-01],
	[3.5335000000E+04, 2.7554620839E+01, 5.1522229073E+00, 1.0567754165E+01, 3.0768282154E+00, 9.4882745364E-01],
	[3.5340000000E+04, 2.7561274178E+01, 5.1522408294E+00, 1.0572617065E+01, 3.0773296638E+00, 9.4885063661E-01],
	[3.5345000000E+04, 2.7567928182E+01, 5.1522587491E+00, 1.0577481513E+01, 3.0778309950E+00, 9.4887380806E-01],
	[3.5350000000E+04, 2.7574582851E+01, 5.1522766663E+00, 1.0582347510E+01, 3.0783322089E+00, 9.4889696799E-01],
	[3.5355000000E+04, 2.7581238185E+01, 5.1522945810E+00, 1.0587215056E+01, 3.0788333057E+00, 9.4892011640E-01],
	[3.5360000000E+04, 2.7587894183E+01, 5.1523124933E+00, 1.0592084150E+01, 3.0793342852E+00, 9.4894325331E-01],
	[3.5365000000E+04, 2.7594550847E+01, 5.1523304031E+00, 1.0596954795E+01, 3.0798351475E+00, 9.4896637872E-01],
	[3.5370000000E+04, 2.7601208175E+01, 5.1523483104E+00, 1.0601826988E+01, 3.0803358926E+00, 9.4898949264E-01],
	[3.5375000000E+04, 2.7607866168E+01, 5.1523662152E+00, 1.0606700732E+01, 3.0808365205E+00, 9.4901259507E-01],
	[3.5380000000E+04, 2.7614524825E+01, 5.1523841176E+00, 1.0611576026E+01, 3.0813370312E+00, 9.4903568601E-01],
	[3.5385000000E+04, 2.7621184148E+01, 5.1524020175E+00, 1.0616452871E+01, 3.0818374247E+00, 9.4905876547E-01],
	[3.5390000000E+04, 2.7627844135E+01, 5.1524199149E+00, 1.0621331266E+01, 3.0823377011E+00, 9.4908183346E-01],
	[3.5395000000E+04, 2.7634504786E+01, 5.1524378099E+00, 1.0626211213E+01, 3.0828378603E+00, 9.4910488999E-01],
	[3.5400000000E+04, 2.7641166102E+01, 5.1524557024E+00, 1.0631092710E+01, 3.0833379023E+00, 9.4912793505E-01],
	[3.5405000000E+04, 2.7647828083E+01, 5.1524735925E+00, 1.0635975759E+01, 3.0838378272E+00, 9.4915096866E-01],
	[3.5410000000E+04, 2.7654490728E+01, 5.1524914800E+00, 1.0640860361E+01, 3.0843376349E+00, 9.4917399081E-01],
	[3.5415000000E+04, 2.7661154038E+01, 5.1525093652E+00, 1.0645746514E+01, 3.0848373255E+00, 9.4919700152E-01],
	[3.5420000000E+04, 2.7667818013E+01, 5.1525272478E+00, 1.0650634219E+01, 3.0853368989E+00, 9.4922000080E-01],
	[3.5425000000E+04, 2.7674482651E+01, 5.1525451280E+00, 1.0655523478E+01, 3.0858363552E+00, 9.4924298863E-01],
	[3.5430000000E+04, 2.7681147955E+01, 5.1525630057E+00, 1.0660414289E+01, 3.0863356944E+00, 9.4926596504E-01],
	[3.5435000000E+04, 2.7687813922E+01, 5.1525808810E+00, 1.0665306654E+01, 3.0868349165E+00, 9.4928893003E-01],
	[3.5440000000E+04, 2.7694480554E+01, 5.1525987538E+00, 1.0670200572E+01, 3.0873340215E+00, 9.4931188359E-01],
	[3.5445000000E+04, 2.7701147851E+01, 5.1526166242E+00, 1.0675096044E+01, 3.0878330094E+00, 9.4933482575E-01],
	[3.5450000000E+04, 2.7707815811E+01, 5.1526344920E+00, 1.0679993069E+01, 3.0883318802E+00, 9.4935775650E-01],
	[3.5455000000E+04, 2.7714484436E+01, 5.1526523575E+00, 1.0684891650E+01, 3.0888306339E+00, 9.4938067585E-01],
	[3.5460000000E+04, 2.7721153726E+01, 5.1526702205E+00, 1.0689791784E+01, 3.0893292705E+00, 9.4940358380E-01],
	[3.5465000000E+04, 2.7727823679E+01, 5.1526880810E+00, 1.0694693474E+01, 3.0898277901E+00, 9.4942648036E-01],
	[3.5470000000E+04, 2.7734494297E+01, 5.1527059390E+00, 1.0699596719E+01, 3.0903261926E+00, 9.4944936554E-01],
	[3.5475000000E+04, 2.7741165579E+01, 5.1527237946E+00, 1.0704501519E+01, 3.0908244781E+00, 9.4947223934E-01],
	[3.5480000000E+04, 2.7747837525E+01, 5.1527416478E+00, 1.0709407875E+01, 3.0913226465E+00, 9.4949510177E-01],
	[3.5485000000E+04, 2.7754510135E+01, 5.1527594985E+00, 1.0714315787E+01, 3.0918206978E+00, 9.4951795283E-01],
	[3.5490000000E+04, 2.7761183410E+01, 5.1527773467E+00, 1.0719225255E+01, 3.0923186322E+00, 9.4954079253E-01],
	[3.5495000000E+04, 2.7767857348E+01, 5.1527951925E+00, 1.0724136280E+01, 3.0928164495E+00, 9.4956362087E-01],
	[3.5500000000E+04, 2.7774531951E+01, 5.1528130359E+00, 1.0729048861E+01, 3.0933141498E+00, 9.4958643786E-01],
	[3.5505000000E+04, 2.7781207217E+01, 5.1528308768E+00, 1.0733963000E+01, 3.0938117331E+00, 9.4960924350E-01],
	[3.5510000000E+04, 2.7787883148E+01, 5.1528487152E+00, 1.0738878695E+01, 3.0943091994E+00, 9.4963203780E-01],
	[3.5515000000E+04, 2.7794559742E+01, 5.1528665512E+00, 1.0743795949E+01, 3.0948065487E+00, 9.4965482077E-01],
	[3.5520000000E+04, 2.7801237001E+01, 5.1528843847E+00, 1.0748714760E+01, 3.0953037810E+00, 9.4967759241E-01],
	[3.5525000000E+04, 2.7807914923E+01, 5.1529022158E+00, 1.0753635130E+01, 3.0958008963E+00, 9.4970035273E-01],
	[3.5530000000E+04, 2.7814593509E+01, 5.1529200445E+00, 1.0758557058E+01, 3.0962978946E+00, 9.4972310173E-01],
	[3.5535000000E+04, 2.7821272759E+01, 5.1529378707E+00, 1.0763480544E+01, 3.0967947760E+00, 9.4974583941E-01],
	[3.5540000000E+04, 2.7827952673E+01, 5.1529556944E+00, 1.0768405590E+01, 3.0972915405E+00, 9.4976856579E-01],
	[3.5545000000E+04, 2.7834633251E+01, 5.1529735157E+00, 1.0773332195E+01, 3.0977881880E+00, 9.4979128087E-01],
	[3.5550000000E+04, 2.7841314493E+01, 5.1529913346E+00, 1.0778260359E+01, 3.0982847185E+00, 9.4981398465E-01],
	[3.5555000000E+04, 2.7847996398E+01, 5.1530091510E+00, 1.0783190083E+01, 3.0987811321E+00, 9.4983667714E-01],
	[3.5560000000E+04, 2.7854678967E+01, 5.1530269650E+00, 1.0788121367E+01, 3.0992774288E+00, 9.4985935835E-01],
	[3.5565000000E+04, 2.7861362200E+01, 5.1530447765E+00, 1.0793054212E+01, 3.0997736086E+00, 9.4988202827E-01],
	[3.5570000000E+04, 2.7868046096E+01, 5.1530625856E+00, 1.0797988617E+01, 3.1002696715E+00, 9.4990468693E-01],
	[3.5575000000E+04, 2.7874730656E+01, 5.1530803922E+00, 1.0802924583E+01, 3.1007656175E+00, 9.4992733431E-01],
	[3.5580000000E+04, 2.7881415880E+01, 5.1530981964E+00, 1.0807862110E+01, 3.1012614465E+00, 9.4994997043E-01],
	[3.5585000000E+04, 2.7888101767E+01, 5.1531159982E+00, 1.0812801199E+01, 3.1017571587E+00, 9.4997259530E-01],
	[3.5590000000E+04, 2.7894788318E+01, 5.1531337975E+00, 1.0817741850E+01, 3.1022527540E+00, 9.4999520891E-01],
	[3.5595000000E+04, 2.7901475532E+01, 5.1531515944E+00, 1.0822684062E+01, 3.1027482325E+00, 9.5001781128E-01],
	[3.5600000000E+04, 2.7908163410E+01, 5.1531693888E+00, 1.0827627837E+01, 3.1032435941E+00, 9.5004040241E-01],
	[3.5605000000E+04, 2.7914851951E+01, 5.1531871808E+00, 1.0832573174E+01, 3.1037388388E+00, 9.5006298230E-01],
	[3.5610000000E+04, 2.7921541156E+01, 5.1532049704E+00, 1.0837520074E+01, 3.1042339667E+00, 9.5008555096E-01],
	[3.5615000000E+04, 2.7928231024E+01, 5.1532227575E+00, 1.0842468537E+01, 3.1047289777E+00, 9.5010810840E-01],
	[3.5620000000E+04, 2.7934921556E+01, 5.1532405422E+00, 1.0847418563E+01, 3.1052238720E+00, 9.5013065462E-01],
	[3.5625000000E+04, 2.7941612751E+01, 5.1532583245E+00, 1.0852370154E+01, 3.1057186494E+00, 9.5015318962E-01],
	[3.5630000000E+04, 2.7948304609E+01, 5.1532761043E+00, 1.0857323308E+01, 3.1062133099E+00, 9.5017571342E-01],
	[3.5635000000E+04, 2.7954997131E+01, 5.1532938817E+00, 1.0862278026E+01, 3.1067078537E+00, 9.5019822602E-01],
	[3.5640000000E+04, 2.7961690316E+01, 5.1533116567E+00, 1.0867234308E+01, 3.1072022807E+00, 9.5022072742E-01],
	[3.5645000000E+04, 2.7968384164E+01, 5.1533294292E+00, 1.0872192156E+01, 3.1076965909E+00, 9.5024321763E-01],
	[3.5650000000E+04, 2.7975078675E+01, 5.1533471993E+00, 1.0877151568E+01, 3.1081907843E+00, 9.5026569665E-01],
	[3.5655000000E+04, 2.7981787110E+01, 5.1533667522E+00, 1.0882112546E+01, 3.1086856743E+00, 9.5028816450E-01],
	[3.5660000000E+04, 2.7988501807E+01, 5.1533870555E+00, 1.0887075089E+01, 3.1091807909E+00, 9.5031062117E-01],
	[3.5665000000E+04, 2.7995217174E+01, 5.1534073560E+00, 1.0892039198E+01, 3.1096757913E+00, 9.5033306667E-01],
	[3.5670000000E+04, 2.8001933210E+01, 5.1534276537E+00, 1.0897004873E+01, 3.1101706753E+00, 9.5035550100E-01],
	[3.5675000000E+04, 2.8008649915E+01, 5.1534479487E+00, 1.0901972114E+01, 3.1106654431E+00, 9.5037792418E-01],
	[3.5680000000E+04, 2.8015367291E+01, 5.1534682409E+00, 1.0906940922E+01, 3.1111600946E+00, 9.5040033621E-01],
	[3.5685000000E+04, 2.8022085335E+01, 5.1534885303E+00, 1.0911911298E+01, 3.1116546298E+00, 9.5042273709E-01],
	[3.5690000000E+04, 2.8028804049E+01, 5.1535088170E+00, 1.0916883240E+01, 3.1121490488E+00, 9.5044512683E-01],
	[3.5695000000E+04, 2.8035523432E+01, 5.1535291009E+00, 1.0921856749E+01, 3.1126433515E+00, 9.5046750543E-01],
	[3.5700000000E+04, 2.8042243485E+01, 5.1535493821E+00, 1.0926831827E+01, 3.1131375380E+00, 9.5048987291E-01],
	[3.5705000000E+04, 2.8048964207E+01, 5.1535696605E+00, 1.0931808472E+01, 3.1136316082E+00, 9.5051222926E-01],
	[3.5710000000E+04, 2.8055685598E+01, 5.1535899361E+00, 1.0936786686E+01, 3.1141255622E+00, 9.5053457448E-01],
	[3.5715000000E+04, 2.8062407659E+01, 5.1536102090E+00, 1.0941766468E+01, 3.1146194000E+00, 9.5055690860E-01],
	[3.5720000000E+04, 2.8069130389E+01, 5.1536304791E+00, 1.0946747820E+01, 3.1151131216E+00, 9.5057923161E-01],
	[3.5725000000E+04, 2.8075853788E+01, 5.1536507464E+00, 1.0951730740E+01, 3.1156067270E+00, 9.5060154351E-01],
	[3.5730000000E+04, 2.8082577856E+01, 5.1536710110E+00, 1.0956715229E+01, 3.1161002162E+00, 9.5062384432E-01],
	[3.5735000000E+04, 2.8089302594E+01, 5.1536912729E+00, 1.0961701289E+01, 3.1165935892E+00, 9.5064613404E-01],
	[3.5740000000E+04, 2.8096028000E+01, 5.1537115320E+00, 1.0966688918E+01, 3.1170868460E+00, 9.5066841267E-01],
	[3.5745000000E+04, 2.8102754076E+01, 5.1537317883E+00, 1.0971678117E+01, 3.1175799867E+00, 9.5069068022E-01],
	[3.5750000000E+04, 2.8109480820E+01, 5.1537520419E+00, 1.0976668887E+01, 3.1180730112E+00, 9.5071293669E-01],
	[3.5755000000E+04, 2.8116208234E+01, 5.1537722927E+00, 1.0981661228E+01, 3.1185659196E+00, 9.5073518209E-01],
	[3.5760000000E+04, 2.8122936317E+01, 5.1537925408E+00, 1.0986655140E+01, 3.1190587118E+00, 9.5075741643E-01],
	[3.5765000000E+04, 2.8129665069E+01, 5.1538127861E+00, 1.0991650623E+01, 3.1195513879E+00, 9.5077963972E-01],
	[3.5770000000E+04, 2.8136394490E+01, 5.1538330287E+00, 1.0996647677E+01, 3.1200439478E+00, 9.5080185195E-01],
	[3.5775000000E+04, 2.8143124579E+01, 5.1538532685E+00, 1.1001646304E+01, 3.1205363917E+00, 9.5082405313E-01],
	[3.5780000000E+04, 2.8149855338E+01, 5.1538735056E+00, 1.1006646502E+01, 3.1210287194E+00, 9.5084624327E-01],
	[3.5785000000E+04, 2.8156586766E+01, 5.1538937399E+00, 1.1011648273E+01, 3.1215209311E+00, 9.5086842237E-01],
	[3.5790000000E+04, 2.8163318862E+01, 5.1539139715E+00, 1.1016651617E+01, 3.1220130266E+00, 9.5089059044E-01],
	[3.5795000000E+04, 2.8170051627E+01, 5.1539342003E+00, 1.1021656534E+01, 3.1225050061E+00, 9.5091274749E-01],
	[3.5800000000E+04, 2.8176785061E+01, 5.1539544264E+00, 1.1026663023E+01, 3.1229968695E+00, 9.5093489351E-01],
	[3.5805000000E+04, 2.8183519164E+01, 5.1539746498E+00, 1.1031671087E+01, 3.1234886168E+00, 9.5095702853E-01],
	[3.5810000000E+04, 2.8190253936E+01, 5.1539948704E+00, 1.1036680724E+01, 3.1239802481E+00, 9.5097915253E-01],
	[3.5815000000E+04, 2.8196989376E+01, 5.1540150882E+00, 1.1041691935E+01, 3.1244717633E+00, 9.5100126553E-01],
	[3.5820000000E+04, 2.8203725485E+01, 5.1540353033E+00, 1.1046704720E+01, 3.1249631625E+00, 9.5102336753E-01],
	[3.5825000000E+04, 2.8210462263E+01, 5.1540555157E+00, 1.1051719080E+01, 3.1254544457E+00, 9.5104545854E-01],
	[3.5830000000E+04, 2.8217199709E+01, 5.1540757253E+00, 1.1056735015E+01, 3.1259456128E+00, 9.5106753856E-01],
	[3.5835000000E+04, 2.8223937824E+01, 5.1540959322E+00, 1.1061752525E+01, 3.1264366639E+00, 9.5108960760E-01],
	[3.5840000000E+04, 2.8230676608E+01, 5.1541161364E+00, 1.1066771611E+01, 3.1269275991E+00, 9.5111166567E-01],
	[3.5845000000E+04, 2.8237416060E+01, 5.1541363378E+00, 1.1071792272E+01, 3.1274184182E+00, 9.5113371276E-01],
	[3.5850000000E+04, 2.8244156180E+01, 5.1541565364E+00, 1.1076814509E+01, 3.1279091214E+00, 9.5115574889E-01],
	[3.5855000000E+04, 2.8250896970E+01, 5.1541767324E+00, 1.1081838323E+01, 3.1283997085E+00, 9.5117777406E-01],
	[3.5860000000E+04, 2.8257638427E+01, 5.1541969256E+00, 1.1086863713E+01, 3.1288901798E+00, 9.5119978828E-01],
	[3.5865000000E+04, 2.8264380554E+01, 5.1542171160E+00, 1.1091890679E+01, 3.1293805350E+00, 9.5122179155E-01],
	[3.5870000000E+04, 2.8271123348E+01, 5.1542373037E+00, 1.1096919223E+01, 3.1298707743E+00, 9.5124378387E-01],
	[3.5875000000E+04, 2.8277866811E+01, 5.1542574887E+00, 1.1101949344E+01, 3.1303608977E+00, 9.5126576526E-01],
	[3.5880000000E+04, 2.8284610943E+01, 5.1542776710E+00, 1.1106981043E+01, 3.1308509051E+00, 9.5128773571E-01],
	[3.5885000000E+04, 2.8291355742E+01, 5.1542978505E+00, 1.1112014319E+01, 3.1313407967E+00, 9.5130969524E-01],
	[3.5890000000E+04, 2.8298101210E+01, 5.1543180273E+00, 1.1117049174E+01, 3.1318305723E+00, 9.5133164385E-01],
	[3.5895000000E+04, 2.8304847347E+01, 5.1543382013E+00, 1.1122085607E+01, 3.1323202320E+00, 9.5135358154E-01],
	[3.5900000000E+04, 2.8311594151E+01, 5.1543583727E+00, 1.1127123619E+01, 3.1328097758E+00, 9.5137550833E-01],
	[3.5905000000E+04, 2.8318341624E+01, 5.1543785413E+00, 1.1132163210E+01, 3.1332992037E+00, 9.5139742420E-01],
	[3.5910000000E+04, 2.8325089765E+01, 5.1543987071E+00, 1.1137204380E+01, 3.1337885157E+00, 9.5141932918E-01],
	[3.5915000000E+04, 2.8331838575E+01, 5.1544188703E+00, 1.1142247130E+01, 3.1342777119E+00, 9.5144122327E-01],
	[3.5920000000E+04, 2.8338588052E+01, 5.1544390307E+00, 1.1147291459E+01, 3.1347667923E+00, 9.5146310647E-01],
	[3.5925000000E+04, 2.8345338198E+01, 5.1544591883E+00, 1.1152337369E+01, 3.1352557567E+00, 9.5148497878E-01],
	[3.5930000000E+04, 2.8352089011E+01, 5.1544793433E+00, 1.1157384859E+01, 3.1357446054E+00, 9.5150684022E-01],
	[3.5935000000E+04, 2.8358840493E+01, 5.1544994955E+00, 1.1162433929E+01, 3.1362333382E+00, 9.5152869079E-01],
	[3.5940000000E+04, 2.8365592643E+01, 5.1545196450E+00, 1.1167484581E+01, 3.1367219552E+00, 9.5155053049E-01],
	[3.5945000000E+04, 2.8372345461E+01, 5.1545397918E+00, 1.1172536814E+01, 3.1372104564E+00, 9.5157235933E-01],
	[3.5950000000E+04, 2.8379098947E+01, 5.1545599359E+00, 1.1177590628E+01, 3.1376988418E+00, 9.5159417731E-01],
	[3.5955000000E+04, 2.8385853101E+01, 5.1545800772E+00, 1.1182646023E+01, 3.1381871114E+00, 9.5161598445E-01],
	[3.5960000000E+04, 2.8392607922E+01, 5.1546002158E+00, 1.1187703001E+01, 3.1386752652E+00, 9.5163778074E-01],
	[3.5965000000E+04, 2.8399363412E+01, 5.1546203517E+00, 1.1192761561E+01, 3.1391633032E+00, 9.5165956619E-01],
	[3.5970000000E+04, 2.8406119570E+01, 5.1546404849E+00, 1.1197821704E+01, 3.1396512255E+00, 9.5168134081E-01],
	[3.5975000000E+04, 2.8412876395E+01, 5.1546606153E+00, 1.1202883430E+01, 3.1401390320E+00, 9.5170310461E-01],
	[3.5980000000E+04, 2.8419633889E+01, 5.1546807430E+00, 1.1207946738E+01, 3.1406267228E+00, 9.5172485758E-01],
	[3.5985000000E+04, 2.8426392050E+01, 5.1547008680E+00, 1.1213011630E+01, 3.1411142979E+00, 9.5174659973E-01],
	[3.5990000000E+04, 2.8433150879E+01, 5.1547209903E+00, 1.1218078106E+01, 3.1416017572E+00, 9.5176833107E-01],
	[3.5995000000E+04, 2.8439910375E+01, 5.1547411099E+00, 1.1223146165E+01, 3.1420891008E+00, 9.5179005161E-01],
	[3.6000000000E+04, 2.8446670540E+01, 5.1547612268E+00, 1.1228215809E+01, 3.1425763287E+00, 9.5181176135E-01],
	[3.6005000000E+04, 2.8453431372E+01, 5.1547813409E+00, 1.1233287037E+01, 3.1430634409E+00, 9.5183346029E-01],
	[3.6010000000E+04, 2.8460192872E+01, 5.1548014524E+00, 1.1238359850E+01, 3.1435504374E+00, 9.5185514844E-01],
	[3.6015000000E+04, 2.8466955039E+01, 5.1548215611E+00, 1.1243434248E+01, 3.1440373183E+00, 9.5187682581E-01],
	[3.6020000000E+04, 2.8473717874E+01, 5.1548416671E+00, 1.1248510231E+01, 3.1445240834E+00, 9.5189849240E-01],
	[3.6025000000E+04, 2.8480481377E+01, 5.1548617704E+00, 1.1253587800E+01, 3.1450107330E+00, 9.5192014822E-01],
	[3.6030000000E+04, 2.8487245547E+01, 5.1548818709E+00, 1.1258666955E+01, 3.1454972668E+00, 9.5194179327E-01],
	[3.6035000000E+04, 2.8494010385E+01, 5.1549019688E+00, 1.1263747696E+01, 3.1459836851E+00, 9.5196342756E-01],
	[3.6040000000E+04, 2.8500775891E+01, 5.1549220640E+00, 1.1268830023E+01, 3.1464699877E+00, 9.5198505109E-01],
	[3.6045000000E+04, 2.8507542064E+01, 5.1549421564E+00, 1.1273913937E+01, 3.1469561747E+00, 9.5200666388E-01],
	[3.6050000000E+04, 2.8514308904E+01, 5.1549622462E+00, 1.1278999438E+01, 3.1474422461E+00, 9.5202826591E-01],
	[3.6055000000E+04, 2.8521076412E+01, 5.1549823332E+00, 1.1284086526E+01, 3.1479282019E+00, 9.5204985721E-01],
	[3.6060000000E+04, 2.8527844587E+01, 5.1550024175E+00, 1.1289175201E+01, 3.1484140421E+00, 9.5207143777E-01],
	[3.6065000000E+04, 2.8534613429E+01, 5.1550224991E+00, 1.1294265465E+01, 3.1488997667E+00, 9.5209300760E-01],
	[3.6070000000E+04, 2.8541382939E+01, 5.1550425781E+00, 1.1299357316E+01, 3.1493853757E+00, 9.5211456671E-01],
	[3.6075000000E+04, 2.8548153117E+01, 5.1550626543E+00, 1.1304450756E+01, 3.1498708692E+00, 9.5213611511E-01],
	[3.6080000000E+04, 2.8554923961E+01, 5.1550827278E+00, 1.1309545784E+01, 3.1503562472E+00, 9.5215765278E-01],
	[3.6085000000E+04, 2.8561695473E+01, 5.1551027986E+00, 1.1314642401E+01, 3.1508415096E+00, 9.5217917976E-01],
	[3.6090000000E+04, 2.8568467652E+01, 5.1551228667E+00, 1.1319740608E+01, 3.1513266564E+00, 9.5220069603E-01],
	[3.6095000000E+04, 2.8575240499E+01, 5.1551429321E+00, 1.1324840403E+01, 3.1518116878E+00, 9.5222220160E-01],
	[3.6100000000E+04, 2.8582014012E+01, 5.1551629948E+00, 1.1329941789E+01, 3.1522966037E+00, 9.5224369648E-01],
	[3.6105000000E+04, 2.8588788193E+01, 5.1551830548E+00, 1.1335044764E+01, 3.1527814040E+00, 9.5226518068E-01],
	[3.6110000000E+04, 2.8595563041E+01, 5.1552031121E+00, 1.1340149330E+01, 3.1532660889E+00, 9.5228665420E-01],
	[3.6115000000E+04, 2.8602338556E+01, 5.1552231666E+00, 1.1345255486E+01, 3.1537506583E+00, 9.5230811705E-01],
	[3.6120000000E+04, 2.8609114738E+01, 5.1552432185E+00, 1.1350363233E+01, 3.1542351122E+00, 9.5232956922E-01],
	[3.6125000000E+04, 2.8615891587E+01, 5.1552632677E+00, 1.1355472571E+01, 3.1547194506E+00, 9.5235101073E-01],
	[3.6130000000E+04, 2.8622669103E+01, 5.1552833142E+00, 1.1360583500E+01, 3.1552036736E+00, 9.5237244159E-01],
	[3.6135000000E+04, 2.8629447286E+01, 5.1553033581E+00, 1.1365696021E+01, 3.1556877812E+00, 9.5239386179E-01],
	[3.6140000000E+04, 2.8636226137E+01, 5.1553233992E+00, 1.1370810134E+01, 3.1561717734E+00, 9.5241527134E-01],
	[3.6145000000E+04, 2.8643005654E+01, 5.1553434376E+00, 1.1375925839E+01, 3.1566556501E+00, 9.5243667026E-01],
	[3.6150000000E+04, 2.8649785838E+01, 5.1553634733E+00, 1.1381043136E+01, 3.1571394114E+00, 9.5245805853E-01],
	[3.6155000000E+04, 2.8656566689E+01, 5.1553835063E+00, 1.1386162027E+01, 3.1576230573E+00, 9.5247943618E-01],
	[3.6160000000E+04, 2.8663348207E+01, 5.1554035367E+00, 1.1391282510E+01, 3.1581065879E+00, 9.5250080320E-01],
	[3.6165000000E+04, 2.8670130391E+01, 5.1554235643E+00, 1.1396404586E+01, 3.1585900031E+00, 9.5252215960E-01],
	[3.6170000000E+04, 2.8676913243E+01, 5.1554435893E+00, 1.1401528256E+01, 3.1590733029E+00, 9.5254350539E-01],
	[3.6175000000E+04, 2.8683696761E+01, 5.1554636115E+00, 1.1406653520E+01, 3.1595564873E+00, 9.5256484057E-01],
	[3.6180000000E+04, 2.8690480946E+01, 5.1554836311E+00, 1.1411780378E+01, 3.1600395564E+00, 9.5258616514E-01],
	[3.6185000000E+04, 2.8697265798E+01, 5.1555036480E+00, 1.1416908830E+01, 3.1605225102E+00, 9.5260747912E-01],
	[3.6190000000E+04, 2.8704051317E+01, 5.1555236622E+00, 1.1422038877E+01, 3.1610053486E+00, 9.5262878251E-01],
	[3.6195000000E+04, 2.8710837502E+01, 5.1555436737E+00, 1.1427170519E+01, 3.1614880717E+00, 9.5265007530E-01],
	[3.6200000000E+04, 2.8717624354E+01, 5.1555636825E+00, 1.1432303756E+01, 3.1619706796E+00, 9.5267135752E-01],
	[3.6205000000E+04, 2.8724411873E+01, 5.1555836887E+00, 1.1437438588E+01, 3.1624531721E+00, 9.5269262916E-01],
	[3.6210000000E+04, 2.8731200058E+01, 5.1556036921E+00, 1.1442575017E+01, 3.1629355493E+00, 9.5271389023E-01],
	[3.6215000000E+04, 2.8737988910E+01, 5.1556236929E+00, 1.1447713041E+01, 3.1634178113E+00, 9.5273514073E-01],
	[3.6220000000E+04, 2.8744778428E+01, 5.1556436910E+00, 1.1452852661E+01, 3.1638999580E+00, 9.5275638068E-01],
	[3.6225000000E+04, 2.8751568613E+01, 5.1556636864E+00, 1.1457993878E+01, 3.1643819895E+00, 9.5277761007E-01],
	[3.6230000000E+04, 2.8758376537E+01, 5.1556859524E+00, 1.1463136692E+01, 3.1648649691E+00, 9.5279882891E-01],
	[3.6235000000E+04, 2.8765186715E+01, 5.1557084260E+00, 1.1468281103E+01, 3.1653479324E+00, 9.5282003721E-01],
	[3.6240000000E+04, 2.8771997565E+01, 5.1557308965E+00, 1.1473427112E+01, 3.1658307809E+00, 9.5284123497E-01],
	[3.6245000000E+04, 2.8778809088E+01, 5.1557533641E+00, 1.1478574718E+01, 3.1663135146E+00, 9.5286242219E-01],
	[3.6250000000E+04, 2.8785621283E+01, 5.1557758286E+00, 1.1483723922E+01, 3.1667961336E+00, 9.5288359889E-01],
	[3.6255000000E+04, 2.8792434151E+01, 5.1557982901E+00, 1.1488874724E+01, 3.1672786378E+00, 9.5290476507E-01],
	[3.6260000000E+04, 2.8799247692E+01, 5.1558207487E+00, 1.1494027125E+01, 3.1677610273E+00, 9.5292592073E-01],
	[3.6265000000E+04, 2.8806061905E+01, 5.1558432042E+00, 1.1499181124E+01, 3.1682433020E+00, 9.5294706588E-01],
	[3.6270000000E+04, 2.8812876791E+01, 5.1558656568E+00, 1.1504336723E+01, 3.1687254620E+00, 9.5296820053E-01],
	[3.6275000000E+04, 2.8819692350E+01, 5.1558881063E+00, 1.1509493921E+01, 3.1692075073E+00, 9.5298932468E-01],
	[3.6280000000E+04, 2.8826508580E+01, 5.1559105529E+00, 1.1514652718E+01, 3.1696894379E+00, 9.5301043833E-01],
	[3.6285000000E+04, 2.8833325484E+01, 5.1559329964E+00, 1.1519813116E+01, 3.1701712538E+00, 9.5303154149E-01],
	[3.6290000000E+04, 2.8840143059E+01, 5.1559554370E+00, 1.1524975113E+01, 3.1706529551E+00, 9.5305263417E-01],
	[3.6295000000E+04, 2.8846961308E+01, 5.1559778746E+00, 1.1530138711E+01, 3.1711345416E+00, 9.5307371637E-01],
	[3.6300000000E+04, 2.8853780228E+01, 5.1560003091E+00, 1.1535303910E+01, 3.1716160135E+00, 9.5309478809E-01],
	[3.6305000000E+04, 2.8860599821E+01, 5.1560227407E+00, 1.1540470709E+01, 3.1720973708E+00, 9.5311584935E-01],
	[3.6310000000E+04, 2.8867420086E+01, 5.1560451693E+00, 1.1545639110E+01, 3.1725786134E+00, 9.5313690015E-01],
	[3.6315000000E+04, 2.8874241024E+01, 5.1560675949E+00, 1.1550809112E+01, 3.1730597414E+00, 9.5315794049E-01],
	[3.6320000000E+04, 2.8881062634E+01, 5.1560900175E+00, 1.1555980716E+01, 3.1735407548E+00, 9.5317897038E-01],
	[3.6325000000E+04, 2.8887884916E+01, 5.1561124372E+00, 1.1561153923E+01, 3.1740216535E+00, 9.5319998983E-01],
	[3.6330000000E+04, 2.8894707870E+01, 5.1561348538E+00, 1.1566328731E+01, 3.1745024377E+00, 9.5322099883E-01],
	[3.6335000000E+04, 2.8901531497E+01, 5.1561572674E+00, 1.1571505142E+01, 3.1749831073E+00, 9.5324199740E-01],
	[3.6340000000E+04, 2.8908355795E+01, 5.1561796781E+00, 1.1576683156E+01, 3.1754636623E+00, 9.5326298554E-01],
	[3.6345000000E+04, 2.8915180766E+01, 5.1562020858E+00, 1.1581862773E+01, 3.1759441028E+00, 9.5328396326E-01],
	[3.6350000000E+04, 2.8922006409E+01, 5.1562244905E+00, 1.1587043994E+01, 3.1764244287E+00, 9.5330493055E-01],
	[3.6355000000E+04, 2.8928832724E+01, 5.1562468922E+00, 1.1592226818E+01, 3.1769046400E+00, 9.5332588744E-01],
	[3.6360000000E+04, 2.8935659711E+01, 5.1562692909E+00, 1.1597411247E+01, 3.1773847369E+00, 9.5334683391E-01],
	[3.6365000000E+04, 2.8942487371E+01, 5.1562916866E+00, 1.1602597279E+01, 3.1778647192E+00, 9.5336776999E-01],
	[3.6370000000E+04, 2.8949315702E+01, 5.1563140794E+00, 1.1607784917E+01, 3.1783445870E+00, 9.5338869567E-01],
	[3.6375000000E+04, 2.8956144705E+01, 5.1563364691E+00, 1.1612974159E+01, 3.1788243403E+00, 9.5340961095E-01],
	[3.6380000000E+04, 2.8962974380E+01, 5.1563588559E+00, 1.1618165006E+01, 3.1793039791E+00, 9.5343051585E-01],
	[3.6385000000E+04, 2.8969804727E+01, 5.1563812398E+00, 1.1623357458E+01, 3.1797835035E+00, 9.5345141037E-01],
	[3.6390000000E+04, 2.8976635746E+01, 5.1564036206E+00, 1.1628551516E+01, 3.1802629134E+00, 9.5347229451E-01],
	[3.6395000000E+04, 2.8983467437E+01, 5.1564259985E+00, 1.1633747180E+01, 3.1807422088E+00, 9.5349316828E-01],
	[3.6400000000E+04, 2.8990299800E+01, 5.1564483733E+00, 1.1638944450E+01, 3.1812213898E+00, 9.5351403169E-01],
	[3.6405000000E+04, 2.8997132835E+01, 5.1564707452E+00, 1.1644143327E+01, 3.1817004564E+00, 9.5353488474E-01],
	[3.6410000000E+04, 2.9003966541E+01, 5.1564931142E+00, 1.1649343811E+01, 3.1821794086E+00, 9.5355572744E-01],
	[3.6415000000E+04, 2.9010800919E+01, 5.1565154801E+00, 1.1654545901E+01, 3.1826582463E+00, 9.5357655979E-01],
	[3.6420000000E+04, 2.9017635969E+01, 5.1565378431E+00, 1.1659749599E+01, 3.1831369697E+00, 9.5359738179E-01],
	[3.6425000000E+04, 2.9024471691E+01, 5.1565602031E+00, 1.1664954904E+01, 3.1836155786E+00, 9.5361819346E-01],
	[3.6430000000E+04, 2.9031308084E+01, 5.1565825602E+00, 1.1670161817E+01, 3.1840940732E+00, 9.5363899479E-01],
	[3.6435000000E+04, 2.9038145149E+01, 5.1566049142E+00, 1.1675370339E+01, 3.1845724534E+00, 9.5365978580E-01],
	[3.6440000000E+04, 2.9044982886E+01, 5.1566272653E+00, 1.1680580468E+01, 3.1850507193E+00, 9.5368056649E-01],
	[3.6445000000E+04, 2.9051821294E+01, 5.1566496134E+00, 1.1685792207E+01, 3.1855288708E+00, 9.5370133686E-01],
	[3.6450000000E+04, 2.9058660374E+01, 5.1566719586E+00, 1.1691005554E+01, 3.1860069080E+00, 9.5372209692E-01],
	[3.6455000000E+04, 2.9065500126E+01, 5.1566943008E+00, 1.1696220511E+01, 3.1864848309E+00, 9.5374284667E-01],
	[3.6460000000E+04, 2.9072340549E+01, 5.1567166400E+00, 1.1701437077E+01, 3.1869626395E+00, 9.5376358613E-01],
	[3.6465000000E+04, 2.9079181643E+01, 5.1567389763E+00, 1.1706655253E+01, 3.1874403338E+00, 9.5378431529E-01],
	[3.6470000000E+04, 2.9086023410E+01, 5.1567613096E+00, 1.1711875038E+01, 3.1879179138E+00, 9.5380503416E-01],
	[3.6475000000E+04, 2.9092865847E+01, 5.1567836399E+00, 1.1717096435E+01, 3.1883953795E+00, 9.5382574275E-01],
	[3.6480000000E+04, 2.9099708956E+01, 5.1568059672E+00, 1.1722319442E+01, 3.1888727310E+00, 9.5384644106E-01],
	[3.6485000000E+04, 2.9106552737E+01, 5.1568282916E+00, 1.1727544059E+01, 3.1893499682E+00, 9.5386712910E-01],
	[3.6490000000E+04, 2.9113397188E+01, 5.1568506131E+00, 1.1732770288E+01, 3.1898270912E+00, 9.5388780687E-01],
	[3.6495000000E+04, 2.9120242311E+01, 5.1568729315E+00, 1.1737998128E+01, 3.1903040999E+00, 9.5390847438E-01],
	[3.6500000000E+04, 2.9127088106E+01, 5.1568952470E+00, 1.1743227580E+01, 3.1907809945E+00, 9.5392913163E-01],
	[3.6505000000E+04, 2.9133934572E+01, 5.1569175596E+00, 1.1748458644E+01, 3.1912577748E+00, 9.5394977863E-01],
	[3.6510000000E+04, 2.9140781709E+01, 5.1569398692E+00, 1.1753691321E+01, 3.1917344410E+00, 9.5397041538E-01],
	[3.6515000000E+04, 2.9147629517E+01, 5.1569621758E+00, 1.1758925609E+01, 3.1922109929E+00, 9.5399104190E-01],
	[3.6520000000E+04, 2.9154477997E+01, 5.1569844795E+00, 1.1764161511E+01, 3.1926874307E+00, 9.5401165818E-01],
	[3.6525000000E+04, 2.9161327148E+01, 5.1570067802E+00, 1.1769399026E+01, 3.1931637543E+00, 9.5403226422E-01],
	[3.6530000000E+04, 2.9168176970E+01, 5.1570290780E+00, 1.1774638154E+01, 3.1936399638E+00, 9.5405286005E-01],
	[3.6535000000E+04, 2.9175027463E+01, 5.1570513728E+00, 1.1779878895E+01, 3.1941160592E+00, 9.5407344565E-01],
	[3.6540000000E+04, 2.9181878627E+01, 5.1570736646E+00, 1.1785121251E+01, 3.1945920404E+00, 9.5409402104E-01],
	[3.6545000000E+04, 2.9188730462E+01, 5.1570959535E+00, 1.1790365221E+01, 3.1950679075E+00, 9.5411458623E-01],
	[3.6550000000E+04, 2.9195582969E+01, 5.1571182395E+00, 1.1795610805E+01, 3.1955436605E+00, 9.5413514121E-01],
	[3.6555000000E+04, 2.9202436146E+01, 5.1571405225E+00, 1.1800858004E+01, 3.1960192995E+00, 9.5415568599E-01],
	[3.6560000000E+04, 2.9209289995E+01, 5.1571628025E+00, 1.1806106818E+01, 3.1964948243E+00, 9.5417622058E-01],
	[3.6565000000E+04, 2.9216144514E+01, 5.1571850796E+00, 1.1811357247E+01, 3.1969702351E+00, 9.5419674498E-01],
	[3.6570000000E+04, 2.9222999705E+01, 5.1572073537E+00, 1.1816609292E+01, 3.1974455319E+00, 9.5421725921E-01],
	[3.6575000000E+04, 2.9229855566E+01, 5.1572296249E+00, 1.1821862952E+01, 3.1979207146E+00, 9.5423776325E-01],
	[3.6580000000E+04, 2.9236712099E+01, 5.1572518932E+00, 1.1827118229E+01, 3.1983957832E+00, 9.5425825713E-01],
	[3.6585000000E+04, 2.9243569302E+01, 5.1572741585E+00, 1.1832375122E+01, 3.1988707379E+00, 9.5427874084E-01],
	[3.6590000000E+04, 2.9250427176E+01, 5.1572964208E+00, 1.1837633632E+01, 3.1993455785E+00, 9.5429921439E-01],
	[3.6595000000E+04, 2.9257285721E+01, 5.1573186802E+00, 1.1842893759E+01, 3.1998203052E+00, 9.5431967778E-01],
	[3.6600000000E+04, 2.9264144937E+01, 5.1573409367E+00, 1.1848155503E+01, 3.2002949178E+00, 9.5434013103E-01],
	[3.6605000000E+04, 2.9271004823E+01, 5.1573631902E+00, 1.1853418864E+01, 3.2007694165E+00, 9.5436057413E-01],
	[3.6610000000E+04, 2.9277865381E+01, 5.1573854408E+00, 1.1858683843E+01, 3.2012438013E+00, 9.5438100709E-01],
	[3.6615000000E+04, 2.9284726609E+01, 5.1574076884E+00, 1.1863950441E+01, 3.2017180721E+00, 9.5440142992E-01],
	[3.6620000000E+04, 2.9291588507E+01, 5.1574299331E+00, 1.1869218656E+01, 3.2021922289E+00, 9.5442184262E-01],
	[3.6625000000E+04, 2.9298451077E+01, 5.1574521748E+00, 1.1874488491E+01, 3.2026662719E+00, 9.5444224520E-01],
	[3.6630000000E+04, 2.9305314317E+01, 5.1574744136E+00, 1.1879759944E+01, 3.2031402009E+00, 9.5446263766E-01],
	[3.6635000000E+04, 2.9312178228E+01, 5.1574966495E+00, 1.1885033016E+01, 3.2036140160E+00, 9.5448302001E-01],
	[3.6640000000E+04, 2.9319042809E+01, 5.1575188824E+00, 1.1890307707E+01, 3.2040877172E+00, 9.5450339226E-01],
	[3.6645000000E+04, 2.9325908061E+01, 5.1575411124E+00, 1.1895584019E+01, 3.2045613046E+00, 9.5452375440E-01],
	[3.6650000000E+04, 2.9332773984E+01, 5.1575633395E+00, 1.1900861950E+01, 3.2050347781E+00, 9.5454410645E-01],
	[3.6655000000E+04, 2.9339640577E+01, 5.1575855636E+00, 1.1906141502E+01, 3.2055081378E+00, 9.5456444840E-01],
	[3.6660000000E+04, 2.9346507840E+01, 5.1576077848E+00, 1.1911422674E+01, 3.2059813836E+00, 9.5458478027E-01],
	[3.6665000000E+04, 2.9353375774E+01, 5.1576300030E+00, 1.1916705467E+01, 3.2064545156E+00, 9.5460510206E-01],
	[3.6670000000E+04, 2.9360244379E+01, 5.1576522183E+00, 1.1921989881E+01, 3.2069275337E+00, 9.5462541378E-01],
	[3.6675000000E+04, 2.9367113654E+01, 5.1576744307E+00, 1.1927275916E+01, 3.2074004381E+00, 9.5464571543E-01],
	[3.6680000000E+04, 2.9373983599E+01, 5.1576966401E+00, 1.1932563573E+01, 3.2078732287E+00, 9.5466600701E-01],
	[3.6685000000E+04, 2.9380854215E+01, 5.1577188467E+00, 1.1937852852E+01, 3.2083459055E+00, 9.5468628853E-01],
	[3.6690000000E+04, 2.9387725501E+01, 5.1577410502E+00, 1.1943143753E+01, 3.2088184685E+00, 9.5470656001E-01],
	[3.6695000000E+04, 2.9394597457E+01, 5.1577632509E+00, 1.1948436276E+01, 3.2092909178E+00, 9.5472682143E-01],
	[3.6700000000E+04, 2.9401470084E+01, 5.1577854486E+00, 1.1953730423E+01, 3.2097632534E+00, 9.5474707281E-01],
	[3.6705000000E+04, 2.9408343380E+01, 5.1578076434E+00, 1.1959026192E+01, 3.2102354752E+00, 9.5476731415E-01],
	[3.6710000000E+04, 2.9415217348E+01, 5.1578298353E+00, 1.1964323584E+01, 3.2107075833E+00, 9.5478754547E-01],
	[3.6715000000E+04, 2.9422091985E+01, 5.1578520242E+00, 1.1969622600E+01, 3.2111795777E+00, 9.5480776675E-01],
	[3.6720000000E+04, 2.9428967293E+01, 5.1578742102E+00, 1.1974923240E+01, 3.2116514584E+00, 9.5482797802E-01],
	[3.6725000000E+04, 2.9435843270E+01, 5.1578963933E+00, 1.1980225504E+01, 3.2121232254E+00, 9.5484817926E-01],
	[3.6730000000E+04, 2.9442719918E+01, 5.1579185735E+00, 1.1985529393E+01, 3.2125948788E+00, 9.5486837050E-01],
	[3.6735000000E+04, 2.9449597236E+01, 5.1579407507E+00, 1.1990834906E+01, 3.2130664185E+00, 9.5488855173E-01],
	[3.6740000000E+04, 2.9456475224E+01, 5.1579629250E+00, 1.1996142044E+01, 3.2135378445E+00, 9.5490872297E-01],
	[3.6745000000E+04, 2.9463353882E+01, 5.1579850964E+00, 1.2001450807E+01, 3.2140091570E+00, 9.5492888420E-01],
	[3.6750000000E+04, 2.9470233210E+01, 5.1580072649E+00, 1.2006761196E+01, 3.2144803558E+00, 9.5494903545E-01],
	[3.6755000000E+04, 2.9477113209E+01, 5.1580294305E+00, 1.2012073211E+01, 3.2149514410E+00, 9.5496917672E-01],
	[3.6760000000E+04, 2.9483993877E+01, 5.1580515931E+00, 1.2017386851E+01, 3.2154224126E+00, 9.5498930800E-01],
	[3.6765000000E+04, 2.9490875215E+01, 5.1580737528E+00, 1.2022702118E+01, 3.2158932706E+00, 9.5500942932E-01],
	[3.6770000000E+04, 2.9497757223E+01, 5.1580959096E+00, 1.2028019011E+01, 3.2163640151E+00, 9.5502954066E-01],
	[3.6775000000E+04, 2.9504639901E+01, 5.1581180635E+00, 1.2033337532E+01, 3.2168346460E+00, 9.5504964204E-01],
	[3.6780000000E+04, 2.9511523249E+01, 5.1581402145E+00, 1.2038657679E+01, 3.2173051633E+00, 9.5506973346E-01],
	[3.6785000000E+04, 2.9518407267E+01, 5.1581623625E+00, 1.2043979454E+01, 3.2177755672E+00, 9.5508981494E-01],
	[3.6790000000E+04, 2.9525291954E+01, 5.1581845076E+00, 1.2049302857E+01, 3.2182458575E+00, 9.5510988646E-01],
	[3.6795000000E+04, 2.9532177311E+01, 5.1582066498E+00, 1.2054627887E+01, 3.2187160343E+00, 9.5512994804E-01],
	[3.6800000000E+04, 2.9539063338E+01, 5.1582287891E+00, 1.2059954546E+01, 3.2191860976E+00, 9.5514999969E-01],
	[3.6805000000E+04, 2.9545950035E+01, 5.1582509255E+00, 1.2065282834E+01, 3.2196560475E+00, 9.5517004141E-01],
	[3.6810000000E+04, 2.9552842553E+01, 5.1582737378E+00, 1.2070612750E+01, 3.2201262095E+00, 9.5519007320E-01],
	[3.6815000000E+04, 2.9559749038E+01, 5.1582982988E+00, 1.2075944295E+01, 3.2205970989E+00, 9.5521009507E-01],
	[3.6820000000E+04, 2.9566656199E+01, 5.1583228566E+00, 1.2081277470E+01, 3.2210678753E+00, 9.5523010702E-01],
	[3.6825000000E+04, 2.9573564035E+01, 5.1583474112E+00, 1.2086612274E+01, 3.2215385387E+00, 9.5525010907E-01],
	[3.6830000000E+04, 2.9580472548E+01, 5.1583719626E+00, 1.2091948708E+01, 3.2220090890E+00, 9.5527010121E-01],
	[3.6835000000E+04, 2.9587381736E+01, 5.1583965108E+00, 1.2097286773E+01, 3.2224795264E+00, 9.5529008345E-01],
	[3.6840000000E+04, 2.9594291600E+01, 5.1584210557E+00, 1.2102626467E+01, 3.2229498508E+00, 9.5531005579E-01],
	[3.6845000000E+04, 2.9601202139E+01, 5.1584455975E+00, 1.2107967793E+01, 3.2234200622E+00, 9.5533001825E-01],
	[3.6850000000E+04, 2.9608113354E+01, 5.1584701360E+00, 1.2113310750E+01, 3.2238901607E+00, 9.5534997083E-01],
	[3.6855000000E+04, 2.9615025245E+01, 5.1584946713E+00, 1.2118655337E+01, 3.2243601462E+00, 9.5536991352E-01],
	[3.6860000000E+04, 2.9621937811E+01, 5.1585192034E+00, 1.2124001557E+01, 3.2248300188E+00, 9.5538984635E-01],
	[3.6865000000E+04, 2.9628851053E+01, 5.1585437323E+00, 1.2129349408E+01, 3.2252997785E+00, 9.5540976930E-01],
	[3.6870000000E+04, 2.9635764970E+01, 5.1585682580E+00, 1.2134698891E+01, 3.2257694252E+00, 9.5542968240E-01],
	[3.6875000000E+04, 2.9642679563E+01, 5.1585927805E+00, 1.2140050007E+01, 3.2262389591E+00, 9.5544958563E-01],
	[3.6880000000E+04, 2.9649594831E+01, 5.1586172998E+00, 1.2145402756E+01, 3.2267083801E+00, 9.5546947902E-01],
	[3.6885000000E+04, 2.9656510775E+01, 5.1586418158E+00, 1.2150757137E+01, 3.2271776883E+00, 9.5548936255E-01],
	[3.6890000000E+04, 2.9663427394E+01, 5.1586663287E+00, 1.2156113152E+01, 3.2276468835E+00, 9.5550923624E-01],
	[3.6895000000E+04, 2.9670344689E+01, 5.1586908383E+00, 1.2161470800E+01, 3.2281159660E+00, 9.5552910010E-01],
	[3.6900000000E+04, 2.9677262659E+01, 5.1587153447E+00, 1.2166830082E+01, 3.2285849356E+00, 9.5554895412E-01],
	[3.6905000000E+04, 2.9684181304E+01, 5.1587398480E+00, 1.2172190998E+01, 3.2290537924E+00, 9.5556879830E-01],
	[3.6910000000E+04, 2.9691100625E+01, 5.1587643480E+00, 1.2177553548E+01, 3.2295225364E+00, 9.5558863267E-01],
	[3.6915000000E+04, 2.9698020620E+01, 5.1587888449E+00, 1.2182917733E+01, 3.2299911676E+00, 9.5560845722E-01],
	[3.6920000000E+04, 2.9704941292E+01, 5.1588133385E+00, 1.2188283553E+01, 3.2304596860E+00, 9.5562827195E-01],
	[3.6925000000E+04, 2.9711862638E+01, 5.1588378289E+00, 1.2193651008E+01, 3.2309280916E+00, 9.5564807687E-01],
	[3.6930000000E+04, 2.9718784660E+01, 5.1588623161E+00, 1.2199020098E+01, 3.2313963846E+00, 9.5566787199E-01],
	[3.6935000000E+04, 2.9725707356E+01, 5.1588868002E+00, 1.2204390824E+01, 3.2318645647E+00, 9.5568765730E-01],
	[3.6940000000E+04, 2.9732630728E+01, 5.1589112810E+00, 1.2209763186E+01, 3.2323326322E+00, 9.5570743283E-01],
	[3.6945000000E+04, 2.9739554775E+01, 5.1589357586E+00, 1.2215137184E+01, 3.2328005869E+00, 9.5572719856E-01],
	[3.6950000000E+04, 2.9746479498E+01, 5.1589602331E+00, 1.2220512819E+01, 3.2332684289E+00, 9.5574695450E-01],
	[3.6955000000E+04, 2.9753404895E+01, 5.1589847043E+00, 1.2225890091E+01, 3.2337361583E+00, 9.5576670067E-01],
	[3.6960000000E+04, 2.9760330967E+01, 5.1590091724E+00, 1.2231269000E+01, 3.2342037749E+00, 9.5578643705E-01],
	[3.6965000000E+04, 2.9767257715E+01, 5.1590336372E+00, 1.2236649546E+01, 3.2346712789E+00, 9.5580616367E-01],
	[3.6970000000E+04, 2.9774185137E+01, 5.1590580989E+00, 1.2242031730E+01, 3.2351386703E+00, 9.5582588052E-01],
	[3.6975000000E+04, 2.9781113234E+01, 5.1590825574E+00, 1.2247415551E+01, 3.2356059490E+00, 9.5584558761E-01],
	[3.6980000000E+04, 2.9788042007E+01, 5.1591070126E+00, 1.2252801011E+01, 3.2360731151E+00, 9.5586528494E-01],
	[3.6985000000E+04, 2.9794971454E+01, 5.1591314647E+00, 1.2258188110E+01, 3.2365401686E+00, 9.5588497252E-01],
	[3.6990000000E+04, 2.9801901576E+01, 5.1591559136E+00, 1.2263576847E+01, 3.2370071095E+00, 9.5590465035E-01],
	[3.6995000000E+04, 2.9808832373E+01, 5.1591803593E+00, 1.2268967223E+01, 3.2374739378E+00, 9.5592431844E-01],
	[3.7000000000E+04, 2.9815763845E+01, 5.1592048018E+00, 1.2274359238E+01, 3.2379406535E+00, 9.5594397679E-01],
	[3.7005000000E+04, 2.9822695992E+01, 5.1592292412E+00, 1.2279752893E+01, 3.2384072567E+00, 9.5596362541E-01],
	[3.7010000000E+04, 2.9829628813E+01, 5.1592536773E+00, 1.2285148188E+01, 3.2388737473E+00, 9.5598326430E-01],
	[3.7015000000E+04, 2.9836562310E+01, 5.1592781103E+00, 1.2290545123E+01, 3.2393401254E+00, 9.5600289347E-01],
	[3.7020000000E+04, 2.9843496481E+01, 5.1593025401E+00, 1.2295943699E+01, 3.2398063910E+00, 9.5602251292E-01],
	[3.7025000000E+04, 2.9850431327E+01, 5.1593269667E+00, 1.2301343915E+01, 3.2402725441E+00, 9.5604212266E-01],
	[3.7030000000E+04, 2.9857366847E+01, 5.1593513901E+00, 1.2306745772E+01, 3.2407385847E+00, 9.5606172268E-01],
	[3.7035000000E+04, 2.9864303042E+01, 5.1593758103E+00, 1.2312149270E+01, 3.2412045128E+00, 9.5608131301E-01],
	[3.7040000000E+04, 2.9871239912E+01, 5.1594002274E+00, 1.2317554410E+01, 3.2416703285E+00, 9.5610089363E-01],
	[3.7045000000E+04, 2.9878177457E+01, 5.1594246412E+00, 1.2322961192E+01, 3.2421360317E+00, 9.5612046456E-01],
	[3.7050000000E+04, 2.9885115676E+01, 5.1594490519E+00, 1.2328369615E+01, 3.2426016224E+00, 9.5614002580E-01],
	[3.7055000000E+04, 2.9892054569E+01, 5.1594734594E+00, 1.2333779681E+01, 3.2430671007E+00, 9.5615957735E-01],
	[3.7060000000E+04, 2.9898994138E+01, 5.1594978638E+00, 1.2339191390E+01, 3.2435324667E+00, 9.5617911923E-01],
	[3.7065000000E+04, 2.9905934380E+01, 5.1595222649E+00, 1.2344604741E+01, 3.2439977202E+00, 9.5619865143E-01],
	[3.7070000000E+04, 2.9912875298E+01, 5.1595466629E+00, 1.2350019736E+01, 3.2444628613E+00, 9.5621817396E-01],
	[3.7075000000E+04, 2.9919816889E+01, 5.1595710577E+00, 1.2355436374E+01, 3.2449278901E+00, 9.5623768682E-01],
	[3.7080000000E+04, 2.9926759155E+01, 5.1595954493E+00, 1.2360854656E+01, 3.2453928065E+00, 9.5625719002E-01],
	[3.7085000000E+04, 2.9933702096E+01, 5.1596198378E+00, 1.2366274582E+01, 3.2458576105E+00, 9.5627668357E-01],
	[3.7090000000E+04, 2.9940645711E+01, 5.1596442231E+00, 1.2371696152E+01, 3.2463223023E+00, 9.5629616747E-01],
	[3.7095000000E+04, 2.9947590000E+01, 5.1596686052E+00, 1.2377119367E+01, 3.2467868817E+00, 9.5631564172E-01],
	[3.7100000000E+04, 2.9954534964E+01, 5.1596929841E+00, 1.2382544227E+01, 3.2472513488E+00, 9.5633510632E-01],
	[3.7105000000E+04, 2.9961480602E+01, 5.1597173599E+00, 1.2387970731E+01, 3.2477157036E+00, 9.5635456129E-01],
	[3.7110000000E+04, 2.9968426914E+01, 5.1597417325E+00, 1.2393398881E+01, 3.2481799461E+00, 9.5637400663E-01],
	[3.7115000000E+04, 2.9975373901E+01, 5.1597661019E+00, 1.2398828677E+01, 3.2486440764E+00, 9.5639344234E-01],
	[3.7120000000E+04, 2.9982321562E+01, 5.1597904682E+00, 1.2404260119E+01, 3.2491080944E+00, 9.5641286843E-01],
	[3.7125000000E+04, 2.9989269897E+01, 5.1598148313E+00, 1.2409693207E+01, 3.2495720002E+00, 9.5643228491E-01],
	[3.7130000000E+04, 2.9996218906E+01, 5.1598391912E+00, 1.2415127941E+01, 3.2500357938E+00, 9.5645169176E-01],
	[3.7135000000E+04, 3.0003168590E+01, 5.1598635480E+00, 1.2420564322E+01, 3.2504994751E+00, 9.5647108901E-01],
	[3.7140000000E+04, 3.0010118947E+01, 5.1598879016E+00, 1.2426002350E+01, 3.2509630443E+00, 9.5649047666E-01],
	[3.7145000000E+04, 3.0017069979E+01, 5.1599122520E+00, 1.2431442026E+01, 3.2514265012E+00, 9.5650985471E-01],
	[3.7150000000E+04, 3.0024021685E+01, 5.1599365993E+00, 1.2436883349E+01, 3.2518898460E+00, 9.5652922317E-01],
	[3.7155000000E+04, 3.0030974065E+01, 5.1599609434E+00, 1.2442326320E+01, 3.2523530786E+00, 9.5654858203E-01],
	[3.7160000000E+04, 3.0037927119E+01, 5.1599852844E+00, 1.2447770939E+01, 3.2528161991E+00, 9.5656793131E-01],
	[3.7165000000E+04, 3.0044880846E+01, 5.1600096222E+00, 1.2453217207E+01, 3.2532792075E+00, 9.5658727102E-01],
	[3.7170000000E+04, 3.0051835248E+01, 5.1600339568E+00, 1.2458665123E+01, 3.2537421038E+00, 9.5660660115E-01],
	[3.7175000000E+04, 3.0058790324E+01, 5.1600582883E+00, 1.2464114688E+01, 3.2542048879E+00, 9.5662592170E-01],
	[3.7180000000E+04, 3.0065746074E+01, 5.1600826166E+00, 1.2469565903E+01, 3.2546675600E+00, 9.5664523270E-01],
	[3.7185000000E+04, 3.0072702498E+01, 5.1601069418E+00, 1.2475018767E+01, 3.2551301200E+00, 9.5666453413E-01],
	[3.7190000000E+04, 3.0079659596E+01, 5.1601312638E+00, 1.2480473281E+01, 3.2555925679E+00, 9.5668382601E-01],
	[3.7195000000E+04, 3.0086617367E+01, 5.1601555826E+00, 1.2485929445E+01, 3.2560549038E+00, 9.5670310834E-01],
	[3.7200000000E+04, 3.0093575812E+01, 5.1601798983E+00, 1.2491387259E+01, 3.2565171276E+00, 9.5672238112E-01],
	[3.7205000000E+04, 3.0100534932E+01, 5.1602042109E+00, 1.2496846724E+01, 3.2569792394E+00, 9.5674164436E-01],
	[3.7210000000E+04, 3.0107494724E+01, 5.1602285203E+00, 1.2502307840E+01, 3.2574412393E+00, 9.5676089807E-01],
	[3.7215000000E+04, 3.0114455191E+01, 5.1602528265E+00, 1.2507770607E+01, 3.2579031271E+00, 9.5678014224E-01],
	[3.7220000000E+04, 3.0121416332E+01, 5.1602771296E+00, 1.2513235026E+01, 3.2583649029E+00, 9.5679937689E-01],
	[3.7225000000E+04, 3.0128378146E+01, 5.1603014295E+00, 1.2518701096E+01, 3.2588265668E+00, 9.5681860201E-01],
	[3.7230000000E+04, 3.0135340634E+01, 5.1603257263E+00, 1.2524168818E+01, 3.2592881187E+00, 9.5683781762E-01],
	[3.7235000000E+04, 3.0142303795E+01, 5.1603500199E+00, 1.2529638193E+01, 3.2597495587E+00, 9.5685702372E-01],
	[3.7240000000E+04, 3.0149267630E+01, 5.1603743104E+00, 1.2535109220E+01, 3.2602108868E+00, 9.5687622031E-01],
	[3.7245000000E+04, 3.0156232139E+01, 5.1603985978E+00, 1.2540581900E+01, 3.2606721030E+00, 9.5689540739E-01],
	[3.7250000000E+04, 3.0163197322E+01, 5.1604228820E+00, 1.2546056233E+01, 3.2611332073E+00, 9.5691458498E-01],
	[3.7255000000E+04, 3.0170163177E+01, 5.1604471630E+00, 1.2551532220E+01, 3.2615941997E+00, 9.5693375307E-01],
	[3.7260000000E+04, 3.0177129707E+01, 5.1604714409E+00, 1.2557009860E+01, 3.2620550802E+00, 9.5695291168E-01],
	[3.7265000000E+04, 3.0184096910E+01, 5.1604957157E+00, 1.2562489155E+01, 3.2625158488E+00, 9.5697206080E-01],
	[3.7270000000E+04, 3.0191064786E+01, 5.1605199873E+00, 1.2567970103E+01, 3.2629765057E+00, 9.5699120045E-01],
	[3.7275000000E+04, 3.0198033336E+01, 5.1605442558E+00, 1.2573452706E+01, 3.2634370507E+00, 9.5701033062E-01],
	[3.7280000000E+04, 3.0205002560E+01, 5.1605685212E+00, 1.2578936964E+01, 3.2638974839E+00, 9.5702945132E-01],
	[3.7285000000E+04, 3.0211972456E+01, 5.1605927834E+00, 1.2584422877E+01, 3.2643578053E+00, 9.5704856256E-01],
	[3.7290000000E+04, 3.0218943027E+01, 5.1606170424E+00, 1.2589910446E+01, 3.2648180149E+00, 9.5706766433E-01],
	[3.7295000000E+04, 3.0225914270E+01, 5.1606412983E+00, 1.2595399669E+01, 3.2652781127E+00, 9.5708675665E-01],
	[3.7300000000E+04, 3.0232886187E+01, 5.1606655511E+00, 1.2600890549E+01, 3.2657380988E+00, 9.5710583953E-01],
	[3.7305000000E+04, 3.0239858777E+01, 5.1606898008E+00, 1.2606383085E+01, 3.2661979732E+00, 9.5712491295E-01],
	[3.7310000000E+04, 3.0246832041E+01, 5.1607140473E+00, 1.2611877278E+01, 3.2666577358E+00, 9.5714397694E-01],
	[3.7315000000E+04, 3.0253805977E+01, 5.1607382907E+00, 1.2617373127E+01, 3.2671173867E+00, 9.5716303149E-01],
	[3.7320000000E+04, 3.0260780587E+01, 5.1607625309E+00, 1.2622870633E+01, 3.2675769259E+00, 9.5718207661E-01],
	[3.7325000000E+04, 3.0267755870E+01, 5.1607867680E+00, 1.2628369797E+01, 3.2680363535E+00, 9.5720111230E-01],
	[3.7330000000E+04, 3.0274731827E+01, 5.1608110020E+00, 1.2633870618E+01, 3.2684956693E+00, 9.5722013857E-01],
	[3.7335000000E+04, 3.0281708456E+01, 5.1608352328E+00, 1.2639373097E+01, 3.2689548735E+00, 9.5723915543E-01],
	[3.7340000000E+04, 3.0288685759E+01, 5.1608594606E+00, 1.2644877234E+01, 3.2694139661E+00, 9.5725816287E-01],
	[3.7345000000E+04, 3.0295663735E+01, 5.1608836851E+00, 1.2650383029E+01, 3.2698729470E+00, 9.5727716091E-01],
	[3.7350000000E+04, 3.0302642383E+01, 5.1609079066E+00, 1.2655890483E+01, 3.2703318163E+00, 9.5729614954E-01],
	[3.7355000000E+04, 3.0309621705E+01, 5.1609321249E+00, 1.2661399596E+01, 3.2707905740E+00, 9.5731512878E-01],
	[3.7360000000E+04, 3.0316601700E+01, 5.1609563401E+00, 1.2666910369E+01, 3.2712492202E+00, 9.5733409862E-01],
	[3.7365000000E+04, 3.0323582368E+01, 5.1609805522E+00, 1.2672422800E+01, 3.2717077547E+00, 9.5735305908E-01],
	[3.7370000000E+04, 3.0330563709E+01, 5.1610047611E+00, 1.2677936892E+01, 3.2721661778E+00, 9.5737201015E-01],
	[3.7375000000E+04, 3.0337545723E+01, 5.1610289669E+00, 1.2683452644E+01, 3.2726244892E+00, 9.5739095184E-01],
	[3.7380000000E+04, 3.0344528410E+01, 5.1610531696E+00, 1.2688970056E+01, 3.2730826892E+00, 9.5740988416E-01],
	[3.7385000000E+04, 3.0351511769E+01, 5.1610773692E+00, 1.2694489128E+01, 3.2735407776E+00, 9.5742880711E-01],
	[3.7390000000E+04, 3.0358495802E+01, 5.1611015657E+00, 1.2700009862E+01, 3.2739987545E+00, 9.5744772070E-01],
	[3.7395000000E+04, 3.0365480507E+01, 5.1611257590E+00, 1.2705532256E+01, 3.2744566199E+00, 9.5746662492E-01],
	[3.7400000000E+04, 3.0372465886E+01, 5.1611499492E+00, 1.2711056312E+01, 3.2749143739E+00, 9.5748551980E-01],
	[3.7405000000E+04, 3.0379465896E+01, 5.1611759572E+00, 1.2716582030E+01, 3.2753729121E+00, 9.5750440532E-01],
	[3.7410000000E+04, 3.0386470859E+01, 5.1612025194E+00, 1.2722109410E+01, 3.2758316134E+00, 9.5752328150E-01],
	[3.7415000000E+04, 3.0393476501E+01, 5.1612290782E+00, 1.2727638452E+01, 3.2762902036E+00, 9.5754214833E-01],
	[3.7420000000E+04, 3.0400482821E+01, 5.1612556337E+00, 1.2733169157E+01, 3.2767486829E+00, 9.5756100583E-01],
	[3.7425000000E+04, 3.0407489820E+01, 5.1612821856E+00, 1.2738701524E+01, 3.2772070511E+00, 9.5757985400E-01],
	[3.7430000000E+04, 3.0414497498E+01, 5.1613087342E+00, 1.2744235555E+01, 3.2776653083E+00, 9.5759869285E-01],
	[3.7435000000E+04, 3.0421505854E+01, 5.1613352794E+00, 1.2749771249E+01, 3.2781234546E+00, 9.5761752237E-01],
	[3.7440000000E+04, 3.0428514889E+01, 5.1613618212E+00, 1.2755308607E+01, 3.2785814899E+00, 9.5763634257E-01],
	[3.7445000000E+04, 3.0435524603E+01, 5.1613883595E+00, 1.2760847628E+01, 3.2790394142E+00, 9.5765515347E-01],
	[3.7450000000E+04, 3.0442534995E+01, 5.1614148945E+00, 1.2766388314E+01, 3.2794972276E+00, 9.5767395506E-01],
	[3.7455000000E+04, 3.0449546066E+01, 5.1614414260E+00, 1.2771930664E+01, 3.2799549301E+00, 9.5769274734E-01],
	[3.7460000000E+04, 3.0456557815E+01, 5.1614679542E+00, 1.2777474679E+01, 3.2804125217E+00, 9.5771153033E-01],
	[3.7465000000E+04, 3.0463570242E+01, 5.1614944789E+00, 1.2783020360E+01, 3.2808700024E+00, 9.5773030402E-01],
	[3.7470000000E+04, 3.0470583348E+01, 5.1615210003E+00, 1.2788567705E+01, 3.2813273722E+00, 9.5774906843E-01],
	[3.7475000000E+04, 3.0477597133E+01, 5.1615475182E+00, 1.2794116716E+01, 3.2817846312E+00, 9.5776782355E-01],
	[3.7480000000E+04, 3.0484611595E+01, 5.1615740327E+00, 1.2799667393E+01, 3.2822417793E+00, 9.5778656939E-01],
	[3.7485000000E+04, 3.0491626737E+01, 5.1616005438E+00, 1.2805219736E+01, 3.2826988165E+00, 9.5780530596E-01],
	[3.7490000000E+04, 3.0498642556E+01, 5.1616270516E+00, 1.2810773746E+01, 3.2831557430E+00, 9.5782403326E-01],
	[3.7495000000E+04, 3.0505659054E+01, 5.1616535559E+00, 1.2816329422E+01, 3.2836125586E+00, 9.5784275130E-01],
	[3.7500000000E+04, 3.0512676230E+01, 5.1616800568E+00, 1.2821886765E+01, 3.2840692634E+00, 9.5786146008E-01],
	[3.7505000000E+04, 3.0519694084E+01, 5.1617065544E+00, 1.2827445776E+01, 3.2845258575E+00, 9.5788015960E-01],
	[3.7510000000E+04, 3.0526712617E+01, 5.1617330485E+00, 1.2833006454E+01, 3.2849823408E+00, 9.5789884987E-01],
	[3.7515000000E+04, 3.0533731828E+01, 5.1617595393E+00, 1.2838568800E+01, 3.2854387133E+00, 9.5791753090E-01],
	[3.7520000000E+04, 3.0540751717E+01, 5.1617860266E+00, 1.2844132814E+01, 3.2858949752E+00, 9.5793620268E-01],
	[3.7525000000E+04, 3.0547772284E+01, 5.1618125106E+00, 1.2849698496E+01, 3.2863511263E+00, 9.5795486523E-01],
	[3.7530000000E+04, 3.0554793530E+01, 5.1618389911E+00, 1.2855265847E+01, 3.2868071667E+00, 9.5797351855E-01],
	[3.7535000000E+04, 3.0561815453E+01, 5.1618654683E+00, 1.2860834867E+01, 3.2872630964E+00, 9.5799216265E-01],
	[3.7540000000E+04, 3.0568838055E+01, 5.1618919421E+00, 1.2866405556E+01, 3.2877189154E+00, 9.5801079752E-01],
	[3.7545000000E+04, 3.0575861334E+01, 5.1619184125E+00, 1.2871977915E+01, 3.2881746237E+00, 9.5802942317E-01],
	[3.7550000000E+04, 3.0582885292E+01, 5.1619448795E+00, 1.2877551943E+01, 3.2886302215E+00, 9.5804803961E-01],
	[3.7555000000E+04, 3.0589909928E+01, 5.1619713431E+00, 1.2883127642E+01, 3.2890857086E+00, 9.5806664685E-01],
	[3.7560000000E+04, 3.0596935241E+01, 5.1619978033E+00, 1.2888705010E+01, 3.2895410850E+00, 9.5808524488E-01],
	[3.7565000000E+04, 3.0603961233E+01, 5.1620242601E+00, 1.2894284050E+01, 3.2899963509E+00, 9.5810383371E-01],
	[3.7570000000E+04, 3.0610987903E+01, 5.1620507136E+00, 1.2899864760E+01, 3.2904515062E+00, 9.5812241335E-01],
	[3.7575000000E+04, 3.0618015250E+01, 5.1620771637E+00, 1.2905447141E+01, 3.2909065509E+00, 9.5814098380E-01],
	[3.7580000000E+04, 3.0625043276E+01, 5.1621036103E+00, 1.2911031194E+01, 3.2913614850E+00, 9.5815954507E-01],
	[3.7585000000E+04, 3.0632071979E+01, 5.1621300536E+00, 1.2916616919E+01, 3.2918163086E+00, 9.5817809716E-01],
	[3.7590000000E+04, 3.0639101360E+01, 5.1621564936E+00, 1.2922204315E+01, 3.2922710217E+00, 9.5819664008E-01],
	[3.7595000000E+04, 3.0646131419E+01, 5.1621829301E+00, 1.2927793384E+01, 3.2927256243E+00, 9.5821517382E-01],
	[3.7600000000E+04, 3.0653162156E+01, 5.1622093632E+00, 1.2933384126E+01, 3.2931801163E+00, 9.5823369840E-01],
	[3.7605000000E+04, 3.0660193570E+01, 5.1622357930E+00, 1.2938976540E+01, 3.2936344979E+00, 9.5825221382E-01],
	[3.7610000000E+04, 3.0667225662E+01, 5.1622622194E+00, 1.2944570627E+01, 3.2940887690E+00, 9.5827072009E-01],
	[3.7615000000E+04, 3.0674258432E+01, 5.1622886424E+00, 1.2950166388E+01, 3.2945429297E+00, 9.5828921720E-01],
	[3.7620000000E+04, 3.0681291880E+01, 5.1623150621E+00, 1.2955763822E+01, 3.2949969799E+00, 9.5830770517E-01],
	[3.7625000000E+04, 3.0688326006E+01, 5.1623414784E+00, 1.2961362930E+01, 3.2954509197E+00, 9.5832618399E-01],
	[3.7630000000E+04, 3.0695360809E+01, 5.1623678913E+00, 1.2966963712E+01, 3.2959047491E+00, 9.5834465369E-01],
	[3.7635000000E+04, 3.0702396289E+01, 5.1623943008E+00, 1.2972566169E+01, 3.2963584680E+00, 9.5836311424E-01],
	[3.7640000000E+04, 3.0709432447E+01, 5.1624207069E+00, 1.2978170301E+01, 3.2968120767E+00, 9.5838156568E-01],
	[3.7645000000E+04, 3.0716469283E+01, 5.1624471097E+00, 1.2983776108E+01, 3.2972655749E+00, 9.5840000798E-01],
	[3.7650000000E+04, 3.0723506797E+01, 5.1624735091E+00, 1.2989383590E+01, 3.2977189628E+00, 9.5841844118E-01],
	[3.7655000000E+04, 3.0730544987E+01, 5.1624999051E+00, 1.2994992747E+01, 3.2981722403E+00, 9.5843686525E-01],
	[3.7660000000E+04, 3.0737583856E+01, 5.1625262978E+00, 1.3000603581E+01, 3.2986254076E+00, 9.5845528023E-01],
	[3.7665000000E+04, 3.0744623402E+01, 5.1625526871E+00, 1.3006216090E+01, 3.2990784645E+00, 9.5847368609E-01],
	[3.7670000000E+04, 3.0751663625E+01, 5.1625790730E+00, 1.3011830276E+01, 3.2995314111E+00, 9.5849208286E-01],
	[3.7675000000E+04, 3.0758704526E+01, 5.1626054556E+00, 1.3017446139E+01, 3.2999842475E+00, 9.5851047053E-01],
	[3.7680000000E+04, 3.0765746104E+01, 5.1626318347E+00, 1.3023063679E+01, 3.3004369736E+00, 9.5852884912E-01],
	[3.7685000000E+04, 3.0772788359E+01, 5.1626582106E+00, 1.3028682896E+01, 3.3008895894E+00, 9.5854721862E-01],
	[3.7690000000E+04, 3.0779831292E+01, 5.1626845830E+00, 1.3034303790E+01, 3.3013420950E+00, 9.5856557904E-01],
	[3.7695000000E+04, 3.0786874902E+01, 5.1627109521E+00, 1.3039926362E+01, 3.3017944904E+00, 9.5858393039E-01],
	[3.7700000000E+04, 3.0793919190E+01, 5.1627373179E+00, 1.3045550613E+01, 3.3022467756E+00, 9.5860227266E-01],
	[3.7705000000E+04, 3.0800964154E+01, 5.1627636802E+00, 1.3051176542E+01, 3.3026989507E+00, 9.5862060587E-01],
	[3.7710000000E+04, 3.0808009796E+01, 5.1627900392E+00, 1.3056804149E+01, 3.3031510155E+00, 9.5863893002E-01],
	[3.7715000000E+04, 3.0815056116E+01, 5.1628163949E+00, 1.3062433435E+01, 3.3036029702E+00, 9.5865724511E-01],
	[3.7720000000E+04, 3.0822103112E+01, 5.1628427472E+00, 1.3068064401E+01, 3.3040548147E+00, 9.5867555115E-01],
	[3.7725000000E+04, 3.0829150786E+01, 5.1628690961E+00, 1.3073697046E+01, 3.3045065492E+00, 9.5869384814E-01],
	[3.7730000000E+04, 3.0836199136E+01, 5.1628954417E+00, 1.3079331371E+01, 3.3049581735E+00, 9.5871213609E-01],
	[3.7735000000E+04, 3.0843248164E+01, 5.1629217839E+00, 1.3084967376E+01, 3.3054096877E+00, 9.5873041501E-01],
	[3.7740000000E+04, 3.0850297869E+01, 5.1629481228E+00, 1.3090605061E+01, 3.3058610918E+00, 9.5874868489E-01],
	[3.7745000000E+04, 3.0857348251E+01, 5.1629744583E+00, 1.3096244427E+01, 3.3063123859E+00, 9.5876694574E-01],
	[3.7750000000E+04, 3.0864399311E+01, 5.1630007904E+00, 1.3101885473E+01, 3.3067635699E+00, 9.5878519757E-01],
	[3.7755000000E+04, 3.0871451047E+01, 5.1630271192E+00, 1.3107528201E+01, 3.3072146439E+00, 9.5880344038E-01],
	[3.7760000000E+04, 3.0878503460E+01, 5.1630534447E+00, 1.3113172610E+01, 3.3076656079E+00, 9.5882167417E-01],
	[3.7765000000E+04, 3.0885556550E+01, 5.1630797668E+00, 1.3118818701E+01, 3.3081164619E+00, 9.5883989896E-01],
	[3.7770000000E+04, 3.0892610317E+01, 5.1631060855E+00, 1.3124466474E+01, 3.3085672058E+00, 9.5885811474E-01],
	[3.7775000000E+04, 3.0899664761E+01, 5.1631324009E+00, 1.3130115929E+01, 3.3090178399E+00, 9.5887632152E-01],
	[3.7780000000E+04, 3.0906719882E+01, 5.1631587130E+00, 1.3135767067E+01, 3.3094683639E+00, 9.5889451931E-01],
	[3.7785000000E+04, 3.0913775680E+01, 5.1631850217E+00, 1.3141419887E+01, 3.3099187780E+00, 9.5891270811E-01],
	[3.7790000000E+04, 3.0920832154E+01, 5.1632113270E+00, 1.3147074391E+01, 3.3103690822E+00, 9.5893088792E-01],
	[3.7795000000E+04, 3.0927889306E+01, 5.1632376290E+00, 1.3152730578E+01, 3.3108192765E+00, 9.5894905875E-01],
	[3.7800000000E+04, 3.0934947134E+01, 5.1632639277E+00, 1.3158388448E+01, 3.3112693608E+00, 9.5896722060E-01],
	[3.7805000000E+04, 3.0942005639E+01, 5.1632902230E+00, 1.3164048003E+01, 3.3117193353E+00, 9.5898537348E-01],
	[3.7810000000E+04, 3.0949064821E+01, 5.1633165150E+00, 1.3169709242E+01, 3.3121691999E+00, 9.5900351739E-01],
	[3.7815000000E+04, 3.0956124680E+01, 5.1633428036E+00, 1.3175372165E+01, 3.3126189547E+00, 9.5902165235E-01],
	[3.7820000000E+04, 3.0963185215E+01, 5.1633690889E+00, 1.3181036773E+01, 3.3130685997E+00, 9.5903977834E-01],
	[3.7825000000E+04, 3.0970246427E+01, 5.1633953709E+00, 1.3186703066E+01, 3.3135181348E+00, 9.5905789538E-01],
	[3.7830000000E+04, 3.0977308316E+01, 5.1634216495E+00, 1.3192371044E+01, 3.3139675601E+00, 9.5907600347E-01],
	[3.7835000000E+04, 3.0984370881E+01, 5.1634479247E+00, 1.3198040708E+01, 3.3144168756E+00, 9.5909410262E-01],
	[3.7840000000E+04, 3.0991434123E+01, 5.1634741967E+00, 1.3203712058E+01, 3.3148660814E+00, 9.5911219283E-01],
	[3.7845000000E+04, 3.0998498041E+01, 5.1635004653E+00, 1.3209385094E+01, 3.3153151774E+00, 9.5913027411E-01],
	[3.7850000000E+04, 3.1005562636E+01, 5.1635267305E+00, 1.3215059816E+01, 3.3157641636E+00, 9.5914834645E-01],
	[3.7855000000E+04, 3.1012627908E+01, 5.1635529924E+00, 1.3220736225E+01, 3.3162130401E+00, 9.5916640987E-01],
	[3.7860000000E+04, 3.1019693856E+01, 5.1635792510E+00, 1.3226414321E+01, 3.3166618070E+00, 9.5918446437E-01],
	[3.7865000000E+04, 3.1026760480E+01, 5.1636055063E+00, 1.3232094104E+01, 3.3171104641E+00, 9.5920250996E-01],
	[3.7870000000E+04, 3.1033827781E+01, 5.1636317582E+00, 1.3237775575E+01, 3.3175590115E+00, 9.5922054663E-01],
	[3.7875000000E+04, 3.1040895759E+01, 5.1636580068E+00, 1.3243458734E+01, 3.3180074493E+00, 9.5923857440E-01],
	[3.7880000000E+04, 3.1047964413E+01, 5.1636842520E+00, 1.3249143581E+01, 3.3184557774E+00, 9.5925659326E-01],
	[3.7885000000E+04, 3.1055033743E+01, 5.1637104939E+00, 1.3254830116E+01, 3.3189039959E+00, 9.5927460323E-01],
	[3.7890000000E+04, 3.1062103750E+01, 5.1637367325E+00, 1.3260518339E+01, 3.3193521048E+00, 9.5929260431E-01],
	[3.7895000000E+04, 3.1069174433E+01, 5.1637629678E+00, 1.3266208252E+01, 3.3198001040E+00, 9.5931059650E-01],
	[3.7900000000E+04, 3.1076245792E+01, 5.1637891997E+00, 1.3271899854E+01, 3.3202479937E+00, 9.5932857981E-01],
	[3.7905000000E+04, 3.1083317827E+01, 5.1638154283E+00, 1.3277593145E+01, 3.3206957738E+00, 9.5934655423E-01],
	[3.7910000000E+04, 3.1090390539E+01, 5.1638416536E+00, 1.3283288127E+01, 3.3211434444E+00, 9.5936451979E-01],
	[3.7915000000E+04, 3.1097463927E+01, 5.1638678756E+00, 1.3288984798E+01, 3.3215910054E+00, 9.5938247647E-01],
	[3.7920000000E+04, 3.1104537992E+01, 5.1638940942E+00, 1.3294683159E+01, 3.3220384569E+00, 9.5940042429E-01],
	[3.7925000000E+04, 3.1111612732E+01, 5.1639203095E+00, 1.3300383211E+01, 3.3224857989E+00, 9.5941836326E-01],
	[3.7930000000E+04, 3.1118688149E+01, 5.1639465215E+00, 1.3306084954E+01, 3.3229330314E+00, 9.5943629336E-01],
	[3.7935000000E+04, 3.1125764242E+01, 5.1639727302E+00, 1.3311788389E+01, 3.3233801544E+00, 9.5945421462E-01],
	[3.7940000000E+04, 3.1132841010E+01, 5.1639989355E+00, 1.3317493514E+01, 3.3238271679E+00, 9.5947212703E-01],
	[3.7945000000E+04, 3.1139918455E+01, 5.1640251375E+00, 1.3323200331E+01, 3.3242740720E+00, 9.5949003060E-01],
	[3.7950000000E+04, 3.1146996577E+01, 5.1640513362E+00, 1.3328908841E+01, 3.3247208667E+00, 9.5950792533E-01],
	[3.7955000000E+04, 3.1154075374E+01, 5.1640775316E+00, 1.3334619042E+01, 3.3251675520E+00, 9.5952581123E-01],
	[3.7960000000E+04, 3.1161154847E+01, 5.1641037237E+00, 1.3340330936E+01, 3.3256141278E+00, 9.5954368831E-01],
	[3.7965000000E+04, 3.1168234996E+01, 5.1641299124E+00, 1.3346044523E+01, 3.3260605943E+00, 9.5956155656E-01],
	[3.7970000000E+04, 3.1175315821E+01, 5.1641560979E+00, 1.3351759803E+01, 3.3265069514E+00, 9.5957941599E-01],
	[3.7975000000E+04, 3.1182397322E+01, 5.1641822800E+00, 1.3357476777E+01, 3.3269531992E+00, 9.5959726662E-01],
	[3.7980000000E+04, 3.1189479499E+01, 5.1642084588E+00, 1.3363195444E+01, 3.3273993376E+00, 9.5961510843E-01],
	[3.7985000000E+04, 3.1196562352E+01, 5.1642346343E+00, 1.3368915805E+01, 3.3278453667E+00, 9.5963294144E-01],
	[3.7990000000E+04, 3.1203645881E+01, 5.1642608065E+00, 1.3374637860E+01, 3.3282912865E+00, 9.5965076565E-01],
	[3.7995000000E+04, 3.1210730085E+01, 5.1642869753E+00, 1.3380361609E+01, 3.3287370970E+00, 9.5966858106E-01],
	[3.8000000000E+04, 3.1217814966E+01, 5.1643131409E+00, 1.3386087054E+01, 3.3291827983E+00, 9.5968638769E-01],
	[3.8005000000E+04, 3.1224906718E+01, 5.1643401038E+00, 1.3391814193E+01, 3.3296287935E+00, 9.5970418553E-01],
	[3.8010000000E+04, 3.1232010968E+01, 5.1643685902E+00, 1.3397543028E+01, 3.3300754490E+00, 9.5972197459E-01],
	[3.8015000000E+04, 3.1239115900E+01, 5.1643970730E+00, 1.3403273559E+01, 3.3305219955E+00, 9.5973975487E-01],
	[3.8020000000E+04, 3.1246221513E+01, 5.1644255523E+00, 1.3409005785E+01, 3.3309684332E+00, 9.5975752639E-01],
	[3.8025000000E+04, 3.1253327808E+01, 5.1644540279E+00, 1.3414739707E+01, 3.3314147621E+00, 9.5977528913E-01],
	[3.8030000000E+04, 3.1260434784E+01, 5.1644825000E+00, 1.3420475326E+01, 3.3318609822E+00, 9.5979304312E-01],
	[3.8035000000E+04, 3.1267542441E+01, 5.1645109685E+00, 1.3426212642E+01, 3.3323070935E+00, 9.5981078834E-01],
	[3.8040000000E+04, 3.1274650780E+01, 5.1645394334E+00, 1.3431951655E+01, 3.3327530960E+00, 9.5982852482E-01],
	[3.8045000000E+04, 3.1281759801E+01, 5.1645678947E+00, 1.3437692365E+01, 3.3331989898E+00, 9.5984625254E-01],
	[3.8050000000E+04, 3.1288869503E+01, 5.1645963524E+00, 1.3443434772E+01, 3.3336447748E+00, 9.5986397153E-01],
	[3.8055000000E+04, 3.1295979886E+01, 5.1646248066E+00, 1.3449178877E+01, 3.3340904511E+00, 9.5988168177E-01],
	[3.8060000000E+04, 3.1303090951E+01, 5.1646532571E+00, 1.3454924681E+01, 3.3345360187E+00, 9.5989938328E-01],
	[3.8065000000E+04, 3.1310202697E+01, 5.1646817041E+00, 1.3460672182E+01, 3.3349814775E+00, 9.5991707606E-01],
	[3.8070000000E+04, 3.1317315124E+01, 5.1647101475E+00, 1.3466421383E+01, 3.3354268277E+00, 9.5993476011E-01],
	[3.8075000000E+04, 3.1324428232E+01, 5.1647385873E+00, 1.3472172282E+01, 3.3358720693E+00, 9.5995243545E-01],
	[3.8080000000E+04, 3.1331542022E+01, 5.1647670236E+00, 1.3477924881E+01, 3.3363172022E+00, 9.5997010207E-01],
	[3.8085000000E+04, 3.1338656493E+01, 5.1647954562E+00, 1.3483679179E+01, 3.3367622264E+00, 9.5998775997E-01],
	[3.8090000000E+04, 3.1345771645E+01, 5.1648238853E+00, 1.3489435177E+01, 3.3372071421E+00, 9.6000540917E-01],
	[3.8095000000E+04, 3.1352887479E+01, 5.1648523109E+00, 1.3495192875E+01, 3.3376519491E+00, 9.6002304967E-01],
	[3.8100000000E+04, 3.1360003993E+01, 5.1648807328E+00, 1.3500952273E+01, 3.3380966476E+00, 9.6004068148E-01],
	[3.8105000000E+04, 3.1367121189E+01, 5.1649091512E+00, 1.3506713372E+01, 3.3385412375E+00, 9.6005830459E-01],
	[3.8110000000E+04, 3.1374239065E+01, 5.1649375660E+00, 1.3512476172E+01, 3.3389857188E+00, 9.6007591901E-01],
	[3.8115000000E+04, 3.1381357623E+01, 5.1649659772E+00, 1.3518240673E+01, 3.3394300916E+00, 9.6009352475E-01],
	[3.8120000000E+04, 3.1388476862E+01, 5.1649943849E+00, 1.3524006875E+01, 3.3398743559E+00, 9.6011112180E-01],
	[3.8125000000E+04, 3.1395596782E+01, 5.1650227889E+00, 1.3529774779E+01, 3.3403185116E+00, 9.6012871019E-01],
	[3.8130000000E+04, 3.1402717383E+01, 5.1650511895E+00, 1.3535544386E+01, 3.3407625589E+00, 9.6014628991E-01],
	[3.8135000000E+04, 3.1409838665E+01, 5.1650795864E+00, 1.3541315694E+01, 3.3412064978E+00, 9.6016386096E-01],
	[3.8140000000E+04, 3.1416960628E+01, 5.1651079798E+00, 1.3547088705E+01, 3.3416503281E+00, 9.6018142335E-01],
	[3.8145000000E+04, 3.1424083272E+01, 5.1651363696E+00, 1.3552863419E+01, 3.3420940500E+00, 9.6019897708E-01],
	[3.8150000000E+04, 3.1431206597E+01, 5.1651647559E+00, 1.3558639836E+01, 3.3425376635E+00, 9.6021652216E-01],
	[3.8155000000E+04, 3.1438330602E+01, 5.1651931385E+00, 1.3564417956E+01, 3.3429811686E+00, 9.6023405860E-01],
	[3.8160000000E+04, 3.1445455289E+01, 5.1652215177E+00, 1.3570197780E+01, 3.3434245653E+00, 9.6025158640E-01],
	[3.8165000000E+04, 3.1452580656E+01, 5.1652498932E+00, 1.3575979308E+01, 3.3438678536E+00, 9.6026910555E-01],
	[3.8170000000E+04, 3.1459706704E+01, 5.1652782652E+00, 1.3581762540E+01, 3.3443110336E+00, 9.6028661608E-01],
	[3.8175000000E+04, 3.1466833433E+01, 5.1653066337E+00, 1.3587547477E+01, 3.3447541052E+00, 9.6030411798E-01],
	[3.8180000000E+04, 3.1473960843E+01, 5.1653349986E+00, 1.3593334119E+01, 3.3451970685E+00, 9.6032161125E-01],
	[3.8185000000E+04, 3.1481088933E+01, 5.1653633599E+00, 1.3599122465E+01, 3.3456399234E+00, 9.6033909590E-01],
	[3.8190000000E+04, 3.1488217705E+01, 5.1653917176E+00, 1.3604912517E+01, 3.3460826701E+00, 9.6035657194E-01],
	[3.8195000000E+04, 3.1495347156E+01, 5.1654200719E+00, 1.3610704275E+01, 3.3465253085E+00, 9.6037403937E-01],
	[3.8200000000E+04, 3.1502477289E+01, 5.1654484225E+00, 1.3616497738E+01, 3.3469678387E+00, 9.6039149820E-01],
	[3.8205000000E+04, 3.1509608102E+01, 5.1654767696E+00, 1.3622292908E+01, 3.3474102605E+00, 9.6040894842E-01],
	[3.8210000000E+04, 3.1516739596E+01, 5.1655051131E+00, 1.3628089784E+01, 3.3478525742E+00, 9.6042639005E-01],
	[3.8215000000E+04, 3.1523871771E+01, 5.1655334531E+00, 1.3633888367E+01, 3.3482947796E+00, 9.6044382309E-01],
	[3.8220000000E+04, 3.1531004626E+01, 5.1655617896E+00, 1.3639688657E+01, 3.3487368769E+00, 9.6046124754E-01],
	[3.8225000000E+04, 3.1538138161E+01, 5.1655901225E+00, 1.3645490654E+01, 3.3491788659E+00, 9.6047866341E-01],
	[3.8230000000E+04, 3.1545272377E+01, 5.1656184518E+00, 1.3651294359E+01, 3.3496207468E+00, 9.6049607070E-01],
	[3.8235000000E+04, 3.1552407274E+01, 5.1656467776E+00, 1.3657099772E+01, 3.3500625196E+00, 9.6051346942E-01],
	[3.8240000000E+04, 3.1559542851E+01, 5.1656750998E+00, 1.3662906892E+01, 3.3505041842E+00, 9.6053085957E-01],
	[3.8245000000E+04, 3.1566679108E+01, 5.1657034185E+00, 1.3668715722E+01, 3.3509457407E+00, 9.6054824115E-01],
	[3.8250000000E+04, 3.1573816046E+01, 5.1657317337E+00, 1.3674526259E+01, 3.3513871891E+00, 9.6056561418E-01],
	[3.8255000000E+04, 3.1580953665E+01, 5.1657600452E+00, 1.3680338506E+01, 3.3518285294E+00, 9.6058297865E-01],
	[3.8260000000E+04, 3.1588091964E+01, 5.1657883533E+00, 1.3686152462E+01, 3.3522697617E+00, 9.6060033457E-01],
	[3.8265000000E+04, 3.1595230943E+01, 5.1658166578E+00, 1.3691968128E+01, 3.3527108859E+00, 9.6061768195E-01],
	[3.8270000000E+04, 3.1602370602E+01, 5.1658449588E+00, 1.3697785503E+01, 3.3531519020E+00, 9.6063502078E-01],
	[3.8275000000E+04, 3.1609510942E+01, 5.1658732562E+00, 1.3703604589E+01, 3.3535928102E+00, 9.6065235108E-01],
	[3.8280000000E+04, 3.1616651962E+01, 5.1659015501E+00, 1.3709425385E+01, 3.3540336103E+00, 9.6066967284E-01],
	[3.8285000000E+04, 3.1623793662E+01, 5.1659298404E+00, 1.3715247891E+01, 3.3544743024E+00, 9.6068698608E-01],
	[3.8290000000E+04, 3.1630936043E+01, 5.1659581272E+00, 1.3721072109E+01, 3.3549148866E+00, 9.6070429080E-01],
	[3.8295000000E+04, 3.1638079104E+01, 5.1659864105E+00, 1.3726898038E+01, 3.3553553629E+00, 9.6072158700E-01],
	[3.8300000000E+04, 3.1645222845E+01, 5.1660146902E+00, 1.3732725678E+01, 3.3557957311E+00, 9.6073887468E-01],
	[3.8305000000E+04, 3.1652367266E+01, 5.1660429664E+00, 1.3738555030E+01, 3.3562359915E+00, 9.6075615386E-01],
	[3.8310000000E+04, 3.1659512367E+01, 5.1660712390E+00, 1.3744386093E+01, 3.3566761440E+00, 9.6077342453E-01],
	[3.8315000000E+04, 3.1666658148E+01, 5.1660995082E+00, 1.3750218870E+01, 3.3571161886E+00, 9.6079068670E-01],
	[3.8320000000E+04, 3.1673804610E+01, 5.1661277737E+00, 1.3756053359E+01, 3.3575561253E+00, 9.6080794038E-01],
	[3.8325000000E+04, 3.1680951752E+01, 5.1661560358E+00, 1.3761889560E+01, 3.3579959541E+00, 9.6082518556E-01],
	[3.8330000000E+04, 3.1688099573E+01, 5.1661842943E+00, 1.3767727475E+01, 3.3584356751E+00, 9.6084242226E-01],
	[3.8335000000E+04, 3.1695248075E+01, 5.1662125493E+00, 1.3773567103E+01, 3.3588752883E+00, 9.6085965048E-01],
	[3.8340000000E+04, 3.1702397256E+01, 5.1662408008E+00, 1.3779408445E+01, 3.3593147937E+00, 9.6087687022E-01],
	[3.8345000000E+04, 3.1709547118E+01, 5.1662690487E+00, 1.3785251501E+01, 3.3597541913E+00, 9.6089408148E-01],
	[3.8350000000E+04, 3.1716697660E+01, 5.1662972931E+00, 1.3791096272E+01, 3.3601934812E+00, 9.6091128428E-01],
	[3.8355000000E+04, 3.1723848881E+01, 5.1663255339E+00, 1.3796942757E+01, 3.3606326632E+00, 9.6092847862E-01],
	[3.8360000000E+04, 3.1731000782E+01, 5.1663537713E+00, 1.3802790956E+01, 3.3610717376E+00, 9.6094566450E-01],
	[3.8365000000E+04, 3.1738153364E+01, 5.1663820051E+00, 1.3808640871E+01, 3.3615107042E+00, 9.6096284192E-01],
	[3.8370000000E+04, 3.1745306625E+01, 5.1664102354E+00, 1.3814492501E+01, 3.3619495631E+00, 9.6098001089E-01],
	[3.8375000000E+04, 3.1752460566E+01, 5.1664384622E+00, 1.3820345847E+01, 3.3623883143E+00, 9.6099717142E-01],
	[3.8380000000E+04, 3.1759615187E+01, 5.1664666854E+00, 1.3826200909E+01, 3.3628269578E+00, 9.6101432351E-01],
	[3.8385000000E+04, 3.1766770487E+01, 5.1664949051E+00, 1.3832057687E+01, 3.3632654937E+00, 9.6103146716E-01],
	[3.8390000000E+04, 3.1773926467E+01, 5.1665231213E+00, 1.3837916181E+01, 3.3637039220E+00, 9.6104860237E-01],
	[3.8395000000E+04, 3.1781083128E+01, 5.1665513340E+00, 1.3843776392E+01, 3.3641422426E+00, 9.6106572916E-01],
	[3.8400000000E+04, 3.1788240467E+01, 5.1665795432E+00, 1.3849638320E+01, 3.3645804556E+00, 9.6108284752E-01],
	[3.8405000000E+04, 3.1795398487E+01, 5.1666077488E+00, 1.3855501966E+01, 3.3650185611E+00, 9.6109995746E-01],
	[3.8410000000E+04, 3.1802557186E+01, 5.1666359509E+00, 1.3861367329E+01, 3.3654565589E+00, 9.6111705899E-01],
	[3.8415000000E+04, 3.1809716565E+01, 5.1666641495E+00, 1.3867234410E+01, 3.3658944492E+00, 9.6113415210E-01],
	[3.8420000000E+04, 3.1816876623E+01, 5.1666923446E+00, 1.3873103210E+01, 3.3663322320E+00, 9.6115123681E-01],
	[3.8425000000E+04, 3.1824037361E+01, 5.1667205362E+00, 1.3878973728E+01, 3.3667699072E+00, 9.6116831311E-01],
	[3.8430000000E+04, 3.1831198778E+01, 5.1667487243E+00, 1.3884845964E+01, 3.3672074750E+00, 9.6118538101E-01],
	[3.8435000000E+04, 3.1838360876E+01, 5.1667769088E+00, 1.3890719919E+01, 3.3676449352E+00, 9.6120244052E-01],
	[3.8440000000E+04, 3.1845523652E+01, 5.1668050898E+00, 1.3896595594E+01, 3.3680822880E+00, 9.6121949164E-01],
	[3.8445000000E+04, 3.1852687108E+01, 5.1668332674E+00, 1.3902472989E+01, 3.3685195333E+00, 9.6123653436E-01],
	[3.8450000000E+04, 3.1859851244E+01, 5.1668614414E+00, 1.3908352103E+01, 3.3689566712E+00, 9.6125356871E-01],
	[3.8455000000E+04, 3.1867016059E+01, 5.1668896119E+00, 1.3914232937E+01, 3.3693937017E+00, 9.6127059468E-01],
	[3.8460000000E+04, 3.1874181553E+01, 5.1669177789E+00, 1.3920115492E+01, 3.3698306247E+00, 9.6128761227E-01],
	[3.8465000000E+04, 3.1881347727E+01, 5.1669459423E+00, 1.3925999767E+01, 3.3702674404E+00, 9.6130462149E-01],
	[3.8470000000E+04, 3.1888514580E+01, 5.1669741023E+00, 1.3931885764E+01, 3.3707041487E+00, 9.6132162235E-01],
	[3.8475000000E+04, 3.1895682113E+01, 5.1670022588E+00, 1.3937773481E+01, 3.3711407496E+00, 9.6133861484E-01],
	[3.8480000000E+04, 3.1902850325E+01, 5.1670304118E+00, 1.3943662920E+01, 3.3715772432E+00, 9.6135559898E-01],
	[3.8485000000E+04, 3.1910019216E+01, 5.1670585612E+00, 1.3949554081E+01, 3.3720136295E+00, 9.6137257476E-01],
	[3.8490000000E+04, 3.1917188786E+01, 5.1670867072E+00, 1.3955446964E+01, 3.3724499085E+00, 9.6138954219E-01],
	[3.8495000000E+04, 3.1924359036E+01, 5.1671148496E+00, 1.3961341570E+01, 3.3728860802E+00, 9.6140650128E-01],
	[3.8500000000E+04, 3.1931529965E+01, 5.1671429886E+00, 1.3967237898E+01, 3.3733221446E+00, 9.6142345203E-01],
	[3.8505000000E+04, 3.1938701573E+01, 5.1671711240E+00, 1.3973135949E+01, 3.3737581018E+00, 9.6144039444E-01],
	[3.8510000000E+04, 3.1945873861E+01, 5.1671992560E+00, 1.3979035723E+01, 3.3741939517E+00, 9.6145732851E-01],
	[3.8515000000E+04, 3.1953046827E+01, 5.1672273844E+00, 1.3984937220E+01, 3.3746296944E+00, 9.6147425426E-01],
	[3.8520000000E+04, 3.1960220473E+01, 5.1672555094E+00, 1.3990840442E+01, 3.3750653299E+00, 9.6149117168E-01],
	[3.8525000000E+04, 3.1967394797E+01, 5.1672836308E+00, 1.3996745387E+01, 3.3755008582E+00, 9.6150808079E-01],
	[3.8530000000E+04, 3.1974569801E+01, 5.1673117488E+00, 1.4002652057E+01, 3.3759362794E+00, 9.6152498157E-01],
	[3.8535000000E+04, 3.1981745484E+01, 5.1673398633E+00, 1.4008560451E+01, 3.3763715934E+00, 9.6154187405E-01],
	[3.8540000000E+04, 3.1988921846E+01, 5.1673679742E+00, 1.4014470570E+01, 3.3768068003E+00, 9.6155875821E-01],
	[3.8545000000E+04, 3.1996098887E+01, 5.1673960817E+00, 1.4020382415E+01, 3.3772419000E+00, 9.6157563408E-01],
	[3.8550000000E+04, 3.2003276607E+01, 5.1674241857E+00, 1.4026295984E+01, 3.3776768927E+00, 9.6159250164E-01],
	[3.8555000000E+04, 3.2010455006E+01, 5.1674522862E+00, 1.4032211280E+01, 3.3781117782E+00, 9.6160936091E-01],
	[3.8560000000E+04, 3.2017634084E+01, 5.1674803832E+00, 1.4038128301E+01, 3.3785465567E+00, 9.6162621189E-01],
	[3.8565000000E+04, 3.2024813841E+01, 5.1675084767E+00, 1.4044047049E+01, 3.3789812282E+00, 9.6164305458E-01],
	[3.8570000000E+04, 3.2031994277E+01, 5.1675365667E+00, 1.4049967523E+01, 3.3794157926E+00, 9.6165988898E-01],
	[3.8575000000E+04, 3.2039175391E+01, 5.1675646533E+00, 1.4055889724E+01, 3.3798502500E+00, 9.6167671511E-01],
	[3.8580000000E+04, 3.2046357185E+01, 5.1675927363E+00, 1.4061813652E+01, 3.3802846004E+00, 9.6169353296E-01],
	[3.8585000000E+04, 3.2053539657E+01, 5.1676208159E+00, 1.4067739308E+01, 3.3807188438E+00, 9.6171034255E-01],
	[3.8590000000E+04, 3.2060722808E+01, 5.1676488919E+00, 1.4073666691E+01, 3.3811529803E+00, 9.6172714386E-01],
	[3.8595000000E+04, 3.2067906638E+01, 5.1676769645E+00, 1.4079595802E+01, 3.3815870098E+00, 9.6174393692E-01],
	[3.8600000000E+04, 3.2075091146E+01, 5.1677050336E+00, 1.4085526642E+01, 3.3820209324E+00, 9.6176072172E-01],
	[3.8605000000E+04, 3.2082276334E+01, 5.1677330992E+00, 1.4091459210E+01, 3.3824547480E+00, 9.6177749826E-01],
	[3.8610000000E+04, 3.2089462200E+01, 5.1677611614E+00, 1.4097393506E+01, 3.3828884568E+00, 9.6179426655E-01],
	[3.8615000000E+04, 3.2096648745E+01, 5.1677892200E+00, 1.4103329532E+01, 3.3833220587E+00, 9.6181102660E-01],
	[3.8620000000E+04, 3.2103853470E+01, 5.1678195160E+00, 1.4109267287E+01, 3.3837567089E+00, 9.6182777841E-01],
	[3.8625000000E+04, 3.2111059169E+01, 5.1678498452E+00, 1.4115206772E+01, 3.3841912716E+00, 9.6184452198E-01],
	[3.8630000000E+04, 3.2118265552E+01, 5.1678801707E+00, 1.4121147986E+01, 3.3846257279E+00, 9.6186125732E-01],
	[3.8635000000E+04, 3.2125472619E+01, 5.1679104924E+00, 1.4127090931E+01, 3.3850600777E+00, 9.6187798442E-01],
	[3.8640000000E+04, 3.2132680370E+01, 5.1679408104E+00, 1.4133035606E+01, 3.3854943210E+00, 9.6189470331E-01],
	[3.8645000000E+04, 3.2139888806E+01, 5.1679711246E+00, 1.4138982012E+01, 3.3859284579E+00, 9.6191141397E-01],
	[3.8650000000E+04, 3.2147097926E+01, 5.1680014351E+00, 1.4144930149E+01, 3.3863624885E+00, 9.6192811642E-01],
	[3.8655000000E+04, 3.2154307730E+01, 5.1680317419E+00, 1.4150880018E+01, 3.3867964126E+00, 9.6194481065E-01],
	[3.8660000000E+04, 3.2161518218E+01, 5.1680620449E+00, 1.4156831617E+01, 3.3872302304E+00, 9.6196149668E-01],
	[3.8665000000E+04, 3.2168729390E+01, 5.1680923442E+00, 1.4162784949E+01, 3.3876639417E+00, 9.6197817450E-01],
	[3.8670000000E+04, 3.2175941246E+01, 5.1681226397E+00, 1.4168740013E+01, 3.3880975468E+00, 9.6199484412E-01],
	[3.8675000000E+04, 3.2183153787E+01, 5.1681529315E+00, 1.4174696809E+01, 3.3885310455E+00, 9.6201150555E-01],
	[3.8680000000E+04, 3.2190367011E+01, 5.1681832195E+00, 1.4180655338E+01, 3.3889644380E+00, 9.6202815878E-01],
	[3.8685000000E+04, 3.2197580920E+01, 5.1682135038E+00, 1.4186615600E+01, 3.3893977241E+00, 9.6204480383E-01],
	[3.8690000000E+04, 3.2204795512E+01, 5.1682437844E+00, 1.4192577595E+01, 3.3898309040E+00, 9.6206144070E-01],
	[3.8695000000E+04, 3.2212010789E+01, 5.1682740612E+00, 1.4198541324E+01, 3.3902639776E+00, 9.6207806938E-01],
	[3.8700000000E+04, 3.2219226749E+01, 5.1683043344E+00, 1.4204506786E+01, 3.3906969450E+00, 9.6209468989E-01],
	[3.8705000000E+04, 3.2226443394E+01, 5.1683346037E+00, 1.4210473983E+01, 3.3911298061E+00, 9.6211130223E-01],
	[3.8710000000E+04, 3.2233660722E+01, 5.1683648694E+00, 1.4216442914E+01, 3.3915625611E+00, 9.6212790641E-01],
	[3.8715000000E+04, 3.2240878734E+01, 5.1683951313E+00, 1.4222413579E+01, 3.3919952098E+00, 9.6214450242E-01],
	[3.8720000000E+04, 3.2248097430E+01, 5.1684253894E+00, 1.4228385980E+01, 3.3924277524E+00, 9.6216109027E-01],
	[3.8725000000E+04, 3.2255316810E+01, 5.1684556439E+00, 1.4234360116E+01, 3.3928601888E+00, 9.6217766997E-01],
	[3.8730000000E+04, 3.2262536874E+01, 5.1684858946E+00, 1.4240335987E+01, 3.3932925192E+00, 9.6219424152E-01],
	[3.8735000000E+04, 3.2269757621E+01, 5.1685161416E+00, 1.4246313594E+01, 3.3937247433E+00, 9.6221080492E-01],
	[3.8740000000E+04, 3.2276979053E+01, 5.1685463849E+00, 1.4252292937E+01, 3.3941568614E+00, 9.6222736018E-01],
	[3.8745000000E+04, 3.2284201168E+01, 5.1685766244E+00, 1.4258274016E+01, 3.3945888734E+00, 9.6224390730E-01],
	[3.8750000000E+04, 3.2291423966E+01, 5.1686068602E+00, 1.4264256832E+01, 3.3950207794E+00, 9.6226044629E-01],
	[3.8755000000E+04, 3.2298647449E+01, 5.1686370923E+00, 1.4270241385E+01, 3.3954525793E+00, 9.6227697715E-01],
	[3.8760000000E+04, 3.2305871615E+01, 5.1686673206E+00, 1.4276227675E+01, 3.3958842731E+00, 9.6229349989E-01],
	[3.8765000000E+04, 3.2313096465E+01, 5.1686975453E+00, 1.4282215702E+01, 3.3963158610E+00, 9.6231001450E-01],
	[3.8770000000E+04, 3.2320321998E+01, 5.1687277662E+00, 1.4288205468E+01, 3.3967473428E+00, 9.6232652100E-01],
	[3.8775000000E+04, 3.2327548215E+01, 5.1687579834E+00, 1.4294196971E+01, 3.3971787187E+00, 9.6234301938E-01],
	[3.8780000000E+04, 3.2334775116E+01, 5.1687881969E+00, 1.4300190212E+01, 3.3976099886E+00, 9.6235950966E-01],
	[3.8785000000E+04, 3.2342002700E+01, 5.1688184066E+00, 1.4306185192E+01, 3.3980411525E+00, 9.6237599183E-01],
	[3.8790000000E+04, 3.2349230967E+01, 5.1688486127E+00, 1.4312181911E+01, 3.3984722106E+00, 9.6239246590E-01],
	[3.8795000000E+04, 3.2356459919E+01, 5.1688788150E+00, 1.4318180369E+01, 3.3989031627E+00, 9.6240893188E-01],
	[3.8800000000E+04, 3.2363689553E+01, 5.1689090136E+00, 1.4324180566E+01, 3.3993340089E+00, 9.6242538976E-01],
	[3.8805000000E+04, 3.2370919871E+01, 5.1689392085E+00, 1.4330182504E+01, 3.3997647492E+00, 9.6244183955E-01],
	[3.8810000000E+04, 3.2378150873E+01, 5.1689693997E+00, 1.4336186181E+01, 3.4001953837E+00, 9.6245828126E-01],
	[3.8815000000E+04, 3.2385382558E+01, 5.1689995872E+00, 1.4342191598E+01, 3.4006259124E+00, 9.6247471490E-01],
	[3.8820000000E+04, 3.2392614926E+01, 5.1690297709E+00, 1.4348198756E+01, 3.4010563352E+00, 9.6249114045E-01],
	[3.8825000000E+04, 3.2399847978E+01, 5.1690599509E+00, 1.4354207654E+01, 3.4014866522E+00, 9.6250755793E-01],
	[3.8830000000E+04, 3.2407081713E+01, 5.1690901273E+00, 1.4360218294E+01, 3.4019168635E+00, 9.6252396735E-01],
	[3.8835000000E+04, 3.2414316131E+01, 5.1691202999E+00, 1.4366230675E+01, 3.4023469689E+00, 9.6254036870E-01],
	[3.8840000000E+04, 3.2421551233E+01, 5.1691504688E+00, 1.4372244797E+01, 3.4027769686E+00, 9.6255676200E-01],
	[3.8845000000E+04, 3.2428787018E+01, 5.1691806340E+00, 1.4378260662E+01, 3.4032068626E+00, 9.6257314724E-01],
	[3.8850000000E+04, 3.2436023486E+01, 5.1692107955E+00, 1.4384278269E+01, 3.4036366509E+00, 9.6258952443E-01],
	[3.8855000000E+04, 3.2443260638E+01, 5.1692409533E+00, 1.4390297618E+01, 3.4040663334E+00, 9.6260589357E-01],
	[3.8860000000E+04, 3.2450498472E+01, 5.1692711074E+00, 1.4396318710E+01, 3.4044959103E+00, 9.6262225467E-01],
	[3.8865000000E+04, 3.2457736990E+01, 5.1693012578E+00, 1.4402341545E+01, 3.4049253815E+00, 9.6263860773E-01],
	[3.8870000000E+04, 3.2464976191E+01, 5.1693314045E+00, 1.4408366123E+01, 3.4053547470E+00, 9.6265495275E-01],
	[3.8875000000E+04, 3.2472216075E+01, 5.1693615475E+00, 1.4414392445E+01, 3.4057840069E+00, 9.6267128975E-01],
	[3.8880000000E+04, 3.2479456642E+01, 5.1693916868E+00, 1.4420420511E+01, 3.4062131612E+00, 9.6268761872E-01],
	[3.8885000000E+04, 3.2486697893E+01, 5.1694218223E+00, 1.4426450321E+01, 3.4066422099E+00, 9.6270393967E-01],
	[3.8890000000E+04, 3.2493939826E+01, 5.1694519542E+00, 1.4432481876E+01, 3.4070711531E+00, 9.6272025260E-01],
	[3.8895000000E+04, 3.2501182443E+01, 5.1694820824E+00, 1.4438515175E+01, 3.4074999906E+00, 9.6273655751E-01],
	[3.8900000000E+04, 3.2508425742E+01, 5.1695122069E+00, 1.4444550219E+01, 3.4079287226E+00, 9.6275285442E-01],
	[3.8905000000E+04, 3.2515669725E+01, 5.1695423277E+00, 1.4450587008E+01, 3.4083573491E+00, 9.6276914332E-01],
	[3.8910000000E+04, 3.2522914390E+01, 5.1695724448E+00, 1.4456625543E+01, 3.4087858701E+00, 9.6278542422E-01],
	[3.8915000000E+04, 3.2530159738E+01, 5.1696025582E+00, 1.4462665824E+01, 3.4092142856E+00, 9.6280169712E-01],
	[3.8920000000E+04, 3.2537405770E+01, 5.1696326679E+00, 1.4468707851E+01, 3.4096425956E+00, 9.6281796203E-01],
	[3.8925000000E+04, 3.2544652484E+01, 5.1696627739E+00, 1.4474751624E+01, 3.4100708002E+00, 9.6283421895E-01],
	[3.8930000000E+04, 3.2551899881E+01, 5.1696928762E+00, 1.4480797144E+01, 3.4104988993E+00, 9.6285046788E-01],
	[3.8935000000E+04, 3.2559147961E+01, 5.1697229749E+00, 1.4486844411E+01, 3.4109268930E+00, 9.6286670884E-01],
	[3.8940000000E+04, 3.2566396723E+01, 5.1697530698E+00, 1.4492893425E+01, 3.4113547813E+00, 9.6288294181E-01],
	[3.8945000000E+04, 3.2573646169E+01, 5.1697831611E+00, 1.4498944187E+01, 3.4117825642E+00, 9.6289916682E-01],
	[3.8950000000E+04, 3.2580896297E+01, 5.1698132486E+00, 1.4504996696E+01, 3.4122102417E+00, 9.6291538385E-01],
	[3.8955000000E+04, 3.2588147108E+01, 5.1698433325E+00, 1.4511050954E+01, 3.4126378139E+00, 9.6293159293E-01],
	[3.8960000000E+04, 3.2595398602E+01, 5.1698734127E+00, 1.4517106960E+01, 3.4130652808E+00, 9.6294779404E-01],
	[3.8965000000E+04, 3.2602650779E+01, 5.1699034892E+00, 1.4523164714E+01, 3.4134926423E+00, 9.6296398719E-01],
	[3.8970000000E+04, 3.2609903638E+01, 5.1699335620E+00, 1.4529224218E+01, 3.4139198986E+00, 9.6298017239E-01],
	[3.8975000000E+04, 3.2617157180E+01, 5.1699636312E+00, 1.4535285470E+01, 3.4143470495E+00, 9.6299634965E-01],
	[3.8980000000E+04, 3.2624411405E+01, 5.1699936966E+00, 1.4541348472E+01, 3.4147740952E+00, 9.6301251896E-01],
	[3.8985000000E+04, 3.2631666312E+01, 5.1700237584E+00, 1.4547413224E+01, 3.4152010357E+00, 9.6302868033E-01],
	[3.8990000000E+04, 3.2638921901E+01, 5.1700538165E+00, 1.4553479726E+01, 3.4156278709E+00, 9.6304483377E-01],
	[3.8995000000E+04, 3.2646178174E+01, 5.1700838709E+00, 1.4559547978E+01, 3.4160546009E+00, 9.6306097927E-01],
	[3.9000000000E+04, 3.2653435129E+01, 5.1701139217E+00, 1.4565617981E+01, 3.4164812258E+00, 9.6307711685E-01],
	[3.9005000000E+04, 3.2660692766E+01, 5.1701439687E+00, 1.4571689735E+01, 3.4169077454E+00, 9.6309324650E-01],
	[3.9010000000E+04, 3.2667951086E+01, 5.1701740121E+00, 1.4577763240E+01, 3.4173341599E+00, 9.6310936823E-01],
	[3.9015000000E+04, 3.2675210088E+01, 5.1702040518E+00, 1.4583838496E+01, 3.4177604693E+00, 9.6312548205E-01],
	[3.9020000000E+04, 3.2682469773E+01, 5.1702340878E+00, 1.4589915504E+01, 3.4181866735E+00, 9.6314158796E-01],
	[3.9025000000E+04, 3.2689730141E+01, 5.1702641202E+00, 1.4595994264E+01, 3.4186127726E+00, 9.6315768596E-01],
	[3.9030000000E+04, 3.2696991190E+01, 5.1702941489E+00, 1.4602074776E+01, 3.4190387667E+00, 9.6317377606E-01],
	[3.9035000000E+04, 3.2704252922E+01, 5.1703241739E+00, 1.4608157041E+01, 3.4194646557E+00, 9.6318985825E-01],
	[3.9040000000E+04, 3.2711515337E+01, 5.1703541952E+00, 1.4614241059E+01, 3.4198904396E+00, 9.6320593256E-01],
	[3.9045000000E+04, 3.2718778434E+01, 5.1703842129E+00, 1.4620326829E+01, 3.4203161185E+00, 9.6322199897E-01],
	[3.9050000000E+04, 3.2726042213E+01, 5.1704142269E+00, 1.4626414354E+01, 3.4207416924E+00, 9.6323805750E-01],
	[3.9055000000E+04, 3.2733306674E+01, 5.1704442372E+00, 1.4632503631E+01, 3.4211671613E+00, 9.6325410814E-01],
	[3.9060000000E+04, 3.2740571818E+01, 5.1704742439E+00, 1.4638594663E+01, 3.4215925252E+00, 9.6327015091E-01],
	[3.9065000000E+04, 3.2747837644E+01, 5.1705042469E+00, 1.4644687449E+01, 3.4220177842E+00, 9.6328618580E-01],
	[3.9070000000E+04, 3.2755104152E+01, 5.1705342462E+00, 1.4650781990E+01, 3.4224429382E+00, 9.6330221282E-01],
	[3.9075000000E+04, 3.2762371342E+01, 5.1705642419E+00, 1.4656878285E+01, 3.4228679872E+00, 9.6331823197E-01],
	[3.9080000000E+04, 3.2769639215E+01, 5.1705942339E+00, 1.4662976335E+01, 3.4232929314E+00, 9.6333424327E-01],
	[3.9085000000E+04, 3.2776907769E+01, 5.1706242223E+00, 1.4669076141E+01, 3.4237177707E+00, 9.6335024670E-01],
	[3.9090000000E+04, 3.2784177006E+01, 5.1706542069E+00, 1.4675177702E+01, 3.4241425051E+00, 9.6336624228E-01],
	[3.9095000000E+04, 3.2791446925E+01, 5.1706841879E+00, 1.4681281020E+01, 3.4245671347E+00, 9.6338223001E-01],
	[3.9100000000E+04, 3.2798717526E+01, 5.1707141653E+00, 1.4687386093E+01, 3.4249916594E+00, 9.6339820990E-01],
	[3.9105000000E+04, 3.2805988809E+01, 5.1707441390E+00, 1.4693492923E+01, 3.4254160794E+00, 9.6341418194E-01],
	[3.9110000000E+04, 3.2813260774E+01, 5.1707741090E+00, 1.4699601510E+01, 3.4258403945E+00, 9.6343014615E-01],
	[3.9115000000E+04, 3.2820533421E+01, 5.1708040754E+00, 1.4705711854E+01, 3.4262646048E+00, 9.6344610252E-01],
	[3.9120000000E+04, 3.2827806751E+01, 5.1708340382E+00, 1.4711823955E+01, 3.4266887104E+00, 9.6346205106E-01],
	[3.9125000000E+04, 3.2835080762E+01, 5.1708639972E+00, 1.4717937813E+01, 3.4271127112E+00, 9.6347799178E-01],
	[3.9130000000E+04, 3.2842355455E+01, 5.1708939526E+00, 1.4724053430E+01, 3.4275366073E+00, 9.6349392468E-01],
	[3.9135000000E+04, 3.2849630830E+01, 5.1709239044E+00, 1.4730170805E+01, 3.4279603987E+00, 9.6350984976E-01],
	[3.9140000000E+04, 3.2856906886E+01, 5.1709538525E+00, 1.4736289938E+01, 3.4283840854E+00, 9.6352576702E-01],
	[3.9145000000E+04, 3.2864183625E+01, 5.1709837970E+00, 1.4742410830E+01, 3.4288076674E+00, 9.6354167648E-01],
	[3.9150000000E+04, 3.2871461046E+01, 5.1710137378E+00, 1.4748533480E+01, 3.4292311448E+00, 9.6355757813E-01],
	[3.9155000000E+04, 3.2878739148E+01, 5.1710436749E+00, 1.4754657890E+01, 3.4296545175E+00, 9.6357347198E-01],
	[3.9160000000E+04, 3.2886017932E+01, 5.1710736084E+00, 1.4760784060E+01, 3.4300777856E+00, 9.6358935804E-01],
	[3.9165000000E+04, 3.2893297398E+01, 5.1711035383E+00, 1.4766911990E+01, 3.4305009491E+00, 9.6360523630E-01],
	[3.9170000000E+04, 3.2900577546E+01, 5.1711334645E+00, 1.4773041679E+01, 3.4309240081E+00, 9.6362110677E-01],
	[3.9175000000E+04, 3.2907858376E+01, 5.1711633870E+00, 1.4779173129E+01, 3.4313469624E+00, 9.6363696946E-01],
	[3.9180000000E+04, 3.2915139887E+01, 5.1711933060E+00, 1.4785306340E+01, 3.4317698122E+00, 9.6365282437E-01],
	[3.9185000000E+04, 3.2922422080E+01, 5.1712232212E+00, 1.4791441312E+01, 3.4321925575E+00, 9.6366867150E-01],
	[3.9190000000E+04, 3.2929704954E+01, 5.1712531329E+00, 1.4797578045E+01, 3.4326151983E+00, 9.6368451086E-01],
	[3.9195000000E+04, 3.2936988510E+01, 5.1712830408E+00, 1.4803716539E+01, 3.4330377346E+00, 9.6370034245E-01],
	[3.9200000000E+04, 3.2944272748E+01, 5.1713129452E+00, 1.4809856795E+01, 3.4334601664E+00, 9.6371616627E-01],
	[3.9205000000E+04, 3.2951557668E+01, 5.1713428459E+00, 1.4815998814E+01, 3.4338824937E+00, 9.6373198234E-01],
	[3.9210000000E+04, 3.2958843269E+01, 5.1713727429E+00, 1.4822142594E+01, 3.4343047166E+00, 9.6374779065E-01],
	[3.9215000000E+04, 3.2966129551E+01, 5.1714026364E+00, 1.4828288138E+01, 3.4347268351E+00, 9.6376359121E-01],
	[3.9220000000E+04, 3.2973416515E+01, 5.1714325262E+00, 1.4834435444E+01, 3.4351488492E+00, 9.6377938402E-01],
	[3.9225000000E+04, 3.2980704161E+01, 5.1714624123E+00, 1.4840584513E+01, 3.4355707589E+00, 9.6379516908E-01],
	[3.9230000000E+04, 3.2987992488E+01, 5.1714922948E+00, 1.4846735346E+01, 3.4359925643E+00, 9.6381094641E-01],
	[3.9235000000E+04, 3.2995281497E+01, 5.1715221737E+00, 1.4852887943E+01, 3.4364142652E+00, 9.6382671600E-01],
	[3.9240000000E+04, 3.3002582665E+01, 5.1715535061E+00, 1.4859042304E+01, 3.4368366300E+00, 9.6384247786E-01],
	[3.9245000000E+04, 3.3009890599E+01, 5.1715856067E+00, 1.4865198429E+01, 3.4372592975E+00, 9.6385823199E-01],
	[3.9250000000E+04, 3.3017199221E+01, 5.1716177033E+00, 1.4871356318E+01, 3.4376818611E+00, 9.6387397839E-01],
	[3.9255000000E+04, 3.3024508529E+01, 5.1716497961E+00, 1.4877515973E+01, 3.4381043207E+00, 9.6388971708E-01],
	[3.9260000000E+04, 3.3031818524E+01, 5.1716818849E+00, 1.4883677393E+01, 3.4385266764E+00, 9.6390544805E-01],
	[3.9265000000E+04, 3.3039129206E+01, 5.1717139699E+00, 1.4889840578E+01, 3.4389489282E+00, 9.6392117131E-01],
	[3.9270000000E+04, 3.3046440575E+01, 5.1717460510E+00, 1.4896005529E+01, 3.4393710761E+00, 9.6393688686E-01],
	[3.9275000000E+04, 3.3053752631E+01, 5.1717781282E+00, 1.4902172245E+01, 3.4397931202E+00, 9.6395259471E-01],
	[3.9280000000E+04, 3.3061065373E+01, 5.1718102016E+00, 1.4908340729E+01, 3.4402150603E+00, 9.6396829486E-01],
	[3.9285000000E+04, 3.3068378802E+01, 5.1718422710E+00, 1.4914510978E+01, 3.4406368967E+00, 9.6398398731E-01],
	[3.9290000000E+04, 3.3075692918E+01, 5.1718743366E+00, 1.4920682995E+01, 3.4410586292E+00, 9.6399967207E-01],
	[3.9295000000E+04, 3.3083007721E+01, 5.1719063982E+00, 1.4926856779E+01, 3.4414802579E+00, 9.6401534914E-01],
	[3.9300000000E+04, 3.3090323210E+01, 5.1719384560E+00, 1.4933032330E+01, 3.4419017829E+00, 9.6403101854E-01],
	[3.9305000000E+04, 3.3097639386E+01, 5.1719705100E+00, 1.4939209649E+01, 3.4423232041E+00, 9.6404668025E-01],
	[3.9310000000E+04, 3.3104956249E+01, 5.1720025600E+00, 1.4945388735E+01, 3.4427445215E+00, 9.6406233428E-01],
	[3.9315000000E+04, 3.3112273798E+01, 5.1720346062E+00, 1.4951569590E+01, 3.4431657352E+00, 9.6407798065E-01],
	[3.9320000000E+04, 3.3119592034E+01, 5.1720666484E+00, 1.4957752214E+01, 3.4435868452E+00, 9.6409361935E-01],
	[3.9325000000E+04, 3.3126910957E+01, 5.1720986868E+00, 1.4963936606E+01, 3.4440078515E+00, 9.6410925038E-01],
	[3.9330000000E+04, 3.3134230566E+01, 5.1721307214E+00, 1.4970122768E+01, 3.4444287542E+00, 9.6412487376E-01],
	[3.9335000000E+04, 3.3141550861E+01, 5.1721627520E+00, 1.4976310699E+01, 3.4448495532E+00, 9.6414048948E-01],
	[3.9340000000E+04, 3.3148871843E+01, 5.1721947788E+00, 1.4982500399E+01, 3.4452702485E+00, 9.6415609755E-01],
	[3.9345000000E+04, 3.3156193512E+01, 5.1722268017E+00, 1.4988691870E+01, 3.4456908402E+00, 9.6417169797E-01],
	[3.9350000000E+04, 3.3163515867E+01, 5.1722588208E+00, 1.4994885110E+01, 3.4461113284E+00, 9.6418729075E-01],
	[3.9355000000E+04, 3.3170838908E+01, 5.1722908360E+00, 1.5001080121E+01, 3.4465317129E+00, 9.6420287589E-01],
	[3.9360000000E+04, 3.3178162636E+01, 5.1723228473E+00, 1.5007276903E+01, 3.4469519939E+00, 9.6421845340E-01],
	[3.9365000000E+04, 3.3185487050E+01, 5.1723548547E+00, 1.5013475456E+01, 3.4473721713E+00, 9.6423402327E-01],
	[3.9370000000E+04, 3.3192812151E+01, 5.1723868583E+00, 1.5019675781E+01, 3.4477922452E+00, 9.6424958552E-01],
	[3.9375000000E+04, 3.3200137938E+01, 5.1724188580E+00, 1.5025877876E+01, 3.4482122156E+00, 9.6426514015E-01],
	[3.9380000000E+04, 3.3207464411E+01, 5.1724508538E+00, 1.5032081744E+01, 3.4486320825E+00, 9.6428068715E-01],
	[3.9385000000E+04, 3.3214791571E+01, 5.1724828458E+00, 1.5038287384E+01, 3.4490518460E+00, 9.6429622655E-01],
	[3.9390000000E+04, 3.3222119416E+01, 5.1725148339E+00, 1.5044494797E+01, 3.4494715059E+00, 9.6431175833E-01],
	[3.9395000000E+04, 3.3229447949E+01, 5.1725468181E+00, 1.5050703982E+01, 3.4498910625E+00, 9.6432728250E-01],
	[3.9400000000E+04, 3.3236777167E+01, 5.1725787985E+00, 1.5056914940E+01, 3.4503105156E+00, 9.6434279907E-01],
	[3.9405000000E+04, 3.3244107071E+01, 5.1726107750E+00, 1.5063127672E+01, 3.4507298653E+00, 9.6435830805E-01],
	[3.9410000000E+04, 3.3251437662E+01, 5.1726427477E+00, 1.5069342177E+01, 3.4511491117E+00, 9.6437380942E-01],
	[3.9415000000E+04, 3.3258768939E+01, 5.1726747165E+00, 1.5075558456E+01, 3.4515682547E+00, 9.6438930321E-01],
	[3.9420000000E+04, 3.3266100902E+01, 5.1727066815E+00, 1.5081776509E+01, 3.4519872943E+00, 9.6440478941E-01],
	[3.9425000000E+04, 3.3273433551E+01, 5.1727386426E+00, 1.5087996336E+01, 3.4524062306E+00, 9.6442026803E-01],
	[3.9430000000E+04, 3.3280766886E+01, 5.1727705998E+00, 1.5094217939E+01, 3.4528250636E+00, 9.6443573907E-01],
	[3.9435000000E+04, 3.3288100908E+01, 5.1728025532E+00, 1.5100441316E+01, 3.4532437933E+00, 9.6445120254E-01],
	[3.9440000000E+04, 3.3295435615E+01, 5.1728345027E+00, 1.5106666468E+01, 3.4536624198E+00, 9.6446665843E-01],
	[3.9445000000E+04, 3.3302771008E+01, 5.1728664484E+00, 1.5112893396E+01, 3.4540809429E+00, 9.6448210676E-01],
	[3.9450000000E+04, 3.3310107088E+01, 5.1728983902E+00, 1.5119122100E+01, 3.4544993629E+00, 9.6449754752E-01],
	[3.9455000000E+04, 3.3317443853E+01, 5.1729303282E+00, 1.5125352580E+01, 3.4549176796E+00, 9.6451298073E-01],
	[3.9460000000E+04, 3.3324781305E+01, 5.1729622623E+00, 1.5131584837E+01, 3.4553358932E+00, 9.6452840638E-01],
	[3.9465000000E+04, 3.3332119442E+01, 5.1729941926E+00, 1.5137818870E+01, 3.4557540035E+00, 9.6454382448E-01],
	[3.9470000000E+04, 3.3339458265E+01, 5.1730261190E+00, 1.5144054680E+01, 3.4561720107E+00, 9.6455923504E-01],
	[3.9475000000E+04, 3.3346797774E+01, 5.1730580416E+00, 1.5150292267E+01, 3.4565899147E+00, 9.6457463805E-01],
	[3.9480000000E+04, 3.3354137969E+01, 5.1730899603E+00, 1.5156531632E+01, 3.4570077157E+00, 9.6459003352E-01],
	[3.9485000000E+04, 3.3361478850E+01, 5.1731218752E+00, 1.5162772774E+01, 3.4574254135E+00, 9.6460542146E-01],
	[3.9490000000E+04, 3.3368820416E+01, 5.1731537863E+00, 1.5169015695E+01, 3.4578430082E+00, 9.6462080187E-01],
	[3.9495000000E+04, 3.3376162669E+01, 5.1731856935E+00, 1.5175260394E+01, 3.4582604999E+00, 9.6463617475E-01],
	[3.9500000000E+04, 3.3383505607E+01, 5.1732175968E+00, 1.5181506871E+01, 3.4586778885E+00, 9.6465154011E-01],
	[3.9505000000E+04, 3.3390849231E+01, 5.1732494963E+00, 1.5187755128E+01, 3.4590951741E+00, 9.6466689795E-01],
	[3.9510000000E+04, 3.3398193540E+01, 5.1732813920E+00, 1.5194005164E+01, 3.4595123566E+00, 9.6468224828E-01],
	[3.9515000000E+04, 3.3405538536E+01, 5.1733132838E+00, 1.5200256979E+01, 3.4599294362E+00, 9.6469759109E-01],
	[3.9520000000E+04, 3.3412884217E+01, 5.1733451718E+00, 1.5206510574E+01, 3.4603464128E+00, 9.6471292640E-01],
	[3.9525000000E+04, 3.3420230584E+01, 5.1733770560E+00, 1.5212765949E+01, 3.4607632864E+00, 9.6472825420E-01],
	[3.9530000000E+04, 3.3427577636E+01, 5.1734089363E+00, 1.5219023104E+01, 3.4611800571E+00, 9.6474357451E-01],
	[3.9535000000E+04, 3.3434925374E+01, 5.1734408128E+00, 1.5225282040E+01, 3.4615967249E+00, 9.6475888732E-01],
	[3.9540000000E+04, 3.3442273797E+01, 5.1734726855E+00, 1.5231542757E+01, 3.4620132897E+00, 9.6477419265E-01],
	[3.9545000000E+04, 3.3449622907E+01, 5.1735045543E+00, 1.5237805255E+01, 3.4624297517E+00, 9.6478949048E-01],
	[3.9550000000E+04, 3.3456972701E+01, 5.1735364193E+00, 1.5244069534E+01, 3.4628461108E+00, 9.6480478083E-01],
	[3.9555000000E+04, 3.3464323181E+01, 5.1735682804E+00, 1.5250335595E+01, 3.4632623671E+00, 9.6482006371E-01],
	[3.9560000000E+04, 3.3471674347E+01, 5.1736001377E+00, 1.5256603439E+01, 3.4636785205E+00, 9.6483533911E-01],
	[3.9565000000E+04, 3.3479026198E+01, 5.1736319912E+00, 1.5262873064E+01, 3.4640945711E+00, 9.6485060704E-01],
	[3.9570000000E+04, 3.3486378735E+01, 5.1736638409E+00, 1.5269144472E+01, 3.4645105190E+00, 9.6486586750E-01],
	[3.9575000000E+04, 3.3493731957E+01, 5.1736956867E+00, 1.5275417663E+01, 3.4649263640E+00, 9.6488112050E-01],
	[3.9580000000E+04, 3.3501085864E+01, 5.1737275287E+00, 1.5281692637E+01, 3.4653421063E+00, 9.6489636604E-01],
	[3.9585000000E+04, 3.3508440457E+01, 5.1737593669E+00, 1.5287969394E+01, 3.4657577459E+00, 9.6491160412E-01],
	[3.9590000000E+04, 3.3515795736E+01, 5.1737912013E+00, 1.5294247935E+01, 3.4661732827E+00, 9.6492683475E-01],
	[3.9595000000E+04, 3.3523151699E+01, 5.1738230318E+00, 1.5300528260E+01, 3.4665887169E+00, 9.6494205794E-01],
	[3.9600000000E+04, 3.3530508348E+01, 5.1738548585E+00, 1.5306810370E+01, 3.4670040483E+00, 9.6495727369E-01],
	[3.9605000000E+04, 3.3537865682E+01, 5.1738866814E+00, 1.5313094264E+01, 3.4674192771E+00, 9.6497248199E-01],
	[3.9610000000E+04, 3.3545223702E+01, 5.1739185005E+00, 1.5319379942E+01, 3.4678344033E+00, 9.6498768286E-01],
	[3.9615000000E+04, 3.3552582406E+01, 5.1739503157E+00, 1.5325667406E+01, 3.4682494268E+00, 9.6500287630E-01],
	[3.9620000000E+04, 3.3559941796E+01, 5.1739821271E+00, 1.5331956655E+01, 3.4686643477E+00, 9.6501806231E-01],
	[3.9625000000E+04, 3.3567301872E+01, 5.1740139347E+00, 1.5338247690E+01, 3.4690791661E+00, 9.6503324090E-01],
	[3.9630000000E+04, 3.3574662632E+01, 5.1740457385E+00, 1.5344540511E+01, 3.4694938818E+00, 9.6504841207E-01],
	[3.9635000000E+04, 3.3582024077E+01, 5.1740775385E+00, 1.5350835118E+01, 3.4699084950E+00, 9.6506357583E-01],
	[3.9640000000E+04, 3.3589386208E+01, 5.1741093347E+00, 1.5357131511E+01, 3.4703230057E+00, 9.6507873217E-01],
	[3.9645000000E+04, 3.3596749024E+01, 5.1741411270E+00, 1.5363429692E+01, 3.4707374139E+00, 9.6509388111E-01],
	[3.9650000000E+04, 3.3604112525E+01, 5.1741729155E+00, 1.5369729659E+01, 3.4711517196E+00, 9.6510902264E-01],
	[3.9655000000E+04, 3.3611476711E+01, 5.1742047002E+00, 1.5376031414E+01, 3.4715659228E+00, 9.6512415677E-01],
	[3.9660000000E+04, 3.3618841582E+01, 5.1742364811E+00, 1.5382334956E+01, 3.4719800235E+00, 9.6513928351E-01],
	[3.9665000000E+04, 3.3626207138E+01, 5.1742682582E+00, 1.5388640286E+01, 3.4723940218E+00, 9.6515440286E-01],
	[3.9670000000E+04, 3.3633573379E+01, 5.1743000315E+00, 1.5394947405E+01, 3.4728079177E+00, 9.6516951482E-01],
	[3.9675000000E+04, 3.3640940305E+01, 5.1743318010E+00, 1.5401256311E+01, 3.4732217111E+00, 9.6518461939E-01],
	[3.9680000000E+04, 3.3648307916E+01, 5.1743635666E+00, 1.5407567007E+01, 3.4736354022E+00, 9.6519971659E-01],
	[3.9685000000E+04, 3.3655676212E+01, 5.1743953285E+00, 1.5413879492E+01, 3.4740489910E+00, 9.6521480641E-01],
	[3.9690000000E+04, 3.3663045192E+01, 5.1744270865E+00, 1.5420193766E+01, 3.4744624774E+00, 9.6522988886E-01],
	[3.9695000000E+04, 3.3670414858E+01, 5.1744588408E+00, 1.5426509829E+01, 3.4748758614E+00, 9.6524496394E-01],
	[3.9700000000E+04, 3.3677785209E+01, 5.1744905912E+00, 1.5432827683E+01, 3.4752891432E+00, 9.6526003166E-01],
	[3.9705000000E+04, 3.3685156244E+01, 5.1745223379E+00, 1.5439147326E+01, 3.4757023226E+00, 9.6527509201E-01],
	[3.9710000000E+04, 3.3692527964E+01, 5.1745540807E+00, 1.5445468761E+01, 3.4761153998E+00, 9.6529014502E-01],
	[3.9715000000E+04, 3.3699900369E+01, 5.1745858197E+00, 1.5451791985E+01, 3.4765283747E+00, 9.6530519067E-01],
	[3.9720000000E+04, 3.3707273459E+01, 5.1746175549E+00, 1.5458117001E+01, 3.4769412474E+00, 9.6532022897E-01],
	[3.9725000000E+04, 3.3714647234E+01, 5.1746492864E+00, 1.5464443808E+01, 3.4773540179E+00, 9.6533525992E-01],
	[3.9730000000E+04, 3.3722021693E+01, 5.1746810140E+00, 1.5470772407E+01, 3.4777666862E+00, 9.6535028354E-01],
	[3.9735000000E+04, 3.3729396837E+01, 5.1747127378E+00, 1.5477102797E+01, 3.4781792523E+00, 9.6536529982E-01],
	[3.9740000000E+04, 3.3736772666E+01, 5.1747444579E+00, 1.5483434980E+01, 3.4785917163E+00, 9.6538030877E-01],
	[3.9745000000E+04, 3.3744149179E+01, 5.1747761741E+00, 1.5489768955E+01, 3.4790040781E+00, 9.6539531039E-01],
	[3.9750000000E+04, 3.3751526377E+01, 5.1748078865E+00, 1.5496104723E+01, 3.4794163378E+00, 9.6541030469E-01],
	[3.9755000000E+04, 3.3758904260E+01, 5.1748395952E+00, 1.5502442283E+01, 3.4798284954E+00, 9.6542529167E-01],
	[3.9760000000E+04, 3.3766282827E+01, 5.1748713000E+00, 1.5508781637E+01, 3.4802405509E+00, 9.6544027133E-01],
	[3.9765000000E+04, 3.3773662079E+01, 5.1749030011E+00, 1.5515122785E+01, 3.4806525044E+00, 9.6545524367E-01],
	[3.9770000000E+04, 3.3781042015E+01, 5.1749346984E+00, 1.5521465726E+01, 3.4810643558E+00, 9.6547020871E-01],
	[3.9775000000E+04, 3.3788422636E+01, 5.1749663918E+00, 1.5527810462E+01, 3.4814761052E+00, 9.6548516645E-01],
	[3.9780000000E+04, 3.3795803941E+01, 5.1749980815E+00, 1.5534156991E+01, 3.4818877525E+00, 9.6550011688E-01],
	[3.9785000000E+04, 3.3803185931E+01, 5.1750297674E+00, 1.5540505316E+01, 3.4822992979E+00, 9.6551506001E-01],
	[3.9790000000E+04, 3.3810568605E+01, 5.1750614495E+00, 1.5546855435E+01, 3.4827107413E+00, 9.6552999586E-01],
	[3.9795000000E+04, 3.3817951964E+01, 5.1750931279E+00, 1.5553207350E+01, 3.4831220828E+00, 9.6554492441E-01],
	[3.9800000000E+04, 3.3825336007E+01, 5.1751248024E+00, 1.5559561060E+01, 3.4835333223E+00, 9.6555984568E-01],
	[3.9805000000E+04, 3.3832720735E+01, 5.1751564732E+00, 1.5565916566E+01, 3.4839444599E+00, 9.6557475967E-01],
	[3.9810000000E+04, 3.3840106147E+01, 5.1751881401E+00, 1.5572273868E+01, 3.4843554957E+00, 9.6558966638E-01],
	[3.9815000000E+04, 3.3847492243E+01, 5.1752198033E+00, 1.5578632966E+01, 3.4847664295E+00, 9.6560456582E-01],
	[3.9820000000E+04, 3.3854879024E+01, 5.1752514627E+00, 1.5584993861E+01, 3.4851772615E+00, 9.6561945798E-01],
	[3.9825000000E+04, 3.3862266489E+01, 5.1752831183E+00, 1.5591356553E+01, 3.4855879916E+00, 9.6563434289E-01],
	[3.9830000000E+04, 3.3869654638E+01, 5.1753147702E+00, 1.5597721042E+01, 3.4859986200E+00, 9.6564922054E-01],
	[3.9835000000E+04, 3.3877043471E+01, 5.1753464182E+00, 1.5604087328E+01, 3.4864091465E+00, 9.6566409096E-01],
	[3.9840000000E+04, 3.3884432989E+01, 5.1753780625E+00, 1.5610455413E+01, 3.4868195713E+00, 9.6567895414E-01],
	[3.9845000000E+04, 3.3891823191E+01, 5.1754097030E+00, 1.5616825295E+01, 3.4872298943E+00, 9.6569381009E-01],
	[3.9850000000E+04, 3.3899214077E+01, 5.1754413398E+00, 1.5623196975E+01, 3.4876401155E+00, 9.6570865881E-01],
	[3.9855000000E+04, 3.3906605647E+01, 5.1754729727E+00, 1.5629570455E+01, 3.4880502350E+00, 9.6572350030E-01],
	[3.9860000000E+04, 3.3913997901E+01, 5.1755046019E+00, 1.5635945733E+01, 3.4884602528E+00, 9.6573833457E-01],
	[3.9865000000E+04, 3.3921390840E+01, 5.1755362273E+00, 1.5642322810E+01, 3.4888701690E+00, 9.6575316162E-01],
	[3.9870000000E+04, 3.3928790045E+01, 5.1755685516E+00, 1.5648701687E+01, 3.4892803619E+00, 9.6576798146E-01],
	[3.9875000000E+04, 3.3936201687E+01, 5.1756023507E+00, 1.5655082363E+01, 3.4896912497E+00, 9.6578279408E-01],
	[3.9880000000E+04, 3.3943614017E+01, 5.1756361458E+00, 1.5661464840E+01, 3.4901020362E+00, 9.6579759950E-01],
	[3.9885000000E+04, 3.3951027038E+01, 5.1756699369E+00, 1.5667849116E+01, 3.4905127214E+00, 9.6581239771E-01],
	[3.9890000000E+04, 3.3958440747E+01, 5.1757037240E+00, 1.5674235194E+01, 3.4909233054E+00, 9.6582718872E-01],
	[3.9895000000E+04, 3.3965855146E+01, 5.1757375070E+00, 1.5680623072E+01, 3.4913337880E+00, 9.6584197253E-01],
	[3.9900000000E+04, 3.3973270234E+01, 5.1757712861E+00, 1.5687012751E+01, 3.4917441695E+00, 9.6585674914E-01],
	[3.9905000000E+04, 3.3980686012E+01, 5.1758050611E+00, 1.5693404232E+01, 3.4921544497E+00, 9.6587151857E-01],
	[3.9910000000E+04, 3.3988102479E+01, 5.1758388321E+00, 1.5699797514E+01, 3.4925646287E+00, 9.6588628080E-01],
	[3.9915000000E+04, 3.3995519635E+01, 5.1758725991E+00, 1.5706192599E+01, 3.4929747065E+00, 9.6590103586E-01],
	[3.9920000000E+04, 3.4002937481E+01, 5.1759063621E+00, 1.5712589485E+01, 3.4933846831E+00, 9.6591578373E-01],
	[3.9925000000E+04, 3.4010356015E+01, 5.1759401211E+00, 1.5718988174E+01, 3.4937945587E+00, 9.6593052442E-01],
	[3.9930000000E+04, 3.4017775239E+01, 5.1759738761E+00, 1.5725388666E+01, 3.4942043330E+00, 9.6594525794E-01],
	[3.9935000000E+04, 3.4025195152E+01, 5.1760076270E+00, 1.5731790961E+01, 3.4946140063E+00, 9.6595998429E-01],
	[3.9940000000E+04, 3.4032615755E+01, 5.1760413740E+00, 1.5738195060E+01, 3.4950235785E+00, 9.6597470347E-01],
	[3.9945000000E+04, 3.4040037046E+01, 5.1760751170E+00, 1.5744600962E+01, 3.4954330496E+00, 9.6598941549E-01],
	[3.9950000000E+04, 3.4047459027E+01, 5.1761088559E+00, 1.5751008668E+01, 3.4958424197E+00, 9.6600412035E-01],
	[3.9955000000E+04, 3.4054881697E+01, 5.1761425909E+00, 1.5757418179E+01, 3.4962516887E+00, 9.6601881805E-01],
	[3.9960000000E+04, 3.4062305055E+01, 5.1761763218E+00, 1.5763829493E+01, 3.4966608567E+00, 9.6603350860E-01],
	[3.9965000000E+04, 3.4069729103E+01, 5.1762100488E+00, 1.5770242613E+01, 3.4970699237E+00, 9.6604819199E-01],
	[3.9970000000E+04, 3.4077153840E+01, 5.1762437718E+00, 1.5776657538E+01, 3.4974788897E+00, 9.6606286824E-01],
	[3.9975000000E+04, 3.4084579266E+01, 5.1762774907E+00, 1.5783074268E+01, 3.4978877548E+00, 9.6607753735E-01],
	[3.9980000000E+04, 3.4092005381E+01, 5.1763112057E+00, 1.5789492804E+01, 3.4982965189E+00, 9.6609219932E-01],
	[3.9985000000E+04, 3.4099432185E+01, 5.1763449166E+00, 1.5795913145E+01, 3.4987051822E+00, 9.6610685415E-01],
	[3.9990000000E+04, 3.4106859678E+01, 5.1763786236E+00, 1.5802335293E+01, 3.4991137445E+00, 9.6612150185E-01],
	[3.9995000000E+04, 3.4114287860E+01, 5.1764123266E+00, 1.5808759247E+01, 3.4995222059E+00, 9.6613614242E-01],
	[4.0000000000E+04, 3.4121716731E+01, 5.1764460256E+00, 1.5815185009E+01, 3.4999305665E+00, 9.6615077586E-01],
	[4.0005000000E+04, 3.4129146290E+01, 5.1764797205E+00, 1.5821637531E+01, 3.5003400476E+00, 9.6616540218E-01],
	[4.0010000000E+04, 3.4136576539E+01, 5.1765134115E+00, 1.5828091879E+01, 3.5007494274E+00, 9.6618002139E-01],
	[4.0015000000E+04, 3.4144007476E+01, 5.1765470985E+00, 1.5834548051E+01, 3.5011587058E+00, 9.6619463347E-01],
	[4.0020000000E+04, 3.4151439102E+01, 5.1765807816E+00, 1.5841006048E+01, 3.5015678828E+00, 9.6620923845E-01],
	[4.0025000000E+04, 3.4158871417E+01, 5.1766144606E+00, 1.5847465871E+01, 3.5019769585E+00, 9.6622383631E-01],
	[4.0030000000E+04, 3.4166304421E+01, 5.1766481356E+00, 1.5853927520E+01, 3.5023859329E+00, 9.6623842707E-01],
	[4.0035000000E+04, 3.4173738113E+01, 5.1766818067E+00, 1.5860390995E+01, 3.5027948059E+00, 9.6625301073E-01],
	[4.0040000000E+04, 3.4181172495E+01, 5.1767154737E+00, 1.5866856296E+01, 3.5032035777E+00, 9.6626758729E-01],
	[4.0045000000E+04, 3.4188607564E+01, 5.1767491368E+00, 1.5873323424E+01, 3.5036122482E+00, 9.6628215676E-01],
	[4.0050000000E+04, 3.4196043323E+01, 5.1767827959E+00, 1.5879792379E+01, 3.5040208175E+00, 9.6629671913E-01],
	[4.0055000000E+04, 3.4203479770E+01, 5.1768164510E+00, 1.5886263161E+01, 3.5044292856E+00, 9.6631127442E-01],
	[4.0060000000E+04, 3.4210916906E+01, 5.1768501021E+00, 1.5892735771E+01, 3.5048376524E+00, 9.6632582262E-01],
	[4.0065000000E+04, 3.4218354731E+01, 5.1768837493E+00, 1.5899210208E+01, 3.5052459181E+00, 9.6634036374E-01],
	[4.0070000000E+04, 3.4225793244E+01, 5.1769173925E+00, 1.5905686474E+01, 3.5056540826E+00, 9.6635489778E-01],
	[4.0075000000E+04, 3.4233232446E+01, 5.1769510316E+00, 1.5912164567E+01, 3.5060621459E+00, 9.6636942475E-01],
	[4.0080000000E+04, 3.4240672336E+01, 5.1769846669E+00, 1.5918644490E+01, 3.5064701081E+00, 9.6638394465E-01],
	[4.0085000000E+04, 3.4248112915E+01, 5.1770182981E+00, 1.5925126241E+01, 3.5068779692E+00, 9.6639845748E-01],
	[4.0090000000E+04, 3.4255554182E+01, 5.1770519253E+00, 1.5931609822E+01, 3.5072857293E+00, 9.6641296324E-01],
	[4.0095000000E+04, 3.4262996138E+01, 5.1770855486E+00, 1.5938095232E+01, 3.5076933882E+00, 9.6642746195E-01],
	[4.0100000000E+04, 3.4270438782E+01, 5.1771191679E+00, 1.5944582473E+01, 3.5081009461E+00, 9.6644195360E-01],
	[4.0105000000E+04, 3.4277882115E+01, 5.1771527833E+00, 1.5951071543E+01, 3.5085084030E+00, 9.6645643819E-01],
	[4.0110000000E+04, 3.4285326136E+01, 5.1771863946E+00, 1.5957562443E+01, 3.5089157588E+00, 9.6647091574E-01],
	[4.0115000000E+04, 3.4292770846E+01, 5.1772200020E+00, 1.5964055174E+01, 3.5093230137E+00, 9.6648538623E-01],
	[4.0120000000E+04, 3.4300216243E+01, 5.1772536054E+00, 1.5970549737E+01, 3.5097301676E+00, 9.6649984969E-01],
	[4.0125000000E+04, 3.4307662330E+01, 5.1772872049E+00, 1.5977046130E+01, 3.5101372205E+00, 9.6651430610E-01],
	[4.0130000000E+04, 3.4315109104E+01, 5.1773208004E+00, 1.5983544355E+01, 3.5105441725E+00, 9.6652875548E-01],
	[4.0135000000E+04, 3.4322556567E+01, 5.1773543919E+00, 1.5990044412E+01, 3.5109510235E+00, 9.6654319782E-01],
	[4.0140000000E+04, 3.4330004718E+01, 5.1773879794E+00, 1.5996546301E+01, 3.5113577737E+00, 9.6655763314E-01],
	[4.0145000000E+04, 3.4337453558E+01, 5.1774215630E+00, 1.6003050022E+01, 3.5117644230E+00, 9.6657206143E-01],
	[4.0150000000E+04, 3.4344903086E+01, 5.1774551426E+00, 1.6009555576E+01, 3.5121709714E+00, 9.6658648269E-01],
	[4.0155000000E+04, 3.4352353302E+01, 5.1774887183E+00, 1.6016062963E+01, 3.5125774190E+00, 9.6660089694E-01],
	[4.0160000000E+04, 3.4359804206E+01, 5.1775222900E+00, 1.6022572184E+01, 3.5129837658E+00, 9.6661530417E-01],
	[4.0165000000E+04, 3.4367255798E+01, 5.1775558577E+00, 1.6029083237E+01, 3.5133900118E+00, 9.6662970439E-01],
	[4.0170000000E+04, 3.4374708078E+01, 5.1775894215E+00, 1.6035596125E+01, 3.5137961570E+00, 9.6664409760E-01],
	[4.0175000000E+04, 3.4382161047E+01, 5.1776229813E+00, 1.6042110847E+01, 3.5142022014E+00, 9.6665848381E-01],
	[4.0180000000E+04, 3.4389614704E+01, 5.1776565371E+00, 1.6048627403E+01, 3.5146081451E+00, 9.6667286301E-01],
	[4.0185000000E+04, 3.4397069049E+01, 5.1776900890E+00, 1.6055145794E+01, 3.5150139881E+00, 9.6668723521E-01],
	[4.0190000000E+04, 3.4404524081E+01, 5.1777236370E+00, 1.6061666020E+01, 3.5154197303E+00, 9.6670160042E-01],
	[4.0195000000E+04, 3.4411979802E+01, 5.1777571809E+00, 1.6068188081E+01, 3.5158253719E+00, 9.6671595864E-01],
	[4.0200000000E+04, 3.4419436211E+01, 5.1777907210E+00, 1.6074711978E+01, 3.5162309128E+00, 9.6673030986E-01],
	[4.0205000000E+04, 3.4426893308E+01, 5.1778242570E+00, 1.6081237711E+01, 3.5166363530E+00, 9.6674465411E-01],
	[4.0210000000E+04, 3.4434351093E+01, 5.1778577891E+00, 1.6087765279E+01, 3.5170416927E+00, 9.6675899137E-01],
	[4.0215000000E+04, 3.4441809566E+01, 5.1778913173E+00, 1.6094294685E+01, 3.5174469317E+00, 9.6677332165E-01],
	[4.0220000000E+04, 3.4449268727E+01, 5.1779248415E+00, 1.6100825927E+01, 3.5178520701E+00, 9.6678764496E-01],
	[4.0225000000E+04, 3.4456728576E+01, 5.1779583618E+00, 1.6107359005E+01, 3.5182571080E+00, 9.6680196130E-01],
	[4.0230000000E+04, 3.4464189112E+01, 5.1779918781E+00, 1.6113893922E+01, 3.5186620453E+00, 9.6681627067E-01],
	[4.0235000000E+04, 3.4471650337E+01, 5.1780253905E+00, 1.6120430675E+01, 3.5190668821E+00, 9.6683057307E-01],
	[4.0240000000E+04, 3.4479112249E+01, 5.1780588989E+00, 1.6126969267E+01, 3.5194716183E+00, 9.6684486852E-01],
	[4.0245000000E+04, 3.4486574849E+01, 5.1780924033E+00, 1.6133509697E+01, 3.5198762541E+00, 9.6685915700E-01],
	[4.0250000000E+04, 3.4494038137E+01, 5.1781259039E+00, 1.6140051965E+01, 3.5202807894E+00, 9.6687343854E-01],
	[4.0255000000E+04, 3.4501502113E+01, 5.1781594004E+00, 1.6146596072E+01, 3.5206852243E+00, 9.6688771312E-01],
	[4.0260000000E+04, 3.4508966776E+01, 5.1781928931E+00, 1.6153142018E+01, 3.5210895587E+00, 9.6690198075E-01],
	[4.0265000000E+04, 3.4516432128E+01, 5.1782263818E+00, 1.6159689804E+01, 3.5214937927E+00, 9.6691624144E-01],
	[4.0270000000E+04, 3.4523898167E+01, 5.1782598665E+00, 1.6166239429E+01, 3.5218979263E+00, 9.6693049520E-01],
	[4.0275000000E+04, 3.4531364893E+01, 5.1782933473E+00, 1.6172790894E+01, 3.5223019595E+00, 9.6694474201E-01],
	[4.0280000000E+04, 3.4538832308E+01, 5.1783268242E+00, 1.6179344199E+01, 3.5227058924E+00, 9.6695898189E-01],
	[4.0285000000E+04, 3.4546300410E+01, 5.1783602971E+00, 1.6185899344E+01, 3.5231097249E+00, 9.6697321484E-01],
	[4.0290000000E+04, 3.4553769199E+01, 5.1783937661E+00, 1.6192456330E+01, 3.5235134572E+00, 9.6698744086E-01],
	[4.0295000000E+04, 3.4561238676E+01, 5.1784272312E+00, 1.6199015158E+01, 3.5239170891E+00, 9.6700165996E-01],
	[4.0300000000E+04, 3.4568708841E+01, 5.1784606923E+00, 1.6205575826E+01, 3.5243206207E+00, 9.6701587214E-01],
	[4.0305000000E+04, 3.4576179694E+01, 5.1784941495E+00, 1.6212138336E+01, 3.5247240521E+00, 9.6703007741E-01],
	[4.0310000000E+04, 3.4583651233E+01, 5.1785276027E+00, 1.6218702689E+01, 3.5251273833E+00, 9.6704427576E-01],
	[4.0315000000E+04, 3.4591123461E+01, 5.1785610521E+00, 1.6225268883E+01, 3.5255306142E+00, 9.6705846720E-01],
	[4.0320000000E+04, 3.4598596376E+01, 5.1785944975E+00, 1.6231836920E+01, 3.5259337449E+00, 9.6707265174E-01],
	[4.0325000000E+04, 3.4606069978E+01, 5.1786279389E+00, 1.6238406799E+01, 3.5263367754E+00, 9.6708682937E-01],
	[4.0330000000E+04, 3.4613544268E+01, 5.1786613764E+00, 1.6244978522E+01, 3.5267397058E+00, 9.6710100010E-01],
	[4.0335000000E+04, 3.4621019245E+01, 5.1786948100E+00, 1.6251552088E+01, 3.5271425361E+00, 9.6711516394E-01],
	[4.0340000000E+04, 3.4628494910E+01, 5.1787282397E+00, 1.6258127497E+01, 3.5275452662E+00, 9.6712932089E-01],
	[4.0345000000E+04, 3.4635971262E+01, 5.1787616654E+00, 1.6264704751E+01, 3.5279478962E+00, 9.6714347094E-01],
	[4.0350000000E+04, 3.4643448301E+01, 5.1787950872E+00, 1.6271283848E+01, 3.5283504261E+00, 9.6715761411E-01],
	[4.0355000000E+04, 3.4650926028E+01, 5.1788285051E+00, 1.6277864791E+01, 3.5287528560E+00, 9.6717175040E-01],
	[4.0360000000E+04, 3.4658404442E+01, 5.1788619191E+00, 1.6284447578E+01, 3.5291551858E+00, 9.6718587981E-01],
	[4.0365000000E+04, 3.4665883543E+01, 5.1788953291E+00, 1.6291032210E+01, 3.5295574156E+00, 9.6720000235E-01],
	[4.0370000000E+04, 3.4673363332E+01, 5.1789287353E+00, 1.6297618687E+01, 3.5299595454E+00, 9.6721411801E-01],
	[4.0375000000E+04, 3.4680843808E+01, 5.1789621374E+00, 1.6304207010E+01, 3.5303615752E+00, 9.6722822680E-01],
	[4.0380000000E+04, 3.4688324971E+01, 5.1789955357E+00, 1.6310797179E+01, 3.5307635050E+00, 9.6724232873E-01],
	[4.0385000000E+04, 3.4695806821E+01, 5.1790289301E+00, 1.6317389194E+01, 3.5311653349E+00, 9.6725642380E-01],
	[4.0390000000E+04, 3.4703289359E+01, 5.1790623205E+00, 1.6323983056E+01, 3.5315670649E+00, 9.6727051201E-01],
	[4.0395000000E+04, 3.4710772583E+01, 5.1790957070E+00, 1.6330578765E+01, 3.5319686949E+00, 9.6728459336E-01],
	[4.0400000000E+04, 3.4718256495E+01, 5.1791290896E+00, 1.6337176320E+01, 3.5323702251E+00, 9.6729866787E-01],
	[4.0405000000E+04, 3.4725741094E+01, 5.1791624683E+00, 1.6343775723E+01, 3.5327716554E+00, 9.6731273552E-01],
	[4.0410000000E+04, 3.4733226380E+01, 5.1791958431E+00, 1.6350376974E+01, 3.5331729858E+00, 9.6732679633E-01],
	[4.0415000000E+04, 3.4740712353E+01, 5.1792292139E+00, 1.6356980072E+01, 3.5335742165E+00, 9.6734085030E-01],
	[4.0420000000E+04, 3.4748199013E+01, 5.1792625809E+00, 1.6363585019E+01, 3.5339753473E+00, 9.6735489743E-01],
	[4.0425000000E+04, 3.4755686361E+01, 5.1792959439E+00, 1.6370191815E+01, 3.5343763783E+00, 9.6736893773E-01],
	[4.0430000000E+04, 3.4763174395E+01, 5.1793293030E+00, 1.6376800459E+01, 3.5347773095E+00, 9.6738297120E-01],
	[4.0435000000E+04, 3.4770663116E+01, 5.1793626582E+00, 1.6383410952E+01, 3.5351781410E+00, 9.6739699783E-01],
	[4.0440000000E+04, 3.4778152524E+01, 5.1793960095E+00, 1.6390023295E+01, 3.5355788728E+00, 9.6741101765E-01],
	[4.0445000000E+04, 3.4785642619E+01, 5.1794293569E+00, 1.6396637487E+01, 3.5359795048E+00, 9.6742503064E-01],
	[4.0450000000E+04, 3.4793133401E+01, 5.1794627004E+00, 1.6403253529E+01, 3.5363800372E+00, 9.6743903682E-01],
	[4.0455000000E+04, 3.4800624870E+01, 5.1794960400E+00, 1.6409871422E+01, 3.5367804699E+00, 9.6745303618E-01],
	[4.0460000000E+04, 3.4808117026E+01, 5.1795293756E+00, 1.6416491165E+01, 3.5371808029E+00, 9.6746702874E-01],
	[4.0465000000E+04, 3.4815609869E+01, 5.1795627074E+00, 1.6423112759E+01, 3.5375810363E+00, 9.6748101448E-01],
	[4.0470000000E+04, 3.4823103398E+01, 5.1795960353E+00, 1.6429736204E+01, 3.5379811701E+00, 9.6749499342E-01],
	[4.0475000000E+04, 3.4830597614E+01, 5.1796293592E+00, 1.6436361500E+01, 3.5383812043E+00, 9.6750896557E-01],
	[4.0480000000E+04, 3.4838092518E+01, 5.1796626793E+00, 1.6442988649E+01, 3.5387811389E+00, 9.6752293091E-01],
	[4.0485000000E+04, 3.4845588107E+01, 5.1796959954E+00, 1.6449617649E+01, 3.5391809740E+00, 9.6753688946E-01],
	[4.0490000000E+04, 3.4853084384E+01, 5.1797293077E+00, 1.6456248501E+01, 3.5395807095E+00, 9.6755084122E-01],
	[4.0495000000E+04, 3.4860581347E+01, 5.1797626160E+00, 1.6462881206E+01, 3.5399803455E+00, 9.6756478620E-01],
	[4.0500000000E+04, 3.4868078997E+01, 5.1797959205E+00, 1.6469515764E+01, 3.5403798820E+00, 9.6757872439E-01],
	[4.0505000000E+04, 3.4875577334E+01, 5.1798292210E+00, 1.6476152175E+01, 3.5407793191E+00, 9.6759265580E-01],
	[4.0510000000E+04, 3.4883076358E+01, 5.1798625177E+00, 1.6482790439E+01, 3.5411786567E+00, 9.6760658044E-01],
	[4.0515000000E+04, 3.4890592512E+01, 5.1798978518E+00, 1.6489430558E+01, 3.5415790185E+00, 9.6762049830E-01],
	[4.0520000000E+04, 3.4898110102E+01, 5.1799332740E+00, 1.6496072530E+01, 3.5419793320E+00, 9.6763440940E-01],
	[4.0525000000E+04, 3.4905628384E+01, 5.1799686920E+00, 1.6502716356E+01, 3.5423795463E+00, 9.6764831372E-01],
	[4.0530000000E+04, 3.4913147357E+01, 5.1800041060E+00, 1.6509362037E+01, 3.5427796616E+00, 9.6766221129E-01],
	[4.0535000000E+04, 3.4920667023E+01, 5.1800395158E+00, 1.6516009573E+01, 3.5431796779E+00, 9.6767610209E-01],
	[4.0540000000E+04, 3.4928187380E+01, 5.1800749215E+00, 1.6522658964E+01, 3.5435795951E+00, 9.6768998614E-01],
	[4.0545000000E+04, 3.4935708429E+01, 5.1801103231E+00, 1.6529310211E+01, 3.5439794132E+00, 9.6770386344E-01],
	[4.0550000000E+04, 3.4943230169E+01, 5.1801457205E+00, 1.6535963313E+01, 3.5443791324E+00, 9.6771773399E-01],
	[4.0555000000E+04, 3.4950752602E+01, 5.1801811138E+00, 1.6542618271E+01, 3.5447787526E+00, 9.6773159779E-01],
	[4.0560000000E+04, 3.4958275726E+01, 5.1802165030E+00, 1.6549275085E+01, 3.5451782738E+00, 9.6774545485E-01],
	[4.0565000000E+04, 3.4965799542E+01, 5.1802518881E+00, 1.6555933757E+01, 3.5455776961E+00, 9.6775930517E-01],
	[4.0570000000E+04, 3.4973324049E+01, 5.1802872691E+00, 1.6562594285E+01, 3.5459770194E+00, 9.6777314876E-01],
	[4.0575000000E+04, 3.4980849248E+01, 5.1803226459E+00, 1.6569256670E+01, 3.5463762438E+00, 9.6778698561E-01],
	[4.0580000000E+04, 3.4988375139E+01, 5.1803580186E+00, 1.6575920913E+01, 3.5467753694E+00, 9.6780081573E-01],
	[4.0585000000E+04, 3.4995901721E+01, 5.1803933872E+00, 1.6582587013E+01, 3.5471743961E+00, 9.6781463913E-01],
	[4.0590000000E+04, 3.5003428995E+01, 5.1804287517E+00, 1.6589254971E+01, 3.5475733239E+00, 9.6782845581E-01],
	[4.0595000000E+04, 3.5010956961E+01, 5.1804641121E+00, 1.6595924788E+01, 3.5479721529E+00, 9.6784226577E-01],
	[4.0600000000E+04, 3.5018485618E+01, 5.1804994683E+00, 1.6602596464E+01, 3.5483708831E+00, 9.6785606901E-01],
	[4.0605000000E+04, 3.5026014967E+01, 5.1805348205E+00, 1.6609269998E+01, 3.5487695145E+00, 9.6786986554E-01],
	[4.0610000000E+04, 3.5033545007E+01, 5.1805701685E+00, 1.6615945391E+01, 3.5491680472E+00, 9.6788365537E-01],
	[4.0615000000E+04, 3.5041075738E+01, 5.1806055125E+00, 1.6622622644E+01, 3.5495664811E+00, 9.6789743848E-01],
	[4.0620000000E+04, 3.5048607161E+01, 5.1806408523E+00, 1.6629301757E+01, 3.5499648162E+00, 9.6791121490E-01],
	[4.0625000000E+04, 3.5056139276E+01, 5.1806761880E+00, 1.6635982730E+01, 3.5503630527E+00, 9.6792498462E-01],
	[4.0630000000E+04, 3.5063672082E+01, 5.1807115196E+00, 1.6642665563E+01, 3.5507611904E+00, 9.6793874764E-01],
	[4.0635000000E+04, 3.5071205579E+01, 5.1807468471E+00, 1.6649350257E+01, 3.5511592295E+00, 9.6795250398E-01],
	[4.0640000000E+04, 3.5078739768E+01, 5.1807821705E+00, 1.6656036812E+01, 3.5515571700E+00, 9.6796625362E-01],
	[4.0645000000E+04, 3.5086274648E+01, 5.1808174897E+00, 1.6662725228E+01, 3.5519550118E+00, 9.6797999658E-01],
	[4.0650000000E+04, 3.5093810219E+01, 5.1808528049E+00, 1.6669415505E+01, 3.5523527550E+00, 9.6799373286E-01],
	[4.0655000000E+04, 3.5101346482E+01, 5.1808881160E+00, 1.6676107645E+01, 3.5527503996E+00, 9.6800746246E-01],
	[4.0660000000E+04, 3.5108883436E+01, 5.1809234230E+00, 1.6682801646E+01, 3.5531479456E+00, 9.6802118539E-01],
	[4.0665000000E+04, 3.5116421081E+01, 5.1809587258E+00, 1.6689497510E+01, 3.5535453931E+00, 9.6803490164E-01],
	[4.0670000000E+04, 3.5123959417E+01, 5.1809940246E+00, 1.6696195236E+01, 3.5539427420E+00, 9.6804861123E-01],
	[4.0675000000E+04, 3.5131498445E+01, 5.1810293193E+00, 1.6702894825E+01, 3.5543399925E+00, 9.6806231415E-01],
	[4.0680000000E+04, 3.5139038164E+01, 5.1810646099E+00, 1.6709596278E+01, 3.5547371444E+00, 9.6807601042E-01],
	[4.0685000000E+04, 3.5146578574E+01, 5.1810998963E+00, 1.6716299594E+01, 3.5551341979E+00, 9.6808970002E-01],
	[4.0690000000E+04, 3.5154119675E+01, 5.1811351787E+00, 1.6723004774E+01, 3.5555311529E+00, 9.6810338297E-01],
	[4.0695000000E+04, 3.5161661468E+01, 5.1811704570E+00, 1.6729711818E+01, 3.5559280095E+00, 9.6811705927E-01],
	[4.0700000000E+04, 3.5169203951E+01, 5.1812057312E+00, 1.6736420726E+01, 3.5563247676E+00, 9.6813072893E-01],
	[4.0705000000E+04, 3.5176747126E+01, 5.1812410013E+00, 1.6743131499E+01, 3.5567214274E+00, 9.6814439194E-01],
	[4.0710000000E+04, 3.5184290991E+01, 5.1812762673E+00, 1.6749844137E+01, 3.5571179888E+00, 9.6815804830E-01],
	[4.0715000000E+04, 3.5191835548E+01, 5.1813115292E+00, 1.6756558641E+01, 3.5575144519E+00, 9.6817169804E-01],
	[4.0720000000E+04, 3.5199380796E+01, 5.1813467871E+00, 1.6763275009E+01, 3.5579108166E+00, 9.6818534113E-01],
	[4.0725000000E+04, 3.5206926734E+01, 5.1813820408E+00, 1.6769993244E+01, 3.5583070829E+00, 9.6819897760E-01],
	[4.0730000000E+04, 3.5214473364E+01, 5.1814172905E+00, 1.6776713345E+01, 3.5587032510E+00, 9.6821260744E-01],
	[4.0735000000E+04, 3.5222020685E+01, 5.1814525360E+00, 1.6783435312E+01, 3.5590993208E+00, 9.6822623066E-01],
	[4.0740000000E+04, 3.5229568696E+01, 5.1814877775E+00, 1.6790159146E+01, 3.5594952924E+00, 9.6823984725E-01],
	[4.0745000000E+04, 3.5237117399E+01, 5.1815230149E+00, 1.6796884847E+01, 3.5598911657E+00, 9.6825345723E-01],
	[4.0750000000E+04, 3.5244666792E+01, 5.1815582482E+00, 1.6803612415E+01, 3.5602869408E+00, 9.6826706060E-01],
	[4.0755000000E+04, 3.5252216877E+01, 5.1815934774E+00, 1.6810341851E+01, 3.5606826177E+00, 9.6828065735E-01],
	[4.0760000000E+04, 3.5259767652E+01, 5.1816287026E+00, 1.6817073154E+01, 3.5610781965E+00, 9.6829424750E-01],
	[4.0765000000E+04, 3.5267319118E+01, 5.1816639236E+00, 1.6823806326E+01, 3.5614736770E+00, 9.6830783104E-01],
	[4.0770000000E+04, 3.5274871275E+01, 5.1816991406E+00, 1.6830541366E+01, 3.5618690595E+00, 9.6832140799E-01],
	[4.0775000000E+04, 3.5282424122E+01, 5.1817343535E+00, 1.6837278275E+01, 3.5622643438E+00, 9.6833497834E-01],
	[4.0780000000E+04, 3.5289977661E+01, 5.1817695623E+00, 1.6844017053E+01, 3.5626595300E+00, 9.6834854209E-01],
	[4.0785000000E+04, 3.5297531890E+01, 5.1818047671E+00, 1.6850757700E+01, 3.5630546181E+00, 9.6836209926E-01],
	[4.0790000000E+04, 3.5305086810E+01, 5.1818399677E+00, 1.6857500217E+01, 3.5634496082E+00, 9.6837564984E-01],
	[4.0795000000E+04, 3.5312642420E+01, 5.1818751643E+00, 1.6864244604E+01, 3.5638445002E+00, 9.6838919383E-01],
	[4.0800000000E+04, 3.5320198721E+01, 5.1819103568E+00, 1.6870990860E+01, 3.5642392942E+00, 9.6840273125E-01],
	[4.0805000000E+04, 3.5327755713E+01, 5.1819455453E+00, 1.6877738988E+01, 3.5646339903E+00, 9.6841626208E-01],
	[4.0810000000E+04, 3.5335313396E+01, 5.1819807297E+00, 1.6884488986E+01, 3.5650285883E+00, 9.6842978635E-01],
	[4.0815000000E+04, 3.5342871769E+01, 5.1820159100E+00, 1.6891240855E+01, 3.5654230884E+00, 9.6844330405E-01],
	[4.0820000000E+04, 3.5350430833E+01, 5.1820510862E+00, 1.6897994595E+01, 3.5658174905E+00, 9.6845681518E-01],
	[4.0825000000E+04, 3.5357990587E+01, 5.1820862583E+00, 1.6904750207E+01, 3.5662117947E+00, 9.6847031974E-01],
	[4.0830000000E+04, 3.5365551032E+01, 5.1821214264E+00, 1.6911507691E+01, 3.5666060010E+00, 9.6848381775E-01],
	[4.0835000000E+04, 3.5373112167E+01, 5.1821565905E+00, 1.6918267047E+01, 3.5670001095E+00, 9.6849730920E-01],
	[4.0840000000E+04, 3.5380673993E+01, 5.1821917504E+00, 1.6925028276E+01, 3.5673941201E+00, 9.6851079410E-01],
	[4.0845000000E+04, 3.5388236510E+01, 5.1822269063E+00, 1.6931791377E+01, 3.5677880328E+00, 9.6852427245E-01],
	[4.0850000000E+04, 3.5395799716E+01, 5.1822620581E+00, 1.6938556351E+01, 3.5681818477E+00, 9.6853774425E-01],
	[4.0855000000E+04, 3.5403363614E+01, 5.1822972059E+00, 1.6945323199E+01, 3.5685755648E+00, 9.6855120951E-01],
	[4.0860000000E+04, 3.5410928201E+01, 5.1823323496E+00, 1.6952091920E+01, 3.5689691842E+00, 9.6856466823E-01],
	[4.0865000000E+04, 3.5418493480E+01, 5.1823674892E+00, 1.6958862515E+01, 3.5693627057E+00, 9.6857812041E-01],
	[4.0870000000E+04, 3.5426059448E+01, 5.1824026248E+00, 1.6965634985E+01, 3.5697561295E+00, 9.6859156606E-01],
	[4.0875000000E+04, 3.5433626107E+01, 5.1824377563E+00, 1.6972409329E+01, 3.5701494557E+00, 9.6860500519E-01],
	[4.0880000000E+04, 3.5441193456E+01, 5.1824728838E+00, 1.6979185548E+01, 3.5705426841E+00, 9.6861843778E-01],
	[4.0885000000E+04, 3.5448761496E+01, 5.1825080072E+00, 1.6985963641E+01, 3.5709358148E+00, 9.6863186385E-01],
	[4.0890000000E+04, 3.5456330226E+01, 5.1825431265E+00, 1.6992743611E+01, 3.5713288478E+00, 9.6864528341E-01],
	[4.0895000000E+04, 3.5463899646E+01, 5.1825782418E+00, 1.6999525455E+01, 3.5717217833E+00, 9.6865869645E-01],
	[4.0900000000E+04, 3.5471469756E+01, 5.1826133530E+00, 1.7006309176E+01, 3.5721146211E+00, 9.6867210297E-01],
	[4.0905000000E+04, 3.5479040557E+01, 5.1826484602E+00, 1.7013094773E+01, 3.5725073613E+00, 9.6868550299E-01],
	[4.0910000000E+04, 3.5486612047E+01, 5.1826835633E+00, 1.7019882247E+01, 3.5729000039E+00, 9.6869889650E-01],
	[4.0915000000E+04, 3.5494184228E+01, 5.1827186624E+00, 1.7026671597E+01, 3.5732925489E+00, 9.6871228351E-01],
	[4.0920000000E+04, 3.5501757100E+01, 5.1827537574E+00, 1.7033462825E+01, 3.5736849964E+00, 9.6872566401E-01],
	[4.0925000000E+04, 3.5509330661E+01, 5.1827888484E+00, 1.7040255930E+01, 3.5740773464E+00, 9.6873903803E-01],
	[4.0930000000E+04, 3.5516904912E+01, 5.1828239353E+00, 1.7047050912E+01, 3.5744695989E+00, 9.6875240555E-01],
	[4.0935000000E+04, 3.5524479854E+01, 5.1828590182E+00, 1.7053847773E+01, 3.5748617539E+00, 9.6876576658E-01],
	[4.0940000000E+04, 3.5532055486E+01, 5.1828940970E+00, 1.7060646511E+01, 3.5752538114E+00, 9.6877912112E-01],
	[4.0945000000E+04, 3.5539631807E+01, 5.1829291718E+00, 1.7067447129E+01, 3.5756457715E+00, 9.6879246919E-01],
	[4.0950000000E+04, 3.5547208819E+01, 5.1829642425E+00, 1.7074249625E+01, 3.5760376342E+00, 9.6880581077E-01],
	[4.0955000000E+04, 3.5554786521E+01, 5.1829993092E+00, 1.7081054000E+01, 3.5764293995E+00, 9.6881914588E-01],
	[4.0960000000E+04, 3.5562364912E+01, 5.1830343718E+00, 1.7087860255E+01, 3.5768210673E+00, 9.6883247451E-01],
	[4.0965000000E+04, 3.5569943994E+01, 5.1830694304E+00, 1.7094668389E+01, 3.5772126379E+00, 9.6884579668E-01],
	[4.0970000000E+04, 3.5577523766E+01, 5.1831044850E+00, 1.7101478403E+01, 3.5776041110E+00, 9.6885911238E-01],
	[4.0975000000E+04, 3.5585104227E+01, 5.1831395355E+00, 1.7108290298E+01, 3.5779954869E+00, 9.6887242162E-01],
	[4.0980000000E+04, 3.5592685379E+01, 5.1831745820E+00, 1.7115104073E+01, 3.5783867654E+00, 9.6888572440E-01],
	[4.0985000000E+04, 3.5600267220E+01, 5.1832096244E+00, 1.7121919729E+01, 3.5787779467E+00, 9.6889902072E-01],
	[4.0990000000E+04, 3.5607849752E+01, 5.1832446628E+00, 1.7128737266E+01, 3.5791690307E+00, 9.6891231059E-01],
	[4.0995000000E+04, 3.5615432973E+01, 5.1832796972E+00, 1.7135556685E+01, 3.5795600175E+00, 9.6892559402E-01],
	[4.1000000000E+04, 3.5623016884E+01, 5.1833147275E+00, 1.7142377986E+01, 3.5799509070E+00, 9.6893887099E-01],
	[4.1005000000E+04, 3.5630601484E+01, 5.1833497538E+00, 1.7149201168E+01, 3.5803416994E+00, 9.6895214153E-01],
	[4.1010000000E+04, 3.5638186775E+01, 5.1833847761E+00, 1.7156026233E+01, 3.5807323945E+00, 9.6896540562E-01],
	[4.1015000000E+04, 3.5645772755E+01, 5.1834197943E+00, 1.7162853180E+01, 3.5811229925E+00, 9.6897866328E-01],
	[4.1020000000E+04, 3.5653359425E+01, 5.1834548085E+00, 1.7169682010E+01, 3.5815134934E+00, 9.6899191451E-01],
	[4.1025000000E+04, 3.5660946785E+01, 5.1834898187E+00, 1.7176512723E+01, 3.5819038971E+00, 9.6900515931E-01],
	[4.1030000000E+04, 3.5668534834E+01, 5.1835248248E+00, 1.7183345320E+01, 3.5822942037E+00, 9.6901839768E-01],
	[4.1035000000E+04, 3.5676123573E+01, 5.1835598269E+00, 1.7190179801E+01, 3.5826844132E+00, 9.6903162963E-01],
	[4.1040000000E+04, 3.5683713002E+01, 5.1835948250E+00, 1.7197016165E+01, 3.5830745257E+00, 9.6904485516E-01],
	[4.1045000000E+04, 3.5691303121E+01, 5.1836298190E+00, 1.7203854414E+01, 3.5834645412E+00, 9.6905807428E-01],
	[4.1050000000E+04, 3.5698893929E+01, 5.1836648090E+00, 1.7210694548E+01, 3.5838544596E+00, 9.6907128698E-01],
	[4.1055000000E+04, 3.5706485426E+01, 5.1836997950E+00, 1.7217536566E+01, 3.5842442810E+00, 9.6908449328E-01],
	[4.1060000000E+04, 3.5714077613E+01, 5.1837347770E+00, 1.7224380470E+01, 3.5846340054E+00, 9.6909769317E-01],
	[4.1065000000E+04, 3.5721670490E+01, 5.1837697550E+00, 1.7231226259E+01, 3.5850236329E+00, 9.6911088665E-01],
	[4.1070000000E+04, 3.5729264056E+01, 5.1838047289E+00, 1.7238073934E+01, 3.5854131634E+00, 9.6912407374E-01],
	[4.1075000000E+04, 3.5736858312E+01, 5.1838396988E+00, 1.7244923495E+01, 3.5858025970E+00, 9.6913725443E-01],
	[4.1080000000E+04, 3.5744453257E+01, 5.1838746647E+00, 1.7251774942E+01, 3.5861919337E+00, 9.6915042873E-01],
	[4.1085000000E+04, 3.5752048892E+01, 5.1839096265E+00, 1.7258628276E+01, 3.5865811735E+00, 9.6916359664E-01],
	[4.1090000000E+04, 3.5759645216E+01, 5.1839445844E+00, 1.7265483497E+01, 3.5869703164E+00, 9.6917675817E-01],
	[4.1095000000E+04, 3.5767242230E+01, 5.1839795382E+00, 1.7272340605E+01, 3.5873593625E+00, 9.6918991331E-01],
	[4.1100000000E+04, 3.5774839933E+01, 5.1840144880E+00, 1.7279199601E+01, 3.5877483118E+00, 9.6920306207E-01],
	[4.1105000000E+04, 3.5782438325E+01, 5.1840494338E+00, 1.7286060485E+01, 3.5881371643E+00, 9.6921620446E-01],
	[4.1110000000E+04, 3.5790037407E+01, 5.1840843756E+00, 1.7292923256E+01, 3.5885259200E+00, 9.6922934048E-01],
	[4.1115000000E+04, 3.5797637178E+01, 5.1841193133E+00, 1.7299787916E+01, 3.5889145789E+00, 9.6924247012E-01],
	[4.1120000000E+04, 3.5805237638E+01, 5.1841542471E+00, 1.7306654465E+01, 3.5893031411E+00, 9.6925559340E-01],
	[4.1125000000E+04, 3.5812838787E+01, 5.1841891768E+00, 1.7313522902E+01, 3.5896916066E+00, 9.6926871032E-01],
	[4.1130000000E+04, 3.5820440626E+01, 5.1842241026E+00, 1.7320393229E+01, 3.5900799754E+00, 9.6928182088E-01],
	[4.1135000000E+04, 3.5828043154E+01, 5.1842590243E+00, 1.7327265445E+01, 3.5904682475E+00, 9.6929492508E-01],
	[4.1140000000E+04, 3.5835646372E+01, 5.1842939420E+00, 1.7334139552E+01, 3.5908564229E+00, 9.6930802294E-01],
	[4.1145000000E+04, 3.5843250278E+01, 5.1843288557E+00, 1.7341015548E+01, 3.5912445017E+00, 9.6932111444E-01],
	[4.1150000000E+04, 3.5850854874E+01, 5.1843637654E+00, 1.7347893435E+01, 3.5916324838E+00, 9.6933419959E-01],
	[4.1155000000E+04, 3.5858460159E+01, 5.1843986711E+00, 1.7354773212E+01, 3.5920203694E+00, 9.6934727841E-01],
	[4.1160000000E+04, 3.5866066133E+01, 5.1844335727E+00, 1.7361654880E+01, 3.5924081584E+00, 9.6936035088E-01],
	[4.1165000000E+04, 3.5873681761E+01, 5.1844695656E+00, 1.7368538440E+01, 3.5927964666E+00, 9.6937341702E-01],
	[4.1170000000E+04, 3.5881306195E+01, 5.1845065455E+00, 1.7375423891E+01, 3.5931852360E+00, 9.6938647682E-01],
	[4.1175000000E+04, 3.5888931323E+01, 5.1845435211E+00, 1.7382311234E+01, 3.5935739091E+00, 9.6939953030E-01],
	[4.1180000000E+04, 3.5896557146E+01, 5.1845804926E+00, 1.7389200470E+01, 3.5939624860E+00, 9.6941257745E-01],
	[4.1185000000E+04, 3.5904183663E+01, 5.1846174598E+00, 1.7396091597E+01, 3.5943509667E+00, 9.6942561827E-01],
	[4.1190000000E+04, 3.5911810874E+01, 5.1846544228E+00, 1.7402984618E+01, 3.5947393512E+00, 9.6943865278E-01],
	[4.1195000000E+04, 3.5919438780E+01, 5.1846913816E+00, 1.7409879531E+01, 3.5951276395E+00, 9.6945168097E-01],
	[4.1200000000E+04, 3.5927067379E+01, 5.1847283361E+00, 1.7416776338E+01, 3.5955158317E+00, 9.6946470285E-01],
	[4.1205000000E+04, 3.5934696673E+01, 5.1847652864E+00, 1.7423675038E+01, 3.5959039278E+00, 9.6947771842E-01],
	[4.1210000000E+04, 3.5942326661E+01, 5.1848022325E+00, 1.7430575632E+01, 3.5962919278E+00, 9.6949072769E-01],
	[4.1215000000E+04, 3.5949957343E+01, 5.1848391744E+00, 1.7437478120E+01, 3.5966798317E+00, 9.6950373065E-01],
	[4.1220000000E+04, 3.5957588719E+01, 5.1848761121E+00, 1.7444382503E+01, 3.5970676395E+00, 9.6951672731E-01],
	[4.1225000000E+04, 3.5965220789E+01, 5.1849130455E+00, 1.7451288781E+01, 3.5974553513E+00, 9.6952971767E-01],
	[4.1230000000E+04, 3.5972853553E+01, 5.1849499748E+00, 1.7458196953E+01, 3.5978429671E+00, 9.6954270174E-01],
	[4.1235000000E+04, 3.5980487011E+01, 5.1849868998E+00, 1.7465107021E+01, 3.5982304868E+00, 9.6955567952E-01],
	[4.1240000000E+04, 3.5988121163E+01, 5.1850238206E+00, 1.7472018985E+01, 3.5986179106E+00, 9.6956865102E-01],
	[4.1245000000E+04, 3.5995756008E+01, 5.1850607372E+00, 1.7478932844E+01, 3.5990052384E+00, 9.6958161623E-01],
	[4.1250000000E+04, 3.6003391548E+01, 5.1850976496E+00, 1.7485848600E+01, 3.5993924703E+00, 9.6959457516E-01],
	[4.1255000000E+04, 3.6011027782E+01, 5.1851345578E+00, 1.7492766252E+01, 3.5997796062E+00, 9.6960752782E-01],
	[4.1260000000E+04, 3.6018664710E+01, 5.1851714617E+00, 1.7499685801E+01, 3.6001666463E+00, 9.6962047420E-01],
	[4.1265000000E+04, 3.6026302331E+01, 5.1852083615E+00, 1.7506607247E+01, 3.6005535904E+00, 9.6963341432E-01],
	[4.1270000000E+04, 3.6033940647E+01, 5.1852452570E+00, 1.7513530590E+01, 3.6009404387E+00, 9.6964634816E-01],
	[4.1275000000E+04, 3.6041579656E+01, 5.1852821483E+00, 1.7520455831E+01, 3.6013271912E+00, 9.6965927575E-01],
	[4.1280000000E+04, 3.6049219359E+01, 5.1853190355E+00, 1.7527382970E+01, 3.6017138478E+00, 9.6967219707E-01],
	[4.1285000000E+04, 3.6056859756E+01, 5.1853559184E+00, 1.7534312007E+01, 3.6021004087E+00, 9.6968511214E-01],
	[4.1290000000E+04, 3.6064500847E+01, 5.1853927971E+00, 1.7541242943E+01, 3.6024868737E+00, 9.6969802095E-01],
	[4.1295000000E+04, 3.6072142631E+01, 5.1854296716E+00, 1.7548175777E+01, 3.6028732430E+00, 9.6971092351E-01],
	[4.1300000000E+04, 3.6079785109E+01, 5.1854665419E+00, 1.7555110511E+01, 3.6032595166E+00, 9.6972381983E-01],
	[4.1305000000E+04, 3.6087428281E+01, 5.1855034081E+00, 1.7562047144E+01, 3.6036456944E+00, 9.6973670990E-01],
	[4.1310000000E+04, 3.6095072146E+01, 5.1855402700E+00, 1.7568985676E+01, 3.6040317765E+00, 9.6974959373E-01],
	[4.1315000000E+04, 3.6102716706E+01, 5.1855771277E+00, 1.7575926109E+01, 3.6044177629E+00, 9.6976247132E-01],
	[4.1320000000E+04, 3.6110361958E+01, 5.1856139812E+00, 1.7582868442E+01, 3.6048036537E+00, 9.6977534269E-01],
	[4.1325000000E+04, 3.6118007905E+01, 5.1856508305E+00, 1.7589812675E+01, 3.6051894489E+00, 9.6978820782E-01],
	[4.1330000000E+04, 3.6125654545E+01, 5.1856876756E+00, 1.7596758809E+01, 3.6055751484E+00, 9.6980106672E-01],
	[4.1335000000E+04, 3.6133301878E+01, 5.1857245166E+00, 1.7603706845E+01, 3.6059607523E+00, 9.6981391940E-01],
	[4.1340000000E+04, 3.6140949906E+01, 5.1857613533E+00, 1.7610656782E+01, 3.6063462606E+00, 9.6982676586E-01],
	[4.1345000000E+04, 3.6148598626E+01, 5.1857981858E+00, 1.7617608620E+01, 3.6067316734E+00, 9.6983960610E-01],
	[4.1350000000E+04, 3.6156248041E+01, 5.1858350142E+00, 1.7624562360E+01, 3.6071169906E+00, 9.6985244013E-01],
	[4.1355000000E+04, 3.6163898148E+01, 5.1858718383E+00, 1.7631518003E+01, 3.6075022123E+00, 9.6986526794E-01],
	[4.1360000000E+04, 3.6171548949E+01, 5.1859086583E+00, 1.7638475548E+01, 3.6078873385E+00, 9.6987808955E-01],
	[4.1365000000E+04, 3.6179200444E+01, 5.1859454741E+00, 1.7645434997E+01, 3.6082723692E+00, 9.6989090496E-01],
	[4.1370000000E+04, 3.6186852632E+01, 5.1859822856E+00, 1.7652396348E+01, 3.6086573045E+00, 9.6990371416E-01],
	[4.1375000000E+04, 3.6194505514E+01, 5.1860190930E+00, 1.7659359603E+01, 3.6090421443E+00, 9.6991651717E-01],
	[4.1380000000E+04, 3.6202159089E+01, 5.1860558962E+00, 1.7666324761E+01, 3.6094268887E+00, 9.6992931398E-01],
	[4.1385000000E+04, 3.6209813357E+01, 5.1860926953E+00, 1.7673291824E+01, 3.6098115377E+00, 9.6994210460E-01],
	[4.1390000000E+04, 3.6217468319E+01, 5.1861294901E+00, 1.7680260791E+01, 3.6101960914E+00, 9.6995488903E-01],
	[4.1395000000E+04, 3.6225123974E+01, 5.1861662808E+00, 1.7687231662E+01, 3.6105805496E+00, 9.6996766728E-01],
	[4.1400000000E+04, 3.6232780322E+01, 5.1862030672E+00, 1.7694204438E+01, 3.6109649125E+00, 9.6998043935E-01],
	[4.1405000000E+04, 3.6240437363E+01, 5.1862398495E+00, 1.7701179120E+01, 3.6113491801E+00, 9.6999320523E-01],
	[4.1410000000E+04, 3.6248095098E+01, 5.1862766276E+00, 1.7708155707E+01, 3.6117333524E+00, 9.7000596495E-01],
	[4.1415000000E+04, 3.6255753526E+01, 5.1863134016E+00, 1.7715134200E+01, 3.6121174295E+00, 9.7001871849E-01],
	[4.1420000000E+04, 3.6263412647E+01, 5.1863501713E+00, 1.7722114598E+01, 3.6125014112E+00, 9.7003146586E-01],
	[4.1425000000E+04, 3.6271072462E+01, 5.1863869369E+00, 1.7729096903E+01, 3.6128852977E+00, 9.7004420707E-01],
	[4.1430000000E+04, 3.6278732970E+01, 5.1864236983E+00, 1.7736081115E+01, 3.6132690890E+00, 9.7005694212E-01],
	[4.1435000000E+04, 3.6286394170E+01, 5.1864604555E+00, 1.7743067234E+01, 3.6136527851E+00, 9.7006967101E-01],
	[4.1440000000E+04, 3.6294056064E+01, 5.1864972086E+00, 1.7750055260E+01, 3.6140363861E+00, 9.7008239374E-01],
	[4.1445000000E+04, 3.6301718652E+01, 5.1865339575E+00, 1.7757045193E+01, 3.6144198918E+00, 9.7009511032E-01],
	[4.1450000000E+04, 3.6309381932E+01, 5.1865707022E+00, 1.7764037034E+01, 3.6148033025E+00, 9.7010782075E-01],
	[4.1455000000E+04, 3.6317045905E+01, 5.1866074427E+00, 1.7771030784E+01, 3.6151866180E+00, 9.7012052504E-01],
	[4.1460000000E+04, 3.6324710571E+01, 5.1866441790E+00, 1.7778026441E+01, 3.6155698384E+00, 9.7013322319E-01],
	[4.1465000000E+04, 3.6332375931E+01, 5.1866809112E+00, 1.7785024008E+01, 3.6159529637E+00, 9.7014591519E-01],
	[4.1470000000E+04, 3.6340041983E+01, 5.1867176392E+00, 1.7792023483E+01, 3.6163359940E+00, 9.7015860106E-01],
	[4.1475000000E+04, 3.6347708729E+01, 5.1867543631E+00, 1.7799024867E+01, 3.6167189292E+00, 9.7017128080E-01],
	[4.1480000000E+04, 3.6355376167E+01, 5.1867910828E+00, 1.7806028161E+01, 3.6171017694E+00, 9.7018395441E-01],
	[4.1485000000E+04, 3.6363044298E+01, 5.1868277983E+00, 1.7813033365E+01, 3.6174845147E+00, 9.7019662189E-01],
	[4.1490000000E+04, 3.6370713122E+01, 5.1868645097E+00, 1.7820040479E+01, 3.6178671649E+00, 9.7020928325E-01],
	[4.1495000000E+04, 3.6378382640E+01, 5.1869012168E+00, 1.7827049504E+01, 3.6182497202E+00, 9.7022193849E-01],
	[4.1500000000E+04, 3.6386052850E+01, 5.1869379199E+00, 1.7834060439E+01, 3.6186321806E+00, 9.7023458761E-01],
	[4.1505000000E+04, 3.6393723753E+01, 5.1869746187E+00, 1.7841073285E+01, 3.6190145460E+00, 9.7024723062E-01],
	[4.1510000000E+04, 3.6401395348E+01, 5.1870113134E+00, 1.7848088042E+01, 3.6193968165E+00, 9.7025986753E-01],
	[4.1515000000E+04, 3.6409067637E+01, 5.1870480040E+00, 1.7855104711E+01, 3.6197789922E+00, 9.7027249832E-01],
	[4.1520000000E+04, 3.6416740618E+01, 5.1870846904E+00, 1.7862123292E+01, 3.6201610730E+00, 9.7028512301E-01],
	[4.1525000000E+04, 3.6424414292E+01, 5.1871213726E+00, 1.7869143785E+01, 3.6205430590E+00, 9.7029774160E-01],
	[4.1530000000E+04, 3.6432088659E+01, 5.1871580507E+00, 1.7876166190E+01, 3.6209249501E+00, 9.7031035410E-01],
	[4.1535000000E+04, 3.6439763719E+01, 5.1871947246E+00, 1.7883190508E+01, 3.6213067465E+00, 9.7032296050E-01],
	[4.1540000000E+04, 3.6447439471E+01, 5.1872313943E+00, 1.7890216739E+01, 3.6216884481E+00, 9.7033556081E-01],
	[4.1545000000E+04, 3.6455115917E+01, 5.1872680599E+00, 1.7897244883E+01, 3.6220700549E+00, 9.7034815503E-01],
	[4.1550000000E+04, 3.6462793054E+01, 5.1873047214E+00, 1.7904274941E+01, 3.6224515670E+00, 9.7036074317E-01],
	[4.1555000000E+04, 3.6470470885E+01, 5.1873413787E+00, 1.7911306913E+01, 3.6228329844E+00, 9.7037332523E-01],
	[4.1560000000E+04, 3.6478149408E+01, 5.1873780318E+00, 1.7918340799E+01, 3.6232143071E+00, 9.7038590121E-01],
	[4.1565000000E+04, 3.6485828624E+01, 5.1874146808E+00, 1.7925376600E+01, 3.6235955351E+00, 9.7039847112E-01],
	[4.1570000000E+04, 3.6493508532E+01, 5.1874513257E+00, 1.7932414315E+01, 3.6239766685E+00, 9.7041103496E-01],
	[4.1575000000E+04, 3.6501189133E+01, 5.1874879664E+00, 1.7939453945E+01, 3.6243577072E+00, 9.7042359273E-01],
	[4.1580000000E+04, 3.6508870426E+01, 5.1875246029E+00, 1.7946495491E+01, 3.6247386513E+00, 9.7043614443E-01],
	[4.1585000000E+04, 3.6516552412E+01, 5.1875612353E+00, 1.7953538952E+01, 3.6251195009E+00, 9.7044869007E-01],
	[4.1590000000E+04, 3.6524235091E+01, 5.1875978636E+00, 1.7960584329E+01, 3.6255002558E+00, 9.7046122966E-01],
	[4.1595000000E+04, 3.6531918462E+01, 5.1876344877E+00, 1.7967631622E+01, 3.6258809162E+00, 9.7047376319E-01],
	[4.1600000000E+04, 3.6539602525E+01, 5.1876711077E+00, 1.7974680832E+01, 3.6262614821E+00, 9.7048629067E-01],
	[4.1605000000E+04, 3.6547287281E+01, 5.1877077235E+00, 1.7981731959E+01, 3.6266419534E+00, 9.7049881210E-01],
	[4.1610000000E+04, 3.6554972729E+01, 5.1877443352E+00, 1.7988785003E+01, 3.6270223303E+00, 9.7051132749E-01],
	[4.1615000000E+04, 3.6562658870E+01, 5.1877809427E+00, 1.7995839964E+01, 3.6274026127E+00, 9.7052383683E-01],
	[4.1620000000E+04, 3.6570345703E+01, 5.1878175461E+00, 1.8002896842E+01, 3.6277828006E+00, 9.7053634014E-01],
	[4.1625000000E+04, 3.6578033229E+01, 5.1878541454E+00, 1.8009955639E+01, 3.6281628942E+00, 9.7054883741E-01],
	[4.1630000000E+04, 3.6585721447E+01, 5.1878907405E+00, 1.8017016354E+01, 3.6285428933E+00, 9.7056132864E-01],
	[4.1635000000E+04, 3.6593410357E+01, 5.1879273315E+00, 1.8024078988E+01, 3.6289227980E+00, 9.7057381385E-01],
	[4.1640000000E+04, 3.6601099959E+01, 5.1879639184E+00, 1.8031143540E+01, 3.6293026083E+00, 9.7058629304E-01],
	[4.1645000000E+04, 3.6608790254E+01, 5.1880005011E+00, 1.8038210011E+01, 3.6296823243E+00, 9.7059876620E-01],
	[4.1650000000E+04, 3.6616481241E+01, 5.1880370797E+00, 1.8045278402E+01, 3.6300619460E+00, 9.7061123334E-01],
	[4.1655000000E+04, 3.6624172920E+01, 5.1880736541E+00, 1.8052348712E+01, 3.6304414733E+00, 9.7062369446E-01],
	[4.1660000000E+04, 3.6631865292E+01, 5.1881102244E+00, 1.8059420943E+01, 3.6308209064E+00, 9.7063614958E-01],
	[4.1665000000E+04, 3.6639558356E+01, 5.1881467906E+00, 1.8066495094E+01, 3.6312002452E+00, 9.7064859868E-01],
	[4.1670000000E+04, 3.6647252112E+01, 5.1881833527E+00, 1.8073571165E+01, 3.6315794898E+00, 9.7066104177E-01],
	[4.1675000000E+04, 3.6654946560E+01, 5.1882199106E+00, 1.8080649157E+01, 3.6319586401E+00, 9.7067347887E-01],
	[4.1680000000E+04, 3.6662641700E+01, 5.1882564644E+00, 1.8087729070E+01, 3.6323376962E+00, 9.7068590996E-01],
	[4.1685000000E+04, 3.6670337532E+01, 5.1882930141E+00, 1.8094810905E+01, 3.6327166582E+00, 9.7069833506E-01],
	[4.1690000000E+04, 3.6678034057E+01, 5.1883295596E+00, 1.8101894662E+01, 3.6330955259E+00, 9.7071075416E-01],
	[4.1695000000E+04, 3.6685731273E+01, 5.1883661010E+00, 1.8108980340E+01, 3.6334742996E+00, 9.7072316727E-01],
	[4.1700000000E+04, 3.6693429182E+01, 5.1884026383E+00, 1.8116067941E+01, 3.6338529790E+00, 9.7073557440E-01],
	[4.1705000000E+04, 3.6701127782E+01, 5.1884391715E+00, 1.8123157464E+01, 3.6342315644E+00, 9.7074797554E-01],
	[4.1710000000E+04, 3.6708827075E+01, 5.1884757006E+00, 1.8130248910E+01, 3.6346100557E+00, 9.7076037070E-01],
	[4.1715000000E+04, 3.6716527059E+01, 5.1885122255E+00, 1.8137342280E+01, 3.6349884530E+00, 9.7077275988E-01],
	[4.1720000000E+04, 3.6724227736E+01, 5.1885487463E+00, 1.8144437573E+01, 3.6353667562E+00, 9.7078514309E-01],
	[4.1725000000E+04, 3.6731929104E+01, 5.1885852630E+00, 1.8151534789E+01, 3.6357449654E+00, 9.7079752032E-01],
	[4.1730000000E+04, 3.6739631165E+01, 5.1886217756E+00, 1.8158633930E+01, 3.6361230805E+00, 9.7080989159E-01],
	[4.1735000000E+04, 3.6747333917E+01, 5.1886582840E+00, 1.8165734995E+01, 3.6365011017E+00, 9.7082225690E-01],
	[4.1740000000E+04, 3.6755037362E+01, 5.1886947884E+00, 1.8172837985E+01, 3.6368790289E+00, 9.7083461624E-01],
	[4.1745000000E+04, 3.6762741498E+01, 5.1887312886E+00, 1.8179942899E+01, 3.6372568622E+00, 9.7084696962E-01],
	[4.1750000000E+04, 3.6770446326E+01, 5.1887677847E+00, 1.8187049739E+01, 3.6376346016E+00, 9.7085931705E-01],
	[4.1755000000E+04, 3.6778151845E+01, 5.1888042767E+00, 1.8194158504E+01, 3.6380122470E+00, 9.7087165853E-01],
	[4.1760000000E+04, 3.6785858057E+01, 5.1888407646E+00, 1.8201269195E+01, 3.6383897986E+00, 9.7088399405E-01],
	[4.1765000000E+04, 3.6793564960E+01, 5.1888772483E+00, 1.8208381813E+01, 3.6387672563E+00, 9.7089632364E-01],
	[4.1770000000E+04, 3.6801272556E+01, 5.1889137280E+00, 1.8215496356E+01, 3.6391446202E+00, 9.7090864727E-01],
	[4.1775000000E+04, 3.6808980843E+01, 5.1889502035E+00, 1.8222612826E+01, 3.6395218902E+00, 9.7092096497E-01],
	[4.1780000000E+04, 3.6816689821E+01, 5.1889866750E+00, 1.8229731223E+01, 3.6398990665E+00, 9.7093327674E-01],
	[4.1785000000E+04, 3.6824399491E+01, 5.1890231423E+00, 1.8236851548E+01, 3.6402761490E+00, 9.7094558257E-01],
	[4.1790000000E+04, 3.6832109854E+01, 5.1890596055E+00, 1.8243973800E+01, 3.6406531377E+00, 9.7095788247E-01],
	[4.1795000000E+04, 3.6839820907E+01, 5.1890960646E+00, 1.8251097979E+01, 3.6410300327E+00, 9.7097017645E-01],
	[4.1800000000E+04, 3.6847532653E+01, 5.1891325196E+00, 1.8258224087E+01, 3.6414068339E+00, 9.7098246450E-01],
	[4.1805000000E+04, 3.6855245089E+01, 5.1891689706E+00, 1.8265352124E+01, 3.6417835415E+00, 9.7099474663E-01],
	[4.1810000000E+04, 3.6862958218E+01, 5.1892054174E+00, 1.8272482088E+01, 3.6421601554E+00, 9.7100702284E-01],
	[4.1815000000E+04, 3.6870672038E+01, 5.1892418601E+00, 1.8279613982E+01, 3.6425366756E+00, 9.7101929314E-01],
	[4.1820000000E+04, 3.6878386550E+01, 5.1892782987E+00, 1.8286747806E+01, 3.6429131022E+00, 9.7103155753E-01],
	[4.1825000000E+04, 3.6886101753E+01, 5.1893147332E+00, 1.8293883558E+01, 3.6432894351E+00, 9.7104381602E-01],
	[4.1830000000E+04, 3.6893834500E+01, 5.1893531900E+00, 1.8301021241E+01, 3.6436668379E+00, 9.7105606859E-01],
	[4.1835000000E+04, 3.6901568058E+01, 5.1893916562E+00, 1.8308160854E+01, 3.6440441553E+00, 9.7106831527E-01],
	[4.1840000000E+04, 3.6909302313E+01, 5.1894301182E+00, 1.8315302397E+01, 3.6444213794E+00, 9.7108055605E-01],
	[4.1845000000E+04, 3.6917037264E+01, 5.1894685758E+00, 1.8322445871E+01, 3.6447985102E+00, 9.7109279093E-01],
	[4.1850000000E+04, 3.6924772912E+01, 5.1895070291E+00, 1.8329591276E+01, 3.6451755477E+00, 9.7110501993E-01],
	[4.1855000000E+04, 3.6932509256E+01, 5.1895454782E+00, 1.8336738612E+01, 3.6455524920E+00, 9.7111724303E-01],
	[4.1860000000E+04, 3.6940246297E+01, 5.1895839229E+00, 1.8343887880E+01, 3.6459293431E+00, 9.7112946025E-01],
	[4.1865000000E+04, 3.6947984034E+01, 5.1896223633E+00, 1.8351039080E+01, 3.6463061010E+00, 9.7114167159E-01],
	[4.1870000000E+04, 3.6955722467E+01, 5.1896607994E+00, 1.8358192212E+01, 3.6466827657E+00, 9.7115387704E-01],
	[4.1875000000E+04, 3.6963461597E+01, 5.1896992312E+00, 1.8365347277E+01, 3.6470593373E+00, 9.7116607663E-01],
	[4.1880000000E+04, 3.6971201424E+01, 5.1897376587E+00, 1.8372504274E+01, 3.6474358157E+00, 9.7117827034E-01],
	[4.1885000000E+04, 3.6978941946E+01, 5.1897760818E+00, 1.8379663204E+01, 3.6478122010E+00, 9.7119045818E-01],
	[4.1890000000E+04, 3.6986683165E+01, 5.1898145007E+00, 1.8386824068E+01, 3.6481884933E+00, 9.7120264015E-01],
	[4.1895000000E+04, 3.6994425081E+01, 5.1898529153E+00, 1.8393986865E+01, 3.6485646924E+00, 9.7121481626E-01],
	[4.1900000000E+04, 3.7002167692E+01, 5.1898913256E+00, 1.8401151596E+01, 3.6489407986E+00, 9.7122698651E-01],
	[4.1905000000E+04, 3.7009911000E+01, 5.1899297316E+00, 1.8408318262E+01, 3.6493168116E+00, 9.7123915090E-01],
	[4.1910000000E+04, 3.7017655005E+01, 5.1899681333E+00, 1.8415486862E+01, 3.6496927317E+00, 9.7125130944E-01],
	[4.1915000000E+04, 3.7025399705E+01, 5.1900065307E+00, 1.8422657396E+01, 3.6500685588E+00, 9.7126346213E-01],
	[4.1920000000E+04, 3.7033145102E+01, 5.1900449237E+00, 1.8429829866E+01, 3.6504442929E+00, 9.7127560898E-01],
	[4.1925000000E+04, 3.7040891195E+01, 5.1900833125E+00, 1.8437004271E+01, 3.6508199341E+00, 9.7128774997E-01],
	[4.1930000000E+04, 3.7048637984E+01, 5.1901216970E+00, 1.8444180612E+01, 3.6511954823E+00, 9.7129988513E-01],
	[4.1935000000E+04, 3.7056385469E+01, 5.1901600773E+00, 1.8451358889E+01, 3.6515709376E+00, 9.7131201445E-01],
	[4.1940000000E+04, 3.7064133651E+01, 5.1901984532E+00, 1.8458539102E+01, 3.6519463000E+00, 9.7132413794E-01],
	[4.1945000000E+04, 3.7071882528E+01, 5.1902368248E+00, 1.8465721252E+01, 3.6523215696E+00, 9.7133625559E-01],
	[4.1950000000E+04, 3.7079632102E+01, 5.1902751921E+00, 1.8472905339E+01, 3.6526967463E+00, 9.7134836741E-01],
	[4.1955000000E+04, 3.7087382371E+01, 5.1903135552E+00, 1.8480091362E+01, 3.6530718302E+00, 9.7136047341E-01],
	[4.1960000000E+04, 3.7095133337E+01, 5.1903519139E+00, 1.8487279323E+01, 3.6534468213E+00, 9.7137257359E-01],
	[4.1965000000E+04, 3.7102884999E+01, 5.1903902684E+00, 1.8494469222E+01, 3.6538217195E+00, 9.7138466795E-01],
	[4.1970000000E+04, 3.7110637357E+01, 5.1904286186E+00, 1.8501661059E+01, 3.6541965251E+00, 9.7139675649E-01],
	[4.1975000000E+04, 3.7118390411E+01, 5.1904669645E+00, 1.8508854834E+01, 3.6545712378E+00, 9.7140883922E-01],
	[4.1980000000E+04, 3.7126144161E+01, 5.1905053061E+00, 1.8516050548E+01, 3.6549458579E+00, 9.7142091614E-01],
	[4.1985000000E+04, 3.7133898606E+01, 5.1905436434E+00, 1.8523248200E+01, 3.6553203852E+00, 9.7143298725E-01],
	[4.1990000000E+04, 3.7141653748E+01, 5.1905819765E+00, 1.8530447792E+01, 3.6556948199E+00, 9.7144505256E-01],
	[4.1995000000E+04, 3.7149409586E+01, 5.1906203053E+00, 1.8537649323E+01, 3.6560691619E+00, 9.7145711207E-01],
	[4.2000000000E+04, 3.7157166119E+01, 5.1906586298E+00, 1.8544852794E+01, 3.6564434112E+00, 9.7146916579E-01],
	[4.2005000000E+04, 3.7164923349E+01, 5.1906969500E+00, 1.8552058205E+01, 3.6568175679E+00, 9.7148121371E-01],
	[4.2010000000E+04, 3.7172681274E+01, 5.1907352659E+00, 1.8559265556E+01, 3.6571916320E+00, 9.7149325584E-01],
	[4.2015000000E+04, 3.7180439895E+01, 5.1907735776E+00, 1.8566474848E+01, 3.6575656036E+00, 9.7150529218E-01],
	[4.2020000000E+04, 3.7188199212E+01, 5.1908118849E+00, 1.8573686081E+01, 3.6579394825E+00, 9.7151732273E-01],
	[4.2025000000E+04, 3.7195959225E+01, 5.1908501880E+00, 1.8580899255E+01, 3.6583132689E+00, 9.7152934751E-01],
	[4.2030000000E+04, 3.7203719933E+01, 5.1908884869E+00, 1.8588114370E+01, 3.6586869628E+00, 9.7154136651E-01],
	[4.2035000000E+04, 3.7211481337E+01, 5.1909267814E+00, 1.8595331428E+01, 3.6590605642E+00, 9.7155337973E-01],
	[4.2040000000E+04, 3.7219243437E+01, 5.1909650717E+00, 1.8602550427E+01, 3.6594340732E+00, 9.7156538718E-01],
	[4.2045000000E+04, 3.7227006233E+01, 5.1910033577E+00, 1.8609771369E+01, 3.6598074896E+00, 9.7157738886E-01],
	[4.2050000000E+04, 3.7234769725E+01, 5.1910416395E+00, 1.8616994253E+01, 3.6601808136E+00, 9.7158938478E-01],
	[4.2055000000E+04, 3.7242533912E+01, 5.1910799169E+00, 1.8624219080E+01, 3.6605540452E+00, 9.7160137493E-01],
	[4.2060000000E+04, 3.7250298794E+01, 5.1911181901E+00, 1.8631445851E+01, 3.6609271844E+00, 9.7161335932E-01],
	[4.2065000000E+04, 3.7258064373E+01, 5.1911564591E+00, 1.8638674565E+01, 3.6613002312E+00, 9.7162533796E-01],
	[4.2070000000E+04, 3.7265830647E+01, 5.1911947237E+00, 1.8645905223E+01, 3.6616731856E+00, 9.7163731084E-01],
	[4.2075000000E+04, 3.7273597616E+01, 5.1912329841E+00, 1.8653137825E+01, 3.6620460477E+00, 9.7164927798E-01],
	[4.2080000000E+04, 3.7281365282E+01, 5.1912712403E+00, 1.8660372372E+01, 3.6624188175E+00, 9.7166123936E-01],
	[4.2085000000E+04, 3.7289133642E+01, 5.1913094922E+00, 1.8667608863E+01, 3.6627914950E+00, 9.7167319501E-01],
	[4.2090000000E+04, 3.7296902698E+01, 5.1913477398E+00, 1.8674847299E+01, 3.6631640802E+00, 9.7168514491E-01],
	[4.2095000000E+04, 3.7304672450E+01, 5.1913859831E+00, 1.8682087680E+01, 3.6635365731E+00, 9.7169708907E-01],
	[4.2100000000E+04, 3.7312442897E+01, 5.1914242222E+00, 1.8689330007E+01, 3.6639089738E+00, 9.7170902750E-01],
	[4.2105000000E+04, 3.7320214040E+01, 5.1914624570E+00, 1.8696574280E+01, 3.6642812823E+00, 9.7172096020E-01],
	[4.2110000000E+04, 3.7327985878E+01, 5.1915006876E+00, 1.8703820499E+01, 3.6646534986E+00, 9.7173288717E-01],
	[4.2115000000E+04, 3.7335758412E+01, 5.1915389139E+00, 1.8711068665E+01, 3.6650256227E+00, 9.7174480842E-01],
	[4.2120000000E+04, 3.7343531641E+01, 5.1915771360E+00, 1.8718318777E+01, 3.6653976547E+00, 9.7175672394E-01],
	[4.2125000000E+04, 3.7351305565E+01, 5.1916153538E+00, 1.8725570836E+01, 3.6657695945E+00, 9.7176863374E-01],
	[4.2130000000E+04, 3.7359080185E+01, 5.1916535673E+00, 1.8732824843E+01, 3.6661414422E+00, 9.7178053783E-01],
	[4.2135000000E+04, 3.7366855500E+01, 5.1916917766E+00, 1.8740080797E+01, 3.6665131978E+00, 9.7179243621E-01],
	[4.2140000000E+04, 3.7374631511E+01, 5.1917299817E+00, 1.8747338699E+01, 3.6668848614E+00, 9.7180432887E-01],
	[4.2145000000E+04, 3.7382408216E+01, 5.1917681825E+00, 1.8754598549E+01, 3.6672564328E+00, 9.7181621583E-01],
	[4.2150000000E+04, 3.7390185617E+01, 5.1918063790E+00, 1.8761860348E+01, 3.6676279123E+00, 9.7182809709E-01],
	[4.2155000000E+04, 3.7397963714E+01, 5.1918445713E+00, 1.8769124095E+01, 3.6679992997E+00, 9.7183997264E-01],
	[4.2160000000E+04, 3.7405742505E+01, 5.1918827593E+00, 1.8776389792E+01, 3.6683705952E+00, 9.7185184250E-01],
	[4.2165000000E+04, 3.7413521992E+01, 5.1919209431E+00, 1.8783657438E+01, 3.6687417986E+00, 9.7186370667E-01],
	[4.2170000000E+04, 3.7421302174E+01, 5.1919591227E+00, 1.8790927033E+01, 3.6691129101E+00, 9.7187556514E-01],
	[4.2175000000E+04, 3.7429083051E+01, 5.1919972980E+00, 1.8798198579E+01, 3.6694839297E+00, 9.7188741792E-01],
	[4.2180000000E+04, 3.7436864623E+01, 5.1920354690E+00, 1.8805472074E+01, 3.6698548574E+00, 9.7189926502E-01],
	[4.2185000000E+04, 3.7444646891E+01, 5.1920736359E+00, 1.8812747521E+01, 3.6702256931E+00, 9.7191110644E-01],
	[4.2190000000E+04, 3.7452429853E+01, 5.1921117984E+00, 1.8820024918E+01, 3.6705964371E+00, 9.7192294218E-01],
	[4.2195000000E+04, 3.7460213511E+01, 5.1921499568E+00, 1.8827304266E+01, 3.6709670891E+00, 9.7193477224E-01],
	[4.2200000000E+04, 3.7467997864E+01, 5.1921881108E+00, 1.8834585565E+01, 3.6713376493E+00, 9.7194659664E-01],
	[4.2205000000E+04, 3.7475782912E+01, 5.1922262607E+00, 1.8841868817E+01, 3.6717081177E+00, 9.7195841536E-01],
	[4.2210000000E+04, 3.7483568655E+01, 5.1922644063E+00, 1.8849154020E+01, 3.6720784944E+00, 9.7197022841E-01],
	[4.2215000000E+04, 3.7491355092E+01, 5.1923025477E+00, 1.8856441175E+01, 3.6724487792E+00, 9.7198203581E-01],
	[4.2220000000E+04, 3.7499142225E+01, 5.1923406848E+00, 1.8863730283E+01, 3.6728189723E+00, 9.7199383754E-01],
	[4.2225000000E+04, 3.7506930053E+01, 5.1923788177E+00, 1.8871021344E+01, 3.6731890737E+00, 9.7200563361E-01],
	[4.2230000000E+04, 3.7514718576E+01, 5.1924169463E+00, 1.8878314358E+01, 3.6735590834E+00, 9.7201742403E-01],
	[4.2235000000E+04, 3.7522507794E+01, 5.1924550708E+00, 1.8885609326E+01, 3.6739290013E+00, 9.7202920880E-01],
	[4.2240000000E+04, 3.7530297707E+01, 5.1924931910E+00, 1.8892906247E+01, 3.6742988277E+00, 9.7204098793E-01],
	[4.2245000000E+04, 3.7538088314E+01, 5.1925313069E+00, 1.8900205122E+01, 3.6746685623E+00, 9.7205276140E-01],
	[4.2250000000E+04, 3.7545879617E+01, 5.1925694187E+00, 1.8907505952E+01, 3.6750382054E+00, 9.7206452924E-01],
	[4.2255000000E+04, 3.7553671614E+01, 5.1926075262E+00, 1.8914808736E+01, 3.6754077568E+00, 9.7207629144E-01],
	[4.2260000000E+04, 3.7561464306E+01, 5.1926456294E+00, 1.8922113475E+01, 3.6757772167E+00, 9.7208804800E-01],
	[4.2265000000E+04, 3.7569257693E+01, 5.1926837285E+00, 1.8929420169E+01, 3.6761465849E+00, 9.7209979893E-01],
	[4.2270000000E+04, 3.7577051775E+01, 5.1927218233E+00, 1.8936728819E+01, 3.6765158617E+00, 9.7211154423E-01],
	[4.2275000000E+04, 3.7584846552E+01, 5.1927599139E+00, 1.8944039424E+01, 3.6768850469E+00, 9.7212328390E-01],
	[4.2280000000E+04, 3.7592642023E+01, 5.1927980002E+00, 1.8951351986E+01, 3.6772541406E+00, 9.7213501795E-01],
	[4.2285000000E+04, 3.7600438189E+01, 5.1928360824E+00, 1.8958666504E+01, 3.6776231429E+00, 9.7214674638E-01],
	[4.2290000000E+04, 3.7608235050E+01, 5.1928741603E+00, 1.8965982978E+01, 3.6779920536E+00, 9.7215846919E-01],
	[4.2295000000E+04, 3.7616032606E+01, 5.1929122340E+00, 1.8973301410E+01, 3.6783608729E+00, 9.7217018639E-01],
	[4.2300000000E+04, 3.7623830856E+01, 5.1929503034E+00, 1.8980621798E+01, 3.6787296009E+00, 9.7218189798E-01],
	[4.2305000000E+04, 3.7631629801E+01, 5.1929883687E+00, 1.8987944145E+01, 3.6790982374E+00, 9.7219360396E-01],
	[4.2310000000E+04, 3.7639429440E+01, 5.1930264297E+00, 1.8995268449E+01, 3.6794667825E+00, 9.7220530433E-01],
	[4.2315000000E+04, 3.7647229774E+01, 5.1930644865E+00, 1.9002594711E+01, 3.6798352362E+00, 9.7221699911E-01],
	[4.2320000000E+04, 3.7655030803E+01, 5.1931025391E+00, 1.9009922931E+01, 3.6802035987E+00, 9.7222868828E-01],
	[4.2325000000E+04, 3.7662832526E+01, 5.1931405875E+00, 1.9017253110E+01, 3.6805718698E+00, 9.7224037186E-01],
	[4.2330000000E+04, 3.7670634944E+01, 5.1931786317E+00, 1.9024585249E+01, 3.6809400496E+00, 9.7225204984E-01],
	[4.2335000000E+04, 3.7678438057E+01, 5.1932166716E+00, 1.9031919346E+01, 3.6813081381E+00, 9.7226372224E-01],
	[4.2340000000E+04, 3.7686241864E+01, 5.1932547073E+00, 1.9039255403E+01, 3.6816761354E+00, 9.7227538905E-01],
	[4.2345000000E+04, 3.7694046365E+01, 5.1932927389E+00, 1.9046593420E+01, 3.6820440414E+00, 9.7228705028E-01],
	[4.2350000000E+04, 3.7701851561E+01, 5.1933307662E+00, 1.9053933397E+01, 3.6824118562E+00, 9.7229870592E-01],
	[4.2355000000E+04, 3.7709657451E+01, 5.1933687893E+00, 1.9061275334E+01, 3.6827795798E+00, 9.7231035599E-01],
	[4.2360000000E+04, 3.7717464036E+01, 5.1934068081E+00, 1.9068619232E+01, 3.6831472123E+00, 9.7232200048E-01],
	[4.2365000000E+04, 3.7725271315E+01, 5.1934448228E+00, 1.9075965091E+01, 3.6835147536E+00, 9.7233363941E-01],
	[4.2370000000E+04, 3.7733079289E+01, 5.1934828333E+00, 1.9083312912E+01, 3.6838822037E+00, 9.7234527276E-01],
	[4.2375000000E+04, 3.7740887957E+01, 5.1935208396E+00, 1.9090662694E+01, 3.6842495628E+00, 9.7235690055E-01],
	[4.2380000000E+04, 3.7748697319E+01, 5.1935588416E+00, 1.9098014438E+01, 3.6846168307E+00, 9.7236852278E-01],
	[4.2385000000E+04, 3.7756507376E+01, 5.1935968395E+00, 1.9105368144E+01, 3.6849840076E+00, 9.7238013945E-01],
	[4.2390000000E+04, 3.7764318127E+01, 5.1936348331E+00, 1.9112723812E+01, 3.6853510934E+00, 9.7239175056E-01],
	[4.2395000000E+04, 3.7772129572E+01, 5.1936728225E+00, 1.9120081444E+01, 3.6857180882E+00, 9.7240335612E-01],
	[4.2400000000E+04, 3.7779941711E+01, 5.1937108078E+00, 1.9127441038E+01, 3.6860849919E+00, 9.7241495613E-01],
	[4.2405000000E+04, 3.7787754545E+01, 5.1937487888E+00, 1.9134802596E+01, 3.6864518047E+00, 9.7242655059E-01],
	[4.2410000000E+04, 3.7795568073E+01, 5.1937867657E+00, 1.9142166117E+01, 3.6868185265E+00, 9.7243813951E-01],
	[4.2415000000E+04, 3.7803382296E+01, 5.1938247383E+00, 1.9149531603E+01, 3.6871851574E+00, 9.7244972288E-01],
	[4.2420000000E+04, 3.7811197212E+01, 5.1938627067E+00, 1.9156899052E+01, 3.6875516973E+00, 9.7246130072E-01],
	[4.2425000000E+04, 3.7819012823E+01, 5.1939006710E+00, 1.9164268466E+01, 3.6879181463E+00, 9.7247287303E-01],
	[4.2430000000E+04, 3.7826829127E+01, 5.1939386310E+00, 1.9171639845E+01, 3.6882845045E+00, 9.7248443980E-01],
	[4.2435000000E+04, 3.7834646126E+01, 5.1939765869E+00, 1.9179013189E+01, 3.6886507717E+00, 9.7249600104E-01],
	[4.2440000000E+04, 3.7842463819E+01, 5.1940145385E+00, 1.9186388498E+01, 3.6890169481E+00, 9.7250755676E-01],
	[4.2445000000E+04, 3.7850282206E+01, 5.1940524860E+00, 1.9193765773E+01, 3.6893830337E+00, 9.7251910696E-01],
	[4.2450000000E+04, 3.7858101288E+01, 5.1940904293E+00, 1.9201145014E+01, 3.6897490285E+00, 9.7253065163E-01],
	[4.2455000000E+04, 3.7865921063E+01, 5.1941283684E+00, 1.9208526222E+01, 3.6901149325E+00, 9.7254219079E-01],
	[4.2460000000E+04, 3.7873741532E+01, 5.1941663032E+00, 1.9215909396E+01, 3.6904807457E+00, 9.7255372444E-01],
	[4.2465000000E+04, 3.7881562695E+01, 5.1942042339E+00, 1.9223294536E+01, 3.6908464682E+00, 9.7256525257E-01],
	[4.2470000000E+04, 3.7889384553E+01, 5.1942421604E+00, 1.9230681644E+01, 3.6912120999E+00, 9.7257677520E-01],
	[4.2475000000E+04, 3.7897207104E+01, 5.1942800828E+00, 1.9238070719E+01, 3.6915776410E+00, 9.7258829232E-01],
	[4.2480000000E+04, 3.7905030349E+01, 5.1943180009E+00, 1.9245461762E+01, 3.6919430914E+00, 9.7259980394E-01],
	[4.2485000000E+04, 3.7912854288E+01, 5.1943559149E+00, 1.9252854773E+01, 3.6923084511E+00, 9.7261131007E-01],
	[4.2490000000E+04, 3.7920678921E+01, 5.1943938246E+00, 1.9260249753E+01, 3.6926737201E+00, 9.7262281069E-01],
	[4.2495000000E+04, 3.7928504248E+01, 5.1944317302E+00, 1.9267646701E+01, 3.6930388986E+00, 9.7263430583E-01],
	[4.2500000000E+04, 3.7936335796E+01, 5.1944702861E+00, 1.9275045617E+01, 3.6934043696E+00, 9.7264579547E-01],
	[4.2505000000E+04, 3.7944179362E+01, 5.1945101782E+00, 1.9282446503E+01, 3.6937705354E+00, 9.7265727963E-01],
	[4.2510000000E+04, 3.7952023628E+01, 5.1945500660E+00, 1.9289849359E+01, 3.6941366108E+00, 9.7266875831E-01],
	[4.2515000000E+04, 3.7959868592E+01, 5.1945899494E+00, 1.9297254184E+01, 3.6945025960E+00, 9.7268023150E-01],
	[4.2520000000E+04, 3.7967714254E+01, 5.1946298284E+00, 1.9304660979E+01, 3.6948684908E+00, 9.7269169922E-01],
	[4.2525000000E+04, 3.7975560616E+01, 5.1946697030E+00, 1.9312069745E+01, 3.6952342954E+00, 9.7270316146E-01],
	[4.2530000000E+04, 3.7983407676E+01, 5.1947095733E+00, 1.9319480481E+01, 3.6956000098E+00, 9.7271461824E-01],
	[4.2535000000E+04, 3.7991255435E+01, 5.1947494392E+00, 1.9326893189E+01, 3.6959656340E+00, 9.7272606954E-01],
	[4.2540000000E+04, 3.7999103893E+01, 5.1947893007E+00, 1.9334307867E+01, 3.6963311679E+00, 9.7273751538E-01],
	[4.2545000000E+04, 3.8006953049E+01, 5.1948291578E+00, 1.9341724517E+01, 3.6966966117E+00, 9.7274895575E-01],
	[4.2550000000E+04, 3.8014802904E+01, 5.1948690105E+00, 1.9349143139E+01, 3.6970619653E+00, 9.7276039067E-01],
	[4.2555000000E+04, 3.8022653458E+01, 5.1949088588E+00, 1.9356563733E+01, 3.6974272288E+00, 9.7277182013E-01],
	[4.2560000000E+04, 3.8030504710E+01, 5.1949487028E+00, 1.9363986299E+01, 3.6977924022E+00, 9.7278324413E-01],
	[4.2565000000E+04, 3.8038356661E+01, 5.1949885424E+00, 1.9371410838E+01, 3.6981574855E+00, 9.7279466269E-01],
	[4.2570000000E+04, 3.8046209310E+01, 5.1950283777E+00, 1.9378837350E+01, 3.6985224787E+00, 9.7280607580E-01],
	[4.2575000000E+04, 3.8054062658E+01, 5.1950682085E+00, 1.9386265835E+01, 3.6988873819E+00, 9.7281748346E-01],
	[4.2580000000E+04, 3.8061916705E+01, 5.1951080350E+00, 1.9393696294E+01, 3.6992521950E+00, 9.7282888568E-01],
	[4.2585000000E+04, 3.8069771450E+01, 5.1951478571E+00, 1.9401128727E+01, 3.6996169181E+00, 9.7284028246E-01],
	[4.2590000000E+04, 3.8077626893E+01, 5.1951876748E+00, 1.9408563134E+01, 3.6999815513E+00, 9.7285167380E-01],
	[4.2595000000E+04, 3.8085483035E+01, 5.1952274882E+00, 1.9415999515E+01, 3.7003460944E+00, 9.7286305971E-01],
	[4.2600000000E+04, 3.8093339875E+01, 5.1952672972E+00, 1.9423437871E+01, 3.7007105476E+00, 9.7287444018E-01],
	[4.2605000000E+04, 3.8101197414E+01, 5.1953071019E+00, 1.9430878202E+01, 3.7010749109E+00, 9.7288581522E-01],
	[4.2610000000E+04, 3.8109055651E+01, 5.1953469021E+00, 1.9438320508E+01, 3.7014391843E+00, 9.7289718484E-01],
	[4.2615000000E+04, 3.8116914587E+01, 5.1953866980E+00, 1.9445764790E+01, 3.7018033678E+00, 9.7290854903E-01],
	[4.2620000000E+04, 3.8124774221E+01, 5.1954264896E+00, 1.9453211048E+01, 3.7021674614E+00, 9.7291990779E-01],
	[4.2625000000E+04, 3.8132634553E+01, 5.1954662768E+00, 1.9460659282E+01, 3.7025314652E+00, 9.7293126114E-01],
	[4.2630000000E+04, 3.8140495584E+01, 5.1955060596E+00, 1.9468109493E+01, 3.7028953791E+00, 9.7294260907E-01],
	[4.2635000000E+04, 3.8148357313E+01, 5.1955458380E+00, 1.9475561680E+01, 3.7032592032E+00, 9.7295395159E-01],
	[4.2640000000E+04, 3.8156219740E+01, 5.1955856121E+00, 1.9483015844E+01, 3.7036229376E+00, 9.7296528869E-01],
	[4.2645000000E+04, 3.8164082866E+01, 5.1956253819E+00, 1.9490471986E+01, 3.7039865822E+00, 9.7297662038E-01],
	[4.2650000000E+04, 3.8171946690E+01, 5.1956651472E+00, 1.9497930105E+01, 3.7043501370E+00, 9.7298794667E-01],
	[4.2655000000E+04, 3.8179811212E+01, 5.1957049083E+00, 1.9505390203E+01, 3.7047136021E+00, 9.7299926755E-01],
	[4.2660000000E+04, 3.8187676432E+01, 5.1957446649E+00, 1.9512852278E+01, 3.7050769775E+00, 9.7301058304E-01],
	[4.2665000000E+04, 3.8195542350E+01, 5.1957844172E+00, 1.9520316332E+01, 3.7054402632E+00, 9.7302189312E-01],
	[4.2670000000E+04, 3.8203408967E+01, 5.1958241652E+00, 1.9527782365E+01, 3.7058034593E+00, 9.7303319780E-01],
	[4.2675000000E+04, 3.8211276282E+01, 5.1958639088E+00, 1.9535250377E+01, 3.7061665657E+00, 9.7304449710E-01],
	[4.2680000000E+04, 3.8219144295E+01, 5.1959036480E+00, 1.9542720369E+01, 3.7065295825E+00, 9.7305579100E-01],
	[4.2685000000E+04, 3.8227013006E+01, 5.1959433829E+00, 1.9550192340E+01, 3.7068925097E+00, 9.7306707951E-01],
	[4.2690000000E+04, 3.8234882415E+01, 5.1959831135E+00, 1.9557666291E+01, 3.7072553473E+00, 9.7307836264E-01],
	[4.2695000000E+04, 3.8242752522E+01, 5.1960228397E+00, 1.9565142222E+01, 3.7076180953E+00, 9.7308964038E-01],
	[4.2700000000E+04, 3.8250623327E+01, 5.1960625615E+00, 1.9572620134E+01, 3.7079807538E+00, 9.7310091275E-01],
	[4.2705000000E+04, 3.8258494830E+01, 5.1961022790E+00, 1.9580100027E+01, 3.7083433228E+00, 9.7311217973E-01],
	[4.2710000000E+04, 3.8266367031E+01, 5.1961419922E+00, 1.9587581901E+01, 3.7087058023E+00, 9.7312344134E-01],
	[4.2715000000E+04, 3.8274239931E+01, 5.1961817010E+00, 1.9595065757E+01, 3.7090681923E+00, 9.7313469758E-01],
	[4.2720000000E+04, 3.8282113528E+01, 5.1962214055E+00, 1.9602551594E+01, 3.7094304928E+00, 9.7314594845E-01],
	[4.2725000000E+04, 3.8289987823E+01, 5.1962611056E+00, 1.9610039413E+01, 3.7097927039E+00, 9.7315719395E-01],
	[4.2730000000E+04, 3.8297862816E+01, 5.1963008014E+00, 1.9617529215E+01, 3.7101548256E+00, 9.7316843408E-01],
	[4.2735000000E+04, 3.8305738507E+01, 5.1963404928E+00, 1.9625020999E+01, 3.7105168579E+00, 9.7317966886E-01],
	[4.2740000000E+04, 3.8313614896E+01, 5.1963801799E+00, 1.9632514766E+01, 3.7108788008E+00, 9.7319089827E-01],
	[4.2745000000E+04, 3.8321491983E+01, 5.1964198626E+00, 1.9640010516E+01, 3.7112406543E+00, 9.7320212232E-01],
	[4.2750000000E+04, 3.8329369768E+01, 5.1964595411E+00, 1.9647508250E+01, 3.7116024185E+00, 9.7321334103E-01],
	[4.2755000000E+04, 3.8337248250E+01, 5.1964992151E+00, 1.9655007968E+01, 3.7119640934E+00, 9.7322455438E-01],
	[4.2760000000E+04, 3.8345127431E+01, 5.1965388849E+00, 1.9662509669E+01, 3.7123256790E+00, 9.7323576238E-01],
	[4.2765000000E+04, 3.8353007309E+01, 5.1965785503E+00, 1.9670013355E+01, 3.7126871753E+00, 9.7324696503E-01],
	[4.2770000000E+04, 3.8360887884E+01, 5.1966182114E+00, 1.9677519026E+01, 3.7130485824E+00, 9.7325816234E-01],
	[4.2775000000E+04, 3.8368769158E+01, 5.1966578681E+00, 1.9685026682E+01, 3.7134099002E+00, 9.7326935431E-01],
	[4.2780000000E+04, 3.8376651129E+01, 5.1966975205E+00, 1.9692536323E+01, 3.7137711288E+00, 9.7328054094E-01],
	[4.2785000000E+04, 3.8384533799E+01, 5.1967371686E+00, 1.9700047949E+01, 3.7141322682E+00, 9.7329172224E-01],
	[4.2790000000E+04, 3.8392417165E+01, 5.1967768124E+00, 1.9707561562E+01, 3.7144933184E+00, 9.7330289820E-01],
	[4.2795000000E+04, 3.8400301230E+01, 5.1968164518E+00, 1.9715077160E+01, 3.7148542795E+00, 9.7331406883E-01],
	[4.2800000000E+04, 3.8408185992E+01, 5.1968560869E+00, 1.9722594745E+01, 3.7152151515E+00, 9.7332523413E-01],
	[4.2805000000E+04, 3.8416071452E+01, 5.1968957176E+00, 1.9730114317E+01, 3.7155759343E+00, 9.7333639410E-01],
	[4.2810000000E+04, 3.8423957609E+01, 5.1969353441E+00, 1.9737635875E+01, 3.7159366281E+00, 9.7334754876E-01],
	[4.2815000000E+04, 3.8431844464E+01, 5.1969749662E+00, 1.9745159421E+01, 3.7162972328E+00, 9.7335869809E-01],
	[4.2820000000E+04, 3.8439732017E+01, 5.1970145839E+00, 1.9752684955E+01, 3.7166577484E+00, 9.7336984210E-01],
	[4.2825000000E+04, 3.8447620267E+01, 5.1970541974E+00, 1.9760212476E+01, 3.7170181750E+00, 9.7338098080E-01],
	[4.2830000000E+04, 3.8455509214E+01, 5.1970938065E+00, 1.9767741986E+01, 3.7173785126E+00, 9.7339211419E-01],
	[4.2835000000E+04, 3.8463398859E+01, 5.1971334114E+00, 1.9775273484E+01, 3.7177387612E+00, 9.7340324227E-01],
	[4.2840000000E+04, 3.8471289202E+01, 5.1971730118E+00, 1.9782806970E+01, 3.7180989208E+00, 9.7341436504E-01],
	[4.2845000000E+04, 3.8479180242E+01, 5.1972126080E+00, 1.9790342446E+01, 3.7184589915E+00, 9.7342548250E-01],
	[4.2850000000E+04, 3.8487071980E+01, 5.1972521999E+00, 1.9797879911E+01, 3.7188189732E+00, 9.7343659467E-01],
	[4.2855000000E+04, 3.8494964415E+01, 5.1972917874E+00, 1.9805419366E+01, 3.7191788661E+00, 9.7344770153E-01],
	[4.2860000000E+04, 3.8502857547E+01, 5.1973313706E+00, 1.9812960811E+01, 3.7195386700E+00, 9.7345880310E-01],
	[4.2865000000E+04, 3.8510751377E+01, 5.1973709495E+00, 1.9820504246E+01, 3.7198983851E+00, 9.7346989937E-01],
	[4.2870000000E+04, 3.8518645904E+01, 5.1974105241E+00, 1.9828049671E+01, 3.7202580113E+00, 9.7348099035E-01],
	[4.2875000000E+04, 3.8526541129E+01, 5.1974500944E+00, 1.9835597088E+01, 3.7206175488E+00, 9.7349207604E-01],
	[4.2880000000E+04, 3.8534437051E+01, 5.1974896604E+00, 1.9843146495E+01, 3.7209769974E+00, 9.7350315644E-01],
	[4.2885000000E+04, 3.8542333670E+01, 5.1975292220E+00, 1.9850697894E+01, 3.7213363572E+00, 9.7351423156E-01],
	[4.2890000000E+04, 3.8550230987E+01, 5.1975687793E+00, 1.9858251284E+01, 3.7216956282E+00, 9.7352530140E-01],
	[4.2895000000E+04, 3.8558129001E+01, 5.1976083324E+00, 1.9865806667E+01, 3.7220548106E+00, 9.7353636596E-01],
	[4.2900000000E+04, 3.8566027712E+01, 5.1976478811E+00, 1.9873364042E+01, 3.7224139042E+00, 9.7354742525E-01],
	[4.2905000000E+04, 3.8573927120E+01, 5.1976874255E+00, 1.9880923409E+01, 3.7227729090E+00, 9.7355847926E-01],
	[4.2910000000E+04, 3.8581827226E+01, 5.1977269656E+00, 1.9888484769E+01, 3.7231318252E+00, 9.7356952800E-01],
	[4.2915000000E+04, 3.8589728028E+01, 5.1977665014E+00, 1.9896048122E+01, 3.7234906528E+00, 9.7358057147E-01],
	[4.2920000000E+04, 3.8597629528E+01, 5.1978060329E+00, 1.9903613469E+01, 3.7238493917E+00, 9.7359160968E-01],
	[4.2925000000E+04, 3.8605531725E+01, 5.1978455601E+00, 1.9911180810E+01, 3.7242080420E+00, 9.7360264262E-01],
	[4.2930000000E+04, 3.8613434620E+01, 5.1978850830E+00, 1.9918750144E+01, 3.7245666036E+00, 9.7361367030E-01],
	[4.2935000000E+04, 3.8621338211E+01, 5.1979246015E+00, 1.9926321473E+01, 3.7249250767E+00, 9.7362469273E-01],
	[4.2940000000E+04, 3.8629242500E+01, 5.1979641158E+00, 1.9933894796E+01, 3.7252834613E+00, 9.7363570990E-01],
	[4.2945000000E+04, 3.8637147485E+01, 5.1980036258E+00, 1.9941470115E+01, 3.7256417573E+00, 9.7364672181E-01],
	[4.2950000000E+04, 3.8645053168E+01, 5.1980431315E+00, 1.9949047428E+01, 3.7259999647E+00, 9.7365772848E-01],
	[4.2955000000E+04, 3.8652959548E+01, 5.1980826329E+00, 1.9956626737E+01, 3.7263580837E+00, 9.7366872990E-01],
	[4.2960000000E+04, 3.8660866624E+01, 5.1981221299E+00, 1.9964208042E+01, 3.7267161142E+00, 9.7367972607E-01],
	[4.2965000000E+04, 3.8668774398E+01, 5.1981616227E+00, 1.9971791343E+01, 3.7270740563E+00, 9.7369071701E-01],
	[4.2970000000E+04, 3.8676682869E+01, 5.1982011112E+00, 1.9979376640E+01, 3.7274319099E+00, 9.7370170270E-01],
	[4.2975000000E+04, 3.8684592036E+01, 5.1982405954E+00, 1.9986963934E+01, 3.7277896751E+00, 9.7371268315E-01],
	[4.2980000000E+04, 3.8692501901E+01, 5.1982800753E+00, 1.9994553225E+01, 3.7281473519E+00, 9.7372365837E-01],
	[4.2985000000E+04, 3.8700412462E+01, 5.1983195509E+00, 2.0002144513E+01, 3.7285049403E+00, 9.7373462836E-01],
	[4.2990000000E+04, 3.8708323721E+01, 5.1983590222E+00, 2.0009737799E+01, 3.7288624403E+00, 9.7374559312E-01],
	[4.2995000000E+04, 3.8716235676E+01, 5.1983984893E+00, 2.0017333083E+01, 3.7292198521E+00, 9.7375655266E-01],
	[4.3000000000E+04, 3.8724148328E+01, 5.1984379520E+00, 2.0024930364E+01, 3.7295771755E+00, 9.7376750697E-01],
	[4.3005000000E+04, 3.8732061677E+01, 5.1984774105E+00, 2.0032529644E+01, 3.7299344106E+00, 9.7377845605E-01],
	[4.3010000000E+04, 3.8739975723E+01, 5.1985168646E+00, 2.0040130923E+01, 3.7302915574E+00, 9.7378939992E-01],
	[4.3015000000E+04, 3.8747890466E+01, 5.1985563145E+00, 2.0047734201E+01, 3.7306486160E+00, 9.7380033857E-01],
	[4.3020000000E+04, 3.8755805906E+01, 5.1985957601E+00, 2.0055339478E+01, 3.7310055864E+00, 9.7381127201E-01],
	[4.3025000000E+04, 3.8763722042E+01, 5.1986352014E+00, 2.0062946755E+01, 3.7313624686E+00, 9.7382220024E-01],
	[4.3030000000E+04, 3.8771638875E+01, 5.1986746384E+00, 2.0070556031E+01, 3.7317192625E+00, 9.7383312326E-01],
	[4.3035000000E+04, 3.8779556405E+01, 5.1987140711E+00, 2.0078167308E+01, 3.7320759683E+00, 9.7384404107E-01],
	[4.3040000000E+04, 3.8787474631E+01, 5.1987534996E+00, 2.0085780585E+01, 3.7324325859E+00, 9.7385495368E-01],
	[4.3045000000E+04, 3.8795393554E+01, 5.1987929238E+00, 2.0093395863E+01, 3.7327891154E+00, 9.7386586109E-01],
	[4.3050000000E+04, 3.8803313174E+01, 5.1988323436E+00, 2.0101013142E+01, 3.7331455568E+00, 9.7387676330E-01],
	[4.3055000000E+04, 3.8811233490E+01, 5.1988717593E+00, 2.0108632422E+01, 3.7335019101E+00, 9.7388766031E-01],
	[4.3060000000E+04, 3.8819154503E+01, 5.1989111706E+00, 2.0116253704E+01, 3.7338581754E+00, 9.7389855214E-01],
	[4.3065000000E+04, 3.8827076213E+01, 5.1989505777E+00, 2.0123876988E+01, 3.7342143526E+00, 9.7390943877E-01],
	[4.3070000000E+04, 3.8834998619E+01, 5.1989899804E+00, 2.0131502274E+01, 3.7345704417E+00, 9.7392032021E-01],
	[4.3075000000E+04, 3.8842921722E+01, 5.1990293789E+00, 2.0139129563E+01, 3.7349264429E+00, 9.7393119647E-01],
	[4.3080000000E+04, 3.8850845522E+01, 5.1990687732E+00, 2.0146758855E+01, 3.7352823561E+00, 9.7394206755E-01],
	[4.3085000000E+04, 3.8858770018E+01, 5.1991081631E+00, 2.0154390149E+01, 3.7356381813E+00, 9.7395293344E-01],
	[4.3090000000E+04, 3.8866695210E+01, 5.1991475488E+00, 2.0162023447E+01, 3.7359939185E+00, 9.7396379416E-01],
	[4.3095000000E+04, 3.8874621099E+01, 5.1991869302E+00, 2.0169658749E+01, 3.7363495679E+00, 9.7397464971E-01],
	[4.3100000000E+04, 3.8882547684E+01, 5.1992263074E+00, 2.0177296055E+01, 3.7367051293E+00, 9.7398550008E-01],
	[4.3105000000E+04, 3.8890474966E+01, 5.1992656802E+00, 2.0184935364E+01, 3.7370606029E+00, 9.7399634528E-01],
	[4.3110000000E+04, 3.8898402945E+01, 5.1993050488E+00, 2.0192576679E+01, 3.7374159885E+00, 9.7400718531E-01],
	[4.3115000000E+04, 3.8906331619E+01, 5.1993444132E+00, 2.0200219998E+01, 3.7377712864E+00, 9.7401802018E-01],
	[4.3120000000E+04, 3.8914260991E+01, 5.1993837732E+00, 2.0207865323E+01, 3.7381264964E+00, 9.7402884989E-01],
	[4.3125000000E+04, 3.8922191058E+01, 5.1994231290E+00, 2.0215512653E+01, 3.7384816186E+00, 9.7403967444E-01],
	[4.3130000000E+04, 3.8930121822E+01, 5.1994624806E+00, 2.0223161988E+01, 3.7388366530E+00, 9.7405049383E-01],
	[4.3135000000E+04, 3.8938053282E+01, 5.1995018279E+00, 2.0230813330E+01, 3.7391915997E+00, 9.7406130807E-01],
	[4.3140000000E+04, 3.8945985439E+01, 5.1995411709E+00, 2.0238466678E+01, 3.7395464586E+00, 9.7407211716E-01],
	[4.3145000000E+04, 3.8953918292E+01, 5.1995805096E+00, 2.0246122033E+01, 3.7399012299E+00, 9.7408292109E-01],
	[4.3150000000E+04, 3.8961851841E+01, 5.1996198441E+00, 2.0253779395E+01, 3.7402559134E+00, 9.7409371988E-01],
	[4.3155000000E+04, 3.8969786086E+01, 5.1996591743E+00, 2.0261438763E+01, 3.7406105092E+00, 9.7410451353E-01],
	[4.3160000000E+04, 3.8977721028E+01, 5.1996985003E+00, 2.0269100140E+01, 3.7409650174E+00, 9.7411530204E-01],
	[4.3165000000E+04, 3.8985656665E+01, 5.1997378220E+00, 2.0276763524E+01, 3.7413194379E+00, 9.7412608540E-01],
	[4.3170000000E+04, 3.8993593000E+01, 5.1997771395E+00, 2.0284428916E+01, 3.7416737708E+00, 9.7413686363E-01],
	[4.3175000000E+04, 3.9001530030E+01, 5.1998164527E+00, 2.0292096316E+01, 3.7420280162E+00, 9.7414763673E-01],
	[4.3180000000E+04, 3.9009467756E+01, 5.1998557616E+00, 2.0299765726E+01, 3.7423821739E+00, 9.7415840470E-01],
	[4.3185000000E+04, 3.9017414457E+01, 5.1998960318E+00, 2.0307437144E+01, 3.7427368205E+00, 9.7416916754E-01],
	[4.3190000000E+04, 3.9025370307E+01, 5.1999372830E+00, 2.0315110571E+01, 3.7430919679E+00, 9.7417992525E-01],
	[4.3195000000E+04, 3.9033326859E+01, 5.1999785297E+00, 2.0322786008E+01, 3.7434470281E+00, 9.7419067784E-01],
	[4.3200000000E+04, 3.9041284111E+01, 5.2000197721E+00, 2.0330463455E+01, 3.7438020010E+00, 9.7420142531E-01],
	[4.3205000000E+04, 3.9049242064E+01, 5.2000610099E+00, 2.0338142912E+01, 3.7441568867E+00, 9.7421216766E-01],
	[4.3210000000E+04, 3.9057200718E+01, 5.2001022433E+00, 2.0345824380E+01, 3.7445116851E+00, 9.7422290489E-01],
	[4.3215000000E+04, 3.9065160073E+01, 5.2001434723E+00, 2.0353507858E+01, 3.7448663963E+00, 9.7423363701E-01],
	[4.3220000000E+04, 3.9073120129E+01, 5.2001846968E+00, 2.0361193347E+01, 3.7452210204E+00, 9.7424436402E-01],
	[4.3225000000E+04, 3.9081080885E+01, 5.2002259169E+00, 2.0368880847E+01, 3.7455755573E+00, 9.7425508593E-01],
	[4.3230000000E+04, 3.9089042343E+01, 5.2002671326E+00, 2.0376570359E+01, 3.7459300070E+00, 9.7426580272E-01],
	[4.3235000000E+04, 3.9097004501E+01, 5.2003083438E+00, 2.0384261883E+01, 3.7462843696E+00, 9.7427651442E-01],
	[4.3240000000E+04, 3.9104967360E+01, 5.2003495505E+00, 2.0391955419E+01, 3.7466386451E+00, 9.7428722102E-01],
	[4.3245000000E+04, 3.9112930920E+01, 5.2003907529E+00, 2.0399650968E+01, 3.7469928336E+00, 9.7429792251E-01],
	[4.3250000000E+04, 3.9120895181E+01, 5.2004319508E+00, 2.0407348529E+01, 3.7473469349E+00, 9.7430861892E-01],
	[4.3255000000E+04, 3.9128860142E+01, 5.2004731442E+00, 2.0415048104E+01, 3.7477009492E+00, 9.7431931023E-01],
	[4.3260000000E+04, 3.9136825804E+01, 5.2005143332E+00, 2.0422749692E+01, 3.7480548765E+00, 9.7432999645E-01],
	[4.3265000000E+04, 3.9144792167E+01, 5.2005555178E+00, 2.0430453293E+01, 3.7484087168E+00, 9.7434067758E-01],
	[4.3270000000E+04, 3.9152759231E+01, 5.2005966980E+00, 2.0438158909E+01, 3.7487624702E+00, 9.7435135363E-01],
	[4.3275000000E+04, 3.9160726995E+01, 5.2006378737E+00, 2.0445866538E+01, 3.7491161365E+00, 9.7436202460E-01],
	[4.3280000000E+04, 3.9168695460E+01, 5.2006790450E+00, 2.0453576182E+01, 3.7494697159E+00, 9.7437269049E-01],
	[4.3285000000E+04, 3.9176664626E+01, 5.2007202119E+00, 2.0461287841E+01, 3.7498232084E+00, 9.7438335130E-01],
	[4.3290000000E+04, 3.9184634492E+01, 5.2007613743E+00, 2.0469001516E+01, 3.7501766140E+00, 9.7439400703E-01],
	[4.3295000000E+04, 3.9192605059E+01, 5.2008025323E+00, 2.0476717205E+01, 3.7505299327E+00, 9.7440465770E-01],
	[4.3300000000E+04, 3.9200576326E+01, 5.2008436859E+00, 2.0484434910E+01, 3.7508831646E+00, 9.7441530329E-01],
	[4.3305000000E+04, 3.9208548294E+01, 5.2008848350E+00, 2.0492154632E+01, 3.7512363096E+00, 9.7442594382E-01],
	[4.3310000000E+04, 3.9216520962E+01, 5.2009259797E+00, 2.0499876369E+01, 3.7515893678E+00, 9.7443657929E-01],
	[4.3315000000E+04, 3.9224494331E+01, 5.2009671200E+00, 2.0507600123E+01, 3.7519423392E+00, 9.7444720969E-01],
	[4.3320000000E+04, 3.9232468401E+01, 5.2010082559E+00, 2.0515325894E+01, 3.7522952238E+00, 9.7445783503E-01],
	[4.3325000000E+04, 3.9240443170E+01, 5.2010493874E+00, 2.0523053683E+01, 3.7526480217E+00, 9.7446845532E-01],
	[4.3330000000E+04, 3.9248418641E+01, 5.2010905144E+00, 2.0530783488E+01, 3.7530007328E+00, 9.7447907055E-01],
	[4.3335000000E+04, 3.9256394812E+01, 5.2011316370E+00, 2.0538515312E+01, 3.7533533572E+00, 9.7448968073E-01],
	[4.3340000000E+04, 3.9264371683E+01, 5.2011727552E+00, 2.0546249153E+01, 3.7537058949E+00, 9.7450028587E-01],
	[4.3345000000E+04, 3.9272349254E+01, 5.2012138690E+00, 2.0553985013E+01, 3.7540583460E+00, 9.7451088595E-01],
	[4.3350000000E+04, 3.9280327526E+01, 5.2012549783E+00, 2.0561722892E+01, 3.7544107104E+00, 9.7452148100E-01],
	[4.3355000000E+04, 3.9288306499E+01, 5.2012960833E+00, 2.0569462789E+01, 3.7547629881E+00, 9.7453207100E-01],
	[4.3360000000E+04, 3.9296286171E+01, 5.2013371838E+00, 2.0577204706E+01, 3.7551151793E+00, 9.7454265596E-01],
	[4.3365000000E+04, 3.9304266545E+01, 5.2013782799E+00, 2.0584948642E+01, 3.7554672838E+00, 9.7455323589E-01],
	[4.3370000000E+04, 3.9312247618E+01, 5.2014193716E+00, 2.0592694598E+01, 3.7558193018E+00, 9.7456381079E-01],
	[4.3375000000E+04, 3.9320229391E+01, 5.2014604589E+00, 2.0600442574E+01, 3.7561712332E+00, 9.7457438065E-01],
	[4.3380000000E+04, 3.9328211865E+01, 5.2015015418E+00, 2.0608192570E+01, 3.7565230781E+00, 9.7458494549E-01],
	[4.3385000000E+04, 3.9336195039E+01, 5.2015426202E+00, 2.0615944587E+01, 3.7568748364E+00, 9.7459550529E-01],
	[4.3390000000E+04, 3.9344178914E+01, 5.2015836943E+00, 2.0623698626E+01, 3.7572265083E+00, 9.7460606008E-01],
	[4.3395000000E+04, 3.9352163488E+01, 5.2016247639E+00, 2.0631454685E+01, 3.7575780937E+00, 9.7461660985E-01],
	[4.3400000000E+04, 3.9360148763E+01, 5.2016658292E+00, 2.0639212766E+01, 3.7579295927E+00, 9.7462715459E-01],
	[4.3405000000E+04, 3.9368134738E+01, 5.2017068900E+00, 2.0646972869E+01, 3.7582810052E+00, 9.7463769433E-01],
	[4.3410000000E+04, 3.9376121413E+01, 5.2017479464E+00, 2.0654734994E+01, 3.7586323313E+00, 9.7464822905E-01],
	[4.3415000000E+04, 3.9384108788E+01, 5.2017889984E+00, 2.0662499142E+01, 3.7589835710E+00, 9.7465875875E-01],
	[4.3420000000E+04, 3.9392096864E+01, 5.2018300461E+00, 2.0670265312E+01, 3.7593347244E+00, 9.7466928346E-01],
	[4.3425000000E+04, 3.9400085639E+01, 5.2018710893E+00, 2.0678033505E+01, 3.7596857914E+00, 9.7467980315E-01],
	[4.3430000000E+04, 3.9408075115E+01, 5.2019121281E+00, 2.0685803722E+01, 3.7600367720E+00, 9.7469031784E-01],
	[4.3435000000E+04, 3.9416065290E+01, 5.2019531625E+00, 2.0693575962E+01, 3.7603876664E+00, 9.7470082754E-01],
	[4.3440000000E+04, 3.9424056166E+01, 5.2019941925E+00, 2.0701350226E+01, 3.7607384745E+00, 9.7471133223E-01],
	[4.3445000000E+04, 3.9432047741E+01, 5.2020352181E+00, 2.0709126515E+01, 3.7610891963E+00, 9.7472183193E-01],
	[4.3450000000E+04, 3.9440040017E+01, 5.2020762393E+00, 2.0716904827E+01, 3.7614398318E+00, 9.7473232664E-01],
	[4.3455000000E+04, 3.9448032992E+01, 5.2021172562E+00, 2.0724685165E+01, 3.7617903811E+00, 9.7474281635E-01],
	[4.3460000000E+04, 3.9456026668E+01, 5.2021582686E+00, 2.0732467528E+01, 3.7621408443E+00, 9.7475330108E-01],
	[4.3465000000E+04, 3.9464021043E+01, 5.2021992766E+00, 2.0740251916E+01, 3.7624912212E+00, 9.7476378083E-01],
	[4.3470000000E+04, 3.9472016119E+01, 5.2022402802E+00, 2.0748038330E+01, 3.7628415120E+00, 9.7477425559E-01],
	[4.3475000000E+04, 3.9480011894E+01, 5.2022812795E+00, 2.0755826770E+01, 3.7631917166E+00, 9.7478472537E-01],
	[4.3480000000E+04, 3.9488008369E+01, 5.2023222743E+00, 2.0763617236E+01, 3.7635418351E+00, 9.7479519018E-01],
	[4.3485000000E+04, 3.9496005544E+01, 5.2023632648E+00, 2.0771409729E+01, 3.7638918675E+00, 9.7480565001E-01],
	[4.3490000000E+04, 3.9504003419E+01, 5.2024042508E+00, 2.0779204248E+01, 3.7642418138E+00, 9.7481610486E-01],
	[4.3495000000E+04, 3.9512001994E+01, 5.2024452325E+00, 2.0787000795E+01, 3.7645916740E+00, 9.7482655475E-01],
	[4.3500000000E+04, 3.9520001268E+01, 5.2024862098E+00, 2.0794799369E+01, 3.7649414482E+00, 9.7483699967E-01],
	[4.3505000000E+04, 3.9528001242E+01, 5.2025271827E+00, 2.0802599971E+01, 3.7652911364E+00, 9.7484743963E-01],
	[4.3510000000E+04, 3.9536001916E+01, 5.2025681512E+00, 2.0810402601E+01, 3.7656407386E+00, 9.7485787462E-01],
	[4.3515000000E+04, 3.9544003290E+01, 5.2026091154E+00, 2.0818207259E+01, 3.7659902548E+00, 9.7486830466E-01],
	[4.3520000000E+04, 3.9552005364E+01, 5.2026500751E+00, 2.0826013946E+01, 3.7663396850E+00, 9.7487872974E-01],
	[4.3525000000E+04, 3.9560008137E+01, 5.2026910305E+00, 2.0833822662E+01, 3.7666890293E+00, 9.7488914986E-01],
	[4.3530000000E+04, 3.9568011610E+01, 5.2027319815E+00, 2.0841633407E+01, 3.7670382876E+00, 9.7489956503E-01],
	[4.3535000000E+04, 3.9576015782E+01, 5.2027729281E+00, 2.0849446181E+01, 3.7673874601E+00, 9.7490997525E-01],
	[4.3540000000E+04, 3.9584020654E+01, 5.2028138703E+00, 2.0857260986E+01, 3.7677365467E+00, 9.7492038053E-01],
	[4.3545000000E+04, 3.9592026226E+01, 5.2028548081E+00, 2.0865077820E+01, 3.7680855474E+00, 9.7493078086E-01],
	[4.3550000000E+04, 3.9600032498E+01, 5.2028957416E+00, 2.0872896685E+01, 3.7684344623E+00, 9.7494117625E-01],
	[4.3555000000E+04, 3.9608039469E+01, 5.2029366707E+00, 2.0880717580E+01, 3.7687832913E+00, 9.7495156670E-01],
	[4.3560000000E+04, 3.9616047139E+01, 5.2029775954E+00, 2.0888540507E+01, 3.7691320346E+00, 9.7496195221E-01],
	[4.3565000000E+04, 3.9624055510E+01, 5.2030185157E+00, 2.0896365464E+01, 3.7694806921E+00, 9.7497233279E-01],
	[4.3570000000E+04, 3.9632064579E+01, 5.2030594317E+00, 2.0904192454E+01, 3.7698292638E+00, 9.7498270844E-01],
	[4.3575000000E+04, 3.9640074348E+01, 5.2031003433E+00, 2.0912021475E+01, 3.7701777498E+00, 9.7499307915E-01],
	[4.3580000000E+04, 3.9648084817E+01, 5.2031412505E+00, 2.0919852528E+01, 3.7705261501E+00, 9.7500344495E-01],
	[4.3585000000E+04, 3.9656095985E+01, 5.2031821533E+00, 2.0927685613E+01, 3.7708744646E+00, 9.7501380581E-01],
	[4.3590000000E+04, 3.9664107853E+01, 5.2032230518E+00, 2.0935520732E+01, 3.7712226935E+00, 9.7502416176E-01],
	[4.3595000000E+04, 3.9672120420E+01, 5.2032639459E+00, 2.0943357883E+01, 3.7715708368E+00, 9.7503451279E-01],
	[4.3600000000E+04, 3.9680133687E+01, 5.2033048356E+00, 2.0951197068E+01, 3.7719188944E+00, 9.7504485890E-01],
	[4.3605000000E+04, 3.9688147652E+01, 5.2033457210E+00, 2.0959038286E+01, 3.7722668663E+00, 9.7505520009E-01],
	[4.3610000000E+04, 3.9696162318E+01, 5.2033866020E+00, 2.0966881539E+01, 3.7726147527E+00, 9.7506553638E-01],
	[4.3615000000E+04, 3.9704177682E+01, 5.2034274786E+00, 2.0974726825E+01, 3.7729625535E+00, 9.7507586775E-01],
	[4.3620000000E+04, 3.9712193746E+01, 5.2034683509E+00, 2.0982574146E+01, 3.7733102688E+00, 9.7508619422E-01],
	[4.3625000000E+04, 3.9720210510E+01, 5.2035092188E+00, 2.0990423502E+01, 3.7736578985E+00, 9.7509651579E-01],
	[4.3630000000E+04, 3.9728227972E+01, 5.2035500824E+00, 2.0998274893E+01, 3.7740054427E+00, 9.7510683245E-01],
	[4.3635000000E+04, 3.9736246134E+01, 5.2035909415E+00, 2.1006128319E+01, 3.7743529015E+00, 9.7511714422E-01],
	[4.3640000000E+04, 3.9744264995E+01, 5.2036317964E+00, 2.1013983781E+01, 3.7747002747E+00, 9.7512745109E-01],
	[4.3645000000E+04, 3.9752284556E+01, 5.2036726468E+00, 2.1021841279E+01, 3.7750475625E+00, 9.7513775306E-01],
	[4.3650000000E+04, 3.9760304815E+01, 5.2037134929E+00, 2.1029700813E+01, 3.7753947648E+00, 9.7514805015E-01],
	[4.3655000000E+04, 3.9768325774E+01, 5.2037543347E+00, 2.1037562383E+01, 3.7757418818E+00, 9.7515834234E-01],
	[4.3660000000E+04, 3.9776347432E+01, 5.2037951721E+00, 2.1045425991E+01, 3.7760889133E+00, 9.7516862965E-01],
	[4.3665000000E+04, 3.9784369790E+01, 5.2038360051E+00, 2.1053291635E+01, 3.7764358595E+00, 9.7517891207E-01],
	[4.3670000000E+04, 3.9792392846E+01, 5.2038768338E+00, 2.1061159318E+01, 3.7767827204E+00, 9.7518918962E-01],
	[4.3675000000E+04, 3.9800416601E+01, 5.2039176581E+00, 2.1069029037E+01, 3.7771294959E+00, 9.7519946228E-01],
	[4.3680000000E+04, 3.9808441056E+01, 5.2039584780E+00, 2.1076900795E+01, 3.7774761860E+00, 9.7520973007E-01],
	[4.3685000000E+04, 3.9816466210E+01, 5.2039992937E+00, 2.1084774591E+01, 3.7778227909E+00, 9.7521999299E-01],
	[4.3690000000E+04, 3.9824492062E+01, 5.2040401049E+00, 2.1092650426E+01, 3.7781693106E+00, 9.7523025103E-01],
	[4.3695000000E+04, 3.9832518614E+01, 5.2040809118E+00, 2.1100528300E+01, 3.7785157450E+00, 9.7524050421E-01],
	[4.3700000000E+04, 3.9840545865E+01, 5.2041217144E+00, 2.1108408213E+01, 3.7788620941E+00, 9.7525075252E-01],
	[4.3705000000E+04, 3.9848573815E+01, 5.2041625126E+00, 2.1116290165E+01, 3.7792083581E+00, 9.7526099597E-01],
	[4.3710000000E+04, 3.9856602464E+01, 5.2042033065E+00, 2.1124174157E+01, 3.7795545368E+00, 9.7527123455E-01],
	[4.3715000000E+04, 3.9864631812E+01, 5.2042440960E+00, 2.1132060189E+01, 3.7799006304E+00, 9.7528146828E-01],
	[4.3720000000E+04, 3.9872661859E+01, 5.2042848812E+00, 2.1139948262E+01, 3.7802466388E+00, 9.7529169715E-01],
	[4.3725000000E+04, 3.9880692604E+01, 5.2043256620E+00, 2.1147838375E+01, 3.7805925622E+00, 9.7530192116E-01],
	[4.3730000000E+04, 3.9888724049E+01, 5.2043664385E+00, 2.1155730529E+01, 3.7809384004E+00, 9.7531214033E-01],
	[4.3735000000E+04, 3.9896756193E+01, 5.2044072107E+00, 2.1163624725E+01, 3.7812841535E+00, 9.7532235465E-01],
	[4.3740000000E+04, 3.9904789035E+01, 5.2044479785E+00, 2.1171520962E+01, 3.7816298215E+00, 9.7533256412E-01],
	[4.3745000000E+04, 3.9912822576E+01, 5.2044887419E+00, 2.1179419241E+01, 3.7819754046E+00, 9.7534276875E-01],
	[4.3750000000E+04, 3.9920856817E+01, 5.2045295010E+00, 2.1187319562E+01, 3.7823209025E+00, 9.7535296853E-01],
	[4.3755000000E+04, 3.9928891756E+01, 5.2045702558E+00, 2.1195221925E+01, 3.7826663155E+00, 9.7536316348E-01],
	[4.3760000000E+04, 3.9936927394E+01, 5.2046110063E+00, 2.1203126331E+01, 3.7830116435E+00, 9.7537335359E-01],
	[4.3765000000E+04, 3.9944963730E+01, 5.2046517524E+00, 2.1211032780E+01, 3.7833568866E+00, 9.7538353887E-01],
	[4.3770000000E+04, 3.9953000765E+01, 5.2046924942E+00, 2.1218941273E+01, 3.7837020447E+00, 9.7539371932E-01],
	[4.3775000000E+04, 3.9961038500E+01, 5.2047332316E+00, 2.1226851809E+01, 3.7840471178E+00, 9.7540389494E-01],
	[4.3780000000E+04, 3.9969076932E+01, 5.2047739647E+00, 2.1234764389E+01, 3.7843921061E+00, 9.7541406573E-01],
	[4.3785000000E+04, 3.9977116064E+01, 5.2048146935E+00, 2.1242679013E+01, 3.7847370095E+00, 9.7542423170E-01],
	[4.3790000000E+04, 3.9985155894E+01, 5.2048554179E+00, 2.1250595682E+01, 3.7850818280E+00, 9.7543439285E-01],
	[4.3795000000E+04, 3.9993196423E+01, 5.2048961380E+00, 2.1258514395E+01, 3.7854265617E+00, 9.7544454918E-01],
	[4.3800000000E+04, 4.0001237651E+01, 5.2049368538E+00, 2.1266435154E+01, 3.7857712105E+00, 9.7545470070E-01],
	[4.3805000000E+04, 4.0009279577E+01, 5.2049775653E+00, 2.1274357958E+01, 3.7861157746E+00, 9.7546484740E-01],
	[4.3810000000E+04, 4.0017322202E+01, 5.2050182724E+00, 2.1282282808E+01, 3.7864602539E+00, 9.7547498929E-01],
	[4.3815000000E+04, 4.0025365525E+01, 5.2050589752E+00, 2.1290209703E+01, 3.7868046484E+00, 9.7548512637E-01],
	[4.3820000000E+04, 4.0033409547E+01, 5.2050996737E+00, 2.1298138645E+01, 3.7871489582E+00, 9.7549525864E-01],
	[4.3825000000E+04, 4.0041454268E+01, 5.2051403678E+00, 2.1306069633E+01, 3.7874931832E+00, 9.7550538611E-01],
	[4.3830000000E+04, 4.0049499687E+01, 5.2051810576E+00, 2.1314002669E+01, 3.7878373236E+00, 9.7551550878E-01],
	[4.3835000000E+04, 4.0057545805E+01, 5.2052217431E+00, 2.1321937751E+01, 3.7881813793E+00, 9.7552562666E-01],
	[4.3840000000E+04, 4.0065592621E+01, 5.2052624243E+00, 2.1329874881E+01, 3.7885253503E+00, 9.7553573973E-01],
	[4.3845000000E+04, 4.0073640135E+01, 5.2053031011E+00, 2.1337814058E+01, 3.7888692367E+00, 9.7554584802E-01],
	[4.3850000000E+04, 4.0081688349E+01, 5.2053437737E+00, 2.1345755284E+01, 3.7892130384E+00, 9.7555595151E-01],
	[4.3855000000E+04, 4.0089737260E+01, 5.2053844419E+00, 2.1353698558E+01, 3.7895567556E+00, 9.7556605021E-01],
	[4.3860000000E+04, 4.0097786870E+01, 5.2054251058E+00, 2.1361643880E+01, 3.7899003882E+00, 9.7557614413E-01],
	[4.3865000000E+04, 4.0105837178E+01, 5.2054657653E+00, 2.1369591251E+01, 3.7902439363E+00, 9.7558623326E-01],
	[4.3870000000E+04, 4.0113888185E+01, 5.2055064206E+00, 2.1377540672E+01, 3.7905873998E+00, 9.7559631761E-01],
	[4.3875000000E+04, 4.0121939890E+01, 5.2055470715E+00, 2.1385492142E+01, 3.7909307787E+00, 9.7560639719E-01],
	[4.3880000000E+04, 4.0129999913E+01, 5.2055885937E+00, 2.1393445662E+01, 3.7912746056E+00, 9.7561647198E-01],
	[4.3885000000E+04, 4.0138069621E+01, 5.2056311436E+00, 2.1401401232E+01, 3.7916189759E+00, 9.7562654201E-01],
	[4.3890000000E+04, 4.0146140031E+01, 5.2056736890E+00, 2.1409358852E+01, 3.7919632619E+00, 9.7563660726E-01],
	[4.3895000000E+04, 4.0154211145E+01, 5.2057162299E+00, 2.1417318523E+01, 3.7923074638E+00, 9.7564666774E-01],
	[4.3900000000E+04, 4.0162282962E+01, 5.2057587663E+00, 2.1425280245E+01, 3.7926515814E+00, 9.7565672346E-01],
	[4.3905000000E+04, 4.0170355482E+01, 5.2058012982E+00, 2.1433244018E+01, 3.7929956148E+00, 9.7566677441E-01],
	[4.3910000000E+04, 4.0178428705E+01, 5.2058438256E+00, 2.1441209843E+01, 3.7933395641E+00, 9.7567682061E-01],
	[4.3915000000E+04, 4.0186502631E+01, 5.2058863485E+00, 2.1449177719E+01, 3.7936834292E+00, 9.7568686204E-01],
	[4.3920000000E+04, 4.0194577260E+01, 5.2059288670E+00, 2.1457147648E+01, 3.7940272102E+00, 9.7569689872E-01],
	[4.3925000000E+04, 4.0202652592E+01, 5.2059713809E+00, 2.1465119629E+01, 3.7943709072E+00, 9.7570693064E-01],
	[4.3930000000E+04, 4.0210728627E+01, 5.2060138903E+00, 2.1473093663E+01, 3.7947145200E+00, 9.7571695782E-01],
	[4.3935000000E+04, 4.0218805365E+01, 5.2060563953E+00, 2.1481069750E+01, 3.7950580488E+00, 9.7572698024E-01],
	[4.3940000000E+04, 4.0226882805E+01, 5.2060988957E+00, 2.1489047890E+01, 3.7954014935E+00, 9.7573699792E-01],
	[4.3945000000E+04, 4.0234960949E+01, 5.2061413917E+00, 2.1497028084E+01, 3.7957448542E+00, 9.7574701085E-01],
	[4.3950000000E+04, 4.0243039795E+01, 5.2061838832E+00, 2.1505010332E+01, 3.7960881309E+00, 9.7575701904E-01],
	[4.3955000000E+04, 4.0251119345E+01, 5.2062263702E+00, 2.1512994634E+01, 3.7964313237E+00, 9.7576702250E-01],
	[4.3960000000E+04, 4.0259199597E+01, 5.2062688527E+00, 2.1520980990E+01, 3.7967744325E+00, 9.7577702121E-01],
	[4.3965000000E+04, 4.0267280552E+01, 5.2063113307E+00, 2.1528969402E+01, 3.7971174573E+00, 9.7578701520E-01],
	[4.3970000000E+04, 4.0275362209E+01, 5.2063538043E+00, 2.1536959868E+01, 3.7974603982E+00, 9.7579700445E-01],
	[4.3975000000E+04, 4.0283444570E+01, 5.2063962733E+00, 2.1544952390E+01, 3.7978032553E+00, 9.7580698897E-01],
	[4.3980000000E+04, 4.0291527633E+01, 5.2064387379E+00, 2.1552946967E+01, 3.7981460284E+00, 9.7581696877E-01],
	[4.3985000000E+04, 4.0299611399E+01, 5.2064811980E+00, 2.1560943600E+01, 3.7984887177E+00, 9.7582694384E-01],
	[4.3990000000E+04, 4.0307695868E+01, 5.2065236536E+00, 2.1568942290E+01, 3.7988313232E+00, 9.7583691419E-01],
	[4.3995000000E+04, 4.0315781039E+01, 5.2065661048E+00, 2.1576943036E+01, 3.7991738448E+00, 9.7584687982E-01],
	[4.4000000000E+04, 4.0323866913E+01, 5.2066085514E+00, 2.1584945839E+01, 3.7995162826E+00, 9.7585684073E-01],
	[4.4005000000E+04, 4.0331953490E+01, 5.2066509936E+00, 2.1592950699E+01, 3.7998586367E+00, 9.7586679693E-01],
	[4.4010000000E+04, 4.0340040769E+01, 5.2066934313E+00, 2.1600957617E+01, 3.8002009070E+00, 9.7587674842E-01],
	[4.4015000000E+04, 4.0348128751E+01, 5.2067358645E+00, 2.1608966592E+01, 3.8005430936E+00, 9.7588669520E-01],
	[4.4020000000E+04, 4.0356217436E+01, 5.2067782933E+00, 2.1616977626E+01, 3.8008851965E+00, 9.7589663727E-01],
	[4.4025000000E+04, 4.0364306823E+01, 5.2068207176E+00, 2.1624990717E+01, 3.8012272156E+00, 9.7590657464E-01],
	[4.4030000000E+04, 4.0372396913E+01, 5.2068631374E+00, 2.1633005868E+01, 3.8015691511E+00, 9.7591650730E-01],
	[4.4035000000E+04, 4.0380487705E+01, 5.2069055527E+00, 2.1641023077E+01, 3.8019110029E+00, 9.7592643527E-01],
	[4.4040000000E+04, 4.0388579200E+01, 5.2069479636E+00, 2.1649042345E+01, 3.8022527711E+00, 9.7593635854E-01],
	[4.4045000000E+04, 4.0396671397E+01, 5.2069903700E+00, 2.1657063673E+01, 3.8025944557E+00, 9.7594627712E-01],
	[4.4050000000E+04, 4.0404764297E+01, 5.2070327719E+00, 2.1665087061E+01, 3.8029360567E+00, 9.7595619100E-01],
	[4.4055000000E+04, 4.0412857899E+01, 5.2070751694E+00, 2.1673112509E+01, 3.8032775741E+00, 9.7596610019E-01],
	[4.4060000000E+04, 4.0420952204E+01, 5.2071175624E+00, 2.1681140017E+01, 3.8036190080E+00, 9.7597600470E-01],
	[4.4065000000E+04, 4.0429047211E+01, 5.2071599509E+00, 2.1689169586E+01, 3.8039603583E+00, 9.7598590452E-01],
	[4.4070000000E+04, 4.0437142920E+01, 5.2072023350E+00, 2.1697201216E+01, 3.8043016251E+00, 9.7599579966E-01],
	[4.4075000000E+04, 4.0445239332E+01, 5.2072447146E+00, 2.1705234907E+01, 3.8046428085E+00, 9.7600569012E-01],
	[4.4080000000E+04, 4.0453336447E+01, 5.2072870897E+00, 2.1713270660E+01, 3.8049839083E+00, 9.7601557590E-01],
	[4.4085000000E+04, 4.0461434263E+01, 5.2073294604E+00, 2.1721308474E+01, 3.8053249247E+00, 9.7602545701E-01],
	[4.4090000000E+04, 4.0469532782E+01, 5.2073718266E+00, 2.1729348351E+01, 3.8056658577E+00, 9.7603533344E-01],
	[4.4095000000E+04, 4.0477632004E+01, 5.2074141884E+00, 2.1737390290E+01, 3.8060067072E+00, 9.7604520521E-01],
	[4.4100000000E+04, 4.0485731927E+01, 5.2074565457E+00, 2.1745434292E+01, 3.8063474734E+00, 9.7605507230E-01],
	[4.4105000000E+04, 4.0493832553E+01, 5.2074988985E+00, 2.1753480357E+01, 3.8066881562E+00, 9.7606493474E-01],
	[4.4110000000E+04, 4.0501933881E+01, 5.2075412469E+00, 2.1761528485E+01, 3.8070287556E+00, 9.7607479251E-01],
	[4.4115000000E+04, 4.0510035912E+01, 5.2075835908E+00, 2.1769578677E+01, 3.8073692717E+00, 9.7608464562E-01],
	[4.4120000000E+04, 4.0518138644E+01, 5.2076259303E+00, 2.1777630933E+01, 3.8077097045E+00, 9.7609449407E-01],
	[4.4125000000E+04, 4.0526242079E+01, 5.2076682653E+00, 2.1785685253E+01, 3.8080500540E+00, 9.7610433786E-01],
	[4.4130000000E+04, 4.0534346216E+01, 5.2077105959E+00, 2.1793741638E+01, 3.8083903202E+00, 9.7611417701E-01],
	[4.4135000000E+04, 4.0542451056E+01, 5.2077529220E+00, 2.1801800087E+01, 3.8087305032E+00, 9.7612401150E-01],
	[4.4140000000E+04, 4.0550556597E+01, 5.2077952437E+00, 2.1809860602E+01, 3.8090706029E+00, 9.7613384135E-01],
	[4.4145000000E+04, 4.0558662840E+01, 5.2078375609E+00, 2.1817923181E+01, 3.8094106195E+00, 9.7614366655E-01],
	[4.4150000000E+04, 4.0566769786E+01, 5.2078798736E+00, 2.1825987827E+01, 3.8097505528E+00, 9.7615348710E-01],
	[4.4155000000E+04, 4.0574877434E+01, 5.2079221820E+00, 2.1834054539E+01, 3.8100904030E+00, 9.7616330302E-01],
	[4.4160000000E+04, 4.0582985783E+01, 5.2079644858E+00, 2.1842123316E+01, 3.8104301700E+00, 9.7617311430E-01],
	[4.4165000000E+04, 4.0591094835E+01, 5.2080067853E+00, 2.1850194161E+01, 3.8107698539E+00, 9.7618292094E-01],
	[4.4170000000E+04, 4.0599204589E+01, 5.2080490802E+00, 2.1858267072E+01, 3.8111094547E+00, 9.7619272295E-01],
	[4.4175000000E+04, 4.0607315045E+01, 5.2080913708E+00, 2.1866342051E+01, 3.8114489724E+00, 9.7620252033E-01],
	[4.4180000000E+04, 4.0615426203E+01, 5.2081336569E+00, 2.1874419096E+01, 3.8117884071E+00, 9.7621231308E-01],
	[4.4185000000E+04, 4.0623538063E+01, 5.2081759385E+00, 2.1882498210E+01, 3.8121277587E+00, 9.7622210120E-01],
	[4.4190000000E+04, 4.0631650625E+01, 5.2082182157E+00, 2.1890579392E+01, 3.8124670272E+00, 9.7623188470E-01],
	[4.4195000000E+04, 4.0639763889E+01, 5.2082604885E+00, 2.1898662642E+01, 3.8128062128E+00, 9.7624166358E-01],
	[4.4200000000E+04, 4.0647877854E+01, 5.2083027568E+00, 2.1906747961E+01, 3.8131453153E+00, 9.7625143784E-01],
	[4.4205000000E+04, 4.0655992522E+01, 5.2083450207E+00, 2.1914835348E+01, 3.8134843349E+00, 9.7626120749E-01],
	[4.4210000000E+04, 4.0664107891E+01, 5.2083872802E+00, 2.1922924805E+01, 3.8138232716E+00, 9.7627097252E-01],
	[4.4215000000E+04, 4.0672223963E+01, 5.2084295352E+00, 2.1931016331E+01, 3.8141621253E+00, 9.7628073294E-01],
	[4.4220000000E+04, 4.0680340736E+01, 5.2084717858E+00, 2.1939109928E+01, 3.8145008961E+00, 9.7629048875E-01],
	[4.4225000000E+04, 4.0688458211E+01, 5.2085140319E+00, 2.1947205594E+01, 3.8148395840E+00, 9.7630023995E-01],
	[4.4230000000E+04, 4.0696576388E+01, 5.2085562736E+00, 2.1955303331E+01, 3.8151781891E+00, 9.7630998655E-01],
	[4.4235000000E+04, 4.0704695267E+01, 5.2085985109E+00, 2.1963403138E+01, 3.8155167113E+00, 9.7631972855E-01],
	[4.4240000000E+04, 4.0712814847E+01, 5.2086407438E+00, 2.1971505016E+01, 3.8158551507E+00, 9.7632946595E-01],
	[4.4245000000E+04, 4.0720935129E+01, 5.2086829722E+00, 2.1979608966E+01, 3.8161935072E+00, 9.7633919875E-01],
	[4.4250000000E+04, 4.0729056113E+01, 5.2087251962E+00, 2.1987714987E+01, 3.8165317810E+00, 9.7634892696E-01],
	[4.4255000000E+04, 4.0737177799E+01, 5.2087674158E+00, 2.1995823081E+01, 3.8168699720E+00, 9.7635865058E-01],
	[4.4260000000E+04, 4.0745300186E+01, 5.2088096309E+00, 2.2003933246E+01, 3.8172080803E+00, 9.7636836960E-01],
	[4.4265000000E+04, 4.0753423275E+01, 5.2088518416E+00, 2.2012045484E+01, 3.8175461059E+00, 9.7637808404E-01],
	[4.4270000000E+04, 4.0761547066E+01, 5.2088940479E+00, 2.2020159794E+01, 3.8178840487E+00, 9.7638779390E-01],
	[4.4275000000E+04, 4.0769671559E+01, 5.2089362497E+00, 2.2028276178E+01, 3.8182219089E+00, 9.7639749917E-01],
	[4.4280000000E+04, 4.0777796753E+01, 5.2089784472E+00, 2.2036394635E+01, 3.8185596864E+00, 9.7640719986E-01],
	[4.4285000000E+04, 4.0785922648E+01, 5.2090206402E+00, 2.2044515166E+01, 3.8188973812E+00, 9.7641689598E-01],
	[4.4290000000E+04, 4.0794049245E+01, 5.2090628288E+00, 2.2052637770E+01, 3.8192349935E+00, 9.7642658752E-01],
	[4.4295000000E+04, 4.0802176544E+01, 5.2091050130E+00, 2.2060762449E+01, 3.8195725231E+00, 9.7643627449E-01],
	[4.4300000000E+04, 4.0810304545E+01, 5.2091471927E+00, 2.2068889202E+01, 3.8199099701E+00, 9.7644595688E-01],
	[4.4305000000E+04, 4.0818433246E+01, 5.2091893680E+00, 2.2077018031E+01, 3.8202473346E+00, 9.7645563471E-01],
	[4.4310000000E+04, 4.0826562650E+01, 5.2092315390E+00, 2.2085148934E+01, 3.8205846166E+00, 9.7646530798E-01],
	[4.4315000000E+04, 4.0834692755E+01, 5.2092737054E+00, 2.2093281913E+01, 3.8209218160E+00, 9.7647497668E-01],
	[4.4320000000E+04, 4.0842823561E+01, 5.2093158675E+00, 2.2101416967E+01, 3.8212589329E+00, 9.7648464082E-01],
	[4.4325000000E+04, 4.0850955069E+01, 5.2093580252E+00, 2.2109554098E+01, 3.8215959673E+00, 9.7649430041E-01],
	[4.4330000000E+04, 4.0859087278E+01, 5.2094001784E+00, 2.2117693305E+01, 3.8219329193E+00, 9.7650395543E-01],
	[4.4335000000E+04, 4.0867220189E+01, 5.2094423273E+00, 2.2125834588E+01, 3.8222697888E+00, 9.7651360591E-01],
	[4.4340000000E+04, 4.0875353801E+01, 5.2094844717E+00, 2.2133977948E+01, 3.8226065759E+00, 9.7652325183E-01],
	[4.4345000000E+04, 4.0883488114E+01, 5.2095266117E+00, 2.2142123386E+01, 3.8229432806E+00, 9.7653289321E-01],
	[4.4350000000E+04, 4.0891623129E+01, 5.2095687473E+00, 2.2150270901E+01, 3.8232799029E+00, 9.7654253004E-01],
	[4.4355000000E+04, 4.0899758846E+01, 5.2096108785E+00, 2.2158420494E+01, 3.8236164428E+00, 9.7655216232E-01],
	[4.4360000000E+04, 4.0907895263E+01, 5.2096530053E+00, 2.2166572164E+01, 3.8239529004E+00, 9.7656179007E-01],
	[4.4365000000E+04, 4.0916032382E+01, 5.2096951277E+00, 2.2174725914E+01, 3.8242892757E+00, 9.7657141327E-01],
	[4.4370000000E+04, 4.0924170202E+01, 5.2097372457E+00, 2.2182881741E+01, 3.8246255687E+00, 9.7658103194E-01],
	[4.4375000000E+04, 4.0932308723E+01, 5.2097793592E+00, 2.2191039648E+01, 3.8249617794E+00, 9.7659064608E-01],
	[4.4380000000E+04, 4.0940447946E+01, 5.2098214684E+00, 2.2199199634E+01, 3.8252979078E+00, 9.7660025568E-01],
	[4.4385000000E+04, 4.0948587870E+01, 5.2098635731E+00, 2.2207361700E+01, 3.8256339540E+00, 9.7660986076E-01],
	[4.4390000000E+04, 4.0956728495E+01, 5.2099056735E+00, 2.2215525846E+01, 3.8259699180E+00, 9.7661946131E-01],
	[4.4395000000E+04, 4.0964869821E+01, 5.2099477694E+00, 2.2223692071E+01, 3.8263057998E+00, 9.7662905733E-01],
	[4.4400000000E+04, 4.0973011849E+01, 5.2099898610E+00, 2.2231860377E+01, 3.8266415994E+00, 9.7663864883E-01],
	[4.4405000000E+04, 4.0981154578E+01, 5.2100319482E+00, 2.2240030764E+01, 3.8269773168E+00, 9.7664823581E-01],
	[4.4410000000E+04, 4.0989298007E+01, 5.2100740309E+00, 2.2248203232E+01, 3.8273129521E+00, 9.7665781828E-01],
	[4.4415000000E+04, 4.0997442138E+01, 5.2101161093E+00, 2.2256377781E+01, 3.8276485053E+00, 9.7666739623E-01],
	[4.4420000000E+04, 4.1005586970E+01, 5.2101581832E+00, 2.2264554412E+01, 3.8279839764E+00, 9.7667696967E-01],
	[4.4425000000E+04, 4.1013732504E+01, 5.2102002528E+00, 2.2272733125E+01, 3.8283193654E+00, 9.7668653859E-01],
	[4.4430000000E+04, 4.1021878738E+01, 5.2102423180E+00, 2.2280913920E+01, 3.8286546723E+00, 9.7669610301E-01],
	[4.4435000000E+04, 4.1030025673E+01, 5.2102843787E+00, 2.2289096797E+01, 3.8289898972E+00, 9.7670566293E-01],
	[4.4440000000E+04, 4.1038173309E+01, 5.2103264351E+00, 2.2297281757E+01, 3.8293250401E+00, 9.7671521834E-01],
	[4.4445000000E+04, 4.1046321647E+01, 5.2103684871E+00, 2.2305468801E+01, 3.8296601010E+00, 9.7672476925E-01],
	[4.4450000000E+04, 4.1054470685E+01, 5.2104105347E+00, 2.2313657927E+01, 3.8299950799E+00, 9.7673431567E-01],
	[4.4455000000E+04, 4.1062620424E+01, 5.2104525779E+00, 2.2321849138E+01, 3.8303299768E+00, 9.7674385759E-01],
	[4.4460000000E+04, 4.1070770864E+01, 5.2104946167E+00, 2.2330042432E+01, 3.8306647918E+00, 9.7675339501E-01],
	[4.4465000000E+04, 4.1078922006E+01, 5.2105366512E+00, 2.2338237811E+01, 3.8309995249E+00, 9.7676292795E-01],
	[4.4470000000E+04, 4.1087073848E+01, 5.2105786812E+00, 2.2346435274E+01, 3.8313341761E+00, 9.7677245639E-01],
	[4.4475000000E+04, 4.1095226391E+01, 5.2106207069E+00, 2.2354634822E+01, 3.8316687454E+00, 9.7678198035E-01],
	[4.4480000000E+04, 4.1103379634E+01, 5.2106627281E+00, 2.2362836455E+01, 3.8320032328E+00, 9.7679149983E-01],
	[4.4485000000E+04, 4.1111533579E+01, 5.2107047450E+00, 2.2371040174E+01, 3.8323376385E+00, 9.7680101482E-01],
	[4.4490000000E+04, 4.1119688225E+01, 5.2107467575E+00, 2.2379245979E+01, 3.8326719622E+00, 9.7681052534E-01],
	[4.4495000000E+04, 4.1127843571E+01, 5.2107887656E+00, 2.2387453869E+01, 3.8330062042E+00, 9.7682003138E-01],
	[4.4500000000E+04, 4.1135999618E+01, 5.2108307694E+00, 2.2395663846E+01, 3.8333403645E+00, 9.7682953294E-01],
	[4.4505000000E+04, 4.1144156366E+01, 5.2108727687E+00, 2.2403875909E+01, 3.8336744429E+00, 9.7683903004E-01],
	[4.4510000000E+04, 4.1152313815E+01, 5.2109147637E+00, 2.2412090060E+01, 3.8340084397E+00, 9.7684852266E-01],
	[4.4515000000E+04, 4.1160471965E+01, 5.2109567543E+00, 2.2420306298E+01, 3.8343423547E+00, 9.7685801082E-01],
	[4.4520000000E+04, 4.1168630815E+01, 5.2109987405E+00, 2.2428524623E+01, 3.8346761880E+00, 9.7686749451E-01],
	[4.4525000000E+04, 4.1176790366E+01, 5.2110407224E+00, 2.2436745036E+01, 3.8350099396E+00, 9.7687697374E-01],
	[4.4530000000E+04, 4.1184950618E+01, 5.2110826999E+00, 2.2444967537E+01, 3.8353436096E+00, 9.7688644851E-01],
	[4.4535000000E+04, 4.1193111570E+01, 5.2111246729E+00, 2.2453192127E+01, 3.8356771979E+00, 9.7689591883E-01],
	[4.4540000000E+04, 4.1201273223E+01, 5.2111666417E+00, 2.2461418805E+01, 3.8360107047E+00, 9.7690538468E-01],
	[4.4545000000E+04, 4.1209435577E+01, 5.2112086060E+00, 2.2469647572E+01, 3.8363441298E+00, 9.7691484609E-01],
	[4.4550000000E+04, 4.1217598631E+01, 5.2112505660E+00, 2.2477878429E+01, 3.8366774733E+00, 9.7692430304E-01],
	[4.4555000000E+04, 4.1225762386E+01, 5.2112925216E+00, 2.2486111375E+01, 3.8370107353E+00, 9.7693375555E-01],
	[4.4560000000E+04, 4.1233926842E+01, 5.2113344728E+00, 2.2494346411E+01, 3.8373439158E+00, 9.7694320361E-01],
	[4.4565000000E+04, 4.1242091998E+01, 5.2113764197E+00, 2.2502583537E+01, 3.8376770147E+00, 9.7695264723E-01],
	[4.4570000000E+04, 4.1250257854E+01, 5.2114183622E+00, 2.2510822754E+01, 3.8380100322E+00, 9.7696208641E-01],
	[4.4575000000E+04, 4.1258424412E+01, 5.2114603003E+00, 2.2519064061E+01, 3.8383429682E+00, 9.7697152115E-01],
	[4.4580000000E+04, 4.1266591669E+01, 5.2115022341E+00, 2.2527307460E+01, 3.8386758227E+00, 9.7698095145E-01],
	[4.4585000000E+04, 4.1274762669E+01, 5.2115445079E+00, 2.2535552950E+01, 3.8390088090E+00, 9.7699037732E-01],
	[4.4590000000E+04, 4.1282947804E+01, 5.2115882984E+00, 2.2543800531E+01, 3.8393426556E+00, 9.7699979876E-01],
	[4.4595000000E+04, 4.1291133644E+01, 5.2116320843E+00, 2.2552050205E+01, 3.8396764210E+00, 9.7700921576E-01],
	[4.4600000000E+04, 4.1299320189E+01, 5.2116758657E+00, 2.2560301971E+01, 3.8400101052E+00, 9.7701862835E-01],
	[4.4605000000E+04, 4.1307507440E+01, 5.2117196425E+00, 2.2568555829E+01, 3.8403437083E+00, 9.7702803650E-01],
	[4.4610000000E+04, 4.1315695395E+01, 5.2117634148E+00, 2.2576811780E+01, 3.8406772302E+00, 9.7703744024E-01],
	[4.4615000000E+04, 4.1323884055E+01, 5.2118071825E+00, 2.2585069824E+01, 3.8410106710E+00, 9.7704683956E-01],
	[4.4620000000E+04, 4.1332073421E+01, 5.2118509457E+00, 2.2593329962E+01, 3.8413440308E+00, 9.7705623445E-01],
	[4.4625000000E+04, 4.1340263491E+01, 5.2118947044E+00, 2.2601592194E+01, 3.8416773094E+00, 9.7706562494E-01],
	[4.4630000000E+04, 4.1348454267E+01, 5.2119384586E+00, 2.2609856519E+01, 3.8420105070E+00, 9.7707501101E-01],
	[4.4635000000E+04, 4.1356645747E+01, 5.2119822082E+00, 2.2618122939E+01, 3.8423436235E+00, 9.7708439267E-01],
	[4.4640000000E+04, 4.1364837933E+01, 5.2120259532E+00, 2.2626391453E+01, 3.8426766591E+00, 9.7709376992E-01],
	[4.4645000000E+04, 4.1373030823E+01, 5.2120696938E+00, 2.2634662063E+01, 3.8430096136E+00, 9.7710314277E-01],
	[4.4650000000E+04, 4.1381224418E+01, 5.2121134298E+00, 2.2642934767E+01, 3.8433424872E+00, 9.7711251122E-01],
	[4.4655000000E+04, 4.1389418719E+01, 5.2121571613E+00, 2.2651209567E+01, 3.8436752798E+00, 9.7712187526E-01],
	[4.4660000000E+04, 4.1397613724E+01, 5.2122008882E+00, 2.2659486463E+01, 3.8440079914E+00, 9.7713123491E-01],
	[4.4665000000E+04, 4.1405809434E+01, 5.2122446106E+00, 2.2667765455E+01, 3.8443406222E+00, 9.7714059016E-01],
	[4.4670000000E+04, 4.1414005849E+01, 5.2122883285E+00, 2.2676046544E+01, 3.8446731720E+00, 9.7714994101E-01],
	[4.4675000000E+04, 4.1422202968E+01, 5.2123320419E+00, 2.2684329729E+01, 3.8450056410E+00, 9.7715928748E-01],
	[4.4680000000E+04, 4.1430400793E+01, 5.2123757507E+00, 2.2692615011E+01, 3.8453380291E+00, 9.7716862955E-01],
	[4.4685000000E+04, 4.1438599322E+01, 5.2124194551E+00, 2.2700902390E+01, 3.8456703364E+00, 9.7717796724E-01],
	[4.4690000000E+04, 4.1446798556E+01, 5.2124631548E+00, 2.2709191867E+01, 3.8460025629E+00, 9.7718730055E-01],
	[4.4695000000E+04, 4.1454998495E+01, 5.2125068501E+00, 2.2717483442E+01, 3.8463347085E+00, 9.7719662947E-01],
	[4.4700000000E+04, 4.1463199139E+01, 5.2125505409E+00, 2.2725777114E+01, 3.8466667734E+00, 9.7720595402E-01],
	[4.4705000000E+04, 4.1471400488E+01, 5.2125942271E+00, 2.2734072886E+01, 3.8469987576E+00, 9.7721527418E-01],
	[4.4710000000E+04, 4.1479602541E+01, 5.2126379088E+00, 2.2742370756E+01, 3.8473306610E+00, 9.7722458997E-01],
	[4.4715000000E+04, 4.1487805299E+01, 5.2126815860E+00, 2.2750670725E+01, 3.8476624836E+00, 9.7723390139E-01],
	[4.4720000000E+04, 4.1496008761E+01, 5.2127252587E+00, 2.2758972794E+01, 3.8479942256E+00, 9.7724320844E-01],
	[4.4725000000E+04, 4.1504212928E+01, 5.2127689268E+00, 2.2767276962E+01, 3.8483258869E+00, 9.7725251112E-01],
	[4.4730000000E+04, 4.1512417800E+01, 5.2128125905E+00, 2.2775583230E+01, 3.8486574676E+00, 9.7726180944E-01],
	[4.4735000000E+04, 4.1520623377E+01, 5.2128562496E+00, 2.2783891598E+01, 3.8489889676E+00, 9.7727110339E-01],
	[4.4740000000E+04, 4.1528829658E+01, 5.2128999042E+00, 2.2792202067E+01, 3.8493203870E+00, 9.7728039298E-01],
	[4.4745000000E+04, 4.1537036643E+01, 5.2129435543E+00, 2.2800514637E+01, 3.8496517258E+00, 9.7728967822E-01],
	[4.4750000000E+04, 4.1545244333E+01, 5.2129871999E+00, 2.2808829308E+01, 3.8499829840E+00, 9.7729895909E-01],
	[4.4755000000E+04, 4.1553452728E+01, 5.2130308409E+00, 2.2817146080E+01, 3.8503141617E+00, 9.7730823562E-01],
	[4.4760000000E+04, 4.1561661828E+01, 5.2130744775E+00, 2.2825464954E+01, 3.8506452588E+00, 9.7731750779E-01],
	[4.4765000000E+04, 4.1569871631E+01, 5.2131181096E+00, 2.2833785930E+01, 3.8509762754E+00, 9.7732677561E-01],
	[4.4770000000E+04, 4.1578082140E+01, 5.2131617371E+00, 2.2842109008E+01, 3.8513072115E+00, 9.7733603909E-01],
	[4.4775000000E+04, 4.1586293353E+01, 5.2132053602E+00, 2.2850434189E+01, 3.8516380672E+00, 9.7734529822E-01],
	[4.4780000000E+04, 4.1594505270E+01, 5.2132489787E+00, 2.2858761473E+01, 3.8519688424E+00, 9.7735455301E-01],
	[4.4785000000E+04, 4.1602717892E+01, 5.2132925927E+00, 2.2867090860E+01, 3.8522995371E+00, 9.7736380345E-01],
	[4.4790000000E+04, 4.1610931218E+01, 5.2133362022E+00, 2.2875422350E+01, 3.8526301514E+00, 9.7737304957E-01],
	[4.4795000000E+04, 4.1619145248E+01, 5.2133798073E+00, 2.2883755944E+01, 3.8529606853E+00, 9.7738229134E-01],
	[4.4800000000E+04, 4.1627359983E+01, 5.2134234078E+00, 2.2892091643E+01, 3.8532911389E+00, 9.7739152879E-01],
	[4.4805000000E+04, 4.1635575422E+01, 5.2134670038E+00, 2.2900429445E+01, 3.8536215121E+00, 9.7740076190E-01],
	[4.4810000000E+04, 4.1643791566E+01, 5.2135105953E+00, 2.2908769353E+01, 3.8539518049E+00, 9.7740999068E-01],
	[4.4815000000E+04, 4.1652008414E+01, 5.2135541823E+00, 2.2917111365E+01, 3.8542820175E+00, 9.7741921514E-01],
	[4.4820000000E+04, 4.1660225966E+01, 5.2135977649E+00, 2.2925455483E+01, 3.8546121497E+00, 9.7742843528E-01],
	[4.4825000000E+04, 4.1668444223E+01, 5.2136413429E+00, 2.2933801706E+01, 3.8549422017E+00, 9.7743765109E-01],
	[4.4830000000E+04, 4.1676663184E+01, 5.2136849164E+00, 2.2942150035E+01, 3.8552721734E+00, 9.7744686259E-01],
	[4.4835000000E+04, 4.1684882849E+01, 5.2137284854E+00, 2.2950500470E+01, 3.8556020649E+00, 9.7745606977E-01],
	[4.4840000000E+04, 4.1693103219E+01, 5.2137720500E+00, 2.2958853012E+01, 3.8559318761E+00, 9.7746527263E-01],
	[4.4845000000E+04, 4.1701324292E+01, 5.2138156100E+00, 2.2967207660E+01, 3.8562616072E+00, 9.7747447119E-01],
	[4.4850000000E+04, 4.1709546070E+01, 5.2138591656E+00, 2.2975564415E+01, 3.8565912580E+00, 9.7748366543E-01],
	[4.4855000000E+04, 4.1717768552E+01, 5.2139027166E+00, 2.2983923278E+01, 3.8569208287E+00, 9.7749285536E-01],
	[4.4860000000E+04, 4.1725991738E+01, 5.2139462632E+00, 2.2992284249E+01, 3.8572503193E+00, 9.7750204099E-01],
	[4.4865000000E+04, 4.1734215629E+01, 5.2139898053E+00, 2.3000647327E+01, 3.8575797298E+00, 9.7751122232E-01],
	[4.4870000000E+04, 4.1742440223E+01, 5.2140333429E+00, 2.3009012513E+01, 3.8579090601E+00, 9.7752039935E-01],
	[4.4875000000E+04, 4.1750665522E+01, 5.2140768760E+00, 2.3017379808E+01, 3.8582383104E+00, 9.7752957208E-01],
	[4.4880000000E+04, 4.1758891524E+01, 5.2141204046E+00, 2.3025749212E+01, 3.8585674807E+00, 9.7753874051E-01],
	[4.4885000000E+04, 4.1767118231E+01, 5.2141639287E+00, 2.3034120725E+01, 3.8588965708E+00, 9.7754790466E-01],
	[4.4890000000E+04, 4.1775345642E+01, 5.2142074484E+00, 2.3042494347E+01, 3.8592255810E+00, 9.7755706450E-01],
	[4.4895000000E+04, 4.1783573757E+01, 5.2142509635E+00, 2.3050870080E+01, 3.8595545112E+00, 9.7756622007E-01],
	[4.4900000000E+04, 4.1791802576E+01, 5.2142944742E+00, 2.3059247922E+01, 3.8598833614E+00, 9.7757537134E-01],
	[4.4905000000E+04, 4.1800032099E+01, 5.2143379804E+00, 2.3067627874E+01, 3.8602121316E+00, 9.7758451833E-01],
	[4.4910000000E+04, 4.1808262325E+01, 5.2143814821E+00, 2.3076009937E+01, 3.8605408219E+00, 9.7759366104E-01],
	[4.4915000000E+04, 4.1816493256E+01, 5.2144249793E+00, 2.3084394111E+01, 3.8608694323E+00, 9.7760279947E-01],
	[4.4920000000E+04, 4.1824724891E+01, 5.2144684721E+00, 2.3092780396E+01, 3.8611979627E+00, 9.7761193362E-01],
	[4.4925000000E+04, 4.1832957230E+01, 5.2145119604E+00, 2.3101168792E+01, 3.8615264133E+00, 9.7762106349E-01],
	[4.4930000000E+04, 4.1841190272E+01, 5.2145554442E+00, 2.3109559301E+01, 3.8618547841E+00, 9.7763018910E-01],
	[4.4935000000E+04, 4.1849424019E+01, 5.2145989235E+00, 2.3117951921E+01, 3.8621830750E+00, 9.7763931043E-01],
	[4.4940000000E+04, 4.1857658469E+01, 5.2146423983E+00, 2.3126346654E+01, 3.8625112860E+00, 9.7764842750E-01],
	[4.4945000000E+04, 4.1865893624E+01, 5.2146858687E+00, 2.3134743499E+01, 3.8628394173E+00, 9.7765754030E-01],
	[4.4950000000E+04, 4.1874129482E+01, 5.2147293346E+00, 2.3143142457E+01, 3.8631674688E+00, 9.7766664883E-01],
	[4.4955000000E+04, 4.1882366044E+01, 5.2147727960E+00, 2.3151543529E+01, 3.8634954406E+00, 9.7767575311E-01],
	[4.4960000000E+04, 4.1890603310E+01, 5.2148162530E+00, 2.3159946714E+01, 3.8638233326E+00, 9.7768485312E-01],
	[4.4965000000E+04, 4.1898841279E+01, 5.2148597055E+00, 2.3168352013E+01, 3.8641511448E+00, 9.7769394888E-01],
	[4.4970000000E+04, 4.1907079953E+01, 5.2149031535E+00, 2.3176759426E+01, 3.8644788774E+00, 9.7770304039E-01],
	[4.4975000000E+04, 4.1915319330E+01, 5.2149465970E+00, 2.3185168954E+01, 3.8648065303E+00, 9.7771212764E-01],
	[4.4980000000E+04, 4.1923559411E+01, 5.2149900361E+00, 2.3193580596E+01, 3.8651341036E+00, 9.7772121064E-01],
	[4.4985000000E+04, 4.1931800195E+01, 5.2150334707E+00, 2.3201994353E+01, 3.8654615972E+00, 9.7773028940E-01],
	[4.4990000000E+04, 4.1940041683E+01, 5.2150769009E+00, 2.3210410226E+01, 3.8657890111E+00, 9.7773936391E-01],
	[4.4995000000E+04, 4.1948283875E+01, 5.2151203266E+00, 2.3218828214E+01, 3.8661163455E+00, 9.7774843418E-01],
	[4.5000000000E+04, 4.1956526771E+01, 5.2151637478E+00, 2.3227248319E+01, 3.8664436003E+00, 9.7775750021E-01],
	[4.5005000000E+04, 4.1964770370E+01, 5.2152071645E+00, 2.3235688187E+01, 3.8667712643E+00, 9.7776656200E-01],
	[4.5010000000E+04, 4.1973014673E+01, 5.2152505768E+00, 2.3244130183E+01, 3.8670988485E+00, 9.7777561955E-01],
	[4.5015000000E+04, 4.1981259679E+01, 5.2152939847E+00, 2.3252574307E+01, 3.8674263529E+00, 9.7778467287E-01],
	[4.5020000000E+04, 4.1989505389E+01, 5.2153373880E+00, 2.3261020558E+01, 3.8677537776E+00, 9.7779372196E-01],
	[4.5025000000E+04, 4.1997751803E+01, 5.2153807870E+00, 2.3269468938E+01, 3.8680811226E+00, 9.7780276682E-01],
	[4.5030000000E+04, 4.2005998920E+01, 5.2154241814E+00, 2.3277919446E+01, 3.8684083879E+00, 9.7781180745E-01],
	[4.5035000000E+04, 4.2014246741E+01, 5.2154675714E+00, 2.3286372084E+01, 3.8687355734E+00, 9.7782084386E-01],
	[4.5040000000E+04, 4.2022495265E+01, 5.2155109570E+00, 2.3294826850E+01, 3.8690626794E+00, 9.7782987605E-01],
	[4.5045000000E+04, 4.2030744493E+01, 5.2155543381E+00, 2.3303283746E+01, 3.8693897056E+00, 9.7783890401E-01],
	[4.5050000000E+04, 4.2038994424E+01, 5.2155977147E+00, 2.3311742772E+01, 3.8697166523E+00, 9.7784792776E-01],
	[4.5055000000E+04, 4.2047245059E+01, 5.2156410869E+00, 2.3320203927E+01, 3.8700435193E+00, 9.7785694729E-01],
	[4.5060000000E+04, 4.2055496397E+01, 5.2156844546E+00, 2.3328667214E+01, 3.8703703068E+00, 9.7786596261E-01],
	[4.5065000000E+04, 4.2063748438E+01, 5.2157278179E+00, 2.3337132630E+01, 3.8706970147E+00, 9.7787497372E-01],
	[4.5070000000E+04, 4.2072001183E+01, 5.2157711767E+00, 2.3345600178E+01, 3.8710236430E+00, 9.7788398062E-01],
	[4.5075000000E+04, 4.2080254632E+01, 5.2158145311E+00, 2.3354069857E+01, 3.8713501919E+00, 9.7789298332E-01],
	[4.5080000000E+04, 4.2088508783E+01, 5.2158578810E+00, 2.3362541668E+01, 3.8716766612E+00, 9.7790198181E-01],
	[4.5085000000E+04, 4.2096763638E+01, 5.2159012265E+00, 2.3371015610E+01, 3.8720030510E+00, 9.7791097609E-01],
	[4.5090000000E+04, 4.2105019197E+01, 5.2159445675E+00, 2.3379491685E+01, 3.8723293614E+00, 9.7791996618E-01],
	[4.5095000000E+04, 4.2113275459E+01, 5.2159879041E+00, 2.3387969892E+01, 3.8726555923E+00, 9.7792895208E-01],
	[4.5100000000E+04, 4.2121532424E+01, 5.2160312362E+00, 2.3396450232E+01, 3.8729817438E+00, 9.7793793377E-01],
	[4.5105000000E+04, 4.2129790092E+01, 5.2160745639E+00, 2.3404932705E+01, 3.8733078159E+00, 9.7794691128E-01],
	[4.5110000000E+04, 4.2138048464E+01, 5.2161178872E+00, 2.3413417311E+01, 3.8736338086E+00, 9.7795588459E-01],
	[4.5115000000E+04, 4.2146307538E+01, 5.2161612060E+00, 2.3421904051E+01, 3.8739597220E+00, 9.7796485371E-01],
	[4.5120000000E+04, 4.2154567316E+01, 5.2162045204E+00, 2.3430392925E+01, 3.8742855560E+00, 9.7797381865E-01],
	[4.5125000000E+04, 4.2162827798E+01, 5.2162478303E+00, 2.3438883933E+01, 3.8746113107E+00, 9.7798277941E-01],
	[4.5130000000E+04, 4.2171088982E+01, 5.2162911358E+00, 2.3447377076E+01, 3.8749369861E+00, 9.7799173599E-01],
	[4.5135000000E+04, 4.2179350870E+01, 5.2163344369E+00, 2.3455872354E+01, 3.8752625822E+00, 9.7800068838E-01],
	[4.5140000000E+04, 4.2187613460E+01, 5.2163777335E+00, 2.3464369766E+01, 3.8755880990E+00, 9.7800963660E-01],
	[4.5145000000E+04, 4.2195876754E+01, 5.2164210257E+00, 2.3472869315E+01, 3.8759135366E+00, 9.7801858064E-01],
	[4.5150000000E+04, 4.2204140751E+01, 5.2164643134E+00, 2.3481370999E+01, 3.8762388949E+00, 9.7802752052E-01],
	[4.5155000000E+04, 4.2212405452E+01, 5.2165075967E+00, 2.3489874819E+01, 3.8765641741E+00, 9.7803645622E-01],
	[4.5160000000E+04, 4.2220670855E+01, 5.2165508756E+00, 2.3498380775E+01, 3.8768893740E+00, 9.7804538775E-01],
	[4.5165000000E+04, 4.2228936961E+01, 5.2165941501E+00, 2.3506888868E+01, 3.8772144948E+00, 9.7805431512E-01],
	[4.5170000000E+04, 4.2237203770E+01, 5.2166374201E+00, 2.3515399098E+01, 3.8775395365E+00, 9.7806323832E-01],
	[4.5175000000E+04, 4.2245471283E+01, 5.2166806857E+00, 2.3523911465E+01, 3.8778644990E+00, 9.7807215736E-01],
	[4.5180000000E+04, 4.2253739498E+01, 5.2167239468E+00, 2.3532425970E+01, 3.8781893824E+00, 9.7808107224E-01],
	[4.5185000000E+04, 4.2262008416E+01, 5.2167672036E+00, 2.3540942613E+01, 3.8785141868E+00, 9.7808998296E-01],
	[4.5190000000E+04, 4.2270278038E+01, 5.2168104559E+00, 2.3549461394E+01, 3.8788389120E+00, 9.7809888952E-01],
	[4.5195000000E+04, 4.2278548362E+01, 5.2168537037E+00, 2.3557982313E+01, 3.8791635583E+00, 9.7810779193E-01],
	[4.5200000000E+04, 4.2286819389E+01, 5.2168969472E+00, 2.3566505371E+01, 3.8794881255E+00, 9.7811669018E-01],
	[4.5205000000E+04, 4.2295091120E+01, 5.2169401862E+00, 2.3575030569E+01, 3.8798126137E+00, 9.7812558429E-01],
	[4.5210000000E+04, 4.2303363553E+01, 5.2169834208E+00, 2.3583557905E+01, 3.8801370229E+00, 9.7813447424E-01],
	[4.5215000000E+04, 4.2311636689E+01, 5.2170266510E+00, 2.3592087381E+01, 3.8804613531E+00, 9.7814336005E-01],
	[4.5220000000E+04, 4.2319910527E+01, 5.2170698767E+00, 2.3600618997E+01, 3.8807856044E+00, 9.7815224172E-01],
	[4.5225000000E+04, 4.2328185069E+01, 5.2171130981E+00, 2.3609152754E+01, 3.8811097768E+00, 9.7816111924E-01],
	[4.5230000000E+04, 4.2336460313E+01, 5.2171563150E+00, 2.3617688651E+01, 3.8814338702E+00, 9.7816999262E-01],
	[4.5235000000E+04, 4.2344736261E+01, 5.2171995275E+00, 2.3626226688E+01, 3.8817578848E+00, 9.7817886186E-01],
	[4.5240000000E+04, 4.2353012911E+01, 5.2172427355E+00, 2.3634766867E+01, 3.8820818205E+00, 9.7818772697E-01],
	[4.5245000000E+04, 4.2361290264E+01, 5.2172859392E+00, 2.3643309188E+01, 3.8824056774E+00, 9.7819658794E-01],
	[4.5250000000E+04, 4.2369568319E+01, 5.2173291384E+00, 2.3651853650E+01, 3.8827294554E+00, 9.7820544478E-01],
	[4.5255000000E+04, 4.2377847078E+01, 5.2173723333E+00, 2.3660400254E+01, 3.8830531546E+00, 9.7821429748E-01],
	[4.5260000000E+04, 4.2386126539E+01, 5.2174155237E+00, 2.3668949001E+01, 3.8833767751E+00, 9.7822314606E-01],
	[4.5265000000E+04, 4.2394406703E+01, 5.2174587097E+00, 2.3677499890E+01, 3.8837003167E+00, 9.7823199052E-01],
	[4.5270000000E+04, 4.2402687569E+01, 5.2175018912E+00, 2.3686052922E+01, 3.8840237797E+00, 9.7824083084E-01],
	[4.5275000000E+04, 4.2410969138E+01, 5.2175450684E+00, 2.3694608098E+01, 3.8843471639E+00, 9.7824966705E-01],
	[4.5280000000E+04, 4.2419251410E+01, 5.2175882412E+00, 2.3703165417E+01, 3.8846704694E+00, 9.7825849913E-01],
	[4.5285000000E+04, 4.2427534385E+01, 5.2176314095E+00, 2.3711724879E+01, 3.8849936962E+00, 9.7826732710E-01],
	[4.5290000000E+04, 4.2435818062E+01, 5.2176745735E+00, 2.3720286486E+01, 3.8853168443E+00, 9.7827615095E-01],
	[4.5295000000E+04, 4.2444102441E+01, 5.2177177330E+00, 2.3728850238E+01, 3.8856399138E+00, 9.7828497068E-01],
	[4.5300000000E+04, 4.2452387524E+01, 5.2177608881E+00, 2.3737416134E+01, 3.8859629046E+00, 9.7829378631E-01],
	[4.5305000000E+04, 4.2460683740E+01, 5.2178051995E+00, 2.3745984175E+01, 3.8862865481E+00, 9.7830259782E-01],
	[4.5310000000E+04, 4.2468986633E+01, 5.2178501704E+00, 2.3754554362E+01, 3.8866105316E+00, 9.7831140522E-01],
	[4.5315000000E+04, 4.2477290232E+01, 5.2178951367E+00, 2.3763126694E+01, 3.8869344367E+00, 9.7832020852E-01],
	[4.5320000000E+04, 4.2485594538E+01, 5.2179400985E+00, 2.3771701172E+01, 3.8872582634E+00, 9.7832900771E-01],
	[4.5325000000E+04, 4.2493899552E+01, 5.2179850557E+00, 2.3780277797E+01, 3.8875820118E+00, 9.7833780280E-01],
	[4.5330000000E+04, 4.2502205272E+01, 5.2180300083E+00, 2.3788856568E+01, 3.8879056818E+00, 9.7834659379E-01],
	[4.5335000000E+04, 4.2510511700E+01, 5.2180749564E+00, 2.3797437486E+01, 3.8882292736E+00, 9.7835538068E-01],
	[4.5340000000E+04, 4.2518818834E+01, 5.2181198998E+00, 2.3806020551E+01, 3.8885527870E+00, 9.7836416347E-01],
	[4.5345000000E+04, 4.2527126676E+01, 5.2181648387E+00, 2.3814605763E+01, 3.8888762222E+00, 9.7837294217E-01],
	[4.5350000000E+04, 4.2535435225E+01, 5.2182097731E+00, 2.3823193123E+01, 3.8891995792E+00, 9.7838171677E-01],
	[4.5355000000E+04, 4.2543744480E+01, 5.2182547028E+00, 2.3831782632E+01, 3.8895228579E+00, 9.7839048729E-01],
	[4.5360000000E+04, 4.2552054443E+01, 5.2182996280E+00, 2.3840374288E+01, 3.8898460584E+00, 9.7839925372E-01],
	[4.5365000000E+04, 4.2560365112E+01, 5.2183445487E+00, 2.3848968094E+01, 3.8901691808E+00, 9.7840801606E-01],
	[4.5370000000E+04, 4.2568676489E+01, 5.2183894648E+00, 2.3857564048E+01, 3.8904922249E+00, 9.7841677431E-01],
	[4.5375000000E+04, 4.2576988572E+01, 5.2184343763E+00, 2.3866162151E+01, 3.8908151909E+00, 9.7842552849E-01],
	[4.5380000000E+04, 4.2585301362E+01, 5.2184792832E+00, 2.3874762404E+01, 3.8911380788E+00, 9.7843427858E-01],
	[4.5385000000E+04, 4.2593614859E+01, 5.2185241856E+00, 2.3883364807E+01, 3.8914608886E+00, 9.7844302459E-01],
	[4.5390000000E+04, 4.2601929063E+01, 5.2185690834E+00, 2.3891969360E+01, 3.8917836203E+00, 9.7845176653E-01],
	[4.5395000000E+04, 4.2610243974E+01, 5.2186139767E+00, 2.3900576064E+01, 3.8921062739E+00, 9.7846050440E-01],
	[4.5400000000E+04, 4.2618559592E+01, 5.2186588654E+00, 2.3909184918E+01, 3.8924288495E+00, 9.7846923819E-01],
	[4.5405000000E+04, 4.2626875916E+01, 5.2187037496E+00, 2.3917795923E+01, 3.8927513471E+00, 9.7847796791E-01],
	[4.5410000000E+04, 4.2635192947E+01, 5.2187486292E+00, 2.3926409080E+01, 3.8930737666E+00, 9.7848669356E-01],
	[4.5415000000E+04, 4.2643510685E+01, 5.2187935042E+00, 2.3935024388E+01, 3.8933961082E+00, 9.7849541514E-01],
	[4.5420000000E+04, 4.2651829130E+01, 5.2188383747E+00, 2.3943641849E+01, 3.8937183718E+00, 9.7850413266E-01],
	[4.5425000000E+04, 4.2660148281E+01, 5.2188832406E+00, 2.3952261461E+01, 3.8940405574E+00, 9.7851284612E-01],
	[4.5430000000E+04, 4.2668468140E+01, 5.2189281020E+00, 2.3960883226E+01, 3.8943626651E+00, 9.7852155552E-01],
	[4.5435000000E+04, 4.2676788704E+01, 5.2189729588E+00, 2.3969507144E+01, 3.8946846949E+00, 9.7853026086E-01],
	[4.5440000000E+04, 4.2685109976E+01, 5.2190178111E+00, 2.3978133215E+01, 3.8950066468E+00, 9.7853896214E-01],
	[4.5445000000E+04, 4.2693431954E+01, 5.2190626588E+00, 2.3986761440E+01, 3.8953285208E+00, 9.7854765936E-01],
	[4.5450000000E+04, 4.2701754639E+01, 5.2191075020E+00, 2.3995391818E+01, 3.8956503170E+00, 9.7855635254E-01],
	[4.5455000000E+04, 4.2710078030E+01, 5.2191523407E+00, 2.4004024350E+01, 3.8959720354E+00, 9.7856504166E-01],
	[4.5460000000E+04, 4.2718402129E+01, 5.2191971747E+00, 2.4012659037E+01, 3.8962936759E+00, 9.7857372674E-01],
	[4.5465000000E+04, 4.2726726933E+01, 5.2192420043E+00, 2.4021295878E+01, 3.8966152387E+00, 9.7858240777E-01],
	[4.5470000000E+04, 4.2735052444E+01, 5.2192868293E+00, 2.4029934875E+01, 3.8969367236E+00, 9.7859108475E-01],
	[4.5475000000E+04, 4.2743378662E+01, 5.2193316497E+00, 2.4038576026E+01, 3.8972581309E+00, 9.7859975769E-01],
	[4.5480000000E+04, 4.2751705587E+01, 5.2193764656E+00, 2.4047219333E+01, 3.8975794604E+00, 9.7860842659E-01],
	[4.5485000000E+04, 4.2760033217E+01, 5.2194212770E+00, 2.4055864796E+01, 3.8979007121E+00, 9.7861709145E-01],
	[4.5490000000E+04, 4.2768361555E+01, 5.2194660838E+00, 2.4064512415E+01, 3.8982218862E+00, 9.7862575228E-01],
	[4.5495000000E+04, 4.2776690599E+01, 5.2195108861E+00, 2.4073162191E+01, 3.8985429826E+00, 9.7863440907E-01],
	[4.5500000000E+04, 4.2785020349E+01, 5.2195556839E+00, 2.4081814123E+01, 3.8988640014E+00, 9.7864306183E-01],
	[4.5505000000E+04, 4.2793350806E+01, 5.2196004771E+00, 2.4090468213E+01, 3.8991849425E+00, 9.7865171055E-01],
	[4.5510000000E+04, 4.2801681969E+01, 5.2196452657E+00, 2.4099124459E+01, 3.8995058060E+00, 9.7866035525E-01],
	[4.5515000000E+04, 4.2810013838E+01, 5.2196900499E+00, 2.4107782864E+01, 3.8998265919E+00, 9.7866899592E-01],
	[4.5520000000E+04, 4.2818346414E+01, 5.2197348295E+00, 2.4116443426E+01, 3.9001473003E+00, 9.7867763257E-01],
	[4.5525000000E+04, 4.2826679697E+01, 5.2197796045E+00, 2.4125106147E+01, 3.9004679310E+00, 9.7868626519E-01],
	[4.5530000000E+04, 4.2835013685E+01, 5.2198243751E+00, 2.4133771026E+01, 3.9007884843E+00, 9.7869489380E-01],
	[4.5535000000E+04, 4.2843348381E+01, 5.2198691411E+00, 2.4142438064E+01, 3.9011089600E+00, 9.7870351838E-01],
	[4.5540000000E+04, 4.2851683782E+01, 5.2199139025E+00, 2.4151107261E+01, 3.9014293583E+00, 9.7871213895E-01],
	[4.5545000000E+04, 4.2860019890E+01, 5.2199586595E+00, 2.4159778618E+01, 3.9017496790E+00, 9.7872075550E-01],
	[4.5550000000E+04, 4.2868356704E+01, 5.2200034119E+00, 2.4168452134E+01, 3.9020699223E+00, 9.7872936804E-01],
	[4.5555000000E+04, 4.2876694224E+01, 5.2200481598E+00, 2.4177127811E+01, 3.9023900882E+00, 9.7873797657E-01],
	[4.5560000000E+04, 4.2885032450E+01, 5.2200929031E+00, 2.4185805647E+01, 3.9027101766E+00, 9.7874658109E-01],
	[4.5565000000E+04, 4.2893371383E+01, 5.2201376419E+00, 2.4194485645E+01, 3.9030301876E+00, 9.7875518160E-01],
	[4.5570000000E+04, 4.2901711022E+01, 5.2201823762E+00, 2.4203167803E+01, 3.9033501213E+00, 9.7876377811E-01],
	[4.5575000000E+04, 4.2910051367E+01, 5.2202271060E+00, 2.4211852123E+01, 3.9036699776E+00, 9.7877237061E-01],
	[4.5580000000E+04, 4.2918392419E+01, 5.2202718313E+00, 2.4220538604E+01, 3.9039897566E+00, 9.7878095912E-01],
	[4.5585000000E+04, 4.2926734176E+01, 5.2203165520E+00, 2.4229227247E+01, 3.9043094582E+00, 9.7878954362E-01],
	[4.5590000000E+04, 4.2935076640E+01, 5.2203612682E+00, 2.4237918052E+01, 3.9046290826E+00, 9.7879812413E-01],
	[4.5595000000E+04, 4.2943419809E+01, 5.2204059799E+00, 2.4246611020E+01, 3.9049486296E+00, 9.7880670064E-01],
	[4.5600000000E+04, 4.2951763685E+01, 5.2204506870E+00, 2.4255306151E+01, 3.9052680994E+00, 9.7881527316E-01],
	[4.5605000000E+04, 4.2960108267E+01, 5.2204953897E+00, 2.4264003444E+01, 3.9055874920E+00, 9.7882384169E-01],
	[4.5610000000E+04, 4.2968453555E+01, 5.2205400878E+00, 2.4272702901E+01, 3.9059068074E+00, 9.7883240623E-01],
	[4.5615000000E+04, 4.2976799550E+01, 5.2205847814E+00, 2.4281404522E+01, 3.9062260455E+00, 9.7884096678E-01],
	[4.5620000000E+04, 4.2985146250E+01, 5.2206294705E+00, 2.4290108306E+01, 3.9065452064E+00, 9.7884952335E-01],
	[4.5625000000E+04, 4.2993493656E+01, 5.2206741551E+00, 2.4298814255E+01, 3.9068642902E+00, 9.7885807594E-01],
	[4.5630000000E+04, 4.3001841768E+01, 5.2207188352E+00, 2.4307522368E+01, 3.9071832969E+00, 9.7886662454E-01],
	[4.5635000000E+04, 4.3010190586E+01, 5.2207635107E+00, 2.4316232646E+01, 3.9075022264E+00, 9.7887516916E-01],
	[4.5640000000E+04, 4.3018540110E+01, 5.2208081818E+00, 2.4324945090E+01, 3.9078210789E+00, 9.7888370981E-01],
	[4.5645000000E+04, 4.3026890340E+01, 5.2208528483E+00, 2.4333659699E+01, 3.9081398542E+00, 9.7889224648E-01],
	[4.5650000000E+04, 4.3035241277E+01, 5.2208975103E+00, 2.4342376473E+01, 3.9084585525E+00, 9.7890077918E-01],
	[4.5655000000E+04, 4.3043592918E+01, 5.2209421678E+00, 2.4351095414E+01, 3.9087771737E+00, 9.7890930791E-01],
	[4.5660000000E+04, 4.3051945266E+01, 5.2209868208E+00, 2.4359816521E+01, 3.9090957179E+00, 9.7891783267E-01],
	[4.5665000000E+04, 4.3060298320E+01, 5.2210314693E+00, 2.4368539795E+01, 3.9094141851E+00, 9.7892635346E-01],
	[4.5670000000E+04, 4.3068652080E+01, 5.2210761133E+00, 2.4377265235E+01, 3.9097325753E+00, 9.7893487028E-01],
	[4.5675000000E+04, 4.3077006545E+01, 5.2211207528E+00, 2.4385992843E+01, 3.9100508886E+00, 9.7894338314E-01],
	[4.5680000000E+04, 4.3085361716E+01, 5.2211653877E+00, 2.4394722619E+01, 3.9103691249E+00, 9.7895189204E-01],
	[4.5685000000E+04, 4.3093717593E+01, 5.2212100182E+00, 2.4403454562E+01, 3.9106872842E+00, 9.7896039698E-01],
	[4.5690000000E+04, 4.3102074176E+01, 5.2212546442E+00, 2.4412188674E+01, 3.9110053667E+00, 9.7896889797E-01],
	[4.5695000000E+04, 4.3110431465E+01, 5.2212992657E+00, 2.4420924954E+01, 3.9113233723E+00, 9.7897739499E-01],
	[4.5700000000E+04, 4.3118789459E+01, 5.2213438826E+00, 2.4429663402E+01, 3.9116413010E+00, 9.7898588807E-01],
	[4.5705000000E+04, 4.3127148160E+01, 5.2213884951E+00, 2.4438404020E+01, 3.9119591529E+00, 9.7899437719E-01],
	[4.5710000000E+04, 4.3135507565E+01, 5.2214331030E+00, 2.4447146808E+01, 3.9122769279E+00, 9.7900286236E-01],
	[4.5715000000E+04, 4.3143867677E+01, 5.2214777065E+00, 2.4455891764E+01, 3.9125946261E+00, 9.7901134359E-01],
	[4.5720000000E+04, 4.3152228494E+01, 5.2215223055E+00, 2.4464638891E+01, 3.9129122476E+00, 9.7901982087E-01],
	[4.5725000000E+04, 4.3160590017E+01, 5.2215669000E+00, 2.4473388188E+01, 3.9132297922E+00, 9.7902829421E-01],
	[4.5730000000E+04, 4.3168952246E+01, 5.2216114899E+00, 2.4482139656E+01, 3.9135472601E+00, 9.7903676360E-01],
	[4.5735000000E+04, 4.3177315180E+01, 5.2216560754E+00, 2.4490893295E+01, 3.9138646513E+00, 9.7904522905E-01],
	[4.5740000000E+04, 4.3185678820E+01, 5.2217006564E+00, 2.4499649105E+01, 3.9141819658E+00, 9.7905369057E-01],
	[4.5745000000E+04, 4.3194043165E+01, 5.2217452329E+00, 2.4508407086E+01, 3.9144992036E+00, 9.7906214815E-01],
	[4.5750000000E+04, 4.3202408216E+01, 5.2217898049E+00, 2.4517167239E+01, 3.9148163647E+00, 9.7907060180E-01],
	[4.5755000000E+04, 4.3210773973E+01, 5.2218343724E+00, 2.4525929564E+01, 3.9151334491E+00, 9.7907905152E-01],
	[4.5760000000E+04, 4.3219140435E+01, 5.2218789355E+00, 2.4534694061E+01, 3.9154504569E+00, 9.7908749730E-01],
	[4.5765000000E+04, 4.3227507603E+01, 5.2219234940E+00, 2.4543460731E+01, 3.9157673881E+00, 9.7909593916E-01],
	[4.5770000000E+04, 4.3235875476E+01, 5.2219680481E+00, 2.4552229575E+01, 3.9160842428E+00, 9.7910437709E-01],
	[4.5775000000E+04, 4.3244244055E+01, 5.2220125976E+00, 2.4561000591E+01, 3.9164010208E+00, 9.7911281110E-01],
	[4.5780000000E+04, 4.3252613339E+01, 5.2220571427E+00, 2.4569773781E+01, 3.9167177223E+00, 9.7912124118E-01],
	[4.5785000000E+04, 4.3260983329E+01, 5.2221016833E+00, 2.4578549145E+01, 3.9170343472E+00, 9.7912966735E-01],
	[4.5790000000E+04, 4.3269354024E+01, 5.2221462194E+00, 2.4587326683E+01, 3.9173508957E+00, 9.7913808960E-01],
	[4.5795000000E+04, 4.3277725424E+01, 5.2221907510E+00, 2.4596106395E+01, 3.9176673676E+00, 9.7914650793E-01],
	[4.5800000000E+04, 4.3286097530E+01, 5.2222352782E+00, 2.4604888283E+01, 3.9179837631E+00, 9.7915492234E-01],
	[4.5805000000E+04, 4.3294470341E+01, 5.2222798008E+00, 2.4613672345E+01, 3.9183000821E+00, 9.7916333285E-01],
	[4.5810000000E+04, 4.3302843858E+01, 5.2223243190E+00, 2.4622458583E+01, 3.9186163246E+00, 9.7917173944E-01],
	[4.5815000000E+04, 4.3311218080E+01, 5.2223688327E+00, 2.4631246996E+01, 3.9189324908E+00, 9.7918014213E-01],
	[4.5820000000E+04, 4.3319593007E+01, 5.2224133419E+00, 2.4640037586E+01, 3.9192485805E+00, 9.7918854091E-01],
	[4.5825000000E+04, 4.3327968640E+01, 5.2224578467E+00, 2.4648830352E+01, 3.9195645939E+00, 9.7919693578E-01],
	[4.5830000000E+04, 4.3336344978E+01, 5.2225023470E+00, 2.4657625294E+01, 3.9198805309E+00, 9.7920532676E-01],
	[4.5835000000E+04, 4.3344722021E+01, 5.2225468428E+00, 2.4666422413E+01, 3.9201963916E+00, 9.7921371383E-01],
	[4.5840000000E+04, 4.3353099770E+01, 5.2225913341E+00, 2.4675221710E+01, 3.9205121759E+00, 9.7922209700E-01],
	[4.5845000000E+04, 4.3361478223E+01, 5.2226358209E+00, 2.4684023183E+01, 3.9208278840E+00, 9.7923047628E-01],
	[4.5850000000E+04, 4.3369857382E+01, 5.2226803033E+00, 2.4692826835E+01, 3.9211435157E+00, 9.7923885166E-01],
	[4.5855000000E+04, 4.3378237247E+01, 5.2227247812E+00, 2.4701632665E+01, 3.9214590713E+00, 9.7924722315E-01],
	[4.5860000000E+04, 4.3386617816E+01, 5.2227692546E+00, 2.4710440673E+01, 3.9217745505E+00, 9.7925559075E-01],
	[4.5865000000E+04, 4.3394999091E+01, 5.2228137236E+00, 2.4719250860E+01, 3.9220899536E+00, 9.7926395446E-01],
	[4.5870000000E+04, 4.3403381070E+01, 5.2228581881E+00, 2.4728063226E+01, 3.9224052804E+00, 9.7927231428E-01],
	[4.5875000000E+04, 4.3411763755E+01, 5.2229026481E+00, 2.4736877771E+01, 3.9227205311E+00, 9.7928067022E-01],
	[4.5880000000E+04, 4.3420147145E+01, 5.2229471037E+00, 2.4745694496E+01, 3.9230357056E+00, 9.7928902228E-01],
	[4.5885000000E+04, 4.3428531240E+01, 5.2229915548E+00, 2.4754513400E+01, 3.9233508039E+00, 9.7929737045E-01],
	[4.5890000000E+04, 4.3436916041E+01, 5.2230360014E+00, 2.4763334485E+01, 3.9236658261E+00, 9.7930571475E-01],
	[4.5895000000E+04, 4.3445301546E+01, 5.2230804435E+00, 2.4772157750E+01, 3.9239807722E+00, 9.7931405517E-01],
	[4.5900000000E+04, 4.3453687756E+01, 5.2231248812E+00, 2.4780983197E+01, 3.9242956423E+00, 9.7932239171E-01],
	[4.5905000000E+04, 4.3462074672E+01, 5.2231693145E+00, 2.4789810824E+01, 3.9246104363E+00, 9.7933072438E-01],
	[4.5910000000E+04, 4.3470462292E+01, 5.2232137433E+00, 2.4798640632E+01, 3.9249251542E+00, 9.7933905318E-01],
	[4.5915000000E+04, 4.3478850617E+01, 5.2232581676E+00, 2.4807472623E+01, 3.9252397961E+00, 9.7934737811E-01],
	[4.5920000000E+04, 4.3487239648E+01, 5.2233025874E+00, 2.4816306795E+01, 3.9255543620E+00, 9.7935569918E-01],
	[4.5925000000E+04, 4.3495629383E+01, 5.2233470028E+00, 2.4825143150E+01, 3.9258688519E+00, 9.7936401637E-01],
	[4.5930000000E+04, 4.3504019823E+01, 5.2233914138E+00, 2.4833981687E+01, 3.9261832658E+00, 9.7937232971E-01],
	[4.5935000000E+04, 4.3512410969E+01, 5.2234358202E+00, 2.4842822407E+01, 3.9264976038E+00, 9.7938063918E-01],
	[4.5940000000E+04, 4.3520802819E+01, 5.2234802223E+00, 2.4851665311E+01, 3.9268118658E+00, 9.7938894479E-01],
	[4.5945000000E+04, 4.3529195374E+01, 5.2235246198E+00, 2.4860510397E+01, 3.9271260520E+00, 9.7939724655E-01],
	[4.5950000000E+04, 4.3537588634E+01, 5.2235690129E+00, 2.4869357668E+01, 3.9274401622E+00, 9.7940554445E-01],
	[4.5955000000E+04, 4.3545982598E+01, 5.2236134016E+00, 2.4878207123E+01, 3.9277541966E+00, 9.7941383850E-01],
	[4.5960000000E+04, 4.3554377268E+01, 5.2236577858E+00, 2.4887058762E+01, 3.9280681551E+00, 9.7942212869E-01],
	[4.5965000000E+04, 4.3562772643E+01, 5.2237021656E+00, 2.4895912586E+01, 3.9283820378E+00, 9.7943041504E-01],
	[4.5970000000E+04, 4.3571168722E+01, 5.2237465409E+00, 2.4904768595E+01, 3.9286958447E+00, 9.7943869753E-01],
	[4.5975000000E+04, 4.3579565506E+01, 5.2237909118E+00, 2.4913626789E+01, 3.9290095758E+00, 9.7944697619E-01],
	[4.5980000000E+04, 4.3587962995E+01, 5.2238352782E+00, 2.4922487169E+01, 3.9293232311E+00, 9.7945525099E-01],
	[4.5985000000E+04, 4.3596361188E+01, 5.2238796401E+00, 2.4931349735E+01, 3.9296368107E+00, 9.7946352196E-01],
	[4.5990000000E+04, 4.3604760087E+01, 5.2239239976E+00, 2.4940214487E+01, 3.9299503145E+00, 9.7947178908E-01],
	[4.5995000000E+04, 4.3613159690E+01, 5.2239683507E+00, 2.4949081425E+01, 3.9302637426E+00, 9.7948005237E-01],
	[4.6000000000E+04, 4.3621559997E+01, 5.2240126993E+00, 2.4957950551E+01, 3.9305770950E+00, 9.7948831182E-01],
	[4.6005000000E+04, 4.3629961010E+01, 5.2240570435E+00, 2.4966821863E+01, 3.9308903718E+00, 9.7949656744E-01],
	[4.6010000000E+04, 4.3638362727E+01, 5.2241013833E+00, 2.4975695363E+01, 3.9312035729E+00, 9.7950481922E-01],
	[4.6015000000E+04, 4.3646765149E+01, 5.2241457186E+00, 2.4984571051E+01, 3.9315166983E+00, 9.7951306718E-01],
	[4.6020000000E+04, 4.3655168275E+01, 5.2241900494E+00, 2.4993448926E+01, 3.9318297481E+00, 9.7952131130E-01],
	[4.6025000000E+04, 4.3663572106E+01, 5.2242343758E+00, 2.5002328990E+01, 3.9321427224E+00, 9.7952955160E-01],
	[4.6030000000E+04, 4.3671976642E+01, 5.2242786978E+00, 2.5011211243E+01, 3.9324556210E+00, 9.7953778808E-01],
	[4.6035000000E+04, 4.3680394617E+01, 5.2243244019E+00, 2.5020095684E+01, 3.9327693331E+00, 9.7954602073E-01],
	[4.6040000000E+04, 4.3688816965E+01, 5.2243705004E+00, 2.5028982315E+01, 3.9330832255E+00, 9.7955424956E-01],
	[4.6045000000E+04, 4.3697240021E+01, 5.2244165943E+00, 2.5037871135E+01, 3.9333970426E+00, 9.7956247458E-01],
	[4.6050000000E+04, 4.3705663787E+01, 5.2244626835E+00, 2.5046762145E+01, 3.9337107844E+00, 9.7957069577E-01],
	[4.6055000000E+04, 4.3714088263E+01, 5.2245087682E+00, 2.5055655345E+01, 3.9340244509E+00, 9.7957891315E-01],
	[4.6060000000E+04, 4.3722513447E+01, 5.2245548483E+00, 2.5064550736E+01, 3.9343380421E+00, 9.7958712672E-01],
	[4.6065000000E+04, 4.3730939340E+01, 5.2246009238E+00, 2.5073448317E+01, 3.9346515580E+00, 9.7959533648E-01],
	[4.6070000000E+04, 4.3739365942E+01, 5.2246469947E+00, 2.5082348090E+01, 3.9349649986E+00, 9.7960354243E-01],
	[4.6075000000E+04, 4.3747793253E+01, 5.2246930610E+00, 2.5091250053E+01, 3.9352783641E+00, 9.7961174457E-01],
	[4.6080000000E+04, 4.3756221273E+01, 5.2247391227E+00, 2.5100154209E+01, 3.9355916543E+00, 9.7961994290E-01],
	[4.6085000000E+04, 4.3764650002E+01, 5.2247851798E+00, 2.5109060556E+01, 3.9359048693E+00, 9.7962813744E-01],
	[4.6090000000E+04, 4.3773079440E+01, 5.2248312324E+00, 2.5117969096E+01, 3.9362180091E+00, 9.7963632817E-01],
	[4.6095000000E+04, 4.3781509587E+01, 5.2248772803E+00, 2.5126879828E+01, 3.9365310738E+00, 9.7964451510E-01],
	[4.6100000000E+04, 4.3789940442E+01, 5.2249233237E+00, 2.5135792753E+01, 3.9368440634E+00, 9.7965269823E-01],
	[4.6105000000E+04, 4.3798372007E+01, 5.2249693624E+00, 2.5144707871E+01, 3.9371569778E+00, 9.7966087757E-01],
	[4.6110000000E+04, 4.3806804280E+01, 5.2250153966E+00, 2.5153625182E+01, 3.9374698171E+00, 9.7966905312E-01],
	[4.6115000000E+04, 4.3815237263E+01, 5.2250614262E+00, 2.5162544688E+01, 3.9377825814E+00, 9.7967722487E-01],
	[4.6120000000E+04, 4.3823670954E+01, 5.2251074512E+00, 2.5171466387E+01, 3.9380952706E+00, 9.7968539284E-01],
	[4.6125000000E+04, 4.3832105354E+01, 5.2251534716E+00, 2.5180390281E+01, 3.9384078848E+00, 9.7969355701E-01],
	[4.6130000000E+04, 4.3840540463E+01, 5.2251994875E+00, 2.5189316369E+01, 3.9387204239E+00, 9.7970171740E-01],
	[4.6135000000E+04, 4.3848976280E+01, 5.2252454987E+00, 2.5198244652E+01, 3.9390328880E+00, 9.7970987401E-01],
	[4.6140000000E+04, 4.3857412806E+01, 5.2252915054E+00, 2.5207175131E+01, 3.9393452772E+00, 9.7971802683E-01],
	[4.6145000000E+04, 4.3865850041E+01, 5.2253375075E+00, 2.5216107805E+01, 3.9396575914E+00, 9.7972617588E-01],
	[4.6150000000E+04, 4.3874287985E+01, 5.2253835050E+00, 2.5225042675E+01, 3.9399698306E+00, 9.7973432114E-01],
	[4.6155000000E+04, 4.3882726638E+01, 5.2254294979E+00, 2.5233979741E+01, 3.9402819950E+00, 9.7974246263E-01],
	[4.6160000000E+04, 4.3891165999E+01, 5.2254754863E+00, 2.5242919003E+01, 3.9405940844E+00, 9.7975060035E-01],
	[4.6165000000E+04, 4.3899606068E+01, 5.2255214701E+00, 2.5251860463E+01, 3.9409060989E+00, 9.7975873429E-01],
	[4.6170000000E+04, 4.3908046847E+01, 5.2255674493E+00, 2.5260804119E+01, 3.9412180386E+00, 9.7976686446E-01],
	[4.6175000000E+04, 4.3916488334E+01, 5.2256134239E+00, 2.5269749973E+01, 3.9415299034E+00, 9.7977499087E-01],
	[4.6180000000E+04, 4.3924930530E+01, 5.2256593940E+00, 2.5278698024E+01, 3.9418416934E+00, 9.7978311350E-01],
	[4.6185000000E+04, 4.3933373434E+01, 5.2257053595E+00, 2.5287648274E+01, 3.9421534086E+00, 9.7979123238E-01],
	[4.6190000000E+04, 4.3941817047E+01, 5.2257513204E+00, 2.5296600721E+01, 3.9424650490E+00, 9.7979934748E-01],
	[4.6195000000E+04, 4.3950261368E+01, 5.2257972767E+00, 2.5305555367E+01, 3.9427766147E+00, 9.7980745883E-01],
	[4.6200000000E+04, 4.3958706398E+01, 5.2258432285E+00, 2.5314512212E+01, 3.9430881056E+00, 9.7981556642E-01],
	[4.6205000000E+04, 4.3967152137E+01, 5.2258891757E+00, 2.5323471257E+01, 3.9433995217E+00, 9.7982367025E-01],
	[4.6210000000E+04, 4.3975598584E+01, 5.2259351184E+00, 2.5332432500E+01, 3.9437108631E+00, 9.7983177033E-01],
	[4.6215000000E+04, 4.3984045739E+01, 5.2259810564E+00, 2.5341395944E+01, 3.9440221299E+00, 9.7983986666E-01],
	[4.6220000000E+04, 4.3992493603E+01, 5.2260269899E+00, 2.5350361587E+01, 3.9443333220E+00, 9.7984795923E-01],
	[4.6225000000E+04, 4.4000942176E+01, 5.2260729189E+00, 2.5359329431E+01, 3.9446444394E+00, 9.7985604805E-01],
	[4.6230000000E+04, 4.4009391457E+01, 5.2261188432E+00, 2.5368299476E+01, 3.9449554822E+00, 9.7986413313E-01],
	[4.6235000000E+04, 4.4017841446E+01, 5.2261647631E+00, 2.5377271722E+01, 3.9452664504E+00, 9.7987221446E-01],
	[4.6240000000E+04, 4.4026292144E+01, 5.2262106783E+00, 2.5386246168E+01, 3.9455773439E+00, 9.7988029204E-01],
	[4.6245000000E+04, 4.4034743550E+01, 5.2262565890E+00, 2.5395222817E+01, 3.9458881629E+00, 9.7988836589E-01],
	[4.6250000000E+04, 4.4043195664E+01, 5.2263024951E+00, 2.5404201667E+01, 3.9461989074E+00, 9.7989643599E-01],
	[4.6255000000E+04, 4.4051648487E+01, 5.2263483967E+00, 2.5413182720E+01, 3.9465095773E+00, 9.7990450236E-01],
	[4.6260000000E+04, 4.4060102019E+01, 5.2263942937E+00, 2.5422165975E+01, 3.9468201727E+00, 9.7991256499E-01],
	[4.6265000000E+04, 4.4068556258E+01, 5.2264401862E+00, 2.5431151432E+01, 3.9471306935E+00, 9.7992062389E-01],
	[4.6270000000E+04, 4.4077011206E+01, 5.2264860741E+00, 2.5440139093E+01, 3.9474411400E+00, 9.7992867905E-01],
	[4.6275000000E+04, 4.4085466862E+01, 5.2265319574E+00, 2.5449128958E+01, 3.9477515119E+00, 9.7993673049E-01],
	[4.6280000000E+04, 4.4093923227E+01, 5.2265778362E+00, 2.5458121026E+01, 3.9480618094E+00, 9.7994477819E-01],
	[4.6285000000E+04, 4.4102380299E+01, 5.2266237104E+00, 2.5467115297E+01, 3.9483720325E+00, 9.7995282217E-01],
	[4.6290000000E+04, 4.4110838080E+01, 5.2266695801E+00, 2.5476111774E+01, 3.9486821812E+00, 9.7996086243E-01],
	[4.6295000000E+04, 4.4119296569E+01, 5.2267154452E+00, 2.5485110455E+01, 3.9489922554E+00, 9.7996889896E-01],
	[4.6300000000E+04, 4.4127755767E+01, 5.2267613058E+00, 2.5494111340E+01, 3.9493022554E+00, 9.7997693177E-01],
	[4.6305000000E+04, 4.4136215672E+01, 5.2268071618E+00, 2.5503114431E+01, 3.9496121809E+00, 9.7998496087E-01],
	[4.6310000000E+04, 4.4144676286E+01, 5.2268530133E+00, 2.5512119728E+01, 3.9499220322E+00, 9.7999298624E-01],
	[4.6315000000E+04, 4.4153137608E+01, 5.2268988602E+00, 2.5521127230E+01, 3.9502318091E+00, 9.8000100790E-01],
	[4.6320000000E+04, 4.4161599638E+01, 5.2269447026E+00, 2.5530136938E+01, 3.9505415118E+00, 9.8000902585E-01],
	[4.6325000000E+04, 4.4170062376E+01, 5.2269905405E+00, 2.5539148853E+01, 3.9508511402E+00, 9.8001704009E-01],
	[4.6330000000E+04, 4.4178525822E+01, 5.2270363738E+00, 2.5548162975E+01, 3.9511606943E+00, 9.8002505061E-01],
	[4.6335000000E+04, 4.4186989976E+01, 5.2270822025E+00, 2.5557179303E+01, 3.9514701742E+00, 9.8003305743E-01],
	[4.6340000000E+04, 4.4195454839E+01, 5.2271280267E+00, 2.5566197839E+01, 3.9517795799E+00, 9.8004106055E-01],
	[4.6345000000E+04, 4.4203920409E+01, 5.2271738464E+00, 2.5575218582E+01, 3.9520889114E+00, 9.8004905996E-01],
	[4.6350000000E+04, 4.4212386688E+01, 5.2272196615E+00, 2.5584241534E+01, 3.9523981688E+00, 9.8005705567E-01],
	[4.6355000000E+04, 4.4220853674E+01, 5.2272654721E+00, 2.5593266693E+01, 3.9527073520E+00, 9.8006504767E-01],
	[4.6360000000E+04, 4.4229321369E+01, 5.2273112781E+00, 2.5602294061E+01, 3.9530164610E+00, 9.8007303599E-01],
	[4.6365000000E+04, 4.4237789771E+01, 5.2273570796E+00, 2.5611323638E+01, 3.9533254959E+00, 9.8008102060E-01],
	[4.6370000000E+04, 4.4246258882E+01, 5.2274028766E+00, 2.5620355424E+01, 3.9536344568E+00, 9.8008900152E-01],
	[4.6375000000E+04, 4.4254728700E+01, 5.2274486690E+00, 2.5629389419E+01, 3.9539433435E+00, 9.8009697875E-01],
	[4.6380000000E+04, 4.4263199226E+01, 5.2274944569E+00, 2.5638425625E+01, 3.9542521562E+00, 9.8010495229E-01],
	[4.6385000000E+04, 4.4271670460E+01, 5.2275402402E+00, 2.5647464040E+01, 3.9545608949E+00, 9.8011292214E-01],
	[4.6390000000E+04, 4.4280142402E+01, 5.2275860191E+00, 2.5656504665E+01, 3.9548695595E+00, 9.8012088830E-01],
	[4.6395000000E+04, 4.4288615052E+01, 5.2276317934E+00, 2.5665547501E+01, 3.9551781501E+00, 9.8012885078E-01],
	[4.6400000000E+04, 4.4297088410E+01, 5.2276775631E+00, 2.5674592548E+01, 3.9554866668E+00, 9.8013680958E-01],
	[4.6405000000E+04, 4.4305562476E+01, 5.2277233283E+00, 2.5683639807E+01, 3.9557951095E+00, 9.8014476469E-01],
	[4.6410000000E+04, 4.4314037249E+01, 5.2277690890E+00, 2.5692689277E+01, 3.9561034783E+00, 9.8015271613E-01],
	[4.6415000000E+04, 4.4322512731E+01, 5.2278148452E+00, 2.5701740958E+01, 3.9564117731E+00, 9.8016066389E-01],
	[4.6420000000E+04, 4.4330988920E+01, 5.2278605968E+00, 2.5710794852E+01, 3.9567199940E+00, 9.8016860797E-01],
	[4.6425000000E+04, 4.4339465817E+01, 5.2279063440E+00, 2.5719850958E+01, 3.9570281411E+00, 9.8017654838E-01],
	[4.6430000000E+04, 4.4347943421E+01, 5.2279520865E+00, 2.5728909277E+01, 3.9573362142E+00, 9.8018448512E-01],
	[4.6435000000E+04, 4.4356421734E+01, 5.2279978246E+00, 2.5737969809E+01, 3.9576442136E+00, 9.8019241819E-01],
	[4.6440000000E+04, 4.4364900754E+01, 5.2280435581E+00, 2.5747032555E+01, 3.9579521391E+00, 9.8020034759E-01],
	[4.6445000000E+04, 4.4373380482E+01, 5.2280892871E+00, 2.5756097514E+01, 3.9582599907E+00, 9.8020827333E-01],
	[4.6450000000E+04, 4.4381860917E+01, 5.2281350116E+00, 2.5765164687E+01, 3.9585677686E+00, 9.8021619540E-01],
	[4.6455000000E+04, 4.4390342060E+01, 5.2281807316E+00, 2.5774234074E+01, 3.9588754728E+00, 9.8022411381E-01],
	[4.6460000000E+04, 4.4398823911E+01, 5.2282264470E+00, 2.5783305676E+01, 3.9591831032E+00, 9.8023202856E-01],
	[4.6465000000E+04, 4.4407306470E+01, 5.2282721580E+00, 2.5792379492E+01, 3.9594906598E+00, 9.8023993965E-01],
	[4.6470000000E+04, 4.4415789736E+01, 5.2283178644E+00, 2.5801455524E+01, 3.9597981427E+00, 9.8024784709E-01],
	[4.6475000000E+04, 4.4424273710E+01, 5.2283635663E+00, 2.5810533772E+01, 3.9601055520E+00, 9.8025575087E-01],
	[4.6480000000E+04, 4.4432758391E+01, 5.2284092636E+00, 2.5819614235E+01, 3.9604128876E+00, 9.8026365100E-01],
	[4.6485000000E+04, 4.4441243780E+01, 5.2284549565E+00, 2.5828696914E+01, 3.9607201495E+00, 9.8027154748E-01],
	[4.6490000000E+04, 4.4449729876E+01, 5.2285006448E+00, 2.5837781809E+01, 3.9610273378E+00, 9.8027944031E-01],
	[4.6495000000E+04, 4.4458216680E+01, 5.2285463287E+00, 2.5846868921E+01, 3.9613344524E+00, 9.8028732949E-01],
	[4.6500000000E+04, 4.4466704192E+01, 5.2285920080E+00, 2.5855958250E+01, 3.9616414935E+00, 9.8029521503E-01],
	[4.6505000000E+04, 4.4475192410E+01, 5.2286376828E+00, 2.5865049797E+01, 3.9619484610E+00, 9.8030309692E-01],
	[4.6510000000E+04, 4.4483681337E+01, 5.2286833531E+00, 2.5874143561E+01, 3.9622553549E+00, 9.8031097517E-01],
	[4.6515000000E+04, 4.4492170971E+01, 5.2287290188E+00, 2.5883239542E+01, 3.9625621753E+00, 9.8031884979E-01],
	[4.6520000000E+04, 4.4500661312E+01, 5.2287746801E+00, 2.5892337742E+01, 3.9628689221E+00, 9.8032672076E-01],
	[4.6525000000E+04, 4.4509152361E+01, 5.2288203369E+00, 2.5901438161E+01, 3.9631755955E+00, 9.8033458810E-01],
	[4.6530000000E+04, 4.4517644117E+01, 5.2288659891E+00, 2.5910540798E+01, 3.9634821954E+00, 9.8034245181E-01],
	[4.6535000000E+04, 4.4526136581E+01, 5.2289116368E+00, 2.5919645655E+01, 3.9637887218E+00, 9.8035031189E-01],
	[4.6540000000E+04, 4.4534629752E+01, 5.2289572801E+00, 2.5928752730E+01, 3.9640951747E+00, 9.8035816833E-01],
	[4.6545000000E+04, 4.4543123630E+01, 5.2290029188E+00, 2.5937862026E+01, 3.9644015543E+00, 9.8036602115E-01],
	[4.6550000000E+04, 4.4551618216E+01, 5.2290485530E+00, 2.5946973541E+01, 3.9647078604E+00, 9.8037387034E-01],
	[4.6555000000E+04, 4.4560113509E+01, 5.2290941828E+00, 2.5956087277E+01, 3.9650140932E+00, 9.8038171591E-01],
	[4.6560000000E+04, 4.4568609509E+01, 5.2291398080E+00, 2.5965203233E+01, 3.9653202525E+00, 9.8038955785E-01],
	[4.6565000000E+04, 4.4577106217E+01, 5.2291854287E+00, 2.5974321410E+01, 3.9656263386E+00, 9.8039739617E-01],
	[4.6570000000E+04, 4.4585603632E+01, 5.2292310449E+00, 2.5983441809E+01, 3.9659323513E+00, 9.8040523088E-01],
	[4.6575000000E+04, 4.4594101754E+01, 5.2292766567E+00, 2.5992564428E+01, 3.9662382907E+00, 9.8041306197E-01],
	[4.6580000000E+04, 4.4602600584E+01, 5.2293222639E+00, 2.6001689270E+01, 3.9665441568E+00, 9.8042088944E-01],
	[4.6585000000E+04, 4.4611100120E+01, 5.2293678666E+00, 2.6010816334E+01, 3.9668499496E+00, 9.8042871330E-01],
	[4.6590000000E+04, 4.4619600364E+01, 5.2294134648E+00, 2.6019945620E+01, 3.9671556691E+00, 9.8043653355E-01],
	[4.6595000000E+04, 4.4628101315E+01, 5.2294590586E+00, 2.6029077129E+01, 3.9674613155E+00, 9.8044435019E-01],
	[4.6600000000E+04, 4.4636602973E+01, 5.2295046478E+00, 2.6038210861E+01, 3.9677668886E+00, 9.8045216322E-01],
	[4.6605000000E+04, 4.4645105339E+01, 5.2295502326E+00, 2.6047346816E+01, 3.9680723885E+00, 9.8045997265E-01],
	[4.6610000000E+04, 4.4653608411E+01, 5.2295958128E+00, 2.6056484995E+01, 3.9683778153E+00, 9.8046777847E-01],
	[4.6615000000E+04, 4.4662112191E+01, 5.2296413886E+00, 2.6065625398E+01, 3.9686831688E+00, 9.8047558069E-01],
	[4.6620000000E+04, 4.4670616678E+01, 5.2296869598E+00, 2.6074768025E+01, 3.9689884493E+00, 9.8048337931E-01],
	[4.6625000000E+04, 4.4679121872E+01, 5.2297325266E+00, 2.6083912876E+01, 3.9692936566E+00, 9.8049117433E-01],
	[4.6630000000E+04, 4.4687627773E+01, 5.2297780889E+00, 2.6093059952E+01, 3.9695987908E+00, 9.8049896576E-01],
	[4.6635000000E+04, 4.4696134381E+01, 5.2298236467E+00, 2.6102209254E+01, 3.9699038520E+00, 9.8050675359E-01],
	[4.6640000000E+04, 4.4704641696E+01, 5.2298692000E+00, 2.6111360781E+01, 3.9702088401E+00, 9.8051453783E-01],
	[4.6645000000E+04, 4.4713149718E+01, 5.2299147488E+00, 2.6120514533E+01, 3.9705137551E+00, 9.8052231848E-01],
	[4.6650000000E+04, 4.4721658447E+01, 5.2299602932E+00, 2.6129670512E+01, 3.9708185971E+00, 9.8053009553E-01],
	[4.6655000000E+04, 4.4730167883E+01, 5.2300058330E+00, 2.6138828717E+01, 3.9711233661E+00, 9.8053786901E-01],
	[4.6660000000E+04, 4.4738678026E+01, 5.2300513684E+00, 2.6147989148E+01, 3.9714280621E+00, 9.8054563889E-01],
	[4.6665000000E+04, 4.4747188876E+01, 5.2300968993E+00, 2.6157151807E+01, 3.9717326852E+00, 9.8055340520E-01],
	[4.6670000000E+04, 4.4755700433E+01, 5.2301424257E+00, 2.6166316693E+01, 3.9720372353E+00, 9.8056116792E-01],
	[4.6675000000E+04, 4.4764212697E+01, 5.2301879476E+00, 2.6175483806E+01, 3.9723417124E+00, 9.8056892706E-01],
	[4.6680000000E+04, 4.4772725668E+01, 5.2302334651E+00, 2.6184653147E+01, 3.9726461167E+00, 9.8057668263E-01],
	[4.6685000000E+04, 4.4781239345E+01, 5.2302789781E+00, 2.6193824716E+01, 3.9729504481E+00, 9.8058443462E-01],
	[4.6690000000E+04, 4.4789753730E+01, 5.2303244865E+00, 2.6202998514E+01, 3.9732547066E+00, 9.8059218303E-01],
	[4.6695000000E+04, 4.4798268821E+01, 5.2303699906E+00, 2.6212174540E+01, 3.9735588922E+00, 9.8059992788E-01],
	[4.6700000000E+04, 4.4806784619E+01, 5.2304154901E+00, 2.6221352796E+01, 3.9738630050E+00, 9.8060766915E-01],
	[4.6705000000E+04, 4.4815301124E+01, 5.2304609852E+00, 2.6230533281E+01, 3.9741670450E+00, 9.8061540685E-01],
	[4.6710000000E+04, 4.4823818336E+01, 5.2305064757E+00, 2.6239715995E+01, 3.9744710122E+00, 9.8062314099E-01],
	[4.6715000000E+04, 4.4832336255E+01, 5.2305519619E+00, 2.6248900940E+01, 3.9747749066E+00, 9.8063087157E-01],
	[4.6720000000E+04, 4.4840854880E+01, 5.2305974435E+00, 2.6258088115E+01, 3.9750787283E+00, 9.8063859858E-01],
	[4.6725000000E+04, 4.4849374212E+01, 5.2306429207E+00, 2.6267277520E+01, 3.9753824772E+00, 9.8064632203E-01],
	[4.6730000000E+04, 4.4857894251E+01, 5.2306883934E+00, 2.6276469156E+01, 3.9756861534E+00, 9.8065404192E-01],
	[4.6735000000E+04, 4.4866414997E+01, 5.2307338616E+00, 2.6285663024E+01, 3.9759897569E+00, 9.8066175825E-01],
	[4.6740000000E+04, 4.4874936449E+01, 5.2307793253E+00, 2.6294859123E+01, 3.9762932877E+00, 9.8066947103E-01],
	[4.6745000000E+04, 4.4883458608E+01, 5.2308247846E+00, 2.6304057453E+01, 3.9765967458E+00, 9.8067718025E-01],
	[4.6750000000E+04, 4.4891981474E+01, 5.2308702395E+00, 2.6313258016E+01, 3.9769001313E+00, 9.8068488592E-01],
	[4.6755000000E+04, 4.4900505046E+01, 5.2309156898E+00, 2.6322460811E+01, 3.9772034442E+00, 9.8069258804E-01],
	[4.6760000000E+04, 4.4909029325E+01, 5.2309611357E+00, 2.6331665839E+01, 3.9775066845E+00, 9.8070028662E-01],
	[4.6765000000E+04, 4.4917554311E+01, 5.2310065771E+00, 2.6340873099E+01, 3.9778098522E+00, 9.8070798165E-01],
	[4.6770000000E+04, 4.4926080003E+01, 5.2310520141E+00, 2.6350082593E+01, 3.9781129473E+00, 9.8071567313E-01],
	[4.6775000000E+04, 4.4934615731E+01, 5.2310984405E+00, 2.6359294321E+01, 3.9784166179E+00, 9.8072336107E-01],
	[4.6780000000E+04, 4.4943159239E+01, 5.2311456157E+00, 2.6368508283E+01, 3.9787207072E+00, 9.8073104547E-01],
	[4.6785000000E+04, 4.4951703458E+01, 5.2311927862E+00, 2.6377724478E+01, 3.9790247242E+00, 9.8073872633E-01],
	[4.6790000000E+04, 4.4960248388E+01, 5.2312399521E+00, 2.6386942908E+01, 3.9793286688E+00, 9.8074640366E-01],
	[4.6795000000E+04, 4.4968794029E+01, 5.2312871134E+00, 2.6396163573E+01, 3.9796325412E+00, 9.8075407745E-01],
	[4.6800000000E+04, 4.4977340381E+01, 5.2313342701E+00, 2.6405386474E+01, 3.9799363412E+00, 9.8076174770E-01],
	[4.6805000000E+04, 4.4985887444E+01, 5.2313814222E+00, 2.6414611609E+01, 3.9802400689E+00, 9.8076941443E-01],
	[4.6810000000E+04, 4.4994435218E+01, 5.2314285696E+00, 2.6423838980E+01, 3.9805437244E+00, 9.8077707762E-01],
	[4.6815000000E+04, 4.5002983703E+01, 5.2314757125E+00, 2.6433068587E+01, 3.9808473077E+00, 9.8078473729E-01],
	[4.6820000000E+04, 4.5011532899E+01, 5.2315228507E+00, 2.6442300431E+01, 3.9811508187E+00, 9.8079239343E-01],
	[4.6825000000E+04, 4.5020082806E+01, 5.2315699844E+00, 2.6451534511E+01, 3.9814542575E+00, 9.8080004605E-01],
	[4.6830000000E+04, 4.5028633423E+01, 5.2316171134E+00, 2.6460770828E+01, 3.9817576242E+00, 9.8080769515E-01],
	[4.6835000000E+04, 4.5037184752E+01, 5.2316642378E+00, 2.6470009382E+01, 3.9820609187E+00, 9.8081534072E-01],
	[4.6840000000E+04, 4.5045736791E+01, 5.2317113576E+00, 2.6479250174E+01, 3.9823641410E+00, 9.8082298278E-01],
	[4.6845000000E+04, 4.5054289541E+01, 5.2317584728E+00, 2.6488493204E+01, 3.9826672912E+00, 9.8083062132E-01],
	[4.6850000000E+04, 4.5062843002E+01, 5.2318055834E+00, 2.6497738472E+01, 3.9829703693E+00, 9.8083825634E-01],
	[4.6855000000E+04, 4.5071397174E+01, 5.2318526894E+00, 2.6506985978E+01, 3.9832733754E+00, 9.8084588785E-01],
	[4.6860000000E+04, 4.5079952056E+01, 5.2318997908E+00, 2.6516235723E+01, 3.9835763093E+00, 9.8085351585E-01],
	[4.6865000000E+04, 4.5088507649E+01, 5.2319468876E+00, 2.6525487706E+01, 3.9838791712E+00, 9.8086114034E-01],
	[4.6870000000E+04, 4.5097063953E+01, 5.2319939798E+00, 2.6534741930E+01, 3.9841819611E+00, 9.8086876133E-01],
	[4.6875000000E+04, 4.5105620968E+01, 5.2320410674E+00, 2.6543998393E+01, 3.9844846789E+00, 9.8087637880E-01],
	[4.6880000000E+04, 4.5114178693E+01, 5.2320881504E+00, 2.6553257095E+01, 3.9847873248E+00, 9.8088399278E-01],
	[4.6885000000E+04, 4.5122737129E+01, 5.2321352288E+00, 2.6562518039E+01, 3.9850898987E+00, 9.8089160325E-01],
	[4.6890000000E+04, 4.5131296276E+01, 5.2321823025E+00, 2.6571781222E+01, 3.9853924006E+00, 9.8089921022E-01],
	[4.6895000000E+04, 4.5139856134E+01, 5.2322293717E+00, 2.6581046647E+01, 3.9856948306E+00, 9.8090681369E-01],
	[4.6900000000E+04, 4.5148416702E+01, 5.2322764364E+00, 2.6590314312E+01, 3.9859971886E+00, 9.8091441367E-01],
	[4.6905000000E+04, 4.5156977980E+01, 5.2323234964E+00, 2.6599584219E+01, 3.9862994748E+00, 9.8092201015E-01],
	[4.6910000000E+04, 4.5165539970E+01, 5.2323705518E+00, 2.6608856368E+01, 3.9866016891E+00, 9.8092960314E-01],
	[4.6915000000E+04, 4.5174102669E+01, 5.2324176026E+00, 2.6618130759E+01, 3.9869038315E+00, 9.8093719263E-01],
	[4.6920000000E+04, 4.5182666080E+01, 5.2324646489E+00, 2.6627407392E+01, 3.9872059021E+00, 9.8094477864E-01],
	[4.6925000000E+04, 4.5191230201E+01, 5.2325116905E+00, 2.6636686268E+01, 3.9875079009E+00, 9.8095236116E-01],
	[4.6930000000E+04, 4.5199795032E+01, 5.2325587276E+00, 2.6645967387E+01, 3.9878098278E+00, 9.8095994020E-01],
	[4.6935000000E+04, 4.5208360574E+01, 5.2326057600E+00, 2.6655250749E+01, 3.9881116830E+00, 9.8096751575E-01],
	[4.6940000000E+04, 4.5216926827E+01, 5.2326527879E+00, 2.6664536355E+01, 3.9884134664E+00, 9.8097508782E-01],
	[4.6945000000E+04, 4.5225493790E+01, 5.2326998112E+00, 2.6673824205E+01, 3.9887151780E+00, 9.8098265641E-01],
	[4.6950000000E+04, 4.5234061463E+01, 5.2327468299E+00, 2.6683114298E+01, 3.9890168179E+00, 9.8099022152E-01],
	[4.6955000000E+04, 4.5242629847E+01, 5.2327938440E+00, 2.6692406637E+01, 3.9893183861E+00, 9.8099778315E-01],
	[4.6960000000E+04, 4.5251198942E+01, 5.2328408536E+00, 2.6701701220E+01, 3.9896198826E+00, 9.8100534131E-01],
	[4.6965000000E+04, 4.5259768747E+01, 5.2328878585E+00, 2.6710998048E+01, 3.9899213075E+00, 9.8101289600E-01],
	[4.6970000000E+04, 4.5268339262E+01, 5.2329348589E+00, 2.6720297121E+01, 3.9902226606E+00, 9.8102044721E-01],
	[4.6975000000E+04, 4.5276910487E+01, 5.2329818547E+00, 2.6729598441E+01, 3.9905239422E+00, 9.8102799496E-01],
	[4.6980000000E+04, 4.5285482423E+01, 5.2330288459E+00, 2.6738902006E+01, 3.9908251521E+00, 9.8103553924E-01],
	[4.6985000000E+04, 4.5294055070E+01, 5.2330758326E+00, 2.6748207817E+01, 3.9911262904E+00, 9.8104308005E-01],
	[4.6990000000E+04, 4.5302628426E+01, 5.2331228146E+00, 2.6757515875E+01, 3.9914273571E+00, 9.8105061740E-01],
	[4.6995000000E+04, 4.5311202493E+01, 5.2331697921E+00, 2.6766826180E+01, 3.9917283523E+00, 9.8105815128E-01],
	[4.7000000000E+04, 4.5319777271E+01, 5.2332167650E+00, 2.6776138733E+01, 3.9920292760E+00, 9.8106568171E-01],
	[4.7005000000E+04, 4.5328352758E+01, 5.2332637333E+00, 2.6785453532E+01, 3.9923301281E+00, 9.8107320868E-01],
	[4.7010000000E+04, 4.5336928956E+01, 5.2333106971E+00, 2.6794770580E+01, 3.9926309087E+00, 9.8108073219E-01],
	[4.7015000000E+04, 4.5345505864E+01, 5.2333576563E+00, 2.6804089875E+01, 3.9929316178E+00, 9.8108825225E-01],
	[4.7020000000E+04, 4.5354083482E+01, 5.2334046109E+00, 2.6813411419E+01, 3.9932322554E+00, 9.8109576885E-01],
	[4.7025000000E+04, 4.5362661811E+01, 5.2334515609E+00, 2.6822735212E+01, 3.9935328216E+00, 9.8110328201E-01],
	[4.7030000000E+04, 4.5371240850E+01, 5.2334985064E+00, 2.6832061254E+01, 3.9938333164E+00, 9.8111079171E-01],
	[4.7035000000E+04, 4.5379820599E+01, 5.2335454473E+00, 2.6841389545E+01, 3.9941337397E+00, 9.8111829797E-01],
	[4.7040000000E+04, 4.5388401058E+01, 5.2335923836E+00, 2.6850720086E+01, 3.9944340917E+00, 9.8112580078E-01],
	[4.7045000000E+04, 4.5396982227E+01, 5.2336393154E+00, 2.6860052876E+01, 3.9947343723E+00, 9.8113330014E-01],
	[4.7050000000E+04, 4.5405564106E+01, 5.2336862426E+00, 2.6869387917E+01, 3.9950345815E+00, 9.8114079607E-01],
	[4.7055000000E+04, 4.5414146696E+01, 5.2337331652E+00, 2.6878725209E+01, 3.9953347194E+00, 9.8114828855E-01],
	[4.7060000000E+04, 4.5422729996E+01, 5.2337800832E+00, 2.6888064751E+01, 3.9956347860E+00, 9.8115577760E-01],
	[4.7065000000E+04, 4.5431314005E+01, 5.2338269967E+00, 2.6897406545E+01, 3.9959347813E+00, 9.8116326321E-01],
	[4.7070000000E+04, 4.5439898725E+01, 5.2338739057E+00, 2.6906750589E+01, 3.9962347053E+00, 9.8117074538E-01],
	[4.7075000000E+04, 4.5448484155E+01, 5.2339208100E+00, 2.6916096886E+01, 3.9965345580E+00, 9.8117822413E-01],
	[4.7080000000E+04, 4.5457070295E+01, 5.2339677099E+00, 2.6925445435E+01, 3.9968343395E+00, 9.8118569944E-01],
	[4.7085000000E+04, 4.5465657145E+01, 5.2340146051E+00, 2.6934796236E+01, 3.9971340497E+00, 9.8119317132E-01],
	[4.7090000000E+04, 4.5474244704E+01, 5.2340614958E+00, 2.6944149289E+01, 3.9974336888E+00, 9.8120063977E-01],
	[4.7095000000E+04, 4.5482832974E+01, 5.2341083819E+00, 2.6953504596E+01, 3.9977332567E+00, 9.8120810480E-01],
	[4.7100000000E+04, 4.5491421954E+01, 5.2341552635E+00, 2.6962862156E+01, 3.9980327534E+00, 9.8121556640E-01],
	[4.7105000000E+04, 4.5500011644E+01, 5.2342021405E+00, 2.6972221969E+01, 3.9983321789E+00, 9.8122302458E-01],
	[4.7110000000E+04, 4.5508602044E+01, 5.2342490130E+00, 2.6981584037E+01, 3.9986315333E+00, 9.8123047934E-01],
	[4.7115000000E+04, 4.5517193153E+01, 5.2342958809E+00, 2.6990948358E+01, 3.9989308166E+00, 9.8123793068E-01],
	[4.7120000000E+04, 4.5525784973E+01, 5.2343427443E+00, 2.7000314934E+01, 3.9992300289E+00, 9.8124537861E-01],
	[4.7125000000E+04, 4.5534377502E+01, 5.2343896031E+00, 2.7009683765E+01, 3.9995291700E+00, 9.8125282312E-01],
	[4.7130000000E+04, 4.5542970742E+01, 5.2344364573E+00, 2.7019054851E+01, 3.9998282401E+00, 9.8126026422E-01],
	[4.7135000000E+04, 4.5551564691E+01, 5.2344833070E+00, 2.7028428192E+01, 4.0001272391E+00, 9.8126770190E-01],
	[4.7140000000E+04, 4.5560159350E+01, 5.2345301522E+00, 2.7037803789E+01, 4.0004261671E+00, 9.8127513618E-01],
	[4.7145000000E+04, 4.5568754718E+01, 5.2345769928E+00, 2.7047181642E+01, 4.0007250242E+00, 9.8128256704E-01],
	[4.7150000000E+04, 4.5577350797E+01, 5.2346238288E+00, 2.7056561751E+01, 4.0010238102E+00, 9.8128999451E-01],
	[4.7155000000E+04, 4.5585947585E+01, 5.2346706603E+00, 2.7065944117E+01, 4.0013225253E+00, 9.8129741856E-01],
	[4.7160000000E+04, 4.5594545084E+01, 5.2347174873E+00, 2.7075328739E+01, 4.0016211694E+00, 9.8130483922E-01],
	[4.7165000000E+04, 4.5603143292E+01, 5.2347643097E+00, 2.7084715619E+01, 4.0019197426E+00, 9.8131225647E-01],
	[4.7170000000E+04, 4.5611742209E+01, 5.2348111275E+00, 2.7094104756E+01, 4.0022182449E+00, 9.8131967033E-01],
	[4.7175000000E+04, 4.5620341837E+01, 5.2348579409E+00, 2.7103496152E+01, 4.0025166763E+00, 9.8132708079E-01],
	[4.7180000000E+04, 4.5628942174E+01, 5.2349047496E+00, 2.7112889805E+01, 4.0028150369E+00, 9.8133448785E-01],
	[4.7185000000E+04, 4.5637543220E+01, 5.2349515539E+00, 2.7122285717E+01, 4.0031133266E+00, 9.8134189152E-01],
	[4.7190000000E+04, 4.5646144977E+01, 5.2349983536E+00, 2.7131683887E+01, 4.0034115454E+00, 9.8134929180E-01],
	[4.7195000000E+04, 4.5654747443E+01, 5.2350451487E+00, 2.7141084317E+01, 4.0037096935E+00, 9.8135668868E-01],
	[4.7200000000E+04, 4.5663350619E+01, 5.2350919393E+00, 2.7150487005E+01, 4.0040077707E+00, 9.8136408218E-01],
	[4.7205000000E+04, 4.5671954504E+01, 5.2351387254E+00, 2.7159891954E+01, 4.0043057772E+00, 9.8137147230E-01],
	[4.7210000000E+04, 4.5680559099E+01, 5.2351855070E+00, 2.7169299162E+01, 4.0046037129E+00, 9.8137885903E-01],
	[4.7215000000E+04, 4.5689164403E+01, 5.2352322840E+00, 2.7178708631E+01, 4.0049015779E+00, 9.8138624237E-01],
	[4.7220000000E+04, 4.5697770417E+01, 5.2352790564E+00, 2.7188120360E+01, 4.0051993721E+00, 9.8139362234E-01],
	[4.7225000000E+04, 4.5706377141E+01, 5.2353258244E+00, 2.7197534350E+01, 4.0054970957E+00, 9.8140099892E-01],
	[4.7230000000E+04, 4.5714984574E+01, 5.2353725878E+00, 2.7206950601E+01, 4.0057947486E+00, 9.8140837213E-01],
	[4.7235000000E+04, 4.5723592717E+01, 5.2354193466E+00, 2.7216369113E+01, 4.0060923308E+00, 9.8141574196E-01],
	[4.7240000000E+04, 4.5732201569E+01, 5.2354661010E+00, 2.7225789887E+01, 4.0063898423E+00, 9.8142310842E-01],
	[4.7245000000E+04, 4.5740811131E+01, 5.2355128508E+00, 2.7235212924E+01, 4.0066872833E+00, 9.8143047151E-01],
	[4.7250000000E+04, 4.5749421402E+01, 5.2355595961E+00, 2.7244638222E+01, 4.0069846536E+00, 9.8143783122E-01],
	[4.7255000000E+04, 4.5758032383E+01, 5.2356063368E+00, 2.7254065784E+01, 4.0072819533E+00, 9.8144518757E-01],
	[4.7260000000E+04, 4.5766644073E+01, 5.2356530730E+00, 2.7263495608E+01, 4.0075791825E+00, 9.8145254055E-01],
	[4.7265000000E+04, 4.5775256472E+01, 5.2356998047E+00, 2.7272927695E+01, 4.0078763411E+00, 9.8145989016E-01],
	[4.7270000000E+04, 4.5783869581E+01, 5.2357465319E+00, 2.7282362047E+01, 4.0081734291E+00, 9.8146723642E-01],
	[4.7275000000E+04, 4.5792483399E+01, 5.2357932545E+00, 2.7291798662E+01, 4.0084704467E+00, 9.8147457931E-01],
	[4.7280000000E+04, 4.5801097927E+01, 5.2358399726E+00, 2.7301237541E+01, 4.0087673938E+00, 9.8148191884E-01],
	[4.7285000000E+04, 4.5809713164E+01, 5.2358866862E+00, 2.7310678684E+01, 4.0090642703E+00, 9.8148925501E-01],
	[4.7290000000E+04, 4.5818329110E+01, 5.2359333953E+00, 2.7320122093E+01, 4.0093610765E+00, 9.8149658783E-01],
	[4.7295000000E+04, 4.5826945766E+01, 5.2359800999E+00, 2.7329567766E+01, 4.0096578121E+00, 9.8150391729E-01],
	[4.7300000000E+04, 4.5835563131E+01, 5.2360267999E+00, 2.7339015705E+01, 4.0099544774E+00, 9.8151124340E-01],
	[4.7305000000E+04, 4.5844181205E+01, 5.2360734954E+00, 2.7348465910E+01, 4.0102510723E+00, 9.8151856616E-01],
	[4.7310000000E+04, 4.5852799988E+01, 5.2361201864E+00, 2.7357918380E+01, 4.0105475967E+00, 9.8152588557E-01],
	[4.7315000000E+04, 4.5861419481E+01, 5.2361668729E+00, 2.7367373117E+01, 4.0108440508E+00, 9.8153320163E-01],
	[4.7320000000E+04, 4.5870039683E+01, 5.2362135548E+00, 2.7376830121E+01, 4.0111404346E+00, 9.8154051435E-01],
	[4.7325000000E+04, 4.5878660594E+01, 5.2362602322E+00, 2.7386289391E+01, 4.0114367480E+00, 9.8154782372E-01],
	[4.7330000000E+04, 4.5887282215E+01, 5.2363069052E+00, 2.7395750929E+01, 4.0117329911E+00, 9.8155512975E-01],
	[4.7335000000E+04, 4.5895904544E+01, 5.2363535736E+00, 2.7405214734E+01, 4.0120291639E+00, 9.8156243244E-01],
	[4.7340000000E+04, 4.5904527583E+01, 5.2364002375E+00, 2.7414680806E+01, 4.0123252665E+00, 9.8156973180E-01],
	[4.7345000000E+04, 4.5913151331E+01, 5.2364468968E+00, 2.7424149147E+01, 4.0126212988E+00, 9.8157702781E-01],
	[4.7350000000E+04, 4.5921775788E+01, 5.2364935517E+00, 2.7433619757E+01, 4.0129172608E+00, 9.8158432049E-01],
	[4.7355000000E+04, 4.5930400954E+01, 5.2365402021E+00, 2.7443092635E+01, 4.0132131526E+00, 9.8159160984E-01],
	[4.7360000000E+04, 4.5939026829E+01, 5.2365868479E+00, 2.7452567782E+01, 4.0135089743E+00, 9.8159889586E-01],
	[4.7365000000E+04, 4.5947653414E+01, 5.2366334893E+00, 2.7462045199E+01, 4.0138047257E+00, 9.8160617854E-01],
	[4.7370000000E+04, 4.5956280707E+01, 5.2366801261E+00, 2.7471524885E+01, 4.0141004070E+00, 9.8161345790E-01],
	[4.7375000000E+04, 4.5964908709E+01, 5.2367267584E+00, 2.7481006841E+01, 4.0143960182E+00, 9.8162073394E-01],
	[4.7380000000E+04, 4.5973537421E+01, 5.2367733862E+00, 2.7490491067E+01, 4.0146915592E+00, 9.8162800664E-01],
	[4.7385000000E+04, 4.5982166842E+01, 5.2368200096E+00, 2.7499977564E+01, 4.0149870301E+00, 9.8163527603E-01],
	[4.7390000000E+04, 4.5990796971E+01, 5.2368666284E+00, 2.7509466332E+01, 4.0152824309E+00, 9.8164254209E-01],
	[4.7395000000E+04, 4.5999427810E+01, 5.2369132427E+00, 2.7518957371E+01, 4.0155777617E+00, 9.8164980484E-01],
	[4.7400000000E+04, 4.6008059357E+01, 5.2369598525E+00, 2.7528450681E+01, 4.0158730224E+00, 9.8165706427E-01],
	[4.7405000000E+04, 4.6016691614E+01, 5.2370064578E+00, 2.7537946263E+01, 4.0161682130E+00, 9.8166432038E-01],
	[4.7410000000E+04, 4.6025324579E+01, 5.2370530586E+00, 2.7547444117E+01, 4.0164633337E+00, 9.8167157318E-01],
	[4.7415000000E+04, 4.6033958253E+01, 5.2370996549E+00, 2.7556944244E+01, 4.0167583843E+00, 9.8167882267E-01],
	[4.7420000000E+04, 4.6042592636E+01, 5.2371462467E+00, 2.7566446643E+01, 4.0170533650E+00, 9.8168606884E-01],
	[4.7425000000E+04, 4.6051227729E+01, 5.2371928340E+00, 2.7575951315E+01, 4.0173482757E+00, 9.8169331171E-01],
	[4.7430000000E+04, 4.6059863530E+01, 5.2372394168E+00, 2.7585458261E+01, 4.0176431165E+00, 9.8170055127E-01],
	[4.7435000000E+04, 4.6068500039E+01, 5.2372859951E+00, 2.7594967479E+01, 4.0179378874E+00, 9.8170778753E-01],
	[4.7440000000E+04, 4.6077137258E+01, 5.2373325689E+00, 2.7604478972E+01, 4.0182325883E+00, 9.8171502048E-01],
	[4.7445000000E+04, 4.6085775186E+01, 5.2373791382E+00, 2.7613992739E+01, 4.0185272194E+00, 9.8172225013E-01],
	[4.7450000000E+04, 4.6094413822E+01, 5.2374257031E+00, 2.7623508781E+01, 4.0188217806E+00, 9.8172947648E-01],
	[4.7455000000E+04, 4.6103053167E+01, 5.2374722634E+00, 2.7633027097E+01, 4.0191162720E+00, 9.8173669954E-01],
	[4.7460000000E+04, 4.6111693221E+01, 5.2375188193E+00, 2.7642547689E+01, 4.0194106935E+00, 9.8174391930E-01],
	[4.7465000000E+04, 4.6120333983E+01, 5.2375653706E+00, 2.7652070556E+01, 4.0197050452E+00, 9.8175113576E-01],
	[4.7470000000E+04, 4.6128975455E+01, 5.2376119175E+00, 2.7661595698E+01, 4.0199993271E+00, 9.8175834893E-01],
	[4.7475000000E+04, 4.6137617635E+01, 5.2376584598E+00, 2.7671123117E+01, 4.0202935393E+00, 9.8176555881E-01],
	[4.7480000000E+04, 4.6146260524E+01, 5.2377049977E+00, 2.7680652812E+01, 4.0205876817E+00, 9.8177276540E-01],
	[4.7485000000E+04, 4.6154904121E+01, 5.2377515311E+00, 2.7690184783E+01, 4.0208817543E+00, 9.8177996870E-01],
	[4.7490000000E+04, 4.6163548427E+01, 5.2377980600E+00, 2.7699719031E+01, 4.0211757573E+00, 9.8178716871E-01],
	[4.7495000000E+04, 4.6172193442E+01, 5.2378445845E+00, 2.7709255557E+01, 4.0214696905E+00, 9.8179436544E-01],
	[4.7500000000E+04, 4.6180839166E+01, 5.2378911044E+00, 2.7718794360E+01, 4.0217635541E+00, 9.8180155889E-01],
	[4.7505000000E+04, 4.6189485598E+01, 5.2379376199E+00, 2.7728335441E+01, 4.0220573480E+00, 9.8180874906E-01],
	[4.7510000000E+04, 4.6198132738E+01, 5.2379841309E+00, 2.7737878800E+01, 4.0223510722E+00, 9.8181593595E-01],
	[4.7515000000E+04, 4.6206780588E+01, 5.2380306374E+00, 2.7747424438E+01, 4.0226447268E+00, 9.8182311957E-01],
	[4.7520000000E+04, 4.6215429146E+01, 5.2380771394E+00, 2.7756972354E+01, 4.0229383118E+00, 9.8183029990E-01],
	[4.7525000000E+04, 4.6224078412E+01, 5.2381236369E+00, 2.7766522549E+01, 4.0232318273E+00, 9.8183747697E-01],
	[4.7530000000E+04, 4.6232744381E+01, 5.2381717974E+00, 2.7776075024E+01, 4.0235263780E+00, 9.8184465076E-01],
	[4.7535000000E+04, 4.6241411468E+01, 5.2382199955E+00, 2.7785629778E+01, 4.0238208874E+00, 9.8185182128E-01],
	[4.7540000000E+04, 4.6250079268E+01, 5.2382681890E+00, 2.7795186813E+01, 4.0241153274E+00, 9.8185898853E-01],
	[4.7545000000E+04, 4.6258747781E+01, 5.2383163779E+00, 2.7804746127E+01, 4.0244096981E+00, 9.8186615252E-01],
	[4.7550000000E+04, 4.6267417007E+01, 5.2383645622E+00, 2.7814307722E+01, 4.0247039993E+00, 9.8187331324E-01],
	[4.7555000000E+04, 4.6276086945E+01, 5.2384127418E+00, 2.7823871598E+01, 4.0249982313E+00, 9.8188047070E-01],
	[4.7560000000E+04, 4.6284757597E+01, 5.2384609169E+00, 2.7833437755E+01, 4.0252923939E+00, 9.8188762490E-01],
	[4.7565000000E+04, 4.6293428961E+01, 5.2385090873E+00, 2.7843006194E+01, 4.0255864873E+00, 9.8189477583E-01],
	[4.7570000000E+04, 4.6302101039E+01, 5.2385572530E+00, 2.7852576914E+01, 4.0258805113E+00, 9.8190192351E-01],
	[4.7575000000E+04, 4.6310773829E+01, 5.2386054142E+00, 2.7862149917E+01, 4.0261744661E+00, 9.8190906793E-01],
	[4.7580000000E+04, 4.6319447332E+01, 5.2386535707E+00, 2.7871725201E+01, 4.0264683517E+00, 9.8191620910E-01],
	[4.7585000000E+04, 4.6328121547E+01, 5.2387017226E+00, 2.7881302769E+01, 4.0267621681E+00, 9.8192334702E-01],
	[4.7590000000E+04, 4.6336796476E+01, 5.2387498700E+00, 2.7890882620E+01, 4.0270559152E+00, 9.8193048168E-01],
	[4.7595000000E+04, 4.6345472117E+01, 5.2387980126E+00, 2.7900464753E+01, 4.0273495932E+00, 9.8193761310E-01],
	[4.7600000000E+04, 4.6354148471E+01, 5.2388461507E+00, 2.7910049171E+01, 4.0276432019E+00, 9.8194474126E-01],
	[4.7605000000E+04, 4.6362825537E+01, 5.2388942842E+00, 2.7919635872E+01, 4.0279367416E+00, 9.8195186618E-01],
	[4.7610000000E+04, 4.6371503317E+01, 5.2389424130E+00, 2.7929224858E+01, 4.0282302121E+00, 9.8195898786E-01],
	[4.7615000000E+04, 4.6380181809E+01, 5.2389905373E+00, 2.7938816128E+01, 4.0285236135E+00, 9.8196610629E-01],
	[4.7620000000E+04, 4.6388861013E+01, 5.2390386569E+00, 2.7948409682E+01, 4.0288169458E+00, 9.8197322148E-01],
	[4.7625000000E+04, 4.6397540931E+01, 5.2390867719E+00, 2.7958005522E+01, 4.0291102090E+00, 9.8198033343E-01],
	[4.7630000000E+04, 4.6406221561E+01, 5.2391348823E+00, 2.7967603648E+01, 4.0294034032E+00, 9.8198744214E-01],
	[4.7635000000E+04, 4.6414902903E+01, 5.2391829881E+00, 2.7977204059E+01, 4.0296965283E+00, 9.8199454761E-01],
	[4.7640000000E+04, 4.6423584958E+01, 5.2392310893E+00, 2.7986806756E+01, 4.0299895844E+00, 9.8200164985E-01],
	[4.7645000000E+04, 4.6432267726E+01, 5.2392791859E+00, 2.7996411739E+01, 4.0302825716E+00, 9.8200874885E-01],
	[4.7650000000E+04, 4.6440951206E+01, 5.2393272778E+00, 2.8006019010E+01, 4.0305754897E+00, 9.8201584462E-01],
	[4.7655000000E+04, 4.6449635399E+01, 5.2393753652E+00, 2.8015628567E+01, 4.0308683388E+00, 9.8202293716E-01],
	[4.7660000000E+04, 4.6458320305E+01, 5.2394234480E+00, 2.8025240411E+01, 4.0311611191E+00, 9.8203002647E-01],
	[4.7665000000E+04, 4.6467005922E+01, 5.2394715261E+00, 2.8034854543E+01, 4.0314538303E+00, 9.8203711255E-01],
	[4.7670000000E+04, 4.6475692253E+01, 5.2395195997E+00, 2.8044470962E+01, 4.0317464727E+00, 9.8204419541E-01],
	[4.7675000000E+04, 4.6484379296E+01, 5.2395676687E+00, 2.8054089670E+01, 4.0320390462E+00, 9.8205127504E-01],
	[4.7680000000E+04, 4.6493067051E+01, 5.2396157330E+00, 2.8063710667E+01, 4.0323315508E+00, 9.8205835145E-01],
	[4.7685000000E+04, 4.6501755519E+01, 5.2396637928E+00, 2.8073333952E+01, 4.0326239866E+00, 9.8206542463E-01],
	[4.7690000000E+04, 4.6510444699E+01, 5.2397118479E+00, 2.8082959526E+01, 4.0329163535E+00, 9.8207249460E-01],
	[4.7695000000E+04, 4.6519134592E+01, 5.2397598985E+00, 2.8092587389E+01, 4.0332086516E+00, 9.8207956134E-01],
	[4.7700000000E+04, 4.6527825197E+01, 5.2398079445E+00, 2.8102217543E+01, 4.0335008809E+00, 9.8208662487E-01],
	[4.7705000000E+04, 4.6536516514E+01, 5.2398559859E+00, 2.8111849986E+01, 4.0337930414E+00, 9.8209368519E-01],
	[4.7710000000E+04, 4.6545208544E+01, 5.2399040226E+00, 2.8121484719E+01, 4.0340851331E+00, 9.8210074229E-01],
	[4.7715000000E+04, 4.6553901286E+01, 5.2399520548E+00, 2.8131121743E+01, 4.0343771561E+00, 9.8210779617E-01],
	[4.7720000000E+04, 4.6562594741E+01, 5.2400000824E+00, 2.8140761058E+01, 4.0346691104E+00, 9.8211484685E-01],
	[4.7725000000E+04, 4.6571288908E+01, 5.2400481054E+00, 2.8150402664E+01, 4.0349609960E+00, 9.8212189432E-01],
	[4.7730000000E+04, 4.6579983787E+01, 5.2400961238E+00, 2.8160046562E+01, 4.0352528128E+00, 9.8212893858E-01],
	[4.7735000000E+04, 4.6588679378E+01, 5.2401441376E+00, 2.8169692751E+01, 4.0355445610E+00, 9.8213597963E-01],
	[4.7740000000E+04, 4.6597375682E+01, 5.2401921469E+00, 2.8179341233E+01, 4.0358362406E+00, 9.8214301748E-01],
	[4.7745000000E+04, 4.6606072698E+01, 5.2402401515E+00, 2.8188992007E+01, 4.0361278515E+00, 9.8215005213E-01],
	[4.7750000000E+04, 4.6614770426E+01, 5.2402881516E+00, 2.8198645074E+01, 4.0364193938E+00, 9.8215708357E-01],
	[4.7755000000E+04, 4.6623468867E+01, 5.2403361470E+00, 2.8208300433E+01, 4.0367108675E+00, 9.8216411181E-01],
	[4.7760000000E+04, 4.6632168019E+01, 5.2403841379E+00, 2.8217958086E+01, 4.0370022726E+00, 9.8217113686E-01],
	[4.7765000000E+04, 4.6640867884E+01, 5.2404321242E+00, 2.8227618033E+01, 4.0372936091E+00, 9.8217815871E-01],
	[4.7770000000E+04, 4.6649568461E+01, 5.2404801059E+00, 2.8237280274E+01, 4.0375848771E+00, 9.8218517736E-01],
	[4.7775000000E+04, 4.6658269750E+01, 5.2405280831E+00, 2.8246944808E+01, 4.0378760766E+00, 9.8219219282E-01],
	[4.7780000000E+04, 4.6666971752E+01, 5.2405760556E+00, 2.8256611638E+01, 4.0381672075E+00, 9.8219920509E-01],
	[4.7785000000E+04, 4.6675674465E+01, 5.2406240236E+00, 2.8266280762E+01, 4.0384582700E+00, 9.8220621416E-01],
	[4.7790000000E+04, 4.6684377891E+01, 5.2406719870E+00, 2.8275952181E+01, 4.0387492640E+00, 9.8221322005E-01],
	[4.7795000000E+04, 4.6693082028E+01, 5.2407199458E+00, 2.8285625896E+01, 4.0390401895E+00, 9.8222022275E-01],
	[4.7800000000E+04, 4.6701786878E+01, 5.2407679000E+00, 2.8295301907E+01, 4.0393310466E+00, 9.8222722226E-01],
	[4.7805000000E+04, 4.6710492440E+01, 5.2408158497E+00, 2.8304980213E+01, 4.0396218353E+00, 9.8223421859E-01],
	[4.7810000000E+04, 4.6719198714E+01, 5.2408637948E+00, 2.8314660816E+01, 4.0399125556E+00, 9.8224121174E-01],
	[4.7815000000E+04, 4.6727905700E+01, 5.2409117353E+00, 2.8324343716E+01, 4.0402032075E+00, 9.8224820170E-01],
	[4.7820000000E+04, 4.6736613398E+01, 5.2409596712E+00, 2.8334028913E+01, 4.0404937910E+00, 9.8225518848E-01],
	[4.7825000000E+04, 4.6745321807E+01, 5.2410076026E+00, 2.8343716406E+01, 4.0407843062E+00, 9.8226217209E-01],
	[4.7830000000E+04, 4.6754030929E+01, 5.2410555293E+00, 2.8353406198E+01, 4.0410747531E+00, 9.8226915252E-01],
	[4.7835000000E+04, 4.6762740763E+01, 5.2411034516E+00, 2.8363098287E+01, 4.0413651316E+00, 9.8227612977E-01],
	[4.7840000000E+04, 4.6771451309E+01, 5.2411513692E+00, 2.8372792675E+01, 4.0416554419E+00, 9.8228310385E-01],
	[4.7845000000E+04, 4.6780162567E+01, 5.2411992823E+00, 2.8382489361E+01, 4.0419456839E+00, 9.8229007476E-01],
	[4.7850000000E+04, 4.6788874536E+01, 5.2412471908E+00, 2.8392188346E+01, 4.0422358576E+00, 9.8229704250E-01],
	[4.7855000000E+04, 4.6797587218E+01, 5.2412950947E+00, 2.8401889630E+01, 4.0425259631E+00, 9.8230400707E-01],
	[4.7860000000E+04, 4.6806300611E+01, 5.2413429941E+00, 2.8411593213E+01, 4.0428160004E+00, 9.8231096847E-01],
	[4.7865000000E+04, 4.6815014717E+01, 5.2413908889E+00, 2.8421299096E+01, 4.0431059694E+00, 9.8231792670E-01],
	[4.7870000000E+04, 4.6823729534E+01, 5.2414387791E+00, 2.8431007279E+01, 4.0433958703E+00, 9.8232488177E-01],
	[4.7875000000E+04, 4.6832445063E+01, 5.2414866648E+00, 2.8440717763E+01, 4.0436857031E+00, 9.8233183368E-01],
	[4.7880000000E+04, 4.6841161303E+01, 5.2415345459E+00, 2.8450430547E+01, 4.0439754676E+00, 9.8233878242E-01],
	[4.7885000000E+04, 4.6849878256E+01, 5.2415824224E+00, 2.8460145632E+01, 4.0442651641E+00, 9.8234572801E-01],
	[4.7890000000E+04, 4.6858595920E+01, 5.2416302944E+00, 2.8469863018E+01, 4.0445547924E+00, 9.8235267044E-01],
	[4.7895000000E+04, 4.6867314297E+01, 5.2416781619E+00, 2.8479582706E+01, 4.0448443527E+00, 9.8235960971E-01],
	[4.7900000000E+04, 4.6876033385E+01, 5.2417260247E+00, 2.8489304695E+01, 4.0451338449E+00, 9.8236654582E-01],
	[4.7905000000E+04, 4.6884753184E+01, 5.2417738830E+00, 2.8499028987E+01, 4.0454232690E+00, 9.8237347878E-01],
	[4.7910000000E+04, 4.6893473696E+01, 5.2418217368E+00, 2.8508755581E+01, 4.0457126251E+00, 9.8238040859E-01],
	[4.7915000000E+04, 4.6902194919E+01, 5.2418695860E+00, 2.8518484478E+01, 4.0460019132E+00, 9.8238733525E-01],
	[4.7920000000E+04, 4.6910916853E+01, 5.2419174306E+00, 2.8528215678E+01, 4.0462911332E+00, 9.8239425876E-01],
	[4.7925000000E+04, 4.6919639500E+01, 5.2419652707E+00, 2.8537949182E+01, 4.0465802853E+00, 9.8240117912E-01],
	[4.7930000000E+04, 4.6928362858E+01, 5.2420131062E+00, 2.8547684989E+01, 4.0468693694E+00, 9.8240809634E-01],
	[4.7935000000E+04, 4.6937086928E+01, 5.2420609372E+00, 2.8557423100E+01, 4.0471583856E+00, 9.8241501041E-01],
	[4.7940000000E+04, 4.6945811709E+01, 5.2421087636E+00, 2.8567163515E+01, 4.0474473339E+00, 9.8242192134E-01],
	[4.7945000000E+04, 4.6954537202E+01, 5.2421565855E+00, 2.8576906235E+01, 4.0477362142E+00, 9.8242882913E-01],
	[4.7950000000E+04, 4.6963263407E+01, 5.2422044028E+00, 2.8586651260E+01, 4.0480250266E+00, 9.8243573378E-01],
	[4.7955000000E+04, 4.6971990323E+01, 5.2422522155E+00, 2.8596398589E+01, 4.0483137712E+00, 9.8244263528E-01],
	[4.7960000000E+04, 4.6980717950E+01, 5.2423000238E+00, 2.8606148225E+01, 4.0486024479E+00, 9.8244953366E-01],
	[4.7965000000E+04, 4.6989446290E+01, 5.2423478274E+00, 2.8615900166E+01, 4.0488910568E+00, 9.8245642889E-01],
	[4.7970000000E+04, 4.6998175340E+01, 5.2423956266E+00, 2.8625654413E+01, 4.0491795979E+00, 9.8246332100E-01],
	[4.7975000000E+04, 4.7006905103E+01, 5.2424434211E+00, 2.8635410967E+01, 4.0494680711E+00, 9.8247020997E-01],
	[4.7980000000E+04, 4.7015635576E+01, 5.2424912112E+00, 2.8645169828E+01, 4.0497564766E+00, 9.8247709581E-01],
	[4.7985000000E+04, 4.7024366762E+01, 5.2425389967E+00, 2.8654930995E+01, 4.0500448143E+00, 9.8248397852E-01],
	[4.7990000000E+04, 4.7033098658E+01, 5.2425867776E+00, 2.8664694470E+01, 4.0503330842E+00, 9.8249085810E-01],
	[4.7995000000E+04, 4.7041831267E+01, 5.2426345540E+00, 2.8674460252E+01, 4.0506212865E+00, 9.8249773456E-01],
	[4.8000000000E+04, 4.7050564586E+01, 5.2426823259E+00, 2.8684228343E+01, 4.0509094210E+00, 9.8250460789E-01],
	[4.8005000000E+04, 4.7059298617E+01, 5.2427300932E+00, 2.8693998741E+01, 4.0511974878E+00, 9.8251147810E-01],
	[4.8010000000E+04, 4.7068033360E+01, 5.2427778560E+00, 2.8703771448E+01, 4.0514854869E+00, 9.8251834519E-01],
	[4.8015000000E+04, 4.7076768813E+01, 5.2428256142E+00, 2.8713546464E+01, 4.0517734184E+00, 9.8252520916E-01],
	[4.8020000000E+04, 4.7085504979E+01, 5.2428733679E+00, 2.8723323789E+01, 4.0520612823E+00, 9.8253207001E-01],
	[4.8025000000E+04, 4.7094241855E+01, 5.2429211171E+00, 2.8733103424E+01, 4.0523490785E+00, 9.8253892775E-01],
	[4.8030000000E+04, 4.7102979443E+01, 5.2429688617E+00, 2.8742885368E+01, 4.0526368071E+00, 9.8254578236E-01],
	[4.8035000000E+04, 4.7111717742E+01, 5.2430166018E+00, 2.8752669623E+01, 4.0529244682E+00, 9.8255263387E-01],
	[4.8040000000E+04, 4.7120456753E+01, 5.2430643373E+00, 2.8762456187E+01, 4.0532120617E+00, 9.8255948226E-01],
	[4.8045000000E+04, 4.7129196474E+01, 5.2431120684E+00, 2.8772245063E+01, 4.0534995876E+00, 9.8256632754E-01],
	[4.8050000000E+04, 4.7137936907E+01, 5.2431597949E+00, 2.8782036249E+01, 4.0537870460E+00, 9.8257316971E-01],
	[4.8055000000E+04, 4.7146678052E+01, 5.2432075168E+00, 2.8791829747E+01, 4.0540744368E+00, 9.8258000878E-01],
	[4.8060000000E+04, 4.7155419907E+01, 5.2432552342E+00, 2.8801625556E+01, 4.0543617602E+00, 9.8258684473E-01],
	[4.8065000000E+04, 4.7164162474E+01, 5.2433029471E+00, 2.8811423677E+01, 4.0546490161E+00, 9.8259367759E-01],
	[4.8070000000E+04, 4.7172905752E+01, 5.2433506555E+00, 2.8821224110E+01, 4.0549362046E+00, 9.8260050734E-01],
	[4.8075000000E+04, 4.7181649741E+01, 5.2433983594E+00, 2.8831026856E+01, 4.0552233256E+00, 9.8260733399E-01],
	[4.8080000000E+04, 4.7190394441E+01, 5.2434460587E+00, 2.8840831915E+01, 4.0555103792E+00, 9.8261415754E-01],
	[4.8085000000E+04, 4.7199139853E+01, 5.2434937535E+00, 2.8850639286E+01, 4.0557973654E+00, 9.8262097798E-01],
	[4.8090000000E+04, 4.7207885975E+01, 5.2435414437E+00, 2.8860448972E+01, 4.0560842842E+00, 9.8262779534E-01],
	[4.8095000000E+04, 4.7216632809E+01, 5.2435891295E+00, 2.8870260970E+01, 4.0563711356E+00, 9.8263460960E-01],
	[4.8100000000E+04, 4.7225380354E+01, 5.2436368107E+00, 2.8880075283E+01, 4.0566579197E+00, 9.8264142076E-01],
	[4.8105000000E+04, 4.7234128610E+01, 5.2436844874E+00, 2.8889891910E+01, 4.0569446364E+00, 9.8264822883E-01],
	[4.8110000000E+04, 4.7242877577E+01, 5.2437321596E+00, 2.8899710852E+01, 4.0572312858E+00, 9.8265503381E-01],
	[4.8115000000E+04, 4.7251627255E+01, 5.2437798272E+00, 2.8909532109E+01, 4.0575178680E+00, 9.8266183570E-01],
	[4.8120000000E+04, 4.7260377644E+01, 5.2438274903E+00, 2.8919355681E+01, 4.0578043828E+00, 9.8266863450E-01],
	[4.8125000000E+04, 4.7269128744E+01, 5.2438751489E+00, 2.8929181569E+01, 4.0580908304E+00, 9.8267543022E-01],
	[4.8130000000E+04, 4.7277880555E+01, 5.2439228030E+00, 2.8939009772E+01, 4.0583772107E+00, 9.8268222285E-01],
	[4.8135000000E+04, 4.7286633077E+01, 5.2439704526E+00, 2.8948840291E+01, 4.0586635239E+00, 9.8268901240E-01],
	[4.8140000000E+04, 4.7295386310E+01, 5.2440180977E+00, 2.8958673127E+01, 4.0589497698E+00, 9.8269579887E-01],
	[4.8145000000E+04, 4.7304140254E+01, 5.2440657382E+00, 2.8968508280E+01, 4.0592359485E+00, 9.8270258225E-01],
	[4.8150000000E+04, 4.7312894909E+01, 5.2441133743E+00, 2.8978345750E+01, 4.0595220601E+00, 9.8270936256E-01],
	[4.8155000000E+04, 4.7321650275E+01, 5.2441610058E+00, 2.8988185537E+01, 4.0598081045E+00, 9.8271613979E-01],
	[4.8160000000E+04, 4.7330406352E+01, 5.2442086328E+00, 2.8998027642E+01, 4.0600940817E+00, 9.8272291394E-01],
	[4.8165000000E+04, 4.7339163140E+01, 5.2442562553E+00, 2.9007872065E+01, 4.0603799919E+00, 9.8272968502E-01],
	[4.8170000000E+04, 4.7347920639E+01, 5.2443038732E+00, 2.9017718806E+01, 4.0606658349E+00, 9.8273645303E-01],
	[4.8175000000E+04, 4.7356678848E+01, 5.2443514867E+00, 2.9027567866E+01, 4.0609516109E+00, 9.8274321797E-01],
	[4.8180000000E+04, 4.7365437769E+01, 5.2443990957E+00, 2.9037419244E+01, 4.0612373198E+00, 9.8274997984E-01],
	[4.8185000000E+04, 4.7374197400E+01, 5.2444467001E+00, 2.9047272942E+01, 4.0615229617E+00, 9.8275673863E-01],
	[4.8190000000E+04, 4.7382957742E+01, 5.2444943001E+00, 2.9057128959E+01, 4.0618085365E+00, 9.8276349437E-01],
	[4.8195000000E+04, 4.7391718795E+01, 5.2445418955E+00, 2.9066987297E+01, 4.0620940443E+00, 9.8277024703E-01],
	[4.8200000000E+04, 4.7400480558E+01, 5.2445894864E+00, 2.9076847954E+01, 4.0623794852E+00, 9.8277699664E-01],
	[4.8205000000E+04, 4.7409243033E+01, 5.2446370729E+00, 2.9086710931E+01, 4.0626648590E+00, 9.8278374318E-01],
	[4.8210000000E+04, 4.7418006218E+01, 5.2446846548E+00, 2.9096576230E+01, 4.0629501660E+00, 9.8279048666E-01],
	[4.8215000000E+04, 4.7426770114E+01, 5.2447322322E+00, 2.9106443849E+01, 4.0632354059E+00, 9.8279722708E-01],
	[4.8220000000E+04, 4.7435534720E+01, 5.2447798051E+00, 2.9116313790E+01, 4.0635205790E+00, 9.8280396444E-01],
	[4.8225000000E+04, 4.7444300037E+01, 5.2448273736E+00, 2.9126186052E+01, 4.0638056851E+00, 9.8281069875E-01],
	[4.8230000000E+04, 4.7453066065E+01, 5.2448749375E+00, 2.9136060637E+01, 4.0640907244E+00, 9.8281743001E-01],
	[4.8235000000E+04, 4.7461832804E+01, 5.2449224969E+00, 2.9145937543E+01, 4.0643756968E+00, 9.8282415821E-01],
	[4.8240000000E+04, 4.7470600253E+01, 5.2449700518E+00, 2.9155816772E+01, 4.0646606023E+00, 9.8283088336E-01],
	[4.8245000000E+04, 4.7479368413E+01, 5.2450176022E+00, 2.9165698324E+01, 4.0649454411E+00, 9.8283760546E-01],
	[4.8250000000E+04, 4.7488137284E+01, 5.2450651482E+00, 2.9175582200E+01, 4.0652302130E+00, 9.8284432451E-01],
	[4.8255000000E+04, 4.7496906865E+01, 5.2451126896E+00, 2.9185468398E+01, 4.0655149181E+00, 9.8285104051E-01],
	[4.8260000000E+04, 4.7505677157E+01, 5.2451602265E+00, 2.9195356921E+01, 4.0657995564E+00, 9.8285775347E-01],
	[4.8265000000E+04, 4.7514448159E+01, 5.2452077590E+00, 2.9205247767E+01, 4.0660841280E+00, 9.8286446338E-01],
	[4.8270000000E+04, 4.7523219872E+01, 5.2452552869E+00, 2.9215140938E+01, 4.0663686328E+00, 9.8287117026E-01],
	[4.8275000000E+04, 4.7531992296E+01, 5.2453028104E+00, 2.9225036433E+01, 4.0666530709E+00, 9.8287787409E-01],
	[4.8280000000E+04, 4.7540765430E+01, 5.2453503293E+00, 2.9234934254E+01, 4.0669374424E+00, 9.8288457488E-01],
	[4.8285000000E+04, 4.7549539274E+01, 5.2453978438E+00, 2.9244834400E+01, 4.0672217471E+00, 9.8289127263E-01],
	[4.8290000000E+04, 4.7558313829E+01, 5.2454453538E+00, 2.9254736871E+01, 4.0675059851E+00, 9.8289796735E-01],
	[4.8295000000E+04, 4.7567104791E+01, 5.2454944609E+00, 2.9264641668E+01, 4.0677912345E+00, 9.8290465903E-01],
	[4.8300000000E+04, 4.7575897168E+01, 5.2455436348E+00, 2.9274548792E+01, 4.0680764654E+00, 9.8291134768E-01],
	[4.8305000000E+04, 4.7584690260E+01, 5.2455928040E+00, 2.9284458242E+01, 4.0683616299E+00, 9.8291803330E-01],
	[4.8310000000E+04, 4.7593484066E+01, 5.2456419687E+00, 2.9294370019E+01, 4.0686467279E+00, 9.8292471589E-01],
	[4.8315000000E+04, 4.7602278588E+01, 5.2456911287E+00, 2.9304284123E+01, 4.0689317594E+00, 9.8293139545E-01],
	[4.8320000000E+04, 4.7611073824E+01, 5.2457402841E+00, 2.9314200554E+01, 4.0692167245E+00, 9.8293807198E-01],
	[4.8325000000E+04, 4.7619869774E+01, 5.2457894348E+00, 2.9324119313E+01, 4.0695016232E+00, 9.8294474548E-01],
	[4.8330000000E+04, 4.7628666440E+01, 5.2458385809E+00, 2.9334040401E+01, 4.0697864556E+00, 9.8295141596E-01],
	[4.8335000000E+04, 4.7637463820E+01, 5.2458877224E+00, 2.9343963816E+01, 4.0700712215E+00, 9.8295808342E-01],
	[4.8340000000E+04, 4.7646261915E+01, 5.2459368593E+00, 2.9353889560E+01, 4.0703559211E+00, 9.8296474786E-01],
	[4.8345000000E+04, 4.7655060724E+01, 5.2459859916E+00, 2.9363817634E+01, 4.0706405544E+00, 9.8297140928E-01],
	[4.8350000000E+04, 4.7663860248E+01, 5.2460351192E+00, 2.9373748036E+01, 4.0709251213E+00, 9.8297806767E-01],
	[4.8355000000E+04, 4.7672660487E+01, 5.2460842423E+00, 2.9383680768E+01, 4.0712096219E+00, 9.8298472306E-01],
	[4.8360000000E+04, 4.7681461441E+01, 5.2461333607E+00, 2.9393615830E+01, 4.0714940563E+00, 9.8299137542E-01],
	[4.8365000000E+04, 4.7690263109E+01, 5.2461824744E+00, 2.9403553222E+01, 4.0717784243E+00, 9.8299802478E-01],
	[4.8370000000E+04, 4.7699065492E+01, 5.2462315836E+00, 2.9413492944E+01, 4.0720627262E+00, 9.8300467112E-01],
	[4.8375000000E+04, 4.7707868589E+01, 5.2462806882E+00, 2.9423434998E+01, 4.0723469618E+00, 9.8301131445E-01],
	[4.8380000000E+04, 4.7716672401E+01, 5.2463297881E+00, 2.9433379382E+01, 4.0726311312E+00, 9.8301795477E-01],
	[4.8385000000E+04, 4.7725476927E+01, 5.2463788834E+00, 2.9443326098E+01, 4.0729152344E+00, 9.8302459208E-01],
	[4.8390000000E+04, 4.7734282168E+01, 5.2464279741E+00, 2.9453275145E+01, 4.0731992714E+00, 9.8303122639E-01],
	[4.8395000000E+04, 4.7743088124E+01, 5.2464770602E+00, 2.9463226525E+01, 4.0734832422E+00, 9.8303785769E-01],
	[4.8400000000E+04, 4.7751894794E+01, 5.2465261417E+00, 2.9473180237E+01, 4.0737671469E+00, 9.8304448599E-01],
	[4.8405000000E+04, 4.7760702178E+01, 5.2465752185E+00, 2.9483136281E+01, 4.0740509855E+00, 9.8305111128E-01],
	[4.8410000000E+04, 4.7769510277E+01, 5.2466242908E+00, 2.9493094659E+01, 4.0743347580E+00, 9.8305773358E-01],
	[4.8415000000E+04, 4.7778319090E+01, 5.2466733585E+00, 2.9503055369E+01, 4.0746184644E+00, 9.8306435288E-01],
	[4.8420000000E+04, 4.7787128618E+01, 5.2467224215E+00, 2.9513018413E+01, 4.0749021047E+00, 9.8307096918E-01],
	[4.8425000000E+04, 4.7795938860E+01, 5.2467714799E+00, 2.9522983791E+01, 4.0751856790E+00, 9.8307758248E-01],
	[4.8430000000E+04, 4.7804749817E+01, 5.2468205338E+00, 2.9532951503E+01, 4.0754691872E+00, 9.8308419279E-01],
	[4.8435000000E+04, 4.7813561488E+01, 5.2468695830E+00, 2.9542921550E+01, 4.0757526294E+00, 9.8309080011E-01],
	[4.8440000000E+04, 4.7822373874E+01, 5.2469186276E+00, 2.9552893931E+01, 4.0760360056E+00, 9.8309740444E-01],
	[4.8445000000E+04, 4.7831186974E+01, 5.2469676676E+00, 2.9562868648E+01, 4.0763193159E+00, 9.8310400577E-01],
	[4.8450000000E+04, 4.7840000788E+01, 5.2470167030E+00, 2.9572845699E+01, 4.0766025601E+00, 9.8311060412E-01],
	[4.8455000000E+04, 4.7848815316E+01, 5.2470657338E+00, 2.9582825087E+01, 4.0768857384E+00, 9.8311719948E-01],
	[4.8460000000E+04, 4.7857630559E+01, 5.2471147600E+00, 2.9592806810E+01, 4.0771688508E+00, 9.8312379186E-01],
	[4.8465000000E+04, 4.7866446516E+01, 5.2471637816E+00, 2.9602790870E+01, 4.0774518973E+00, 9.8313038125E-01],
	[4.8470000000E+04, 4.7875263187E+01, 5.2472127986E+00, 2.9612777266E+01, 4.0777348779E+00, 9.8313696766E-01],
	[4.8475000000E+04, 4.7884080573E+01, 5.2472618111E+00, 2.9622765999E+01, 4.0780177926E+00, 9.8314355109E-01],
	[4.8480000000E+04, 4.7892898673E+01, 5.2473108189E+00, 2.9632757069E+01, 4.0783006414E+00, 9.8315013154E-01],
	[4.8485000000E+04, 4.7901717487E+01, 5.2473598221E+00, 2.9642750477E+01, 4.0785834244E+00, 9.8315670901E-01],
	[4.8490000000E+04, 4.7910537016E+01, 5.2474088207E+00, 2.9652746223E+01, 4.0788661416E+00, 9.8316328350E-01],
	[4.8495000000E+04, 4.7919357258E+01, 5.2474578147E+00, 2.9662744307E+01, 4.0791487930E+00, 9.8316985502E-01],
	[4.8500000000E+04, 4.7928178215E+01, 5.2475068042E+00, 2.9672744729E+01, 4.0794313785E+00, 9.8317642357E-01],
	[4.8505000000E+04, 4.7936999886E+01, 5.2475557890E+00, 2.9682747490E+01, 4.0797138984E+00, 9.8318298914E-01],
	[4.8510000000E+04, 4.7945822271E+01, 5.2476047692E+00, 2.9692752589E+01, 4.0799963524E+00, 9.8318955175E-01],
	[4.8515000000E+04, 4.7954645370E+01, 5.2476537449E+00, 2.9702760029E+01, 4.0802787407E+00, 9.8319611138E-01],
	[4.8520000000E+04, 4.7963469184E+01, 5.2477027160E+00, 2.9712769808E+01, 4.0805610633E+00, 9.8320266805E-01],
	[4.8525000000E+04, 4.7972293711E+01, 5.2477516824E+00, 2.9722781926E+01, 4.0808433202E+00, 9.8320922175E-01],
	[4.8530000000E+04, 4.7981118953E+01, 5.2478006443E+00, 2.9732796385E+01, 4.0811255115E+00, 9.8321577249E-01],
	[4.8535000000E+04, 4.7989944908E+01, 5.2478496016E+00, 2.9742813185E+01, 4.0814076370E+00, 9.8322232027E-01],
	[4.8540000000E+04, 4.7998771578E+01, 5.2478985543E+00, 2.9752832325E+01, 4.0816896969E+00, 9.8322886508E-01],
	[4.8545000000E+04, 4.8007598962E+01, 5.2479475025E+00, 2.9762853807E+01, 4.0819716912E+00, 9.8323540693E-01],
	[4.8550000000E+04, 4.8016427060E+01, 5.2479964460E+00, 2.9772877630E+01, 4.0822536199E+00, 9.8324194583E-01],
	[4.8555000000E+04, 4.8025255871E+01, 5.2480453850E+00, 2.9782903795E+01, 4.0825354829E+00, 9.8324848177E-01],
	[4.8560000000E+04, 4.8034085397E+01, 5.2480943193E+00, 2.9792932302E+01, 4.0828172804E+00, 9.8325501475E-01],
	[4.8565000000E+04, 4.8042915637E+01, 5.2481432491E+00, 2.9802963151E+01, 4.0830990124E+00, 9.8326154477E-01],
	[4.8570000000E+04, 4.8051746591E+01, 5.2481921744E+00, 2.9812996343E+01, 4.0833806787E+00, 9.8326807185E-01],
	[4.8575000000E+04, 4.8060578258E+01, 5.2482410950E+00, 2.9823031878E+01, 4.0836622796E+00, 9.8327459597E-01],
	[4.8580000000E+04, 4.8069410640E+01, 5.2482900110E+00, 2.9833069757E+01, 4.0839438150E+00, 9.8328111715E-01],
	[4.8585000000E+04, 4.8078243736E+01, 5.2483389225E+00, 2.9843109979E+01, 4.0842252848E+00, 9.8328763538E-01],
	[4.8590000000E+04, 4.8087077545E+01, 5.2483878294E+00, 2.9853152545E+01, 4.0845066892E+00, 9.8329415065E-01],
	[4.8595000000E+04, 4.8095912068E+01, 5.2484367317E+00, 2.9863197455E+01, 4.0847880282E+00, 9.8330066299E-01],
	[4.8600000000E+04, 4.8104747306E+01, 5.2484856295E+00, 2.9873244709E+01, 4.0850693017E+00, 9.8330717238E-01],
	[4.8605000000E+04, 4.8113583257E+01, 5.2485345226E+00, 2.9883294309E+01, 4.0853505098E+00, 9.8331367883E-01],
	[4.8610000000E+04, 4.8122419922E+01, 5.2485834112E+00, 2.9893346253E+01, 4.0856316525E+00, 9.8332018234E-01],
	[4.8615000000E+04, 4.8131257300E+01, 5.2486322953E+00, 2.9903400543E+01, 4.0859127298E+00, 9.8332668291E-01],
	[4.8620000000E+04, 4.8140095393E+01, 5.2486811747E+00, 2.9913457179E+01, 4.0861937417E+00, 9.8333318054E-01],
	[4.8625000000E+04, 4.8148934199E+01, 5.2487300496E+00, 2.9923516161E+01, 4.0864746883E+00, 9.8333967523E-01],
	[4.8630000000E+04, 4.8157773720E+01, 5.2487789199E+00, 2.9933577489E+01, 4.0867555696E+00, 9.8334616699E-01],
	[4.8635000000E+04, 4.8166613953E+01, 5.2488277856E+00, 2.9943641164E+01, 4.0870363855E+00, 9.8335265582E-01],
	[4.8640000000E+04, 4.8175454901E+01, 5.2488766468E+00, 2.9953707186E+01, 4.0873171362E+00, 9.8335914171E-01],
	[4.8645000000E+04, 4.8184296562E+01, 5.2489255034E+00, 2.9963775555E+01, 4.0875978216E+00, 9.8336562467E-01],
	[4.8650000000E+04, 4.8193138938E+01, 5.2489743554E+00, 2.9973846271E+01, 4.0878784417E+00, 9.8337210471E-01],
	[4.8655000000E+04, 4.8201982026E+01, 5.2490232029E+00, 2.9983919336E+01, 4.0881589965E+00, 9.8337858182E-01],
	[4.8660000000E+04, 4.8210825829E+01, 5.2490720458E+00, 2.9993994749E+01, 4.0884394862E+00, 9.8338505600E-01],
	[4.8665000000E+04, 4.8219670345E+01, 5.2491208842E+00, 3.0004072510E+01, 4.0887199106E+00, 9.8339152726E-01],
	[4.8670000000E+04, 4.8228515575E+01, 5.2491697179E+00, 3.0014152620E+01, 4.0890002699E+00, 9.8339799559E-01],
	[4.8675000000E+04, 4.8237361518E+01, 5.2492185472E+00, 3.0024235079E+01, 4.0892805639E+00, 9.8340446100E-01],
	[4.8680000000E+04, 4.8246208175E+01, 5.2492673718E+00, 3.0034319887E+01, 4.0895607929E+00, 9.8341092350E-01],
	[4.8685000000E+04, 4.8255055546E+01, 5.2493161919E+00, 3.0044407046E+01, 4.0898409566E+00, 9.8341738307E-01],
	[4.8690000000E+04, 4.8263903630E+01, 5.2493650074E+00, 3.0054496554E+01, 4.0901210553E+00, 9.8342383973E-01],
	[4.8695000000E+04, 4.8272752428E+01, 5.2494138184E+00, 3.0064588412E+01, 4.0904010889E+00, 9.8343029347E-01],
	[4.8700000000E+04, 4.8281601939E+01, 5.2494626248E+00, 3.0074682622E+01, 4.0906810573E+00, 9.8343674429E-01],
	[4.8705000000E+04, 4.8290452164E+01, 5.2495114267E+00, 3.0084779182E+01, 4.0909609607E+00, 9.8344319221E-01],
	[4.8710000000E+04, 4.8299303103E+01, 5.2495602240E+00, 3.0094878093E+01, 4.0912407991E+00, 9.8344963721E-01],
	[4.8715000000E+04, 4.8308154755E+01, 5.2496090167E+00, 3.0104979356E+01, 4.0915205724E+00, 9.8345607930E-01],
	[4.8720000000E+04, 4.8317007120E+01, 5.2496578049E+00, 3.0115082971E+01, 4.0918002807E+00, 9.8346251849E-01],
	[4.8725000000E+04, 4.8325860199E+01, 5.2497065886E+00, 3.0125188938E+01, 4.0920799240E+00, 9.8346895477E-01],
	[4.8730000000E+04, 4.8334713992E+01, 5.2497553677E+00, 3.0135297258E+01, 4.0923595024E+00, 9.8347538814E-01],
	[4.8735000000E+04, 4.8343568498E+01, 5.2498041422E+00, 3.0145407930E+01, 4.0926390157E+00, 9.8348181861E-01],
	[4.8740000000E+04, 4.8352423717E+01, 5.2498529122E+00, 3.0155520955E+01, 4.0929184641E+00, 9.8348824617E-01],
	[4.8745000000E+04, 4.8361279650E+01, 5.2499016776E+00, 3.0165636334E+01, 4.0931978476E+00, 9.8349467084E-01],
	[4.8750000000E+04, 4.8370136296E+01, 5.2499504385E+00, 3.0175754066E+01, 4.0934771662E+00, 9.8350109260E-01],
	[4.8755000000E+04, 4.8378993655E+01, 5.2499991949E+00, 3.0185874153E+01, 4.0937564199E+00, 9.8350751147E-01],
	[4.8760000000E+04, 4.8387851728E+01, 5.2500479467E+00, 3.0195996593E+01, 4.0940356087E+00, 9.8351392744E-01],
	[4.8765000000E+04, 4.8396710514E+01, 5.2500966939E+00, 3.0206121389E+01, 4.0943147327E+00, 9.8352034052E-01],
	[4.8770000000E+04, 4.8405570014E+01, 5.2501454366E+00, 3.0216248539E+01, 4.0945937918E+00, 9.8352675070E-01],
	[4.8775000000E+04, 4.8414430227E+01, 5.2501941748E+00, 3.0226378044E+01, 4.0948727861E+00, 9.8353315799E-01],
	[4.8780000000E+04, 4.8423291153E+01, 5.2502429084E+00, 3.0236509905E+01, 4.0951517156E+00, 9.8353956239E-01],
	[4.8785000000E+04, 4.8432152792E+01, 5.2502916374E+00, 3.0246644122E+01, 4.0954305803E+00, 9.8354596390E-01],
	[4.8790000000E+04, 4.8441015145E+01, 5.2503403620E+00, 3.0256780695E+01, 4.0957093802E+00, 9.8355236252E-01],
	[4.8795000000E+04, 4.8449878211E+01, 5.2503890820E+00, 3.0266919624E+01, 4.0959881154E+00, 9.8355875826E-01],
	[4.8800000000E+04, 4.8458741990E+01, 5.2504377974E+00, 3.0277060910E+01, 4.0962667858E+00, 9.8356515111E-01],
	[4.8805000000E+04, 4.8467606483E+01, 5.2504865083E+00, 3.0287204553E+01, 4.0965453916E+00, 9.8357154108E-01],
	[4.8810000000E+04, 4.8476471689E+01, 5.2505352147E+00, 3.0297350554E+01, 4.0968239326E+00, 9.8357792816E-01],
	[4.8815000000E+04, 4.8485337608E+01, 5.2505839165E+00, 3.0307498912E+01, 4.0971024089E+00, 9.8358431237E-01],
	[4.8820000000E+04, 4.8494204240E+01, 5.2506326138E+00, 3.0317649628E+01, 4.0973808206E+00, 9.8359069369E-01],
	[4.8825000000E+04, 4.8503071585E+01, 5.2506813066E+00, 3.0327802703E+01, 4.0976591676E+00, 9.8359707214E-01],
	[4.8830000000E+04, 4.8511939643E+01, 5.2507299948E+00, 3.0337958136E+01, 4.0979374500E+00, 9.8360344771E-01],
	[4.8835000000E+04, 4.8520808415E+01, 5.2507786785E+00, 3.0348115928E+01, 4.0982156678E+00, 9.8360982041E-01],
	[4.8840000000E+04, 4.8529677899E+01, 5.2508273576E+00, 3.0358276079E+01, 4.0984938210E+00, 9.8361619024E-01],
	[4.8845000000E+04, 4.8538548097E+01, 5.2508760323E+00, 3.0368438589E+01, 4.0987719096E+00, 9.8362255719E-01],
	[4.8850000000E+04, 4.8547419008E+01, 5.2509247024E+00, 3.0378603460E+01, 4.0990499336E+00, 9.8362892127E-01],
	[4.8855000000E+04, 4.8556290632E+01, 5.2509733679E+00, 3.0388770690E+01, 4.0993278931E+00, 9.8363528248E-01],
	[4.8860000000E+04, 4.8565162969E+01, 5.2510220290E+00, 3.0398940281E+01, 4.0996057881E+00, 9.8364164083E-01],
	[4.8865000000E+04, 4.8574036019E+01, 5.2510706855E+00, 3.0409112233E+01, 4.0998836186E+00, 9.8364799631E-01],
	[4.8870000000E+04, 4.8582909782E+01, 5.2511193375E+00, 3.0419286546E+01, 4.1001613846E+00, 9.8365434893E-01],
	[4.8875000000E+04, 4.8591784258E+01, 5.2511679849E+00, 3.0429463220E+01, 4.1004390861E+00, 9.8366069868E-01],
	[4.8880000000E+04, 4.8600659447E+01, 5.2512166278E+00, 3.0439642255E+01, 4.1007167231E+00, 9.8366704557E-01],
	[4.8885000000E+04, 4.8609535349E+01, 5.2512652662E+00, 3.0449823653E+01, 4.1009942957E+00, 9.8367338960E-01],
	[4.8890000000E+04, 4.8618411964E+01, 5.2513139001E+00, 3.0460007413E+01, 4.1012718039E+00, 9.8367973077E-01],
	[4.8895000000E+04, 4.8627289292E+01, 5.2513625295E+00, 3.0470193535E+01, 4.1015492477E+00, 9.8368606909E-01],
	[4.8900000000E+04, 4.8636167333E+01, 5.2514111543E+00, 3.0480382021E+01, 4.1018266271E+00, 9.8369240455E-01],
	[4.8905000000E+04, 4.8645046087E+01, 5.2514597746E+00, 3.0490572869E+01, 4.1021039421E+00, 9.8369873715E-01],
	[4.8910000000E+04, 4.8653925553E+01, 5.2515083904E+00, 3.0500766081E+01, 4.1023811928E+00, 9.8370506690E-01],
	[4.8915000000E+04, 4.8662805733E+01, 5.2515570017E+00, 3.0510961657E+01, 4.1026583791E+00, 9.8371139380E-01],
	[4.8920000000E+04, 4.8671686625E+01, 5.2516056084E+00, 3.0521159597E+01, 4.1029355011E+00, 9.8371771785E-01],
	[4.8925000000E+04, 4.8680568231E+01, 5.2516542107E+00, 3.0531359901E+01, 4.1032125588E+00, 9.8372403906E-01],
	[4.8930000000E+04, 4.8689450549E+01, 5.2517028084E+00, 3.0541562570E+01, 4.1034895523E+00, 9.8373035741E-01],
	[4.8935000000E+04, 4.8698333580E+01, 5.2517514016E+00, 3.0551767604E+01, 4.1037664814E+00, 9.8373667292E-01],
	[4.8940000000E+04, 4.8707217323E+01, 5.2517999903E+00, 3.0561975003E+01, 4.1040433463E+00, 9.8374298559E-01],
	[4.8945000000E+04, 4.8716101780E+01, 5.2518485744E+00, 3.0572184768E+01, 4.1043201470E+00, 9.8374929541E-01],
	[4.8950000000E+04, 4.8724986949E+01, 5.2518971541E+00, 3.0582396899E+01, 4.1045968835E+00, 9.8375560239E-01],
	[4.8955000000E+04, 4.8733872831E+01, 5.2519457293E+00, 3.0592611396E+01, 4.1048735558E+00, 9.8376190653E-01],
	[4.8960000000E+04, 4.8742759426E+01, 5.2519942999E+00, 3.0602828259E+01, 4.1051501639E+00, 9.8376820783E-01],
	[4.8965000000E+04, 4.8751646734E+01, 5.2520428660E+00, 3.0613047490E+01, 4.1054267078E+00, 9.8377450630E-01],
	[4.8970000000E+04, 4.8760534754E+01, 5.2520914276E+00, 3.0623269087E+01, 4.1057031876E+00, 9.8378080193E-01],
	[4.8975000000E+04, 4.8769423487E+01, 5.2521399847E+00, 3.0633493052E+01, 4.1059796033E+00, 9.8378709473E-01],
	[4.8980000000E+04, 4.8778312932E+01, 5.2521885373E+00, 3.0643719385E+01, 4.1062559549E+00, 9.8379338469E-01],
	[4.8985000000E+04, 4.8787203091E+01, 5.2522370854E+00, 3.0653948086E+01, 4.1065322423E+00, 9.8379967182E-01],
	[4.8990000000E+04, 4.8796093962E+01, 5.2522856290E+00, 3.0664179155E+01, 4.1068084657E+00, 9.8380595613E-01],
	[4.8995000000E+04, 4.8804985545E+01, 5.2523341681E+00, 3.0674412593E+01, 4.1070846251E+00, 9.8381223760E-01],
	[4.9000000000E+04, 4.8813877841E+01, 5.2523827026E+00, 3.0684648400E+01, 4.1073607204E+00, 9.8381851625E-01],
	[4.9005000000E+04, 4.8822770850E+01, 5.2524312327E+00, 3.0694886576E+01, 4.1076367516E+00, 9.8382479207E-01],
	[4.9010000000E+04, 4.8831664572E+01, 5.2524797583E+00, 3.0705127122E+01, 4.1079127189E+00, 9.8383106507E-01],
	[4.9015000000E+04, 4.8840559005E+01, 5.2525282793E+00, 3.0715370038E+01, 4.1081886222E+00, 9.8383733525E-01],
	[4.9020000000E+04, 4.8849454152E+01, 5.2525767959E+00, 3.0725615323E+01, 4.1084644615E+00, 9.8384360260E-01],
	[4.9025000000E+04, 4.8858350011E+01, 5.2526253080E+00, 3.0735862980E+01, 4.1087402368E+00, 9.8384986714E-01],
	[4.9030000000E+04, 4.8867246583E+01, 5.2526738155E+00, 3.0746113007E+01, 4.1090159483E+00, 9.8385612885E-01],
	[4.9035000000E+04, 4.8876143867E+01, 5.2527223186E+00, 3.0756365405E+01, 4.1092915958E+00, 9.8386238775E-01],
	[4.9040000000E+04, 4.8885041863E+01, 5.2527708171E+00, 3.0766620175E+01, 4.1095671794E+00, 9.8386864384E-01],
	[4.9045000000E+04, 4.8893940572E+01, 5.2528193112E+00, 3.0776877317E+01, 4.1098426991E+00, 9.8387489711E-01],
	[4.9050000000E+04, 4.8902839994E+01, 5.2528678008E+00, 3.0787136830E+01, 4.1101181549E+00, 9.8388114757E-01],
	[4.9055000000E+04, 4.8911740128E+01, 5.2529162859E+00, 3.0797398716E+01, 4.1103935469E+00, 9.8388739521E-01],
	[4.9060000000E+04, 4.8920640974E+01, 5.2529647665E+00, 3.0807662975E+01, 4.1106688751E+00, 9.8389364005E-01],
	[4.9065000000E+04, 4.8929542533E+01, 5.2530132425E+00, 3.0817929606E+01, 4.1109441394E+00, 9.8389988208E-01],
	[4.9070000000E+04, 4.8938452606E+01, 5.2530624934E+00, 3.0828198611E+01, 4.1112198724E+00, 9.8390612130E-01],
	[4.9075000000E+04, 4.8947371984E+01, 5.2531125975E+00, 3.0838469990E+01, 4.1114961277E+00, 9.8391235772E-01],
	[4.9080000000E+04, 4.8956292079E+01, 5.2531626971E+00, 3.0848743742E+01, 4.1117723194E+00, 9.8391859133E-01],
	[4.9085000000E+04, 4.8965212890E+01, 5.2532127920E+00, 3.0859019869E+01, 4.1120484474E+00, 9.8392482215E-01],
	[4.9090000000E+04, 4.8974134418E+01, 5.2532628823E+00, 3.0869298370E+01, 4.1123245119E+00, 9.8393105016E-01],
	[4.9095000000E+04, 4.8983056662E+01, 5.2533129679E+00, 3.0879579245E+01, 4.1126005128E+00, 9.8393727537E-01],
	[4.9100000000E+04, 4.8991979623E+01, 5.2533630490E+00, 3.0889862496E+01, 4.1128764501E+00, 9.8394349778E-01],
	[4.9105000000E+04, 4.9000903301E+01, 5.2534131254E+00, 3.0900148123E+01, 4.1131523238E+00, 9.8394971739E-01],
	[4.9110000000E+04, 4.9009827695E+01, 5.2534631972E+00, 3.0910436125E+01, 4.1134281340E+00, 9.8395593421E-01],
	[4.9115000000E+04, 4.9018752806E+01, 5.2535132644E+00, 3.0920726503E+01, 4.1137038807E+00, 9.8396214824E-01],
	[4.9120000000E+04, 4.9027678634E+01, 5.2535633269E+00, 3.0931019257E+01, 4.1139795639E+00, 9.8396835947E-01],
	[4.9125000000E+04, 4.9036605178E+01, 5.2536133848E+00, 3.0941314388E+01, 4.1142551836E+00, 9.8397456792E-01],
	[4.9130000000E+04, 4.9045532438E+01, 5.2536634382E+00, 3.0951611896E+01, 4.1145307399E+00, 9.8398077357E-01],
	[4.9135000000E+04, 4.9054460415E+01, 5.2537134869E+00, 3.0961911781E+01, 4.1148062327E+00, 9.8398697644E-01],
	[4.9140000000E+04, 4.9063389108E+01, 5.2537635309E+00, 3.0972214044E+01, 4.1150816620E+00, 9.8399317652E-01],
	[4.9145000000E+04, 4.9072318518E+01, 5.2538135704E+00, 3.0982518685E+01, 4.1153570280E+00, 9.8399937381E-01],
	[4.9150000000E+04, 4.9081248645E+01, 5.2538636053E+00, 3.0992825704E+01, 4.1156323305E+00, 9.8400556832E-01],
	[4.9155000000E+04, 4.9090179487E+01, 5.2539136355E+00, 3.1003135101E+01, 4.1159075697E+00, 9.8401176004E-01],
	[4.9160000000E+04, 4.9099111047E+01, 5.2539636611E+00, 3.1013446877E+01, 4.1161827455E+00, 9.8401794899E-01],
	[4.9165000000E+04, 4.9108043322E+01, 5.2540136822E+00, 3.1023761032E+01, 4.1164578580E+00, 9.8402413516E-01],
	[4.9170000000E+04, 4.9116976314E+01, 5.2540636986E+00, 3.1034077567E+01, 4.1167329071E+00, 9.8403031854E-01],
	[4.9175000000E+04, 4.9125910022E+01, 5.2541137104E+00, 3.1044396481E+01, 4.1170078929E+00, 9.8403649916E-01],
	[4.9180000000E+04, 4.9134844447E+01, 5.2541637175E+00, 3.1054717776E+01, 4.1172828154E+00, 9.8404267699E-01],
	[4.9185000000E+04, 4.9143779588E+01, 5.2542137201E+00, 3.1065041450E+01, 4.1175576747E+00, 9.8404885205E-01],
	[4.9190000000E+04, 4.9152715446E+01, 5.2542637181E+00, 3.1075367506E+01, 4.1178324707E+00, 9.8405502434E-01],
	[4.9195000000E+04, 4.9161652019E+01, 5.2543137115E+00, 3.1085695942E+01, 4.1181072034E+00, 9.8406119386E-01],
	[4.9200000000E+04, 4.9170589309E+01, 5.2543637002E+00, 3.1096026759E+01, 4.1183818729E+00, 9.8406736061E-01],
	[4.9205000000E+04, 4.9179527316E+01, 5.2544136844E+00, 3.1106359958E+01, 4.1186564792E+00, 9.8407352459E-01],
	[4.9210000000E+04, 4.9188466038E+01, 5.2544636639E+00, 3.1116695539E+01, 4.1189310223E+00, 9.8407968580E-01],
	[4.9215000000E+04, 4.9197405477E+01, 5.2545136389E+00, 3.1127033502E+01, 4.1192055022E+00, 9.8408584425E-01],
	[4.9220000000E+04, 4.9206345632E+01, 5.2545636092E+00, 3.1137373848E+01, 4.1194799190E+00, 9.8409199994E-01],
	[4.9225000000E+04, 4.9215286503E+01, 5.2546135750E+00, 3.1147716576E+01, 4.1197542726E+00, 9.8409815286E-01],
	[4.9230000000E+04, 4.9224228091E+01, 5.2546635361E+00, 3.1158061687E+01, 4.1200285631E+00, 9.8410430302E-01],
	[4.9235000000E+04, 4.9233170394E+01, 5.2547134927E+00, 3.1168409182E+01, 4.1203027905E+00, 9.8411045042E-01],
	[4.9240000000E+04, 4.9242113414E+01, 5.2547634446E+00, 3.1178759060E+01, 4.1205769548E+00, 9.8411659506E-01],
	[4.9245000000E+04, 4.9251057150E+01, 5.2548133920E+00, 3.1189111322E+01, 4.1208510561E+00, 9.8412273695E-01],
	[4.9250000000E+04, 4.9260001602E+01, 5.2548633347E+00, 3.1199465969E+01, 4.1211250943E+00, 9.8412887608E-01],
	[4.9255000000E+04, 4.9268946771E+01, 5.2549132729E+00, 3.1209823000E+01, 4.1213990694E+00, 9.8413501246E-01],
	[4.9260000000E+04, 4.9277892655E+01, 5.2549632065E+00, 3.1220182417E+01, 4.1216729815E+00, 9.8414114608E-01],
	[4.9265000000E+04, 4.9286839256E+01, 5.2550131354E+00, 3.1230544218E+01, 4.1219468306E+00, 9.8414727695E-01],
	[4.9270000000E+04, 4.9295786572E+01, 5.2550630598E+00, 3.1240908405E+01, 4.1222206167E+00, 9.8415340507E-01],
	[4.9275000000E+04, 4.9304734605E+01, 5.2551129796E+00, 3.1251274978E+01, 4.1224943399E+00, 9.8415953045E-01],
	[4.9280000000E+04, 4.9313683353E+01, 5.2551628948E+00, 3.1261643937E+01, 4.1227680001E+00, 9.8416565307E-01],
	[4.9285000000E+04, 4.9322632818E+01, 5.2552128054E+00, 3.1272015282E+01, 4.1230415973E+00, 9.8417177296E-01],
	[4.9290000000E+04, 4.9331582999E+01, 5.2552627114E+00, 3.1282389014E+01, 4.1233151317E+00, 9.8417789009E-01],
	[4.9295000000E+04, 4.9340533896E+01, 5.2553126129E+00, 3.1292765133E+01, 4.1235886031E+00, 9.8418400449E-01],
	[4.9300000000E+04, 4.9349485508E+01, 5.2553625097E+00, 3.1303143640E+01, 4.1238620117E+00, 9.8419011614E-01],
	[4.9305000000E+04, 4.9358437837E+01, 5.2554124020E+00, 3.1313524534E+01, 4.1241353573E+00, 9.8419622505E-01],
	[4.9310000000E+04, 4.9367390882E+01, 5.2554622896E+00, 3.1323907816E+01, 4.1244086402E+00, 9.8420233123E-01],
	[4.9315000000E+04, 4.9376344642E+01, 5.2555121727E+00, 3.1334293487E+01, 4.1246818602E+00, 9.8420843466E-01],
	[4.9320000000E+04, 4.9385299119E+01, 5.2555620512E+00, 3.1344681546E+01, 4.1249550173E+00, 9.8421453537E-01],
	[4.9325000000E+04, 4.9394254311E+01, 5.2556119252E+00, 3.1355071994E+01, 4.1252281117E+00, 9.8422063333E-01],
	[4.9330000000E+04, 4.9403210220E+01, 5.2556617945E+00, 3.1365464831E+01, 4.1255011433E+00, 9.8422672857E-01],
	[4.9335000000E+04, 4.9412166844E+01, 5.2557116592E+00, 3.1375860058E+01, 4.1257741121E+00, 9.8423282107E-01],
	[4.9340000000E+04, 4.9421124184E+01, 5.2557615194E+00, 3.1386257674E+01, 4.1260470182E+00, 9.8423891084E-01],
	[4.9345000000E+04, 4.9430082240E+01, 5.2558113750E+00, 3.1396657681E+01, 4.1263198615E+00, 9.8424499789E-01],
	[4.9350000000E+04, 4.9439041012E+01, 5.2558612260E+00, 3.1407060078E+01, 4.1265926422E+00, 9.8425108220E-01],
	[4.9355000000E+04, 4.9448000499E+01, 5.2559110725E+00, 3.1417464866E+01, 4.1268653601E+00, 9.8425716379E-01],
	[4.9360000000E+04, 4.9456960703E+01, 5.2559609143E+00, 3.1427872045E+01, 4.1271380153E+00, 9.8426324266E-01],
	[4.9365000000E+04, 4.9465921622E+01, 5.2560107516E+00, 3.1438281615E+01, 4.1274106079E+00, 9.8426931880E-01],
	[4.9370000000E+04, 4.9474883257E+01, 5.2560605843E+00, 3.1448693577E+01, 4.1276831379E+00, 9.8427539222E-01],
	[4.9375000000E+04, 4.9483845608E+01, 5.2561104125E+00, 3.1459107931E+01, 4.1279556052E+00, 9.8428146292E-01],
	[4.9380000000E+04, 4.9492808674E+01, 5.2561602360E+00, 3.1469524677E+01, 4.1282280098E+00, 9.8428753091E-01],
	[4.9385000000E+04, 4.9501772457E+01, 5.2562100550E+00, 3.1479943816E+01, 4.1285003519E+00, 9.8429359617E-01],
	[4.9390000000E+04, 4.9510736954E+01, 5.2562598694E+00, 3.1490365347E+01, 4.1287726314E+00, 9.8429965872E-01],
	[4.9395000000E+04, 4.9519702168E+01, 5.2563096793E+00, 3.1500789272E+01, 4.1290448484E+00, 9.8430571855E-01],
	[4.9400000000E+04, 4.9528668097E+01, 5.2563594846E+00, 3.1511215590E+01, 4.1293170028E+00, 9.8431177567E-01],
	[4.9405000000E+04, 4.9537634742E+01, 5.2564092853E+00, 3.1521644303E+01, 4.1295890946E+00, 9.8431783008E-01],
	[4.9410000000E+04, 4.9546602103E+01, 5.2564590814E+00, 3.1532075409E+01, 4.1298611240E+00, 9.8432388178E-01],
	[4.9415000000E+04, 4.9555570179E+01, 5.2565088730E+00, 3.1542508909E+01, 4.1301330909E+00, 9.8432993077E-01],
	[4.9420000000E+04, 4.9564538971E+01, 5.2565586600E+00, 3.1552944805E+01, 4.1304049953E+00, 9.8433597705E-01],
	[4.9425000000E+04, 4.9573508479E+01, 5.2566084424E+00, 3.1563383095E+01, 4.1306768372E+00, 9.8434202062E-01],
	[4.9430000000E+04, 4.9582478702E+01, 5.2566582203E+00, 3.1573823781E+01, 4.1309486167E+00, 9.8434806149E-01],
	[4.9435000000E+04, 4.9591449641E+01, 5.2567079936E+00, 3.1584266862E+01, 4.1312203337E+00, 9.8435409966E-01],
	[4.9440000000E+04, 4.9600421295E+01, 5.2567577624E+00, 3.1594712340E+01, 4.1314919883E+00, 9.8436013512E-01],
	[4.9445000000E+04, 4.9609393665E+01, 5.2568075266E+00, 3.1605160213E+01, 4.1317635806E+00, 9.8436616789E-01],
	[4.9450000000E+04, 4.9618366750E+01, 5.2568572862E+00, 3.1615610484E+01, 4.1320351105E+00, 9.8437219795E-01],
	[4.9455000000E+04, 4.9627340551E+01, 5.2569070413E+00, 3.1626063151E+01, 4.1323065780E+00, 9.8437822532E-01],
	[4.9460000000E+04, 4.9636315067E+01, 5.2569567918E+00, 3.1636518215E+01, 4.1325779831E+00, 9.8438424999E-01],
	[4.9465000000E+04, 4.9645290299E+01, 5.2570065377E+00, 3.1646975677E+01, 4.1328493260E+00, 9.8439027196E-01],
	[4.9470000000E+04, 4.9654266246E+01, 5.2570562791E+00, 3.1657435536E+01, 4.1331206065E+00, 9.8439629124E-01],
	[4.9475000000E+04, 4.9663242909E+01, 5.2571060160E+00, 3.1667897794E+01, 4.1333918247E+00, 9.8440230783E-01],
	[4.9480000000E+04, 4.9672220287E+01, 5.2571557483E+00, 3.1678362450E+01, 4.1336629807E+00, 9.8440832172E-01],
	[4.9485000000E+04, 4.9681198381E+01, 5.2572054760E+00, 3.1688829505E+01, 4.1339340744E+00, 9.8441433293E-01],
	[4.9490000000E+04, 4.9690177190E+01, 5.2572551992E+00, 3.1699298958E+01, 4.1342051059E+00, 9.8442034145E-01],
	[4.9495000000E+04, 4.9699156714E+01, 5.2573049178E+00, 3.1709770812E+01, 4.1344760751E+00, 9.8442634728E-01],
	[4.9500000000E+04, 4.9708136954E+01, 5.2573546319E+00, 3.1720245064E+01, 4.1347469821E+00, 9.8443235043E-01],
	[4.9505000000E+04, 4.9717117909E+01, 5.2574043414E+00, 3.1730721717E+01, 4.1350178270E+00, 9.8443835089E-01],
	[4.9510000000E+04, 4.9726099579E+01, 5.2574540463E+00, 3.1741200770E+01, 4.1352886096E+00, 9.8444434867E-01],
	[4.9515000000E+04, 4.9735081965E+01, 5.2575037468E+00, 3.1751682224E+01, 4.1355593301E+00, 9.8445034377E-01],
	[4.9520000000E+04, 4.9744065066E+01, 5.2575534426E+00, 3.1762166078E+01, 4.1358299885E+00, 9.8445633619E-01],
	[4.9525000000E+04, 4.9753048883E+01, 5.2576031339E+00, 3.1772652334E+01, 4.1361005848E+00, 9.8446232593E-01],
	[4.9530000000E+04, 4.9762033415E+01, 5.2576528207E+00, 3.1783140991E+01, 4.1363711189E+00, 9.8446831299E-01],
	[4.9535000000E+04, 4.9771018662E+01, 5.2577025029E+00, 3.1793632049E+01, 4.1366415909E+00, 9.8447429738E-01],
	[4.9540000000E+04, 4.9780004624E+01, 5.2577521806E+00, 3.1804125510E+01, 4.1369120009E+00, 9.8448027909E-01],
	[4.9545000000E+04, 4.9788991301E+01, 5.2578018538E+00, 3.1814621374E+01, 4.1371823488E+00, 9.8448625813E-01],
	[4.9550000000E+04, 4.9797978694E+01, 5.2578515224E+00, 3.1825119640E+01, 4.1374526347E+00, 9.8449223450E-01],
	[4.9555000000E+04, 4.9806966802E+01, 5.2579011864E+00, 3.1835620309E+01, 4.1377228586E+00, 9.8449820820E-01],
	[4.9560000000E+04, 4.9815955625E+01, 5.2579508459E+00, 3.1846123381E+01, 4.1379930204E+00, 9.8450417923E-01],
	[4.9565000000E+04, 4.9824945163E+01, 5.2580005009E+00, 3.1856628857E+01, 4.1382631203E+00, 9.8451014759E-01],
	[4.9570000000E+04, 4.9833935417E+01, 5.2580501513E+00, 3.1867136737E+01, 4.1385331582E+00, 9.8451611328E-01],
	[4.9575000000E+04, 4.9842926386E+01, 5.2580997972E+00, 3.1877647021E+01, 4.1388031341E+00, 9.8452207631E-01],
	[4.9580000000E+04, 4.9851918069E+01, 5.2581494386E+00, 3.1888159710E+01, 4.1390730481E+00, 9.8452803668E-01],
	[4.9585000000E+04, 4.9860910468E+01, 5.2581990754E+00, 3.1898674804E+01, 4.1393429002E+00, 9.8453399439E-01],
	[4.9590000000E+04, 4.9869903582E+01, 5.2582487076E+00, 3.1909192302E+01, 4.1396126904E+00, 9.8453994943E-01],
	[4.9595000000E+04, 4.9878897411E+01, 5.2582983354E+00, 3.1919712207E+01, 4.1398824187E+00, 9.8454590182E-01],
	[4.9600000000E+04, 4.9887891955E+01, 5.2583479586E+00, 3.1930234517E+01, 4.1401520851E+00, 9.8455185154E-01],
	[4.9605000000E+04, 4.9896887214E+01, 5.2583975773E+00, 3.1940759233E+01, 4.1404216896E+00, 9.8455779862E-01],
	[4.9610000000E+04, 4.9905883189E+01, 5.2584471914E+00, 3.1951286355E+01, 4.1406912323E+00, 9.8456374303E-01],
	[4.9615000000E+04, 4.9914879878E+01, 5.2584968010E+00, 3.1961815884E+01, 4.1409607133E+00, 9.8456968479E-01],
	[4.9620000000E+04, 4.9923877282E+01, 5.2585464061E+00, 3.1972347820E+01, 4.1412301324E+00, 9.8457562390E-01],
	[4.9625000000E+04, 4.9932875401E+01, 5.2585960066E+00, 3.1982882164E+01, 4.1414994897E+00, 9.8458156036E-01],
	[4.9630000000E+04, 4.9941874236E+01, 5.2586456027E+00, 3.1993418915E+01, 4.1417687852E+00, 9.8458749417E-01],
	[4.9635000000E+04, 4.9950873785E+01, 5.2586951941E+00, 3.2003958074E+01, 4.1420380190E+00, 9.8459342533E-01],
	[4.9640000000E+04, 4.9959874049E+01, 5.2587447811E+00, 3.2014499641E+01, 4.1423071910E+00, 9.8459935385E-01],
	[4.9645000000E+04, 4.9968875028E+01, 5.2587943635E+00, 3.2025043617E+01, 4.1425763014E+00, 9.8460527972E-01],
	[4.9650000000E+04, 4.9977876722E+01, 5.2588439415E+00, 3.2035590002E+01, 4.1428453500E+00, 9.8461120294E-01],
	[4.9655000000E+04, 4.9986879131E+01, 5.2588935148E+00, 3.2046138796E+01, 4.1431143370E+00, 9.8461712352E-01],
	[4.9660000000E+04, 4.9995882255E+01, 5.2589430837E+00, 3.2056689999E+01, 4.1433832622E+00, 9.8462304146E-01],
	[4.9665000000E+04, 5.0004886094E+01, 5.2589926480E+00, 3.2067243612E+01, 4.1436521259E+00, 9.8462895676E-01],
	[4.9670000000E+04, 5.0013890647E+01, 5.2590422078E+00, 3.2077799635E+01, 4.1439209278E+00, 9.8463486943E-01],
	[4.9675000000E+04, 5.0022895916E+01, 5.2590917631E+00, 3.2088358069E+01, 4.1441896682E+00, 9.8464077945E-01],
	[4.9680000000E+04, 5.0031901899E+01, 5.2591413139E+00, 3.2098918913E+01, 4.1444583470E+00, 9.8464668684E-01],
	[4.9685000000E+04, 5.0040908597E+01, 5.2591908602E+00, 3.2109482168E+01, 4.1447269642E+00, 9.8465259159E-01],
	[4.9690000000E+04, 5.0049916010E+01, 5.2592404019E+00, 3.2120047835E+01, 4.1449955198E+00, 9.8465849371E-01],
	[4.9695000000E+04, 5.0058924137E+01, 5.2592899391E+00, 3.2130615913E+01, 4.1452640138E+00, 9.8466439320E-01],
	[4.9700000000E+04, 5.0067932980E+01, 5.2593394718E+00, 3.2141186403E+01, 4.1455324464E+00, 9.8467029006E-01],
	[4.9705000000E+04, 5.0076942537E+01, 5.2593890000E+00, 3.2151759305E+01, 4.1458008174E+00, 9.8467618429E-01],
	[4.9710000000E+04, 5.0085952809E+01, 5.2594385236E+00, 3.2162334620E+01, 4.1460691269E+00, 9.8468207589E-01],
	[4.9715000000E+04, 5.0094963795E+01, 5.2594880428E+00, 3.2172912348E+01, 4.1463373749E+00, 9.8468796487E-01],
	[4.9720000000E+04, 5.0103975497E+01, 5.2595375574E+00, 3.2183492489E+01, 4.1466055614E+00, 9.8469385122E-01],
	[4.9725000000E+04, 5.0112987913E+01, 5.2595870675E+00, 3.2194075043E+01, 4.1468736865E+00, 9.8469973494E-01],
	[4.9730000000E+04, 5.0122001043E+01, 5.2596365732E+00, 3.2204660011E+01, 4.1471417502E+00, 9.8470561605E-01],
	[4.9735000000E+04, 5.0131014889E+01, 5.2596860742E+00, 3.2215247393E+01, 4.1474097524E+00, 9.8471149453E-01],
	[4.9740000000E+04, 5.0140029449E+01, 5.2597355708E+00, 3.2225837190E+01, 4.1476776933E+00, 9.8471737040E-01],
	[4.9745000000E+04, 5.0149044723E+01, 5.2597850629E+00, 3.2236429401E+01, 4.1479455728E+00, 9.8472324364E-01],
	[4.9750000000E+04, 5.0158060712E+01, 5.2598345505E+00, 3.2247024027E+01, 4.1482133908E+00, 9.8472911427E-01],
	[4.9755000000E+04, 5.0167077416E+01, 5.2598840335E+00, 3.2257621069E+01, 4.1484811476E+00, 9.8473498228E-01],
	[4.9760000000E+04, 5.0176094835E+01, 5.2599335121E+00, 3.2268220526E+01, 4.1487488430E+00, 9.8474084768E-01],
	[4.9765000000E+04, 5.0185112968E+01, 5.2599829862E+00, 3.2278822399E+01, 4.1490164771E+00, 9.8474671047E-01],
	[4.9770000000E+04, 5.0194131815E+01, 5.2600324557E+00, 3.2289426688E+01, 4.1492840499E+00, 9.8475257065E-01],
	[4.9775000000E+04, 5.0203151377E+01, 5.2600819207E+00, 3.2300033394E+01, 4.1495515614E+00, 9.8475842821E-01],
	[4.9780000000E+04, 5.0212171654E+01, 5.2601313813E+00, 3.2310642516E+01, 4.1498190116E+00, 9.8476428317E-01],
	[4.9785000000E+04, 5.0221192645E+01, 5.2601808373E+00, 3.2321254056E+01, 4.1500864006E+00, 9.8477013552E-01],
	[4.9790000000E+04, 5.0230214351E+01, 5.2602302888E+00, 3.2331868013E+01, 4.1503537283E+00, 9.8477598526E-01],
	[4.9795000000E+04, 5.0239236771E+01, 5.2602797359E+00, 3.2342484388E+01, 4.1506209949E+00, 9.8478183240E-01],
	[4.9800000000E+04, 5.0248259905E+01, 5.2603291784E+00, 3.2353103181E+01, 4.1508882002E+00, 9.8478767693E-01],
	[4.9805000000E+04, 5.0257283754E+01, 5.2603786164E+00, 3.2363724393E+01, 4.1511553444E+00, 9.8479351886E-01],
	[4.9810000000E+04, 5.0266308318E+01, 5.2604280500E+00, 3.2374348023E+01, 4.1514224273E+00, 9.8479935820E-01],
	[4.9815000000E+04, 5.0275333596E+01, 5.2604774790E+00, 3.2384974072E+01, 4.1516894492E+00, 9.8480519493E-01],
	[4.9820000000E+04, 5.0284359588E+01, 5.2605269035E+00, 3.2395602541E+01, 4.1519564099E+00, 9.8481102907E-01],
	[4.9825000000E+04, 5.0293386294E+01, 5.2605763236E+00, 3.2406233429E+01, 4.1522233094E+00, 9.8481686060E-01],
	[4.9830000000E+04, 5.0302413716E+01, 5.2606257391E+00, 3.2416866736E+01, 4.1524901479E+00, 9.8482268955E-01],
	[4.9835000000E+04, 5.0311441851E+01, 5.2606751502E+00, 3.2427502465E+01, 4.1527569253E+00, 9.8482851590E-01],
	[4.9840000000E+04, 5.0320470701E+01, 5.2607245567E+00, 3.2438140613E+01, 4.1530236416E+00, 9.8483433966E-01],
	[4.9845000000E+04, 5.0329500265E+01, 5.2607739588E+00, 3.2448781183E+01, 4.1532902969E+00, 9.8484016082E-01],
	[4.9850000000E+04, 5.0338530543E+01, 5.2608233564E+00, 3.2459424173E+01, 4.1535568911E+00, 9.8484597940E-01],
	[4.9855000000E+04, 5.0347561536E+01, 5.2608727495E+00, 3.2470069586E+01, 4.1538234244E+00, 9.8485179539E-01],
	[4.9860000000E+04, 5.0356601301E+01, 5.2609229258E+00, 3.2480717419E+01, 4.1540904426E+00, 9.8485760879E-01],
	[4.9865000000E+04, 5.0365650119E+01, 5.2609739121E+00, 3.2491367675E+01, 4.1543579645E+00, 9.8486341960E-01],
	[4.9870000000E+04, 5.0374699654E+01, 5.2610248939E+00, 3.2502020354E+01, 4.1546254255E+00, 9.8486922783E-01],
	[4.9875000000E+04, 5.0383749909E+01, 5.2610758710E+00, 3.2512675455E+01, 4.1548928258E+00, 9.8487503348E-01],
	[4.9880000000E+04, 5.0392800881E+01, 5.2611268435E+00, 3.2523332979E+01, 4.1551601652E+00, 9.8488083655E-01],
	[4.9885000000E+04, 5.0401852573E+01, 5.2611778114E+00, 3.2533992926E+01, 4.1554274438E+00, 9.8488663703E-01],
	[4.9890000000E+04, 5.0410904982E+01, 5.2612287747E+00, 3.2544655297E+01, 4.1556946616E+00, 9.8489243494E-01],
	[4.9895000000E+04, 5.0419958110E+01, 5.2612797333E+00, 3.2555320091E+01, 4.1559618187E+00, 9.8489823027E-01],
	[4.9900000000E+04, 5.0429011957E+01, 5.2613306874E+00, 3.2565987310E+01, 4.1562289150E+00, 9.8490402302E-01],
	[4.9905000000E+04, 5.0438066522E+01, 5.2613816368E+00, 3.2576656954E+01, 4.1564959505E+00, 9.8490981320E-01],
	[4.9910000000E+04, 5.0447121805E+01, 5.2614325816E+00, 3.2587329022E+01, 4.1567629254E+00, 9.8491560080E-01],
	[4.9915000000E+04, 5.0456177806E+01, 5.2614835218E+00, 3.2598003516E+01, 4.1570298395E+00, 9.8492138583E-01],
	[4.9920000000E+04, 5.0465234526E+01, 5.2615344574E+00, 3.2608680435E+01, 4.1572966930E+00, 9.8492716829E-01],
	[4.9925000000E+04, 5.0474291964E+01, 5.2615853884E+00, 3.2619359779E+01, 4.1575634857E+00, 9.8493294818E-01],
	[4.9930000000E+04, 5.0483350121E+01, 5.2616363148E+00, 3.2630041550E+01, 4.1578302179E+00, 9.8493872550E-01],
	[4.9935000000E+04, 5.0492408996E+01, 5.2616872366E+00, 3.2640725747E+01, 4.1580968893E+00, 9.8494450026E-01],
	[4.9940000000E+04, 5.0501468589E+01, 5.2617381538E+00, 3.2651412371E+01, 4.1583635002E+00, 9.8495027245E-01],
	[4.9945000000E+04, 5.0510528900E+01, 5.2617890664E+00, 3.2662101422E+01, 4.1586300505E+00, 9.8495604207E-01],
	[4.9950000000E+04, 5.0519589930E+01, 5.2618399743E+00, 3.2672792900E+01, 4.1588965401E+00, 9.8496180913E-01],
	[4.9955000000E+04, 5.0528651678E+01, 5.2618908777E+00, 3.2683486806E+01, 4.1591629692E+00, 9.8496757362E-01],
	[4.9960000000E+04, 5.0537714144E+01, 5.2619417765E+00, 3.2694183139E+01, 4.1594293378E+00, 9.8497333556E-01],
	[4.9965000000E+04, 5.0546777328E+01, 5.2619926706E+00, 3.2704881901E+01, 4.1596956458E+00, 9.8497909493E-01],
	[4.9970000000E+04, 5.0555841231E+01, 5.2620435602E+00, 3.2715583092E+01, 4.1599618932E+00, 9.8498485175E-01],
	[4.9975000000E+04, 5.0564905852E+01, 5.2620944451E+00, 3.2726286711E+01, 4.1602280802E+00, 9.8499060601E-01],
	[4.9980000000E+04, 5.0573971191E+01, 5.2621453255E+00, 3.2736992759E+01, 4.1604942067E+00, 9.8499635771E-01],
	[4.9985000000E+04, 5.0583037248E+01, 5.2621962013E+00, 3.2747701237E+01, 4.1607602727E+00, 9.8500210685E-01],
	[4.9990000000E+04, 5.0592104023E+01, 5.2622470724E+00, 3.2758412144E+01, 4.1610262783E+00, 9.8500785344E-01],
	[4.9995000000E+04, 5.0601171516E+01, 5.2622979390E+00, 3.2769125482E+01, 4.1612922234E+00, 9.8501359748E-01],
	[5.0000000000E+04, 5.0610239727E+01, 5.2623488010E+00, 3.2779841250E+01, 4.1615581081E+00, 9.8501933897E-01],
	[5.0005000000E+04, 5.0619308657E+01, 5.2623996584E+00, 3.2790573998E+01, 4.1618241667E+00, 9.8502507791E-01],
	[5.0010000000E+04, 5.0628378304E+01, 5.2624505111E+00, 3.2801309185E+01, 4.1620901649E+00, 9.8503081429E-01],
	[5.0015000000E+04, 5.0637448670E+01, 5.2625013593E+00, 3.2812046811E+01, 4.1623561025E+00, 9.8503654813E-01],
	[5.0020000000E+04, 5.0646519754E+01, 5.2625522029E+00, 3.2822786878E+01, 4.1626219797E+00, 9.8504227942E-01],
	[5.0025000000E+04, 5.0655591555E+