# -*- coding: utf-8 -*-
from plone.app.contenttypes.testing import TEST_MIGRATION
from plone.app.contenttypes.testing import PLONE_APP_CONTENTTYPES_INTEGRATION_TESTING  # noqa
import unittest

if TEST_MIGRATION:
    from plone.app.contenttypes.interfaces import IDocument
    from plone.app.contenttypes.interfaces import IFile
    from plone.app.contenttypes.interfaces import IFolder
    from plone.app.contenttypes.interfaces import IImage
    from plone.app.contenttypes.interfaces import ILink
    from plone.app.contenttypes.interfaces import INewsItem
    from plone.app.contenttypes.interfaces import IPloneAppContenttypesLayer
    from plone.app.testing import applyProfile
    from plone.app.testing import setRoles
    from plone.app.testing import TEST_USER_ID
    from plone.dexterity.fti import DexterityFTI
    from plone.dexterity.interfaces import IDexterityFTI
    from plone.event.interfaces import IEvent
    from Products.CMFCore.utils import getToolByName
    from zope.interface import directlyProvides


class FixBaseclassesTest(unittest.TestCase):

    layer = PLONE_APP_CONTENTTYPES_INTEGRATION_TESTING

    def setUp(self):
        if not TEST_MIGRATION:
            raise unittest.SkipTest('Migration tests require ATContentTypes')

        self.portal = self.layer['portal']
        self.request = self.layer['request']
        self.request['ACTUAL_URL'] = self.portal.absolute_url()
        self.request['URL'] = self.portal.absolute_url()
        directlyProvides(self.request, IPloneAppContenttypesLayer)
        setRoles(self.portal, TEST_USER_ID, ['Manager'])
        self.catalog = getToolByName(self.portal, 'portal_catalog')
        fti = DexterityFTI('mockobject')
        fti.klass = 'plone.dexterity.content.Item'
        self.portal.portal_types._setObject('mockobject', fti)
        self.portal.invokeFactory('mockobject', 'obj1')
        self.obj = self.portal.obj1

    def test_view_is_registered(self):
        view = self.portal.restrictedTraverse('fix_base_classes')
        self.assertTrue(isinstance(view(), str))

    def test_fix_interface_for_document(self):
        self.obj.portal_type = 'Document'
        self.catalog.reindexObject(self.obj)

        self.portal.restrictedTraverse('fix_base_classes')()

        self.assertTrue(IDocument.providedBy(self.obj))

    def test_fix_interface_for_event(self):
        self.obj.portal_type = 'Event'
        self.catalog.reindexObject(self.obj)

        self.portal.restrictedTraverse('fix_base_classes')()

        self.assertTrue(IEvent.providedBy(self.obj))

    def test_fix_interface_for_file(self):
        self.obj.portal_type = 'File'
        self.catalog.reindexObject(self.obj)

        self.portal.restrictedTraverse('fix_base_classes')()

        self.assertTrue(IFile.providedBy(self.obj))

    def test_fix_interface_for_folder(self):
        self.obj.portal_type = 'Folder'
        self.catalog.reindexObject(self.obj)

        self.portal.restrictedTraverse('fix_base_classes')()

        self.assertTrue(IFolder.providedBy(self.obj))

    def test_fix_interface_for_image(self):
        self.obj.portal_type = 'Image'
        self.catalog.reindexObject(self.obj)

        self.portal.restrictedTraverse('fix_base_classes')()

        self.assertTrue(IImage.providedBy(self.obj))

    def test_fix_interface_for_link(self):
        self.obj.portal_type = 'Link'
        self.catalog.reindexObject(self.obj)

        self.portal.restrictedTraverse('fix_base_classes')()

        self.assertTrue(ILink.providedBy(self.obj))

    def test_fix_interface_for_news_item(self):
        self.obj.portal_type = 'News Item'
        self.catalog.reindexObject(self.obj)

        self.portal.restrictedTraverse('fix_base_classes')()

        self.assertTrue(INewsItem.providedBy(self.obj))

    def test_install_dx_type_if_needed(self):
        from plone.app.contenttypes.migration.utils import installTypeIfNeeded
        tt = self.portal.portal_types
        tt.manage_delObjects('Document')
        tt.manage_addTypeInformation(
            'Factory-based Type Information with dynamic views',
            id='Document')
        applyProfile(
            self.portal,
            'plone.app.contenttypes:default',
            blacklisted_steps=['typeinfo'])
        fti = tt.getTypeInfo('Document')
        self.assertFalse(IDexterityFTI.providedBy(fti))
        installTypeIfNeeded('Document')
        fti = tt.getTypeInfo('Document')
        self.assertTrue(IDexterityFTI.providedBy(fti))

    def test_install_dx_type_if_needed_wrong_type_name(self):
        from plone.app.contenttypes.migration.utils import installTypeIfNeeded
        with self.assertRaises(KeyError) as e:
            installTypeIfNeeded('Unknown')
        self.assertEqual(
            e.exception.args[0],
            'Unknown is not one of the default types'
        )
