"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Condition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A Condition for use in a Choice state branch.
 *
 * @stability stable
 */
class Condition {
    /**
     * Matches if variable is present.
     *
     * @stability stable
     */
    static isPresent(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsPresent, true);
    }
    /**
     * Matches if variable is not present.
     *
     * @stability stable
     */
    static isNotPresent(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsPresent, false);
    }
    /**
     * Matches if variable is a string.
     *
     * @stability stable
     */
    static isString(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsString, true);
    }
    /**
     * Matches if variable is not a string.
     *
     * @stability stable
     */
    static isNotString(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsString, false);
    }
    /**
     * Matches if variable is numeric.
     *
     * @stability stable
     */
    static isNumeric(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsNumeric, true);
    }
    /**
     * Matches if variable is not numeric.
     *
     * @stability stable
     */
    static isNotNumeric(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsNumeric, false);
    }
    /**
     * Matches if variable is boolean.
     *
     * @stability stable
     */
    static isBoolean(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsBoolean, true);
    }
    /**
     * Matches if variable is not boolean.
     *
     * @stability stable
     */
    static isNotBoolean(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsBoolean, false);
    }
    /**
     * Matches if variable is a timestamp.
     *
     * @stability stable
     */
    static isTimestamp(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsTimestamp, true);
    }
    /**
     * Matches if variable is not a timestamp.
     *
     * @stability stable
     */
    static isNotTimestamp(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsTimestamp, false);
    }
    /**
     * Matches if variable is not null.
     *
     * @stability stable
     */
    static isNotNull(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsNull, false);
    }
    /**
     * Matches if variable is Null.
     *
     * @stability stable
     */
    static isNull(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsNull, true);
    }
    /**
     * Matches if a boolean field has the given value.
     *
     * @stability stable
     */
    static booleanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.BooleanEquals, value);
    }
    /**
     * Matches if a boolean field equals to a value at a given mapping path.
     *
     * @stability stable
     */
    static booleanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.BooleanEqualsPath, value);
    }
    /**
     * Matches if a string field equals to a value at a given mapping path.
     *
     * @stability stable
     */
    static stringEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringEqualsPath, value);
    }
    /**
     * Matches if a string field has the given value.
     *
     * @stability stable
     */
    static stringEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringEquals, value);
    }
    /**
     * Matches if a string field sorts before a given value.
     *
     * @stability stable
     */
    static stringLessThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringLessThan, value);
    }
    /**
     * Matches if a string field sorts before a given value at a particular mapping.
     *
     * @stability stable
     */
    static stringLessThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringLessThanPath, value);
    }
    /**
     * Matches if a string field sorts equal to or before a given value.
     *
     * @stability stable
     */
    static stringLessThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringLessThanEquals, value);
    }
    /**
     * Matches if a string field sorts equal to or before a given mapping.
     *
     * @stability stable
     */
    static stringLessThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringLessThanEqualsPath, value);
    }
    /**
     * Matches if a string field sorts after a given value.
     *
     * @stability stable
     */
    static stringGreaterThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringGreaterThan, value);
    }
    /**
     * Matches if a string field sorts after a value at a given mapping path.
     *
     * @stability stable
     */
    static stringGreaterThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringGreaterThanPath, value);
    }
    /**
     * Matches if a string field sorts after or equal to value at a given mapping path.
     *
     * @stability stable
     */
    static stringGreaterThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringGreaterThanEqualsPath, value);
    }
    /**
     * Matches if a string field sorts after or equal to a given value.
     *
     * @stability stable
     */
    static stringGreaterThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringGreaterThanEquals, value);
    }
    /**
     * Matches if a numeric field has the given value.
     *
     * @stability stable
     */
    static numberEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericEquals, value);
    }
    /**
     * Matches if a numeric field has the value in a given mapping path.
     *
     * @stability stable
     */
    static numberEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericEqualsPath, value);
    }
    /**
     * Matches if a numeric field is less than the given value.
     *
     * @stability stable
     */
    static numberLessThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericLessThan, value);
    }
    /**
     * Matches if a numeric field is less than the value at the given mapping path.
     *
     * @stability stable
     */
    static numberLessThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericLessThanPath, value);
    }
    /**
     * Matches if a numeric field is less than or equal to the given value.
     *
     * @stability stable
     */
    static numberLessThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericLessThanEquals, value);
    }
    /**
     * Matches if a numeric field is less than or equal to the numeric value at given mapping path.
     *
     * @stability stable
     */
    static numberLessThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericLessThanEqualsPath, value);
    }
    /**
     * Matches if a numeric field is greater than the given value.
     *
     * @stability stable
     */
    static numberGreaterThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericGreaterThan, value);
    }
    /**
     * Matches if a numeric field is greater than the value at a given mapping path.
     *
     * @stability stable
     */
    static numberGreaterThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericGreaterThanPath, value);
    }
    /**
     * Matches if a numeric field is greater than or equal to the given value.
     *
     * @stability stable
     */
    static numberGreaterThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericGreaterThanEquals, value);
    }
    /**
     * Matches if a numeric field is greater than or equal to the value at a given mapping path.
     *
     * @stability stable
     */
    static numberGreaterThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericGreaterThanEqualsPath, value);
    }
    /**
     * Matches if a timestamp field is the same time as the given timestamp.
     *
     * @stability stable
     */
    static timestampEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampEquals, value);
    }
    /**
     * Matches if a timestamp field is the same time as the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampEqualsPath, value);
    }
    /**
     * Matches if a timestamp field is before the given timestamp.
     *
     * @stability stable
     */
    static timestampLessThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampLessThan, value);
    }
    /**
     * Matches if a timestamp field is before the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampLessThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampLessThanPath, value);
    }
    /**
     * Matches if a timestamp field is before or equal to the given timestamp.
     *
     * @stability stable
     */
    static timestampLessThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampLessThanEquals, value);
    }
    /**
     * Matches if a timestamp field is before or equal to the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampLessThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampLessThanEqualsPath, value);
    }
    /**
     * Matches if a timestamp field is after the given timestamp.
     *
     * @stability stable
     */
    static timestampGreaterThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampGreaterThan, value);
    }
    /**
     * Matches if a timestamp field is after the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampGreaterThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampGreaterThanPath, value);
    }
    /**
     * Matches if a timestamp field is after or equal to the given timestamp.
     *
     * @stability stable
     */
    static timestampGreaterThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampGreaterThanEquals, value);
    }
    /**
     * Matches if a timestamp field is after or equal to the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampGreaterThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampGreaterThanEqualsPath, value);
    }
    /**
     * Matches if a field matches a string pattern that can contain a wild card (*) e.g: log-*.txt or *LATEST*. No other characters other than "*" have any special meaning - * can be escaped: \\*.
     *
     * @stability stable
     */
    static stringMatches(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringMatches, value);
    }
    /**
     * Combine two or more conditions with a logical AND.
     *
     * @stability stable
     */
    static and(...conditions) {
        return new CompoundCondition(CompoundOperator.And, ...conditions);
    }
    /**
     * Combine two or more conditions with a logical OR.
     *
     * @stability stable
     */
    static or(...conditions) {
        return new CompoundCondition(CompoundOperator.Or, ...conditions);
    }
    /**
     * Negate a condition.
     *
     * @stability stable
     */
    static not(condition) {
        return new NotCondition(condition);
    }
}
exports.Condition = Condition;
_a = JSII_RTTI_SYMBOL_1;
Condition[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Condition", version: "1.91.0" };
/**
 * Comparison Operator types
 */
var ComparisonOperator;
(function (ComparisonOperator) {
    ComparisonOperator[ComparisonOperator["StringEquals"] = 0] = "StringEquals";
    ComparisonOperator[ComparisonOperator["StringEqualsPath"] = 1] = "StringEqualsPath";
    ComparisonOperator[ComparisonOperator["StringLessThan"] = 2] = "StringLessThan";
    ComparisonOperator[ComparisonOperator["StringLessThanPath"] = 3] = "StringLessThanPath";
    ComparisonOperator[ComparisonOperator["StringGreaterThan"] = 4] = "StringGreaterThan";
    ComparisonOperator[ComparisonOperator["StringGreaterThanPath"] = 5] = "StringGreaterThanPath";
    ComparisonOperator[ComparisonOperator["StringLessThanEquals"] = 6] = "StringLessThanEquals";
    ComparisonOperator[ComparisonOperator["StringLessThanEqualsPath"] = 7] = "StringLessThanEqualsPath";
    ComparisonOperator[ComparisonOperator["StringGreaterThanEquals"] = 8] = "StringGreaterThanEquals";
    ComparisonOperator[ComparisonOperator["StringGreaterThanEqualsPath"] = 9] = "StringGreaterThanEqualsPath";
    ComparisonOperator[ComparisonOperator["NumericEquals"] = 10] = "NumericEquals";
    ComparisonOperator[ComparisonOperator["NumericEqualsPath"] = 11] = "NumericEqualsPath";
    ComparisonOperator[ComparisonOperator["NumericLessThan"] = 12] = "NumericLessThan";
    ComparisonOperator[ComparisonOperator["NumericLessThanPath"] = 13] = "NumericLessThanPath";
    ComparisonOperator[ComparisonOperator["NumericGreaterThan"] = 14] = "NumericGreaterThan";
    ComparisonOperator[ComparisonOperator["NumericGreaterThanPath"] = 15] = "NumericGreaterThanPath";
    ComparisonOperator[ComparisonOperator["NumericLessThanEquals"] = 16] = "NumericLessThanEquals";
    ComparisonOperator[ComparisonOperator["NumericLessThanEqualsPath"] = 17] = "NumericLessThanEqualsPath";
    ComparisonOperator[ComparisonOperator["NumericGreaterThanEquals"] = 18] = "NumericGreaterThanEquals";
    ComparisonOperator[ComparisonOperator["NumericGreaterThanEqualsPath"] = 19] = "NumericGreaterThanEqualsPath";
    ComparisonOperator[ComparisonOperator["BooleanEquals"] = 20] = "BooleanEquals";
    ComparisonOperator[ComparisonOperator["BooleanEqualsPath"] = 21] = "BooleanEqualsPath";
    ComparisonOperator[ComparisonOperator["TimestampEquals"] = 22] = "TimestampEquals";
    ComparisonOperator[ComparisonOperator["TimestampEqualsPath"] = 23] = "TimestampEqualsPath";
    ComparisonOperator[ComparisonOperator["TimestampLessThan"] = 24] = "TimestampLessThan";
    ComparisonOperator[ComparisonOperator["TimestampLessThanPath"] = 25] = "TimestampLessThanPath";
    ComparisonOperator[ComparisonOperator["TimestampGreaterThan"] = 26] = "TimestampGreaterThan";
    ComparisonOperator[ComparisonOperator["TimestampGreaterThanPath"] = 27] = "TimestampGreaterThanPath";
    ComparisonOperator[ComparisonOperator["TimestampLessThanEquals"] = 28] = "TimestampLessThanEquals";
    ComparisonOperator[ComparisonOperator["TimestampLessThanEqualsPath"] = 29] = "TimestampLessThanEqualsPath";
    ComparisonOperator[ComparisonOperator["TimestampGreaterThanEquals"] = 30] = "TimestampGreaterThanEquals";
    ComparisonOperator[ComparisonOperator["TimestampGreaterThanEqualsPath"] = 31] = "TimestampGreaterThanEqualsPath";
    ComparisonOperator[ComparisonOperator["IsNull"] = 32] = "IsNull";
    ComparisonOperator[ComparisonOperator["IsBoolean"] = 33] = "IsBoolean";
    ComparisonOperator[ComparisonOperator["IsNumeric"] = 34] = "IsNumeric";
    ComparisonOperator[ComparisonOperator["IsString"] = 35] = "IsString";
    ComparisonOperator[ComparisonOperator["IsTimestamp"] = 36] = "IsTimestamp";
    ComparisonOperator[ComparisonOperator["IsPresent"] = 37] = "IsPresent";
    ComparisonOperator[ComparisonOperator["StringMatches"] = 38] = "StringMatches";
})(ComparisonOperator || (ComparisonOperator = {}));
/**
 * Compound Operator types
 */
var CompoundOperator;
(function (CompoundOperator) {
    CompoundOperator[CompoundOperator["And"] = 0] = "And";
    CompoundOperator[CompoundOperator["Or"] = 1] = "Or";
})(CompoundOperator || (CompoundOperator = {}));
/**
 * Scalar comparison
 */
class VariableComparison extends Condition {
    constructor(variable, comparisonOperator, value) {
        super();
        this.variable = variable;
        this.comparisonOperator = comparisonOperator;
        this.value = value;
        if (!/^\$|(\$[.[])/.test(variable)) {
            throw new Error(`Variable reference must be '$', start with '$.', or start with '$[', got '${variable}'`);
        }
    }
    renderCondition() {
        return {
            Variable: this.variable,
            [ComparisonOperator[this.comparisonOperator]]: this.value,
        };
    }
}
/**
 * Logical compound condition
 */
class CompoundCondition extends Condition {
    constructor(operator, ...conditions) {
        super();
        this.operator = operator;
        this.conditions = conditions;
        if (conditions.length === 0) {
            throw new Error('Must supply at least one inner condition for a logical combination');
        }
    }
    renderCondition() {
        return {
            [CompoundOperator[this.operator]]: this.conditions.map(c => c.renderCondition()),
        };
    }
}
/**
 * Logical unary condition
 */
class NotCondition extends Condition {
    constructor(comparisonOperation) {
        super();
        this.comparisonOperation = comparisonOperation;
    }
    renderCondition() {
        return {
            Not: this.comparisonOperation.renderCondition(),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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