"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationRule = exports.DetailType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const codestarnotifications_generated_1 = require("./codestarnotifications.generated");
/**
 * The level of detail to include in the notifications for this resource.
 *
 * @stability stable
 */
var DetailType;
(function (DetailType) {
    DetailType["BASIC"] = "BASIC";
    DetailType["FULL"] = "FULL";
})(DetailType = exports.DetailType || (exports.DetailType = {}));
/**
 * A new notification rule.
 *
 * @stability stable
 * @resource AWS::CodeStarNotifications::NotificationRule
 */
class NotificationRule extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.targets = [];
        this.events = [];
        jsiiDeprecationWarnings._aws_cdk_aws_codestarnotifications_NotificationRuleProps(props);
        const source = props.source.bindAsNotificationRuleSource(this);
        this.addEvents(props.events);
        const resource = new codestarnotifications_generated_1.CfnNotificationRule(this, 'Resource', {
            // It has a 64 characters limit for the name
            name: props.notificationRuleName || core_1.Names.uniqueId(this).slice(-64),
            detailType: props.detailType || DetailType.FULL,
            targets: this.targets,
            eventTypeIds: this.events,
            resource: source.sourceArn,
            status: props.enabled !== undefined
                ? (props.enabled ? 'ENABLED' : 'DISABLED')
                : undefined,
        });
        this.notificationRuleArn = resource.ref;
        (_b = props.targets) === null || _b === void 0 ? void 0 : _b.forEach((target) => {
            this.addTarget(target);
        });
    }
    /**
     * Import an existing notification rule provided an ARN.
     *
     * @param scope The parent creating construct.
     * @param id The construct's name.
     * @param notificationRuleArn Notification rule ARN (i.e. arn:aws:codestar-notifications:::notificationrule/01234abcde).
     * @stability stable
     */
    static fromNotificationRuleArn(scope, id, notificationRuleArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.notificationRuleArn = notificationRuleArn;
            }
            addTarget(_target) {
                return false;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: notificationRuleArn,
        });
    }
    /**
     * Adds target to notification rule.
     *
     * @param target The SNS topic or AWS Chatbot Slack target.
     * @stability stable
     */
    addTarget(target) {
        jsiiDeprecationWarnings._aws_cdk_aws_codestarnotifications_INotificationRuleTarget(target);
        this.targets.push(target.bindAsNotificationRuleTarget(this));
        return true;
    }
    /**
     * Adds events to notification rule
     *
     * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline
     * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-buildproject
     * @param events The list of event types for AWS Codebuild and AWS CodePipeline
     */
    addEvents(events) {
        events.forEach((event) => {
            if (this.events.includes(event)) {
                return;
            }
            this.events.push(event);
        });
    }
}
exports.NotificationRule = NotificationRule;
_a = JSII_RTTI_SYMBOL_1;
NotificationRule[_a] = { fqn: "@aws-cdk/aws-codestarnotifications.NotificationRule", version: "1.138.2" };
//# sourceMappingURL=data:application/json;base64,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