/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.map;

import com.datapps.linkoopdb.jdbc.lib.ArrayUtil;

public class BitMap {
    private boolean canChangeSize;
    private int initialSize;
    private int[] map;
    private int limitPos;

    public BitMap(int size, boolean extend) {
        int words = size / 32;
        if (size == 0 || size % 32 != 0) {
            ++words;
        }
        this.map = new int[words];
        this.canChangeSize = extend;
        this.limitPos = size;
        this.initialSize = size;
    }

    public BitMap(int[] map) {
        this.map = map;
        this.limitPos = this.initialSize = map.length * 32;
        this.canChangeSize = false;
    }

    public static int countSetBitsEnd(int map) {
        int count;
        int mask = 1;
        for (count = 0; count < 32 && (map & mask) != 0; ++count) {
            map >>= 1;
        }
        return count;
    }

    public static int countUnsetBitsStart(int map) {
        int count;
        int mask = Integer.MIN_VALUE;
        if (map == 0) {
            return 32;
        }
        for (count = 0; count < 32 && (map & mask) == 0; ++count) {
            mask >>>= 1;
        }
        return count;
    }

    public static int setByte(int map, byte value, int pos) {
        int intValue = (value & 0xFF) << 24 - pos;
        int mask = -16777216 >>> pos;
        return (map &= (mask ^= 0xFFFFFFFF)) | intValue;
    }

    public static int set(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return map | mask;
    }

    public static byte set(byte map, int pos) {
        int mask = 128 >>> pos;
        return (byte)(map | mask);
    }

    public static int unset(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return map & (mask ^= 0xFFFFFFFF);
    }

    public static boolean isSet(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return (map & mask) != 0;
    }

    public static boolean isSet(byte map, int pos) {
        int mask = 128 >>> pos;
        return (map & mask) != 0;
    }

    public static boolean isSet(byte[] map, int pos) {
        int mask = 128 >>> (pos & 7);
        int index = pos / 8;
        if (index >= map.length) {
            return false;
        }
        byte b = map[index];
        return (b & mask) != 0;
    }

    public static void unset(byte[] map, int pos) {
        int mask = 128 >>> (pos & 7);
        mask ^= 0xFFFFFFFF;
        int index = pos / 8;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        map[index] = (byte)(b & mask);
    }

    public static void set(byte[] map, int pos) {
        int mask = 128 >>> (pos & 7);
        int index = pos / 8;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        map[index] = (byte)(b | mask);
    }

    public static void and(byte[] map, int pos, byte source, int count) {
        int shift = pos & 7;
        int mask = (source & 0xFF) >>> shift;
        int innermask = 255 >> shift;
        int index = pos / 8;
        if (count < 8) {
            innermask >>>= 8 - count;
            innermask <<= 8 - count;
        }
        mask &= innermask;
        innermask ^= 0xFFFFFFFF;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        map[index] = (byte)(b & innermask);
        b = (byte)(b & mask);
        map[index] = (byte)(map[index] | b);
        if (shift == 0) {
            return;
        }
        if (count > (shift = 8 - shift)) {
            mask = (source & 0xFF) << 8 >>> shift;
            innermask = 65280 >>> shift;
            b = map[index + 1];
            map[index + 1] = (byte)(b & (innermask ^= 0xFFFFFFFF));
            b = (byte)(b & mask);
            map[index + 1] = (byte)(map[index + 1] | b);
        }
    }

    public static void or(byte[] map, int pos, byte source, int count) {
        byte b;
        int shift = pos & 7;
        int mask = (source & 0xFF) >>> shift;
        int index = pos / 8;
        if (index >= map.length) {
            return;
        }
        map[index] = b = (byte)(map[index] | mask);
        if (shift == 0) {
            return;
        }
        if (count > (shift = 8 - shift)) {
            mask = (source & 0xFF) << 8 >>> shift;
            map[index + 1] = b = (byte)(map[index + 1] | mask);
        }
    }

    public static void overlay(byte[] map, int pos, byte source, int count) {
        int shift = pos & 7;
        int mask = (source & 0xFF) >>> shift;
        int innermask = 255 >> shift;
        int index = pos / 8;
        if (count < 8) {
            innermask >>>= 8 - count;
            innermask <<= 8 - count;
        }
        mask &= innermask;
        innermask ^= 0xFFFFFFFF;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        b = (byte)(b & innermask);
        map[index] = (byte)(b | mask);
        if (shift == 0) {
            return;
        }
        if (count > (shift = 8 - shift)) {
            mask = (source & 0xFF) << 8 >>> shift;
            innermask = 65280 >>> shift;
            b = map[index + 1];
            b = (byte)(b & (innermask ^= 0xFFFFFFFF));
            map[index + 1] = (byte)(b | mask);
        }
    }

    public static byte[] and(byte[] a, byte[] b) {
        int length = a.length > b.length ? a.length : b.length;
        int shortLength = a.length > b.length ? b.length : a.length;
        byte[] map = new byte[length];
        for (int i = 0; i < shortLength; ++i) {
            map[i] = (byte)(a[i] & b[i]);
        }
        return map;
    }

    public static byte[] or(byte[] a, byte[] b) {
        int length = a.length > b.length ? a.length : b.length;
        int shortLength = a.length > b.length ? b.length : a.length;
        byte[] map = new byte[length];
        if (length != shortLength) {
            byte[] source = a.length > b.length ? a : b;
            System.arraycopy(source, shortLength, map, shortLength, length - shortLength);
        }
        for (int i = 0; i < shortLength; ++i) {
            map[i] = (byte)(a[i] | b[i]);
        }
        return map;
    }

    public static byte[] xor(byte[] a, byte[] b) {
        int length = a.length > b.length ? a.length : b.length;
        int shortLength = a.length > b.length ? b.length : a.length;
        byte[] map = new byte[length];
        if (length != shortLength) {
            byte[] source = a.length > b.length ? a : b;
            System.arraycopy(source, shortLength, map, shortLength, length - shortLength);
        }
        for (int i = 0; i < shortLength; ++i) {
            map[i] = (byte)(a[i] ^ b[i]);
        }
        return map;
    }

    public static byte[] not(byte[] a) {
        byte[] map = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            map[i] = ~a[i];
        }
        return map;
    }

    public static boolean hasAnyBitSet(byte[] map) {
        for (int i = 0; i < map.length; ++i) {
            if (map[i] == 0) continue;
            return true;
        }
        return false;
    }

    public static byte[] leftShift(byte[] map, int shiftBits) {
        byte[] newMap = new byte[map.length];
        int shiftBytes = shiftBits / 8;
        if (shiftBytes >= map.length) {
            return newMap;
        }
        if ((shiftBits %= 8) == 0) {
            int i = 0;
            for (int j = shiftBytes; j < map.length; ++j) {
                newMap[i] = map[j];
                ++i;
            }
        } else {
            int i = 0;
            for (int j = shiftBytes; j < map.length; ++j) {
                int shifted = (map[j] & 0xFF) << shiftBits;
                newMap[i] = (byte)shifted;
                if (i > 0) {
                    int n = i - 1;
                    newMap[n] = (byte)(newMap[n] | (byte)(shifted >>> 8));
                }
                ++i;
            }
        }
        return newMap;
    }

    public BitMap duplicate() {
        BitMap newMap = new BitMap((int[])ArrayUtil.duplicateArray(this.map));
        newMap.canChangeSize = this.canChangeSize;
        newMap.initialSize = this.initialSize;
        newMap.limitPos = this.limitPos;
        return newMap;
    }

    public int size() {
        return this.limitPos;
    }

    public void setSize(int newSize) {
        if (!this.canChangeSize) {
            throw new UnsupportedOperationException("BitMap");
        }
        this.ensureCapacity(newSize);
        if (this.limitPos > newSize) {
            this.unsetRange(newSize, this.limitPos - newSize);
            this.limitPos = newSize;
        }
    }

    public void reset() {
        for (int i = 0; i < this.map.length; ++i) {
            this.map[i] = 0;
        }
        this.limitPos = this.initialSize;
    }

    public int countSetMatches(BitMap other) {
        int matchCount = 0;
        for (int i = 0; i < this.map.length; ++i) {
            int matches = this.map[i] & other.map[i];
            if (matches == 0) continue;
            matchCount += Integer.bitCount(matches);
        }
        return matchCount;
    }

    public int setRange(int pos, int count) {
        return this.setOrUnsetRange(pos, count, true);
    }

    public int unsetRange(int pos, int count) {
        return this.setOrUnsetRange(pos, count, false);
    }

    private int setOrUnsetRange(int pos, int count, boolean set) {
        if (count == 0) {
            return 0;
        }
        this.ensureCapacity(pos + count);
        int windex = pos >> 5;
        int windexend = pos + count - 1 >> 5;
        int mask = -1 >>> (pos & 0x1F);
        int maskend = Integer.MIN_VALUE >> (pos + count - 1 & 0x1F);
        if (windex == windexend) {
            mask &= maskend;
        }
        int word = this.map[windex];
        int setCount = Integer.bitCount(word & mask);
        this.map[windex] = set ? word | mask : word & (mask ^= 0xFFFFFFFF);
        if (windex != windexend) {
            word = this.map[windexend];
            setCount += Integer.bitCount(word & maskend);
            this.map[windexend] = set ? word | maskend : word & (maskend ^= 0xFFFFFFFF);
            for (int i = windex + 1; i < windexend; ++i) {
                setCount += Integer.bitCount(this.map[i]);
                this.map[i] = set ? -1 : 0;
            }
        }
        return set ? count - setCount : setCount;
    }

    public int setValue(int pos, boolean set) {
        return set ? this.set(pos) : this.unset(pos);
    }

    public int set(int pos) {
        this.ensureCapacity(pos + 1);
        int windex = pos >> 5;
        int mask = Integer.MIN_VALUE >>> (pos & 0x1F);
        int word = this.map[windex];
        int result = (word & mask) == 0 ? 0 : 1;
        this.map[windex] = word | mask;
        return result;
    }

    public int unset(int pos) {
        this.ensureCapacity(pos + 1);
        int windex = pos >> 5;
        int mask = Integer.MIN_VALUE >>> (pos & 0x1F);
        int word = this.map[windex];
        int result = (word & mask) == 0 ? 0 : 1;
        this.map[windex] = word & (mask ^= 0xFFFFFFFF);
        return result;
    }

    public int get(int pos) {
        if (pos >= this.limitPos) {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
        int windex = pos >> 5;
        int word = this.map[windex];
        int mask = Integer.MIN_VALUE >>> (pos & 0x1F);
        return (word & mask) == 0 ? 0 : 1;
    }

    public boolean isSet(int pos) {
        return this.get(pos) == 1;
    }

    public void set(BitMap other) {
        int windex = 0;
        while (windex < this.map.length) {
            int word = other.map[windex];
            int n = windex++;
            this.map[n] = this.map[n] | word;
        }
    }

    public int countSet(int pos, int count) {
        int set = 0;
        for (int i = pos; i < pos + count; ++i) {
            if (!this.isSet(i)) continue;
            ++set;
        }
        return set;
    }

    public int countSetBits() {
        int word;
        int setCount = 0;
        for (int windex = 0; windex < this.limitPos / 32; ++windex) {
            word = this.map[windex];
            if (word == 0) continue;
            if (word == -1) {
                setCount += 32;
                continue;
            }
            setCount += Integer.bitCount(word);
        }
        if (this.limitPos % 32 != 0) {
            int maskend = Integer.MIN_VALUE >> (this.limitPos - 1 & 0x1F);
            word = this.map[this.limitPos / 32] & maskend;
            setCount += Integer.bitCount(word);
        }
        return setCount;
    }

    public int countSetBitsEnd() {
        int count = 0;
        for (int windex = this.limitPos / 32 - 1; windex >= 0; --windex) {
            if (this.map[windex] == -1) {
                count += 32;
                continue;
            }
            int val = BitMap.countSetBitsEnd(this.map[windex]);
            count += val;
            break;
        }
        return count;
    }

    public int[] getIntArray() {
        return this.map;
    }

    public byte[] getBytes() {
        byte[] buf = new byte[(this.limitPos + 7) / 8];
        if (buf.length == 0) {
            return buf;
        }
        int i = 0;
        do {
            int v = this.map[i / 4];
            buf[i++] = (byte)(v >>> 24);
            if (i == buf.length) break;
            buf[i++] = (byte)(v >>> 16);
            if (i == buf.length) break;
            buf[i++] = (byte)(v >>> 8);
            if (i == buf.length) break;
            buf[i++] = (byte)v;
        } while (i != buf.length);
        return buf;
    }

    private void ensureCapacity(int newSize) {
        if (newSize > this.limitPos && !this.canChangeSize) {
            throw new ArrayStoreException("BitMap extend");
        }
        if (newSize <= this.map.length * 32) {
            if (newSize > this.limitPos) {
                this.limitPos = newSize;
            }
            return;
        }
        int newMapLength = this.map.length;
        while (newSize > newMapLength * 32) {
            newMapLength *= 2;
        }
        int[] newmap = new int[newMapLength];
        System.arraycopy(this.map, 0, newmap, 0, this.map.length);
        this.map = newmap;
        this.limitPos = newSize;
    }
}

