# generated by datamodel-codegen:
#   filename:  engMeta.json
#   timestamp: 2022-01-19T15:30:28+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from easyDataverse.core import DataverseBase
from pydantic import Field


class DataGeneration(Enum):
    """
    Approach to data generation
    """

    simulation = 'Simulation'
    analysis = 'Analysis'
    experiment = 'Experiment'
    prediction = 'Prediction'


class SpatialResolution(DataverseBase):
    number_of_cells: Optional[int] = Field(
        None,
        description='The number of 2D spatial cells.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterCountCells',
    )
    number_of_blocks: Optional[int] = Field(
        None,
        description='The number of 3D spatial blocks.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterCountBlocks',
    )
    number_of_points_x: Optional[int] = Field(
        None,
        description='The number of points in x-direction.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterCountX',
    )
    number_of_points_y: Optional[int] = Field(
        None,
        description='The number of points in y-direction.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterCountY',
    )
    number_of_points_z: Optional[int] = Field(
        None,
        description='The number of points in z-direction.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterCountZ',
    )
    interval_x: Optional[float] = Field(
        None,
        description='The distance between the points in x-direction.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterIntervalX',
    )
    interval_y: Optional[float] = Field(
        None,
        description='The distance between the points in y-direction.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterIntervalY',
    )
    interval_z: Optional[float] = Field(
        None,
        description='The distance between the points in z-direction.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterIntervalZ',
    )
    unit: Optional[str] = Field(
        None,
        description='The unit of the grid.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterUnit',
    )
    scaling_formular: Optional[str] = Field(
        None,
        description='If the grid is not equidistant, the distance between points can be specified via a formular.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaGitterScalingFormular',
    )


class ControlledVariables(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of this variable.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaControlledVarName',
    )
    symbol: Optional[str] = Field(
        None,
        description='The symbol used to describe this variable.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaControlledVarSymbol',
    )
    unit: Optional[str] = Field(
        None,
        description='The unit or scale of this variable.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaControlledVarUnit',
    )
    value: Optional[float] = Field(
        None,
        description='The (single) value of this variable.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaControlledVarValue',
    )
    minimum_value: Optional[float] = Field(
        None,
        description='The minimum value of this variable (use for ranges)',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaControlledVarValueFrom',
    )
    maximum_value: Optional[float] = Field(
        None,
        description='The maximum value of this variable  (use for ranges)',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaControlledVarValueTo',
    )
    textual_value: Optional[str] = Field(
        None,
        description='The value of this controlled variable (for non numerical values).',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaControlledVarTextValue',
    )


class MeasuredVariables(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of this variable.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaMeasuredVarName',
    )
    symbol: Optional[str] = Field(
        None,
        description='The symbol used to describe this variable.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaMeasuredVarSymbol',
    )
    unit: Optional[str] = Field(
        None,
        description='The unit or scale of this variable.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaMeasuredVarUnit',
    )
    error: Optional[float] = Field(
        None,
        description='A value for the uncertainty of this variable.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaMeasuredVarError',
    )
    error_description: Optional[str] = Field(
        None,
        description='The type the error is measured (e.g. standard deviation, percentage, …)',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaMeasuredVarErrorDesc',
    )
    minimum_value: Optional[float] = Field(
        None,
        description='The minimum value of this variable (use for ranges)',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaMeasuredVarValueFrom',
    )
    maximum_value: Optional[float] = Field(
        None,
        description='The maximum value of this variable (use for ranges)',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaMeasuredVarValueTo',
    )
    textual_value: Optional[str] = Field(
        None,
        description='The value of this measured variable (for non numerical values).',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaMeasuredVarTextValue',
    )


class ForceFieldParameters(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of the parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaForcefieldParName',
    )
    symbol: Optional[str] = Field(
        None,
        description='The symbol used to describe this parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaForcefieldParSymbol',
    )
    unit: Optional[str] = Field(
        None,
        description='The unit or scale of this parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaForcefieldParUnit',
    )
    value: Optional[float] = Field(
        None,
        description='The value of this parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaForcefieldParValue',
    )


class TemporalResolution(DataverseBase):
    points: Optional[str] = Field(
        None,
        description='List of time points that describe the temporal resolution (if it can not be specified otherwise).',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaTempPoints',
    )
    number_of_time_steps: Optional[int] = Field(
        None,
        description='The number of time points (with equidistant distance).',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaTempCountPoints',
    )
    interval: Optional[float] = Field(
        None,
        description='Distance between two time points.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaTempInterval',
    )
    unit: Optional[str] = Field(
        None,
        description='The unit of the temporal resolution.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaTempUnit',
    )


class BoundaryParameters(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of the parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaBoundCondParName',
    )
    symbol: Optional[str] = Field(
        None,
        description='The symbol used to describe this parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaBoundCondParSymbol',
    )
    unit: Optional[str] = Field(
        None,
        description='The unit or scale of this parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaBoundCondParUnit',
    )
    value: Optional[float] = Field(
        None,
        description='The value of this parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaBoundCondParValue',
    )


class ForceField(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of the force field.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaForcefieldName',
    )
    parameters: Optional[str] = Field(
        None,
        description='List of all parameter names relevant for this force field (detailed information about parameters should be given under Force Field Parameters entry).',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaForcefieldPars',
    )


class BoundaryConditions(DataverseBase):
    flows: Optional[str] = Field(
        None,
        description='List of in- and outflows describing this boundary condition (detailed information about flows should be given under Flows).',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaBoundCondFlows',
    )
    parameters: Optional[str] = Field(
        None,
        description='List of all parameter names relevant for this boundary condition (detailed information about parameters should be given under Boundary Parameters.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaBoundCondPars',
    )


class SystemPhases(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of a phase.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaPhaseName',
    )
    components: Optional[str] = Field(
        None,
        description='List of all component names for this phase (detailed information about components should be given under System Components).',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaPhaseComps',
    )


class Flows(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of the flow.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaFlowsName',
    )
    components: Optional[str] = Field(
        None,
        description='List of system component names this flow belongs to.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaFlowsComp',
    )
    shape: Optional[str] = Field(
        None,
        description='Shape of the flow.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaFlowsShape',
    )
    size: Optional[float] = Field(
        None,
        description='Size of the flow.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaFlowsSize',
    )
    position: Optional[str] = Field(
        None,
        description='The position of the flow.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaFlowsPosition',
    )


class SystemOrPhaseComponents(DataverseBase):
    id: Optional[int] = Field(
        None,
        description='Unique number that can be referred to in the metadata. Use if Name is not unique.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaCompId',
    )
    name: Optional[str] = Field(
        None,
        description='Name of this component.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaCompName',
    )
    description: Optional[str] = Field(
        None,
        description='Description of the component.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaCompDescription',
    )
    inchicode: Optional[str] = Field(
        None,
        description='The IUPAC International Chemical Identifier',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaCompInChI',
    )
    smilescode: Optional[str] = Field(
        None,
        description='Simplified Molecular Input Line Entry Specification',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaCompSmilesCode',
    )
    iupac_name: Optional[str] = Field(
        None,
        description='Chemical nomenclature created and developed by the International Union of Pure and Applied Chemistry (IUPAC)',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaCompIUPAC',
    )
    quantity: Optional[str] = Field(
        None,
        description='The amount of this component.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaCompQuantity',
    )
    unit: Optional[str] = Field(
        None,
        description='The unit in which the amount is measured.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaCompUnit',
    )
    force_field: Optional[str] = Field(
        None,
        description='Name of the force field belonging to this component (detailed information about the force field should be given under Force Field Parameters).',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaCompForcefield',
    )


class SystemParameters(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of the parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaSystemParName',
    )
    symbol: Optional[str] = Field(
        None,
        description='The symbol used to describe this parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaSystemParSymbol',
    )
    unit: Optional[str] = Field(
        None,
        description='The unit or scale of this parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaSystemParUnit',
    )
    value: Optional[float] = Field(
        None,
        description='The (numerical) value of this parameter.',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaSystemParValue',
    )
    textual_value: Optional[str] = Field(
        None,
        description='The value of this system parameter (for non numerical values).',
        multiple=False,
        typeClass='primitive',
        typeName='engMetaSystemParTextValue',
    )


class EngMeta(DataverseBase):
    data_generation: Optional[Union[list, DataGeneration]] = Field(
        None,
        description='Approach to data generation',
        multiple=True,
        typeClass='controlledVocabulary',
        typeName='engMetaMode',
    )
    spatial_resolution: list[SpatialResolution] = Field(
        default_factory=list,
        description='Specification of the spatial grid of the observation.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaGitter',
    )
    controlled_variables: list[ControlledVariables] = Field(
        default_factory=list,
        description='Specification of controlled (observed / independent) variables.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaControlledVar',
    )
    measured_variables: list[MeasuredVariables] = Field(
        default_factory=list,
        description='Specification of captured (measured / simulated / surveyed / dependent) variables.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaMeasuredVar',
    )
    force_field_parameters: list[ForceFieldParameters] = Field(
        default_factory=list,
        description='Specification of a force field parameter.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaForcefieldPar',
    )
    temporal_resolution: list[TemporalResolution] = Field(
        default_factory=list,
        description='Temporal resolution of the observation. Can be defined either through a number of time steps with a definition of the intervals (with unit) between the timesteps (equidistant time steps) or a series of time steps together with the unit.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaTemp',
    )
    boundary_parameters: list[BoundaryParameters] = Field(
        default_factory=list,
        description='Parameters relevant for boundary conditions.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaBoundCondPar',
    )
    force_field: list[ForceField] = Field(
        default_factory=list,
        description='Specification of a force field',
        multiple=True,
        typeClass='compound',
        typeName='engMetaForcefield',
    )
    boundary_conditions: list[BoundaryConditions] = Field(
        default_factory=list,
        description='Definition of boundaries of the observed system.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaBoundCond',
    )
    system_phases: list[SystemPhases] = Field(
        default_factory=list,
        description='Phases of the observed system.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaPhase',
    )
    flows: list[Flows] = Field(
        default_factory=list,
        description='Information about in- and outflows relevant for boundary conditions.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaFlows',
    )
    system_or_phase_components: list[SystemOrPhaseComponents] = Field(
        default_factory=list,
        description='Specification of a component of the object of research / observed system',
        multiple=True,
        typeClass='compound',
        typeName='engMetaComp',
    )
    system_parameters: list[SystemParameters] = Field(
        default_factory=list,
        description='Parameters of the observed system.',
        multiple=True,
        typeClass='compound',
        typeName='engMetaSystemPar',
    )
    _metadatablock_name: Optional[str] = 'engMeta'


    def add_boundary_conditions(
        self,
        flows: Optional[str] = None,
        parameters: Optional[str] = None,
    ):
        """Function used to add an instance of BoundaryConditions to the metadatablock.

        Args:
        
            flows (string): List of in- and outflows describing this boundary condition (detailed information about flows should be given under Flows).
            parameters (string): List of all parameter names relevant for this boundary condition (detailed information about parameters should be given under Boundary Parameters.

        """

        self.boundary_conditions.append(
            BoundaryConditions(
                flows=flows, parameters=parameters
            )
        )


    def add_boundary_parameters(
        self,
        name: Optional[str] = None,
        symbol: Optional[str] = None,
        unit: Optional[str] = None,
        value: Optional[float] = None,
    ):
        """Function used to add an instance of BoundaryParameters to the metadatablock.

        Args:
        
            name (string): Name of the parameter.
            symbol (string): The symbol used to describe this parameter.
            unit (string): The unit or scale of this parameter.
            value (number): The value of this parameter.

        """

        self.boundary_parameters.append(
            BoundaryParameters(
                name=name, symbol=symbol, unit=unit, value=value
            )
        )


    def add_controlled_variables(
        self,
        name: Optional[str] = None,
        symbol: Optional[str] = None,
        unit: Optional[str] = None,
        value: Optional[float] = None,
        minimum_value: Optional[float] = None,
        maximum_value: Optional[float] = None,
        textual_value: Optional[str] = None,
    ):
        """Function used to add an instance of ControlledVariables to the metadatablock.

        Args:
        
            name (string): Name of this variable.
            symbol (string): The symbol used to describe this variable.
            unit (string): The unit or scale of this variable.
            value (number): The (single) value of this variable.
            minimum_value (number): The minimum value of this variable (use for ranges)
            maximum_value (number): The maximum value of this variable  (use for ranges)
            textual_value (string): The value of this controlled variable (for non numerical values).

        """

        self.controlled_variables.append(
            ControlledVariables(
                name=name, symbol=symbol, unit=unit, value=value, minimum_value=minimum_value, maximum_value=maximum_value, textual_value=textual_value
            )
        )


    def add_flows(
        self,
        name: Optional[str] = None,
        components: Optional[str] = None,
        shape: Optional[str] = None,
        size: Optional[float] = None,
        position: Optional[str] = None,
    ):
        """Function used to add an instance of Flows to the metadatablock.

        Args:
        
            name (string): Name of the flow.
            components (string): List of system component names this flow belongs to.
            shape (string): Shape of the flow.
            size (number): Size of the flow.
            position (string): The position of the flow.

        """

        self.flows.append(
            Flows(
                name=name, components=components, shape=shape, size=size, position=position
            )
        )


    def add_force_field(
        self,
        name: Optional[str] = None,
        parameters: Optional[str] = None,
    ):
        """Function used to add an instance of ForceField to the metadatablock.

        Args:
        
            name (string): Name of the force field.
            parameters (string): List of all parameter names relevant for this force field (detailed information about parameters should be given under Force Field Parameters entry).

        """

        self.force_field.append(
            ForceField(
                name=name, parameters=parameters
            )
        )


    def add_force_field_parameters(
        self,
        name: Optional[str] = None,
        symbol: Optional[str] = None,
        unit: Optional[str] = None,
        value: Optional[float] = None,
    ):
        """Function used to add an instance of ForceFieldParameters to the metadatablock.

        Args:
        
            name (string): Name of the parameter.
            symbol (string): The symbol used to describe this parameter.
            unit (string): The unit or scale of this parameter.
            value (number): The value of this parameter.

        """

        self.force_field_parameters.append(
            ForceFieldParameters(
                name=name, symbol=symbol, unit=unit, value=value
            )
        )


    def add_measured_variables(
        self,
        name: Optional[str] = None,
        symbol: Optional[str] = None,
        unit: Optional[str] = None,
        error: Optional[float] = None,
        error_description: Optional[str] = None,
        minimum_value: Optional[float] = None,
        maximum_value: Optional[float] = None,
        textual_value: Optional[str] = None,
    ):
        """Function used to add an instance of MeasuredVariables to the metadatablock.

        Args:
        
            name (string): Name of this variable.
            symbol (string): The symbol used to describe this variable.
            unit (string): The unit or scale of this variable.
            error (number): A value for the uncertainty of this variable.
            error_description (string): The type the error is measured (e.g. standard deviation, percentage, …)
            minimum_value (number): The minimum value of this variable (use for ranges)
            maximum_value (number): The maximum value of this variable (use for ranges)
            textual_value (string): The value of this measured variable (for non numerical values).

        """

        self.measured_variables.append(
            MeasuredVariables(
                name=name, symbol=symbol, unit=unit, error=error, error_description=error_description, minimum_value=minimum_value, maximum_value=maximum_value, textual_value=textual_value
            )
        )


    def add_spatial_resolution(
        self,
        number_of_cells: Optional[int] = None,
        number_of_blocks: Optional[int] = None,
        number_of_points_x: Optional[int] = None,
        number_of_points_y: Optional[int] = None,
        number_of_points_z: Optional[int] = None,
        interval_x: Optional[float] = None,
        interval_y: Optional[float] = None,
        interval_z: Optional[float] = None,
        unit: Optional[str] = None,
        scaling_formular: Optional[str] = None,
    ):
        """Function used to add an instance of SpatialResolution to the metadatablock.

        Args:
        
            number_of_cells (integer): The number of 2D spatial cells.
            number_of_blocks (integer): The number of 3D spatial blocks.
            number_of_points_x (integer): The number of points in x-direction.
            number_of_points_y (integer): The number of points in y-direction.
            number_of_points_z (integer): The number of points in z-direction.
            interval_x (number): The distance between the points in x-direction.
            interval_y (number): The distance between the points in y-direction.
            interval_z (number): The distance between the points in z-direction.
            unit (string): The unit of the grid.
            scaling_formular (string): If the grid is not equidistant, the distance between points can be specified via a formular.

        """

        self.spatial_resolution.append(
            SpatialResolution(
                number_of_cells=number_of_cells, number_of_blocks=number_of_blocks, number_of_points_x=number_of_points_x, number_of_points_y=number_of_points_y, number_of_points_z=number_of_points_z, interval_x=interval_x, interval_y=interval_y, interval_z=interval_z, unit=unit, scaling_formular=scaling_formular
            )
        )


    def add_system_or_phase_components(
        self,
        id: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        inchicode: Optional[str] = None,
        smilescode: Optional[str] = None,
        iupac_name: Optional[str] = None,
        quantity: Optional[str] = None,
        unit: Optional[str] = None,
        force_field: Optional[str] = None,
    ):
        """Function used to add an instance of SystemOrPhaseComponents to the metadatablock.

        Args:
        
            id (integer): Unique number that can be referred to in the metadata. Use if Name is not unique.
            name (string): Name of this component.
            description (string): Description of the component.
            inchicode (string): The IUPAC International Chemical Identifier
            smilescode (string): Simplified Molecular Input Line Entry Specification
            iupac_name (string): Chemical nomenclature created and developed by the International Union of Pure and Applied Chemistry (IUPAC)
            quantity (string): The amount of this component.
            unit (string): The unit in which the amount is measured.
            force_field (string): Name of the force field belonging to this component (detailed information about the force field should be given under Force Field Parameters).

        """

        self.system_or_phase_components.append(
            SystemOrPhaseComponents(
                id=id, name=name, description=description, inchicode=inchicode, smilescode=smilescode, iupac_name=iupac_name, quantity=quantity, unit=unit, force_field=force_field
            )
        )


    def add_system_parameters(
        self,
        name: Optional[str] = None,
        symbol: Optional[str] = None,
        unit: Optional[str] = None,
        value: Optional[float] = None,
        textual_value: Optional[str] = None,
    ):
        """Function used to add an instance of SystemParameters to the metadatablock.

        Args:
        
            name (string): Name of the parameter.
            symbol (string): The symbol used to describe this parameter.
            unit (string): The unit or scale of this parameter.
            value (number): The (numerical) value of this parameter.
            textual_value (string): The value of this system parameter (for non numerical values).

        """

        self.system_parameters.append(
            SystemParameters(
                name=name, symbol=symbol, unit=unit, value=value, textual_value=textual_value
            )
        )


    def add_system_phases(
        self,
        name: Optional[str] = None,
        components: Optional[str] = None,
    ):
        """Function used to add an instance of SystemPhases to the metadatablock.

        Args:
        
            name (string): Name of a phase.
            components (string): List of all component names for this phase (detailed information about components should be given under System Components).

        """

        self.system_phases.append(
            SystemPhases(
                name=name, components=components
            )
        )


    def add_temporal_resolution(
        self,
        points: Optional[str] = None,
        number_of_time_steps: Optional[int] = None,
        interval: Optional[float] = None,
        unit: Optional[str] = None,
    ):
        """Function used to add an instance of TemporalResolution to the metadatablock.

        Args:
        
            points (string): List of time points that describe the temporal resolution (if it can not be specified otherwise).
            number_of_time_steps (integer): The number of time points (with equidistant distance).
            interval (number): Distance between two time points.
            unit (string): The unit of the temporal resolution.

        """

        self.temporal_resolution.append(
            TemporalResolution(
                points=points, number_of_time_steps=number_of_time_steps, interval=interval, unit=unit
            )
        )
