class Color:
    def __init__(self, hex:str = None, rgb:tuple = None) -> None:    
        self.hex = hex
        self.rgb = rgb

def hex2rgb(hex:str) -> tuple:
    r = int(hex[1:3], 16)
    g = int(hex[3:5], 16)
    b = int(hex[5:7], 16)

    return (r,g,b)

def rgb2hex(rgb:tuple) -> str:
    r, g, b = rgb
    return f"#{hex(r)}{hex(g)}{hex(b)}"


RED = Color('#FF0000', (255, 0, 0))
WHITE = Color('#FFFFFF', (255, 255, 255))
CYAN = Color('#00FFFF', (0, 255, 255))
SILVER = Color('#C0C0C0', (192, 192, 192))
BLUE = Color('#0000FF', (0, 0, 255))
GREY = Color('#808080', (128, 128, 128))
DARKBLUE = Color('#00008B', (0, 0, 139))
BLACK = Color('#000000', (0, 0, 0))
LIGHTBLUE = Color('#ADD8E6', (173, 216, 230))
ORANGE = Color('#FFA500', (255, 165, 0))
PURPLE = Color('#800080', (128, 0, 128))
BROWN = Color('#A52A2A', (165, 42, 42))
YELLOW = Color('#FFFF00', (255, 255, 0))
MAROON = Color('#800000', (128, 0, 0))
LIME = Color('#00FF00', (0, 255, 0))
GREEN = Color('#008000', (0, 128, 0))
MAGENTA = Color('#FF00FF', (255, 0, 255))
OLIVE = Color('#808000', (128, 128, 0))
PINK = Color('#FFC0CB', (255, 192, 203))
AQUAMARINE = Color('#7FFD4', (127, 253, 4))
NIGHT = Color('#0C090A', (12, 9, 10))
CHARCOAL = Color('#34282C', (52, 40, 44))
OIL = Color('#3B3131', (59, 49, 49))
DARK_GRAY = Color('#3A3B3C', (58, 59, 60))
LIGHT_BLACK = Color('#454545', (69, 69, 69))
BLACK_CAT = Color('#413839', (65, 56, 57))
IRIDIUM = Color('#3D3C3A', (61, 60, 58))
BLACK_EEL = Color('#463E3F', (70, 62, 63))
BLACK_COW = Color('#4C4646', (76, 70, 70))
GRAY_WOLF = Color('#504A4B', (80, 74, 75))
VAMPIRE_GRAY = Color('#565051', (86, 80, 81))
IRON_GRAY = Color('#52595D', (82, 89, 93))
GRAY_DOLPHIN = Color('#5C5858', (92, 88, 88))
CARBON_GRAY = Color('#625D5D', (98, 93, 93))
ASH_GRAY = Color('#666362', (102, 99, 98))
NARDO_GRAY = Color('#686A6C', (104, 106, 108))
CLOUDY_GRAY = Color('#6D6968', (109, 105, 104))
SMOKEY_GRAY = Color('#726E6D', (114, 110, 109))
ALIEN_GRAY = Color('#736F6E', (115, 111, 110))
SONIC_SILVER = Color('#757575', (117, 117, 117))
PLATINUM_GRAY = Color('#797979', (121, 121, 121))
GRANITE = Color('#837E7C', (131, 126, 124))
BATTLESHIP_GRAY = Color('#848482', (132, 132, 130))
GUNMETAL_GRAY = Color('#8D918D', (141, 145, 141))
GRAY_CLOUD = Color('#B6B6B4', (182, 182, 180))
PALE_SILVER = Color('#C9C0BB', (201, 192, 187))
GRAY_GOOSE = Color('#D1D0CE', (209, 208, 206))
PLATINUM_SILVER = Color('#CECECE', (206, 206, 206))
PLATINUM = Color('#E5E4E2', (229, 228, 226))
METALLIC_SILVER = Color('#BCC6CC', (188, 198, 204))
BLUE_GRAY = Color('#98AFC7', (152, 175, 199))
ROMAN_SILVER = Color('#838996', (131, 137, 150))
RAT_GRAY = Color('#6D7B8D', (109, 123, 141))
SLATE_GRANITE_GRAY = Color('#657383', (101, 115, 131))
JET_GRAY = Color('#616D7E', (97, 109, 126))
MIST_BLUE = Color('#646D7E', (100, 109, 126))
MARBLE_BLUE = Color('#566D7E', (86, 109, 126))
SLATE_BLUE_GREY = Color('#737CA1', (115, 124, 161))
LIGHT_PURPLE_BLUE = Color('#728FCE', (114, 143, 206))
AZURE_BLUE = Color('#4863A0', (72, 99, 160))
BLUE_JAY = Color('#2B547E', (43, 84, 126))
CHARCOAL_BLUE = Color('#36454F', (54, 69, 79))
DARK_BLUE_GREY = Color('#29465B', (41, 70, 91))
DARK_SLATE = Color('#2B3856', (43, 56, 86))
DEEP_SEA_BLUE = Color('#123456', (18, 52, 86))
NIGHT_BLUE = Color('#151B54', (21, 27, 84))
DENIM_DARK_BLUE = Color('#151B8D', (21, 27, 141))
LAPIS_BLUE = Color('#15317E', (21, 49, 126))
NEW_MIDNIGHT_BLUE = Color('#0000A0', (0, 0, 160))
EARTH_BLUE = Color('#0000A5', (0, 0, 165))
COBALT_BLUE = Color('#0020C2', (0, 32, 194))
BLUEBERRY_BLUE = Color('#0041C2', (0, 65, 194))
CANARY_BLUE = Color('#2916F5', (41, 22, 245))
BRIGHT_BLUE = Color('#0909FF', (9, 9, 255))
BLUE_ORCHID = Color('#1F45FC', (31, 69, 252))
SAPPHIRE_BLUE = Color('#2554C7', (37, 84, 199))
BLUE_EYES = Color('#1569C7', (21, 105, 199))
BRIGHT_NAVY_BLUE = Color('#1974D2', (25, 116, 210))
BALLOON_BLUE = Color('#2B60DE', (43, 96, 222))
OCEAN_BLUE = Color('#2B65EC', (43, 101, 236))
BLUE_RIBBON = Color('#306EFF', (48, 110, 255))
BLUE_DRESS = Color('#157DEC', (21, 125, 236))
NEON_BLUE = Color('#1589FF', (21, 137, 255))
GLACIAL_BLUE_ICE = Color('#368BC1', (54, 139, 193))
SILK_BLUE = Color('#488AC7', (72, 138, 199))
WINDOWS_BLUE = Color('#357EC7', (53, 126, 199))
BLUE_IVY = Color('#3090C7', (48, 144, 199))
BLUE_KOI = Color('#659EC7', (101, 158, 199))
COLUMBIA_BLUE = Color('#87AFC7', (135, 175, 199))
BABY_BLUE = Color('#95B9C7', (149, 185, 199))
SKY_BLUE_DRESS = Color('#6698FF', (102, 152, 255))
ICEBERG = Color('#56A5EC', (86, 165, 236))
BUTTERFLY_BLUE = Color('#38ACEC', (56, 172, 236))
MIDDAY_BLUE = Color('#3BB9FF', (59, 185, 255))
CRYSTAL_BLUE = Color('#5CB3FF', (92, 179, 255))
DENIM_BLUE = Color('#79BAEC', (121, 186, 236))
DAY_SKY_BLUE = Color('#82CAFF', (130, 202, 255))
JEANS_BLUE = Color('#A0CFEC', (160, 207, 236))
BLUE_ANGEL = Color('#B7CEEC', (183, 206, 236))
PASTEL_BLUE = Color('#B4CFEC', (180, 207, 236))
LIGHT_DAY_BLUE = Color('#ADDFFF', (173, 223, 255))
SEA_BLUE = Color('#C2DFFF', (194, 223, 255))
HEAVENLY_BLUE = Color('#C6DEFF', (198, 222, 255))
ROBIN_EGG_BLUE = Color('#BDEDFF', (189, 237, 255))
CORAL_BLUE = Color('#AFDCEC', (175, 220, 236))
GULF_BLUE = Color('#C9DFEC', (201, 223, 236))
PASTEL_LIGHT_BLUE = Color('#D5D6EA', (213, 214, 234))
LAVENDER_BLUE = Color('#E3E4FA', (227, 228, 250))
WATER = Color('#EBF4FA', (235, 244, 250))
LIGHT_SLATE = Color('#CCFFFF', (204, 255, 255))
ELECTRIC_BLUE = Color('#9AFEFF', (154, 254, 255))
TRON_BLUE = Color('#7DFDFE', (125, 253, 254))
BLUE_ZIRCON = Color('#57FEFF', (87, 254, 255))
BRIGHT_CYAN = Color('#0AFFFF', (10, 255, 255))
CELESTE = Color('#50EBEC', (80, 235, 236))
BLUE_DIAMOND = Color('#4EE2EC', (78, 226, 236))
BRIGHT_TURQUOISE = Color('#16E2F5', (22, 226, 245))
BLUE_LAGOON = Color('#8EEBEC', (142, 235, 236))
PALE_BLUE_LILY = Color('#CFECEC', (207, 236, 236))
TIFFANY_BLUE = Color('#81D8D0', (129, 216, 208))
BLUE_HOSTA = Color('#77BFC7', (119, 191, 199))
CYAN_OPAQUE = Color('#92C7C7', (146, 199, 199))
NORTHERN_LIGHTS_BLUE = Color('#78C7C7', (120, 199, 199))
BLUE_GREEN = Color('#7BCCB5', (123, 204, 181))
MAGIC_MINT = Color('#AAF0D1', (170, 240, 209))
LIGHT_AQUAMARINE = Color('#93FFE8', (147, 255, 232))
DEEP_TURQUOISE = Color('#48CCCD', (72, 204, 205))
JELLYFISH = Color('#46C7C7', (70, 199, 199))
BLUE_TURQUOISE = Color('#43C6DB', (67, 198, 219))
MACAW_BLUE_GREEN = Color('#43BFC7', (67, 191, 199))
SEAFOAM_GREEN = Color('#3EA99F', (62, 169, 159))
DEEP_SEA = Color('#3B9C9C', (59, 156, 156))
MEDIUM_TEAL = Color('#045F5F', (4, 95, 95))
DEEP_TEAL = Color('#033E3E', (3, 62, 62))
GUNMETAL = Color('#2C3539', (44, 53, 57))
BLUE_MOSS_GREEN = Color('#3C565B', (60, 86, 91))
BEETLE_GREEN = Color('#4C787E', (76, 120, 126))
GRAYISH_TURQUOISE = Color('#5E7D7E', (94, 125, 126))
GREENISH_BLUE = Color('#307D7E', (48, 125, 126))
AQUAMARINE_STONE = Color('#348781', (52, 135, 129))
SEA_TURTLE_GREEN = Color('#438D80', (67, 141, 128))
DULL_SEA_GREEN = Color('#4E8975', (78, 137, 117))
DEEP_SEA_GREEN = Color('#306754', (48, 103, 84))
DARK_MINT = Color('#31906E', (49, 144, 110))
JADE = Color('#00A36C', (0, 163, 108))
EARTH_GREEN = Color('#34A56F', (52, 165, 111))
EMERALD = Color('#50C878', (80, 200, 120))
MINT = Color('#3EB489', (62, 180, 137))
CAMOUFLAGE_GREEN = Color('#78866B', (120, 134, 107))
SAGE_GREEN = Color('#848B79', (132, 139, 121))
HAZEL_GREEN = Color('#617C58', (97, 124, 88))
VENOM_GREEN = Color('#728C00', (114, 140, 0))
ARMY_GREEN = Color('#4B5320', (75, 83, 32))
FERN_GREEN = Color('#667C26', (102, 124, 38))
FALL_FOREST_GREEN = Color('#4E9258', (78, 146, 88))
PINE_GREEN = Color('#387C44', (56, 124, 68))
MEDIUM_FOREST_GREEN = Color('#347235', (52, 114, 53))
JUNGLE_GREEN = Color('#347C2C', (52, 124, 44))
DEEP_EMERALD_GREEN = Color('#046307', (4, 99, 7))
DARK_FOREST_GREEN = Color('#254117', (37, 65, 23))
SEAWEED_GREEN = Color('#437C17', (67, 124, 23))
SHAMROCK_GREEN = Color('#347C17', (52, 124, 23))
GREEN_ONION = Color('#6AA121', (106, 161, 33))
GREEN_PEPPER = Color('#4AA02C', (74, 160, 44))
DARK_LIME_GREEN = Color('#41A317', (65, 163, 23))
PARROT_GREEN = Color('#12AD2B', (18, 173, 43))
CLOVER_GREEN = Color('#3EA055', (62, 160, 85))
DINOSAUR_GREEN = Color('#73A16C', (115, 161, 108))
GREEN_SNAKE = Color('#6CBB3C', (108, 187, 60))
ALIEN_GREEN = Color('#6CC417', (108, 196, 23))
GREEN_APPLE = Color('#4CC417', (76, 196, 23))
PEA_GREEN = Color('#52D017', (82, 208, 23))
KELLY_GREEN = Color('#4CC552', (76, 197, 82))
ZOMBIE_GREEN = Color('#54C571', (84, 197, 113))
FROG_GREEN = Color('#99C68E', (153, 198, 142))
GREEN_PEAS = Color('#89C35C', (137, 195, 92))
DOLLAR_BILL_GREEN = Color('#85BB65', (133, 187, 101))
IGUANA_GREEN = Color('#9CB071', (156, 176, 113))
ACID_GREEN = Color('#B0BF1A', (176, 191, 26))
AVOCADO_GREEN = Color('#B2C248', (178, 194, 72))
PISTACHIO_GREEN = Color('#9DC209', (157, 194, 9))
SALAD_GREEN = Color('#A1C935', (161, 201, 53))
PASTEL_GREEN = Color('#77DD77', (119, 221, 119))
HUMMINGBIRD_GREEN = Color('#7FE817', (127, 232, 23))
NEBULA_GREEN = Color('#59E817', (89, 232, 23))
STOPLIGHT_GO_GREEN = Color('#57E964', (87, 233, 100))
NEON_GREEN = Color('#16F529', (22, 245, 41))
JADE_GREEN = Color('#5EFB6E', (94, 251, 110))
LIME_MINT_GREEN = Color('#36F57F', (54, 245, 127))
EMERALD_GREEN = Color('#5FFB17', (95, 251, 23))
BRIGHT_GREEN = Color('#66FF00', (102, 255, 0))
YELLOW_LAWN_GREEN = Color('#87F717', (135, 247, 23))
ALOE_VERA_GREEN = Color('#98F516', (152, 245, 22))
DULL_GREEN_YELLOW = Color('#B1FB17', (177, 251, 23))
CHAMELEON_GREEN = Color('#BDF516', (189, 245, 22))
NEON_YELLOW_GREEN = Color('#DAEE01', (218, 238, 1))
YELLOW_GREEN_GROSBEAK = Color('#E2F516', (226, 245, 22))
TEA_GREEN = Color('#CCFB5D', (204, 251, 93))
SLIME_GREEN = Color('#BCE954', (188, 233, 84))
ALGAE_GREEN = Color('#64E986', (100, 233, 134))
DRAGON_GREEN = Color('#6AFB92', (106, 251, 146))
MINT_GREEN = Color('#98FF98', (152, 255, 152))
GREEN_THUMB = Color('#B5EAAA', (181, 234, 170))
ORGANIC_BROWN = Color('#E3F9A6', (227, 249, 166))
LIGHT_JADE = Color('#C3FDB8', (195, 253, 184))
LIGHT_ROSE_GREEN = Color('#DBF9DB', (219, 249, 219))
PARCHMENT = Color('#FFFFC2', (255, 255, 194))
CREAM = Color('#FFFFCC', (255, 255, 204))
CREAM_WHITE = Color('#FFFDD0', (255, 253, 208))
BLONDE = Color('#FBF6D9', (251, 246, 217))
CHAMPAGNE = Color('#F7E7CE', (247, 231, 206))
PEACH = Color('#FFE5B4', (255, 229, 180))
LIGHT_ORANGE = Color('#FED8B1', (254, 216, 177))
GOLDEN_BLONDE = Color('#FBE7A1', (251, 231, 161))
GOLDEN_SILK = Color('#F3E3C3', (243, 227, 195))
DARK_BLONDE = Color('#F0E2B6', (240, 226, 182))
LIGHT_GOLD = Color('#F1E5AC', (241, 229, 172))
VANILLA = Color('#F3E5AB', (243, 229, 171))
TAN_BROWN = Color('#ECE5B6', (236, 229, 182))
DIRTY_WHITE = Color('#E8E4C9', (232, 228, 201))
CARDBOARD_BROWN = Color('#EDDA74', (237, 218, 116))
HARVEST_GOLD = Color('#EDE275', (237, 226, 117))
SUN_YELLOW = Color('#FFE87C', (255, 232, 124))
CORN_YELLOW = Color('#FFF380', (255, 243, 128))
PASTEL_YELLOW = Color('#FAF884', (250, 248, 132))
NEON_YELLOW = Color('#FFFF33', (255, 255, 51))
CANARY_YELLOW = Color('#FFEF00', (255, 239, 0))
BANANA_YELLOW = Color('#F5E216', (245, 226, 22))
MUSTARD_YELLOW = Color('#FFDB58', (255, 219, 88))
GOLDEN_YELLOW = Color('#FFDF00', (255, 223, 0))
BOLD_YELLOW = Color('#F9DB24', (249, 219, 36))
RUBBER_DUCKY_YELLOW = Color('#FFD801', (255, 216, 1))
BRIGHT_GOLD = Color('#FDD017', (253, 208, 23))
CHROME_GOLD = Color('#FFCE44', (255, 206, 68))
GOLDEN_BROWN = Color('#EAC117', (234, 193, 23))
DEEP_YELLOW = Color('#F6BE00', (246, 190, 0))
MACARONI_AND_CHEESE = Color('#F2BB66', (242, 187, 102))
SAFFRON = Color('#FBB917', (251, 185, 23))
BEER = Color('#FBB117', (251, 177, 23))
YELLOW_ORANGE_OR_ORANGE_YELLOW = Color('#FFAE42', (255, 174, 66))
CANTALOUPE = Color('#FFA62F', (255, 166, 47))
BROWN_SAND = Color('#EE9A4D', (238, 154, 77))
BROWN_SUGAR = Color('#E2A76F', (226, 167, 111))
CAMEL_BROWN = Color('#C19A6B', (193, 154, 107))
DEER_BROWN = Color('#E6BF83', (230, 191, 131))
LIGHT_FRENCH_BEIGE = Color('#C8AD7F', (200, 173, 127))
SAND = Color('#C2B280', (194, 178, 128))
SAGE = Color('#BCB88A', (188, 184, 138))
FALL_LEAF_BROWN = Color('#C8B560', (200, 181, 96))
GINGER_BROWN = Color('#C9BE62', (201, 190, 98))
OLIVE_GREEN = Color('#BAB86C', (186, 184, 108))
BRASS = Color('#B5A642', (181, 166, 66))
COOKIE_BROWN = Color('#C7A317', (199, 163, 23))
METALLIC_GOLD = Color('#D4AF37', (212, 175, 55))
BEE_YELLOW = Color('#E9AB17', (233, 171, 23))
SCHOOL_BUS_YELLOW = Color('#E8A317', (232, 163, 23))
ORANGE_GOLD = Color('#D4A017', (212, 160, 23))
CARAMEL = Color('#C68E17', (198, 142, 23))
CINNAMON = Color('#C58917', (197, 137, 23))
BRONZE = Color('#CD7F32', (205, 127, 50))
TIGER_ORANGE = Color('#C88141', (200, 129, 65))
COPPER = Color('#B87333', (184, 115, 51))
DARK_GOLD = Color('#AA6C39', (170, 108, 57))
DARK_ALMOND = Color('#AB784E', (171, 120, 78))
WOOD = Color('#966F33', (150, 111, 51))
OAK_BROWN = Color('#806517', (128, 101, 23))
ANTIQUE_BRONZE = Color('#665D1E', (102, 93, 30))
HAZEL = Color('#8E7618', (142, 118, 24))
DARK_YELLOW = Color('#8B8000', (139, 128, 0))
DARK_MOCCASIN = Color('#827839', (130, 120, 57))
KHAKI_GREEN = Color('#8A865D', (138, 134, 93))
BULLET_SHELL = Color('#AF9B60', (175, 155, 96))
ARMY_BROWN = Color('#827B60', (130, 123, 96))
SANDSTONE = Color('#786D5F', (120, 109, 95))
TAUPE = Color('#483C32', (72, 60, 50))
MOCHA = Color('#493D26', (73, 61, 38))
MILK_CHOCOLATE = Color('#513B1C', (81, 59, 28))
GRAY_BROWN = Color('#3D3635', (61, 54, 53))
DARK_COFFEE = Color('#3B2F2F', (59, 47, 47))
OLD_BURGUNDY = Color('#43302E', (67, 48, 46))
WESTERN_CHARCOAL = Color('#49413F', (73, 65, 63))
BAKERS_BROWN = Color('#5C3317', (92, 51, 23))
DARK_BROWN = Color('#654321', (101, 67, 33))
SEPIA_BROWN = Color('#704214', (112, 66, 20))
DARK_BRONZE = Color('#804A00', (128, 74, 0))
COFFEE = Color('#6F4E37', (111, 78, 55))
BROWN_BEAR = Color('#835C3B', (131, 92, 59))
RED_DIRT = Color('#7F5217', (127, 82, 23))
SEPIA = Color('#7F462C', (127, 70, 44))
DARK_SIENNA = Color('#8A4117', (138, 65, 23))
SANGRIA = Color('#7E3817', (126, 56, 23))
BLOOD_RED = Color('#7E3517', (126, 53, 23))
CHESTNUT = Color('#954535', (149, 69, 53))
CHESTNUT_RED = Color('#C34A2C', (195, 74, 44))
MAHOGANY = Color('#C04000', (192, 64, 0))
RED_FOX = Color('#C35817', (195, 88, 23))
DARK_BISQUE = Color('#B86500', (184, 101, 0))
LIGHT_BROWN = Color('#B5651D', (181, 101, 29))
PETRA_GOLD = Color('#B76734', (183, 103, 52))
RUST = Color('#C36241', (195, 98, 65))
COPPER_RED = Color('#CB6D51', (203, 109, 81))
ORANGE_SALMON = Color('#C47451', (196, 116, 81))
SEDONA = Color('#CC6600', (204, 102, 0))
PAPAYA_ORANGE = Color('#E56717', (229, 103, 23))
HALLOWEEN_ORANGE = Color('#E66C2C', (230, 108, 44))
NEON_ORANGE = Color('#FF6700', (255, 103, 0))
BRIGHT_ORANGE = Color('#FF5F1F', (255, 95, 31))
PUMPKIN_ORANGE = Color('#F87217', (248, 114, 23))
CARROT_ORANGE = Color('#F88017', (248, 128, 23))
CONSTRUCTION_CONE_ORANGE = Color('#F87431', (248, 116, 49))
INDIAN_SAFFRON = Color('#FF7722', (255, 119, 34))
SUNRISE_ORANGE = Color('#E67451', (230, 116, 81))
MANGO_ORANGE = Color('#FF8040', (255, 128, 64))
BASKET_BALL_ORANGE = Color('#F88158', (248, 129, 88))
LIGHT_SALMON_ROSE = Color('#F9966B', (249, 150, 107))
TANGERINE = Color('#E78A61', (231, 138, 97))
LIGHT_COPPER = Color('#DA8A67', (218, 138, 103))
PASTEL_RED = Color('#F67280', (246, 114, 128))
PINK_CORAL = Color('#E77471', (231, 116, 113))
BEAN_RED = Color('#F75D59', (247, 93, 89))
VALENTINE_RED = Color('#E55451', (229, 84, 81))
SHOCKING_ORANGE = Color('#E55B3C', (229, 91, 60))
NEON_RED = Color('#FD1C03', (253, 28, 3))
SCARLET = Color('#FF2400', (255, 36, 0))
RUBY_RED = Color('#F62217', (246, 34, 23))
FERRARI_RED = Color('#F70D1A', (247, 13, 26))
FIRE_ENGINE_RED = Color('#F62817', (246, 40, 23))
LAVA_RED = Color('#E42217', (228, 34, 23))
LOVE_RED = Color('#E41B17', (228, 27, 23))
GRAPEFRUIT = Color('#DC381F', (220, 56, 31))
CHERRY_RED = Color('#C24641', (194, 70, 65))
CHILLI_PEPPER = Color('#C11B17', (193, 27, 23))
TOMATO_SAUCE_RED = Color('#B21807', (178, 24, 7))
CARBON_RED = Color('#A70D2A', (167, 13, 42))
CRANBERRY = Color('#9F000F', (159, 0, 15))
SAFFRON_RED = Color('#931314', (147, 19, 20))
CRIMSON_RED = Color('#990000', (153, 0, 0))
RED_WINE_OR_WINE_RED = Color('#990012', (153, 0, 18))
BURGUNDY = Color('#8C001A', (140, 0, 26))
VERMILION = Color('#7E191B', (126, 25, 27))
DEEP_RED = Color('#800517', (128, 5, 23))
RED_BLOOD = Color('#660000', (102, 0, 0))
BLOOD_NIGHT = Color('#551606', (85, 22, 6))
DARK_SCARLET = Color('#560319', (86, 3, 25))
BLACK_BEAN = Color('#3D0C02', (61, 12, 2))
CHOCOLATE_BROWN = Color('#3F000F', (63, 0, 15))
MIDNIGHT = Color('#2B1B17', (43, 27, 23))
PURPLE_LILY = Color('#550A35', (85, 10, 53))
PURPLE_MAROON = Color('#810541', (129, 5, 65))
PLUM_PIE = Color('#7D0541', (125, 5, 65))
PLUM_VELVET = Color('#7D0552', (125, 5, 82))
DARK_RASPBERRY = Color('#872657', (135, 38, 87))
VELVET_MAROON = Color('#7E354D', (126, 53, 77))
ROSY_FINCH = Color('#7F4E52', (127, 78, 82))
DULL_PURPLE = Color('#7F525D', (127, 82, 93))
PUCE = Color('#7F5A58', (127, 90, 88))
ROSE_DUST = Color('#997070', (153, 112, 112))
ROSY_PINK = Color('#B38481', (179, 132, 129))
KHAKI_ROSE = Color('#C5908E', (197, 144, 142))
LIPSTICK_PINK = Color('#C48793', (196, 135, 147))
PINK_BROWN = Color('#C48189', (196, 129, 137))
PINK_DAISY = Color('#E799A3', (231, 153, 163))
DUSTY_PINK = Color('#D58A94', (213, 138, 148))
ROSE = Color('#E8ADAA', (232, 173, 170))
SILVER_PINK = Color('#C4AEAD', (196, 174, 173))
ROSE_GOLD = Color('#ECC5C0', (236, 197, 192))
DEEP_PEACH = Color('#FFCBA4', (255, 203, 164))
PASTEL_ORANGE = Color('#F8B88B', (248, 184, 139))
DESERT_SAND = Color('#EDC9AF', (237, 201, 175))
UNBLEACHED_SILK = Color('#FFDDCA', (255, 221, 202))
PIG_PINK = Color('#FDD7E4', (253, 215, 228))
BLUSH = Color('#FFE6E8', (255, 230, 232))
PINK_BUBBLE_GUM = Color('#FFDFDD', (255, 223, 221))
LIGHT_RED = Color('#FFCCCB', (255, 204, 203))
LIGHT_ROSE = Color('#FBCFCD', (251, 207, 205))
DEEP_ROSE = Color('#FBBBB9', (251, 187, 185))
DONUT_PINK = Color('#FAAFBE', (250, 175, 190))
BABY_PINK = Color('#FAAFBA', (250, 175, 186))
FLAMINGO_PINK = Color('#F9A7B0', (249, 167, 176))
PASTEL_PINK = Color('#FEA3AA', (254, 163, 170))
ROSE_PINK_OR_PINK_ROSE = Color('#E7A1B0', (231, 161, 176))
CADILLAC_PINK = Color('#E38AAE', (227, 138, 174))
CARNATION_PINK = Color('#F778A1', (247, 120, 161))
BLUSH_RED = Color('#E56E94', (229, 110, 148))
PURPLE_PINK = Color('#D16587', (209, 101, 135))
TULIP_PINK = Color('#C25A7C', (194, 90, 124))
BASHFUL_PINK = Color('#C25283', (194, 82, 131))
DARK_PINK = Color('#E75480', (231, 84, 128))
DARK_HOT_PINK = Color('#F660AB', (246, 96, 171))
WATERMELON_PINK = Color('#FC6C85', (252, 108, 133))
VIOLET_RED = Color('#F6358A', (246, 53, 138))
HOT_DEEP_PINK = Color('#F52887', (245, 40, 135))
NEON_PINK = Color('#F535AA', (245, 53, 170))
NEON_HOT_PINK = Color('#FD349C', (253, 52, 156))
PINK_CUPCAKE = Color('#E45E9D', (228, 94, 157))
DIMORPHOTHECA_MAGENTA = Color('#E3319D', (227, 49, 157))
PINK_LEMONADE = Color('#E4287C', (228, 40, 124))
RASPBERRY = Color('#E30B5D', (227, 11, 93))
BRIGHT_MAROON = Color('#C32148', (195, 33, 72))
ROSE_RED = Color('#C21E56', (194, 30, 86))
ROGUE_PINK = Color('#C12869', (193, 40, 105))
BURNT_PINK = Color('#C12267', (193, 34, 103))
PINK_VIOLET = Color('#CA226B', (202, 34, 107))
DARK_CARNATION_PINK = Color('#C12283', (193, 34, 131))
RASPBERRY_PURPLE = Color('#B3446C', (179, 68, 108))
PINK_PLUM = Color('#B93B8F', (185, 59, 143))
DEEP_MAUVE = Color('#DF73D4', (223, 115, 212))
BRIGHT_NEON_PINK = Color('#F433FF', (244, 51, 255))
CRIMSON_PURPLE = Color('#E238EC', (226, 56, 236))
HELIOTROPE_PURPLE = Color('#D462FF', (212, 98, 255))
TYRIAN_PURPLE = Color('#C45AEC', (196, 90, 236))
PURPLE_FLOWER = Color('#A74AC7', (167, 74, 199))
ORCHID_PURPLE = Color('#B048B5', (176, 72, 181))
PASTEL_VIOLET = Color('#D291BC', (210, 145, 188))
MAUVE_TAUPE = Color('#915F6D', (145, 95, 109))
VIOLA_PURPLE = Color('#7E587E', (126, 88, 126))
EGGPLANT = Color('#614051', (97, 64, 81))
PLUM_PURPLE = Color('#583759', (88, 55, 89))
GRAPE = Color('#5E5A80', (94, 90, 128))
PURPLE_NAVY = Color('#4E5180', (78, 81, 128))
BLUE_LOTUS = Color('#6960EC', (105, 96, 236))
LIGHT_SLATE_BLUE = Color('#736AFF', (115, 106, 255))
PERIWINKLE_PURPLE = Color('#7575CF', (117, 117, 207))
VERY_PERI = Color('#6667AB', (102, 103, 171))
BRIGHT_GRAPE = Color('#6F2DA8', (111, 45, 168))
PURPLE_AMETHYST = Color('#6C2DC7', (108, 45, 199))
BRIGHT_PURPLE = Color('#6A0DAD', (106, 13, 173))
DEEP_PERIWINKLE = Color('#5453A6', (84, 83, 166))
PURPLE_HAZE = Color('#4E387E', (78, 56, 126))
PURPLE_IRIS = Color('#571B7E', (87, 27, 126))
DARK_PURPLE = Color('#4B0150', (75, 1, 80))
DEEP_PURPLE = Color('#36013F', (54, 1, 63))
PURPLE_MONSTER = Color('#461B7E', (70, 27, 126))
BLUE_WHALE = Color('#342D7E', (52, 45, 126))
PURPLE_JAM = Color('#6A287E', (106, 40, 126))
FRENCH_LILAC = Color('#86608E', (134, 96, 142))
PURPLE_VIOLET = Color('#8D38C9', (141, 56, 201))
JASMINE_PURPLE = Color('#A23BEC', (162, 59, 236))
PURPLE_DAFFODIL = Color('#B041FF', (176, 65, 255))
CLEMATIS_VIOLET = Color('#842DCE', (132, 45, 206))
PURPLE_SAGE_BUSH = Color('#7A5DC7', (122, 93, 199))
LOVELY_PURPLE = Color('#7F38EC', (127, 56, 236))
NEON_PURPLE = Color('#9D00FF', (157, 0, 255))
PURPLE_PLUM = Color('#8E35EF', (142, 53, 239))
AZTECH_PURPLE = Color('#893BFF', (137, 59, 255))
LAVENDER_PURPLE = Color('#967BB6', (150, 123, 182))
LIGHT_PURPLE = Color('#8467D7', (132, 103, 215))
CROCUS_PURPLE = Color('#9172EC', (145, 114, 236))
PURPLE_MIMOSA = Color('#9E7BFF', (158, 123, 255))
PERIWINKLE = Color('#CCCCFF', (204, 204, 255))
PALE_LILAC = Color('#DCD0FF', (220, 208, 255))
MAUVE = Color('#E0B0FF', (224, 176, 255))
BRIGHT_LILAC = Color('#D891EF', (216, 145, 239))
RICH_LILAC = Color('#B666D2', (182, 102, 210))
PURPLE_DRAGON = Color('#C38EC7', (195, 142, 199))
LILAC = Color('#C8A2C8', (200, 162, 200))
BLUSH_PINK = Color('#E6A9EC', (230, 169, 236))
PASTEL_PURPLE = Color('#F2A2E8', (242, 162, 232))
BLOSSOM_PINK = Color('#F9B7FF', (249, 183, 255))
WISTERIA_PURPLE = Color('#C6AEC7', (198, 174, 199))
PURPLE_THISTLE = Color('#D2B9D3', (210, 185, 211))
PERIWINKLE_PINK = Color('#E9CFEC', (233, 207, 236))
COTTON_CANDY = Color('#FCDFFF', (252, 223, 255))
LAVENDER_PINOCCHIO = Color('#EBDDE2', (235, 221, 226))
DARK_WHITE = Color('#E1D9D1', (225, 217, 209))
ASH_WHITE = Color('#E9E4D4', (233, 228, 212))
WHITE_CHOCOLATE = Color('#EDE6D6', (237, 230, 214))
SOFT_IVORY = Color('#FAF0DD', (250, 240, 221))
OFF_WHITE = Color('#F8F0E3', (248, 240, 227))
PEARL_WHITE = Color('#F8F6F0', (248, 246, 240))
PEARL = Color('#FDEEF4', (253, 238, 244))
EGG_SHELL = Color('#FFF9E3', (255, 249, 227))
RICE = Color('#FAF5EF', (250, 245, 239))
LIGHT_WHITE = Color('#FFFFF7', (255, 255, 247))
COTTON = Color('#FBFBF9', (251, 251, 249))
MILK_WHITE = Color('#FEFCFF', (254, 252, 255))