# PyMoDAQ Plugin Manager

[<img src="https://img.shields.io/pypi/v/pymodaq_plugin_manager.svg">](https://pypi.org/project/pymodaq_plugin_manager/)
[<img src="https://readthedocs.org/projects/pymodaq/badge/?version=latest">](https://pymodaq.readthedocs.io/en/stable/?badge=latest)
[<img src="https://github.com/CEMES-CNRS/pymodaq_plugin_manager/workflows/Upload%20Python%20Package/badge.svg">](https://github.com/CEMES-CNRS/pymodaq_plugin_manager)


A plugin manager for PyMoDAQ, Modular Data Acquisition with Python.

Give a list of available, installable or updatable plugins compatible with pymodaq


# PyMoDAQ Plugins
|                                                          Repo Name                                                          |              Authors              |           Version plugin            |                                                                                                                                                                                                                                                                                                                                                                                                  Instruments                                                                                                                                                                                                                                                                                                                                                                                                   |
|-----------------------------------------------------------------------------------------------------------------------------|-----------------------------------|-------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| <a href="https://pypi.org/project/pymodaq-plugins-orsay/" target="_top"># PyMoDAQ Orsay STEM and Camera plugin</a>          | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.1</a>  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| <a href="https://pypi.org/project/pymodaq-plugins-amplitude/" target="_top">Amplitude Lasers</a>                            | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.2</a>  | Viewer0D<ul>   <li>     **AmplitudeSystemsCRC16**: Let you control the laser settings and grab info on the laser status (tested on a Satsuma)   </li> </ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| <a href="https://pypi.org/project/pymodaq-plugins-andor/" target="_top">Andor</a>                                           | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.4</a>  | Actuators<ul><li>**Shamrock**: Shamrock series of spectrometer used as a monochromator</li></ul>Viewer1D<ul>   <li>**ShamrockCCD**: Shamrock series of spectrometer using the Andor CCD cameras</li>   <li>**ShamrockSCMOS**: Shamrock series of spectrometer using the Andor SCMOS cameras</li> </ul>Viewer2D<ul>   <li>**AndorCCD**: Andor CCD camera using the SDK2</li>   <li>**AndorSCMOS**: Andor CCD camera using the SDK3</li> </ul>                                                                                                                                                                                                                                                                                                                                                                   |
| <a href="https://pypi.org/project/pymodaq-plugins-femto/" target="_top">Femto Characterization</a>                          | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.2</a>  | Viewer1D<ul><li>**femto**: Fake detector mocking typically a spectrometer acquiring FROG traces</li></ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| <a href="https://pypi.org/project/pymodaq-plugins-flim/" target="_top">Fluorescence Lifetime Imaging Microscopy</a>         | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.2</a>  | ViewerND<ul><li>**FLIM**: FLIM using piezoconcept XY stage and picoquant timeharp TH260"</li></ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| <a href="https://pypi.org/project/pymodaq-plugins-horiba/" target="_top">Horiba Spectrometers</a>                           | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.2</a>  | Viewer1D<ul>   <li>**Labspec6TCP**: Control of Labspec6 settings and acquisition using TCP/IP communication</li> </ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| <a href="https://pypi.org/project/pymodaq-plugins-daqmx/" target="_top">National Instrument DAQmx</a>                       | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.4</a>  | Actuators<ul><li>**DAQmx**: Analog output DC, Sinus, Ramp...</li></ul>Viewer0D<ul><li>**DAQmx**: Analog acquisition, Counting</li></ul>Viewer1D<ul><li>**DAQmx**: Analog acquisition</li></ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| <a href="https://pypi.org/project/pymodaq-plugins-newport/" target="_top">Newport Instruments</a>                           | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.3</a>  | Actuators<ul>   <li>**Conex**: Piezo actuators from the CONEX-AGAP series"</li>   <li>**Newport_ESP100**: ESP100 motion controllers</li> </ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| <a href="https://pypi.org/project/pymodaq-plugins-oceaninsight/" target="_top">Ocean Insight (Optics</a>                    | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.2</a>  | Viewer1D<ul>   <li>**Omnidriver**: Control of Spectrometer using the Omnidriver library (should be installed)</li> </ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| <a href="https://pypi.org/project/pymodaq-plugins-physical-measurements/" target="_top">Physical Measurements Hardware</a>  | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.4</a>  | Viewer0D<ul>   <li>**Keithley_Pico**: Pico-Amperemeter Keithley 648X Series, 6430 and 6514</li>   <li>**Keithley2110**: Multimeter Keithley  2110</li>   <li>**Lockin7270**: Lockin Amplifier Ametek 7270</li>   <li>**LockinSR830**: LockIn Amplifier SR830</li> </ul>Viewer1D<ul>   <li>**LecroyWaveRunner6Zi**: Oscilloscope LecroyWaveRunner 6Zi</li>   <li>**Tektronix**: Oscilloscope Tektronix MDO Series</li>   <li>**Picoscope**: Picoscope from Picotechnology</li> </ul>Viewer2D<ul>   <li>**OpenCVCam**: Webcams control using the opencv library</li>   <li>**GenICam**: GeniCam compliant cameras suing the harvester libary</li>   <li>**TIS**: The Imaging Source TIS cameras</li> </ul>                                                                                                       |
| <a href="https://pypi.org/project/pymodaq-plugins-physik-instrumente/" target="_top">Physik Instrumente Stages</a>          | <ul><li>Sebastien Weber</li></ul> | <a href="" target="_top">0.0.3</a>  | Actuators<ul>   <li>**PI**: All stages compatible with the GCS2 library</li>   <li>**PI_MMC**: old controller and stages using the 32 bits MMC dll (requires 32bit python)</li> </ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| <a href="https://pypi.org/project/pymodaq-plugins-picoquant/" target="_top">Picoquant</a>                                   | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">0.0.2</a>  | Viewer1D<ul><li>**TH260**: Timeharp TH260 for *photon counting* and *time tagging*</li></ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| <a href="https://pypi.org/project/pymodaq-plugins-piezoconcept/" target="_top">PiezoConcept Stages</a>                      | <ul><li>Sebastien Weber</li></ul> | <a href="" target="_top">0.0.4</a>  | Actuators<ul>   <li>**PiezoConcept** : piezoconcept stages (tested on BIO2.100) using the usual serial commands</li>   <li>     **PiezoConceptPI**: Special firmware to emulate functions form the GCS2 library from Physik Instrumente   </li> </ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| <a href="https://pypi.org/project/pymodaq-plugins/" target="_top">PyMoDAQ Plugins</a>                                       | <ul><li>Sbastien Weber</li></ul> | <a href="" target="_top">3.1.2</a>  | Actuators<ul>   <li>**Mock** actuator to test PyMoDAQ functionnalities</li>   <li>**MockTau** mock actuator with caracteristic time to reach set value</li>   <li>**TCP server** to communicate with other DAQ_Move or third party applications</li> </ul>Viewer0D<ul>   <li>**Mock 0D** detector to test PyMoDAQ functionnalities</li>   <li>**Mock Adaptive** detector to test PyMoDAQ adaptive scan mode</li>   <li>**TCP server** to communicate with other DAQ_Viewer or third party applications</li> </ul>Viewer1D<ul>   <li>**Mock 1D** detector to test PyMoDAQ functionnalities</li>   <li>**Mock Spectro** detector to test pymodaq_spectro functionalities</li>   <li>**TCP server** to communicate with other DAQ_Viewer or third party applications</li> </ul>Viewer2D<ul></ul>ViewerND<ul></ul> |
| <a href="https://pypi.org/project/pymodaq-plugins-smaract/" target="_top">Smaract</a>                                       | <ul><li>David Bresteau</li></ul>  | <a href="" target="_top">0.0.4</a>  | Actuators<ul>   <li>**SLC linear stages with sensor (S option) with MCS controller**</li>   <li>**SLC linear stages with sensor (S option) with MCS2 controller**</li> </ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| <a href="https://pypi.org/project/pymodaq-plugins-stellarnet/" target="_top">StellarNet</a>                                 | <ul><li>Romain Gneaux</li></ul>  | <a href="" target="_top">1.0.1</a>  | Viewer1D<ul>   <li>     **Stellarnet**: USB spectrometers made by StellarNet, Inc (https://www.stellarnet.us/spectrometers/).   </li> </ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| <a href="https://pypi.org/project/pymodaq-plugins-thorlabs/" target="_top">Thorlabs Instruments</a>                         | <ul><li>Sebastien Weber</li></ul> | <a href="" target="_top">0.0.2</a>  | Actuators<ul>   <li>**Kinesis**: Kinesis serie (tested on K10CR1)</li>   <li>**Kinesis_Flipper**: Kinesis serie Flipper</li> </ul>Viewer0D<ul><li>**Kinesis_KPA101**: Kinesis serie (position sensitive photodetector)</li></ul>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
