# -*- coding: utf-8 -*-

import unittest

from apiutil.json_api import (MANDATORY,
                              OPTIONAL,
                              TYPE,
                              PROPERTIES,
                              PROPERTY,
                              DEFAULT,
                              JsonApiPropertiesClassCreator)


class TestDictionaryResponderCreator(unittest.TestCase):

    def test_x(self):
        x = JsonApiPropertiesClassCreator(class_name=u'Rectangle',
                                          key=u'rectangle',
                                          property_name=u'rect',
                                          attributes={u'w': {MANDATORY: True,
                                                             PROPERTIES: [u'w', u'width'], },

                                                      u'h': {MANDATORY: True,
                                                             PROPERTIES: [u'h', u'height'], },

                                                      u'col': {OPTIONAL: False,
                                                               PROPERTIES: [u'color', u'colour'],
                                                               DEFAULT: u'red'},

                                                      u'border': {OPTIONAL: False,
                                                                  PROPERTY: u'border',
                                                                  DEFAULT: 1.0,
                                                                  TYPE: int},
                                                      },
                                          mixins=[{u"module": u".class_augmentations.augment_example",
                                                   u"name": u"Augment"}]
                                          )
        expected = u"""# encoding: utf-8
# Code generated by apiutil.json_api.JsonApiPropertiesClassCreator

from apiutil.json_api import JsonApiPropertiesClass
from classutils import class_cache_result 
from .class_augmentations.augment_example import Augment


class RectangleBase(JsonApiPropertiesClass):

    h = JsonApiPropertiesClass.mandatory_field(key='h')
    height = JsonApiPropertiesClass.mandatory_field(key='h')
    border = JsonApiPropertiesClass.optional_field(key='border', default=1.0, cast=int)
    color = JsonApiPropertiesClass.optional_field(key='col', default='red')
    colour = JsonApiPropertiesClass.optional_field(key='col', default='red')
    w = JsonApiPropertiesClass.mandatory_field(key='w')
    width = JsonApiPropertiesClass.mandatory_field(key='w')


class Rectangle(RectangleBase,
                Augment):
    pass  # Does this need an init?


class RectMandatoryMixIn(object):

    RECTANGLE = Rectangle  # Override in subclass if required

    def __init__(self):
        super(RectMandatoryMixIn, self).__init__()

    @property
    @class_cache_result
    def rect(self):
        attribute = self._get_mandatory_field_value(u'rectangle')
        if isinstance(attribute, list):
            rect = [
                Rectangle(
                    response=response,
                    parent=self)
                for response in attribute]
        elif isinstance(attribute, dict):
            rect = Rectangle(
                response=attribute,
                parent=self)
        else:
            raise TypeError(u'Unexpected type:{t} (Expected list or dict)'
                            .format(t=type(attribute).__name__))
        return rect


class RectOptionalMixIn(object):

    RECTANGLE = Rectangle  # Override in subclass if required

    def __init__(self):
        super(RectOptionalMixIn, self).__init__()

    @property
    @class_cache_result
    def rect(self):
        attribute = self._get_optional_field_value(u'rectangle')
        if isinstance(attribute, list):
            rect = [
                Rectangle(
                    response=response,
                    parent=self)
                for response in attribute]
        elif isinstance(attribute, dict):
            rect = Rectangle(
                response=attribute,
                parent=self)
        else:
            raise TypeError(u'Unexpected type:{t} (Expected list or dict)'
                            .format(t=type(attribute).__name__))
        return rect
"""
        generated = x.code

        print(generated)
        self.assertEqual(expected.splitlines()[:9], generated.splitlines()[:9])

        for line in range(9, 17):
            # These lines are ordered differently between py2 & py3
            self.assertIn(generated.splitlines()[line], expected.splitlines()[9:17])

        self.assertEqual(expected.splitlines()[17:], generated.splitlines()[17:])


if __name__ == u'__main__':
    unittest.main()
