import asyncio
from typing import Optional

from aiohttp import web  # pylint: disable=import-error

from . import _server


def _run_server(app: web.Application, port: int) -> None:
    """Run the given app on the given port.

    Intended to be called as a target for a separate thread.
    NOTE. `aiohttp.web.run_app` works only in the main thread and can't be used here (or maybe can we some tuning)
    """
    # Set a loop for a new thread (there is no by default for non-main threads)
    loop = asyncio.new_event_loop()
    asyncio.set_event_loop(loop)
    runner = web.AppRunner(app)
    loop.run_until_complete(runner.setup())
    site = web.TCPSite(runner, "127.0.0.1", port)
    loop.run_until_complete(site.start())
    loop.run_forever()


def run_server(app: web.Application, port: Optional[int] = None, timeout: float = 0.05) -> int:
    """Start a thread with the given aiohttp application."""
    return _server.run(_run_server, app=app, port=port, timeout=timeout)
