"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const core_2 = require("@aws-solutions-constructs/core");
const defaults = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename), {});
stack.templateOptions.description = 'Dummy Integration Test for aws-route53-apigateway';
// This is an dummy integ test in order to bypass the CodeBuild integ test scans.
// Route53ToApiGateway construct requires a legitimate DNS and certificate to be deployed.
// If a fake DNS and certificate is provided, the deployment will hang and cause it to fail.
// Legitimate DNS and certificate cannot be provided in integ tests as it is user specific
// and will need to be regenerated.
// Create dummy integ with at least one resource to pass CFN scan
const [restApi] = defaults.RegionalRestApi(stack);
restApi.root.addMethod('GET');
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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