"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53ToApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const route53 = require("@aws-cdk/aws-route53");
const targets = require("@aws-cdk/aws-route53-targets");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
/**
 * @summary The Route53ToApiGateway class.
 */
class Route53ToApiGateway extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the Route53ToApiGateway class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {Route53ToApiGatewayProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        this.certificate = props.existingCertificateInterface;
        if (props.existingVpc) {
            this.vpc = props.existingVpc;
        }
        // Existing Public or Private Hosted Zone
        if (props.existingHostedZoneInterface) {
            this.hostedZone = props.existingHostedZoneInterface;
            if (props.existingVpc) {
                throw new Error('Cannot provide an existing VPC to an existing Private Hosted Zone.');
            }
            if (props.privateHostedZoneProps) {
                throw new Error('Must provide either existingHostedZoneInterface or privateHostedZoneProps, but not both.');
            }
        }
        else { // Creating a Private Hosted Zone
            if (props.publicApi) {
                throw new Error('Public APIs require an existingHostedZone be passed in the Props object.');
            }
            else {
                if (!props.privateHostedZoneProps) {
                    throw new Error('Must provide either existingHostedZoneInterface or privateHostedZoneProps.');
                }
                if (props.privateHostedZoneProps.vpc) {
                    throw new Error('All VPC specs must be provided at the Construct level in Route53ToApiGatewayProps.');
                }
                if (!props.privateHostedZoneProps.zoneName) {
                    throw new Error('Must supply zoneName for Private Hosted Zone Props.');
                }
                if (!this.vpc) {
                    throw new Error('Must specify an existingVPC for the Private Hosted Zone in the construct props.');
                }
                const manufacturedProps = defaults.overrideProps(props.privateHostedZoneProps, { vpc: this.vpc });
                this.hostedZone = new route53.PrivateHostedZone(this, `${id}-zone`, manufacturedProps);
            }
        }
        // Convert IRestApi to RestApi
        this.apiGateway = props.existingApiGatewayInterface;
        // Add custom domain name in API Gateway
        this.apiGateway.addDomainName('CustomDomainName', {
            domainName: this.hostedZone.zoneName,
            certificate: this.certificate
        });
        // Create A Record in custom domain to route traffic to API Gateway
        new route53.ARecord(this, 'CustomDomainAliasRecord', {
            zone: this.hostedZone,
            target: route53.RecordTarget.fromAlias(new targets.ApiGateway(this.apiGateway))
        });
    }
}
exports.Route53ToApiGateway = Route53ToApiGateway;
_a = JSII_RTTI_SYMBOL_1;
Route53ToApiGateway[_a] = { fqn: "@aws-solutions-constructs/aws-route53-apigateway.Route53ToApiGateway", version: "1.166.1" };
//# sourceMappingURL=data:application/json;base64,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