/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as api from '@aws-cdk/aws-apigateway';
import * as route53 from "@aws-cdk/aws-route53";
import * as ec2 from '@aws-cdk/aws-ec2';
import * as certificatemanager from '@aws-cdk/aws-certificatemanager';
import { Construct } from '@aws-cdk/core';
/**
 * The properties for the Route53ToApiGateway class.
 */
export interface Route53ToApiGatewayProps {
    /**
     * Whether to create a public or private API. This value has implications
     * for the VPC, the type of Hosted Zone and the Application Load Balancer
     *
     * @default - None
     */
    readonly publicApi: boolean;
    /**
     * Optional custom properties for a new Private Hosted Zone. Cannot be specified for a
     * public API. Cannot specify a VPC, it will use the VPC in existingVpc or the VPC created by the construct.
     * Providing both this and existingHostedZoneInterface is an error.
     *
     * @default - None
     */
    readonly privateHostedZoneProps?: route53.PrivateHostedZoneProps | any;
    /**
     * Existing Public or Private Hosted Zone. If a Private Hosted Zone, must
     * exist in the same VPC specified in existingVpc
     *
     * @default - None
     */
    readonly existingHostedZoneInterface?: route53.IHostedZone;
    /**
     * An existing VPC. If an existing Private Hosted Zone is provided,
     * this value must be the VPC associated with those resources.
     *
     * @default - None
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * The existing API Gateway instance that will be protected with the Route 53 hosted zone.
     *
     * @default - None
     */
    readonly existingApiGatewayInterface: api.IRestApi;
    /**
     * An existing AWS Certificate Manager certificate for your custom domain name.
     *
     * @defualt - None
     */
    readonly existingCertificateInterface: certificatemanager.ICertificate;
}
/**
 * @summary The Route53ToApiGateway class.
 */
export declare class Route53ToApiGateway extends Construct {
    readonly hostedZone: route53.IHostedZone;
    readonly vpc?: ec2.IVpc;
    readonly apiGateway: api.RestApi;
    readonly certificate: certificatemanager.ICertificate;
    /**
     * @summary Constructs a new instance of the Route53ToApiGateway class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {Route53ToApiGatewayProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: Route53ToApiGatewayProps);
}
