/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    private final Writer out;
    private final File lockFile;
    static /* synthetic */ Class class$org$apache$commons$io$output$LockableFileWriter;

    public LockableFileWriter(String fileName) throws IOException {
        this(fileName, false, null);
    }

    public LockableFileWriter(String fileName, boolean append) throws IOException {
        this(fileName, append, null);
    }

    public LockableFileWriter(String fileName, boolean append, String lockDir) throws IOException {
        this(new File(fileName), append, lockDir);
    }

    public LockableFileWriter(File file2) throws IOException {
        this(file2, false, null);
    }

    public LockableFileWriter(File file2, boolean append) throws IOException {
        this(file2, append, null);
    }

    public LockableFileWriter(File file2, boolean append, String lockDir) throws IOException {
        this(file2, null, append, lockDir);
    }

    public LockableFileWriter(File file2, String encoding) throws IOException {
        this(file2, encoding, false, null);
    }

    public LockableFileWriter(File file2, String encoding, boolean append, String lockDir) throws IOException {
        file2 = file2.getAbsoluteFile();
        if (file2.getParentFile() != null) {
            FileUtils.forceMkdir(file2.getParentFile());
        }
        if (file2.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        if (lockDir == null) {
            lockDir = System.getProperty("java.io.tmpdir");
        }
        File lockDirFile = new File(lockDir);
        FileUtils.forceMkdir(lockDirFile);
        this.testLockDir(lockDirFile);
        this.lockFile = new File(lockDirFile, file2.getName() + LCK);
        this.createLock();
        this.out = this.initWriter(file2, encoding, append);
    }

    private void testLockDir(File lockDir) throws IOException {
        if (!lockDir.exists()) {
            throw new IOException("Could not find lockDir: " + lockDir.getAbsolutePath());
        }
        if (!lockDir.canWrite()) {
            throw new IOException("Could not write to lockDir: " + lockDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLock() throws IOException {
        Class clazz = class$org$apache$commons$io$output$LockableFileWriter == null ? (class$org$apache$commons$io$output$LockableFileWriter = LockableFileWriter.class$("org.apache.commons.io.output.LockableFileWriter")) : class$org$apache$commons$io$output$LockableFileWriter;
        synchronized (clazz) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
        }
    }

    private Writer initWriter(File file2, String encoding, boolean append) throws IOException {
        boolean fileExistedAlready = file2.exists();
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            if (encoding == null) {
                writer = new FileWriter(file2.getAbsolutePath(), append);
            } else {
                stream = new FileOutputStream(file2.getAbsolutePath(), append);
                writer = new OutputStreamWriter((OutputStream)stream, encoding);
            }
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(stream);
            this.lockFile.delete();
            if (!fileExistedAlready) {
                file2.delete();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(stream);
            this.lockFile.delete();
            if (!fileExistedAlready) {
                file2.delete();
            }
            throw ex;
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            this.lockFile.delete();
        }
    }

    public void write(int idx) throws IOException {
        this.out.write(idx);
    }

    public void write(char[] chr) throws IOException {
        this.out.write(chr);
    }

    public void write(char[] chr, int st, int end) throws IOException {
        this.out.write(chr, st, end);
    }

    public void write(String str) throws IOException {
        this.out.write(str);
    }

    public void write(String str, int st, int end) throws IOException {
        this.out.write(str, st, end);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

