/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IlluminationTypeEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IlluminationTypeEnumHandler.class);
    private static final Hashtable<String, String> patterns = IlluminationTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Transmitted\\s*", "Transmitted");
        p.put("^\\s*Epifluorescence\\s*", "Epifluorescence");
        p.put("^\\s*Oblique\\s*", "Oblique");
        p.put("^\\s*NonLinear\\s*", "NonLinear");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return IlluminationType.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"IlluminationType", (Object)value);
        return IlluminationType.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return IlluminationType.class;
    }
}

