import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataTemplateFileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/template/d/file#filename DataTemplateFile#filename}
    */
    readonly filename?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/template/d/file#id DataTemplateFile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Contents of the template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/template/d/file#template DataTemplateFile#template}
    */
    readonly template?: string;
    /**
    * variables to substitute
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/template/d/file#vars DataTemplateFile#vars}
    */
    readonly vars?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/template/d/file template_file}
*/
export declare class DataTemplateFile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "template_file";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/template/d/file template_file} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataTemplateFileConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataTemplateFileConfig);
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get rendered(): string;
    private _template?;
    get template(): string;
    set template(value: string);
    resetTemplate(): void;
    get templateInput(): string | undefined;
    private _vars?;
    get vars(): {
        [key: string]: string;
    };
    set vars(value: {
        [key: string]: string;
    });
    resetVars(): void;
    get varsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
