# SPDX-License-Identifier: Apache-2.0
#
# The OpenSearch Contributors require contributions made to
# this file be licensed under the Apache-2.0 license or a
# compatible open source license.
#
# Modifications Copyright OpenSearch Contributors. See
# GitHub history for details.
#
#  Licensed to Elasticsearch B.V. under one or more contributor
#  license agreements. See the NOTICE file distributed with
#  this work for additional information regarding copyright
#  ownership. Elasticsearch B.V. licenses this file to you under
#  the Apache License, Version 2.0 (the "License"); you may
#  not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
# 	http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing,
#  software distributed under the License is distributed on an
#  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#  KIND, either express or implied.  See the License for the
#  specific language governing permissions and limitations
#  under the License.

from typing import Any

from .utils import DslBase

class Field(DslBase): ...
class CustomField(Field): ...
class Object(Field): ...
class Nested(Object): ...
class Date(Field): ...
class Text(Field): ...
class SearchAsYouType(Field): ...
class Keyword(Field): ...
class ConstantKeyword(Keyword): ...
class Boolean(Field): ...
class Float(Field): ...
class DenseVector(Float): ...
class SparseVector(Field): ...
class HalfFloat(Float): ...
class ScaledFloat(Float): ...
class Double(Float): ...
class RankFeature(Float): ...
class RankFeatures(Field): ...
class Integer(Field): ...
class Byte(Integer): ...
class Short(Integer): ...
class Long(Integer): ...
class Ip(Field): ...
class Binary(Field): ...
class GeoPoint(Field): ...
class GeoShape(Field): ...
class Completion(Field): ...
class Percolator(Field): ...
class RangeField(Field): ...
class IntegerRange(RangeField): ...
class FloatRange(RangeField): ...
class LongRange(RangeField): ...
class DoubleRange(RangeField): ...
class DateRange(RangeField): ...
class IpRange(Field): ...
class Join(Field): ...
class TokenCount(Field): ...
class Murmur3(Field): ...

def construct_field(name_or_field: Any, **params: Any) -> Any: ...
