"""
Copyright (c) 2016-2020 Keith Sterling http://www.keithsterling.com

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the "Software"), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""
from sqlalchemy import Column
from sqlalchemy import Integer
from sqlalchemy import String
from programy.storage.stores.sql.base import Base
from programy.storage.stores.utils import DAOUtils


class AuthoriseUser(Base):
    __tablename__ = 'authusers'

    id = Column(Integer, primary_key=True)
    name = Column(String(48))

    def __repr__(self):
        return "<AuthoriseUser(id='%s', name='%s')>" % (DAOUtils.valid_id(self.id), self.name)


class UserRole(Base):
    __tablename__ = 'userroles'

    id = Column(Integer, primary_key=True)
    user = Column(String(48))
    role = Column(String(48))

    def __repr__(self):
        return "<UserRole(id='%s', user='%s', role='%s')>" % (DAOUtils.valid_id(self.id), self.user, self.role)


class UserGroup(Base):
    __tablename__ = 'usergroups'

    id = Column(Integer, primary_key=True)
    user = Column(String(48))
    group = Column(String(48))

    def __repr__(self):
        return "<UserGroup(id='%s', user='%s', group='%s')>" % (DAOUtils.valid_id(self.id), self.user, self.group)


class AuthoriseGroup(Base):
    __tablename__ = 'authgroups'

    id = Column(Integer, primary_key=True)
    name = Column(String(48))
    parent = Column(String(48), nullable=True)

    def __repr__(self):
        return "<AuthoriseGroup(id='%s', name='%s', parent='%s')>" % (DAOUtils.valid_id(self.id),
                                                                      self.name,
                                                                      self.parent)


class GroupGroup(Base):
    __tablename__ = 'groupgroups'

    id = Column(Integer, primary_key=True)
    group = Column(String(48))
    subgroup = Column(String(48))

    def __repr__(self):
        return "<GroupGroup(id='%s', group='%s', subgroup='%s')>" % (DAOUtils.valid_id(self.id),
                                                                     self.group,
                                                                     self.subgroup)


class GroupRole(Base):
    __tablename__ = 'grouproles'

    id = Column(Integer, primary_key=True)
    group = Column(String(48))
    role = Column(String(48))

    def __repr__(self):
        return "<GroupRole(id='%s', group='%s', role='%s')>" % (DAOUtils.valid_id(self.id), self.group, self.role)


class GroupUser(Base):
    __tablename__ = 'groupusers'

    id = Column(Integer, primary_key=True)
    group = Column(String(48))
    user = Column(String(48))

    def __repr__(self):
        return "<GroupUser(id='%s', group='%s', user='%s')>" % (DAOUtils.valid_id(self.id), self.group, self.user)
