"""
Copyright (c) 2016-2020 Keith Sterling http://www.keithsterling.com

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the "Software"), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""
from programy.parser.template.nodes.base import TemplateNode
from programy.utils.text.text import TextUtils
from programy.parser.exceptions import ParserException


class TemplateCarouselNode(TemplateNode):

    def __init__(self):
        TemplateNode.__init__(self)
        self._cards = []

    def resolve_to_string(self, client_context):
        resolved = "<carousel>"
        for card in self._cards:
            resolved += card.resolve_to_string(client_context)
        resolved += "</carousel>"
        return resolved

    def to_string(self):
        return "[CAROUSEL %d]" % (len(self._cards))

    def to_xml(self, client_context):
        return self.resolve_to_string(client_context)

    #######################################################################################################
    #

    def parse_expression(self, graph, expression):
        head_text = self.get_text_from_element(expression)
        self.parse_text(graph, head_text)

        for child in expression:
            tag_name = TextUtils.tag_from_text(child.tag)

            if tag_name == 'card':
                card_class = graph.get_node_class_by_name("card")
                card = card_class()
                card.parse_expression(graph, child)
                self._cards.append(card)
            else:
                raise ParserException("Only card allowed in carousel")

            tail_text = self.get_tail_from_element(child)
            self.parse_text(graph, tail_text)

        if len(self._cards) == 0:
            raise ParserException("No cards found in in carousel")
