# Generated by Django 4.1.3 on 2022-11-24 19:47

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('organization_id',
                 models.CharField(help_text='Organization ID, usually the Accronym', max_length=10, primary_key=True,
                                  serialize=False)),
                ('organization_name', models.CharField(help_text='Organization Name (No Accronym)', max_length=100)),
                ('organization_address',
                 models.CharField(blank=True, help_text='Organization physical address - Optional', max_length=100)),
                ('organization_city',
                 models.CharField(blank=True, help_text='Organization City - Optional', max_length=100)),
                ('organization_country',
                 models.CharField(blank=True, help_text='Organization Country ISO Code - Optional', max_length=2)),
            ],
        ),
        migrations.CreateModel(
            name='Station',
            fields=[
                ('station_id',
                 models.CharField(help_text='Station ID, unique identifier code', max_length=10, primary_key=True,
                                  serialize=False)),
                ('station_name', models.CharField(help_text='Station Name, a human readable name', max_length=100)),
                ('station_lat', models.FloatField(help_text='Station Latitude in decimal degrees')),
                ('station_lon', models.FloatField(help_text='Station Longitude in decimal degrees')),
                ('station_elev',
                 models.FloatField(blank=True, help_text='Station Elevation in meters above sea level - Optional')),
                ('station_location',
                 models.CharField(blank=True, help_text='Station Location - Optional', max_length=100)),
                ('station_year_established',
                 models.IntegerField(blank=True, help_text='Year the station was established - Optional')),
                ('station_organization',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='WebApp.organization')),
            ],
        ),
        migrations.CreateModel(
            name='Measurement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('measurement_date', models.DateField(help_text='Measurement Date')),
                ('measurement_temp', models.FloatField(help_text='Temperature in degrees Celsius')),
                ('measurement_precip', models.FloatField(help_text='Precipitation in millimeters')),
                ('station', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='WebApp.station')),
            ],
        ),
    ]
