# Generated by Django 3.2.8 on 2022-04-14 10:02

import django.core.validators
import edc_model.models.fields.other_charfield
import edc_model.models.validators.date
import edc_protocol.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("effect_subject", "0033_auto_20220405_1936"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="historicalpatienttreatmentday14",
            name="medicines_rx_d14_other",
        ),
        migrations.RemoveField(
            model_name="patienttreatmentday14",
            name="medicines_rx_d14_other",
        ),
        migrations.RemoveField(
            model_name="patienttreatmentday14",
            name="prescribed_d14",
        ),
        migrations.AddField(
            model_name="historicalmedicationadherence",
            name="pill_count_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=5,
                verbose_name="Was a pill count performed",
            ),
        ),
        migrations.AddField(
            model_name="historicalpatienttreatmentday14",
            name="fluconazole_rx_d14",
            field=models.CharField(
                choices=[
                    ("1200_mg_d", "Fluconazole, 1200 mg/d (as per protocol)"),
                    ("OTHER", "Other (specify dose and reason below ...)"),
                    ("N/A", "Not applicable"),
                ],
                default="-",
                help_text="in mg/d",
                max_length=25,
                verbose_name="Fluconazole prescribed on day 14?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalpatienttreatmentday14",
            name="fluconazole_rx_d14_other",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[django.core.validators.MinValueValidator(1)],
                verbose_name="Other Fluconazole dose prescribed:",
            ),
        ),
        migrations.AddField(
            model_name="historicalpatienttreatmentday14",
            name="fluconazole_rx_d14_other_reason",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="Other Fluconazole dose reason:",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="lp_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete 'Lumbar Puncture/CSF' CRF.",
                max_length=15,
                verbose_name="Was a lumbar puncture performed?",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="urinary_lam_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete 'TB Diagnostics' CRF.",
                max_length=15,
                verbose_name="Was a urinary LAM performed?",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="xray_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete 'Chest X-ray' CRF.",
                max_length=15,
                verbose_name="Was an X-ray performed?",
            ),
        ),
        migrations.AddField(
            model_name="medicationadherence",
            name="pill_count_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=5,
                verbose_name="Was a pill count performed",
            ),
        ),
        migrations.AddField(
            model_name="patienttreatmentday14",
            name="fluconazole_rx_d14",
            field=models.CharField(
                choices=[
                    ("1200_mg_d", "Fluconazole, 1200 mg/d (as per protocol)"),
                    ("OTHER", "Other (specify dose and reason below ...)"),
                    ("N/A", "Not applicable"),
                ],
                default="-",
                help_text="in mg/d",
                max_length=25,
                verbose_name="Fluconazole prescribed on day 14?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="patienttreatmentday14",
            name="fluconazole_rx_d14_other",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[django.core.validators.MinValueValidator(1)],
                verbose_name="Other Fluconazole dose prescribed:",
            ),
        ),
        migrations.AddField(
            model_name="patienttreatmentday14",
            name="fluconazole_rx_d14_other_reason",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="Other Fluconazole dose reason:",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="lp_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete 'Lumbar Puncture/CSF' CRF.",
                max_length=15,
                verbose_name="Was a lumbar puncture performed?",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="urinary_lam_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete 'TB Diagnostics' CRF.",
                max_length=15,
                verbose_name="Was a urinary LAM performed?",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="xray_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete 'Chest X-ray' CRF.",
                max_length=15,
                verbose_name="Was an X-ray performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalpatienthistory",
            name="fluconazole_dose",
            field=models.CharField(
                choices=[
                    ("1200_mg_d", "Fluconazole, 1200 mg/d"),
                    ("800_mg_d", "Fluconazole, 800 mg/d"),
                    ("OTHER", "Other (specify dose and reason below ...)"),
                    ("N/A", "Not applicable"),
                ],
                help_text="in mg/d",
                max_length=25,
                verbose_name="If YES, Fluconazole dose (if taken < 1 week prior to randomisation):",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectvisit",
            name="last_alive_date",
            field=models.DateField(
                blank=True,
                help_text="Will be validated on the Death report",
                null=True,
                validators=[
                    edc_protocol.validators.date_not_before_study_start,
                    edc_model.models.validators.date.date_not_future,
                ],
                verbose_name="Date participant last known alive",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectvisit",
            name="survival_status",
            field=models.CharField(
                choices=[("alive", "Alive"), ("dead", "Deceased"), ("unknown", "Unknown")],
                default="alive",
                help_text="If YES, submit Death report",
                max_length=10,
                null=True,
                verbose_name="Participant's survival status",
            ),
        ),
        migrations.AlterField(
            model_name="patienthistory",
            name="fluconazole_dose",
            field=models.CharField(
                choices=[
                    ("1200_mg_d", "Fluconazole, 1200 mg/d"),
                    ("800_mg_d", "Fluconazole, 800 mg/d"),
                    ("OTHER", "Other (specify dose and reason below ...)"),
                    ("N/A", "Not applicable"),
                ],
                help_text="in mg/d",
                max_length=25,
                verbose_name="If YES, Fluconazole dose (if taken < 1 week prior to randomisation):",
            ),
        ),
        migrations.AlterField(
            model_name="subjectvisit",
            name="last_alive_date",
            field=models.DateField(
                blank=True,
                help_text="Will be validated on the Death report",
                null=True,
                validators=[
                    edc_protocol.validators.date_not_before_study_start,
                    edc_model.models.validators.date.date_not_future,
                ],
                verbose_name="Date participant last known alive",
            ),
        ),
        migrations.AlterField(
            model_name="subjectvisit",
            name="survival_status",
            field=models.CharField(
                choices=[("alive", "Alive"), ("dead", "Deceased"), ("unknown", "Unknown")],
                default="alive",
                help_text="If YES, submit Death report",
                max_length=10,
                null=True,
                verbose_name="Participant's survival status",
            ),
        ),
    ]
