import copy

from deploy_config_generator.utils import yaml_dump
from deploy_config_generator.output import kube_common


class OutputPlugin(kube_common.OutputPlugin):

    NAME = 'kube_servicemonitor'
    DESCR = 'Kubernetes ServiceMonitor output plugin'
    FILE_EXT = '.yaml'

    DEFAULT_CONFIG = {
        'fields': {
            'kube_servicemonitors': dict(
                metadata=dict(
                    type='dict',
                    required=True,
                    fields=copy.deepcopy(kube_common.METADATA_FIELD_SPEC),
                ),
                spec=dict(
                    type='dict',
                    required=True,
                    fields=dict(
                        endpoints=dict(
                            type='list',
                            subtype='dict',
                            fields=dict(
                                basic_auth=dict(
                                    type='dict',
                                    fields=dict(
                                        password=dict(
                                            type='dict',
                                            fields=dict(
                                                key=dict(
                                                    type='str',
                                                    required=True,
                                                ),
                                                name=dict(
                                                    type='str',
                                                ),
                                                optional=dict(
                                                    type='bool',
                                                ),
                                            ),
                                        ),
                                        username=dict(
                                            type='dict',
                                            fields=dict(
                                                key=dict(
                                                    type='str',
                                                    required=True,
                                                ),
                                                name=dict(
                                                    type='str',
                                                ),
                                                optional=dict(
                                                    type='bool',
                                                ),
                                            ),
                                        ),
                                    ),
                                ),
                                bearer_token_file=dict(
                                    type='str',
                                ),
                                bearer_token_secret=dict(
                                    type='dict',
                                    fields=dict(
                                        key=dict(
                                            type='str',
                                            required=True,
                                        ),
                                        name=dict(
                                            type='str',
                                        ),
                                        optional=dict(
                                            type='bool',
                                        ),
                                    ),
                                ),
                                honor_labels=dict(
                                    type='bool',
                                ),
                                honor_timestamps=dict(
                                    type='bool',
                                ),
                                interval=dict(
                                    type='str',
                                ),
                                metric_relabelings=dict(
                                    type='list',
                                    subtype='dict',
                                    fields=dict(
                                        action=dict(
                                            type='str',
                                        ),
                                        modulus=dict(
                                            type='int',
                                        ),
                                        regex=dict(
                                            type='str',
                                        ),
                                        replacement=dict(
                                            type='str',
                                        ),
                                        separator=dict(
                                            type='str',
                                        ),
                                        source_labels=dict(
                                            type='list',
                                            subtype='str'
                                        ),
                                        target_label=dict(
                                            type='str',
                                        )
                                    ),
                                ),
                                params=dict(
                                    type='dict',
                                    fields=dict(
                                        additional_properties=dict(
                                            type='list',
                                            subtype='str',
                                        )
                                    )
                                ),
                                path=dict(
                                    type='str',
                                ),
                                port=dict(
                                    type='str',
                                ),
                                proxy_url=dict(
                                    type='str',
                                ),
                                relabelings=dict(
                                    type='list',
                                    subtype='dict',
                                    fields=dict(
                                        action=dict(
                                            type='str',
                                        ),
                                        modulus=dict(
                                            type='int',
                                        ),
                                        regex=dict(
                                            type='str',
                                        ),
                                        replacement=dict(
                                            type='str',
                                        ),
                                        separator=dict(
                                            type='str',
                                        ),
                                        source_labels=dict(
                                            type='list',
                                            subtype='str'
                                        ),
                                        target_label=dict(
                                            type='str',
                                        )
                                    ),
                                ),
                                scheme=dict(
                                    type='str',
                                ),
                                scrape_timeout=dict(
                                    type='string',
                                ),
                                target_port=dict(
                                    # No type specified, because this can be 'int' or 'str', and this tool
                                    # doesn't currently support setting multiple allowed types
                                ),
                                tls_config=dict(
                                    type='dict',
                                    fields=dict(
                                        ca=dict(
                                            type='dict',
                                            fields=dict(
                                                config_map=dict(
                                                    type='dict',
                                                    fields=dict(
                                                        key=dict(
                                                            type='str',
                                                            required=True,
                                                        ),
                                                        name=dict(
                                                            type='str',
                                                        ),
                                                        optional=dict(
                                                            type='bool',
                                                        ),
                                                    ),
                                                ),
                                                secret=dict(
                                                    type='dict',
                                                    fields=dict(
                                                        key=dict(
                                                            type='str',
                                                            required=True,
                                                        ),
                                                        name=dict(
                                                            type='str',
                                                        ),
                                                        optional=dict(
                                                            type='bool',
                                                        ),
                                                    ),
                                                ),
                                            ),
                                        ),
                                        ca_file=dict(
                                            type='str'
                                        ),
                                        cert=dict(
                                            type='dict',
                                            fields=dict(
                                                config_map=dict(
                                                    type='dict',
                                                    fields=dict(
                                                        key=dict(
                                                            type='str',
                                                            required=True,
                                                        ),
                                                        name=dict(
                                                            type='str',
                                                        ),
                                                        optional=dict(
                                                            type='bool',
                                                        ),
                                                    ),
                                                ),
                                                secret=dict(
                                                    type='dict',
                                                    fields=dict(
                                                        key=dict(
                                                            type='str',
                                                            required=True,
                                                        ),
                                                        name=dict(
                                                            type='str',
                                                        ),
                                                        optional=dict(
                                                            type='bool',
                                                        ),
                                                    ),
                                                ),
                                            ),
                                        ),
                                        cert_file=dict(
                                            type='string',
                                        ),
                                        insecure_skip_verify=dict(
                                            type='bool',
                                        ),
                                        key_file=dict(
                                            type='str',
                                        ),
                                        key_secret=dict(
                                            type='dict',
                                            fields=dict(
                                                key=dict(
                                                    type='str',
                                                    required=True,
                                                ),
                                                name=dict(
                                                    type='str',
                                                ),
                                                optional=dict(
                                                    type='bool',
                                                ),
                                            ),
                                        ),
                                        server_name=dict(
                                            type='str',
                                        ),
                                    ),
                                ),
                            ),
                        ),
                        job_label=dict(
                            type='str',
                        ),
                        namespace_selector=dict(
                            type='dict',
                            fields=dict(
                                any=dict(
                                    type='bool'
                                ),
                                match_names=dict(
                                    type='list',
                                    subtype='str',
                                ),
                            ),
                        ),
                        pod_target_labels=dict(
                            type='list',
                            subtype='str',
                        ),
                        sample_limit=dict(
                            type='int',
                        ),
                        selector=dict(
                            type='dict',
                            required=True,
                            fields=copy.deepcopy(kube_common.SELECTOR_FIELD_SPEC),
                        ),
                        target_labels=dict(
                            type='list',
                            subtype='str',
                        ),
                        target_limit=dict(
                            type='int'
                        )
                    ),
                ),
            ),
        }
    }

    def generate_output(self, app_vars):
        # Basic structure
        data = {
            'apiVersion': 'monitoring.coreos.com/v1',
            'kind': 'ServiceMonitor',
            'spec': dict(),
        }
        data['metadata'] = self.build_metadata(app_vars['APP']['metadata'])
        data['spec'] = self.build_generic(app_vars['APP']['spec'], self._plugin_config['fields']['kube_servicemonitors']['spec']['fields'])

        data = self._template.render_template(data, app_vars)
        output = yaml_dump(data)
        return (output, self.get_output_filename_suffix(data))
