from enum import Enum
from types import TracebackType
from typing import Any
from typing import Callable
from typing import ClassVar
from typing import Sequence
from typing import TypeVar

from .capture import Captured
from .formatter.base import Formatter
from .model import Tag
from .tag_expression import TagExpression

class Status(Enum):

	untested = 0
	skipped = 1
	passed = 2
	failed = 3
	undefined = 4
	executing = 5

	@classmethod
	def from_name(cls, name: str) -> Status: ...


class Argument:

	original: str
	value: Any
	name: str|None
	start: int
	end: int

	def __init__(self, start: int, end: int, original: str, value: Any, name: str = ...): ...


class FileLocation:

	T = TypeVar("T", bound="FileLocation")

	filename: str
	line: int

	def __init__(self, filename: str, line: int): ...
	def __eq__(self, other: Any) -> bool: ...
	def __ne__(self, other: Any) -> bool: ...
	def __le__(self, other: str|FileLocation) -> bool: ...
	def __gt__(self, other: str|FileLocation) -> bool: ...
	def __ge__(self, other: str|FileLocation) -> bool: ...
	def __str__(self) -> str: ...

	def get(self) -> str: ...
	def abspath(self) -> str: ...
	def basename(self) -> str: ...
	def dirname(self) -> str: ...
	def relpath(self, start: str = ...) -> str: ...
	def exists(self) -> str: ...

	@classmethod
	def for_function(cls: type[T], func: Callable[..., Any], curdir: str = ...) -> T: ...


class BasicStatement:

	location: FileLocation
	keyword: str
	name: str
	captured: Captured
	exception: Exception|None
	exc_traceback: TracebackType|None
	error_message: str|None

	@property
	def filename(self) -> str: ...

	@property
	def line(self) -> int: ...

	def __init__(self, filename: str, line: int, keyword: str, name: str): ...
	def __hash__(self) -> int: ...
	def __eq__(self, other: Any) -> bool: ...
	def __ne__(self, other: Any) -> bool: ...
	def __lt__(self, other: BasicStatement) -> bool: ...
	def __le__(self, other: BasicStatement) -> bool: ...
	def __gt__(self, other: BasicStatement) -> bool: ...
	def __ge__(self, other: BasicStatement) -> bool: ...

	def reset(self) -> None: ...
	def store_exception_context(self, exception: Exception) -> None: ...


class TagStatement(BasicStatement):

	tags: Sequence[Tag]

	def __init__(self, filename: str, line: int, keyword: str, name: str, tags: Sequence[Tag]): ...
	def should_run_with_tags(self, tag_expression: TagExpression) -> bool: ...


class TagAndStatusStatement(BasicStatement):

	final_status: ClassVar[tuple[Status]]

	tags: Sequence[Tag]
	should_skip: bool
	skip_reason: str|None

	@property
	def status(self) -> Status: ...

	def __init__(self, filename: str, line: int, keyword: str, name: str, tags: Sequence[Tag]): ...

	def should_run_with_tags(self, tag_expression: TagExpression) -> bool: ...
	def set_status(self, value: Status) -> None: ...
	def clear_status(self) -> None: ...
	def reset(self) -> None: ...
	def compute_status(self) -> Status: ...


class Replayable:

	def replay(self, formatter: Formatter) -> None: ...
