from typing import IO
from typing import ClassVar
from typing import Protocol

from ..matchers import Match
from ..model import Background
from ..model import Configuration
from ..model import Feature
from ..model import Scenario
from ..model import Step

class StreamOpener:

	default_encoding: ClassVar[str]

	name: str
	stream: IO[str]
	encoding: str
	should_close_stream = bool

	def __init__(
		self,
		filename: str = ...,
		stream: IO[str] = ...,
		encoding: str = ...,
	): ...

	@staticmethod
	def ensure_dir_exists(directory: str) -> None: ...

	@classmethod
	def ensure_stream_with_encoder(cls, stream: IO[str], encoding: str = ...) -> IO[str]: ...

	def open(self) -> IO[str]: ...
	def close(self) -> bool: ...


class Formatter(Protocol):

	name: str
	description: str

	def __init__(self, stream_opener: StreamOpener, config: Configuration): ...

	@property
	def stdout_mode(self) -> bool: ...

	def open(self) -> IO[str]: ...
	def uri(self, uri: str) -> None: ...
	def feature(self, feature: Feature) -> None: ...
	def background(self, background: Background) -> None: ...
	def scenario(self, scenario: Scenario) -> None: ...
	def step(self, step: Step) -> None: ...
	def match(self, match: Match) -> None: ...
	def result(self, step: Step) -> None: ...
	def eof(self) -> None: ...
	def close(self) -> None: ...
	def close_stream(self) -> None: ...
