from typing import Any, Dict, TypeVar

from django.db.models import Model

from rest_framework.generics import UsesQuerySet
from rest_framework.request import Request
from rest_framework.response import Response
from rest_framework.serializers import BaseSerializer

_MT = TypeVar("_MT", bound=Model)

class CreateModelMixin:
    def create(self, request: Request, *args: Any, **kwargs: Any) -> Response: ...
    def perform_create(self: UsesQuerySet[_MT], serializer: BaseSerializer[_MT]) -> None: ...
    def get_success_headers(self, data: Any) -> Dict[str, str]: ...

class ListModelMixin:
    def list(self, request: Request, *args: Any, **kwargs: Any) -> Response: ...

class RetrieveModelMixin:
    def retrieve(self, request: Request, *args: Any, **kwargs: Any) -> Response: ...

class UpdateModelMixin:
    def update(self, request: Request, *args: Any, **kwargs: Any) -> Response: ...
    def perform_update(self: UsesQuerySet[_MT], serializer: BaseSerializer[_MT]) -> None: ...
    def partial_update(self, request: Request, *args: Any, **kwargs: Any) -> Response: ...

class DestroyModelMixin:
    def destroy(self, request: Request, *args: Any, **kwargs: Any) -> Response: ...
    def perform_destroy(self: UsesQuerySet[_MT], instance: _MT) -> None: ...
