from typing import Any, Callable, Dict, List, Mapping, Optional, Sequence, Tuple, Union

from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps
from typing_extensions import Literal

from .base import Operation

class SeparateDatabaseAndState(Operation):
    database_operations: Sequence[Operation] = ...
    state_operations: Sequence[Operation] = ...
    def __init__(
        self, database_operations: Sequence[Operation] = ..., state_operations: Sequence[Operation] = ...
    ) -> None: ...

class RunSQL(Operation):
    noop: Literal[""] = ...
    sql: Union[str, List[str], Tuple[str, ...]] = ...
    reverse_sql: Optional[Union[str, List[str], Tuple[str, ...]]] = ...
    state_operations: Sequence[Operation] = ...
    hints: Mapping[str, Any] = ...
    def __init__(
        self,
        sql: Union[str, List[str], Tuple[str, ...]],
        reverse_sql: Optional[Union[str, List[str], Tuple[str, ...]]] = ...,
        state_operations: Sequence[Operation] = ...,
        hints: Optional[Mapping[str, Any]] = ...,
        elidable: bool = ...,
    ) -> None: ...

class RunPython(Operation):
    code: Callable[[StateApps, BaseDatabaseSchemaEditor], None] = ...
    reverse_code: Optional[Callable[[StateApps, BaseDatabaseSchemaEditor], None]] = ...
    hints: Optional[Dict[str, Any]] = ...
    def __init__(
        self,
        code: Callable[[StateApps, BaseDatabaseSchemaEditor], None],
        reverse_code: Optional[Callable[[StateApps, BaseDatabaseSchemaEditor], None]] = ...,
        atomic: Optional[bool] = ...,
        hints: Optional[Dict[str, Any]] = ...,
        elidable: bool = ...,
    ) -> None: ...
    @staticmethod
    def noop(apps: StateApps, schema_editor: BaseDatabaseSchemaEditor) -> None: ...
