/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.google.common.annotations.VisibleForTesting;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.cli.GridNodeCliOptions;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.internal.utils.configuration.json.NodeJsonConfiguration;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.net.NetworkUtils;

public class GridNodeConfiguration
extends GridConfiguration {
    public static final String DEFAULT_NODE_CONFIG_FILE = "org/openqa/grid/common/defaults/DefaultNodeWebDriver.json";
    public static final String CONFIG_UUID_CAPABILITY = "server:CONFIG_UUID";
    private static NodeJsonConfiguration DEFAULT_CONFIG_FROM_JSON = NodeJsonConfiguration.loadFromResourceOrFile("org/openqa/grid/common/defaults/DefaultNodeWebDriver.json");
    @VisibleForTesting
    static final String ROLE = "node";
    private HostPort hubHostPort;
    public String nodeConfigFile;
    public String remoteHost;
    @Deprecated
    private Object configuration;
    public String hubHost;
    public Integer hubPort;
    public String id;
    public List<MutableCapabilities> capabilities;
    public Integer downPollingLimit;
    public String hub;
    public Integer nodePolling;
    public Integer nodeStatusCheckTimeout;
    public String proxy;
    public Boolean register;
    public Integer registerCycle;
    public Integer unregisterIfStillDownAfter;
    public boolean enablePlatformVerification;

    public GridNodeConfiguration() {
        this(DEFAULT_CONFIG_FROM_JSON);
    }

    public GridNodeConfiguration(NodeJsonConfiguration jsonConfig) {
        super(jsonConfig);
        this.role = ROLE;
        this.capabilities = new ArrayList<MutableCapabilities>((Collection)Optional.ofNullable(jsonConfig.getCapabilities()).orElse(DEFAULT_CONFIG_FROM_JSON.getCapabilities()));
        this.maxSession = Optional.ofNullable(jsonConfig.getMaxSession()).orElse(DEFAULT_CONFIG_FROM_JSON.getMaxSession());
        this.register = Optional.ofNullable(jsonConfig.getRegister()).orElse(DEFAULT_CONFIG_FROM_JSON.getRegister());
        this.registerCycle = Optional.ofNullable(jsonConfig.getRegisterCycle()).orElse(DEFAULT_CONFIG_FROM_JSON.getRegisterCycle());
        this.nodeStatusCheckTimeout = Optional.ofNullable(jsonConfig.getNodeStatusCheckTimeout()).orElse(DEFAULT_CONFIG_FROM_JSON.getNodeStatusCheckTimeout());
        this.nodePolling = Optional.ofNullable(jsonConfig.getNodePolling()).orElse(DEFAULT_CONFIG_FROM_JSON.getNodePolling());
        this.unregisterIfStillDownAfter = Optional.ofNullable(jsonConfig.getUnregisterIfStillDownAfter()).orElse(DEFAULT_CONFIG_FROM_JSON.getUnregisterIfStillDownAfter());
        this.downPollingLimit = Optional.ofNullable(jsonConfig.getDownPollingLimit()).orElse(DEFAULT_CONFIG_FROM_JSON.getDownPollingLimit());
        this.proxy = Optional.ofNullable(jsonConfig.getProxy()).orElse(DEFAULT_CONFIG_FROM_JSON.getProxy());
        this.enablePlatformVerification = jsonConfig.isEnablePlatformVerification();
        if (jsonConfig.getHub() != null) {
            this.hub = jsonConfig.getHub();
        } else if (jsonConfig.getHubHost() != null && jsonConfig.getHubPort() != null) {
            this.hubHost = Optional.ofNullable(jsonConfig.getHubHost()).orElse(DEFAULT_CONFIG_FROM_JSON.getHubHost());
            this.hubPort = Optional.ofNullable(jsonConfig.getHubPort()).orElse(DEFAULT_CONFIG_FROM_JSON.getHubPort());
        } else {
            this.hub = DEFAULT_CONFIG_FROM_JSON.getHub();
        }
    }

    public GridNodeConfiguration(GridNodeCliOptions cliConfig) {
        this(Optional.ofNullable(cliConfig.getConfigFile()).map(NodeJsonConfiguration::loadFromResourceOrFile).orElse(DEFAULT_CONFIG_FROM_JSON));
        super.merge(cliConfig.getCommonGridOptions());
        Optional.ofNullable(cliConfig.getCapabilities()).ifPresent(v -> {
            this.capabilities = v;
        });
        Optional.ofNullable(cliConfig.getRegister()).ifPresent(v -> {
            this.register = v;
        });
        Optional.ofNullable(cliConfig.getRegisterCycle()).ifPresent(v -> {
            this.registerCycle = v;
        });
        Optional.ofNullable(cliConfig.getNodeStatusCheckTimeout()).ifPresent(v -> {
            this.nodeStatusCheckTimeout = v;
        });
        Optional.ofNullable(cliConfig.getNodePolling()).ifPresent(v -> {
            this.nodePolling = v;
        });
        Optional.ofNullable(cliConfig.getUnregisterIfStillDownAfter()).ifPresent(v -> {
            this.unregisterIfStillDownAfter = v;
        });
        Optional.ofNullable(cliConfig.getDownPollingLimit()).ifPresent(v -> {
            this.downPollingLimit = v;
        });
        Optional.ofNullable(cliConfig.getProxy()).ifPresent(v -> {
            this.proxy = v;
        });
        Optional.ofNullable(cliConfig.getEnablePlatformVerification()).ifPresent(v -> {
            this.enablePlatformVerification = v;
        });
        Optional.ofNullable(cliConfig.getId()).ifPresent(v -> {
            this.id = v;
        });
        if (cliConfig.getHub() != null) {
            this.hub = cliConfig.getHub();
        } else if (cliConfig.getHubHost() != null || cliConfig.getHubPort() != null) {
            HostPort defaultHubHostPort = this.getHubHostPort();
            this.hub = null;
            this.hubHost = Optional.ofNullable(cliConfig.getHubHost()).orElse(defaultHubHostPort.host);
            this.hubPort = Optional.ofNullable(cliConfig.getHubPort()).orElse(defaultHubHostPort.port);
        }
    }

    public String getHubHost() {
        return this.getHubHostPort().host;
    }

    public Integer getHubPort() {
        return this.getHubHostPort().port;
    }

    private HostPort getHubHostPort() {
        if (this.hub != null) {
            try {
                URL u = new URL(this.hub);
                this.hubHostPort = new HostPort(u.getHost(), u.getPort());
            }
            catch (MalformedURLException mURLe) {
                throw new RuntimeException("-hub must be a valid url: " + this.hub, mURLe);
            }
        } else if (this.hubHost != null || this.hubPort != null) {
            this.hubHostPort = new HostPort(Optional.ofNullable(this.hubHost).orElse(DEFAULT_CONFIG_FROM_JSON.getHubHost()), Optional.ofNullable(this.hubPort).orElse(DEFAULT_CONFIG_FROM_JSON.getHubPort()));
        }
        return this.hubHostPort;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (this.host == null) {
                this.host = "localhost";
            }
            if (this.port == null) {
                this.port = 5555;
            }
            this.remoteHost = "http://" + this.host + ":" + this.port;
        }
        return this.remoteHost;
    }

    public void merge(GridNodeConfiguration other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        if (this.isMergeAble(List.class, other.capabilities, this.capabilities)) {
            this.capabilities = other.capabilities;
        }
        if (this.isMergeAble(Integer.class, other.downPollingLimit, this.downPollingLimit)) {
            this.downPollingLimit = other.downPollingLimit;
        }
        if (this.isMergeAble(String.class, other.hub, this.hub)) {
            this.hub = other.hub;
        }
        if (this.isMergeAble(String.class, other.hubHost, this.hubHost)) {
            this.hubHost = other.hubHost;
        }
        if (this.isMergeAble(Integer.class, other.hubPort, this.hubPort)) {
            this.hubPort = other.hubPort;
        }
        if (this.isMergeAble(String.class, other.id, this.id)) {
            this.id = other.id;
        }
        if (this.isMergeAble(Integer.class, other.nodePolling, this.nodePolling)) {
            this.nodePolling = other.nodePolling;
        }
        if (this.isMergeAble(Integer.class, other.nodeStatusCheckTimeout, this.nodeStatusCheckTimeout)) {
            this.nodeStatusCheckTimeout = other.nodeStatusCheckTimeout;
        }
        if (this.isMergeAble(String.class, other.proxy, this.proxy)) {
            this.proxy = other.proxy;
        }
        if (this.isMergeAble(Boolean.class, other.register, this.register)) {
            this.register = other.register;
        }
        if (this.isMergeAble(Integer.class, other.registerCycle, this.registerCycle)) {
            this.registerCycle = other.registerCycle;
        }
        if (this.isMergeAble(String.class, other.remoteHost, this.remoteHost)) {
            this.remoteHost = other.remoteHost;
        }
        if (this.isMergeAble(Integer.class, other.unregisterIfStillDownAfter, this.unregisterIfStillDownAfter)) {
            this.unregisterIfStillDownAfter = other.unregisterIfStillDownAfter;
        }
    }

    @Override
    protected void serializeFields(Map<String, Object> appendTo) {
        super.serializeFields(appendTo);
        appendTo.put("remoteHost", this.remoteHost);
        appendTo.put("hubHost", this.hubHost);
        appendTo.put("hubPort", this.hubPort);
        appendTo.put("id", this.id);
        appendTo.put("capabilities", this.capabilities);
        appendTo.put("downPollingLimit", this.downPollingLimit);
        appendTo.put("hub", this.hub);
        appendTo.put("nodePolling", this.nodePolling);
        appendTo.put("nodeStatusCheckTimeout", this.nodeStatusCheckTimeout);
        appendTo.put("proxy", this.proxy);
        appendTo.put("register", this.register);
        appendTo.put("registerCycle", this.registerCycle);
        appendTo.put("unregisterIfStillDownAfter", this.unregisterIfStillDownAfter);
        appendTo.put("enablePlatformVerification", this.enablePlatformVerification);
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "capabilities", this.capabilities));
        sb.append((CharSequence)this.toString(format, "downPollingLimit", this.downPollingLimit));
        sb.append((CharSequence)this.toString(format, "hub", this.hub));
        sb.append((CharSequence)this.toString(format, "id", this.id));
        sb.append((CharSequence)this.toString(format, "hubHost", this.hubHost));
        sb.append((CharSequence)this.toString(format, "hubPort", this.hubPort));
        sb.append((CharSequence)this.toString(format, "nodeConfigFile", this.nodeConfigFile));
        sb.append((CharSequence)this.toString(format, "nodePolling", this.nodePolling));
        sb.append((CharSequence)this.toString(format, "nodeStatusCheckTimeout", this.nodeStatusCheckTimeout));
        sb.append((CharSequence)this.toString(format, "proxy", this.proxy));
        sb.append((CharSequence)this.toString(format, "register", this.register));
        sb.append((CharSequence)this.toString(format, "registerCycle", this.registerCycle));
        sb.append((CharSequence)this.toString(format, "remoteHost", this.remoteHost));
        sb.append((CharSequence)this.toString(format, "unregisterIfStillDownAfter", this.unregisterIfStillDownAfter));
        return sb.toString();
    }

    public static GridNodeConfiguration loadFromJSON(String filePath) {
        return GridNodeConfiguration.loadFromJSON(StandaloneConfiguration.loadJsonFromResourceOrFile(filePath));
    }

    public static GridNodeConfiguration loadFromJSON(JsonInput jsonInput) {
        try {
            GridNodeConfiguration fromJson = new GridNodeConfiguration(NodeJsonConfiguration.loadFromJson(jsonInput));
            GridNodeConfiguration result = new GridNodeConfiguration();
            result.merge(fromJson);
            if (fromJson.getHubHostPort() != null) {
                result.hub = String.format("http://%s:%s", fromJson.getHubHostPort(), fromJson.getHubPort());
            }
            if (fromJson.hub != null) {
                result.hub = fromJson.hub;
            }
            if (fromJson.hubHost != null) {
                result.hubHost = fromJson.hubHost;
            }
            if (fromJson.hubPort != null) {
                result.hubPort = fromJson.hubPort;
            }
            if (fromJson.host != null) {
                result.host = fromJson.host;
            }
            if (fromJson.port != null) {
                result.port = fromJson.port;
            }
            return result;
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public void fixUpCapabilities() {
        if (this.capabilities == null) {
            return;
        }
        Platform current = Platform.getCurrent();
        this.capabilities = this.capabilities.stream().peek(cap -> cap.setCapability("platform", Optional.ofNullable(cap.getCapability("platformName")).orElse(Optional.ofNullable(cap.getCapability("platform")).orElse((Object)current)))).peek(cap -> cap.setCapability("platformName", Optional.ofNullable(cap.getCapability("platformName")).orElse(Optional.ofNullable(cap.getCapability("platform")).orElse((Object)current)))).peek(cap -> cap.setCapability("seleniumProtocol", Optional.ofNullable(cap.getCapability("seleniumProtocol")).orElse(SeleniumProtocol.WebDriver.toString()))).peek(cap -> cap.setCapability(CONFIG_UUID_CAPABILITY, UUID.randomUUID().toString())).collect(Collectors.toList());
    }

    public void dropCapabilitiesThatDoesNotMatchCurrentPlatform() {
        if (!this.enablePlatformVerification) {
            return;
        }
        if (this.capabilities == null) {
            return;
        }
        Platform current = Platform.getCurrent();
        Platform currentFamily = Optional.ofNullable(current.family()).orElse(current);
        this.capabilities = this.capabilities.stream().filter(cap -> cap.getPlatform() != null && (cap.getPlatform() == Platform.ANY || cap.getPlatform().is(currentFamily))).collect(Collectors.toList());
    }

    public void fixUpHost() {
        NetworkUtils util = new NetworkUtils();
        if (this.host == null || "ip".equalsIgnoreCase(this.host)) {
            this.host = util.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        } else if ("host".equalsIgnoreCase(this.host)) {
            this.host = util.getIp4NonLoopbackAddressOfThisMachine().getHostName();
        }
    }

    private static class HostPort {
        final String host;
        final int port;

        HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }
}

